/*
 * gconf keys which relate with iiim
 */
#ifndef _IIIM_PROPERTIES_KEYS_H
#define _IIIM_PROPERTIES_KEYS_H

#include <glib.h>
#include <X11/Xlib.h>

#define IIIM_KEY_DIR "/desktop/input_methods"
#define IIIM_GNOME_KEY_DIR "/desktop/gnome/input_methods"
#define IIIM_GIMLET_KEY_DIR "/apps/gimlet/preference"

/** General properties
 *
 *	format:
 *		KEY_ENAGLE_IM : Boolean
 *		KEY_STATUS_DISPLAY : Boolean
 *		KEY_STATUS_PLACEMENT : String
 *			"DESKTOP_DEFAULT", "PANEL" or "ATTACH_FRAME"
 */
#define KEY_ENABLE_IM IIIM_KEY_DIR "/enable"
#define KEY_ENABLE_IM_GIMLET IIIM_GNOME_KEY_DIR "/support"
#define KEY_STATUS_DISPLAY IIIM_KEY_DIR "/status"
#define KEY_STATUS_DISPLAY_GIMLET IIIM_GNOME_KEY_DIR "/status"
#define KEY_STATUS_PLACEMENT IIIM_KEY_DIR "/status_placement"
#define KEY_STATUS_PLACEMENT_GIMLET IIIM_GNOME_KEY_DIR "/status_placement"
#define KEY_STATUS_STYLE_GIMLET "/desktop/gnome/interface/gtk-im-status-style"
#define KEY_INPUT_LANG_POLICY_GIMLET IIIM_GIMLET_KEY_DIR "/input_language_policy"
#define KEY_CONVERSION_ON_GIMLET IIIM_GIMLET_KEY_DIR "/conversion_on_start"

/**
 * Languages / Scrips properties
 *
 *	format:
 *		KEY_LANG_TO_USE : String
 *			<lang id>,<lang id>...
 *		KEY_ENGINE_FOR_LANG : String
 *			<lang id>:<engine id><hotkeys>,<engine id><>|<lang id>:...
 */
/* string representation lang_to_use should be removed ---- TODO */
#define KEY_LANG_TO_USE_LIST IIIM_KEY_DIR "/languages_use"
#define KEY_LANG_TO_SAVE_LIST IIIM_KEY_DIR "/languages_save"

/**
 *  Trigger keys properties
 *
 *	format:
 *		KEY_TRIGGER : String
 *		KEY_USER_HOTKEYS_TO_DEACTIVATE : String
 *		KEY_USE_SAME_KEYS_TO_DEACTIVATE : Boolean
 *		KEY_TRIGGER_TO_DEACTIVATE : String
 */
#define KEY_TRIGGER IIIM_KEY_DIR "/trigger_keys"
#define KEY_USE_HOTKEYS_TO_DEACTIVATE IIIM_KEY_DIR "/use_trigger_keys_to_deactivate"
#define KEY_USE_SAME_KEYS_TO_DEACTIVATE IIIM_KEY_DIR "/use_same_keys_to_deactivate"
#define KEY_TRIGGER_TO_DEACTIVATE IIIM_KEY_DIR "/deactivate_trigger_keys"

/**
 * Misc properites
 *
 *	format:
 *		KEY_LANG_SWITCH_POLICY : String
 *			"PER_IC" or "PER_DESKTOP" 
 *		KEY_ON_OFF_POLICY : String
 *			"ACTIVATE" or "NOT_CHANGE"
 *		KEY_ENABLE_LOOKUP : Boolean
 *		KEY_ENABLE_LANG_LIST : Boolean
 *		KEY_LANG_LIST_PLACEMENT : String
 *			"INPUT_LOCATION", "PANEL", "STATUS"
 *		KEY_LANG_LIST_HOTKEY : String
 *			"<Key><Key>...
 *		KEY_ENABLE_MISC_HOTKEY : Boolean
 *		KEY_CYCLE_LANG_HOTKEY : String
 *		KEY_REVERSE_CYCLE_LANG_HOTKEY : String
 *
 */
#define KEY_LANG_SWITCH_POLICY IIIM_KEY_DIR "/lang_switch_policy"
#define KEY_ON_OFF_POLICY IIIM_KEY_DIR  "/on_off_policy"
#define KEY_ENABLE_LOOKUP IIIM_KEY_DIR "/lookup"
#define KEY_ENABLE_LANG_LIST IIIM_KEY_DIR "/lang_list"
#define KEY_LANG_LIST_PLACEMENT IIIM_KEY_DIR "/lang_list_placement"
#define KEY_LANG_LIST_HOTKEY IIIM_KEY_DIR "/lang_list_hotkey"
#define KEY_ENABLE_MISC_HOTKEY IIIM_KEY_DIR "/misc_hotkey"
#define KEY_CYCLE_LANG_HOTKEY IIIM_KEY_DIR "/cycle_lang_hotkey"
#define KEY_REVERSE_CYCLE_LANG_HOTKEY IIIM_KEY_DIR "/reverse_cycle_lang_hotkey"

#endif
