/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.OpenDialogAction;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class AddExternalJarAction
extends OpenDialogAction {
    public AddExternalJarAction(IClasspathViewer viewer, String dialogSettingsPrefix) {
        super(ActionMessages.AddExternalJar_Add_E_xternal_JARs_1, viewer, dialogSettingsPrefix);
    }

    public void run() {
        String lastUsedPath = this.getDialogSetting("LAST_PATH_SETTING");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.getShell(), 2);
        dialog.setText(ActionMessages.AddExternalJar_Jar_Selection_3);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        ArrayList<IRuntimeClasspathEntry> list = new ArrayList<IRuntimeClasspathEntry>();
        IPath path = null;
        int i = 0;
        while (i < nChosen) {
            path = filterPath.append(fileNames[i]).makeAbsolute();
            if (path.toFile().exists()) {
                list.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.AddExternalJarAction_error_box_title, (String)MessageFormat.format((String)ActionMessages.AddExternalJarAction_error_box_message, (Object[])new String[]{path.makeAbsolute().toOSString()}));
            }
            ++i;
        }
        if (list.size() > 0) {
            this.setDialogSetting("LAST_PATH_SETTING", filterPath.toOSString());
            this.getViewer().addEntries(list.toArray(new IRuntimeClasspathEntry[list.size()]));
        }
    }
}

