/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class JavaDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    private Button fSuspendButton;
    private Button fSuspendOnCompilationErrors;
    private Button fSuspendDuringEvaluations;
    private Button fOpenInspector;
    private Button fPromptUnableToInstallBreakpoint;
    private Combo fSuspendVMorThread;
    private Button fAlertHCRButton;
    private Button fAlertHCRNotSupportedButton;
    private Button fAlertObsoleteButton;
    private Button fPerformHCRWithCompilationErrors;
    private JavaDebugIntegerFieldEditor fTimeoutText;
    private JavaDebugIntegerFieldEditor fConnectionTimeoutText;

    public JavaDebugPreferencePage() {
        this.setPreferenceStore(JDIDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(DebugUIMessages.JavaDebugPreferencePage_description);
    }

    protected Control createContents(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 0, 0, 4);
        new PreferenceLinkArea(composite, 0, "org.eclipse.debug.ui.DebugPreferencePage", DebugUIMessages.JavaDebugPreferencePage_0, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        Group group = SWTFactory.createGroup(composite, DebugUIMessages.JavaDebugPreferencePage_Suspend_Execution_1, 2, 1, 768);
        this.fSuspendButton = SWTFactory.createCheckButton((Composite)group, DebugUIMessages.JavaDebugPreferencePage_Suspend__execution_on_uncaught_exceptions_1, null, false, 2);
        this.fSuspendOnCompilationErrors = SWTFactory.createCheckButton((Composite)group, DebugUIMessages.JavaDebugPreferencePage_Suspend_execution_on_co_mpilation_errors_1, null, false, 2);
        this.fSuspendDuringEvaluations = SWTFactory.createCheckButton((Composite)group, DebugUIMessages.JavaDebugPreferencePage_14, null, false, 2);
        this.fOpenInspector = SWTFactory.createCheckButton((Composite)group, DebugUIMessages.JavaDebugPreferencePage_20, null, false, 2);
        SWTFactory.createLabel((Composite)group, DebugUIMessages.JavaDebugPreferencePage_21, 1);
        this.fSuspendVMorThread = new Combo((Composite)group, 2056);
        this.fSuspendVMorThread.setItems(new String[]{DebugUIMessages.JavaDebugPreferencePage_22, DebugUIMessages.JavaDebugPreferencePage_23});
        group = SWTFactory.createGroup(composite, DebugUIMessages.JavaDebugPreferencePage_Hot_Code_Replace_2, 1, 1, 768);
        this.fAlertHCRButton = SWTFactory.createCheckButton((Composite)group, DebugUIMessages.JavaDebugPreferencePage_Alert_me_when_hot_code_replace_fails_1, null, false, 1);
        this.fAlertHCRNotSupportedButton = SWTFactory.createCheckButton((Composite)group, DebugUIMessages.JavaDebugPreferencePage_Alert_me_when_hot_code_replace_is_not_supported_1, null, false, 1);
        this.fAlertObsoleteButton = SWTFactory.createCheckButton((Composite)group, DebugUIMessages.JavaDebugPreferencePage_Alert_me_when_obsolete_methods_remain_1, null, false, 1);
        this.fPerformHCRWithCompilationErrors = SWTFactory.createCheckButton((Composite)group, DebugUIMessages.JavaDebugPreferencePage_Replace_classfiles_containing_compilation_errors_1, null, false, 1);
        group = SWTFactory.createGroup(composite, DebugUIMessages.JavaDebugPreferencePage_Communication_1, 1, 1, 768);
        Composite space = SWTFactory.createComposite((Composite)group, group.getFont(), 1, 1, 768);
        Preferences coreStore = JDIDebugModel.getPreferences();
        Preferences runtimeStore = JavaRuntime.getPreferences();
        this.fTimeoutText = new JavaDebugIntegerFieldEditor(JDIDebugModel.PREF_REQUEST_TIMEOUT, DebugUIMessages.JavaDebugPreferencePage_Debugger__timeout__2, space);
        this.fTimeoutText.setPage((DialogPage)this);
        this.fTimeoutText.setValidateStrategy(0);
        int minValue = coreStore.getDefaultInt(JDIDebugModel.PREF_REQUEST_TIMEOUT);
        this.fTimeoutText.setValidRange(minValue, Integer.MAX_VALUE);
        this.fTimeoutText.setErrorMessage(MessageFormat.format((String)DebugUIMessages.JavaDebugPreferencePage_Value_must_be_a_valid_integer_greater_than__0__ms_1, (Object[])new Object[]{new Integer(minValue)}));
        this.fTimeoutText.load();
        this.fConnectionTimeoutText = new JavaDebugIntegerFieldEditor(JavaRuntime.PREF_CONNECT_TIMEOUT, DebugUIMessages.JavaDebugPreferencePage__Launch_timeout__ms___1, space);
        this.fConnectionTimeoutText.setPage((DialogPage)this);
        this.fConnectionTimeoutText.setValidateStrategy(0);
        minValue = runtimeStore.getDefaultInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
        this.fConnectionTimeoutText.setValidRange(minValue, Integer.MAX_VALUE);
        this.fConnectionTimeoutText.setErrorMessage(MessageFormat.format((String)DebugUIMessages.JavaDebugPreferencePage_Value_must_be_a_valid_integer_greater_than__0__ms_1, (Object[])new Object[]{new Integer(minValue)}));
        this.fConnectionTimeoutText.load();
        SWTFactory.createVerticalSpacer(composite, 1);
        this.fPromptUnableToInstallBreakpoint = SWTFactory.createCheckButton(composite, DebugUIMessages.JavaDebugPreferencePage_19, null, false, 1);
        this.setValues();
        this.fTimeoutText.setPropertyChangeListener(this);
        this.fConnectionTimeoutText.setPropertyChangeListener(this);
        this.applyDialogFont(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IJavaDebugHelpContextIds.JAVA_DEBUG_PREFERENCE_PAGE);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        Preferences coreStore = JDIDebugModel.getPreferences();
        Preferences runtimeStore = JavaRuntime.getPreferences();
        store.setValue(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS, this.fSuspendButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS, this.fSuspendOnCompilationErrors.getSelection());
        coreStore.setValue(JDIDebugModel.PREF_SUSPEND_FOR_BREAKPOINTS_DURING_EVALUATION, this.fSuspendDuringEvaluations.getSelection());
        int selectionIndex = this.fSuspendVMorThread.getSelectionIndex();
        int policy = 2;
        if (selectionIndex > 0) {
            policy = 1;
        }
        coreStore.setValue(JDIDebugPlugin.PREF_DEFAULT_BREAKPOINT_SUSPEND_POLICY, policy);
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED, this.fAlertHCRButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED, this.fAlertHCRNotSupportedButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS, this.fAlertObsoleteButton.getSelection());
        coreStore.setValue(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS, this.fPerformHCRWithCompilationErrors.getSelection());
        coreStore.setValue(JDIDebugModel.PREF_REQUEST_TIMEOUT, this.fTimeoutText.getIntValue());
        runtimeStore.setValue(JavaRuntime.PREF_CONNECT_TIMEOUT, this.fConnectionTimeoutText.getIntValue());
        store.setValue(IJDIPreferencesConstants.PREF_ALERT_UNABLE_TO_INSTALL_BREAKPOINT, this.fPromptUnableToInstallBreakpoint.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_OPEN_INSPECT_POPUP_ON_EXCEPTION, this.fOpenInspector.getSelection());
        JDIDebugModel.savePreferences();
        JavaRuntime.savePreferences();
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        Preferences coreStore = JDIDebugModel.getPreferences();
        Preferences runtimeStore = JavaRuntime.getPreferences();
        this.fSuspendButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS));
        this.fSuspendOnCompilationErrors.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS));
        this.fSuspendDuringEvaluations.setSelection(coreStore.getDefaultBoolean(JDIDebugModel.PREF_SUSPEND_FOR_BREAKPOINTS_DURING_EVALUATION));
        int value = coreStore.getDefaultInt(JDIDebugPlugin.PREF_DEFAULT_BREAKPOINT_SUSPEND_POLICY);
        this.fSuspendVMorThread.select(value == 2 ? 0 : 1);
        this.fAlertHCRButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED));
        this.fAlertHCRNotSupportedButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED));
        this.fAlertObsoleteButton.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS));
        this.fPerformHCRWithCompilationErrors.setSelection(coreStore.getDefaultBoolean(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS));
        this.fTimeoutText.setStringValue(new Integer(coreStore.getDefaultInt(JDIDebugModel.PREF_REQUEST_TIMEOUT)).toString());
        this.fConnectionTimeoutText.setStringValue(new Integer(runtimeStore.getDefaultInt(JavaRuntime.PREF_CONNECT_TIMEOUT)).toString());
        this.fPromptUnableToInstallBreakpoint.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_ALERT_UNABLE_TO_INSTALL_BREAKPOINT));
        this.fOpenInspector.setSelection(store.getDefaultBoolean(IJDIPreferencesConstants.PREF_OPEN_INSPECT_POPUP_ON_EXCEPTION));
        super.performDefaults();
    }

    private void setValues() {
        IPreferenceStore store = this.getPreferenceStore();
        Preferences coreStore = JDIDebugModel.getPreferences();
        Preferences runtimeStore = JavaRuntime.getPreferences();
        this.fSuspendButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_UNCAUGHT_EXCEPTIONS));
        this.fSuspendOnCompilationErrors.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_SUSPEND_ON_COMPILATION_ERRORS));
        this.fSuspendDuringEvaluations.setSelection(coreStore.getBoolean(JDIDebugModel.PREF_SUSPEND_FOR_BREAKPOINTS_DURING_EVALUATION));
        int value = coreStore.getInt(JDIDebugPlugin.PREF_DEFAULT_BREAKPOINT_SUSPEND_POLICY);
        this.fSuspendVMorThread.select(value == 2 ? 0 : 1);
        this.fAlertHCRButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED));
        this.fAlertHCRNotSupportedButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED));
        this.fAlertObsoleteButton.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS));
        this.fPerformHCRWithCompilationErrors.setSelection(coreStore.getBoolean(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS));
        this.fTimeoutText.setStringValue(new Integer(coreStore.getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT)).toString());
        this.fConnectionTimeoutText.setStringValue(new Integer(runtimeStore.getInt(JavaRuntime.PREF_CONNECT_TIMEOUT)).toString());
        this.fPromptUnableToInstallBreakpoint.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_ALERT_UNABLE_TO_INSTALL_BREAKPOINT));
        this.fOpenInspector.setSelection(store.getBoolean(IJDIPreferencesConstants.PREF_OPEN_INSPECT_POPUP_ON_EXCEPTION));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                if (this.fTimeoutText != null && event.getSource() != this.fTimeoutText) {
                    this.fTimeoutText.refreshValidState();
                }
                if (this.fConnectionTimeoutText != null && event.getSource() != this.fConnectionTimeoutText) {
                    this.fConnectionTimeoutText.refreshValidState();
                }
            }
            this.setValid(this.fTimeoutText.isValid() && this.fConnectionTimeoutText.isValid());
            this.getContainer().updateButtons();
            this.updateApplyButton();
        }
    }

    protected boolean canClearErrorMessage() {
        return this.fTimeoutText.isValid() && this.fConnectionTimeoutText.isValid();
    }

    protected class JavaDebugIntegerFieldEditor
    extends IntegerFieldEditor {
        public JavaDebugIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (JavaDebugPreferencePage.this.canClearErrorMessage()) {
                super.clearErrorMessage();
            }
        }
    }
}

