/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.ClassServiceFactory;
import org.eclipse.jdt.apt.core.internal.IServiceFactory;
import org.eclipse.jdt.apt.core.internal.PluginFactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryPluginManager {
    private static final HashMap<String, AnnotationProcessorFactory> PLUGIN_JAVA5_FACTORY_MAP = new HashMap();
    private static final HashMap<String, IServiceFactory> PLUGIN_JAVA6_FACTORY_MAP = new HashMap();
    private static final TreeMap<String, PluginFactoryContainer> PLUGIN_CONTAINER_MAP = new TreeMap();
    private static boolean mapsInitialized = false;

    public static synchronized Map<FactoryContainer, FactoryPath.Attributes> getAllPluginFactoryContainers() {
        LinkedHashMap<FactoryContainer, FactoryPath.Attributes> map = new LinkedHashMap<FactoryContainer, FactoryPath.Attributes>(FactoryPluginManager.getPluginContainerMap().size());
        for (PluginFactoryContainer pfc : FactoryPluginManager.getPluginContainerMap().values()) {
            FactoryPath.Attributes a = new FactoryPath.Attributes(pfc.getEnableDefault(), false);
            map.put(pfc, a);
        }
        return map;
    }

    public static synchronized AnnotationProcessorFactory getJava5FactoryFromPlugin(String factoryName) {
        AnnotationProcessorFactory apf = FactoryPluginManager.getJava5PluginFactoryMap().get(factoryName);
        if (apf == null) {
            String s = "could not find AnnotationProcessorFactory " + factoryName + " from available factories defined by plugins";
            AptPlugin.log((IStatus)new Status(2, "org.eclipse.jdt.apt.core", 2, s, null));
        }
        return apf;
    }

    public static synchronized IServiceFactory getJava6FactoryFromPlugin(String factoryName) {
        IServiceFactory isf = FactoryPluginManager.getJava6PluginFactoryMap().get(factoryName);
        if (isf == null) {
            String s = "could not find annotation processor " + factoryName + " from available factories defined by plugins";
            AptPlugin.log((IStatus)new Status(2, "org.eclipse.jdt.apt.core", 2, s, null));
        }
        return isf;
    }

    public static synchronized FactoryContainer getPluginFactoryContainer(String pluginId) {
        return FactoryPluginManager.getPluginContainerMap().get(pluginId);
    }

    private static TreeMap<String, PluginFactoryContainer> getPluginContainerMap() {
        FactoryPluginManager.loadFactoryPlugins();
        return PLUGIN_CONTAINER_MAP;
    }

    private static HashMap<String, AnnotationProcessorFactory> getJava5PluginFactoryMap() {
        FactoryPluginManager.loadFactoryPlugins();
        return PLUGIN_JAVA5_FACTORY_MAP;
    }

    private static HashMap<String, IServiceFactory> getJava6PluginFactoryMap() {
        FactoryPluginManager.loadFactoryPlugins();
        return PLUGIN_JAVA6_FACTORY_MAP;
    }

    private static synchronized void loadFactoryPlugins() {
        if (mapsInitialized) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.apt.core", "annotationProcessorFactory");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement factories = iConfigurationElementArray[n4];
                if ("factories".equals(factories.getName())) {
                    FactoryPluginManager.loadJava5Factories(extension, factories);
                } else if ("java6processors".equals(factories.getName())) {
                    FactoryPluginManager.loadJava6Factories(extension, factories);
                }
                ++n4;
            }
            ++n2;
        }
        mapsInitialized = true;
    }

    private static void loadJava6Factories(IExtension extension, IConfigurationElement factories) {
        if (!AptPlugin.canRunJava6Processors()) {
            return;
        }
        String enableDefaultStr = factories.getAttribute("enableDefault");
        boolean enableDefault = true;
        if ("false".equals(enableDefaultStr)) {
            enableDefault = false;
        }
        String pluginId = extension.getNamespaceIdentifier();
        PluginFactoryContainer pfc = new PluginFactoryContainer(pluginId, enableDefault);
        PLUGIN_CONTAINER_MAP.put(pluginId, pfc);
        IConfigurationElement[] iConfigurationElementArray = factories.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement factory = iConfigurationElementArray[n2];
            if ("java6processor".equals(factory.getName())) {
                String factoryName = null;
                try {
                    factoryName = factory.getAttribute("class");
                    Object execExt = factory.createExecutableExtension("class");
                    Class<?> clazz = execExt.getClass();
                    if (AptPlugin.getJava6ProcessorClass().isInstance(execExt)) {
                        assert (clazz.getName().equals(factoryName));
                        ClassServiceFactory isf = new ClassServiceFactory(clazz);
                        PLUGIN_JAVA6_FACTORY_MAP.put(factoryName, isf);
                        pfc.addFactoryName(factoryName, "javax.annotation.processing.Processor");
                    } else {
                        FactoryPluginManager.reportFailureToLoadProcessor(null, factoryName, extension.getNamespaceIdentifier());
                    }
                }
                catch (CoreException e) {
                    FactoryPluginManager.reportFailureToLoadProcessor((Exception)((Object)e), factoryName, extension.getNamespaceIdentifier());
                }
            }
            ++n2;
        }
    }

    private static void loadJava5Factories(IExtension extension, IConfigurationElement factories) {
        String enableDefaultStr = factories.getAttribute("enableDefault");
        boolean enableDefault = true;
        if ("false".equals(enableDefaultStr)) {
            enableDefault = false;
        }
        String pluginId = extension.getNamespaceIdentifier();
        PluginFactoryContainer pfc = new PluginFactoryContainer(pluginId, enableDefault);
        PLUGIN_CONTAINER_MAP.put(pluginId, pfc);
        IConfigurationElement[] iConfigurationElementArray = factories.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement factory = iConfigurationElementArray[n2];
            if ("factory".equals(factory.getName())) {
                String factoryName = null;
                try {
                    factoryName = factory.getAttribute("class");
                    Object execExt = factory.createExecutableExtension("class");
                    if (execExt instanceof AnnotationProcessorFactory) {
                        assert (execExt.getClass().getName().equals(factoryName));
                        PLUGIN_JAVA5_FACTORY_MAP.put(factoryName, (AnnotationProcessorFactory)execExt);
                        pfc.addFactoryName(factoryName, "com.sun.mirror.apt.AnnotationProcessorFactory");
                    } else {
                        FactoryPluginManager.reportFailureToLoadProcessor(null, factory.getName(), extension.getNamespaceIdentifier());
                    }
                }
                catch (CoreException e) {
                    FactoryPluginManager.reportFailureToLoadProcessor((Exception)((Object)e), factory.getName(), extension.getNamespaceIdentifier());
                }
            }
            ++n2;
        }
    }

    private static void reportFailureToLoadProcessor(Exception e, String factoryName, String pluginId) {
        AptPlugin.log(e, "Unable to load annotation processor " + factoryName + " from plug-in " + pluginId);
    }
}

