# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Probabilistic distributions."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _dist_bundle1
else:
    import _dist_bundle1

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _dist_bundle1.delete_SwigPyIterator

    def value(self):
        return _dist_bundle1.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _dist_bundle1.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _dist_bundle1.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _dist_bundle1.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _dist_bundle1.SwigPyIterator_equal(self, x)

    def copy(self):
        return _dist_bundle1.SwigPyIterator_copy(self)

    def next(self):
        return _dist_bundle1.SwigPyIterator_next(self)

    def __next__(self):
        return _dist_bundle1.SwigPyIterator___next__(self)

    def previous(self):
        return _dist_bundle1.SwigPyIterator_previous(self)

    def advance(self, n):
        return _dist_bundle1.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _dist_bundle1.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _dist_bundle1.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _dist_bundle1.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _dist_bundle1.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _dist_bundle1.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _dist_bundle1.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _dist_bundle1:
_dist_bundle1.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class Arcsine(openturns.model_copula.DistributionImplementation):
    r"""
    Arcsine distribution.

    Parameters
    ----------
    a : float
        lower bound.

        Default value is -1.0.
    b : float
        upper bound, :math:`b > a`.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{1}{\pi \sqrt{(x - a)(b - x)}},
                 \quad x \in [a, b]

    with :math:`a < b`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \frac{a + b}{2} \\
            \Var{X} & = & \frac{(b - a)^2}{8}
        \end{eqnarray*}

    It is possible to create an Arcsine distribution from the alternative parametrization :math:`(\mu, \sigma)`: see  :class:`~openturns.ArcsineMuSigma`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization :math:`(\mu, \sigma)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(a, b)`

    Examples
    --------
    Create a distribution from its native parameters :math:`(a, b)`:

    >>> import openturns as ot
    >>> myDist = ot.Arcsine(2.0, 3.0)

    Create a it from the alternative parametrization :math:`(\mu, \sigma)`:

    >>> myDist2 = ot.Arcsine()
    >>> myDist2.setParameter(ot.ArcsineMuSigma()([2.5, 0.35]))

    Create it from :math:`(\mu, \sigma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.ArcsineMuSigma(2.5, 0.35)
    >>> myDist3 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Arcsine_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Arcsine___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Arcsine___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Arcsine___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Arcsine_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Arcsine_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Arcsine_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Arcsine_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Arcsine_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Arcsine_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Arcsine_computeCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Arcsine_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Arcsine_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Arcsine_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.Arcsine_computeProbability(self, interval)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Arcsine_computeEntropy(self)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle1.Arcsine_getRoughness(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Arcsine_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Arcsine_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Arcsine_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.Arcsine_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Arcsine_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Arcsine_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Arcsine_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Arcsine_isElliptical(self)

    def setA(self, a):
        r"""
        Accessor to the distribution's lower bound.

        Parameters
        ----------
        a : float, :math:`a < b`
            Lower bound.
        """
        return _dist_bundle1.Arcsine_setA(self, a)

    def getA(self):
        r"""
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle1.Arcsine_getA(self)

    def setB(self, b):
        r"""
        Accessor to the distribution's upper bound.

        Parameters
        ----------
        b : float, :math:`a < b`
            Upper bound.
        """
        return _dist_bundle1.Arcsine_setB(self, b)

    def getB(self):
        r"""
        Accessor to the distribution's upper bound.

        Returns
        -------
        b : float
            Upper bound.
        """
        return _dist_bundle1.Arcsine_getB(self)

    def __init__(self, *args):
        _dist_bundle1.Arcsine_swiginit(self, _dist_bundle1.new_Arcsine(*args))
    __swig_destroy__ = _dist_bundle1.delete_Arcsine

# Register Arcsine in _dist_bundle1:
_dist_bundle1.Arcsine_swigregister(Arcsine)
class ArcsineFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Arcsine factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \Hat{a} = \Hat{\mu}_x - \Hat{\sigma}_x \sqrt{2}\\
          \displaystyle \Hat{b} = \Hat{\mu}_x + \Hat{\sigma}_x \sqrt{2}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Arcsine
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ArcsineFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.ArcsineFactory_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle1.ArcsineFactory_buildEstimator(self, *args)

    def buildAsArcsine(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsArcsine()

            buildAsArcsine(*sample*)

            buildAsArcsine(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
            The parameters of the  :class:`~openturns.Arcsine`.

        Returns
        -------
        dist : :class:`~openturns.Arcsine`
            The built distribution.

            In the first usage, the default Arcsine distribution is built.
        """
        return _dist_bundle1.ArcsineFactory_buildAsArcsine(self, *args)

    def __init__(self, *args):
        _dist_bundle1.ArcsineFactory_swiginit(self, _dist_bundle1.new_ArcsineFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_ArcsineFactory

# Register ArcsineFactory in _dist_bundle1:
_dist_bundle1.ArcsineFactory_swigregister(ArcsineFactory)
class ArcsineMuSigma(openturns.model_copula.DistributionParametersImplementation):
    r"""
    Arcsine distribution parameters.

    Parameters
    ----------
    mu : float
        Mean.

        Default value is 1.0.
    sigma : float
        Standard deviation :math:`\sigma > 0`.

        Default value is 1.0.

    Notes
    -----
    The native parameters are defined as follows:

    .. math::

        a &= \mu - \sigma \sqrt{2} \\
        b &= \mu + \sigma \sqrt{2}

    See also
    --------
    Arcsine

    Examples
    --------
    Create the parameters of the Arcsine distribution:

    >>> import openturns as ot
    >>> parameters = ot.ArcsineMuSigma(8.4, 2.25)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [5.21802,11.582]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  1        1       ]
     [ -1.41421  1.41421 ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ArcsineMuSigma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.ArcsineMuSigma___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.ArcsineMuSigma_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle1.ArcsineMuSigma_gradient(self)

    def __call__(self, inP):
        return _dist_bundle1.ArcsineMuSigma___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.ArcsineMuSigma_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.ArcsineMuSigma_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.ArcsineMuSigma_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.ArcsineMuSigma_getDescription(self)

    def __repr__(self):
        return _dist_bundle1.ArcsineMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.ArcsineMuSigma___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle1.ArcsineMuSigma_swiginit(self, _dist_bundle1.new_ArcsineMuSigma(*args))
    __swig_destroy__ = _dist_bundle1.delete_ArcsineMuSigma

# Register ArcsineMuSigma in _dist_bundle1:
_dist_bundle1.ArcsineMuSigma_swigregister(ArcsineMuSigma)
class Bernoulli(openturns.model_copula.DistributionImplementation):
    r"""
    Bernoulli distribution.

    Parameters
    ----------
    p : float, :math:`0 \leq p \leq 1`
        Success probability.

        Default value is 0.5.

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Prob{X = 1} & = & p \\
            \Prob{X = 0} & = & 1 - p
        \end{eqnarray*}

    with :math:`0 \leq p \leq 1`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & p \\
            \Var{X} & = & p\,(1 - p)
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Bernoulli(0.2)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Bernoulli_getClassName(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Bernoulli_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Bernoulli_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Bernoulli_isIntegral(self)

    def __eq__(self, *args):
        return _dist_bundle1.Bernoulli___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Bernoulli___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Bernoulli___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Bernoulli_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Bernoulli_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Bernoulli_computeCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Bernoulli_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Bernoulli_computeCDFGradient(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Bernoulli_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Bernoulli_computeCharacteristicFunction(self, x)

    def computeGeneratingFunction(self, z):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input *z*.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle1.Bernoulli_computeGeneratingFunction(self, z)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle1.Bernoulli_getSupport(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Bernoulli_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Bernoulli_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Bernoulli_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Bernoulli_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Bernoulli_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Bernoulli_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Bernoulli_isElliptical(self)

    def setP(self, p):
        r"""
        Accessor to the distribution's *success probability* parameter.

        Parameters
        ----------
        p : float, :math:`0 \leq p \leq 1`
            Success probability.
        """
        return _dist_bundle1.Bernoulli_setP(self, p)

    def getP(self):
        r"""
        Accessor to the distribution's *success probability* parameter.

        Returns
        -------
        p : float
            Success probability.
        """
        return _dist_bundle1.Bernoulli_getP(self)

    def __init__(self, *args):
        _dist_bundle1.Bernoulli_swiginit(self, _dist_bundle1.new_Bernoulli(*args))
    __swig_destroy__ = _dist_bundle1.delete_Bernoulli

# Register Bernoulli in _dist_bundle1:
_dist_bundle1.Bernoulli_swigregister(Bernoulli)
class BernoulliFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Bernoulli factory.

    Notes
    -----
    We use the following estimator:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{p}_n = \bar{x}_n
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Bernoulli
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BernoulliFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.BernoulliFactory_build(self, *args)

    def buildAsBernoulli(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsBernoulli()

            buildAsBernoulli(*sample*)

            buildAsBernoulli(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
           The parameters of the :class:`~openturns.Bernoulli`.

        Returns
        -------
        distribution : :class:`~openturns.Bernoulli`
            The estimated distribution as a Bernoulli.

            In the first usage, the default Bernoulli distribution is built.
        """
        return _dist_bundle1.BernoulliFactory_buildAsBernoulli(self, *args)

    def buildEstimator(self, sample):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle1.BernoulliFactory_buildEstimator(self, sample)

    def __init__(self, *args):
        _dist_bundle1.BernoulliFactory_swiginit(self, _dist_bundle1.new_BernoulliFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_BernoulliFactory

# Register BernoulliFactory in _dist_bundle1:
_dist_bundle1.BernoulliFactory_swigregister(BernoulliFactory)
class EmpiricalBernsteinCopula(openturns.model_copula.DistributionImplementation):
    r"""
    Empirical Bernstein copula.

    Parameters
    ----------
    sample : :class:`~openturns.Sample`
        A sample of size :math:`\sampleSize>0` and dimension :math:`d`.

        Default value is [[0.0], [0.0]].
    m : int, :math:`1 \leq m \leq \sampleSize`
        The number of sub-intervals in which all the edges of the unit cube
        :math:`[0, 1]^d` are regularly partitioned.

        Default value is 1.
    isRankSample : bool
        Flag to tell if the given sample is already a normalized rank sample.

        Default value is False.

    Notes
    -----
    Let :math:`(\inputReal_1, \dots, \inputReal_\sampleSize)` a sample. Let :math:`m` be the bin number.
    Note that when :math:`m=1`, the empirical Bernstein copula is the independent copula. When :math:`m=\sampleSize`, the empirical Bernstein
    copula is also called the *Beta copula* (see [segers2016]_).

    **Case 1:** :math:`isRankSample = False`.

    In that case, if :math:`m` does not divide :math:`\sampleSize`, then a part of the sample is
    removed in order to get a new size :math:`\tilde{\sampleSize}` such that :math:`m` divides :math:`\tilde{\sampleSize}`. At most, :math:`m-1` points are removed from the initial sample. This condition guarantees that the :class:`~openturns.EmpiricalBernsteinCopula`
    built is a copula.

    We still denote by  :math:`\sampleSize` the size of the sample used to create the empirical Bernstein copula.

    Let :math:`(\vect{v}_1, \dots, \vect{v}_\sampleSize)` be the associated normalized rank sample defined  by:

    .. math::

         \vect{v}_k = \dfrac{1}{\sampleSize} rank(\inputReal_k)

    for all :math:`1 \leq i \leq \sampleSize` where the rank of a vector is the vector of the component ranks.

    Let :math:`r_i^j` and :math:`s_i^j` defined by:

    .. math::

         r_i^j & = \lfloor m v_i^j \rfloor \\
         s_i^j & = m-r_i^j+1

    for all :math:`1 \leq i \leq \sampleSize` and :math:`1 \leq j \leq d` and where :math:`\lfloor x \rfloor` is
    the largest integer less than or equal to :math:`x`.

    Let :math:`B(r_i^j , s_i^j, 0, 1)` be a
    :class:`~openturns.Beta` distribution defined on :math:`[0,1]` parametrized by the shape parameters :math:`r_i^j` and
    :math:`s_i^j`. We denote by :math:`F_{B(r_i^j, s_i^j, 0, 1)}` its cumulated distribution function.

    Then the empirical Bernstein copula :math:`C^B_\sampleSize` is defined by:

    .. math::
        :label: defEmpCopBernstein

        C^B_\sampleSize(\vect{u}) = \dfrac{1}{\sampleSize}\sum_{i=1}^\sampleSize\prod_{j=1}^d F_{B(r_i^j, s_i^j, 0, 1)}(u^j)

    for :math:`\vect{u}\in[0,1]^d`.

    **Case 2:** :math:`isRankSample = True`.

    In that case, the given sample is assumed to be already a normalized rank sample.
    Even if the bin number :math:`m` does not divide :math:`\sampleSize`, the whole sample is used. The
    empirical Bernstein copula is still defined by :eq:`defEmpCopBernstein` where :math:`r_i^j`
    and :math:`s_i^j` are computed on the initial sample :math:`(\inputReal_1, \dots, \inputReal_\sampleSize)`:

    .. math::

         r_i^j & = \lfloor m x_i^j \rfloor \\
         s_i^j & = m-r_i^j+1

    If :math:`m` does not divide :math:`\sampleSize`, then :math:`C^B_\sampleSize` is no longer a copula but still a valid core,
    i.e a multivariate distribution whose range is included in :math:`[0,1]^d`. As a matter of fact, the marginals are not necessarily
    uniform because some cells may have more points than others.

    We still use the term *copula* even if it is not a copula.

    See also
    --------
    BernsteinCopulaFactory

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> sampleNormal = ot.Normal(2).getSample(10)
    >>> m = 2
    >>> empBernsteinCop = ot.EmpiricalBernsteinCopula(sampleNormal, m)

    Draw a sample:

    >>> sample = empBernsteinCop.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.EmpiricalBernsteinCopula___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.EmpiricalBernsteinCopula___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.EmpiricalBernsteinCopula___str__(self, *args)

    def setCopulaSample(self, copulaSample, isEmpiricalCopulaSample=False):
        r"""
        Set the sample.

        Parameters
        ----------
        sample : 2-d sequence of float
            The sample from which the empirical copula sample is deduced.
        isRankSample : bool
            Flag telling if the given sample is already a normalized rank sample.

            Default value is *False*.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_setCopulaSample(self, copulaSample, isEmpiricalCopulaSample)

    def getCopulaSample(self):
        r"""
        Get the empirical copula sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The empirical copula sample.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_getCopulaSample(self)

    def setBinNumber(self, binNumber):
        r"""
        Set the bin number :math:`m`.

        Parameters
        ----------
        m : int, :math:`0 < m \leq \sampleSize`
            The number of sub-intervals in which all the edges of the unit cube
            :math:`[0, 1]^d` are regularly partitioned.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_setBinNumber(self, binNumber)

    def getBinNumber(self):
        r"""
        Get the bin number :math:`m`.

        Returns
        -------
        m : int, :math:`0 < m \leq \sampleSize`
            The number of sub-intervals in which all the edges of the unit cube
            :math:`[0, 1]^d` are regularly partitioned.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_getBinNumber(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_getSample(self, size)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_computeProbability(self, interval)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_computeSequentialConditionalCDF(self, x)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_getMarginal(self, *args)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_getSpearmanCorrelation(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_hasIndependentCopula(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.EmpiricalBernsteinCopula_getParameterDescription(self)

    def __init__(self, *args):
        _dist_bundle1.EmpiricalBernsteinCopula_swiginit(self, _dist_bundle1.new_EmpiricalBernsteinCopula(*args))
    __swig_destroy__ = _dist_bundle1.delete_EmpiricalBernsteinCopula

# Register EmpiricalBernsteinCopula in _dist_bundle1:
_dist_bundle1.EmpiricalBernsteinCopula_swigregister(EmpiricalBernsteinCopula)
class BernsteinCopulaFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    EmpiricalBernsteinCopula factory.

    Notes
    -----
    This class builds an :class:`~openturns.EmpiricalBernsteinCopula` which is a non parametric fitting of
    the copula of a multivariate distribution.

    The keys of :class:`~openturns.ResourceMap` related to the class are:

    - the keys `BernsteinCopulaFactory-MinM` and `BernsteinCopulaFactory-MaxM` that define the range of :math:`m`
      in the optimization
      problems computing the optimal bin number according to a specified criterion,
    - the key `BernsteinCopulaFactory-BinNumberSelection` that defines the  criterion to compute the optimal bin number
      when it is not specified. The possible choices are 'AMISE', 'LogLikelihood', 'PenalizedCsiszarDivergence';
    - the key `BernsteinCopulaFactory-KFraction` that defines the fraction of the sample used for the validation in the
      method :meth:`ComputeLogLikelihoodBinNumber`,
    - the key `BernsteinCopulaFactory-SamplingSize`  that defines the :math:`N` parameter used in the
      method :meth:`ComputePenalizedCsiszarDivergenceBinNumber`.

    See also
    --------
    DistributionFactory, EmpiricalBernsteinCopula
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BernsteinCopulaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the empirical Bernstein copula.

        **Available usages**:

            build()

            build(*sample*)

            build(*sample, m*)

            build(*sample, method, f*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension :math:`d`
            The sample of size :math:`\sampleSize>0` from which the copula is estimated.
        method : str
            The name of the bin number selection method. Possible choices are *AMISE*, *LogLikelihood* and *PenalizedCsiszarDivergence*.

            Default is *LogLikelihood*.
        f : :class:`~openturns.Function`
            The function defining the Csiszar divergence of interest used by
            the  *PenalizedCsiszarDivergence* method.

            Default is Function().
        m : int,:math:`1 \leq m \leq \sampleSize`,
            The bin number, i.e. the number of sub-intervals in which all the edges of the unit cube
            :math:`[0, 1]^d` are regularly partitioned.

            Default value is the value computed from the default bin number selection method.

        Returns
        -------
        copula : :class:`~openturns.Distribution`
            The empirical Bernstein copula as a generic distribution.

        Notes
        -----
        If the bin number :math:`m` is specified and does not divide the sample size :math:`\sampleSize`, then a part of the sample is
        removed for the result to be a copula. See :class:`~openturns.EmpiricalBernsteinCopula`.

        """
        return _dist_bundle1.BernsteinCopulaFactory_build(self, *args)

    def buildAsEmpiricalBernsteinCopula(self, *args):
        r"""
        Build the empirical Bernstein copula as a native distribution.

        **Available usages**:

            buildAsEmpiricalBernsteinCopula()

            buildAsEmpiricalBernsteinCopula(*sample*)

            buildAsEmpiricalBernsteinCopula(*sample, m*)

            buildAsEmpiricalBernsteinCopula(*sample, method, f*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension *d*
            The sample of size :math:`\sampleSize>0` from which the copula is estimated.
        method : str
            The name of the bin number selection method. Possible choices are *AMISE*, *LogLikelihood* and
            *PenalizedCsiszarDivergence*.

            Default is *LogLikelihood*.
        f : :class:`~openturns.Function`
            The function defining the Csiszar divergence of interest used by
            the  *PenalizedCsiszarDivergence* method.

            Default is Function().
        m : int, :math:`1 \leq m \leq \sampleSize`,
            The bin number, i.e. the number of sub-intervals in which all the edges of the unit cube
            :math:`[0, 1]^d` are regularly partitioned.

            Default value is the value computed from the default bin number selection method.

        Returns
        -------
        copula : :class:`~openturns.EmpiricalBernsteinCopula`
            The empirical Bernstein copula as a native distribution.

        Notes
        -----
        If the bin number :math:`m` is specified and does not divide the sample size :math:`\sampleSize`, then a part of the sample is
        removed for the result to be a copula a copula. See :class:`~openturns.EmpiricalBernsteinCopula`.

        """
        return _dist_bundle1.BernsteinCopulaFactory_buildAsEmpiricalBernsteinCopula(self, *args)

    @staticmethod
    def ComputeAMISEBinNumber(sample):
        r"""
        Compute the optimal AMISE number of bins.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the optimal AMISE bin number is computed.

        Notes
        -----
        The bin number :math:`m` is computed by minimizing the asymptotic mean integrated squared error (AMISE),
        leading to:

        .. math::

            m = 1+\left\lfloor \sampleSize^{\frac{2}{4+d}} \right\rfloor

        where :math:`\lfloor x \rfloor` is the largest integer less than or equal to :math:`x`, :math:`\sampleSize` the sample size and :math:`d` the sample dimension.

        Note that this optimal :math:`m` does not necessarily divide the sample size :math:`\sampleSize`.

        """
        return _dist_bundle1.BernsteinCopulaFactory_ComputeAMISEBinNumber(sample)

    @staticmethod
    def ComputeLogLikelihoodBinNumber(*args):
        r"""
        Compute the optimal log-likelihood number of bins by cross-validation.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample of size :math:`\sampleSize` from which the optimal log-likelihood bin number is computed.
        kFraction : int, :math:`0<kFraction<\sampleSize`
            The fraction of the sample used for the validation.

            Default value 2.

        Notes
        -----
        Let :math:`\cE= (\inputReal_1, \dots, \inputReal_\sampleSize)` be the given sample. If :math:`kFraction=1`, the bin number :math:`m` is given by:

        .. math::

            m = \argmin_{M\in\{1,\dots,\sampleSize\}}\dfrac{1}{\sampleSize}\sum_{\vect{x}_i\in\cE}-\log c^{\cE}_{M}(\vect{x}_i)

        where :math:`c_M^{\cE}` is the density function of the :class:`~openturns.EmpiricalBernsteinCopula` associated to the sample :math:`\cE` and the bin number :math:`M`.

        If :math:`kFraction>1`, the bin number :math:`m` is given by:

        .. math::

            m = \argmin_{M\in\{1,\dots,\sampleSize\}}\dfrac{1}{kFraction}\sum_{k=0}^{kFraction-1}\dfrac{1}{\sampleSize}\sum_{\vect{x}_i\in\cE^V_k}-\log c^{\cE^L_k}_{M}(\vect{x}_i)

        where :math:`\cE^V_k=\left\{\vect{x}_i\in\cE\,|\,i\equiv k \mod kFraction\right\}`
        and :math:`\cE^L_k=\cE \backslash \cE^V_k`.

        Note that this optimal :math:`m` does not necessarily divide the sample size :math:`\sampleSize`.

        """
        return _dist_bundle1.BernsteinCopulaFactory_ComputeLogLikelihoodBinNumber(*args)

    @staticmethod
    def ComputePenalizedCsiszarDivergenceBinNumber(*args):
        r"""
        Compute the optimal penalized Csiszar divergence number of bins.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample of size :math:`\sampleSize` from which the optimal AMISE bin number is computed.
        f : :class:`~openturns.Function`
            The function defining the Csiszar divergence of interest.
        alpha : float, :math:`\alpha\geq 0`
            The penalization factor.

        Notes
        -----
        Let :math:`\cE=(\inputReal_1, \dots, \inputReal_\sampleSize)` be the given sample. The bin number :math:`m` is given by:

        .. math::

            m = \argmin_{M\in\{1,\dots,\sampleSize\}}\left[\hat{D}_f(c^{\cE}_{M})-\dfrac{1}{\sampleSize}\sum_{\vect{x}_i\in\cE}f\left(\dfrac{1}{c^{\cE}_{M}(\vect{x}_i)}\right)\right]^2-[\rho_S(c^{\cE}_{M})-\rho_S({\cE}_{M})]^2

        where :math:`c_M^{\cE}` is the density function of the :class:`~openturns.EmpiricalBernsteinCopula` associated to the sample
        :math:`\cE` and the bin number :math:`M`, :math:`\hat{D}_f(c^{\cE}_{M})=\dfrac{1}{N}\sum_{j=1}^Nf\left(\dfrac{1}{\vect{u}_j}\right)` a
        Monte Carlo estimate of the Csiszar :math:`f` divergence, :math:`\rho_S(c^{\cE}_{M})` the exact Spearman correlation of the empirical
        Bernstein copula :math:`c^{\cE}_{M}` and :math:`\rho_S({\cE}_{M})` the empirical Spearman correlation of the sample :math:`{\cE}_{M}`.

        The parameter :math:`N` is controlled by the *BernsteinCopulaFactory-SamplingSize* key in :class:`~openturns.ResourceMap`.

        Note that this optimal :math:`m` does not necessarily divide the sample size :math:`\sampleSize`.

        """
        return _dist_bundle1.BernsteinCopulaFactory_ComputePenalizedCsiszarDivergenceBinNumber(*args)

    def __init__(self, *args):
        _dist_bundle1.BernsteinCopulaFactory_swiginit(self, _dist_bundle1.new_BernsteinCopulaFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_BernsteinCopulaFactory

# Register BernsteinCopulaFactory in _dist_bundle1:
_dist_bundle1.BernsteinCopulaFactory_swigregister(BernsteinCopulaFactory)
class Beta(openturns.model_copula.DistributionImplementation):
    r"""
    Beta distribution.

    Parameters
    ----------
    alpha : float
        Shape parameter :math:`\alpha > 0`.

        Default value is 2.0.
    beta : float
        Shape parameter :math:`\beta > 0`.

        Default value is 2.0.
    a : float
        Lower bound.

        Default value is -1.0.
    b : float, :math:`b > a`
        Upper bound.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{(x - a)^{\alpha - 1} (b - x)^{\beta - 1}}
                      {(b - a)^{\alpha + \beta - 1} {\rm B}(\alpha, \beta)},
                      \quad x \in [a, b]

    with :math:`\alpha, \beta > 0` and :math:`a < b` and where :math:`\rm B` denotes
    Euler's beta function :meth:`~openturns.SpecFunc.Beta`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & a + (b - a)\frac{\alpha}{\alpha + \beta} \\
            \Var{X} & = & (b - a)^2 \frac{\alpha \beta}{(\alpha + \beta)^2(\alpha + \beta + 1)}
        \end{eqnarray*}


    It is possible to create a Beta distribution from the alternative parametrization :math:`(\mu, \sigma, a, b)`: see  :class:`~openturns.BetaMuSigma`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization :math:`(\mu, \sigma, a, b)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\alpha, \beta, a, b)`.

    Examples
    --------
    Create a distribution from its native parameters :math:`(\alpha, \beta, a, b)`:

    >>> import openturns as ot
    >>> myDist = ot.Beta(1.0, 2.0, 1.0, 5.0)

    Create it from the alternative parametrization :math:`(\mu, \sigma, a, b)`:

    >>> myDist2 = ot.Beta()
    >>> myDist2.setParameter(ot.BetaMuSigma()([3.0, 1.15, 1.0, 5.0]))

    Create it from :math:`(\mu, \sigma, a, b)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.BetaMuSigma(3.0, 1.15, 1.0, 5.0)
    >>> myDist3 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Beta_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Beta___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Beta___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Beta___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Beta_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Beta_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Beta_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Beta_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Beta_computeCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Beta_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Beta_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Beta_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.Beta_computeProbability(self, interval)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Beta_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Beta_computeCharacteristicFunction(self, x)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle1.Beta_getRoughness(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Beta_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Beta_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Beta_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.Beta_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Beta_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Beta_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Beta_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        The Beta distribution is elliptical if :math:`\alpha = \beta`.

        """
        return _dist_bundle1.Beta_isElliptical(self)

    def setAlpha(self, alpha):
        r"""
        Accessor to the distribution's shape parameter :math:`\alpha`.

        Parameters
        ----------
        alpha : float, :math:`\alpha > 0`
            Shape parameter :math:`\alpha`.
        """
        return _dist_bundle1.Beta_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Accessor to the distribution's shape parameter :math:`\alpha`.

        Returns
        -------
        alpha : float
            Shape parameter :math:`\alpha`.
        """
        return _dist_bundle1.Beta_getAlpha(self)

    def setBeta(self, beta):
        r"""
        Accessor to the distribution's shape parameter :math:`\beta`.

        Parameters
        ----------
        beta : float, :math:`\beta > 0`
            Shape parameter :math:`\beta`.
        """
        return _dist_bundle1.Beta_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the distribution's shape parameter :math:`\beta`.

        Returns
        -------
        beta : float
            Shape parameter :math:`\beta`.
        """
        return _dist_bundle1.Beta_getBeta(self)

    def setA(self, a):
        r"""
        Accessor to the distribution's lower bound.

        Parameters
        ----------
        a : float, :math:`a < b`
            Lower bound.
        """
        return _dist_bundle1.Beta_setA(self, a)

    def getA(self):
        r"""
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle1.Beta_getA(self)

    def setB(self, b):
        r"""
        Accessor to the distribution's upper bound.

        Parameters
        ----------
        b : float, :math:`b > a`
            Upper bound.
        """
        return _dist_bundle1.Beta_setB(self, b)

    def getB(self):
        r"""
        Accessor to the distribution's upper bound.

        Returns
        -------
        b : float
            Upper bound.
        """
        return _dist_bundle1.Beta_getB(self)

    def __init__(self, *args):
        _dist_bundle1.Beta_swiginit(self, _dist_bundle1.new_Beta(*args))
    __swig_destroy__ = _dist_bundle1.delete_Beta

# Register Beta in _dist_bundle1:
_dist_bundle1.Beta_swigregister(Beta)
class BetaFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Beta factory.

    Notes
    -----
    Let :math:`n` be the sample sample size. 
    Let :math:`x_{(1)}` be the sample minimum and :math:`x_{(n)}` be the sample maximum.
    Let :math:`\delta` be the sample range:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \delta = x_{(n)} - x_{(1)}.
        \end{eqnarray*}

    Then the distribution bounds are computed from the equations:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \hat{a} &=& x_{(1)} - \frac{\delta}{n + 2}, \\
          \hat{b} &=& x_{(n)} + \frac{\delta}{n + 2}.
        \end{eqnarray*}

    Let :math:`\bar{x}` be the sample mean and :math:`\hat{\sigma}^2` be the sample
    unbiased variance.
    The remaining parameters are estimated using the method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \hat{\alpha} & = & \left(\frac{\bar{x} - \hat{a}}{\hat{b} - \hat{a}}\right) \left( \frac{\left(\hat{b} - \bar{x}\right)\left(\bar{x} - \hat{a}\right)}{\hat{\sigma}^2}-1\right) \\
          \hat{\beta}  & = & \left(\frac{\hat{b} - \bar{x}}{\bar{x} - \hat{a}}\right) \hat{\alpha}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Beta

    Examples
    --------

    In the following example, the parameters of a :class:`~openturns.Beta` 
    are estimated from a sample. 

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> size = 10000
    >>> distribution = ot.Beta(0.2, 0.4, -1.0, 2.0)
    >>> sample = distribution.getSample(size)
    >>> factory = ot.BetaFactory()
    >>> estimated_dist = factory.build(sample)
    >>> estimated_beta = factory.buildAsBeta(sample)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BetaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.BetaFactory_build(self, *args)

    def buildAsBeta(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsBeta()

            buildAsBeta(*sample*)

            buildAsBeta(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Beta`.

        Returns
        -------
        dist : :class:`~openturns.Beta`
            The estimated distribution as a Beta.

            In the first usage, the default Bernoulli distribution is built.
        """
        return _dist_bundle1.BetaFactory_buildAsBeta(self, *args)

    def __init__(self, *args):
        _dist_bundle1.BetaFactory_swiginit(self, _dist_bundle1.new_BetaFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_BetaFactory

# Register BetaFactory in _dist_bundle1:
_dist_bundle1.BetaFactory_swigregister(BetaFactory)
class BetaMuSigma(openturns.model_copula.DistributionParametersImplementation):
    r"""
    Beta distribution parameters.

    Parameters
    ----------
    mu : float
        Mean.

        Default value is 0.5.
    sigma : float
        Standard deviation :math:`\sigma > 0`.

        Default value is 0.223607.
    a : float
        Lower bound.

        Default value is 0.0.
    b : float, :math:`b > a`
        Upper bound.

        Default value is 1.0.

    Notes
    -----
    The native parameters  :math:`(\alpha, \beta, a, b)` are defined as follows:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \alpha & = & \left(\dfrac{\mu-a}{b-a}\right) \left( \dfrac{(b-\mu)(\mu-a)}{\sigma^2}-1\right) \\
            \beta & = &  \left( \dfrac{b-\mu}{\mu-a}\right) \alpha
        \end{eqnarray*}

    See also
    --------
    Beta

    Examples
    --------
    Create the parameters  :math:`(\mu, \sigma, a, b)` of the Beta distribution:

    >>> import openturns as ot
    >>> parameters = ot.BetaMuSigma(0.2, 0.6, -1, 2)

    Convert parameters into the native parameters :math:`(\alpha, \beta, a, b)`:

    >>> print(parameters.evaluate())
    [2,3,-1,2]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BetaMuSigma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.BetaMuSigma___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.BetaMuSigma_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle1.BetaMuSigma_gradient(self)

    def __call__(self, inP):
        return _dist_bundle1.BetaMuSigma___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.BetaMuSigma_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.BetaMuSigma_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.BetaMuSigma_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.BetaMuSigma_getDescription(self)

    def isElliptical(self):
        r"""
        Test whether the Beta distribution is elliptical.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        The Beta distribution parametrized by the given :math:`(\mu, \sigma, a, b)`
        is elliptical if :math:`b = 2\mu - a`.
        """
        return _dist_bundle1.BetaMuSigma_isElliptical(self)

    def __repr__(self):
        return _dist_bundle1.BetaMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.BetaMuSigma___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle1.BetaMuSigma_swiginit(self, _dist_bundle1.new_BetaMuSigma(*args))
    __swig_destroy__ = _dist_bundle1.delete_BetaMuSigma

# Register BetaMuSigma in _dist_bundle1:
_dist_bundle1.BetaMuSigma_swigregister(BetaMuSigma)
class Binomial(openturns.model_copula.DistributionImplementation):
    r"""
    Binomial distribution.

    Parameters
    ----------
    n : int, :math:`n \in \Nset`
        The number of Bernoulli trials.

        Default value is 1.
    p : float, :math:`0 \leq p \leq 1`
        The success probability of the Bernoulli trial.

        Default value is 0.5.

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::

        \Prob{X = k} = C_n^k p^k (1-p)^{n-k},
                       \quad \forall k \in \{0, \ldots, n\}

    with :math:`n \in \Nset` and :math:`0 \leq p \leq 1`.
    It is evaluated using  Loader's algorithm, the *fast* and *accurate* method described in [loader2000]_,
    with the further improvements mentioned in [dimitriadis2016]_, see :meth:`~openturns.DistFunc.dBinomial`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & n\,p \\
            \Var{X} & = & n\,p\,(1-p)
        \end{eqnarray*}

    The sampling is done using the rejection algorithm described in [hormann1993]_, see :meth:`~openturns.DistFunc.rBinomial`.

    See Also
    --------
    Bernoulli

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Binomial(10, 0.5)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Binomial_getClassName(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Binomial_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Binomial_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Binomial_isIntegral(self)

    def __eq__(self, *args):
        return _dist_bundle1.Binomial___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Binomial___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Binomial___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Binomial_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Binomial_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Binomial_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Binomial_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Binomial_computeComplementaryCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Binomial_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Binomial_computeCDFGradient(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Binomial_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.Binomial_computeLogCharacteristicFunction(self, x)

    def computeGeneratingFunction(self, z):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input *z*.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle1.Binomial_computeGeneratingFunction(self, z)

    def computeLogGeneratingFunction(self, z):
        r"""
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input *z*.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _dist_bundle1.Binomial_computeLogGeneratingFunction(self, z)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle1.Binomial_getSupport(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Binomial_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Binomial_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Binomial_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Binomial_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Binomial_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Binomial_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Binomial_isElliptical(self)

    def setP(self, p):
        r"""
        Accessor to the success probability parameter.

        Parameters
        ----------
        p : float, :math:`0 \leq p \leq 1`
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle1.Binomial_setP(self, p)

    def getP(self):
        r"""
        Accessor to the success probability parameter.

        Returns
        -------
        p : float
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle1.Binomial_getP(self)

    def setN(self, n):
        r"""
        Accessor to the number of trials.

        Parameters
        ----------
        n : int, :math:`n \in \Nset`
            The number of Bernoulli trials.
        """
        return _dist_bundle1.Binomial_setN(self, n)

    def getN(self):
        r"""
        Accessor to the number of trials.

        Returns
        -------
        n : int
            The number of Bernoulli trials.
        """
        return _dist_bundle1.Binomial_getN(self)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Binomial_computeScalarQuantile(self, prob, tail)

    def __init__(self, *args):
        _dist_bundle1.Binomial_swiginit(self, _dist_bundle1.new_Binomial(*args))
    __swig_destroy__ = _dist_bundle1.delete_Binomial

# Register Binomial in _dist_bundle1:
_dist_bundle1.Binomial_swigregister(Binomial)
class BinomialFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Binomial factory.

    Notes
    -----
    The estimation is done by maximizing the likelihood of the sample.

    | We initialize the value of :math:`(n,p_n)` to
      :math:`\displaystyle\left(\left\lceil\frac{\Hat{x}_n^2}{\Hat{x}_n-\Hat{\sigma}_n^2}\right\rceil, \frac{\Hat{x}_n}{n}\right)`
      where :math:`\Hat{x}_n` is the empirical mean of the sample
      :math:`(x_1, \hdots, x_n)`, and :math:`\Hat{\sigma}_n^2` its unbiased
      empirical variance.
    | Then, we evaluate the likelihood of the sample with respect to the
      Binomial distribution parameterized with
      :math:`\displaystyle\left(\left\lceil\frac{\Hat{x}_n^2}{\Hat{x}_n-\Hat{\sigma}_n^2}\right\rceil, \frac{\Hat{x}_n}{n}\right)`.
      By testing successively :math:`n+1` and :math:`n-1` instead of
      :math:`n`, we determine the variation of the likelihood of the sample
      with respect to the Binomial distribution parameterized with
      :math:`(n+1,p_{n+1})` and :math:`(n-1,p_{n-1})`. We then iterate in
      the direction that makes the likelihood decrease, until the likelihood
      stops decreasing. The last couple is the one selected.

    See also
    --------
    DistributionFactory, Binomial
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BinomialFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.BinomialFactory_build(self, *args)

    def buildAsBinomial(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsBinomial()

            buildAsBinomial(*sample*)

            buildAsBinomial(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Binomial`.

        Returns
        -------
        distribution : :class:`~openturns.Binomial`
            The estimated distribution as a Binomial.

            In the first usage, the default Binomial distribution is built.
        """
        return _dist_bundle1.BinomialFactory_buildAsBinomial(self, *args)

    def __init__(self, *args):
        _dist_bundle1.BinomialFactory_swiginit(self, _dist_bundle1.new_BinomialFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_BinomialFactory

# Register BinomialFactory in _dist_bundle1:
_dist_bundle1.BinomialFactory_swigregister(BinomialFactory)
class Burr(openturns.model_copula.DistributionImplementation):
    r"""
    Burr distribution.

    Parameters
    ----------
    c : float, :math:`c > 0`

        Default value is 1.0.
    k : float, :math:`k > 0`

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = c k \frac{x^{c - 1}}{(1 + x^c)^{k + 1}}, \quad x \in \Rset^{+*}

    with :math:`c, k > 0`.

    Its only, first-order moment is:

    .. math::

        \Expect{X} = k {\rm B}(k - 1 / c, 1 + 1 / c)

    where :math:`\rm B` denotes Euler's beta function.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Burr(2.0, 3.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Burr_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Burr___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Burr___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Burr___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Burr_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Burr_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Burr_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Burr_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Burr_computeCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Burr_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Burr_computeCDFGradient(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.Burr_computeProbability(self, interval)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Burr_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Burr_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Burr_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Burr_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Burr_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Burr_getParameterDescription(self)

    def setC(self, c):
        r"""
        Accessor to the parameter :math:`c`.

        Parameters
        ----------
        c : float, :math:`c > 0`
        """
        return _dist_bundle1.Burr_setC(self, c)

    def getC(self):
        r"""
        Accessor to the parameter :math:`c`.

        Returns
        -------
        c : float
        """
        return _dist_bundle1.Burr_getC(self)

    def setK(self, k):
        r"""
        Accessor to the parameter :math:`k`.

        Parameters
        ----------
        k : float, :math:`k > 0`
        """
        return _dist_bundle1.Burr_setK(self, k)

    def getK(self):
        r"""
        Accessor to the parameter :math:`k`.

        Returns
        -------
        k : float
        """
        return _dist_bundle1.Burr_getK(self)

    def __init__(self, *args):
        _dist_bundle1.Burr_swiginit(self, _dist_bundle1.new_Burr(*args))
    __swig_destroy__ = _dist_bundle1.delete_Burr

# Register Burr in _dist_bundle1:
_dist_bundle1.Burr_swigregister(Burr)
class BurrFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Burr factory.

    Notes
    -----
    The parameter :math:`\Hat{c}_n` is the solution of the following non linear equation:

    .. math::

        \displaystyle 1+\frac{c}{n}\left[ SR - \frac{n}{\sum_{i=1}^n \log(1+x_i^c)}SSR\right] = 0

    where :math:`\displaystyle SR = \displaystyle \sum_{i=1}^n \frac{ \log(x_i)}{1+x_i^c}`
    and :math:`\displaystyle SSR = \displaystyle \sum_{i=1}^n \frac{ x_i^c\log(x_i)}{1+x_i^c}`

    The resolution of this equation can be tuned through
    `BurrFactory-RelativePrecision`, `BurrFactory-ResidualPrecision`,
    `BurrFactory-MaximumIteration` in :class:`~openturns.ResourceMap`

    Then

    .. math::

        \Hat{k}_n =  \frac{n}{\sum_{i=1}^n \log(1+x_i^c)}

    See also
    --------
    DistributionFactory, Burr
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BurrFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.BurrFactory_build(self, *args)

    def buildAsBurr(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsBurr()

            buildAsBurr(*sample*)

            buildAsBurr(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.Burr`.

        Returns
        -------
        dist : :class:`~openturns.Burr`
            The estimated distribution as a Burr.

            In the first usage, the default Burr distribution is built.
        """
        return _dist_bundle1.BurrFactory_buildAsBurr(self, *args)

    def __init__(self, *args):
        _dist_bundle1.BurrFactory_swiginit(self, _dist_bundle1.new_BurrFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_BurrFactory

# Register BurrFactory in _dist_bundle1:
_dist_bundle1.BurrFactory_swigregister(BurrFactory)
class Chi(openturns.model_copula.DistributionImplementation):
    r"""
    :math:`\chi` distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        Degrees of freedom.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{2^{1 - \nu / 2} x^{\nu - 1} \exp(- x^2 / 2)}
                      {\Gamma(\nu / 2)}, \quad x \in \Rset^{+*}

    with :math:`\nu > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \sqrt{2}\,\frac{\Gamma((\nu + 1) / 2)}
                                            {\Gamma(\nu / 2)} \\
            \Var{X} & = & \nu - \mu^2
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Chi(2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Chi_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Chi___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Chi___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Chi___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Chi_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Chi_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Chi_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Chi_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Chi_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Chi_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Chi_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Chi_computeCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Chi_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Chi_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Chi_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.Chi_computeProbability(self, interval)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Chi_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Chi_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Chi_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Chi_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Chi_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Chi_getParameterDescription(self)

    def setNu(self, nu):
        r"""
        Accessor to the degrees of freedom parameter.

        Parameters
        ----------
        nu : float, :math:`\nu > 0`
            Degrees of freedom.
        """
        return _dist_bundle1.Chi_setNu(self, nu)

    def getNu(self):
        r"""
        Accessor to the degrees of freedom parameter.

        Returns
        -------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle1.Chi_getNu(self)

    def __init__(self, *args):
        _dist_bundle1.Chi_swiginit(self, _dist_bundle1.new_Chi(*args))
    __swig_destroy__ = _dist_bundle1.delete_Chi

# Register Chi in _dist_bundle1:
_dist_bundle1.Chi_swigregister(Chi)
class ChiFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Chi factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \Hat{\nu}_n=\bar{x^2}_n
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Chi
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ChiFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.ChiFactory_build(self, *args)

    def buildAsChi(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsChi()

            buildAsChi(*sample*)

            buildAsChi(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Chi`.

        Returns
        -------
        dist : :class:`~openturns.Chi`
            The estimated distribution as a Chi.

            In the first usage, the default Chi distribution is built.
        """
        return _dist_bundle1.ChiFactory_buildAsChi(self, *args)

    def __init__(self, *args):
        _dist_bundle1.ChiFactory_swiginit(self, _dist_bundle1.new_ChiFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_ChiFactory

# Register ChiFactory in _dist_bundle1:
_dist_bundle1.ChiFactory_swigregister(ChiFactory)
class ChiSquare(openturns.model_copula.DistributionImplementation):
    r"""
    :math:`\chi^2` distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        Degrees of freedom.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{2^{- \nu / 2} x^{\nu / 2 - 1} \exp(- x / 2)}
                      {\Gamma(\nu / 2)}, \quad x \in \Rset^{+*}

    with :math:`\nu > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \nu \\
            \Var{X} & = & 2 \nu
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.ChiSquare(2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ChiSquare_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.ChiSquare___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.ChiSquare___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.ChiSquare___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.ChiSquare_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.ChiSquare_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.ChiSquare_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.ChiSquare_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.ChiSquare_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.ChiSquare_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.ChiSquare_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.ChiSquare_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.ChiSquare_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.ChiSquare_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.ChiSquare_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.ChiSquare_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.ChiSquare_computeProbability(self, interval)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.ChiSquare_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.ChiSquare_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.ChiSquare_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.ChiSquare_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.ChiSquare_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.ChiSquare_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.ChiSquare_getParameterDescription(self)

    def setNu(self, nu):
        r"""
        Accessor to the degrees of freedom parameter.

        Parameters
        ----------
        nu : float, :math:`\nu > 0`
            Degrees of freedom.
        """
        return _dist_bundle1.ChiSquare_setNu(self, nu)

    def getNu(self):
        r"""
        Accessor to the degrees of freedom parameter.

        Returns
        -------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle1.ChiSquare_getNu(self)

    def __init__(self, *args):
        _dist_bundle1.ChiSquare_swiginit(self, _dist_bundle1.new_ChiSquare(*args))
    __swig_destroy__ = _dist_bundle1.delete_ChiSquare

# Register ChiSquare in _dist_bundle1:
_dist_bundle1.ChiSquare_swigregister(ChiSquare)
class ChiSquareFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Chi-Square factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \Hat{\nu} = \bar{x}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, ChiSquare
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ChiSquareFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.ChiSquareFactory_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle1.ChiSquareFactory_buildEstimator(self, *args)

    def buildAsChiSquare(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsChiSquare()

            buildAsChiSquare(*sample*)

            buildAsChiSquare(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.ChiSquare`.

        Returns
        -------
        dist : :class:`~openturns.ChiSquare`
            The estimated distribution as a Chi Square.

            In the first usage, the default Chi Square distribution is built.
        """
        return _dist_bundle1.ChiSquareFactory_buildAsChiSquare(self, *args)

    def __init__(self, *args):
        _dist_bundle1.ChiSquareFactory_swiginit(self, _dist_bundle1.new_ChiSquareFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_ChiSquareFactory

# Register ChiSquareFactory in _dist_bundle1:
_dist_bundle1.ChiSquareFactory_swigregister(ChiSquareFactory)
class CompositeDistribution(openturns.model_copula.DistributionImplementation):
    r"""
    Composite distribution.

    Helper class for defining the push-forward distribution of a given univariate
    distribution by a given scalar function.

    Available constructors:
        CompositeDistribution(*g, distX*)

        CompositeDistribution(*g, distX, a, v*)

    Parameters
    ----------
    g : :class:`~openturns.Function`, :math:`\Rset \rightarrow \Rset`
    distX : :class:`~openturns.Distribution`, univariate
    a : sequence of float of dimension :math:`N+1`, :math:`a[0]=\inf \supp{distX}`, :math:`a[N]=\sup \supp{distX}`
        The bounds of the intervals on which :math:`g` is monotone, sorted in
        ascending order.
    v : sequence of float of dimension :math:`N+1`,
        The values taken by :math:`g` on each bound: :math:`v[k]=g(a[k])`.

    Returns
    -------
    distY : :class:`~openturns.Distribution`, univariate
        :math:`distY` is the push-forward distribution of :math:`distX` by :math:`g`.


    Notes
    -----
    We note :math:`X` a scalar random variable which distribution is :math:`distX`,
    which probability density function is :math:`f_X`.

    Then :math:`distY` is the distribution of the scalar random variable
    :math:`Y=g(X)`, which probability density function :math:`f_Y` is defined as:

    .. math::

        \displaystyle f_Y(y) = \sum_{k =0}^{k=N} \frac{f_X (g^{-1}(y))}{|g'\circ g^{-1}(y)|}1_{y \in g([a_k, a_{k+1}))}

    with :math:`a_0=\inf \supp{f_X}`, :math:`a_N=\sup \supp{f_X}` and
    :math:`(a_1, \dots, a_N)` such that :math:`g` is monotone over
    :math:`[a_k, a_{k+1})` for :math:`0 \leq k \leq N`.

    Its first moments are obtained by numerical integration.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> g = ot.SymbolicFunction(['x'], ['sin(x) + cos(x)'])
    >>> distY = ot.CompositeDistribution(g, ot.Normal(1.0, 0.5))

    >>> g = ot.SymbolicFunction(['x'], ['abs(x)'])
    >>> a = [-1.0, 0.0, 2.0]
    >>> v = [1.0, 0.0, 2.0]
    >>> distZ = ot.CompositeDistribution(g, ot.Uniform(-1.0, 2.0), a, v)

    >>> distX = ot.Normal(0.0, 1.0)
    >>> a0 = distX.getRange().getLowerBound()
    >>> aN = distX.getRange().getUpperBound()
    >>> a = [a0[0], 0.0, 0.0, aN[0]]
    >>> g = ot.SymbolicFunction(['x'], ['1.0/x'])
    >>> v = [g(a0)[0], -ot.SpecFunc.Infinity, ot.SpecFunc.Infinity, g(aN)[0]]
    >>> distT = ot.CompositeDistribution(g, distX, a, v)


    Draw a sample:

    >>> sample = distT.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.CompositeDistribution_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.CompositeDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.CompositeDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.CompositeDistribution___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.CompositeDistribution_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.CompositeDistribution_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.CompositeDistribution_computeCDF(self, *args)

    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _dist_bundle1.CompositeDistribution_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle1.CompositeDistribution_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities
        (i.e. discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle1.CompositeDistribution_getSingularities(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.CompositeDistribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.CompositeDistribution_setParametersCollection(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.CompositeDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.CompositeDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.CompositeDistribution_getParameterDescription(self)

    def setFunction(self, function):
        r"""
        Fix the function through which the distribution is push-forwarded.

        Parameters
        ----------
        g :  :class:`~openturns.Function`, :math:`\Rset \rightarrow \Rset`
            the function :math:`g`.
        """
        return _dist_bundle1.CompositeDistribution_setFunction(self, function)

    def getFunction(self):
        r"""
        Accessor to the function.

        Returns
        -------
        g :  :class:`~openturns.Function`, :math:`\Rset \rightarrow \Rset`
            the function :math:`g`.
        """
        return _dist_bundle1.CompositeDistribution_getFunction(self)

    def setAntecedent(self, antecedent):
        r"""
        Fix the antecedent distribution which is push-forwarded.

        Parameters
        ----------
        distX : :class:`~openturns.Distribution`, univariate
           Distribution of the antecedent :math:`distX`.
        """
        return _dist_bundle1.CompositeDistribution_setAntecedent(self, antecedent)

    def getAntecedent(self):
        r"""
        Accessor to the antecedent distribution.

        Returns
        -------
        distX : :class:`~openturns.Distribution`, univariate
            Antecedent distribution :math:`distX`.
        """
        return _dist_bundle1.CompositeDistribution_getAntecedent(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.CompositeDistribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.CompositeDistribution_isDiscrete(self)

    def setSolver(self, solver):
        r"""
        Solver accessor.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            The solver used for PDF/CDF computations.

        """
        return _dist_bundle1.CompositeDistribution_setSolver(self, solver)

    def getSolver(self):
        r"""
        Solver accessor.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            The solver used for PDF/CDF computations.

        """
        return _dist_bundle1.CompositeDistribution_getSolver(self)

    def __init__(self, *args):
        _dist_bundle1.CompositeDistribution_swiginit(self, _dist_bundle1.new_CompositeDistribution(*args))
    __swig_destroy__ = _dist_bundle1.delete_CompositeDistribution

# Register CompositeDistribution in _dist_bundle1:
_dist_bundle1.CompositeDistribution_swigregister(CompositeDistribution)
class Dirac(openturns.model_copula.DistributionImplementation):
    r"""
    Dirac distribution.


    Parameters
    ----------
    x : float, sequence of float, :math:`\vect{x} \in \Rset^n`
        The deterministic value.

        Default is 0.0.

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::

        \Prob{\vect{X} = \vect{x}} = 1

    with :math:`\vect{x} \in \Rset^n`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{\vect{X}} & = & \vect{x} \\
            \Var{X_i} & = & 0, \quad i = 1, \ldots, n
        \end{eqnarray*}

    This distribution can be used to model deterministic parameters.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Dirac([1.0, 2.0, 3.0])

    Draw a sample:

    >>> sample = distribution.getSample(2)
    >>> sample[0] == sample[1]
    True
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Dirac_getClassName(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Dirac_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Dirac_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Dirac_isIntegral(self)

    def __eq__(self, *args):
        return _dist_bundle1.Dirac___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Dirac___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Dirac___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Dirac_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Dirac_getSample(self, size)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Dirac_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Dirac_computeCDF(self, *args)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _dist_bundle1.Dirac_computeQuantile(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Dirac_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Dirac_computeCDFGradient(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Dirac_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Dirac_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.Dirac_computeLogCharacteristicFunction(self, x)

    def computeGeneratingFunction(self, z):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input *z*.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle1.Dirac_computeGeneratingFunction(self, z)

    def computeLogGeneratingFunction(self, z):
        r"""
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input *z*.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _dist_bundle1.Dirac_computeLogGeneratingFunction(self, z)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle1.Dirac_getSupport(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Dirac_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Dirac_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Dirac_getKurtosis(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.Dirac_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.Dirac_setParametersCollection(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Dirac_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Dirac_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Dirac_getParameterDescription(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle1.Dirac_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Dirac_hasIndependentCopula(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Dirac_isElliptical(self)

    def setPoint(self, point):
        r"""
        Accessor to the distribution's unique value.

        Parameters
        ----------
        x : float, sequence of float, :math:`\vect{x} \in \Rset^n`
            The deterministic value.
        """
        return _dist_bundle1.Dirac_setPoint(self, point)

    def getPoint(self):
        r"""
        Accessor to the distribution's unique value.

        Returns
        -------
        x : float, :class:`~openturns.Point`
            The deterministic value.
        """
        return _dist_bundle1.Dirac_getPoint(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle1.Dirac_getMarginal(self, *args)

    def __init__(self, *args):
        _dist_bundle1.Dirac_swiginit(self, _dist_bundle1.new_Dirac(*args))
    __swig_destroy__ = _dist_bundle1.delete_Dirac

# Register Dirac in _dist_bundle1:
_dist_bundle1.Dirac_swigregister(Dirac)
class DiracFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Dirac factory.

    Notes
    -----
    Can only estimate the parameter from a sample that contains the same point.

    See also
    --------
    DistributionFactory, Dirac
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.DiracFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.DiracFactory_build(self, *args)

    def buildAsDirac(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsDirac()

            buildAsDirac(*sample*)

            buildAsDirac(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Dirac`.

        Returns
        -------
        distribution : :class:`~openturns.Dirac`
            The estimated distribution as a :class:`openturns.Dirac`.

            In the first usage, the default :class:`openturns.Dirac` distribution is built.
        """
        return _dist_bundle1.DiracFactory_buildAsDirac(self, *args)

    def __init__(self, *args):
        _dist_bundle1.DiracFactory_swiginit(self, _dist_bundle1.new_DiracFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_DiracFactory

# Register DiracFactory in _dist_bundle1:
_dist_bundle1.DiracFactory_swigregister(DiracFactory)
class Dirichlet(openturns.model_copula.DistributionImplementation):
    r"""
    Dirichlet distribution.

    Parameters
    ----------
    theta : sequence of float, optional
            :math:`\vect{\theta}` must be at least bidimensional
            with :math:`\theta_i > 0, i = 1, \ldots, n+1`.
            Default value is [1.0, 1.0].

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::

        f_{\vect{X}}(\vect{x}) = \frac{\Gamma(|\vect{\theta}|_1)}
                                      {\prod_{j=1}^{n + 1} \Gamma(\theta_j)}
                                 \left[1 - \sum_{j=1}^{n} x_j
                                       \right]^{\theta_{n+1} - 1}
                                 \prod_{j=1}^n x_j^{\theta_j - 1},
                                 \quad \vect{x} \in \Delta(\vect{X})

    with :math:`\Delta(\vect{X}) = \{ \vect{x} \in \Rset^n : x_i \geq 0, \sum_{i=1}^n x_i \leq 1, i = 1, \ldots, n \}`
    and :math:`\theta_i > 0, i = 1, \ldots, n+1` and where :math:`|\vect{\theta}|_1 = \sum_{i=1}^{n+1} \theta_i`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{\vect{X}} & = & \Tr{(\theta_i/|\vect{\theta}|_1,
                                         \quad i = 1, \ldots, n)} \\
            \Cov{\vect{X}} & = & \left[- \frac{\theta_i \theta_j}
                                              {|\vect{\theta}|_1^2
                                               (|\vect{\theta}|_1+1)},
                                       \quad i,j = 1, \ldots, n \right]
        \end{eqnarray*}

    .. warning::
        The present implementation does not model the :math:`n+1`-th component of
        the Dirichlet distribution as it is fixed:

        .. math::

            X_{n + 1} = 1 - \sum_{i=1}^{n} X_i

    See Also
    --------
    Multinomial

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Dirichlet([1.0, 1.0, 1.0])

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Dirichlet_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Dirichlet___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Dirichlet___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Dirichlet___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Dirichlet_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Dirichlet_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Dirichlet_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Dirichlet_computeCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Dirichlet_computeEntropy(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Dirichlet_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Dirichlet_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Dirichlet_getKurtosis(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.Dirichlet_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.Dirichlet_setParametersCollection(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Dirichlet_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Dirichlet_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Dirichlet_getParameterDescription(self)

    def setTheta(self, theta):
        r"""
        Accessor to the distribution's vector parameter.

        Parameters
        ----------
        theta : float, sequence of float, :math:`\theta_i > 0, i = 1, \ldots, n+1`
        """
        return _dist_bundle1.Dirichlet_setTheta(self, theta)

    def getTheta(self):
        r"""
        Accessor to the distribution's vector parameter.

        Returns
        -------
        theta : float, :class:`~openturns.Point`
        """
        return _dist_bundle1.Dirichlet_getTheta(self)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle1.Dirichlet_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _dist_bundle1.Dirichlet_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _dist_bundle1.Dirichlet_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _dist_bundle1.Dirichlet_computeSequentialConditionalCDF(self, x)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle1.Dirichlet_computeConditionalQuantile(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        p : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Sequence of conditional quantiles values at *p*

        Notes
        -----
        The sequential conditional quantile function is defined by:

        .. math::

            \left(F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p_j; x_1, \dots, x_{j-1})\right)_{i=1,\ldots,d}

        where :math:`F^{-1}` is the quantile function and
        where :math:`x_1,\ldots,x_{j-1}` are defined recursively as :math:`x_1=F_1^{-1}(p_1)` and for :math:`2\leq j \leq d`,
        :math:`x_j=F_{X_j}^{-1}(p_j|X_1=x_1,\ldots,X_{j-1}=x_{j-1})`: the conditioning part is the set of already
        computed conditional quantiles.
        """
        return _dist_bundle1.Dirichlet_computeSequentialConditionalQuantile(self, q)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle1.Dirichlet_getMarginal(self, *args)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Dirichlet_hasIndependentCopula(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle1.Dirichlet_hasEllipticalCopula(self)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _dist_bundle1.Dirichlet_getSpearmanCorrelation(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _dist_bundle1.Dirichlet_getKendallTau(self)

    def __init__(self, *args):
        _dist_bundle1.Dirichlet_swiginit(self, _dist_bundle1.new_Dirichlet(*args))
    __swig_destroy__ = _dist_bundle1.delete_Dirichlet

# Register Dirichlet in _dist_bundle1:
_dist_bundle1.Dirichlet_swigregister(Dirichlet)
class DirichletFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Dirichlet factory.

    Notes
    -----
    The estimation is done by maximizing the likelihood of the sample,
    using the algorithm described in [minka2012]_.

    See also
    --------
    DistributionFactory, Dirichlet
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.DirichletFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.DirichletFactory_build(self, *args)

    def buildAsDirichlet(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsDirichlet()

            buildAsDirichlet(*sample*)

            buildAsDirichlet(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Dirichlet`.

        Returns
        -------
        dist : :class:`~openturns.Dirichlet`
            The estimated distribution as a :class:`openturns.Dirichlet`.

            In the first usage, the default :class:`openturns.Dirichlet` distribution is built.
        """
        return _dist_bundle1.DirichletFactory_buildAsDirichlet(self, *args)

    def __init__(self, *args):
        _dist_bundle1.DirichletFactory_swiginit(self, _dist_bundle1.new_DirichletFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_DirichletFactory

# Register DirichletFactory in _dist_bundle1:
_dist_bundle1.DirichletFactory_swigregister(DirichletFactory)
class DiscreteCompoundDistribution(openturns.model_copula.DistributionImplementation):
    r"""
    Discrete compound distribution.

    Parameters
    ----------
    base_distribution : :class:`~openturns.Distribution`
        Integer-valued distribution of the summed independent random variables
    compound_distribution : :class:`~openturns.Distribution`
        Integer-valued distribution of the number of summed terms :math:`N`

    Notes
    -----
    Probability distribution of the random variable :math:`Y(\omega)` defined as:

    .. math::

        Y(\omega) = \sum_{k=1}^{N(\omega)} X_i(\omega)

    where the :math:`X_i \; (i \in \mathbb{N}\setminus{0})` are independent
    identically distribution random variables following base_distribution
    and :math:`N` is a random variable following compound_distribution that is
    independent from all :math:`X_i \; (i \in \mathbb{N}\setminus{0})`.

    See Also
    --------
    Poisson

    Examples
    --------
    Create a discrete compound distribution from a Bernoulli distribution with parameter :math:`p=0.5`
    and a Poisson distribution with parameter :math:`\lambda=10`.
    This is mathematically equivalent to a Poisson distribution with parameter :math:`\lambda=5`.

    >>> import openturns as ot
    >>> distribution = ot.DiscreteCompoundDistribution(ot.Bernoulli(0.5), ot.Poisson(10.0))

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.DiscreteCompoundDistribution_getClassName(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.DiscreteCompoundDistribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.DiscreteCompoundDistribution_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.DiscreteCompoundDistribution_isIntegral(self)

    def __eq__(self, *args):
        return _dist_bundle1.DiscreteCompoundDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.DiscreteCompoundDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.DiscreteCompoundDistribution___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.DiscreteCompoundDistribution_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.DiscreteCompoundDistribution_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.DiscreteCompoundDistribution_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.DiscreteCompoundDistribution_computeComplementaryCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.DiscreteCompoundDistribution_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.DiscreteCompoundDistribution_computeCDFGradient(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.DiscreteCompoundDistribution_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.DiscreteCompoundDistribution_computeCharacteristicFunction(self, x)

    def computeGeneratingFunction(self, z):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input *z*.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle1.DiscreteCompoundDistribution_computeGeneratingFunction(self, z)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle1.DiscreteCompoundDistribution_getSupport(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.DiscreteCompoundDistribution_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.DiscreteCompoundDistribution_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.DiscreteCompoundDistribution_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.DiscreteCompoundDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.DiscreteCompoundDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.DiscreteCompoundDistribution_getParameterDescription(self)

    def getBaseDistribution(self):
        r"""
        Base distribution accessor.

        Returns
        -------
        base_distribution : :class:`~openturns.Distribution`
            Integer-valued distribution of the summed independent random variables
        """
        return _dist_bundle1.DiscreteCompoundDistribution_getBaseDistribution(self)

    def getCompoundDistribution(self):
        r"""
        Compound distribution accessor.

        Returns
        -------
        compound_distribution : :class:`~openturns.Distribution`
            Integer-valued distribution of the number of summed terms :math:`N`
        """
        return _dist_bundle1.DiscreteCompoundDistribution_getCompoundDistribution(self)

    def __init__(self, *args):
        _dist_bundle1.DiscreteCompoundDistribution_swiginit(self, _dist_bundle1.new_DiscreteCompoundDistribution(*args))
    __swig_destroy__ = _dist_bundle1.delete_DiscreteCompoundDistribution

# Register DiscreteCompoundDistribution in _dist_bundle1:
_dist_bundle1.DiscreteCompoundDistribution_swigregister(DiscreteCompoundDistribution)
class Epanechnikov(openturns.model_copula.DistributionImplementation):
    r"""
    Epanechnikov distribution.

    Notes
    -----

    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{3}{4}\,(1 - x^2), \quad x \in [-1; 1]

    It has no parameters and is intended to be used as a kernel within a
    :class:`~openturns.KernelSmoothing`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & 0 \\
            \Var{X} & = & \frac{1}{5}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Epanechnikov()

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Epanechnikov_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Epanechnikov___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Epanechnikov___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Epanechnikov___str__(self, *args)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Epanechnikov_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Epanechnikov_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Epanechnikov_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Epanechnikov_computeComplementaryCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Epanechnikov_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Epanechnikov_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Epanechnikov_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.Epanechnikov_computeProbability(self, interval)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Epanechnikov_computeEntropy(self)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle1.Epanechnikov_getRoughness(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Epanechnikov_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Epanechnikov_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Epanechnikov_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.Epanechnikov_getStandardRepresentative(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Epanechnikov_isElliptical(self)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Epanechnikov_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Epanechnikov_getParameterDescription(self)

    def __init__(self, *args):
        _dist_bundle1.Epanechnikov_swiginit(self, _dist_bundle1.new_Epanechnikov(*args))
    __swig_destroy__ = _dist_bundle1.delete_Epanechnikov

# Register Epanechnikov in _dist_bundle1:
_dist_bundle1.Epanechnikov_swigregister(Epanechnikov)
class Exponential(openturns.model_copula.DistributionImplementation):
    r"""
    Exponential distribution.

    Parameters
    ----------
    lambda : float, :math:`\lambda > 0`
        Rate parameter.

        Default value is 1.0.
    gamma : float, optional
        Location parameter :math:`\gamma`.

        Default value is 0.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \lambda \exp\left(- \lambda\,(x - \gamma)\right),
                 \quad x \in [\gamma; +\infty[

    with :math:`\lambda > 0` and :math:`\gamma \in \Rset`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \gamma + \frac{1}{\lambda} \\
            \Var{X} & = & \frac{1}{\lambda^2}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Exponential(1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Exponential_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Exponential___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Exponential___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Exponential___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Exponential_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Exponential_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Exponential_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Exponential_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Exponential_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Exponential_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Exponential_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Exponential_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.Exponential_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Exponential_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Exponential_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Exponential_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.Exponential_computeProbability(self, interval)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Exponential_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Exponential_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Exponential_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.Exponential_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Exponential_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Exponential_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Exponential_getParameterDescription(self)

    def setLambda(self, _lambda):
        r"""
        Accessor to the rate parameter.

        Parameters
        ----------
        lambda : float, :math:`\lambda > 0`
            Failure rate parameter.
        """
        return _dist_bundle1.Exponential_setLambda(self, _lambda)

    def getLambda(self):
        r"""
        Accessor to the rate parameter.

        Returns
        -------
        lambda : float
            Rate parameter.
        """
        return _dist_bundle1.Exponential_getLambda(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the location parameter.

        Parameters
        ----------
        gamma : float, :math:`\gamma \in \Rset`
            Shift parameter.
        """
        return _dist_bundle1.Exponential_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the location parameter.

        Returns
        -------
        gamma : float
            Shift parameter.
        """
        return _dist_bundle1.Exponential_getGamma(self)

    def __init__(self, *args):
        _dist_bundle1.Exponential_swiginit(self, _dist_bundle1.new_Exponential(*args))
    __swig_destroy__ = _dist_bundle1.delete_Exponential

# Register Exponential in _dist_bundle1:
_dist_bundle1.Exponential_swigregister(Exponential)
class ExponentialFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Exponential factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \Hat{\gamma}_n = x_{(1,n)} - \frac{|x_{(1,n)}|}{2+n}\\
          \displaystyle \Hat{\lambda}_n= \frac{1}{\bar{x}_n-\Hat{\gamma}_n}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Exponential
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ExponentialFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.ExponentialFactory_build(self, *args)

    def buildAsExponential(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsExponential()

            buildAsExponential(*sample*)

            buildAsExponential(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Exponential`.

        Returns
        -------
        dist : :class:`~openturns.Exponential`
            The estimated distribution as a Exponential.

            In the first usage, the default Exponential distribution is built.
        """
        return _dist_bundle1.ExponentialFactory_buildAsExponential(self, *args)

    def __init__(self, *args):
        _dist_bundle1.ExponentialFactory_swiginit(self, _dist_bundle1.new_ExponentialFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_ExponentialFactory

# Register ExponentialFactory in _dist_bundle1:
_dist_bundle1.ExponentialFactory_swigregister(ExponentialFactory)
class ExtremeValueCopula(openturns.model_copula.DistributionImplementation):
    r"""
    ExtremeValue copula.

    Parameters
    ----------
    pickandFunction : :class:`~openturns.Function`
        Parameter :math:`A`, the Pickand function defining the extreme value copula.

        Default value is the constant function equal to 1.

    Notes
    -----
    The ExtremeValue copula is a bivariate copula defined by:

    .. math::

        C(u_1, u_2) = \exp\left[\log(u_1u_2)A\left(\dfrac{\log u_2}{\log u_1u_2}\right)\right]

    for :math:`(u_1, u_2) \in [0, 1]^2`

    Where :math:`A` is a convex function satisfying :math:`A(0)=A(1)=1`, :math:`\max(t, 1-t)\leq A(t)\leq 1`.

    See also
    --------
    Distribution

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.ExtremeValueCopula(ot.SymbolicFunction('t', '1'))

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ExtremeValueCopula_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.ExtremeValueCopula___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.ExtremeValueCopula___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.ExtremeValueCopula___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.ExtremeValueCopula_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.ExtremeValueCopula_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.ExtremeValueCopula_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.ExtremeValueCopula_computeCDF(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _dist_bundle1.ExtremeValueCopula_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle1.ExtremeValueCopula_computeConditionalQuantile(self, *args)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.ExtremeValueCopula_hasIndependentCopula(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.ExtremeValueCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.ExtremeValueCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.ExtremeValueCopula_getParameterDescription(self)

    def setPickandFunction(self, *args):
        r"""
        Set the Pickand function :math:`A`.

        Parameters
        ----------
        A : :class:`~openturns.Function`
            The Pickand function of the copula. It must be a convex function :math:`A` such that :math:`\forall t\in[0,1],\:\max(t, 1-t)\leq A(t)\leq 1`.
        check : bool
            Flag to tell if the properties of a Pickand function are verified by the given function. Default value is *True*, given by the *ExtremeValueCopula-CheckPickandFunction* entry in the :class:`~openturns.ResourceMap`, and the test is done pointwise on a regular grid of size given by the *ExtremeValueCopula-CheckGridSize* entry in the :class:`~openturns.ResourceMap`.

        """
        return _dist_bundle1.ExtremeValueCopula_setPickandFunction(self, *args)

    def getPickandFunction(self):
        r"""
        Get the Pickand function :math:`A`.

        Returns
        -------
        A : :class:`~openturns.Function`
            The Pickand function :math:`A` of the copula.
        """
        return _dist_bundle1.ExtremeValueCopula_getPickandFunction(self)

    def __init__(self, *args):
        _dist_bundle1.ExtremeValueCopula_swiginit(self, _dist_bundle1.new_ExtremeValueCopula(*args))
    __swig_destroy__ = _dist_bundle1.delete_ExtremeValueCopula

# Register ExtremeValueCopula in _dist_bundle1:
_dist_bundle1.ExtremeValueCopula_swigregister(ExtremeValueCopula)
class JoeCopula(ExtremeValueCopula):
    r"""
    Joe copula.

    Parameters
    ----------
    theta : float
        Parameter :math:`\theta > 0`.

        Default value is 0.5.
    psi1 : float
        Parameter :math:`\psi_1 \in [0, 1]`.

        Default value is 0.5.
    psi2 : float
        Parameter :math:`\psi_2 \in [0, 1]`.

        Default value is 0.5.

    Notes
    -----
    The Joe copula is a bivariate copula defined by:

    .. math::

        C(u_1, u_2) = \exp\left[\log(u_1u_2)A\left(\dfrac{\log u_2}{\log u_1u_2}\right)\right]

    for :math:`(u_1, u_2) \in [0, 1]^2`

    Where :math:`A` is the following Pickand function 
    :math:`t \in [0,1]`, :math:`A(t) = 1 - [ (\psi_1 (1-t))^{-1/ \theta} + (\psi_2 t)^{-1/ \theta} ]^{- \theta}`

    See also
    --------
    ExtremeValueCopula

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.JoeCopula(0.5)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.JoeCopula_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.JoeCopula___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.JoeCopula___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.JoeCopula___str__(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.JoeCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.JoeCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.JoeCopula_getParameterDescription(self)

    def setTheta(self, theta):
        r"""
        Set the Joe copula parameter :math:`\theta`.

        Parameters
        ----------
        theta : float
            The scalar parameter :math:`\theta > 0`.

        """
        return _dist_bundle1.JoeCopula_setTheta(self, theta)

    def getTheta(self):
        r"""
        Get the Joe copula parameter :math:`\theta`.

        Returns
        -------
        theta : float
            The scalar parameter :math:`\theta > 0`.

        """
        return _dist_bundle1.JoeCopula_getTheta(self)

    def setPsi1(self, psi1):
        r"""
        Set the Joe copula parameter :math:`\psi_1`.

        Parameters
        ----------
        psi1 : float
            The scalar parameter :math:`\psi_1 \in [0, 1]`.

        """
        return _dist_bundle1.JoeCopula_setPsi1(self, psi1)

    def getPsi1(self):
        r"""
        Get the Joe copula parameter :math:`\psi_1`.

        Returns
        -------
        psi1 : float
            The scalar parameter :math:`\psi_1 \in [0, 1]`.

        """
        return _dist_bundle1.JoeCopula_getPsi1(self)

    def setPsi2(self, psi2):
        r"""
        Set the Joe copula parameter :math:`\psi_2`.

        Parameters
        ----------
        psi2 : float
            The scalar parameter :math:`\psi_2 \in [0, 1]`.

        """
        return _dist_bundle1.JoeCopula_setPsi2(self, psi2)

    def getPsi2(self):
        r"""
        Get the Joe copula parameter :math:`\psi_2`.

        Returns
        -------
        psi2 : float
            The scalar parameter :math:`\psi_2 \in [0, 1]`.

        """
        return _dist_bundle1.JoeCopula_getPsi2(self)

    def __init__(self, *args):
        _dist_bundle1.JoeCopula_swiginit(self, _dist_bundle1.new_JoeCopula(*args))
    __swig_destroy__ = _dist_bundle1.delete_JoeCopula

# Register JoeCopula in _dist_bundle1:
_dist_bundle1.JoeCopula_swigregister(JoeCopula)
class FisherSnedecor(openturns.model_copula.DistributionImplementation):
    r"""
    Fisher-Snedecor distribution.

    Parameters
    ----------
    d1 : float, :math:`d_1 > 0`
        First :class:`~openturns.ChiSquare` degrees of freedom (numerator).

        Default value is 1.0.
    d2 : float, :math:`d_2 > 0`
        Second :class:`~openturns.ChiSquare` degrees of freedom (denominator).

        Default value is 5.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{1}{x {\rm B}(d_1 / 2, d_2 / 2)}
                 \left[\left(\frac{d_1 x}{d_1 x + d_2}\right)^{d_1 / 2}
                       \left(1 - \frac{d_1 x}{d_1 x + d_2}\right)^{d_2 / 2}\right],
                 \quad x \in \Rset^{+*}

    with :math:`d_1, d_2 > 0` and where :math:`\rm B` denotes Euler's beta
    function.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \frac{d_2}{d_2 - 2} \textrm{ if } d_2>2\\
            \Var{X} & = & \frac{2d_2^2(d_1+d_2-2)}{d_1(d_2-2)^2(d_2-4)} \textrm{ if } d_2>4
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.FisherSnedecor(2.0, 3.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.FisherSnedecor_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.FisherSnedecor___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.FisherSnedecor___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.FisherSnedecor___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.FisherSnedecor_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.FisherSnedecor_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.FisherSnedecor_computeLogPDF(self, *args)

    def computeLogPDFGradient(self, *args):
        r"""
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input *x*.
        """
        return _dist_bundle1.FisherSnedecor_computeLogPDFGradient(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.FisherSnedecor_computePDFGradient(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.FisherSnedecor_computeCDF(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.FisherSnedecor_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.FisherSnedecor_computeProbability(self, interval)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.FisherSnedecor_computeEntropy(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.FisherSnedecor_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.FisherSnedecor_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.FisherSnedecor_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.FisherSnedecor_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.FisherSnedecor_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.FisherSnedecor_getParameterDescription(self)

    def setD1(self, d1):
        r"""
        Accessor to the parameter :math:`d_1`.

        Parameters
        ----------
        d1 : float, :math:`d_1 > 0`
            First :class:`~openturns.ChiSquare` degrees of freedom (numerator).
        """
        return _dist_bundle1.FisherSnedecor_setD1(self, d1)

    def getD1(self):
        r"""
        Accessor to the parameter :math:`d_1`.

        Returns
        -------
        d1 : float
            First :class:`~openturns.ChiSquare` degrees of freedom (numerator).
        """
        return _dist_bundle1.FisherSnedecor_getD1(self)

    def setD2(self, d2):
        r"""
        Accessor to the parameter :math:`d_2`.

        Parameters
        ----------
        d2 : float, :math:`d_2 > 0`
            Second :class:`~openturns.ChiSquare` degrees of freedom (denominator).
        """
        return _dist_bundle1.FisherSnedecor_setD2(self, d2)

    def getD2(self):
        r"""
        Accessor to the parameter :math:`d_2`.

        Returns
        -------
        d2 : float
            Second :class:`~openturns.ChiSquare` degrees of freedom (denominator).
        """
        return _dist_bundle1.FisherSnedecor_getD2(self)

    def __init__(self, *args):
        _dist_bundle1.FisherSnedecor_swiginit(self, _dist_bundle1.new_FisherSnedecor(*args))
    __swig_destroy__ = _dist_bundle1.delete_FisherSnedecor

# Register FisherSnedecor in _dist_bundle1:
_dist_bundle1.FisherSnedecor_swigregister(FisherSnedecor)
class FisherSnedecorFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Fisher-Snedecor factory.

    Notes
    -----
    Several estimators to build a FisherSnedecor distribution from a scalar sample
    are proposed. The default strategy is using the maximum likelihood estimators.

    **Maximum likelihood estimator:**

    The parameters are estimated by numerical maximum likelihood estimation. 
    The starting point of the optimization algorithm is based on the moment based 
    estimator. 

    The optimization sets lower bounds for the :math:`d_1` and :math:`d_2` parameters 
    in order to ensure that :math:`d_1>0` and :math:`d_2>0`. 
    The default values for these lower bounds are from the :class:`~openturns.ResourceMap` 
    keys `FisherSnedecorFactory-D1LowerBound` and `FisherSnedecorFactory-D2LowerBound`. 

    **Moment based estimator:**

    Lets denote:

    - :math:`\displaystyle \overline{x}_n = \frac{1}{n} \sum_{i=1}^n x_i` the empirical
      mean of the sample, 
    - :math:`\displaystyle s_n^2 = \frac{1}{n-1} \sum_{i=1}^n (x_i - \overline{x}_n)^2`
      its empirical variance,

    We first compute :math:`d_2`:

    .. math::

        d_2 = \frac{2 \overline{x}_n}{\overline{x}_n-1}

    if :math:`\overline{x}_n>1` (otherwise, the moment based estimator fails). 

    Then we compute :math:`d_1`:

    .. math::

        d_1 = \frac{2 d_2^2 (d_2-2)}{(d_2-2)^2 (d_2-4)s_n^2 - 2d_2^2}

    if :math:`s_n^2>0` (otherwise, the moment based estimator fails). 


    See also
    --------
    DistributionFactory, FisherSnedecor

    Examples
    --------

    In the following example, the parameters of a :class:`~openturns.FisherSnedecor` 
    are estimated from a sample. 

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> size = 10000
    >>> distribution = ot.FisherSnedecor(4.5, 8.4)
    >>> sample = distribution.getSample(size)
    >>> factory = ot.FisherSnedecorFactory()
    >>> estimated = factory.build(sample)
    >>> estimated = factory.buildMethodOfMoments(sample)
    >>> estimated = factory.buildMethodOfLikelihoodMaximization(sample)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.FisherSnedecorFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.FisherSnedecorFactory_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle1.FisherSnedecorFactory_buildEstimator(self, *args)

    def buildAsFisherSnedecor(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsFisherSnedecor()

            buildAsFisherSnedecor(*sample*)

            buildAsFisherSnedecor(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float,
           The parameters of the :class:`~openturns.FisherSnedecor`.

        Returns
        -------
        distribution : :class:`~openturns.FisherSnedecor`
            The estimated distribution as a FisherSnedecor.

            In the first usage, the default FisherSnedecor distribution is built.
        """
        return _dist_bundle1.FisherSnedecorFactory_buildAsFisherSnedecor(self, *args)

    def buildMethodOfMoments(self, sample):
        r"""
        Method of moments estimator.


        Parameters
        ----------
        sample :  2-d sequence of float
            Data.

        Returns
        -------
        distribution : :class:`~openturns.FisherSnedecor`
            The estimated distribution.
        """
        return _dist_bundle1.FisherSnedecorFactory_buildMethodOfMoments(self, sample)

    def buildMethodOfLikelihoodMaximization(self, sample):
        r"""
        Method of likelihood maximization.

        Refer to :class:`~openturns.MaximumLikelihoodFactory`.

        Parameters
        ----------
        sample :  2-d sequence of float
            Data.

        Returns
        -------
        distribution : :class:`~openturns.FisherSnedecor`
            The estimated distribution.
        """
        return _dist_bundle1.FisherSnedecorFactory_buildMethodOfLikelihoodMaximization(self, sample)

    def __init__(self, *args):
        _dist_bundle1.FisherSnedecorFactory_swiginit(self, _dist_bundle1.new_FisherSnedecorFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_FisherSnedecorFactory

# Register FisherSnedecorFactory in _dist_bundle1:
_dist_bundle1.FisherSnedecorFactory_swigregister(FisherSnedecorFactory)
class Frechet(openturns.model_copula.DistributionImplementation):
    r"""
    Frechet distribution.

    Parameters
    ----------
    beta : float, :math:`\beta > 0`
        Scale parameter.

        Default value is 1.0.
    alpha : float, :math:`\alpha > 0`
        Shape parameter.

        Default value is 1.0.
    gamma : float, optional
        Location parameter.

        Default value is 0.0.

    Notes
    -----
    Its cumulative distribution function and its probability density function are defined as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            F_X(x) & = & \exp\left(-\left(\frac{x-\gamma}{\beta}\right)^{-\alpha}\right), \quad x \in [ \gamma; +\infty) \\
            f_X(x) & = & \frac{\alpha}{\beta}\left(\frac{x-\gamma}{\beta}\right)^{-1-\alpha}\exp\left(-\left(\frac{x-\gamma}{\beta}\right)^{-\alpha}\right),
                 \quad x \in [ \gamma; +\infty)
        \end{eqnarray*}

    with :math:`\beta > 0` and :math:`\alpha > 0`.


    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \gamma + \beta \,\Gamma\left(1 - \frac{1}{\alpha}\right)
                            \quad \text{ if } \alpha > 1\\
                       & = & +\infty  \quad\text{ if } \alpha \leq 1\\
            \Var{X} & = & \beta^2 \left( \Gamma \left( 1 - \frac{2}{\alpha} \right) -
                         \Gamma^2 \left( 1 - \frac{1}{\alpha} \right) \right) \quad \text{ if } \alpha > 2\\
                       & = & +\infty  \quad \text{ if } \alpha \leq 2\\
        \end{eqnarray*}

    where :math:`\Gamma` denotes Euler's Gamma function
    :meth:`~openturns.SpecFunc.Gamma`.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Frechet(1.0, 3.0, 0.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Frechet_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Frechet___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Frechet___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Frechet___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Frechet_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Frechet_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Frechet_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Frechet_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Frechet_computeCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Frechet_computeEntropy(self)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle1.Frechet_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Frechet_computePDFGradient(self, *args)

    def computeLogPDFGradient(self, *args):
        r"""
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input *x*.
        """
        return _dist_bundle1.Frechet_computeLogPDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Frechet_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Frechet_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.Frechet_computeProbability(self, interval)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Frechet_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Frechet_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Frechet_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.Frechet_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Frechet_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Frechet_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Frechet_getParameterDescription(self)

    def setAlpha(self, alpha):
        r"""
        Accessor to the shape parameter.

        Parameters
        ----------
        alpha : float, :math:`\alpha > 0`
            Shape parameter.
        """
        return _dist_bundle1.Frechet_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Accessor to the shape parameter.

        Returns
        -------
        alpha : float
            Shape parameter.
        """
        return _dist_bundle1.Frechet_getAlpha(self)

    def setBeta(self, beta):
        r"""
        Accessor to the scale parameter.

        Parameters
        ----------
        beta : float, :math:`\beta > 0`
            Scale parameter.
        """
        return _dist_bundle1.Frechet_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the scale parameter.

        Returns
        -------
        beta : float
            Scale parameter.
        """
        return _dist_bundle1.Frechet_getBeta(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the location parameter.

        Parameters
        ----------
        gamma : float, :math:`\gamma > 0`
            Location parameter.
        """
        return _dist_bundle1.Frechet_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the location parameter.

        Returns
        -------
        gamma : float
            Location parameter.
        """
        return _dist_bundle1.Frechet_getGamma(self)

    def __init__(self, *args):
        _dist_bundle1.Frechet_swiginit(self, _dist_bundle1.new_Frechet(*args))
    __swig_destroy__ = _dist_bundle1.delete_Frechet

# Register Frechet in _dist_bundle1:
_dist_bundle1.Frechet_swigregister(Frechet)
class FrechetFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Frechet factory.

    Notes
    -----
    The parameters are estimated by likelihood maximization. The starting point is obtained from the estimation of a Gumbel distribution based on the logarithm of the shifted observations:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{\alpha} & = & \frac{\pi}{\Hat{\sigma}_y\sqrt{6}} \\
          \displaystyle\Hat{\beta} & = & \exp\left\{\bar{y}_n-\frac{\gamma\sqrt{6}}{\pi}\Hat{\sigma}_y\right\} \\
          \displaystyle\Hat{\gamma} & = & x_{(1)} - \frac{|x_{(1)}|}{n+2}
        \end{eqnarray*}

    with :math:`\gamma \simeq 0.57721` as Euler's constant (not to be confused with the location parameter of the Frechet distribution!), :math:`x_{(1)}=\min_{i=1,\dots,n}x_i` and :math:`y_i=x_i-\Hat{\gamma}`.

    See also
    --------
    DistributionFactory, Frechet
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.FrechetFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.FrechetFactory_build(self, *args)

    def buildAsFrechet(self, *args):
        r"""
        Build the Frechet distribution.

        **Available usages**:

            buildAsFrechet()

            buildAsFrechet(*sample*)

            buildAsFrechet(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Frechet`.

        Returns
        -------
        dist : :class:`~openturns.Frechet`
            The estimated distribution as a Frechet.

            In the first usage, the default Frechet distribution is built.
        """
        return _dist_bundle1.FrechetFactory_buildAsFrechet(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle1.FrechetFactory_buildEstimator(self, *args)

    def __init__(self, *args):
        _dist_bundle1.FrechetFactory_swiginit(self, _dist_bundle1.new_FrechetFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_FrechetFactory

# Register FrechetFactory in _dist_bundle1:
_dist_bundle1.FrechetFactory_swigregister(FrechetFactory)
class GalambosCopula(ExtremeValueCopula):
    r"""
    Galambos copula.

    Parameters
    ----------
    theta : float
        Parameter :math:`\theta > 0`.

        Default value is 0.5.

    Notes
    -----
    The Galambos copula is a bivariate copula defined by:

    .. math::

       C(u_1, u_2) = u_1u_2\exp\left[(-\log(u_1))^{-\theta} + (-\log(u_2))^{-\theta}\right]^{-1/\theta}

    for :math:`(u_1, u_2) \in [0, 1]^2` and :math:`\theta > 0`.
    This copula is an Extreme Value Copula based on the Pickand function :math:`A` defined for all :math:`t \in (0,1)` by

    .. math::

       A(t) = 1 - [t^{-\theta} + (1-t)^{-\theta}]^{-1/\theta}.

    See also
    --------
    ExtremeValueCopula

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.GalambosCopula(0.5)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GalambosCopula_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.GalambosCopula___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.GalambosCopula___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GalambosCopula___str__(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.GalambosCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.GalambosCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.GalambosCopula_getParameterDescription(self)

    def setTheta(self, theta):
        r"""
        Set the Galambos copula parameter :math:`\theta`.

        Parameters
        ----------
        theta : float
            The scalar parameter :math:`\theta > 0`.

        """
        return _dist_bundle1.GalambosCopula_setTheta(self, theta)

    def getTheta(self):
        r"""
        Get the Galambos copula parameter :math:`\theta`.

        Returns
        -------
        theta : float
            The scalar parameter :math:`\theta > 0`.

        """
        return _dist_bundle1.GalambosCopula_getTheta(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.GalambosCopula_hasIndependentCopula(self)

    def __init__(self, *args):
        _dist_bundle1.GalambosCopula_swiginit(self, _dist_bundle1.new_GalambosCopula(*args))
    __swig_destroy__ = _dist_bundle1.delete_GalambosCopula

# Register GalambosCopula in _dist_bundle1:
_dist_bundle1.GalambosCopula_swigregister(GalambosCopula)
class Gamma(openturns.model_copula.DistributionImplementation):
    r"""
    Gamma distribution.

    Parameters
    ----------
    k : float
        Shape parameter :math:`k > 0` with :math:`k = (\mu - \gamma)^2 / \sigma^2`.

        Default value is 1.0.
    lambda : float
        Rate parameter :math:`\lambda > 0` with :math:`\lambda = (\mu - \gamma) / \sigma^2`.

        Default value is 1.0.
    gamma : float, optional
        Location parameter :math:`\gamma`.

        Default value is 0.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{\lambda}{\Gamma(k)}
                 \left(\lambda (x - \gamma)\right)^{k - 1}
                 \exp\left(- \lambda (x - \gamma)\right),
                 \quad x \in [\gamma; +\infty[

    with :math:`k, \lambda > 0` and :math:`\gamma \in \Rset`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \frac{k}{\lambda} + \gamma \\
            \Var{X} & = & \frac{k}{\lambda^2}
        \end{eqnarray*}


    It is possible to create a Gamma distribution from the alternative parametrization :math:`(\mu, \sigma, \gamma)`: see  :class:`~openturns.GammaMuSigma`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization :math:`(\mu, \sigma, \gamma)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(k, \lambda, \gamma)`.

    Examples
    --------
    Create a distribution from its native parameters :math:`(k, \lambda, \gamma)`:

    >>> import openturns as ot
    >>> myDist = ot.Gamma(1.0, 1.0, 0.0)

    Create a it from the alternative parametrization :math:`(\mu, \lambda, \gamma)`:

    >>> myDist2 = ot.Gamma()
    >>> myDist2.setParameter(ot.GammaMuSigma()([1.0, 1.0, 0.0]))

    Create it from :math:`(\mu, \lambda, \gamma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.GammaMuSigma(1.5, 2.5, -0.5)
    >>> myDist3 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Gamma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Gamma___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Gamma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Gamma___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Gamma_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Gamma_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Gamma_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Gamma_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Gamma_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Gamma_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Gamma_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Gamma_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.Gamma_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Gamma_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Gamma_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Gamma_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.Gamma_computeProbability(self, interval)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Gamma_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Gamma_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Gamma_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.Gamma_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Gamma_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Gamma_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Gamma_getParameterDescription(self)

    def setK(self, k):
        r"""
        Accessor to the distribution's shape parameter :math:`k`.

        Parameters
        ----------
        k : float, :math:`k > 0`
            Shape parameter :math:`k`.
        """
        return _dist_bundle1.Gamma_setK(self, k)

    def getK(self):
        r"""
        Accessor to the distribution's shape parameter :math:`k`.

        Returns
        -------
        k : float
            Shape parameter :math:`k`.
        """
        return _dist_bundle1.Gamma_getK(self)

    def setLambda(self, _lambda):
        r"""
        Accessor to the distribution's rate parameter :math:`\lambda`.

        Parameters
        ----------
        lambda : float, :math:`\lambda > 0`
            Rate parameter :math:`\lambda`.
        """
        return _dist_bundle1.Gamma_setLambda(self, _lambda)

    def getLambda(self):
        r"""
        Accessor to the distribution's rate parameter :math:`\lambda`.

        Returns
        -------
        lambda : float
            Rate parameter :math:`\lambda`.
        """
        return _dist_bundle1.Gamma_getLambda(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the distribution's location parameter :math:`\gamma`.

        Parameters
        ----------
        gamma : float, :math:`\gamma \in \Rset`
            Location parameter :math:`\gamma`.
        """
        return _dist_bundle1.Gamma_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the distribution's location parameter :math:`\gamma`.

        Returns
        -------
        gamma : float
            Location parameter :math:`\gamma`.
        """
        return _dist_bundle1.Gamma_getGamma(self)

    def __init__(self, *args):
        _dist_bundle1.Gamma_swiginit(self, _dist_bundle1.new_Gamma(*args))
    __swig_destroy__ = _dist_bundle1.delete_Gamma

# Register Gamma in _dist_bundle1:
_dist_bundle1.Gamma_swigregister(Gamma)
class GammaFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Gamma factory.

    Notes
    -----
    The parameters are estimated by maximum likelihood:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{k}_n= \frac{(\bar{x}_n-\Hat{\gamma}_n)^2}{(\sigma_n^X)^2}\\
          \displaystyle\Hat{\lambda}_n= \frac{\bar{x}_n-\Hat{\gamma}_n}{(\sigma_n^X)^2}\\
          \displaystyle\Hat{\gamma}_n = (1-\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Gamma
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GammaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.GammaFactory_build(self, *args)

    def buildAsGamma(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsGamma()

            buildAsGamma(*sample*)

            buildAsGamma(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Gamma`.

        Returns
        -------
        distribution : :class:`~openturns.Gamma`
            The estimated distribution as a Gamma.

            In the first usage, the default Gamma distribution is built.
        """
        return _dist_bundle1.GammaFactory_buildAsGamma(self, *args)

    def __init__(self, *args):
        _dist_bundle1.GammaFactory_swiginit(self, _dist_bundle1.new_GammaFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_GammaFactory

# Register GammaFactory in _dist_bundle1:
_dist_bundle1.GammaFactory_swigregister(GammaFactory)
class GammaMuSigma(openturns.model_copula.DistributionParametersImplementation):
    r"""
    Gamma distribution parameters.

    Parameters
    ----------
    mu : float
        Mean.

        Default value is 1.0.
    sigma : float
        Standard deviation :math:`\sigma > 0`.

        Default value is 1.0.
    gamma : float, optional
        Shift parameter.

        Default value is 0.0.

    Notes
    -----
    The native parameters are defined as follows:

    .. math::

        k &= \left( \frac{\mu-\gamma}{\sigma} \right)^2 \\
        \lambda &= \frac{\mu-\gamma}{\sigma^2}

    See also
    --------
    Gamma

    Examples
    --------
    Create the parameters of the Gamma distribution:

    >>> import openturns as ot
    >>> parameters = ot.GammaMuSigma(1.5, 2.5, -0.5)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [0.64,0.32,-0.5]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  0.64   0.16   0     ]
     [ -0.512 -0.256  0     ]
     [ -0.64  -0.16   1     ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GammaMuSigma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.GammaMuSigma___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.GammaMuSigma_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle1.GammaMuSigma_gradient(self)

    def __call__(self, inP):
        return _dist_bundle1.GammaMuSigma___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.GammaMuSigma_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.GammaMuSigma_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.GammaMuSigma_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.GammaMuSigma_getDescription(self)

    def __repr__(self):
        return _dist_bundle1.GammaMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GammaMuSigma___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle1.GammaMuSigma_swiginit(self, _dist_bundle1.new_GammaMuSigma(*args))
    __swig_destroy__ = _dist_bundle1.delete_GammaMuSigma

# Register GammaMuSigma in _dist_bundle1:
_dist_bundle1.GammaMuSigma_swigregister(GammaMuSigma)
class Pareto(openturns.model_copula.DistributionImplementation):
    r"""
    Pareto distribution.

    Parameters
    ----------
    beta : float
        Scale parameter :math:`\beta > 0`.

        Default value is 1.0.
    alpha : float, :math:`\alpha > 0`
        Shape parameter :math:`\alpha`.

        Default value is 1.0.
    gamma : float
        Location parameter :math:`\gamma`.

        Default value is 0.0.

    Notes
    -----
    Its cumulative distribution function and its probability density function are defined as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            F_X(x) & = & 1 - \left( \frac{x- \gamma}{\beta} \right) ^{-\alpha},  \quad \forall x \geq \gamma + \beta \\
            p_X(x) & = & \dfrac{\alpha}{\beta} \left( \frac{x- \gamma}{\beta} \right) ^{-\alpha-1},  \quad \forall x \geq \gamma + \beta
        \end{eqnarray*}

    with :math:`\alpha > 0` and :math:`\beta >0`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \gamma + \frac{\alpha}{\alpha + 1}\beta
                             \quad \text{ if } \alpha > 1 \\
            \Var{X} & = & \dfrac{\alpha}{\alpha-2}\left(\dfrac{\beta}{\alpha - 1} \right)^2 \quad \text{ if } \alpha > 2 \\
            Skew[X] & = & \dfrac{2(1+\alpha)}{\alpha-3}\sqrt{\dfrac{\alpha-2}{\alpha}} \quad \text{ if } \alpha > 3
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Pareto(1.0, 1.0, 0.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Pareto_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Pareto___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Pareto___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Pareto___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Pareto_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Pareto_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Pareto_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Pareto_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Pareto_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Pareto_computeComplementaryCDF(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Pareto_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.Pareto_computeProbability(self, interval)

    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _dist_bundle1.Pareto_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle1.Pareto_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Pareto_computeEntropy(self)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Pareto_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Pareto_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Pareto_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Pareto_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Pareto_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.Pareto_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Pareto_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Pareto_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Pareto_getParameterDescription(self)

    def setBeta(self, beta):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Parameters
        ----------
        beta : float, :math:`\alpha \in \Rset`
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle1.Pareto_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Returns
        -------
        sigma : float
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle1.Pareto_getBeta(self)

    def setAlpha(self, alpha):
        r"""
        Accessor to the distribution's shape parameter :math:`\alpha`.

        Parameters
        ----------
        alpha : float, :math:`\alpha > 0`
            Shape parameter :math:`\alpha`.
        """
        return _dist_bundle1.Pareto_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Accessor to the distribution's shape parameter :math:`\alpha`.

        Returns
        -------
        alpha : float
            Shape parameter :math:`\alpha`.
        """
        return _dist_bundle1.Pareto_getAlpha(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the distribution's location parameter :math:`\gamma`.

        Parameters
        ----------
        gamma : float, :math:`u \in \Rset`
            Gamma parameter :math:`\gamma`.
        """
        return _dist_bundle1.Pareto_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the distribution's location parameter :math:`\gamma`.

        Returns
        -------
        gamma : float
            Gamma parameter :math:`\gamma`.
        """
        return _dist_bundle1.Pareto_getGamma(self)

    def __init__(self, *args):
        _dist_bundle1.Pareto_swiginit(self, _dist_bundle1.new_Pareto(*args))
    __swig_destroy__ = _dist_bundle1.delete_Pareto

# Register Pareto in _dist_bundle1:
_dist_bundle1.Pareto_swigregister(Pareto)
class ParetoFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Pareto factory.


    Notes
    -----
    Several estimators to build a Pareto distribution from a scalar sample
    are proposed. The default strategy is to use the least squares estimator.

    **Moments based estimator:**

    Lets denote:

    - :math:`\displaystyle \overline{x}_n = \frac{1}{n} \sum_{i=1}^n x_i` the empirical mean of the sample, 
    - :math:`\displaystyle s_n^2 = \frac{1}{n-1} \sum_{i=1}^n (x_i - \overline{x}_n)^2` its empirical variance,
    - :math:`\displaystyle skew_n` the empirical skewness of the sample

    The estimator :math:`(\hat{\beta}_n, \hat{\alpha}_n, \hat{\gamma}_n)` of
    :math:`(\beta, \alpha, \gamma)` is defined as follows :

    The parameter :math:`\hat{\alpha}_n` is solution of the equation: 

    .. math::
        :nowrap:

        \begin{eqnarray*}
            skew_n & =  & \dfrac{ 2(1+\hat{\alpha}_n) }{ \hat{\alpha}_n-3 } \sqrt{ \dfrac{ \hat{\alpha}_n-2 }{ \hat{\alpha}_n } } 
        \end{eqnarray*}

    There exists a symbolic solution. If :math:`\hat{\alpha}_n >3`, then we get :math:`(\hat{\beta}_n, \hat{\gamma}_n)` as follows: 

    .. math::
        :nowrap:

        \begin{eqnarray*}
           \hat{\beta}_n & = & (\hat{\alpha}_n-1) \sqrt{\dfrac{\hat{\alpha}_n-2}{\hat{\alpha}_n}}s_n \\
           \hat{\gamma}_n & = & \overline{x}_n - \dfrac{\hat{\alpha}_n}{\hat{\alpha}_n+1} \hat{\beta}_n
        \end{eqnarray*}


    **Maximum likelihood based estimator:**

    The likelihood of the sample is defined by:

    .. math::

        \ell(\alpha, \beta, \gamma|  x_1, \dots, x_n) = n\log \alpha + n\alpha \log \beta - (\alpha+1) \sum_{i=1}^n \log(x_i-\gamma)


    The maximum likelihood based estimator :math:`(\hat{\beta}_n, \hat{\alpha}_n, \hat{\gamma}_n)` of :math:`(\beta, \alpha, \gamma)` maximizes the likelihood:

    .. math::

        (\hat{\beta}_n, \hat{\alpha}_n, \hat{\gamma}_n) = \argmax_{\alpha, \beta, \gamma} \ell(\alpha, \beta, \gamma|  x_1, \dots, x_n)

    The following strategy is to be implemented soon: 
    For a given :math:`\gamma`, the likelihood of the sample is defined by:

    .. math::

        \ell(\alpha(\gamma), \beta(\gamma)|  x_1, \dots, x_n, \gamma) = n\log \alpha(\gamma) + n\alpha(\gamma) \log \beta(\gamma) - (\alpha(\gamma)+1) \sum_{i=1}^n \log(x_i-\gamma)

    We get :math:`(\hat{\beta}_n( \gamma), \hat{\alpha}_n( \gamma))` which maximizes :math:`\ell(\alpha, \beta|  x_1, \dots, x_n, \gamma)` :

    .. math::

        (\hat{\beta}_n( \gamma), \hat{\alpha}_n( \gamma)) = \argmax_{\alpha, \beta}   \ell(\alpha(\gamma), \beta(\gamma)|  x_1, \dots, x_n, \gamma) \text{ under the constraint } \gamma + \hat{\beta}_n(\gamma) \leq x_{(1,n)}

    We get:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \hat{\beta}_n( \gamma) & = & x_{(1,n)} - \gamma \\
             \hat{\alpha}_n( \gamma) & = & \dfrac{n}{\sum_{i=1}^n \log\left( \dfrac{x_i - \gamma}{\hat{\beta}_n( \gamma)}\right)}
        \end{eqnarray*}


    Then the parameter :math:`\gamma` is obtained by maximizing the likelihood :math:`\ell(\hat{\beta}_n( \gamma), \hat{\alpha}_n( \gamma), \gamma)`:

    .. math::

        \hat{\gamma}_n = \argmax_{\gamma}  \ell(\hat{\beta}_n( \gamma), \hat{\alpha}_n( \gamma), \gamma)

    The initial point of the optimisation problem is :math:`\gamma_0 = x_{(1,n)} - |x_{(1,n)}|/(2+n)`.


    **Least squares estimator:**

    The parameter :math:`\gamma` is numerically optimized by non-linear least-squares:

    .. math::

        \min{\gamma} \norm{\hat{S}_n(x_i) - (a_1 \log(x_i - \gamma) + a_0)}_2^2


    where :math:`a_0, a_1` are computed from linear least-squares at each optimization evaluation.

    When :math:`\gamma` is known and the :math:`x_i` follow a Pareto distribution then
    we use linear least-squares to solve the relation:

    .. math::
      :label: least_squares_estimator_pareto

       \hat{S}_n(x_i) = a_1 \log(x_i - \gamma) + a_0

    And the remaining parameters are estimated with:

    .. math::

        \hat{\beta} &= \exp{\frac{-a_0}{a_1}}\\
        \hat{\alpha} &= -a_1


    See also
    --------
    DistributionFactory, Normal
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ParetoFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.ParetoFactory_build(self, *args)

    def buildAsPareto(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsPareto()

            buildAsPareto(*sample*)

            buildAsPareto(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float,
            The parameters of the :class:`~openturns.Pareto`.

        Returns
        -------
        dist : :class:`~openturns.Pareto`
            The estimated distribution as a Pareto.

            In the first usage, the default Pareto distribution is built.
        """
        return _dist_bundle1.ParetoFactory_buildAsPareto(self, *args)

    def buildMethodOfMoments(self, sample):
        r"""
        Method of moments estimator.


        Parameters
        ----------
        sample : 2-d sequence of float
            Data.

        Returns
        -------
        distribution : :class:`~openturns.Pareto`
            The estimated distribution
        """
        return _dist_bundle1.ParetoFactory_buildMethodOfMoments(self, sample)

    def buildMethodOfLikelihoodMaximization(self, sample):
        r"""
        Method of likelihood maximization.

        Refer to :class:`~openturns.MaximumLikelihoodFactory`.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.

        Returns
        -------
        distribution : :class:`~openturns.Pareto`
            The estimated distribution
        """
        return _dist_bundle1.ParetoFactory_buildMethodOfLikelihoodMaximization(self, sample)

    def buildMethodOfLeastSquares(self, *args):
        r"""
        Method of least-squares.

        Notes
        -----
        Refer to :class:`~openturns.LeastSquaresDistributionFactory`.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        gamma : float, optional
            Gamma parameter.

        Returns
        -------
        distribution : :class:`~openturns.Pareto`
            The estimated distribution.
        """
        return _dist_bundle1.ParetoFactory_buildMethodOfLeastSquares(self, *args)

    def __init__(self, *args):
        _dist_bundle1.ParetoFactory_swiginit(self, _dist_bundle1.new_ParetoFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_ParetoFactory

# Register ParetoFactory in _dist_bundle1:
_dist_bundle1.ParetoFactory_swigregister(ParetoFactory)
class DistributionFactoryLikelihoodResult(openturns.model_copula.DistributionFactoryResult):
    r"""
    Result from likelihood estimation.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Estimated distribution
    parameterDistribution : :class:`~openturns.Distribution`
        Distribution of the parameters
    logLikelihood : float
        Optimal log-likelihood value

    See also
    --------
    GeneralizedExtremeValueFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.DistributionFactoryLikelihoodResult_getClassName(self)

    def setLogLikelihood(self, logLikelihood):
        r"""
        Likelihood value accessor.

        Parameters
        ----------
        llh : float
            Log-likelihood value.

        """
        return _dist_bundle1.DistributionFactoryLikelihoodResult_setLogLikelihood(self, logLikelihood)

    def getLogLikelihood(self):
        r"""
        Likelihood value accessor.

        Returns
        -------
        llh : float
            Log-likelihood value.

        """
        return _dist_bundle1.DistributionFactoryLikelihoodResult_getLogLikelihood(self)

    def __repr__(self):
        return _dist_bundle1.DistributionFactoryLikelihoodResult___repr__(self)

    def __init__(self, *args):
        _dist_bundle1.DistributionFactoryLikelihoodResult_swiginit(self, _dist_bundle1.new_DistributionFactoryLikelihoodResult(*args))
    __swig_destroy__ = _dist_bundle1.delete_DistributionFactoryLikelihoodResult

# Register DistributionFactoryLikelihoodResult in _dist_bundle1:
_dist_bundle1.DistributionFactoryLikelihoodResult_swigregister(DistributionFactoryLikelihoodResult)
class ProfileLikelihoodResult(DistributionFactoryLikelihoodResult):
    r"""
    Distribution factory result for profile likelihood estimation.

    This  class provides all the results obtained after a profile likelihood estimation with respect to the
    parameter :math:`\vect{\theta}^{(1)}`: refer to :meth:`~openturns.HypothesisTest.LikelihoodRatioTest`.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Parent distribution at optimal parameter :math:`(\hat{\vect{\theta}}^{(1)}, \hat{\vect{\theta}}^{(2)})`.
    parameterDistribution : :class:`~openturns.Distribution`
        Asymptotic distribution of :math:`(\hat{\vect{\theta}}^{(1)}, \hat{\vect{\theta}}^{(2)})`.
    logLikelihood : float
        Maximum profile log-likelihood.
    profileLikelihood : :class:`~openturns.Function`
        Profile log-likelihood function with respect to the scalar parameter :math:`\theta^{(1)}`.
    parameter : float
        Estimator of :math:`\vect{\theta}^{(1)}`.

    See also
    --------
    GeneralizedExtremeValueFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ProfileLikelihoodResult_getClassName(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Confidence level accessor.

        Parameters
        ----------
        level : float
            The confidence level :math:`(1-\alpha)`.
        """
        return _dist_bundle1.ProfileLikelihoodResult_setConfidenceLevel(self, confidenceLevel)

    def getConfidenceLevel(self):
        r"""
        Confidence level accessor.

        Returns
        -------
        level : float
            The confidence level :math:`(1-\alpha)`.
        """
        return _dist_bundle1.ProfileLikelihoodResult_getConfidenceLevel(self)

    def getParameterConfidenceInterval(self):
        r"""
        Confidence interval accessor.

        Returns
        -------
        ci : :class:`~openturns.Interval`
            Confidence interval of :math:`\vect{\theta}^{(1)}`.
        """
        return _dist_bundle1.ProfileLikelihoodResult_getParameterConfidenceInterval(self)

    def getProfileLikelihoodFunction(self):
        r"""
        Profile log-likelihood function accessor.

        Returns
        -------
        ll : :class:`~openturns.Function`
            Profile log-likelihood function with respect to :math:`\vect{\theta}^{(1)}`.
        """
        return _dist_bundle1.ProfileLikelihoodResult_getProfileLikelihoodFunction(self)

    def drawProfileLikelihoodFunction(self):
        r"""
        Draw the profile likelihood graph with respect to the scalar parameter :math:`\theta^{(1)}`.

        If the parameter :math:`\theta^{(1)}` is scalar, the graph of the profile log-likelihood: :math:`\theta^{(1)} \mapsto \ell_p(\theta^{(1)})` provides:

        - the estimator :math:`\hat{\theta}^{(1)}` of  :math:`\theta^{(1)}` that maximizes the log-profile likelihood,
        - the :math:`(1-\alpha)`-confidence interval of :math:`\theta^{(1)}` built from the profile deviance statistics :math:`\mathcal{D}_p (\theta^{(1)})`.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Profile likelihood graph with respect to the scalar parameter :math:`\theta^{(1)}`.
        """
        return _dist_bundle1.ProfileLikelihoodResult_drawProfileLikelihoodFunction(self)

    def getParameter(self):
        r"""
        Estimator of :math:`\vect{\theta}^{(1)}`.

        Returns
        -------
        parameter : float
            Estimator of :math:`\vect{\theta}^{(1)}`.
        """
        return _dist_bundle1.ProfileLikelihoodResult_getParameter(self)

    def __repr__(self):
        return _dist_bundle1.ProfileLikelihoodResult___repr__(self)

    def __init__(self, *args):
        _dist_bundle1.ProfileLikelihoodResult_swiginit(self, _dist_bundle1.new_ProfileLikelihoodResult(*args))
    __swig_destroy__ = _dist_bundle1.delete_ProfileLikelihoodResult

# Register ProfileLikelihoodResult in _dist_bundle1:
_dist_bundle1.ProfileLikelihoodResult_swigregister(ProfileLikelihoodResult)
class TimeVaryingResult(openturns.common.PersistentObject):
    r"""
    Estimation result class for a non stationary GEV or GPD model.

    Parameters
    ----------
    factory : :class:`~openturns.DistributionFactory`
        Parent distribution factory.
    data : 2-d sequence of float
        Sample drawn from :math:`Z_t`.
    parameterFunction : :class:`~openturns.Function`
        The  function :math:`t \mapsto \vect{\theta}(t)`.
    timeStamps : 2-d sequence of float
        Values of :math:`t`.
    parameterDistribution : :class:`~openturns.Distribution`
        The distribution of :math:`\vect{\beta}`.
    normalizationFunction : :class:`~openturns.LinearFunction`
        The normalization function :math:`t \mapsto \tau(t)`.
    llh : float
        Maximum log-likelihood.

    Notes
    -----
    This class is created by the method
    :meth:`~openturns.GeneralizedParetoFactory.buildTimeVarying` of the classes
    :class:`~openturns.GeneralizedExtremeValueFactory` and
    :class:`~openturns.GeneralizedParetoFactory`.

    Let :math:`Z_t` be a non stationary random variable which follows a GEV distribution or whose excesses above :math:`u` follow a GPD. The parameters of the GEV or GPD model depend on :math:`t`:

    .. math::

        Z_t & \sim \mbox{GEV}(\mu(t), \sigma(t), \xi(t))\\
        Z_t & \sim \mbox{GPD}(\sigma(t), \xi(t), u)

    For the GPD, the threshold :math:`u` is assumed to be known.

    We denote by :math:`(z_{t_1}, \dots, z_{t_n})` the values of
    :math:`Z_t` on the time stamps :math:`(t_1, \dots, t_n)`.

    For numerical reasons, the time stamps have been normalized using the linear function:

    .. math::

        \tau(t) = \dfrac{t-c}{d}

    Let :math:`\vect{\theta} = (\theta_1, \dots, \theta_p)` be the set of parameters :math:`(\mu, \sigma, \xi)` for the GEV model and :math:`(\sigma, \xi)` for the GPD. Each component :math:`\theta_q` can be written
    as a function of :math:`t`: 

    .. math::

        \theta_q(t)  = h_q\left(\sum_{i=1}^{d_{\theta_q}} \beta_i^{\theta_q} \varphi_i^{\theta_q}(\tau(t))\right)

    where:

    - :math:`d_{\theta_q}` is the size of the functional basis involved in the modelling of
      :math:`\theta_q`,
    - :math:`h_q: \Rset \mapsto \Rset` is usually referred to as the *inverse-link function* of
      the component :math:`\theta_q`,
    - each :math:`\varphi_i^{\theta_q}` is a scalar function :math:`\Rset \mapsto \Rset`,
    - each :math:`\beta_i^{j} \in \Rset`.

    We denote by :math:`\vect{\beta} = (\beta_1^{\theta_1}, \dots, \beta_{d_{\theta_1}}^{\theta_1}, \dots, \beta_1^{\theta_p}, \dots, \beta_{d_{\theta_p}}^{\theta_p})` the complete vector of parameters.

    The estimator of the vector  :math:`\vect{\beta}` maximizes the likelihood of the Parent distribution (ie the distribution of :math:`Z_t`).

    See also
    --------
    GeneralizedExtremeValueFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.TimeVaryingResult_getClassName(self)

    def getOptimalParameter(self):
        r"""
        Optimal parameter accessor.

        Returns
        -------
        optimalParameter : :class:`~openturns.Point`
            Optimal vector of parameters :math:`\vect{\beta}`.

        """
        return _dist_bundle1.TimeVaryingResult_getOptimalParameter(self)

    def getParameterFunction(self):
        r"""
        Parameter function accessor.

        Returns
        -------
        parameterFunction : :class:`~openturns.Function`
            The  function :math:`t \mapsto \vect{\theta}(t)`.
        """
        return _dist_bundle1.TimeVaryingResult_getParameterFunction(self)

    def getTimeGrid(self):
        r"""
        Accessor to the time grid.

        Returns
        -------
        timeGrid : :class:`~openturns.Sample`
            Values of :math:`t`.
        """
        return _dist_bundle1.TimeVaryingResult_getTimeGrid(self)

    def getNormalizationFunction(self):
        r"""
        Normalizing function accessor.

        Returns
        -------
        normalizeFunction : :class:`~openturns.Function`
            The  function :math:`t \mapsto \tau(t)`.
        """
        return _dist_bundle1.TimeVaryingResult_getNormalizationFunction(self)

    def setParameterDistribution(self, parameterDistribution):
        r"""
        Accessor to the distribution of of :math:`\vect{\beta}`.

        Parameters
        ----------
        parameterDistribution : :class:`~openturns.Distribution`
            The distribution of the estimator of :math:`\vect{\beta}`.
        """
        return _dist_bundle1.TimeVaryingResult_setParameterDistribution(self, parameterDistribution)

    def getParameterDistribution(self):
        r"""
        Accessor to the distribution of :math:`\vect{\beta}`.

        Returns
        -------
        parameterDistribution : :class:`~openturns.Distribution`
            The distribution of the  estimator of :math:`\vect{\beta}`.
        """
        return _dist_bundle1.TimeVaryingResult_getParameterDistribution(self)

    def setLogLikelihood(self, logLikelihood):
        r"""
        Optimal log-likelihood value accessor.

        Parameters
        ----------
        llh : float
            Maximum log-likelihood.

        """
        return _dist_bundle1.TimeVaryingResult_setLogLikelihood(self, logLikelihood)

    def getLogLikelihood(self):
        r"""
        Optimal log-likelihood value accessor.

        Returns
        -------
        llh : float
            Maximum log-likelihood.

        """
        return _dist_bundle1.TimeVaryingResult_getLogLikelihood(self)

    def drawParameterFunction(self, parameterIndex=0):
        r"""
        Draw the parameter function.

        Parameters
        ----------
        parameterIndex : int, 
            The index :math:`q` specifying the component of :math:`\theta_q`.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of :math:`t \mapsto \theta_q(t)`.

        """
        return _dist_bundle1.TimeVaryingResult_drawParameterFunction(self, parameterIndex)

    def getDistribution(self, t):
        r"""
        Accessor to the Parent distribution at a given time.

        Parameters
        ----------
        t : float
            Time value.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The Parent distribution at time *t*.
        """
        return _dist_bundle1.TimeVaryingResult_getDistribution(self, t)

    def drawQuantileFunction(self, p):
        r"""
        Draw the quantile function.

        Parameters
        ----------
        p : float
            The quantile level.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Quantile function graph.

        Notes
        -----
        The quantile function is the function :math:`t \mapsto q_p(t)` where :math:`q_p(t)` is
        the quantile of order :math:`p` of the Parent distribution at time :math:`t`.

        """
        return _dist_bundle1.TimeVaryingResult_drawQuantileFunction(self, p)

    def drawDiagnosticPlot(self):
        r"""
        Draw the 4 usual diagnostic plots.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Returns a grid of 4 graphs:
             - the QQ-plot,
             - the PP-plot,
             - the return level graph (with confidence lines),
             - the density graph.

        Notes
        -----
        Let :math:`Z_t` be a non stationary random variable which follows a GEV distribution or whose excesses above :math:`u` follow a GPD.
        The parameters of the GEV or GPD model depend on :math:`t`:

        .. math::

            Z_t & \sim \mbox{GEV}(\mu(t), \sigma(t), \xi(t))\\
            Z_t & \sim \mbox{GPD}(\sigma(t), \xi(t), u)

        Then, the standardized variables :math:`\hat{Z}_t` defined respectively by:

        .. math::

            \hat{Z}_t & = \dfrac{1}{\xi(t)} \log \left[1 + \xi(t)\left( \dfrac{Z_t-\mu(t)}{\sigma(t)} \right)\right] \\
            \hat{Z}_t & = \dfrac{1}{\xi(t)} \log \left[1 + \xi(t)\left( \dfrac{Z_t-u}{\sigma(t)}      \right)\right]

        respectively follows the standard Gumbel distribution (which is the GEV model with :math:`(\mu, \sigma, \xi) = (0, 1, 0)`) or the standard Exponential distribution (which is the GPD with :math:`(\sigma, \xi, u) = (1, 0, 0)`).

        Then, the 4 usual diagnostic graphs are built from the transformed data compared to the
        Gumbel or Exponential model:

        - the *probability-probability* plot,
        - the *quantile-quantile* plot,
        - the *return level* plot,
        - the data histogram with the Gumbel/Exponential distribution.

        If :math:`(\hat{z}_{(1)}, \dots, \hat{z}_{(n)})` denotes the ordered transformed data,
        the graphs are defined as follows.

        The *probability-probability* plot consists of the points (respectively for the GEV and GPD models):

        .. math::
            \left\{ \left( i/(n+1),\exp (-\exp (-\hat{z}_{(i)})) \right), i=1, \dots , n\right\}\\
            \left\{ \left( i/(n+1), 1- \exp(-\tilde{z}_{(i)})    \right), i=1, \dots , n\right\}

        The *quantile-quantile* plot consists of the points (respectively for the GEV and GPD models):

        .. math::
            \left\{  \left(  \hat{z}_{(i)},  -\log(-\log(i/(n+1)))  \right), i=1, \dots , n\right\} \\
            \left\{ \left(   \tilde{z}_{(i)}, -\log(1-i/(n+1))      \right), i=1, \dots , n\right\}

        The *return level* plot consists of the points:

        .. math::
            \left\{ \left( m, \hat{z}_m \right), m> 0 \right\}

        and the points:

        .. math::
            \left\{ \left( m, \hat{z}_{m}^{emp} \right), m> 0 \right\}

        where :math:`\hat{z}_{m}^{emp}` is the empirical :math:`m`-block return level (for the GEV model) or the :math:`m`-observation return level (for the GPD model)  of the transformed data and :math:`\hat{z}_{m}` the
        same quantity evaluated from the Gumbel/Exponential distribution.
        """
        return _dist_bundle1.TimeVaryingResult_drawDiagnosticPlot(self)

    def __repr__(self):
        return _dist_bundle1.TimeVaryingResult___repr__(self)

    def __init__(self, *args):
        _dist_bundle1.TimeVaryingResult_swiginit(self, _dist_bundle1.new_TimeVaryingResult(*args))
    __swig_destroy__ = _dist_bundle1.delete_TimeVaryingResult

# Register TimeVaryingResult in _dist_bundle1:
_dist_bundle1.TimeVaryingResult_swigregister(TimeVaryingResult)
class CovariatesResult(openturns.common.PersistentObject):
    r"""
    Estimation result class for a GEV or GPD model depending on covariates.

    Parameters
    ----------
    factory : :class:`~openturns.DistributionFactory`
        Parent distribution factory.
    parameterFunction : :class:`~openturns.Function`
        The  function :math:`\vect{\theta}`.
    covariates : 2-d sequence of float
        Values of :math:`\vect{y}`.
    parameterDistribution : :class:`~openturns.Distribution`
        The distribution of :math:`\vect{\beta}`.
    llh : float
        Maximum log-likelihood.

    Notes
    -----
    This class is created by the method
    :meth:`~openturns.GeneralizedParetoFactory.buildCovariates` of the classes
    :class:`~openturns.GeneralizedExtremeValueFactory` and
    :class:`~openturns.GeneralizedParetoFactory`.

    Let :math:`Z_{\vect{y}}` be a random variable which follows a GEV distribution or whose
    excesses above :math:`u` follow a GPD. We assume that the parameters of the GEV model or the GPD
    (except for the threshold of the GPD which is assumed to be known)
    depend on :math:`d` covariates
    denoted by :math:`\vect{y} = \Tr{(y_1, \dots, y_d)}`:

    .. math::

        Z_{\vect{y}} & \sim \mbox{GEV}(\mu(\vect{y}), \sigma(\vect{y}), \xi(\vect{y}))\\
        Z_{\vect{y}} & \sim \mbox{GPD}(\sigma(\vect{y}), \xi(\vect{y}), u)

    We denote by :math:`(z_{\vect{y}_1}, \dots, z_{\vect{y}_n})`
    the values of :math:`Z_{\vect{y}}` associated to the values of the
    covariates :math:`(\vect{y}_1, \dots, \vect{y}_n)`.

    For numerical reasons, the covariates have been normalized. Each covariate :math:`y_k`
    has its own normalization: 

    .. math::

        \tilde{y}_k = \tau_k(y_k) = \dfrac{y_k-c_k}{d_k}

    Let :math:`\vect{\theta} = (\theta_1, \dots, \theta_p)` be the set of parameters
    :math:`(\mu, \sigma, \xi)` for the GEV model and :math:`(\sigma, \xi)` for the GPD model.
    Then, :math:`\vect{\theta}` depends on all the :math:`d`
    covariates
    even if each component of :math:`\vect{\theta}` only depends on a subset of the covariates.
    We denote by :math:`(y_1^q, \dots, y_{d_q}^q)` the :math:`d_q` covariates involved in the
    modelling of the component :math:`\theta_q`.

    Each component :math:`\theta_q` can be written as a function of the covariates:

    .. math::

        \theta_q(y_1^q, \dots, y_{d_q}^q)  & = h_q\left(\sum_{i=1}^{d_q} \beta_i^qy_i^q +
        \beta_{d_q+1}^q \right)

    where:

    - :math:`h_q: \Rset \mapsto \Rset` is usually referred to as the *inverse-link function* of
      the component :math:`\theta_q`,
    - each :math:`\beta_i^{q} \in \Rset`.

    To allow one of the parameters to remain constant, i.e. independent of the covariates
    (this will generally be the case for the parameter :math:`\xi`, the library systematically
    adds the constant covariate to the list speciﬁed by the user, even if it means duplicating it
    if the user has already put it in his list.

    The complete vector of parameters is defined by:

    .. math::

        \Tr{\vect{b}} & = \Tr{( \Tr{\vect{b}_1}, \dots,  \Tr{\vect{b}_p} )} \in  \Rset^{d_t}\\
        \Tr{\vect{b}_q} & =  (\beta_1^q, \dots, \beta_{d_q}^q)\in \Rset^{d_q}

    where :math:`d_t = \sum_{i=1}^p d_i`.

    The estimator of :math:`\Tr{\vect{b}}` maximizes the likelihood of the Parent distribution.

    See also
    --------
    GeneralizedExtremeValueFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.CovariatesResult_getClassName(self)

    def getOptimalParameter(self):
        r"""
        Optimal parameter accessor.

        Returns
        -------
        optimalParameter : :class:`~openturns.Point`
            Optimal vector of parameters :math:`\vect{\beta}`.

        """
        return _dist_bundle1.CovariatesResult_getOptimalParameter(self)

    def getParameterFunction(self):
        r"""
        Parameter function accessor.

        Returns
        -------
        parameterFunction : :class:`~openturns.Function`
            The function :math:`(\vect{\beta}, \vect{y}) \mapsto \vect{\theta}(\vect{\beta},\vect{y})`.
        """
        return _dist_bundle1.CovariatesResult_getParameterFunction(self)

    def getCovariates(self):
        r"""
        Covariates accessor.

        Returns
        -------
        covariates : :class:`~openturns.Sample`
            The sample of covariates.

        Notes
        -----
        If the constant covariate was not specified, a last column has been automatically added
        which contains the value 1.
        """
        return _dist_bundle1.CovariatesResult_getCovariates(self)

    def getNormalizationFunction(self):
        r"""
        Normalizing function accessor.

        Returns
        -------
        normalizeFunction : :class:`~openturns.Function`
            The function :math:`\vect{y} \mapsto (\tau_1(y_1), \dots, \tau_d(y_d))`.
        """
        return _dist_bundle1.CovariatesResult_getNormalizationFunction(self)

    def setParameterDistribution(self, parameterDistribution):
        r"""
        Accessor to the distribution of of :math:`\vect{\beta}`.

        Parameters
        ----------
        parameterDistribution : :class:`~openturns.Distribution`
            The distribution of the estimator of :math:`\vect{\beta}`.
        """
        return _dist_bundle1.CovariatesResult_setParameterDistribution(self, parameterDistribution)

    def getParameterDistribution(self):
        r"""
        Accessor to the distribution of :math:`\vect{\beta}`.

        Returns
        -------
        parameterDistribution : :class:`~openturns.Distribution`
            The distribution of the  estimator of :math:`\vect{\beta}`.
        """
        return _dist_bundle1.CovariatesResult_getParameterDistribution(self)

    def setLogLikelihood(self, logLikelihood):
        r"""
        Optimal likelihood value accessor.

        Parameters
        ----------
        llh : float
            Maximum log-likelihood.

        """
        return _dist_bundle1.CovariatesResult_setLogLikelihood(self, logLikelihood)

    def getLogLikelihood(self):
        r"""
        Optimal likelihood value accessor.

        Returns
        -------
        llh : float
            Maximum log-likelihood.

        """
        return _dist_bundle1.CovariatesResult_getLogLikelihood(self)

    def drawParameterFunction1D(self, *args):
        r"""
        Draw the parameter function.

        Parameters
        ----------
        parameterIndex : int in [0, 2]
            The index specifying the component  :math:`\theta_q`.
        referencePoint : sequence of float, optional
            Reference values for the frozen covariates.
            If not provided the mean of covariates is used.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Graphs of :math:`y_k \mapsto \theta_q(\vect{y})` for :math:`1 \leq k \leq d`.

        Notes
        -----
        Once the index :math:`q` has been chosen, the method draws all the graphs
        :math:`y_k \mapsto \theta_q(\vect{y})`, where all the components of
        :math:`\vect{y}` are fixed to a reference value excepted for :math:`y_k`, for each
        :math:`1 \leq k \leq d`.

        Each component of :math:`\vect{\theta}` potentially depends only on a subset of the
        covariates. Hence, when the component :math:`\theta_q` does not depend on
        :math:`y_k`, the graph is reduced to one horizontal line.
        """
        return _dist_bundle1.CovariatesResult_drawParameterFunction1D(self, *args)

    def drawParameterFunction2D(self, *args):
        r"""
        Draw the parameter function.

        Parameters
        ----------
        parameterIndex : int in [0, 2]
            The index specifying the component :math:`\theta_q`.
        referencePoint : sequence of float, optional
            Reference values for the frozen covariates.
            If not provided the mean of covariates is used.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Graphs of :math:`(y_k, y_\ell) \mapsto \theta_q(\vect{y})` for
            :math:`1 \leq k, \ell \leq d`.

        Notes
        -----
        Once the index :math:`q` has been chosen, the method draws all the graphs
        :math:`(y_k, y_\ell) \mapsto \theta_q(\vect{y})`, where all the components of
        :math:`\vect{y}` are fixed to a reference value excepted for :math:`(y_k, y_\ell)`, for each
        :math:`1 \leq k, \ell \leq d`.

        Each component of :math:`\vect{\theta}` potentially depends only on a subset of the
        covariates. Hence, when the component :math:`\theta_q` does not depend on
        :math:`(y_k, y_\ell)`, the graph is reduced to one point. If it does not depend on one of
        the two, the graph is reduced to one line.
        """
        return _dist_bundle1.CovariatesResult_drawParameterFunction2D(self, *args)

    def getDistribution(self, covariates):
        r"""
        Accessor to the Parent distribution at a given covariate vector.

        Parameters
        ----------
        covariate : sequence of float, 2-d sequence of float
            Covariates value :math:`\vect{y} \in \Rset^d`.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The Parent distribution at *covariate*.
        """
        return _dist_bundle1.CovariatesResult_getDistribution(self, covariates)

    def drawQuantileFunction1D(self, *args):
        r"""
        Draw the quantile function.

        Parameters
        ----------
        p : float
            The quantile level.
        referencePoint : sequence of float, optional
            Reference values for the frozen covariates.
            If not provided the mean of covariates is used.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Graphs of :math:`y_k \mapsto q_p(Z_{\vect{y}})` for :math:`1 \leq k \leq d`.

        Notes
        -----
        The method plots all the graphs of the quantile functions of order :math:`p`: of
        :math:`Z_{\vect{y}}`:  :math:`y_k \mapsto q_p(Z_{\vect{y}})` where all the components of
        :math:`\vect{y}` are fixed to a reference value excepted for :math:`y_k`, for each
        :math:`1 \leq k \leq d`.

        Each component of :math:`\vect{\theta}` potentially depends only on a subset of the
        covariates. Hence, when the component :math:`\theta_q` does not depend on
        :math:`y_k`, the graph is reduced to one horizontal line.

        """
        return _dist_bundle1.CovariatesResult_drawQuantileFunction1D(self, *args)

    def drawQuantileFunction2D(self, *args):
        r"""
        Draw the quantile function.

        Parameters
        ----------
        p : float
            The quantile level.
        referencePoint : sequence of float, optional
            Reference values for the frozen covariates.
            If not provided the mean of covariates is used.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Graphs of :math:`(y_k, y_\ell) \mapsto q_p(Z_{\vect{y}})` for :math:`1 \leq k, \ell \leq d`.

        Notes
        -----
        The method plots all the graphs of the quantile functions of order :math:`p`: of
        :math:`Z_{\vect{y}}`:  :math:`(y_k, y_\ell) \mapsto q_p(Z_{\vect{y}})` where all the
        components of :math:`\vect{y}` are fixed to a reference value excepted for
        :math:`(y_k, y_\ell)`, for each :math:`1 \leq k, \ell \leq d`.

        Each component of :math:`\vect{\theta}` potentially depends only on a subset of the
        covariates. Hence, when the component :math:`\theta_q` does not depend on
        :math:`(y_k, y_\ell)`, the graph is reduced to one point. If it does not depend on one of
        the two, the graph is reduced to one line.
        """
        return _dist_bundle1.CovariatesResult_drawQuantileFunction2D(self, *args)

    def __repr__(self):
        return _dist_bundle1.CovariatesResult___repr__(self)

    def __init__(self, *args):
        _dist_bundle1.CovariatesResult_swiginit(self, _dist_bundle1.new_CovariatesResult(*args))
    __swig_destroy__ = _dist_bundle1.delete_CovariatesResult

# Register CovariatesResult in _dist_bundle1:
_dist_bundle1.CovariatesResult_swigregister(CovariatesResult)
class GeneralizedPareto(openturns.model_copula.DistributionImplementation):
    r"""
    Generalized Pareto distribution.

    Parameters
    ----------
    sigma : float, :math:`\sigma > 0`
        Scale parameter :math:`\sigma`.

        Default value is 1.0.
    xi : float
        Shape parameter :math:`\xi`.

        Default value is 0.0.
    u : float, default=0.0
        Location parameter :math:`u`.

        Default value is 0.0.

    Notes
    -----
    Its cumulative distribution function and its probability density function are defined as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            F_X(x) &  = & 1-t(x), \quad \forall x \in \cS \\
            p_X(x) & = & -t'(x), \quad \forall x \in \cS
        \end{eqnarray*}

    where 

    .. math::
        :nowrap:

        \begin{eqnarray*}
            t(x) &  = & \left(1+\xi \dfrac{x-u}{\sigma}\right)^{-1/\xi} \quad \text{ if } \xi \neq 0\\
            t(x) &  = & \exp(-\dfrac{x-u}{\sigma}) \quad \text{ if } \xi= 0
        \end{eqnarray*}

    and 

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \cS &  = &  [u, +\infty) \quad \text{ if } \xi \geq 0\\
                &  = &  [u, u-\sigma/\xi] \quad \text{ if } \xi < 0
        \end{eqnarray*}

    with :math:`\sigma > 0` and :math:`\xi \in \Rset`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & u + \frac{\sigma}{1 - \xi}
                             \quad \text{ if } \xi < 1 \\
            \Var{X} & = & \frac{\sigma^2}{(1 - 2 \xi) (1 - \xi)^2}
                          \quad \text{ if } \xi < \frac{1}{2}
        \end{eqnarray*}



    When the constructor from a :class:`~openturns.Pareto`:math:`(\beta, \alpha, \gamma)` distribution is used,  then it creates :class:`~openturns.GeneralizedPareto`:math:`(\sigma, \xi, u)` where:

    .. math::
        :nowrap:

        \begin{eqnarray*}
           u & = & \gamma + \beta \\
           \sigma & = & \dfrac{\beta}{\alpha} \\
           \xi & = & \dfrac{1}{\alpha}
        \end{eqnarray*}


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> dist1 = ot.GeneralizedPareto(1.0, 0.0, 0.0)

    Create it from a Pareto distribution:

    >>> pareto = ot.Pareto(1.0, 2.0, 3.0)
    >>> dist1 = ot.GeneralizedPareto(pareto)

    Draw a sample:

    >>> sample = dist1.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GeneralizedPareto_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.GeneralizedPareto___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.GeneralizedPareto___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GeneralizedPareto___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.GeneralizedPareto_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.GeneralizedPareto_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.GeneralizedPareto_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.GeneralizedPareto_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.GeneralizedPareto_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.GeneralizedPareto_computeComplementaryCDF(self, *args)

    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _dist_bundle1.GeneralizedPareto_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle1.GeneralizedPareto_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.GeneralizedPareto_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.GeneralizedPareto_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.GeneralizedPareto_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.GeneralizedPareto_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.GeneralizedPareto_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.GeneralizedPareto_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.GeneralizedPareto_computeProbability(self, interval)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.GeneralizedPareto_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.GeneralizedPareto_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.GeneralizedPareto_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.GeneralizedPareto_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.GeneralizedPareto_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.GeneralizedPareto_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.GeneralizedPareto_getParameterDescription(self)

    def setSigma(self, sigma):
        r"""
        Accessor to the distribution's scale parameter :math:`\sigma`.

        Parameters
        ----------
        sigma : float, :math:`\sigma > 0`
            Scale parameter :math:`\sigma`.
        """
        return _dist_bundle1.GeneralizedPareto_setSigma(self, sigma)

    def getSigma(self):
        r"""
        Accessor to the distribution's scale parameter :math:`\sigma`.

        Returns
        -------
        sigma : float
            Scale parameter :math:`\sigma`.
        """
        return _dist_bundle1.GeneralizedPareto_getSigma(self)

    def setXi(self, xi):
        r"""
        Accessor to the distribution's shape parameter :math:`\xi`.

        Parameters
        ----------
        xi : float, :math:`\xi \in \Rset`
            Shape parameter :math:`\xi`.
        """
        return _dist_bundle1.GeneralizedPareto_setXi(self, xi)

    def getXi(self):
        r"""
        Accessor to the distribution's shape parameter :math:`\xi`.

        Returns
        -------
        xi : float
            Shape parameter :math:`\xi`.
        """
        return _dist_bundle1.GeneralizedPareto_getXi(self)

    def setU(self, location):
        r"""
        Accessor to the distribution's location parameter :math:`u`.

        Parameters
        ----------
        u : float, :math:`u \in \Rset`
            Location parameter :math:`u`.
        """
        return _dist_bundle1.GeneralizedPareto_setU(self, location)

    def getU(self):
        r"""
        Accessor to the distribution's location parameter :math:`u`.

        Returns
        -------
        u : float
            Location parameter :math:`u`.
        """
        return _dist_bundle1.GeneralizedPareto_getU(self)

    def asPareto(self):
        r"""
        Pareto distribution conversion.

        Returns
        -------
        pareto : :class:`~openturns.Pareto`
            Pareto distribution.

        Notes
        -----
        The Pareto associated to the :class:`~openturns.GeneralizedPareto`:math:`(\sigma, \xi, u)` is a  :class:`~openturns.Pareto`:math:`(\beta, \alpha, \gamma)` such that: 

        .. math::
            :nowrap:

            \begin{eqnarray*}
               \beta & = & \dfrac{\sigma}{\xi} \\
               \alpha & = & \dfrac{1}{\xi} \\
               \gamma & = & u-\dfrac{\sigma}{\xi}
            \end{eqnarray*}


        """
        return _dist_bundle1.GeneralizedPareto_asPareto(self)

    def computeReturnLevel(self, m):
        r"""
        Accessor to the return level.

        Parameters
        ----------
        m : float
            Return period

        Returns
        -------
        q : float
            Return level computed as the quantile of level :math:`1-1/m`.
        """
        return _dist_bundle1.GeneralizedPareto_computeReturnLevel(self, m)

    def drawReturnLevel(self):
        r"""
        Plot the return level.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Return level graph.

        Notes
        -----
        The return level plot bounds are defined by the :class:`~openturns.ResourceMap`
        entries `GeneralizedPareto-MMin` and `GeneralizedPareto-MMax`
        """
        return _dist_bundle1.GeneralizedPareto_drawReturnLevel(self)

    def __init__(self, *args):
        _dist_bundle1.GeneralizedPareto_swiginit(self, _dist_bundle1.new_GeneralizedPareto(*args))
    __swig_destroy__ = _dist_bundle1.delete_GeneralizedPareto

# Register GeneralizedPareto in _dist_bundle1:
_dist_bundle1.GeneralizedPareto_swigregister(GeneralizedPareto)
class GeneralizedParetoFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Generalized Pareto factory.

    See also
    --------
    DistributionFactory, GeneralizedPareto

    Notes
    -----
    The following :class:`~openturns.ResourceMap` entries can be used to tweak
    the parameters of the optimization solver involved in the different estimators:

    - `GeneralizedParetoFactory-DefaultOptimizationAlgorithm`
    - `GeneralizedParetoFactory-MaximumEvaluationNumber`
    - `GeneralizedParetoFactory-MaximumAbsoluteError`
    - `GeneralizedParetoFactory-MaximumRelativeError`
    - `GeneralizedParetoFactory-MaximumObjectiveError`
    - `GeneralizedParetoFactory-MaximumConstraintError`
    - `GeneralizedParetoFactory-InitializationMethod`
    - `GeneralizedParetoFactory-NormalizationMethod`

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GeneralizedParetoFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.


        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which :math:`\vect{\theta} = (\sigma, \xi, u)`
            are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.GeneralizedPareto`.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated GPD.

        Notes
        -----
        In the first usage, the default :class:`~openturns.GeneralizedPareto` distribution is built.

        In the second usage, the chosen algorithm depends on the size of the sample compared
        to the :class:`~openturns.ResourceMap` key `GeneralizedParetoFactory-SmallSize`
        (see [matthys2003]_ for the theory):

        - If the sample size is less or equal to `GeneralizedParetoFactory-SmallSize` from :class:`~openturns.ResourceMap`, then the method of probability weighted moments is used. If it fails, the method of exponential regression is used.
        - Otherwise, the first method tried is the method of exponential regression, then the method of probability weighted moments if the first one fails.

        In the third usage, a :class:`~openturns.GeneralizedPareto` distribution corresponding to the given parameters is built.
        """
        return _dist_bundle1.GeneralizedParetoFactory_build(self, *args)

    def buildAsGeneralizedPareto(self, *args):
        r"""
        Build the distribution as a GeneralizedPareto type.


        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which :math:`\vect{\theta} = (\sigma, \xi, u)`
            are estimated.
        param : sequence of float,
            A vector of parameters of the :class:`~openturns.GeneralizedPareto`.

        Returns
        -------
        dist : :class:`~openturns.GeneralizedPareto`
            The estimated GPD as a :class:`~openturns.GeneralizedPareto`.

            In the first usage, the default GeneralizedPareto distribution is built.

        Notes
        -----
        The strategy described in :meth:`build` is followed.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildAsGeneralizedPareto(self, *args)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the likelihood.
        """
        return _dist_bundle1.GeneralizedParetoFactory_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the likelihood.
        """
        return _dist_bundle1.GeneralizedParetoFactory_setOptimizationAlgorithm(self, solver)

    def buildMethodOfMoments(self, sample):
        r"""
        Build the distribution based on the method of moments estimator.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which :math:`\vect{\theta} = (\sigma, \xi, u)`
            are estimated.

        Returns
        -------
        dist : :class:`~openturns.GeneralizedPareto`
            The estimated GPD.

        Notes
        -----
        Lets denote:

        - :math:`\displaystyle \overline{x}_n = \frac{1}{n} \sum_{i=1}^n x_i` the empirical
          mean of the sample, 
        - :math:`\displaystyle s_n^2 = \frac{1}{n-1} \sum_{i=1}^n (x_i - \overline{x}_n)^2`
          its empirical variance.

        Then, we estimate :math:`(\hat{\sigma}_n, \hat{\xi}_n, \hat{u}_n)` using:

        .. math::
            :label: gpd_moment_estimator

            \hat{u}_n & = x_{(1)} - \dfrac{x_{(1)}}{2 + n} \\
            \hat{\xi}_n & = -\dfrac{1}{2}\left(\dfrac{(\overline{x}_n - \hat{u}_n)^2}{s_n^2}-1\right) \\
            \hat{\sigma}_n & = \dfrac{(\overline{x}_n- \hat{u}_n)}{2}\left(\dfrac{(\overline{x}_n- \hat{u}_n)^2}{s_n^2}+1\right)

        This estimator is well-defined only if :math:`\hat{\xi}>-1/4`, otherwise the second moment does not exist.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildMethodOfMoments(self, sample)

    def buildMethodOfExponentialRegression(self, sample):
        r"""
        Build the distribution based on the exponential regression estimator.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which :math:`\vect{\theta} = (\sigma, \xi, u)`
            are estimated.

        Returns
        -------
        dist : :class:`~openturns.GeneralizedPareto`
            The estimated GPD.

        Notes
        -----
        Lets denote:

        - :math:`y_{i}=i\log\left(\dfrac{x_{(n-i)}-x_{(1)}}{x_{(n-i-1)}-x_{(1)}}\right)` for :math:`i\in\{1,n-3\}`

        Then we estimate :math:`(\hat{\sigma}, \hat{\xi}, \hat{u})`
        using:

        .. math::
            :label: gpd_exponential_estimator

            \hat{\xi} & = \xi^* \\
            \hat{\sigma} & = \dfrac{2(\overline{x}_n- \hat{u}_n)}{1-2\rho} \\
            \hat{u} & = x_{(1)} - \frac{x_{(1)}}{2 + n}

        Where :math:`\xi^*` maximizes:

        .. math::
            :label: gpd_xi_relation

            \sum_{i=1}^{n-2}\log\left(\dfrac{1-(j/n)^{\xi}}{\xi}\right)-\dfrac{1-(j/n)^{\xi}}{\xi}y_i

        under the constraint :math:`-1 \leq \xi \leq 1`.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildMethodOfExponentialRegression(self, sample)

    def buildMethodOfProbabilityWeightedMoments(self, sample):
        r"""
        Build the distribution based on the probability weighted moments estimator.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which :math:`\vect{\theta} = (\sigma, \xi, u)`
            are estimated.

        Returns
        -------
        dist : :class:`~openturns.GeneralizedPareto`
            The estimated GPD.

        Notes
        -----
        Lets denote:

        - :math:`\left(x_{(i)}\right)_{i\in\{1,\dots,n\}}` the sample sorted in ascending order
        - :math:`m=\dfrac{1}{n}\sum_{i=1}^n\left(1-\dfrac{i-7/20}{n}\right)x_{(i)}`
        - :math:`\rho=\dfrac{m}{\overline{x}_n}`

        Then we estimate :math:`(\hat{\sigma}, \hat{\xi}, \hat{u})` using:

        .. math::
            :label: gpd_probability_weighted_moment_estimator

            \hat{u}_n & = x_{(1)} - \frac{x_{(1)}}{2 + n}\\
            \hat{\xi}_n & = \dfrac{1-4\rho}{1-2\rho} \\
            \hat{\sigma}_n & = \dfrac{2(\overline{x}_n- \hat{u}_n)}{1-2\rho}

        This estimator is well-defined only if :math:`\hat{\xi}_n>-1/2`, otherwise the first moment does not exist.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildMethodOfProbabilityWeightedMoments(self, sample)

    def drawMeanResidualLife(self, sample):
        r"""
        Draw the mean residual life plot.


        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample drawn from :math:`X`.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of :math:`u \mapsto m_n(u)` and its :math:`95\%` confidence interval.

        Notes
        -----
        This method is complementary to :meth:`drawParameterThresholdStability` as a method of threshold
        selection.

        Let :math:`X` a random variable defined whose excesses above the threshold :math:`u_0`
        follow the Generalized Pareto distribution :math:`GPD(\xi, \sigma_0)`.
        The mean of excesses of :math:`X` for :math:`u > u_0` is

        .. math::

            \Expect{X-u|X>u} = \frac{\sigma_0+\xi u}{1-\xi}

        Hence, for all :math:`u>u_0` :math:`\Expect{X-u|X>u}` is a linear function of :math:`u`.
        The threshold :math:`u_0` is the smallest value of :math:`u` from which the curve is linear.

        The quantity :math:`\Expect{X-u|X>u}` is estimated by the empirical estimator of the mean:

        .. math::

            M_n(u) = \frac{1}{n} \sum_{i=1}^n (X_i - u) 1_{X_i \ge u} = \frac{1}{n} \sum_{i=1}^n X_i 1_{X_i \ge u} - u

        The estimator :math:`M_n(u)` is asymptotically normal with mean
        :math:`\mu(u) = \Expect{X-u|X>u}` and variance :math:`\mu(u)(1 - \mu(u))/n`.

        We denote by :math:`m_n(u)` its realization on the sample drawn from :math:`X`.
        The mean and the variance of :math:`M_n(u)` are respectively estimated by :math:`m_n(u)` and :math:`m_n(u)(1-m_n(u))`.

        The graph :math:`u \mapsto m_n(u)` is termed the *mean residual life plot*.

        The confidence level can be set using the :class:`~openturns.ResourceMap` key
        `GeneralizedParetoFactory-MeanResidualLifeConfidenceLevel`
        The number of threshold points in the graph can be set with the key
        `GeneralizedParetoFactory-MeanResidualLifePointNumber`.

        """
        return _dist_bundle1.GeneralizedParetoFactory_drawMeanResidualLife(self, sample)

    def buildMethodOfLikelihoodMaximizationEstimator(self, sample, u):
        r"""
        Estimate the distribution and the parameter distribution with the maximum likelihood method.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample drawn from :math:`X`.
        u : float
            Given threshold value.

        Returns
        -------
        result : :class:`~openturns.DistributionFactoryLikelihoodResult`
            The result class.

        Notes
        -----

        Let :math:`X` be a random variable whose excesses above :math:`u` follow
        a GPD parameterized by :math:`\vect{\theta} = (\sigma, \xi)`. We assume
        that :math:`u` is known.

        The estimator :math:`(\hat{\sigma}, \hat{\xi})` is defined using the profile log-likelihood  as detailed in
        :meth:`buildMethodOfLikelihoodMaximization`.

        The result class produced by the method provides:

        - the GPD distribution associated to :math:`(\hat{\sigma}, \hat{\xi}, u)`,
        - the asymptotic distribution of :math:`(\hat{\sigma}, \hat{\xi}, u)`.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildMethodOfLikelihoodMaximizationEstimator(self, sample, u)

    def buildMethodOfLikelihoodMaximization(self, sample, u):
        r"""
        Estimate the distribution with the maximum likelihood method.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample drawn from :math:`X`.
        u : float
            Given threshold value.

        Returns
        -------
        distribution : :class:`~openturns.GeneralizedExtremeValue`
            The estimated distribution of :math:`(\hat{\sigma}, \hat{\xi})`.

        Notes
        -----
        Let :math:`X` be a random variable whose excesses above :math:`u` follow
        a GPD parameterized by :math:`\vect{\theta} = (\sigma, \xi)`. We assume
        that :math:`u` is known.

        Let :math:`(x_1, \dots, x_n)` be a sample drawn from :math:`X`. We define the excesses above :math:`u` by:

        .. math::

            z_i = x_i - u

        for all :math:`1 \leq i \leq n`. 

        The maximum likelihood estimator of :math:`(\sigma, \xi)` maximizes  the log-likelihood defined by:

        If :math:`\xi \neq 0`:

        .. math::
            :label: llgpdR1

            \ell(\sigma, \xi) = -n \log \sigma - \sum_{i=1}^n  \log \left(1 + \xi \frac{z_i}{\sigma}\right)

        defined on :math:`(\sigma, \xi)` such that :math:`1+\xi \left( \frac{z_i - u}{\sigma} \right) > 0` for all :math:`1 \leq i \leq n`.

        If :math:`\xi = 0`:

        .. math::
            :label: llgpdR2

            \ell(\sigma, \xi) = -n \log \sigma - \sigma^{-1} \sum_{i=1}^n \exp z_i

        """
        return _dist_bundle1.GeneralizedParetoFactory_buildMethodOfLikelihoodMaximization(self, sample, u)

    def buildMethodOfXiProfileLikelihoodEstimator(self, sample, u):
        r"""
        Estimate the distribution and the parameter distribution with the profile likelihood.


        Parameters
        ----------
        sample : 2-d sequence of float
            Sample drawn from :math:`X`.
        u : float
            Given threshold value.

        Returns
        -------
        result : :class:`~openturns.ProfileLikelihoodResult`
            The result class.

        Notes
        -----
        Let :math:`X` be a random variable whose excesses above :math:`u` follow
        a GPD parameterized by :math:`\vect{\theta} = (\sigma, \xi)`. We assume
        that :math:`u` is known.

        The estimator :math:`(\hat{\sigma}, \hat{\xi})` is defined in :meth:`buildMethodOfXiProfileLikelihood`.

        The result class produced by the method provides:

        - the GPD distribution associated to :math:`(\hat{\sigma}, \hat{\xi}, u)`,
        - the asymptotic distribution of :math:`(\hat{\sigma}, \hat{\xi}, u)`,
        - the profile log-likelihood function :math:`\xi \mapsto \ell_p(\xi)`,
        - the optimal profile log-likelihood value :math:`\ell_p(\hat{\xi})`,
        - confidence intervals of level :math:`(1-\alpha)` of :math:`\xi`.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildMethodOfXiProfileLikelihoodEstimator(self, sample, u)

    def buildMethodOfXiProfileLikelihood(self, sample, u):
        r"""
        Estimate the distribution with the profile likelihood.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample drawn from :math:`X`.
        u : float
            Given threshold value.

        Returns
        -------
        distribution : :class:`~openturns.GeneralizedPareto`
            The estimated GPD.

        Notes
        -----
        Let :math:`X` be a random variable whose excesses above :math:`u` follow
        a GPD parameterized by :math:`\vect{\theta} = (\sigma, \xi)`. We assume
        that :math:`u` is known.

        The estimator :math:`(\hat{\sigma}, \hat{\xi})` is defined using a nested numerical optimization of the log-likelihood:

        .. math::

            \ell_p (\xi) = \max_{(\sigma)} \ell (\sigma, \xi, u)

        where :math:`\ell (\sigma, \xi, u)` is detailed in equations :eq:`llgpdR1` and :eq:`llgpdR2`.

        The estimator is given by:

        .. math::

            \hat{\xi} & =  \argmax_{\xi} \ell_p(\xi)\\
            \hat{\sigma} & = \argmax_{\sigma} \ell(\sigma, \hat{\xi}, u)


        """
        return _dist_bundle1.GeneralizedParetoFactory_buildMethodOfXiProfileLikelihood(self, sample, u)

    def drawParameterThresholdStability(self, sample, thresholdRange):
        r"""
        Draw the parameter threshold stability plot.


        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample drawn from  :math:`X`.
        uRange : :class:`~openturns.Interval`
            The range of the threshold :math:`u: [u_{min}, u_{max}]`.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graphs of :math:`u \mapsto \hat{\sigma}^{\ast}` and :math:`u \mapsto \hat{\xi}`.

        Notes
        -----
        This method is complementary to :meth:`drawMeanResidualLife` as a method of threshold
        selection.

        Let :math:`X` a random variable whose excesses above the threshold :math:`u_0`
        follow a Generalized Pareto distribution :math:`GPD(\sigma_0, \xi)`. Then the excesses of
        :math:`X` above :math:`u>u_0` also follow a Generalized Pareto distribution
        :math:`GPD( \sigma_u, \xi)` where:

        .. math::
            :label: sigmau

            \sigma_u = \sigma_0 + \xi (u - u_0)

        Hence, if we define the modified scale parameter :math:`\sigma^{\ast}` by:

        .. math::

            \sigma^{\ast} = \sigma_u - \xi u

        then , by virtue of :eq:`sigmau`, :math:`\sigma^{\ast}` is constant with respect to :math:`u`. 

        Consequently, estimates of :math:`\sigma^{\ast}` and :math:`\xi` should be constant (or stable
        accounting for sampling variability) above
        :math:`u_0` if :math:`u_0` is a valid threshold for excesses to follow a Generalized Pareto
        distribution.

        The method draws the graphs of :math:`u \mapsto \hat{\sigma}^{\ast}` and
        :math:`u \mapsto \hat{\xi}` with the respective :math:`95\%` confidence intervals,
        for :math:`u \in [u_{min}, u_{max}]`.
        The selected threshold is the lowest value of :math:`u` from which the estimates remain
        near-constant.

        The confidence level can be set using the :class:`~openturns.ResourceMap` key
        `GeneralizedParetoFactory-ThresholdStabilityConfidenceLevel`
        The number of threshold points in the graph can be set with the key
        `GeneralizedParetoFactory-ThresholdStabilityPointNumber`.

        """
        return _dist_bundle1.GeneralizedParetoFactory_drawParameterThresholdStability(self, sample, thresholdRange)

    def buildCovariates(self, *args):
        r"""
        Estimate a GPD from covariates.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample drawn from a GPD.
        u : float
            The threshold.
        covariates : 2-d sequence of float
            Covariates sample.
            A constant column is automatically added if none is not provided.
        sigmaIndices : sequence of int, optional
            Indices of covariates considered for parameter :math:`\sigma`.

            By default, an empty sequence.

            The index of the constant covariate is added
            if empty or if the covariates do not initially contain a constant column.
        xiIndices : sequence of int, optional
            Indices of covariates considered for parameter :math:`\xi`.

            By default, an empty sequence.

            The index of the constant covariate is added
            if empty or if the covariates do not initially contain a constant column.
        sigmaLink : :class:`~openturns.Function`, optional
            The :math:`h_{\sigma}` function.

            By default, the identity function.
        xiLink : :class:`~openturns.Function`, optional
            The :math:`h_{\xi}` function.

            By default, the identity function.
        initializationMethod : str, optional
            The initialization method for the optimization problem: *Generic* or *Static*.

            By default, the method *Generic* (see :class:`~openturns.ResourceMap`, key
            *GeneralizedParetoFactory-InitializationMethod*).
        normalizationMethod : str, optional
            The data normalization method: *CenterReduce*, *MinMax* or *None*.

            By default, the method *MinMax* (see :class:`~openturns.ResourceMap`, key
            *GeneralizedParetoFactory-NormalizationMethod*).

        Returns
        -------
        result : :class:`~openturns.CovariatesResult`
            The result class.

        Notes
        -----
        Let :math:`Z_{\vect{y}}` whose excesses above the threshold :math:`u` follow a GPD whose parameters :math:`(\sigma, \xi)` depend on :math:`d` covariates
        denoted by :math:`\vect{y} = \Tr{(y_1, \dots, y_d)}`:

        .. math::

            Z_{\vect{y}} \sim \mbox{GPD}(\sigma(\vect{y}), \xi(\vect{y}), u)

        We assume that the threshold :math:`u` is known.

        We denote by :math:`(z_{\vect{y}_1}, \dots, z_{\vect{y}_n})`
        the values of :math:`Z_{\vect{y}}` associated to the values of the
        covariates :math:`(\vect{y}_1, \dots, \vect{y}_n)`.

        For numerical reasons, it is recommended to normalize the covariates. Each covariate :math:`y_k`
        has its own normalization: 

        .. math::

            \tilde{y}_k = \tau_k(y_k) = \dfrac{y_k-c_k}{d_k}

        and with three ways of defining :math:`(c_k,d_k)` of the covariate :math:`y_k`:

        - the *CenterReduce* method where :math:`c_k = \dfrac{1}{n} \sum_{i=1}^n y_{k,i}` is the covariate mean
          and :math:`d_k = \sqrt{\dfrac{1}{n} \sum_{i=1}^n (y_{k,i}-c_k)^2}` is the standard deviation of the covariates;
        - the *MinMax* method where :math:`c_k = \min_i y_{k,i}` is the min value of the covariate
          :math:`y_k` and :math:`d_k = \max_i y_{k,i}- \min_i y_{k,i}` its range. This is the default method. This is the default method;
        - the *None* method where :math:`c_k = 0` and :math:`d_k = 1`: in that case, data are not normalized.


        Let :math:`\vect{\theta} = (\sigma, \xi)` be the vector of parameters. Then, :math:`\vect{\theta}` depends on all the :math:`d` covariates
        even if each component of :math:`\vect{\theta}` only depends on a subset of the covariates. We
        denote by :math:`(y_1^q, \dots, y_{d_q}^q)` the :math:`d_q` covariates involved in the modelling
        of the component :math:`\theta_q`.

        Each component :math:`\theta_q` can be written as a function of the normalized covariates:

        .. math::

            \theta_q(y_1^q, \dots, y_{d_q}^q)  & = h_q\left(\sum_{i=1}^{d_q} \tilde{\beta}_i^q\tilde{y}_i^q \right)

        This relation can be written  as a function of the real covariates:

        .. math::

            \theta_q(y_1^q, \dots, y_{d_q}^q)  & = h_q\left(\sum_{i=1}^{d_q} \beta_i^qy_i^q +
            \beta_{d_q+1}^q \right)

        where:

        - :math:`h_q: \Rset \mapsto \Rset` is usually referred to as the *inverse-link function* of the
          component :math:`\theta_q`,
        - each :math:`\beta_i^{q} \in \Rset`.

        To allow some parameters to remain constant, i.e. independent of the covariates
        (this will generally be the case for the parameter :math:`\xi`), the library systematically
        adds the constant covariate to the speciﬁed covariates.

        The complete vector of parameters is defined by:

        .. math::

            \Tr{\vect{b}} & = \Tr{( \Tr{\vect{b}_1}, \dots,  \Tr{\vect{b}_p} )} \in  \Rset^{d_t}\\
            \Tr{\vect{b}_q} & =  (\beta_1^q, \dots, \beta_{d_q}^q)\in \Rset^{d_q}

        where :math:`d_t = \sum_{q=1}^p d_q`.

        The estimator of  :math:`\vect{\beta}` maximizes  the likelihood of the model which is defined by:

        .. math::

            L(\vect{\beta}) = \prod_{i=1}^{n} g(z_{\vect{y}_i};\vect{\theta}(\vect{y}_i)))

        where :math:`g(z_{\vect{y}_i};\vect{\theta}(\vect{y}_i))` denotes the GPD density function with
        parameters
        :math:`\vect{\theta}(\vect{y}_i)` and evaluated at :math:`z_{\vect{y}_i}`.

        Then, if none of the :math:`\xi(\vect{y}_i)` is zero, the log-likelihood is defined by:

        .. math::

            \ell (\vect{\beta}) = -\sum_{i=1}^{n} \left\{ \log(\sigma(\vect{y}_i)) +
            (1 + 1 / \xi(\vect{y}_i) ) \log\left[ 1+\xi(\vect{y}_i) \left( \frac{z_{\vect{y}_i} -
            \mu(\vect{y}_i)}{\sigma(\vect{y}_i)}\right) \right] + \left[ 1 + \xi(\vect{y}_i)
            \left( \frac{z_{\vect{y}_i}- \mu(\vect{y}_i)}{\sigma(\vect{y}_i)} \right) \right]^{-1 / \xi(\vect{y}_i)} \right\}

        defined on :math:`(\mu, \sigma, \xi)` such that :math:`1+\xi \left( \frac{z_{\vect{y}_i} -
        \mu(\vect{y}_i)}{\sigma(\vect{y}_i)}\right) > 0` for all :math:`\vect{y}_i`.

        And if any of the :math:`\xi(\vect{y}_i)` is equal to 0, the log-likelihood is defined as:

        .. math::

            \ell (\vect{\beta}) = -\sum_{i=1}^{n} \left\{ \log(\sigma(\vect{y}_i)) + \frac{z_{\vect{y}_i} - \mu(\vect{y}_i)}{\sigma(\vect{y}_i)} + \exp \left\{ - \frac{z_{\vect{y}_i} - \mu(\vect{y}_i)}{\sigma(\vect{y}_i)} \right\} \right\}

        The initialization of the optimization problem is crucial.
        Two initial points :math:`(\mu_0, \sigma_0, \xi_0)` are proposed:

        - the *Generic* initial point: in that case, we assume that the GPD is stationary and
          :math:`(\sigma_0, \xi_0)` is the estimate resulting from the method
          :meth:`buildAsGeneralizedPareto` which follows the strategy described
          in the method :meth:`build`. This is the default initial point;
        - the *Static* initial point: in that case, we still assume that the GPD is stationary and
          :math:`(\sigma_0, \xi_0)`
          is the maximum likelihood estimate.

        The result class provides:

        - the estimator :math:`\hat{\vect{\beta}}`,
        - the asymptotic distribution of :math:`\hat{\vect{\beta}}`,
        - the parameter function :math:`(\vect{\beta}, \vect{y}) \mapsto \vect{\theta}(\vect{\beta},
          \vect{y})`,
        - the graphs of the parameter functions :math:`y_k \mapsto \theta_q(\vect{y})`, where all the components of
          :math:`\vect{y}` are fixed to a reference value excepted for :math:`y_k`, for each :math:`k`,
        - the graphs of the parameter functions :math:`(y_k, y_\ell) \mapsto \theta_q(\vect{y})`, where all the
          components of :math:`\vect{y}` are fixed to a reference value excepted for
          :math:`(y_k, y_\ell)`, for each :math:`(k,\ell)`,
        - the normalizing function :math:`\vect{y} \mapsto (\tau_1(y_1), \dots, \tau_d(y_d))`,
        - the optimal log-likelihood value :math:`\hat{\vect{\beta}}`,
        - the GEV distribution at covariate :math:`\vect{y}`,
        - the graphs of the quantile functions of order :math:`p`: :math:`y_k \mapsto q_p(Z_{\vect{y}})` where all
          the components of :math:`\vect{y}` are fixed to a reference value excepted for :math:`y_k`, for each :math:`k`,
        - the graphs of the quantile functions of order :math:`p`: :math:`(y_k, y_\ell) \mapsto q_p(Z_{\vect{y}})` where
          all the components of :math:`\vect{y}` are fixed to a
          reference value excepted for :math:`(y_k, y_\ell)`, for each :math:`(k,\ell)`.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildCovariates(self, *args)

    def buildTimeVarying(self, *args):
        r"""
        Estimate a non stationary GPD from a time-dependent parametric model.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample drawn from :math:`Z_t`.
        u : float
            The threshold.
        timeStamps : 2-d sequence of float
            Values of :math:`t`.
        basis : :class:`~openturns.Basis`
            Functional basis.
        sigmaIndices : sequence of int, optional
            Indices of basis terms considered for parameter :math:`\sigma`.
        xiIndices : sequence of int, optional
            Indices of basis terms considered for parameter :math:`\xi`.
        sigmaLink : :class:`~openturns.Function`, optional
            The :math:`h_{\sigma}` function.

            By default, the identity function.
        xiLink : :class:`~openturns.Function`, optional
            The :math:`h_{\xi}` function.

            By default, the identity function.
        initializationMethod : str, optional
            The initialization method for the optimization problem: *Generic* or *Static*.

            By default, the method *Generic* (see :class:`~openturns.ResourceMap`, key
            *GeneralizedParetoFactory-InitializationMethod*).
        normalizationMethod : str, optional
            The data normalization method: *CenterReduce*, *MinMax* or *None*.

            By default, the method *MinMax* (see :class:`~openturns.ResourceMap`, key
            *GeneralizedParetoFactory-NormalizationMethod*).

        Returns
        -------
        result : :class:`~openturns.TimeVaryingResult`
            The result class.

        Notes
        -----
        Let :math:`Z_t` be a non stationary random variable whose excesses above the threshold :math:`u` follow a GPD. We assume that :math:`u` is known:

        .. math::

            Z_t \sim \mbox{GPD}(\sigma(t), \xi(t), u)

        We denote by :math:`(z_{t_1}, \dots, z_{t_n})` the values of
        :math:`Z_t` on the time stamps :math:`(t_1, \dots, t_n)`.

        For numerical reasons, it is recommended to normalize the time stamps.
        The following mapping is applied:

        .. math::

            \tau(t) = \dfrac{t-c}{d}

        and with three ways of defining :math:`(c,d)`:

        - the *CenterReduce* method where :math:`c = \dfrac{1}{n} \sum_{i=1}^n t_i` is the mean
          time stamps
          and :math:`d = \sqrt{\dfrac{1}{n} \sum_{i=1}^n (t_i-c)^2}` is the standard deviation of the time stamps;
        - the *MinMax* method where :math:`c = t_1` is the first time and :math:`d = t_n-t_1` the
          range of the time stamps. This is the default method;
        - the *None* method where :math:`c = 0` and :math:`d = 1`: in that case, data are not
          normalized.


        If we denote by :math:`\theta_q` is a component of :math:`\vect{\theta} = (\sigma, \xi)`,
        then  :math:`\theta_q` can be written as a function of :math:`t`: 

        .. math::

            \theta_q(t)  = h_q\left(\sum_{i=1}^{d_{\theta_q}} \beta_i^{\theta_q} \varphi_i^{\theta_q}
            (\tau(t))\right)

        where:

        - :math:`d_{\theta_q}` is the size of the functional basis involved in the modelling of
          :math:`\theta_q`,
        - :math:`h_q: \Rset \mapsto \Rset` is usually referred to as the *inverse-link function* of
          the parameter :math:`\theta_q`,
        - each :math:`\varphi_i^{\theta_q}` is a scalar function :math:`\Rset \mapsto \Rset`,
        - each :math:`\beta_i^{j} \in \Rset`.

        We denote by :math:`d_{\sigma}` and :math:`d_{\xi}` the size of the functional basis of
        :math:`\sigma` and :math:`\xi` respectively. We denote by
        :math:`\vect{\beta} = (\beta_1^{\sigma}, \dots, \beta_{d_{\sigma}}^{\sigma}, \beta_1^{\xi},
        \dots, \beta_{d_{\xi}}^{\xi})` the complete vector of parameters.

        The estimator of  :math:`\vect{\beta}` maximizes  the likelihood of the non stationary model which is defined by:

        .. math::

            L(\vect{\beta}) = \prod_{i=1}^{n} g(z_{t_i};\sigma(t_i), \xi(t_i), u)

        where :math:`g(z_{t};\sigma(t), \xi(t))` denotes the GPD density function with parameters
        :math:`(\sigma(t), \xi(t), u)` evaluated at :math:`z_t`.

        Then, if none of the :math:`\xi(t)` is zero, the log-likelihood is defined by:

        .. math::

            \ell (\vect{\beta}) = -\sum_{i=1}^{n} \left\{ \log(\sigma(t_i)) + (1 + 1 / \xi(t_i) )
            \log\left[ 1+\xi(t_i) \left( \frac{z_{t_i} - \mu(t_i)}{\sigma(t_i)}\right) \right] + \left[ 1 +
            \xi(t_i) \left( \frac{z_{t_i}- \mu(t_i)}{\sigma(t_i)} \right) \right]^{-1 / \xi(t_i)} \right\}

        defined on :math:`(\sigma, \xi, u)` such that :math:`1+\xi(t) \left( \frac{z_t - \mu(t)}{\sigma(t)}
        \right) > 0` for all :math:`t`.

        And if any of the :math:`\xi(t_i)` is equal to 0, the log-likelihood is defined as:

        .. math::

            \ell (\vect{\beta}) = -\sum_{i=1}^{n} \left\{ \log(\sigma(t_i)) + \frac{z_{t_i} - \mu(t_i)}
            {\sigma(t_i)} + \exp \left\{ - \frac{z_{t_i} - \mu(t_i)}{\sigma(t_i)} \right\} \right\}

        The initialization of the optimization problem is crucial.
        Two initial points :math:`(\mu_0, \sigma_0, \xi_0)` are proposed:

        - the *Generic* initial point: in that case, we assume that the GPD is stationary and
          :math:`(\sigma_0, \xi_0)` is the estimate resulting from the method
          :meth:`buildAsGeneralizedPareto` which follows the strategy described
          in the method :meth:`build`. This is the default initial point;
        - the *Static* initial point: in that case, we still assume that the GPD is stationary and
          :math:`(\sigma_0, \xi_0)`
          is the maximum likelihood estimate.

        The result class produced by the method provides:

        - the estimator :math:`\hat{\vect{\beta}}`,
        - the asymptotic distribution of :math:`\hat{\vect{\beta}}`,
        - the parameter functions :math:`t \mapsto \vect{\theta}(t)`,
        - the normalizing function :math:`t \mapsto \tau(t)`,
        - the optimal log-likelihood value :math:`\hat{\vect{\beta}}`,
        - the GPD distribution at time :math:`t`,
        - the quantile functions of order :math:`p`: :math:`t \mapsto q_p(Z_t)`.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildTimeVarying(self, *args)

    def buildReturnLevelEstimator(self, result, sample, m, theta=1.0):
        r"""
        Estimate a return level and its distribution from the GPD parameters.

        Parameters
        ----------
        result : :class:`~openturns.DistributionFactoryResult`
            Likelihood estimation result obtained to estimate the GPD :math:`(\sigma, \xi, u)`.
        sample : 2-d sequence of float
            The initial data from which the clusters (if any) have been extracted. If the data are independent, *sample* is the sample used to get *result*.
        m : float
            The return period expressed in terms of number of observations.
        theta : float, optional
            The extremal index defined in :eq:`defThetaZetaU`.

            Default value is 1.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The asymptotic distribution of :math:`\hat{z}_m`.

        Notes
        -----
        Let :math:`Z` a random variable whose excesses above the threshold
        :math:`u` follow a Generalized Pareto distribution
        :math:`GPD(\sigma, \xi)`. We assume that :math:`u` is known.

        The :math:`m`-observation return level :math:`z_m` is the level exceeded on
        average once every :math:`m` observations.
        The :math:`m`-observation return level can be translated into the annual-scale: if there
        are :math:`n_y` observations per year, then the :math:`N`-year return level
        corresponds to the :math:`m`-observation return level where :math:`m = n_yN`.

        The :math:`m`-observation return level is defined as a particular quantile of :math:`Z`:

        If :math:`\xi \neq 0`:

        .. math::
            :label: xm1gpd

            z_m = u + \frac{\sigma}{\xi}\left[(m \zeta_u \theta)^{\xi} - 1 \right]

        If :math:`\xi = 0`:

        .. math::
            :label: xm2gpd

            z_m = u + \sigma \log(m \zeta_u \theta)

        with :math:`\zeta_u` the probability of an exceedance of :math:`u`
        and :math:`\theta` the extremal index. Denoting the number of observations by
        :math:`n`, the number of  exceedances of the threshold :math:`u` by
        :math:`n_u` and the number of clusters obtained above :math:`u` by
        :math:`n_c`, then :math:`\zeta_u` and :math:`\theta` are estimated by:

        .. math::
            :label: defThetaZetaU

            \zeta_u & = \dfrac{n_u}{n}\\
            \theta  & = \dfrac{n_c}{n_u}

        If the data are independent, no clustering is performed and :math:`\theta=1`.

        The estimator :math:`\hat{z}_m` of :math:`z_m` is deduced from the estimator
        :math:`(\hat{\sigma}, \hat{\xi}, \hat{\zeta_u})` of :math:`(\sigma, \xi, \zeta_u)`
        of the GPD.

        The asymptotic distribution of :math:`\hat{z}_m` is obtained by the Delta method from the asymptotic distribution of
        :math:`(\hat{\sigma}, \hat{\xi}, \hat{\zeta}_u)`. It is a normal distribution with mean :math:`\hat{z}_m` and variance:

        .. math::

            \Var{\hat{z}_m} = (\nabla z_m)^T \mat{V}_n \nabla z_m

        where :math:`\nabla z_m = (\frac{\partial z_m}{\partial \mu}, \frac{\partial z_m}{\partial \sigma}, \frac{\partial z_m}{\partial \xi})`
        and :math:`\mat{V}_n` is the asymptotic covariance of :math:`(\hat{\sigma}, \hat{\xi}, \hat{\mu})`.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildReturnLevelEstimator(self, result, sample, m, theta)

    def buildReturnLevelProfileLikelihoodEstimator(self, sample, u, m, theta=1.0):
        r"""
        Estimate :math:`(z_m, \xi)` and its distribution with the profile likelihood.

        Parameters
        ----------
        sample : 2-d sequence of float
            A sample of dimension 1.
        u : float
            The threshold.
        m : float
            The return period expressed in terms of number of observations.
        theta : float, optional
            When clustering is performed, this is the ratio :math:`\theta = \frac{n_c}{n_u}` of number
            of clusters over number of exceedances, otherwise defaults to 1.

        Returns
        -------
        result : :class:`~openturns.ProfileLikelihoodResult`
            The result class.

        Notes
        -----
        Let :math:`Z` a random variable whose excesses above the threshold
        :math:`u` follow a Generalized Pareto distribution
        :math:`GPD(\sigma, \xi)`. We assume that :math:`u` is known.

        The return level :math:`z_m` is defined in :meth:`buildReturnLevelEstimator`. The profile log-likelihood :math:`\ell_p(z_m)` is defined in
        :meth:`buildReturnLevelProfileLikelihood`.

        The result class produced by the method provides:

        - the GPD distribution associated to :math:`(\hat{z}_m, \hat{\xi}, u)`,
        - the asymptotic distribution of :math:`(\hat{z}_m, \hat{\xi}, u)`,
        - the profile log-likelihood function :math:`z_m \mapsto \ell_p(z_m)`,
        - the optimal profile log-likelihood value :math:`\ell_p(\hat{z}_m)`,
        - confidence intervals of level :math:`(1-\alpha)` of :math:`\hat{z}_m`.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildReturnLevelProfileLikelihoodEstimator(self, sample, u, m, theta)

    def buildReturnLevelProfileLikelihood(self, sample, u, m, theta=1.0):
        r"""
        Estimate a return level and its distribution with the profile likelihood.

        Parameters
        ----------
        sample : 2-d sequence of float
            A sample of dimension 1.
        u : float
            The threshold.
        m : float
            The return period expressed in terms of number of observations.
        theta : float, optional
            The extremal index defined in :eq:`defThetaZetaU`.

            Default value is 1.

        Returns
        -------
        distribution : :class:`~openturns.Normal`
            The asymptotic distribution of :math:`\hat{z}_m`.

        Notes
        -----
        Let :math:`Z` a random variable whose excesses above the threshold
        :math:`u` follow a Generalized Pareto distribution
        :math:`GPD(\sigma, \xi)`. We assume that :math:`u` is known.

        The return level :math:`z_m` is defined in :meth:`buildReturnLevelEstimator`.

        The estimator :math:`\hat{z}_m` of :math:`z_m` is defined using a nested numerical optimization of the log-likelihood:

        .. math::

            \ell_p (z_m) = \max_{\xi} \ell (z_m, \xi, u)

        where :math:`\ell (z_m, \xi, u)` is the log-likelihood detailed in :eq:`llgpdR1` and :eq:`llgpdR2`
        where we substitued
        :math:`\sigma` for :math:`z_m` using equations :eq:`xm1gpd` or :eq:`xm2gpd`.

        Then :math:`\hat{z}_m` is defined by:

        .. math::

            \hat{z}_m = \argmax_{z_m} \ell_p(z_m)

        The asymptotic distribution of :math:`\hat{z}_m` is normal.

        The starting point of the optimization is initialized from the regular maximum likelihood method.
        """
        return _dist_bundle1.GeneralizedParetoFactory_buildReturnLevelProfileLikelihood(self, sample, u, m, theta)

    def __init__(self, *args):
        _dist_bundle1.GeneralizedParetoFactory_swiginit(self, _dist_bundle1.new_GeneralizedParetoFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_GeneralizedParetoFactory

# Register GeneralizedParetoFactory in _dist_bundle1:
_dist_bundle1.GeneralizedParetoFactory_swigregister(GeneralizedParetoFactory)
class Geometric(openturns.model_copula.DistributionImplementation):
    r"""
    Geometric distribution.

    Parameters
    ----------
    p : float, :math:`0 < p \leq 1`
        Success probability of the associated Bernoulli trial.

        Default value is 0.5.

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::

        \Prob{X = k} = p (1 - p)^{k - 1},
                       \quad \forall k \in \Nset^*

    with :math:`0 < p \leq 1`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \frac{1}{p} \\
            \Var{X} & = & \frac{1 - p}{p^2}
        \end{eqnarray*}

    See Also
    --------
    Bernoulli

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Geometric(0.5)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Geometric_getClassName(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Geometric_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Geometric_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Geometric_isIntegral(self)

    def __eq__(self, *args):
        return _dist_bundle1.Geometric___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Geometric___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Geometric___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Geometric_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Geometric_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Geometric_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Geometric_computeComplementaryCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Geometric_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Geometric_computeCDFGradient(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Geometric_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Geometric_computeCharacteristicFunction(self, x)

    def computeGeneratingFunction(self, z):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input *z*.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle1.Geometric_computeGeneratingFunction(self, z)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle1.Geometric_getSupport(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Geometric_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Geometric_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Geometric_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Geometric_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Geometric_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Geometric_getParameterDescription(self)

    def setP(self, p):
        r"""
        Accessor to the success probability parameter.

        Parameters
        ----------
        p : float, :math:`0 < p \leq 1`
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle1.Geometric_setP(self, p)

    def getP(self):
        r"""
        Accessor to the success probability parameter.

        Returns
        -------
        p : float
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle1.Geometric_getP(self)

    def __init__(self, *args):
        _dist_bundle1.Geometric_swiginit(self, _dist_bundle1.new_Geometric(*args))
    __swig_destroy__ = _dist_bundle1.delete_Geometric

# Register Geometric in _dist_bundle1:
_dist_bundle1.Geometric_swigregister(Geometric)
class GeometricFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Geometric factory.

    Notes
    -----
    We use the following estimator:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{p}_n = \frac{1}{\bar{x}_n}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Geometric
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GeometricFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.GeometricFactory_build(self, *args)

    def buildAsGeometric(self, *args):
        r"""
        Estimate the distribution as native distribution.


        **Available usages**:

            buildAsGeometric()

            buildAsGeometric(*sample*)

            buildAsGeometric(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Geometric`.

        Returns
        -------
        distribution : :class:`~openturns.Geometric`
            The estimated distribution as a Geometric.

            In the first usage, the default Geometric distribution is built.
        """
        return _dist_bundle1.GeometricFactory_buildAsGeometric(self, *args)

    def __init__(self, *args):
        _dist_bundle1.GeometricFactory_swiginit(self, _dist_bundle1.new_GeometricFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_GeometricFactory

# Register GeometricFactory in _dist_bundle1:
_dist_bundle1.GeometricFactory_swigregister(GeometricFactory)
class Gumbel(openturns.model_copula.DistributionImplementation):
    r"""
    Gumbel distribution.

    Parameters
    ----------
    beta : float
        scale parameter :math:`\beta > 0`.

        Default value is 1.0.
    gamma : float
        position parameter :math:`\gamma`.

        Default value is 0.0.

    Notes
    -----
    Its cumulative distribution function and its probability density function are defined as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            F_X(x) & = & \exp \left( -  \exp \left( -\dfrac{x-\gamma}{\beta} \right) \right), \quad x \in \Rset \\
            f_X(x) & = & \dfrac{1}{\beta} \exp \left(- \dfrac{x-\gamma}{\beta} - \exp \left(- \dfrac{x-\gamma}{\beta} \right) \right), \quad x \in \Rset
        \end{eqnarray*}

    with :math:`\beta > 0` and :math:`\gamma \in \Rset`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \gamma + \gamma_e \beta \\
            \Var{X} & = & \frac{1}{6} \pi^2 \beta^2
        \end{eqnarray*}

    where :math:`\gamma_e` is the Euler-Mascheroni constant.


    It is possible to create a Gumbel distribution from the alternative parametrizations :math:`(\mu, \sigma)`: see  :class:`~openturns.GumbelMuSigma` or :math:`(\lambda,\gamma)`: see  :class:`~openturns.GumbelLambdaGamma`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\beta, \gamma)`.

    Examples
    --------
    Create a distribution in its native parameters :math:`(\beta, \gamma)`:

    >>> import openturns as ot
    >>> myDist = ot.Gumbel(1.0, 0.0)

    Create it from the alternative parametrization :math:`(\mu, \sigma)`:

    >>> myDist2 = ot.Gumbel()
    >>> myDist2.setParameter(ot.GumbelMuSigma()([0.58, 1.28]))

    Create it from the alternative parametrization :math:`(\lambda, \gamma)`:

    >>> myDist3 = ot.Gumbel()
    >>> myDist3.setParameter(ot.GumbelLambdaGamma()([1.0, 1.0]))

    Create it from :math:`(\mu, \sigma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.GumbelMuSigma(0.58, 1.28)
    >>> myDist4 = ot.ParametrizedDistribution(myParam)

    Create it from :math:`(\lambda, \gamma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.GumbelLambdaGamma(1.0, 1.0)
    >>> myDist5 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Gumbel_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.Gumbel___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.Gumbel___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Gumbel___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.Gumbel_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Gumbel_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Gumbel_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.Gumbel_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.Gumbel_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Gumbel_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.Gumbel_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Gumbel_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.Gumbel_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.Gumbel_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.Gumbel_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Gumbel_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.Gumbel_computeProbability(self, interval)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Gumbel_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.Gumbel_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.Gumbel_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.Gumbel_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Gumbel_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Gumbel_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Gumbel_getParameterDescription(self)

    def setBeta(self, beta):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Parameters
        ----------
        beta : float, :math:`\beta > 0`
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle1.Gumbel_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Returns
        -------
        beta : float
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle1.Gumbel_getBeta(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the distribution's position parameter :math:`\gamma`.

        Parameters
        ----------
        gamma : float, :math:`\beta \in \Rset`
            Scale parameter :math:`\gamma`.
        """
        return _dist_bundle1.Gumbel_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the distribution's position parameter :math:`\gamma`.

        Returns
        -------
        gamma : float
            Scale parameter :math:`\gamma`.
        """
        return _dist_bundle1.Gumbel_getGamma(self)

    def __init__(self, *args):
        _dist_bundle1.Gumbel_swiginit(self, _dist_bundle1.new_Gumbel(*args))
    __swig_destroy__ = _dist_bundle1.delete_Gumbel

# Register Gumbel in _dist_bundle1:
_dist_bundle1.Gumbel_swigregister(Gumbel)
class WeibullMax(openturns.model_copula.DistributionImplementation):
    r"""
    WeibullMax distribution.

    Parameters
    ----------
    beta : float
        Scale parameter :math:`\beta > 0`.

        Default value is 1.0.
    alpha : float
        Shape parameter :math:`\alpha > 0`.

        Default value is 1.0.
    gamma : float, optional
        Location parameter.

        Default value is 0.0.

    Notes
    -----
    Its cumulative distribution function and probability density function are defined as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            F_X(x) & = &  \exp \left(-\left(-\frac{x - \gamma}{\beta}\right)^{\alpha}\right), \quad \forall x \in ( - \infty; \gamma] \\
            f_X(x) &  = & \frac{\alpha}{\beta}
                 \left(-\frac{x - \gamma}{\beta} \right) ^ {\alpha-1}
                 \exp \left(-\left(-\frac{x - \gamma}{\beta}\right)^{\alpha}\right),
                 \quad x \in ( - \infty; \gamma]
        \end{eqnarray*}

    with :math:`\beta > 0` and :math:`\alpha > 0`.


    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \gamma - \beta \,\Gamma \left( 1 + \frac{1}{\alpha} \right) \\
            \Var{X} & = & \beta^2 \left( \Gamma  \left( 1 + \frac{2}{\alpha} \right) -
                         \Gamma^2  \left( 1 + \frac{1}{\alpha} \right) \right)
        \end{eqnarray*}

    where :math:`\Gamma` denotes Euler's Gamma function
    :meth:`~openturns.SpecFunc.Gamma`.

    It is possible to create a WeibullMax distribution from the alternative parametrization :math:`(\mu, \sigma, \gamma)`: see  :class:`~openturns.WeibullMaxMuSigma`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization :math:`(\mu, \sigma, \gamma)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\beta, \alpha, \gamma)`.

    Note that if :math:`X` follows a WeibullMax :math:`(\beta, \alpha, \gamma)` distribution, then  :math:`(-X)` follows a WeibullMin :math:`(\beta, \alpha, -\gamma)` distribution.

    See also
    --------
    WeibullMin

    Examples
    --------
    Create a distribution from its native parameters :math:`(\beta, \alpha, \gamma)`:

    >>> import openturns as ot
    >>> myDist = ot.WeibullMax(2.0, 1.5, 3.0)

    Create it from the alternative parametrization :math:`(\mu, \sigma, \gamma)`:

    >>> myDist2 = ot.WeibullMax()
    >>> myDist2.setParameter(ot.WeibullMaxMuSigma()([2.8, 1.2, 4.6]))

    Create it from :math:`(\mu, \sigma, \gamma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.WeibullMaxMuSigma(2.8, 1.2, 4.6)
    >>> myDist3 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.WeibullMax_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.WeibullMax___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.WeibullMax___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.WeibullMax___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.WeibullMax_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.WeibullMax_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.WeibullMax_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.WeibullMax_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.WeibullMax_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.WeibullMax_computeComplementaryCDF(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.WeibullMax_computeScalarQuantile(self, prob, tail)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle1.WeibullMax_computeProbability(self, interval)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.WeibullMax_computeCharacteristicFunction(self, x)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.WeibullMax_computeEntropy(self)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.WeibullMax_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.WeibullMax_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.WeibullMax_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.WeibullMax_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.WeibullMax_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.WeibullMax_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.WeibullMax_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.WeibullMax_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.WeibullMax_getParameterDescription(self)

    def setBeta(self, beta):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Parameters
        ----------
        beta : float, :math:`\beta > 0`
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle1.WeibullMax_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Returns
        -------
        beta : float
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle1.WeibullMax_getBeta(self)

    def setAlpha(self, alpha):
        r"""
        Accessor to the distribution's shape parameter :math:`\alpha`.

        Parameters
        ----------
        alpha : float, :math:`\alpha > 0`
            Shape parameter :math:`\alpha`.
        """
        return _dist_bundle1.WeibullMax_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Accessor to the distribution's shape parameter :math:`\alpha`.

        Returns
        -------
        alpha : float
            Shape parameter :math:`\alpha`.
        """
        return _dist_bundle1.WeibullMax_getAlpha(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the distribution's location parameter :math:`\gamma`.

        Parameters
        ----------
        gamma : float
            Location parameter :math:`\gamma`.
        """
        return _dist_bundle1.WeibullMax_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the distribution's location parameter :math:`\gamma`.

        Returns
        -------
        gamma : float
            Location parameter :math:`\gamma`.
        """
        return _dist_bundle1.WeibullMax_getGamma(self)

    def __init__(self, *args):
        _dist_bundle1.WeibullMax_swiginit(self, _dist_bundle1.new_WeibullMax(*args))
    __swig_destroy__ = _dist_bundle1.delete_WeibullMax

# Register WeibullMax in _dist_bundle1:
_dist_bundle1.WeibullMax_swigregister(WeibullMax)
class WeibullMaxFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    WeibullMax factory.

    See also
    --------
    DistributionFactory, WeibullMax

    Notes
    -----
    Note that if :math:`X` follows a WeibullMax :math:`(\beta, \alpha, \gamma)` distribution, then  :math:`(-X)` follows a WeibullMin :math:`(\beta, \alpha, -\gamma)` distribution.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.WeibullMaxFactory_getClassName(self)

    def build(self, *args):
        r"""
        Estimate the distribution using the default strategy.


        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : Collection of  :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The estimated distribution

        Notes
        -----
        Note that if :math:`X` follows a WeibullMax :math:`(\beta, \alpha, \gamma)` distribution, then  :math:`(-X)`follows a WeibullMin :math:`(\beta, \alpha, -\gamma)` distribution.
        The sample is transformed into its opposite and a WeibullMin :math:`(\beta, \alpha, \gamma)` is fitted on it. We return the WeibullMax :math:`(\beta, \alpha, -\gamma)` distribution.
        We use the default strategy of  :class:`~openturns.WeibullMinFactory`.
        """
        return _dist_bundle1.WeibullMaxFactory_build(self, *args)

    def buildAsWeibullMax(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsWeibullMax()

            buildAsWeibullMax(*sample*)

            buildAsWeibullMax(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the :class:`~openturns.WeibullMax`.

        Returns
        -------
        dist : :class:`~openturns.WeibullMax`
            The estimated distribution as a WeibullMax.

            In the first usage, the default WeibullMax distribution is built.
        """
        return _dist_bundle1.WeibullMaxFactory_buildAsWeibullMax(self, *args)

    def __init__(self, *args):
        _dist_bundle1.WeibullMaxFactory_swiginit(self, _dist_bundle1.new_WeibullMaxFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_WeibullMaxFactory

# Register WeibullMaxFactory in _dist_bundle1:
_dist_bundle1.WeibullMaxFactory_swigregister(WeibullMaxFactory)
class WeibullMaxMuSigma(openturns.model_copula.DistributionParametersImplementation):
    r"""
    WeibullMax distribution parameters.

    Parameters
    ----------
    mu : float
        Mean.

        Default value is 1.0.
    sigma : float
        Standard deviation :math:`\sigma > 0`.

        Default value is 1.0.
    gamma : float, optional
        Shift parameter :math:`\gamma > \mu`.

        Default value is 0.0.

    Notes
    -----
    The native parameters :math:`\alpha` and :math:`\beta` are searched such as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \mu & = & \gamma - \beta \,\Gamma\left(1 + \frac{1}{\alpha}\right)\\
            \sigma^2 & = & \beta^2 \left( \Gamma \left( 1 + \frac{2}{\alpha} \right) -
                         \Gamma^2 \left( 1 + \frac{1}{\alpha} \right) \right)
        \end{eqnarray*}

    The :math:`\gamma` parameter is the same.

    See also
    --------
    WeibullMax

    Examples
    --------
    Create the parameters :math:`(\mu, \sigma, \gamma)` of the WeibullMax distribution:

    >>> import openturns as ot
    >>> parameters = ot.WeibullMaxMuSigma(1.3, 1.23, 3.1)

    Convert parameters into the native parameters :math:`(\beta, \alpha, \gamma)`:

    >>> print(parameters.evaluate())
    [1.99222,1.48961,3.1]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.WeibullMaxMuSigma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.WeibullMaxMuSigma___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.WeibullMaxMuSigma_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle1.WeibullMaxMuSigma_gradient(self)

    def __call__(self, inP):
        return _dist_bundle1.WeibullMaxMuSigma___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.WeibullMaxMuSigma_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.WeibullMaxMuSigma_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.WeibullMaxMuSigma_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.WeibullMaxMuSigma_getDescription(self)

    def __repr__(self):
        return _dist_bundle1.WeibullMaxMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.WeibullMaxMuSigma___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle1.WeibullMaxMuSigma_swiginit(self, _dist_bundle1.new_WeibullMaxMuSigma(*args))
    __swig_destroy__ = _dist_bundle1.delete_WeibullMaxMuSigma

# Register WeibullMaxMuSigma in _dist_bundle1:
_dist_bundle1.WeibullMaxMuSigma_swigregister(WeibullMaxMuSigma)
class GeneralizedExtremeValue(openturns.model_copula.DistributionImplementation):
    r"""
    Generalized ExtremeValue distribution.

    Available constructors:
        GeneralizedExtremeValue(*mu, sigma, xi*)

        GeneralizedExtremeValue(*distribution*)

    Parameters
    ----------
    mu : float
        Position parameter :math:`\mu`.

        Default value is 0.0.
    sigma : float, :math:`\sigma > 0`
        Scale parameter :math:`\sigma >0`.

        Default value is 1.0.
    xi : float
        Shape parameter :math:`\xi`.

        Default value is 0.0.
    distribution : :class:`~openturns.WeibullMax`, :class:`~openturns.Frechet` or :class:`~openturns.Gumbel`
        The underlying distribution.

    Notes
    -----
    Its cumulative distribution function and its probability density function are defined as:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            F_X(x) &  = & \exp(-t(x)), \quad \forall x \in \cS \\
            p_X(x) & = & \dfrac{1}{\sigma}t^{1+\xi} \exp(-t(x)), \quad \forall x \in \cS
        \end{eqnarray*}

    where 

    .. math::
        :nowrap:

        \begin{eqnarray*}
            t(x) &  = & \left(1+\xi \dfrac{x-\mu}{\sigma}\right)^{-1/\xi} \quad \text{ if } \xi \neq 0\\
            t(x) &  = & \exp \left(- \dfrac{x-\mu}{\sigma}\right) \quad \text{ if } \xi= 0
        \end{eqnarray*}

    and 

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \cS &  = &  [\mu-\sigma/\xi, +\infty) \quad \text{ if } \xi > 0\\
                &  = &  \Rset \quad \text{ if } \xi = 0\\
                &  = &  (-\infty,\mu-\sigma/\xi] \quad \text{ if } \xi < 0
        \end{eqnarray*}


    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
        \Expect{X} & = & \mu+\dfrac{\sigma}{\xi}\left(\Gamma(1-\xi)-1\right) \quad \text{ if } \xi < 1, \xi\neq 0 \\
                   & = &     \mu + \sigma\gamma_e \quad \text{ if } \xi= 0 \\
                   & = &    \infty  \quad \text{ if } \xi \geq 1
        \end{eqnarray*}

        \begin{eqnarray*}
            \Var{X} & = &  \dfrac{\sigma^2}{\xi^2}\left(\Gamma(1-2\xi)-\Gamma^2(1-\xi)\right) \quad \text{ if } \xi < 1/2, \xi\neq 0 \\
                    & = & \dfrac{1}{6} \sigma^2\pi^2 \quad \text{ if } \xi= 0 \\
                    & = & \infty \quad \text{ if } \xi \geq 1/2
        \end{eqnarray*}

    where :math:`\gamma_e` is Euler's constant.


    When the constructor from a :class:`~openturns.WeibullMax`:math:`(\beta, \alpha, \gamma)` distribution is used,  then it creates :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, \xi)` where:

    .. math::
        :nowrap:

        \begin{eqnarray*}
           \mu & = & \gamma - \beta \\
           \sigma & = & \dfrac{\beta}{\alpha} \\
           \xi & = & -\dfrac{1}{\alpha}
        \end{eqnarray*}



    When the constructor from a :class:`~openturns.Frechet`:math:`(\beta, \alpha, \gamma)` distribution is used,  then it creates :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, \xi)` where:

    .. math::
        :nowrap:

        \begin{eqnarray*}
           \mu & = & \gamma + \beta \\
           \sigma & = & \dfrac{\beta}{\alpha} \\
           \xi & = & \dfrac{1}{\alpha}
        \end{eqnarray*}



    When the constructor from a :class:`~openturns.Gumbel`:math:`(\beta, \gamma)` distribution is used,  then it creates :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, \xi)` where:

    .. math::
        :nowrap:

        \begin{eqnarray*}
           \mu & = & \gamma  \\
           \sigma & = & \beta \\
           \xi & = & 0.0
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> dist1 = ot.GeneralizedExtremeValue(1.0, 2.0, -0.2)

    Create it from a Frechet distribution:

    >>> frechet = ot.Frechet(1.0, 2.0, 3.0)
    >>> dist1 = ot.GeneralizedExtremeValue(frechet)

    Draw a sample:

    >>> sample = dist1.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GeneralizedExtremeValue_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.GeneralizedExtremeValue___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle1.GeneralizedExtremeValue___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GeneralizedExtremeValue___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle1.GeneralizedExtremeValue_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.GeneralizedExtremeValue_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle1.GeneralizedExtremeValue_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _dist_bundle1.GeneralizedExtremeValue_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.GeneralizedExtremeValue_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _dist_bundle1.GeneralizedExtremeValue_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle1.GeneralizedExtremeValue_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _dist_bundle1.GeneralizedExtremeValue_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.GeneralizedExtremeValue_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getParameterDescription(self)

    def setMu(self, mu):
        r"""
        Accessor to the distribution's position parameter :math:`\mu`.

        Parameters
        ----------
        mu : float
            Position parameter :math:`\mu`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_setMu(self, mu)

    def getMu(self):
        r"""
        Accessor to the distribution's position parameter :math:`\mu`.

        Returns
        -------
        mu : float
            Position parameter :math:`\mu`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getMu(self)

    def setSigma(self, sigma):
        r"""
        Accessor to the distribution's scale parameter :math:`\sigma`.

        Parameters
        ----------
        sigma : float, :math:`\sigma > 0`
            Scale parameter :math:`\sigma`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_setSigma(self, sigma)

    def getSigma(self):
        r"""
        Accessor to the distribution's scale parameter :math:`\sigma`.

        Returns
        -------
        sigma : float
            Scale parameter :math:`\sigma`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getSigma(self)

    def setXi(self, xi):
        r"""
        Accessor to the distribution's shape parameter :math:`\xi`.

        Parameters
        ----------
        xi : float, :math:`\xi \in \Rset`
            Shape parameter :math:`\xi`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_setXi(self, xi)

    def getXi(self):
        r"""
        Accessor to the distribution's shape parameter :math:`\xi`.

        Returns
        -------
        xi : float
            Shape parameter :math:`\xi`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getXi(self)

    def setActualDistribution(self, distribution):
        r"""
        Accessor to the internal distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
             The actual distribution in charge of the computation (:class:`~openturns.WeibullMax`, :class:`~openturns.Frechet`, :class:`~openturns.Gumbel`).
        """
        return _dist_bundle1.GeneralizedExtremeValue_setActualDistribution(self, distribution)

    def getActualDistribution(self):
        r"""
        Accessor to the internal distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
             The actual distribution in charge of the computation (:class:`~openturns.WeibullMax`, :class:`~openturns.Frechet`, :class:`~openturns.Gumbel`).
        """
        return _dist_bundle1.GeneralizedExtremeValue_getActualDistribution(self)

    def asFrechet(self):
        r"""
        Temptative conversion to the underlying Frechet distribution.

        Returns
        -------
        distribution : :class:`~openturns.Frechet`
             The underlying Frechet distribution.

        Notes
        -----
        If :math:`\xi >0` then the :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, \xi)` is actually a :class:`~openturns.Frechet`:math:`(\beta, \alpha, \gamma)` distribution where:

        .. math::
            :nowrap:

            \begin{eqnarray*}
               \beta & = & \dfrac{\sigma}{\xi} \\
               \alpha & = & \dfrac{1}{\xi} \\
               \gamma & = & \mu - \dfrac{\sigma}{\xi}
            \end{eqnarray*}

        """
        return _dist_bundle1.GeneralizedExtremeValue_asFrechet(self)

    def asWeibullMax(self):
        r"""
        Temptative conversion to the underlying WeibullMax distribution.

        Returns
        -------
        distribution : :class:`~openturns.WeibullMax`
             The underlying WeibullMax  distribution.

        Notes
        -----
        If :math:`\xi <0` then the :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, \xi)` is actually a :class:`~openturns.WeibullMax`:math:`(\beta, \alpha, \gamma)` distribution where:

        .. math::
            :nowrap:

            \begin{eqnarray*}
               \beta & = & -\dfrac{\sigma}{\xi} \\
               \alpha & = & -\dfrac{1}{\xi} \\
               \gamma & = & \mu - \dfrac{\sigma}{\xi}
            \end{eqnarray*}

        """
        return _dist_bundle1.GeneralizedExtremeValue_asWeibullMax(self)

    def asGumbel(self):
        r"""
        Temptative conversion to the underlying Gumbel distribution.

        Returns
        -------
        distribution : :class:`~openturns.Gumbel`
             The underlying Gumbel distribution.

        Notes
        -----
        If :math:`\xi =0` then the :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, 0.0)` is actually a :class:`~openturns.Gumbel`:math:`(\beta, \gamma)` distribution where:

        .. math::
            :nowrap:

            \begin{eqnarray*}
               \beta & = & \sigma \\
               \gamma & = & \mu 
            \end{eqnarray*}

        """
        return _dist_bundle1.GeneralizedExtremeValue_asGumbel(self)

    def computeReturnLevel(self, m):
        r"""
        Accessor to the return level.

        Parameters
        ----------
        m : float
            Return period

        Returns
        -------
        q : float
            Return level computed as the quantile of level :math:`1-1/m`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeReturnLevel(self, m)

    def drawReturnLevel(self):
        r"""
        Plot the return level.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Return level graph.

        Notes
        -----
        The return level plot bounds are defined by the :class:`~openturns.ResourceMap`
        entries `GeneralizedExtremeValue-MMin` and `GeneralizedExtremeValue-MMax`
        """
        return _dist_bundle1.GeneralizedExtremeValue_drawReturnLevel(self)

    def __init__(self, *args):
        _dist_bundle1.GeneralizedExtremeValue_swiginit(self, _dist_bundle1.new_GeneralizedExtremeValue(*args))
    __swig_destroy__ = _dist_bundle1.delete_GeneralizedExtremeValue

# Register GeneralizedExtremeValue in _dist_bundle1:
_dist_bundle1.GeneralizedExtremeValue_swigregister(GeneralizedExtremeValue)
class GeneralizedExtremeValueFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    GeneralizedExtremeValue factory.

    See also
    --------
    DistributionFactory, GeneralizedExtremeValue, FrechetFactory, GumbelFactory, WeibullMaxFactory

    Notes
    -----
    Several estimators to build a GeneralizedExtremeValueFactory distribution from a scalar sample
    are proposed. The details are given in the methods documentation.

    The following :class:`~openturns.ResourceMap` entries can be used to tweak
    the parameters of the optimization solver involved in the different estimators:

    - `GeneralizedExtremeValueFactory-DefaultOptimizationAlgorithm`
    - `GeneralizedExtremeValueFactory-MaximumCallsNumber`
    - `GeneralizedExtremeValueFactory-MaximumAbsoluteError`
    - `GeneralizedExtremeValueFactory-MaximumRelativeError`
    - `GeneralizedExtremeValueFactory-MaximumObjectiveError`
    - `GeneralizedExtremeValueFactory-MaximumConstraintError`
    - `GeneralizedExtremeValueFactory-InitializationMethod`
    - `GeneralizedExtremeValueFactory-NormalizationMethod`

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_getClassName(self)

    def build(self, *args):
        r"""
        Estimate the distribution via maximum likelihood.


        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            The block maxima sample of dimension 1 from which
            :math:`\vect{\theta} = (\mu, \sigma, \xi)` are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.GeneralizedExtremeValue`.

        Returns
        -------
        distribution : :class:`~openturns.GeneralizedExtremeValue`
            The estimated distribution.

        Notes
        -----
        The estimation strategy described in :meth:`buildAsGeneralizedExtremeValue` is followed.
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildEstimator(self, *args)

    def buildAsGeneralizedExtremeValue(self, *args):
        r"""
        Estimate the distribution as native distribution.


        **Available usages**:

            buildAsGeneralizedExtremeValue()

            buildAsGeneralizedExtremeValue(*sample*)

            buildAsGeneralizedExtremeValue(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            The block maxima sample of dimension 1 from which
            :math:`\vect{\theta} = (\mu, \sigma, \xi)` are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.GeneralizedExtremeValue`.

        Returns
        -------
        distribution : :class:`~openturns.GeneralizedExtremeValue`
            The estimated distribution as a GeneralizedExtremeValue.

            In the first usage, the default GeneralizedExtremeValue distribution is built.

        Notes
        -----
        The estimate maximizes the log-likelihood of the model.
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildAsGeneralizedExtremeValue(self, *args)

    def buildMethodOfXiProfileLikelihoodEstimator(self, sample, r=0):
        r"""
        Estimate the distribution and the parameter distribution with the profile likelihood.

        Parameters
        ----------
        sample : 2-d sequence of float
            Block maxima grouped in a sample of size :math:`n` and dimension :math:`R`.
        r : int, :math:`1 \leq r \leq R`,
            Number of largest order statistics taken into account among the :math:`R` stored ones.
            The block maxima sample of dimension 1 from which
            :math:`\vect{\theta} = (\mu, \sigma, \xi)` are estimated.

            By default, :math:`r=0` which means that all the maxima are used.

        Returns
        -------
        result : :class:`~openturns.ProfileLikelihoodResult`
            The result class.

        Notes
        -----
        The method estimates a GEV distribution parameterized by :math:`\vect{\theta} = (\mu, \sigma, \xi)` from a given sample.

        The estimator :math:`\hat{\vect{\theta}}` is defined in :meth:`buildMethodOfXiProfileLikelihood`.

        The result class produced by the method provides:

        - the GEV distribution associated to :math:`(\hat{\mu}, \hat{\sigma}, \hat{\xi})`,
        - the asymptotic distribution of :math:`(\hat{\mu}, \hat{\sigma}, \hat{\xi})`,
        - the profile log-likelihood function :math:`\xi \mapsto \ell_p(\xi)`,
        - the optimal profile log-likelihood value :math:`\ell_p(\hat{\xi})`,
        - confidence intervals of level :math:`(1-\alpha)` of :math:`\xi`.
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildMethodOfXiProfileLikelihoodEstimator(self, sample, r)

    def buildMethodOfXiProfileLikelihood(self, sample, r=0):
        r"""
        Estimate the distribution with the profile likelihood.

        Parameters
        ----------
        sample : 2-d sequence of float
            Block maxima grouped in a sample of size :math:`n` and dimension :math:`R`.
        r : int, :math:`1 \leq r \leq R`,
            Number of largest order statistics taken into account among the :math:`R` stored ones.

            By default, :math:`r=0` which means that all the maxima are used.

        Returns
        -------
        distribution : :class:`~openturns.GeneralizedExtremeValue`
            The estimated distribution.

        Notes
        -----
        The method estimates a GEV distribution parameterized by :math:`\vect{\theta} = (\mu, \sigma, \xi)` from a given sample.

        The estimator :math:`\hat{\vect{\theta}}` is defined using a nested numerical optimization of the log-likelihood:

        .. math::

            \ell_p (\xi) = \max_{(\mu, \sigma)} \ell (\mu, \sigma, \xi)

        where :math:`\ell (\mu, \sigma, \xi)` is detailed in equations :eq:`llR1` and :eq:`llR2` with :math:`r=1`.

        If :math:`\xi = 0` then:

        .. math::

            \hat{\xi}  & =  \argmax_{\xi} \ell_p(\xi)\\
            (\hat{\mu}, \hat{\sigma})  & =  \argmax_{(\mu, \sigma)} \ell(\mu, \sigma, \hat{\xi})

        The starting point of the optimization is initialized from the probability weighted moments method, see [diebolt2008]_.

        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildMethodOfXiProfileLikelihood(self, sample, r)

    def buildMethodOfLikelihoodMaximizationEstimator(self, sample, r=0):
        r"""
        Estimate the distribution and the parameter distribution with the R-maxima method.

        Parameters
        ----------
        sampleM : 2-d sequence of float
            Block maxima  grouped in a sample of size :math:`n` and dimension :math:`R`.
        r : int, :math:`1 \leq r \leq R`, optional
            Number of order statistics taken into account among the :math:`R` stored ones.

            By default, :math:`r=0` which means that all the maxima are used.

        Returns
        -------
        result : :class:`~openturns.DistributionFactoryLikelihoodResult`
            The result class.

        Notes
        -----
        The method estimates a GEV distribution parameterized by :math:`\vect{\theta} = (\mu, \sigma, \xi)` from a given sample.

        The estimator :math:`\hat{\vect{\theta}}` is defined using the profile log-likelihood  as detailed in
        :meth:`buildMethodOfLikelihoodMaximization`.

        The result class produced by the method provides:

        - the GEV distribution associated to :math:`(\hat{\mu}, \hat{\sigma}, \hat{\xi})`,
        - the asymptotic distribution of :math:`(\hat{\mu}, \hat{\sigma}, \hat{\xi})`.
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildMethodOfLikelihoodMaximizationEstimator(self, sample, r)

    def buildMethodOfLikelihoodMaximization(self, sample, r=0):
        r"""
        Estimate the distribution from the :math:`r` largest order statistics.

        Parameters
        ----------
        sample : 2-d sequence of float
            Block maxima grouped in a sample of size :math:`n` and dimension :math:`R`.
        r : int, :math:`1 \leq r \leq R`,
            Number of largest order statistics taken into account among the :math:`R` stored ones.

            By default, :math:`r=0` which means that all the maxima are used.

        Returns
        -------
        distribution : :class:`~openturns.GeneralizedExtremeValue`
            The estimated distribution.

        Notes
        -----
        The method estimates a GEV distribution parameterized by :math:`\vect{\theta} = (\mu, \sigma, \xi)` from a given sample.

        Let us suppose we have a series of independent and identically distributed variables and that data are grouped
        into :math:`n` blocks. In each block, the largest :math:`R` observations are recorded.

        We define the series
        :math:`M_i^{(R)} = (z_i^{(1)}, \hdots, z_i^{(R)})` for :math:`1 \leq i \leq n` where the values are sorted
        in decreasing order.

        The estimator of :math:`(\mu, \sigma, \xi)` maximizes  the log-likelihood built from the :math:`r` largest order statistics,
        with :math:`1 \leq r \leq R` defined as:

        If :math:`\xi \neq 0`, then:

        .. math::
            :label: llR1

            \ell(\mu, \sigma, \xi) = -nr \log \sigma - \sum_{i=1}^n   \biggl[ 1 + \xi \Bigl( \frac{z_i^{(r)} - \mu }{\sigma} \Bigr) \biggr]^{-1/\xi}  -\left(\dfrac{1}{\xi} +1 \right)  \sum_{i=1}^n \sum_{k=1}^r  \log \biggl[ 1 + \xi \Bigl( \frac{z_i^{(k)} - \mu }{\sigma} \Bigr) \biggr] 


        defined on :math:`(\mu, \sigma, \xi)` such that :math:`1+\xi \left( \frac{z_i^{(k)} - \mu}{\sigma} \right) > 0`
        for all :math:`1 \leq i \leq m` and :math:`1 \leq k \leq r`.

        If :math:`\xi = 0`, then:

        .. math::
            :label: llR2

            \ell(\mu, \sigma, \xi) = -nr \log \sigma - \sum_{i=1}^n   \exp \biggl[ - \Bigl( \frac{z_i^{(r)} - \mu }{\sigma} \Bigr) \biggr] - \sum_{i=1}^n \sum_{k=1}^r  \Bigl( \frac{z_i^{(k)} - \mu }{\sigma} \Bigr)

        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildMethodOfLikelihoodMaximization(self, sample, r)

    def buildCovariates(self, *args):
        r"""
        Estimate a GEV from covariates.

        Parameters
        ----------
        sample : 2-d sequence of float
            The block maxima grouped in a sample of size :math:`m` and one dimension.
        covariates : 2-d sequence of float
            Covariates sample.
            A constant column is automatically added if it is not provided.
        muIndices : sequence of int, optional
            Indices of covariates considered for parameter :math:`\mu`.

            By default, an empty sequence.

            The index of the constant covariate is added
            if empty or if the covariates do not initially contain a constant column.
        sigmaIndices : sequence of int, optional
            Indices of covariates considered for parameter :math:`\sigma`.

            By default, an empty sequence.

            The index of the constant covariate is added
            if empty or if the covariates do not initially contain a constant column.
        xiIndices : sequence of int, optional
            Indices of covariates considered for parameter :math:`\xi`.

            By default, an empty sequence.

            The index of the constant covariate is added
            if empty or if the covariates do not initially contain a constant column.
        muLink : :class:`~openturns.Function`, optional
            The :math:`h_{\mu}` function.

            By default, the identity function.
        sigmaLink : :class:`~openturns.Function`, optional
            The :math:`h_{\sigma}` function.

            By default, the identity function.
        xiLink : :class:`~openturns.Function`, optional
            The :math:`h_{\xi}` function.

            By default, the identity function.
        initializationMethod : str, optional
            The initialization method for the optimization problem: *Gumbel* or *Static*.

            By default, the method *Gumbel* (see :class:`~openturns.ResourceMap`, key
            *GeneralizedExtremeValueFactory-InitializationMethod*).
        normalizationMethod : str, optional
            The data normalization method: *CenterReduce*, *MinMax* or *None*.

            By default, the method *MinMax* (see :class:`~openturns.ResourceMap`, key
            *GeneralizedExtremeValueFactory-NormalizationMethod*).

        Returns
        -------
        result : :class:`~openturns.CovariatesResult`
            The result class.

        Notes
        -----
        Let :math:`Z_{\vect{y}}` be a GEV model whose parameters depend on :math:`d` covariates
        denoted by :math:`\vect{y} = \Tr{(y_1, \dots, y_d)}`:

        .. math::

            Z_{\vect{y}} \sim \mbox{GEV}(\mu(\vect{y}), \sigma(\vect{y}), \xi(\vect{y}))

        We denote by :math:`(z_{\vect{y}_1}, \dots, z_{\vect{y}_n})`
        the values of :math:`Z_{\vect{y}}` associated to the values of the
        covariates :math:`(\vect{y}_1, \dots, \vect{y}_n)`.

        For numerical reasons, it is recommended to normalize the covariates. Each covariate
        :math:`y_k` has its own normalization:

        .. math::

            \tilde{y}_k = \tau_k(y_k) = \dfrac{y_k-c_k}{d_k}

        and with three ways of defining :math:`(c_k,d_k)` of the covariate :math:`y_k`:

        - the *CenterReduce* method where :math:`c_k = \dfrac{1}{n} \sum_{i=1}^n y_{k,i}` is the
          covariate mean and :math:`d_k = \sqrt{\dfrac{1}{n} \sum_{i=1}^n (y_{k,i}-c_k)^2}` is the standard deviation of the covariates;
        - the *MinMax* method where :math:`c_k = \min_i y_{k,i}` is the min value of the covariate
          :math:`y_k` and :math:`d_k = \max_i y_{k,i}- \min_i y_{k,i}` its range. This is the default method;
        - the *None* method where :math:`c_k = 0` and :math:`d_k = 1`: in that case, data are not
          normalized.

        Let :math:`\vect{\theta} = (\mu, \sigma, \xi)` be the vector of parameters. Then, :math:`\vect{\theta}` depends on all the :math:`d` covariates
        even if each component of :math:`\vect{\theta}` only depends on a subset of the covariates. We
        denote by :math:`(y_1^q, \dots, y_{d_q}^q)` the :math:`d_q` covariates involved in the
        modelling of the component :math:`\theta_q`.

        Each component :math:`\theta_q` can be written as a function of the normalized covariates:

        .. math::

            \theta_q(y_1^q, \dots, y_{d_q}^q)  & = h_q\left(\sum_{i=1}^{d_q} \tilde{\beta}
            _i^q\tilde{y}_i^q \right)

        This relation can be written  as a function of the real covariates:

        .. math::

            \theta_q(y_1^q, \dots, y_{d_q}^q)  & = h_q\left(\sum_{i=1}^{d_q} \beta_i^qy_i^q +
            \beta_{d_q+1}^q \right)

        where:

        - :math:`h_q: \Rset \mapsto \Rset` is usually referred to as the *inverse-link function* of
          the component :math:`\theta_q`,
        - each :math:`\beta_i^{q} \in \Rset`.

        To allow some parameters to remain constant, i.e. independent of the covariates
        (this will generally be the case for the parameter :math:`\xi`), the library systematically
        adds the constant covariate to the speciﬁed covariates.

        The complete vector of parameters is defined by:

        .. math::

            \Tr{\vect{b}} & = \Tr{ ( \Tr{\vect{b}_1}, \dots,  \Tr{\vect{b}_p} ) } \in  \Rset^{d_t}\\
            \Tr{\vect{b}_q} & =  (\beta_1^q, \dots, \beta_{d_q}^q) \in \Rset^{d_q}

        where :math:`d_t = \sum_{q=1}^p d_q`.

        The estimator of  :math:`\vect{\beta}` maximizes  the likelihood of the model which is defined
        by:

        .. math::

            L(\vect{\beta}) = \prod_{i=1}^{n} g(z_{\vect{y}_i};\vect{\theta}(\vect{y}_i)))

        where :math:`g(z_{\vect{y}_i};\vect{\theta}(\vect{y}_i))` denotes the GEV density function
        with parameters
        :math:`\vect{\theta}(\vect{y}_i)` and evaluated at :math:`z_{\vect{y}_i}`.

        Then, if none of the :math:`\xi(\vect{y}_i)` is zero, the log-likelihood is defined by:

        .. math::

            \ell (\vect{\beta}) = -\sum_{i=1}^{n} \left\{ \log(\sigma(\vect{y}_i)) + (1 + 1 /
            \xi(\vect{y}
            _i) ) \log\left[ 1+\xi(\vect{y}_i) \left( \frac{z_{\vect{y}_i} - \mu(\vect{y}_i)}
            {\sigma(\vect{y}_i)}\right) \right] + \left[ 1 + \xi(\vect{y}_i) \left( \frac{
            z_{\vect{y}_i}-
            \mu(\vect{y}_i)}{\sigma(\vect{y}_i)} \right) \right]^{-1 / \xi(\vect{y}_i)} \right\}

        defined on :math:`(\mu, \sigma, \xi)` such that :math:`1+\xi \left( \frac{z_{\vect{y}_i} -
        \mu(\vect{y}_i)}{\sigma(\vect{y}_i)} \right) > 0`
        for all :math:`\vect{y}_i`.

        And if any of the :math:`\xi(\vect{y}_i)` is equal to 0, the log-likelihood is defined as:

        .. math::

            \ell (\vect{\beta}) = -\sum_{i=1}^{n} \left\{ \log(\sigma(\vect{y}_i)) + \frac{z_{\vect{y}_i}
            - \mu(\vect{y}_i)}{\sigma(\vect{y}_i)} + \exp \left\{ - \frac{z_{\vect{y}_i} -
            \mu(\vect{y}_i)}{\sigma(\vect{y}_i)} \right\} \right\}

        The initialization of the optimization problem is crucial.
        Two initial points :math:`(\mu_0, \sigma_0, \xi_0)` are proposed:

        - the *Gumbel* initial point: in that case, we assume that the GEV is a stationary Gumbel
          distribution and we deduce
          :math:`(\mu_0, \sigma_0)` from the mean :math:`\hat{M}` and standard variation :math:`\hat{\sigma}` of the data:
          :math:`\sigma_0 = \dfrac{\sqrt{6}}{\pi} \hat{\sigma}` and :math:`\mu_0 = \hat{M} - \gamma
          \sigma_0` where
          :math:`\gamma` is Euler's constant; then we take the initial point :math:`(\mu_0, \sigma_0, \xi_0 = 0.1)`. This is the default initial point;
        - the *Static* initial point: in that case, we assume that the GEV is stationary and
          :math:`(\mu_0, \sigma_0, \xi_0)`
          is the maximum likelihood estimate resulting from that assumption.

        The result class provides:

        - the estimator :math:`\hat{\vect{\beta}}`,
        - the asymptotic distribution of :math:`\hat{\vect{\beta}}`,
        - the parameter function :math:`(\vect{\beta}, \vect{y}) \mapsto \vect{\theta}(\vect{\beta},
          \vect{y})`,
        - the graphs of the parameter functions :math:`y_k \mapsto \theta_q(\vect{y})`, where all the components of
          :math:`\vect{y}` are fixed to a reference value excepted for :math:`y_k`, for each :math:`k`,
        - the graphs of the parameter functions :math:`(y_k, y_\ell) \mapsto\theta_q(\vect{y})`, where all the
          components of :math:`\vect{y}` are fixed to a reference value excepted for
          :math:`(y_k, y_\ell)`, for each :math:`(k,\ell)`,
        - the normalizing function :math:`\vect{y} \mapsto (\tau_1(y_1), \dots, \tau_d(y_d))`,
        - the optimal log-likelihood value :math:`\hat{\vect{\beta}}`,
        - the GEV distribution at covariate :math:`\vect{y}`,
        - the graphs of the quantile functions of order :math:`p`: :math:`y_k \mapsto q_p(Z_{\vect{y}})` where all the components
          of :math:`\vect{y}` are fixed to a reference value excepted for :math:`y_k`, for each :math:`k`,
        - the graphs of the quantile functions of order :math:`p`: :math:`(y_k, y_\ell) \mapsto q_p(Z_{\vect{y}})`
          where all the components of :math:`\vect{y}` are fixed to a
          reference value excepted for :math:`(y_k, y_\ell)`, for each :math:`(k,\ell)`.
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildCovariates(self, *args)

    def buildTimeVarying(self, *args):
        r"""
        Estimate a non stationary GEV from a time-dependent parametric model.

        Parameters
        ----------
        sample : 2-d sequence of float
            The block maxima grouped in a sample of size :math:`m` and one dimension.
        timeStamps : 2-d sequence of float
            Values of :math:`t`.
        basis : :class:`~openturns.Basis`
            Functional basis respectively for :math:`\mu(t)`, :math:`\sigma(t)` and :math:`\xi(t)`.
        muIndices : sequence of int, optional
            Indices of basis terms considered for parameter :math:`\mu`
        sigmaIndices : sequence of int, optional
            Indices of basis terms considered for parameter :math:`\sigma`
        xiIndices : sequence of int, optional
            Indices of basis terms considered for parameter :math:`\xi`
        muLink : :class:`~openturns.Function`, optional
            The :math:`h_{\mu}` function.

            By default, the identity function.
        sigmaLink : :class:`~openturns.Function`, optional
            The :math:`h_{\sigma}` function.

            By default, the identity function.
        xiLink : :class:`~openturns.Function`, optional
            The :math:`h_{\xi}` function.

            By default, the identity function.
        initializationMethod : str, optional
            The initialization method for the optimization problem: *Gumbel* or *Static*.

            By default, the method *Gumbel* (see :class:`~openturns.ResourceMap`, key
            *GeneralizedExtremeValueFactory-InitializationMethod*).
        normalizationMethod : str, optional
            The data normalization method: *CenterReduce*, *MinMax* or *None*.

            By default, the method *MinMax* (see :class:`~openturns.ResourceMap`, key
            *GeneralizedExtremeValueFactory-NormalizationMethod*).

        Returns
        -------
        result : :class:`~openturns.TimeVaryingResult`
            The result class.

        Notes
        -----
        Let :math:`Z_t` be a non stationary GEV distribution:

        .. math::

            Z_t \sim \mbox{GEV}(\mu(t), \sigma(t), \xi(t))

        We denote by :math:`(z_{t_1}, \dots, z_{t_n})` the values of
        :math:`Z_t` on the time stamps :math:`(t_1, \dots, t_n)`.

        For numerical reasons, it is recommended to normalize the time stamps.
        The following mapping is applied:

        .. math::

            \tau(t) = \dfrac{t-c}{d}

        and with three ways of defining :math:`(c,d)`:

        - the *CenterReduce* method where :math:`c = \dfrac{1}{n} \sum_{i=1}^n t_i` is the mean time
          stamps
          and :math:`d = \sqrt{\dfrac{1}{n} \sum_{i=1}^n (t_i-c)^2}` is the standard deviation of the time stamps;
        - the *MinMax* method where :math:`c = t_1` is the first time and :math:`d = t_n-t_1` the
          range of the time stamps. This is the default method;
        - the *None* method where :math:`c = 0` and :math:`d = 1`: in that case, data are not
          normalized.

        If we denote by :math:`\theta_q` is a component of :math:`\vect{\theta} = (\mu, \sigma, \xi)`,
        then  :math:`\theta_q` can be written as a function of :math:`t`: 

        .. math::

            \theta_q(t)  = h_q\left(\sum_{i=1}^{d_{\theta_q}} \beta_i^{\theta_q} \varphi_i^{\theta_q}
            (\tau(t))\right)

        where:

        - :math:`d_{\theta_q}` is the size of the functional basis involved in the modelling of
          :math:`\theta_q`,
        - :math:`h_q: \Rset \mapsto \Rset` is usually referred to as the *inverse-link function* of
          the parameter :math:`\theta_q`,
        - each :math:`\varphi_i^{\theta_q}` is a scalar function :math:`\Rset \mapsto \Rset`,
        - each :math:`\beta_i^{j} \in \Rset`.

        We denote by :math:`d_{\mu}`, :math:`d_{\sigma}` and :math:`d_{\xi}` the size of the functional basis of
        :math:`\mu`, :math:`\sigma` and :math:`\xi` respectively. We denote by
        :math:`\vect{\beta} = (\beta_1^{\mu}, \dots, \beta_{d_{\mu}}^{\mu}, \beta_1^{\sigma}, \dots, \beta_{d_{\sigma}}^{\sigma}, \beta_1^{\xi}, \dots, \beta_{d_{\xi}}^{\xi})`
        the complete vector of parameters.

        The estimator of  :math:`\vect{\beta}` maximizes  the likelihood of the non stationary model which is defined by:

        .. math::

            L(\vect{\beta}) = \prod_{i=1}^{n} g(z_{t_i};\mu(t_i), \sigma(t_i), \xi(t_i))

        where :math:`g(z_{t};\mu(t), \sigma(t), \xi(t))` denotes the GEV density function with parameters
        :math:`(\mu(t), \sigma(t), \xi(t))` evaluated at :math:`z_t`.

        Then, if none of the :math:`\xi(t_i)` is zero, the log-likelihood is defined by:

        .. math::

            \ell (\vect{\beta}) = -\sum_{i=1}^{n} \left\{ \log(\sigma(t_i)) + (1 + 1 / \xi(t_i) ) \log\left[ 1+\xi(t_i) \left( \frac{z_{t_i} - \mu(t_i)}{\sigma(t_i)}\right) \right] + \left[ 1 + \xi(t_i) \left( \frac{z_{t_i}- \mu(t_i)}{\sigma(t_i)} \right) \right]^{-1 / \xi(t_i)} \right\}

        defined on :math:`(\mu, \sigma, \xi)` such that :math:`1+\xi(t) \left( \frac{z_t - \mu(t)}{\sigma(t)} \right) > 0`
        for all :math:`t`.

        And if any of the :math:`\xi(t)` is equal to 0, the log-likelihood is defined as:

        .. math::

            \ell (\vect{\beta}) = -\sum_{t=1}^{n} \left\{ \log(\sigma(t)) + \frac{z_t - \mu(t)}{\sigma(t)} + \exp \left\{ - \frac{z_t - \mu(t)}{\sigma(t)} \right\} \right\}

        The initialization of the optimization problem is crucial.
        Two initial points :math:`(\mu_0, \sigma_0, \xi_0)` are proposed:

        - the *Gumbel* initial point: in that case, we assume that the GEV is a stationary Gumbel
          distribution and we deduce
          :math:`(\mu_0, \sigma_0)` from the empirical mean :math:`\hat{M}` and the empirical standard variation
          :math:`\hat{\sigma}` of the data:
          :math:`\sigma_0 = \dfrac{\sqrt{6}}{\pi} \hat{\sigma}` and :math:`\mu_0 = \hat{M} - \gamma
          \sigma_0` where
          :math:`\gamma` is Euler's constant; then we take the initial point :math:`(\mu_0, \sigma_0,
          \xi_0 = 0.1)`. This is the default initial point;
        - the *Static* initial point: in that case, we assume that the GEV is stationary and
          :math:`(\mu_0, \sigma_0, \xi_0)`
          is the maximum likelihood estimate resulting from that assumption.

        The result class produced by the method provides:

        - the estimator :math:`\hat{\vect{\beta}}`,
        - the asymptotic distribution of :math:`\hat{\vect{\beta}}`,
        - the parameter functions :math:`t \mapsto \vect{\theta}(t)`,
        - the normalizing function :math:`t \mapsto \tau(t)`,
        - the optimal log-likelihood value :math:`\hat{\vect{\beta}}`,
        - the GEV distribution at time :math:`t`,
        - the quantile functions of order :math:`p`: :math:`t \mapsto q_p(Z_t)`.
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildTimeVarying(self, *args)

    def buildReturnLevelEstimator(self, result, m):
        r"""
        Estimate a return level and its distribution from the GEV parameters.

        Parameters
        ----------
        result : :class:`~openturns.DistributionFactoryResult`
            Likelihood estimation result of a :class:`~openturns.GeneralizedExtremeValue`
        m : float
            The return period expressed in terms of number of blocks.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The asymptotic distribution of :math:`\hat{z}_m`.

        Notes
        -----
        Let :math:`Z` be a random variable which follows a GEV distribution parameterized by
        :math:`\vect{\theta} = (\mu, \sigma, \xi)`.

        The :math:`m`-block return level :math:`z_m` is the level exceeded on average once every :math:`m`
        blocks.
        The :math:`m`-block return level can be translated into the annual-scale: if there
        are :math:`n_y` blocks per year, then the :math:`N`-year return level
        corresponds to the :math:`m`-bock return level where :math:`m = n_yN`.

        The :math:`m`-block return level is defined as the quantile of order :math:`1-p=1-1/m` of the GEV
        distribution:

        If :math:`\xi \neq 0`:

        .. math::
            :label: zm1

            z_m = \mu - \frac{\sigma}{\xi} \left[ 1- (-\log(1-p))^{-\xi}\right]

        If :math:`\xi = 0`:

        .. math::
            :label: zm2

            z_m = \mu - \sigma \log(-\log(1-p))

        The estimator :math:`\hat{z}_m` of :math:`z_m` is deduced from the estimator
        :math:`(\hat{\mu}, \hat{\sigma}, \hat{\xi})` of :math:`(\mu, \sigma, \xi)`. 

        The asymptotic distribution of :math:`\hat{z_m}` is obtained by the Delta method from the asymptotic distribution of
        :math:`(\hat{\mu}, \hat{\sigma}, \hat{\xi})`. It is a normal distribution with mean :math:`\hat{z}_m` and variance:

        .. math::

            \Var{z_m} = (\nabla z_m)^T \mat{V}_n \nabla z_m

        where :math:`\nabla z_m = (\frac{\partial z_m}{\partial \mu}, \frac{\partial z_m}{\partial \sigma}, \frac{\partial z_m}{\partial \xi})`
        and :math:`\mat{V}_n` is the asymptotic covariance of :math:`(\hat{\mu}, \hat{\sigma}, \hat{\xi})`.
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildReturnLevelEstimator(self, result, m)

    def buildReturnLevelProfileLikelihoodEstimator(self, sample, m):
        r"""
        Estimate :math:`(z_m, \sigma, \xi)` and its distribution with the profile likelihood.

        Parameters
        ----------
        sample : 2-d sequence of float
            The block maxima sample of dimension 1.
        m : float
            The return period expressed in terms of number of blocks.

        Returns
        -------
        result : :class:`~openturns.ProfileLikelihoodResult`
            The result class.

        Notes
        -----
        Let :math:`Z` be a random variable which follows a GEV distribution parameterized by
        :math:`\vect{\theta} = (\mu, \sigma, \xi)`.

        The  :math:`m`-block return level :math:`z_m` is defined in :meth:`buildReturnLevelEstimator`.
        The profile log-likelihood :math:`\ell_p(z_m)` is defined in :meth:`buildReturnLevelProfileLikelihood`.

        The estimator of  :math:`(\hat{z}_m, \hat{\sigma}, \hat{\xi})` is defined by:

        .. math::

            \hat{z}_m & = \argmax_{z_m} \ell_p(z_m)\\
            (\hat{\sigma}, \hat{\xi}) & = \argmax_{(\sigma, \xi)} \ell(\hat{z}_m, \sigma, \xi)

        The result class produced by the method provides:

        - the GEV distribution associated to :math:`(\hat{z}_m, \hat{\sigma}, \hat{\xi})`,
        - the asymptotic distribution of :math:`(\hat{z}_m, \hat{\sigma}, \hat{\xi})`,
        - the profile log-likelihood function :math:`z_m \mapsto \ell_p(z_m)`,
        - the optimal profile log-likelihood value :math:`\ell_p(\hat{z}_m)`,
        - confidence intervals of level :math:`(1-\alpha)` of :math:`\hat{z}_m`.
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildReturnLevelProfileLikelihoodEstimator(self, sample, m)

    def buildReturnLevelProfileLikelihood(self, sample, m):
        r"""
        Estimate a return level and its distribution with the profile likelihood.


        Parameters
        ----------
        sample : 2-d sequence of float
            The block maxima sample of dimension 1.

        Returns
        -------
        distribution : :class:`~openturns.Normal`
            The asymptotic distribution of :math:`\hat{z}_m`.

        Notes
        -----
        Let :math:`Z` be a random variable which follows a GEV distribution parameterized by
        :math:`\vect{\theta} = (\mu, \sigma, \xi)`.

        The :math:`m`-return level :math:`z_m` is defined in :meth:`buildReturnLevelEstimator`.

        The estimator is defined using a nested numerical optimization of the log-likelihood:

        .. math::

            \ell_p (z_m) = \max_{(\mu, \sigma)} \ell (z_m, \sigma, \xi)

        where :math:`\ell (z_m, \sigma, \xi)` is the log-likelihood detailed in :eq:`llR1` and :eq:`llR2` with :math:`r=1` and where we substitued
        :math:`\mu` for :math:`z_m` using equations :eq:`zm1` or :eq:`zm2`.

        The estimator :math:`\hat{z}_m` of :math:`z_m` is defined by:

        .. math::

            \hat{z}_m = \argmax_{z_m} \ell_p(z_m)

        The asymptotic distribution of :math:`\hat{z}_m` is normal.

        The starting point of the optimization is initialized from the regular maximum likelihood method.

        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_buildReturnLevelProfileLikelihood(self, sample, m)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the moments.
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the moments.
        """
        return _dist_bundle1.GeneralizedExtremeValueFactory_getOptimizationAlgorithm(self)

    def __init__(self, *args):
        _dist_bundle1.GeneralizedExtremeValueFactory_swiginit(self, _dist_bundle1.new_GeneralizedExtremeValueFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_GeneralizedExtremeValueFactory

# Register GeneralizedExtremeValueFactory in _dist_bundle1:
_dist_bundle1.GeneralizedExtremeValueFactory_swigregister(GeneralizedExtremeValueFactory)
class GeneralizedExtremeValueValidation(openturns.common.PersistentObject):
    r"""
    Validation of GeneralizedExtremeValue inference.

    Parameters
    ----------
    result : :class:`~openturns.DistributionFactoryResult`
        Inference result to validate.
    sample : 2-d sequence of float
        Data on which the inference was performed.

    See also
    --------
    GeneralizedExtremeValueFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GeneralizedExtremeValueValidation_getClassName(self)

    def drawReturnLevel(self):
        r"""
        Draw the return level with confidence interval.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The return level graph.

        Notes
        -----
        The *return level* plot consists of the points:

        .. math::
            \left\{ \left( m, \hat{z}_m\right), m >0 \right\}

        and the points:

        .. math::
            \left\{ \left( m, z_{m}^{emp}\right), m> 0\right\}

        where :math:`z_{m}^{emp}` is the empirical :math:`m`-block return level and :math:`\hat{z}_{m}` the 
        :math:`m`-block return level calculated with the fitted GEV.
        """
        return _dist_bundle1.GeneralizedExtremeValueValidation_drawReturnLevel(self)

    def drawPDF(self):
        r"""
        Draw the estimated density and the data histogram.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The estimated density and the data histogram.

        """
        return _dist_bundle1.GeneralizedExtremeValueValidation_drawPDF(self)

    def drawDiagnosticPlot(self):
        r"""
        Draw the 4 usual diagnostic plots.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Returns a grid of 4 graphs:
             - the QQ-plot,
             - the PP-plot,
             - the return level graph (with confidence lines),
             - the density graph.

        Notes
        -----
        The 4 graphs are the *probability-probability* plot, the *quantile-quantile* plot, the *return level* plot, the data histogram with the fitted model density.


        If :math:`(z_{(1)} \leq z_{(2)} \leq \dots \leq z_{(n)})` denotes the ordered block maximum data and :math:`\hat{G}` the cumulative distribution function of the GEV distribution fitted on the data, the graphs are defined as follows.

        The *probability-probability* plot consists of the points:

        .. math::
            \left\{ \left( i/(n+1), \hat{G}(z_{(i)}) \right), i=1, \dots , m\right\}


        The *quantile-quantile* plot consists of the points:

        .. math::
            \left\{  \left(  z_{(i)},  \hat{G}^{-1}(i/(n+1))  \right), i=1, \dots , n\right\} 

        The *return level* plot consists of the points:

        .. math::
            \left\{ \left( m, \hat{z}_m\right), m> 0\right\}

        and the points:

        .. math::
            \left\{ \left( m, z_{m}^{emp}\right), m> 0\right\}

        where :math:`z_{m}^{emp}` is the empirical :math:`m`-block return level and :math:`\hat{z}_{m}` the 
        :math:`m`-block return level calculated with the fitted GEV.
        """
        return _dist_bundle1.GeneralizedExtremeValueValidation_drawDiagnosticPlot(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Confidence level accessor.

        Parameters
        ----------
        level : float
            Confidence level for the confidence lines.

        """
        return _dist_bundle1.GeneralizedExtremeValueValidation_setConfidenceLevel(self, confidenceLevel)

    def getConfidenceLevel(self):
        r"""
        Confidence level accessor.

        Returns
        -------
        level : float
            Confidence level for the confidence lines.

        """
        return _dist_bundle1.GeneralizedExtremeValueValidation_getConfidenceLevel(self)

    def __repr__(self):
        return _dist_bundle1.GeneralizedExtremeValueValidation___repr__(self)

    def __init__(self, *args):
        _dist_bundle1.GeneralizedExtremeValueValidation_swiginit(self, _dist_bundle1.new_GeneralizedExtremeValueValidation(*args))
    __swig_destroy__ = _dist_bundle1.delete_GeneralizedExtremeValueValidation

# Register GeneralizedExtremeValueValidation in _dist_bundle1:
_dist_bundle1.GeneralizedExtremeValueValidation_swigregister(GeneralizedExtremeValueValidation)
class GumbelFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Gumbel factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{\beta} = \frac{\sqrt{6}}{\pi}\Hat{\sigma}_x\\
          \displaystyle\Hat{\gamma} = \bar{x}_n - \frac{\gamma_e \sqrt{6}}{\pi}\Hat{\sigma}_x\\
        \end{eqnarray*}

    with :math:`\gamma_e \simeq 0.57721` as Euler's constant.

    See also
    --------
    DistributionFactory, Gumbel
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GumbelFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle1.GumbelFactory_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle1.GumbelFactory_buildEstimator(self, *args)

    def buildAsGumbel(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsGumbel()

            buildAsGumbel(*sample*)

            buildAsGumbel(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Gumbel`.

        Returns
        -------
        distribution : :class:`~openturns.Gumbel`
            The estimated distribution as a Gumbel.

            In the first usage, the default Gumbel distribution is built.
        """
        return _dist_bundle1.GumbelFactory_buildAsGumbel(self, *args)

    def __init__(self, *args):
        _dist_bundle1.GumbelFactory_swiginit(self, _dist_bundle1.new_GumbelFactory(*args))
    __swig_destroy__ = _dist_bundle1.delete_GumbelFactory

# Register GumbelFactory in _dist_bundle1:
_dist_bundle1.GumbelFactory_swigregister(GumbelFactory)
class GumbelLambdaGamma(openturns.model_copula.DistributionParametersImplementation):
    r"""
    Gumbel rate/location parametrization.

    Parameters
    ----------
    lambda : float
        Rate parameter :math:`\lambda > 0`.

        Default value is 0.0.
    gamma : float
        Location parameter.

        Default value is 1.0.

    Notes
    -----
    The native parameters :math:`(\beta, \gamma)` are defined as follows:

    .. math::

       \beta &= \frac{1}{\lambda} \\

    The :math:`\gamma` parameter is the same.

    See also
    --------
    Gumbel

    Examples
    --------
    Create the parameters :math:`(\lambda, \gamma)` of the Gumbel distribution:

    >>> import openturns as ot
    >>> parameters = ot.GumbelLambdaGamma(2.0, 0.5)

    Convert parameters into the native parameters :math:`(\beta, \gamma)`:

    >>> print(parameters.evaluate())
    [0.5,0.5]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GumbelLambdaGamma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.GumbelLambdaGamma___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.GumbelLambdaGamma_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle1.GumbelLambdaGamma_gradient(self)

    def __call__(self, inP):
        return _dist_bundle1.GumbelLambdaGamma___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.GumbelLambdaGamma_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.GumbelLambdaGamma_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.GumbelLambdaGamma_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.GumbelLambdaGamma_getDescription(self)

    def __repr__(self):
        return _dist_bundle1.GumbelLambdaGamma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GumbelLambdaGamma___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle1.GumbelLambdaGamma_swiginit(self, _dist_bundle1.new_GumbelLambdaGamma(*args))
    __swig_destroy__ = _dist_bundle1.delete_GumbelLambdaGamma

# Register GumbelLambdaGamma in _dist_bundle1:
_dist_bundle1.GumbelLambdaGamma_swigregister(GumbelLambdaGamma)
class GumbelMuSigma(openturns.model_copula.DistributionParametersImplementation):
    r"""
    Gumbel distribution parameters.

    Parameters
    ----------
    mu : float
        Mean.

        Default value is :math:`\gamma_e`.
    sigma : float
        Standard deviation :math:`\sigma > 0`.

        Default value is :math:`\frac{\pi}{\sqrt{6}}`.

    Notes
    -----
    Let :math:`X` be a random variable that follows a Gumbel distribution
    such that:

    .. math::

        \Expect{X} &= \mu \\
        \Var{X} &= \sigma^2

    The native parameters  :math:`(\beta, \gamma)` are defined as follows:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \mu & = & \gamma + \gamma_e \beta \\
            \sigma^2 & = & \frac{1}{6} \pi^2 \beta^2
        \end{eqnarray*}

    where :math:`\gamma_e` is the Euler-Mascheroni constant.

    The default values of :math:`(\mu, \sigma)` are defined so that the associated native parameters
    have the default values: :math:`(\beta, \gamma) = (1.0, 0.0)`.


    See also
    --------
    Gumbel

    Examples
    --------
    Create the parameters :math:`(\mu, \sigma)` of the Gumbel distribution:

    >>> import openturns as ot
    >>> parameters = ot.GumbelMuSigma(1.5, 1.3)

    Convert parameters into the native parameters :math:`(\beta, \gamma)`:

    >>> print(parameters.evaluate())
    [1.01361,0.914931]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GumbelMuSigma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle1.GumbelMuSigma___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.GumbelMuSigma_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle1.GumbelMuSigma_gradient(self)

    def __call__(self, inP):
        return _dist_bundle1.GumbelMuSigma___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.GumbelMuSigma_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.GumbelMuSigma_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.GumbelMuSigma_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.GumbelMuSigma_getDescription(self)

    def __repr__(self):
        return _dist_bundle1.GumbelMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GumbelMuSigma___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle1.GumbelMuSigma_swiginit(self, _dist_bundle1.new_GumbelMuSigma(*args))
    __swig_destroy__ = _dist_bundle1.delete_GumbelMuSigma

# Register GumbelMuSigma in _dist_bundle1:
_dist_bundle1.GumbelMuSigma_swigregister(GumbelMuSigma)

