%feature("docstring") OT::MeshDomain
"Adaptor to convert a Mesh to a Domain.

Available constructors:
    MeshDomain(*mesh*)

    MeshDomain(*mesh, enclosingSimplex*)

Parameters
----------
mesh : :class:`~openturns.Mesh`
    Underlying mesh.
enclosingSimplex : :class:`~openturns.EnclosingSimplexAlgorithm`
    Algorithm to use for point location.

Examples
--------
>>> import openturns as ot
>>> # First domain
>>> interval2d = ot.Interval([-1.0, -1.0], [0.5, 0.5])
>>> # Second domain
>>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
>>> simplices = [[0, 1, 2], [1, 2, 3]]
>>> mesh2d = ot.Mesh(vertices, simplices)
>>> domain = ot.MeshDomain(mesh2d)
>>> x = [0.2, 0.1]
>>> inside = (x in domain)"

// ---------------------------------------------------------------------

%feature("docstring") OT::MeshDomain::getLowerBound
"Get the lower bound.

Returns
-------
lowerBound : :class:`~openturns.Point`
    Value of the lower bound.

Examples
--------
>>> import openturns as ot
>>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
>>> print(interval.getLowerBound())
[2,3]"

// ---------------------------------------------------------------------

%feature("docstring") OT::MeshDomain::getUpperBound
"Get the upper bound.

Returns
-------
upperBound : :class:`~openturns.Point`
    Value of the upper bound.

Examples
--------
>>> import openturns as ot
>>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
>>> print(interval.getUpperBound())
[4,5]"

// ---------------------------------------------------------------------

%feature("docstring") OT::MeshDomain::getMesh
"Get the mesh.

Returns
-------
mesh : :class:`~openturns.Mesh`
    Underlying mesh."

// ---------------------------------------------------------------------

%feature("docstring") OT::MeshDomain::setEnclosingSimplexAlgorithm
"Set the simplex algorithm.

Parameters
----------
algo : :class:`~openturns.EnclosingSimplexAlgorithm`
    Simplex algorithm."

// ---------------------------------------------------------------------

%feature("docstring") OT::MeshDomain::getEnclosingSimplexAlgorithm
"Get the simplex algorithm.

Returns
-------
algo : :class:`~openturns.EnclosingSimplexAlgorithm`
    Simplex algorithm."
