/*
 * libvirt-gconfig-domain-serial.h: libvirt domain serial configuration
 *
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Author: Daniel P. Berrange <berrange@redhat.com>
 */

#if !defined(__LIBVIRT_GCONFIG_H__) && !defined(LIBVIRT_GCONFIG_BUILD)
#error "Only <libvirt-gconfig/libvirt-gconfig.h> can be included directly."
#endif

#pragma once

G_BEGIN_DECLS

#define GVIR_CONFIG_TYPE_DOMAIN_SERIAL            (gvir_config_domain_serial_get_type ())
#define GVIR_CONFIG_DOMAIN_SERIAL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GVIR_CONFIG_TYPE_DOMAIN_SERIAL, GVirConfigDomainSerial))
#define GVIR_CONFIG_DOMAIN_SERIAL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GVIR_CONFIG_TYPE_DOMAIN_SERIAL, GVirConfigDomainSerialClass))
#define GVIR_CONFIG_IS_DOMAIN_SERIAL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GVIR_CONFIG_TYPE_DOMAIN_SERIAL))
#define GVIR_CONFIG_IS_DOMAIN_SERIAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GVIR_CONFIG_TYPE_DOMAIN_SERIAL))
#define GVIR_CONFIG_DOMAIN_SERIAL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GVIR_CONFIG_TYPE_DOMAIN_SERIAL, GVirConfigDomainSerialClass))

typedef struct _GVirConfigDomainSerial GVirConfigDomainSerial;
typedef struct _GVirConfigDomainSerialPrivate GVirConfigDomainSerialPrivate;
typedef struct _GVirConfigDomainSerialClass GVirConfigDomainSerialClass;

struct _GVirConfigDomainSerial
{
    GVirConfigDomainChardev parent;

    GVirConfigDomainSerialPrivate *priv;

    /* Do not add fields to this struct */
};

struct _GVirConfigDomainSerialClass
{
    GVirConfigDomainChardevClass parent_class;

    gpointer padding[20];
};


GType gvir_config_domain_serial_get_type(void);
GVirConfigDomainSerial *gvir_config_domain_serial_new(void);
GVirConfigDomainSerial *gvir_config_domain_serial_new_from_xml(const gchar *xml,
                                                                 GError **error);

G_END_DECLS
