/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_TABLES_1_H
#define LEXBOR_UNICODE_TABLES_1_H

#ifdef __cplusplus
extern "C" {
#endif


static const lxb_unicode_idna_map_t lxb_unicode_idna_map_13F8 = {.cps = (lxb_codepoint_t[]) {0x13F0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_13F9 = {.cps = (lxb_codepoint_t[]) {0x13F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_13FA = {.cps = (lxb_codepoint_t[]) {0x13F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_13FB = {.cps = (lxb_codepoint_t[]) {0x13F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_13FC = {.cps = (lxb_codepoint_t[]) {0x13F4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_13FD = {.cps = (lxb_codepoint_t[]) {0x13F5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C80 = {.cps = (lxb_codepoint_t[]) {0x0432}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C81 = {.cps = (lxb_codepoint_t[]) {0x0434}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C82 = {.cps = (lxb_codepoint_t[]) {0x043E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C83 = {.cps = (lxb_codepoint_t[]) {0x0441}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C84 = {.cps = (lxb_codepoint_t[]) {0x0442}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C85 = {.cps = (lxb_codepoint_t[]) {0x0442}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C86 = {.cps = (lxb_codepoint_t[]) {0x044A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C87 = {.cps = (lxb_codepoint_t[]) {0x0463}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C88 = {.cps = (lxb_codepoint_t[]) {0xA64B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C90 = {.cps = (lxb_codepoint_t[]) {0x10D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C91 = {.cps = (lxb_codepoint_t[]) {0x10D1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C92 = {.cps = (lxb_codepoint_t[]) {0x10D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C93 = {.cps = (lxb_codepoint_t[]) {0x10D3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C94 = {.cps = (lxb_codepoint_t[]) {0x10D4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C95 = {.cps = (lxb_codepoint_t[]) {0x10D5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C96 = {.cps = (lxb_codepoint_t[]) {0x10D6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C97 = {.cps = (lxb_codepoint_t[]) {0x10D7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C98 = {.cps = (lxb_codepoint_t[]) {0x10D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C99 = {.cps = (lxb_codepoint_t[]) {0x10D9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C9A = {.cps = (lxb_codepoint_t[]) {0x10DA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C9B = {.cps = (lxb_codepoint_t[]) {0x10DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C9C = {.cps = (lxb_codepoint_t[]) {0x10DC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C9D = {.cps = (lxb_codepoint_t[]) {0x10DD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C9E = {.cps = (lxb_codepoint_t[]) {0x10DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1C9F = {.cps = (lxb_codepoint_t[]) {0x10DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CA0 = {.cps = (lxb_codepoint_t[]) {0x10E0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CA1 = {.cps = (lxb_codepoint_t[]) {0x10E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CA2 = {.cps = (lxb_codepoint_t[]) {0x10E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CA3 = {.cps = (lxb_codepoint_t[]) {0x10E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CA4 = {.cps = (lxb_codepoint_t[]) {0x10E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CA5 = {.cps = (lxb_codepoint_t[]) {0x10E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CA6 = {.cps = (lxb_codepoint_t[]) {0x10E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CA7 = {.cps = (lxb_codepoint_t[]) {0x10E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CA8 = {.cps = (lxb_codepoint_t[]) {0x10E8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CA9 = {.cps = (lxb_codepoint_t[]) {0x10E9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CAA = {.cps = (lxb_codepoint_t[]) {0x10EA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CAB = {.cps = (lxb_codepoint_t[]) {0x10EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CAC = {.cps = (lxb_codepoint_t[]) {0x10EC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CAD = {.cps = (lxb_codepoint_t[]) {0x10ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CAE = {.cps = (lxb_codepoint_t[]) {0x10EE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CAF = {.cps = (lxb_codepoint_t[]) {0x10EF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CB0 = {.cps = (lxb_codepoint_t[]) {0x10F0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CB1 = {.cps = (lxb_codepoint_t[]) {0x10F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CB2 = {.cps = (lxb_codepoint_t[]) {0x10F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CB3 = {.cps = (lxb_codepoint_t[]) {0x10F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CB4 = {.cps = (lxb_codepoint_t[]) {0x10F4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CB5 = {.cps = (lxb_codepoint_t[]) {0x10F5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CB6 = {.cps = (lxb_codepoint_t[]) {0x10F6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CB7 = {.cps = (lxb_codepoint_t[]) {0x10F7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CB8 = {.cps = (lxb_codepoint_t[]) {0x10F8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CB9 = {.cps = (lxb_codepoint_t[]) {0x10F9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CBA = {.cps = (lxb_codepoint_t[]) {0x10FA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CBD = {.cps = (lxb_codepoint_t[]) {0x10FD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CBE = {.cps = (lxb_codepoint_t[]) {0x10FE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1CBF = {.cps = (lxb_codepoint_t[]) {0x10FF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D2C = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D2D = {.cps = (lxb_codepoint_t[]) {0x00E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D2E = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D30 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D31 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D32 = {.cps = (lxb_codepoint_t[]) {0x01DD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D33 = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D34 = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D35 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D36 = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D37 = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D38 = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D39 = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D3A = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D3C = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D3D = {.cps = (lxb_codepoint_t[]) {0x0223}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D3E = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D3F = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D40 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D41 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D42 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D43 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D44 = {.cps = (lxb_codepoint_t[]) {0x0250}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D45 = {.cps = (lxb_codepoint_t[]) {0x0251}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D46 = {.cps = (lxb_codepoint_t[]) {0x1D02}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D47 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D48 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D49 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4A = {.cps = (lxb_codepoint_t[]) {0x0259}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B = {.cps = (lxb_codepoint_t[]) {0x025B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4C = {.cps = (lxb_codepoint_t[]) {0x025C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4D = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4F = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D50 = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D51 = {.cps = (lxb_codepoint_t[]) {0x014B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D52 = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D53 = {.cps = (lxb_codepoint_t[]) {0x0254}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D54 = {.cps = (lxb_codepoint_t[]) {0x1D16}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D55 = {.cps = (lxb_codepoint_t[]) {0x1D17}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D56 = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D57 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D58 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D59 = {.cps = (lxb_codepoint_t[]) {0x1D1D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D5A = {.cps = (lxb_codepoint_t[]) {0x026F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D5B = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D5C = {.cps = (lxb_codepoint_t[]) {0x1D25}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D5D = {.cps = (lxb_codepoint_t[]) {0x03B2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D5E = {.cps = (lxb_codepoint_t[]) {0x03B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D5F = {.cps = (lxb_codepoint_t[]) {0x03B4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D60 = {.cps = (lxb_codepoint_t[]) {0x03C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D61 = {.cps = (lxb_codepoint_t[]) {0x03C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D62 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D63 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D64 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D65 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D66 = {.cps = (lxb_codepoint_t[]) {0x03B2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D67 = {.cps = (lxb_codepoint_t[]) {0x03B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D68 = {.cps = (lxb_codepoint_t[]) {0x03C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D69 = {.cps = (lxb_codepoint_t[]) {0x03C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D6A = {.cps = (lxb_codepoint_t[]) {0x03C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D78 = {.cps = (lxb_codepoint_t[]) {0x043D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D9B = {.cps = (lxb_codepoint_t[]) {0x0252}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D9C = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D9D = {.cps = (lxb_codepoint_t[]) {0x0255}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D9E = {.cps = (lxb_codepoint_t[]) {0x00F0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D9F = {.cps = (lxb_codepoint_t[]) {0x025C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DA0 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DA1 = {.cps = (lxb_codepoint_t[]) {0x025F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DA2 = {.cps = (lxb_codepoint_t[]) {0x0261}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DA3 = {.cps = (lxb_codepoint_t[]) {0x0265}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DA4 = {.cps = (lxb_codepoint_t[]) {0x0268}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DA5 = {.cps = (lxb_codepoint_t[]) {0x0269}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DA6 = {.cps = (lxb_codepoint_t[]) {0x026A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DA7 = {.cps = (lxb_codepoint_t[]) {0x1D7B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DA8 = {.cps = (lxb_codepoint_t[]) {0x029D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DA9 = {.cps = (lxb_codepoint_t[]) {0x026D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DAA = {.cps = (lxb_codepoint_t[]) {0x1D85}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DAB = {.cps = (lxb_codepoint_t[]) {0x029F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DAC = {.cps = (lxb_codepoint_t[]) {0x0271}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DAD = {.cps = (lxb_codepoint_t[]) {0x0270}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DAE = {.cps = (lxb_codepoint_t[]) {0x0272}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DAF = {.cps = (lxb_codepoint_t[]) {0x0273}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DB0 = {.cps = (lxb_codepoint_t[]) {0x0274}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DB1 = {.cps = (lxb_codepoint_t[]) {0x0275}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DB2 = {.cps = (lxb_codepoint_t[]) {0x0278}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DB3 = {.cps = (lxb_codepoint_t[]) {0x0282}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DB4 = {.cps = (lxb_codepoint_t[]) {0x0283}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DB5 = {.cps = (lxb_codepoint_t[]) {0x01AB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DB6 = {.cps = (lxb_codepoint_t[]) {0x0289}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DB7 = {.cps = (lxb_codepoint_t[]) {0x028A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DB8 = {.cps = (lxb_codepoint_t[]) {0x1D1C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DB9 = {.cps = (lxb_codepoint_t[]) {0x028B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DBA = {.cps = (lxb_codepoint_t[]) {0x028C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DBB = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DBC = {.cps = (lxb_codepoint_t[]) {0x0290}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DBD = {.cps = (lxb_codepoint_t[]) {0x0291}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DBE = {.cps = (lxb_codepoint_t[]) {0x0292}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1DBF = {.cps = (lxb_codepoint_t[]) {0x03B8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E00 = {.cps = (lxb_codepoint_t[]) {0x1E01}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E02 = {.cps = (lxb_codepoint_t[]) {0x1E03}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E04 = {.cps = (lxb_codepoint_t[]) {0x1E05}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E06 = {.cps = (lxb_codepoint_t[]) {0x1E07}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E08 = {.cps = (lxb_codepoint_t[]) {0x1E09}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E0A = {.cps = (lxb_codepoint_t[]) {0x1E0B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E0C = {.cps = (lxb_codepoint_t[]) {0x1E0D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E0E = {.cps = (lxb_codepoint_t[]) {0x1E0F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E10 = {.cps = (lxb_codepoint_t[]) {0x1E11}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E12 = {.cps = (lxb_codepoint_t[]) {0x1E13}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E14 = {.cps = (lxb_codepoint_t[]) {0x1E15}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E16 = {.cps = (lxb_codepoint_t[]) {0x1E17}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E18 = {.cps = (lxb_codepoint_t[]) {0x1E19}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E1A = {.cps = (lxb_codepoint_t[]) {0x1E1B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E1C = {.cps = (lxb_codepoint_t[]) {0x1E1D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E1E = {.cps = (lxb_codepoint_t[]) {0x1E1F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E20 = {.cps = (lxb_codepoint_t[]) {0x1E21}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E22 = {.cps = (lxb_codepoint_t[]) {0x1E23}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E24 = {.cps = (lxb_codepoint_t[]) {0x1E25}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E26 = {.cps = (lxb_codepoint_t[]) {0x1E27}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E28 = {.cps = (lxb_codepoint_t[]) {0x1E29}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E2A = {.cps = (lxb_codepoint_t[]) {0x1E2B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E2C = {.cps = (lxb_codepoint_t[]) {0x1E2D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E2E = {.cps = (lxb_codepoint_t[]) {0x1E2F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E30 = {.cps = (lxb_codepoint_t[]) {0x1E31}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E32 = {.cps = (lxb_codepoint_t[]) {0x1E33}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E34 = {.cps = (lxb_codepoint_t[]) {0x1E35}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E36 = {.cps = (lxb_codepoint_t[]) {0x1E37}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E38 = {.cps = (lxb_codepoint_t[]) {0x1E39}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E3A = {.cps = (lxb_codepoint_t[]) {0x1E3B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E3C = {.cps = (lxb_codepoint_t[]) {0x1E3D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E3E = {.cps = (lxb_codepoint_t[]) {0x1E3F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E40 = {.cps = (lxb_codepoint_t[]) {0x1E41}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E42 = {.cps = (lxb_codepoint_t[]) {0x1E43}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E44 = {.cps = (lxb_codepoint_t[]) {0x1E45}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E46 = {.cps = (lxb_codepoint_t[]) {0x1E47}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E48 = {.cps = (lxb_codepoint_t[]) {0x1E49}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E4A = {.cps = (lxb_codepoint_t[]) {0x1E4B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E4C = {.cps = (lxb_codepoint_t[]) {0x1E4D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E4E = {.cps = (lxb_codepoint_t[]) {0x1E4F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E50 = {.cps = (lxb_codepoint_t[]) {0x1E51}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E52 = {.cps = (lxb_codepoint_t[]) {0x1E53}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E54 = {.cps = (lxb_codepoint_t[]) {0x1E55}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E56 = {.cps = (lxb_codepoint_t[]) {0x1E57}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E58 = {.cps = (lxb_codepoint_t[]) {0x1E59}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E5A = {.cps = (lxb_codepoint_t[]) {0x1E5B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E5C = {.cps = (lxb_codepoint_t[]) {0x1E5D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E5E = {.cps = (lxb_codepoint_t[]) {0x1E5F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E60 = {.cps = (lxb_codepoint_t[]) {0x1E61}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E62 = {.cps = (lxb_codepoint_t[]) {0x1E63}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E64 = {.cps = (lxb_codepoint_t[]) {0x1E65}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E66 = {.cps = (lxb_codepoint_t[]) {0x1E67}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E68 = {.cps = (lxb_codepoint_t[]) {0x1E69}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E6A = {.cps = (lxb_codepoint_t[]) {0x1E6B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E6C = {.cps = (lxb_codepoint_t[]) {0x1E6D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E6E = {.cps = (lxb_codepoint_t[]) {0x1E6F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E70 = {.cps = (lxb_codepoint_t[]) {0x1E71}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E72 = {.cps = (lxb_codepoint_t[]) {0x1E73}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E74 = {.cps = (lxb_codepoint_t[]) {0x1E75}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E76 = {.cps = (lxb_codepoint_t[]) {0x1E77}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E78 = {.cps = (lxb_codepoint_t[]) {0x1E79}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E7A = {.cps = (lxb_codepoint_t[]) {0x1E7B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E7C = {.cps = (lxb_codepoint_t[]) {0x1E7D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E7E = {.cps = (lxb_codepoint_t[]) {0x1E7F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E80 = {.cps = (lxb_codepoint_t[]) {0x1E81}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E82 = {.cps = (lxb_codepoint_t[]) {0x1E83}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E84 = {.cps = (lxb_codepoint_t[]) {0x1E85}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E86 = {.cps = (lxb_codepoint_t[]) {0x1E87}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E88 = {.cps = (lxb_codepoint_t[]) {0x1E89}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E8A = {.cps = (lxb_codepoint_t[]) {0x1E8B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E8C = {.cps = (lxb_codepoint_t[]) {0x1E8D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E8E = {.cps = (lxb_codepoint_t[]) {0x1E8F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E90 = {.cps = (lxb_codepoint_t[]) {0x1E91}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E92 = {.cps = (lxb_codepoint_t[]) {0x1E93}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E94 = {.cps = (lxb_codepoint_t[]) {0x1E95}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E9A = {.cps = (lxb_codepoint_t[]) {0x0061, 0x02BE}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E9B = {.cps = (lxb_codepoint_t[]) {0x1E61}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1E9E = {.cps = (lxb_codepoint_t[]) {0x0073, 0x0073}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EA0 = {.cps = (lxb_codepoint_t[]) {0x1EA1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EA2 = {.cps = (lxb_codepoint_t[]) {0x1EA3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EA4 = {.cps = (lxb_codepoint_t[]) {0x1EA5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EA6 = {.cps = (lxb_codepoint_t[]) {0x1EA7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EA8 = {.cps = (lxb_codepoint_t[]) {0x1EA9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EAA = {.cps = (lxb_codepoint_t[]) {0x1EAB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EAC = {.cps = (lxb_codepoint_t[]) {0x1EAD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EAE = {.cps = (lxb_codepoint_t[]) {0x1EAF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EB0 = {.cps = (lxb_codepoint_t[]) {0x1EB1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EB2 = {.cps = (lxb_codepoint_t[]) {0x1EB3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EB4 = {.cps = (lxb_codepoint_t[]) {0x1EB5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EB6 = {.cps = (lxb_codepoint_t[]) {0x1EB7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EB8 = {.cps = (lxb_codepoint_t[]) {0x1EB9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EBA = {.cps = (lxb_codepoint_t[]) {0x1EBB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EBC = {.cps = (lxb_codepoint_t[]) {0x1EBD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EBE = {.cps = (lxb_codepoint_t[]) {0x1EBF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EC0 = {.cps = (lxb_codepoint_t[]) {0x1EC1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EC2 = {.cps = (lxb_codepoint_t[]) {0x1EC3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EC4 = {.cps = (lxb_codepoint_t[]) {0x1EC5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EC6 = {.cps = (lxb_codepoint_t[]) {0x1EC7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EC8 = {.cps = (lxb_codepoint_t[]) {0x1EC9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1ECA = {.cps = (lxb_codepoint_t[]) {0x1ECB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1ECC = {.cps = (lxb_codepoint_t[]) {0x1ECD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1ECE = {.cps = (lxb_codepoint_t[]) {0x1ECF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1ED0 = {.cps = (lxb_codepoint_t[]) {0x1ED1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1ED2 = {.cps = (lxb_codepoint_t[]) {0x1ED3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1ED4 = {.cps = (lxb_codepoint_t[]) {0x1ED5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1ED6 = {.cps = (lxb_codepoint_t[]) {0x1ED7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1ED8 = {.cps = (lxb_codepoint_t[]) {0x1ED9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EDA = {.cps = (lxb_codepoint_t[]) {0x1EDB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EDC = {.cps = (lxb_codepoint_t[]) {0x1EDD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EDE = {.cps = (lxb_codepoint_t[]) {0x1EDF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EE0 = {.cps = (lxb_codepoint_t[]) {0x1EE1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EE2 = {.cps = (lxb_codepoint_t[]) {0x1EE3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EE4 = {.cps = (lxb_codepoint_t[]) {0x1EE5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EE6 = {.cps = (lxb_codepoint_t[]) {0x1EE7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EE8 = {.cps = (lxb_codepoint_t[]) {0x1EE9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EEA = {.cps = (lxb_codepoint_t[]) {0x1EEB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EEC = {.cps = (lxb_codepoint_t[]) {0x1EED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EEE = {.cps = (lxb_codepoint_t[]) {0x1EEF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EF0 = {.cps = (lxb_codepoint_t[]) {0x1EF1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EF2 = {.cps = (lxb_codepoint_t[]) {0x1EF3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EF4 = {.cps = (lxb_codepoint_t[]) {0x1EF5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EF6 = {.cps = (lxb_codepoint_t[]) {0x1EF7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EF8 = {.cps = (lxb_codepoint_t[]) {0x1EF9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EFA = {.cps = (lxb_codepoint_t[]) {0x1EFB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EFC = {.cps = (lxb_codepoint_t[]) {0x1EFD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1EFE = {.cps = (lxb_codepoint_t[]) {0x1EFF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F08 = {.cps = (lxb_codepoint_t[]) {0x1F00}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F09 = {.cps = (lxb_codepoint_t[]) {0x1F01}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F0A = {.cps = (lxb_codepoint_t[]) {0x1F02}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F0B = {.cps = (lxb_codepoint_t[]) {0x1F03}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F0C = {.cps = (lxb_codepoint_t[]) {0x1F04}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F0D = {.cps = (lxb_codepoint_t[]) {0x1F05}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F0E = {.cps = (lxb_codepoint_t[]) {0x1F06}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F0F = {.cps = (lxb_codepoint_t[]) {0x1F07}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F18 = {.cps = (lxb_codepoint_t[]) {0x1F10}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F19 = {.cps = (lxb_codepoint_t[]) {0x1F11}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F1A = {.cps = (lxb_codepoint_t[]) {0x1F12}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F1B = {.cps = (lxb_codepoint_t[]) {0x1F13}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F1C = {.cps = (lxb_codepoint_t[]) {0x1F14}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F1D = {.cps = (lxb_codepoint_t[]) {0x1F15}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F28 = {.cps = (lxb_codepoint_t[]) {0x1F20}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F29 = {.cps = (lxb_codepoint_t[]) {0x1F21}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F2A = {.cps = (lxb_codepoint_t[]) {0x1F22}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F2B = {.cps = (lxb_codepoint_t[]) {0x1F23}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F2C = {.cps = (lxb_codepoint_t[]) {0x1F24}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F2D = {.cps = (lxb_codepoint_t[]) {0x1F25}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F2E = {.cps = (lxb_codepoint_t[]) {0x1F26}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F2F = {.cps = (lxb_codepoint_t[]) {0x1F27}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F38 = {.cps = (lxb_codepoint_t[]) {0x1F30}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F39 = {.cps = (lxb_codepoint_t[]) {0x1F31}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F3A = {.cps = (lxb_codepoint_t[]) {0x1F32}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F3B = {.cps = (lxb_codepoint_t[]) {0x1F33}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F3C = {.cps = (lxb_codepoint_t[]) {0x1F34}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F3D = {.cps = (lxb_codepoint_t[]) {0x1F35}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F3E = {.cps = (lxb_codepoint_t[]) {0x1F36}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F3F = {.cps = (lxb_codepoint_t[]) {0x1F37}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F48 = {.cps = (lxb_codepoint_t[]) {0x1F40}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F49 = {.cps = (lxb_codepoint_t[]) {0x1F41}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F4A = {.cps = (lxb_codepoint_t[]) {0x1F42}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F4B = {.cps = (lxb_codepoint_t[]) {0x1F43}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F4C = {.cps = (lxb_codepoint_t[]) {0x1F44}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F4D = {.cps = (lxb_codepoint_t[]) {0x1F45}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F59 = {.cps = (lxb_codepoint_t[]) {0x1F51}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F5B = {.cps = (lxb_codepoint_t[]) {0x1F53}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F5D = {.cps = (lxb_codepoint_t[]) {0x1F55}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F5F = {.cps = (lxb_codepoint_t[]) {0x1F57}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F68 = {.cps = (lxb_codepoint_t[]) {0x1F60}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F69 = {.cps = (lxb_codepoint_t[]) {0x1F61}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F6A = {.cps = (lxb_codepoint_t[]) {0x1F62}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F6B = {.cps = (lxb_codepoint_t[]) {0x1F63}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F6C = {.cps = (lxb_codepoint_t[]) {0x1F64}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F6D = {.cps = (lxb_codepoint_t[]) {0x1F65}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F6E = {.cps = (lxb_codepoint_t[]) {0x1F66}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F6F = {.cps = (lxb_codepoint_t[]) {0x1F67}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F71 = {.cps = (lxb_codepoint_t[]) {0x03AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F73 = {.cps = (lxb_codepoint_t[]) {0x03AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F75 = {.cps = (lxb_codepoint_t[]) {0x03AE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F77 = {.cps = (lxb_codepoint_t[]) {0x03AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F79 = {.cps = (lxb_codepoint_t[]) {0x03CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F7B = {.cps = (lxb_codepoint_t[]) {0x03CD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F7D = {.cps = (lxb_codepoint_t[]) {0x03CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F80 = {.cps = (lxb_codepoint_t[]) {0x1F00, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F81 = {.cps = (lxb_codepoint_t[]) {0x1F01, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F82 = {.cps = (lxb_codepoint_t[]) {0x1F02, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F83 = {.cps = (lxb_codepoint_t[]) {0x1F03, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F84 = {.cps = (lxb_codepoint_t[]) {0x1F04, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F85 = {.cps = (lxb_codepoint_t[]) {0x1F05, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F86 = {.cps = (lxb_codepoint_t[]) {0x1F06, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F87 = {.cps = (lxb_codepoint_t[]) {0x1F07, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F88 = {.cps = (lxb_codepoint_t[]) {0x1F00, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F89 = {.cps = (lxb_codepoint_t[]) {0x1F01, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F8A = {.cps = (lxb_codepoint_t[]) {0x1F02, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F8B = {.cps = (lxb_codepoint_t[]) {0x1F03, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F8C = {.cps = (lxb_codepoint_t[]) {0x1F04, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F8D = {.cps = (lxb_codepoint_t[]) {0x1F05, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F8E = {.cps = (lxb_codepoint_t[]) {0x1F06, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F8F = {.cps = (lxb_codepoint_t[]) {0x1F07, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F90 = {.cps = (lxb_codepoint_t[]) {0x1F20, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F91 = {.cps = (lxb_codepoint_t[]) {0x1F21, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F92 = {.cps = (lxb_codepoint_t[]) {0x1F22, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F93 = {.cps = (lxb_codepoint_t[]) {0x1F23, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F94 = {.cps = (lxb_codepoint_t[]) {0x1F24, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F95 = {.cps = (lxb_codepoint_t[]) {0x1F25, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F96 = {.cps = (lxb_codepoint_t[]) {0x1F26, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F97 = {.cps = (lxb_codepoint_t[]) {0x1F27, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F98 = {.cps = (lxb_codepoint_t[]) {0x1F20, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F99 = {.cps = (lxb_codepoint_t[]) {0x1F21, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F9A = {.cps = (lxb_codepoint_t[]) {0x1F22, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F9B = {.cps = (lxb_codepoint_t[]) {0x1F23, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F9C = {.cps = (lxb_codepoint_t[]) {0x1F24, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F9D = {.cps = (lxb_codepoint_t[]) {0x1F25, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F9E = {.cps = (lxb_codepoint_t[]) {0x1F26, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1F9F = {.cps = (lxb_codepoint_t[]) {0x1F27, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FA0 = {.cps = (lxb_codepoint_t[]) {0x1F60, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FA1 = {.cps = (lxb_codepoint_t[]) {0x1F61, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FA2 = {.cps = (lxb_codepoint_t[]) {0x1F62, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FA3 = {.cps = (lxb_codepoint_t[]) {0x1F63, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FA4 = {.cps = (lxb_codepoint_t[]) {0x1F64, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FA5 = {.cps = (lxb_codepoint_t[]) {0x1F65, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FA6 = {.cps = (lxb_codepoint_t[]) {0x1F66, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FA7 = {.cps = (lxb_codepoint_t[]) {0x1F67, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FA8 = {.cps = (lxb_codepoint_t[]) {0x1F60, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FA9 = {.cps = (lxb_codepoint_t[]) {0x1F61, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FAA = {.cps = (lxb_codepoint_t[]) {0x1F62, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FAB = {.cps = (lxb_codepoint_t[]) {0x1F63, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FAC = {.cps = (lxb_codepoint_t[]) {0x1F64, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FAD = {.cps = (lxb_codepoint_t[]) {0x1F65, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FAE = {.cps = (lxb_codepoint_t[]) {0x1F66, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FAF = {.cps = (lxb_codepoint_t[]) {0x1F67, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FB2 = {.cps = (lxb_codepoint_t[]) {0x1F70, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FB3 = {.cps = (lxb_codepoint_t[]) {0x03B1, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FB4 = {.cps = (lxb_codepoint_t[]) {0x03AC, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FB7 = {.cps = (lxb_codepoint_t[]) {0x1FB6, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FB8 = {.cps = (lxb_codepoint_t[]) {0x1FB0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FB9 = {.cps = (lxb_codepoint_t[]) {0x1FB1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FBA = {.cps = (lxb_codepoint_t[]) {0x1F70}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FBB = {.cps = (lxb_codepoint_t[]) {0x03AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FBC = {.cps = (lxb_codepoint_t[]) {0x03B1, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FBD = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0313}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FBE = {.cps = (lxb_codepoint_t[]) {0x03B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FBF = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0313}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FC0 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0342}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FC1 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0308, 0x0342}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FC2 = {.cps = (lxb_codepoint_t[]) {0x1F74, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FC3 = {.cps = (lxb_codepoint_t[]) {0x03B7, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FC4 = {.cps = (lxb_codepoint_t[]) {0x03AE, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FC7 = {.cps = (lxb_codepoint_t[]) {0x1FC6, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FC8 = {.cps = (lxb_codepoint_t[]) {0x1F72}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FC9 = {.cps = (lxb_codepoint_t[]) {0x03AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FCA = {.cps = (lxb_codepoint_t[]) {0x1F74}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FCB = {.cps = (lxb_codepoint_t[]) {0x03AE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FCC = {.cps = (lxb_codepoint_t[]) {0x03B7, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FCD = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0313, 0x0300}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FCE = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0313, 0x0301}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FCF = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0313, 0x0342}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FD3 = {.cps = (lxb_codepoint_t[]) {0x0390}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FD8 = {.cps = (lxb_codepoint_t[]) {0x1FD0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FD9 = {.cps = (lxb_codepoint_t[]) {0x1FD1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FDA = {.cps = (lxb_codepoint_t[]) {0x1F76}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FDB = {.cps = (lxb_codepoint_t[]) {0x03AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FDD = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0314, 0x0300}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FDE = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0314, 0x0301}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FDF = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0314, 0x0342}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FE3 = {.cps = (lxb_codepoint_t[]) {0x03B0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FE8 = {.cps = (lxb_codepoint_t[]) {0x1FE0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FE9 = {.cps = (lxb_codepoint_t[]) {0x1FE1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FEA = {.cps = (lxb_codepoint_t[]) {0x1F7A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FEB = {.cps = (lxb_codepoint_t[]) {0x03CD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FEC = {.cps = (lxb_codepoint_t[]) {0x1FE5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FED = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0308, 0x0300}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FEE = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0308, 0x0301}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FEF = {.cps = (lxb_codepoint_t[]) {0x0060}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FF2 = {.cps = (lxb_codepoint_t[]) {0x1F7C, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FF3 = {.cps = (lxb_codepoint_t[]) {0x03C9, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FF4 = {.cps = (lxb_codepoint_t[]) {0x03CE, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FF7 = {.cps = (lxb_codepoint_t[]) {0x1FF6, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FF8 = {.cps = (lxb_codepoint_t[]) {0x1F78}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FF9 = {.cps = (lxb_codepoint_t[]) {0x03CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FFA = {.cps = (lxb_codepoint_t[]) {0x1F7C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FFB = {.cps = (lxb_codepoint_t[]) {0x03CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FFC = {.cps = (lxb_codepoint_t[]) {0x03C9, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FFD = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0301}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1FFE = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0314}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2000 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2001 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2002 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2003 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2004 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2005 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2006 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2007 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2008 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2009 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_200A = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2011 = {.cps = (lxb_codepoint_t[]) {0x2010}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2017 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0333}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_202F = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2033 = {.cps = (lxb_codepoint_t[]) {0x2032, 0x2032}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2034 = {.cps = (lxb_codepoint_t[]) {0x2032, 0x2032, 0x2032}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2036 = {.cps = (lxb_codepoint_t[]) {0x2035, 0x2035}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2037 = {.cps = (lxb_codepoint_t[]) {0x2035, 0x2035, 0x2035}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_203C = {.cps = (lxb_codepoint_t[]) {0x0021, 0x0021}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_203E = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0305}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2047 = {.cps = (lxb_codepoint_t[]) {0x003F, 0x003F}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2048 = {.cps = (lxb_codepoint_t[]) {0x003F, 0x0021}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2049 = {.cps = (lxb_codepoint_t[]) {0x0021, 0x003F}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2057 = {.cps = (lxb_codepoint_t[]) {0x2032, 0x2032, 0x2032, 0x2032}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_205F = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2070 = {.cps = (lxb_codepoint_t[]) {0x0030}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2071 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2074 = {.cps = (lxb_codepoint_t[]) {0x0034}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2075 = {.cps = (lxb_codepoint_t[]) {0x0035}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2076 = {.cps = (lxb_codepoint_t[]) {0x0036}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2077 = {.cps = (lxb_codepoint_t[]) {0x0037}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2078 = {.cps = (lxb_codepoint_t[]) {0x0038}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2079 = {.cps = (lxb_codepoint_t[]) {0x0039}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_207A = {.cps = (lxb_codepoint_t[]) {0x002B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_207B = {.cps = (lxb_codepoint_t[]) {0x2212}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_207C = {.cps = (lxb_codepoint_t[]) {0x003D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_207D = {.cps = (lxb_codepoint_t[]) {0x0028}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_207E = {.cps = (lxb_codepoint_t[]) {0x0029}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_207F = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2080 = {.cps = (lxb_codepoint_t[]) {0x0030}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2081 = {.cps = (lxb_codepoint_t[]) {0x0031}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2082 = {.cps = (lxb_codepoint_t[]) {0x0032}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2083 = {.cps = (lxb_codepoint_t[]) {0x0033}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2084 = {.cps = (lxb_codepoint_t[]) {0x0034}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2085 = {.cps = (lxb_codepoint_t[]) {0x0035}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2086 = {.cps = (lxb_codepoint_t[]) {0x0036}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2087 = {.cps = (lxb_codepoint_t[]) {0x0037}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2088 = {.cps = (lxb_codepoint_t[]) {0x0038}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2089 = {.cps = (lxb_codepoint_t[]) {0x0039}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_208A = {.cps = (lxb_codepoint_t[]) {0x002B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_208B = {.cps = (lxb_codepoint_t[]) {0x2212}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_208C = {.cps = (lxb_codepoint_t[]) {0x003D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_208D = {.cps = (lxb_codepoint_t[]) {0x0028}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_208E = {.cps = (lxb_codepoint_t[]) {0x0029}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2090 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2091 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2092 = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2093 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2094 = {.cps = (lxb_codepoint_t[]) {0x0259}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2095 = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2096 = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2097 = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2098 = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2099 = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_209A = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_209B = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_209C = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_20A8 = {.cps = (lxb_codepoint_t[]) {0x0072, 0x0073}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2100 = {.cps = (lxb_codepoint_t[]) {0x0061, 0x002F, 0x0063}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2101 = {.cps = (lxb_codepoint_t[]) {0x0061, 0x002F, 0x0073}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2102 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2103 = {.cps = (lxb_codepoint_t[]) {0x00B0, 0x0063}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2105 = {.cps = (lxb_codepoint_t[]) {0x0063, 0x002F, 0x006F}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2106 = {.cps = (lxb_codepoint_t[]) {0x0063, 0x002F, 0x0075}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2107 = {.cps = (lxb_codepoint_t[]) {0x025B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2109 = {.cps = (lxb_codepoint_t[]) {0x00B0, 0x0066}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_210A = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_210B = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_210C = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_210D = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_210E = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_210F = {.cps = (lxb_codepoint_t[]) {0x0127}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2110 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2111 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2112 = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2113 = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2115 = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2116 = {.cps = (lxb_codepoint_t[]) {0x006E, 0x006F}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2119 = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_211A = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_211B = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_211C = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_211D = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2120 = {.cps = (lxb_codepoint_t[]) {0x0073, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2121 = {.cps = (lxb_codepoint_t[]) {0x0074, 0x0065, 0x006C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2122 = {.cps = (lxb_codepoint_t[]) {0x0074, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2124 = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2126 = {.cps = (lxb_codepoint_t[]) {0x03C9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2128 = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_212A = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_212B = {.cps = (lxb_codepoint_t[]) {0x00E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_212C = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_212D = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_212F = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2130 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2131 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2133 = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2134 = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2135 = {.cps = (lxb_codepoint_t[]) {0x05D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2136 = {.cps = (lxb_codepoint_t[]) {0x05D1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2137 = {.cps = (lxb_codepoint_t[]) {0x05D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2138 = {.cps = (lxb_codepoint_t[]) {0x05D3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2139 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_213B = {.cps = (lxb_codepoint_t[]) {0x0066, 0x0061, 0x0078}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_213C = {.cps = (lxb_codepoint_t[]) {0x03C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_213D = {.cps = (lxb_codepoint_t[]) {0x03B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_213E = {.cps = (lxb_codepoint_t[]) {0x03B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_213F = {.cps = (lxb_codepoint_t[]) {0x03C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2140 = {.cps = (lxb_codepoint_t[]) {0x2211}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2145 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2146 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2147 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2148 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2149 = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2150 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x2044, 0x0037}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2151 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x2044, 0x0039}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2152 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x2044, 0x0031, 0x0030}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2153 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x2044, 0x0033}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2154 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x2044, 0x0033}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2155 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x2044, 0x0035}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2156 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x2044, 0x0035}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2157 = {.cps = (lxb_codepoint_t[]) {0x0033, 0x2044, 0x0035}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2158 = {.cps = (lxb_codepoint_t[]) {0x0034, 0x2044, 0x0035}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2159 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x2044, 0x0036}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_215A = {.cps = (lxb_codepoint_t[]) {0x0035, 0x2044, 0x0036}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_215B = {.cps = (lxb_codepoint_t[]) {0x0031, 0x2044, 0x0038}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_215C = {.cps = (lxb_codepoint_t[]) {0x0033, 0x2044, 0x0038}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_215D = {.cps = (lxb_codepoint_t[]) {0x0035, 0x2044, 0x0038}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_215E = {.cps = (lxb_codepoint_t[]) {0x0037, 0x2044, 0x0038}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_215F = {.cps = (lxb_codepoint_t[]) {0x0031, 0x2044}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2160 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2161 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x0069}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2162 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x0069, 0x0069}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2163 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2164 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2165 = {.cps = (lxb_codepoint_t[]) {0x0076, 0x0069}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2166 = {.cps = (lxb_codepoint_t[]) {0x0076, 0x0069, 0x0069}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2167 = {.cps = (lxb_codepoint_t[]) {0x0076, 0x0069, 0x0069, 0x0069}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2168 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x0078}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2169 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_216A = {.cps = (lxb_codepoint_t[]) {0x0078, 0x0069}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_216B = {.cps = (lxb_codepoint_t[]) {0x0078, 0x0069, 0x0069}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_216C = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_216D = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_216E = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_216F = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2170 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2171 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x0069}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2172 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x0069, 0x0069}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2173 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2174 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2175 = {.cps = (lxb_codepoint_t[]) {0x0076, 0x0069}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2176 = {.cps = (lxb_codepoint_t[]) {0x0076, 0x0069, 0x0069}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2177 = {.cps = (lxb_codepoint_t[]) {0x0076, 0x0069, 0x0069, 0x0069}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2178 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x0078}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2179 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_217A = {.cps = (lxb_codepoint_t[]) {0x0078, 0x0069}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_217B = {.cps = (lxb_codepoint_t[]) {0x0078, 0x0069, 0x0069}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_217C = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_217D = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_217E = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_217F = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2189 = {.cps = (lxb_codepoint_t[]) {0x0030, 0x2044, 0x0033}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_222C = {.cps = (lxb_codepoint_t[]) {0x222B, 0x222B}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_222D = {.cps = (lxb_codepoint_t[]) {0x222B, 0x222B, 0x222B}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_222F = {.cps = (lxb_codepoint_t[]) {0x222E, 0x222E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2230 = {.cps = (lxb_codepoint_t[]) {0x222E, 0x222E, 0x222E}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2329 = {.cps = (lxb_codepoint_t[]) {0x3008}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_232A = {.cps = (lxb_codepoint_t[]) {0x3009}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2460 = {.cps = (lxb_codepoint_t[]) {0x0031}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2461 = {.cps = (lxb_codepoint_t[]) {0x0032}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2462 = {.cps = (lxb_codepoint_t[]) {0x0033}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2463 = {.cps = (lxb_codepoint_t[]) {0x0034}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2464 = {.cps = (lxb_codepoint_t[]) {0x0035}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2465 = {.cps = (lxb_codepoint_t[]) {0x0036}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2466 = {.cps = (lxb_codepoint_t[]) {0x0037}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2467 = {.cps = (lxb_codepoint_t[]) {0x0038}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2468 = {.cps = (lxb_codepoint_t[]) {0x0039}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2469 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0030}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_246A = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0031}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_246B = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0032}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_246C = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0033}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_246D = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0034}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_246E = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0035}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_246F = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0036}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2470 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0037}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2471 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0038}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2472 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0039}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2473 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0030}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2474 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2475 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0032, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2476 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0033, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2477 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0034, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2478 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0035, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2479 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0036, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_247A = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0037, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_247B = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0038, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_247C = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0039, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_247D = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0030, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_247E = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0031, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_247F = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0032, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2480 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0033, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2481 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0034, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2482 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0035, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2483 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0036, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2484 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0037, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2485 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0038, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2486 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0031, 0x0039, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2487 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0032, 0x0030, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_249C = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0061, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_249D = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0062, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_249E = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0063, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_249F = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0064, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24A0 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0065, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24A1 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0066, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24A2 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0067, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24A3 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0068, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24A4 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0069, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24A5 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x006A, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24A6 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x006B, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24A7 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x006C, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24A8 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x006D, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24A9 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x006E, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24AA = {.cps = (lxb_codepoint_t[]) {0x0028, 0x006F, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24AB = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0070, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24AC = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0071, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24AD = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0072, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24AE = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0073, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24AF = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0074, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24B0 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0075, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24B1 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0076, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24B2 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0077, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24B3 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0078, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24B4 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x0079, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24B5 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x007A, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24B6 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24B7 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24B8 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24B9 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24BA = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24BB = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24BC = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24BD = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24BE = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24BF = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24C0 = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24C1 = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24C2 = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24C3 = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24C4 = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24C5 = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24C6 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24C7 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24C8 = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24C9 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24CA = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24CB = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24CC = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24CD = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24CE = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24CF = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24D0 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24D1 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24D2 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24D3 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24D4 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24D5 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24D6 = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24D7 = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24D8 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24D9 = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24DA = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24DB = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24DC = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24DD = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24DE = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24DF = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24E0 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24E1 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24E2 = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24E3 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24E4 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24E5 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24E6 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24E7 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24E8 = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24E9 = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_24EA = {.cps = (lxb_codepoint_t[]) {0x0030}, .length = 1};

static const lxb_unicode_entry_t lxb_unicode_entry_1714 = {.cp = 0x1714, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1715 = {.cp = 0x1715, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1734 = {.cp = 0x1734, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_17D2 = {.cp = 0x17D2, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_17DD = {.cp = 0x17DD, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_18A9 = {.cp = 0x18A9, .ccc = 228, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1939 = {.cp = 0x1939, .ccc = 222, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_193A = {.cp = 0x193A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_193B = {.cp = 0x193B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A17 = {.cp = 0x1A17, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A18 = {.cp = 0x1A18, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A60 = {.cp = 0x1A60, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A75 = {.cp = 0x1A75, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A76 = {.cp = 0x1A76, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A77 = {.cp = 0x1A77, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A78 = {.cp = 0x1A78, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A79 = {.cp = 0x1A79, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A7A = {.cp = 0x1A7A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A7B = {.cp = 0x1A7B, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A7C = {.cp = 0x1A7C, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1A7F = {.cp = 0x1A7F, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AB0 = {.cp = 0x1AB0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AB1 = {.cp = 0x1AB1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AB2 = {.cp = 0x1AB2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AB3 = {.cp = 0x1AB3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AB4 = {.cp = 0x1AB4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AB5 = {.cp = 0x1AB5, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AB6 = {.cp = 0x1AB6, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AB7 = {.cp = 0x1AB7, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AB8 = {.cp = 0x1AB8, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AB9 = {.cp = 0x1AB9, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1ABA = {.cp = 0x1ABA, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1ABB = {.cp = 0x1ABB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1ABC = {.cp = 0x1ABC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1ABD = {.cp = 0x1ABD, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1ABF = {.cp = 0x1ABF, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AC0 = {.cp = 0x1AC0, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AC1 = {.cp = 0x1AC1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AC2 = {.cp = 0x1AC2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AC3 = {.cp = 0x1AC3, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AC4 = {.cp = 0x1AC4, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AC5 = {.cp = 0x1AC5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AC6 = {.cp = 0x1AC6, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AC7 = {.cp = 0x1AC7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AC8 = {.cp = 0x1AC8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1AC9 = {.cp = 0x1AC9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1ACA = {.cp = 0x1ACA, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1ACB = {.cp = 0x1ACB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1ACC = {.cp = 0x1ACC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1ACD = {.cp = 0x1ACD, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1ACE = {.cp = 0x1ACE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B06[2] = {0x1B05, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B06, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B06[2] = {0x1B05, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B06, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B06[2] = {0x1B05, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B06, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B06 = {.cp = 0x1B06, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B06, .cde = &lxb_unicode_decomposition_c_1B06, .kde = &lxb_unicode_decomposition_k_1B06};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B08[2] = {0x1B07, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B08, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B08[2] = {0x1B07, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B08, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B08[2] = {0x1B07, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B08, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B08 = {.cp = 0x1B08, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B08, .cde = &lxb_unicode_decomposition_c_1B08, .kde = &lxb_unicode_decomposition_k_1B08};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B0A[2] = {0x1B09, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B0A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B0A[2] = {0x1B09, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B0A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B0A[2] = {0x1B09, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B0A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B0A = {.cp = 0x1B0A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B0A, .cde = &lxb_unicode_decomposition_c_1B0A, .kde = &lxb_unicode_decomposition_k_1B0A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B0C[2] = {0x1B0B, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B0C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B0C[2] = {0x1B0B, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B0C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B0C[2] = {0x1B0B, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B0C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B0C = {.cp = 0x1B0C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B0C, .cde = &lxb_unicode_decomposition_c_1B0C, .kde = &lxb_unicode_decomposition_k_1B0C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B0E[2] = {0x1B0D, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B0E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B0E[2] = {0x1B0D, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B0E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B0E[2] = {0x1B0D, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B0E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B0E = {.cp = 0x1B0E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B0E, .cde = &lxb_unicode_decomposition_c_1B0E, .kde = &lxb_unicode_decomposition_k_1B0E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B12[2] = {0x1B11, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B12, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B12[2] = {0x1B11, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B12, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B12[2] = {0x1B11, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B12, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B12 = {.cp = 0x1B12, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B12, .cde = &lxb_unicode_decomposition_c_1B12, .kde = &lxb_unicode_decomposition_k_1B12};

static const lxb_unicode_entry_t lxb_unicode_entry_1B34 = {.cp = 0x1B34, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1B35 = {.cp = 0x1B35, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B3B[2] = {0x1B3A, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B3B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B3B[2] = {0x1B3A, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B3B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B3B[2] = {0x1B3A, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B3B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B3B = {.cp = 0x1B3B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B3B, .cde = &lxb_unicode_decomposition_c_1B3B, .kde = &lxb_unicode_decomposition_k_1B3B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B3D[2] = {0x1B3C, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B3D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B3D[2] = {0x1B3C, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B3D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B3D[2] = {0x1B3C, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B3D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B3D = {.cp = 0x1B3D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B3D, .cde = &lxb_unicode_decomposition_c_1B3D, .kde = &lxb_unicode_decomposition_k_1B3D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B40[2] = {0x1B3E, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B40, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B40[2] = {0x1B3E, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B40, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B40[2] = {0x1B3E, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B40, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B40 = {.cp = 0x1B40, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B40, .cde = &lxb_unicode_decomposition_c_1B40, .kde = &lxb_unicode_decomposition_k_1B40};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B41[2] = {0x1B3F, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B41, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B41[2] = {0x1B3F, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B41, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B41[2] = {0x1B3F, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B41, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B41 = {.cp = 0x1B41, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B41, .cde = &lxb_unicode_decomposition_c_1B41, .kde = &lxb_unicode_decomposition_k_1B41};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1B43[2] = {0x1B42, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1B43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1B43, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1B43[2] = {0x1B42, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1B43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1B43, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1B43[2] = {0x1B42, 0x1B35};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1B43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1B43, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1B43 = {.cp = 0x1B43, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1B43, .cde = &lxb_unicode_decomposition_c_1B43, .kde = &lxb_unicode_decomposition_k_1B43};

static const lxb_unicode_entry_t lxb_unicode_entry_1B44 = {.cp = 0x1B44, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1B6B = {.cp = 0x1B6B, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1B6C = {.cp = 0x1B6C, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1B6D = {.cp = 0x1B6D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1B6E = {.cp = 0x1B6E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1B6F = {.cp = 0x1B6F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1B70 = {.cp = 0x1B70, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1B71 = {.cp = 0x1B71, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1B72 = {.cp = 0x1B72, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1B73 = {.cp = 0x1B73, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1BAA = {.cp = 0x1BAA, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1BAB = {.cp = 0x1BAB, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1BE6 = {.cp = 0x1BE6, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1BF2 = {.cp = 0x1BF2, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1BF3 = {.cp = 0x1BF3, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1C37 = {.cp = 0x1C37, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CD0 = {.cp = 0x1CD0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CD1 = {.cp = 0x1CD1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CD2 = {.cp = 0x1CD2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CD4 = {.cp = 0x1CD4, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CD5 = {.cp = 0x1CD5, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CD6 = {.cp = 0x1CD6, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CD7 = {.cp = 0x1CD7, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CD8 = {.cp = 0x1CD8, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CD9 = {.cp = 0x1CD9, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CDA = {.cp = 0x1CDA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CDB = {.cp = 0x1CDB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CDC = {.cp = 0x1CDC, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CDD = {.cp = 0x1CDD, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CDE = {.cp = 0x1CDE, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CDF = {.cp = 0x1CDF, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CE0 = {.cp = 0x1CE0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CE2 = {.cp = 0x1CE2, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CE3 = {.cp = 0x1CE3, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CE4 = {.cp = 0x1CE4, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CE5 = {.cp = 0x1CE5, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CE6 = {.cp = 0x1CE6, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CE7 = {.cp = 0x1CE7, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CE8 = {.cp = 0x1CE8, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CED = {.cp = 0x1CED, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CF4 = {.cp = 0x1CF4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CF8 = {.cp = 0x1CF8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1CF9 = {.cp = 0x1CF9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D2C[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D2C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D2C[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D2C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D2C[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D2C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D2C = {.cp = 0x1D2C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D2C, .cde = &lxb_unicode_decomposition_c_1D2C, .kde = &lxb_unicode_decomposition_k_1D2C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D2D[1] = {0x00C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D2D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D2D[1] = {0x00C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D2D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D2D[1] = {0x00C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D2D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D2D = {.cp = 0x1D2D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D2D, .cde = &lxb_unicode_decomposition_c_1D2D, .kde = &lxb_unicode_decomposition_k_1D2D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D2E[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D2E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D2E[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D2E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D2E[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D2E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D2E = {.cp = 0x1D2E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D2E, .cde = &lxb_unicode_decomposition_c_1D2E, .kde = &lxb_unicode_decomposition_k_1D2E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D30[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D30, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D30[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D30, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D30[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D30, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D30 = {.cp = 0x1D30, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D30, .cde = &lxb_unicode_decomposition_c_1D30, .kde = &lxb_unicode_decomposition_k_1D30};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D31[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D31, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D31[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D31, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D31[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D31, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D31 = {.cp = 0x1D31, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D31, .cde = &lxb_unicode_decomposition_c_1D31, .kde = &lxb_unicode_decomposition_k_1D31};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D32[1] = {0x018E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D32, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D32[1] = {0x018E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D32, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D32[1] = {0x018E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D32, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D32 = {.cp = 0x1D32, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D32, .cde = &lxb_unicode_decomposition_c_1D32, .kde = &lxb_unicode_decomposition_k_1D32};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D33[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D33, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D33[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D33, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D33[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D33, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D33 = {.cp = 0x1D33, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D33, .cde = &lxb_unicode_decomposition_c_1D33, .kde = &lxb_unicode_decomposition_k_1D33};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D34[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D34, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D34[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D34, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D34[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D34, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D34 = {.cp = 0x1D34, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D34, .cde = &lxb_unicode_decomposition_c_1D34, .kde = &lxb_unicode_decomposition_k_1D34};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D35[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D35, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D35[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D35, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D35[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D35, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D35 = {.cp = 0x1D35, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D35, .cde = &lxb_unicode_decomposition_c_1D35, .kde = &lxb_unicode_decomposition_k_1D35};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D36[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D36, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D36[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D36, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D36[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D36, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D36 = {.cp = 0x1D36, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D36, .cde = &lxb_unicode_decomposition_c_1D36, .kde = &lxb_unicode_decomposition_k_1D36};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D37[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D37, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D37[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D37, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D37[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D37, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D37 = {.cp = 0x1D37, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D37, .cde = &lxb_unicode_decomposition_c_1D37, .kde = &lxb_unicode_decomposition_k_1D37};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D38[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D38, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D38[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D38, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D38[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D38, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D38 = {.cp = 0x1D38, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D38, .cde = &lxb_unicode_decomposition_c_1D38, .kde = &lxb_unicode_decomposition_k_1D38};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D39[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D39, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D39[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D39, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D39[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D39, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D39 = {.cp = 0x1D39, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D39, .cde = &lxb_unicode_decomposition_c_1D39, .kde = &lxb_unicode_decomposition_k_1D39};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D3A[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D3A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D3A[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D3A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D3A[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D3A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D3A = {.cp = 0x1D3A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D3A, .cde = &lxb_unicode_decomposition_c_1D3A, .kde = &lxb_unicode_decomposition_k_1D3A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D3C[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D3C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D3C[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D3C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D3C[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D3C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D3C = {.cp = 0x1D3C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D3C, .cde = &lxb_unicode_decomposition_c_1D3C, .kde = &lxb_unicode_decomposition_k_1D3C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D3D[1] = {0x0222};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D3D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D3D[1] = {0x0222};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D3D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D3D[1] = {0x0222};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D3D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D3D = {.cp = 0x1D3D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D3D, .cde = &lxb_unicode_decomposition_c_1D3D, .kde = &lxb_unicode_decomposition_k_1D3D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D3E[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D3E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D3E[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D3E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D3E[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D3E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D3E = {.cp = 0x1D3E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D3E, .cde = &lxb_unicode_decomposition_c_1D3E, .kde = &lxb_unicode_decomposition_k_1D3E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D3F[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D3F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D3F[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D3F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D3F[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D3F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D3F = {.cp = 0x1D3F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D3F, .cde = &lxb_unicode_decomposition_c_1D3F, .kde = &lxb_unicode_decomposition_k_1D3F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D40[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D40, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D40[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D40, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D40[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D40, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D40 = {.cp = 0x1D40, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D40, .cde = &lxb_unicode_decomposition_c_1D40, .kde = &lxb_unicode_decomposition_k_1D40};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D41[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D41, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D41[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D41, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D41[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D41, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D41 = {.cp = 0x1D41, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D41, .cde = &lxb_unicode_decomposition_c_1D41, .kde = &lxb_unicode_decomposition_k_1D41};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D42[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D42, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D42[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D42, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D42[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D42, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D42 = {.cp = 0x1D42, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D42, .cde = &lxb_unicode_decomposition_c_1D42, .kde = &lxb_unicode_decomposition_k_1D42};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D43[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D43, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D43[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D43, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D43[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D43, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D43 = {.cp = 0x1D43, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D43, .cde = &lxb_unicode_decomposition_c_1D43, .kde = &lxb_unicode_decomposition_k_1D43};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D44[1] = {0x0250};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D44, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D44[1] = {0x0250};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D44, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D44[1] = {0x0250};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D44, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D44 = {.cp = 0x1D44, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D44, .cde = &lxb_unicode_decomposition_c_1D44, .kde = &lxb_unicode_decomposition_k_1D44};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D45[1] = {0x0251};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D45, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D45[1] = {0x0251};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D45, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D45[1] = {0x0251};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D45, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D45 = {.cp = 0x1D45, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D45, .cde = &lxb_unicode_decomposition_c_1D45, .kde = &lxb_unicode_decomposition_k_1D45};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D46[1] = {0x1D02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D46, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D46[1] = {0x1D02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D46, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D46[1] = {0x1D02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D46, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D46 = {.cp = 0x1D46, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D46, .cde = &lxb_unicode_decomposition_c_1D46, .kde = &lxb_unicode_decomposition_k_1D46};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D47[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D47, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D47[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D47, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D47[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D47, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D47 = {.cp = 0x1D47, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D47, .cde = &lxb_unicode_decomposition_c_1D47, .kde = &lxb_unicode_decomposition_k_1D47};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D48[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D48, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D48[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D48, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D48[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D48, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D48 = {.cp = 0x1D48, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D48, .cde = &lxb_unicode_decomposition_c_1D48, .kde = &lxb_unicode_decomposition_k_1D48};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D49[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D49, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D49[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D49, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D49[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D49, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D49 = {.cp = 0x1D49, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D49, .cde = &lxb_unicode_decomposition_c_1D49, .kde = &lxb_unicode_decomposition_k_1D49};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4A[1] = {0x0259};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D4A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4A[1] = {0x0259};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D4A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4A[1] = {0x0259};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D4A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4A = {.cp = 0x1D4A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4A, .cde = &lxb_unicode_decomposition_c_1D4A, .kde = &lxb_unicode_decomposition_k_1D4A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B[1] = {0x025B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D4B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B[1] = {0x025B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D4B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B[1] = {0x025B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D4B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B = {.cp = 0x1D4B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B, .cde = &lxb_unicode_decomposition_c_1D4B, .kde = &lxb_unicode_decomposition_k_1D4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4C[1] = {0x025C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D4C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4C[1] = {0x025C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D4C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4C[1] = {0x025C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D4C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4C = {.cp = 0x1D4C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4C, .cde = &lxb_unicode_decomposition_c_1D4C, .kde = &lxb_unicode_decomposition_k_1D4C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4D[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D4D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4D[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D4D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4D[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D4D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4D = {.cp = 0x1D4D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4D, .cde = &lxb_unicode_decomposition_c_1D4D, .kde = &lxb_unicode_decomposition_k_1D4D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4F[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D4F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4F[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D4F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4F[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D4F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4F = {.cp = 0x1D4F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4F, .cde = &lxb_unicode_decomposition_c_1D4F, .kde = &lxb_unicode_decomposition_k_1D4F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D50[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D50[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D50[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D50, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D50 = {.cp = 0x1D50, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D50, .cde = &lxb_unicode_decomposition_c_1D50, .kde = &lxb_unicode_decomposition_k_1D50};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D51[1] = {0x014B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D51[1] = {0x014B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D51[1] = {0x014B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D51, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D51 = {.cp = 0x1D51, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D51, .cde = &lxb_unicode_decomposition_c_1D51, .kde = &lxb_unicode_decomposition_k_1D51};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D52[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D52[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D52[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D52, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D52 = {.cp = 0x1D52, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D52, .cde = &lxb_unicode_decomposition_c_1D52, .kde = &lxb_unicode_decomposition_k_1D52};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D53[1] = {0x0254};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D53, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D53[1] = {0x0254};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D53, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D53[1] = {0x0254};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D53, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D53 = {.cp = 0x1D53, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D53, .cde = &lxb_unicode_decomposition_c_1D53, .kde = &lxb_unicode_decomposition_k_1D53};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D54[1] = {0x1D16};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D54[1] = {0x1D16};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D54[1] = {0x1D16};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D54, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D54 = {.cp = 0x1D54, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D54, .cde = &lxb_unicode_decomposition_c_1D54, .kde = &lxb_unicode_decomposition_k_1D54};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D55[1] = {0x1D17};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D55[1] = {0x1D17};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D55[1] = {0x1D17};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D55, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D55 = {.cp = 0x1D55, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D55, .cde = &lxb_unicode_decomposition_c_1D55, .kde = &lxb_unicode_decomposition_k_1D55};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D56[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D56[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D56[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D56, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D56 = {.cp = 0x1D56, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D56, .cde = &lxb_unicode_decomposition_c_1D56, .kde = &lxb_unicode_decomposition_k_1D56};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D57[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D57[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D57[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D57, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D57 = {.cp = 0x1D57, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D57, .cde = &lxb_unicode_decomposition_c_1D57, .kde = &lxb_unicode_decomposition_k_1D57};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D58[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D58[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D58[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D58, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D58 = {.cp = 0x1D58, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D58, .cde = &lxb_unicode_decomposition_c_1D58, .kde = &lxb_unicode_decomposition_k_1D58};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D59[1] = {0x1D1D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D59[1] = {0x1D1D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D59[1] = {0x1D1D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D59, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D59 = {.cp = 0x1D59, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D59, .cde = &lxb_unicode_decomposition_c_1D59, .kde = &lxb_unicode_decomposition_k_1D59};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D5A[1] = {0x026F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D5A[1] = {0x026F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D5A[1] = {0x026F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D5A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D5A = {.cp = 0x1D5A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D5A, .cde = &lxb_unicode_decomposition_c_1D5A, .kde = &lxb_unicode_decomposition_k_1D5A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D5B[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D5B[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D5B[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D5B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D5B = {.cp = 0x1D5B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D5B, .cde = &lxb_unicode_decomposition_c_1D5B, .kde = &lxb_unicode_decomposition_k_1D5B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D5C[1] = {0x1D25};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D5C[1] = {0x1D25};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D5C[1] = {0x1D25};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D5C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D5C = {.cp = 0x1D5C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D5C, .cde = &lxb_unicode_decomposition_c_1D5C, .kde = &lxb_unicode_decomposition_k_1D5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D5D[1] = {0x03B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D5D[1] = {0x03B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D5D[1] = {0x03B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D5D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D5D = {.cp = 0x1D5D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D5D, .cde = &lxb_unicode_decomposition_c_1D5D, .kde = &lxb_unicode_decomposition_k_1D5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D5E[1] = {0x03B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D5E[1] = {0x03B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D5E[1] = {0x03B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D5E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D5E = {.cp = 0x1D5E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D5E, .cde = &lxb_unicode_decomposition_c_1D5E, .kde = &lxb_unicode_decomposition_k_1D5E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D5F[1] = {0x03B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D5F[1] = {0x03B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D5F[1] = {0x03B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D5F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D5F = {.cp = 0x1D5F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D5F, .cde = &lxb_unicode_decomposition_c_1D5F, .kde = &lxb_unicode_decomposition_k_1D5F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D60[1] = {0x03C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D60[1] = {0x03C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D60[1] = {0x03C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D60, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D60 = {.cp = 0x1D60, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D60, .cde = &lxb_unicode_decomposition_c_1D60, .kde = &lxb_unicode_decomposition_k_1D60};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D61[1] = {0x03C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D61[1] = {0x03C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D61[1] = {0x03C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D61, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D61 = {.cp = 0x1D61, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D61, .cde = &lxb_unicode_decomposition_c_1D61, .kde = &lxb_unicode_decomposition_k_1D61};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D62[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_1D62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D62[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_1D62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D62[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__1D62, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D62 = {.cp = 0x1D62, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D62, .cde = &lxb_unicode_decomposition_c_1D62, .kde = &lxb_unicode_decomposition_k_1D62};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D63[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_1D63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D63[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_1D63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D63[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__1D63, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D63 = {.cp = 0x1D63, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D63, .cde = &lxb_unicode_decomposition_c_1D63, .kde = &lxb_unicode_decomposition_k_1D63};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D64[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_1D64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D64[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_1D64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D64[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__1D64, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D64 = {.cp = 0x1D64, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D64, .cde = &lxb_unicode_decomposition_c_1D64, .kde = &lxb_unicode_decomposition_k_1D64};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D65[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_1D65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D65[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_1D65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D65[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__1D65, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D65 = {.cp = 0x1D65, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D65, .cde = &lxb_unicode_decomposition_c_1D65, .kde = &lxb_unicode_decomposition_k_1D65};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D66[1] = {0x03B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_1D66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D66[1] = {0x03B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_1D66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D66[1] = {0x03B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__1D66, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D66 = {.cp = 0x1D66, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D66, .cde = &lxb_unicode_decomposition_c_1D66, .kde = &lxb_unicode_decomposition_k_1D66};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D67[1] = {0x03B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_1D67, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D67[1] = {0x03B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_1D67, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D67[1] = {0x03B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__1D67, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D67 = {.cp = 0x1D67, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D67, .cde = &lxb_unicode_decomposition_c_1D67, .kde = &lxb_unicode_decomposition_k_1D67};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D68[1] = {0x03C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_1D68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D68[1] = {0x03C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_1D68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D68[1] = {0x03C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__1D68, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D68 = {.cp = 0x1D68, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D68, .cde = &lxb_unicode_decomposition_c_1D68, .kde = &lxb_unicode_decomposition_k_1D68};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D69[1] = {0x03C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_1D69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D69[1] = {0x03C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_1D69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D69[1] = {0x03C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__1D69, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D69 = {.cp = 0x1D69, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D69, .cde = &lxb_unicode_decomposition_c_1D69, .kde = &lxb_unicode_decomposition_k_1D69};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D6A[1] = {0x03C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_1D6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D6A[1] = {0x03C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_1D6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D6A[1] = {0x03C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__1D6A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D6A = {.cp = 0x1D6A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D6A, .cde = &lxb_unicode_decomposition_c_1D6A, .kde = &lxb_unicode_decomposition_k_1D6A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D78[1] = {0x043D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D78, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D78[1] = {0x043D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D78, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D78[1] = {0x043D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D78, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D78 = {.cp = 0x1D78, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D78, .cde = &lxb_unicode_decomposition_c_1D78, .kde = &lxb_unicode_decomposition_k_1D78};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D9B[1] = {0x0252};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D9B[1] = {0x0252};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D9B[1] = {0x0252};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D9B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D9B = {.cp = 0x1D9B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D9B, .cde = &lxb_unicode_decomposition_c_1D9B, .kde = &lxb_unicode_decomposition_k_1D9B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D9C[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D9C[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D9C[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D9C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D9C = {.cp = 0x1D9C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D9C, .cde = &lxb_unicode_decomposition_c_1D9C, .kde = &lxb_unicode_decomposition_k_1D9C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D9D[1] = {0x0255};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D9D[1] = {0x0255};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D9D[1] = {0x0255};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D9D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D9D = {.cp = 0x1D9D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D9D, .cde = &lxb_unicode_decomposition_c_1D9D, .kde = &lxb_unicode_decomposition_k_1D9D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D9E[1] = {0x00F0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D9E[1] = {0x00F0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D9E[1] = {0x00F0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D9E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D9E = {.cp = 0x1D9E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D9E, .cde = &lxb_unicode_decomposition_c_1D9E, .kde = &lxb_unicode_decomposition_k_1D9E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D9F[1] = {0x025C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1D9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D9F[1] = {0x025C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1D9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D9F[1] = {0x025C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1D9F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D9F = {.cp = 0x1D9F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D9F, .cde = &lxb_unicode_decomposition_c_1D9F, .kde = &lxb_unicode_decomposition_k_1D9F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DA0[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DA0[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DA0[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DA0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DA0 = {.cp = 0x1DA0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DA0, .cde = &lxb_unicode_decomposition_c_1DA0, .kde = &lxb_unicode_decomposition_k_1DA0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DA1[1] = {0x025F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DA1[1] = {0x025F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DA1[1] = {0x025F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DA1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DA1 = {.cp = 0x1DA1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DA1, .cde = &lxb_unicode_decomposition_c_1DA1, .kde = &lxb_unicode_decomposition_k_1DA1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DA2[1] = {0x0261};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DA2[1] = {0x0261};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DA2[1] = {0x0261};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DA2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DA2 = {.cp = 0x1DA2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DA2, .cde = &lxb_unicode_decomposition_c_1DA2, .kde = &lxb_unicode_decomposition_k_1DA2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DA3[1] = {0x0265};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DA3[1] = {0x0265};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DA3[1] = {0x0265};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DA3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DA3 = {.cp = 0x1DA3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DA3, .cde = &lxb_unicode_decomposition_c_1DA3, .kde = &lxb_unicode_decomposition_k_1DA3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DA4[1] = {0x0268};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DA4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DA4[1] = {0x0268};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DA4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DA4[1] = {0x0268};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DA4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DA4 = {.cp = 0x1DA4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DA4, .cde = &lxb_unicode_decomposition_c_1DA4, .kde = &lxb_unicode_decomposition_k_1DA4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DA5[1] = {0x0269};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DA5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DA5[1] = {0x0269};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DA5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DA5[1] = {0x0269};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DA5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DA5 = {.cp = 0x1DA5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DA5, .cde = &lxb_unicode_decomposition_c_1DA5, .kde = &lxb_unicode_decomposition_k_1DA5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DA6[1] = {0x026A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DA6[1] = {0x026A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DA6[1] = {0x026A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DA6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DA6 = {.cp = 0x1DA6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DA6, .cde = &lxb_unicode_decomposition_c_1DA6, .kde = &lxb_unicode_decomposition_k_1DA6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DA7[1] = {0x1D7B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DA7[1] = {0x1D7B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DA7[1] = {0x1D7B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DA7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DA7 = {.cp = 0x1DA7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DA7, .cde = &lxb_unicode_decomposition_c_1DA7, .kde = &lxb_unicode_decomposition_k_1DA7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DA8[1] = {0x029D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DA8[1] = {0x029D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DA8[1] = {0x029D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DA8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DA8 = {.cp = 0x1DA8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DA8, .cde = &lxb_unicode_decomposition_c_1DA8, .kde = &lxb_unicode_decomposition_k_1DA8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DA9[1] = {0x026D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DA9[1] = {0x026D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DA9[1] = {0x026D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DA9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DA9 = {.cp = 0x1DA9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DA9, .cde = &lxb_unicode_decomposition_c_1DA9, .kde = &lxb_unicode_decomposition_k_1DA9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DAA[1] = {0x1D85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DAA[1] = {0x1D85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DAA[1] = {0x1D85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DAA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DAA = {.cp = 0x1DAA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DAA, .cde = &lxb_unicode_decomposition_c_1DAA, .kde = &lxb_unicode_decomposition_k_1DAA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DAB[1] = {0x029F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DAB[1] = {0x029F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DAB[1] = {0x029F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DAB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DAB = {.cp = 0x1DAB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DAB, .cde = &lxb_unicode_decomposition_c_1DAB, .kde = &lxb_unicode_decomposition_k_1DAB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DAC[1] = {0x0271};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DAC[1] = {0x0271};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DAC[1] = {0x0271};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DAC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DAC = {.cp = 0x1DAC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DAC, .cde = &lxb_unicode_decomposition_c_1DAC, .kde = &lxb_unicode_decomposition_k_1DAC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DAD[1] = {0x0270};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DAD[1] = {0x0270};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DAD[1] = {0x0270};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DAD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DAD = {.cp = 0x1DAD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DAD, .cde = &lxb_unicode_decomposition_c_1DAD, .kde = &lxb_unicode_decomposition_k_1DAD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DAE[1] = {0x0272};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DAE[1] = {0x0272};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DAE[1] = {0x0272};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DAE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DAE = {.cp = 0x1DAE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DAE, .cde = &lxb_unicode_decomposition_c_1DAE, .kde = &lxb_unicode_decomposition_k_1DAE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DAF[1] = {0x0273};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DAF[1] = {0x0273};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DAF[1] = {0x0273};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DAF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DAF = {.cp = 0x1DAF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DAF, .cde = &lxb_unicode_decomposition_c_1DAF, .kde = &lxb_unicode_decomposition_k_1DAF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DB0[1] = {0x0274};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DB0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DB0[1] = {0x0274};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DB0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DB0[1] = {0x0274};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DB0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DB0 = {.cp = 0x1DB0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DB0, .cde = &lxb_unicode_decomposition_c_1DB0, .kde = &lxb_unicode_decomposition_k_1DB0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DB1[1] = {0x0275};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DB1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DB1[1] = {0x0275};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DB1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DB1[1] = {0x0275};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DB1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DB1 = {.cp = 0x1DB1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DB1, .cde = &lxb_unicode_decomposition_c_1DB1, .kde = &lxb_unicode_decomposition_k_1DB1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DB2[1] = {0x0278};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DB2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DB2[1] = {0x0278};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DB2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DB2[1] = {0x0278};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DB2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DB2 = {.cp = 0x1DB2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DB2, .cde = &lxb_unicode_decomposition_c_1DB2, .kde = &lxb_unicode_decomposition_k_1DB2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DB3[1] = {0x0282};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DB3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DB3[1] = {0x0282};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DB3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DB3[1] = {0x0282};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DB3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DB3 = {.cp = 0x1DB3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DB3, .cde = &lxb_unicode_decomposition_c_1DB3, .kde = &lxb_unicode_decomposition_k_1DB3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DB4[1] = {0x0283};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DB4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DB4[1] = {0x0283};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DB4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DB4[1] = {0x0283};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DB4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DB4 = {.cp = 0x1DB4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DB4, .cde = &lxb_unicode_decomposition_c_1DB4, .kde = &lxb_unicode_decomposition_k_1DB4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DB5[1] = {0x01AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DB5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DB5[1] = {0x01AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DB5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DB5[1] = {0x01AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DB5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DB5 = {.cp = 0x1DB5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DB5, .cde = &lxb_unicode_decomposition_c_1DB5, .kde = &lxb_unicode_decomposition_k_1DB5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DB6[1] = {0x0289};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DB6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DB6[1] = {0x0289};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DB6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DB6[1] = {0x0289};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DB6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DB6 = {.cp = 0x1DB6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DB6, .cde = &lxb_unicode_decomposition_c_1DB6, .kde = &lxb_unicode_decomposition_k_1DB6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DB7[1] = {0x028A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DB7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DB7[1] = {0x028A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DB7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DB7[1] = {0x028A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DB7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DB7 = {.cp = 0x1DB7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DB7, .cde = &lxb_unicode_decomposition_c_1DB7, .kde = &lxb_unicode_decomposition_k_1DB7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DB8[1] = {0x1D1C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DB8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DB8[1] = {0x1D1C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DB8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DB8[1] = {0x1D1C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DB8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DB8 = {.cp = 0x1DB8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DB8, .cde = &lxb_unicode_decomposition_c_1DB8, .kde = &lxb_unicode_decomposition_k_1DB8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DB9[1] = {0x028B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DB9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DB9[1] = {0x028B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DB9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DB9[1] = {0x028B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DB9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DB9 = {.cp = 0x1DB9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DB9, .cde = &lxb_unicode_decomposition_c_1DB9, .kde = &lxb_unicode_decomposition_k_1DB9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DBA[1] = {0x028C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DBA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DBA[1] = {0x028C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DBA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DBA[1] = {0x028C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DBA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DBA = {.cp = 0x1DBA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DBA, .cde = &lxb_unicode_decomposition_c_1DBA, .kde = &lxb_unicode_decomposition_k_1DBA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DBB[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DBB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DBB[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DBB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DBB[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DBB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DBB = {.cp = 0x1DBB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DBB, .cde = &lxb_unicode_decomposition_c_1DBB, .kde = &lxb_unicode_decomposition_k_1DBB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DBC[1] = {0x0290};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DBC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DBC[1] = {0x0290};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DBC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DBC[1] = {0x0290};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DBC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DBC = {.cp = 0x1DBC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DBC, .cde = &lxb_unicode_decomposition_c_1DBC, .kde = &lxb_unicode_decomposition_k_1DBC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DBD[1] = {0x0291};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DBD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DBD[1] = {0x0291};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DBD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DBD[1] = {0x0291};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DBD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DBD = {.cp = 0x1DBD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DBD, .cde = &lxb_unicode_decomposition_c_1DBD, .kde = &lxb_unicode_decomposition_k_1DBD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DBE[1] = {0x0292};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DBE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DBE[1] = {0x0292};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DBE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DBE[1] = {0x0292};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DBE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DBE = {.cp = 0x1DBE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DBE, .cde = &lxb_unicode_decomposition_c_1DBE, .kde = &lxb_unicode_decomposition_k_1DBE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1DBF[1] = {0x03B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1DBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_1DBF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1DBF[1] = {0x03B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1DBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_1DBF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1DBF[1] = {0x03B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1DBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__1DBF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1DBF = {.cp = 0x1DBF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1DBF, .cde = &lxb_unicode_decomposition_c_1DBF, .kde = &lxb_unicode_decomposition_k_1DBF};

static const lxb_unicode_entry_t lxb_unicode_entry_1DC0 = {.cp = 0x1DC0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DC1 = {.cp = 0x1DC1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DC2 = {.cp = 0x1DC2, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DC3 = {.cp = 0x1DC3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DC4 = {.cp = 0x1DC4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DC5 = {.cp = 0x1DC5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DC6 = {.cp = 0x1DC6, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DC7 = {.cp = 0x1DC7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DC8 = {.cp = 0x1DC8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DC9 = {.cp = 0x1DC9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DCA = {.cp = 0x1DCA, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DCB = {.cp = 0x1DCB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DCC = {.cp = 0x1DCC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DCD = {.cp = 0x1DCD, .ccc = 234, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DCE = {.cp = 0x1DCE, .ccc = 214, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DCF = {.cp = 0x1DCF, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DD0 = {.cp = 0x1DD0, .ccc = 202, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DD1 = {.cp = 0x1DD1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DD2 = {.cp = 0x1DD2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DD3 = {.cp = 0x1DD3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DD4 = {.cp = 0x1DD4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DD5 = {.cp = 0x1DD5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DD6 = {.cp = 0x1DD6, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DD7 = {.cp = 0x1DD7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DD8 = {.cp = 0x1DD8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DD9 = {.cp = 0x1DD9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DDA = {.cp = 0x1DDA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DDB = {.cp = 0x1DDB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DDC = {.cp = 0x1DDC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DDD = {.cp = 0x1DDD, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DDE = {.cp = 0x1DDE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DDF = {.cp = 0x1DDF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DE0 = {.cp = 0x1DE0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DE1 = {.cp = 0x1DE1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DE2 = {.cp = 0x1DE2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DE3 = {.cp = 0x1DE3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DE4 = {.cp = 0x1DE4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DE5 = {.cp = 0x1DE5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DE6 = {.cp = 0x1DE6, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DE7 = {.cp = 0x1DE7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DE8 = {.cp = 0x1DE8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DE9 = {.cp = 0x1DE9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DEA = {.cp = 0x1DEA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DEB = {.cp = 0x1DEB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DEC = {.cp = 0x1DEC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DED = {.cp = 0x1DED, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DEE = {.cp = 0x1DEE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DEF = {.cp = 0x1DEF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DF0 = {.cp = 0x1DF0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DF1 = {.cp = 0x1DF1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DF2 = {.cp = 0x1DF2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DF3 = {.cp = 0x1DF3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DF4 = {.cp = 0x1DF4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DF5 = {.cp = 0x1DF5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DF6 = {.cp = 0x1DF6, .ccc = 232, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DF7 = {.cp = 0x1DF7, .ccc = 228, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DF8 = {.cp = 0x1DF8, .ccc = 228, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DF9 = {.cp = 0x1DF9, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DFA = {.cp = 0x1DFA, .ccc = 218, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DFB = {.cp = 0x1DFB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DFC = {.cp = 0x1DFC, .ccc = 233, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DFD = {.cp = 0x1DFD, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DFE = {.cp = 0x1DFE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1DFF = {.cp = 0x1DFF, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E00[2] = {0x0041, 0x0325};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E00, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E00[2] = {0x0041, 0x0325};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E00, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E00[2] = {0x0041, 0x0325};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E00, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E00 = {.cp = 0x1E00, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E00, .cde = &lxb_unicode_decomposition_c_1E00, .kde = &lxb_unicode_decomposition_k_1E00};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E01[2] = {0x0061, 0x0325};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E01, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E01[2] = {0x0061, 0x0325};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E01, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E01[2] = {0x0061, 0x0325};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E01, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E01 = {.cp = 0x1E01, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E01, .cde = &lxb_unicode_decomposition_c_1E01, .kde = &lxb_unicode_decomposition_k_1E01};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E02[2] = {0x0042, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E02, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E02[2] = {0x0042, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E02, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E02[2] = {0x0042, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E02, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E02 = {.cp = 0x1E02, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E02, .cde = &lxb_unicode_decomposition_c_1E02, .kde = &lxb_unicode_decomposition_k_1E02};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E03[2] = {0x0062, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E03, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E03[2] = {0x0062, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E03, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E03[2] = {0x0062, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E03, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E03 = {.cp = 0x1E03, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E03, .cde = &lxb_unicode_decomposition_c_1E03, .kde = &lxb_unicode_decomposition_k_1E03};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E04[2] = {0x0042, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E04, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E04[2] = {0x0042, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E04, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E04[2] = {0x0042, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E04, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E04 = {.cp = 0x1E04, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E04, .cde = &lxb_unicode_decomposition_c_1E04, .kde = &lxb_unicode_decomposition_k_1E04};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E05[2] = {0x0062, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E05, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E05[2] = {0x0062, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E05, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E05[2] = {0x0062, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E05, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E05 = {.cp = 0x1E05, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E05, .cde = &lxb_unicode_decomposition_c_1E05, .kde = &lxb_unicode_decomposition_k_1E05};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E06[2] = {0x0042, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E06, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E06[2] = {0x0042, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E06, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E06[2] = {0x0042, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E06, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E06 = {.cp = 0x1E06, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E06, .cde = &lxb_unicode_decomposition_c_1E06, .kde = &lxb_unicode_decomposition_k_1E06};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E07[2] = {0x0062, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E07, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E07[2] = {0x0062, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E07, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E07[2] = {0x0062, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E07, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E07 = {.cp = 0x1E07, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E07, .cde = &lxb_unicode_decomposition_c_1E07, .kde = &lxb_unicode_decomposition_k_1E07};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E08[3] = {0x0043, 0x0327, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E08, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E08[3] = {0x0043, 0x0327, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E08, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E08[2] = {0x00C7, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E08, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E08 = {.cp = 0x1E08, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E08, .cde = &lxb_unicode_decomposition_c_1E08, .kde = &lxb_unicode_decomposition_k_1E08};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E09[3] = {0x0063, 0x0327, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E09, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E09[3] = {0x0063, 0x0327, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E09, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E09[2] = {0x00E7, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E09, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E09 = {.cp = 0x1E09, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E09, .cde = &lxb_unicode_decomposition_c_1E09, .kde = &lxb_unicode_decomposition_k_1E09};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E0A[2] = {0x0044, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E0A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E0A[2] = {0x0044, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E0A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E0A[2] = {0x0044, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E0A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E0A = {.cp = 0x1E0A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E0A, .cde = &lxb_unicode_decomposition_c_1E0A, .kde = &lxb_unicode_decomposition_k_1E0A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E0B[2] = {0x0064, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E0B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E0B[2] = {0x0064, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E0B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E0B[2] = {0x0064, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E0B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E0B = {.cp = 0x1E0B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E0B, .cde = &lxb_unicode_decomposition_c_1E0B, .kde = &lxb_unicode_decomposition_k_1E0B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E0C[2] = {0x0044, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E0C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E0C[2] = {0x0044, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E0C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E0C[2] = {0x0044, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E0C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E0C = {.cp = 0x1E0C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E0C, .cde = &lxb_unicode_decomposition_c_1E0C, .kde = &lxb_unicode_decomposition_k_1E0C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E0D[2] = {0x0064, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E0D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E0D[2] = {0x0064, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E0D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E0D[2] = {0x0064, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E0D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E0D = {.cp = 0x1E0D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E0D, .cde = &lxb_unicode_decomposition_c_1E0D, .kde = &lxb_unicode_decomposition_k_1E0D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E0E[2] = {0x0044, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E0E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E0E[2] = {0x0044, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E0E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E0E[2] = {0x0044, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E0E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E0E = {.cp = 0x1E0E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E0E, .cde = &lxb_unicode_decomposition_c_1E0E, .kde = &lxb_unicode_decomposition_k_1E0E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E0F[2] = {0x0064, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E0F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E0F[2] = {0x0064, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E0F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E0F[2] = {0x0064, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E0F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E0F = {.cp = 0x1E0F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E0F, .cde = &lxb_unicode_decomposition_c_1E0F, .kde = &lxb_unicode_decomposition_k_1E0F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E10[2] = {0x0044, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E10, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E10[2] = {0x0044, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E10, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E10[2] = {0x0044, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E10, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E10 = {.cp = 0x1E10, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E10, .cde = &lxb_unicode_decomposition_c_1E10, .kde = &lxb_unicode_decomposition_k_1E10};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E11[2] = {0x0064, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E11, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E11[2] = {0x0064, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E11, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E11[2] = {0x0064, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E11, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E11 = {.cp = 0x1E11, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E11, .cde = &lxb_unicode_decomposition_c_1E11, .kde = &lxb_unicode_decomposition_k_1E11};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E12[2] = {0x0044, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E12, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E12[2] = {0x0044, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E12, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E12[2] = {0x0044, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E12, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E12 = {.cp = 0x1E12, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E12, .cde = &lxb_unicode_decomposition_c_1E12, .kde = &lxb_unicode_decomposition_k_1E12};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E13[2] = {0x0064, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E13, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E13[2] = {0x0064, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E13, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E13[2] = {0x0064, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E13, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E13 = {.cp = 0x1E13, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E13, .cde = &lxb_unicode_decomposition_c_1E13, .kde = &lxb_unicode_decomposition_k_1E13};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E14[3] = {0x0045, 0x0304, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E14, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E14[3] = {0x0045, 0x0304, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E14, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E14[2] = {0x0112, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E14, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E14 = {.cp = 0x1E14, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E14, .cde = &lxb_unicode_decomposition_c_1E14, .kde = &lxb_unicode_decomposition_k_1E14};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E15[3] = {0x0065, 0x0304, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E15, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E15[3] = {0x0065, 0x0304, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E15, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E15[2] = {0x0113, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E15, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E15 = {.cp = 0x1E15, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E15, .cde = &lxb_unicode_decomposition_c_1E15, .kde = &lxb_unicode_decomposition_k_1E15};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E16[3] = {0x0045, 0x0304, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E16, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E16[3] = {0x0045, 0x0304, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E16, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E16[2] = {0x0112, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E16, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E16 = {.cp = 0x1E16, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E16, .cde = &lxb_unicode_decomposition_c_1E16, .kde = &lxb_unicode_decomposition_k_1E16};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E17[3] = {0x0065, 0x0304, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E17, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E17[3] = {0x0065, 0x0304, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E17, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E17[2] = {0x0113, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E17, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E17 = {.cp = 0x1E17, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E17, .cde = &lxb_unicode_decomposition_c_1E17, .kde = &lxb_unicode_decomposition_k_1E17};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E18[2] = {0x0045, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E18, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E18[2] = {0x0045, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E18, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E18[2] = {0x0045, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E18, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E18 = {.cp = 0x1E18, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E18, .cde = &lxb_unicode_decomposition_c_1E18, .kde = &lxb_unicode_decomposition_k_1E18};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E19[2] = {0x0065, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E19, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E19[2] = {0x0065, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E19, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E19[2] = {0x0065, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E19, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E19 = {.cp = 0x1E19, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E19, .cde = &lxb_unicode_decomposition_c_1E19, .kde = &lxb_unicode_decomposition_k_1E19};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E1A[2] = {0x0045, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E1A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E1A[2] = {0x0045, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E1A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E1A[2] = {0x0045, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E1A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E1A = {.cp = 0x1E1A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E1A, .cde = &lxb_unicode_decomposition_c_1E1A, .kde = &lxb_unicode_decomposition_k_1E1A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E1B[2] = {0x0065, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E1B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E1B[2] = {0x0065, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E1B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E1B[2] = {0x0065, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E1B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E1B = {.cp = 0x1E1B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E1B, .cde = &lxb_unicode_decomposition_c_1E1B, .kde = &lxb_unicode_decomposition_k_1E1B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E1C[3] = {0x0045, 0x0327, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E1C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E1C[3] = {0x0045, 0x0327, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E1C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E1C[2] = {0x0228, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E1C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E1C = {.cp = 0x1E1C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E1C, .cde = &lxb_unicode_decomposition_c_1E1C, .kde = &lxb_unicode_decomposition_k_1E1C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E1D[3] = {0x0065, 0x0327, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E1D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E1D[3] = {0x0065, 0x0327, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E1D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E1D[2] = {0x0229, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E1D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E1D = {.cp = 0x1E1D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E1D, .cde = &lxb_unicode_decomposition_c_1E1D, .kde = &lxb_unicode_decomposition_k_1E1D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E1E[2] = {0x0046, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E1E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E1E[2] = {0x0046, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E1E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E1E[2] = {0x0046, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E1E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E1E = {.cp = 0x1E1E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E1E, .cde = &lxb_unicode_decomposition_c_1E1E, .kde = &lxb_unicode_decomposition_k_1E1E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E1F[2] = {0x0066, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E1F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E1F[2] = {0x0066, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E1F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E1F[2] = {0x0066, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E1F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E1F = {.cp = 0x1E1F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E1F, .cde = &lxb_unicode_decomposition_c_1E1F, .kde = &lxb_unicode_decomposition_k_1E1F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E20[2] = {0x0047, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E20, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E20[2] = {0x0047, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E20, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E20[2] = {0x0047, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E20, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E20 = {.cp = 0x1E20, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E20, .cde = &lxb_unicode_decomposition_c_1E20, .kde = &lxb_unicode_decomposition_k_1E20};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E21[2] = {0x0067, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E21, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E21[2] = {0x0067, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E21, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E21[2] = {0x0067, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E21, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E21 = {.cp = 0x1E21, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E21, .cde = &lxb_unicode_decomposition_c_1E21, .kde = &lxb_unicode_decomposition_k_1E21};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E22[2] = {0x0048, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E22, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E22[2] = {0x0048, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E22, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E22[2] = {0x0048, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E22, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E22 = {.cp = 0x1E22, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E22, .cde = &lxb_unicode_decomposition_c_1E22, .kde = &lxb_unicode_decomposition_k_1E22};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E23[2] = {0x0068, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E23, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E23[2] = {0x0068, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E23, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E23[2] = {0x0068, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E23, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E23 = {.cp = 0x1E23, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E23, .cde = &lxb_unicode_decomposition_c_1E23, .kde = &lxb_unicode_decomposition_k_1E23};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E24[2] = {0x0048, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E24, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E24[2] = {0x0048, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E24, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E24[2] = {0x0048, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E24, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E24 = {.cp = 0x1E24, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E24, .cde = &lxb_unicode_decomposition_c_1E24, .kde = &lxb_unicode_decomposition_k_1E24};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E25[2] = {0x0068, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E25, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E25[2] = {0x0068, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E25, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E25[2] = {0x0068, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E25, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E25 = {.cp = 0x1E25, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E25, .cde = &lxb_unicode_decomposition_c_1E25, .kde = &lxb_unicode_decomposition_k_1E25};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E26[2] = {0x0048, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E26, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E26[2] = {0x0048, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E26, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E26[2] = {0x0048, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E26, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E26 = {.cp = 0x1E26, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E26, .cde = &lxb_unicode_decomposition_c_1E26, .kde = &lxb_unicode_decomposition_k_1E26};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E27[2] = {0x0068, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E27, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E27[2] = {0x0068, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E27, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E27[2] = {0x0068, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E27, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E27 = {.cp = 0x1E27, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E27, .cde = &lxb_unicode_decomposition_c_1E27, .kde = &lxb_unicode_decomposition_k_1E27};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E28[2] = {0x0048, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E28, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E28[2] = {0x0048, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E28, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E28[2] = {0x0048, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E28, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E28 = {.cp = 0x1E28, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E28, .cde = &lxb_unicode_decomposition_c_1E28, .kde = &lxb_unicode_decomposition_k_1E28};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E29[2] = {0x0068, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E29, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E29[2] = {0x0068, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E29, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E29[2] = {0x0068, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E29, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E29 = {.cp = 0x1E29, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E29, .cde = &lxb_unicode_decomposition_c_1E29, .kde = &lxb_unicode_decomposition_k_1E29};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E2A[2] = {0x0048, 0x032E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E2A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E2A[2] = {0x0048, 0x032E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E2A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E2A[2] = {0x0048, 0x032E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E2A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E2A = {.cp = 0x1E2A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E2A, .cde = &lxb_unicode_decomposition_c_1E2A, .kde = &lxb_unicode_decomposition_k_1E2A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E2B[2] = {0x0068, 0x032E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E2B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E2B[2] = {0x0068, 0x032E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E2B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E2B[2] = {0x0068, 0x032E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E2B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E2B = {.cp = 0x1E2B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E2B, .cde = &lxb_unicode_decomposition_c_1E2B, .kde = &lxb_unicode_decomposition_k_1E2B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E2C[2] = {0x0049, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E2C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E2C[2] = {0x0049, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E2C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E2C[2] = {0x0049, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E2C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E2C = {.cp = 0x1E2C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E2C, .cde = &lxb_unicode_decomposition_c_1E2C, .kde = &lxb_unicode_decomposition_k_1E2C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E2D[2] = {0x0069, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E2D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E2D[2] = {0x0069, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E2D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E2D[2] = {0x0069, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E2D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E2D = {.cp = 0x1E2D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E2D, .cde = &lxb_unicode_decomposition_c_1E2D, .kde = &lxb_unicode_decomposition_k_1E2D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E2E[3] = {0x0049, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E2E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E2E[3] = {0x0049, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E2E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E2E[2] = {0x00CF, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E2E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E2E = {.cp = 0x1E2E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E2E, .cde = &lxb_unicode_decomposition_c_1E2E, .kde = &lxb_unicode_decomposition_k_1E2E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E2F[3] = {0x0069, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E2F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E2F[3] = {0x0069, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E2F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E2F[2] = {0x00EF, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E2F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E2F = {.cp = 0x1E2F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E2F, .cde = &lxb_unicode_decomposition_c_1E2F, .kde = &lxb_unicode_decomposition_k_1E2F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E30[2] = {0x004B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E30, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E30[2] = {0x004B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E30, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E30[2] = {0x004B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E30, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E30 = {.cp = 0x1E30, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E30, .cde = &lxb_unicode_decomposition_c_1E30, .kde = &lxb_unicode_decomposition_k_1E30};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E31[2] = {0x006B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E31, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E31[2] = {0x006B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E31, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E31[2] = {0x006B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E31, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E31 = {.cp = 0x1E31, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E31, .cde = &lxb_unicode_decomposition_c_1E31, .kde = &lxb_unicode_decomposition_k_1E31};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E32[2] = {0x004B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E32, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E32[2] = {0x004B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E32, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E32[2] = {0x004B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E32, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E32 = {.cp = 0x1E32, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E32, .cde = &lxb_unicode_decomposition_c_1E32, .kde = &lxb_unicode_decomposition_k_1E32};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E33[2] = {0x006B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E33, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E33[2] = {0x006B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E33, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E33[2] = {0x006B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E33, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E33 = {.cp = 0x1E33, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E33, .cde = &lxb_unicode_decomposition_c_1E33, .kde = &lxb_unicode_decomposition_k_1E33};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E34[2] = {0x004B, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E34, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E34[2] = {0x004B, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E34, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E34[2] = {0x004B, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E34, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E34 = {.cp = 0x1E34, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E34, .cde = &lxb_unicode_decomposition_c_1E34, .kde = &lxb_unicode_decomposition_k_1E34};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E35[2] = {0x006B, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E35, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E35[2] = {0x006B, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E35, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E35[2] = {0x006B, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E35, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E35 = {.cp = 0x1E35, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E35, .cde = &lxb_unicode_decomposition_c_1E35, .kde = &lxb_unicode_decomposition_k_1E35};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E36[2] = {0x004C, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E36, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E36[2] = {0x004C, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E36, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E36[2] = {0x004C, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E36, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E36 = {.cp = 0x1E36, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E36, .cde = &lxb_unicode_decomposition_c_1E36, .kde = &lxb_unicode_decomposition_k_1E36};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E37[2] = {0x006C, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E37, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E37[2] = {0x006C, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E37, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E37[2] = {0x006C, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E37, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E37 = {.cp = 0x1E37, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E37, .cde = &lxb_unicode_decomposition_c_1E37, .kde = &lxb_unicode_decomposition_k_1E37};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E38[3] = {0x004C, 0x0323, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E38, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E38[3] = {0x004C, 0x0323, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E38, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E38[2] = {0x1E36, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E38, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E38 = {.cp = 0x1E38, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E38, .cde = &lxb_unicode_decomposition_c_1E38, .kde = &lxb_unicode_decomposition_k_1E38};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E39[3] = {0x006C, 0x0323, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E39, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E39[3] = {0x006C, 0x0323, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E39, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E39[2] = {0x1E37, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E39, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E39 = {.cp = 0x1E39, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E39, .cde = &lxb_unicode_decomposition_c_1E39, .kde = &lxb_unicode_decomposition_k_1E39};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E3A[2] = {0x004C, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E3A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E3A[2] = {0x004C, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E3A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E3A[2] = {0x004C, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E3A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E3A = {.cp = 0x1E3A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E3A, .cde = &lxb_unicode_decomposition_c_1E3A, .kde = &lxb_unicode_decomposition_k_1E3A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E3B[2] = {0x006C, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E3B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E3B[2] = {0x006C, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E3B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E3B[2] = {0x006C, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E3B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E3B = {.cp = 0x1E3B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E3B, .cde = &lxb_unicode_decomposition_c_1E3B, .kde = &lxb_unicode_decomposition_k_1E3B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E3C[2] = {0x004C, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E3C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E3C[2] = {0x004C, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E3C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E3C[2] = {0x004C, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E3C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E3C = {.cp = 0x1E3C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E3C, .cde = &lxb_unicode_decomposition_c_1E3C, .kde = &lxb_unicode_decomposition_k_1E3C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E3D[2] = {0x006C, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E3D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E3D[2] = {0x006C, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E3D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E3D[2] = {0x006C, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E3D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E3D = {.cp = 0x1E3D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E3D, .cde = &lxb_unicode_decomposition_c_1E3D, .kde = &lxb_unicode_decomposition_k_1E3D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E3E[2] = {0x004D, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E3E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E3E[2] = {0x004D, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E3E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E3E[2] = {0x004D, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E3E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E3E = {.cp = 0x1E3E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E3E, .cde = &lxb_unicode_decomposition_c_1E3E, .kde = &lxb_unicode_decomposition_k_1E3E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E3F[2] = {0x006D, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E3F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E3F[2] = {0x006D, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E3F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E3F[2] = {0x006D, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E3F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E3F = {.cp = 0x1E3F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E3F, .cde = &lxb_unicode_decomposition_c_1E3F, .kde = &lxb_unicode_decomposition_k_1E3F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E40[2] = {0x004D, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E40, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E40[2] = {0x004D, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E40, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E40[2] = {0x004D, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E40, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E40 = {.cp = 0x1E40, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E40, .cde = &lxb_unicode_decomposition_c_1E40, .kde = &lxb_unicode_decomposition_k_1E40};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E41[2] = {0x006D, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E41, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E41[2] = {0x006D, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E41, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E41[2] = {0x006D, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E41, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E41 = {.cp = 0x1E41, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E41, .cde = &lxb_unicode_decomposition_c_1E41, .kde = &lxb_unicode_decomposition_k_1E41};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E42[2] = {0x004D, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E42, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E42[2] = {0x004D, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E42, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E42[2] = {0x004D, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E42, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E42 = {.cp = 0x1E42, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E42, .cde = &lxb_unicode_decomposition_c_1E42, .kde = &lxb_unicode_decomposition_k_1E42};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E43[2] = {0x006D, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E43, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E43[2] = {0x006D, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E43, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E43[2] = {0x006D, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E43, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E43 = {.cp = 0x1E43, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E43, .cde = &lxb_unicode_decomposition_c_1E43, .kde = &lxb_unicode_decomposition_k_1E43};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E44[2] = {0x004E, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E44, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E44[2] = {0x004E, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E44, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E44[2] = {0x004E, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E44, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E44 = {.cp = 0x1E44, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E44, .cde = &lxb_unicode_decomposition_c_1E44, .kde = &lxb_unicode_decomposition_k_1E44};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E45[2] = {0x006E, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E45, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E45[2] = {0x006E, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E45, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E45[2] = {0x006E, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E45, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E45 = {.cp = 0x1E45, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E45, .cde = &lxb_unicode_decomposition_c_1E45, .kde = &lxb_unicode_decomposition_k_1E45};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E46[2] = {0x004E, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E46, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E46[2] = {0x004E, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E46, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E46[2] = {0x004E, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E46, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E46 = {.cp = 0x1E46, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E46, .cde = &lxb_unicode_decomposition_c_1E46, .kde = &lxb_unicode_decomposition_k_1E46};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E47[2] = {0x006E, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E47, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E47[2] = {0x006E, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E47, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E47[2] = {0x006E, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E47, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E47 = {.cp = 0x1E47, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E47, .cde = &lxb_unicode_decomposition_c_1E47, .kde = &lxb_unicode_decomposition_k_1E47};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E48[2] = {0x004E, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E48[2] = {0x004E, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E48[2] = {0x004E, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E48, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E48 = {.cp = 0x1E48, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E48, .cde = &lxb_unicode_decomposition_c_1E48, .kde = &lxb_unicode_decomposition_k_1E48};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E49[2] = {0x006E, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E49, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E49[2] = {0x006E, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E49, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E49[2] = {0x006E, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E49, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E49 = {.cp = 0x1E49, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E49, .cde = &lxb_unicode_decomposition_c_1E49, .kde = &lxb_unicode_decomposition_k_1E49};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E4A[2] = {0x004E, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E4A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E4A[2] = {0x004E, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E4A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E4A[2] = {0x004E, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E4A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E4A = {.cp = 0x1E4A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E4A, .cde = &lxb_unicode_decomposition_c_1E4A, .kde = &lxb_unicode_decomposition_k_1E4A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E4B[2] = {0x006E, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E4B[2] = {0x006E, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E4B[2] = {0x006E, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E4B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E4B = {.cp = 0x1E4B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E4B, .cde = &lxb_unicode_decomposition_c_1E4B, .kde = &lxb_unicode_decomposition_k_1E4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E4C[3] = {0x004F, 0x0303, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E4C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E4C[3] = {0x004F, 0x0303, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E4C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E4C[2] = {0x00D5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E4C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E4C = {.cp = 0x1E4C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E4C, .cde = &lxb_unicode_decomposition_c_1E4C, .kde = &lxb_unicode_decomposition_k_1E4C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E4D[3] = {0x006F, 0x0303, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E4D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E4D[3] = {0x006F, 0x0303, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E4D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E4D[2] = {0x00F5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E4D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E4D = {.cp = 0x1E4D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E4D, .cde = &lxb_unicode_decomposition_c_1E4D, .kde = &lxb_unicode_decomposition_k_1E4D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E4E[3] = {0x004F, 0x0303, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E4E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E4E[3] = {0x004F, 0x0303, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E4E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E4E[2] = {0x00D5, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E4E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E4E = {.cp = 0x1E4E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E4E, .cde = &lxb_unicode_decomposition_c_1E4E, .kde = &lxb_unicode_decomposition_k_1E4E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E4F[3] = {0x006F, 0x0303, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E4F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E4F[3] = {0x006F, 0x0303, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E4F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E4F[2] = {0x00F5, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E4F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E4F = {.cp = 0x1E4F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E4F, .cde = &lxb_unicode_decomposition_c_1E4F, .kde = &lxb_unicode_decomposition_k_1E4F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E50[3] = {0x004F, 0x0304, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E50, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E50[3] = {0x004F, 0x0304, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E50, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E50[2] = {0x014C, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E50, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E50 = {.cp = 0x1E50, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E50, .cde = &lxb_unicode_decomposition_c_1E50, .kde = &lxb_unicode_decomposition_k_1E50};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E51[3] = {0x006F, 0x0304, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E51, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E51[3] = {0x006F, 0x0304, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E51, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E51[2] = {0x014D, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E51, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E51 = {.cp = 0x1E51, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E51, .cde = &lxb_unicode_decomposition_c_1E51, .kde = &lxb_unicode_decomposition_k_1E51};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E52[3] = {0x004F, 0x0304, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E52, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E52[3] = {0x004F, 0x0304, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E52, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E52[2] = {0x014C, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E52, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E52 = {.cp = 0x1E52, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E52, .cde = &lxb_unicode_decomposition_c_1E52, .kde = &lxb_unicode_decomposition_k_1E52};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E53[3] = {0x006F, 0x0304, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E53, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E53[3] = {0x006F, 0x0304, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E53, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E53[2] = {0x014D, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E53, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E53 = {.cp = 0x1E53, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E53, .cde = &lxb_unicode_decomposition_c_1E53, .kde = &lxb_unicode_decomposition_k_1E53};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E54[2] = {0x0050, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E54, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E54[2] = {0x0050, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E54, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E54[2] = {0x0050, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E54, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E54 = {.cp = 0x1E54, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E54, .cde = &lxb_unicode_decomposition_c_1E54, .kde = &lxb_unicode_decomposition_k_1E54};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E55[2] = {0x0070, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E55, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E55[2] = {0x0070, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E55, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E55[2] = {0x0070, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E55, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E55 = {.cp = 0x1E55, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E55, .cde = &lxb_unicode_decomposition_c_1E55, .kde = &lxb_unicode_decomposition_k_1E55};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E56[2] = {0x0050, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E56, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E56[2] = {0x0050, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E56, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E56[2] = {0x0050, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E56, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E56 = {.cp = 0x1E56, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E56, .cde = &lxb_unicode_decomposition_c_1E56, .kde = &lxb_unicode_decomposition_k_1E56};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E57[2] = {0x0070, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E57, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E57[2] = {0x0070, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E57, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E57[2] = {0x0070, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E57, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E57 = {.cp = 0x1E57, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E57, .cde = &lxb_unicode_decomposition_c_1E57, .kde = &lxb_unicode_decomposition_k_1E57};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E58[2] = {0x0052, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E58, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E58[2] = {0x0052, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E58, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E58[2] = {0x0052, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E58, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E58 = {.cp = 0x1E58, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E58, .cde = &lxb_unicode_decomposition_c_1E58, .kde = &lxb_unicode_decomposition_k_1E58};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E59[2] = {0x0072, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E59, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E59[2] = {0x0072, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E59, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E59[2] = {0x0072, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E59, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E59 = {.cp = 0x1E59, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E59, .cde = &lxb_unicode_decomposition_c_1E59, .kde = &lxb_unicode_decomposition_k_1E59};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E5A[2] = {0x0052, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E5A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E5A[2] = {0x0052, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E5A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E5A[2] = {0x0052, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E5A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E5A = {.cp = 0x1E5A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E5A, .cde = &lxb_unicode_decomposition_c_1E5A, .kde = &lxb_unicode_decomposition_k_1E5A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E5B[2] = {0x0072, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E5B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E5B[2] = {0x0072, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E5B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E5B[2] = {0x0072, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E5B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E5B = {.cp = 0x1E5B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E5B, .cde = &lxb_unicode_decomposition_c_1E5B, .kde = &lxb_unicode_decomposition_k_1E5B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E5C[3] = {0x0052, 0x0323, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E5C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E5C[3] = {0x0052, 0x0323, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E5C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E5C[2] = {0x1E5A, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E5C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E5C = {.cp = 0x1E5C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E5C, .cde = &lxb_unicode_decomposition_c_1E5C, .kde = &lxb_unicode_decomposition_k_1E5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E5D[3] = {0x0072, 0x0323, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E5D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E5D[3] = {0x0072, 0x0323, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E5D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E5D[2] = {0x1E5B, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E5D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E5D = {.cp = 0x1E5D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E5D, .cde = &lxb_unicode_decomposition_c_1E5D, .kde = &lxb_unicode_decomposition_k_1E5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E5E[2] = {0x0052, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E5E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E5E[2] = {0x0052, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E5E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E5E[2] = {0x0052, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E5E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E5E = {.cp = 0x1E5E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E5E, .cde = &lxb_unicode_decomposition_c_1E5E, .kde = &lxb_unicode_decomposition_k_1E5E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E5F[2] = {0x0072, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E5F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E5F[2] = {0x0072, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E5F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E5F[2] = {0x0072, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E5F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E5F = {.cp = 0x1E5F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E5F, .cde = &lxb_unicode_decomposition_c_1E5F, .kde = &lxb_unicode_decomposition_k_1E5F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E60[2] = {0x0053, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E60, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E60[2] = {0x0053, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E60, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E60[2] = {0x0053, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E60, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E60 = {.cp = 0x1E60, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E60, .cde = &lxb_unicode_decomposition_c_1E60, .kde = &lxb_unicode_decomposition_k_1E60};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E61[2] = {0x0073, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E61, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E61[2] = {0x0073, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E61, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E61[2] = {0x0073, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E61, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E61 = {.cp = 0x1E61, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E61, .cde = &lxb_unicode_decomposition_c_1E61, .kde = &lxb_unicode_decomposition_k_1E61};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E62[2] = {0x0053, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E62, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E62[2] = {0x0053, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E62, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E62[2] = {0x0053, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E62, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E62 = {.cp = 0x1E62, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E62, .cde = &lxb_unicode_decomposition_c_1E62, .kde = &lxb_unicode_decomposition_k_1E62};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E63[2] = {0x0073, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E63, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E63[2] = {0x0073, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E63, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E63[2] = {0x0073, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E63, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E63 = {.cp = 0x1E63, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E63, .cde = &lxb_unicode_decomposition_c_1E63, .kde = &lxb_unicode_decomposition_k_1E63};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E64[3] = {0x0053, 0x0301, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E64, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E64[3] = {0x0053, 0x0301, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E64, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E64[2] = {0x015A, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E64, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E64 = {.cp = 0x1E64, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E64, .cde = &lxb_unicode_decomposition_c_1E64, .kde = &lxb_unicode_decomposition_k_1E64};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E65[3] = {0x0073, 0x0301, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E65, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E65[3] = {0x0073, 0x0301, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E65, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E65[2] = {0x015B, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E65, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E65 = {.cp = 0x1E65, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E65, .cde = &lxb_unicode_decomposition_c_1E65, .kde = &lxb_unicode_decomposition_k_1E65};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E66[3] = {0x0053, 0x030C, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E66, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E66[3] = {0x0053, 0x030C, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E66, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E66[2] = {0x0160, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E66, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E66 = {.cp = 0x1E66, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E66, .cde = &lxb_unicode_decomposition_c_1E66, .kde = &lxb_unicode_decomposition_k_1E66};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E67[3] = {0x0073, 0x030C, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E67, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E67[3] = {0x0073, 0x030C, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E67, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E67[2] = {0x0161, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E67, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E67 = {.cp = 0x1E67, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E67, .cde = &lxb_unicode_decomposition_c_1E67, .kde = &lxb_unicode_decomposition_k_1E67};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E68[3] = {0x0053, 0x0323, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E68, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E68[3] = {0x0053, 0x0323, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E68, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E68[2] = {0x1E62, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E68, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E68 = {.cp = 0x1E68, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E68, .cde = &lxb_unicode_decomposition_c_1E68, .kde = &lxb_unicode_decomposition_k_1E68};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E69[3] = {0x0073, 0x0323, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E69, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E69[3] = {0x0073, 0x0323, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E69, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E69[2] = {0x1E63, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E69, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E69 = {.cp = 0x1E69, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E69, .cde = &lxb_unicode_decomposition_c_1E69, .kde = &lxb_unicode_decomposition_k_1E69};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E6A[2] = {0x0054, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E6A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E6A[2] = {0x0054, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E6A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E6A[2] = {0x0054, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E6A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E6A = {.cp = 0x1E6A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E6A, .cde = &lxb_unicode_decomposition_c_1E6A, .kde = &lxb_unicode_decomposition_k_1E6A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E6B[2] = {0x0074, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E6B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E6B[2] = {0x0074, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E6B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E6B[2] = {0x0074, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E6B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E6B = {.cp = 0x1E6B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E6B, .cde = &lxb_unicode_decomposition_c_1E6B, .kde = &lxb_unicode_decomposition_k_1E6B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E6C[2] = {0x0054, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E6C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E6C[2] = {0x0054, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E6C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E6C[2] = {0x0054, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E6C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E6C = {.cp = 0x1E6C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E6C, .cde = &lxb_unicode_decomposition_c_1E6C, .kde = &lxb_unicode_decomposition_k_1E6C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E6D[2] = {0x0074, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E6D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E6D[2] = {0x0074, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E6D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E6D[2] = {0x0074, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E6D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E6D = {.cp = 0x1E6D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E6D, .cde = &lxb_unicode_decomposition_c_1E6D, .kde = &lxb_unicode_decomposition_k_1E6D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E6E[2] = {0x0054, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E6E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E6E[2] = {0x0054, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E6E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E6E[2] = {0x0054, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E6E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E6E = {.cp = 0x1E6E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E6E, .cde = &lxb_unicode_decomposition_c_1E6E, .kde = &lxb_unicode_decomposition_k_1E6E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E6F[2] = {0x0074, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E6F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E6F[2] = {0x0074, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E6F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E6F[2] = {0x0074, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E6F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E6F = {.cp = 0x1E6F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E6F, .cde = &lxb_unicode_decomposition_c_1E6F, .kde = &lxb_unicode_decomposition_k_1E6F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E70[2] = {0x0054, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E70, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E70[2] = {0x0054, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E70, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E70[2] = {0x0054, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E70, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E70 = {.cp = 0x1E70, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E70, .cde = &lxb_unicode_decomposition_c_1E70, .kde = &lxb_unicode_decomposition_k_1E70};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E71[2] = {0x0074, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E71, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E71[2] = {0x0074, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E71, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E71[2] = {0x0074, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E71, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E71 = {.cp = 0x1E71, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E71, .cde = &lxb_unicode_decomposition_c_1E71, .kde = &lxb_unicode_decomposition_k_1E71};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E72[2] = {0x0055, 0x0324};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E72, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E72[2] = {0x0055, 0x0324};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E72, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E72[2] = {0x0055, 0x0324};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E72, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E72 = {.cp = 0x1E72, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E72, .cde = &lxb_unicode_decomposition_c_1E72, .kde = &lxb_unicode_decomposition_k_1E72};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E73[2] = {0x0075, 0x0324};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E73, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E73[2] = {0x0075, 0x0324};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E73, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E73[2] = {0x0075, 0x0324};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E73, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E73 = {.cp = 0x1E73, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E73, .cde = &lxb_unicode_decomposition_c_1E73, .kde = &lxb_unicode_decomposition_k_1E73};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E74[2] = {0x0055, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E74, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E74[2] = {0x0055, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E74, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E74[2] = {0x0055, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E74, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E74 = {.cp = 0x1E74, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E74, .cde = &lxb_unicode_decomposition_c_1E74, .kde = &lxb_unicode_decomposition_k_1E74};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E75[2] = {0x0075, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E75, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E75[2] = {0x0075, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E75, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E75[2] = {0x0075, 0x0330};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E75, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E75 = {.cp = 0x1E75, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E75, .cde = &lxb_unicode_decomposition_c_1E75, .kde = &lxb_unicode_decomposition_k_1E75};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E76[2] = {0x0055, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E76, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E76[2] = {0x0055, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E76, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E76[2] = {0x0055, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E76, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E76 = {.cp = 0x1E76, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E76, .cde = &lxb_unicode_decomposition_c_1E76, .kde = &lxb_unicode_decomposition_k_1E76};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E77[2] = {0x0075, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E77, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E77[2] = {0x0075, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E77, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E77[2] = {0x0075, 0x032D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E77, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E77 = {.cp = 0x1E77, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E77, .cde = &lxb_unicode_decomposition_c_1E77, .kde = &lxb_unicode_decomposition_k_1E77};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E78[3] = {0x0055, 0x0303, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E78, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E78[3] = {0x0055, 0x0303, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E78, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E78[2] = {0x0168, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E78, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E78 = {.cp = 0x1E78, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E78, .cde = &lxb_unicode_decomposition_c_1E78, .kde = &lxb_unicode_decomposition_k_1E78};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E79[3] = {0x0075, 0x0303, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E79, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E79[3] = {0x0075, 0x0303, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E79, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E79[2] = {0x0169, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E79, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E79 = {.cp = 0x1E79, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E79, .cde = &lxb_unicode_decomposition_c_1E79, .kde = &lxb_unicode_decomposition_k_1E79};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E7A[3] = {0x0055, 0x0304, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E7A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E7A[3] = {0x0055, 0x0304, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E7A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E7A[2] = {0x016A, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E7A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E7A = {.cp = 0x1E7A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E7A, .cde = &lxb_unicode_decomposition_c_1E7A, .kde = &lxb_unicode_decomposition_k_1E7A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E7B[3] = {0x0075, 0x0304, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E7B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E7B[3] = {0x0075, 0x0304, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E7B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E7B[2] = {0x016B, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E7B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E7B = {.cp = 0x1E7B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E7B, .cde = &lxb_unicode_decomposition_c_1E7B, .kde = &lxb_unicode_decomposition_k_1E7B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E7C[2] = {0x0056, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E7C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E7C[2] = {0x0056, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E7C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E7C[2] = {0x0056, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E7C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E7C = {.cp = 0x1E7C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E7C, .cde = &lxb_unicode_decomposition_c_1E7C, .kde = &lxb_unicode_decomposition_k_1E7C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E7D[2] = {0x0076, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E7D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E7D[2] = {0x0076, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E7D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E7D[2] = {0x0076, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E7D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E7D = {.cp = 0x1E7D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E7D, .cde = &lxb_unicode_decomposition_c_1E7D, .kde = &lxb_unicode_decomposition_k_1E7D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E7E[2] = {0x0056, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E7E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E7E[2] = {0x0056, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E7E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E7E[2] = {0x0056, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E7E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E7E = {.cp = 0x1E7E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E7E, .cde = &lxb_unicode_decomposition_c_1E7E, .kde = &lxb_unicode_decomposition_k_1E7E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E7F[2] = {0x0076, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E7F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E7F[2] = {0x0076, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E7F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E7F[2] = {0x0076, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E7F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E7F = {.cp = 0x1E7F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E7F, .cde = &lxb_unicode_decomposition_c_1E7F, .kde = &lxb_unicode_decomposition_k_1E7F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E80[2] = {0x0057, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E80, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E80[2] = {0x0057, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E80, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E80[2] = {0x0057, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E80, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E80 = {.cp = 0x1E80, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E80, .cde = &lxb_unicode_decomposition_c_1E80, .kde = &lxb_unicode_decomposition_k_1E80};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E81[2] = {0x0077, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E81, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E81[2] = {0x0077, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E81, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E81[2] = {0x0077, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E81, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E81 = {.cp = 0x1E81, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E81, .cde = &lxb_unicode_decomposition_c_1E81, .kde = &lxb_unicode_decomposition_k_1E81};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E82[2] = {0x0057, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E82, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E82[2] = {0x0057, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E82, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E82[2] = {0x0057, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E82, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E82 = {.cp = 0x1E82, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E82, .cde = &lxb_unicode_decomposition_c_1E82, .kde = &lxb_unicode_decomposition_k_1E82};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E83[2] = {0x0077, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E83, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E83[2] = {0x0077, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E83, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E83[2] = {0x0077, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E83, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E83 = {.cp = 0x1E83, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E83, .cde = &lxb_unicode_decomposition_c_1E83, .kde = &lxb_unicode_decomposition_k_1E83};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E84[2] = {0x0057, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E84, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E84[2] = {0x0057, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E84, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E84[2] = {0x0057, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E84, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E84 = {.cp = 0x1E84, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E84, .cde = &lxb_unicode_decomposition_c_1E84, .kde = &lxb_unicode_decomposition_k_1E84};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E85[2] = {0x0077, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E85, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E85[2] = {0x0077, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E85, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E85[2] = {0x0077, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E85, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E85 = {.cp = 0x1E85, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E85, .cde = &lxb_unicode_decomposition_c_1E85, .kde = &lxb_unicode_decomposition_k_1E85};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E86[2] = {0x0057, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E86, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E86[2] = {0x0057, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E86, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E86[2] = {0x0057, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E86, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E86 = {.cp = 0x1E86, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E86, .cde = &lxb_unicode_decomposition_c_1E86, .kde = &lxb_unicode_decomposition_k_1E86};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E87[2] = {0x0077, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E87, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E87[2] = {0x0077, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E87, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E87[2] = {0x0077, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E87, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E87 = {.cp = 0x1E87, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E87, .cde = &lxb_unicode_decomposition_c_1E87, .kde = &lxb_unicode_decomposition_k_1E87};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E88[2] = {0x0057, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E88, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E88[2] = {0x0057, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E88, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E88[2] = {0x0057, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E88, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E88 = {.cp = 0x1E88, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E88, .cde = &lxb_unicode_decomposition_c_1E88, .kde = &lxb_unicode_decomposition_k_1E88};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E89[2] = {0x0077, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E89, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E89[2] = {0x0077, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E89, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E89[2] = {0x0077, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E89, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E89 = {.cp = 0x1E89, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E89, .cde = &lxb_unicode_decomposition_c_1E89, .kde = &lxb_unicode_decomposition_k_1E89};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E8A[2] = {0x0058, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E8A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E8A[2] = {0x0058, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E8A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E8A[2] = {0x0058, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E8A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E8A = {.cp = 0x1E8A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E8A, .cde = &lxb_unicode_decomposition_c_1E8A, .kde = &lxb_unicode_decomposition_k_1E8A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E8B[2] = {0x0078, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E8B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E8B[2] = {0x0078, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E8B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E8B[2] = {0x0078, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E8B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E8B = {.cp = 0x1E8B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E8B, .cde = &lxb_unicode_decomposition_c_1E8B, .kde = &lxb_unicode_decomposition_k_1E8B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E8C[2] = {0x0058, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E8C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E8C[2] = {0x0058, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E8C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E8C[2] = {0x0058, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E8C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E8C = {.cp = 0x1E8C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E8C, .cde = &lxb_unicode_decomposition_c_1E8C, .kde = &lxb_unicode_decomposition_k_1E8C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E8D[2] = {0x0078, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E8D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E8D[2] = {0x0078, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E8D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E8D[2] = {0x0078, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E8D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E8D = {.cp = 0x1E8D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E8D, .cde = &lxb_unicode_decomposition_c_1E8D, .kde = &lxb_unicode_decomposition_k_1E8D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E8E[2] = {0x0059, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E8E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E8E[2] = {0x0059, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E8E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E8E[2] = {0x0059, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E8E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E8E = {.cp = 0x1E8E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E8E, .cde = &lxb_unicode_decomposition_c_1E8E, .kde = &lxb_unicode_decomposition_k_1E8E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E8F[2] = {0x0079, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E8F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E8F[2] = {0x0079, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E8F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E8F[2] = {0x0079, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E8F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E8F = {.cp = 0x1E8F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E8F, .cde = &lxb_unicode_decomposition_c_1E8F, .kde = &lxb_unicode_decomposition_k_1E8F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E90[2] = {0x005A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E90, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E90[2] = {0x005A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E90, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E90[2] = {0x005A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E90, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E90 = {.cp = 0x1E90, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E90, .cde = &lxb_unicode_decomposition_c_1E90, .kde = &lxb_unicode_decomposition_k_1E90};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E91[2] = {0x007A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E91, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E91[2] = {0x007A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E91, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E91[2] = {0x007A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E91, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E91 = {.cp = 0x1E91, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E91, .cde = &lxb_unicode_decomposition_c_1E91, .kde = &lxb_unicode_decomposition_k_1E91};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E92[2] = {0x005A, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E92, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E92[2] = {0x005A, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E92, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E92[2] = {0x005A, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E92, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E92 = {.cp = 0x1E92, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E92, .cde = &lxb_unicode_decomposition_c_1E92, .kde = &lxb_unicode_decomposition_k_1E92};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E93[2] = {0x007A, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E93, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E93[2] = {0x007A, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E93, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E93[2] = {0x007A, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E93, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E93 = {.cp = 0x1E93, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E93, .cde = &lxb_unicode_decomposition_c_1E93, .kde = &lxb_unicode_decomposition_k_1E93};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E94[2] = {0x005A, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E94, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E94[2] = {0x005A, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E94, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E94[2] = {0x005A, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E94, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E94 = {.cp = 0x1E94, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E94, .cde = &lxb_unicode_decomposition_c_1E94, .kde = &lxb_unicode_decomposition_k_1E94};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E95[2] = {0x007A, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E95, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E95[2] = {0x007A, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E95, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E95[2] = {0x007A, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E95, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E95 = {.cp = 0x1E95, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E95, .cde = &lxb_unicode_decomposition_c_1E95, .kde = &lxb_unicode_decomposition_k_1E95};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E96[2] = {0x0068, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E96, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E96[2] = {0x0068, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E96, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E96[2] = {0x0068, 0x0331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E96, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E96 = {.cp = 0x1E96, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E96, .cde = &lxb_unicode_decomposition_c_1E96, .kde = &lxb_unicode_decomposition_k_1E96};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E97[2] = {0x0074, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E97, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E97[2] = {0x0074, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E97, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E97[2] = {0x0074, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E97, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E97 = {.cp = 0x1E97, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E97, .cde = &lxb_unicode_decomposition_c_1E97, .kde = &lxb_unicode_decomposition_k_1E97};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E98[2] = {0x0077, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E98, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E98[2] = {0x0077, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E98, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E98[2] = {0x0077, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E98, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E98 = {.cp = 0x1E98, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E98, .cde = &lxb_unicode_decomposition_c_1E98, .kde = &lxb_unicode_decomposition_k_1E98};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E99[2] = {0x0079, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E99, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E99[2] = {0x0079, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E99, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E99[2] = {0x0079, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E99, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E99 = {.cp = 0x1E99, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E99, .cde = &lxb_unicode_decomposition_c_1E99, .kde = &lxb_unicode_decomposition_k_1E99};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E9A[2] = {0x0061, 0x02BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_1E9A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E9A[2] = {0x0061, 0x02BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_1E9A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E9A[2] = {0x0061, 0x02BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__1E9A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E9A = {.cp = 0x1E9A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E9A, .cde = &lxb_unicode_decomposition_c_1E9A, .kde = &lxb_unicode_decomposition_k_1E9A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1E9B[2] = {0x017F, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1E9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1E9B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1E9B[2] = {0x0073, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1E9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1E9B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1E9B[2] = {0x017F, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1E9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1E9B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1E9B = {.cp = 0x1E9B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1E9B, .cde = &lxb_unicode_decomposition_c_1E9B, .kde = &lxb_unicode_decomposition_k_1E9B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EA0[2] = {0x0041, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EA0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EA0[2] = {0x0041, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EA0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EA0[2] = {0x0041, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EA0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EA0 = {.cp = 0x1EA0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EA0, .cde = &lxb_unicode_decomposition_c_1EA0, .kde = &lxb_unicode_decomposition_k_1EA0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EA1[2] = {0x0061, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EA1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EA1[2] = {0x0061, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EA1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EA1[2] = {0x0061, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EA1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EA1 = {.cp = 0x1EA1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EA1, .cde = &lxb_unicode_decomposition_c_1EA1, .kde = &lxb_unicode_decomposition_k_1EA1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EA2[2] = {0x0041, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EA2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EA2[2] = {0x0041, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EA2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EA2[2] = {0x0041, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EA2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EA2 = {.cp = 0x1EA2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EA2, .cde = &lxb_unicode_decomposition_c_1EA2, .kde = &lxb_unicode_decomposition_k_1EA2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EA3[2] = {0x0061, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EA3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EA3[2] = {0x0061, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EA3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EA3[2] = {0x0061, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EA3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EA3 = {.cp = 0x1EA3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EA3, .cde = &lxb_unicode_decomposition_c_1EA3, .kde = &lxb_unicode_decomposition_k_1EA3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EA4[3] = {0x0041, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EA4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EA4[3] = {0x0041, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EA4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EA4[2] = {0x00C2, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EA4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EA4 = {.cp = 0x1EA4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EA4, .cde = &lxb_unicode_decomposition_c_1EA4, .kde = &lxb_unicode_decomposition_k_1EA4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EA5[3] = {0x0061, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EA5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EA5[3] = {0x0061, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EA5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EA5[2] = {0x00E2, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EA5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EA5 = {.cp = 0x1EA5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EA5, .cde = &lxb_unicode_decomposition_c_1EA5, .kde = &lxb_unicode_decomposition_k_1EA5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EA6[3] = {0x0041, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EA6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EA6[3] = {0x0041, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EA6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EA6[2] = {0x00C2, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EA6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EA6 = {.cp = 0x1EA6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EA6, .cde = &lxb_unicode_decomposition_c_1EA6, .kde = &lxb_unicode_decomposition_k_1EA6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EA7[3] = {0x0061, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EA7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EA7[3] = {0x0061, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EA7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EA7[2] = {0x00E2, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EA7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EA7 = {.cp = 0x1EA7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EA7, .cde = &lxb_unicode_decomposition_c_1EA7, .kde = &lxb_unicode_decomposition_k_1EA7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EA8[3] = {0x0041, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EA8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EA8[3] = {0x0041, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EA8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EA8[2] = {0x00C2, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EA8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EA8 = {.cp = 0x1EA8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EA8, .cde = &lxb_unicode_decomposition_c_1EA8, .kde = &lxb_unicode_decomposition_k_1EA8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EA9[3] = {0x0061, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EA9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EA9[3] = {0x0061, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EA9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EA9[2] = {0x00E2, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EA9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EA9 = {.cp = 0x1EA9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EA9, .cde = &lxb_unicode_decomposition_c_1EA9, .kde = &lxb_unicode_decomposition_k_1EA9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EAA[3] = {0x0041, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EAA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EAA[3] = {0x0041, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EAA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EAA[2] = {0x00C2, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EAA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EAA = {.cp = 0x1EAA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EAA, .cde = &lxb_unicode_decomposition_c_1EAA, .kde = &lxb_unicode_decomposition_k_1EAA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EAB[3] = {0x0061, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EAB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EAB[3] = {0x0061, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EAB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EAB[2] = {0x00E2, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EAB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EAB = {.cp = 0x1EAB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EAB, .cde = &lxb_unicode_decomposition_c_1EAB, .kde = &lxb_unicode_decomposition_k_1EAB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EAC[3] = {0x0041, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EAC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EAC[3] = {0x0041, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EAC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EAC[2] = {0x1EA0, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EAC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EAC = {.cp = 0x1EAC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EAC, .cde = &lxb_unicode_decomposition_c_1EAC, .kde = &lxb_unicode_decomposition_k_1EAC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EAD[3] = {0x0061, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EAD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EAD[3] = {0x0061, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EAD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EAD[2] = {0x1EA1, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EAD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EAD = {.cp = 0x1EAD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EAD, .cde = &lxb_unicode_decomposition_c_1EAD, .kde = &lxb_unicode_decomposition_k_1EAD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EAE[3] = {0x0041, 0x0306, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EAE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EAE[3] = {0x0041, 0x0306, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EAE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EAE[2] = {0x0102, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EAE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EAE = {.cp = 0x1EAE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EAE, .cde = &lxb_unicode_decomposition_c_1EAE, .kde = &lxb_unicode_decomposition_k_1EAE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EAF[3] = {0x0061, 0x0306, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EAF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EAF[3] = {0x0061, 0x0306, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EAF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EAF[2] = {0x0103, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EAF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EAF = {.cp = 0x1EAF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EAF, .cde = &lxb_unicode_decomposition_c_1EAF, .kde = &lxb_unicode_decomposition_k_1EAF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EB0[3] = {0x0041, 0x0306, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EB0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EB0[3] = {0x0041, 0x0306, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EB0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EB0[2] = {0x0102, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EB0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EB0 = {.cp = 0x1EB0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EB0, .cde = &lxb_unicode_decomposition_c_1EB0, .kde = &lxb_unicode_decomposition_k_1EB0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EB1[3] = {0x0061, 0x0306, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EB1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EB1[3] = {0x0061, 0x0306, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EB1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EB1[2] = {0x0103, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EB1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EB1 = {.cp = 0x1EB1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EB1, .cde = &lxb_unicode_decomposition_c_1EB1, .kde = &lxb_unicode_decomposition_k_1EB1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EB2[3] = {0x0041, 0x0306, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EB2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EB2[3] = {0x0041, 0x0306, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EB2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EB2[2] = {0x0102, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EB2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EB2 = {.cp = 0x1EB2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EB2, .cde = &lxb_unicode_decomposition_c_1EB2, .kde = &lxb_unicode_decomposition_k_1EB2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EB3[3] = {0x0061, 0x0306, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EB3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EB3[3] = {0x0061, 0x0306, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EB3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EB3[2] = {0x0103, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EB3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EB3 = {.cp = 0x1EB3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EB3, .cde = &lxb_unicode_decomposition_c_1EB3, .kde = &lxb_unicode_decomposition_k_1EB3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EB4[3] = {0x0041, 0x0306, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EB4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EB4[3] = {0x0041, 0x0306, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EB4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EB4[2] = {0x0102, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EB4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EB4 = {.cp = 0x1EB4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EB4, .cde = &lxb_unicode_decomposition_c_1EB4, .kde = &lxb_unicode_decomposition_k_1EB4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EB5[3] = {0x0061, 0x0306, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EB5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EB5[3] = {0x0061, 0x0306, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EB5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EB5[2] = {0x0103, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EB5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EB5 = {.cp = 0x1EB5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EB5, .cde = &lxb_unicode_decomposition_c_1EB5, .kde = &lxb_unicode_decomposition_k_1EB5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EB6[3] = {0x0041, 0x0323, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EB6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EB6[3] = {0x0041, 0x0323, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EB6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EB6[2] = {0x1EA0, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EB6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EB6 = {.cp = 0x1EB6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EB6, .cde = &lxb_unicode_decomposition_c_1EB6, .kde = &lxb_unicode_decomposition_k_1EB6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EB7[3] = {0x0061, 0x0323, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EB7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EB7[3] = {0x0061, 0x0323, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EB7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EB7[2] = {0x1EA1, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EB7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EB7 = {.cp = 0x1EB7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EB7, .cde = &lxb_unicode_decomposition_c_1EB7, .kde = &lxb_unicode_decomposition_k_1EB7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EB8[2] = {0x0045, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EB8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EB8[2] = {0x0045, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EB8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EB8[2] = {0x0045, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EB8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EB8 = {.cp = 0x1EB8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EB8, .cde = &lxb_unicode_decomposition_c_1EB8, .kde = &lxb_unicode_decomposition_k_1EB8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EB9[2] = {0x0065, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EB9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EB9[2] = {0x0065, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EB9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EB9[2] = {0x0065, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EB9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EB9 = {.cp = 0x1EB9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EB9, .cde = &lxb_unicode_decomposition_c_1EB9, .kde = &lxb_unicode_decomposition_k_1EB9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EBA[2] = {0x0045, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EBA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EBA[2] = {0x0045, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EBA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EBA[2] = {0x0045, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EBA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EBA = {.cp = 0x1EBA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EBA, .cde = &lxb_unicode_decomposition_c_1EBA, .kde = &lxb_unicode_decomposition_k_1EBA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EBB[2] = {0x0065, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EBB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EBB[2] = {0x0065, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EBB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EBB[2] = {0x0065, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EBB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EBB = {.cp = 0x1EBB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EBB, .cde = &lxb_unicode_decomposition_c_1EBB, .kde = &lxb_unicode_decomposition_k_1EBB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EBC[2] = {0x0045, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EBC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EBC[2] = {0x0045, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EBC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EBC[2] = {0x0045, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EBC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EBC = {.cp = 0x1EBC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EBC, .cde = &lxb_unicode_decomposition_c_1EBC, .kde = &lxb_unicode_decomposition_k_1EBC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EBD[2] = {0x0065, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EBD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EBD[2] = {0x0065, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EBD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EBD[2] = {0x0065, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EBD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EBD = {.cp = 0x1EBD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EBD, .cde = &lxb_unicode_decomposition_c_1EBD, .kde = &lxb_unicode_decomposition_k_1EBD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EBE[3] = {0x0045, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EBE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EBE[3] = {0x0045, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EBE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EBE[2] = {0x00CA, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EBE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EBE = {.cp = 0x1EBE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EBE, .cde = &lxb_unicode_decomposition_c_1EBE, .kde = &lxb_unicode_decomposition_k_1EBE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EBF[3] = {0x0065, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EBF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EBF[3] = {0x0065, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EBF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EBF[2] = {0x00EA, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EBF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EBF = {.cp = 0x1EBF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EBF, .cde = &lxb_unicode_decomposition_c_1EBF, .kde = &lxb_unicode_decomposition_k_1EBF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EC0[3] = {0x0045, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EC0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EC0[3] = {0x0045, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EC0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EC0[2] = {0x00CA, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EC0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EC0 = {.cp = 0x1EC0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EC0, .cde = &lxb_unicode_decomposition_c_1EC0, .kde = &lxb_unicode_decomposition_k_1EC0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EC1[3] = {0x0065, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EC1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EC1[3] = {0x0065, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EC1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EC1[2] = {0x00EA, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EC1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EC1 = {.cp = 0x1EC1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EC1, .cde = &lxb_unicode_decomposition_c_1EC1, .kde = &lxb_unicode_decomposition_k_1EC1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EC2[3] = {0x0045, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EC2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EC2[3] = {0x0045, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EC2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EC2[2] = {0x00CA, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EC2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EC2 = {.cp = 0x1EC2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EC2, .cde = &lxb_unicode_decomposition_c_1EC2, .kde = &lxb_unicode_decomposition_k_1EC2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EC3[3] = {0x0065, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EC3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EC3[3] = {0x0065, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EC3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EC3[2] = {0x00EA, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EC3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EC3 = {.cp = 0x1EC3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EC3, .cde = &lxb_unicode_decomposition_c_1EC3, .kde = &lxb_unicode_decomposition_k_1EC3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EC4[3] = {0x0045, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EC4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EC4[3] = {0x0045, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EC4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EC4[2] = {0x00CA, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EC4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EC4 = {.cp = 0x1EC4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EC4, .cde = &lxb_unicode_decomposition_c_1EC4, .kde = &lxb_unicode_decomposition_k_1EC4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EC5[3] = {0x0065, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EC5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EC5[3] = {0x0065, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EC5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EC5[2] = {0x00EA, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EC5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EC5 = {.cp = 0x1EC5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EC5, .cde = &lxb_unicode_decomposition_c_1EC5, .kde = &lxb_unicode_decomposition_k_1EC5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EC6[3] = {0x0045, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EC6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EC6[3] = {0x0045, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EC6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EC6[2] = {0x1EB8, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EC6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EC6 = {.cp = 0x1EC6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EC6, .cde = &lxb_unicode_decomposition_c_1EC6, .kde = &lxb_unicode_decomposition_k_1EC6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EC7[3] = {0x0065, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EC7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EC7[3] = {0x0065, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EC7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EC7[2] = {0x1EB9, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EC7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EC7 = {.cp = 0x1EC7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EC7, .cde = &lxb_unicode_decomposition_c_1EC7, .kde = &lxb_unicode_decomposition_k_1EC7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EC8[2] = {0x0049, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EC8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EC8[2] = {0x0049, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EC8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EC8[2] = {0x0049, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EC8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EC8 = {.cp = 0x1EC8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EC8, .cde = &lxb_unicode_decomposition_c_1EC8, .kde = &lxb_unicode_decomposition_k_1EC8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EC9[2] = {0x0069, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EC9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EC9[2] = {0x0069, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EC9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EC9[2] = {0x0069, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EC9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EC9 = {.cp = 0x1EC9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EC9, .cde = &lxb_unicode_decomposition_c_1EC9, .kde = &lxb_unicode_decomposition_k_1EC9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ECA[2] = {0x0049, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ECA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ECA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ECA[2] = {0x0049, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ECA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ECA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ECA[2] = {0x0049, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ECA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ECA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ECA = {.cp = 0x1ECA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ECA, .cde = &lxb_unicode_decomposition_c_1ECA, .kde = &lxb_unicode_decomposition_k_1ECA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ECB[2] = {0x0069, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ECB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ECB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ECB[2] = {0x0069, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ECB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ECB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ECB[2] = {0x0069, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ECB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ECB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ECB = {.cp = 0x1ECB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ECB, .cde = &lxb_unicode_decomposition_c_1ECB, .kde = &lxb_unicode_decomposition_k_1ECB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ECC[2] = {0x004F, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ECC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ECC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ECC[2] = {0x004F, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ECC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ECC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ECC[2] = {0x004F, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ECC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ECC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ECC = {.cp = 0x1ECC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ECC, .cde = &lxb_unicode_decomposition_c_1ECC, .kde = &lxb_unicode_decomposition_k_1ECC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ECD[2] = {0x006F, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ECD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ECD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ECD[2] = {0x006F, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ECD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ECD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ECD[2] = {0x006F, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ECD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ECD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ECD = {.cp = 0x1ECD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ECD, .cde = &lxb_unicode_decomposition_c_1ECD, .kde = &lxb_unicode_decomposition_k_1ECD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ECE[2] = {0x004F, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ECE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ECE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ECE[2] = {0x004F, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ECE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ECE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ECE[2] = {0x004F, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ECE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ECE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ECE = {.cp = 0x1ECE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ECE, .cde = &lxb_unicode_decomposition_c_1ECE, .kde = &lxb_unicode_decomposition_k_1ECE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ECF[2] = {0x006F, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ECF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ECF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ECF[2] = {0x006F, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ECF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ECF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ECF[2] = {0x006F, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ECF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ECF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ECF = {.cp = 0x1ECF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ECF, .cde = &lxb_unicode_decomposition_c_1ECF, .kde = &lxb_unicode_decomposition_k_1ECF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ED0[3] = {0x004F, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ED0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ED0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ED0[3] = {0x004F, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ED0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ED0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ED0[2] = {0x00D4, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ED0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ED0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ED0 = {.cp = 0x1ED0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ED0, .cde = &lxb_unicode_decomposition_c_1ED0, .kde = &lxb_unicode_decomposition_k_1ED0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ED1[3] = {0x006F, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ED1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ED1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ED1[3] = {0x006F, 0x0302, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ED1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ED1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ED1[2] = {0x00F4, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ED1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ED1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ED1 = {.cp = 0x1ED1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ED1, .cde = &lxb_unicode_decomposition_c_1ED1, .kde = &lxb_unicode_decomposition_k_1ED1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ED2[3] = {0x004F, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ED2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ED2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ED2[3] = {0x004F, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ED2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ED2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ED2[2] = {0x00D4, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ED2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ED2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ED2 = {.cp = 0x1ED2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ED2, .cde = &lxb_unicode_decomposition_c_1ED2, .kde = &lxb_unicode_decomposition_k_1ED2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ED3[3] = {0x006F, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ED3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ED3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ED3[3] = {0x006F, 0x0302, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ED3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ED3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ED3[2] = {0x00F4, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ED3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ED3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ED3 = {.cp = 0x1ED3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ED3, .cde = &lxb_unicode_decomposition_c_1ED3, .kde = &lxb_unicode_decomposition_k_1ED3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ED4[3] = {0x004F, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ED4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ED4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ED4[3] = {0x004F, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ED4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ED4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ED4[2] = {0x00D4, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ED4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ED4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ED4 = {.cp = 0x1ED4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ED4, .cde = &lxb_unicode_decomposition_c_1ED4, .kde = &lxb_unicode_decomposition_k_1ED4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ED5[3] = {0x006F, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ED5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ED5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ED5[3] = {0x006F, 0x0302, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ED5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ED5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ED5[2] = {0x00F4, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ED5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ED5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ED5 = {.cp = 0x1ED5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ED5, .cde = &lxb_unicode_decomposition_c_1ED5, .kde = &lxb_unicode_decomposition_k_1ED5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ED6[3] = {0x004F, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ED6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ED6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ED6[3] = {0x004F, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ED6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ED6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ED6[2] = {0x00D4, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ED6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ED6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ED6 = {.cp = 0x1ED6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ED6, .cde = &lxb_unicode_decomposition_c_1ED6, .kde = &lxb_unicode_decomposition_k_1ED6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ED7[3] = {0x006F, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ED7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ED7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ED7[3] = {0x006F, 0x0302, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ED7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ED7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ED7[2] = {0x00F4, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ED7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ED7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ED7 = {.cp = 0x1ED7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ED7, .cde = &lxb_unicode_decomposition_c_1ED7, .kde = &lxb_unicode_decomposition_k_1ED7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ED8[3] = {0x004F, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ED8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ED8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ED8[3] = {0x004F, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ED8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ED8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ED8[2] = {0x1ECC, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ED8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ED8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ED8 = {.cp = 0x1ED8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ED8, .cde = &lxb_unicode_decomposition_c_1ED8, .kde = &lxb_unicode_decomposition_k_1ED8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1ED9[3] = {0x006F, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1ED9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1ED9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1ED9[3] = {0x006F, 0x0323, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1ED9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1ED9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1ED9[2] = {0x1ECD, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1ED9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1ED9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1ED9 = {.cp = 0x1ED9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1ED9, .cde = &lxb_unicode_decomposition_c_1ED9, .kde = &lxb_unicode_decomposition_k_1ED9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EDA[3] = {0x004F, 0x031B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EDA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EDA[3] = {0x004F, 0x031B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EDA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EDA[2] = {0x01A0, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EDA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EDA = {.cp = 0x1EDA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EDA, .cde = &lxb_unicode_decomposition_c_1EDA, .kde = &lxb_unicode_decomposition_k_1EDA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EDB[3] = {0x006F, 0x031B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EDB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EDB[3] = {0x006F, 0x031B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EDB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EDB[2] = {0x01A1, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EDB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EDB = {.cp = 0x1EDB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EDB, .cde = &lxb_unicode_decomposition_c_1EDB, .kde = &lxb_unicode_decomposition_k_1EDB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EDC[3] = {0x004F, 0x031B, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EDC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EDC[3] = {0x004F, 0x031B, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EDC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EDC[2] = {0x01A0, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EDC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EDC = {.cp = 0x1EDC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EDC, .cde = &lxb_unicode_decomposition_c_1EDC, .kde = &lxb_unicode_decomposition_k_1EDC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EDD[3] = {0x006F, 0x031B, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EDD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EDD[3] = {0x006F, 0x031B, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EDD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EDD[2] = {0x01A1, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EDD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EDD = {.cp = 0x1EDD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EDD, .cde = &lxb_unicode_decomposition_c_1EDD, .kde = &lxb_unicode_decomposition_k_1EDD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EDE[3] = {0x004F, 0x031B, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EDE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EDE[3] = {0x004F, 0x031B, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EDE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EDE[2] = {0x01A0, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EDE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EDE = {.cp = 0x1EDE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EDE, .cde = &lxb_unicode_decomposition_c_1EDE, .kde = &lxb_unicode_decomposition_k_1EDE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EDF[3] = {0x006F, 0x031B, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EDF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EDF[3] = {0x006F, 0x031B, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EDF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EDF[2] = {0x01A1, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EDF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EDF = {.cp = 0x1EDF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EDF, .cde = &lxb_unicode_decomposition_c_1EDF, .kde = &lxb_unicode_decomposition_k_1EDF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EE0[3] = {0x004F, 0x031B, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EE0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EE0[3] = {0x004F, 0x031B, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EE0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EE0[2] = {0x01A0, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EE0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EE0 = {.cp = 0x1EE0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EE0, .cde = &lxb_unicode_decomposition_c_1EE0, .kde = &lxb_unicode_decomposition_k_1EE0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EE1[3] = {0x006F, 0x031B, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EE1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EE1[3] = {0x006F, 0x031B, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EE1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EE1[2] = {0x01A1, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EE1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EE1 = {.cp = 0x1EE1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EE1, .cde = &lxb_unicode_decomposition_c_1EE1, .kde = &lxb_unicode_decomposition_k_1EE1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EE2[3] = {0x004F, 0x031B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EE2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EE2[3] = {0x004F, 0x031B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EE2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EE2[2] = {0x01A0, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EE2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EE2 = {.cp = 0x1EE2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EE2, .cde = &lxb_unicode_decomposition_c_1EE2, .kde = &lxb_unicode_decomposition_k_1EE2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EE3[3] = {0x006F, 0x031B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EE3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EE3[3] = {0x006F, 0x031B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EE3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EE3[2] = {0x01A1, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EE3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EE3 = {.cp = 0x1EE3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EE3, .cde = &lxb_unicode_decomposition_c_1EE3, .kde = &lxb_unicode_decomposition_k_1EE3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EE4[2] = {0x0055, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EE4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EE4[2] = {0x0055, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EE4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EE4[2] = {0x0055, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EE4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EE4 = {.cp = 0x1EE4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EE4, .cde = &lxb_unicode_decomposition_c_1EE4, .kde = &lxb_unicode_decomposition_k_1EE4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EE5[2] = {0x0075, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EE5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EE5[2] = {0x0075, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EE5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EE5[2] = {0x0075, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EE5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EE5 = {.cp = 0x1EE5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EE5, .cde = &lxb_unicode_decomposition_c_1EE5, .kde = &lxb_unicode_decomposition_k_1EE5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EE6[2] = {0x0055, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EE6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EE6[2] = {0x0055, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EE6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EE6[2] = {0x0055, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EE6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EE6 = {.cp = 0x1EE6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EE6, .cde = &lxb_unicode_decomposition_c_1EE6, .kde = &lxb_unicode_decomposition_k_1EE6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EE7[2] = {0x0075, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EE7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EE7[2] = {0x0075, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EE7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EE7[2] = {0x0075, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EE7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EE7 = {.cp = 0x1EE7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EE7, .cde = &lxb_unicode_decomposition_c_1EE7, .kde = &lxb_unicode_decomposition_k_1EE7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EE8[3] = {0x0055, 0x031B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EE8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EE8[3] = {0x0055, 0x031B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EE8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EE8[2] = {0x01AF, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EE8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EE8 = {.cp = 0x1EE8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EE8, .cde = &lxb_unicode_decomposition_c_1EE8, .kde = &lxb_unicode_decomposition_k_1EE8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EE9[3] = {0x0075, 0x031B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EE9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EE9[3] = {0x0075, 0x031B, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EE9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EE9[2] = {0x01B0, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EE9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EE9 = {.cp = 0x1EE9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EE9, .cde = &lxb_unicode_decomposition_c_1EE9, .kde = &lxb_unicode_decomposition_k_1EE9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EEA[3] = {0x0055, 0x031B, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EEA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EEA[3] = {0x0055, 0x031B, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EEA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EEA[2] = {0x01AF, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EEA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EEA = {.cp = 0x1EEA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EEA, .cde = &lxb_unicode_decomposition_c_1EEA, .kde = &lxb_unicode_decomposition_k_1EEA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EEB[3] = {0x0075, 0x031B, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EEB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EEB[3] = {0x0075, 0x031B, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EEB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EEB[2] = {0x01B0, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EEB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EEB = {.cp = 0x1EEB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EEB, .cde = &lxb_unicode_decomposition_c_1EEB, .kde = &lxb_unicode_decomposition_k_1EEB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EEC[3] = {0x0055, 0x031B, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EEC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EEC[3] = {0x0055, 0x031B, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EEC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EEC[2] = {0x01AF, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EEC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EEC = {.cp = 0x1EEC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EEC, .cde = &lxb_unicode_decomposition_c_1EEC, .kde = &lxb_unicode_decomposition_k_1EEC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EED[3] = {0x0075, 0x031B, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EED, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EED[3] = {0x0075, 0x031B, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EED, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EED[2] = {0x01B0, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EED, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EED = {.cp = 0x1EED, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EED, .cde = &lxb_unicode_decomposition_c_1EED, .kde = &lxb_unicode_decomposition_k_1EED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EEE[3] = {0x0055, 0x031B, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EEE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EEE[3] = {0x0055, 0x031B, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EEE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EEE[2] = {0x01AF, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EEE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EEE = {.cp = 0x1EEE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EEE, .cde = &lxb_unicode_decomposition_c_1EEE, .kde = &lxb_unicode_decomposition_k_1EEE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EEF[3] = {0x0075, 0x031B, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EEF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EEF[3] = {0x0075, 0x031B, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EEF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EEF[2] = {0x01B0, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EEF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EEF = {.cp = 0x1EEF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EEF, .cde = &lxb_unicode_decomposition_c_1EEF, .kde = &lxb_unicode_decomposition_k_1EEF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EF0[3] = {0x0055, 0x031B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EF0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EF0[3] = {0x0055, 0x031B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EF0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EF0[2] = {0x01AF, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EF0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EF0 = {.cp = 0x1EF0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EF0, .cde = &lxb_unicode_decomposition_c_1EF0, .kde = &lxb_unicode_decomposition_k_1EF0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EF1[3] = {0x0075, 0x031B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EF1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EF1[3] = {0x0075, 0x031B, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EF1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EF1[2] = {0x01B0, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EF1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EF1 = {.cp = 0x1EF1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EF1, .cde = &lxb_unicode_decomposition_c_1EF1, .kde = &lxb_unicode_decomposition_k_1EF1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EF2[2] = {0x0059, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EF2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EF2[2] = {0x0059, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EF2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EF2[2] = {0x0059, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EF2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EF2 = {.cp = 0x1EF2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EF2, .cde = &lxb_unicode_decomposition_c_1EF2, .kde = &lxb_unicode_decomposition_k_1EF2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EF3[2] = {0x0079, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EF3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EF3[2] = {0x0079, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EF3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EF3[2] = {0x0079, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EF3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EF3 = {.cp = 0x1EF3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EF3, .cde = &lxb_unicode_decomposition_c_1EF3, .kde = &lxb_unicode_decomposition_k_1EF3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EF4[2] = {0x0059, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EF4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EF4[2] = {0x0059, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EF4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EF4[2] = {0x0059, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EF4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EF4 = {.cp = 0x1EF4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EF4, .cde = &lxb_unicode_decomposition_c_1EF4, .kde = &lxb_unicode_decomposition_k_1EF4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EF5[2] = {0x0079, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EF5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EF5[2] = {0x0079, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EF5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EF5[2] = {0x0079, 0x0323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EF5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EF5 = {.cp = 0x1EF5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EF5, .cde = &lxb_unicode_decomposition_c_1EF5, .kde = &lxb_unicode_decomposition_k_1EF5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EF6[2] = {0x0059, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EF6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EF6[2] = {0x0059, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EF6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EF6[2] = {0x0059, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EF6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EF6 = {.cp = 0x1EF6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EF6, .cde = &lxb_unicode_decomposition_c_1EF6, .kde = &lxb_unicode_decomposition_k_1EF6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EF7[2] = {0x0079, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EF7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EF7[2] = {0x0079, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EF7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EF7[2] = {0x0079, 0x0309};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EF7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EF7 = {.cp = 0x1EF7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EF7, .cde = &lxb_unicode_decomposition_c_1EF7, .kde = &lxb_unicode_decomposition_k_1EF7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EF8[2] = {0x0059, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EF8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EF8[2] = {0x0059, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EF8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EF8[2] = {0x0059, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EF8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EF8 = {.cp = 0x1EF8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EF8, .cde = &lxb_unicode_decomposition_c_1EF8, .kde = &lxb_unicode_decomposition_k_1EF8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1EF9[2] = {0x0079, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1EF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1EF9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1EF9[2] = {0x0079, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1EF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1EF9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1EF9[2] = {0x0079, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1EF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1EF9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1EF9 = {.cp = 0x1EF9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1EF9, .cde = &lxb_unicode_decomposition_c_1EF9, .kde = &lxb_unicode_decomposition_k_1EF9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F00[2] = {0x03B1, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F00, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F00[2] = {0x03B1, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F00, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F00[2] = {0x03B1, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F00, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F00 = {.cp = 0x1F00, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F00, .cde = &lxb_unicode_decomposition_c_1F00, .kde = &lxb_unicode_decomposition_k_1F00};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F01[2] = {0x03B1, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F01, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F01[2] = {0x03B1, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F01, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F01[2] = {0x03B1, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F01, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F01 = {.cp = 0x1F01, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F01, .cde = &lxb_unicode_decomposition_c_1F01, .kde = &lxb_unicode_decomposition_k_1F01};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F02[3] = {0x03B1, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F02, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F02[3] = {0x03B1, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F02, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F02[2] = {0x1F00, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F02, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F02 = {.cp = 0x1F02, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F02, .cde = &lxb_unicode_decomposition_c_1F02, .kde = &lxb_unicode_decomposition_k_1F02};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F03[3] = {0x03B1, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F03, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F03[3] = {0x03B1, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F03, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F03[2] = {0x1F01, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F03, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F03 = {.cp = 0x1F03, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F03, .cde = &lxb_unicode_decomposition_c_1F03, .kde = &lxb_unicode_decomposition_k_1F03};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F04[3] = {0x03B1, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F04, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F04[3] = {0x03B1, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F04, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F04[2] = {0x1F00, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F04, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F04 = {.cp = 0x1F04, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F04, .cde = &lxb_unicode_decomposition_c_1F04, .kde = &lxb_unicode_decomposition_k_1F04};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F05[3] = {0x03B1, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F05, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F05[3] = {0x03B1, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F05, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F05[2] = {0x1F01, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F05, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F05 = {.cp = 0x1F05, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F05, .cde = &lxb_unicode_decomposition_c_1F05, .kde = &lxb_unicode_decomposition_k_1F05};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F06[3] = {0x03B1, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F06, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F06[3] = {0x03B1, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F06, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F06[2] = {0x1F00, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F06, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F06 = {.cp = 0x1F06, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F06, .cde = &lxb_unicode_decomposition_c_1F06, .kde = &lxb_unicode_decomposition_k_1F06};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F07[3] = {0x03B1, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F07, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F07[3] = {0x03B1, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F07, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F07[2] = {0x1F01, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F07, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F07 = {.cp = 0x1F07, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F07, .cde = &lxb_unicode_decomposition_c_1F07, .kde = &lxb_unicode_decomposition_k_1F07};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F08[2] = {0x0391, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F08, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F08[2] = {0x0391, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F08, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F08[2] = {0x0391, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F08, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F08 = {.cp = 0x1F08, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F08, .cde = &lxb_unicode_decomposition_c_1F08, .kde = &lxb_unicode_decomposition_k_1F08};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F09[2] = {0x0391, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F09, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F09[2] = {0x0391, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F09, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F09[2] = {0x0391, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F09, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F09 = {.cp = 0x1F09, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F09, .cde = &lxb_unicode_decomposition_c_1F09, .kde = &lxb_unicode_decomposition_k_1F09};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F0A[3] = {0x0391, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F0A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F0A[3] = {0x0391, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F0A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F0A[2] = {0x1F08, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F0A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F0A = {.cp = 0x1F0A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F0A, .cde = &lxb_unicode_decomposition_c_1F0A, .kde = &lxb_unicode_decomposition_k_1F0A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F0B[3] = {0x0391, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F0B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F0B[3] = {0x0391, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F0B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F0B[2] = {0x1F09, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F0B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F0B = {.cp = 0x1F0B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F0B, .cde = &lxb_unicode_decomposition_c_1F0B, .kde = &lxb_unicode_decomposition_k_1F0B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F0C[3] = {0x0391, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F0C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F0C[3] = {0x0391, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F0C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F0C[2] = {0x1F08, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F0C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F0C = {.cp = 0x1F0C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F0C, .cde = &lxb_unicode_decomposition_c_1F0C, .kde = &lxb_unicode_decomposition_k_1F0C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F0D[3] = {0x0391, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F0D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F0D[3] = {0x0391, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F0D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F0D[2] = {0x1F09, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F0D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F0D = {.cp = 0x1F0D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F0D, .cde = &lxb_unicode_decomposition_c_1F0D, .kde = &lxb_unicode_decomposition_k_1F0D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F0E[3] = {0x0391, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F0E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F0E[3] = {0x0391, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F0E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F0E[2] = {0x1F08, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F0E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F0E = {.cp = 0x1F0E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F0E, .cde = &lxb_unicode_decomposition_c_1F0E, .kde = &lxb_unicode_decomposition_k_1F0E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F0F[3] = {0x0391, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F0F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F0F[3] = {0x0391, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F0F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F0F[2] = {0x1F09, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F0F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F0F = {.cp = 0x1F0F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F0F, .cde = &lxb_unicode_decomposition_c_1F0F, .kde = &lxb_unicode_decomposition_k_1F0F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F10[2] = {0x03B5, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F10, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F10[2] = {0x03B5, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F10, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F10[2] = {0x03B5, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F10, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F10 = {.cp = 0x1F10, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F10, .cde = &lxb_unicode_decomposition_c_1F10, .kde = &lxb_unicode_decomposition_k_1F10};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F11[2] = {0x03B5, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F11, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F11[2] = {0x03B5, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F11, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F11[2] = {0x03B5, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F11, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F11 = {.cp = 0x1F11, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F11, .cde = &lxb_unicode_decomposition_c_1F11, .kde = &lxb_unicode_decomposition_k_1F11};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F12[3] = {0x03B5, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F12, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F12[3] = {0x03B5, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F12, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F12[2] = {0x1F10, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F12, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F12 = {.cp = 0x1F12, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F12, .cde = &lxb_unicode_decomposition_c_1F12, .kde = &lxb_unicode_decomposition_k_1F12};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F13[3] = {0x03B5, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F13, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F13[3] = {0x03B5, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F13, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F13[2] = {0x1F11, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F13, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F13 = {.cp = 0x1F13, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F13, .cde = &lxb_unicode_decomposition_c_1F13, .kde = &lxb_unicode_decomposition_k_1F13};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F14[3] = {0x03B5, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F14, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F14[3] = {0x03B5, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F14, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F14[2] = {0x1F10, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F14, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F14 = {.cp = 0x1F14, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F14, .cde = &lxb_unicode_decomposition_c_1F14, .kde = &lxb_unicode_decomposition_k_1F14};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F15[3] = {0x03B5, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F15, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F15[3] = {0x03B5, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F15, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F15[2] = {0x1F11, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F15, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F15 = {.cp = 0x1F15, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F15, .cde = &lxb_unicode_decomposition_c_1F15, .kde = &lxb_unicode_decomposition_k_1F15};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F18[2] = {0x0395, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F18, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F18[2] = {0x0395, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F18, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F18[2] = {0x0395, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F18, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F18 = {.cp = 0x1F18, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F18, .cde = &lxb_unicode_decomposition_c_1F18, .kde = &lxb_unicode_decomposition_k_1F18};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F19[2] = {0x0395, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F19, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F19[2] = {0x0395, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F19, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F19[2] = {0x0395, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F19, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F19 = {.cp = 0x1F19, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F19, .cde = &lxb_unicode_decomposition_c_1F19, .kde = &lxb_unicode_decomposition_k_1F19};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F1A[3] = {0x0395, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F1A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F1A[3] = {0x0395, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F1A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F1A[2] = {0x1F18, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F1A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F1A = {.cp = 0x1F1A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F1A, .cde = &lxb_unicode_decomposition_c_1F1A, .kde = &lxb_unicode_decomposition_k_1F1A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F1B[3] = {0x0395, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F1B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F1B[3] = {0x0395, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F1B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F1B[2] = {0x1F19, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F1B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F1B = {.cp = 0x1F1B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F1B, .cde = &lxb_unicode_decomposition_c_1F1B, .kde = &lxb_unicode_decomposition_k_1F1B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F1C[3] = {0x0395, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F1C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F1C[3] = {0x0395, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F1C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F1C[2] = {0x1F18, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F1C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F1C = {.cp = 0x1F1C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F1C, .cde = &lxb_unicode_decomposition_c_1F1C, .kde = &lxb_unicode_decomposition_k_1F1C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F1D[3] = {0x0395, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F1D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F1D[3] = {0x0395, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F1D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F1D[2] = {0x1F19, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F1D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F1D = {.cp = 0x1F1D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F1D, .cde = &lxb_unicode_decomposition_c_1F1D, .kde = &lxb_unicode_decomposition_k_1F1D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F20[2] = {0x03B7, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F20, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F20[2] = {0x03B7, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F20, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F20[2] = {0x03B7, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F20, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F20 = {.cp = 0x1F20, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F20, .cde = &lxb_unicode_decomposition_c_1F20, .kde = &lxb_unicode_decomposition_k_1F20};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F21[2] = {0x03B7, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F21, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F21[2] = {0x03B7, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F21, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F21[2] = {0x03B7, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F21, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F21 = {.cp = 0x1F21, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F21, .cde = &lxb_unicode_decomposition_c_1F21, .kde = &lxb_unicode_decomposition_k_1F21};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F22[3] = {0x03B7, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F22, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F22[3] = {0x03B7, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F22, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F22[2] = {0x1F20, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F22, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F22 = {.cp = 0x1F22, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F22, .cde = &lxb_unicode_decomposition_c_1F22, .kde = &lxb_unicode_decomposition_k_1F22};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F23[3] = {0x03B7, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F23, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F23[3] = {0x03B7, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F23, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F23[2] = {0x1F21, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F23, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F23 = {.cp = 0x1F23, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F23, .cde = &lxb_unicode_decomposition_c_1F23, .kde = &lxb_unicode_decomposition_k_1F23};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F24[3] = {0x03B7, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F24, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F24[3] = {0x03B7, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F24, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F24[2] = {0x1F20, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F24, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F24 = {.cp = 0x1F24, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F24, .cde = &lxb_unicode_decomposition_c_1F24, .kde = &lxb_unicode_decomposition_k_1F24};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F25[3] = {0x03B7, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F25, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F25[3] = {0x03B7, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F25, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F25[2] = {0x1F21, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F25, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F25 = {.cp = 0x1F25, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F25, .cde = &lxb_unicode_decomposition_c_1F25, .kde = &lxb_unicode_decomposition_k_1F25};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F26[3] = {0x03B7, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F26, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F26[3] = {0x03B7, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F26, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F26[2] = {0x1F20, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F26, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F26 = {.cp = 0x1F26, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F26, .cde = &lxb_unicode_decomposition_c_1F26, .kde = &lxb_unicode_decomposition_k_1F26};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F27[3] = {0x03B7, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F27, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F27[3] = {0x03B7, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F27, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F27[2] = {0x1F21, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F27, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F27 = {.cp = 0x1F27, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F27, .cde = &lxb_unicode_decomposition_c_1F27, .kde = &lxb_unicode_decomposition_k_1F27};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F28[2] = {0x0397, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F28, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F28[2] = {0x0397, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F28, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F28[2] = {0x0397, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F28, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F28 = {.cp = 0x1F28, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F28, .cde = &lxb_unicode_decomposition_c_1F28, .kde = &lxb_unicode_decomposition_k_1F28};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F29[2] = {0x0397, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F29, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F29[2] = {0x0397, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F29, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F29[2] = {0x0397, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F29, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F29 = {.cp = 0x1F29, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F29, .cde = &lxb_unicode_decomposition_c_1F29, .kde = &lxb_unicode_decomposition_k_1F29};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F2A[3] = {0x0397, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F2A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F2A[3] = {0x0397, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F2A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F2A[2] = {0x1F28, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F2A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F2A = {.cp = 0x1F2A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F2A, .cde = &lxb_unicode_decomposition_c_1F2A, .kde = &lxb_unicode_decomposition_k_1F2A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F2B[3] = {0x0397, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F2B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F2B[3] = {0x0397, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F2B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F2B[2] = {0x1F29, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F2B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F2B = {.cp = 0x1F2B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F2B, .cde = &lxb_unicode_decomposition_c_1F2B, .kde = &lxb_unicode_decomposition_k_1F2B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F2C[3] = {0x0397, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F2C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F2C[3] = {0x0397, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F2C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F2C[2] = {0x1F28, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F2C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F2C = {.cp = 0x1F2C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F2C, .cde = &lxb_unicode_decomposition_c_1F2C, .kde = &lxb_unicode_decomposition_k_1F2C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F2D[3] = {0x0397, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F2D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F2D[3] = {0x0397, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F2D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F2D[2] = {0x1F29, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F2D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F2D = {.cp = 0x1F2D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F2D, .cde = &lxb_unicode_decomposition_c_1F2D, .kde = &lxb_unicode_decomposition_k_1F2D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F2E[3] = {0x0397, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F2E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F2E[3] = {0x0397, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F2E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F2E[2] = {0x1F28, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F2E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F2E = {.cp = 0x1F2E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F2E, .cde = &lxb_unicode_decomposition_c_1F2E, .kde = &lxb_unicode_decomposition_k_1F2E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F2F[3] = {0x0397, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F2F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F2F[3] = {0x0397, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F2F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F2F[2] = {0x1F29, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F2F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F2F = {.cp = 0x1F2F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F2F, .cde = &lxb_unicode_decomposition_c_1F2F, .kde = &lxb_unicode_decomposition_k_1F2F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F30[2] = {0x03B9, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F30, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F30[2] = {0x03B9, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F30, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F30[2] = {0x03B9, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F30, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F30 = {.cp = 0x1F30, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F30, .cde = &lxb_unicode_decomposition_c_1F30, .kde = &lxb_unicode_decomposition_k_1F30};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F31[2] = {0x03B9, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F31, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F31[2] = {0x03B9, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F31, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F31[2] = {0x03B9, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F31, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F31 = {.cp = 0x1F31, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F31, .cde = &lxb_unicode_decomposition_c_1F31, .kde = &lxb_unicode_decomposition_k_1F31};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F32[3] = {0x03B9, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F32, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F32[3] = {0x03B9, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F32, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F32[2] = {0x1F30, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F32, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F32 = {.cp = 0x1F32, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F32, .cde = &lxb_unicode_decomposition_c_1F32, .kde = &lxb_unicode_decomposition_k_1F32};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F33[3] = {0x03B9, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F33, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F33[3] = {0x03B9, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F33, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F33[2] = {0x1F31, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F33, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F33 = {.cp = 0x1F33, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F33, .cde = &lxb_unicode_decomposition_c_1F33, .kde = &lxb_unicode_decomposition_k_1F33};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F34[3] = {0x03B9, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F34, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F34[3] = {0x03B9, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F34, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F34[2] = {0x1F30, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F34, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F34 = {.cp = 0x1F34, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F34, .cde = &lxb_unicode_decomposition_c_1F34, .kde = &lxb_unicode_decomposition_k_1F34};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F35[3] = {0x03B9, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F35, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F35[3] = {0x03B9, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F35, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F35[2] = {0x1F31, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F35, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F35 = {.cp = 0x1F35, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F35, .cde = &lxb_unicode_decomposition_c_1F35, .kde = &lxb_unicode_decomposition_k_1F35};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F36[3] = {0x03B9, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F36, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F36[3] = {0x03B9, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F36, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F36[2] = {0x1F30, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F36, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F36 = {.cp = 0x1F36, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F36, .cde = &lxb_unicode_decomposition_c_1F36, .kde = &lxb_unicode_decomposition_k_1F36};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F37[3] = {0x03B9, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F37, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F37[3] = {0x03B9, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F37, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F37[2] = {0x1F31, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F37, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F37 = {.cp = 0x1F37, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F37, .cde = &lxb_unicode_decomposition_c_1F37, .kde = &lxb_unicode_decomposition_k_1F37};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F38[2] = {0x0399, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F38, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F38[2] = {0x0399, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F38, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F38[2] = {0x0399, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F38, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F38 = {.cp = 0x1F38, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F38, .cde = &lxb_unicode_decomposition_c_1F38, .kde = &lxb_unicode_decomposition_k_1F38};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F39[2] = {0x0399, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F39, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F39[2] = {0x0399, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F39, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F39[2] = {0x0399, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F39, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F39 = {.cp = 0x1F39, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F39, .cde = &lxb_unicode_decomposition_c_1F39, .kde = &lxb_unicode_decomposition_k_1F39};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F3A[3] = {0x0399, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F3A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F3A[3] = {0x0399, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F3A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F3A[2] = {0x1F38, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F3A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F3A = {.cp = 0x1F3A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F3A, .cde = &lxb_unicode_decomposition_c_1F3A, .kde = &lxb_unicode_decomposition_k_1F3A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F3B[3] = {0x0399, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F3B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F3B[3] = {0x0399, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F3B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F3B[2] = {0x1F39, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F3B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F3B = {.cp = 0x1F3B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F3B, .cde = &lxb_unicode_decomposition_c_1F3B, .kde = &lxb_unicode_decomposition_k_1F3B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F3C[3] = {0x0399, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F3C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F3C[3] = {0x0399, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F3C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F3C[2] = {0x1F38, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F3C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F3C = {.cp = 0x1F3C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F3C, .cde = &lxb_unicode_decomposition_c_1F3C, .kde = &lxb_unicode_decomposition_k_1F3C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F3D[3] = {0x0399, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F3D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F3D[3] = {0x0399, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F3D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F3D[2] = {0x1F39, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F3D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F3D = {.cp = 0x1F3D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F3D, .cde = &lxb_unicode_decomposition_c_1F3D, .kde = &lxb_unicode_decomposition_k_1F3D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F3E[3] = {0x0399, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F3E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F3E[3] = {0x0399, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F3E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F3E[2] = {0x1F38, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F3E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F3E = {.cp = 0x1F3E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F3E, .cde = &lxb_unicode_decomposition_c_1F3E, .kde = &lxb_unicode_decomposition_k_1F3E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F3F[3] = {0x0399, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F3F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F3F[3] = {0x0399, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F3F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F3F[2] = {0x1F39, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F3F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F3F = {.cp = 0x1F3F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F3F, .cde = &lxb_unicode_decomposition_c_1F3F, .kde = &lxb_unicode_decomposition_k_1F3F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F40[2] = {0x03BF, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F40, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F40[2] = {0x03BF, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F40, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F40[2] = {0x03BF, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F40, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F40 = {.cp = 0x1F40, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F40, .cde = &lxb_unicode_decomposition_c_1F40, .kde = &lxb_unicode_decomposition_k_1F40};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F41[2] = {0x03BF, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F41, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F41[2] = {0x03BF, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F41, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F41[2] = {0x03BF, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F41, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F41 = {.cp = 0x1F41, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F41, .cde = &lxb_unicode_decomposition_c_1F41, .kde = &lxb_unicode_decomposition_k_1F41};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F42[3] = {0x03BF, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F42, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F42[3] = {0x03BF, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F42, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F42[2] = {0x1F40, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F42, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F42 = {.cp = 0x1F42, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F42, .cde = &lxb_unicode_decomposition_c_1F42, .kde = &lxb_unicode_decomposition_k_1F42};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F43[3] = {0x03BF, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F43, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F43[3] = {0x03BF, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F43, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F43[2] = {0x1F41, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F43, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F43 = {.cp = 0x1F43, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F43, .cde = &lxb_unicode_decomposition_c_1F43, .kde = &lxb_unicode_decomposition_k_1F43};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F44[3] = {0x03BF, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F44, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F44[3] = {0x03BF, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F44, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F44[2] = {0x1F40, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F44, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F44 = {.cp = 0x1F44, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F44, .cde = &lxb_unicode_decomposition_c_1F44, .kde = &lxb_unicode_decomposition_k_1F44};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F45[3] = {0x03BF, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F45, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F45[3] = {0x03BF, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F45, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F45[2] = {0x1F41, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F45, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F45 = {.cp = 0x1F45, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F45, .cde = &lxb_unicode_decomposition_c_1F45, .kde = &lxb_unicode_decomposition_k_1F45};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F48[2] = {0x039F, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F48[2] = {0x039F, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F48[2] = {0x039F, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F48, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F48 = {.cp = 0x1F48, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F48, .cde = &lxb_unicode_decomposition_c_1F48, .kde = &lxb_unicode_decomposition_k_1F48};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F49[2] = {0x039F, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F49, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F49[2] = {0x039F, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F49, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F49[2] = {0x039F, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F49, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F49 = {.cp = 0x1F49, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F49, .cde = &lxb_unicode_decomposition_c_1F49, .kde = &lxb_unicode_decomposition_k_1F49};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F4A[3] = {0x039F, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F4A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F4A[3] = {0x039F, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F4A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F4A[2] = {0x1F48, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F4A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F4A = {.cp = 0x1F4A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F4A, .cde = &lxb_unicode_decomposition_c_1F4A, .kde = &lxb_unicode_decomposition_k_1F4A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F4B[3] = {0x039F, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F4B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F4B[3] = {0x039F, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F4B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F4B[2] = {0x1F49, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F4B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F4B = {.cp = 0x1F4B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F4B, .cde = &lxb_unicode_decomposition_c_1F4B, .kde = &lxb_unicode_decomposition_k_1F4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F4C[3] = {0x039F, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F4C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F4C[3] = {0x039F, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F4C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F4C[2] = {0x1F48, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F4C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F4C = {.cp = 0x1F4C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F4C, .cde = &lxb_unicode_decomposition_c_1F4C, .kde = &lxb_unicode_decomposition_k_1F4C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F4D[3] = {0x039F, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F4D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F4D[3] = {0x039F, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F4D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F4D[2] = {0x1F49, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F4D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F4D = {.cp = 0x1F4D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F4D, .cde = &lxb_unicode_decomposition_c_1F4D, .kde = &lxb_unicode_decomposition_k_1F4D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F50[2] = {0x03C5, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F50, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F50[2] = {0x03C5, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F50, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F50[2] = {0x03C5, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F50, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F50 = {.cp = 0x1F50, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F50, .cde = &lxb_unicode_decomposition_c_1F50, .kde = &lxb_unicode_decomposition_k_1F50};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F51[2] = {0x03C5, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F51, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F51[2] = {0x03C5, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F51, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F51[2] = {0x03C5, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F51, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F51 = {.cp = 0x1F51, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F51, .cde = &lxb_unicode_decomposition_c_1F51, .kde = &lxb_unicode_decomposition_k_1F51};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F52[3] = {0x03C5, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F52, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F52[3] = {0x03C5, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F52, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F52[2] = {0x1F50, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F52, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F52 = {.cp = 0x1F52, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F52, .cde = &lxb_unicode_decomposition_c_1F52, .kde = &lxb_unicode_decomposition_k_1F52};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F53[3] = {0x03C5, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F53, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F53[3] = {0x03C5, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F53, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F53[2] = {0x1F51, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F53, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F53 = {.cp = 0x1F53, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F53, .cde = &lxb_unicode_decomposition_c_1F53, .kde = &lxb_unicode_decomposition_k_1F53};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F54[3] = {0x03C5, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F54, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F54[3] = {0x03C5, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F54, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F54[2] = {0x1F50, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F54, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F54 = {.cp = 0x1F54, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F54, .cde = &lxb_unicode_decomposition_c_1F54, .kde = &lxb_unicode_decomposition_k_1F54};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F55[3] = {0x03C5, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F55, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F55[3] = {0x03C5, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F55, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F55[2] = {0x1F51, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F55, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F55 = {.cp = 0x1F55, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F55, .cde = &lxb_unicode_decomposition_c_1F55, .kde = &lxb_unicode_decomposition_k_1F55};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F56[3] = {0x03C5, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F56, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F56[3] = {0x03C5, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F56, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F56[2] = {0x1F50, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F56, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F56 = {.cp = 0x1F56, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F56, .cde = &lxb_unicode_decomposition_c_1F56, .kde = &lxb_unicode_decomposition_k_1F56};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F57[3] = {0x03C5, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F57, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F57[3] = {0x03C5, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F57, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F57[2] = {0x1F51, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F57, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F57 = {.cp = 0x1F57, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F57, .cde = &lxb_unicode_decomposition_c_1F57, .kde = &lxb_unicode_decomposition_k_1F57};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F59[2] = {0x03A5, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F59, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F59[2] = {0x03A5, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F59, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F59[2] = {0x03A5, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F59, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F59 = {.cp = 0x1F59, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F59, .cde = &lxb_unicode_decomposition_c_1F59, .kde = &lxb_unicode_decomposition_k_1F59};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F5B[3] = {0x03A5, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F5B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F5B[3] = {0x03A5, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F5B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F5B[2] = {0x1F59, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F5B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F5B = {.cp = 0x1F5B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F5B, .cde = &lxb_unicode_decomposition_c_1F5B, .kde = &lxb_unicode_decomposition_k_1F5B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F5D[3] = {0x03A5, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F5D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F5D[3] = {0x03A5, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F5D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F5D[2] = {0x1F59, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F5D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F5D = {.cp = 0x1F5D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F5D, .cde = &lxb_unicode_decomposition_c_1F5D, .kde = &lxb_unicode_decomposition_k_1F5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F5F[3] = {0x03A5, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F5F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F5F[3] = {0x03A5, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F5F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F5F[2] = {0x1F59, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F5F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F5F = {.cp = 0x1F5F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F5F, .cde = &lxb_unicode_decomposition_c_1F5F, .kde = &lxb_unicode_decomposition_k_1F5F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F60[2] = {0x03C9, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F60, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F60[2] = {0x03C9, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F60, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F60[2] = {0x03C9, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F60, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F60 = {.cp = 0x1F60, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F60, .cde = &lxb_unicode_decomposition_c_1F60, .kde = &lxb_unicode_decomposition_k_1F60};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F61[2] = {0x03C9, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F61, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F61[2] = {0x03C9, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F61, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F61[2] = {0x03C9, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F61, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F61 = {.cp = 0x1F61, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F61, .cde = &lxb_unicode_decomposition_c_1F61, .kde = &lxb_unicode_decomposition_k_1F61};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F62[3] = {0x03C9, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F62, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F62[3] = {0x03C9, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F62, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F62[2] = {0x1F60, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F62, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F62 = {.cp = 0x1F62, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F62, .cde = &lxb_unicode_decomposition_c_1F62, .kde = &lxb_unicode_decomposition_k_1F62};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F63[3] = {0x03C9, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F63, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F63[3] = {0x03C9, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F63, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F63[2] = {0x1F61, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F63, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F63 = {.cp = 0x1F63, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F63, .cde = &lxb_unicode_decomposition_c_1F63, .kde = &lxb_unicode_decomposition_k_1F63};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F64[3] = {0x03C9, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F64, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F64[3] = {0x03C9, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F64, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F64[2] = {0x1F60, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F64, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F64 = {.cp = 0x1F64, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F64, .cde = &lxb_unicode_decomposition_c_1F64, .kde = &lxb_unicode_decomposition_k_1F64};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F65[3] = {0x03C9, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F65, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F65[3] = {0x03C9, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F65, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F65[2] = {0x1F61, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F65, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F65 = {.cp = 0x1F65, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F65, .cde = &lxb_unicode_decomposition_c_1F65, .kde = &lxb_unicode_decomposition_k_1F65};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F66[3] = {0x03C9, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F66, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F66[3] = {0x03C9, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F66, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F66[2] = {0x1F60, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F66, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F66 = {.cp = 0x1F66, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F66, .cde = &lxb_unicode_decomposition_c_1F66, .kde = &lxb_unicode_decomposition_k_1F66};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F67[3] = {0x03C9, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F67, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F67[3] = {0x03C9, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F67, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F67[2] = {0x1F61, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F67, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F67 = {.cp = 0x1F67, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F67, .cde = &lxb_unicode_decomposition_c_1F67, .kde = &lxb_unicode_decomposition_k_1F67};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F68[2] = {0x03A9, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F68, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F68[2] = {0x03A9, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F68, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F68[2] = {0x03A9, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F68, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F68 = {.cp = 0x1F68, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F68, .cde = &lxb_unicode_decomposition_c_1F68, .kde = &lxb_unicode_decomposition_k_1F68};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F69[2] = {0x03A9, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F69, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F69[2] = {0x03A9, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F69, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F69[2] = {0x03A9, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F69, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F69 = {.cp = 0x1F69, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F69, .cde = &lxb_unicode_decomposition_c_1F69, .kde = &lxb_unicode_decomposition_k_1F69};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F6A[3] = {0x03A9, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F6A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F6A[3] = {0x03A9, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F6A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F6A[2] = {0x1F68, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F6A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F6A = {.cp = 0x1F6A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F6A, .cde = &lxb_unicode_decomposition_c_1F6A, .kde = &lxb_unicode_decomposition_k_1F6A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F6B[3] = {0x03A9, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F6B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F6B[3] = {0x03A9, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F6B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F6B[2] = {0x1F69, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F6B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F6B = {.cp = 0x1F6B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F6B, .cde = &lxb_unicode_decomposition_c_1F6B, .kde = &lxb_unicode_decomposition_k_1F6B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F6C[3] = {0x03A9, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F6C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F6C[3] = {0x03A9, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F6C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F6C[2] = {0x1F68, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F6C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F6C = {.cp = 0x1F6C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F6C, .cde = &lxb_unicode_decomposition_c_1F6C, .kde = &lxb_unicode_decomposition_k_1F6C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F6D[3] = {0x03A9, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F6D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F6D[3] = {0x03A9, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F6D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F6D[2] = {0x1F69, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F6D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F6D = {.cp = 0x1F6D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F6D, .cde = &lxb_unicode_decomposition_c_1F6D, .kde = &lxb_unicode_decomposition_k_1F6D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F6E[3] = {0x03A9, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F6E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F6E[3] = {0x03A9, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F6E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F6E[2] = {0x1F68, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F6E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F6E = {.cp = 0x1F6E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F6E, .cde = &lxb_unicode_decomposition_c_1F6E, .kde = &lxb_unicode_decomposition_k_1F6E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F6F[3] = {0x03A9, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F6F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F6F[3] = {0x03A9, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F6F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F6F[2] = {0x1F69, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F6F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F6F = {.cp = 0x1F6F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F6F, .cde = &lxb_unicode_decomposition_c_1F6F, .kde = &lxb_unicode_decomposition_k_1F6F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F70[2] = {0x03B1, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F70, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F70[2] = {0x03B1, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F70, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F70[2] = {0x03B1, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F70, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F70 = {.cp = 0x1F70, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F70, .cde = &lxb_unicode_decomposition_c_1F70, .kde = &lxb_unicode_decomposition_k_1F70};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F71[2] = {0x03B1, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F71, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F71[2] = {0x03B1, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F71, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F71[1] = {0x03AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F71, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1F71 = {.cp = 0x1F71, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F71, .cde = &lxb_unicode_decomposition_c_1F71, .kde = &lxb_unicode_decomposition_k_1F71};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F72[2] = {0x03B5, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F72, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F72[2] = {0x03B5, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F72, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F72[2] = {0x03B5, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F72, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F72 = {.cp = 0x1F72, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F72, .cde = &lxb_unicode_decomposition_c_1F72, .kde = &lxb_unicode_decomposition_k_1F72};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F73[2] = {0x03B5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F73, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F73[2] = {0x03B5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F73, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F73[1] = {0x03AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F73, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1F73 = {.cp = 0x1F73, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F73, .cde = &lxb_unicode_decomposition_c_1F73, .kde = &lxb_unicode_decomposition_k_1F73};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F74[2] = {0x03B7, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F74, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F74[2] = {0x03B7, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F74, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F74[2] = {0x03B7, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F74, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F74 = {.cp = 0x1F74, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F74, .cde = &lxb_unicode_decomposition_c_1F74, .kde = &lxb_unicode_decomposition_k_1F74};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F75[2] = {0x03B7, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F75, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F75[2] = {0x03B7, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F75, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F75[1] = {0x03AE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F75, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1F75 = {.cp = 0x1F75, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F75, .cde = &lxb_unicode_decomposition_c_1F75, .kde = &lxb_unicode_decomposition_k_1F75};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F76[2] = {0x03B9, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F76, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F76[2] = {0x03B9, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F76, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F76[2] = {0x03B9, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F76, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F76 = {.cp = 0x1F76, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F76, .cde = &lxb_unicode_decomposition_c_1F76, .kde = &lxb_unicode_decomposition_k_1F76};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F77[2] = {0x03B9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F77, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F77[2] = {0x03B9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F77, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F77[1] = {0x03AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F77, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1F77 = {.cp = 0x1F77, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F77, .cde = &lxb_unicode_decomposition_c_1F77, .kde = &lxb_unicode_decomposition_k_1F77};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F78[2] = {0x03BF, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F78, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F78[2] = {0x03BF, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F78, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F78[2] = {0x03BF, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F78, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F78 = {.cp = 0x1F78, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F78, .cde = &lxb_unicode_decomposition_c_1F78, .kde = &lxb_unicode_decomposition_k_1F78};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F79[2] = {0x03BF, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F79, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F79[2] = {0x03BF, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F79, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F79[1] = {0x03CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F79, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1F79 = {.cp = 0x1F79, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F79, .cde = &lxb_unicode_decomposition_c_1F79, .kde = &lxb_unicode_decomposition_k_1F79};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F7A[2] = {0x03C5, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F7A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F7A[2] = {0x03C5, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F7A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F7A[2] = {0x03C5, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F7A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F7A = {.cp = 0x1F7A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F7A, .cde = &lxb_unicode_decomposition_c_1F7A, .kde = &lxb_unicode_decomposition_k_1F7A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F7B[2] = {0x03C5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F7B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F7B[2] = {0x03C5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F7B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F7B[1] = {0x03CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F7B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1F7B = {.cp = 0x1F7B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F7B, .cde = &lxb_unicode_decomposition_c_1F7B, .kde = &lxb_unicode_decomposition_k_1F7B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F7C[2] = {0x03C9, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F7C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F7C[2] = {0x03C9, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F7C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F7C[2] = {0x03C9, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F7C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F7C = {.cp = 0x1F7C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F7C, .cde = &lxb_unicode_decomposition_c_1F7C, .kde = &lxb_unicode_decomposition_k_1F7C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F7D[2] = {0x03C9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F7D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F7D[2] = {0x03C9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F7D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F7D[1] = {0x03CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F7D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1F7D = {.cp = 0x1F7D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F7D, .cde = &lxb_unicode_decomposition_c_1F7D, .kde = &lxb_unicode_decomposition_k_1F7D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F80[3] = {0x03B1, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F80, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F80[3] = {0x03B1, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F80, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F80[2] = {0x1F00, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F80, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F80 = {.cp = 0x1F80, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F80, .cde = &lxb_unicode_decomposition_c_1F80, .kde = &lxb_unicode_decomposition_k_1F80};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F81[3] = {0x03B1, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F81, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F81[3] = {0x03B1, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F81, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F81[2] = {0x1F01, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F81, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F81 = {.cp = 0x1F81, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F81, .cde = &lxb_unicode_decomposition_c_1F81, .kde = &lxb_unicode_decomposition_k_1F81};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F82[4] = {0x03B1, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F82, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F82[4] = {0x03B1, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F82, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F82[2] = {0x1F02, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F82, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F82 = {.cp = 0x1F82, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F82, .cde = &lxb_unicode_decomposition_c_1F82, .kde = &lxb_unicode_decomposition_k_1F82};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F83[4] = {0x03B1, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F83, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F83[4] = {0x03B1, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F83, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F83[2] = {0x1F03, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F83, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F83 = {.cp = 0x1F83, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F83, .cde = &lxb_unicode_decomposition_c_1F83, .kde = &lxb_unicode_decomposition_k_1F83};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F84[4] = {0x03B1, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F84, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F84[4] = {0x03B1, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F84, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F84[2] = {0x1F04, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F84, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F84 = {.cp = 0x1F84, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F84, .cde = &lxb_unicode_decomposition_c_1F84, .kde = &lxb_unicode_decomposition_k_1F84};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F85[4] = {0x03B1, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F85, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F85[4] = {0x03B1, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F85, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F85[2] = {0x1F05, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F85, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F85 = {.cp = 0x1F85, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F85, .cde = &lxb_unicode_decomposition_c_1F85, .kde = &lxb_unicode_decomposition_k_1F85};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F86[4] = {0x03B1, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F86, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F86[4] = {0x03B1, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F86, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F86[2] = {0x1F06, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F86, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F86 = {.cp = 0x1F86, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F86, .cde = &lxb_unicode_decomposition_c_1F86, .kde = &lxb_unicode_decomposition_k_1F86};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F87[4] = {0x03B1, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F87, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F87[4] = {0x03B1, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F87, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F87[2] = {0x1F07, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F87, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F87 = {.cp = 0x1F87, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F87, .cde = &lxb_unicode_decomposition_c_1F87, .kde = &lxb_unicode_decomposition_k_1F87};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F88[3] = {0x0391, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F88, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F88[3] = {0x0391, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F88, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F88[2] = {0x1F08, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F88, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F88 = {.cp = 0x1F88, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F88, .cde = &lxb_unicode_decomposition_c_1F88, .kde = &lxb_unicode_decomposition_k_1F88};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F89[3] = {0x0391, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F89, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F89[3] = {0x0391, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F89, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F89[2] = {0x1F09, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F89, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F89 = {.cp = 0x1F89, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F89, .cde = &lxb_unicode_decomposition_c_1F89, .kde = &lxb_unicode_decomposition_k_1F89};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F8A[4] = {0x0391, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F8A, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F8A[4] = {0x0391, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F8A, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F8A[2] = {0x1F0A, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F8A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F8A = {.cp = 0x1F8A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F8A, .cde = &lxb_unicode_decomposition_c_1F8A, .kde = &lxb_unicode_decomposition_k_1F8A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F8B[4] = {0x0391, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F8B, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F8B[4] = {0x0391, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F8B, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F8B[2] = {0x1F0B, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F8B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F8B = {.cp = 0x1F8B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F8B, .cde = &lxb_unicode_decomposition_c_1F8B, .kde = &lxb_unicode_decomposition_k_1F8B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F8C[4] = {0x0391, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F8C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F8C[4] = {0x0391, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F8C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F8C[2] = {0x1F0C, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F8C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F8C = {.cp = 0x1F8C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F8C, .cde = &lxb_unicode_decomposition_c_1F8C, .kde = &lxb_unicode_decomposition_k_1F8C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F8D[4] = {0x0391, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F8D, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F8D[4] = {0x0391, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F8D, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F8D[2] = {0x1F0D, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F8D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F8D = {.cp = 0x1F8D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F8D, .cde = &lxb_unicode_decomposition_c_1F8D, .kde = &lxb_unicode_decomposition_k_1F8D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F8E[4] = {0x0391, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F8E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F8E[4] = {0x0391, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F8E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F8E[2] = {0x1F0E, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F8E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F8E = {.cp = 0x1F8E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F8E, .cde = &lxb_unicode_decomposition_c_1F8E, .kde = &lxb_unicode_decomposition_k_1F8E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F8F[4] = {0x0391, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F8F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F8F[4] = {0x0391, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F8F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F8F[2] = {0x1F0F, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F8F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F8F = {.cp = 0x1F8F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F8F, .cde = &lxb_unicode_decomposition_c_1F8F, .kde = &lxb_unicode_decomposition_k_1F8F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F90[3] = {0x03B7, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F90, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F90[3] = {0x03B7, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F90, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F90[2] = {0x1F20, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F90, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F90 = {.cp = 0x1F90, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F90, .cde = &lxb_unicode_decomposition_c_1F90, .kde = &lxb_unicode_decomposition_k_1F90};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F91[3] = {0x03B7, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F91, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F91[3] = {0x03B7, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F91, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F91[2] = {0x1F21, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F91, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F91 = {.cp = 0x1F91, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F91, .cde = &lxb_unicode_decomposition_c_1F91, .kde = &lxb_unicode_decomposition_k_1F91};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F92[4] = {0x03B7, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F92, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F92[4] = {0x03B7, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F92, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F92[2] = {0x1F22, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F92, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F92 = {.cp = 0x1F92, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F92, .cde = &lxb_unicode_decomposition_c_1F92, .kde = &lxb_unicode_decomposition_k_1F92};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F93[4] = {0x03B7, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F93, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F93[4] = {0x03B7, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F93, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F93[2] = {0x1F23, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F93, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F93 = {.cp = 0x1F93, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F93, .cde = &lxb_unicode_decomposition_c_1F93, .kde = &lxb_unicode_decomposition_k_1F93};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F94[4] = {0x03B7, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F94, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F94[4] = {0x03B7, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F94, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F94[2] = {0x1F24, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F94, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F94 = {.cp = 0x1F94, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F94, .cde = &lxb_unicode_decomposition_c_1F94, .kde = &lxb_unicode_decomposition_k_1F94};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F95[4] = {0x03B7, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F95, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F95[4] = {0x03B7, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F95, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F95[2] = {0x1F25, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F95, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F95 = {.cp = 0x1F95, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F95, .cde = &lxb_unicode_decomposition_c_1F95, .kde = &lxb_unicode_decomposition_k_1F95};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F96[4] = {0x03B7, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F96, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F96[4] = {0x03B7, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F96, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F96[2] = {0x1F26, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F96, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F96 = {.cp = 0x1F96, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F96, .cde = &lxb_unicode_decomposition_c_1F96, .kde = &lxb_unicode_decomposition_k_1F96};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F97[4] = {0x03B7, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F97, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F97[4] = {0x03B7, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F97, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F97[2] = {0x1F27, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F97, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F97 = {.cp = 0x1F97, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F97, .cde = &lxb_unicode_decomposition_c_1F97, .kde = &lxb_unicode_decomposition_k_1F97};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F98[3] = {0x0397, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F98, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F98[3] = {0x0397, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F98, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F98[2] = {0x1F28, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F98, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F98 = {.cp = 0x1F98, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F98, .cde = &lxb_unicode_decomposition_c_1F98, .kde = &lxb_unicode_decomposition_k_1F98};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F99[3] = {0x0397, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F99, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F99[3] = {0x0397, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F99, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F99[2] = {0x1F29, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F99, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F99 = {.cp = 0x1F99, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F99, .cde = &lxb_unicode_decomposition_c_1F99, .kde = &lxb_unicode_decomposition_k_1F99};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F9A[4] = {0x0397, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F9A, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F9A[4] = {0x0397, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F9A, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F9A[2] = {0x1F2A, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F9A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F9A = {.cp = 0x1F9A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F9A, .cde = &lxb_unicode_decomposition_c_1F9A, .kde = &lxb_unicode_decomposition_k_1F9A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F9B[4] = {0x0397, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F9B, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F9B[4] = {0x0397, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F9B, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F9B[2] = {0x1F2B, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F9B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F9B = {.cp = 0x1F9B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F9B, .cde = &lxb_unicode_decomposition_c_1F9B, .kde = &lxb_unicode_decomposition_k_1F9B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F9C[4] = {0x0397, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F9C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F9C[4] = {0x0397, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F9C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F9C[2] = {0x1F2C, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F9C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F9C = {.cp = 0x1F9C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F9C, .cde = &lxb_unicode_decomposition_c_1F9C, .kde = &lxb_unicode_decomposition_k_1F9C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F9D[4] = {0x0397, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F9D, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F9D[4] = {0x0397, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F9D, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F9D[2] = {0x1F2D, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F9D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F9D = {.cp = 0x1F9D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F9D, .cde = &lxb_unicode_decomposition_c_1F9D, .kde = &lxb_unicode_decomposition_k_1F9D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F9E[4] = {0x0397, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F9E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F9E[4] = {0x0397, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F9E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F9E[2] = {0x1F2E, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F9E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F9E = {.cp = 0x1F9E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F9E, .cde = &lxb_unicode_decomposition_c_1F9E, .kde = &lxb_unicode_decomposition_k_1F9E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1F9F[4] = {0x0397, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1F9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1F9F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1F9F[4] = {0x0397, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1F9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1F9F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1F9F[2] = {0x1F2F, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1F9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1F9F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1F9F = {.cp = 0x1F9F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1F9F, .cde = &lxb_unicode_decomposition_c_1F9F, .kde = &lxb_unicode_decomposition_k_1F9F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FA0[3] = {0x03C9, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FA0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FA0[3] = {0x03C9, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FA0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FA0[2] = {0x1F60, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FA0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FA0 = {.cp = 0x1FA0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FA0, .cde = &lxb_unicode_decomposition_c_1FA0, .kde = &lxb_unicode_decomposition_k_1FA0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FA1[3] = {0x03C9, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FA1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FA1[3] = {0x03C9, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FA1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FA1[2] = {0x1F61, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FA1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FA1 = {.cp = 0x1FA1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FA1, .cde = &lxb_unicode_decomposition_c_1FA1, .kde = &lxb_unicode_decomposition_k_1FA1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FA2[4] = {0x03C9, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FA2, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FA2[4] = {0x03C9, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FA2, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FA2[2] = {0x1F62, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FA2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FA2 = {.cp = 0x1FA2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FA2, .cde = &lxb_unicode_decomposition_c_1FA2, .kde = &lxb_unicode_decomposition_k_1FA2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FA3[4] = {0x03C9, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FA3, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FA3[4] = {0x03C9, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FA3, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FA3[2] = {0x1F63, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FA3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FA3 = {.cp = 0x1FA3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FA3, .cde = &lxb_unicode_decomposition_c_1FA3, .kde = &lxb_unicode_decomposition_k_1FA3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FA4[4] = {0x03C9, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FA4, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FA4[4] = {0x03C9, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FA4, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FA4[2] = {0x1F64, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FA4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FA4 = {.cp = 0x1FA4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FA4, .cde = &lxb_unicode_decomposition_c_1FA4, .kde = &lxb_unicode_decomposition_k_1FA4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FA5[4] = {0x03C9, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FA5, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FA5[4] = {0x03C9, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FA5, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FA5[2] = {0x1F65, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FA5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FA5 = {.cp = 0x1FA5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FA5, .cde = &lxb_unicode_decomposition_c_1FA5, .kde = &lxb_unicode_decomposition_k_1FA5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FA6[4] = {0x03C9, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FA6, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FA6[4] = {0x03C9, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FA6, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FA6[2] = {0x1F66, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FA6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FA6 = {.cp = 0x1FA6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FA6, .cde = &lxb_unicode_decomposition_c_1FA6, .kde = &lxb_unicode_decomposition_k_1FA6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FA7[4] = {0x03C9, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FA7, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FA7[4] = {0x03C9, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FA7, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FA7[2] = {0x1F67, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FA7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FA7 = {.cp = 0x1FA7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FA7, .cde = &lxb_unicode_decomposition_c_1FA7, .kde = &lxb_unicode_decomposition_k_1FA7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FA8[3] = {0x03A9, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FA8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FA8[3] = {0x03A9, 0x0313, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FA8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FA8[2] = {0x1F68, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FA8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FA8 = {.cp = 0x1FA8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FA8, .cde = &lxb_unicode_decomposition_c_1FA8, .kde = &lxb_unicode_decomposition_k_1FA8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FA9[3] = {0x03A9, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FA9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FA9[3] = {0x03A9, 0x0314, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FA9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FA9[2] = {0x1F69, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FA9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FA9 = {.cp = 0x1FA9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FA9, .cde = &lxb_unicode_decomposition_c_1FA9, .kde = &lxb_unicode_decomposition_k_1FA9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FAA[4] = {0x03A9, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FAA, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FAA[4] = {0x03A9, 0x0313, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FAA, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FAA[2] = {0x1F6A, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FAA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FAA = {.cp = 0x1FAA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FAA, .cde = &lxb_unicode_decomposition_c_1FAA, .kde = &lxb_unicode_decomposition_k_1FAA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FAB[4] = {0x03A9, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FAB, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FAB[4] = {0x03A9, 0x0314, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FAB, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FAB[2] = {0x1F6B, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FAB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FAB = {.cp = 0x1FAB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FAB, .cde = &lxb_unicode_decomposition_c_1FAB, .kde = &lxb_unicode_decomposition_k_1FAB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FAC[4] = {0x03A9, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FAC, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FAC[4] = {0x03A9, 0x0313, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FAC, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FAC[2] = {0x1F6C, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FAC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FAC = {.cp = 0x1FAC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FAC, .cde = &lxb_unicode_decomposition_c_1FAC, .kde = &lxb_unicode_decomposition_k_1FAC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FAD[4] = {0x03A9, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FAD, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FAD[4] = {0x03A9, 0x0314, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FAD, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FAD[2] = {0x1F6D, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FAD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FAD = {.cp = 0x1FAD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FAD, .cde = &lxb_unicode_decomposition_c_1FAD, .kde = &lxb_unicode_decomposition_k_1FAD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FAE[4] = {0x03A9, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FAE, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FAE[4] = {0x03A9, 0x0313, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FAE, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FAE[2] = {0x1F6E, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FAE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FAE = {.cp = 0x1FAE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FAE, .cde = &lxb_unicode_decomposition_c_1FAE, .kde = &lxb_unicode_decomposition_k_1FAE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FAF[4] = {0x03A9, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FAF, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FAF[4] = {0x03A9, 0x0314, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FAF, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FAF[2] = {0x1F6F, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FAF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FAF = {.cp = 0x1FAF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FAF, .cde = &lxb_unicode_decomposition_c_1FAF, .kde = &lxb_unicode_decomposition_k_1FAF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FB0[2] = {0x03B1, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FB0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FB0[2] = {0x03B1, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FB0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FB0[2] = {0x03B1, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FB0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FB0 = {.cp = 0x1FB0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FB0, .cde = &lxb_unicode_decomposition_c_1FB0, .kde = &lxb_unicode_decomposition_k_1FB0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FB1[2] = {0x03B1, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FB1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FB1[2] = {0x03B1, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FB1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FB1[2] = {0x03B1, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FB1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FB1 = {.cp = 0x1FB1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FB1, .cde = &lxb_unicode_decomposition_c_1FB1, .kde = &lxb_unicode_decomposition_k_1FB1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FB2[3] = {0x03B1, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FB2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FB2[3] = {0x03B1, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FB2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FB2[2] = {0x1F70, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FB2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FB2 = {.cp = 0x1FB2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FB2, .cde = &lxb_unicode_decomposition_c_1FB2, .kde = &lxb_unicode_decomposition_k_1FB2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FB3[2] = {0x03B1, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FB3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FB3[2] = {0x03B1, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FB3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FB3[2] = {0x03B1, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FB3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FB3 = {.cp = 0x1FB3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FB3, .cde = &lxb_unicode_decomposition_c_1FB3, .kde = &lxb_unicode_decomposition_k_1FB3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FB4[3] = {0x03B1, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FB4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FB4[3] = {0x03B1, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FB4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FB4[2] = {0x03AC, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FB4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FB4 = {.cp = 0x1FB4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FB4, .cde = &lxb_unicode_decomposition_c_1FB4, .kde = &lxb_unicode_decomposition_k_1FB4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FB6[2] = {0x03B1, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FB6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FB6[2] = {0x03B1, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FB6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FB6[2] = {0x03B1, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FB6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FB6 = {.cp = 0x1FB6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FB6, .cde = &lxb_unicode_decomposition_c_1FB6, .kde = &lxb_unicode_decomposition_k_1FB6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FB7[3] = {0x03B1, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FB7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FB7[3] = {0x03B1, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FB7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FB7[2] = {0x1FB6, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FB7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FB7 = {.cp = 0x1FB7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FB7, .cde = &lxb_unicode_decomposition_c_1FB7, .kde = &lxb_unicode_decomposition_k_1FB7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FB8[2] = {0x0391, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FB8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FB8[2] = {0x0391, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FB8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FB8[2] = {0x0391, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FB8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FB8 = {.cp = 0x1FB8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FB8, .cde = &lxb_unicode_decomposition_c_1FB8, .kde = &lxb_unicode_decomposition_k_1FB8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FB9[2] = {0x0391, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FB9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FB9[2] = {0x0391, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FB9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FB9[2] = {0x0391, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FB9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FB9 = {.cp = 0x1FB9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FB9, .cde = &lxb_unicode_decomposition_c_1FB9, .kde = &lxb_unicode_decomposition_k_1FB9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FBA[2] = {0x0391, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FBA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FBA[2] = {0x0391, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FBA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FBA[2] = {0x0391, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FBA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FBA = {.cp = 0x1FBA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FBA, .cde = &lxb_unicode_decomposition_c_1FBA, .kde = &lxb_unicode_decomposition_k_1FBA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FBB[2] = {0x0391, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FBB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FBB[2] = {0x0391, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FBB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FBB[1] = {0x0386};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FBB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FBB = {.cp = 0x1FBB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FBB, .cde = &lxb_unicode_decomposition_c_1FBB, .kde = &lxb_unicode_decomposition_k_1FBB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FBC[2] = {0x0391, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FBC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FBC[2] = {0x0391, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FBC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FBC[2] = {0x0391, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FBC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FBC = {.cp = 0x1FBC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FBC, .cde = &lxb_unicode_decomposition_c_1FBC, .kde = &lxb_unicode_decomposition_k_1FBC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FBD[2] = {0x0020, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_1FBD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FBD[2] = {0x0020, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_1FBD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FBD[2] = {0x0020, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__1FBD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FBD = {.cp = 0x1FBD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FBD, .cde = &lxb_unicode_decomposition_c_1FBD, .kde = &lxb_unicode_decomposition_k_1FBD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FBE[1] = {0x03B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FBE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FBE[1] = {0x03B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FBE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FBE[1] = {0x03B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FBE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FBE = {.cp = 0x1FBE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FBE, .cde = &lxb_unicode_decomposition_c_1FBE, .kde = &lxb_unicode_decomposition_k_1FBE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FBF[2] = {0x0020, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_1FBF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FBF[2] = {0x0020, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_1FBF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FBF[2] = {0x0020, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__1FBF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FBF = {.cp = 0x1FBF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FBF, .cde = &lxb_unicode_decomposition_c_1FBF, .kde = &lxb_unicode_decomposition_k_1FBF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FC0[2] = {0x0020, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_1FC0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FC0[2] = {0x0020, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_1FC0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FC0[2] = {0x0020, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__1FC0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FC0 = {.cp = 0x1FC0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FC0, .cde = &lxb_unicode_decomposition_c_1FC0, .kde = &lxb_unicode_decomposition_k_1FC0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FC1[2] = {0x00A8, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FC1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FC1[3] = {0x0020, 0x0308, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FC1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FC1[2] = {0x00A8, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FC1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FC1 = {.cp = 0x1FC1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FC1, .cde = &lxb_unicode_decomposition_c_1FC1, .kde = &lxb_unicode_decomposition_k_1FC1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FC2[3] = {0x03B7, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FC2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FC2[3] = {0x03B7, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FC2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FC2[2] = {0x1F74, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FC2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FC2 = {.cp = 0x1FC2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FC2, .cde = &lxb_unicode_decomposition_c_1FC2, .kde = &lxb_unicode_decomposition_k_1FC2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FC3[2] = {0x03B7, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FC3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FC3[2] = {0x03B7, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FC3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FC3[2] = {0x03B7, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FC3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FC3 = {.cp = 0x1FC3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FC3, .cde = &lxb_unicode_decomposition_c_1FC3, .kde = &lxb_unicode_decomposition_k_1FC3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FC4[3] = {0x03B7, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FC4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FC4[3] = {0x03B7, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FC4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FC4[2] = {0x03AE, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FC4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FC4 = {.cp = 0x1FC4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FC4, .cde = &lxb_unicode_decomposition_c_1FC4, .kde = &lxb_unicode_decomposition_k_1FC4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FC6[2] = {0x03B7, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FC6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FC6[2] = {0x03B7, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FC6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FC6[2] = {0x03B7, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FC6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FC6 = {.cp = 0x1FC6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FC6, .cde = &lxb_unicode_decomposition_c_1FC6, .kde = &lxb_unicode_decomposition_k_1FC6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FC7[3] = {0x03B7, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FC7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FC7[3] = {0x03B7, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FC7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FC7[2] = {0x1FC6, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FC7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FC7 = {.cp = 0x1FC7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FC7, .cde = &lxb_unicode_decomposition_c_1FC7, .kde = &lxb_unicode_decomposition_k_1FC7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FC8[2] = {0x0395, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FC8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FC8[2] = {0x0395, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FC8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FC8[2] = {0x0395, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FC8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FC8 = {.cp = 0x1FC8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FC8, .cde = &lxb_unicode_decomposition_c_1FC8, .kde = &lxb_unicode_decomposition_k_1FC8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FC9[2] = {0x0395, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FC9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FC9[2] = {0x0395, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FC9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FC9[1] = {0x0388};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FC9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FC9 = {.cp = 0x1FC9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FC9, .cde = &lxb_unicode_decomposition_c_1FC9, .kde = &lxb_unicode_decomposition_k_1FC9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FCA[2] = {0x0397, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FCA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FCA[2] = {0x0397, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FCA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FCA[2] = {0x0397, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FCA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FCA = {.cp = 0x1FCA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FCA, .cde = &lxb_unicode_decomposition_c_1FCA, .kde = &lxb_unicode_decomposition_k_1FCA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FCB[2] = {0x0397, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FCB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FCB[2] = {0x0397, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FCB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FCB[1] = {0x0389};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FCB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FCB = {.cp = 0x1FCB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FCB, .cde = &lxb_unicode_decomposition_c_1FCB, .kde = &lxb_unicode_decomposition_k_1FCB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FCC[2] = {0x0397, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FCC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FCC[2] = {0x0397, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FCC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FCC[2] = {0x0397, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FCC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FCC = {.cp = 0x1FCC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FCC, .cde = &lxb_unicode_decomposition_c_1FCC, .kde = &lxb_unicode_decomposition_k_1FCC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FCD[2] = {0x1FBF, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FCD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FCD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FCD[3] = {0x0020, 0x0313, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FCD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FCD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FCD[2] = {0x1FBF, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FCD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FCD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FCD = {.cp = 0x1FCD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FCD, .cde = &lxb_unicode_decomposition_c_1FCD, .kde = &lxb_unicode_decomposition_k_1FCD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FCE[2] = {0x1FBF, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FCE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FCE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FCE[3] = {0x0020, 0x0313, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FCE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FCE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FCE[2] = {0x1FBF, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FCE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FCE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FCE = {.cp = 0x1FCE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FCE, .cde = &lxb_unicode_decomposition_c_1FCE, .kde = &lxb_unicode_decomposition_k_1FCE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FCF[2] = {0x1FBF, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FCF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FCF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FCF[3] = {0x0020, 0x0313, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FCF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FCF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FCF[2] = {0x1FBF, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FCF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FCF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FCF = {.cp = 0x1FCF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FCF, .cde = &lxb_unicode_decomposition_c_1FCF, .kde = &lxb_unicode_decomposition_k_1FCF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FD0[2] = {0x03B9, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FD0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FD0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FD0[2] = {0x03B9, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FD0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FD0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FD0[2] = {0x03B9, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FD0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FD0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FD0 = {.cp = 0x1FD0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FD0, .cde = &lxb_unicode_decomposition_c_1FD0, .kde = &lxb_unicode_decomposition_k_1FD0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FD1[2] = {0x03B9, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FD1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FD1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FD1[2] = {0x03B9, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FD1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FD1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FD1[2] = {0x03B9, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FD1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FD1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FD1 = {.cp = 0x1FD1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FD1, .cde = &lxb_unicode_decomposition_c_1FD1, .kde = &lxb_unicode_decomposition_k_1FD1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FD2[3] = {0x03B9, 0x0308, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FD2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FD2[3] = {0x03B9, 0x0308, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FD2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FD2[2] = {0x03CA, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FD2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FD2 = {.cp = 0x1FD2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FD2, .cde = &lxb_unicode_decomposition_c_1FD2, .kde = &lxb_unicode_decomposition_k_1FD2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FD3[3] = {0x03B9, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FD3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FD3[3] = {0x03B9, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FD3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FD3[1] = {0x0390};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FD3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FD3 = {.cp = 0x1FD3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FD3, .cde = &lxb_unicode_decomposition_c_1FD3, .kde = &lxb_unicode_decomposition_k_1FD3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FD6[2] = {0x03B9, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FD6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FD6[2] = {0x03B9, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FD6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FD6[2] = {0x03B9, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FD6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FD6 = {.cp = 0x1FD6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FD6, .cde = &lxb_unicode_decomposition_c_1FD6, .kde = &lxb_unicode_decomposition_k_1FD6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FD7[3] = {0x03B9, 0x0308, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FD7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FD7[3] = {0x03B9, 0x0308, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FD7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FD7[2] = {0x03CA, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FD7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FD7 = {.cp = 0x1FD7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FD7, .cde = &lxb_unicode_decomposition_c_1FD7, .kde = &lxb_unicode_decomposition_k_1FD7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FD8[2] = {0x0399, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FD8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FD8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FD8[2] = {0x0399, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FD8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FD8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FD8[2] = {0x0399, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FD8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FD8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FD8 = {.cp = 0x1FD8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FD8, .cde = &lxb_unicode_decomposition_c_1FD8, .kde = &lxb_unicode_decomposition_k_1FD8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FD9[2] = {0x0399, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FD9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FD9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FD9[2] = {0x0399, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FD9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FD9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FD9[2] = {0x0399, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FD9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FD9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FD9 = {.cp = 0x1FD9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FD9, .cde = &lxb_unicode_decomposition_c_1FD9, .kde = &lxb_unicode_decomposition_k_1FD9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FDA[2] = {0x0399, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FDA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FDA[2] = {0x0399, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FDA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FDA[2] = {0x0399, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FDA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FDA = {.cp = 0x1FDA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FDA, .cde = &lxb_unicode_decomposition_c_1FDA, .kde = &lxb_unicode_decomposition_k_1FDA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FDB[2] = {0x0399, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FDB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FDB[2] = {0x0399, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FDB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FDB[1] = {0x038A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FDB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FDB = {.cp = 0x1FDB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FDB, .cde = &lxb_unicode_decomposition_c_1FDB, .kde = &lxb_unicode_decomposition_k_1FDB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FDD[2] = {0x1FFE, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FDD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FDD[3] = {0x0020, 0x0314, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FDD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FDD[2] = {0x1FFE, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FDD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FDD = {.cp = 0x1FDD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FDD, .cde = &lxb_unicode_decomposition_c_1FDD, .kde = &lxb_unicode_decomposition_k_1FDD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FDE[2] = {0x1FFE, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FDE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FDE[3] = {0x0020, 0x0314, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FDE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FDE[2] = {0x1FFE, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FDE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FDE = {.cp = 0x1FDE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FDE, .cde = &lxb_unicode_decomposition_c_1FDE, .kde = &lxb_unicode_decomposition_k_1FDE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FDF[2] = {0x1FFE, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FDF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FDF[3] = {0x0020, 0x0314, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FDF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FDF[2] = {0x1FFE, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FDF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FDF = {.cp = 0x1FDF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FDF, .cde = &lxb_unicode_decomposition_c_1FDF, .kde = &lxb_unicode_decomposition_k_1FDF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FE0[2] = {0x03C5, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FE0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FE0[2] = {0x03C5, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FE0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FE0[2] = {0x03C5, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FE0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FE0 = {.cp = 0x1FE0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FE0, .cde = &lxb_unicode_decomposition_c_1FE0, .kde = &lxb_unicode_decomposition_k_1FE0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FE1[2] = {0x03C5, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FE1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FE1[2] = {0x03C5, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FE1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FE1[2] = {0x03C5, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FE1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FE1 = {.cp = 0x1FE1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FE1, .cde = &lxb_unicode_decomposition_c_1FE1, .kde = &lxb_unicode_decomposition_k_1FE1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FE2[3] = {0x03C5, 0x0308, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FE2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FE2[3] = {0x03C5, 0x0308, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FE2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FE2[2] = {0x03CB, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FE2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FE2 = {.cp = 0x1FE2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FE2, .cde = &lxb_unicode_decomposition_c_1FE2, .kde = &lxb_unicode_decomposition_k_1FE2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FE3[3] = {0x03C5, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FE3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FE3[3] = {0x03C5, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FE3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FE3[1] = {0x03B0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FE3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FE3 = {.cp = 0x1FE3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FE3, .cde = &lxb_unicode_decomposition_c_1FE3, .kde = &lxb_unicode_decomposition_k_1FE3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FE4[2] = {0x03C1, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FE4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FE4[2] = {0x03C1, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FE4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FE4[2] = {0x03C1, 0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FE4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FE4 = {.cp = 0x1FE4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FE4, .cde = &lxb_unicode_decomposition_c_1FE4, .kde = &lxb_unicode_decomposition_k_1FE4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FE5[2] = {0x03C1, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FE5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FE5[2] = {0x03C1, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FE5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FE5[2] = {0x03C1, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FE5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FE5 = {.cp = 0x1FE5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FE5, .cde = &lxb_unicode_decomposition_c_1FE5, .kde = &lxb_unicode_decomposition_k_1FE5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FE6[2] = {0x03C5, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FE6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FE6[2] = {0x03C5, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FE6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FE6[2] = {0x03C5, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FE6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FE6 = {.cp = 0x1FE6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FE6, .cde = &lxb_unicode_decomposition_c_1FE6, .kde = &lxb_unicode_decomposition_k_1FE6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FE7[3] = {0x03C5, 0x0308, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FE7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FE7[3] = {0x03C5, 0x0308, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FE7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FE7[2] = {0x03CB, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FE7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FE7 = {.cp = 0x1FE7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FE7, .cde = &lxb_unicode_decomposition_c_1FE7, .kde = &lxb_unicode_decomposition_k_1FE7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FE8[2] = {0x03A5, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FE8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FE8[2] = {0x03A5, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FE8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FE8[2] = {0x03A5, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FE8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FE8 = {.cp = 0x1FE8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FE8, .cde = &lxb_unicode_decomposition_c_1FE8, .kde = &lxb_unicode_decomposition_k_1FE8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FE9[2] = {0x03A5, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FE9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FE9[2] = {0x03A5, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FE9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FE9[2] = {0x03A5, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FE9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FE9 = {.cp = 0x1FE9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FE9, .cde = &lxb_unicode_decomposition_c_1FE9, .kde = &lxb_unicode_decomposition_k_1FE9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FEA[2] = {0x03A5, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FEA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FEA[2] = {0x03A5, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FEA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FEA[2] = {0x03A5, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FEA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FEA = {.cp = 0x1FEA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FEA, .cde = &lxb_unicode_decomposition_c_1FEA, .kde = &lxb_unicode_decomposition_k_1FEA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FEB[2] = {0x03A5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FEB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FEB[2] = {0x03A5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FEB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FEB[1] = {0x038E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FEB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FEB = {.cp = 0x1FEB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FEB, .cde = &lxb_unicode_decomposition_c_1FEB, .kde = &lxb_unicode_decomposition_k_1FEB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FEC[2] = {0x03A1, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FEC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FEC[2] = {0x03A1, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FEC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FEC[2] = {0x03A1, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FEC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FEC = {.cp = 0x1FEC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FEC, .cde = &lxb_unicode_decomposition_c_1FEC, .kde = &lxb_unicode_decomposition_k_1FEC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FED[2] = {0x00A8, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FED, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FED[3] = {0x0020, 0x0308, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FED, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FED[2] = {0x00A8, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FED, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FED = {.cp = 0x1FED, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FED, .cde = &lxb_unicode_decomposition_c_1FED, .kde = &lxb_unicode_decomposition_k_1FED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FEE[2] = {0x00A8, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FEE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FEE[3] = {0x0020, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FEE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FEE[1] = {0x0385};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FEE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FEE = {.cp = 0x1FEE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FEE, .cde = &lxb_unicode_decomposition_c_1FEE, .kde = &lxb_unicode_decomposition_k_1FEE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FEF[1] = {0x0060};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FEF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FEF[1] = {0x0060};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FEF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FEF[1] = {0x0060};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FEF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FEF = {.cp = 0x1FEF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FEF, .cde = &lxb_unicode_decomposition_c_1FEF, .kde = &lxb_unicode_decomposition_k_1FEF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FF2[3] = {0x03C9, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FF2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FF2[3] = {0x03C9, 0x0300, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FF2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FF2[2] = {0x1F7C, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FF2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FF2 = {.cp = 0x1FF2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FF2, .cde = &lxb_unicode_decomposition_c_1FF2, .kde = &lxb_unicode_decomposition_k_1FF2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FF3[2] = {0x03C9, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FF3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FF3[2] = {0x03C9, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FF3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FF3[2] = {0x03C9, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FF3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FF3 = {.cp = 0x1FF3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FF3, .cde = &lxb_unicode_decomposition_c_1FF3, .kde = &lxb_unicode_decomposition_k_1FF3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FF4[3] = {0x03C9, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FF4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FF4[3] = {0x03C9, 0x0301, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FF4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FF4[2] = {0x03CE, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FF4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FF4 = {.cp = 0x1FF4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FF4, .cde = &lxb_unicode_decomposition_c_1FF4, .kde = &lxb_unicode_decomposition_k_1FF4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FF6[2] = {0x03C9, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FF6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FF6[2] = {0x03C9, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FF6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FF6[2] = {0x03C9, 0x0342};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FF6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FF6 = {.cp = 0x1FF6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FF6, .cde = &lxb_unicode_decomposition_c_1FF6, .kde = &lxb_unicode_decomposition_k_1FF6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FF7[3] = {0x03C9, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FF7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FF7[3] = {0x03C9, 0x0342, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FF7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FF7[2] = {0x1FF6, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FF7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FF7 = {.cp = 0x1FF7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FF7, .cde = &lxb_unicode_decomposition_c_1FF7, .kde = &lxb_unicode_decomposition_k_1FF7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FF8[2] = {0x039F, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FF8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FF8[2] = {0x039F, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FF8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FF8[2] = {0x039F, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FF8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FF8 = {.cp = 0x1FF8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FF8, .cde = &lxb_unicode_decomposition_c_1FF8, .kde = &lxb_unicode_decomposition_k_1FF8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FF9[2] = {0x039F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FF9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FF9[2] = {0x039F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FF9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FF9[1] = {0x038C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FF9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FF9 = {.cp = 0x1FF9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FF9, .cde = &lxb_unicode_decomposition_c_1FF9, .kde = &lxb_unicode_decomposition_k_1FF9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FFA[2] = {0x03A9, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FFA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FFA[2] = {0x03A9, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FFA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FFA[2] = {0x03A9, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FFA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FFA = {.cp = 0x1FFA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FFA, .cde = &lxb_unicode_decomposition_c_1FFA, .kde = &lxb_unicode_decomposition_k_1FFA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FFB[2] = {0x03A9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FFB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FFB[2] = {0x03A9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FFB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FFB[1] = {0x038F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FFB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FFB = {.cp = 0x1FFB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FFB, .cde = &lxb_unicode_decomposition_c_1FFB, .kde = &lxb_unicode_decomposition_k_1FFB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FFC[2] = {0x03A9, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FFC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FFC[2] = {0x03A9, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FFC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FFC[2] = {0x03A9, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FFC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FFC = {.cp = 0x1FFC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FFC, .cde = &lxb_unicode_decomposition_c_1FFC, .kde = &lxb_unicode_decomposition_k_1FFC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FFD[1] = {0x00B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FFD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1FFD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FFD[2] = {0x0020, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FFD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1FFD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FFD[1] = {0x00B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FFD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1FFD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1FFD = {.cp = 0x1FFD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FFD, .cde = &lxb_unicode_decomposition_c_1FFD, .kde = &lxb_unicode_decomposition_k_1FFD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1FFE[2] = {0x0020, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1FFE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_1FFE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1FFE[2] = {0x0020, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1FFE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_1FFE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1FFE[2] = {0x0020, 0x0314};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1FFE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__1FFE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1FFE = {.cp = 0x1FFE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1FFE, .cde = &lxb_unicode_decomposition_c_1FFE, .kde = &lxb_unicode_decomposition_k_1FFE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2000[1] = {0x2002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2000 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2000, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2000[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2000 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2000, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2000[1] = {0x2002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2000 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2000, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2000 = {.cp = 0x2000, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2000, .cde = &lxb_unicode_decomposition_c_2000, .kde = &lxb_unicode_decomposition_k_2000};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2001[1] = {0x2003};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2001 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2001, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2001[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2001 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2001, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2001[1] = {0x2003};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2001 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2001, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2001 = {.cp = 0x2001, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2001, .cde = &lxb_unicode_decomposition_c_2001, .kde = &lxb_unicode_decomposition_k_2001};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2002[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2002 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2002, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2002[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2002 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2002, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2002[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2002 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2002, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2002 = {.cp = 0x2002, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2002, .cde = &lxb_unicode_decomposition_c_2002, .kde = &lxb_unicode_decomposition_k_2002};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2003[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2003 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2003, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2003[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2003 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2003, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2003[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2003 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2003, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2003 = {.cp = 0x2003, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2003, .cde = &lxb_unicode_decomposition_c_2003, .kde = &lxb_unicode_decomposition_k_2003};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2004[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2004 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2004, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2004[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2004 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2004, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2004[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2004 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2004, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2004 = {.cp = 0x2004, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2004, .cde = &lxb_unicode_decomposition_c_2004, .kde = &lxb_unicode_decomposition_k_2004};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2005[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2005 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2005, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2005[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2005 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2005, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2005[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2005 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2005, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2005 = {.cp = 0x2005, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2005, .cde = &lxb_unicode_decomposition_c_2005, .kde = &lxb_unicode_decomposition_k_2005};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2006[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2006 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2006, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2006[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2006 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2006, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2006[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2006 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2006, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2006 = {.cp = 0x2006, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2006, .cde = &lxb_unicode_decomposition_c_2006, .kde = &lxb_unicode_decomposition_k_2006};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2007[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2007 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp_c_2007, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2007[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2007 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp_k_2007, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2007[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2007 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp__2007, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2007 = {.cp = 0x2007, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2007, .cde = &lxb_unicode_decomposition_c_2007, .kde = &lxb_unicode_decomposition_k_2007};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2008[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2008 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2008, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2008[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2008 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2008, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2008[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2008 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2008, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2008 = {.cp = 0x2008, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2008, .cde = &lxb_unicode_decomposition_c_2008, .kde = &lxb_unicode_decomposition_k_2008};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2009[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2009 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2009, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2009[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2009 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2009, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2009[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2009 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2009, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2009 = {.cp = 0x2009, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2009, .cde = &lxb_unicode_decomposition_c_2009, .kde = &lxb_unicode_decomposition_k_2009};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_200A[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_200A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_200A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_200A[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_200A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_200A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__200A[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__200A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__200A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_200A = {.cp = 0x200A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__200A, .cde = &lxb_unicode_decomposition_c_200A, .kde = &lxb_unicode_decomposition_k_200A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2011[1] = {0x2010};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2011 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp_c_2011, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2011[1] = {0x2010};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2011 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp_k_2011, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2011[1] = {0x2010};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2011 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp__2011, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2011 = {.cp = 0x2011, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2011, .cde = &lxb_unicode_decomposition_c_2011, .kde = &lxb_unicode_decomposition_k_2011};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2017[2] = {0x0020, 0x0333};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2017 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2017, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2017[2] = {0x0020, 0x0333};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2017 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2017, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2017[2] = {0x0020, 0x0333};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2017 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2017, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2017 = {.cp = 0x2017, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2017, .cde = &lxb_unicode_decomposition_c_2017, .kde = &lxb_unicode_decomposition_k_2017};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2024[1] = {0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2024 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2024, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2024[1] = {0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2024 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2024, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2024[1] = {0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2024 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2024, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2024 = {.cp = 0x2024, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2024, .cde = &lxb_unicode_decomposition_c_2024, .kde = &lxb_unicode_decomposition_k_2024};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2025[2] = {0x002E, 0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2025 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2025, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2025[2] = {0x002E, 0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2025 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2025, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2025[2] = {0x002E, 0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2025 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2025, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2025 = {.cp = 0x2025, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2025, .cde = &lxb_unicode_decomposition_c_2025, .kde = &lxb_unicode_decomposition_k_2025};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2026[3] = {0x002E, 0x002E, 0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2026 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2026, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2026[3] = {0x002E, 0x002E, 0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2026 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2026, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2026[3] = {0x002E, 0x002E, 0x002E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2026 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2026, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2026 = {.cp = 0x2026, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2026, .cde = &lxb_unicode_decomposition_c_2026, .kde = &lxb_unicode_decomposition_k_2026};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_202F[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_202F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp_c_202F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_202F[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_202F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp_k_202F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__202F[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__202F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp__202F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_202F = {.cp = 0x202F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__202F, .cde = &lxb_unicode_decomposition_c_202F, .kde = &lxb_unicode_decomposition_k_202F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2033[2] = {0x2032, 0x2032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2033 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2033, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2033[2] = {0x2032, 0x2032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2033 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2033, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2033[2] = {0x2032, 0x2032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2033 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2033, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2033 = {.cp = 0x2033, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2033, .cde = &lxb_unicode_decomposition_c_2033, .kde = &lxb_unicode_decomposition_k_2033};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2034[3] = {0x2032, 0x2032, 0x2032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2034 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2034, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2034[3] = {0x2032, 0x2032, 0x2032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2034 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2034, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2034[3] = {0x2032, 0x2032, 0x2032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2034 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2034, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2034 = {.cp = 0x2034, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2034, .cde = &lxb_unicode_decomposition_c_2034, .kde = &lxb_unicode_decomposition_k_2034};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2036[2] = {0x2035, 0x2035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2036 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2036, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2036[2] = {0x2035, 0x2035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2036 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2036, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2036[2] = {0x2035, 0x2035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2036 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2036, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2036 = {.cp = 0x2036, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2036, .cde = &lxb_unicode_decomposition_c_2036, .kde = &lxb_unicode_decomposition_k_2036};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2037[3] = {0x2035, 0x2035, 0x2035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2037 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2037, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2037[3] = {0x2035, 0x2035, 0x2035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2037 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2037, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2037[3] = {0x2035, 0x2035, 0x2035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2037 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2037, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2037 = {.cp = 0x2037, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2037, .cde = &lxb_unicode_decomposition_c_2037, .kde = &lxb_unicode_decomposition_k_2037};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_203C[2] = {0x0021, 0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_203C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_203C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_203C[2] = {0x0021, 0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_203C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_203C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__203C[2] = {0x0021, 0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__203C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__203C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_203C = {.cp = 0x203C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__203C, .cde = &lxb_unicode_decomposition_c_203C, .kde = &lxb_unicode_decomposition_k_203C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_203E[2] = {0x0020, 0x0305};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_203E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_203E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_203E[2] = {0x0020, 0x0305};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_203E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_203E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__203E[2] = {0x0020, 0x0305};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__203E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__203E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_203E = {.cp = 0x203E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__203E, .cde = &lxb_unicode_decomposition_c_203E, .kde = &lxb_unicode_decomposition_k_203E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2047[2] = {0x003F, 0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2047 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2047, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2047[2] = {0x003F, 0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2047 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2047, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2047[2] = {0x003F, 0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2047 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2047, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2047 = {.cp = 0x2047, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2047, .cde = &lxb_unicode_decomposition_c_2047, .kde = &lxb_unicode_decomposition_k_2047};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2048[2] = {0x003F, 0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2048 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2048, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2048[2] = {0x003F, 0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2048 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2048, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2048[2] = {0x003F, 0x0021};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2048 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2048, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2048 = {.cp = 0x2048, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2048, .cde = &lxb_unicode_decomposition_c_2048, .kde = &lxb_unicode_decomposition_k_2048};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2049[2] = {0x0021, 0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2049 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2049, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2049[2] = {0x0021, 0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2049 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2049, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2049[2] = {0x0021, 0x003F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2049 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2049, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2049 = {.cp = 0x2049, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2049, .cde = &lxb_unicode_decomposition_c_2049, .kde = &lxb_unicode_decomposition_k_2049};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2057[4] = {0x2032, 0x2032, 0x2032, 0x2032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2057 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2057, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2057[4] = {0x2032, 0x2032, 0x2032, 0x2032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2057 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2057, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2057[4] = {0x2032, 0x2032, 0x2032, 0x2032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2057 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2057, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_2057 = {.cp = 0x2057, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2057, .cde = &lxb_unicode_decomposition_c_2057, .kde = &lxb_unicode_decomposition_k_2057};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_205F[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_205F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_205F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_205F[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_205F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_205F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__205F[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__205F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__205F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_205F = {.cp = 0x205F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__205F, .cde = &lxb_unicode_decomposition_c_205F, .kde = &lxb_unicode_decomposition_k_205F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2070[1] = {0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2070 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2070, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2070[1] = {0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2070 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2070, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2070[1] = {0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2070 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2070, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2070 = {.cp = 0x2070, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2070, .cde = &lxb_unicode_decomposition_c_2070, .kde = &lxb_unicode_decomposition_k_2070};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2071[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2071 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2071, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2071[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2071 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2071, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2071[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2071 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2071, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2071 = {.cp = 0x2071, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2071, .cde = &lxb_unicode_decomposition_c_2071, .kde = &lxb_unicode_decomposition_k_2071};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2074[1] = {0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2074 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2074, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2074[1] = {0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2074 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2074, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2074[1] = {0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2074 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2074, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2074 = {.cp = 0x2074, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2074, .cde = &lxb_unicode_decomposition_c_2074, .kde = &lxb_unicode_decomposition_k_2074};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2075[1] = {0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2075 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2075, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2075[1] = {0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2075 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2075, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2075[1] = {0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2075 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2075, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2075 = {.cp = 0x2075, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2075, .cde = &lxb_unicode_decomposition_c_2075, .kde = &lxb_unicode_decomposition_k_2075};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2076[1] = {0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2076 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2076, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2076[1] = {0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2076 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2076, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2076[1] = {0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2076 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2076, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2076 = {.cp = 0x2076, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2076, .cde = &lxb_unicode_decomposition_c_2076, .kde = &lxb_unicode_decomposition_k_2076};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2077[1] = {0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2077 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2077, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2077[1] = {0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2077 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2077, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2077[1] = {0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2077 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2077, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2077 = {.cp = 0x2077, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2077, .cde = &lxb_unicode_decomposition_c_2077, .kde = &lxb_unicode_decomposition_k_2077};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2078[1] = {0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2078 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2078, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2078[1] = {0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2078 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2078, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2078[1] = {0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2078 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2078, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2078 = {.cp = 0x2078, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2078, .cde = &lxb_unicode_decomposition_c_2078, .kde = &lxb_unicode_decomposition_k_2078};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2079[1] = {0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2079 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2079, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2079[1] = {0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2079 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2079, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2079[1] = {0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2079 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2079, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2079 = {.cp = 0x2079, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2079, .cde = &lxb_unicode_decomposition_c_2079, .kde = &lxb_unicode_decomposition_k_2079};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_207A[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_207A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_207A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_207A[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_207A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_207A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__207A[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__207A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__207A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_207A = {.cp = 0x207A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__207A, .cde = &lxb_unicode_decomposition_c_207A, .kde = &lxb_unicode_decomposition_k_207A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_207B[1] = {0x2212};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_207B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_207B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_207B[1] = {0x2212};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_207B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_207B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__207B[1] = {0x2212};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__207B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__207B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_207B = {.cp = 0x207B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__207B, .cde = &lxb_unicode_decomposition_c_207B, .kde = &lxb_unicode_decomposition_k_207B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_207C[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_207C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_207C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_207C[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_207C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_207C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__207C[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__207C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__207C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_207C = {.cp = 0x207C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__207C, .cde = &lxb_unicode_decomposition_c_207C, .kde = &lxb_unicode_decomposition_k_207C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_207D[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_207D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_207D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_207D[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_207D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_207D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__207D[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__207D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__207D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_207D = {.cp = 0x207D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__207D, .cde = &lxb_unicode_decomposition_c_207D, .kde = &lxb_unicode_decomposition_k_207D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_207E[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_207E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_207E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_207E[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_207E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_207E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__207E[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__207E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__207E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_207E = {.cp = 0x207E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__207E, .cde = &lxb_unicode_decomposition_c_207E, .kde = &lxb_unicode_decomposition_k_207E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_207F[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_207F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_207F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_207F[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_207F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_207F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__207F[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__207F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__207F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_207F = {.cp = 0x207F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__207F, .cde = &lxb_unicode_decomposition_c_207F, .kde = &lxb_unicode_decomposition_k_207F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2080[1] = {0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2080 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2080, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2080[1] = {0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2080 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2080, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2080[1] = {0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2080 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2080, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2080 = {.cp = 0x2080, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2080, .cde = &lxb_unicode_decomposition_c_2080, .kde = &lxb_unicode_decomposition_k_2080};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2081[1] = {0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2081 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2081, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2081[1] = {0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2081 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2081, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2081[1] = {0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2081 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2081, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2081 = {.cp = 0x2081, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2081, .cde = &lxb_unicode_decomposition_c_2081, .kde = &lxb_unicode_decomposition_k_2081};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2082[1] = {0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2082 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2082, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2082[1] = {0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2082 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2082, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2082[1] = {0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2082 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2082, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2082 = {.cp = 0x2082, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2082, .cde = &lxb_unicode_decomposition_c_2082, .kde = &lxb_unicode_decomposition_k_2082};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2083[1] = {0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2083 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2083, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2083[1] = {0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2083 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2083, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2083[1] = {0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2083 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2083, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2083 = {.cp = 0x2083, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2083, .cde = &lxb_unicode_decomposition_c_2083, .kde = &lxb_unicode_decomposition_k_2083};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2084[1] = {0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2084 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2084, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2084[1] = {0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2084 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2084, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2084[1] = {0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2084 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2084, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2084 = {.cp = 0x2084, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2084, .cde = &lxb_unicode_decomposition_c_2084, .kde = &lxb_unicode_decomposition_k_2084};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2085[1] = {0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2085 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2085, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2085[1] = {0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2085 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2085, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2085[1] = {0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2085 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2085, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2085 = {.cp = 0x2085, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2085, .cde = &lxb_unicode_decomposition_c_2085, .kde = &lxb_unicode_decomposition_k_2085};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2086[1] = {0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2086 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2086, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2086[1] = {0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2086 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2086, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2086[1] = {0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2086 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2086, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2086 = {.cp = 0x2086, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2086, .cde = &lxb_unicode_decomposition_c_2086, .kde = &lxb_unicode_decomposition_k_2086};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2087[1] = {0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2087 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2087, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2087[1] = {0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2087 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2087, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2087[1] = {0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2087 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2087, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2087 = {.cp = 0x2087, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2087, .cde = &lxb_unicode_decomposition_c_2087, .kde = &lxb_unicode_decomposition_k_2087};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2088[1] = {0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2088 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2088, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2088[1] = {0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2088 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2088, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2088[1] = {0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2088 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2088, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2088 = {.cp = 0x2088, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2088, .cde = &lxb_unicode_decomposition_c_2088, .kde = &lxb_unicode_decomposition_k_2088};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2089[1] = {0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2089 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2089, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2089[1] = {0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2089 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2089, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2089[1] = {0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2089 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2089, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2089 = {.cp = 0x2089, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2089, .cde = &lxb_unicode_decomposition_c_2089, .kde = &lxb_unicode_decomposition_k_2089};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_208A[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_208A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_208A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_208A[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_208A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_208A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__208A[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__208A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__208A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_208A = {.cp = 0x208A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__208A, .cde = &lxb_unicode_decomposition_c_208A, .kde = &lxb_unicode_decomposition_k_208A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_208B[1] = {0x2212};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_208B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_208B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_208B[1] = {0x2212};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_208B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_208B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__208B[1] = {0x2212};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__208B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__208B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_208B = {.cp = 0x208B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__208B, .cde = &lxb_unicode_decomposition_c_208B, .kde = &lxb_unicode_decomposition_k_208B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_208C[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_208C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_208C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_208C[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_208C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_208C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__208C[1] = {0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__208C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__208C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_208C = {.cp = 0x208C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__208C, .cde = &lxb_unicode_decomposition_c_208C, .kde = &lxb_unicode_decomposition_k_208C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_208D[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_208D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_208D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_208D[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_208D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_208D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__208D[1] = {0x0028};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__208D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__208D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_208D = {.cp = 0x208D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__208D, .cde = &lxb_unicode_decomposition_c_208D, .kde = &lxb_unicode_decomposition_k_208D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_208E[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_208E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_208E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_208E[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_208E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_208E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__208E[1] = {0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__208E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__208E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_208E = {.cp = 0x208E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__208E, .cde = &lxb_unicode_decomposition_c_208E, .kde = &lxb_unicode_decomposition_k_208E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2090[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2090 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2090, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2090[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2090 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2090, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2090[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2090 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2090, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2090 = {.cp = 0x2090, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2090, .cde = &lxb_unicode_decomposition_c_2090, .kde = &lxb_unicode_decomposition_k_2090};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2091[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2091 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2091, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2091[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2091 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2091, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2091[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2091 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2091, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2091 = {.cp = 0x2091, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2091, .cde = &lxb_unicode_decomposition_c_2091, .kde = &lxb_unicode_decomposition_k_2091};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2092[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2092 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2092, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2092[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2092 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2092, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2092[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2092 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2092, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2092 = {.cp = 0x2092, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2092, .cde = &lxb_unicode_decomposition_c_2092, .kde = &lxb_unicode_decomposition_k_2092};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2093[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2093 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2093, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2093[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2093 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2093, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2093[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2093 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2093, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2093 = {.cp = 0x2093, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2093, .cde = &lxb_unicode_decomposition_c_2093, .kde = &lxb_unicode_decomposition_k_2093};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2094[1] = {0x0259};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2094 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2094, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2094[1] = {0x0259};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2094 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2094, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2094[1] = {0x0259};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2094 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2094, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2094 = {.cp = 0x2094, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2094, .cde = &lxb_unicode_decomposition_c_2094, .kde = &lxb_unicode_decomposition_k_2094};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2095[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2095 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2095, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2095[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2095 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2095, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2095[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2095 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2095, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2095 = {.cp = 0x2095, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2095, .cde = &lxb_unicode_decomposition_c_2095, .kde = &lxb_unicode_decomposition_k_2095};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2096[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2096 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2096, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2096[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2096 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2096, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2096[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2096 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2096, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2096 = {.cp = 0x2096, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2096, .cde = &lxb_unicode_decomposition_c_2096, .kde = &lxb_unicode_decomposition_k_2096};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2097[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2097 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2097, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2097[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2097 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2097, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2097[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2097 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2097, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2097 = {.cp = 0x2097, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2097, .cde = &lxb_unicode_decomposition_c_2097, .kde = &lxb_unicode_decomposition_k_2097};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2098[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2098 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2098, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2098[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2098 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2098, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2098[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2098 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2098, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2098 = {.cp = 0x2098, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2098, .cde = &lxb_unicode_decomposition_c_2098, .kde = &lxb_unicode_decomposition_k_2098};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2099[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2099 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2099, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2099[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2099 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2099, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2099[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2099 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2099, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2099 = {.cp = 0x2099, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2099, .cde = &lxb_unicode_decomposition_c_2099, .kde = &lxb_unicode_decomposition_k_2099};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_209A[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_209A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_209A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_209A[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_209A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_209A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__209A[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__209A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__209A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_209A = {.cp = 0x209A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__209A, .cde = &lxb_unicode_decomposition_c_209A, .kde = &lxb_unicode_decomposition_k_209A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_209B[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_209B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_209B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_209B[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_209B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_209B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__209B[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__209B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__209B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_209B = {.cp = 0x209B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__209B, .cde = &lxb_unicode_decomposition_c_209B, .kde = &lxb_unicode_decomposition_k_209B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_209C[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_209C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_209C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_209C[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_209C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_209C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__209C[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__209C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__209C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_209C = {.cp = 0x209C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__209C, .cde = &lxb_unicode_decomposition_c_209C, .kde = &lxb_unicode_decomposition_k_209C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_20A8[2] = {0x0052, 0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_20A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_20A8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_20A8[2] = {0x0052, 0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_20A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_20A8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__20A8[2] = {0x0052, 0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__20A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__20A8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_20A8 = {.cp = 0x20A8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__20A8, .cde = &lxb_unicode_decomposition_c_20A8, .kde = &lxb_unicode_decomposition_k_20A8};

static const lxb_unicode_entry_t lxb_unicode_entry_20D0 = {.cp = 0x20D0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20D1 = {.cp = 0x20D1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20D2 = {.cp = 0x20D2, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20D3 = {.cp = 0x20D3, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20D4 = {.cp = 0x20D4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20D5 = {.cp = 0x20D5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20D6 = {.cp = 0x20D6, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20D7 = {.cp = 0x20D7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20D8 = {.cp = 0x20D8, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20D9 = {.cp = 0x20D9, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20DA = {.cp = 0x20DA, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20DB = {.cp = 0x20DB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20DC = {.cp = 0x20DC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20E1 = {.cp = 0x20E1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20E5 = {.cp = 0x20E5, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20E6 = {.cp = 0x20E6, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20E7 = {.cp = 0x20E7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20E8 = {.cp = 0x20E8, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20E9 = {.cp = 0x20E9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20EA = {.cp = 0x20EA, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20EB = {.cp = 0x20EB, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20EC = {.cp = 0x20EC, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20ED = {.cp = 0x20ED, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20EE = {.cp = 0x20EE, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20EF = {.cp = 0x20EF, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_20F0 = {.cp = 0x20F0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2100[3] = {0x0061, 0x002F, 0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2100 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2100, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2100[3] = {0x0061, 0x002F, 0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2100 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2100, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2100[3] = {0x0061, 0x002F, 0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2100 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2100, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2100 = {.cp = 0x2100, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2100, .cde = &lxb_unicode_decomposition_c_2100, .kde = &lxb_unicode_decomposition_k_2100};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2101[3] = {0x0061, 0x002F, 0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2101 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2101, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2101[3] = {0x0061, 0x002F, 0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2101 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2101, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2101[3] = {0x0061, 0x002F, 0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2101 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2101, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2101 = {.cp = 0x2101, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2101, .cde = &lxb_unicode_decomposition_c_2101, .kde = &lxb_unicode_decomposition_k_2101};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2102[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2102 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2102, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2102[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2102 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2102, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2102[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2102 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2102, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2102 = {.cp = 0x2102, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2102, .cde = &lxb_unicode_decomposition_c_2102, .kde = &lxb_unicode_decomposition_k_2102};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2103[2] = {0x00B0, 0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2103 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2103, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2103[2] = {0x00B0, 0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2103 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2103, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2103[2] = {0x00B0, 0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2103 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2103, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2103 = {.cp = 0x2103, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2103, .cde = &lxb_unicode_decomposition_c_2103, .kde = &lxb_unicode_decomposition_k_2103};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2105[3] = {0x0063, 0x002F, 0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2105 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2105, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2105[3] = {0x0063, 0x002F, 0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2105 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2105, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2105[3] = {0x0063, 0x002F, 0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2105 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2105, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2105 = {.cp = 0x2105, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2105, .cde = &lxb_unicode_decomposition_c_2105, .kde = &lxb_unicode_decomposition_k_2105};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2106[3] = {0x0063, 0x002F, 0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2106 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2106, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2106[3] = {0x0063, 0x002F, 0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2106 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2106, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2106[3] = {0x0063, 0x002F, 0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2106 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2106, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2106 = {.cp = 0x2106, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2106, .cde = &lxb_unicode_decomposition_c_2106, .kde = &lxb_unicode_decomposition_k_2106};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2107[1] = {0x0190};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2107 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2107, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2107[1] = {0x0190};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2107 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2107, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2107[1] = {0x0190};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2107 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2107, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2107 = {.cp = 0x2107, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2107, .cde = &lxb_unicode_decomposition_c_2107, .kde = &lxb_unicode_decomposition_k_2107};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2109[2] = {0x00B0, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2109 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2109, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2109[2] = {0x00B0, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2109 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2109, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2109[2] = {0x00B0, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2109 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2109, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2109 = {.cp = 0x2109, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2109, .cde = &lxb_unicode_decomposition_c_2109, .kde = &lxb_unicode_decomposition_k_2109};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_210A[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_210A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_210A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_210A[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_210A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_210A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__210A[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__210A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__210A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_210A = {.cp = 0x210A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__210A, .cde = &lxb_unicode_decomposition_c_210A, .kde = &lxb_unicode_decomposition_k_210A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_210B[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_210B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_210B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_210B[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_210B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_210B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__210B[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__210B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__210B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_210B = {.cp = 0x210B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__210B, .cde = &lxb_unicode_decomposition_c_210B, .kde = &lxb_unicode_decomposition_k_210B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_210C[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_210C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_210C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_210C[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_210C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_210C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__210C[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__210C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__210C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_210C = {.cp = 0x210C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__210C, .cde = &lxb_unicode_decomposition_c_210C, .kde = &lxb_unicode_decomposition_k_210C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_210D[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_210D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_210D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_210D[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_210D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_210D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__210D[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__210D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__210D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_210D = {.cp = 0x210D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__210D, .cde = &lxb_unicode_decomposition_c_210D, .kde = &lxb_unicode_decomposition_k_210D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_210E[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_210E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_210E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_210E[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_210E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_210E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__210E[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__210E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__210E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_210E = {.cp = 0x210E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__210E, .cde = &lxb_unicode_decomposition_c_210E, .kde = &lxb_unicode_decomposition_k_210E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_210F[1] = {0x0127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_210F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_210F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_210F[1] = {0x0127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_210F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_210F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__210F[1] = {0x0127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__210F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__210F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_210F = {.cp = 0x210F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__210F, .cde = &lxb_unicode_decomposition_c_210F, .kde = &lxb_unicode_decomposition_k_210F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2110[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2110 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2110, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2110[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2110 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2110, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2110[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2110 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2110, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2110 = {.cp = 0x2110, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2110, .cde = &lxb_unicode_decomposition_c_2110, .kde = &lxb_unicode_decomposition_k_2110};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2111[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2111 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2111, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2111[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2111 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2111, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2111[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2111 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2111, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2111 = {.cp = 0x2111, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2111, .cde = &lxb_unicode_decomposition_c_2111, .kde = &lxb_unicode_decomposition_k_2111};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2112[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2112 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2112, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2112[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2112 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2112, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2112[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2112 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2112, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2112 = {.cp = 0x2112, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2112, .cde = &lxb_unicode_decomposition_c_2112, .kde = &lxb_unicode_decomposition_k_2112};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2113[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2113 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2113, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2113[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2113 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2113, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2113[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2113 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2113, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2113 = {.cp = 0x2113, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2113, .cde = &lxb_unicode_decomposition_c_2113, .kde = &lxb_unicode_decomposition_k_2113};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2115[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2115 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2115, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2115[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2115 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2115, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2115[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2115 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2115, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2115 = {.cp = 0x2115, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2115, .cde = &lxb_unicode_decomposition_c_2115, .kde = &lxb_unicode_decomposition_k_2115};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2116[2] = {0x004E, 0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2116 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2116, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2116[2] = {0x004E, 0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2116 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2116, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2116[2] = {0x004E, 0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2116 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2116, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2116 = {.cp = 0x2116, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2116, .cde = &lxb_unicode_decomposition_c_2116, .kde = &lxb_unicode_decomposition_k_2116};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2119[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2119 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2119, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2119[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2119 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2119, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2119[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2119 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2119, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2119 = {.cp = 0x2119, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2119, .cde = &lxb_unicode_decomposition_c_2119, .kde = &lxb_unicode_decomposition_k_2119};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_211A[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_211A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_211A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_211A[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_211A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_211A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__211A[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__211A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__211A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_211A = {.cp = 0x211A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__211A, .cde = &lxb_unicode_decomposition_c_211A, .kde = &lxb_unicode_decomposition_k_211A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_211B[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_211B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_211B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_211B[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_211B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_211B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__211B[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__211B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__211B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_211B = {.cp = 0x211B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__211B, .cde = &lxb_unicode_decomposition_c_211B, .kde = &lxb_unicode_decomposition_k_211B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_211C[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_211C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_211C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_211C[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_211C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_211C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__211C[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__211C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__211C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_211C = {.cp = 0x211C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__211C, .cde = &lxb_unicode_decomposition_c_211C, .kde = &lxb_unicode_decomposition_k_211C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_211D[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_211D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_211D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_211D[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_211D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_211D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__211D[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__211D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__211D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_211D = {.cp = 0x211D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__211D, .cde = &lxb_unicode_decomposition_c_211D, .kde = &lxb_unicode_decomposition_k_211D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2120[2] = {0x0053, 0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2120 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2120, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2120[2] = {0x0053, 0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2120 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2120, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2120[2] = {0x0053, 0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2120 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2120, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2120 = {.cp = 0x2120, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2120, .cde = &lxb_unicode_decomposition_c_2120, .kde = &lxb_unicode_decomposition_k_2120};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2121[3] = {0x0054, 0x0045, 0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2121 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2121, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2121[3] = {0x0054, 0x0045, 0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2121 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2121, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2121[3] = {0x0054, 0x0045, 0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2121 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2121, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2121 = {.cp = 0x2121, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2121, .cde = &lxb_unicode_decomposition_c_2121, .kde = &lxb_unicode_decomposition_k_2121};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2122[2] = {0x0054, 0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2122 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2122, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2122[2] = {0x0054, 0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2122 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2122, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2122[2] = {0x0054, 0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2122 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2122, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2122 = {.cp = 0x2122, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2122, .cde = &lxb_unicode_decomposition_c_2122, .kde = &lxb_unicode_decomposition_k_2122};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2124[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2124 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2124, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2124[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2124 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2124, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2124[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2124 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2124, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2124 = {.cp = 0x2124, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2124, .cde = &lxb_unicode_decomposition_c_2124, .kde = &lxb_unicode_decomposition_k_2124};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2126[1] = {0x03A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2126 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2126, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2126[1] = {0x03A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2126 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2126, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2126[1] = {0x03A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2126 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2126, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2126 = {.cp = 0x2126, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2126, .cde = &lxb_unicode_decomposition_c_2126, .kde = &lxb_unicode_decomposition_k_2126};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2128[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2128 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2128, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2128[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2128 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2128, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2128[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2128 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2128, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2128 = {.cp = 0x2128, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2128, .cde = &lxb_unicode_decomposition_c_2128, .kde = &lxb_unicode_decomposition_k_2128};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_212A[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_212A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_212A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_212A[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_212A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_212A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__212A[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__212A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__212A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_212A = {.cp = 0x212A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__212A, .cde = &lxb_unicode_decomposition_c_212A, .kde = &lxb_unicode_decomposition_k_212A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_212B[2] = {0x0041, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_212B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_212B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_212B[2] = {0x0041, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_212B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_212B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__212B[1] = {0x00C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__212B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__212B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_212B = {.cp = 0x212B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__212B, .cde = &lxb_unicode_decomposition_c_212B, .kde = &lxb_unicode_decomposition_k_212B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_212C[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_212C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_212C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_212C[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_212C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_212C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__212C[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__212C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__212C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_212C = {.cp = 0x212C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__212C, .cde = &lxb_unicode_decomposition_c_212C, .kde = &lxb_unicode_decomposition_k_212C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_212D[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_212D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_212D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_212D[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_212D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_212D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__212D[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__212D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__212D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_212D = {.cp = 0x212D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__212D, .cde = &lxb_unicode_decomposition_c_212D, .kde = &lxb_unicode_decomposition_k_212D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_212F[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_212F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_212F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_212F[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_212F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_212F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__212F[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__212F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__212F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_212F = {.cp = 0x212F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__212F, .cde = &lxb_unicode_decomposition_c_212F, .kde = &lxb_unicode_decomposition_k_212F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2130[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2130 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2130, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2130[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2130 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2130, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2130[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2130 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2130, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2130 = {.cp = 0x2130, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2130, .cde = &lxb_unicode_decomposition_c_2130, .kde = &lxb_unicode_decomposition_k_2130};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2131[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2131 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2131, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2131[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2131 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2131, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2131[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2131 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2131, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2131 = {.cp = 0x2131, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2131, .cde = &lxb_unicode_decomposition_c_2131, .kde = &lxb_unicode_decomposition_k_2131};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2133[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2133 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2133, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2133[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2133 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2133, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2133[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2133 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2133, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2133 = {.cp = 0x2133, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2133, .cde = &lxb_unicode_decomposition_c_2133, .kde = &lxb_unicode_decomposition_k_2133};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2134[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2134 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2134, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2134[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2134 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2134, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2134[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2134 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2134, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2134 = {.cp = 0x2134, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2134, .cde = &lxb_unicode_decomposition_c_2134, .kde = &lxb_unicode_decomposition_k_2134};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2135[1] = {0x05D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2135 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2135, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2135[1] = {0x05D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2135 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2135, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2135[1] = {0x05D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2135 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2135, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2135 = {.cp = 0x2135, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2135, .cde = &lxb_unicode_decomposition_c_2135, .kde = &lxb_unicode_decomposition_k_2135};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2136[1] = {0x05D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2136 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2136, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2136[1] = {0x05D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2136 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2136, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2136[1] = {0x05D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2136 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2136, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2136 = {.cp = 0x2136, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2136, .cde = &lxb_unicode_decomposition_c_2136, .kde = &lxb_unicode_decomposition_k_2136};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2137[1] = {0x05D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2137 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2137, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2137[1] = {0x05D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2137 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2137, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2137[1] = {0x05D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2137 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2137, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2137 = {.cp = 0x2137, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2137, .cde = &lxb_unicode_decomposition_c_2137, .kde = &lxb_unicode_decomposition_k_2137};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2138[1] = {0x05D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2138 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2138, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2138[1] = {0x05D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2138 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2138, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2138[1] = {0x05D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2138 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2138, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2138 = {.cp = 0x2138, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2138, .cde = &lxb_unicode_decomposition_c_2138, .kde = &lxb_unicode_decomposition_k_2138};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2139[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2139 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2139, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2139[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2139 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2139, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2139[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2139 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2139, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2139 = {.cp = 0x2139, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2139, .cde = &lxb_unicode_decomposition_c_2139, .kde = &lxb_unicode_decomposition_k_2139};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_213B[3] = {0x0046, 0x0041, 0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_213B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_213B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_213B[3] = {0x0046, 0x0041, 0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_213B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_213B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__213B[3] = {0x0046, 0x0041, 0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__213B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__213B, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_213B = {.cp = 0x213B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__213B, .cde = &lxb_unicode_decomposition_c_213B, .kde = &lxb_unicode_decomposition_k_213B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_213C[1] = {0x03C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_213C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_213C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_213C[1] = {0x03C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_213C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_213C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__213C[1] = {0x03C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__213C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__213C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_213C = {.cp = 0x213C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__213C, .cde = &lxb_unicode_decomposition_c_213C, .kde = &lxb_unicode_decomposition_k_213C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_213D[1] = {0x03B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_213D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_213D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_213D[1] = {0x03B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_213D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_213D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__213D[1] = {0x03B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__213D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__213D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_213D = {.cp = 0x213D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__213D, .cde = &lxb_unicode_decomposition_c_213D, .kde = &lxb_unicode_decomposition_k_213D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_213E[1] = {0x0393};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_213E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_213E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_213E[1] = {0x0393};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_213E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_213E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__213E[1] = {0x0393};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__213E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__213E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_213E = {.cp = 0x213E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__213E, .cde = &lxb_unicode_decomposition_c_213E, .kde = &lxb_unicode_decomposition_k_213E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_213F[1] = {0x03A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_213F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_213F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_213F[1] = {0x03A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_213F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_213F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__213F[1] = {0x03A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__213F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__213F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_213F = {.cp = 0x213F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__213F, .cde = &lxb_unicode_decomposition_c_213F, .kde = &lxb_unicode_decomposition_k_213F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2140[1] = {0x2211};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2140 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2140, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2140[1] = {0x2211};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2140 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2140, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2140[1] = {0x2211};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2140 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2140, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2140 = {.cp = 0x2140, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2140, .cde = &lxb_unicode_decomposition_c_2140, .kde = &lxb_unicode_decomposition_k_2140};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2145[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2145 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2145, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2145[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2145 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2145, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2145[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2145 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2145, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2145 = {.cp = 0x2145, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2145, .cde = &lxb_unicode_decomposition_c_2145, .kde = &lxb_unicode_decomposition_k_2145};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2146[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2146 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2146, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2146[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2146 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2146, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2146[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2146 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2146, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2146 = {.cp = 0x2146, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2146, .cde = &lxb_unicode_decomposition_c_2146, .kde = &lxb_unicode_decomposition_k_2146};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2147[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2147 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2147, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2147[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2147 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2147, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2147[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2147 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2147, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2147 = {.cp = 0x2147, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2147, .cde = &lxb_unicode_decomposition_c_2147, .kde = &lxb_unicode_decomposition_k_2147};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2148[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2148 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2148, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2148[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2148 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2148, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2148[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2148 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2148, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2148 = {.cp = 0x2148, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2148, .cde = &lxb_unicode_decomposition_c_2148, .kde = &lxb_unicode_decomposition_k_2148};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2149[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2149 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_2149, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2149[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2149 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_2149, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2149[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2149 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__2149, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2149 = {.cp = 0x2149, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2149, .cde = &lxb_unicode_decomposition_c_2149, .kde = &lxb_unicode_decomposition_k_2149};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2150[3] = {0x0031, 0x2044, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2150 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2150, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2150[3] = {0x0031, 0x2044, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2150 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2150, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2150[3] = {0x0031, 0x2044, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2150 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2150, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2150 = {.cp = 0x2150, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2150, .cde = &lxb_unicode_decomposition_c_2150, .kde = &lxb_unicode_decomposition_k_2150};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2151[3] = {0x0031, 0x2044, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2151 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2151, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2151[3] = {0x0031, 0x2044, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2151 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2151, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2151[3] = {0x0031, 0x2044, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2151 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2151, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2151 = {.cp = 0x2151, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2151, .cde = &lxb_unicode_decomposition_c_2151, .kde = &lxb_unicode_decomposition_k_2151};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2152[4] = {0x0031, 0x2044, 0x0031, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2152 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2152, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2152[4] = {0x0031, 0x2044, 0x0031, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2152 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2152, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2152[4] = {0x0031, 0x2044, 0x0031, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2152 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2152, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_2152 = {.cp = 0x2152, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2152, .cde = &lxb_unicode_decomposition_c_2152, .kde = &lxb_unicode_decomposition_k_2152};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2153[3] = {0x0031, 0x2044, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2153 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2153, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2153[3] = {0x0031, 0x2044, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2153 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2153, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2153[3] = {0x0031, 0x2044, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2153 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2153, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2153 = {.cp = 0x2153, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2153, .cde = &lxb_unicode_decomposition_c_2153, .kde = &lxb_unicode_decomposition_k_2153};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2154[3] = {0x0032, 0x2044, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2154 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2154, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2154[3] = {0x0032, 0x2044, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2154 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2154, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2154[3] = {0x0032, 0x2044, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2154 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2154, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2154 = {.cp = 0x2154, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2154, .cde = &lxb_unicode_decomposition_c_2154, .kde = &lxb_unicode_decomposition_k_2154};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2155[3] = {0x0031, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2155 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2155, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2155[3] = {0x0031, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2155 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2155, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2155[3] = {0x0031, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2155 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2155, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2155 = {.cp = 0x2155, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2155, .cde = &lxb_unicode_decomposition_c_2155, .kde = &lxb_unicode_decomposition_k_2155};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2156[3] = {0x0032, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2156 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2156, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2156[3] = {0x0032, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2156 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2156, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2156[3] = {0x0032, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2156 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2156, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2156 = {.cp = 0x2156, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2156, .cde = &lxb_unicode_decomposition_c_2156, .kde = &lxb_unicode_decomposition_k_2156};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2157[3] = {0x0033, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2157 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2157, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2157[3] = {0x0033, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2157 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2157, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2157[3] = {0x0033, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2157 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2157, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2157 = {.cp = 0x2157, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2157, .cde = &lxb_unicode_decomposition_c_2157, .kde = &lxb_unicode_decomposition_k_2157};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2158[3] = {0x0034, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2158 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2158, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2158[3] = {0x0034, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2158 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2158, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2158[3] = {0x0034, 0x2044, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2158 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2158, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2158 = {.cp = 0x2158, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2158, .cde = &lxb_unicode_decomposition_c_2158, .kde = &lxb_unicode_decomposition_k_2158};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2159[3] = {0x0031, 0x2044, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2159 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2159, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2159[3] = {0x0031, 0x2044, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2159 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2159, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2159[3] = {0x0031, 0x2044, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2159 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2159, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2159 = {.cp = 0x2159, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2159, .cde = &lxb_unicode_decomposition_c_2159, .kde = &lxb_unicode_decomposition_k_2159};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_215A[3] = {0x0035, 0x2044, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_215A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_215A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_215A[3] = {0x0035, 0x2044, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_215A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_215A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__215A[3] = {0x0035, 0x2044, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__215A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__215A, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_215A = {.cp = 0x215A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__215A, .cde = &lxb_unicode_decomposition_c_215A, .kde = &lxb_unicode_decomposition_k_215A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_215B[3] = {0x0031, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_215B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_215B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_215B[3] = {0x0031, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_215B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_215B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__215B[3] = {0x0031, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__215B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__215B, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_215B = {.cp = 0x215B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__215B, .cde = &lxb_unicode_decomposition_c_215B, .kde = &lxb_unicode_decomposition_k_215B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_215C[3] = {0x0033, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_215C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_215C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_215C[3] = {0x0033, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_215C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_215C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__215C[3] = {0x0033, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__215C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__215C, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_215C = {.cp = 0x215C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__215C, .cde = &lxb_unicode_decomposition_c_215C, .kde = &lxb_unicode_decomposition_k_215C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_215D[3] = {0x0035, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_215D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_215D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_215D[3] = {0x0035, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_215D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_215D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__215D[3] = {0x0035, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__215D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__215D, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_215D = {.cp = 0x215D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__215D, .cde = &lxb_unicode_decomposition_c_215D, .kde = &lxb_unicode_decomposition_k_215D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_215E[3] = {0x0037, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_215E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_215E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_215E[3] = {0x0037, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_215E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_215E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__215E[3] = {0x0037, 0x2044, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__215E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__215E, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_215E = {.cp = 0x215E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__215E, .cde = &lxb_unicode_decomposition_c_215E, .kde = &lxb_unicode_decomposition_k_215E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_215F[2] = {0x0031, 0x2044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_215F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_215F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_215F[2] = {0x0031, 0x2044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_215F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_215F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__215F[2] = {0x0031, 0x2044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__215F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__215F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_215F = {.cp = 0x215F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__215F, .cde = &lxb_unicode_decomposition_c_215F, .kde = &lxb_unicode_decomposition_k_215F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2160[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2160, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2160[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2160, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2160[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2160, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2160 = {.cp = 0x2160, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2160, .cde = &lxb_unicode_decomposition_c_2160, .kde = &lxb_unicode_decomposition_k_2160};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2161[2] = {0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2161, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2161[2] = {0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2161, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2161[2] = {0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2161, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2161 = {.cp = 0x2161, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2161, .cde = &lxb_unicode_decomposition_c_2161, .kde = &lxb_unicode_decomposition_k_2161};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2162[3] = {0x0049, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2162, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2162[3] = {0x0049, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2162, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2162[3] = {0x0049, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2162, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2162 = {.cp = 0x2162, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2162, .cde = &lxb_unicode_decomposition_c_2162, .kde = &lxb_unicode_decomposition_k_2162};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2163[2] = {0x0049, 0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2163, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2163[2] = {0x0049, 0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2163, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2163[2] = {0x0049, 0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2163, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2163 = {.cp = 0x2163, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2163, .cde = &lxb_unicode_decomposition_c_2163, .kde = &lxb_unicode_decomposition_k_2163};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2164[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2164, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2164[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2164, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2164[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2164, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2164 = {.cp = 0x2164, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2164, .cde = &lxb_unicode_decomposition_c_2164, .kde = &lxb_unicode_decomposition_k_2164};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2165[2] = {0x0056, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2165 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2165, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2165[2] = {0x0056, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2165 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2165, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2165[2] = {0x0056, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2165 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2165, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2165 = {.cp = 0x2165, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2165, .cde = &lxb_unicode_decomposition_c_2165, .kde = &lxb_unicode_decomposition_k_2165};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2166[3] = {0x0056, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2166 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2166, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2166[3] = {0x0056, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2166 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2166, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2166[3] = {0x0056, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2166 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2166, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2166 = {.cp = 0x2166, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2166, .cde = &lxb_unicode_decomposition_c_2166, .kde = &lxb_unicode_decomposition_k_2166};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2167[4] = {0x0056, 0x0049, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2167 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2167, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2167[4] = {0x0056, 0x0049, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2167 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2167, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2167[4] = {0x0056, 0x0049, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2167 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2167, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_2167 = {.cp = 0x2167, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2167, .cde = &lxb_unicode_decomposition_c_2167, .kde = &lxb_unicode_decomposition_k_2167};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2168[2] = {0x0049, 0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2168 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2168, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2168[2] = {0x0049, 0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2168 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2168, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2168[2] = {0x0049, 0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2168 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2168, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2168 = {.cp = 0x2168, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2168, .cde = &lxb_unicode_decomposition_c_2168, .kde = &lxb_unicode_decomposition_k_2168};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2169[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2169 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2169, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2169[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2169 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2169, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2169[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2169 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2169, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2169 = {.cp = 0x2169, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2169, .cde = &lxb_unicode_decomposition_c_2169, .kde = &lxb_unicode_decomposition_k_2169};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_216A[2] = {0x0058, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_216A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_216A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_216A[2] = {0x0058, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_216A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_216A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__216A[2] = {0x0058, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__216A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__216A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_216A = {.cp = 0x216A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__216A, .cde = &lxb_unicode_decomposition_c_216A, .kde = &lxb_unicode_decomposition_k_216A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_216B[3] = {0x0058, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_216B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_216B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_216B[3] = {0x0058, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_216B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_216B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__216B[3] = {0x0058, 0x0049, 0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__216B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__216B, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_216B = {.cp = 0x216B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__216B, .cde = &lxb_unicode_decomposition_c_216B, .kde = &lxb_unicode_decomposition_k_216B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_216C[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_216C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_216C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_216C[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_216C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_216C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__216C[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__216C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__216C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_216C = {.cp = 0x216C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__216C, .cde = &lxb_unicode_decomposition_c_216C, .kde = &lxb_unicode_decomposition_k_216C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_216D[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_216D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_216D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_216D[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_216D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_216D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__216D[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__216D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__216D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_216D = {.cp = 0x216D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__216D, .cde = &lxb_unicode_decomposition_c_216D, .kde = &lxb_unicode_decomposition_k_216D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_216E[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_216E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_216E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_216E[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_216E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_216E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__216E[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__216E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__216E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_216E = {.cp = 0x216E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__216E, .cde = &lxb_unicode_decomposition_c_216E, .kde = &lxb_unicode_decomposition_k_216E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_216F[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_216F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_216F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_216F[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_216F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_216F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__216F[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__216F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__216F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_216F = {.cp = 0x216F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__216F, .cde = &lxb_unicode_decomposition_c_216F, .kde = &lxb_unicode_decomposition_k_216F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2170[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2170 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2170, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2170[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2170 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2170, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2170[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2170 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2170, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2170 = {.cp = 0x2170, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2170, .cde = &lxb_unicode_decomposition_c_2170, .kde = &lxb_unicode_decomposition_k_2170};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2171[2] = {0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2171 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2171, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2171[2] = {0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2171 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2171, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2171[2] = {0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2171 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2171, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2171 = {.cp = 0x2171, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2171, .cde = &lxb_unicode_decomposition_c_2171, .kde = &lxb_unicode_decomposition_k_2171};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2172[3] = {0x0069, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2172 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2172, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2172[3] = {0x0069, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2172 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2172, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2172[3] = {0x0069, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2172 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2172, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2172 = {.cp = 0x2172, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2172, .cde = &lxb_unicode_decomposition_c_2172, .kde = &lxb_unicode_decomposition_k_2172};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2173[2] = {0x0069, 0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2173 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2173, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2173[2] = {0x0069, 0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2173 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2173, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2173[2] = {0x0069, 0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2173 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2173, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2173 = {.cp = 0x2173, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2173, .cde = &lxb_unicode_decomposition_c_2173, .kde = &lxb_unicode_decomposition_k_2173};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2174[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2174 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2174, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2174[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2174 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2174, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2174[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2174 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2174, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2174 = {.cp = 0x2174, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2174, .cde = &lxb_unicode_decomposition_c_2174, .kde = &lxb_unicode_decomposition_k_2174};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2175[2] = {0x0076, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2175 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2175, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2175[2] = {0x0076, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2175 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2175, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2175[2] = {0x0076, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2175 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2175, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2175 = {.cp = 0x2175, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2175, .cde = &lxb_unicode_decomposition_c_2175, .kde = &lxb_unicode_decomposition_k_2175};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2176[3] = {0x0076, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2176 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2176, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2176[3] = {0x0076, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2176 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2176, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2176[3] = {0x0076, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2176 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2176, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2176 = {.cp = 0x2176, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2176, .cde = &lxb_unicode_decomposition_c_2176, .kde = &lxb_unicode_decomposition_k_2176};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2177[4] = {0x0076, 0x0069, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2177 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2177, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2177[4] = {0x0076, 0x0069, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2177 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2177, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2177[4] = {0x0076, 0x0069, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2177 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2177, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_2177 = {.cp = 0x2177, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2177, .cde = &lxb_unicode_decomposition_c_2177, .kde = &lxb_unicode_decomposition_k_2177};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2178[2] = {0x0069, 0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2178 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2178, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2178[2] = {0x0069, 0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2178 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2178, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2178[2] = {0x0069, 0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2178 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2178, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2178 = {.cp = 0x2178, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2178, .cde = &lxb_unicode_decomposition_c_2178, .kde = &lxb_unicode_decomposition_k_2178};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2179[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2179 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2179, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2179[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2179 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2179, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2179[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2179 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2179, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2179 = {.cp = 0x2179, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2179, .cde = &lxb_unicode_decomposition_c_2179, .kde = &lxb_unicode_decomposition_k_2179};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_217A[2] = {0x0078, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_217A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_217A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_217A[2] = {0x0078, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_217A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_217A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__217A[2] = {0x0078, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__217A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__217A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_217A = {.cp = 0x217A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__217A, .cde = &lxb_unicode_decomposition_c_217A, .kde = &lxb_unicode_decomposition_k_217A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_217B[3] = {0x0078, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_217B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_217B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_217B[3] = {0x0078, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_217B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_217B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__217B[3] = {0x0078, 0x0069, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__217B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__217B, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_217B = {.cp = 0x217B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__217B, .cde = &lxb_unicode_decomposition_c_217B, .kde = &lxb_unicode_decomposition_k_217B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_217C[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_217C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_217C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_217C[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_217C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_217C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__217C[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__217C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__217C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_217C = {.cp = 0x217C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__217C, .cde = &lxb_unicode_decomposition_c_217C, .kde = &lxb_unicode_decomposition_k_217C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_217D[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_217D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_217D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_217D[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_217D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_217D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__217D[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__217D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__217D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_217D = {.cp = 0x217D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__217D, .cde = &lxb_unicode_decomposition_c_217D, .kde = &lxb_unicode_decomposition_k_217D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_217E[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_217E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_217E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_217E[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_217E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_217E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__217E[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__217E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__217E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_217E = {.cp = 0x217E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__217E, .cde = &lxb_unicode_decomposition_c_217E, .kde = &lxb_unicode_decomposition_k_217E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_217F[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_217F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_217F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_217F[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_217F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_217F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__217F[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__217F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__217F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_217F = {.cp = 0x217F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__217F, .cde = &lxb_unicode_decomposition_c_217F, .kde = &lxb_unicode_decomposition_k_217F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2189[3] = {0x0030, 0x2044, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2189 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_2189, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2189[3] = {0x0030, 0x2044, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2189 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_2189, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2189[3] = {0x0030, 0x2044, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2189 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__2189, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2189 = {.cp = 0x2189, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2189, .cde = &lxb_unicode_decomposition_c_2189, .kde = &lxb_unicode_decomposition_k_2189};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_219A[2] = {0x2190, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_219A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_219A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_219A[2] = {0x2190, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_219A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_219A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__219A[2] = {0x2190, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__219A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__219A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_219A = {.cp = 0x219A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__219A, .cde = &lxb_unicode_decomposition_c_219A, .kde = &lxb_unicode_decomposition_k_219A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_219B[2] = {0x2192, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_219B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_219B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_219B[2] = {0x2192, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_219B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_219B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__219B[2] = {0x2192, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__219B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__219B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_219B = {.cp = 0x219B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__219B, .cde = &lxb_unicode_decomposition_c_219B, .kde = &lxb_unicode_decomposition_k_219B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_21AE[2] = {0x2194, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_21AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_21AE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_21AE[2] = {0x2194, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_21AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_21AE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__21AE[2] = {0x2194, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__21AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__21AE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_21AE = {.cp = 0x21AE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__21AE, .cde = &lxb_unicode_decomposition_c_21AE, .kde = &lxb_unicode_decomposition_k_21AE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_21CD[2] = {0x21D0, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_21CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_21CD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_21CD[2] = {0x21D0, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_21CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_21CD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__21CD[2] = {0x21D0, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__21CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__21CD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_21CD = {.cp = 0x21CD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__21CD, .cde = &lxb_unicode_decomposition_c_21CD, .kde = &lxb_unicode_decomposition_k_21CD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_21CE[2] = {0x21D4, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_21CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_21CE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_21CE[2] = {0x21D4, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_21CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_21CE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__21CE[2] = {0x21D4, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__21CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__21CE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_21CE = {.cp = 0x21CE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__21CE, .cde = &lxb_unicode_decomposition_c_21CE, .kde = &lxb_unicode_decomposition_k_21CE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_21CF[2] = {0x21D2, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_21CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_21CF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_21CF[2] = {0x21D2, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_21CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_21CF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__21CF[2] = {0x21D2, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__21CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__21CF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_21CF = {.cp = 0x21CF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__21CF, .cde = &lxb_unicode_decomposition_c_21CF, .kde = &lxb_unicode_decomposition_k_21CF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2204[2] = {0x2203, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2204 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2204, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2204[2] = {0x2203, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2204 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2204, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2204[2] = {0x2203, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2204 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2204, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2204 = {.cp = 0x2204, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2204, .cde = &lxb_unicode_decomposition_c_2204, .kde = &lxb_unicode_decomposition_k_2204};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2209[2] = {0x2208, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2209 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2209, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2209[2] = {0x2208, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2209 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2209, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2209[2] = {0x2208, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2209 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2209, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2209 = {.cp = 0x2209, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2209, .cde = &lxb_unicode_decomposition_c_2209, .kde = &lxb_unicode_decomposition_k_2209};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_220C[2] = {0x220B, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_220C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_220C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_220C[2] = {0x220B, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_220C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_220C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__220C[2] = {0x220B, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__220C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__220C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_220C = {.cp = 0x220C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__220C, .cde = &lxb_unicode_decomposition_c_220C, .kde = &lxb_unicode_decomposition_k_220C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2224[2] = {0x2223, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2224 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2224, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2224[2] = {0x2223, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2224 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2224, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2224[2] = {0x2223, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2224 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2224, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2224 = {.cp = 0x2224, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2224, .cde = &lxb_unicode_decomposition_c_2224, .kde = &lxb_unicode_decomposition_k_2224};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2226[2] = {0x2225, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2226 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2226, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2226[2] = {0x2225, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2226 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2226, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2226[2] = {0x2225, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2226 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2226, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2226 = {.cp = 0x2226, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2226, .cde = &lxb_unicode_decomposition_c_2226, .kde = &lxb_unicode_decomposition_k_2226};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_222C[2] = {0x222B, 0x222B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_222C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_222C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_222C[2] = {0x222B, 0x222B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_222C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_222C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__222C[2] = {0x222B, 0x222B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__222C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__222C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_222C = {.cp = 0x222C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__222C, .cde = &lxb_unicode_decomposition_c_222C, .kde = &lxb_unicode_decomposition_k_222C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_222D[3] = {0x222B, 0x222B, 0x222B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_222D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_222D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_222D[3] = {0x222B, 0x222B, 0x222B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_222D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_222D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__222D[3] = {0x222B, 0x222B, 0x222B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__222D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__222D, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_222D = {.cp = 0x222D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__222D, .cde = &lxb_unicode_decomposition_c_222D, .kde = &lxb_unicode_decomposition_k_222D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_222F[2] = {0x222E, 0x222E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_222F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_222F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_222F[2] = {0x222E, 0x222E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_222F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_222F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__222F[2] = {0x222E, 0x222E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__222F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__222F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_222F = {.cp = 0x222F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__222F, .cde = &lxb_unicode_decomposition_c_222F, .kde = &lxb_unicode_decomposition_k_222F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2230[3] = {0x222E, 0x222E, 0x222E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2230 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2230, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2230[3] = {0x222E, 0x222E, 0x222E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2230 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2230, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2230[3] = {0x222E, 0x222E, 0x222E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2230 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2230, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2230 = {.cp = 0x2230, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2230, .cde = &lxb_unicode_decomposition_c_2230, .kde = &lxb_unicode_decomposition_k_2230};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2241[2] = {0x223C, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2241 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2241, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2241[2] = {0x223C, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2241 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2241, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2241[2] = {0x223C, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2241 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2241, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2241 = {.cp = 0x2241, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2241, .cde = &lxb_unicode_decomposition_c_2241, .kde = &lxb_unicode_decomposition_k_2241};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2244[2] = {0x2243, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2244 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2244, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2244[2] = {0x2243, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2244 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2244, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2244[2] = {0x2243, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2244 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2244, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2244 = {.cp = 0x2244, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2244, .cde = &lxb_unicode_decomposition_c_2244, .kde = &lxb_unicode_decomposition_k_2244};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2247[2] = {0x2245, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2247 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2247, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2247[2] = {0x2245, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2247 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2247, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2247[2] = {0x2245, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2247 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2247, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2247 = {.cp = 0x2247, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2247, .cde = &lxb_unicode_decomposition_c_2247, .kde = &lxb_unicode_decomposition_k_2247};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2249[2] = {0x2248, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2249 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2249, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2249[2] = {0x2248, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2249 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2249, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2249[2] = {0x2248, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2249 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2249, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2249 = {.cp = 0x2249, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2249, .cde = &lxb_unicode_decomposition_c_2249, .kde = &lxb_unicode_decomposition_k_2249};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2260[2] = {0x003D, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2260 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2260, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2260[2] = {0x003D, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2260 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2260, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2260[2] = {0x003D, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2260 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2260, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2260 = {.cp = 0x2260, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2260, .cde = &lxb_unicode_decomposition_c_2260, .kde = &lxb_unicode_decomposition_k_2260};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2262[2] = {0x2261, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2262 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2262, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2262[2] = {0x2261, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2262 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2262, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2262[2] = {0x2261, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2262 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2262, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2262 = {.cp = 0x2262, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2262, .cde = &lxb_unicode_decomposition_c_2262, .kde = &lxb_unicode_decomposition_k_2262};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_226D[2] = {0x224D, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_226D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_226D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_226D[2] = {0x224D, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_226D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_226D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__226D[2] = {0x224D, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__226D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__226D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_226D = {.cp = 0x226D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__226D, .cde = &lxb_unicode_decomposition_c_226D, .kde = &lxb_unicode_decomposition_k_226D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_226E[2] = {0x003C, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_226E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_226E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_226E[2] = {0x003C, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_226E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_226E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__226E[2] = {0x003C, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__226E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__226E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_226E = {.cp = 0x226E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__226E, .cde = &lxb_unicode_decomposition_c_226E, .kde = &lxb_unicode_decomposition_k_226E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_226F[2] = {0x003E, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_226F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_226F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_226F[2] = {0x003E, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_226F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_226F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__226F[2] = {0x003E, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__226F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__226F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_226F = {.cp = 0x226F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__226F, .cde = &lxb_unicode_decomposition_c_226F, .kde = &lxb_unicode_decomposition_k_226F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2270[2] = {0x2264, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2270 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2270, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2270[2] = {0x2264, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2270 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2270, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2270[2] = {0x2264, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2270 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2270, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2270 = {.cp = 0x2270, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2270, .cde = &lxb_unicode_decomposition_c_2270, .kde = &lxb_unicode_decomposition_k_2270};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2271[2] = {0x2265, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2271 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2271, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2271[2] = {0x2265, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2271 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2271, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2271[2] = {0x2265, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2271 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2271, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2271 = {.cp = 0x2271, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2271, .cde = &lxb_unicode_decomposition_c_2271, .kde = &lxb_unicode_decomposition_k_2271};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2274[2] = {0x2272, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2274 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2274, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2274[2] = {0x2272, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2274 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2274, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2274[2] = {0x2272, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2274 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2274, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2274 = {.cp = 0x2274, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2274, .cde = &lxb_unicode_decomposition_c_2274, .kde = &lxb_unicode_decomposition_k_2274};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2275[2] = {0x2273, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2275 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2275, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2275[2] = {0x2273, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2275 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2275, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2275[2] = {0x2273, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2275 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2275, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2275 = {.cp = 0x2275, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2275, .cde = &lxb_unicode_decomposition_c_2275, .kde = &lxb_unicode_decomposition_k_2275};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2278[2] = {0x2276, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2278 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2278, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2278[2] = {0x2276, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2278 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2278, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2278[2] = {0x2276, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2278 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2278, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2278 = {.cp = 0x2278, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2278, .cde = &lxb_unicode_decomposition_c_2278, .kde = &lxb_unicode_decomposition_k_2278};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2279[2] = {0x2277, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2279 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2279, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2279[2] = {0x2277, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2279 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2279, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2279[2] = {0x2277, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2279 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2279, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2279 = {.cp = 0x2279, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2279, .cde = &lxb_unicode_decomposition_c_2279, .kde = &lxb_unicode_decomposition_k_2279};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2280[2] = {0x227A, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2280 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2280, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2280[2] = {0x227A, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2280 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2280, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2280[2] = {0x227A, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2280 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2280, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2280 = {.cp = 0x2280, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2280, .cde = &lxb_unicode_decomposition_c_2280, .kde = &lxb_unicode_decomposition_k_2280};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2281[2] = {0x227B, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2281 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2281, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2281[2] = {0x227B, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2281 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2281, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2281[2] = {0x227B, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2281 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2281, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2281 = {.cp = 0x2281, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2281, .cde = &lxb_unicode_decomposition_c_2281, .kde = &lxb_unicode_decomposition_k_2281};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2284[2] = {0x2282, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2284 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2284, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2284[2] = {0x2282, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2284 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2284, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2284[2] = {0x2282, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2284 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2284, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2284 = {.cp = 0x2284, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2284, .cde = &lxb_unicode_decomposition_c_2284, .kde = &lxb_unicode_decomposition_k_2284};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2285[2] = {0x2283, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2285 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2285, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2285[2] = {0x2283, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2285 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2285, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2285[2] = {0x2283, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2285 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2285, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2285 = {.cp = 0x2285, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2285, .cde = &lxb_unicode_decomposition_c_2285, .kde = &lxb_unicode_decomposition_k_2285};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2288[2] = {0x2286, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2288 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2288, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2288[2] = {0x2286, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2288 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2288, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2288[2] = {0x2286, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2288 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2288, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2288 = {.cp = 0x2288, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2288, .cde = &lxb_unicode_decomposition_c_2288, .kde = &lxb_unicode_decomposition_k_2288};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2289[2] = {0x2287, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2289 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2289, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2289[2] = {0x2287, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2289 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2289, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2289[2] = {0x2287, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2289 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2289, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2289 = {.cp = 0x2289, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2289, .cde = &lxb_unicode_decomposition_c_2289, .kde = &lxb_unicode_decomposition_k_2289};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_22AC[2] = {0x22A2, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_22AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_22AC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_22AC[2] = {0x22A2, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_22AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_22AC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__22AC[2] = {0x22A2, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__22AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__22AC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_22AC = {.cp = 0x22AC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__22AC, .cde = &lxb_unicode_decomposition_c_22AC, .kde = &lxb_unicode_decomposition_k_22AC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_22AD[2] = {0x22A8, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_22AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_22AD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_22AD[2] = {0x22A8, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_22AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_22AD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__22AD[2] = {0x22A8, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__22AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__22AD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_22AD = {.cp = 0x22AD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__22AD, .cde = &lxb_unicode_decomposition_c_22AD, .kde = &lxb_unicode_decomposition_k_22AD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_22AE[2] = {0x22A9, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_22AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_22AE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_22AE[2] = {0x22A9, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_22AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_22AE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__22AE[2] = {0x22A9, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__22AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__22AE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_22AE = {.cp = 0x22AE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__22AE, .cde = &lxb_unicode_decomposition_c_22AE, .kde = &lxb_unicode_decomposition_k_22AE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_22AF[2] = {0x22AB, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_22AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_22AF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_22AF[2] = {0x22AB, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_22AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_22AF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__22AF[2] = {0x22AB, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__22AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__22AF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_22AF = {.cp = 0x22AF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__22AF, .cde = &lxb_unicode_decomposition_c_22AF, .kde = &lxb_unicode_decomposition_k_22AF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_22E0[2] = {0x227C, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_22E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_22E0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_22E0[2] = {0x227C, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_22E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_22E0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__22E0[2] = {0x227C, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__22E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__22E0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_22E0 = {.cp = 0x22E0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__22E0, .cde = &lxb_unicode_decomposition_c_22E0, .kde = &lxb_unicode_decomposition_k_22E0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_22E1[2] = {0x227D, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_22E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_22E1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_22E1[2] = {0x227D, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_22E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_22E1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__22E1[2] = {0x227D, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__22E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__22E1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_22E1 = {.cp = 0x22E1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__22E1, .cde = &lxb_unicode_decomposition_c_22E1, .kde = &lxb_unicode_decomposition_k_22E1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_22E2[2] = {0x2291, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_22E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_22E2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_22E2[2] = {0x2291, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_22E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_22E2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__22E2[2] = {0x2291, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__22E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__22E2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_22E2 = {.cp = 0x22E2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__22E2, .cde = &lxb_unicode_decomposition_c_22E2, .kde = &lxb_unicode_decomposition_k_22E2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_22E3[2] = {0x2292, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_22E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_22E3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_22E3[2] = {0x2292, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_22E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_22E3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__22E3[2] = {0x2292, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__22E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__22E3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_22E3 = {.cp = 0x22E3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__22E3, .cde = &lxb_unicode_decomposition_c_22E3, .kde = &lxb_unicode_decomposition_k_22E3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_22EA[2] = {0x22B2, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_22EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_22EA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_22EA[2] = {0x22B2, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_22EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_22EA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__22EA[2] = {0x22B2, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__22EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__22EA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_22EA = {.cp = 0x22EA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__22EA, .cde = &lxb_unicode_decomposition_c_22EA, .kde = &lxb_unicode_decomposition_k_22EA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_22EB[2] = {0x22B3, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_22EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_22EB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_22EB[2] = {0x22B3, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_22EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_22EB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__22EB[2] = {0x22B3, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__22EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__22EB, .length = 2};
stati