/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { Config } from '../config/config.js';
import type { AgentDefinition } from './types.js';
/**
 * Manages the discovery, loading, validation, and registration of
 * AgentDefinitions.
 */
export declare class AgentRegistry {
    private readonly config;
    private readonly agents;
    constructor(config: Config);
    /**
     * Discovers and loads agents.
     */
    initialize(): Promise<void>;
    private loadBuiltInAgents;
    /**
     * Registers an agent definition. If an agent with the same name exists,
     * it will be overwritten, respecting the precedence established by the
     * initialization order.
     */
    protected registerAgent(definition: AgentDefinition): void;
    /**
     * Retrieves an agent definition by name.
     */
    getDefinition(name: string): AgentDefinition | undefined;
    /**
     * Returns all active agent definitions.
     */
    getAllDefinitions(): AgentDefinition[];
}
