/* pci-ids.c
 *
 * pci-ids.c is based on the pci.ids of The PCI ID Repository at
 * https://pci-ids.ucw.cz/, fetched indirectly via
 * https://github.com/pciutils/pciids
 *
 * List of PCI ID's
 *
 * Version: 2025.07.11
 * Date:    2025-07-11 03:15:02
 *
 * Maintained by Albert Pool, Martin Mares, and other volunteers from
 * the PCI ID Project at https://pci-ids.ucw.cz/.
 *
 * New data are always welcome, especially if they are accurate. If you have
 * anything to contribute, please follow the instructions at the web site.
 *
 * This file can be distributed under either the GPL
 * (version 2 or higher) or the 3-clause BSD License.
 *
 *
 * Generated by tools/make-pci-ids.py
 * By Caleb Chiu <caleb.chiu@macnica.com>
 * Copyright 2021
 *
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <config.h>

#include <stddef.h>
#include <stdlib.h>

#include "wsutil/array.h"

#include "pci-ids.h"

typedef struct
{
  uint16_t vid;
  uint16_t did;
  uint16_t svid;
  uint16_t ssid;
  const char *name;

} pci_id_t;

typedef struct
{
  uint16_t vid;
  uint16_t count;
  pci_id_t const *ids_ptr;

} pci_vid_index_t;

static pci_id_t const pci_vid_0001[] = {
{0x0001, 0xFFFF, 0xFFFF, 0xFFFF, "SafeNet (wrong ID)(0x0001)"},
}; /* pci_vid_0001[] */

static pci_id_t const pci_vid_0010[] = {
{0x0010, 0xFFFF, 0xFFFF, 0xFFFF, "Allied Telesis, Inc (Wrong ID)(0x0010)"},
{0x0010, 0x8139, 0xFFFF, 0xFFFF, "AT-2500TX V3 Ethernet(0x8139)"},
}; /* pci_vid_0010[] */

static pci_id_t const pci_vid_0014[] = {
{0x0014, 0xFFFF, 0xFFFF, 0xFFFF, "Loongson Technology LLC(0x0014)"},
{0x0014, 0x7A00, 0xFFFF, 0xFFFF, "Hyper Transport Bridge Controller(0x7A00)"},
{0x0014, 0x7A02, 0xFFFF, 0xFFFF, "APB (Advanced Peripheral Bus) Controller(0x7A02)"},
{0x0014, 0x7A03, 0xFFFF, 0xFFFF, "Gigabit Ethernet Controller(0x7A03)"},
{0x0014, 0x7A04, 0xFFFF, 0xFFFF, "OTG USB Controller(0x7A04)"},
{0x0014, 0x7A05, 0xFFFF, 0xFFFF, "Vivante GPU (Graphics Processing Unit)(0x7A05)"},
{0x0014, 0x7A06, 0xFFFF, 0xFFFF, "DC (Display Controller)(0x7A06)"},
{0x0014, 0x7A07, 0xFFFF, 0xFFFF, "HDA (High Definition Audio) Controller(0x7A07)"},
{0x0014, 0x7A08, 0xFFFF, 0xFFFF, "SATA AHCI Controller(0x7A08)"},
{0x0014, 0x7A09, 0xFFFF, 0xFFFF, "PCI-to-PCI Bridge(0x7A09)"},
{0x0014, 0x7A0B, 0xFFFF, 0xFFFF, "SPI Controller(0x7A0B)"},
{0x0014, 0x7A0C, 0xFFFF, 0xFFFF, "LPC Controller(0x7A0C)"},
{0x0014, 0x7A0F, 0xFFFF, 0xFFFF, "DMA (Direct Memory Access) Controller(0x7A0F)"},
{0x0014, 0x7A10, 0xFFFF, 0xFFFF, "Hyper Transport Bridge Controller(0x7A10)"},
{0x0014, 0x7A13, 0xFFFF, 0xFFFF, "7A2000 PCH Gigabit Ethernet Controller(0x7A13)"},
{0x0014, 0x7A14, 0xFFFF, 0xFFFF, "EHCI USB Controller(0x7A14)"},
{0x0014, 0x7A15, 0xFFFF, 0xFFFF, "Vivante GPU (Graphics Processing Unit)(0x7A15)"},
{0x0014, 0x7A18, 0xFFFF, 0xFFFF, "SATA 3 AHCI Controller(0x7A18)"},
{0x0014, 0x7A19, 0xFFFF, 0xFFFF, "PCI-to-PCI Bridge(0x7A19)"},
{0x0014, 0x7A1B, 0xFFFF, 0xFFFF, "SPI Controller(0x7A1B)"},
{0x0014, 0x7A24, 0xFFFF, 0xFFFF, "OHCI USB Controller(0x7A24)"},
{0x0014, 0x7A25, 0xFFFF, 0xFFFF, "LG100 GPU(0x7A25)"},
{0x0014, 0x7A27, 0xFFFF, 0xFFFF, "7A2000 PCH I2S Controller(0x7A27)"},
{0x0014, 0x7A29, 0xFFFF, 0xFFFF, "PCI-to-PCI Bridge(0x7A29)"},
{0x0014, 0x7A34, 0xFFFF, 0xFFFF, "xHCI USB Controller(0x7A34)"},
{0x0014, 0x7A36, 0xFFFF, 0xFFFF, "Display Controller(0x7A36)"},
{0x0014, 0x7A39, 0xFFFF, 0xFFFF, "PCIe x1 Root Port(0x7A39)"},
{0x0014, 0x7A49, 0xFFFF, 0xFFFF, "PCIe x4 Root Port(0x7A49)"},
{0x0014, 0x7A59, 0xFFFF, 0xFFFF, "PCIe x8 Root Port(0x7A59)"},
{0x0014, 0x7A69, 0xFFFF, 0xFFFF, "PCIe x16 Root Port(0x7A69)"},
}; /* pci_vid_0014[] */

static pci_id_t const pci_vid_0018[] = {
{0x0018, 0xFFFF, 0xFFFF, 0xFFFF, "Fn-Link Technology Limited(0x0018)"},
{0x0018, 0x6252, 0xFFFF, 0xFFFF, "6252CPUB 802.11ax PCIe Wireless Network Adapter(0x6252)"},
}; /* pci_vid_0018[] */

static pci_id_t const pci_vid_001C[] = {
{0x001C, 0xFFFF, 0xFFFF, 0xFFFF, "PEAK-System Technik GmbH(0x001C)"},
{0x001C, 0x0001, 0xFFFF, 0xFFFF, "PCAN-PCI CAN-Bus controller(0x0001)"},
{0x001C, 0x0001, 0x001C, 0x0004, "2 Channel CAN Bus SJC1000(0x001C-0x0004)"},
{0x001C, 0x0001, 0x001C, 0x0005, "2 Channel CAN Bus SJC1000 (Optically Isolated)(0x001C-0x0005)"},
}; /* pci_vid_001C[] */

static pci_id_t const pci_vid_003D[] = {
{0x003D, 0xFFFF, 0xFFFF, 0xFFFF, "Lockheed Martin-Marietta Corp(0x003D)"},
}; /* pci_vid_003D[] */

static pci_id_t const pci_vid_0059[] = {
{0x0059, 0xFFFF, 0xFFFF, 0xFFFF, "Tiger Jet Network Inc. (Wrong ID)(0x0059)"},
}; /* pci_vid_0059[] */

static pci_id_t const pci_vid_0070[] = {
{0x0070, 0xFFFF, 0xFFFF, 0xFFFF, "Hauppauge computer works Inc.(0x0070)"},
{0x0070, 0x7801, 0xFFFF, 0xFFFF, "WinTV HVR-1800 MCE(0x7801)"},
}; /* pci_vid_0070[] */

static pci_id_t const pci_vid_0071[] = {
{0x0071, 0xFFFF, 0xFFFF, 0xFFFF, "Nebula Electronics Ltd.(0x0071)"},
}; /* pci_vid_0071[] */

static pci_id_t const pci_vid_0095[] = {
{0x0095, 0xFFFF, 0xFFFF, 0xFFFF, "Silicon Image, Inc. (Wrong ID)(0x0095)"},
{0x0095, 0x0680, 0xFFFF, 0xFFFF, "Ultra ATA/133 IDE RAID CONTROLLER CARD(0x0680)"},
}; /* pci_vid_0095[] */

static pci_id_t const pci_vid_00A7[] = {
{0x00A7, 0xFFFF, 0xFFFF, 0xFFFF, "Teles AG (Wrong ID)(0x00A7)"},
}; /* pci_vid_00A7[] */

static pci_id_t const pci_vid_0100[] = {
{0x0100, 0xFFFF, 0xFFFF, 0xFFFF, "nCipher Security(0x0100)"},
}; /* pci_vid_0100[] */

static pci_id_t const pci_vid_0123[] = {
{0x0123, 0xFFFF, 0xFFFF, 0xFFFF, "General Dynamics(0x0123)"},
}; /* pci_vid_0123[] */

static pci_id_t const pci_vid_0128[] = {
{0x0128, 0xFFFF, 0xFFFF, 0xFFFF, "Dell (wrong ID)(0x0128)"},
}; /* pci_vid_0128[] */

static pci_id_t const pci_vid_018A[] = {
{0x018A, 0xFFFF, 0xFFFF, 0xFFFF, "LevelOne(0x018A)"},
{0x018A, 0x0106, 0xFFFF, 0xFFFF, "FPC-0106TX misprogrammed [RTL81xx](0x0106)"},
}; /* pci_vid_018A[] */

static pci_id_t const pci_vid_01DE[] = {
{0x01DE, 0xFFFF, 0xFFFF, 0xFFFF, "Oxide Computer Company(0x01DE)"},
{0x01DE, 0x0000, 0xFFFF, 0xFFFF, "Propolis NVMe Controller(0x0000)"},
{0x01DE, 0x0001, 0xFFFF, 0xFFFF, "Propolis xHCI Controller(0x0001)"},
{0x01DE, 0x0002, 0xFFFF, 0xFFFF, "Propolis PCI-PCI Bridge(0x0002)"},
}; /* pci_vid_01DE[] */

static pci_id_t const pci_vid_0200[] = {
{0x0200, 0xFFFF, 0xFFFF, 0xFFFF, "Dell (wrong ID)(0x0200)"},
}; /* pci_vid_0200[] */

static pci_id_t const pci_vid_021B[] = {
{0x021B, 0xFFFF, 0xFFFF, 0xFFFF, "Compaq Computer Corporation(0x021B)"},
{0x021B, 0x8139, 0xFFFF, 0xFFFF, "HNE-300 (RealTek RTL8139c) [iPaq Networking](0x8139)"},
}; /* pci_vid_021B[] */

static pci_id_t const pci_vid_025E[] = {
{0x025E, 0xFFFF, 0xFFFF, 0xFFFF, "Solidigm(0x025E)"},
{0x025E, 0x0B60, 0xFFFF, 0xFFFF, "NVMe DC SSD [Sentinel Rock Plus controller](0x0B60)"},
{0x025E, 0x0B60, 0x025E, 0x8008, "NVMe DC SSD U.2 15mm [D7-P5510](0x025E-0x8008)"},
{0x025E, 0x0B60, 0x025E, 0x8208, "NVMe DC SSD U.2 15mm [D7-P5810](0x025E-0x8208)"},
{0x025E, 0x0B60, 0x025E, 0x8D1D, "NVMe DC SSD E1.L 9.5mm [D5-P5316](0x025E-0x8D1D)"},
{0x025E, 0x0B60, 0x025E, 0x9008, "NVMe DC SSD U.2 15mm [D7-P5520](0x025E-0x9008)"},
{0x025E, 0x0B60, 0x025E, 0x900C, "NVMe DC SSD E1.S 9.5mm [D7-P5520](0x025E-0x900C)"},
{0x025E, 0x0B60, 0x025E, 0x900D, "NVMe DC SSD E1.S 15mm [D7-P5520](0x025E-0x900D)"},
{0x025E, 0x0B60, 0x025E, 0x901C, "NVMe DC SSD E1.L 9.5mm [D7-P5520](0x025E-0x901C)"},
{0x025E, 0x0B60, 0x025E, 0x9108, "NVMe DC SSD U.2 15mm [D7-P5620](0x025E-0x9108)"},
{0x025E, 0x0B60, 0x025E, 0xC008, "NVMe DC SSD U.2 15mm [D5-P5530](0x025E-0xC008)"},
{0x025E, 0x0B60, 0x025E, 0xD408, "NVMe DC SSD U.2 15mm [D5-P5430](0x025E-0xD408)"},
{0x025E, 0x0B60, 0x025E, 0xD40C, "NVMe DC SSD E1.S 9.5mm [D5-P5430](0x025E-0xD40C)"},
{0x025E, 0x0B60, 0x025E, 0xD419, "NVMe DC SSD E3.S 7.5mm [D5-P5430](0x025E-0xD419)"},
{0x025E, 0x0B60, 0x025E, 0xD808, "NVMe DC SSD U.2 15mm [D5-P5336](0x025E-0xD808)"},
{0x025E, 0x0B60, 0x025E, 0xD819, "NVMe DC SSD E3.S 7.5mm [D5-P5336](0x025E-0xD819)"},
{0x025E, 0x0B60, 0x025E, 0xD81C, "NVMe DC SSD E1.L 18mm [D5-P5336](0x025E-0xD81C)"},
{0x025E, 0x0B60, 0x025E, 0xD81D, "NVMe DC SSD E1.L 9.5mm [D5-P5336](0x025E-0xD81D)"},
{0x025E, 0x0B70, 0xFFFF, 0xFFFF, "NVMe DC SSD [Yorktown controller](0x0B70)"},
{0x025E, 0x2B59, 0xFFFF, 0xFFFF, "NVMe DC SSD [Atomos Prime](0x2B59)"},
{0x025E, 0x2B59, 0x025E, 0x0008, "NVMe DC SSD U.2-SFF 15mm [D7-PS1010](0x025E-0x0008)"},
{0x025E, 0x2B59, 0x025E, 0x000C, "NVMe DC SSD E1.S 9.5mm [D7-PS1010](0x025E-0x000C)"},
{0x025E, 0x2B59, 0x025E, 0x000D, "NVMe DC SSD E1.S 15mm [D7-PS1010](0x025E-0x000D)"},
{0x025E, 0x2B59, 0x025E, 0x0019, "NVMe DC SSD E3.S-1T 7.5mm [D7-PS1010](0x025E-0x0019)"},
{0x025E, 0x2B59, 0x025E, 0x0108, "NVMe DC SSD U.2-SFF 15mm [D7-PS1030](0x025E-0x0108)"},
{0x025E, 0x2B59, 0x025E, 0x0119, "NVMe DC SSD E3.S-1T 7.5mm [D7-PS1030](0x025E-0x0119)"},
{0x025E, 0x2B59, 0x108E, 0x48A0, "NVMe DC SSD U.2-SFF 15mm 3.84TB [D7-PS1010 Custom](0x108E-0x48A0)"},
{0x025E, 0x2B59, 0x108E, 0x48A1, "NVMe DC SSD U.2-SFF 15mm 7.68TB [D7-PS1010 Custom](0x108E-0x48A1)"},
{0x025E, 0x2B59, 0x108E, 0x48A2, "NVMe DC SSD U.2-SFF 15mm 15.36TB [D7-PS1010 Custom](0x108E-0x48A2)"},
{0x025E, 0x2B59, 0x108E, 0x48A3, "NVMe DC SSD Add-In-Card [D7-PS1030 Custom](0x108E-0x48A3)"},
{0x025E, 0x2B59, 0x108E, 0x48A4, "NVMe DC SSD E3.S-1T 7.5mm 3.84TB [D7-PS1010 Custom](0x108E-0x48A4)"},
{0x025E, 0x2B59, 0x108E, 0x48A5, "NVMe DC SSD E3.S-1T 7.5mm 7.68TB [D7-PS1010 Custom](0x108E-0x48A5)"},
{0x025E, 0x2B59, 0x108E, 0x48A6, "NVMe DC SSD E3.S-1T 7.5mm 15.36TB [D7-PS1010 Custom](0x108E-0x48A6)"},
{0x025E, 0xF1AB, 0xFFFF, 0xFFFF, "P41 Plus NVMe SSD (DRAM-less) [Echo Harbor](0xF1AB)"},
{0x025E, 0xF1AC, 0xFFFF, 0xFFFF, "P44 Pro NVMe SSD [Hollywood Beach](0xF1AC)"},
}; /* pci_vid_025E[] */

static pci_id_t const pci_vid_0270[] = {
{0x0270, 0xFFFF, 0xFFFF, 0xFFFF, "Hauppauge computer works Inc. (Wrong ID)(0x0270)"},
}; /* pci_vid_0270[] */

static pci_id_t const pci_vid_0291[] = {
{0x0291, 0xFFFF, 0xFFFF, 0xFFFF, "Davicom Semiconductor, Inc. (Wrong ID)(0x0291)"},
}; /* pci_vid_0291[] */

static pci_id_t const pci_vid_02AC[] = {
{0x02AC, 0xFFFF, 0xFFFF, 0xFFFF, "SpeedStream(0x02AC)"},
{0x02AC, 0x1012, 0xFFFF, 0xFFFF, "1012 PCMCIA 10/100 Ethernet Card [RTL81xx](0x1012)"},
}; /* pci_vid_02AC[] */

static pci_id_t const pci_vid_02E0[] = {
{0x02E0, 0xFFFF, 0xFFFF, 0xFFFF, "XFX Pine Group Inc. (Wrong ID)(0x02E0)"},
}; /* pci_vid_02E0[] */

static pci_id_t const pci_vid_0303[] = {
{0x0303, 0xFFFF, 0xFFFF, 0xFFFF, "Hewlett-Packard Company (Wrong ID)(0x0303)"},
}; /* pci_vid_0303[] */

static pci_id_t const pci_vid_0308[] = {
{0x0308, 0xFFFF, 0xFFFF, 0xFFFF, "ZyXEL Communications Corporation (Wrong ID)(0x0308)"},
}; /* pci_vid_0308[] */

static pci_id_t const pci_vid_0315[] = {
{0x0315, 0xFFFF, 0xFFFF, 0xFFFF, "SK-Electronics Co., Ltd.(0x0315)"},
}; /* pci_vid_0315[] */

static pci_id_t const pci_vid_0357[] = {
{0x0357, 0xFFFF, 0xFFFF, 0xFFFF, "TTTech Computertechnik AG (Wrong ID)(0x0357)"},
{0x0357, 0x000A, 0xFFFF, 0xFFFF, "TTP-Monitoring Card V2.0(0x000A)"},
}; /* pci_vid_0357[] */

static pci_id_t const pci_vid_0432[] = {
{0x0432, 0xFFFF, 0xFFFF, 0xFFFF, "SCM Microsystems, Inc.(0x0432)"},
{0x0432, 0x0001, 0xFFFF, 0xFFFF, "Pluto2 DVB-T Receiver for PCMCIA [EasyWatch MobilSet](0x0001)"},
}; /* pci_vid_0432[] */

static pci_id_t const pci_vid_0497[] = {
{0x0497, 0xFFFF, 0xFFFF, 0xFFFF, "Dell Inc. (wrong ID)(0x0497)"},
}; /* pci_vid_0497[] */

static pci_id_t const pci_vid_060E[] = {
{0x060E, 0xFFFF, 0xFFFF, 0xFFFF, "Lightelligence(0x060E)"},
{0x060E, 0x0001, 0xFFFF, 0xFFFF, "Hummingbird ES(0x0001)"},
}; /* pci_vid_060E[] */

static pci_id_t const pci_vid_0675[] = {
{0x0675, 0xFFFF, 0xFFFF, 0xFFFF, "Dynalink(0x0675)"},
{0x0675, 0x1700, 0xFFFF, 0xFFFF, "IS64PH ISDN Adapter(0x1700)"},
{0x0675, 0x1702, 0xFFFF, 0xFFFF, "IS64PH ISDN Adapter(0x1702)"},
{0x0675, 0x1703, 0xFFFF, 0xFFFF, "ISDN Adapter (PCI Bus, DV, W)(0x1703)"},
{0x0675, 0x1704, 0xFFFF, 0xFFFF, "ISDN Adapter (PCI Bus, D, C)(0x1704)"},
}; /* pci_vid_0675[] */

static pci_id_t const pci_vid_0709[] = {
{0x0709, 0xFFFF, 0xFFFF, 0xFFFF, "LJMicro Co., Ltd(0x0709)"},
{0x0709, 0x0101, 0xFFFF, 0xFFFF, "GP101(0x0101)"},
{0x0709, 0x0102, 0xFFFF, 0xFFFF, "GP102(0x0102)"},
{0x0709, 0x0201, 0xFFFF, 0xFFFF, "GP201(0x0201)"},
{0x0709, 0x0202, 0xFFFF, 0xFFFF, "GP202(0x0202)"},
}; /* pci_vid_0709[] */

static pci_id_t const pci_vid_0721[] = {
{0x0721, 0xFFFF, 0xFFFF, 0xFFFF, "Sapphire, Inc.(0x0721)"},
}; /* pci_vid_0721[] */

static pci_id_t const pci_vid_0731[] = {
{0x0731, 0xFFFF, 0xFFFF, 0xFFFF, "Jingjia Microelectronics Co Ltd(0x0731)"},
{0x0731, 0x1100, 0xFFFF, 0xFFFF, "JM1100(0x1100)"},
{0x0731, 0x1100, 0x0731, 0x1101, "JM1100-C(0x0731-0x1101)"},
{0x0731, 0x1100, 0x0731, 0x1102, "JM1100-II(0x0731-0x1102)"},
{0x0731, 0x1100, 0x0731, 0x1103, "JM1100-I(0x0731-0x1103)"},
{0x0731, 0x1100, 0x0731, 0x1104, "JM1100-M(0x0731-0x1104)"},
{0x0731, 0x1100, 0x0731, 0x1105, "JM1100-Y(0x0731-0x1105)"},
{0x0731, 0x1100, 0x0731, 0x1106, "JM1100-EI(0x0731-0x1106)"},
{0x0731, 0x1100, 0x0731, 0x1107, "JM1100-EM(0x0731-0x1107)"},
{0x0731, 0x7200, 0xFFFF, 0xFFFF, "JM7200 Series GPU(0x7200)"},
{0x0731, 0x7200, 0x0731, 0x7201, "JM7201(0x0731-0x7201)"},
{0x0731, 0x7200, 0x0731, 0x7202, "JM7202(0x0731-0x7202)"},
{0x0731, 0x7200, 0x0731, 0x7208, "JM7200(0x0731-0x7208)"},
{0x0731, 0x7200, 0x0731, 0x7212, "JM7200(0x0731-0x7212)"},
{0x0731, 0x7200, 0x0731, 0x7214, "JM7500(0x0731-0x7214)"},
{0x0731, 0x7200, 0x0731, 0x7215, "JM7200(0x0731-0x7215)"},
{0x0731, 0x9100, 0xFFFF, 0xFFFF, "JM9100(0x9100)"},
{0x0731, 0x9100, 0x0731, 0x9101, "JM9100(0x0731-0x9101)"},
{0x0731, 0x9100, 0x0731, 0x9102, "JM9100-I(0x0731-0x9102)"},
{0x0731, 0x9100, 0x0731, 0x9103, "JM9100M(0x0731-0x9103)"},
{0x0731, 0x910A, 0xFFFF, 0xFFFF, "JH910(0x910A)"},
{0x0731, 0x910A, 0x0731, 0x910A, "JH910(0x0731-0x910A)"},
{0x0731, 0x910A, 0x0731, 0x910B, "JH910-I(0x0731-0x910B)"},
{0x0731, 0x910A, 0x0731, 0x910C, "JH910-M(0x0731-0x910C)"},
{0x0731, 0x9200, 0xFFFF, 0xFFFF, "JM9200(0x9200)"},
{0x0731, 0x920A, 0xFFFF, 0xFFFF, "JH920(0x920A)"},
{0x0731, 0x920A, 0x0731, 0x920A, "JH920(0x0731-0x920A)"},
{0x0731, 0x920A, 0x0731, 0x920B, "JH920-I(0x0731-0x920B)"},
{0x0731, 0x920A, 0x0731, 0x920C, "JH920-M(0x0731-0x920C)"},
{0x0731, 0x920B, 0xFFFF, 0xFFFF, "JH920-I(0x920B)"},
{0x0731, 0x920C, 0xFFFF, 0xFFFF, "JH920-M(0x920C)"},
{0x0731, 0x9210, 0xFFFF, 0xFFFF, "JM9210(0x9210)"},
{0x0731, 0x9210, 0x0731, 0x9210, "JM9210(0x0731-0x9210)"},
{0x0731, 0x9210, 0x0731, 0x9211, "JM9210-I(0x0731-0x9211)"},
{0x0731, 0x9211, 0xFFFF, 0xFFFF, "JM9210-I(0x9211)"},
{0x0731, 0x9230, 0xFFFF, 0xFFFF, "JM9230(0x9230)"},
{0x0731, 0x9230, 0x0731, 0x9230, "JM9230(0x0731-0x9230)"},
{0x0731, 0x9230, 0x0731, 0x9231, "JM9230-I(0x0731-0x9231)"},
{0x0731, 0x9231, 0xFFFF, 0xFFFF, "JM9231-I(0x9231)"},
{0x0731, 0x9250, 0xFFFF, 0xFFFF, "JM9250(0x9250)"},
{0x0731, 0x9250, 0x0731, 0x9250, "JM9250(0x0731-0x9250)"},
{0x0731, 0x930A, 0xFFFF, 0xFFFF, "JH930-I(0x930A)"},
{0x0731, 0x930A, 0x0731, 0x930A, "JH930-I(0x0731-0x930A)"},
{0x0731, 0x930A, 0x0731, 0x930B, "JH930-M(0x0731-0x930B)"},
{0x0731, 0x930A, 0x0731, 0x930C, "JH930(0x0731-0x930C)"},
{0x0731, 0x930B, 0xFFFF, 0xFFFF, "JH930-M(0x930B)"},
{0x0731, 0xF011, 0xFFFF, 0xFFFF, "JM1100-IV(0xF011)"},
{0x0731, 0xF111, 0xFFFF, 0xFFFF, "JM1100-MV(0xF111)"},
{0x0731, 0xFF11, 0xFFFF, 0xFFFF, "JM1100-YV(0xFF11)"},
}; /* pci_vid_0731[] */

static pci_id_t const pci_vid_0777[] = {
{0x0777, 0xFFFF, 0xFFFF, 0xFFFF, "Ubiquiti Networks, Inc.(0x0777)"},
}; /* pci_vid_0777[] */

static pci_id_t const pci_vid_0795[] = {
{0x0795, 0xFFFF, 0xFFFF, 0xFFFF, "Wired Inc.(0x0795)"},
{0x0795, 0x6663, 0xFFFF, 0xFFFF, "Butane II (MPEG2 encoder board)(0x6663)"},
{0x0795, 0x6666, 0xFFFF, 0xFFFF, "MediaPress (MPEG2 encoder board)(0x6666)"},
}; /* pci_vid_0795[] */

static pci_id_t const pci_vid_07D1[] = {
{0x07D1, 0xFFFF, 0xFFFF, 0xFFFF, "D-Link System Inc(0x07D1)"},
}; /* pci_vid_07D1[] */

static pci_id_t const pci_vid_0824[] = {
{0x0824, 0xFFFF, 0xFFFF, 0xFFFF, "T1042 [Freescale](0x0824)"},
}; /* pci_vid_0824[] */

static pci_id_t const pci_vid_0911[] = {
{0x0911, 0xFFFF, 0xFFFF, 0xFFFF, "Hantick(0x0911)"},
}; /* pci_vid_0911[] */

static pci_id_t const pci_vid_0925[] = {
{0x0925, 0xFFFF, 0xFFFF, 0xFFFF, "VIA Technologies, Inc. (Wrong ID)(0x0925)"},
}; /* pci_vid_0925[] */

static pci_id_t const pci_vid_0A89[] = {
{0x0A89, 0xFFFF, 0xFFFF, 0xFFFF, "BREA Technologies Inc(0x0A89)"},
}; /* pci_vid_0A89[] */

static pci_id_t const pci_vid_0B0B[] = {
{0x0B0B, 0xFFFF, 0xFFFF, 0xFFFF, "Rhino Equipment Corp.(0x0B0B)"},
{0x0B0B, 0x0105, 0xFFFF, 0xFFFF, "R1T1(0x0105)"},
{0x0B0B, 0x0205, 0xFFFF, 0xFFFF, "R4FXO(0x0205)"},
{0x0B0B, 0x0206, 0xFFFF, 0xFFFF, "RCB4FXO 4-channel FXO analog telephony card(0x0206)"},
{0x0B0B, 0x0305, 0xFFFF, 0xFFFF, "R4T1(0x0305)"},
{0x0B0B, 0x0405, 0xFFFF, 0xFFFF, "R8FXX(0x0405)"},
{0x0B0B, 0x0406, 0xFFFF, 0xFFFF, "RCB8FXX 8-channel modular analog telephony card(0x0406)"},
{0x0B0B, 0x0505, 0xFFFF, 0xFFFF, "R24FXX(0x0505)"},
{0x0B0B, 0x0506, 0xFFFF, 0xFFFF, "RCB24FXS 24-Channel FXS analog telephony card(0x0506)"},
{0x0B0B, 0x0605, 0xFFFF, 0xFFFF, "R2T1(0x0605)"},
{0x0B0B, 0x0705, 0xFFFF, 0xFFFF, "R24FXS(0x0705)"},
{0x0B0B, 0x0706, 0xFFFF, 0xFFFF, "RCB24FXO 24-Channel FXO analog telephony card(0x0706)"},
{0x0B0B, 0x0905, 0xFFFF, 0xFFFF, "R1T3 Single T3 Digital Telephony Card(0x0905)"},
{0x0B0B, 0x0906, 0xFFFF, 0xFFFF, "RCB24FXX 24-channel modular analog telephony card(0x0906)"},
{0x0B0B, 0x0A06, 0xFFFF, 0xFFFF, "RCB672FXX 672-channel modular analog telephony card(0x0A06)"},
}; /* pci_vid_0B0B[] */

static pci_id_t const pci_vid_0BAE[] = {
{0x0BAE, 0xFFFF, 0xFFFF, 0xFFFF, "Bachmann electronic GmbH(0x0BAE)"},
}; /* pci_vid_0BAE[] */

static pci_id_t const pci_vid_0CCD[] = {
{0x0CCD, 0xFFFF, 0xFFFF, 0xFFFF, "Preferred Networks, Inc.(0x0CCD)"},
{0x0CCD, 0x0110, 0xFFFF, 0xFFFF, "MN-Core(0x0110)"},
{0x0CCD, 0x0120, 0xFFFF, 0xFFFF, "MN-Core 2(0x0120)"},
{0x0CCD, 0x0120, 0x0CCD, 0x0000, "MN-Core 2 16GB(0x0CCD-0x0000)"},
{0x0CCD, 0x0120, 0x0CCD, 0x0010, "MN-Core 2 32GB(0x0CCD-0x0010)"},
{0x0CCD, 0x0200, 0xFFFF, 0xFFFF, "MN-Core Direct Connect(0x0200)"},
{0x0CCD, 0x0201, 0xFFFF, 0xFFFF, "MN-Core 2 Middle-plane(0x0201)"},
}; /* pci_vid_0CCD[] */

static pci_id_t const pci_vid_0E11[] = {
{0x0E11, 0xFFFF, 0xFFFF, 0xFFFF, "Compaq Computer Corporation(0x0E11)"},
{0x0E11, 0x0001, 0xFFFF, 0xFFFF, "PCI to EISA Bridge(0x0001)"},
{0x0E11, 0x0002, 0xFFFF, 0xFFFF, "PCI to ISA Bridge(0x0002)"},
{0x0E11, 0x0046, 0xFFFF, 0xFFFF, "Smart Array 64xx(0x0046)"},
{0x0E11, 0x0046, 0x0E11, 0x4091, "Smart Array 6i(0x0E11-0x4091)"},
{0x0E11, 0x0046, 0x0E11, 0x409A, "Smart Array 641(0x0E11-0x409A)"},
{0x0E11, 0x0046, 0x0E11, 0x409B, "Smart Array 642(0x0E11-0x409B)"},
{0x0E11, 0x0046, 0x0E11, 0x409C, "Smart Array 6400(0x0E11-0x409C)"},
{0x0E11, 0x0046, 0x0E11, 0x409D, "Smart Array 6400 EM(0x0E11-0x409D)"},
{0x0E11, 0x0049, 0xFFFF, 0xFFFF, "NC7132 Gigabit Upgrade Module(0x0049)"},
{0x0E11, 0x004A, 0xFFFF, 0xFFFF, "NC6136 Gigabit Server Adapter(0x004A)"},
{0x0E11, 0x005A, 0xFFFF, 0xFFFF, "Remote Insight II board - Lights-Out(0x005A)"},
{0x0E11, 0x007C, 0xFFFF, 0xFFFF, "NC7770 1000BaseTX(0x007C)"},
{0x0E11, 0x007D, 0xFFFF, 0xFFFF, "NC6770 1000BaseTX(0x007D)"},
{0x0E11, 0x0085, 0xFFFF, 0xFFFF, "NC7780 1000BaseTX(0x0085)"},
{0x0E11, 0x00B1, 0xFFFF, 0xFFFF, "Remote Insight II board - PCI device(0x00B1)"},
{0x0E11, 0x00BB, 0xFFFF, 0xFFFF, "NC7760(0x00BB)"},
{0x0E11, 0x00CA, 0xFFFF, 0xFFFF, "NC7771(0x00CA)"},
{0x0E11, 0x00CB, 0xFFFF, 0xFFFF, "NC7781(0x00CB)"},
{0x0E11, 0x00CF, 0xFFFF, 0xFFFF, "NC7772(0x00CF)"},
{0x0E11, 0x00D0, 0xFFFF, 0xFFFF, "NC7782(0x00D0)"},
{0x0E11, 0x00D1, 0xFFFF, 0xFFFF, "NC7783(0x00D1)"},
{0x0E11, 0x00E3, 0xFFFF, 0xFFFF, "NC7761(0x00E3)"},
{0x0E11, 0x0508, 0xFFFF, 0xFFFF, "Netelligent 4/16 Token Ring(0x0508)"},
{0x0E11, 0x1000, 0xFFFF, 0xFFFF, "Triflex/Pentium Bridge, Model 1000(0x1000)"},
{0x0E11, 0x2000, 0xFFFF, 0xFFFF, "Triflex/Pentium Bridge, Model 2000(0x2000)"},
{0x0E11, 0x3032, 0xFFFF, 0xFFFF, "QVision 1280/p(0x3032)"},
{0x0E11, 0x3033, 0xFFFF, 0xFFFF, "QVision 1280/p(0x3033)"},
{0x0E11, 0x3034, 0xFFFF, 0xFFFF, "QVision 1280/p(0x3034)"},
{0x0E11, 0x4000, 0xFFFF, 0xFFFF, "4000 [Triflex](0x4000)"},
{0x0E11, 0x4040, 0xFFFF, 0xFFFF, "Integrated Array(0x4040)"},
{0x0E11, 0x4048, 0xFFFF, 0xFFFF, "Compaq Raid LC2(0x4048)"},
{0x0E11, 0x4050, 0xFFFF, 0xFFFF, "Smart Array 4200(0x4050)"},
{0x0E11, 0x4051, 0xFFFF, 0xFFFF, "Smart Array 4250ES(0x4051)"},
{0x0E11, 0x4058, 0xFFFF, 0xFFFF, "Smart Array 431(0x4058)"},
{0x0E11, 0x4070, 0xFFFF, 0xFFFF, "Smart Array 5300(0x4070)"},
{0x0E11, 0x4080, 0xFFFF, 0xFFFF, "Smart Array 5i(0x4080)"},
{0x0E11, 0x4082, 0xFFFF, 0xFFFF, "Smart Array 532(0x4082)"},
{0x0E11, 0x4083, 0xFFFF, 0xFFFF, "Smart Array 5312(0x4083)"},
{0x0E11, 0x4091, 0xFFFF, 0xFFFF, "Smart Array 6i(0x4091)"},
{0x0E11, 0x409A, 0xFFFF, 0xFFFF, "Smart Array 641(0x409A)"},
{0x0E11, 0x409B, 0xFFFF, 0xFFFF, "Smart Array 642(0x409B)"},
{0x0E11, 0x409C, 0xFFFF, 0xFFFF, "Smart Array 6400(0x409C)"},
{0x0E11, 0x409D, 0xFFFF, 0xFFFF, "Smart Array 6400 EM(0x409D)"},
{0x0E11, 0x6010, 0xFFFF, 0xFFFF, "HotPlug PCI Bridge 6010(0x6010)"},
{0x0E11, 0x7020, 0xFFFF, 0xFFFF, "USB Controller(0x7020)"},
{0x0E11, 0xA0EC, 0xFFFF, 0xFFFF, "Fibre Channel Host Controller(0xA0EC)"},
{0x0E11, 0xA0F0, 0xFFFF, 0xFFFF, "Advanced System Management Controller(0xA0F0)"},
{0x0E11, 0xA0F0, 0x0E11, 0xB0F3, "ProLiant DL360(0x0E11-0xB0F3)"},
{0x0E11, 0xA0F3, 0xFFFF, 0xFFFF, "Triflex PCI to ISA Bridge(0xA0F3)"},
{0x0E11, 0xA0F7, 0xFFFF, 0xFFFF, "PCI Hotplug Controller(0xA0F7)"},
{0x0E11, 0xA0F7, 0x8086, 0x002A, "PCI Hotplug Controller A(0x8086-0x002A)"},
{0x0E11, 0xA0F7, 0x8086, 0x002B, "PCI Hotplug Controller B(0x8086-0x002B)"},
{0x0E11, 0xA0F8, 0xFFFF, 0xFFFF, "ZFMicro Chipset USB(0xA0F8)"},
{0x0E11, 0xA0FC, 0xFFFF, 0xFFFF, "FibreChannel HBA Tachyon(0xA0FC)"},
{0x0E11, 0xAE10, 0xFFFF, 0xFFFF, "Smart-2/P RAID Controller(0xAE10)"},
{0x0E11, 0xAE10, 0x0E11, 0x4030, "Smart-2/P Array Controller(0x0E11-0x4030)"},
{0x0E11, 0xAE10, 0x0E11, 0x4031, "Smart-2SL Array Controller(0x0E11-0x4031)"},
{0x0E11, 0xAE10, 0x0E11, 0x4032, "Smart Array 3200 Controller(0x0E11-0x4032)"},
{0x0E11, 0xAE10, 0x0E11, 0x4033, "Smart Array 3100ES Controller(0x0E11-0x4033)"},
{0x0E11, 0xAE10, 0x0E11, 0x4034, "Smart Array 221 Controller(0x0E11-0x4034)"},
{0x0E11, 0xAE29, 0xFFFF, 0xFFFF, "MIS-L(0xAE29)"},
{0x0E11, 0xAE2A, 0xFFFF, 0xFFFF, "MPC(0xAE2A)"},
{0x0E11, 0xAE2B, 0xFFFF, 0xFFFF, "MIS-E(0xAE2B)"},
{0x0E11, 0xAE31, 0xFFFF, 0xFFFF, "System Management Controller(0xAE31)"},
{0x0E11, 0xAE32, 0xFFFF, 0xFFFF, "Netelligent 10/100 TX PCI UTP(0xAE32)"},
{0x0E11, 0xAE33, 0xFFFF, 0xFFFF, "Triflex Dual EIDE Controller(0xAE33)"},
{0x0E11, 0xAE34, 0xFFFF, 0xFFFF, "Netelligent 10 T PCI UTP(0xAE34)"},
{0x0E11, 0xAE35, 0xFFFF, 0xFFFF, "Integrated NetFlex-3/P(0xAE35)"},
{0x0E11, 0xAE40, 0xFFFF, 0xFFFF, "Netelligent Dual 10/100 TX PCI UTP(0xAE40)"},
{0x0E11, 0xAE43, 0xFFFF, 0xFFFF, "Netelligent Integrated 10/100 TX UTP(0xAE43)"},
{0x0E11, 0xAE69, 0xFFFF, 0xFFFF, "CETUS-L(0xAE69)"},
{0x0E11, 0xAE6C, 0xFFFF, 0xFFFF, "Northstar(0xAE6C)"},
{0x0E11, 0xAE6D, 0xFFFF, 0xFFFF, "NorthStar CPU to PCI Bridge(0xAE6D)"},
{0x0E11, 0xB011, 0xFFFF, 0xFFFF, "Netelligent 10/100 TX Embedded UTP(0xB011)"},
{0x0E11, 0xB012, 0xFFFF, 0xFFFF, "Netelligent 10 T/2 PCI UTP/Coax(0xB012)"},
{0x0E11, 0xB01E, 0xFFFF, 0xFFFF, "NC3120 Fast Ethernet NIC(0xB01E)"},
{0x0E11, 0xB01F, 0xFFFF, 0xFFFF, "NC3122 Fast Ethernet NIC(0xB01F)"},
{0x0E11, 0xB02F, 0xFFFF, 0xFFFF, "NC1120 Ethernet NIC(0xB02F)"},
{0x0E11, 0xB030, 0xFFFF, 0xFFFF, "Netelligent 10/100 TX UTP(0xB030)"},
{0x0E11, 0xB04A, 0xFFFF, 0xFFFF, "10/100 TX PCI Intel WOL UTP Controller(0xB04A)"},
{0x0E11, 0xB060, 0xFFFF, 0xFFFF, "Smart Array 5300 Controller(0xB060)"},
{0x0E11, 0xB0C6, 0xFFFF, 0xFFFF, "NC3161 Fast Ethernet NIC(0xB0C6)"},
{0x0E11, 0xB0C7, 0xFFFF, 0xFFFF, "NC3160 Fast Ethernet NIC(0xB0C7)"},
{0x0E11, 0xB0D7, 0xFFFF, 0xFFFF, "NC3121 Fast Ethernet NIC(0xB0D7)"},
{0x0E11, 0xB0DD, 0xFFFF, 0xFFFF, "NC3131 Fast Ethernet NIC(0xB0DD)"},
{0x0E11, 0xB0DE, 0xFFFF, 0xFFFF, "NC3132 Fast Ethernet Module(0xB0DE)"},
{0x0E11, 0xB0DF, 0xFFFF, 0xFFFF, "NC6132 Gigabit Module(0xB0DF)"},
{0x0E11, 0xB0E0, 0xFFFF, 0xFFFF, "NC6133 Gigabit Module(0xB0E0)"},
{0x0E11, 0xB0E1, 0xFFFF, 0xFFFF, "NC3133 Fast Ethernet Module(0xB0E1)"},
{0x0E11, 0xB123, 0xFFFF, 0xFFFF, "NC6134 Gigabit NIC(0xB123)"},
{0x0E11, 0xB134, 0xFFFF, 0xFFFF, "NC3163 Fast Ethernet NIC(0xB134)"},
{0x0E11, 0xB13C, 0xFFFF, 0xFFFF, "NC3162 Fast Ethernet NIC(0xB13C)"},
{0x0E11, 0xB144, 0xFFFF, 0xFFFF, "NC3123 Fast Ethernet NIC(0xB144)"},
{0x0E11, 0xB163, 0xFFFF, 0xFFFF, "NC3134 Fast Ethernet NIC(0xB163)"},
{0x0E11, 0xB164, 0xFFFF, 0xFFFF, "NC3165 Fast Ethernet Upgrade Module(0xB164)"},
{0x0E11, 0xB178, 0xFFFF, 0xFFFF, "Smart Array 5i/532(0xB178)"},
{0x0E11, 0xB178, 0x0E11, 0x4080, "Smart Array 5i(0x0E11-0x4080)"},
{0x0E11, 0xB178, 0x0E11, 0x4082, "Smart Array 532(0x0E11-0x4082)"},
{0x0E11, 0xB178, 0x0E11, 0x4083, "Smart Array 5312(0x0E11-0x4083)"},
{0x0E11, 0xB1A4, 0xFFFF, 0xFFFF, "NC7131 Gigabit Server Adapter(0xB1A4)"},
{0x0E11, 0xB200, 0xFFFF, 0xFFFF, "Memory Hot-Plug Controller(0xB200)"},
{0x0E11, 0xB203, 0xFFFF, 0xFFFF, "Integrated Lights Out Controller(0xB203)"},
{0x0E11, 0xB203, 0x103C, 0x3305, "iLO2(0x103C-0x3305)"},
{0x0E11, 0xB204, 0xFFFF, 0xFFFF, "Integrated Lights Out  Processor(0xB204)"},
{0x0E11, 0xB204, 0x103C, 0x3305, "iLO2(0x103C-0x3305)"},
{0x0E11, 0xC000, 0xFFFF, 0xFFFF, "Remote Insight Lights-Out Edition(0xC000)"},
{0x0E11, 0xF130, 0xFFFF, 0xFFFF, "NetFlex-3/P ThunderLAN 1.0(0xF130)"},
{0x0E11, 0xF150, 0xFFFF, 0xFFFF, "NetFlex-3/P ThunderLAN 2.3(0xF150)"},
}; /* pci_vid_0E11[] */

static pci_id_t const pci_vid_0E55[] = {
{0x0E55, 0xFFFF, 0xFFFF, 0xFFFF, "HaSoTec GmbH(0x0E55)"},
}; /* pci_vid_0E55[] */

static pci_id_t const pci_vid_0EAC[] = {
{0x0EAC, 0xFFFF, 0xFFFF, 0xFFFF, "SHF Communication Technologies AG(0x0EAC)"},
{0x0EAC, 0x0008, 0xFFFF, 0xFFFF, "Ethernet Powerlink Managing Node 01(0x0008)"},
}; /* pci_vid_0EAC[] */

static pci_id_t const pci_vid_0F62[] = {
{0x0F62, 0xFFFF, 0xFFFF, 0xFFFF, "Acrox Technologies Co., Ltd.(0x0F62)"},
}; /* pci_vid_0F62[] */

static pci_id_t const pci_vid_1000[] = {
{0x1000, 0xFFFF, 0xFFFF, 0xFFFF, "Broadcom / LSI(0x1000)"},
{0x1000, 0x0001, 0xFFFF, 0xFFFF, "53c810(0x0001)"},
{0x1000, 0x0001, 0x1000, 0x1000, "LSI53C810AE PCI to SCSI I/O Processor(0x1000-0x1000)"},
{0x1000, 0x0002, 0xFFFF, 0xFFFF, "53c820(0x0002)"},
{0x1000, 0x0003, 0xFFFF, 0xFFFF, "53c825(0x0003)"},
{0x1000, 0x0003, 0x1000, 0x1000, "LSI53C825AE PCI to SCSI I/O Processor (Ultra Wide)(0x1000-0x1000)"},
{0x1000, 0x0004, 0xFFFF, 0xFFFF, "53c815(0x0004)"},
{0x1000, 0x0005, 0xFFFF, 0xFFFF, "53c810AP(0x0005)"},
{0x1000, 0x0006, 0xFFFF, 0xFFFF, "53c860(0x0006)"},
{0x1000, 0x0006, 0x1000, 0x1000, "LSI53C860E PCI to Ultra SCSI I/O Processor(0x1000-0x1000)"},
{0x1000, 0x000A, 0xFFFF, 0xFFFF, "53c1510(0x000A)"},
{0x1000, 0x000A, 0x0E11, 0xB143, "Integrated Dual Channel Wide Ultra2 SCSI Controller(0x0E11-0xB143)"},
{0x1000, 0x000A, 0x1000, 0x1000, "LSI53C1510 PCI to Dual Channel Wide Ultra2 SCSI Controller (Nonintelligent mode)(0x1000-0x1000)"},
{0x1000, 0x000B, 0xFFFF, 0xFFFF, "53C896/897(0x000B)"},
{0x1000, 0x000B, 0x0E11, 0x6004, "EOB003 Series SCSI host adapter(0x0E11-0x6004)"},
{0x1000, 0x000B, 0x1000, 0x1000, "LSI53C896/7 PCI to Dual Channel Ultra2 SCSI Multifunction Controller(0x1000-0x1000)"},
{0x1000, 0x000B, 0x1000, 0x1010, "LSI22910 PCI to Dual Channel Ultra2 SCSI host adapter(0x1000-0x1010)"},
{0x1000, 0x000B, 0x1000, 0x1020, "LSI21002 PCI to Dual Channel Ultra2 SCSI host adapter(0x1000-0x1020)"},
{0x1000, 0x000B, 0x13E9, 0x1000, "6221L-4U (Dual U2W SCSI, dual 10/100TX, graphics)(0x13E9-0x1000)"},
{0x1000, 0x000C, 0xFFFF, 0xFFFF, "53c895(0x000C)"},
{0x1000, 0x000C, 0x1000, 0x1010, "LSI8951U PCI to Ultra2 SCSI host adapter(0x1000-0x1010)"},
{0x1000, 0x000C, 0x1000, 0x1020, "LSI8952U PCI to Ultra2 SCSI host adapter(0x1000-0x1020)"},
{0x1000, 0x000C, 0x1DE1, 0x3906, "DC-390U2B SCSI adapter(0x1DE1-0x3906)"},
{0x1000, 0x000C, 0x1DE1, 0x3907, "DC-390U2W(0x1DE1-0x3907)"},
{0x1000, 0x000D, 0xFFFF, 0xFFFF, "53c885(0x000D)"},
{0x1000, 0x000F, 0xFFFF, 0xFFFF, "53c875(0x000F)"},
{0x1000, 0x000F, 0x0E11, 0x7004, "Embedded Ultra Wide SCSI Controller(0x0E11-0x7004)"},
{0x1000, 0x000F, 0x1000, 0x1000, "LSI53C876/E PCI to Dual Channel SCSI Controller(0x1000-0x1000)"},
{0x1000, 0x000F, 0x1000, 0x1010, "LSI22801 PCI to Dual Channel Ultra SCSI host adapter(0x1000-0x1010)"},
{0x1000, 0x000F, 0x1000, 0x1020, "LSI22802 PCI to Dual Channel Ultra SCSI host adapter(0x1000-0x1020)"},
{0x1000, 0x000F, 0x1092, 0x8760, "FirePort 40 Dual SCSI Controller(0x1092-0x8760)"},
{0x1000, 0x000F, 0x1775, 0x10D0, "V5D Single Board Computer Wide Ultra SCSI(0x1775-0x10D0)"},
{0x1000, 0x000F, 0x1775, 0x10D1, "V5D Single Board Computer Ultra SCSI(0x1775-0x10D1)"},
{0x1000, 0x000F, 0x1DE1, 0x3904, "DC390F/U Ultra Wide SCSI Adapter(0x1DE1-0x3904)"},
{0x1000, 0x000F, 0x4C53, 0x1000, "CC7/CR7/CP7/VC7/VP7/VR7 mainboard(0x4C53-0x1000)"},
{0x1000, 0x000F, 0x4C53, 0x1050, "CT7 mainboard(0x4C53-0x1050)"},
{0x1000, 0x0010, 0xFFFF, 0xFFFF, "53C1510(0x0010)"},
{0x1000, 0x0010, 0x0E11, 0x4040, "Integrated Smart Array Controller(0x0E11-0x4040)"},
{0x1000, 0x0010, 0x0E11, 0x4048, "RAID LC2 Controller(0x0E11-0x4048)"},
{0x1000, 0x0010, 0x1000, 0x1000, "53C1510 PCI to Dual Channel Wide Ultra2 SCSI Controller (Intelligent mode)(0x1000-0x1000)"},
{0x1000, 0x0012, 0xFFFF, 0xFFFF, "53c895a(0x0012)"},
{0x1000, 0x0012, 0x1000, 0x1000, "LSI53C895A PCI to Ultra2 SCSI Controller(0x1000-0x1000)"},
{0x1000, 0x0013, 0xFFFF, 0xFFFF, "53c875a(0x0013)"},
{0x1000, 0x0013, 0x1000, 0x1000, "LSI53C875A PCI to Ultra SCSI Controller(0x1000-0x1000)"},
{0x1000, 0x0014, 0xFFFF, 0xFFFF, "MegaRAID Tri-Mode SAS3516(0x0014)"},
{0x1000, 0x0014, 0x1000, 0x9460, "MegaRAID 9460-16i(0x1000-0x9460)"},
{0x1000, 0x0014, 0x1000, 0x9480, "MegaRAID 9480-8i8e(0x1000-0x9480)"},
{0x1000, 0x0014, 0x1000, 0x9481, "MegaRAID 9480-8e(0x1000-0x9481)"},
{0x1000, 0x0014, 0x1028, 0x1F3A, "PERC H745 Adapter(0x1028-0x1F3A)"},
{0x1000, 0x0014, 0x1028, 0x1F3B, "PERC H745 Front(0x1028-0x1F3B)"},
{0x1000, 0x0014, 0x1028, 0x1FD4, "PERC H745P MX(0x1028-0x1FD4)"},
{0x1000, 0x0014, 0x1137, 0x020E, "UCSC-RAID-M5 12G Modular RAID Controller(0x1137-0x020E)"},
{0x1000, 0x0014, 0x1D49, 0x0602, "ThinkSystem RAID 930-16i 4GB Flash PCIe 12Gb Adapter(0x1D49-0x0602)"},
{0x1000, 0x0014, 0x1D49, 0x0604, "ThinkSystem RAID 930-8e 4GB Flash PCIe 12Gb Adapter(0x1D49-0x0604)"},
{0x1000, 0x0014, 0x1D49, 0x0607, "ThinkSystem RAID 930-16i 8GB Flash PCIe 12Gb Adapter(0x1D49-0x0607)"},
{0x1000, 0x0014, 0x8086, 0x352D, "Integrated RAID Module RMSP3AD160F(0x8086-0x352D)"},
{0x1000, 0x0014, 0x8086, 0x9460, "RAID Controller RSP3TD160F(0x8086-0x9460)"},
{0x1000, 0x0014, 0x8086, 0x9480, "RAID Controller RSP3MD088F(0x8086-0x9480)"},
{0x1000, 0x0015, 0xFFFF, 0xFFFF, "MegaRAID Tri-Mode SAS3416(0x0015)"},
{0x1000, 0x0015, 0x1000, 0x9441, "MegaRAID 9440-16i(0x1000-0x9441)"},
{0x1000, 0x0015, 0x1028, 0x1F3C, "PERC H345 Adapter(0x1028-0x1F3C)"},
{0x1000, 0x0015, 0x1028, 0x1F3D, "PERC H345 Front(0x1028-0x1F3D)"},
{0x1000, 0x0015, 0x1D49, 0x0503, "ThinkSystem RAID 530-16i PCIe 12Gb Adapter(0x1D49-0x0503)"},
{0x1000, 0x0016, 0xFFFF, 0xFFFF, "MegaRAID Tri-Mode SAS3508(0x0016)"},
{0x1000, 0x0016, 0x1000, 0x9461, "MegaRAID 9460-8i(0x1000-0x9461)"},
{0x1000, 0x0016, 0x1000, 0x9462, "MegaRAID 9460-4i(0x1000-0x9462)"},
{0x1000, 0x0016, 0x1000, 0x9463, "MegaRAID 9365-28i(0x1000-0x9463)"},
{0x1000, 0x0016, 0x1000, 0x9464, "MegaRAID 9365-24i(0x1000-0x9464)"},
{0x1000, 0x0016, 0x1028, 0x1FC9, "PERC H840 Adapter(0x1028-0x1FC9)"},
{0x1000, 0x0016, 0x1028, 0x1FCB, "PERC H740P Adapter(0x1028-0x1FCB)"},
{0x1000, 0x0016, 0x1028, 0x1FCD, "PERC H740P Mini(0x1028-0x1FCD)"},
{0x1000, 0x0016, 0x1028, 0x1FCF, "PERC H740P Mini(0x1028-0x1FCF)"},
{0x1000, 0x0016, 0x1D49, 0x0601, "ThinkSystem RAID 930-8i 2GB Flash PCIe 12Gb Adapter(0x1D49-0x0601)"},
{0x1000, 0x0016, 0x1D49, 0x0603, "ThinkSystem RAID 930-24i 4GB Flash PCIe 12Gb Adapter(0x1D49-0x0603)"},
{0x1000, 0x0016, 0x8086, 0x352E, "Integrated RAID Module RMSP3CD080F(0x8086-0x352E)"},
{0x1000, 0x0016, 0x8086, 0x352F, "Integrated RAID Module RMSP3HD080E(0x8086-0x352F)"},
{0x1000, 0x0016, 0x8086, 0x9461, "RAID Controller RSP3DD080F(0x8086-0x9461)"},
{0x1000, 0x0017, 0xFFFF, 0xFFFF, "MegaRAID Tri-Mode SAS3408(0x0017)"},
{0x1000, 0x0017, 0x1000, 0x9440, "MegaRAID 9440-8i(0x1000-0x9440)"},
{0x1000, 0x0017, 0x1000, 0x9442, "MegaRAID 9440-4i(0x1000-0x9442)"},
{0x1000, 0x0017, 0x1D49, 0x0500, "ThinkSystem RAID 530-8i PCIe 12Gb Adapter(0x1D49-0x0500)"},
{0x1000, 0x0017, 0x1D49, 0x0502, "ThinkSystem RAID 530-8i Dense Adapter(0x1D49-0x0502)"},
{0x1000, 0x0017, 0x8086, 0x3528, "Integrated RAID RMSP3LD060(0x8086-0x3528)"},
{0x1000, 0x0017, 0x8086, 0x3529, "Integrated RAID RMSP3LD060(0x8086-0x3529)"},
{0x1000, 0x0017, 0x8086, 0x9441, "RAID Controller RSP3WD080E(0x8086-0x9441)"},
{0x1000, 0x001B, 0xFFFF, 0xFFFF, "MegaRAID Tri-Mode SAS3504(0x001B)"},
{0x1000, 0x001B, 0x1D49, 0x0605, "ThinkSystem RAID 930-4i 2GB Flash Flex Adapter(0x1D49-0x0605)"},
{0x1000, 0x001C, 0xFFFF, 0xFFFF, "MegaRAID Tri-Mode SAS3404(0x001C)"},
{0x1000, 0x001C, 0x1D49, 0x0501, "ThinkSystem RAID 530-4i Flex Adapter(0x1D49-0x0501)"},
{0x1000, 0x0020, 0xFFFF, 0xFFFF, "53c1010 Ultra3 SCSI Adapter(0x0020)"},
{0x1000, 0x0020, 0x1000, 0x1000, "LSI53C1010-33 PCI to Dual Channel Ultra160 SCSI Controller(0x1000-0x1000)"},
{0x1000, 0x0020, 0x107B, 0x1040, "Server Onboard 53C1010-33(0x107B-0x1040)"},
{0x1000, 0x0020, 0x1DE1, 0x1020, "DC-390U3W(0x1DE1-0x1020)"},
{0x1000, 0x0021, 0xFFFF, 0xFFFF, "53c1010 66MHz  Ultra3 SCSI Adapter(0x0021)"},
{0x1000, 0x0021, 0x1000, 0x1000, "LSI53C1000/1000R/1010R/1010-66 PCI to Ultra160 SCSI Controller(0x1000-0x1000)"},
{0x1000, 0x0021, 0x1000, 0x1010, "Asus TR-DLS onboard 53C1010-66(0x1000-0x1010)"},
{0x1000, 0x0021, 0x103C, 0x1300, "Ultra160 SCSI [AB306A](0x103C-0x1300)"},
{0x1000, 0x0021, 0x103C, 0x1310, "Ultra160 SCSI [A9918A](0x103C-0x1310)"},
{0x1000, 0x0021, 0x103C, 0x1330, "Ultra160 SCSI [A7059A](0x103C-0x1330)"},
{0x1000, 0x0021, 0x103C, 0x1340, "Ultra160 SCSI [A7060A](0x103C-0x1340)"},
{0x1000, 0x0021, 0x124B, 0x1070, "PMC-USCSI3(0x124B-0x1070)"},
{0x1000, 0x0021, 0x4C53, 0x1080, "CT8 mainboard(0x4C53-0x1080)"},
{0x1000, 0x0021, 0x4C53, 0x1300, "P017 mezzanine (32-bit PMC)(0x4C53-0x1300)"},
{0x1000, 0x0021, 0x4C53, 0x1310, "P017 mezzanine (64-bit PMC)(0x4C53-0x1310)"},
{0x1000, 0x002F, 0xFFFF, 0xFFFF, "MegaRAID SAS 2208 IOV [Thunderbolt](0x002F)"},
{0x1000, 0x002F, 0x1028, 0x1F39, "SPERC8-e(0x1028-0x1F39)"},
{0x1000, 0x002F, 0x1028, 0x1F3E, "SPERC 8(0x1028-0x1F3E)"},
{0x1000, 0x0030, 0xFFFF, 0xFFFF, "53c1030 PCI-X Fusion-MPT Dual Ultra320 SCSI(0x0030)"},
{0x1000, 0x0030, 0x0E11, 0x00DA, "ProLiant ML 350(0x0E11-0x00DA)"},
{0x1000, 0x0030, 0x1028, 0x0123, "LSI Logic 1020/1030(0x1028-0x0123)"},
{0x1000, 0x0030, 0x1028, 0x014A, "LSI Logic 1020/1030(0x1028-0x014A)"},
{0x1000, 0x0030, 0x1028, 0x016C, "PowerEdge 1850 MPT Fusion SCSI/RAID (Perc 4)(0x1028-0x016C)"},
{0x1000, 0x0030, 0x1028, 0x0183, "LSI Logic 1020/1030(0x1028-0x0183)"},
{0x1000, 0x0030, 0x1028, 0x018A, "PERC 4/IM(0x1028-0x018A)"},
{0x1000, 0x0030, 0x1028, 0x1010, "LSI U320 SCSI Controller(0x1028-0x1010)"},
{0x1000, 0x0030, 0x103C, 0x12C5, "Ultra320 SCSI [A7173A](0x103C-0x12C5)"},
{0x1000, 0x0030, 0x103C, 0x1323, "Core I/O LAN/SCSI Combo [AB314A](0x103C-0x1323)"},
{0x1000, 0x0030, 0x103C, 0x3108, "Single Channel Ultra320 SCSI HBA G2(0x103C-0x3108)"},
{0x1000, 0x0030, 0x103C, 0x322A, "SC11Xe Ultra320 Single Channel PCIe x4 SCSI Host Bus Adapter (412911-B21)(0x103C-0x322A)"},
{0x1000, 0x0030, 0x124B, 0x1170, "PMC-USCSI320(0x124B-0x1170)"},
{0x1000, 0x0030, 0x15AD, 0x1976, "LSI Logic Parallel SCSI Controller (emulated)(0x15AD-0x1976)"},
{0x1000, 0x0030, 0x1734, 0x1052, "PRIMERGY BX/RX/TX S2 series onboard SCSI(IME)(0x1734-0x1052)"},
{0x1000, 0x0031, 0xFFFF, 0xFFFF, "53c1030ZC PCI-X Fusion-MPT Dual Ultra320 SCSI(0x0031)"},
{0x1000, 0x0032, 0xFFFF, 0xFFFF, "53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI(0x0032)"},
{0x1000, 0x0032, 0x1000, 0x1000, "LSI53C1020/1030 PCI-X to Ultra320 SCSI Controller(0x1000-0x1000)"},
{0x1000, 0x0033, 0xFFFF, 0xFFFF, "1030ZC_53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI(0x0033)"},
{0x1000, 0x0040, 0xFFFF, 0xFFFF, "53c1035 PCI-X Fusion-MPT Dual Ultra320 SCSI(0x0040)"},
{0x1000, 0x0040, 0x1000, 0x0033, "MegaRAID SCSI 320-2XR(0x1000-0x0033)"},
{0x1000, 0x0040, 0x1000, 0x0066, "MegaRAID SCSI 320-2XRWS(0x1000-0x0066)"},
{0x1000, 0x0041, 0xFFFF, 0xFFFF, "53C1035ZC PCI-X Fusion-MPT Dual Ultra320 SCSI(0x0041)"},
{0x1000, 0x0050, 0xFFFF, 0xFFFF, "SAS1064 PCI-X Fusion-MPT SAS(0x0050)"},
{0x1000, 0x0050, 0x1028, 0x1F04, "SAS 5/E(0x1028-0x1F04)"},
{0x1000, 0x0050, 0x1028, 0x1F09, "SAS 5i/R(0x1028-0x1F09)"},
{0x1000, 0x0052, 0xFFFF, 0xFFFF, "MegaRAID SAS-3 3216/3224 [Cutlass](0x0052)"},
{0x1000, 0x0053, 0xFFFF, 0xFFFF, "MegaRAID SAS-3 3216/3224 [Cutlass](0x0053)"},
{0x1000, 0x0053, 0x1000, 0x9350, "MegaRAID SAS 9341-16i(0x1000-0x9350)"},
{0x1000, 0x0053, 0x1000, 0x9351, "MegaRAID SAS 9341-24i(0x1000-0x9351)"},
{0x1000, 0x0054, 0xFFFF, 0xFFFF, "SAS1068 PCI-X Fusion-MPT SAS(0x0054)"},
{0x1000, 0x0054, 0x1028, 0x1F04, "SAS 5/E Adapter Controller(0x1028-0x1F04)"},
{0x1000, 0x0054, 0x1028, 0x1F05, "SAS 5/i Adapter Controller(0x1028-0x1F05)"},
{0x1000, 0x0054, 0x1028, 0x1F06, "SAS 5/i Integrated Controller(0x1028-0x1F06)"},
{0x1000, 0x0054, 0x1028, 0x1F07, "SAS 5/iR Integrated RAID Controller(0x1028-0x1F07)"},
{0x1000, 0x0054, 0x1028, 0x1F08, "SAS 5/iR Integrated RAID Controller(0x1028-0x1F08)"},
{0x1000, 0x0054, 0x1028, 0x1F09, "SAS 5/iR Adapter RAID Controller(0x1028-0x1F09)"},
{0x1000, 0x0054, 0x103C, 0x3228, "SAS3080X-HP 8-port PCI-X 133MHz Host Bus Adapter with 2xSFF-8484(0x103C-0x3228)"},
{0x1000, 0x0054, 0x15AD, 0x1976, "SAS Controller(0x15AD-0x1976)"},
{0x1000, 0x0055, 0xFFFF, 0xFFFF, "SAS1068 PCI-X Fusion-MPT SAS(0x0055)"},
{0x1000, 0x0055, 0x1033, 0x8336, "SAS1068(0x1033-0x8336)"},
{0x1000, 0x0056, 0xFFFF, 0xFFFF, "SAS1064ET PCI-Express Fusion-MPT SAS(0x0056)"},
{0x1000, 0x0056, 0x1014, 0x03BB, "ServeRAID BR10il SAS/SATA Controller v2(0x1014-0x03BB)"},
{0x1000, 0x0056, 0x8086, 0x34DC, "AXX4SASMOD RAID Controller(0x8086-0x34DC)"},
{0x1000, 0x0057, 0xFFFF, 0xFFFF, "M1064E MegaRAID SAS(0x0057)"},
{0x1000, 0x0057, 0x8086, 0x346C, "Embedded Software RAID Technology II (ESTRII)(0x8086-0x346C)"},
{0x1000, 0x0058, 0xFFFF, 0xFFFF, "SAS1068E PCI-Express Fusion-MPT SAS(0x0058)"},
{0x1000, 0x0058, 0x1000, 0x3140, "SAS3081E-R 8-Port SAS/SATA Host Bus Adapter(0x1000-0x3140)"},
{0x1000, 0x0058, 0x1028, 0x021D, "SAS 6/iR Integrated Workstations RAID Controller(0x1028-0x021D)"},
{0x1000, 0x0058, 0x1028, 0x1F0E, "SAS 6/iR Adapter RAID Controller(0x1028-0x1F0E)"},
{0x1000, 0x0058, 0x1028, 0x1F0F, "SAS 6/iR Integrated Blades RAID Controller(0x1028-0x1F0F)"},
{0x1000, 0x0058, 0x1028, 0x1F10, "SAS 6/iR Integrated RAID Controller(0x1028-0x1F10)"},
{0x1000, 0x0058, 0x103C, 0x3229, "SC44Ge Host Bus Adapter(0x103C-0x3229)"},
{0x1000, 0x0059, 0xFFFF, 0xFFFF, "MegaRAID SAS 8208ELP/8208ELP(0x0059)"},
{0x1000, 0x005A, 0xFFFF, 0xFFFF, "SAS1066E PCI-Express Fusion-MPT SAS(0x005A)"},
{0x1000, 0x005B, 0xFFFF, 0xFFFF, "MegaRAID SAS 2208 [Thunderbolt](0x005B)"},
{0x1000, 0x005B, 0x1000, 0x9265, "MegaRAID SAS 9265-8i(0x1000-0x9265)"},
{0x1000, 0x005B, 0x1000, 0x9266, "MegaRAID SAS 9266-8i(0x1000-0x9266)"},
{0x1000, 0x005B, 0x1000, 0x9267, "MegaRAID SAS 9267-8i(0x1000-0x9267)"},
{0x1000, 0x005B, 0x1000, 0x9268, "MegaRAID SAS 9265CV-8i / 9270CV-8i(0x1000-0x9268)"},
{0x1000, 0x005B, 0x1000, 0x9269, "MegaRAID SAS 9266-4i(0x1000-0x9269)"},
{0x1000, 0x005B, 0x1000, 0x9270, "MegaRAID SAS 9270-8i(0x1000-0x9270)"},
{0x1000, 0x005B, 0x1000, 0x9271, "MegaRAID SAS 9271-8i(0x1000-0x9271)"},
{0x1000, 0x005B, 0x1000, 0x9272, "MegaRAID SAS 9272-8i(0x1000-0x9272)"},
{0x1000, 0x005B, 0x1000, 0x9273, "MegaRAID SAS 9270CV-8i(0x1000-0x9273)"},
{0x1000, 0x005B, 0x1000, 0x9274, "MegaRAID SAS 9270-4i(0x1000-0x9274)"},
{0x1000, 0x005B, 0x1000, 0x9275, "MegaRAID SAS 9271-8iCC(0x1000-0x9275)"},
{0x1000, 0x005B, 0x1000, 0x9276, "MegaRAID SAS 9271-4i(0x1000-0x9276)"},
{0x1000, 0x005B, 0x1000, 0x9285, "MegaRAID SAS 9285-8e(0x1000-0x9285)"},
{0x1000, 0x005B, 0x1000, 0x9288, "MegaRAID SAS 9285CV-8e(0x1000-0x9288)"},
{0x1000, 0x005B, 0x1000, 0x9290, "MegaRAID SAS 9286-8e(0x1000-0x9290)"},
{0x1000, 0x005B, 0x1000, 0x9291, "MegaRAID SAS 9286CV-8e(0x1000-0x9291)"},
{0x1000, 0x005B, 0x1000, 0x9295, "MegaRAID SAS 9286CV-8eCC(0x1000-0x9295)"},
{0x1000, 0x005B, 0x1014, 0x040B, "ServeRAID M5110 SAS/SATA Controller(0x1014-0x040B)"},
{0x1000, 0x005B, 0x1014, 0x040C, "ServeRAID M5120 SAS/SATA Controller(0x1014-0x040C)"},
{0x1000, 0x005B, 0x1014, 0x0412, "ServeRAID M5110e SAS/SATA Controller(0x1014-0x0412)"},
{0x1000, 0x005B, 0x1028, 0x1F2D, "PERC H810 Adapter(0x1028-0x1F2D)"},
{0x1000, 0x005B, 0x1028, 0x1F30, "PERC H710 Embedded(0x1028-0x1F30)"},
{0x1000, 0x005B, 0x1028, 0x1F31, "PERC H710P Adapter(0x1028-0x1F31)"},
{0x1000, 0x005B, 0x1028, 0x1F33, "PERC H710P Mini (for blades)(0x1028-0x1F33)"},
{0x1000, 0x005B, 0x1028, 0x1F34, "PERC H710P Mini (for monolithics)(0x1028-0x1F34)"},
{0x1000, 0x005B, 0x1028, 0x1F35, "PERC H710 Adapter(0x1028-0x1F35)"},
{0x1000, 0x005B, 0x1028, 0x1F37, "PERC H710 Mini (for blades)(0x1028-0x1F37)"},
{0x1000, 0x005B, 0x1028, 0x1F38, "PERC H710 Mini (for monolithics)(0x1028-0x1F38)"},
{0x1000, 0x005B, 0x15D9, 0x0690, "LSI MegaRAID ROMB(0x15D9-0x0690)"},
{0x1000, 0x005B, 0x8086, 0x3510, "RMS25PB080 RAID Controller(0x8086-0x3510)"},
{0x1000, 0x005B, 0x8086, 0x3511, "RMS25PB040 RAID Controller(0x8086-0x3511)"},
{0x1000, 0x005B, 0x8086, 0x3512, "RMT3PB080 RAID Controller(0x8086-0x3512)"},
{0x1000, 0x005B, 0x8086, 0x3513, "Integrated RAID Module RMS25CB080(0x8086-0x3513)"},
{0x1000, 0x005B, 0x8086, 0x3514, "RMS25CB040 RAID Controller(0x8086-0x3514)"},
{0x1000, 0x005B, 0x8086, 0x351C, "RMS25PB080N RAID Controller(0x8086-0x351C)"},
{0x1000, 0x005B, 0x8086, 0x351D, "RMS25CB080N RAID Controller(0x8086-0x351D)"},
{0x1000, 0x005B, 0x8086, 0x9265, "RS25DB080 RAID Controller(0x8086-0x9265)"},
{0x1000, 0x005B, 0x8086, 0x9268, "RS25AB080 RAID Controller(0x8086-0x9268)"},
{0x1000, 0x005B, 0x8086, 0x9285, "RS25NB008 RAID Controller(0x8086-0x9285)"},
{0x1000, 0x005B, 0x8086, 0x9288, "RS25SB008 RAID Controller(0x8086-0x9288)"},
{0x1000, 0x005C, 0xFFFF, 0xFFFF, "SAS1064A PCI-X Fusion-MPT SAS(0x005C)"},
{0x1000, 0x005D, 0xFFFF, 0xFFFF, "MegaRAID SAS-3 3108 [Invader](0x005D)"},
{0x1000, 0x005D, 0x1000, 0x9361, "MegaRAID SAS 9361-8i(0x1000-0x9361)"},
{0x1000, 0x005D, 0x1000, 0x9363, "MegaRAID SAS 9361-4i(0x1000-0x9363)"},
{0x1000, 0x005D, 0x1000, 0x9364, "MegaRAID SAS 9364-8i(0x1000-0x9364)"},
{0x1000, 0x005D, 0x1000, 0x936A, "MegaRAID SAS 9364-8i(0x1000-0x936A)"},
{0x1000, 0x005D, 0x1000, 0x9380, "MegaRAID SAS 9380-8e(0x1000-0x9380)"},
{0x1000, 0x005D, 0x1028, 0x1F41, "PERC H830 Adapter(0x1028-0x1F41)"},
{0x1000, 0x005D, 0x1028, 0x1F42, "PERC H730P Adapter(0x1028-0x1F42)"},
{0x1000, 0x005D, 0x1028, 0x1F43, "PERC H730 Adapter(0x1028-0x1F43)"},
{0x1000, 0x005D, 0x1028, 0x1F47, "PERC H730P Mini(0x1028-0x1F47)"},
{0x1000, 0x005D, 0x1028, 0x1F48, "PERC H730P Mini (for blades)(0x1028-0x1F48)"},
{0x1000, 0x005D, 0x1028, 0x1F49, "PERC H730 Mini(0x1028-0x1F49)"},
{0x1000, 0x005D, 0x1028, 0x1F4A, "PERC H730 Mini (for blades)(0x1028-0x1F4A)"},
{0x1000, 0x005D, 0x1028, 0x1F4D, "PERC FD33xS(0x1028-0x1F4D)"},
{0x1000, 0x005D, 0x1028, 0x1F4F, "PERC H730P Slim(0x1028-0x1F4F)"},
{0x1000, 0x005D, 0x1028, 0x1F54, "PERC FD33xD(0x1028-0x1F54)"},
{0x1000, 0x005D, 0x1028, 0x1FD1, "PERC H730P MX(0x1028-0x1FD1)"},
{0x1000, 0x005D, 0x1734, 0x11F6, "PRAID EP400i(0x1734-0x11F6)"},
{0x1000, 0x005D, 0x17AA, 0x1052, "ThinkServer RAID 720i(0x17AA-0x1052)"},
{0x1000, 0x005D, 0x17AA, 0x1053, "ThinkServer RAID 720ix(0x17AA-0x1053)"},
{0x1000, 0x005D, 0x1BD4, 0x0014, "12G SAS3108 2G(0x1BD4-0x0014)"},
{0x1000, 0x005D, 0x1BD4, 0x0015, "12G SAS3108 4G(0x1BD4-0x0015)"},
{0x1000, 0x005D, 0x1D49, 0x0600, "ThinkSystem RAID 730-8i 1GB Cache PCIe 12Gb Adapter(0x1D49-0x0600)"},
{0x1000, 0x005D, 0x1D49, 0x0608, "ThinkSystem RAID 730-8i 2GB Flash PCIe 12Gb Adapter(0x1D49-0x0608)"},
{0x1000, 0x005D, 0x1D49, 0x0609, "ThinkSystem RAID 730-8i 4GB Flash PCIe 12Gb Adapter(0x1D49-0x0609)"},
{0x1000, 0x005D, 0x8086, 0x351E, "RMS3CC080 RAID Controller(0x8086-0x351E)"},
{0x1000, 0x005D, 0x8086, 0x351F, "RMS3CC040 RAID Controller(0x8086-0x351F)"},
{0x1000, 0x005D, 0x8086, 0x9360, "RS3DC080 RAID Controller(0x8086-0x9360)"},
{0x1000, 0x005D, 0x8086, 0x9362, "RS3DC040 RAID Controller(0x8086-0x9362)"},
{0x1000, 0x005D, 0x8086, 0x9380, "RS3SC008 RAID Controller(0x8086-0x9380)"},
{0x1000, 0x005D, 0x8086, 0x9381, "RS3MC044 RAID Controller(0x8086-0x9381)"},
{0x1000, 0x005E, 0xFFFF, 0xFFFF, "SAS1066 PCI-X Fusion-MPT SAS(0x005E)"},
{0x1000, 0x005F, 0xFFFF, 0xFFFF, "MegaRAID SAS-3 3008 [Fury](0x005F)"},
{0x1000, 0x005F, 0x1028, 0x1F44, "PERC H330 Adapter(0x1028-0x1F44)"},
{0x1000, 0x005F, 0x1028, 0x1F4B, "PERC H330 Mini(0x1028-0x1F4B)"},
{0x1000, 0x005F, 0x1028, 0x1F4C, "PERC H330 Mini (for blades)(0x1028-0x1F4C)"},
{0x1000, 0x005F, 0x1028, 0x1F4D, "PERC H330 Embedded (for monolithic)(0x1028-0x1F4D)"},
{0x1000, 0x005F, 0x1054, 0x306A, "SAS 3004 iMR ROMB(0x1054-0x306A)"},
{0x1000, 0x005F, 0x1734, 0x1211, "PRAID CP400i [D3307-A12](0x1734-0x1211)"},
{0x1000, 0x005F, 0x1D49, 0x04DB, "ServeRAID M1210 SAS/SATA Controller(0x1D49-0x04DB)"},
{0x1000, 0x005F, 0x1D49, 0x0504, "ThinkSystem RAID 520-8i PCIe 12Gb Adapter(0x1D49-0x0504)"},
{0x1000, 0x0060, 0xFFFF, 0xFFFF, "MegaRAID SAS 1078(0x0060)"},
{0x1000, 0x0060, 0x1000, 0x1006, "MegaRAID SAS 8888ELP(0x1000-0x1006)"},
{0x1000, 0x0060, 0x1000, 0x100A, "MegaRAID SAS 8708ELP(0x1000-0x100A)"},
{0x1000, 0x0060, 0x1000, 0x100E, "MegaRAID SAS 8884E(0x1000-0x100E)"},
{0x1000, 0x0060, 0x1000, 0x100F, "MegaRAID SAS 8708E(0x1000-0x100F)"},
{0x1000, 0x0060, 0x1000, 0x1010, "MegaRAID SATA 350-8ELP(0x1000-0x1010)"},
{0x1000, 0x0060, 0x1000, 0x1011, "MegaRAID SATA 350-4ELP(0x1000-0x1011)"},
{0x1000, 0x0060, 0x1000, 0x1012, "MegaRAID SAS 8704ELP(0x1000-0x1012)"},
{0x1000, 0x0060, 0x1000, 0x1016, "MegaRAID SAS 8880EM2(0x1000-0x1016)"},
{0x1000, 0x0060, 0x1014, 0x0363, "MegaRAID SAS PCI Express ROMB(0x1014-0x0363)"},
{0x1000, 0x0060, 0x1014, 0x0364, "SystemX MegaRAID SAS 8808E(0x1014-0x0364)"},
{0x1000, 0x0060, 0x1014, 0x0365, "SystemX MegaRAID SAS 8884E(0x1014-0x0365)"},
{0x1000, 0x0060, 0x1014, 0x0379, "SystemX MegaRAID SAS 8880EM2(0x1014-0x0379)"},
{0x1000, 0x0060, 0x1028, 0x1F0A, "PERC 6/E Adapter RAID Controller(0x1028-0x1F0A)"},
{0x1000, 0x0060, 0x1028, 0x1F0B, "PERC 6/i Adapter RAID Controller(0x1028-0x1F0B)"},
{0x1000, 0x0060, 0x1028, 0x1F0C, "PERC 6/i Integrated RAID Controller(0x1028-0x1F0C)"},
{0x1000, 0x0060, 0x1028, 0x1F0D, "PERC 6/i Integrated RAID Controller(0x1028-0x1F0D)"},
{0x1000, 0x0060, 0x1028, 0x1F11, "CERC 6/i Integrated RAID Controller(0x1028-0x1F11)"},
{0x1000, 0x0060, 0x1033, 0x835A, "MegaRAID SAS PCI Express ROMB(0x1033-0x835A)"},
{0x1000, 0x0060, 0x1043, 0x824D, "MegaRAID SAS PCI Express ROMB(0x1043-0x824D)"},
{0x1000, 0x0060, 0x1170, 0x002F, "MegaRAID SAS PCI Express ROMB(0x1170-0x002F)"},
{0x1000, 0x0060, 0x1170, 0x0036, "MegaRAID SAS PCI Express ROMB(0x1170-0x0036)"},
{0x1000, 0x0060, 0x15D9, 0xC080, "MegaRAID SAS PCI Express ROMB(0x15D9-0xC080)"},
{0x1000, 0x0060, 0x17AA, 0x6B7C, "MegaRAID SAS PCI Express ROMB(0x17AA-0x6B7C)"},
{0x1000, 0x0060, 0x18A1, 0x0003, "LSI MegaRAID SAS PCI Express ROMB(0x18A1-0x0003)"},
{0x1000, 0x0060, 0x8086, 0x1006, "RAID Controller SRCSAS28EP(0x8086-0x1006)"},
{0x1000, 0x0060, 0x8086, 0x100A, "RAID Controller SRCSAS28EV(0x8086-0x100A)"},
{0x1000, 0x0060, 0x8086, 0x1010, "RAID Controller SRCSATA28E(0x8086-0x1010)"},
{0x1000, 0x0060, 0x8086, 0x34CC, "Integrated RAID Controller SROMBSAS28E(0x8086-0x34CC)"},
{0x1000, 0x0060, 0x8086, 0x34CD, "Integrated RAID Controller SROMBSAS28E(0x8086-0x34CD)"},
{0x1000, 0x0060, 0x8086, 0x3505, "Integrated RAID Controller SROMBSASMP2(0x8086-0x3505)"},
{0x1000, 0x0062, 0xFFFF, 0xFFFF, "SAS1078 PCI-Express Fusion-MPT SAS(0x0062)"},
{0x1000, 0x0062, 0x1000, 0x0062, "SAS1078 PCI-Express Fusion-MPT SAS(0x1000-0x0062)"},
{0x1000, 0x0064, 0xFFFF, 0xFFFF, "SAS2116 PCI-Express Fusion-MPT SAS-2 [Meteor](0x0064)"},
{0x1000, 0x0064, 0x1000, 0x3030, "9200-16e 6Gb/s SAS/SATA PCIe x8 External HBA(0x1000-0x3030)"},
{0x1000, 0x0064, 0x1000, 0x30C0, "SAS 9201-16i(0x1000-0x30C0)"},
{0x1000, 0x0064, 0x1000, 0x30D0, "9201-16e 6Gb/s SAS/SATA PCIe x8 External HBA(0x1000-0x30D0)"},
{0x1000, 0x0065, 0xFFFF, 0xFFFF, "SAS2116 PCI-Express Fusion-MPT SAS-2 [Meteor](0x0065)"},
{0x1000, 0x006E, 0xFFFF, 0xFFFF, "SAS2308 PCI-Express Fusion-MPT SAS-2(0x006E)"},
{0x1000, 0x0070, 0xFFFF, 0xFFFF, "SAS2004 PCI-Express Fusion-MPT SAS-2 [Spitfire](0x0070)"},
{0x1000, 0x0070, 0x1000, 0x3010, "SAS9211-4i(0x1000-0x3010)"},
{0x1000, 0x0070, 0x1014, 0x040E, "ServeRAID H1110(0x1014-0x040E)"},
{0x1000, 0x0071, 0xFFFF, 0xFFFF, "MR SAS HBA 2004(0x0071)"},
{0x1000, 0x0072, 0xFFFF, 0xFFFF, "SAS2008 PCI-Express Fusion-MPT SAS-2 [Falcon](0x0072)"},
{0x1000, 0x0072, 0x1000, 0x3020, "9211-8i(0x1000-0x3020)"},
{0x1000, 0x0072, 0x1000, 0x3040, "9210-8i(0x1000-0x3040)"},
{0x1000, 0x0072, 0x1000, 0x3080, "9200-8e [LSI SAS 6Gb/s SAS/SATA PCIe x8 External HBA](0x1000-0x3080)"},
{0x1000, 0x0072, 0x1000, 0x30B0, "9200-8e [LSI SAS 6Gb/s SAS/SATA PCIe x8 External HBA](0x1000-0x30B0)"},
{0x1000, 0x0072, 0x1014, 0x03CA, "IBM 6Gb SAS HBA [9212-4i4e](0x1014-0x03CA)"},
{0x1000, 0x0072, 0x1028, 0x1F1C, "6Gbps SAS HBA Adapter(0x1028-0x1F1C)"},
{0x1000, 0x0072, 0x1028, 0x1F1D, "PERC H200 Adapter(0x1028-0x1F1D)"},
{0x1000, 0x0072, 0x1028, 0x1F1E, "PERC H200 Integrated(0x1028-0x1F1E)"},
{0x1000, 0x0072, 0x1028, 0x1F1F, "PERC H200 Modular(0x1028-0x1F1F)"},
{0x1000, 0x0072, 0x1028, 0x1F20, "PERC H200 Embedded(0x1028-0x1F20)"},
{0x1000, 0x0072, 0x1028, 0x1F22, "PERC H200 Internal Tape Adapter(0x1028-0x1F22)"},
{0x1000, 0x0072, 0x1734, 0x1177, "HBA Ctrl SAS 6G 0/1 [D2607](0x1734-0x1177)"},
{0x1000, 0x0072, 0x1BD4, 0x000D, "6G SAS2008IT(0x1BD4-0x000D)"},
{0x1000, 0x0072, 0x1BD4, 0x000E, "6G SAS2008IR(0x1BD4-0x000E)"},
{0x1000, 0x0072, 0x1BD4, 0x000F, "6G SAS2008IT SA5248(0x1BD4-0x000F)"},
{0x1000, 0x0072, 0x1BD4, 0x0010, "6G SAS2008IR SA5248(0x1BD4-0x0010)"},
{0x1000, 0x0072, 0x4C52, 0x96C8, "LRSA96C8 8-Port SATA3 (6Gb/s) Exchange Adapter (with RAID)(0x4C52-0x96C8)"},
{0x1000, 0x0072, 0x8086, 0x350F, "RMS2LL040 RAID Controller(0x8086-0x350F)"},
{0x1000, 0x0072, 0x8086, 0x3700, "SSD 910 Series(0x8086-0x3700)"},
{0x1000, 0x0073, 0xFFFF, 0xFFFF, "MegaRAID SAS 2008 [Falcon](0x0073)"},
{0x1000, 0x0073, 0x1000, 0x9240, "MegaRAID SAS 9240-8i(0x1000-0x9240)"},
{0x1000, 0x0073, 0x1000, 0x9241, "MegaRAID SAS 9240-4i(0x1000-0x9241)"},
{0x1000, 0x0073, 0x1000, 0x92A0, "MegaRAID SAS 9220-8i(0x1000-0x92A0)"},
{0x1000, 0x0073, 0x1014, 0x03B1, "ServeRAID M1015 SAS/SATA Controller(0x1014-0x03B1)"},
{0x1000, 0x0073, 0x1014, 0x040D, "ServeRAID M1115 SAS/SATA Controller(0x1014-0x040D)"},
{0x1000, 0x0073, 0x1028, 0x1F4E, "PERC H310 Adapter(0x1028-0x1F4E)"},
{0x1000, 0x0073, 0x1028, 0x1F4F, "PERC H310 Integrated(0x1028-0x1F4F)"},
{0x1000, 0x0073, 0x1028, 0x1F50, "PERC H310 Mini Blades(0x1028-0x1F50)"},
{0x1000, 0x0073, 0x1028, 0x1F51, "PERC H310 Mini Monolithics(0x1028-0x1F51)"},
{0x1000, 0x0073, 0x1028, 0x1F52, "PERC H310 Embedded1(0x1028-0x1F52)"},
{0x1000, 0x0073, 0x1028, 0x1F53, "PERC H310 Embedded2(0x1028-0x1F53)"},
{0x1000, 0x0073, 0x1028, 0x1F54, "PERC H310 Reserved(0x1028-0x1F54)"},
{0x1000, 0x0073, 0x1028, 0x1F78, "PERC H310(0x1028-0x1F78)"},
{0x1000, 0x0073, 0x1054, 0x3035, "LSI MegaRAID SAS 9240-8i(0x1054-0x3035)"},
{0x1000, 0x0073, 0x1137, 0x0072, "2004 iMR ROMB(0x1137-0x0072)"},
{0x1000, 0x0073, 0x1137, 0x0073, "2008 ROMB(0x1137-0x0073)"},
{0x1000, 0x0073, 0x1137, 0x00B0, "UCSC RAID SAS 2008M-8i(0x1137-0x00B0)"},
{0x1000, 0x0073, 0x1137, 0x00B1, "UCSC RAID SAS 2008M-8i(0x1137-0x00B1)"},
{0x1000, 0x0073, 0x1137, 0x00C2, "UCS E-Series Double Wide(0x1137-0x00C2)"},
{0x1000, 0x0073, 0x1137, 0x00C3, "UCS E-Series Single Wide(0x1137-0x00C3)"},
{0x1000, 0x0073, 0x15D9, 0x0400, "Supermicro SMC2008-iMR(0x15D9-0x0400)"},
{0x1000, 0x0073, 0x1734, 0x1177, "RAID Ctrl SAS 6G 0/1 (D2607)(0x1734-0x1177)"},
{0x1000, 0x0073, 0x17AA, 0x1051, "ThinkServer RAID 510i(0x17AA-0x1051)"},
{0x1000, 0x0073, 0x8086, 0x350D, "RMS2AF040 RAID Controller(0x8086-0x350D)"},
{0x1000, 0x0073, 0x8086, 0x9240, "RAID Controller RS2WC080(0x8086-0x9240)"},
{0x1000, 0x0073, 0x8086, 0x9241, "RAID Controller RS2WC040(0x8086-0x9241)"},
{0x1000, 0x0074, 0xFFFF, 0xFFFF, "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator](0x0074)"},
{0x1000, 0x0076, 0xFFFF, 0xFFFF, "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator](0x0076)"},
{0x1000, 0x0077, 0xFFFF, 0xFFFF, "SAS2108 PCI-Express Fusion-MPT SAS-2 [Liberator](0x0077)"},
{0x1000, 0x0079, 0xFFFF, 0xFFFF, "MegaRAID SAS 2108 [Liberator](0x0079)"},
{0x1000, 0x0079, 0x1000, 0x9251, "MegaRAID SAS 9260-4ix(0x1000-0x9251)"},
{0x1000, 0x0079, 0x1000, 0x9256, "MegaRAID SAS 9260-8ix(0x1000-0x9256)"},
{0x1000, 0x0079, 0x1000, 0x9260, "MegaRAID SAS 9260-4i(0x1000-0x9260)"},
{0x1000, 0x0079, 0x1000, 0x9261, "MegaRAID SAS 9260-8i(0x1000-0x9261)"},
{0x1000, 0x0079, 0x1000, 0x9262, "MegaRAID SAS 9262-8i(0x1000-0x9262)"},
{0x1000, 0x0079, 0x1000, 0x9263, "MegaRAID SAS 9261-8i(0x1000-0x9263)"},
{0x1000, 0x0079, 0x1000, 0x9264, "MegaRAID SAS 9264-8i(0x1000-0x9264)"},
{0x1000, 0x0079, 0x1000, 0x9267, "MegaRAID SAS 9260CV-4i(0x1000-0x9267)"},
{0x1000, 0x0079, 0x1000, 0x9268, "MegaRAID SAS 9260CV-8i(0x1000-0x9268)"},
{0x1000, 0x0079, 0x1000, 0x9275, "MegaRAID SAS 9280-8ex(0x1000-0x9275)"},
{0x1000, 0x0079, 0x1000, 0x9276, "MR9260-16i(0x1000-0x9276)"},
{0x1000, 0x0079, 0x1000, 0x9280, "MegaRAID SAS 9280-8e(0x1000-0x9280)"},
{0x1000, 0x0079, 0x1000, 0x9281, "MegaRAID SAS 9281-8E(0x1000-0x9281)"},
{0x1000, 0x0079, 0x1000, 0x9282, "MegaRAID SAS 9280-4i4e(0x1000-0x9282)"},
{0x1000, 0x0079, 0x1000, 0x9290, "MegaRAID SAS 9280DE-24i4e(0x1000-0x9290)"},
{0x1000, 0x0079, 0x1014, 0x03B2, "ServeRAID M5015 SAS/SATA Controller(0x1014-0x03B2)"},
{0x1000, 0x0079, 0x1014, 0x03B3, "ServeRAID M5025 SAS/SATA Controller(0x1014-0x03B3)"},
{0x1000, 0x0079, 0x1028, 0x1F15, "PERC H800 Adapter(0x1028-0x1F15)"},
{0x1000, 0x0079, 0x1028, 0x1F16, "PERC H700 Adapter(0x1028-0x1F16)"},
{0x1000, 0x0079, 0x1028, 0x1F17, "PERC H700 Integrated(0x1028-0x1F17)"},
{0x1000, 0x0079, 0x1028, 0x1F18, "PERC H700 Modular(0x1028-0x1F18)"},
{0x1000, 0x0079, 0x1028, 0x1F1A, "PERC H800 Proto Adapter(0x1028-0x1F1A)"},
{0x1000, 0x0079, 0x1028, 0x1F1B, "PERC H700 Integrated(0x1028-0x1F1B)"},
{0x1000, 0x0079, 0x1043, 0x8480, "PIKE-2108 16PD(0x1043-0x8480)"},
{0x1000, 0x0079, 0x1734, 0x1176, "RAID Ctrl SAS 6G 5/6 512MB (D2616)(0x1734-0x1176)"},
{0x1000, 0x0079, 0x1734, 0x1177, "RAID Ctrl SAS 6G 0/1 (D2607)(0x1734-0x1177)"},
{0x1000, 0x0079, 0x8086, 0x350B, "RMS2MH080 RAID Controller(0x8086-0x350B)"},
{0x1000, 0x0079, 0x8086, 0x9256, "MegaRAID SAS 9260DE-8i RS2BL080DE(0x8086-0x9256)"},
{0x1000, 0x0079, 0x8086, 0x9260, "RAID Controller RS2BL040(0x8086-0x9260)"},
{0x1000, 0x0079, 0x8086, 0x9261, "RAID Controller RS2BL080(0x8086-0x9261)"},
{0x1000, 0x0079, 0x8086, 0x9264, "RAID Controller RT3WB080 Warm Beach (Caster Lite)(0x8086-0x9264)"},
{0x1000, 0x0079, 0x8086, 0x9267, "RAID Controller RS2VB040(0x8086-0x9267)"},
{0x1000, 0x0079, 0x8086, 0x9268, "RAID Controller RS2VB080(0x8086-0x9268)"},
{0x1000, 0x0079, 0x8086, 0x9275, "RAID Controller RS2PI008DE(0x8086-0x9275)"},
{0x1000, 0x0079, 0x8086, 0x9276, "RAID Controller RS2WG160(0x8086-0x9276)"},
{0x1000, 0x0079, 0x8086, 0x9280, "RAID Controller RS2PI008(0x8086-0x9280)"},
{0x1000, 0x0079, 0x8086, 0x9282, "RAID Controller RS2MB044(0x8086-0x9282)"},
{0x1000, 0x0079, 0x8086, 0x9290, "RAID Controller RS2SG244(0x8086-0x9290)"},
{0x1000, 0x007C, 0xFFFF, 0xFFFF, "MegaRAID SAS 1078DE(0x007C)"},
{0x1000, 0x007C, 0x1014, 0x0395, "ServeRAID-AR10is SAS/SATA Controller(0x1014-0x0395)"},
{0x1000, 0x007E, 0xFFFF, 0xFFFF, "SSS6200 PCI-Express Flash SSD(0x007E)"},
{0x1000, 0x007E, 0x1000, 0x0504, "Nytro NWD-BLP4-800(0x1000-0x0504)"},
{0x1000, 0x007E, 0x1000, 0x0507, "Nytro NWD-BLP4-1600(0x1000-0x0507)"},
{0x1000, 0x007E, 0x1000, 0x0581, "Nytro NWD-BLP4-400(0x1000-0x0581)"},
{0x1000, 0x007E, 0x1000, 0x100D, "Nytro NWD-BFH6-1200(0x1000-0x100D)"},
{0x1000, 0x007E, 0x1000, 0x100E, "Nytro NWD-BFH8-1600(0x1000-0x100E)"},
{0x1000, 0x007E, 0x1000, 0x107E, "Nytro NWD-BFH8-3200(0x1000-0x107E)"},
{0x1000, 0x007E, 0x1000, 0x1310, "Nytro XP6302-8B1536(0x1000-0x1310)"},
{0x1000, 0x007E, 0x1000, 0x1311, "Nytro XP6302-8B2048(0x1000-0x1311)"},
{0x1000, 0x007E, 0x1000, 0x1314, "Nytro XP6302-8B4096(0x1000-0x1314)"},
{0x1000, 0x007E, 0x1000, 0x150C, "Nytro XP6210-4A2048(0x1000-0x150C)"},
{0x1000, 0x007E, 0x1000, 0x150F, "Nytro XP6210-4B2048(0x1000-0x150F)"},
{0x1000, 0x007E, 0x1000, 0x160B, "Nytro XP6209-4A1024(0x1000-0x160B)"},
{0x1000, 0x007E, 0x1000, 0x1613, "Nytro XP6209-4B2048(0x1000-0x1613)"},
{0x1000, 0x007E, 0x108E, 0x050A, "Nytro ELP4x200_4d_n(0x108E-0x050A)"},
{0x1000, 0x007E, 0x108E, 0x0581, "Nytro ELP4x100_4d_n(0x108E-0x0581)"},
{0x1000, 0x0080, 0xFFFF, 0xFFFF, "SAS2208 PCI-Express Fusion-MPT SAS-2(0x0080)"},
{0x1000, 0x0081, 0xFFFF, 0xFFFF, "SAS2208 PCI-Express Fusion-MPT SAS-2(0x0081)"},
{0x1000, 0x0082, 0xFFFF, 0xFFFF, "SAS2208 PCI-Express Fusion-MPT SAS-2(0x0082)"},
{0x1000, 0x0083, 0xFFFF, 0xFFFF, "SAS2208 PCI-Express Fusion-MPT SAS-2(0x0083)"},
{0x1000, 0x0084, 0xFFFF, 0xFFFF, "SAS2208 PCI-Express Fusion-MPT SAS-2(0x0084)"},
{0x1000, 0x0085, 0xFFFF, 0xFFFF, "SAS2208 PCI-Express Fusion-MPT SAS-2(0x0085)"},
{0x1000, 0x0086, 0xFFFF, 0xFFFF, "SAS2308 PCI-Express Fusion-MPT SAS-2(0x0086)"},
{0x1000, 0x0086, 0x15D9, 0x0690, "Onboard MegaRAID SAS2208 [Thunderbolt](0x15D9-0x0690)"},
{0x1000, 0x0086, 0x15D9, 0x0691, "Onboard SAS2308 PCI-Express Fusion-MPT SAS-2(0x15D9-0x0691)"},
{0x1000, 0x0087, 0xFFFF, 0xFFFF, "SAS2308 PCI-Express Fusion-MPT SAS-2(0x0087)"},
{0x1000, 0x0087, 0x1000, 0x3020, "9207-8i SAS2.1 HBA(0x1000-0x3020)"},
{0x1000, 0x0087, 0x1000, 0x3030, "SAS9207-4i4e(0x1000-0x3030)"},
{0x1000, 0x0087, 0x1000, 0x3040, "9207-8e SAS2.1 HBA(0x1000-0x3040)"},
{0x1000, 0x0087, 0x1000, 0x3050, "SAS9217-8i(0x1000-0x3050)"},
{0x1000, 0x0087, 0x1000, 0x3060, "SAS9217-4i4e(0x1000-0x3060)"},
{0x1000, 0x0087, 0x1014, 0x0472, "N2125 External Host Bus Adapter(0x1014-0x0472)"},
{0x1000, 0x0087, 0x1014, 0x047A, "N2115 Internal Host Bus Adapter(0x1014-0x047A)"},
{0x1000, 0x0087, 0x1590, 0x0041, "H220i(0x1590-0x0041)"},
{0x1000, 0x0087, 0x1590, 0x0042, "H221 / 9207-8e(0x1590-0x0042)"},
{0x1000, 0x0087, 0x1590, 0x0044, "H220i(0x1590-0x0044)"},
{0x1000, 0x0087, 0x1BD4, 0x0009, "6G SAS2308IR(0x1BD4-0x0009)"},
{0x1000, 0x0087, 0x1BD4, 0x000A, "6G SAS2308IT(0x1BD4-0x000A)"},
{0x1000, 0x0087, 0x8086, 0x3000, "RS25GB008 RAID Controller(0x8086-0x3000)"},
{0x1000, 0x0087, 0x8086, 0x3060, "RS25FB044 RAID Controller(0x8086-0x3060)"},
{0x1000, 0x0087, 0x8086, 0x3516, "RMS25JB080 RAID Controller(0x8086-0x3516)"},
{0x1000, 0x0087, 0x8086, 0x3517, "RMS25JB040 RAID Controller(0x8086-0x3517)"},
{0x1000, 0x0087, 0x8086, 0x3518, "RMS25KB080 RAID Controller(0x8086-0x3518)"},
{0x1000, 0x0087, 0x8086, 0x3519, "RMS25KB040 RAID Controller(0x8086-0x3519)"},
{0x1000, 0x0087, 0x8086, 0x351A, "RMS25LB040 RAID Controller(0x8086-0x351A)"},
{0x1000, 0x0087, 0x8086, 0x351B, "RMS25LB080 RAID Controller(0x8086-0x351B)"},
{0x1000, 0x008F, 0xFFFF, 0xFFFF, "53c875J(0x008F)"},
{0x1000, 0x008F, 0x1092, 0x8000, "FirePort 40 SCSI Controller(0x1092-0x8000)"},
{0x1000, 0x008F, 0x1092, 0x8760, "FirePort 40 Dual SCSI Host Adapter(0x1092-0x8760)"},
{0x1000, 0x0090, 0xFFFF, 0xFFFF, "SAS3108 PCI-Express Fusion-MPT SAS-3(0x0090)"},
{0x1000, 0x0091, 0xFFFF, 0xFFFF, "SAS3108 PCI-Express Fusion-MPT SAS-3(0x0091)"},
{0x1000, 0x0094, 0xFFFF, 0xFFFF, "SAS3108 PCI-Express Fusion-MPT SAS-3(0x0094)"},
{0x1000, 0x0095, 0xFFFF, 0xFFFF, "SAS3108 PCI-Express Fusion-MPT SAS-3(0x0095)"},
{0x1000, 0x0096, 0xFFFF, 0xFFFF, "SAS3004 PCI-Express Fusion-MPT SAS-3(0x0096)"},
{0x1000, 0x0097, 0xFFFF, 0xFFFF, "SAS3008 PCI-Express Fusion-MPT SAS-3(0x0097)"},
{0x1000, 0x0097, 0x1000, 0x3090, "SAS9311-8i(0x1000-0x3090)"},
{0x1000, 0x0097, 0x1000, 0x30A0, "SAS9300-8e(0x1000-0x30A0)"},
{0x1000, 0x0097, 0x1000, 0x30E0, "SAS9300-8i(0x1000-0x30E0)"},
{0x1000, 0x0097, 0x1000, 0x3130, "SAS 9300-16i(0x1000-0x3130)"},
{0x1000, 0x0097, 0x1000, 0x3170, "SAS9302-16e(0x1000-0x3170)"},
{0x1000, 0x0097, 0x1014, 0x0457, "9302-8i [N2215](0x1014-0x0457)"},
{0x1000, 0x0097, 0x1028, 0x1F45, "HBA330 Adapter(0x1028-0x1F45)"},
{0x1000, 0x0097, 0x1028, 0x1F46, "12Gbps HBA(0x1028-0x1F46)"},
{0x1000, 0x0097, 0x1028, 0x1F53, "HBA330 Mini(0x1028-0x1F53)"},
{0x1000, 0x0097, 0x1028, 0x1FD2, "HBA330 MX(0x1028-0x1FD2)"},
{0x1000, 0x0097, 0x1028, 0x1FD3, "HBA330 MMZ(0x1028-0x1FD3)"},
{0x1000, 0x0097, 0x15D9, 0x0808, "AOC-S3008L-L8e(0x15D9-0x0808)"},
{0x1000, 0x0097, 0x1BD4, 0x0008, "12G SAS3008IMR Onboard(0x1BD4-0x0008)"},
{0x1000, 0x0097, 0x1BD4, 0x000B, "12G SAS3008IR(0x1BD4-0x000B)"},
{0x1000, 0x0097, 0x1BD4, 0x000C, "12G SAS3008IT(0x1BD4-0x000C)"},
{0x1000, 0x0097, 0x1BD4, 0x0011, "Inspur 12Gb 8i-3008 IT SAS HBA(0x1BD4-0x0011)"},
{0x1000, 0x0097, 0x1BD4, 0x0012, "12Gb SAS3008IR UDM(0x1BD4-0x0012)"},
{0x1000, 0x0097, 0x1BD4, 0x001F, "12G SAS3008IR Onboard(0x1BD4-0x001F)"},
{0x1000, 0x0097, 0x1BD4, 0x0020, "12G SAS3008IT Onboard(0x1BD4-0x0020)"},
{0x1000, 0x0097, 0x1BD4, 0x0026, "12G SAS3008IT RACK(0x1BD4-0x0026)"},
{0x1000, 0x0097, 0x1BD4, 0x0027, "12G SAS3008IMR RACK(0x1BD4-0x0027)"},
{0x1000, 0x0097, 0x1BD4, 0x0028, "12G SAS3008IR RACK(0x1BD4-0x0028)"},
{0x1000, 0x00A5, 0xFFFF, 0xFFFF, "Fusion-MPT 24GSAS/PCIe SAS40xx/41xx(0x00A5)"},
{0x1000, 0x00A5, 0x1000, 0x4600, "MegaRAID 9670W-16i Tri-Mode Storage Adapter(0x1000-0x4600)"},
{0x1000, 0x00A5, 0x1000, 0x4610, "MegaRAID 9670-24i Tri-Mode Storage Adapter(0x1000-0x4610)"},
{0x1000, 0x00A5, 0x1000, 0x4620, "MegaRAID 9660-16i Tri-Mode Storage Adapter(0x1000-0x4620)"},
{0x1000, 0x00A5, 0x1000, 0x4630, "MegaRAID 9660-8i8e Tri-Mode Storage Adapter(0x1000-0x4630)"},
{0x1000, 0x00A5, 0x1000, 0x4640, "eHBA 9600W-16i Tri-Mode Storage Adapter(0x1000-0x4640)"},
{0x1000, 0x00A5, 0x1000, 0x4650, "eHBA 9600W-16e Tri-Mode Storage Adapter(0x1000-0x4650)"},
{0x1000, 0x00A5, 0x1000, 0x4660, "eHBA 9600-24i Tri-Mode Storage Adapter(0x1000-0x4660)"},
{0x1000, 0x00A5, 0x1000, 0x4670, "eHBA 9600-16i Tri-Mode Storage Adapter(0x1000-0x4670)"},
{0x1000, 0x00A5, 0x1000, 0x4680, "eHBA 9600-16e Tri-Mode Storage Adapter(0x1000-0x4680)"},
{0x1000, 0x00A5, 0x1000, 0x4690, "MegaRAID 9620-16i Tri-Mode Storage Adapter(0x1000-0x4690)"},
{0x1000, 0x00A5, 0x1000, 0x46A0, "MegaRAID 9660-24i Tri-Mode Storage Adapter(0x1000-0x46A0)"},
{0x1000, 0x00A5, 0x1000, 0x46C0, "eHBA 9680W-16e Tri-Mode Storage Adapter(0x1000-0x46C0)"},
{0x1000, 0x00A5, 0x1000, 0x46D0, "eHBA 9600-8i8e Tri-Mode Storage Adapter(0x1000-0x46D0)"},
{0x1000, 0x00A5, 0x1000, 0x46E0, "eHBA 9602W-16e Tri-Mode Storage Adapter(0x1000-0x46E0)"},
{0x1000, 0x00A5, 0x1028, 0x2114, "PERC H965i Adapter(0x1028-0x2114)"},
{0x1000, 0x00A5, 0x1028, 0x2115, "PERC H965i Front(0x1028-0x2115)"},
{0x1000, 0x00A5, 0x1028, 0x2117, "PERC H965i MX(0x1028-0x2117)"},
{0x1000, 0x00A5, 0x1028, 0x213A, "PERC H965e Adapter(0x1028-0x213A)"},
{0x1000, 0x00A5, 0x1028, 0x213B, "PERC H765i Adapter(0x1028-0x213B)"},
{0x1000, 0x00A5, 0x1028, 0x213C, "PERC H765i Front(0x1028-0x213C)"},
{0x1000, 0x00A5, 0x1028, 0x213D, "PERC H765N Front(0x1028-0x213D)"},
{0x1000, 0x00A5, 0x1028, 0x213E, "PERC H765i MX(0x1028-0x213E)"},
{0x1000, 0x00A5, 0x1028, 0x213F, "PERC H365i Adapter(0x1028-0x213F)"},
{0x1000, 0x00A5, 0x1028, 0x2140, "PERC H365i Front(0x1028-0x2140)"},
{0x1000, 0x00A5, 0x1028, 0x2142, "HBA465e Adapter(0x1028-0x2142)"},
{0x1000, 0x00A5, 0x1028, 0x2209, "HBA465i Adapter(0x1028-0x2209)"},
{0x1000, 0x00A5, 0x1028, 0x220A, "HBA465i Front(0x1028-0x220A)"},
{0x1000, 0x00A5, 0x1028, 0x22CB, "PERC H365i Front(0x1028-0x22CB)"},
{0x1000, 0x00A5, 0x1028, 0x22CC, "PERC H965i Front(0x1028-0x22CC)"},
{0x1000, 0x00A5, 0x1028, 0x22CD, "HBA465i Front(0x1028-0x22CD)"},
{0x1000, 0x00A5, 0x15D9, 0x1D03, "AOC-S4116L-H16IR (16DD/96DD) RAID Adapter(0x15D9-0x1D03)"},
{0x1000, 0x00A5, 0x15D9, 0x1D07, "AOC-S4016L-L16IT Storage Adapter(0x15D9-0x1D07)"},
{0x1000, 0x00A5, 0x15D9, 0x1D08, "AOC-S4016L-L16IR Storage Adapter(0x15D9-0x1D08)"},
{0x1000, 0x00A5, 0x1D49, 0x020A, "ThinkSystem 450W-16e SAS/SATA PCIe Gen4 24Gb HBA(0x1D49-0x020A)"},
{0x1000, 0x00AB, 0xFFFF, 0xFFFF, "SAS3516 Fusion-MPT Tri-Mode RAID On Chip (ROC)(0x00AB)"},
{0x1000, 0x00AB, 0x1000, 0x3040, "HBA 9400-8i8e(0x1000-0x3040)"},
{0x1000, 0x00AB, 0x8086, 0x3530, "Integrated RAID Module RMSP3JD160J(0x8086-0x3530)"},
{0x1000, 0x00AC, 0xFFFF, 0xFFFF, "SAS3416 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)(0x00AC)"},
{0x1000, 0x00AC, 0x1000, 0x3000, "HBA 9400-16i(0x1000-0x3000)"},
{0x1000, 0x00AC, 0x1000, 0x3020, "HBA 9400-16e(0x1000-0x3020)"},
{0x1000, 0x00AC, 0x1028, 0x1FE3, "HBA345 Adapter(0x1028-0x1FE3)"},
{0x1000, 0x00AC, 0x1028, 0x1FE4, "HBA345 Front(0x1028-0x1FE4)"},
{0x1000, 0x00AC, 0x1D49, 0x0201, "ThinkSystem 430-16i SAS/SATA 12Gb HBA(0x1D49-0x0201)"},
{0x1000, 0x00AC, 0x1D49, 0x0203, "ThinkSystem 430-16e SAS/SATA 12Gb HBA(0x1D49-0x0203)"},
{0x1000, 0x00AC, 0x8086, 0x3000, "RAID Controller RSP3QD160J(0x8086-0x3000)"},
{0x1000, 0x00AC, 0x8086, 0x3020, "RAID Controller RSP3GD016J(0x8086-0x3020)"},
{0x1000, 0x00AE, 0xFFFF, 0xFFFF, "SAS3508 Fusion-MPT Tri-Mode RAID On Chip (ROC)(0x00AE)"},
{0x1000, 0x00AF, 0xFFFF, 0xFFFF, "SAS3408 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)(0x00AF)"},
{0x1000, 0x00AF, 0x1000, 0x3010, "HBA 9400-8i(0x1000-0x3010)"},
{0x1000, 0x00AF, 0x1000, 0x3030, "HBA 9400-8e(0x1000-0x3030)"},
{0x1000, 0x00AF, 0x1D49, 0x0200, "ThinkSystem 430-8i SAS/SATA 12Gb HBA(0x1D49-0x0200)"},
{0x1000, 0x00AF, 0x1D49, 0x0202, "ThinkSystem 430-8e SAS/SATA 12Gb HBA(0x1D49-0x0202)"},
{0x1000, 0x00AF, 0x1D49, 0x0204, "ThinkSystem 430-8i SAS/SATA 12Gb Dense HBA(0x1D49-0x0204)"},
{0x1000, 0x00B2, 0xFFFF, 0xFFFF, "PCIe Switch management endpoint(0x00B2)"},
{0x1000, 0x00B2, 0x1D49, 0x0003, "ThinkSystem 1611-8P PCIe Gen4 NVMe Switch Adapter(0x1D49-0x0003)"},
{0x1000, 0x00B3, 0xFFFF, 0xFFFF, "Fusion-MPT 24G SAS/PCIe SAS50xx/SAS51xx(0x00B3)"},
{0x1000, 0x00B3, 0x1000, 0x5000, "MegaRAID 9760W-32i 24G SAS/PCIe Storage Adapter(0x1000-0x5000)"},
{0x1000, 0x00B3, 0x1000, 0x5001, "MegaRAID 9760W-16i 24G SAS/PCIe Storage Adapter(0x1000-0x5001)"},
{0x1000, 0x00B3, 0x1000, 0x5010, "MegaRAID 9760W-16i16e 24G SAS/PCIe Storage Adapter(0x1000-0x5010)"},
{0x1000, 0x00B3, 0x1000, 0x5020, "eHBA 9700W-32i 24G SAS/PCIe Storage Adapter(0x1000-0x5020)"},
{0x1000, 0x00B3, 0x1000, 0x5021, "eHBA 9700W-16i 24G SAS/PCIe Storage Adapter(0x1000-0x5021)"},
{0x1000, 0x00B3, 0x1000, 0x5030, "eHBA 9700-16e 24G SAS/PCIe Storage Adapter(0x1000-0x5030)"},
{0x1000, 0x00B3, 0x1028, 0x22D2, "PERC H975i Front(0x1028-0x22D2)"},
{0x1000, 0x00B3, 0x1028, 0x22D3, "PERC H975i Adapter(0x1028-0x22D3)"},
{0x1000, 0x00B3, 0x1028, 0x23CB, "PERC H975i Front(0x1028-0x23CB)"},
{0x1000, 0x00B3, 0x1028, 0x23CD, "PERC H975i Adapter(0x1028-0x23CD)"},
{0x1000, 0x00B3, 0x1028, 0x2446, "PERC H976i Front(0x1028-0x2446)"},
{0x1000, 0x00B3, 0x1D49, 0x020B, "ThinkSystem 460-16e SAS/SATA PCIe Gen5 24Gb HBA(0x1D49-0x020B)"},
{0x1000, 0x00B5, 0xFFFF, 0xFFFF, "Fusion-MPT 24G SAS/PCIe SAS50xx/SAS51xx(0x00B5)"},
{0x1000, 0x00B5, 0x1000, 0x5000, "MegaRAID 9760W-32i 24G SAS/PCIe Storage Adapter(0x1000-0x5000)"},
{0x1000, 0x00B5, 0x1000, 0x5001, "MegaRAID 9760W-16i 24G SAS/PCIe Storage Adapter(0x1000-0x5001)"},
{0x1000, 0x00B5, 0x1000, 0x5010, "MegaRAID 9760W-16i16e 24G SAS/PCIe Storage Adapter(0x1000-0x5010)"},
{0x1000, 0x00B5, 0x1000, 0x5020, "eHBA 9700W-32i 24G SAS/PCIe Storage Adapter(0x1000-0x5020)"},
{0x1000, 0x00B5, 0x1000, 0x5021, "eHBA 9700W-16i 24G SAS/PCIe Storage Adapter(0x1000-0x5021)"},
{0x1000, 0x00B5, 0x1000, 0x5030, "eHBA 9700-16e 24G SAS/PCIe Storage Adapter(0x1000-0x5030)"},
{0x1000, 0x00B5, 0x1028, 0x22D2, "PERC H975i Front - Virtual(0x1028-0x22D2)"},
{0x1000, 0x00B5, 0x1028, 0x22D3, "PERC H975i Adapter - Virtual(0x1028-0x22D3)"},
{0x1000, 0x00B5, 0x1028, 0x23CB, "PERC H975i Front - Virtual(0x1028-0x23CB)"},
{0x1000, 0x00B5, 0x1028, 0x23CD, "PERC H975i Adapter - Virtual(0x1028-0x23CD)"},
{0x1000, 0x00B5, 0x1028, 0x2446, "PERC H976i Front - Virtual(0x1028-0x2446)"},
{0x1000, 0x00B8, 0xFFFF, 0xFFFF, "Fusion-MPT Switch SAS50xx/SAS51xx(0x00B8)"},
{0x1000, 0x00BE, 0xFFFF, 0xFFFF, "SAS3504 Fusion-MPT Tri-Mode RAID On Chip (ROC)(0x00BE)"},
{0x1000, 0x00BF, 0xFFFF, 0xFFFF, "SAS3404 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)(0x00BF)"},
{0x1000, 0x00C0, 0xFFFF, 0xFFFF, "SAS3324 PCI-Express Fusion-MPT SAS-3(0x00C0)"},
{0x1000, 0x00C1, 0xFFFF, 0xFFFF, "SAS3324 PCI-Express Fusion-MPT SAS-3(0x00C1)"},
{0x1000, 0x00C2, 0xFFFF, 0xFFFF, "SAS3324 PCI-Express Fusion-MPT SAS-3(0x00C2)"},
{0x1000, 0x00C3, 0xFFFF, 0xFFFF, "SAS3324 PCI-Express Fusion-MPT SAS-3(0x00C3)"},
{0x1000, 0x00C4, 0xFFFF, 0xFFFF, "SAS3224 PCI-Express Fusion-MPT SAS-3(0x00C4)"},
{0x1000, 0x00C4, 0x1000, 0x3190, "SAS9305-16i(0x1000-0x3190)"},
{0x1000, 0x00C4, 0x1000, 0x31A0, "SAS9305-24i(0x1000-0x31A0)"},
{0x1000, 0x00C4, 0x1170, 0x0002, "SAS3224 PCI Express to 12Gb HBA MEZZ CARD(0x1170-0x0002)"},
{0x1000, 0x00C5, 0xFFFF, 0xFFFF, "SAS3316 PCI-Express Fusion-MPT SAS-3(0x00C5)"},
{0x1000, 0x00C6, 0xFFFF, 0xFFFF, "SAS3316 PCI-Express Fusion-MPT SAS-3(0x00C6)"},
{0x1000, 0x00C7, 0xFFFF, 0xFFFF, "SAS3316 PCI-Express Fusion-MPT SAS-3(0x00C7)"},
{0x1000, 0x00C8, 0xFFFF, 0xFFFF, "SAS3316 PCI-Express Fusion-MPT SAS-3(0x00C8)"},
{0x1000, 0x00C9, 0xFFFF, 0xFFFF, "SAS3216 PCI-Express Fusion-MPT SAS-3(0x00C9)"},
{0x1000, 0x00C9, 0x1000, 0x3180, "SAS9305-16e(0x1000-0x3180)"},
{0x1000, 0x00CE, 0xFFFF, 0xFFFF, "MegaRAID SAS-3 3316 [Intruder](0x00CE)"},
{0x1000, 0x00CE, 0x1000, 0x9371, "MegaRAID SAS 9361-16i(0x1000-0x9371)"},
{0x1000, 0x00CE, 0x1000, 0x9390, "MegaRAID SAS 9380-8i8e(0x1000-0x9390)"},
{0x1000, 0x00CF, 0xFFFF, 0xFFFF, "MegaRAID SAS-3 3324 [Intruder](0x00CF)"},
{0x1000, 0x00CF, 0x1000, 0x9370, "MegaRAID SAS 9361-24i(0x1000-0x9370)"},
{0x1000, 0x00D0, 0xFFFF, 0xFFFF, "SAS3716 Fusion-MPT Tri-Mode RAID Controller Chip (ROC)(0x00D0)"},
{0x1000, 0x00D0, 0x1000, 0x3050, "HBA 9405W-16i(0x1000-0x3050)"},
{0x1000, 0x00D0, 0x1000, 0x3070, "HBA 9405W-8i8e(0x1000-0x3070)"},
{0x1000, 0x00D1, 0xFFFF, 0xFFFF, "SAS3616 Fusion-MPT Tri-Mode I/O Controller Chip (IOC)(0x00D1)"},
{0x1000, 0x00D1, 0x1000, 0x3080, "HBA 9405W-16e(0x1000-0x3080)"},
{0x1000, 0x00D1, 0x1000, 0x3090, "HBA 9405W-16i(0x1000-0x3090)"},
{0x1000, 0x00D3, 0xFFFF, 0xFFFF, "MegaRAID Tri-Mode SAS3716W(0x00D3)"},
{0x1000, 0x00E0, 0xFFFF, 0xFFFF, "Fusion-MPT 12GSAS/PCIe Unsupported SAS39xx(0x00E0)"},
{0x1000, 0x00E1, 0xFFFF, 0xFFFF, "Fusion-MPT 12GSAS/PCIe SAS39xx(0x00E1)"},
{0x1000, 0x00E2, 0xFFFF, 0xFFFF, "Fusion-MPT 12GSAS/PCIe Secure SAS39xx(0x00E2)"},
{0x1000, 0x00E3, 0xFFFF, 0xFFFF, "Fusion-MPT 12GSAS/PCIe Unsupported SAS39xx(0x00E3)"},
{0x1000, 0x00E4, 0xFFFF, 0xFFFF, "Fusion-MPT 12GSAS/PCIe Unsupported SAS38xx(0x00E4)"},
{0x1000, 0x00E4, 0x1028, 0x200B, "HBA355i Adapter Invalid(0x1028-0x200B)"},
{0x1000, 0x00E4, 0x1028, 0x200C, "HBA355i Front Invalid(0x1028-0x200C)"},
{0x1000, 0x00E4, 0x1028, 0x200D, "HBA355e Adapter Invalid(0x1028-0x200D)"},
{0x1000, 0x00E4, 0x1028, 0x200E, "HBA350i MX Invalid(0x1028-0x200E)"},
{0x1000, 0x00E5, 0xFFFF, 0xFFFF, "Fusion-MPT 12GSAS/PCIe SAS38xx(0x00E5)"},
{0x1000, 0x00E5, 0x1028, 0x200B, "HBA355i Adapter(0x1028-0x200B)"},
{0x1000, 0x00E5, 0x1028, 0x200C, "HBA355i Front(0x1028-0x200C)"},
{0x1000, 0x00E5, 0x1028, 0x200D, "HBA355e Adapter(0x1028-0x200D)"},
{0x1000, 0x00E5, 0x1028, 0x200E, "HBA350i MX(0x1028-0x200E)"},
{0x1000, 0x00E5, 0x1D49, 0x0205, "ThinkSystem 440-16i SAS/SATA PCIe Gen4 12Gb Internal HBA(0x1D49-0x0205)"},
{0x1000, 0x00E5, 0x1D49, 0x0206, "ThinkSystem 440-16e SAS/SATA PCIe Gen4 12Gb HBA(0x1D49-0x0206)"},
{0x1000, 0x00E6, 0xFFFF, 0xFFFF, "Fusion-MPT 12GSAS/PCIe Secure SAS38xx(0x00E6)"},
{0x1000, 0x00E6, 0x1000, 0x4050, "9500-16i Tri-Mode HBA(0x1000-0x4050)"},
{0x1000, 0x00E6, 0x1000, 0x4060, "9500-8i Tri-Mode HBA(0x1000-0x4060)"},
{0x1000, 0x00E6, 0x1000, 0x4070, "9500-16e Tri-Mode HBA(0x1000-0x4070)"},
{0x1000, 0x00E6, 0x1000, 0x4080, "9500-8e Tri-Mode HBA(0x1000-0x4080)"},
{0x1000, 0x00E6, 0x1028, 0x200B, "HBA355i Adapter(0x1028-0x200B)"},
{0x1000, 0x00E6, 0x1028, 0x200C, "HBA355i Front(0x1028-0x200C)"},
{0x1000, 0x00E6, 0x1028, 0x200D, "HBA355e Adapter(0x1028-0x200D)"},
{0x1000, 0x00E6, 0x1028, 0x200E, "HBA350i MX(0x1028-0x200E)"},
{0x1000, 0x00E6, 0x1028, 0x2170, "HBA350i MM(0x1028-0x2170)"},
{0x1000, 0x00E6, 0x1028, 0x2175, "HBA350i Adapter(0x1028-0x2175)"},
{0x1000, 0x00E6, 0x1028, 0x2197, "HBA350i MM LP(0x1028-0x2197)"},
{0x1000, 0x00E6, 0x1028, 0x2212, "HBA355e-s Adapter(0x1028-0x2212)"},
{0x1000, 0x00E6, 0x15D9, 0x1B64, "SCC-B8SB80-B1 (NI22) Storage Controller Card(0x15D9-0x1B64)"},
{0x1000, 0x00E6, 0x15D9, 0x1B65, "AOC-S3816L-L16iT (NI22) Storage Adapter(0x15D9-0x1B65)"},
{0x1000, 0x00E6, 0x15D9, 0x1B99, "AOC-S3808L-L8iT Storage Adapter(0x15D9-0x1B99)"},
{0x1000, 0x00E6, 0x1D49, 0x0205, "ThinkSystem 440-16i SAS/SATA PCIe Gen4 12Gb Internal HBA(0x1D49-0x0205)"},
{0x1000, 0x00E6, 0x1D49, 0x0206, "ThinkSystem 440-16e SAS/SATA PCIe Gen4 12Gb HBA(0x1D49-0x0206)"},
{0x1000, 0x00E6, 0x1D49, 0x0207, "ThinkSystem 440-8i SAS/SATA PCIe Gen4 12Gb HBA(0x1D49-0x0207)"},
{0x1000, 0x00E6, 0x1D49, 0x0208, "ThinkSystem 440-16i SAS/SATA PCIe Gen4 12Gb HBA(0x1D49-0x0208)"},
{0x1000, 0x00E6, 0x1D49, 0x0209, "ThinkSystem 440-8e SAS/SATA PCIe Gen4 12Gb HBA(0x1D49-0x0209)"},
{0x1000, 0x00E6, 0x8086, 0x4050, "Storage Controller RS3P4QF160J(0x8086-0x4050)"},
{0x1000, 0x00E6, 0x8086, 0x4070, "Storage Controller RS3P4GF016J(0x8086-0x4070)"},
{0x1000, 0x00E7, 0xFFFF, 0xFFFF, "Fusion-MPT 12GSAS/PCIe Unsupported SAS38xx(0x00E7)"},
{0x1000, 0x00E7, 0x1028, 0x200B, "HBA355i Adapter Tampered(0x1028-0x200B)"},
{0x1000, 0x00E7, 0x1028, 0x200C, "HBA355i Front Tampered(0x1028-0x200C)"},
{0x1000, 0x00E7, 0x1028, 0x200D, "HBA355e Adapter Tampered(0x1028-0x200D)"},
{0x1000, 0x00E7, 0x1028, 0x200E, "HBA350i MX Tampered(0x1028-0x200E)"},
{0x1000, 0x02B0, 0xFFFF, 0xFFFF, "Virtual Endpoint on PCIe Switch(0x02B0)"},
{0x1000, 0x02B0, 0x1D49, 0x0001, "ThinkSystem 1610-4P NVMe Switch Adapter(0x1D49-0x0001)"},
{0x1000, 0x02B0, 0x1D49, 0x0002, "ThinkSystem 810-4P NVMe Switch Adapter(0x1D49-0x0002)"},
{0x1000, 0x02B1, 0xFFFF, 0xFFFF, "Virtual Endpoint on PCIe Switch (9749)(0x02B1)"},
{0x1000, 0x02B1, 0x1D49, 0x0004, "ThinkSystem 1610-8P NVMe Switch Adapter(0x1D49-0x0004)"},
{0x1000, 0x02B2, 0xFFFF, 0xFFFF, "Virtual PCIe Placeholder Endpoint(0x02B2)"},
{0x1000, 0x0407, 0xFFFF, 0xFFFF, "MegaRAID(0x0407)"},
{0x1000, 0x0407, 0x1000, 0x0530, "MegaRAID 530 SCSI 320-0X RAID Controller(0x1000-0x0530)"},
{0x1000, 0x0407, 0x1000, 0x0531, "MegaRAID 531 SCSI 320-4X RAID Controller(0x1000-0x0531)"},
{0x1000, 0x0407, 0x1000, 0x0532, "MegaRAID 532 SCSI 320-2X RAID Controller(0x1000-0x0532)"},
{0x1000, 0x0407, 0x1028, 0x0531, "PowerEdge Expandable RAID Controller 4/QC(0x1028-0x0531)"},
{0x1000, 0x0407, 0x1028, 0x0533, "PowerEdge Expandable RAID Controller 4/QC(0x1028-0x0533)"},
{0x1000, 0x0407, 0x8086, 0x0530, "MegaRAID Intel RAID Controller SRCZCRX(0x8086-0x0530)"},
{0x1000, 0x0407, 0x8086, 0x0532, "MegaRAID Intel RAID Controller SRCU42X(0x8086-0x0532)"},
{0x1000, 0x0408, 0xFFFF, 0xFFFF, "MegaRAID(0x0408)"},
{0x1000, 0x0408, 0x1000, 0x0001, "MegaRAID SCSI 320-1E RAID Controller(0x1000-0x0001)"},
{0x1000, 0x0408, 0x1000, 0x0002, "MegaRAID SCSI 320-2E RAID Controller(0x1000-0x0002)"},
{0x1000, 0x0408, 0x1025, 0x004D, "MegaRAID ACER ROMB-2E RAID Controller(0x1025-0x004D)"},
{0x1000, 0x0408, 0x1028, 0x0001, "PowerEdge RAID Controller PERC4e/SC(0x1028-0x0001)"},
{0x1000, 0x0408, 0x1028, 0x0002, "PowerEdge RAID Controller PERC4e/DC(0x1028-0x0002)"},
{0x1000, 0x0408, 0x1028, 0x0012, "PowerEdge RAID Controller RAC4(0x1028-0x0012)"},
{0x1000, 0x0408, 0x1028, 0x0015, "PowerEdge RAID Controller PERC5(0x1028-0x0015)"},
{0x1000, 0x0408, 0x1028, 0x1F03, "PowerEdge RAID Controller PERC5(0x1028-0x1F03)"},
{0x1000, 0x0408, 0x1734, 0x1065, "FSC MegaRAID PCI Express ROMB(0x1734-0x1065)"},
{0x1000, 0x0408, 0x8086, 0x0002, "MegaRAID Intel RAID Controller SRCU42E(0x8086-0x0002)"},
{0x1000, 0x0408, 0x8086, 0x3449, "MegaRAID Intel RAID Controller SROMBU(0x8086-0x3449)"},
{0x1000, 0x0409, 0xFFFF, 0xFFFF, "MegaRAID(0x0409)"},
{0x1000, 0x0409, 0x1000, 0x3004, "MegaRAID SATA 300-4X RAID Controller(0x1000-0x3004)"},
{0x1000, 0x0409, 0x1000, 0x3008, "MegaRAID SATA 300-8X RAID Controller(0x1000-0x3008)"},
{0x1000, 0x0409, 0x8086, 0x3008, "MegaRAID RAID Controller SRCS28X(0x8086-0x3008)"},
{0x1000, 0x0409, 0x8086, 0x3431, "MegaRAID RAID Controller Alief SROMBU42E(0x8086-0x3431)"},
{0x1000, 0x0409, 0x8086, 0x3499, "MegaRAID RAID Controller Harwich SROMBU42E(0x8086-0x3499)"},
{0x1000, 0x0411, 0xFFFF, 0xFFFF, "MegaRAID SAS 1068(0x0411)"},
{0x1000, 0x0411, 0x1000, 0x1001, "MegaRAID SAS 8408E(0x1000-0x1001)"},
{0x1000, 0x0411, 0x1000, 0x1002, "MegaRAID SAS 8480E(0x1000-0x1002)"},
{0x1000, 0x0411, 0x1000, 0x1003, "MegaRAID SAS 8344ELP(0x1000-0x1003)"},
{0x1000, 0x0411, 0x1000, 0x1004, "MegaRAID SAS 8308ELP(0x1000-0x1004)"},
{0x1000, 0x0411, 0x1000, 0x1008, "MegaRAID SAS 84016E(0x1000-0x1008)"},
{0x1000, 0x0411, 0x1000, 0x100C, "MegaRAID SATA 300-12E(0x1000-0x100C)"},
{0x1000, 0x0411, 0x1000, 0x100D, "MegaRAID SATA 300-16E(0x1000-0x100D)"},
{0x1000, 0x0411, 0x1000, 0x2004, "MegaRAID SATA 300-8ELP(0x1000-0x2004)"},
{0x1000, 0x0411, 0x1000, 0x2005, "MegaRAID SATA 300-4ELP(0x1000-0x2005)"},
{0x1000, 0x0411, 0x1033, 0x8287, "MegaRAID SAS PCI Express ROMB(0x1033-0x8287)"},
{0x1000, 0x0411, 0x1054, 0x3016, "MegaRAID SAS RoMB Server(0x1054-0x3016)"},
{0x1000, 0x0411, 0x1734, 0x1081, "MegaRAID SAS PCI Express ROMB(0x1734-0x1081)"},
{0x1000, 0x0411, 0x1734, 0x10A3, "MegaRAID SAS PCI Express ROMB(0x1734-0x10A3)"},
{0x1000, 0x0411, 0x8086, 0x1001, "RAID Controller SRCSAS18E(0x8086-0x1001)"},
{0x1000, 0x0411, 0x8086, 0x1003, "RAID Controller SRCSAS144E(0x8086-0x1003)"},
{0x1000, 0x0411, 0x8086, 0x3500, "SROMBSAS18E RAID Controller(0x8086-0x3500)"},
{0x1000, 0x0411, 0x8086, 0x3501, "SROMBSAS18E RAID Controller(0x8086-0x3501)"},
{0x1000, 0x0411, 0x8086, 0x3504, "SROMBSAS18E RAID Controller(0x8086-0x3504)"},
{0x1000, 0x0413, 0xFFFF, 0xFFFF, "MegaRAID SAS 1068 [Verde ZCR](0x0413)"},
{0x1000, 0x0413, 0x1000, 0x1005, "MegaRAID SAS 8300XLP(0x1000-0x1005)"},
{0x1000, 0x0621, 0xFFFF, 0xFFFF, "FC909 Fibre Channel Adapter(0x0621)"},
{0x1000, 0x0622, 0xFFFF, 0xFFFF, "FC929 Fibre Channel Adapter(0x0622)"},
{0x1000, 0x0622, 0x1000, 0x1020, "44929 O Dual Fibre Channel card(0x1000-0x1020)"},
{0x1000, 0x0623, 0xFFFF, 0xFFFF, "FC929 LAN(0x0623)"},
{0x1000, 0x0624, 0xFFFF, 0xFFFF, "FC919 Fibre Channel Adapter(0x0624)"},
{0x1000, 0x0625, 0xFFFF, 0xFFFF, "FC919 LAN(0x0625)"},
{0x1000, 0x0626, 0xFFFF, 0xFFFF, "FC929X Fibre Channel Adapter(0x0626)"},
{0x1000, 0x0626, 0x1000, 0x1010, "7202-XP-LC Dual Fibre Channel card(0x1000-0x1010)"},
{0x1000, 0x0627, 0xFFFF, 0xFFFF, "FC929X LAN(0x0627)"},
{0x1000, 0x0628, 0xFFFF, 0xFFFF, "FC919X Fibre Channel Adapter(0x0628)"},
{0x1000, 0x0629, 0xFFFF, 0xFFFF, "FC919X LAN(0x0629)"},
{0x1000, 0x0640, 0xFFFF, 0xFFFF, "FC949X Fibre Channel Adapter(0x0640)"},
{0x1000, 0x0642, 0xFFFF, 0xFFFF, "FC939X Fibre Channel Adapter(0x0642)"},
{0x1000, 0x0646, 0xFFFF, 0xFFFF, "FC949ES Fibre Channel Adapter(0x0646)"},
{0x1000, 0x0701, 0xFFFF, 0xFFFF, "83C885 NT50 DigitalScape Fast Ethernet(0x0701)"},
{0x1000, 0x0702, 0xFFFF, 0xFFFF, "Yellowfin G-NIC gigabit ethernet(0x0702)"},
{0x1000, 0x0702, 0x1318, 0x0000, "PEI100X(0x1318-0x0000)"},
{0x1000, 0x0804, 0xFFFF, 0xFFFF, "SA2010(0x0804)"},
{0x1000, 0x0805, 0xFFFF, 0xFFFF, "SA2010ZC(0x0805)"},
{0x1000, 0x0806, 0xFFFF, 0xFFFF, "SA2020(0x0806)"},
{0x1000, 0x0807, 0xFFFF, 0xFFFF, "SA2020ZC(0x0807)"},
{0x1000, 0x0901, 0xFFFF, 0xFFFF, "61C102(0x0901)"},
{0x1000, 0x1000, 0xFFFF, 0xFFFF, "63C815(0x1000)"},
{0x1000, 0x10E0, 0xFFFF, 0xFFFF, "MegaRAID 12GSAS/PCIe Unsupported SAS39xx(0x10E0)"},
{0x1000, 0x10E0, 0x1028, 0x1AE0, "PERC H755 Adapter - Invalid Device(0x1028-0x1AE0)"},
{0x1000, 0x10E0, 0x1028, 0x1AE1, "PERC H755 Front - Invalid Device(0x1028-0x1AE1)"},
{0x1000, 0x10E0, 0x1028, 0x1AE2, "PERC H755N Front - Invalid Device(0x1028-0x1AE2)"},
{0x1000, 0x10E0, 0x1028, 0x1AE3, "PERC H755 MX - Invalid Device(0x1028-0x1AE3)"},
{0x1000, 0x10E1, 0xFFFF, 0xFFFF, "MegaRAID 12GSAS/PCIe SAS39xx(0x10E1)"},
{0x1000, 0x10E1, 0x1028, 0x1AE0, "PERC H755 Adapter(0x1028-0x1AE0)"},
{0x1000, 0x10E1, 0x1028, 0x1AE1, "PERC H755 Front(0x1028-0x1AE1)"},
{0x1000, 0x10E1, 0x1028, 0x1AE2, "PERC H755N Front(0x1028-0x1AE2)"},
{0x1000, 0x10E1, 0x1028, 0x1AE3, "PERC H755 MX(0x1028-0x1AE3)"},
{0x1000, 0x10E1, 0x1D49, 0x060A, "ThinkSystem RAID 940-8i 4GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x060A)"},
{0x1000, 0x10E1, 0x1D49, 0x060B, "ThinkSystem RAID 940-8i 8GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x060B)"},
{0x1000, 0x10E1, 0x1D49, 0x060C, "ThinkSystem RAID 940-16i 8GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x060C)"},
{0x1000, 0x10E1, 0x1D49, 0x060D, "ThinkSystem RAID 940-16i 8GB Flash PCIe Gen4 12Gb Internal Adapter(0x1D49-0x060D)"},
{0x1000, 0x10E1, 0x1D49, 0x060E, "ThinkSystem RAID 940-32i 8GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x060E)"},
{0x1000, 0x10E1, 0x1D49, 0x060F, "ThinkSystem RAID 940-8e 4GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x060F)"},
{0x1000, 0x10E2, 0xFFFF, 0xFFFF, "MegaRAID 12GSAS/PCIe Secure SAS39xx(0x10E2)"},
{0x1000, 0x10E2, 0x1000, 0x4000, "MegaRAID 9560-16i(0x1000-0x4000)"},
{0x1000, 0x10E2, 0x1000, 0x4002, "MegaRAID 9561-16i(0x1000-0x4002)"},
{0x1000, 0x10E2, 0x1000, 0x4010, "MegaRAID 9560-8i(0x1000-0x4010)"},
{0x1000, 0x10E2, 0x1000, 0x4015, "MegaRAID 9550-8i(0x1000-0x4015)"},
{0x1000, 0x10E2, 0x1000, 0x4020, "MegaRAID 9580-8i8e(0x1000-0x4020)"},
{0x1000, 0x10E2, 0x1000, 0x40B0, "MegaRAID 9562-16i(0x1000-0x40B0)"},
{0x1000, 0x10E2, 0x1028, 0x1AE0, "PERC H755 Adapter(0x1028-0x1AE0)"},
{0x1000, 0x10E2, 0x1028, 0x1AE1, "PERC H755 Front(0x1028-0x1AE1)"},
{0x1000, 0x10E2, 0x1028, 0x1AE2, "PERC H755N Front(0x1028-0x1AE2)"},
{0x1000, 0x10E2, 0x1028, 0x1AE3, "PERC H755 MX(0x1028-0x1AE3)"},
{0x1000, 0x10E2, 0x1028, 0x2171, "PERC H750 Mini(0x1028-0x2171)"},
{0x1000, 0x10E2, 0x1028, 0x2176, "PERC H750 Adapter(0x1028-0x2176)"},
{0x1000, 0x10E2, 0x15D9, 0x1B66, "AOC-S3908L-H8iR RAID Adapter(0x15D9-0x1B66)"},
{0x1000, 0x10E2, 0x15D9, 0x1B67, "AOC-S3916L-H16iR RAID Adapter(0x15D9-0x1B67)"},
{0x1000, 0x10E2, 0x15D9, 0x1C06, "AOC-S3916L-H16iR-32DD+ RAID Adapter(0x15D9-0x1C06)"},
{0x1000, 0x10E2, 0x1D49, 0x060A, "ThinkSystem RAID 940-8i 4GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x060A)"},
{0x1000, 0x10E2, 0x1D49, 0x060B, "ThinkSystem RAID 940-8i 8GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x060B)"},
{0x1000, 0x10E2, 0x1D49, 0x060C, "ThinkSystem RAID 940-16i 8GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x060C)"},
{0x1000, 0x10E2, 0x1D49, 0x060D, "ThinkSystem RAID 940-16i 8GB Flash PCIe Gen4 12Gb Internal Adapter(0x1D49-0x060D)"},
{0x1000, 0x10E2, 0x1D49, 0x060E, "ThinkSystem RAID 940-32i 8GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x060E)"},
{0x1000, 0x10E2, 0x1D49, 0x060F, "ThinkSystem RAID 940-8e 4GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x060F)"},
{0x1000, 0x10E2, 0x1D49, 0x0610, "ThinkSystem RAID 940-16i 4GB Flash PCIe Gen4 12Gb Adapter(0x1D49-0x0610)"},
{0x1000, 0x10E2, 0x8086, 0x4000, "RAID Controller RS3P4TF160F(0x8086-0x4000)"},
{0x1000, 0x10E2, 0x8086, 0x4020, "RAID Controller RS3P4MF088F(0x8086-0x4020)"},
{0x1000, 0x10E3, 0xFFFF, 0xFFFF, "MegaRAID 12GSAS/PCIe Unsupported SAS39xx(0x10E3)"},
{0x1000, 0x10E3, 0x1028, 0x1AE0, "PERC H755 Adapter - Tampered Device(0x1028-0x1AE0)"},
{0x1000, 0x10E3, 0x1028, 0x1AE1, "PERC H755 Front - Tampered Device(0x1028-0x1AE1)"},
{0x1000, 0x10E3, 0x1028, 0x1AE2, "PERC H755N Front - Tampered Device(0x1028-0x1AE2)"},
{0x1000, 0x10E3, 0x1028, 0x1AE3, "PERC H755 MX - Tampered Device(0x1028-0x1AE3)"},
{0x1000, 0x10E4, 0xFFFF, 0xFFFF, "MegaRAID 12GSAS/PCIe Unsupported SAS38xx(0x10E4)"},
{0x1000, 0x10E5, 0xFFFF, 0xFFFF, "MegaRAID 12GSAS/PCIe SAS38xx(0x10E5)"},
{0x1000, 0x10E6, 0xFFFF, 0xFFFF, "MegaRAID 12GSAS/PCIe Secure SAS38xx(0x10E6)"},
{0x1000, 0x10E6, 0x1000, 0x04D9, "3808N iMR ROMB(0x1000-0x04D9)"},
{0x1000, 0x10E6, 0x1000, 0x04DA, "3808N iMR ROMB(0x1000-0x04DA)"},
{0x1000, 0x10E6, 0x1000, 0x04DB, "3808N iMR ROMB(0x1000-0x04DB)"},
{0x1000, 0x10E6, 0x1000, 0x04DC, "3808N iMR ROMB(0x1000-0x04DC)"},
{0x1000, 0x10E6, 0x1000, 0x04DD, "3808N iMR ROMB(0x1000-0x04DD)"},
{0x1000, 0x10E6, 0x1000, 0x40D5, "MegaRAID 9540-8i(0x1000-0x40D5)"},
{0x1000, 0x10E6, 0x1000, 0x40D6, "MegaRAID 9520-8i(0x1000-0x40D6)"},
{0x1000, 0x10E6, 0x1000, 0x40D8, "MegaRAID 9524-8i(0x1000-0x40D8)"},
{0x1000, 0x10E6, 0x1000, 0x40E0, "MegaRAID 9540-2M2(0x1000-0x40E0)"},
{0x1000, 0x10E6, 0x1028, 0x1A3D, "BOSS-MR1(0x1028-0x1A3D)"},
{0x1000, 0x10E6, 0x1028, 0x2172, "PERC H355 Adapter(0x1028-0x2172)"},
{0x1000, 0x10E6, 0x1028, 0x2173, "PERC H355 Front(0x1028-0x2173)"},
{0x1000, 0x10E6, 0x1028, 0x2174, "PERC H350 Mini(0x1028-0x2174)"},
{0x1000, 0x10E6, 0x1028, 0x2177, "PERC H350 Adapter(0x1028-0x2177)"},
{0x1000, 0x10E6, 0x1028, 0x2199, "PERC H350 Mini LP(0x1028-0x2199)"},
{0x1000, 0x10E6, 0x15D9, 0x1B9D, "AOC-S3816L-L16IR Storage Adapter(0x15D9-0x1B9D)"},
{0x1000, 0x10E6, 0x15D9, 0x1B9F, "AOC-S3816L-L8IR Storage Adapter(0x15D9-0x1B9F)"},
{0x1000, 0x10E6, 0x15D9, 0x1C6D, "AOC-S3808L-L8IR Storage Adapter(0x15D9-0x1C6D)"},
{0x1000, 0x10E6, 0x15D9, 0x1C6E, "AOC-SLG4-2H8M2 Storage Adapter(0x15D9-0x1C6E)"},
{0x1000, 0x10E6, 0x1D49, 0x0505, "ThinkSystem RAID 540-8i PCIe Gen4 12Gb Adapter(0x1D49-0x0505)"},
{0x1000, 0x10E6, 0x1D49, 0x0506, "ThinkSystem RAID 540-16i PCIe Gen4 12Gb Adapter(0x1D49-0x0506)"},
{0x1000, 0x10E6, 0x1D49, 0x0507, "ThinkSystem RAID 545-8i PCIe Gen4 12Gb Adapter(0x1D49-0x0507)"},
{0x1000, 0x10E6, 0x1D49, 0x0700, "ThinkSystem M.2 RAID B540i-2i SATA/NVMe Enablement Kit(0x1D49-0x0700)"},
{0x1000, 0x10E6, 0x1D49, 0x0701, "ThinkSystem 7mm RAID B540p-2HS SATA/NVMe Enablement Kit(0x1D49-0x0701)"},
{0x1000, 0x10E6, 0x1D49, 0x0702, "ThinkSystem M.2 RAID B540p-2HS SATA/NVMe Enablement Kit(0x1D49-0x0702)"},
{0x1000, 0x10E6, 0x1D49, 0x0703, "ThinkSystem M.2 RAID B540d-2HS SATA/NVMe Enablement Kit(0x1D49-0x0703)"},
{0x1000, 0x10E6, 0x1D49, 0x0704, "ThinkSystem M.2 RAID B545i-2i SATA/NVMe Enablement Kit(0x1D49-0x0704)"},
{0x1000, 0x10E7, 0xFFFF, 0xFFFF, "MegaRAID 12GSAS/PCIe Unsupported SAS38xx(0x10E7)"},
{0x1000, 0x1960, 0xFFFF, 0xFFFF, "MegaRAID(0x1960)"},
{0x1000, 0x1960, 0x1000, 0x0518, "MegaRAID 518 SCSI 320-2 Controller(0x1000-0x0518)"},
{0x1000, 0x1960, 0x1000, 0x0520, "MegaRAID 520 SCSI 320-1 Controller(0x1000-0x0520)"},
{0x1000, 0x1960, 0x1000, 0x0522, "MegaRAID 522 i4 133 RAID Controller(0x1000-0x0522)"},
{0x1000, 0x1960, 0x1000, 0x0523, "MegaRAID SATA 150-6 RAID Controller(0x1000-0x0523)"},
{0x1000, 0x1960, 0x1000, 0x4523, "MegaRAID SATA 150-4 RAID Controller(0x1000-0x4523)"},
{0x1000, 0x1960, 0x1000, 0xA520, "MegaRAID ZCR SCSI 320-0 Controller(0x1000-0xA520)"},
{0x1000, 0x1960, 0x1028, 0x0518, "MegaRAID 518 DELL PERC 4/DC RAID Controller(0x1028-0x0518)"},
{0x1000, 0x1960, 0x1028, 0x0520, "MegaRAID 520 DELL PERC 4/SC RAID Controller(0x1028-0x0520)"},
{0x1000, 0x1960, 0x1028, 0x0531, "PowerEdge Expandable RAID Controller 4/QC(0x1028-0x0531)"},
{0x1000, 0x1960, 0x1028, 0x0533, "PowerEdge Expandable RAID Controller 4/QC(0x1028-0x0533)"},
{0x1000, 0x1960, 0x8086, 0x0520, "MegaRAID RAID Controller SRCU41L(0x8086-0x0520)"},
{0x1000, 0x1960, 0x8086, 0x0523, "MegaRAID RAID Controller SRCS16(0x8086-0x0523)"},
{0x1000, 0x3050, 0xFFFF, 0xFFFF, "SAS2008 PCI-Express Fusion-MPT SAS-2(0x3050)"},
{0x1000, 0x3150, 0xFFFF, 0xFFFF, "1068e(0x3150)"},
{0x1000, 0x6001, 0xFFFF, 0xFFFF, "DX1 Multiformat Broadcast HD/SD Encoder/Decoder(0x6001)"},
{0x1000, 0xC010, 0xFFFF, 0xFFFF, "PEX880xx PCIe Gen 4 Switch(0xC010)"},
{0x1000, 0xC010, 0x1000, 0x100B, "PEX88000 PCIe Gen 4 Virtual Upstream/Downstream Port(0x1000-0x100B)"},
{0x1000, 0xC010, 0x1000, 0x2004, "PEX88000 Virtual PCIe TWC/NT2 Endpoint(0x1000-0x2004)"},
{0x1000, 0xC010, 0x1000, 0x2005, "PEX88000 Virtual PCIe gDMA Endpoint(0x1000-0x2005)"},
{0x1000, 0xC010, 0x1000, 0xA024, "PEX88024 24 lane/port PCIe Gen 4.0 Switch(0x1000-0xA024)"},
{0x1000, 0xC010, 0x1000, 0xA032, "PEX88032 32 lane/port PCIe Gen 4 Switch(0x1000-0xA032)"},
{0x1000, 0xC010, 0x1000, 0xA048, "PEX88048 50 lane/port PCIe Gen 4.0 Switch(0x1000-0xA048)"},
{0x1000, 0xC010, 0x1000, 0xA064, "PEX88064 64 lane/port PCIe Gen 4 Switch(0x1000-0xA064)"},
{0x1000, 0xC010, 0x1000, 0xA080, "PEX88080 80 lane/port PCIe Gen 4 Switch(0x1000-0xA080)"},
{0x1000, 0xC010, 0x1000, 0xA096, "PEX88096 98 lane/port PCIe Gen 4.0 Switch(0x1000-0xA096)"},
{0x1000, 0xC010, 0x4C52, 0x9F48, "LRNV9F48 4-port Built-in 8654 NVMe Switching Adapter(0x4C52-0x9F48)"},
{0x1000, 0xC012, 0xFFFF, 0xFFFF, "PEX880xx PCIe Gen 4 Switch(0xC012)"},
{0x1000, 0xC012, 0x1000, 0x100B, "PEX88000 PCIe Gen 4 Virtual Upstream/Downstream Port(0x1000-0x100B)"},
{0x1000, 0xC012, 0x1000, 0x2004, "PEX88000 Virtual PCIe TWC/NT2 Endpoint(0x1000-0x2004)"},
{0x1000, 0xC012, 0x1000, 0x2005, "PEX88000 Virtual PCIe gDMA Endpoint(0x1000-0x2005)"},
{0x1000, 0xC012, 0x1000, 0xA024, "PEX88024 24 lane/port PCIe Gen 4.0 Switch(0x1000-0xA024)"},
{0x1000, 0xC012, 0x1000, 0xA032, "PEX88032 32 lane/port PCIe Gen 4.0 Switch(0x1000-0xA032)"},
{0x1000, 0xC012, 0x1000, 0xA048, "PEX88048 48 lane/port PCIe Gen 4.0 Switch(0x1000-0xA048)"},
{0x1000, 0xC012, 0x1000, 0xA064, "PEX88064 64 lane/port PCIe Gen 4.0 Switch(0x1000-0xA064)"},
{0x1000, 0xC012, 0x1000, 0xA080, "PEX88080 80 lane/port PCIe Gen 4.0 Switch(0x1000-0xA080)"},
{0x1000, 0xC012, 0x1000, 0xA096, "PEX88096 96 lane/port PCIe Gen 4.0 Switch(0x1000-0xA096)"},
{0x1000, 0xC012, 0x1D49, 0x0003, "ThinkSystem 1611-8P PCIe Gen4 NVMe Switch Adapter(0x1D49-0x0003)"},
{0x1000, 0xC030, 0xFFFF, 0xFFFF, "PEX890xx PCIe Gen 5 Switch(0xC030)"},
{0x1000, 0xC030, 0x1000, 0x0024, "PEX89024 PCIe Gen 5 24 port/lane Switch Upstream/Downstream Port(0x1000-0x0024)"},
{0x1000, 0xC030, 0x1000, 0x0032, "PEX89032 PCIe Gen 5 32 port/lane Switch Upstream/Downstream Port(0x1000-0x0032)"},
{0x1000, 0xC030, 0x1000, 0x0048, "PEX89048 PCIe Gen 5 48 port/lane Switch Upstream/Downstream Port(0x1000-0x0048)"},
{0x1000, 0xC030, 0x1000, 0x0072, "PEX89072 PCIe Gen 5 36 port/72 lane Switch Upstream/Downstream Port(0x1000-0x0072)"},
{0x1000, 0xC030, 0x1000, 0x0088, "PEX89088 PCIe Gen 5 44 port/88 lane Switch Upstream/Downstream Port(0x1000-0x0088)"},
{0x1000, 0xC030, 0x1000, 0x0104, "PEX89104 PCIe Gen 5 52 port/104 lane Switch Upstream/Downstream Port(0x1000-0x0104)"},
{0x1000, 0xC030, 0x1000, 0x0144, "PEX89144 PCIe Gen 5 72 port/144 lane Switch Upstream/Downstream Port(0x1000-0x0144)"},
{0x1000, 0xC030, 0x1000, 0x100B, "PEX89000 PCIe Gen 5 Virtual Upstream/Downstream Port(0x1000-0x100B)"},
{0x1000, 0xC030, 0x1000, 0x2004, "PEX89000 Virtual PCIe TWC/NT 2.0 Endpoint(0x1000-0x2004)"},
{0x1000, 0xC030, 0x1000, 0x2005, "PEX89000 Virtual PCIe gDMA Endpoint(0x1000-0x2005)"},
{0x1000, 0xC034, 0xFFFF, 0xFFFF, "PEX890xx PCIe Gen 5 Switch(0xC034)"},
{0x1000, 0xC034, 0x1000, 0x0024, "PEX89024 PCIe Gen 5 24 port/lane Switch Upstream/Downstream Port(0x1000-0x0024)"},
{0x1000, 0xC034, 0x1000, 0x0032, "PEX89032 PCIe Gen 5 32 port/lane Switch Upstream/Downstream Port(0x1000-0x0032)"},
{0x1000, 0xC034, 0x1000, 0x0048, "PEX89048 PCIe Gen 5 48 port/lane Switch Upstream/Downstream Port(0x1000-0x0048)"},
{0x1000, 0xC034, 0x1000, 0x100B, "PEX89000 PCIe Gen 5 Virtual Upstream/Downstream Port(0x1000-0x100B)"},
{0x1000, 0xC034, 0x1000, 0x2004, "PEX89000 Virtual PCIe TWC/NT 2.0 Endpoint(0x1000-0x2004)"},
{0x1000, 0xC034, 0x1000, 0x2005, "PEX89000 Virtual PCIe gDMA Endpoint(0x1000-0x2005)"},
}; /* pci_vid_1000[] */

static pci_id_t const pci_vid_1001[] = {
{0x1001, 0xFFFF, 0xFFFF, 0xFFFF, "Kolter Electronic(0x1001)"},
{0x1001, 0x0010, 0xFFFF, 0xFFFF, "PCI 1616 Measurement card with 32 digital I/O lines(0x0010)"},
{0x1001, 0x0011, 0xFFFF, 0xFFFF, "OPTO-PCI Opto-Isolated digital I/O board(0x0011)"},
{0x1001, 0x0012, 0xFFFF, 0xFFFF, "PCI-AD/DA Analogue I/O board(0x0012)"},
{0x1001, 0x0013, 0xFFFF, 0xFFFF, "PCI-OPTO-RELAIS Digital I/O board with relay outputs(0x0013)"},
{0x1001, 0x0014, 0xFFFF, 0xFFFF, "PCI-Counter/Timer Counter Timer board(0x0014)"},
{0x1001, 0x0015, 0xFFFF, 0xFFFF, "PCI-DAC416 Analogue output board(0x0015)"},
{0x1001, 0x0016, 0xFFFF, 0xFFFF, "PCI-MFB Analogue I/O board(0x0016)"},
{0x1001, 0x0017, 0xFFFF, 0xFFFF, "PROTO-3 PCI Prototyping board(0x0017)"},
{0x1001, 0x9100, 0xFFFF, 0xFFFF, "INI-9100/9100W SCSI Host(0x9100)"},
}; /* pci_vid_1001[] */

static pci_id_t const pci_vid_1002[] = {
{0x1002, 0xFFFF, 0xFFFF, 0xFFFF, "Advanced Micro Devices, Inc. [AMD/ATI](0x1002)"},
{0x1002, 0x1114, 0xFFFF, 0xFFFF, "Krackan [Radeon 840M / 860M Graphics](0x1114)"},
{0x1002, 0x1304, 0xFFFF, 0xFFFF, "Kaveri(0x1304)"},
{0x1002, 0x1305, 0xFFFF, 0xFFFF, "Kaveri(0x1305)"},
{0x1002, 0x1306, 0xFFFF, 0xFFFF, "Kaveri(0x1306)"},
{0x1002, 0x1307, 0xFFFF, 0xFFFF, "Kaveri(0x1307)"},
{0x1002, 0x1308, 0xFFFF, 0xFFFF, "Kaveri HDMI/DP Audio Controller(0x1308)"},
{0x1002, 0x1308, 0x17AA, 0x3988, "Z50-75(0x17AA-0x3988)"},
{0x1002, 0x1309, 0xFFFF, 0xFFFF, "Kaveri [Radeon R6/R7 Graphics](0x1309)"},
{0x1002, 0x1309, 0x17AA, 0x3830, "Z50-75(0x17AA-0x3830)"},
{0x1002, 0x130A, 0xFFFF, 0xFFFF, "Kaveri [Radeon R6 Graphics](0x130A)"},
{0x1002, 0x130B, 0xFFFF, 0xFFFF, "Kaveri [Radeon R4 Graphics](0x130B)"},
{0x1002, 0x130C, 0xFFFF, 0xFFFF, "Kaveri [Radeon R7 Graphics](0x130C)"},
{0x1002, 0x130D, 0xFFFF, 0xFFFF, "Kaveri [Radeon R6 Graphics](0x130D)"},
{0x1002, 0x130E, 0xFFFF, 0xFFFF, "Kaveri [Radeon R5 Graphics](0x130E)"},
{0x1002, 0x130F, 0xFFFF, 0xFFFF, "Kaveri [Radeon R7 Graphics](0x130F)"},
{0x1002, 0x1310, 0xFFFF, 0xFFFF, "Kaveri(0x1310)"},
{0x1002, 0x1311, 0xFFFF, 0xFFFF, "Kaveri(0x1311)"},
{0x1002, 0x1312, 0xFFFF, 0xFFFF, "Kaveri(0x1312)"},
{0x1002, 0x1313, 0xFFFF, 0xFFFF, "Kaveri [Radeon R7 Graphics](0x1313)"},
{0x1002, 0x1314, 0xFFFF, 0xFFFF, "Wrestler HDMI Audio(0x1314)"},
{0x1002, 0x1314, 0x174B, 0x1001, "PURE Fusion Mini(0x174B-0x1001)"},
{0x1002, 0x1315, 0xFFFF, 0xFFFF, "Kaveri [Radeon R5 Graphics](0x1315)"},
{0x1002, 0x1316, 0xFFFF, 0xFFFF, "Kaveri [Radeon R5 Graphics](0x1316)"},
{0x1002, 0x1317, 0xFFFF, 0xFFFF, "Kaveri(0x1317)"},
{0x1002, 0x1318, 0xFFFF, 0xFFFF, "Kaveri [Radeon R5 Graphics](0x1318)"},
{0x1002, 0x131B, 0xFFFF, 0xFFFF, "Kaveri [Radeon R4 Graphics](0x131B)"},
{0x1002, 0x131C, 0xFFFF, 0xFFFF, "Kaveri [Radeon R7 Graphics](0x131C)"},
{0x1002, 0x131D, 0xFFFF, 0xFFFF, "Kaveri [Radeon R6 Graphics](0x131D)"},
{0x1002, 0x13C0, 0xFFFF, 0xFFFF, "Granite Ridge [Radeon Graphics](0x13C0)"},
{0x1002, 0x13E9, 0xFFFF, 0xFFFF, "Ariel/Navi10Lite(0x13E9)"},
{0x1002, 0x13F9, 0xFFFF, 0xFFFF, "Oberon/Navi12Lite(0x13F9)"},
{0x1002, 0x13FE, 0xFFFF, 0xFFFF, "Cyan Skillfish [BC-250](0x13FE)"},
{0x1002, 0x1435, 0xFFFF, 0xFFFF, "Sephiroth [AMD Custom GPU 0405](0x1435)"},
{0x1002, 0x145A, 0xFFFF, 0xFFFF, "Dummy Function (absent graphics controller)(0x145A)"},
{0x1002, 0x1478, 0xFFFF, 0xFFFF, "Navi 10 XL Upstream Port of PCI Express Switch(0x1478)"},
{0x1002, 0x1479, 0xFFFF, 0xFFFF, "Navi 10 XL Downstream Port of PCI Express Switch(0x1479)"},
{0x1002, 0x1506, 0xFFFF, 0xFFFF, "Mendocino(0x1506)"},
{0x1002, 0x150E, 0xFFFF, 0xFFFF, "Strix [Radeon 880M / 890M](0x150E)"},
{0x1002, 0x154C, 0xFFFF, 0xFFFF, "Kryptos [Radeon RX 350](0x154C)"},
{0x1002, 0x154C, 0x1462, 0x7C28, "MS-7C28 Motherboard(0x1462-0x7C28)"},
{0x1002, 0x154E, 0xFFFF, 0xFFFF, "Garfield(0x154E)"},
{0x1002, 0x1551, 0xFFFF, 0xFFFF, "Arlene(0x1551)"},
{0x1002, 0x1552, 0xFFFF, 0xFFFF, "Pooky(0x1552)"},
{0x1002, 0x1561, 0xFFFF, 0xFFFF, "Anubis(0x1561)"},
{0x1002, 0x1586, 0xFFFF, 0xFFFF, "Strix Halo [Radeon Graphics / Radeon 8050S Graphics / Radeon 8060S Graphics](0x1586)"},
{0x1002, 0x15BF, 0xFFFF, 0xFFFF, "Phoenix1(0x15BF)"},
{0x1002, 0x15C8, 0xFFFF, 0xFFFF, "Phoenix2(0x15C8)"},
{0x1002, 0x15D8, 0xFFFF, 0xFFFF, "Picasso/Raven 2 [Radeon Vega Series / Radeon Vega Mobile Series](0x15D8)"},
{0x1002, 0x15D8, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1002, 0x15D8, 0x17AA, 0x3181, "ThinkCentre M75n IoT(0x17AA-0x3181)"},
{0x1002, 0x15D8, 0x17AA, 0x5124, "ThinkPad E595(0x17AA-0x5124)"},
{0x1002, 0x15D8, 0x1DC2, 0x2209, "Avita Pura 14 Notebook(0x1DC2-0x2209)"},
{0x1002, 0x15D8, 0xEA50, 0xCC10, "RXi2-BP(0xEA50-0xCC10)"},
{0x1002, 0x15DD, 0xFFFF, 0xFFFF, "Raven Ridge [Radeon Vega Series / Radeon Vega Mobile Series](0x15DD)"},
{0x1002, 0x15DD, 0x103C, 0x83C6, "Radeon Vega 8 Mobile(0x103C-0x83C6)"},
{0x1002, 0x15DD, 0x1043, 0x876B, "PRIME Motherboard(0x1043-0x876B)"},
{0x1002, 0x15DD, 0x1458, 0xD000, "Radeon RX Vega 11(0x1458-0xD000)"},
{0x1002, 0x15DD, 0xEA50, 0xCC10, "RXi2-BP(0xEA50-0xCC10)"},
{0x1002, 0x15DE, 0xFFFF, 0xFFFF, "Raven/Raven2/Fenghuang HDMI/DP Audio Controller(0x15DE)"},
{0x1002, 0x15DE, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1002, 0x15DE, 0x1043, 0x876B, "PRIME B450M-A Motherboard(0x1043-0x876B)"},
{0x1002, 0x15DE, 0x17AA, 0x5124, "ThinkPad E595(0x17AA-0x5124)"},
{0x1002, 0x15DE, 0xEA50, 0xCC10, "RXi2-BP(0xEA50-0xCC10)"},
{0x1002, 0x15DF, 0xFFFF, 0xFFFF, "Raven/Raven2/Fenghuang/Renoir Cryptographic Coprocessor(0x15DF)"},
{0x1002, 0x15DF, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1002, 0x15DF, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1002, 0x15E7, 0xFFFF, 0xFFFF, "Barcelo(0x15E7)"},
{0x1002, 0x15E7, 0x103C, 0x8B17, "ProBook 445 G9/455 G9 [Ryzen 7 Integrated Radeon GPU](0x103C-0x8B17)"},
{0x1002, 0x15FF, 0xFFFF, 0xFFFF, "Fenghuang [Zhongshan Subor Z+](0x15FF)"},
{0x1002, 0x1607, 0xFFFF, 0xFFFF, "Arden(0x1607)"},
{0x1002, 0x1636, 0xFFFF, 0xFFFF, "Renoir [Radeon Vega Series / Radeon Vega Mobile Series](0x1636)"},
{0x1002, 0x1637, 0xFFFF, 0xFFFF, "Renoir/Cezanne HDMI/DP Audio Controller(0x1637)"},
{0x1002, 0x1638, 0xFFFF, 0xFFFF, "Cezanne [Radeon Vega Series / Radeon Vega Mobile Series](0x1638)"},
{0x1002, 0x1638, 0x1043, 0x16C2, "Radeon Vega 8(0x1043-0x16C2)"},
{0x1002, 0x163F, 0xFFFF, 0xFFFF, "VanGogh [AMD Custom GPU 0405](0x163F)"},
{0x1002, 0x1640, 0xFFFF, 0xFFFF, "Radeon High Definition Audio Controller [Rembrandt/Strix](0x1640)"},
{0x1002, 0x164C, 0xFFFF, 0xFFFF, "Lucienne(0x164C)"},
{0x1002, 0x164D, 0xFFFF, 0xFFFF, "Rembrandt(0x164D)"},
{0x1002, 0x164E, 0xFFFF, 0xFFFF, "Raphael(0x164E)"},
{0x1002, 0x164F, 0xFFFF, 0xFFFF, "Phoenix(0x164F)"},
{0x1002, 0x1681, 0xFFFF, 0xFFFF, "Rembrandt [Radeon 680M](0x1681)"},
{0x1002, 0x1714, 0xFFFF, 0xFFFF, "BeaverCreek HDMI Audio [Radeon HD 6500D and 6400G-6600G series](0x1714)"},
{0x1002, 0x1714, 0x103C, 0x168B, "ProBook 4535s(0x103C-0x168B)"},
{0x1002, 0x1900, 0xFFFF, 0xFFFF, "HawkPoint1(0x1900)"},
{0x1002, 0x1901, 0xFFFF, 0xFFFF, "HawkPoint2(0x1901)"},
{0x1002, 0x1902, 0xFFFF, 0xFFFF, "Krackan2(0x1902)"},
{0x1002, 0x3150, 0xFFFF, 0xFFFF, "RV380/M24 [Mobility Radeon X600](0x3150)"},
{0x1002, 0x3150, 0x103C, 0x0934, "nx8220(0x103C-0x0934)"},
{0x1002, 0x3151, 0xFFFF, 0xFFFF, "RV380 GL [FireMV 2400](0x3151)"},
{0x1002, 0x3152, 0xFFFF, 0xFFFF, "RV370/M22 [Mobility Radeon X300](0x3152)"},
{0x1002, 0x3154, 0xFFFF, 0xFFFF, "RV380/M24 GL [Mobility FireGL V3200](0x3154)"},
{0x1002, 0x3155, 0xFFFF, 0xFFFF, "RV380 GL [FireMV 2400](0x3155)"},
{0x1002, 0x3171, 0xFFFF, 0xFFFF, "RV380 GL [FireMV 2400] (Secondary)(0x3171)"},
{0x1002, 0x3E50, 0xFFFF, 0xFFFF, "RV380 [Radeon X550/X600](0x3E50)"},
{0x1002, 0x3E54, 0xFFFF, 0xFFFF, "RV380 GL [FireGL V3200](0x3E54)"},
{0x1002, 0x3E70, 0xFFFF, 0xFFFF, "RV380 [Radeon X550/X600] (Secondary)(0x3E70)"},
{0x1002, 0x4136, 0xFFFF, 0xFFFF, "RS100 [Mobility IGP 320M](0x4136)"},
{0x1002, 0x4137, 0xFFFF, 0xFFFF, "RS200 [Radeon IGP 340](0x4137)"},
{0x1002, 0x4144, 0xFFFF, 0xFFFF, "R300 [Radeon 9500](0x4144)"},
{0x1002, 0x4146, 0xFFFF, 0xFFFF, "R300 [Radeon 9700 PRO](0x4146)"},
{0x1002, 0x4147, 0xFFFF, 0xFFFF, "R300 GL [FireGL Z1](0x4147)"},
{0x1002, 0x4148, 0xFFFF, 0xFFFF, "R350 [Radeon 9800/9800 SE](0x4148)"},
{0x1002, 0x4150, 0xFFFF, 0xFFFF, "RV350 [Radeon 9550/9600/X1050 Series](0x4150)"},
{0x1002, 0x4150, 0x1002, 0x0002, "R9600 Pro primary (Asus OEM for HP)(0x1002-0x0002)"},
{0x1002, 0x4150, 0x1002, 0x0003, "R9600 Pro secondary (Asus OEM for HP)(0x1002-0x0003)"},
{0x1002, 0x4150, 0x1002, 0x4722, "All-in-Wonder 2006 AGP Edition(0x1002-0x4722)"},
{0x1002, 0x4150, 0x1458, 0x4024, "GV-R96128D(0x1458-0x4024)"},
{0x1002, 0x4150, 0x148C, 0x2064, "R96A-C3N(0x148C-0x2064)"},
{0x1002, 0x4150, 0x148C, 0x2066, "R96A-C3N(0x148C-0x2066)"},
{0x1002, 0x4150, 0x174B, 0x7C19, "Atlantis Radeon 9600 Pro(0x174B-0x7C19)"},
{0x1002, 0x4150, 0x174B, 0x7C29, "GC-R9600PRO(0x174B-0x7C29)"},
{0x1002, 0x4150, 0x17EE, 0x2002, "Radeon 9600 256Mb Primary(0x17EE-0x2002)"},
{0x1002, 0x4150, 0x18BC, 0x0101, "GC-R9600PRO (Primary)(0x18BC-0x0101)"},
{0x1002, 0x4151, 0xFFFF, 0xFFFF, "RV350 [Radeon 9600 Series](0x4151)"},
{0x1002, 0x4151, 0x1043, 0xC004, "A9600SE(0x1043-0xC004)"},
{0x1002, 0x4151, 0x174B, 0x7C37, "Radeon 9600SE 128M DDR V/D/VO(0x174B-0x7C37)"},
{0x1002, 0x4152, 0xFFFF, 0xFFFF, "RV360 [Radeon 9600/X1050 Series](0x4152)"},
{0x1002, 0x4152, 0x1002, 0x0002, "Radeon 9600XT(0x1002-0x0002)"},
{0x1002, 0x4152, 0x1002, 0x4772, "All-in-Wonder 9600 XT(0x1002-0x4772)"},
{0x1002, 0x4152, 0x1043, 0xC002, "Radeon 9600 XT TVD(0x1043-0xC002)"},
{0x1002, 0x4152, 0x1043, 0xC01A, "A9600XT/TD(0x1043-0xC01A)"},
{0x1002, 0x4152, 0x1462, 0x9510, "RX9600XT (MS-8951)(0x1462-0x9510)"},
{0x1002, 0x4152, 0x174B, 0x7C29, "Radeon 9600XT(0x174B-0x7C29)"},
{0x1002, 0x4152, 0x1787, 0x4002, "Radeon 9600 XT(0x1787-0x4002)"},
{0x1002, 0x4153, 0xFFFF, 0xFFFF, "RV350 [Radeon 9550](0x4153)"},
{0x1002, 0x4153, 0x1043, 0x010C, "A9550GE/TD(0x1043-0x010C)"},
{0x1002, 0x4153, 0x1462, 0x932C, "RX9550SE-TD128 (MS-8932)(0x1462-0x932C)"},
{0x1002, 0x4154, 0xFFFF, 0xFFFF, "RV350 GL [FireGL T2](0x4154)"},
{0x1002, 0x4155, 0xFFFF, 0xFFFF, "RV350 [Radeon 9600](0x4155)"},
{0x1002, 0x4157, 0xFFFF, 0xFFFF, "RV350 GL [FireGL T2](0x4157)"},
{0x1002, 0x4158, 0xFFFF, 0xFFFF, "68800AX [Graphics Ultra Pro PCI](0x4158)"},
{0x1002, 0x4164, 0xFFFF, 0xFFFF, "R300 [Radeon 9500 PRO] (Secondary)(0x4164)"},
{0x1002, 0x4165, 0xFFFF, 0xFFFF, "R300 [Radeon 9700 PRO] (Secondary)(0x4165)"},
{0x1002, 0x4166, 0xFFFF, 0xFFFF, "R300 [Radeon 9700 PRO] (Secondary)(0x4166)"},
{0x1002, 0x4168, 0xFFFF, 0xFFFF, "RV350 [Radeon 9800 SE] (Secondary)(0x4168)"},
{0x1002, 0x4170, 0xFFFF, 0xFFFF, "RV350 [Radeon 9550/9600/X1050 Series] (Secondary)(0x4170)"},
{0x1002, 0x4170, 0x1002, 0x0003, "R9600 Pro secondary (Asus OEM for HP)(0x1002-0x0003)"},
{0x1002, 0x4170, 0x1002, 0x4723, "All-in-Wonder 2006 AGP Edition (Secondary)(0x1002-0x4723)"},
{0x1002, 0x4170, 0x1458, 0x4025, "GV-R96128D (Secondary)(0x1458-0x4025)"},
{0x1002, 0x4170, 0x148C, 0x2067, "R96A-C3N (Secondary)(0x148C-0x2067)"},
{0x1002, 0x4170, 0x174B, 0x7C28, "GC-R9600PRO (Secondary)(0x174B-0x7C28)"},
{0x1002, 0x4170, 0x17EE, 0x2003, "Radeon 9600 256Mb (Secondary)(0x17EE-0x2003)"},
{0x1002, 0x4170, 0x18BC, 0x0100, "GC-R9600PRO (Secondary)(0x18BC-0x0100)"},
{0x1002, 0x4171, 0xFFFF, 0xFFFF, "RV350 [Radeon 9600] (Secondary)(0x4171)"},
{0x1002, 0x4171, 0x1043, 0xC005, "A9600SE (Secondary)(0x1043-0xC005)"},
{0x1002, 0x4171, 0x174B, 0x7C36, "Radeon 9600SE 128M DDR V/D/VO (secondary)(0x174B-0x7C36)"},
{0x1002, 0x4172, 0xFFFF, 0xFFFF, "RV350 [Radeon 9600/X1050 Series] (Secondary)(0x4172)"},
{0x1002, 0x4172, 0x1002, 0x0003, "Radeon 9600XT (Secondary)(0x1002-0x0003)"},
{0x1002, 0x4172, 0x1002, 0x4773, "All-in-Wonder 9600 XT (Secondary)(0x1002-0x4773)"},
{0x1002, 0x4172, 0x1043, 0xC003, "A9600XT (Secondary)(0x1043-0xC003)"},
{0x1002, 0x4172, 0x1043, 0xC01B, "A9600XT/TD (Secondary)(0x1043-0xC01B)"},
{0x1002, 0x4172, 0x174B, 0x7C28, "Radeon 9600XT (Secondary)(0x174B-0x7C28)"},
{0x1002, 0x4172, 0x1787, 0x4003, "Radeon 9600 XT (Secondary)(0x1787-0x4003)"},
{0x1002, 0x4173, 0xFFFF, 0xFFFF, "RV350 [Radeon 9550] (Secondary)(0x4173)"},
{0x1002, 0x4173, 0x1043, 0x010D, "A9550GE/TD (Secondary)(0x1043-0x010D)"},
{0x1002, 0x4242, 0xFFFF, 0xFFFF, "R200 [All-In-Wonder Radeon 8500 DV](0x4242)"},
{0x1002, 0x4242, 0x1002, 0x02AA, "Radeon 8500 AIW DV Edition(0x1002-0x02AA)"},
{0x1002, 0x4243, 0xFFFF, 0xFFFF, "R200 PCI Bridge [All-in-Wonder Radeon 8500DV](0x4243)"},
{0x1002, 0x4336, 0xFFFF, 0xFFFF, "RS100 [Radeon IGP 320M](0x4336)"},
{0x1002, 0x4336, 0x1002, 0x4336, "Pavilion ze4300 ATI Radeon Mobility U1 (IGP 320 M)(0x1002-0x4336)"},
{0x1002, 0x4336, 0x103C, 0x0024, "Pavilion ze4400 builtin Video(0x103C-0x0024)"},
{0x1002, 0x4336, 0x161F, 0x2029, "eMachines M5312 builtin Video(0x161F-0x2029)"},
{0x1002, 0x4337, 0xFFFF, 0xFFFF, "RS200M [Radeon IGP 330M/340M/345M/350M](0x4337)"},
{0x1002, 0x4337, 0x1014, 0x053A, "ThinkPad R40e(0x1014-0x053A)"},
{0x1002, 0x4337, 0x103C, 0x0850, "Radeon IGP 345M(0x103C-0x0850)"},
{0x1002, 0x4341, 0xFFFF, 0xFFFF, "SB200 AC97 Audio Controller(0x4341)"},
{0x1002, 0x4342, 0xFFFF, 0xFFFF, "SB200 PCI to PCI Bridge(0x4342)"},
{0x1002, 0x4345, 0xFFFF, 0xFFFF, "SB200 EHCI USB Controller(0x4345)"},
{0x1002, 0x4346, 0xFFFF, 0xFFFF, "Crayola 6 [XENOS Parent Die (XBOX 360)](0x4346)"},
{0x1002, 0x4347, 0xFFFF, 0xFFFF, "SB200 OHCI USB Controller #1(0x4347)"},
{0x1002, 0x4348, 0xFFFF, 0xFFFF, "SB200 OHCI USB Controller #2(0x4348)"},
{0x1002, 0x4349, 0xFFFF, 0xFFFF, "SB200 IDE Controller(0x4349)"},
{0x1002, 0x434C, 0xFFFF, 0xFFFF, "SB200 PCI to LPC Bridge(0x434C)"},
{0x1002, 0x434D, 0xFFFF, 0xFFFF, "SB200 AC97 Modem Controller(0x434D)"},
{0x1002, 0x4353, 0xFFFF, 0xFFFF, "SB200 SMBus Controller(0x4353)"},
{0x1002, 0x4354, 0xFFFF, 0xFFFF, "215CT [Mach64 CT PCI](0x4354)"},
{0x1002, 0x4358, 0xFFFF, 0xFFFF, "Mach64 CX [Graphics Xpression](0x4358)"},
{0x1002, 0x4361, 0xFFFF, 0xFFFF, "SB300 AC'97 Audio Controller(0x4361)"},
{0x1002, 0x4362, 0xFFFF, 0xFFFF, "SB300 PCI to PCI Bridge(0x4362)"},
{0x1002, 0x4363, 0xFFFF, 0xFFFF, "SB300 SMBus Controller(0x4363)"},
{0x1002, 0x4365, 0xFFFF, 0xFFFF, "SB300 USB Controller (EHCI)(0x4365)"},
{0x1002, 0x4367, 0xFFFF, 0xFFFF, "SB300 USB Controller (EHCI)(0x4367)"},
{0x1002, 0x4368, 0xFFFF, 0xFFFF, "SB300 USB Controller (EHCI)(0x4368)"},
{0x1002, 0x4369, 0xFFFF, 0xFFFF, "SB300 IDE Controller(0x4369)"},
{0x1002, 0x436C, 0xFFFF, 0xFFFF, "SB300 PCI to LPC Bridge(0x436C)"},
{0x1002, 0x436D, 0xFFFF, 0xFFFF, "SB300 AC97 Modem Controller(0x436D)"},
{0x1002, 0x436E, 0xFFFF, 0xFFFF, "SB300 Serial ATA Controller(0x436E)"},
{0x1002, 0x4370, 0xFFFF, 0xFFFF, "IXP SB400 AC'97 Audio Controller(0x4370)"},
{0x1002, 0x4370, 0x1025, 0x0079, "Aspire 5024WLMMi(0x1025-0x0079)"},
{0x1002, 0x4370, 0x1025, 0x0091, "Aspire 5032WXMi(0x1025-0x0091)"},
{0x1002, 0x4370, 0x103C, 0x2A05, "Pavilion t3030.de Desktop PC(0x103C-0x2A05)"},
{0x1002, 0x4370, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x4370, 0x105B, 0x0C81, "Realtek ALC 653(0x105B-0x0C81)"},
{0x1002, 0x4370, 0x107B, 0x0300, "MX6421(0x107B-0x0300)"},
{0x1002, 0x4370, 0x1462, 0x0131, "MS-1013 Notebook(0x1462-0x0131)"},
{0x1002, 0x4371, 0xFFFF, 0xFFFF, "IXP SB4x0 PCI-PCI Bridge(0x4371)"},
{0x1002, 0x4371, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x4371, 0x1462, 0x7217, "Aspire L250(0x1462-0x7217)"},
{0x1002, 0x4372, 0xFFFF, 0xFFFF, "IXP SB4x0 SMBus Controller(0x4372)"},
{0x1002, 0x4372, 0x1025, 0x0080, "Aspire 5024WLMMi(0x1025-0x0080)"},
{0x1002, 0x4372, 0x103C, 0x2A20, "Pavilion t3030.de Desktop PC(0x103C-0x2A20)"},
{0x1002, 0x4372, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x4372, 0x1462, 0x0131, "MS-1013 Notebook(0x1462-0x0131)"},
{0x1002, 0x4372, 0x1462, 0x7217, "Aspire L250(0x1462-0x7217)"},
{0x1002, 0x4373, 0xFFFF, 0xFFFF, "IXP SB4x0 USB2 Host Controller(0x4373)"},
{0x1002, 0x4373, 0x1025, 0x0080, "Aspire 5024WLMMi(0x1025-0x0080)"},
{0x1002, 0x4373, 0x103C, 0x2A20, "Pavilion t3030.de Desktop PC(0x103C-0x2A20)"},
{0x1002, 0x4373, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x4373, 0x1462, 0x7217, "Aspire L250(0x1462-0x7217)"},
{0x1002, 0x4374, 0xFFFF, 0xFFFF, "IXP SB4x0 USB Host Controller(0x4374)"},
{0x1002, 0x4374, 0x103C, 0x2A20, "Pavilion t3030.de Desktop PC(0x103C-0x2A20)"},
{0x1002, 0x4374, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x4374, 0x1462, 0x7217, "Aspire L250(0x1462-0x7217)"},
{0x1002, 0x4375, 0xFFFF, 0xFFFF, "IXP SB4x0 USB Host Controller(0x4375)"},
{0x1002, 0x4375, 0x1025, 0x0080, "Aspire 5024WLMMi(0x1025-0x0080)"},
{0x1002, 0x4375, 0x103C, 0x2A20, "Pavilion t3030.de Desktop PC(0x103C-0x2A20)"},
{0x1002, 0x4375, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x4375, 0x1462, 0x7217, "Aspire L250(0x1462-0x7217)"},
{0x1002, 0x4376, 0xFFFF, 0xFFFF, "IXP SB4x0 IDE Controller(0x4376)"},
{0x1002, 0x4376, 0x1025, 0x0080, "Aspire 5024WLMMi(0x1025-0x0080)"},
{0x1002, 0x4376, 0x103C, 0x2A20, "Pavilion t3030.de Desktop PC(0x103C-0x2A20)"},
{0x1002, 0x4376, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x4376, 0x1462, 0x0131, "MS-1013 Notebook(0x1462-0x0131)"},
{0x1002, 0x4376, 0x1462, 0x7217, "Aspire L250(0x1462-0x7217)"},
{0x1002, 0x4377, 0xFFFF, 0xFFFF, "IXP SB4x0 PCI-ISA Bridge(0x4377)"},
{0x1002, 0x4377, 0x1025, 0x0080, "Aspire 5024WLMi(0x1025-0x0080)"},
{0x1002, 0x4377, 0x103C, 0x2A20, "Pavilion t3030.de Desktop PC(0x103C-0x2A20)"},
{0x1002, 0x4377, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x4377, 0x1462, 0x7217, "Aspire L250(0x1462-0x7217)"},
{0x1002, 0x4378, 0xFFFF, 0xFFFF, "IXP SB400 AC'97 Modem Controller(0x4378)"},
{0x1002, 0x4378, 0x1025, 0x0080, "Aspire 5024WLMMi(0x1025-0x0080)"},
{0x1002, 0x4378, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x4378, 0x1462, 0x0131, "MS-1013 Notebook(0x1462-0x0131)"},
{0x1002, 0x4379, 0xFFFF, 0xFFFF, "IXP SB4x0 Serial ATA Controller(0x4379)"},
{0x1002, 0x4379, 0x1462, 0x7141, "Aspire L250(0x1462-0x7141)"},
{0x1002, 0x437A, 0xFFFF, 0xFFFF, "IXP SB400 Serial ATA Controller(0x437A)"},
{0x1002, 0x437A, 0x1002, 0x4379, "4379 Serial ATA Controller(0x1002-0x4379)"},
{0x1002, 0x437A, 0x1002, 0x437A, "437A Serial ATA Controller(0x1002-0x437A)"},
{0x1002, 0x437A, 0x1462, 0x7141, "Aspire L250(0x1462-0x7141)"},
{0x1002, 0x437A, 0x14F1, 0x8800, "Leadtek WinFast TV2000XP Expert(0x14F1-0x8800)"},
{0x1002, 0x437B, 0xFFFF, 0xFFFF, "IXP SB4x0 High Definition Audio Controller(0x437B)"},
{0x1002, 0x437B, 0x1002, 0x437B, "IXP SB4x0 High Definition Audio Controller(0x1002-0x437B)"},
{0x1002, 0x437B, 0x10CF, 0x1326, "Fujitsu Lifebook A3040(0x10CF-0x1326)"},
{0x1002, 0x437B, 0x1734, 0x10B8, "Realtek High Definition Audio(0x1734-0x10B8)"},
{0x1002, 0x4380, 0xFFFF, 0xFFFF, "SB600 Non-Raid-5 SATA(0x4380)"},
{0x1002, 0x4380, 0x103C, 0x2813, "DC5750 Microtower(0x103C-0x2813)"},
{0x1002, 0x4380, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x4380, 0x1458, 0xB003, "GA-MA790FX-DS5 (rev. 1.0)(0x1458-0xB003)"},
{0x1002, 0x4380, 0x1458, 0xB005, "Gigabyte GA-MA69G-S3H Motherboard(0x1458-0xB005)"},
{0x1002, 0x4380, 0x1462, 0x7327, "K9AG Neo2(0x1462-0x7327)"},
{0x1002, 0x4380, 0x17F2, 0x5999, "KI690-AM2 Motherboard(0x17F2-0x5999)"},
{0x1002, 0x4381, 0xFFFF, 0xFFFF, "SB600 SATA Controller (RAID 5 mode)(0x4381)"},
{0x1002, 0x4382, 0xFFFF, 0xFFFF, "SB600 AC97 Audio(0x4382)"},
{0x1002, 0x4383, 0xFFFF, 0xFFFF, "SBx00 Azalia (Intel HDA)(0x4383)"},
{0x1002, 0x4383, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1002, 0x4383, 0x103C, 0x1611, "Pavilion dm1z-3000(0x103C-0x1611)"},
{0x1002, 0x4383, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x4383, 0x1043, 0x8230, "M3A78-EH Motherboard(0x1043-0x8230)"},
{0x1002, 0x4383, 0x1043, 0x836C, "M4A785TD Motherboard(0x1043-0x836C)"},
{0x1002, 0x4383, 0x1043, 0x8410, "M4A89GTD PRO/USB3 Motherboard(0x1043-0x8410)"},
{0x1002, 0x4383, 0x1043, 0x841B, "M5A88-V EVO(0x1043-0x841B)"},
{0x1002, 0x4383, 0x1043, 0x8445, "M5A78L LE(0x1043-0x8445)"},
{0x1002, 0x4383, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x4383, 0x1179, 0xFF1E, "Satellite C660D-113(0x1179-0xFF1E)"},
{0x1002, 0x4383, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x4383, 0x1458, 0xA022, "GA-770/78-series motherboard(0x1458-0xA022)"},
{0x1002, 0x4383, 0x1458, 0xA102, "GA-880GMA-USB3(0x1458-0xA102)"},
{0x1002, 0x4383, 0x1462, 0x7596, "760GM-E51(MS-7596) Motherboard(0x1462-0x7596)"},
{0x1002, 0x4383, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x4384, 0xFFFF, 0xFFFF, "SBx00 PCI to PCI Bridge(0x4384)"},
{0x1002, 0x4385, 0xFFFF, 0xFFFF, "SBx00 SMBus Controller(0x4385)"},
{0x1002, 0x4385, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1002, 0x4385, 0x103C, 0x1611, "Pavilion DM1Z-3000(0x103C-0x1611)"},
{0x1002, 0x4385, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x4385, 0x1043, 0x82EF, "M3A78-EH Motherboard(0x1043-0x82EF)"},
{0x1002, 0x4385, 0x1043, 0x8389, "M4A785TD Motherboard(0x1043-0x8389)"},
{0x1002, 0x4385, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x4385, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x4385, 0x1458, 0x4385, "GA-770/78-series motherboard(0x1458-0x4385)"},
{0x1002, 0x4385, 0x1462, 0x7368, "K9AG Neo2(0x1462-0x7368)"},
{0x1002, 0x4385, 0x1462, 0x7596, "760GM-E51(MS-7596) Motherboard(0x1462-0x7596)"},
{0x1002, 0x4385, 0x15D9, 0xA811, "H8DGU(0x15D9-0xA811)"},
{0x1002, 0x4385, 0x174B, 0x1001, "PURE Fusion Mini(0x174B-0x1001)"},
{0x1002, 0x4385, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x4386, 0xFFFF, 0xFFFF, "SB600 USB Controller (EHCI)(0x4386)"},
{0x1002, 0x4386, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x4386, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x4386, 0x1462, 0x7368, "K9AG Neo2(0x1462-0x7368)"},
{0x1002, 0x4386, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x4387, 0xFFFF, 0xFFFF, "SB600 USB (OHCI0)(0x4387)"},
{0x1002, 0x4387, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x4387, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x4387, 0x1462, 0x7368, "K9AG Neo2(0x1462-0x7368)"},
{0x1002, 0x4387, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x4388, 0xFFFF, 0xFFFF, "SB600 USB (OHCI1)(0x4388)"},
{0x1002, 0x4388, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x4388, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x4388, 0x1462, 0x7368, "K9AG Neo2(0x1462-0x7368)"},
{0x1002, 0x4388, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x4389, 0xFFFF, 0xFFFF, "SB600 USB (OHCI2)(0x4389)"},
{0x1002, 0x4389, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x4389, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x4389, 0x1462, 0x7368, "K9AG Neo2(0x1462-0x7368)"},
{0x1002, 0x4389, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x438A, 0xFFFF, 0xFFFF, "SB600 USB (OHCI3)(0x438A)"},
{0x1002, 0x438A, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x438A, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x438A, 0x1462, 0x7368, "K9AG Neo2(0x1462-0x7368)"},
{0x1002, 0x438A, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x438B, 0xFFFF, 0xFFFF, "SB600 USB (OHCI4)(0x438B)"},
{0x1002, 0x438B, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x438B, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x438B, 0x1462, 0x7368, "K9AG Neo2(0x1462-0x7368)"},
{0x1002, 0x438B, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x438C, 0xFFFF, 0xFFFF, "SB600 IDE(0x438C)"},
{0x1002, 0x438C, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x438C, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x438C, 0x1458, 0x5002, "Gigabyte GA-MA69G-S3H Motherboard(0x1458-0x5002)"},
{0x1002, 0x438C, 0x1462, 0x7368, "K9AG Neo2(0x1462-0x7368)"},
{0x1002, 0x438C, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x438D, 0xFFFF, 0xFFFF, "SB600 PCI to LPC Bridge(0x438D)"},
{0x1002, 0x438D, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x438D, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x438D, 0x1462, 0x7368, "K9AG Neo2(0x1462-0x7368)"},
{0x1002, 0x438D, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x438E, 0xFFFF, 0xFFFF, "SB600 AC97 Modem(0x438E)"},
{0x1002, 0x4390, 0xFFFF, 0xFFFF, "SB7x0/SB8x0/SB9x0 SATA Controller [IDE mode](0x4390)"},
{0x1002, 0x4390, 0x1043, 0x82EF, "M3A78-EH Motherboard(0x1043-0x82EF)"},
{0x1002, 0x4390, 0x1043, 0x8389, "M4A785TD Motherboard(0x1043-0x8389)"},
{0x1002, 0x4390, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x4390, 0x1458, 0xB002, "GA-MA770-DS3rev2.0 Motherboard(0x1458-0xB002)"},
{0x1002, 0x4390, 0x1462, 0x7596, "760GM-E51(MS-7596) Motherboard(0x1462-0x7596)"},
{0x1002, 0x4390, 0x1849, 0x4390, "Motherboard (one of many)(0x1849-0x4390)"},
{0x1002, 0x4391, 0xFFFF, 0xFFFF, "SB7x0/SB8x0/SB9x0 SATA Controller [AHCI mode](0x4391)"},
{0x1002, 0x4391, 0x103C, 0x1609, "ProLiant MicroServer N36L(0x103C-0x1609)"},
{0x1002, 0x4391, 0x103C, 0x1611, "Pavilion DM1Z-3000(0x103C-0x1611)"},
{0x1002, 0x4391, 0x1043, 0x82EF, "M3A78-EH Motherboard(0x1043-0x82EF)"},
{0x1002, 0x4391, 0x1043, 0x8443, "M5A88-V EVO(0x1043-0x8443)"},
{0x1002, 0x4391, 0x1043, 0x84DD, "M5A99X EVO (R1.0) SB950(0x1043-0x84DD)"},
{0x1002, 0x4391, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x4391, 0x1458, 0xB002, "GA-78/880-series motherboard(0x1458-0xB002)"},
{0x1002, 0x4391, 0x174B, 0x1001, "PURE Fusion Mini(0x174B-0x1001)"},
{0x1002, 0x4392, 0xFFFF, 0xFFFF, "SB7x0/SB8x0/SB9x0 SATA Controller [Non-RAID5 mode](0x4392)"},
{0x1002, 0x4392, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x4393, 0xFFFF, 0xFFFF, "SB7x0/SB8x0/SB9x0 SATA Controller [RAID5 mode](0x4393)"},
{0x1002, 0x4394, 0xFFFF, 0xFFFF, "SB7x0/SB8x0/SB9x0 SATA Controller [AHCI mode](0x4394)"},
{0x1002, 0x4395, 0xFFFF, 0xFFFF, "SB8x0/SB9x0 SATA Controller [Storage mode](0x4395)"},
{0x1002, 0x4396, 0xFFFF, 0xFFFF, "SB7x0/SB8x0/SB9x0 USB EHCI Controller(0x4396)"},
{0x1002, 0x4396, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1002, 0x4396, 0x103C, 0x1609, "ProLiant MicroServer N36L(0x103C-0x1609)"},
{0x1002, 0x4396, 0x103C, 0x1611, "Pavilion DM1Z-3000(0x103C-0x1611)"},
{0x1002, 0x4396, 0x1043, 0x82EF, "M3A78-EH Motherboard(0x1043-0x82EF)"},
{0x1002, 0x4396, 0x1043, 0x8443, "M5A88-V EVO(0x1043-0x8443)"},
{0x1002, 0x4396, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x4396, 0x1458, 0x5004, "GA-78/880-series motherboard(0x1458-0x5004)"},
{0x1002, 0x4396, 0x1462, 0x7596, "760GM-E51(MS-7596) Motherboard(0x1462-0x7596)"},
{0x1002, 0x4396, 0x15D9, 0xA811, "H8DGU(0x15D9-0xA811)"},
{0x1002, 0x4396, 0x174B, 0x1001, "PURE Fusion Mini(0x174B-0x1001)"},
{0x1002, 0x4397, 0xFFFF, 0xFFFF, "SB7x0/SB8x0/SB9x0 USB OHCI0 Controller(0x4397)"},
{0x1002, 0x4397, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1002, 0x4397, 0x103C, 0x1609, "ProLiant MicroServer N36L(0x103C-0x1609)"},
{0x1002, 0x4397, 0x103C, 0x1611, "Pavilion DM1Z-3000(0x103C-0x1611)"},
{0x1002, 0x4397, 0x1043, 0x82EF, "M3A78-EH Motherboard(0x1043-0x82EF)"},
{0x1002, 0x4397, 0x1043, 0x8443, "M5A88-V EVO(0x1043-0x8443)"},
{0x1002, 0x4397, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x4397, 0x1458, 0x5004, "GA-78/880-series motherboard(0x1458-0x5004)"},
{0x1002, 0x4397, 0x1462, 0x7596, "760GM-E51(MS-7596) Motherboard(0x1462-0x7596)"},
{0x1002, 0x4397, 0x15D9, 0xA811, "H8DGU(0x15D9-0xA811)"},
{0x1002, 0x4397, 0x174B, 0x1001, "PURE Fusion Mini(0x174B-0x1001)"},
{0x1002, 0x4398, 0xFFFF, 0xFFFF, "SB7x0 USB OHCI1 Controller(0x4398)"},
{0x1002, 0x4398, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1002, 0x4398, 0x1043, 0x82EF, "M3A78-EH Motherboard(0x1043-0x82EF)"},
{0x1002, 0x4398, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x4398, 0x1458, 0x5004, "GA-MA78GM-S2H motherboard(0x1458-0x5004)"},
{0x1002, 0x4398, 0x1462, 0x7596, "760GM-E51(MS-7596) Motherboard(0x1462-0x7596)"},
{0x1002, 0x4398, 0x15D9, 0xA811, "H8DGU(0x15D9-0xA811)"},
{0x1002, 0x4399, 0xFFFF, 0xFFFF, "SB7x0/SB8x0/SB9x0 USB OHCI2 Controller(0x4399)"},
{0x1002, 0x4399, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1002, 0x4399, 0x1043, 0x82EF, "M3A78-EH Motherboard(0x1043-0x82EF)"},
{0x1002, 0x4399, 0x1043, 0x8443, "M5A88-V EVO(0x1043-0x8443)"},
{0x1002, 0x4399, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x4399, 0x1458, 0x5004, "GA-78/880-series motherboard(0x1458-0x5004)"},
{0x1002, 0x4399, 0x1462, 0x7596, "760GM-E51(MS-7596) Motherboard(0x1462-0x7596)"},
{0x1002, 0x4399, 0x174B, 0x1001, "PURE Fusion Mini(0x174B-0x1001)"},
{0x1002, 0x439C, 0xFFFF, 0xFFFF, "SB7x0/SB8x0/SB9x0 IDE Controller(0x439C)"},
{0x1002, 0x439C, 0x1002, 0x4392, "MSI MS-7713 motherboard(0x1002-0x4392)"},
{0x1002, 0x439C, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1002, 0x439C, 0x103C, 0x1609, "ProLiant MicroServer N36L(0x103C-0x1609)"},
{0x1002, 0x439C, 0x1043, 0x82EF, "M3A78-EH Motherboard(0x1043-0x82EF)"},
{0x1002, 0x439C, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x439C, 0x1458, 0x5002, "GA-MA78GM-S2H motherboard(0x1458-0x5002)"},
{0x1002, 0x439C, 0x1462, 0x7596, "760GM-E51(MS-7596) Motherboard(0x1462-0x7596)"},
{0x1002, 0x439D, 0xFFFF, 0xFFFF, "SB7x0/SB8x0/SB9x0 LPC host controller(0x439D)"},
{0x1002, 0x439D, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1002, 0x439D, 0x103C, 0x1609, "ProLiant MicroServer N36L(0x103C-0x1609)"},
{0x1002, 0x439D, 0x103C, 0x1611, "Pavilion DM1Z-3000(0x103C-0x1611)"},
{0x1002, 0x439D, 0x1043, 0x82EF, "M3A78-EH Motherboard(0x1043-0x82EF)"},
{0x1002, 0x439D, 0x1043, 0x8443, "M5A88-V EVO(0x1043-0x8443)"},
{0x1002, 0x439D, 0x105B, 0x0E13, "N15235/A74MX mainboard / AMD SB700(0x105B-0x0E13)"},
{0x1002, 0x439D, 0x1462, 0x7596, "760GM-E51(MS-7596) Motherboard(0x1462-0x7596)"},
{0x1002, 0x439D, 0x174B, 0x1001, "PURE Fusion Mini(0x174B-0x1001)"},
{0x1002, 0x43A0, 0xFFFF, 0xFFFF, "SB700/SB800/SB900 PCI to PCI bridge (PCIE port 0)(0x43A0)"},
{0x1002, 0x43A1, 0xFFFF, 0xFFFF, "SB700/SB800/SB900 PCI to PCI bridge (PCIE port 1)(0x43A1)"},
{0x1002, 0x43A2, 0xFFFF, 0xFFFF, "SB900 PCI to PCI bridge (PCIE port 2)(0x43A2)"},
{0x1002, 0x43A3, 0xFFFF, 0xFFFF, "SB900 PCI to PCI bridge (PCIE port 3)(0x43A3)"},
{0x1002, 0x4437, 0xFFFF, 0xFFFF, "RS250 [Mobility Radeon 7000 IGP](0x4437)"},
{0x1002, 0x4554, 0xFFFF, 0xFFFF, "210888ET [Mach64 ET](0x4554)"},
{0x1002, 0x4630, 0xFFFF, 0xFFFF, "XENOS Parent Die (XBOX 360)(0x4630)"},
{0x1002, 0x4631, 0xFFFF, 0xFFFF, "XENOS Daughter Die (XBOX 360)(0x4631)"},
{0x1002, 0x4654, 0xFFFF, 0xFFFF, "Mach64 VT(0x4654)"},
{0x1002, 0x4742, 0xFFFF, 0xFFFF, "Rage 3 [3D Rage PRO AGP 2X](0x4742)"},
{0x1002, 0x4742, 0x1002, 0x0040, "Rage Pro Turbo AGP 2X(0x1002-0x0040)"},
{0x1002, 0x4742, 0x1002, 0x0044, "Rage Pro Turbo AGP 2X(0x1002-0x0044)"},
{0x1002, 0x4742, 0x1002, 0x0061, "Rage Pro AIW AGP 2X(0x1002-0x0061)"},
{0x1002, 0x4742, 0x1002, 0x0062, "Rage Pro AIW AGP 2X(0x1002-0x0062)"},
{0x1002, 0x4742, 0x1002, 0x0063, "Rage Pro AIW AGP 2X(0x1002-0x0063)"},
{0x1002, 0x4742, 0x1002, 0x0080, "Rage Pro Turbo AGP 2X(0x1002-0x0080)"},
{0x1002, 0x4742, 0x1002, 0x0084, "Rage Pro Turbo AGP 2X(0x1002-0x0084)"},
{0x1002, 0x4742, 0x1002, 0x4742, "Rage Pro Turbo AGP 2X(0x1002-0x4742)"},
{0x1002, 0x4742, 0x1002, 0x8001, "Rage Pro Turbo AGP 2X(0x1002-0x8001)"},
{0x1002, 0x4742, 0x1028, 0x0082, "Rage Pro Turbo AGP 2X(0x1028-0x0082)"},
{0x1002, 0x4742, 0x1028, 0x4082, "Optiplex GX1 Onboard Display Adapter(0x1028-0x4082)"},
{0x1002, 0x4742, 0x1028, 0x8082, "Rage Pro Turbo AGP 2X(0x1028-0x8082)"},
{0x1002, 0x4742, 0x1028, 0xC082, "Rage Pro Turbo AGP 2X(0x1028-0xC082)"},
{0x1002, 0x4742, 0x8086, 0x4152, "Xpert 98D AGP 2X(0x8086-0x4152)"},
{0x1002, 0x4742, 0x8086, 0x464A, "Rage Pro Turbo AGP 2X(0x8086-0x464A)"},
{0x1002, 0x4744, 0xFFFF, 0xFFFF, "Rage 3 [3D Rage PRO AGP 1X](0x4744)"},
{0x1002, 0x4744, 0x1002, 0x4744, "Rage Pro Turbo AGP(0x1002-0x4744)"},
{0x1002, 0x4744, 0x8086, 0x4D55, "Rage 3D Pro AGP 1X [Intel MU440EX](0x8086-0x4D55)"},
{0x1002, 0x4749, 0xFFFF, 0xFFFF, "3D Rage PRO PCI(0x4749)"},
{0x1002, 0x4749, 0x1002, 0x0061, "Rage Pro AIW(0x1002-0x0061)"},
{0x1002, 0x4749, 0x1002, 0x0062, "Rage Pro AIW(0x1002-0x0062)"},
{0x1002, 0x474D, 0xFFFF, 0xFFFF, "Rage XL AGP 2X(0x474D)"},
{0x1002, 0x474D, 0x1002, 0x0004, "Xpert 98 RXL AGP 2X(0x1002-0x0004)"},
{0x1002, 0x474D, 0x1002, 0x0008, "Xpert 98 RXL AGP 2X(0x1002-0x0008)"},
{0x1002, 0x474D, 0x1002, 0x0080, "Rage XL AGP 2X(0x1002-0x0080)"},
{0x1002, 0x474D, 0x1002, 0x0084, "Xpert 98 AGP 2X(0x1002-0x0084)"},
{0x1002, 0x474D, 0x1002, 0x474D, "Rage XL AGP(0x1002-0x474D)"},
{0x1002, 0x474D, 0x1033, 0x806A, "Rage XL AGP(0x1033-0x806A)"},
{0x1002, 0x474E, 0xFFFF, 0xFFFF, "Rage XC AGP(0x474E)"},
{0x1002, 0x474E, 0x1002, 0x474E, "Rage XC AGP(0x1002-0x474E)"},
{0x1002, 0x474F, 0xFFFF, 0xFFFF, "Rage XL(0x474F)"},
{0x1002, 0x474F, 0x1002, 0x0008, "Rage XL(0x1002-0x0008)"},
{0x1002, 0x474F, 0x1002, 0x474F, "Rage XL(0x1002-0x474F)"},
{0x1002, 0x4750, 0xFFFF, 0xFFFF, "3D Rage Pro PCI(0x4750)"},
{0x1002, 0x4750, 0x1002, 0x0040, "Rage Pro Turbo(0x1002-0x0040)"},
{0x1002, 0x4750, 0x1002, 0x0044, "Rage Pro Turbo(0x1002-0x0044)"},
{0x1002, 0x4750, 0x1002, 0x0080, "Rage Pro Turbo(0x1002-0x0080)"},
{0x1002, 0x4750, 0x1002, 0x0084, "Rage Pro Turbo(0x1002-0x0084)"},
{0x1002, 0x4750, 0x1002, 0x4750, "Rage Pro Turbo(0x1002-0x4750)"},
{0x1002, 0x4752, 0xFFFF, 0xFFFF, "Rage 3 [Rage XL PCI](0x4752)"},
{0x1002, 0x4752, 0x0E11, 0x001E, "Proliant Rage XL(0x0E11-0x001E)"},
{0x1002, 0x4752, 0x1002, 0x0008, "Rage XL(0x1002-0x0008)"},
{0x1002, 0x4752, 0x1002, 0x4752, "Proliant Rage XL(0x1002-0x4752)"},
{0x1002, 0x4752, 0x1002, 0x8008, "Rage XL(0x1002-0x8008)"},
{0x1002, 0x4752, 0x1014, 0x0240, "eServer xSeries server mainboard(0x1014-0x0240)"},
{0x1002, 0x4752, 0x1028, 0x00CE, "PowerEdge 1400(0x1028-0x00CE)"},
{0x1002, 0x4752, 0x1028, 0x00D1, "PowerEdge 2550(0x1028-0x00D1)"},
{0x1002, 0x4752, 0x1028, 0x00D9, "PowerEdge 2500(0x1028-0x00D9)"},
{0x1002, 0x4752, 0x1028, 0x0134, "PowerEdge 600SC(0x1028-0x0134)"},
{0x1002, 0x4752, 0x1028, 0x014A, "PowerEdge 1750(0x1028-0x014A)"},
{0x1002, 0x4752, 0x1028, 0x0165, "PowerEdge 750(0x1028-0x0165)"},
{0x1002, 0x4752, 0x103C, 0x10E1, "NetServer Rage XL(0x103C-0x10E1)"},
{0x1002, 0x4752, 0x103C, 0x3208, "ProLiant DL140 G2(0x103C-0x3208)"},
{0x1002, 0x4752, 0x107B, 0x6400, "6400 Server(0x107B-0x6400)"},
{0x1002, 0x4752, 0x1734, 0x007A, "PRIMERGY RX/TX series onboard VGA(0x1734-0x007A)"},
{0x1002, 0x4752, 0x1734, 0x1073, "Primergy Econel 200 D2020 mainboard(0x1734-0x1073)"},
{0x1002, 0x4752, 0x8086, 0x3411, "SDS2 Mainboard(0x8086-0x3411)"},
{0x1002, 0x4752, 0x8086, 0x3427, "S875WP1-E mainboard(0x8086-0x3427)"},
{0x1002, 0x4752, 0x8086, 0x5744, "S845WD1-E mainboard(0x8086-0x5744)"},
{0x1002, 0x4753, 0xFFFF, 0xFFFF, "Rage XC(0x4753)"},
{0x1002, 0x4753, 0x1002, 0x4753, "Rage XC(0x1002-0x4753)"},
{0x1002, 0x4754, 0xFFFF, 0xFFFF, "Mach64 GT/GT-B [3D Rage I/II](0x4754)"},
{0x1002, 0x4755, 0xFFFF, 0xFFFF, "Mach64 GT-B [3D Rage II+ DVD](0x4755)"},
{0x1002, 0x4756, 0xFFFF, 0xFFFF, "Rage 2 [3D Rage IIC PCI](0x4756)"},
{0x1002, 0x4756, 0x1002, 0x4756, "Rage IIC(0x1002-0x4756)"},
{0x1002, 0x4757, 0xFFFF, 0xFFFF, "Rage 2 [3D Rage IIC AGP](0x4757)"},
{0x1002, 0x4757, 0x1002, 0x4757, "Rage IIC AGP(0x1002-0x4757)"},
{0x1002, 0x4757, 0x1028, 0x0089, "Rage 3D IIC(0x1028-0x0089)"},
{0x1002, 0x4757, 0x1028, 0x008E, "PowerEdge 1300 onboard video(0x1028-0x008E)"},
{0x1002, 0x4757, 0x1028, 0x4082, "Rage 3D IIC(0x1028-0x4082)"},
{0x1002, 0x4757, 0x1028, 0x8082, "Rage 3D IIC(0x1028-0x8082)"},
{0x1002, 0x4757, 0x1028, 0xC082, "Rage 3D IIC(0x1028-0xC082)"},
{0x1002, 0x4758, 0xFFFF, 0xFFFF, "Mach64 GX [WinTurbo](0x4758)"},
{0x1002, 0x4759, 0xFFFF, 0xFFFF, "Rage 3 [3D Rage IIC PCI](0x4759)"},
{0x1002, 0x475A, 0xFFFF, 0xFFFF, "3D Rage IIC AGP(0x475A)"},
{0x1002, 0x475A, 0x1002, 0x0084, "Rage 3D Pro AGP 2x XPERT 98(0x1002-0x0084)"},
{0x1002, 0x475A, 0x1002, 0x0087, "Rage 3D IIC(0x1002-0x0087)"},
{0x1002, 0x475A, 0x1002, 0x475A, "Rage IIC AGP(0x1002-0x475A)"},
{0x1002, 0x4845, 0xFFFF, 0xFFFF, "Xilleon 220 HBIU for HDTV2(0x4845)"},
{0x1002, 0x4846, 0xFFFF, 0xFFFF, "Xilleon 220 IDE for HDTV2(0x4846)"},
{0x1002, 0x4847, 0xFFFF, 0xFFFF, "Xilleon 220 USB for HDTV2(0x4847)"},
{0x1002, 0x4848, 0xFFFF, 0xFFFF, "Xilleon 220 DAIO-0 for HDTV2(0x4848)"},
{0x1002, 0x4849, 0xFFFF, 0xFFFF, "Xilleon 220 DAIO-1 for HDTV2(0x4849)"},
{0x1002, 0x484A, 0xFFFF, 0xFFFF, "Xilleon 220 LPC for HDTV2(0x484A)"},
{0x1002, 0x4850, 0xFFFF, 0xFFFF, "Xilleon 215 HBIU for X215(0x4850)"},
{0x1002, 0x4851, 0xFFFF, 0xFFFF, "Xilleon 215 IDE for X215(0x4851)"},
{0x1002, 0x4852, 0xFFFF, 0xFFFF, "Xilleon 215 USB for X215(0x4852)"},
{0x1002, 0x4853, 0xFFFF, 0xFFFF, "Xilleon 215 DAIO-0 for X215(0x4853)"},
{0x1002, 0x4854, 0xFFFF, 0xFFFF, "Xilleon 215 DAIO-1 for X215(0x4854)"},
{0x1002, 0x4855, 0xFFFF, 0xFFFF, "Xilleon 225 HBIU for X225(0x4855)"},
{0x1002, 0x4856, 0xFFFF, 0xFFFF, "Xilleon 225 IDE for X225(0x4856)"},
{0x1002, 0x4857, 0xFFFF, 0xFFFF, "Xilleon 225 USB for X225(0x4857)"},
{0x1002, 0x4858, 0xFFFF, 0xFFFF, "Xilleon 225 DAIO-0 for X225(0x4858)"},
{0x1002, 0x4859, 0xFFFF, 0xFFFF, "Xilleon 225 DAIO-1 for X225(0x4859)"},
{0x1002, 0x4860, 0xFFFF, 0xFFFF, "Xilleon 210 HBIU for X210(0x4860)"},
{0x1002, 0x4861, 0xFFFF, 0xFFFF, "Xilleon 210 IDE for X210(0x4861)"},
{0x1002, 0x4862, 0xFFFF, 0xFFFF, "Xilleon 210 USB for X210(0x4862)"},
{0x1002, 0x4863, 0xFFFF, 0xFFFF, "Xilleon 210 DAIO-0 for X210(0x4863)"},
{0x1002, 0x4864, 0xFFFF, 0xFFFF, "Xilleon 210 DAIO-1 for X210(0x4864)"},
{0x1002, 0x4865, 0xFFFF, 0xFFFF, "Xilleon 226 HBIU for X226(0x4865)"},
{0x1002, 0x4866, 0xFFFF, 0xFFFF, "Xilleon 226 IDE for X226(0x4866)"},
{0x1002, 0x4867, 0xFFFF, 0xFFFF, "Xilleon 226 USB for X226(0x4867)"},
{0x1002, 0x4868, 0xFFFF, 0xFFFF, "Xilleon 226 DAIO-0 for X226(0x4868)"},
{0x1002, 0x4869, 0xFFFF, 0xFFFF, "Xilleon 226 DAIO-1 for X226(0x4869)"},
{0x1002, 0x486A, 0xFFFF, 0xFFFF, "Xilleon 240S HBIU for X240S(0x486A)"},
{0x1002, 0x486B, 0xFFFF, 0xFFFF, "Xilleon 240H HBIU for X240H(0x486B)"},
{0x1002, 0x486C, 0xFFFF, 0xFFFF, "Xilleon 240S USB for X240S(0x486C)"},
{0x1002, 0x486D, 0xFFFF, 0xFFFF, "Xilleon 240H USB for X240H(0x486D)"},
{0x1002, 0x486E, 0xFFFF, 0xFFFF, "Xilleon 250 USB 1.1 for X250(0x486E)"},
{0x1002, 0x486F, 0xFFFF, 0xFFFF, "Xilleon 260 USB 1.1 for X260(0x486F)"},
{0x1002, 0x4870, 0xFFFF, 0xFFFF, "Xilleon 250 HBIU for X250(0x4870)"},
{0x1002, 0x4871, 0xFFFF, 0xFFFF, "Xilleon 250 IDE for X250(0x4871)"},
{0x1002, 0x4872, 0xFFFF, 0xFFFF, "Xilleon 234/235 HBIU for X234/X235(0x4872)"},
{0x1002, 0x4873, 0xFFFF, 0xFFFF, "Xilleon 244/245 HBIU for X244/X245(0x4873)"},
{0x1002, 0x4874, 0xFFFF, 0xFFFF, "Xilleon 234/235 USB 1.1 for X234/X235(0x4874)"},
{0x1002, 0x4875, 0xFFFF, 0xFFFF, "Xilleon 260 HBIU for X260(0x4875)"},
{0x1002, 0x4876, 0xFFFF, 0xFFFF, "Xilleon 260 IDE for X260(0x4876)"},
{0x1002, 0x4877, 0xFFFF, 0xFFFF, "Xilleon 244/245 USB 1.1 for X244/X245(0x4877)"},
{0x1002, 0x4878, 0xFFFF, 0xFFFF, "Xilleon 270 HBIU for X270(0x4878)"},
{0x1002, 0x487B, 0xFFFF, 0xFFFF, "Xilleon 242 HBIU for X242(0x487B)"},
{0x1002, 0x487D, 0xFFFF, 0xFFFF, "Xilleon 242 USB 1.1 for X242(0x487D)"},
{0x1002, 0x4880, 0xFFFF, 0xFFFF, "Xilleon 254 HBIU for X254(0x4880)"},
{0x1002, 0x4881, 0xFFFF, 0xFFFF, "Xilleon 254 USB 1.1 for X254(0x4881)"},
{0x1002, 0x4882, 0xFFFF, 0xFFFF, "Xilleon 255 HBIU for X255(0x4882)"},
{0x1002, 0x4883, 0xFFFF, 0xFFFF, "Xilleon 255 USB 1.1 for X255(0x4883)"},
{0x1002, 0x4884, 0xFFFF, 0xFFFF, "Xilleon 243 HBIU for X243(0x4884)"},
{0x1002, 0x4885, 0xFFFF, 0xFFFF, "Xilleon 243 USB 1.1 for X243(0x4885)"},
{0x1002, 0x4886, 0xFFFF, 0xFFFF, "Xilleon 233 HBIU for X233(0x4886)"},
{0x1002, 0x4887, 0xFFFF, 0xFFFF, "Xilleon 233 USB 1.1 for X233(0x4887)"},
{0x1002, 0x4888, 0xFFFF, 0xFFFF, "Xilleon 143 HBIU for X143(0x4888)"},
{0x1002, 0x4889, 0xFFFF, 0xFFFF, "Xilleon 143 HBIU for X143L(0x4889)"},
{0x1002, 0x488A, 0xFFFF, 0xFFFF, "Xilleon 143 HBIU for X143S(0x488A)"},
{0x1002, 0x4966, 0xFFFF, 0xFFFF, "RV250 [Radeon 9000 Series](0x4966)"},
{0x1002, 0x4966, 0x10F1, 0x0002, "RV250 If [Tachyon G9000 PRO](0x10F1-0x0002)"},
{0x1002, 0x4966, 0x148C, 0x2039, "RV250 If [Radeon 9000 Pro \"Evil Commando\"](0x148C-0x2039)"},
{0x1002, 0x4966, 0x1509, 0x9A00, "RV250 If [Radeon 9000 \"AT009\"](0x1509-0x9A00)"},
{0x1002, 0x4966, 0x1681, 0x0040, "RV250 If [3D prophet 9000](0x1681-0x0040)"},
{0x1002, 0x4966, 0x174B, 0x7176, "Radeon 9000 Pro(0x174B-0x7176)"},
{0x1002, 0x4966, 0x174B, 0x7192, "RV250 If [Radeon 9000 \"Atlantis\"](0x174B-0x7192)"},
{0x1002, 0x4966, 0x17AF, 0x2005, "RV250 If [Excalibur Radeon 9000 Pro](0x17AF-0x2005)"},
{0x1002, 0x4966, 0x17AF, 0x2006, "RV250 If [Excalibur Radeon 9000](0x17AF-0x2006)"},
{0x1002, 0x496E, 0xFFFF, 0xFFFF, "RV250 [Radeon 9000] (Secondary)(0x496E)"},
{0x1002, 0x4A49, 0xFFFF, 0xFFFF, "R420 [Radeon X800 PRO/GTO AGP](0x4A49)"},
{0x1002, 0x4A49, 0x174B, 0x2620, "R420 [Radeon X800 GTO AGP](0x174B-0x2620)"},
{0x1002, 0x4A4A, 0xFFFF, 0xFFFF, "R420 [Radeon X800 GT AGP](0x4A4A)"},
{0x1002, 0x4A4B, 0xFFFF, 0xFFFF, "R420 [Radeon X800 AGP Series](0x4A4B)"},
{0x1002, 0x4A4D, 0xFFFF, 0xFFFF, "R420 GL [FireGL X3-256](0x4A4D)"},
{0x1002, 0x4A4E, 0xFFFF, 0xFFFF, "RV420/M18 [Mobility Radeon 9800](0x4A4E)"},
{0x1002, 0x4A4F, 0xFFFF, 0xFFFF, "R420 [Radeon X850 AGP](0x4A4F)"},
{0x1002, 0x4A50, 0xFFFF, 0xFFFF, "R420 [Radeon X800 XT Platinum Edition AGP](0x4A50)"},
{0x1002, 0x4A54, 0xFFFF, 0xFFFF, "R420 [Radeon X800 VE AGP](0x4A54)"},
{0x1002, 0x4A54, 0x1002, 0x4422, "All-In-Wonder X800 VE AGP(0x1002-0x4422)"},
{0x1002, 0x4A69, 0xFFFF, 0xFFFF, "R420 [Radeon X800 PRO/GTO] (Secondary)(0x4A69)"},
{0x1002, 0x4A6A, 0xFFFF, 0xFFFF, "R420 [Radeon X800] (Secondary)(0x4A6A)"},
{0x1002, 0x4A6B, 0xFFFF, 0xFFFF, "R420 [Radeon X800 XT AGP] (Secondary)(0x4A6B)"},
{0x1002, 0x4A70, 0xFFFF, 0xFFFF, "R420 [Radeon X800 XT Platinum Edition AGP] (Secondary)(0x4A70)"},
{0x1002, 0x4A74, 0xFFFF, 0xFFFF, "R420 [Radeon X800 VE] (Secondary)(0x4A74)"},
{0x1002, 0x4B49, 0xFFFF, 0xFFFF, "R481 [Radeon X850 XT AGP](0x4B49)"},
{0x1002, 0x4B4B, 0xFFFF, 0xFFFF, "R481 [Radeon X850 PRO AGP](0x4B4B)"},
{0x1002, 0x4B4C, 0xFFFF, 0xFFFF, "R481 [Radeon X850 XT Platinum Edition AGP](0x4B4C)"},
{0x1002, 0x4B69, 0xFFFF, 0xFFFF, "R481 [Radeon X850 XT AGP] (Secondary)(0x4B69)"},
{0x1002, 0x4B6B, 0xFFFF, 0xFFFF, "R481 [Radeon X850 PRO AGP] (Secondary)(0x4B6B)"},
{0x1002, 0x4B6C, 0xFFFF, 0xFFFF, "R481 [Radeon X850 XT Platinum Edition AGP] (Secondary)(0x4B6C)"},
{0x1002, 0x4C42, 0xFFFF, 0xFFFF, "Mach64 LT [3D Rage LT PRO AGP](0x4C42)"},
{0x1002, 0x4C42, 0x0E11, 0xB0E7, "Rage LT Pro (Compaq Presario 5240)(0x0E11-0xB0E7)"},
{0x1002, 0x4C42, 0x0E11, 0xB0E8, "Rage 3D LT Pro(0x0E11-0xB0E8)"},
{0x1002, 0x4C42, 0x0E11, 0xB10E, "3D Rage LT Pro (Compaq Armada 1750)(0x0E11-0xB10E)"},
{0x1002, 0x4C42, 0x1002, 0x0040, "Rage LT Pro AGP 2X(0x1002-0x0040)"},
{0x1002, 0x4C42, 0x1002, 0x0044, "Rage LT Pro AGP 2X(0x1002-0x0044)"},
{0x1002, 0x4C42, 0x1002, 0x4C42, "Rage LT Pro AGP 2X(0x1002-0x4C42)"},
{0x1002, 0x4C42, 0x1002, 0x8001, "Rage LT Pro AGP 2X(0x1002-0x8001)"},
{0x1002, 0x4C42, 0x1028, 0x0085, "Rage 3D LT Pro(0x1028-0x0085)"},
{0x1002, 0x4C46, 0xFFFF, 0xFFFF, "Rage Mobility 128 AGP 2X/Mobility M3(0x4C46)"},
{0x1002, 0x4C46, 0x1002, 0x0155, "IBM Thinkpad A22p(0x1002-0x0155)"},
{0x1002, 0x4C46, 0x1014, 0x0155, "Thinkpad A22p(0x1014-0x0155)"},
{0x1002, 0x4C46, 0x1028, 0x00B1, "Latitude C600(0x1028-0x00B1)"},
{0x1002, 0x4C47, 0xFFFF, 0xFFFF, "3D Rage IIC PCI / Mobility Radeon 7500/7500C(0x4C47)"},
{0x1002, 0x4C49, 0xFFFF, 0xFFFF, "3D Rage LT PRO PCI(0x4C49)"},
{0x1002, 0x4C49, 0x1002, 0x0004, "Rage LT Pro(0x1002-0x0004)"},
{0x1002, 0x4C49, 0x1002, 0x0040, "Rage LT Pro(0x1002-0x0040)"},
{0x1002, 0x4C49, 0x1002, 0x0044, "Rage LT Pro(0x1002-0x0044)"},
{0x1002, 0x4C49, 0x1002, 0x4C49, "Rage LT Pro(0x1002-0x4C49)"},
{0x1002, 0x4C4D, 0xFFFF, 0xFFFF, "Rage Mobility AGP 2x Series(0x4C4D)"},
{0x1002, 0x4C4D, 0x0E11, 0xB111, "Armada M700(0x0E11-0xB111)"},
{0x1002, 0x4C4D, 0x0E11, 0xB160, "Armada E500(0x0E11-0xB160)"},
{0x1002, 0x4C4D, 0x1002, 0x0084, "Xpert 98 AGP 2X (Mobility)(0x1002-0x0084)"},
{0x1002, 0x4C4D, 0x1014, 0x0154, "ThinkPad A20m/A21m(0x1014-0x0154)"},
{0x1002, 0x4C4D, 0x1028, 0x00AA, "Latitude CPt(0x1028-0x00AA)"},
{0x1002, 0x4C4D, 0x1028, 0x00BB, "Latitude CPx(0x1028-0x00BB)"},
{0x1002, 0x4C4D, 0x1179, 0xFF00, "Satellite 1715XCDS laptop(0x1179-0xFF00)"},
{0x1002, 0x4C4D, 0x13BD, 0x1019, "PC-AR10(0x13BD-0x1019)"},
{0x1002, 0x4C4E, 0xFFFF, 0xFFFF, "Rage Mobility L AGP 2x(0x4C4E)"},
{0x1002, 0x4C50, 0xFFFF, 0xFFFF, "Rage 3 LT [3D Rage LT PRO PCI](0x4C50)"},
{0x1002, 0x4C50, 0x1002, 0x4C50, "Rage LT Pro(0x1002-0x4C50)"},
{0x1002, 0x4C52, 0xFFFF, 0xFFFF, "M1 [Rage Mobility-M1 PCI](0x4C52)"},
{0x1002, 0x4C52, 0x1033, 0x8112, "Versa Note VXi(0x1033-0x8112)"},
{0x1002, 0x4C54, 0xFFFF, 0xFFFF, "264LT [Mach64 LT](0x4C54)"},
{0x1002, 0x4C57, 0xFFFF, 0xFFFF, "RV200/M7 [Mobility Radeon 7500](0x4C57)"},
{0x1002, 0x4C57, 0x1014, 0x0517, "ThinkPad T30(0x1014-0x0517)"},
{0x1002, 0x4C57, 0x1014, 0x0530, "ThinkPad T4x Series(0x1014-0x0530)"},
{0x1002, 0x4C57, 0x1028, 0x00E6, "Radeon Mobility M7 LW (Dell Inspiron 8100)(0x1028-0x00E6)"},
{0x1002, 0x4C57, 0x1028, 0x012A, "Latitude C640(0x1028-0x012A)"},
{0x1002, 0x4C57, 0x1043, 0x1622, "Mobility Radeon M7 (L3C/S)(0x1043-0x1622)"},
{0x1002, 0x4C57, 0x144D, 0xC006, "Radeon Mobility M7 LW in vpr Matrix 170B4(0x144D-0xC006)"},
{0x1002, 0x4C58, 0xFFFF, 0xFFFF, "RV200/M7 GL [Mobility FireGL 7800](0x4C58)"},
{0x1002, 0x4C59, 0xFFFF, 0xFFFF, "RV100/M6 [Rage/Radeon Mobility Series](0x4C59)"},
{0x1002, 0x4C59, 0x0E11, 0xB111, "Evo N600c(0x0E11-0xB111)"},
{0x1002, 0x4C59, 0x1014, 0x0235, "ThinkPad A30/A30p (2652/2653)(0x1014-0x0235)"},
{0x1002, 0x4C59, 0x1014, 0x0239, "ThinkPad X22/X23/X24(0x1014-0x0239)"},
{0x1002, 0x4C59, 0x103C, 0x0025, "XE4500 Notebook(0x103C-0x0025)"},
{0x1002, 0x4C59, 0x104D, 0x80E7, "VAIO PCG-GR214EP/GR214MP/GR215MP/GR314MP/GR315MP(0x104D-0x80E7)"},
{0x1002, 0x4C59, 0x104D, 0x8140, "PCG-Z1SP laptop(0x104D-0x8140)"},
{0x1002, 0x4C59, 0x1509, 0x1930, "Medion MD9703(0x1509-0x1930)"},
{0x1002, 0x4C66, 0xFFFF, 0xFFFF, "RV250/M9 GL [Mobility FireGL 9000/Radeon 9000](0x4C66)"},
{0x1002, 0x4C66, 0x1014, 0x054D, "ThinkPad T41(0x1014-0x054D)"},
{0x1002, 0x4C6E, 0xFFFF, 0xFFFF, "RV250/M9 [Mobility Radeon 9000] (Secondary)(0x4C6E)"},
{0x1002, 0x4D46, 0xFFFF, 0xFFFF, "Rage Mobility 128 AGP 4X/Mobility M4(0x4D46)"},
{0x1002, 0x4D52, 0xFFFF, 0xFFFF, "Theater 550 PRO PCI [ATI TV Wonder 550](0x4D52)"},
{0x1002, 0x4D53, 0xFFFF, 0xFFFF, "Theater 550 PRO PCIe(0x4D53)"},
{0x1002, 0x4E44, 0xFFFF, 0xFFFF, "R300 [Radeon 9700/9700 PRO](0x4E44)"},
{0x1002, 0x4E44, 0x1002, 0x515E, "Radeon ES1000(0x1002-0x515E)"},
{0x1002, 0x4E44, 0x1002, 0x5965, "Radeon ES1000(0x1002-0x5965)"},
{0x1002, 0x4E45, 0xFFFF, 0xFFFF, "R300 [Radeon 9500 PRO/9700](0x4E45)"},
{0x1002, 0x4E45, 0x1002, 0x0002, "Radeon R300 NE [Radeon 9500 Pro](0x1002-0x0002)"},
{0x1002, 0x4E45, 0x1681, 0x0002, "Hercules 3D Prophet 9500 PRO [Radeon 9500 Pro](0x1681-0x0002)"},
{0x1002, 0x4E46, 0xFFFF, 0xFFFF, "R300 [Radeon 9600 TX](0x4E46)"},
{0x1002, 0x4E47, 0xFFFF, 0xFFFF, "R300 GL [FireGL X1](0x4E47)"},
{0x1002, 0x4E48, 0xFFFF, 0xFFFF, "R350 [Radeon 9800 Series](0x4E48)"},
{0x1002, 0x4E49, 0xFFFF, 0xFFFF, "R350 [Radeon 9800](0x4E49)"},
{0x1002, 0x4E4A, 0xFFFF, 0xFFFF, "R360 [Radeon 9800 XXL/XT](0x4E4A)"},
{0x1002, 0x4E4A, 0x1002, 0x4E4A, "R360 [Radeon 9800 XT](0x1002-0x4E4A)"},
{0x1002, 0x4E4B, 0xFFFF, 0xFFFF, "R350 GL [FireGL X2 AGP Pro](0x4E4B)"},
{0x1002, 0x4E50, 0xFFFF, 0xFFFF, "RV350/M10 / RV360/M11 [Mobility Radeon 9600 (PRO) / 9700](0x4E50)"},
{0x1002, 0x4E50, 0x1025, 0x005A, "TravelMate 290(0x1025-0x005A)"},
{0x1002, 0x4E50, 0x1025, 0x0064, "Extensa 3000 series laptop: ATI RV360/M11 [Mobility Radeon 9700](0x1025-0x0064)"},
{0x1002, 0x4E50, 0x103C, 0x088C, "NC8000 laptop(0x103C-0x088C)"},
{0x1002, 0x4E50, 0x103C, 0x0890, "NC6000 laptop(0x103C-0x0890)"},
{0x1002, 0x4E50, 0x144D, 0xC00C, "P35 notebook(0x144D-0xC00C)"},
{0x1002, 0x4E50, 0x1462, 0x0311, "MSI M510A(0x1462-0x0311)"},
{0x1002, 0x4E50, 0x1734, 0x1055, "Amilo M1420W(0x1734-0x1055)"},
{0x1002, 0x4E51, 0xFFFF, 0xFFFF, "RV350 [Radeon 9550/9600/X1050 Series](0x4E51)"},
{0x1002, 0x4E52, 0xFFFF, 0xFFFF, "RV350/M10 [Mobility Radeon 9500/9700 SE](0x4E52)"},
{0x1002, 0x4E52, 0x144D, 0xC00C, "P35 notebook(0x144D-0xC00C)"},
{0x1002, 0x4E54, 0xFFFF, 0xFFFF, "RV350/M10 GL [Mobility FireGL T2](0x4E54)"},
{0x1002, 0x4E56, 0xFFFF, 0xFFFF, "RV360/M12 [Mobility Radeon 9550](0x4E56)"},
{0x1002, 0x4E64, 0xFFFF, 0xFFFF, "R300 [Radeon 9700 PRO] (Secondary)(0x4E64)"},
{0x1002, 0x4E65, 0xFFFF, 0xFFFF, "R300 [Radeon 9500 PRO] (Secondary)(0x4E65)"},
{0x1002, 0x4E65, 0x1002, 0x0003, "Radeon R300 NE [Radeon 9500 Pro](0x1002-0x0003)"},
{0x1002, 0x4E65, 0x1681, 0x0003, "Hercules 3D Prophet 9500 PRO [Radeon 9500 Pro] (Secondary)(0x1681-0x0003)"},
{0x1002, 0x4E66, 0xFFFF, 0xFFFF, "RV350 [Radeon 9600] (Secondary)(0x4E66)"},
{0x1002, 0x4E67, 0xFFFF, 0xFFFF, "R300 GL [FireGL X1] (Secondary)(0x4E67)"},
{0x1002, 0x4E68, 0xFFFF, 0xFFFF, "R350 [Radeon 9800 PRO] (Secondary)(0x4E68)"},
{0x1002, 0x4E69, 0xFFFF, 0xFFFF, "R350 [Radeon 9800] (Secondary)(0x4E69)"},
{0x1002, 0x4E6A, 0xFFFF, 0xFFFF, "RV350 [Radeon 9800 XT] (Secondary)(0x4E6A)"},
{0x1002, 0x4E6A, 0x1002, 0x4E6A, "R360 [Radeon 9800 XT] (Secondary)(0x1002-0x4E6A)"},
{0x1002, 0x4E6A, 0x1002, 0x4E71, "M10 NQ [Radeon Mobility 9600](0x1002-0x4E71)"},
{0x1002, 0x4E71, 0xFFFF, 0xFFFF, "RV350/M10 [Mobility Radeon 9600] (Secondary)(0x4E71)"},
{0x1002, 0x4F72, 0xFFFF, 0xFFFF, "RV250 [Radeon 9000 Series](0x4F72)"},
{0x1002, 0x4F73, 0xFFFF, 0xFFFF, "RV250 [Radeon 9000 Series] (Secondary)(0x4F73)"},
{0x1002, 0x5044, 0xFFFF, 0xFFFF, "All-In-Wonder 128 PCI(0x5044)"},
{0x1002, 0x5044, 0x1002, 0x0028, "Rage 128 AIW(0x1002-0x0028)"},
{0x1002, 0x5044, 0x1002, 0x0029, "Rage 128 AIW(0x1002-0x0029)"},
{0x1002, 0x5046, 0xFFFF, 0xFFFF, "Rage 4 [Rage 128 PRO AGP 4X](0x5046)"},
{0x1002, 0x5046, 0x1002, 0x0004, "Rage Fury Pro(0x1002-0x0004)"},
{0x1002, 0x5046, 0x1002, 0x0008, "Rage Fury Pro/Xpert 2000 Pro(0x1002-0x0008)"},
{0x1002, 0x5046, 0x1002, 0x0014, "Rage Fury Pro(0x1002-0x0014)"},
{0x1002, 0x5046, 0x1002, 0x0018, "Rage Fury Pro/Xpert 2000 Pro(0x1002-0x0018)"},
{0x1002, 0x5046, 0x1002, 0x0028, "Rage 128 Pro AIW AGP(0x1002-0x0028)"},
{0x1002, 0x5046, 0x1002, 0x002A, "Rage 128 Pro AIW AGP(0x1002-0x002A)"},
{0x1002, 0x5046, 0x1002, 0x0048, "Rage Fury Pro(0x1002-0x0048)"},
{0x1002, 0x5046, 0x1002, 0x2000, "Rage Fury MAXX AGP 4x (TMDS) (VGA device)(0x1002-0x2000)"},
{0x1002, 0x5046, 0x1002, 0x2001, "Rage Fury MAXX AGP 4x (TMDS) (Extra device?-!)(0x1002-0x2001)"},
{0x1002, 0x5050, 0xFFFF, 0xFFFF, "Rage 4 [Rage 128 PRO PCI / Xpert 128 PCI](0x5050)"},
{0x1002, 0x5050, 0x1002, 0x0008, "Xpert 128(0x1002-0x0008)"},
{0x1002, 0x5052, 0xFFFF, 0xFFFF, "Rage 4 [Rage 128 PRO AGP 4X](0x5052)"},
{0x1002, 0x5144, 0xFFFF, 0xFFFF, "R100 [Radeon 7200 / All-In-Wonder Radeon](0x5144)"},
{0x1002, 0x5144, 0x1002, 0x0008, "Radeon 7000/Radeon VE(0x1002-0x0008)"},
{0x1002, 0x5144, 0x1002, 0x0009, "Radeon 7000/Radeon(0x1002-0x0009)"},
{0x1002, 0x5144, 0x1002, 0x000A, "Radeon 7000/Radeon(0x1002-0x000A)"},
{0x1002, 0x5144, 0x1002, 0x001A, "Radeon 7000/Radeon(0x1002-0x001A)"},
{0x1002, 0x5144, 0x1002, 0x0029, "Radeon AIW(0x1002-0x0029)"},
{0x1002, 0x5144, 0x1002, 0x0038, "Radeon 7000/Radeon(0x1002-0x0038)"},
{0x1002, 0x5144, 0x1002, 0x0039, "Radeon 7000/Radeon(0x1002-0x0039)"},
{0x1002, 0x5144, 0x1002, 0x008A, "Radeon 7000/Radeon(0x1002-0x008A)"},
{0x1002, 0x5144, 0x1002, 0x00BA, "Radeon 7000/Radeon(0x1002-0x00BA)"},
{0x1002, 0x5144, 0x1002, 0x0139, "Radeon 7000/Radeon(0x1002-0x0139)"},
{0x1002, 0x5144, 0x1002, 0x028A, "Radeon 7000/Radeon(0x1002-0x028A)"},
{0x1002, 0x5144, 0x1002, 0x02AA, "Radeon AIW(0x1002-0x02AA)"},
{0x1002, 0x5144, 0x1002, 0x053A, "Radeon 7000/Radeon(0x1002-0x053A)"},
{0x1002, 0x5148, 0xFFFF, 0xFFFF, "R200 GL [FireGL 8800](0x5148)"},
{0x1002, 0x5148, 0x1002, 0x010A, "FireGL 8800 64Mb(0x1002-0x010A)"},
{0x1002, 0x5148, 0x1002, 0x0152, "FireGL 8800 128Mb(0x1002-0x0152)"},
{0x1002, 0x5148, 0x1002, 0x0162, "FireGL 8700 32Mb(0x1002-0x0162)"},
{0x1002, 0x5148, 0x1002, 0x0172, "FireGL 8700 64Mb(0x1002-0x0172)"},
{0x1002, 0x514C, 0xFFFF, 0xFFFF, "R200 [Radeon 8500/8500 LE](0x514C)"},
{0x1002, 0x514C, 0x1002, 0x003A, "Radeon R200 QL [Radeon 8500 LE](0x1002-0x003A)"},
{0x1002, 0x514C, 0x1002, 0x013A, "Radeon 8500(0x1002-0x013A)"},
{0x1002, 0x514C, 0x148C, 0x2026, "R200 QL [Radeon 8500 Evil Master II Multi Display Edition](0x148C-0x2026)"},
{0x1002, 0x514C, 0x1681, 0x0010, "Radeon 8500 [3D Prophet 8500 128Mb](0x1681-0x0010)"},
{0x1002, 0x514C, 0x174B, 0x7149, "Radeon 8500 LE(0x174B-0x7149)"},
{0x1002, 0x514C, 0x1787, 0x0F08, "Radeon R200 QL [PowerMagic Radeon 8500](0x1787-0x0F08)"},
{0x1002, 0x514D, 0xFFFF, 0xFFFF, "R200 [Radeon 9100](0x514D)"},
{0x1002, 0x5157, 0xFFFF, 0xFFFF, "RV200 [Radeon 7500/7500 LE](0x5157)"},
{0x1002, 0x5157, 0x1002, 0x013A, "Radeon 7500(0x1002-0x013A)"},
{0x1002, 0x5157, 0x1002, 0x0F2B, "ALL-IN-WONDER VE PCI(0x1002-0x0F2B)"},
{0x1002, 0x5157, 0x1002, 0x103A, "Dell Optiplex GX260(0x1002-0x103A)"},
{0x1002, 0x5157, 0x1458, 0x4000, "RV200 QW [RADEON 7500 PRO MAYA AR](0x1458-0x4000)"},
{0x1002, 0x5157, 0x148C, 0x2024, "RV200 QW [Radeon 7500LE Dual Display](0x148C-0x2024)"},
{0x1002, 0x5157, 0x148C, 0x2025, "RV200 QW [Radeon 7500 Evil Master Multi Display Edition](0x148C-0x2025)"},
{0x1002, 0x5157, 0x148C, 0x2036, "RV200 QW [Radeon 7500 PCI Dual Display](0x148C-0x2036)"},
{0x1002, 0x5157, 0x174B, 0x7146, "RV200 QW [Radeon 7500 LE](0x174B-0x7146)"},
{0x1002, 0x5157, 0x174B, 0x7147, "Radeon 7500 LE(0x174B-0x7147)"},
{0x1002, 0x5157, 0x174B, 0x7161, "Radeon RV200 QW [Radeon 7500 LE](0x174B-0x7161)"},
{0x1002, 0x5157, 0x17AF, 0x0202, "RV200 QW [Excalibur Radeon 7500LE](0x17AF-0x0202)"},
{0x1002, 0x5159, 0xFFFF, 0xFFFF, "RV100 [Radeon 7000 / Radeon VE](0x5159)"},
{0x1002, 0x5159, 0x1002, 0x000A, "Radeon 7000/Radeon VE(0x1002-0x000A)"},
{0x1002, 0x5159, 0x1002, 0x000B, "Radeon 7000(0x1002-0x000B)"},
{0x1002, 0x5159, 0x1002, 0x0038, "Radeon 7000/Radeon VE(0x1002-0x0038)"},
{0x1002, 0x5159, 0x1002, 0x003A, "Radeon 7000/Radeon VE(0x1002-0x003A)"},
{0x1002, 0x5159, 0x1002, 0x00BA, "Radeon 7000/Radeon VE(0x1002-0x00BA)"},
{0x1002, 0x5159, 0x1002, 0x013A, "Radeon 7000/Radeon VE(0x1002-0x013A)"},
{0x1002, 0x5159, 0x1002, 0x0908, "XVR-100 (supplied by Sun)(0x1002-0x0908)"},
{0x1002, 0x5159, 0x1014, 0x029A, "Remote Supervisor Adapter II (RSA2)(0x1014-0x029A)"},
{0x1002, 0x5159, 0x1014, 0x02C8, "eServer xSeries server mainboard(0x1014-0x02C8)"},
{0x1002, 0x5159, 0x1028, 0x016C, "PowerEdge 1850 Embedded Radeon 7000/VE(0x1028-0x016C)"},
{0x1002, 0x5159, 0x1028, 0x016D, "PowerEdge 2850 Embedded Radeon 7000-M(0x1028-0x016D)"},
{0x1002, 0x5159, 0x1028, 0x0170, "PowerEdge 6850 Embedded Radeon 7000/VE(0x1028-0x0170)"},
{0x1002, 0x5159, 0x1028, 0x019A, "PowerEdge SC1425(0x1028-0x019A)"},
{0x1002, 0x5159, 0x103C, 0x1292, "Radeon 7000(0x103C-0x1292)"},
{0x1002, 0x5159, 0x1043, 0xC00A, "A7000/T/64M(0x1043-0xC00A)"},
{0x1002, 0x5159, 0x1458, 0x4002, "RV100 QY [RADEON 7000 PRO MAYA AV Series](0x1458-0x4002)"},
{0x1002, 0x5159, 0x148C, 0x2003, "RV100 QY [Radeon 7000 Multi-Display Edition](0x148C-0x2003)"},
{0x1002, 0x5159, 0x148C, 0x2023, "RV100 QY [Radeon 7000 Evil Master Multi-Display](0x148C-0x2023)"},
{0x1002, 0x5159, 0x148C, 0x2081, "RV6DE(0x148C-0x2081)"},
{0x1002, 0x5159, 0x174B, 0x0280, "Radeon RV100 QY [Radeon 7000/VE](0x174B-0x0280)"},
{0x1002, 0x5159, 0x174B, 0x7112, "Radeon VE 7000(0x174B-0x7112)"},
{0x1002, 0x5159, 0x174B, 0x7C28, "Radeon VE 7000 DDR(0x174B-0x7C28)"},
{0x1002, 0x5159, 0x1787, 0x0202, "RV100 QY [Excalibur Radeon 7000](0x1787-0x0202)"},
{0x1002, 0x5159, 0x17EE, 0x1001, "Radeon 7000 64MB DDR + DVI(0x17EE-0x1001)"},
{0x1002, 0x515E, 0xFFFF, 0xFFFF, "ES1000(0x515E)"},
{0x1002, 0x515E, 0x1028, 0x01BB, "PowerEdge 1955 Embedded ATI ES1000(0x1028-0x01BB)"},
{0x1002, 0x515E, 0x1028, 0x01DF, "PowerEdge SC440(0x1028-0x01DF)"},
{0x1002, 0x515E, 0x1028, 0x01E6, "PowerEdge 860(0x1028-0x01E6)"},
{0x1002, 0x515E, 0x1028, 0x01F0, "PowerEdge R900 Embedded ATI ES1000(0x1028-0x01F0)"},
{0x1002, 0x515E, 0x1028, 0x0205, "PowerEdge 2970 Embedded ATI ES1000(0x1028-0x0205)"},
{0x1002, 0x515E, 0x1028, 0x020B, "PowerEdge T605 Embedded ATI ES1000(0x1028-0x020B)"},
{0x1002, 0x515E, 0x1028, 0x020F, "PowerEdge R300 Embedded ATI ES1000(0x1028-0x020F)"},
{0x1002, 0x515E, 0x1028, 0x0210, "PowerEdge T300 Embedded ATI ES1000(0x1028-0x0210)"},
{0x1002, 0x515E, 0x1028, 0x0221, "PowerEdge R805 Embedded ATI ES1000(0x1028-0x0221)"},
{0x1002, 0x515E, 0x1028, 0x0223, "PowerEdge R905 Embedded ATI ES1000(0x1028-0x0223)"},
{0x1002, 0x515E, 0x1028, 0x0225, "PowerEdge T105 Embedded ATI ES1000(0x1028-0x0225)"},
{0x1002, 0x515E, 0x1028, 0x023C, "PowerEdge R200 Embedded ATI ES1000(0x1028-0x023C)"},
{0x1002, 0x515E, 0x103C, 0x1304, "Integrity iLO2 Advanced KVM VGA [AD307A](0x103C-0x1304)"},
{0x1002, 0x515E, 0x103C, 0x31FB, "ProLiant DL360 G5(0x103C-0x31FB)"},
{0x1002, 0x515E, 0x15D9, 0x8680, "X7DVL-E-O motherboard(0x15D9-0x8680)"},
{0x1002, 0x515E, 0x15D9, 0x9680, "X7DBN Motherboard(0x15D9-0x9680)"},
{0x1002, 0x515E, 0x8086, 0x3476, "S5000PSLSATA Server Board(0x8086-0x3476)"},
{0x1002, 0x5245, 0xFFFF, 0xFFFF, "Rage 128 GL PCI(0x5245)"},
{0x1002, 0x5245, 0x1002, 0x0008, "Xpert 128(0x1002-0x0008)"},
{0x1002, 0x5245, 0x1002, 0x0028, "Rage 128 AIW(0x1002-0x0028)"},
{0x1002, 0x5245, 0x1002, 0x0029, "Rage 128 AIW(0x1002-0x0029)"},
{0x1002, 0x5245, 0x1002, 0x0068, "Rage 128 AIW(0x1002-0x0068)"},
{0x1002, 0x5246, 0xFFFF, 0xFFFF, "Rage 128 (Rage 4) series(0x5246)"},
{0x1002, 0x5246, 0x1002, 0x0004, "Magnum/Xpert 128/Xpert 99(0x1002-0x0004)"},
{0x1002, 0x5246, 0x1002, 0x0008, "Rage 128 AGP 2x(0x1002-0x0008)"},
{0x1002, 0x5246, 0x1002, 0x0028, "Rage 128 AIW AGP(0x1002-0x0028)"},
{0x1002, 0x5246, 0x1002, 0x0044, "Rage Fury/Xpert 128/Xpert 2000(0x1002-0x0044)"},
{0x1002, 0x5246, 0x1002, 0x0068, "Rage 128 AIW AGP(0x1002-0x0068)"},
{0x1002, 0x5246, 0x1002, 0x0448, "Rage Fury(0x1002-0x0448)"},
{0x1002, 0x524B, 0xFFFF, 0xFFFF, "Rage 128 VR PCI(0x524B)"},
{0x1002, 0x524C, 0xFFFF, 0xFFFF, "Rage 128 VR AGP(0x524C)"},
{0x1002, 0x524C, 0x1002, 0x0008, "Xpert 99/Xpert 2000(0x1002-0x0008)"},
{0x1002, 0x524C, 0x1002, 0x0088, "Xpert 99(0x1002-0x0088)"},
{0x1002, 0x534D, 0xFFFF, 0xFFFF, "Rage 128 4X AGP 4x(0x534D)"},
{0x1002, 0x534D, 0x1002, 0x0008, "Xpert 99/Xpert 2000(0x1002-0x0008)"},
{0x1002, 0x534D, 0x1002, 0x0018, "Xpert 2000(0x1002-0x0018)"},
{0x1002, 0x5354, 0xFFFF, 0xFFFF, "Mach 64 VT(0x5354)"},
{0x1002, 0x5354, 0x1002, 0x5654, "Mach 64 reference(0x1002-0x5654)"},
{0x1002, 0x5446, 0xFFFF, 0xFFFF, "Rage 128 PRO Ultra AGP 4x(0x5446)"},
{0x1002, 0x5446, 0x1002, 0x0004, "Rage Fury Pro(0x1002-0x0004)"},
{0x1002, 0x5446, 0x1002, 0x0008, "Rage Fury Pro/Xpert 2000 Pro(0x1002-0x0008)"},
{0x1002, 0x5446, 0x1002, 0x0018, "Rage Fury Pro/Xpert 2000 Pro(0x1002-0x0018)"},
{0x1002, 0x5446, 0x1002, 0x0028, "Rage 128 AIW Pro AGP(0x1002-0x0028)"},
{0x1002, 0x5446, 0x1002, 0x0029, "Rage 128 AIW(0x1002-0x0029)"},
{0x1002, 0x5446, 0x1002, 0x002A, "Rage 128 AIW Pro AGP(0x1002-0x002A)"},
{0x1002, 0x5446, 0x1002, 0x002B, "Rage 128 AIW(0x1002-0x002B)"},
{0x1002, 0x5446, 0x1002, 0x0048, "Xpert 2000 Pro(0x1002-0x0048)"},
{0x1002, 0x5452, 0xFFFF, 0xFFFF, "Rage 128 PRO Ultra4XL VR-R AGP(0x5452)"},
{0x1002, 0x5452, 0x1002, 0x001C, "Rage 128 Pro 4XL(0x1002-0x001C)"},
{0x1002, 0x5452, 0x103C, 0x1279, "Rage 128 Pro 4XL(0x103C-0x1279)"},
{0x1002, 0x5460, 0xFFFF, 0xFFFF, "RV370/M22 [Mobility Radeon X300](0x5460)"},
{0x1002, 0x5460, 0x1775, 0x1100, "CR11/VR11 Single Board Computer(0x1775-0x1100)"},
{0x1002, 0x5461, 0xFFFF, 0xFFFF, "RV370/M22 [Mobility Radeon X300](0x5461)"},
{0x1002, 0x5462, 0xFFFF, 0xFFFF, "RV380/M24C [Mobility Radeon X600 SE](0x5462)"},
{0x1002, 0x5464, 0xFFFF, 0xFFFF, "RV370/M22 GL [Mobility FireGL V3100](0x5464)"},
{0x1002, 0x5549, 0xFFFF, 0xFFFF, "R423 [Radeon X800 GTO](0x5549)"},
{0x1002, 0x554A, 0xFFFF, 0xFFFF, "R423 [Radeon X800 XT Platinum Edition](0x554A)"},
{0x1002, 0x554B, 0xFFFF, 0xFFFF, "R423 [Radeon X800 GT/SE](0x554B)"},
{0x1002, 0x554B, 0x1002, 0x0302, "Radeon X800 SE(0x1002-0x0302)"},
{0x1002, 0x554D, 0xFFFF, 0xFFFF, "R480 [Radeon X800 GTO2/XL](0x554D)"},
{0x1002, 0x554D, 0x1002, 0x0322, "All-In-Wonder X800 XL(0x1002-0x0322)"},
{0x1002, 0x554D, 0x1458, 0x2124, "GV-R80L256V-B (AGP)(0x1458-0x2124)"},
{0x1002, 0x554E, 0xFFFF, 0xFFFF, "R430 [All-In-Wonder X800 GT](0x554E)"},
{0x1002, 0x554F, 0xFFFF, 0xFFFF, "R430 [Radeon X800](0x554F)"},
{0x1002, 0x5550, 0xFFFF, 0xFFFF, "R423 GL [FireGL V7100](0x5550)"},
{0x1002, 0x5551, 0xFFFF, 0xFFFF, "R423 GL [FireGL V5100](0x5551)"},
{0x1002, 0x5569, 0xFFFF, 0xFFFF, "R423 [Radeon X800 PRO] (Secondary)(0x5569)"},
{0x1002, 0x556B, 0xFFFF, 0xFFFF, "R423 [Radeon X800 GT] (Secondary)(0x556B)"},
{0x1002, 0x556D, 0xFFFF, 0xFFFF, "R480 [Radeon X800 GTO2/XL] (Secondary)(0x556D)"},
{0x1002, 0x556D, 0x1458, 0x2125, "GV-R80L256V-B (AGP)(0x1458-0x2125)"},
{0x1002, 0x556F, 0xFFFF, 0xFFFF, "R430 [Radeon X800] (Secondary)(0x556F)"},
{0x1002, 0x5571, 0xFFFF, 0xFFFF, "R423 GL [FireGL V5100] (Secondary)(0x5571)"},
{0x1002, 0x564B, 0xFFFF, 0xFFFF, "RV410/M26 GL [Mobility FireGL V5000](0x564B)"},
{0x1002, 0x564F, 0xFFFF, 0xFFFF, "RV410/M26 [Mobility Radeon X700 XL](0x564F)"},
{0x1002, 0x5652, 0xFFFF, 0xFFFF, "RV410/M26 [Mobility Radeon X700](0x5652)"},
{0x1002, 0x5653, 0xFFFF, 0xFFFF, "RV410/M26 [Mobility Radeon X700](0x5653)"},
{0x1002, 0x5653, 0x1025, 0x0080, "Aspire 5024WLMi(0x1025-0x0080)"},
{0x1002, 0x5653, 0x103C, 0x0940, "Compaq NW8240 Mobile Workstation(0x103C-0x0940)"},
{0x1002, 0x5654, 0xFFFF, 0xFFFF, "Mach64 VT [Video Xpression](0x5654)"},
{0x1002, 0x5654, 0x1002, 0x5654, "Mach64VT Reference(0x1002-0x5654)"},
{0x1002, 0x5655, 0xFFFF, 0xFFFF, "264VT3 [Mach64 VT3](0x5655)"},
{0x1002, 0x5656, 0xFFFF, 0xFFFF, "Mach64 VT4 [Video Xpression+](0x5656)"},
{0x1002, 0x5657, 0xFFFF, 0xFFFF, "RV410 [Radeon X550 XTX / X700](0x5657)"},
{0x1002, 0x5830, 0xFFFF, 0xFFFF, "RS300 Host Bridge(0x5830)"},
{0x1002, 0x5831, 0xFFFF, 0xFFFF, "RS300 Host Bridge(0x5831)"},
{0x1002, 0x5832, 0xFFFF, 0xFFFF, "RS300 Host Bridge(0x5832)"},
{0x1002, 0x5833, 0xFFFF, 0xFFFF, "RS300 Host Bridge(0x5833)"},
{0x1002, 0x5834, 0xFFFF, 0xFFFF, "RS300 [Radeon 9100 IGP](0x5834)"},
{0x1002, 0x5835, 0xFFFF, 0xFFFF, "RS300M [Mobility Radeon 9100 IGP](0x5835)"},
{0x1002, 0x5838, 0xFFFF, 0xFFFF, "RS300 AGP Bridge(0x5838)"},
{0x1002, 0x5854, 0xFFFF, 0xFFFF, "RS480 [Radeon Xpress 200 Series] (Secondary)(0x5854)"},
{0x1002, 0x5874, 0xFFFF, 0xFFFF, "RS480 [Radeon Xpress 1150] (Secondary)(0x5874)"},
{0x1002, 0x5940, 0xFFFF, 0xFFFF, "RV280 [Radeon 9200 PRO] (Secondary)(0x5940)"},
{0x1002, 0x5940, 0x17AF, 0x2021, "Excalibur Radeon 9250 (Secondary)(0x17AF-0x2021)"},
{0x1002, 0x5941, 0xFFFF, 0xFFFF, "RV280 [Radeon 9200] (Secondary)(0x5941)"},
{0x1002, 0x5941, 0x1458, 0x4019, "Radeon 9200(0x1458-0x4019)"},
{0x1002, 0x5941, 0x174B, 0x7C12, "Radeon 9200(0x174B-0x7C12)"},
{0x1002, 0x5941, 0x17AF, 0x200D, "Excalibur Radeon 9200(0x17AF-0x200D)"},
{0x1002, 0x5941, 0x18BC, 0x0050, "GC-R9200-C3 (Secondary)(0x18BC-0x0050)"},
{0x1002, 0x5944, 0xFFFF, 0xFFFF, "RV280 [Radeon 9200 SE PCI](0x5944)"},
{0x1002, 0x5950, 0xFFFF, 0xFFFF, "RS480/RS482/RS485 Host Bridge(0x5950)"},
{0x1002, 0x5950, 0x1025, 0x0080, "Aspire 5024WLMMi(0x1025-0x0080)"},
{0x1002, 0x5950, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x5950, 0x103C, 0x2A20, "Pavilion t3030.de Desktop PC(0x103C-0x2A20)"},
{0x1002, 0x5950, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x5950, 0x1462, 0x0131, "MS-1013 Notebook(0x1462-0x0131)"},
{0x1002, 0x5950, 0x1462, 0x7217, "Aspire L250(0x1462-0x7217)"},
{0x1002, 0x5951, 0xFFFF, 0xFFFF, "RX480/RX482 Host Bridge(0x5951)"},
{0x1002, 0x5952, 0xFFFF, 0xFFFF, "RD580 Host Bridge(0x5952)"},
{0x1002, 0x5954, 0xFFFF, 0xFFFF, "RS480 [Radeon Xpress 200 Series](0x5954)"},
{0x1002, 0x5954, 0x1002, 0x5954, "RV370 [Radeon Xpress 200G Series](0x1002-0x5954)"},
{0x1002, 0x5955, 0xFFFF, 0xFFFF, "RS480M [Mobility Radeon Xpress 200](0x5955)"},
{0x1002, 0x5955, 0x1002, 0x5955, "RS480 0x5955 [Radeon XPRESS 200M 5955 (PCIE)](0x1002-0x5955)"},
{0x1002, 0x5955, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x1002, 0x5955, 0x1462, 0x0131, "MS-1013 Notebook(0x1462-0x0131)"},
{0x1002, 0x5956, 0xFFFF, 0xFFFF, "RD790 Host Bridge(0x5956)"},
{0x1002, 0x5957, 0xFFFF, 0xFFFF, "RX780/RX790 Host Bridge(0x5957)"},
{0x1002, 0x5957, 0x1849, 0x5957, "A770CrossFire Motherboard(0x1849-0x5957)"},
{0x1002, 0x5958, 0xFFFF, 0xFFFF, "RD780 Host Bridge(0x5958)"},
{0x1002, 0x5960, 0xFFFF, 0xFFFF, "RV280 [Radeon 9200 PRO / 9250](0x5960)"},
{0x1002, 0x5960, 0x17AF, 0x2020, "Excalibur Radeon 9250(0x17AF-0x2020)"},
{0x1002, 0x5961, 0xFFFF, 0xFFFF, "RV280 [Radeon 9200](0x5961)"},
{0x1002, 0x5961, 0x1002, 0x2F72, "All-in-Wonder 9200 Series(0x1002-0x2F72)"},
{0x1002, 0x5961, 0x1019, 0x4C30, "Radeon 9200 VIVO(0x1019-0x4C30)"},
{0x1002, 0x5961, 0x12AB, 0x5961, "YUAN SMARTVGA Radeon 9200(0x12AB-0x5961)"},
{0x1002, 0x5961, 0x1458, 0x4018, "Radeon 9200(0x1458-0x4018)"},
{0x1002, 0x5961, 0x174B, 0x7C13, "Radeon 9200(0x174B-0x7C13)"},
{0x1002, 0x5961, 0x17AF, 0x200C, "Excalibur Radeon 9200(0x17AF-0x200C)"},
{0x1002, 0x5961, 0x18BC, 0x0050, "Radeon 9200 Game Buster(0x18BC-0x0050)"},
{0x1002, 0x5961, 0x18BC, 0x0051, "GC-R9200-C3(0x18BC-0x0051)"},
{0x1002, 0x5961, 0x18BC, 0x0053, "Radeon 9200 Game Buster VIVO(0x18BC-0x0053)"},
{0x1002, 0x5962, 0xFFFF, 0xFFFF, "RV280 [Radeon 9200](0x5962)"},
{0x1002, 0x5964, 0xFFFF, 0xFFFF, "RV280 [Radeon 9200 SE](0x5964)"},
{0x1002, 0x5964, 0x1002, 0x5964, "Radeon 9200 SE, 64-bit 128MB DDR, 200/166MHz(0x1002-0x5964)"},
{0x1002, 0x5964, 0x1043, 0xC006, "Radeon 9200 SE / TD / 128M(0x1043-0xC006)"},
{0x1002, 0x5964, 0x1458, 0x4018, "R92S128T [Radeon 9200 SE 128MB](0x1458-0x4018)"},
{0x1002, 0x5964, 0x1458, 0x4032, "Radeon 9200 SE 128MB(0x1458-0x4032)"},
{0x1002, 0x5964, 0x147B, 0x6191, "R9200SE-DT(0x147B-0x6191)"},
{0x1002, 0x5964, 0x148C, 0x2073, "CN-AG92E(0x148C-0x2073)"},
{0x1002, 0x5964, 0x174B, 0x7C13, "Radeon 9200 SE(0x174B-0x7C13)"},
{0x1002, 0x5964, 0x1787, 0x5964, "Excalibur 9200SE VIVO 128M(0x1787-0x5964)"},
{0x1002, 0x5964, 0x17AF, 0x2012, "Radeon 9200 SE Excalibur(0x17AF-0x2012)"},
{0x1002, 0x5964, 0x18BC, 0x0170, "Sapphire Radeon 9200 SE 128MB Game Buster(0x18BC-0x0170)"},
{0x1002, 0x5964, 0x18BC, 0x0173, "GC-R9200L(SE)-C3H [Radeon 9200 Game Buster](0x18BC-0x0173)"},
{0x1002, 0x5965, 0xFFFF, 0xFFFF, "RV280 GL [FireMV 2200 PCI](0x5965)"},
{0x1002, 0x5974, 0xFFFF, 0xFFFF, "RS482/RS485 [Radeon Xpress 1100/1150](0x5974)"},
{0x1002, 0x5974, 0x103C, 0x280A, "DC5750 Microtower(0x103C-0x280A)"},
{0x1002, 0x5974, 0x1462, 0x7141, "Aspire L250(0x1462-0x7141)"},
{0x1002, 0x5975, 0xFFFF, 0xFFFF, "RS482M [Mobility Radeon Xpress 200](0x5975)"},
{0x1002, 0x5978, 0xFFFF, 0xFFFF, "RX780/RD790 PCI to PCI bridge (external gfx0 port A)(0x5978)"},
{0x1002, 0x5978, 0x1849, 0x5957, "A770CrossFire Motherboard(0x1849-0x5957)"},
{0x1002, 0x5979, 0xFFFF, 0xFFFF, "RD790 PCI to PCI bridge (external gfx0 port B)(0x5979)"},
{0x1002, 0x597A, 0xFFFF, 0xFFFF, "RD790 PCI to PCI bridge (PCI express gpp port A)(0x597A)"},
{0x1002, 0x597B, 0xFFFF, 0xFFFF, "RX780/RD790 PCI to PCI bridge (PCI express gpp port B)(0x597B)"},
{0x1002, 0x597C, 0xFFFF, 0xFFFF, "RD790 PCI to PCI bridge (PCI express gpp port C)(0x597C)"},
{0x1002, 0x597D, 0xFFFF, 0xFFFF, "RX780/RD790 PCI to PCI bridge (PCI express gpp port D)(0x597D)"},
{0x1002, 0x597E, 0xFFFF, 0xFFFF, "RD790 PCI to PCI bridge (PCI express gpp port E)(0x597E)"},
{0x1002, 0x597E, 0x1849, 0x5957, "A770CrossFire Motherboard(0x1849-0x5957)"},
{0x1002, 0x597F, 0xFFFF, 0xFFFF, "RD790 PCI to PCI bridge (PCI express gpp port F)(0x597F)"},
{0x1002, 0x597F, 0x1849, 0x5957, "A770CrossFire Motherboard(0x1849-0x5957)"},
{0x1002, 0x5980, 0xFFFF, 0xFFFF, "RD790 PCI to PCI bridge (external gfx1 port A)(0x5980)"},
{0x1002, 0x5981, 0xFFFF, 0xFFFF, "RD790 PCI to PCI bridge (external gfx1 port B)(0x5981)"},
{0x1002, 0x5982, 0xFFFF, 0xFFFF, "RD790 PCI to PCI bridge (NB-SB link)(0x5982)"},
{0x1002, 0x5A10, 0xFFFF, 0xFFFF, "RD890 Northbridge only dual slot (2x16) PCI-e GFX Hydra part(0x5A10)"},
{0x1002, 0x5A11, 0xFFFF, 0xFFFF, "RD890 Northbridge only single slot PCI-e GFX Hydra part(0x5A11)"},
{0x1002, 0x5A12, 0xFFFF, 0xFFFF, "RD890 Northbridge only dual slot (2x8) PCI-e GFX Hydra part(0x5A12)"},
{0x1002, 0x5A12, 0x15D9, 0xA811, "H8DGU(0x15D9-0xA811)"},
{0x1002, 0x5A13, 0xFFFF, 0xFFFF, "RD890S/SR5650 Host Bridge(0x5A13)"},
{0x1002, 0x5A14, 0xFFFF, 0xFFFF, "RD9x0/RX980 Host Bridge(0x5A14)"},
{0x1002, 0x5A15, 0xFFFF, 0xFFFF, "RD890 PCI to PCI bridge (PCI express gpp port A)(0x5A15)"},
{0x1002, 0x5A16, 0xFFFF, 0xFFFF, "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GFX port 0)(0x5A16)"},
{0x1002, 0x5A17, 0xFFFF, 0xFFFF, "RD890/RD9x0 PCI to PCI bridge (PCI Express GFX port 1)(0x5A17)"},
{0x1002, 0x5A18, 0xFFFF, 0xFFFF, "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 0)(0x5A18)"},
{0x1002, 0x5A18, 0x15D9, 0xA811, "H8DGU(0x15D9-0xA811)"},
{0x1002, 0x5A19, 0xFFFF, 0xFFFF, "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 1)(0x5A19)"},
{0x1002, 0x5A1A, 0xFFFF, 0xFFFF, "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 2)(0x5A1A)"},
{0x1002, 0x5A1B, 0xFFFF, 0xFFFF, "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 3)(0x5A1B)"},
{0x1002, 0x5A1C, 0xFFFF, 0xFFFF, "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 4)(0x5A1C)"},
{0x1002, 0x5A1D, 0xFFFF, 0xFFFF, "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP Port 5)(0x5A1D)"},
{0x1002, 0x5A1E, 0xFFFF, 0xFFFF, "RD890/RD9x0/RX980 PCI to PCI bridge (PCI Express GPP2 Port 0)(0x5A1E)"},
{0x1002, 0x5A1F, 0xFFFF, 0xFFFF, "RD890/RD990 PCI to PCI bridge (PCI Express GFX2 port 0)(0x5A1F)"},
{0x1002, 0x5A1F, 0x15D9, 0xA811, "H8DGU(0x15D9-0xA811)"},
{0x1002, 0x5A20, 0xFFFF, 0xFFFF, "RD890/RD990 PCI to PCI bridge (PCI Express GFX2 port 1)(0x5A20)"},
{0x1002, 0x5A23, 0xFFFF, 0xFFFF, "RD890S/RD990 I/O Memory Management Unit (IOMMU)(0x5A23)"},
{0x1002, 0x5A31, 0xFFFF, 0xFFFF, "RC410 Host Bridge(0x5A31)"},
{0x1002, 0x5A33, 0xFFFF, 0xFFFF, "RS400 Host Bridge(0x5A33)"},
{0x1002, 0x5A34, 0xFFFF, 0xFFFF, "RS4xx PCI Express Port [ext gfx](0x5A34)"},
{0x1002, 0x5A36, 0xFFFF, 0xFFFF, "RC4xx/RS4xx PCI Express Port 1(0x5A36)"},
{0x1002, 0x5A37, 0xFFFF, 0xFFFF, "RC4xx/RS4xx PCI Express Port 2(0x5A37)"},
{0x1002, 0x5A38, 0xFFFF, 0xFFFF, "RC4xx/RS4xx PCI Express Port 3(0x5A38)"},
{0x1002, 0x5A39, 0xFFFF, 0xFFFF, "RC4xx/RS4xx PCI Express Port 4(0x5A39)"},
{0x1002, 0x5A3F, 0xFFFF, 0xFFFF, "RC4xx/RS4xx PCI Bridge [int gfx](0x5A3F)"},
{0x1002, 0x5A3F, 0x1462, 0x7217, "Aspire L250(0x1462-0x7217)"},
{0x1002, 0x5A41, 0xFFFF, 0xFFFF, "RS400 [Radeon Xpress 200](0x5A41)"},
{0x1002, 0x5A42, 0xFFFF, 0xFFFF, "RS400M [Radeon Xpress 200M](0x5A42)"},
{0x1002, 0x5A61, 0xFFFF, 0xFFFF, "RC410 [Radeon Xpress 200/1100](0x5A61)"},
{0x1002, 0x5A62, 0xFFFF, 0xFFFF, "RC410M [Mobility Radeon Xpress 200M](0x5A62)"},
{0x1002, 0x5B60, 0xFFFF, 0xFFFF, "RV370 [Radeon X300](0x5B60)"},
{0x1002, 0x5B60, 0x1043, 0x002A, "Extreme AX300SE-X(0x1043-0x002A)"},
{0x1002, 0x5B60, 0x1043, 0x032E, "Extreme AX300/TD(0x1043-0x032E)"},
{0x1002, 0x5B60, 0x1458, 0x2102, "GV-RX30S128D (X300SE)(0x1458-0x2102)"},
{0x1002, 0x5B60, 0x1462, 0x0400, "RX300SE-TD128E (MS-8940 REV:200)(0x1462-0x0400)"},
{0x1002, 0x5B60, 0x1462, 0x0402, "RX300SE-TD128E (MS-8940)(0x1462-0x0402)"},
{0x1002, 0x5B60, 0x174B, 0x0500, "Radeon X300 (PCIE)(0x174B-0x0500)"},
{0x1002, 0x5B60, 0x196D, 0x1086, "X300SE HM(0x196D-0x1086)"},
{0x1002, 0x5B62, 0xFFFF, 0xFFFF, "RV370 [Radeon X600/X600 SE](0x5B62)"},
{0x1002, 0x5B63, 0xFFFF, 0xFFFF, "RV370 [Radeon X300/X550/X1050 Series](0x5B63)"},
{0x1002, 0x5B64, 0xFFFF, 0xFFFF, "RV370 GL [FireGL V3100](0x5B64)"},
{0x1002, 0x5B65, 0xFFFF, 0xFFFF, "RV370 GL [FireMV 2200](0x5B65)"},
{0x1002, 0x5B66, 0xFFFF, 0xFFFF, "RV370X(0x5B66)"},
{0x1002, 0x5B70, 0xFFFF, 0xFFFF, "RV370 [Radeon X300 SE](0x5B70)"},
{0x1002, 0x5B70, 0x1462, 0x0403, "Radeon X300 SE 128MB DDR(0x1462-0x0403)"},
{0x1002, 0x5B70, 0x174B, 0x0501, "Radeon X300 SE(0x174B-0x0501)"},
{0x1002, 0x5B70, 0x196D, 0x1087, "Radeon X300 SE HyperMemory(0x196D-0x1087)"},
{0x1002, 0x5B72, 0xFFFF, 0xFFFF, "RV380 [Radeon X300/X550/X1050 Series] (Secondary)(0x5B72)"},
{0x1002, 0x5B73, 0xFFFF, 0xFFFF, "RV370 [Radeon X300/X550/X1050 Series] (Secondary)(0x5B73)"},
{0x1002, 0x5B74, 0xFFFF, 0xFFFF, "RV370 GL [FireGL V3100] (Secondary)(0x5B74)"},
{0x1002, 0x5B75, 0xFFFF, 0xFFFF, "RV370 GL [FireMV 2200] (Secondary)(0x5B75)"},
{0x1002, 0x5C61, 0xFFFF, 0xFFFF, "RV280/M9+ [Mobility Radeon 9200 AGP](0x5C61)"},
{0x1002, 0x5C63, 0xFFFF, 0xFFFF, "RV280/M9+ [Mobility Radeon 9200 AGP](0x5C63)"},
{0x1002, 0x5C63, 0x1002, 0x5C63, "Apple iBook G4 2004(0x1002-0x5C63)"},
{0x1002, 0x5C63, 0x144D, 0xC00C, "P30 notebook(0x144D-0xC00C)"},
{0x1002, 0x5D44, 0xFFFF, 0xFFFF, "RV280 [Radeon 9200 SE] (Secondary)(0x5D44)"},
{0x1002, 0x5D44, 0x1458, 0x4019, "R92S128T (Radeon 9200 SE 128MB Secondary)(0x1458-0x4019)"},
{0x1002, 0x5D44, 0x1458, 0x4032, "Radeon 9200 SE 128MB(0x1458-0x4032)"},
{0x1002, 0x5D44, 0x147B, 0x6190, "R9200SE-DT (Secondary)(0x147B-0x6190)"},
{0x1002, 0x5D44, 0x174B, 0x7C12, "Radeon 9200 SE (Secondary)(0x174B-0x7C12)"},
{0x1002, 0x5D44, 0x1787, 0x5965, "Excalibur 9200SE VIVO 128M (Secondary)(0x1787-0x5965)"},
{0x1002, 0x5D44, 0x17AF, 0x2013, "Radeon 9200 SE Excalibur (Secondary)(0x17AF-0x2013)"},
{0x1002, 0x5D44, 0x18BC, 0x0171, "Radeon 9200 SE 128MB Game Buster (Secondary)(0x18BC-0x0171)"},
{0x1002, 0x5D44, 0x18BC, 0x0172, "GC-R9200L(SE)-C3H [Radeon 9200 Game Buster](0x18BC-0x0172)"},
{0x1002, 0x5D45, 0xFFFF, 0xFFFF, "RV280 GL [FireMV 2200 PCI] (Secondary)(0x5D45)"},
{0x1002, 0x5D48, 0xFFFF, 0xFFFF, "R423/M28 [Mobility Radeon X800 XT](0x5D48)"},
{0x1002, 0x5D49, 0xFFFF, 0xFFFF, "R423/M28 GL [Mobility FireGL V5100](0x5D49)"},
{0x1002, 0x5D4A, 0xFFFF, 0xFFFF, "R423/M28 [Mobility Radeon X800](0x5D4A)"},
{0x1002, 0x5D4D, 0xFFFF, 0xFFFF, "R480 [Radeon X850 XT Platinum Edition](0x5D4D)"},
{0x1002, 0x5D4E, 0xFFFF, 0xFFFF, "R480 [Radeon X850 SE](0x5D4E)"},
{0x1002, 0x5D4F, 0xFFFF, 0xFFFF, "R480 [Radeon X800 GTO](0x5D4F)"},
{0x1002, 0x5D50, 0xFFFF, 0xFFFF, "R480 GL [FireGL V7200](0x5D50)"},
{0x1002, 0x5D52, 0xFFFF, 0xFFFF, "R480 [Radeon X850 XT](0x5D52)"},
{0x1002, 0x5D52, 0x1002, 0x0B12, "PowerColor X850XT PCIe (Primary)(0x1002-0x0B12)"},
{0x1002, 0x5D57, 0xFFFF, 0xFFFF, "R423 [Radeon X800 XT](0x5D57)"},
{0x1002, 0x5D6D, 0xFFFF, 0xFFFF, "R480 [Radeon X850 XT Platinum Edition] (Secondary)(0x5D6D)"},
{0x1002, 0x5D6F, 0xFFFF, 0xFFFF, "R480 [Radeon X800 GTO] (Secondary)(0x5D6F)"},
{0x1002, 0x5D72, 0xFFFF, 0xFFFF, "R480 [Radeon X850 XT] (Secondary)(0x5D72)"},
{0x1002, 0x5D72, 0x1002, 0x0B13, "PowerColor X850XT PCIe (Secondary)(0x1002-0x0B13)"},
{0x1002, 0x5D77, 0xFFFF, 0xFFFF, "R423 [Radeon X800 XT] (Secondary)(0x5D77)"},
{0x1002, 0x5E48, 0xFFFF, 0xFFFF, "RV410 GL [FireGL V5000](0x5E48)"},
{0x1002, 0x5E49, 0xFFFF, 0xFFFF, "RV410 [Radeon X700 Series](0x5E49)"},
{0x1002, 0x5E4A, 0xFFFF, 0xFFFF, "RV410 [Radeon X700 XT](0x5E4A)"},
{0x1002, 0x5E4B, 0xFFFF, 0xFFFF, "RV410 [Radeon X700 PRO](0x5E4B)"},
{0x1002, 0x5E4C, 0xFFFF, 0xFFFF, "RV410 [Radeon X700 SE](0x5E4C)"},
{0x1002, 0x5E4D, 0xFFFF, 0xFFFF, "RV410 [Radeon X700](0x5E4D)"},
{0x1002, 0x5E4D, 0x148C, 0x2116, "Bravo X700(0x148C-0x2116)"},
{0x1002, 0x5E4F, 0xFFFF, 0xFFFF, "RV410 [Radeon X700](0x5E4F)"},
{0x1002, 0x5E4F, 0x1569, 0x1E4F, "Radeon X550 XT(0x1569-0x1E4F)"},
{0x1002, 0x5E6B, 0xFFFF, 0xFFFF, "RV410 [Radeon X700 PRO] (Secondary)(0x5E6B)"},
{0x1002, 0x5E6D, 0xFFFF, 0xFFFF, "RV410 [Radeon X700] (Secondary)(0x5E6D)"},
{0x1002, 0x5E6D, 0x148C, 0x2117, "Bravo X700 (Secondary)(0x148C-0x2117)"},
{0x1002, 0x5F57, 0xFFFF, 0xFFFF, "R423 [Radeon X800 XT](0x5F57)"},
{0x1002, 0x6600, 0xFFFF, 0xFFFF, "Mars [Radeon HD 8670A/8670M/8750M / R7 M370](0x6600)"},
{0x1002, 0x6600, 0x103C, 0x1952, "ProBook 455 G1(0x103C-0x1952)"},
{0x1002, 0x6601, 0xFFFF, 0xFFFF, "Mars [Radeon HD 8730M](0x6601)"},
{0x1002, 0x6601, 0x103C, 0x2100, "FirePro M4100(0x103C-0x2100)"},
{0x1002, 0x6604, 0xFFFF, 0xFFFF, "Opal XT [Radeon R7 M265/M365X/M465](0x6604)"},
{0x1002, 0x6604, 0x1025, 0x0776, "Aspire V5 Radeon R7 M265(0x1025-0x0776)"},
{0x1002, 0x6604, 0x103C, 0x8006, "FirePro M4170(0x103C-0x8006)"},
{0x1002, 0x6604, 0x103C, 0x814F, "Litho XT [Radeon R7 M365X](0x103C-0x814F)"},
{0x1002, 0x6604, 0x103C, 0x82AA, "Litho XT [Radeon R7 M465](0x103C-0x82AA)"},
{0x1002, 0x6604, 0x17AA, 0x3643, "Radeon R7 A360(0x17AA-0x3643)"},
{0x1002, 0x6605, 0xFFFF, 0xFFFF, "Opal PRO [Radeon R7 M260X](0x6605)"},
{0x1002, 0x6605, 0x103C, 0x2259, "FirePro M4150(0x103C-0x2259)"},
{0x1002, 0x6606, 0xFFFF, 0xFFFF, "Mars XTX [Radeon HD 8790M](0x6606)"},
{0x1002, 0x6606, 0x1028, 0x0684, "FirePro W4170M(0x1028-0x0684)"},
{0x1002, 0x6607, 0xFFFF, 0xFFFF, "Mars LE [Radeon HD 8530M / R5 M240](0x6607)"},
{0x1002, 0x6608, 0xFFFF, 0xFFFF, "Oland GL [FirePro W2100](0x6608)"},
{0x1002, 0x6608, 0x13CC, 0x3D28, "MXRT-2600(0x13CC-0x3D28)"},
{0x1002, 0x6609, 0xFFFF, 0xFFFF, "Oland GL [FirePro W2100 / Barco MXRT 2600](0x6609)"},
{0x1002, 0x6610, 0xFFFF, 0xFFFF, "Oland XT [Radeon HD 8670 / R5 340X OEM / R7 250/350/350X OEM](0x6610)"},
{0x1002, 0x6610, 0x1019, 0x0030, "Radeon HD 8670(0x1019-0x0030)"},
{0x1002, 0x6610, 0x1028, 0x0081, "Radeon R7 350X OEM(0x1028-0x0081)"},
{0x1002, 0x6610, 0x1028, 0x0083, "Radeon R5 340X OEM(0x1028-0x0083)"},
{0x1002, 0x6610, 0x1028, 0x2120, "Radeon R7 250(0x1028-0x2120)"},
{0x1002, 0x6610, 0x1028, 0x2322, "Radeon R7 250(0x1028-0x2322)"},
{0x1002, 0x6610, 0x1462, 0x2910, "Radeon HD 8670(0x1462-0x2910)"},
{0x1002, 0x6610, 0x1462, 0x2911, "Radeon HD 8670(0x1462-0x2911)"},
{0x1002, 0x6610, 0x148C, 0x7350, "Radeon R7 350(0x148C-0x7350)"},
{0x1002, 0x6610, 0x1642, 0x3C81, "Radeon HD 8670(0x1642-0x3C81)"},
{0x1002, 0x6610, 0x1642, 0x3C91, "Radeon HD 8670(0x1642-0x3C91)"},
{0x1002, 0x6610, 0x1642, 0x3F09, "Radeon R7 350(0x1642-0x3F09)"},
{0x1002, 0x6611, 0xFFFF, 0xFFFF, "Oland [Radeon HD 8570 / R5 430 OEM / R7 240/340 / Radeon 520 OEM](0x6611)"},
{0x1002, 0x6611, 0x1028, 0x1001, "Radeon R5 430 OEM (1024 MByte)(0x1028-0x1001)"},
{0x1002, 0x6611, 0x1028, 0x1002, "Radeon R5 430 OEM (2048 MByte)(0x1028-0x1002)"},
{0x1002, 0x6611, 0x1028, 0x1711, "R5 430 OEM (2048 MByte)(0x1028-0x1711)"},
{0x1002, 0x6611, 0x1028, 0x210B, "Radeon R5 240 OEM(0x1028-0x210B)"},
{0x1002, 0x6611, 0x1028, 0x2121, "Radeon HD 8570 OEM(0x1028-0x2121)"},
{0x1002, 0x6611, 0x10CF, 0x1889, "Radeon HD 8570 OEM(0x10CF-0x1889)"},
{0x1002, 0x6611, 0x1642, 0x1869, "Radeon 520 OEM(0x1642-0x1869)"},
{0x1002, 0x6611, 0x174B, 0x4248, "Radeon R7 240 OEM(0x174B-0x4248)"},
{0x1002, 0x6611, 0x174B, 0xA240, "Radeon R7 240 OEM(0x174B-0xA240)"},
{0x1002, 0x6611, 0x174B, 0xD340, "Radeon R7 340 OEM(0x174B-0xD340)"},
{0x1002, 0x6611, 0x1B0A, 0x90D3, "Radeon R7 240 OEM(0x1B0A-0x90D3)"},
{0x1002, 0x6613, 0xFFFF, 0xFFFF, "Oland PRO [Radeon R7 240/340 / Radeon 520](0x6613)"},
{0x1002, 0x6613, 0x148C, 0x7340, "Radeon R7 340(0x148C-0x7340)"},
{0x1002, 0x6613, 0x1682, 0x7240, "R7 240 2048 MB(0x1682-0x7240)"},
{0x1002, 0x6613, 0x1DCF, 0x3000, "Oland PRO [Radeon R7 240/340 / Radeon 520](0x1DCF-0x3000)"},
{0x1002, 0x6617, 0xFFFF, 0xFFFF, "Oland LE [Radeon R7 240](0x6617)"},
{0x1002, 0x6631, 0xFFFF, 0xFFFF, "Oland(0x6631)"},
{0x1002, 0x6640, 0xFFFF, 0xFFFF, "Saturn XT [FirePro M6100](0x6640)"},
{0x1002, 0x6640, 0x106B, 0x014B, "Tropo XT [Radeon R9 M380 Mac Edition](0x106B-0x014B)"},
{0x1002, 0x6641, 0xFFFF, 0xFFFF, "Saturn PRO [Radeon HD 8930M](0x6641)"},
{0x1002, 0x6646, 0xFFFF, 0xFFFF, "Bonaire XT [Radeon R9 M280X / FirePro W6150M](0x6646)"},
{0x1002, 0x6647, 0xFFFF, 0xFFFF, "Saturn PRO/XT [Radeon R9 M270X/M280X](0x6647)"},
{0x1002, 0x6647, 0x1043, 0x223D, "N551ZU laptop Radeon R9 M280X(0x1043-0x223D)"},
{0x1002, 0x6649, 0xFFFF, 0xFFFF, "Bonaire [FirePro W5100](0x6649)"},
{0x1002, 0x6649, 0x1002, 0x0B0C, "FirePro W4300(0x1002-0x0B0C)"},
{0x1002, 0x6649, 0x103C, 0x0B0C, "Bonaire [FirePro W4300](0x103C-0x0B0C)"},
{0x1002, 0x6649, 0x103C, 0x230C, "FirePro W5100(0x103C-0x230C)"},
{0x1002, 0x6649, 0x13CC, 0x3D2A, "MXRT-5600(0x13CC-0x3D2A)"},
{0x1002, 0x664D, 0xFFFF, 0xFFFF, "Bonaire [FirePro W5100 / Barco MXRT-5600](0x664D)"},
{0x1002, 0x6650, 0xFFFF, 0xFFFF, "Bonaire(0x6650)"},
{0x1002, 0x6651, 0xFFFF, 0xFFFF, "Bonaire(0x6651)"},
{0x1002, 0x6658, 0xFFFF, 0xFFFF, "Bonaire XTX [Radeon R7 260X/360](0x6658)"},
{0x1002, 0x6658, 0x1043, 0x048F, "R7260X-DC2OC-2GD5(0x1043-0x048F)"},
{0x1002, 0x6658, 0x1043, 0x04D3, "AMD Radeon R7 260X(0x1043-0x04D3)"},
{0x1002, 0x6658, 0x1458, 0x227B, "Radeon R7 260X(0x1458-0x227B)"},
{0x1002, 0x6658, 0x148C, 0x0907, "Radeon R7 360(0x148C-0x0907)"},
{0x1002, 0x6658, 0x1682, 0x0907, "Radeon R7 360(0x1682-0x0907)"},
{0x1002, 0x6658, 0x1682, 0x7360, "Radeon R7 360(0x1682-0x7360)"},
{0x1002, 0x665C, 0xFFFF, 0xFFFF, "Bonaire XT [Radeon HD 7790/8770 / R7 360 / R9 260/360 OEM](0x665C)"},
{0x1002, 0x665C, 0x1043, 0x0452, "Radeon HD 7790 DirectCU II OC(0x1043-0x0452)"},
{0x1002, 0x665C, 0x1462, 0x2930, "Radeon HD 7790 OC(0x1462-0x2930)"},
{0x1002, 0x665C, 0x1462, 0x2932, "Radeon HD 8770(0x1462-0x2932)"},
{0x1002, 0x665C, 0x1462, 0x2934, "Radeon R9 260 OEM(0x1462-0x2934)"},
{0x1002, 0x665C, 0x1462, 0x2938, "Radeon R9 360 OEM(0x1462-0x2938)"},
{0x1002, 0x665C, 0x148C, 0x0907, "Radeon R7 360(0x148C-0x0907)"},
{0x1002, 0x665C, 0x148C, 0x9260, "Radeon R9 260 OEM(0x148C-0x9260)"},
{0x1002, 0x665C, 0x148C, 0x9360, "Radeon R9 360 OEM(0x148C-0x9360)"},
{0x1002, 0x665C, 0x1682, 0x0907, "Radeon R7 360(0x1682-0x0907)"},
{0x1002, 0x665C, 0x1682, 0x3310, "Radeon HD 7790 Black Edition 2 GB(0x1682-0x3310)"},
{0x1002, 0x665C, 0x174B, 0xE253, "Radeon HD 7790 Dual-X OC(0x174B-0xE253)"},
{0x1002, 0x665C, 0x1787, 0x2329, "Radeon HD 7790 TurboDuo(0x1787-0x2329)"},
{0x1002, 0x665D, 0xFFFF, 0xFFFF, "Bonaire [Radeon R7 200 Series](0x665D)"},
{0x1002, 0x665F, 0xFFFF, 0xFFFF, "Tobago PRO [Radeon R7 360 / R9 360 OEM](0x665F)"},
{0x1002, 0x665F, 0x1028, 0x0B04, "Radeon R9 360 OEM(0x1028-0x0B04)"},
{0x1002, 0x665F, 0x1462, 0x2938, "Radeon R9 360 OEM(0x1462-0x2938)"},
{0x1002, 0x665F, 0x1462, 0x3271, "Radeon R9 360 OEM(0x1462-0x3271)"},
{0x1002, 0x665F, 0x1682, 0x7360, "Radeon R7 360(0x1682-0x7360)"},
{0x1002, 0x6660, 0xFFFF, 0xFFFF, "Sun XT [Radeon HD 8670A/8670M/8690M / R5 M330 / M430 / Radeon 520 Mobile](0x6660)"},
{0x1002, 0x6660, 0x1028, 0x05EA, "Radeon HD 8670M(0x1028-0x05EA)"},
{0x1002, 0x6660, 0x1028, 0x06BF, "Radeon R5 M335(0x1028-0x06BF)"},
{0x1002, 0x6660, 0x103C, 0x1970, "Radeon HD 8670M(0x103C-0x1970)"},
{0x1002, 0x6660, 0x103C, 0x80BE, "Radeon R5 M330(0x103C-0x80BE)"},
{0x1002, 0x6660, 0x103C, 0x8136, "Radeon R5 M330(0x103C-0x8136)"},
{0x1002, 0x6660, 0x103C, 0x8329, "Radeon R7 M520(0x103C-0x8329)"},
{0x1002, 0x6660, 0x17AA, 0x3633, "Radeon R5 A330(0x17AA-0x3633)"},
{0x1002, 0x6660, 0x17AA, 0x3804, "Radeon R5 M330(0x17AA-0x3804)"},
{0x1002, 0x6660, 0x17AA, 0x3809, "Radeon R5 M330(0x17AA-0x3809)"},
{0x1002, 0x6660, 0x17AA, 0x381A, "Radeon R5 M430(0x17AA-0x381A)"},
{0x1002, 0x6660, 0x17AA, 0x390C, "Radeon R5 M330(0x17AA-0x390C)"},
{0x1002, 0x6663, 0xFFFF, 0xFFFF, "Sun PRO [Radeon HD 8570A/8570M](0x6663)"},
{0x1002, 0x6663, 0x1025, 0x0846, "Radeon HD 8570A(0x1025-0x0846)"},
{0x1002, 0x6663, 0x17AA, 0x3805, "Radeon HD 8570M(0x17AA-0x3805)"},
{0x1002, 0x6664, 0xFFFF, 0xFFFF, "Jet XT [Radeon R5 M240](0x6664)"},
{0x1002, 0x6665, 0xFFFF, 0xFFFF, "Jet PRO [Radeon R5 M230 / R7 M260DX / Radeon 520/610 Mobile](0x6665)"},
{0x1002, 0x6665, 0x17AA, 0x1309, "Z50-75 Radeon R7 M260DX(0x17AA-0x1309)"},
{0x1002, 0x6665, 0x17AA, 0x368F, "Radeon R5 A230(0x17AA-0x368F)"},
{0x1002, 0x6667, 0xFFFF, 0xFFFF, "Jet ULT [Radeon R5 M230](0x6667)"},
{0x1002, 0x666F, 0xFFFF, 0xFFFF, "Sun LE [Radeon HD 8550M / R5 M230](0x666F)"},
{0x1002, 0x66A0, 0xFFFF, 0xFFFF, "Vega 20 [Radeon Pro/Radeon Instinct](0x66A0)"},
{0x1002, 0x66A1, 0xFFFF, 0xFFFF, "Vega 20 [Radeon Pro VII/Radeon Instinct MI50 32GB](0x66A1)"},
{0x1002, 0x66A2, 0xFFFF, 0xFFFF, "Vega 20(0x66A2)"},
{0x1002, 0x66A3, 0xFFFF, 0xFFFF, "Vega 20 [Radeon Pro Vega II/Radeon Pro Vega II Duo](0x66A3)"},
{0x1002, 0x66A7, 0xFFFF, 0xFFFF, "Vega 20 [Radeon Pro Vega 20](0x66A7)"},
{0x1002, 0x66AF, 0xFFFF, 0xFFFF, "Vega 20 [Radeon VII](0x66AF)"},
{0x1002, 0x6704, 0xFFFF, 0xFFFF, "Cayman PRO GL [FirePro V7900](0x6704)"},
{0x1002, 0x6707, 0xFFFF, 0xFFFF, "Cayman LE GL [FirePro V5900](0x6707)"},
{0x1002, 0x6718, 0xFFFF, 0xFFFF, "Cayman XT [Radeon HD 6970](0x6718)"},
{0x1002, 0x6719, 0xFFFF, 0xFFFF, "Cayman PRO [Radeon HD 6950](0x6719)"},
{0x1002, 0x671C, 0xFFFF, 0xFFFF, "Antilles [Radeon HD 6990](0x671C)"},
{0x1002, 0x671D, 0xFFFF, 0xFFFF, "Antilles [Radeon HD 6990](0x671D)"},
{0x1002, 0x671F, 0xFFFF, 0xFFFF, "Cayman CE [Radeon HD 6930](0x671F)"},
{0x1002, 0x6720, 0xFFFF, 0xFFFF, "Blackcomb [Radeon HD 6970M/6990M](0x6720)"},
{0x1002, 0x6720, 0x1028, 0x048F, "Radeon HD 6990M(0x1028-0x048F)"},
{0x1002, 0x6720, 0x1028, 0x0490, "Alienware M17x R3 Radeon HD 6970M(0x1028-0x0490)"},
{0x1002, 0x6720, 0x1028, 0x04A4, "FirePro M8900(0x1028-0x04A4)"},
{0x1002, 0x6720, 0x1028, 0x04BA, "Radeon HD 6990M(0x1028-0x04BA)"},
{0x1002, 0x6720, 0x1028, 0x053F, "FirePro M8900(0x1028-0x053F)"},
{0x1002, 0x6720, 0x106B, 0x0B00, "Radeon HD 6970M(0x106B-0x0B00)"},
{0x1002, 0x6720, 0x1558, 0x5102, "Radeon HD 6970M(0x1558-0x5102)"},
{0x1002, 0x6720, 0x1558, 0x5104, "Radeon HD 6990M(0x1558-0x5104)"},
{0x1002, 0x6720, 0x1558, 0x7201, "Radeon HD 6990M(0x1558-0x7201)"},
{0x1002, 0x6720, 0x174B, 0xE188, "Radeon HD 6970M(0x174B-0xE188)"},
{0x1002, 0x6738, 0xFFFF, 0xFFFF, "Barts XT [Radeon HD 6870](0x6738)"},
{0x1002, 0x6738, 0x1682, 0x3103, "Radeon HD 8670(0x1682-0x3103)"},
{0x1002, 0x6738, 0x1787, 0x201A, "Barts XT [Radeon HD 6870 X2](0x1787-0x201A)"},
{0x1002, 0x6738, 0x1787, 0x201B, "Barts XT [Radeon HD 6870 X2](0x1787-0x201B)"},
{0x1002, 0x6739, 0xFFFF, 0xFFFF, "Barts PRO [Radeon HD 6850](0x6739)"},
{0x1002, 0x6739, 0x1043, 0x03B4, "EAH6850 [Radeon HD 6850](0x1043-0x03B4)"},
{0x1002, 0x673E, 0xFFFF, 0xFFFF, "Barts LE [Radeon HD 6790](0x673E)"},
{0x1002, 0x673E, 0x148C, 0x7720, "Radeon HD 7720 OEM(0x148C-0x7720)"},
{0x1002, 0x6740, 0xFFFF, 0xFFFF, "Whistler [Radeon HD 6730M/6770M/7690M XT](0x6740)"},
{0x1002, 0x6740, 0x1019, 0x238C, "Radeon HD 6730M(0x1019-0x238C)"},
{0x1002, 0x6740, 0x1019, 0x238E, "Radeon HD 6730M(0x1019-0x238E)"},
{0x1002, 0x6740, 0x1019, 0x2391, "Radeon HD 6730M(0x1019-0x2391)"},
{0x1002, 0x6740, 0x1019, 0x2392, "Radeon HD 6770M(0x1019-0x2392)"},
{0x1002, 0x6740, 0x1028, 0x04A3, "Precision M4600(0x1028-0x04A3)"},
{0x1002, 0x6740, 0x1028, 0x053E, "FirePro M5950(0x1028-0x053E)"},
{0x1002, 0x6740, 0x103C, 0x1630, "FirePro M5950(0x103C-0x1630)"},
{0x1002, 0x6740, 0x103C, 0x1631, "FirePro M5950(0x103C-0x1631)"},
{0x1002, 0x6740, 0x103C, 0x164B, "Radeon HD 6730M(0x103C-0x164B)"},
{0x1002, 0x6740, 0x103C, 0x164E, "Radeon HD 6730M(0x103C-0x164E)"},
{0x1002, 0x6740, 0x103C, 0x1657, "Radeon HD 6770M(0x103C-0x1657)"},
{0x1002, 0x6740, 0x103C, 0x1658, "Radeon HD 6770M(0x103C-0x1658)"},
{0x1002, 0x6740, 0x103C, 0x165A, "Radeon HD 6770M(0x103C-0x165A)"},
{0x1002, 0x6740, 0x103C, 0x165B, "Radeon HD 6770M(0x103C-0x165B)"},
{0x1002, 0x6740, 0x103C, 0x1688, "Radeon HD 6770M(0x103C-0x1688)"},
{0x1002, 0x6740, 0x103C, 0x1689, "Radeon HD 6770M(0x103C-0x1689)"},
{0x1002, 0x6740, 0x103C, 0x168A, "Radeon HD 6770M(0x103C-0x168A)"},
{0x1002, 0x6740, 0x103C, 0x185E, "Radeon HD 7690M XT(0x103C-0x185E)"},
{0x1002, 0x6740, 0x103C, 0x3388, "Radeon HD 6770M(0x103C-0x3388)"},
{0x1002, 0x6740, 0x103C, 0x3389, "Radeon HD 6770M(0x103C-0x3389)"},
{0x1002, 0x6740, 0x103C, 0x3582, "Radeon HD 6770M(0x103C-0x3582)"},
{0x1002, 0x6740, 0x103C, 0x366C, "Radeon HD 6730M(0x103C-0x366C)"},
{0x1002, 0x6740, 0x1043, 0x1D02, "Radeon HD 6730M(0x1043-0x1D02)"},
{0x1002, 0x6740, 0x1043, 0x1D12, "Radeon HD 6730M(0x1043-0x1D12)"},
{0x1002, 0x6740, 0x104D, 0x9084, "Radeon HD 6730M(0x104D-0x9084)"},
{0x1002, 0x6740, 0x104D, 0x9085, "Radeon HD 6730M(0x104D-0x9085)"},
{0x1002, 0x6740, 0x144D, 0xB074, "Radeon HD 6730M(0x144D-0xB074)"},
{0x1002, 0x6740, 0x144D, 0xB077, "Radeon HD 6730M(0x144D-0xB077)"},
{0x1002, 0x6740, 0x144D, 0xB084, "Radeon HD 6730M(0x144D-0xB084)"},
{0x1002, 0x6740, 0x144D, 0xB088, "Radeon HD 6730M(0x144D-0xB088)"},
{0x1002, 0x6740, 0x17AA, 0x3982, "Radeon HD 6730M(0x17AA-0x3982)"},
{0x1002, 0x6741, 0xFFFF, 0xFFFF, "Whistler [Radeon HD 6630M/6650M/6750M/7670M/7690M](0x6741)"},
{0x1002, 0x6741, 0x1019, 0x238E, "Radeon HD 6650M(0x1019-0x238E)"},
{0x1002, 0x6741, 0x1019, 0x238F, "Radeon HD 6650M(0x1019-0x238F)"},
{0x1002, 0x6741, 0x1025, 0x0379, "Radeon HD 6650M(0x1025-0x0379)"},
{0x1002, 0x6741, 0x1025, 0x037B, "Radeon HD 6650M(0x1025-0x037B)"},
{0x1002, 0x6741, 0x1025, 0x037E, "Radeon HD 6650M(0x1025-0x037E)"},
{0x1002, 0x6741, 0x1025, 0x0382, "Radeon HD 6650M(0x1025-0x0382)"},
{0x1002, 0x6741, 0x1025, 0x0384, "Radeon HD 6650M(0x1025-0x0384)"},
{0x1002, 0x6741, 0x1025, 0x0385, "Radeon HD 6650M(0x1025-0x0385)"},
{0x1002, 0x6741, 0x1025, 0x0386, "Radeon HD 6650M(0x1025-0x0386)"},
{0x1002, 0x6741, 0x1025, 0x0387, "Radeon HD 6650M(0x1025-0x0387)"},
{0x1002, 0x6741, 0x1025, 0x0388, "Radeon HD 6650M(0x1025-0x0388)"},
{0x1002, 0x6741, 0x1025, 0x0442, "Radeon HD 6650M(0x1025-0x0442)"},
{0x1002, 0x6741, 0x1025, 0x0451, "Radeon HD 6650M(0x1025-0x0451)"},
{0x1002, 0x6741, 0x1025, 0x0489, "Radeon HD 6650M(0x1025-0x0489)"},
{0x1002, 0x6741, 0x1025, 0x048B, "Radeon HD 6650M(0x1025-0x048B)"},
{0x1002, 0x6741, 0x1025, 0x048C, "Radeon HD 6650M(0x1025-0x048C)"},
{0x1002, 0x6741, 0x1025, 0x050A, "Radeon HD 6650M(0x1025-0x050A)"},
{0x1002, 0x6741, 0x1025, 0x050B, "Radeon HD 6650M(0x1025-0x050B)"},
{0x1002, 0x6741, 0x1025, 0x050C, "Radeon HD 6650M(0x1025-0x050C)"},
{0x1002, 0x6741, 0x1025, 0x050E, "Radeon HD 6650M(0x1025-0x050E)"},
{0x1002, 0x6741, 0x1025, 0x050F, "Radeon HD 6650M(0x1025-0x050F)"},
{0x1002, 0x6741, 0x1025, 0x0513, "Radeon HD 6650M(0x1025-0x0513)"},
{0x1002, 0x6741, 0x1025, 0x0514, "Radeon HD 6650M(0x1025-0x0514)"},
{0x1002, 0x6741, 0x1025, 0x0515, "Radeon HD 6650M(0x1025-0x0515)"},
{0x1002, 0x6741, 0x1025, 0x0516, "Radeon HD 6650M(0x1025-0x0516)"},
{0x1002, 0x6741, 0x1025, 0x051E, "Radeon HD 6650M(0x1025-0x051E)"},
{0x1002, 0x6741, 0x1025, 0x051F, "Radeon HD 6650M(0x1025-0x051F)"},
{0x1002, 0x6741, 0x1025, 0x0520, "Radeon HD 6650M(0x1025-0x0520)"},
{0x1002, 0x6741, 0x1025, 0x0521, "Radeon HD 6650M(0x1025-0x0521)"},
{0x1002, 0x6741, 0x1025, 0x052A, "Radeon HD 6650M(0x1025-0x052A)"},
{0x1002, 0x6741, 0x1025, 0x0555, "Radeon HD 6650M(0x1025-0x0555)"},
{0x1002, 0x6741, 0x1025, 0x0556, "Radeon HD 6650M(0x1025-0x0556)"},
{0x1002, 0x6741, 0x1025, 0x055D, "Radeon HD 6650M(0x1025-0x055D)"},
{0x1002, 0x6741, 0x1025, 0x055E, "Radeon HD 6650M(0x1025-0x055E)"},
{0x1002, 0x6741, 0x1025, 0x056D, "Radeon HD 6650M(0x1025-0x056D)"},
{0x1002, 0x6741, 0x1025, 0x059A, "Radeon HD 6650M(0x1025-0x059A)"},
{0x1002, 0x6741, 0x1025, 0x059B, "Radeon HD 6650M(0x1025-0x059B)"},
{0x1002, 0x6741, 0x1025, 0x059E, "Radeon HD 6650M(0x1025-0x059E)"},
{0x1002, 0x6741, 0x1025, 0x059F, "Radeon HD 6650M(0x1025-0x059F)"},
{0x1002, 0x6741, 0x1025, 0x0600, "Radeon HD 6650M(0x1025-0x0600)"},
{0x1002, 0x6741, 0x1025, 0x0605, "Radeon HD 6650M(0x1025-0x0605)"},
{0x1002, 0x6741, 0x1025, 0x0606, "Radeon HD 6650M(0x1025-0x0606)"},
{0x1002, 0x6741, 0x1025, 0x0619, "Radeon HD 6650M(0x1025-0x0619)"},
{0x1002, 0x6741, 0x1028, 0x04C1, "Radeon HD 6630M(0x1028-0x04C1)"},
{0x1002, 0x6741, 0x1028, 0x04C5, "Radeon HD 6630M(0x1028-0x04C5)"},
{0x1002, 0x6741, 0x1028, 0x04CD, "Radeon HD 6630M(0x1028-0x04CD)"},
{0x1002, 0x6741, 0x1028, 0x04D7, "Radeon HD 6630M(0x1028-0x04D7)"},
{0x1002, 0x6741, 0x1028, 0x04D9, "Radeon HD 6630M(0x1028-0x04D9)"},
{0x1002, 0x6741, 0x1028, 0x052D, "Radeon HD 6630M(0x1028-0x052D)"},
{0x1002, 0x6741, 0x103C, 0x1617, "Radeon HD 6650M(0x103C-0x1617)"},
{0x1002, 0x6741, 0x103C, 0x1646, "Radeon HD 6750M(0x103C-0x1646)"},
{0x1002, 0x6741, 0x103C, 0x1647, "Radeon HD 6650M(0x103C-0x1647)"},
{0x1002, 0x6741, 0x103C, 0x164B, "Radeon HD 6650M(0x103C-0x164B)"},
{0x1002, 0x6741, 0x103C, 0x164E, "Radeon HD 6650M(0x103C-0x164E)"},
{0x1002, 0x6741, 0x103C, 0x1688, "Radeon HD 6750M(0x103C-0x1688)"},
{0x1002, 0x6741, 0x103C, 0x1689, "Radeon HD 6750M(0x103C-0x1689)"},
{0x1002, 0x6741, 0x103C, 0x168A, "Radeon HD 6750M(0x103C-0x168A)"},
{0x1002, 0x6741, 0x103C, 0x1860, "Radeon HD 7690M(0x103C-0x1860)"},
{0x1002, 0x6741, 0x103C, 0x3385, "Radeon HD 6630M(0x103C-0x3385)"},
{0x1002, 0x6741, 0x103C, 0x3560, "Radeon HD 6750M(0x103C-0x3560)"},
{0x1002, 0x6741, 0x103C, 0x358D, "Radeon HD 6750M(0x103C-0x358D)"},
{0x1002, 0x6741, 0x103C, 0x3590, "Radeon HD 6750M(0x103C-0x3590)"},
{0x1002, 0x6741, 0x103C, 0x3593, "Radeon HD 6750M(0x103C-0x3593)"},
{0x1002, 0x6741, 0x103C, 0x366C, "Radeon HD 6650M(0x103C-0x366C)"},
{0x1002, 0x6741, 0x1043, 0x1CD2, "Radeon HD 6650M(0x1043-0x1CD2)"},
{0x1002, 0x6741, 0x1043, 0x2121, "Radeon HD 6650M(0x1043-0x2121)"},
{0x1002, 0x6741, 0x1043, 0x2122, "Radeon HD 6650M(0x1043-0x2122)"},
{0x1002, 0x6741, 0x1043, 0x2123, "Radeon HD 6650M(0x1043-0x2123)"},
{0x1002, 0x6741, 0x1043, 0x2125, "Radeon HD 7670M(0x1043-0x2125)"},
{0x1002, 0x6741, 0x1043, 0x2127, "Radeon HD 7670M(0x1043-0x2127)"},
{0x1002, 0x6741, 0x104D, 0x907B, "Radeon HD 6630M(0x104D-0x907B)"},
{0x1002, 0x6741, 0x104D, 0x9080, "Radeon HD 6630M(0x104D-0x9080)"},
{0x1002, 0x6741, 0x104D, 0x9081, "Radeon HD 6630M(0x104D-0x9081)"},
{0x1002, 0x6741, 0x106B, 0x00E2, "MacBookPro8,2 [Core i7, 15\", Late 2011](0x106B-0x00E2)"},
{0x1002, 0x6741, 0x1179, 0xFD63, "Radeon HD 6630M(0x1179-0xFD63)"},
{0x1002, 0x6741, 0x1179, 0xFD65, "Radeon HD 6630M(0x1179-0xFD65)"},
{0x1002, 0x6741, 0x144D, 0xC093, "Radeon HD 6650M(0x144D-0xC093)"},
{0x1002, 0x6741, 0x144D, 0xC0AC, "Radeon HD 6650M(0x144D-0xC0AC)"},
{0x1002, 0x6741, 0x144D, 0xC0B3, "Radeon HD 6750M(0x144D-0xC0B3)"},
{0x1002, 0x6741, 0x144D, 0xC539, "Radeon HD 6630M(0x144D-0xC539)"},
{0x1002, 0x6741, 0x144D, 0xC609, "Radeon HD 6630M(0x144D-0xC609)"},
{0x1002, 0x6741, 0x152D, 0x0914, "Radeon HD 6650M(0x152D-0x0914)"},
{0x1002, 0x6741, 0x17AA, 0x21E1, "Radeon HD 6630M(0x17AA-0x21E1)"},
{0x1002, 0x6741, 0x17AA, 0x3970, "Radeon HD 6650M(0x17AA-0x3970)"},
{0x1002, 0x6741, 0x17AA, 0x3976, "Radeon HD 6650M(0x17AA-0x3976)"},
{0x1002, 0x6741, 0x1854, 0x0907, "Radeon HD 6650M(0x1854-0x0907)"},
{0x1002, 0x6742, 0xFFFF, 0xFFFF, "Whistler LE [Radeon HD 6610M/7610M](0x6742)"},
{0x1002, 0x6742, 0x1002, 0x6570, "Turks [Radeon HD 6570](0x1002-0x6570)"},
{0x1002, 0x6742, 0x1019, 0x2393, "Radeon HD 6610M(0x1019-0x2393)"},
{0x1002, 0x6742, 0x1043, 0x1D82, "K53SK Laptop Radeon HD 7610M(0x1043-0x1D82)"},
{0x1002, 0x6742, 0x1179, 0xFB22, "Radeon HD 7610M(0x1179-0xFB22)"},
{0x1002, 0x6742, 0x1179, 0xFB23, "Radeon HD 7610M(0x1179-0xFB23)"},
{0x1002, 0x6742, 0x1179, 0xFB27, "Radeon HD 7610M(0x1179-0xFB27)"},
{0x1002, 0x6742, 0x1179, 0xFB2A, "Radeon HD 7610M(0x1179-0xFB2A)"},
{0x1002, 0x6742, 0x1179, 0xFB2C, "Radeon HD 7610M(0x1179-0xFB2C)"},
{0x1002, 0x6742, 0x1179, 0xFB30, "Radeon HD 7610M(0x1179-0xFB30)"},
{0x1002, 0x6742, 0x1179, 0xFB31, "Radeon HD 7610M(0x1179-0xFB31)"},
{0x1002, 0x6742, 0x1179, 0xFB32, "Radeon HD 7610M(0x1179-0xFB32)"},
{0x1002, 0x6742, 0x1179, 0xFB38, "Radeon HD 7610M(0x1179-0xFB38)"},
{0x1002, 0x6742, 0x1179, 0xFB39, "Radeon HD 7610M(0x1179-0xFB39)"},
{0x1002, 0x6742, 0x1179, 0xFB3A, "Radeon HD 7610M(0x1179-0xFB3A)"},
{0x1002, 0x6742, 0x1179, 0xFB3B, "Radeon HD 7610M(0x1179-0xFB3B)"},
{0x1002, 0x6742, 0x1179, 0xFB40, "Radeon HD 7610M(0x1179-0xFB40)"},
{0x1002, 0x6742, 0x1179, 0xFB41, "Radeon HD 7610M(0x1179-0xFB41)"},
{0x1002, 0x6742, 0x1179, 0xFB47, "Radeon HD 7610M(0x1179-0xFB47)"},
{0x1002, 0x6742, 0x1179, 0xFB48, "Radeon HD 7610M(0x1179-0xFB48)"},
{0x1002, 0x6742, 0x1179, 0xFB49, "Radeon HD 7610M(0x1179-0xFB49)"},
{0x1002, 0x6742, 0x1179, 0xFB51, "Radeon HD 7610M(0x1179-0xFB51)"},
{0x1002, 0x6742, 0x1179, 0xFB52, "Radeon HD 7610M(0x1179-0xFB52)"},
{0x1002, 0x6742, 0x1179, 0xFB53, "Radeon HD 7610M(0x1179-0xFB53)"},
{0x1002, 0x6742, 0x1179, 0xFB56, "Radeon HD 7610M(0x1179-0xFB56)"},
{0x1002, 0x6742, 0x1179, 0xFB81, "Radeon HD 7610M(0x1179-0xFB81)"},
{0x1002, 0x6742, 0x1179, 0xFB82, "Radeon HD 7610M(0x1179-0xFB82)"},
{0x1002, 0x6742, 0x1179, 0xFB83, "Radeon HD 7610M(0x1179-0xFB83)"},
{0x1002, 0x6742, 0x1179, 0xFC56, "Radeon HD 7610M(0x1179-0xFC56)"},
{0x1002, 0x6742, 0x1179, 0xFCD4, "Radeon HD 7610M(0x1179-0xFCD4)"},
{0x1002, 0x6742, 0x1179, 0xFCEE, "Radeon HD 7610M(0x1179-0xFCEE)"},
{0x1002, 0x6742, 0x1458, 0x6570, "Turks [Radeon HD 6570](0x1458-0x6570)"},
{0x1002, 0x6742, 0x1462, 0x6570, "Turks [Radeon HD 6570](0x1462-0x6570)"},
{0x1002, 0x6742, 0x148C, 0x6570, "Turks [Radeon HD 6570](0x148C-0x6570)"},
{0x1002, 0x6742, 0x1682, 0x6570, "Turks [Radeon HD 6570](0x1682-0x6570)"},
{0x1002, 0x6742, 0x174B, 0x5570, "Turks [Radeon HD 5570](0x174B-0x5570)"},
{0x1002, 0x6742, 0x174B, 0x6570, "Turks [Radeon HD 6570](0x174B-0x6570)"},
{0x1002, 0x6742, 0x174B, 0x7570, "Turks [Radeon HD 7570](0x174B-0x7570)"},
{0x1002, 0x6742, 0x174B, 0x8510, "Turks [Radeon HD 8510](0x174B-0x8510)"},
{0x1002, 0x6742, 0x174B, 0x8570, "Turks [Radeon HD 8570](0x174B-0x8570)"},
{0x1002, 0x6742, 0x1787, 0x6570, "Turks [Radeon HD 6570](0x1787-0x6570)"},
{0x1002, 0x6742, 0x17AF, 0x6570, "Turks [Radeon HD 6570](0x17AF-0x6570)"},
{0x1002, 0x6742, 0x8086, 0x2111, "Radeon HD 6625M(0x8086-0x2111)"},
{0x1002, 0x6743, 0xFFFF, 0xFFFF, "Whistler [Radeon E6760](0x6743)"},
{0x1002, 0x6749, 0xFFFF, 0xFFFF, "Turks GL [FirePro V4900](0x6749)"},
{0x1002, 0x6749, 0x15C3, 0x2B06, "MED-X4900 (EIZO)(0x15C3-0x2B06)"},
{0x1002, 0x674A, 0xFFFF, 0xFFFF, "Turks GL [FirePro V3900](0x674A)"},
{0x1002, 0x674A, 0x13CC, 0x3D22, "MXRT-2500(0x13CC-0x3D22)"},
{0x1002, 0x674A, 0x15C3, 0x0106, "MED-X3900(0x15C3-0x0106)"},
{0x1002, 0x6750, 0xFFFF, 0xFFFF, "Onega [Radeon HD 6650A/7650A](0x6750)"},
{0x1002, 0x6750, 0x1462, 0x2670, "Radeon HD 6670A(0x1462-0x2670)"},
{0x1002, 0x6750, 0x17AA, 0x3079, "Radeon HD 7650A(0x17AA-0x3079)"},
{0x1002, 0x6750, 0x17AA, 0x307A, "Radeon HD 6650A(0x17AA-0x307A)"},
{0x1002, 0x6750, 0x17AA, 0x3087, "Radeon HD 7650A(0x17AA-0x3087)"},
{0x1002, 0x6750, 0x17AA, 0x3618, "Radeon HD 6650A(0x17AA-0x3618)"},
{0x1002, 0x6750, 0x17AA, 0x3623, "Radeon HD 6650A(0x17AA-0x3623)"},
{0x1002, 0x6750, 0x17AA, 0x3627, "Radeon HD 6650A(0x17AA-0x3627)"},
{0x1002, 0x6751, 0xFFFF, 0xFFFF, "Turks [Radeon HD 7650A/7670A](0x6751)"},
{0x1002, 0x6751, 0x1028, 0x0548, "Radeon HD 7650A(0x1028-0x0548)"},
{0x1002, 0x6751, 0x1462, 0x2671, "Radeon HD 7670A(0x1462-0x2671)"},
{0x1002, 0x6751, 0x1462, 0x2672, "Radeon HD 7670A(0x1462-0x2672)"},
{0x1002, 0x6751, 0x1462, 0x2680, "Radeon HD 7650A(0x1462-0x2680)"},
{0x1002, 0x6751, 0x1462, 0x2681, "Radeon HD 7650A(0x1462-0x2681)"},
{0x1002, 0x6751, 0x17AA, 0x3087, "Radeon HD 7650A(0x17AA-0x3087)"},
{0x1002, 0x6758, 0xFFFF, 0xFFFF, "Turks XT [Radeon HD 6670/7670](0x6758)"},
{0x1002, 0x6758, 0x1028, 0x0B0E, "Radeon HD 6670(0x1028-0x0B0E)"},
{0x1002, 0x6758, 0x103C, 0x6882, "Radeon HD 6670(0x103C-0x6882)"},
{0x1002, 0x6758, 0x1462, 0x250A, "Radeon HD 7670(0x1462-0x250A)"},
{0x1002, 0x6758, 0x148C, 0x7670, "Radeon HD 7670(0x148C-0x7670)"},
{0x1002, 0x6758, 0x1545, 0x7670, "Radeon HD 7670(0x1545-0x7670)"},
{0x1002, 0x6758, 0x1682, 0x3300, "Radeon HD 7670(0x1682-0x3300)"},
{0x1002, 0x6758, 0x174B, 0x7670, "Radeon HD 7670(0x174B-0x7670)"},
{0x1002, 0x6758, 0x174B, 0xE181, "Radeon HD 6670(0x174B-0xE181)"},
{0x1002, 0x6758, 0x1787, 0x2309, "Radeon HD 6670(0x1787-0x2309)"},
{0x1002, 0x6759, 0xFFFF, 0xFFFF, "Turks PRO [Radeon HD 6570/7570/8550 / R5 230](0x6759)"},
{0x1002, 0x6759, 0x103C, 0x3130, "Radeon HD 6570(0x103C-0x3130)"},
{0x1002, 0x6759, 0x1043, 0x0403, "Radeon HD 6570(0x1043-0x0403)"},
{0x1002, 0x6759, 0x1462, 0x2500, "Radeon HD 6570(0x1462-0x2500)"},
{0x1002, 0x6759, 0x1462, 0x2509, "Radeon HD 7570(0x1462-0x2509)"},
{0x1002, 0x6759, 0x148C, 0x7570, "Radeon HD 7570(0x148C-0x7570)"},
{0x1002, 0x6759, 0x1642, 0x3A67, "Radeon HD 6570(0x1642-0x3A67)"},
{0x1002, 0x6759, 0x1682, 0x3280, "Radeon HD 7570(0x1682-0x3280)"},
{0x1002, 0x6759, 0x1682, 0x3530, "Radeon HD 8550(0x1682-0x3530)"},
{0x1002, 0x6759, 0x1682, 0x5230, "Radeon R5 230 series(0x1682-0x5230)"},
{0x1002, 0x6759, 0x1682, 0x6450, "Radeon HD 6450 series(0x1682-0x6450)"},
{0x1002, 0x6759, 0x174B, 0x7570, "Radeon HD 7570(0x174B-0x7570)"},
{0x1002, 0x6759, 0x174B, 0x8550, "Radeon HD8550 OEM(0x174B-0x8550)"},
{0x1002, 0x6759, 0x174B, 0x8570, "Radeon HD8550 OEM(0x174B-0x8570)"},
{0x1002, 0x6759, 0x174B, 0xE142, "Radeon HD 6570(0x174B-0xE142)"},
{0x1002, 0x6759, 0x174B, 0xE181, "Radeon HD 6570(0x174B-0xE181)"},
{0x1002, 0x6759, 0x1787, 0xA230, "Radeon R5 230 series(0x1787-0xA230)"},
{0x1002, 0x6759, 0x1787, 0xA450, "Radeon HD 6450 series(0x1787-0xA450)"},
{0x1002, 0x6759, 0x1B0A, 0x908F, "Radeon HD 6570(0x1B0A-0x908F)"},
{0x1002, 0x6759, 0x1B0A, 0x9090, "Radeon HD 6570(0x1B0A-0x9090)"},
{0x1002, 0x6759, 0x1B0A, 0x9091, "Radeon HD 6570(0x1B0A-0x9091)"},
{0x1002, 0x6759, 0x1B0A, 0x9092, "Radeon HD 6570(0x1B0A-0x9092)"},
{0x1002, 0x6759, 0x1B0A, 0x909E, "Radeon HD 6570(0x1B0A-0x909E)"},
{0x1002, 0x6759, 0x1B0A, 0x90B5, "Radeon HD 7570(0x1B0A-0x90B5)"},
{0x1002, 0x6759, 0x1B0A, 0x90B6, "Radeon HD 7570(0x1B0A-0x90B6)"},
{0x1002, 0x675B, 0xFFFF, 0xFFFF, "Turks [Radeon HD 7600 Series](0x675B)"},
{0x1002, 0x675D, 0xFFFF, 0xFFFF, "Turks PRO [Radeon HD 7570](0x675D)"},
{0x1002, 0x675F, 0xFFFF, 0xFFFF, "Turks LE [Radeon HD 5570/6510/7510/8510](0x675F)"},
{0x1002, 0x675F, 0x148C, 0x6510, "Radeon HD 6510(0x148C-0x6510)"},
{0x1002, 0x675F, 0x148C, 0x6530, "Radeon HD 6530(0x148C-0x6530)"},
{0x1002, 0x675F, 0x148C, 0x7510, "Radeon HD 7510(0x148C-0x7510)"},
{0x1002, 0x675F, 0x1545, 0x7570, "Radeon HD 7570(0x1545-0x7570)"},
{0x1002, 0x675F, 0x174B, 0x6510, "Radeon HD 6510(0x174B-0x6510)"},
{0x1002, 0x675F, 0x174B, 0x7510, "Radeon HD 7510(0x174B-0x7510)"},
{0x1002, 0x675F, 0x174B, 0x8510, "Radeon HD 8510(0x174B-0x8510)"},
{0x1002, 0x675F, 0x1787, 0x2012, "Radeon HD 5570 2GB GDDR3(0x1787-0x2012)"},
{0x1002, 0x675F, 0x1787, 0x2314, "Radeon HD 5570 1GB DDR2/GDDR3(0x1787-0x2314)"},
{0x1002, 0x6760, 0xFFFF, 0xFFFF, "Seymour [Radeon HD 6400M/7400M Series](0x6760)"},
{0x1002, 0x6760, 0x1002, 0x0124, "Radeon HD 6470M(0x1002-0x0124)"},
{0x1002, 0x6760, 0x1002, 0x0134, "Radeon HD 6470M(0x1002-0x0134)"},
{0x1002, 0x6760, 0x1019, 0x238B, "Radeon HD 6470M(0x1019-0x238B)"},
{0x1002, 0x6760, 0x1019, 0x238E, "Radeon HD 6470M(0x1019-0x238E)"},
{0x1002, 0x6760, 0x1019, 0x2390, "Radeon HD 6470M(0x1019-0x2390)"},
{0x1002, 0x6760, 0x1019, 0x9985, "Radeon HD 6470M(0x1019-0x9985)"},
{0x1002, 0x6760, 0x1028, 0x04C1, "Radeon HD 6470M(0x1028-0x04C1)"},
{0x1002, 0x6760, 0x1028, 0x04C3, "Radeon HD 6470M(0x1028-0x04C3)"},
{0x1002, 0x6760, 0x1028, 0x04CA, "Radeon HD 6470M(0x1028-0x04CA)"},
{0x1002, 0x6760, 0x1028, 0x04CB, "Radeon HD 6470M(0x1028-0x04CB)"},
{0x1002, 0x6760, 0x1028, 0x04CC, "Vostro 3350(0x1028-0x04CC)"},
{0x1002, 0x6760, 0x1028, 0x04D1, "Radeon HD 6470M(0x1028-0x04D1)"},
{0x1002, 0x6760, 0x1028, 0x04D3, "Radeon HD 6470M(0x1028-0x04D3)"},
{0x1002, 0x6760, 0x1028, 0x04D7, "Radeon HD 6470M(0x1028-0x04D7)"},
{0x1002, 0x6760, 0x1028, 0x0502, "Radeon HD 6470M(0x1028-0x0502)"},
{0x1002, 0x6760, 0x1028, 0x0503, "Radeon HD 6470M(0x1028-0x0503)"},
{0x1002, 0x6760, 0x1028, 0x0506, "Radeon HD 6470M(0x1028-0x0506)"},
{0x1002, 0x6760, 0x1028, 0x0507, "Radeon HD 6470M(0x1028-0x0507)"},
{0x1002, 0x6760, 0x1028, 0x0514, "Radeon HD 6470M(0x1028-0x0514)"},
{0x1002, 0x6760, 0x1028, 0x051C, "Radeon HD 6450M / 7430M(0x1028-0x051C)"},
{0x1002, 0x6760, 0x1028, 0x051D, "Radeon HD 6450M / 7430M(0x1028-0x051D)"},
{0x1002, 0x6760, 0x103C, 0x161A, "Radeon HD 6470M(0x103C-0x161A)"},
{0x1002, 0x6760, 0x103C, 0x161B, "Radeon HD 6470M(0x103C-0x161B)"},
{0x1002, 0x6760, 0x103C, 0x161E, "Radeon HD 6470M(0x103C-0x161E)"},
{0x1002, 0x6760, 0x103C, 0x161F, "Radeon HD 6470M(0x103C-0x161F)"},
{0x1002, 0x6760, 0x103C, 0x1622, "Radeon HD 6450M(0x103C-0x1622)"},
{0x1002, 0x6760, 0x103C, 0x1623, "Radeon HD 6450M(0x103C-0x1623)"},
{0x1002, 0x6760, 0x103C, 0x164A, "Radeon HD 6470M(0x103C-0x164A)"},
{0x1002, 0x6760, 0x103C, 0x164D, "Radeon HD 6470M(0x103C-0x164D)"},
{0x1002, 0x6760, 0x103C, 0x1651, "Radeon HD 6470M(0x103C-0x1651)"},
{0x1002, 0x6760, 0x103C, 0x1656, "Radeon HD 6490M(0x103C-0x1656)"},
{0x1002, 0x6760, 0x103C, 0x1658, "Radeon HD 6490M(0x103C-0x1658)"},
{0x1002, 0x6760, 0x103C, 0x1659, "Radeon HD 6490M(0x103C-0x1659)"},
{0x1002, 0x6760, 0x103C, 0x165B, "Radeon HD 6490M(0x103C-0x165B)"},
{0x1002, 0x6760, 0x103C, 0x165D, "Radeon HD 6470M(0x103C-0x165D)"},
{0x1002, 0x6760, 0x103C, 0x165F, "Radeon HD 6470M(0x103C-0x165F)"},
{0x1002, 0x6760, 0x103C, 0x1661, "Radeon HD 6470M(0x103C-0x1661)"},
{0x1002, 0x6760, 0x103C, 0x1663, "Radeon HD 6470M(0x103C-0x1663)"},
{0x1002, 0x6760, 0x103C, 0x1665, "Radeon HD 6470M(0x103C-0x1665)"},
{0x1002, 0x6760, 0x103C, 0x1667, "Radeon HD 6470M(0x103C-0x1667)"},
{0x1002, 0x6760, 0x103C, 0x1669, "Radeon HD 6470M(0x103C-0x1669)"},
{0x1002, 0x6760, 0x103C, 0x166B, "Radeon HD 6470M(0x103C-0x166B)"},
{0x1002, 0x6760, 0x103C, 0x166C, "Radeon HD 6470M(0x103C-0x166C)"},
{0x1002, 0x6760, 0x103C, 0x166E, "Radeon HD 6470M(0x103C-0x166E)"},
{0x1002, 0x6760, 0x103C, 0x1670, "Radeon HD 6470M(0x103C-0x1670)"},
{0x1002, 0x6760, 0x103C, 0x1672, "Radeon HD 6470M(0x103C-0x1672)"},
{0x1002, 0x6760, 0x103C, 0x167A, "Radeon HD 6470M(0x103C-0x167A)"},
{0x1002, 0x6760, 0x103C, 0x167B, "Radeon HD 6470M(0x103C-0x167B)"},
{0x1002, 0x6760, 0x103C, 0x167D, "Radeon HD 6490M(0x103C-0x167D)"},
{0x1002, 0x6760, 0x103C, 0x167F, "Radeon HD 6490M(0x103C-0x167F)"},
{0x1002, 0x6760, 0x103C, 0x168C, "Radeon HD 6470M(0x103C-0x168C)"},
{0x1002, 0x6760, 0x103C, 0x168F, "Radeon HD 6470M(0x103C-0x168F)"},
{0x1002, 0x6760, 0x103C, 0x1694, "Radeon HD 6470M(0x103C-0x1694)"},
{0x1002, 0x6760, 0x103C, 0x1696, "Radeon HD 6470M(0x103C-0x1696)"},
{0x1002, 0x6760, 0x103C, 0x1698, "Radeon HD 6470M(0x103C-0x1698)"},
{0x1002, 0x6760, 0x103C, 0x169A, "Radeon HD 6470M(0x103C-0x169A)"},
{0x1002, 0x6760, 0x103C, 0x169C, "Radeon HD 6490M(0x103C-0x169C)"},
{0x1002, 0x6760, 0x103C, 0x1855, "Radeon HD 7450M(0x103C-0x1855)"},
{0x1002, 0x6760, 0x103C, 0x1859, "Radeon HD 7450M(0x103C-0x1859)"},
{0x1002, 0x6760, 0x103C, 0x185C, "Radeon HD 7450M(0x103C-0x185C)"},
{0x1002, 0x6760, 0x103C, 0x185D, "Radeon HD 7470M(0x103C-0x185D)"},
{0x1002, 0x6760, 0x103C, 0x185F, "Radeon HD 7470M(0x103C-0x185F)"},
{0x1002, 0x6760, 0x103C, 0x1863, "Radeon HD 7450M(0x103C-0x1863)"},
{0x1002, 0x6760, 0x103C, 0x355C, "Radeon HD 6490M(0x103C-0x355C)"},
{0x1002, 0x6760, 0x103C, 0x355F, "Radeon HD 6490M(0x103C-0x355F)"},
{0x1002, 0x6760, 0x103C, 0x3563, "Radeon HD 6470M(0x103C-0x3563)"},
{0x1002, 0x6760, 0x103C, 0x3565, "Radeon HD 6470M(0x103C-0x3565)"},
{0x1002, 0x6760, 0x103C, 0x3567, "Radeon HD 6470M(0x103C-0x3567)"},
{0x1002, 0x6760, 0x103C, 0x3569, "Radeon HD 6470M(0x103C-0x3569)"},
{0x1002, 0x6760, 0x103C, 0x3581, "Radeon HD 6490M(0x103C-0x3581)"},
{0x1002, 0x6760, 0x103C, 0x3584, "Radeon HD 6470M(0x103C-0x3584)"},
{0x1002, 0x6760, 0x103C, 0x358C, "Radeon HD 6490M(0x103C-0x358C)"},
{0x1002, 0x6760, 0x103C, 0x358F, "Radeon HD 6490M(0x103C-0x358F)"},
{0x1002, 0x6760, 0x103C, 0x3592, "Radeon HD 6490M(0x103C-0x3592)"},
{0x1002, 0x6760, 0x103C, 0x3596, "Radeon HD 6490M(0x103C-0x3596)"},
{0x1002, 0x6760, 0x103C, 0x366B, "Radeon HD 6470M(0x103C-0x366B)"},
{0x1002, 0x6760, 0x103C, 0x3671, "FirePro M3900(0x103C-0x3671)"},
{0x1002, 0x6760, 0x103C, 0x3673, "Radeon HD 6470M(0x103C-0x3673)"},
{0x1002, 0x6760, 0x1043, 0x100A, "Radeon HD 7470M(0x1043-0x100A)"},
{0x1002, 0x6760, 0x1043, 0x100C, "Radeon HD 6470M(0x1043-0x100C)"},
{0x1002, 0x6760, 0x1043, 0x101B, "Radeon HD 6470M(0x1043-0x101B)"},
{0x1002, 0x6760, 0x1043, 0x101C, "Radeon HD 6470M(0x1043-0x101C)"},
{0x1002, 0x6760, 0x1043, 0x102A, "Radeon HD 7450M(0x1043-0x102A)"},
{0x1002, 0x6760, 0x1043, 0x102C, "Radeon HD 6470M(0x1043-0x102C)"},
{0x1002, 0x6760, 0x1043, 0x104B, "Radeon HD 7470M(0x1043-0x104B)"},
{0x1002, 0x6760, 0x1043, 0x105D, "Radeon HD 7470M(0x1043-0x105D)"},
{0x1002, 0x6760, 0x1043, 0x106B, "Radeon HD 7470M(0x1043-0x106B)"},
{0x1002, 0x6760, 0x1043, 0x106D, "Radeon HD 7470M(0x1043-0x106D)"},
{0x1002, 0x6760, 0x1043, 0x107D, "Radeon HD 7470M(0x1043-0x107D)"},
{0x1002, 0x6760, 0x1043, 0x1CB2, "Radeon HD 6470M(0x1043-0x1CB2)"},
{0x1002, 0x6760, 0x1043, 0x1D22, "Radeon HD 6470M(0x1043-0x1D22)"},
{0x1002, 0x6760, 0x1043, 0x1D32, "Radeon HD 6470M(0x1043-0x1D32)"},
{0x1002, 0x6760, 0x1043, 0x2001, "Radeon HD 6470M(0x1043-0x2001)"},
{0x1002, 0x6760, 0x1043, 0x2002, "Radeon HD 7470M(0x1043-0x2002)"},
{0x1002, 0x6760, 0x1043, 0x2107, "Radeon HD 7470M(0x1043-0x2107)"},
{0x1002, 0x6760, 0x1043, 0x2108, "Radeon HD 7470M(0x1043-0x2108)"},
{0x1002, 0x6760, 0x1043, 0x2109, "Radeon HD 7470M(0x1043-0x2109)"},
{0x1002, 0x6760, 0x1043, 0x84A0, "Radeon HD 6470M(0x1043-0x84A0)"},
{0x1002, 0x6760, 0x1043, 0x84E9, "Radeon HD 6470M(0x1043-0x84E9)"},
{0x1002, 0x6760, 0x1043, 0x8515, "Radeon HD 7470M(0x1043-0x8515)"},
{0x1002, 0x6760, 0x1043, 0x8517, "Radeon HD 7470M(0x1043-0x8517)"},
{0x1002, 0x6760, 0x1043, 0x855A, "Radeon HD 7470M(0x1043-0x855A)"},
{0x1002, 0x6760, 0x104D, 0x907B, "Radeon HD 6470M(0x104D-0x907B)"},
{0x1002, 0x6760, 0x104D, 0x9081, "Radeon HD 6470M(0x104D-0x9081)"},
{0x1002, 0x6760, 0x104D, 0x9084, "Radeon HD 6470M(0x104D-0x9084)"},
{0x1002, 0x6760, 0x104D, 0x9085, "Radeon HD 6470M(0x104D-0x9085)"},
{0x1002, 0x6760, 0x1179, 0x0001, "Radeon HD 6450M(0x1179-0x0001)"},
{0x1002, 0x6760, 0x1179, 0x0003, "Radeon HD 6450M(0x1179-0x0003)"},
{0x1002, 0x6760, 0x1179, 0x0004, "Radeon HD 6450M(0x1179-0x0004)"},
{0x1002, 0x6760, 0x1179, 0xFB22, "Radeon HD 7470M(0x1179-0xFB22)"},
{0x1002, 0x6760, 0x1179, 0xFB23, "Radeon HD 7470M(0x1179-0xFB23)"},
{0x1002, 0x6760, 0x1179, 0xFB2C, "Radeon HD 7470M(0x1179-0xFB2C)"},
{0x1002, 0x6760, 0x1179, 0xFB31, "Radeon HD 7470M(0x1179-0xFB31)"},
{0x1002, 0x6760, 0x1179, 0xFB32, "Radeon HD 7470M(0x1179-0xFB32)"},
{0x1002, 0x6760, 0x1179, 0xFB33, "Radeon HD 7470M(0x1179-0xFB33)"},
{0x1002, 0x6760, 0x1179, 0xFB38, "Radeon HD 7470M(0x1179-0xFB38)"},
{0x1002, 0x6760, 0x1179, 0xFB39, "Radeon HD 7470M(0x1179-0xFB39)"},
{0x1002, 0x6760, 0x1179, 0xFB3A, "Radeon HD 7470M(0x1179-0xFB3A)"},
{0x1002, 0x6760, 0x1179, 0xFB40, "Radeon HD 7470M(0x1179-0xFB40)"},
{0x1002, 0x6760, 0x1179, 0xFB41, "Radeon HD 7470M(0x1179-0xFB41)"},
{0x1002, 0x6760, 0x1179, 0xFB42, "Radeon HD 7470M(0x1179-0xFB42)"},
{0x1002, 0x6760, 0x1179, 0xFB47, "Radeon HD 7470M(0x1179-0xFB47)"},
{0x1002, 0x6760, 0x1179, 0xFB48, "Radeon HD 7470M(0x1179-0xFB48)"},
{0x1002, 0x6760, 0x1179, 0xFB51, "Radeon HD 7470M(0x1179-0xFB51)"},
{0x1002, 0x6760, 0x1179, 0xFB52, "Radeon HD 7470M(0x1179-0xFB52)"},
{0x1002, 0x6760, 0x1179, 0xFB53, "Radeon HD 7470M(0x1179-0xFB53)"},
{0x1002, 0x6760, 0x1179, 0xFB81, "Radeon HD 7470M(0x1179-0xFB81)"},
{0x1002, 0x6760, 0x1179, 0xFB82, "Radeon HD 7470M(0x1179-0xFB82)"},
{0x1002, 0x6760, 0x1179, 0xFB83, "Radeon HD 7470M(0x1179-0xFB83)"},
{0x1002, 0x6760, 0x1179, 0xFC51, "Radeon HD 6470M(0x1179-0xFC51)"},
{0x1002, 0x6760, 0x1179, 0xFC52, "Radeon HD 7470M(0x1179-0xFC52)"},
{0x1002, 0x6760, 0x1179, 0xFC56, "Radeon HD 7470M(0x1179-0xFC56)"},
{0x1002, 0x6760, 0x1179, 0xFCD3, "Radeon HD 7470M(0x1179-0xFCD3)"},
{0x1002, 0x6760, 0x1179, 0xFCD4, "Radeon HD 7470M(0x1179-0xFCD4)"},
{0x1002, 0x6760, 0x1179, 0xFCEE, "Radeon HD 7470M(0x1179-0xFCEE)"},
{0x1002, 0x6760, 0x1179, 0xFDEE, "Radeon HD 7470M(0x1179-0xFDEE)"},
{0x1002, 0x6760, 0x144D, 0xB074, "Radeon HD 6470M(0x144D-0xB074)"},
{0x1002, 0x6760, 0x144D, 0xB084, "Radeon HD 6470M(0x144D-0xB084)"},
{0x1002, 0x6760, 0x144D, 0xC095, "Radeon HD 6470M(0x144D-0xC095)"},
{0x1002, 0x6760, 0x144D, 0xC0B3, "Radeon HD 6490M(0x144D-0xC0B3)"},
{0x1002, 0x6760, 0x144D, 0xC538, "Radeon HD 6470M(0x144D-0xC538)"},
{0x1002, 0x6760, 0x144D, 0xC581, "Radeon HD 6470M(0x144D-0xC581)"},
{0x1002, 0x6760, 0x144D, 0xC589, "Radeon HD 6470M(0x144D-0xC589)"},
{0x1002, 0x6760, 0x144D, 0xC609, "Radeon HD 7470M(0x144D-0xC609)"},
{0x1002, 0x6760, 0x144D, 0xC625, "Radeon HD 7470M(0x144D-0xC625)"},
{0x1002, 0x6760, 0x144D, 0xC636, "Radeon HD 7450M(0x144D-0xC636)"},
{0x1002, 0x6760, 0x1462, 0x10AC, "Radeon HD 6470M(0x1462-0x10AC)"},
{0x1002, 0x6760, 0x152D, 0x0916, "Radeon HD 6470M(0x152D-0x0916)"},
{0x1002, 0x6760, 0x17AA, 0x21E5, "Radeon HD 6470M(0x17AA-0x21E5)"},
{0x1002, 0x6760, 0x17AA, 0x3900, "Radeon HD 7450M(0x17AA-0x3900)"},
{0x1002, 0x6760, 0x17AA, 0x3902, "Radeon HD 7450M(0x17AA-0x3902)"},
{0x1002, 0x6760, 0x17AA, 0x3969, "Radeon HD 6470M(0x17AA-0x3969)"},
{0x1002, 0x6760, 0x17AA, 0x3970, "Radeon HD 7450M(0x17AA-0x3970)"},
{0x1002, 0x6760, 0x17AA, 0x3976, "Radeon HD 6470M(0x17AA-0x3976)"},
{0x1002, 0x6760, 0x17AA, 0x397B, "Radeon HD 6470M(0x17AA-0x397B)"},
{0x1002, 0x6760, 0x17AA, 0x397D, "Radeon HD 6470M(0x17AA-0x397D)"},
{0x1002, 0x6760, 0x17AA, 0x5101, "Radeon HD 7470M(0x17AA-0x5101)"},
{0x1002, 0x6760, 0x17AA, 0x5102, "Radeon HD 7450M(0x17AA-0x5102)"},
{0x1002, 0x6760, 0x17AA, 0x5103, "Radeon HD 7450M(0x17AA-0x5103)"},
{0x1002, 0x6760, 0x17AA, 0x5106, "Radeon HD 7450M(0x17AA-0x5106)"},
{0x1002, 0x6760, 0x1854, 0x0897, "Radeon HD 6470M(0x1854-0x0897)"},
{0x1002, 0x6760, 0x1854, 0x0900, "Radeon HD 6470M(0x1854-0x0900)"},
{0x1002, 0x6760, 0x1854, 0x0908, "Radeon HD 6470M(0x1854-0x0908)"},
{0x1002, 0x6760, 0x1854, 0x2015, "Radeon HD 6470M(0x1854-0x2015)"},
{0x1002, 0x6761, 0xFFFF, 0xFFFF, "Seymour LP [Radeon HD 6430M](0x6761)"},
{0x1002, 0x6763, 0xFFFF, 0xFFFF, "Seymour [Radeon E6460](0x6763)"},
{0x1002, 0x6764, 0xFFFF, 0xFFFF, "Seymour [Radeon HD 6400M Series](0x6764)"},
{0x1002, 0x6765, 0xFFFF, 0xFFFF, "Seymour [Radeon HD 6400M Series](0x6765)"},
{0x1002, 0x6766, 0xFFFF, 0xFFFF, "Caicos(0x6766)"},
{0x1002, 0x6767, 0xFFFF, 0xFFFF, "Caicos(0x6767)"},
{0x1002, 0x6768, 0xFFFF, 0xFFFF, "Caicos(0x6768)"},
{0x1002, 0x6770, 0xFFFF, 0xFFFF, "Caicos [Radeon HD 6450A/7450A](0x6770)"},
{0x1002, 0x6770, 0x17AA, 0x308D, "Radeon HD 7450A(0x17AA-0x308D)"},
{0x1002, 0x6770, 0x17AA, 0x3623, "Radeon HD 6450A(0x17AA-0x3623)"},
{0x1002, 0x6770, 0x17AA, 0x3627, "Radeon HD 6450A(0x17AA-0x3627)"},
{0x1002, 0x6770, 0x17AA, 0x3629, "Radeon HD 6450A(0x17AA-0x3629)"},
{0x1002, 0x6770, 0x17AA, 0x363C, "Radeon HD 6450A(0x17AA-0x363C)"},
{0x1002, 0x6770, 0x17AA, 0x3658, "Radeon HD 7470A(0x17AA-0x3658)"},
{0x1002, 0x6771, 0xFFFF, 0xFFFF, "Caicos XTX [Radeon HD 8490 / R5 235X OEM](0x6771)"},
{0x1002, 0x6772, 0xFFFF, 0xFFFF, "Caicos [Radeon HD 7450A](0x6772)"},
{0x1002, 0x6778, 0xFFFF, 0xFFFF, "Caicos XT [Radeon HD 7470/8470 / R5 235/310 OEM](0x6778)"},
{0x1002, 0x6778, 0x1019, 0x0024, "Radeon HD 7470(0x1019-0x0024)"},
{0x1002, 0x6778, 0x1019, 0x0027, "Radeon HD 8470(0x1019-0x0027)"},
{0x1002, 0x6778, 0x1028, 0x2120, "Radeon HD 7470(0x1028-0x2120)"},
{0x1002, 0x6778, 0x1462, 0xB491, "Radeon HD 8470(0x1462-0xB491)"},
{0x1002, 0x6778, 0x1462, 0xB492, "Radeon HD 8470(0x1462-0xB492)"},
{0x1002, 0x6778, 0x1462, 0xB493, "Radeon HD 8470 OEM(0x1462-0xB493)"},
{0x1002, 0x6778, 0x1462, 0xB499, "Radeon R5 235 OEM(0x1462-0xB499)"},
{0x1002, 0x6778, 0x1642, 0x3C65, "Radeon HD 8470(0x1642-0x3C65)"},
{0x1002, 0x6778, 0x1642, 0x3C75, "Radeon HD 8470(0x1642-0x3C75)"},
{0x1002, 0x6778, 0x174B, 0x8145, "Radeon HD 8470(0x174B-0x8145)"},
{0x1002, 0x6778, 0x174B, 0xD145, "Radeon R5 235 OEM(0x174B-0xD145)"},
{0x1002, 0x6778, 0x174B, 0xD335, "Radeon R5 310 OEM(0x174B-0xD335)"},
{0x1002, 0x6778, 0x174B, 0xE145, "Radeon HD 7470(0x174B-0xE145)"},
{0x1002, 0x6778, 0x17AA, 0x3694, "Radeon R5 A220(0x17AA-0x3694)"},
{0x1002, 0x6779, 0xFFFF, 0xFFFF, "Caicos [Radeon HD 6450/7450/8450 / R5 230 OEM](0x6779)"},
{0x1002, 0x6779, 0x1019, 0x0016, "Radeon HD 6450(0x1019-0x0016)"},
{0x1002, 0x6779, 0x1019, 0x0017, "Radeon HD 6450(0x1019-0x0017)"},
{0x1002, 0x6779, 0x1019, 0x0018, "Radeon HD 6450(0x1019-0x0018)"},
{0x1002, 0x6779, 0x1028, 0x2120, "Radeon HD 6450(0x1028-0x2120)"},
{0x1002, 0x6779, 0x103C, 0x2128, "Radeon HD 6450(0x103C-0x2128)"},
{0x1002, 0x6779, 0x103C, 0x2AEE, "Radeon HD 7450A(0x103C-0x2AEE)"},
{0x1002, 0x6779, 0x1043, 0x047B, "EAH6450 SILENT/DI/1GD3(LP)(0x1043-0x047B)"},
{0x1002, 0x6779, 0x1092, 0x6450, "Radeon HD 6450(0x1092-0x6450)"},
{0x1002, 0x6779, 0x1462, 0x2125, "Radeon HD 6450(0x1462-0x2125)"},
{0x1002, 0x6779, 0x1462, 0x2346, "Radeon HD 7450(0x1462-0x2346)"},
{0x1002, 0x6779, 0x1462, 0x2490, "Radeon HD 6450(0x1462-0x2490)"},
{0x1002, 0x6779, 0x1462, 0x2494, "Radeon HD 6450(0x1462-0x2494)"},
{0x1002, 0x6779, 0x1462, 0x2496, "Radeon HD 7450(0x1462-0x2496)"},
{0x1002, 0x6779, 0x148C, 0x7450, "Radeon HD 7450(0x148C-0x7450)"},
{0x1002, 0x6779, 0x148C, 0x8450, "Radeon HD 8450 OEM(0x148C-0x8450)"},
{0x1002, 0x6779, 0x1545, 0x7470, "Radeon HD 7470(0x1545-0x7470)"},
{0x1002, 0x6779, 0x1642, 0x3A65, "Radeon HD 6450(0x1642-0x3A65)"},
{0x1002, 0x6779, 0x1642, 0x3A66, "Radeon HD 7450(0x1642-0x3A66)"},
{0x1002, 0x6779, 0x1642, 0x3A75, "Radeon HD 6450(0x1642-0x3A75)"},
{0x1002, 0x6779, 0x1642, 0x3A76, "Radeon HD 7450(0x1642-0x3A76)"},
{0x1002, 0x6779, 0x1682, 0x3200, "Radeon HD 7450(0x1682-0x3200)"},
{0x1002, 0x6779, 0x174B, 0x7450, "Radeon HD 7450(0x174B-0x7450)"},
{0x1002, 0x6779, 0x174B, 0xE127, "Radeon HD 6450(0x174B-0xE127)"},
{0x1002, 0x6779, 0x174B, 0xE153, "Radeon HD 6450(0x174B-0xE153)"},
{0x1002, 0x6779, 0x174B, 0xE164, "Radeon HD 6450 1 GB DDR3(0x174B-0xE164)"},
{0x1002, 0x6779, 0x174B, 0xE180, "Radeon HD 6450(0x174B-0xE180)"},
{0x1002, 0x6779, 0x174B, 0xE201, "Radeon HD 6450(0x174B-0xE201)"},
{0x1002, 0x6779, 0x1787, 0x2311, "Radeon HD 6450(0x1787-0x2311)"},
{0x1002, 0x6779, 0x17AF, 0x8450, "Radeon HD 8450 OEM(0x17AF-0x8450)"},
{0x1002, 0x6779, 0x1B0A, 0x9096, "Radeon HD 6450(0x1B0A-0x9096)"},
{0x1002, 0x6779, 0x1B0A, 0x9097, "Radeon HD 6450(0x1B0A-0x9097)"},
{0x1002, 0x6779, 0x1B0A, 0x90A8, "Radeon HD 6450A(0x1B0A-0x90A8)"},
{0x1002, 0x6779, 0x1B0A, 0x90B1, "Radeon HD 6450(0x1B0A-0x90B1)"},
{0x1002, 0x6779, 0x1B0A, 0x90B3, "Radeon HD 7450A(0x1B0A-0x90B3)"},
{0x1002, 0x6779, 0x1B0A, 0x90BB, "Radeon HD 7450A(0x1B0A-0x90BB)"},
{0x1002, 0x677B, 0xFFFF, 0xFFFF, "Caicos PRO [Radeon HD 7450](0x677B)"},
{0x1002, 0x6780, 0xFFFF, 0xFFFF, "Tahiti XT GL [FirePro W9000](0x6780)"},
{0x1002, 0x6784, 0xFFFF, 0xFFFF, "Tahiti [FirePro Series Graphics Adapter](0x6784)"},
{0x1002, 0x6788, 0xFFFF, 0xFFFF, "Tahiti [FirePro Series Graphics Adapter](0x6788)"},
{0x1002, 0x678A, 0xFFFF, 0xFFFF, "Tahiti PRO GL [FirePro Series](0x678A)"},
{0x1002, 0x678A, 0x1002, 0x030C, "FirePro W8000(0x1002-0x030C)"},
{0x1002, 0x678A, 0x1002, 0x0310, "FirePro S9000(0x1002-0x0310)"},
{0x1002, 0x678A, 0x1002, 0x0420, "Radeon Sky 700(0x1002-0x0420)"},
{0x1002, 0x678A, 0x1002, 0x0422, "Radeon Sky 900(0x1002-0x0422)"},
{0x1002, 0x678A, 0x1002, 0x0710, "FirePro S9050(0x1002-0x0710)"},
{0x1002, 0x678A, 0x1002, 0x0B0E, "FirePro S10000 Passive(0x1002-0x0B0E)"},
{0x1002, 0x678A, 0x1002, 0x0B2A, "FirePro S10000(0x1002-0x0B2A)"},
{0x1002, 0x678A, 0x1028, 0x030C, "FirePro W8000(0x1028-0x030C)"},
{0x1002, 0x678A, 0x1028, 0x0710, "FirePro S9000(0x1028-0x0710)"},
{0x1002, 0x6798, 0xFFFF, 0xFFFF, "Tahiti XT [Radeon HD 7970/8970 OEM / R9 280X](0x6798)"},
{0x1002, 0x6798, 0x1002, 0x3000, "Tahiti XT2 [Radeon HD 7970 GHz Edition](0x1002-0x3000)"},
{0x1002, 0x6798, 0x1002, 0x3001, "Tahiti XTL [Radeon R9 280X](0x1002-0x3001)"},
{0x1002, 0x6798, 0x1002, 0x4000, "Radeon HD 8970 OEM(0x1002-0x4000)"},
{0x1002, 0x6798, 0x1043, 0x041C, "HD 7970 DirectCU II(0x1043-0x041C)"},
{0x1002, 0x6798, 0x1043, 0x0420, "HD 7970 DirectCU II TOP(0x1043-0x0420)"},
{0x1002, 0x6798, 0x1043, 0x0444, "HD 7970 DirectCU II TOP(0x1043-0x0444)"},
{0x1002, 0x6798, 0x1043, 0x0448, "HD 7970 DirectCU II TOP(0x1043-0x0448)"},
{0x1002, 0x6798, 0x1043, 0x044A, "Tahiti XT2 [Matrix HD 7970](0x1043-0x044A)"},
{0x1002, 0x6798, 0x1043, 0x044C, "Tahiti XT2 [Matrix HD 7970 Platinum](0x1043-0x044C)"},
{0x1002, 0x6798, 0x1043, 0x3001, "Tahiti XTL [ROG Matrix R9 280X](0x1043-0x3001)"},
{0x1002, 0x6798, 0x1043, 0x3006, "Tahiti XTL [Radeon R9 280X DirectCU II TOP](0x1043-0x3006)"},
{0x1002, 0x6798, 0x1043, 0x9999, "ARES II(0x1043-0x9999)"},
{0x1002, 0x6798, 0x106B, 0x0127, "FirePro D700(0x106B-0x0127)"},
{0x1002, 0x6798, 0x106B, 0x0128, "FirePro D700(0x106B-0x0128)"},
{0x1002, 0x6798, 0x1092, 0x3000, "Tahiti XT2 [Radeon HD 7970 GHz Edition](0x1092-0x3000)"},
{0x1002, 0x6798, 0x1458, 0x2261, "Tahiti XT2 [Radeon HD 7970 GHz Edition OC](0x1458-0x2261)"},
{0x1002, 0x6798, 0x1458, 0x3001, "Tahiti XTL [Radeon R9 280X OC](0x1458-0x3001)"},
{0x1002, 0x6798, 0x1462, 0x2774, "HD 7970 TwinFrozr III Boost Edition OC(0x1462-0x2774)"},
{0x1002, 0x6798, 0x1682, 0x3001, "Tahiti XTL [Radeon R9 280X](0x1682-0x3001)"},
{0x1002, 0x6798, 0x1682, 0x3211, "Double D HD 7970 Black Edition(0x1682-0x3211)"},
{0x1002, 0x6798, 0x1682, 0x3213, "HD 7970 Black Edition(0x1682-0x3213)"},
{0x1002, 0x6798, 0x1682, 0x3214, "Double D HD 7970(0x1682-0x3214)"},
{0x1002, 0x6798, 0x1787, 0x201C, "HD 7970 IceQ X²(0x1787-0x201C)"},
{0x1002, 0x6798, 0x1787, 0x2317, "Radeon HD 7990(0x1787-0x2317)"},
{0x1002, 0x6798, 0x1787, 0x3000, "Tahiti XT2 [Radeon HD 7970 GHz Edition](0x1787-0x3000)"},
{0x1002, 0x679A, 0xFFFF, 0xFFFF, "Tahiti PRO [Radeon HD 7950/8950 OEM / R9 280](0x679A)"},
{0x1002, 0x679A, 0x1002, 0x0B01, "Radeon HD 8950 OEM(0x1002-0x0B01)"},
{0x1002, 0x679A, 0x1002, 0x3000, "Tahiti PRO2 [Radeon HD 7950 Boost](0x1002-0x3000)"},
{0x1002, 0x679A, 0x1462, 0x3000, "Radeon HD 8950 OEM(0x1462-0x3000)"},
{0x1002, 0x679A, 0x174B, 0xA003, "Radeon R9 280(0x174B-0xA003)"},
{0x1002, 0x679B, 0xFFFF, 0xFFFF, "Malta [Radeon HD 7990/8990 OEM](0x679B)"},
{0x1002, 0x679B, 0x1002, 0x0B28, "Radeon HD 8990 OEM(0x1002-0x0B28)"},
{0x1002, 0x679B, 0x1002, 0x0B2A, "Radeon HD 7990(0x1002-0x0B2A)"},
{0x1002, 0x679B, 0x1462, 0x8036, "Radeon HD 8990 OEM(0x1462-0x8036)"},
{0x1002, 0x679B, 0x148C, 0x8990, "Radeon HD 8990 OEM(0x148C-0x8990)"},
{0x1002, 0x679E, 0xFFFF, 0xFFFF, "Tahiti LE [Radeon HD 7870 XT](0x679E)"},
{0x1002, 0x679E, 0x106B, 0x0125, "FirePro D500(0x106B-0x0125)"},
{0x1002, 0x679E, 0x106B, 0x0126, "FirePro D500(0x106B-0x0126)"},
{0x1002, 0x679E, 0x1787, 0x2328, "Radeon HD 7870 Black Edition 2 GB GDDR5 [2GBD5-2DHV3E](0x1787-0x2328)"},
{0x1002, 0x679F, 0xFFFF, 0xFFFF, "Tahiti(0x679F)"},
{0x1002, 0x67A0, 0xFFFF, 0xFFFF, "Hawaii XT GL [FirePro W9100](0x67A0)"},
{0x1002, 0x67A0, 0x1002, 0x0335, "FirePro S9150(0x1002-0x0335)"},
{0x1002, 0x67A0, 0x1002, 0x0735, "FirePro S9170(0x1002-0x0735)"},
{0x1002, 0x67A0, 0x1028, 0x031F, "FirePro W9100(0x1028-0x031F)"},
{0x1002, 0x67A0, 0x1028, 0x0335, "FirePro S9150(0x1028-0x0335)"},
{0x1002, 0x67A1, 0xFFFF, 0xFFFF, "Hawaii PRO GL [FirePro W8100](0x67A1)"},
{0x1002, 0x67A1, 0x1002, 0x0335, "FirePro S9100(0x1002-0x0335)"},
{0x1002, 0x67A1, 0x1028, 0x0335, "FirePro S9100(0x1028-0x0335)"},
{0x1002, 0x67A2, 0xFFFF, 0xFFFF, "Hawaii GL(0x67A2)"},
{0x1002, 0x67A8, 0xFFFF, 0xFFFF, "Hawaii(0x67A8)"},
{0x1002, 0x67A9, 0xFFFF, 0xFFFF, "Hawaii(0x67A9)"},
{0x1002, 0x67AA, 0xFFFF, 0xFFFF, "Hawaii(0x67AA)"},
{0x1002, 0x67B0, 0xFFFF, 0xFFFF, "Hawaii XT / Grenada XT [Radeon R9 290X/390X](0x67B0)"},
{0x1002, 0x67B0, 0x1028, 0x0B00, "Grenada XT [Radeon R9 390X](0x1028-0x0B00)"},
{0x1002, 0x67B0, 0x103C, 0x6566, "Radeon R9 390X(0x103C-0x6566)"},
{0x1002, 0x67B0, 0x1043, 0x046A, "R9 290X DirectCU II(0x1043-0x046A)"},
{0x1002, 0x67B0, 0x1043, 0x046C, "R9 290X DirectCU II OC(0x1043-0x046C)"},
{0x1002, 0x67B0, 0x1043, 0x0474, "Matrix R9 290X Platinum(0x1043-0x0474)"},
{0x1002, 0x67B0, 0x1043, 0x0476, "ARES III(0x1043-0x0476)"},
{0x1002, 0x67B0, 0x1043, 0x04D7, "Radeon R9 390X(0x1043-0x04D7)"},
{0x1002, 0x67B0, 0x1043, 0x04DB, "Radeon R9 390X(0x1043-0x04DB)"},
{0x1002, 0x67B0, 0x1043, 0x04DF, "Radeon R9 390X(0x1043-0x04DF)"},
{0x1002, 0x67B0, 0x1043, 0x04E9, "Radeon R9 390X(0x1043-0x04E9)"},
{0x1002, 0x67B0, 0x1458, 0x227C, "R9 290X WindForce 3X OC(0x1458-0x227C)"},
{0x1002, 0x67B0, 0x1458, 0x2281, "R9 290X WindForce 3X OC(0x1458-0x2281)"},
{0x1002, 0x67B0, 0x1458, 0x228C, "R9 290X WindForce 3X(0x1458-0x228C)"},
{0x1002, 0x67B0, 0x1458, 0x228D, "R9 290X WindForce 3X OC(0x1458-0x228D)"},
{0x1002, 0x67B0, 0x1458, 0x2290, "R9 290X WindForce 3X(0x1458-0x2290)"},
{0x1002, 0x67B0, 0x1458, 0x22BC, "Radeon R9 390X(0x1458-0x22BC)"},
{0x1002, 0x67B0, 0x1458, 0x22C1, "Grenada PRO [Radeon R9 390](0x1458-0x22C1)"},
{0x1002, 0x67B0, 0x1462, 0x2015, "Radeon R9 390X(0x1462-0x2015)"},
{0x1002, 0x67B0, 0x1462, 0x3070, "R9 290X Lightning(0x1462-0x3070)"},
{0x1002, 0x67B0, 0x1462, 0x3071, "R9 290X Lightning(0x1462-0x3071)"},
{0x1002, 0x67B0, 0x1462, 0x3072, "R9 290X Lightning LE(0x1462-0x3072)"},
{0x1002, 0x67B0, 0x1462, 0x3080, "R9 290X Gaming(0x1462-0x3080)"},
{0x1002, 0x67B0, 0x1462, 0x3082, "R9 290X Gaming OC(0x1462-0x3082)"},
{0x1002, 0x67B0, 0x148C, 0x2347, "Devil 13 Dual Core R9 290X(0x148C-0x2347)"},
{0x1002, 0x67B0, 0x148C, 0x2357, "Grenada XT [Radeon R9 390X](0x148C-0x2357)"},
{0x1002, 0x67B0, 0x1682, 0x9290, "Double Dissipation R9 290X(0x1682-0x9290)"},
{0x1002, 0x67B0, 0x1682, 0x9395, "Grenada XT [Radeon R9 390X](0x1682-0x9395)"},
{0x1002, 0x67B0, 0x174B, 0x0E34, "Radeon R9 390X(0x174B-0x0E34)"},
{0x1002, 0x67B0, 0x174B, 0xE282, "Vapor-X R9 290X Tri-X OC(0x174B-0xE282)"},
{0x1002, 0x67B0, 0x174B, 0xE285, "R9 290X Tri-X OC(0x174B-0xE285)"},
{0x1002, 0x67B0, 0x174B, 0xE324, "Grenada XT2 [Radeon R9 390X](0x174B-0xE324)"},
{0x1002, 0x67B0, 0x1787, 0x2020, "R9 290X IceQ X² Turbo(0x1787-0x2020)"},
{0x1002, 0x67B0, 0x1787, 0x2357, "Grenada XT [Radeon R9 390X](0x1787-0x2357)"},
{0x1002, 0x67B1, 0xFFFF, 0xFFFF, "Hawaii PRO [Radeon R9 290/390](0x67B1)"},
{0x1002, 0x67B1, 0x1043, 0x04DD, "STRIX R9 390(0x1043-0x04DD)"},
{0x1002, 0x67B1, 0x148C, 0x2358, "Radeon R9 390(0x148C-0x2358)"},
{0x1002, 0x67B1, 0x174B, 0xE324, "Sapphire Nitro R9 390(0x174B-0xE324)"},
{0x1002, 0x67B8, 0xFFFF, 0xFFFF, "Hawaii XT [Radeon R9 290X Engineering Sample](0x67B8)"},
{0x1002, 0x67B9, 0xFFFF, 0xFFFF, "Vesuvius [Radeon R9 295X2](0x67B9)"},
{0x1002, 0x67BE, 0xFFFF, 0xFFFF, "Hawaii LE(0x67BE)"},
{0x1002, 0x67C0, 0xFFFF, 0xFFFF, "Ellesmere [Radeon Pro WX 7100 Mobile](0x67C0)"},
{0x1002, 0x67C2, 0xFFFF, 0xFFFF, "Ellesmere [Radeon Pro V7300X / V7350x2](0x67C2)"},
{0x1002, 0x67C4, 0xFFFF, 0xFFFF, "Ellesmere [Radeon Pro WX 7100](0x67C4)"},
{0x1002, 0x67C4, 0x1002, 0x0336, "Radeon Pro Duo(0x1002-0x0336)"},
{0x1002, 0x67C4, 0x1002, 0x1336, "Radeon Pro Duo(0x1002-0x1336)"},
{0x1002, 0x67C7, 0xFFFF, 0xFFFF, "Ellesmere [Radeon Pro WX 5100](0x67C7)"},
{0x1002, 0x67CA, 0xFFFF, 0xFFFF, "Ellesmere [Polaris10](0x67CA)"},
{0x1002, 0x67CC, 0xFFFF, 0xFFFF, "Ellesmere [Polaris10](0x67CC)"},
{0x1002, 0x67CF, 0xFFFF, 0xFFFF, "Ellesmere [Polaris10](0x67CF)"},
{0x1002, 0x67D0, 0xFFFF, 0xFFFF, "Ellesmere [Radeon Pro V7300X / V7350x2](0x67D0)"},
{0x1002, 0x67D4, 0xFFFF, 0xFFFF, "Ellesmere [Radeon Pro WX 7100 / Barco MXRT-8700](0x67D4)"},
{0x1002, 0x67D7, 0xFFFF, 0xFFFF, "Ellesmere [Radeon Pro WX 5100 / Barco MXRT-6700](0x67D7)"},
{0x1002, 0x67DF, 0xFFFF, 0xFFFF, "Ellesmere [Radeon RX 470/480/570/570X/580/580X/590](0x67DF)"},
{0x1002, 0x67DF, 0x1002, 0x0B37, "Radeon RX 480(0x1002-0x0B37)"},
{0x1002, 0x67DF, 0x1028, 0x1722, "Radeon RX 570X(0x1028-0x1722)"},
{0x1002, 0x67DF, 0x1028, 0x1723, "Radeon RX 580X(0x1028-0x1723)"},
{0x1002, 0x67DF, 0x103C, 0x840E, "Radeon RX 580 4GB(0x103C-0x840E)"},
{0x1002, 0x67DF, 0x1043, 0x04A8, "Radeon RX 480(0x1043-0x04A8)"},
{0x1002, 0x67DF, 0x1043, 0x04B0, "Radeon RX 470(0x1043-0x04B0)"},
{0x1002, 0x67DF, 0x1043, 0x04FB, "Radeon RX 480(0x1043-0x04FB)"},
{0x1002, 0x67DF, 0x1043, 0x04FD, "Radeon RX 480 8GB(0x1043-0x04FD)"},
{0x1002, 0x67DF, 0x1043, 0x056A, "Radeon RX 590(0x1043-0x056A)"},
{0x1002, 0x67DF, 0x106B, 0x0161, "Radeon Pro 580(0x106B-0x0161)"},
{0x1002, 0x67DF, 0x106B, 0x0162, "Radeon Pro 575(0x106B-0x0162)"},
{0x1002, 0x67DF, 0x106B, 0x0163, "Radeon Pro 570(0x106B-0x0163)"},
{0x1002, 0x67DF, 0x1458, 0x22F0, "Radeon RX 570(0x1458-0x22F0)"},
{0x1002, 0x67DF, 0x1458, 0x22F7, "Radeon RX 570 Gaming 4G(0x1458-0x22F7)"},
{0x1002, 0x67DF, 0x1462, 0x3411, "Radeon RX 470(0x1462-0x3411)"},
{0x1002, 0x67DF, 0x1462, 0x3413, "Radeon RX 480 Gaming X 8GB(0x1462-0x3413)"},
{0x1002, 0x67DF, 0x1462, 0x3416, "Radeon RX 570(0x1462-0x3416)"},
{0x1002, 0x67DF, 0x1462, 0x3418, "Radeon RX 580 ARMOR 8G OC(0x1462-0x3418)"},
{0x1002, 0x67DF, 0x1462, 0x341B, "Radeon RX 570 Armor 8G OC(0x1462-0x341B)"},
{0x1002, 0x67DF, 0x1462, 0x341E, "Radeon RX 570 Armor 4G OC(0x1462-0x341E)"},
{0x1002, 0x67DF, 0x1462, 0x809E, "Radeon RX 480 4GB(0x1462-0x809E)"},
{0x1002, 0x67DF, 0x1462, 0x8A92, "Radeon RX 580(0x1462-0x8A92)"},
{0x1002, 0x67DF, 0x148C, 0x2372, "Radeon RX 480 [Red Dragon](0x148C-0x2372)"},
{0x1002, 0x67DF, 0x148C, 0x2373, "Radeon RX 470(0x148C-0x2373)"},
{0x1002, 0x67DF, 0x148C, 0x2377, "Red Devil RX 580 8G Golden(0x148C-0x2377)"},
{0x1002, 0x67DF, 0x148C, 0x2378, "Radeon RX 580(0x148C-0x2378)"},
{0x1002, 0x67DF, 0x148C, 0x2379, "Radeon RX 570 4G [Red Dragon](0x148C-0x2379)"},
{0x1002, 0x67DF, 0x148C, 0x2391, "Radeon RX 590 [Red Devil](0x148C-0x2391)"},
{0x1002, 0x67DF, 0x1682, 0x9470, "Radeon RX 470(0x1682-0x9470)"},
{0x1002, 0x67DF, 0x1682, 0x9480, "Radeon RX 480(0x1682-0x9480)"},
{0x1002, 0x67DF, 0x1682, 0x9587, "Radeon RX 590 FATBOY 8GB(0x1682-0x9587)"},
{0x1002, 0x67DF, 0x1682, 0x9588, "Radeon RX 580 XTR(0x1682-0x9588)"},
{0x1002, 0x67DF, 0x1682, 0xC570, "Radeon RX 570(0x1682-0xC570)"},
{0x1002, 0x67DF, 0x1682, 0xC580, "Radeon RX 580(0x1682-0xC580)"},
{0x1002, 0x67DF, 0x174B, 0xE347, "Radeon RX 470/480(0x174B-0xE347)"},
{0x1002, 0x67DF, 0x174B, 0xE349, "Radeon RX 470(0x174B-0xE349)"},
{0x1002, 0x67DF, 0x1787, 0xA470, "Radeon RX 470(0x1787-0xA470)"},
{0x1002, 0x67DF, 0x1787, 0xA480, "Radeon RX 480(0x1787-0xA480)"},
{0x1002, 0x67DF, 0x1849, 0x5001, "Phantom Gaming X RX 580 OC(0x1849-0x5001)"},
{0x1002, 0x67DF, 0x1849, 0x5030, "Phantom Gaming D Radeon RX580 8G OC(0x1849-0x5030)"},
{0x1002, 0x67DF, 0x1DA2, 0xE343, "Radeon RX 570 Pulse ITX 4GB(0x1DA2-0xE343)"},
{0x1002, 0x67DF, 0x1DA2, 0xE353, "Radeon RX 570 Pulse 4GB(0x1DA2-0xE353)"},
{0x1002, 0x67DF, 0x1DA2, 0xE366, "Nitro+ Radeon RX 570/580/590(0x1DA2-0xE366)"},
{0x1002, 0x67DF, 0x1DA2, 0xE387, "Radeon RX 580 Pulse 4GB(0x1DA2-0xE387)"},
{0x1002, 0x67E0, 0xFFFF, 0xFFFF, "Baffin [Radeon Pro WX 4170](0x67E0)"},
{0x1002, 0x67E0, 0x103C, 0x8270, "Radeon Pro WX 4170(0x103C-0x8270)"},
{0x1002, 0x67E0, 0x103C, 0x8272, "Radeon Pro WX 4170(0x103C-0x8272)"},
{0x1002, 0x67E1, 0xFFFF, 0xFFFF, "Baffin [Polaris11](0x67E1)"},
{0x1002, 0x67E3, 0xFFFF, 0xFFFF, "Baffin [Radeon Pro WX 4100](0x67E3)"},
{0x1002, 0x67E8, 0xFFFF, 0xFFFF, "Baffin [Radeon Pro WX 4130/4150](0x67E8)"},
{0x1002, 0x67E8, 0x1028, 0x075D, "Radeon Pro WX 4150(0x1028-0x075D)"},
{0x1002, 0x67E8, 0x1028, 0x07B0, "Radeon Pro WX 4130/4150(0x1028-0x07B0)"},
{0x1002, 0x67E8, 0x1028, 0x07B1, "Radeon Pro WX 4130(0x1028-0x07B1)"},
{0x1002, 0x67E8, 0x1028, 0x175D, "Radeon Pro WX 4150(0x1028-0x175D)"},
{0x1002, 0x67E8, 0x1028, 0x17B0, "Radeon Pro WX 4130/4150(0x1028-0x17B0)"},
{0x1002, 0x67E8, 0x1028, 0x17B1, "Radeon Pro WX 4130(0x1028-0x17B1)"},
{0x1002, 0x67E8, 0x103C, 0x8275, "Radeon Pro WX 4150(0x103C-0x8275)"},
{0x1002, 0x67E8, 0x103C, 0x8277, "Radeon Pro WX 4150(0x103C-0x8277)"},
{0x1002, 0x67E9, 0xFFFF, 0xFFFF, "Baffin [Polaris11](0x67E9)"},
{0x1002, 0x67EB, 0xFFFF, 0xFFFF, "Baffin [Radeon Pro V5300X](0x67EB)"},
{0x1002, 0x67EF, 0xFFFF, 0xFFFF, "Baffin [Radeon RX 460/560D / Pro 450/455/460/555/555X/560/560X](0x67EF)"},
{0x1002, 0x67EF, 0x1025, 0x1367, "RX560X 4GB(0x1025-0x1367)"},
{0x1002, 0x67EF, 0x1028, 0x1703, "RX 560D OEM OC 2 GB(0x1028-0x1703)"},
{0x1002, 0x67EF, 0x103C, 0x3421, "Radeon RX 460(0x103C-0x3421)"},
{0x1002, 0x67EF, 0x1043, 0x0561, "AREZ Radeon RX 560(0x1043-0x0561)"},
{0x1002, 0x67EF, 0x106B, 0x0160, "Radeon Pro 460(0x106B-0x0160)"},
{0x1002, 0x67EF, 0x106B, 0x0166, "Radeon Pro 455(0x106B-0x0166)"},
{0x1002, 0x67EF, 0x106B, 0x0167, "Radeon Pro 450(0x106B-0x0167)"},
{0x1002, 0x67EF, 0x106B, 0x0179, "Radeon Pro 560(0x106B-0x0179)"},
{0x1002, 0x67EF, 0x106B, 0x017A, "Radeon Pro 555(0x106B-0x017A)"},
{0x1002, 0x67EF, 0x106B, 0x018F, "Radeon Pro 560X(0x106B-0x018F)"},
{0x1002, 0x67EF, 0x106B, 0x0190, "Radeon Pro 555X(0x106B-0x0190)"},
{0x1002, 0x67EF, 0x1642, 0x1727, "Polaris 21 XL [Radeon RX 560D](0x1642-0x1727)"},
{0x1002, 0x67EF, 0x1682, 0x956D, "Polaris 21 XL [Radeon RX 560D](0x1682-0x956D)"},
{0x1002, 0x67FF, 0xFFFF, 0xFFFF, "Baffin [Radeon RX 550 640SP / RX 560/560X](0x67FF)"},
{0x1002, 0x67FF, 0x1002, 0x0B04, "Radeon RX 560(0x1002-0x0B04)"},
{0x1002, 0x67FF, 0x1028, 0x1721, "Radeon RX 560X(0x1028-0x1721)"},
{0x1002, 0x67FF, 0x1028, 0x1726, "Radeon RX 560DX(0x1028-0x1726)"},
{0x1002, 0x67FF, 0x103C, 0x8479, "Radeon RX 560X Mobile(0x103C-0x8479)"},
{0x1002, 0x67FF, 0x1043, 0x04BC, "Radeon RX 560(0x1043-0x04BC)"},
{0x1002, 0x67FF, 0x1043, 0x052F, "Radeon RX 560(0x1043-0x052F)"},
{0x1002, 0x67FF, 0x1458, 0x22ED, "Radeon RX 560(0x1458-0x22ED)"},
{0x1002, 0x67FF, 0x148C, 0x2381, "Radeon RX 560(0x148C-0x2381)"},
{0x1002, 0x67FF, 0x1682, 0x9560, "Radeon RX 560(0x1682-0x9560)"},
{0x1002, 0x67FF, 0x1849, 0x5037, "PHANTOM G R RX550 2G/M/ASRK(0x1849-0x5037)"},
{0x1002, 0x67FF, 0x1DA2, 0xE348, "Radeon RX 560(0x1DA2-0xE348)"},
{0x1002, 0x67FF, 0x1DA2, 0xE367, "Radeon RX 550 640SP(0x1DA2-0xE367)"},
{0x1002, 0x6800, 0xFFFF, 0xFFFF, "Wimbledon XT [Radeon HD 7970M](0x6800)"},
{0x1002, 0x6800, 0x1002, 0x0124, "Radeon HD 7970M(0x1002-0x0124)"},
{0x1002, 0x6800, 0x8086, 0x2110, "Radeon HD 7970M(0x8086-0x2110)"},
{0x1002, 0x6800, 0x8086, 0x2111, "Radeon HD 7970M(0x8086-0x2111)"},
{0x1002, 0x6801, 0xFFFF, 0xFFFF, "Neptune XT [Radeon HD 8970M](0x6801)"},
{0x1002, 0x6801, 0x1002, 0x0124, "Radeon HD 8970M(0x1002-0x0124)"},
{0x1002, 0x6801, 0x1462, 0x1117, "Radeon R9 M290X(0x1462-0x1117)"},
{0x1002, 0x6801, 0x8086, 0x2110, "Radeon HD 8970M(0x8086-0x2110)"},
{0x1002, 0x6801, 0x8086, 0x2111, "Radeon HD 8970M(0x8086-0x2111)"},
{0x1002, 0x6802, 0xFFFF, 0xFFFF, "Wimbledon(0x6802)"},
{0x1002, 0x6806, 0xFFFF, 0xFFFF, "Neptune(0x6806)"},
{0x1002, 0x6808, 0xFFFF, 0xFFFF, "Pitcairn XT GL [FirePro W7000](0x6808)"},
{0x1002, 0x6808, 0x1002, 0x0310, "FirePro S7000(0x1002-0x0310)"},
{0x1002, 0x6808, 0x1002, 0x0420, "Radeon Sky 500(0x1002-0x0420)"},
{0x1002, 0x6808, 0x103C, 0x030C, "MED-X7000(0x103C-0x030C)"},
{0x1002, 0x6808, 0x13CC, 0x3D25, "MXRT-7500(0x13CC-0x3D25)"},
{0x1002, 0x6808, 0x15C3, 0x030C, "MED-X7000(0x15C3-0x030C)"},
{0x1002, 0x6809, 0xFFFF, 0xFFFF, "Pitcairn LE GL [FirePro W5000](0x6809)"},
{0x1002, 0x6809, 0x13CC, 0x3D23, "MXRT-5500(0x13CC-0x3D23)"},
{0x1002, 0x6809, 0x13CC, 0x3D24, "MXRT-5550(0x13CC-0x3D24)"},
{0x1002, 0x6809, 0x15C3, 0x0B06, "MED-X5000(0x15C3-0x0B06)"},
{0x1002, 0x6810, 0xFFFF, 0xFFFF, "Curacao XT / Trinidad XT [Radeon R7 370 / R9 270X/370X](0x6810)"},
{0x1002, 0x6810, 0x106B, 0x012A, "FirePro D300(0x106B-0x012A)"},
{0x1002, 0x6810, 0x106B, 0x012B, "FirePro D300(0x106B-0x012B)"},
{0x1002, 0x6810, 0x148C, 0x0908, "Radeon R9 370 OEM(0x148C-0x0908)"},
{0x1002, 0x6810, 0x1682, 0x7370, "Radeon R7 370(0x1682-0x7370)"},
{0x1002, 0x6811, 0xFFFF, 0xFFFF, "Curacao PRO [Radeon R7 370 / R9 270/370 OEM](0x6811)"},
{0x1002, 0x6811, 0x1028, 0x0B00, "Trinidad PRO [Radeon R9 370 OEM](0x1028-0x0B00)"},
{0x1002, 0x6811, 0x1043, 0x2016, "Trinidad PRO [Radeon R9 370 OEM](0x1043-0x2016)"},
{0x1002, 0x6811, 0x1458, 0x2016, "Trinidad PRO [Radeon R9 370 OEM](0x1458-0x2016)"},
{0x1002, 0x6811, 0x1462, 0x2016, "Trinidad PRO [Radeon R9 370 OEM](0x1462-0x2016)"},
{0x1002, 0x6811, 0x1462, 0x3050, "R9 270 Gaming OC(0x1462-0x3050)"},
{0x1002, 0x6811, 0x148C, 0x2016, "Trinidad PRO [Radeon R9 370 OEM](0x148C-0x2016)"},
{0x1002, 0x6811, 0x1682, 0x2015, "Trinidad PRO [Radeon R7 370](0x1682-0x2015)"},
{0x1002, 0x6811, 0x174B, 0x2015, "NITRO Radeon R7 370(0x174B-0x2015)"},
{0x1002, 0x6811, 0x174B, 0x2016, "Trinidad PRO [Radeon R9 370 OEM](0x174B-0x2016)"},
{0x1002, 0x6811, 0x1787, 0x2016, "Trinidad PRO [Radeon R9 370 OEM](0x1787-0x2016)"},
{0x1002, 0x6816, 0xFFFF, 0xFFFF, "Pitcairn(0x6816)"},
{0x1002, 0x6817, 0xFFFF, 0xFFFF, "Pitcairn(0x6817)"},
{0x1002, 0x6818, 0xFFFF, 0xFFFF, "Pitcairn XT [Radeon HD 7870 GHz Edition](0x6818)"},
{0x1002, 0x6818, 0x1002, 0x0B05, "Radeon HD 8870 OEM(0x1002-0x0B05)"},
{0x1002, 0x6818, 0x174B, 0x8B04, "Radeon HD 8860(0x174B-0x8B04)"},
{0x1002, 0x6819, 0xFFFF, 0xFFFF, "Pitcairn PRO [Radeon HD 7850 / R7 265 / R9 270 1024SP](0x6819)"},
{0x1002, 0x6819, 0x1043, 0x042C, "Radeon HD 7850(0x1043-0x042C)"},
{0x1002, 0x6819, 0x1682, 0x7269, "Radeon R9 270 1024SP(0x1682-0x7269)"},
{0x1002, 0x6819, 0x1682, 0x9278, "Radeon R9 270 1024SP(0x1682-0x9278)"},
{0x1002, 0x6819, 0x174B, 0xA008, "Radeon R9 270 1024SP(0x174B-0xA008)"},
{0x1002, 0x6819, 0x174B, 0xE221, "Radeon HD 7850 2GB GDDR5 DVI-I/DVI-D/HDMI/DP(0x174B-0xE221)"},
{0x1002, 0x6820, 0xFFFF, 0xFFFF, "Venus XTX [Radeon HD 8890M / R9 M275X/M375X](0x6820)"},
{0x1002, 0x6820, 0x103C, 0x1851, "Radeon HD 7750M(0x103C-0x1851)"},
{0x1002, 0x6820, 0x17AA, 0x3643, "Radeon R9 A375(0x17AA-0x3643)"},
{0x1002, 0x6820, 0x17AA, 0x3801, "Radeon R9 M275(0x17AA-0x3801)"},
{0x1002, 0x6820, 0x17AA, 0x3824, "Radeon R9 M375(0x17AA-0x3824)"},
{0x1002, 0x6820, 0x1DA2, 0xE26A, "Radeon R7 250(0x1DA2-0xE26A)"},
{0x1002, 0x6821, 0xFFFF, 0xFFFF, "Venus XT [Radeon HD 8870M / R9 M270X/M370X](0x6821)"},
{0x1002, 0x6821, 0x1002, 0x031E, "FirePro SX4000(0x1002-0x031E)"},
{0x1002, 0x6821, 0x1028, 0x05CC, "FirePro M5100(0x1028-0x05CC)"},
{0x1002, 0x6821, 0x1028, 0x15CC, "FirePro M5100(0x1028-0x15CC)"},
{0x1002, 0x6821, 0x106B, 0x0149, "Radeon R9 M370X Mac Edition(0x106B-0x0149)"},
{0x1002, 0x6822, 0xFFFF, 0xFFFF, "Venus PRO [Radeon E8860](0x6822)"},
{0x1002, 0x6823, 0xFFFF, 0xFFFF, "Venus PRO [Radeon HD 8850M / R9 M265X](0x6823)"},
{0x1002, 0x6825, 0xFFFF, 0xFFFF, "Heathrow XT [Radeon HD 7870M](0x6825)"},
{0x1002, 0x6825, 0x1028, 0x053F, "FirePro M6000(0x1028-0x053F)"},
{0x1002, 0x6825, 0x1028, 0x05CD, "FirePro M6000(0x1028-0x05CD)"},
{0x1002, 0x6825, 0x1028, 0x15CD, "FirePro M6000(0x1028-0x15CD)"},
{0x1002, 0x6825, 0x103C, 0x176C, "FirePro M6000(0x103C-0x176C)"},
{0x1002, 0x6825, 0x8086, 0x2111, "Chelsea PRO(0x8086-0x2111)"},
{0x1002, 0x6826, 0xFFFF, 0xFFFF, "Chelsea LP [Radeon HD 7700M Series](0x6826)"},
{0x1002, 0x6827, 0xFFFF, 0xFFFF, "Heathrow PRO [Radeon HD 7850M/8850M](0x6827)"},
{0x1002, 0x6828, 0xFFFF, 0xFFFF, "Cape Verde PRO [FirePro W600](0x6828)"},
{0x1002, 0x6828, 0x15C3, 0x2B1E, "MED-X6000(0x15C3-0x2B1E)"},
{0x1002, 0x6829, 0xFFFF, 0xFFFF, "Cape Verde(0x6829)"},
{0x1002, 0x682A, 0xFFFF, 0xFFFF, "Venus PRO(0x682A)"},
{0x1002, 0x682B, 0xFFFF, 0xFFFF, "Cape Verde PRO / Venus LE / Tropo PRO-L [Radeon HD 8830M / R7 250 / R7 M465X](0x682B)"},
{0x1002, 0x682B, 0x0128, 0x079C, "Radeon R7 465X(0x0128-0x079C)"},
{0x1002, 0x682B, 0x1462, 0x3012, "Radeon R7 250(0x1462-0x3012)"},
{0x1002, 0x682C, 0xFFFF, 0xFFFF, "Cape Verde GL [FirePro W4100](0x682C)"},
{0x1002, 0x682D, 0xFFFF, 0xFFFF, "Chelsea XT GL [FirePro M4000](0x682D)"},
{0x1002, 0x682F, 0xFFFF, 0xFFFF, "Chelsea LP [Radeon HD 7730M](0x682F)"},
{0x1002, 0x682F, 0x103C, 0x1851, "Radeon HD 7750M(0x103C-0x1851)"},
{0x1002, 0x6835, 0xFFFF, 0xFFFF, "Cape Verde PRX [Radeon R9 255 OEM](0x6835)"},
{0x1002, 0x6837, 0xFFFF, 0xFFFF, "Cape Verde LE [Radeon HD 7730/8730](0x6837)"},
{0x1002, 0x6837, 0x1462, 0x2796, "Radeon HD 8730(0x1462-0x2796)"},
{0x1002, 0x6837, 0x1462, 0x8092, "Radeon HD 8730(0x1462-0x8092)"},
{0x1002, 0x6837, 0x148C, 0x8730, "Radeon HD 8730(0x148C-0x8730)"},
{0x1002, 0x6837, 0x1787, 0x3000, "Radeon HD 6570(0x1787-0x3000)"},
{0x1002, 0x683D, 0xFFFF, 0xFFFF, "Cape Verde XT [Radeon HD 7770/8760 / R7 250X](0x683D)"},
{0x1002, 0x683D, 0x1002, 0x0030, "Radeon HD 8760 OEM(0x1002-0x0030)"},
{0x1002, 0x683D, 0x1019, 0x0030, "Radeon HD 8760 OEM(0x1019-0x0030)"},
{0x1002, 0x683D, 0x103C, 0x6890, "Radeon HD 8760 OEM(0x103C-0x6890)"},
{0x1002, 0x683D, 0x1043, 0x8760, "Radeon HD 8760 OEM(0x1043-0x8760)"},
{0x1002, 0x683D, 0x1462, 0x2710, "R7770-PMD1GD5(0x1462-0x2710)"},
{0x1002, 0x683D, 0x174B, 0x8304, "Radeon HD 8760 OEM(0x174B-0x8304)"},
{0x1002, 0x683F, 0xFFFF, 0xFFFF, "Cape Verde PRO [Radeon HD 7750/8740 / R7 250E](0x683F)"},
{0x1002, 0x683F, 0x1462, 0x2790, "Radeon HD 8740(0x1462-0x2790)"},
{0x1002, 0x683F, 0x1462, 0x2791, "Radeon HD 8740(0x1462-0x2791)"},
{0x1002, 0x683F, 0x1642, 0x3B97, "Radeon HD 8740(0x1642-0x3B97)"},
{0x1002, 0x6840, 0xFFFF, 0xFFFF, "Thames [Radeon HD 7500M/7600M Series](0x6840)"},
{0x1002, 0x6840, 0x1025, 0x050E, "Radeon HD 7670M(0x1025-0x050E)"},
{0x1002, 0x6840, 0x1025, 0x050F, "Radeon HD 7670M(0x1025-0x050F)"},
{0x1002, 0x6840, 0x1025, 0x0513, "Radeon HD 7670M(0x1025-0x0513)"},
{0x1002, 0x6840, 0x1025, 0x0514, "Radeon HD 7670M(0x1025-0x0514)"},
{0x1002, 0x6840, 0x1025, 0x056D, "Radeon HD 7670M(0x1025-0x056D)"},
{0x1002, 0x6840, 0x1025, 0x059A, "Radeon HD 7670M(0x1025-0x059A)"},
{0x1002, 0x6840, 0x1025, 0x059B, "Radeon HD 7670M(0x1025-0x059B)"},
{0x1002, 0x6840, 0x1025, 0x059E, "Radeon HD 7670M(0x1025-0x059E)"},
{0x1002, 0x6840, 0x1025, 0x0600, "Radeon HD 7670M(0x1025-0x0600)"},
{0x1002, 0x6840, 0x1025, 0x0606, "Radeon HD 7670M(0x1025-0x0606)"},
{0x1002, 0x6840, 0x1025, 0x0696, "Radeon HD 7650M(0x1025-0x0696)"},
{0x1002, 0x6840, 0x1025, 0x0697, "Radeon HD 7650M(0x1025-0x0697)"},
{0x1002, 0x6840, 0x1025, 0x0698, "Radeon HD 7650M(0x1025-0x0698)"},
{0x1002, 0x6840, 0x1025, 0x0699, "Radeon HD 7650M(0x1025-0x0699)"},
{0x1002, 0x6840, 0x1025, 0x0757, "Radeon HD 7670M(0x1025-0x0757)"},
{0x1002, 0x6840, 0x1028, 0x056A, "Radeon HD 7670M(0x1028-0x056A)"},
{0x1002, 0x6840, 0x1028, 0x056E, "Radeon HD 7670M(0x1028-0x056E)"},
{0x1002, 0x6840, 0x1028, 0x0598, "Radeon HD 7670M(0x1028-0x0598)"},
{0x1002, 0x6840, 0x1028, 0x059D, "Radeon HD 7670M(0x1028-0x059D)"},
{0x1002, 0x6840, 0x1028, 0x05A3, "Radeon HD 7670M(0x1028-0x05A3)"},
{0x1002, 0x6840, 0x1028, 0x05B9, "Radeon HD 7670M(0x1028-0x05B9)"},
{0x1002, 0x6840, 0x1028, 0x05BB, "Radeon HD 7670M(0x1028-0x05BB)"},
{0x1002, 0x6840, 0x103C, 0x1789, "FirePro M2000(0x103C-0x1789)"},
{0x1002, 0x6840, 0x103C, 0x17F1, "Radeon HD 7570M(0x103C-0x17F1)"},
{0x1002, 0x6840, 0x103C, 0x17F4, "Radeon HD 7650M(0x103C-0x17F4)"},
{0x1002, 0x6840, 0x103C, 0x1813, "Radeon HD 7590M(0x103C-0x1813)"},
{0x1002, 0x6840, 0x103C, 0x182F, "Radeon HD 7670M(0x103C-0x182F)"},
{0x1002, 0x6840, 0x103C, 0x1830, "Radeon HD 7670M(0x103C-0x1830)"},
{0x1002, 0x6840, 0x103C, 0x1835, "Radeon HD 7670M(0x103C-0x1835)"},
{0x1002, 0x6840, 0x103C, 0x183A, "Radeon HD 7670M(0x103C-0x183A)"},
{0x1002, 0x6840, 0x103C, 0x183C, "Radeon HD 7670M(0x103C-0x183C)"},
{0x1002, 0x6840, 0x103C, 0x183E, "Radeon HD 7670M(0x103C-0x183E)"},
{0x1002, 0x6840, 0x103C, 0x1840, "Radeon HD 7670M(0x103C-0x1840)"},
{0x1002, 0x6840, 0x103C, 0x1842, "Radeon HD 7670M(0x103C-0x1842)"},
{0x1002, 0x6840, 0x103C, 0x1844, "Radeon HD 7670M(0x103C-0x1844)"},
{0x1002, 0x6840, 0x103C, 0x1848, "Radeon HD 7670M(0x103C-0x1848)"},
{0x1002, 0x6840, 0x103C, 0x184A, "Radeon HD 7670M(0x103C-0x184A)"},
{0x1002, 0x6840, 0x103C, 0x184C, "Radeon HD 7670M(0x103C-0x184C)"},
{0x1002, 0x6840, 0x103C, 0x1895, "Radeon HD 7670M(0x103C-0x1895)"},
{0x1002, 0x6840, 0x103C, 0x1897, "Radeon HD 7670M(0x103C-0x1897)"},
{0x1002, 0x6840, 0x103C, 0x18A5, "Radeon HD 7670M(0x103C-0x18A5)"},
{0x1002, 0x6840, 0x103C, 0x18A7, "Radeon HD 7670M(0x103C-0x18A7)"},
{0x1002, 0x6840, 0x103C, 0x18F4, "Radeon HD 7670M(0x103C-0x18F4)"},
{0x1002, 0x6840, 0x1043, 0x100A, "Radeon HD 7670M(0x1043-0x100A)"},
{0x1002, 0x6840, 0x1043, 0x104B, "Radeon HD 7670M(0x1043-0x104B)"},
{0x1002, 0x6840, 0x1043, 0x10DC, "Radeon HD 7670M(0x1043-0x10DC)"},
{0x1002, 0x6840, 0x1043, 0x2121, "Radeon HD 7670M(0x1043-0x2121)"},
{0x1002, 0x6840, 0x1043, 0x2122, "Radeon HD 7670M(0x1043-0x2122)"},
{0x1002, 0x6840, 0x1043, 0x2123, "Radeon HD 7670M(0x1043-0x2123)"},
{0x1002, 0x6840, 0x1043, 0x2125, "Radeon HD 7670M(0x1043-0x2125)"},
{0x1002, 0x6840, 0x1043, 0x2127, "Radeon HD 7670M(0x1043-0x2127)"},
{0x1002, 0x6840, 0x1179, 0xFB11, "Radeon HD 7670M(0x1179-0xFB11)"},
{0x1002, 0x6840, 0x1179, 0xFB22, "Radeon HD 7670M(0x1179-0xFB22)"},
{0x1002, 0x6840, 0x1179, 0xFB23, "Radeon HD 7670M(0x1179-0xFB23)"},
{0x1002, 0x6840, 0x1179, 0xFB2C, "Radeon HD 7670M(0x1179-0xFB2C)"},
{0x1002, 0x6840, 0x1179, 0xFB31, "Radeon HD 7670M(0x1179-0xFB31)"},
{0x1002, 0x6840, 0x1179, 0xFB32, "Radeon HD 7670M(0x1179-0xFB32)"},
{0x1002, 0x6840, 0x1179, 0xFB38, "Radeon HD 7670M(0x1179-0xFB38)"},
{0x1002, 0x6840, 0x1179, 0xFB39, "Radeon HD 7670M(0x1179-0xFB39)"},
{0x1002, 0x6840, 0x1179, 0xFB3A, "Radeon HD 7670M(0x1179-0xFB3A)"},
{0x1002, 0x6840, 0x1179, 0xFB40, "Radeon HD 7670M(0x1179-0xFB40)"},
{0x1002, 0x6840, 0x1179, 0xFB41, "Radeon HD 7670M(0x1179-0xFB41)"},
{0x1002, 0x6840, 0x1179, 0xFB47, "Radeon HD 7670M(0x1179-0xFB47)"},
{0x1002, 0x6840, 0x1179, 0xFB48, "Radeon HD 7670M(0x1179-0xFB48)"},
{0x1002, 0x6840, 0x1179, 0xFB51, "Radeon HD 7670M(0x1179-0xFB51)"},
{0x1002, 0x6840, 0x1179, 0xFB52, "Radeon HD 7670M(0x1179-0xFB52)"},
{0x1002, 0x6840, 0x1179, 0xFB53, "Radeon HD 7670M(0x1179-0xFB53)"},
{0x1002, 0x6840, 0x1179, 0xFB81, "Radeon HD 7670M(0x1179-0xFB81)"},
{0x1002, 0x6840, 0x1179, 0xFB82, "Radeon HD 7670M(0x1179-0xFB82)"},
{0x1002, 0x6840, 0x1179, 0xFB83, "Radeon HD 7670M(0x1179-0xFB83)"},
{0x1002, 0x6840, 0x1179, 0xFC56, "Radeon HD 7670M(0x1179-0xFC56)"},
{0x1002, 0x6840, 0x1179, 0xFCD4, "Radeon HD 7670M(0x1179-0xFCD4)"},
{0x1002, 0x6840, 0x1179, 0xFCEE, "Radeon HD 7670M(0x1179-0xFCEE)"},
{0x1002, 0x6840, 0x144D, 0xC0C5, "Radeon HD 7690M(0x144D-0xC0C5)"},
{0x1002, 0x6840, 0x144D, 0xC0CE, "Radeon HD 7670M(0x144D-0xC0CE)"},
{0x1002, 0x6840, 0x144D, 0xC0DA, "Radeon HD 7670M(0x144D-0xC0DA)"},
{0x1002, 0x6840, 0x17AA, 0x3970, "Radeon HD 7670M(0x17AA-0x3970)"},
{0x1002, 0x6840, 0x17AA, 0x397B, "Radeon HD 7670M(0x17AA-0x397B)"},
{0x1002, 0x6840, 0x17AA, 0x5101, "Radeon HD 7670M(0x17AA-0x5101)"},
{0x1002, 0x6840, 0x17AA, 0x5102, "Radeon HD 7670M(0x17AA-0x5102)"},
{0x1002, 0x6840, 0x17AA, 0x5103, "Radeon HD 7670M(0x17AA-0x5103)"},
{0x1002, 0x6841, 0xFFFF, 0xFFFF, "Thames [Radeon HD 7550M/7570M/7650M](0x6841)"},
{0x1002, 0x6841, 0x1028, 0x0561, "Radeon HD 7650M(0x1028-0x0561)"},
{0x1002, 0x6841, 0x1028, 0x056C, "Radeon HD 7650M(0x1028-0x056C)"},
{0x1002, 0x6841, 0x1028, 0x057F, "Radeon HD 7570M(0x1028-0x057F)"},
{0x1002, 0x6841, 0x103C, 0x17F1, "Radeon HD 7570M(0x103C-0x17F1)"},
{0x1002, 0x6841, 0x103C, 0x17F4, "Radeon HD 7650M(0x103C-0x17F4)"},
{0x1002, 0x6841, 0x103C, 0x1813, "Radeon HD 7570M(0x103C-0x1813)"},
{0x1002, 0x6841, 0x103C, 0x183A, "Radeon HD 7650M(0x103C-0x183A)"},
{0x1002, 0x6841, 0x103C, 0x183C, "Radeon HD 7650M(0x103C-0x183C)"},
{0x1002, 0x6841, 0x103C, 0x183E, "Radeon HD 7650M(0x103C-0x183E)"},
{0x1002, 0x6841, 0x103C, 0x1840, "Radeon HD 7650M(0x103C-0x1840)"},
{0x1002, 0x6841, 0x103C, 0x1842, "Radeon HD 7650M(0x103C-0x1842)"},
{0x1002, 0x6841, 0x103C, 0x1844, "Radeon HD 7650M(0x103C-0x1844)"},
{0x1002, 0x6841, 0x1043, 0x100A, "Radeon HD 7650M(0x1043-0x100A)"},
{0x1002, 0x6841, 0x1043, 0x104B, "Radeon HD 7650M(0x1043-0x104B)"},
{0x1002, 0x6841, 0x1043, 0x10DC, "Radeon HD 7650M(0x1043-0x10DC)"},
{0x1002, 0x6841, 0x1043, 0x2134, "Radeon HD 7650M(0x1043-0x2134)"},
{0x1002, 0x6841, 0x1179, 0x0001, "Radeon HD 7570M(0x1179-0x0001)"},
{0x1002, 0x6841, 0x1179, 0x0002, "Radeon HD 7570M(0x1179-0x0002)"},
{0x1002, 0x6841, 0x1179, 0xFB43, "Radeon HD 7550M(0x1179-0xFB43)"},
{0x1002, 0x6841, 0x1179, 0xFB91, "Radeon HD 7550M(0x1179-0xFB91)"},
{0x1002, 0x6841, 0x1179, 0xFB92, "Radeon HD 7550M(0x1179-0xFB92)"},
{0x1002, 0x6841, 0x1179, 0xFB93, "Radeon HD 7550M(0x1179-0xFB93)"},
{0x1002, 0x6841, 0x1179, 0xFBA2, "Radeon HD 7550M(0x1179-0xFBA2)"},
{0x1002, 0x6841, 0x1179, 0xFBA3, "Radeon HD 7550M(0x1179-0xFBA3)"},
{0x1002, 0x6841, 0x144D, 0xC0C7, "Radeon HD 7550M(0x144D-0xC0C7)"},
{0x1002, 0x6842, 0xFFFF, 0xFFFF, "Thames LE [Radeon HD 7000M Series](0x6842)"},
{0x1002, 0x6843, 0xFFFF, 0xFFFF, "Thames [Radeon HD 7670M](0x6843)"},
{0x1002, 0x6860, 0xFFFF, 0xFFFF, "Vega 10 [Instinct MI25/MI25x2/V340/V320](0x6860)"},
{0x1002, 0x6860, 0x1002, 0x0C35, "Radeon PRO V320(0x1002-0x0C35)"},
{0x1002, 0x6860, 0x1002, 0x6C75, "Radeon PRO V320(0x1002-0x6C75)"},
{0x1002, 0x6860, 0x106B, 0x017C, "Radeon Pro Vega 64(0x106B-0x017C)"},
{0x1002, 0x6861, 0xFFFF, 0xFFFF, "Vega 10 XT [Radeon PRO WX 9100](0x6861)"},
{0x1002, 0x6862, 0xFFFF, 0xFFFF, "Vega 10 XT [Radeon PRO SSG](0x6862)"},
{0x1002, 0x6863, 0xFFFF, 0xFFFF, "Vega 10 XTX [Radeon Vega Frontier Edition](0x6863)"},
{0x1002, 0x6864, 0xFFFF, 0xFFFF, "Vega 10 [Radeon Pro V340/Instinct MI25x2](0x6864)"},
{0x1002, 0x6867, 0xFFFF, 0xFFFF, "Vega 10 XL [Radeon Pro Vega 56](0x6867)"},
{0x1002, 0x6868, 0xFFFF, 0xFFFF, "Vega 10 [Radeon PRO WX 8100/8200](0x6868)"},
{0x1002, 0x6869, 0xFFFF, 0xFFFF, "Vega 10 XGA [Radeon Pro Vega 48](0x6869)"},
{0x1002, 0x686A, 0xFFFF, 0xFFFF, "Vega 10 LEA(0x686A)"},
{0x1002, 0x686B, 0xFFFF, 0xFFFF, "Vega 10 XTXA [Radeon Pro Vega 64X](0x686B)"},
{0x1002, 0x686C, 0xFFFF, 0xFFFF, "Vega 10 [Instinct MI25 MxGPU/MI25x2 MxGPU/V340 MxGPU/V340L MxGPU](0x686C)"},
{0x1002, 0x686D, 0xFFFF, 0xFFFF, "Vega 10 GLXTA(0x686D)"},
{0x1002, 0x686E, 0xFFFF, 0xFFFF, "Vega 10 GLXLA(0x686E)"},
{0x1002, 0x687F, 0xFFFF, 0xFFFF, "Vega 10 XL/XT [Radeon RX Vega 56/64](0x687F)"},
{0x1002, 0x687F, 0x1002, 0x0B36, "RX Vega64(0x1002-0x0B36)"},
{0x1002, 0x687F, 0x1002, 0x6B76, "AMD Radeon RX Vega 56 8GB(0x1002-0x6B76)"},
{0x1002, 0x687F, 0x1043, 0x04C4, "Radeon RX Vega 64(0x1043-0x04C4)"},
{0x1002, 0x687F, 0x1043, 0x0555, "ROG STRIX RX Vega 56 8GB(0x1043-0x0555)"},
{0x1002, 0x687F, 0x1458, 0x230C, "Radeon RX VEGA 56 GAMING OC 8G(0x1458-0x230C)"},
{0x1002, 0x687F, 0x1DA2, 0xE376, "Radeon RX VEGA 56 Pulse 8GB OC HBM2(0x1DA2-0xE376)"},
{0x1002, 0x6880, 0xFFFF, 0xFFFF, "Lexington [Radeon HD 6550M](0x6880)"},
{0x1002, 0x6880, 0x103C, 0x163C, "Pavilion dv6 Radeon HD 6550M(0x103C-0x163C)"},
{0x1002, 0x6888, 0xFFFF, 0xFFFF, "Cypress XT [FirePro V8800](0x6888)"},
{0x1002, 0x6889, 0xFFFF, 0xFFFF, "Cypress PRO [FirePro V7800](0x6889)"},
{0x1002, 0x6889, 0x1002, 0x0301, "FirePro V7800P(0x1002-0x0301)"},
{0x1002, 0x6889, 0x13CC, 0x3D1F, "MXRT-7400(0x13CC-0x3D1F)"},
{0x1002, 0x688A, 0xFFFF, 0xFFFF, "Cypress XT [FirePro V9800](0x688A)"},
{0x1002, 0x688A, 0x1002, 0x030C, "FirePro V9800P(0x1002-0x030C)"},
{0x1002, 0x688C, 0xFFFF, 0xFFFF, "Cypress XT GL [FireStream 9370](0x688C)"},
{0x1002, 0x688D, 0xFFFF, 0xFFFF, "Cypress PRO GL [FireStream 9350](0x688D)"},
{0x1002, 0x6898, 0xFFFF, 0xFFFF, "Cypress XT [Radeon HD 5870](0x6898)"},
{0x1002, 0x6898, 0x1002, 0x0B00, "Radeon HD 5870 Eyefinity Edition(0x1002-0x0B00)"},
{0x1002, 0x6898, 0x106B, 0x00D0, "Radeon HD 5870 Mac Edition(0x106B-0x00D0)"},
{0x1002, 0x6898, 0x1462, 0x8032, "Radeon HD 5870 1 GB GDDR5(0x1462-0x8032)"},
{0x1002, 0x6898, 0x174B, 0x6870, "Radeon HD 6870 1600SP Edition(0x174B-0x6870)"},
{0x1002, 0x6899, 0xFFFF, 0xFFFF, "Cypress PRO [Radeon HD 5850](0x6899)"},
{0x1002, 0x6899, 0x1043, 0x0330, "Radeon HD 5850(0x1043-0x0330)"},
{0x1002, 0x6899, 0x174B, 0x237B, "Radeon HD 5850 X2(0x174B-0x237B)"},
{0x1002, 0x6899, 0x174B, 0x6850, "Radeon HD 6850 1440SP Edition(0x174B-0x6850)"},
{0x1002, 0x689B, 0xFFFF, 0xFFFF, "Cypress PRO [Radeon HD 6800 Series](0x689B)"},
{0x1002, 0x689C, 0xFFFF, 0xFFFF, "Hemlock [Radeon HD 5970](0x689C)"},
{0x1002, 0x689C, 0x1043, 0x0352, "ARES(0x1043-0x0352)"},
{0x1002, 0x689D, 0xFFFF, 0xFFFF, "Hemlock [Radeon HD 5970](0x689D)"},
{0x1002, 0x689E, 0xFFFF, 0xFFFF, "Cypress LE [Radeon HD 5830](0x689E)"},
{0x1002, 0x68A0, 0xFFFF, 0xFFFF, "Broadway XT [Mobility Radeon HD 5870](0x68A0)"},
{0x1002, 0x68A0, 0x1028, 0x12EF, "FirePro M7820(0x1028-0x12EF)"},
{0x1002, 0x68A0, 0x103C, 0x1520, "FirePro M7820(0x103C-0x1520)"},
{0x1002, 0x68A1, 0xFFFF, 0xFFFF, "Broadway PRO [Mobility Radeon HD 5850](0x68A1)"},
{0x1002, 0x68A1, 0x106B, 0x00CC, "iMac MC511 Mobility Radeon HD 5850 MXM Module(0x106B-0x00CC)"},
{0x1002, 0x68A8, 0xFFFF, 0xFFFF, "Granville [Radeon HD 6850M/6870M](0x68A8)"},
{0x1002, 0x68A8, 0x1025, 0x0442, "Radeon HD 6850M(0x1025-0x0442)"},
{0x1002, 0x68A8, 0x1025, 0x0451, "Radeon HD 6850M(0x1025-0x0451)"},
{0x1002, 0x68A8, 0x1025, 0x050A, "Radeon HD 6850M(0x1025-0x050A)"},
{0x1002, 0x68A8, 0x1025, 0x050B, "Radeon HD 6850M(0x1025-0x050B)"},
{0x1002, 0x68A8, 0x1025, 0x050C, "Radeon HD 6850M(0x1025-0x050C)"},
{0x1002, 0x68A8, 0x1025, 0x050E, "Radeon HD 6850M(0x1025-0x050E)"},
{0x1002, 0x68A8, 0x1025, 0x050F, "Radeon HD 6850M(0x1025-0x050F)"},
{0x1002, 0x68A8, 0x1025, 0x0513, "Radeon HD 6850M(0x1025-0x0513)"},
{0x1002, 0x68A8, 0x1025, 0x0514, "Radeon HD 6850M(0x1025-0x0514)"},
{0x1002, 0x68A8, 0x1025, 0x0515, "Radeon HD 6850M(0x1025-0x0515)"},
{0x1002, 0x68A8, 0x1025, 0x0516, "Radeon HD 6850M(0x1025-0x0516)"},
{0x1002, 0x68A8, 0x1025, 0x0525, "Radeon HD 6850M(0x1025-0x0525)"},
{0x1002, 0x68A8, 0x1025, 0x0526, "Radeon HD 6850M(0x1025-0x0526)"},
{0x1002, 0x68A8, 0x1025, 0x056D, "Radeon HD 6850M(0x1025-0x056D)"},
{0x1002, 0x68A8, 0x1028, 0x048F, "Radeon HD 6870M(0x1028-0x048F)"},
{0x1002, 0x68A8, 0x1028, 0x0490, "Radeon HD 6870M(0x1028-0x0490)"},
{0x1002, 0x68A8, 0x1028, 0x04B9, "Radeon HD 6870M(0x1028-0x04B9)"},
{0x1002, 0x68A8, 0x1028, 0x04BA, "Radeon HD 6870M(0x1028-0x04BA)"},
{0x1002, 0x68A8, 0x103C, 0x159B, "Radeon HD 6850M(0x103C-0x159B)"},
{0x1002, 0x68A8, 0x144D, 0xC0AD, "Radeon HD 6850M(0x144D-0xC0AD)"},
{0x1002, 0x68A9, 0xFFFF, 0xFFFF, "Juniper XT [FirePro V5800](0x68A9)"},
{0x1002, 0x68A9, 0x13CC, 0x3D1E, "MXRT-5400(0x13CC-0x3D1E)"},
{0x1002, 0x68A9, 0x13CC, 0x3D20, "MXRT-5450(0x13CC-0x3D20)"},
{0x1002, 0x68B8, 0xFFFF, 0xFFFF, "Juniper XT [Radeon HD 5770](0x68B8)"},
{0x1002, 0x68B8, 0x106B, 0x00CF, "MacPro5,1 [Mac Pro 2.8GHz DDR3](0x106B-0x00CF)"},
{0x1002, 0x68B9, 0xFFFF, 0xFFFF, "Juniper LE [Radeon HD 5670 640SP Edition](0x68B9)"},
{0x1002, 0x68BA, 0xFFFF, 0xFFFF, "Juniper XT [Radeon HD 6770](0x68BA)"},
{0x1002, 0x68BE, 0xFFFF, 0xFFFF, "Juniper PRO [Radeon HD 5750](0x68BE)"},
{0x1002, 0x68BE, 0x148C, 0x3000, "Radeon HD 6750(0x148C-0x3000)"},
{0x1002, 0x68BF, 0xFFFF, 0xFFFF, "Juniper PRO [Radeon HD 6750](0x68BF)"},
{0x1002, 0x68BF, 0x174B, 0x6750, "Radeon HD 6750(0x174B-0x6750)"},
{0x1002, 0x68C0, 0xFFFF, 0xFFFF, "Madison [Mobility Radeon HD 5730 / 6570M](0x68C0)"},
{0x1002, 0x68C0, 0x1019, 0x2383, "Mobility Radeon HD 5730(0x1019-0x2383)"},
{0x1002, 0x68C0, 0x1028, 0x02A2, "Mobility Radeon HD 5730(0x1028-0x02A2)"},
{0x1002, 0x68C0, 0x1028, 0x02FE, "Mobility Radeon HD 5730(0x1028-0x02FE)"},
{0x1002, 0x68C0, 0x1028, 0x0419, "Mobility Radeon HD 5730(0x1028-0x0419)"},
{0x1002, 0x68C0, 0x103C, 0x147D, "Mobility Radeon HD 5730(0x103C-0x147D)"},
{0x1002, 0x68C0, 0x103C, 0x1521, "Madison XT [FirePro M5800](0x103C-0x1521)"},
{0x1002, 0x68C0, 0x103C, 0x1593, "Mobility Radeon HD 6570(0x103C-0x1593)"},
{0x1002, 0x68C0, 0x103C, 0x1596, "Mobility Radeon HD 6570(0x103C-0x1596)"},
{0x1002, 0x68C0, 0x103C, 0x1599, "Mobility Radeon HD 6570(0x103C-0x1599)"},
{0x1002, 0x68C0, 0x1043, 0x1C22, "Mobility Radeon HD 5730(0x1043-0x1C22)"},
{0x1002, 0x68C0, 0x17AA, 0x3927, "Mobility Radeon HD 5730(0x17AA-0x3927)"},
{0x1002, 0x68C0, 0x17AA, 0x3952, "Mobility Radeon HD 5730(0x17AA-0x3952)"},
{0x1002, 0x68C0, 0x17AA, 0x3978, "Radeon HD 6570M(0x17AA-0x3978)"},
{0x1002, 0x68C1, 0xFFFF, 0xFFFF, "Madison [Mobility Radeon HD 5650/5750 / 6530M/6550M](0x68C1)"},
{0x1002, 0x68C1, 0x1025, 0x0205, "Mobility Radeon HD 5650(0x1025-0x0205)"},
{0x1002, 0x68C1, 0x1025, 0x0293, "Mobility Radeon HD 5650(0x1025-0x0293)"},
{0x1002, 0x68C1, 0x1025, 0x0294, "Mobility Radeon HD 5650(0x1025-0x0294)"},
{0x1002, 0x68C1, 0x1025, 0x0296, "Mobility Radeon HD 5650(0x1025-0x0296)"},
{0x1002, 0x68C1, 0x1025, 0x0308, "Mobility Radeon HD 5650(0x1025-0x0308)"},
{0x1002, 0x68C1, 0x1025, 0x030A, "Mobility Radeon HD 5650(0x1025-0x030A)"},
{0x1002, 0x68C1, 0x1025, 0x0311, "Mobility Radeon HD 5650(0x1025-0x0311)"},
{0x1002, 0x68C1, 0x1025, 0x0312, "Mobility Radeon HD 5650(0x1025-0x0312)"},
{0x1002, 0x68C1, 0x1025, 0x031C, "Mobility Radeon HD 5650(0x1025-0x031C)"},
{0x1002, 0x68C1, 0x1025, 0x031D, "Mobility Radeon HD 5650(0x1025-0x031D)"},
{0x1002, 0x68C1, 0x1025, 0x033D, "Mobility Radeon HD 5650(0x1025-0x033D)"},
{0x1002, 0x68C1, 0x1025, 0x033E, "Mobility Radeon HD 5650(0x1025-0x033E)"},
{0x1002, 0x68C1, 0x1025, 0x033F, "Mobility Radeon HD 5650(0x1025-0x033F)"},
{0x1002, 0x68C1, 0x1025, 0x0346, "Mobility Radeon HD 5650(0x1025-0x0346)"},
{0x1002, 0x68C1, 0x1025, 0x0347, "Aspire 7740G(0x1025-0x0347)"},
{0x1002, 0x68C1, 0x1025, 0x0348, "Mobility Radeon HD 5650(0x1025-0x0348)"},
{0x1002, 0x68C1, 0x1025, 0x0356, "Mobility Radeon HD 5650(0x1025-0x0356)"},
{0x1002, 0x68C1, 0x1025, 0x0357, "Mobility Radeon HD 5650(0x1025-0x0357)"},
{0x1002, 0x68C1, 0x1025, 0x0358, "Mobility Radeon HD 5650(0x1025-0x0358)"},
{0x1002, 0x68C1, 0x1025, 0x0359, "Mobility Radeon HD 5650(0x1025-0x0359)"},
{0x1002, 0x68C1, 0x1025, 0x035A, "Mobility Radeon HD 5650(0x1025-0x035A)"},
{0x1002, 0x68C1, 0x1025, 0x035B, "Mobility Radeon HD 5650(0x1025-0x035B)"},
{0x1002, 0x68C1, 0x1025, 0x035C, "Mobility Radeon HD 5650(0x1025-0x035C)"},
{0x1002, 0x68C1, 0x1025, 0x035D, "Mobility Radeon HD 5650(0x1025-0x035D)"},
{0x1002, 0x68C1, 0x1025, 0x035E, "Mobility Radeon HD 5650(0x1025-0x035E)"},
{0x1002, 0x68C1, 0x1025, 0x0360, "Mobility Radeon HD 5650(0x1025-0x0360)"},
{0x1002, 0x68C1, 0x1025, 0x0362, "Mobility Radeon HD 5650(0x1025-0x0362)"},
{0x1002, 0x68C1, 0x1025, 0x0364, "Mobility Radeon HD 5650(0x1025-0x0364)"},
{0x1002, 0x68C1, 0x1025, 0x0365, "Mobility Radeon HD 5650(0x1025-0x0365)"},
{0x1002, 0x68C1, 0x1025, 0x0366, "Mobility Radeon HD 5650(0x1025-0x0366)"},
{0x1002, 0x68C1, 0x1025, 0x0367, "Mobility Radeon HD 5650(0x1025-0x0367)"},
{0x1002, 0x68C1, 0x1025, 0x0368, "Mobility Radeon HD 5650(0x1025-0x0368)"},
{0x1002, 0x68C1, 0x1025, 0x036C, "Mobility Radeon HD 5650(0x1025-0x036C)"},
{0x1002, 0x68C1, 0x1025, 0x036D, "Mobility Radeon HD 5650(0x1025-0x036D)"},
{0x1002, 0x68C1, 0x1025, 0x036E, "Mobility Radeon HD 5650(0x1025-0x036E)"},
{0x1002, 0x68C1, 0x1025, 0x036F, "Mobility Radeon HD 5650(0x1025-0x036F)"},
{0x1002, 0x68C1, 0x1025, 0x0372, "Mobility Radeon HD 5650(0x1025-0x0372)"},
{0x1002, 0x68C1, 0x1025, 0x0373, "Mobility Radeon HD 5650(0x1025-0x0373)"},
{0x1002, 0x68C1, 0x1025, 0x0377, "Mobility Radeon HD 5650(0x1025-0x0377)"},
{0x1002, 0x68C1, 0x1025, 0x0378, "Mobility Radeon HD 5650(0x1025-0x0378)"},
{0x1002, 0x68C1, 0x1025, 0x0379, "Mobility Radeon HD 5650(0x1025-0x0379)"},
{0x1002, 0x68C1, 0x1025, 0x037A, "Mobility Radeon HD 5650(0x1025-0x037A)"},
{0x1002, 0x68C1, 0x1025, 0x037B, "Mobility Radeon HD 5650(0x1025-0x037B)"},
{0x1002, 0x68C1, 0x1025, 0x037E, "Mobility Radeon HD 5650(0x1025-0x037E)"},
{0x1002, 0x68C1, 0x1025, 0x037F, "Mobility Radeon HD 5650(0x1025-0x037F)"},
{0x1002, 0x68C1, 0x1025, 0x0382, "Mobility Radeon HD 5650(0x1025-0x0382)"},
{0x1002, 0x68C1, 0x1025, 0x0383, "Mobility Radeon HD 5650(0x1025-0x0383)"},
{0x1002, 0x68C1, 0x1025, 0x0384, "Mobility Radeon HD 5650(0x1025-0x0384)"},
{0x1002, 0x68C1, 0x1025, 0x0385, "Mobility Radeon HD 5650(0x1025-0x0385)"},
{0x1002, 0x68C1, 0x1025, 0x0386, "Mobility Radeon HD 5650(0x1025-0x0386)"},
{0x1002, 0x68C1, 0x1025, 0x0387, "Mobility Radeon HD 5650(0x1025-0x0387)"},
{0x1002, 0x68C1, 0x1025, 0x0388, "Mobility Radeon HD 5650(0x1025-0x0388)"},
{0x1002, 0x68C1, 0x1025, 0x038B, "Mobility Radeon HD 5650(0x1025-0x038B)"},
{0x1002, 0x68C1, 0x1025, 0x038C, "Mobility Radeon HD 5650(0x1025-0x038C)"},
{0x1002, 0x68C1, 0x1025, 0x039A, "Mobility Radeon HD 5650(0x1025-0x039A)"},
{0x1002, 0x68C1, 0x1025, 0x0411, "Mobility Radeon HD 5650(0x1025-0x0411)"},
{0x1002, 0x68C1, 0x1025, 0x0412, "Mobility Radeon HD 5650(0x1025-0x0412)"},
{0x1002, 0x68C1, 0x1025, 0x0418, "Mobility Radeon HD 5650(0x1025-0x0418)"},
{0x1002, 0x68C1, 0x1025, 0x0419, "Mobility Radeon HD 5650(0x1025-0x0419)"},
{0x1002, 0x68C1, 0x1025, 0x0420, "Mobility Radeon HD 5650(0x1025-0x0420)"},
{0x1002, 0x68C1, 0x1025, 0x0421, "Mobility Radeon HD 5650(0x1025-0x0421)"},
{0x1002, 0x68C1, 0x1025, 0x0425, "Mobility Radeon HD 5650(0x1025-0x0425)"},
{0x1002, 0x68C1, 0x1025, 0x042A, "Mobility Radeon HD 5650(0x1025-0x042A)"},
{0x1002, 0x68C1, 0x1025, 0x042E, "Mobility Radeon HD 5650(0x1025-0x042E)"},
{0x1002, 0x68C1, 0x1025, 0x042F, "Mobility Radeon HD 5650(0x1025-0x042F)"},
{0x1002, 0x68C1, 0x1025, 0x0432, "Mobility Radeon HD 5650(0x1025-0x0432)"},
{0x1002, 0x68C1, 0x1025, 0x0433, "Mobility Radeon HD 5650(0x1025-0x0433)"},
{0x1002, 0x68C1, 0x1025, 0x0442, "Mobility Radeon HD 5650(0x1025-0x0442)"},
{0x1002, 0x68C1, 0x1025, 0x044C, "Mobility Radeon HD 5650(0x1025-0x044C)"},
{0x1002, 0x68C1, 0x1025, 0x044E, "Mobility Radeon HD 5650(0x1025-0x044E)"},
{0x1002, 0x68C1, 0x1025, 0x0451, "Mobility Radeon HD 5650(0x1025-0x0451)"},
{0x1002, 0x68C1, 0x1025, 0x0454, "Mobility Radeon HD 5650(0x1025-0x0454)"},
{0x1002, 0x68C1, 0x1025, 0x0455, "Mobility Radeon HD 5650(0x1025-0x0455)"},
{0x1002, 0x68C1, 0x1025, 0x0475, "Mobility Radeon HD 5650(0x1025-0x0475)"},
{0x1002, 0x68C1, 0x1025, 0x0476, "Mobility Radeon HD 5650(0x1025-0x0476)"},
{0x1002, 0x68C1, 0x1025, 0x0487, "Mobility Radeon HD 5650(0x1025-0x0487)"},
{0x1002, 0x68C1, 0x1025, 0x0489, "Mobility Radeon HD 5650(0x1025-0x0489)"},
{0x1002, 0x68C1, 0x1025, 0x0498, "Mobility Radeon HD 5650(0x1025-0x0498)"},
{0x1002, 0x68C1, 0x1025, 0x0517, "Radeon HD 6550M(0x1025-0x0517)"},
{0x1002, 0x68C1, 0x1025, 0x051A, "Radeon HD 6550M(0x1025-0x051A)"},
{0x1002, 0x68C1, 0x1025, 0x051B, "Radeon HD 6550M(0x1025-0x051B)"},
{0x1002, 0x68C1, 0x1025, 0x051C, "Radeon HD 6550M(0x1025-0x051C)"},
{0x1002, 0x68C1, 0x1025, 0x051D, "Radeon HD 6550M(0x1025-0x051D)"},
{0x1002, 0x68C1, 0x1025, 0x0525, "Radeon HD 6550M(0x1025-0x0525)"},
{0x1002, 0x68C1, 0x1025, 0x0526, "Radeon HD 6550M(0x1025-0x0526)"},
{0x1002, 0x68C1, 0x1025, 0x052B, "Radeon HD 6550M(0x1025-0x052B)"},
{0x1002, 0x68C1, 0x1025, 0x052C, "Radeon HD 6550M(0x1025-0x052C)"},
{0x1002, 0x68C1, 0x1025, 0x053C, "Radeon HD 6550M(0x1025-0x053C)"},
{0x1002, 0x68C1, 0x1025, 0x053D, "Radeon HD 6550M(0x1025-0x053D)"},
{0x1002, 0x68C1, 0x1025, 0x053E, "Radeon HD 6550M(0x1025-0x053E)"},
{0x1002, 0x68C1, 0x1025, 0x053F, "Radeon HD 6550M(0x1025-0x053F)"},
{0x1002, 0x68C1, 0x1025, 0x0607, "Radeon HD 6550M(0x1025-0x0607)"},
{0x1002, 0x68C1, 0x1028, 0x041B, "Mobility Radeon HD 5650(0x1028-0x041B)"},
{0x1002, 0x68C1, 0x1028, 0x0447, "Mobility Radeon HD 5650(0x1028-0x0447)"},
{0x1002, 0x68C1, 0x1028, 0x0448, "Mobility Radeon HD 5650(0x1028-0x0448)"},
{0x1002, 0x68C1, 0x1028, 0x0456, "Mobility Radeon HD 5650(0x1028-0x0456)"},
{0x1002, 0x68C1, 0x1028, 0x0457, "Mobility Radeon HD 5650(0x1028-0x0457)"},
{0x1002, 0x68C1, 0x103C, 0x1436, "Mobility Radeon HD 5650(0x103C-0x1436)"},
{0x1002, 0x68C1, 0x103C, 0x1437, "Mobility Radeon HD 5650(0x103C-0x1437)"},
{0x1002, 0x68C1, 0x103C, 0x1440, "Mobility Radeon HD 5650(0x103C-0x1440)"},
{0x1002, 0x68C1, 0x103C, 0x1448, "Mobility Radeon HD 5650(0x103C-0x1448)"},
{0x1002, 0x68C1, 0x103C, 0x1449, "Mobility Radeon HD 5650(0x103C-0x1449)"},
{0x1002, 0x68C1, 0x103C, 0x144A, "Mobility Radeon HD 5650(0x103C-0x144A)"},
{0x1002, 0x68C1, 0x103C, 0x144B, "Mobility Radeon HD 5650(0x103C-0x144B)"},
{0x1002, 0x68C1, 0x103C, 0x147B, "Mobility Radeon HD 5650(0x103C-0x147B)"},
{0x1002, 0x68C1, 0x103C, 0x149C, "Mobility Radeon HD 5650(0x103C-0x149C)"},
{0x1002, 0x68C1, 0x103C, 0x149E, "Mobility Radeon HD 5650(0x103C-0x149E)"},
{0x1002, 0x68C1, 0x103C, 0x1521, "Madison Pro [FirePro M5800](0x103C-0x1521)"},
{0x1002, 0x68C1, 0x1043, 0x1BC2, "Mobility Radeon HD 5650(0x1043-0x1BC2)"},
{0x1002, 0x68C1, 0x104D, 0x9071, "Mobility Radeon HD 5650(0x104D-0x9071)"},
{0x1002, 0x68C1, 0x104D, 0x9077, "Mobility Radeon HD 5650(0x104D-0x9077)"},
{0x1002, 0x68C1, 0x104D, 0x9081, "Mobility Radeon HD 5650(0x104D-0x9081)"},
{0x1002, 0x68C1, 0x1179, 0xFD00, "Mobility Radeon HD 5650(0x1179-0xFD00)"},
{0x1002, 0x68C1, 0x1179, 0xFD12, "Mobility Radeon HD 5650(0x1179-0xFD12)"},
{0x1002, 0x68C1, 0x1179, 0xFD1A, "Mobility Radeon HD 5650(0x1179-0xFD1A)"},
{0x1002, 0x68C1, 0x1179, 0xFD30, "Mobility Radeon HD 5650(0x1179-0xFD30)"},
{0x1002, 0x68C1, 0x1179, 0xFD31, "Mobility Radeon HD 5650(0x1179-0xFD31)"},
{0x1002, 0x68C1, 0x1179, 0xFD50, "Mobility Radeon HD 5650(0x1179-0xFD50)"},
{0x1002, 0x68C1, 0x1179, 0xFD52, "Radeon HD 6530M(0x1179-0xFD52)"},
{0x1002, 0x68C1, 0x1179, 0xFD63, "Radeon HD 6530M(0x1179-0xFD63)"},
{0x1002, 0x68C1, 0x1179, 0xFD65, "Radeon HD 6530M(0x1179-0xFD65)"},
{0x1002, 0x68C1, 0x1179, 0xFDD0, "Mobility Radeon HD 5650(0x1179-0xFDD0)"},
{0x1002, 0x68C1, 0x1179, 0xFDD2, "Radeon HD 6530M(0x1179-0xFDD2)"},
{0x1002, 0x68C1, 0x144D, 0xC07E, "Mobility Radeon HD 5650(0x144D-0xC07E)"},
{0x1002, 0x68C1, 0x144D, 0xC085, "Mobility Radeon HD 5650(0x144D-0xC085)"},
{0x1002, 0x68C1, 0x14C0, 0x0043, "Mobility Radeon HD 5650(0x14C0-0x0043)"},
{0x1002, 0x68C1, 0x14C0, 0x004D, "Mobility Radeon HD 5650(0x14C0-0x004D)"},
{0x1002, 0x68C1, 0x17AA, 0x3928, "Mobility Radeon HD 5650(0x17AA-0x3928)"},
{0x1002, 0x68C1, 0x17AA, 0x3951, "Mobility Radeon HD 5650(0x17AA-0x3951)"},
{0x1002, 0x68C1, 0x17AA, 0x3977, "Radeon HD 6550M(0x17AA-0x3977)"},
{0x1002, 0x68C7, 0xFFFF, 0xFFFF, "Pinewood [Mobility Radeon HD 5570/6550A](0x68C7)"},
{0x1002, 0x68C7, 0x1462, 0x2241, "Mobility Radeon HD 5570(0x1462-0x2241)"},
{0x1002, 0x68C7, 0x1462, 0x2243, "Mobility Radeon HD 5570(0x1462-0x2243)"},
{0x1002, 0x68C7, 0x1462, 0x2244, "Mobility Radeon HD 5570(0x1462-0x2244)"},
{0x1002, 0x68C7, 0x1462, 0x2245, "Radeon HD 6550A(0x1462-0x2245)"},
{0x1002, 0x68C7, 0x1462, 0x2246, "Radeon HD 6550A(0x1462-0x2246)"},
{0x1002, 0x68C8, 0xFFFF, 0xFFFF, "Redwood XT GL [FirePro V4800](0x68C8)"},
{0x1002, 0x68C9, 0xFFFF, 0xFFFF, "Redwood PRO GL [FirePro V3800](0x68C9)"},
{0x1002, 0x68C9, 0x13CC, 0x3D1D, "MXRT-2400(0x13CC-0x3D1D)"},
{0x1002, 0x68D8, 0xFFFF, 0xFFFF, "Redwood XT [Radeon HD 5670/5690/5730](0x68D8)"},
{0x1002, 0x68D8, 0x1028, 0x68E0, "Radeon HD 5670(0x1028-0x68E0)"},
{0x1002, 0x68D8, 0x174B, 0x5690, "Radeon HD 5690(0x174B-0x5690)"},
{0x1002, 0x68D8, 0x174B, 0x5730, "Radeon HD 5730(0x174B-0x5730)"},
{0x1002, 0x68D8, 0x174B, 0xE151, "Radeon HD 5670(0x174B-0xE151)"},
{0x1002, 0x68D8, 0x1787, 0x3000, "Radeon HD 5730(0x1787-0x3000)"},
{0x1002, 0x68D8, 0x17AF, 0x3010, "Radeon HD 5730(0x17AF-0x3010)"},
{0x1002, 0x68D8, 0x17AF, 0x3011, "Radeon HD 5690(0x17AF-0x3011)"},
{0x1002, 0x68D9, 0xFFFF, 0xFFFF, "Redwood PRO [Radeon HD 5550/5570/5630/6510/6610/7570](0x68D9)"},
{0x1002, 0x68D9, 0x103C, 0x6870, "Radeon HD 5570(0x103C-0x6870)"},
{0x1002, 0x68D9, 0x103C, 0x6872, "Radeon HD 5570(0x103C-0x6872)"},
{0x1002, 0x68D9, 0x1043, 0x03CE, "Radeon HD 5550(0x1043-0x03CE)"},
{0x1002, 0x68D9, 0x1462, 0x2151, "Radeon HD 5570(0x1462-0x2151)"},
{0x1002, 0x68D9, 0x1462, 0x2240, "Radeon HD 5570(0x1462-0x2240)"},
{0x1002, 0x68D9, 0x148C, 0x3000, "Radeon HD 6510(0x148C-0x3000)"},
{0x1002, 0x68D9, 0x148C, 0x3001, "Radeon HD 6610(0x148C-0x3001)"},
{0x1002, 0x68D9, 0x1545, 0x5550, "Radeon HD 5550(0x1545-0x5550)"},
{0x1002, 0x68D9, 0x1545, 0x7570, "Radeon HD 7570(0x1545-0x7570)"},
{0x1002, 0x68D9, 0x1642, 0x3985, "Radeon HD 5570(0x1642-0x3985)"},
{0x1002, 0x68D9, 0x1642, 0x3996, "Radeon HD 5570(0x1642-0x3996)"},
{0x1002, 0x68D9, 0x174B, 0x3000, "Radeon HD 6510(0x174B-0x3000)"},
{0x1002, 0x68D9, 0x174B, 0x6510, "Radeon HD 6510(0x174B-0x6510)"},
{0x1002, 0x68D9, 0x174B, 0x6610, "Radeon HD 6610(0x174B-0x6610)"},
{0x1002, 0x68D9, 0x174B, 0xE142, "Radeon HD 5570(0x174B-0xE142)"},
{0x1002, 0x68D9, 0x1787, 0x3000, "Radeon HD 6510(0x1787-0x3000)"},
{0x1002, 0x68D9, 0x17AF, 0x3000, "Radeon HD 6510(0x17AF-0x3000)"},
{0x1002, 0x68D9, 0x17AF, 0x3010, "Radeon HD 5630(0x17AF-0x3010)"},
{0x1002, 0x68DA, 0xFFFF, 0xFFFF, "Redwood LE [Radeon HD 5550/5570/5630/6390/6490/7570](0x68DA)"},
{0x1002, 0x68DA, 0x1462, 0x8071, "VR5550-MD1G (Radeon HD 5550)(0x1462-0x8071)"},
{0x1002, 0x68DA, 0x148C, 0x3000, "Radeon HD 6390(0x148C-0x3000)"},
{0x1002, 0x68DA, 0x148C, 0x3001, "Radeon HD 6490(0x148C-0x3001)"},
{0x1002, 0x68DA, 0x1545, 0x7570, "Radeon HD 7570(0x1545-0x7570)"},
{0x1002, 0x68DA, 0x174B, 0x3000, "Radeon HD 6390(0x174B-0x3000)"},
{0x1002, 0x68DA, 0x174B, 0x5570, "Radeon HD 5570(0x174B-0x5570)"},
{0x1002, 0x68DA, 0x174B, 0x5630, "Radeon HD 5630(0x174B-0x5630)"},
{0x1002, 0x68DA, 0x174B, 0x6490, "Radeon HD 6490(0x174B-0x6490)"},
{0x1002, 0x68DA, 0x1787, 0x3000, "Radeon HD 5630(0x1787-0x3000)"},
{0x1002, 0x68DA, 0x17AF, 0x3000, "Radeon HD 6390(0x17AF-0x3000)"},
{0x1002, 0x68DA, 0x17AF, 0x3010, "Radeon HD 5630(0x17AF-0x3010)"},
{0x1002, 0x68DE, 0xFFFF, 0xFFFF, "Redwood(0x68DE)"},
{0x1002, 0x68E0, 0xFFFF, 0xFFFF, "Park [Mobility Radeon HD 5430/5450/5470](0x68E0)"},
{0x1002, 0x68E0, 0x1028, 0x0404, "Mobility Radeon HD 5450(0x1028-0x0404)"},
{0x1002, 0x68E0, 0x1028, 0x0414, "Mobility Radeon HD 5450(0x1028-0x0414)"},
{0x1002, 0x68E0, 0x1028, 0x0434, "Mobility Radeon HD 5450(0x1028-0x0434)"},
{0x1002, 0x68E0, 0x103C, 0x1433, "Mobility Radeon HD 5450(0x103C-0x1433)"},
{0x1002, 0x68E0, 0x103C, 0x1434, "Mobility Radeon HD 5450(0x103C-0x1434)"},
{0x1002, 0x68E0, 0x103C, 0x1469, "Mobility Radeon HD 5450(0x103C-0x1469)"},
{0x1002, 0x68E0, 0x103C, 0x146B, "Mobility Radeon HD 5450(0x103C-0x146B)"},
{0x1002, 0x68E0, 0x103C, 0x1486, "TouchSmart tm2-2050er discrete GPU (Mobility Radeon HD 5450)(0x103C-0x1486)"},
{0x1002, 0x68E0, 0x103C, 0x1622, "Mobility Radeon HD 5450(0x103C-0x1622)"},
{0x1002, 0x68E0, 0x103C, 0x1623, "Mobility Radeon HD 5450(0x103C-0x1623)"},
{0x1002, 0x68E0, 0x103C, 0xEEEE, "Mobility Radeon HD 5450(0x103C-0xEEEE)"},
{0x1002, 0x68E0, 0x104D, 0x9076, "Mobility Radeon HD 5450(0x104D-0x9076)"},
{0x1002, 0x68E0, 0x1682, 0x304E, "Caicos [Radeon HD 5450](0x1682-0x304E)"},
{0x1002, 0x68E0, 0x1682, 0x6000, "Caicos [Radeon HD 5450](0x1682-0x6000)"},
{0x1002, 0x68E0, 0x17AA, 0x9E52, "FirePro M3800(0x17AA-0x9E52)"},
{0x1002, 0x68E0, 0x17AA, 0x9E53, "FirePro M3800(0x17AA-0x9E53)"},
{0x1002, 0x68E1, 0xFFFF, 0xFFFF, "Park [Mobility Radeon HD 5430](0x68E1)"},
{0x1002, 0x68E1, 0x1043, 0x041F, "Caicos [Radeon HD 7350](0x1043-0x041F)"},
{0x1002, 0x68E1, 0x1043, 0x3000, "Caicos [Radeon HD 5450](0x1043-0x3000)"},
{0x1002, 0x68E1, 0x148C, 0x3000, "Caicos [Radeon HD 5450](0x148C-0x3000)"},
{0x1002, 0x68E1, 0x148C, 0x3001, "Caicos [Radeon HD 6230](0x148C-0x3001)"},
{0x1002, 0x68E1, 0x148C, 0x3002, "Caicos [Radeon HD 6250](0x148C-0x3002)"},
{0x1002, 0x68E1, 0x148C, 0x3003, "Caicos [Radeon HD 6350](0x148C-0x3003)"},
{0x1002, 0x68E1, 0x148C, 0x7350, "Caicos [Radeon HD 7350](0x148C-0x7350)"},
{0x1002, 0x68E1, 0x148C, 0x8350, "Caicos [Radeon HD 8350](0x148C-0x8350)"},
{0x1002, 0x68E1, 0x1545, 0x5450, "Caicos [Radeon HD 5450](0x1545-0x5450)"},
{0x1002, 0x68E1, 0x1545, 0x7350, "Caicos [Radeon HD 7350](0x1545-0x7350)"},
{0x1002, 0x68E1, 0x1682, 0x3000, "Caicos [Radeon HD 5450](0x1682-0x3000)"},
{0x1002, 0x68E1, 0x1682, 0x6000, "Caicos [Radeon HD 5450](0x1682-0x6000)"},
{0x1002, 0x68E1, 0x1682, 0x7350, "Caicos [Radeon HD 7350](0x1682-0x7350)"},
{0x1002, 0x68E1, 0x174B, 0x3000, "Caicos [Radeon HD 5450](0x174B-0x3000)"},
{0x1002, 0x68E1, 0x174B, 0x5470, "Caicos [Radeon HD 5470](0x174B-0x5470)"},
{0x1002, 0x68E1, 0x174B, 0x6000, "Caicos [Radeon HD 5450](0x174B-0x6000)"},
{0x1002, 0x68E1, 0x174B, 0x6230, "Caicos [Radeon HD 6230](0x174B-0x6230)"},
{0x1002, 0x68E1, 0x174B, 0x6350, "Caicos [Radeon HD 6350](0x174B-0x6350)"},
{0x1002, 0x68E1, 0x174B, 0x7350, "Caicos [Radeon HD 7350](0x174B-0x7350)"},
{0x1002, 0x68E1, 0x1787, 0x3000, "Caicos [Radeon HD 5450](0x1787-0x3000)"},
{0x1002, 0x68E1, 0x17AF, 0x3000, "Caicos [Radeon HD 5450](0x17AF-0x3000)"},
{0x1002, 0x68E1, 0x17AF, 0x3001, "Caicos [Radeon HD 6230](0x17AF-0x3001)"},
{0x1002, 0x68E1, 0x17AF, 0x3014, "Caicos [Radeon HD 6350](0x17AF-0x3014)"},
{0x1002, 0x68E1, 0x17AF, 0x3015, "Caicos [Radeon HD 7350](0x17AF-0x3015)"},
{0x1002, 0x68E1, 0x17AF, 0x8350, "Caicos [Radeon HD 8350 OEM](0x17AF-0x8350)"},
{0x1002, 0x68E4, 0xFFFF, 0xFFFF, "Robson CE [Radeon HD 6370M/7370M](0x68E4)"},
{0x1002, 0x68E4, 0x1019, 0x2386, "Radeon HD 6350M(0x1019-0x2386)"},
{0x1002, 0x68E4, 0x1019, 0x2387, "Radeon HD 6350M(0x1019-0x2387)"},
{0x1002, 0x68E4, 0x1019, 0x238D, "Radeon HD 6370M(0x1019-0x238D)"},
{0x1002, 0x68E4, 0x1019, 0x238E, "Radeon HD 6370M(0x1019-0x238E)"},
{0x1002, 0x68E4, 0x1025, 0x0382, "Radeon HD 6370M(0x1025-0x0382)"},
{0x1002, 0x68E4, 0x1025, 0x0489, "Radeon HD 6370M(0x1025-0x0489)"},
{0x1002, 0x68E4, 0x1025, 0x048A, "Radeon HD 6370M(0x1025-0x048A)"},
{0x1002, 0x68E4, 0x1025, 0x048B, "Radeon HD 6370M(0x1025-0x048B)"},
{0x1002, 0x68E4, 0x1025, 0x048C, "Radeon HD 6370M(0x1025-0x048C)"},
{0x1002, 0x68E4, 0x1028, 0x04C1, "Radeon HD 6370M(0x1028-0x04C1)"},
{0x1002, 0x68E4, 0x1028, 0x04CA, "Radeon HD 6370M(0x1028-0x04CA)"},
{0x1002, 0x68E4, 0x1028, 0x04CC, "Radeon HD 6370M(0x1028-0x04CC)"},
{0x1002, 0x68E4, 0x1028, 0x04CD, "Radeon HD 6370M(0x1028-0x04CD)"},
{0x1002, 0x68E4, 0x1028, 0x04D7, "Radeon HD 6370M(0x1028-0x04D7)"},
{0x1002, 0x68E4, 0x103C, 0x1411, "Radeon HD 6370M(0x103C-0x1411)"},
{0x1002, 0x68E4, 0x103C, 0x1421, "Radeon HD 6370M(0x103C-0x1421)"},
{0x1002, 0x68E4, 0x103C, 0x1426, "Radeon HD 6370M(0x103C-0x1426)"},
{0x1002, 0x68E4, 0x103C, 0x1428, "Radeon HD 6370M(0x103C-0x1428)"},
{0x1002, 0x68E4, 0x103C, 0x142A, "Radeon HD 6370M(0x103C-0x142A)"},
{0x1002, 0x68E4, 0x103C, 0x142B, "Radeon HD 6370M(0x103C-0x142B)"},
{0x1002, 0x68E4, 0x103C, 0x143A, "Radeon HD 6370M(0x103C-0x143A)"},
{0x1002, 0x68E4, 0x103C, 0x143C, "Radeon HD 6370M(0x103C-0x143C)"},
{0x1002, 0x68E4, 0x103C, 0x1445, "Radeon HD 6370M(0x103C-0x1445)"},
{0x1002, 0x68E4, 0x103C, 0x162C, "Radeon HD 6370M(0x103C-0x162C)"},
{0x1002, 0x68E4, 0x103C, 0x162D, "Radeon HD 6370M(0x103C-0x162D)"},
{0x1002, 0x68E4, 0x103C, 0x162E, "Radeon HD 6370M(0x103C-0x162E)"},
{0x1002, 0x68E4, 0x103C, 0x162F, "Radeon HD 6370M(0x103C-0x162F)"},
{0x1002, 0x68E4, 0x103C, 0x1639, "Radeon HD 6370M(0x103C-0x1639)"},
{0x1002, 0x68E4, 0x103C, 0x163A, "Radeon HD 6370M(0x103C-0x163A)"},
{0x1002, 0x68E4, 0x103C, 0x163B, "Radeon HD 6370M(0x103C-0x163B)"},
{0x1002, 0x68E4, 0x103C, 0x163C, "Radeon HD 6370M(0x103C-0x163C)"},
{0x1002, 0x68E4, 0x103C, 0x163D, "Radeon HD 6370M(0x103C-0x163D)"},
{0x1002, 0x68E4, 0x103C, 0x163E, "Radeon HD 6370M(0x103C-0x163E)"},
{0x1002, 0x68E4, 0x103C, 0x163F, "Radeon HD 6370M(0x103C-0x163F)"},
{0x1002, 0x68E4, 0x103C, 0x1641, "Radeon HD 6370M(0x103C-0x1641)"},
{0x1002, 0x68E4, 0x103C, 0x1643, "Radeon HD 6370M(0x103C-0x1643)"},
{0x1002, 0x68E4, 0x103C, 0x3578, "Radeon HD 6370M(0x103C-0x3578)"},
{0x1002, 0x68E4, 0x103C, 0x357A, "Radeon HD 6370M(0x103C-0x357A)"},
{0x1002, 0x68E4, 0x103C, 0x3673, "Radeon HD 6370M(0x103C-0x3673)"},
{0x1002, 0x68E4, 0x103C, 0x3675, "Radeon HD 6370M(0x103C-0x3675)"},
{0x1002, 0x68E4, 0x1043, 0x1C92, "Radeon HD 6370M(0x1043-0x1C92)"},
{0x1002, 0x68E4, 0x1043, 0x84A1, "Radeon HD 6370M(0x1043-0x84A1)"},
{0x1002, 0x68E4, 0x1043, 0x84AD, "Radeon HD 6370M(0x1043-0x84AD)"},
{0x1002, 0x68E4, 0x104D, 0x9081, "Radeon HD 6370M(0x104D-0x9081)"},
{0x1002, 0x68E4, 0x1545, 0x7350, "Cedar [Radeon HD 7350](0x1545-0x7350)"},
{0x1002, 0x68E4, 0x1558, 0x4510, "Radeon HD 6370M(0x1558-0x4510)"},
{0x1002, 0x68E4, 0x1558, 0x5505, "Radeon HD 6370M(0x1558-0x5505)"},
{0x1002, 0x68E4, 0x174B, 0x5450, "Cedar [Radeon HD 5450](0x174B-0x5450)"},
{0x1002, 0x68E4, 0x17AA, 0x21DD, "Radeon HD 6370M(0x17AA-0x21DD)"},
{0x1002, 0x68E4, 0x17AA, 0x21E9, "Radeon HD 6370M(0x17AA-0x21E9)"},
{0x1002, 0x68E4, 0x17AA, 0x3971, "Radeon HD 6370M(0x17AA-0x3971)"},
{0x1002, 0x68E4, 0x17AA, 0x3972, "Radeon HD 7370M(0x17AA-0x3972)"},
{0x1002, 0x68E4, 0x17AA, 0x397A, "Radeon HD 6370M/7370M(0x17AA-0x397A)"},
{0x1002, 0x68E4, 0x17AA, 0x397B, "Radeon HD 6370M/7370M(0x17AA-0x397B)"},
{0x1002, 0x68E4, 0x17AA, 0x397F, "Radeon HD 7370M(0x17AA-0x397F)"},
{0x1002, 0x68E5, 0xFFFF, 0xFFFF, "Robson LE [Radeon HD 6330M](0x68E5)"},
{0x1002, 0x68E5, 0x1179, 0xFD3C, "Radeon HD 6330M(0x1179-0xFD3C)"},
{0x1002, 0x68E5, 0x1179, 0xFD50, "Radeon HD 6330M(0x1179-0xFD50)"},
{0x1002, 0x68E5, 0x1179, 0xFD52, "Radeon HD 6330M(0x1179-0xFD52)"},
{0x1002, 0x68E5, 0x1179, 0xFD63, "Radeon HD 6330M(0x1179-0xFD63)"},
{0x1002, 0x68E5, 0x1179, 0xFD65, "Radeon HD 6330M(0x1179-0xFD65)"},
{0x1002, 0x68E5, 0x1179, 0xFD73, "Radeon HD 6330M(0x1179-0xFD73)"},
{0x1002, 0x68E5, 0x1179, 0xFD75, "Radeon HD 6330M(0x1179-0xFD75)"},
{0x1002, 0x68E5, 0x1179, 0xFDD0, "Radeon HD 6330M(0x1179-0xFDD0)"},
{0x1002, 0x68E5, 0x1179, 0xFDD2, "Radeon HD 6330M(0x1179-0xFDD2)"},
{0x1002, 0x68E5, 0x1179, 0xFDEA, "Radeon HD 6330M(0x1179-0xFDEA)"},
{0x1002, 0x68E5, 0x1179, 0xFDF8, "Radeon HD 6330M(0x1179-0xFDF8)"},
{0x1002, 0x68E5, 0x148C, 0x5450, "Cedar [Radeon HD 5450](0x148C-0x5450)"},
{0x1002, 0x68E5, 0x148C, 0x6350, "Cedar [Radeon HD 6350](0x148C-0x6350)"},
{0x1002, 0x68E5, 0x148C, 0x7350, "Cedar [Radeon HD 7350](0x148C-0x7350)"},
{0x1002, 0x68E5, 0x148C, 0x8350, "Cedar [Radeon HD 8350](0x148C-0x8350)"},
{0x1002, 0x68E5, 0x1545, 0x7350, "Cedar [Radeon HD 7350](0x1545-0x7350)"},
{0x1002, 0x68E8, 0xFFFF, 0xFFFF, "Cedar(0x68E8)"},
{0x1002, 0x68E9, 0xFFFF, 0xFFFF, "Cedar [ATI FirePro (FireGL) Graphics Adapter](0x68E9)"},
{0x1002, 0x68F1, 0xFFFF, 0xFFFF, "Cedar GL [FirePro 2460](0x68F1)"},
{0x1002, 0x68F2, 0xFFFF, 0xFFFF, "Cedar GL [FirePro 2270](0x68F2)"},
{0x1002, 0x68F8, 0xFFFF, 0xFFFF, "Cedar [Radeon HD 7300 Series](0x68F8)"},
{0x1002, 0x68F9, 0xFFFF, 0xFFFF, "Cedar [Radeon HD 5000/6000/7350/8350 Series](0x68F9)"},
{0x1002, 0x68F9, 0x1019, 0x0001, "Radeon HD 5450(0x1019-0x0001)"},
{0x1002, 0x68F9, 0x1019, 0x0002, "Radeon HD 5450(0x1019-0x0002)"},
{0x1002, 0x68F9, 0x1019, 0x0019, "Radeon HD 6350(0x1019-0x0019)"},
{0x1002, 0x68F9, 0x1025, 0x0518, "Radeon HD 5450(0x1025-0x0518)"},
{0x1002, 0x68F9, 0x1025, 0x0519, "Radeon HD 5450(0x1025-0x0519)"},
{0x1002, 0x68F9, 0x1028, 0x010E, "XPS 8300(0x1028-0x010E)"},
{0x1002, 0x68F9, 0x1028, 0x2126, "Radeon HD 6350(0x1028-0x2126)"},
{0x1002, 0x68F9, 0x103C, 0x2126, "Radeon HD 6350(0x103C-0x2126)"},
{0x1002, 0x68F9, 0x103C, 0x2AAC, "Radeon HD 5450(0x103C-0x2AAC)"},
{0x1002, 0x68F9, 0x103C, 0x2AAE, "Radeon HD 5450(0x103C-0x2AAE)"},
{0x1002, 0x68F9, 0x103C, 0x3580, "Radeon HD 5450(0x103C-0x3580)"},
{0x1002, 0x68F9, 0x1043, 0x0386, "Radeon HD 5450(0x1043-0x0386)"},
{0x1002, 0x68F9, 0x1043, 0x03C2, "EAH5450 SILENT/DI/512MD2 (LP)(0x1043-0x03C2)"},
{0x1002, 0x68F9, 0x1458, 0x21D8, "Radeon HD 5450 1GB DDR3 Silent(0x1458-0x21D8)"},
{0x1002, 0x68F9, 0x1462, 0x2130, "Radeon HD 5450(0x1462-0x2130)"},
{0x1002, 0x68F9, 0x1462, 0x2131, "Radeon HD 5450(0x1462-0x2131)"},
{0x1002, 0x68F9, 0x1462, 0x2133, "Radeon HD 6350(0x1462-0x2133)"},
{0x1002, 0x68F9, 0x1462, 0x2180, "Radeon HD 5450(0x1462-0x2180)"},
{0x1002, 0x68F9, 0x1462, 0x2181, "Radeon HD 5450(0x1462-0x2181)"},
{0x1002, 0x68F9, 0x1462, 0x2182, "Radeon HD 6350(0x1462-0x2182)"},
{0x1002, 0x68F9, 0x1462, 0x2183, "Radeon HD 6350(0x1462-0x2183)"},
{0x1002, 0x68F9, 0x1462, 0x2230, "Radeon HD 5450(0x1462-0x2230)"},
{0x1002, 0x68F9, 0x1462, 0x2231, "Radeon HD 5450(0x1462-0x2231)"},
{0x1002, 0x68F9, 0x1462, 0x2495, "Radeon HD 6350(0x1462-0x2495)"},
{0x1002, 0x68F9, 0x148C, 0x3001, "Radeon HD 5530/6250(0x148C-0x3001)"},
{0x1002, 0x68F9, 0x148C, 0x3002, "Radeon HD 6290(0x148C-0x3002)"},
{0x1002, 0x68F9, 0x148C, 0x3003, "Radeon HD 6230(0x148C-0x3003)"},
{0x1002, 0x68F9, 0x148C, 0x3004, "Radeon HD 6350(0x148C-0x3004)"},
{0x1002, 0x68F9, 0x148C, 0x7350, "Radeon HD 7350(0x148C-0x7350)"},
{0x1002, 0x68F9, 0x148C, 0x8350, "Radeon HD 8350(0x148C-0x8350)"},
{0x1002, 0x68F9, 0x1545, 0x7350, "Radeon HD 7350(0x1545-0x7350)"},
{0x1002, 0x68F9, 0x1642, 0x3983, "Radeon HD 5450(0x1642-0x3983)"},
{0x1002, 0x68F9, 0x1642, 0x3984, "Radeon HD 6350(0x1642-0x3984)"},
{0x1002, 0x68F9, 0x1642, 0x3987, "Radeon HD 6350(0x1642-0x3987)"},
{0x1002, 0x68F9, 0x1642, 0x3997, "Radeon HD 5450(0x1642-0x3997)"},
{0x1002, 0x68F9, 0x1642, 0x3A05, "Radeon HD 5450(0x1642-0x3A05)"},
{0x1002, 0x68F9, 0x1642, 0x3B31, "Radeon HD 6350A(0x1642-0x3B31)"},
{0x1002, 0x68F9, 0x1682, 0x3270, "Radeon HD 7350(0x1682-0x3270)"},
{0x1002, 0x68F9, 0x174B, 0x3000, "Radeon HD 6230(0x174B-0x3000)"},
{0x1002, 0x68F9, 0x174B, 0x3987, "Radeon HD 6350(0x174B-0x3987)"},
{0x1002, 0x68F9, 0x174B, 0x5470, "Radeon HD 5470(0x174B-0x5470)"},
{0x1002, 0x68F9, 0x174B, 0x5490, "Radeon HD 5490(0x174B-0x5490)"},
{0x1002, 0x68F9, 0x174B, 0x5530, "Radeon HD 5530(0x174B-0x5530)"},
{0x1002, 0x68F9, 0x174B, 0x6230, "Radeon HD 6230(0x174B-0x6230)"},
{0x1002, 0x68F9, 0x174B, 0x6250, "Radeon HD 6250(0x174B-0x6250)"},
{0x1002, 0x68F9, 0x174B, 0x6290, "Radeon HD 6290(0x174B-0x6290)"},
{0x1002, 0x68F9, 0x174B, 0x6350, "Radeon HD 6350(0x174B-0x6350)"},
{0x1002, 0x68F9, 0x174B, 0x7350, "Radeon HD 7350(0x174B-0x7350)"},
{0x1002, 0x68F9, 0x174B, 0x8350, "Radeon HD 8350(0x174B-0x8350)"},
{0x1002, 0x68F9, 0x174B, 0xE127, "Radeon HD 5450(0x174B-0xE127)"},
{0x1002, 0x68F9, 0x174B, 0xE145, "Radeon HD 5450(0x174B-0xE145)"},
{0x1002, 0x68F9, 0x174B, 0xE153, "Radeon HD 5450(0x174B-0xE153)"},
{0x1002, 0x68F9, 0x1787, 0x3000, "Radeon HD 5470(0x1787-0x3000)"},
{0x1002, 0x68F9, 0x1787, 0x3001, "Radeon HD 5530(0x1787-0x3001)"},
{0x1002, 0x68F9, 0x1787, 0x3002, "Radeon HD 5490(0x1787-0x3002)"},
{0x1002, 0x68F9, 0x17AA, 0x3602, "Radeon HD 5450(0x17AA-0x3602)"},
{0x1002, 0x68F9, 0x17AA, 0x3603, "Radeon HD 5450(0x17AA-0x3603)"},
{0x1002, 0x68F9, 0x17AA, 0x360F, "Radeon HD 5450(0x17AA-0x360F)"},
{0x1002, 0x68F9, 0x17AA, 0x3619, "Radeon HD 5450(0x17AA-0x3619)"},
{0x1002, 0x68F9, 0x17AF, 0x3000, "Radeon HD 6250(0x17AF-0x3000)"},
{0x1002, 0x68F9, 0x17AF, 0x3001, "Radeon HD 6230(0x17AF-0x3001)"},
{0x1002, 0x68F9, 0x17AF, 0x3002, "Radeon HD 6290(0x17AF-0x3002)"},
{0x1002, 0x68F9, 0x17AF, 0x3011, "Radeon HD 5470(0x17AF-0x3011)"},
{0x1002, 0x68F9, 0x17AF, 0x3012, "Radeon HD 5490(0x17AF-0x3012)"},
{0x1002, 0x68F9, 0x17AF, 0x3013, "Radeon HD 5470(0x17AF-0x3013)"},
{0x1002, 0x68F9, 0x17AF, 0x3014, "Radeon HD 6350(0x17AF-0x3014)"},
{0x1002, 0x68FA, 0xFFFF, 0xFFFF, "Cedar [Radeon HD 7350/8350 / R5 220](0x68FA)"},
{0x1002, 0x68FA, 0x1019, 0x0019, "Radeon HD 7350(0x1019-0x0019)"},
{0x1002, 0x68FA, 0x1019, 0x0021, "Radeon HD 7350(0x1019-0x0021)"},
{0x1002, 0x68FA, 0x1019, 0x0022, "Radeon HD 7350(0x1019-0x0022)"},
{0x1002, 0x68FA, 0x1019, 0x0026, "Radeon HD 8350(0x1019-0x0026)"},
{0x1002, 0x68FA, 0x103C, 0x2ADF, "Radeon HD 7350A(0x103C-0x2ADF)"},
{0x1002, 0x68FA, 0x103C, 0x2AE8, "Radeon HD 7350A(0x103C-0x2AE8)"},
{0x1002, 0x68FA, 0x1043, 0x8350, "Radeon HD 8350(0x1043-0x8350)"},
{0x1002, 0x68FA, 0x1462, 0x2128, "Radeon HD 7350(0x1462-0x2128)"},
{0x1002, 0x68FA, 0x1462, 0x2184, "Radeon HD 7350(0x1462-0x2184)"},
{0x1002, 0x68FA, 0x1462, 0x2186, "Radeon HD 7350(0x1462-0x2186)"},
{0x1002, 0x68FA, 0x1462, 0x2495, "Radeon HD 7350(0x1462-0x2495)"},
{0x1002, 0x68FA, 0x1462, 0xB490, "Radeon HD 7350(0x1462-0xB490)"},
{0x1002, 0x68FA, 0x1642, 0x3985, "Radeon HD 7350(0x1642-0x3985)"},
{0x1002, 0x68FA, 0x174B, 0x3510, "Radeon HD 8350(0x174B-0x3510)"},
{0x1002, 0x68FA, 0x174B, 0x3521, "Radeon R5 220(0x174B-0x3521)"},
{0x1002, 0x68FA, 0x174B, 0x3522, "Radeon R5 220(0x174B-0x3522)"},
{0x1002, 0x68FA, 0x174B, 0x7350, "Radeon HD 7350(0x174B-0x7350)"},
{0x1002, 0x68FA, 0x174B, 0x8153, "Radeon HD 8350(0x174B-0x8153)"},
{0x1002, 0x68FA, 0x174B, 0xE127, "Radeon HD 7350(0x174B-0xE127)"},
{0x1002, 0x68FA, 0x174B, 0xE153, "Radeon HD 7350(0x174B-0xE153)"},
{0x1002, 0x68FA, 0x174B, 0xE180, "Radeon HD 7350(0x174B-0xE180)"},
{0x1002, 0x68FA, 0x17AF, 0x3015, "Radeon HD 7350(0x17AF-0x3015)"},
{0x1002, 0x68FE, 0xFFFF, 0xFFFF, "Cedar LE(0x68FE)"},
{0x1002, 0x6900, 0xFFFF, 0xFFFF, "Topaz XT [Radeon R7 M260/M265 / M340/M360 / M440/M445 / 530/535 / 620/625 Mobile](0x6900)"},
{0x1002, 0x6900, 0x1025, 0x1056, "Radeon R7 M360 / R8 M365DX(0x1025-0x1056)"},
{0x1002, 0x6900, 0x1028, 0x0640, "Radeon R7 M260/M265(0x1028-0x0640)"},
{0x1002, 0x6900, 0x1028, 0x0643, "Radeon R7 M260/M265(0x1028-0x0643)"},
{0x1002, 0x6900, 0x1028, 0x067F, "Radeon R7 M260(0x1028-0x067F)"},
{0x1002, 0x6900, 0x1028, 0x0767, "Radeon R7 M445(0x1028-0x0767)"},
{0x1002, 0x6900, 0x1028, 0x0810, "Radeon 530(0x1028-0x0810)"},
{0x1002, 0x6900, 0x1028, 0x130A, "Radeon R7 M260(0x1028-0x130A)"},
{0x1002, 0x6900, 0x103C, 0x2263, "Radeon R7 M260(0x103C-0x2263)"},
{0x1002, 0x6900, 0x103C, 0x2269, "Radeon R7 M260(0x103C-0x2269)"},
{0x1002, 0x6900, 0x103C, 0x22C6, "Radeon R7 M260(0x103C-0x22C6)"},
{0x1002, 0x6900, 0x103C, 0x22C8, "Radeon R7 M260(0x103C-0x22C8)"},
{0x1002, 0x6900, 0x103C, 0x2B45, "Radeon R7 A360(0x103C-0x2B45)"},
{0x1002, 0x6900, 0x103C, 0x808C, "Radeon R7 M260(0x103C-0x808C)"},
{0x1002, 0x6900, 0x103C, 0x8099, "Radeon R7 M360(0x103C-0x8099)"},
{0x1002, 0x6900, 0x103C, 0x80B5, "Radeon R7 M360(0x103C-0x80B5)"},
{0x1002, 0x6900, 0x103C, 0x80B9, "Radeon R7 M360(0x103C-0x80B9)"},
{0x1002, 0x6900, 0x103C, 0x811C, "Radeon R7 M340(0x103C-0x811C)"},
{0x1002, 0x6900, 0x103C, 0x8226, "Radeon R7 M440(0x103C-0x8226)"},
{0x1002, 0x6900, 0x10CF, 0x1906, "Radeon R7 M260(0x10CF-0x1906)"},
{0x1002, 0x6900, 0x1170, 0x9979, "Radeon R7 M360(0x1170-0x9979)"},
{0x1002, 0x6900, 0x1179, 0xF903, "Radeon R7 M260(0x1179-0xF903)"},
{0x1002, 0x6900, 0x1179, 0xF922, "Radeon R7 M260(0x1179-0xF922)"},
{0x1002, 0x6900, 0x1179, 0xF923, "Radeon R7 M260(0x1179-0xF923)"},
{0x1002, 0x6900, 0x1179, 0xF934, "Radeon R7 M260(0x1179-0xF934)"},
{0x1002, 0x6900, 0x17AA, 0x3822, "Radeon R7 M360(0x17AA-0x3822)"},
{0x1002, 0x6900, 0x17AA, 0x3824, "Radeon R7 M360(0x17AA-0x3824)"},
{0x1002, 0x6900, 0x17AA, 0x5021, "Radeon R7 M260(0x17AA-0x5021)"},
{0x1002, 0x6901, 0xFFFF, 0xFFFF, "Topaz PRO [Radeon R5 M255](0x6901)"},
{0x1002, 0x6901, 0x103C, 0x1318, "Radeon R6 M255DX(0x103C-0x1318)"},
{0x1002, 0x6907, 0xFFFF, 0xFFFF, "Meso XT [Radeon R5 M315](0x6907)"},
{0x1002, 0x6920, 0xFFFF, 0xFFFF, "Amethyst [Radeon R9 M395/ M395X Mac Edition](0x6920)"},
{0x1002, 0x6921, 0xFFFF, 0xFFFF, "Amethyst XT [Radeon R9 M295X / M390X](0x6921)"},
{0x1002, 0x6929, 0xFFFF, 0xFFFF, "Tonga XT GL [FirePro S7150](0x6929)"},
{0x1002, 0x692B, 0xFFFF, 0xFFFF, "Tonga PRO GL [FirePro W7100](0x692B)"},
{0x1002, 0x692B, 0x13CC, 0x3D2B, "MXRT-7600(0x13CC-0x3D2B)"},
{0x1002, 0x692F, 0xFFFF, 0xFFFF, "Tonga XTV GL [FirePro S7150V](0x692F)"},
{0x1002, 0x6930, 0xFFFF, 0xFFFF, "Tonga PRO [Radeon R9 380 4GB](0x6930)"},
{0x1002, 0x6938, 0xFFFF, 0xFFFF, "Tonga XT / Amethyst XT [Radeon R9 380X / R9 M295X](0x6938)"},
{0x1002, 0x6938, 0x1043, 0x04F5, "Radeon R9 380X(0x1043-0x04F5)"},
{0x1002, 0x6938, 0x1043, 0x04F7, "Radeon R9 380X(0x1043-0x04F7)"},
{0x1002, 0x6938, 0x106B, 0x013A, "Radeon R9 M295X Mac Edition(0x106B-0x013A)"},
{0x1002, 0x6938, 0x1458, 0x22C8, "Radeon R9 380X(0x1458-0x22C8)"},
{0x1002, 0x6938, 0x148C, 0x2350, "Radeon R9 380X(0x148C-0x2350)"},
{0x1002, 0x6938, 0x1682, 0x9385, "Radeon R9 380X(0x1682-0x9385)"},
{0x1002, 0x6938, 0x174B, 0xE308, "Radeon R9 380X Nitro 4G D5(0x174B-0xE308)"},
{0x1002, 0x6938, 0x17AF, 0x2006, "Radeon R9 380X(0x17AF-0x2006)"},
{0x1002, 0x6939, 0xFFFF, 0xFFFF, "Tonga PRO [Radeon R9 285/380](0x6939)"},
{0x1002, 0x6939, 0x1462, 0x2015, "Radeon R9 380 Gaming 4G(0x1462-0x2015)"},
{0x1002, 0x6939, 0x148C, 0x9380, "Radeon R9 380(0x148C-0x9380)"},
{0x1002, 0x6939, 0x174B, 0xE308, "Radeon R9 380 Nitro 4G D5(0x174B-0xE308)"},
{0x1002, 0x6939, 0x174B, 0xE315, "Radeon R9 285(0x174B-0xE315)"},
{0x1002, 0x693B, 0xFFFF, 0xFFFF, "Tonga PRO GL [FirePro W7100 / Barco MXRT-7600](0x693B)"},
{0x1002, 0x694C, 0xFFFF, 0xFFFF, "Polaris 22 XT [Radeon RX Vega M GH](0x694C)"},
{0x1002, 0x694E, 0xFFFF, 0xFFFF, "Polaris 22 XL [Radeon RX Vega M GL](0x694E)"},
{0x1002, 0x694F, 0xFFFF, 0xFFFF, "Polaris 22 MGL XL [Radeon Pro WX Vega M GL](0x694F)"},
{0x1002, 0x6980, 0xFFFF, 0xFFFF, "Polaris12(0x6980)"},
{0x1002, 0x6981, 0xFFFF, 0xFFFF, "Lexa XT [Radeon PRO WX 3200](0x6981)"},
{0x1002, 0x6985, 0xFFFF, 0xFFFF, "Lexa XT [Radeon PRO WX 3100](0x6985)"},
{0x1002, 0x6985, 0x103C, 0x83B5, "Radeon PRO WX 3100(0x103C-0x83B5)"},
{0x1002, 0x6986, 0xFFFF, 0xFFFF, "Polaris12(0x6986)"},
{0x1002, 0x6987, 0xFFFF, 0xFFFF, "Lexa [Radeon 540X/550X/630 / RX 640 / E9171 MCM](0x6987)"},
{0x1002, 0x698F, 0xFFFF, 0xFFFF, "Lexa XT [Radeon PRO WX 3100 / Barco MXRT 4700](0x698F)"},
{0x1002, 0x6995, 0xFFFF, 0xFFFF, "Lexa XT [Radeon PRO WX 2100](0x6995)"},
{0x1002, 0x699F, 0xFFFF, 0xFFFF, "Lexa PRO [Radeon 540/540X/550/550X / RX 540X/550/550X](0x699F)"},
{0x1002, 0x699F, 0x1028, 0x1720, "Radeon RX 550X(0x1028-0x1720)"},
{0x1002, 0x699F, 0x148C, 0x2380, "Lexa XL [Radeon RX 550](0x148C-0x2380)"},
{0x1002, 0x699F, 0x17AA, 0x5069, "Thinkpad E480/E580(0x17AA-0x5069)"},
{0x1002, 0x699F, 0x1DA2, 0xE367, "Lexa PRO [Radeon RX 550](0x1DA2-0xE367)"},
{0x1002, 0x69A0, 0xFFFF, 0xFFFF, "Vega 12(0x69A0)"},
{0x1002, 0x69A1, 0xFFFF, 0xFFFF, "Vega 12(0x69A1)"},
{0x1002, 0x69A2, 0xFFFF, 0xFFFF, "Vega 12(0x69A2)"},
{0x1002, 0x69A3, 0xFFFF, 0xFFFF, "Vega 12(0x69A3)"},
{0x1002, 0x69AF, 0xFFFF, 0xFFFF, "Vega 12 [Radeon Pro Vega 20](0x69AF)"},
{0x1002, 0x6FDF, 0xFFFF, 0xFFFF, "Polaris 20 XL [Radeon RX 580 2048SP](0x6FDF)"},
{0x1002, 0x700F, 0xFFFF, 0xFFFF, "RS100 AGP Bridge(0x700F)"},
{0x1002, 0x7010, 0xFFFF, 0xFFFF, "RS200/RS250 AGP Bridge(0x7010)"},
{0x1002, 0x7100, 0xFFFF, 0xFFFF, "R520 [Radeon X1800 XT](0x7100)"},
{0x1002, 0x7101, 0xFFFF, 0xFFFF, "R520/M58 [Mobility Radeon X1800 XT](0x7101)"},
{0x1002, 0x7102, 0xFFFF, 0xFFFF, "R520/M58 [Mobility Radeon X1800](0x7102)"},
{0x1002, 0x7104, 0xFFFF, 0xFFFF, "R520 GL [FireGL V7200 / Barco MXTR-5100](0x7104)"},
{0x1002, 0x7104, 0x13CC, 0x3D0A, "MXRT-5100(0x13CC-0x3D0A)"},
{0x1002, 0x7109, 0xFFFF, 0xFFFF, "R520 [Radeon X1800 XL](0x7109)"},
{0x1002, 0x7109, 0x1002, 0x0322, "All-in-Wonder X1800XL(0x1002-0x0322)"},
{0x1002, 0x7109, 0x1002, 0x0D02, "Radeon X1800 CrossFire Edition(0x1002-0x0D02)"},
{0x1002, 0x710A, 0xFFFF, 0xFFFF, "R520 [Radeon X1800 GTO](0x710A)"},
{0x1002, 0x710A, 0x1002, 0x0B12, "Radeon X1800 GTO²(0x1002-0x0B12)"},
{0x1002, 0x710B, 0xFFFF, 0xFFFF, "R520 [Radeon X1800 GTO](0x710B)"},
{0x1002, 0x710E, 0xFFFF, 0xFFFF, "R520 GL [FireGL V7300](0x710E)"},
{0x1002, 0x710E, 0x13CC, 0x3D0C, "MXRT-5150(0x13CC-0x3D0C)"},
{0x1002, 0x710F, 0xFFFF, 0xFFFF, "R520 GL [FireGL V7350](0x710F)"},
{0x1002, 0x710F, 0x13CC, 0x3D0E, "MXRT-7100(0x13CC-0x3D0E)"},
{0x1002, 0x7120, 0xFFFF, 0xFFFF, "R520 [Radeon X1800] (Secondary)(0x7120)"},
{0x1002, 0x7124, 0xFFFF, 0xFFFF, "R520 GL [FireGL V7200] (Secondary)(0x7124)"},
{0x1002, 0x7124, 0x13CC, 0x3D0B, "MXRT-5100 (Secondary)(0x13CC-0x3D0B)"},
{0x1002, 0x7129, 0xFFFF, 0xFFFF, "R520 [Radeon X1800] (Secondary)(0x7129)"},
{0x1002, 0x7129, 0x1002, 0x0323, "All-In-Wonder X1800 XL (Secondary)(0x1002-0x0323)"},
{0x1002, 0x7129, 0x1002, 0x0D03, "Radeon X1800 CrossFire Edition (Secondary)(0x1002-0x0D03)"},
{0x1002, 0x712E, 0xFFFF, 0xFFFF, "R520 GL [FireGL V7300] (Secondary)(0x712E)"},
{0x1002, 0x712E, 0x13CC, 0x3D0D, "MXRT-5150 (Secondary)(0x13CC-0x3D0D)"},
{0x1002, 0x712F, 0xFFFF, 0xFFFF, "R520 GL [FireGL V7350] (Secondary)(0x712F)"},
{0x1002, 0x712F, 0x13CC, 0x3D0F, "MXRT-7100 (Secondary)(0x13CC-0x3D0F)"},
{0x1002, 0x7140, 0xFFFF, 0xFFFF, "RV515 [Radeon X1300/X1550/X1600 Series](0x7140)"},
{0x1002, 0x7142, 0xFFFF, 0xFFFF, "RV515 PRO [Radeon X1300/X1550 Series](0x7142)"},
{0x1002, 0x7142, 0x1002, 0x0322, "All-in-Wonder 2006 PCI-E Edition(0x1002-0x0322)"},
{0x1002, 0x7142, 0x1043, 0x0142, "EAX1300PRO/TD/256M(0x1043-0x0142)"},
{0x1002, 0x7143, 0xFFFF, 0xFFFF, "RV505 [Radeon X1300/X1550 Series](0x7143)"},
{0x1002, 0x7145, 0xFFFF, 0xFFFF, "RV515/M54 [Mobility Radeon X1400](0x7145)"},
{0x1002, 0x7145, 0x17AA, 0x2006, "Thinkpad T60 model 2007(0x17AA-0x2006)"},
{0x1002, 0x7146, 0xFFFF, 0xFFFF, "RV515 [Radeon X1300/X1550](0x7146)"},
{0x1002, 0x7146, 0x1002, 0x0322, "All-in-Wonder 2006 PCI-E Edition(0x1002-0x0322)"},
{0x1002, 0x7146, 0x1545, 0x1996, "Radeon X1300 512MB PCI-e(0x1545-0x1996)"},
{0x1002, 0x7147, 0xFFFF, 0xFFFF, "RV505 [Radeon X1550 64-bit](0x7147)"},
{0x1002, 0x7149, 0xFFFF, 0xFFFF, "RV515/M52 [Mobility Radeon X1300](0x7149)"},
{0x1002, 0x714A, 0xFFFF, 0xFFFF, "RV515/M52 [Mobility Radeon X1300](0x714A)"},
{0x1002, 0x7152, 0xFFFF, 0xFFFF, "RV515 GL [FireGL V3300](0x7152)"},
{0x1002, 0x7153, 0xFFFF, 0xFFFF, "RV515 GL [FireGL V3350](0x7153)"},
{0x1002, 0x715F, 0xFFFF, 0xFFFF, "RV505 CE [Radeon X1550 64-bit](0x715F)"},
{0x1002, 0x7162, 0xFFFF, 0xFFFF, "RV515 PRO [Radeon X1300/X1550 Series] (Secondary)(0x7162)"},
{0x1002, 0x7162, 0x1002, 0x0323, "All-in-Wonder 2006 PCI-E Edition (Secondary)(0x1002-0x0323)"},
{0x1002, 0x7163, 0xFFFF, 0xFFFF, "RV505 [Radeon X1550 Series] (Secondary)(0x7163)"},
{0x1002, 0x7166, 0xFFFF, 0xFFFF, "RV515 [Radeon X1300/X1550 Series] (Secondary)(0x7166)"},
{0x1002, 0x7166, 0x1002, 0x0323, "All-in-Wonder 2006 PCI-E Edition (Secondary)(0x1002-0x0323)"},
{0x1002, 0x7166, 0x1545, 0x1997, "Radeon X1300 512MB PCI-e (Secondary)(0x1545-0x1997)"},
{0x1002, 0x7167, 0xFFFF, 0xFFFF, "RV515 [Radeon X1550 64-bit] (Secondary)(0x7167)"},
{0x1002, 0x7172, 0xFFFF, 0xFFFF, "RV515 GL [FireGL V3300] (Secondary)(0x7172)"},
{0x1002, 0x7173, 0xFFFF, 0xFFFF, "RV515 GL [FireGL V3350] (Secondary)(0x7173)"},
{0x1002, 0x7181, 0xFFFF, 0xFFFF, "RV516 [Radeon X1600/X1650 Series](0x7181)"},
{0x1002, 0x7183, 0xFFFF, 0xFFFF, "RV516 [Radeon X1300/X1550 Series](0x7183)"},
{0x1002, 0x7186, 0xFFFF, 0xFFFF, "RV516/M64 [Mobility Radeon X1450](0x7186)"},
{0x1002, 0x7187, 0xFFFF, 0xFFFF, "RV516 [Radeon X1300/X1550 Series](0x7187)"},
{0x1002, 0x7188, 0xFFFF, 0xFFFF, "RV516/M64-S [Mobility Radeon X2300](0x7188)"},
{0x1002, 0x7188, 0x103C, 0x30C1, "6910p(0x103C-0x30C1)"},
{0x1002, 0x718A, 0xFFFF, 0xFFFF, "RV516/M64 [Mobility Radeon X2300](0x718A)"},
{0x1002, 0x718B, 0xFFFF, 0xFFFF, "RV516/M62 [Mobility Radeon X1350](0x718B)"},
{0x1002, 0x718B, 0x1071, 0x8209, "Medion MIM 2240 Notebook PC [MD98100](0x1071-0x8209)"},
{0x1002, 0x718C, 0xFFFF, 0xFFFF, "RV516/M62-CSP64 [Mobility Radeon X1350](0x718C)"},
{0x1002, 0x718D, 0xFFFF, 0xFFFF, "RV516/M64-CSP128 [Mobility Radeon X1450](0x718D)"},
{0x1002, 0x7193, 0xFFFF, 0xFFFF, "RV516 [Radeon X1550 Series](0x7193)"},
{0x1002, 0x7196, 0xFFFF, 0xFFFF, "RV516/M62-S [Mobility Radeon X1350](0x7196)"},
{0x1002, 0x719B, 0xFFFF, 0xFFFF, "RV516 GL [FireMV 2250](0x719B)"},
{0x1002, 0x719B, 0x13CC, 0x3D12, "MXRT-1150(0x13CC-0x3D12)"},
{0x1002, 0x719B, 0x13CC, 0x3D14, "MXRT-2150(0x13CC-0x3D14)"},
{0x1002, 0x719F, 0xFFFF, 0xFFFF, "RV516 [Radeon X1550 Series](0x719F)"},
{0x1002, 0x71A0, 0xFFFF, 0xFFFF, "RV516 [Radeon X1300/X1550 Series] (Secondary)(0x71A0)"},
{0x1002, 0x71A1, 0xFFFF, 0xFFFF, "RV516 [Radeon X1600/X1650 Series] (Secondary)(0x71A1)"},
{0x1002, 0x71A3, 0xFFFF, 0xFFFF, "RV516 [Radeon X1300/X1550 Series] (Secondary)(0x71A3)"},
{0x1002, 0x71A7, 0xFFFF, 0xFFFF, "RV516 [Radeon X1300/X1550 Series] (Secondary)(0x71A7)"},
{0x1002, 0x71BB, 0xFFFF, 0xFFFF, "RV516 GL [FireMV 2250] (Secondary)(0x71BB)"},
{0x1002, 0x71BB, 0x13CC, 0x3D13, "MXRT-1150 (Secondary)(0x13CC-0x3D13)"},
{0x1002, 0x71BB, 0x13CC, 0x3D15, "MXRT-2150 (Secondary)(0x13CC-0x3D15)"},
{0x1002, 0x71C0, 0xFFFF, 0xFFFF, "RV530 [Radeon X1600 XT/X1650 GTO](0x71C0)"},
{0x1002, 0x71C0, 0x1002, 0xE160, "Radeon X1650 GTO(0x1002-0xE160)"},
{0x1002, 0x71C0, 0x174B, 0xE160, "Radeon X1650 GTO(0x174B-0xE160)"},
{0x1002, 0x71C1, 0xFFFF, 0xFFFF, "RV535 [Radeon X1650 PRO](0x71C1)"},
{0x1002, 0x71C1, 0x174B, 0x0880, "Radeon X1700 FSC(0x174B-0x0880)"},
{0x1002, 0x71C2, 0xFFFF, 0xFFFF, "RV530 [Radeon X1600 PRO](0x71C2)"},
{0x1002, 0x71C3, 0xFFFF, 0xFFFF, "RV530 [Radeon X1600 PRO](0x71C3)"},
{0x1002, 0x71C4, 0xFFFF, 0xFFFF, "RV530/M56 GL [Mobility FireGL V5200](0x71C4)"},
{0x1002, 0x71C4, 0x17AA, 0x2007, "ThinkPad T60p(0x17AA-0x2007)"},
{0x1002, 0x71C5, 0xFFFF, 0xFFFF, "RV530/M56-P [Mobility Radeon X1600](0x71C5)"},
{0x1002, 0x71C5, 0x103C, 0x309F, "Compaq nx9420 Notebook(0x103C-0x309F)"},
{0x1002, 0x71C5, 0x103C, 0x30A3, "Compaq NW8440(0x103C-0x30A3)"},
{0x1002, 0x71C5, 0x1043, 0x10B2, "A6J-Q008(0x1043-0x10B2)"},
{0x1002, 0x71C5, 0x106B, 0x0080, "MacBook Pro(0x106B-0x0080)"},
{0x1002, 0x71C6, 0xFFFF, 0xFFFF, "RV530LE [Radeon X1600/X1650 PRO](0x71C6)"},
{0x1002, 0x71C7, 0xFFFF, 0xFFFF, "RV535 [Radeon X1650 PRO](0x71C7)"},
{0x1002, 0x71C7, 0x1787, 0x3000, "PowerColor X1650 PRO AGP(0x1787-0x3000)"},
{0x1002, 0x71CE, 0xFFFF, 0xFFFF, "RV530 [Radeon X1300 XT/X1600 PRO](0x71CE)"},
{0x1002, 0x71D2, 0xFFFF, 0xFFFF, "RV530 GL [FireGL V3400](0x71D2)"},
{0x1002, 0x71D2, 0x13CC, 0x3D08, "MXRT-2100(0x13CC-0x3D08)"},
{0x1002, 0x71D4, 0xFFFF, 0xFFFF, "RV530/M66 GL [Mobility FireGL V5250](0x71D4)"},
{0x1002, 0x71D5, 0xFFFF, 0xFFFF, "RV530/M66-P [Mobility Radeon X1700](0x71D5)"},
{0x1002, 0x71D6, 0xFFFF, 0xFFFF, "RV530/M66-XT [Mobility Radeon X1700](0x71D6)"},
{0x1002, 0x71DE, 0xFFFF, 0xFFFF, "RV530/M66 [Mobility Radeon X1700/X2500](0x71DE)"},
{0x1002, 0x71E0, 0xFFFF, 0xFFFF, "RV530 [Radeon X1600] (Secondary)(0x71E0)"},
{0x1002, 0x71E0, 0x174B, 0xE161, "Radeon X1600 GTO (Secondary)(0x174B-0xE161)"},
{0x1002, 0x71E1, 0xFFFF, 0xFFFF, "RV535 [Radeon X1650 PRO] (Secondary)(0x71E1)"},
{0x1002, 0x71E1, 0x174B, 0x0881, "Radeon X1700 FSC (Secondary)(0x174B-0x0881)"},
{0x1002, 0x71E2, 0xFFFF, 0xFFFF, "RV530 [Radeon X1600] (Secondary)(0x71E2)"},
{0x1002, 0x71E6, 0xFFFF, 0xFFFF, "RV530 [Radeon X1650] (Secondary)(0x71E6)"},
{0x1002, 0x71E7, 0xFFFF, 0xFFFF, "RV535 [Radeon X1650 PRO] (Secondary)(0x71E7)"},
{0x1002, 0x71E7, 0x1787, 0x3001, "Radeon X1650 PRO AGP(0x1787-0x3001)"},
{0x1002, 0x71F2, 0xFFFF, 0xFFFF, "RV530 GL [FireGL V3400] (Secondary)(0x71F2)"},
{0x1002, 0x71F2, 0x13CC, 0x3D09, "MXRT-2100 (Secondary)(0x13CC-0x3D09)"},
{0x1002, 0x7210, 0xFFFF, 0xFFFF, "RV550/M71 [Mobility Radeon HD 2300](0x7210)"},
{0x1002, 0x7211, 0xFFFF, 0xFFFF, "RV550/M71 [Mobility Radeon X2300 HD](0x7211)"},
{0x1002, 0x7240, 0xFFFF, 0xFFFF, "R580+ [Radeon X1950 XTX](0x7240)"},
{0x1002, 0x7240, 0x1002, 0x0D02, "Radeon X1950 CrossFire Edition(0x1002-0x0D02)"},
{0x1002, 0x7244, 0xFFFF, 0xFFFF, "R580+ [Radeon X1950 XT](0x7244)"},
{0x1002, 0x7248, 0xFFFF, 0xFFFF, "R580 [Radeon X1950](0x7248)"},
{0x1002, 0x7249, 0xFFFF, 0xFFFF, "R580 [Radeon X1900 XT](0x7249)"},
{0x1002, 0x7249, 0x1002, 0x0412, "All-In-Wonder X1900(0x1002-0x0412)"},
{0x1002, 0x7249, 0x1002, 0x0B12, "Radeon X1900 XT/XTX(0x1002-0x0B12)"},
{0x1002, 0x7249, 0x1002, 0x0D02, "Radeon X1900 CrossFire Edition(0x1002-0x0D02)"},
{0x1002, 0x7249, 0x1043, 0x0160, "Radeon X1900 XTX 512 MB GDDR3(0x1043-0x0160)"},
{0x1002, 0x724B, 0xFFFF, 0xFFFF, "R580 [Radeon X1900 GT](0x724B)"},
{0x1002, 0x724B, 0x1002, 0x0B12, "Radeon X1900 (Primary)(0x1002-0x0B12)"},
{0x1002, 0x724B, 0x1002, 0x0B13, "Radeon X1900 (Secondary)(0x1002-0x0B13)"},
{0x1002, 0x724E, 0xFFFF, 0xFFFF, "R580 GL [FireGL V7350](0x724E)"},
{0x1002, 0x7269, 0xFFFF, 0xFFFF, "R580 [Radeon X1900 XT] (Secondary)(0x7269)"},
{0x1002, 0x726B, 0xFFFF, 0xFFFF, "R580 [Radeon X1900 GT] (Secondary)(0x726B)"},
{0x1002, 0x726E, 0xFFFF, 0xFFFF, "R580 [AMD Stream Processor] (Secondary)(0x726E)"},
{0x1002, 0x7280, 0xFFFF, 0xFFFF, "RV570 [Radeon X1950 PRO](0x7280)"},
{0x1002, 0x7288, 0xFFFF, 0xFFFF, "RV570 [Radeon X1950 GT](0x7288)"},
{0x1002, 0x7291, 0xFFFF, 0xFFFF, "RV560 [Radeon X1650 XT](0x7291)"},
{0x1002, 0x7291, 0x1462, 0x0810, "Radeon X1700 SE(0x1462-0x0810)"},
{0x1002, 0x7293, 0xFFFF, 0xFFFF, "RV560 [Radeon X1650 GT](0x7293)"},
{0x1002, 0x72A0, 0xFFFF, 0xFFFF, "RV570 [Radeon X1950 PRO] (Secondary)(0x72A0)"},
{0x1002, 0x72A8, 0xFFFF, 0xFFFF, "RV570 [Radeon X1950 GT] (Secondary)(0x72A8)"},
{0x1002, 0x72B1, 0xFFFF, 0xFFFF, "RV560 [Radeon X1650 XT] (Secondary)(0x72B1)"},
{0x1002, 0x72B3, 0xFFFF, 0xFFFF, "RV560 [Radeon X1650 GT] (Secondary)(0x72B3)"},
{0x1002, 0x7300, 0xFFFF, 0xFFFF, "Fiji [Radeon R9 FURY / NANO Series](0x7300)"},
{0x1002, 0x7300, 0x1002, 0x0B35, "FirePro S9300 X2(0x1002-0x0B35)"},
{0x1002, 0x7300, 0x1002, 0x0B36, "Radeon R9 FURY X / NANO(0x1002-0x0B36)"},
{0x1002, 0x7300, 0x1002, 0x1B36, "Radeon Pro Duo(0x1002-0x1B36)"},
{0x1002, 0x7300, 0x1043, 0x049E, "Radeon R9 FURY(0x1043-0x049E)"},
{0x1002, 0x7300, 0x1043, 0x04A0, "Radeon R9 FURY X(0x1043-0x04A0)"},
{0x1002, 0x7300, 0x174B, 0xE329, "Radeon R9 FURY(0x174B-0xE329)"},
{0x1002, 0x7310, 0xFFFF, 0xFFFF, "Navi 10 [Radeon Pro W5700X](0x7310)"},
{0x1002, 0x7312, 0xFFFF, 0xFFFF, "Navi 10 [Radeon Pro W5700](0x7312)"},
{0x1002, 0x7314, 0xFFFF, 0xFFFF, "Navi 10 USB(0x7314)"},
{0x1002, 0x7319, 0xFFFF, 0xFFFF, "Navi 10 [Radeon Pro 5700 XT](0x7319)"},
{0x1002, 0x731B, 0xFFFF, 0xFFFF, "Navi 10 [Radeon Pro 5700](0x731B)"},
{0x1002, 0x731E, 0xFFFF, 0xFFFF, "TDC-150(0x731E)"},
{0x1002, 0x731F, 0xFFFF, 0xFFFF, "Navi 10 [Radeon RX 5600 OEM/5600 XT / 5700/5700 XT](0x731F)"},
{0x1002, 0x731F, 0x1002, 0x0B36, "Reference RX 5700 XT(0x1002-0x0B36)"},
{0x1002, 0x731F, 0x1458, 0x2313, "Radeon RX 5700 XT Gaming OC(0x1458-0x2313)"},
{0x1002, 0x731F, 0x1458, 0x231D, "Radeon RX 5600 XT/REV 2.0 [Windforce 6GB OC](0x1458-0x231D)"},
{0x1002, 0x731F, 0x148C, 0x2398, "AXRX 5700 XT 8GBD6-3DHE/OC [PowerColor Red Devil Radeon RX 5700 XT](0x148C-0x2398)"},
{0x1002, 0x731F, 0x1682, 0x5701, "RX 5700 XT RAW II(0x1682-0x5701)"},
{0x1002, 0x731F, 0x1849, 0x5102, "RX5700 CLD 8GO [ASRock Challenger D RX 5700 OC](0x1849-0x5102)"},
{0x1002, 0x731F, 0x1849, 0x5120, "Radeon RX 5600 XT(0x1849-0x5120)"},
{0x1002, 0x731F, 0x1DA2, 0xE409, "Sapphire Technology Limited Navi 10 [Radeon RX 5600 OEM/5600 XT / 5700/5700 XT](0x1DA2-0xE409)"},
{0x1002, 0x731F, 0x1DA2, 0xE410, "Sapphire NITRO+ RX 5700 XT(0x1DA2-0xE410)"},
{0x1002, 0x731F, 0x1DA2, 0xE411, "Navi 10 [Radeon RX 5600 OEM/5600 XT / 5700/5700 XT]Navi 10 [Radeon RX 5600 OEM/5600 XT / 5700/5700 XT](0x1DA2-0xE411)"},
{0x1002, 0x7340, 0xFFFF, 0xFFFF, "Navi 14 [Radeon RX 5500/5500M / Pro 5500M](0x7340)"},
{0x1002, 0x7340, 0x106B, 0x0210, "Radeon Pro 5300M(0x106B-0x0210)"},
{0x1002, 0x7341, 0xFFFF, 0xFFFF, "Navi 14 [Radeon Pro W5500](0x7341)"},
{0x1002, 0x7347, 0xFFFF, 0xFFFF, "Navi 14 [Radeon Pro W5500M](0x7347)"},
{0x1002, 0x734F, 0xFFFF, 0xFFFF, "Navi 14 [Radeon Pro W5300M](0x734F)"},
{0x1002, 0x7360, 0xFFFF, 0xFFFF, "Navi 12 [Radeon Pro 5600M/V520/BC-160](0x7360)"},
{0x1002, 0x7362, 0xFFFF, 0xFFFF, "Navi 12 [Radeon Pro V520/V540](0x7362)"},
{0x1002, 0x7388, 0xFFFF, 0xFFFF, "Arcturus GL-XL(0x7388)"},
{0x1002, 0x738C, 0xFFFF, 0xFFFF, "Arcturus GL-XL [Instinct MI100](0x738C)"},
{0x1002, 0x738E, 0xFFFF, 0xFFFF, "Arcturus GL-XL [Instinct MI100](0x738E)"},
{0x1002, 0x73A1, 0xFFFF, 0xFFFF, "Navi 21 [Radeon Pro V620](0x73A1)"},
{0x1002, 0x73A2, 0xFFFF, 0xFFFF, "Navi 21 Pro-XTA [Radeon Pro W6900X](0x73A2)"},
{0x1002, 0x73A3, 0xFFFF, 0xFFFF, "Navi 21 GL-XL [Radeon PRO W6800](0x73A3)"},
{0x1002, 0x73A4, 0xFFFF, 0xFFFF, "Navi 21 USB(0x73A4)"},
{0x1002, 0x73A5, 0xFFFF, 0xFFFF, "Navi 21 [Radeon RX 6950 XT](0x73A5)"},
{0x1002, 0x73A5, 0x1002, 0x0E3A, "Radeon RX 6950 XT(0x1002-0x0E3A)"},
{0x1002, 0x73A5, 0x1849, 0x5230, "Navi 21 [ASRock OC Forumla Radeon RX 6950XT](0x1849-0x5230)"},
{0x1002, 0x73A5, 0x1849, 0x5238, "Navi 21 [ASRock Radeon RX 6950 XT Phantom Gaming OC](0x1849-0x5238)"},
{0x1002, 0x73A5, 0x1DA2, 0x441D, "Navi 21 [Sapphire Nitro+ Radeon RX 6950 XT](0x1DA2-0x441D)"},
{0x1002, 0x73A5, 0x1EAE, 0x6950, "Navi 21 [XFX Speedster MERC319 Radeon RX 6950 XT](0x1EAE-0x6950)"},
{0x1002, 0x73AB, 0xFFFF, 0xFFFF, "Navi 21 Pro-XLA [Radeon Pro W6800X/Radeon Pro W6800X Duo](0x73AB)"},
{0x1002, 0x73AE, 0xFFFF, 0xFFFF, "Navi 21 [Radeon Pro V620 MxGPU](0x73AE)"},
{0x1002, 0x73AF, 0xFFFF, 0xFFFF, "Navi 21 [Radeon RX 6900 XT](0x73AF)"},
{0x1002, 0x73AF, 0x148C, 0x2414, "Navi 21 XTXH [PowerColor Red Devil RX 6900 XT Ultimate](0x148C-0x2414)"},
{0x1002, 0x73BF, 0xFFFF, 0xFFFF, "Navi 21 [Radeon RX 6800/6800 XT / 6900 XT](0x73BF)"},
{0x1002, 0x73BF, 0x1002, 0x0E3A, "Radeon RX 6900 XT(0x1002-0x0E3A)"},
{0x1002, 0x73BF, 0x148C, 0x2408, "Red Devil AMD Radeon RX 6900 XT(0x148C-0x2408)"},
{0x1002, 0x73BF, 0x1DA2, 0x438E, "NITRO+ Radeon RX 6800 XT(0x1DA2-0x438E)"},
{0x1002, 0x73BF, 0x1DA2, 0x440F, "TOXIC RX 6900 XT(0x1DA2-0x440F)"},
{0x1002, 0x73BF, 0x1DA2, 0xE437, "Pulse Radeon RX 6800(0x1DA2-0xE437)"},
{0x1002, 0x73BF, 0x1EAE, 0x6701, "Speedster MERC 319 AMD Radeon RX 6800 XT Black(0x1EAE-0x6701)"},
{0x1002, 0x73BF, 0x1EAE, 0x6901, "Speedster MERC 319 AMD Radeon RX 6900 XT Black(0x1EAE-0x6901)"},
{0x1002, 0x73C3, 0xFFFF, 0xFFFF, "Navi 22(0x73C3)"},
{0x1002, 0x73C4, 0xFFFF, 0xFFFF, "Navi 22 USB(0x73C4)"},
{0x1002, 0x73CE, 0xFFFF, 0xFFFF, "Navi 22-XL SRIOV MxGPU(0x73CE)"},
{0x1002, 0x73DF, 0xFFFF, 0xFFFF, "Navi 22 [Radeon RX 6700/6700 XT/6750 XT / 6800M/6850M XT](0x73DF)"},
{0x1002, 0x73DF, 0x1043, 0x16C2, "Radeon RX 6800M(0x1043-0x16C2)"},
{0x1002, 0x73DF, 0x1458, 0x2408, "Radeon RX 6750 XT GAMING OC 12G(0x1458-0x2408)"},
{0x1002, 0x73DF, 0x1462, 0x3980, "Radeon RX 6700 XT Mech 2X 12G [MSI](0x1462-0x3980)"},
{0x1002, 0x73DF, 0x148C, 0x2409, "Red Devil RX 6700 XT(0x148C-0x2409)"},
{0x1002, 0x73DF, 0x1849, 0x5210, "Radeon RX 6700 XT Challenger D(0x1849-0x5210)"},
{0x1002, 0x73DF, 0x1849, 0x5219, "Radeon RX 6700 XT Challenger D(0x1849-0x5219)"},
{0x1002, 0x73DF, 0x1849, 0x5222, "RX 6700 XT Challenger D OC(0x1849-0x5222)"},
{0x1002, 0x73DF, 0x1DA2, 0x445E, "Radeon RX 6700 XT GAMING OC 12G [Sapphire PULSE](0x1DA2-0x445E)"},
{0x1002, 0x73DF, 0x1DA2, 0x465E, "Radeon RX 6750 XT PULSE OC(0x1DA2-0x465E)"},
{0x1002, 0x73DF, 0x1DA2, 0xE445, "Sapphire Radeon RX 6700(0x1DA2-0xE445)"},
{0x1002, 0x73DF, 0x1EAE, 0x6601, "Speedster QICK 319 RX 6700 XT(0x1EAE-0x6601)"},
{0x1002, 0x73DF, 0x1EAE, 0x661A, "Radeon RX 6700 [SPEEDSTER SWFT 309](0x1EAE-0x661A)"},
{0x1002, 0x73E0, 0xFFFF, 0xFFFF, "Navi 23(0x73E0)"},
{0x1002, 0x73E1, 0xFFFF, 0xFFFF, "Navi 23 WKS-XM [Radeon PRO W6600M](0x73E1)"},
{0x1002, 0x73E3, 0xFFFF, 0xFFFF, "Navi 23 WKS-XL [Radeon PRO W6600](0x73E3)"},
{0x1002, 0x73E4, 0xFFFF, 0xFFFF, "Navi 23 USB(0x73E4)"},
{0x1002, 0x73EF, 0xFFFF, 0xFFFF, "Navi 23 [Radeon RX 6650 XT / 6700S / 6800S](0x73EF)"},
{0x1002, 0x73EF, 0x1458, 0x2405, "Navi 23 [Radeon RX 6650 XT](0x1458-0x2405)"},
{0x1002, 0x73EF, 0x1462, 0x5027, "RX 6650XT MECH 2X(0x1462-0x5027)"},
{0x1002, 0x73EF, 0x1849, 0x5236, "RX 6650 XT Challenger D OC(0x1849-0x5236)"},
{0x1002, 0x73F0, 0xFFFF, 0xFFFF, "Navi 33 [Radeon RX 7600M XT](0x73F0)"},
{0x1002, 0x73FF, 0xFFFF, 0xFFFF, "Navi 23 [Radeon RX 6600/6600 XT/6600M](0x73FF)"},
{0x1002, 0x73FF, 0x1462, 0x5021, "MSI RX 6600XT MECH 2X(0x1462-0x5021)"},
{0x1002, 0x73FF, 0x1462, 0x5022, "RX 6600 MECH 2X(0x1462-0x5022)"},
{0x1002, 0x73FF, 0x148C, 0x2412, "PowerColor Red Devil RX 6600 XT(0x148C-0x2412)"},
{0x1002, 0x73FF, 0x1849, 0x5218, "Radeon RX 6600 Challenger ITX 8GB(0x1849-0x5218)"},
{0x1002, 0x73FF, 0x1DA2, 0x448E, "Radeon RX 6600 XT Pulse(0x1DA2-0x448E)"},
{0x1002, 0x7408, 0xFFFF, 0xFFFF, "Aldebaran/MI200 [Instinct MI250X](0x7408)"},
{0x1002, 0x740C, 0xFFFF, 0xFFFF, "Aldebaran/MI200 [Instinct MI250X/MI250](0x740C)"},
{0x1002, 0x740F, 0xFFFF, 0xFFFF, "Aldebaran/MI200 [Instinct MI210](0x740F)"},
{0x1002, 0x7421, 0xFFFF, 0xFFFF, "Navi 24 [Radeon PRO W6500M](0x7421)"},
{0x1002, 0x7422, 0xFFFF, 0xFFFF, "Navi 24 [Radeon PRO W6400](0x7422)"},
{0x1002, 0x7423, 0xFFFF, 0xFFFF, "Navi 24 [Radeon PRO W6300/W6300M](0x7423)"},
{0x1002, 0x7424, 0xFFFF, 0xFFFF, "Navi 24 [Radeon RX 6300](0x7424)"},
{0x1002, 0x743F, 0xFFFF, 0xFFFF, "Navi 24 [Radeon RX 6400/6500 XT/6500M](0x743F)"},
{0x1002, 0x743F, 0x1DA2, 0xE457, "PULSE AMD Radeon RX 6500 XT(0x1DA2-0xE457)"},
{0x1002, 0x7446, 0xFFFF, 0xFFFF, "Navi 31 USB(0x7446)"},
{0x1002, 0x7448, 0xFFFF, 0xFFFF, "Navi 31 [Radeon Pro W7900](0x7448)"},
{0x1002, 0x744A, 0xFFFF, 0xFFFF, "Navi 31 [Radeon Pro W7900 Dual Slot](0x744A)"},
{0x1002, 0x744C, 0xFFFF, 0xFFFF, "Navi 31 [Radeon RX 7900 XT/7900 XTX/7900 GRE/7900M](0x744C)"},
{0x1002, 0x744C, 0x1002, 0x0E3B, "RX 7900 XTX / RX 7900 GRE [XFX](0x1002-0x0E3B)"},
{0x1002, 0x744C, 0x1043, 0x0506, "TUF Gaming Radeon RX 7900 XTX OC(0x1043-0x0506)"},
{0x1002, 0x744C, 0x148C, 0x2425, "HELLHOUND RX 7900 GRE(0x148C-0x2425)"},
{0x1002, 0x744C, 0x1849, 0x5304, "Radeon RX 7900 XTX(0x1849-0x5304)"},
{0x1002, 0x744C, 0x1DA2, 0x471E, "PULSE RX 7900 XTX(0x1DA2-0x471E)"},
{0x1002, 0x744C, 0x1DA2, 0x475E, "PULSE RX 7900 GRE(0x1DA2-0x475E)"},
{0x1002, 0x744C, 0x1DA2, 0xE471, "NITRO+ RX 7900 XTX Vapor-X(0x1DA2-0xE471)"},
{0x1002, 0x744C, 0x1EAE, 0x7901, "RX-79XMERCB9 [SPEEDSTER MERC 310 RX 7900 XTX](0x1EAE-0x7901)"},
{0x1002, 0x744C, 0x1EAE, 0x790A, "RX-79GMERCBR [XFX RX 7900 GRE](0x1EAE-0x790A)"},
{0x1002, 0x745E, 0xFFFF, 0xFFFF, "Navi 31 [Radeon Pro W7800](0x745E)"},
{0x1002, 0x7460, 0xFFFF, 0xFFFF, "Navi32 GL-XL [AMD Radeon PRO V710](0x7460)"},
{0x1002, 0x7461, 0xFFFF, 0xFFFF, "Navi 32 [AMD Radeon PRO V710](0x7461)"},
{0x1002, 0x7470, 0xFFFF, 0xFFFF, "Navi 32 [Radeon PRO W7700](0x7470)"},
{0x1002, 0x747E, 0xFFFF, 0xFFFF, "Navi 32 [Radeon RX 7700 XT / 7800 XT](0x747E)"},
{0x1002, 0x747E, 0x148C, 0x2427, "RX 7800 XT [Hellhound / Red Devil](0x148C-0x2427)"},
{0x1002, 0x7480, 0xFFFF, 0xFFFF, "Navi 33 [Radeon RX 7600/7600 XT/7600M XT/7600S/7700S / PRO W7600](0x7480)"},
{0x1002, 0x7480, 0x1849, 0x5313, "RX 7600 Challenger OC(0x1849-0x5313)"},
{0x1002, 0x7481, 0xFFFF, 0xFFFF, "Navi 33 [Radeon Graphics](0x7481)"},
{0x1002, 0x7483, 0xFFFF, 0xFFFF, "Navi 33 [Radeon RX 7600M/7600M XT](0x7483)"},
{0x1002, 0x7487, 0xFFFF, 0xFFFF, "Navi 33 [Radeon Graphics](0x7487)"},
{0x1002, 0x7489, 0xFFFF, 0xFFFF, "Navi 33 [Radeon Pro W7500](0x7489)"},
{0x1002, 0x748B, 0xFFFF, 0xFFFF, "Navi 33 [Radeon Graphics](0x748B)"},
{0x1002, 0x7499, 0xFFFF, 0xFFFF, "Navi 33 [Radeon RX 7400/7300/Pro W7400](0x7499)"},
{0x1002, 0x749F, 0xFFFF, 0xFFFF, "Navi 33 [Radeon RX 7500](0x749F)"},
{0x1002, 0x74A0, 0xFFFF, 0xFFFF, "Aqua Vanjaram [Instinct MI300A](0x74A0)"},
{0x1002, 0x74A1, 0xFFFF, 0xFFFF, "Aqua Vanjaram [Instinct MI300X](0x74A1)"},
{0x1002, 0x74A2, 0xFFFF, 0xFFFF, "Aqua Vanjaram [Instinct MI308X](0x74A2)"},
{0x1002, 0x74A5, 0xFFFF, 0xFFFF, "Aqua Vanjaram [Instinct MI325X](0x74A5)"},
{0x1002, 0x74A9, 0xFFFF, 0xFFFF, "Aqua Vanjaram [Instinct MI300X HF](0x74A9)"},
{0x1002, 0x74B5, 0xFFFF, 0xFFFF, "Aqua Vanjaram [Instinct MI300X VF](0x74B5)"},
{0x1002, 0x74B9, 0xFFFF, 0xFFFF, "Aqua Vanjaram [Instinct MI325X VF](0x74B9)"},
{0x1002, 0x74BD, 0xFFFF, 0xFFFF, "Aqua Vanjaram [Instinct MI300X HF](0x74BD)"},
{0x1002, 0x7550, 0xFFFF, 0xFFFF, "Navi 48 [Radeon RX 9070/9070 XT/9070 GRE](0x7550)"},
{0x1002, 0x7550, 0x148C, 0x2435, "Reaper Radeon RX 9070 XT 16GB GDDR6 (RX9070XT 16G-A)(0x148C-0x2435)"},
{0x1002, 0x7550, 0x1DA2, 0xE490, "Navi 48 XTX [Sapphire Pulse Radeon RX 9070 XT](0x1DA2-0xE490)"},
{0x1002, 0x7551, 0xFFFF, 0xFFFF, "Navi 48 [Radeon AI PRO R9700](0x7551)"},
{0x1002, 0x7590, 0xFFFF, 0xFFFF, "Navi 44 [Radeon RX 9060 XT](0x7590)"},
{0x1002, 0x7833, 0xFFFF, 0xFFFF, "RS350 Host Bridge(0x7833)"},
{0x1002, 0x7834, 0xFFFF, 0xFFFF, "RS350 [Radeon 9100 PRO/XT IGP](0x7834)"},
{0x1002, 0x7835, 0xFFFF, 0xFFFF, "RS350M [Mobility Radeon 9000 IGP](0x7835)"},
{0x1002, 0x7838, 0xFFFF, 0xFFFF, "RS350 AGP Bridge(0x7838)"},
{0x1002, 0x7910, 0xFFFF, 0xFFFF, "RS690 Host Bridge(0x7910)"},
{0x1002, 0x7910, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x7910, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x7911, 0xFFFF, 0xFFFF, "RS690/RS740 Host Bridge(0x7911)"},
{0x1002, 0x7911, 0x1002, 0x7910, "RS690/RS740 Host Bridge(0x1002-0x7910)"},
{0x1002, 0x7912, 0xFFFF, 0xFFFF, "RS690/RS740 PCI to PCI Bridge (Internal gfx)(0x7912)"},
{0x1002, 0x7913, 0xFFFF, 0xFFFF, "RS690 PCI to PCI Bridge (PCI Express Graphics Port 0)(0x7913)"},
{0x1002, 0x7915, 0xFFFF, 0xFFFF, "RS690 PCI to PCI Bridge (PCI Express Port 1)(0x7915)"},
{0x1002, 0x7916, 0xFFFF, 0xFFFF, "RS690 PCI to PCI Bridge (PCI Express Port 2)(0x7916)"},
{0x1002, 0x7917, 0xFFFF, 0xFFFF, "RS690 PCI to PCI Bridge (PCI Express Port 3)(0x7917)"},
{0x1002, 0x7917, 0x1002, 0x7910, "RS690 PCI to PCI Bridge(0x1002-0x7910)"},
{0x1002, 0x7919, 0xFFFF, 0xFFFF, "RS690 HDMI Audio [Radeon Xpress 1200 Series](0x7919)"},
{0x1002, 0x7919, 0x1179, 0x7919, "Satellite P305D-S8995E(0x1179-0x7919)"},
{0x1002, 0x7919, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x791E, 0xFFFF, 0xFFFF, "RS690 [Radeon X1200](0x791E)"},
{0x1002, 0x791E, 0x1462, 0x7327, "K9AG Neo2(0x1462-0x7327)"},
{0x1002, 0x791E, 0x17F2, 0x5000, "KI690-AM2 Motherboard(0x17F2-0x5000)"},
{0x1002, 0x791F, 0xFFFF, 0xFFFF, "RS690M [Radeon Xpress 1200/1250/1270](0x791F)"},
{0x1002, 0x791F, 0x1179, 0xFF50, "Satellite P305D-S8995E(0x1179-0xFF50)"},
{0x1002, 0x7930, 0xFFFF, 0xFFFF, "RS600 Host Bridge(0x7930)"},
{0x1002, 0x7932, 0xFFFF, 0xFFFF, "RS600 PCI to PCI Bridge (Internal gfx)(0x7932)"},
{0x1002, 0x7933, 0xFFFF, 0xFFFF, "RS600 PCI to PCI Bridge (PCI Express Graphics Port 0)(0x7933)"},
{0x1002, 0x7935, 0xFFFF, 0xFFFF, "RS600 PCI to PCI Bridge (PCI Express Port 1)(0x7935)"},
{0x1002, 0x7936, 0xFFFF, 0xFFFF, "RS600 PCI to PCI Bridge (PCI Express Port 2)(0x7936)"},
{0x1002, 0x7937, 0xFFFF, 0xFFFF, "RS690 PCI to PCI Bridge (PCI Express Port 3)(0x7937)"},
{0x1002, 0x793B, 0xFFFF, 0xFFFF, "RS600 HDMI Audio [Radeon Xpress 1250](0x793B)"},
{0x1002, 0x793F, 0xFFFF, 0xFFFF, "RS690M [Radeon Xpress 1200/1250/1270] (Secondary)(0x793F)"},
{0x1002, 0x7941, 0xFFFF, 0xFFFF, "RS600 [Radeon Xpress 1250](0x7941)"},
{0x1002, 0x7942, 0xFFFF, 0xFFFF, "RS600M [Radeon Xpress 1250](0x7942)"},
{0x1002, 0x796E, 0xFFFF, 0xFFFF, "RS740 [Radeon 2100](0x796E)"},
{0x1002, 0x796E, 0x105B, 0x0E13, "N15235/A74MX mainboard(0x105B-0x0E13)"},
{0x1002, 0x9400, 0xFFFF, 0xFFFF, "R600 [Radeon HD 2900 PRO/XT](0x9400)"},
{0x1002, 0x9400, 0x1002, 0x2552, "Radeon HD 2900 XT(0x1002-0x2552)"},
{0x1002, 0x9400, 0x1002, 0x3000, "Radeon HD 2900 PRO(0x1002-0x3000)"},
{0x1002, 0x9400, 0x1002, 0x3142, "HIS Radeon HD 2900XT 512MB GDDR3 VIVO PCIe(0x1002-0x3142)"},
{0x1002, 0x9401, 0xFFFF, 0xFFFF, "R600 [Radeon HD 2900 XT](0x9401)"},
{0x1002, 0x9403, 0xFFFF, 0xFFFF, "R600 [Radeon HD 2900 PRO](0x9403)"},
{0x1002, 0x9405, 0xFFFF, 0xFFFF, "R600 [Radeon HD 2900 GT](0x9405)"},
{0x1002, 0x940A, 0xFFFF, 0xFFFF, "R600 GL [FireGL V8650](0x940A)"},
{0x1002, 0x940A, 0x13CC, 0x3D16, "MXRT-7200(0x13CC-0x3D16)"},
{0x1002, 0x940B, 0xFFFF, 0xFFFF, "R600 GL [FireGL V8600](0x940B)"},
{0x1002, 0x940F, 0xFFFF, 0xFFFF, "R600 GL [FireGL V7600](0x940F)"},
{0x1002, 0x9440, 0xFFFF, 0xFFFF, "RV770 [Radeon HD 4870](0x9440)"},
{0x1002, 0x9441, 0xFFFF, 0xFFFF, "R700 [Radeon HD 4870 X2](0x9441)"},
{0x1002, 0x9442, 0xFFFF, 0xFFFF, "RV770 [Radeon HD 4850](0x9442)"},
{0x1002, 0x9442, 0x1002, 0x0502, "MSI Radeon HD 4850 512MB GDDR3(0x1002-0x0502)"},
{0x1002, 0x9442, 0x174B, 0xE810, "Radeon HD 4850 512MB GDDR3(0x174B-0xE810)"},
{0x1002, 0x9443, 0xFFFF, 0xFFFF, "R700 [Radeon HD 4850 X2](0x9443)"},
{0x1002, 0x9444, 0xFFFF, 0xFFFF, "RV770 GL [FirePro V8750](0x9444)"},
{0x1002, 0x9446, 0xFFFF, 0xFFFF, "RV770 GL [FirePro V7760](0x9446)"},
{0x1002, 0x944A, 0xFFFF, 0xFFFF, "RV770/M98L [Mobility Radeon HD 4850](0x944A)"},
{0x1002, 0x944B, 0xFFFF, 0xFFFF, "RV770/M98 [Mobility Radeon HD 4850 X2](0x944B)"},
{0x1002, 0x944C, 0xFFFF, 0xFFFF, "RV770 LE [Radeon HD 4830](0x944C)"},
{0x1002, 0x944E, 0xFFFF, 0xFFFF, "RV770 CE [Radeon HD 4710](0x944E)"},
{0x1002, 0x944E, 0x174B, 0x3261, "Radeon HD 4810(0x174B-0x3261)"},
{0x1002, 0x9450, 0xFFFF, 0xFFFF, "RV770 GL [FireStream 9270](0x9450)"},
{0x1002, 0x9452, 0xFFFF, 0xFFFF, "RV770 GL [FireStream 9250](0x9452)"},
{0x1002, 0x9456, 0xFFFF, 0xFFFF, "RV770 GL [FirePro V8700](0x9456)"},
{0x1002, 0x945A, 0xFFFF, 0xFFFF, "RV770/M98-XT [Mobility Radeon HD 4870](0x945A)"},
{0x1002, 0x9460, 0xFFFF, 0xFFFF, "RV790 [Radeon HD 4890](0x9460)"},
{0x1002, 0x9462, 0xFFFF, 0xFFFF, "RV790 [Radeon HD 4860](0x9462)"},
{0x1002, 0x946A, 0xFFFF, 0xFFFF, "RV770 GL [FirePro M7750](0x946A)"},
{0x1002, 0x9480, 0xFFFF, 0xFFFF, "RV730/M96 [Mobility Radeon HD 4650/5165](0x9480)"},
{0x1002, 0x9480, 0x103C, 0x3628, "Mobility Radeon HD 4650 [dv6-1190en](0x103C-0x3628)"},
{0x1002, 0x9488, 0xFFFF, 0xFFFF, "RV730/M96-XT [Mobility Radeon HD 4670](0x9488)"},
{0x1002, 0x9489, 0xFFFF, 0xFFFF, "RV730/M96 GL [Mobility FireGL V5725](0x9489)"},
{0x1002, 0x9490, 0xFFFF, 0xFFFF, "RV730 XT [Radeon HD 4670](0x9490)"},
{0x1002, 0x9490, 0x174B, 0xE880, "Radeon HD 4670 512MB GDDR3 Dual DVI-I/TVO(0x174B-0xE880)"},
{0x1002, 0x9491, 0xFFFF, 0xFFFF, "RV730/M96-CSP [Radeon E4690](0x9491)"},
{0x1002, 0x9495, 0xFFFF, 0xFFFF, "RV730 [Radeon HD 4600 AGP Series](0x9495)"},
{0x1002, 0x9495, 0x1002, 0x0028, "Radeon HD 4650/4670 AGP(0x1002-0x0028)"},
{0x1002, 0x9495, 0x1092, 0x0028, "Radeon HD 4670 AGP 512MB DDR2(0x1092-0x0028)"},
{0x1002, 0x9495, 0x1458, 0x0028, "Radeon HD 4650 AGP(0x1458-0x0028)"},
{0x1002, 0x9495, 0x1682, 0x0028, "Radeon HD 4650 AGP(0x1682-0x0028)"},
{0x1002, 0x9495, 0x174B, 0x0028, "Radeon HD 4650 AGP DDR2(0x174B-0x0028)"},
{0x1002, 0x9498, 0xFFFF, 0xFFFF, "RV730 PRO [Radeon HD 4650](0x9498)"},
{0x1002, 0x949C, 0xFFFF, 0xFFFF, "RV730 GL [FirePro V7750](0x949C)"},
{0x1002, 0x949C, 0x13CC, 0x3D1B, "MXRT-7300(0x13CC-0x3D1B)"},
{0x1002, 0x949E, 0xFFFF, 0xFFFF, "RV730 GL [FirePro V5700](0x949E)"},
{0x1002, 0x949F, 0xFFFF, 0xFFFF, "RV730 GL [FirePro V3750](0x949F)"},
{0x1002, 0x94A0, 0xFFFF, 0xFFFF, "RV740/M97 [Mobility Radeon HD 4830](0x94A0)"},
{0x1002, 0x94A1, 0xFFFF, 0xFFFF, "RV740/M97-XT [Mobility Radeon HD 4860](0x94A1)"},
{0x1002, 0x94A3, 0xFFFF, 0xFFFF, "RV740/M97 GL [FirePro M7740](0x94A3)"},
{0x1002, 0x94B3, 0xFFFF, 0xFFFF, "RV740 PRO [Radeon HD 4770](0x94B3)"},
{0x1002, 0x94B4, 0xFFFF, 0xFFFF, "RV740 PRO [Radeon HD 4750](0x94B4)"},
{0x1002, 0x94C1, 0xFFFF, 0xFFFF, "RV610 [Radeon HD 2400 PRO/XT](0x94C1)"},
{0x1002, 0x94C1, 0x1028, 0x0211, "Optiplex 755(0x1028-0x0211)"},
{0x1002, 0x94C1, 0x1028, 0x0D02, "Optiplex 755(0x1028-0x0D02)"},
{0x1002, 0x94C3, 0xFFFF, 0xFFFF, "RV610 [Radeon HD 2400 PRO](0x94C3)"},
{0x1002, 0x94C3, 0x1028, 0x0302, "Radeon HD 2400 Pro(0x1028-0x0302)"},
{0x1002, 0x94C3, 0x174B, 0xE400, "Radeon HD 2400 PRO(0x174B-0xE400)"},
{0x1002, 0x94C3, 0x18BC, 0x3550, "Radeon HD 2400 PRO(0x18BC-0x3550)"},
{0x1002, 0x94C4, 0xFFFF, 0xFFFF, "RV610 LE [Radeon HD 2400 PRO AGP](0x94C4)"},
{0x1002, 0x94C5, 0xFFFF, 0xFFFF, "RV610 [Radeon HD 2400 LE](0x94C5)"},
{0x1002, 0x94C7, 0xFFFF, 0xFFFF, "RV610 [Radeon HD 2350](0x94C7)"},
{0x1002, 0x94C8, 0xFFFF, 0xFFFF, "RV610/M74 [Mobility Radeon HD 2400 XT](0x94C8)"},
{0x1002, 0x94C9, 0xFFFF, 0xFFFF, "RV610/M72-S [Mobility Radeon HD 2400](0x94C9)"},
{0x1002, 0x94C9, 0x1002, 0x94C9, "Radeon HD2400(0x1002-0x94C9)"},
{0x1002, 0x94CB, 0xFFFF, 0xFFFF, "RV610 [Radeon E2400](0x94CB)"},
{0x1002, 0x94CC, 0xFFFF, 0xFFFF, "RV610 LE [Radeon HD 2400 PRO PCI](0x94CC)"},
{0x1002, 0x9500, 0xFFFF, 0xFFFF, "RV670 [Radeon HD 3850 X2](0x9500)"},
{0x1002, 0x9501, 0xFFFF, 0xFFFF, "RV670 [Radeon HD 3870](0x9501)"},
{0x1002, 0x9501, 0x174B, 0xE620, "Radeon HD 3870(0x174B-0xE620)"},
{0x1002, 0x9504, 0xFFFF, 0xFFFF, "RV670/M88 [Mobility Radeon HD 3850](0x9504)"},
{0x1002, 0x9505, 0xFFFF, 0xFFFF, "RV670 [Radeon HD 3690/3850](0x9505)"},
{0x1002, 0x9505, 0x148C, 0x3000, "Radeon HD 3850(0x148C-0x3000)"},
{0x1002, 0x9505, 0x174B, 0x3000, "Radeon HD 3690/3850(0x174B-0x3000)"},
{0x1002, 0x9505, 0x1787, 0x3000, "Radeon HD 3690(0x1787-0x3000)"},
{0x1002, 0x9506, 0xFFFF, 0xFFFF, "RV670/M88 [Mobility Radeon HD 3850 X2](0x9506)"},
{0x1002, 0x9507, 0xFFFF, 0xFFFF, "RV670 [Radeon HD 3830](0x9507)"},
{0x1002, 0x9508, 0xFFFF, 0xFFFF, "RV670/M88-XT [Mobility Radeon HD 3870](0x9508)"},
{0x1002, 0x9509, 0xFFFF, 0xFFFF, "RV670/M88 [Mobility Radeon HD 3870 X2](0x9509)"},
{0x1002, 0x950F, 0xFFFF, 0xFFFF, "R680 [Radeon HD 3870 X2](0x950F)"},
{0x1002, 0x9511, 0xFFFF, 0xFFFF, "RV670 GL [FireGL V7700](0x9511)"},
{0x1002, 0x9513, 0xFFFF, 0xFFFF, "RV670 [Radeon HD 3850 X2](0x9513)"},
{0x1002, 0x9515, 0xFFFF, 0xFFFF, "RV670 PRO [Radeon HD 3850 AGP](0x9515)"},
{0x1002, 0x9519, 0xFFFF, 0xFFFF, "RV670 GL [FireStream 9170](0x9519)"},
{0x1002, 0x9540, 0xFFFF, 0xFFFF, "RV710 [Radeon HD 4550](0x9540)"},
{0x1002, 0x954F, 0xFFFF, 0xFFFF, "RV710 [Radeon HD 4350/4550](0x954F)"},
{0x1002, 0x954F, 0x1462, 0x1618, "R4350 MD512H (MS-V161)(0x1462-0x1618)"},
{0x1002, 0x9552, 0xFFFF, 0xFFFF, "RV710/M92 [Mobility Radeon HD 4330/4350/4550](0x9552)"},
{0x1002, 0x9552, 0x1028, 0x1103, "M92 [Mobility Radeon HD 4330](0x1028-0x1103)"},
{0x1002, 0x9552, 0x1458, 0x21AC, "Radeon HD 4350(0x1458-0x21AC)"},
{0x1002, 0x9552, 0x1458, 0x21ED, "Radeon HD 4550(0x1458-0x21ED)"},
{0x1002, 0x9552, 0x148C, 0x3000, "Radeon HD 4350 Go! Green 512MB GDDR3(0x148C-0x3000)"},
{0x1002, 0x9552, 0x174B, 0x3000, "Radeon HD 4350/4550 HyperMemory DDR2(0x174B-0x3000)"},
{0x1002, 0x9553, 0xFFFF, 0xFFFF, "RV710/M92 [Mobility Radeon HD 4530/4570/5145/530v/540v/545v](0x9553)"},
{0x1002, 0x9553, 0x1025, 0x015E, "Mobility Radeon HD 4570(0x1025-0x015E)"},
{0x1002, 0x9553, 0x1025, 0x017D, "Mobility Radeon HD 4570(0x1025-0x017D)"},
{0x1002, 0x9553, 0x1025, 0x0205, "Mobility Radeon HD 4570 / 545v(0x1025-0x0205)"},
{0x1002, 0x9553, 0x1025, 0x0206, "Mobility Radeon HD 4570(0x1025-0x0206)"},
{0x1002, 0x9553, 0x1025, 0x0237, "Mobility Radeon HD 4570(0x1025-0x0237)"},
{0x1002, 0x9553, 0x1028, 0x02BE, "Mobility Radeon HD 4570 / 545v(0x1028-0x02BE)"},
{0x1002, 0x9553, 0x1028, 0x02E8, "Mobility Radeon HD 4530(0x1028-0x02E8)"},
{0x1002, 0x9553, 0x103C, 0x143C, "Mobility Radeon HD 545v(0x103C-0x143C)"},
{0x1002, 0x9553, 0x103C, 0x1446, "Mobility Radeon HD 545v(0x103C-0x1446)"},
{0x1002, 0x9553, 0x103C, 0x3624, "Mobility Radeon HD 4530(0x103C-0x3624)"},
{0x1002, 0x9553, 0x103C, 0x3628, "Mobility Radeon HD 4530(0x103C-0x3628)"},
{0x1002, 0x9553, 0x103C, 0x3636, "Mobility Radeon HD 4530(0x103C-0x3636)"},
{0x1002, 0x9553, 0x1043, 0x1B32, "Mobility Radeon HD 4570(0x1043-0x1B32)"},
{0x1002, 0x9553, 0x1043, 0x1B42, "Mobility Radeon HD 4570(0x1043-0x1B42)"},
{0x1002, 0x9553, 0x104D, 0x9056, "Mobility Radeon HD 4570(0x104D-0x9056)"},
{0x1002, 0x9553, 0x1179, 0xFF82, "Satellite L505-13T GPU (Mobility Radeon HD 5145)(0x1179-0xFF82)"},
{0x1002, 0x9553, 0x144D, 0xC07F, "Mobility Radeon HD 545v(0x144D-0xC07F)"},
{0x1002, 0x9553, 0x144D, 0xC571, "Mobility Radeon HD 545v(0x144D-0xC571)"},
{0x1002, 0x9553, 0x1462, 0x1006, "Mobility Radeon HD 545v(0x1462-0x1006)"},
{0x1002, 0x9553, 0x17AA, 0x2129, "Mobility Radeon HD 545v(0x17AA-0x2129)"},
{0x1002, 0x9553, 0x17AA, 0x215B, "Mobility Radeon HD 545v(0x17AA-0x215B)"},
{0x1002, 0x9553, 0x17AA, 0x21BB, "Mobility Radeon HD 545v(0x17AA-0x21BB)"},
{0x1002, 0x9555, 0xFFFF, 0xFFFF, "RV711/M93 [Mobility Radeon HD 4350/4550/530v/540v/545v / FirePro RG220](0x9555)"},
{0x1002, 0x9555, 0x103C, 0x1411, "ProBook 4720s GPU (Mobility Radeon HD 4350)(0x103C-0x1411)"},
{0x1002, 0x9557, 0xFFFF, 0xFFFF, "RV711/M93 GL [FirePro RG220](0x9557)"},
{0x1002, 0x955F, 0xFFFF, 0xFFFF, "RV710/M92 [Mobility Radeon HD 4330](0x955F)"},
{0x1002, 0x9580, 0xFFFF, 0xFFFF, "RV630 [Radeon HD 2600 PRO](0x9580)"},
{0x1002, 0x9581, 0xFFFF, 0xFFFF, "RV630/M76 [Mobility Radeon HD 2600](0x9581)"},
{0x1002, 0x9583, 0xFFFF, 0xFFFF, "RV630/M76 [Mobility Radeon HD 2600 XT/2700](0x9583)"},
{0x1002, 0x9583, 0x106B, 0x0083, "iMac 7,1(0x106B-0x0083)"},
{0x1002, 0x9583, 0x1734, 0x1107, "Mobility Radeon HD 2700(0x1734-0x1107)"},
{0x1002, 0x9586, 0xFFFF, 0xFFFF, "RV630 XT [Radeon HD 2600 XT AGP](0x9586)"},
{0x1002, 0x9587, 0xFFFF, 0xFFFF, "RV630 PRO [Radeon HD 2600 PRO AGP](0x9587)"},
{0x1002, 0x9588, 0xFFFF, 0xFFFF, "RV630 XT [Radeon HD 2600 XT](0x9588)"},
{0x1002, 0x9588, 0x1458, 0x216C, "Radeon HD 2600 XT, 256MB GDDR3, 2x DVI, TV-out, PCIe (GV-RX26T256H)(0x1458-0x216C)"},
{0x1002, 0x9589, 0xFFFF, 0xFFFF, "RV630 PRO [Radeon HD 2600 PRO](0x9589)"},
{0x1002, 0x9589, 0x1787, 0x3000, "Radeon HD 3610(0x1787-0x3000)"},
{0x1002, 0x958A, 0xFFFF, 0xFFFF, "RV630 [Radeon HD 2600 X2](0x958A)"},
{0x1002, 0x958B, 0xFFFF, 0xFFFF, "RV630/M76 [Mobility Radeon HD 2600 XT](0x958B)"},
{0x1002, 0x958C, 0xFFFF, 0xFFFF, "RV630 GL [FireGL V5600](0x958C)"},
{0x1002, 0x958C, 0x13CC, 0x3D18, "MXRT-5200(0x13CC-0x3D18)"},
{0x1002, 0x958D, 0xFFFF, 0xFFFF, "RV630 GL [FireGL V3600](0x958D)"},
{0x1002, 0x9591, 0xFFFF, 0xFFFF, "RV635/M86 [Mobility Radeon HD 3650](0x9591)"},
{0x1002, 0x9591, 0x1002, 0x9591, "Mobility Radeon HD 3650(0x1002-0x9591)"},
{0x1002, 0x9593, 0xFFFF, 0xFFFF, "RV635/M86 [Mobility Radeon HD 3670](0x9593)"},
{0x1002, 0x9595, 0xFFFF, 0xFFFF, "RV635/M86 GL [Mobility FireGL V5700](0x9595)"},
{0x1002, 0x9596, 0xFFFF, 0xFFFF, "RV635 PRO [Radeon HD 3650 AGP](0x9596)"},
{0x1002, 0x9596, 0x1043, 0x0028, "EAH3650 SILENT/HTDI/512M/A(0x1043-0x0028)"},
{0x1002, 0x9597, 0xFFFF, 0xFFFF, "RV635 PRO [Radeon HD 3650 AGP](0x9597)"},
{0x1002, 0x9598, 0xFFFF, 0xFFFF, "RV635 [Radeon HD 3650/3750/4570/4580](0x9598)"},
{0x1002, 0x9598, 0x1002, 0x9598, "Mobility Radeon HD 3600(0x1002-0x9598)"},
{0x1002, 0x9598, 0x1043, 0x01D6, "EAH3650 Silent(0x1043-0x01D6)"},
{0x1002, 0x9598, 0x1043, 0x3001, "Radeon HD 4570(0x1043-0x3001)"},
{0x1002, 0x9598, 0x174B, 0x3001, "Radeon HD 3750(0x174B-0x3001)"},
{0x1002, 0x9598, 0x174B, 0x4580, "RV635 PRO [Radeon HD 4580](0x174B-0x4580)"},
{0x1002, 0x9598, 0x17AF, 0x3011, "RV635 PRO [Radeon HD 4580](0x17AF-0x3011)"},
{0x1002, 0x9599, 0xFFFF, 0xFFFF, "RV635 PRO [Radeon HD 3650 AGP](0x9599)"},
{0x1002, 0x95C0, 0xFFFF, 0xFFFF, "RV620 PRO [Radeon HD 3470](0x95C0)"},
{0x1002, 0x95C0, 0x1002, 0x95C0, "Mobility Radeon HD 3470(0x1002-0x95C0)"},
{0x1002, 0x95C0, 0x1028, 0x3243, "C120D(0x1028-0x3243)"},
{0x1002, 0x95C2, 0xFFFF, 0xFFFF, "RV620/M82 [Mobility Radeon HD 3410/3430](0x95C2)"},
{0x1002, 0x95C4, 0xFFFF, 0xFFFF, "RV620/M82 [Mobility Radeon HD 3450/3470](0x95C4)"},
{0x1002, 0x95C4, 0x1002, 0x95C4, "Mobility Radeon HD 3400(0x1002-0x95C4)"},
{0x1002, 0x95C5, 0xFFFF, 0xFFFF, "RV620 LE [Radeon HD 3450](0x95C5)"},
{0x1002, 0x95C5, 0x1028, 0x0342, "Radeon HD 3450 DMS-59(0x1028-0x0342)"},
{0x1002, 0x95C6, 0xFFFF, 0xFFFF, "RV620 LE [Radeon HD 3450 AGP](0x95C6)"},
{0x1002, 0x95C9, 0xFFFF, 0xFFFF, "RV620 LE [Radeon HD 3450 PCI](0x95C9)"},
{0x1002, 0x95CC, 0xFFFF, 0xFFFF, "RV620 GL [FirePro V3700](0x95CC)"},
{0x1002, 0x95CD, 0xFFFF, 0xFFFF, "RV620 GL [FirePro 2450](0x95CD)"},
{0x1002, 0x95CF, 0xFFFF, 0xFFFF, "RV620 GL [FirePro 2260](0x95CF)"},
{0x1002, 0x960F, 0xFFFF, 0xFFFF, "RS780 HDMI Audio [Radeon 3000/3100 / HD 3200/3300](0x960F)"},
{0x1002, 0x960F, 0x1462, 0x7596, "760GM-E51(MS-7596) Motherboard(0x1462-0x7596)"},
{0x1002, 0x9610, 0xFFFF, 0xFFFF, "RS780 [Radeon HD 3200](0x9610)"},
{0x1002, 0x9610, 0x1458, 0xD000, "GA-MA78GM-S2H Motherboard(0x1458-0xD000)"},
{0x1002, 0x9611, 0xFFFF, 0xFFFF, "RS780C [Radeon 3100](0x9611)"},
{0x1002, 0x9612, 0xFFFF, 0xFFFF, "RS780M [Mobility Radeon HD 3200](0x9612)"},
{0x1002, 0x9613, 0xFFFF, 0xFFFF, "RS780MC [Mobility Radeon HD 3100](0x9613)"},
{0x1002, 0x9614, 0xFFFF, 0xFFFF, "RS780D [Radeon HD 3300](0x9614)"},
{0x1002, 0x9615, 0xFFFF, 0xFFFF, "RS780E [Radeon HD 3200](0x9615)"},
{0x1002, 0x9616, 0xFFFF, 0xFFFF, "RS780L [Radeon 3000](0x9616)"},
{0x1002, 0x9616, 0x1462, 0x7501, "760GM-E51(MS-7596) Motherboard(0x1462-0x7501)"},
{0x1002, 0x9640, 0xFFFF, 0xFFFF, "Sumo [Radeon HD 6550D](0x9640)"},
{0x1002, 0x9641, 0xFFFF, 0xFFFF, "Sumo [Radeon HD 6620G](0x9641)"},
{0x1002, 0x9642, 0xFFFF, 0xFFFF, "SuperSumo [Radeon HD 6370D](0x9642)"},
{0x1002, 0x9643, 0xFFFF, 0xFFFF, "SuperSumo [Radeon HD 6380G](0x9643)"},
{0x1002, 0x9644, 0xFFFF, 0xFFFF, "SuperSumo [Radeon HD 6410D](0x9644)"},
{0x1002, 0x9645, 0xFFFF, 0xFFFF, "SuperSumo [Radeon HD 6410D](0x9645)"},
{0x1002, 0x9647, 0xFFFF, 0xFFFF, "Sumo [Radeon HD 6520G](0x9647)"},
{0x1002, 0x9648, 0xFFFF, 0xFFFF, "Sumo [Radeon HD 6480G](0x9648)"},
{0x1002, 0x9649, 0xFFFF, 0xFFFF, "SuperSumo [Radeon HD 6480G](0x9649)"},
{0x1002, 0x964A, 0xFFFF, 0xFFFF, "Sumo [Radeon HD 6530D](0x964A)"},
{0x1002, 0x964B, 0xFFFF, 0xFFFF, "Sumo(0x964B)"},
{0x1002, 0x964C, 0xFFFF, 0xFFFF, "Sumo(0x964C)"},
{0x1002, 0x964E, 0xFFFF, 0xFFFF, "Sumo(0x964E)"},
{0x1002, 0x964F, 0xFFFF, 0xFFFF, "Sumo(0x964F)"},
{0x1002, 0x970F, 0xFFFF, 0xFFFF, "RS880 HDMI Audio [Radeon HD 4200 Series](0x970F)"},
{0x1002, 0x970F, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1002, 0x970F, 0x1043, 0x83A2, "M4A785TD Motherboard(0x1043-0x83A2)"},
{0x1002, 0x970F, 0x1043, 0x843E, "M5A88-V EVO(0x1043-0x843E)"},
{0x1002, 0x9710, 0xFFFF, 0xFFFF, "RS880 [Radeon HD 4200](0x9710)"},
{0x1002, 0x9710, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1002, 0x9710, 0x1043, 0x83A2, "M4A785TD Motherboard(0x1043-0x83A2)"},
{0x1002, 0x9712, 0xFFFF, 0xFFFF, "RS880M [Mobility Radeon HD 4225/4250](0x9712)"},
{0x1002, 0x9712, 0x103C, 0x1609, "ProLiant MicroServer N36L(0x103C-0x1609)"},
{0x1002, 0x9713, 0xFFFF, 0xFFFF, "RS880M [Mobility Radeon HD 4100](0x9713)"},
{0x1002, 0x9714, 0xFFFF, 0xFFFF, "RS880 [Radeon HD 4290](0x9714)"},
{0x1002, 0x9715, 0xFFFF, 0xFFFF, "RS880 [Radeon HD 4250](0x9715)"},
{0x1002, 0x9715, 0x1043, 0x843E, "M5A88-V EVO(0x1043-0x843E)"},
{0x1002, 0x9802, 0xFFFF, 0xFFFF, "Wrestler [Radeon HD 6310](0x9802)"},
{0x1002, 0x9802, 0x174B, 0x1001, "PURE Fusion Mini(0x174B-0x1001)"},
{0x1002, 0x9803, 0xFFFF, 0xFFFF, "Wrestler [Radeon HD 6310](0x9803)"},
{0x1002, 0x9804, 0xFFFF, 0xFFFF, "Wrestler [Radeon HD 6250](0x9804)"},
{0x1002, 0x9805, 0xFFFF, 0xFFFF, "Wrestler [Radeon HD 6250](0x9805)"},
{0x1002, 0x9806, 0xFFFF, 0xFFFF, "Wrestler [Radeon HD 6320](0x9806)"},
{0x1002, 0x9807, 0xFFFF, 0xFFFF, "Wrestler [Radeon HD 6290](0x9807)"},
{0x1002, 0x9808, 0xFFFF, 0xFFFF, "Wrestler [Radeon HD 7340](0x9808)"},
{0x1002, 0x9809, 0xFFFF, 0xFFFF, "Wrestler [Radeon HD 7310](0x9809)"},
{0x1002, 0x980A, 0xFFFF, 0xFFFF, "Wrestler [Radeon HD 7290](0x980A)"},
{0x1002, 0x9830, 0xFFFF, 0xFFFF, "Kabini [Radeon HD 8400 / R3 Series](0x9830)"},
{0x1002, 0x9830, 0x1043, 0x8623, "AM1I-A Motherboard(0x1043-0x8623)"},
{0x1002, 0x9831, 0xFFFF, 0xFFFF, "Kabini [Radeon HD 8400E](0x9831)"},
{0x1002, 0x9832, 0xFFFF, 0xFFFF, "Kabini [Radeon HD 8330](0x9832)"},
{0x1002, 0x9832, 0x1849, 0x9832, "QC5000-ITX/PH(0x1849-0x9832)"},
{0x1002, 0x9833, 0xFFFF, 0xFFFF, "Kabini [Radeon HD 8330E](0x9833)"},
{0x1002, 0x9834, 0xFFFF, 0xFFFF, "Kabini [Radeon HD 8210](0x9834)"},
{0x1002, 0x9835, 0xFFFF, 0xFFFF, "Kabini [Radeon HD 8310E](0x9835)"},
{0x1002, 0x9836, 0xFFFF, 0xFFFF, "Kabini [Radeon HD 8280 / R3 Series](0x9836)"},
{0x1002, 0x9837, 0xFFFF, 0xFFFF, "Kabini [Radeon HD 8280E](0x9837)"},
{0x1002, 0x9838, 0xFFFF, 0xFFFF, "Kabini [Radeon HD 8240 / R3 Series](0x9838)"},
{0x1002, 0x9839, 0xFFFF, 0xFFFF, "Kabini [Radeon HD 8180](0x9839)"},
{0x1002, 0x983D, 0xFFFF, 0xFFFF, "Temash [Radeon HD 8250/8280G](0x983D)"},
{0x1002, 0x9840, 0xFFFF, 0xFFFF, "Kabini HDMI/DP Audio(0x9840)"},
{0x1002, 0x9840, 0x1043, 0x8623, "AM1I-A Motherboard(0x1043-0x8623)"},
{0x1002, 0x9840, 0x1849, 0x9840, "QC5000-ITX/PH(0x1849-0x9840)"},
{0x1002, 0x9850, 0xFFFF, 0xFFFF, "Mullins [Radeon R2/R3 Graphics](0x9850)"},
{0x1002, 0x9851, 0xFFFF, 0xFFFF, "Mullins [Radeon R4/R5 Graphics](0x9851)"},
{0x1002, 0x9851, 0x1179, 0xF928, "Beema [Radeon R5 Graphics](0x1179-0xF928)"},
{0x1002, 0x9852, 0xFFFF, 0xFFFF, "Mullins [Radeon R2 Graphics](0x9852)"},
{0x1002, 0x9853, 0xFFFF, 0xFFFF, "Mullins [Radeon R2 Graphics](0x9853)"},
{0x1002, 0x9854, 0xFFFF, 0xFFFF, "Mullins [Radeon R3E Graphics](0x9854)"},
{0x1002, 0x9855, 0xFFFF, 0xFFFF, "Mullins [Radeon R6 Graphics](0x9855)"},
{0x1002, 0x9856, 0xFFFF, 0xFFFF, "Mullins [Radeon R1E/R2E Graphics](0x9856)"},
{0x1002, 0x9857, 0xFFFF, 0xFFFF, "Mullins [Radeon APU XX-2200M with R2 Graphics](0x9857)"},
{0x1002, 0x9858, 0xFFFF, 0xFFFF, "Mullins(0x9858)"},
{0x1002, 0x9859, 0xFFFF, 0xFFFF, "Mullins(0x9859)"},
{0x1002, 0x985A, 0xFFFF, 0xFFFF, "Mullins(0x985A)"},
{0x1002, 0x985B, 0xFFFF, 0xFFFF, "Mullins(0x985B)"},
{0x1002, 0x985C, 0xFFFF, 0xFFFF, "Mullins(0x985C)"},
{0x1002, 0x985D, 0xFFFF, 0xFFFF, "Mullins(0x985D)"},
{0x1002, 0x985E, 0xFFFF, 0xFFFF, "Mullins(0x985E)"},
{0x1002, 0x985F, 0xFFFF, 0xFFFF, "Mullins(0x985F)"},
{0x1002, 0x9874, 0xFFFF, 0xFFFF, "Wani [Radeon R5/R6/R7 Graphics](0x9874)"},
{0x1002, 0x9874, 0x1002, 0x1871, "Radeon R5 Graphics(0x1002-0x1871)"},
{0x1002, 0x9874, 0x1002, 0x1E20, "Radeon R7 Graphics(0x1002-0x1E20)"},
{0x1002, 0x9874, 0x1028, 0x06BD, "Radeon R6 Graphics(0x1028-0x06BD)"},
{0x1002, 0x9874, 0x103C, 0x2B44, "Radeon R6 Graphics(0x103C-0x2B44)"},
{0x1002, 0x9874, 0x103C, 0x8221, "Radeon R5 Graphics(0x103C-0x8221)"},
{0x1002, 0x9874, 0x103C, 0x8223, "Radeon R5 Graphics(0x103C-0x8223)"},
{0x1002, 0x9874, 0x103C, 0x8238, "Radeon R7 Graphics(0x103C-0x8238)"},
{0x1002, 0x9874, 0x103C, 0x8353, "Radeon R7 Graphics(0x103C-0x8353)"},
{0x1002, 0x9874, 0x1458, 0xD000, "Radeon R7 Graphics(0x1458-0xD000)"},
{0x1002, 0x9874, 0x17AA, 0x5113, "Radeon R6 Graphics(0x17AA-0x5113)"},
{0x1002, 0x9874, 0x17AA, 0x5116, "Radeon R6 Graphics(0x17AA-0x5116)"},
{0x1002, 0x9874, 0x17AA, 0x5118, "Radeon R5 Graphics(0x17AA-0x5118)"},
{0x1002, 0x9890, 0xFFFF, 0xFFFF, "Amur(0x9890)"},
{0x1002, 0x98C0, 0xFFFF, 0xFFFF, "Nolan(0x98C0)"},
{0x1002, 0x98E4, 0xFFFF, 0xFFFF, "Stoney [Radeon R2/R3/R4/R5 Graphics](0x98E4)"},
{0x1002, 0x9900, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7660G](0x9900)"},
{0x1002, 0x9900, 0x103C, 0x1985, "Pavilion 17-e163sg Notebook PC(0x103C-0x1985)"},
{0x1002, 0x9901, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7660D](0x9901)"},
{0x1002, 0x9902, 0xFFFF, 0xFFFF, "Trinity HDMI Audio Controller(0x9902)"},
{0x1002, 0x9902, 0x103C, 0x194E, "ProBook 455 G1 Notebook(0x103C-0x194E)"},
{0x1002, 0x9902, 0x103C, 0x1985, "Pavilion 17-e163sg Notebook PC(0x103C-0x1985)"},
{0x1002, 0x9903, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7640G](0x9903)"},
{0x1002, 0x9903, 0x103C, 0x194E, "ProBook 455 G1 Notebook(0x103C-0x194E)"},
{0x1002, 0x9903, 0x103C, 0x1952, "ProBook 455 G1 Notebook(0x103C-0x1952)"},
{0x1002, 0x9904, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7560D](0x9904)"},
{0x1002, 0x9905, 0xFFFF, 0xFFFF, "Trinity GL [FirePro A300](0x9905)"},
{0x1002, 0x9906, 0xFFFF, 0xFFFF, "Trinity GL [FirePro A320](0x9906)"},
{0x1002, 0x9907, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7620G](0x9907)"},
{0x1002, 0x9908, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7600G](0x9908)"},
{0x1002, 0x9909, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7500G](0x9909)"},
{0x1002, 0x990A, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7500G](0x990A)"},
{0x1002, 0x990B, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8650G](0x990B)"},
{0x1002, 0x990C, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8670D](0x990C)"},
{0x1002, 0x990D, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8550G](0x990D)"},
{0x1002, 0x990E, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8570D](0x990E)"},
{0x1002, 0x990F, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8610G](0x990F)"},
{0x1002, 0x9910, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7660G](0x9910)"},
{0x1002, 0x9913, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7640G](0x9913)"},
{0x1002, 0x9917, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7620G](0x9917)"},
{0x1002, 0x9918, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7600G](0x9918)"},
{0x1002, 0x9919, 0xFFFF, 0xFFFF, "Trinity [Radeon HD 7500G](0x9919)"},
{0x1002, 0x991E, 0xFFFF, 0xFFFF, "Bishop [Xbox One S APU](0x991E)"},
{0x1002, 0x9920, 0xFFFF, 0xFFFF, "Liverpool [Playstation 4 APU](0x9920)"},
{0x1002, 0x9921, 0xFFFF, 0xFFFF, "Liverpool HDMI/DP Audio Controller(0x9921)"},
{0x1002, 0x9922, 0xFFFF, 0xFFFF, "Starshp(0x9922)"},
{0x1002, 0x9923, 0xFFFF, 0xFFFF, "Starsha2 [Kingston/Clayton](0x9923)"},
{0x1002, 0x9924, 0xFFFF, 0xFFFF, "Gladius(0x9924)"},
{0x1002, 0x9925, 0xFFFF, 0xFFFF, "Kingston/Clayton/Jupiter/Gladius/Montego HDMI Controller(0x9925)"},
{0x1002, 0x9926, 0xFFFF, 0xFFFF, "Jupiter(0x9926)"},
{0x1002, 0x9990, 0xFFFF, 0xFFFF, "Trinity 2 [Radeon HD 7520G](0x9990)"},
{0x1002, 0x9991, 0xFFFF, 0xFFFF, "Trinity 2 [Radeon HD 7540D](0x9991)"},
{0x1002, 0x9992, 0xFFFF, 0xFFFF, "Trinity 2 [Radeon HD 7420G](0x9992)"},
{0x1002, 0x9993, 0xFFFF, 0xFFFF, "Trinity 2 [Radeon HD 7480D](0x9993)"},
{0x1002, 0x9994, 0xFFFF, 0xFFFF, "Trinity 2 [Radeon HD 7400G](0x9994)"},
{0x1002, 0x9995, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8450G](0x9995)"},
{0x1002, 0x9996, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8470D](0x9996)"},
{0x1002, 0x9997, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8350G](0x9997)"},
{0x1002, 0x9998, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8370D](0x9998)"},
{0x1002, 0x9999, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8510G](0x9999)"},
{0x1002, 0x999A, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8410G](0x999A)"},
{0x1002, 0x999B, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8310G](0x999B)"},
{0x1002, 0x999C, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8650D](0x999C)"},
{0x1002, 0x999D, 0xFFFF, 0xFFFF, "Richland [Radeon HD 8550D](0x999D)"},
{0x1002, 0x99A0, 0xFFFF, 0xFFFF, "Trinity 2 [Radeon HD 7520G](0x99A0)"},
{0x1002, 0x99A2, 0xFFFF, 0xFFFF, "Trinity 2 [Radeon HD 7420G](0x99A2)"},
{0x1002, 0x99A4, 0xFFFF, 0xFFFF, "Trinity 2 [Radeon HD 7400G](0x99A4)"},
{0x1002, 0xAA00, 0xFFFF, 0xFFFF, "R600 HDMI Audio [Radeon HD 2900 GT/PRO/XT](0xAA00)"},
{0x1002, 0xAA08, 0xFFFF, 0xFFFF, "RV630 HDMI Audio [Radeon HD 2600 PRO/XT / HD 3610](0xAA08)"},
{0x1002, 0xAA10, 0xFFFF, 0xFFFF, "RV610 HDMI Audio [Radeon HD 2350 PRO / 2400 PRO/XT / HD 3410](0xAA10)"},
{0x1002, 0xAA10, 0x174B, 0xAA10, "Radeon HD 2400 PRO(0x174B-0xAA10)"},
{0x1002, 0xAA10, 0x18BC, 0xAA10, "Radeon HD 2400 PRO(0x18BC-0xAA10)"},
{0x1002, 0xAA18, 0xFFFF, 0xFFFF, "RV670/680 HDMI Audio [Radeon HD 3690/3800 Series](0xAA18)"},
{0x1002, 0xAA20, 0xFFFF, 0xFFFF, "RV635 HDMI Audio [Radeon HD 3650/3730/3750](0xAA20)"},
{0x1002, 0xAA28, 0xFFFF, 0xFFFF, "RV620 HDMI Audio [Radeon HD 3450/3470/3550/3570](0xAA28)"},
{0x1002, 0xAA30, 0xFFFF, 0xFFFF, "RV770 HDMI Audio [Radeon HD 4850/4870](0xAA30)"},
{0x1002, 0xAA30, 0x174B, 0xAA30, "Radeon HD 4850 512MB GDDR3 PCI-E Dual Slot Fansink(0x174B-0xAA30)"},
{0x1002, 0xAA38, 0xFFFF, 0xFFFF, "RV710/730 HDMI Audio [Radeon HD 4000 series](0xAA38)"},
{0x1002, 0xAA38, 0x103C, 0x3628, "dv6-1190en(0x103C-0x3628)"},
{0x1002, 0xAA50, 0xFFFF, 0xFFFF, "Cypress HDMI Audio [Radeon HD 5830/5850/5870 / 6850/6870 Rebrand](0xAA50)"},
{0x1002, 0xAA58, 0xFFFF, 0xFFFF, "Juniper HDMI Audio [Radeon HD 5700 Series](0xAA58)"},
{0x1002, 0xAA60, 0xFFFF, 0xFFFF, "Redwood HDMI Audio [Radeon HD 5000 Series](0xAA60)"},
{0x1002, 0xAA60, 0x1025, 0x033D, "Mobility Radeon HD 5650(0x1025-0x033D)"},
{0x1002, 0xAA60, 0x1025, 0x0347, "Aspire 7740G(0x1025-0x0347)"},
{0x1002, 0xAA68, 0xFFFF, 0xFFFF, "Cedar HDMI Audio [Radeon HD 5400/6300/7300 Series](0xAA68)"},
{0x1002, 0xAA68, 0x1028, 0xAA68, "XPS 8300(0x1028-0xAA68)"},
{0x1002, 0xAA80, 0xFFFF, 0xFFFF, "Cayman/Antilles HDMI Audio [Radeon HD 6930/6950/6970/6990](0xAA80)"},
{0x1002, 0xAA88, 0xFFFF, 0xFFFF, "Barts HDMI Audio [Radeon HD 6790/6850/6870 / 7720 OEM](0xAA88)"},
{0x1002, 0xAA90, 0xFFFF, 0xFFFF, "Turks HDMI Audio [Radeon HD 6500/6600 / 6700M Series](0xAA90)"},
{0x1002, 0xAA90, 0x1028, 0x04A3, "Precision M4600(0x1028-0x04A3)"},
{0x1002, 0xAA98, 0xFFFF, 0xFFFF, "Caicos HDMI Audio [Radeon HD 6450 / 7450/8450/8490 OEM / R5 230/235/235X OEM](0xAA98)"},
{0x1002, 0xAA98, 0x1043, 0xAA98, "EAH6450 SILENT/DI/1GD3(LP)(0x1043-0xAA98)"},
{0x1002, 0xAA98, 0x174B, 0xAA98, "Radeon HD 6450 1GB DDR3(0x174B-0xAA98)"},
{0x1002, 0xAAA0, 0xFFFF, 0xFFFF, "Tahiti HDMI Audio [Radeon HD 7870 XT / 7950/7970](0xAAA0)"},
{0x1002, 0xAAB0, 0xFFFF, 0xFFFF, "Oland/Hainan/Cape Verde/Pitcairn HDMI Audio [Radeon HD 7000 Series](0xAAB0)"},
{0x1002, 0xAAB8, 0xFFFF, 0xFFFF, "Tiran HDMI Audio(0xAAB8)"},
{0x1002, 0xAAC0, 0xFFFF, 0xFFFF, "Tobago HDMI Audio [Radeon R7 360 / R9 360 OEM](0xAAC0)"},
{0x1002, 0xAAC0, 0x1043, 0xAAC0, "R7260X-DC2OC-2GD5(0x1043-0xAAC0)"},
{0x1002, 0xAAC8, 0xFFFF, 0xFFFF, "Hawaii HDMI Audio [Radeon R9 290/290X / 390/390X](0xAAC8)"},
{0x1002, 0xAAD8, 0xFFFF, 0xFFFF, "Tonga HDMI Audio [Radeon R9 285/380](0xAAD8)"},
{0x1002, 0xAAD8, 0x174B, 0xAAD8, "Radeon R9 285/380 HDMI Audio(0x174B-0xAAD8)"},
{0x1002, 0xAAE0, 0xFFFF, 0xFFFF, "Baffin HDMI/DP Audio [Radeon RX 550 640SP / RX 560/560X](0xAAE0)"},
{0x1002, 0xAAE8, 0xFFFF, 0xFFFF, "Fiji HDMI/DP Audio [Radeon R9 Nano / FURY/FURY X](0xAAE8)"},
{0x1002, 0xAAF0, 0xFFFF, 0xFFFF, "Ellesmere HDMI Audio [Radeon RX 470/480 / 570/580/590](0xAAF0)"},
{0x1002, 0xAAF8, 0xFFFF, 0xFFFF, "Vega 10 HDMI Audio [Radeon Vega 56/64](0xAAF8)"},
{0x1002, 0xAB00, 0xFFFF, 0xFFFF, "Baffin HDMI/DP Audio [Radeon RX 550 640SP / RX 560/560X](0xAB00)"},
{0x1002, 0xAB08, 0xFFFF, 0xFFFF, "Polaris 22 HDMI Audio(0xAB08)"},
{0x1002, 0xAB10, 0xFFFF, 0xFFFF, "Lexa HDMI Audio(0xAB10)"},
{0x1002, 0xAB18, 0xFFFF, 0xFFFF, "Vega 12 HDMI Audio(0xAB18)"},
{0x1002, 0xAB20, 0xFFFF, 0xFFFF, "Vega 20 HDMI Audio [Radeon VII](0xAB20)"},
{0x1002, 0xAB28, 0xFFFF, 0xFFFF, "Navi 21/23 HDMI/DP Audio Controller(0xAB28)"},
{0x1002, 0xAB30, 0xFFFF, 0xFFFF, "Navi 31 HDMI/DP Audio(0xAB30)"},
{0x1002, 0xAB38, 0xFFFF, 0xFFFF, "Navi 10 HDMI Audio(0xAB38)"},
{0x1002, 0xAB40, 0xFFFF, 0xFFFF, "Navi 48 HDMI/DP Audio Controller(0xAB40)"},
{0x1002, 0xAC00, 0xFFFF, 0xFFFF, "Theater 506 World-Wide Analog Decoder(0xAC00)"},
{0x1002, 0xAC01, 0xFFFF, 0xFFFF, "Theater 506 World-Wide Analog Decoder(0xAC01)"},
{0x1002, 0xAC02, 0xFFFF, 0xFFFF, "TV Wonder HD 600 PCIe(0xAC02)"},
{0x1002, 0xAC03, 0xFFFF, 0xFFFF, "Theater 506 PCIe(0xAC03)"},
{0x1002, 0xAC04, 0xFFFF, 0xFFFF, "Theater 506 USB(0xAC04)"},
{0x1002, 0xAC05, 0xFFFF, 0xFFFF, "Theater 506 USB(0xAC05)"},
{0x1002, 0xAC06, 0xFFFF, 0xFFFF, "Theater 506 External USB(0xAC06)"},
{0x1002, 0xAC07, 0xFFFF, 0xFFFF, "Theater 506 External USB(0xAC07)"},
{0x1002, 0xAC08, 0xFFFF, 0xFFFF, "Theater 506A World-Wide Analog Decoder + Demodulator(0xAC08)"},
{0x1002, 0xAC09, 0xFFFF, 0xFFFF, "Theater 506A World-Wide Analog Decoder + Demodulator(0xAC09)"},
{0x1002, 0xAC0A, 0xFFFF, 0xFFFF, "Theater 506A PCIe(0xAC0A)"},
{0x1002, 0xAC0B, 0xFFFF, 0xFFFF, "Theater 506A PCIe(0xAC0B)"},
{0x1002, 0xAC0C, 0xFFFF, 0xFFFF, "Theater 506A USB(0xAC0C)"},
{0x1002, 0xAC0D, 0xFFFF, 0xFFFF, "Theater 506A USB(0xAC0D)"},
{0x1002, 0xAC0E, 0xFFFF, 0xFFFF, "Theater 506A External USB(0xAC0E)"},
{0x1002, 0xAC0F, 0xFFFF, 0xFFFF, "Theater 506A External USB(0xAC0F)"},
{0x1002, 0xAC12, 0xFFFF, 0xFFFF, "Theater HD T507 (DVB-T) TV tuner/capture device(0xAC12)"},
{0x1002, 0xCAB0, 0xFFFF, 0xFFFF, "RS100 Host Bridge(0xCAB0)"},
{0x1002, 0xCAB2, 0xFFFF, 0xFFFF, "RS200 Host Bridge(0xCAB2)"},
{0x1002, 0xCAB3, 0xFFFF, 0xFFFF, "RS250 Host Bridge(0xCAB3)"},
{0x1002, 0xCBB2, 0xFFFF, 0xFFFF, "RS200 Host Bridge(0xCBB2)"},
}; /* pci_vid_1002[] */

static pci_id_t const pci_vid_1003[] = {
{0x1003, 0xFFFF, 0xFFFF, 0xFFFF, "ULSI Systems(0x1003)"},
{0x1003, 0x0201, 0xFFFF, 0xFFFF, "US201(0x0201)"},
}; /* pci_vid_1003[] */

static pci_id_t const pci_vid_1004[] = {
{0x1004, 0xFFFF, 0xFFFF, 0xFFFF, "VLSI Technology Inc(0x1004)"},
{0x1004, 0x0005, 0xFFFF, 0xFFFF, "82C592-FC1(0x0005)"},
{0x1004, 0x0006, 0xFFFF, 0xFFFF, "82C593-FC1(0x0006)"},
{0x1004, 0x0007, 0xFFFF, 0xFFFF, "82C594-AFC2(0x0007)"},
{0x1004, 0x0008, 0xFFFF, 0xFFFF, "82C596/7 [Wildcat](0x0008)"},
{0x1004, 0x0009, 0xFFFF, 0xFFFF, "82C597-AFC2(0x0009)"},
{0x1004, 0x000C, 0xFFFF, 0xFFFF, "82C541 [Lynx](0x000C)"},
{0x1004, 0x000D, 0xFFFF, 0xFFFF, "82C543 [Lynx](0x000D)"},
{0x1004, 0x0101, 0xFFFF, 0xFFFF, "82C532(0x0101)"},
{0x1004, 0x0102, 0xFFFF, 0xFFFF, "82C534 [Eagle](0x0102)"},
{0x1004, 0x0103, 0xFFFF, 0xFFFF, "82C538(0x0103)"},
{0x1004, 0x0104, 0xFFFF, 0xFFFF, "82C535(0x0104)"},
{0x1004, 0x0105, 0xFFFF, 0xFFFF, "82C147(0x0105)"},
{0x1004, 0x0200, 0xFFFF, 0xFFFF, "82C975(0x0200)"},
{0x1004, 0x0280, 0xFFFF, 0xFFFF, "82C925(0x0280)"},
{0x1004, 0x0304, 0xFFFF, 0xFFFF, "QSound ThunderBird PCI Audio(0x0304)"},
{0x1004, 0x0304, 0x1004, 0x0304, "QSound ThunderBird PCI Audio(0x1004-0x0304)"},
{0x1004, 0x0304, 0x122D, 0x1206, "DSP368 Audio(0x122D-0x1206)"},
{0x1004, 0x0304, 0x1483, 0x5020, "XWave Thunder 3D Audio(0x1483-0x5020)"},
{0x1004, 0x0305, 0xFFFF, 0xFFFF, "QSound ThunderBird PCI Audio Gameport(0x0305)"},
{0x1004, 0x0305, 0x1004, 0x0305, "QSound ThunderBird PCI Audio Gameport(0x1004-0x0305)"},
{0x1004, 0x0305, 0x122D, 0x1207, "DSP368 Audio Gameport(0x122D-0x1207)"},
{0x1004, 0x0305, 0x1483, 0x5021, "XWave Thunder 3D Audio Gameport(0x1483-0x5021)"},
{0x1004, 0x0306, 0xFFFF, 0xFFFF, "QSound ThunderBird PCI Audio Support Registers(0x0306)"},
{0x1004, 0x0306, 0x1004, 0x0306, "QSound ThunderBird PCI Audio Support Registers(0x1004-0x0306)"},
{0x1004, 0x0306, 0x122D, 0x1208, "DSP368 Audio Support Registers(0x122D-0x1208)"},
{0x1004, 0x0306, 0x1483, 0x5022, "XWave Thunder 3D Audio Support Registers(0x1483-0x5022)"},
{0x1004, 0x0307, 0xFFFF, 0xFFFF, "SAA7785 ThunderBird PCI Audio(0x0307)"},
{0x1004, 0x0307, 0x1004, 0x0703, "Philips Rhythmic Edge PSC703(0x1004-0x0703)"},
{0x1004, 0x0307, 0x1004, 0x0705, "Philips Seismic Edge PSC705(0x1004-0x0705)"},
{0x1004, 0x0307, 0x1004, 0x0706, "Philips Acoustic Edge PSC706(0x1004-0x0706)"},
{0x1004, 0x0308, 0xFFFF, 0xFFFF, "SAA7785 ThunderBird PCI Audio Gameport(0x0308)"},
{0x1004, 0x0702, 0xFFFF, 0xFFFF, "VAS96011 [Golden Gate II](0x0702)"},
{0x1004, 0x0703, 0xFFFF, 0xFFFF, "Tollgate(0x0703)"},
}; /* pci_vid_1004[] */

static pci_id_t const pci_vid_1005[] = {
{0x1005, 0xFFFF, 0xFFFF, 0xFFFF, "Avance Logic Inc. [ALI](0x1005)"},
{0x1005, 0x2064, 0xFFFF, 0xFFFF, "ALG2032/2064(0x2064)"},
{0x1005, 0x2128, 0xFFFF, 0xFFFF, "ALG2364A(0x2128)"},
{0x1005, 0x2301, 0xFFFF, 0xFFFF, "ALG2301(0x2301)"},
{0x1005, 0x2302, 0xFFFF, 0xFFFF, "ALG2302(0x2302)"},
{0x1005, 0x2364, 0xFFFF, 0xFFFF, "ALG2364(0x2364)"},
{0x1005, 0x2464, 0xFFFF, 0xFFFF, "ALG2364A(0x2464)"},
{0x1005, 0x2501, 0xFFFF, 0xFFFF, "ALG2564A/25128A(0x2501)"},
}; /* pci_vid_1005[] */

static pci_id_t const pci_vid_1006[] = {
{0x1006, 0xFFFF, 0xFFFF, 0xFFFF, "Reply Group(0x1006)"},
}; /* pci_vid_1006[] */

static pci_id_t const pci_vid_1007[] = {
{0x1007, 0xFFFF, 0xFFFF, 0xFFFF, "NetFrame Systems Inc(0x1007)"},
}; /* pci_vid_1007[] */

static pci_id_t const pci_vid_1008[] = {
{0x1008, 0xFFFF, 0xFFFF, 0xFFFF, "Epson(0x1008)"},
}; /* pci_vid_1008[] */

static pci_id_t const pci_vid_100A[] = {
{0x100A, 0xFFFF, 0xFFFF, 0xFFFF, "Phoenix Technologies(0x100A)"},
}; /* pci_vid_100A[] */

static pci_id_t const pci_vid_100B[] = {
{0x100B, 0xFFFF, 0xFFFF, 0xFFFF, "National Semiconductor Corporation(0x100B)"},
{0x100B, 0x0001, 0xFFFF, 0xFFFF, "DP83810(0x0001)"},
{0x100B, 0x0002, 0xFFFF, 0xFFFF, "87415/87560 IDE(0x0002)"},
{0x100B, 0x000E, 0xFFFF, 0xFFFF, "87560 Legacy I/O(0x000E)"},
{0x100B, 0x000F, 0xFFFF, 0xFFFF, "FireWire Controller(0x000F)"},
{0x100B, 0x0011, 0xFFFF, 0xFFFF, "NS87560 National PCI System I/O(0x0011)"},
{0x100B, 0x0012, 0xFFFF, 0xFFFF, "USB Controller(0x0012)"},
{0x100B, 0x0020, 0xFFFF, 0xFFFF, "DP83815 (MacPhyter) Ethernet Controller(0x0020)"},
{0x100B, 0x0020, 0x103C, 0x0024, "Pavilion ze4400 builtin Network(0x103C-0x0024)"},
{0x100B, 0x0020, 0x12D9, 0x000C, "Aculab E1/T1 PMXc cPCI carrier card(0x12D9-0x000C)"},
{0x100B, 0x0020, 0x1385, 0xF311, "FA311 / FA312 (FA311 with WoL HW)(0x1385-0xF311)"},
{0x100B, 0x0020, 0x1385, 0xF312, "FA312 (rev. A1) Fast Ethernet PCI Adapter(0x1385-0xF312)"},
{0x100B, 0x0021, 0xFFFF, 0xFFFF, "PC87200 PCI to ISA Bridge(0x0021)"},
{0x100B, 0x0022, 0xFFFF, 0xFFFF, "DP83820 10/100/1000 Ethernet Controller(0x0022)"},
{0x100B, 0x0022, 0x1186, 0x4900, "DGE-500T(0x1186-0x4900)"},
{0x100B, 0x0022, 0x1385, 0x621A, "GA621(0x1385-0x621A)"},
{0x100B, 0x0022, 0x1385, 0x622A, "GA622T(0x1385-0x622A)"},
{0x100B, 0x0028, 0xFFFF, 0xFFFF, "Geode GX2 Host Bridge(0x0028)"},
{0x100B, 0x002A, 0xFFFF, 0xFFFF, "CS5535 South Bridge(0x002A)"},
{0x100B, 0x002B, 0xFFFF, 0xFFFF, "CS5535 ISA bridge(0x002B)"},
{0x100B, 0x002D, 0xFFFF, 0xFFFF, "CS5535 IDE(0x002D)"},
{0x100B, 0x002E, 0xFFFF, 0xFFFF, "CS5535 Audio(0x002E)"},
{0x100B, 0x002F, 0xFFFF, 0xFFFF, "CS5535 USB(0x002F)"},
{0x100B, 0x0030, 0xFFFF, 0xFFFF, "Geode GX2 Graphics Processor(0x0030)"},
{0x100B, 0x0035, 0xFFFF, 0xFFFF, "DP83065 [Saturn] 10/100/1000 Ethernet Controller(0x0035)"},
{0x100B, 0x0500, 0xFFFF, 0xFFFF, "SCx200 Bridge(0x0500)"},
{0x100B, 0x0501, 0xFFFF, 0xFFFF, "SCx200 SMI(0x0501)"},
{0x100B, 0x0502, 0xFFFF, 0xFFFF, "SCx200, SC1100 IDE controller(0x0502)"},
{0x100B, 0x0502, 0x100B, 0x0502, "IDE Controller(0x100B-0x0502)"},
{0x100B, 0x0503, 0xFFFF, 0xFFFF, "SCx200, SC1100 Audio Controller(0x0503)"},
{0x100B, 0x0503, 0x100B, 0x0503, "XpressAudio controller(0x100B-0x0503)"},
{0x100B, 0x0504, 0xFFFF, 0xFFFF, "SCx200 Video(0x0504)"},
{0x100B, 0x0505, 0xFFFF, 0xFFFF, "SCx200 XBus(0x0505)"},
{0x100B, 0x0510, 0xFFFF, 0xFFFF, "SC1100 Bridge(0x0510)"},
{0x100B, 0x0510, 0x100B, 0x0500, "GPIO and LPC support bridge(0x100B-0x0500)"},
{0x100B, 0x0511, 0xFFFF, 0xFFFF, "SC1100 SMI & ACPI(0x0511)"},
{0x100B, 0x0511, 0x100B, 0x0501, "SC1100 SMI & ACPI bridge(0x100B-0x0501)"},
{0x100B, 0x0515, 0xFFFF, 0xFFFF, "SC1100 XBus(0x0515)"},
{0x100B, 0x0515, 0x100B, 0x0505, "SC1100 PCI to XBus bridge(0x100B-0x0505)"},
{0x100B, 0xD001, 0xFFFF, 0xFFFF, "87410 IDE(0xD001)"},
}; /* pci_vid_100B[] */

static pci_id_t const pci_vid_100C[] = {
{0x100C, 0xFFFF, 0xFFFF, 0xFFFF, "Tseng Labs Inc(0x100C)"},
{0x100C, 0x3202, 0xFFFF, 0xFFFF, "ET4000/W32p rev A(0x3202)"},
{0x100C, 0x3205, 0xFFFF, 0xFFFF, "ET4000/W32p rev B(0x3205)"},
{0x100C, 0x3206, 0xFFFF, 0xFFFF, "ET4000/W32p rev C(0x3206)"},
{0x100C, 0x3207, 0xFFFF, 0xFFFF, "ET4000/W32p rev D(0x3207)"},
{0x100C, 0x3208, 0xFFFF, 0xFFFF, "ET6000(0x3208)"},
{0x100C, 0x4702, 0xFFFF, 0xFFFF, "ET6300(0x4702)"},
}; /* pci_vid_100C[] */

static pci_id_t const pci_vid_100D[] = {
{0x100D, 0xFFFF, 0xFFFF, 0xFFFF, "AST Research Inc(0x100D)"},
}; /* pci_vid_100D[] */

static pci_id_t const pci_vid_100E[] = {
{0x100E, 0xFFFF, 0xFFFF, 0xFFFF, "Weitek(0x100E)"},
{0x100E, 0x9000, 0xFFFF, 0xFFFF, "P9000 Viper(0x9000)"},
{0x100E, 0x9001, 0xFFFF, 0xFFFF, "P9000 Viper(0x9001)"},
{0x100E, 0x9002, 0xFFFF, 0xFFFF, "P9000 Viper(0x9002)"},
{0x100E, 0x9100, 0xFFFF, 0xFFFF, "P9100 Viper Pro/SE(0x9100)"},
}; /* pci_vid_100E[] */

static pci_id_t const pci_vid_1010[] = {
{0x1010, 0xFFFF, 0xFFFF, 0xFFFF, "Video Logic, Ltd.(0x1010)"},
}; /* pci_vid_1010[] */

static pci_id_t const pci_vid_1011[] = {
{0x1011, 0xFFFF, 0xFFFF, 0xFFFF, "Digital Equipment Corporation(0x1011)"},
{0x1011, 0x0001, 0xFFFF, 0xFFFF, "DECchip 21050(0x0001)"},
{0x1011, 0x0002, 0xFFFF, 0xFFFF, "DECchip 21040 [Tulip](0x0002)"},
{0x1011, 0x0004, 0xFFFF, 0xFFFF, "DECchip 21030 [TGA](0x0004)"},
{0x1011, 0x0007, 0xFFFF, 0xFFFF, "NVRAM [Zephyr NVRAM](0x0007)"},
{0x1011, 0x0008, 0xFFFF, 0xFFFF, "KZPSA [KZPSA](0x0008)"},
{0x1011, 0x0009, 0xFFFF, 0xFFFF, "DECchip 21140 [FasterNet](0x0009)"},
{0x1011, 0x0009, 0x1025, 0x0310, "21140 Fast Ethernet(0x1025-0x0310)"},
{0x1011, 0x0009, 0x10B8, 0x2001, "SMC9332BDT EtherPower 10/100(0x10B8-0x2001)"},
{0x1011, 0x0009, 0x10B8, 0x2002, "SMC9332BVT EtherPower T4 10/100(0x10B8-0x2002)"},
{0x1011, 0x0009, 0x10B8, 0x2003, "SMC9334BDT EtherPower 10/100 (1-port)(0x10B8-0x2003)"},
{0x1011, 0x0009, 0x1109, 0x2400, "ANA-6944A/TX Fast Ethernet(0x1109-0x2400)"},
{0x1011, 0x0009, 0x1112, 0x2300, "RNS2300 Fast Ethernet(0x1112-0x2300)"},
{0x1011, 0x0009, 0x1112, 0x2320, "RNS2320 Fast Ethernet(0x1112-0x2320)"},
{0x1011, 0x0009, 0x1112, 0x2340, "RNS2340 Fast Ethernet(0x1112-0x2340)"},
{0x1011, 0x0009, 0x1113, 0x1207, "EN-1207-TX Fast Ethernet(0x1113-0x1207)"},
{0x1011, 0x0009, 0x1186, 0x1100, "DFE-500TX Fast Ethernet(0x1186-0x1100)"},
{0x1011, 0x0009, 0x1186, 0x1112, "DFE-570TX Fast Ethernet(0x1186-0x1112)"},
{0x1011, 0x0009, 0x1186, 0x1140, "DFE-660 Cardbus Ethernet 10/100(0x1186-0x1140)"},
{0x1011, 0x0009, 0x1186, 0x1142, "DFE-660 Cardbus Ethernet 10/100(0x1186-0x1142)"},
{0x1011, 0x0009, 0x11F6, 0x0503, "Freedomline Fast Ethernet(0x11F6-0x0503)"},
{0x1011, 0x0009, 0x1282, 0x9100, "AEF-380TXD Fast Ethernet(0x1282-0x9100)"},
{0x1011, 0x0009, 0x1385, 0x1100, "FA310TX Fast Ethernet(0x1385-0x1100)"},
{0x1011, 0x0009, 0x2646, 0x0001, "KNE100TX Fast Ethernet(0x2646-0x0001)"},
{0x1011, 0x000A, 0xFFFF, 0xFFFF, "21230 Video Codec(0x000A)"},
{0x1011, 0x000D, 0xFFFF, 0xFFFF, "PBXGB [TGA2](0x000D)"},
{0x1011, 0x000F, 0xFFFF, 0xFFFF, "PCI-to-PDQ Interface Chip [PFI] FDDI (DEFPA)(0x000F)"},
{0x1011, 0x000F, 0x1011, 0xDEF1, "FDDIcontroller/PCI (DEFPA)(0x1011-0xDEF1)"},
{0x1011, 0x000F, 0x103C, 0xDEF1, "FDDIcontroller/PCI (3X-DEFPA)(0x103C-0xDEF1)"},
{0x1011, 0x0014, 0xFFFF, 0xFFFF, "DECchip 21041 [Tulip Pass 3](0x0014)"},
{0x1011, 0x0014, 0x1186, 0x0100, "DE-530+(0x1186-0x0100)"},
{0x1011, 0x0016, 0xFFFF, 0xFFFF, "ATMworks 350 Adapter [OPPO] (DGLPB)(0x0016)"},
{0x1011, 0x0017, 0xFFFF, 0xFFFF, "PV-PCI Graphics Controller (ZLXp-L)(0x0017)"},
{0x1011, 0x0018, 0xFFFF, 0xFFFF, "Memory Channel interface(0x0018)"},
{0x1011, 0x0019, 0xFFFF, 0xFFFF, "DECchip 21142/43(0x0019)"},
{0x1011, 0x0019, 0x1011, 0x500A, "DE500A Fast Ethernet(0x1011-0x500A)"},
{0x1011, 0x0019, 0x1011, 0x500B, "DE500B Fast Ethernet(0x1011-0x500B)"},
{0x1011, 0x0019, 0x1014, 0x0001, "10/100 EtherJet Cardbus(0x1014-0x0001)"},
{0x1011, 0x0019, 0x1025, 0x0315, "ALN315 Fast Ethernet(0x1025-0x0315)"},
{0x1011, 0x0019, 0x1033, 0x800C, "PC-9821-CS01 100BASE-TX Interface Card(0x1033-0x800C)"},
{0x1011, 0x0019, 0x1033, 0x800D, "PC-9821NR-B06 100BASE-TX Interface Card(0x1033-0x800D)"},
{0x1011, 0x0019, 0x103C, 0x125A, "10/100Base-TX (PCI) [A5506B](0x103C-0x125A)"},
{0x1011, 0x0019, 0x108D, 0x0016, "Rapidfire 2327 10/100 Ethernet(0x108D-0x0016)"},
{0x1011, 0x0019, 0x108D, 0x0017, "GoCard 2250 Ethernet 10/100 Cardbus(0x108D-0x0017)"},
{0x1011, 0x0019, 0x10B8, 0x2005, "SMC8032DT Extreme Ethernet 10/100(0x10B8-0x2005)"},
{0x1011, 0x0019, 0x10B8, 0x8034, "SMC8034 Extreme Ethernet 10/100(0x10B8-0x8034)"},
{0x1011, 0x0019, 0x10EF, 0x8169, "Cardbus Fast Ethernet(0x10EF-0x8169)"},
{0x1011, 0x0019, 0x1109, 0x2A00, "ANA-6911A/TX Fast Ethernet(0x1109-0x2A00)"},
{0x1011, 0x0019, 0x1109, 0x2B00, "ANA-6911A/TXC Fast Ethernet(0x1109-0x2B00)"},
{0x1011, 0x0019, 0x1109, 0x3000, "ANA-6922/TX Fast Ethernet(0x1109-0x3000)"},
{0x1011, 0x0019, 0x1113, 0x1207, "Cheetah Fast Ethernet(0x1113-0x1207)"},
{0x1011, 0x0019, 0x1113, 0x2220, "Cardbus Fast Ethernet(0x1113-0x2220)"},
{0x1011, 0x0019, 0x115D, 0x0002, "Cardbus Ethernet 10/100(0x115D-0x0002)"},
{0x1011, 0x0019, 0x1179, 0x0203, "Fast Ethernet(0x1179-0x0203)"},
{0x1011, 0x0019, 0x1179, 0x0204, "Cardbus Fast Ethernet(0x1179-0x0204)"},
{0x1011, 0x0019, 0x1186, 0x1100, "DFE-500TX Fast Ethernet(0x1186-0x1100)"},
{0x1011, 0x0019, 0x1186, 0x1101, "DFE-500TX Fast Ethernet(0x1186-0x1101)"},
{0x1011, 0x0019, 0x1186, 0x1102, "DFE-500TX Fast Ethernet(0x1186-0x1102)"},
{0x1011, 0x0019, 0x1186, 0x1112, "DFE-570TX Quad Fast Ethernet(0x1186-0x1112)"},
{0x1011, 0x0019, 0x11F0, 0x4235, "21143 [FASTLine-II UTP 10/100](0x11F0-0x4235)"},
{0x1011, 0x0019, 0x1259, 0x2800, "AT-2800Tx Fast Ethernet(0x1259-0x2800)"},
{0x1011, 0x0019, 0x1266, 0x0004, "Eagle Fast EtherMAX(0x1266-0x0004)"},
{0x1011, 0x0019, 0x12AF, 0x0019, "NetFlyer Cardbus Fast Ethernet(0x12AF-0x0019)"},
{0x1011, 0x0019, 0x1374, 0x0001, "Cardbus Ethernet Card 10/100(0x1374-0x0001)"},
{0x1011, 0x0019, 0x1374, 0x0002, "Cardbus Ethernet Card 10/100(0x1374-0x0002)"},
{0x1011, 0x0019, 0x1374, 0x0007, "Cardbus Ethernet Card 10/100(0x1374-0x0007)"},
{0x1011, 0x0019, 0x1374, 0x0008, "Cardbus Ethernet Card 10/100(0x1374-0x0008)"},
{0x1011, 0x0019, 0x1385, 0x2100, "FA510(0x1385-0x2100)"},
{0x1011, 0x0019, 0x1395, 0x0001, "10/100 Ethernet CardBus PC Card(0x1395-0x0001)"},
{0x1011, 0x0019, 0x13D1, 0xAB01, "EtherFast 10/100 Cardbus (PCMPC200)(0x13D1-0xAB01)"},
{0x1011, 0x0019, 0x1498, 0x000A, "TPMC880-10 10/100Base-T and 10Base2 PMC Ethernet Adapter(0x1498-0x000A)"},
{0x1011, 0x0019, 0x1498, 0x000B, "TPMC880-11 Single 10/100Base-T PMC Ethernet Adapter(0x1498-0x000B)"},
{0x1011, 0x0019, 0x1498, 0x000C, "TPMC880-12 Single 10Base2 PMC Ethernet Adapter(0x1498-0x000C)"},
{0x1011, 0x0019, 0x14CB, 0x0100, "LNDL-100N 100Base-TX Ethernet PC Card(0x14CB-0x0100)"},
{0x1011, 0x0019, 0x1668, 0x2000, "FastNet Pro (PE2000)(0x1668-0x2000)"},
{0x1011, 0x0019, 0x2646, 0x0001, "KNE100TX(0x2646-0x0001)"},
{0x1011, 0x0019, 0x2646, 0x0002, "KNE-CB4TX(0x2646-0x0002)"},
{0x1011, 0x0019, 0x8086, 0x0001, "EtherExpress PRO/100 Mobile CardBus 32(0x8086-0x0001)"},
{0x1011, 0x001A, 0xFFFF, 0xFFFF, "Farallon PN9000SX Gigabit Ethernet(0x001A)"},
{0x1011, 0x0021, 0xFFFF, 0xFFFF, "DECchip 21052(0x0021)"},
{0x1011, 0x0022, 0xFFFF, 0xFFFF, "DECchip 21150(0x0022)"},
{0x1011, 0x0023, 0xFFFF, 0xFFFF, "DECchip 21150(0x0023)"},
{0x1011, 0x0024, 0xFFFF, 0xFFFF, "DECchip 21152(0x0024)"},
{0x1011, 0x0025, 0xFFFF, 0xFFFF, "DECchip 21153(0x0025)"},
{0x1011, 0x0026, 0xFFFF, 0xFFFF, "DECchip 21154(0x0026)"},
{0x1011, 0x0034, 0xFFFF, 0xFFFF, "56k Modem Cardbus(0x0034)"},
{0x1011, 0x0034, 0x1374, 0x0003, "56k Modem Cardbus(0x1374-0x0003)"},
{0x1011, 0x0045, 0xFFFF, 0xFFFF, "DECchip 21553(0x0045)"},
{0x1011, 0x0046, 0xFFFF, 0xFFFF, "DECchip 21554(0x0046)"},
{0x1011, 0x0046, 0x0E11, 0x4050, "Smart Array 4200 Controller(0x0E11-0x4050)"},
{0x1011, 0x0046, 0x0E11, 0x4051, "Smart Array 4250ES Controller(0x0E11-0x4051)"},
{0x1011, 0x0046, 0x0E11, 0x4058, "Smart Array 431 Controller(0x0E11-0x4058)"},
{0x1011, 0x0046, 0x103C, 0x10C2, "NetRAID-4M(0x103C-0x10C2)"},
{0x1011, 0x0046, 0x12D9, 0x000A, "IP Telephony card(0x12D9-0x000A)"},
{0x1011, 0x0046, 0x4C53, 0x1050, "CT7 mainboard(0x4C53-0x1050)"},
{0x1011, 0x0046, 0x4C53, 0x1051, "CE7 mainboard(0x4C53-0x1051)"},
{0x1011, 0x0046, 0x9005, 0x0364, "5400S (Mustang)(0x9005-0x0364)"},
{0x1011, 0x0046, 0x9005, 0x0365, "5400S (Mustang)(0x9005-0x0365)"},
{0x1011, 0x0046, 0x9005, 0x1364, "Dell PowerEdge RAID Controller 2(0x9005-0x1364)"},
{0x1011, 0x0046, 0x9005, 0x1365, "Dell PowerEdge RAID Controller 2(0x9005-0x1365)"},
{0x1011, 0x0046, 0xE4BF, 0x1000, "CC8-1-BLUES(0xE4BF-0x1000)"},
{0x1011, 0x1065, 0xFFFF, 0xFFFF, "StrongARM DC21285(0x1065)"},
{0x1011, 0x1065, 0x1069, 0x0020, "DAC960P / DAC1164P(0x1069-0x0020)"},
}; /* pci_vid_1011[] */

static pci_id_t const pci_vid_1012[] = {
{0x1012, 0xFFFF, 0xFFFF, 0xFFFF, "Micronics Computers Inc(0x1012)"},
}; /* pci_vid_1012[] */

static pci_id_t const pci_vid_1013[] = {
{0x1013, 0xFFFF, 0xFFFF, 0xFFFF, "Cirrus Logic(0x1013)"},
{0x1013, 0x0038, 0xFFFF, 0xFFFF, "GD 7548(0x0038)"},
{0x1013, 0x0040, 0xFFFF, 0xFFFF, "GD 7555 Flat Panel GUI Accelerator(0x0040)"},
{0x1013, 0x004C, 0xFFFF, 0xFFFF, "GD 7556 Video/Graphics LCD/CRT Ctrlr(0x004C)"},
{0x1013, 0x00A0, 0xFFFF, 0xFFFF, "GD 5430/40 [Alpine](0x00A0)"},
{0x1013, 0x00A2, 0xFFFF, 0xFFFF, "GD 5432 [Alpine](0x00A2)"},
{0x1013, 0x00A4, 0xFFFF, 0xFFFF, "GD 5434-4 [Alpine](0x00A4)"},
{0x1013, 0x00A8, 0xFFFF, 0xFFFF, "GD 5434-8 [Alpine](0x00A8)"},
{0x1013, 0x00AC, 0xFFFF, 0xFFFF, "GD 5436 [Alpine](0x00AC)"},
{0x1013, 0x00B0, 0xFFFF, 0xFFFF, "GD 5440(0x00B0)"},
{0x1013, 0x00B8, 0xFFFF, 0xFFFF, "GD 5446(0x00B8)"},
{0x1013, 0x00B8, 0x1AF4, 0x1100, "QEMU Virtual Machine(0x1AF4-0x1100)"},
{0x1013, 0x00BC, 0xFFFF, 0xFFFF, "GD 5480(0x00BC)"},
{0x1013, 0x00BC, 0x1013, 0x00BC, "CL-GD5480(0x1013-0x00BC)"},
{0x1013, 0x00D0, 0xFFFF, 0xFFFF, "GD 5462(0x00D0)"},
{0x1013, 0x00D2, 0xFFFF, 0xFFFF, "GD 5462 [Laguna I](0x00D2)"},
{0x1013, 0x00D4, 0xFFFF, 0xFFFF, "GD 5464 [Laguna](0x00D4)"},
{0x1013, 0x00D5, 0xFFFF, 0xFFFF, "GD 5464 BD [Laguna](0x00D5)"},
{0x1013, 0x00D6, 0xFFFF, 0xFFFF, "GD 5465 [Laguna](0x00D6)"},
{0x1013, 0x00D6, 0x13CE, 0x8031, "Barco Metheus 2 Megapixel, Dual Head(0x13CE-0x8031)"},
{0x1013, 0x00D6, 0x13CF, 0x8031, "Barco Metheus 2 Megapixel, Dual Head(0x13CF-0x8031)"},
{0x1013, 0x00E8, 0xFFFF, 0xFFFF, "GD 5436U(0x00E8)"},
{0x1013, 0x1100, 0xFFFF, 0xFFFF, "CL 6729(0x1100)"},
{0x1013, 0x1110, 0xFFFF, 0xFFFF, "PD 6832 PCMCIA/CardBus Ctrlr(0x1110)"},
{0x1013, 0x1112, 0xFFFF, 0xFFFF, "PD 6834 PCMCIA/CardBus Ctrlr(0x1112)"},
{0x1013, 0x1113, 0xFFFF, 0xFFFF, "PD 6833 PCMCIA/CardBus Ctrlr(0x1113)"},
{0x1013, 0x1200, 0xFFFF, 0xFFFF, "GD 7542 [Nordic](0x1200)"},
{0x1013, 0x1202, 0xFFFF, 0xFFFF, "GD 7543 [Viking](0x1202)"},
{0x1013, 0x1204, 0xFFFF, 0xFFFF, "GD 7541 [Nordic Light](0x1204)"},
{0x1013, 0x4000, 0xFFFF, 0xFFFF, "MD 5620 [CLM Data Fax Voice](0x4000)"},
{0x1013, 0x4400, 0xFFFF, 0xFFFF, "CD 4400(0x4400)"},
{0x1013, 0x6001, 0xFFFF, 0xFFFF, "CS 4610/11 [CrystalClear SoundFusion Audio Accelerator](0x6001)"},
{0x1013, 0x6001, 0x1014, 0x1010, "CS4610 SoundFusion Audio Accelerator(0x1014-0x1010)"},
{0x1013, 0x6003, 0xFFFF, 0xFFFF, "CS 4614/22/24/30 [CrystalClear SoundFusion Audio Accelerator](0x6003)"},
{0x1013, 0x6003, 0x1013, 0x4280, "Crystal SoundFusion PCI Audio Accelerator(0x1013-0x4280)"},
{0x1013, 0x6003, 0x1014, 0x0153, "ThinkPad 600X/A20m(0x1014-0x0153)"},
{0x1013, 0x6003, 0x153B, 0x112E, "DMX XFire 1024(0x153B-0x112E)"},
{0x1013, 0x6003, 0x153B, 0x1136, "SiXPack 5.1+(0x153B-0x1136)"},
{0x1013, 0x6003, 0x1681, 0x0050, "Game Theater XP(0x1681-0x0050)"},
{0x1013, 0x6003, 0x1681, 0xA010, "Gamesurround Fortissimo II(0x1681-0xA010)"},
{0x1013, 0x6003, 0x1681, 0xA011, "Gamesurround Fortissimo III 7.1(0x1681-0xA011)"},
{0x1013, 0x6003, 0x5053, 0x3357, "Santa Cruz(0x5053-0x3357)"},
{0x1013, 0x6004, 0xFFFF, 0xFFFF, "CS 4614/22/24 [CrystalClear SoundFusion Audio Accelerator](0x6004)"},
{0x1013, 0x6005, 0xFFFF, 0xFFFF, "Crystal CS4281 PCI Audio(0x6005)"},
{0x1013, 0x6005, 0x1013, 0x4281, "Crystal CS4281 PCI Audio(0x1013-0x4281)"},
{0x1013, 0x6005, 0x10CF, 0x10A8, "Crystal CS4281 PCI Audio(0x10CF-0x10A8)"},
{0x1013, 0x6005, 0x10CF, 0x10A9, "Crystal CS4281 PCI Audio(0x10CF-0x10A9)"},
{0x1013, 0x6005, 0x10CF, 0x10AA, "Crystal CS4281 PCI Audio(0x10CF-0x10AA)"},
{0x1013, 0x6005, 0x10CF, 0x10AB, "Crystal CS4281 PCI Audio(0x10CF-0x10AB)"},
{0x1013, 0x6005, 0x10CF, 0x10AC, "Crystal CS4281 PCI Audio(0x10CF-0x10AC)"},
{0x1013, 0x6005, 0x10CF, 0x10AD, "Crystal CS4281 PCI Audio(0x10CF-0x10AD)"},
{0x1013, 0x6005, 0x10CF, 0x10B4, "Crystal CS4281 PCI Audio(0x10CF-0x10B4)"},
{0x1013, 0x6005, 0x1179, 0x0001, "Crystal CS4281 PCI Audio(0x1179-0x0001)"},
{0x1013, 0x6005, 0x14C0, 0x000C, "Crystal CS4281 PCI Audio(0x14C0-0x000C)"},
}; /* pci_vid_1013[] */

static pci_id_t const pci_vid_1014[] = {
{0x1014, 0xFFFF, 0xFFFF, 0xFFFF, "IBM(0x1014)"},
{0x1014, 0x0002, 0xFFFF, 0xFFFF, "PCI to MCA Bridge(0x0002)"},
{0x1014, 0x0005, 0xFFFF, 0xFFFF, "Processor to I/O Controller [Alta Lite](0x0005)"},
{0x1014, 0x0007, 0xFFFF, 0xFFFF, "Processor to I/O Controller [Alta MP](0x0007)"},
{0x1014, 0x000A, 0xFFFF, 0xFFFF, "PCI to ISA Bridge (IBM27-82376) [Fire Coral](0x000A)"},
{0x1014, 0x0017, 0xFFFF, 0xFFFF, "CPU to PCI Bridge(0x0017)"},
{0x1014, 0x0018, 0xFFFF, 0xFFFF, "TR Auto LANstreamer(0x0018)"},
{0x1014, 0x001B, 0xFFFF, 0xFFFF, "GXT-150P(0x001B)"},
{0x1014, 0x001C, 0xFFFF, 0xFFFF, "Carrera(0x001C)"},
{0x1014, 0x001D, 0xFFFF, 0xFFFF, "SCSI-2 FAST PCI Adapter (82G2675)(0x001D)"},
{0x1014, 0x0020, 0xFFFF, 0xFFFF, "GXT1000 Graphics Adapter(0x0020)"},
{0x1014, 0x0022, 0xFFFF, 0xFFFF, "PCI to PCI Bridge (IBM27-82351)(0x0022)"},
{0x1014, 0x002D, 0xFFFF, 0xFFFF, "Processor to I/O Controller [Python](0x002D)"},
{0x1014, 0x002E, 0xFFFF, 0xFFFF, "SCSI RAID Adapter [ServeRAID](0x002E)"},
{0x1014, 0x002E, 0x1014, 0x002E, "ServeRAID-3x(0x1014-0x002E)"},
{0x1014, 0x002E, 0x1014, 0x022E, "ServeRAID-4H(0x1014-0x022E)"},
{0x1014, 0x0031, 0xFFFF, 0xFFFF, "2 Port Serial Adapter(0x0031)"},
{0x1014, 0x0031, 0x1014, 0x0031, "2721 WAN IOA - 2 Port Sync Serial Adapter(0x1014-0x0031)"},
{0x1014, 0x0036, 0xFFFF, 0xFFFF, "PCI to 32-bit LocalBus Bridge [Miami](0x0036)"},
{0x1014, 0x0037, 0xFFFF, 0xFFFF, "PowerPC to PCI Bridge (IBM27-82660)(0x0037)"},
{0x1014, 0x003A, 0xFFFF, 0xFFFF, "CPU to PCI Bridge(0x003A)"},
{0x1014, 0x003C, 0xFFFF, 0xFFFF, "GXT250P/GXT255P Graphics Adapter(0x003C)"},
{0x1014, 0x003E, 0xFFFF, 0xFFFF, "16/4 Token ring UTP/STP controller(0x003E)"},
{0x1014, 0x003E, 0x1014, 0x003E, "Token-Ring Adapter(0x1014-0x003E)"},
{0x1014, 0x003E, 0x1014, 0x00CD, "Token-Ring Adapter + Wake-On-LAN(0x1014-0x00CD)"},
{0x1014, 0x003E, 0x1014, 0x00CE, "16/4 Token-Ring Adapter 2(0x1014-0x00CE)"},
{0x1014, 0x003E, 0x1014, 0x00CF, "16/4 Token-Ring Adapter Special(0x1014-0x00CF)"},
{0x1014, 0x003E, 0x1014, 0x00E4, "High-Speed 100/16/4 Token-Ring Adapter(0x1014-0x00E4)"},
{0x1014, 0x003E, 0x1014, 0x00E5, "16/4 Token-Ring Adapter 2 + Wake-On-LAN(0x1014-0x00E5)"},
{0x1014, 0x003E, 0x1014, 0x016D, "iSeries 2744 Card(0x1014-0x016D)"},
{0x1014, 0x0045, 0xFFFF, 0xFFFF, "SSA Adapter(0x0045)"},
{0x1014, 0x0046, 0xFFFF, 0xFFFF, "MPIC interrupt controller(0x0046)"},
{0x1014, 0x0047, 0xFFFF, 0xFFFF, "PCI to PCI Bridge(0x0047)"},
{0x1014, 0x0048, 0xFFFF, 0xFFFF, "PCI to PCI Bridge(0x0048)"},
{0x1014, 0x0049, 0xFFFF, 0xFFFF, "Warhead SCSI Controller(0x0049)"},
{0x1014, 0x004E, 0xFFFF, 0xFFFF, "ATM Controller (14104e00)(0x004E)"},
{0x1014, 0x004F, 0xFFFF, 0xFFFF, "ATM Controller (14104f00)(0x004F)"},
{0x1014, 0x0050, 0xFFFF, 0xFFFF, "ATM Controller (14105000)(0x0050)"},
{0x1014, 0x0053, 0xFFFF, 0xFFFF, "25 MBit ATM Controller(0x0053)"},
{0x1014, 0x0054, 0xFFFF, 0xFFFF, "GXT500P/GXT550P Graphics Adapter(0x0054)"},
{0x1014, 0x0057, 0xFFFF, 0xFFFF, "MPEG PCI Bridge(0x0057)"},
{0x1014, 0x0058, 0xFFFF, 0xFFFF, "SSA Adapter [Advanced SerialRAID/X](0x0058)"},
{0x1014, 0x005E, 0xFFFF, 0xFFFF, "GXT800P Graphics Adapter(0x005E)"},
{0x1014, 0x007C, 0xFFFF, 0xFFFF, "ATM Controller (14107c00)(0x007C)"},
{0x1014, 0x007D, 0xFFFF, 0xFFFF, "3780IDSP [MWave](0x007D)"},
{0x1014, 0x008B, 0xFFFF, 0xFFFF, "EADS PCI to PCI Bridge(0x008B)"},
{0x1014, 0x008E, 0xFFFF, 0xFFFF, "GXT3000P Graphics Adapter(0x008E)"},
{0x1014, 0x0090, 0xFFFF, 0xFFFF, "GXT 3000P(0x0090)"},
{0x1014, 0x0090, 0x1014, 0x008E, "GXT-3000P(0x1014-0x008E)"},
{0x1014, 0x0091, 0xFFFF, 0xFFFF, "SSA Adapter(0x0091)"},
{0x1014, 0x0095, 0xFFFF, 0xFFFF, "20H2999 PCI Docking Bridge(0x0095)"},
{0x1014, 0x0096, 0xFFFF, 0xFFFF, "Chukar chipset SCSI controller(0x0096)"},
{0x1014, 0x0096, 0x1014, 0x0097, "iSeries 2778 DASD IOA(0x1014-0x0097)"},
{0x1014, 0x0096, 0x1014, 0x0098, "iSeries 2763 DASD IOA(0x1014-0x0098)"},
{0x1014, 0x0096, 0x1014, 0x0099, "iSeries 2748 DASD IOA(0x1014-0x0099)"},
{0x1014, 0x009F, 0xFFFF, 0xFFFF, "PCI 4758 Cryptographic Accelerator(0x009F)"},
{0x1014, 0x00A5, 0xFFFF, 0xFFFF, "ATM Controller (1410a500)(0x00A5)"},
{0x1014, 0x00A6, 0xFFFF, 0xFFFF, "ATM 155MBPS MM Controller (1410a600)(0x00A6)"},
{0x1014, 0x00B7, 0xFFFF, 0xFFFF, "GXT2000P Graphics Adapter(0x00B7)"},
{0x1014, 0x00B7, 0x1092, 0x00B8, "FireGL1 AGP 32Mb(0x1092-0x00B8)"},
{0x1014, 0x00B8, 0xFFFF, 0xFFFF, "GXT2000P Graphics Adapter(0x00B8)"},
{0x1014, 0x00BE, 0xFFFF, 0xFFFF, "ATM 622MBPS Controller (1410be00)(0x00BE)"},
{0x1014, 0x00DC, 0xFFFF, 0xFFFF, "Advanced Systems Management Adapter (ASMA)(0x00DC)"},
{0x1014, 0x00FC, 0xFFFF, 0xFFFF, "CPC710 Dual Bridge and Memory Controller (PCI-64)(0x00FC)"},
{0x1014, 0x0105, 0xFFFF, 0xFFFF, "CPC710 Dual Bridge and Memory Controller (PCI-32)(0x0105)"},
{0x1014, 0x010F, 0xFFFF, 0xFFFF, "Remote Supervisor Adapter (RSA)(0x010F)"},
{0x1014, 0x0142, 0xFFFF, 0xFFFF, "Yotta Video Compositor Input(0x0142)"},
{0x1014, 0x0142, 0x1014, 0x0143, "Yotta Input Controller (ytin)(0x1014-0x0143)"},
{0x1014, 0x0144, 0xFFFF, 0xFFFF, "Yotta Video Compositor Output(0x0144)"},
{0x1014, 0x0144, 0x1014, 0x0145, "Yotta Output Controller (ytout)(0x1014-0x0145)"},
{0x1014, 0x0156, 0xFFFF, 0xFFFF, "405GP PLB to PCI Bridge(0x0156)"},
{0x1014, 0x015E, 0xFFFF, 0xFFFF, "622Mbps ATM PCI Adapter(0x015E)"},
{0x1014, 0x0160, 0xFFFF, 0xFFFF, "64bit/66MHz PCI ATM 155 MMF(0x0160)"},
{0x1014, 0x016E, 0xFFFF, 0xFFFF, "GXT4000P Graphics Adapter(0x016E)"},
{0x1014, 0x0170, 0xFFFF, 0xFFFF, "GXT6000P Graphics Adapter(0x0170)"},
{0x1014, 0x0170, 0x1092, 0x0172, "Fire GL2(0x1092-0x0172)"},
{0x1014, 0x0170, 0x1092, 0x0173, "Fire GL3(0x1092-0x0173)"},
{0x1014, 0x0170, 0x1092, 0x0174, "Fire GL4(0x1092-0x0174)"},
{0x1014, 0x0170, 0x1092, 0x0184, "Fire GL4s(0x1092-0x0184)"},
{0x1014, 0x017D, 0xFFFF, 0xFFFF, "GXT300P Graphics Adapter(0x017D)"},
{0x1014, 0x0180, 0xFFFF, 0xFFFF, "Snipe chipset SCSI controller(0x0180)"},
{0x1014, 0x0180, 0x1014, 0x0241, "iSeries 2757 DASD IOA(0x1014-0x0241)"},
{0x1014, 0x0180, 0x1014, 0x0264, "Quad Channel PCI-X U320 SCSI RAID Adapter (2780)(0x1014-0x0264)"},
{0x1014, 0x0188, 0xFFFF, 0xFFFF, "EADS-X PCI-X to PCI-X Bridge(0x0188)"},
{0x1014, 0x01A7, 0xFFFF, 0xFFFF, "PCI-X to PCI-X Bridge(0x01A7)"},
{0x1014, 0x01BD, 0xFFFF, 0xFFFF, "ServeRAID Controller(0x01BD)"},
{0x1014, 0x01BD, 0x1014, 0x01BD, "ServeRAID 4Lx(0x1014-0x01BD)"},
{0x1014, 0x01BD, 0x1014, 0x01BE, "ServeRAID-4M(0x1014-0x01BE)"},
{0x1014, 0x01BD, 0x1014, 0x01BF, "ServeRAID-4L(0x1014-0x01BF)"},
{0x1014, 0x01BD, 0x1014, 0x0208, "ServeRAID-4Mx(0x1014-0x0208)"},
{0x1014, 0x01BD, 0x1014, 0x020E, "ServeRAID-4Lx(0x1014-0x020E)"},
{0x1014, 0x01BD, 0x1014, 0x022E, "ServeRAID-4H(0x1014-0x022E)"},
{0x1014, 0x01BD, 0x1014, 0x0258, "ServeRAID-5i(0x1014-0x0258)"},
{0x1014, 0x01BD, 0x1014, 0x0259, "ServeRAID-5i(0x1014-0x0259)"},
{0x1014, 0x01C1, 0xFFFF, 0xFFFF, "64bit/66MHz PCI ATM 155 UTP(0x01C1)"},
{0x1014, 0x01E6, 0xFFFF, 0xFFFF, "Cryptographic Accelerator(0x01E6)"},
{0x1014, 0x01EF, 0xFFFF, 0xFFFF, "PowerPC 440GP PCI Bridge(0x01EF)"},
{0x1014, 0x01EF, 0x1734, 0x102B, "PCEAS PCI-X Dual Port ESCON Adapter(0x1734-0x102B)"},
{0x1014, 0x01EF, 0x1734, 0x10F8, "PCEAT PCI-Express Dual Port ESCON Adapter(0x1734-0x10F8)"},
{0x1014, 0x01FF, 0xFFFF, 0xFFFF, "10/100 Mbps Ethernet(0x01FF)"},
{0x1014, 0x0219, 0xFFFF, 0xFFFF, "Multiport Serial Adapter(0x0219)"},
{0x1014, 0x0219, 0x1014, 0x021A, "Dual RVX(0x1014-0x021A)"},
{0x1014, 0x0219, 0x1014, 0x0251, "Internal Modem/RVX(0x1014-0x0251)"},
{0x1014, 0x0219, 0x1014, 0x0252, "Quad Internal Modem(0x1014-0x0252)"},
{0x1014, 0x021B, 0xFFFF, 0xFFFF, "GXT6500P Graphics Adapter(0x021B)"},
{0x1014, 0x021C, 0xFFFF, 0xFFFF, "GXT4500P Graphics Adapter(0x021C)"},
{0x1014, 0x0233, 0xFFFF, 0xFFFF, "GXT135P Graphics Adapter(0x0233)"},
{0x1014, 0x025A, 0xFFFF, 0xFFFF, "Drone card(0x025A)"},
{0x1014, 0x028C, 0xFFFF, 0xFFFF, "Citrine chipset SCSI controller(0x028C)"},
{0x1014, 0x028C, 0x1014, 0x028D, "Dual Channel PCI-X DDR SAS RAID Adapter (572E)(0x1014-0x028D)"},
{0x1014, 0x028C, 0x1014, 0x02BE, "Dual Channel PCI-X DDR U320 SCSI RAID Adapter (571B)(0x1014-0x02BE)"},
{0x1014, 0x028C, 0x1014, 0x02C0, "Dual Channel PCI-X DDR U320 SCSI Adapter (571A)(0x1014-0x02C0)"},
{0x1014, 0x028C, 0x1014, 0x030D, "PCI-X DDR Auxiliary Cache Adapter (575B)(0x1014-0x030D)"},
{0x1014, 0x02A1, 0xFFFF, 0xFFFF, "Calgary PCI-X Host Bridge(0x02A1)"},
{0x1014, 0x02BD, 0xFFFF, 0xFFFF, "Obsidian chipset SCSI controller(0x02BD)"},
{0x1014, 0x02BD, 0x1014, 0x02C1, "PCI-X DDR 3Gb SAS Adapter (572A/572C)(0x1014-0x02C1)"},
{0x1014, 0x02BD, 0x1014, 0x02C2, "PCI-X DDR 3Gb SAS RAID Adapter (572B/571D)(0x1014-0x02C2)"},
{0x1014, 0x02BD, 0x1014, 0x0338, "PCI-X DDR Auxiliary Cache Adapter (575C)(0x1014-0x0338)"},
{0x1014, 0x0302, 0xFFFF, 0xFFFF, "Winnipeg PCI-X Host Bridge(0x0302)"},
{0x1014, 0x0308, 0xFFFF, 0xFFFF, "CalIOC2 PCI-E Root Port(0x0308)"},
{0x1014, 0x0311, 0xFFFF, 0xFFFF, "FC 5740/1954 4-Port 10/100/1000 Base-TX PCI-X Adapter for POWER(0x0311)"},
{0x1014, 0x0314, 0xFFFF, 0xFFFF, "ZISC 036 Neural accelerator card(0x0314)"},
{0x1014, 0x032D, 0xFFFF, 0xFFFF, "Axon - Cell Companion Chip(0x032D)"},
{0x1014, 0x032D, 0x1014, 0x03A1, "PCIe PowerXCell 8i Cell Accelerator Board(0x1014-0x03A1)"},
{0x1014, 0x0339, 0xFFFF, 0xFFFF, "Obsidian-E PCI-E SCSI controller(0x0339)"},
{0x1014, 0x0339, 0x1014, 0x030A, "PCIe 3Gb SAS RAID Adapter (574E)(0x1014-0x030A)"},
{0x1014, 0x0339, 0x1014, 0x033A, "PCIe 3Gb SAS Adapter (57B3)(0x1014-0x033A)"},
{0x1014, 0x0339, 0x1014, 0x035C, "PCIe x8 Internal 3Gb SAS adapter (57CC)(0x1014-0x035C)"},
{0x1014, 0x0339, 0x1014, 0x0360, "PCI-E Auxiliary Cache Adapter (57B7)(0x1014-0x0360)"},
{0x1014, 0x033D, 0xFFFF, 0xFFFF, "PCI-E IPR SAS Adapter (FPGA)(0x033D)"},
{0x1014, 0x033D, 0x1014, 0x033C, "PCIe2 1.8GB Cache 6Gb SAS RAID Adapter Tri-port (57B5)(0x1014-0x033C)"},
{0x1014, 0x033D, 0x1014, 0x0353, "PCIe2 3.1GB Cache 6Gb SAS RAID Enclosure (57C3)(0x1014-0x0353)"},
{0x1014, 0x033D, 0x1014, 0x0354, "PCIe2 6Gb SAS Adapter Dual-port (57C4)(0x1014-0x0354)"},
{0x1014, 0x033D, 0x1014, 0x0356, "PCIe2 1.8GB Cache 6Gb SAS RAID & SSD Adapter (574D)(0x1014-0x0356)"},
{0x1014, 0x033D, 0x1014, 0x035F, "PCIe2 6Gb SAS Adapter Quad-port (57B2)(0x1014-0x035F)"},
{0x1014, 0x034A, 0xFFFF, 0xFFFF, "PCI-E IPR SAS Adapter (ASIC)(0x034A)"},
{0x1014, 0x034A, 0x1014, 0x033B, "PCIe2 6Gb SAS RAID Adapter Quad-port (57B4)(0x1014-0x033B)"},
{0x1014, 0x034A, 0x1014, 0x0355, "PCIe2 3.6GB Cache 6Gb SAS RAID Adapter Quad-port (57B1)(0x1014-0x0355)"},
{0x1014, 0x034A, 0x1014, 0x0357, "PCIe2 6Gb SAS Adapter Quad-port (57C6)(0x1014-0x0357)"},
{0x1014, 0x034A, 0x1014, 0x035D, "PCIe3 1.8GB Cache RAID SAS Adapter Quad-port 6GB (57C8)(0x1014-0x035D)"},
{0x1014, 0x034A, 0x1014, 0x035E, "PCIe2 3.6GB Cache 6Gb SAS RAID Adapter Quad-port (57CE)(0x1014-0x035E)"},
{0x1014, 0x034A, 0x1014, 0x03FB, "PCIe3 28GB Cache RAID SAS Enclosure 6Gb x 16 (57D5)(0x1014-0x03FB)"},
{0x1014, 0x034A, 0x1014, 0x03FE, "PCIe3 x8 Cache SAS RAID Internal Adapter 6Gb (57D8)(0x1014-0x03FE)"},
{0x1014, 0x034A, 0x1014, 0x03FF, "PCIe3 x8 SAS RAID Internal Adapter 6Gb (57D7)(0x1014-0x03FF)"},
{0x1014, 0x034A, 0x1014, 0x0474, "PCIe3 x16 Cache SAS RAID Internal Adapter 6Gb (57EB)(0x1014-0x0474)"},
{0x1014, 0x034A, 0x1014, 0x0475, "PCIe3 x16 SAS RAID Internal Adapter 6Gb (57EC)(0x1014-0x0475)"},
{0x1014, 0x034A, 0x1014, 0x0499, "PCIe3 x16 Cache SAS RAID Internal Adapter 6Gb (57ED)(0x1014-0x0499)"},
{0x1014, 0x034A, 0x1014, 0x049A, "PCIe3 x16 SAS RAID Internal Adapter 6Gb (57EE)(0x1014-0x049A)"},
{0x1014, 0x034A, 0x1014, 0x04C7, "PCIe3 x 8 Cache SAS RAID Internal Adapter 6GB(2CCA)(0x1014-0x04C7)"},
{0x1014, 0x034A, 0x1014, 0x04C8, "PCIe3 x 8 Cache SAS RAID Internal Adapter 6GB(2CD2)(0x1014-0x04C8)"},
{0x1014, 0x034A, 0x1014, 0x04C9, "PCIe3 x 8 Cache SAS RAID Internal Adapter 6GB(2CCD)(0x1014-0x04C9)"},
{0x1014, 0x03DC, 0xFFFF, 0xFFFF, "POWER8 Host Bridge (PHB3)(0x03DC)"},
{0x1014, 0x044B, 0xFFFF, 0xFFFF, "GenWQE Accelerator Adapter(0x044B)"},
{0x1014, 0x04AA, 0xFFFF, 0xFFFF, "Flash Adapter 90 (PCIe2 0.9TB)(0x04AA)"},
{0x1014, 0x04C1, 0xFFFF, 0xFFFF, "POWER9 Host Bridge (PHB4)(0x04C1)"},
{0x1014, 0x04DA, 0xFFFF, 0xFFFF, "PCI-E IPR SAS+ Adapter (ASIC)(0x04DA)"},
{0x1014, 0x04DA, 0x1014, 0x04FB, "PCIe3 x16 20GB Cache 12Gb Quad SAS RAID+ Adapter(580B)(0x1014-0x04FB)"},
{0x1014, 0x04DA, 0x1014, 0x04FC, "PCIe3 x8 12Gb Quad SAS RAID+ Adapter(580A)(0x1014-0x04FC)"},
{0x1014, 0x04ED, 0xFFFF, 0xFFFF, "Internal Shared Memory (ISM) virtual PCI device(0x04ED)"},
{0x1014, 0x0611, 0xFFFF, 0xFFFF, "4769 Cryptographic Adapter(0x0611)"},
{0x1014, 0x06A2, 0xFFFF, 0xFFFF, "4770 Cryptographic Adapter(0x06A2)"},
{0x1014, 0x06A7, 0xFFFF, 0xFFFF, "Spyre Accelerator(0x06A7)"},
{0x1014, 0x06A8, 0xFFFF, 0xFFFF, "Spyre Accelerator Virtual Function(0x06A8)"},
{0x1014, 0x3022, 0xFFFF, 0xFFFF, "QLA3022 Network Adapter(0x3022)"},
{0x1014, 0x4022, 0xFFFF, 0xFFFF, "QLA3022 Network Adapter(0x4022)"},
{0x1014, 0xFFFF, 0xFFFF, 0xFFFF, "MPIC-2 interrupt controller(0xFFFF)"},
}; /* pci_vid_1014[] */

static pci_id_t const pci_vid_1015[] = {
{0x1015, 0xFFFF, 0xFFFF, 0xFFFF, "LSI Logic Corp of Canada(0x1015)"},
}; /* pci_vid_1015[] */

static pci_id_t const pci_vid_1016[] = {
{0x1016, 0xFFFF, 0xFFFF, 0xFFFF, "ICL Personal Systems(0x1016)"},
}; /* pci_vid_1016[] */

static pci_id_t const pci_vid_1017[] = {
{0x1017, 0xFFFF, 0xFFFF, 0xFFFF, "SPEA Software AG(0x1017)"},
{0x1017, 0x5343, 0xFFFF, 0xFFFF, "SPEA 3D Accelerator(0x5343)"},
}; /* pci_vid_1017[] */

static pci_id_t const pci_vid_1018[] = {
{0x1018, 0xFFFF, 0xFFFF, 0xFFFF, "Unisys Systems(0x1018)"},
}; /* pci_vid_1018[] */

static pci_id_t const pci_vid_1019[] = {
{0x1019, 0xFFFF, 0xFFFF, 0xFFFF, "Elitegroup Computer Systems(0x1019)"},
{0x1019, 0x9602, 0xFFFF, 0xFFFF, "RS780/RS880 PCI to PCI bridge (int gfx)(0x9602)"},
}; /* pci_vid_1019[] */

static pci_id_t const pci_vid_101A[] = {
{0x101A, 0xFFFF, 0xFFFF, 0xFFFF, "AT&T GIS (NCR)(0x101A)"},
{0x101A, 0x0005, 0xFFFF, 0xFFFF, "100VG ethernet(0x0005)"},
{0x101A, 0x0007, 0xFFFF, 0xFFFF, "BYNET BIC4G/2C/2G(0x0007)"},
{0x101A, 0x0007, 0x101A, 0x0019, "BYNET BIC2C(0x101A-0x0019)"},
{0x101A, 0x0007, 0x101A, 0x001C, "BYNET BIC2G(0x101A-0x001C)"},
{0x101A, 0x0007, 0x101A, 0x001F, "BYNET BIC4G(0x101A-0x001F)"},
{0x101A, 0x0009, 0xFFFF, 0xFFFF, "PQS Memory Controller(0x0009)"},
{0x101A, 0x000A, 0xFFFF, 0xFFFF, "BYNET BPCI Adapter(0x000A)"},
{0x101A, 0x000B, 0xFFFF, 0xFFFF, "BYNET 4 Port BYA Switch (BYA4P)(0x000B)"},
{0x101A, 0x000C, 0xFFFF, 0xFFFF, "BYNET 4 Port BYA Switch (BYA4G)(0x000C)"},
{0x101A, 0x0010, 0xFFFF, 0xFFFF, "NCR AMC Memory Controller(0x0010)"},
{0x101A, 0x1DC1, 0xFFFF, 0xFFFF, "BYNET BIC2M/BIC4M/BYA4M(0x1DC1)"},
{0x101A, 0x1DC1, 0x101A, 0x0019, "BIC2M(0x101A-0x0019)"},
{0x101A, 0x1DC1, 0x101A, 0x001F, "BIC4M(0x101A-0x001F)"},
{0x101A, 0x1DC1, 0x101A, 0x0ECE, "BYA4M(0x101A-0x0ECE)"},
{0x101A, 0x1FA8, 0xFFFF, 0xFFFF, "BYNET Multi-port BIC Adapter (XBIC Based)(0x1FA8)"},
{0x101A, 0x1FA8, 0x101A, 0x00C3, "BYNET BIC2SE(0x101A-0x00C3)"},
}; /* pci_vid_101A[] */

static pci_id_t const pci_vid_101B[] = {
{0x101B, 0xFFFF, 0xFFFF, 0xFFFF, "Vitesse Semiconductor(0x101B)"},
{0x101B, 0x0452, 0xFFFF, 0xFFFF, "VSC452 [SuperBMC](0x0452)"},
}; /* pci_vid_101B[] */

static pci_id_t const pci_vid_101C[] = {
{0x101C, 0xFFFF, 0xFFFF, 0xFFFF, "Western Digital(0x101C)"},
{0x101C, 0x0193, 0xFFFF, 0xFFFF, "33C193A(0x0193)"},
{0x101C, 0x0196, 0xFFFF, 0xFFFF, "33C196A(0x0196)"},
{0x101C, 0x0197, 0xFFFF, 0xFFFF, "33C197A(0x0197)"},
{0x101C, 0x0296, 0xFFFF, 0xFFFF, "33C296A(0x0296)"},
{0x101C, 0x3193, 0xFFFF, 0xFFFF, "7193(0x3193)"},
{0x101C, 0x3197, 0xFFFF, 0xFFFF, "7197(0x3197)"},
{0x101C, 0x3296, 0xFFFF, 0xFFFF, "33C296A(0x3296)"},
{0x101C, 0x4296, 0xFFFF, 0xFFFF, "34C296(0x4296)"},
{0x101C, 0x9710, 0xFFFF, 0xFFFF, "Pipeline 9710(0x9710)"},
{0x101C, 0x9712, 0xFFFF, 0xFFFF, "Pipeline 9712(0x9712)"},
{0x101C, 0xC24A, 0xFFFF, 0xFFFF, "90C(0xC24A)"},
}; /* pci_vid_101C[] */

static pci_id_t const pci_vid_101D[] = {
{0x101D, 0xFFFF, 0xFFFF, 0xFFFF, "Maxim Integrated Products(0x101D)"},
}; /* pci_vid_101D[] */

static pci_id_t const pci_vid_101E[] = {
{0x101E, 0xFFFF, 0xFFFF, 0xFFFF, "American Megatrends Inc.(0x101E)"},
{0x101E, 0x0009, 0xFFFF, 0xFFFF, "MegaRAID 428 Ultra RAID Controller (rev 03)(0x0009)"},
{0x101E, 0x1960, 0xFFFF, 0xFFFF, "MegaRAID(0x1960)"},
{0x101E, 0x1960, 0x101E, 0x0471, "MegaRAID 471 Enterprise 1600 RAID Controller(0x101E-0x0471)"},
{0x101E, 0x1960, 0x101E, 0x0475, "MegaRAID 475 Express 500/500LC RAID Controller(0x101E-0x0475)"},
{0x101E, 0x1960, 0x101E, 0x0477, "MegaRAID 477 Elite 3100 RAID Controller(0x101E-0x0477)"},
{0x101E, 0x1960, 0x101E, 0x0493, "MegaRAID 493 Elite 1600 RAID Controller(0x101E-0x0493)"},
{0x101E, 0x1960, 0x101E, 0x0494, "MegaRAID 494 Elite 1650 RAID Controller(0x101E-0x0494)"},
{0x101E, 0x1960, 0x101E, 0x0503, "MegaRAID 503 Enterprise 1650 RAID Controller(0x101E-0x0503)"},
{0x101E, 0x1960, 0x101E, 0x0511, "MegaRAID 511 i4 IDE RAID Controller(0x101E-0x0511)"},
{0x101E, 0x1960, 0x101E, 0x0522, "MegaRAID 522 i4133 RAID Controller(0x101E-0x0522)"},
{0x101E, 0x1960, 0x1028, 0x0471, "PowerEdge RAID Controller 3/QC(0x1028-0x0471)"},
{0x101E, 0x1960, 0x1028, 0x0475, "PowerEdge RAID Controller 3/SC(0x1028-0x0475)"},
{0x101E, 0x1960, 0x1028, 0x0493, "PowerEdge RAID Controller 3/DC(0x1028-0x0493)"},
{0x101E, 0x1960, 0x1028, 0x0511, "PowerEdge Cost Effective RAID Controller ATA100/4Ch(0x1028-0x0511)"},
{0x101E, 0x1960, 0x103C, 0x60E7, "NetRAID-1M(0x103C-0x60E7)"},
{0x101E, 0x1960, 0x103C, 0x60E8, "NetRaid 2M [AMI MegaRaid 493](0x103C-0x60E8)"},
{0x101E, 0x9010, 0xFFFF, 0xFFFF, "MegaRAID 428 Ultra RAID Controller(0x9010)"},
{0x101E, 0x9030, 0xFFFF, 0xFFFF, "EIDE Controller(0x9030)"},
{0x101E, 0x9031, 0xFFFF, 0xFFFF, "EIDE Controller(0x9031)"},
{0x101E, 0x9032, 0xFFFF, 0xFFFF, "EIDE & SCSI Controller(0x9032)"},
{0x101E, 0x9033, 0xFFFF, 0xFFFF, "SCSI Controller(0x9033)"},
{0x101E, 0x9040, 0xFFFF, 0xFFFF, "Multimedia card(0x9040)"},
{0x101E, 0x9060, 0xFFFF, 0xFFFF, "MegaRAID 434 Ultra GT RAID Controller(0x9060)"},
{0x101E, 0x9063, 0xFFFF, 0xFFFF, "MegaRAC(0x9063)"},
{0x101E, 0x9063, 0x101E, 0x0767, "Dell Remote Assistant Card 2(0x101E-0x0767)"},
}; /* pci_vid_101E[] */

static pci_id_t const pci_vid_101F[] = {
{0x101F, 0xFFFF, 0xFFFF, 0xFFFF, "PictureTel(0x101F)"},
}; /* pci_vid_101F[] */

static pci_id_t const pci_vid_1020[] = {
{0x1020, 0xFFFF, 0xFFFF, 0xFFFF, "Hitachi Computer Products(0x1020)"},
}; /* pci_vid_1020[] */

static pci_id_t const pci_vid_1021[] = {
{0x1021, 0xFFFF, 0xFFFF, 0xFFFF, "OKI Electric Industry Co. Ltd.(0x1021)"},
}; /* pci_vid_1021[] */

static pci_id_t const pci_vid_1022[] = {
{0x1022, 0xFFFF, 0xFFFF, 0xFFFF, "Advanced Micro Devices, Inc. [AMD](0x1022)"},
{0x1022, 0x1100, 0xFFFF, 0xFFFF, "K8 [Athlon64/Opteron] HyperTransport Technology Configuration(0x1100)"},
{0x1022, 0x1101, 0xFFFF, 0xFFFF, "K8 [Athlon64/Opteron] Address Map(0x1101)"},
{0x1022, 0x1102, 0xFFFF, 0xFFFF, "K8 [Athlon64/Opteron] DRAM Controller(0x1102)"},
{0x1022, 0x1103, 0xFFFF, 0xFFFF, "K8 [Athlon64/Opteron] Miscellaneous Control(0x1103)"},
{0x1022, 0x1110, 0xFFFF, 0xFFFF, "Krackan Internal PCIe GPP Bridge 0 to Bus A(0x1110)"},
{0x1022, 0x1111, 0xFFFF, 0xFFFF, "Krackan Internal PCIe GPP Bridge 0 to Bus B(0x1111)"},
{0x1022, 0x1112, 0xFFFF, 0xFFFF, "Krackan Internal PCIe GPP Bridge 0 to Bus C(0x1112)"},
{0x1022, 0x1113, 0xFFFF, 0xFFFF, "Krackan PCIe Dummy Function(0x1113)"},
{0x1022, 0x1116, 0xFFFF, 0xFFFF, "Krackan PCIe Dummy Function(0x1116)"},
{0x1022, 0x1117, 0xFFFF, 0xFFFF, "Krackan PCIe Dummy Function(0x1117)"},
{0x1022, 0x1122, 0xFFFF, 0xFFFF, "Krackan Root Complex(0x1122)"},
{0x1022, 0x1123, 0xFFFF, 0xFFFF, "Krackan IOMMU(0x1123)"},
{0x1022, 0x1200, 0xFFFF, 0xFFFF, "Family 10h Processor HyperTransport Configuration(0x1200)"},
{0x1022, 0x1201, 0xFFFF, 0xFFFF, "Family 10h Processor Address Map(0x1201)"},
{0x1022, 0x1202, 0xFFFF, 0xFFFF, "Family 10h Processor DRAM Controller(0x1202)"},
{0x1022, 0x1203, 0xFFFF, 0xFFFF, "Family 10h Processor Miscellaneous Control(0x1203)"},
{0x1022, 0x1204, 0xFFFF, 0xFFFF, "Family 10h Processor Link Control(0x1204)"},
{0x1022, 0x1248, 0xFFFF, 0xFFFF, "Krackan Data Fabric; Function 0(0x1248)"},
{0x1022, 0x1249, 0xFFFF, 0xFFFF, "Krackan Data Fabric; Function 1(0x1249)"},
{0x1022, 0x124A, 0xFFFF, 0xFFFF, "Krackan Data Fabric; Function 2(0x124A)"},
{0x1022, 0x124B, 0xFFFF, 0xFFFF, "Krackan Data Fabric; Function 3(0x124B)"},
{0x1022, 0x124C, 0xFFFF, 0xFFFF, "Krackan Data Fabric; Function 4(0x124C)"},
{0x1022, 0x124D, 0xFFFF, 0xFFFF, "Krackan Data Fabric; Function 5(0x124D)"},
{0x1022, 0x124E, 0xFFFF, 0xFFFF, "Krackan Data Fabric; Function 6(0x124E)"},
{0x1022, 0x124F, 0xFFFF, 0xFFFF, "Krackan Data Fabric; Function 7(0x124F)"},
{0x1022, 0x12B8, 0xFFFF, 0xFFFF, "Strix Halo Data Fabric; Function 0(0x12B8)"},
{0x1022, 0x12B9, 0xFFFF, 0xFFFF, "Strix Halo Data Fabric; Function 1(0x12B9)"},
{0x1022, 0x12BA, 0xFFFF, 0xFFFF, "Strix Halo Data Fabric; Function 2(0x12BA)"},
{0x1022, 0x12BB, 0xFFFF, 0xFFFF, "Strix Halo Data Fabric; Function 3(0x12BB)"},
{0x1022, 0x12BC, 0xFFFF, 0xFFFF, "Strix Halo Data Fabric; Function 4(0x12BC)"},
{0x1022, 0x12BD, 0xFFFF, 0xFFFF, "Strix Halo Data Fabric; Function 5(0x12BD)"},
{0x1022, 0x12BE, 0xFFFF, 0xFFFF, "Strix Halo Data Fabric; Function 6(0x12BE)"},
{0x1022, 0x12BF, 0xFFFF, 0xFFFF, "Strix Halo Data Fabric; Function 7(0x12BF)"},
{0x1022, 0x12C0, 0xFFFF, 0xFFFF, "Turin Data Fabric; Function 0(0x12C0)"},
{0x1022, 0x12C1, 0xFFFF, 0xFFFF, "Turin Data Fabric; Function 1(0x12C1)"},
{0x1022, 0x12C2, 0xFFFF, 0xFFFF, "Turin Data Fabric; Function 2(0x12C2)"},
{0x1022, 0x12C3, 0xFFFF, 0xFFFF, "Turin Data Fabric; Function 3(0x12C3)"},
{0x1022, 0x12C4, 0xFFFF, 0xFFFF, "Turin Data Fabric; Function 4(0x12C4)"},
{0x1022, 0x12C5, 0xFFFF, 0xFFFF, "Turin Data Fabric; Function 5(0x12C5)"},
{0x1022, 0x12C6, 0xFFFF, 0xFFFF, "Turin Data Fabric; Function 6(0x12C6)"},
{0x1022, 0x12C7, 0xFFFF, 0xFFFF, "Turin Data Fabric; Function 7(0x12C7)"},
{0x1022, 0x1300, 0xFFFF, 0xFFFF, "Family 11h Processor HyperTransport Configuration(0x1300)"},
{0x1022, 0x1301, 0xFFFF, 0xFFFF, "Family 11h Processor Address Map(0x1301)"},
{0x1022, 0x1302, 0xFFFF, 0xFFFF, "Family 11h Processor DRAM Controller(0x1302)"},
{0x1022, 0x1303, 0xFFFF, 0xFFFF, "Family 11h Processor Miscellaneous Control(0x1303)"},
{0x1022, 0x1304, 0xFFFF, 0xFFFF, "Family 11h Processor Link Control(0x1304)"},
{0x1022, 0x1305, 0xFFFF, 0xFFFF, "Griffin Function 5(0x1305)"},
{0x1022, 0x1306, 0xFFFF, 0xFFFF, "Griffin Function 6(0x1306)"},
{0x1022, 0x1307, 0xFFFF, 0xFFFF, "Griffin Function 7(0x1307)"},
{0x1022, 0x1308, 0xFFFF, 0xFFFF, "Kaveri Audio Controller(0x1308)"},
{0x1022, 0x1314, 0xFFFF, 0xFFFF, "Wrestler/Bheem/Ontario/Krishna Audio Controller(0x1314)"},
{0x1022, 0x13E0, 0xFFFF, 0xFFFF, "Ariel Root Complex(0x13E0)"},
{0x1022, 0x13E1, 0xFFFF, 0xFFFF, "Ariel IOMMU(0x13E1)"},
{0x1022, 0x13E2, 0xFFFF, 0xFFFF, "Ariel PCIe Dummy Host Bridge(0x13E2)"},
{0x1022, 0x13E3, 0xFFFF, 0xFFFF, "Ariel PCIe GPP Bridge(0x13E3)"},
{0x1022, 0x13E4, 0xFFFF, 0xFFFF, "Ariel PCIe Dummy Host Bridge(0x13E4)"},
{0x1022, 0x13E5, 0xFFFF, 0xFFFF, "Ariel Internal PCIe GPP Bridge 0 to Bus A(0x13E5)"},
{0x1022, 0x13E6, 0xFFFF, 0xFFFF, "Ariel Internal PCIe GPP Bridge 0 to Bus B(0x13E6)"},
{0x1022, 0x13E7, 0xFFFF, 0xFFFF, "Ariel SMBus Controller(0x13E7)"},
{0x1022, 0x13E8, 0xFFFF, 0xFFFF, "Ariel LPC Bridge(0x13E8)"},
{0x1022, 0x13E9, 0xFFFF, 0xFFFF, "Ariel Internal GPU(0x13E9)"},
{0x1022, 0x13EA, 0xFFFF, 0xFFFF, "Ariel HD Audio Controller(0x13EA)"},
{0x1022, 0x13EB, 0xFFFF, 0xFFFF, "Ariel HD Audio Coprocessor(0x13EB)"},
{0x1022, 0x13EC, 0xFFFF, 0xFFFF, "Ariel Cryptographic Coprocessor(0x13EC)"},
{0x1022, 0x13ED, 0xFFFF, 0xFFFF, "Ariel USB 3.1 Type C: Gen2 x 1port + DP Alt Mode(0x13ED)"},
{0x1022, 0x13EE, 0xFFFF, 0xFFFF, "Ariel USB 3.1 Type A: Gen2 x 2 ports(0x13EE)"},
{0x1022, 0x13EF, 0xFFFF, 0xFFFF, "Ariel ZCN/MP4(0x13EF)"},
{0x1022, 0x13F0, 0xFFFF, 0xFFFF, "Ariel Device 24: Function 0(0x13F0)"},
{0x1022, 0x13F1, 0xFFFF, 0xFFFF, "Ariel Device 24: Function 1(0x13F1)"},
{0x1022, 0x13F2, 0xFFFF, 0xFFFF, "Ariel Device 24: Function 2(0x13F2)"},
{0x1022, 0x13F3, 0xFFFF, 0xFFFF, "Ariel Device 24: Function 3(0x13F3)"},
{0x1022, 0x13F4, 0xFFFF, 0xFFFF, "Ariel Device 24: Function 4(0x13F4)"},
{0x1022, 0x13F5, 0xFFFF, 0xFFFF, "Ariel Device 24: Function 5(0x13F5)"},
{0x1022, 0x13F6, 0xFFFF, 0xFFFF, "Ariel Device 24: Function 6(0x13F6)"},
{0x1022, 0x13F7, 0xFFFF, 0xFFFF, "Ariel Device 24: Function 7(0x13F7)"},
{0x1022, 0x1400, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Function 0(0x1400)"},
{0x1022, 0x1401, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Function 1(0x1401)"},
{0x1022, 0x1402, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Function 2(0x1402)"},
{0x1022, 0x1403, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Function 3(0x1403)"},
{0x1022, 0x1404, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Function 4(0x1404)"},
{0x1022, 0x1405, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Function 5(0x1405)"},
{0x1022, 0x1410, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Root Complex(0x1410)"},
{0x1022, 0x1410, 0x103C, 0x1985, "Pavilion 17-e163sg Notebook PC(0x103C-0x1985)"},
{0x1022, 0x1412, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Root Port(0x1412)"},
{0x1022, 0x1412, 0x1022, 0x1234, "Trinity A-series APU(0x1022-0x1234)"},
{0x1022, 0x1413, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Root Port(0x1413)"},
{0x1022, 0x1414, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Root Port(0x1414)"},
{0x1022, 0x1414, 0x1022, 0x1234, "Trinity A-series APU(0x1022-0x1234)"},
{0x1022, 0x1415, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Root Port(0x1415)"},
{0x1022, 0x1416, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Root Port(0x1416)"},
{0x1022, 0x1417, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Root Port(0x1417)"},
{0x1022, 0x1418, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) Processor Root Port(0x1418)"},
{0x1022, 0x1419, 0xFFFF, 0xFFFF, "Family 15h (Models 10h-1fh) I/O Memory Management Unit(0x1419)"},
{0x1022, 0x141A, 0xFFFF, 0xFFFF, "Family 15h (Models 30h-3fh) Processor Function 0(0x141A)"},
{0x1022, 0x141B, 0xFFFF, 0xFFFF, "Family 15h (Models 30h-3fh) Processor Function 1(0x141B)"},
{0x1022, 0x141C, 0xFFFF, 0xFFFF, "Family 15h (Models 30h-3fh) Processor Function 2(0x141C)"},
{0x1022, 0x141D, 0xFFFF, 0xFFFF, "Family 15h (Models 30h-3fh) Processor Function 3(0x141D)"},
{0x1022, 0x141E, 0xFFFF, 0xFFFF, "Family 15h (Models 30h-3fh) Processor Function 4(0x141E)"},
{0x1022, 0x141F, 0xFFFF, 0xFFFF, "Family 15h (Models 30h-3fh) Processor Function 5(0x141F)"},
{0x1022, 0x1422, 0xFFFF, 0xFFFF, "Family 15h (Models 30h-3fh) Processor Root Complex(0x1422)"},
{0x1022, 0x1423, 0xFFFF, 0xFFFF, "Family 15h (Models 30h-3fh) I/O Memory Management Unit(0x1423)"},
{0x1022, 0x1424, 0xFFFF, 0xFFFF, "Family 15h (Models 30h-3fh) Processor Root Port(0x1424)"},
{0x1022, 0x1425, 0xFFFF, 0xFFFF, "Kaveri P2P Bridge for GFX PCIe Port [1:0](0x1425)"},
{0x1022, 0x1426, 0xFFFF, 0xFFFF, "Family 15h (Models 30h-3fh) Processor Root Port(0x1426)"},
{0x1022, 0x142E, 0xFFFF, 0xFFFF, "Liverpool Processor HT configuration(0x142E)"},
{0x1022, 0x142F, 0xFFFF, 0xFFFF, "Liverpool Processor Address Maps(0x142F)"},
{0x1022, 0x1430, 0xFFFF, 0xFFFF, "Liverpool Processor DRAM configuration(0x1430)"},
{0x1022, 0x1431, 0xFFFF, 0xFFFF, "Liverpool Processor Misc configuration(0x1431)"},
{0x1022, 0x1432, 0xFFFF, 0xFFFF, "Liverpool Processor PM configuration(0x1432)"},
{0x1022, 0x1433, 0xFFFF, 0xFFFF, "Liverpool Processor NB Performance Monitor(0x1433)"},
{0x1022, 0x1434, 0xFFFF, 0xFFFF, "Liverpool Processor SPLL Configuration(0x1434)"},
{0x1022, 0x1436, 0xFFFF, 0xFFFF, "Liverpool Processor Root Complex(0x1436)"},
{0x1022, 0x1437, 0xFFFF, 0xFFFF, "Liverpool I/O Memory Management Unit(0x1437)"},
{0x1022, 0x1438, 0xFFFF, 0xFFFF, "Liverpool UMI PCIe Dummy Host Bridge(0x1438)"},
{0x1022, 0x1439, 0xFFFF, 0xFFFF, "Family 16h Processor Functions 5:1(0x1439)"},
{0x1022, 0x143A, 0xFFFF, 0xFFFF, "Kingston/Clayton/Gladius/Montego Root Complex(0x143A)"},
{0x1022, 0x143B, 0xFFFF, 0xFFFF, "Kingston/Clayton/Gladius/Montego P2P Bridge for UMI Link(0x143B)"},
{0x1022, 0x1440, 0xFFFF, 0xFFFF, "Matisse/Vermeer Data Fabric: Device 18h; Function 0(0x1440)"},
{0x1022, 0x1441, 0xFFFF, 0xFFFF, "Matisse/Vermeer Data Fabric: Device 18h; Function 1(0x1441)"},
{0x1022, 0x1442, 0xFFFF, 0xFFFF, "Matisse/Vermeer Data Fabric: Device 18h; Function 2(0x1442)"},
{0x1022, 0x1443, 0xFFFF, 0xFFFF, "Matisse/Vermeer Data Fabric: Device 18h; Function 3(0x1443)"},
{0x1022, 0x1444, 0xFFFF, 0xFFFF, "Matisse/Vermeer Data Fabric: Device 18h; Function 4(0x1444)"},
{0x1022, 0x1445, 0xFFFF, 0xFFFF, "Matisse/Vermeer Data Fabric: Device 18h; Function 5(0x1445)"},
{0x1022, 0x1446, 0xFFFF, 0xFFFF, "Matisse/Vermeer Data Fabric: Device 18h; Function 6(0x1446)"},
{0x1022, 0x1447, 0xFFFF, 0xFFFF, "Matisse/Vermeer Data Fabric: Device 18h; Function 7(0x1447)"},
{0x1022, 0x1448, 0xFFFF, 0xFFFF, "Renoir Device 24: Function 0(0x1448)"},
{0x1022, 0x1449, 0xFFFF, 0xFFFF, "Renoir Device 24: Function 1(0x1449)"},
{0x1022, 0x144A, 0xFFFF, 0xFFFF, "Renoir Device 24: Function 2(0x144A)"},
{0x1022, 0x144B, 0xFFFF, 0xFFFF, "Renoir Device 24: Function 3(0x144B)"},
{0x1022, 0x144C, 0xFFFF, 0xFFFF, "Renoir Device 24: Function 4(0x144C)"},
{0x1022, 0x144D, 0xFFFF, 0xFFFF, "Renoir Device 24: Function 5(0x144D)"},
{0x1022, 0x144E, 0xFFFF, 0xFFFF, "Renoir Device 24: Function 6(0x144E)"},
{0x1022, 0x144F, 0xFFFF, 0xFFFF, "Renoir Device 24: Function 7(0x144F)"},
{0x1022, 0x1450, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Root Complex(0x1450)"},
{0x1022, 0x1451, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) I/O Memory Management Unit(0x1451)"},
{0x1022, 0x1452, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-1fh) PCIe Dummy Host Bridge(0x1452)"},
{0x1022, 0x1452, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x1453, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) PCIe GPP Bridge(0x1453)"},
{0x1022, 0x1454, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Internal PCIe GPP Bridge 0 to Bus B(0x1454)"},
{0x1022, 0x1455, 0xFFFF, 0xFFFF, "Zeppelin/Renoir PCIe Dummy Function(0x1455)"},
{0x1022, 0x1456, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Platform Security Processor (PSP) 3.0 Device(0x1456)"},
{0x1022, 0x1457, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) HD Audio Controller(0x1457)"},
{0x1022, 0x1458, 0xFFFF, 0xFFFF, "XGMAC 10GbE Controller(0x1458)"},
{0x1022, 0x1459, 0xFFFF, 0xFFFF, "XGMAC 10GbE Controller(0x1459)"},
{0x1022, 0x145A, 0xFFFF, 0xFFFF, "Zeppelin/Raven/Raven2 PCIe Dummy Function(0x145A)"},
{0x1022, 0x145B, 0xFFFF, 0xFFFF, "Zeppelin Non-Transparent Bridge(0x145B)"},
{0x1022, 0x145C, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) USB 3.0 Host Controller(0x145C)"},
{0x1022, 0x145D, 0xFFFF, 0xFFFF, "Zeppelin Switch Upstream (PCIE SW.US)(0x145D)"},
{0x1022, 0x145E, 0xFFFF, 0xFFFF, "Zeppelin Switch Downstream (PCIE SW.DS)(0x145E)"},
{0x1022, 0x145F, 0xFFFF, 0xFFFF, "Zeppelin USB 3.0 xHCI Compliant Host Controller(0x145F)"},
{0x1022, 0x1460, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 0(0x1460)"},
{0x1022, 0x1461, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 1(0x1461)"},
{0x1022, 0x1462, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 2(0x1462)"},
{0x1022, 0x1463, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 3(0x1463)"},
{0x1022, 0x1464, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 4(0x1464)"},
{0x1022, 0x1465, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 5(0x1465)"},
{0x1022, 0x1466, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 6(0x1466)"},
{0x1022, 0x1467, 0xFFFF, 0xFFFF, "Family 17h (Models 00h-0fh) Data Fabric: Device 18h; Function 7(0x1467)"},
{0x1022, 0x1468, 0xFFFF, 0xFFFF, "Zeppelin Cryptographic Coprocessor NTBCCP(0x1468)"},
{0x1022, 0x1470, 0xFFFF, 0xFFFF, "Vega 10 PCIe Bridge(0x1470)"},
{0x1022, 0x1471, 0xFFFF, 0xFFFF, "Vega 10 PCIe Bridge(0x1471)"},
{0x1022, 0x1480, 0xFFFF, 0xFFFF, "Starship/Matisse Root Complex(0x1480)"},
{0x1022, 0x1480, 0x1462, 0x7C37, "X570-A PRO motherboard(0x1462-0x7C37)"},
{0x1022, 0x1480, 0x15D9, 0x1B95, "H12SSL-i(0x15D9-0x1B95)"},
{0x1022, 0x1480, 0x1849, 0x1480, "ROME2D32LM3(0x1849-0x1480)"},
{0x1022, 0x1481, 0xFFFF, 0xFFFF, "Starship/Matisse IOMMU(0x1481)"},
{0x1022, 0x1482, 0xFFFF, 0xFFFF, "Starship/Matisse PCIe Dummy Host Bridge(0x1482)"},
{0x1022, 0x1483, 0xFFFF, 0xFFFF, "Starship/Matisse GPP Bridge(0x1483)"},
{0x1022, 0x1483, 0x01DE, 0xFFF9, "Gimlet Baseboard(0x01DE-0xFFF9)"},
{0x1022, 0x1484, 0xFFFF, 0xFFFF, "Starship/Matisse Internal PCIe GPP Bridge 0 to bus[E:B](0x1484)"},
{0x1022, 0x1485, 0xFFFF, 0xFFFF, "Starship/Matisse Reserved SPP(0x1485)"},
{0x1022, 0x1486, 0xFFFF, 0xFFFF, "Starship/Matisse Cryptographic Coprocessor PSPCPP(0x1486)"},
{0x1022, 0x1487, 0xFFFF, 0xFFFF, "Starship/Matisse HD Audio Controller(0x1487)"},
{0x1022, 0x1487, 0x1462, 0x9C37, "X570-A PRO motherboard(0x1462-0x9C37)"},
{0x1022, 0x1488, 0xFFFF, 0xFFFF, "Starship Reserved SSP(0x1488)"},
{0x1022, 0x1489, 0xFFFF, 0xFFFF, "Starship Reserved SSP(0x1489)"},
{0x1022, 0x148A, 0xFFFF, 0xFFFF, "Starship/Matisse PCIe Dummy Function(0x148A)"},
{0x1022, 0x148B, 0xFFFF, 0xFFFF, "Starship/Matisse Non-Transparent Bridge(0x148B)"},
{0x1022, 0x148C, 0xFFFF, 0xFFFF, "Starship USB 3.0 Host Controller(0x148C)"},
{0x1022, 0x148C, 0x15D9, 0x145C, "H12SSL-i(0x15D9-0x145C)"},
{0x1022, 0x148D, 0xFFFF, 0xFFFF, "Starship/Matisse Switch Upstream (PCIE SW.US)(0x148D)"},
{0x1022, 0x148E, 0xFFFF, 0xFFFF, "Starship/Matisse Switch Downstream (PCIE SW.DS)(0x148E)"},
{0x1022, 0x148F, 0xFFFF, 0xFFFF, "Starship Reserved SSP(0x148F)"},
{0x1022, 0x1490, 0xFFFF, 0xFFFF, "Starship Device 24; Function 0(0x1490)"},
{0x1022, 0x1491, 0xFFFF, 0xFFFF, "Starship Device 24; Function 1(0x1491)"},
{0x1022, 0x1492, 0xFFFF, 0xFFFF, "Starship Device 24; Function 2(0x1492)"},
{0x1022, 0x1493, 0xFFFF, 0xFFFF, "Starship Device 24; Function 3(0x1493)"},
{0x1022, 0x1494, 0xFFFF, 0xFFFF, "Starship Device 24; Function 4(0x1494)"},
{0x1022, 0x1495, 0xFFFF, 0xFFFF, "Starship Device 24; Function 5(0x1495)"},
{0x1022, 0x1496, 0xFFFF, 0xFFFF, "Starship Device 24; Function 6(0x1496)"},
{0x1022, 0x1497, 0xFFFF, 0xFFFF, "Starship Device 24; Function 7(0x1497)"},
{0x1022, 0x1498, 0xFFFF, 0xFFFF, "Starship/Matisse PTDMA(0x1498)"},
{0x1022, 0x1499, 0xFFFF, 0xFFFF, "Starship/Matisse NVMe(0x1499)"},
{0x1022, 0x149A, 0xFFFF, 0xFFFF, "Starship PCIe GPP Bridge [1:0](0x149A)"},
{0x1022, 0x149B, 0xFFFF, 0xFFFF, "Starship Reserved SSP(0x149B)"},
{0x1022, 0x149C, 0xFFFF, 0xFFFF, "Matisse USB 3.0 Host Controller(0x149C)"},
{0x1022, 0x149C, 0x1462, 0x7C37, "X570-A PRO motherboard(0x1462-0x7C37)"},
{0x1022, 0x149D, 0xFFFF, 0xFFFF, "Vangogh CVIP(0x149D)"},
{0x1022, 0x149E, 0xFFFF, 0xFFFF, "Genoa/Bergamo IOMMU(0x149E)"},
{0x1022, 0x149F, 0xFFFF, 0xFFFF, "Genoa/Bergamo Dummy Host Bridge(0x149F)"},
{0x1022, 0x14A4, 0xFFFF, 0xFFFF, "Genoa/Bergamo Root Complex(0x14A4)"},
{0x1022, 0x14A5, 0xFFFF, 0xFFFF, "Genoa/Bergamo GPP Bridge(0x14A5)"},
{0x1022, 0x14A6, 0xFFFF, 0xFFFF, "Genoa/Bergamo RCEC(0x14A6)"},
{0x1022, 0x14A7, 0xFFFF, 0xFFFF, "Genoa/Bergamo Internal PCIe GPP Bridge to Bus [D:B](0x14A7)"},
{0x1022, 0x14AA, 0xFFFF, 0xFFFF, "Genoa/Bergamo GPP Bridge(0x14AA)"},
{0x1022, 0x14AB, 0xFFFF, 0xFFFF, "Genoa/Bergamo GPP Bridge(0x14AB)"},
{0x1022, 0x14AC, 0xFFFF, 0xFFFF, "Genoa/Bergamo Dummy Function(0x14AC)"},
{0x1022, 0x14AD, 0xFFFF, 0xFFFF, "Genoa/Bergamo Data Fabric; Function 0(0x14AD)"},
{0x1022, 0x14AE, 0xFFFF, 0xFFFF, "Genoa/Bergamo Data Fabric; Function 1(0x14AE)"},
{0x1022, 0x14AF, 0xFFFF, 0xFFFF, "Genoa/Bergamo Data Fabric; Function 2(0x14AF)"},
{0x1022, 0x14B0, 0xFFFF, 0xFFFF, "Genoa/Bergamo Data Fabric; Function 3(0x14B0)"},
{0x1022, 0x14B1, 0xFFFF, 0xFFFF, "Genoa/Bergamo Data Fabric; Function 4(0x14B1)"},
{0x1022, 0x14B2, 0xFFFF, 0xFFFF, "Genoa/Bergamo Data Fabric; Function 5(0x14B2)"},
{0x1022, 0x14B3, 0xFFFF, 0xFFFF, "Genoa/Bergamo Data Fabric; Function 6(0x14B3)"},
{0x1022, 0x14B4, 0xFFFF, 0xFFFF, "Genoa/Bergamo Data Fabric; Function 7(0x14B4)"},
{0x1022, 0x14B5, 0xFFFF, 0xFFFF, "Family 17h-19h PCIe Root Complex(0x14B5)"},
{0x1022, 0x14B6, 0xFFFF, 0xFFFF, "Family 17h-19h IOMMU(0x14B6)"},
{0x1022, 0x14B7, 0xFFFF, 0xFFFF, "Family 17h-19h PCIe Dummy Host Bridge(0x14B7)"},
{0x1022, 0x14B8, 0xFFFF, 0xFFFF, "Family 17h-19h PCIe GPP Bridge(0x14B8)"},
{0x1022, 0x14B9, 0xFFFF, 0xFFFF, "Family 17h-19h Internal PCIe GPP Bridge(0x14B9)"},
{0x1022, 0x14BA, 0xFFFF, 0xFFFF, "Family 17h-19h PCIe GPP Bridge(0x14BA)"},
{0x1022, 0x14C1, 0xFFFF, 0xFFFF, "Secondary vNTB(0x14C1)"},
{0x1022, 0x14CA, 0xFFFF, 0xFFFF, "Genoa CCP/PSP 4.0 Device(0x14CA)"},
{0x1022, 0x14CD, 0xFFFF, 0xFFFF, "Family 19h USB4/Thunderbolt PCIe tunnel(0x14CD)"},
{0x1022, 0x14D8, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Root Complex(0x14D8)"},
{0x1022, 0x14D9, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge IOMMU(0x14D9)"},
{0x1022, 0x14DA, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Dummy Host Bridge(0x14DA)"},
{0x1022, 0x14DB, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge GPP Bridge(0x14DB)"},
{0x1022, 0x14DC, 0xFFFF, 0xFFFF, "SDXI(0x14DC)"},
{0x1022, 0x14DD, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Internal GPP Bridge to Bus [C:A](0x14DD)"},
{0x1022, 0x14DE, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge PCIe Dummy Function(0x14DE)"},
{0x1022, 0x14E0, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Data Fabric; Function 0(0x14E0)"},
{0x1022, 0x14E1, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Data Fabric; Function 1(0x14E1)"},
{0x1022, 0x14E2, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Data Fabric; Function 2(0x14E2)"},
{0x1022, 0x14E3, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Data Fabric; Function 3(0x14E3)"},
{0x1022, 0x14E4, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Data Fabric; Function 4(0x14E4)"},
{0x1022, 0x14E5, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Data Fabric; Function 5(0x14E5)"},
{0x1022, 0x14E6, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Data Fabric; Function 6(0x14E6)"},
{0x1022, 0x14E7, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge Data Fabric; Function 7(0x14E7)"},
{0x1022, 0x14E8, 0xFFFF, 0xFFFF, "Phoenix Root Complex(0x14E8)"},
{0x1022, 0x14E9, 0xFFFF, 0xFFFF, "Phoenix IOMMU(0x14E9)"},
{0x1022, 0x14EA, 0xFFFF, 0xFFFF, "Phoenix Dummy Host Bridge(0x14EA)"},
{0x1022, 0x14EB, 0xFFFF, 0xFFFF, "Phoenix Internal GPP Bridge to Bus [C:A](0x14EB)"},
{0x1022, 0x14EC, 0xFFFF, 0xFFFF, "Phoenix Dummy Function(0x14EC)"},
{0x1022, 0x14ED, 0xFFFF, 0xFFFF, "Phoenix GPP Bridge(0x14ED)"},
{0x1022, 0x14EE, 0xFFFF, 0xFFFF, "Phoenix GPP Bridge(0x14EE)"},
{0x1022, 0x14EF, 0xFFFF, 0xFFFF, "Family 19h USB4/Thunderbolt PCIe tunnel(0x14EF)"},
{0x1022, 0x14F0, 0xFFFF, 0xFFFF, "Phoenix Data Fabric; Function 0(0x14F0)"},
{0x1022, 0x14F1, 0xFFFF, 0xFFFF, "Phoenix Data Fabric; Function 1(0x14F1)"},
{0x1022, 0x14F2, 0xFFFF, 0xFFFF, "Phoenix Data Fabric; Function 2(0x14F2)"},
{0x1022, 0x14F3, 0xFFFF, 0xFFFF, "Phoenix Data Fabric; Function 3(0x14F3)"},
{0x1022, 0x14F4, 0xFFFF, 0xFFFF, "Phoenix Data Fabric; Function 4(0x14F4)"},
{0x1022, 0x14F5, 0xFFFF, 0xFFFF, "Phoenix Data Fabric; Function 5(0x14F5)"},
{0x1022, 0x14F6, 0xFFFF, 0xFFFF, "Phoenix Data Fabric; Function 6(0x14F6)"},
{0x1022, 0x14F7, 0xFFFF, 0xFFFF, "Phoenix Data Fabric; Function 7(0x14F7)"},
{0x1022, 0x1502, 0xFFFF, 0xFFFF, "AMD IPU Device(0x1502)"},
{0x1022, 0x1507, 0xFFFF, 0xFFFF, "Strix/Strix Halo Root Complex(0x1507)"},
{0x1022, 0x1508, 0xFFFF, 0xFFFF, "Strix/Strix Halo IOMMU(0x1508)"},
{0x1022, 0x1509, 0xFFFF, 0xFFFF, "Strix/Strix Halo Dummy Host Bridge(0x1509)"},
{0x1022, 0x150A, 0xFFFF, 0xFFFF, "Strix/Strix Halo PCIe USB4 Bridge(0x150A)"},
{0x1022, 0x150B, 0xFFFF, 0xFFFF, "Strix/Strix Halo GPP Bridge(0x150B)"},
{0x1022, 0x150C, 0xFFFF, 0xFFFF, "Strix/Strix Halo Internal GPP Bridge to Bus [C:A](0x150C)"},
{0x1022, 0x150D, 0xFFFF, 0xFFFF, "Strix/Strix Halo PCIe Dummy Function(0x150D)"},
{0x1022, 0x1510, 0xFFFF, 0xFFFF, "Family 14h Processor Root Complex(0x1510)"},
{0x1022, 0x1510, 0x174B, 0x1001, "PURE Fusion Mini(0x174B-0x1001)"},
{0x1022, 0x1512, 0xFFFF, 0xFFFF, "Family 14h Processor Root Port(0x1512)"},
{0x1022, 0x1513, 0xFFFF, 0xFFFF, "Family 14h Processor Root Port(0x1513)"},
{0x1022, 0x1514, 0xFFFF, 0xFFFF, "Family 14h Processor Root Port(0x1514)"},
{0x1022, 0x1515, 0xFFFF, 0xFFFF, "Family 14h Processor Root Port(0x1515)"},
{0x1022, 0x1516, 0xFFFF, 0xFFFF, "Family 14h Processor Root Port(0x1516)"},
{0x1022, 0x151C, 0xFFFF, 0xFFFF, "USB4 Router 0(0x151C)"},
{0x1022, 0x151D, 0xFFFF, 0xFFFF, "USB4 Router 1(0x151D)"},
{0x1022, 0x1530, 0xFFFF, 0xFFFF, "Family 16h Processor Function 0(0x1530)"},
{0x1022, 0x1531, 0xFFFF, 0xFFFF, "Family 16h Processor Function 1(0x1531)"},
{0x1022, 0x1532, 0xFFFF, 0xFFFF, "Family 16h Processor Function 2(0x1532)"},
{0x1022, 0x1533, 0xFFFF, 0xFFFF, "Family 16h Processor Function 3(0x1533)"},
{0x1022, 0x1534, 0xFFFF, 0xFFFF, "Family 16h Processor Function 4(0x1534)"},
{0x1022, 0x1535, 0xFFFF, 0xFFFF, "Family 16h Processor Function 5(0x1535)"},
{0x1022, 0x1536, 0xFFFF, 0xFFFF, "Family 16h Processor Root Complex(0x1536)"},
{0x1022, 0x1536, 0x1043, 0x8623, "AM1I-A Motherboard(0x1043-0x8623)"},
{0x1022, 0x1536, 0x1849, 0x1536, "QC5000-ITX/PH(0x1849-0x1536)"},
{0x1022, 0x1537, 0xFFFF, 0xFFFF, "Kabini/Mullins PSP-Platform Security Processor(0x1537)"},
{0x1022, 0x1538, 0xFFFF, 0xFFFF, "Family 16h Processor Function 0(0x1538)"},
{0x1022, 0x1539, 0xFFFF, 0xFFFF, "Kabini P2P Bridge for PCIe Ports[4:0](0x1539)"},
{0x1022, 0x153A, 0xFFFF, 0xFFFF, "Turin Root Complex(0x153A)"},
{0x1022, 0x153B, 0xFFFF, 0xFFFF, "Turin IOMMU(0x153B)"},
{0x1022, 0x153C, 0xFFFF, 0xFFFF, "Turin RCEC(0x153C)"},
{0x1022, 0x153D, 0xFFFF, 0xFFFF, "Turin PCIe Dummy Host Bridge(0x153D)"},
{0x1022, 0x153E, 0xFFFF, 0xFFFF, "Turin GPP Bridge(0x153E)"},
{0x1022, 0x153E, 0x01DE, 0xFFF8, "Cosmo Baseboard(0x01DE-0xFFF8)"},
{0x1022, 0x1540, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky HT Configuration(0x1540)"},
{0x1022, 0x1541, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Address Maps(0x1541)"},
{0x1022, 0x1542, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky DRAM Configuration(0x1542)"},
{0x1022, 0x1543, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Miscellaneous Configuration(0x1543)"},
{0x1022, 0x1544, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky PM Configuration(0x1544)"},
{0x1022, 0x1545, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky NB Performance Monitor(0x1545)"},
{0x1022, 0x1546, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Root Complex(0x1546)"},
{0x1022, 0x1547, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky IOMMU(0x1547)"},
{0x1022, 0x1548, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky UMI PCIe Dummy Host Bridge(0x1548)"},
{0x1022, 0x1549, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+ P2P Bridge for PCIe Port [3:0](0x1549)"},
{0x1022, 0x154A, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Audio Processor(0x154A)"},
{0x1022, 0x154B, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky Security Processor(0x154B)"},
{0x1022, 0x154D, 0xFFFF, 0xFFFF, "Kryptos/Cato/Garfield/Garfield+/Arlene/Pooky/Anubis HDMI Controller(0x154D)"},
{0x1022, 0x154F, 0xFFFF, 0xFFFF, "Anubis Audio Processor(0x154F)"},
{0x1022, 0x1550, 0xFFFF, 0xFFFF, "Garfield+/Arlene/Pooky/Anubis SPLL Configuration(0x1550)"},
{0x1022, 0x1553, 0xFFFF, 0xFFFF, "Arlene/Pooky P2P Bridge for PCIE (3:0)(0x1553)"},
{0x1022, 0x1554, 0xFFFF, 0xFFFF, "Turin GPP Bridge(0x1554)"},
{0x1022, 0x1555, 0xFFFF, 0xFFFF, "Turin Internal PCIe GPP Bridge to Bus [D:C](0x1555)"},
{0x1022, 0x1556, 0xFFFF, 0xFFFF, "Turin PCIe Dummy Function(0x1556)"},
{0x1022, 0x1557, 0xFFFF, 0xFFFF, "Turin USB 3.1 xHCI(0x1557)"},
{0x1022, 0x1559, 0xFFFF, 0xFFFF, "Turin Secondary PCIe Dummy Function(0x1559)"},
{0x1022, 0x155B, 0xFFFF, 0xFFFF, "Anubis Root Complex(0x155B)"},
{0x1022, 0x155C, 0xFFFF, 0xFFFF, "Anubis IOMMU(0x155C)"},
{0x1022, 0x155D, 0xFFFF, 0xFFFF, "Anubis UMI PCIe Dummy Bridge(0x155D)"},
{0x1022, 0x155E, 0xFFFF, 0xFFFF, "Anubis P2P Bridge for PCIe Ports [4:0](0x155E)"},
{0x1022, 0x1560, 0xFFFF, 0xFFFF, "Anubis Security Processor(0x1560)"},
{0x1022, 0x1566, 0xFFFF, 0xFFFF, "Family 16h (Models 30h-3fh) Processor Root Complex(0x1566)"},
{0x1022, 0x1567, 0xFFFF, 0xFFFF, "Mullins IOMMU(0x1567)"},
{0x1022, 0x156B, 0xFFFF, 0xFFFF, "Family 16h (Models 30h-3fh) Host Bridge(0x156B)"},
{0x1022, 0x156E, 0xFFFF, 0xFFFF, "Turin CCP/ASP(0x156E)"},
{0x1022, 0x1570, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) Processor Function 0(0x1570)"},
{0x1022, 0x1571, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) Processor Function 1(0x1571)"},
{0x1022, 0x1572, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) Processor Function 2(0x1572)"},
{0x1022, 0x1573, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) Processor Function 3(0x1573)"},
{0x1022, 0x1574, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) Processor Function 4(0x1574)"},
{0x1022, 0x1575, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) Processor Function 5(0x1575)"},
{0x1022, 0x1576, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) Processor Root Complex(0x1576)"},
{0x1022, 0x1577, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) I/O Memory Management Unit(0x1577)"},
{0x1022, 0x1578, 0xFFFF, 0xFFFF, "Carrizo Platform Security Processor(0x1578)"},
{0x1022, 0x1579, 0xFFFF, 0xFFFF, "Carrizo Audio Processor(0x1579)"},
{0x1022, 0x157A, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) Audio Controller(0x157A)"},
{0x1022, 0x157B, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) Host Bridge(0x157B)"},
{0x1022, 0x157C, 0xFFFF, 0xFFFF, "Family 15h (Models 60h-6fh) Processor Root Port(0x157C)"},
{0x1022, 0x157D, 0xFFFF, 0xFFFF, "Carrizo Audio Dummy Host Bridge(0x157D)"},
{0x1022, 0x157E, 0xFFFF, 0xFFFF, "Carrizo Audio Controller(0x157E)"},
{0x1022, 0x1580, 0xFFFF, 0xFFFF, "Family 16h (Models 30h-3fh) Processor Function 0(0x1580)"},
{0x1022, 0x1581, 0xFFFF, 0xFFFF, "Family 16h (Models 30h-3fh) Processor Function 1(0x1581)"},
{0x1022, 0x1582, 0xFFFF, 0xFFFF, "Family 16h (Models 30h-3fh) Processor Function 2(0x1582)"},
{0x1022, 0x1583, 0xFFFF, 0xFFFF, "Family 16h (Models 30h-3fh) Processor Function 3(0x1583)"},
{0x1022, 0x1584, 0xFFFF, 0xFFFF, "Family 16h (Models 30h-3fh) Processor Function 4(0x1584)"},
{0x1022, 0x1585, 0xFFFF, 0xFFFF, "Family 16h (Models 30h-3fh) Processor Function 5(0x1585)"},
{0x1022, 0x1587, 0xFFFF, 0xFFFF, "Strix Halo USB 3.1 xHCI(0x1587)"},
{0x1022, 0x1588, 0xFFFF, 0xFFFF, "Strix Halo USB 3.1 xHCI(0x1588)"},
{0x1022, 0x1589, 0xFFFF, 0xFFFF, "Strix Halo USB 3.1 xHCI(0x1589)"},
{0x1022, 0x158B, 0xFFFF, 0xFFFF, "Strix Halo USB 3.1 xHCI(0x158B)"},
{0x1022, 0x158D, 0xFFFF, 0xFFFF, "Strix Halo USB4 Host Router(0x158D)"},
{0x1022, 0x158E, 0xFFFF, 0xFFFF, "Strix Halo USB4 Host Router(0x158E)"},
{0x1022, 0x1590, 0xFFFF, 0xFFFF, "Amur/Nolan HT Configuration(0x1590)"},
{0x1022, 0x1591, 0xFFFF, 0xFFFF, "Amur/Nolan Address Maps(0x1591)"},
{0x1022, 0x1592, 0xFFFF, 0xFFFF, "Amur/Nolan DRAM Configuration(0x1592)"},
{0x1022, 0x1593, 0xFFFF, 0xFFFF, "Amur/Nolan Miscellaneous Configuration(0x1593)"},
{0x1022, 0x1594, 0xFFFF, 0xFFFF, "Amur/Nolan PM Configuration(0x1594)"},
{0x1022, 0x1595, 0xFFFF, 0xFFFF, "Amur/Nolan NB Performance Monitor(0x1595)"},
{0x1022, 0x1596, 0xFFFF, 0xFFFF, "Amur/Nolan Root Complex(0x1596)"},
{0x1022, 0x1597, 0xFFFF, 0xFFFF, "Amur/Nolan IOMMU(0x1597)"},
{0x1022, 0x1598, 0xFFFF, 0xFFFF, "Amur/Nolan Platform Security Processor(0x1598)"},
{0x1022, 0x1599, 0xFFFF, 0xFFFF, "Amur/Nolan PCIe Dummy Host Bridge(0x1599)"},
{0x1022, 0x159D, 0xFFFF, 0xFFFF, "Amur Function 6: Gasket(0x159D)"},
{0x1022, 0x15B0, 0xFFFF, 0xFFFF, "Stoney HT Configuration(0x15B0)"},
{0x1022, 0x15B1, 0xFFFF, 0xFFFF, "Stoney Address Maps(0x15B1)"},
{0x1022, 0x15B2, 0xFFFF, 0xFFFF, "Stoney DRAM Configuration(0x15B2)"},
{0x1022, 0x15B3, 0xFFFF, 0xFFFF, "Stoney Miscellaneous Configuration(0x15B3)"},
{0x1022, 0x15B4, 0xFFFF, 0xFFFF, "Stoney PM Configuration(0x15B4)"},
{0x1022, 0x15B5, 0xFFFF, 0xFFFF, "Stoney NB Performance Monitor(0x15B5)"},
{0x1022, 0x15B6, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge USB 3.1 xHCI(0x15B6)"},
{0x1022, 0x15B7, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge USB 3.1 xHCI(0x15B7)"},
{0x1022, 0x15B8, 0xFFFF, 0xFFFF, "Raphael/Granite Ridge USB 2.0 xHCI(0x15B8)"},
{0x1022, 0x15BC, 0xFFFF, 0xFFFF, "Stoney PCIe [GFX,GPP] Bridge [4:0](0x15BC)"},
{0x1022, 0x15BE, 0xFFFF, 0xFFFF, "Stoney Audio Processor(0x15BE)"},
{0x1022, 0x15C4, 0xFFFF, 0xFFFF, "Phoenix USB4/Thunderbolt NHI controller #1(0x15C4)"},
{0x1022, 0x15C5, 0xFFFF, 0xFFFF, "Phoenix USB4/Thunderbolt NHI controller #2(0x15C5)"},
{0x1022, 0x15C7, 0xFFFF, 0xFFFF, "Phoenix CCP/PSP 3.0 Device(0x15C7)"},
{0x1022, 0x15D0, 0xFFFF, 0xFFFF, "Raven/Raven2 Root Complex(0x15D0)"},
{0x1022, 0x15D0, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1022, 0x15D0, 0x1043, 0x876B, "PRIME B450M-A Motherboard(0x1043-0x876B)"},
{0x1022, 0x15D0, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15D1, 0xFFFF, 0xFFFF, "Raven/Raven2 IOMMU(0x15D1)"},
{0x1022, 0x15D1, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1022, 0x15D1, 0x1043, 0x876B, "PRIME B450M-A Motherboard(0x1043-0x876B)"},
{0x1022, 0x15D1, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15D2, 0xFFFF, 0xFFFF, "Raven/Raven2 PCIe Dummy Host Bridge(0x15D2)"},
{0x1022, 0x15D3, 0xFFFF, 0xFFFF, "Raven/Raven2 PCIe GPP Bridge [6:0](0x15D3)"},
{0x1022, 0x15D3, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15D4, 0xFFFF, 0xFFFF, "FireFlight USB 3.1(0x15D4)"},
{0x1022, 0x15D5, 0xFFFF, 0xFFFF, "FireFlight USB 3.1(0x15D5)"},
{0x1022, 0x15D6, 0xFFFF, 0xFFFF, "Rembrandt USB4 XHCI controller #5(0x15D6)"},
{0x1022, 0x15D7, 0xFFFF, 0xFFFF, "Rembrandt USB4 XHCI controller #6(0x15D7)"},
{0x1022, 0x15DA, 0xFFFF, 0xFFFF, "Raven/Raven2 PCIe Dummy Host Bridge(0x15DA)"},
{0x1022, 0x15DB, 0xFFFF, 0xFFFF, "Raven/Raven2 Internal PCIe GPP Bridge 0 to Bus A(0x15DB)"},
{0x1022, 0x15DB, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15DC, 0xFFFF, 0xFFFF, "Raven/Raven2 Internal PCIe GPP Bridge 0 to Bus B(0x15DC)"},
{0x1022, 0x15DC, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15DE, 0xFFFF, 0xFFFF, "Raven/Raven2/FireFlight HD Audio Controller(0x15DE)"},
{0x1022, 0x15DF, 0xFFFF, 0xFFFF, "Raven/Raven2/FireFlight/Renoir/Cezanne Platform Security Processor(0x15DF)"},
{0x1022, 0x15DF, 0x1043, 0x876B, "PRIME Motherboard(0x1043-0x876B)"},
{0x1022, 0x15DF, 0x17AA, 0x5124, "ThinkPad E595(0x17AA-0x5124)"},
{0x1022, 0x15DF, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15E0, 0xFFFF, 0xFFFF, "Raven USB 3.1(0x15E0)"},
{0x1022, 0x15E0, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1022, 0x15E0, 0x1043, 0x876B, "PRIME Motherboard(0x1043-0x876B)"},
{0x1022, 0x15E0, 0x17AA, 0x5124, "ThinkPad E595(0x17AA-0x5124)"},
{0x1022, 0x15E0, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15E1, 0xFFFF, 0xFFFF, "Raven USB 3.1(0x15E1)"},
{0x1022, 0x15E1, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1022, 0x15E1, 0x1043, 0x876B, "PRIME Motherboard(0x1043-0x876B)"},
{0x1022, 0x15E1, 0x17AA, 0x5124, "ThinkPad E595(0x17AA-0x5124)"},
{0x1022, 0x15E1, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15E2, 0xFFFF, 0xFFFF, "Audio Coprocessor(0x15E2)"},
{0x1022, 0x15E2, 0x17AA, 0x5124, "ThinkPad E595(0x17AA-0x5124)"},
{0x1022, 0x15E2, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15E3, 0xFFFF, 0xFFFF, "Family 17h/19h/1ah HD Audio Controller(0x15E3)"},
{0x1022, 0x15E3, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1022, 0x15E3, 0x103C, 0x8B17, "ProBook 445 G9/455 G9(0x103C-0x8B17)"},
{0x1022, 0x15E3, 0x1043, 0x86C7, "PRIME B450M-A Motherboard(0x1043-0x86C7)"},
{0x1022, 0x15E3, 0x17AA, 0x5124, "ThinkPad E595(0x17AA-0x5124)"},
{0x1022, 0x15E4, 0xFFFF, 0xFFFF, "Sensor Fusion Hub(0x15E4)"},
{0x1022, 0x15E5, 0xFFFF, 0xFFFF, "Raven2 USB 3.1(0x15E5)"},
{0x1022, 0x15E5, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15E6, 0xFFFF, 0xFFFF, "Raven/Raven2/Renoir Non-Sensor Fusion Hub KMDF driver(0x15E6)"},
{0x1022, 0x15E6, 0x1022, 0x15E4, "Raven/Raven2/Renoir Sensor Fusion Hub(0x1022-0x15E4)"},
{0x1022, 0x15E6, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x15E8, 0xFFFF, 0xFFFF, "Raven/Raven2 Device 24: Function 0(0x15E8)"},
{0x1022, 0x15E9, 0xFFFF, 0xFFFF, "Raven/Raven2 Device 24: Function 1(0x15E9)"},
{0x1022, 0x15EA, 0xFFFF, 0xFFFF, "Raven/Raven2 Device 24: Function 2(0x15EA)"},
{0x1022, 0x15EB, 0xFFFF, 0xFFFF, "Raven/Raven2 Device 24: Function 3(0x15EB)"},
{0x1022, 0x15EC, 0xFFFF, 0xFFFF, "Raven/Raven2 Device 24: Function 4(0x15EC)"},
{0x1022, 0x15ED, 0xFFFF, 0xFFFF, "Raven/Raven2 Device 24: Function 5(0x15ED)"},
{0x1022, 0x15EE, 0xFFFF, 0xFFFF, "Raven/Raven2 Device 24: Function 6(0x15EE)"},
{0x1022, 0x15EF, 0xFFFF, 0xFFFF, "Raven/Raven2 Device 24: Function 7(0x15EF)"},
{0x1022, 0x15F0, 0xFFFF, 0xFFFF, "FireFlight Device 24: Function 0(0x15F0)"},
{0x1022, 0x15F1, 0xFFFF, 0xFFFF, "FireFlight Device 24: Function 1(0x15F1)"},
{0x1022, 0x15F2, 0xFFFF, 0xFFFF, "FireFlight Device 24: Function 2(0x15F2)"},
{0x1022, 0x15F3, 0xFFFF, 0xFFFF, "FireFlight Device 24: Function 3(0x15F3)"},
{0x1022, 0x15F4, 0xFFFF, 0xFFFF, "FireFlight Device 24: Function 4(0x15F4)"},
{0x1022, 0x15F5, 0xFFFF, 0xFFFF, "FireFlight Device 24: Function 5(0x15F5)"},
{0x1022, 0x15F6, 0xFFFF, 0xFFFF, "FireFlight Device 24: Function 6(0x15F6)"},
{0x1022, 0x15F7, 0xFFFF, 0xFFFF, "FireFlight Device 24: Function 7(0x15F7)"},
{0x1022, 0x15F8, 0xFFFF, 0xFFFF, "FireFlight Root Complex(0x15F8)"},
{0x1022, 0x15F9, 0xFFFF, 0xFFFF, "FireFlight IOMMU(0x15F9)"},
{0x1022, 0x15FA, 0xFFFF, 0xFFFF, "FireFlight PCIe Dummy Host Bridge(0x15FA)"},
{0x1022, 0x15FB, 0xFFFF, 0xFFFF, "FireFlight PCIe GPP Bride 3:0(0x15FB)"},
{0x1022, 0x15FC, 0xFFFF, 0xFFFF, "FireFlight PCIe Dummy Host Bridge(0x15FC)"},
{0x1022, 0x15FD, 0xFFFF, 0xFFFF, "FireFlight Internal PCIe GPP Bridge 0 to Bus A(0x15FD)"},
{0x1022, 0x15FE, 0xFFFF, 0xFFFF, "FireFlight Internal PCIe GPP Bridge 0 to Bus B(0x15FE)"},
{0x1022, 0x15FF, 0xFFFF, 0xFFFF, "FireFlight Bus A; Device 0: Function 0: Internal GPU(0x15FF)"},
{0x1022, 0x1600, 0xFFFF, 0xFFFF, "Family 15h Processor Function 0(0x1600)"},
{0x1022, 0x1601, 0xFFFF, 0xFFFF, "Family 15h Processor Function 1(0x1601)"},
{0x1022, 0x1602, 0xFFFF, 0xFFFF, "Family 15h Processor Function 2(0x1602)"},
{0x1022, 0x1603, 0xFFFF, 0xFFFF, "Family 15h Processor Function 3(0x1603)"},
{0x1022, 0x1604, 0xFFFF, 0xFFFF, "Family 15h Processor Function 4(0x1604)"},
{0x1022, 0x1605, 0xFFFF, 0xFFFF, "Family 15h Processor Function 5(0x1605)"},
{0x1022, 0x1606, 0xFFFF, 0xFFFF, "Arden Security Processor(0x1606)"},
{0x1022, 0x1608, 0xFFFF, 0xFFFF, "Arden Device 18h: Function 0(0x1608)"},
{0x1022, 0x1609, 0xFFFF, 0xFFFF, "Arden Device 18h: Function 1(0x1609)"},
{0x1022, 0x160A, 0xFFFF, 0xFFFF, "Arden Device 18h: Function 2(0x160A)"},
{0x1022, 0x160B, 0xFFFF, 0xFFFF, "Arden Device 18h: Function 3(0x160B)"},
{0x1022, 0x160C, 0xFFFF, 0xFFFF, "Arden Device 18h: Function 4(0x160C)"},
{0x1022, 0x160D, 0xFFFF, 0xFFFF, "Arden Device 18h: Function 5(0x160D)"},
{0x1022, 0x160E, 0xFFFF, 0xFFFF, "Arden Device 18h: Function 6(0x160E)"},
{0x1022, 0x160F, 0xFFFF, 0xFFFF, "Arden Device 18h: Function 7(0x160F)"},
{0x1022, 0x161A, 0xFFFF, 0xFFFF, "Rembrandt USB4 XHCI controller #1(0x161A)"},
{0x1022, 0x161B, 0xFFFF, 0xFFFF, "Rembrandt USB4 XHCI controller #2(0x161B)"},
{0x1022, 0x161C, 0xFFFF, 0xFFFF, "Rembrandt USB4 XHCI controller #7(0x161C)"},
{0x1022, 0x161D, 0xFFFF, 0xFFFF, "Rembrandt USB4 XHCI controller #3(0x161D)"},
{0x1022, 0x161E, 0xFFFF, 0xFFFF, "Rembrandt USB4 XHCI controller #4(0x161E)"},
{0x1022, 0x161F, 0xFFFF, 0xFFFF, "Rembrandt USB4 XHCI controller #8(0x161F)"},
{0x1022, 0x1620, 0xFFFF, 0xFFFF, "Anubis HT Configuration(0x1620)"},
{0x1022, 0x1621, 0xFFFF, 0xFFFF, "Anubis Address Maps(0x1621)"},
{0x1022, 0x1622, 0xFFFF, 0xFFFF, "Anubis DRAM Configuration(0x1622)"},
{0x1022, 0x1623, 0xFFFF, 0xFFFF, "Anubis Miscellaneous Configuration(0x1623)"},
{0x1022, 0x1624, 0xFFFF, 0xFFFF, "Anubis PM Configuration(0x1624)"},
{0x1022, 0x1625, 0xFFFF, 0xFFFF, "Anubis NB Performance Monitor(0x1625)"},
{0x1022, 0x1626, 0xFFFF, 0xFFFF, "Arden Root Complex(0x1626)"},
{0x1022, 0x1627, 0xFFFF, 0xFFFF, "Arden IOMMU(0x1627)"},
{0x1022, 0x1628, 0xFFFF, 0xFFFF, "Arden PCIe Dummy Host Bridge(0x1628)"},
{0x1022, 0x1629, 0xFFFF, 0xFFFF, "Arden PCIe GPP Bridge(0x1629)"},
{0x1022, 0x162A, 0xFFFF, 0xFFFF, "Arden Internal PCIe GPP Bridge 0 to bus X(0x162A)"},
{0x1022, 0x162B, 0xFFFF, 0xFFFF, "Arden PCIe Non-Transparent Bridge(0x162B)"},
{0x1022, 0x162C, 0xFFFF, 0xFFFF, "VanGogh USB2(0x162C)"},
{0x1022, 0x162E, 0xFFFF, 0xFFFF, "Rembrandt USB4/Thunderbolt NHI controller #1(0x162E)"},
{0x1022, 0x162F, 0xFFFF, 0xFFFF, "Rembrandt USB4/Thunderbolt NHI controller #2(0x162F)"},
{0x1022, 0x1630, 0xFFFF, 0xFFFF, "Renoir/Cezanne Root Complex(0x1630)"},
{0x1022, 0x1631, 0xFFFF, 0xFFFF, "Renoir/Cezanne IOMMU(0x1631)"},
{0x1022, 0x1632, 0xFFFF, 0xFFFF, "Renoir PCIe Dummy Host Bridge(0x1632)"},
{0x1022, 0x1633, 0xFFFF, 0xFFFF, "Renoir PCIe GPP Bridge(0x1633)"},
{0x1022, 0x1634, 0xFFFF, 0xFFFF, "Renoir/Cezanne PCIe GPP Bridge(0x1634)"},
{0x1022, 0x1635, 0xFFFF, 0xFFFF, "Renoir Internal PCIe GPP Bridge to Bus(0x1635)"},
{0x1022, 0x1637, 0xFFFF, 0xFFFF, "Renoir HD Audio Controller(0x1637)"},
{0x1022, 0x1639, 0xFFFF, 0xFFFF, "Renoir/Cezanne USB 3.1(0x1639)"},
{0x1022, 0x163A, 0xFFFF, 0xFFFF, "VanGogh USB0(0x163A)"},
{0x1022, 0x163B, 0xFFFF, 0xFFFF, "VanGogh USB1(0x163B)"},
{0x1022, 0x163C, 0xFFFF, 0xFFFF, "VanGogh SecUSB(0x163C)"},
{0x1022, 0x163D, 0xFFFF, 0xFFFF, "VanGogh SecureFunction(0x163D)"},
{0x1022, 0x163E, 0xFFFF, 0xFFFF, "VanGogh HSP(0x163E)"},
{0x1022, 0x1641, 0xFFFF, 0xFFFF, "Renoir 10GbE Controller Port 0 (XGBE0/1)(0x1641)"},
{0x1022, 0x1642, 0xFFFF, 0xFFFF, "Renoir WLAN(0x1642)"},
{0x1022, 0x1643, 0xFFFF, 0xFFFF, "Renoir BT(0x1643)"},
{0x1022, 0x1644, 0xFFFF, 0xFFFF, "Renoir I2S(0x1644)"},
{0x1022, 0x1645, 0xFFFF, 0xFFFF, "VanGogh Root Complex(0x1645)"},
{0x1022, 0x1646, 0xFFFF, 0xFFFF, "VanGogh IOMMU(0x1646)"},
{0x1022, 0x1647, 0xFFFF, 0xFFFF, "VanGogh PCIe GPP Bridge(0x1647)"},
{0x1022, 0x1648, 0xFFFF, 0xFFFF, "VanGogh Internal PCIe GPP Bridge to Bus(0x1648)"},
{0x1022, 0x1649, 0xFFFF, 0xFFFF, "Family 19h PSP/CCP(0x1649)"},
{0x1022, 0x164A, 0xFFFF, 0xFFFF, "Sensor Fusion Hub(0x164A)"},
{0x1022, 0x164B, 0xFFFF, 0xFFFF, "Non-Sensor Fusion Hub(0x164B)"},
{0x1022, 0x164F, 0xFFFF, 0xFFFF, "Milan IOMMU(0x164F)"},
{0x1022, 0x1650, 0xFFFF, 0xFFFF, "Milan Data Fabric; Function 0(0x1650)"},
{0x1022, 0x1651, 0xFFFF, 0xFFFF, "Milan Data Fabric; Function 1(0x1651)"},
{0x1022, 0x1652, 0xFFFF, 0xFFFF, "Milan Data Fabric; Function 2(0x1652)"},
{0x1022, 0x1653, 0xFFFF, 0xFFFF, "Milan Data Fabric; Function 3(0x1653)"},
{0x1022, 0x1654, 0xFFFF, 0xFFFF, "Milan Data Fabric; Function 4(0x1654)"},
{0x1022, 0x1655, 0xFFFF, 0xFFFF, "Milan Data Fabric; Function 5(0x1655)"},
{0x1022, 0x1656, 0xFFFF, 0xFFFF, "Milan Data Fabric; Function 6(0x1656)"},
{0x1022, 0x1657, 0xFFFF, 0xFFFF, "Milan Data Fabric; Function 7(0x1657)"},
{0x1022, 0x1660, 0xFFFF, 0xFFFF, "VanGogh Data Fabric; Function 0(0x1660)"},
{0x1022, 0x1661, 0xFFFF, 0xFFFF, "VanGogh Data Fabric; Function 1(0x1661)"},
{0x1022, 0x1662, 0xFFFF, 0xFFFF, "VanGogh Data Fabric; Function 2(0x1662)"},
{0x1022, 0x1663, 0xFFFF, 0xFFFF, "VanGogh Data Fabric; Function 3(0x1663)"},
{0x1022, 0x1664, 0xFFFF, 0xFFFF, "VanGogh Data Fabric; Function 4(0x1664)"},
{0x1022, 0x1665, 0xFFFF, 0xFFFF, "VanGogh Data Fabric; Function 5(0x1665)"},
{0x1022, 0x1666, 0xFFFF, 0xFFFF, "VanGogh Data Fabric; Function 6(0x1666)"},
{0x1022, 0x1667, 0xFFFF, 0xFFFF, "VanGogh Data Fabric; Function 7(0x1667)"},
{0x1022, 0x1668, 0xFFFF, 0xFFFF, "Pink Sardine USB4/Thunderbolt NHI controller #1(0x1668)"},
{0x1022, 0x1669, 0xFFFF, 0xFFFF, "Pink Sardine USB4/Thunderbolt NHI controller #2(0x1669)"},
{0x1022, 0x166A, 0xFFFF, 0xFFFF, "Cezanne Data Fabric; Function 0(0x166A)"},
{0x1022, 0x166B, 0xFFFF, 0xFFFF, "Cezanne Data Fabric; Function 1(0x166B)"},
{0x1022, 0x166C, 0xFFFF, 0xFFFF, "Cezanne Data Fabric; Function 2(0x166C)"},
{0x1022, 0x166D, 0xFFFF, 0xFFFF, "Cezanne Data Fabric; Function 3(0x166D)"},
{0x1022, 0x166E, 0xFFFF, 0xFFFF, "Cezanne Data Fabric; Function 4(0x166E)"},
{0x1022, 0x166F, 0xFFFF, 0xFFFF, "Cezanne Data Fabric; Function 5(0x166F)"},
{0x1022, 0x1670, 0xFFFF, 0xFFFF, "Cezanne Data Fabric; Function 6(0x1670)"},
{0x1022, 0x1671, 0xFFFF, 0xFFFF, "Cezanne Data Fabric; Function 7(0x1671)"},
{0x1022, 0x1679, 0xFFFF, 0xFFFF, "Rembrandt Data Fabric: Device 18h; Function 0(0x1679)"},
{0x1022, 0x167A, 0xFFFF, 0xFFFF, "Rembrandt Data Fabric: Device 18h; Function 1(0x167A)"},
{0x1022, 0x167B, 0xFFFF, 0xFFFF, "Rembrandt Data Fabric: Device 18h; Function 2(0x167B)"},
{0x1022, 0x167C, 0xFFFF, 0xFFFF, "Rembrandt Data Fabric: Device 18h; Function 3(0x167C)"},
{0x1022, 0x167D, 0xFFFF, 0xFFFF, "Rembrandt Data Fabric: Device 18h; Function 4(0x167D)"},
{0x1022, 0x167E, 0xFFFF, 0xFFFF, "Rembrandt Data Fabric: Device 18h; Function 5(0x167E)"},
{0x1022, 0x167F, 0xFFFF, 0xFFFF, "Rembrandt Data Fabric: Device 18h; Function 6(0x167F)"},
{0x1022, 0x1680, 0xFFFF, 0xFFFF, "Rembrandt Data Fabric: Device 18h; Function 7(0x1680)"},
{0x1022, 0x16F8, 0xFFFF, 0xFFFF, "Strix Data Fabric; Function 0(0x16F8)"},
{0x1022, 0x16F9, 0xFFFF, 0xFFFF, "Strix Data Fabric; Function 1(0x16F9)"},
{0x1022, 0x16FA, 0xFFFF, 0xFFFF, "Strix Data Fabric; Function 2(0x16FA)"},
{0x1022, 0x16FB, 0xFFFF, 0xFFFF, "Strix Data Fabric; Function 3(0x16FB)"},
{0x1022, 0x16FC, 0xFFFF, 0xFFFF, "Strix Data Fabric; Function 4(0x16FC)"},
{0x1022, 0x16FD, 0xFFFF, 0xFFFF, "Strix Data Fabric; Function 5(0x16FD)"},
{0x1022, 0x16FE, 0xFFFF, 0xFFFF, "Strix Data Fabric; Function 6(0x16FE)"},
{0x1022, 0x16FF, 0xFFFF, 0xFFFF, "Strix Data Fabric; Function 7(0x16FF)"},
{0x1022, 0x1700, 0xFFFF, 0xFFFF, "Family 12h/14h Processor Function 0(0x1700)"},
{0x1022, 0x1701, 0xFFFF, 0xFFFF, "Family 12h/14h Processor Function 1(0x1701)"},
{0x1022, 0x1702, 0xFFFF, 0xFFFF, "Family 12h/14h Processor Function 2(0x1702)"},
{0x1022, 0x1703, 0xFFFF, 0xFFFF, "Family 12h/14h Processor Function 3(0x1703)"},
{0x1022, 0x1704, 0xFFFF, 0xFFFF, "Family 12h/14h Processor Function 4(0x1704)"},
{0x1022, 0x1705, 0xFFFF, 0xFFFF, "Family 12h Processor Root Complex(0x1705)"},
{0x1022, 0x1706, 0xFFFF, 0xFFFF, "Llano P2P Bridge to external GPU(0x1706)"},
{0x1022, 0x1707, 0xFFFF, 0xFFFF, "Family 12h Processor Root Port(0x1707)"},
{0x1022, 0x1708, 0xFFFF, 0xFFFF, "Family 12h Processor Root Port(0x1708)"},
{0x1022, 0x1709, 0xFFFF, 0xFFFF, "Family 12h Processor Root Port(0x1709)"},
{0x1022, 0x170A, 0xFFFF, 0xFFFF, "Family 12h Processor Root Port(0x170A)"},
{0x1022, 0x170B, 0xFFFF, 0xFFFF, "Family 12h Processor Root Port(0x170B)"},
{0x1022, 0x170C, 0xFFFF, 0xFFFF, "Family 12h Processor Root Port(0x170C)"},
{0x1022, 0x170D, 0xFFFF, 0xFFFF, "Family 12h Processor Root Port(0x170D)"},
{0x1022, 0x1716, 0xFFFF, 0xFFFF, "Family 12h/14h Processor Function 5(0x1716)"},
{0x1022, 0x1718, 0xFFFF, 0xFFFF, "Family 12h/14h Processor Function 6(0x1718)"},
{0x1022, 0x1719, 0xFFFF, 0xFFFF, "Family 12h/14h Processor Function 7(0x1719)"},
{0x1022, 0x17E0, 0xFFFF, 0xFFFF, "Strix/Krackan/Strix Halo CCP/ASP(0x17E0)"},
{0x1022, 0x17F0, 0xFFFF, 0xFFFF, "Strix/Krackan/Strix Halo Neural Processing Unit(0x17F0)"},
{0x1022, 0x2000, 0xFFFF, 0xFFFF, "79C97x [PCnet32 LANCE](0x2000)"},
{0x1022, 0x2000, 0x1014, 0x2000, "NetFinity 10/100 Fast Ethernet(0x1014-0x2000)"},
{0x1022, 0x2000, 0x1022, 0x2000, "PCnet - Fast 79C971(0x1022-0x2000)"},
{0x1022, 0x2000, 0x103C, 0x104C, "Ethernet with LAN remote power Adapter(0x103C-0x104C)"},
{0x1022, 0x2000, 0x103C, 0x1064, "Ethernet with LAN remote power Adapter(0x103C-0x1064)"},
{0x1022, 0x2000, 0x103C, 0x1065, "Ethernet with LAN remote power Adapter(0x103C-0x1065)"},
{0x1022, 0x2000, 0x103C, 0x106C, "Ethernet with LAN remote power Adapter(0x103C-0x106C)"},
{0x1022, 0x2000, 0x103C, 0x106E, "Ethernet with LAN remote power Adapter(0x103C-0x106E)"},
{0x1022, 0x2000, 0x103C, 0x10EA, "Ethernet with LAN remote power Adapter(0x103C-0x10EA)"},
{0x1022, 0x2000, 0x1113, 0x1220, "EN1220 10/100 Fast Ethernet(0x1113-0x1220)"},
{0x1022, 0x2000, 0x1259, 0x2450, "AT-2450 10/100 Fast Ethernet(0x1259-0x2450)"},
{0x1022, 0x2000, 0x1259, 0x2454, "AT-2450v4 10Mb Ethernet Adapter(0x1259-0x2454)"},
{0x1022, 0x2000, 0x1259, 0x2700, "AT-2700TX 10/100 Fast Ethernet(0x1259-0x2700)"},
{0x1022, 0x2000, 0x1259, 0x2701, "AT-2700FX 100Mb Ethernet(0x1259-0x2701)"},
{0x1022, 0x2000, 0x1259, 0x2702, "AT-2700FTX (AM79C976KD [PCnet-PRO] chipset) 10/100 Mb Fiber/Copper Fast Ethernet(0x1259-0x2702)"},
{0x1022, 0x2000, 0x1259, 0x2703, "AT-2701FX(0x1259-0x2703)"},
{0x1022, 0x2000, 0x1259, 0x2704, "AT-2701FTX 10/100 Mb Fiber/Copper Fast Ethernet(0x1259-0x2704)"},
{0x1022, 0x2000, 0x4C53, 0x1000, "CC7/CR7/CP7/VC7/VP7/VR7 mainboard(0x4C53-0x1000)"},
{0x1022, 0x2000, 0x4C53, 0x1010, "CP5/CR6 mainboard(0x4C53-0x1010)"},
{0x1022, 0x2000, 0x4C53, 0x1020, "VR6 mainboard(0x4C53-0x1020)"},
{0x1022, 0x2000, 0x4C53, 0x1030, "PC5 mainboard(0x4C53-0x1030)"},
{0x1022, 0x2000, 0x4C53, 0x1040, "CL7 mainboard(0x4C53-0x1040)"},
{0x1022, 0x2000, 0x4C53, 0x1060, "PC7 mainboard(0x4C53-0x1060)"},
{0x1022, 0x2001, 0xFFFF, 0xFFFF, "Am79C978 PCnet Home (HomePNA) 1/10 PCI Ethernet Adapter [Am79C971 PHY](0x2001)"},
{0x1022, 0x2001, 0x1092, 0x0A78, "Multimedia Home Network Adapter(0x1092-0x0A78)"},
{0x1022, 0x2001, 0x1668, 0x0299, "ActionLink Home Network Adapter(0x1668-0x0299)"},
{0x1022, 0x2003, 0xFFFF, 0xFFFF, "Am 1771 MBW [Alchemy](0x2003)"},
{0x1022, 0x2020, 0xFFFF, 0xFFFF, "AM53/79C974 [PC-SCSI](0x2020)"},
{0x1022, 0x2020, 0x1AF4, 0x1100, "QEMU Virtual Machine(0x1AF4-0x1100)"},
{0x1022, 0x2040, 0xFFFF, 0xFFFF, "79c974(0x2040)"},
{0x1022, 0x2080, 0xFFFF, 0xFFFF, "CS5536 [Geode companion] Host Bridge(0x2080)"},
{0x1022, 0x2081, 0xFFFF, 0xFFFF, "Geode LX Video(0x2081)"},
{0x1022, 0x2082, 0xFFFF, 0xFFFF, "Geode LX AES Security Block(0x2082)"},
{0x1022, 0x208F, 0xFFFF, 0xFFFF, "CS5536 GeodeLink PCI South Bridge(0x208F)"},
{0x1022, 0x2090, 0xFFFF, 0xFFFF, "CS5536 [Geode companion] ISA(0x2090)"},
{0x1022, 0x2091, 0xFFFF, 0xFFFF, "CS5536 [Geode companion] FLASH(0x2091)"},
{0x1022, 0x2093, 0xFFFF, 0xFFFF, "CS5536 [Geode companion] Audio(0x2093)"},
{0x1022, 0x2094, 0xFFFF, 0xFFFF, "CS5536 [Geode companion] OHC(0x2094)"},
{0x1022, 0x2095, 0xFFFF, 0xFFFF, "CS5536 [Geode companion] EHC(0x2095)"},
{0x1022, 0x2096, 0xFFFF, 0xFFFF, "CS5536 [Geode companion] UDC(0x2096)"},
{0x1022, 0x2097, 0xFFFF, 0xFFFF, "CS5536 [Geode companion] UOC(0x2097)"},
{0x1022, 0x209A, 0xFFFF, 0xFFFF, "CS5536 [Geode companion] IDE(0x209A)"},
{0x1022, 0x2625, 0xFFFF, 0xFFFF, "Am79C973 [Lance/PCI PCNet/32](0x2625)"},
{0x1022, 0x2627, 0xFFFF, 0xFFFF, "Am79C975 [Lance/PCI PCNet/32](0x2627)"},
{0x1022, 0x3000, 0xFFFF, 0xFFFF, "ELanSC520 Microcontroller(0x3000)"},
{0x1022, 0x43A0, 0xFFFF, 0xFFFF, "Hudson PCI to PCI bridge (PCIE port 0)(0x43A0)"},
{0x1022, 0x43A1, 0xFFFF, 0xFFFF, "Hudson PCI to PCI bridge (PCIE port 1)(0x43A1)"},
{0x1022, 0x43A2, 0xFFFF, 0xFFFF, "Hudson PCI to PCI bridge (PCIE port 2)(0x43A2)"},
{0x1022, 0x43A3, 0xFFFF, 0xFFFF, "Hudson PCI to PCI bridge (PCIE port 3)(0x43A3)"},
{0x1022, 0x43B0, 0xFFFF, 0xFFFF, "X370 Series Chipset PCIe Upstream Port(0x43B0)"},
{0x1022, 0x43B0, 0x1849, 0x43C6, "Fatal1ty X370 Professional Gaming(0x1849-0x43C6)"},
{0x1022, 0x43B1, 0xFFFF, 0xFFFF, "X399 Series Chipset PCIe Bridge(0x43B1)"},
{0x1022, 0x43B4, 0xFFFF, 0xFFFF, "300 Series Chipset PCIe Port(0x43B4)"},
{0x1022, 0x43B5, 0xFFFF, 0xFFFF, "X370 Series Chipset SATA Controller(0x43B5)"},
{0x1022, 0x43B5, 0x1849, 0x43C8, "Fatal1ty X370 Professional Gaming(0x1849-0x43C8)"},
{0x1022, 0x43B6, 0xFFFF, 0xFFFF, "X399 Series Chipset SATA Controller(0x43B6)"},
{0x1022, 0x43B7, 0xFFFF, 0xFFFF, "300 Series Chipset SATA Controller(0x43B7)"},
{0x1022, 0x43B8, 0xFFFF, 0xFFFF, "A320 Chipset SATA Controller [AHCI mode](0x43B8)"},
{0x1022, 0x43B9, 0xFFFF, 0xFFFF, "X370 Series Chipset USB 3.1 xHCI Controller(0x43B9)"},
{0x1022, 0x43B9, 0x1849, 0x43D0, "Fatal1ty X370 Professional Gaming(0x1849-0x43D0)"},
{0x1022, 0x43BA, 0xFFFF, 0xFFFF, "X399 Series Chipset USB 3.1 xHCI Controller(0x43BA)"},
{0x1022, 0x43BB, 0xFFFF, 0xFFFF, "300 Series Chipset USB 3.1 xHCI Controller(0x43BB)"},
{0x1022, 0x43BC, 0xFFFF, 0xFFFF, "A320 USB 3.1 XHCI Host Controller(0x43BC)"},
{0x1022, 0x43C6, 0xFFFF, 0xFFFF, "400 Series Chipset PCIe Bridge(0x43C6)"},
{0x1022, 0x43C7, 0xFFFF, 0xFFFF, "400 Series Chipset PCIe Port(0x43C7)"},
{0x1022, 0x43C8, 0xFFFF, 0xFFFF, "400 Series Chipset SATA Controller(0x43C8)"},
{0x1022, 0x43D5, 0xFFFF, 0xFFFF, "400 Series Chipset USB 3.1 xHCI Compliant Host Controller(0x43D5)"},
{0x1022, 0x43E9, 0xFFFF, 0xFFFF, "500 Series Chipset Switch Upstream Port(0x43E9)"},
{0x1022, 0x43EA, 0xFFFF, 0xFFFF, "500 Series Chipset Switch Downstream Port(0x43EA)"},
{0x1022, 0x43EB, 0xFFFF, 0xFFFF, "500 Series Chipset SATA Controller(0x43EB)"},
{0x1022, 0x43EB, 0x1B21, 0x1062, "ASM1062 Serial ATA Controller(0x1B21-0x1062)"},
{0x1022, 0x43EC, 0xFFFF, 0xFFFF, "A520 Series Chipset USB 3.1 XHCI Controller(0x43EC)"},
{0x1022, 0x43EE, 0xFFFF, 0xFFFF, "500 Series Chipset USB 3.1 XHCI Controller(0x43EE)"},
{0x1022, 0x43EE, 0x1B21, 0x1142, "ASM1042A USB 3.0 Host Controller(0x1B21-0x1142)"},
{0x1022, 0x43F4, 0xFFFF, 0xFFFF, "600 Series Chipset PCIe Switch Upstream Port(0x43F4)"},
{0x1022, 0x43F5, 0xFFFF, 0xFFFF, "600 Series Chipset PCIe Switch Downstream Port(0x43F5)"},
{0x1022, 0x43F6, 0xFFFF, 0xFFFF, "600 Series Chipset SATA Controller(0x43F6)"},
{0x1022, 0x43F7, 0xFFFF, 0xFFFF, "600 Series Chipset USB 3.2 Controller(0x43F7)"},
{0x1022, 0x43FC, 0xFFFF, 0xFFFF, "800 Series Chipset USB 3.x XHCI Controller(0x43FC)"},
{0x1022, 0x43FD, 0xFFFF, 0xFFFF, "800 Series Chipset USB 3.x XHCI Controller(0x43FD)"},
{0x1022, 0x57A3, 0xFFFF, 0xFFFF, "Matisse PCIe GPP Bridge(0x57A3)"},
{0x1022, 0x57A4, 0xFFFF, 0xFFFF, "Matisse PCIe GPP Bridge(0x57A4)"},
{0x1022, 0x57AD, 0xFFFF, 0xFFFF, "Matisse Switch Upstream(0x57AD)"},
{0x1022, 0x7006, 0xFFFF, 0xFFFF, "AMD-751 [Irongate] System Controller(0x7006)"},
{0x1022, 0x7007, 0xFFFF, 0xFFFF, "AMD-751 [Irongate] AGP Bridge(0x7007)"},
{0x1022, 0x700A, 0xFFFF, 0xFFFF, "AMD-IGR4 AGP Host to PCI Bridge(0x700A)"},
{0x1022, 0x700B, 0xFFFF, 0xFFFF, "AMD-IGR4 PCI to PCI Bridge(0x700B)"},
{0x1022, 0x700C, 0xFFFF, 0xFFFF, "AMD-760 MP [IGD4-2P] System Controller(0x700C)"},
{0x1022, 0x700D, 0xFFFF, 0xFFFF, "AMD-760 MP [IGD4-2P] AGP Bridge(0x700D)"},
{0x1022, 0x700E, 0xFFFF, 0xFFFF, "AMD-760 [IGD4-1P] System Controller(0x700E)"},
{0x1022, 0x700F, 0xFFFF, 0xFFFF, "AMD-760 [IGD4-1P] AGP Bridge(0x700F)"},
{0x1022, 0x7400, 0xFFFF, 0xFFFF, "AMD-755 [Cobra] ISA(0x7400)"},
{0x1022, 0x7401, 0xFFFF, 0xFFFF, "AMD-755 [Cobra] IDE(0x7401)"},
{0x1022, 0x7403, 0xFFFF, 0xFFFF, "AMD-755 [Cobra] ACPI(0x7403)"},
{0x1022, 0x7404, 0xFFFF, 0xFFFF, "AMD-755 [Cobra] USB(0x7404)"},
{0x1022, 0x7408, 0xFFFF, 0xFFFF, "AMD-756 [Viper] ISA(0x7408)"},
{0x1022, 0x7409, 0xFFFF, 0xFFFF, "AMD-756 [Viper] IDE(0x7409)"},
{0x1022, 0x740B, 0xFFFF, 0xFFFF, "AMD-756 [Viper] ACPI(0x740B)"},
{0x1022, 0x740C, 0xFFFF, 0xFFFF, "AMD-756 [Viper] USB(0x740C)"},
{0x1022, 0x7410, 0xFFFF, 0xFFFF, "AMD-766 [ViperPlus] ISA(0x7410)"},
{0x1022, 0x7411, 0xFFFF, 0xFFFF, "AMD-766 [ViperPlus] IDE(0x7411)"},
{0x1022, 0x7413, 0xFFFF, 0xFFFF, "AMD-766 [ViperPlus] ACPI(0x7413)"},
{0x1022, 0x7414, 0xFFFF, 0xFFFF, "AMD-766 [ViperPlus] USB(0x7414)"},
{0x1022, 0x7440, 0xFFFF, 0xFFFF, "AMD-768 [Opus] ISA(0x7440)"},
{0x1022, 0x7440, 0x1043, 0x8044, "A7M-D Mainboard(0x1043-0x8044)"},
{0x1022, 0x7441, 0xFFFF, 0xFFFF, "AMD-768 [Opus] IDE(0x7441)"},
{0x1022, 0x7443, 0xFFFF, 0xFFFF, "AMD-768 [Opus] ACPI(0x7443)"},
{0x1022, 0x7443, 0x1043, 0x8044, "A7M-D Mainboard(0x1043-0x8044)"},
{0x1022, 0x7445, 0xFFFF, 0xFFFF, "AMD-768 [Opus] Audio(0x7445)"},
{0x1022, 0x7446, 0xFFFF, 0xFFFF, "AMD-768 [Opus] MC97 Modem(0x7446)"},
{0x1022, 0x7448, 0xFFFF, 0xFFFF, "AMD-768 [Opus] PCI(0x7448)"},
{0x1022, 0x7449, 0xFFFF, 0xFFFF, "AMD-768 [Opus] USB(0x7449)"},
{0x1022, 0x7450, 0xFFFF, 0xFFFF, "AMD-8131 PCI-X Bridge(0x7450)"},
{0x1022, 0x7451, 0xFFFF, 0xFFFF, "AMD-8131 PCI-X IOAPIC(0x7451)"},
{0x1022, 0x7454, 0xFFFF, 0xFFFF, "AMD-8151 System Controller(0x7454)"},
{0x1022, 0x7455, 0xFFFF, 0xFFFF, "AMD-8151 AGP Bridge(0x7455)"},
{0x1022, 0x7458, 0xFFFF, 0xFFFF, "AMD-8132 PCI-X Bridge(0x7458)"},
{0x1022, 0x7459, 0xFFFF, 0xFFFF, "AMD-8132 PCI-X IOAPIC(0x7459)"},
{0x1022, 0x7460, 0xFFFF, 0xFFFF, "AMD-8111 PCI(0x7460)"},
{0x1022, 0x7460, 0x161F, 0x3017, "HDAMB(0x161F-0x3017)"},
{0x1022, 0x7461, 0xFFFF, 0xFFFF, "AMD-8111 USB(0x7461)"},
{0x1022, 0x7462, 0xFFFF, 0xFFFF, "AMD-8111 Ethernet(0x7462)"},
{0x1022, 0x7463, 0xFFFF, 0xFFFF, "AMD-8111 USB EHCI(0x7463)"},
{0x1022, 0x7464, 0xFFFF, 0xFFFF, "AMD-8111 USB OHCI(0x7464)"},
{0x1022, 0x7464, 0x161F, 0x3017, "HDAMB(0x161F-0x3017)"},
{0x1022, 0x7468, 0xFFFF, 0xFFFF, "AMD-8111 LPC(0x7468)"},
{0x1022, 0x7468, 0x161F, 0x3017, "HDAMB(0x161F-0x3017)"},
{0x1022, 0x7469, 0xFFFF, 0xFFFF, "AMD-8111 IDE(0x7469)"},
{0x1022, 0x7469, 0x1022, 0x2B80, "AMD-8111 IDE [Quartet](0x1022-0x2B80)"},
{0x1022, 0x7469, 0x161F, 0x3017, "HDAMB(0x161F-0x3017)"},
{0x1022, 0x746A, 0xFFFF, 0xFFFF, "AMD-8111 SMBus 2.0(0x746A)"},
{0x1022, 0x746B, 0xFFFF, 0xFFFF, "AMD-8111 ACPI(0x746B)"},
{0x1022, 0x746B, 0x161F, 0x3017, "HDAMB(0x161F-0x3017)"},
{0x1022, 0x746D, 0xFFFF, 0xFFFF, "AMD-8111 AC97 Audio(0x746D)"},
{0x1022, 0x746D, 0x161F, 0x3017, "HDAMB(0x161F-0x3017)"},
{0x1022, 0x746E, 0xFFFF, 0xFFFF, "AMD-8111 MC97 Modem(0x746E)"},
{0x1022, 0x756B, 0xFFFF, 0xFFFF, "AMD-8111 ACPI(0x756B)"},
{0x1022, 0x7800, 0xFFFF, 0xFFFF, "FCH SATA Controller [IDE mode](0x7800)"},
{0x1022, 0x7801, 0xFFFF, 0xFFFF, "FCH SATA Controller [AHCI mode](0x7801)"},
{0x1022, 0x7801, 0x103C, 0x168B, "ProBook 4535s Notebook(0x103C-0x168B)"},
{0x1022, 0x7801, 0x103C, 0x194E, "ProBook 455 G1 Notebook(0x103C-0x194E)"},
{0x1022, 0x7801, 0x1043, 0x8623, "AM1I-A Motherboard(0x1043-0x8623)"},
{0x1022, 0x7801, 0x17AA, 0x3988, "Z50-75(0x17AA-0x3988)"},
{0x1022, 0x7801, 0x1849, 0x7801, "QC5000-ITX/PH(0x1849-0x7801)"},
{0x1022, 0x7802, 0xFFFF, 0xFFFF, "FCH SATA Controller [RAID mode](0x7802)"},
{0x1022, 0x7803, 0xFFFF, 0xFFFF, "FCH SATA Controller [RAID mode](0x7803)"},
{0x1022, 0x7804, 0xFFFF, 0xFFFF, "FCH SATA Controller [AHCI mode](0x7804)"},
{0x1022, 0x7804, 0x103C, 0x1985, "Pavilion 17-e163sg Notebook PC(0x103C-0x1985)"},
{0x1022, 0x7805, 0xFFFF, 0xFFFF, "FCH SATA Controller [RAID mode](0x7805)"},
{0x1022, 0x7806, 0xFFFF, 0xFFFF, "FCH SD Flash Controller(0x7806)"},
{0x1022, 0x7807, 0xFFFF, 0xFFFF, "FCH USB OHCI Controller(0x7807)"},
{0x1022, 0x7807, 0x103C, 0x194E, "ProBook 455 G1 Notebook(0x103C-0x194E)"},
{0x1022, 0x7807, 0x103C, 0x1985, "Pavilion 17-e163sg Notebook PC(0x103C-0x1985)"},
{0x1022, 0x7807, 0x1043, 0x8623, "AM1I-A Motherboard(0x1043-0x8623)"},
{0x1022, 0x7807, 0x17AA, 0x3988, "Z50-75(0x17AA-0x3988)"},
{0x1022, 0x7807, 0x1849, 0x7807, "QC5000-ITX/PH(0x1849-0x7807)"},
{0x1022, 0x7808, 0xFFFF, 0xFFFF, "FCH USB EHCI Controller(0x7808)"},
{0x1022, 0x7808, 0x103C, 0x194E, "ProBook 455 G1 Notebook(0x103C-0x194E)"},
{0x1022, 0x7808, 0x103C, 0x1985, "Pavilion 17-e163sg Notebook PC(0x103C-0x1985)"},
{0x1022, 0x7808, 0x1043, 0x8623, "AM1I-A Motherboard(0x1043-0x8623)"},
{0x1022, 0x7808, 0x17AA, 0x3988, "Z50-75(0x17AA-0x3988)"},
{0x1022, 0x7808, 0x1849, 0x7808, "QC5000-ITX/PH(0x1849-0x7808)"},
{0x1022, 0x7809, 0xFFFF, 0xFFFF, "FCH USB OHCI Controller(0x7809)"},
{0x1022, 0x7809, 0x103C, 0x194E, "ProBook 455 G1 Notebook(0x103C-0x194E)"},
{0x1022, 0x7809, 0x17AA, 0x3988, "Z50-75(0x17AA-0x3988)"},
{0x1022, 0x780A, 0xFFFF, 0xFFFF, "Kabini/Mullins SATA Raid/AHCI Mode (DotHill driver)(0x780A)"},
{0x1022, 0x780B, 0xFFFF, 0xFFFF, "FCH SMBus Controller(0x780B)"},
{0x1022, 0x780B, 0x103C, 0x194E, "ProBook 455 G1 Notebook(0x103C-0x194E)"},
{0x1022, 0x780B, 0x103C, 0x1985, "Pavilion 17-e163sg Notebook PC(0x103C-0x1985)"},
{0x1022, 0x780B, 0x1043, 0x8623, "AM1I-A Motherboard(0x1043-0x8623)"},
{0x1022, 0x780B, 0x17AA, 0x3988, "Z50-75(0x17AA-0x3988)"},
{0x1022, 0x780B, 0x1849, 0x780B, "QC5000-ITX/PH(0x1849-0x780B)"},
{0x1022, 0x780C, 0xFFFF, 0xFFFF, "FCH IDE Controller(0x780C)"},
{0x1022, 0x780D, 0xFFFF, 0xFFFF, "FCH Azalia Controller(0x780D)"},
{0x1022, 0x780D, 0x103C, 0x194E, "ProBook 455 G1 Notebook(0x103C-0x194E)"},
{0x1022, 0x780D, 0x103C, 0x1985, "Pavilion 17-e163sg Notebook PC(0x103C-0x1985)"},
{0x1022, 0x780D, 0x1043, 0x8444, "F2A85-M Series(0x1043-0x8444)"},
{0x1022, 0x780D, 0x1043, 0x8576, "AM1I-A Motherboard(0x1043-0x8576)"},
{0x1022, 0x780D, 0x17AA, 0x3988, "Z50-75(0x17AA-0x3988)"},
{0x1022, 0x780D, 0x1849, 0x8892, "QC5000-ITX/PH(0x1849-0x8892)"},
{0x1022, 0x780E, 0xFFFF, 0xFFFF, "FCH LPC Bridge(0x780E)"},
{0x1022, 0x780E, 0x103C, 0x194E, "ProBook 455 G1 Notebook(0x103C-0x194E)"},
{0x1022, 0x780E, 0x103C, 0x1985, "Pavilion 17-e163sg Notebook PC(0x103C-0x1985)"},
{0x1022, 0x780E, 0x1043, 0x8623, "AM1I-A Motherboard(0x1043-0x8623)"},
{0x1022, 0x780E, 0x17AA, 0x3988, "Z50-75(0x17AA-0x3988)"},
{0x1022, 0x780E, 0x1849, 0x780E, "QC5000-ITX/PH(0x1849-0x780E)"},
{0x1022, 0x780F, 0xFFFF, 0xFFFF, "FCH PCI Bridge(0x780F)"},
{0x1022, 0x7812, 0xFFFF, 0xFFFF, "FCH USB XHCI Controller(0x7812)"},
{0x1022, 0x7813, 0xFFFF, 0xFFFF, "FCH SD Flash Controller(0x7813)"},
{0x1022, 0x7814, 0xFFFF, 0xFFFF, "FCH USB XHCI Controller(0x7814)"},
{0x1022, 0x7814, 0x103C, 0x194E, "ProBook 455 G1 Notebook(0x103C-0x194E)"},
{0x1022, 0x7814, 0x103C, 0x1985, "Pavilion 17-e163sg Notebook PC(0x103C-0x1985)"},
{0x1022, 0x7814, 0x1043, 0x8623, "AM1I-A Motherboard(0x1043-0x8623)"},
{0x1022, 0x7814, 0x17AA, 0x3988, "Z50-75(0x17AA-0x3988)"},
{0x1022, 0x7814, 0x1849, 0x7814, "QC5000-ITX/PH(0x1849-0x7814)"},
{0x1022, 0x7900, 0xFFFF, 0xFFFF, "FCH SATA Controller [IDE mode](0x7900)"},
{0x1022, 0x7901, 0xFFFF, 0xFFFF, "FCH SATA Controller [AHCI mode](0x7901)"},
{0x1022, 0x7901, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1022, 0x7901, 0x1043, 0x876B, "PRIME Motherboard(0x1043-0x876B)"},
{0x1022, 0x7901, 0x1462, 0x7C37, "X570-A PRO motherboard(0x1462-0x7C37)"},
{0x1022, 0x7901, 0x15D9, 0x7901, "H12SSL-i(0x15D9-0x7901)"},
{0x1022, 0x7901, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x7902, 0xFFFF, 0xFFFF, "FCH SATA Controller [RAID mode](0x7902)"},
{0x1022, 0x7903, 0xFFFF, 0xFFFF, "FCH SATA Controller [RAID mode](0x7903)"},
{0x1022, 0x7904, 0xFFFF, 0xFFFF, "FCH SATA Controller [AHCI mode](0x7904)"},
{0x1022, 0x7906, 0xFFFF, 0xFFFF, "FCH SD Flash Controller(0x7906)"},
{0x1022, 0x7908, 0xFFFF, 0xFFFF, "FCH USB EHCI Controller(0x7908)"},
{0x1022, 0x790B, 0xFFFF, 0xFFFF, "FCH SMBus Controller(0x790B)"},
{0x1022, 0x790B, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1022, 0x790B, 0x103C, 0x8B17, "ProBook 445 G9/455 G9(0x103C-0x8B17)"},
{0x1022, 0x790B, 0x1043, 0x876B, "PRIME Motherboard(0x1043-0x876B)"},
{0x1022, 0x790B, 0x1462, 0x7C37, "X570-A PRO motherboard(0x1462-0x7C37)"},
{0x1022, 0x790B, 0x15D9, 0x790B, "H12SSL-i(0x15D9-0x790B)"},
{0x1022, 0x790B, 0x17AA, 0x5124, "ThinkPad E595(0x17AA-0x5124)"},
{0x1022, 0x790B, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x790E, 0xFFFF, 0xFFFF, "FCH LPC Bridge(0x790E)"},
{0x1022, 0x790E, 0x103C, 0x8615, "Pavilion Laptop 15-cw1xxx(0x103C-0x8615)"},
{0x1022, 0x790E, 0x1043, 0x876B, "PRIME B450M-A Motherboard(0x1043-0x876B)"},
{0x1022, 0x790E, 0x1462, 0x7C37, "X570-A PRO motherboard(0x1462-0x7C37)"},
{0x1022, 0x790E, 0x15D9, 0x790E, "H12SSL-i(0x15D9-0x790E)"},
{0x1022, 0x790E, 0x17AA, 0x5124, "ThinkPad E595(0x17AA-0x5124)"},
{0x1022, 0x790E, 0xEA50, 0xCE19, "mCOM10-L1900(0xEA50-0xCE19)"},
{0x1022, 0x790F, 0xFFFF, 0xFFFF, "FCH PCI Bridge(0x790F)"},
{0x1022, 0x7914, 0xFFFF, 0xFFFF, "FCH USB XHCI Controller(0x7914)"},
{0x1022, 0x9600, 0xFFFF, 0xFFFF, "RS780 Host Bridge(0x9600)"},
{0x1022, 0x9600, 0x1043, 0x82EE, "M378A-CM Motherboard(0x1043-0x82EE)"},
{0x1022, 0x9600, 0x1043, 0x82F1, "M3A78-EH Motherboard(0x1043-0x82F1)"},
{0x1022, 0x9601, 0xFFFF, 0xFFFF, "RS880 Host Bridge(0x9601)"},
{0x1022, 0x9601, 0x1019, 0x2120, "A785GM-M(0x1019-0x2120)"},
{0x1022, 0x9601, 0x1028, 0x0433, "Optiplex 580(0x1028-0x0433)"},
{0x1022, 0x9601, 0x103C, 0x1609, "ProLiant MicroServer N36L(0x103C-0x1609)"},
{0x1022, 0x9601, 0x1043, 0x83A2, "M4A785-M Mainboard(0x1043-0x83A2)"},
{0x1022, 0x9601, 0x1043, 0x843E, "M5A88-V EVO(0x1043-0x843E)"},
{0x1022, 0x9602, 0xFFFF, 0xFFFF, "RS780/RS880 PCI to PCI bridge (int gfx)(0x9602)"},
{0x1022, 0x9603, 0xFFFF, 0xFFFF, "RS780 PCI to PCI bridge (ext gfx port 0)(0x9603)"},
{0x1022, 0x9603, 0x1028, 0x0433, "Optiplex 580(0x1028-0x0433)"},
{0x1022, 0x9603, 0x103C, 0x1609, "ProLiant MicroServer N36L(0x103C-0x1609)"},
{0x1022, 0x9604, 0xFFFF, 0xFFFF, "RS780/RS880 PCI to PCI bridge (PCIE port 0)(0x9604)"},
{0x1022, 0x9604, 0x1028, 0x0433, "OptiPlex 580(0x1028-0x0433)"},
{0x1022, 0x9605, 0xFFFF, 0xFFFF, "RS780/RS880 PCI to PCI bridge (PCIE port 1)(0x9605)"},
{0x1022, 0x9606, 0xFFFF, 0xFFFF, "RS780 PCI to PCI bridge (PCIE port 2)(0x9606)"},
{0x1022, 0x9606, 0x103C, 0x1609, "ProLiant MicroServer N36L(0x103C-0x1609)"},
{0x1022, 0x9607, 0xFFFF, 0xFFFF, "RS780/RS880 PCI to PCI bridge (PCIE port 3)(0x9607)"},
{0x1022, 0x9608, 0xFFFF, 0xFFFF, "RS780/RS880 PCI to PCI bridge (PCIE port 4)(0x9608)"},
{0x1022, 0x9608, 0x1028, 0x0433, "OptiPlex 580(0x1028-0x0433)"},
{0x1022, 0x9609, 0xFFFF, 0xFFFF, "RS780/RS880 PCI to PCI bridge (PCIE port 5)(0x9609)"},
{0x1022, 0x960A, 0xFFFF, 0xFFFF, "RS780 PCI to PCI bridge (NB-SB link)(0x960A)"},
{0x1022, 0x960B, 0xFFFF, 0xFFFF, "RS780 PCI to PCI bridge (ext gfx port 1)(0x960B)"},
{0x1022, 0xB000, 0xFFFF, 0xFFFF, "RAID Bottom Device(0xB000)"},
}; /* pci_vid_1022[] */

static pci_id_t const pci_vid_1023[] = {
{0x1023, 0xFFFF, 0xFFFF, 0xFFFF, "Trident Microsystems(0x1023)"},
{0x1023, 0x0194, 0xFFFF, 0xFFFF, "82C194(0x0194)"},
{0x1023, 0x2000, 0xFFFF, 0xFFFF, "4DWave DX(0x2000)"},
{0x1023, 0x2001, 0xFFFF, 0xFFFF, "4DWave NX(0x2001)"},
{0x1023, 0x2001, 0x122D, 0x1400, "Trident PCI288-Q3DII (NX)(0x122D-0x1400)"},
{0x1023, 0x2100, 0xFFFF, 0xFFFF, "CyberBlade XP4m32(0x2100)"},
{0x1023, 0x2200, 0xFFFF, 0xFFFF, "XGI Volari XP5(0x2200)"},
{0x1023, 0x8400, 0xFFFF, 0xFFFF, "CyberBlade/i7(0x8400)"},
{0x1023, 0x8400, 0x1023, 0x8400, "CyberBlade i7 AGP(0x1023-0x8400)"},
{0x1023, 0x8420, 0xFFFF, 0xFFFF, "CyberBlade/i7d(0x8420)"},
{0x1023, 0x8420, 0x0E11, 0xB15A, "CyberBlade i7 AGP(0x0E11-0xB15A)"},
{0x1023, 0x8500, 0xFFFF, 0xFFFF, "CyberBlade/i1(0x8500)"},
{0x1023, 0x8520, 0xFFFF, 0xFFFF, "CyberBlade i1(0x8520)"},
{0x1023, 0x8520, 0x0E11, 0xB16E, "CyberBlade i1 AGP(0x0E11-0xB16E)"},
{0x1023, 0x8520, 0x1023, 0x8520, "CyberBlade i1 AGP(0x1023-0x8520)"},
{0x1023, 0x8620, 0xFFFF, 0xFFFF, "CyberBlade/i1(0x8620)"},
{0x1023, 0x8620, 0x1014, 0x0502, "ThinkPad R30/T30(0x1014-0x0502)"},
{0x1023, 0x8620, 0x1014, 0x1025, "Travelmate 352TE(0x1014-0x1025)"},
{0x1023, 0x8820, 0xFFFF, 0xFFFF, "CyberBlade XPAi1(0x8820)"},
{0x1023, 0x9320, 0xFFFF, 0xFFFF, "TGUI 9320(0x9320)"},
{0x1023, 0x9350, 0xFFFF, 0xFFFF, "GUI Accelerator(0x9350)"},
{0x1023, 0x9360, 0xFFFF, 0xFFFF, "Flat panel GUI Accelerator(0x9360)"},
{0x1023, 0x9382, 0xFFFF, 0xFFFF, "Cyber 9382 [Reference design](0x9382)"},
{0x1023, 0x9383, 0xFFFF, 0xFFFF, "Cyber 9383 [Reference design](0x9383)"},
{0x1023, 0x9385, 0xFFFF, 0xFFFF, "Cyber 9385 [Reference design](0x9385)"},
{0x1023, 0x9386, 0xFFFF, 0xFFFF, "Cyber 9386(0x9386)"},
{0x1023, 0x9388, 0xFFFF, 0xFFFF, "Cyber 9388(0x9388)"},
{0x1023, 0x9397, 0xFFFF, 0xFFFF, "Cyber 9397(0x9397)"},
{0x1023, 0x939A, 0xFFFF, 0xFFFF, "Cyber 9397DVD(0x939A)"},
{0x1023, 0x9420, 0xFFFF, 0xFFFF, "TGUI 9420(0x9420)"},
{0x1023, 0x9430, 0xFFFF, 0xFFFF, "TGUI 9430(0x9430)"},
{0x1023, 0x9440, 0xFFFF, 0xFFFF, "TGUI 9440(0x9440)"},
{0x1023, 0x9460, 0xFFFF, 0xFFFF, "TGUI 9460(0x9460)"},
{0x1023, 0x9470, 0xFFFF, 0xFFFF, "TGUI 9470(0x9470)"},
{0x1023, 0x9520, 0xFFFF, 0xFFFF, "Cyber 9520(0x9520)"},
{0x1023, 0x9525, 0xFFFF, 0xFFFF, "Cyber 9525(0x9525)"},
{0x1023, 0x9540, 0xFFFF, 0xFFFF, "Cyber 9540(0x9540)"},
{0x1023, 0x9660, 0xFFFF, 0xFFFF, "TGUI 9660/938x/968x(0x9660)"},
{0x1023, 0x9680, 0xFFFF, 0xFFFF, "TGUI 9680(0x9680)"},
{0x1023, 0x9682, 0xFFFF, 0xFFFF, "TGUI 9682(0x9682)"},
{0x1023, 0x9683, 0xFFFF, 0xFFFF, "TGUI 9683(0x9683)"},
{0x1023, 0x9685, 0xFFFF, 0xFFFF, "ProVIDIA 9685(0x9685)"},
{0x1023, 0x9750, 0xFFFF, 0xFFFF, "3DImage 9750(0x9750)"},
{0x1023, 0x9750, 0x1014, 0x9750, "3DImage 9750(0x1014-0x9750)"},
{0x1023, 0x9750, 0x1023, 0x9750, "3DImage 9750(0x1023-0x9750)"},
{0x1023, 0x9753, 0xFFFF, 0xFFFF, "TGUI 9753(0x9753)"},
{0x1023, 0x9754, 0xFFFF, 0xFFFF, "TGUI 9754(0x9754)"},
{0x1023, 0x9759, 0xFFFF, 0xFFFF, "TGUI 975(0x9759)"},
{0x1023, 0x9783, 0xFFFF, 0xFFFF, "TGUI 9783(0x9783)"},
{0x1023, 0x9785, 0xFFFF, 0xFFFF, "TGUI 9785(0x9785)"},
{0x1023, 0x9850, 0xFFFF, 0xFFFF, "3DImage 9850(0x9850)"},
{0x1023, 0x9880, 0xFFFF, 0xFFFF, "Blade 3D PCI/AGP(0x9880)"},
{0x1023, 0x9880, 0x1023, 0x9880, "Blade 3D(0x1023-0x9880)"},
{0x1023, 0x9910, 0xFFFF, 0xFFFF, "CyberBlade/XP(0x9910)"},
{0x1023, 0x9930, 0xFFFF, 0xFFFF, "CyberBlade/XPm(0x9930)"},
{0x1023, 0x9960, 0xFFFF, 0xFFFF, "CyberBlade XP2(0x9960)"},
}; /* pci_vid_1023[] */

static pci_id_t const pci_vid_1024[] = {
{0x1024, 0xFFFF, 0xFFFF, 0xFFFF, "Beijing Dajia Internet Information Technology Co.(0x1024)"},
{0x1024, 0x0101, 0xFFFF, 0xFFFF, "StreamLake 200 AI-VPU(0x0101)"},
{0x1024, 0x0101, 0x1024, 0x0201, "SL200-NP(0x1024-0x0201)"},
{0x1024, 0x0101, 0x1024, 0x0301, "SL200-P(0x1024-0x0301)"},
}; /* pci_vid_1024[] */

static pci_id_t const pci_vid_1025[] = {
{0x1025, 0xFFFF, 0xFFFF, 0xFFFF, "Acer Incorporated [ALI](0x1025)"},
{0x1025, 0x1435, 0xFFFF, 0xFFFF, "M1435(0x1435)"},
{0x1025, 0x1445, 0xFFFF, 0xFFFF, "M1445(0x1445)"},
{0x1025, 0x1449, 0xFFFF, 0xFFFF, "M1449(0x1449)"},
{0x1025, 0x1451, 0xFFFF, 0xFFFF, "M1451(0x1451)"},
{0x1025, 0x1461, 0xFFFF, 0xFFFF, "M1461(0x1461)"},
{0x1025, 0x1489, 0xFFFF, 0xFFFF, "M1489(0x1489)"},
{0x1025, 0x1511, 0xFFFF, 0xFFFF, "M1511(0x1511)"},
{0x1025, 0x1512, 0xFFFF, 0xFFFF, "ALI M1512 Aladdin(0x1512)"},
{0x1025, 0x1513, 0xFFFF, 0xFFFF, "M1513(0x1513)"},
{0x1025, 0x1521, 0xFFFF, 0xFFFF, "ALI M1521 Aladdin III CPU Bridge(0x1521)"},
{0x1025, 0x1521, 0x10B9, 0x1521, "ALI M1521 Aladdin III CPU Bridge(0x10B9-0x1521)"},
{0x1025, 0x1523, 0xFFFF, 0xFFFF, "ALI M1523 ISA Bridge(0x1523)"},
{0x1025, 0x1523, 0x10B9, 0x1523, "ALI M1523 ISA Bridge(0x10B9-0x1523)"},
{0x1025, 0x1531, 0xFFFF, 0xFFFF, "M1531 Northbridge [Aladdin IV/IV+](0x1531)"},
{0x1025, 0x1533, 0xFFFF, 0xFFFF, "M1533 PCI-to-ISA Bridge(0x1533)"},
{0x1025, 0x1533, 0x10B9, 0x1533, "ALI M1533 Aladdin IV/V ISA South Bridge(0x10B9-0x1533)"},
{0x1025, 0x1535, 0xFFFF, 0xFFFF, "M1535 PCI Bridge + Super I/O + FIR(0x1535)"},
{0x1025, 0x1541, 0xFFFF, 0xFFFF, "M1541 Northbridge [Aladdin V](0x1541)"},
{0x1025, 0x1541, 0x10B9, 0x1541, "ALI M1541 Aladdin V/V+ AGP+PCI North Bridge(0x10B9-0x1541)"},
{0x1025, 0x1542, 0xFFFF, 0xFFFF, "M1542 Northbridge [Aladdin V](0x1542)"},
{0x1025, 0x1543, 0xFFFF, 0xFFFF, "M1543 PCI-to-ISA Bridge + Super I/O + FIR(0x1543)"},
{0x1025, 0x1561, 0xFFFF, 0xFFFF, "M1561 Northbridge [Aladdin 7](0x1561)"},
{0x1025, 0x1621, 0xFFFF, 0xFFFF, "M1621 Northbridge [Aladdin-Pro II](0x1621)"},
{0x1025, 0x1631, 0xFFFF, 0xFFFF, "M1631 Northbridge+3D Graphics [Aladdin TNT2](0x1631)"},
{0x1025, 0x1641, 0xFFFF, 0xFFFF, "M1641 Northbridge [Aladdin-Pro IV](0x1641)"},
{0x1025, 0x1647, 0xFFFF, 0xFFFF, "M1647 [MaGiK1] PCI North Bridge(0x1647)"},
{0x1025, 0x1671, 0xFFFF, 0xFFFF, "M1671 Northbridge [ALADDiN-P4](0x1671)"},
{0x1025, 0x1672, 0xFFFF, 0xFFFF, "Northbridge [CyberALADDiN-P4](0x1672)"},
{0x1025, 0x3141, 0xFFFF, 0xFFFF, "M3141(0x3141)"},
{0x1025, 0x3143, 0xFFFF, 0xFFFF, "M3143(0x3143)"},
{0x1025, 0x3145, 0xFFFF, 0xFFFF, "M3145(0x3145)"},
{0x1025, 0x3147, 0xFFFF, 0xFFFF, "M3147(0x3147)"},
{0x1025, 0x3149, 0xFFFF, 0xFFFF, "M3149(0x3149)"},
{0x1025, 0x3151, 0xFFFF, 0xFFFF, "M3151(0x3151)"},
{0x1025, 0x3307, 0xFFFF, 0xFFFF, "M3307 MPEG-I Video Controller(0x3307)"},
{0x1025, 0x3309, 0xFFFF, 0xFFFF, "M3309 MPEG-II Video w/ Software Audio Decoder(0x3309)"},
{0x1025, 0x3321, 0xFFFF, 0xFFFF, "M3321 MPEG-II Audio/Video Decoder(0x3321)"},
{0x1025, 0x5212, 0xFFFF, 0xFFFF, "M4803(0x5212)"},
{0x1025, 0x5215, 0xFFFF, 0xFFFF, "ALI PCI EIDE Controller(0x5215)"},
{0x1025, 0x5217, 0xFFFF, 0xFFFF, "M5217H(0x5217)"},
{0x1025, 0x5219, 0xFFFF, 0xFFFF, "M5219(0x5219)"},
{0x1025, 0x5225, 0xFFFF, 0xFFFF, "M5225(0x5225)"},
{0x1025, 0x5229, 0xFFFF, 0xFFFF, "M5229(0x5229)"},
{0x1025, 0x5235, 0xFFFF, 0xFFFF, "M5235(0x5235)"},
{0x1025, 0x5237, 0xFFFF, 0xFFFF, "OHCI USB Controller(0x5237)"},
{0x1025, 0x5239, 0xFFFF, 0xFFFF, "EHCI USB Controller(0x5239)"},
{0x1025, 0x5240, 0xFFFF, 0xFFFF, "EIDE Controller(0x5240)"},
{0x1025, 0x5241, 0xFFFF, 0xFFFF, "PCMCIA Bridge(0x5241)"},
{0x1025, 0x5242, 0xFFFF, 0xFFFF, "General Purpose Controller(0x5242)"},
{0x1025, 0x5243, 0xFFFF, 0xFFFF, "PCI to PCI Bridge Controller(0x5243)"},
{0x1025, 0x5244, 0xFFFF, 0xFFFF, "Floppy Disk Controller(0x5244)"},
{0x1025, 0x5247, 0xFFFF, 0xFFFF, "M1541 PCI to PCI Bridge(0x5247)"},
{0x1025, 0x5251, 0xFFFF, 0xFFFF, "M5251 P1394 Controller(0x5251)"},
{0x1025, 0x5427, 0xFFFF, 0xFFFF, "PCI to AGP Bridge(0x5427)"},
{0x1025, 0x5451, 0xFFFF, 0xFFFF, "M5451 PCI AC-Link Controller Audio Device(0x5451)"},
{0x1025, 0x5453, 0xFFFF, 0xFFFF, "M5453 PCI AC-Link Controller Modem Device(0x5453)"},
{0x1025, 0x7101, 0xFFFF, 0xFFFF, "M7101 PCI PMU Power Management Controller(0x7101)"},
{0x1025, 0x7101, 0x10B9, 0x7101, "M7101 PCI PMU Power Management Controller(0x10B9-0x7101)"},
{0x1025, 0x9602, 0xFFFF, 0xFFFF, "AMD RS780/RS880 PCI to PCI bridge (int gfx)(0x9602)"},
}; /* pci_vid_1025[] */

static pci_id_t const pci_vid_1028[] = {
{0x1028, 0xFFFF, 0xFFFF, 0xFFFF, "Dell(0x1028)"},
{0x1028, 0x0001, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID Controller 2/Si(0x0001)"},
{0x1028, 0x0001, 0x1028, 0x0001, "PowerEdge 2400(0x1028-0x0001)"},
{0x1028, 0x0002, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID Controller 3/Di(0x0002)"},
{0x1028, 0x0002, 0x1028, 0x0002, "PowerEdge 4400(0x1028-0x0002)"},
{0x1028, 0x0002, 0x1028, 0x00D1, "PERC 3/DiV [Viper](0x1028-0x00D1)"},
{0x1028, 0x0002, 0x1028, 0x00D9, "PERC 3/DiL [Lexus](0x1028-0x00D9)"},
{0x1028, 0x0003, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID Controller 3/Si(0x0003)"},
{0x1028, 0x0003, 0x1028, 0x0003, "PowerEdge 2450(0x1028-0x0003)"},
{0x1028, 0x0004, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID Controller 3/Di [Iguana](0x0004)"},
{0x1028, 0x0004, 0x1028, 0x0004, "PERC 3/DiF [Iguana](0x1028-0x0004)"},
{0x1028, 0x0006, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID Controller 3/Di(0x0006)"},
{0x1028, 0x0007, 0xFFFF, 0xFFFF, "Remote Access Card III(0x0007)"},
{0x1028, 0x0008, 0xFFFF, 0xFFFF, "Remote Access Card III(0x0008)"},
{0x1028, 0x0009, 0xFFFF, 0xFFFF, "Remote Access Card III: BMC/SMIC device not present(0x0009)"},
{0x1028, 0x000A, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID Controller 3/Di(0x000A)"},
{0x1028, 0x000A, 0x1028, 0x0106, "PERC 3/DiJ [Jaguar](0x1028-0x0106)"},
{0x1028, 0x000A, 0x1028, 0x011B, "PERC 3/DiD [Dagger](0x1028-0x011B)"},
{0x1028, 0x000A, 0x1028, 0x0121, "PERC 3/DiB [Boxster](0x1028-0x0121)"},
{0x1028, 0x000C, 0xFFFF, 0xFFFF, "Embedded Remote Access or ERA/O(0x000C)"},
{0x1028, 0x000D, 0xFFFF, 0xFFFF, "Embedded Remote Access: BMC/SMIC device(0x000D)"},
{0x1028, 0x000E, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID controller 4/Di(0x000E)"},
{0x1028, 0x000F, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID controller 4/Di(0x000F)"},
{0x1028, 0x000F, 0x1028, 0x014A, "PowerEdge 1750(0x1028-0x014A)"},
{0x1028, 0x0010, 0xFFFF, 0xFFFF, "Remote Access Card 4(0x0010)"},
{0x1028, 0x0011, 0xFFFF, 0xFFFF, "Remote Access Card 4 Daughter Card(0x0011)"},
{0x1028, 0x0012, 0xFFFF, 0xFFFF, "Remote Access Card 4 Daughter Card Virtual UART(0x0012)"},
{0x1028, 0x0013, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID controller 4(0x0013)"},
{0x1028, 0x0013, 0x1028, 0x016C, "PowerEdge Expandable RAID Controller 4e/Si(0x1028-0x016C)"},
{0x1028, 0x0013, 0x1028, 0x016D, "PowerEdge Expandable RAID Controller 4e/Di(0x1028-0x016D)"},
{0x1028, 0x0013, 0x1028, 0x016E, "PowerEdge Expandable RAID Controller 4e/Di(0x1028-0x016E)"},
{0x1028, 0x0013, 0x1028, 0x016F, "PowerEdge Expandable RAID Controller 4e/Di(0x1028-0x016F)"},
{0x1028, 0x0013, 0x1028, 0x0170, "PowerEdge Expandable RAID Controller 4e/Di(0x1028-0x0170)"},
{0x1028, 0x0014, 0xFFFF, 0xFFFF, "Remote Access Card 4 Daughter Card SMIC interface(0x0014)"},
{0x1028, 0x0015, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID controller 5(0x0015)"},
{0x1028, 0x0015, 0x1028, 0x1F01, "PERC 5/E Adapter RAID Controller(0x1028-0x1F01)"},
{0x1028, 0x0015, 0x1028, 0x1F02, "PERC 5/i Adapter RAID Controller(0x1028-0x1F02)"},
{0x1028, 0x0015, 0x1028, 0x1F03, "PERC 5/i Integrated RAID Controller(0x1028-0x1F03)"},
{0x1028, 0x0016, 0xFFFF, 0xFFFF, "PowerEdge Expandable RAID controller S300(0x0016)"},
{0x1028, 0x0016, 0x1028, 0x1F24, "PERC S300 Controller(0x1028-0x1F24)"},
{0x1028, 0x0073, 0xFFFF, 0xFFFF, "NV-RAM Adapter(0x0073)"},
{0x1028, 0x0C46, 0xFFFF, 0xFFFF, "PERC S160 RAID controller(0x0C46)"},
{0x1028, 0x1028, 0xFFFF, 0xFFFF, "PCIe Bridge riser(0x1028)"},
{0x1028, 0x2600, 0xFFFF, 0xFFFF, "ENT NVMe RT1(0x2600)"},
{0x1028, 0x2600, 0x1028, 0x215E, "ENT NVMe RT1 RI 3.84TB(0x1028-0x215E)"},
{0x1028, 0x2600, 0x1028, 0x215F, "ENT NVMe RT1 RI 7.68TB(0x1028-0x215F)"},
{0x1028, 0x2600, 0x1028, 0x2160, "ENT NVMe RT1 FIPS RI 3.84TB(0x1028-0x2160)"},
{0x1028, 0x2600, 0x1028, 0x2161, "ENT NVMe RT1 FIPS RI 7.68TB(0x1028-0x2161)"},
{0x1028, 0x9602, 0xFFFF, 0xFFFF, "RS780/RS880 PCI to PCI bridge (int gfx)(0x9602)"},
}; /* pci_vid_1028[] */

static pci_id_t const pci_vid_1029[] = {
{0x1029, 0xFFFF, 0xFFFF, 0xFFFF, "Siemens Nixdorf IS(0x1029)"},
}; /* pci_vid_1029[] */

static pci_id_t const pci_vid_102A[] = {
{0x102A, 0xFFFF, 0xFFFF, 0xFFFF, "LSI Logic(0x102A)"},
{0x102A, 0x0000, 0xFFFF, 0xFFFF, "HYDRA(0x0000)"},
{0x102A, 0x0010, 0xFFFF, 0xFFFF, "ASPEN(0x0010)"},
{0x102A, 0x001F, 0xFFFF, 0xFFFF, "AHA-2940U2/U2W /7890/7891 SCSI Controllers(0x001F)"},
{0x102A, 0x001F, 0x9005, 0x000F, "2940U2W SCSI Controller(0x9005-0x000F)"},
{0x102A, 0x001F, 0x9005, 0x0106, "2940U2W SCSI Controller(0x9005-0x0106)"},
{0x102A, 0x001F, 0x9005, 0xA180, "2940U2W SCSI Controller(0x9005-0xA180)"},
{0x102A, 0x00C5, 0xFFFF, 0xFFFF, "AIC-7899 U160/m SCSI Controller(0x00C5)"},
{0x102A, 0x00C5, 0x1028, 0x00C5, "PowerEdge 2550/2650/4600(0x1028-0x00C5)"},
{0x102A, 0x00CF, 0xFFFF, 0xFFFF, "AIC-7899P U160/m(0x00CF)"},
{0x102A, 0x00CF, 0x1028, 0x0106, "PowerEdge 4600(0x1028-0x0106)"},
{0x102A, 0x00CF, 0x1028, 0x0121, "PowerEdge 2650(0x1028-0x0121)"},
}; /* pci_vid_102A[] */

static pci_id_t const pci_vid_102B[] = {
{0x102B, 0xFFFF, 0xFFFF, 0xFFFF, "Matrox Electronics Systems Ltd.(0x102B)"},
{0x102B, 0x0010, 0xFFFF, 0xFFFF, "MGA-I [Impression?-](0x0010)"},
{0x102B, 0x0100, 0xFFFF, 0xFFFF, "MGA 1064SG [Mystique](0x0100)"},
{0x102B, 0x0518, 0xFFFF, 0xFFFF, "MGA-II [Athena](0x0518)"},
{0x102B, 0x0519, 0xFFFF, 0xFFFF, "MGA 2064W [Millennium](0x0519)"},
{0x102B, 0x051A, 0xFFFF, 0xFFFF, "MGA 1064SG [Mystique](0x051A)"},
{0x102B, 0x051A, 0x102B, 0x0100, "MGA-1064SG Mystique(0x102B-0x0100)"},
{0x102B, 0x051A, 0x102B, 0x051A, "MGA-1164SG Mystique 220(0x102B-0x051A)"},
{0x102B, 0x051A, 0x102B, 0x1100, "MGA-1084SG Mystique(0x102B-0x1100)"},
{0x102B, 0x051A, 0x102B, 0x1200, "MGA-1084SG Mystique(0x102B-0x1200)"},
{0x102B, 0x051A, 0x1100, 0x102B, "MGA-1084SG Mystique(0x1100-0x102B)"},
{0x102B, 0x051A, 0x110A, 0x0018, "Scenic Pro C5 (D1025)(0x110A-0x0018)"},
{0x102B, 0x051B, 0xFFFF, 0xFFFF, "MGA 2164W [Millennium II](0x051B)"},
{0x102B, 0x051B, 0x102B, 0x051B, "MGA-2164W Millennium II(0x102B-0x051B)"},
{0x102B, 0x051B, 0x102B, 0x1100, "MGA-2164W Millennium II(0x102B-0x1100)"},
{0x102B, 0x051B, 0x102B, 0x1200, "MGA-2164W Millennium II(0x102B-0x1200)"},
{0x102B, 0x051B, 0x102B, 0x2100, "MGA-2164W Millennium II(0x102B-0x2100)"},
{0x102B, 0x051E, 0xFFFF, 0xFFFF, "MGA 1064SG [Mystique] AGP(0x051E)"},
{0x102B, 0x051F, 0xFFFF, 0xFFFF, "MGA 2164W [Millennium II] AGP(0x051F)"},
{0x102B, 0x051F, 0x102B, 0x2100, "MGA-2164WA [Millennium II A](0x102B-0x2100)"},
{0x102B, 0x0520, 0xFFFF, 0xFFFF, "MGA G200(0x0520)"},
{0x102B, 0x0520, 0x102B, 0xDBC2, "G200 Multi-Monitor(0x102B-0xDBC2)"},
{0x102B, 0x0520, 0x102B, 0xDBC8, "G200 Multi-Monitor(0x102B-0xDBC8)"},
{0x102B, 0x0520, 0x102B, 0xDBE2, "G200 Multi-Monitor(0x102B-0xDBE2)"},
{0x102B, 0x0520, 0x102B, 0xDBE8, "G200 Multi-Monitor(0x102B-0xDBE8)"},
{0x102B, 0x0520, 0x102B, 0xFF03, "Millennium G200 SD(0x102B-0xFF03)"},
{0x102B, 0x0520, 0x102B, 0xFF04, "Marvel G200(0x102B-0xFF04)"},
{0x102B, 0x0521, 0xFFFF, 0xFFFF, "MGA G200 AGP(0x0521)"},
{0x102B, 0x0521, 0x1014, 0xFF03, "Millennium G200 AGP(0x1014-0xFF03)"},
{0x102B, 0x0521, 0x102B, 0x48E9, "Mystique G200 AGP(0x102B-0x48E9)"},
{0x102B, 0x0521, 0x102B, 0x48F8, "Millennium G200 SD AGP(0x102B-0x48F8)"},
{0x102B, 0x0521, 0x102B, 0x4A60, "Millennium G200 LE AGP(0x102B-0x4A60)"},
{0x102B, 0x0521, 0x102B, 0x4A64, "Millennium G200 AGP(0x102B-0x4A64)"},
{0x102B, 0x0521, 0x102B, 0xC93C, "Millennium G200 AGP(0x102B-0xC93C)"},
{0x102B, 0x0521, 0x102B, 0xC9B0, "Millennium G200 AGP(0x102B-0xC9B0)"},
{0x102B, 0x0521, 0x102B, 0xC9BC, "Millennium G200 AGP(0x102B-0xC9BC)"},
{0x102B, 0x0521, 0x102B, 0xCA60, "Millennium G250 LE AGP(0x102B-0xCA60)"},
{0x102B, 0x0521, 0x102B, 0xCA6C, "Millennium G250 AGP(0x102B-0xCA6C)"},
{0x102B, 0x0521, 0x102B, 0xDBBC, "Millennium G200 AGP(0x102B-0xDBBC)"},
{0x102B, 0x0521, 0x102B, 0xDBC2, "Millennium G200 MMS (Dual G200)(0x102B-0xDBC2)"},
{0x102B, 0x0521, 0x102B, 0xDBC3, "G200 Multi-Monitor(0x102B-0xDBC3)"},
{0x102B, 0x0521, 0x102B, 0xDBC8, "Millennium G200 MMS (Dual G200)(0x102B-0xDBC8)"},
{0x102B, 0x0521, 0x102B, 0xDBD2, "G200 Multi-Monitor(0x102B-0xDBD2)"},
{0x102B, 0x0521, 0x102B, 0xDBD3, "G200 Multi-Monitor(0x102B-0xDBD3)"},
{0x102B, 0x0521, 0x102B, 0xDBD4, "G200 Multi-Monitor(0x102B-0xDBD4)"},
{0x102B, 0x0521, 0x102B, 0xDBD5, "G200 Multi-Monitor(0x102B-0xDBD5)"},
{0x102B, 0x0521, 0x102B, 0xDBD8, "G200 Multi-Monitor(0x102B-0xDBD8)"},
{0x102B, 0x0521, 0x102B, 0xDBD9, "G200 Multi-Monitor(0x102B-0xDBD9)"},
{0x102B, 0x0521, 0x102B, 0xDBE2, "Millennium G200 MMS (Quad G200)(0x102B-0xDBE2)"},
{0x102B, 0x0521, 0x102B, 0xDBE3, "G200 Multi-Monitor(0x102B-0xDBE3)"},
{0x102B, 0x0521, 0x102B, 0xDBE8, "Millennium G200 MMS (Quad G200)(0x102B-0xDBE8)"},
{0x102B, 0x0521, 0x102B, 0xDBF2, "G200 Multi-Monitor(0x102B-0xDBF2)"},
{0x102B, 0x0521, 0x102B, 0xDBF3, "G200 Multi-Monitor(0x102B-0xDBF3)"},
{0x102B, 0x0521, 0x102B, 0xDBF4, "G200 Multi-Monitor(0x102B-0xDBF4)"},
{0x102B, 0x0521, 0x102B, 0xDBF5, "G200 Multi-Monitor(0x102B-0xDBF5)"},
{0x102B, 0x0521, 0x102B, 0xDBF8, "G200 Multi-Monitor(0x102B-0xDBF8)"},
{0x102B, 0x0521, 0x102B, 0xDBF9, "G200 Multi-Monitor(0x102B-0xDBF9)"},
{0x102B, 0x0521, 0x102B, 0xF806, "Mystique G200 Video AGP(0x102B-0xF806)"},
{0x102B, 0x0521, 0x102B, 0xFF00, "MGA-G200 AGP(0x102B-0xFF00)"},
{0x102B, 0x0521, 0x102B, 0xFF02, "Mystique G200 AGP(0x102B-0xFF02)"},
{0x102B, 0x0521, 0x102B, 0xFF03, "Millennium G200A AGP(0x102B-0xFF03)"},
{0x102B, 0x0521, 0x102B, 0xFF04, "Marvel G200 AGP(0x102B-0xFF04)"},
{0x102B, 0x0521, 0x110A, 0x0032, "MGA-G200 AGP(0x110A-0x0032)"},
{0x102B, 0x0522, 0xFFFF, 0xFFFF, "MGA G200e [Pilot] ServerEngines (SEP1)(0x0522)"},
{0x102B, 0x0522, 0x103C, 0x31FA, "ProLiant DL140 G3(0x103C-0x31FA)"},
{0x102B, 0x0525, 0xFFFF, 0xFFFF, "MGA G400/G450(0x0525)"},
{0x102B, 0x0525, 0x0E11, 0xB16F, "MGA-G400 AGP(0x0E11-0xB16F)"},
{0x102B, 0x0525, 0x102B, 0x0328, "Millennium G400 16Mb SDRAM(0x102B-0x0328)"},
{0x102B, 0x0525, 0x102B, 0x0338, "Millennium G400 16Mb SDRAM(0x102B-0x0338)"},
{0x102B, 0x0525, 0x102B, 0x0378, "Millennium G400 32Mb SDRAM(0x102B-0x0378)"},
{0x102B, 0x0525, 0x102B, 0x0541, "Millennium G450 Dual Head(0x102B-0x0541)"},
{0x102B, 0x0525, 0x102B, 0x0542, "Millennium G450 Dual Head LX(0x102B-0x0542)"},
{0x102B, 0x0525, 0x102B, 0x0543, "Millennium G450 Single Head LX(0x102B-0x0543)"},
{0x102B, 0x0525, 0x102B, 0x0641, "Millennium G450 32Mb SDRAM Dual Head(0x102B-0x0641)"},
{0x102B, 0x0525, 0x102B, 0x0642, "Millennium G450 32Mb SDRAM Dual Head LX(0x102B-0x0642)"},
{0x102B, 0x0525, 0x102B, 0x0643, "Millennium G450 32Mb SDRAM Single Head LX(0x102B-0x0643)"},
{0x102B, 0x0525, 0x102B, 0x07C0, "Millennium G450 Dual Head LE(0x102B-0x07C0)"},
{0x102B, 0x0525, 0x102B, 0x07C1, "Millennium G450 SDR Dual Head LE(0x102B-0x07C1)"},
{0x102B, 0x0525, 0x102B, 0x0D41, "Millennium G450 Dual Head PCI(0x102B-0x0D41)"},
{0x102B, 0x0525, 0x102B, 0x0D42, "Millennium G450 Dual Head LX PCI(0x102B-0x0D42)"},
{0x102B, 0x0525, 0x102B, 0x0D43, "Millennium G450 32Mb Dual Head PCI(0x102B-0x0D43)"},
{0x102B, 0x0525, 0x102B, 0x0E00, "Marvel G450 eTV(0x102B-0x0E00)"},
{0x102B, 0x0525, 0x102B, 0x0E01, "Marvel G450 eTV(0x102B-0x0E01)"},
{0x102B, 0x0525, 0x102B, 0x0E02, "Marvel G450 eTV(0x102B-0x0E02)"},
{0x102B, 0x0525, 0x102B, 0x0E03, "Marvel G450 eTV(0x102B-0x0E03)"},
{0x102B, 0x0525, 0x102B, 0x0F80, "Millennium G450 Low Profile(0x102B-0x0F80)"},
{0x102B, 0x0525, 0x102B, 0x0F81, "Millennium G450 Low Profile(0x102B-0x0F81)"},
{0x102B, 0x0525, 0x102B, 0x0F82, "Millennium G450 Low Profile DVI(0x102B-0x0F82)"},
{0x102B, 0x0525, 0x102B, 0x0F83, "Millennium G450 Low Profile DVI(0x102B-0x0F83)"},
{0x102B, 0x0525, 0x102B, 0x19D8, "Millennium G400 16Mb SGRAM(0x102B-0x19D8)"},
{0x102B, 0x0525, 0x102B, 0x19F8, "Millennium G400 32Mb SGRAM(0x102B-0x19F8)"},
{0x102B, 0x0525, 0x102B, 0x2159, "Millennium G400 Dual Head 16Mb(0x102B-0x2159)"},
{0x102B, 0x0525, 0x102B, 0x2179, "Millennium G400 MAX/Dual Head 32Mb(0x102B-0x2179)"},
{0x102B, 0x0525, 0x102B, 0x217D, "Millennium G400 Dual Head Max(0x102B-0x217D)"},
{0x102B, 0x0525, 0x102B, 0x23C0, "Millennium G450(0x102B-0x23C0)"},
{0x102B, 0x0525, 0x102B, 0x23C1, "Millennium G450(0x102B-0x23C1)"},
{0x102B, 0x0525, 0x102B, 0x23C2, "Millennium G450 DVI(0x102B-0x23C2)"},
{0x102B, 0x0525, 0x102B, 0x23C3, "Millennium G450 DVI(0x102B-0x23C3)"},
{0x102B, 0x0525, 0x102B, 0x2F58, "Millennium G400(0x102B-0x2F58)"},
{0x102B, 0x0525, 0x102B, 0x2F78, "Millennium G400(0x102B-0x2F78)"},
{0x102B, 0x0525, 0x102B, 0x3693, "Marvel G400 AGP(0x102B-0x3693)"},
{0x102B, 0x0525, 0x102B, 0x5DD0, "4Sight II(0x102B-0x5DD0)"},
{0x102B, 0x0525, 0x102B, 0x5F50, "4Sight II(0x102B-0x5F50)"},
{0x102B, 0x0525, 0x102B, 0x5F51, "4Sight II(0x102B-0x5F51)"},
{0x102B, 0x0525, 0x102B, 0x5F52, "4Sight II(0x102B-0x5F52)"},
{0x102B, 0x0525, 0x102B, 0x9010, "Millennium G400 Dual Head(0x102B-0x9010)"},
{0x102B, 0x0525, 0x1458, 0x0400, "GA-G400(0x1458-0x0400)"},
{0x102B, 0x0525, 0x1705, 0x0001, "Millennium G450 32MB SGRAM(0x1705-0x0001)"},
{0x102B, 0x0525, 0x1705, 0x0002, "Millennium G450 16MB SGRAM(0x1705-0x0002)"},
{0x102B, 0x0525, 0x1705, 0x0003, "Millennium G450 32MB(0x1705-0x0003)"},
{0x102B, 0x0525, 0x1705, 0x0004, "Millennium G450 16MB(0x1705-0x0004)"},
{0x102B, 0x0527, 0xFFFF, 0xFFFF, "Parhelia(0x0527)"},
{0x102B, 0x0527, 0x102B, 0x0840, "Parhelia 128Mb(0x102B-0x0840)"},
{0x102B, 0x0527, 0x102B, 0x0850, "Parhelia 256MB(0x102B-0x0850)"},
{0x102B, 0x0527, 0x102B, 0x0870, "MED2mp-DVI(0x102B-0x0870)"},
{0x102B, 0x0527, 0x102B, 0x0880, "P-256 Edge Overlap Controller(0x102B-0x0880)"},
{0x102B, 0x0528, 0xFFFF, 0xFFFF, "Parhelia(0x0528)"},
{0x102B, 0x0528, 0x102B, 0x1020, "Parhelia 128MB(0x102B-0x1020)"},
{0x102B, 0x0528, 0x102B, 0x1030, "Parhelia 256 MB Dual DVI(0x102B-0x1030)"},
{0x102B, 0x0528, 0x102B, 0x1040, "MED2mp-DVI(0x102B-0x1040)"},
{0x102B, 0x0528, 0x102B, 0x1050, "Sono S20(0x102B-0x1050)"},
{0x102B, 0x0528, 0x102B, 0x1060, "PJ-30L(0x102B-0x1060)"},
{0x102B, 0x0528, 0x102B, 0x1070, "PJ-40L(0x102B-0x1070)"},
{0x102B, 0x0528, 0x102B, 0x1421, "MED5mp(0x102B-0x1421)"},
{0x102B, 0x0528, 0x102B, 0x1431, "MED3mp-DVI(0x102B-0x1431)"},
{0x102B, 0x0528, 0x102B, 0x1451, "MED5mp-DVI(0x102B-0x1451)"},
{0x102B, 0x0528, 0x102B, 0x1491, "MED2mp-DVI(0x102B-0x1491)"},
{0x102B, 0x0528, 0x102B, 0x14B1, "MED3mp-DVI(0x102B-0x14B1)"},
{0x102B, 0x0528, 0x102B, 0x14C1, "MED5mp-DVI(0x102B-0x14C1)"},
{0x102B, 0x0528, 0x102B, 0x14E1, "Parhelia PCI 256MB(0x102B-0x14E1)"},
{0x102B, 0x0528, 0x102B, 0x14F1, "Parhelia Precision SGT(0x102B-0x14F1)"},
{0x102B, 0x0528, 0x102B, 0x1501, "ATC-4MP(0x102B-0x1501)"},
{0x102B, 0x0528, 0x102B, 0x1511, "ATC-4MP(0x102B-0x1511)"},
{0x102B, 0x0528, 0x102B, 0x1521, "TheatreVUE T30(0x102B-0x1521)"},
{0x102B, 0x0528, 0x102B, 0x1531, "TheatreVUE T20(0x102B-0x1531)"},
{0x102B, 0x0528, 0x102B, 0x1541, "MED2mp-DVI(0x102B-0x1541)"},
{0x102B, 0x0528, 0x102B, 0x1551, "MED3mp-DVI(0x102B-0x1551)"},
{0x102B, 0x0528, 0x102B, 0x1561, "MED5mp-DVI(0x102B-0x1561)"},
{0x102B, 0x0528, 0x102B, 0x1571, "Parhelia DL256 PCI(0x102B-0x1571)"},
{0x102B, 0x0528, 0x102B, 0x1591, "Parhelia Precision SDT(0x102B-0x1591)"},
{0x102B, 0x0528, 0x102B, 0x15A1, "MED4mp-DVI(0x102B-0x15A1)"},
{0x102B, 0x0528, 0x102B, 0x2011, "Parhelia HR256(0x102B-0x2011)"},
{0x102B, 0x0528, 0x102B, 0x2021, "QID Pro(0x102B-0x2021)"},
{0x102B, 0x0528, 0x102B, 0x2061, "PJ-40LP(0x102B-0x2061)"},
{0x102B, 0x0528, 0x102B, 0x2081, "EWS Quad(0x102B-0x2081)"},
{0x102B, 0x0528, 0x102B, 0x2411, "PPX-OUT8(0x102B-0x2411)"},
{0x102B, 0x0528, 0x102B, 0x2421, "VPX-OUT8(0x102B-0x2421)"},
{0x102B, 0x0528, 0x102B, 0x2441, "PPX-OUT4(0x102B-0x2441)"},
{0x102B, 0x0528, 0x102B, 0x2451, "VPX-OUT4(0x102B-0x2451)"},
{0x102B, 0x0528, 0x102B, 0x2491, "LPX-OUT4(0x102B-0x2491)"},
{0x102B, 0x0530, 0xFFFF, 0xFFFF, "MGA G200EV(0x0530)"},
{0x102B, 0x0532, 0xFFFF, 0xFFFF, "MGA G200eW WPCM450(0x0532)"},
{0x102B, 0x0532, 0x1028, 0x0235, "PowerEdge R710 MGA G200eW WPCM450(0x1028-0x0235)"},
{0x102B, 0x0532, 0x1028, 0x0236, "PowerEdge R610 MGA G200eW WPCM450(0x1028-0x0236)"},
{0x102B, 0x0532, 0x1028, 0x0237, "PowerEdge T610 MGA G200eW WPCM450(0x1028-0x0237)"},
{0x102B, 0x0532, 0x1028, 0x0287, "PowerEdge M610 MGA G200eW WPCM450(0x1028-0x0287)"},
{0x102B, 0x0532, 0x1028, 0x028C, "PowerEdge R410 MGA G200eW WPCM450(0x1028-0x028C)"},
{0x102B, 0x0532, 0x1028, 0x028D, "PowerEdge T410 MGA G200eW WPCM450(0x1028-0x028D)"},
{0x102B, 0x0532, 0x1028, 0x029C, "PowerEdge M710 MGA G200eW WPCM450(0x1028-0x029C)"},
{0x102B, 0x0532, 0x1028, 0x02A4, "PowerEdge T310 MGA G200eW WPCM450(0x1028-0x02A4)"},
{0x102B, 0x0532, 0x15D9, 0x0605, "X8SIL(0x15D9-0x0605)"},
{0x102B, 0x0532, 0x15D9, 0x0624, "X9SCM-F Motherboard(0x15D9-0x0624)"},
{0x102B, 0x0532, 0x15D9, 0x066B, "X9SRL-F(0x15D9-0x066B)"},
{0x102B, 0x0532, 0x15D9, 0xA811, "H8DGU(0x15D9-0xA811)"},
{0x102B, 0x0533, 0xFFFF, 0xFFFF, "MGA G200EH(0x0533)"},
{0x102B, 0x0533, 0x103C, 0x3381, "iLO4(0x103C-0x3381)"},
{0x102B, 0x0534, 0xFFFF, 0xFFFF, "G200eR2(0x0534)"},
{0x102B, 0x0534, 0x1028, 0x04F7, "PowerEdge R320 server(0x1028-0x04F7)"},
{0x102B, 0x0536, 0xFFFF, 0xFFFF, "Integrated Matrox G200eW3 Graphics Controller(0x0536)"},
{0x102B, 0x0538, 0xFFFF, 0xFFFF, "MGA G200eH3(0x0538)"},
{0x102B, 0x0538, 0x1590, 0x00E4, "iLO5 VGA(0x1590-0x00E4)"},
{0x102B, 0x0540, 0xFFFF, 0xFFFF, "M91XX(0x0540)"},
{0x102B, 0x0540, 0x102B, 0x2080, "M9140 LP PCIe x16(0x102B-0x2080)"},
{0x102B, 0x0540, 0x102B, 0x20C0, "Xenia(0x102B-0x20C0)"},
{0x102B, 0x0540, 0x102B, 0x20C1, "Xenia Pro(0x102B-0x20C1)"},
{0x102B, 0x0540, 0x102B, 0x2100, "M9120 PCIe x16(0x102B-0x2100)"},
{0x102B, 0x0540, 0x102B, 0x2140, "M9125 PCIe x16(0x102B-0x2140)"},
{0x102B, 0x0540, 0x102B, 0x2180, "M9120 Plus LP PCIe x16(0x102B-0x2180)"},
{0x102B, 0x0540, 0x102B, 0x21C0, "M9120 Plus LP PCIe x1(0x102B-0x21C0)"},
{0x102B, 0x0540, 0x102B, 0x2200, "VDA1164 Output Board(0x102B-0x2200)"},
{0x102B, 0x0540, 0x102B, 0x2240, "M9148 LP PCIe x16(0x102B-0x2240)"},
{0x102B, 0x0540, 0x102B, 0x2241, "M9138 LP PCIe x16(0x102B-0x2241)"},
{0x102B, 0x0540, 0x102B, 0x2280, "M9188 ATX PCIe x16(0x102B-0x2280)"},
{0x102B, 0x0540, 0x102B, 0x22C0, "M9128 LP PCIe x16(0x102B-0x22C0)"},
{0x102B, 0x0550, 0xFFFF, 0xFFFF, "SV2(0x0550)"},
{0x102B, 0x0550, 0x102B, 0x00C0, "MURA-IPX-I4EF(0x102B-0x00C0)"},
{0x102B, 0x0550, 0x102B, 0x00C1, "MURA-IPX-I4DF(0x102B-0x00C1)"},
{0x102B, 0x0550, 0x102B, 0x00C3, "MURA-IPX-I4DHF(0x102B-0x00C3)"},
{0x102B, 0x0550, 0x102B, 0x00C5, "MURA-IPX-I4EHF(0x102B-0x00C5)"},
{0x102B, 0x0D10, 0xFFFF, 0xFFFF, "MGA Ultima/Impression(0x0D10)"},
{0x102B, 0x1000, 0xFFFF, 0xFFFF, "MGA G100 [Productiva](0x1000)"},
{0x102B, 0x1000, 0x102B, 0xFF01, "Productiva G100(0x102B-0xFF01)"},
{0x102B, 0x1000, 0x102B, 0xFF05, "Productiva G100 Multi-Monitor(0x102B-0xFF05)"},
{0x102B, 0x1001, 0xFFFF, 0xFFFF, "MGA G100 [Productiva] AGP(0x1001)"},
{0x102B, 0x1001, 0x102B, 0x1001, "MGA-G100 AGP(0x102B-0x1001)"},
{0x102B, 0x1001, 0x102B, 0xFF00, "MGA-G100 AGP(0x102B-0xFF00)"},
{0x102B, 0x1001, 0x102B, 0xFF01, "MGA-G100 Productiva AGP(0x102B-0xFF01)"},
{0x102B, 0x1001, 0x102B, 0xFF03, "Millennium G100 AGP(0x102B-0xFF03)"},
{0x102B, 0x1001, 0x102B, 0xFF04, "MGA-G100 AGP(0x102B-0xFF04)"},
{0x102B, 0x1001, 0x102B, 0xFF05, "MGA-G100 Productiva AGP Multi-Monitor(0x102B-0xFF05)"},
{0x102B, 0x1001, 0x110A, 0x001E, "MGA-G100 AGP(0x110A-0x001E)"},
{0x102B, 0x2007, 0xFFFF, 0xFFFF, "MGA Mistral(0x2007)"},
{0x102B, 0x2527, 0xFFFF, 0xFFFF, "Millennium G550(0x2527)"},
{0x102B, 0x2527, 0x102B, 0x0F42, "Matrox G550 Low Profile PCI(0x102B-0x0F42)"},
{0x102B, 0x2527, 0x102B, 0x0F83, "Millennium G550(0x102B-0x0F83)"},
{0x102B, 0x2527, 0x102B, 0x0F84, "Millennium G550 Dual Head DDR 32Mb(0x102B-0x0F84)"},
{0x102B, 0x2527, 0x102B, 0x1E41, "Millennium G550(0x102B-0x1E41)"},
{0x102B, 0x2527, 0x102B, 0x22C0, "G550 PCIe(0x102B-0x22C0)"},
{0x102B, 0x2527, 0x102B, 0x2300, "Millennium G550 LP PCIE(0x102B-0x2300)"},
{0x102B, 0x2537, 0xFFFF, 0xFFFF, "Millennium P650/P750(0x2537)"},
{0x102B, 0x2537, 0x102B, 0x1820, "Millennium P750 64MB(0x102B-0x1820)"},
{0x102B, 0x2537, 0x102B, 0x1830, "Millennium P650 64MB(0x102B-0x1830)"},
{0x102B, 0x2537, 0x102B, 0x1850, "RAD2mp(0x102B-0x1850)"},
{0x102B, 0x2537, 0x102B, 0x1860, "RAD3mp(0x102B-0x1860)"},
{0x102B, 0x2537, 0x102B, 0x1880, "Sono S10(0x102B-0x1880)"},
{0x102B, 0x2537, 0x102B, 0x1C10, "QID 128MB(0x102B-0x1C10)"},
{0x102B, 0x2537, 0x102B, 0x2811, "Millennium P650 Low-profile PCI 64MB(0x102B-0x2811)"},
{0x102B, 0x2537, 0x102B, 0x2821, "Millennium P650 Low-profile PCI(0x102B-0x2821)"},
{0x102B, 0x2537, 0x102B, 0x2841, "RAD PCI(0x102B-0x2841)"},
{0x102B, 0x2537, 0x102B, 0x2851, "Spectrum PCI(0x102B-0x2851)"},
{0x102B, 0x2537, 0x102B, 0x2871, "EpicA TC2(0x102B-0x2871)"},
{0x102B, 0x2537, 0x102B, 0x2C11, "QID Low-profile PCI(0x102B-0x2C11)"},
{0x102B, 0x2537, 0x102B, 0x2C21, "QID LP PCI LW(0x102B-0x2C21)"},
{0x102B, 0x2537, 0x102B, 0x2C31, "QID LP PCI(0x102B-0x2C31)"},
{0x102B, 0x2537, 0x102B, 0x2C41, "EpicA TC4(0x102B-0x2C41)"},
{0x102B, 0x2537, 0x102B, 0x3001, "Extio F1400(0x102B-0x3001)"},
{0x102B, 0x2537, 0x102B, 0x3011, "Extio F1220(0x102B-0x3011)"},
{0x102B, 0x2537, 0x102B, 0x3041, "RG-200DL(0x102B-0x3041)"},
{0x102B, 0x2537, 0x102B, 0x3051, "RG-400SL(0x102B-0x3051)"},
{0x102B, 0x2537, 0x102B, 0x3061, "Extio F1420(0x102B-0x3061)"},
{0x102B, 0x2537, 0x102B, 0x3081, "Extio F1240(0x102B-0x3081)"},
{0x102B, 0x2538, 0xFFFF, 0xFFFF, "Millennium P650 PCIe(0x2538)"},
{0x102B, 0x2538, 0x102B, 0x0847, "RAD PCIe(0x102B-0x0847)"},
{0x102B, 0x2538, 0x102B, 0x08C7, "Millennium P650 PCIe 128MB(0x102B-0x08C7)"},
{0x102B, 0x2538, 0x102B, 0x0907, "Millennium P650 PCIe 64MB(0x102B-0x0907)"},
{0x102B, 0x2538, 0x102B, 0x0947, "Parhelia APVe(0x102B-0x0947)"},
{0x102B, 0x2538, 0x102B, 0x0987, "ATC PCIe 4MP(0x102B-0x0987)"},
{0x102B, 0x2538, 0x102B, 0x1047, "Millennium P650 LP PCIe 128MB(0x102B-0x1047)"},
{0x102B, 0x2538, 0x102B, 0x1087, "Millennium P650 LP PCIe 64MB(0x102B-0x1087)"},
{0x102B, 0x2538, 0x102B, 0x1801, "Millennium P650 PCIe x1(0x102B-0x1801)"},
{0x102B, 0x2538, 0x102B, 0x2538, "Parhelia APVe(0x102B-0x2538)"},
{0x102B, 0x2538, 0x102B, 0x3007, "QID Low-profile PCIe(0x102B-0x3007)"},
{0x102B, 0x2538, 0x102B, 0x3087, "Aurora VX3mp(0x102B-0x3087)"},
{0x102B, 0x2538, 0x102B, 0x30C7, "QID LP PCIe(0x102B-0x30C7)"},
{0x102B, 0x2539, 0xFFFF, 0xFFFF, "Millennium P690(0x2539)"},
{0x102B, 0x2539, 0x102B, 0x0040, "Millennium P690 PCIe x16(0x102B-0x0040)"},
{0x102B, 0x2539, 0x102B, 0x0042, "ONYX(0x102B-0x0042)"},
{0x102B, 0x2539, 0x102B, 0x0043, "SPECTRA(0x102B-0x0043)"},
{0x102B, 0x2539, 0x102B, 0x0080, "Millennium P690 Plus LP PCIe x16(0x102B-0x0080)"},
{0x102B, 0x2539, 0x102B, 0x0081, "Millennium P690 LP PCIe x16(0x102B-0x0081)"},
{0x102B, 0x2539, 0x102B, 0x0082, "RAD LPX PCIe x16(0x102B-0x0082)"},
{0x102B, 0x2539, 0x102B, 0x00C0, "Millennium P690 Plus LP PCI(0x102B-0x00C0)"},
{0x102B, 0x2539, 0x102B, 0x00C2, "Millennium P690 LP PCI(0x102B-0x00C2)"},
{0x102B, 0x2539, 0x102B, 0x00C3, "RAD LPX PCI(0x102B-0x00C3)"},
{0x102B, 0x2539, 0x102B, 0x0101, "Millennium P690 PCI(0x102B-0x0101)"},
{0x102B, 0x2539, 0x102B, 0x0140, "Millennium P690 LP PCIe x1(0x102B-0x0140)"},
{0x102B, 0x2539, 0x102B, 0x0180, "Display Wall IP Decode 128 MB(0x102B-0x0180)"},
{0x102B, 0x4164, 0xFFFF, 0xFFFF, "Morphis QxT frame grabber(0x4164)"},
{0x102B, 0x43B4, 0xFFFF, 0xFFFF, "Morphis Qxt encoding engine(0x43B4)"},
{0x102B, 0x4510, 0xFFFF, 0xFFFF, "Morphis COM port(0x4510)"},
{0x102B, 0x4536, 0xFFFF, 0xFFFF, "VIA Framegrabber(0x4536)"},
{0x102B, 0x4686, 0xFFFF, 0xFFFF, "Concord GX (customized Intel 82541)(0x4686)"},
{0x102B, 0x475B, 0xFFFF, 0xFFFF, "Solios eCL/XCL-B frame grabber(0x475B)"},
{0x102B, 0x475D, 0xFFFF, 0xFFFF, "Vio frame grabber family(0x475D)"},
{0x102B, 0x475D, 0x102B, 0x4B90, "Vio Duo frame grabber (single channel)(0x102B-0x4B90)"},
{0x102B, 0x475D, 0x102B, 0x4B91, "Vio Duo frame grabber(0x102B-0x4B91)"},
{0x102B, 0x475D, 0x102B, 0x4B92, "Vio Analog frame grabber(0x102B-0x4B92)"},
{0x102B, 0x475D, 0x102B, 0x4B93, "Vio SDI Frame Grabber(0x102B-0x4B93)"},
{0x102B, 0x475D, 0x102B, 0x4B94, "Vio DVI-A frame grabber(0x102B-0x4B94)"},
{0x102B, 0x475F, 0xFFFF, 0xFFFF, "Solios (single-Full) CL frame grabber(0x475F)"},
{0x102B, 0x475F, 0x102B, 0x475F, "Solios eCL/XCL-F frame grabber(0x102B-0x475F)"},
{0x102B, 0x475F, 0x102B, 0x4D5F, "Solios eV-CL (single-Full) frame grabber(0x102B-0x4D5F)"},
{0x102B, 0x475F, 0x102B, 0x4E5F, "Solios eM-CL (single-Full) frame grabber(0x102B-0x4E5F)"},
{0x102B, 0x47A1, 0xFFFF, 0xFFFF, "Solios eA/XA frame grabber(0x47A1)"},
{0x102B, 0x47A1, 0x102B, 0x4BE0, "Solios eA/XA (single) frame grabber(0x102B-0x4BE0)"},
{0x102B, 0x47A1, 0x102B, 0x4BE1, "Solios eA/XA (dual) frame grabber(0x102B-0x4BE1)"},
{0x102B, 0x47A1, 0x102B, 0x4BE2, "Solios eA/XA (quad) frame grabber(0x102B-0x4BE2)"},
{0x102B, 0x47A2, 0xFFFF, 0xFFFF, "Solios COM port(0x47A2)"},
{0x102B, 0x47C1, 0xFFFF, 0xFFFF, "Solios (dual-Base/single-Medium) CL frame grabber(0x47C1)"},
{0x102B, 0x47C1, 0x102B, 0x0000, "Solios frame grabber(0x102B-0x0000)"},
{0x102B, 0x47C1, 0x102B, 0x4B80, "Solios eCL/XCL (single-Medium) frame grabber(0x102B-0x4B80)"},
{0x102B, 0x47C1, 0x102B, 0x4B81, "Solios eCL/XCL (dual-Base) frame grabber(0x102B-0x4B81)"},
{0x102B, 0x47C1, 0x102B, 0x4D80, "Solios eV-CL (single-Medium) frame grabber(0x102B-0x4D80)"},
{0x102B, 0x47C1, 0x102B, 0x4D81, "Solios eV-CL (dual-Base) frame grabber(0x102B-0x4D81)"},
{0x102B, 0x47C1, 0x102B, 0x4E80, "Solios eM-CL (single-Medium) frame grabber(0x102B-0x4E80)"},
{0x102B, 0x47C1, 0x102B, 0x4E81, "Solios eM-CL (dual-Base) frame grabber(0x102B-0x4E81)"},
{0x102B, 0x47C2, 0xFFFF, 0xFFFF, "Solios COM port(0x47C2)"},
{0x102B, 0x4949, 0xFFFF, 0xFFFF, "Radient frame grabber family(0x4949)"},
{0x102B, 0x4949, 0x102B, 0x0010, "Radient eCL (Single-full) frame grabber(0x102B-0x0010)"},
{0x102B, 0x4949, 0x102B, 0x0011, "Radient eCLV (Single-full) frame grabber(0x102B-0x0011)"},
{0x102B, 0x4949, 0x102B, 0x0020, "Radient eCL (Dual-base) frame grabber(0x102B-0x0020)"},
{0x102B, 0x4949, 0x102B, 0x0030, "Radient eCL (Dual-full) frame grabber(0x102B-0x0030)"},
{0x102B, 0x4949, 0x102B, 0x0040, "Radient eCL (Quad-base) frame grabber(0x102B-0x0040)"},
{0x102B, 0x4949, 0x102B, 0x0050, "Radient eCL (Golden) frame grabber(0x102B-0x0050)"},
{0x102B, 0x4949, 0x102B, 0x1010, "Radient eV-CXP (quad CXP-6) frame grabber(0x102B-0x1010)"},
{0x102B, 0x4949, 0x102B, 0x1015, "Radient eV-CXP (dual CXP-6) frame grabber(0x102B-0x1015)"},
{0x102B, 0x4949, 0x102B, 0x1020, "Radient eV-CXP (quad CXP-3) frame grabber(0x102B-0x1020)"},
{0x102B, 0x4949, 0x102B, 0x1050, "Radient eV-CXP (Golden) frame grabber(0x102B-0x1050)"},
{0x102B, 0x4CDC, 0xFFFF, 0xFFFF, "Morphis JPEG2000 accelerator(0x4CDC)"},
{0x102B, 0x4F54, 0xFFFF, 0xFFFF, "Morphis (e)Quad frame grabber(0x4F54)"},
{0x102B, 0x4FC5, 0xFFFF, 0xFFFF, "Morphis (e)Dual frame grabber(0x4FC5)"},
{0x102B, 0x5E10, 0xFFFF, 0xFFFF, "Morphis aux I/O(0x5E10)"},
{0x102B, 0x6573, 0xFFFF, 0xFFFF, "Shark 10/100 Multiport SwitchNIC(0x6573)"},
}; /* pci_vid_102B[] */

static pci_id_t const pci_vid_102C[] = {
{0x102C, 0xFFFF, 0xFFFF, 0xFFFF, "Chips and Technologies(0x102C)"},
{0x102C, 0x00B8, 0xFFFF, 0xFFFF, "F64310(0x00B8)"},
{0x102C, 0x00C0, 0xFFFF, 0xFFFF, "F69000 HiQVideo(0x00C0)"},
{0x102C, 0x00C0, 0x102C, 0x00C0, "F69000 HiQVideo(0x102C-0x00C0)"},
{0x102C, 0x00C0, 0x4C53, 0x1000, "CC7/CR7/CP7/VC7/VP7/VR7 mainboard(0x4C53-0x1000)"},
{0x102C, 0x00C0, 0x4C53, 0x1010, "CP5/CR6 mainboard(0x4C53-0x1010)"},
{0x102C, 0x00C0, 0x4C53, 0x1020, "VR6 mainboard(0x4C53-0x1020)"},
{0x102C, 0x00C0, 0x4C53, 0x1030, "PC5 mainboard(0x4C53-0x1030)"},
{0x102C, 0x00C0, 0x4C53, 0x1050, "CT7 mainboard(0x4C53-0x1050)"},
{0x102C, 0x00C0, 0x4C53, 0x1051, "CE7 mainboard(0x4C53-0x1051)"},
{0x102C, 0x00D0, 0xFFFF, 0xFFFF, "F65545(0x00D0)"},
{0x102C, 0x00D8, 0xFFFF, 0xFFFF, "F65545(0x00D8)"},
{0x102C, 0x00DC, 0xFFFF, 0xFFFF, "F65548(0x00DC)"},
{0x102C, 0x00E0, 0xFFFF, 0xFFFF, "F65550(0x00E0)"},
{0x102C, 0x00E4, 0xFFFF, 0xFFFF, "F65554(0x00E4)"},
{0x102C, 0x00E5, 0xFFFF, 0xFFFF, "F65555 HiQVPro(0x00E5)"},
{0x102C, 0x00E5, 0x0E11, 0xB049, "Armada 1700 Laptop Display Controller(0x0E11-0xB049)"},
{0x102C, 0x00E5, 0x1179, 0x0001, "Satellite Pro/Satellite(0x1179-0x0001)"},
{0x102C, 0x00F0, 0xFFFF, 0xFFFF, "F68554(0x00F0)"},
{0x102C, 0x00F4, 0xFFFF, 0xFFFF, "F68554 HiQVision(0x00F4)"},
{0x102C, 0x00F5, 0xFFFF, 0xFFFF, "F68555(0x00F5)"},
{0x102C, 0x0C30, 0xFFFF, 0xFFFF, "F69030(0x0C30)"},
{0x102C, 0x0C30, 0x4C53, 0x1000, "CC7/CR7/CP7/VC7/VP7/VR7 mainboard(0x4C53-0x1000)"},
{0x102C, 0x0C30, 0x4C53, 0x1050, "CT7 mainboard(0x4C53-0x1050)"},
{0x102C, 0x0C30, 0x4C53, 0x1051, "CE7 mainboard(0x4C53-0x1051)"},
{0x102C, 0x0C30, 0x4C53, 0x1080, "CT8 mainboard(0x4C53-0x1080)"},
}; /* pci_vid_102C[] */

static pci_id_t const pci_vid_102D[] = {
{0x102D, 0xFFFF, 0xFFFF, 0xFFFF, "Wyse Technology Inc.(0x102D)"},
{0x102D, 0x50DC, 0xFFFF, 0xFFFF, "3328 Audio(0x50DC)"},
}; /* pci_vid_102D[] */

static pci_id_t const pci_vid_102E[] = {
{0x102E, 0xFFFF, 0xFFFF, 0xFFFF, "Olivetti Advanced Technology(0x102E)"},
}; /* pci_vid_102E[] */

static pci_id_t const pci_vid_102F[] = {
{0x102F, 0xFFFF, 0xFFFF, 0xFFFF, "Toshiba America(0x102F)"},
{0x102F, 0x0009, 0xFFFF, 0xFFFF, "r4x00(0x0009)"},
{0x102F, 0x000A, 0xFFFF, 0xFFFF, "TX3927 MIPS RISC PCI Controller(0x000A)"},
{0x102F, 0x0020, 0xFFFF, 0xFFFF, "ATM Meteor 155(0x0020)"},
{0x102F, 0x0020, 0x102F, 0x00F8, "ATM Meteor 155(0x102F-0x00F8)"},
{0x102F, 0x0030, 0xFFFF, 0xFFFF, "TC35815CF PCI 10/100 Mbit Ethernet Controller(0x0030)"},
{0x102F, 0x0031, 0xFFFF, 0xFFFF, "TC35815CF PCI 10/100 Mbit Ethernet Controller with WOL(0x0031)"},
{0x102F, 0x0032, 0xFFFF, 0xFFFF, "TC35815CF PCI 10/100 Mbit Ethernet Controller on TX4939(0x0032)"},
{0x102F, 0x0105, 0xFFFF, 0xFFFF, "TC86C001 [goku-s] IDE(0x0105)"},
{0x102F, 0x0106, 0xFFFF, 0xFFFF, "TC86C001 [goku-s] USB 1.1 Host(0x0106)"},
{0x102F, 0x0107, 0xFFFF, 0xFFFF, "TC86C001 [goku-s] USB Device Controller(0x0107)"},
{0x102F, 0x0108, 0xFFFF, 0xFFFF, "TC86C001 [goku-s] I2C/SIO/GPIO Controller(0x0108)"},
{0x102F, 0x0180, 0xFFFF, 0xFFFF, "TX4927/38 MIPS RISC PCI Controller(0x0180)"},
{0x102F, 0x0181, 0xFFFF, 0xFFFF, "TX4925 MIPS RISC PCI Controller(0x0181)"},
{0x102F, 0x0182, 0xFFFF, 0xFFFF, "TX4937 MIPS RISC PCI Controller(0x0182)"},
{0x102F, 0x01B4, 0xFFFF, 0xFFFF, "Celleb platform IDE interface(0x01B4)"},
{0x102F, 0x01B5, 0xFFFF, 0xFFFF, "SCC USB 2.0 EHCI controller(0x01B5)"},
{0x102F, 0x01B6, 0xFFFF, 0xFFFF, "SCC USB 1.1 OHCI controller(0x01B6)"},
}; /* pci_vid_102F[] */

static pci_id_t const pci_vid_1030[] = {
{0x1030, 0xFFFF, 0xFFFF, 0xFFFF, "TMC Research(0x1030)"},
}; /* pci_vid_1030[] */

static pci_id_t const pci_vid_1031[] = {
{0x1031, 0xFFFF, 0xFFFF, 0xFFFF, "Miro Computer Products AG(0x1031)"},
{0x1031, 0x5601, 0xFFFF, 0xFFFF, "DC20 ASIC(0x5601)"},
{0x1031, 0x5607, 0xFFFF, 0xFFFF, "Video I/O & motion JPEG compressor(0x5607)"},
{0x1031, 0x5631, 0xFFFF, 0xFFFF, "Media 3D(0x5631)"},
{0x1031, 0x6057, 0xFFFF, 0xFFFF, "MiroVideo DC10/DC30+(0x6057)"},
}; /* pci_vid_1031[] */

static pci_id_t const pci_vid_1032[] = {
{0x1032, 0xFFFF, 0xFFFF, 0xFFFF, "Compaq(0x1032)"},
}; /* pci_vid_1032[] */

static pci_id_t const pci_vid_1033[] = {
{0x1033, 0xFFFF, 0xFFFF, 0xFFFF, "NEC Corporation(0x1033)"},
{0x1033, 0x0000, 0xFFFF, 0xFFFF, "Vr4181A USB Host or Function Control Unit(0x0000)"},
{0x1033, 0x0001, 0xFFFF, 0xFFFF, "PCI to 486-like bus Bridge(0x0001)"},
{0x1033, 0x0002, 0xFFFF, 0xFFFF, "PCI to VL98 Bridge(0x0002)"},
{0x1033, 0x0003, 0xFFFF, 0xFFFF, "ATM Controller(0x0003)"},
{0x1033, 0x0004, 0xFFFF, 0xFFFF, "R4000 PCI Bridge(0x0004)"},
{0x1033, 0x0005, 0xFFFF, 0xFFFF, "PCI to 486-like bus Bridge(0x0005)"},
{0x1033, 0x0006, 0xFFFF, 0xFFFF, "PC-9800 Graphic Accelerator(0x0006)"},
{0x1033, 0x0007, 0xFFFF, 0xFFFF, "PCI to UX-Bus Bridge(0x0007)"},
{0x1033, 0x0008, 0xFFFF, 0xFFFF, "PC-9800 Graphic Accelerator(0x0008)"},
{0x1033, 0x0009, 0xFFFF, 0xFFFF, "PCI to PC9800 Core-Graph Bridge(0x0009)"},
{0x1033, 0x0016, 0xFFFF, 0xFFFF, "PCI to VL Bridge(0x0016)"},
{0x1033, 0x001A, 0xFFFF, 0xFFFF, "[Nile II](0x001A)"},
{0x1033, 0x0021, 0xFFFF, 0xFFFF, "Vrc4373 [Nile I](0x0021)"},
{0x1033, 0x0029, 0xFFFF, 0xFFFF, "PowerVR PCX1(0x0029)"},
{0x1033, 0x002A, 0xFFFF, 0xFFFF, "PowerVR 3D(0x002A)"},
{0x1033, 0x002C, 0xFFFF, 0xFFFF, "Star Alpha 2(0x002C)"},
{0x1033, 0x002D, 0xFFFF, 0xFFFF, "PCI to C-bus Bridge(0x002D)"},
{0x1033, 0x0035, 0xFFFF, 0xFFFF, "OHCI USB Controller(0x0035)"},
{0x1033, 0x0035, 0x1033, 0x0035, "USB Controller(0x1033-0x0035)"},
{0x1033, 0x0035, 0x103C, 0x1293, "USB add-in card(0x103C-0x1293)"},
{0x1033, 0x0035, 0x103C, 0x1294, "USB 2.0 add-in card(0x103C-0x1294)"},
{0x1033, 0x0035, 0x1179, 0x0001, "USB(0x1179-0x0001)"},
{0x1033, 0x0035, 0x1186, 0x0035, "DUB-C2 USB 2.0 2-port 32-bit cardbus controller(0x1186-0x0035)"},
{0x1033, 0x0035, 0x12EE, 0x7000, "Root Hub(0x12EE-0x7000)"},
{0x1033, 0x0035, 0x14C2, 0x0105, "PTI-205N USB 2.0 Host Controller(0x14C2-0x0105)"},
{0x1033, 0x0035, 0x1799, 0x0001, "Root Hub(0x1799-0x0001)"},
{0x1033, 0x0035, 0x1931, 0x000A, "GlobeTrotter Fusion Quad Lite (PPP data)(0x1931-0x000A)"},
{0x1033, 0x0035, 0x1931, 0x000B, "GlobeTrotter Fusion Quad Lite (GSM data)(0x1931-0x000B)"},
{0x1033, 0x0035, 0x807D, 0x0035, "PCI-USB2 (OHCI subsystem)(0x807D-0x0035)"},
{0x1033, 0x0035, 0x8086, 0x4D44, "D850EMV2 motherboard(0x8086-0x4D44)"},
{0x1033, 0x003B, 0xFFFF, 0xFFFF, "PCI to C-bus Bridge(0x003B)"},
{0x1033, 0x003E, 0xFFFF, 0xFFFF, "NAPCCARD Cardbus Controller(0x003E)"},
{0x1033, 0x0046, 0xFFFF, 0xFFFF, "PowerVR PCX2 [midas](0x0046)"},
{0x1033, 0x005A, 0xFFFF, 0xFFFF, "Vrc5074 [Nile 4](0x005A)"},
{0x1033, 0x0063, 0xFFFF, 0xFFFF, "uPD72862 [Firewarden] IEEE1394 OHCI 1.0 Link Controller(0x0063)"},
{0x1033, 0x0067, 0xFFFF, 0xFFFF, "PowerVR Neon 250 Chipset(0x0067)"},
{0x1033, 0x0067, 0x1010, 0x0020, "PowerVR Neon 250 AGP 32Mb(0x1010-0x0020)"},
{0x1033, 0x0067, 0x1010, 0x0080, "PowerVR Neon 250 AGP 16Mb(0x1010-0x0080)"},
{0x1033, 0x0067, 0x1010, 0x0088, "PowerVR Neon 250 16Mb(0x1010-0x0088)"},
{0x1033, 0x0067, 0x1010, 0x0090, "PowerVR Neon 250 AGP 16Mb(0x1010-0x0090)"},
{0x1033, 0x0067, 0x1010, 0x0098, "PowerVR Neon 250 16Mb(0x1010-0x0098)"},
{0x1033, 0x0067, 0x1010, 0x00A0, "PowerVR Neon 250 AGP 32Mb(0x1010-0x00A0)"},
{0x1033, 0x0067, 0x1010, 0x00A8, "PowerVR Neon 250 32Mb(0x1010-0x00A8)"},
{0x1033, 0x0067, 0x1010, 0x0120, "PowerVR Neon 250 AGP 32Mb(0x1010-0x0120)"},
{0x1033, 0x0072, 0xFFFF, 0xFFFF, "uPD72874 IEEE1394 OHCI 1.1 3-port PHY-Link Ctrlr(0x0072)"},
{0x1033, 0x0074, 0xFFFF, 0xFFFF, "56k Voice Modem(0x0074)"},
{0x1033, 0x0074, 0x1033, 0x8014, "RCV56ACF 56k Voice Modem(0x1033-0x8014)"},
{0x1033, 0x009B, 0xFFFF, 0xFFFF, "Vrc5476(0x009B)"},
{0x1033, 0x00A5, 0xFFFF, 0xFFFF, "VRC4173(0x00A5)"},
{0x1033, 0x00A6, 0xFFFF, 0xFFFF, "VRC5477 AC97(0x00A6)"},
{0x1033, 0x00CD, 0xFFFF, 0xFFFF, "uPD72870 [Firewarden] IEEE1394a OHCI 1.0 Link/3-port PHY Controller(0x00CD)"},
{0x1033, 0x00CD, 0x12EE, 0x8011, "Root hub(0x12EE-0x8011)"},
{0x1033, 0x00CE, 0xFFFF, 0xFFFF, "uPD72871 [Firewarden] IEEE1394a OHCI 1.0 Link/1-port PHY Controller(0x00CE)"},
{0x1033, 0x00DF, 0xFFFF, 0xFFFF, "Vr4131(0x00DF)"},
{0x1033, 0x00E0, 0xFFFF, 0xFFFF, "uPD72010x USB 2.0 Controller(0x00E0)"},
{0x1033, 0x00E0, 0x1186, 0xF100, "DUB-C2 USB 2.0 2-port 32-bit cardbus controller(0x1186-0xF100)"},
{0x1033, 0x00E0, 0x12EE, 0x7001, "Root hub(0x12EE-0x7001)"},
{0x1033, 0x00E0, 0x14C2, 0x0205, "PTI-205N USB 2.0 Host Controller(0x14C2-0x0205)"},
{0x1033, 0x00E0, 0x1799, 0x0002, "Root Hub(0x1799-0x0002)"},
{0x1033, 0x00E0, 0x807D, 0x1043, "PCI-USB2 (EHCI subsystem)(0x807D-0x1043)"},
{0x1033, 0x00E0, 0x8086, 0x4D44, "D850EMV2 motherboard(0x8086-0x4D44)"},
{0x1033, 0x00E7, 0xFFFF, 0xFFFF, "uPD72873 [Firewarden] IEEE1394a OHCI 1.1 Link/2-port PHY Controller(0x00E7)"},
{0x1033, 0x00F2, 0xFFFF, 0xFFFF, "uPD72874 [Firewarden] IEEE1394a OHCI 1.1 Link/3-port PHY Controller(0x00F2)"},
{0x1033, 0x00F3, 0xFFFF, 0xFFFF, "uPD6113x Multimedia Decoder/Processor [EMMA2](0x00F3)"},
{0x1033, 0x010C, 0xFFFF, 0xFFFF, "VR7701(0x010C)"},
{0x1033, 0x0125, 0xFFFF, 0xFFFF, "uPD720400 PCI Express - PCI/PCI-X Bridge(0x0125)"},
{0x1033, 0x013A, 0xFFFF, 0xFFFF, "Dual Tuner/MPEG Encoder(0x013A)"},
{0x1033, 0x0194, 0xFFFF, 0xFFFF, "uPD720200 USB 3.0 Host Controller(0x0194)"},
{0x1033, 0x0194, 0x1028, 0x04A3, "Precision M4600(0x1028-0x04A3)"},
{0x1033, 0x0194, 0x1028, 0x04B2, "Vostro 3350(0x1028-0x04B2)"},
{0x1033, 0x0194, 0x1028, 0x04DA, "Vostro 3750(0x1028-0x04DA)"},
{0x1033, 0x0194, 0x1043, 0x8413, "P8P67 Deluxe Motherboard(0x1043-0x8413)"},
{0x1033, 0x0194, 0x104D, 0x907A, "Vaio VPCF1(0x104D-0x907A)"},
{0x1033, 0x0194, 0x1AF4, 0x1100, "QEMU Virtual Machine(0x1AF4-0x1100)"},
{0x1033, 0x0194, 0x1B96, 0x0001, "USB 3.0 PCIe Card(0x1B96-0x0001)"},
{0x1033, 0x01E7, 0xFFFF, 0xFFFF, "uPD72873 [Firewarden] IEEE1394a OHCI 1.1 Link/2-port PHY Controller(0x01E7)"},
{0x1033, 0x01F2, 0xFFFF, 0xFFFF, "uPD72874 [Firewarden] IEEE1394a OHCI 1.1 Link/3-port PHY Controller(0x01F2)"},
}; /* pci_vid_1033[] */

static pci_id_t const pci_vid_1034[] = {
{0x1034, 0xFFFF, 0xFFFF, 0xFFFF, "Framatome Connectors USA Inc.(0x1034)"},
}; /* pci_vid_1034[] */

static pci_id_t const pci_vid_1035[] = {
{0x1035, 0xFFFF, 0xFFFF, 0xFFFF, "Comp. & Comm. Research Lab(0x1035)"},
}; /* pci_vid_1035[] */

static pci_id_t const pci_vid_1036[] = {
{0x1036, 0xFFFF, 0xFFFF, 0xFFFF, "Future Domain Corp.(0x1036)"},
{0x1036, 0x0000, 0xFFFF, 0xFFFF, "TMC-18C30 [36C70](0x0000)"},
}; /* pci_vid_1036[] */

static pci_id_t const pci_vid_1037[] = {
{0x1037, 0xFFFF, 0xFFFF, 0xFFFF, "Hitachi Micro Systems(0x1037)"},
}; /* pci_vid_1037[] */

static pci_id_t const pci_vid_1038[] = {
{0x1038, 0xFFFF, 0xFFFF, 0xFFFF, "AMP, Inc(0x1038)"},
}; /* pci_vid_1038[] */

static pci_id_t const pci_vid_1039[] = {
{0x1039, 0xFFFF, 0xFFFF, 0xFFFF, "Silicon Integrated Systems [SiS](0x1039)"},
{0x1039, 0x0001, 0xFFFF, 0xFFFF, "AGP Port (virtual PCI-to-PCI bridge)(0x0001)"},
{0x1039, 0x0002, 0xFFFF, 0xFFFF, "AGP Port (virtual PCI-to-PCI bridge)(0x0002)"},
{0x1039, 0x0003, 0xFFFF, 0xFFFF, "AGP Port (virtual PCI-to-PCI bridge)(0x0003)"},
{0x1039, 0x0004, 0xFFFF, 0xFFFF, "PCI-to-PCI bridge(0x0004)"},
{0x1039, 0x0004, 0x1039, 0x0000, "PCIe x16 port(0x1039-0x0000)"},
{0x1039, 0x0006, 0xFFFF, 0xFFFF, "85C501/2/3(0x0006)"},
{0x1039, 0x0008, 0xFFFF, 0xFFFF, "SiS85C503/5513 (LPC Bridge)(0x0008)"},
{0x1039, 0x0009, 0xFFFF, 0xFFFF, "5595 Power Management Controller(0x0009)"},
{0x1039, 0x000A, 0xFFFF, 0xFFFF, "PCI-to-PCI bridge(0x000A)"},
{0x1039, 0x000A, 0x1039, 0x0000, "PCIe x1 port(0x1039-0x0000)"},
{0x1039, 0x0016, 0xFFFF, 0xFFFF, "SiS961/2/3 SMBus controller(0x0016)"},
{0x1039, 0x0018, 0xFFFF, 0xFFFF, "SiS85C503/5513 (LPC Bridge)(0x0018)"},
{0x1039, 0x0163, 0xFFFF, 0xFFFF, "163 802.11b/g Wireless LAN Adapter(0x0163)"},
{0x1039, 0x0180, 0xFFFF, 0xFFFF, "RAID bus controller 180 SATA/PATA  [SiS](0x0180)"},
{0x1039, 0x0181, 0xFFFF, 0xFFFF, "SATA(0x0181)"},
{0x1039, 0x0182, 0xFFFF, 0xFFFF, "182 SATA/RAID Controller(0x0182)"},
{0x1039, 0x0182, 0x1734, 0x1095, "D2030-A1(0x1734-0x1095)"},
{0x1039, 0x0186, 0xFFFF, 0xFFFF, "AHCI Controller (0106)(0x0186)"},
{0x1039, 0x0190, 0xFFFF, 0xFFFF, "190 Ethernet Adapter(0x0190)"},
{0x1039, 0x0191, 0xFFFF, 0xFFFF, "191 Gigabit Ethernet Adapter(0x0191)"},
{0x1039, 0x0191, 0x1043, 0x8139, "P5SD2-FM/S mainboard(0x1043-0x8139)"},
{0x1039, 0x0200, 0xFFFF, 0xFFFF, "5597/5598/6326 VGA(0x0200)"},
{0x1039, 0x0200, 0x1039, 0x0000, "SiS5597 SVGA (Shared RAM)(0x1039-0x0000)"},
{0x1039, 0x0204, 0xFFFF, 0xFFFF, "82C204(0x0204)"},
{0x1039, 0x0205, 0xFFFF, 0xFFFF, "SG86C205(0x0205)"},
{0x1039, 0x0300, 0xFFFF, 0xFFFF, "300/305 PCI/AGP VGA Display Adapter(0x0300)"},
{0x1039, 0x0300, 0x107D, 0x2720, "Leadtek WinFast VR300(0x107D-0x2720)"},
{0x1039, 0x0310, 0xFFFF, 0xFFFF, "315H PCI/AGP VGA Display Adapter(0x0310)"},
{0x1039, 0x0315, 0xFFFF, 0xFFFF, "315 PCI/AGP VGA Display Adapter(0x0315)"},
{0x1039, 0x0325, 0xFFFF, 0xFFFF, "315PRO PCI/AGP VGA Display Adapter(0x0325)"},
{0x1039, 0x0330, 0xFFFF, 0xFFFF, "330 [Xabre] PCI/AGP VGA Display Adapter(0x0330)"},
{0x1039, 0x0406, 0xFFFF, 0xFFFF, "85C501/2(0x0406)"},
{0x1039, 0x0496, 0xFFFF, 0xFFFF, "SiS85C496 PCI & CPU Memory Controller (PCM)(0x0496)"},
{0x1039, 0x0530, 0xFFFF, 0xFFFF, "530 Host(0x0530)"},
{0x1039, 0x0540, 0xFFFF, 0xFFFF, "540 Host(0x0540)"},
{0x1039, 0x0550, 0xFFFF, 0xFFFF, "550 Host(0x0550)"},
{0x1039, 0x0597, 0xFFFF, 0xFFFF, "5513C(0x0597)"},
{0x1039, 0x0601, 0xFFFF, 0xFFFF, "85C601(0x0601)"},
{0x1039, 0x0620, 0xFFFF, 0xFFFF, "620 Host(0x0620)"},
{0x1039, 0x0630, 0xFFFF, 0xFFFF, "630 Host(0x0630)"},
{0x1039, 0x0633, 0xFFFF, 0xFFFF, "633 Host(0x0633)"},
{0x1039, 0x0635, 0xFFFF, 0xFFFF, "635 Host(0x0635)"},
{0x1039, 0x0645, 0xFFFF, 0xFFFF, "SiS645 Host & Memory & AGP Controller(0x0645)"},
{0x1039, 0x0646, 0xFFFF, 0xFFFF, "SiS645DX Host & Memory & AGP Controller(0x0646)"},
{0x1039, 0x0648, 0xFFFF, 0xFFFF, "645xx(0x0648)"},
{0x1039, 0x0649, 0xFFFF, 0xFFFF, "SiS649 Host(0x0649)"},
{0x1039, 0x0650, 0xFFFF, 0xFFFF, "650/M650 Host(0x0650)"},
{0x1039, 0x0651, 0xFFFF, 0xFFFF, "651 Host(0x0651)"},
{0x1039, 0x0655, 0xFFFF, 0xFFFF, "655 Host(0x0655)"},
{0x1039, 0x0660, 0xFFFF, 0xFFFF, "660 Host(0x0660)"},
{0x1039, 0x0661, 0xFFFF, 0xFFFF, "661FX/M661FX/M661MX Host(0x0661)"},
{0x1039, 0x0662, 0xFFFF, 0xFFFF, "662 Host(0x0662)"},
{0x1039, 0x0671, 0xFFFF, 0xFFFF, "671MX(0x0671)"},
{0x1039, 0x0730, 0xFFFF, 0xFFFF, "730 Host(0x0730)"},
{0x1039, 0x0733, 0xFFFF, 0xFFFF, "733 Host(0x0733)"},
{0x1039, 0x0735, 0xFFFF, 0xFFFF, "735 Host(0x0735)"},
{0x1039, 0x0740, 0xFFFF, 0xFFFF, "740 Host(0x0740)"},
{0x1039, 0x0741, 0xFFFF, 0xFFFF, "741/741GX/M741 Host(0x0741)"},
{0x1039, 0x0741, 0x1849, 0x0741, "K7S41/K7S41GX motherboard(0x1849-0x0741)"},
{0x1039, 0x0745, 0xFFFF, 0xFFFF, "745 Host(0x0745)"},
{0x1039, 0x0746, 0xFFFF, 0xFFFF, "746 Host(0x0746)"},
{0x1039, 0x0755, 0xFFFF, 0xFFFF, "755 Host(0x0755)"},
{0x1039, 0x0760, 0xFFFF, 0xFFFF, "760/M760 Host(0x0760)"},
{0x1039, 0x0761, 0xFFFF, 0xFFFF, "761/M761 Host(0x0761)"},
{0x1039, 0x0761, 0x1734, 0x1099, "D2030-A1 Motherboard(0x1734-0x1099)"},
{0x1039, 0x0900, 0xFFFF, 0xFFFF, "SiS900 PCI Fast Ethernet(0x0900)"},
{0x1039, 0x0900, 0x1019, 0x0A14, "K7S5A motherboard(0x1019-0x0A14)"},
{0x1039, 0x0900, 0x1039, 0x0900, "SiS900 10/100 Ethernet Adapter onboard(0x1039-0x0900)"},
{0x1039, 0x0900, 0x1043, 0x8035, "CUSI-FX motherboard(0x1043-0x8035)"},
{0x1039, 0x0900, 0x1043, 0x80A7, "Motherboard P4S800D-X(0x1043-0x80A7)"},
{0x1039, 0x0900, 0x1462, 0x0900, "MS-6701 motherboard(0x1462-0x0900)"},
{0x1039, 0x0961, 0xFFFF, 0xFFFF, "SiS961 [MuTIOL Media IO](0x0961)"},
{0x1039, 0x0962, 0xFFFF, 0xFFFF, "SiS962 [MuTIOL Media IO] LPC Controller(0x0962)"},
{0x1039, 0x0963, 0xFFFF, 0xFFFF, "SiS963 [MuTIOL Media IO] LPC Controller(0x0963)"},
{0x1039, 0x0964, 0xFFFF, 0xFFFF, "SiS964 [MuTIOL Media IO] LPC Controller(0x0964)"},
{0x1039, 0x0965, 0xFFFF, 0xFFFF, "SiS965 [MuTIOL Media IO](0x0965)"},
{0x1039, 0x0966, 0xFFFF, 0xFFFF, "SiS966 [MuTIOL Media IO](0x0966)"},
{0x1039, 0x0968, 0xFFFF, 0xFFFF, "SiS968 [MuTIOL Media IO](0x0968)"},
{0x1039, 0x1180, 0xFFFF, 0xFFFF, "SATA Controller / IDE mode(0x1180)"},
{0x1039, 0x1182, 0xFFFF, 0xFFFF, "SATA Controller / RAID mode(0x1182)"},
{0x1039, 0x1182, 0x1039, 0x0180, "SiS 966 4-port SATA controller(0x1039-0x0180)"},
{0x1039, 0x1183, 0xFFFF, 0xFFFF, "SATA Controller / IDE mode(0x1183)"},
{0x1039, 0x1183, 0x1039, 0x0180, "SiS 966 4-port SATA controller(0x1039-0x0180)"},
{0x1039, 0x1184, 0xFFFF, 0xFFFF, "AHCI Controller / RAID mode(0x1184)"},
{0x1039, 0x1185, 0xFFFF, 0xFFFF, "AHCI IDE Controller (0106)(0x1185)"},
{0x1039, 0x3602, 0xFFFF, 0xFFFF, "83C602(0x3602)"},
{0x1039, 0x5107, 0xFFFF, 0xFFFF, "5107(0x5107)"},
{0x1039, 0x5300, 0xFFFF, 0xFFFF, "SiS540 PCI Display Adapter(0x5300)"},
{0x1039, 0x5315, 0xFFFF, 0xFFFF, "550 PCI/AGP VGA Display Adapter(0x5315)"},
{0x1039, 0x5401, 0xFFFF, 0xFFFF, "486 PCI Chipset(0x5401)"},
{0x1039, 0x5511, 0xFFFF, 0xFFFF, "5511/5512(0x5511)"},
{0x1039, 0x5513, 0xFFFF, 0xFFFF, "5513 IDE Controller(0x5513)"},
{0x1039, 0x5513, 0x1019, 0x0970, "P6STP-FL motherboard(0x1019-0x0970)"},
{0x1039, 0x5513, 0x1039, 0x5513, "SiS5513 EIDE Controller (A,B step)(0x1039-0x5513)"},
{0x1039, 0x5513, 0x1043, 0x8035, "CUSI-FX motherboard(0x1043-0x8035)"},
{0x1039, 0x5513, 0x1462, 0x7010, "MS-6701 motherboard(0x1462-0x7010)"},
{0x1039, 0x5513, 0x1631, 0x5513, "GA-8SIML Rev1.0 Motherboard(0x1631-0x5513)"},
{0x1039, 0x5513, 0x1734, 0x1095, "D2030-A1 Motherboard(0x1734-0x1095)"},
{0x1039, 0x5517, 0xFFFF, 0xFFFF, "5517(0x5517)"},
{0x1039, 0x5571, 0xFFFF, 0xFFFF, "5571(0x5571)"},
{0x1039, 0x5581, 0xFFFF, 0xFFFF, "5581 Pentium Chipset(0x5581)"},
{0x1039, 0x5582, 0xFFFF, 0xFFFF, "5582(0x5582)"},
{0x1039, 0x5591, 0xFFFF, 0xFFFF, "5591/5592 Host(0x5591)"},
{0x1039, 0x5596, 0xFFFF, 0xFFFF, "5596 Pentium Chipset(0x5596)"},
{0x1039, 0x5597, 0xFFFF, 0xFFFF, "5597 [SiS5582](0x5597)"},
{0x1039, 0x5600, 0xFFFF, 0xFFFF, "5600 Host(0x5600)"},
{0x1039, 0x6204, 0xFFFF, 0xFFFF, "Video decoder & MPEG interface(0x6204)"},
{0x1039, 0x6205, 0xFFFF, 0xFFFF, "VGA Controller(0x6205)"},
{0x1039, 0x6236, 0xFFFF, 0xFFFF, "6236 3D-AGP(0x6236)"},
{0x1039, 0x6300, 0xFFFF, 0xFFFF, "630/730 PCI/AGP VGA Display Adapter(0x6300)"},
{0x1039, 0x6300, 0x1019, 0x0970, "P6STP-FL motherboard(0x1019-0x0970)"},
{0x1039, 0x6300, 0x1043, 0x8035, "CUSI-FX motherboard(0x1043-0x8035)"},
{0x1039, 0x6300, 0x104D, 0x80E2, "VAIO PCV-J200(0x104D-0x80E2)"},
{0x1039, 0x6306, 0xFFFF, 0xFFFF, "530/620 PCI/AGP VGA Display Adapter(0x6306)"},
{0x1039, 0x6325, 0xFFFF, 0xFFFF, "65x/M650/740 PCI/AGP VGA Display Adapter(0x6325)"},
{0x1039, 0x6325, 0x1039, 0x6325, "SiS 651 onboard [Asus P4SC-EA](0x1039-0x6325)"},
{0x1039, 0x6325, 0x1631, 0x1004, "SiS 651C onboard [Gigabyte GA-8SIML Rev1.0](0x1631-0x1004)"},
{0x1039, 0x6326, 0xFFFF, 0xFFFF, "86C326 5598/6326(0x6326)"},
{0x1039, 0x6326, 0x1039, 0x6326, "SiS6326 GUI Accelerator(0x1039-0x6326)"},
{0x1039, 0x6326, 0x1092, 0x0A50, "SpeedStar A50(0x1092-0x0A50)"},
{0x1039, 0x6326, 0x1092, 0x0A70, "SpeedStar A70(0x1092-0x0A70)"},
{0x1039, 0x6326, 0x1092, 0x4910, "SpeedStar A70(0x1092-0x4910)"},
{0x1039, 0x6326, 0x1092, 0x4920, "SpeedStar A70(0x1092-0x4920)"},
{0x1039, 0x6326, 0x10B0, 0x6326, "S6110-B (AGP)(0x10B0-0x6326)"},
{0x1039, 0x6326, 0x1569, 0x6326, "SiS6326 GUI Accelerator(0x1569-0x6326)"},
{0x1039, 0x6330, 0xFFFF, 0xFFFF, "661/741/760 PCI/AGP or 662/761Gx PCIE VGA Display Adapter(0x6330)"},
{0x1039, 0x6330, 0x1039, 0x6330, "[M]661xX/[M]741[GX]/[M]760 PCI/AGP VGA Adapter(0x1039-0x6330)"},
{0x1039, 0x6330, 0x1043, 0x8113, "SiS Real 256E (ASUS P5S800-VM motherboard)(0x1043-0x8113)"},
{0x1039, 0x6330, 0x1458, 0xD000, "SiS661FX GUI 2D/3D Accelerator(0x1458-0xD000)"},
{0x1039, 0x6330, 0x1734, 0x1099, "D2030-A1(0x1734-0x1099)"},
{0x1039, 0x6350, 0xFFFF, 0xFFFF, "770/670 PCIE VGA Display Adapter(0x6350)"},
{0x1039, 0x6351, 0xFFFF, 0xFFFF, "771/671 PCIE VGA Display Adapter(0x6351)"},
{0x1039, 0x7001, 0xFFFF, 0xFFFF, "USB 1.1 Controller(0x7001)"},
{0x1039, 0x7001, 0x1019, 0x0A14, "K7S5A motherboard(0x1019-0x0A14)"},
{0x1039, 0x7001, 0x1039, 0x7000, "Onboard USB Controller(0x1039-0x7000)"},
{0x1039, 0x7001, 0x1462, 0x5470, "ECS K7SOM+ motherboard(0x1462-0x5470)"},
{0x1039, 0x7001, 0x1462, 0x7010, "MS-6701 motherboard(0x1462-0x7010)"},
{0x1039, 0x7001, 0x1734, 0x1095, "D2030-A1 Motherboard(0x1734-0x1095)"},
{0x1039, 0x7002, 0xFFFF, 0xFFFF, "USB 2.0 Controller(0x7002)"},
{0x1039, 0x7002, 0x1462, 0x5470, "K7SOM+ 5.2C Motherboard(0x1462-0x5470)"},
{0x1039, 0x7002, 0x1462, 0x7010, "MS-6701 motherboard(0x1462-0x7010)"},
{0x1039, 0x7002, 0x1509, 0x7002, "Onboard USB Controller(0x1509-0x7002)"},
{0x1039, 0x7002, 0x1734, 0x1095, "D2030-A1(0x1734-0x1095)"},
{0x1039, 0x7007, 0xFFFF, 0xFFFF, "FireWire Controller(0x7007)"},
{0x1039, 0x7007, 0x1462, 0x701D, "MS-6701(0x1462-0x701D)"},
{0x1039, 0x7012, 0xFFFF, 0xFFFF, "SiS7012 AC'97 Sound Controller(0x7012)"},
{0x1039, 0x7012, 0x1019, 0x0F05, "A928 (i-Buddie)(0x1019-0x0F05)"},
{0x1039, 0x7012, 0x1039, 0x7012, "SiS 7012 onboard [Asus P4SC-EA] AC'97 Sound Controller(0x1039-0x7012)"},
{0x1039, 0x7012, 0x1043, 0x818F, "A8S-X Motherboard(0x1043-0x818F)"},
{0x1039, 0x7012, 0x13F6, 0x0300, "CMI9739(A) on ECS K7S series motherboard(0x13F6-0x0300)"},
{0x1039, 0x7012, 0x1462, 0x5850, "MSI 648 Max (MS-6585)(0x1462-0x5850)"},
{0x1039, 0x7012, 0x1462, 0x7010, "MS-6701 motherboard(0x1462-0x7010)"},
{0x1039, 0x7012, 0x15BD, 0x1001, "DFI 661FX motherboard(0x15BD-0x1001)"},
{0x1039, 0x7012, 0x1734, 0x109F, "D2030-A1 Motherboard(0x1734-0x109F)"},
{0x1039, 0x7012, 0x1849, 0x7012, "K7S41GX motherboard(0x1849-0x7012)"},
{0x1039, 0x7013, 0xFFFF, 0xFFFF, "AC'97 Modem Controller(0x7013)"},
{0x1039, 0x7016, 0xFFFF, 0xFFFF, "SiS7016 PCI Fast Ethernet Adapter(0x7016)"},
{0x1039, 0x7016, 0x1039, 0x7016, "SiS7016 10/100 Ethernet Adapter(0x1039-0x7016)"},
{0x1039, 0x7018, 0xFFFF, 0xFFFF, "SiS PCI Audio Accelerator(0x7018)"},
{0x1039, 0x7018, 0x1014, 0x01B6, "SiS PCI Audio Accelerator(0x1014-0x01B6)"},
{0x1039, 0x7018, 0x1014, 0x01B7, "SiS PCI Audio Accelerator(0x1014-0x01B7)"},
{0x1039, 0x7018, 0x1019, 0x7018, "SiS PCI Audio Accelerator(0x1019-0x7018)"},
{0x1039, 0x7018, 0x1025, 0x000E, "SiS PCI Audio Accelerator(0x1025-0x000E)"},
{0x1039, 0x7018, 0x1025, 0x0018, "SiS PCI Audio Accelerator(0x1025-0x0018)"},
{0x1039, 0x7018, 0x1039, 0x7018, "SiS PCI Audio Accelerator(0x1039-0x7018)"},
{0x1039, 0x7018, 0x1043, 0x1453, "SiS PCI Audio Accelerator(0x1043-0x1453)"},
{0x1039, 0x7018, 0x1043, 0x800B, "SiS PCI Audio Accelerator(0x1043-0x800B)"},
{0x1039, 0x7018, 0x104D, 0x80E2, "VAIO PCV-J200(0x104D-0x80E2)"},
{0x1039, 0x7018, 0x1054, 0x7018, "SiS PCI Audio Accelerator(0x1054-0x7018)"},
{0x1039, 0x7018, 0x107D, 0x5330, "SiS PCI Audio Accelerator(0x107D-0x5330)"},
{0x1039, 0x7018, 0x107D, 0x5350, "SiS PCI Audio Accelerator(0x107D-0x5350)"},
{0x1039, 0x7018, 0x1170, 0x3209, "SiS PCI Audio Accelerator(0x1170-0x3209)"},
{0x1039, 0x7018, 0x1462, 0x400A, "SiS PCI Audio Accelerator(0x1462-0x400A)"},
{0x1039, 0x7018, 0x14A4, 0x2089, "SiS PCI Audio Accelerator(0x14A4-0x2089)"},
{0x1039, 0x7018, 0x14CD, 0x2194, "SiS PCI Audio Accelerator(0x14CD-0x2194)"},
{0x1039, 0x7018, 0x14FF, 0x1100, "SiS PCI Audio Accelerator(0x14FF-0x1100)"},
{0x1039, 0x7018, 0x152D, 0x8808, "SiS PCI Audio Accelerator(0x152D-0x8808)"},
{0x1039, 0x7018, 0x1558, 0x1103, "SiS PCI Audio Accelerator(0x1558-0x1103)"},
{0x1039, 0x7018, 0x1558, 0x2200, "SiS PCI Audio Accelerator(0x1558-0x2200)"},
{0x1039, 0x7018, 0x1563, 0x7018, "SiS PCI Audio Accelerator(0x1563-0x7018)"},
{0x1039, 0x7018, 0x15C5, 0x0111, "SiS PCI Audio Accelerator(0x15C5-0x0111)"},
{0x1039, 0x7018, 0x270F, 0xA171, "SiS PCI Audio Accelerator(0x270F-0xA171)"},
{0x1039, 0x7018, 0xA0A0, 0x0022, "SiS PCI Audio Accelerator(0xA0A0-0x0022)"},
{0x1039, 0x7019, 0xFFFF, 0xFFFF, "SiS7019 Audio Accelerator(0x7019)"},
{0x1039, 0x7502, 0xFFFF, 0xFFFF, "Azalia Audio Controller(0x7502)"},
{0x1039, 0x7502, 0x1043, 0x81A1, "P5SD2-FM/S mainboard(0x1043-0x81A1)"},
}; /* pci_vid_1039[] */

static pci_id_t const pci_vid_103A[] = {
{0x103A, 0xFFFF, 0xFFFF, 0xFFFF, "Seiko Epson Corporation(0x103A)"},
}; /* pci_vid_103A[] */

static pci_id_t const pci_vid_103B[] = {
{0x103B, 0xFFFF, 0xFFFF, 0xFFFF, "Tatung Corp. Of America(0x103B)"},
}; /* pci_vid_103B[] */

static pci_id_t const pci_vid_103C[] = {
{0x103C, 0xFFFF, 0xFFFF, 0xFFFF, "Hewlett-Packard Company(0x103C)"},
{0x103C, 0x1005, 0xFFFF, 0xFFFF, "A4977A Visualize EG(0x1005)"},
{0x103C, 0x1008, 0xFFFF, 0xFFFF, "Visualize FX(0x1008)"},
{0x103C, 0x1020, 0xFFFF, 0xFFFF, "548XX Scope Interface(0x1020)"},
{0x103C, 0x1028, 0xFFFF, 0xFFFF, "Tach TL Fibre Channel Host Adapter(0x1028)"},
{0x103C, 0x1029, 0xFFFF, 0xFFFF, "Tach XL2 Fibre Channel Host Adapter(0x1029)"},
{0x103C, 0x1029, 0x107E, 0x000F, "Interphase 5560 Fibre Channel Adapter(0x107E-0x000F)"},
{0x103C, 0x1029, 0x9004, 0x9210, "1Gb/2Gb Family Fibre Channel Controller(0x9004-0x9210)"},
{0x103C, 0x1029, 0x9004, 0x9211, "1Gb/2Gb Family Fibre Channel Controller(0x9004-0x9211)"},
{0x103C, 0x102A, 0xFFFF, 0xFFFF, "Tach TS Fibre Channel Host Adapter(0x102A)"},
{0x103C, 0x102A, 0x107E, 0x000E, "Interphase 5540/5541 Fibre Channel Adapter(0x107E-0x000E)"},
{0x103C, 0x102A, 0x9004, 0x9110, "1Gb/2Gb Family Fibre Channel Controller(0x9004-0x9110)"},
{0x103C, 0x102A, 0x9004, 0x9111, "1Gb/2Gb Family Fibre Channel Controller(0x9004-0x9111)"},
{0x103C, 0x1030, 0xFFFF, 0xFFFF, "J2585A DeskDirect 10/100VG NIC(0x1030)"},
{0x103C, 0x1031, 0xFFFF, 0xFFFF, "J2585B HP 10/100VG PCI LAN Adapter(0x1031)"},
{0x103C, 0x1031, 0x103C, 0x1040, "J2973A DeskDirect 10BaseT NIC(0x103C-0x1040)"},
{0x103C, 0x1031, 0x103C, 0x1041, "J2585B DeskDirect 10/100VG NIC(0x103C-0x1041)"},
{0x103C, 0x1031, 0x103C, 0x1042, "J2970A DeskDirect 10BaseT/2 NIC(0x103C-0x1042)"},
{0x103C, 0x1040, 0xFFFF, 0xFFFF, "J2973A DeskDirect 10BaseT NIC(0x1040)"},
{0x103C, 0x1041, 0xFFFF, 0xFFFF, "J2585B DeskDirect 10/100 NIC(0x1041)"},
{0x103C, 0x1042, 0xFFFF, 0xFFFF, "J2970A DeskDirect 10BaseT/2 NIC(0x1042)"},
{0x103C, 0x1048, 0xFFFF, 0xFFFF, "Diva Serial [GSP] Multiport UART(0x1048)"},
{0x103C, 0x1048, 0x103C, 0x1049, "Tosca Console(0x103C-0x1049)"},
{0x103C, 0x1048, 0x103C, 0x104A, "Tosca Secondary(0x103C-0x104A)"},
{0x103C, 0x1048, 0x103C, 0x104B, "Maestro SP2(0x103C-0x104B)"},
{0x103C, 0x1048, 0x103C, 0x1223, "Superdome Console(0x103C-0x1223)"},
{0x103C, 0x1048, 0x103C, 0x1226, "Keystone SP2(0x103C-0x1226)"},
{0x103C, 0x1048, 0x103C, 0x1227, "Powerbar SP2(0x103C-0x1227)"},
{0x103C, 0x1048, 0x103C, 0x1282, "Everest SP2(0x103C-0x1282)"},
{0x103C, 0x1048, 0x103C, 0x1301, "Diva RMP3(0x103C-0x1301)"},
{0x103C, 0x1054, 0xFFFF, 0xFFFF, "PCI Local Bus Adapter(0x1054)"},
{0x103C, 0x1064, 0xFFFF, 0xFFFF, "79C970 PCnet Ethernet Controller(0x1064)"},
{0x103C, 0x108B, 0xFFFF, 0xFFFF, "Visualize FXe(0x108B)"},
{0x103C, 0x10C1, 0xFFFF, 0xFFFF, "NetServer Smart IRQ Router(0x10C1)"},
{0x103C, 0x10ED, 0xFFFF, 0xFFFF, "TopTools Remote Control(0x10ED)"},
{0x103C, 0x10F0, 0xFFFF, 0xFFFF, "rio System Bus Adapter(0x10F0)"},
{0x103C, 0x10F1, 0xFFFF, 0xFFFF, "rio I/O Controller(0x10F1)"},
{0x103C, 0x1219, 0xFFFF, 0xFFFF, "NetServer PCI Hot-Plug Controller(0x1219)"},
{0x103C, 0x121A, 0xFFFF, 0xFFFF, "NetServer SMIC Controller(0x121A)"},
{0x103C, 0x121B, 0xFFFF, 0xFFFF, "NetServer Legacy COM Port Decoder(0x121B)"},
{0x103C, 0x121C, 0xFFFF, 0xFFFF, "NetServer PCI COM Port Decoder(0x121C)"},
{0x103C, 0x1229, 0xFFFF, 0xFFFF, "zx1 System Bus Adapter(0x1229)"},
{0x103C, 0x122A, 0xFFFF, 0xFFFF, "zx1 I/O Controller(0x122A)"},
{0x103C, 0x122E, 0xFFFF, 0xFFFF, "PCI-X Local Bus Adapter(0x122E)"},
{0x103C, 0x127B, 0xFFFF, 0xFFFF, "sx1000 System Bus Adapter(0x127B)"},
{0x103C, 0x127C, 0xFFFF, 0xFFFF, "sx1000 I/O Controller(0x127C)"},
{0x103C, 0x128D, 0xFFFF, 0xFFFF, "Diva [GSP] Management Board(0x128D)"},
{0x103C, 0x1290, 0xFFFF, 0xFFFF, "Auxiliary Diva Serial Port(0x1290)"},
{0x103C, 0x1290, 0x103C, 0x1291, "Diva SP2(0x103C-0x1291)"},
{0x103C, 0x1291, 0xFFFF, 0xFFFF, "Auxiliary Diva Serial Port(0x1291)"},
{0x103C, 0x12B4, 0xFFFF, 0xFFFF, "zx1 QuickSilver AGP8x Local Bus Adapter(0x12B4)"},
{0x103C, 0x12EB, 0xFFFF, 0xFFFF, "sx2000 System Bus Adapter(0x12EB)"},
{0x103C, 0x12EC, 0xFFFF, 0xFFFF, "sx2000 I/O Controller(0x12EC)"},
{0x103C, 0x12EE, 0xFFFF, 0xFFFF, "PCI-X 2.0 Local Bus Adapter(0x12EE)"},
{0x103C, 0x1302, 0xFFFF, 0xFFFF, "RMP-3 Shared Memory Driver(0x1302)"},
{0x103C, 0x1303, 0xFFFF, 0xFFFF, "RMP-3 (Remote Management Processor)(0x1303)"},
{0x103C, 0x22F6, 0xFFFF, 0xFFFF, "iLO5 Virtual USB Controller(0x22F6)"},
{0x103C, 0x22F6, 0x1590, 0x00E4, "iLO5 Standard Virtual USB Controller(0x1590-0x00E4)"},
{0x103C, 0x2910, 0xFFFF, 0xFFFF, "E2910A PCIBus Exerciser(0x2910)"},
{0x103C, 0x2925, 0xFFFF, 0xFFFF, "E2925A 32 Bit, 33 MHzPCI Exerciser & Analyzer(0x2925)"},
{0x103C, 0x3206, 0xFFFF, 0xFFFF, "Adaptec Embedded Serial ATA HostRAID(0x3206)"},
{0x103C, 0x3220, 0xFFFF, 0xFFFF, "Smart Array P600(0x3220)"},
{0x103C, 0x3220, 0x103C, 0x3225, "3 Gb/s SAS RAID(0x103C-0x3225)"},
{0x103C, 0x3230, 0xFFFF, 0xFFFF, "Smart Array Controller(0x3230)"},
{0x103C, 0x3230, 0x103C, 0x3223, "Smart Array P800(0x103C-0x3223)"},
{0x103C, 0x3230, 0x103C, 0x3234, "P400 SAS Controller(0x103C-0x3234)"},
{0x103C, 0x3230, 0x103C, 0x3235, "P400i SAS Controller(0x103C-0x3235)"},
{0x103C, 0x3230, 0x103C, 0x3237, "E500 SAS Controller(0x103C-0x3237)"},
{0x103C, 0x3230, 0x103C, 0x323D, "P700m SAS Controller(0x103C-0x323D)"},
{0x103C, 0x3238, 0xFFFF, 0xFFFF, "Smart Array E200i (SAS Controller)(0x3238)"},
{0x103C, 0x3238, 0x103C, 0x3211, "Smart Array E200i(0x103C-0x3211)"},
{0x103C, 0x3238, 0x103C, 0x3212, "Smart Array E200(0x103C-0x3212)"},
{0x103C, 0x3239, 0xFFFF, 0xFFFF, "Smart Array Gen9 Controllers(0x3239)"},
{0x103C, 0x3239, 0x103C, 0x21BD, "P244br(0x103C-0x21BD)"},
{0x103C, 0x3239, 0x103C, 0x21BE, "P741m(0x103C-0x21BE)"},
{0x103C, 0x3239, 0x103C, 0x21BF, "H240ar(0x103C-0x21BF)"},
{0x103C, 0x3239, 0x103C, 0x21C0, "P440ar(0x103C-0x21C0)"},
{0x103C, 0x3239, 0x103C, 0x21C1, "P840ar(0x103C-0x21C1)"},
{0x103C, 0x3239, 0x103C, 0x21C2, "P440(0x103C-0x21C2)"},
{0x103C, 0x3239, 0x103C, 0x21C3, "P441(0x103C-0x21C3)"},
{0x103C, 0x3239, 0x103C, 0x21C4, "Smart Array(0x103C-0x21C4)"},
{0x103C, 0x3239, 0x103C, 0x21C5, "P841(0x103C-0x21C5)"},
{0x103C, 0x3239, 0x103C, 0x21C6, "H244br(0x103C-0x21C6)"},
{0x103C, 0x3239, 0x103C, 0x21C7, "H240(0x103C-0x21C7)"},
{0x103C, 0x3239, 0x103C, 0x21C8, "H241(0x103C-0x21C8)"},
{0x103C, 0x3239, 0x103C, 0x21C9, "Smart Array(0x103C-0x21C9)"},
{0x103C, 0x3239, 0x103C, 0x21CA, "P246br(0x103C-0x21CA)"},
{0x103C, 0x3239, 0x103C, 0x21CB, "P840(0x103C-0x21CB)"},
{0x103C, 0x3239, 0x103C, 0x21CC, "Smart Array(0x103C-0x21CC)"},
{0x103C, 0x3239, 0x103C, 0x21CD, "P240nr(0x103C-0x21CD)"},
{0x103C, 0x3239, 0x103C, 0x21CE, "H240nr(0x103C-0x21CE)"},
{0x103C, 0x323A, 0xFFFF, 0xFFFF, "Smart Array G6 controllers(0x323A)"},
{0x103C, 0x323A, 0x103C, 0x3241, "Smart Array P212(0x103C-0x3241)"},
{0x103C, 0x323A, 0x103C, 0x3243, "Smart Array P410(0x103C-0x3243)"},
{0x103C, 0x323A, 0x103C, 0x3245, "Smart Array P410i(0x103C-0x3245)"},
{0x103C, 0x323A, 0x103C, 0x3247, "Smart Array P411(0x103C-0x3247)"},
{0x103C, 0x323A, 0x103C, 0x3249, "Smart Array P812(0x103C-0x3249)"},
{0x103C, 0x323A, 0x103C, 0x324A, "Smart Array 712m (Mezzanine RAID controller)(0x103C-0x324A)"},
{0x103C, 0x323A, 0x103C, 0x324B, "Smart Array P711m (Mezzanine RAID controller)(0x103C-0x324B)"},
{0x103C, 0x323B, 0xFFFF, 0xFFFF, "Smart Array Gen8 Controllers(0x323B)"},
{0x103C, 0x323B, 0x103C, 0x3350, "P222(0x103C-0x3350)"},
{0x103C, 0x323B, 0x103C, 0x3351, "P420(0x103C-0x3351)"},
{0x103C, 0x323B, 0x103C, 0x3352, "P421(0x103C-0x3352)"},
{0x103C, 0x323B, 0x103C, 0x3354, "P420i(0x103C-0x3354)"},
{0x103C, 0x323B, 0x103C, 0x3355, "P220i(0x103C-0x3355)"},
{0x103C, 0x323C, 0xFFFF, 0xFFFF, "Smart Array Gen8+ Controllers(0x323C)"},
{0x103C, 0x323C, 0x103C, 0x1920, "P430i(0x103C-0x1920)"},
{0x103C, 0x323C, 0x103C, 0x1921, "P830i(0x103C-0x1921)"},
{0x103C, 0x323C, 0x103C, 0x1922, "P430(0x103C-0x1922)"},
{0x103C, 0x323C, 0x103C, 0x1923, "P431(0x103C-0x1923)"},
{0x103C, 0x323C, 0x103C, 0x1924, "P830(0x103C-0x1924)"},
{0x103C, 0x323C, 0x103C, 0x1925, "Smart Array(0x103C-0x1925)"},
{0x103C, 0x323C, 0x103C, 0x1926, "P731m(0x103C-0x1926)"},
{0x103C, 0x323C, 0x103C, 0x1928, "P230i(0x103C-0x1928)"},
{0x103C, 0x3300, 0xFFFF, 0xFFFF, "Integrated Lights-Out Standard Virtual USB Controller(0x3300)"},
{0x103C, 0x3300, 0x103C, 0x3304, "iLO2(0x103C-0x3304)"},
{0x103C, 0x3300, 0x103C, 0x3305, "iLO2(0x103C-0x3305)"},
{0x103C, 0x3300, 0x103C, 0x3309, "iLO2 GXL/iLO3 GXE(0x103C-0x3309)"},
{0x103C, 0x3300, 0x103C, 0x330E, "iLO3(0x103C-0x330E)"},
{0x103C, 0x3300, 0x103C, 0x3381, "iLO4(0x103C-0x3381)"},
{0x103C, 0x3301, 0xFFFF, 0xFFFF, "Integrated Lights-Out Standard Serial Port(0x3301)"},
{0x103C, 0x3301, 0x103C, 0x3304, "iLO2(0x103C-0x3304)"},
{0x103C, 0x3301, 0x103C, 0x3305, "iLO2(0x103C-0x3305)"},
{0x103C, 0x3301, 0x103C, 0x330E, "iLO3(0x103C-0x330E)"},
{0x103C, 0x3301, 0x103C, 0x3381, "iLO4(0x103C-0x3381)"},
{0x103C, 0x3302, 0xFFFF, 0xFFFF, "Integrated Lights-Out Standard KCS Interface(0x3302)"},
{0x103C, 0x3302, 0x103C, 0x3304, "iLO2(0x103C-0x3304)"},
{0x103C, 0x3302, 0x103C, 0x3305, "iLO2(0x103C-0x3305)"},
{0x103C, 0x3302, 0x103C, 0x330E, "iLO3(0x103C-0x330E)"},
{0x103C, 0x3302, 0x103C, 0x3381, "iLO4(0x103C-0x3381)"},
{0x103C, 0x3305, 0xFFFF, 0xFFFF, "Integrated Lights-Out (iLO2) Controller(0x3305)"},
{0x103C, 0x3306, 0xFFFF, 0xFFFF, "Integrated Lights-Out Standard Slave Instrumentation & System Support(0x3306)"},
{0x103C, 0x3306, 0x103C, 0x330E, "iLO3(0x103C-0x330E)"},
{0x103C, 0x3306, 0x103C, 0x3381, "iLO4(0x103C-0x3381)"},
{0x103C, 0x3306, 0x1590, 0x00E4, "iLO5(0x1590-0x00E4)"},
{0x103C, 0x3307, 0xFFFF, 0xFFFF, "Integrated Lights-Out Standard Management Processor Support and Messaging(0x3307)"},
{0x103C, 0x3307, 0x103C, 0x3309, "iLO 2(0x103C-0x3309)"},
{0x103C, 0x3307, 0x103C, 0x330E, "iLO3(0x103C-0x330E)"},
{0x103C, 0x3307, 0x103C, 0x3381, "iLO4(0x103C-0x3381)"},
{0x103C, 0x3308, 0xFFFF, 0xFFFF, "Integrated Lights-Out Standard MS Watchdog Timer(0x3308)"},
{0x103C, 0x3308, 0x103C, 0x330E, "iLO3(0x103C-0x330E)"},
{0x103C, 0x3308, 0x103C, 0x3381, "iLO4(0x103C-0x3381)"},
{0x103C, 0x4030, 0xFFFF, 0xFFFF, "zx2 System Bus Adapter(0x4030)"},
{0x103C, 0x4031, 0xFFFF, 0xFFFF, "zx2 I/O Controller(0x4031)"},
{0x103C, 0x4037, 0xFFFF, 0xFFFF, "PCIe Local Bus Adapter(0x4037)"},
{0x103C, 0x9602, 0xFFFF, 0xFFFF, "AMD RS780/RS880 PCI to PCI bridge (int gfx)(0x9602)"},
{0x103C, 0x9602, 0x103C, 0x1609, "ProLiant MicroServer N36L(0x103C-0x1609)"},
}; /* pci_vid_103C[] */

static pci_id_t const pci_vid_103E[] = {
{0x103E, 0xFFFF, 0xFFFF, 0xFFFF, "Solliday Engineering(0x103E)"},
}; /* pci_vid_103E[] */

static pci_id_t const pci_vid_103F[] = {
{0x103F, 0xFFFF, 0xFFFF, 0xFFFF, "Synopsys/Logic Modeling Group(0x103F)"},
}; /* pci_vid_103F[] */

static pci_id_t const pci_vid_1040[] = {
{0x1040, 0xFFFF, 0xFFFF, 0xFFFF, "Accelgraphics Inc.(0x1040)"},
}; /* pci_vid_1040[] */

static pci_id_t const pci_vid_1041[] = {
{0x1041, 0xFFFF, 0xFFFF, 0xFFFF, "Computrend(0x1041)"},
}; /* pci_vid_1041[] */

static pci_id_t const pci_vid_1042[] = {
{0x1042, 0xFFFF, 0xFFFF, 0xFFFF, "Micron(0x1042)"},
{0x1042, 0x1000, 0xFFFF, 0xFFFF, "PC Tech RZ1000(0x1000)"},
{0x1042, 0x1001, 0xFFFF, 0xFFFF, "PC Tech RZ1001(0x1001)"},
{0x1042, 0x3000, 0xFFFF, 0xFFFF, "Samurai_0(0x3000)"},
{0x1042, 0x3010, 0xFFFF, 0xFFFF, "Samurai_1(0x3010)"},
{0x1042, 0x3020, 0xFFFF, 0xFFFF, "Samurai_IDE(0x3020)"},
}; /* pci_vid_1042[] */

static pci_id_t const pci_vid_1043[] = {
{0x1043, 0xFFFF, 0xFFFF, 0xFFFF, "ASUSTeK Computer Inc.(0x1043)"},
{0x1043, 0x0675, 0xFFFF, 0xFFFF, "ISDNLink P-IN100-ST-D(0x0675)"},
{0x1043, 0x0675, 0x0675, 0x1704, "ISDN Adapter (PCI Bus, D, C)(0x0675-0x1704)"},
{0x1043, 0x0675, 0x0675, 0x1707, "ISDN Adapter (PCI Bus, DV, W)(0x0675-0x1707)"},
{0x1043, 0x0675, 0x10CF, 0x105E, "ISDN Adapter (PCI Bus, DV, W)(0x10CF-0x105E)"},
{0x1043, 0x9602, 0xFFFF, 0xFFFF, "AMD RS780/RS880 PCI to PCI bridge (int gfx)(0x9602)"},
{0x1043, 0x9602, 0x1043, 0x83A2, "M4A785TD Motherboard(0x1043-0x83A2)"},
}; /* pci_vid_1043[] */

static pci_id_t const pci_vid_1044[] = {
{0x1044, 0xFFFF, 0xFFFF, 0xFFFF, "Adaptec (formerly DPT)(0x1044)"},
{0x1044, 0x1012, 0xFFFF, 0xFFFF, "Domino RAID Engine(0x1012)"},
{0x1044, 0xA400, 0xFFFF, 0xFFFF, "SmartCache/Raid I-IV Controller(0xA400)"},
{0x1044, 0xA500, 0xFFFF, 0xFFFF, "PCI Bridge(0xA500)"},
{0x1044, 0xA501, 0xFFFF, 0xFFFF, "SmartRAID V Controller(0xA501)"},
{0x1044, 0xA501, 0x1044, 0xC001, "PM1554U2 Ultra2 Single Channel(0x1044-0xC001)"},
{0x1044, 0xA501, 0x1044, 0xC002, "PM1654U2 Ultra2 Single Channel(0x1044-0xC002)"},
{0x1044, 0xA501, 0x1044, 0xC003, "PM1564U3 Ultra3 Single Channel(0x1044-0xC003)"},
{0x1044, 0xA501, 0x1044, 0xC004, "PM1564U3 Ultra3 Dual Channel(0x1044-0xC004)"},
{0x1044, 0xA501, 0x1044, 0xC005, "PM1554U2 Ultra2 Single Channel (NON ACPI)(0x1044-0xC005)"},
{0x1044, 0xA501, 0x1044, 0xC00A, "PM2554U2 Ultra2 Single Channel(0x1044-0xC00A)"},
{0x1044, 0xA501, 0x1044, 0xC00B, "PM2654U2 Ultra2 Single Channel(0x1044-0xC00B)"},
{0x1044, 0xA501, 0x1044, 0xC00C, "PM2664U3 Ultra3 Single Channel(0x1044-0xC00C)"},
{0x1044, 0xA501, 0x1044, 0xC00D, "PM2664U3 Ultra3 Dual Channel(0x1044-0xC00D)"},
{0x1044, 0xA501, 0x1044, 0xC00E, "PM2554U2 Ultra2 Single Channel (NON ACPI)(0x1044-0xC00E)"},
{0x1044, 0xA501, 0x1044, 0xC00F, "PM2654U2 Ultra2 Single Channel (NON ACPI)(0x1044-0xC00F)"},
{0x1044, 0xA501, 0x1044, 0xC014, "PM3754U2 Ultra2 Single Channel (NON ACPI)(0x1044-0xC014)"},
{0x1044, 0xA501, 0x1044, 0xC015, "PM3755U2B Ultra2 Single Channel (NON ACPI)(0x1044-0xC015)"},
{0x1044, 0xA501, 0x1044, 0xC016, "PM3755F Fibre Channel (NON ACPI)(0x1044-0xC016)"},
{0x1044, 0xA501, 0x1044, 0xC01E, "PM3757U2 Ultra2 Single Channel(0x1044-0xC01E)"},
{0x1044, 0xA501, 0x1044, 0xC01F, "PM3757U2 Ultra2 Dual Channel(0x1044-0xC01F)"},
{0x1044, 0xA501, 0x1044, 0xC020, "PM3767U3 Ultra3 Dual Channel(0x1044-0xC020)"},
{0x1044, 0xA501, 0x1044, 0xC021, "PM3767U3 Ultra3 Quad Channel(0x1044-0xC021)"},
{0x1044, 0xA501, 0x1044, 0xC028, "PM2865U3 Ultra3 Single Channel(0x1044-0xC028)"},
{0x1044, 0xA501, 0x1044, 0xC029, "PM2865U3 Ultra3 Dual Channel(0x1044-0xC029)"},
{0x1044, 0xA501, 0x1044, 0xC02A, "PM2865F Fibre Channel(0x1044-0xC02A)"},
{0x1044, 0xA501, 0x1044, 0xC03C, "2000S Ultra3 Single Channel(0x1044-0xC03C)"},
{0x1044, 0xA501, 0x1044, 0xC03D, "2000S Ultra3 Dual Channel(0x1044-0xC03D)"},
{0x1044, 0xA501, 0x1044, 0xC03E, "2000F Fibre Channel(0x1044-0xC03E)"},
{0x1044, 0xA501, 0x1044, 0xC046, "3000S Ultra3 Single Channel(0x1044-0xC046)"},
{0x1044, 0xA501, 0x1044, 0xC047, "3000S Ultra3 Dual Channel(0x1044-0xC047)"},
{0x1044, 0xA501, 0x1044, 0xC048, "3000F Fibre Channel(0x1044-0xC048)"},
{0x1044, 0xA501, 0x1044, 0xC050, "5000S Ultra3 Single Channel(0x1044-0xC050)"},
{0x1044, 0xA501, 0x1044, 0xC051, "5000S Ultra3 Dual Channel(0x1044-0xC051)"},
{0x1044, 0xA501, 0x1044, 0xC052, "5000F Fibre Channel(0x1044-0xC052)"},
{0x1044, 0xA501, 0x1044, 0xC05A, "2400A UDMA Four Channel(0x1044-0xC05A)"},
{0x1044, 0xA501, 0x1044, 0xC05B, "2400A UDMA Four Channel DAC(0x1044-0xC05B)"},
{0x1044, 0xA501, 0x1044, 0xC064, "3010S Ultra3 Dual Channel(0x1044-0xC064)"},
{0x1044, 0xA501, 0x1044, 0xC065, "3410S Ultra160 Four Channel(0x1044-0xC065)"},
{0x1044, 0xA501, 0x1044, 0xC066, "3010S Fibre Channel(0x1044-0xC066)"},
{0x1044, 0xA511, 0xFFFF, 0xFFFF, "SmartRAID V Controller(0xA511)"},
{0x1044, 0xA511, 0x1044, 0xC032, "ASR-2005S I2O Zero Channel(0x1044-0xC032)"},
{0x1044, 0xA511, 0x1044, 0xC035, "ASR-2010S I2O Zero Channel(0x1044-0xC035)"},
{0x1044, 0xC066, 0xFFFF, 0xFFFF, "3010S Ultra3 Dual Channel(0xC066)"},
}; /* pci_vid_1044[] */

static pci_id_t const pci_vid_1045[] = {
{0x1045, 0xFFFF, 0xFFFF, 0xFFFF, "OPTi Inc.(0x1045)"},
{0x1045, 0xA0F8, 0xFFFF, 0xFFFF, "82C750 [Vendetta] USB Controller(0xA0F8)"},
{0x1045, 0xC101, 0xFFFF, 0xFFFF, "82C264 GUI Accelerator(0xC101)"},
{0x1045, 0xC178, 0xFFFF, 0xFFFF, "92C178(0xC178)"},
{0x1045, 0xC556, 0xFFFF, 0xFFFF, "82X556 [Viper](0xC556)"},
{0x1045, 0xC557, 0xFFFF, 0xFFFF, "82C557 [Viper-M](0xC557)"},
{0x1045, 0xC558, 0xFFFF, 0xFFFF, "82C558 [Viper-M ISA+IDE](0xC558)"},
{0x1045, 0xC567, 0xFFFF, 0xFFFF, "82C750 [Vendetta] Host Bridge(0xC567)"},
{0x1045, 0xC568, 0xFFFF, 0xFFFF, "82C750 [Vendetta] ISA Bridge(0xC568)"},
{0x1045, 0xC569, 0xFFFF, 0xFFFF, "82C579 [Viper XPress+ Chipset](0xC569)"},
{0x1045, 0xC621, 0xFFFF, 0xFFFF, "82C621A PCI IDE Contoller(0xC621)"},
{0x1045, 0xC700, 0xFFFF, 0xFFFF, "82C700 [FireStar](0xC700)"},
{0x1045, 0xC701, 0xFFFF, 0xFFFF, "82C700 [FireStar] Host Bridge(0xC701)"},
{0x1045, 0xC814, 0xFFFF, 0xFFFF, "82C814 [FireBridge II] Docking Stration Controller(0xC814)"},
{0x1045, 0xC822, 0xFFFF, 0xFFFF, "82C822(0xC822)"},
{0x1045, 0xC824, 0xFFFF, 0xFFFF, "82C824 [FireFox] 32-Bit PC Card Controller(0xC824)"},
{0x1045, 0xC825, 0xFFFF, 0xFFFF, "82C825 [FireBridge II] Docking Stration Controller(0xC825)"},
{0x1045, 0xC832, 0xFFFF, 0xFFFF, "82C832(0xC832)"},
{0x1045, 0xC861, 0xFFFF, 0xFFFF, "82C861/2/3 [FireLink] PCI-USB Host Bridge(0xC861)"},
{0x1045, 0xC881, 0xFFFF, 0xFFFF, "82C881 [FireLink] 1394 OHCI Link Controller(0xC881)"},
{0x1045, 0xC895, 0xFFFF, 0xFFFF, "82C895(0xC895)"},
{0x1045, 0xC935, 0xFFFF, 0xFFFF, "82С935 [MachOne] Integrated PCI Audio Processor(0xC935)"},
{0x1045, 0xD568, 0xFFFF, 0xFFFF, "82C700 [FireStar] PCI IDE Controller(0xD568)"},
{0x1045, 0xD721, 0xFFFF, 0xFFFF, "82C700 [FireStar] PCI IDE Controller(0xD721)"},
}; /* pci_vid_1045[] */

static pci_id_t const pci_vid_1046[] = {
{0x1046, 0xFFFF, 0xFFFF, 0xFFFF, "IPC Corporation, Ltd.(0x1046)"},
}; /* pci_vid_1046[] */

static pci_id_t const pci_vid_1047[] = {
{0x1047, 0xFFFF, 0xFFFF, 0xFFFF, "Genoa Systems Corp(0x1047)"},
}; /* pci_vid_1047[] */

static pci_id_t const pci_vid_1048[] = {
{0x1048, 0xFFFF, 0xFFFF, 0xFFFF, "Elsa AG(0x1048)"},
{0x1048, 0x0C60, 0xFFFF, 0xFFFF, "Gladiac MX(0x0C60)"},
{0x1048, 0x0D22, 0xFFFF, 0xFFFF, "Quadro4 900XGL [ELSA GLoria4 900XGL](0x0D22)"},
{0x1048, 0x1000, 0xFFFF, 0xFFFF, "QuickStep 1000(0x1000)"},
{0x1048, 0x3000, 0xFFFF, 0xFFFF, "QuickStep 3000(0x3000)"},
{0x1048, 0x8901, 0xFFFF, 0xFFFF, "Gloria XL(0x8901)"},
{0x1048, 0x8901, 0x1048, 0x0935, "GLoria XL (Virge)(0x1048-0x0935)"},
}; /* pci_vid_1048[] */

static pci_id_t const pci_vid_1049[] = {
{0x1049, 0xFFFF, 0xFFFF, 0xFFFF, "Fountain Technologies, Inc.(0x1049)"},
}; /* pci_vid_1049[] */

static pci_id_t const pci_vid_104A[] = {
{0x104A, 0xFFFF, 0xFFFF, 0xFFFF, "STMicroelectronics(0x104A)"},
{0x104A, 0x0000, 0xFFFF, 0xFFFF, "STLS2F Host Bridge(0x0000)"},
{0x104A, 0x0008, 0xFFFF, 0xFFFF, "STG 2000X(0x0008)"},
{0x104A, 0x0009, 0xFFFF, 0xFFFF, "STG 1764X(0x0009)"},
{0x104A, 0x0010, 0xFFFF, 0xFFFF, "STG4000 [3D Prophet Kyro Series](0x0010)"},
{0x104A, 0x0010, 0x104A, 0x4018, "ST PowerVR Kyro (64MB AGP TVO)(0x104A-0x4018)"},
{0x104A, 0x0010, 0x1681, 0x0010, "PowerVR Kyro II [3D Prophet 4500](0x1681-0x0010)"},
{0x104A, 0x0010, 0x1681, 0x0028, "3D Prophet 4000XT(0x1681-0x0028)"},
{0x104A, 0x0010, 0x1681, 0xC010, "3D Prophet 4500 TV-Out(0x1681-0xC010)"},
{0x104A, 0x0010, 0x1681, 0xC069, "3D Prophet 4000XT(0x1681-0xC069)"},
{0x104A, 0x0201, 0xFFFF, 0xFFFF, "STPC Vega Northbridge(0x0201)"},
{0x104A, 0x0209, 0xFFFF, 0xFFFF, "STPC Consumer/Industrial North- and Southbridge(0x0209)"},
{0x104A, 0x020A, 0xFFFF, 0xFFFF, "STPC Atlas/ConsumerS/Consumer IIA Northbridge(0x020A)"},
{0x104A, 0x020B, 0xFFFF, 0xFFFF, "STPC Consumer II ISA Bridge(0x020B)"},
{0x104A, 0x0210, 0xFFFF, 0xFFFF, "STPC Atlas ISA Bridge(0x0210)"},
{0x104A, 0x021A, 0xFFFF, 0xFFFF, "STPC Consumer S Southbridge(0x021A)"},
{0x104A, 0x021B, 0xFFFF, 0xFFFF, "STPC Consumer IIA Southbridge(0x021B)"},
{0x104A, 0x0220, 0xFFFF, 0xFFFF, "STPC Industrial PCI to PCCard bridge(0x0220)"},
{0x104A, 0x0228, 0xFFFF, 0xFFFF, "STPC Atlas IDE(0x0228)"},
{0x104A, 0x0229, 0xFFFF, 0xFFFF, "STPC Vega IDE(0x0229)"},
{0x104A, 0x0230, 0xFFFF, 0xFFFF, "STPC Atlas/Vega OHCI USB Controller(0x0230)"},
{0x104A, 0x0238, 0xFFFF, 0xFFFF, "STPC Vega LAN(0x0238)"},
{0x104A, 0x0500, 0xFFFF, 0xFFFF, "ST70137 [Unicorn] ADSL DMT Transceiver(0x0500)"},
{0x104A, 0x0500, 0x104A, 0x0500, "BeWAN ADSL PCI st(0x104A-0x0500)"},
{0x104A, 0x0564, 0xFFFF, 0xFFFF, "STPC Client Northbridge(0x0564)"},
{0x104A, 0x0981, 0xFFFF, 0xFFFF, "21x4x DEC-Tulip compatible 10/100 Ethernet(0x0981)"},
{0x104A, 0x1746, 0xFFFF, 0xFFFF, "STG 1764X(0x1746)"},
{0x104A, 0x2774, 0xFFFF, 0xFFFF, "21x4x DEC-Tulip compatible 10/100 Ethernet(0x2774)"},
{0x104A, 0x3520, 0xFFFF, 0xFFFF, "MPEG-II decoder card(0x3520)"},
{0x104A, 0x55CC, 0xFFFF, 0xFFFF, "STPC Client Southbridge(0x55CC)"},
}; /* pci_vid_104A[] */

static pci_id_t const pci_vid_104B[] = {
{0x104B, 0xFFFF, 0xFFFF, 0xFFFF, "BusLogic(0x104B)"},
{0x104B, 0x0140, 0xFFFF, 0xFFFF, "BT-946C (old) [multimaster  01](0x0140)"},
{0x104B, 0x1040, 0xFFFF, 0xFFFF, "BT-946C (BA80C30) [MultiMaster 10](0x1040)"},
{0x104B, 0x8130, 0xFFFF, 0xFFFF, "Flashpoint LT(0x8130)"},
}; /* pci_vid_104B[] */

static pci_id_t const pci_vid_104C[] = {
{0x104C, 0xFFFF, 0xFFFF, 0xFFFF, "Texas Instruments(0x104C)"},
{0x104C, 0x0500, 0xFFFF, 0xFFFF, "100 MBit LAN Controller(0x0500)"},
{0x104C, 0x0508, 0xFFFF, 0xFFFF, "TMS380C2X Compressor Interface(0x0508)"},
{0x104C, 0x1000, 0xFFFF, 0xFFFF, "Eagle i/f AS(0x1000)"},
{0x104C, 0x104C, 0xFFFF, 0xFFFF, "PCI1510 PC card Cardbus Controller(0x104C)"},
{0x104C, 0x3D04, 0xFFFF, 0xFFFF, "TVP4010 [Permedia](0x3D04)"},
{0x104C, 0x3D07, 0xFFFF, 0xFFFF, "TVP4020 [Permedia 2](0x3D07)"},
{0x104C, 0x3D07, 0x1011, 0x4D10, "Comet(0x1011-0x4D10)"},
{0x104C, 0x3D07, 0x1040, 0x000F, "AccelStar II(0x1040-0x000F)"},
{0x104C, 0x3D07, 0x1040, 0x0011, "AccelStar II(0x1040-0x0011)"},
{0x104C, 0x3D07, 0x1048, 0x0A31, "WINNER 2000(0x1048-0x0A31)"},
{0x104C, 0x3D07, 0x1048, 0x0A32, "GLoria Synergy(0x1048-0x0A32)"},
{0x104C, 0x3D07, 0x1048, 0x0A34, "GLoria Synergy(0x1048-0x0A34)"},
{0x104C, 0x3D07, 0x1048, 0x0A35, "GLoria Synergy(0x1048-0x0A35)"},
{0x104C, 0x3D07, 0x1048, 0x0A36, "GLoria Synergy(0x1048-0x0A36)"},
{0x104C, 0x3D07, 0x1048, 0x0A43, "GLoria Synergy(0x1048-0x0A43)"},
{0x104C, 0x3D07, 0x1048, 0x0A44, "GLoria Synergy(0x1048-0x0A44)"},
{0x104C, 0x3D07, 0x107D, 0x2633, "WinFast 3D L2300(0x107D-0x2633)"},
{0x104C, 0x3D07, 0x1092, 0x0126, "FIRE GL 1000 PRO(0x1092-0x0126)"},
{0x104C, 0x3D07, 0x1092, 0x0127, "FIRE GL 1000 PRO(0x1092-0x0127)"},
{0x104C, 0x3D07, 0x1092, 0x0136, "FIRE GL 1000 PRO(0x1092-0x0136)"},
{0x104C, 0x3D07, 0x1092, 0x0141, "FIRE GL 1000 PRO(0x1092-0x0141)"},
{0x104C, 0x3D07, 0x1092, 0x0146, "FIRE GL 1000 PRO(0x1092-0x0146)"},
{0x104C, 0x3D07, 0x1092, 0x0148, "FIRE GL 1000 PRO(0x1092-0x0148)"},
{0x104C, 0x3D07, 0x1092, 0x0149, "FIRE GL 1000 PRO(0x1092-0x0149)"},
{0x104C, 0x3D07, 0x1092, 0x0152, "FIRE GL 1000 PRO(0x1092-0x0152)"},
{0x104C, 0x3D07, 0x1092, 0x0154, "FIRE GL 1000 PRO(0x1092-0x0154)"},
{0x104C, 0x3D07, 0x1092, 0x0155, "FIRE GL 1000 PRO(0x1092-0x0155)"},
{0x104C, 0x3D07, 0x1092, 0x0156, "FIRE GL 1000 PRO(0x1092-0x0156)"},
{0x104C, 0x3D07, 0x1092, 0x0157, "FIRE GL 1000 PRO(0x1092-0x0157)"},
{0x104C, 0x3D07, 0x1097, 0x3D01, "Jeronimo Pro(0x1097-0x3D01)"},
{0x104C, 0x3D07, 0x1102, 0x100F, "Graphics Blaster Extreme(0x1102-0x100F)"},
{0x104C, 0x3D07, 0x3D3D, 0x0100, "Reference Permedia 2 3D(0x3D3D-0x0100)"},
{0x104C, 0x8000, 0xFFFF, 0xFFFF, "PCILynx/PCILynx2 IEEE 1394 Link Layer Controller(0x8000)"},
{0x104C, 0x8000, 0x105E, 0x8003, "FireBoard200(0x105E-0x8003)"},
{0x104C, 0x8000, 0x1443, 0x8003, "FireBoard200(0x1443-0x8003)"},
{0x104C, 0x8000, 0x1443, 0x8005, "FireBoard400(0x1443-0x8005)"},
{0x104C, 0x8000, 0x1443, 0x8006, "FireBoard400(0x1443-0x8006)"},
{0x104C, 0x8000, 0xE4BF, 0x1010, "CF1-1-SNARE(0xE4BF-0x1010)"},
{0x104C, 0x8000, 0xE4BF, 0x1020, "CF1-2-SNARE(0xE4BF-0x1020)"},
{0x104C, 0x8000, 0xE4BF, 0x1040, "FireCompact400(0xE4BF-0x1040)"},
{0x104C, 0x8009, 0xFFFF, 0xFFFF, "TSB12LV22 IEEE-1394 Controller(0x8009)"},
{0x104C, 0x8009, 0x104D, 0x8032, "8032 OHCI i.LINK (IEEE 1394) Controller(0x104D-0x8032)"},
{0x104C, 0x8009, 0x1443, 0x8010, "FireBoard400-OHCI(0x1443-0x8010)"},
{0x104C, 0x8017, 0xFFFF, 0xFFFF, "PCI4410 FireWire Controller(0x8017)"},
{0x104C, 0x8019, 0xFFFF, 0xFFFF, "TSB12LV23 IEEE-1394 Controller(0x8019)"},
{0x104C, 0x8019, 0x11BD, 0x000A, "Studio DV500-1394(0x11BD-0x000A)"},
{0x104C, 0x8019, 0x11BD, 0x000E, "Studio DV(0x11BD-0x000E)"},
{0x104C, 0x8019, 0x1443, 0x8010, "FireBoard400-OHCI(0x1443-0x8010)"},
{0x104C, 0x8019, 0xE4BF, 0x1010, "CF2-1-CYMBAL(0xE4BF-0x1010)"},
{0x104C, 0x8020, 0xFFFF, 0xFFFF, "TSB12LV26 IEEE-1394 Controller (Link)(0x8020)"},
{0x104C, 0x8020, 0x1028, 0x00D8, "Precision 530(0x1028-0x00D8)"},
{0x104C, 0x8020, 0x104D, 0x80E2, "VAIO PCV-J200(0x104D-0x80E2)"},
{0x104C, 0x8020, 0x11BD, 0x000F, "Studio DV500-1394(0x11BD-0x000F)"},
{0x104C, 0x8020, 0x11BD, 0x001C, "Excalibur 4.1(0x11BD-0x001C)"},
{0x104C, 0x8020, 0x1443, 0x8010, "FireBoard400-OHCI(0x1443-0x8010)"},
{0x104C, 0x8021, 0xFFFF, 0xFFFF, "TSB43AA22 IEEE-1394 Controller (PHY/Link Integrated)(0x8021)"},
{0x104C, 0x8021, 0x104D, 0x80DF, "Vaio PCG-FX403(0x104D-0x80DF)"},
{0x104C, 0x8021, 0x104D, 0x80E7, "VAIO PCG-GR214EP/GR214MP/GR215MP/GR314MP/GR315MP(0x104D-0x80E7)"},
{0x104C, 0x8022, 0xFFFF, 0xFFFF, "TSB43AB22 IEEE-1394a-2000 Controller (PHY/Link) [iOHCI-Lynx](0x8022)"},
{0x104C, 0x8022, 0x104C, 0x8023, "TSB43AB22/A IEEE-1394a-2000 Controller (PHY/Link)(0x104C-0x8023)"},
{0x104C, 0x8023, 0xFFFF, 0xFFFF, "TSB43AB22A IEEE-1394a-2000 Controller (PHY/Link) [iOHCI-Lynx](0x8023)"},
{0x104C, 0x8023, 0x1028, 0x0168, "Precision Workstation 670 Mainboard(0x1028-0x0168)"},
{0x104C, 0x8023, 0x103C, 0x088C, "NC8000 laptop(0x103C-0x088C)"},
{0x104C, 0x8023, 0x1043, 0x808B, "K8N4/A8N Series Mainboard(0x1043-0x808B)"},
{0x104C, 0x8023, 0x1043, 0x815B, "P5W DH Deluxe Motherboard(0x1043-0x815B)"},
{0x104C, 0x8023, 0x1443, 0x8023, "FireCard400(0x1443-0x8023)"},
{0x104C, 0x8023, 0x8086, 0x5044, "Desktop Board DP35DP(0x8086-0x5044)"},
{0x104C, 0x8024, 0xFFFF, 0xFFFF, "TSB43AB23 IEEE-1394a-2000 Controller (PHY/Link)(0x8024)"},
{0x104C, 0x8024, 0x107D, 0x6620, "Winfast DV2000 FireWire Controller(0x107D-0x6620)"},
{0x104C, 0x8024, 0x1443, 0x8024, "FireBoard Blue(0x1443-0x8024)"},
{0x104C, 0x8024, 0x1458, 0x1000, "Motherboard(0x1458-0x1000)"},
{0x104C, 0x8025, 0xFFFF, 0xFFFF, "TSB82AA2 IEEE-1394b Link Layer Controller(0x8025)"},
{0x104C, 0x8025, 0x1043, 0x813C, "P5P series mainboard(0x1043-0x813C)"},
{0x104C, 0x8025, 0x1443, 0x8025, "FireBoard800(0x1443-0x8025)"},
{0x104C, 0x8025, 0x1458, 0x1000, "GA-K8N Ultra-9 Mainboard(0x1458-0x1000)"},
{0x104C, 0x8025, 0x1546, 0x8025, "FWB-PCI01(0x1546-0x8025)"},
{0x104C, 0x8025, 0x17FC, 0x8025, "GIC3800(0x17FC-0x8025)"},
{0x104C, 0x8026, 0xFFFF, 0xFFFF, "TSB43AB21 IEEE-1394a-2000 Controller (PHY/Link)(0x8026)"},
{0x104C, 0x8026, 0x1025, 0x0035, "TravelMate 660(0x1025-0x0035)"},
{0x104C, 0x8026, 0x1025, 0x003C, "Aspire 2001WLCi (Compaq CL50 motherboard)(0x1025-0x003C)"},
{0x104C, 0x8026, 0x103C, 0x0025, "XE4500 Notebook(0x103C-0x0025)"},
{0x104C, 0x8026, 0x103C, 0x006A, "NX9500(0x103C-0x006A)"},
{0x104C, 0x8026, 0x1043, 0x808D, "A7V333 mainboard.(0x1043-0x808D)"},
{0x104C, 0x8027, 0xFFFF, 0xFFFF, "PCI4451 IEEE-1394 Controller(0x8027)"},
{0x104C, 0x8027, 0x1028, 0x00E5, "Latitude C810(0x1028-0x00E5)"},
{0x104C, 0x8027, 0x1028, 0x00E6, "PCI4451 IEEE-1394 Controller (Dell Inspiron 8100)(0x1028-0x00E6)"},
{0x104C, 0x8029, 0xFFFF, 0xFFFF, "PCI4510 IEEE-1394 Controller(0x8029)"},
{0x104C, 0x8029, 0x1028, 0x0163, "Latitude D505(0x1028-0x0163)"},
{0x104C, 0x8029, 0x1028, 0x0196, "Inspiron 5160(0x1028-0x0196)"},
{0x104C, 0x8029, 0x1071, 0x8160, "MIM2900(0x1071-0x8160)"},
{0x104C, 0x802B, 0xFFFF, 0xFFFF, "PCI7410,7510,7610 OHCI-Lynx Controller(0x802B)"},
{0x104C, 0x802B, 0x1028, 0x0139, "Latitude D400(0x1028-0x0139)"},
{0x104C, 0x802B, 0x1028, 0x014E, "PCI7410,7510,7610 OHCI-Lynx Controller (Latitude D800)(0x1028-0x014E)"},
{0x104C, 0x802E, 0xFFFF, 0xFFFF, "PCI7x20 1394a-2000 OHCI Two-Port PHY/Link-Layer Controller(0x802E)"},
{0x104C, 0x802E, 0x1028, 0x018D, "Inspiron 700m/710m(0x1028-0x018D)"},
{0x104C, 0x8031, 0xFFFF, 0xFFFF, "PCIxx21/PCIxx11/PCIx515 PC Card Controller(0x8031)"},
{0x104C, 0x8031, 0x1025, 0x0064, "Extensa 3000 series laptop(0x1025-0x0064)"},
{0x104C, 0x8031, 0x1025, 0x0080, "Aspire 5024WLMi(0x1025-0x0080)"},
{0x104C, 0x8031, 0x103C, 0x0934, "Compaq nw8240/nx8220(0x103C-0x0934)"},
{0x104C, 0x8031, 0x103C, 0x0944, "Compaq nc6220 Notebook PC(0x103C-0x0944)"},
{0x104C, 0x8031, 0x103C, 0x099C, "NX6110/NC6120(0x103C-0x099C)"},
{0x104C, 0x8031, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x104C, 0x8032, 0xFFFF, 0xFFFF, "OHCI Compliant IEEE 1394 Host Controller(0x8032)"},
{0x104C, 0x8032, 0x1025, 0x0064, "Extensa 3000 series laptop(0x1025-0x0064)"},
{0x104C, 0x8032, 0x1025, 0x0080, "Aspire 5024WLMi(0x1025-0x0080)"},
{0x104C, 0x8032, 0x103C, 0x0934, "Compaq nw8240/nx8220(0x103C-0x0934)"},
{0x104C, 0x8032, 0x103C, 0x099C, "NX6110/NC6120(0x103C-0x099C)"},
{0x104C, 0x8032, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x104C, 0x8033, 0xFFFF, 0xFFFF, "PCIxx21/PCIxx11 Flash Media Controller(0x8033)"},
{0x104C, 0x8033, 0x1025, 0x0064, "Extensa 3000 series laptop(0x1025-0x0064)"},
{0x104C, 0x8033, 0x1025, 0x0080, "Aspire 5024WLMi(0x1025-0x0080)"},
{0x104C, 0x8033, 0x103C, 0x0934, "Compaq nw8240/nx8220(0x103C-0x0934)"},
{0x104C, 0x8033, 0x103C, 0x0944, "Compaq nc6220 Notebook PC(0x103C-0x0944)"},
{0x104C, 0x8033, 0x103C, 0x099C, "NX6110/NC6120(0x103C-0x099C)"},
{0x104C, 0x8033, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x104C, 0x8034, 0xFFFF, 0xFFFF, "PCIxx21/PCIxx11 SD Host Controller(0x8034)"},
{0x104C, 0x8034, 0x1025, 0x0080, "Aspire 5024WLMi(0x1025-0x0080)"},
{0x104C, 0x8034, 0x103C, 0x0934, "Compaq nw8240/nx8220(0x103C-0x0934)"},
{0x104C, 0x8034, 0x103C, 0x0944, "Compaq nc6220 Notebook PC(0x103C-0x0944)"},
{0x104C, 0x8034, 0x103C, 0x099C, "NX6110/NC6120(0x103C-0x099C)"},
{0x104C, 0x8034, 0x103C, 0x308B, "MX6125(0x103C-0x308B)"},
{0x104C, 0x8035, 0xFFFF, 0xFFFF, "PCIxx21/PCIxx11 Smart Card Controller(0x8035)"},
{0x104C, 0x8035, 0x103C, 0x0934, "Compaq nw8240/nx8220(0x103C-0x0934)"},
{0x104C, 0x8035, 0x103C, 0x0944, "Compaq nc6220 Notebook PC(0x103C-0x0944)"},
{0x104C, 0x8035, 0x103C, 0x099C, "NX6110/NC6120(0x103C-0x099C)"},
{0x104C, 0x8036, 0xFFFF, 0xFFFF, "PCI6515 Cardbus Controller(0x8036)"},
{0x104C, 0x8038, 0xFFFF, 0xFFFF, "PCI6515 SmartCard Controller(0x8038)"},
{0x104C, 0x8039, 0xFFFF, 0xFFFF, "PCIxx12 Cardbus Controller(0x8039)"},
{0x104C, 0x8039, 0x103C, 0x309F, "Compaq nx9420 Notebook(0x103C-0x309F)"},
{0x104C, 0x8039, 0x103C, 0x30A1, "NC2400(0x103C-0x30A1)"},
{0x104C, 0x8039, 0x103C, 0x30A3, "Compaq nw8440(0x103C-0x30A3)"},
{0x104C, 0x8039, 0x104D, 0x902D, "VAIO VGN-NR120E(0x104D-0x902D)"},
{0x104C, 0x803A, 0xFFFF, 0xFFFF, "PCIxx12 OHCI Compliant IEEE 1394 Host Controller(0x803A)"},
{0x104C, 0x803A, 0x103C, 0x309F, "nx9420(0x103C-0x309F)"},
{0x104C, 0x803A, 0x103C, 0x30A1, "NC2400(0x103C-0x30A1)"},
{0x104C, 0x803A, 0x103C, 0x30A3, "Compaq nw8440(0x103C-0x30A3)"},
{0x104C, 0x803A, 0x104D, 0x902D, "VAIO VGN-NR120E(0x104D-0x902D)"},
{0x104C, 0x803B, 0xFFFF, 0xFFFF, "PCIxx12 Flash Media Controller(0x803B)"},
{0x104C, 0x803B, 0x103C, 0x309F, "nx9420(0x103C-0x309F)"},
{0x104C, 0x803B, 0x103C, 0x30A3, "Compaq nw8440(0x103C-0x30A3)"},
{0x104C, 0x803B, 0x104D, 0x8212, "VAIO VGN-N21E(0x104D-0x8212)"},
{0x104C, 0x803B, 0x104D, 0x902D, "VAIO VGN-NR120E(0x104D-0x902D)"},
{0x104C, 0x803C, 0xFFFF, 0xFFFF, "PCIxx12 SDA Standard Compliant SD Host Controller(0x803C)"},
{0x104C, 0x803C, 0x103C, 0x309F, "nx9420(0x103C-0x309F)"},
{0x104C, 0x803C, 0x103C, 0x30A3, "Compaq nw8440(0x103C-0x30A3)"},
{0x104C, 0x803D, 0xFFFF, 0xFFFF, "PCIxx12 GemCore based SmartCard controller(0x803D)"},
{0x104C, 0x803D, 0x103C, 0x309F, "Compaq nx9420 Notebook(0x103C-0x309F)"},
{0x104C, 0x803D, 0x103C, 0x30A1, "NC2400(0x103C-0x30A1)"},
{0x104C, 0x803D, 0x103C, 0x30A3, "nc8430(0x103C-0x30A3)"},
{0x104C, 0x803D, 0x103C, 0x30AA, "nc6310(0x103C-0x30AA)"},
{0x104C, 0x8101, 0xFFFF, 0xFFFF, "TSB43DB42 IEEE-1394a-2000 Controller (PHY/Link)(0x8101)"},
{0x104C, 0x8201, 0xFFFF, 0xFFFF, "PCI1620 Firmware Loading Function(0x8201)"},
{0x104C, 0x8204, 0xFFFF, 0xFFFF, "PCI7410/7510/7610 PCI Firmware Loading Function(0x8204)"},
{0x104C, 0x8204, 0x1028, 0x0139, "Latitude D400(0x1028-0x0139)"},
{0x104C, 0x8204, 0x1028, 0x014E, "Latitude D800(0x1028-0x014E)"},
{0x104C, 0x8231, 0xFFFF, 0xFFFF, "XIO2000(A)/XIO2200A PCI Express-to-PCI Bridge(0x8231)"},
{0x104C, 0x8231, 0x5678, 0x1234, "DC-1394 PCIe(0x5678-0x1234)"},
{0x104C, 0x8232, 0xFFFF, 0xFFFF, "XIO3130 PCI Express Switch (Upstream)(0x8232)"},
{0x104C, 0x8233, 0xFFFF, 0xFFFF, "XIO3130 PCI Express Switch (Downstream)(0x8233)"},
{0x104C, 0x8235, 0xFFFF, 0xFFFF, "XIO2200A IEEE-1394a-2000 Controller (PHY/Link)(0x8235)"},
{0x104C, 0x8235, 0x5678, 0x1234, "DC-1394 PCIe(0x5678-0x1234)"},
{0x104C, 0x823E, 0xFFFF, 0xFFFF, "XIO2213A/B/XIO2221 PCI Express to PCI Bridge [Cheetah Express](0x823E)"},
{0x104C, 0x823F, 0xFFFF, 0xFFFF, "XIO2213A/B/XIO2221 IEEE-1394b OHCI Controller [Cheetah Express](0x823F)"},
{0x104C, 0x823F, 0x1546, 0x803C, "FWB-PCIE1X11B(0x1546-0x803C)"},
{0x104C, 0x8240, 0xFFFF, 0xFFFF, "XIO2001 PCI Express-to-PCI Bridge(0x8240)"},
{0x104C, 0x8241, 0xFFFF, 0xFFFF, "TUSB73x0 SuperSpeed USB 3.0 xHCI Host Controller(0x8241)"},
{0x104C, 0x8241, 0x1014, 0x04B2, "S824 (8286-42A)(0x1014-0x04B2)"},
{0x104C, 0x8400, 0xFFFF, 0xFFFF, "ACX 100 22Mbps Wireless Interface(0x8400)"},
{0x104C, 0x8400, 0x1186, 0x3B00, "DWL-650+ PC Card cardbus 22Mbs Wireless Adapter [AirPlus](0x1186-0x3B00)"},
{0x104C, 0x8400, 0x1186, 0x3B01, "DWL-520+ 22Mbps PCI Wireless Adapter(0x1186-0x3B01)"},
{0x104C, 0x8400, 0x1395, 0x2201, "WL22-PC(0x1395-0x2201)"},
{0x104C, 0x8400, 0x16AB, 0x8501, "WL-8305 IEEE802.11b+ Wireless LAN PCI Adapter(0x16AB-0x8501)"},
{0x104C, 0x8401, 0xFFFF, 0xFFFF, "ACX 100 22Mbps Wireless Interface(0x8401)"},
{0x104C, 0x8888, 0xFFFF, 0xFFFF, "Multicore DSP+ARM KeyStone II SOC(0x8888)"},
{0x104C, 0x9000, 0xFFFF, 0xFFFF, "Wireless Interface (of unknown type)(0x9000)"},
{0x104C, 0x9065, 0xFFFF, 0xFFFF, "TMS320DM642(0x9065)"},
{0x104C, 0x9066, 0xFFFF, 0xFFFF, "ACX 111 54Mbps Wireless Interface(0x9066)"},
{0x104C, 0x9066, 0x0308, 0x3404, "G-102 v1 802.11g Wireless Cardbus Adapter(0x0308-0x3404)"},
{0x104C, 0x9066, 0x0308, 0x3406, "G-162 v2 802.11g Wireless Cardbus Adapter(0x0308-0x3406)"},
{0x104C, 0x9066, 0x104C, 0x9066, "WL212 Sitecom Wireless Network PCI-Card 100M (Version 1)(0x104C-0x9066)"},
{0x104C, 0x9066, 0x104C, 0x9067, "TNETW1130GVF(0x104C-0x9067)"},
{0x104C, 0x9066, 0x104C, 0x9096, "Trendnet TEW-412PC Wireless PCI Adapter (Version A)(0x104C-0x9096)"},
{0x104C, 0x9066, 0x1186, 0x3B04, "DWL-G520+ Wireless PCI Adapter(0x1186-0x3B04)"},
{0x104C, 0x9066, 0x1186, 0x3B05, "DWL-G650+ AirPlusG+ CardBus Wireless LAN(0x1186-0x3B05)"},
{0x104C, 0x9066, 0x1186, 0x3B08, "AirPlus G DWL-G630 Wireless Cardbus Adapter (rev.B1)(0x1186-0x3B08)"},
{0x104C, 0x9066, 0x1385, 0x4C00, "WG311v2 802.11g Wireless PCI Adapter(0x1385-0x4C00)"},
{0x104C, 0x9066, 0x13D1, 0xABA0, "SWLMP-54108 108Mbps Wireless mini PCI card 802.11g+(0x13D1-0xABA0)"},
{0x104C, 0x9066, 0x14EA, 0xAB07, "GW-NS54GM Wireless Cardbus Adapter(0x14EA-0xAB07)"},
{0x104C, 0x9066, 0x16EC, 0x010D, "USR5416 802.11g Wireless Turbo PCI Adapter(0x16EC-0x010D)"},
{0x104C, 0x9066, 0x16EC, 0x010E, "USR5410 802.11g Wireless Cardbus Adapter(0x16EC-0x010E)"},
{0x104C, 0x9066, 0x1737, 0x0033, "WPC54G v2 802.11g Wireless-G Notebook Adapter(0x1737-0x0033)"},
{0x104C, 0x9066, 0x17CF, 0x0032, "G-162 v1 802.11g Wireless Cardbus Adapter(0x17CF-0x0032)"},
{0x104C, 0x9066, 0x17CF, 0x0033, "Z-Com XG650 Wireless miniPCI 802.11b/g(0x17CF-0x0033)"},
{0x104C, 0x9066, 0x187E, 0x340B, "G-302 v2 802.11g Wireless PCI Adapter(0x187E-0x340B)"},
{0x104C, 0x9066, 0x187E, 0x340C, "G-360 v2 802.11g Wireless PCI Adapter(0x187E-0x340C)"},
{0x104C, 0xA001, 0xFFFF, 0xFFFF, "TDC1570(0xA001)"},
{0x104C, 0xA100, 0xFFFF, 0xFFFF, "TDC1561(0xA100)"},
{0x104C, 0xA102, 0xFFFF, 0xFFFF, "TNETA1575 HyperSAR Plus w/PCI Host i/f & UTOPIA i/f(0xA102)"},
{0x104C, 0xA106, 0xFFFF, 0xFFFF, "TMS320C6414 TMS320C6415 TMS320C6416(0xA106)"},
{0x104C, 0xA106, 0x175C, 0x5000, "ASI50xx Audio Adapter(0x175C-0x5000)"},
{0x104C, 0xA106, 0x175C, 0x6400, "ASI6400 Cobranet series(0x175C-0x6400)"},
{0x104C, 0xA106, 0x175C, 0x8700, "ASI87xx Radio Tuner card(0x175C-0x8700)"},
{0x104C, 0xAC10, 0xFFFF, 0xFFFF, "PCI1050(0xAC10)"},
{0x104C, 0xAC11, 0xFFFF, 0xFFFF, "PCI1053(0xAC11)"},
{0x104C, 0xAC12, 0xFFFF, 0xFFFF, "PCI1130(0xAC12)"},
{0x104C, 0xAC13, 0xFFFF, 0xFFFF, "PCI1031(0xAC13)"},
{0x104C, 0xAC15, 0xFFFF, 0xFFFF, "PCI1131(0xAC15)"},
{0x104C, 0xAC16, 0xFFFF, 0xFFFF, "PCI1250(0xAC16)"},
{0x104C, 0xAC16, 0x1014, 0x0092, "ThinkPad 600(0x1014-0x0092)"},
{0x104C, 0xAC17, 0xFFFF, 0xFFFF, "PCI1220(0xAC17)"},
{0x104C, 0xAC18, 0xFFFF, 0xFFFF, "PCI1260(0xAC18)"},
{0x104C, 0xAC19, 0xFFFF, 0xFFFF, "PCI1221(0xAC19)"},
{0x104C, 0xAC1A, 0xFFFF, 0xFFFF, "PCI1210(0xAC1A)"},
{0x104C, 0xAC1B, 0xFFFF, 0xFFFF, "PCI1450(0xAC1B)"},
{0x104C, 0xAC1B, 0x0E11, 0xB113, "Armada M700(0x0E11-0xB113)"},
{0x104C, 0xAC1B, 0x1014, 0x0130, "ThinkPad 600X/A21m/T20/T22(0x1014-0x0130)"},
{0x104C, 0xAC1C, 0xFFFF, 0xFFFF, "PCI1225(0xAC1C)"},
{0x104C, 0xAC1C, 0x0E11, 0xB121, "Armada E500(0x0E11-0xB121)"},
{0x104C, 0xAC1C, 0x1028, 0x0088, "Latitude CPi A400XT(0x1028-0x0088)"},
{0x104C, 0xAC1D, 0xFFFF, 0xFFFF, "PCI1251A(0xAC1D)"},
{0x104C, 0xAC1E, 0xFFFF, 0xFFFF, "PCI1211(0xAC1E)"},
{0x104C, 0xAC1F, 0xFFFF, 0xFFFF, "PCI1251B(0xAC1F)"},
{0x104C, 0xAC20, 0xFFFF, 0xFFFF, "TI 2030(0xAC20)"},
{0x104C, 0xAC21, 0xFFFF, 0xFFFF, "PCI2031(0xAC21)"},
{0x104C, 0xAC22, 0xFFFF, 0xFFFF, "PCI2032 PCI Docking Bridge(0xAC22)"},
{0x104C, 0xAC23, 0xFFFF, 0xFFFF, "PCI2250 PCI-to-PCI Bridge(0xAC23)"},
{0x104C, 0xAC28, 0xFFFF, 0xFFFF, "PCI2050 PCI-to-PCI Bridge(0xAC28)"},
{0x104C, 0xAC2C, 0xFFFF, 0xFFFF, "PCI2060 PCI-to-PCI Bridge(0xAC2C)"},
{0x104C, 0xAC30, 0xFFFF, 0xFFFF, "PCI1260 PC card Cardbus Controller(0xAC30)"},
{0x104C, 0xAC40, 0xFFFF, 0xFFFF, "PCI4450 PC card Cardbus Controller(0xAC40)"},
{0x104C, 0xAC41, 0xFFFF, 0xFFFF, "PCI4410 PC card Cardbus Controller(0xAC41)"},
{0x104C, 0xAC42, 0xFFFF, 0xFFFF, "PCI4451 PC card Cardbus Controller(0xAC42)"},
{0x104C, 0xAC42, 0x1028, 0x00E6, "PCI4451 PC card CardBus Controller (Inspiron 8100)(0x1028-0x00E6)"},
{0x104C, 0xAC44, 0xFFFF, 0xFFFF, "PCI4510 PC card Cardbus Controller(0xAC44)"},
{0x104C, 0xAC44, 0x1028, 0x0149, "Inspiron 5100(0x1028-0x0149)"},
{0x104C, 0xAC44, 0x1028, 0x0163, "Latitude D505(0x1028-0x0163)"},
{0x104C, 0xAC44, 0x1028, 0x0196, "Inspiron 5160(0x1028-0x0196)"},
{0x104C, 0xAC44, 0x1071, 0x8160, "MIM2000(0x1071-0x8160)"},
{0x104C, 0xAC46, 0xFFFF, 0xFFFF, "PCI4520 PC card Cardbus Controller(0xAC46)"},
{0x104C, 0xAC46, 0x1014, 0x0552, "ThinkPad(0x1014-0x0552)"},
{0x104C, 0xAC47, 0xFFFF, 0xFFFF, "PCI7510 PC card Cardbus Controller(0xAC47)"},
{0x104C, 0xAC47, 0x1028, 0x0139, "Latitude D400(0x1028-0x0139)"},
{0x104C, 0xAC47, 0x1028, 0x013F, "Precision M60(0x1028-0x013F)"},
{0x104C, 0xAC47, 0x1028, 0x014E, "Latitude D800(0x1028-0x014E)"},
{0x104C, 0xAC48, 0xFFFF, 0xFFFF, "PCI7610 PC Card Cardbus Controller(0xAC48)"},
{0x104C, 0xAC49, 0xFFFF, 0xFFFF, "PCI7410 PC Card Cardbus Controller(0xAC49)"},
{0x104C, 0xAC4A, 0xFFFF, 0xFFFF, "PCI7510/7610 CardBus Bridge(0xAC4A)"},
{0x104C, 0xAC4A, 0x1028, 0x0139, "Latitude D400(0x1028-0x0139)"},
{0x104C, 0xAC4A, 0x1028, 0x014E, "Latitude D800(0x1028-0x014E)"},
{0x104C, 0xAC4B, 0xFFFF, 0xFFFF, "PCI7610 SD/MMC controller(0xAC4B)"},
{0x104C, 0xAC4C, 0xFFFF, 0xFFFF, "PCI7610 Memory Stick controller(0xAC4C)"},
{0x104C, 0xAC50, 0xFFFF, 0xFFFF, "PCI1410 PC card Cardbus Controller(0xAC50)"},
{0x104C, 0xAC51, 0xFFFF, 0xFFFF, "PCI1420 PC card Cardbus Controller(0xAC51)"},
{0x104C, 0xAC51, 0x0E11, 0x004E, "Evo N600c(0x0E11-0x004E)"},
{0x104C, 0xAC51, 0x1014, 0x0148, "ThinkPad A20m(0x1014-0x0148)"},
{0x104C, 0xAC51, 0x1014, 0x023B, "ThinkPad T23(0x1014-0x023B)"},
{0x104C, 0xAC51, 0x1028, 0x00B1, "Latitude C600(0x1028-0x00B1)"},
{0x104C, 0xAC51, 0x1028, 0x012A, "Latitude C640(0x1028-0x012A)"},
{0x104C, 0xAC51, 0x1033, 0x80CD, "Versa Note VXi(0x1033-0x80CD)"},
{0x104C, 0xAC51, 0x10CF, 0x1095, "Lifebook S-4510/C6155(0x10CF-0x1095)"},
{0x104C, 0xAC51, 0xE4BF, 0x1000, "CP2-2-HIPHOP(0xE4BF-0x1000)"},
{0x104C, 0xAC52, 0xFFFF, 0xFFFF, "PCI1451 PC card Cardbus Controller(0xAC52)"},
{0x104C, 0xAC53, 0xFFFF, 0xFFFF, "PCI1421 PC card Cardbus Controller(0xAC53)"},
{0x104C, 0xAC54, 0xFFFF, 0xFFFF, "PCI1620 PC Card Controller(0xAC54)"},
{0x104C, 0xAC54, 0x103C, 0x08B0, "tc1100 tablet(0x103C-0x08B0)"},
{0x104C, 0xAC55, 0xFFFF, 0xFFFF, "PCI1520 PC card Cardbus Controller(0xAC55)"},
{0x104C, 0xAC55, 0x1014, 0x0512, "ThinkPad T30/T40(0x1014-0x0512)"},
{0x104C, 0xAC55, 0x103C, 0x0025, "XE4500 Notebook(0x103C-0x0025)"},
{0x104C, 0xAC56, 0xFFFF, 0xFFFF, "PCI1510 PC card Cardbus Controller(0xAC56)"},
{0x104C, 0xAC56, 0x1014, 0x0512, "ThinkPad R50e(0x1014-0x0512)"},
{0x104C, 0xAC56, 0x1014, 0x0528, "ThinkPad R40e(0x1014-0x0528)"},
{0x104C, 0xAC56, 0x17AA, 0x2012, "ThinkPad T60/R60 series(0x17AA-0x2012)"},
{0x104C, 0xAC60, 0xFFFF, 0xFFFF, "PCI2040 PCI to DSP Bridge Controller(0xAC60)"},
{0x104C, 0xAC60, 0x175C, 0x5100, "ASI51xx Audio Adapter(0x175C-0x5100)"},
{0x104C, 0xAC60, 0x175C, 0x6100, "ASI61xx Audio Adapter(0x175C-0x6100)"},
{0x104C, 0xAC60, 0x175C, 0x6200, "ASI62xx Audio Adapter(0x175C-0x6200)"},
{0x104C, 0xAC60, 0x175C, 0x8800, "ASI88xx Audio Adapter(0x175C-0x8800)"},
{0x104C, 0xAC60, 0x186F, 0x3001, "WR-G303 PCI radio receiver(0x186F-0x3001)"},
{0x104C, 0xAC60, 0x186F, 0x3005, "WR-G305 PCI radio receiver(0x186F-0x3005)"},
{0x104C, 0xAC60, 0x186F, 0x3101, "WR-G313 PCI radio receiver(0x186F-0x3101)"},
{0x104C, 0xAC60, 0x186F, 0x3105, "WR-G315 PCI radio receiver(0x186F-0x3105)"},
{0x104C, 0xAC8D, 0xFFFF, 0xFFFF, "PCI 7620(0xAC8D)"},
{0x104C, 0xAC8E, 0xFFFF, 0xFFFF, "PCI7420 CardBus Controller(0xAC8E)"},
{0x104C, 0xAC8E, 0x1028, 0x018D, "Inspiron 700m/710m(0x1028-0x018D)"},
{0x104C, 0xAC8F, 0xFFFF, 0xFFFF, "PCI7420/7620 SD/MS-Pro Controller(0xAC8F)"},
{0x104C, 0xAC8F, 0x1028, 0x018D, "Inspiron 700m/710m(0x1028-0x018D)"},
{0x104C, 0xB001, 0xFFFF, 0xFFFF, "TMS320C6424(0xB001)"},
{0x104C, 0xFE00, 0xFFFF, 0xFFFF, "FireWire Host Controller(0xFE00)"},
{0x104C, 0xFE03, 0xFFFF, 0xFFFF, "12C01A FireWire Host Controller(0xFE03)"},
}; /* pci_vid_104C[] */

static pci_id_t const pci_vid_104D[] = {
{0x104D, 0xFFFF, 0xFFFF, 0xFFFF, "Sony Corporation(0x104D)"},
{0x104D, 0x8004, 0xFFFF, 0xFFFF, "DTL-H2500 [Playstation development board](0x8004)"},
{0x104D, 0x8009, 0xFFFF, 0xFFFF, "CXD1947Q i.LINK Controller(0x8009)"},
{0x104D, 0x800C, 0xFFFF, 0xFFFF, "DTL-H800 [PS1 sound development board](0x800C)"},
{0x104D, 0x800D, 0xFFFF, 0xFFFF, "DVBK-2000(E) DV Still Image Capture Board(0x800D)"},
{0x104D, 0x8039, 0xFFFF, 0xFFFF, "CXD3222 i.LINK Controller(0x8039)"},
{0x104D, 0x8047, 0xFFFF, 0xFFFF, "PS2 TOOL MRP(0x8047)"},
{0x104D, 0x8056, 0xFFFF, 0xFFFF, "Rockwell HCF 56K modem(0x8056)"},
{0x104D, 0x808A, 0xFFFF, 0xFFFF, "Memory Stick Controller(0x808A)"},
{0x104D, 0x80FF, 0xFFFF, 0xFFFF, "PS2 Performance Analyzer(0x80FF)"},
{0x104D, 0x814A, 0xFFFF, 0xFFFF, "PS2 Performance Analyzer(0x814A)"},
{0x104D, 0x8183, 0xFFFF, 0xFFFF, "ATHENS [PS3 prototype developer interface card](0x8183)"},
{0x104D, 0x81B0, 0xFFFF, 0xFFFF, "BM-1 [PSP TOOL Board Management Device](0x81B0)"},
{0x104D, 0x81C3, 0xFFFF, 0xFFFF, "VO-4 [PSP TOOL Video Output Device](0x81C3)"},
{0x104D, 0x81CE, 0xFFFF, 0xFFFF, "SxS Pro memory card(0x81CE)"},
{0x104D, 0x81FF, 0xFFFF, 0xFFFF, "PS3 TOOL MRP(0x81FF)"},
{0x104D, 0x8200, 0xFFFF, 0xFFFF, "PS3 TOOL RSX Tracing FPGA(0x8200)"},
{0x104D, 0x820E, 0xFFFF, 0xFFFF, "CXD9208GP [PS3 PS2 emulation subsystem adapter](0x820E)"},
{0x104D, 0x905C, 0xFFFF, 0xFFFF, "SxS Pro memory card(0x905C)"},
{0x104D, 0x907F, 0xFFFF, 0xFFFF, "SxS Pro+ memory card(0x907F)"},
{0x104D, 0x908F, 0xFFFF, 0xFFFF, "Aeolia ACPI(0x908F)"},
{0x104D, 0x909E, 0xFFFF, 0xFFFF, "Aeolia Ethernet Controller (Marvell Yukon 2 Family)(0x909E)"},
{0x104D, 0x909F, 0xFFFF, 0xFFFF, "Aeolia SATA AHCI Controller(0x909F)"},
{0x104D, 0x90A0, 0xFFFF, 0xFFFF, "Aeolia SD/MMC Host Controller(0x90A0)"},
{0x104D, 0x90A1, 0xFFFF, 0xFFFF, "Aeolia PCI Express Glue and Miscellaneous Devices(0x90A1)"},
{0x104D, 0x90A2, 0xFFFF, 0xFFFF, "Aeolia DMA Controller(0x90A2)"},
{0x104D, 0x90A3, 0xFFFF, 0xFFFF, "Aeolia Memory (DDR3/SPM)(0x90A3)"},
{0x104D, 0x90A4, 0xFFFF, 0xFFFF, "Aeolia USB 3.0 xHCI Host Controller(0x90A4)"},
{0x104D, 0x90BC, 0xFFFF, 0xFFFF, "SxS Pro+ memory card(0x90BC)"},
{0x104D, 0x90C0, 0xFFFF, 0xFFFF, "PCIe x8 XAVC Codec Board(0x90C0)"},
{0x104D, 0x90C8, 0xFFFF, 0xFFFF, "Belize ACPI(0x90C8)"},
{0x104D, 0x90C9, 0xFFFF, 0xFFFF, "Belize Ethernet Controller(0x90C9)"},
{0x104D, 0x90CA, 0xFFFF, 0xFFFF, "Belize SATA AHCI Controller(0x90CA)"},
{0x104D, 0x90CB, 0xFFFF, 0xFFFF, "Belize SD/MMC Host Controller(0x90CB)"},
{0x104D, 0x90CC, 0xFFFF, 0xFFFF, "Belize PCI Express Glue and Miscellaneous Devices(0x90CC)"},
{0x104D, 0x90CD, 0xFFFF, 0xFFFF, "Belize DMA Controller(0x90CD)"},
{0x104D, 0x90CE, 0xFFFF, 0xFFFF, "Belize Memory (DDR3/SPM)(0x90CE)"},
{0x104D, 0x90CF, 0xFFFF, 0xFFFF, "Belize USB 3.0 xHCI Host Controller(0x90CF)"},
{0x104D, 0x90D7, 0xFFFF, 0xFFFF, "Baikal ACPI(0x90D7)"},
{0x104D, 0x90D8, 0xFFFF, 0xFFFF, "Baikal Ethernet Controller(0x90D8)"},
{0x104D, 0x90D9, 0xFFFF, 0xFFFF, "Baikal SATA AHCI Controller(0x90D9)"},
{0x104D, 0x90DA, 0xFFFF, 0xFFFF, "Baikal SD/MMC Host Controller(0x90DA)"},
{0x104D, 0x90DB, 0xFFFF, 0xFFFF, "Baikal PCI Express Glue and Miscellaneous Devices(0x90DB)"},
{0x104D, 0x90DC, 0xFFFF, 0xFFFF, "Baikal DMA Controller(0x90DC)"},
{0x104D, 0x90DD, 0xFFFF, 0xFFFF, "Baikal Memory (DDR3/SPM)(0x90DD)"},
{0x104D, 0x90DE, 0xFFFF, 0xFFFF, "Baikal USB 3.0 xHCI Host Controller(0x90DE)"},
{0x104D, 0x90EB, 0xFFFF, 0xFFFF, "CXD90062GG(0x90EB)"},
{0x104D, 0x9121, 0xFFFF, 0xFFFF, "Nextorage NEM-PA NVMe SSD for PlayStation(0x9121)"},
}; /* pci_vid_104D[] */

static pci_id_t const pci_vid_104E[] = {
{0x104E, 0xFFFF, 0xFFFF, 0xFFFF, "Oak Technology, Inc(0x104E)"},
{0x104E, 0x0017, 0xFFFF, 0xFFFF, "OTI-64017(0x0017)"},
{0x104E, 0x0107, 0xFFFF, 0xFFFF, "OTI-107 [Spitfire](0x0107)"},
{0x104E, 0x0109, 0xFFFF, 0xFFFF, "Video Adapter(0x0109)"},
{0x104E, 0x0111, 0xFFFF, 0xFFFF, "OTI-64111 [Spitfire](0x0111)"},
{0x104E, 0x0217, 0xFFFF, 0xFFFF, "OTI-64217(0x0217)"},
{0x104E, 0x0317, 0xFFFF, 0xFFFF, "OTI-64317(0x0317)"},
}; /* pci_vid_104E[] */

static pci_id_t const pci_vid_104F[] = {
{0x104F, 0xFFFF, 0xFFFF, 0xFFFF, "Co-time Computer Ltd(0x104F)"},
}; /* pci_vid_104F[] */

static pci_id_t const pci_vid_1050[] = {
{0x1050, 0xFFFF, 0xFFFF, 0xFFFF, "Winbond Electronics Corp(0x1050)"},
{0x1050, 0x0000, 0xFFFF, 0xFFFF, "NE2000(0x0000)"},
{0x1050, 0x0001, 0xFFFF, 0xFFFF, "W83769F(0x0001)"},
{0x1050, 0x0033, 0xFFFF, 0xFFFF, "W89C33D 802.11 a/b/g BB/MAC(0x0033)"},
{0x1050, 0x0105, 0xFFFF, 0xFFFF, "W82C105(0x0105)"},
{0x1050, 0x0628, 0xFFFF, 0xFFFF, "W83628F/W83629D PCI to ISA Bridge Set(0x0628)"},
{0x1050, 0x0840, 0xFFFF, 0xFFFF, "W89C840(0x0840)"},
{0x1050, 0x0840, 0x1050, 0x0001, "W89C840 Ethernet Adapter(0x1050-0x0001)"},
{0x1050, 0x0840, 0x1050, 0x0840, "W89C840 Ethernet Adapter(0x1050-0x0840)"},
{0x1050, 0x0940, 0xFFFF, 0xFFFF, "W89C940(0x0940)"},
{0x1050, 0x5A5A, 0xFFFF, 0xFFFF, "W89C940 Twisted-pair Ether-LAN Controller With PCI Interface [ELANC-PCI](0x5A5A)"},
{0x1050, 0x6692, 0xFFFF, 0xFFFF, "W6692 PCI ISDN S/T-Controller(0x6692)"},
{0x1050, 0x6692, 0x1043, 0x1702, "ISDN Adapter (PCI Bus, D, W)(0x1043-0x1702)"},
{0x1050, 0x6692, 0x1043, 0x1703, "ISDN Adapter (PCI Bus, DV, W)(0x1043-0x1703)"},
{0x1050, 0x6692, 0x1043, 0x1707, "ISDN Adapter (PCI Bus, DV, W)(0x1043-0x1707)"},
{0x1050, 0x6692, 0x144F, 0x1702, "ISDN Adapter (PCI Bus, D, W)(0x144F-0x1702)"},
{0x1050, 0x6692, 0x144F, 0x1703, "ISDN Adapter (PCI Bus, DV, W)(0x144F-0x1703)"},
{0x1050, 0x6692, 0x144F, 0x1707, "ISDN Adapter (PCI Bus, DV, W)(0x144F-0x1707)"},
{0x1050, 0x9921, 0xFFFF, 0xFFFF, "W99200F MPEG-1 Video Encoder(0x9921)"},
{0x1050, 0x9922, 0xFFFF, 0xFFFF, "W99200F/W9922PF MPEG-1/2 Video Encoder(0x9922)"},
{0x1050, 0x9960, 0xFFFF, 0xFFFF, "W9960CF Video Codec(0x9960)"},
{0x1050, 0x9970, 0xFFFF, 0xFFFF, "W9970CF(0x9970)"},
}; /* pci_vid_1050[] */

static pci_id_t const pci_vid_1051[] = {
{0x1051, 0xFFFF, 0xFFFF, 0xFFFF, "Anigma, Inc.(0x1051)"},
}; /* pci_vid_1051[] */

static pci_id_t const pci_vid_1052[] = {
{0x1052, 0xFFFF, 0xFFFF, 0xFFFF, "?-Young Micro Systems(0x1052)"},
}; /* pci_vid_1052[] */

static pci_id_t const pci_vid_1053[] = {
{0x1053, 0xFFFF, 0xFFFF, 0xFFFF, "Young Micro Systems(0x1053)"},
}; /* pci_vid_1053[] */

static pci_id_t const pci_vid_1054[] = {
{0x1054, 0xFFFF, 0xFFFF, 0xFFFF, "Hitachi, Ltd(0x1054)"},
{0x1054, 0x3009, 0xFFFF, 0xFFFF, "2Gbps Fibre Channel to PCI HBA 3009(0x3009)"},
{0x1054, 0x300A, 0xFFFF, 0xFFFF, "4Gbps Fibre Channel to PCI-X HBA 300a(0x300A)"},
{0x1054, 0x300B, 0xFFFF, 0xFFFF, "4Gbps Fibre Channel to PCI-X HBA 300b(0x300B)"},
{0x1054, 0x300F, 0xFFFF, 0xFFFF, "ColdFusion 3 Chipset Processor to I/O Controller(0x300F)"},
{0x1054, 0x3010, 0xFFFF, 0xFFFF, "ColdFusion 3 Chipset Memory Controller Hub(0x3010)"},
{0x1054, 0x3011, 0xFFFF, 0xFFFF, "ColdFusion 3e Chipset Processor to I/O Controller(0x3011)"},
{0x1054, 0x3012, 0xFFFF, 0xFFFF, "ColdFusion 3e Chipset Memory Controller Hub(0x3012)"},
{0x1054, 0x3017, 0xFFFF, 0xFFFF, "Unassigned Hitachi Shared FC Device 3017(0x3017)"},
{0x1054, 0x301B, 0xFFFF, 0xFFFF, "Virtual VGA Device(0x301B)"},
{0x1054, 0x301D, 0xFFFF, 0xFFFF, "PCIe-to-PCIe Bridge with Virtualization IO Assist Feature(0x301D)"},
{0x1054, 0x3020, 0xFFFF, 0xFFFF, "FIVE-EX based Fibre Channel to PCIe HBA(0x3020)"},
{0x1054, 0x302C, 0xFFFF, 0xFFFF, "M001 PCI Express Switch Upstream Port(0x302C)"},
{0x1054, 0x302D, 0xFFFF, 0xFFFF, "M001 PCI Express Switch Downstream Port(0x302D)"},
{0x1054, 0x3070, 0xFFFF, 0xFFFF, "Hitachi FIVE-FX Fibre Channel to PCIe HBA(0x3070)"},
{0x1054, 0x3505, 0xFFFF, 0xFFFF, "SH7751 PCI Controller (PCIC)(0x3505)"},
{0x1054, 0x350E, 0xFFFF, 0xFFFF, "SH7751R PCI Controller (PCIC)(0x350E)"},
}; /* pci_vid_1054[] */

static pci_id_t const pci_vid_1055[] = {
{0x1055, 0xFFFF, 0xFFFF, 0xFFFF, "Microchip Technology / SMSC(0x1055)"},
{0x1055, 0x7430, 0xFFFF, 0xFFFF, "LAN7430(0x7430)"},
{0x1055, 0x7431, 0xFFFF, 0xFFFF, "LAN7431(0x7431)"},
{0x1055, 0x7431, 0x1059, 0x01A0, "RD10055 M.2 Dual 1GbE-T1 40m(0x1059-0x01A0)"},
{0x1055, 0x9130, 0xFFFF, 0xFFFF, "SLC90E66 [Victory66] IDE(0x9130)"},
{0x1055, 0x9460, 0xFFFF, 0xFFFF, "SLC90E66 [Victory66] ISA(0x9460)"},
{0x1055, 0x9462, 0xFFFF, 0xFFFF, "SLC90E66 [Victory66] USB(0x9462)"},
{0x1055, 0x9463, 0xFFFF, 0xFFFF, "SLC90E66 [Victory66] ACPI(0x9463)"},
{0x1055, 0xE420, 0xFFFF, 0xFFFF, "LAN9420/LAN9420i(0xE420)"},
}; /* pci_vid_1055[] */

static pci_id_t const pci_vid_1056[] = {
{0x1056, 0xFFFF, 0xFFFF, 0xFFFF, "ICL(0x1056)"},
}; /* pci_vid_1056[] */

static pci_id_t const pci_vid_1057[] = {
{0x1057, 0xFFFF, 0xFFFF, 0xFFFF, "Motorola(0x1057)"},
{0x1057, 0x0001, 0xFFFF, 0xFFFF, "MPC105 [Eagle](0x0001)"},
{0x1057, 0x0002, 0xFFFF, 0xFFFF, "MPC106 [Grackle](0x0002)"},
{0x1057, 0x0003, 0xFFFF, 0xFFFF, "MPC8240 [Kahlua](0x0003)"},
{0x1057, 0x0004, 0xFFFF, 0xFFFF, "MPC107(0x0004)"},
{0x1057, 0x0006, 0xFFFF, 0xFFFF, "MPC8245 [Unity](0x0006)"},
{0x1057, 0x0008, 0xFFFF, 0xFFFF, "MPC8540(0x0008)"},
{0x1057, 0x0009, 0xFFFF, 0xFFFF, "MPC8560(0x0009)"},
{0x1057, 0x0012, 0xFFFF, 0xFFFF, "MPC8548 [PowerQUICC III](0x0012)"},
{0x1057, 0x0100, 0xFFFF, 0xFFFF, "MC145575 [HFC-PCI](0x0100)"},
{0x1057, 0x0431, 0xFFFF, 0xFFFF, "KTI829c 100VG(0x0431)"},
{0x1057, 0x1073, 0xFFFF, 0xFFFF, "Nokia N770(0x1073)"},
{0x1057, 0x1219, 0xFFFF, 0xFFFF, "Nokia N800(0x1219)"},
{0x1057, 0x1801, 0xFFFF, 0xFFFF, "DSP56301 Digital Signal Processor(0x1801)"},
{0x1057, 0x1801, 0x14FB, 0x0101, "Transas Radar Imitator Board [RIM](0x14FB-0x0101)"},
{0x1057, 0x1801, 0x14FB, 0x0102, "Transas Radar Imitator Board [RIM-2](0x14FB-0x0102)"},
{0x1057, 0x1801, 0x14FB, 0x0202, "Transas Radar Integrator Board [RIB-2](0x14FB-0x0202)"},
{0x1057, 0x1801, 0x14FB, 0x0611, "1 channel CAN bus Controller [CanPci-1](0x14FB-0x0611)"},
{0x1057, 0x1801, 0x14FB, 0x0612, "2 channels CAN bus Controller [CanPci-2](0x14FB-0x0612)"},
{0x1057, 0x1801, 0x14FB, 0x0613, "3 channels CAN bus Controller [CanPci-3](0x14FB-0x0613)"},
{0x1057, 0x1801, 0x14FB, 0x0614, "4 channels CAN bus Controller [CanPci-4](0x14FB-0x0614)"},
{0x1057, 0x1801, 0x14FB, 0x0621, "1 channel CAN bus Controller [CanPci2-1](0x14FB-0x0621)"},
{0x1057, 0x1801, 0x14FB, 0x0622, "2 channels CAN bus Controller [CanPci2-2](0x14FB-0x0622)"},
{0x1057, 0x1801, 0x14FB, 0x0810, "Transas VTS Radar Integrator Board [RIB-4](0x14FB-0x0810)"},
{0x1057, 0x1801, 0x175C, 0x4200, "ASI4215 Audio Adapter(0x175C-0x4200)"},
{0x1057, 0x1801, 0x175C, 0x4300, "ASI43xx Audio Adapter(0x175C-0x4300)"},
{0x1057, 0x1801, 0x175C, 0x4400, "ASI4401 Audio Adapter(0x175C-0x4400)"},
{0x1057, 0x1801, 0xECC0, 0x0010, "Darla(0xECC0-0x0010)"},
{0x1057, 0x1801, 0xECC0, 0x0020, "Gina(0xECC0-0x0020)"},
{0x1057, 0x1801, 0xECC0, 0x0030, "Layla rev.0(0xECC0-0x0030)"},
{0x1057, 0x1801, 0xECC0, 0x0031, "Layla rev.1(0xECC0-0x0031)"},
{0x1057, 0x1801, 0xECC0, 0x0040, "Darla24 rev.0(0xECC0-0x0040)"},
{0x1057, 0x1801, 0xECC0, 0x0041, "Darla24 rev.1(0xECC0-0x0041)"},
{0x1057, 0x1801, 0xECC0, 0x0050, "Gina24 rev.0(0xECC0-0x0050)"},
{0x1057, 0x1801, 0xECC0, 0x0051, "Gina24 rev.1(0xECC0-0x0051)"},
{0x1057, 0x1801, 0xECC0, 0x0070, "Mona rev.0(0xECC0-0x0070)"},
{0x1057, 0x1801, 0xECC0, 0x0071, "Mona rev.1(0xECC0-0x0071)"},
{0x1057, 0x1801, 0xECC0, 0x0072, "Mona rev.2(0xECC0-0x0072)"},
{0x1057, 0x18C0, 0xFFFF, 0xFFFF, "MPC8265A/8266/8272(0x18C0)"},
{0x1057, 0x18C1, 0xFFFF, 0xFFFF, "MPC8271/MPC8272(0x18C1)"},
{0x1057, 0x3052, 0xFFFF, 0xFFFF, "SM56 Data Fax Modem(0x3052)"},
{0x1057, 0x3410, 0xFFFF, 0xFFFF, "DSP56361 Digital Signal Processor(0x3410)"},
{0x1057, 0x3410, 0xECC0, 0x0050, "Gina24 rev.0(0xECC0-0x0050)"},
{0x1057, 0x3410, 0xECC0, 0x0051, "Gina24 rev.1(0xECC0-0x0051)"},
{0x1057, 0x3410, 0xECC0, 0x0060, "Layla24(0xECC0-0x0060)"},
{0x1057, 0x3410, 0xECC0, 0x0070, "Mona rev.0(0xECC0-0x0070)"},
{0x1057, 0x3410, 0xECC0, 0x0071, "Mona rev.1(0xECC0-0x0071)"},
{0x1057, 0x3410, 0xECC0, 0x0072, "Mona rev.2(0xECC0-0x0072)"},
{0x1057, 0x3410, 0xECC0, 0x0080, "Mia rev.0(0xECC0-0x0080)"},
{0x1057, 0x3410, 0xECC0, 0x0081, "Mia rev.1(0xECC0-0x0081)"},
{0x1057, 0x3410, 0xECC0, 0x0090, "Indigo(0xECC0-0x0090)"},
{0x1057, 0x3410, 0xECC0, 0x00A0, "Indigo IO(0xECC0-0x00A0)"},
{0x1057, 0x3410, 0xECC0, 0x00B0, "Indigo DJ(0xECC0-0x00B0)"},
{0x1057, 0x3410, 0xECC0, 0x0100, "3G(0xECC0-0x0100)"},
{0x1057, 0x4801, 0xFFFF, 0xFFFF, "Raven(0x4801)"},
{0x1057, 0x4802, 0xFFFF, 0xFFFF, "Falcon(0x4802)"},
{0x1057, 0x4803, 0xFFFF, 0xFFFF, "Hawk(0x4803)"},
{0x1057, 0x4806, 0xFFFF, 0xFFFF, "CPX8216(0x4806)"},
{0x1057, 0x480B, 0xFFFF, 0xFFFF, "MPC7410(0x480B)"},
{0x1057, 0x4D68, 0xFFFF, 0xFFFF, "20268(0x4D68)"},
{0x1057, 0x5600, 0xFFFF, 0xFFFF, "SM56 PCI Modem(0x5600)"},
{0x1057, 0x5600, 0x1057, 0x0300, "SM56 PCI Speakerphone Modem(0x1057-0x0300)"},
{0x1057, 0x5600, 0x1057, 0x0301, "SM56 PCI Voice Modem(0x1057-0x0301)"},
{0x1057, 0x5600, 0x1057, 0x0302, "SM56 PCI Fax Modem(0x1057-0x0302)"},
{0x1057, 0x5600, 0x1057, 0x5600, "SM56 PCI Voice modem(0x1057-0x5600)"},
{0x1057, 0x5600, 0x13D2, 0x0300, "SM56 PCI Speakerphone Modem(0x13D2-0x0300)"},
{0x1057, 0x5600, 0x13D2, 0x0301, "SM56 PCI Voice modem(0x13D2-0x0301)"},
{0x1057, 0x5600, 0x13D2, 0x0302, "SM56 PCI Fax Modem(0x13D2-0x0302)"},
{0x1057, 0x5600, 0x1436, 0x0300, "SM56 PCI Speakerphone Modem(0x1436-0x0300)"},
{0x1057, 0x5600, 0x1436, 0x0301, "SM56 PCI Voice modem(0x1436-0x0301)"},
{0x1057, 0x5600, 0x1436, 0x0302, "SM56 PCI Fax Modem(0x1436-0x0302)"},
{0x1057, 0x5600, 0x144F, 0x100C, "SM56 PCI Fax Modem(0x144F-0x100C)"},
{0x1057, 0x5600, 0x1494, 0x0300, "SM56 PCI Speakerphone Modem(0x1494-0x0300)"},
{0x1057, 0x5600, 0x1494, 0x0301, "SM56 PCI Voice modem(0x1494-0x0301)"},
{0x1057, 0x5600, 0x14C8, 0x0300, "SM56 PCI Speakerphone Modem(0x14C8-0x0300)"},
{0x1057, 0x5600, 0x14C8, 0x0302, "SM56 PCI Fax Modem(0x14C8-0x0302)"},
{0x1057, 0x5600, 0x1668, 0x0300, "SM56 PCI Speakerphone Modem(0x1668-0x0300)"},
{0x1057, 0x5600, 0x1668, 0x0302, "SM56 PCI Fax Modem(0x1668-0x0302)"},
{0x1057, 0x5608, 0xFFFF, 0xFFFF, "Wildcard X100P(0x5608)"},
{0x1057, 0x5803, 0xFFFF, 0xFFFF, "MPC5200(0x5803)"},
{0x1057, 0x5806, 0xFFFF, 0xFFFF, "MCF54 Coldfire(0x5806)"},
{0x1057, 0x5808, 0xFFFF, 0xFFFF, "MPC8220(0x5808)"},
{0x1057, 0x5809, 0xFFFF, 0xFFFF, "MPC5200B(0x5809)"},
{0x1057, 0x6400, 0xFFFF, 0xFFFF, "MPC190 Security Processor (S1 family, encryption)(0x6400)"},
{0x1057, 0x6405, 0xFFFF, 0xFFFF, "MPC184 Security Processor (S1 family)(0x6405)"},
}; /* pci_vid_1057[] */

static pci_id_t const pci_vid_1058[] = {
{0x1058, 0xFFFF, 0xFFFF, 0xFFFF, "Electronics & Telecommunications RSH(0x1058)"},
}; /* pci_vid_1058[] */

static pci_id_t const pci_vid_1059[] = {
{0x1059, 0xFFFF, 0xFFFF, 0xFFFF, "Kontron(0x1059)"},
{0x1059, 0x0004, 0xFFFF, 0xFFFF, "FPGA M.2 (K20058)(0x0004)"},
{0x1059, 0x0004, 0x1059, 0x0000, "FPGA M.2 (K20058)(0x1059-0x0000)"},
}; /* pci_vid_1059[] */

static pci_id_t const pci_vid_105A[] = {
{0x105A, 0xFFFF, 0xFFFF, 0xFFFF, "Promise Technology, Inc.(0x105A)"},
{0x105A, 0x0D30, 0xFFFF, 0xFFFF, "PDC20265 (FastTrak100 Lite/Ultra100)(0x0D30)"},
{0x105A, 0x0D30, 0x1043, 0x8042, "AV7266-E South Bridge Promise RAID(0x1043-0x8042)"},
{0x105A, 0x0D30, 0x105A, 0x4D33, "Ultra100(0x105A-0x4D33)"},
{0x105A, 0x0D38, 0xFFFF, 0xFFFF, "20263(0x0D38)"},
{0x105A, 0x0D38, 0x105A, 0x4D39, "Fasttrak66(0x105A-0x4D39)"},
{0x105A, 0x1275, 0xFFFF, 0xFFFF, "20275(0x1275)"},
{0x105A, 0x3318, 0xFFFF, 0xFFFF, "PDC20318 (SATA150 TX4)(0x3318)"},
{0x105A, 0x3319, 0xFFFF, 0xFFFF, "PDC20319 (FastTrak S150 TX4)(0x3319)"},
{0x105A, 0x3319, 0x105A, 0x3319, "FastTrak S150 TX4 4 port SATA PCI board(0x105A-0x3319)"},
{0x105A, 0x3319, 0x8086, 0x3427, "S875WP1-E mainboard(0x8086-0x3427)"},
{0x105A, 0x3371, 0xFFFF, 0xFFFF, "PDC20371 (FastTrak S150 TX2plus)(0x3371)"},
{0x105A, 0x3373, 0xFFFF, 0xFFFF, "PDC20378 (FastTrak 378/SATA 378)(0x3373)"},
{0x105A, 0x3373, 0x1043, 0x80F5, "K8V Deluxe/PC-DL Deluxe motherboard(0x1043-0x80F5)"},
{0x105A, 0x3373, 0x1462, 0x590D, "KT6 Delta-FIS2R (MS-6590)(0x1462-0x590D)"},
{0x105A, 0x3373, 0x1462, 0x702E, "K8T NEO FIS2R motherboard(0x1462-0x702E)"},
{0x105A, 0x3375, 0xFFFF, 0xFFFF, "PDC20375 (SATA150 TX2plus)(0x3375)"},
{0x105A, 0x3376, 0xFFFF, 0xFFFF, "PDC20376 (FastTrak 376)(0x3376)"},
{0x105A, 0x3376, 0x1043, 0x809E, "A7V8X motherboard(0x1043-0x809E)"},
{0x105A, 0x3515, 0xFFFF, 0xFFFF, "PDC40719 [FastTrak TX4300/TX4310](0x3515)"},
{0x105A, 0x3519, 0xFFFF, 0xFFFF, "PDC40519 (FastTrak TX4200)(0x3519)"},
{0x105A, 0x3570, 0xFFFF, 0xFFFF, "PDC20771 [FastTrak TX2300](0x3570)"},
{0x105A, 0x3571, 0xFFFF, 0xFFFF, "PDC20571 (FastTrak TX2200)(0x3571)"},
{0x105A, 0x3574, 0xFFFF, 0xFFFF, "PDC20579 SATAII 150 IDE Controller(0x3574)"},
{0x105A, 0x3577, 0xFFFF, 0xFFFF, "PDC40779 (SATA 300 779)(0x3577)"},
{0x105A, 0x3D17, 0xFFFF, 0xFFFF, "PDC40718 (SATA 300 TX4)(0x3D17)"},
{0x105A, 0x3D18, 0xFFFF, 0xFFFF, "PDC20518/PDC40518 (SATAII 150 TX4)(0x3D18)"},
{0x105A, 0x3D73, 0xFFFF, 0xFFFF, "PDC40775 (SATA 300 TX2plus)(0x3D73)"},
{0x105A, 0x3D75, 0xFFFF, 0xFFFF, "PDC20575 (SATAII150 TX2plus)(0x3D75)"},
{0x105A, 0x3F20, 0xFFFF, 0xFFFF, "PDC42819 [FastTrak TX2650/TX4650](0x3F20)"},
{0x105A, 0x4302, 0xFFFF, 0xFFFF, "80333 [SuperTrak EX4350](0x4302)"},
{0x105A, 0x4D30, 0xFFFF, 0xFFFF, "PDC20267 (FastTrak100/Ultra100)(0x4D30)"},
{0x105A, 0x4D30, 0x105A, 0x4D33, "Ultra100(0x105A-0x4D33)"},
{0x105A, 0x4D30, 0x105A, 0x4D39, "FastTrak100(0x105A-0x4D39)"},
{0x105A, 0x4D30, 0x8086, 0x5744, "S845WD1-E mainboard(0x8086-0x5744)"},
{0x105A, 0x4D33, 0xFFFF, 0xFFFF, "20246(0x4D33)"},
{0x105A, 0x4D33, 0x105A, 0x4D33, "20246 IDE Controller(0x105A-0x4D33)"},
{0x105A, 0x4D38, 0xFFFF, 0xFFFF, "PDC20262 (FastTrak66/Ultra66)(0x4D38)"},
{0x105A, 0x4D38, 0x105A, 0x4D30, "Ultra Device on SuperTrak(0x105A-0x4D30)"},
{0x105A, 0x4D38, 0x105A, 0x4D33, "Ultra66(0x105A-0x4D33)"},
{0x105A, 0x4D38, 0x105A, 0x4D39, "FastTrak66(0x105A-0x4D39)"},
{0x105A, 0x4D68, 0xFFFF, 0xFFFF, "PDC20268 [Ultra100 TX2](0x4D68)"},
{0x105A, 0x4D68, 0x105A, 0x4D68, "Ultra100 TX2(0x105A-0x4D68)"},
{0x105A, 0x4D69, 0xFFFF, 0xFFFF, "20269(0x4D69)"},
{0x105A, 0x4D69, 0x105A, 0x4D68, "Ultra133TX2(0x105A-0x4D68)"},
{0x105A, 0x5275, 0xFFFF, 0xFFFF, "PDC20276 (MBFastTrak133 Lite)(0x5275)"},
{0x105A, 0x5275, 0x1043, 0x807E, "A7V333 motherboard.(0x1043-0x807E)"},
{0x105A, 0x5275, 0x105A, 0x0275, "SuperTrak SX6000 IDE(0x105A-0x0275)"},
{0x105A, 0x5275, 0x105A, 0x1275, "MBFastTrak133 Lite (tm) Controller (RAID mode)(0x105A-0x1275)"},
{0x105A, 0x5275, 0x1458, 0xB001, "MBUltra 133(0x1458-0xB001)"},
{0x105A, 0x5300, 0xFFFF, 0xFFFF, "DC5300(0x5300)"},
{0x105A, 0x6268, 0xFFFF, 0xFFFF, "PDC20270 (FastTrak100 LP/TX2/TX4)(0x6268)"},
{0x105A, 0x6268, 0x105A, 0x4D68, "FastTrak100 TX2(0x105A-0x4D68)"},
{0x105A, 0x6269, 0xFFFF, 0xFFFF, "PDC20271 (FastTrak TX2000)(0x6269)"},
{0x105A, 0x6269, 0x105A, 0x6269, "FastTrak TX2/TX2000(0x105A-0x6269)"},
{0x105A, 0x6300, 0xFFFF, 0xFFFF, "PDC81731 [FastTrak SX8300](0x6300)"},
{0x105A, 0x6621, 0xFFFF, 0xFFFF, "PDC20621 (FastTrak S150 SX4/FastTrak SX4000 lite)(0x6621)"},
{0x105A, 0x6622, 0xFFFF, 0xFFFF, "PDC20621 [SATA150 SX4] 4 Channel IDE RAID Controller(0x6622)"},
{0x105A, 0x6624, 0xFFFF, 0xFFFF, "PDC20621 [FastTrak SX4100](0x6624)"},
{0x105A, 0x6626, 0xFFFF, 0xFFFF, "PDC20618 (Ultra 618)(0x6626)"},
{0x105A, 0x6629, 0xFFFF, 0xFFFF, "PDC20619 (FastTrak TX4000)(0x6629)"},
{0x105A, 0x7275, 0xFFFF, 0xFFFF, "PDC20277 (SBFastTrak133 Lite)(0x7275)"},
{0x105A, 0x8002, 0xFFFF, 0xFFFF, "SATAII150 SX8(0x8002)"},
{0x105A, 0x8350, 0xFFFF, 0xFFFF, "80333 [SuperTrak EX8350/EX16350], 80331 [SuperTrak EX8300/EX16300](0x8350)"},
{0x105A, 0x8650, 0xFFFF, 0xFFFF, "81384 [SuperTrak EX SAS and SATA RAID Controller](0x8650)"},
{0x105A, 0x8650, 0x105A, 0x4600, "SuperTrak EX4650A(0x105A-0x4600)"},
{0x105A, 0x8650, 0x105A, 0x4601, "SuperTrak EX4650(0x105A-0x4601)"},
{0x105A, 0x8650, 0x105A, 0x4610, "SuperTrak EX4650EL(0x105A-0x4610)"},
{0x105A, 0x8650, 0x105A, 0x8600, "SuperTrak EX8650EL(0x105A-0x8600)"},
{0x105A, 0x8650, 0x105A, 0x8601, "SuperTrak EX8650A(0x105A-0x8601)"},
{0x105A, 0x8650, 0x105A, 0x8602, "SuperTrak EX8654(0x105A-0x8602)"},
{0x105A, 0x8650, 0x105A, 0x8603, "SuperTrak EX8658(0x105A-0x8603)"},
{0x105A, 0x8650, 0x105A, 0x8604, "SuperTrak EX8650(0x105A-0x8604)"},
{0x105A, 0x8650, 0x105A, 0x8610, "SuperTrak EX8650M(0x105A-0x8610)"},
{0x105A, 0x8650, 0x105A, 0xA600, "SuperTrak EX12650(0x105A-0xA600)"},
{0x105A, 0x8650, 0x105A, 0xB600, "SuperTrak EX16650(0x105A-0xB600)"},
{0x105A, 0x8650, 0x105A, 0xB601, "SuperTrak EX16654(0x105A-0xB601)"},
{0x105A, 0x8650, 0x105A, 0xB602, "SuperTrak EX16658(0x105A-0xB602)"},
{0x105A, 0x8760, 0xFFFF, 0xFFFF, "PM8010 [SuperTrak EX SAS and SATA 6G RAID Controller](0x8760)"},
{0x105A, 0xC350, 0xFFFF, 0xFFFF, "80333 [SuperTrak EX12350](0xC350)"},
{0x105A, 0xE350, 0xFFFF, 0xFFFF, "80333 [SuperTrak EX24350](0xE350)"},
}; /* pci_vid_105A[] */

static pci_id_t const pci_vid_105B[] = {
{0x105B, 0xFFFF, 0xFFFF, 0xFFFF, "Foxconn International, Inc.(0x105B)"},
{0x105B, 0x9602, 0xFFFF, 0xFFFF, "RS780/RS880 PCI to PCI bridge (int gfx)(0x9602)"},
{0x105B, 0xE0C3, 0xFFFF, 0xFFFF, "T99W175 5G Modem [Snapdragon X55](0xE0C3)"},
}; /* pci_vid_105B[] */

static pci_id_t const pci_vid_105C[] = {
{0x105C, 0xFFFF, 0xFFFF, 0xFFFF, "Wipro Infotech Limited(0x105C)"},
}; /* pci_vid_105C[] */

static pci_id_t const pci_vid_105D[] = {
{0x105D, 0xFFFF, 0xFFFF, 0xFFFF, "Number 9 Computer Company(0x105D)"},
{0x105D, 0x2309, 0xFFFF, 0xFFFF, "Imagine 128(0x2309)"},
{0x105D, 0x2339, 0xFFFF, 0xFFFF, "Imagine 128-II(0x2339)"},
{0x105D, 0x2339, 0x105D, 0x0000, "Imagine 128 series 2 4Mb VRAM(0x105D-0x0000)"},
{0x105D, 0x2339, 0x105D, 0x0001, "Imagine 128 series 2 4Mb VRAM(0x105D-0x0001)"},
{0x105D, 0x2339, 0x105D, 0x0002, "Imagine 128 series 2 4Mb VRAM(0x105D-0x0002)"},
{0x105D, 0x2339, 0x105D, 0x0003, "Imagine 128 series 2 4Mb VRAM(0x105D-0x0003)"},
{0x105D, 0x2339, 0x105D, 0x0004, "Imagine 128 series 2 4Mb VRAM(0x105D-0x0004)"},
{0x105D, 0x2339, 0x105D, 0x0005, "Imagine 128 series 2 4Mb VRAM(0x105D-0x0005)"},
{0x105D, 0x2339, 0x105D, 0x0006, "Imagine 128 series 2 4Mb VRAM(0x105D-0x0006)"},
{0x105D, 0x2339, 0x105D, 0x0007, "Imagine 128 series 2 4Mb VRAM(0x105D-0x0007)"},
{0x105D, 0x2339, 0x105D, 0x0008, "Imagine 128 series 2e 4Mb DRAM(0x105D-0x0008)"},
{0x105D, 0x2339, 0x105D, 0x0009, "Imagine 128 series 2e 4Mb DRAM(0x105D-0x0009)"},
{0x105D, 0x2339, 0x105D, 0x000A, "Imagine 128 series 2 8Mb VRAM(0x105D-0x000A)"},
{0x105D, 0x2339, 0x105D, 0x000B, "Imagine 128 series 2 8Mb H-VRAM(0x105D-0x000B)"},
{0x105D, 0x2339, 0x11A4, 0x000A, "Metheus 5 Megapixel(0x11A4-0x000A)"},
{0x105D, 0x2339, 0x13CC, 0x0000, "Metheus 5 Megapixel(0x13CC-0x0000)"},
{0x105D, 0x2339, 0x13CC, 0x0004, "Metheus 5 Megapixel(0x13CC-0x0004)"},
{0x105D, 0x2339, 0x13CC, 0x0005, "Metheus 5 Megapixel(0x13CC-0x0005)"},
{0x105D, 0x2339, 0x13CC, 0x0006, "Metheus 5 Megapixel(0x13CC-0x0006)"},
{0x105D, 0x2339, 0x13CC, 0x0008, "Metheus 5 Megapixel(0x13CC-0x0008)"},
{0x105D, 0x2339, 0x13CC, 0x0009, "Metheus 5 Megapixel(0x13CC-0x0009)"},
{0x105D, 0x2339, 0x13CC, 0x000A, "Metheus 5 Megapixel(0x13CC-0x000A)"},
{0x105D, 0x2339, 0x13CC, 0x000C, "Metheus 5 Megapixel(0x13CC-0x000C)"},
{0x105D, 0x493D, 0xFFFF, 0xFFFF, "Imagine 128 T2R [Ticket to Ride](0x493D)"},
{0x105D, 0x493D, 0x11A4, 0x000A, "Metheus 5 Megapixel, Dual Head(0x11A4-0x000A)"},
{0x105D, 0x493D, 0x11A4, 0x000B, "Metheus 5 Megapixel, Dual Head(0x11A4-0x000B)"},
{0x105D, 0x493D, 0x13CC, 0x0002, "Metheus 4 Megapixel, Dual Head(0x13CC-0x0002)"},
{0x105D, 0x493D, 0x13CC, 0x0003, "Metheus 5 Megapixel, Dual Head(0x13CC-0x0003)"},
{0x105D, 0x493D, 0x13CC, 0x0007, "Metheus 5 Megapixel, Dual Head(0x13CC-0x0007)"},
{0x105D, 0x493D, 0x13CC, 0x0008, "Metheus 5 Megapixel, Dual Head(0x13CC-0x0008)"},
{0x105D, 0x493D, 0x13CC, 0x0009, "Metheus 5 Megapixel, Dual Head(0x13CC-0x0009)"},
{0x105D, 0x493D, 0x13CC, 0x000A, "Metheus 5 Megapixel, Dual Head(0x13CC-0x000A)"},
{0x105D, 0x5348, 0xFFFF, 0xFFFF, "Revolution 4(0x5348)"},
{0x105D, 0x5348, 0x105D, 0x0037, "Revolution IV-FP AGP (For SGI 1600SW)(0x105D-0x0037)"},
{0x105D, 0x5348, 0x11A4, 0x0028, "PVS5600M(0x11A4-0x0028)"},
{0x105D, 0x5348, 0x11A4, 0x0038, "PVS5600D(0x11A4-0x0038)"},
}; /* pci_vid_105D[] */

static pci_id_t const pci_vid_105E[] = {
{0x105E, 0xFFFF, 0xFFFF, 0xFFFF, "Vtech Computers Ltd(0x105E)"},
}; /* pci_vid_105E[] */

static pci_id_t const pci_vid_105F[] = {
{0x105F, 0xFFFF, 0xFFFF, 0xFFFF, "Infotronic America Inc(0x105F)"},
}; /* pci_vid_105F[] */

static pci_id_t const pci_vid_1060[] = {
{0x1060, 0xFFFF, 0xFFFF, 0xFFFF, "United Microelectronics [UMC](0x1060)"},
{0x1060, 0x0001, 0xFFFF, 0xFFFF, "UM82C881(0x0001)"},
{0x1060, 0x0002, 0xFFFF, 0xFFFF, "UM82C886(0x0002)"},
{0x1060, 0x0101, 0xFFFF, 0xFFFF, "UM8673F(0x0101)"},
{0x1060, 0x0881, 0xFFFF, 0xFFFF, "UM8881(0x0881)"},
{0x1060, 0x0886, 0xFFFF, 0xFFFF, "UM8886F(0x0886)"},
{0x1060, 0x0891, 0xFFFF, 0xFFFF, "UM8891A(0x0891)"},
{0x1060, 0x1001, 0xFFFF, 0xFFFF, "UM886A(0x1001)"},
{0x1060, 0x673A, 0xFFFF, 0xFFFF, "UM8886BF(0x673A)"},
{0x1060, 0x673B, 0xFFFF, 0xFFFF, "EIDE Master/DMA(0x673B)"},
{0x1060, 0x8710, 0xFFFF, 0xFFFF, "UM8710(0x8710)"},
{0x1060, 0x886A, 0xFFFF, 0xFFFF, "UM8886A(0x886A)"},
{0x1060, 0x8881, 0xFFFF, 0xFFFF, "UM8881F(0x8881)"},
{0x1060, 0x8886, 0xFFFF, 0xFFFF, "UM8886F(0x8886)"},
{0x1060, 0x888A, 0xFFFF, 0xFFFF, "UM8886A(0x888A)"},
{0x1060, 0x8891, 0xFFFF, 0xFFFF, "UM8891A(0x8891)"},
{0x1060, 0x9017, 0xFFFF, 0xFFFF, "UM9017F(0x9017)"},
{0x1060, 0x9018, 0xFFFF, 0xFFFF, "UM9018(0x9018)"},
{0x1060, 0x9026, 0xFFFF, 0xFFFF, "UM9026(0x9026)"},
{0x1060, 0xE881, 0xFFFF, 0xFFFF, "UM8881N(0xE881)"},
{0x1060, 0xE886, 0xFFFF, 0xFFFF, "UM8886N(0xE886)"},
{0x1060, 0xE88A, 0xFFFF, 0xFFFF, "UM8886N(0xE88A)"},
{0x1060, 0xE891, 0xFFFF, 0xFFFF, "UM8891N(0xE891)"},
}; /* pci_vid_1060[] */

static pci_id_t const pci_vid_1061[] = {
{0x1061, 0xFFFF, 0xFFFF, 0xFFFF, "I.I.T.(0x1061)"},
{0x1061, 0x0001, 0xFFFF, 0xFFFF, "AGX016(0x0001)"},
{0x1061, 0x0002, 0xFFFF, 0xFFFF, "IIT3204/3501(0x0002)"},
}; /* pci_vid_1061[] */

static pci_id_t const pci_vid_1062[] = {
{0x1062, 0xFFFF, 0xFFFF, 0xFFFF, "Maspar Computer Corp(0x1062)"},
}; /* pci_vid_1062[] */

static pci_id_t const pci_vid_1063[] = {
{0x1063, 0xFFFF, 0xFFFF, 0xFFFF, "Ocean Office Automation(0x1063)"},
}; /* pci_vid_1063[] */

static pci_id_t const pci_vid_1064[] = {
{0x1064, 0xFFFF, 0xFFFF, 0xFFFF, "Alcatel(0x1064)"},
{0x1064, 0x1102, 0xFFFF, 0xFFFF, "Dynamite 2840 (ADSL PCI modem)(0x1102)"},
}; /* pci_vid_1064[] */

static pci_id_t const pci_vid_1065[] = {
{0x1065, 0xFFFF, 0xFFFF, 0xFFFF, "Texas Microsystems(0x1065)"},
}; /* pci_vid_1065[] */

static pci_id_t const pci_vid_1066[] = {
{0x1066, 0xFFFF, 0xFFFF, 0xFFFF, "PicoPower Technology(0x1066)"},
{0x1066, 0x0000, 0xFFFF, 0xFFFF, "PT80C826(0x0000)"},
{0x1066, 0x0001, 0xFFFF, 0xFFFF, "PT86C521 [Vesuvius v1] Host Bridge(0x0001)"},
{0x1066, 0x0002, 0xFFFF, 0xFFFF, "PT86C523 [Vesuvius v3] PCI-ISA Bridge Master(0x0002)"},
{0x1066, 0x0003, 0xFFFF, 0xFFFF, "PT86C524 [Nile] PCI-to-PCI Bridge(0x0003)"},
{0x1066, 0x0004, 0xFFFF, 0xFFFF, "PT86C525 [Nile-II] PCI-to-PCI Bridge(0x0004)"},
{0x1066, 0x0005, 0xFFFF, 0xFFFF, "National PC87550 System Controller(0x0005)"},
{0x1066, 0x8002, 0xFFFF, 0xFFFF, "PT86C523 [Vesuvius v3] PCI-ISA Bridge Slave(0x8002)"},
}; /* pci_vid_1066[] */

static pci_id_t const pci_vid_1067[] = {
{0x1067, 0xFFFF, 0xFFFF, 0xFFFF, "Mitsubishi Electric(0x1067)"},
{0x1067, 0x0301, 0xFFFF, 0xFFFF, "AccelGraphics AccelECLIPSE(0x0301)"},
{0x1067, 0x0304, 0xFFFF, 0xFFFF, "AccelGALAXY A2100 [OEM Evans & Sutherland](0x0304)"},
{0x1067, 0x0308, 0xFFFF, 0xFFFF, "Tornado 3000 [OEM Evans & Sutherland](0x0308)"},
{0x1067, 0x1002, 0xFFFF, 0xFFFF, "VG500 [VolumePro Volume Rendering Accelerator](0x1002)"},
}; /* pci_vid_1067[] */

static pci_id_t const pci_vid_1068[] = {
{0x1068, 0xFFFF, 0xFFFF, 0xFFFF, "Diversified Technology(0x1068)"},
}; /* pci_vid_1068[] */

static pci_id_t const pci_vid_1069[] = {
{0x1069, 0xFFFF, 0xFFFF, 0xFFFF, "Mylex Corporation(0x1069)"},
{0x1069, 0x0001, 0xFFFF, 0xFFFF, "DAC960P(0x0001)"},
{0x1069, 0x0002, 0xFFFF, 0xFFFF, "DAC960PD(0x0002)"},
{0x1069, 0x0010, 0xFFFF, 0xFFFF, "DAC960PG(0x0010)"},
{0x1069, 0x0020, 0xFFFF, 0xFFFF, "DAC960LA(0x0020)"},
{0x1069, 0x0050, 0xFFFF, 0xFFFF, "AcceleRAID 352/170/160 support Device(0x0050)"},
{0x1069, 0x0050, 0x1069, 0x0050, "AcceleRAID 352 support Device(0x1069-0x0050)"},
{0x1069, 0x0050, 0x1069, 0x0052, "AcceleRAID 170 support Device(0x1069-0x0052)"},
{0x1069, 0x0050, 0x1069, 0x0054, "AcceleRAID 160 support Device(0x1069-0x0054)"},
{0x1069, 0xB166, 0xFFFF, 0xFFFF, "AcceleRAID 600/500/400/Sapphire support Device(0xB166)"},
{0x1069, 0xB166, 0x1014, 0x0242, "iSeries 2872 DASD IOA(0x1014-0x0242)"},
{0x1069, 0xB166, 0x1014, 0x0266, "Dual Channel PCI-X U320 SCSI Adapter(0x1014-0x0266)"},
{0x1069, 0xB166, 0x1014, 0x0278, "Dual Channel PCI-X U320 SCSI RAID Adapter(0x1014-0x0278)"},
{0x1069, 0xB166, 0x1014, 0x02D3, "Dual Channel PCI-X U320 SCSI Adapter(0x1014-0x02D3)"},
{0x1069, 0xB166, 0x1014, 0x02D4, "Dual Channel PCI-X U320 SCSI RAID Adapter(0x1014-0x02D4)"},
{0x1069, 0xB166, 0x1069, 0x0200, "AcceleRAID 400, Single Channel, PCI-X, U320, SCSI RAID(0x1069-0x0200)"},
{0x1069, 0xB166, 0x1069, 0x0202, "AcceleRAID Sapphire, Dual Channel, PCI-X, U320, SCSI RAID(0x1069-0x0202)"},
{0x1069, 0xB166, 0x1069, 0x0204, "AcceleRAID 500, Dual Channel, Low-Profile, PCI-X, U320, SCSI RAID(0x1069-0x0204)"},
{0x1069, 0xB166, 0x1069, 0x0206, "AcceleRAID 600, Dual Channel, PCI-X, U320, SCSI RAID(0x1069-0x0206)"},
{0x1069, 0xBA55, 0xFFFF, 0xFFFF, "eXtremeRAID 1100 support Device(0xBA55)"},
{0x1069, 0xBA56, 0xFFFF, 0xFFFF, "eXtremeRAID 2000/3000 support Device(0xBA56)"},
{0x1069, 0xBA56, 0x1069, 0x0030, "eXtremeRAID 3000 support Device(0x1069-0x0030)"},
{0x1069, 0xBA56, 0x1069, 0x0040, "eXtremeRAID 2000 support Device(0x1069-0x0040)"},
{0x1069, 0xBA57, 0xFFFF, 0xFFFF, "eXtremeRAID 4000/5000 support Device(0xBA57)"},
{0x1069, 0xBA57, 0x1069, 0x0072, "eXtremeRAID 5000 support Device(0x1069-0x0072)"},
}; /* pci_vid_1069[] */

static pci_id_t const pci_vid_106A[] = {
{0x106A, 0xFFFF, 0xFFFF, 0xFFFF, "Aten Research Inc(0x106A)"},
}; /* pci_vid_106A[] */

static pci_id_t const pci_vid_106B[] = {
{0x106B, 0xFFFF, 0xFFFF, 0xFFFF, "Apple Inc.(0x106B)"},
{0x106B, 0x0001, 0xFFFF, 0xFFFF, "Bandit PowerPC host bridge(0x0001)"},
{0x106B, 0x0002, 0xFFFF, 0xFFFF, "Grand Central I/O(0x0002)"},
{0x106B, 0x0003, 0xFFFF, 0xFFFF, "Control Video(0x0003)"},
{0x106B, 0x0004, 0xFFFF, 0xFFFF, "PlanB Video-In(0x0004)"},
{0x106B, 0x0007, 0xFFFF, 0xFFFF, "O'Hare I/O(0x0007)"},
{0x106B, 0x000B, 0xFFFF, 0xFFFF, "Apple Camera(0x000B)"},
{0x106B, 0x000C, 0xFFFF, 0xFFFF, "DOS on Mac(0x000C)"},
{0x106B, 0x000E, 0xFFFF, 0xFFFF, "Hydra Mac I/O(0x000E)"},
{0x106B, 0x0010, 0xFFFF, 0xFFFF, "Heathrow Mac I/O(0x0010)"},
{0x106B, 0x0017, 0xFFFF, 0xFFFF, "Paddington Mac I/O(0x0017)"},
{0x106B, 0x0018, 0xFFFF, 0xFFFF, "UniNorth FireWire(0x0018)"},
{0x106B, 0x0019, 0xFFFF, 0xFFFF, "KeyLargo USB(0x0019)"},
{0x106B, 0x001E, 0xFFFF, 0xFFFF, "UniNorth Internal PCI(0x001E)"},
{0x106B, 0x001F, 0xFFFF, 0xFFFF, "UniNorth PCI(0x001F)"},
{0x106B, 0x0020, 0xFFFF, 0xFFFF, "UniNorth AGP(0x0020)"},
{0x106B, 0x0021, 0xFFFF, 0xFFFF, "UniNorth GMAC (Sun GEM)(0x0021)"},
{0x106B, 0x0022, 0xFFFF, 0xFFFF, "KeyLargo Mac I/O(0x0022)"},
{0x106B, 0x0024, 0xFFFF, 0xFFFF, "UniNorth/Pangea GMAC (Sun GEM)(0x0024)"},
{0x106B, 0x0025, 0xFFFF, 0xFFFF, "KeyLargo/Pangea Mac I/O(0x0025)"},
{0x106B, 0x0026, 0xFFFF, 0xFFFF, "KeyLargo/Pangea USB(0x0026)"},
{0x106B, 0x0027, 0xFFFF, 0xFFFF, "UniNorth/Pangea AGP(0x0027)"},
{0x106B, 0x0028, 0xFFFF, 0xFFFF, "UniNorth/Pangea PCI(0x0028)"},
{0x106B, 0x0029, 0xFFFF, 0xFFFF, "UniNorth/Pangea Internal PCI(0x0029)"},
{0x106B, 0x002D, 0xFFFF, 0xFFFF, "UniNorth 1.5 AGP(0x002D)"},
{0x106B, 0x002E, 0xFFFF, 0xFFFF, "UniNorth 1.5 PCI(0x002E)"},
{0x106B, 0x002F, 0xFFFF, 0xFFFF, "UniNorth 1.5 Internal PCI(0x002F)"},
{0x106B, 0x0030, 0xFFFF, 0xFFFF, "UniNorth/Pangea FireWire(0x0030)"},
{0x106B, 0x0031, 0xFFFF, 0xFFFF, "UniNorth 2 FireWire(0x0031)"},
{0x106B, 0x0031, 0x106B, 0x5811, "iBook G4 2004(0x106B-0x5811)"},
{0x106B, 0x0032, 0xFFFF, 0xFFFF, "UniNorth 2 GMAC (Sun GEM)(0x0032)"},
{0x106B, 0x0033, 0xFFFF, 0xFFFF, "UniNorth 2 ATA/100(0x0033)"},
{0x106B, 0x0034, 0xFFFF, 0xFFFF, "UniNorth 2 AGP(0x0034)"},
{0x106B, 0x0035, 0xFFFF, 0xFFFF, "UniNorth 2 PCI(0x0035)"},
{0x106B, 0x0036, 0xFFFF, 0xFFFF, "UniNorth 2 Internal PCI(0x0036)"},
{0x106B, 0x003B, 0xFFFF, 0xFFFF, "UniNorth/Intrepid ATA/100(0x003B)"},
{0x106B, 0x003E, 0xFFFF, 0xFFFF, "KeyLargo/Intrepid Mac I/O(0x003E)"},
{0x106B, 0x003F, 0xFFFF, 0xFFFF, "KeyLargo/Intrepid USB(0x003F)"},
{0x106B, 0x003F, 0x1AF4, 0x1100, "QEMU Virtual Machine(0x1AF4-0x1100)"},
{0x106B, 0x0040, 0xFFFF, 0xFFFF, "K2 KeyLargo USB(0x0040)"},
{0x106B, 0x0041, 0xFFFF, 0xFFFF, "K2 KeyLargo Mac/IO(0x0041)"},
{0x106B, 0x0042, 0xFFFF, 0xFFFF, "K2 FireWire(0x0042)"},
{0x106B, 0x0043, 0xFFFF, 0xFFFF, "K2 ATA/100(0x0043)"},
{0x106B, 0x0045, 0xFFFF, 0xFFFF, "K2 HT-PCI Bridge(0x0045)"},
{0x106B, 0x0046, 0xFFFF, 0xFFFF, "K2 HT-PCI Bridge(0x0046)"},
{0x106B, 0x0047, 0xFFFF, 0xFFFF, "K2 HT-PCI Bridge(0x0047)"},
{0x106B, 0x0048, 0xFFFF, 0xFFFF, "K2 HT-PCI Bridge(0x0048)"},
{0x106B, 0x0049, 0xFFFF, 0xFFFF, "K2 HT-PCI Bridge(0x0049)"},
{0x106B, 0x004A, 0xFFFF, 0xFFFF, "CPC945 HT Bridge(0x004A)"},
{0x106B, 0x004B, 0xFFFF, 0xFFFF, "U3 AGP(0x004B)"},
{0x106B, 0x004C, 0xFFFF, 0xFFFF, "K2 GMAC (Sun GEM)(0x004C)"},
{0x106B, 0x004F, 0xFFFF, 0xFFFF, "Shasta Mac I/O(0x004F)"},
{0x106B, 0x0050, 0xFFFF, 0xFFFF, "Shasta IDE(0x0050)"},
{0x106B, 0x0051, 0xFFFF, 0xFFFF, "Shasta (Sun GEM)(0x0051)"},
{0x106B, 0x0052, 0xFFFF, 0xFFFF, "Shasta Firewire(0x0052)"},
{0x106B, 0x0053, 0xFFFF, 0xFFFF, "Shasta PCI Bridge(0x0053)"},
{0x106B, 0x0054, 0xFFFF, 0xFFFF, "Shasta PCI Bridge(0x0054)"},
{0x106B, 0x0055, 0xFFFF, 0xFFFF, "Shasta PCI Bridge(0x0055)"},
{0x106B, 0x0056, 0xFFFF, 0xFFFF, "U4 PCIe(0x0056)"},
{0x106B, 0x0057, 0xFFFF, 0xFFFF, "U3 HT Bridge(0x0057)"},
{0x106B, 0x0058, 0xFFFF, 0xFFFF, "U3L AGP Bridge(0x0058)"},
{0x106B, 0x0059, 0xFFFF, 0xFFFF, "U3H AGP Bridge(0x0059)"},
{0x106B, 0x005B, 0xFFFF, 0xFFFF, "CPC945 PCIe Bridge(0x005B)"},
{0x106B, 0x0066, 0xFFFF, 0xFFFF, "Intrepid2 AGP Bridge(0x0066)"},
{0x106B, 0x0067, 0xFFFF, 0xFFFF, "Intrepid2 PCI Bridge(0x0067)"},
{0x106B, 0x0068, 0xFFFF, 0xFFFF, "Intrepid2 PCI Bridge(0x0068)"},
{0x106B, 0x0069, 0xFFFF, 0xFFFF, "Intrepid2 ATA/100(0x0069)"},
{0x106B, 0x006A, 0xFFFF, 0xFFFF, "Intrepid2 Firewire(0x006A)"},
{0x106B, 0x006B, 0xFFFF, 0xFFFF, "Intrepid2 GMAC (Sun GEM)(0x006B)"},
{0x106B, 0x0074, 0xFFFF, 0xFFFF, "U4 HT Bridge(0x0074)"},
{0x106B, 0x100C, 0xFFFF, 0xFFFF, "Apple Silicon PCI Express Root Port(0x100C)"},
{0x106B, 0x1010, 0xFFFF, 0xFFFF, "Apple Silicon USB4/Thunderbolt PCI Express Root Port(0x1010)"},
{0x106B, 0x1645, 0xFFFF, 0xFFFF, "Broadcom NetXtreme BCM5701 Gigabit Ethernet(0x1645)"},
{0x106B, 0x1801, 0xFFFF, 0xFFFF, "T2 Bridge Controller(0x1801)"},
{0x106B, 0x1802, 0xFFFF, 0xFFFF, "T2 Secure Enclave Processor(0x1802)"},
{0x106B, 0x1803, 0xFFFF, 0xFFFF, "Apple Audio Device(0x1803)"},
{0x106B, 0x2001, 0xFFFF, 0xFFFF, "S1X NVMe Controller(0x2001)"},
{0x106B, 0x2002, 0xFFFF, 0xFFFF, "S3ELab NVMe Controller(0x2002)"},
{0x106B, 0x2003, 0xFFFF, 0xFFFF, "S3X NVMe Controller(0x2003)"},
{0x106B, 0x2005, 0xFFFF, 0xFFFF, "ANS2 NVMe Controller(0x2005)"},
}; /* pci_vid_106B[] */

static pci_id_t const pci_vid_106C[] = {
{0x106C, 0xFFFF, 0xFFFF, 0xFFFF, "Hynix Semiconductor(0x106C)"},
{0x106C, 0x8139, 0xFFFF, 0xFFFF, "8139c 100BaseTX Ethernet Controller(0x8139)"},
{0x106C, 0x8801, 0xFFFF, 0xFFFF, "Dual Pentium ISA/PCI Motherboard(0x8801)"},
{0x106C, 0x8802, 0xFFFF, 0xFFFF, "PowerPC ISA/PCI Motherboard(0x8802)"},
{0x106C, 0x8803, 0xFFFF, 0xFFFF, "Dual Window Graphics Accelerator(0x8803)"},
{0x106C, 0x8804, 0xFFFF, 0xFFFF, "LAN Controller(0x8804)"},
{0x106C, 0x8805, 0xFFFF, 0xFFFF, "100-BaseT LAN(0x8805)"},
}; /* pci_vid_106C[] */

static pci_id_t const pci_vid_106D[] = {
{0x106D, 0xFFFF, 0xFFFF, 0xFFFF, "Sequent Computer Systems(0x106D)"},
}; /* pci_vid_106D[] */

static pci_id_t const pci_vid_106E[] = {
{0x106E, 0xFFFF, 0xFFFF, 0xFFFF, "DFI, Inc(0x106E)"},
}; /* pci_vid_106E[] */

static pci_id_t const pci_vid_106F[] = {
{0x106F, 0xFFFF, 0xFFFF, 0xFFFF, "City Gate Development Ltd(0x106F)"},
}; /* pci_vid_106F[] */

static pci_id_t const pci_vid_1070[] = {
{0x1070, 0xFFFF, 0xFFFF, 0xFFFF, "Daewoo Telecom Ltd(0x1070)"},
}; /* pci_vid_1070[] */

static pci_id_t const pci_vid_1071[] = {
{0x1071, 0xFFFF, 0xFFFF, 0xFFFF, "Mitac(0x1071)"},
{0x1071, 0x8160, 0xFFFF, 0xFFFF, "Mitac 8060B Mobile Platform(0x8160)"},
}; /* pci_vid_1071[] */

static pci_id_t const pci_vid_1072[] = {
{0x1072, 0xFFFF, 0xFFFF, 0xFFFF, "GIT Co Ltd(0x1072)"},
}; /* pci_vid_1072[] */

static pci_id_t const pci_vid_1073[] = {
{0x1073, 0xFFFF, 0xFFFF, 0xFFFF, "Yamaha Corporation(0x1073)"},
{0x1073, 0x0001, 0xFFFF, 0xFFFF, "3D GUI Accelerator(0x0001)"},
{0x1073, 0x0002, 0xFFFF, 0xFFFF, "YGV615 [RPA3 3D-Graphics Controller](0x0002)"},
{0x1073, 0x0003, 0xFFFF, 0xFFFF, "YMF-740(0x0003)"},
{0x1073, 0x0004, 0xFFFF, 0xFFFF, "YMF-724(0x0004)"},
{0x1073, 0x0004, 0x1073, 0x0004, "YMF724-Based PCI Audio Adapter(0x1073-0x0004)"},
{0x1073, 0x0005, 0xFFFF, 0xFFFF, "DS1 Audio(0x0005)"},
{0x1073, 0x0005, 0x1073, 0x0005, "DS-XG PCI Audio CODEC(0x1073-0x0005)"},
{0x1073, 0x0006, 0xFFFF, 0xFFFF, "DS1 Audio(0x0006)"},
{0x1073, 0x0008, 0xFFFF, 0xFFFF, "DS1 Audio(0x0008)"},
{0x1073, 0x0008, 0x1073, 0x0008, "DS-XG PCI Audio CODEC(0x1073-0x0008)"},
{0x1073, 0x000A, 0xFFFF, 0xFFFF, "DS1L Audio(0x000A)"},
{0x1073, 0x000A, 0x1073, 0x0004, "DS-XG PCI Audio CODEC(0x1073-0x0004)"},
{0x1073, 0x000A, 0x1073, 0x000A, "DS-XG PCI Audio CODEC(0x1073-0x000A)"},
{0x1073, 0x000A, 0x8086, 0x4D55, "DS-XG PCI Audio CODEC [Intel MU440EX](0x8086-0x4D55)"},
{0x1073, 0x000C, 0xFFFF, 0xFFFF, "YMF-740C [DS-1L Audio Controller](0x000C)"},
{0x1073, 0x000C, 0x107A, 0x000C, "DS-XG PCI Audio CODEC(0x107A-0x000C)"},
{0x1073, 0x000D, 0xFFFF, 0xFFFF, "YMF-724F [DS-1 Audio Controller](0x000D)"},
{0x1073, 0x000D, 0x1073, 0x000D, "DS-XG PCI Audio CODEC(0x1073-0x000D)"},
{0x1073, 0x0010, 0xFFFF, 0xFFFF, "YMF-744B [DS-1S Audio Controller](0x0010)"},
{0x1073, 0x0010, 0x1073, 0x0006, "DS-XG PCI Audio CODEC(0x1073-0x0006)"},
{0x1073, 0x0010, 0x1073, 0x0010, "DS-XG PCI Audio CODEC(0x1073-0x0010)"},
{0x1073, 0x0012, 0xFFFF, 0xFFFF, "YMF-754 [DS-1E Audio Controller](0x0012)"},
{0x1073, 0x0012, 0x1073, 0x0012, "DS-XG PCI Audio Codec(0x1073-0x0012)"},
{0x1073, 0x0020, 0xFFFF, 0xFFFF, "DS-1 Audio(0x0020)"},
{0x1073, 0x1000, 0xFFFF, 0xFFFF, "SW1000XG [XG Factory](0x1000)"},
{0x1073, 0x2000, 0xFFFF, 0xFFFF, "DS2416 Digital Mixing Card(0x2000)"},
{0x1073, 0x2000, 0x1073, 0x2000, "DS2416 Digital Mixing Card(0x1073-0x2000)"},
}; /* pci_vid_1073[] */

static pci_id_t const pci_vid_1074[] = {
{0x1074, 0xFFFF, 0xFFFF, 0xFFFF, "NexGen Microsystems(0x1074)"},
{0x1074, 0x4E78, 0xFFFF, 0xFFFF, "82c500/1(0x4E78)"},
}; /* pci_vid_1074[] */

static pci_id_t const pci_vid_1075[] = {
{0x1075, 0xFFFF, 0xFFFF, 0xFFFF, "Advanced Integrations Research(0x1075)"},
}; /* pci_vid_1075[] */

static pci_id_t const pci_vid_1076[] = {
{0x1076, 0xFFFF, 0xFFFF, 0xFFFF, "Chaintech Computer Co. Ltd(0x1076)"},
}; /* pci_vid_1076[] */

static pci_id_t const pci_vid_1077[] = {
{0x1077, 0xFFFF, 0xFFFF, 0xFFFF, "QLogic Corp.(0x1077)"},
{0x1077, 0x1016, 0xFFFF, 0xFFFF, "ISP10160 Single Channel Ultra3 SCSI Processor(0x1016)"},
{0x1077, 0x1020, 0xFFFF, 0xFFFF, "ISP1020/1040 Fast-wide SCSI(0x1020)"},
{0x1077, 0x1022, 0xFFFF, 0xFFFF, "ISP1022 Fast-wide SCSI(0x1022)"},
{0x1077, 0x1080, 0xFFFF, 0xFFFF, "ISP1080 SCSI Host Adapter(0x1080)"},
{0x1077, 0x1216, 0xFFFF, 0xFFFF, "ISP12160 Dual Channel Ultra3 SCSI Processor(0x1216)"},
{0x1077, 0x1216, 0x101E, 0x8471, "QLA12160 on AMI MegaRAID(0x101E-0x8471)"},
{0x1077, 0x1216, 0x101E, 0x8493, "QLA12160 on AMI MegaRAID(0x101E-0x8493)"},
{0x1077, 0x1240, 0xFFFF, 0xFFFF, "ISP1240 SCSI Host Adapter(0x1240)"},
{0x1077, 0x1280, 0xFFFF, 0xFFFF, "ISP1280 SCSI Host Adapter(0x1280)"},
{0x1077, 0x1634, 0xFFFF, 0xFFFF, "FastLinQ QL45000 Series 40GbE Controller(0x1634)"},
{0x1077, 0x1634, 0x1077, 0xE4F1, "FastLinQ QL45212H 40GbE Adapter(0x1077-0xE4F1)"},
{0x1077, 0x1634, 0x1077, 0xE4F2, "FastLinQ QL45211H 40GbE Adapter(0x1077-0xE4F2)"},
{0x1077, 0x1634, 0x1077, 0xE4F3, "FastLinQ QL45412H 40GbE Adapter(0x1077-0xE4F3)"},
{0x1077, 0x1634, 0x1077, 0xE4F4, "FastLinQ QL45411H 40GbE Adapter(0x1077-0xE4F4)"},
{0x1077, 0x1644, 0xFFFF, 0xFFFF, "FastLinQ QL45000 Series 100GbE Controller(0x1644)"},
{0x1077, 0x1644, 0x1077, 0xE4F8, "FastLinQ QL45611H 100GbE Adapter(0x1077-0xE4F8)"},
{0x1077, 0x1654, 0xFFFF, 0xFFFF, "FastLinQ QL45000 Series 50GbE Controller(0x1654)"},
{0x1077, 0x1654, 0x1077, 0x0032, "QL45212 Flex 50Gb 2-port Ethernet Adapter(0x1077-0x0032)"},
{0x1077, 0x1654, 0x1590, 0x0223, "Synergy 6810C 25/50Gb Ethernet Adapter(0x1590-0x0223)"},
{0x1077, 0x1654, 0x1590, 0x0287, "Synergy 6820C 25/50Gb CNA(0x1590-0x0287)"},
{0x1077, 0x1656, 0xFFFF, 0xFFFF, "FastLinQ QL45000 Series 25GbE Controller(0x1656)"},
{0x1077, 0x1656, 0x1077, 0x0033, "QL45214 Flex 25Gb 4-port Ethernet Adapter(0x1077-0x0033)"},
{0x1077, 0x1656, 0x1077, 0x02A7, "QL45212-DE 25GbE Adapter(0x1077-0x02A7)"},
{0x1077, 0x1656, 0x1077, 0xE4F6, "FastLinQ QL45211H 25GbE Adapter(0x1077-0xE4F6)"},
{0x1077, 0x1656, 0x1077, 0xE4F7, "FastLinQ QL45212H 25GbE Adapter(0x1077-0xE4F7)"},
{0x1077, 0x1656, 0x1590, 0x0245, "10/20/25GbE 2P 4820c CNA(0x1590-0x0245)"},
{0x1077, 0x165C, 0xFFFF, 0xFFFF, "FastLinQ QL45000 Series 10/25/40/50GbE Controller (FCoE)(0x165C)"},
{0x1077, 0x165C, 0x1077, 0x0034, "QL45262 Flex 50Gb 2-port Ethernet Adapter w/ iSCSI/FCoE(0x1077-0x0034)"},
{0x1077, 0x165C, 0x1077, 0xE4F1, "FastLinQ QL45462H 40GbE FCoE Adapter(0x1077-0xE4F1)"},
{0x1077, 0x165C, 0x1077, 0xE4F2, "FastLinQ QL45461H 40GbE FCoE Adapter(0x1077-0xE4F2)"},
{0x1077, 0x165C, 0x1590, 0x0245, "10/20/25GbE 2P 4820c CNA FCoE(0x1590-0x0245)"},
{0x1077, 0x165E, 0xFFFF, 0xFFFF, "FastLinQ QL45000 Series 10/25/40/50GbE Controller (iSCSI)(0x165E)"},
{0x1077, 0x165E, 0x1077, 0x0034, "QL45262 Flex 50Gb 2-port Ethernet Adapter w/ iSCSI/FCoE(0x1077-0x0034)"},
{0x1077, 0x165E, 0x1077, 0xE4F1, "FastLinQ QL45462H 40GbE iSCSI Adapter(0x1077-0xE4F1)"},
{0x1077, 0x165E, 0x1077, 0xE4F2, "FastLinQ QL45461H 40GbE iSCSI Adapter(0x1077-0xE4F2)"},
{0x1077, 0x165E, 0x1590, 0x0245, "10/20/25GbE 2P 4820c CNA iSCSI(0x1590-0x0245)"},
{0x1077, 0x1664, 0xFFFF, 0xFFFF, "FastLinQ QL45000 Series Gigabit Ethernet Controller (SR-IOV VF)(0x1664)"},
{0x1077, 0x1664, 0x1077, 0xE4F1, "FastLinQ QL45462H 40GbE Adapter (SR-IOV VF)(0x1077-0xE4F1)"},
{0x1077, 0x1664, 0x1077, 0xE4F2, "FastLinQ QL45461H 40GbE Adapter (SR-IOV VF)(0x1077-0xE4F2)"},
{0x1077, 0x1664, 0x1077, 0xE4F3, "FastLinQ QL45412H 40GbE Adapter (SR-IOV VF)(0x1077-0xE4F3)"},
{0x1077, 0x1664, 0x1077, 0xE4F4, "FastLinQ QL45411H 40GbE Adapter (SR-IOV VF)(0x1077-0xE4F4)"},
{0x1077, 0x1664, 0x1077, 0xE4F6, "FastLinQ QL45211H 25GbE Adapter (SR-IOV VF)(0x1077-0xE4F6)"},
{0x1077, 0x1664, 0x1077, 0xE4F7, "FastLinQ QL45212H 25GbE Adapter (SR-IOV VF)(0x1077-0xE4F7)"},
{0x1077, 0x1664, 0x1077, 0xE4F8, "FastLinQ QL45611H 100GbE Adapter (SR-IOV VF)(0x1077-0xE4F8)"},
{0x1077, 0x1664, 0x1590, 0x0245, "10/20/25GbE 2P 4820c CNA SRIOV(0x1590-0x0245)"},
{0x1077, 0x2020, 0xFFFF, 0xFFFF, "ISP2020A Fast!SCSI Basic Adapter(0x2020)"},
{0x1077, 0x2031, 0xFFFF, 0xFFFF, "ISP8324-based 16Gb Fibre Channel to PCI Express Adapter(0x2031)"},
{0x1077, 0x2031, 0x103C, 0x17E7, "SN1000Q 16Gb Single Port Fibre Channel Adapter(0x103C-0x17E7)"},
{0x1077, 0x2031, 0x103C, 0x17E8, "SN1000Q 16Gb Dual Port Fibre Channel Adapter(0x103C-0x17E8)"},
{0x1077, 0x2031, 0x103C, 0x1939, "QMH2672 16Gb Dual Port Fibre Channel Adapter(0x103C-0x1939)"},
{0x1077, 0x2031, 0x103C, 0x8002, "3830C 16G Fibre Channel Host Bus Adapter(0x103C-0x8002)"},
{0x1077, 0x2031, 0x1077, 0x0241, "QLE2670 16Gb Single Port Fibre Channel Adapter(0x1077-0x0241)"},
{0x1077, 0x2031, 0x1077, 0x0249, "QLE2672 16Gb Dual Port Fibre Channel Adapter(0x1077-0x0249)"},
{0x1077, 0x2071, 0xFFFF, 0xFFFF, "ISP2714-based 16/32Gb Fibre Channel to PCIe Adapter(0x2071)"},
{0x1077, 0x2071, 0x1077, 0x0283, "QLE2764 Quad Port 32Gb Fibre Channel to PCIe Adapter(0x1077-0x0283)"},
{0x1077, 0x2071, 0x1077, 0x029E, "QLE2694 Quad Port 16Gb Fibre Channel to PCIe Adapter(0x1077-0x029E)"},
{0x1077, 0x2071, 0x1077, 0x02A2, "QLE2694L Quad Port 16Gb Fibre Channel to PCIe Adapter(0x1077-0x02A2)"},
{0x1077, 0x2071, 0x1077, 0x02AD, "QLE2694U Quad Port 16/32Gb Fibre Channel to PCIe Adapter(0x1077-0x02AD)"},
{0x1077, 0x2081, 0xFFFF, 0xFFFF, "ISP2814-based 64/32G Fibre Channel to PCIe Controller(0x2081)"},
{0x1077, 0x2081, 0x1077, 0x02E1, "QLE2874 Quad Port 64GFC PCIe Gen4 x16 Adapter(0x1077-0x02E1)"},
{0x1077, 0x2081, 0x1077, 0x02E3, "QLE2774 Quad Port 32GFC PCIe Gen4 x16 Adapter(0x1077-0x02E3)"},
{0x1077, 0x2089, 0xFFFF, 0xFFFF, "ISP2854-based 64/32G Fibre Channel to PCIe Controller with StorCryption(0x2089)"},
{0x1077, 0x2089, 0x1077, 0x02E8, "QLE2884 Quad Port 64GFC PCIe Gen4 x16 Adapter with StorCryption(0x1077-0x02E8)"},
{0x1077, 0x2089, 0x1077, 0x02EA, "QLE2784 Quad Port 32GFC PCIe Gen4 x16 Adapter with StorCryption(0x1077-0x02EA)"},
{0x1077, 0x2100, 0xFFFF, 0xFFFF, "QLA2100 64-bit Fibre Channel Adapter(0x2100)"},
{0x1077, 0x2100, 0x1077, 0x0001, "QLA2100 64-bit Fibre Channel Adapter(0x1077-0x0001)"},
{0x1077, 0x2200, 0xFFFF, 0xFFFF, "QLA2200 64-bit Fibre Channel Adapter(0x2200)"},
{0x1077, 0x2200, 0x1077, 0x0002, "QLA2200(0x1077-0x0002)"},
{0x1077, 0x2261, 0xFFFF, 0xFFFF, "ISP2722-based 16/32Gb Fibre Channel to PCIe Adapter(0x2261)"},
{0x1077, 0x2261, 0x1077, 0x0299, "QLE2740 Single Port 32Gb Fibre Channel to PCIe Adapter(0x1077-0x0299)"},
{0x1077, 0x2261, 0x1077, 0x029A, "QLE2742 Dual Port 32Gb Fibre Channel to PCIe Adapter(0x1077-0x029A)"},
{0x1077, 0x2261, 0x1077, 0x029B, "QLE2690 Single Port 16Gb Fibre Channel to PCIe Adapter(0x1077-0x029B)"},
{0x1077, 0x2261, 0x1077, 0x029C, "QLE2692 Dual Port 16Gb Fibre Channel to PCIe Adapter(0x1077-0x029C)"},
{0x1077, 0x2261, 0x1077, 0x02A7, "QLE2690 Single Port 16Gb FC to PCIe Gen3 x8 Adapter(0x1077-0x02A7)"},
{0x1077, 0x2261, 0x1077, 0x02A8, "QLE2692 Dual Port 16Gb FC to PCIe Gen3 x8 Adapter(0x1077-0x02A8)"},
{0x1077, 0x2261, 0x1077, 0x02AB, "QLE2740 Single Port 32Gb FC to PCIe Gen3 x8 Adapter(0x1077-0x02AB)"},
{0x1077, 0x2261, 0x1077, 0x02AC, "QLE2742 Dual Port 32Gb FC to PCIe Gen3 x8 Adapter(0x1077-0x02AC)"},
{0x1077, 0x2261, 0x1077, 0x02B8, "2x16Gb QME2692 FC HBA(0x1077-0x02B8)"},
{0x1077, 0x2261, 0x1077, 0x02B9, "2x32Gb QME2742 FC HBA(0x1077-0x02B9)"},
{0x1077, 0x2261, 0x1590, 0x00F9, "StoreFabric SN1100Q 16Gb Single Port Fibre Channel Host Bus Adapter(0x1590-0x00F9)"},
{0x1077, 0x2261, 0x1590, 0x00FA, "StoreFabric SN1100Q 16Gb Dual Port Fibre Channel Host Bus Adapter(0x1590-0x00FA)"},
{0x1077, 0x2261, 0x1590, 0x0203, "StoreFabric SN1600Q 32Gb Single Port Fibre Channel Host Bus Adapter(0x1590-0x0203)"},
{0x1077, 0x2261, 0x1590, 0x0204, "StoreFabric SN1600Q 32Gb Dual Port Fibre Channel Host Bus Adapter(0x1590-0x0204)"},
{0x1077, 0x2261, 0x1590, 0x022D, "5830C 32Gb Dual Port Fibre Channel Adapter(0x1590-0x022D)"},
{0x1077, 0x2261, 0x193D, 0x100D, "NIC-FC680i-Mb-2x16G(0x193D-0x100D)"},
{0x1077, 0x2281, 0xFFFF, 0xFFFF, "ISP2812-based 64/32G Fibre Channel to PCIe Controller(0x2281)"},
{0x1077, 0x2281, 0x1077, 0x02E2, "QLE2872 Dual Port 64GFC PCIe Gen4 x8 Adapter(0x1077-0x02E2)"},
{0x1077, 0x2281, 0x1077, 0x02E4, "QLE2772 Dual Port 32GFC PCIe Gen4 x8 Adapter(0x1077-0x02E4)"},
{0x1077, 0x2281, 0x1077, 0x02EE, "QLE2870 Single Port 64GFC PCIe Gen4 x8 Adapter(0x1077-0x02EE)"},
{0x1077, 0x2281, 0x1077, 0x02F0, "QLE2770 Single Port 32GFC PCIe Gen4 x8 Adapter(0x1077-0x02F0)"},
{0x1077, 0x2281, 0x1077, 0x02F2, "QLogic 1x32Gb QLE2770 FC HBA(0x1077-0x02F2)"},
{0x1077, 0x2281, 0x1077, 0x02F3, "QLogic 2x32Gb QLE2772 FC HBA(0x1077-0x02F3)"},
{0x1077, 0x2281, 0x1590, 0x02D3, "SN1610Q - 1P Enhanced 32GFC Single Port Fibre Channel Host Bus Adapter(0x1590-0x02D3)"},
{0x1077, 0x2281, 0x1590, 0x02D4, "SN1610Q - 2P Enhanced 32GFC Dual Port Fibre Channel Host Bus Adapter(0x1590-0x02D4)"},
{0x1077, 0x2289, 0xFFFF, 0xFFFF, "ISP2852-based 64/32G Fibre Channel to PCIe Controller with StorCryption(0x2289)"},
{0x1077, 0x2289, 0x1077, 0x02E9, "QLE2882 Dual Port 64GFC PCIe Gen4 x8 Adapter with StorCryption(0x1077-0x02E9)"},
{0x1077, 0x2289, 0x1077, 0x02EB, "QLE2782 Dual Port 32GFC PCIe Gen4 x8 Adapter with StorCryption(0x1077-0x02EB)"},
{0x1077, 0x2289, 0x1077, 0x02EF, "QLE2880 Single Port 64GFC PCIe Gen4 x8 Adapter with StorCryption(0x1077-0x02EF)"},
{0x1077, 0x2289, 0x1077, 0x02F1, "QLE2780 Single Port 32GFC PCIe Gen4 x8 Adapter with StorCryption(0x1077-0x02F1)"},
{0x1077, 0x2300, 0xFFFF, 0xFFFF, "QLA2300 64-bit Fibre Channel Adapter(0x2300)"},
{0x1077, 0x2312, 0xFFFF, 0xFFFF, "ISP2312-based 2Gb Fibre Channel to PCI-X HBA(0x2312)"},
{0x1077, 0x2312, 0x103C, 0x0131, "2Gb Fibre Channel - Single port [A7538A](0x103C-0x0131)"},
{0x1077, 0x2312, 0x103C, 0x12BA, "2Gb Fibre Channel - Dual port [A6826A](0x103C-0x12BA)"},
{0x1077, 0x2322, 0xFFFF, 0xFFFF, "ISP2322-based 2Gb Fibre Channel to PCI-X HBA(0x2322)"},
{0x1077, 0x2422, 0xFFFF, 0xFFFF, "ISP2422-based 4Gb Fibre Channel to PCI-X HBA(0x2422)"},
{0x1077, 0x2422, 0x103C, 0x12D7, "4Gb Fibre Channel [AB379A](0x103C-0x12D7)"},
{0x1077, 0x2422, 0x103C, 0x12DD, "4Gb Fibre Channel [AB429A](0x103C-0x12DD)"},
{0x1077, 0x2432, 0xFFFF, 0xFFFF, "ISP2432-based 4Gb Fibre Channel to PCI Express HBA(0x2432)"},
{0x1077, 0x2432, 0x103C, 0x7040, "FC1142SR 4Gb 1-port PCIe Fibre Channel Host Bus Adapter [HPAE311A](0x103C-0x7040)"},
{0x1077, 0x2432, 0x1077, 0x0137, "QLE2460 Single-Port 4Gbps FC-to-PCI-X/PCIe Host Bus Adapter(0x1077-0x0137)"},
{0x1077, 0x2432, 0x1077, 0x0138, "QLE2462 Dual-Port 4Gbps FC-to-PCI-X/PCIe Host Bus Adapter(0x1077-0x0138)"},
{0x1077, 0x2532, 0xFFFF, 0xFFFF, "ISP2532-based 8Gb Fibre Channel to PCI Express HBA(0x2532)"},
{0x1077, 0x2532, 0x1014, 0x041E, "FC EN0Y/EN12 PCIe2 LP 8 Gb 4-port Fibre Channel Adapter for POWER(0x1014-0x041E)"},
{0x1077, 0x2532, 0x103C, 0x3262, "StorageWorks 81Q(0x103C-0x3262)"},
{0x1077, 0x2532, 0x103C, 0x3263, "StorageWorks 82Q(0x103C-0x3263)"},
{0x1077, 0x2532, 0x1077, 0x015C, "QLE2560 PCI Express to 8Gb FC Single Channel(0x1077-0x015C)"},
{0x1077, 0x2532, 0x1077, 0x015D, "QLE2562 PCI Express to 8Gb FC Dual Channel(0x1077-0x015D)"},
{0x1077, 0x2532, 0x1077, 0x015E, "QLE2564 PCI Express to 8Gb FC Quad Channel(0x1077-0x015E)"},
{0x1077, 0x2532, 0x1077, 0x0167, "QME2572 Dual Port FC8 HBA Mezzanine(0x1077-0x0167)"},
{0x1077, 0x2532, 0x1590, 0x00FC, "StoreFabric 84Q 8Gb Quad Port Fibre Channel Host Bus Adapter(0x1590-0x00FC)"},
{0x1077, 0x2971, 0xFFFF, 0xFFFF, "ISP2684(0x2971)"},
{0x1077, 0x2981, 0xFFFF, 0xFFFF, "32G SFP28 EP2744 Apatter(0x2981)"},
{0x1077, 0x2981, 0x1BD4, 0x00B0, "32G SFP28 EP2744 Apatter(0x1BD4-0x00B0)"},
{0x1077, 0x3022, 0xFFFF, 0xFFFF, "ISP4022-based Ethernet NIC(0x3022)"},
{0x1077, 0x3032, 0xFFFF, 0xFFFF, "ISP4032-based Ethernet IPv6 NIC(0x3032)"},
{0x1077, 0x4010, 0xFFFF, 0xFFFF, "ISP4010-based iSCSI TOE HBA(0x4010)"},
{0x1077, 0x4022, 0xFFFF, 0xFFFF, "ISP4022-based iSCSI TOE HBA(0x4022)"},
{0x1077, 0x4032, 0xFFFF, 0xFFFF, "ISP4032-based iSCSI TOE IPv6 HBA(0x4032)"},
{0x1077, 0x5432, 0xFFFF, 0xFFFF, "SP232-based 4Gb Fibre Channel to PCI Express HBA(0x5432)"},
{0x1077, 0x6312, 0xFFFF, 0xFFFF, "SP202-based 2Gb Fibre Channel to PCI-X HBA(0x6312)"},
{0x1077, 0x6322, 0xFFFF, 0xFFFF, "SP212-based 2Gb Fibre Channel to PCI-X HBA(0x6322)"},
{0x1077, 0x7220, 0xFFFF, 0xFFFF, "IBA7220 InfiniBand HCA(0x7220)"},
{0x1077, 0x7322, 0xFFFF, 0xFFFF, "IBA7322 QDR InfiniBand HCA(0x7322)"},
{0x1077, 0x8000, 0xFFFF, 0xFFFF, "10GbE Converged Network Adapter (TCP/IP Networking)(0x8000)"},
{0x1077, 0x8001, 0xFFFF, 0xFFFF, "10GbE Converged Network Adapter (FCoE)(0x8001)"},
{0x1077, 0x8001, 0x1014, 0x03AF, "FC 5708/5270 10 Gb FCoE PCIe Dual Port Adapter for POWER(0x1014-0x03AF)"},
{0x1077, 0x8020, 0xFFFF, 0xFFFF, "cLOM8214 1/10GbE Controller(0x8020)"},
{0x1077, 0x8020, 0x1028, 0x1F64, "QMD8262-k 10G DP bNDC KR(0x1028-0x1F64)"},
{0x1077, 0x8020, 0x103C, 0x3346, "CN1000Q Dual Port Converged Network Adapter(0x103C-0x3346)"},
{0x1077, 0x8020, 0x103C, 0x3733, "NC523SFP 10Gb 2-port Server Adapter(0x103C-0x3733)"},
{0x1077, 0x8020, 0x1077, 0x0203, "8200 Series Single Port 10GbE Converged Network Adapter (TCP/IP Networking)(0x1077-0x0203)"},
{0x1077, 0x8020, 0x1077, 0x0207, "8200 Series Dual Port 10GbE Converged Network Adapter (TCP/IP Networking)(0x1077-0x0207)"},
{0x1077, 0x8020, 0x1077, 0x020B, "3200 Series Dual Port 10Gb Intelligent Ethernet Adapter(0x1077-0x020B)"},
{0x1077, 0x8020, 0x1077, 0x020C, "3200 Series Quad Port 1Gb Intelligent Ethernet Adapter(0x1077-0x020C)"},
{0x1077, 0x8020, 0x1077, 0x020F, "3200 Series Single Port 10Gb Intelligent Ethernet Adapter(0x1077-0x020F)"},
{0x1077, 0x8020, 0x1077, 0x0210, "QME8242-k 10GbE Dual Port Mezzanine Card(0x1077-0x0210)"},
{0x1077, 0x8020, 0x1077, 0x0233, "QME8262-k 10GbE Dual Port Mezzanine Card(0x1077-0x0233)"},
{0x1077, 0x8021, 0xFFFF, 0xFFFF, "8200 Series 10GbE Converged Network Adapter (FCoE)(0x8021)"},
{0x1077, 0x8021, 0x103C, 0x3348, "CN1000Q Dual Port Converged Network Adapter(0x103C-0x3348)"},
{0x1077, 0x8021, 0x1077, 0x0211, "QME8242-k 10GbE Dual Port Mezzanine Card, FCoE(0x1077-0x0211)"},
{0x1077, 0x8022, 0xFFFF, 0xFFFF, "8200 Series 10GbE Converged Network Adapter (iSCSI)(0x8022)"},
{0x1077, 0x8022, 0x103C, 0x3347, "CN1000Q Dual Port Converged Network Adapter(0x103C-0x3347)"},
{0x1077, 0x8022, 0x1077, 0x0212, "QME8242-k 10GbE Dual Port Mezzanine Card, iSCSI(0x1077-0x0212)"},
{0x1077, 0x8030, 0xFFFF, 0xFFFF, "ISP8324 1/10GbE Converged Network Controller(0x8030)"},
{0x1077, 0x8030, 0x1077, 0x0243, "8300 Series Single Port 10GbE Converged Network Adapter (TCP/IP Networking)(0x1077-0x0243)"},
{0x1077, 0x8030, 0x1077, 0x0246, "8300 Series Dual Port 10GbE Converged Network Adapter (TCP/IP Networking)(0x1077-0x0246)"},
{0x1077, 0x8031, 0xFFFF, 0xFFFF, "8300 Series 10GbE Converged Network Adapter (FCoE)(0x8031)"},
{0x1077, 0x8032, 0xFFFF, 0xFFFF, "8300 Series 10GbE Converged Network Adapter (iSCSI)(0x8032)"},
{0x1077, 0x8070, 0xFFFF, 0xFFFF, "FastLinQ QL41000 Series 10/25/40/50GbE Controller(0x8070)"},
{0x1077, 0x8070, 0x1077, 0x0001, "10GE 2P QL41162HxRJ-DE Adapter(0x1077-0x0001)"},
{0x1077, 0x8070, 0x1077, 0x0002, "10GE 2P QL41112HxCU-DE Adapter(0x1077-0x0002)"},
{0x1077, 0x8070, 0x1077, 0x0004, "4x10GE QL41164HFCU CNA(0x1077-0x0004)"},
{0x1077, 0x8070, 0x1077, 0x0005, "QLogic 4x10GE QL41164HMRJ CNA(0x1077-0x0005)"},
{0x1077, 0x8070, 0x1077, 0x0006, "QLogic 4x10GE QL41164HMCU CNA(0x1077-0x0006)"},
{0x1077, 0x8070, 0x1077, 0x0007, "QLogic 2x1GE+2x10GE QL41264HMCU CNA(0x1077-0x0007)"},
{0x1077, 0x8070, 0x1077, 0x0009, "QLogic 2x1GE+2x10GE QL41162HMRJ CNA(0x1077-0x0009)"},
{0x1077, 0x8070, 0x1077, 0x000B, "25GE 2P QL41262HxCU-DE Adapter(0x1077-0x000B)"},
{0x1077, 0x8070, 0x1077, 0x000F, "2x25GE QL41262HMKR CNA(0x1077-0x000F)"},
{0x1077, 0x8070, 0x1077, 0x0010, "2x25GE QL41232HMKR NIC(0x1077-0x0010)"},
{0x1077, 0x8070, 0x1077, 0x0011, "FastLinQ QL41212HLCU 25GbE Adapter(0x1077-0x0011)"},
{0x1077, 0x8070, 0x1077, 0x0012, "FastLinQ QL41112H 10GbE Adapter(0x1077-0x0012)"},
{0x1077, 0x8070, 0x1077, 0x0019, "QL41232HOCU - Dual Port 25/10GbE SFP28 OCP Adapter(0x1077-0x0019)"},
{0x1077, 0x8070, 0x1077, 0x0039, "QLogic QL41262 PCIe 25Gb 2-Port SFP28 Ethernet Adapter(0x1077-0x0039)"},
{0x1077, 0x8070, 0x1077, 0x0053, "QLogic 2x25GE QL41232HQCU NIC(0x1077-0x0053)"},
{0x1077, 0x8070, 0x1077, 0x0054, "2x10GE QL41132HQRJ NIC(0x1077-0x0054)"},
{0x1077, 0x8070, 0x1077, 0x0055, "QLogic 2x10GE QL41132HQCU NIC(0x1077-0x0055)"},
{0x1077, 0x8070, 0x1077, 0x0056, "2x10GE QL41132HxRJ NIC(0x1077-0x0056)"},
{0x1077, 0x8070, 0x1077, 0x0057, "2x25GE QL41232HxCU NIC(0x1077-0x0057)"},
{0x1077, 0x8070, 0x1077, 0x0065, "QLogic 4x10GE QL41154HQRJ CNA(0x1077-0x0065)"},
{0x1077, 0x8070, 0x1077, 0x0066, "QLogic 4x10GE QL41154HQCU CNA(0x1077-0x0066)"},
{0x1077, 0x8070, 0x1077, 0x0068, "10GbE 2p SFP+ QL41132HLCU-HC Adapter(0x1077-0x0068)"},
{0x1077, 0x8070, 0x1077, 0x0069, "10GbE 2p BASE-T QL41132HQRJ-HC OCP3 Adapter(0x1077-0x0069)"},
{0x1077, 0x8070, 0x1077, 0x0070, "10GbE 2p BASE-T QL41132HLRJ-HC Adapter(0x1077-0x0070)"},
{0x1077, 0x8070, 0x1077, 0x0071, "10GbE 2p SFP+ QL41132HQCU-HC OCP3 Adapter(0x1077-0x0071)"},
{0x1077, 0x8070, 0x1077, 0x0072, "10GbE 4p SFP+ QL41134HLCU-HC Adapter(0x1077-0x0072)"},
{0x1077, 0x8070, 0x1077, 0x0073, "10/25GbE 2p SFP28 QL41232HQCU-HC OCP3 Adapter(0x1077-0x0073)"},
{0x1077, 0x8070, 0x1077, 0x0074, "10/25GbE 2p SFP28 QL41232HLCU-HC Adapter(0x1077-0x0074)"},
{0x1077, 0x8070, 0x1590, 0x021A, "10GbE 2P QL41162HLRJ-HP Adapter(0x1590-0x021A)"},
{0x1077, 0x8070, 0x1590, 0x021B, "10GbE 2P QL41162HLRJ-HP Adapter(0x1590-0x021B)"},
{0x1077, 0x8070, 0x1590, 0x021D, "10/25GbE 2P QL41222HLCU-HP Adapter(0x1590-0x021D)"},
{0x1077, 0x8070, 0x1590, 0x021E, "10/25GbE 2P QL41162HMRJ-HP Adapter(0x1590-0x021E)"},
{0x1077, 0x8070, 0x1590, 0x021F, "10/25GbE 2P QL41262HMCU-HP Adapter(0x1590-0x021F)"},
{0x1077, 0x8070, 0x1590, 0x0220, "10/25GbE 2P QL41122HLRJ-HP Adapter(0x1590-0x0220)"},
{0x1077, 0x8070, 0x1590, 0x02BD, "10Gb 2P 524SFP+ NIC(0x1590-0x02BD)"},
{0x1077, 0x8070, 0x193D, 0x1030, "NIC-ETH681i-Mb-2x25G(0x193D-0x1030)"},
{0x1077, 0x8070, 0x193D, 0x1032, "NIC-ETH682i-Mb-2x25G(0x193D-0x1032)"},
{0x1077, 0x8080, 0xFFFF, 0xFFFF, "FastLinQ QL41000 Series 10/25/40/50GbE Controller (FCoE)(0x8080)"},
{0x1077, 0x8080, 0x1077, 0x0001, "10GE 2P QL41162HxRJ-DE Adapter(0x1077-0x0001)"},
{0x1077, 0x8080, 0x1077, 0x0002, "10GE 2P QL41112HxCU-DE Adapter(0x1077-0x0002)"},
{0x1077, 0x8080, 0x1077, 0x0004, "4x10GE QL41164HFCU CNA(0x1077-0x0004)"},
{0x1077, 0x8080, 0x1077, 0x0005, "QLogic 4x10GE QL41164HMRJ CNA(0x1077-0x0005)"},
{0x1077, 0x8080, 0x1077, 0x0006, "QLogic 4x10GE QL41164HMCU CNA(0x1077-0x0006)"},
{0x1077, 0x8080, 0x1077, 0x0007, "QLogic 2x1GE+2x10GE QL41264HMCU CNA(0x1077-0x0007)"},
{0x1077, 0x8080, 0x1077, 0x0009, "QLogic 2x1GE+2x10GE QL41162HMRJ CNA(0x1077-0x0009)"},
{0x1077, 0x8080, 0x1077, 0x000B, "25GE 2P QL41262HxCU-DE Adapter(0x1077-0x000B)"},
{0x1077, 0x8080, 0x1077, 0x000C, "QLogic 2x25GE QL41262HMCU CNA(0x1077-0x000C)"},
{0x1077, 0x8080, 0x1077, 0x000D, "FastLinQ QL41262H 25GbE FCoE Adapter(0x1077-0x000D)"},
{0x1077, 0x8080, 0x1077, 0x000E, "FastLinQ QL41162H 10GbE FCoE Adapter(0x1077-0x000E)"},
{0x1077, 0x8080, 0x1077, 0x000F, "2x25GE QL41262HMKR CNA(0x1077-0x000F)"},
{0x1077, 0x8080, 0x1590, 0x021A, "10GbE 2P QL41162HLRJ-HP Adapter(0x1590-0x021A)"},
{0x1077, 0x8080, 0x1590, 0x021B, "10GbE 2P QL41162HLRJ-HP Adapter(0x1590-0x021B)"},
{0x1077, 0x8084, 0xFFFF, 0xFFFF, "FastLinQ QL41000 Series 10/25/40/50GbE Controller (iSCSI)(0x8084)"},
{0x1077, 0x8084, 0x1077, 0x0001, "10GE 2P QL41162HxRJ-DE Adapter(0x1077-0x0001)"},
{0x1077, 0x8084, 0x1077, 0x0002, "10GE 2P QL41112HxCU-DE Adapter(0x1077-0x0002)"},
{0x1077, 0x8084, 0x1077, 0x0003, "4x10GE QL41164HxRJ CNA(0x1077-0x0003)"},
{0x1077, 0x8084, 0x1077, 0x0004, "4x10GE QL41164HFCU CNA(0x1077-0x0004)"},
{0x1077, 0x8084, 0x1077, 0x0005, "QLogic 4x10GE QL41164HMRJ CNA(0x1077-0x0005)"},
{0x1077, 0x8084, 0x1077, 0x0006, "QLogic 4x10GE QL41164HMCU CNA(0x1077-0x0006)"},
{0x1077, 0x8084, 0x1077, 0x0007, "QLogic 2x25GE QL41262HMCU CNA(0x1077-0x0007)"},
{0x1077, 0x8084, 0x1077, 0x0009, "QLogic 2x1GE+2x10GE QL41162HMRJ CNA(0x1077-0x0009)"},
{0x1077, 0x8084, 0x1077, 0x000B, "25GE 2P QL41262HxCU-DE Adapter(0x1077-0x000B)"},
{0x1077, 0x8084, 0x1077, 0x000C, "QLogic 2x25GE QL41262HMCU CNA(0x1077-0x000C)"},
{0x1077, 0x8084, 0x1077, 0x000D, "FastLinQ QL41262H 25GbE iSCSI Adapter(0x1077-0x000D)"},
{0x1077, 0x8084, 0x1077, 0x000E, "FastLinQ QL41162H 10GbE iSCSI Adapter(0x1077-0x000E)"},
{0x1077, 0x8084, 0x1077, 0x000F, "2x25GE QL41262HMKR CNA(0x1077-0x000F)"},
{0x1077, 0x8084, 0x1077, 0x0065, "QLogic 4x10GE QL41154HQRJ CNA(0x1077-0x0065)"},
{0x1077, 0x8084, 0x1077, 0x0066, "QLogic 4x10GE QL41154HQCU CNA(0x1077-0x0066)"},
{0x1077, 0x8084, 0x1590, 0x021A, "10GbE 2P QL41162HLRJ-HP Adapter(0x1590-0x021A)"},
{0x1077, 0x8084, 0x1590, 0x021B, "10GbE 2P QL41162HLRJ-HP Adapter(0x1590-0x021B)"},
{0x1077, 0x8090, 0xFFFF, 0xFFFF, "FastLinQ QL41000 Series Gigabit Ethernet Controller (SR-IOV VF)(0x8090)"},
{0x1077, 0x8090, 0x1077, 0x0001, "25GE 2P QL41262HxCU-DE Adapter(0x1077-0x0001)"},
{0x1077, 0x8090, 0x1077, 0x0002, "10GE 2P QL41112HxCU-DE Adapter(0x1077-0x0002)"},
{0x1077, 0x8090, 0x1077, 0x0003, "4x10GE QL41164HxRJ CNA(0x1077-0x0003)"},
{0x1077, 0x8090, 0x1077, 0x0004, "4x10GE QL41164HFCU CNA(0x1077-0x0004)"},
{0x1077, 0x8090, 0x1077, 0x0005, "QLogic 4x10GE QL41164HMRJ CNA(0x1077-0x0005)"},
{0x1077, 0x8090, 0x1077, 0x0006, "QLogic 4x10GE QL41164HMCU CNA(0x1077-0x0006)"},
{0x1077, 0x8090, 0x1077, 0x0007, "QLogic 2x1GE+2x10GE QL41264HMCU CNA(0x1077-0x0007)"},
{0x1077, 0x8090, 0x1077, 0x0009, "QLogic 2x1GE+2x10GE QL41162HMRJ CNA(0x1077-0x0009)"},
{0x1077, 0x8090, 0x1077, 0x000B, "25GE 2P QL41262HxCU-DE Adapter(0x1077-0x000B)"},
{0x1077, 0x8090, 0x1077, 0x000C, "QLogic 2x25GE QL41262HMCU CNA(0x1077-0x000C)"},
{0x1077, 0x8090, 0x1077, 0x000D, "FastLinQ QL41262H 25GbE FCoE Adapter (SR-IOV VF)(0x1077-0x000D)"},
{0x1077, 0x8090, 0x1077, 0x000E, "FastLinQ QL41162H 10GbE iSCSI Adapter (SR-IOV VF)(0x1077-0x000E)"},
{0x1077, 0x8090, 0x1077, 0x000F, "2x25GE QL41262HMKR CNA(0x1077-0x000F)"},
{0x1077, 0x8090, 0x1077, 0x0010, "2x25GE QL41232HMKR NIC(0x1077-0x0010)"},
{0x1077, 0x8090, 0x1077, 0x0011, "FastLinQ QL41212H 25GbE Adapter (SR-IOV VF)(0x1077-0x0011)"},
{0x1077, 0x8090, 0x1077, 0x0012, "FastLinQ QL41112H 10GbE Adapter (SR-IOV VF)(0x1077-0x0012)"},
{0x1077, 0x8090, 0x1077, 0x0053, "QLogic 2x25GE QL41232HQCU NIC(0x1077-0x0053)"},
{0x1077, 0x8090, 0x1077, 0x0054, "QLogic 2x10GE QL41132HQRJ NIC(0x1077-0x0054)"},
{0x1077, 0x8090, 0x1077, 0x0055, "QLogic 2x10GE QL41132HQCU NIC(0x1077-0x0055)"},
{0x1077, 0x8090, 0x1077, 0x0056, "2x10GE QL41132HxRJ NIC(0x1077-0x0056)"},
{0x1077, 0x8090, 0x1077, 0x0057, "2x25GE QL41232HxCU NIC(0x1077-0x0057)"},
{0x1077, 0x8090, 0x1077, 0x0065, "QLogic 4x10GE QL41154HQRJ CNA(0x1077-0x0065)"},
{0x1077, 0x8090, 0x1077, 0x0066, "QLogic 4x10GE QL41154HQCU CNA(0x1077-0x0066)"},
{0x1077, 0x8090, 0x1590, 0x021A, "10GbE 2P QL41162HLRJ-HP Adapter(0x1590-0x021A)"},
{0x1077, 0x8090, 0x1590, 0x021B, "10GbE 2P QL41162HLRJ-HP Adapter(0x1590-0x021B)"},
{0x1077, 0x8090, 0x1590, 0x021E, "10/25GbE 2P QL41162HMRJ-HP Adapter(0x1590-0x021E)"},
{0x1077, 0x8090, 0x1590, 0x021F, "10/25GbE 2P QL41262HMCU-HP Adapter(0x1590-0x021F)"},
{0x1077, 0x8090, 0x1590, 0x02BD, "10Gb 2P 524SFP+ NIC(0x1590-0x02BD)"},
{0x1077, 0x8430, 0xFFFF, 0xFFFF, "ISP8324 1/10GbE Converged Network Controller (NIC VF)(0x8430)"},
{0x1077, 0x8431, 0xFFFF, 0xFFFF, "8300 Series 10GbE Converged Network Adapter (FCoE VF)(0x8431)"},
{0x1077, 0x8432, 0xFFFF, 0xFFFF, "ISP2432M-based 10GbE Converged Network Adapter (CNA)(0x8432)"},
}; /* pci_vid_1077[] */

static pci_id_t const pci_vid_1078[] = {
{0x1078, 0xFFFF, 0xFFFF, 0xFFFF, "Cyrix Corporation(0x1078)"},
{0x1078, 0x0000, 0xFFFF, 0xFFFF, "5510 [Grappa](0x0000)"},
{0x1078, 0x0001, 0xFFFF, 0xFFFF, "PCI Master(0x0001)"},
{0x1078, 0x0002, 0xFFFF, 0xFFFF, "5520 [Cognac](0x0002)"},
{0x1078, 0x0100, 0xFFFF, 0xFFFF, "5530 Legacy [Kahlua](0x0100)"},
{0x1078, 0x0101, 0xFFFF, 0xFFFF, "5530 SMI [Kahlua](0x0101)"},
{0x1078, 0x0102, 0xFFFF, 0xFFFF, "5530 IDE [Kahlua](0x0102)"},
{0x1078, 0x0103, 0xFFFF, 0xFFFF, "5530 Audio [Kahlua](0x0103)"},
{0x1078, 0x0104, 0xFFFF, 0xFFFF, "5530 Video [Kahlua](0x0104)"},
{0x1078, 0x0400, 0xFFFF, 0xFFFF, "ZFMicro PCI Bridge(0x0400)"},
{0x1078, 0x0401, 0xFFFF, 0xFFFF, "ZFMicro Chipset SMI(0x0401)"},
{0x1078, 0x0402, 0xFFFF, 0xFFFF, "ZFMicro Chipset IDE(0x0402)"},
{0x1078, 0x0403, 0xFFFF, 0xFFFF, "ZFMicro Expansion Bus(0x0403)"},
}; /* pci_vid_1078[] */

static pci_id_t const pci_vid_1079[] = {
{0x1079, 0xFFFF, 0xFFFF, 0xFFFF, "I-Bus(0x1079)"},
}; /* pci_vid_1079[] */

static pci_id_t const pci_vid_107A[] = {
{0x107A, 0xFFFF, 0xFFFF, 0xFFFF, "NetWorth(0x107A)"},
}; /* pci_vid_107A[] */

static pci_id_t const pci_vid_107B[] = {
{0x107B, 0xFFFF, 0xFFFF, 0xFFFF, "Gateway, Inc.(0x107B)"},
}; /* pci_vid_107B[] */

static pci_id_t const pci_vid_107C[] = {
{0x107C, 0xFFFF, 0xFFFF, 0xFFFF, "LG Electronics [Lucky Goldstar Co. Ltd](0x107C)"},
}; /* pci_vid_107C[] */

static pci_id_t const pci_vid_107D[] = {
{0x107D, 0xFFFF, 0xFFFF, 0xFFFF, "LeadTek Research Inc.(0x107D)"},
{0x107D, 0x0000, 0xFFFF, 0xFFFF, "P86C850(0x0000)"},
}; /* pci_vid_107D[] */

static pci_id_t const pci_vid_107E[] = {
{0x107E, 0xFFFF, 0xFFFF, 0xFFFF, "Interphase Corporation(0x107E)"},
{0x107E, 0x0001, 0xFFFF, 0xFFFF, "5515 ATM Adapter [Flipper](0x0001)"},
{0x107E, 0x0002, 0xFFFF, 0xFFFF, "100 VG AnyLan Controller(0x0002)"},
{0x107E, 0x0004, 0xFFFF, 0xFFFF, "5526 Fibre Channel Host Adapter(0x0004)"},
{0x107E, 0x0005, 0xFFFF, 0xFFFF, "x526 Fibre Channel Host Adapter(0x0005)"},
{0x107E, 0x0008, 0xFFFF, 0xFFFF, "5525/5575 ATM Adapter (155 Mbit) [Atlantic](0x0008)"},
{0x107E, 0x9003, 0xFFFF, 0xFFFF, "5535-4P-BRI-ST(0x9003)"},
{0x107E, 0x9007, 0xFFFF, 0xFFFF, "5535-4P-BRI-U(0x9007)"},
{0x107E, 0x9008, 0xFFFF, 0xFFFF, "5535-1P-SR(0x9008)"},
{0x107E, 0x900C, 0xFFFF, 0xFFFF, "5535-1P-SR-ST(0x900C)"},
{0x107E, 0x900E, 0xFFFF, 0xFFFF, "5535-1P-SR-U(0x900E)"},
{0x107E, 0x9011, 0xFFFF, 0xFFFF, "5535-1P-PRI(0x9011)"},
{0x107E, 0x9013, 0xFFFF, 0xFFFF, "5535-2P-PRI(0x9013)"},
{0x107E, 0x9023, 0xFFFF, 0xFFFF, "5536-4P-BRI-ST(0x9023)"},
{0x107E, 0x9027, 0xFFFF, 0xFFFF, "5536-4P-BRI-U(0x9027)"},
{0x107E, 0x9031, 0xFFFF, 0xFFFF, "5536-1P-PRI(0x9031)"},
{0x107E, 0x9033, 0xFFFF, 0xFFFF, "5536-2P-PRI(0x9033)"},
}; /* pci_vid_107E[] */

static pci_id_t const pci_vid_107F[] = {
{0x107F, 0xFFFF, 0xFFFF, 0xFFFF, "Data Technology Corporation(0x107F)"},
{0x107F, 0x0802, 0xFFFF, 0xFFFF, "SL82C105(0x0802)"},
}; /* pci_vid_107F[] */

static pci_id_t const pci_vid_1080[] = {
{0x1080, 0xFFFF, 0xFFFF, 0xFFFF, "Contaq Microsystems(0x1080)"},
{0x1080, 0x0600, 0xFFFF, 0xFFFF, "82C599(0x0600)"},
{0x1080, 0xC691, 0xFFFF, 0xFFFF, "Cypress CY82C691(0xC691)"},
{0x1080, 0xC693, 0xFFFF, 0xFFFF, "82c693(0xC693)"},
}; /* pci_vid_1080[] */

static pci_id_t const pci_vid_1081[] = {
{0x1081, 0xFFFF, 0xFFFF, 0xFFFF, "Supermac Technology(0x1081)"},
{0x1081, 0x0D47, 0xFFFF, 0xFFFF, "Radius PCI to NuBUS Bridge(0x0D47)"},
}; /* pci_vid_1081[] */

static pci_id_t const pci_vid_1082[] = {
{0x1082, 0xFFFF, 0xFFFF, 0xFFFF, "EFA Corporation of America(0x1082)"},
}; /* pci_vid_1082[] */

static pci_id_t const pci_vid_1083[] = {
{0x1083, 0xFFFF, 0xFFFF, 0xFFFF, "Forex Computer Corporation(0x1083)"},
{0x1083, 0x0001, 0xFFFF, 0xFFFF, "FR710(0x0001)"},
}; /* pci_vid_1083[] */

static pci_id_t const pci_vid_1084[] = {
{0x1084, 0xFFFF, 0xFFFF, 0xFFFF, "Parador(0x1084)"},
}; /* pci_vid_1084[] */

static pci_id_t const pci_vid_1086[] = {
{0x1086, 0xFFFF, 0xFFFF, 0xFFFF, "J. Bond Computer Systems(0x1086)"},
}; /* pci_vid_1086[] */

static pci_id_t const pci_vid_1087[] = {
{0x1087, 0xFFFF, 0xFFFF, 0xFFFF, "Cache Computer(0x1087)"},
}; /* pci_vid_1087[] */

static pci_id_t const pci_vid_1088[] = {
{0x1088, 0xFFFF, 0xFFFF, 0xFFFF, "Microcomputer Systems (M) Son(0x1088)"},
}; /* pci_vid_1088[] */

static pci_id_t const pci_vid_1089[] = {
{0x1089, 0xFFFF, 0xFFFF, 0xFFFF, "Data General Corporation(0x1089)"},
}; /* pci_vid_1089[] */

static pci_id_t const pci_vid_108A[] = {
{0x108A, 0xFFFF, 0xFFFF, 0xFFFF, "SBS Technologies(0x108A)"},
{0x108A, 0x0001, 0xFFFF, 0xFFFF, "VME Bridge Model 617(0x0001)"},
{0x108A, 0x0010, 0xFFFF, 0xFFFF, "VME Bridge Model 618(0x0010)"},
{0x108A, 0x0040, 0xFFFF, 0xFFFF, "dataBLIZZARD(0x0040)"},
{0x108A, 0x3000, 0xFFFF, 0xFFFF, "VME Bridge Model 2706(0x3000)"},
}; /* pci_vid_108A[] */

static pci_id_t const pci_vid_108C[] = {
{0x108C, 0xFFFF, 0xFFFF, 0xFFFF, "Oakleigh Systems Inc.(0x108C)"},
}; /* pci_vid_108C[] */

static pci_id_t const pci_vid_108D[] = {
{0x108D, 0xFFFF, 0xFFFF, 0xFFFF, "Olicom(0x108D)"},
{0x108D, 0x0001, 0xFFFF, 0xFFFF, "Token-Ring 16/4 PCI Adapter (3136/3137)(0x0001)"},
{0x108D, 0x0002, 0xFFFF, 0xFFFF, "16/4 Token Ring(0x0002)"},
{0x108D, 0x0004, 0xFFFF, 0xFFFF, "RapidFire OC-3139/3140 Token-Ring 16/4 PCI Adapter(0x0004)"},
{0x108D, 0x0004, 0x108D, 0x0004, "OC-3139/3140 RapidFire Token-Ring 16/4 Adapter(0x108D-0x0004)"},
{0x108D, 0x0005, 0xFFFF, 0xFFFF, "GoCard 3250 Token-Ring 16/4 CardBus PC Card(0x0005)"},
{0x108D, 0x0006, 0xFFFF, 0xFFFF, "OC-3530 RapidFire Token-Ring 100(0x0006)"},
{0x108D, 0x0007, 0xFFFF, 0xFFFF, "RapidFire 3141 Token-Ring 16/4 PCI Fiber Adapter(0x0007)"},
{0x108D, 0x0007, 0x108D, 0x0007, "OC-3141 RapidFire Token-Ring 16/4 Adapter(0x108D-0x0007)"},
{0x108D, 0x0008, 0xFFFF, 0xFFFF, "RapidFire 3540 HSTR 100/16/4 PCI Adapter(0x0008)"},
{0x108D, 0x0008, 0x108D, 0x0008, "OC-3540 RapidFire HSTR 100/16/4 Adapter(0x108D-0x0008)"},
{0x108D, 0x0011, 0xFFFF, 0xFFFF, "OC-2315(0x0011)"},
{0x108D, 0x0012, 0xFFFF, 0xFFFF, "OC-2325(0x0012)"},
{0x108D, 0x0013, 0xFFFF, 0xFFFF, "OC-2183/2185(0x0013)"},
{0x108D, 0x0014, 0xFFFF, 0xFFFF, "OC-2326(0x0014)"},
{0x108D, 0x0019, 0xFFFF, 0xFFFF, "OC-2327/2250 10/100 Ethernet Adapter(0x0019)"},
{0x108D, 0x0019, 0x108D, 0x0016, "OC-2327 Rapidfire 10/100 Ethernet Adapter(0x108D-0x0016)"},
{0x108D, 0x0019, 0x108D, 0x0017, "OC-2250 GoCard 10/100 Ethernet Adapter(0x108D-0x0017)"},
{0x108D, 0x0021, 0xFFFF, 0xFFFF, "OC-6151/6152 [RapidFire ATM 155](0x0021)"},
{0x108D, 0x0022, 0xFFFF, 0xFFFF, "ATM Adapter(0x0022)"},
}; /* pci_vid_108D[] */

static pci_id_t const pci_vid_108E[] = {
{0x108E, 0xFFFF, 0xFFFF, 0xFFFF, "Oracle/SUN(0x108E)"},
{0x108E, 0x0001, 0xFFFF, 0xFFFF, "EBUS(0x0001)"},
{0x108E, 0x1000, 0xFFFF, 0xFFFF, "STP2003QFP [PCIO] EBUS(0x1000)"},
{0x108E, 0x1001, 0xFFFF, 0xFFFF, "Happy Meal 10/100 Ethernet [hme](0x1001)"},
{0x108E, 0x1100, 0xFFFF, 0xFFFF, "RIO EBUS(0x1100)"},
{0x108E, 0x1100, 0x108E, 0x1100, "RIO EBUS on Blade 100 motherboard(0x108E-0x1100)"},
{0x108E, 0x1101, 0xFFFF, 0xFFFF, "RIO 10/100 Ethernet [eri](0x1101)"},
{0x108E, 0x1101, 0x108E, 0x1101, "RIO GEM on Blade 100 motherboard(0x108E-0x1101)"},
{0x108E, 0x1102, 0xFFFF, 0xFFFF, "RIO 1394(0x1102)"},
{0x108E, 0x1102, 0x108E, 0x1102, "RIO 1394 on Blade 100 motherboard(0x108E-0x1102)"},
{0x108E, 0x1103, 0xFFFF, 0xFFFF, "RIO USB(0x1103)"},
{0x108E, 0x1103, 0x108E, 0x1103, "RIO USB on Blade 100 motherboard(0x108E-0x1103)"},
{0x108E, 0x1647, 0xFFFF, 0xFFFF, "Broadcom 570x 10/100/1000 Ethernet [bge](0x1647)"},
{0x108E, 0x1648, 0xFFFF, 0xFFFF, "Broadcom 570x 10/100/1000 Ethernet [bge](0x1648)"},
{0x108E, 0x16A7, 0xFFFF, 0xFFFF, "Broadcom 570x 10/100/1000 Ethernet [bge](0x16A7)"},
{0x108E, 0x16A8, 0xFFFF, 0xFFFF, "Broadcom 570x 10/100/1000 Ethernet [bge](0x16A8)"},
{0x108E, 0x2BAD, 0xFFFF, 0xFFFF, "GEM 10/100/1000 Ethernet [ge](0x2BAD)"},
{0x108E, 0x5000, 0xFFFF, 0xFFFF, "Simba Advanced PCI Bridge(0x5000)"},
{0x108E, 0x5000, 0x108E, 0x5000, "Netra AX1105-500(0x108E-0x5000)"},
{0x108E, 0x5043, 0xFFFF, 0xFFFF, "SunPCI Co-processor(0x5043)"},
{0x108E, 0x5CA0, 0xFFFF, 0xFFFF, "Crypto Accelerator 6000 [mca](0x5CA0)"},
{0x108E, 0x6300, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6300)"},
{0x108E, 0x6301, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6301)"},
{0x108E, 0x6302, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6302)"},
{0x108E, 0x6303, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6303)"},
{0x108E, 0x6310, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6310)"},
{0x108E, 0x6311, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6311)"},
{0x108E, 0x6312, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6312)"},
{0x108E, 0x6313, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6313)"},
{0x108E, 0x6320, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6320)"},
{0x108E, 0x6323, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6323)"},
{0x108E, 0x6330, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6330)"},
{0x108E, 0x6331, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6331)"},
{0x108E, 0x6332, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6332)"},
{0x108E, 0x6333, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6333)"},
{0x108E, 0x6340, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6340)"},
{0x108E, 0x6343, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6343)"},
{0x108E, 0x6350, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6350)"},
{0x108E, 0x6353, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6353)"},
{0x108E, 0x6722, 0xFFFF, 0xFFFF, "Intel 21554 PCI-PCI bus bridge [db21554](0x6722)"},
{0x108E, 0x676E, 0xFFFF, 0xFFFF, "SunPCiIII(0x676E)"},
{0x108E, 0x7063, 0xFFFF, 0xFFFF, "SunPCiII / SunPCiIIpro(0x7063)"},
{0x108E, 0x8000, 0xFFFF, 0xFFFF, "Psycho PCI Bus Module(0x8000)"},
{0x108E, 0x8001, 0xFFFF, 0xFFFF, "Schizo PCI Bus Module(0x8001)"},
{0x108E, 0x8002, 0xFFFF, 0xFFFF, "Schizo+ PCI Bus Module(0x8002)"},
{0x108E, 0x80F0, 0xFFFF, 0xFFFF, "PCIe switch [px](0x80F0)"},
{0x108E, 0x80F8, 0xFFFF, 0xFFFF, "PCIe switch [px](0x80F8)"},
{0x108E, 0x9010, 0xFFFF, 0xFFFF, "PCIe/PCI bridge switch [pxb_plx](0x9010)"},
{0x108E, 0x9020, 0xFFFF, 0xFFFF, "PCIe/PCI bridge switch [pxb_plx](0x9020)"},
{0x108E, 0x9102, 0xFFFF, 0xFFFF, "Davicom Fast Ethernet driver for Davicom DM9102A [dmfe](0x9102)"},
{0x108E, 0xA000, 0xFFFF, 0xFFFF, "Psycho UPA-PCI Bus Module [pcipsy](0xA000)"},
{0x108E, 0xA001, 0xFFFF, 0xFFFF, "Psycho UPA-PCI Bus Module [pcipsy](0xA001)"},
{0x108E, 0xA001, 0x108E, 0xA001, "Ultra IIe on Blade 100 motherboard(0x108E-0xA001)"},
{0x108E, 0xA801, 0xFFFF, 0xFFFF, "Schizo Fireplane-PCI bus bridge module [pcisch](0xA801)"},
{0x108E, 0xAAAA, 0xFFFF, 0xFFFF, "Multithreaded Shared 10GbE Ethernet Network Controller(0xAAAA)"},
{0x108E, 0xABBA, 0xFFFF, 0xFFFF, "Cassini 10/100/1000(0xABBA)"},
{0x108E, 0xABCD, 0xFFFF, 0xFFFF, "Multithreaded 10-Gigabit Ethernet Network Controller(0xABCD)"},
{0x108E, 0xC416, 0xFFFF, 0xFFFF, "Sun Fire System/System Controller Interface chip [sbbc](0xC416)"},
}; /* pci_vid_108E[] */

static pci_id_t const pci_vid_108F[] = {
{0x108F, 0xFFFF, 0xFFFF, 0xFFFF, "Systemsoft(0x108F)"},
}; /* pci_vid_108F[] */

static pci_id_t const pci_vid_1090[] = {
{0x1090, 0xFFFF, 0xFFFF, 0xFFFF, "Compro Computer Services, Inc.(0x1090)"},
{0x1090, 0x4610, 0xFFFF, 0xFFFF, "PCI RTOM(0x4610)"},
{0x1090, 0x4620, 0xFFFF, 0xFFFF, "GPIO HSD(0x4620)"},
}; /* pci_vid_1090[] */

static pci_id_t const pci_vid_1091[] = {
{0x1091, 0xFFFF, 0xFFFF, 0xFFFF, "Intergraph Corporation(0x1091)"},
{0x1091, 0x0020, 0xFFFF, 0xFFFF, "3D graphics processor(0x0020)"},
{0x1091, 0x0021, 0xFFFF, 0xFFFF, "3D graphics processor w/Texturing(0x0021)"},
{0x1091, 0x0040, 0xFFFF, 0xFFFF, "3D graphics frame buffer(0x0040)"},
{0x1091, 0x0041, 0xFFFF, 0xFFFF, "3D graphics frame buffer(0x0041)"},
{0x1091, 0x0060, 0xFFFF, 0xFFFF, "Proprietary bus bridge(0x0060)"},
{0x1091, 0x00E4, 0xFFFF, 0xFFFF, "Powerstorm 4D50T(0x00E4)"},
{0x1091, 0x0720, 0xFFFF, 0xFFFF, "Motion JPEG codec(0x0720)"},
{0x1091, 0x0780, 0xFFFF, 0xFFFF, "Intense3D Wildcat 3410 (MSMT496)(0x0780)"},
{0x1091, 0x07A0, 0xFFFF, 0xFFFF, "Sun Expert3D-Lite Graphics Accelerator(0x07A0)"},
{0x1091, 0x1091, 0xFFFF, 0xFFFF, "Sun Expert3D Graphics Accelerator(0x1091)"},
}; /* pci_vid_1091[] */

static pci_id_t const pci_vid_1092[] = {
{0x1092, 0xFFFF, 0xFFFF, 0xFFFF, "Diamond Multimedia Systems(0x1092)"},
{0x1092, 0x0028, 0xFFFF, 0xFFFF, "Viper V770(0x0028)"},
{0x1092, 0x0028, 0x1092, 0x4A00, "Viper V770 32MB(0x1092-0x4A00)"},
{0x1092, 0x00A0, 0xFFFF, 0xFFFF, "Speedstar Pro SE(0x00A0)"},
{0x1092, 0x00A8, 0xFFFF, 0xFFFF, "Speedstar 64(0x00A8)"},
{0x1092, 0x0550, 0xFFFF, 0xFFFF, "Viper V550(0x0550)"},
{0x1092, 0x08D4, 0xFFFF, 0xFFFF, "Supra 2260 Modem(0x08D4)"},
{0x1092, 0x094C, 0xFFFF, 0xFFFF, "SupraExpress 56i Pro(0x094C)"},
{0x1092, 0x1001, 0xFFFF, 0xFFFF, "Video Crunch It 1001 capture card(0x1001)"},
{0x1092, 0x1092, 0xFFFF, 0xFFFF, "Viper V330(0x1092)"},
{0x1092, 0x6120, 0xFFFF, 0xFFFF, "Maximum DVD(0x6120)"},
{0x1092, 0x8810, 0xFFFF, 0xFFFF, "Stealth SE(0x8810)"},
{0x1092, 0x8811, 0xFFFF, 0xFFFF, "Stealth 64/SE(0x8811)"},
{0x1092, 0x8880, 0xFFFF, 0xFFFF, "Stealth(0x8880)"},
{0x1092, 0x8881, 0xFFFF, 0xFFFF, "Stealth(0x8881)"},
{0x1092, 0x88B0, 0xFFFF, 0xFFFF, "Stealth 64(0x88B0)"},
{0x1092, 0x88B1, 0xFFFF, 0xFFFF, "Stealth 64(0x88B1)"},
{0x1092, 0x88C0, 0xFFFF, 0xFFFF, "Stealth 64(0x88C0)"},
{0x1092, 0x88C1, 0xFFFF, 0xFFFF, "Stealth 64(0x88C1)"},
{0x1092, 0x88D0, 0xFFFF, 0xFFFF, "Stealth 64(0x88D0)"},
{0x1092, 0x88D1, 0xFFFF, 0xFFFF, "Stealth 64(0x88D1)"},
{0x1092, 0x88F0, 0xFFFF, 0xFFFF, "Stealth 64(0x88F0)"},
{0x1092, 0x88F1, 0xFFFF, 0xFFFF, "Stealth 64(0x88F1)"},
{0x1092, 0x9999, 0xFFFF, 0xFFFF, "DMD-I0928-1 \"Monster sound\" sound chip(0x9999)"},
}; /* pci_vid_1092[] */

static pci_id_t const pci_vid_1093[] = {
{0x1093, 0xFFFF, 0xFFFF, 0xFFFF, "National Instruments(0x1093)"},
{0x1093, 0x0160, 0xFFFF, 0xFFFF, "PCI-DIO-96(0x0160)"},
{0x1093, 0x0162, 0xFFFF, 0xFFFF, "PCI-MIO-16XE-50(0x0162)"},
{0x1093, 0x0FE1, 0xFFFF, 0xFFFF, "PXI-8320(0x0FE1)"},
{0x1093, 0x1150, 0xFFFF, 0xFFFF, "PCI-6533 (PCI-DIO-32HS)(0x1150)"},
{0x1093, 0x1170, 0xFFFF, 0xFFFF, "PCI-MIO-16XE-10(0x1170)"},
{0x1093, 0x1180, 0xFFFF, 0xFFFF, "PCI-MIO-16E-1(0x1180)"},
{0x1093, 0x1190, 0xFFFF, 0xFFFF, "PCI-MIO-16E-4(0x1190)"},
{0x1093, 0x11B0, 0xFFFF, 0xFFFF, "PXI-6070E(0x11B0)"},
{0x1093, 0x11C0, 0xFFFF, 0xFFFF, "PXI-6040E(0x11C0)"},
{0x1093, 0x11D0, 0xFFFF, 0xFFFF, "PXI-6030E(0x11D0)"},
{0x1093, 0x1270, 0xFFFF, 0xFFFF, "PCI-6032E(0x1270)"},
{0x1093, 0x1290, 0xFFFF, 0xFFFF, "PCI-6704(0x1290)"},
{0x1093, 0x12B0, 0xFFFF, 0xFFFF, "PCI-6534(0x12B0)"},
{0x1093, 0x1310, 0xFFFF, 0xFFFF, "PCI-6602(0x1310)"},
{0x1093, 0x1320, 0xFFFF, 0xFFFF, "PXI-6533(0x1320)"},
{0x1093, 0x1330, 0xFFFF, 0xFFFF, "PCI-6031E(0x1330)"},
{0x1093, 0x1340, 0xFFFF, 0xFFFF, "PCI-6033E(0x1340)"},
{0x1093, 0x1350, 0xFFFF, 0xFFFF, "PCI-6071E(0x1350)"},
{0x1093, 0x1360, 0xFFFF, 0xFFFF, "PXI-6602(0x1360)"},
{0x1093, 0x13C0, 0xFFFF, 0xFFFF, "PXI-6508(0x13C0)"},
{0x1093, 0x1490, 0xFFFF, 0xFFFF, "PXI-6534(0x1490)"},
{0x1093, 0x14E0, 0xFFFF, 0xFFFF, "PCI-6110(0x14E0)"},
{0x1093, 0x14F0, 0xFFFF, 0xFFFF, "PCI-6111(0x14F0)"},
{0x1093, 0x1580, 0xFFFF, 0xFFFF, "PXI-6031E(0x1580)"},
{0x1093, 0x15B0, 0xFFFF, 0xFFFF, "PXI-6071E(0x15B0)"},
{0x1093, 0x1710, 0xFFFF, 0xFFFF, "PXI-6509(0x1710)"},
{0x1093, 0x17C0, 0xFFFF, 0xFFFF, "PXI-5690(0x17C0)"},
{0x1093, 0x17D0, 0xFFFF, 0xFFFF, "PCI-6503(0x17D0)"},
{0x1093, 0x1870, 0xFFFF, 0xFFFF, "PCI-6713(0x1870)"},
{0x1093, 0x1880, 0xFFFF, 0xFFFF, "PCI-6711(0x1880)"},
{0x1093, 0x18B0, 0xFFFF, 0xFFFF, "PCI-6052E(0x18B0)"},
{0x1093, 0x18C0, 0xFFFF, 0xFFFF, "PXI-6052E(0x18C0)"},
{0x1093, 0x1920, 0xFFFF, 0xFFFF, "PXI-6704(0x1920)"},
{0x1093, 0x1930, 0xFFFF, 0xFFFF, "PCI-6040E(0x1930)"},
{0x1093, 0x19C0, 0xFFFF, 0xFFFF, "PCI-4472(0x19C0)"},
{0x1093, 0x1AA0, 0xFFFF, 0xFFFF, "PXI-4110(0x1AA0)"},
{0x1093, 0x1AD0, 0xFFFF, 0xFFFF, "PCI-6133(0x1AD0)"},
{0x1093, 0x1AE0, 0xFFFF, 0xFFFF, "PXI-6133(0x1AE0)"},
{0x1093, 0x1E30, 0xFFFF, 0xFFFF, "PCI-6624(0x1E30)"},
{0x1093, 0x1E40, 0xFFFF, 0xFFFF, "PXI-6624(0x1E40)"},
{0x1093, 0x1E50, 0xFFFF, 0xFFFF, "PXI-5404(0x1E50)"},
{0x1093, 0x2410, 0xFFFF, 0xFFFF, "PCI-6733(0x2410)"},
{0x1093, 0x2420, 0xFFFF, 0xFFFF, "PXI-6733(0x2420)"},
{0x1093, 0x2430, 0xFFFF, 0xFFFF, "PCI-6731(0x2430)"},
{0x1093, 0x2470, 0xFFFF, 0xFFFF, "PCI-4474(0x2470)"},
{0x1093, 0x24A0, 0xFFFF, 0xFFFF, "PCI-4065(0x24A0)"},
{0x1093, 0x24B0, 0xFFFF, 0xFFFF, "PXI-4200(0x24B0)"},
{0x1093, 0x24F0, 0xFFFF, 0xFFFF, "PXI-4472(0x24F0)"},
{0x1093, 0x2510, 0xFFFF, 0xFFFF, "PCI-4472(0x2510)"},
{0x1093, 0x2520, 0xFFFF, 0xFFFF, "PCI-4474(0x2520)"},
{0x1093, 0x27A0, 0xFFFF, 0xFFFF, "PCI-6123(0x27A0)"},
{0x1093, 0x27B0, 0xFFFF, 0xFFFF, "PXI-6123(0x27B0)"},
{0x1093, 0x2880, 0xFFFF, 0xFFFF, "DAQCard-6601(0x2880)"},
{0x1093, 0x2890, 0xFFFF, 0xFFFF, "PCI-6036E(0x2890)"},
{0x1093, 0x28A0, 0xFFFF, 0xFFFF, "PXI-4461(0x28A0)"},
{0x1093, 0x28B0, 0xFFFF, 0xFFFF, "PCI-6013(0x28B0)"},
{0x1093, 0x28C0, 0xFFFF, 0xFFFF, "PCI-6014(0x28C0)"},
{0x1093, 0x28D0, 0xFFFF, 0xFFFF, "PCI-5122(0x28D0)"},
{0x1093, 0x28E0, 0xFFFF, 0xFFFF, "PXI-5122(0x28E0)"},
{0x1093, 0x29F0, 0xFFFF, 0xFFFF, "PXI-7334(0x29F0)"},
{0x1093, 0x2A00, 0xFFFF, 0xFFFF, "PXI-7344(0x2A00)"},
{0x1093, 0x2A60, 0xFFFF, 0xFFFF, "PCI-6023E(0x2A60)"},
{0x1093, 0x2A70, 0xFFFF, 0xFFFF, "PCI-6024E(0x2A70)"},
{0x1093, 0x2A80, 0xFFFF, 0xFFFF, "PCI-6025E(0x2A80)"},
{0x1093, 0x2AB0, 0xFFFF, 0xFFFF, "PXI-6025E(0x2AB0)"},
{0x1093, 0x2B10, 0xFFFF, 0xFFFF, "PXI-6527(0x2B10)"},
{0x1093, 0x2B20, 0xFFFF, 0xFFFF, "PCI-6527(0x2B20)"},
{0x1093, 0x2B80, 0xFFFF, 0xFFFF, "PXI-6713(0x2B80)"},
{0x1093, 0x2B90, 0xFFFF, 0xFFFF, "PXI-6711(0x2B90)"},
{0x1093, 0x2C60, 0xFFFF, 0xFFFF, "PCI-6601(0x2C60)"},
{0x1093, 0x2C70, 0xFFFF, 0xFFFF, "PXI-6601(0x2C70)"},
{0x1093, 0x2C80, 0xFFFF, 0xFFFF, "PCI-6035E(0x2C80)"},
{0x1093, 0x2C90, 0xFFFF, 0xFFFF, "PCI-6703(0x2C90)"},
{0x1093, 0x2CA0, 0xFFFF, 0xFFFF, "PCI-6034E(0x2CA0)"},
{0x1093, 0x2CB0, 0xFFFF, 0xFFFF, "PCI-7344(0x2CB0)"},
{0x1093, 0x2CC0, 0xFFFF, 0xFFFF, "PXI-6608(0x2CC0)"},
{0x1093, 0x2D20, 0xFFFF, 0xFFFF, "PXI-5600(0x2D20)"},
{0x1093, 0x2DB0, 0xFFFF, 0xFFFF, "PCI-6608(0x2DB0)"},
{0x1093, 0x2DC0, 0xFFFF, 0xFFFF, "PCI-4070(0x2DC0)"},
{0x1093, 0x2DD0, 0xFFFF, 0xFFFF, "PXI-4070(0x2DD0)"},
{0x1093, 0x2EB0, 0xFFFF, 0xFFFF, "PXI-4472(0x2EB0)"},
{0x1093, 0x2EC0, 0xFFFF, 0xFFFF, "PXI-6115(0x2EC0)"},
{0x1093, 0x2ED0, 0xFFFF, 0xFFFF, "PCI-6115(0x2ED0)"},
{0x1093, 0x2EE0, 0xFFFF, 0xFFFF, "PXI-6120(0x2EE0)"},
{0x1093, 0x2EF0, 0xFFFF, 0xFFFF, "PCI-6120(0x2EF0)"},
{0x1093, 0x2FD1, 0xFFFF, 0xFFFF, "PCI-7334(0x2FD1)"},
{0x1093, 0x2FD2, 0xFFFF, 0xFFFF, "PCI-7350(0x2FD2)"},
{0x1093, 0x2FD3, 0xFFFF, 0xFFFF, "PCI-7342(0x2FD3)"},
{0x1093, 0x2FD5, 0xFFFF, 0xFFFF, "PXI-7350(0x2FD5)"},
{0x1093, 0x2FD6, 0xFFFF, 0xFFFF, "PXI-7342(0x2FD6)"},
{0x1093, 0x7003, 0xFFFF, 0xFFFF, "PCI-6551(0x7003)"},
{0x1093, 0x7004, 0xFFFF, 0xFFFF, "PXI-6551(0x7004)"},
{0x1093, 0x700B, 0xFFFF, 0xFFFF, "PXI-5421(0x700B)"},
{0x1093, 0x700C, 0xFFFF, 0xFFFF, "PCI-5421(0x700C)"},
{0x1093, 0x701A, 0xFFFF, 0xFFFF, "VXIpc-87xB(0x701A)"},
{0x1093, 0x701B, 0xFFFF, 0xFFFF, "VXIpc-770(0x701B)"},
{0x1093, 0x7023, 0xFFFF, 0xFFFF, "PXI-2593(0x7023)"},
{0x1093, 0x7027, 0xFFFF, 0xFFFF, "PCI-MXI-2 Universal(0x7027)"},
{0x1093, 0x702C, 0xFFFF, 0xFFFF, "PXI-7831R(0x702C)"},
{0x1093, 0x702D, 0xFFFF, 0xFFFF, "PCI-7831R(0x702D)"},
{0x1093, 0x702E, 0xFFFF, 0xFFFF, "PXI-7811R(0x702E)"},
{0x1093, 0x702F, 0xFFFF, 0xFFFF, "PCI-7811R(0x702F)"},
{0x1093, 0x7030, 0xFFFF, 0xFFFF, "PCI-CAN (Series 2)(0x7030)"},
{0x1093, 0x7031, 0xFFFF, 0xFFFF, "PCI-CAN/2 (Series 2)(0x7031)"},
{0x1093, 0x7032, 0xFFFF, 0xFFFF, "PCI-CAN/LS (Series 2)(0x7032)"},
{0x1093, 0x7033, 0xFFFF, 0xFFFF, "PCI-CAN/LS2 (Series 2)(0x7033)"},
{0x1093, 0x7034, 0xFFFF, 0xFFFF, "PCI-CAN/DS (Series 2)(0x7034)"},
{0x1093, 0x7035, 0xFFFF, 0xFFFF, "PXI-8460 (Series 2, 1 port)(0x7035)"},
{0x1093, 0x7036, 0xFFFF, 0xFFFF, "PXI-8460 (Series 2, 2 ports)(0x7036)"},
{0x1093, 0x7037, 0xFFFF, 0xFFFF, "PXI-8461 (Series 2, 1 port)(0x7037)"},
{0x1093, 0x7038, 0xFFFF, 0xFFFF, "PXI-8461 (Series 2, 2 ports)(0x7038)"},
{0x1093, 0x7039, 0xFFFF, 0xFFFF, "PXI-8462 (Series 2)(0x7039)"},
{0x1093, 0x703F, 0xFFFF, 0xFFFF, "PXI-2566(0x703F)"},
{0x1093, 0x7040, 0xFFFF, 0xFFFF, "PXI-2567(0x7040)"},
{0x1093, 0x7044, 0xFFFF, 0xFFFF, "MXI-4 Connection Monitor(0x7044)"},
{0x1093, 0x7047, 0xFFFF, 0xFFFF, "PXI-6653(0x7047)"},
{0x1093, 0x704C, 0xFFFF, 0xFFFF, "PXI-2530(0x704C)"},
{0x1093, 0x704F, 0xFFFF, 0xFFFF, "PXI-4220(0x704F)"},
{0x1093, 0x7050, 0xFFFF, 0xFFFF, "PXI-4204(0x7050)"},
{0x1093, 0x7055, 0xFFFF, 0xFFFF, "PXI-7830R(0x7055)"},
{0x1093, 0x7056, 0xFFFF, 0xFFFF, "PCI-7830R(0x7056)"},
{0x1093, 0x705A, 0xFFFF, 0xFFFF, "PCI-CAN/XS (Series 2)(0x705A)"},
{0x1093, 0x705B, 0xFFFF, 0xFFFF, "PCI-CAN/XS2 (Series 2)(0x705B)"},
{0x1093, 0x705C, 0xFFFF, 0xFFFF, "PXI-8464 (Series 2, 1 port)(0x705C)"},
{0x1093, 0x705D, 0xFFFF, 0xFFFF, "PXI-8464 (Series 2, 2 ports)(0x705D)"},
{0x1093, 0x705E, 0xFFFF, 0xFFFF, "cRIO-9102(0x705E)"},
{0x1093, 0x7060, 0xFFFF, 0xFFFF, "PXI-5610(0x7060)"},
{0x1093, 0x7064, 0xFFFF, 0xFFFF, "PXI-1045 Trigger Routing Module(0x7064)"},
{0x1093, 0x7065, 0xFFFF, 0xFFFF, "PXI-6652(0x7065)"},
{0x1093, 0x7066, 0xFFFF, 0xFFFF, "PXI-6651(0x7066)"},
{0x1093, 0x7067, 0xFFFF, 0xFFFF, "PXI-2529(0x7067)"},
{0x1093, 0x7068, 0xFFFF, 0xFFFF, "PCI-CAN/SW (Series 2)(0x7068)"},
{0x1093, 0x7069, 0xFFFF, 0xFFFF, "PCI-CAN/SW2 (Series 2)(0x7069)"},
{0x1093, 0x706A, 0xFFFF, 0xFFFF, "PXI-8463 (Series 2, 1 port)(0x706A)"},
{0x1093, 0x706B, 0xFFFF, 0xFFFF, "PXI-8463 (Series 2, 2 ports)(0x706B)"},
{0x1093, 0x7073, 0xFFFF, 0xFFFF, "PCI-6723(0x7073)"},
{0x1093, 0x7074, 0xFFFF, 0xFFFF, "PXI-7833R(0x7074)"},
{0x1093, 0x7075, 0xFFFF, 0xFFFF, "PXI-6552(0x7075)"},
{0x1093, 0x7076, 0xFFFF, 0xFFFF, "PCI-6552(0x7076)"},
{0x1093, 0x707C, 0xFFFF, 0xFFFF, "PXI-1428(0x707C)"},
{0x1093, 0x707E, 0xFFFF, 0xFFFF, "PXI-4462(0x707E)"},
{0x1093, 0x7080, 0xFFFF, 0xFFFF, "PXI-8430/2 (RS-232) Interface(0x7080)"},
{0x1093, 0x7081, 0xFFFF, 0xFFFF, "PXI-8431/2 (RS-485) Interface(0x7081)"},
{0x1093, 0x7083, 0xFFFF, 0xFFFF, "PCI-7833R(0x7083)"},
{0x1093, 0x7085, 0xFFFF, 0xFFFF, "PCI-6509(0x7085)"},
{0x1093, 0x7086, 0xFFFF, 0xFFFF, "PXI-6528(0x7086)"},
{0x1093, 0x7087, 0xFFFF, 0xFFFF, "PCI-6515(0x7087)"},
{0x1093, 0x7088, 0xFFFF, 0xFFFF, "PCI-6514(0x7088)"},
{0x1093, 0x708C, 0xFFFF, 0xFFFF, "PXI-2568(0x708C)"},
{0x1093, 0x708D, 0xFFFF, 0xFFFF, "PXI-2569(0x708D)"},
{0x1093, 0x70A9, 0xFFFF, 0xFFFF, "PCI-6528(0x70A9)"},
{0x1093, 0x70AA, 0xFFFF, 0xFFFF, "PCI-6229(0x70AA)"},
{0x1093, 0x70AB, 0xFFFF, 0xFFFF, "PCI-6259(0x70AB)"},
{0x1093, 0x70AC, 0xFFFF, 0xFFFF, "PCI-6289(0x70AC)"},
{0x1093, 0x70AD, 0xFFFF, 0xFFFF, "PXI-6251(0x70AD)"},
{0x1093, 0x70AE, 0xFFFF, 0xFFFF, "PXI-6220(0x70AE)"},
{0x1093, 0x70AF, 0xFFFF, 0xFFFF, "PCI-6221(0x70AF)"},
{0x1093, 0x70B0, 0xFFFF, 0xFFFF, "PCI-6220(0x70B0)"},
{0x1093, 0x70B1, 0xFFFF, 0xFFFF, "PXI-6229(0x70B1)"},
{0x1093, 0x70B2, 0xFFFF, 0xFFFF, "PXI-6259(0x70B2)"},
{0x1093, 0x70B3, 0xFFFF, 0xFFFF, "PXI-6289(0x70B3)"},
{0x1093, 0x70B4, 0xFFFF, 0xFFFF, "PCI-6250(0x70B4)"},
{0x1093, 0x70B5, 0xFFFF, 0xFFFF, "PXI-6221(0x70B5)"},
{0x1093, 0x70B6, 0xFFFF, 0xFFFF, "PCI-6280(0x70B6)"},
{0x1093, 0x70B7, 0xFFFF, 0xFFFF, "PCI-6254(0x70B7)"},
{0x1093, 0x70B8, 0xFFFF, 0xFFFF, "PCI-6251(0x70B8)"},
{0x1093, 0x70B9, 0xFFFF, 0xFFFF, "PXI-6250(0x70B9)"},
{0x1093, 0x70BA, 0xFFFF, 0xFFFF, "PXI-6254(0x70BA)"},
{0x1093, 0x70BB, 0xFFFF, 0xFFFF, "PXI-6280(0x70BB)"},
{0x1093, 0x70BC, 0xFFFF, 0xFFFF, "PCI-6284(0x70BC)"},
{0x1093, 0x70BD, 0xFFFF, 0xFFFF, "PCI-6281(0x70BD)"},
{0x1093, 0x70BE, 0xFFFF, 0xFFFF, "PXI-6284(0x70BE)"},
{0x1093, 0x70BF, 0xFFFF, 0xFFFF, "PXI-6281(0x70BF)"},
{0x1093, 0x70C0, 0xFFFF, 0xFFFF, "PCI-6143(0x70C0)"},
{0x1093, 0x70C3, 0xFFFF, 0xFFFF, "PCI-6511(0x70C3)"},
{0x1093, 0x70C4, 0xFFFF, 0xFFFF, "PXI-7330(0x70C4)"},
{0x1093, 0x70C5, 0xFFFF, 0xFFFF, "PXI-7340(0x70C5)"},
{0x1093, 0x70C6, 0xFFFF, 0xFFFF, "PCI-7330(0x70C6)"},
{0x1093, 0x70C7, 0xFFFF, 0xFFFF, "PCI-7340(0x70C7)"},
{0x1093, 0x70C8, 0xFFFF, 0xFFFF, "PCI-6513(0x70C8)"},
{0x1093, 0x70C9, 0xFFFF, 0xFFFF, "PXI-6515(0x70C9)"},
{0x1093, 0x70CA, 0xFFFF, 0xFFFF, "PCI-1405(0x70CA)"},
{0x1093, 0x70CC, 0xFFFF, 0xFFFF, "PCI-6512(0x70CC)"},
{0x1093, 0x70CD, 0xFFFF, 0xFFFF, "PXI-6514(0x70CD)"},
{0x1093, 0x70CE, 0xFFFF, 0xFFFF, "PXI-1405(0x70CE)"},
{0x1093, 0x70CF, 0xFFFF, 0xFFFF, "PCIe-GPIB(0x70CF)"},
{0x1093, 0x70D0, 0xFFFF, 0xFFFF, "PXI-2570(0x70D0)"},
{0x1093, 0x70D1, 0xFFFF, 0xFFFF, "PXI-6513(0x70D1)"},
{0x1093, 0x70D2, 0xFFFF, 0xFFFF, "PXI-6512(0x70D2)"},
{0x1093, 0x70D3, 0xFFFF, 0xFFFF, "PXI-6511(0x70D3)"},
{0x1093, 0x70D4, 0xFFFF, 0xFFFF, "PCI-6722(0x70D4)"},
{0x1093, 0x70D6, 0xFFFF, 0xFFFF, "PXI-4072(0x70D6)"},
{0x1093, 0x70D7, 0xFFFF, 0xFFFF, "PXI-6541(0x70D7)"},
{0x1093, 0x70D8, 0xFFFF, 0xFFFF, "PXI-6542(0x70D8)"},
{0x1093, 0x70D9, 0xFFFF, 0xFFFF, "PCI-6541(0x70D9)"},
{0x1093, 0x70DA, 0xFFFF, 0xFFFF, "PCI-6542(0x70DA)"},
{0x1093, 0x70DB, 0xFFFF, 0xFFFF, "PCI-8430/2 (RS-232) Interface(0x70DB)"},
{0x1093, 0x70DC, 0xFFFF, 0xFFFF, "PCI-8431/2 (RS-485) Interface(0x70DC)"},
{0x1093, 0x70DD, 0xFFFF, 0xFFFF, "PXI-8430/4 (RS-232) Interface(0x70DD)"},
{0x1093, 0x70DE, 0xFFFF, 0xFFFF, "PXI-8431/4 (RS-485) Interface(0x70DE)"},
{0x1093, 0x70DF, 0xFFFF, 0xFFFF, "PCI-8430/4 (RS-232) Interface(0x70DF)"},
{0x1093, 0x70E0, 0xFFFF, 0xFFFF, "PCI-8431/4 (RS-485) Interface(0x70E0)"},
{0x1093, 0x70E1, 0xFFFF, 0xFFFF, "PXI-2532(0x70E1)"},
{0x1093, 0x70E2, 0xFFFF, 0xFFFF, "PXI-8430/8 (RS-232) Interface(0x70E2)"},
{0x1093, 0x70E3, 0xFFFF, 0xFFFF, "PXI-8431/8 (RS-485) Interface(0x70E3)"},
{0x1093, 0x70E4, 0xFFFF, 0xFFFF, "PCI-8430/8 (RS-232) Interface(0x70E4)"},
{0x1093, 0x70E5, 0xFFFF, 0xFFFF, "PCI-8431/8 (RS-485) Interface(0x70E5)"},
{0x1093, 0x70E6, 0xFFFF, 0xFFFF, "PXI-8430/16 (RS-232) Interface(0x70E6)"},
{0x1093, 0x70E7, 0xFFFF, 0xFFFF, "PCI-8430/16 (RS-232) Interface(0x70E7)"},
{0x1093, 0x70E8, 0xFFFF, 0xFFFF, "PXI-8432/2 (Isolated RS-232) Interface(0x70E8)"},
{0x1093, 0x70E9, 0xFFFF, 0xFFFF, "PXI-8433/2 (Isolated RS-485) Interface(0x70E9)"},
{0x1093, 0x70EA, 0xFFFF, 0xFFFF, "PCI-8432/2 (Isolated RS-232) Interface(0x70EA)"},
{0x1093, 0x70EB, 0xFFFF, 0xFFFF, "PCI-8433/2 (Isolated RS-485) Interface(0x70EB)"},
{0x1093, 0x70EC, 0xFFFF, 0xFFFF, "PXI-8432/4 (Isolated RS-232) Interface(0x70EC)"},
{0x1093, 0x70ED, 0xFFFF, 0xFFFF, "PXI-8433/4 (Isolated RS-485) Interface(0x70ED)"},
{0x1093, 0x70EE, 0xFFFF, 0xFFFF, "PCI-8432/4 (Isolated RS-232) Interface(0x70EE)"},
{0x1093, 0x70EF, 0xFFFF, 0xFFFF, "PCI-8433/4 (Isolated RS-485) Interface(0x70EF)"},
{0x1093, 0x70F0, 0xFFFF, 0xFFFF, "PXI-5922(0x70F0)"},
{0x1093, 0x70F1, 0xFFFF, 0xFFFF, "PCI-5922(0x70F1)"},
{0x1093, 0x70F2, 0xFFFF, 0xFFFF, "PCI-6224(0x70F2)"},
{0x1093, 0x70F3, 0xFFFF, 0xFFFF, "PXI-6224(0x70F3)"},
{0x1093, 0x70F6, 0xFFFF, 0xFFFF, "cRIO-9101(0x70F6)"},
{0x1093, 0x70F7, 0xFFFF, 0xFFFF, "cRIO-9103(0x70F7)"},
{0x1093, 0x70F8, 0xFFFF, 0xFFFF, "cRIO-9104(0x70F8)"},
{0x1093, 0x70FF, 0xFFFF, 0xFFFF, "PXI-6723(0x70FF)"},
{0x1093, 0x7100, 0xFFFF, 0xFFFF, "PXI-6722(0x7100)"},
{0x1093, 0x7104, 0xFFFF, 0xFFFF, "PCIx-1429(0x7104)"},
{0x1093, 0x7105, 0xFFFF, 0xFFFF, "PCIe-1429(0x7105)"},
{0x1093, 0x710A, 0xFFFF, 0xFFFF, "PXI-4071(0x710A)"},
{0x1093, 0x710D, 0xFFFF, 0xFFFF, "PXI-6143(0x710D)"},
{0x1093, 0x710E, 0xFFFF, 0xFFFF, "PCIe-GPIB(0x710E)"},
{0x1093, 0x710F, 0xFFFF, 0xFFFF, "PXI-5422(0x710F)"},
{0x1093, 0x7110, 0xFFFF, 0xFFFF, "PCI-5422(0x7110)"},
{0x1093, 0x7111, 0xFFFF, 0xFFFF, "PXI-5441(0x7111)"},
{0x1093, 0x7119, 0xFFFF, 0xFFFF, "PXI-6561(0x7119)"},
{0x1093, 0x711A, 0xFFFF, 0xFFFF, "PXI-6562(0x711A)"},
{0x1093, 0x711B, 0xFFFF, 0xFFFF, "PCI-6561(0x711B)"},
{0x1093, 0x711C, 0xFFFF, 0xFFFF, "PCI-6562(0x711C)"},
{0x1093, 0x7120, 0xFFFF, 0xFFFF, "PCI-7390(0x7120)"},
{0x1093, 0x7121, 0xFFFF, 0xFFFF, "PXI-5122EX(0x7121)"},
{0x1093, 0x7122, 0xFFFF, 0xFFFF, "PCI-5122EX(0x7122)"},
{0x1093, 0x7123, 0xFFFF, 0xFFFF, "PXIe-5653(0x7123)"},
{0x1093, 0x7124, 0xFFFF, 0xFFFF, "PCI-6510(0x7124)"},
{0x1093, 0x7125, 0xFFFF, 0xFFFF, "PCI-6516(0x7125)"},
{0x1093, 0x7126, 0xFFFF, 0xFFFF, "PCI-6517(0x7126)"},
{0x1093, 0x7127, 0xFFFF, 0xFFFF, "PCI-6518(0x7127)"},
{0x1093, 0x7128, 0xFFFF, 0xFFFF, "PCI-6519(0x7128)"},
{0x1093, 0x7137, 0xFFFF, 0xFFFF, "PXI-2575(0x7137)"},
{0x1093, 0x713C, 0xFFFF, 0xFFFF, "PXI-2585(0x713C)"},
{0x1093, 0x713D, 0xFFFF, 0xFFFF, "PXI-2586(0x713D)"},
{0x1093, 0x7142, 0xFFFF, 0xFFFF, "PXI-4224(0x7142)"},
{0x1093, 0x7144, 0xFFFF, 0xFFFF, "PXI-5124(0x7144)"},
{0x1093, 0x7145, 0xFFFF, 0xFFFF, "PCI-5124(0x7145)"},
{0x1093, 0x7146, 0xFFFF, 0xFFFF, "PCI-6132(0x7146)"},
{0x1093, 0x7147, 0xFFFF, 0xFFFF, "PXI-6132(0x7147)"},
{0x1093, 0x7148, 0xFFFF, 0xFFFF, "PCI-6122(0x7148)"},
{0x1093, 0x7149, 0xFFFF, 0xFFFF, "PXI-6122(0x7149)"},
{0x1093, 0x714C, 0xFFFF, 0xFFFF, "PXI-5114(0x714C)"},
{0x1093, 0x714D, 0xFFFF, 0xFFFF, "PCI-5114(0x714D)"},
{0x1093, 0x7150, 0xFFFF, 0xFFFF, "PXI-2564(0x7150)"},
{0x1093, 0x7152, 0xFFFF, 0xFFFF, "PCI-5640R(0x7152)"},
{0x1093, 0x7156, 0xFFFF, 0xFFFF, "PXI-1044 Trigger Routing Module(0x7156)"},
{0x1093, 0x715D, 0xFFFF, 0xFFFF, "PCI-1426(0x715D)"},
{0x1093, 0x7167, 0xFFFF, 0xFFFF, "PXI-5412(0x7167)"},
{0x1093, 0x7168, 0xFFFF, 0xFFFF, "PCI-5412(0x7168)"},
{0x1093, 0x716B, 0xFFFF, 0xFFFF, "PCI-6230(0x716B)"},
{0x1093, 0x716C, 0xFFFF, 0xFFFF, "PCI-6225(0x716C)"},
{0x1093, 0x716D, 0xFFFF, 0xFFFF, "PXI-6225(0x716D)"},
{0x1093, 0x716F, 0xFFFF, 0xFFFF, "PCI-4461(0x716F)"},
{0x1093, 0x7170, 0xFFFF, 0xFFFF, "PCI-4462(0x7170)"},
{0x1093, 0x7171, 0xFFFF, 0xFFFF, "PCI-6010(0x7171)"},
{0x1093, 0x7174, 0xFFFF, 0xFFFF, "PXI-8360(0x7174)"},
{0x1093, 0x7177, 0xFFFF, 0xFFFF, "PXI-6230(0x7177)"},
{0x1093, 0x717D, 0xFFFF, 0xFFFF, "PCIe-6251(0x717D)"},
{0x1093, 0x717F, 0xFFFF, 0xFFFF, "PCIe-6259(0x717F)"},
{0x1093, 0x7187, 0xFFFF, 0xFFFF, "PCI-1410(0x7187)"},
{0x1093, 0x718B, 0xFFFF, 0xFFFF, "PCI-6521(0x718B)"},
{0x1093, 0x718C, 0xFFFF, 0xFFFF, "PXI-6521(0x718C)"},
{0x1093, 0x7191, 0xFFFF, 0xFFFF, "PCI-6154(0x7191)"},
{0x1093, 0x7193, 0xFFFF, 0xFFFF, "PXI-7813R(0x7193)"},
{0x1093, 0x7194, 0xFFFF, 0xFFFF, "PCI-7813R(0x7194)"},
{0x1093, 0x7195, 0xFFFF, 0xFFFF, "PCI-8254R(0x7195)"},
{0x1093, 0x7197, 0xFFFF, 0xFFFF, "PXI-5402(0x7197)"},
{0x1093, 0x7198, 0xFFFF, 0xFFFF, "PCI-5402(0x7198)"},
{0x1093, 0x719F, 0xFFFF, 0xFFFF, "PCIe-6535(0x719F)"},
{0x1093, 0x71A0, 0xFFFF, 0xFFFF, "PCIe-6536(0x71A0)"},
{0x1093, 0x71A3, 0xFFFF, 0xFFFF, "PXI-5650(0x71A3)"},
{0x1093, 0x71A4, 0xFFFF, 0xFFFF, "PXI-5652(0x71A4)"},
{0x1093, 0x71A5, 0xFFFF, 0xFFFF, "PXI-2594(0x71A5)"},
{0x1093, 0x71A7, 0xFFFF, 0xFFFF, "PXI-2595(0x71A7)"},
{0x1093, 0x71A9, 0xFFFF, 0xFFFF, "PXI-2596(0x71A9)"},
{0x1093, 0x71AA, 0xFFFF, 0xFFFF, "PXI-2597(0x71AA)"},
{0x1093, 0x71AB, 0xFFFF, 0xFFFF, "PXI-2598(0x71AB)"},
{0x1093, 0x71AC, 0xFFFF, 0xFFFF, "PXI-2599(0x71AC)"},
{0x1093, 0x71AD, 0xFFFF, 0xFFFF, "PCI-GPIB+(0x71AD)"},
{0x1093, 0x71AE, 0xFFFF, 0xFFFF, "PCIe-1430(0x71AE)"},
{0x1093, 0x71B7, 0xFFFF, 0xFFFF, "PXI-1056 Trigger Routing Module(0x71B7)"},
{0x1093, 0x71B8, 0xFFFF, 0xFFFF, "PXI-1045 Trigger Routing Module(0x71B8)"},
{0x1093, 0x71B9, 0xFFFF, 0xFFFF, "PXI-1044 Trigger Routing Module(0x71B9)"},
{0x1093, 0x71BB, 0xFFFF, 0xFFFF, "PXI-2584(0x71BB)"},
{0x1093, 0x71BC, 0xFFFF, 0xFFFF, "PCI-6221 (37-pin)(0x71BC)"},
{0x1093, 0x71BF, 0xFFFF, 0xFFFF, "PCIe-1427(0x71BF)"},
{0x1093, 0x71C5, 0xFFFF, 0xFFFF, "PCI-6520(0x71C5)"},
{0x1093, 0x71C6, 0xFFFF, 0xFFFF, "PXI-2576(0x71C6)"},
{0x1093, 0x71C7, 0xFFFF, 0xFFFF, "cRIO-9072(0x71C7)"},
{0x1093, 0x71DC, 0xFFFF, 0xFFFF, "PCI-1588(0x71DC)"},
{0x1093, 0x71E0, 0xFFFF, 0xFFFF, "PCI-6255(0x71E0)"},
{0x1093, 0x71E1, 0xFFFF, 0xFFFF, "PXI-6255(0x71E1)"},
{0x1093, 0x71E2, 0xFFFF, 0xFFFF, "PXI-5406(0x71E2)"},
{0x1093, 0x71E3, 0xFFFF, 0xFFFF, "PCI-5406(0x71E3)"},
{0x1093, 0x71FC, 0xFFFF, 0xFFFF, "PXI-4022(0x71FC)"},
{0x1093, 0x7209, 0xFFFF, 0xFFFF, "PCI-6233(0x7209)"},
{0x1093, 0x720A, 0xFFFF, 0xFFFF, "PXI-6233(0x720A)"},
{0x1093, 0x720B, 0xFFFF, 0xFFFF, "PCI-6238(0x720B)"},
{0x1093, 0x720C, 0xFFFF, 0xFFFF, "PXI-6238(0x720C)"},
{0x1093, 0x7260, 0xFFFF, 0xFFFF, "PXI-5142(0x7260)"},
{0x1093, 0x7261, 0xFFFF, 0xFFFF, "PCI-5142(0x7261)"},
{0x1093, 0x726D, 0xFFFF, 0xFFFF, "PXI-5651(0x726D)"},
{0x1093, 0x7273, 0xFFFF, 0xFFFF, "PXI-4461(0x7273)"},
{0x1093, 0x7274, 0xFFFF, 0xFFFF, "PXI-4462(0x7274)"},
{0x1093, 0x7279, 0xFFFF, 0xFFFF, "PCI-6232(0x7279)"},
{0x1093, 0x727A, 0xFFFF, 0xFFFF, "PXI-6232(0x727A)"},
{0x1093, 0x727B, 0xFFFF, 0xFFFF, "PCI-6239(0x727B)"},
{0x1093, 0x727C, 0xFFFF, 0xFFFF, "PXI-6239(0x727C)"},
{0x1093, 0x727E, 0xFFFF, 0xFFFF, "SMBus Controller(0x727E)"},
{0x1093, 0x727E, 0x1093, 0x75AC, "PXIe-8388(0x1093-0x75AC)"},
{0x1093, 0x727E, 0x1093, 0x75AD, "PXIe-8389(0x1093-0x75AD)"},
{0x1093, 0x727E, 0x1093, 0x7650, "PXIe-8381(0x1093-0x7650)"},
{0x1093, 0x727E, 0x1093, 0x8360, "PXIe-8360(0x1093-0x8360)"},
{0x1093, 0x727E, 0x1093, 0x8370, "PXIe-8370(0x1093-0x8370)"},
{0x1093, 0x727E, 0x1093, 0x8375, "PXIe-8375(0x1093-0x8375)"},
{0x1093, 0x7281, 0xFFFF, 0xFFFF, "PCI-6236(0x7281)"},
{0x1093, 0x7282, 0xFFFF, 0xFFFF, "PXI-6236(0x7282)"},
{0x1093, 0x7283, 0xFFFF, 0xFFFF, "PXI-2554(0x7283)"},
{0x1093, 0x7288, 0xFFFF, 0xFFFF, "PXIe-5611(0x7288)"},
{0x1093, 0x7293, 0xFFFF, 0xFFFF, "PCIe-8255R(0x7293)"},
{0x1093, 0x729D, 0xFFFF, 0xFFFF, "cRIO-9074(0x729D)"},
{0x1093, 0x72A4, 0xFFFF, 0xFFFF, "PCIe-4065(0x72A4)"},
{0x1093, 0x72A7, 0xFFFF, 0xFFFF, "PCIe-6537(0x72A7)"},
{0x1093, 0x72A8, 0xFFFF, 0xFFFF, "PXI-5152(0x72A8)"},
{0x1093, 0x72A9, 0xFFFF, 0xFFFF, "PCI-5152(0x72A9)"},
{0x1093, 0x72AA, 0xFFFF, 0xFFFF, "PXI-5105(0x72AA)"},
{0x1093, 0x72AB, 0xFFFF, 0xFFFF, "PCI-5105(0x72AB)"},
{0x1093, 0x72B8, 0xFFFF, 0xFFFF, "PXI-6682(0x72B8)"},
{0x1093, 0x72D0, 0xFFFF, 0xFFFF, "PXI-2545(0x72D0)"},
{0x1093, 0x72D1, 0xFFFF, 0xFFFF, "PXI-2546(0x72D1)"},
{0x1093, 0x72D2, 0xFFFF, 0xFFFF, "PXI-2547(0x72D2)"},
{0x1093, 0x72D3, 0xFFFF, 0xFFFF, "PXI-2548(0x72D3)"},
{0x1093, 0x72D4, 0xFFFF, 0xFFFF, "PXI-2549(0x72D4)"},
{0x1093, 0x72D5, 0xFFFF, 0xFFFF, "PXI-2555(0x72D5)"},
{0x1093, 0x72D6, 0xFFFF, 0xFFFF, "PXI-2556(0x72D6)"},
{0x1093, 0x72D7, 0xFFFF, 0xFFFF, "PXI-2557(0x72D7)"},
{0x1093, 0x72D8, 0xFFFF, 0xFFFF, "PXI-2558(0x72D8)"},
{0x1093, 0x72D9, 0xFFFF, 0xFFFF, "PXI-2559(0x72D9)"},
{0x1093, 0x72E8, 0xFFFF, 0xFFFF, "PXIe-6251(0x72E8)"},
{0x1093, 0x72E9, 0xFFFF, 0xFFFF, "PXIe-6259(0x72E9)"},
{0x1093, 0x72EF, 0xFFFF, 0xFFFF, "PXI-4498(0x72EF)"},
{0x1093, 0x72F0, 0xFFFF, 0xFFFF, "PXI-4496(0x72F0)"},
{0x1093, 0x72FB, 0xFFFF, 0xFFFF, "PXIe-6672(0x72FB)"},
{0x1093, 0x730E, 0xFFFF, 0xFFFF, "PXI-4130(0x730E)"},
{0x1093, 0x730F, 0xFFFF, 0xFFFF, "PXI-5922EX(0x730F)"},
{0x1093, 0x7310, 0xFFFF, 0xFFFF, "PCI-5922EX(0x7310)"},
{0x1093, 0x731C, 0xFFFF, 0xFFFF, "PXI-2535(0x731C)"},
{0x1093, 0x731D, 0xFFFF, 0xFFFF, "PXI-2536(0x731D)"},
{0x1093, 0x7322, 0xFFFF, 0xFFFF, "PXIe-6124(0x7322)"},
{0x1093, 0x7327, 0xFFFF, 0xFFFF, "PXI-6529(0x7327)"},
{0x1093, 0x732C, 0xFFFF, 0xFFFF, "VXI-8360T(0x732C)"},
{0x1093, 0x7331, 0xFFFF, 0xFFFF, "PXIe-5602(0x7331)"},
{0x1093, 0x7332, 0xFFFF, 0xFFFF, "PXIe-5601(0x7332)"},
{0x1093, 0x7333, 0xFFFF, 0xFFFF, "PXI-5900(0x7333)"},
{0x1093, 0x7335, 0xFFFF, 0xFFFF, "PXI-2533(0x7335)"},
{0x1093, 0x7336, 0xFFFF, 0xFFFF, "PXI-2534(0x7336)"},
{0x1093, 0x7342, 0xFFFF, 0xFFFF, "PXI-4461(0x7342)"},
{0x1093, 0x7349, 0xFFFF, 0xFFFF, "PXI-5154(0x7349)"},
{0x1093, 0x734A, 0xFFFF, 0xFFFF, "PCI-5154(0x734A)"},
{0x1093, 0x7357, 0xFFFF, 0xFFFF, "PXI-4065(0x7357)"},
{0x1093, 0x7359, 0xFFFF, 0xFFFF, "PXI-4495(0x7359)"},
{0x1093, 0x7370, 0xFFFF, 0xFFFF, "PXI-4461(0x7370)"},
{0x1093, 0x7373, 0xFFFF, 0xFFFF, "sbRIO-9601(0x7373)"},
{0x1093, 0x7374, 0xFFFF, 0xFFFF, "IOtech-9601(0x7374)"},
{0x1093, 0x7375, 0xFFFF, 0xFFFF, "sbRIO-9602(0x7375)"},
{0x1093, 0x7378, 0xFFFF, 0xFFFF, "sbRIO-9641(0x7378)"},
{0x1093, 0x737D, 0xFFFF, 0xFFFF, "PXI-5124EX(0x737D)"},
{0x1093, 0x7384, 0xFFFF, 0xFFFF, "PXI-7851R(0x7384)"},
{0x1093, 0x7385, 0xFFFF, 0xFFFF, "PXI-7852R(0x7385)"},
{0x1093, 0x7386, 0xFFFF, 0xFFFF, "PCIe-7851R(0x7386)"},
{0x1093, 0x7387, 0xFFFF, 0xFFFF, "PCIe-7852R(0x7387)"},
{0x1093, 0x7390, 0xFFFF, 0xFFFF, "PXI-7841R(0x7390)"},
{0x1093, 0x7391, 0xFFFF, 0xFFFF, "PXI-7842R(0x7391)"},
{0x1093, 0x7392, 0xFFFF, 0xFFFF, "PXI-7853R(0x7392)"},
{0x1093, 0x7393, 0xFFFF, 0xFFFF, "PCIe-7841R(0x7393)"},
{0x1093, 0x7394, 0xFFFF, 0xFFFF, "PCIe-7842R(0x7394)"},
{0x1093, 0x7397, 0xFFFF, 0xFFFF, "sbRIO-9611(0x7397)"},
{0x1093, 0x7398, 0xFFFF, 0xFFFF, "sbRIO-9612(0x7398)"},
{0x1093, 0x7399, 0xFFFF, 0xFFFF, "sbRIO-9631(0x7399)"},
{0x1093, 0x739A, 0xFFFF, 0xFFFF, "sbRIO-9632(0x739A)"},
{0x1093, 0x739B, 0xFFFF, 0xFFFF, "sbRIO-9642(0x739B)"},
{0x1093, 0x73A1, 0xFFFF, 0xFFFF, "PXIe-4498(0x73A1)"},
{0x1093, 0x73A2, 0xFFFF, 0xFFFF, "PXIe-4496(0x73A2)"},
{0x1093, 0x73A5, 0xFFFF, 0xFFFF, "PXIe-5641R(0x73A5)"},
{0x1093, 0x73A7, 0xFFFF, 0xFFFF, "PXI-8250 Chassis Monitor Module(0x73A7)"},
{0x1093, 0x73A8, 0xFFFF, 0xFFFF, "PXI-8511 CAN/LS(0x73A8)"},
{0x1093, 0x73A9, 0xFFFF, 0xFFFF, "PXI-8511 CAN/LS(0x73A9)"},
{0x1093, 0x73AA, 0xFFFF, 0xFFFF, "PXI-8512 CAN/HS(0x73AA)"},
{0x1093, 0x73AB, 0xFFFF, 0xFFFF, "PXI-8512 CAN/HS(0x73AB)"},
{0x1093, 0x73AC, 0xFFFF, 0xFFFF, "PXI-8513 CAN/XS(0x73AC)"},
{0x1093, 0x73AD, 0xFFFF, 0xFFFF, "PXI-8513 CAN/XS(0x73AD)"},
{0x1093, 0x73AF, 0xFFFF, 0xFFFF, "PXI-8516 LIN(0x73AF)"},
{0x1093, 0x73B1, 0xFFFF, 0xFFFF, "PXI-8517 FlexRay(0x73B1)"},
{0x1093, 0x73B2, 0xFFFF, 0xFFFF, "PXI-8531 CANopen(0x73B2)"},
{0x1093, 0x73B3, 0xFFFF, 0xFFFF, "PXI-8531 CANopen(0x73B3)"},
{0x1093, 0x73B4, 0xFFFF, 0xFFFF, "PXI-8532 DeviceNet(0x73B4)"},
{0x1093, 0x73B5, 0xFFFF, 0xFFFF, "PXI-8532 DeviceNet(0x73B5)"},
{0x1093, 0x73B6, 0xFFFF, 0xFFFF, "PCI-8511 CAN/LS(0x73B6)"},
{0x1093, 0x73B7, 0xFFFF, 0xFFFF, "PCI-8511 CAN/LS(0x73B7)"},
{0x1093, 0x73B8, 0xFFFF, 0xFFFF, "PCI-8512 CAN/HS(0x73B8)"},
{0x1093, 0x73B9, 0xFFFF, 0xFFFF, "PCI-8512 CAN/HS(0x73B9)"},
{0x1093, 0x73BA, 0xFFFF, 0xFFFF, "PCI-8513 CAN/XS(0x73BA)"},
{0x1093, 0x73BB, 0xFFFF, 0xFFFF, "PCI-8513 CAN/XS(0x73BB)"},
{0x1093, 0x73BD, 0xFFFF, 0xFFFF, "PCI-8516 LIN(0x73BD)"},
{0x1093, 0x73BF, 0xFFFF, 0xFFFF, "PCI-8517 FlexRay(0x73BF)"},
{0x1093, 0x73C0, 0xFFFF, 0xFFFF, "PCI-8531 CANopen(0x73C0)"},
{0x1093, 0x73C1, 0xFFFF, 0xFFFF, "PCI-8531 CANopen(0x73C1)"},
{0x1093, 0x73C2, 0xFFFF, 0xFFFF, "PCI-8532 DeviceNet(0x73C2)"},
{0x1093, 0x73C3, 0xFFFF, 0xFFFF, "PCI-8532 DeviceNet(0x73C3)"},
{0x1093, 0x73C5, 0xFFFF, 0xFFFF, "PXIe-2527(0x73C5)"},
{0x1093, 0x73C6, 0xFFFF, 0xFFFF, "PXIe-2529(0x73C6)"},
{0x1093, 0x73C8, 0xFFFF, 0xFFFF, "PXIe-2530(0x73C8)"},
{0x1093, 0x73C9, 0xFFFF, 0xFFFF, "PXIe-2532(0x73C9)"},
{0x1093, 0x73CA, 0xFFFF, 0xFFFF, "PXIe-2569(0x73CA)"},
{0x1093, 0x73CB, 0xFFFF, 0xFFFF, "PXIe-2575(0x73CB)"},
{0x1093, 0x73CC, 0xFFFF, 0xFFFF, "PXIe-2593(0x73CC)"},
{0x1093, 0x73D5, 0xFFFF, 0xFFFF, "PXI-7951R(0x73D5)"},
{0x1093, 0x73D6, 0xFFFF, 0xFFFF, "PXI-7952R(0x73D6)"},
{0x1093, 0x73D7, 0xFFFF, 0xFFFF, "PXI-7953R(0x73D7)"},
{0x1093, 0x73E1, 0xFFFF, 0xFFFF, "PXI-7854R(0x73E1)"},
{0x1093, 0x73EC, 0xFFFF, 0xFFFF, "PXI-7954R(0x73EC)"},
{0x1093, 0x73ED, 0xFFFF, 0xFFFF, "cRIO-9073(0x73ED)"},
{0x1093, 0x73F0, 0xFFFF, 0xFFFF, "PXI-5153(0x73F0)"},
{0x1093, 0x73F1, 0xFFFF, 0xFFFF, "PCI-5153(0x73F1)"},
{0x1093, 0x73F4, 0xFFFF, 0xFFFF, "PXI-2515(0x73F4)"},
{0x1093, 0x73F6, 0xFFFF, 0xFFFF, "cRIO-9111(0x73F6)"},
{0x1093, 0x73F7, 0xFFFF, 0xFFFF, "cRIO-9112(0x73F7)"},
{0x1093, 0x73F8, 0xFFFF, 0xFFFF, "cRIO-9113(0x73F8)"},
{0x1093, 0x73F9, 0xFFFF, 0xFFFF, "cRIO-9114(0x73F9)"},
{0x1093, 0x73FA, 0xFFFF, 0xFFFF, "cRIO-9116(0x73FA)"},
{0x1093, 0x73FB, 0xFFFF, 0xFFFF, "cRIO-9118(0x73FB)"},
{0x1093, 0x7404, 0xFFFF, 0xFFFF, "PXI-4132(0x7404)"},
{0x1093, 0x7405, 0xFFFF, 0xFFFF, "PXIe-6674T(0x7405)"},
{0x1093, 0x7406, 0xFFFF, 0xFFFF, "PXIe-6674(0x7406)"},
{0x1093, 0x740E, 0xFFFF, 0xFFFF, "PCIe-8430/16 (RS-232) Interface(0x740E)"},
{0x1093, 0x740F, 0xFFFF, 0xFFFF, "PCIe-8430/8 (RS-232) Interface(0x740F)"},
{0x1093, 0x7410, 0xFFFF, 0xFFFF, "PCIe-8431/16 (RS-485) Interface(0x7410)"},
{0x1093, 0x7411, 0xFFFF, 0xFFFF, "PCIe-8431/8 (RS-485) Interface(0x7411)"},
{0x1093, 0x7414, 0xFFFF, 0xFFFF, "PCIe-GPIB+(0x7414)"},
{0x1093, 0x741C, 0xFFFF, 0xFFFF, "PXI-5691(0x741C)"},
{0x1093, 0x741D, 0xFFFF, 0xFFFF, "PXI-5695(0x741D)"},
{0x1093, 0x743C, 0xFFFF, 0xFFFF, "CSC-3059(0x743C)"},
{0x1093, 0x7448, 0xFFFF, 0xFFFF, "PXI-2510(0x7448)"},
{0x1093, 0x7454, 0xFFFF, 0xFFFF, "PXI-2512(0x7454)"},
{0x1093, 0x7455, 0xFFFF, 0xFFFF, "PXI-2514(0x7455)"},
{0x1093, 0x7456, 0xFFFF, 0xFFFF, "PXIe-2512(0x7456)"},
{0x1093, 0x7457, 0xFFFF, 0xFFFF, "PXIe-2514(0x7457)"},
{0x1093, 0x745A, 0xFFFF, 0xFFFF, "PXI-6682H(0x745A)"},
{0x1093, 0x745E, 0xFFFF, 0xFFFF, "PXI-5153EX(0x745E)"},
{0x1093, 0x745F, 0xFFFF, 0xFFFF, "PCI-5153EX(0x745F)"},
{0x1093, 0x7460, 0xFFFF, 0xFFFF, "PXI-5154EX(0x7460)"},
{0x1093, 0x7461, 0xFFFF, 0xFFFF, "PCI-5154EX(0x7461)"},
{0x1093, 0x746D, 0xFFFF, 0xFFFF, "PXIe-5650(0x746D)"},
{0x1093, 0x746E, 0xFFFF, 0xFFFF, "PXIe-5651(0x746E)"},
{0x1093, 0x746F, 0xFFFF, 0xFFFF, "PXIe-5652(0x746F)"},
{0x1093, 0x7472, 0xFFFF, 0xFFFF, "PXI-2800(0x7472)"},
{0x1093, 0x7495, 0xFFFF, 0xFFFF, "PXIe-5603(0x7495)"},
{0x1093, 0x7497, 0xFFFF, 0xFFFF, "PXIe-5605(0x7497)"},
{0x1093, 0x74AE, 0xFFFF, 0xFFFF, "PXIe-2515(0x74AE)"},
{0x1093, 0x74B4, 0xFFFF, 0xFFFF, "PXI-2531(0x74B4)"},
{0x1093, 0x74B5, 0xFFFF, 0xFFFF, "PXIe-2531(0x74B5)"},
{0x1093, 0x74C1, 0xFFFF, 0xFFFF, "PXIe-8430/16 (RS-232) Interface(0x74C1)"},
{0x1093, 0x74C2, 0xFFFF, 0xFFFF, "PXIe-8430/8 (RS-232) Interface(0x74C2)"},
{0x1093, 0x74C3, 0xFFFF, 0xFFFF, "PXIe-8431/16 (RS-485) Interface(0x74C3)"},
{0x1093, 0x74C4, 0xFFFF, 0xFFFF, "PXIe-8431/8 (RS-485) Interface(0x74C4)"},
{0x1093, 0x74D5, 0xFFFF, 0xFFFF, "PXIe-5630(0x74D5)"},
{0x1093, 0x74D9, 0xFFFF, 0xFFFF, "PCIe-8432/2 (Isolated RS-232) Interface(0x74D9)"},
{0x1093, 0x74DA, 0xFFFF, 0xFFFF, "PCIe-8433/2 (Isolated RS-485) Interface(0x74DA)"},
{0x1093, 0x74DB, 0xFFFF, 0xFFFF, "PCIe-8432/4 (Isolated RS-232) Interface(0x74DB)"},
{0x1093, 0x74DC, 0xFFFF, 0xFFFF, "PCIe-8433/4 (Isolated RS-485) Interface(0x74DC)"},
{0x1093, 0x74E8, 0xFFFF, 0xFFFF, "NI 9148(0x74E8)"},
{0x1093, 0x7515, 0xFFFF, 0xFFFF, "PCIe-8430/2 (RS-232) Interface(0x7515)"},
{0x1093, 0x7516, 0xFFFF, 0xFFFF, "PCIe-8430/4 (RS-232) Interface(0x7516)"},
{0x1093, 0x7517, 0xFFFF, 0xFFFF, "PCIe-8431/2 (RS-485) Interface(0x7517)"},
{0x1093, 0x7518, 0xFFFF, 0xFFFF, "PCIe-8431/4 (RS-485) Interface(0x7518)"},
{0x1093, 0x751B, 0xFFFF, 0xFFFF, "cRIO-9081(0x751B)"},
{0x1093, 0x751C, 0xFFFF, 0xFFFF, "cRIO-9082(0x751C)"},
{0x1093, 0x7528, 0xFFFF, 0xFFFF, "PXIe-4497(0x7528)"},
{0x1093, 0x7529, 0xFFFF, 0xFFFF, "PXIe-4499(0x7529)"},
{0x1093, 0x752A, 0xFFFF, 0xFFFF, "PXIe-4492(0x752A)"},
{0x1093, 0x7539, 0xFFFF, 0xFFFF, "NI 9157(0x7539)"},
{0x1093, 0x753A, 0xFFFF, 0xFFFF, "NI 9159(0x753A)"},
{0x1093, 0x7598, 0xFFFF, 0xFFFF, "PXI-2571(0x7598)"},
{0x1093, 0x75A4, 0xFFFF, 0xFFFF, "PXI-4131A(0x75A4)"},
{0x1093, 0x75B1, 0xFFFF, 0xFFFF, "PCIe-7854R(0x75B1)"},
{0x1093, 0x75BA, 0xFFFF, 0xFFFF, "PXI-2543(0x75BA)"},
{0x1093, 0x75BB, 0xFFFF, 0xFFFF, "PXIe-2543(0x75BB)"},
{0x1093, 0x75E5, 0xFFFF, 0xFFFF, "PXI-6683(0x75E5)"},
{0x1093, 0x75E6, 0xFFFF, 0xFFFF, "PXI-6683H(0x75E6)"},
{0x1093, 0x75EF, 0xFFFF, 0xFFFF, "PXIe-5632(0x75EF)"},
{0x1093, 0x761C, 0xFFFF, 0xFFFF, "VXI-8360LT(0x761C)"},
{0x1093, 0x761F, 0xFFFF, 0xFFFF, "PXI-2540(0x761F)"},
{0x1093, 0x7620, 0xFFFF, 0xFFFF, "PXIe-2540(0x7620)"},
{0x1093, 0x7621, 0xFFFF, 0xFFFF, "PXI-2541(0x7621)"},
{0x1093, 0x7622, 0xFFFF, 0xFFFF, "PXIe-2541(0x7622)"},
{0x1093, 0x7626, 0xFFFF, 0xFFFF, "NI 9154(0x7626)"},
{0x1093, 0x7627, 0xFFFF, 0xFFFF, "NI 9155(0x7627)"},
{0x1093, 0x7638, 0xFFFF, 0xFFFF, "PXI-2720(0x7638)"},
{0x1093, 0x7639, 0xFFFF, 0xFFFF, "PXI-2722(0x7639)"},
{0x1093, 0x763A, 0xFFFF, 0xFFFF, "PXIe-2725(0x763A)"},
{0x1093, 0x763B, 0xFFFF, 0xFFFF, "PXIe-2727(0x763B)"},
{0x1093, 0x763C, 0xFFFF, 0xFFFF, "PXI-4465(0x763C)"},
{0x1093, 0x764B, 0xFFFF, 0xFFFF, "PXIe-2790(0x764B)"},
{0x1093, 0x764C, 0xFFFF, 0xFFFF, "PXI-2520(0x764C)"},
{0x1093, 0x764D, 0xFFFF, 0xFFFF, "PXI-2521(0x764D)"},
{0x1093, 0x764E, 0xFFFF, 0xFFFF, "PXI-2522(0x764E)"},
{0x1093, 0x764F, 0xFFFF, 0xFFFF, "PXI-2523(0x764F)"},
{0x1093, 0x7652, 0xFFFF, 0xFFFF, "PXIe-4080(0x7652)"},
{0x1093, 0x7654, 0xFFFF, 0xFFFF, "PXI-2796(0x7654)"},
{0x1093, 0x7655, 0xFFFF, 0xFFFF, "PXI-2797(0x7655)"},
{0x1093, 0x7656, 0xFFFF, 0xFFFF, "PXI-2798(0x7656)"},
{0x1093, 0x7657, 0xFFFF, 0xFFFF, "PXI-2799(0x7657)"},
{0x1093, 0x765D, 0xFFFF, 0xFFFF, "PXI-2542(0x765D)"},
{0x1093, 0x765E, 0xFFFF, 0xFFFF, "PXIe-2542(0x765E)"},
{0x1093, 0x765F, 0xFFFF, 0xFFFF, "PXI-2544(0x765F)"},
{0x1093, 0x7660, 0xFFFF, 0xFFFF, "PXIe-2544(0x7660)"},
{0x1093, 0x766D, 0xFFFF, 0xFFFF, "PCIe-6535B(0x766D)"},
{0x1093, 0x766E, 0xFFFF, 0xFFFF, "PCIe-6536B(0x766E)"},
{0x1093, 0x766F, 0xFFFF, 0xFFFF, "PCIe-6537B(0x766F)"},
{0x1093, 0x76A3, 0xFFFF, 0xFFFF, "PXIe-6535B(0x76A3)"},
{0x1093, 0x76A4, 0xFFFF, 0xFFFF, "PXIe-6536B(0x76A4)"},
{0x1093, 0x76A5, 0xFFFF, 0xFFFF, "PXIe-6537B(0x76A5)"},
{0x1093, 0x76D8, 0xFFFF, 0xFFFF, "PXIe-4081(0x76D8)"},
{0x1093, 0x76D9, 0xFFFF, 0xFFFF, "PXIe-4082(0x76D9)"},
{0x1093, 0x77A8, 0xFFFF, 0xFFFF, "PXIe-6375(0x77A8)"},
{0x1093, 0x783E, 0xFFFF, 0xFFFF, "PXI-8368(0x783E)"},
{0x1093, 0x7882, 0xFFFF, 0xFFFF, "PXIe-6376(0x7882)"},
{0x1093, 0x7883, 0xFFFF, 0xFFFF, "PXIe-6378(0x7883)"},
{0x1093, 0x799E, 0xFFFF, 0xFFFF, "PXIe-6386(0x799E)"},
{0x1093, 0x799F, 0xFFFF, 0xFFFF, "PXIe-6396(0x799F)"},
{0x1093, 0x9020, 0xFFFF, 0xFFFF, "PXI-2501(0x9020)"},
{0x1093, 0x9030, 0xFFFF, 0xFFFF, "PXI-2503(0x9030)"},
{0x1093, 0x9040, 0xFFFF, 0xFFFF, "PXI-2527(0x9040)"},
{0x1093, 0x9050, 0xFFFF, 0xFFFF, "PXI-2565(0x9050)"},
{0x1093, 0x9060, 0xFFFF, 0xFFFF, "PXI-2590(0x9060)"},
{0x1093, 0x9070, 0xFFFF, 0xFFFF, "PXI-2591(0x9070)"},
{0x1093, 0x9080, 0xFFFF, 0xFFFF, "PXI-2580(0x9080)"},
{0x1093, 0x9090, 0xFFFF, 0xFFFF, "PCI-4021(0x9090)"},
{0x1093, 0x90A0, 0xFFFF, 0xFFFF, "PXI-4021(0x90A0)"},
{0x1093, 0xA001, 0xFFFF, 0xFFFF, "PCI-MXI-2(0xA001)"},
{0x1093, 0xB001, 0xFFFF, 0xFFFF, "PCI-1408(0xB001)"},
{0x1093, 0xB011, 0xFFFF, 0xFFFF, "PXI-1408(0xB011)"},
{0x1093, 0xB021, 0xFFFF, 0xFFFF, "PCI-1424(0xB021)"},
{0x1093, 0xB022, 0xFFFF, 0xFFFF, "PXI-1424(0xB022)"},
{0x1093, 0xB031, 0xFFFF, 0xFFFF, "PCI-1413(0xB031)"},
{0x1093, 0xB041, 0xFFFF, 0xFFFF, "PCI-1407(0xB041)"},
{0x1093, 0xB051, 0xFFFF, 0xFFFF, "PXI-1407(0xB051)"},
{0x1093, 0xB061, 0xFFFF, 0xFFFF, "PCI-1411(0xB061)"},
{0x1093, 0xB071, 0xFFFF, 0xFFFF, "PCI-1422(0xB071)"},
{0x1093, 0xB081, 0xFFFF, 0xFFFF, "PXI-1422(0xB081)"},
{0x1093, 0xB091, 0xFFFF, 0xFFFF, "PXI-1411(0xB091)"},
{0x1093, 0xB0B1, 0xFFFF, 0xFFFF, "PCI-1409(0xB0B1)"},
{0x1093, 0xB0C1, 0xFFFF, 0xFFFF, "PXI-1409(0xB0C1)"},
{0x1093, 0xB0E1, 0xFFFF, 0xFFFF, "PCI-1428(0xB0E1)"},
{0x1093, 0xC4C4, 0xFFFF, 0xFFFF, "PXIe/PCIe Device(0xC4C4)"},
{0x1093, 0xC4C4, 0x1093, 0x728A, "PXIe-5421(0x1093-0x728A)"},
{0x1093, 0xC4C4, 0x1093, 0x728B, "PXIe-5442(0x1093-0x728B)"},
{0x1093, 0xC4C4, 0x1093, 0x728D, "PXIe-5451(0x1093-0x728D)"},
{0x1093, 0xC4C4, 0x1093, 0x72A2, "PXIe-5122(0x1093-0x72A2)"},
{0x1093, 0xC4C4, 0x1093, 0x72DA, "PXIe-5422(0x1093-0x72DA)"},
{0x1093, 0xC4C4, 0x1093, 0x72F7, "PXIe-6535(0x1093-0x72F7)"},
{0x1093, 0xC4C4, 0x1093, 0x72F8, "PXIe-6536(0x1093-0x72F8)"},
{0x1093, 0xC4C4, 0x1093, 0x72F9, "PXIe-6537(0x1093-0x72F9)"},
{0x1093, 0xC4C4, 0x1093, 0x730A, "PXIe-5142(0x1093-0x730A)"},
{0x1093, 0xC4C4, 0x1093, 0x7326, "PCIe-6509(0x1093-0x7326)"},
{0x1093, 0xC4C4, 0x1093, 0x736C, "PXIe-4140(0x1093-0x736C)"},
{0x1093, 0xC4C4, 0x1093, 0x738B, "PXIe-5622(0x1093-0x738B)"},
{0x1093, 0xC4C4, 0x1093, 0x73C4, "PXIe-5450(0x1093-0x73C4)"},
{0x1093, 0xC4C4, 0x1093, 0x73C7, "PXIe-6545(0x1093-0x73C7)"},
{0x1093, 0xC4C4, 0x1093, 0x73D4, "PXIe-6544(0x1093-0x73D4)"},
{0x1093, 0xC4C4, 0x1093, 0x7425, "PCIe-6320(0x1093-0x7425)"},
{0x1093, 0xC4C4, 0x1093, 0x7427, "PCIe-6321(0x1093-0x7427)"},
{0x1093, 0xC4C4, 0x1093, 0x7428, "PXIe-6323(0x1093-0x7428)"},
{0x1093, 0xC4C4, 0x1093, 0x7429, "PCIe-6323(0x1093-0x7429)"},
{0x1093, 0xC4C4, 0x1093, 0x742A, "PXIe-6341(0x1093-0x742A)"},
{0x1093, 0xC4C4, 0x1093, 0x742B, "PCIe-6341(0x1093-0x742B)"},
{0x1093, 0xC4C4, 0x1093, 0x742C, "PXIe-6343(0x1093-0x742C)"},
{0x1093, 0xC4C4, 0x1093, 0x742D, "PCIe-6343(0x1093-0x742D)"},
{0x1093, 0xC4C4, 0x1093, 0x742F, "PCIe-6351(0x1093-0x742F)"},
{0x1093, 0xC4C4, 0x1093, 0x7431, "PCIe-6353(0x1093-0x7431)"},
{0x1093, 0xC4C4, 0x1093, 0x7432, "PXIe-6361(0x1093-0x7432)"},
{0x1093, 0xC4C4, 0x1093, 0x7433, "PCIe-6361(0x1093-0x7433)"},
{0x1093, 0xC4C4, 0x1093, 0x7434, "PXIe-6363(0x1093-0x7434)"},
{0x1093, 0xC4C4, 0x1093, 0x7435, "PCIe-6363(0x1093-0x7435)"},
{0x1093, 0xC4C4, 0x1093, 0x7436, "PXIe-6356(0x1093-0x7436)"},
{0x1093, 0xC4C4, 0x1093, 0x7437, "PXIe-6358(0x1093-0x7437)"},
{0x1093, 0xC4C4, 0x1093, 0x7438, "PXIe-6366(0x1093-0x7438)"},
{0x1093, 0xC4C4, 0x1093, 0x7439, "PXIe-6368(0x1093-0x7439)"},
{0x1093, 0xC4C4, 0x1093, 0x7468, "PXIe-5185(0x1093-0x7468)"},
{0x1093, 0xC4C4, 0x1093, 0x7469, "PXIe-5186(0x1093-0x7469)"},
{0x1093, 0xC4C4, 0x1093, 0x7492, "PXIe-4300(0x1093-0x7492)"},
{0x1093, 0xC4C4, 0x1093, 0x7498, "PXIe-6548(0x1093-0x7498)"},
{0x1093, 0xC4C4, 0x1093, 0x7499, "PXIe-6547(0x1093-0x7499)"},
{0x1093, 0xC4C4, 0x1093, 0x74A8, "PXIe-4330(0x1093-0x74A8)"},
{0x1093, 0xC4C4, 0x1093, 0x74A9, "PXIe-4331(0x1093-0x74A9)"},
{0x1093, 0xC4C4, 0x1093, 0x74B1, "PXIe-4154(0x1093-0x74B1)"},
{0x1093, 0xC4C4, 0x1093, 0x74B2, "PXIe-4353(0x1093-0x74B2)"},
{0x1093, 0xC4C4, 0x1093, 0x74B6, "PCIe-1433(0x1093-0x74B6)"},
{0x1093, 0xC4C4, 0x1093, 0x74CD, "PXIe-5643R(0x1093-0x74CD)"},
{0x1093, 0xC4C4, 0x1093, 0x74D0, "PXIe-7961R(0x1093-0x74D0)"},
{0x1093, 0xC4C4, 0x1093, 0x74DD, "PXIe-6376(0x1093-0x74DD)"},
{0x1093, 0xC4C4, 0x1093, 0x74DE, "PXIe-6378(0x1093-0x74DE)"},
{0x1093, 0xC4C4, 0x1093, 0x74E2, "PXIe-7962R(0x1093-0x74E2)"},
{0x1093, 0xC4C4, 0x1093, 0x74E3, "PXIe-7965R(0x1093-0x74E3)"},
{0x1093, 0xC4C4, 0x1093, 0x74E5, "PXIe-4844(0x1093-0x74E5)"},
{0x1093, 0xC4C4, 0x1093, 0x74F3, "PCIe-5140(0x1093-0x74F3)"},
{0x1093, 0xC4C4, 0x1093, 0x753C, "PXIe-1435(0x1093-0x753C)"},
{0x1093, 0xC4C4, 0x1093, 0x7548, "PXIe-5622 (25MHz DDC)(0x1093-0x7548)"},
{0x1093, 0xC4C4, 0x1093, 0x754D, "PCIe-5155(0x1093-0x754D)"},
{0x1093, 0xC4C4, 0x1093, 0x7551, "PXIe-6556(0x1093-0x7551)"},
{0x1093, 0xC4C4, 0x1093, 0x7553, "PCIe-1473R(0x1093-0x7553)"},
{0x1093, 0xC4C4, 0x1093, 0x7570, "PCIe-1474R(0x1093-0x7570)"},
{0x1093, 0xC4C4, 0x1093, 0x7571, "PXIe-1475R(0x1093-0x7571)"},
{0x1093, 0xC4C4, 0x1093, 0x7572, "PXIe-1476R(0x1093-0x7572)"},
{0x1093, 0xC4C4, 0x1093, 0x75A2, "PXIe-5693(0x1093-0x75A2)"},
{0x1093, 0xC4C4, 0x1093, 0x75A3, "PXIe-5694(0x1093-0x75A3)"},
{0x1093, 0xC4C4, 0x1093, 0x75A5, "PXIe-4141(0x1093-0x75A5)"},
{0x1093, 0xC4C4, 0x1093, 0x75CE, "PXIe-7966R(0x1093-0x75CE)"},
{0x1093, 0xC4C4, 0x1093, 0x75CF, "PXIe-4357(0x1093-0x75CF)"},
{0x1093, 0xC4C4, 0x1093, 0x75D2, "PXIe-RevB-5643R(0x1093-0x75D2)"},
{0x1093, 0xC4C4, 0x1093, 0x75D3, "PXIe-5644R(0x1093-0x75D3)"},
{0x1093, 0xC4C4, 0x1093, 0x75EE, "PXIe-5645R(0x1093-0x75EE)"},
{0x1093, 0xC4C4, 0x1093, 0x7613, "PXIe-6555(0x1093-0x7613)"},
{0x1093, 0xC4C4, 0x1093, 0x7619, "PXIe-5185(0x1093-0x7619)"},
{0x1093, 0xC4C4, 0x1093, 0x761A, "PXIe-5186(0x1093-0x761A)"},
{0x1093, 0xC4C4, 0x1093, 0x7629, "PXIe-4142(0x1093-0x7629)"},
{0x1093, 0xC4C4, 0x1093, 0x762A, "PXIe-4143(0x1093-0x762A)"},
{0x1093, 0xC4C4, 0x1093, 0x762B, "PXIe-4138(0x1093-0x762B)"},
{0x1093, 0xC4C4, 0x1093, 0x762C, "PXIe-4144(0x1093-0x762C)"},
{0x1093, 0xC4C4, 0x1093, 0x762D, "PXIe-4145(0x1093-0x762D)"},
{0x1093, 0xC4C4, 0x1093, 0x762E, "PXIe-5606(0x1093-0x762E)"},
{0x1093, 0xC4C4, 0x1093, 0x7644, "PXIe-4841(0x1093-0x7644)"},
{0x1093, 0xC4C4, 0x1093, 0x764A, "PCIe-8237R-S(0x1093-0x764A)"},
{0x1093, 0xC4C4, 0x1093, 0x7652, "PXIe-4080(0x1093-0x7652)"},
{0x1093, 0xC4C4, 0x1093, 0x7658, "PXIe-5162 (4CH)(0x1093-0x7658)"},
{0x1093, 0xC4C4, 0x1093, 0x76AB, "PXIe-4322(0x1093-0x76AB)"},
{0x1093, 0xC4C4, 0x1093, 0x76AD, "PXIe-4112(0x1093-0x76AD)"},
{0x1093, 0xC4C4, 0x1093, 0x76AE, "PXIe-4113(0x1093-0x76AE)"},
{0x1093, 0xC4C4, 0x1093, 0x76B5, "PXIe-7971R(0x1093-0x76B5)"},
{0x1093, 0xC4C4, 0x1093, 0x76B6, "PXIe-7972R(0x1093-0x76B6)"},
{0x1093, 0xC4C4, 0x1093, 0x76B7, "PXIe-7975R(0x1093-0x76B7)"},
{0x1093, 0xC4C4, 0x1093, 0x76B8, "PXIe-5696(0x1093-0x76B8)"},
{0x1093, 0xC4C4, 0x1093, 0x76B9, "PXIe-5654(0x1093-0x76B9)"},
{0x1093, 0xC4C4, 0x1093, 0x76C8, "PXIe-6614(0x1093-0x76C8)"},
{0x1093, 0xC4C4, 0x1093, 0x76C9, "PXIe-6612(0x1093-0x76C9)"},
{0x1093, 0xC4C4, 0x1093, 0x76CB, "PXIe-5646R(0x1093-0x76CB)"},
{0x1093, 0xC4C4, 0x1093, 0x76CC, "PXIe-5162 (2CH)(0x1093-0x76CC)"},
{0x1093, 0xC4C4, 0x1093, 0x76CE, "CVS-1459(0x1093-0x76CE)"},
{0x1093, 0xC4C4, 0x1093, 0x76D0, "PXIe-5160 (2CH)(0x1093-0x76D0)"},
{0x1093, 0xC4C4, 0x1093, 0x76D1, "PXIe-5160 (4CH)(0x1093-0x76D1)"},
{0x1093, 0xC4C4, 0x1093, 0x76D8, "PXIe-4081(0x1093-0x76D8)"},
{0x1093, 0xC4C4, 0x1093, 0x76D9, "PXIe-4082(0x1093-0x76D9)"},
{0x1093, 0xC4C4, 0x1093, 0x76DC, "PXIe-4610(0x1093-0x76DC)"},
{0x1093, 0xC4C4, 0x1093, 0x76EC, "PXIe-2524(0x1093-0x76EC)"},
{0x1093, 0xC4C4, 0x1093, 0x76ED, "PXIe-2525(0x1093-0x76ED)"},
{0x1093, 0xC4C4, 0x1093, 0x76EE, "PXIe-2526(0x1093-0x76EE)"},
{0x1093, 0xC4C4, 0x1093, 0x76EF, "PXIe-2737(0x1093-0x76EF)"},
{0x1093, 0xC4C4, 0x1093, 0x76F0, "PXIe-2738(0x1093-0x76F0)"},
{0x1093, 0xC4C4, 0x1093, 0x76F1, "PXIe-2739(0x1093-0x76F1)"},
{0x1093, 0xC4C4, 0x1093, 0x76FB, "PCIe-1473R-LX110(0x1093-0x76FB)"},
{0x1093, 0xC4C4, 0x1093, 0x76FC, "PXIe-5105(0x1093-0x76FC)"},
{0x1093, 0xC4C4, 0x1093, 0x76FD, "PXIe-5114(0x1093-0x76FD)"},
{0x1093, 0xC4C4, 0x1093, 0x76FE, "PXIe-5644R(0x1093-0x76FE)"},
{0x1093, 0xC4C4, 0x1093, 0x76FF, "PXIe-5644R(0x1093-0x76FF)"},
{0x1093, 0xC4C4, 0x1093, 0x7700, "PXIe-5644R(0x1093-0x7700)"},
{0x1093, 0xC4C4, 0x1093, 0x7701, "PXIe-5645R(0x1093-0x7701)"},
{0x1093, 0xC4C4, 0x1093, 0x7702, "PXIe-5645R(0x1093-0x7702)"},
{0x1093, 0xC4C4, 0x1093, 0x7703, "PXIe-5645R(0x1093-0x7703)"},
{0x1093, 0xC4C4, 0x1093, 0x770C, "PXIe-4139(0x1093-0x770C)"},
{0x1093, 0xC4C4, 0x1093, 0x7711, "PXIe-4464(0x1093-0x7711)"},
{0x1093, 0xC4C4, 0x1093, 0x7712, "PXIe-4463(0x1093-0x7712)"},
{0x1093, 0xC4C4, 0x1093, 0x7716, "PCIe-6612(0x1093-0x7716)"},
{0x1093, 0xC4C4, 0x1093, 0x771D, "Unconfigured CA4 Switch(0x1093-0x771D)"},
{0x1093, 0xC4C4, 0x1093, 0x771E, "PXIe-4339(0x1093-0x771E)"},
{0x1093, 0xC4C4, 0x1093, 0x7735, "cRIO-9033(0x1093-0x7735)"},
{0x1093, 0xC4C4, 0x1093, 0x773E, "PXIe-5624R(0x1093-0x773E)"},
{0x1093, 0xC4C4, 0x1093, 0x774B, "cRIO-9031(0x1093-0x774B)"},
{0x1093, 0xC4C4, 0x1093, 0x774D, "cRIO-9034(0x1093-0x774D)"},
{0x1093, 0xC4C4, 0x1093, 0x7755, "cRIO-9030(0x1093-0x7755)"},
{0x1093, 0xC4C4, 0x1093, 0x7768, "PXIe-2747(0x1093-0x7768)"},
{0x1093, 0xC4C4, 0x1093, 0x7769, "PXIe-2748(0x1093-0x7769)"},
{0x1093, 0xC4C4, 0x1093, 0x776A, "PXIe-2746(0x1093-0x776A)"},
{0x1093, 0xC4C4, 0x1093, 0x7777, "PXIe-7976R(0x1093-0x7777)"},
{0x1093, 0xC4C4, 0x1093, 0x7782, "PXIe-5646R(0x1093-0x7782)"},
{0x1093, 0xC4C4, 0x1093, 0x7783, "PXIe-5646R(0x1093-0x7783)"},
{0x1093, 0xC4C4, 0x1093, 0x7784, "PXIe-5646R(0x1093-0x7784)"},
{0x1093, 0xC4C4, 0x1093, 0x7790, "PXIe-5170R (4CH)(0x1093-0x7790)"},
{0x1093, 0xC4C4, 0x1093, 0x7791, "PXIe-5170R (8CH)(0x1093-0x7791)"},
{0x1093, 0xC4C4, 0x1093, 0x7793, "PXIe-5171R (8CH)(0x1093-0x7793)"},
{0x1093, 0xC4C4, 0x1093, 0x7794, "PXIe-5172 (4CH - 325T)(0x1093-0x7794)"},
{0x1093, 0xC4C4, 0x1093, 0x7795, "PXIe-5172 (8CH - 410T)(0x1093-0x7795)"},
{0x1093, 0xC4C4, 0x1093, 0x77A5, "PXIe-6345(0x1093-0x77A5)"},
{0x1093, 0xC4C4, 0x1093, 0x77A6, "PXIe-6355(0x1093-0x77A6)"},
{0x1093, 0xC4C4, 0x1093, 0x77A7, "PXIe-6365(0x1093-0x77A7)"},
{0x1093, 0xC4C4, 0x1093, 0x77A8, "PXIe-6375(0x1093-0x77A8)"},
{0x1093, 0xC4C4, 0x1093, 0x77AA, "CVS-1458(0x1093-0x77AA)"},
{0x1093, 0xC4C4, 0x1093, 0x77AD, "IC-3173(0x1093-0x77AD)"},
{0x1093, 0xC4C4, 0x1093, 0x77B4, "PXIe-7820R(0x1093-0x77B4)"},
{0x1093, 0xC4C4, 0x1093, 0x77B5, "PXIe-7821R(0x1093-0x77B5)"},
{0x1093, 0xC4C4, 0x1093, 0x77B6, "PXIe-7822R(0x1093-0x77B6)"},
{0x1093, 0xC4C4, 0x1093, 0x77B9, "cRIO-9038(0x1093-0x77B9)"},
{0x1093, 0xC4C4, 0x1093, 0x77BA, "PXIe-4136(0x1093-0x77BA)"},
{0x1093, 0xC4C4, 0x1093, 0x77BB, "PXIe-4137(0x1093-0x77BB)"},
{0x1093, 0xC4C4, 0x1093, 0x77C0, "PXIe-5624R(0x1093-0x77C0)"},
{0x1093, 0xC4C4, 0x1093, 0x77C1, "PXIe-5624R(0x1093-0x77C1)"},
{0x1093, 0xC4C4, 0x1093, 0x77C2, "PXIe-5624R(0x1093-0x77C2)"},
{0x1093, 0xC4C4, 0x1093, 0x77CA, "PXIe-6738(0x1093-0x77CA)"},
{0x1093, 0xC4C4, 0x1093, 0x77CB, "PXIe-6739(0x1093-0x77CB)"},
{0x1093, 0xC4C4, 0x1093, 0x77DB, "cRIO-9035(0x1093-0x77DB)"},
{0x1093, 0xC4C4, 0x1093, 0x77DC, "cRIO-9036(0x1093-0x77DC)"},
{0x1093, 0xC4C4, 0x1093, 0x77DD, "cRIO-9039(0x1093-0x77DD)"},
{0x1093, 0xC4C4, 0x1093, 0x7802, "PXIe-4302(0x1093-0x7802)"},
{0x1093, 0xC4C4, 0x1093, 0x7803, "PXIe-4303(0x1093-0x7803)"},
{0x1093, 0xC4C4, 0x1093, 0x7805, "PXIe-4305(0x1093-0x7805)"},
{0x1093, 0xC4C4, 0x1093, 0x781E, "PXIe-4135(0x1093-0x781E)"},
{0x1093, 0xC4C4, 0x1093, 0x7820, "PXIe-5164(0x1093-0x7820)"},
{0x1093, 0xC4C4, 0x1093, 0x783D, "PXIe-6570(0x1093-0x783D)"},
{0x1093, 0xC4C4, 0x1093, 0x7851, "PXIe-5172 (8CH - 325T)(0x1093-0x7851)"},
{0x1093, 0xC4C4, 0x1093, 0x786F, "PXIe-4163(0x1093-0x786F)"},
{0x1093, 0xC4C4, 0x1093, 0x7881, "PXIe-5163(0x1093-0x7881)"},
{0x1093, 0xC4C4, 0x1093, 0x788E, "PXIe-4304(0x1093-0x788E)"},
{0x1093, 0xC4C4, 0x1093, 0x78D5, "PXIe-5413 (1CH)(0x1093-0x78D5)"},
{0x1093, 0xC4C4, 0x1093, 0x78D6, "PXIe-5413 (2CH)(0x1093-0x78D6)"},
{0x1093, 0xC4C4, 0x1093, 0x78D7, "PXIe-5423 (1CH)(0x1093-0x78D7)"},
{0x1093, 0xC4C4, 0x1093, 0x78D8, "PXIe-5423 (2CH)(0x1093-0x78D8)"},
{0x1093, 0xC4C4, 0x1093, 0x78D9, "PXIe-5433 (1CH)(0x1093-0x78D9)"},
{0x1093, 0xC4C4, 0x1093, 0x78DA, "NI PXIe-5433 (2CH)(0x1093-0x78DA)"},
{0x1093, 0xC4C4, 0x1093, 0x78F8, "NI FlexRIO Module (KU035)(0x1093-0x78F8)"},
{0x1093, 0xC4C4, 0x1093, 0x78F9, "NI FlexRIO Module (KU040)(0x1093-0x78F9)"},
{0x1093, 0xC4C4, 0x1093, 0x78FA, "NI FlexRIO Module (KU060)(0x1093-0x78FA)"},
{0x1093, 0xC4C4, 0x1093, 0x78FF, "PXIe-4162(0x1093-0x78FF)"},
{0x1093, 0xC4C4, 0x1093, 0x792F, "PXIe-4190(0x1093-0x792F)"},
{0x1093, 0xC4C4, 0x1093, 0x7935, "PXIe-5111(0x1093-0x7935)"},
{0x1093, 0xC4C4, 0x1093, 0x7936, "PXIe-5110(0x1093-0x7936)"},
{0x1093, 0xC4C4, 0x1093, 0x7995, "PXIe-7911R(0x1093-0x7995)"},
{0x1093, 0xC4C4, 0x1093, 0x7996, "PXIe-7912R(0x1093-0x7996)"},
{0x1093, 0xC4C4, 0x1093, 0x7997, "PXIe-7915R(0x1093-0x7997)"},
{0x1093, 0xC4C4, 0x1093, 0x79CD, "PXIe-5113(0x1093-0x79CD)"},
{0x1093, 0xC4C4, 0x1093, 0x79D3, "NI FlexRIO PCIe Module (KU035)(0x1093-0x79D3)"},
{0x1093, 0xC4C4, 0x1093, 0x79D4, "NI FlexRIO PCIe Module (KU040)(0x1093-0x79D4)"},
{0x1093, 0xC4C4, 0x1093, 0x79D5, "NI FlexRIO PCIe Module (KU060)(0x1093-0x79D5)"},
{0x1093, 0xC4C4, 0x1093, 0x79F8, "PXIe-6571(0x1093-0x79F8)"},
{0x1093, 0xC4C4, 0x1093, 0x7A16, "PXIe-4147(0x1093-0x7A16)"},
{0x1093, 0xC4C4, 0x1093, 0x7A9A, "PXIe-4137 (40W)(0x1093-0x7A9A)"},
{0x1093, 0xC4C4, 0x1093, 0x7AA4, "PXIe-4135 (40W)(0x1093-0x7AA4)"},
{0x1093, 0xC4C4, 0x1093, 0x7ACA, "PXIe-4051(0x1093-0x7ACA)"},
{0x1093, 0xC4C4, 0x1093, 0x7ACB, "PXIe-4150(0x1093-0x7ACB)"},
{0x1093, 0xC4C4, 0x1093, 0x7ACC, "PXIe-4151(0x1093-0x7ACC)"},
{0x1093, 0xC4C4, 0x1093, 0x7AE0, "PXIe-4163 (10 pA)(0x1093-0x7AE0)"},
{0x1093, 0xC4C4, 0x1093, 0x7AE1, "PXIe-4162 (10 pA)(0x1093-0x7AE1)"},
{0x1093, 0xC4C4, 0x1093, 0x7AEF, "PXIe-4190 (500 kHz)(0x1093-0x7AEF)"},
{0x1093, 0xC4C4, 0x1093, 0x7B1F, "PXIe-6571 (8CH)(0x1093-0x7B1F)"},
{0x1093, 0xC801, 0xFFFF, 0xFFFF, "PCI-GPIB(0xC801)"},
{0x1093, 0xC811, 0xFFFF, 0xFFFF, "PCI-GPIB+(0xC811)"},
{0x1093, 0xC821, 0xFFFF, 0xFFFF, "PXI-GPIB(0xC821)"},
{0x1093, 0xC831, 0xFFFF, 0xFFFF, "PMC-GPIB(0xC831)"},
{0x1093, 0xC840, 0xFFFF, 0xFFFF, "PCI-GPIB(0xC840)"},
{0x1093, 0xD130, 0xFFFF, 0xFFFF, "PCI-232/2 Interface(0xD130)"},
{0x1093, 0xD140, 0xFFFF, 0xFFFF, "PCI-232/4 Interface(0xD140)"},
{0x1093, 0xD150, 0xFFFF, 0xFFFF, "PCI-232/8 Interface(0xD150)"},
{0x1093, 0xD160, 0xFFFF, 0xFFFF, "PCI-485/2 Interface(0xD160)"},
{0x1093, 0xD170, 0xFFFF, 0xFFFF, "PCI-485/4 Interface(0xD170)"},
{0x1093, 0xD190, 0xFFFF, 0xFFFF, "PXI-8422/2 (Isolated RS-232) Interface(0xD190)"},
{0x1093, 0xD1A0, 0xFFFF, 0xFFFF, "PXI-8422/4 (Isolated RS-232) Interface(0xD1A0)"},
{0x1093, 0xD1B0, 0xFFFF, 0xFFFF, "PXI-8423/2 (Isolated RS-485) Interface(0xD1B0)"},
{0x1093, 0xD1C0, 0xFFFF, 0xFFFF, "PXI-8423/4 (Isolated RS-485) Interface(0xD1C0)"},
{0x1093, 0xD1D0, 0xFFFF, 0xFFFF, "PXI-8420/2 (RS-232) Interface(0xD1D0)"},
{0x1093, 0xD1E0, 0xFFFF, 0xFFFF, "PXI-8420/4 (RS-232) Interface(0xD1E0)"},
{0x1093, 0xD1F0, 0xFFFF, 0xFFFF, "PXI-8420/8 (RS-232) Interface(0xD1F0)"},
{0x1093, 0xD1F1, 0xFFFF, 0xFFFF, "PXI-8420/16 (RS-232) Interface(0xD1F1)"},
{0x1093, 0xD230, 0xFFFF, 0xFFFF, "PXI-8421/2 (RS-485) Interface(0xD230)"},
{0x1093, 0xD240, 0xFFFF, 0xFFFF, "PXI-8421/4 (RS-485) Interface(0xD240)"},
{0x1093, 0xD250, 0xFFFF, 0xFFFF, "PCI-232/2 (Isolated) Interface(0xD250)"},
{0x1093, 0xD260, 0xFFFF, 0xFFFF, "PCI-485/2 (Isolated) Interface(0xD260)"},
{0x1093, 0xD270, 0xFFFF, 0xFFFF, "PCI-232/4 (Isolated) Interface(0xD270)"},
{0x1093, 0xD280, 0xFFFF, 0xFFFF, "PCI-485/4 (Isolated) Interface(0xD280)"},
{0x1093, 0xD290, 0xFFFF, 0xFFFF, "PCI-485/8 Interface(0xD290)"},
{0x1093, 0xD2A0, 0xFFFF, 0xFFFF, "PXI-8421/8 (RS-485) Interface(0xD2A0)"},
{0x1093, 0xD2B0, 0xFFFF, 0xFFFF, "PCI-232/16 Interface(0xD2B0)"},
{0x1093, 0xE111, 0xFFFF, 0xFFFF, "PCI-CAN(0xE111)"},
{0x1093, 0xE131, 0xFFFF, 0xFFFF, "PXI-8461 (1 port)(0xE131)"},
{0x1093, 0xE141, 0xFFFF, 0xFFFF, "PCI-CAN/LS(0xE141)"},
{0x1093, 0xE151, 0xFFFF, 0xFFFF, "PXI-8460 (1 port)(0xE151)"},
{0x1093, 0xE211, 0xFFFF, 0xFFFF, "PCI-CAN/2(0xE211)"},
{0x1093, 0xE231, 0xFFFF, 0xFFFF, "PXI-8461 (2 ports)(0xE231)"},
{0x1093, 0xE241, 0xFFFF, 0xFFFF, "PCI-CAN/LS2(0xE241)"},
{0x1093, 0xE251, 0xFFFF, 0xFFFF, "PXI-8460 (2 ports)(0xE251)"},
{0x1093, 0xE261, 0xFFFF, 0xFFFF, "PCI-CAN/DS(0xE261)"},
{0x1093, 0xE271, 0xFFFF, 0xFFFF, "PXI-8462(0xE271)"},
{0x1093, 0xF110, 0xFFFF, 0xFFFF, "VMEpc-650(0xF110)"},
{0x1093, 0xF120, 0xFFFF, 0xFFFF, "VXIpc-650(0xF120)"},
{0x1093, 0xFE00, 0xFFFF, 0xFFFF, "VXIpc-87x(0xFE00)"},
{0x1093, 0xFE41, 0xFFFF, 0xFFFF, "VXIpc-860(0xFE41)"},
{0x1093, 0xFE51, 0xFFFF, 0xFFFF, "VXIpc-74x(0xFE51)"},
{0x1093, 0xFE61, 0xFFFF, 0xFFFF, "VXIpc-850(0xFE61)"},
{0x1093, 0xFE70, 0xFFFF, 0xFFFF, "VXIpc-880(0xFE70)"},
}; /* pci_vid_1093[] */

static pci_id_t const pci_vid_1094[] = {
{0x1094, 0xFFFF, 0xFFFF, 0xFFFF, "First International Computers [FIC](0x1094)"},
}; /* pci_vid_1094[] */

static pci_id_t const pci_vid_1095[] = {
{0x1095, 0xFFFF, 0xFFFF, 0xFFFF, "Silicon Image, Inc.(0x1095)"},
{0x1095, 0x0240, 0xFFFF, 0xFFFF, "Adaptec AAR-1210SA SATA HostRAID Controller(0x0240)"},
{0x1095, 0x0242, 0xFFFF, 0xFFFF, "AAR-1220SA SATA RAID Controller(0x0242)"},
{0x1095, 0x0640, 0xFFFF, 0xFFFF, "PCI0640(0x0640)"},
{0x1095, 0x0643, 0xFFFF, 0xFFFF, "PCI0643(0x0643)"},
{0x1095, 0x0646, 0xFFFF, 0xFFFF, "PCI0646(0x0646)"},
{0x1095, 0x0647, 0xFFFF, 0xFFFF, "PCI0647(0x0647)"},
{0x1095, 0x0648, 0xFFFF, 0xFFFF, "PCI0648(0x0648)"},
{0x1095, 0x0648, 0x1043, 0x8025, "CUBX motherboard(0x1043-0x8025)"},
{0x1095, 0x0649, 0xFFFF, 0xFFFF, "SiI 0649 Ultra ATA/100 PCI to ATA Host Controller(0x0649)"},
{0x1095, 0x0649, 0x0E11, 0x005D, "Integrated Ultra ATA-100 Dual Channel Controller(0x0E11-0x005D)"},
{0x1095, 0x0649, 0x0E11, 0x007E, "Integrated Ultra ATA-100 IDE RAID Controller(0x0E11-0x007E)"},
{0x1095, 0x0649, 0x101E, 0x0649, "AMI MegaRAID IDE 100 Controller(0x101E-0x0649)"},
{0x1095, 0x0650, 0xFFFF, 0xFFFF, "PBC0650A(0x0650)"},
{0x1095, 0x0670, 0xFFFF, 0xFFFF, "USB0670(0x0670)"},
{0x1095, 0x0670, 0x1095, 0x0670, "USB0670(0x1095-0x0670)"},
{0x1095, 0x0673, 0xFFFF, 0xFFFF, "USB0673(0x0673)"},
{0x1095, 0x0680, 0xFFFF, 0xFFFF, "PCI0680 Ultra ATA-133 Host Controller(0x0680)"},
{0x1095, 0x0680, 0x1095, 0x0680, "SiI 0680 ATA/133 Controller(0x1095-0x0680)"},
{0x1095, 0x0680, 0x1095, 0x3680, "Winic W-680 (Silicon Image 680 based)(0x1095-0x3680)"},
{0x1095, 0x3112, 0xFFFF, 0xFFFF, "SiI 3112 [SATALink/SATARaid] Serial ATA Controller(0x3112)"},
{0x1095, 0x3112, 0x1095, 0x3112, "SiI 3112 SATALink Controller(0x1095-0x3112)"},
{0x1095, 0x3112, 0x1095, 0x6112, "SiI 3112 SATARaid Controller(0x1095-0x6112)"},
{0x1095, 0x3112, 0x9005, 0x0250, "SATAConnect 1205SA Host Controller(0x9005-0x0250)"},
{0x1095, 0x3114, 0xFFFF, 0xFFFF, "SiI 3114 [SATALink/SATARaid] Serial ATA Controller(0x3114)"},
{0x1095, 0x3114, 0x1043, 0x8167, "A8N-SLI Deluxe/Premium Mainboard(0x1043-0x8167)"},
{0x1095, 0x3114, 0x1095, 0x3114, "SiI 3114 SATALink Controller(0x1095-0x3114)"},
{0x1095, 0x3114, 0x1095, 0x6114, "SiI 3114 SATARaid Controller(0x1095-0x6114)"},
{0x1095, 0x3124, 0xFFFF, 0xFFFF, "SiI 3124 PCI-X Serial ATA Controller(0x3124)"},
{0x1095, 0x3124, 0x1095, 0x3124, "SiI 3124 PCI-X Serial ATA Controller(0x1095-0x3124)"},
{0x1095, 0x3132, 0xFFFF, 0xFFFF, "SiI 3132 Serial ATA Raid II Controller(0x3132)"},
{0x1095, 0x3512, 0xFFFF, 0xFFFF, "SiI 3512 [SATALink/SATARaid] Serial ATA Controller(0x3512)"},
{0x1095, 0x3512, 0x1095, 0x3512, "SiI 3512 SATALink Controller(0x1095-0x3512)"},
{0x1095, 0x3512, 0x1095, 0x6512, "SiI 3512 SATARaid Controller(0x1095-0x6512)"},
{0x1095, 0x3531, 0xFFFF, 0xFFFF, "SiI 3531 [SATALink/SATARaid] Serial ATA Controller(0x3531)"},
{0x1095, 0x3531, 0x17C0, 0x4083, "Medion WIM 2210 Notebook PC [MD96850](0x17C0-0x4083)"},
}; /* pci_vid_1095[] */

static pci_id_t const pci_vid_1096[] = {
{0x1096, 0xFFFF, 0xFFFF, 0xFFFF, "Alacron(0x1096)"},
}; /* pci_vid_1096[] */

static pci_id_t const pci_vid_1097[] = {
{0x1097, 0xFFFF, 0xFFFF, 0xFFFF, "Appian Technology(0x1097)"},
}; /* pci_vid_1097[] */

static pci_id_t const pci_vid_1098[] = {
{0x1098, 0xFFFF, 0xFFFF, 0xFFFF, "Quantum Designs (H.K.) Ltd(0x1098)"},
{0x1098, 0x0001, 0xFFFF, 0xFFFF, "QD-8500(0x0001)"},
{0x1098, 0x0002, 0xFFFF, 0xFFFF, "QD-8580(0x0002)"},
}; /* pci_vid_1098[] */

static pci_id_t const pci_vid_1099[] = {
{0x1099, 0xFFFF, 0xFFFF, 0xFFFF, "Samsung Electronics Co., Ltd(0x1099)"},
}; /* pci_vid_1099[] */

static pci_id_t const pci_vid_109A[] = {
{0x109A, 0xFFFF, 0xFFFF, 0xFFFF, "Packard Bell(0x109A)"},
}; /* pci_vid_109A[] */

static pci_id_t const pci_vid_109B[] = {
{0x109B, 0xFFFF, 0xFFFF, 0xFFFF, "Gemlight Computer Ltd.(0x109B)"},
}; /* pci_vid_109B[] */

static pci_id_t const pci_vid_109C[] = {
{0x109C, 0xFFFF, 0xFFFF, 0xFFFF, "Megachips Corporation(0x109C)"},
}; /* pci_vid_109C[] */

static pci_id_t const pci_vid_109D[] = {
{0x109D, 0xFFFF, 0xFFFF, 0xFFFF, "Zida Technologies Ltd.(0x109D)"},
}; /* pci_vid_109D[] */

static pci_id_t const pci_vid_109E[] = {
{0x109E, 0xFFFF, 0xFFFF, 0xFFFF, "Brooktree Corporation(0x109E)"},
{0x109E, 0x0310, 0xFFFF, 0xFFFF, "Bt848 Video Capture(0x0310)"},
{0x109E, 0x032E, 0xFFFF, 0xFFFF, "Bt878 Video Capture(0x032E)"},
{0x109E, 0x0350, 0xFFFF, 0xFFFF, "Bt848 Video Capture(0x0350)"},
{0x109E, 0x0351, 0xFFFF, 0xFFFF, "Bt849A Video capture(0x0351)"},
{0x109E, 0x0369, 0xFFFF, 0xFFFF, "Bt878 Video Capture(0x0369)"},
{0x109E, 0x0369, 0x1002, 0x0001, "TV-Wonder(0x1002-0x0001)"},
{0x109E, 0x0369, 0x1002, 0x0003, "TV-Wonder/VE(0x1002-0x0003)"},
{0x109E, 0x036C, 0xFFFF, 0xFFFF, "Bt879(?-?-) Video Capture(0x036C)"},
{0x109E, 0x036C, 0x13E9, 0x0070, "Win/TV (Video Section)(0x13E9-0x0070)"},
{0x109E, 0x036E, 0xFFFF, 0xFFFF, "Bt878 Video Capture(0x036E)"},
{0x109E, 0x036E, 0x0000, 0x0001, "Euresys Picolo PCIe(0x0000-0x0001)"},
{0x109E, 0x036E, 0x0000, 0x0002, "Euresys PICOLO Pro 2(0x0000-0x0002)"},
{0x109E, 0x036E, 0x0000, 0x0004, "Euresys PICOLO Pro 3E(0x0000-0x0004)"},
{0x109E, 0x036E, 0x0070, 0x13EB, "WinTV Series(0x0070-0x13EB)"},
{0x109E, 0x036E, 0x0070, 0xFF01, "Viewcast Osprey 200(0x0070-0xFF01)"},
{0x109E, 0x036E, 0x0071, 0x0101, "DigiTV PCI(0x0071-0x0101)"},
{0x109E, 0x036E, 0x107D, 0x6606, "WinFast TV 2000(0x107D-0x6606)"},
{0x109E, 0x036E, 0x11BD, 0x0012, "PCTV pro (TV + FM stereo receiver)(0x11BD-0x0012)"},
{0x109E, 0x036E, 0x11BD, 0x001C, "PCTV Sat (DBC receiver)(0x11BD-0x001C)"},
{0x109E, 0x036E, 0x127A, 0x0001, "Bt878 Mediastream Controller NTSC(0x127A-0x0001)"},
{0x109E, 0x036E, 0x127A, 0x0002, "Bt878 Mediastream Controller PAL BG(0x127A-0x0002)"},
{0x109E, 0x036E, 0x127A, 0x0003, "Bt878a Mediastream Controller PAL BG(0x127A-0x0003)"},
{0x109E, 0x036E, 0x127A, 0x0048, "Bt878/832 Mediastream Controller(0x127A-0x0048)"},
{0x109E, 0x036E, 0x144F, 0x3000, "MagicTView CPH060 - Video(0x144F-0x3000)"},
{0x109E, 0x036E, 0x1461, 0x0002, "TV98 Series (TV/No FM/Remote)(0x1461-0x0002)"},
{0x109E, 0x036E, 0x1461, 0x0003, "AverMedia UltraTV PCI 350(0x1461-0x0003)"},
{0x109E, 0x036E, 0x1461, 0x0004, "AVerTV WDM Video Capture(0x1461-0x0004)"},
{0x109E, 0x036E, 0x1461, 0x0761, "AverTV DVB-T(0x1461-0x0761)"},
{0x109E, 0x036E, 0x1461, 0x0771, "AverMedia AVerTV DVB-T 771(0x1461-0x0771)"},
{0x109E, 0x036E, 0x14F1, 0x0001, "Bt878 Mediastream Controller NTSC(0x14F1-0x0001)"},
{0x109E, 0x036E, 0x14F1, 0x0002, "Bt878 Mediastream Controller PAL BG(0x14F1-0x0002)"},
{0x109E, 0x036E, 0x14F1, 0x0003, "Bt878a Mediastream Controller PAL BG(0x14F1-0x0003)"},
{0x109E, 0x036E, 0x14F1, 0x0048, "Bt878/832 Mediastream Controller(0x14F1-0x0048)"},
{0x109E, 0x036E, 0x1805, 0x0101, "Euresys PICOLO Tetra(0x1805-0x0101)"},
{0x109E, 0x036E, 0x1805, 0x0102, "Euresys PICOLO Tetra(0x1805-0x0102)"},
{0x109E, 0x036E, 0x1805, 0x0103, "Euresys PICOLO Tetra(0x1805-0x0103)"},
{0x109E, 0x036E, 0x1805, 0x0104, "Euresys PICOLO Tetra(0x1805-0x0104)"},
{0x109E, 0x036E, 0x1805, 0x0105, "Euresys PICOLO Tetra(0x1805-0x0105)"},
{0x109E, 0x036E, 0x1805, 0x0106, "Euresys PICOLO Tetra(0x1805-0x0106)"},
{0x109E, 0x036E, 0x1805, 0x0107, "Euresys PICOLO Tetra(0x1805-0x0107)"},
{0x109E, 0x036E, 0x1805, 0x0108, "Euresys PICOLO Tetra(0x1805-0x0108)"},
{0x109E, 0x036E, 0x1805, 0x0201, "Euresys PICOLO Tetra-X(0x1805-0x0201)"},
{0x109E, 0x036E, 0x1805, 0x0202, "Euresys PICOLO Tetra-X(0x1805-0x0202)"},
{0x109E, 0x036E, 0x1805, 0x0203, "Euresys PICOLO Tetra-X(0x1805-0x0203)"},
{0x109E, 0x036E, 0x1805, 0x0204, "Euresys PICOLO Tetra-X(0x1805-0x0204)"},
{0x109E, 0x036E, 0x1805, 0x0401, "Euresys PICOLO Tymo(0x1805-0x0401)"},
{0x109E, 0x036E, 0x1805, 0x0402, "Euresys PICOLO Tymo(0x1805-0x0402)"},
{0x109E, 0x036E, 0x1805, 0x0403, "Euresys PICOLO Tymo(0x1805-0x0403)"},
{0x109E, 0x036E, 0x1805, 0x0404, "Euresys PICOLO Tymo(0x1805-0x0404)"},
{0x109E, 0x036E, 0x1805, 0x1001, "Euresys PICOLO Junior 4(0x1805-0x1001)"},
{0x109E, 0x036E, 0x1822, 0x0001, "VisionPlus DVB card(0x1822-0x0001)"},
{0x109E, 0x036E, 0x1851, 0x1850, "FlyVideo'98 - Video(0x1851-0x1850)"},
{0x109E, 0x036E, 0x1851, 0x1851, "FlyVideo II(0x1851-0x1851)"},
{0x109E, 0x036E, 0x1852, 0x1852, "FlyVideo'98 - Video (with FM Tuner)(0x1852-0x1852)"},
{0x109E, 0x036E, 0x18AC, 0xD500, "DViCO FusionHDTV5 Lite(0x18AC-0xD500)"},
{0x109E, 0x036E, 0x270F, 0xFC00, "Digitop DTT-1000(0x270F-0xFC00)"},
{0x109E, 0x036E, 0xAA00, 0x1460, "Spectra8 CardA Input0(0xAA00-0x1460)"},
{0x109E, 0x036E, 0xAA01, 0x1461, "Spectra8 CardA Input1(0xAA01-0x1461)"},
{0x109E, 0x036E, 0xAA02, 0x1462, "Spectra8 CardA Input2(0xAA02-0x1462)"},
{0x109E, 0x036E, 0xAA03, 0x1463, "Spectra8 CardA Input3(0xAA03-0x1463)"},
{0x109E, 0x036E, 0xAA04, 0x1464, "Spectra8 CardB Input0(0xAA04-0x1464)"},
{0x109E, 0x036E, 0xAA05, 0x1465, "Spectra8 CardB Input1(0xAA05-0x1465)"},
{0x109E, 0x036E, 0xAA06, 0x1466, "Spectra8 CardB Input2(0xAA06-0x1466)"},
{0x109E, 0x036E, 0xAA07, 0x1467, "Spectra8 CardB Input3(0xAA07-0x1467)"},
{0x109E, 0x036E, 0xAA08, 0x1468, "Spectra8 CardC Input0(0xAA08-0x1468)"},
{0x109E, 0x036E, 0xAA09, 0x1469, "Spectra8 CardC Input1(0xAA09-0x1469)"},
{0x109E, 0x036E, 0xAA0A, 0x146A, "Spectra8 CardC Input2(0xAA0A-0x146A)"},
{0x109E, 0x036E, 0xAA0B, 0x146B, "Spectra8 CardC Input3(0xAA0B-0x146B)"},
{0x109E, 0x036E, 0xAA0C, 0x146C, "Spectra8 CardD Input0(0xAA0C-0x146C)"},
{0x109E, 0x036E, 0xAA0D, 0x146D, "Spectra8 CardD Input1(0xAA0D-0x146D)"},
{0x109E, 0x036E, 0xAA0E, 0x146E, "Spectra8 CardD Input2(0xAA0E-0x146E)"},
{0x109E, 0x036E, 0xAA0F, 0x146F, "Spectra8 CardD Input3(0xAA0F-0x146F)"},
{0x109E, 0x036E, 0xBD11, 0x1200, "PCTV pro (TV + FM stereo receiver)(0xBD11-0x1200)"},
{0x109E, 0x036F, 0xFFFF, 0xFFFF, "Bt879 Video Capture(0x036F)"},
{0x109E, 0x036F, 0x127A, 0x0044, "Bt879 Video Capture NTSC(0x127A-0x0044)"},
{0x109E, 0x036F, 0x127A, 0x0122, "Bt879 Video Capture PAL I(0x127A-0x0122)"},
{0x109E, 0x036F, 0x127A, 0x0144, "Bt879 Video Capture NTSC(0x127A-0x0144)"},
{0x109E, 0x036F, 0x127A, 0x0222, "Bt879 Video Capture PAL BG(0x127A-0x0222)"},
{0x109E, 0x036F, 0x127A, 0x0244, "Bt879a Video Capture NTSC(0x127A-0x0244)"},
{0x109E, 0x036F, 0x127A, 0x0322, "Bt879 Video Capture NTSC(0x127A-0x0322)"},
{0x109E, 0x036F, 0x127A, 0x0422, "Bt879 Video Capture NTSC(0x127A-0x0422)"},
{0x109E, 0x036F, 0x127A, 0x1122, "Bt879 Video Capture PAL I(0x127A-0x1122)"},
{0x109E, 0x036F, 0x127A, 0x1222, "Bt879 Video Capture PAL BG(0x127A-0x1222)"},
{0x109E, 0x036F, 0x127A, 0x1322, "Bt879 Video Capture NTSC(0x127A-0x1322)"},
{0x109E, 0x036F, 0x127A, 0x1522, "Bt879a Video Capture PAL I(0x127A-0x1522)"},
{0x109E, 0x036F, 0x127A, 0x1622, "Bt879a Video Capture PAL BG(0x127A-0x1622)"},
{0x109E, 0x036F, 0x127A, 0x1722, "Bt879a Video Capture NTSC(0x127A-0x1722)"},
{0x109E, 0x036F, 0x14F1, 0x0044, "Bt879 Video Capture NTSC(0x14F1-0x0044)"},
{0x109E, 0x036F, 0x14F1, 0x0122, "Bt879 Video Capture PAL I(0x14F1-0x0122)"},
{0x109E, 0x036F, 0x14F1, 0x0144, "Bt879 Video Capture NTSC(0x14F1-0x0144)"},
{0x109E, 0x036F, 0x14F1, 0x0222, "Bt879 Video Capture PAL BG(0x14F1-0x0222)"},
{0x109E, 0x036F, 0x14F1, 0x0244, "Bt879a Video Capture NTSC(0x14F1-0x0244)"},
{0x109E, 0x036F, 0x14F1, 0x0322, "Bt879 Video Capture NTSC(0x14F1-0x0322)"},
{0x109E, 0x036F, 0x14F1, 0x0422, "Bt879 Video Capture NTSC(0x14F1-0x0422)"},
{0x109E, 0x036F, 0x14F1, 0x1122, "Bt879 Video Capture PAL I(0x14F1-0x1122)"},
{0x109E, 0x036F, 0x14F1, 0x1222, "Bt879 Video Capture PAL BG(0x14F1-0x1222)"},
{0x109E, 0x036F, 0x14F1, 0x1322, "Bt879 Video Capture NTSC(0x14F1-0x1322)"},
{0x109E, 0x036F, 0x14F1, 0x1522, "Bt879a Video Capture PAL I(0x14F1-0x1522)"},
{0x109E, 0x036F, 0x14F1, 0x1622, "Bt879a Video Capture PAL BG(0x14F1-0x1622)"},
{0x109E, 0x036F, 0x14F1, 0x1722, "Bt879a Video Capture NTSC(0x14F1-0x1722)"},
{0x109E, 0x036F, 0x1851, 0x1850, "FlyVideo'98 - Video(0x1851-0x1850)"},
{0x109E, 0x036F, 0x1851, 0x1851, "FlyVideo II(0x1851-0x1851)"},
{0x109E, 0x036F, 0x1852, 0x1852, "FlyVideo'98 - Video (with FM Tuner)(0x1852-0x1852)"},
{0x109E, 0x0370, 0xFFFF, 0xFFFF, "Bt880 Video Capture(0x0370)"},
{0x109E, 0x0370, 0x1851, 0x1850, "FlyVideo'98(0x1851-0x1850)"},
{0x109E, 0x0370, 0x1851, 0x1851, "FlyVideo'98 EZ - video(0x1851-0x1851)"},
{0x109E, 0x0370, 0x1852, 0x1852, "FlyVideo'98 (with FM Tuner)(0x1852-0x1852)"},
{0x109E, 0x0878, 0xFFFF, 0xFFFF, "Bt878 Audio Capture(0x0878)"},
{0x109E, 0x0878, 0x0000, 0x0001, "Euresys Picolo PCIe(0x0000-0x0001)"},
{0x109E, 0x0878, 0x0000, 0x0002, "Euresys PICOLO Pro 2 (Audio Section)(0x0000-0x0002)"},
{0x109E, 0x0878, 0x0000, 0x0004, "Euresys PICOLO Pro 3E (Audio Section)(0x0000-0x0004)"},
{0x109E, 0x0878, 0x0070, 0x13EB, "WinTV Series(0x0070-0x13EB)"},
{0x109E, 0x0878, 0x0070, 0xFF01, "Viewcast Osprey 200(0x0070-0xFF01)"},
{0x109E, 0x0878, 0x0071, 0x0101, "DigiTV PCI(0x0071-0x0101)"},
{0x109E, 0x0878, 0x1002, 0x0001, "TV-Wonder(0x1002-0x0001)"},
{0x109E, 0x0878, 0x1002, 0x0003, "TV-Wonder/VE(0x1002-0x0003)"},
{0x109E, 0x0878, 0x11BD, 0x0012, "PCTV pro (TV + FM stereo receiver, audio section)(0x11BD-0x0012)"},
{0x109E, 0x0878, 0x11BD, 0x001C, "PCTV Sat (DBC receiver)(0x11BD-0x001C)"},
{0x109E, 0x0878, 0x127A, 0x0001, "Bt878 Video Capture (Audio Section)(0x127A-0x0001)"},
{0x109E, 0x0878, 0x127A, 0x0002, "Bt878 Video Capture (Audio Section)(0x127A-0x0002)"},
{0x109E, 0x0878, 0x127A, 0x0003, "Bt878 Video Capture (Audio Section)(0x127A-0x0003)"},
{0x109E, 0x0878, 0x127A, 0x0048, "Bt878 Video Capture (Audio Section)(0x127A-0x0048)"},
{0x109E, 0x0878, 0x13E9, 0x0070, "Win/TV (Audio Section)(0x13E9-0x0070)"},
{0x109E, 0x0878, 0x144F, 0x3000, "MagicTView CPH060 - Audio(0x144F-0x3000)"},
{0x109E, 0x0878, 0x1461, 0x0002, "Avermedia PCTV98 Audio Capture(0x1461-0x0002)"},
{0x109E, 0x0878, 0x1461, 0x0003, "UltraTV PCI 350(0x1461-0x0003)"},
{0x109E, 0x0878, 0x1461, 0x0004, "AVerTV WDM Audio Capture(0x1461-0x0004)"},
{0x109E, 0x0878, 0x1461, 0x0761, "AVerTV DVB-T(0x1461-0x0761)"},
{0x109E, 0x0878, 0x1461, 0x0771, "AverMedia AVerTV DVB-T 771(0x1461-0x0771)"},
{0x109E, 0x0878, 0x14F1, 0x0001, "Bt878 Video Capture (Audio Section)(0x14F1-0x0001)"},
{0x109E, 0x0878, 0x14F1, 0x0002, "Bt878 Video Capture (Audio Section)(0x14F1-0x0002)"},
{0x109E, 0x0878, 0x14F1, 0x0003, "Bt878 Video Capture (Audio Section)(0x14F1-0x0003)"},
{0x109E, 0x0878, 0x14F1, 0x0048, "Bt878 Video Capture (Audio Section)(0x14F1-0x0048)"},
{0x109E, 0x0878, 0x1805, 0x0101, "Euresys PICOLO Tetra (Audio Section)(0x1805-0x0101)"},
{0x109E, 0x0878, 0x1805, 0x0102, "Euresys PICOLO Tetra (Audio Section)(0x1805-0x0102)"},
{0x109E, 0x0878, 0x1805, 0x0103, "Euresys PICOLO Tetra (Audio Section)(0x1805-0x0103)"},
{0x109E, 0x0878, 0x1805, 0x0104, "Euresys PICOLO Tetra (Audio Section)(0x1805-0x0104)"},
{0x109E, 0x0878, 0x1805, 0x0105, "Euresys PICOLO Tetra (Audio Section)(0x1805-0x0105)"},
{0x109E, 0x0878, 0x1805, 0x0106, "Euresys PICOLO Tetra (Audio Section)(0x1805-0x0106)"},
{0x109E, 0x0878, 0x1805, 0x0107, "Euresys PICOLO Tetra (Audio Section)(0x1805-0x0107)"},
{0x109E, 0x0878, 0x1805, 0x0108, "Euresys PICOLO Tetra (Audio Section)(0x1805-0x0108)"},
{0x109E, 0x0878, 0x1805, 0x0201, "Euresys PICOLO Tetra-X (Audio Section)(0x1805-0x0201)"},
{0x109E, 0x0878, 0x1805, 0x0202, "Euresys PICOLO Tetra-X (Audio Section)(0x1805-0x0202)"},
{0x109E, 0x0878, 0x1805, 0x0203, "Euresys PICOLO Tetra-X (Audio Section)(0x1805-0x0203)"},
{0x109E, 0x0878, 0x1805, 0x0204, "Euresys PICOLO Tetra-X (Audio Section)(0x1805-0x0204)"},
{0x109E, 0x0878, 0x1805, 0x0401, "Euresys PICOLO Tymo (Audio Section)(0x1805-0x0401)"},
{0x109E, 0x0878, 0x1805, 0x0402, "Euresys PICOLO Tymo (Audio Section)(0x1805-0x0402)"},
{0x109E, 0x0878, 0x1805, 0x0403, "Euresys PICOLO Tymo (Audio Section)(0x1805-0x0403)"},
{0x109E, 0x0878, 0x1805, 0x0404, "Euresys PICOLO Tymo (Audio Section)(0x1805-0x0404)"},
{0x109E, 0x0878, 0x1805, 0x1001, "Euresys PICOLO Junior 4 (Audio Section)(0x1805-0x1001)"},
{0x109E, 0x0878, 0x1822, 0x0001, "VisionPlus DVB Card(0x1822-0x0001)"},
{0x109E, 0x0878, 0x18AC, 0xD500, "DViCO FusionHDTV5 Lite(0x18AC-0xD500)"},
{0x109E, 0x0878, 0x270F, 0xFC00, "Digitop DTT-1000(0x270F-0xFC00)"},
{0x109E, 0x0878, 0xBD11, 0x1200, "PCTV pro (TV + FM stereo receiver, audio section)(0xBD11-0x1200)"},
{0x109E, 0x0879, 0xFFFF, 0xFFFF, "Bt879 Audio Capture(0x0879)"},
{0x109E, 0x0879, 0x127A, 0x0044, "Bt879 Video Capture (Audio Section)(0x127A-0x0044)"},
{0x109E, 0x0879, 0x127A, 0x0122, "Bt879 Video Capture (Audio Section)(0x127A-0x0122)"},
{0x109E, 0x0879, 0x127A, 0x0144, "Bt879 Video Capture (Audio Section)(0x127A-0x0144)"},
{0x109E, 0x0879, 0x127A, 0x0222, "Bt879 Video Capture (Audio Section)(0x127A-0x0222)"},
{0x109E, 0x0879, 0x127A, 0x0244, "Bt879 Video Capture (Audio Section)(0x127A-0x0244)"},
{0x109E, 0x0879, 0x127A, 0x0322, "Bt879 Video Capture (Audio Section)(0x127A-0x0322)"},
{0x109E, 0x0879, 0x127A, 0x0422, "Bt879 Video Capture (Audio Section)(0x127A-0x0422)"},
{0x109E, 0x0879, 0x127A, 0x1122, "Bt879 Video Capture (Audio Section)(0x127A-0x1122)"},
{0x109E, 0x0879, 0x127A, 0x1222, "Bt879 Video Capture (Audio Section)(0x127A-0x1222)"},
{0x109E, 0x0879, 0x127A, 0x1322, "Bt879 Video Capture (Audio Section)(0x127A-0x1322)"},
{0x109E, 0x0879, 0x127A, 0x1522, "Bt879 Video Capture (Audio Section)(0x127A-0x1522)"},
{0x109E, 0x0879, 0x127A, 0x1622, "Bt879 Video Capture (Audio Section)(0x127A-0x1622)"},
{0x109E, 0x0879, 0x127A, 0x1722, "Bt879 Video Capture (Audio Section)(0x127A-0x1722)"},
{0x109E, 0x0879, 0x14F1, 0x0044, "Bt879 Video Capture (Audio Section)(0x14F1-0x0044)"},
{0x109E, 0x0879, 0x14F1, 0x0122, "Bt879 Video Capture (Audio Section)(0x14F1-0x0122)"},
{0x109E, 0x0879, 0x14F1, 0x0144, "Bt879 Video Capture (Audio Section)(0x14F1-0x0144)"},
{0x109E, 0x0879, 0x14F1, 0x0222, "Bt879 Video Capture (Audio Section)(0x14F1-0x0222)"},
{0x109E, 0x0879, 0x14F1, 0x0244, "Bt879 Video Capture (Audio Section)(0x14F1-0x0244)"},
{0x109E, 0x0879, 0x14F1, 0x0322, "Bt879 Video Capture (Audio Section)(0x14F1-0x0322)"},
{0x109E, 0x0879, 0x14F1, 0x0422, "Bt879 Video Capture (Audio Section)(0x14F1-0x0422)"},
{0x109E, 0x0879, 0x14F1, 0x1122, "Bt879 Video Capture (Audio Section)(0x14F1-0x1122)"},
{0x109E, 0x0879, 0x14F1, 0x1222, "Bt879 Video Capture (Audio Section)(0x14F1-0x1222)"},
{0x109E, 0x0879, 0x14F1, 0x1322, "Bt879 Video Capture (Audio Section)(0x14F1-0x1322)"},
{0x109E, 0x0879, 0x14F1, 0x1522, "Bt879 Video Capture (Audio Section)(0x14F1-0x1522)"},
{0x109E, 0x0879, 0x14F1, 0x1622, "Bt879 Video Capture (Audio Section)(0x14F1-0x1622)"},
{0x109E, 0x0879, 0x14F1, 0x1722, "Bt879 Video Capture (Audio Section)(0x14F1-0x1722)"},
{0x109E, 0x0880, 0xFFFF, 0xFFFF, "Bt880 Audio Capture(0x0880)"},
{0x109E, 0x2115, 0xFFFF, 0xFFFF, "BtV 2115 Mediastream controller(0x2115)"},
{0x109E, 0x2125, 0xFFFF, 0xFFFF, "BtV 2125 Mediastream controller(0x2125)"},
{0x109E, 0x2164, 0xFFFF, 0xFFFF, "BtV 2164(0x2164)"},
{0x109E, 0x2165, 0xFFFF, 0xFFFF, "BtV 2165(0x2165)"},
{0x109E, 0x8230, 0xFFFF, 0xFFFF, "Bt8230 ATM Segment/Reassembly Ctrlr (SRC)(0x8230)"},
{0x109E, 0x8472, 0xFFFF, 0xFFFF, "Bt8472(0x8472)"},
{0x109E, 0x8474, 0xFFFF, 0xFFFF, "Bt8474(0x8474)"},
}; /* pci_vid_109E[] */

static pci_id_t const pci_vid_109F[] = {
{0x109F, 0xFFFF, 0xFFFF, 0xFFFF, "Trigem Computer Inc.(0x109F)"},
}; /* pci_vid_109F[] */

static pci_id_t const pci_vid_10A0[] = {
{0x10A0, 0xFFFF, 0xFFFF, 0xFFFF, "Meidensha Corporation(0x10A0)"},
}; /* pci_vid_10A0[] */

static pci_id_t const pci_vid_10A1[] = {
{0x10A1, 0xFFFF, 0xFFFF, 0xFFFF, "Juko Electronics Ind. Co. Ltd(0x10A1)"},
}; /* pci_vid_10A1[] */

static pci_id_t const pci_vid_10A2[] = {
{0x10A2, 0xFFFF, 0xFFFF, 0xFFFF, "Quantum Corporation(0x10A2)"},
}; /* pci_vid_10A2[] */

static pci_id_t const pci_vid_10A3[] = {
{0x10A3, 0xFFFF, 0xFFFF, 0xFFFF, "Everex Systems Inc(0x10A3)"},
}; /* pci_vid_10A3[] */

static pci_id_t const pci_vid_10A4[] = {
{0x10A4, 0xFFFF, 0xFFFF, 0xFFFF, "Globe Manufacturing Sales(0x10A4)"},
}; /* pci_vid_10A4[] */

static pci_id_t const pci_vid_10A5[] = {
{0x10A5, 0xFFFF, 0xFFFF, 0xFFFF, "Smart Link Ltd.(0x10A5)"},
{0x10A5, 0x3052, 0xFFFF, 0xFFFF, "SmartPCI562 56K Modem(0x3052)"},
{0x10A5, 0x5449, 0xFFFF, 0xFFFF, "SmartPCI561 modem(0x5449)"},
}; /* pci_vid_10A5[] */

static pci_id_t const pci_vid_10A6[] = {
{0x10A6, 0xFFFF, 0xFFFF, 0xFFFF, "Informtech Industrial Ltd.(0x10A6)"},
}; /* pci_vid_10A6[] */

static pci_id_t const pci_vid_10A7[] = {
{0x10A7, 0xFFFF, 0xFFFF, 0xFFFF, "Benchmarq Microelectronics(0x10A7)"},
}; /* pci_vid_10A7[] */

static pci_id_t const pci_vid_10A8[] = {
{0x10A8, 0xFFFF, 0xFFFF, 0xFFFF, "Sierra Semiconductor(0x10A8)"},
{0x10A8, 0x0000, 0xFFFF, 0xFFFF, "STB Horizon 64(0x0000)"},
}; /* pci_vid_10A8[] */

static pci_id_t const pci_vid_10A9[] = {
{0x10A9, 0xFFFF, 0xFFFF, 0xFFFF, "Silicon Graphics Intl. Corp.(0x10A9)"},
{0x10A9, 0x0001, 0xFFFF, 0xFFFF, "Crosstalk to PCI Bridge(0x0001)"},
{0x10A9, 0x0002, 0xFFFF, 0xFFFF, "Linc I/O controller(0x0002)"},
{0x10A9, 0x0003, 0xFFFF, 0xFFFF, "IOC3 I/O controller(0x0003)"},
{0x10A9, 0x0004, 0xFFFF, 0xFFFF, "O2 MACE(0x0004)"},
{0x10A9, 0x0005, 0xFFFF, 0xFFFF, "RAD Audio(0x0005)"},
{0x10A9, 0x0006, 0xFFFF, 0xFFFF, "HPCEX(0x0006)"},
{0x10A9, 0x0007, 0xFFFF, 0xFFFF, "RPCEX(0x0007)"},
{0x10A9, 0x0008, 0xFFFF, 0xFFFF, "DiVO VIP(0x0008)"},
{0x10A9, 0x0009, 0xFFFF, 0xFFFF, "AceNIC Gigabit Ethernet(0x0009)"},
{0x10A9, 0x0009, 0x10A9, 0x8002, "AceNIC Gigabit Ethernet(0x10A9-0x8002)"},
{0x10A9, 0x0010, 0xFFFF, 0xFFFF, "AMP Video I/O(0x0010)"},
{0x10A9, 0x0011, 0xFFFF, 0xFFFF, "GRIP(0x0011)"},
{0x10A9, 0x0012, 0xFFFF, 0xFFFF, "SGH PSHAC GSN(0x0012)"},
{0x10A9, 0x0208, 0xFFFF, 0xFFFF, "SSIM1 SAS Adapter(0x0208)"},
{0x10A9, 0x1001, 0xFFFF, 0xFFFF, "Magic Carpet(0x1001)"},
{0x10A9, 0x1002, 0xFFFF, 0xFFFF, "Lithium(0x1002)"},
{0x10A9, 0x1003, 0xFFFF, 0xFFFF, "Dual JPEG 1(0x1003)"},
{0x10A9, 0x1004, 0xFFFF, 0xFFFF, "Dual JPEG 2(0x1004)"},
{0x10A9, 0x1005, 0xFFFF, 0xFFFF, "Dual JPEG 3(0x1005)"},
{0x10A9, 0x1006, 0xFFFF, 0xFFFF, "Dual JPEG 4(0x1006)"},
{0x10A9, 0x1007, 0xFFFF, 0xFFFF, "Dual JPEG 5(0x1007)"},
{0x10A9, 0x1008, 0xFFFF, 0xFFFF, "Cesium(0x1008)"},
{0x10A9, 0x100A, 0xFFFF, 0xFFFF, "IOC4 I/O controller(0x100A)"},
{0x10A9, 0x1504, 0xFFFF, 0xFFFF, "SSIM1 Fibre Channel Adapter(0x1504)"},
{0x10A9, 0x2001, 0xFFFF, 0xFFFF, "Fibre Channel(0x2001)"},
{0x10A9, 0x2002, 0xFFFF, 0xFFFF, "ASDE(0x2002)"},
{0x10A9, 0x4001, 0xFFFF, 0xFFFF, "TIO-CE PCI Express Bridge(0x4001)"},
{0x10A9, 0x4002, 0xFFFF, 0xFFFF, "TIO-CE PCI Express Port(0x4002)"},
{0x10A9, 0x8001, 0xFFFF, 0xFFFF, "O2 1394(0x8001)"},
{0x10A9, 0x8002, 0xFFFF, 0xFFFF, "G-net NT(0x8002)"},
{0x10A9, 0x802B, 0xFFFF, 0xFFFF, "REACT external interrupt controller(0x802B)"},
}; /* pci_vid_10A9[] */

static pci_id_t const pci_vid_10AA[] = {
{0x10AA, 0xFFFF, 0xFFFF, 0xFFFF, "ACC Microelectronics(0x10AA)"},
{0x10AA, 0x0000, 0xFFFF, 0xFFFF, "ACCM 2188(0x0000)"},
{0x10AA, 0x2051, 0xFFFF, 0xFFFF, "2051 CPU bridge(0x2051)"},
{0x10AA, 0x5842, 0xFFFF, 0xFFFF, "2051 ISA bridge(0x5842)"},
}; /* pci_vid_10AA[] */

static pci_id_t const pci_vid_10AB[] = {
{0x10AB, 0xFFFF, 0xFFFF, 0xFFFF, "Digicom(0x10AB)"},
}; /* pci_vid_10AB[] */

static pci_id_t const pci_vid_10AC[] = {
{0x10AC, 0xFFFF, 0xFFFF, 0xFFFF, "Honeywell IAC(0x10AC)"},
}; /* pci_vid_10AC[] */

static pci_id_t const pci_vid_10AD[] = {
{0x10AD, 0xFFFF, 0xFFFF, 0xFFFF, "Winbond Electronics Corp / Symphony Labs(0x10AD)"},
{0x10AD, 0x0001, 0xFFFF, 0xFFFF, "W83769F(0x0001)"},
{0x10AD, 0x0003, 0xFFFF, 0xFFFF, "SL82C103(0x0003)"},
{0x10AD, 0x0005, 0xFFFF, 0xFFFF, "SL82C105(0x0005)"},
{0x10AD, 0x0103, 0xFFFF, 0xFFFF, "SL82c103(0x0103)"},
{0x10AD, 0x0105, 0xFFFF, 0xFFFF, "SL82C105/W83C55xF Bus Master IDE(0x0105)"},
{0x10AD, 0x0565, 0xFFFF, 0xFFFF, "W83C553F/554F ISA bridge(0x0565)"},
}; /* pci_vid_10AD[] */

static pci_id_t const pci_vid_10AE[] = {
{0x10AE, 0xFFFF, 0xFFFF, 0xFFFF, "Cornerstone Technology(0x10AE)"},
}; /* pci_vid_10AE[] */

static pci_id_t const pci_vid_10AF[] = {
{0x10AF, 0xFFFF, 0xFFFF, 0xFFFF, "Micro Computer Systems Inc(0x10AF)"},
}; /* pci_vid_10AF[] */

static pci_id_t const pci_vid_10B0[] = {
{0x10B0, 0xFFFF, 0xFFFF, 0xFFFF, "CardExpert Technology(0x10B0)"},
}; /* pci_vid_10B0[] */

static pci_id_t const pci_vid_10B1[] = {
{0x10B1, 0xFFFF, 0xFFFF, 0xFFFF, "Cabletron Systems Inc(0x10B1)"},
}; /* pci_vid_10B1[] */

static pci_id_t const pci_vid_10B2[] = {
{0x10B2, 0xFFFF, 0xFFFF, 0xFFFF, "Raytheon Company(0x10B2)"},
}; /* pci_vid_10B2[] */

static pci_id_t const pci_vid_10B3[] = {
{0x10B3, 0xFFFF, 0xFFFF, 0xFFFF, "Databook Inc(0x10B3)"},
{0x10B3, 0x3106, 0xFFFF, 0xFFFF, "DB87144(0x3106)"},
{0x10B3, 0xB106, 0xFFFF, 0xFFFF, "DB87144(0xB106)"},
}; /* pci_vid_10B3[] */

static pci_id_t const pci_vid_10B4[] = {
{0x10B4, 0xFFFF, 0xFFFF, 0xFFFF, "STB Systems Inc(0x10B4)"},
{0x10B4, 0x1B1D, 0xFFFF, 0xFFFF, "Velocity 128 3D(0x1B1D)"},
{0x10B4, 0x1B1D, 0x10B4, 0x237E, "Velocity 4400(0x10B4-0x237E)"},
}; /* pci_vid_10B4[] */

static pci_id_t const pci_vid_10B5[] = {
{0x10B5, 0xFFFF, 0xFFFF, 0xFFFF, "PLX Technology, Inc.(0x10B5)"},
{0x10B5, 0x0001, 0xFFFF, 0xFFFF, "i960 PCI bus interface(0x0001)"},
{0x10B5, 0x0557, 0xFFFF, 0xFFFF, "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge(0x0557)"},
{0x10B5, 0x0557, 0x10B5, 0x9030, "Digium Tormenta 2 T400P-SS7 or E400P-SS7 Quad T1 or E1 PCI card(0x10B5-0x9030)"},
{0x10B5, 0x1000, 0xFFFF, 0xFFFF, "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge(0x1000)"},
{0x10B5, 0x1000, 0x10B5, 0x9030, "ATCOM AT400P Quad T1 PCI card(0x10B5-0x9030)"},
{0x10B5, 0x1024, 0xFFFF, 0xFFFF, "Acromag, Inc. IndustryPack Carrier Card(0x1024)"},
{0x10B5, 0x1042, 0xFFFF, 0xFFFF, "Brandywine / jxi2, Inc. - PMC-SyncClock32, IRIG A & B, Nasa 36(0x1042)"},
{0x10B5, 0x106A, 0xFFFF, 0xFFFF, "Dual OX16C952 4 port serial adapter [Megawolf Romulus/4](0x106A)"},
{0x10B5, 0x1076, 0xFFFF, 0xFFFF, "VScom 800 8 port serial adaptor(0x1076)"},
{0x10B5, 0x1077, 0xFFFF, 0xFFFF, "VScom 400 4 port serial adaptor(0x1077)"},
{0x10B5, 0x1078, 0xFFFF, 0xFFFF, "VScom 210 2 port serial and 1 port parallel adaptor(0x1078)"},
{0x10B5, 0x1103, 0xFFFF, 0xFFFF, "VScom 200 2 port serial adaptor(0x1103)"},
{0x10B5, 0x1146, 0xFFFF, 0xFFFF, "VScom 010 1 port parallel adaptor(0x1146)"},
{0x10B5, 0x1147, 0xFFFF, 0xFFFF, "VScom 020 2 port parallel adaptor(0x1147)"},
{0x10B5, 0x2000, 0xFFFF, 0xFFFF, "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge(0x2000)"},
{0x10B5, 0x2000, 0x10B5, 0x9030, "ATCOM AE400P Quad E1 PCI card(0x10B5-0x9030)"},
{0x10B5, 0x2300, 0xFFFF, 0xFFFF, "Euresys DOMINO Gamma(0x2300)"},
{0x10B5, 0x2374, 0xFFFF, 0xFFFF, "Euresys DOMINO Alpha(0x2374)"},
{0x10B5, 0x2491, 0xFFFF, 0xFFFF, "Euresys GRABLINK Value(0x2491)"},
{0x10B5, 0x2493, 0xFFFF, 0xFFFF, "Euresys GRABLINK Expert(0x2493)"},
{0x10B5, 0x2540, 0xFFFF, 0xFFFF, "IXXAT CAN-Interface PC-I 04/PCI(0x2540)"},
{0x10B5, 0x2724, 0xFFFF, 0xFFFF, "Thales PCSM Security Card(0x2724)"},
{0x10B5, 0x3376, 0xFFFF, 0xFFFF, "Cosateq 4 Port CAN Card(0x3376)"},
{0x10B5, 0x4000, 0xFFFF, 0xFFFF, "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge(0x4000)"},
{0x10B5, 0x4000, 0x10B5, 0x9030, "Tormenta 3 Varion V400P/ATCOM TE400P Quad E1/T1/J1 PCI card(0x10B5-0x9030)"},
{0x10B5, 0x4001, 0xFFFF, 0xFFFF, "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge(0x4001)"},
{0x10B5, 0x4001, 0x10B5, 0x9030, "ATCOM A400PE Quad E1 PCI card(0x10B5-0x9030)"},
{0x10B5, 0x4002, 0xFFFF, 0xFFFF, "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge(0x4002)"},
{0x10B5, 0x4002, 0x10B5, 0x9030, "ATCOM A400PT Quad T1 PCI card(0x10B5-0x9030)"},
{0x10B5, 0x6140, 0xFFFF, 0xFFFF, "PCI6140 32-bit 33MHz PCI-to-PCI Bridge(0x6140)"},
{0x10B5, 0x6150, 0xFFFF, 0xFFFF, "PCI6150 32-bit 33MHz PCI-to-PCI Bridge(0x6150)"},
{0x10B5, 0x6152, 0xFFFF, 0xFFFF, "PCI6152 32-bit 66MHz PCI-to-PCI Bridge(0x6152)"},
{0x10B5, 0x6154, 0xFFFF, 0xFFFF, "PCI6154 64-bit 66MHz PCI-to-PCI Bridge(0x6154)"},
{0x10B5, 0x6254, 0xFFFF, 0xFFFF, "PCI6254 64-bit 66MHz PCI-to-PCI Bridge(0x6254)"},
{0x10B5, 0x6466, 0xFFFF, 0xFFFF, "PCI6466 64-bit 66MHz PCI-to-PCI Bridge(0x6466)"},
{0x10B5, 0x6520, 0xFFFF, 0xFFFF, "PCI6520 64-bit 133MHz PCI-X-to-PCI-X Bridge(0x6520)"},
{0x10B5, 0x6540, 0xFFFF, 0xFFFF, "PCI6540 64-bit 133MHz PCI-X-to-PCI-X Bridge(0x6540)"},
{0x10B5, 0x6540, 0x1775, 0x1100, "CR11 Single Board Computer(0x1775-0x1100)"},
{0x10B5, 0x6540, 0x4C53, 0x10E0, "PSL09 PrPMC(0x4C53-0x10E0)"},
{0x10B5, 0x6541, 0xFFFF, 0xFFFF, "PCI6540/6466 PCI-PCI bridge (non-transparent mode, primary side)(0x6541)"},
{0x10B5, 0x6541, 0x1775, 0x1100, "CR11 Single Board Computer(0x1775-0x1100)"},
{0x10B5, 0x6541, 0x4C53, 0x10E0, "PSL09 PrPMC(0x4C53-0x10E0)"},
{0x10B5, 0x6542, 0xFFFF, 0xFFFF, "PCI6540/6466 PCI-PCI bridge (non-transparent mode, secondary side)(0x6542)"},
{0x10B5, 0x6542, 0x1775, 0x1100, "CR11 Single Board Computer(0x1775-0x1100)"},
{0x10B5, 0x6542, 0x4C53, 0x10E0, "PSL09 PrPMC(0x4C53-0x10E0)"},
{0x10B5, 0x8111, 0xFFFF, 0xFFFF, "PEX 8111 PCI Express-to-PCI Bridge(0x8111)"},
{0x10B5, 0x8112, 0xFFFF, 0xFFFF, "PEX8112 x1 Lane PCI Express-to-PCI Bridge(0x8112)"},
{0x10B5, 0x8114, 0xFFFF, 0xFFFF, "PEX 8114 PCI Express-to-PCI/PCI-X Bridge(0x8114)"},
{0x10B5, 0x8311, 0xFFFF, 0xFFFF, "PEX8311 x1 Lane PCI Express-to-Generic Local Bus Bridge(0x8311)"},
{0x10B5, 0x8505, 0xFFFF, 0xFFFF, "PEX 8505 5-lane, 5-port PCI Express Switch(0x8505)"},
{0x10B5, 0x8508, 0xFFFF, 0xFFFF, "PEX 8508 8-lane, 5-port PCI Express Switch(0x8508)"},
{0x10B5, 0x8509, 0xFFFF, 0xFFFF, "PEX 8509 8-lane, 8-port PCI Express Switch(0x8509)"},
{0x10B5, 0x8512, 0xFFFF, 0xFFFF, "PEX 8512 12-lane, 5-port PCI Express Switch(0x8512)"},
{0x10B5, 0x8516, 0xFFFF, 0xFFFF, "PEX 8516  Versatile PCI Express Switch(0x8516)"},
{0x10B5, 0x8517, 0xFFFF, 0xFFFF, "PEX 8517 16-lane, 5-port PCI Express Switch(0x8517)"},
{0x10B5, 0x8518, 0xFFFF, 0xFFFF, "PEX 8518 16-lane, 5-port PCI Express Switch(0x8518)"},
{0x10B5, 0x8524, 0xFFFF, 0xFFFF, "PEX 8524 24-lane, 6-port PCI Express Switch(0x8524)"},
{0x10B5, 0x8525, 0xFFFF, 0xFFFF, "PEX 8525 24-lane, 5-port PCI Express Switch(0x8525)"},
{0x10B5, 0x8532, 0xFFFF, 0xFFFF, "PEX 8532  Versatile PCI Express Switch(0x8532)"},
{0x10B5, 0x8533, 0xFFFF, 0xFFFF, "PEX 8533 32-lane, 6-port PCI Express Switch(0x8533)"},
{0x10B5, 0x8547, 0xFFFF, 0xFFFF, "PEX 8547 48-lane, 3-port PCI Express Switch(0x8547)"},
{0x10B5, 0x8548, 0xFFFF, 0xFFFF, "PEX 8548 48-lane, 9-port PCI Express Switch(0x8548)"},
{0x10B5, 0x8603, 0xFFFF, 0xFFFF, "PEX 8603 3-lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8603)"},
{0x10B5, 0x8604, 0xFFFF, 0xFFFF, "PEX 8604 4-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8604)"},
{0x10B5, 0x8605, 0xFFFF, 0xFFFF, "PEX 8605 PCI Express 4-port Gen2 Switch(0x8605)"},
{0x10B5, 0x8606, 0xFFFF, 0xFFFF, "PEX 8606 6 Lane, 6 Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8606)"},
{0x10B5, 0x8608, 0xFFFF, 0xFFFF, "PEX 8608 8-lane, 8-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8608)"},
{0x10B5, 0x8609, 0xFFFF, 0xFFFF, "PEX 8609 8-lane, 8-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA(0x8609)"},
{0x10B5, 0x8612, 0xFFFF, 0xFFFF, "PEX 8612 12-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8612)"},
{0x10B5, 0x8613, 0xFFFF, 0xFFFF, "PEX 8613 12-lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8613)"},
{0x10B5, 0x8614, 0xFFFF, 0xFFFF, "PEX 8614 12-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8614)"},
{0x10B5, 0x8615, 0xFFFF, 0xFFFF, "PEX 8615 12-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA(0x8615)"},
{0x10B5, 0x8616, 0xFFFF, 0xFFFF, "PEX 8616 16-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8616)"},
{0x10B5, 0x8617, 0xFFFF, 0xFFFF, "PEX 8617 16-lane, 4-Port PCI Express Gen 2 (5.0 GT/s) Switch with P2P(0x8617)"},
{0x10B5, 0x8618, 0xFFFF, 0xFFFF, "PEX 8618 16-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8618)"},
{0x10B5, 0x8619, 0xFFFF, 0xFFFF, "PEX 8619 16-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch with DMA(0x8619)"},
{0x10B5, 0x8624, 0xFFFF, 0xFFFF, "PEX 8624 24-lane, 6-Port PCI Express Gen 2 (5.0 GT/s) Switch [ExpressLane](0x8624)"},
{0x10B5, 0x8624, 0x13A3, 0x1845, "DX1845 Acceleration Card(0x13A3-0x1845)"},
{0x10B5, 0x8625, 0xFFFF, 0xFFFF, "PEX 8625 24-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8625)"},
{0x10B5, 0x8632, 0xFFFF, 0xFFFF, "PEX 8632 32-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8632)"},
{0x10B5, 0x8636, 0xFFFF, 0xFFFF, "PEX 8636 36-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8636)"},
{0x10B5, 0x8647, 0xFFFF, 0xFFFF, "PEX 8647 48-Lane, 3-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8647)"},
{0x10B5, 0x8648, 0xFFFF, 0xFFFF, "PEX 8648 48-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8648)"},
{0x10B5, 0x8649, 0xFFFF, 0xFFFF, "PEX 8649 48-lane, 12-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8649)"},
{0x10B5, 0x8664, 0xFFFF, 0xFFFF, "PEX 8664 64-lane, 16-Port PCI Express Gen 2 (5.0 GT/s) Switch(0x8664)"},
{0x10B5, 0x8680, 0xFFFF, 0xFFFF, "PEX 8680 80-lane, 20-Port PCI Express Gen 2 (5.0 GT/s) Multi-Root Switch(0x8680)"},
{0x10B5, 0x8696, 0xFFFF, 0xFFFF, "PEX 8696 96-lane, 24-Port PCI Express Gen 2 (5.0 GT/s) Multi-Root Switch(0x8696)"},
{0x10B5, 0x8714, 0xFFFF, 0xFFFF, "PEX 8714 12-Lane, 5-Port PCI Express Gen 3 (8 GT/s) Switch(0x8714)"},
{0x10B5, 0x8717, 0xFFFF, 0xFFFF, "PEX 8717 16-lane, 8-Port PCI Express Gen 3 (8.0 GT/s) Switch with DMA(0x8717)"},
{0x10B5, 0x8718, 0xFFFF, 0xFFFF, "PEX 8718 16-Lane, 5-Port PCI Express Gen 3 (8.0 GT/s) Switch(0x8718)"},
{0x10B5, 0x8723, 0xFFFF, 0xFFFF, "PEX 8723 24-Lane, 6-Port PCI Express Gen 3 (8 GT/s) Switch(0x8723)"},
{0x10B5, 0x8724, 0xFFFF, 0xFFFF, "PEX 8724 24-Lane, 6-Port PCI Express Gen 3 (8 GT/s) Switch, 19 x 19mm FCBGA(0x8724)"},
{0x10B5, 0x8724, 0x4C52, 0x9234, "LRNV9324 2-port Built-in 8643 NVMe Exchange Adapter(0x4C52-0x9234)"},
{0x10B5, 0x8724, 0x4C52, 0x9524, "LRNV9524 2-port M.2 NVMe SSD Exchange Adapter(0x4C52-0x9524)"},
{0x10B5, 0x8725, 0xFFFF, 0xFFFF, "PEX 8725 24-Lane, 10-Port PCI Express Gen 3 (8.0 GT/s) Multi-Root Switch with DMA(0x8725)"},
{0x10B5, 0x8732, 0xFFFF, 0xFFFF, "PEX 8732 32-lane, 8-Port PCI Express Gen 3 (8.0 GT/s) Switch(0x8732)"},
{0x10B5, 0x8733, 0xFFFF, 0xFFFF, "PEX 8733 32-Lane, 19-Port PCI Express Gen 3 (8 GT/s) Switch(0x8733)"},
{0x10B5, 0x8734, 0xFFFF, 0xFFFF, "PEX 8734 32-lane, 8-Port PCI Express Gen 3 (8.0GT/s) Switch(0x8734)"},
{0x10B5, 0x8747, 0xFFFF, 0xFFFF, "PEX 8747 48-Lane, 5-Port PCI Express Gen 3 (8.0 GT/s) Switch(0x8747)"},
{0x10B5, 0x8747, 0x4C52, 0x9347, "LRNV9347L 2-port Built-in 8643 NVMe Switching Adapter(0x4C52-0x9347)"},
{0x10B5, 0x8747, 0x4C52, 0x9547, "LRNV9547 4-port M.2 NVMe SSD Exchange Adapter(0x4C52-0x9547)"},
{0x10B5, 0x8748, 0xFFFF, 0xFFFF, "PEX 8748 48-Lane, 12-Port PCI Express Gen 3 (8 GT/s) Switch, 27 x 27mm FCBGA(0x8748)"},
{0x10B5, 0x8749, 0xFFFF, 0xFFFF, "PEX 8749 48-Lane, 18-Port PCI Express Gen 3 (8.0 GT/s) Multi-Root Switch with DMA(0x8749)"},
{0x10B5, 0x8749, 0x4C52, 0x9349, "LRNV9349 8-port SFF-8643 NVMe SSD Exchange Adapter(0x4C52-0x9349)"},
{0x10B5, 0x8764, 0xFFFF, 0xFFFF, "PEX 8764 64-Lane, 16-Port PCI Express Gen 3 (8 GT/s) Switch(0x8764)"},
{0x10B5, 0x8780, 0xFFFF, 0xFFFF, "PEX 8780 80-Lane, 20-Port PCI Express Gen 3 (8 GT/s) Switch(0x8780)"},
{0x10B5, 0x8796, 0xFFFF, 0xFFFF, "PEX8796 96-Lane, 24-Port PCIe Gen 3 (8.0 GT/s) Switch(0x8796)"},
{0x10B5, 0x87A0, 0xFFFF, 0xFFFF, "PEX PCI Express Switch NT0 Port Link Interface(0x87A0)"},
{0x10B5, 0x87A1, 0xFFFF, 0xFFFF, "PEX PCI Express Switch NT1 Port Link Interface(0x87A1)"},
{0x10B5, 0x87B0, 0xFFFF, 0xFFFF, "PEX PCI Express Switch NT0 Port Virtual Interface(0x87B0)"},
{0x10B5, 0x87B0, 0x1093, 0x7761, "PXIe-8830mc(0x1093-0x7761)"},
{0x10B5, 0x87B1, 0xFFFF, 0xFFFF, "PEX PCI Express Switch NT1 Port Virtual Interface(0x87B1)"},
{0x10B5, 0x87D0, 0xFFFF, 0xFFFF, "PEX PCI Express Switch DMA interface(0x87D0)"},
{0x10B5, 0x9016, 0xFFFF, 0xFFFF, "PLX 9016 8-port serial controller(0x9016)"},
{0x10B5, 0x9030, 0xFFFF, 0xFFFF, "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge(0x9030)"},
{0x10B5, 0x9030, 0x10B5, 0x1205, "Becker & Hickl MSA-1000(0x10B5-0x1205)"},
{0x10B5, 0x9030, 0x10B5, 0x2695, "Hilscher CIF50-PB/DPS Profibus(0x10B5-0x2695)"},
{0x10B5, 0x9030, 0x10B5, 0x2862, "Alpermann+Velte PCL PCI LV (3V/5V): Timecode Reader Board(0x10B5-0x2862)"},
{0x10B5, 0x9030, 0x10B5, 0x2906, "Alpermann+Velte PCI TS (3V/5V): Time Synchronisation Board(0x10B5-0x2906)"},
{0x10B5, 0x9030, 0x10B5, 0x2940, "Alpermann+Velte PCL PCI D (3V/5V): Timecode Reader Board(0x10B5-0x2940)"},
{0x10B5, 0x9030, 0x10B5, 0x2977, "IXXAT iPC-I XC16/PCI CAN Board(0x10B5-0x2977)"},
{0x10B5, 0x9030, 0x10B5, 0x2978, "SH ARC-PCIu/SH ARC-PCI104/SH ARC-PCIe SOHARD ARCNET card(0x10B5-0x2978)"},
{0x10B5, 0x9030, 0x10B5, 0x3025, "Alpermann+Velte PCL PCI L (3V/5V): Timecode Reader Board(0x10B5-0x3025)"},
{0x10B5, 0x9030, 0x10B5, 0x3068, "Alpermann+Velte PCL PCI HD (3V/5V): Timecode Reader Board(0x10B5-0x3068)"},
{0x10B5, 0x9030, 0x10B5, 0x3463, "Alpermann+Velte PCL PCI D (v2) (3V/5V): Timecode Reader Board(0x10B5-0x3463)"},
{0x10B5, 0x9030, 0x10B5, 0x3591, "PLURA PCL PCI L (v2) (3.3V/5V): Time Code Reader Board(0x10B5-0x3591)"},
{0x10B5, 0x9030, 0x12FE, 0x0111, "CPCI-ASIO4 (ESD 4-port Serial Interface Board)(0x12FE-0x0111)"},
{0x10B5, 0x9030, 0x1369, 0x9C01, "VX222v2(0x1369-0x9C01)"},
{0x10B5, 0x9030, 0x1369, 0x9D01, "VX222-Mic(0x1369-0x9D01)"},
{0x10B5, 0x9030, 0x1369, 0x9D02, "VX222-Mic(0x1369-0x9D02)"},
{0x10B5, 0x9030, 0x1369, 0x9E01, "PCX924v2(0x1369-0x9E01)"},
{0x10B5, 0x9030, 0x1369, 0x9F01, "PCX924-Mic(0x1369-0x9F01)"},
{0x10B5, 0x9030, 0x1369, 0x9F02, "PCX924-Mic(0x1369-0x9F02)"},
{0x10B5, 0x9030, 0x1369, 0xA001, "PCX22v2(0x1369-0xA001)"},
{0x10B5, 0x9030, 0x1369, 0xA701, "LCM220v2(0x1369-0xA701)"},
{0x10B5, 0x9030, 0x1369, 0xA801, "LCM200(0x1369-0xA801)"},
{0x10B5, 0x9030, 0x1397, 0x3136, "4xS0-ISDN PCI Adapter(0x1397-0x3136)"},
{0x10B5, 0x9030, 0x1397, 0x3137, "S2M-E1-ISDN PCI Adapter(0x1397-0x3137)"},
{0x10B5, 0x9030, 0x1518, 0x0200, "ThinkIO-C(0x1518-0x0200)"},
{0x10B5, 0x9030, 0x15ED, 0x1002, "MCCS 8-port Serial Hot Swap(0x15ED-0x1002)"},
{0x10B5, 0x9030, 0x15ED, 0x1003, "MCCS 16-port Serial Hot Swap(0x15ED-0x1003)"},
{0x10B5, 0x9030, 0xE1C5, 0x0001, "TE1-PCI(0xE1C5-0x0001)"},
{0x10B5, 0x9030, 0xE1C5, 0x0005, "TA1-PCI(0xE1C5-0x0005)"},
{0x10B5, 0x9030, 0xE1C5, 0x0006, "TA1-PCI4(0xE1C5-0x0006)"},
{0x10B5, 0x9036, 0xFFFF, 0xFFFF, "9036(0x9036)"},
{0x10B5, 0x9050, 0xFFFF, 0xFFFF, "PCI <-> IOBus Bridge(0x9050)"},
{0x10B5, 0x9050, 0x103C, 0x10B0, "82350 PCI GPIB(0x103C-0x10B0)"},
{0x10B5, 0x9050, 0x10B5, 0x1067, "IXXAT CAN i165(0x10B5-0x1067)"},
{0x10B5, 0x9050, 0x10B5, 0x114E, "Wasco WITIO PCI168extended(0x10B5-0x114E)"},
{0x10B5, 0x9050, 0x10B5, 0x1169, "Wasco OPTOIO32standard 32 digital in, 32 digital out(0x10B5-0x1169)"},
{0x10B5, 0x9050, 0x10B5, 0x1171, "Becker & Hickl PMS-400(0x10B5-0x1171)"},
{0x10B5, 0x9050, 0x10B5, 0x1172, "IK220 (Heidenhain)(0x10B5-0x1172)"},
{0x10B5, 0x9050, 0x10B5, 0x1201, "Becker & Hickl SPC-6x0(0x10B5-0x1201)"},
{0x10B5, 0x9050, 0x10B5, 0x1202, "Becker & Hickl SPC-7x0(0x10B5-0x1202)"},
{0x10B5, 0x9050, 0x10B5, 0x1203, "Becker & Hickl MSA-300(0x10B5-0x1203)"},
{0x10B5, 0x9050, 0x10B5, 0x1206, "Becker & Hickl DCC-100(0x10B5-0x1206)"},
{0x10B5, 0x9050, 0x10B5, 0x120A, "Becker & Hickl STP-340(0x10B5-0x120A)"},
{0x10B5, 0x9050, 0x10B5, 0x2036, "SatPak GPS(0x10B5-0x2036)"},
{0x10B5, 0x9050, 0x10B5, 0x2221, "Alpermann+Velte PCL PCI LV: Timecode Reader Board(0x10B5-0x2221)"},
{0x10B5, 0x9050, 0x10B5, 0x2273, "SH ARC-PCI SOHARD ARCNET card(0x10B5-0x2273)"},
{0x10B5, 0x9050, 0x10B5, 0x2431, "Alpermann+Velte PCL PCI D: Timecode Reader Board(0x10B5-0x2431)"},
{0x10B5, 0x9050, 0x10B5, 0x2905, "Alpermann+Velte PCI TS: Time Synchronisation Board(0x10B5-0x2905)"},
{0x10B5, 0x9050, 0x10B5, 0x3196, "Goramo PLX200SYN sync serial card(0x10B5-0x3196)"},
{0x10B5, 0x9050, 0x10B5, 0x9050, "PCI-I04 PCI Passive PC/CAN Interface(0x10B5-0x9050)"},
{0x10B5, 0x9050, 0x11A9, 0x5334, "PDS4(0x11A9-0x5334)"},
{0x10B5, 0x9050, 0x12FE, 0x0001, "CAN-PCI/331 CAN bus controller(0x12FE-0x0001)"},
{0x10B5, 0x9050, 0x1369, 0x8901, "PCX11+ PCI(0x1369-0x8901)"},
{0x10B5, 0x9050, 0x1369, 0x8F01, "VX222(0x1369-0x8F01)"},
{0x10B5, 0x9050, 0x1369, 0x9401, "PCX924(0x1369-0x9401)"},
{0x10B5, 0x9050, 0x1369, 0x9501, "PCX22(0x1369-0x9501)"},
{0x10B5, 0x9050, 0x1498, 0x0362, "TPMC866 8 Channel Serial Card(0x1498-0x0362)"},
{0x10B5, 0x9050, 0x1522, 0x0001, "RockForce 4 Port V.90 Data/Fax/Voice Modem(0x1522-0x0001)"},
{0x10B5, 0x9050, 0x1522, 0x0002, "RockForce 2 Port V.90 Data/Fax/Voice Modem(0x1522-0x0002)"},
{0x10B5, 0x9050, 0x1522, 0x0003, "RockForce 6 Port V.90 Data/Fax/Voice Modem(0x1522-0x0003)"},
{0x10B5, 0x9050, 0x1522, 0x0004, "RockForce 8 Port V.90 Data/Fax/Voice Modem(0x1522-0x0004)"},
{0x10B5, 0x9050, 0x1522, 0x0010, "RockForce2000 4 Port V.90 Data/Fax/Voice Modem(0x1522-0x0010)"},
{0x10B5, 0x9050, 0x1522, 0x0020, "RockForce2000 2 Port V.90 Data/Fax/Voice Modem(0x1522-0x0020)"},
{0x10B5, 0x9050, 0x15ED, 0x1000, "Macrolink MCCS 8-port Serial(0x15ED-0x1000)"},
{0x10B5, 0x9050, 0x15ED, 0x1001, "Macrolink MCCS 16-port Serial(0x15ED-0x1001)"},
{0x10B5, 0x9050, 0x15ED, 0x1002, "Macrolink MCCS 8-port Serial Hot Swap(0x15ED-0x1002)"},
{0x10B5, 0x9050, 0x15ED, 0x1003, "Macrolink MCCS 16-port Serial Hot Swap(0x15ED-0x1003)"},
{0x10B5, 0x9050, 0x5654, 0x2036, "OpenSwitch 6 Telephony card(0x5654-0x2036)"},
{0x10B5, 0x9050, 0x5654, 0x3132, "OpenSwitch 12 Telephony card(0x5654-0x3132)"},
{0x10B5, 0x9050, 0x5654, 0x5634, "OpenLine4 Telephony Card(0x5654-0x5634)"},
{0x10B5, 0x9050, 0xD531, 0xC002, "PCIntelliCAN 2xSJA1000 CAN bus(0xD531-0xC002)"},
{0x10B5, 0x9050, 0xD84D, 0x4006, "EX-4006 1P(0xD84D-0x4006)"},
{0x10B5, 0x9050, 0xD84D, 0x4008, "EX-4008 1P EPP/ECP(0xD84D-0x4008)"},
{0x10B5, 0x9050, 0xD84D, 0x4014, "EX-4014 2P(0xD84D-0x4014)"},
{0x10B5, 0x9050, 0xD84D, 0x4018, "EX-4018 3P EPP/ECP(0xD84D-0x4018)"},
{0x10B5, 0x9050, 0xD84D, 0x4025, "EX-4025 1S(16C550) RS-232(0xD84D-0x4025)"},
{0x10B5, 0x9050, 0xD84D, 0x4027, "EX-4027 1S(16C650) RS-232(0xD84D-0x4027)"},
{0x10B5, 0x9050, 0xD84D, 0x4028, "EX-4028 1S(16C850) RS-232(0xD84D-0x4028)"},
{0x10B5, 0x9050, 0xD84D, 0x4036, "EX-4036 2S(16C650) RS-232(0xD84D-0x4036)"},
{0x10B5, 0x9050, 0xD84D, 0x4037, "EX-4037 2S(16C650) RS-232(0xD84D-0x4037)"},
{0x10B5, 0x9050, 0xD84D, 0x4038, "EX-4038 2S(16C850) RS-232(0xD84D-0x4038)"},
{0x10B5, 0x9050, 0xD84D, 0x4052, "EX-4052 1S(16C550) RS-422/485(0xD84D-0x4052)"},
{0x10B5, 0x9050, 0xD84D, 0x4053, "EX-4053 2S(16C550) RS-422/485(0xD84D-0x4053)"},
{0x10B5, 0x9050, 0xD84D, 0x4055, "EX-4055 4S(16C550) RS-232(0xD84D-0x4055)"},
{0x10B5, 0x9050, 0xD84D, 0x4058, "EX-4055 4S(16C650) RS-232(0xD84D-0x4058)"},
{0x10B5, 0x9050, 0xD84D, 0x4065, "EX-4065 8S(16C550) RS-232(0xD84D-0x4065)"},
{0x10B5, 0x9050, 0xD84D, 0x4068, "EX-4068 8S(16C650) RS-232(0xD84D-0x4068)"},
{0x10B5, 0x9050, 0xD84D, 0x4078, "EX-4078 2S(16C552) RS-232+1P(0xD84D-0x4078)"},
{0x10B5, 0x9052, 0xFFFF, 0xFFFF, "PCI9052 PCI <-> IOBus Bridge(0x9052)"},
{0x10B5, 0x9054, 0xFFFF, 0xFFFF, "PCI9054 32-bit 33MHz PCI <-> IOBus Bridge(0x9054)"},
{0x10B5, 0x9054, 0x10B5, 0x1171, "Becker & Hickl PMS-400A(0x10B5-0x1171)"},
{0x10B5, 0x9054, 0x10B5, 0x1208, "Becker & Hickl SPC-830(0x10B5-0x1208)"},
{0x10B5, 0x9054, 0x10B5, 0x120E, "Becker & Hickl SPC-930(0x10B5-0x120E)"},
{0x10B5, 0x9054, 0x10B5, 0x120F, "Becker & Hickl SPC-150(0x10B5-0x120F)"},
{0x10B5, 0x9054, 0x10B5, 0x1210, "Becker & Hickl DPC-230(0x10B5-0x1210)"},
{0x10B5, 0x9054, 0x10B5, 0x2455, "Wessex Techology PHIL-PCI(0x10B5-0x2455)"},
{0x10B5, 0x9054, 0x10B5, 0x2696, "Innes Corp AM Radcap card(0x10B5-0x2696)"},
{0x10B5, 0x9054, 0x10B5, 0x2717, "Innes Corp Auricon card(0x10B5-0x2717)"},
{0x10B5, 0x9054, 0x10B5, 0x2844, "Innes Corp TVS Encoder card(0x10B5-0x2844)"},
{0x10B5, 0x9054, 0x12C7, 0x4001, "Intel Dialogic DM/V960-4T1 PCI(0x12C7-0x4001)"},
{0x10B5, 0x9054, 0x12D9, 0x0002, "PCI Prosody Card rev 1.5(0x12D9-0x0002)"},
{0x10B5, 0x9054, 0x14B4, 0xD100, "Dektec DTA-100(0x14B4-0xD100)"},
{0x10B5, 0x9054, 0x14B4, 0xD114, "Dektec DTA-120(0x14B4-0xD114)"},
{0x10B5, 0x9054, 0x16DF, 0x0011, "PIKA PrimeNet MM PCI(0x16DF-0x0011)"},
{0x10B5, 0x9054, 0x16DF, 0x0012, "PIKA PrimeNet MM cPCI 8(0x16DF-0x0012)"},
{0x10B5, 0x9054, 0x16DF, 0x0013, "PIKA PrimeNet MM cPCI 8 (without CAS Signaling)(0x16DF-0x0013)"},
{0x10B5, 0x9054, 0x16DF, 0x0014, "PIKA PrimeNet MM cPCI 4(0x16DF-0x0014)"},
{0x10B5, 0x9054, 0x16DF, 0x0015, "PIKA Daytona MM(0x16DF-0x0015)"},
{0x10B5, 0x9054, 0x16DF, 0x0016, "PIKA InLine MM(0x16DF-0x0016)"},
{0x10B5, 0x9056, 0xFFFF, 0xFFFF, "PCI9056 32-bit 66MHz PCI <-> IOBus Bridge(0x9056)"},
{0x10B5, 0x9056, 0x10B5, 0x2979, "CellinkBlade 11 - CPCI board VoATM AAL1(0x10B5-0x2979)"},
{0x10B5, 0x9056, 0x10B5, 0x3268, "IXXAT iPC-I XC16/PCIe CAN Board(0x10B5-0x3268)"},
{0x10B5, 0x9056, 0x10B5, 0x3334, "Cambridge Pixel HPx Radar Input Card(0x10B5-0x3334)"},
{0x10B5, 0x9056, 0x10B5, 0x3352, "Alpermann+Velte PCL PCIe HD: Timecode Reader Board(0x10B5-0x3352)"},
{0x10B5, 0x9056, 0x10B5, 0x3353, "Alpermann+Velte PCL PCIe D: Timecode Reader Board(0x10B5-0x3353)"},
{0x10B5, 0x9056, 0x10B5, 0x3354, "Plura PCL PCIe LV: Timecode Reader Board(0x10B5-0x3354)"},
{0x10B5, 0x9056, 0x10B5, 0x3355, "Plura PCL PCIe L: Timecode Reader Board(0x10B5-0x3355)"},
{0x10B5, 0x9056, 0x10B5, 0x3415, "Plura PCIe TS: Time Synchronisation Board(0x10B5-0x3415)"},
{0x10B5, 0x9056, 0x10B5, 0x3493, "Plura PCL PCIe 3G: Timecode Reader Board(0x10B5-0x3493)"},
{0x10B5, 0x9056, 0x10B5, 0x3565, "Cambridge Pixel HPx Radar Output Card(0x10B5-0x3565)"},
{0x10B5, 0x9056, 0x1369, 0xC001, "LX6464ES(0x1369-0xC001)"},
{0x10B5, 0x9056, 0x1369, 0xC201, "LX1616ES(0x1369-0xC201)"},
{0x10B5, 0x9056, 0x14B4, 0xD10A, "DekTec DTA-110T(0x14B4-0xD10A)"},
{0x10B5, 0x9056, 0x14B4, 0xD128, "Dektec DTA-140(0x14B4-0xD128)"},
{0x10B5, 0x9056, 0x14B4, 0xD140, "Dektec DTA-140(0x14B4-0xD140)"},
{0x10B5, 0x9056, 0x1A0E, 0x006F, "Dektec DTA-111(0x1A0E-0x006F)"},
{0x10B5, 0x9060, 0xFFFF, 0xFFFF, "PCI9060 32-bit 33MHz PCI <-> IOBus Bridge(0x9060)"},
{0x10B5, 0x906D, 0xFFFF, 0xFFFF, "9060SD(0x906D)"},
{0x10B5, 0x906D, 0x125C, 0x0640, "Aries 16000P(0x125C-0x0640)"},
{0x10B5, 0x906E, 0xFFFF, 0xFFFF, "9060ES(0x906E)"},
{0x10B5, 0x9080, 0xFFFF, 0xFFFF, "PCI9080 32-bit; 33MHz PCI <-> IOBus Bridge(0x9080)"},
{0x10B5, 0x9080, 0x103C, 0x10EB, "(Agilent) E2777B 83K Series Optical Communication Interface(0x103C-0x10EB)"},
{0x10B5, 0x9080, 0x103C, 0x10EC, "(Agilent) E6978-66442 PCI CIC(0x103C-0x10EC)"},
{0x10B5, 0x9080, 0x10B5, 0x1123, "Sectra KK631 encryption board(0x10B5-0x1123)"},
{0x10B5, 0x9080, 0x10B5, 0x9080, "9080 [real subsystem ID not set](0x10B5-0x9080)"},
{0x10B5, 0x9080, 0x12D9, 0x0002, "PCI Prosody Card(0x12D9-0x0002)"},
{0x10B5, 0x9080, 0x12DF, 0x4422, "4422PCI [\"Do-All\" Telemetry Data Acquisition System](0x12DF-0x4422)"},
{0x10B5, 0x9080, 0x1369, 0x9601, "PCX822np(0x1369-0x9601)"},
{0x10B5, 0x9080, 0x1369, 0xA102, "PCX822v2(0x1369-0xA102)"},
{0x10B5, 0x9080, 0x1369, 0xA201, "PCX442(0x1369-0xA201)"},
{0x10B5, 0x9080, 0x1369, 0xA301, "LCM440v2(0x1369-0xA301)"},
{0x10B5, 0x9080, 0x1369, 0xA401, "VX822(0x1369-0xA401)"},
{0x10B5, 0x9080, 0x1369, 0xA402, "VX822v2(0x1369-0xA402)"},
{0x10B5, 0x9080, 0x1369, 0xA901, "LCM420(0x1369-0xA901)"},
{0x10B5, 0x9080, 0x1369, 0xAA01, "VX820v2(0x1369-0xAA01)"},
{0x10B5, 0x9080, 0x1517, 0x000B, "ECSG-1R3ADC-PMC Clock synthesizer(0x1517-0x000B)"},
{0x10B5, 0x9656, 0xFFFF, 0xFFFF, "PCI9656 PCI <-> IOBus Bridge(0x9656)"},
{0x10B5, 0x9656, 0x1517, 0x000F, "ECDR-GC314-PMC Receiver(0x1517-0x000F)"},
{0x10B5, 0x9656, 0x1885, 0x0700, "Tsunami FPGA PMC with Altera Stratix S40(0x1885-0x0700)"},
{0x10B5, 0x9656, 0x1885, 0x0701, "Tsunami FPGA PMC with Altera Stratix S30(0x1885-0x0701)"},
{0x10B5, 0x9712, 0xFFFF, 0xFFFF, "PEX9712 12-Lane, 5-Port PCIe Gen 3 (8.0 GT/s) ExpressFabric Switch(0x9712)"},
{0x10B5, 0x9733, 0xFFFF, 0xFFFF, "PEX 9733 33-lane, 9-port PCI Express Gen 3 (8.0 GT/s) Switch(0x9733)"},
{0x10B5, 0x9733, 0x1D49, 0x0001, "ThinkSystem 1610-4P NVMe Switch Adapter(0x1D49-0x0001)"},
{0x10B5, 0x9733, 0x1D49, 0x0002, "ThinkSystem 810-4P NVMe Switch Adapter(0x1D49-0x0002)"},
{0x10B5, 0x9749, 0xFFFF, 0xFFFF, "PEX 9749 49-lane, 13-port PCI Express Gen 3 (8.0 GT/s) Switch(0x9749)"},
{0x10B5, 0x9749, 0x1D49, 0x0004, "ThinkSystem 1610-8P NVMe Switch Adapter(0x1D49-0x0004)"},
{0x10B5, 0x9765, 0xFFFF, 0xFFFF, "PEX9765 65-Lane, 17-Port PCIe Gen 3 (8.0 GT/s) ExpressFabric Switch(0x9765)"},
{0x10B5, 0x9781, 0xFFFF, 0xFFFF, "PEX9781 81-Lane, 21-Port PCIe Gen 3 (8.0 GT/s) ExpressFabric Switch(0x9781)"},
{0x10B5, 0x9797, 0xFFFF, 0xFFFF, "PEX9781 97-Lane, 25-Port PCIe Gen 3 (8.0 GT/s) ExpressFabric Switch(0x9797)"},
{0x10B5, 0xA100, 0xFFFF, 0xFFFF, "Blackmagic Design DeckLink(0xA100)"},
{0x10B5, 0xBB04, 0xFFFF, 0xFFFF, "B&B 3PCIOSD1A Isolated PCI Serial(0xBB04)"},
{0x10B5, 0xC001, 0xFFFF, 0xFFFF, "CronyxOmega-PCI (8-port RS232)(0xC001)"},
{0x10B5, 0xD00D, 0xFFFF, 0xFFFF, "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge(0xD00D)"},
{0x10B5, 0xD00D, 0x10B5, 0x9030, "Digium Tormenta 2 T400P or E400P Quad T1 or E1 PCI card(0x10B5-0x9030)"},
{0x10B5, 0xD33D, 0xFFFF, 0xFFFF, "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge(0xD33D)"},
{0x10B5, 0xD33D, 0x10B5, 0x9030, "Tormenta 3 Varion V401PT Quad T1/J1 PCI card(0x10B5-0x9030)"},
{0x10B5, 0xD44D, 0xFFFF, 0xFFFF, "PCI9030 32-bit 33MHz PCI <-> IOBus Bridge(0xD44D)"},
{0x10B5, 0xD44D, 0x10B5, 0x17F6, "Allo CP100P/E 1-port E1/T1/J1 PCI/PCIe card(0x10B5-0x17F6)"},
{0x10B5, 0xD44D, 0x10B5, 0x17F7, "Allo CP400P/E 4-port E1/T1/J1 PCI/PCIe card(0x10B5-0x17F7)"},
{0x10B5, 0xD44D, 0x10B5, 0x17F8, "Allo CP200P/E 2-port E1/T1/J1 PCI/PCIe card(0x10B5-0x17F8)"},
{0x10B5, 0xD44D, 0x10B5, 0x9030, "Tormenta 3 Varion V401PE Quad E1 PCI card(0x10B5-0x9030)"},
}; /* pci_vid_10B5[] */

static pci_id_t const pci_vid_10B6[] = {
{0x10B6, 0xFFFF, 0xFFFF, 0xFFFF, "Madge Networks(0x10B6)"},
{0x10B6, 0x0001, 0xFFFF, 0xFFFF, "Smart 16/4 PCI Ringnode(0x0001)"},
{0x10B6, 0x0002, 0xFFFF, 0xFFFF, "Smart 16/4 PCI Ringnode Mk2(0x0002)"},
{0x10B6, 0x0002, 0x10B6, 0x0002, "Smart 16/4 PCI Ringnode Mk2(0x10B6-0x0002)"},
{0x10B6, 0x0002, 0x10B6, 0x0006, "16/4 CardBus Adapter(0x10B6-0x0006)"},
{0x10B6, 0x0003, 0xFFFF, 0xFFFF, "Smart 16/4 PCI Ringnode Mk3(0x0003)"},
{0x10B6, 0x0003, 0x0E11, 0xB0FD, "Compaq NC4621 PCI, 4/16, WOL(0x0E11-0xB0FD)"},
{0x10B6, 0x0003, 0x10B6, 0x0003, "Smart 16/4 PCI Ringnode Mk3(0x10B6-0x0003)"},
{0x10B6, 0x0003, 0x10B6, 0x0007, "Presto PCI Plus Adapter(0x10B6-0x0007)"},
{0x10B6, 0x0004, 0xFFFF, 0xFFFF, "Smart 16/4 PCI Ringnode Mk1(0x0004)"},
{0x10B6, 0x0006, 0xFFFF, 0xFFFF, "16/4 Cardbus Adapter(0x0006)"},
{0x10B6, 0x0006, 0x10B6, 0x0006, "16/4 CardBus Adapter(0x10B6-0x0006)"},
{0x10B6, 0x0007, 0xFFFF, 0xFFFF, "Presto PCI Adapter(0x0007)"},
{0x10B6, 0x0007, 0x10B6, 0x0007, "Presto PCI(0x10B6-0x0007)"},
{0x10B6, 0x0009, 0xFFFF, 0xFFFF, "Smart 100/16/4 PCI-HS Ringnode(0x0009)"},
{0x10B6, 0x0009, 0x10B6, 0x0009, "Smart 100/16/4 PCI-HS Ringnode(0x10B6-0x0009)"},
{0x10B6, 0x000A, 0xFFFF, 0xFFFF, "Token Ring 100/16/4 Ringnode/Ringrunner(0x000A)"},
{0x10B6, 0x000A, 0x10B6, 0x000A, "Token Ring 100/16/4 Ringnode/Ringrunner(0x10B6-0x000A)"},
{0x10B6, 0x000B, 0xFFFF, 0xFFFF, "16/4 CardBus Adapter Mk2(0x000B)"},
{0x10B6, 0x000B, 0x10B6, 0x0008, "16/4 CardBus Adapter Mk2(0x10B6-0x0008)"},
{0x10B6, 0x000B, 0x10B6, 0x000B, "16/4 Cardbus Adapter Mk2(0x10B6-0x000B)"},
{0x10B6, 0x000C, 0xFFFF, 0xFFFF, "RapidFire 3140V2 16/4 TR Adapter(0x000C)"},
{0x10B6, 0x000C, 0x10B6, 0x000C, "RapidFire 3140V2 16/4 TR Adapter(0x10B6-0x000C)"},
{0x10B6, 0x1000, 0xFFFF, 0xFFFF, "Collage 25/155 ATM Client Adapter(0x1000)"},
{0x10B6, 0x1001, 0xFFFF, 0xFFFF, "Collage 155 ATM Server Adapter(0x1001)"},
}; /* pci_vid_10B6[] */

static pci_id_t const pci_vid_10B7[] = {
{0x10B7, 0xFFFF, 0xFFFF, 0xFFFF, "3Com Corporation(0x10B7)"},
{0x10B7, 0x0001, 0xFFFF, 0xFFFF, "3c985 1000BaseSX (SX/TX)(0x0001)"},
{0x10B7, 0x0001, 0x9850, 0x0001, "3c985B-SX(0x9850-0x0001)"},
{0x10B7, 0x0013, 0xFFFF, 0xFFFF, "AR5212 802.11abg NIC (3CRDAG675)(0x0013)"},
{0x10B7, 0x0013, 0x10B7, 0x2031, "3CRDAG675 11a/b/g Wireless PCI Adapter(0x10B7-0x2031)"},
{0x10B7, 0x0910, 0xFFFF, 0xFFFF, "3C910-A01(0x0910)"},
{0x10B7, 0x1006, 0xFFFF, 0xFFFF, "MINI PCI type 3B Data Fax Modem(0x1006)"},
{0x10B7, 0x1007, 0xFFFF, 0xFFFF, "Mini PCI 56k Winmodem(0x1007)"},
{0x10B7, 0x1007, 0x10B7, 0x615B, "Mini PCI 56K Modem(0x10B7-0x615B)"},
{0x10B7, 0x1007, 0x10B7, 0x615C, "Mini PCI 56K Modem(0x10B7-0x615C)"},
{0x10B7, 0x1201, 0xFFFF, 0xFFFF, "3c982-TXM 10/100baseTX Dual Port A [Hydra](0x1201)"},
{0x10B7, 0x1202, 0xFFFF, 0xFFFF, "3c982-TXM 10/100baseTX Dual Port B [Hydra](0x1202)"},
{0x10B7, 0x1700, 0xFFFF, 0xFFFF, "3c940 10/100/1000Base-T [Marvell](0x1700)"},
{0x10B7, 0x1700, 0x1043, 0x80EB, "A7V600/P4P800/K8V motherboard(0x1043-0x80EB)"},
{0x10B7, 0x1700, 0x10B7, 0x0010, "3C940 Gigabit LOM Ethernet Adapter(0x10B7-0x0010)"},
{0x10B7, 0x1700, 0x10B7, 0x0020, "3C941 Gigabit LOM Ethernet Adapter(0x10B7-0x0020)"},
{0x10B7, 0x1700, 0x147B, 0x1407, "KV8-MAX3 motherboard(0x147B-0x1407)"},
{0x10B7, 0x3390, 0xFFFF, 0xFFFF, "3c339 TokenLink Velocity(0x3390)"},
{0x10B7, 0x3590, 0xFFFF, 0xFFFF, "3c359 TokenLink Velocity XL(0x3590)"},
{0x10B7, 0x3590, 0x10B7, 0x3590, "TokenLink Velocity XL Adapter (3C359/359B)(0x10B7-0x3590)"},
{0x10B7, 0x4500, 0xFFFF, 0xFFFF, "3c450 HomePNA [Tornado](0x4500)"},
{0x10B7, 0x5055, 0xFFFF, 0xFFFF, "3c555 Laptop Hurricane(0x5055)"},
{0x10B7, 0x5057, 0xFFFF, 0xFFFF, "3c575 Megahertz 10/100 LAN CardBus [Boomerang](0x5057)"},
{0x10B7, 0x5057, 0x10B7, 0x5A57, "3C575 Megahertz 10/100 LAN Cardbus PC Card(0x10B7-0x5A57)"},
{0x10B7, 0x5157, 0xFFFF, 0xFFFF, "3cCFE575BT Megahertz 10/100 LAN CardBus [Cyclone](0x5157)"},
{0x10B7, 0x5157, 0x10B7, 0x5B57, "3C575 Megahertz 10/100 LAN Cardbus PC Card(0x10B7-0x5B57)"},
{0x10B7, 0x5257, 0xFFFF, 0xFFFF, "3cCFE575CT CardBus [Cyclone](0x5257)"},
{0x10B7, 0x5257, 0x10B7, 0x5C57, "FE575C-3Com 10/100 LAN CardBus-Fast Ethernet(0x10B7-0x5C57)"},
{0x10B7, 0x5900, 0xFFFF, 0xFFFF, "3c590 10BaseT [Vortex](0x5900)"},
{0x10B7, 0x5920, 0xFFFF, 0xFFFF, "3c592 EISA 10mbps Demon/Vortex(0x5920)"},
{0x10B7, 0x5950, 0xFFFF, 0xFFFF, "3c595 100BaseTX [Vortex](0x5950)"},
{0x10B7, 0x5951, 0xFFFF, 0xFFFF, "3c595 100BaseT4 [Vortex](0x5951)"},
{0x10B7, 0x5952, 0xFFFF, 0xFFFF, "3c595 100Base-MII [Vortex](0x5952)"},
{0x10B7, 0x5970, 0xFFFF, 0xFFFF, "3c597 EISA Fast Demon/Vortex(0x5970)"},
{0x10B7, 0x5B57, 0xFFFF, 0xFFFF, "3c595 Megahertz 10/100 LAN CardBus [Boomerang](0x5B57)"},
{0x10B7, 0x5B57, 0x10B7, 0x5B57, "3C575 Megahertz 10/100 LAN Cardbus PC Card(0x10B7-0x5B57)"},
{0x10B7, 0x6000, 0xFFFF, 0xFFFF, "3CRSHPW796 [OfficeConnect Wireless CardBus](0x6000)"},
{0x10B7, 0x6001, 0xFFFF, 0xFFFF, "3com 3CRWE154G72 [Office Connect Wireless LAN Adapter](0x6001)"},
{0x10B7, 0x6055, 0xFFFF, 0xFFFF, "3c556 Hurricane CardBus [Cyclone](0x6055)"},
{0x10B7, 0x6056, 0xFFFF, 0xFFFF, "3c556B CardBus [Tornado](0x6056)"},
{0x10B7, 0x6056, 0x10B7, 0x6556, "10/100 Mini PCI Ethernet Adapter(0x10B7-0x6556)"},
{0x10B7, 0x6560, 0xFFFF, 0xFFFF, "3cCFE656 CardBus [Cyclone](0x6560)"},
{0x10B7, 0x6560, 0x10B7, 0x656A, "3CCFEM656 10/100 LAN+56K Modem CardBus(0x10B7-0x656A)"},
{0x10B7, 0x6561, 0xFFFF, 0xFFFF, "3cCFEM656 10/100 LAN+56K Modem CardBus(0x6561)"},
{0x10B7, 0x6561, 0x10B7, 0x656B, "3CCFEM656 10/100 LAN+56K Modem CardBus(0x10B7-0x656B)"},
{0x10B7, 0x6562, 0xFFFF, 0xFFFF, "3cCFEM656B 10/100 LAN+Winmodem CardBus [Cyclone](0x6562)"},
{0x10B7, 0x6562, 0x10B7, 0x656B, "3CCFEM656B 10/100 LAN+56K Modem CardBus(0x10B7-0x656B)"},
{0x10B7, 0x6563, 0xFFFF, 0xFFFF, "3cCFEM656B 10/100 LAN+56K Modem CardBus(0x6563)"},
{0x10B7, 0x6563, 0x10B7, 0x656B, "3CCFEM656 10/100 LAN+56K Modem CardBus(0x10B7-0x656B)"},
{0x10B7, 0x6564, 0xFFFF, 0xFFFF, "3cXFEM656C 10/100 LAN+Winmodem CardBus [Tornado](0x6564)"},
{0x10B7, 0x7646, 0xFFFF, 0xFFFF, "3cSOHO100-TX Hurricane(0x7646)"},
{0x10B7, 0x7770, 0xFFFF, 0xFFFF, "3CRWE777 PCI Wireless Adapter [Airconnect](0x7770)"},
{0x10B7, 0x7940, 0xFFFF, 0xFFFF, "3c803 FDDILink UTP Controller(0x7940)"},
{0x10B7, 0x7980, 0xFFFF, 0xFFFF, "3c804 FDDILink SAS Controller(0x7980)"},
{0x10B7, 0x7990, 0xFFFF, 0xFFFF, "3c805 FDDILink DAS Controller(0x7990)"},
{0x10B7, 0x80EB, 0xFFFF, 0xFFFF, "3c940B 10/100/1000Base-T(0x80EB)"},
{0x10B7, 0x8811, 0xFFFF, 0xFFFF, "Token ring(0x8811)"},
{0x10B7, 0x9000, 0xFFFF, 0xFFFF, "3c900 10BaseT [Boomerang](0x9000)"},
{0x10B7, 0x9001, 0xFFFF, 0xFFFF, "3c900 10Mbps Combo [Boomerang](0x9001)"},
{0x10B7, 0x9004, 0xFFFF, 0xFFFF, "3c900B-TPO Etherlink XL [Cyclone](0x9004)"},
{0x10B7, 0x9004, 0x10B7, 0x9004, "3C900B-TPO Etherlink XL TPO 10Mb(0x10B7-0x9004)"},
{0x10B7, 0x9005, 0xFFFF, 0xFFFF, "3c900B-Combo Etherlink XL [Cyclone](0x9005)"},
{0x10B7, 0x9005, 0x10B7, 0x9005, "3C900B-Combo Etherlink XL Combo(0x10B7-0x9005)"},
{0x10B7, 0x9006, 0xFFFF, 0xFFFF, "3c900B-TPC Etherlink XL [Cyclone](0x9006)"},
{0x10B7, 0x900A, 0xFFFF, 0xFFFF, "3c900B-FL 10base-FL [Cyclone](0x900A)"},
{0x10B7, 0x9050, 0xFFFF, 0xFFFF, "3c905 100BaseTX [Boomerang](0x9050)"},
{0x10B7, 0x9051, 0xFFFF, 0xFFFF, "3c905 100BaseT4 [Boomerang](0x9051)"},
{0x10B7, 0x9054, 0xFFFF, 0xFFFF, "3C905B-TX Fast Etherlink XL PCI(0x9054)"},
{0x10B7, 0x9054, 0x10B7, 0x9054, "3C905B-TX Fast Etherlink XL PCI(0x10B7-0x9054)"},
{0x10B7, 0x9055, 0xFFFF, 0xFFFF, "3c905B 100BaseTX [Cyclone](0x9055)"},
{0x10B7, 0x9055, 0x1028, 0x0080, "3C905B Fast Etherlink XL 10/100(0x1028-0x0080)"},
{0x10B7, 0x9055, 0x1028, 0x0081, "3C905B Fast Etherlink XL 10/100(0x1028-0x0081)"},
{0x10B7, 0x9055, 0x1028, 0x0082, "3C905B Fast Etherlink XL 10/100(0x1028-0x0082)"},
{0x10B7, 0x9055, 0x1028, 0x0083, "3C905B Fast Etherlink XL 10/100(0x1028-0x0083)"},
{0x10B7, 0x9055, 0x1028, 0x0084, "3C905B Fast Etherlink XL 10/100(0x1028-0x0084)"},
{0x10B7, 0x9055, 0x1028, 0x0085, "3C905B Fast Etherlink XL 10/100(0x1028-0x0085)"},
{0x10B7, 0x9055, 0x1028, 0x0086, "3C905B Fast Etherlink XL 10/100(0x1028-0x0086)"},
{0x10B7, 0x9055, 0x1028, 0x0087, "3C905B Fast Etherlink XL 10/100(0x1028-0x0087)"},
{0x10B7, 0x9055, 0x1028, 0x0088, "3C905B Fast Etherlink XL 10/100(0x1028-0x0088)"},
{0x10B7, 0x9055, 0x1028, 0x0089, "3C905B Fast Etherlink XL 10/100(0x1028-0x0089)"},
{0x10B7, 0x9055, 0x1028, 0x0090, "3C905B Fast Etherlink XL 10/100(0x1028-0x0090)"},
{0x10B7, 0x9055, 0x1028, 0x0091, "3C905B Fast Etherlink XL 10/100(0x1028-0x0091)"},
{0x10B7, 0x9055, 0x1028, 0x0092, "3C905B Fast Etherlink XL 10/100(0x1028-0x0092)"},
{0x10B7, 0x9055, 0x1028, 0x0093, "3C905B Fast Etherlink XL 10/100(0x1028-0x0093)"},
{0x10B7, 0x9055, 0x1028, 0x0094, "3C905B Fast Etherlink XL 10/100(0x1028-0x0094)"},
{0x10B7, 0x9055, 0x1028, 0x0095, "3C905B Fast Etherlink XL 10/100(0x1028-0x0095)"},
{0x10B7, 0x9055, 0x1028, 0x0096, "3C905B Fast Etherlink XL 10/100(0x1028-0x0096)"},
{0x10B7, 0x9055, 0x1028, 0x0097, "3C905B Fast Etherlink XL 10/100(0x1028-0x0097)"},
{0x10B7, 0x9055, 0x1028, 0x0098, "3C905B Fast Etherlink XL 10/100(0x1028-0x0098)"},
{0x10B7, 0x9055, 0x1028, 0x0099, "3C905B Fast Etherlink XL 10/100(0x1028-0x0099)"},
{0x10B7, 0x9055, 0x10B7, 0x9055, "3C905B Fast Etherlink XL 10/100(0x10B7-0x9055)"},
{0x10B7, 0x9056, 0xFFFF, 0xFFFF, "3c905B-T4 Fast EtherLink XL [Cyclone](0x9056)"},
{0x10B7, 0x9058, 0xFFFF, 0xFFFF, "3c905B Deluxe Etherlink 10/100/BNC [Cyclone](0x9058)"},
{0x10B7, 0x905A, 0xFFFF, 0xFFFF, "3c905B-FX Fast Etherlink XL FX 100baseFx [Cyclone](0x905A)"},
{0x10B7, 0x9200, 0xFFFF, 0xFFFF, "3c905C-TX/TX-M [Tornado](0x9200)"},
{0x10B7, 0x9200, 0x1028, 0x0095, "3C920 Integrated Fast Ethernet Controller(0x1028-0x0095)"},
{0x10B7, 0x9200, 0x1028, 0x0097, "3C920 Integrated Fast Ethernet Controller(0x1028-0x0097)"},
{0x10B7, 0x9200, 0x1028, 0x00B4, "OptiPlex GX110(0x1028-0x00B4)"},
{0x10B7, 0x9200, 0x1028, 0x00D8, "Precision 530(0x1028-0x00D8)"},
{0x10B7, 0x9200, 0x1028, 0x00FE, "Optiplex GX240(0x1028-0x00FE)"},
{0x10B7, 0x9200, 0x1028, 0x012A, "3C920 Integrated Fast Ethernet Controller [Latitude C640](0x1028-0x012A)"},
{0x10B7, 0x9200, 0x10B7, 0x1000, "3C905CX-TX/TX-M Fast Etherlink for PC Management NIC(0x10B7-0x1000)"},
{0x10B7, 0x9200, 0x10B7, 0x7000, "10/100 Mini PCI Ethernet Adapter(0x10B7-0x7000)"},
{0x10B7, 0x9200, 0x10F1, 0x2466, "Tiger MPX S2466 (3C920 Integrated Fast Ethernet Controller)(0x10F1-0x2466)"},
{0x10B7, 0x9200, 0x144D, 0xC005, "X10 Laptop(0x144D-0xC005)"},
{0x10B7, 0x9201, 0xFFFF, 0xFFFF, "3C920B-EMB Integrated Fast Ethernet Controller [Tornado](0x9201)"},
{0x10B7, 0x9201, 0x1043, 0x80AB, "A7N8X Deluxe onboard 3C920B-EMB Integrated Fast Ethernet Controller(0x1043-0x80AB)"},
{0x10B7, 0x9202, 0xFFFF, 0xFFFF, "3Com 3C920B-EMB-WNM Integrated Fast Ethernet Controller(0x9202)"},
{0x10B7, 0x9210, 0xFFFF, 0xFFFF, "3C920B-EMB-WNM Integrated Fast Ethernet Controller(0x9210)"},
{0x10B7, 0x9300, 0xFFFF, 0xFFFF, "3CSOHO100B-TX 910-A01 [tulip](0x9300)"},
{0x10B7, 0x9800, 0xFFFF, 0xFFFF, "3c980-TX Fast Etherlink XL Server Adapter [Cyclone](0x9800)"},
{0x10B7, 0x9800, 0x10B7, 0x9800, "3c980-TX Fast Etherlink XL Server Adapter(0x10B7-0x9800)"},
{0x10B7, 0x9805, 0xFFFF, 0xFFFF, "3c980-C 10/100baseTX NIC [Python-T](0x9805)"},
{0x10B7, 0x9805, 0x10B7, 0x1201, "EtherLink Server 10/100 Dual Port A(0x10B7-0x1201)"},
{0x10B7, 0x9805, 0x10B7, 0x1202, "EtherLink Server 10/100 Dual Port B(0x10B7-0x1202)"},
{0x10B7, 0x9805, 0x10B7, 0x9805, "3c980 10/100baseTX NIC [Python-T](0x10B7-0x9805)"},
{0x10B7, 0x9805, 0x10F1, 0x2462, "Thunder K7 S2462(0x10F1-0x2462)"},
{0x10B7, 0x9900, 0xFFFF, 0xFFFF, "3C990-TX [Typhoon](0x9900)"},
{0x10B7, 0x9902, 0xFFFF, 0xFFFF, "3CR990-TX-95 [Typhoon 56-bit](0x9902)"},
{0x10B7, 0x9903, 0xFFFF, 0xFFFF, "3CR990-TX-97 [Typhoon 168-bit](0x9903)"},
{0x10B7, 0x9904, 0xFFFF, 0xFFFF, "3C990B-TX-M/3C990BSVR [Typhoon2](0x9904)"},
{0x10B7, 0x9904, 0x10B7, 0x1000, "3CR990B-TX-M [Typhoon2](0x10B7-0x1000)"},
{0x10B7, 0x9904, 0x10B7, 0x2000, "3CR990BSVR [Typhoon2 Server](0x10B7-0x2000)"},
{0x10B7, 0x9905, 0xFFFF, 0xFFFF, "3CR990-FX-95/97/95 [Typhon Fiber](0x9905)"},
{0x10B7, 0x9905, 0x10B7, 0x1101, "3CR990-FX-95 [Typhoon Fiber 56-bit](0x10B7-0x1101)"},
{0x10B7, 0x9905, 0x10B7, 0x1102, "3CR990-FX-97 [Typhoon Fiber 168-bit](0x10B7-0x1102)"},
{0x10B7, 0x9905, 0x10B7, 0x2101, "3CR990-FX-95 Server [Typhoon Fiber 56-bit](0x10B7-0x2101)"},
{0x10B7, 0x9905, 0x10B7, 0x2102, "3CR990-FX-97 Server [Typhoon Fiber 168-bit](0x10B7-0x2102)"},
{0x10B7, 0x9908, 0xFFFF, 0xFFFF, "3CR990SVR95 [Typhoon Server 56-bit](0x9908)"},
{0x10B7, 0x9909, 0xFFFF, 0xFFFF, "3CR990SVR97 [Typhoon Server 168-bit](0x9909)"},
{0x10B7, 0x990A, 0xFFFF, 0xFFFF, "3C990SVR [Typhoon Server](0x990A)"},
{0x10B7, 0x990B, 0xFFFF, 0xFFFF, "3C990SVR [Typhoon Server](0x990B)"},
}; /* pci_vid_10B7[] */

static pci_id_t const pci_vid_10B8[] = {
{0x10B8, 0xFFFF, 0xFFFF, 0xFFFF, "Standard Microsystems Corp [SMC](0x10B8)"},
{0x10B8, 0x0005, 0xFFFF, 0xFFFF, "83c170 EPIC/100 Fast Ethernet Adapter(0x0005)"},
{0x10B8, 0x0005, 0x1055, 0xE000, "LANEPIC 10/100 [EVB171Q-PCI](0x1055-0xE000)"},
{0x10B8, 0x0005, 0x1055, 0xE002, "LANEPIC 10/100 [EVB171G-PCI](0x1055-0xE002)"},
{0x10B8, 0x0005, 0x10B8, 0xA011, "EtherPower II 10/100(0x10B8-0xA011)"},
{0x10B8, 0x0005, 0x10B8, 0xA014, "EtherPower II 10/100(0x10B8-0xA014)"},
{0x10B8, 0x0005, 0x10B8, 0xA015, "EtherPower II 10/100(0x10B8-0xA015)"},
{0x10B8, 0x0005, 0x10B8, 0xA016, "EtherPower II 10/100(0x10B8-0xA016)"},
{0x10B8, 0x0005, 0x10B8, 0xA017, "EtherPower II 10/100(0x10B8-0xA017)"},
{0x10B8, 0x0006, 0xFFFF, 0xFFFF, "83c175 EPIC/100 Fast Ethernet Adapter(0x0006)"},
{0x10B8, 0x0006, 0x1055, 0xE100, "LANEPIC Cardbus Fast Ethernet Adapter(0x1055-0xE100)"},
{0x10B8, 0x0006, 0x1055, 0xE102, "LANEPIC Cardbus Fast Ethernet Adapter(0x1055-0xE102)"},
{0x10B8, 0x0006, 0x1055, 0xE300, "LANEPIC Cardbus Fast Ethernet Adapter(0x1055-0xE300)"},
{0x10B8, 0x0006, 0x1055, 0xE302, "LANEPIC Cardbus Fast Ethernet Adapter(0x1055-0xE302)"},
{0x10B8, 0x0006, 0x10B8, 0xA012, "LANEPIC Cardbus Fast Ethernet Adapter(0x10B8-0xA012)"},
{0x10B8, 0x0006, 0x13A2, 0x8002, "LANEPIC Cardbus Fast Ethernet Adapter(0x13A2-0x8002)"},
{0x10B8, 0x0006, 0x13A2, 0x8006, "LANEPIC Cardbus Fast Ethernet Adapter(0x13A2-0x8006)"},
{0x10B8, 0x1000, 0xFFFF, 0xFFFF, "FDC 37c665(0x1000)"},
{0x10B8, 0x1001, 0xFFFF, 0xFFFF, "FDC 37C922(0x1001)"},
{0x10B8, 0xA011, 0xFFFF, 0xFFFF, "83C170QF(0xA011)"},
{0x10B8, 0xB106, 0xFFFF, 0xFFFF, "SMC34C90(0xB106)"},
}; /* pci_vid_10B8[] */

static pci_id_t const pci_vid_10B9[] = {
{0x10B9, 0xFFFF, 0xFFFF, 0xFFFF, "ULi Electronics Inc.(0x10B9)"},
{0x10B9, 0x0101, 0xFFFF, 0xFFFF, "CMI8338/C3DX PCI Audio Device(0x0101)"},
{0x10B9, 0x0111, 0xFFFF, 0xFFFF, "C-Media CMI8738/C3DX Audio Device (OEM)(0x0111)"},
{0x10B9, 0x0111, 0x10B9, 0x0111, "C-Media CMI8738/C3DX Audio Device (OEM)(0x10B9-0x0111)"},
{0x10B9, 0x0780, 0xFFFF, 0xFFFF, "Multi-IO Card(0x0780)"},
{0x10B9, 0x0782, 0xFFFF, 0xFFFF, "Multi-IO Card(0x0782)"},
{0x10B9, 0x1435, 0xFFFF, 0xFFFF, "M1435(0x1435)"},
{0x10B9, 0x1445, 0xFFFF, 0xFFFF, "M1445(0x1445)"},
{0x10B9, 0x1449, 0xFFFF, 0xFFFF, "M1449(0x1449)"},
{0x10B9, 0x1451, 0xFFFF, 0xFFFF, "M1451(0x1451)"},
{0x10B9, 0x1461, 0xFFFF, 0xFFFF, "M1461(0x1461)"},
{0x10B9, 0x1489, 0xFFFF, 0xFFFF, "M1489 Cache-Memory PCI Controller (CMP) [FinALi 486] CPU to PCI bridge(0x1489)"},
{0x10B9, 0x1511, 0xFFFF, 0xFFFF, "M1511 [Aladdin](0x1511)"},
{0x10B9, 0x1512, 0xFFFF, 0xFFFF, "M1512 [Aladdin](0x1512)"},
{0x10B9, 0x1513, 0xFFFF, 0xFFFF, "M1513 [Aladdin](0x1513)"},
{0x10B9, 0x1521, 0xFFFF, 0xFFFF, "M1521 [Aladdin III](0x1521)"},
{0x10B9, 0x1521, 0x10B9, 0x1521, "ALI M1521 Aladdin III CPU Bridge(0x10B9-0x1521)"},
{0x10B9, 0x1523, 0xFFFF, 0xFFFF, "M1523(0x1523)"},
{0x10B9, 0x1523, 0x10B9, 0x1523, "ALI M1523 ISA Bridge(0x10B9-0x1523)"},
{0x10B9, 0x1531, 0xFFFF, 0xFFFF, "M1531 [Aladdin IV](0x1531)"},
{0x10B9, 0x1533, 0xFFFF, 0xFFFF, "M1533/M1535/M1543 PCI to ISA Bridge [Aladdin IV/V/V+](0x1533)"},
{0x10B9, 0x1533, 0x1014, 0x053B, "ThinkPad R40e(0x1014-0x053B)"},
{0x10B9, 0x1533, 0x10B9, 0x1533, "ALi M1533 Aladdin IV/V ISA Bridge(0x10B9-0x1533)"},
{0x10B9, 0x1541, 0xFFFF, 0xFFFF, "M1541(0x1541)"},
{0x10B9, 0x1541, 0x10B9, 0x1541, "ALI M1541 Aladdin V/V+ AGP System Controller(0x10B9-0x1541)"},
{0x10B9, 0x1543, 0xFFFF, 0xFFFF, "M1543(0x1543)"},
{0x10B9, 0x1563, 0xFFFF, 0xFFFF, "M1563 HyperTransport South Bridge(0x1563)"},
{0x10B9, 0x1563, 0x10B9, 0x1563, "ASRock 939Dual-SATA2 Motherboard(0x10B9-0x1563)"},
{0x10B9, 0x1563, 0x1849, 0x1563, "ASRock 939Dual-SATA2 Motherboard(0x1849-0x1563)"},
{0x10B9, 0x1573, 0xFFFF, 0xFFFF, "PCI to LPC Controller(0x1573)"},
{0x10B9, 0x1575, 0xFFFF, 0xFFFF, "M1575 South Bridge(0x1575)"},
{0x10B9, 0x1621, 0xFFFF, 0xFFFF, "M1621(0x1621)"},
{0x10B9, 0x1631, 0xFFFF, 0xFFFF, "ALI M1631 PCI North Bridge Aladdin Pro III(0x1631)"},
{0x10B9, 0x1632, 0xFFFF, 0xFFFF, "M1632M Northbridge+Trident(0x1632)"},
{0x10B9, 0x1641, 0xFFFF, 0xFFFF, "ALI M1641 PCI North Bridge Aladdin Pro IV(0x1641)"},
{0x10B9, 0x1644, 0xFFFF, 0xFFFF, "M1644/M1644T Northbridge+Trident(0x1644)"},
{0x10B9, 0x1646, 0xFFFF, 0xFFFF, "M1646 Northbridge+Trident(0x1646)"},
{0x10B9, 0x1647, 0xFFFF, 0xFFFF, "M1647 Northbridge [MAGiK 1 / MobileMAGiK 1](0x1647)"},
{0x10B9, 0x1651, 0xFFFF, 0xFFFF, "M1651/M1651T Northbridge [Aladdin-Pro 5/5M,Aladdin-Pro 5T/5TM](0x1651)"},
{0x10B9, 0x1671, 0xFFFF, 0xFFFF, "M1671 Super P4 Northbridge [AGP4X,PCI and SDR/DDR](0x1671)"},
{0x10B9, 0x1672, 0xFFFF, 0xFFFF, "M1672 Northbridge [CyberALADDiN-P4](0x1672)"},
{0x10B9, 0x1681, 0xFFFF, 0xFFFF, "M1681 P4 Northbridge [AGP8X,HyperTransport and SDR/DDR](0x1681)"},
{0x10B9, 0x1687, 0xFFFF, 0xFFFF, "M1687 K8 Northbridge [AGP8X and HyperTransport](0x1687)"},
{0x10B9, 0x1689, 0xFFFF, 0xFFFF, "M1689 K8 Northbridge [Super K8 Single Chip](0x1689)"},
{0x10B9, 0x1695, 0xFFFF, 0xFFFF, "M1695 Host Bridge(0x1695)"},
{0x10B9, 0x1697, 0xFFFF, 0xFFFF, "M1697 HTT Host Bridge(0x1697)"},
{0x10B9, 0x3141, 0xFFFF, 0xFFFF, "M3141(0x3141)"},
{0x10B9, 0x3143, 0xFFFF, 0xFFFF, "M3143(0x3143)"},
{0x10B9, 0x3145, 0xFFFF, 0xFFFF, "M3145(0x3145)"},
{0x10B9, 0x3147, 0xFFFF, 0xFFFF, "M3147(0x3147)"},
{0x10B9, 0x3149, 0xFFFF, 0xFFFF, "M3149(0x3149)"},
{0x10B9, 0x3151, 0xFFFF, 0xFFFF, "M3151(0x3151)"},
{0x10B9, 0x3307, 0xFFFF, 0xFFFF, "M3307(0x3307)"},
{0x10B9, 0x3309, 0xFFFF, 0xFFFF, "M3309(0x3309)"},
{0x10B9, 0x3323, 0xFFFF, 0xFFFF, "M3325 Video/Audio Decoder(0x3323)"},
{0x10B9, 0x5212, 0xFFFF, 0xFFFF, "M4803(0x5212)"},
{0x10B9, 0x5215, 0xFFFF, 0xFFFF, "MS4803(0x5215)"},
{0x10B9, 0x5217, 0xFFFF, 0xFFFF, "M5217H(0x5217)"},
{0x10B9, 0x5219, 0xFFFF, 0xFFFF, "M5219(0x5219)"},
{0x10B9, 0x5225, 0xFFFF, 0xFFFF, "M5225(0x5225)"},
{0x10B9, 0x5228, 0xFFFF, 0xFFFF, "M5228 ALi ATA/RAID Controller(0x5228)"},
{0x10B9, 0x5229, 0xFFFF, 0xFFFF, "M5229 IDE(0x5229)"},
{0x10B9, 0x5229, 0x1014, 0x050F, "ThinkPad R30(0x1014-0x050F)"},
{0x10B9, 0x5229, 0x1014, 0x053D, "ThinkPad R40e(0x1014-0x053D)"},
{0x10B9, 0x5229, 0x103C, 0x0024, "Pavilion ze4400 builtin IDE(0x103C-0x0024)"},
{0x10B9, 0x5229, 0x103C, 0x0025, "XE4500 Notebook(0x103C-0x0025)"},
{0x10B9, 0x5229, 0x1043, 0x8053, "A7A266 Motherboard IDE(0x1043-0x8053)"},
{0x10B9, 0x5229, 0x1849, 0x5229, "ASRock 939Dual-SATA2 Motherboard IDE (PATA)(0x1849-0x5229)"},
{0x10B9, 0x5235, 0xFFFF, 0xFFFF, "M5225(0x5235)"},
{0x10B9, 0x5237, 0xFFFF, 0xFFFF, "USB 1.1 Controller(0x5237)"},
{0x10B9, 0x5237, 0x1014, 0x0540, "ThinkPad R40e(0x1014-0x0540)"},
{0x10B9, 0x5237, 0x103C, 0x0024, "Pavilion ze4400 builtin USB(0x103C-0x0024)"},
{0x10B9, 0x5237, 0x103C, 0x0025, "XE4500 Notebook(0x103C-0x0025)"},
{0x10B9, 0x5237, 0x104D, 0x810F, "VAIO PCG-U1 USB/OHCI Revision 1.0(0x104D-0x810F)"},
{0x10B9, 0x5237, 0x10B9, 0x5237, "M5273 USB OHCI PCI adapter(0x10B9-0x5237)"},
{0x10B9, 0x5237, 0x1849, 0x5237, "ASRock 939Dual-SATA2 Motherboard(0x1849-0x5237)"},
{0x10B9, 0x5239, 0xFFFF, 0xFFFF, "USB 2.0 Controller(0x5239)"},
{0x10B9, 0x5239, 0x10B9, 0x5239, "M5273 USB PCI adapter(0x10B9-0x5239)"},
{0x10B9, 0x5239, 0x1849, 0x5239, "ASRock 939Dual-SATA2 Motherboard(0x1849-0x5239)"},
{0x10B9, 0x5243, 0xFFFF, 0xFFFF, "M1541 PCI to AGP Controller(0x5243)"},
{0x10B9, 0x5246, 0xFFFF, 0xFFFF, "AGP8X Controller(0x5246)"},
{0x10B9, 0x5247, 0xFFFF, 0xFFFF, "PCI to AGP Controller(0x5247)"},
{0x10B9, 0x5249, 0xFFFF, 0xFFFF, "M5249 HTT to PCI Bridge(0x5249)"},
{0x10B9, 0x524B, 0xFFFF, 0xFFFF, "PCI Express Root Port(0x524B)"},
{0x10B9, 0x524C, 0xFFFF, 0xFFFF, "PCI Express Root Port(0x524C)"},
{0x10B9, 0x524D, 0xFFFF, 0xFFFF, "PCI Express Root Port(0x524D)"},
{0x10B9, 0x524E, 0xFFFF, 0xFFFF, "PCI Express Root Port(0x524E)"},
{0x10B9, 0x5251, 0xFFFF, 0xFFFF, "M5251 P1394 OHCI 1.0 Controller(0x5251)"},
{0x10B9, 0x5253, 0xFFFF, 0xFFFF, "M5253 P1394 OHCI 1.1 Controller(0x5253)"},
{0x10B9, 0x5261, 0xFFFF, 0xFFFF, "M5261 Ethernet Controller(0x5261)"},
{0x10B9, 0x5263, 0xFFFF, 0xFFFF, "ULi 1689,1573 integrated ethernet.(0x5263)"},
{0x10B9, 0x5281, 0xFFFF, 0xFFFF, "ALi M5281 Serial ATA / RAID Host Controller(0x5281)"},
{0x10B9, 0x5287, 0xFFFF, 0xFFFF, "ULi 5287 SATA(0x5287)"},
{0x10B9, 0x5288, 0xFFFF, 0xFFFF, "ULi M5288 SATA(0x5288)"},
{0x10B9, 0x5288, 0x1043, 0x8056, "A8R-MVP Mainboard(0x1043-0x8056)"},
{0x10B9, 0x5289, 0xFFFF, 0xFFFF, "ULi 5289 SATA(0x5289)"},
{0x10B9, 0x5450, 0xFFFF, 0xFFFF, "Lucent Technologies Soft Modem AMR(0x5450)"},
{0x10B9, 0x5451, 0xFFFF, 0xFFFF, "M5451 PCI AC-Link Controller Audio Device(0x5451)"},
{0x10B9, 0x5451, 0x1014, 0x0506, "ThinkPad R30(0x1014-0x0506)"},
{0x10B9, 0x5451, 0x1014, 0x053E, "ThinkPad R40e(0x1014-0x053E)"},
{0x10B9, 0x5451, 0x103C, 0x0024, "Pavilion ze4400 builtin Audio(0x103C-0x0024)"},
{0x10B9, 0x5451, 0x103C, 0x0025, "XE4500 Notebook(0x103C-0x0025)"},
{0x10B9, 0x5453, 0xFFFF, 0xFFFF, "M5453 PCI AC-Link Controller Modem Device(0x5453)"},
{0x10B9, 0x5455, 0xFFFF, 0xFFFF, "M5455 PCI AC-Link Controller Audio Device(0x5455)"},
{0x10B9, 0x5455, 0x10B9, 0x5455, "ASRock 939Dual-SATA2 Motherboard(0x10B9-0x5455)"},
{0x10B9, 0x5455, 0x1849, 0x0850, "ASRock 939Dual-SATA2 Motherboard(0x1849-0x0850)"},
{0x10B9, 0x5457, 0xFFFF, 0xFFFF, "M5457 AC'97 Modem Controller(0x5457)"},
{0x10B9, 0x5457, 0x1014, 0x0535, "ThinkPad R40e(0x1014-0x0535)"},
{0x10B9, 0x5457, 0x103C, 0x0024, "Pavilion ze4400 builtin Modem Device(0x103C-0x0024)"},
{0x10B9, 0x5457, 0x103C, 0x0025, "XE4500 Notebook(0x103C-0x0025)"},
{0x10B9, 0x5459, 0xFFFF, 0xFFFF, "SmartLink SmartPCI561 56K Modem(0x5459)"},
{0x10B9, 0x545A, 0xFFFF, 0xFFFF, "SmartLink SmartPCI563 56K Modem(0x545A)"},
{0x10B9, 0x5461, 0xFFFF, 0xFFFF, "HD Audio Controller(0x5461)"},
{0x10B9, 0x5471, 0xFFFF, 0xFFFF, "M5471 Memory Stick Controller(0x5471)"},
{0x10B9, 0x5473, 0xFFFF, 0xFFFF, "M5473 SD-MMC Controller(0x5473)"},
{0x10B9, 0x7101, 0xFFFF, 0xFFFF, "M7101 Power Management Controller [PMU](0x7101)"},
{0x10B9, 0x7101, 0x1014, 0x0510, "ThinkPad R30(0x1014-0x0510)"},
{0x10B9, 0x7101, 0x1014, 0x053C, "ThinkPad R40e(0x1014-0x053C)"},
{0x10B9, 0x7101, 0x103C, 0x0024, "Pavilion ze4400(0x103C-0x0024)"},
{0x10B9, 0x7101, 0x103C, 0x0025, "XE4500 Notebook(0x103C-0x0025)"},
{0x10B9, 0x7101, 0x1849, 0x7101, "ASRock 939Dual-SATA2 Motherboard(0x1849-0x7101)"},
}; /* pci_vid_10B9[] */

static pci_id_t const pci_vid_10BA[] = {
{0x10BA, 0xFFFF, 0xFFFF, 0xFFFF, "Mitsubishi Electric Corp.(0x10BA)"},
{0x10BA, 0x0301, 0xFFFF, 0xFFFF, "AccelGraphics AccelECLIPSE(0x0301)"},
{0x10BA, 0x0304, 0xFFFF, 0xFFFF, "AccelGALAXY A2100 [OEM Evans & Sutherland](0x0304)"},
{0x10BA, 0x0308, 0xFFFF, 0xFFFF, "Tornado 3000 [OEM Evans & Sutherland](0x0308)"},
{0x10BA, 0x0308, 0x10DD, 0x0024, "Tornado 3000(0x10DD-0x0024)"},
{0x10BA, 0x1002, 0xFFFF, 0xFFFF, "VG500 [VolumePro Volume Rendering Accelerator](0x1002)"},
}; /* pci_vid_10BA[] */

static pci_id_t const pci_vid_10BB[] = {
{0x10BB, 0xFFFF, 0xFFFF, 0xFFFF, "Dapha Electronics Corporation(0x10BB)"},
}; /* pci_vid_10BB[] */

static pci_id_t const pci_vid_10BC[] = {
{0x10BC, 0xFFFF, 0xFFFF, 0xFFFF, "Advanced Logic Research(0x10BC)"},
}; /* pci_vid_10BC[] */

static pci_id_t const pci_vid_10BD[] = {
{0x10BD, 0xFFFF, 0xFFFF, 0xFFFF, "Surecom Technology(0x10BD)"},
{0x10BD, 0x0E34, 0xFFFF, 0xFFFF, "NE-34(0x0E34)"},
}; /* pci_vid_10BD[] */

static pci_id_t const pci_vid_10BE[] = {
{0x10BE, 0xFFFF, 0xFFFF, 0xFFFF, "Tseng Labs International Co.(0x10BE)"},
}; /* pci_vid_10BE[] */

static pci_id_t const pci_vid_10BF[] = {
{0x10BF, 0xFFFF, 0xFFFF, 0xFFFF, "Most Inc(0x10BF)"},
}; /* pci_vid_10BF[] */

static pci_id_t const pci_vid_10C0[] = {
{0x10C0, 0xFFFF, 0xFFFF, 0xFFFF, "Boca Research Inc.(0x10C0)"},
{0x10C0, 0x9135, 0xFFFF, 0xFFFF, "iX3D Ultimate Rez(0x9135)"},
}; /* pci_vid_10C0[] */

static pci_id_t const pci_vid_10C1[] = {
{0x10C1, 0xFFFF, 0xFFFF, 0xFFFF, "ICM Co., Ltd.(0x10C1)"},
}; /* pci_vid_10C1[] */

static pci_id_t const pci_vid_10C2[] = {
{0x10C2, 0xFFFF, 0xFFFF, 0xFFFF, "Auspex Systems Inc.(0x10C2)"},
}; /* pci_vid_10C2[] */

static pci_id_t const pci_vid_10C3[] = {
{0x10C3, 0xFFFF, 0xFFFF, 0xFFFF, "Samsung Semiconductors, Inc.(0x10C3)"},
}; /* pci_vid_10C3[] */

static pci_id_t const pci_vid_10C4[] = {
{0x10C4, 0xFFFF, 0xFFFF, 0xFFFF, "Award Software International Inc.(0x10C4)"},
}; /* pci_vid_10C4[] */

static pci_id_t const pci_vid_10C5[] = {
{0x10C5, 0xFFFF, 0xFFFF, 0xFFFF, "Xerox Corporation(0x10C5)"},
}; /* pci_vid_10C5[] */

static pci_id_t const pci_vid_10C6[] = {
{0x10C6, 0xFFFF, 0xFFFF, 0xFFFF, "Rambus Inc.(0x10C6)"},
}; /* pci_vid_10C6[] */

static pci_id_t const pci_vid_10C7[] = {
{0x10C7, 0xFFFF, 0xFFFF, 0xFFFF, "Media Vision(0x10C7)"},
}; /* pci_vid_10C7[] */

static pci_id_t const pci_vid_10C8[] = {
{0x10C8, 0xFFFF, 0xFFFF, 0xFFFF, "Neomagic Corporation(0x10C8)"},
{0x10C8, 0x0001, 0xFFFF, 0xFFFF, "NM2070 [MagicGraph 128](0x0001)"},
{0x10C8, 0x0002, 0xFFFF, 0xFFFF, "NM2090 [MagicGraph 128V](0x0002)"},
{0x10C8, 0x0003, 0xFFFF, 0xFFFF, "NM2093 [MagicGraph 128ZV](0x0003)"},
{0x10C8, 0x0004, 0xFFFF, 0xFFFF, "NM2160 [MagicGraph 128XD](0x0004)"},
{0x10C8, 0x0004, 0x1014, 0x00BA, "MagicGraph 128XD(0x1014-0x00BA)"},
{0x10C8, 0x0004, 0x1025, 0x1007, "MagicGraph 128XD(0x1025-0x1007)"},
{0x10C8, 0x0004, 0x1028, 0x0074, "MagicGraph 128XD(0x1028-0x0074)"},
{0x10C8, 0x0004, 0x1028, 0x0075, "MagicGraph 128XD(0x1028-0x0075)"},
{0x10C8, 0x0004, 0x1028, 0x007D, "MagicGraph 128XD(0x1028-0x007D)"},
{0x10C8, 0x0004, 0x1028, 0x007E, "MagicGraph 128XD(0x1028-0x007E)"},
{0x10C8, 0x0004, 0x1033, 0x802F, "MagicGraph 128XD(0x1033-0x802F)"},
{0x10C8, 0x0004, 0x104D, 0x801B, "MagicGraph 128XD(0x104D-0x801B)"},
{0x10C8, 0x0004, 0x104D, 0x802F, "MagicGraph 128XD(0x104D-0x802F)"},
{0x10C8, 0x0004, 0x104D, 0x830B, "MagicGraph 128XD(0x104D-0x830B)"},
{0x10C8, 0x0004, 0x10BA, 0x0E00, "MagicGraph 128XD(0x10BA-0x0E00)"},
{0x10C8, 0x0004, 0x10C8, 0x0004, "MagicGraph 128XD(0x10C8-0x0004)"},
{0x10C8, 0x0004, 0x10CF, 0x1029, "MagicGraph 128XD(0x10CF-0x1029)"},
{0x10C8, 0x0004, 0x10F7, 0x8308, "MagicGraph 128XD(0x10F7-0x8308)"},
{0x10C8, 0x0004, 0x10F7, 0x8309, "MagicGraph 128XD(0x10F7-0x8309)"},
{0x10C8, 0x0004, 0x10F7, 0x830B, "MagicGraph 128XD(0x10F7-0x830B)"},
{0x10C8, 0x0004, 0x10F7, 0x830D, "MagicGraph 128XD(0x10F7-0x830D)"},
{0x10C8, 0x0004, 0x10F7, 0x8312, "MagicGraph 128XD(0x10F7-0x8312)"},
{0x10C8, 0x0005, 0xFFFF, 0xFFFF, "NM2200 [MagicGraph 256AV](0x0005)"},
{0x10C8, 0x0005, 0x1014, 0x00DD, "ThinkPad 570(0x1014-0x00DD)"},
{0x10C8, 0x0005, 0x1028, 0x0088, "Latitude CPi A(0x1028-0x0088)"},
{0x10C8, 0x0006, 0xFFFF, 0xFFFF, "NM2360 [MagicMedia 256ZX](0x0006)"},
{0x10C8, 0x0006, 0x1014, 0x0152, "ThinkPad 600X(0x1014-0x0152)"},
{0x10C8, 0x0016, 0xFFFF, 0xFFFF, "NM2380 [MagicMedia 256XL+](0x0016)"},
{0x10C8, 0x0016, 0x10C8, 0x0016, "MagicMedia 256XL+(0x10C8-0x0016)"},
{0x10C8, 0x0025, 0xFFFF, 0xFFFF, "NM2230 [MagicGraph 256AV+](0x0025)"},
{0x10C8, 0x0083, 0xFFFF, 0xFFFF, "NM2093 [MagicGraph 128ZV+](0x0083)"},
{0x10C8, 0x8005, 0xFFFF, 0xFFFF, "NM2200 [MagicMedia 256AV Audio](0x8005)"},
{0x10C8, 0x8005, 0x0E11, 0xB0D1, "MagicMedia 256AV Audio Device on Discovery(0x0E11-0xB0D1)"},
{0x10C8, 0x8005, 0x0E11, 0xB126, "MagicMedia 256AV Audio Device on Durango(0x0E11-0xB126)"},
{0x10C8, 0x8005, 0x1014, 0x00DD, "ThinkPad 390/i1720/i1721(0x1014-0x00DD)"},
{0x10C8, 0x8005, 0x1025, 0x1003, "MagicMedia 256AV Audio Device on TravelMate 720(0x1025-0x1003)"},
{0x10C8, 0x8005, 0x1028, 0x0088, "Latitude CPi A(0x1028-0x0088)"},
{0x10C8, 0x8005, 0x1028, 0x008F, "MagicMedia 256AV Audio Device on Colorado Inspiron(0x1028-0x008F)"},
{0x10C8, 0x8005, 0x103C, 0x0007, "MagicMedia 256AV Audio Device on Voyager II(0x103C-0x0007)"},
{0x10C8, 0x8005, 0x103C, 0x0008, "MagicMedia 256AV Audio Device on Voyager III(0x103C-0x0008)"},
{0x10C8, 0x8005, 0x103C, 0x000D, "MagicMedia 256AV Audio Device on Omnibook 900(0x103C-0x000D)"},
{0x10C8, 0x8005, 0x10C8, 0x8005, "MagicMedia 256AV Audio Device on FireAnt(0x10C8-0x8005)"},
{0x10C8, 0x8005, 0x110A, 0x8005, "MagicMedia 256AV Audio Device(0x110A-0x8005)"},
{0x10C8, 0x8005, 0x14C0, 0x0004, "MagicMedia 256AV Audio Device(0x14C0-0x0004)"},
{0x10C8, 0x8006, 0xFFFF, 0xFFFF, "NM2360 [MagicMedia 256ZX Audio](0x8006)"},
{0x10C8, 0x8016, 0xFFFF, 0xFFFF, "NM2380 [MagicMedia 256XL+ Audio](0x8016)"},
}; /* pci_vid_10C8[] */

static pci_id_t const pci_vid_10C9[] = {
{0x10C9, 0xFFFF, 0xFFFF, 0xFFFF, "Dataexpert Corporation(0x10C9)"},
}; /* pci_vid_10C9[] */

static pci_id_t const pci_vid_10CA[] = {
{0x10CA, 0xFFFF, 0xFFFF, 0xFFFF, "Fujitsu Microelectr., Inc.(0x10CA)"},
}; /* pci_vid_10CA[] */

static pci_id_t const pci_vid_10CB[] = {
{0x10CB, 0xFFFF, 0xFFFF, 0xFFFF, "Omron Corporation(0x10CB)"},
}; /* pci_vid_10CB[] */

static pci_id_t const pci_vid_10CC[] = {
{0x10CC, 0xFFFF, 0xFFFF, 0xFFFF, "Mai Logic Incorporated(0x10CC)"},
{0x10CC, 0x0660, 0xFFFF, 0xFFFF, "Articia S Host Bridge(0x0660)"},
{0x10CC, 0x0661, 0xFFFF, 0xFFFF, "Articia S PCI Bridge(0x0661)"},
}; /* pci_vid_10CC[] */

static pci_id_t const pci_vid_10CD[] = {
{0x10CD, 0xFFFF, 0xFFFF, 0xFFFF, "Advanced System Products, Inc(0x10CD)"},
{0x10CD, 0x1100, 0xFFFF, 0xFFFF, "ASC1100(0x1100)"},
{0x10CD, 0x1200, 0xFFFF, 0xFFFF, "ASC1200 [(abp940) Fast SCSI-II](0x1200)"},
{0x10CD, 0x1300, 0xFFFF, 0xFFFF, "ASC1300 / ASC3030 [ABP940-U / ABP960-U / ABP3925](0x1300)"},
{0x10CD, 0x1300, 0x10CD, 0x1310, "ASC1300/3030 SCSI adapter(0x10CD-0x1310)"},
{0x10CD, 0x1300, 0x1195, 0x1320, "Ultra-SCSI CardBus PC Card REX CB31(0x1195-0x1320)"},
{0x10CD, 0x2300, 0xFFFF, 0xFFFF, "ABP940-UW(0x2300)"},
{0x10CD, 0x2500, 0xFFFF, 0xFFFF, "ABP940-U2W(0x2500)"},
{0x10CD, 0x2700, 0xFFFF, 0xFFFF, "ABP3950-U3W(0x2700)"},
}; /* pci_vid_10CD[] */

static pci_id_t const pci_vid_10CE[] = {
{0x10CE, 0xFFFF, 0xFFFF, 0xFFFF, "Radius(0x10CE)"},
}; /* pci_vid_10CE[] */

static pci_id_t const pci_vid_10CF[] = {
{0x10CF, 0xFFFF, 0xFFFF, 0xFFFF, "Fujitsu Limited.(0x10CF)"},
{0x10CF, 0x01EF, 0xFFFF, 0xFFFF, "PCEA4 PCI-Express Dual Port ESCON Adapter(0x01EF)"},
{0x10CF, 0x1414, 0xFFFF, 0xFFFF, "On-board USB 1.1 companion controller(0x1414)"},
{0x10CF, 0x1415, 0xFFFF, 0xFFFF, "On-board USB 2.0 EHCI controller(0x1415)"},
{0x10CF, 0x1422, 0xFFFF, 0xFFFF, "E8410 nVidia graphics adapter(0x1422)"},
{0x10CF, 0x142D, 0xFFFF, 0xFFFF, "HD audio (Realtek ALC262)(0x142D)"},
{0x10CF, 0x1430, 0xFFFF, 0xFFFF, "82566MM Intel 1Gb copper LAN interface(0x1430)"},
{0x10CF, 0x1623, 0xFFFF, 0xFFFF, "PCEA4 PCI-Express Dual Port ESCON Adapter(0x1623)"},
{0x10CF, 0x2001, 0xFFFF, 0xFFFF, "mb86605(0x2001)"},
{0x10CF, 0x200C, 0xFFFF, 0xFFFF, "MB86613L IEEE1394 OHCI 1.0 Controller(0x200C)"},
{0x10CF, 0x2010, 0xFFFF, 0xFFFF, "MB86613S IEEE1394 OHCI 1.1 Controller(0x2010)"},
{0x10CF, 0x2019, 0xFFFF, 0xFFFF, "MB86295S [CORAL P](0x2019)"},
{0x10CF, 0x201E, 0xFFFF, 0xFFFF, "MB86296S [CORAL PA](0x201E)"},
{0x10CF, 0x202B, 0xFFFF, 0xFFFF, "MB86297A [Carmine Graphics Controller](0x202B)"},
}; /* pci_vid_10CF[] */

static pci_id_t const pci_vid_10D1[] = {
{0x10D1, 0xFFFF, 0xFFFF, 0xFFFF, "FuturePlus Systems Corp.(0x10D1)"},
}; /* pci_vid_10D1[] */

static pci_id_t const pci_vid_10D2[] = {
{0x10D2, 0xFFFF, 0xFFFF, 0xFFFF, "Molex Incorporated(0x10D2)"},
}; /* pci_vid_10D2[] */

static pci_id_t const pci_vid_10D3[] = {
{0x10D3, 0xFFFF, 0xFFFF, 0xFFFF, "Jabil Circuit Inc(0x10D3)"},
}; /* pci_vid_10D3[] */

static pci_id_t const pci_vid_10D4[] = {
{0x10D4, 0xFFFF, 0xFFFF, 0xFFFF, "Hualon Microelectronics(0x10D4)"},
}; /* pci_vid_10D4[] */

static pci_id_t const pci_vid_10D5[] = {
{0x10D5, 0xFFFF, 0xFFFF, 0xFFFF, "Autologic Inc.(0x10D5)"},
}; /* pci_vid_10D5[] */

static pci_id_t const pci_vid_10D6[] = {
{0x10D6, 0xFFFF, 0xFFFF, 0xFFFF, "Cetia(0x10D6)"},
}; /* pci_vid_10D6[] */

static pci_id_t const pci_vid_10D7[] = {
{0x10D7, 0xFFFF, 0xFFFF, 0xFFFF, "BCM Advanced Research(0x10D7)"},
}; /* pci_vid_10D7[] */

static pci_id_t const pci_vid_10D8[] = {
{0x10D8, 0xFFFF, 0xFFFF, 0xFFFF, "Advanced Peripherals Labs(0x10D8)"},
}; /* pci_vid_10D8[] */

static pci_id_t const pci_vid_10D9[] = {
{0x10D9, 0xFFFF, 0xFFFF, 0xFFFF, "Macronix, Inc. [MXIC](0x10D9)"},
{0x10D9, 0x0431, 0xFFFF, 0xFFFF, "MX98715(0x0431)"},
{0x10D9, 0x0512, 0xFFFF, 0xFFFF, "MX98713(0x0512)"},
{0x10D9, 0x0531, 0xFFFF, 0xFFFF, "MX987x5(0x0531)"},
{0x10D9, 0x0531, 0x1186, 0x1200, "DFE-540TX ProFAST 10/100 Adapter(0x1186-0x1200)"},
{0x10D9, 0x8625, 0xFFFF, 0xFFFF, "MX86250(0x8625)"},
{0x10D9, 0x8626, 0xFFFF, 0xFFFF, "Macronix MX86251 + 3Dfx Voodoo Rush(0x8626)"},
{0x10D9, 0x8888, 0xFFFF, 0xFFFF, "MX86200(0x8888)"},
}; /* pci_vid_10D9[] */

static pci_id_t const pci_vid_10DA[] = {
{0x10DA, 0xFFFF, 0xFFFF, 0xFFFF, "Compaq IPG-Austin(0x10DA)"},
{0x10DA, 0x0508, 0xFFFF, 0xFFFF, "TC4048 Token Ring 4/16(0x0508)"},
{0x10DA, 0x3390, 0xFFFF, 0xFFFF, "Tl3c3x9(0x3390)"},
}; /* pci_vid_10DA[] */

static pci_id_t const pci_vid_10DB[] = {
{0x10DB, 0xFFFF, 0xFFFF, 0xFFFF, "Rohm LSI Systems, Inc.(0x10DB)"},
}; /* pci_vid_10DB[] */

static pci_id_t const pci_vid_10DC[] = {
{0x10DC, 0xFFFF, 0xFFFF, 0xFFFF, "CERN/ECP/EDU(0x10DC)"},
{0x10DC, 0x0001, 0xFFFF, 0xFFFF, "STAR/RD24 SCI-PCI (PMC)(0x0001)"},
{0x10DC, 0x0002, 0xFFFF, 0xFFFF, "TAR/RD24 SCI-PCI (PMC)(0x0002)"},
{0x10DC, 0x0021, 0xFFFF, 0xFFFF, "HIPPI destination(0x0021)"},
{0x10DC, 0x0022, 0xFFFF, 0xFFFF, "HIPPI source(0x0022)"},
{0x10DC, 0x10DC, 0xFFFF, 0xFFFF, "ATT2C15-3 FPGA(0x10DC)"},
}; /* pci_vid_10DC[] */

static pci_id_t const pci_vid_10DD[] = {
{0x10DD, 0xFFFF, 0xFFFF, 0xFFFF, "Evans & Sutherland(0x10DD)"},
{0x10DD, 0x0100, 0xFFFF, 0xFFFF, "Lightning 1200(0x0100)"},
{0x10DD, 0x0100, 0x10DD, 0x0023, "Lightning 1200 15+16M(0x10DD-0x0023)"},
}; /* pci_vid_10DD[] */

static pci_id_t const pci_vid_10DE[] = {
{0x10DE, 0xFFFF, 0xFFFF, 0xFFFF, "NVIDIA Corporation(0x10DE)"},
{0x10DE, 0x0008, 0xFFFF, 0xFFFF, "NV1 [STG2000X-B Series](0x0008)"},
{0x10DE, 0x0009, 0xFFFF, 0xFFFF, "NV1 [NV1 Series](0x0009)"},
{0x10DE, 0x0018, 0xFFFF, 0xFFFF, "NV3 [Riva 128](0x0018)"},
{0x10DE, 0x0019, 0xFFFF, 0xFFFF, "NV3 [Riva 128ZX](0x0019)"},
{0x10DE, 0x0020, 0xFFFF, 0xFFFF, "NV4 [Riva TNT](0x0020)"},
{0x10DE, 0x0020, 0x1043, 0x0200, "V3400 TNT(0x1043-0x0200)"},
{0x10DE, 0x0020, 0x1048, 0x0C18, "Erazor II SGRAM(0x1048-0x0C18)"},
{0x10DE, 0x0020, 0x1048, 0x0C19, "Erazor II(0x1048-0x0C19)"},
{0x10DE, 0x0020, 0x1048, 0x0C1B, "Erazor II(0x1048-0x0C1B)"},
{0x10DE, 0x0020, 0x1048, 0x0C1C, "Erazor II(0x1048-0x0C1C)"},
{0x10DE, 0x0020, 0x1092, 0x0550, "Viper V550(0x1092-0x0550)"},
{0x10DE, 0x0020, 0x1092, 0x0552, "Viper V550(0x1092-0x0552)"},
{0x10DE, 0x0020, 0x1092, 0x4804, "Viper V550(0x1092-0x4804)"},
{0x10DE, 0x0020, 0x1092, 0x4808, "Viper V550(0x1092-0x4808)"},
{0x10DE, 0x0020, 0x1092, 0x4810, "Viper V550(0x1092-0x4810)"},
{0x10DE, 0x0020, 0x1092, 0x4812, "Viper V550(0x1092-0x4812)"},
{0x10DE, 0x0020, 0x1092, 0x4815, "Viper V550(0x1092-0x4815)"},
{0x10DE, 0x0020, 0x1092, 0x4820, "Viper V550 with TV out(0x1092-0x4820)"},
{0x10DE, 0x0020, 0x1092, 0x4822, "Viper V550(0x1092-0x4822)"},
{0x10DE, 0x0020, 0x1092, 0x4904, "Viper V550(0x1092-0x4904)"},
{0x10DE, 0x0020, 0x1092, 0x4914, "Viper V550(0x1092-0x4914)"},
{0x10DE, 0x0020, 0x1092, 0x8225, "Viper V550(0x1092-0x8225)"},
{0x10DE, 0x0020, 0x10B4, 0x273D, "Velocity 4400(0x10B4-0x273D)"},
{0x10DE, 0x0020, 0x10B4, 0x273E, "Velocity 4400(0x10B4-0x273E)"},
{0x10DE, 0x0020, 0x10B4, 0x2740, "Velocity 4400(0x10B4-0x2740)"},
{0x10DE, 0x0020, 0x10DE, 0x0020, "Riva TNT(0x10DE-0x0020)"},
{0x10DE, 0x0020, 0x1102, 0x1015, "Graphics Blaster CT6710(0x1102-0x1015)"},
{0x10DE, 0x0020, 0x1102, 0x1016, "Graphics Blaster RIVA TNT(0x1102-0x1016)"},
{0x10DE, 0x0028, 0xFFFF, 0xFFFF, "NV5 [Riva TNT2 / TNT2 Pro](0x0028)"},
{0x10DE, 0x0028, 0x1043, 0x0200, "AGP-V3800 SGRAM(0x1043-0x0200)"},
{0x10DE, 0x0028, 0x1043, 0x0201, "AGP-V3800 SDRAM(0x1043-0x0201)"},
{0x10DE, 0x0028, 0x1043, 0x0205, "PCI-V3800(0x1043-0x0205)"},
{0x10DE, 0x0028, 0x1043, 0x4000, "AGP-V3800PRO(0x1043-0x4000)"},
{0x10DE, 0x0028, 0x1048, 0x0C21, "Synergy II(0x1048-0x0C21)"},
{0x10DE, 0x0028, 0x1048, 0x0C28, "Erazor III(0x1048-0x0C28)"},
{0x10DE, 0x0028, 0x1048, 0x0C29, "Erazor III(0x1048-0x0C29)"},
{0x10DE, 0x0028, 0x1048, 0x0C2A, "Erazor III(0x1048-0x0C2A)"},
{0x10DE, 0x0028, 0x1048, 0x0C2B, "Erazor III(0x1048-0x0C2B)"},
{0x10DE, 0x0028, 0x1048, 0x0C31, "Erazor III Pro(0x1048-0x0C31)"},
{0x10DE, 0x0028, 0x1048, 0x0C32, "Erazor III Pro(0x1048-0x0C32)"},
{0x10DE, 0x0028, 0x1048, 0x0C33, "Erazor III Pro(0x1048-0x0C33)"},
{0x10DE, 0x0028, 0x1048, 0x0C34, "Erazor III Pro(0x1048-0x0C34)"},
{0x10DE, 0x0028, 0x107D, 0x2134, "WinFast 3D S320 II + TV-Out(0x107D-0x2134)"},
{0x10DE, 0x0028, 0x1092, 0x4804, "Viper V770(0x1092-0x4804)"},
{0x10DE, 0x0028, 0x1092, 0x4A00, "Viper V770(0x1092-0x4A00)"},
{0x10DE, 0x0028, 0x1092, 0x4A02, "Viper V770 Ultra(0x1092-0x4A02)"},
{0x10DE, 0x0028, 0x1092, 0x5A00, "RIVA TNT2/TNT2 Pro(0x1092-0x5A00)"},
{0x10DE, 0x0028, 0x1092, 0x5A40, "Viper V770D AGP(0x1092-0x5A40)"},
{0x10DE, 0x0028, 0x1092, 0x6A02, "Viper V770 Ultra(0x1092-0x6A02)"},
{0x10DE, 0x0028, 0x1092, 0x7A02, "Viper V770 Ultra(0x1092-0x7A02)"},
{0x10DE, 0x0028, 0x10DE, 0x0005, "RIVA TNT2 Pro(0x10DE-0x0005)"},
{0x10DE, 0x0028, 0x10DE, 0x000F, "Compaq NVIDIA TNT2 Pro(0x10DE-0x000F)"},
{0x10DE, 0x0028, 0x1102, 0x1020, "3D Blaster RIVA TNT2(0x1102-0x1020)"},
{0x10DE, 0x0028, 0x1102, 0x1026, "3D Blaster RIVA TNT2 Digital(0x1102-0x1026)"},
{0x10DE, 0x0028, 0x1462, 0x8806, "MS-8806 AGPhantom Graphics Card(0x1462-0x8806)"},
{0x10DE, 0x0028, 0x14AF, 0x5810, "Maxi Gamer Xentor(0x14AF-0x5810)"},
{0x10DE, 0x0029, 0xFFFF, 0xFFFF, "NV5 [Riva TNT2 Ultra](0x0029)"},
{0x10DE, 0x0029, 0x1043, 0x0200, "AGP-V3800 Deluxe(0x1043-0x0200)"},
{0x10DE, 0x0029, 0x1043, 0x0201, "AGP-V3800 Ultra SDRAM(0x1043-0x0201)"},
{0x10DE, 0x0029, 0x1043, 0x0205, "PCI-V3800 Ultra(0x1043-0x0205)"},
{0x10DE, 0x0029, 0x1048, 0x0C2E, "Erazor III Ultra(0x1048-0x0C2E)"},
{0x10DE, 0x0029, 0x1048, 0x0C2F, "Erazor III Ultra(0x1048-0x0C2F)"},
{0x10DE, 0x0029, 0x1048, 0x0C30, "Erazor III Ultra(0x1048-0x0C30)"},
{0x10DE, 0x0029, 0x1102, 0x1021, "3D Blaster RIVA TNT2 Ultra(0x1102-0x1021)"},
{0x10DE, 0x0029, 0x1102, 0x1029, "3D Blaster RIVA TNT2 Ultra(0x1102-0x1029)"},
{0x10DE, 0x0029, 0x1102, 0x102F, "3D Blaster RIVA TNT2 Ultra(0x1102-0x102F)"},
{0x10DE, 0x0029, 0x14AF, 0x5820, "Maxi Gamer Xentor 32(0x14AF-0x5820)"},
{0x10DE, 0x0029, 0x4843, 0x4F34, "Dynamite(0x4843-0x4F34)"},
{0x10DE, 0x002A, 0xFFFF, 0xFFFF, "NV5 [Riva TNT2](0x002A)"},
{0x10DE, 0x002B, 0xFFFF, 0xFFFF, "NV5 [Riva TNT2](0x002B)"},
{0x10DE, 0x002C, 0xFFFF, 0xFFFF, "NV5 [Vanta / Vanta LT](0x002C)"},
{0x10DE, 0x002C, 0x1043, 0x0200, "AGP-V3800 Combat SDRAM(0x1043-0x0200)"},
{0x10DE, 0x002C, 0x1043, 0x0201, "AGP-V3800 Combat(0x1043-0x0201)"},
{0x10DE, 0x002C, 0x1048, 0x0C20, "TNT2 Vanta(0x1048-0x0C20)"},
{0x10DE, 0x002C, 0x1048, 0x0C21, "TNT2 Vanta(0x1048-0x0C21)"},
{0x10DE, 0x002C, 0x1048, 0x0C25, "TNT2 Vanta 16MB(0x1048-0x0C25)"},
{0x10DE, 0x002C, 0x1092, 0x6820, "Viper V730(0x1092-0x6820)"},
{0x10DE, 0x002C, 0x1102, 0x1031, "CT6938 VANTA 8MB(0x1102-0x1031)"},
{0x10DE, 0x002C, 0x1102, 0x1034, "CT6894 VANTA 16MB(0x1102-0x1034)"},
{0x10DE, 0x002C, 0x14AF, 0x5008, "Maxi Gamer Phoenix 2(0x14AF-0x5008)"},
{0x10DE, 0x002D, 0xFFFF, 0xFFFF, "NV5 [Riva TNT2 Model 64 / Model 64 Pro](0x002D)"},
{0x10DE, 0x002D, 0x1043, 0x0200, "AGP-V3800M(0x1043-0x0200)"},
{0x10DE, 0x002D, 0x1043, 0x0201, "AGP-V3800M(0x1043-0x0201)"},
{0x10DE, 0x002D, 0x1048, 0x0C3A, "Erazor III LT(0x1048-0x0C3A)"},
{0x10DE, 0x002D, 0x1048, 0x0C3B, "Erazor III LT(0x1048-0x0C3B)"},
{0x10DE, 0x002D, 0x107D, 0x2137, "WinFast 3D S325(0x107D-0x2137)"},
{0x10DE, 0x002D, 0x10DE, 0x0006, "RIVA TNT2 Model 64/Model 64 Pro(0x10DE-0x0006)"},
{0x10DE, 0x002D, 0x10DE, 0x001E, "M64 AGP4x(0x10DE-0x001E)"},
{0x10DE, 0x002D, 0x1102, 0x1023, "CT6892 RIVA TNT2 Value(0x1102-0x1023)"},
{0x10DE, 0x002D, 0x1102, 0x1024, "CT6932 RIVA TNT2 Value 32Mb(0x1102-0x1024)"},
{0x10DE, 0x002D, 0x1102, 0x102C, "CT6931 RIVA TNT2 Value [Jumper](0x1102-0x102C)"},
{0x10DE, 0x002D, 0x1102, 0x1030, "CT6931 RIVA TNT2 Value(0x1102-0x1030)"},
{0x10DE, 0x002D, 0x110A, 0x006F, "GM1000-16(0x110A-0x006F)"},
{0x10DE, 0x002D, 0x110A, 0x0081, "GM1000-16(0x110A-0x0081)"},
{0x10DE, 0x002D, 0x1462, 0x8808, "MSI-8808(0x1462-0x8808)"},
{0x10DE, 0x002D, 0x14AF, 0x5620, "Gamer Cougar Video Edition(0x14AF-0x5620)"},
{0x10DE, 0x002D, 0x1554, 0x1041, "Pixelview RIVA TNT2 M64(0x1554-0x1041)"},
{0x10DE, 0x002D, 0x1569, 0x002D, "Palit Microsystems Daytona TNT2 M64(0x1569-0x002D)"},
{0x10DE, 0x0034, 0xFFFF, 0xFFFF, "MCP04 SMBus(0x0034)"},
{0x10DE, 0x0035, 0xFFFF, 0xFFFF, "MCP04 IDE(0x0035)"},
{0x10DE, 0x0036, 0xFFFF, 0xFFFF, "MCP04 Serial ATA Controller(0x0036)"},
{0x10DE, 0x0037, 0xFFFF, 0xFFFF, "MCP04 Ethernet Controller(0x0037)"},
{0x10DE, 0x0038, 0xFFFF, 0xFFFF, "MCP04 Ethernet Controller(0x0038)"},
{0x10DE, 0x003A, 0xFFFF, 0xFFFF, "MCP04 AC'97 Audio Controller(0x003A)"},
{0x10DE, 0x003B, 0xFFFF, 0xFFFF, "MCP04 USB Controller(0x003B)"},
{0x10DE, 0x003C, 0xFFFF, 0xFFFF, "MCP04 USB Controller(0x003C)"},
{0x10DE, 0x003D, 0xFFFF, 0xFFFF, "MCP04 PCI Bridge(0x003D)"},
{0x10DE, 0x003E, 0xFFFF, 0xFFFF, "MCP04 Serial ATA Controller(0x003E)"},
{0x10DE, 0x0040, 0xFFFF, 0xFFFF, "NV40 [GeForce 6800 Ultra](0x0040)"},
{0x10DE, 0x0041, 0xFFFF, 0xFFFF, "NV40 [GeForce 6800](0x0041)"},
{0x10DE, 0x0041, 0x1043, 0x817B, "V9999 Gamer Edition(0x1043-0x817B)"},
{0x10DE, 0x0041, 0x107D, 0x2992, "WinFast A400(0x107D-0x2992)"},
{0x10DE, 0x0041, 0x1458, 0x310F, "Geforce 6800 GV-N6812(0x1458-0x310F)"},
{0x10DE, 0x0042, 0xFFFF, 0xFFFF, "NV40 [GeForce 6800 LE](0x0042)"},
{0x10DE, 0x0042, 0x107D, 0x299B, "WinFast A400 LE(0x107D-0x299B)"},
{0x10DE, 0x0043, 0xFFFF, 0xFFFF, "NV40 [GeForce 6800 XE](0x0043)"},
{0x10DE, 0x0044, 0xFFFF, 0xFFFF, "NV40 [GeForce 6800 XT](0x0044)"},
{0x10DE, 0x0045, 0xFFFF, 0xFFFF, "NV40 [GeForce 6800 GT](0x0045)"},
{0x10DE, 0x0045, 0x1043, 0x817D, "V9999GT(0x1043-0x817D)"},
{0x10DE, 0x0045, 0x1458, 0x3140, "GV-N68T256D(0x1458-0x3140)"},
{0x10DE, 0x0047, 0xFFFF, 0xFFFF, "NV40 [GeForce 6800 GS](0x0047)"},
{0x10DE, 0x0047, 0x1682, 0x2109, "GeForce 6800 GS(0x1682-0x2109)"},
{0x10DE, 0x0048, 0xFFFF, 0xFFFF, "NV40 [GeForce 6800 XT](0x0048)"},
{0x10DE, 0x004E, 0xFFFF, 0xFFFF, "NV40GL [Quadro FX 4000](0x004E)"},
{0x10DE, 0x0050, 0xFFFF, 0xFFFF, "CK804 ISA Bridge(0x0050)"},
{0x10DE, 0x0050, 0x1043, 0x815A, "K8N4/A8N Series Mainboard(0x1043-0x815A)"},
{0x10DE, 0x0050, 0x10F1, 0x2865, "Tomcat K8E (S2865)(0x10F1-0x2865)"},
{0x10DE, 0x0050, 0x1458, 0x0C11, "GA-K8N Ultra-9 Mainboard(0x1458-0x0C11)"},
{0x10DE, 0x0050, 0x1462, 0x7100, "MSI K8N Diamond(0x1462-0x7100)"},
{0x10DE, 0x0050, 0x1462, 0x7125, "K8N Neo4-F mainboard(0x1462-0x7125)"},
{0x10DE, 0x0050, 0x147B, 0x1C1A, "KN8-Ultra Mainboard(0x147B-0x1C1A)"},
{0x10DE, 0x0050, 0x1565, 0x3402, "NF4 AM2L Mainboard(0x1565-0x3402)"},
{0x10DE, 0x0051, 0xFFFF, 0xFFFF, "CK804 ISA Bridge(0x0051)"},
{0x10DE, 0x0051, 0x1028, 0x0225, "PowerEdge T105 ISA Bridge(0x1028-0x0225)"},
{0x10DE, 0x0052, 0xFFFF, 0xFFFF, "CK804 SMBus(0x0052)"},
{0x10DE, 0x0052, 0x1028, 0x0225, "PowerEdge T105 SMBus(0x1028-0x0225)"},
{0x10DE, 0x0052, 0x1043, 0x815A, "K8N4/A8N Series Mainboard(0x1043-0x815A)"},
{0x10DE, 0x0052, 0x10F1, 0x2865, "Tomcat K8E (S2865)(0x10F1-0x2865)"},
{0x10DE, 0x0052, 0x1458, 0x0C11, "GA-K8N Ultra-9 Mainboard(0x1458-0x0C11)"},
{0x10DE, 0x0052, 0x1462, 0x7100, "MSI K8N Diamond(0x1462-0x7100)"},
{0x10DE, 0x0052, 0x1462, 0x7125, "K8N Neo4-F mainboard(0x1462-0x7125)"},
{0x10DE, 0x0052, 0x147B, 0x1C1A, "KN8-Ultra Mainboard(0x147B-0x1C1A)"},
{0x10DE, 0x0052, 0x1565, 0x3402, "NF4 AM2L Mainboard(0x1565-0x3402)"},
{0x10DE, 0x0053, 0xFFFF, 0xFFFF, "CK804 IDE(0x0053)"},
{0x10DE, 0x0053, 0x1043, 0x815A, "K8N4/A8N Series Mainboard(0x1043-0x815A)"},
{0x10DE, 0x0053, 0x10F1, 0x2865, "Tomcat K8E (S2865)(0x10F1-0x2865)"},
{0x10DE, 0x0053, 0x1458, 0x5002, "GA-K8N Ultra-9 Mainboard(0x1458-0x5002)"},
{0x10DE, 0x0053, 0x1462, 0x7100, "MSI K8N Diamond(0x1462-0x7100)"},
{0x10DE, 0x0053, 0x1462, 0x7125, "K8N Neo4-F mainboard(0x1462-0x7125)"},
{0x10DE, 0x0053, 0x147B, 0x1C1A, "KN8-Ultra Mainboard(0x147B-0x1C1A)"},
{0x10DE, 0x0053, 0x1565, 0x3402, "NF4 AM2L Mainboard(0x1565-0x3402)"},
{0x10DE, 0x0054, 0xFFFF, 0xFFFF, "CK804 Serial ATA Controller(0x0054)"},
{0x10DE, 0x0054, 0x1028, 0x0225, "PowerEdge T105 Serial ATA(0x1028-0x0225)"},
{0x10DE, 0x0054, 0x1043, 0x815A, "A8N Series Mainboard(0x1043-0x815A)"},
{0x10DE, 0x0054, 0x10F1, 0x2865, "Tomcat K8E (S2865)(0x10F1-0x2865)"},
{0x10DE, 0x0054, 0x1458, 0xB003, "GA-K8N Ultra-9 Mainboard(0x1458-0xB003)"},
{0x10DE, 0x0054, 0x1462, 0x7100, "MSI K8N Diamond(0x1462-0x7100)"},
{0x10DE, 0x0054, 0x1462, 0x7125, "K8N Neo4-F mainboard(0x1462-0x7125)"},
{0x10DE, 0x0054, 0x147B, 0x1C1A, "KN8-Ultra Mainboard(0x147B-0x1C1A)"},
{0x10DE, 0x0054, 0x1565, 0x5401, "NF4 AM2L Mainboard(0x1565-0x5401)"},
{0x10DE, 0x0055, 0xFFFF, 0xFFFF, "CK804 Serial ATA Controller(0x0055)"},
{0x10DE, 0x0055, 0x1028, 0x0225, "PowerEdge T105 Serial ATA(0x1028-0x0225)"},
{0x10DE, 0x0055, 0x1043, 0x815A, "K8N4/A8N Series Mainboard(0x1043-0x815A)"},
{0x10DE, 0x0055, 0x10F1, 0x2865, "Tomcat K8E (S2865)(0x10F1-0x2865)"},
{0x10DE, 0x0055, 0x1458, 0xB003, "GA-K8N Ultra-9 Mainboard(0x1458-0xB003)"},
{0x10DE, 0x0055, 0x1462, 0x7125, "K8N Neo4-F mainboard(0x1462-0x7125)"},
{0x10DE, 0x0055, 0x147B, 0x1C1A, "KN8-Ultra Mainboard(0x147B-0x1C1A)"},
{0x10DE, 0x0055, 0x1565, 0x5401, "NF4 AM2L Mainboard(0x1565-0x5401)"},
{0x10DE, 0x0056, 0xFFFF, 0xFFFF, "CK804 Ethernet Controller(0x0056)"},
{0x10DE, 0x0057, 0xFFFF, 0xFFFF, "CK804 Ethernet Controller(0x0057)"},
{0x10DE, 0x0057, 0x1043, 0x8141, "K8N4/A8N Series Mainboard(0x1043-0x8141)"},
{0x10DE, 0x0057, 0x10DE, 0xCB84, "NF4 Lanparty(0x10DE-0xCB84)"},
{0x10DE, 0x0057, 0x10F1, 0x2865, "Tomcat K8E (S2865)(0x10F1-0x2865)"},
{0x10DE, 0x0057, 0x1458, 0xE000, "GA-K8N Ultra-9 Mainboard(0x1458-0xE000)"},
{0x10DE, 0x0057, 0x1462, 0x7100, "MSI K8N Diamond(0x1462-0x7100)"},
{0x10DE, 0x0057, 0x1462, 0x7125, "K8N Neo4-F mainboard(0x1462-0x7125)"},
{0x10DE, 0x0057, 0x147B, 0x1C1A, "KN8-Ultra Mainboard(0x147B-0x1C1A)"},
{0x10DE, 0x0057, 0x1565, 0x2501, "NF4 AM2L Mainboard(0x1565-0x2501)"},
{0x10DE, 0x0058, 0xFFFF, 0xFFFF, "CK804 AC'97 Modem(0x0058)"},
{0x10DE, 0x0059, 0xFFFF, 0xFFFF, "CK804 AC'97 Audio Controller(0x0059)"},
{0x10DE, 0x0059, 0x1043, 0x812A, "K8N4/A8N Series Mainboard(0x1043-0x812A)"},
{0x10DE, 0x0059, 0x10F1, 0x2865, "Tomcat K8E (S2865)(0x10F1-0x2865)"},
{0x10DE, 0x0059, 0x1462, 0x7585, "K8N Neo4-F mainboard(0x1462-0x7585)"},
{0x10DE, 0x0059, 0x147B, 0x1C1A, "KN8-Ultra Mainboard(0x147B-0x1C1A)"},
{0x10DE, 0x0059, 0x1565, 0x8211, "NF4 AM2L Mainboard(0x1565-0x8211)"},
{0x10DE, 0x005A, 0xFFFF, 0xFFFF, "CK804 USB Controller(0x005A)"},
{0x10DE, 0x005A, 0x1028, 0x0225, "PowerEdge T105 onboard USB(0x1028-0x0225)"},
{0x10DE, 0x005A, 0x1043, 0x815A, "K8N4/A8N Series Mainboard(0x1043-0x815A)"},
{0x10DE, 0x005A, 0x10F1, 0x2865, "Tomcat K8E (S2865)(0x10F1-0x2865)"},
{0x10DE, 0x005A, 0x1458, 0x5004, "GA-K8N Ultra-9 Mainboard(0x1458-0x5004)"},
{0x10DE, 0x005A, 0x1462, 0x7100, "MSI K8N Diamond(0x1462-0x7100)"},
{0x10DE, 0x005A, 0x1462, 0x7125, "K8N Neo4-F mainboard(0x1462-0x7125)"},
{0x10DE, 0x005A, 0x147B, 0x1C1A, "KN8-Ultra Mainboard(0x147B-0x1C1A)"},
{0x10DE, 0x005A, 0x1565, 0x3402, "NF4 AM2L Mainboard(0x1565-0x3402)"},
{0x10DE, 0x005B, 0xFFFF, 0xFFFF, "CK804 USB Controller(0x005B)"},
{0x10DE, 0x005B, 0x1028, 0x0225, "PowerEdge T105 onboard USB(0x1028-0x0225)"},
{0x10DE, 0x005B, 0x1043, 0x815A, "K8N4/A8N Series Mainboard(0x1043-0x815A)"},
{0x10DE, 0x005B, 0x10F1, 0x2865, "Tomcat K8E (S2865)(0x10F1-0x2865)"},
{0x10DE, 0x005B, 0x1458, 0x5004, "GA-K8N Ultra-9 Mainboard(0x1458-0x5004)"},
{0x10DE, 0x005B, 0x1462, 0x7100, "MSI K8N Diamond(0x1462-0x7100)"},
{0x10DE, 0x005B, 0x1462, 0x7125, "K8N Neo4-F mainboard(0x1462-0x7125)"},
{0x10DE, 0x005B, 0x147B, 0x1C1A, "KN8-Ultra Mainboard(0x147B-0x1C1A)"},
{0x10DE, 0x005B, 0x1565, 0x3402, "NF4 AM2L Mainboard(0x1565-0x3402)"},
{0x10DE, 0x005C, 0xFFFF, 0xFFFF, "CK804 PCI Bridge(0x005C)"},
{0x10DE, 0x005D, 0xFFFF, 0xFFFF, "CK804 PCIE Bridge(0x005D)"},
{0x10DE, 0x005E, 0xFFFF, 0xFFFF, "CK804 Memory Controller(0x005E)"},
{0x10DE, 0x005E, 0x1028, 0x0225, "PowerEdge T105 Memory Controller(0x1028-0x0225)"},
{0x10DE, 0x005E, 0x1043, 0x815A, "A8N Series Mainboard(0x1043-0x815A)"},
{0x10DE, 0x005E, 0x10DE, 0x005E, "ECS Elitegroup NFORCE3-A939 motherboard.(0x10DE-0x005E)"},
{0x10DE, 0x005E, 0x10F1, 0x2865, "Tomcat K8E (S2865)(0x10F1-0x2865)"},
{0x10DE, 0x005E, 0x10F1, 0x2891, "Thunder K8SRE Mainboard(0x10F1-0x2891)"},
{0x10DE, 0x005E, 0x1458, 0x5000, "GA-K8N Ultra-9 Mainboard(0x1458-0x5000)"},
{0x10DE, 0x005E, 0x1462, 0x7100, "K8N Diamond Mainboard(0x1462-0x7100)"},
{0x10DE, 0x005E, 0x1462, 0x7125, "K8N Neo4-F Mainboard(0x1462-0x7125)"},
{0x10DE, 0x005E, 0x147B, 0x1C1A, "KN8-Ultra Mainboard(0x147B-0x1C1A)"},
{0x10DE, 0x005E, 0x1565, 0x3402, "NF4 AM2L Mainboard(0x1565-0x3402)"},
{0x10DE, 0x005F, 0xFFFF, 0xFFFF, "CK804 Memory Controller(0x005F)"},
{0x10DE, 0x0060, 0xFFFF, 0xFFFF, "nForce2 ISA Bridge(0x0060)"},
{0x10DE, 0x0060, 0x1043, 0x80AD, "A7N8X Mainboard(0x1043-0x80AD)"},
{0x10DE, 0x0060, 0x147B, 0x1C02, "NF7-S/NF7 (nVidia-nForce2) 2.X(0x147B-0x1C02)"},
{0x10DE, 0x0060, 0xA0A0, 0x03BA, "UK79G-1394 motherboard(0xA0A0-0x03BA)"},
{0x10DE, 0x0064, 0xFFFF, 0xFFFF, "nForce2 SMBus (MCP)(0x0064)"},
{0x10DE, 0x0064, 0x147B, 0x1C02, "NF7-S/NF7 (nVidia-nForce2) 2.X(0x147B-0x1C02)"},
{0x10DE, 0x0064, 0xA0A0, 0x03BB, "UK79G-1394 motherboard(0xA0A0-0x03BB)"},
{0x10DE, 0x0065, 0xFFFF, 0xFFFF, "nForce2 IDE(0x0065)"},
{0x10DE, 0x0065, 0x10DE, 0x0C11, "nForce 2 EIDE Controller(0x10DE-0x0C11)"},
{0x10DE, 0x0065, 0xA0A0, 0x03B2, "UK79G-1394 motherboard(0xA0A0-0x03B2)"},
{0x10DE, 0x0066, 0xFFFF, 0xFFFF, "nForce2 Ethernet Controller(0x0066)"},
{0x10DE, 0x0066, 0x1043, 0x80A7, "A7N8X Mainboard onboard nForce2 Ethernet(0x1043-0x80A7)"},
{0x10DE, 0x0066, 0x10DE, 0x0C11, "nForce MCP-T Networking Adapter(0x10DE-0x0C11)"},
{0x10DE, 0x0066, 0xA0A0, 0x03B3, "UK79G-1394 motherboard(0xA0A0-0x03B3)"},
{0x10DE, 0x0067, 0xFFFF, 0xFFFF, "nForce2 USB Controller(0x0067)"},
{0x10DE, 0x0067, 0x1043, 0x0C11, "A7N8X Mainboard(0x1043-0x0C11)"},
{0x10DE, 0x0067, 0xA0A0, 0x03B4, "UK79G-1394 motherboard(0xA0A0-0x03B4)"},
{0x10DE, 0x0068, 0xFFFF, 0xFFFF, "nForce2 USB Controller(0x0068)"},
{0x10DE, 0x0068, 0x1043, 0x0C11, "A7N8X Mainboard(0x1043-0x0C11)"},
{0x10DE, 0x0068, 0xA0A0, 0x03B4, "UK79G-1394 motherboard(0xA0A0-0x03B4)"},
{0x10DE, 0x006A, 0xFFFF, 0xFFFF, "nForce2 AC97 Audio Controler (MCP)(0x006A)"},
{0x10DE, 0x006A, 0x1043, 0x8095, "nForce2 AC97 Audio Controller (MCP)(0x1043-0x8095)"},
{0x10DE, 0x006A, 0xA0A0, 0x0304, "UK79G-1394 motherboard(0xA0A0-0x0304)"},
{0x10DE, 0x006B, 0xFFFF, 0xFFFF, "nForce Audio Processing Unit(0x006B)"},
{0x10DE, 0x006B, 0x10DE, 0x006B, "nForce2 MCP Audio Processing Unit(0x10DE-0x006B)"},
{0x10DE, 0x006B, 0xA0A0, 0x0304, "UK79G-1394 motherboard(0xA0A0-0x0304)"},
{0x10DE, 0x006C, 0xFFFF, 0xFFFF, "nForce2 External PCI Bridge(0x006C)"},
{0x10DE, 0x006D, 0xFFFF, 0xFFFF, "nForce2 PCI Bridge(0x006D)"},
{0x10DE, 0x006E, 0xFFFF, 0xFFFF, "nForce2 FireWire (IEEE 1394) Controller(0x006E)"},
{0x10DE, 0x006E, 0xA0A0, 0x0306, "UK79G-1394 motherboard(0xA0A0-0x0306)"},
{0x10DE, 0x0080, 0xFFFF, 0xFFFF, "MCP2A ISA bridge(0x0080)"},
{0x10DE, 0x0080, 0x147B, 0x1C09, "NV7 Motherboard(0x147B-0x1C09)"},
{0x10DE, 0x0084, 0xFFFF, 0xFFFF, "MCP2A SMBus(0x0084)"},
{0x10DE, 0x0084, 0x147B, 0x1C09, "NV7 Motherboard(0x147B-0x1C09)"},
{0x10DE, 0x0085, 0xFFFF, 0xFFFF, "MCP2A IDE(0x0085)"},
{0x10DE, 0x0085, 0x147B, 0x1C09, "NV7 Motherboard(0x147B-0x1C09)"},
{0x10DE, 0x0086, 0xFFFF, 0xFFFF, "MCP2A Ethernet Controller(0x0086)"},
{0x10DE, 0x0087, 0xFFFF, 0xFFFF, "MCP2A USB Controller(0x0087)"},
{0x10DE, 0x0087, 0x147B, 0x1C09, "NV7 Motherboard(0x147B-0x1C09)"},
{0x10DE, 0x0088, 0xFFFF, 0xFFFF, "MCP2A USB Controller(0x0088)"},
{0x10DE, 0x0088, 0x147B, 0x1C09, "NV7 Motherboard(0x147B-0x1C09)"},
{0x10DE, 0x008A, 0xFFFF, 0xFFFF, "MCP2S AC'97 Audio Controller(0x008A)"},
{0x10DE, 0x008A, 0x147B, 0x1C09, "NV7 Motherboard(0x147B-0x1C09)"},
{0x10DE, 0x008B, 0xFFFF, 0xFFFF, "MCP2A PCI Bridge(0x008B)"},
{0x10DE, 0x008C, 0xFFFF, 0xFFFF, "MCP2A Ethernet Controller(0x008C)"},
{0x10DE, 0x008E, 0xFFFF, 0xFFFF, "nForce2 Serial ATA Controller(0x008E)"},
{0x10DE, 0x0090, 0xFFFF, 0xFFFF, "G70 [GeForce 7800 GTX](0x0090)"},
{0x10DE, 0x0091, 0xFFFF, 0xFFFF, "G70 [GeForce 7800 GTX](0x0091)"},
{0x10DE, 0x0092, 0xFFFF, 0xFFFF, "G70 [GeForce 7800 GT](0x0092)"},
{0x10DE, 0x0093, 0xFFFF, 0xFFFF, "G70 [GeForce 7800 GS](0x0093)"},
{0x10DE, 0x0094, 0xFFFF, 0xFFFF, "High Definition Audio(0x0094)"},
{0x10DE, 0x0095, 0xFFFF, 0xFFFF, "G70 [GeForce 7800 SLI](0x0095)"},
{0x10DE, 0x0097, 0xFFFF, 0xFFFF, "G70 [GeForce GTS 250](0x0097)"},
{0x10DE, 0x0098, 0xFFFF, 0xFFFF, "G70M [GeForce Go 7800](0x0098)"},
{0x10DE, 0x0099, 0xFFFF, 0xFFFF, "G70M [GeForce Go 7800 GTX](0x0099)"},
{0x10DE, 0x009D, 0xFFFF, 0xFFFF, "G70GL [Quadro FX 4500](0x009D)"},
{0x10DE, 0x00A0, 0xFFFF, 0xFFFF, "NV0A [Aladdin TNT2 IGP](0x00A0)"},
{0x10DE, 0x00A0, 0x14AF, 0x5810, "Maxi Gamer Xentor(0x14AF-0x5810)"},
{0x10DE, 0x00C0, 0xFFFF, 0xFFFF, "NV41 [GeForce 6800 GS](0x00C0)"},
{0x10DE, 0x00C1, 0xFFFF, 0xFFFF, "NV41 [GeForce 6800](0x00C1)"},
{0x10DE, 0x00C2, 0xFFFF, 0xFFFF, "NV41 [GeForce 6800 LE](0x00C2)"},
{0x10DE, 0x00C3, 0xFFFF, 0xFFFF, "NV41 [GeForce 6800 XT](0x00C3)"},
{0x10DE, 0x00C5, 0xFFFF, 0xFFFF, "NV41(0x00C5)"},
{0x10DE, 0x00C6, 0xFFFF, 0xFFFF, "NV41(0x00C6)"},
{0x10DE, 0x00C7, 0xFFFF, 0xFFFF, "NV41(0x00C7)"},
{0x10DE, 0x00C8, 0xFFFF, 0xFFFF, "NV41M [GeForce Go 6800](0x00C8)"},
{0x10DE, 0x00C9, 0xFFFF, 0xFFFF, "NV41M [GeForce Go 6800 Ultra](0x00C9)"},
{0x10DE, 0x00CC, 0xFFFF, 0xFFFF, "NV41GLM [Quadro FX Go1400](0x00CC)"},
{0x10DE, 0x00CD, 0xFFFF, 0xFFFF, "NV42GL [Quadro FX 3450/4000 SDI](0x00CD)"},
{0x10DE, 0x00CD, 0x10DE, 0x029B, "Quadro FX 3450(0x10DE-0x029B)"},
{0x10DE, 0x00CE, 0xFFFF, 0xFFFF, "NV41GL [Quadro FX 1400](0x00CE)"},
{0x10DE, 0x00CF, 0xFFFF, 0xFFFF, "NV41(0x00CF)"},
{0x10DE, 0x00D0, 0xFFFF, 0xFFFF, "nForce3 LPC Bridge(0x00D0)"},
{0x10DE, 0x00D1, 0xFFFF, 0xFFFF, "nForce3 Host Bridge(0x00D1)"},
{0x10DE, 0x00D2, 0xFFFF, 0xFFFF, "nForce3 AGP Bridge(0x00D2)"},
{0x10DE, 0x00D3, 0xFFFF, 0xFFFF, "CK804 Memory Controller(0x00D3)"},
{0x10DE, 0x00D4, 0xFFFF, 0xFFFF, "nForce3 SMBus(0x00D4)"},
{0x10DE, 0x00D5, 0xFFFF, 0xFFFF, "nForce3 IDE(0x00D5)"},
{0x10DE, 0x00D6, 0xFFFF, 0xFFFF, "nForce3 Ethernet(0x00D6)"},
{0x10DE, 0x00D7, 0xFFFF, 0xFFFF, "nForce3 USB 1.1(0x00D7)"},
{0x10DE, 0x00D8, 0xFFFF, 0xFFFF, "nForce3 USB 2.0(0x00D8)"},
{0x10DE, 0x00D9, 0xFFFF, 0xFFFF, "nForce3 Audio(0x00D9)"},
{0x10DE, 0x00DA, 0xFFFF, 0xFFFF, "nForce3 Audio(0x00DA)"},
{0x10DE, 0x00DD, 0xFFFF, 0xFFFF, "nForce3 PCI Bridge(0x00DD)"},
{0x10DE, 0x00DF, 0xFFFF, 0xFFFF, "CK8S Ethernet Controller(0x00DF)"},
{0x10DE, 0x00DF, 0x1043, 0x80A7, "K8N-E(0x1043-0x80A7)"},
{0x10DE, 0x00DF, 0x105B, 0x0C43, "Winfast NF3250K8AA(0x105B-0x0C43)"},
{0x10DE, 0x00DF, 0x147B, 0x1C0B, "NF8 Mainboard(0x147B-0x1C0B)"},
{0x10DE, 0x00E0, 0xFFFF, 0xFFFF, "nForce3 250Gb LPC Bridge(0x00E0)"},
{0x10DE, 0x00E0, 0x1043, 0x813F, "K8N-E(0x1043-0x813F)"},
{0x10DE, 0x00E0, 0x10DE, 0x0C11, "Winfast NF3250K8AA(0x10DE-0x0C11)"},
{0x10DE, 0x00E0, 0x1462, 0x7030, "K8N Neo-FSR v2.0(0x1462-0x7030)"},
{0x10DE, 0x00E0, 0x147B, 0x1C0B, "NF8 Mainboard(0x147B-0x1C0B)"},
{0x10DE, 0x00E0, 0x1849, 0x00E0, "Motherboard (one of many)(0x1849-0x00E0)"},
{0x10DE, 0x00E1, 0xFFFF, 0xFFFF, "nForce3 250Gb Host Bridge(0x00E1)"},
{0x10DE, 0x00E1, 0x1043, 0x813F, "K8N-E(0x1043-0x813F)"},
{0x10DE, 0x00E1, 0x1462, 0x7030, "K8N Neo-FSR v2.0(0x1462-0x7030)"},
{0x10DE, 0x00E1, 0x147B, 0x1C0B, "NF8 Mainboard(0x147B-0x1C0B)"},
{0x10DE, 0x00E1, 0x1849, 0x00E1, "Motherboard (one of many)(0x1849-0x00E1)"},
{0x10DE, 0x00E2, 0xFFFF, 0xFFFF, "nForce3 250Gb AGP Host to PCI Bridge(0x00E2)"},
{0x10DE, 0x00E3, 0xFFFF, 0xFFFF, "nForce3 Serial ATA Controller(0x00E3)"},
{0x10DE, 0x00E3, 0x1043, 0x813F, "K8N-E(0x1043-0x813F)"},
{0x10DE, 0x00E3, 0x105B, 0x0C43, "Winfast NF3250K8AA(0x105B-0x0C43)"},
{0x10DE, 0x00E3, 0x147B, 0x1C0B, "NF8 Mainboard(0x147B-0x1C0B)"},
{0x10DE, 0x00E3, 0x1849, 0x00E3, "Motherboard (one of many)(0x1849-0x00E3)"},
{0x10DE, 0x00E4, 0xFFFF, 0xFFFF, "nForce 250Gb PCI System Management(0x00E4)"},
{0x10DE, 0x00E4, 0x1043, 0x813F, "K8N-E(0x1043-0x813F)"},
{0x10DE, 0x00E4, 0x105B, 0x0C43, "Winfast NF3250K8AA(0x105B-0x0C43)"},
{0x10DE, 0x00E4, 0x1462, 0x7030, "K8N Neo-FSR v2.0(0x1462-0x7030)"},
{0x10DE, 0x00E4, 0x147B, 0x1C0B, "NF8 Mainboard(0x147B-0x1C0B)"},
{0x10DE, 0x00E4, 0x1849, 0x00E4, "Motherboard (one of many)(0x1849-0x00E4)"},
{0x10DE, 0x00E5, 0xFFFF, 0xFFFF, "CK8S Parallel ATA Controller (v2.5)(0x00E5)"},
{0x10DE, 0x00E5, 0x1043, 0x813F, "K8N-E(0x1043-0x813F)"},
{0x10DE, 0x00E5, 0x105B, 0x0C43, "Winfast NF3250K8AA(0x105B-0x0C43)"},
{0x10DE, 0x00E5, 0x1462, 0x7030, "K8N Neo-FSR v2.0(0x1462-0x7030)"},
{0x10DE, 0x00E5, 0x147B, 0x1C0B, "NF8 Mainboard(0x147B-0x1C0B)"},
{0x10DE, 0x00E5, 0x1849, 0x00E5, "Motherboard (one of many)(0x1849-0x00E5)"},
{0x10DE, 0x00E5, 0xF849, 0x00E5, "Motherboard (one of many)(0xF849-0x00E5)"},
{0x10DE, 0x00E6, 0xFFFF, 0xFFFF, "CK8S Ethernet Controller(0x00E6)"},
{0x10DE, 0x00E7, 0xFFFF, 0xFFFF, "CK8S USB Controller(0x00E7)"},
{0x10DE, 0x00E7, 0x1043, 0x813F, "K8N-E(0x1043-0x813F)"},
{0x10DE, 0x00E7, 0x105B, 0x0C43, "Winfast NF3250K8AA(0x105B-0x0C43)"},
{0x10DE, 0x00E7, 0x1462, 0x7030, "K8N Neo-FSR v2.0(0x1462-0x7030)"},
{0x10DE, 0x00E7, 0x147B, 0x1C0B, "NF8 Mainboard(0x147B-0x1C0B)"},
{0x10DE, 0x00E7, 0x1849, 0x00E7, "Motherboard (one of many)(0x1849-0x00E7)"},
{0x10DE, 0x00E8, 0xFFFF, 0xFFFF, "nForce3 EHCI USB 2.0 Controller(0x00E8)"},
{0x10DE, 0x00E8, 0x1043, 0x813F, "K8N-E(0x1043-0x813F)"},
{0x10DE, 0x00E8, 0x105B, 0x0C43, "Winfast NF3250K8AA(0x105B-0x0C43)"},
{0x10DE, 0x00E8, 0x1462, 0x7030, "K8N Neo-FSR v2.0(0x1462-0x7030)"},
{0x10DE, 0x00E8, 0x147B, 0x1C0B, "NF8 Mainboard(0x147B-0x1C0B)"},
{0x10DE, 0x00E8, 0x1849, 0x00E8, "Motherboard (one of many)(0x1849-0x00E8)"},
{0x10DE, 0x00EA, 0xFFFF, 0xFFFF, "nForce3 250Gb AC'97 Audio Controller(0x00EA)"},
{0x10DE, 0x00EA, 0x1043, 0x819D, "K8N-E(0x1043-0x819D)"},
{0x10DE, 0x00EA, 0x105B, 0x0C43, "Winfast NF3250K8AA(0x105B-0x0C43)"},
{0x10DE, 0x00EA, 0x1462, 0xB010, "K8N Neo-FSR v2.0(0x1462-0xB010)"},
{0x10DE, 0x00EA, 0x147B, 0x1C0B, "NF8 Mainboard(0x147B-0x1C0B)"},
{0x10DE, 0x00ED, 0xFFFF, 0xFFFF, "nForce3 250Gb PCI-to-PCI Bridge(0x00ED)"},
{0x10DE, 0x00EE, 0xFFFF, 0xFFFF, "nForce3 Serial ATA Controller 2(0x00EE)"},
{0x10DE, 0x00F1, 0xFFFF, 0xFFFF, "NV43 [GeForce 6600 GT](0x00F1)"},
{0x10DE, 0x00F1, 0x1043, 0x81A6, "N6600GT TD 128M AGP(0x1043-0x81A6)"},
{0x10DE, 0x00F1, 0x1043, 0x81C6, "N6600GT TD 128M AGP(0x1043-0x81C6)"},
{0x10DE, 0x00F1, 0x1458, 0x3150, "GV-N66T128VP(0x1458-0x3150)"},
{0x10DE, 0x00F1, 0x1554, 0x1191, "PixelView PV-N43UA (128KD)(0x1554-0x1191)"},
{0x10DE, 0x00F1, 0x1682, 0x2119, "GeForce 6600 GT AGP(0x1682-0x2119)"},
{0x10DE, 0x00F2, 0xFFFF, 0xFFFF, "NV43 [GeForce 6600](0x00F2)"},
{0x10DE, 0x00F2, 0x1554, 0x1194, "PixelView PV-N43AT (256KD)(0x1554-0x1194)"},
{0x10DE, 0x00F2, 0x1682, 0x211C, "GeForce 6600 256MB DDR DUAL DVI TV(0x1682-0x211C)"},
{0x10DE, 0x00F3, 0xFFFF, 0xFFFF, "NV43 [GeForce 6200](0x00F3)"},
{0x10DE, 0x00F4, 0xFFFF, 0xFFFF, "NV43 [GeForce 6600 LE](0x00F4)"},
{0x10DE, 0x00F5, 0xFFFF, 0xFFFF, "G70/G71 [GeForce 7800 GS AGP](0x00F5)"},
{0x10DE, 0x00F6, 0xFFFF, 0xFFFF, "NV43 [GeForce 6800 GS/XT](0x00F6)"},
{0x10DE, 0x00F6, 0x1682, 0x217E, "XFX GeForce 6800 XTreme 256MB DDR3 AGP(0x1682-0x217E)"},
{0x10DE, 0x00F8, 0xFFFF, 0xFFFF, "NV45GL [Quadro FX 3400/4400](0x00F8)"},
{0x10DE, 0x00F9, 0xFFFF, 0xFFFF, "NV40 [GeForce 6800 GT/GTO/Ultra](0x00F9)"},
{0x10DE, 0x00F9, 0x10DE, 0x00F9, "NV40 [GeForce 6800 GT](0x10DE-0x00F9)"},
{0x10DE, 0x00F9, 0x1682, 0x2120, "GEFORCE 6800 GT PCI-E(0x1682-0x2120)"},
{0x10DE, 0x00FA, 0xFFFF, 0xFFFF, "NV39 [GeForce PCX 5750](0x00FA)"},
{0x10DE, 0x00FB, 0xFFFF, 0xFFFF, "NV35 [GeForce PCX 5900](0x00FB)"},
{0x10DE, 0x00FC, 0xFFFF, 0xFFFF, "NV37GL [Quadro FX 330/GeForce PCX 5300](0x00FC)"},
{0x10DE, 0x00FD, 0xFFFF, 0xFFFF, "NV37GL [Quadro PCI-E Series](0x00FD)"},
{0x10DE, 0x00FE, 0xFFFF, 0xFFFF, "NV38GL [Quadro FX 1300](0x00FE)"},
{0x10DE, 0x00FF, 0xFFFF, 0xFFFF, "NV19 [GeForce PCX 4300](0x00FF)"},
{0x10DE, 0x0100, 0xFFFF, 0xFFFF, "NV10 [GeForce 256 SDR](0x0100)"},
{0x10DE, 0x0100, 0x1043, 0x0200, "AGP-V6600 SGRAM(0x1043-0x0200)"},
{0x10DE, 0x0100, 0x1043, 0x0201, "AGP-V6600 SDRAM(0x1043-0x0201)"},
{0x10DE, 0x0100, 0x1043, 0x4008, "AGP-V6600 SGRAM(0x1043-0x4008)"},
{0x10DE, 0x0100, 0x1043, 0x4009, "AGP-V6600 SDRAM(0x1043-0x4009)"},
{0x10DE, 0x0100, 0x1048, 0x0C41, "Erazor X(0x1048-0x0C41)"},
{0x10DE, 0x0100, 0x1048, 0x0C43, "ERAZOR X PCI(0x1048-0x0C43)"},
{0x10DE, 0x0100, 0x1048, 0x0C48, "Synergy Force(0x1048-0x0C48)"},
{0x10DE, 0x0100, 0x1102, 0x102D, "CT6941 GeForce 256(0x1102-0x102D)"},
{0x10DE, 0x0100, 0x14AF, 0x5022, "3D Prophet SE(0x14AF-0x5022)"},
{0x10DE, 0x0101, 0xFFFF, 0xFFFF, "NV10 [GeForce 256 DDR](0x0101)"},
{0x10DE, 0x0101, 0x1043, 0x0202, "AGP-V6800 DDR(0x1043-0x0202)"},
{0x10DE, 0x0101, 0x1043, 0x400A, "AGP-V6800 DDR SGRAM(0x1043-0x400A)"},
{0x10DE, 0x0101, 0x1043, 0x400B, "AGP-V6800 DDR SDRAM(0x1043-0x400B)"},
{0x10DE, 0x0101, 0x1048, 0x0C42, "Erazor X(0x1048-0x0C42)"},
{0x10DE, 0x0101, 0x107D, 0x2822, "WinFast GeForce 256(0x107D-0x2822)"},
{0x10DE, 0x0101, 0x1102, 0x102E, "CT6970/CT6971(0x1102-0x102E)"},
{0x10DE, 0x0101, 0x14AF, 0x5021, "3D Prophet DDR-DVI(0x14AF-0x5021)"},
{0x10DE, 0x0103, 0xFFFF, 0xFFFF, "NV10GL [Quadro](0x0103)"},
{0x10DE, 0x0103, 0x1048, 0x0C40, "GLoria II-64(0x1048-0x0C40)"},
{0x10DE, 0x0103, 0x1048, 0x0C44, "GLoria II(0x1048-0x0C44)"},
{0x10DE, 0x0103, 0x1048, 0x0C45, "GLoria II(0x1048-0x0C45)"},
{0x10DE, 0x0103, 0x1048, 0x0C4A, "GLoria II-64 Pro(0x1048-0x0C4A)"},
{0x10DE, 0x0103, 0x1048, 0x0C4B, "GLoria II-64 Pro DVII(0x1048-0x0C4B)"},
{0x10DE, 0x0103, 0x10A9, 0x9002, "VPro VR3(0x10A9-0x9002)"},
{0x10DE, 0x0110, 0xFFFF, 0xFFFF, "NV11 [GeForce2 MX/MX 400](0x0110)"},
{0x10DE, 0x0110, 0x1043, 0x4015, "AGP-V7100 Pro(0x1043-0x4015)"},
{0x10DE, 0x0110, 0x1043, 0x4021, "V7100 Deluxe Combo(0x1043-0x4021)"},
{0x10DE, 0x0110, 0x1043, 0x4031, "V7100 Pro with TV output(0x1043-0x4031)"},
{0x10DE, 0x0110, 0x1048, 0x0C60, "Gladiac MX(0x1048-0x0C60)"},
{0x10DE, 0x0110, 0x1048, 0x0C61, "Gladiac 511PCI(0x1048-0x0C61)"},
{0x10DE, 0x0110, 0x1048, 0x0C63, "Gladiac 511TV-OUT 32MB(0x1048-0x0C63)"},
{0x10DE, 0x0110, 0x1048, 0x0C64, "Gladiac 511TV-OUT 64MB(0x1048-0x0C64)"},
{0x10DE, 0x0110, 0x1048, 0x0C65, "Gladiac 511TWIN(0x1048-0x0C65)"},
{0x10DE, 0x0110, 0x1048, 0x0C66, "Gladiac 311(0x1048-0x0C66)"},
{0x10DE, 0x0110, 0x10B0, 0x0001, "GeForce2 MX Jumbo TV(0x10B0-0x0001)"},
{0x10DE, 0x0110, 0x10DE, 0x0091, "Dell OEM GeForce 2 MX 400(0x10DE-0x0091)"},
{0x10DE, 0x0110, 0x10DE, 0x00A1, "Apple OEM GeForce2 MX(0x10DE-0x00A1)"},
{0x10DE, 0x0110, 0x1462, 0x8523, "MS-8852(0x1462-0x8523)"},
{0x10DE, 0x0110, 0x1462, 0x8817, "MSI GeForce2 MX400 Pro32S [MS-8817](0x1462-0x8817)"},
{0x10DE, 0x0110, 0x14AF, 0x7102, "3D Prophet II MX(0x14AF-0x7102)"},
{0x10DE, 0x0110, 0x14AF, 0x7103, "3D Prophet II MX Dual-Display(0x14AF-0x7103)"},
{0x10DE, 0x0110, 0x1545, 0x0023, "Xtasy Rev. B2(0x1545-0x0023)"},
{0x10DE, 0x0110, 0x1554, 0x1081, "MVGA-NVG11AM(400)(0x1554-0x1081)"},
{0x10DE, 0x0111, 0xFFFF, 0xFFFF, "NV11 [GeForce2 MX200](0x0111)"},
{0x10DE, 0x0112, 0xFFFF, 0xFFFF, "NV11M [GeForce2 Go](0x0112)"},
{0x10DE, 0x0113, 0xFFFF, 0xFFFF, "NV11GL [Quadro2 MXR/EX/Go](0x0113)"},
{0x10DE, 0x0113, 0x1028, 0x00E5, "Quadro2 Go(0x1028-0x00E5)"},
{0x10DE, 0x0140, 0xFFFF, 0xFFFF, "NV43 [GeForce 6600 GT](0x0140)"},
{0x10DE, 0x0140, 0x1458, 0x3125, "GV-NX66T128D(0x1458-0x3125)"},
{0x10DE, 0x0140, 0x1458, 0x3126, "GV-NX66T256DE(0x1458-0x3126)"},
{0x10DE, 0x0140, 0x1462, 0x8939, "MS-8983(0x1462-0x8939)"},
{0x10DE, 0x0141, 0xFFFF, 0xFFFF, "NV43 [GeForce 6600](0x0141)"},
{0x10DE, 0x0141, 0x1043, 0x81B0, "EN6600 Silencer(0x1043-0x81B0)"},
{0x10DE, 0x0141, 0x107D, 0x593A, "LR2A22 128MB TV OUT(0x107D-0x593A)"},
{0x10DE, 0x0141, 0x107D, 0x597B, "WINFAST PX6600(0x107D-0x597B)"},
{0x10DE, 0x0141, 0x1458, 0x3124, "GV-NX66128DP Turbo Force Edition(0x1458-0x3124)"},
{0x10DE, 0x0142, 0xFFFF, 0xFFFF, "NV43 [GeForce 6600 LE](0x0142)"},
{0x10DE, 0x0143, 0xFFFF, 0xFFFF, "NV43 [GeForce 6600 VE](0x0143)"},
{0x10DE, 0x0144, 0xFFFF, 0xFFFF, "NV43M [GeForce Go 6600](0x0144)"},
{0x10DE, 0x0145, 0xFFFF, 0xFFFF, "NV43 [GeForce 6610 XL](0x0145)"},
{0x10DE, 0x0146, 0xFFFF, 0xFFFF, "NV43M [GeForce Go6200 TE / 6600 TE](0x0146)"},
{0x10DE, 0x0147, 0xFFFF, 0xFFFF, "NV43 [GeForce 6700 XL](0x0147)"},
{0x10DE, 0x0148, 0xFFFF, 0xFFFF, "NV43M [GeForce Go 6600](0x0148)"},
{0x10DE, 0x0149, 0xFFFF, 0xFFFF, "NV43M [GeForce Go 6600 GT](0x0149)"},
{0x10DE, 0x014A, 0xFFFF, 0xFFFF, "NV43 [Quadro NVS 440](0x014A)"},
{0x10DE, 0x014B, 0xFFFF, 0xFFFF, "NV43(0x014B)"},
{0x10DE, 0x014D, 0xFFFF, 0xFFFF, "NV43GL [Quadro FX 550](0x014D)"},
{0x10DE, 0x014E, 0xFFFF, 0xFFFF, "NV43GL [Quadro FX 540](0x014E)"},
{0x10DE, 0x014F, 0xFFFF, 0xFFFF, "NV43 [GeForce 6200](0x014F)"},
{0x10DE, 0x0150, 0xFFFF, 0xFFFF, "NV15 [GeForce2 GTS/Pro](0x0150)"},
{0x10DE, 0x0150, 0x1043, 0x4016, "V7700 AGP Video Card(0x1043-0x4016)"},
{0x10DE, 0x0150, 0x1043, 0x402A, "AGP-V7700(0x1043-0x402A)"},
{0x10DE, 0x0150, 0x1048, 0x0C50, "Gladiac(0x1048-0x0C50)"},
{0x10DE, 0x0150, 0x1048, 0x0C52, "Gladiac-64(0x1048-0x0C52)"},
{0x10DE, 0x0150, 0x107D, 0x2840, "WinFast GeForce2 GTS with TV output(0x107D-0x2840)"},
{0x10DE, 0x0150, 0x107D, 0x2842, "WinFast GeForce 2 Pro(0x107D-0x2842)"},
{0x10DE, 0x0150, 0x10DE, 0x002E, "GeForce2 GTS(0x10DE-0x002E)"},
{0x10DE, 0x0150, 0x1462, 0x815A, "MS-8815(0x1462-0x815A)"},
{0x10DE, 0x0150, 0x1462, 0x8831, "Creative GeForce2 Pro(0x1462-0x8831)"},
{0x10DE, 0x0151, 0xFFFF, 0xFFFF, "NV15 [GeForce2 Ti](0x0151)"},
{0x10DE, 0x0151, 0x1043, 0x405F, "V7700Ti(0x1043-0x405F)"},
{0x10DE, 0x0151, 0x1462, 0x5506, "Creative 3D Blaster GeForce2 Titanium(0x1462-0x5506)"},
{0x10DE, 0x0151, 0x1462, 0x8364, "MS-8836(0x1462-0x8364)"},
{0x10DE, 0x0152, 0xFFFF, 0xFFFF, "NV15 [GeForce2 Ultra](0x0152)"},
{0x10DE, 0x0152, 0x1048, 0x0C56, "GLADIAC Ultra(0x1048-0x0C56)"},
{0x10DE, 0x0153, 0xFFFF, 0xFFFF, "NV15GL [Quadro2 Pro](0x0153)"},
{0x10DE, 0x0160, 0xFFFF, 0xFFFF, "NV44 [GeForce 6500](0x0160)"},
{0x10DE, 0x0161, 0xFFFF, 0xFFFF, "NV44 [GeForce 6200 TurboCache](0x0161)"},
{0x10DE, 0x0162, 0xFFFF, 0xFFFF, "NV44 [GeForce 6200 SE TurboCache](0x0162)"},
{0x10DE, 0x0163, 0xFFFF, 0xFFFF, "NV44 [GeForce 6200 LE](0x0163)"},
{0x10DE, 0x0164, 0xFFFF, 0xFFFF, "NV44M [GeForce Go 6200](0x0164)"},
{0x10DE, 0x0165, 0xFFFF, 0xFFFF, "NV44 [Quadro NVS 285](0x0165)"},
{0x10DE, 0x0166, 0xFFFF, 0xFFFF, "NV44M [GeForce Go 6400](0x0166)"},
{0x10DE, 0x0167, 0xFFFF, 0xFFFF, "NV44M [GeForce Go 6200](0x0167)"},
{0x10DE, 0x0168, 0xFFFF, 0xFFFF, "NV44M [GeForce Go 6400](0x0168)"},
{0x10DE, 0x0169, 0xFFFF, 0xFFFF, "NV44 [GeForce 6250](0x0169)"},
{0x10DE, 0x016A, 0xFFFF, 0xFFFF, "NV44 [GeForce 7100 GS](0x016A)"},
{0x10DE, 0x016D, 0xFFFF, 0xFFFF, "NV44(0x016D)"},
{0x10DE, 0x016E, 0xFFFF, 0xFFFF, "NV44(0x016E)"},
{0x10DE, 0x016F, 0xFFFF, 0xFFFF, "NV44(0x016F)"},
{0x10DE, 0x0170, 0xFFFF, 0xFFFF, "NV17 [GeForce4 MX 460](0x0170)"},
{0x10DE, 0x0170, 0x1462, 0x8630, "MS-8863(0x1462-0x8630)"},
{0x10DE, 0x0171, 0xFFFF, 0xFFFF, "NV17 [GeForce4 MX 440](0x0171)"},
{0x10DE, 0x0171, 0x10B0, 0x0002, "Gainward Pro/600 TV(0x10B0-0x0002)"},
{0x10DE, 0x0171, 0x10DE, 0x0008, "Apple OEM GeForce4 MX 440(0x10DE-0x0008)"},
{0x10DE, 0x0171, 0x1462, 0x8661, "G4MX440-VTP(0x1462-0x8661)"},
{0x10DE, 0x0171, 0x1462, 0x8730, "MX440SES-T (MS-8873)(0x1462-0x8730)"},
{0x10DE, 0x0171, 0x1462, 0x8743, "MS-8874(0x1462-0x8743)"},
{0x10DE, 0x0171, 0x1462, 0x8852, "GeForce4 MX440 PCI(0x1462-0x8852)"},
{0x10DE, 0x0171, 0x147B, 0x8F00, "Abit Siluro GeForce4MX440(0x147B-0x8F00)"},
{0x10DE, 0x0172, 0xFFFF, 0xFFFF, "NV17 [GeForce4 MX 420](0x0172)"},
{0x10DE, 0x0172, 0x1462, 0x8730, "MS-8873(0x1462-0x8730)"},
{0x10DE, 0x0172, 0x1462, 0x8784, "MS-8878(0x1462-0x8784)"},
{0x10DE, 0x0173, 0xFFFF, 0xFFFF, "NV17 [GeForce4 MX 440-SE](0x0173)"},
{0x10DE, 0x0174, 0xFFFF, 0xFFFF, "NV17M [GeForce4 440 Go](0x0174)"},
{0x10DE, 0x0175, 0xFFFF, 0xFFFF, "NV17M [GeForce4 420 Go](0x0175)"},
{0x10DE, 0x0176, 0xFFFF, 0xFFFF, "NV17M [GeForce4 420 Go 32M](0x0176)"},
{0x10DE, 0x0176, 0x103C, 0x08B0, "tc1100 tablet(0x103C-0x08B0)"},
{0x10DE, 0x0176, 0x144D, 0xC005, "X10 Laptop(0x144D-0xC005)"},
{0x10DE, 0x0176, 0x4C53, 0x1090, "Cx9 / Vx9 mainboard(0x4C53-0x1090)"},
{0x10DE, 0x0177, 0xFFFF, 0xFFFF, "NV17M [GeForce4 460 Go](0x0177)"},
{0x10DE, 0x0178, 0xFFFF, 0xFFFF, "NV17GL [Quadro4 550 XGL](0x0178)"},
{0x10DE, 0x0179, 0xFFFF, 0xFFFF, "NV17M [GeForce4 440 Go 64M](0x0179)"},
{0x10DE, 0x0179, 0x10DE, 0x0179, "GeForce4 MX (Mac)(0x10DE-0x0179)"},
{0x10DE, 0x017A, 0xFFFF, 0xFFFF, "NV17GL [Quadro NVS](0x017A)"},
{0x10DE, 0x017B, 0xFFFF, 0xFFFF, "NV17GL [Quadro4 550 XGL](0x017B)"},
{0x10DE, 0x017C, 0xFFFF, 0xFFFF, "NV17GL [Quadro4 500 GoGL](0x017C)"},
{0x10DE, 0x017F, 0xFFFF, 0xFFFF, "NV17(0x017F)"},
{0x10DE, 0x0181, 0xFFFF, 0xFFFF, "NV18 [GeForce4 MX 440 AGP 8x](0x0181)"},
{0x10DE, 0x0181, 0x1043, 0x8063, "GeForce4 MX 440 AGP 8X(0x1043-0x8063)"},
{0x10DE, 0x0181, 0x1043, 0x806F, "V9180 Magic(0x1043-0x806F)"},
{0x10DE, 0x0181, 0x1462, 0x8880, "MS-StarForce GeForce4 MX 440 with AGP8X(0x1462-0x8880)"},
{0x10DE, 0x0181, 0x1462, 0x8900, "MS-8890 GeForce 4 MX440 AGP8X(0x1462-0x8900)"},
{0x10DE, 0x0181, 0x1462, 0x9350, "MSI GeForce4 MX T8X with AGP8X(0x1462-0x9350)"},
{0x10DE, 0x0181, 0x147B, 0x8F0D, "Siluro GF4 MX-8X(0x147B-0x8F0D)"},
{0x10DE, 0x0181, 0x1554, 0x1111, "PixelView MVGA-NVG18A(0x1554-0x1111)"},
{0x10DE, 0x0182, 0xFFFF, 0xFFFF, "NV18 [GeForce4 MX 440SE AGP 8x](0x0182)"},
{0x10DE, 0x0183, 0xFFFF, 0xFFFF, "NV18 [GeForce4 MX 420 AGP 8x](0x0183)"},
{0x10DE, 0x0184, 0xFFFF, 0xFFFF, "NV18 [GeForce4 MX](0x0184)"},
{0x10DE, 0x0185, 0xFFFF, 0xFFFF, "NV18 [GeForce4 MX 4000](0x0185)"},
{0x10DE, 0x0186, 0xFFFF, 0xFFFF, "NV18M [GeForce4 448 Go](0x0186)"},
{0x10DE, 0x0187, 0xFFFF, 0xFFFF, "NV18M [GeForce4 488 Go](0x0187)"},
{0x10DE, 0x0188, 0xFFFF, 0xFFFF, "NV18GL [Quadro4 580 XGL](0x0188)"},
{0x10DE, 0x0189, 0xFFFF, 0xFFFF, "NV18 [GeForce4 MX with AGP8X (Mac)](0x0189)"},
{0x10DE, 0x018A, 0xFFFF, 0xFFFF, "NV18GL [Quadro NVS 280 SD](0x018A)"},
{0x10DE, 0x018B, 0xFFFF, 0xFFFF, "NV18GL [Quadro4 380 XGL](0x018B)"},
{0x10DE, 0x018C, 0xFFFF, 0xFFFF, "NV18GL [Quadro NVS 50 PCI](0x018C)"},
{0x10DE, 0x018D, 0xFFFF, 0xFFFF, "NV18M [GeForce4 448 Go](0x018D)"},
{0x10DE, 0x0190, 0xFFFF, 0xFFFF, "G80 [GeForce 8800 GTS / 8800 GTX](0x0190)"},
{0x10DE, 0x0191, 0xFFFF, 0xFFFF, "G80 [GeForce 8800 GTX](0x0191)"},
{0x10DE, 0x0192, 0xFFFF, 0xFFFF, "G80 [GeForce 8800 GTS](0x0192)"},
{0x10DE, 0x0193, 0xFFFF, 0xFFFF, "G80 [GeForce 8800 GTS](0x0193)"},
{0x10DE, 0x0193, 0x107D, 0x20BD, "WinFast PX 8800 GTS TDH(0x107D-0x20BD)"},
{0x10DE, 0x0194, 0xFFFF, 0xFFFF, "G80 [GeForce 8800 Ultra](0x0194)"},
{0x10DE, 0x0197, 0xFFFF, 0xFFFF, "G80GL [Tesla C870](0x0197)"},
{0x10DE, 0x019D, 0xFFFF, 0xFFFF, "G80GL [Quadro FX 5600](0x019D)"},
{0x10DE, 0x019E, 0xFFFF, 0xFFFF, "G80GL [Quadro FX 4600](0x019E)"},
{0x10DE, 0x01A0, 0xFFFF, 0xFFFF, "nForce 220/420 NV1A [GeForce2 MX](0x01A0)"},
{0x10DE, 0x01A4, 0xFFFF, 0xFFFF, "nForce CPU bridge(0x01A4)"},
{0x10DE, 0x01AB, 0xFFFF, 0xFFFF, "nForce 420 Memory Controller (DDR)(0x01AB)"},
{0x10DE, 0x01AC, 0xFFFF, 0xFFFF, "nForce 220/420 Memory Controller(0x01AC)"},
{0x10DE, 0x01AD, 0xFFFF, 0xFFFF, "nForce 220/420 Memory Controller(0x01AD)"},
{0x10DE, 0x01B0, 0xFFFF, 0xFFFF, "nForce Audio Processing Unit(0x01B0)"},
{0x10DE, 0x01B1, 0xFFFF, 0xFFFF, "nForce AC'97 Audio Controller(0x01B1)"},
{0x10DE, 0x01B2, 0xFFFF, 0xFFFF, "nForce ISA Bridge(0x01B2)"},
{0x10DE, 0x01B4, 0xFFFF, 0xFFFF, "nForce PCI System Management(0x01B4)"},
{0x10DE, 0x01B7, 0xFFFF, 0xFFFF, "nForce AGP to PCI Bridge(0x01B7)"},
{0x10DE, 0x01B8, 0xFFFF, 0xFFFF, "nForce PCI-to-PCI bridge(0x01B8)"},
{0x10DE, 0x01BC, 0xFFFF, 0xFFFF, "nForce IDE(0x01BC)"},
{0x10DE, 0x01C1, 0xFFFF, 0xFFFF, "nForce AC'97 Modem Controller(0x01C1)"},
{0x10DE, 0x01C2, 0xFFFF, 0xFFFF, "nForce USB Controller(0x01C2)"},
{0x10DE, 0x01C3, 0xFFFF, 0xFFFF, "nForce Ethernet Controller(0x01C3)"},
{0x10DE, 0x01D0, 0xFFFF, 0xFFFF, "G72 [GeForce 7350 LE](0x01D0)"},
{0x10DE, 0x01D1, 0xFFFF, 0xFFFF, "G72 [GeForce 7300 LE](0x01D1)"},
{0x10DE, 0x01D1, 0x107D, 0x5EFA, "WinFast PX7300LE-TD128(0x107D-0x5EFA)"},
{0x10DE, 0x01D1, 0x107D, 0x5EFB, "WinFast PX7300LE-TD256(0x107D-0x5EFB)"},
{0x10DE, 0x01D1, 0x1462, 0x0345, "7300LE PCI Express Graphics Adapter(0x1462-0x0345)"},
{0x10DE, 0x01D2, 0xFFFF, 0xFFFF, "G72 [GeForce 7550 LE](0x01D2)"},
{0x10DE, 0x01D3, 0xFFFF, 0xFFFF, "G72 [GeForce 7200 GS / 7300 SE](0x01D3)"},
{0x10DE, 0x01D3, 0x1043, 0x8203, "EN7300SE(0x1043-0x8203)"},
{0x10DE, 0x01D3, 0x1043, 0x8250, "EN7200GS(0x1043-0x8250)"},
{0x10DE, 0x01D5, 0xFFFF, 0xFFFF, "G72(0x01D5)"},
{0x10DE, 0x01D6, 0xFFFF, 0xFFFF, "G72M [GeForce Go 7200](0x01D6)"},
{0x10DE, 0x01D7, 0xFFFF, 0xFFFF, "G72M [Quadro NVS 110M/GeForce Go 7300](0x01D7)"},
{0x10DE, 0x01D8, 0xFFFF, 0xFFFF, "G72M [GeForce Go 7400](0x01D8)"},
{0x10DE, 0x01D8, 0x1028, 0x01D7, "XPS M1210(0x1028-0x01D7)"},
{0x10DE, 0x01D9, 0xFFFF, 0xFFFF, "G72M [GeForce Go 7450](0x01D9)"},
{0x10DE, 0x01DA, 0xFFFF, 0xFFFF, "G72M [Quadro NVS 110M](0x01DA)"},
{0x10DE, 0x01DB, 0xFFFF, 0xFFFF, "G72M [Quadro NVS 120M](0x01DB)"},
{0x10DE, 0x01DC, 0xFFFF, 0xFFFF, "G72GLM [Quadro FX 350M](0x01DC)"},
{0x10DE, 0x01DD, 0xFFFF, 0xFFFF, "G72 [GeForce 7500 LE](0x01DD)"},
{0x10DE, 0x01DE, 0xFFFF, 0xFFFF, "G72GL [Quadro FX 350](0x01DE)"},
{0x10DE, 0x01DE, 0x10DE, 0x01DC, "Quadro  FX Go350M(0x10DE-0x01DC)"},
{0x10DE, 0x01DF, 0xFFFF, 0xFFFF, "G72 [GeForce 7300 GS](0x01DF)"},
{0x10DE, 0x01E0, 0xFFFF, 0xFFFF, "nForce2 IGP2(0x01E0)"},
{0x10DE, 0x01E0, 0x147B, 0x1C09, "NV7 Motherboard(0x147B-0x1C09)"},
{0x10DE, 0x01E8, 0xFFFF, 0xFFFF, "nForce2 AGP(0x01E8)"},
{0x10DE, 0x01EA, 0xFFFF, 0xFFFF, "nForce2 Memory Controller 0(0x01EA)"},
{0x10DE, 0x01EA, 0xA0A0, 0x03B9, "UK79G-1394 motherboard(0xA0A0-0x03B9)"},
{0x10DE, 0x01EB, 0xFFFF, 0xFFFF, "nForce2 Memory Controller 1(0x01EB)"},
{0x10DE, 0x01EB, 0xA0A0, 0x03B9, "UK79G-1394 motherboard(0xA0A0-0x03B9)"},
{0x10DE, 0x01EC, 0xFFFF, 0xFFFF, "nForce2 Memory Controller 2(0x01EC)"},
{0x10DE, 0x01EC, 0xA0A0, 0x03B9, "UK79G-1394 motherboard(0xA0A0-0x03B9)"},
{0x10DE, 0x01ED, 0xFFFF, 0xFFFF, "nForce2 Memory Controller 3(0x01ED)"},
{0x10DE, 0x01ED, 0xA0A0, 0x03B9, "UK79G-1394 motherboard(0xA0A0-0x03B9)"},
{0x10DE, 0x01EE, 0xFFFF, 0xFFFF, "nForce2 Memory Controller 4(0x01EE)"},
{0x10DE, 0x01EE, 0x10DE, 0x01EE, "MSI Delta-L nForce2 memory controller(0x10DE-0x01EE)"},
{0x10DE, 0x01EE, 0xA0A0, 0x03B9, "UK79G-1394 motherboard(0xA0A0-0x03B9)"},
{0x10DE, 0x01EF, 0xFFFF, 0xFFFF, "nForce2 Memory Controller 5(0x01EF)"},
{0x10DE, 0x01EF, 0xA0A0, 0x03B9, "UK79G-1394 motherboard(0xA0A0-0x03B9)"},
{0x10DE, 0x01F0, 0xFFFF, 0xFFFF, "NV1F C17 [GeForce4 MX IGP](0x01F0)"},
{0x10DE, 0x01F0, 0xA0A0, 0x03B5, "UK79G-1394 motherboard(0xA0A0-0x03B5)"},
{0x10DE, 0x0200, 0xFFFF, 0xFFFF, "NV20 [GeForce3](0x0200)"},
{0x10DE, 0x0200, 0x1043, 0x402F, "AGP-V8200 DDR(0x1043-0x402F)"},
{0x10DE, 0x0200, 0x1048, 0x0C70, "GLADIAC 920(0x1048-0x0C70)"},
{0x10DE, 0x0201, 0xFFFF, 0xFFFF, "NV20 [GeForce3 Ti 200](0x0201)"},
{0x10DE, 0x0201, 0x1462, 0x8503, "G3Ti200 Pro VT128(0x1462-0x8503)"},
{0x10DE, 0x0202, 0xFFFF, 0xFFFF, "NV20 [GeForce3 Ti 500](0x0202)"},
{0x10DE, 0x0202, 0x1043, 0x405B, "V8200 T5(0x1043-0x405B)"},
{0x10DE, 0x0202, 0x1545, 0x002F, "Xtasy 6964(0x1545-0x002F)"},
{0x10DE, 0x0203, 0xFFFF, 0xFFFF, "NV20GL [Quadro DCC](0x0203)"},
{0x10DE, 0x0211, 0xFFFF, 0xFFFF, "NV48 [GeForce 6800](0x0211)"},
{0x10DE, 0x0212, 0xFFFF, 0xFFFF, "NV48 [GeForce 6800 LE](0x0212)"},
{0x10DE, 0x0215, 0xFFFF, 0xFFFF, "NV48 [GeForce 6800 GT](0x0215)"},
{0x10DE, 0x0218, 0xFFFF, 0xFFFF, "NV48 [GeForce 6800 XT](0x0218)"},
{0x10DE, 0x0221, 0xFFFF, 0xFFFF, "NV44A [GeForce 6200](0x0221)"},
{0x10DE, 0x0221, 0x1043, 0x81E1, "N6200/TD/256M/A(0x1043-0x81E1)"},
{0x10DE, 0x0221, 0x3842, 0xA341, "256A8N341DX(0x3842-0xA341)"},
{0x10DE, 0x0222, 0xFFFF, 0xFFFF, "NV44 [GeForce 6200 A-LE](0x0222)"},
{0x10DE, 0x0224, 0xFFFF, 0xFFFF, "NV44(0x0224)"},
{0x10DE, 0x0240, 0xFFFF, 0xFFFF, "C51PV [GeForce 6150](0x0240)"},
{0x10DE, 0x0240, 0x1043, 0x81CD, "A8N-VM CSM(0x1043-0x81CD)"},
{0x10DE, 0x0240, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x0241, 0xFFFF, 0xFFFF, "C51 [GeForce 6150 LE](0x0241)"},
{0x10DE, 0x0242, 0xFFFF, 0xFFFF, "C51G [GeForce 6100](0x0242)"},
{0x10DE, 0x0242, 0x105B, 0x0CAD, "Winfast 6100K8MB(0x105B-0x0CAD)"},
{0x10DE, 0x0243, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x0243)"},
{0x10DE, 0x0244, 0xFFFF, 0xFFFF, "C51 [GeForce Go 6150](0x0244)"},
{0x10DE, 0x0244, 0x103C, 0x30B5, "Presario V3242AU(0x103C-0x30B5)"},
{0x10DE, 0x0244, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x0244, 0x10DE, 0x0244, "GeForce Go 6150(0x10DE-0x0244)"},
{0x10DE, 0x0245, 0xFFFF, 0xFFFF, "C51 [Quadro NVS 210S/GeForce 6150LE](0x0245)"},
{0x10DE, 0x0246, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x0246)"},
{0x10DE, 0x0247, 0xFFFF, 0xFFFF, "C51 [GeForce Go 6100](0x0247)"},
{0x10DE, 0x0247, 0x1043, 0x1382, "MCP51 PCI-X GeForce Go 6100(0x1043-0x1382)"},
{0x10DE, 0x0248, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x0248)"},
{0x10DE, 0x0249, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x0249)"},
{0x10DE, 0x024A, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x024A)"},
{0x10DE, 0x024B, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x024B)"},
{0x10DE, 0x024C, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x024C)"},
{0x10DE, 0x024D, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x024D)"},
{0x10DE, 0x024E, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x024E)"},
{0x10DE, 0x024F, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x024F)"},
{0x10DE, 0x0250, 0xFFFF, 0xFFFF, "NV25 [GeForce4 Ti 4600](0x0250)"},
{0x10DE, 0x0251, 0xFFFF, 0xFFFF, "NV25 [GeForce4 Ti 4400](0x0251)"},
{0x10DE, 0x0251, 0x1043, 0x8023, "v8440 GeForce 4 Ti4400(0x1043-0x8023)"},
{0x10DE, 0x0251, 0x10DE, 0x0251, "PNY GeForce4 Ti 4400(0x10DE-0x0251)"},
{0x10DE, 0x0251, 0x1462, 0x8710, "PNY GeForce4 Ti 4400(0x1462-0x8710)"},
{0x10DE, 0x0252, 0xFFFF, 0xFFFF, "NV25 [GeForce4 Ti](0x0252)"},
{0x10DE, 0x0253, 0xFFFF, 0xFFFF, "NV25 [GeForce4 Ti 4200](0x0253)"},
{0x10DE, 0x0253, 0x107D, 0x2896, "WinFast A250 LE TD (Dual VGA/TV-out/DVI)(0x107D-0x2896)"},
{0x10DE, 0x0253, 0x147B, 0x8F09, "Siluro (Dual VGA/TV-out/DVI)(0x147B-0x8F09)"},
{0x10DE, 0x0258, 0xFFFF, 0xFFFF, "NV25GL [Quadro4 900 XGL](0x0258)"},
{0x10DE, 0x0259, 0xFFFF, 0xFFFF, "NV25GL [Quadro4 750 XGL](0x0259)"},
{0x10DE, 0x025B, 0xFFFF, 0xFFFF, "NV25GL [Quadro4 700 XGL](0x025B)"},
{0x10DE, 0x0260, 0xFFFF, 0xFFFF, "MCP51 LPC Bridge(0x0260)"},
{0x10DE, 0x0260, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x0260, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x0260, 0x1043, 0x81BC, "A8N-VM CSM Mainboard(0x1043-0x81BC)"},
{0x10DE, 0x0260, 0x1458, 0x5001, "GA-M55plus-S3G(0x1458-0x5001)"},
{0x10DE, 0x0260, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x0261, 0xFFFF, 0xFFFF, "MCP51 LPC Bridge(0x0261)"},
{0x10DE, 0x0261, 0x105B, 0x0CAD, "Winfast 6100K8MB(0x105B-0x0CAD)"},
{0x10DE, 0x0262, 0xFFFF, 0xFFFF, "MCP51 LPC Bridge(0x0262)"},
{0x10DE, 0x0263, 0xFFFF, 0xFFFF, "MCP51 LPC Bridge(0x0263)"},
{0x10DE, 0x0264, 0xFFFF, 0xFFFF, "MCP51 SMBus(0x0264)"},
{0x10DE, 0x0264, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x0264, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x0264, 0x1043, 0x81BC, "A8N-VM CSM Mainboard(0x1043-0x81BC)"},
{0x10DE, 0x0264, 0x105B, 0x0CAD, "Winfast 6100K8MB(0x105B-0x0CAD)"},
{0x10DE, 0x0264, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x0265, 0xFFFF, 0xFFFF, "MCP51 IDE(0x0265)"},
{0x10DE, 0x0265, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x0265, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x0265, 0x1043, 0x81BC, "A8N-VM CSM Mainboard(0x1043-0x81BC)"},
{0x10DE, 0x0265, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x0265, 0xF05B, 0x0CAD, "Winfast 6100K8MB(0xF05B-0x0CAD)"},
{0x10DE, 0x0266, 0xFFFF, 0xFFFF, "MCP51 Serial ATA Controller(0x0266)"},
{0x10DE, 0x0266, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x0266, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x0266, 0x1043, 0x81BC, "A8N-VM CSM Mainboard(0x1043-0x81BC)"},
{0x10DE, 0x0266, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x0267, 0xFFFF, 0xFFFF, "MCP51 Serial ATA Controller(0x0267)"},
{0x10DE, 0x0267, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x0267, 0x1043, 0x81BC, "A8N-VM CSM Mainboard(0x1043-0x81BC)"},
{0x10DE, 0x0267, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x0268, 0xFFFF, 0xFFFF, "MCP51 Ethernet Controller(0x0268)"},
{0x10DE, 0x0269, 0xFFFF, 0xFFFF, "MCP51 Ethernet Controller(0x0269)"},
{0x10DE, 0x0269, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x0269, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x0269, 0x1043, 0x8141, "A8N-VM CSM Mainboard(0x1043-0x8141)"},
{0x10DE, 0x0269, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x026A, 0xFFFF, 0xFFFF, "MCP51 MCI(0x026A)"},
{0x10DE, 0x026B, 0xFFFF, 0xFFFF, "MCP51 AC97 Audio Controller(0x026B)"},
{0x10DE, 0x026B, 0x105B, 0x0CAD, "Winfast 6100K8MB(0x105B-0x0CAD)"},
{0x10DE, 0x026C, 0xFFFF, 0xFFFF, "MCP51 High Definition Audio(0x026C)"},
{0x10DE, 0x026C, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x026C, 0x103C, 0x30B5, "Presario V3242AU(0x103C-0x30B5)"},
{0x10DE, 0x026C, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x026C, 0x10DE, 0xCB84, "ASUSTeK Computer Inc. A8N-VM CSM Mainboard(0x10DE-0xCB84)"},
{0x10DE, 0x026C, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x026D, 0xFFFF, 0xFFFF, "MCP51 USB Controller(0x026D)"},
{0x10DE, 0x026D, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x026D, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x026D, 0x1043, 0x81BC, "A8N-VM CSM Mainboard(0x1043-0x81BC)"},
{0x10DE, 0x026D, 0x105B, 0x0CAD, "Winfast 6100K8MB(0x105B-0x0CAD)"},
{0x10DE, 0x026D, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x026E, 0xFFFF, 0xFFFF, "MCP51 USB Controller(0x026E)"},
{0x10DE, 0x026E, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x026E, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x026E, 0x1043, 0x81BC, "A8N-VM CSM Mainboard(0x1043-0x81BC)"},
{0x10DE, 0x026E, 0x105B, 0x0CAD, "Winfast 6100K8MB(0x105B-0x0CAD)"},
{0x10DE, 0x026E, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x026F, 0xFFFF, 0xFFFF, "MCP51 PCI Bridge(0x026F)"},
{0x10DE, 0x026F, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x0270, 0xFFFF, 0xFFFF, "MCP51 Host Bridge(0x0270)"},
{0x10DE, 0x0270, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x0270, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x0270, 0x1043, 0x81BC, "A8N-VM CSM Mainboard(0x1043-0x81BC)"},
{0x10DE, 0x0270, 0x105B, 0x0CAD, "Winfast 6100K8MB(0x105B-0x0CAD)"},
{0x10DE, 0x0270, 0x1458, 0x5001, "GA-M55plus-S3G(0x1458-0x5001)"},
{0x10DE, 0x0270, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x0271, 0xFFFF, 0xFFFF, "MCP51 PMU(0x0271)"},
{0x10DE, 0x0271, 0x103C, 0x30B5, "Presario V3242AU(0x103C-0x30B5)"},
{0x10DE, 0x0271, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x0272, 0xFFFF, 0xFFFF, "MCP51 Memory Controller 0(0x0272)"},
{0x10DE, 0x0272, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x0272, 0x105B, 0x0CAD, "Winfast 6100K8MB(0x105B-0x0CAD)"},
{0x10DE, 0x027E, 0xFFFF, 0xFFFF, "C51 Memory Controller 2(0x027E)"},
{0x10DE, 0x027E, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x027E, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x027E, 0x1043, 0x81CD, "A8N-VM CSM Mainboard(0x1043-0x81CD)"},
{0x10DE, 0x027E, 0x1458, 0x5000, "GA-M55plus-S3G(0x1458-0x5000)"},
{0x10DE, 0x027E, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x027F, 0xFFFF, 0xFFFF, "C51 Memory Controller 3(0x027F)"},
{0x10DE, 0x027F, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x027F, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x027F, 0x1043, 0x81CD, "A8N-VM CSM Mainboard(0x1043-0x81CD)"},
{0x10DE, 0x027F, 0x1458, 0x5000, "GA-M55plus-S3G(0x1458-0x5000)"},
{0x10DE, 0x027F, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x0280, 0xFFFF, 0xFFFF, "NV28 [GeForce4 Ti 4800](0x0280)"},
{0x10DE, 0x0281, 0xFFFF, 0xFFFF, "NV28 [GeForce4 Ti 4200 AGP 8x](0x0281)"},
{0x10DE, 0x0282, 0xFFFF, 0xFFFF, "NV28 [GeForce4 Ti 4800 SE](0x0282)"},
{0x10DE, 0x0286, 0xFFFF, 0xFFFF, "NV28M [GeForce4 Ti 4200 Go AGP 8x](0x0286)"},
{0x10DE, 0x0288, 0xFFFF, 0xFFFF, "NV28GL [Quadro4 980 XGL](0x0288)"},
{0x10DE, 0x0289, 0xFFFF, 0xFFFF, "NV28GL [Quadro4 780 XGL](0x0289)"},
{0x10DE, 0x028C, 0xFFFF, 0xFFFF, "NV28GLM [Quadro4 Go700](0x028C)"},
{0x10DE, 0x0290, 0xFFFF, 0xFFFF, "G71 [GeForce 7900 GTX](0x0290)"},
{0x10DE, 0x0291, 0xFFFF, 0xFFFF, "G71 [GeForce 7900 GT/GTO](0x0291)"},
{0x10DE, 0x0291, 0x10DE, 0x042B, "NX7900GTO-T2D512E [7900 GTO](0x10DE-0x042B)"},
{0x10DE, 0x0292, 0xFFFF, 0xFFFF, "G71 [GeForce 7900 GS](0x0292)"},
{0x10DE, 0x0293, 0xFFFF, 0xFFFF, "G71 [GeForce 7900 GX2](0x0293)"},
{0x10DE, 0x0294, 0xFFFF, 0xFFFF, "G71 [GeForce 7950 GX2](0x0294)"},
{0x10DE, 0x0295, 0xFFFF, 0xFFFF, "G71 [GeForce 7950 GT](0x0295)"},
{0x10DE, 0x0295, 0x1043, 0x8225, "GeForce 7950 GT(0x1043-0x8225)"},
{0x10DE, 0x0295, 0x107D, 0x2A68, "WinFast PX7950GT TDH(0x107D-0x2A68)"},
{0x10DE, 0x0295, 0x1462, 0x0663, "NX7950GT-VT2D512EZ-HD(0x1462-0x0663)"},
{0x10DE, 0x0297, 0xFFFF, 0xFFFF, "G71M [GeForce Go 7950 GTX](0x0297)"},
{0x10DE, 0x0298, 0xFFFF, 0xFFFF, "G71M [GeForce Go 7900 GS](0x0298)"},
{0x10DE, 0x0299, 0xFFFF, 0xFFFF, "G71M [GeForce Go 7900 GTX](0x0299)"},
{0x10DE, 0x029A, 0xFFFF, 0xFFFF, "G71GLM [Quadro FX 2500M](0x029A)"},
{0x10DE, 0x029B, 0xFFFF, 0xFFFF, "G71GLM [Quadro FX 1500M](0x029B)"},
{0x10DE, 0x029C, 0xFFFF, 0xFFFF, "G71GL [Quadro FX 5500](0x029C)"},
{0x10DE, 0x029D, 0xFFFF, 0xFFFF, "G71GL [Quadro FX 3500](0x029D)"},
{0x10DE, 0x029D, 0x1028, 0x019B, "G71GLM [Quadro FX 3500M](0x1028-0x019B)"},
{0x10DE, 0x029E, 0xFFFF, 0xFFFF, "G71GL [Quadro FX 1500](0x029E)"},
{0x10DE, 0x029F, 0xFFFF, 0xFFFF, "G71GL [Quadro FX 4500 X2](0x029F)"},
{0x10DE, 0x02A0, 0xFFFF, 0xFFFF, "NV2A [XGPU](0x02A0)"},
{0x10DE, 0x02A5, 0xFFFF, 0xFFFF, "MCPX CPU Bridge(0x02A5)"},
{0x10DE, 0x02A6, 0xFFFF, 0xFFFF, "MCPX Memory Controller(0x02A6)"},
{0x10DE, 0x02E0, 0xFFFF, 0xFFFF, "G73 [GeForce 7600 GT AGP](0x02E0)"},
{0x10DE, 0x02E0, 0x02E0, 0x2249, "GF 7600GT 560M 256MB DDR3 DUAL DVI TV(0x02E0-0x2249)"},
{0x10DE, 0x02E1, 0xFFFF, 0xFFFF, "G73 [GeForce 7600 GS AGP](0x02E1)"},
{0x10DE, 0x02E1, 0x1682, 0x222B, "PV-T73K-UAL3 (256MB)(0x1682-0x222B)"},
{0x10DE, 0x02E1, 0x1682, 0x2247, "GF 7600GS 512MB DDR2(0x1682-0x2247)"},
{0x10DE, 0x02E2, 0xFFFF, 0xFFFF, "G73 [GeForce 7300 GT AGP](0x02E2)"},
{0x10DE, 0x02E3, 0xFFFF, 0xFFFF, "G71 [GeForce 7900 GS AGP](0x02E3)"},
{0x10DE, 0x02E4, 0xFFFF, 0xFFFF, "G71 [GeForce 7950 GT AGP](0x02E4)"},
{0x10DE, 0x02E4, 0x1682, 0x2271, "PV-T71A-YDF7 (512MB)(0x1682-0x2271)"},
{0x10DE, 0x02E5, 0xFFFF, 0xFFFF, "G71 [GeForce 7600 GS AGP](0x02E5)"},
{0x10DE, 0x02F0, 0xFFFF, 0xFFFF, "C51 Host Bridge(0x02F0)"},
{0x10DE, 0x02F0, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x02F0, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x02F0, 0x1043, 0x81CD, "A8N-VM CSM Mainboard(0x1043-0x81CD)"},
{0x10DE, 0x02F0, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x02F1, 0xFFFF, 0xFFFF, "C51 Host Bridge(0x02F1)"},
{0x10DE, 0x02F1, 0x1458, 0x5000, "GA-M55plus-S3G(0x1458-0x5000)"},
{0x10DE, 0x02F2, 0xFFFF, 0xFFFF, "C51 Host Bridge(0x02F2)"},
{0x10DE, 0x02F3, 0xFFFF, 0xFFFF, "C51 Host Bridge(0x02F3)"},
{0x10DE, 0x02F4, 0xFFFF, 0xFFFF, "C51 Host Bridge(0x02F4)"},
{0x10DE, 0x02F5, 0xFFFF, 0xFFFF, "C51 Host Bridge(0x02F5)"},
{0x10DE, 0x02F6, 0xFFFF, 0xFFFF, "C51 Host Bridge(0x02F6)"},
{0x10DE, 0x02F7, 0xFFFF, 0xFFFF, "C51 Host Bridge(0x02F7)"},
{0x10DE, 0x02F8, 0xFFFF, 0xFFFF, "C51 Memory Controller 5(0x02F8)"},
{0x10DE, 0x02F8, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x02F8, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x02F8, 0x1043, 0x81CD, "A8N-VM CSM Mainboard(0x1043-0x81CD)"},
{0x10DE, 0x02F8, 0x1458, 0x5000, "GA-M55plus-S3G(0x1458-0x5000)"},
{0x10DE, 0x02F8, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x02F9, 0xFFFF, 0xFFFF, "C51 Memory Controller 4(0x02F9)"},
{0x10DE, 0x02F9, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x02F9, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x02F9, 0x1043, 0x81CD, "A8N-VM CSM Mainboard(0x1043-0x81CD)"},
{0x10DE, 0x02F9, 0x1458, 0x5000, "GA-M55plus-S3G(0x1458-0x5000)"},
{0x10DE, 0x02F9, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x02FA, 0xFFFF, 0xFFFF, "C51 Memory Controller 0(0x02FA)"},
{0x10DE, 0x02FA, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x02FA, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x02FA, 0x1043, 0x81CD, "A8N-VM CSM Mainboard(0x1043-0x81CD)"},
{0x10DE, 0x02FA, 0x1458, 0x5000, "GA-M55plus-S3G(0x1458-0x5000)"},
{0x10DE, 0x02FA, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x02FB, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x02FB)"},
{0x10DE, 0x02FC, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x02FC)"},
{0x10DE, 0x02FC, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x02FD, 0xFFFF, 0xFFFF, "C51 PCI Express Bridge(0x02FD)"},
{0x10DE, 0x02FD, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x02FE, 0xFFFF, 0xFFFF, "C51 Memory Controller 1(0x02FE)"},
{0x10DE, 0x02FE, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x02FE, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x02FE, 0x1043, 0x81CD, "A8N-VM CSM Mainboard(0x1043-0x81CD)"},
{0x10DE, 0x02FE, 0x1458, 0x5000, "GA-M55plus-S3G(0x1458-0x5000)"},
{0x10DE, 0x02FE, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x02FF, 0xFFFF, 0xFFFF, "C51 Host Bridge(0x02FF)"},
{0x10DE, 0x02FF, 0x103C, 0x2A34, "Pavilion a1677c(0x103C-0x2A34)"},
{0x10DE, 0x02FF, 0x103C, 0x30B7, "Presario V6133CL(0x103C-0x30B7)"},
{0x10DE, 0x02FF, 0x1043, 0x81CD, "A8N-VM CSM Mainboard(0x1043-0x81CD)"},
{0x10DE, 0x02FF, 0x1458, 0x5000, "GA-M55plus-S3G(0x1458-0x5000)"},
{0x10DE, 0x02FF, 0x1462, 0x7207, "K8NGM2 series(0x1462-0x7207)"},
{0x10DE, 0x0300, 0xFFFF, 0xFFFF, "NV30 [GeForce FX](0x0300)"},
{0x10DE, 0x0301, 0xFFFF, 0xFFFF, "NV30 [GeForce FX 5800 Ultra](0x0301)"},
{0x10DE, 0x0302, 0xFFFF, 0xFFFF, "NV30 [GeForce FX 5800](0x0302)"},
{0x10DE, 0x0308, 0xFFFF, 0xFFFF, "NV30GL [Quadro FX 2000](0x0308)"},
{0x10DE, 0x0309, 0xFFFF, 0xFFFF, "NV30GL [Quadro FX 1000](0x0309)"},
{0x10DE, 0x0311, 0xFFFF, 0xFFFF, "NV31 [GeForce FX 5600 Ultra](0x0311)"},
{0x10DE, 0x0312, 0xFFFF, 0xFFFF, "NV31 [GeForce FX 5600](0x0312)"},
{0x10DE, 0x0314, 0xFFFF, 0xFFFF, "NV31 [GeForce FX 5600XT](0x0314)"},
{0x10DE, 0x0314, 0x1043, 0x814A, "V9560XT/TD(0x1043-0x814A)"},
{0x10DE, 0x0316, 0xFFFF, 0xFFFF, "NV31M(0x0316)"},
{0x10DE, 0x0318, 0xFFFF, 0xFFFF, "NV31GL(0x0318)"},
{0x10DE, 0x031A, 0xFFFF, 0xFFFF, "NV31M [GeForce FX Go5600](0x031A)"},
{0x10DE, 0x031B, 0xFFFF, 0xFFFF, "NV31M [GeForce FX Go5650](0x031B)"},
{0x10DE, 0x031C, 0xFFFF, 0xFFFF, "NV31GLM [Quadro FX Go700](0x031C)"},
{0x10DE, 0x0320, 0xFFFF, 0xFFFF, "NV34 [GeForce FX 5200](0x0320)"},
{0x10DE, 0x0321, 0xFFFF, 0xFFFF, "NV34 [GeForce FX 5200 Ultra](0x0321)"},
{0x10DE, 0x0322, 0xFFFF, 0xFFFF, "NV34 [GeForce FX 5200](0x0322)"},
{0x10DE, 0x0322, 0x1043, 0x02FB, "V9250 Magic(0x1043-0x02FB)"},
{0x10DE, 0x0322, 0x1043, 0x8180, "V9520-X/TD/128M(0x1043-0x8180)"},
{0x10DE, 0x0322, 0x107D, 0x2967, "WinFast A340T 128MB(0x107D-0x2967)"},
{0x10DE, 0x0322, 0x1462, 0x9110, "MS-8911 (FX5200-TD128)(0x1462-0x9110)"},
{0x10DE, 0x0322, 0x1462, 0x9171, "MS-8917 (FX5200-T128)(0x1462-0x9171)"},
{0x10DE, 0x0322, 0x1462, 0x9360, "MS-8936 (FX5200-T128)(0x1462-0x9360)"},
{0x10DE, 0x0322, 0x1682, 0x1351, "GeForce FX 5200(0x1682-0x1351)"},
{0x10DE, 0x0323, 0xFFFF, 0xFFFF, "NV34 [GeForce FX 5200LE](0x0323)"},
{0x10DE, 0x0324, 0xFFFF, 0xFFFF, "NV34M [GeForce FX Go5200 64M](0x0324)"},
{0x10DE, 0x0324, 0x1028, 0x0196, "Inspiron 5160(0x1028-0x0196)"},
{0x10DE, 0x0324, 0x103C, 0x006A, "Pavilion ZD7000 laptop(0x103C-0x006A)"},
{0x10DE, 0x0324, 0x1071, 0x8160, "MIM2000(0x1071-0x8160)"},
{0x10DE, 0x0325, 0xFFFF, 0xFFFF, "NV34M [GeForce FX Go5250](0x0325)"},
{0x10DE, 0x0326, 0xFFFF, 0xFFFF, "NV34 [GeForce FX 5500](0x0326)"},
{0x10DE, 0x0326, 0x1458, 0x310D, "GeForce FX 5500 128 MB(0x1458-0x310D)"},
{0x10DE, 0x0326, 0x1682, 0x2034, "GeForce 5500 256 MB(0x1682-0x2034)"},
{0x10DE, 0x0327, 0xFFFF, 0xFFFF, "NV34 [GeForce FX 5100](0x0327)"},
{0x10DE, 0x0328, 0xFFFF, 0xFFFF, "NV34M [GeForce FX Go5200 32M/64M](0x0328)"},
{0x10DE, 0x0329, 0xFFFF, 0xFFFF, "NV34M [GeForce FX Go5200](0x0329)"},
{0x10DE, 0x0329, 0x10DE, 0x0010, "Powerbook G4(0x10DE-0x0010)"},
{0x10DE, 0x032A, 0xFFFF, 0xFFFF, "NV34GL [Quadro NVS 280 PCI](0x032A)"},
{0x10DE, 0x032B, 0xFFFF, 0xFFFF, "NV34GL [Quadro FX 500/600 PCI](0x032B)"},
{0x10DE, 0x032C, 0xFFFF, 0xFFFF, "NV34M [GeForce FX Go5300 / Go5350](0x032C)"},
{0x10DE, 0x032D, 0xFFFF, 0xFFFF, "NV34M [GeForce FX Go5100](0x032D)"},
{0x10DE, 0x032E, 0xFFFF, 0xFFFF, "NV34(0x032E)"},
{0x10DE, 0x032F, 0xFFFF, 0xFFFF, "NV34 [GeForce FX 5200](0x032F)"},
{0x10DE, 0x0330, 0xFFFF, 0xFFFF, "NV35 [GeForce FX 5900 Ultra](0x0330)"},
{0x10DE, 0x0330, 0x1043, 0x8137, "V9950 Ultra / 256 MB(0x1043-0x8137)"},
{0x10DE, 0x0331, 0xFFFF, 0xFFFF, "NV35 [GeForce FX 5900](0x0331)"},
{0x10DE, 0x0331, 0x1043, 0x8145, "V9950GE(0x1043-0x8145)"},
{0x10DE, 0x0332, 0xFFFF, 0xFFFF, "NV35 [GeForce FX 5900XT](0x0332)"},
{0x10DE, 0x0333, 0xFFFF, 0xFFFF, "NV38 [GeForce FX 5950 Ultra](0x0333)"},
{0x10DE, 0x0334, 0xFFFF, 0xFFFF, "NV35 [GeForce FX 5900ZT](0x0334)"},
{0x10DE, 0x0334, 0x1462, 0x9373, "FX5900ZT-VTD128 (MS-8937)(0x1462-0x9373)"},
{0x10DE, 0x0338, 0xFFFF, 0xFFFF, "NV35GL [Quadro FX 3000](0x0338)"},
{0x10DE, 0x033F, 0xFFFF, 0xFFFF, "NV35GL [Quadro FX 700](0x033F)"},
{0x10DE, 0x0341, 0xFFFF, 0xFFFF, "NV36 [GeForce FX 5700 Ultra](0x0341)"},
{0x10DE, 0x0341, 0x1462, 0x9380, "MS-8938 (FX5700U-TD128)(0x1462-0x9380)"},
{0x10DE, 0x0342, 0xFFFF, 0xFFFF, "NV36 [GeForce FX 5700](0x0342)"},
{0x10DE, 0x0343, 0xFFFF, 0xFFFF, "NV36 [GeForce FX 5700LE](0x0343)"},
{0x10DE, 0x0344, 0xFFFF, 0xFFFF, "NV36 [GeForce FX 5700VE](0x0344)"},
{0x10DE, 0x0347, 0xFFFF, 0xFFFF, "NV36M [GeForce FX Go5700](0x0347)"},
{0x10DE, 0x0347, 0x103C, 0x006A, "NX9500(0x103C-0x006A)"},
{0x10DE, 0x0348, 0xFFFF, 0xFFFF, "NV36M [GeForce FX Go5700](0x0348)"},
{0x10DE, 0x034C, 0xFFFF, 0xFFFF, "NV36 [Quadro FX Go1000](0x034C)"},
{0x10DE, 0x034D, 0xFFFF, 0xFFFF, "NV36(0x034D)"},
{0x10DE, 0x034E, 0xFFFF, 0xFFFF, "NV36GL [Quadro FX 1100](0x034E)"},
{0x10DE, 0x0360, 0xFFFF, 0xFFFF, "MCP55 LPC Bridge(0x0360)"},
{0x10DE, 0x0361, 0xFFFF, 0xFFFF, "MCP55 LPC Bridge(0x0361)"},
{0x10DE, 0x0361, 0x1028, 0x0221, "PowerEdge R805 MCP55 LPC Bridge(0x1028-0x0221)"},
{0x10DE, 0x0362, 0xFFFF, 0xFFFF, "MCP55 LPC Bridge(0x0362)"},
{0x10DE, 0x0362, 0x147B, 0x1C24, "KN9 series mainboard(0x147B-0x1C24)"},
{0x10DE, 0x0363, 0xFFFF, 0xFFFF, "MCP55 LPC Bridge(0x0363)"},
{0x10DE, 0x0364, 0xFFFF, 0xFFFF, "MCP55 LPC Bridge(0x0364)"},
{0x10DE, 0x0364, 0x1028, 0x0221, "PowerEdge R805 MCP55 LPC Bridge(0x1028-0x0221)"},
{0x10DE, 0x0365, 0xFFFF, 0xFFFF, "MCP55 LPC Bridge(0x0365)"},
{0x10DE, 0x0366, 0xFFFF, 0xFFFF, "MCP55 LPC Bridge(0x0366)"},
{0x10DE, 0x0367, 0xFFFF, 0xFFFF, "MCP55 LPC Bridge(0x0367)"},
{0x10DE, 0x0368, 0xFFFF, 0xFFFF, "MCP55 SMBus Controller(0x0368)"},
{0x10DE, 0x0368, 0x1028, 0x020C, "PowerEdge M605 MCP55 SMBus(0x1028-0x020C)"},
{0x10DE, 0x0368, 0x1028, 0x0221, "PowerEdge R805 MCP55 SMBus(0x1028-0x0221)"},
{0x10DE, 0x0368, 0x147B, 0x1C24, "KN9 series mainboard(0x147B-0x1C24)"},
{0x10DE, 0x0369, 0xFFFF, 0xFFFF, "MCP55 Memory Controller(0x0369)"},
{0x10DE, 0x0369, 0x147B, 0x1C24, "KN9 series mainboard(0x147B-0x1C24)"},
{0x10DE, 0x036A, 0xFFFF, 0xFFFF, "MCP55 Memory Controller(0x036A)"},
{0x10DE, 0x036B, 0xFFFF, 0xFFFF, "MCP55 SMU(0x036B)"},
{0x10DE, 0x036C, 0xFFFF, 0xFFFF, "MCP55 USB Controller(0x036C)"},
{0x10DE, 0x036C, 0x1028, 0x020C, "PowerEdge M605 MCP55 USB Controller(0x1028-0x020C)"},
{0x10DE, 0x036C, 0x1028, 0x0221, "PowerEdge R805 MCP55 USB Controller(0x1028-0x0221)"},
{0x10DE, 0x036C, 0x147B, 0x1C24, "KN9 series mainboard(0x147B-0x1C24)"},
{0x10DE, 0x036D, 0xFFFF, 0xFFFF, "MCP55 USB Controller(0x036D)"},
{0x10DE, 0x036D, 0x1028, 0x020C, "PowerEdge M605 MCP55 USB Controller(0x1028-0x020C)"},
{0x10DE, 0x036D, 0x1028, 0x0221, "PowerEdge R805 MCP55 USB Controller(0x1028-0x0221)"},
{0x10DE, 0x036D, 0x147B, 0x1C24, "KN9 series mainboard(0x147B-0x1C24)"},
{0x10DE, 0x036E, 0xFFFF, 0xFFFF, "MCP55 IDE(0x036E)"},
{0x10DE, 0x036E, 0x147B, 0x1C24, "KN9 series mainboard(0x147B-0x1C24)"},
{0x10DE, 0x0370, 0xFFFF, 0xFFFF, "MCP55 PCI bridge(0x0370)"},
{0x10DE, 0x0371, 0xFFFF, 0xFFFF, "MCP55 High Definition Audio(0x0371)"},
{0x10DE, 0x0371, 0x147B, 0x1C24, "KN9 series mainboard(0x147B-0x1C24)"},
{0x10DE, 0x0372, 0xFFFF, 0xFFFF, "MCP55 Ethernet(0x0372)"},
{0x10DE, 0x0373, 0xFFFF, 0xFFFF, "MCP55 Ethernet(0x0373)"},
{0x10DE, 0x0373, 0x147B, 0x1C24, "KN9 series mainboard(0x147B-0x1C24)"},
{0x10DE, 0x0374, 0xFFFF, 0xFFFF, "MCP55 PCI Express bridge(0x0374)"},
{0x10DE, 0x0375, 0xFFFF, 0xFFFF, "MCP55 PCI Express bridge(0x0375)"},
{0x10DE, 0x0376, 0xFFFF, 0xFFFF, "MCP55 PCI Express bridge(0x0376)"},
{0x10DE, 0x0377, 0xFFFF, 0xFFFF, "MCP55 PCI Express bridge(0x0377)"},
{0x10DE, 0x0378, 0xFFFF, 0xFFFF, "MCP55 PCI Express bridge(0x0378)"},
{0x10DE, 0x037A, 0xFFFF, 0xFFFF, "MCP55 Memory Controller(0x037A)"},
{0x10DE, 0x037E, 0xFFFF, 0xFFFF, "MCP55 SATA Controller(0x037E)"},
{0x10DE, 0x037F, 0xFFFF, 0xFFFF, "MCP55 SATA Controller(0x037F)"},
{0x10DE, 0x037F, 0x1028, 0x0221, "PowerEdge R805 MCP55 SATA Controller(0x1028-0x0221)"},
{0x10DE, 0x037F, 0x147B, 0x1C24, "KN9 series mainboard(0x147B-0x1C24)"},
{0x10DE, 0x038B, 0xFFFF, 0xFFFF, "G73 [GeForce 7650 GS](0x038B)"},
{0x10DE, 0x0390, 0xFFFF, 0xFFFF, "G73 [GeForce 7650 GS](0x0390)"},
{0x10DE, 0x0391, 0xFFFF, 0xFFFF, "G73 [GeForce 7600 GT](0x0391)"},
{0x10DE, 0x0391, 0x1458, 0x3427, "GV-NX76T128D-RH(0x1458-0x3427)"},
{0x10DE, 0x0391, 0x1462, 0x0452, "NX7600GT-VT2D256E(0x1462-0x0452)"},
{0x10DE, 0x0392, 0xFFFF, 0xFFFF, "G73 [GeForce 7600 GS](0x0392)"},
{0x10DE, 0x0392, 0x1462, 0x0622, "NX7600GS-T2D256EH(0x1462-0x0622)"},
{0x10DE, 0x0393, 0xFFFF, 0xFFFF, "G73 [GeForce 7300 GT](0x0393)"},
{0x10DE, 0x0393, 0x10DE, 0x0412, "NX7300GT-TD256EH(0x10DE-0x0412)"},
{0x10DE, 0x0393, 0x1462, 0x0412, "NX7300GT-TD256EH(0x1462-0x0412)"},
{0x10DE, 0x0394, 0xFFFF, 0xFFFF, "G73 [GeForce 7600 LE](0x0394)"},
{0x10DE, 0x0395, 0xFFFF, 0xFFFF, "G73 [GeForce 7300 GT](0x0395)"},
{0x10DE, 0x0396, 0xFFFF, 0xFFFF, "G73(0x0396)"},
{0x10DE, 0x0397, 0xFFFF, 0xFFFF, "G73M [GeForce Go 7700](0x0397)"},
{0x10DE, 0x0398, 0xFFFF, 0xFFFF, "G73M [GeForce Go 7600](0x0398)"},
{0x10DE, 0x0398, 0x1025, 0x006C, "Aspire 9814WKMi(0x1025-0x006C)"},
{0x10DE, 0x0399, 0xFFFF, 0xFFFF, "G73M [GeForce Go 7600 GT](0x0399)"},
{0x10DE, 0x039A, 0xFFFF, 0xFFFF, "G73M [Quadro NVS 300M](0x039A)"},
{0x10DE, 0x039B, 0xFFFF, 0xFFFF, "G73M [GeForce Go 7900 SE](0x039B)"},
{0x10DE, 0x039C, 0xFFFF, 0xFFFF, "G73GLM [Quadro FX 550M](0x039C)"},
{0x10DE, 0x039C, 0x10DE, 0x039C, "Quadro FX 560M(0x10DE-0x039C)"},
{0x10DE, 0x039D, 0xFFFF, 0xFFFF, "G73(0x039D)"},
{0x10DE, 0x039E, 0xFFFF, 0xFFFF, "G73GL [Quadro FX 560](0x039E)"},
{0x10DE, 0x039F, 0xFFFF, 0xFFFF, "G73(0x039F)"},
{0x10DE, 0x03A0, 0xFFFF, 0xFFFF, "C55 Host Bridge(0x03A0)"},
{0x10DE, 0x03A1, 0xFFFF, 0xFFFF, "C55 Host Bridge(0x03A1)"},
{0x10DE, 0x03A2, 0xFFFF, 0xFFFF, "C55 Host Bridge(0x03A2)"},
{0x10DE, 0x03A3, 0xFFFF, 0xFFFF, "C55 Host Bridge(0x03A3)"},
{0x10DE, 0x03A4, 0xFFFF, 0xFFFF, "C55 Host Bridge(0x03A4)"},
{0x10DE, 0x03A5, 0xFFFF, 0xFFFF, "C55 Host Bridge(0x03A5)"},
{0x10DE, 0x03A6, 0xFFFF, 0xFFFF, "C55 Host Bridge(0x03A6)"},
{0x10DE, 0x03A7, 0xFFFF, 0xFFFF, "C55 Host Bridge(0x03A7)"},
{0x10DE, 0x03A8, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03A8)"},
{0x10DE, 0x03A9, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03A9)"},
{0x10DE, 0x03AA, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03AA)"},
{0x10DE, 0x03AB, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03AB)"},
{0x10DE, 0x03AC, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03AC)"},
{0x10DE, 0x03AD, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03AD)"},
{0x10DE, 0x03AE, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03AE)"},
{0x10DE, 0x03AF, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03AF)"},
{0x10DE, 0x03B0, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03B0)"},
{0x10DE, 0x03B1, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03B1)"},
{0x10DE, 0x03B2, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03B2)"},
{0x10DE, 0x03B3, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03B3)"},
{0x10DE, 0x03B4, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03B4)"},
{0x10DE, 0x03B5, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03B5)"},
{0x10DE, 0x03B6, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03B6)"},
{0x10DE, 0x03B7, 0xFFFF, 0xFFFF, "C55 PCI Express bridge(0x03B7)"},
{0x10DE, 0x03B8, 0xFFFF, 0xFFFF, "C55 PCI Express bridge(0x03B8)"},
{0x10DE, 0x03B9, 0xFFFF, 0xFFFF, "C55 PCI Express bridge(0x03B9)"},
{0x10DE, 0x03BA, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03BA)"},
{0x10DE, 0x03BB, 0xFFFF, 0xFFFF, "C55 PCI Express bridge(0x03BB)"},
{0x10DE, 0x03BC, 0xFFFF, 0xFFFF, "C55 Memory Controller(0x03BC)"},
{0x10DE, 0x03D0, 0xFFFF, 0xFFFF, "C61 [GeForce 6150SE nForce 430](0x03D0)"},
{0x10DE, 0x03D0, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03D1, 0xFFFF, 0xFFFF, "C61 [GeForce 6100 nForce 405](0x03D1)"},
{0x10DE, 0x03D2, 0xFFFF, 0xFFFF, "C61 [GeForce 6100 nForce 400](0x03D2)"},
{0x10DE, 0x03D5, 0xFFFF, 0xFFFF, "C61 [GeForce 6100 nForce 420](0x03D5)"},
{0x10DE, 0x03D6, 0xFFFF, 0xFFFF, "C61 [GeForce 7025 / nForce 630a](0x03D6)"},
{0x10DE, 0x03E0, 0xFFFF, 0xFFFF, "MCP61 LPC Bridge(0x03E0)"},
{0x10DE, 0x03E0, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03E0, 0x1849, 0x03E0, "939NF6G-VSTA Board(0x1849-0x03E0)"},
{0x10DE, 0x03E1, 0xFFFF, 0xFFFF, "MCP61 LPC Bridge(0x03E1)"},
{0x10DE, 0x03E1, 0x1043, 0x83A4, "M4N68T series motherboard(0x1043-0x83A4)"},
{0x10DE, 0x03E2, 0xFFFF, 0xFFFF, "MCP61 Host Bridge(0x03E2)"},
{0x10DE, 0x03E2, 0x1043, 0x83A4, "M4N68T series motherboard(0x1043-0x83A4)"},
{0x10DE, 0x03E3, 0xFFFF, 0xFFFF, "MCP61 LPC Bridge(0x03E3)"},
{0x10DE, 0x03E4, 0xFFFF, 0xFFFF, "MCP61 High Definition Audio(0x03E4)"},
{0x10DE, 0x03E5, 0xFFFF, 0xFFFF, "MCP61 Ethernet(0x03E5)"},
{0x10DE, 0x03E6, 0xFFFF, 0xFFFF, "MCP61 Ethernet(0x03E6)"},
{0x10DE, 0x03E7, 0xFFFF, 0xFFFF, "MCP61 SATA Controller(0x03E7)"},
{0x10DE, 0x03E8, 0xFFFF, 0xFFFF, "MCP61 PCI Express bridge(0x03E8)"},
{0x10DE, 0x03E8, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03E8, 0x1849, 0x03E8, "939NF6G-VSTA Board(0x1849-0x03E8)"},
{0x10DE, 0x03E9, 0xFFFF, 0xFFFF, "MCP61 PCI Express bridge(0x03E9)"},
{0x10DE, 0x03E9, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03E9, 0x1849, 0x03E9, "939NF6G-VSTA Board(0x1849-0x03E9)"},
{0x10DE, 0x03EA, 0xFFFF, 0xFFFF, "MCP61 Memory Controller(0x03EA)"},
{0x10DE, 0x03EA, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03EA, 0x1849, 0x03EA, "939NF6G-VSTA Board(0x1849-0x03EA)"},
{0x10DE, 0x03EB, 0xFFFF, 0xFFFF, "MCP61 SMBus(0x03EB)"},
{0x10DE, 0x03EB, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03EB, 0x1043, 0x83A4, "M4N68T series motherboard(0x1043-0x83A4)"},
{0x10DE, 0x03EB, 0x1849, 0x03EB, "939NF6G-VSTA Board(0x1849-0x03EB)"},
{0x10DE, 0x03EC, 0xFFFF, 0xFFFF, "MCP61 IDE(0x03EC)"},
{0x10DE, 0x03EC, 0x1025, 0x0392, "ET1350(0x1025-0x0392)"},
{0x10DE, 0x03EC, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03EC, 0x1043, 0x83A4, "M4N68T series motherboard(0x1043-0x83A4)"},
{0x10DE, 0x03EC, 0x1849, 0x03EC, "939NF6G-VSTA Board(0x1849-0x03EC)"},
{0x10DE, 0x03EE, 0xFFFF, 0xFFFF, "MCP61 Ethernet(0x03EE)"},
{0x10DE, 0x03EF, 0xFFFF, 0xFFFF, "MCP61 Ethernet(0x03EF)"},
{0x10DE, 0x03EF, 0x1025, 0x8000, "ET1350(0x1025-0x8000)"},
{0x10DE, 0x03EF, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03EF, 0x1043, 0x83A4, "M4N68T series motherboard(0x1043-0x83A4)"},
{0x10DE, 0x03EF, 0x1849, 0x03EF, "939NF6G-VSTA Board(0x1849-0x03EF)"},
{0x10DE, 0x03F0, 0xFFFF, 0xFFFF, "MCP61 High Definition Audio(0x03F0)"},
{0x10DE, 0x03F0, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03F0, 0x1043, 0x8415, "M4N68T series motherboard(0x1043-0x8415)"},
{0x10DE, 0x03F0, 0x1849, 0x0888, "939NF6G-VSTA Board(0x1849-0x0888)"},
{0x10DE, 0x03F1, 0xFFFF, 0xFFFF, "MCP61 USB 1.1 Controller(0x03F1)"},
{0x10DE, 0x03F1, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03F1, 0x1043, 0x83A4, "M4N68T series motherboard(0x1043-0x83A4)"},
{0x10DE, 0x03F1, 0x1849, 0x03F1, "939NF6G-VSTA Board(0x1849-0x03F1)"},
{0x10DE, 0x03F2, 0xFFFF, 0xFFFF, "MCP61 USB 2.0 Controller(0x03F2)"},
{0x10DE, 0x03F2, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03F2, 0x1043, 0x83A4, "M4N68T series motherboard(0x1043-0x83A4)"},
{0x10DE, 0x03F2, 0x1849, 0x03F2, "939NF6G-VSTA Board(0x1849-0x03F2)"},
{0x10DE, 0x03F3, 0xFFFF, 0xFFFF, "MCP61 PCI bridge(0x03F3)"},
{0x10DE, 0x03F3, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03F3, 0x1849, 0x03F3, "939NF6G-VSTA Board(0x1849-0x03F3)"},
{0x10DE, 0x03F4, 0xFFFF, 0xFFFF, "MCP61 SMU(0x03F4)"},
{0x10DE, 0x03F5, 0xFFFF, 0xFFFF, "MCP61 Memory Controller(0x03F5)"},
{0x10DE, 0x03F5, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03F5, 0x1043, 0x83A4, "M4N68T series motherboard(0x1043-0x83A4)"},
{0x10DE, 0x03F5, 0x1849, 0x03EB, "939NF6G-VSTA Board(0x1849-0x03EB)"},
{0x10DE, 0x03F6, 0xFFFF, 0xFFFF, "MCP61 SATA Controller(0x03F6)"},
{0x10DE, 0x03F6, 0x1028, 0x020E, "Inspiron 531(0x1028-0x020E)"},
{0x10DE, 0x03F6, 0x1043, 0x83A4, "M4N68T series motherboard(0x1043-0x83A4)"},
{0x10DE, 0x03F6, 0x1849, 0x03F6, "939NF6G-VSTA Board(0x1849-0x03F6)"},
{0x10DE, 0x03F7, 0xFFFF, 0xFFFF, "MCP61 SATA Controller(0x03F7)"},
{0x10DE, 0x0400, 0xFFFF, 0xFFFF, "G84 [GeForce 8600 GTS](0x0400)"},
{0x10DE, 0x0400, 0x1043, 0x8241, "EN8600GTS(0x1043-0x8241)"},
{0x10DE, 0x0401, 0xFFFF, 0xFFFF, "G84 [GeForce 8600 GT](0x0401)"},
{0x10DE, 0x0402, 0xFFFF, 0xFFFF, "G84 [GeForce 8600 GT](0x0402)"},
{0x10DE, 0x0402, 0x1458, 0x3455, "GV-NX86T512H(0x1458-0x3455)"},
{0x10DE, 0x0402, 0x1462, 0x0910, "NX8600GT-T2D256EZ(0x1462-0x0910)"},
{0x10DE, 0x0403, 0xFFFF, 0xFFFF, "G84 [GeForce 8600 GS](0x0403)"},
{0x10DE, 0x0404, 0xFFFF, 0xFFFF, "G84 [GeForce 8400 GS](0x0404)"},
{0x10DE, 0x0404, 0x1462, 0x1230, "NX8400GS-TD256E(0x1462-0x1230)"},
{0x10DE, 0x0405, 0xFFFF, 0xFFFF, "G84M [GeForce 9500M GS](0x0405)"},
{0x10DE, 0x0406, 0xFFFF, 0xFFFF, "G84 [GeForce 8300 GS](0x0406)"},
{0x10DE, 0x0407, 0xFFFF, 0xFFFF, "G84M [GeForce 8600M GT](0x0407)"},
{0x10DE, 0x0408, 0xFFFF, 0xFFFF, "G84M [GeForce 9650M GS](0x0408)"},
{0x10DE, 0x0409, 0xFFFF, 0xFFFF, "G84M [GeForce 8700M GT](0x0409)"},
{0x10DE, 0x040A, 0xFFFF, 0xFFFF, "G84GL [Quadro FX 370](0x040A)"},
{0x10DE, 0x040B, 0xFFFF, 0xFFFF, "G84GLM [Quadro NVS 320M](0x040B)"},
{0x10DE, 0x040C, 0xFFFF, 0xFFFF, "G84GLM [Quadro FX 570M](0x040C)"},
{0x10DE, 0x040C, 0x17AA, 0x20D9, "ThinkPad T61p(0x17AA-0x20D9)"},
{0x10DE, 0x040D, 0xFFFF, 0xFFFF, "G84GLM [Quadro FX 1600M](0x040D)"},
{0x10DE, 0x040E, 0xFFFF, 0xFFFF, "G84GL [Quadro FX 570](0x040E)"},
{0x10DE, 0x040F, 0xFFFF, 0xFFFF, "G84GL [Quadro FX 1700](0x040F)"},
{0x10DE, 0x0410, 0xFFFF, 0xFFFF, "G92 [GeForce GT 330](0x0410)"},
{0x10DE, 0x0414, 0xFFFF, 0xFFFF, "G92 [GeForce 9800 GT](0x0414)"},
{0x10DE, 0x0418, 0xFFFF, 0xFFFF, "G92 [GeForce GT 330 OEM](0x0418)"},
{0x10DE, 0x0420, 0xFFFF, 0xFFFF, "G86 [GeForce 8400 SE](0x0420)"},
{0x10DE, 0x0421, 0xFFFF, 0xFFFF, "G86 [GeForce 8500 GT](0x0421)"},
{0x10DE, 0x0421, 0x1462, 0x0960, "NX8500GT-TD512EH/M2(0x1462-0x0960)"},
{0x10DE, 0x0422, 0xFFFF, 0xFFFF, "G86 [GeForce 8400 GS](0x0422)"},
{0x10DE, 0x0423, 0xFFFF, 0xFFFF, "G86 [GeForce 8300 GS](0x0423)"},
{0x10DE, 0x0424, 0xFFFF, 0xFFFF, "G86 [GeForce 8400 GS](0x0424)"},
{0x10DE, 0x0425, 0xFFFF, 0xFFFF, "G86M [GeForce 8600M GS](0x0425)"},
{0x10DE, 0x0425, 0x1025, 0x0121, "Aspire 5920G(0x1025-0x0121)"},
{0x10DE, 0x0425, 0x1043, 0x1514, "F3SV(0x1043-0x1514)"},
{0x10DE, 0x0426, 0xFFFF, 0xFFFF, "G86M [GeForce 8400M GT](0x0426)"},
{0x10DE, 0x0427, 0xFFFF, 0xFFFF, "G86M [GeForce 8400M GS](0x0427)"},
{0x10DE, 0x0427, 0x103C, 0x30CC, "Pavilion dv6700(0x103C-0x30CC)"},
{0x10DE, 0x0427, 0x103C, 0x30CF, "Pavilion dv9668eg Laptop(0x103C-0x30CF)"},
{0x10DE, 0x0428, 0xFFFF, 0xFFFF, "G86M [GeForce 8400M G](0x0428)"},
{0x10DE, 0x0429, 0xFFFF, 0xFFFF, "G86M [Quadro NVS 140M](0x0429)"},
{0x10DE, 0x0429, 0x17AA, 0x20D8, "ThinkPad T61(0x17AA-0x20D8)"},
{0x10DE, 0x042A, 0xFFFF, 0xFFFF, "G86M [Quadro NVS 130M](0x042A)"},
{0x10DE, 0x042B, 0xFFFF, 0xFFFF, "G86M [Quadro NVS 135M](0x042B)"},
{0x10DE, 0x042C, 0xFFFF, 0xFFFF, "G86 [GeForce 9400 GT](0x042C)"},
{0x10DE, 0x042D, 0xFFFF, 0xFFFF, "G86GLM [Quadro FX 360M](0x042D)"},
{0x10DE, 0x042E, 0xFFFF, 0xFFFF, "G86M [GeForce 9300M G](0x042E)"},
{0x10DE, 0x042F, 0xFFFF, 0xFFFF, "G86 [Quadro NVS 290](0x042F)"},
{0x10DE, 0x0440, 0xFFFF, 0xFFFF, "MCP65 LPC Bridge(0x0440)"},
{0x10DE, 0x0441, 0xFFFF, 0xFFFF, "MCP65 LPC Bridge(0x0441)"},
{0x10DE, 0x0442, 0xFFFF, 0xFFFF, "MCP65 LPC Bridge(0x0442)"},
{0x10DE, 0x0442, 0x103C, 0x30CF, "Pavilion dv9668eg Laptop(0x103C-0x30CF)"},
{0x10DE, 0x0443, 0xFFFF, 0xFFFF, "MCP65 LPC Bridge(0x0443)"},
{0x10DE, 0x0444, 0xFFFF, 0xFFFF, "MCP65 Memory Controller(0x0444)"},
{0x10DE, 0x0444, 0x103C, 0x30CF, "Pavilion dv9668eg Laptop(0x103C-0x30CF)"},
{0x10DE, 0x0445, 0xFFFF, 0xFFFF, "MCP65 Memory Controller(0x0445)"},
{0x10DE, 0x0446, 0xFFFF, 0xFFFF, "MCP65 SMBus(0x0446)"},
{0x10DE, 0x0446, 0x103C, 0x30CF, "Pavilion dv9668eg Laptop(0x103C-0x30CF)"},
{0x10DE, 0x0447, 0xFFFF, 0xFFFF, "MCP65 SMU(0x0447)"},
{0x10DE, 0x0447, 0x103C, 0x30CF, "Pavilion dv9500/9600/9700 series(0x103C-0x30CF)"},
{0x10DE, 0x0448, 0xFFFF, 0xFFFF, "MCP65 IDE(0x0448)"},
{0x10DE, 0x0448, 0x103C, 0x30CF, "Pavilion dv9668eg Laptop(0x103C-0x30CF)"},
{0x10DE, 0x0449, 0xFFFF, 0xFFFF, "MCP65 PCI bridge(0x0449)"},
{0x10DE, 0x0449, 0x10DE, 0xCB84, "HP Pavilion dv9668eg Laptop(0x10DE-0xCB84)"},
{0x10DE, 0x044A, 0xFFFF, 0xFFFF, "MCP65 High Definition Audio(0x044A)"},
{0x10DE, 0x044A, 0x103C, 0x30CF, "Pavilion dv9668eg Laptop(0x103C-0x30CF)"},
{0x10DE, 0x044B, 0xFFFF, 0xFFFF, "MCP65 High Definition Audio(0x044B)"},
{0x10DE, 0x044C, 0xFFFF, 0xFFFF, "MCP65 AHCI Controller(0x044C)"},
{0x10DE, 0x044D, 0xFFFF, 0xFFFF, "MCP65 AHCI Controller(0x044D)"},
{0x10DE, 0x044E, 0xFFFF, 0xFFFF, "MCP65 AHCI Controller(0x044E)"},
{0x10DE, 0x044F, 0xFFFF, 0xFFFF, "MCP65 AHCI Controller(0x044F)"},
{0x10DE, 0x0450, 0xFFFF, 0xFFFF, "MCP65 Ethernet(0x0450)"},
{0x10DE, 0x0450, 0x103C, 0x30CF, "Pavilion dv9668eg Laptop(0x103C-0x30CF)"},
{0x10DE, 0x0451, 0xFFFF, 0xFFFF, "MCP65 Ethernet(0x0451)"},
{0x10DE, 0x0452, 0xFFFF, 0xFFFF, "MCP65 Ethernet(0x0452)"},
{0x10DE, 0x0453, 0xFFFF, 0xFFFF, "MCP65 Ethernet(0x0453)"},
{0x10DE, 0x0454, 0xFFFF, 0xFFFF, "MCP65 USB 1.1 OHCI Controller(0x0454)"},
{0x10DE, 0x0454, 0x103C, 0x30CF, "Pavilion dv9668eg Laptop(0x103C-0x30CF)"},
{0x10DE, 0x0455, 0xFFFF, 0xFFFF, "MCP65 USB 2.0 EHCI Controller(0x0455)"},
{0x10DE, 0x0455, 0x103C, 0x30CF, "Pavilion dv9668eg Laptop(0x103C-0x30CF)"},
{0x10DE, 0x0456, 0xFFFF, 0xFFFF, "MCP65 USB Controller(0x0456)"},
{0x10DE, 0x0457, 0xFFFF, 0xFFFF, "MCP65 USB Controller(0x0457)"},
{0x10DE, 0x0458, 0xFFFF, 0xFFFF, "MCP65 PCI Express bridge(0x0458)"},
{0x10DE, 0x0458, 0x10DE, 0x0000, "MCP65 PCI Express bridge(0x10DE-0x0000)"},
{0x10DE, 0x0459, 0xFFFF, 0xFFFF, "MCP65 PCI Express bridge(0x0459)"},
{0x10DE, 0x0459, 0x10DE, 0x0000, "MCP65 PCI Express bridge(0x10DE-0x0000)"},
{0x10DE, 0x045A, 0xFFFF, 0xFFFF, "MCP65 PCI Express bridge(0x045A)"},
{0x10DE, 0x045A, 0x10DE, 0x0000, "MCP65 PCI Express bridge(0x10DE-0x0000)"},
{0x10DE, 0x045B, 0xFFFF, 0xFFFF, "MCP65 PCI Express bridge(0x045B)"},
{0x10DE, 0x045B, 0x10DE, 0x0000, "MCP65 PCI Express bridge(0x10DE-0x0000)"},
{0x10DE, 0x045C, 0xFFFF, 0xFFFF, "MCP65 SATA Controller(0x045C)"},
{0x10DE, 0x045D, 0xFFFF, 0xFFFF, "MCP65 SATA Controller(0x045D)"},
{0x10DE, 0x045D, 0x103C, 0x30CF, "Pavilion dv9668eg Laptop(0x103C-0x30CF)"},
{0x10DE, 0x045E, 0xFFFF, 0xFFFF, "MCP65 SATA Controller(0x045E)"},
{0x10DE, 0x045F, 0xFFFF, 0xFFFF, "MCP65 SATA Controller(0x045F)"},
{0x10DE, 0x0531, 0xFFFF, 0xFFFF, "C67 [GeForce 7150M / nForce 630M](0x0531)"},
{0x10DE, 0x0533, 0xFFFF, 0xFFFF, "C67 [GeForce 7000M / nForce 610M](0x0533)"},
{0x10DE, 0x053A, 0xFFFF, 0xFFFF, "C68 [GeForce 7050 PV / nForce 630a](0x053A)"},
{0x10DE, 0x053B, 0xFFFF, 0xFFFF, "C68 [GeForce 7050 PV / nForce 630a](0x053B)"},
{0x10DE, 0x053B, 0x1043, 0x8308, "M2N68-AM Motherboard(0x1043-0x8308)"},
{0x10DE, 0x053E, 0xFFFF, 0xFFFF, "C68 [GeForce 7025 / nForce 630a](0x053E)"},
{0x10DE, 0x0541, 0xFFFF, 0xFFFF, "MCP67 Memory Controller(0x0541)"},
{0x10DE, 0x0542, 0xFFFF, 0xFFFF, "MCP67 SMBus(0x0542)"},
{0x10DE, 0x0542, 0x1043, 0x8308, "M2N68-AM Motherboard(0x1043-0x8308)"},
{0x10DE, 0x0543, 0xFFFF, 0xFFFF, "MCP67 Co-processor(0x0543)"},
{0x10DE, 0x0547, 0xFFFF, 0xFFFF, "MCP67 Memory Controller(0x0547)"},
{0x10DE, 0x0547, 0x1043, 0x8308, "M2N68-AM Motherboard(0x1043-0x8308)"},
{0x10DE, 0x0547, 0x1849, 0x0547, "ALiveNF7G-HDready(0x1849-0x0547)"},
{0x10DE, 0x0548, 0xFFFF, 0xFFFF, "MCP67 ISA Bridge(0x0548)"},
{0x10DE, 0x0548, 0x1043, 0x8308, "M2N68-AM Motherboard(0x1043-0x8308)"},
{0x10DE, 0x054C, 0xFFFF, 0xFFFF, "MCP67 Ethernet(0x054C)"},
{0x10DE, 0x054C, 0x1043, 0x8308, "M2N68-AM Motherboard(0x1043-0x8308)"},
{0x10DE, 0x054C, 0x1849, 0x054C, "ALiveNF7G-HDready, MCP67 Gigabit Ethernet(0x1849-0x054C)"},
{0x10DE, 0x054D, 0xFFFF, 0xFFFF, "MCP67 Ethernet(0x054D)"},
{0x10DE, 0x054E, 0xFFFF, 0xFFFF, "MCP67 Ethernet(0x054E)"},
{0x10DE, 0x054F, 0xFFFF, 0xFFFF, "MCP67 Ethernet(0x054F)"},
{0x10DE, 0x0550, 0xFFFF, 0xFFFF, "MCP67 AHCI Controller(0x0550)"},
{0x10DE, 0x0550, 0x1043, 0x8308, "M2N68-AM Motherboard(0x1043-0x8308)"},
{0x10DE, 0x0554, 0xFFFF, 0xFFFF, "MCP67 AHCI Controller(0x0554)"},
{0x10DE, 0x0554, 0x1043, 0x8308, "M2N68-AM Motherboard(0x1043-0x8308)"},
{0x10DE, 0x0555, 0xFFFF, 0xFFFF, "MCP67 SATA Controller(0x0555)"},
{0x10DE, 0x0555, 0x1043, 0x8308, "M2N68-AM Motherboard(0x1043-0x8308)"},
{0x10DE, 0x055C, 0xFFFF, 0xFFFF, "MCP67 High Definition Audio(0x055C)"},
{0x10DE, 0x055C, 0x1043, 0x8290, "M2N68-AM Motherboard(0x1043-0x8290)"},
{0x10DE, 0x055D, 0xFFFF, 0xFFFF, "MCP67 High Definition Audio(0x055D)"},
{0x10DE, 0x055E, 0xFFFF, 0xFFFF, "MCP67 OHCI USB 1.1 Controller(0x055E)"},
{0x10DE, 0x055E, 0x1043, 0x8308, "M2N68-AM Motherboard(0x1043-0x8308)"},
{0x10DE, 0x055F, 0xFFFF, 0xFFFF, "MCP67 EHCI USB 2.0 Controller(0x055F)"},
{0x10DE, 0x055F, 0x1043, 0x8308, "M2N68-AM Motherboard(0x1043-0x8308)"},
{0x10DE, 0x0560, 0xFFFF, 0xFFFF, "MCP67 IDE Controller(0x0560)"},
{0x10DE, 0x0560, 0xF043, 0x8308, "M2N68-AM Motherboard(0xF043-0x8308)"},
{0x10DE, 0x0561, 0xFFFF, 0xFFFF, "MCP67 PCI Bridge(0x0561)"},
{0x10DE, 0x0562, 0xFFFF, 0xFFFF, "MCP67 PCI Express Bridge(0x0562)"},
{0x10DE, 0x0562, 0x1849, 0x0562, "ALiveNF7G-HDready(0x1849-0x0562)"},
{0x10DE, 0x0563, 0xFFFF, 0xFFFF, "MCP67 PCI Express Bridge(0x0563)"},
{0x10DE, 0x0568, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] Memory Controller(0x0568)"},
{0x10DE, 0x0568, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0568, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0568, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0568, 0x1849, 0x0568, "K10N78FullHD-hSLI R3.0 Memory Controller(0x1849-0x0568)"},
{0x10DE, 0x0569, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] PCI Express Bridge(0x0569)"},
{0x10DE, 0x0569, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0569, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0569, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0569, 0x1849, 0x0569, "K10N78FullHD-hSLI R3.0 PCI Express Bridge(0x1849-0x0569)"},
{0x10DE, 0x056A, 0xFFFF, 0xFFFF, "MCP73 [nForce 630i] USB 2.0 Controller (EHCI)(0x056A)"},
{0x10DE, 0x056A, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x056A, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x056C, 0xFFFF, 0xFFFF, "MCP73 IDE Controller(0x056C)"},
{0x10DE, 0x056C, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x056C, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x056C, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x056D, 0xFFFF, 0xFFFF, "MCP73 PCI Express bridge(0x056D)"},
{0x10DE, 0x056D, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x056D, 0x10DE, 0xCB73, "MCP73 PCI Bridge(0x10DE-0xCB73)"},
{0x10DE, 0x056E, 0xFFFF, 0xFFFF, "MCP73 PCI Express bridge(0x056E)"},
{0x10DE, 0x056E, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x056E, 0x10DE, 0x0000, "MCP73 PCIe x16 port(0x10DE-0x0000)"},
{0x10DE, 0x056F, 0xFFFF, 0xFFFF, "MCP73 PCI Express bridge(0x056F)"},
{0x10DE, 0x056F, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x056F, 0x10DE, 0x0000, "MCP73 PCIe x1 port(0x10DE-0x0000)"},
{0x10DE, 0x05B1, 0xFFFF, 0xFFFF, "NF200 PCIe 2.0 switch(0x05B1)"},
{0x10DE, 0x05B8, 0xFFFF, 0xFFFF, "NF200 PCIe 2.0 switch for GTX 295(0x05B8)"},
{0x10DE, 0x05BE, 0xFFFF, 0xFFFF, "NF200 PCIe 2.0 switch for Quadro Plex S4 / Tesla S870 / Tesla S1070 / Tesla S2050(0x05BE)"},
{0x10DE, 0x05E0, 0xFFFF, 0xFFFF, "GT200b [GeForce GTX 295](0x05E0)"},
{0x10DE, 0x05E1, 0xFFFF, 0xFFFF, "GT200 [GeForce GTX 280](0x05E1)"},
{0x10DE, 0x05E2, 0xFFFF, 0xFFFF, "GT200 [GeForce GTX 260](0x05E2)"},
{0x10DE, 0x05E3, 0xFFFF, 0xFFFF, "GT200b [GeForce GTX 285](0x05E3)"},
{0x10DE, 0x05E3, 0x1682, 0x2490, "GX-285N-ZDF(0x1682-0x2490)"},
{0x10DE, 0x05E6, 0xFFFF, 0xFFFF, "GT200b [GeForce GTX 275](0x05E6)"},
{0x10DE, 0x05E7, 0xFFFF, 0xFFFF, "GT200GL [Tesla C1060 / M1060](0x05E7)"},
{0x10DE, 0x05E7, 0x10DE, 0x0595, "Tesla T10 Processor(0x10DE-0x0595)"},
{0x10DE, 0x05E7, 0x10DE, 0x068F, "Tesla T10 Processor(0x10DE-0x068F)"},
{0x10DE, 0x05E7, 0x10DE, 0x0697, "Tesla M1060(0x10DE-0x0697)"},
{0x10DE, 0x05E7, 0x10DE, 0x0714, "Tesla M1060(0x10DE-0x0714)"},
{0x10DE, 0x05E7, 0x10DE, 0x0743, "Tesla M1060(0x10DE-0x0743)"},
{0x10DE, 0x05EA, 0xFFFF, 0xFFFF, "GT200 [GeForce GTX 260](0x05EA)"},
{0x10DE, 0x05EB, 0xFFFF, 0xFFFF, "GT200 [GeForce GTX 295](0x05EB)"},
{0x10DE, 0x05ED, 0xFFFF, 0xFFFF, "GT200GL [Quadro Plex 2200 D2](0x05ED)"},
{0x10DE, 0x05F1, 0xFFFF, 0xFFFF, "GT200 [GeForce GTX 280](0x05F1)"},
{0x10DE, 0x05F2, 0xFFFF, 0xFFFF, "GT200 [GeForce GTX 260](0x05F2)"},
{0x10DE, 0x05F8, 0xFFFF, 0xFFFF, "GT200GL [Quadro Plex 2200 S4](0x05F8)"},
{0x10DE, 0x05F9, 0xFFFF, 0xFFFF, "GT200GL [Quadro CX](0x05F9)"},
{0x10DE, 0x05FD, 0xFFFF, 0xFFFF, "GT200GL [Quadro FX 5800](0x05FD)"},
{0x10DE, 0x05FE, 0xFFFF, 0xFFFF, "GT200GL [Quadro FX 4800](0x05FE)"},
{0x10DE, 0x05FF, 0xFFFF, 0xFFFF, "GT200GL [Quadro FX 3800](0x05FF)"},
{0x10DE, 0x0600, 0xFFFF, 0xFFFF, "G92 [GeForce 8800 GTS 512](0x0600)"},
{0x10DE, 0x0601, 0xFFFF, 0xFFFF, "G92 [GeForce 9800 GT](0x0601)"},
{0x10DE, 0x0602, 0xFFFF, 0xFFFF, "G92 [GeForce 8800 GT](0x0602)"},
{0x10DE, 0x0603, 0xFFFF, 0xFFFF, "G92 [GeForce GT 230 OEM](0x0603)"},
{0x10DE, 0x0604, 0xFFFF, 0xFFFF, "G92 [GeForce 9800 GX2](0x0604)"},
{0x10DE, 0x0605, 0xFFFF, 0xFFFF, "G92 [GeForce 9800 GT](0x0605)"},
{0x10DE, 0x0606, 0xFFFF, 0xFFFF, "G92 [GeForce 8800 GS](0x0606)"},
{0x10DE, 0x0607, 0xFFFF, 0xFFFF, "G92 [GeForce GTS 240](0x0607)"},
{0x10DE, 0x0608, 0xFFFF, 0xFFFF, "G92M [GeForce 9800M GTX](0x0608)"},
{0x10DE, 0x0609, 0xFFFF, 0xFFFF, "G92M [GeForce 8800M GTS](0x0609)"},
{0x10DE, 0x0609, 0x106B, 0x00A7, "GeForce 8800 GS(0x106B-0x00A7)"},
{0x10DE, 0x060A, 0xFFFF, 0xFFFF, "G92M [GeForce GTX 280M](0x060A)"},
{0x10DE, 0x060B, 0xFFFF, 0xFFFF, "G92M [GeForce 9800M GT](0x060B)"},
{0x10DE, 0x060C, 0xFFFF, 0xFFFF, "G92M [GeForce 8800M GTX](0x060C)"},
{0x10DE, 0x060D, 0xFFFF, 0xFFFF, "G92 [GeForce 8800 GS](0x060D)"},
{0x10DE, 0x060F, 0xFFFF, 0xFFFF, "G92M [GeForce GTX 285M](0x060F)"},
{0x10DE, 0x0610, 0xFFFF, 0xFFFF, "G92 [GeForce 9600 GSO](0x0610)"},
{0x10DE, 0x0610, 0x1682, 0x2385, "GeForce 9600 GSO 768mb(0x1682-0x2385)"},
{0x10DE, 0x0611, 0xFFFF, 0xFFFF, "G92 [GeForce 8800 GT](0x0611)"},
{0x10DE, 0x0611, 0x107D, 0x2AB0, "Winfast PX8800 GT PCI-E(0x107D-0x2AB0)"},
{0x10DE, 0x0611, 0x1462, 0x1170, "NX8800GT series model V117 2xDVI+TV(0x1462-0x1170)"},
{0x10DE, 0x0611, 0x19DA, 0x1040, "ZT-88TES2P-FSP(0x19DA-0x1040)"},
{0x10DE, 0x0612, 0xFFFF, 0xFFFF, "G92 [GeForce 9800 GTX / 9800 GTX+](0x0612)"},
{0x10DE, 0x0613, 0xFFFF, 0xFFFF, "G92 [GeForce 9800 GTX+](0x0613)"},
{0x10DE, 0x0614, 0xFFFF, 0xFFFF, "G92 [GeForce 9800 GT](0x0614)"},
{0x10DE, 0x0614, 0x107D, 0x2AB3, "WinFast PX9800 GT (S-Fanpipe)(0x107D-0x2AB3)"},
{0x10DE, 0x0615, 0xFFFF, 0xFFFF, "G92 [GeForce GTS 250](0x0615)"},
{0x10DE, 0x0615, 0x3842, 0x1150, "GeForce GTS 250 P/N 512-P3-1150-TR(0x3842-0x1150)"},
{0x10DE, 0x0615, 0x3842, 0x1151, "GeForce GTS 250 P/N 512-P3-1151-TR(0x3842-0x1151)"},
{0x10DE, 0x0615, 0x3842, 0x1155, "GeForce GTS 250 P/N 01G-P3-1155-TR(0x3842-0x1155)"},
{0x10DE, 0x0615, 0x3842, 0x1156, "GeForce GTS 250 P/N 01G-P3-1156-TR(0x3842-0x1156)"},
{0x10DE, 0x0617, 0xFFFF, 0xFFFF, "G92M [GeForce 9800M GTX](0x0617)"},
{0x10DE, 0x0618, 0xFFFF, 0xFFFF, "G92M [GeForce GTX 260M](0x0618)"},
{0x10DE, 0x0619, 0xFFFF, 0xFFFF, "G92GL [Quadro FX 4700 X2](0x0619)"},
{0x10DE, 0x061A, 0xFFFF, 0xFFFF, "G92GL [Quadro FX 3700](0x061A)"},
{0x10DE, 0x061B, 0xFFFF, 0xFFFF, "G92GL [Quadro VX 200](0x061B)"},
{0x10DE, 0x061C, 0xFFFF, 0xFFFF, "G92GLM [Quadro FX 3600M](0x061C)"},
{0x10DE, 0x061D, 0xFFFF, 0xFFFF, "G92GLM [Quadro FX 2800M](0x061D)"},
{0x10DE, 0x061E, 0xFFFF, 0xFFFF, "G92GLM [Quadro FX 3700M](0x061E)"},
{0x10DE, 0x061F, 0xFFFF, 0xFFFF, "G92GLM [Quadro FX 3800M](0x061F)"},
{0x10DE, 0x0620, 0xFFFF, 0xFFFF, "G94 [GeForce 9800 GT](0x0620)"},
{0x10DE, 0x0621, 0xFFFF, 0xFFFF, "G94 [GeForce GT 230](0x0621)"},
{0x10DE, 0x0622, 0xFFFF, 0xFFFF, "G94 [GeForce 9600 GT](0x0622)"},
{0x10DE, 0x0622, 0x107D, 0x2AC1, "WinFast PX9600GT 1024MB(0x107D-0x2AC1)"},
{0x10DE, 0x0622, 0x1458, 0x3481, "GV-NX96T512HP(0x1458-0x3481)"},
{0x10DE, 0x0623, 0xFFFF, 0xFFFF, "G94 [GeForce 9600 GS](0x0623)"},
{0x10DE, 0x0624, 0xFFFF, 0xFFFF, "G94 [GeForce 9600 GT Green Edition](0x0624)"},
{0x10DE, 0x0625, 0xFFFF, 0xFFFF, "G94 [GeForce 9600 GSO 512](0x0625)"},
{0x10DE, 0x0626, 0xFFFF, 0xFFFF, "G94 [GeForce GT 130](0x0626)"},
{0x10DE, 0x0627, 0xFFFF, 0xFFFF, "G94 [GeForce GT 140](0x0627)"},
{0x10DE, 0x0628, 0xFFFF, 0xFFFF, "G94M [GeForce 9800M GTS](0x0628)"},
{0x10DE, 0x062A, 0xFFFF, 0xFFFF, "G94M [GeForce 9700M GTS](0x062A)"},
{0x10DE, 0x062B, 0xFFFF, 0xFFFF, "G94M [GeForce 9800M GS](0x062B)"},
{0x10DE, 0x062C, 0xFFFF, 0xFFFF, "G94M [GeForce 9800M GTS](0x062C)"},
{0x10DE, 0x062D, 0xFFFF, 0xFFFF, "G94 [GeForce 9600 GT](0x062D)"},
{0x10DE, 0x062E, 0xFFFF, 0xFFFF, "G94 [GeForce 9600 GT](0x062E)"},
{0x10DE, 0x062E, 0x106B, 0x0605, "GeForce GT 130(0x106B-0x0605)"},
{0x10DE, 0x062F, 0xFFFF, 0xFFFF, "G94 [GeForce 9800 S](0x062F)"},
{0x10DE, 0x0630, 0xFFFF, 0xFFFF, "G94 [GeForce 9600 GT](0x0630)"},
{0x10DE, 0x0631, 0xFFFF, 0xFFFF, "G94M [GeForce GTS 160M](0x0631)"},
{0x10DE, 0x0632, 0xFFFF, 0xFFFF, "G94M [GeForce GTS 150M](0x0632)"},
{0x10DE, 0x0633, 0xFFFF, 0xFFFF, "G94 [GeForce GT 220](0x0633)"},
{0x10DE, 0x0635, 0xFFFF, 0xFFFF, "G94 [GeForce 9600 GSO](0x0635)"},
{0x10DE, 0x0637, 0xFFFF, 0xFFFF, "G94 [GeForce 9600 GT](0x0637)"},
{0x10DE, 0x0638, 0xFFFF, 0xFFFF, "G94GL [Quadro FX 1800](0x0638)"},
{0x10DE, 0x063A, 0xFFFF, 0xFFFF, "G94GLM [Quadro FX 2700M](0x063A)"},
{0x10DE, 0x063F, 0xFFFF, 0xFFFF, "G94 [GeForce 9600 GE](0x063F)"},
{0x10DE, 0x0640, 0xFFFF, 0xFFFF, "G96C [GeForce 9500 GT](0x0640)"},
{0x10DE, 0x0641, 0xFFFF, 0xFFFF, "G96C [GeForce 9400 GT](0x0641)"},
{0x10DE, 0x0641, 0x1682, 0x4009, "PV-T94G-ZAFG(0x1682-0x4009)"},
{0x10DE, 0x0642, 0xFFFF, 0xFFFF, "G96 [D9M-10](0x0642)"},
{0x10DE, 0x0643, 0xFFFF, 0xFFFF, "G96 [GeForce 9500 GT](0x0643)"},
{0x10DE, 0x0644, 0xFFFF, 0xFFFF, "G96 [GeForce 9500 GS](0x0644)"},
{0x10DE, 0x0644, 0x174B, 0x9600, "Geforce 9500GS 512M DDR2 V/D/HDMI(0x174B-0x9600)"},
{0x10DE, 0x0645, 0xFFFF, 0xFFFF, "G96C [GeForce 9500 GS](0x0645)"},
{0x10DE, 0x0646, 0xFFFF, 0xFFFF, "G96C [GeForce GT 120](0x0646)"},
{0x10DE, 0x0647, 0xFFFF, 0xFFFF, "G96CM [GeForce 9600M GT](0x0647)"},
{0x10DE, 0x0648, 0xFFFF, 0xFFFF, "G96CM [GeForce 9600M GS](0x0648)"},
{0x10DE, 0x0649, 0xFFFF, 0xFFFF, "G96CM [GeForce 9600M GT](0x0649)"},
{0x10DE, 0x0649, 0x1043, 0x202D, "GeForce GT 220M(0x1043-0x202D)"},
{0x10DE, 0x064A, 0xFFFF, 0xFFFF, "G96M [GeForce 9700M GT](0x064A)"},
{0x10DE, 0x064B, 0xFFFF, 0xFFFF, "G96M [GeForce 9500M G](0x064B)"},
{0x10DE, 0x064C, 0xFFFF, 0xFFFF, "G96CM [GeForce 9650M GT](0x064C)"},
{0x10DE, 0x064E, 0xFFFF, 0xFFFF, "G96C [GeForce 9600 GSO / 9800 GT](0x064E)"},
{0x10DE, 0x0651, 0xFFFF, 0xFFFF, "G96CM [GeForce G 110M](0x0651)"},
{0x10DE, 0x0652, 0xFFFF, 0xFFFF, "G96CM [GeForce GT 130M](0x0652)"},
{0x10DE, 0x0652, 0x152D, 0x0850, "GeForce GT 240M LE(0x152D-0x0850)"},
{0x10DE, 0x0653, 0xFFFF, 0xFFFF, "G96CM [GeForce GT 120M](0x0653)"},
{0x10DE, 0x0654, 0xFFFF, 0xFFFF, "G96CM [GeForce GT 220M](0x0654)"},
{0x10DE, 0x0654, 0x1043, 0x14A2, "GeForce GT 320M(0x1043-0x14A2)"},
{0x10DE, 0x0654, 0x1043, 0x14D2, "GeForce GT 320M(0x1043-0x14D2)"},
{0x10DE, 0x0655, 0xFFFF, 0xFFFF, "G96 [GeForce GT 120 Mac Edition](0x0655)"},
{0x10DE, 0x0656, 0xFFFF, 0xFFFF, "G96 [GeForce GT 120 Mac Edition](0x0656)"},
{0x10DE, 0x0658, 0xFFFF, 0xFFFF, "G96GL [Quadro FX 380](0x0658)"},
{0x10DE, 0x0659, 0xFFFF, 0xFFFF, "G96CGL [Quadro FX 580](0x0659)"},
{0x10DE, 0x065A, 0xFFFF, 0xFFFF, "G96GLM [Quadro FX 1700M](0x065A)"},
{0x10DE, 0x065B, 0xFFFF, 0xFFFF, "G96C [GeForce 9400 GT](0x065B)"},
{0x10DE, 0x065C, 0xFFFF, 0xFFFF, "G96GLM [Quadro FX 770M](0x065C)"},
{0x10DE, 0x065D, 0xFFFF, 0xFFFF, "G96 [GeForce 9500 GA / 9600 GT / GTS 250](0x065D)"},
{0x10DE, 0x065F, 0xFFFF, 0xFFFF, "G96C [GeForce G210](0x065F)"},
{0x10DE, 0x06C0, 0xFFFF, 0xFFFF, "GF100 [GeForce GTX 480](0x06C0)"},
{0x10DE, 0x06C4, 0xFFFF, 0xFFFF, "GF100 [GeForce GTX 465](0x06C4)"},
{0x10DE, 0x06CA, 0xFFFF, 0xFFFF, "GF100M [GeForce GTX 480M](0x06CA)"},
{0x10DE, 0x06CB, 0xFFFF, 0xFFFF, "GF100 [GeForce GTX 480](0x06CB)"},
{0x10DE, 0x06CD, 0xFFFF, 0xFFFF, "GF100 [GeForce GTX 470](0x06CD)"},
{0x10DE, 0x06D0, 0xFFFF, 0xFFFF, "GF100GL(0x06D0)"},
{0x10DE, 0x06D1, 0xFFFF, 0xFFFF, "GF100GL [Tesla C2050 / C2070](0x06D1)"},
{0x10DE, 0x06D1, 0x10DE, 0x0771, "Tesla C2050(0x10DE-0x0771)"},
{0x10DE, 0x06D1, 0x10DE, 0x0772, "Tesla C2070(0x10DE-0x0772)"},
{0x10DE, 0x06D2, 0xFFFF, 0xFFFF, "GF100GL [Tesla M2070](0x06D2)"},
{0x10DE, 0x06D2, 0x10DE, 0x0774, "Tesla M2070(0x10DE-0x0774)"},
{0x10DE, 0x06D2, 0x10DE, 0x0830, "Tesla M2070(0x10DE-0x0830)"},
{0x10DE, 0x06D2, 0x10DE, 0x0842, "Tesla M2070(0x10DE-0x0842)"},
{0x10DE, 0x06D2, 0x10DE, 0x088F, "Tesla X2070(0x10DE-0x088F)"},
{0x10DE, 0x06D2, 0x10DE, 0x0908, "Tesla M2070(0x10DE-0x0908)"},
{0x10DE, 0x06D8, 0xFFFF, 0xFFFF, "GF100GL [Quadro 6000](0x06D8)"},
{0x10DE, 0x06D9, 0xFFFF, 0xFFFF, "GF100GL [Quadro 5000](0x06D9)"},
{0x10DE, 0x06DA, 0xFFFF, 0xFFFF, "GF100GLM [Quadro 5000M](0x06DA)"},
{0x10DE, 0x06DC, 0xFFFF, 0xFFFF, "GF100GL [Quadro 6000](0x06DC)"},
{0x10DE, 0x06DD, 0xFFFF, 0xFFFF, "GF100GL [Quadro 4000](0x06DD)"},
{0x10DE, 0x06DE, 0xFFFF, 0xFFFF, "GF100GL [Tesla T20 Processor](0x06DE)"},
{0x10DE, 0x06DE, 0x10DE, 0x0773, "Tesla S2050(0x10DE-0x0773)"},
{0x10DE, 0x06DE, 0x10DE, 0x082F, "Tesla M2050(0x10DE-0x082F)"},
{0x10DE, 0x06DE, 0x10DE, 0x0840, "Tesla X2070(0x10DE-0x0840)"},
{0x10DE, 0x06DE, 0x10DE, 0x0842, "Tesla M2050(0x10DE-0x0842)"},
{0x10DE, 0x06DE, 0x10DE, 0x0846, "Tesla M2050(0x10DE-0x0846)"},
{0x10DE, 0x06DE, 0x10DE, 0x0866, "Tesla M2050(0x10DE-0x0866)"},
{0x10DE, 0x06DE, 0x10DE, 0x0907, "Tesla M2050(0x10DE-0x0907)"},
{0x10DE, 0x06DE, 0x10DE, 0x091E, "Tesla M2050(0x10DE-0x091E)"},
{0x10DE, 0x06DF, 0xFFFF, 0xFFFF, "GF100GL [Tesla M2070-Q](0x06DF)"},
{0x10DE, 0x06DF, 0x10DE, 0x084D, "Tesla M2070-Q(0x10DE-0x084D)"},
{0x10DE, 0x06DF, 0x10DE, 0x087F, "Tesla M2070-Q(0x10DE-0x087F)"},
{0x10DE, 0x06E0, 0xFFFF, 0xFFFF, "G98 [GeForce 9300 GE](0x06E0)"},
{0x10DE, 0x06E0, 0x107D, 0x5A96, "Geforce 9300GE(0x107D-0x5A96)"},
{0x10DE, 0x06E1, 0xFFFF, 0xFFFF, "G98 [GeForce 9300 GS](0x06E1)"},
{0x10DE, 0x06E2, 0xFFFF, 0xFFFF, "G98 [GeForce 8400](0x06E2)"},
{0x10DE, 0x06E3, 0xFFFF, 0xFFFF, "G98 [GeForce 8300 GS](0x06E3)"},
{0x10DE, 0x06E4, 0xFFFF, 0xFFFF, "G98 [GeForce 8400 GS Rev. 2](0x06E4)"},
{0x10DE, 0x06E4, 0x1458, 0x3475, "GV-NX84S256HE [GeForce 8400 GS](0x1458-0x3475)"},
{0x10DE, 0x06E5, 0xFFFF, 0xFFFF, "G98M [GeForce 9300M GS](0x06E5)"},
{0x10DE, 0x06E6, 0xFFFF, 0xFFFF, "G98 [GeForce G 100](0x06E6)"},
{0x10DE, 0x06E7, 0xFFFF, 0xFFFF, "G98 [GeForce 9300 SE](0x06E7)"},
{0x10DE, 0x06E8, 0xFFFF, 0xFFFF, "G98M [GeForce 9200M GS](0x06E8)"},
{0x10DE, 0x06E8, 0x103C, 0x360B, "GeForce 9200M GE(0x103C-0x360B)"},
{0x10DE, 0x06E9, 0xFFFF, 0xFFFF, "G98M [GeForce 9300M GS](0x06E9)"},
{0x10DE, 0x06E9, 0x1043, 0x19B2, "U6V laptop(0x1043-0x19B2)"},
{0x10DE, 0x06EA, 0xFFFF, 0xFFFF, "G98M [Quadro NVS 150M](0x06EA)"},
{0x10DE, 0x06EB, 0xFFFF, 0xFFFF, "G98M [Quadro NVS 160M](0x06EB)"},
{0x10DE, 0x06EC, 0xFFFF, 0xFFFF, "G98M [GeForce G 105M](0x06EC)"},
{0x10DE, 0x06ED, 0xFFFF, 0xFFFF, "G98 [GeForce 9600 GT / 9800 GT](0x06ED)"},
{0x10DE, 0x06EE, 0xFFFF, 0xFFFF, "G98 [GeForce 9600 GT / 9800 GT / GT 240](0x06EE)"},
{0x10DE, 0x06EF, 0xFFFF, 0xFFFF, "G98M [GeForce G 103M](0x06EF)"},
{0x10DE, 0x06F1, 0xFFFF, 0xFFFF, "G98M [GeForce G 105M](0x06F1)"},
{0x10DE, 0x06F8, 0xFFFF, 0xFFFF, "G98 [Quadro NVS 420](0x06F8)"},
{0x10DE, 0x06F9, 0xFFFF, 0xFFFF, "G98GL [Quadro FX 370 LP](0x06F9)"},
{0x10DE, 0x06FA, 0xFFFF, 0xFFFF, "G98 [Quadro NVS 450](0x06FA)"},
{0x10DE, 0x06FB, 0xFFFF, 0xFFFF, "G98GLM [Quadro FX 370M](0x06FB)"},
{0x10DE, 0x06FD, 0xFFFF, 0xFFFF, "G98 [Quadro NVS 295](0x06FD)"},
{0x10DE, 0x06FF, 0xFFFF, 0xFFFF, "G98 [HICx16 + Graphics](0x06FF)"},
{0x10DE, 0x06FF, 0x10DE, 0x0711, "HICx8 + Graphics(0x10DE-0x0711)"},
{0x10DE, 0x0751, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] Memory Controller(0x0751)"},
{0x10DE, 0x0751, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0751, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0751, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0751, 0x1849, 0x0751, "K10N78FullHD-hSLI R3.0 Memory Controller(0x1849-0x0751)"},
{0x10DE, 0x0752, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] SMBus(0x0752)"},
{0x10DE, 0x0752, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0752, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0752, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0752, 0x1849, 0x0752, "K10N78FullHD-hSLI R3.0 SMBus(0x1849-0x0752)"},
{0x10DE, 0x0753, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] Co-Processor(0x0753)"},
{0x10DE, 0x0753, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0753, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0753, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0753, 0x1849, 0x0753, "K10N78FullHD-hSLI R3.0 Co-Processor(0x1849-0x0753)"},
{0x10DE, 0x0754, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] Memory Controller(0x0754)"},
{0x10DE, 0x0754, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0754, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0754, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0754, 0x1849, 0x0754, "K10N78FullHD-hSLI R3.0 Memory Controller(0x1849-0x0754)"},
{0x10DE, 0x0759, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] IDE(0x0759)"},
{0x10DE, 0x0759, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0759, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0759, 0x1849, 0x0759, "K10N78FullHD-hSLI R3.0 IDE(0x1849-0x0759)"},
{0x10DE, 0x075A, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] PCI Bridge(0x075A)"},
{0x10DE, 0x075A, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x075A, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x075A, 0x1849, 0x075A, "K10N78FullHD-hSLI R3.0 PCI Bridge(0x1849-0x075A)"},
{0x10DE, 0x075B, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] PCI Express Bridge(0x075B)"},
{0x10DE, 0x075B, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x075B, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x075B, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x075B, 0x1849, 0x075B, "K10N78FullHD-hSLI R3.0 PCI Express Bridge(0x1849-0x075B)"},
{0x10DE, 0x075C, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] LPC Bridge(0x075C)"},
{0x10DE, 0x075C, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x075C, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x075C, 0x1849, 0x075C, "K10N78FullHD-hSLI R3.0 LPC Bridge(0x1849-0x075C)"},
{0x10DE, 0x075D, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] LPC Bridge(0x075D)"},
{0x10DE, 0x075D, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0760, 0xFFFF, 0xFFFF, "MCP77 Ethernet(0x0760)"},
{0x10DE, 0x0760, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0760, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0760, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0760, 0x1849, 0x0760, "K10N78FullHD-hSLI R3.0 Ethernet(0x1849-0x0760)"},
{0x10DE, 0x0761, 0xFFFF, 0xFFFF, "MCP77 Ethernet(0x0761)"},
{0x10DE, 0x0762, 0xFFFF, 0xFFFF, "MCP77 Ethernet(0x0762)"},
{0x10DE, 0x0763, 0xFFFF, 0xFFFF, "MCP77 Ethernet(0x0763)"},
{0x10DE, 0x0774, 0xFFFF, 0xFFFF, "MCP72XE/MCP72P/MCP78U/MCP78S High Definition Audio(0x0774)"},
{0x10DE, 0x0774, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0774, 0x1043, 0x82FE, "M3N72-D(0x1043-0x82FE)"},
{0x10DE, 0x0774, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0774, 0x1849, 0x3662, "K10N78FullHD-hSLI R3.0 High Definition Audio(0x1849-0x3662)"},
{0x10DE, 0x0778, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] PCI Express Bridge(0x0778)"},
{0x10DE, 0x0778, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0778, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0778, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0778, 0x1849, 0x0778, "K10N78FullHD-hSLI R3.0 PCI Express Bridge(0x1849-0x0778)"},
{0x10DE, 0x077A, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] PCI Bridge(0x077A)"},
{0x10DE, 0x077A, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x077A, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x077A, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x077A, 0x1849, 0x077A, "K10N78FullHD-hSLI R3.0 PCI Bridge(0x1849-0x077A)"},
{0x10DE, 0x077B, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] OHCI USB 1.1 Controller(0x077B)"},
{0x10DE, 0x077B, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x077B, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x077B, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x077B, 0x1849, 0x077B, "K10N78FullHD-hSLI R3.0 OHCI USB 1.1 Controller(0x1849-0x077B)"},
{0x10DE, 0x077C, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] EHCI USB 2.0 Controller(0x077C)"},
{0x10DE, 0x077C, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x077C, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x077C, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x077C, 0x1849, 0x077C, "K10N78FullHD-hSLI R3.0 EHCI USB 2.0 Controller(0x1849-0x077C)"},
{0x10DE, 0x077D, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] OHCI USB 1.1 Controller(0x077D)"},
{0x10DE, 0x077D, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x077D, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x077D, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x077D, 0x1849, 0x077D, "K10N78FullHD-hSLI R3.0 OHCI USB 1.1 Controller(0x1849-0x077D)"},
{0x10DE, 0x077E, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] EHCI USB 2.0 Controller(0x077E)"},
{0x10DE, 0x077E, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x077E, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x077E, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x077E, 0x1849, 0x077E, "K10N78FullHD-hSLI R3.0 EHCI USB 2.0 Controller(0x1849-0x077E)"},
{0x10DE, 0x07C0, 0xFFFF, 0xFFFF, "MCP73 Host Bridge(0x07C0)"},
{0x10DE, 0x07C0, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07C1, 0xFFFF, 0xFFFF, "MCP73 Host Bridge(0x07C1)"},
{0x10DE, 0x07C1, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07C2, 0xFFFF, 0xFFFF, "MCP73 Host Bridge(0x07C2)"},
{0x10DE, 0x07C3, 0xFFFF, 0xFFFF, "MCP73 Host Bridge(0x07C3)"},
{0x10DE, 0x07C3, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07C5, 0xFFFF, 0xFFFF, "MCP73 Host Bridge(0x07C5)"},
{0x10DE, 0x07C8, 0xFFFF, 0xFFFF, "MCP73 Memory Controller(0x07C8)"},
{0x10DE, 0x07C8, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07C8, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07C8, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07CB, 0xFFFF, 0xFFFF, "nForce 610i/630i memory controller(0x07CB)"},
{0x10DE, 0x07CB, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07CB, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07CB, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07CD, 0xFFFF, 0xFFFF, "nForce 610i/630i memory controller(0x07CD)"},
{0x10DE, 0x07CD, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07CD, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07CD, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07CE, 0xFFFF, 0xFFFF, "nForce 610i/630i memory controller(0x07CE)"},
{0x10DE, 0x07CE, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07CE, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07CE, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07CF, 0xFFFF, 0xFFFF, "nForce 610i/630i memory controller(0x07CF)"},
{0x10DE, 0x07CF, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07CF, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07CF, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07D0, 0xFFFF, 0xFFFF, "nForce 610i/630i memory controller(0x07D0)"},
{0x10DE, 0x07D0, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07D0, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07D0, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07D1, 0xFFFF, 0xFFFF, "nForce 610i/630i memory controller(0x07D1)"},
{0x10DE, 0x07D1, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07D1, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07D1, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07D2, 0xFFFF, 0xFFFF, "nForce 610i/630i memory controller(0x07D2)"},
{0x10DE, 0x07D2, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07D2, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07D2, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07D3, 0xFFFF, 0xFFFF, "nForce 610i/630i memory controller(0x07D3)"},
{0x10DE, 0x07D3, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07D3, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07D3, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07D6, 0xFFFF, 0xFFFF, "nForce 610i/630i memory controller(0x07D6)"},
{0x10DE, 0x07D6, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07D6, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07D6, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07D7, 0xFFFF, 0xFFFF, "MCP73 LPC Bridge(0x07D7)"},
{0x10DE, 0x07D7, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07D7, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07D7, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07D8, 0xFFFF, 0xFFFF, "MCP73 SMBus(0x07D8)"},
{0x10DE, 0x07D8, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07D8, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07D8, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07D9, 0xFFFF, 0xFFFF, "MCP73 Memory Controller(0x07D9)"},
{0x10DE, 0x07D9, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07D9, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07D9, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07DA, 0xFFFF, 0xFFFF, "MCP73 Co-processor(0x07DA)"},
{0x10DE, 0x07DA, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07DC, 0xFFFF, 0xFFFF, "MCP73 Ethernet(0x07DC)"},
{0x10DE, 0x07DC, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07DD, 0xFFFF, 0xFFFF, "MCP73 Ethernet(0x07DD)"},
{0x10DE, 0x07DE, 0xFFFF, 0xFFFF, "MCP73 Ethernet(0x07DE)"},
{0x10DE, 0x07DF, 0xFFFF, 0xFFFF, "MCP73 Ethernet(0x07DF)"},
{0x10DE, 0x07E0, 0xFFFF, 0xFFFF, "C73 [GeForce 7150 / nForce 630i](0x07E0)"},
{0x10DE, 0x07E0, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x07E1, 0xFFFF, 0xFFFF, "C73 [GeForce 7100 / nForce 630i](0x07E1)"},
{0x10DE, 0x07E1, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07E2, 0xFFFF, 0xFFFF, "C73 [GeForce 7050 / nForce 630i](0x07E2)"},
{0x10DE, 0x07E3, 0xFFFF, 0xFFFF, "C73 [GeForce 7050 / nForce 610i](0x07E3)"},
{0x10DE, 0x07E3, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07E5, 0xFFFF, 0xFFFF, "C73 [GeForce 7100 / nForce 620i](0x07E5)"},
{0x10DE, 0x07F0, 0xFFFF, 0xFFFF, "MCP73 SATA Controller (IDE mode)(0x07F0)"},
{0x10DE, 0x07F0, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07F4, 0xFFFF, 0xFFFF, "GeForce 7100/nForce 630i SATA(0x07F4)"},
{0x10DE, 0x07F4, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07F4, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07F8, 0xFFFF, 0xFFFF, "MCP73 SATA RAID Controller(0x07F8)"},
{0x10DE, 0x07F8, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07FC, 0xFFFF, 0xFFFF, "MCP73 High Definition Audio(0x07FC)"},
{0x10DE, 0x07FC, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07FC, 0x10DE, 0x07FC, "MCP73 High Definition Audio(0x10DE-0x07FC)"},
{0x10DE, 0x07FC, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07FE, 0xFFFF, 0xFFFF, "MCP73 OHCI USB 1.1 Controller(0x07FE)"},
{0x10DE, 0x07FE, 0x1019, 0x297A, "MCP73PVT-SM(0x1019-0x297A)"},
{0x10DE, 0x07FE, 0x147B, 0x1C3E, "I-N73V motherboard(0x147B-0x1C3E)"},
{0x10DE, 0x07FE, 0x1AFA, 0x7150, "JW-IN7150-HD(0x1AFA-0x7150)"},
{0x10DE, 0x0840, 0xFFFF, 0xFFFF, "C77 [GeForce 8200M](0x0840)"},
{0x10DE, 0x0844, 0xFFFF, 0xFFFF, "C77 [GeForce 9100M G](0x0844)"},
{0x10DE, 0x0845, 0xFFFF, 0xFFFF, "C77 [GeForce 8200M G](0x0845)"},
{0x10DE, 0x0846, 0xFFFF, 0xFFFF, "C77 [GeForce 9200](0x0846)"},
{0x10DE, 0x0847, 0xFFFF, 0xFFFF, "C78 [GeForce 9100](0x0847)"},
{0x10DE, 0x0847, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0848, 0xFFFF, 0xFFFF, "C77 [GeForce 8300](0x0848)"},
{0x10DE, 0x0849, 0xFFFF, 0xFFFF, "C77 [GeForce 8200](0x0849)"},
{0x10DE, 0x0849, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0849, 0x1849, 0x0849, "K10N78FullHD-hSLI R3.0 GeForce 8200(0x1849-0x0849)"},
{0x10DE, 0x084A, 0xFFFF, 0xFFFF, "C77 [nForce 730a](0x084A)"},
{0x10DE, 0x084B, 0xFFFF, 0xFFFF, "C77 [GeForce 8200](0x084B)"},
{0x10DE, 0x084C, 0xFFFF, 0xFFFF, "C77 [nForce 780a/980a SLI](0x084C)"},
{0x10DE, 0x084D, 0xFFFF, 0xFFFF, "C77 [nForce 750a SLI](0x084D)"},
{0x10DE, 0x084D, 0x1043, 0x82E8, "M3N72-D mGPU(0x1043-0x82E8)"},
{0x10DE, 0x084F, 0xFFFF, 0xFFFF, "C77 [GeForce 8100 / nForce 720a](0x084F)"},
{0x10DE, 0x0860, 0xFFFF, 0xFFFF, "C79 [GeForce 9300](0x0860)"},
{0x10DE, 0x0861, 0xFFFF, 0xFFFF, "C79 [GeForce 9400](0x0861)"},
{0x10DE, 0x0862, 0xFFFF, 0xFFFF, "C79 [GeForce 9400M G](0x0862)"},
{0x10DE, 0x0863, 0xFFFF, 0xFFFF, "C79 [GeForce 9400M](0x0863)"},
{0x10DE, 0x0863, 0x106B, 0x00AA, "MacBook5,1(0x106B-0x00AA)"},
{0x10DE, 0x0864, 0xFFFF, 0xFFFF, "C79 [GeForce 9300](0x0864)"},
{0x10DE, 0x0865, 0xFFFF, 0xFFFF, "C79 [GeForce 9300 / ION](0x0865)"},
{0x10DE, 0x0866, 0xFFFF, 0xFFFF, "C79 [GeForce 9400M G](0x0866)"},
{0x10DE, 0x0866, 0x106B, 0x00B1, "GeForce 9400M(0x106B-0x00B1)"},
{0x10DE, 0x0867, 0xFFFF, 0xFFFF, "C79 [GeForce 9400](0x0867)"},
{0x10DE, 0x0867, 0x106B, 0x00AD, "iMac 9,1(0x106B-0x00AD)"},
{0x10DE, 0x0868, 0xFFFF, 0xFFFF, "C79 [nForce 760i SLI](0x0868)"},
{0x10DE, 0x0869, 0xFFFF, 0xFFFF, "MCP7A [GeForce 9400](0x0869)"},
{0x10DE, 0x086A, 0xFFFF, 0xFFFF, "C79 [GeForce 9400](0x086A)"},
{0x10DE, 0x086C, 0xFFFF, 0xFFFF, "C79 [GeForce 9300 / nForce 730i](0x086C)"},
{0x10DE, 0x086D, 0xFFFF, 0xFFFF, "C79 [GeForce 9200](0x086D)"},
{0x10DE, 0x086E, 0xFFFF, 0xFFFF, "C79 [GeForce 9100M G](0x086E)"},
{0x10DE, 0x086F, 0xFFFF, 0xFFFF, "MCP79 [GeForce 8200M G](0x086F)"},
{0x10DE, 0x086F, 0x1043, 0x16B2, "F5GL Notebook(0x1043-0x16B2)"},
{0x10DE, 0x0870, 0xFFFF, 0xFFFF, "C79 [GeForce 9400M](0x0870)"},
{0x10DE, 0x0871, 0xFFFF, 0xFFFF, "C79 [GeForce 9200](0x0871)"},
{0x10DE, 0x0872, 0xFFFF, 0xFFFF, "C79 [GeForce G102M](0x0872)"},
{0x10DE, 0x0872, 0x1043, 0x19B4, "GeForce G102M(0x1043-0x19B4)"},
{0x10DE, 0x0872, 0x1043, 0x1AA2, "GeForce G102M(0x1043-0x1AA2)"},
{0x10DE, 0x0872, 0x1043, 0x1C02, "GeForce G102M(0x1043-0x1C02)"},
{0x10DE, 0x0872, 0x1043, 0x1C42, "GeForce G205M(0x1043-0x1C42)"},
{0x10DE, 0x0873, 0xFFFF, 0xFFFF, "C79 [GeForce G102M](0x0873)"},
{0x10DE, 0x0873, 0x1043, 0x19B4, "GeForce G102M(0x1043-0x19B4)"},
{0x10DE, 0x0873, 0x1043, 0x1C12, "GeForce G102M(0x1043-0x1C12)"},
{0x10DE, 0x0873, 0x1043, 0x1C52, "GeForce G205M(0x1043-0x1C52)"},
{0x10DE, 0x0874, 0xFFFF, 0xFFFF, "C79 [ION](0x0874)"},
{0x10DE, 0x0876, 0xFFFF, 0xFFFF, "C79 [GeForce 9400M / ION](0x0876)"},
{0x10DE, 0x087A, 0xFFFF, 0xFFFF, "C79 [GeForce 9400](0x087A)"},
{0x10DE, 0x087D, 0xFFFF, 0xFFFF, "C79 [ION](0x087D)"},
{0x10DE, 0x087D, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x087E, 0xFFFF, 0xFFFF, "C79 [ION LE](0x087E)"},
{0x10DE, 0x087F, 0xFFFF, 0xFFFF, "C79 [ION LE](0x087F)"},
{0x10DE, 0x08A0, 0xFFFF, 0xFFFF, "MCP89 [GeForce 320M](0x08A0)"},
{0x10DE, 0x08A2, 0xFFFF, 0xFFFF, "MCP89 [GeForce 320M](0x08A2)"},
{0x10DE, 0x08A3, 0xFFFF, 0xFFFF, "MCP89 [GeForce 320M](0x08A3)"},
{0x10DE, 0x08A4, 0xFFFF, 0xFFFF, "MCP89 [GeForce 320M](0x08A4)"},
{0x10DE, 0x08A5, 0xFFFF, 0xFFFF, "MCP89 [GeForce 320M](0x08A5)"},
{0x10DE, 0x0A20, 0xFFFF, 0xFFFF, "GT216 [GeForce GT 220](0x0A20)"},
{0x10DE, 0x0A20, 0x1043, 0x8311, "ENGT220/DI/1GD3(LP)/V2(0x1043-0x8311)"},
{0x10DE, 0x0A21, 0xFFFF, 0xFFFF, "GT216M [GeForce GT 330M](0x0A21)"},
{0x10DE, 0x0A22, 0xFFFF, 0xFFFF, "GT216 [GeForce 315](0x0A22)"},
{0x10DE, 0x0A23, 0xFFFF, 0xFFFF, "GT216 [GeForce 210](0x0A23)"},
{0x10DE, 0x0A24, 0xFFFF, 0xFFFF, "GT216 [GeForce 405](0x0A24)"},
{0x10DE, 0x0A26, 0xFFFF, 0xFFFF, "GT216 [GeForce 405](0x0A26)"},
{0x10DE, 0x0A27, 0xFFFF, 0xFFFF, "GT216 [GeForce 405](0x0A27)"},
{0x10DE, 0x0A28, 0xFFFF, 0xFFFF, "GT216M [GeForce GT 230M](0x0A28)"},
{0x10DE, 0x0A29, 0xFFFF, 0xFFFF, "GT216M [GeForce GT 330M](0x0A29)"},
{0x10DE, 0x0A2A, 0xFFFF, 0xFFFF, "GT216M [GeForce GT 230M](0x0A2A)"},
{0x10DE, 0x0A2B, 0xFFFF, 0xFFFF, "GT216M [GeForce GT 330M](0x0A2B)"},
{0x10DE, 0x0A2C, 0xFFFF, 0xFFFF, "GT216M [NVS 5100M](0x0A2C)"},
{0x10DE, 0x0A2D, 0xFFFF, 0xFFFF, "GT216M [GeForce GT 320M](0x0A2D)"},
{0x10DE, 0x0A30, 0xFFFF, 0xFFFF, "GT216 [GeForce 505](0x0A30)"},
{0x10DE, 0x0A32, 0xFFFF, 0xFFFF, "GT216 [GeForce GT 415](0x0A32)"},
{0x10DE, 0x0A34, 0xFFFF, 0xFFFF, "GT216M [GeForce GT 240M](0x0A34)"},
{0x10DE, 0x0A35, 0xFFFF, 0xFFFF, "GT216M [GeForce GT 325M](0x0A35)"},
{0x10DE, 0x0A38, 0xFFFF, 0xFFFF, "GT216GL [Quadro 400](0x0A38)"},
{0x10DE, 0x0A3C, 0xFFFF, 0xFFFF, "GT216GLM [Quadro FX 880M](0x0A3C)"},
{0x10DE, 0x0A60, 0xFFFF, 0xFFFF, "GT218 [GeForce G210](0x0A60)"},
{0x10DE, 0x0A62, 0xFFFF, 0xFFFF, "GT218 [GeForce 205](0x0A62)"},
{0x10DE, 0x0A63, 0xFFFF, 0xFFFF, "GT218 [GeForce 310](0x0A63)"},
{0x10DE, 0x0A64, 0xFFFF, 0xFFFF, "GT218 [ION](0x0A64)"},
{0x10DE, 0x0A65, 0xFFFF, 0xFFFF, "GT218 [GeForce 210](0x0A65)"},
{0x10DE, 0x0A65, 0x1043, 0x8334, "EN210 SILENT(0x1043-0x8334)"},
{0x10DE, 0x0A65, 0x1458, 0x36A9, "GV-N210D3-1GI (rev. 6.0/6.1)(0x1458-0x36A9)"},
{0x10DE, 0x0A65, 0x1462, 0x8094, "N210 [Geforce 210] PCIe graphics adapter(0x1462-0x8094)"},
{0x10DE, 0x0A65, 0x19DA, 0x7222, "GeForce 210 1GB [Synergy Edition](0x19DA-0x7222)"},
{0x10DE, 0x0A66, 0xFFFF, 0xFFFF, "GT218 [GeForce 310](0x0A66)"},
{0x10DE, 0x0A67, 0xFFFF, 0xFFFF, "GT218 [GeForce 315](0x0A67)"},
{0x10DE, 0x0A68, 0xFFFF, 0xFFFF, "GT218M [GeForce G 105M](0x0A68)"},
{0x10DE, 0x0A69, 0xFFFF, 0xFFFF, "GT218M [GeForce G 105M](0x0A69)"},
{0x10DE, 0x0A6A, 0xFFFF, 0xFFFF, "GT218M [NVS 2100M](0x0A6A)"},
{0x10DE, 0x0A6C, 0xFFFF, 0xFFFF, "GT218M [NVS 3100M](0x0A6C)"},
{0x10DE, 0x0A6C, 0x1028, 0x040B, "Latitude E6510(0x1028-0x040B)"},
{0x10DE, 0x0A6C, 0x17AA, 0x2142, "ThinkPad T410(0x17AA-0x2142)"},
{0x10DE, 0x0A6E, 0xFFFF, 0xFFFF, "GT218M [GeForce 305M](0x0A6E)"},
{0x10DE, 0x0A6F, 0xFFFF, 0xFFFF, "GT218M [ION](0x0A6F)"},
{0x10DE, 0x0A70, 0xFFFF, 0xFFFF, "GT218M [GeForce 310M](0x0A70)"},
{0x10DE, 0x0A71, 0xFFFF, 0xFFFF, "GT218M [GeForce 305M](0x0A71)"},
{0x10DE, 0x0A72, 0xFFFF, 0xFFFF, "GT218M [GeForce 310M](0x0A72)"},
{0x10DE, 0x0A73, 0xFFFF, 0xFFFF, "GT218M [GeForce 305M](0x0A73)"},
{0x10DE, 0x0A74, 0xFFFF, 0xFFFF, "GT218M [GeForce G210M](0x0A74)"},
{0x10DE, 0x0A74, 0x1B0A, 0x903A, "GeForce G210(0x1B0A-0x903A)"},
{0x10DE, 0x0A75, 0xFFFF, 0xFFFF, "GT218M [GeForce 310M](0x0A75)"},
{0x10DE, 0x0A76, 0xFFFF, 0xFFFF, "GT218M [ION 2](0x0A76)"},
{0x10DE, 0x0A78, 0xFFFF, 0xFFFF, "GT218GL [Quadro FX 380 LP](0x0A78)"},
{0x10DE, 0x0A7A, 0xFFFF, 0xFFFF, "GT218M [GeForce 315M](0x0A7A)"},
{0x10DE, 0x0A7A, 0x104D, 0x907E, "GeForce 315M(0x104D-0x907E)"},
{0x10DE, 0x0A7A, 0x1179, 0xFC50, "GeForce 315M(0x1179-0xFC50)"},
{0x10DE, 0x0A7A, 0x1179, 0xFC61, "GeForce 315M(0x1179-0xFC61)"},
{0x10DE, 0x0A7A, 0x1179, 0xFC71, "GeForce 315M(0x1179-0xFC71)"},
{0x10DE, 0x0A7A, 0x1179, 0xFC90, "GeForce 315M(0x1179-0xFC90)"},
{0x10DE, 0x0A7A, 0x1179, 0xFCC0, "GeForce 315M(0x1179-0xFCC0)"},
{0x10DE, 0x0A7A, 0x1179, 0xFCD0, "GeForce 315M(0x1179-0xFCD0)"},
{0x10DE, 0x0A7A, 0x1179, 0xFCE2, "GeForce 315M(0x1179-0xFCE2)"},
{0x10DE, 0x0A7A, 0x1179, 0xFCF2, "GeForce 315M(0x1179-0xFCF2)"},
{0x10DE, 0x0A7A, 0x1179, 0xFD16, "GeForce 315M(0x1179-0xFD16)"},
{0x10DE, 0x0A7A, 0x1179, 0xFD40, "GeForce 315M(0x1179-0xFD40)"},
{0x10DE, 0x0A7A, 0x1179, 0xFD50, "GeForce 315M(0x1179-0xFD50)"},
{0x10DE, 0x0A7A, 0x1179, 0xFD52, "GeForce 315M(0x1179-0xFD52)"},
{0x10DE, 0x0A7A, 0x1179, 0xFD61, "GeForce 315M(0x1179-0xFD61)"},
{0x10DE, 0x0A7A, 0x1179, 0xFD71, "GeForce 315M(0x1179-0xFD71)"},
{0x10DE, 0x0A7A, 0x1179, 0xFD92, "GeForce 315M(0x1179-0xFD92)"},
{0x10DE, 0x0A7A, 0x1179, 0xFD96, "GeForce 315M(0x1179-0xFD96)"},
{0x10DE, 0x0A7A, 0x1179, 0xFDD0, "GeForce 315M(0x1179-0xFDD0)"},
{0x10DE, 0x0A7A, 0x1179, 0xFDD2, "GeForce 315M(0x1179-0xFDD2)"},
{0x10DE, 0x0A7A, 0x1179, 0xFDFE, "GeForce 315M(0x1179-0xFDFE)"},
{0x10DE, 0x0A7A, 0x144D, 0xC0A2, "GeForce 315M(0x144D-0xC0A2)"},
{0x10DE, 0x0A7A, 0x144D, 0xC0B2, "GeForce 315M(0x144D-0xC0B2)"},
{0x10DE, 0x0A7A, 0x144D, 0xC581, "GeForce 315M(0x144D-0xC581)"},
{0x10DE, 0x0A7A, 0x144D, 0xC587, "GeForce 315M(0x144D-0xC587)"},
{0x10DE, 0x0A7A, 0x144D, 0xC588, "GeForce 315M(0x144D-0xC588)"},
{0x10DE, 0x0A7A, 0x144D, 0xC597, "GeForce 315M(0x144D-0xC597)"},
{0x10DE, 0x0A7A, 0x144D, 0xC606, "GeForce 315M(0x144D-0xC606)"},
{0x10DE, 0x0A7A, 0x1462, 0xAA51, "GeForce 405(0x1462-0xAA51)"},
{0x10DE, 0x0A7A, 0x1462, 0xAA58, "GeForce 405(0x1462-0xAA58)"},
{0x10DE, 0x0A7A, 0x1462, 0xAC71, "GeForce 405(0x1462-0xAC71)"},
{0x10DE, 0x0A7A, 0x1462, 0xAC81, "GeForce 315M(0x1462-0xAC81)"},
{0x10DE, 0x0A7A, 0x1462, 0xAC82, "GeForce 405(0x1462-0xAC82)"},
{0x10DE, 0x0A7A, 0x1462, 0xAE33, "GeForce 405(0x1462-0xAE33)"},
{0x10DE, 0x0A7A, 0x1642, 0x3980, "GeForce 405(0x1642-0x3980)"},
{0x10DE, 0x0A7A, 0x17AA, 0x3950, "GeForce 405M(0x17AA-0x3950)"},
{0x10DE, 0x0A7A, 0x17AA, 0x397D, "GeForce 405M(0x17AA-0x397D)"},
{0x10DE, 0x0A7A, 0x1B0A, 0x2091, "GeForce 315M(0x1B0A-0x2091)"},
{0x10DE, 0x0A7A, 0x1B0A, 0x90B4, "GeForce 405(0x1B0A-0x90B4)"},
{0x10DE, 0x0A7A, 0x1BFD, 0x0003, "GeForce 405(0x1BFD-0x0003)"},
{0x10DE, 0x0A7A, 0x1BFD, 0x8006, "GeForce 405(0x1BFD-0x8006)"},
{0x10DE, 0x0A7A, 0x1BFD, 0x8007, "GeForce 315M(0x1BFD-0x8007)"},
{0x10DE, 0x0A7B, 0xFFFF, 0xFFFF, "GT218 [GeForce 505](0x0A7B)"},
{0x10DE, 0x0A7C, 0xFFFF, 0xFFFF, "GT218GLM [Quadro FX 380M](0x0A7C)"},
{0x10DE, 0x0A80, 0xFFFF, 0xFFFF, "MCP79 Host Bridge(0x0A80)"},
{0x10DE, 0x0A81, 0xFFFF, 0xFFFF, "MCP79 Host Bridge(0x0A81)"},
{0x10DE, 0x0A82, 0xFFFF, 0xFFFF, "MCP79 Host Bridge(0x0A82)"},
{0x10DE, 0x0A83, 0xFFFF, 0xFFFF, "MCP79 Host Bridge(0x0A83)"},
{0x10DE, 0x0A84, 0xFFFF, 0xFFFF, "MCP79 Host Bridge(0x0A84)"},
{0x10DE, 0x0A85, 0xFFFF, 0xFFFF, "MCP79 Host Bridge(0x0A85)"},
{0x10DE, 0x0A86, 0xFFFF, 0xFFFF, "MCP79 Host Bridge(0x0A86)"},
{0x10DE, 0x0A87, 0xFFFF, 0xFFFF, "MCP79 Host Bridge(0x0A87)"},
{0x10DE, 0x0A88, 0xFFFF, 0xFFFF, "MCP79 Memory Controller(0x0A88)"},
{0x10DE, 0x0A89, 0xFFFF, 0xFFFF, "MCP79 Memory Controller(0x0A89)"},
{0x10DE, 0x0A98, 0xFFFF, 0xFFFF, "MCP79 Memory Controller(0x0A98)"},
{0x10DE, 0x0A98, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0A98, 0x10DE, 0xCB79, "iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AA0, 0xFFFF, 0xFFFF, "MCP79 PCI Express Bridge(0x0AA0)"},
{0x10DE, 0x0AA0, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AA0, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AA2, 0xFFFF, 0xFFFF, "MCP79 SMBus(0x0AA2)"},
{0x10DE, 0x0AA2, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AA2, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AA2, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x0AA3, 0xFFFF, 0xFFFF, "MCP79 Co-processor(0x0AA3)"},
{0x10DE, 0x0AA3, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AA3, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AA3, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x0AA4, 0xFFFF, 0xFFFF, "MCP79 Memory Controller(0x0AA4)"},
{0x10DE, 0x0AA4, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AA4, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x0AA5, 0xFFFF, 0xFFFF, "MCP79 OHCI USB 1.1 Controller(0x0AA5)"},
{0x10DE, 0x0AA5, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AA5, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AA5, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x0AA6, 0xFFFF, 0xFFFF, "MCP79 EHCI USB 2.0 Controller(0x0AA6)"},
{0x10DE, 0x0AA6, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AA6, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AA6, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x0AA7, 0xFFFF, 0xFFFF, "MCP79 OHCI USB 1.1 Controller(0x0AA7)"},
{0x10DE, 0x0AA7, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AA7, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x0AA8, 0xFFFF, 0xFFFF, "MCP79 OHCI USB 1.1 Controller(0x0AA8)"},
{0x10DE, 0x0AA9, 0xFFFF, 0xFFFF, "MCP79 EHCI USB 2.0 Controller(0x0AA9)"},
{0x10DE, 0x0AA9, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AA9, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x0AAA, 0xFFFF, 0xFFFF, "MCP79 EHCI USB 2.0 Controller(0x0AAA)"},
{0x10DE, 0x0AAB, 0xFFFF, 0xFFFF, "MCP79 PCI Bridge(0x0AAB)"},
{0x10DE, 0x0AAB, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AAB, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AAC, 0xFFFF, 0xFFFF, "MCP79 LPC Bridge(0x0AAC)"},
{0x10DE, 0x0AAD, 0xFFFF, 0xFFFF, "MCP79 LPC Bridge(0x0AAD)"},
{0x10DE, 0x0AAD, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x0AAE, 0xFFFF, 0xFFFF, "MCP79 LPC Bridge(0x0AAE)"},
{0x10DE, 0x0AAE, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AAE, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AAF, 0xFFFF, 0xFFFF, "MCP79 LPC Bridge(0x0AAF)"},
{0x10DE, 0x0AB0, 0xFFFF, 0xFFFF, "MCP79 Ethernet(0x0AB0)"},
{0x10DE, 0x0AB0, 0x1043, 0x1215, "F5GL Notebook(0x1043-0x1215)"},
{0x10DE, 0x0AB0, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AB0, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x0AB1, 0xFFFF, 0xFFFF, "MCP79 Ethernet(0x0AB1)"},
{0x10DE, 0x0AB2, 0xFFFF, 0xFFFF, "MCP79 Ethernet(0x0AB2)"},
{0x10DE, 0x0AB3, 0xFFFF, 0xFFFF, "MCP79 Ethernet(0x0AB3)"},
{0x10DE, 0x0AB4, 0xFFFF, 0xFFFF, "MCP79 SATA Controller(0x0AB4)"},
{0x10DE, 0x0AB4, 0x19DA, 0xA123, "IONITX-F-E(0x19DA-0xA123)"},
{0x10DE, 0x0AB5, 0xFFFF, 0xFFFF, "MCP79 SATA Controller(0x0AB5)"},
{0x10DE, 0x0AB6, 0xFFFF, 0xFFFF, "MCP79 SATA Controller(0x0AB6)"},
{0x10DE, 0x0AB7, 0xFFFF, 0xFFFF, "MCP79 SATA Controller(0x0AB7)"},
{0x10DE, 0x0AB8, 0xFFFF, 0xFFFF, "MCP79 AHCI Controller(0x0AB8)"},
{0x10DE, 0x0AB8, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AB9, 0xFFFF, 0xFFFF, "MCP79 AHCI Controller(0x0AB9)"},
{0x10DE, 0x0AB9, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0ABA, 0xFFFF, 0xFFFF, "MCP79 AHCI Controller(0x0ABA)"},
{0x10DE, 0x0ABB, 0xFFFF, 0xFFFF, "MCP79 AHCI Controller(0x0ABB)"},
{0x10DE, 0x0ABC, 0xFFFF, 0xFFFF, "MCP79 RAID Controller(0x0ABC)"},
{0x10DE, 0x0ABD, 0xFFFF, 0xFFFF, "MCP79 RAID Controller(0x0ABD)"},
{0x10DE, 0x0ABE, 0xFFFF, 0xFFFF, "MCP79 RAID Controller(0x0ABE)"},
{0x10DE, 0x0ABF, 0xFFFF, 0xFFFF, "MCP79 RAID Controller(0x0ABF)"},
{0x10DE, 0x0AC0, 0xFFFF, 0xFFFF, "MCP79 High Definition Audio(0x0AC0)"},
{0x10DE, 0x0AC0, 0x1043, 0x1903, "F5GL Notebook(0x1043-0x1903)"},
{0x10DE, 0x0AC0, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AC1, 0xFFFF, 0xFFFF, "MCP79 High Definition Audio(0x0AC1)"},
{0x10DE, 0x0AC2, 0xFFFF, 0xFFFF, "MCP79 High Definition Audio(0x0AC2)"},
{0x10DE, 0x0AC3, 0xFFFF, 0xFFFF, "MCP79 High Definition Audio(0x0AC3)"},
{0x10DE, 0x0AC4, 0xFFFF, 0xFFFF, "MCP79 PCI Express Bridge(0x0AC4)"},
{0x10DE, 0x0AC4, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AC5, 0xFFFF, 0xFFFF, "MCP79 PCI Express Bridge(0x0AC5)"},
{0x10DE, 0x0AC6, 0xFFFF, 0xFFFF, "MCP79 PCI Express Bridge(0x0AC6)"},
{0x10DE, 0x0AC6, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AC6, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AC7, 0xFFFF, 0xFFFF, "MCP79 PCI Express Bridge(0x0AC7)"},
{0x10DE, 0x0AC7, 0x1043, 0x1A87, "F5GL Notebook(0x1043-0x1A87)"},
{0x10DE, 0x0AC7, 0x10DE, 0xCB79, "Apple iMac 9,1(0x10DE-0xCB79)"},
{0x10DE, 0x0AC8, 0xFFFF, 0xFFFF, "MCP79 PCI Express Bridge(0x0AC8)"},
{0x10DE, 0x0AD0, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] SATA Controller (non-AHCI mode)(0x0AD0)"},
{0x10DE, 0x0AD0, 0x1462, 0x7508, "K9N2GM-FIH(0x1462-0x7508)"},
{0x10DE, 0x0AD0, 0x1849, 0x0AD0, "K10N78FullHD-hSLI R3.0 IDE(0x1849-0x0AD0)"},
{0x10DE, 0x0AD4, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] AHCI Controller(0x0AD4)"},
{0x10DE, 0x0AD4, 0x103C, 0x2A9E, "Pavilion p6310f(0x103C-0x2A9E)"},
{0x10DE, 0x0AD4, 0x1043, 0x82E8, "M3N72-D(0x1043-0x82E8)"},
{0x10DE, 0x0AD4, 0x1849, 0x0AD4, "K10N78FullHD-hSLI R3.0 AHCI Controller(0x1849-0x0AD4)"},
{0x10DE, 0x0AD8, 0xFFFF, 0xFFFF, "MCP78S [GeForce 8200] SATA Controller (RAID mode)(0x0AD8)"},
{0x10DE, 0x0BE2, 0xFFFF, 0xFFFF, "GT216 HDMI Audio Controller(0x0BE2)"},
{0x10DE, 0x0BE2, 0x1043, 0x8311, "ENGT220/DI/1GD3(LP)/V2(0x1043-0x8311)"},
{0x10DE, 0x0BE3, 0xFFFF, 0xFFFF, "High Definition Audio Controller(0x0BE3)"},
{0x10DE, 0x0BE3, 0x1028, 0x040B, "Latitude E6510(0x1028-0x040B)"},
{0x10DE, 0x0BE3, 0x10DE, 0x066D, "G98 [GeForce 8400GS](0x10DE-0x066D)"},
{0x10DE, 0x0BE3, 0x1462, 0x8094, "N210 [Geforce 210] PCIe graphics adapter(0x1462-0x8094)"},
{0x10DE, 0x0BE4, 0xFFFF, 0xFFFF, "High Definition Audio Controller(0x0BE4)"},
{0x10DE, 0x0BE5, 0xFFFF, 0xFFFF, "GF100 High Definition Audio Controller(0x0BE5)"},
{0x10DE, 0x0BE9, 0xFFFF, 0xFFFF, "GF106 High Definition Audio Controller(0x0BE9)"},
{0x10DE, 0x0BE9, 0x1558, 0x8687, "CLEVO/KAPOK W860CU(0x1558-0x8687)"},
{0x10DE, 0x0BE9, 0x3842, 0x1452, "GeForce GTS 450(0x3842-0x1452)"},
{0x10DE, 0x0BEA, 0xFFFF, 0xFFFF, "GF108 High Definition Audio Controller(0x0BEA)"},
{0x10DE, 0x0BEA, 0x3842, 0x1430, "GeForce GT 430(0x3842-0x1430)"},
{0x10DE, 0x0BEB, 0xFFFF, 0xFFFF, "GF104 High Definition Audio Controller(0x0BEB)"},
{0x10DE, 0x0BEB, 0x1462, 0x2322, "N460GTX Cyclone 1GD5/OC(0x1462-0x2322)"},
{0x10DE, 0x0BEE, 0xFFFF, 0xFFFF, "GF116 High Definition Audio Controller(0x0BEE)"},
{0x10DE, 0x0BF0, 0xFFFF, 0xFFFF, "Tegra2 PCIe x4 Bridge(0x0BF0)"},
{0x10DE, 0x0BF1, 0xFFFF, 0xFFFF, "Tegra2 PCIe x2 Bridge(0x0BF1)"},
{0x10DE, 0x0CA0, 0xFFFF, 0xFFFF, "GT215 [GeForce GT 330](0x0CA0)"},
{0x10DE, 0x0CA2, 0xFFFF, 0xFFFF, "GT215 [GeForce GT 320](0x0CA2)"},
{0x10DE, 0x0CA3, 0xFFFF, 0xFFFF, "GT215 [GeForce GT 240](0x0CA3)"},
{0x10DE, 0x0CA4, 0xFFFF, 0xFFFF, "GT215 [GeForce GT 340](0x0CA4)"},
{0x10DE, 0x0CA5, 0xFFFF, 0xFFFF, "GT215 [GeForce GT 220](0x0CA5)"},
{0x10DE, 0x0CA7, 0xFFFF, 0xFFFF, "GT215 [GeForce GT 330](0x0CA7)"},
{0x10DE, 0x0CA8, 0xFFFF, 0xFFFF, "GT215M [GeForce GTS 260M](0x0CA8)"},
{0x10DE, 0x0CA9, 0xFFFF, 0xFFFF, "GT215M [GeForce GTS 250M](0x0CA9)"},
{0x10DE, 0x0CAC, 0xFFFF, 0xFFFF, "GT215 [GeForce GT 220/315](0x0CAC)"},
{0x10DE, 0x0CAF, 0xFFFF, 0xFFFF, "GT215M [GeForce GT 335M](0x0CAF)"},
{0x10DE, 0x0CB0, 0xFFFF, 0xFFFF, "GT215M [GeForce GTS 350M](0x0CB0)"},
{0x10DE, 0x0CB1, 0xFFFF, 0xFFFF, "GT215M [GeForce GTS 360M](0x0CB1)"},
{0x10DE, 0x0CBC, 0xFFFF, 0xFFFF, "GT215GLM [Quadro FX 1800M](0x0CBC)"},
{0x10DE, 0x0D60, 0xFFFF, 0xFFFF, "MCP89 HOST Bridge(0x0D60)"},
{0x10DE, 0x0D68, 0xFFFF, 0xFFFF, "MCP89 Memory Controller(0x0D68)"},
{0x10DE, 0x0D69, 0xFFFF, 0xFFFF, "MCP89 Memory Controller(0x0D69)"},
{0x10DE, 0x0D76, 0xFFFF, 0xFFFF, "MCP89 PCI Express Bridge(0x0D76)"},
{0x10DE, 0x0D79, 0xFFFF, 0xFFFF, "MCP89 SMBus(0x0D79)"},
{0x10DE, 0x0D7A, 0xFFFF, 0xFFFF, "MCP89 Co-Processor(0x0D7A)"},
{0x10DE, 0x0D7B, 0xFFFF, 0xFFFF, "MCP89 Memory Controller(0x0D7B)"},
{0x10DE, 0x0D7D, 0xFFFF, 0xFFFF, "MCP89 Ethernet(0x0D7D)"},
{0x10DE, 0x0D80, 0xFFFF, 0xFFFF, "MCP89 LPC Bridge(0x0D80)"},
{0x10DE, 0x0D85, 0xFFFF, 0xFFFF, "MCP89 SATA Controller(0x0D85)"},
{0x10DE, 0x0D88, 0xFFFF, 0xFFFF, "MCP89 SATA Controller (AHCI mode)(0x0D88)"},
{0x10DE, 0x0D89, 0xFFFF, 0xFFFF, "MCP89 SATA Controller (AHCI mode)(0x0D89)"},
{0x10DE, 0x0D8D, 0xFFFF, 0xFFFF, "MCP89 SATA Controller (RAID mode)(0x0D8D)"},
{0x10DE, 0x0D94, 0xFFFF, 0xFFFF, "MCP89 High Definition Audio(0x0D94)"},
{0x10DE, 0x0D9C, 0xFFFF, 0xFFFF, "MCP89 OHCI USB 1.1 Controller(0x0D9C)"},
{0x10DE, 0x0D9D, 0xFFFF, 0xFFFF, "MCP89 EHCI USB 2.0 Controller(0x0D9D)"},
{0x10DE, 0x0DC0, 0xFFFF, 0xFFFF, "GF106 [GeForce GT 440](0x0DC0)"},
{0x10DE, 0x0DC4, 0xFFFF, 0xFFFF, "GF106 [GeForce GTS 450](0x0DC4)"},
{0x10DE, 0x0DC5, 0xFFFF, 0xFFFF, "GF106 [GeForce GTS 450 OEM](0x0DC5)"},
{0x10DE, 0x0DC6, 0xFFFF, 0xFFFF, "GF106 [GeForce GTS 450 OEM](0x0DC6)"},
{0x10DE, 0x0DCD, 0xFFFF, 0xFFFF, "GF106M [GeForce GT 555M](0x0DCD)"},
{0x10DE, 0x0DCE, 0xFFFF, 0xFFFF, "GF106M [GeForce GT 555M](0x0DCE)"},
{0x10DE, 0x0DD1, 0xFFFF, 0xFFFF, "GF106M [GeForce GTX 460M](0x0DD1)"},
{0x10DE, 0x0DD1, 0x1558, 0x8687, "CLEVO/KAPOK W860CU(0x1558-0x8687)"},
{0x10DE, 0x0DD2, 0xFFFF, 0xFFFF, "GF106M [GeForce GT 445M](0x0DD2)"},
{0x10DE, 0x0DD3, 0xFFFF, 0xFFFF, "GF106M [GeForce GT 435M](0x0DD3)"},
{0x10DE, 0x0DD6, 0xFFFF, 0xFFFF, "GF106M [GeForce GT 550M](0x0DD6)"},
{0x10DE, 0x0DD8, 0xFFFF, 0xFFFF, "GF106GL [Quadro 2000](0x0DD8)"},
{0x10DE, 0x0DD8, 0x10DE, 0x0914, "Quadro 2000D(0x10DE-0x0914)"},
{0x10DE, 0x0DDA, 0xFFFF, 0xFFFF, "GF106GLM [Quadro 2000M](0x0DDA)"},
{0x10DE, 0x0DE0, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 440](0x0DE0)"},
{0x10DE, 0x0DE1, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 430](0x0DE1)"},
{0x10DE, 0x0DE1, 0x3842, 0x1430, "GeForce GT 430(0x3842-0x1430)"},
{0x10DE, 0x0DE2, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 420](0x0DE2)"},
{0x10DE, 0x0DE3, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 635M](0x0DE3)"},
{0x10DE, 0x0DE4, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 520](0x0DE4)"},
{0x10DE, 0x0DE5, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 530](0x0DE5)"},
{0x10DE, 0x0DE7, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 610](0x0DE7)"},
{0x10DE, 0x0DE8, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 620M](0x0DE8)"},
{0x10DE, 0x0DE9, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 620M/630M/635M/640M LE](0x0DE9)"},
{0x10DE, 0x0DE9, 0x1025, 0x0692, "GeForce GT 620M(0x1025-0x0692)"},
{0x10DE, 0x0DE9, 0x1025, 0x0725, "GeForce GT 620M(0x1025-0x0725)"},
{0x10DE, 0x0DE9, 0x1025, 0x0728, "GeForce GT 620M(0x1025-0x0728)"},
{0x10DE, 0x0DE9, 0x1025, 0x072B, "GeForce GT 620M(0x1025-0x072B)"},
{0x10DE, 0x0DE9, 0x1025, 0x072E, "GeForce GT 620M(0x1025-0x072E)"},
{0x10DE, 0x0DE9, 0x1025, 0x0753, "GeForce GT 620M(0x1025-0x0753)"},
{0x10DE, 0x0DE9, 0x1025, 0x0754, "GeForce GT 620M(0x1025-0x0754)"},
{0x10DE, 0x0DE9, 0x17AA, 0x3977, "GeForce GT 640M LE(0x17AA-0x3977)"},
{0x10DE, 0x0DE9, 0x1B0A, 0x20C6, "GeForce GT 630M(0x1B0A-0x20C6)"},
{0x10DE, 0x0DE9, 0x1B0A, 0x2210, "GeForce GT 635M(0x1B0A-0x2210)"},
{0x10DE, 0x0DEA, 0xFFFF, 0xFFFF, "GF108M [GeForce 610M](0x0DEA)"},
{0x10DE, 0x0DEA, 0x17AA, 0x365A, "GeForce 615(0x17AA-0x365A)"},
{0x10DE, 0x0DEA, 0x17AA, 0x365B, "GeForce 615(0x17AA-0x365B)"},
{0x10DE, 0x0DEA, 0x17AA, 0x365E, "GeForce 615(0x17AA-0x365E)"},
{0x10DE, 0x0DEA, 0x17AA, 0x3660, "GeForce 615(0x17AA-0x3660)"},
{0x10DE, 0x0DEA, 0x17AA, 0x366C, "GeForce 615(0x17AA-0x366C)"},
{0x10DE, 0x0DEB, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 555M](0x0DEB)"},
{0x10DE, 0x0DEC, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 525M](0x0DEC)"},
{0x10DE, 0x0DED, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 520M](0x0DED)"},
{0x10DE, 0x0DEE, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 415M](0x0DEE)"},
{0x10DE, 0x0DEF, 0xFFFF, 0xFFFF, "GF108M [NVS 5400M](0x0DEF)"},
{0x10DE, 0x0DF0, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 425M](0x0DF0)"},
{0x10DE, 0x0DF1, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 420M](0x0DF1)"},
{0x10DE, 0x0DF2, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 435M](0x0DF2)"},
{0x10DE, 0x0DF3, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 420M](0x0DF3)"},
{0x10DE, 0x0DF4, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 540M](0x0DF4)"},
{0x10DE, 0x0DF4, 0x152D, 0x0952, "GeForce GT 630M(0x152D-0x0952)"},
{0x10DE, 0x0DF4, 0x152D, 0x0953, "GeForce GT 630M(0x152D-0x0953)"},
{0x10DE, 0x0DF5, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 525M](0x0DF5)"},
{0x10DE, 0x0DF6, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 550M](0x0DF6)"},
{0x10DE, 0x0DF7, 0xFFFF, 0xFFFF, "GF108M [GeForce GT 520M](0x0DF7)"},
{0x10DE, 0x0DF8, 0xFFFF, 0xFFFF, "GF108GL [Quadro 600](0x0DF8)"},
{0x10DE, 0x0DF9, 0xFFFF, 0xFFFF, "GF108GLM [Quadro 500M](0x0DF9)"},
{0x10DE, 0x0DFA, 0xFFFF, 0xFFFF, "GF108GLM [Quadro 1000M](0x0DFA)"},
{0x10DE, 0x0DFC, 0xFFFF, 0xFFFF, "GF108GLM [NVS 5200M](0x0DFC)"},
{0x10DE, 0x0E08, 0xFFFF, 0xFFFF, "GF119 HDMI Audio Controller(0x0E08)"},
{0x10DE, 0x0E08, 0x1043, 0x83A0, "ENGT520 SILENT(0x1043-0x83A0)"},
{0x10DE, 0x0E08, 0x10B0, 0x104A, "Gainward GeForce GT 610(0x10B0-0x104A)"},
{0x10DE, 0x0E09, 0xFFFF, 0xFFFF, "GF110 High Definition Audio Controller(0x0E09)"},
{0x10DE, 0x0E0A, 0xFFFF, 0xFFFF, "GK104 HDMI Audio Controller(0x0E0A)"},
{0x10DE, 0x0E0B, 0xFFFF, 0xFFFF, "GK106 HDMI Audio Controller(0x0E0B)"},
{0x10DE, 0x0E0C, 0xFFFF, 0xFFFF, "GF114 HDMI Audio Controller(0x0E0C)"},
{0x10DE, 0x0E0F, 0xFFFF, 0xFFFF, "GK208 HDMI/DP Audio Controller(0x0E0F)"},
{0x10DE, 0x0E12, 0xFFFF, 0xFFFF, "TegraK1 PCIe x4 Bridge(0x0E12)"},
{0x10DE, 0x0E13, 0xFFFF, 0xFFFF, "TegraK1 PCIe x1 Bridge(0x0E13)"},
{0x10DE, 0x0E1A, 0xFFFF, 0xFFFF, "GK110 High Definition Audio Controller(0x0E1A)"},
{0x10DE, 0x0E1B, 0xFFFF, 0xFFFF, "GK107 HDMI Audio Controller(0x0E1B)"},
{0x10DE, 0x0E1B, 0x103C, 0x197B, "ZBook 15(0x103C-0x197B)"},
{0x10DE, 0x0E1B, 0x1043, 0x8428, "GTX650-DC-1GD5(0x1043-0x8428)"},
{0x10DE, 0x0E1C, 0xFFFF, 0xFFFF, "Tegra3+ PCIe x4 Bridge(0x0E1C)"},
{0x10DE, 0x0E1D, 0xFFFF, 0xFFFF, "Tegra3+ PCIe x2 Bridge(0x0E1D)"},
{0x10DE, 0x0E22, 0xFFFF, 0xFFFF, "GF104 [GeForce GTX 460](0x0E22)"},
{0x10DE, 0x0E22, 0x1462, 0x2322, "N460GTX Cyclone 1GD5/OC(0x1462-0x2322)"},
{0x10DE, 0x0E23, 0xFFFF, 0xFFFF, "GF104 [GeForce GTX 460 SE](0x0E23)"},
{0x10DE, 0x0E24, 0xFFFF, 0xFFFF, "GF104 [GeForce GTX 460 OEM](0x0E24)"},
{0x10DE, 0x0E30, 0xFFFF, 0xFFFF, "GF104M [GeForce GTX 470M](0x0E30)"},
{0x10DE, 0x0E31, 0xFFFF, 0xFFFF, "GF104M [GeForce GTX 485M](0x0E31)"},
{0x10DE, 0x0E3A, 0xFFFF, 0xFFFF, "GF104GLM [Quadro 3000M](0x0E3A)"},
{0x10DE, 0x0E3B, 0xFFFF, 0xFFFF, "GF104GLM [Quadro 4000M](0x0E3B)"},
{0x10DE, 0x0F00, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 630](0x0F00)"},
{0x10DE, 0x0F01, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 620](0x0F01)"},
{0x10DE, 0x0F02, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 730](0x0F02)"},
{0x10DE, 0x0F03, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 610](0x0F03)"},
{0x10DE, 0x0F06, 0xFFFF, 0xFFFF, "GF108 [GeForce GT 730](0x0F06)"},
{0x10DE, 0x0FA0, 0xFFFF, 0xFFFF, "GK11x [GK11x_FPGA](0x0FA0)"},
{0x10DE, 0x0FA5, 0xFFFF, 0xFFFF, "GK11x(0x0FA5)"},
{0x10DE, 0x0FA7, 0xFFFF, 0xFFFF, "GK11x [Tegra on x86 (PEATRANS)](0x0FA7)"},
{0x10DE, 0x0FAE, 0xFFFF, 0xFFFF, "Tegra X1 PCIe x4 Root Complex(0x0FAE)"},
{0x10DE, 0x0FAF, 0xFFFF, 0xFFFF, "Tegra X1 PCIe x1 Root Complex(0x0FAF)"},
{0x10DE, 0x0FB0, 0xFFFF, 0xFFFF, "GM200 High Definition Audio(0x0FB0)"},
{0x10DE, 0x0FB8, 0xFFFF, 0xFFFF, "GP108 High Definition Audio Controller(0x0FB8)"},
{0x10DE, 0x0FB9, 0xFFFF, 0xFFFF, "GP107GL High Definition Audio Controller(0x0FB9)"},
{0x10DE, 0x0FBA, 0xFFFF, 0xFFFF, "GM206 High Definition Audio Controller(0x0FBA)"},
{0x10DE, 0x0FBB, 0xFFFF, 0xFFFF, "GM204 High Definition Audio Controller(0x0FBB)"},
{0x10DE, 0x0FBC, 0xFFFF, 0xFFFF, "GM107 High Definition Audio Controller [GeForce 940MX](0x0FBC)"},
{0x10DE, 0x0FC0, 0xFFFF, 0xFFFF, "GK107 [GeForce GT 640 OEM](0x0FC0)"},
{0x10DE, 0x0FC1, 0xFFFF, 0xFFFF, "GK107 [GeForce GT 640](0x0FC1)"},
{0x10DE, 0x0FC2, 0xFFFF, 0xFFFF, "GK107 [GeForce GT 630 OEM](0x0FC2)"},
{0x10DE, 0x0FC4, 0xFFFF, 0xFFFF, "GK107 [D14P1-15](0x0FC4)"},
{0x10DE, 0x0FC5, 0xFFFF, 0xFFFF, "GK107 [GeForce GT 1030](0x0FC5)"},
{0x10DE, 0x0FC6, 0xFFFF, 0xFFFF, "GK107 [GeForce GTX 650](0x0FC6)"},
{0x10DE, 0x0FC6, 0x1043, 0x8428, "GTX650-DC-1GD5(0x1043-0x8428)"},
{0x10DE, 0x0FC8, 0xFFFF, 0xFFFF, "GK107 [GeForce GT 740](0x0FC8)"},
{0x10DE, 0x0FC9, 0xFFFF, 0xFFFF, "GK107 [GeForce GT 730](0x0FC9)"},
{0x10DE, 0x0FCB, 0xFFFF, 0xFFFF, "GK107 [EXK107](0x0FCB)"},
{0x10DE, 0x0FCC, 0xFFFF, 0xFFFF, "GK107 [GeForce GT 720](0x0FCC)"},
{0x10DE, 0x0FCD, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 755M](0x0FCD)"},
{0x10DE, 0x0FCE, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 640M LE](0x0FCE)"},
{0x10DE, 0x0FCF, 0xFFFF, 0xFFFF, "GK107 [GEN3 ESI](0x0FCF)"},
{0x10DE, 0x0FD0, 0xFFFF, 0xFFFF, "GK107 [NB1G](0x0FD0)"},
{0x10DE, 0x0FD1, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 650M](0x0FD1)"},
{0x10DE, 0x0FD1, 0x1043, 0x1597, "GeForce GT 650M(0x1043-0x1597)"},
{0x10DE, 0x0FD1, 0x1043, 0x15A7, "GeForce GT 650M(0x1043-0x15A7)"},
{0x10DE, 0x0FD1, 0x1043, 0x2103, "N56VZ(0x1043-0x2103)"},
{0x10DE, 0x0FD1, 0x1043, 0x2105, "GeForce GT 650M(0x1043-0x2105)"},
{0x10DE, 0x0FD1, 0x1043, 0x2141, "GeForce GT 650M(0x1043-0x2141)"},
{0x10DE, 0x0FD2, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 640M](0x0FD2)"},
{0x10DE, 0x0FD2, 0x1028, 0x054F, "GeForce GT 640M(0x1028-0x054F)"},
{0x10DE, 0x0FD2, 0x1028, 0x055F, "GeForce GT 640M(0x1028-0x055F)"},
{0x10DE, 0x0FD2, 0x1028, 0x0595, "GeForce GT 640M LE(0x1028-0x0595)"},
{0x10DE, 0x0FD2, 0x1028, 0x05B2, "GeForce GT 640M LE(0x1028-0x05B2)"},
{0x10DE, 0x0FD3, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 640M LE](0x0FD3)"},
{0x10DE, 0x0FD4, 0xFFFF, 0xFFFF, "GK107M [GeForce GTX 660M](0x0FD4)"},
{0x10DE, 0x0FD5, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 650M Mac Edition](0x0FD5)"},
{0x10DE, 0x0FD6, 0xFFFF, 0xFFFF, "GK107M [N13P-GS-W](0x0FD6)"},
{0x10DE, 0x0FD7, 0xFFFF, 0xFFFF, "GK107 [GK107-GTX](0x0FD7)"},
{0x10DE, 0x0FD8, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 640M Mac Edition](0x0FD8)"},
{0x10DE, 0x0FD9, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 645M](0x0FD9)"},
{0x10DE, 0x0FDA, 0xFFFF, 0xFFFF, "GK107 [GK107-ES-A1](0x0FDA)"},
{0x10DE, 0x0FDB, 0xFFFF, 0xFFFF, "GK107 [GK107-ESP-A1](0x0FDB)"},
{0x10DE, 0x0FDC, 0xFFFF, 0xFFFF, "GK107 [GK107-INT22-A1](0x0FDC)"},
{0x10DE, 0x0FDD, 0xFFFF, 0xFFFF, "GK107 [GK107-INT11-A1](0x0FDD)"},
{0x10DE, 0x0FDE, 0xFFFF, 0xFFFF, "GK107 [GK107-ES-KA-E1](0x0FDE)"},
{0x10DE, 0x0FDF, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 740M](0x0FDF)"},
{0x10DE, 0x0FE0, 0xFFFF, 0xFFFF, "GK107M [GeForce GTX 660M Mac Edition](0x0FE0)"},
{0x10DE, 0x0FE1, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 730M](0x0FE1)"},
{0x10DE, 0x0FE2, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 745M](0x0FE2)"},
{0x10DE, 0x0FE3, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 745M](0x0FE3)"},
{0x10DE, 0x0FE3, 0x103C, 0x2B16, "GeForce GT 745A(0x103C-0x2B16)"},
{0x10DE, 0x0FE3, 0x17AA, 0x3675, "GeForce GT 745A(0x17AA-0x3675)"},
{0x10DE, 0x0FE4, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 750M](0x0FE4)"},
{0x10DE, 0x0FE5, 0xFFFF, 0xFFFF, "GK107 [GeForce K340 USM](0x0FE5)"},
{0x10DE, 0x0FE6, 0xFFFF, 0xFFFF, "GK107 [GRID K1 NVS USM](0x0FE6)"},
{0x10DE, 0x0FE7, 0xFFFF, 0xFFFF, "GK107GL [GRID K100 vGPU](0x0FE7)"},
{0x10DE, 0x0FE7, 0x10DE, 0x101E, "GRID K100(0x10DE-0x101E)"},
{0x10DE, 0x0FE8, 0xFFFF, 0xFFFF, "GK107M [N14P-GS](0x0FE8)"},
{0x10DE, 0x0FE9, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 750M Mac Edition](0x0FE9)"},
{0x10DE, 0x0FEA, 0xFFFF, 0xFFFF, "GK107M [GeForce GT 755M Mac Edition](0x0FEA)"},
{0x10DE, 0x0FEC, 0xFFFF, 0xFFFF, "GK107M [GeForce 710A](0x0FEC)"},
{0x10DE, 0x0FED, 0xFFFF, 0xFFFF, "GK107M [GeForce 820M](0x0FED)"},
{0x10DE, 0x0FEE, 0xFFFF, 0xFFFF, "GK107M [GeForce 810M](0x0FEE)"},
{0x10DE, 0x0FEF, 0xFFFF, 0xFFFF, "GK107GL [GRID K340](0x0FEF)"},
{0x10DE, 0x0FF0, 0xFFFF, 0xFFFF, "GK107 [NB1Q](0x0FF0)"},
{0x10DE, 0x0FF1, 0xFFFF, 0xFFFF, "GK107 [NVS 1000](0x0FF1)"},
{0x10DE, 0x0FF2, 0xFFFF, 0xFFFF, "GK107GL [GRID K1](0x0FF2)"},
{0x10DE, 0x0FF3, 0xFFFF, 0xFFFF, "GK107GL [Quadro K420](0x0FF3)"},
{0x10DE, 0x0FF5, 0xFFFF, 0xFFFF, "GK107GL [GRID K1 Tesla USM](0x0FF5)"},
{0x10DE, 0x0FF6, 0xFFFF, 0xFFFF, "GK107GLM [Quadro K1100M](0x0FF6)"},
{0x10DE, 0x0FF6, 0x103C, 0x197B, "ZBook 15(0x103C-0x197B)"},
{0x10DE, 0x0FF7, 0xFFFF, 0xFFFF, "GK107GL [GRID K140Q vGPU](0x0FF7)"},
{0x10DE, 0x0FF7, 0x10DE, 0x1037, "GRID K140Q(0x10DE-0x1037)"},
{0x10DE, 0x0FF8, 0xFFFF, 0xFFFF, "GK107GLM [Quadro K500M](0x0FF8)"},
{0x10DE, 0x0FF9, 0xFFFF, 0xFFFF, "GK107GL [Quadro K2000D](0x0FF9)"},
{0x10DE, 0x0FFA, 0xFFFF, 0xFFFF, "GK107GL [Quadro K600](0x0FFA)"},
{0x10DE, 0x0FFB, 0xFFFF, 0xFFFF, "GK107GLM [Quadro K2000M](0x0FFB)"},
{0x10DE, 0x0FFC, 0xFFFF, 0xFFFF, "GK107GLM [Quadro K1000M](0x0FFC)"},
{0x10DE, 0x0FFD, 0xFFFF, 0xFFFF, "GK107 [NVS 510](0x0FFD)"},
{0x10DE, 0x0FFE, 0xFFFF, 0xFFFF, "GK107GL [Quadro K2000](0x0FFE)"},
{0x10DE, 0x0FFF, 0xFFFF, 0xFFFF, "GK107GL [Quadro 410](0x0FFF)"},
{0x10DE, 0x1001, 0xFFFF, 0xFFFF, "GK110B [GeForce GTX TITAN Z](0x1001)"},
{0x10DE, 0x1003, 0xFFFF, 0xFFFF, "GK110 [GeForce GTX Titan LE](0x1003)"},
{0x10DE, 0x1004, 0xFFFF, 0xFFFF, "GK110 [GeForce GTX 780](0x1004)"},
{0x10DE, 0x1004, 0x3842, 0x0784, "GK110B [GeForce GTX 780 SC w/ ACX Cooler](0x3842-0x0784)"},
{0x10DE, 0x1004, 0x3842, 0x1784, "GK110B [GeForce GTX 780 Dual FTW w/ ACX Cooler](0x3842-0x1784)"},
{0x10DE, 0x1004, 0x3842, 0x1788, "GK110B [GeForce GTX 780 Dual Classified w/ ACX Cooler](0x3842-0x1788)"},
{0x10DE, 0x1005, 0xFFFF, 0xFFFF, "GK110 [GeForce GTX TITAN](0x1005)"},
{0x10DE, 0x1005, 0x1043, 0x8451, "GTXTITAN-6GD5(0x1043-0x8451)"},
{0x10DE, 0x1005, 0x10DE, 0x1035, "GeForce GTX Titan(0x10DE-0x1035)"},
{0x10DE, 0x1005, 0x3842, 0x2790, "GeForce GTX Titan(0x3842-0x2790)"},
{0x10DE, 0x1005, 0x3842, 0x2791, "GeForce GTX Titan SC(0x3842-0x2791)"},
{0x10DE, 0x1005, 0x3842, 0x2793, "GeForce GTX Titan SC Signature(0x3842-0x2793)"},
{0x10DE, 0x1005, 0x3842, 0x2794, "GeForce GTX Titan SC Hydro Copper(0x3842-0x2794)"},
{0x10DE, 0x1005, 0x3842, 0x2795, "GeForce GTX Titan SC Hydro Copper Signature(0x3842-0x2795)"},
{0x10DE, 0x1007, 0xFFFF, 0xFFFF, "GK110 [GeForce GTX 780 Rev. 2](0x1007)"},
{0x10DE, 0x1008, 0xFFFF, 0xFFFF, "GK110 [GeForce GTX 780 Ti 6GB](0x1008)"},
{0x10DE, 0x100A, 0xFFFF, 0xFFFF, "GK110B [GeForce GTX 780 Ti](0x100A)"},
{0x10DE, 0x100C, 0xFFFF, 0xFFFF, "GK110B [GeForce GTX TITAN Black](0x100C)"},
{0x10DE, 0x101E, 0xFFFF, 0xFFFF, "GK110GL [Tesla K20X](0x101E)"},
{0x10DE, 0x101F, 0xFFFF, 0xFFFF, "GK110GL [Tesla K20](0x101F)"},
{0x10DE, 0x1020, 0xFFFF, 0xFFFF, "GK110GL [Tesla K20X](0x1020)"},
{0x10DE, 0x1021, 0xFFFF, 0xFFFF, "GK110GL [Tesla K20Xm](0x1021)"},
{0x10DE, 0x1022, 0xFFFF, 0xFFFF, "GK110GL [Tesla K20c](0x1022)"},
{0x10DE, 0x1023, 0xFFFF, 0xFFFF, "GK110BGL [Tesla K40m](0x1023)"},
{0x10DE, 0x1023, 0x10DE, 0x097E, "12GB Computational Accelerator(0x10DE-0x097E)"},
{0x10DE, 0x1024, 0xFFFF, 0xFFFF, "GK180GL [Tesla K40c](0x1024)"},
{0x10DE, 0x1026, 0xFFFF, 0xFFFF, "GK110GL [Tesla K20s](0x1026)"},
{0x10DE, 0x1027, 0xFFFF, 0xFFFF, "GK110BGL [Tesla K40st](0x1027)"},
{0x10DE, 0x1028, 0xFFFF, 0xFFFF, "GK110GL [Tesla K20m](0x1028)"},
{0x10DE, 0x1029, 0xFFFF, 0xFFFF, "GK110BGL [Tesla K40s](0x1029)"},
{0x10DE, 0x102A, 0xFFFF, 0xFFFF, "GK110BGL [Tesla K40t](0x102A)"},
{0x10DE, 0x102D, 0xFFFF, 0xFFFF, "GK210GL [Tesla K80](0x102D)"},
{0x10DE, 0x102E, 0xFFFF, 0xFFFF, "GK110BGL [Tesla K40d](0x102E)"},
{0x10DE, 0x102F, 0xFFFF, 0xFFFF, "GK110BGL [Tesla Stella Solo](0x102F)"},
{0x10DE, 0x103A, 0xFFFF, 0xFFFF, "GK110GL [Quadro K6000](0x103A)"},
{0x10DE, 0x103C, 0xFFFF, 0xFFFF, "GK110GL [Quadro K5200](0x103C)"},
{0x10DE, 0x103F, 0xFFFF, 0xFFFF, "GK110BGL [Tesla Stella SXM](0x103F)"},
{0x10DE, 0x1040, 0xFFFF, 0xFFFF, "GF119 [GeForce GT 520](0x1040)"},
{0x10DE, 0x1040, 0x1043, 0x83A0, "ENGT520 SILENT(0x1043-0x83A0)"},
{0x10DE, 0x1042, 0xFFFF, 0xFFFF, "GF119 [GeForce 510](0x1042)"},
{0x10DE, 0x1045, 0xFFFF, 0xFFFF, "GF119(0x1045)"},
{0x10DE, 0x1048, 0xFFFF, 0xFFFF, "GF119 [GeForce 605](0x1048)"},
{0x10DE, 0x1049, 0xFFFF, 0xFFFF, "GF119 [GeForce GT 620 OEM](0x1049)"},
{0x10DE, 0x104A, 0xFFFF, 0xFFFF, "GF119 [GeForce GT 610](0x104A)"},
{0x10DE, 0x104A, 0x10B0, 0x104A, "Gainward GeForce GT 610(0x10B0-0x104A)"},
{0x10DE, 0x104B, 0xFFFF, 0xFFFF, "GF119 [GeForce GT 625 OEM](0x104B)"},
{0x10DE, 0x104C, 0xFFFF, 0xFFFF, "GF119 [GeForce GT 705](0x104C)"},
{0x10DE, 0x104D, 0xFFFF, 0xFFFF, "GF119 [GeForce GT 710](0x104D)"},
{0x10DE, 0x1050, 0xFFFF, 0xFFFF, "GF119M [GeForce GT 520M](0x1050)"},
{0x10DE, 0x1051, 0xFFFF, 0xFFFF, "GF119M [GeForce GT 520MX](0x1051)"},
{0x10DE, 0x1052, 0xFFFF, 0xFFFF, "GF119M [GeForce GT 520M](0x1052)"},
{0x10DE, 0x1054, 0xFFFF, 0xFFFF, "GF119M [GeForce 410M](0x1054)"},
{0x10DE, 0x1055, 0xFFFF, 0xFFFF, "GF119M [GeForce 410M](0x1055)"},
{0x10DE, 0x1056, 0xFFFF, 0xFFFF, "GF119M [NVS 4200M](0x1056)"},
{0x10DE, 0x1057, 0xFFFF, 0xFFFF, "GF119M [Quadro NVS 4200M](0x1057)"},
{0x10DE, 0x1058, 0xFFFF, 0xFFFF, "GF119M [GeForce 610M](0x1058)"},
{0x10DE, 0x1058, 0x103C, 0x2AED, "GeForce 610(0x103C-0x2AED)"},
{0x10DE, 0x1058, 0x103C, 0x2AF1, "GeForce 610(0x103C-0x2AF1)"},
{0x10DE, 0x1058, 0x1043, 0x10AC, "GeForce GT 610M(0x1043-0x10AC)"},
{0x10DE, 0x1058, 0x1043, 0x10BC, "GeForce GT 610M(0x1043-0x10BC)"},
{0x10DE, 0x1058, 0x1043, 0x1652, "GeForce GT 610M(0x1043-0x1652)"},
{0x10DE, 0x1058, 0x17AA, 0x367A, "GeForce 610M(0x17AA-0x367A)"},
{0x10DE, 0x1058, 0x17AA, 0x3682, "GeForce 800A(0x17AA-0x3682)"},
{0x10DE, 0x1058, 0x17AA, 0x3687, "GeForce 800A(0x17AA-0x3687)"},
{0x10DE, 0x1058, 0x17AA, 0x3692, "GeForce 705A(0x17AA-0x3692)"},
{0x10DE, 0x1058, 0x17AA, 0x3695, "GeForce 800A(0x17AA-0x3695)"},
{0x10DE, 0x1058, 0x17AA, 0xA117, "GeForce 610M(0x17AA-0xA117)"},
{0x10DE, 0x1059, 0xFFFF, 0xFFFF, "GF119M [GeForce 610M](0x1059)"},
{0x10DE, 0x105A, 0xFFFF, 0xFFFF, "GF119M [GeForce 610M](0x105A)"},
{0x10DE, 0x105A, 0x1043, 0x2111, "GeForce GT 610M(0x1043-0x2111)"},
{0x10DE, 0x105A, 0x1043, 0x2112, "GeForce GT 610M(0x1043-0x2112)"},
{0x10DE, 0x105B, 0xFFFF, 0xFFFF, "GF119M [GeForce 705M](0x105B)"},
{0x10DE, 0x105B, 0x103C, 0x2AFB, "GeForce 705A(0x103C-0x2AFB)"},
{0x10DE, 0x105B, 0x17AA, 0x309D, "GeForce 705A(0x17AA-0x309D)"},
{0x10DE, 0x105B, 0x17AA, 0x30B1, "GeForce 800A(0x17AA-0x30B1)"},
{0x10DE, 0x105B, 0x17AA, 0x30F3, "GeForce 705A(0x17AA-0x30F3)"},
{0x10DE, 0x105B, 0x17AA, 0x36A1, "GeForce 800A(0x17AA-0x36A1)"},
{0x10DE, 0x107C, 0xFFFF, 0xFFFF, "GF119 [NVS 315](0x107C)"},
{0x10DE, 0x107D, 0xFFFF, 0xFFFF, "GF119 [NVS 310](0x107D)"},
{0x10DE, 0x1080, 0xFFFF, 0xFFFF, "GF110 [GeForce GTX 580](0x1080)"},
{0x10DE, 0x1081, 0xFFFF, 0xFFFF, "GF110 [GeForce GTX 570](0x1081)"},
{0x10DE, 0x1081, 0x10DE, 0x087E, "Leadtek WinFast GTX 570(0x10DE-0x087E)"},
{0x10DE, 0x1082, 0xFFFF, 0xFFFF, "GF110 [GeForce GTX 560 Ti OEM](0x1082)"},
{0x10DE, 0x1084, 0xFFFF, 0xFFFF, "GF110 [GeForce GTX 560 OEM](0x1084)"},
{0x10DE, 0x1086, 0xFFFF, 0xFFFF, "GF110 [GeForce GTX 570 Rev. 2](0x1086)"},
{0x10DE, 0x1087, 0xFFFF, 0xFFFF, "GF110 [GeForce GTX 560 Ti 448 Cores](0x1087)"},
{0x10DE, 0x1088, 0xFFFF, 0xFFFF, "GF110 [GeForce GTX 590](0x1088)"},
{0x10DE, 0x1089, 0xFFFF, 0xFFFF, "GF110 [GeForce GTX 580 Rev. 2](0x1089)"},
{0x10DE, 0x108B, 0xFFFF, 0xFFFF, "GF110 [GeForce GTX 580](0x108B)"},
{0x10DE, 0x108E, 0xFFFF, 0xFFFF, "GF110GL [Tesla C2090](0x108E)"},
{0x10DE, 0x1091, 0xFFFF, 0xFFFF, "GF110GL [Tesla M2090](0x1091)"},
{0x10DE, 0x1091, 0x10DE, 0x088E, "Tesla X2090(0x10DE-0x088E)"},
{0x10DE, 0x1091, 0x10DE, 0x0891, "Tesla X2090(0x10DE-0x0891)"},
{0x10DE, 0x1091, 0x10DE, 0x0974, "Tesla X2090(0x10DE-0x0974)"},
{0x10DE, 0x1091, 0x10DE, 0x098D, "Tesla X2090(0x10DE-0x098D)"},
{0x10DE, 0x1094, 0xFFFF, 0xFFFF, "GF110GL [Tesla M2075](0x1094)"},
{0x10DE, 0x1094, 0x10DE, 0x0888, "Tesla M2075(0x10DE-0x0888)"},
{0x10DE, 0x1096, 0xFFFF, 0xFFFF, "GF110GL [Tesla C2050 / C2075](0x1096)"},
{0x10DE, 0x1096, 0x10DE, 0x0910, "Tesla C2075(0x10DE-0x0910)"},
{0x10DE, 0x1096, 0x10DE, 0x0911, "Tesla C2050(0x10DE-0x0911)"},
{0x10DE, 0x109A, 0xFFFF, 0xFFFF, "GF100GLM [Quadro 5010M](0x109A)"},
{0x10DE, 0x109B, 0xFFFF, 0xFFFF, "GF100GL [Quadro 7000](0x109B)"},
{0x10DE, 0x109B, 0x10DE, 0x0918, "Quadro 7000(0x10DE-0x0918)"},
{0x10DE, 0x10C0, 0xFFFF, 0xFFFF, "GT218 [GeForce 9300 GS Rev. 2](0x10C0)"},
{0x10DE, 0x10C3, 0xFFFF, 0xFFFF, "GT218 [GeForce 8400 GS Rev. 3](0x10C3)"},
{0x10DE, 0x10C5, 0xFFFF, 0xFFFF, "GT218 [GeForce 405](0x10C5)"},
{0x10DE, 0x10D8, 0xFFFF, 0xFFFF, "GT218 [NVS 300](0x10D8)"},
{0x10DE, 0x10E5, 0xFFFF, 0xFFFF, "Parker PCIe x4 Root Complex(0x10E5)"},
{0x10DE, 0x10E6, 0xFFFF, 0xFFFF, "Parker PCIe x1 Root Complex(0x10E6)"},
{0x10DE, 0x10EF, 0xFFFF, 0xFFFF, "GP102 HDMI Audio Controller(0x10EF)"},
{0x10DE, 0x10F0, 0xFFFF, 0xFFFF, "GP104 High Definition Audio Controller(0x10F0)"},
{0x10DE, 0x10F1, 0xFFFF, 0xFFFF, "GP106 High Definition Audio Controller(0x10F1)"},
{0x10DE, 0x10F1, 0x1043, 0x85B6, "DUAL-GTX1060-O6G [GeForce GTX 1060 6GB Dual](0x1043-0x85B6)"},
{0x10DE, 0x10F7, 0xFFFF, 0xFFFF, "TU102 High Definition Audio Controller(0x10F7)"},
{0x10DE, 0x10F8, 0xFFFF, 0xFFFF, "TU104 HD Audio Controller(0x10F8)"},
{0x10DE, 0x10F9, 0xFFFF, 0xFFFF, "TU106 High Definition Audio Controller(0x10F9)"},
{0x10DE, 0x10F9, 0x1043, 0x8673, "TURBO-RTX2070-8G(0x1043-0x8673)"},
{0x10DE, 0x1140, 0xFFFF, 0xFFFF, "GF117M [GeForce 610M/710M/810M/820M / GT 620M/625M/630M/720M](0x1140)"},
{0x10DE, 0x1140, 0x1019, 0x0799, "GeForce 820M(0x1019-0x0799)"},
{0x10DE, 0x1140, 0x1019, 0x999F, "GeForce GT 720M(0x1019-0x999F)"},
{0x10DE, 0x1140, 0x1025, 0x0600, "GeForce GT 620M(0x1025-0x0600)"},
{0x10DE, 0x1140, 0x1025, 0x0606, "GeForce GT 620M(0x1025-0x0606)"},
{0x10DE, 0x1140, 0x1025, 0x064A, "GeForce GT 620M(0x1025-0x064A)"},
{0x10DE, 0x1140, 0x1025, 0x064C, "GeForce GT 620M(0x1025-0x064C)"},
{0x10DE, 0x1140, 0x1025, 0x067A, "GeForce GT 620M(0x1025-0x067A)"},
{0x10DE, 0x1140, 0x1025, 0x0680, "GeForce GT 620M(0x1025-0x0680)"},
{0x10DE, 0x1140, 0x1025, 0x0686, "GeForce 710M(0x1025-0x0686)"},
{0x10DE, 0x1140, 0x1025, 0x0689, "GeForce 710M(0x1025-0x0689)"},
{0x10DE, 0x1140, 0x1025, 0x068B, "GeForce 710M(0x1025-0x068B)"},
{0x10DE, 0x1140, 0x1025, 0x068D, "GeForce 710M(0x1025-0x068D)"},
{0x10DE, 0x1140, 0x1025, 0x068E, "GeForce 710M(0x1025-0x068E)"},
{0x10DE, 0x1140, 0x1025, 0x0691, "GeForce 710M(0x1025-0x0691)"},
{0x10DE, 0x1140, 0x1025, 0x0692, "GeForce GT 620M(0x1025-0x0692)"},
{0x10DE, 0x1140, 0x1025, 0x0694, "GeForce GT 620M(0x1025-0x0694)"},
{0x10DE, 0x1140, 0x1025, 0x0702, "GeForce GT 620M(0x1025-0x0702)"},
{0x10DE, 0x1140, 0x1025, 0x0719, "GeForce GT 620M(0x1025-0x0719)"},
{0x10DE, 0x1140, 0x1025, 0x0725, "GeForce GT 620M(0x1025-0x0725)"},
{0x10DE, 0x1140, 0x1025, 0x0728, "GeForce GT 620M(0x1025-0x0728)"},
{0x10DE, 0x1140, 0x1025, 0x072B, "GeForce GT 620M(0x1025-0x072B)"},
{0x10DE, 0x1140, 0x1025, 0x072E, "GeForce GT 620M(0x1025-0x072E)"},
{0x10DE, 0x1140, 0x1025, 0x0732, "GeForce GT 620M(0x1025-0x0732)"},
{0x10DE, 0x1140, 0x1025, 0x0763, "GeForce GT 720M(0x1025-0x0763)"},
{0x10DE, 0x1140, 0x1025, 0x0773, "GeForce 710M(0x1025-0x0773)"},
{0x10DE, 0x1140, 0x1025, 0x0774, "GeForce 710M(0x1025-0x0774)"},
{0x10DE, 0x1140, 0x1025, 0x0776, "GeForce GT 720M(0x1025-0x0776)"},
{0x10DE, 0x1140, 0x1025, 0x077A, "GeForce 710M(0x1025-0x077A)"},
{0x10DE, 0x1140, 0x1025, 0x077B, "GeForce 710M(0x1025-0x077B)"},
{0x10DE, 0x1140, 0x1025, 0x077C, "GeForce 710M(0x1025-0x077C)"},
{0x10DE, 0x1140, 0x1025, 0x077D, "GeForce 710M(0x1025-0x077D)"},
{0x10DE, 0x1140, 0x1025, 0x077E, "GeForce 710M(0x1025-0x077E)"},
{0x10DE, 0x1140, 0x1025, 0x077F, "GeForce 710M(0x1025-0x077F)"},
{0x10DE, 0x1140, 0x1025, 0x0781, "GeForce GT 720M(0x1025-0x0781)"},
{0x10DE, 0x1140, 0x1025, 0x0798, "GeForce GT 720M(0x1025-0x0798)"},
{0x10DE, 0x1140, 0x1025, 0x0799, "GeForce GT 720M(0x1025-0x0799)"},
{0x10DE, 0x1140, 0x1025, 0x079B, "GeForce GT 720M(0x1025-0x079B)"},
{0x10DE, 0x1140, 0x1025, 0x079C, "GeForce GT 720M(0x1025-0x079C)"},
{0x10DE, 0x1140, 0x1025, 0x0807, "GeForce GT 720M(0x1025-0x0807)"},
{0x10DE, 0x1140, 0x1025, 0x0821, "GeForce GT 720M(0x1025-0x0821)"},
{0x10DE, 0x1140, 0x1025, 0x0823, "GeForce GT 720M(0x1025-0x0823)"},
{0x10DE, 0x1140, 0x1025, 0x0830, "GeForce GT 720M(0x1025-0x0830)"},
{0x10DE, 0x1140, 0x1025, 0x0833, "GeForce GT 720M(0x1025-0x0833)"},
{0x10DE, 0x1140, 0x1025, 0x0837, "GeForce GT 720M(0x1025-0x0837)"},
{0x10DE, 0x1140, 0x1025, 0x083E, "GeForce 820M(0x1025-0x083E)"},
{0x10DE, 0x1140, 0x1025, 0x0841, "GeForce 710M(0x1025-0x0841)"},
{0x10DE, 0x1140, 0x1025, 0x0854, "GeForce 820M(0x1025-0x0854)"},
{0x10DE, 0x1140, 0x1025, 0x0855, "GeForce 820M(0x1025-0x0855)"},
{0x10DE, 0x1140, 0x1025, 0x0856, "GeForce 820M(0x1025-0x0856)"},
{0x10DE, 0x1140, 0x1025, 0x0857, "GeForce 820M(0x1025-0x0857)"},
{0x10DE, 0x1140, 0x1025, 0x0858, "GeForce 820M(0x1025-0x0858)"},
{0x10DE, 0x1140, 0x1025, 0x0863, "GeForce 820M(0x1025-0x0863)"},
{0x10DE, 0x1140, 0x1025, 0x0868, "GeForce 820M(0x1025-0x0868)"},
{0x10DE, 0x1140, 0x1025, 0x0869, "GeForce 810M(0x1025-0x0869)"},
{0x10DE, 0x1140, 0x1025, 0x0873, "GeForce 820M(0x1025-0x0873)"},
{0x10DE, 0x1140, 0x1025, 0x0878, "GeForce 820M(0x1025-0x0878)"},
{0x10DE, 0x1140, 0x1025, 0x087B, "GeForce 820M(0x1025-0x087B)"},
{0x10DE, 0x1140, 0x1025, 0x087C, "GeForce 810M(0x1025-0x087C)"},
{0x10DE, 0x1140, 0x1025, 0x0881, "GeForce 820M(0x1025-0x0881)"},
{0x10DE, 0x1140, 0x1025, 0x088A, "GeForce 820M(0x1025-0x088A)"},
{0x10DE, 0x1140, 0x1025, 0x089B, "GeForce 820M(0x1025-0x089B)"},
{0x10DE, 0x1140, 0x1025, 0x090F, "GeForce 820M(0x1025-0x090F)"},
{0x10DE, 0x1140, 0x1025, 0x0921, "GeForce 820M(0x1025-0x0921)"},
{0x10DE, 0x1140, 0x1025, 0x092E, "GeForce 810M(0x1025-0x092E)"},
{0x10DE, 0x1140, 0x1025, 0x092F, "GeForce 820M(0x1025-0x092F)"},
{0x10DE, 0x1140, 0x1025, 0x0932, "GeForce 820M(0x1025-0x0932)"},
{0x10DE, 0x1140, 0x1025, 0x093A, "GeForce 820M(0x1025-0x093A)"},
{0x10DE, 0x1140, 0x1025, 0x093C, "GeForce 820M(0x1025-0x093C)"},
{0x10DE, 0x1140, 0x1025, 0x093F, "GeForce 820M(0x1025-0x093F)"},
{0x10DE, 0x1140, 0x1025, 0x0941, "GeForce 820M(0x1025-0x0941)"},
{0x10DE, 0x1140, 0x1025, 0x0945, "GeForce 820M(0x1025-0x0945)"},
{0x10DE, 0x1140, 0x1025, 0x0954, "GeForce 820M(0x1025-0x0954)"},
{0x10DE, 0x1140, 0x1025, 0x0965, "GeForce 820M(0x1025-0x0965)"},
{0x10DE, 0x1140, 0x1028, 0x054D, "GeForce GT 630M(0x1028-0x054D)"},
{0x10DE, 0x1140, 0x1028, 0x054E, "GeForce GT 630M(0x1028-0x054E)"},
{0x10DE, 0x1140, 0x1028, 0x0554, "GeForce GT 620M(0x1028-0x0554)"},
{0x10DE, 0x1140, 0x1028, 0x0557, "GeForce GT 620M(0x1028-0x0557)"},
{0x10DE, 0x1140, 0x1028, 0x0562, "GeForce GT 625M(0x1028-0x0562)"},
{0x10DE, 0x1140, 0x1028, 0x0565, "GeForce GT 630M(0x1028-0x0565)"},
{0x10DE, 0x1140, 0x1028, 0x0568, "GeForce GT 630M(0x1028-0x0568)"},
{0x10DE, 0x1140, 0x1028, 0x0590, "GeForce GT 630M(0x1028-0x0590)"},
{0x10DE, 0x1140, 0x1028, 0x0592, "GeForce GT 625M(0x1028-0x0592)"},
{0x10DE, 0x1140, 0x1028, 0x0594, "GeForce GT 625M(0x1028-0x0594)"},
{0x10DE, 0x1140, 0x1028, 0x0595, "GeForce GT 625M(0x1028-0x0595)"},
{0x10DE, 0x1140, 0x1028, 0x05A2, "GeForce GT 625M(0x1028-0x05A2)"},
{0x10DE, 0x1140, 0x1028, 0x05B1, "GeForce GT 625M(0x1028-0x05B1)"},
{0x10DE, 0x1140, 0x1028, 0x05B3, "GeForce GT 625M(0x1028-0x05B3)"},
{0x10DE, 0x1140, 0x1028, 0x05DA, "GeForce GT 630M(0x1028-0x05DA)"},
{0x10DE, 0x1140, 0x1028, 0x05DE, "GeForce GT 720M(0x1028-0x05DE)"},
{0x10DE, 0x1140, 0x1028, 0x05E0, "GeForce GT 720M(0x1028-0x05E0)"},
{0x10DE, 0x1140, 0x1028, 0x05E8, "GeForce GT 630M(0x1028-0x05E8)"},
{0x10DE, 0x1140, 0x1028, 0x05F4, "GeForce GT 720M(0x1028-0x05F4)"},
{0x10DE, 0x1140, 0x1028, 0x060F, "GeForce GT 720M(0x1028-0x060F)"},
{0x10DE, 0x1140, 0x1028, 0x064E, "GeForce 820M(0x1028-0x064E)"},
{0x10DE, 0x1140, 0x1028, 0x0652, "GeForce 820M(0x1028-0x0652)"},
{0x10DE, 0x1140, 0x1028, 0x0653, "GeForce 820M(0x1028-0x0653)"},
{0x10DE, 0x1140, 0x1028, 0x0655, "GeForce 820M(0x1028-0x0655)"},
{0x10DE, 0x1140, 0x1028, 0x065E, "GeForce 820M(0x1028-0x065E)"},
{0x10DE, 0x1140, 0x1028, 0x0662, "GeForce 820M(0x1028-0x0662)"},
{0x10DE, 0x1140, 0x1028, 0x068D, "GeForce 820M(0x1028-0x068D)"},
{0x10DE, 0x1140, 0x1028, 0x06AD, "GeForce 820M(0x1028-0x06AD)"},
{0x10DE, 0x1140, 0x1028, 0x06AE, "GeForce 820M(0x1028-0x06AE)"},
{0x10DE, 0x1140, 0x1028, 0x06AF, "GeForce 820M(0x1028-0x06AF)"},
{0x10DE, 0x1140, 0x1028, 0x06B0, "GeForce 820M(0x1028-0x06B0)"},
{0x10DE, 0x1140, 0x1028, 0x06C0, "GeForce 820M(0x1028-0x06C0)"},
{0x10DE, 0x1140, 0x1028, 0x06C1, "GeForce 820M(0x1028-0x06C1)"},
{0x10DE, 0x1140, 0x103C, 0x18EF, "GeForce GT 630M(0x103C-0x18EF)"},
{0x10DE, 0x1140, 0x103C, 0x18F9, "GeForce GT 630M(0x103C-0x18F9)"},
{0x10DE, 0x1140, 0x103C, 0x18FB, "GeForce GT 630M(0x103C-0x18FB)"},
{0x10DE, 0x1140, 0x103C, 0x18FD, "GeForce GT 630M(0x103C-0x18FD)"},
{0x10DE, 0x1140, 0x103C, 0x18FF, "GeForce GT 630M(0x103C-0x18FF)"},
{0x10DE, 0x1140, 0x103C, 0x218A, "GeForce 820M(0x103C-0x218A)"},
{0x10DE, 0x1140, 0x103C, 0x21BB, "GeForce 820M(0x103C-0x21BB)"},
{0x10DE, 0x1140, 0x103C, 0x21BC, "GeForce 820M(0x103C-0x21BC)"},
{0x10DE, 0x1140, 0x103C, 0x220E, "GeForce 820M(0x103C-0x220E)"},
{0x10DE, 0x1140, 0x103C, 0x2210, "GeForce 820M(0x103C-0x2210)"},
{0x10DE, 0x1140, 0x103C, 0x2212, "GeForce 820M(0x103C-0x2212)"},
{0x10DE, 0x1140, 0x103C, 0x2214, "GeForce 820M(0x103C-0x2214)"},
{0x10DE, 0x1140, 0x103C, 0x2218, "GeForce 820M(0x103C-0x2218)"},
{0x10DE, 0x1140, 0x103C, 0x225B, "GeForce 820M(0x103C-0x225B)"},
{0x10DE, 0x1140, 0x103C, 0x225D, "GeForce 820M(0x103C-0x225D)"},
{0x10DE, 0x1140, 0x103C, 0x226D, "GeForce 820M(0x103C-0x226D)"},
{0x10DE, 0x1140, 0x103C, 0x226F, "GeForce 820M(0x103C-0x226F)"},
{0x10DE, 0x1140, 0x103C, 0x22D2, "GeForce 820M(0x103C-0x22D2)"},
{0x10DE, 0x1140, 0x103C, 0x22D9, "GeForce 820M(0x103C-0x22D9)"},
{0x10DE, 0x1140, 0x103C, 0x2335, "GeForce 820M(0x103C-0x2335)"},
{0x10DE, 0x1140, 0x103C, 0x2337, "GeForce 820M(0x103C-0x2337)"},
{0x10DE, 0x1140, 0x103C, 0x2AEF, "GeForce GT 720A(0x103C-0x2AEF)"},
{0x10DE, 0x1140, 0x103C, 0x2AF9, "GeForce 710A(0x103C-0x2AF9)"},
{0x10DE, 0x1140, 0x1043, 0x10DD, "NVS 5200M(0x1043-0x10DD)"},
{0x10DE, 0x1140, 0x1043, 0x10ED, "NVS 5200M(0x1043-0x10ED)"},
{0x10DE, 0x1140, 0x1043, 0x11FD, "GeForce GT 720M(0x1043-0x11FD)"},
{0x10DE, 0x1140, 0x1043, 0x124D, "GeForce GT 720M(0x1043-0x124D)"},
{0x10DE, 0x1140, 0x1043, 0x126D, "GeForce GT 720M(0x1043-0x126D)"},
{0x10DE, 0x1140, 0x1043, 0x131D, "GeForce GT 720M(0x1043-0x131D)"},
{0x10DE, 0x1140, 0x1043, 0x13FD, "GeForce GT 720M(0x1043-0x13FD)"},
{0x10DE, 0x1140, 0x1043, 0x14C7, "GeForce GT 720M(0x1043-0x14C7)"},
{0x10DE, 0x1140, 0x1043, 0x1507, "GeForce GT 620M(0x1043-0x1507)"},
{0x10DE, 0x1140, 0x1043, 0x15AD, "GeForce 820M(0x1043-0x15AD)"},
{0x10DE, 0x1140, 0x1043, 0x15ED, "GeForce 820M(0x1043-0x15ED)"},
{0x10DE, 0x1140, 0x1043, 0x160D, "GeForce 820M(0x1043-0x160D)"},
{0x10DE, 0x1140, 0x1043, 0x163D, "GeForce 820M(0x1043-0x163D)"},
{0x10DE, 0x1140, 0x1043, 0x166D, "GeForce 820M(0x1043-0x166D)"},
{0x10DE, 0x1140, 0x1043, 0x16CD, "GeForce 820M(0x1043-0x16CD)"},
{0x10DE, 0x1140, 0x1043, 0x16DD, "GeForce 820M(0x1043-0x16DD)"},
{0x10DE, 0x1140, 0x1043, 0x170D, "GeForce 820M(0x1043-0x170D)"},
{0x10DE, 0x1140, 0x1043, 0x176D, "GeForce 820M(0x1043-0x176D)"},
{0x10DE, 0x1140, 0x1043, 0x178D, "GeForce 820M(0x1043-0x178D)"},
{0x10DE, 0x1140, 0x1043, 0x179D, "GeForce 820M(0x1043-0x179D)"},
{0x10DE, 0x1140, 0x1043, 0x17DD, "GeForce 820M(0x1043-0x17DD)"},
{0x10DE, 0x1140, 0x1043, 0x2132, "GeForce GT 620M(0x1043-0x2132)"},
{0x10DE, 0x1140, 0x1043, 0x2136, "NVS 5200M(0x1043-0x2136)"},
{0x10DE, 0x1140, 0x1043, 0x21BA, "GeForce GT 720M(0x1043-0x21BA)"},
{0x10DE, 0x1140, 0x1043, 0x21FA, "GeForce GT 720M(0x1043-0x21FA)"},
{0x10DE, 0x1140, 0x1043, 0x220A, "GeForce GT 720M(0x1043-0x220A)"},
{0x10DE, 0x1140, 0x1043, 0x221A, "GeForce GT 720M(0x1043-0x221A)"},
{0x10DE, 0x1140, 0x1043, 0x223A, "GeForce GT 710M(0x1043-0x223A)"},
{0x10DE, 0x1140, 0x1043, 0x224A, "GeForce GT 710M(0x1043-0x224A)"},
{0x10DE, 0x1140, 0x1043, 0x227A, "GeForce 820M(0x1043-0x227A)"},
{0x10DE, 0x1140, 0x1043, 0x228A, "GeForce 820M(0x1043-0x228A)"},
{0x10DE, 0x1140, 0x1043, 0x232A, "GeForce 820M(0x1043-0x232A)"},
{0x10DE, 0x1140, 0x1043, 0x233A, "GeForce 820M(0x1043-0x233A)"},
{0x10DE, 0x1140, 0x1043, 0x235A, "GeForce 820M(0x1043-0x235A)"},
{0x10DE, 0x1140, 0x1043, 0x236A, "GeForce 820M(0x1043-0x236A)"},
{0x10DE, 0x1140, 0x1043, 0x238A, "GeForce 820M(0x1043-0x238A)"},
{0x10DE, 0x1140, 0x1043, 0x8595, "GeForce GT 720M(0x1043-0x8595)"},
{0x10DE, 0x1140, 0x1043, 0x85EA, "GeForce GT 720M(0x1043-0x85EA)"},
{0x10DE, 0x1140, 0x1043, 0x85EB, "GeForce 820M(0x1043-0x85EB)"},
{0x10DE, 0x1140, 0x1043, 0x85EC, "GeForce 820M(0x1043-0x85EC)"},
{0x10DE, 0x1140, 0x1043, 0x85EE, "GeForce GT 720M(0x1043-0x85EE)"},
{0x10DE, 0x1140, 0x1043, 0x85F3, "GeForce 820M(0x1043-0x85F3)"},
{0x10DE, 0x1140, 0x1043, 0x860E, "GeForce 820M(0x1043-0x860E)"},
{0x10DE, 0x1140, 0x1043, 0x861A, "GeForce 820M(0x1043-0x861A)"},
{0x10DE, 0x1140, 0x1043, 0x861B, "GeForce 820M(0x1043-0x861B)"},
{0x10DE, 0x1140, 0x1043, 0x8628, "GeForce 820M(0x1043-0x8628)"},
{0x10DE, 0x1140, 0x1043, 0x8643, "GeForce 820M(0x1043-0x8643)"},
{0x10DE, 0x1140, 0x1043, 0x864C, "GeForce 820M(0x1043-0x864C)"},
{0x10DE, 0x1140, 0x1043, 0x8652, "GeForce 820M(0x1043-0x8652)"},
{0x10DE, 0x1140, 0x1043, 0x8660, "GeForce 820M(0x1043-0x8660)"},
{0x10DE, 0x1140, 0x1043, 0x8661, "GeForce 820M(0x1043-0x8661)"},
{0x10DE, 0x1140, 0x105B, 0x0DAC, "GeForce GT 720M(0x105B-0x0DAC)"},
{0x10DE, 0x1140, 0x105B, 0x0DAD, "GeForce GT 720M(0x105B-0x0DAD)"},
{0x10DE, 0x1140, 0x105B, 0x0EF3, "GeForce GT 720M(0x105B-0x0EF3)"},
{0x10DE, 0x1140, 0x1072, 0x152D, "GeForce GT 720M(0x1072-0x152D)"},
{0x10DE, 0x1140, 0x10CF, 0x17F5, "GeForce GT 720M(0x10CF-0x17F5)"},
{0x10DE, 0x1140, 0x1179, 0xFA01, "GeForce 710M(0x1179-0xFA01)"},
{0x10DE, 0x1140, 0x1179, 0xFA02, "GeForce 710M(0x1179-0xFA02)"},
{0x10DE, 0x1140, 0x1179, 0xFA03, "GeForce 710M(0x1179-0xFA03)"},
{0x10DE, 0x1140, 0x1179, 0xFA05, "GeForce 710M(0x1179-0xFA05)"},
{0x10DE, 0x1140, 0x1179, 0xFA11, "GeForce 710M(0x1179-0xFA11)"},
{0x10DE, 0x1140, 0x1179, 0xFA13, "GeForce 710M(0x1179-0xFA13)"},
{0x10DE, 0x1140, 0x1179, 0xFA18, "GeForce 710M(0x1179-0xFA18)"},
{0x10DE, 0x1140, 0x1179, 0xFA19, "GeForce 710M(0x1179-0xFA19)"},
{0x10DE, 0x1140, 0x1179, 0xFA21, "GeForce 710M(0x1179-0xFA21)"},
{0x10DE, 0x1140, 0x1179, 0xFA23, "GeForce 710M(0x1179-0xFA23)"},
{0x10DE, 0x1140, 0x1179, 0xFA2A, "GeForce 710M(0x1179-0xFA2A)"},
{0x10DE, 0x1140, 0x1179, 0xFA32, "GeForce 710M(0x1179-0xFA32)"},
{0x10DE, 0x1140, 0x1179, 0xFA33, "GeForce 710M(0x1179-0xFA33)"},
{0x10DE, 0x1140, 0x1179, 0xFA36, "GeForce 710M(0x1179-0xFA36)"},
{0x10DE, 0x1140, 0x1179, 0xFA38, "GeForce 710M(0x1179-0xFA38)"},
{0x10DE, 0x1140, 0x1179, 0xFA42, "GeForce 710M(0x1179-0xFA42)"},
{0x10DE, 0x1140, 0x1179, 0xFA43, "GeForce 710M(0x1179-0xFA43)"},
{0x10DE, 0x1140, 0x1179, 0xFA45, "GeForce 710M(0x1179-0xFA45)"},
{0x10DE, 0x1140, 0x1179, 0xFA47, "GeForce 710M(0x1179-0xFA47)"},
{0x10DE, 0x1140, 0x1179, 0xFA49, "GeForce 710M(0x1179-0xFA49)"},
{0x10DE, 0x1140, 0x1179, 0xFA58, "GeForce 710M(0x1179-0xFA58)"},
{0x10DE, 0x1140, 0x1179, 0xFA59, "GeForce 710M(0x1179-0xFA59)"},
{0x10DE, 0x1140, 0x1179, 0xFA88, "GeForce 710M(0x1179-0xFA88)"},
{0x10DE, 0x1140, 0x1179, 0xFA89, "GeForce 710M(0x1179-0xFA89)"},
{0x10DE, 0x1140, 0x144D, 0xB092, "GeForce GT 620M(0x144D-0xB092)"},
{0x10DE, 0x1140, 0x144D, 0xC0D5, "GeForce GT 630M(0x144D-0xC0D5)"},
{0x10DE, 0x1140, 0x144D, 0xC0D7, "GeForce GT 620M(0x144D-0xC0D7)"},
{0x10DE, 0x1140, 0x144D, 0xC0E2, "NVS 5200M(0x144D-0xC0E2)"},
{0x10DE, 0x1140, 0x144D, 0xC0E3, "NVS 5200M(0x144D-0xC0E3)"},
{0x10DE, 0x1140, 0x144D, 0xC0E4, "NVS 5200M(0x144D-0xC0E4)"},
{0x10DE, 0x1140, 0x144D, 0xC10D, "GeForce 820M(0x144D-0xC10D)"},
{0x10DE, 0x1140, 0x144D, 0xC652, "GeForce GT 620M on NP300E5C series laptop(0x144D-0xC652)"},
{0x10DE, 0x1140, 0x144D, 0xC709, "GeForce 710M(0x144D-0xC709)"},
{0x10DE, 0x1140, 0x144D, 0xC711, "GeForce 710M(0x144D-0xC711)"},
{0x10DE, 0x1140, 0x144D, 0xC736, "GeForce 710M(0x144D-0xC736)"},
{0x10DE, 0x1140, 0x144D, 0xC737, "GeForce 710M(0x144D-0xC737)"},
{0x10DE, 0x1140, 0x144D, 0xC745, "GeForce 820M(0x144D-0xC745)"},
{0x10DE, 0x1140, 0x144D, 0xC750, "GeForce 820M(0x144D-0xC750)"},
{0x10DE, 0x1140, 0x1462, 0x10B8, "GeForce GT 710M(0x1462-0x10B8)"},
{0x10DE, 0x1140, 0x1462, 0x10E9, "GeForce GT 720M(0x1462-0x10E9)"},
{0x10DE, 0x1140, 0x1462, 0x1116, "GeForce 820M(0x1462-0x1116)"},
{0x10DE, 0x1140, 0x1462, 0xAA33, "GeForce 720M(0x1462-0xAA33)"},
{0x10DE, 0x1140, 0x1462, 0xAAA2, "GeForce GT 720M(0x1462-0xAAA2)"},
{0x10DE, 0x1140, 0x1462, 0xAAA3, "GeForce 820M(0x1462-0xAAA3)"},
{0x10DE, 0x1140, 0x1462, 0xACB2, "GeForce GT 720M(0x1462-0xACB2)"},
{0x10DE, 0x1140, 0x1462, 0xACC1, "GeForce GT 720M(0x1462-0xACC1)"},
{0x10DE, 0x1140, 0x1462, 0xAE61, "GeForce 720M(0x1462-0xAE61)"},
{0x10DE, 0x1140, 0x1462, 0xAE65, "GeForce GT 720M(0x1462-0xAE65)"},
{0x10DE, 0x1140, 0x1462, 0xAE6A, "GeForce 820M(0x1462-0xAE6A)"},
{0x10DE, 0x1140, 0x1462, 0xAE71, "GeForce GT 720M(0x1462-0xAE71)"},
{0x10DE, 0x1140, 0x14C0, 0x0083, "GeForce 820M(0x14C0-0x0083)"},
{0x10DE, 0x1140, 0x152D, 0x0926, "GeForce 620M(0x152D-0x0926)"},
{0x10DE, 0x1140, 0x152D, 0x0982, "GeForce GT 630M(0x152D-0x0982)"},
{0x10DE, 0x1140, 0x152D, 0x0983, "GeForce GT 630M(0x152D-0x0983)"},
{0x10DE, 0x1140, 0x152D, 0x1005, "GeForce GT 820M(0x152D-0x1005)"},
{0x10DE, 0x1140, 0x152D, 0x1012, "GeForce 710M(0x152D-0x1012)"},
{0x10DE, 0x1140, 0x152D, 0x1019, "GeForce 820M(0x152D-0x1019)"},
{0x10DE, 0x1140, 0x152D, 0x1030, "GeForce GT 630M(0x152D-0x1030)"},
{0x10DE, 0x1140, 0x152D, 0x1055, "GeForce 710M(0x152D-0x1055)"},
{0x10DE, 0x1140, 0x152D, 0x1067, "GeForce GT 720M(0x152D-0x1067)"},
{0x10DE, 0x1140, 0x152D, 0x1072, "GeForce GT 720M(0x152D-0x1072)"},
{0x10DE, 0x1140, 0x152D, 0x1086, "GeForce 820M(0x152D-0x1086)"},
{0x10DE, 0x1140, 0x152D, 0x1092, "GeForce 820M(0x152D-0x1092)"},
{0x10DE, 0x1140, 0x17AA, 0x2200, "NVS 5200M(0x17AA-0x2200)"},
{0x10DE, 0x1140, 0x17AA, 0x2213, "GeForce GT 720M(0x17AA-0x2213)"},
{0x10DE, 0x1140, 0x17AA, 0x2220, "GeForce GT 720M(0x17AA-0x2220)"},
{0x10DE, 0x1140, 0x17AA, 0x309C, "GeForce GT 720A(0x17AA-0x309C)"},
{0x10DE, 0x1140, 0x17AA, 0x30B4, "GeForce 820A(0x17AA-0x30B4)"},
{0x10DE, 0x1140, 0x17AA, 0x30B7, "GeForce 720A(0x17AA-0x30B7)"},
{0x10DE, 0x1140, 0x17AA, 0x30E4, "GeForce 820A(0x17AA-0x30E4)"},
{0x10DE, 0x1140, 0x17AA, 0x361B, "GeForce 820A(0x17AA-0x361B)"},
{0x10DE, 0x1140, 0x17AA, 0x361C, "GeForce 820A(0x17AA-0x361C)"},
{0x10DE, 0x1140, 0x17AA, 0x361D, "GeForce 820A(0x17AA-0x361D)"},
{0x10DE, 0x1140, 0x17AA, 0x3656, "GeForce GT 620M(0x17AA-0x3656)"},
{0x10DE, 0x1140, 0x17AA, 0x365A, "GeForce 705M(0x17AA-0x365A)"},
{0x10DE, 0x1140, 0x17AA, 0x365E, "GeForce 800M(0x17AA-0x365E)"},
{0x10DE, 0x1140, 0x17AA, 0x3661, "GeForce 820A(0x17AA-0x3661)"},
{0x10DE, 0x1140, 0x17AA, 0x366C, "GeForce 800M(0x17AA-0x366C)"},
{0x10DE, 0x1140, 0x17AA, 0x3685, "GeForce 800M(0x17AA-0x3685)"},
{0x10DE, 0x1140, 0x17AA, 0x3686, "GeForce 800M(0x17AA-0x3686)"},
{0x10DE, 0x1140, 0x17AA, 0x3687, "GeForce 705A(0x17AA-0x3687)"},
{0x10DE, 0x1140, 0x17AA, 0x3696, "GeForce 820A(0x17AA-0x3696)"},
{0x10DE, 0x1140, 0x17AA, 0x369B, "GeForce 820A(0x17AA-0x369B)"},
{0x10DE, 0x1140, 0x17AA, 0x369C, "GeForce 820A(0x17AA-0x369C)"},
{0x10DE, 0x1140, 0x17AA, 0x369D, "GeForce 820A(0x17AA-0x369D)"},
{0x10DE, 0x1140, 0x17AA, 0x369E, "GeForce 820A(0x17AA-0x369E)"},
{0x10DE, 0x1140, 0x17AA, 0x36A9, "GeForce 820A(0x17AA-0x36A9)"},
{0x10DE, 0x1140, 0x17AA, 0x36AF, "GeForce 820A(0x17AA-0x36AF)"},
{0x10DE, 0x1140, 0x17AA, 0x36B0, "GeForce 820A(0x17AA-0x36B0)"},
{0x10DE, 0x1140, 0x17AA, 0x36B6, "GeForce 820A(0x17AA-0x36B6)"},
{0x10DE, 0x1140, 0x17AA, 0x3800, "GeForce GT 720M(0x17AA-0x3800)"},
{0x10DE, 0x1140, 0x17AA, 0x3801, "GeForce GT 720M(0x17AA-0x3801)"},
{0x10DE, 0x1140, 0x17AA, 0x3802, "GeForce GT 720M(0x17AA-0x3802)"},
{0x10DE, 0x1140, 0x17AA, 0x3803, "GeForce GT 720M(0x17AA-0x3803)"},
{0x10DE, 0x1140, 0x17AA, 0x3804, "GeForce GT 720M(0x17AA-0x3804)"},
{0x10DE, 0x1140, 0x17AA, 0x3806, "GeForce GT 720M(0x17AA-0x3806)"},
{0x10DE, 0x1140, 0x17AA, 0x3808, "GeForce GT 720M(0x17AA-0x3808)"},
{0x10DE, 0x1140, 0x17AA, 0x380D, "GeForce 820M(0x17AA-0x380D)"},
{0x10DE, 0x1140, 0x17AA, 0x380E, "GeForce 820M(0x17AA-0x380E)"},
{0x10DE, 0x1140, 0x17AA, 0x380F, "GeForce 820M(0x17AA-0x380F)"},
{0x10DE, 0x1140, 0x17AA, 0x3811, "GeForce 820M(0x17AA-0x3811)"},
{0x10DE, 0x1140, 0x17AA, 0x3812, "GeForce 820M(0x17AA-0x3812)"},
{0x10DE, 0x1140, 0x17AA, 0x3813, "GeForce 820M(0x17AA-0x3813)"},
{0x10DE, 0x1140, 0x17AA, 0x3816, "GeForce 820M(0x17AA-0x3816)"},
{0x10DE, 0x1140, 0x17AA, 0x3818, "GeForce 820M(0x17AA-0x3818)"},
{0x10DE, 0x1140, 0x17AA, 0x381A, "GeForce 820M(0x17AA-0x381A)"},
{0x10DE, 0x1140, 0x17AA, 0x381C, "GeForce 820M(0x17AA-0x381C)"},
{0x10DE, 0x1140, 0x17AA, 0x3901, "GeForce 610M / GT 620M(0x17AA-0x3901)"},
{0x10DE, 0x1140, 0x17AA, 0x3902, "GeForce 710M(0x17AA-0x3902)"},
{0x10DE, 0x1140, 0x17AA, 0x3903, "GeForce 610M/710M(0x17AA-0x3903)"},
{0x10DE, 0x1140, 0x17AA, 0x3904, "GeForce GT 620M/625M(0x17AA-0x3904)"},
{0x10DE, 0x1140, 0x17AA, 0x3905, "GeForce GT 720M(0x17AA-0x3905)"},
{0x10DE, 0x1140, 0x17AA, 0x3907, "GeForce 820M(0x17AA-0x3907)"},
{0x10DE, 0x1140, 0x17AA, 0x3910, "GeForce 720M(0x17AA-0x3910)"},
{0x10DE, 0x1140, 0x17AA, 0x3912, "GeForce 720M(0x17AA-0x3912)"},
{0x10DE, 0x1140, 0x17AA, 0x3913, "GeForce 820M(0x17AA-0x3913)"},
{0x10DE, 0x1140, 0x17AA, 0x3915, "GeForce 820M(0x17AA-0x3915)"},
{0x10DE, 0x1140, 0x17AA, 0x3977, "GeForce GT 720M(0x17AA-0x3977)"},
{0x10DE, 0x1140, 0x17AA, 0x3983, "GeForce 610M(0x17AA-0x3983)"},
{0x10DE, 0x1140, 0x17AA, 0x5001, "GeForce 610M(0x17AA-0x5001)"},
{0x10DE, 0x1140, 0x17AA, 0x5003, "GeForce GT 720M(0x17AA-0x5003)"},
{0x10DE, 0x1140, 0x17AA, 0x5005, "GeForce 705M(0x17AA-0x5005)"},
{0x10DE, 0x1140, 0x17AA, 0x500D, "GeForce GT 620M(0x17AA-0x500D)"},
{0x10DE, 0x1140, 0x17AA, 0x5014, "GeForce 710M(0x17AA-0x5014)"},
{0x10DE, 0x1140, 0x17AA, 0x5017, "GeForce 710M(0x17AA-0x5017)"},
{0x10DE, 0x1140, 0x17AA, 0x5019, "GeForce 710M(0x17AA-0x5019)"},
{0x10DE, 0x1140, 0x17AA, 0x501A, "GeForce 710M(0x17AA-0x501A)"},
{0x10DE, 0x1140, 0x17AA, 0x501F, "GeForce GT 720M(0x17AA-0x501F)"},
{0x10DE, 0x1140, 0x17AA, 0x5025, "GeForce 710M(0x17AA-0x5025)"},
{0x10DE, 0x1140, 0x17AA, 0x5027, "GeForce 710M(0x17AA-0x5027)"},
{0x10DE, 0x1140, 0x17AA, 0x502A, "GeForce 710M(0x17AA-0x502A)"},
{0x10DE, 0x1140, 0x17AA, 0x502B, "GeForce GT 720M(0x17AA-0x502B)"},
{0x10DE, 0x1140, 0x17AA, 0x502D, "GeForce 710M(0x17AA-0x502D)"},
{0x10DE, 0x1140, 0x17AA, 0x502E, "GeForce GT 720M(0x17AA-0x502E)"},
{0x10DE, 0x1140, 0x17AA, 0x502F, "GeForce GT 720M(0x17AA-0x502F)"},
{0x10DE, 0x1140, 0x17AA, 0x5030, "GeForce 705M(0x17AA-0x5030)"},
{0x10DE, 0x1140, 0x17AA, 0x5031, "GeForce 705M(0x17AA-0x5031)"},
{0x10DE, 0x1140, 0x17AA, 0x5032, "GeForce 820M(0x17AA-0x5032)"},
{0x10DE, 0x1140, 0x17AA, 0x5033, "GeForce 820M(0x17AA-0x5033)"},
{0x10DE, 0x1140, 0x17AA, 0x503E, "GeForce 710M(0x17AA-0x503E)"},
{0x10DE, 0x1140, 0x17AA, 0x503F, "GeForce 820M(0x17AA-0x503F)"},
{0x10DE, 0x1140, 0x17AA, 0x5040, "GeForce 820M(0x17AA-0x5040)"},
{0x10DE, 0x1140, 0x1854, 0x0177, "GeForce 710M(0x1854-0x0177)"},
{0x10DE, 0x1140, 0x1854, 0x0180, "GeForce 710M(0x1854-0x0180)"},
{0x10DE, 0x1140, 0x1854, 0x0190, "GeForce GT 720M(0x1854-0x0190)"},
{0x10DE, 0x1140, 0x1854, 0x0192, "GeForce GT 720M(0x1854-0x0192)"},
{0x10DE, 0x1140, 0x1854, 0x0224, "GeForce 820M(0x1854-0x0224)"},
{0x10DE, 0x1140, 0x1B0A, 0x01C0, "GeForce 820M(0x1B0A-0x01C0)"},
{0x10DE, 0x1140, 0x1B0A, 0x20DD, "GeForce GT 620M(0x1B0A-0x20DD)"},
{0x10DE, 0x1140, 0x1B0A, 0x20DF, "GeForce GT 620M(0x1B0A-0x20DF)"},
{0x10DE, 0x1140, 0x1B0A, 0x210E, "GeForce 820M(0x1B0A-0x210E)"},
{0x10DE, 0x1140, 0x1B0A, 0x2202, "GeForce GT 720M(0x1B0A-0x2202)"},
{0x10DE, 0x1140, 0x1B0A, 0x90D7, "GeForce 820M(0x1B0A-0x90D7)"},
{0x10DE, 0x1140, 0x1B0A, 0x90DD, "GeForce 820M(0x1B0A-0x90DD)"},
{0x10DE, 0x1140, 0x1B50, 0x5530, "GeForce 820M(0x1B50-0x5530)"},
{0x10DE, 0x1140, 0x1B6C, 0x5531, "GeForce GT 720M(0x1B6C-0x5531)"},
{0x10DE, 0x1140, 0x1BAB, 0x0106, "GeForce 820M(0x1BAB-0x0106)"},
{0x10DE, 0x1140, 0x1D05, 0x1013, "GeForce 810M(0x1D05-0x1013)"},
{0x10DE, 0x1180, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 680](0x1180)"},
{0x10DE, 0x1180, 0x1043, 0x83F1, "GTX680-DC2-2GD5(0x1043-0x83F1)"},
{0x10DE, 0x1180, 0x3842, 0x3682, "GeForce GTX 680 Mac Edition(0x3842-0x3682)"},
{0x10DE, 0x1182, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 760 Ti](0x1182)"},
{0x10DE, 0x1183, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 660 Ti](0x1183)"},
{0x10DE, 0x1184, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 770](0x1184)"},
{0x10DE, 0x1185, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 660 OEM](0x1185)"},
{0x10DE, 0x1185, 0x10DE, 0x106F, "GK104 [GeForce GTX 760 OEM](0x10DE-0x106F)"},
{0x10DE, 0x1186, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 660 Ti](0x1186)"},
{0x10DE, 0x1187, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 760](0x1187)"},
{0x10DE, 0x1188, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 690](0x1188)"},
{0x10DE, 0x1189, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 670](0x1189)"},
{0x10DE, 0x1189, 0x10DE, 0x1074, "GK104 [GeForce GTX 760 Ti OEM](0x10DE-0x1074)"},
{0x10DE, 0x118A, 0xFFFF, 0xFFFF, "GK104GL [GRID K520](0x118A)"},
{0x10DE, 0x118B, 0xFFFF, 0xFFFF, "GK104GL [GRID K2 GeForce USM](0x118B)"},
{0x10DE, 0x118C, 0xFFFF, 0xFFFF, "GK104 [GRID K2 NVS USM](0x118C)"},
{0x10DE, 0x118D, 0xFFFF, 0xFFFF, "GK104GL [GRID K200 vGPU](0x118D)"},
{0x10DE, 0x118D, 0x10DE, 0x101D, "GRID K200(0x10DE-0x101D)"},
{0x10DE, 0x118E, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 760 OEM](0x118E)"},
{0x10DE, 0x118F, 0xFFFF, 0xFFFF, "GK104GL [Tesla K10](0x118F)"},
{0x10DE, 0x1191, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 760 Rev. 2](0x1191)"},
{0x10DE, 0x1193, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 760 Ti OEM](0x1193)"},
{0x10DE, 0x1194, 0xFFFF, 0xFFFF, "GK104GL [Tesla K8](0x1194)"},
{0x10DE, 0x1195, 0xFFFF, 0xFFFF, "GK104 [GeForce GTX 660 Rev. 2](0x1195)"},
{0x10DE, 0x1198, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 880M](0x1198)"},
{0x10DE, 0x1199, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 870M](0x1199)"},
{0x10DE, 0x119A, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 860M](0x119A)"},
{0x10DE, 0x119D, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 775M Mac Edition](0x119D)"},
{0x10DE, 0x119E, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 780M Mac Edition](0x119E)"},
{0x10DE, 0x119F, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 780M](0x119F)"},
{0x10DE, 0x11A0, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 680M](0x11A0)"},
{0x10DE, 0x11A1, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 670MX](0x11A1)"},
{0x10DE, 0x11A2, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 675MX Mac Edition](0x11A2)"},
{0x10DE, 0x11A3, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 680MX](0x11A3)"},
{0x10DE, 0x11A3, 0x106B, 0x010D, "iMac 13,2(0x106B-0x010D)"},
{0x10DE, 0x11A4, 0xFFFF, 0xFFFF, "GK104 [GK104-ESA](0x11A4)"},
{0x10DE, 0x11A5, 0xFFFF, 0xFFFF, "GK104 [GK104-ESA](0x11A5)"},
{0x10DE, 0x11A7, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 675MX](0x11A7)"},
{0x10DE, 0x11A8, 0xFFFF, 0xFFFF, "GK104GLM [Quadro K5100M](0x11A8)"},
{0x10DE, 0x11A9, 0xFFFF, 0xFFFF, "GK104M [GeForce GTX 870M](0x11A9)"},
{0x10DE, 0x11AA, 0xFFFF, 0xFFFF, "GK104 [GK104-INT](0x11AA)"},
{0x10DE, 0x11AC, 0xFFFF, 0xFFFF, "GK104 [GK104-CS](0x11AC)"},
{0x10DE, 0x11AF, 0xFFFF, 0xFFFF, "GK104GLM [GRID IceCube](0x11AF)"},
{0x10DE, 0x11B0, 0xFFFF, 0xFFFF, "GK104GL [GRID K240Q / K260Q vGPU](0x11B0)"},
{0x10DE, 0x11B0, 0x10DE, 0x101A, "GRID K240Q(0x10DE-0x101A)"},
{0x10DE, 0x11B0, 0x10DE, 0x101B, "GRID K260Q(0x10DE-0x101B)"},
{0x10DE, 0x11B1, 0xFFFF, 0xFFFF, "GK104GL [GRID K2 Tesla USM](0x11B1)"},
{0x10DE, 0x11B4, 0xFFFF, 0xFFFF, "GK104GL [Quadro K4200](0x11B4)"},
{0x10DE, 0x11B6, 0xFFFF, 0xFFFF, "GK104GLM [Quadro K3100M](0x11B6)"},
{0x10DE, 0x11B7, 0xFFFF, 0xFFFF, "GK104GLM [Quadro K4100M](0x11B7)"},
{0x10DE, 0x11B8, 0xFFFF, 0xFFFF, "GK104GLM [Quadro K5100M](0x11B8)"},
{0x10DE, 0x11B9, 0xFFFF, 0xFFFF, "GK104GLM(0x11B9)"},
{0x10DE, 0x11BA, 0xFFFF, 0xFFFF, "GK104GL [Quadro K5000](0x11BA)"},
{0x10DE, 0x11BB, 0xFFFF, 0xFFFF, "GK104GL [Quadro 4100](0x11BB)"},
{0x10DE, 0x11BC, 0xFFFF, 0xFFFF, "GK104GLM [Quadro K5000M](0x11BC)"},
{0x10DE, 0x11BD, 0xFFFF, 0xFFFF, "GK104GLM [Quadro K4000M](0x11BD)"},
{0x10DE, 0x11BE, 0xFFFF, 0xFFFF, "GK104GLM [Quadro K3000M](0x11BE)"},
{0x10DE, 0x11BF, 0xFFFF, 0xFFFF, "GK104GL [GRID K2](0x11BF)"},
{0x10DE, 0x11C0, 0xFFFF, 0xFFFF, "GK106 [GeForce GTX 660](0x11C0)"},
{0x10DE, 0x11C1, 0xFFFF, 0xFFFF, "GK106 [D14P2-30](0x11C1)"},
{0x10DE, 0x11C2, 0xFFFF, 0xFFFF, "GK106 [GeForce GTX 650 Ti Boost](0x11C2)"},
{0x10DE, 0x11C2, 0x1043, 0x845B, "GeForce GTX 650 Ti Boost DirectCU II OC(0x1043-0x845B)"},
{0x10DE, 0x11C2, 0x1462, 0x2874, "GeForce GTX 650 Ti Boost TwinFrozr II OC(0x1462-0x2874)"},
{0x10DE, 0x11C2, 0x1569, 0x11C2, "GeForce GTX 650 Ti Boost OC(0x1569-0x11C2)"},
{0x10DE, 0x11C2, 0x19DA, 0x1281, "GeForce GTX 650 Ti Boost OC(0x19DA-0x1281)"},
{0x10DE, 0x11C2, 0x3842, 0x3657, "GeForce GTX 650 Ti Boost(0x3842-0x3657)"},
{0x10DE, 0x11C2, 0x3842, 0x3658, "GeForce GTX 650 Ti Boost Superclocked(0x3842-0x3658)"},
{0x10DE, 0x11C3, 0xFFFF, 0xFFFF, "GK106 [GeForce GTX 650 Ti OEM](0x11C3)"},
{0x10DE, 0x11C3, 0x10DE, 0x1030, "GeForce GTX 650 Ti OEM(0x10DE-0x1030)"},
{0x10DE, 0x11C4, 0xFFFF, 0xFFFF, "GK106 [GeForce GTX 645 OEM](0x11C4)"},
{0x10DE, 0x11C5, 0xFFFF, 0xFFFF, "GK106 [GeForce GT 740](0x11C5)"},
{0x10DE, 0x11C6, 0xFFFF, 0xFFFF, "GK106 [GeForce GTX 650 Ti](0x11C6)"},
{0x10DE, 0x11C7, 0xFFFF, 0xFFFF, "GK106 [GeForce GTX 750 Ti](0x11C7)"},
{0x10DE, 0x11C8, 0xFFFF, 0xFFFF, "GK106 [GeForce GTX 650 OEM](0x11C8)"},
{0x10DE, 0x11CB, 0xFFFF, 0xFFFF, "GK106 [GeForce GT 740](0x11CB)"},
{0x10DE, 0x11D0, 0xFFFF, 0xFFFF, "GK106 [GK106-INT353](0x11D0)"},
{0x10DE, 0x11D1, 0xFFFF, 0xFFFF, "GK106 [GK106-INT343](0x11D1)"},
{0x10DE, 0x11D2, 0xFFFF, 0xFFFF, "GK106 [GK106-INT232](0x11D2)"},
{0x10DE, 0x11D3, 0xFFFF, 0xFFFF, "GK106 [GK106-ES](0x11D3)"},
{0x10DE, 0x11E0, 0xFFFF, 0xFFFF, "GK106M [GeForce GTX 770M](0x11E0)"},
{0x10DE, 0x11E1, 0xFFFF, 0xFFFF, "GK106M [GeForce GTX 765M](0x11E1)"},
{0x10DE, 0x11E2, 0xFFFF, 0xFFFF, "GK106M [GeForce GTX 765M](0x11E2)"},
{0x10DE, 0x11E3, 0xFFFF, 0xFFFF, "GK106M [GeForce GTX 760M](0x11E3)"},
{0x10DE, 0x11E3, 0x17AA, 0x3683, "GeForce GTX 760A(0x17AA-0x3683)"},
{0x10DE, 0x11E7, 0xFFFF, 0xFFFF, "GK106M(0x11E7)"},
{0x10DE, 0x11FA, 0xFFFF, 0xFFFF, "GK106GL [Quadro K4000](0x11FA)"},
{0x10DE, 0x11FC, 0xFFFF, 0xFFFF, "GK106GLM [Quadro K2100M](0x11FC)"},
{0x10DE, 0x11FF, 0xFFFF, 0xFFFF, "GK106 [NB1Q](0x11FF)"},
{0x10DE, 0x1200, 0xFFFF, 0xFFFF, "GF114 [GeForce GTX 560 Ti](0x1200)"},
{0x10DE, 0x1201, 0xFFFF, 0xFFFF, "GF114 [GeForce GTX 560](0x1201)"},
{0x10DE, 0x1202, 0xFFFF, 0xFFFF, "GF114 [GeForce GTX 560 Ti OEM](0x1202)"},
{0x10DE, 0x1203, 0xFFFF, 0xFFFF, "GF114 [GeForce GTX 460 SE v2](0x1203)"},
{0x10DE, 0x1205, 0xFFFF, 0xFFFF, "GF114 [GeForce GTX 460 v2](0x1205)"},
{0x10DE, 0x1206, 0xFFFF, 0xFFFF, "GF114 [GeForce GTX 555](0x1206)"},
{0x10DE, 0x1207, 0xFFFF, 0xFFFF, "GF114 [GeForce GT 645 OEM](0x1207)"},
{0x10DE, 0x1208, 0xFFFF, 0xFFFF, "GF114 [GeForce GTX 560 SE](0x1208)"},
{0x10DE, 0x1210, 0xFFFF, 0xFFFF, "GF114M [GeForce GTX 570M](0x1210)"},
{0x10DE, 0x1211, 0xFFFF, 0xFFFF, "GF114M [GeForce GTX 580M](0x1211)"},
{0x10DE, 0x1212, 0xFFFF, 0xFFFF, "GF114M [GeForce GTX 675M](0x1212)"},
{0x10DE, 0x1213, 0xFFFF, 0xFFFF, "GF114M [GeForce GTX 670M](0x1213)"},
{0x10DE, 0x1241, 0xFFFF, 0xFFFF, "GF116 [GeForce GT 545 OEM](0x1241)"},
{0x10DE, 0x1243, 0xFFFF, 0xFFFF, "GF116 [GeForce GT 545](0x1243)"},
{0x10DE, 0x1244, 0xFFFF, 0xFFFF, "GF116 [GeForce GTX 550 Ti](0x1244)"},
{0x10DE, 0x1245, 0xFFFF, 0xFFFF, "GF116 [GeForce GTS 450 Rev. 2](0x1245)"},
{0x10DE, 0x1246, 0xFFFF, 0xFFFF, "GF116M [GeForce GT 550M](0x1246)"},
{0x10DE, 0x1247, 0xFFFF, 0xFFFF, "GF116M [GeForce GT 555M/635M](0x1247)"},
{0x10DE, 0x1247, 0x1043, 0x1752, "GeForce GT 555M(0x1043-0x1752)"},
{0x10DE, 0x1247, 0x1043, 0x2050, "GeForce GT 555M(0x1043-0x2050)"},
{0x10DE, 0x1247, 0x1043, 0x2051, "GeForce GT 555M(0x1043-0x2051)"},
{0x10DE, 0x1247, 0x1043, 0x212A, "GeForce GT 635M(0x1043-0x212A)"},
{0x10DE, 0x1247, 0x1043, 0x212B, "GeForce GT 635M(0x1043-0x212B)"},
{0x10DE, 0x1247, 0x1043, 0x212C, "GeForce GT 635M(0x1043-0x212C)"},
{0x10DE, 0x1247, 0x152D, 0x0930, "GeForce GT 635M(0x152D-0x0930)"},
{0x10DE, 0x1248, 0xFFFF, 0xFFFF, "GF116M [GeForce GT 555M/635M](0x1248)"},
{0x10DE, 0x1248, 0x152D, 0x0930, "GeForce GT 635M(0x152D-0x0930)"},
{0x10DE, 0x1248, 0x17C0, 0x10E7, "GeForce GT 555M(0x17C0-0x10E7)"},
{0x10DE, 0x1248, 0x17C0, 0x10E8, "GeForce GT 555M(0x17C0-0x10E8)"},
{0x10DE, 0x1248, 0x17C0, 0x10EA, "GeForce GT 555M(0x17C0-0x10EA)"},
{0x10DE, 0x1248, 0x1854, 0x0890, "GeForce GT 555M(0x1854-0x0890)"},
{0x10DE, 0x1248, 0x1854, 0x0891, "GeForce GT 555M(0x1854-0x0891)"},
{0x10DE, 0x1248, 0x1854, 0x1795, "GeForce GT 555M(0x1854-0x1795)"},
{0x10DE, 0x1248, 0x1854, 0x1796, "GeForce GT 555M(0x1854-0x1796)"},
{0x10DE, 0x1248, 0x1854, 0x3005, "GeForce GT 555M(0x1854-0x3005)"},
{0x10DE, 0x1249, 0xFFFF, 0xFFFF, "GF116 [GeForce GTS 450 Rev. 3](0x1249)"},
{0x10DE, 0x124B, 0xFFFF, 0xFFFF, "GF116 [GeForce GT 640 OEM](0x124B)"},
{0x10DE, 0x124D, 0xFFFF, 0xFFFF, "GF116M [GeForce GT 555M/635M](0x124D)"},
{0x10DE, 0x124D, 0x1028, 0x0491, "GeForce GT 555M(0x1028-0x0491)"},
{0x10DE, 0x124D, 0x1028, 0x0570, "GeForce GT 555M(0x1028-0x0570)"},
{0x10DE, 0x124D, 0x1028, 0x0571, "GeForce GT 555M(0x1028-0x0571)"},
{0x10DE, 0x124D, 0x1462, 0x108D, "GeForce GT 555M(0x1462-0x108D)"},
{0x10DE, 0x124D, 0x1462, 0x10CC, "GeForce GT 635M(0x1462-0x10CC)"},
{0x10DE, 0x1251, 0xFFFF, 0xFFFF, "GF116M [GeForce GT 560M](0x1251)"},
{0x10DE, 0x1280, 0xFFFF, 0xFFFF, "GK208 [GeForce GT 635](0x1280)"},
{0x10DE, 0x1281, 0xFFFF, 0xFFFF, "GK208 [GeForce GT 710](0x1281)"},
{0x10DE, 0x1282, 0xFFFF, 0xFFFF, "GK208 [GeForce GT 640 Rev. 2](0x1282)"},
{0x10DE, 0x1283, 0xFFFF, 0xFFFF, "GK208 [D15M2-10](0x1283)"},
{0x10DE, 0x1284, 0xFFFF, 0xFFFF, "GK208 [GeForce GT 630 Rev. 2](0x1284)"},
{0x10DE, 0x1285, 0xFFFF, 0xFFFF, "GK208 [GK208-100](0x1285)"},
{0x10DE, 0x1286, 0xFFFF, 0xFFFF, "GK208 [GeForce GT 720](0x1286)"},
{0x10DE, 0x1287, 0xFFFF, 0xFFFF, "GK208B [GeForce GT 730](0x1287)"},
{0x10DE, 0x1288, 0xFFFF, 0xFFFF, "GK208B [GeForce GT 720](0x1288)"},
{0x10DE, 0x1289, 0xFFFF, 0xFFFF, "GK208 [GeForce GT 710](0x1289)"},
{0x10DE, 0x128A, 0xFFFF, 0xFFFF, "GK208B(0x128A)"},
{0x10DE, 0x128B, 0xFFFF, 0xFFFF, "GK208B [GeForce GT 710](0x128B)"},
{0x10DE, 0x128B, 0x1043, 0x85F7, "GT710-SL-1GD5(0x1043-0x85F7)"},
{0x10DE, 0x128B, 0x1043, 0x8770, "GT710-4H-SL-2GD5(0x1043-0x8770)"},
{0x10DE, 0x128C, 0xFFFF, 0xFFFF, "GK208B(0x128C)"},
{0x10DE, 0x1290, 0xFFFF, 0xFFFF, "GK208M [GeForce GT 730M](0x1290)"},
{0x10DE, 0x1290, 0x103C, 0x2AFA, "GeForce GT 730A(0x103C-0x2AFA)"},
{0x10DE, 0x1290, 0x103C, 0x2B04, "GeForce GT 730A(0x103C-0x2B04)"},
{0x10DE, 0x1290, 0x1043, 0x13AD, "GeForce GT 730M(0x1043-0x13AD)"},
{0x10DE, 0x1290, 0x1043, 0x13CD, "GeForce GT 730M(0x1043-0x13CD)"},
{0x10DE, 0x1291, 0xFFFF, 0xFFFF, "GK208M [GeForce GT 735M](0x1291)"},
{0x10DE, 0x1292, 0xFFFF, 0xFFFF, "GK208M [GeForce GT 740M](0x1292)"},
{0x10DE, 0x1292, 0x17AA, 0x3675, "GeForce GT 740A(0x17AA-0x3675)"},
{0x10DE, 0x1292, 0x17AA, 0x367C, "GeForce GT 740A(0x17AA-0x367C)"},
{0x10DE, 0x1292, 0x17AA, 0x3684, "GeForce GT 740A(0x17AA-0x3684)"},
{0x10DE, 0x1293, 0xFFFF, 0xFFFF, "GK208M [GeForce GT 730M](0x1293)"},
{0x10DE, 0x1294, 0xFFFF, 0xFFFF, "GK208M [GeForce GT 740M](0x1294)"},
{0x10DE, 0x1295, 0xFFFF, 0xFFFF, "GK208M [GeForce 710M](0x1295)"},
{0x10DE, 0x1295, 0x103C, 0x2B0D, "GeForce 710A(0x103C-0x2B0D)"},
{0x10DE, 0x1295, 0x103C, 0x2B0F, "GeForce 710A(0x103C-0x2B0F)"},
{0x10DE, 0x1295, 0x103C, 0x2B11, "GeForce 710A(0x103C-0x2B11)"},
{0x10DE, 0x1295, 0x103C, 0x2B20, "GeForce 810A(0x103C-0x2B20)"},
{0x10DE, 0x1295, 0x103C, 0x2B21, "GeForce 810A(0x103C-0x2B21)"},
{0x10DE, 0x1295, 0x103C, 0x2B22, "GeForce 810A(0x103C-0x2B22)"},
{0x10DE, 0x1295, 0x17AA, 0x367A, "GeForce 805A(0x17AA-0x367A)"},
{0x10DE, 0x1295, 0x17AA, 0x367C, "GeForce 710A(0x17AA-0x367C)"},
{0x10DE, 0x1296, 0xFFFF, 0xFFFF, "GK208M [GeForce 825M](0x1296)"},
{0x10DE, 0x1298, 0xFFFF, 0xFFFF, "GK208M [GeForce GT 720M](0x1298)"},
{0x10DE, 0x1299, 0xFFFF, 0xFFFF, "GK208BM [GeForce 920M](0x1299)"},
{0x10DE, 0x1299, 0x17AA, 0x30BB, "GeForce 920A(0x17AA-0x30BB)"},
{0x10DE, 0x1299, 0x17AA, 0x30DF, "GeForce 920A(0x17AA-0x30DF)"},
{0x10DE, 0x1299, 0x17AA, 0x36A7, "GeForce 920A(0x17AA-0x36A7)"},
{0x10DE, 0x1299, 0x17AA, 0x36AF, "GeForce 920M(0x17AA-0x36AF)"},
{0x10DE, 0x129A, 0xFFFF, 0xFFFF, "GK208BM [GeForce 910M](0x129A)"},
{0x10DE, 0x12A0, 0xFFFF, 0xFFFF, "GK208(0x12A0)"},
{0x10DE, 0x12AD, 0xFFFF, 0xFFFF, "GK208 [GK208-ES](0x12AD)"},
{0x10DE, 0x12AE, 0xFFFF, 0xFFFF, "GK208 [GK208-CS1-C](0x12AE)"},
{0x10DE, 0x12AF, 0xFFFF, 0xFFFF, "GK208 [GK208-INT](0x12AF)"},
{0x10DE, 0x12B0, 0xFFFF, 0xFFFF, "GK208 [GK208-CS-Q](0x12B0)"},
{0x10DE, 0x12B1, 0xFFFF, 0xFFFF, "GK208 [GK208 INT](0x12B1)"},
{0x10DE, 0x12B9, 0xFFFF, 0xFFFF, "GK208GLM [Quadro K610M](0x12B9)"},
{0x10DE, 0x12BA, 0xFFFF, 0xFFFF, "GK208GLM [Quadro K510M](0x12BA)"},
{0x10DE, 0x130B, 0xFFFF, 0xFFFF, "GK110 [Q12U-1](0x130B)"},
{0x10DE, 0x1340, 0xFFFF, 0xFFFF, "GM108M [GeForce 830M](0x1340)"},
{0x10DE, 0x1340, 0x103C, 0x2B2B, "GeForce 830A(0x103C-0x2B2B)"},
{0x10DE, 0x1341, 0xFFFF, 0xFFFF, "GM108M [GeForce 840M](0x1341)"},
{0x10DE, 0x1341, 0x17AA, 0x3697, "GeForce 840A(0x17AA-0x3697)"},
{0x10DE, 0x1341, 0x17AA, 0x3699, "GeForce 840A(0x17AA-0x3699)"},
{0x10DE, 0x1341, 0x17AA, 0x369C, "GeForce 840A(0x17AA-0x369C)"},
{0x10DE, 0x1344, 0xFFFF, 0xFFFF, "GM108M [GeForce 845M](0x1344)"},
{0x10DE, 0x1346, 0xFFFF, 0xFFFF, "GM108M [GeForce 930M](0x1346)"},
{0x10DE, 0x1347, 0xFFFF, 0xFFFF, "GM108M [GeForce 940M](0x1347)"},
{0x10DE, 0x1348, 0xFFFF, 0xFFFF, "GM108M [GeForce 945M / 945A](0x1348)"},
{0x10DE, 0x1349, 0xFFFF, 0xFFFF, "GM108M [GeForce 930M](0x1349)"},
{0x10DE, 0x134B, 0xFFFF, 0xFFFF, "GM108M [GeForce 940MX](0x134B)"},
{0x10DE, 0x134D, 0xFFFF, 0xFFFF, "GM108M [GeForce 940MX](0x134D)"},
{0x10DE, 0x134D, 0x17AA, 0x2248, "ThinkPad T570(0x17AA-0x2248)"},
{0x10DE, 0x134E, 0xFFFF, 0xFFFF, "GM108M [GeForce 930MX](0x134E)"},
{0x10DE, 0x134F, 0xFFFF, 0xFFFF, "GM108M [GeForce 920MX](0x134F)"},
{0x10DE, 0x137A, 0xFFFF, 0xFFFF, "GM108GLM [Quadro K620M / Quadro M500M](0x137A)"},
{0x10DE, 0x137A, 0x17AA, 0x505A, "Quadro M500M(0x17AA-0x505A)"},
{0x10DE, 0x137B, 0xFFFF, 0xFFFF, "GM108GLM [Quadro M520 Mobile](0x137B)"},
{0x10DE, 0x137D, 0xFFFF, 0xFFFF, "GM108M [GeForce 940A](0x137D)"},
{0x10DE, 0x1380, 0xFFFF, 0xFFFF, "GM107 [GeForce GTX 750 Ti](0x1380)"},
{0x10DE, 0x1381, 0xFFFF, 0xFFFF, "GM107 [GeForce GTX 750](0x1381)"},
{0x10DE, 0x1382, 0xFFFF, 0xFFFF, "GM107 [GeForce GTX 745](0x1382)"},
{0x10DE, 0x1389, 0xFFFF, 0xFFFF, "GM107GL [GRID M30](0x1389)"},
{0x10DE, 0x1390, 0xFFFF, 0xFFFF, "GM107M [GeForce 845M](0x1390)"},
{0x10DE, 0x1391, 0xFFFF, 0xFFFF, "GM107M [GeForce GTX 850M](0x1391)"},
{0x10DE, 0x1391, 0x17AA, 0x3697, "GeForce GTX 850A(0x17AA-0x3697)"},
{0x10DE, 0x1391, 0x17AA, 0xA125, "GeForce GTX 850A(0x17AA-0xA125)"},
{0x10DE, 0x1392, 0xFFFF, 0xFFFF, "GM107M [GeForce GTX 860M](0x1392)"},
{0x10DE, 0x1393, 0xFFFF, 0xFFFF, "GM107M [GeForce 840M](0x1393)"},
{0x10DE, 0x1398, 0xFFFF, 0xFFFF, "GM107M [GeForce 845M](0x1398)"},
{0x10DE, 0x1399, 0xFFFF, 0xFFFF, "GM107M [GeForce 945M](0x1399)"},
{0x10DE, 0x139A, 0xFFFF, 0xFFFF, "GM107M [GeForce GTX 950M](0x139A)"},
{0x10DE, 0x139A, 0x17AA, 0x362C, "GeForce GTX 950A(0x17AA-0x362C)"},
{0x10DE, 0x139A, 0x17AA, 0x362F, "GeForce GTX 950A(0x17AA-0x362F)"},
{0x10DE, 0x139A, 0x17AA, 0x363F, "GeForce GTX 950A(0x17AA-0x363F)"},
{0x10DE, 0x139A, 0x17AA, 0x3640, "GeForce GTX 950A(0x17AA-0x3640)"},
{0x10DE, 0x139A, 0x17AA, 0x3647, "GeForce GTX 950A(0x17AA-0x3647)"},
{0x10DE, 0x139A, 0x17AA, 0x36B9, "GeForce GTX 950A(0x17AA-0x36B9)"},
{0x10DE, 0x139B, 0xFFFF, 0xFFFF, "GM107M [GeForce GTX 960M](0x139B)"},
{0x10DE, 0x139B, 0x1028, 0x06E4, "XPS 15 9550(0x1028-0x06E4)"},
{0x10DE, 0x139B, 0x103C, 0x2B4C, "GeForce GTX 960A(0x103C-0x2B4C)"},
{0x10DE, 0x139C, 0xFFFF, 0xFFFF, "GM107M [GeForce 940M](0x139C)"},
{0x10DE, 0x139D, 0xFFFF, 0xFFFF, "GM107M [GeForce GTX 750 Ti](0x139D)"},
{0x10DE, 0x13AD, 0xFFFF, 0xFFFF, "GM204 [GM107 INT52](0x13AD)"},
{0x10DE, 0x13AE, 0xFFFF, 0xFFFF, "GM204 [GM107 CS1](0x13AE)"},
{0x10DE, 0x13B0, 0xFFFF, 0xFFFF, "GM107GLM [Quadro M2000M](0x13B0)"},
{0x10DE, 0x13B1, 0xFFFF, 0xFFFF, "GM107GLM [Quadro M1000M](0x13B1)"},
{0x10DE, 0x13B2, 0xFFFF, 0xFFFF, "GM107GLM [Quadro M600M](0x13B2)"},
{0x10DE, 0x13B3, 0xFFFF, 0xFFFF, "GM107GLM [Quadro K2200M](0x13B3)"},
{0x10DE, 0x13B4, 0xFFFF, 0xFFFF, "GM107GLM [Quadro M620 Mobile](0x13B4)"},
{0x10DE, 0x13B6, 0xFFFF, 0xFFFF, "GM107GLM [Quadro M1200 Mobile](0x13B6)"},
{0x10DE, 0x13B9, 0xFFFF, 0xFFFF, "GM107GL [NVS 810](0x13B9)"},
{0x10DE, 0x13BA, 0xFFFF, 0xFFFF, "GM107GL [Quadro K2200](0x13BA)"},
{0x10DE, 0x13BB, 0xFFFF, 0xFFFF, "GM107GL [Quadro K620](0x13BB)"},
{0x10DE, 0x13BC, 0xFFFF, 0xFFFF, "GM107GL [Quadro K1200](0x13BC)"},
{0x10DE, 0x13BD, 0xFFFF, 0xFFFF, "GM107GL [Tesla M10](0x13BD)"},
{0x10DE, 0x13BD, 0x10DE, 0x110A, "GRID M40(0x10DE-0x110A)"},
{0x10DE, 0x13BD, 0x10DE, 0x1160, "Tesla M10(0x10DE-0x1160)"},
{0x10DE, 0x13BD, 0x10DE, 0x11D2, "GRID M10-8Q(0x10DE-0x11D2)"},
{0x10DE, 0x13BE, 0xFFFF, 0xFFFF, "GM204 [GM107 CS1](0x13BE)"},
{0x10DE, 0x13BF, 0xFFFF, 0xFFFF, "GM204 [GM107 INT52](0x13BF)"},
{0x10DE, 0x13C0, 0xFFFF, 0xFFFF, "GM204 [GeForce GTX 980](0x13C0)"},
{0x10DE, 0x13C0, 0x1043, 0x8504, "GTX980-4GD5(0x1043-0x8504)"},
{0x10DE, 0x13C1, 0xFFFF, 0xFFFF, "GM204(0x13C1)"},
{0x10DE, 0x13C2, 0xFFFF, 0xFFFF, "GM204 [GeForce GTX 970](0x13C2)"},
{0x10DE, 0x13C3, 0xFFFF, 0xFFFF, "GM204(0x13C3)"},
{0x10DE, 0x13C4, 0xFFFF, 0xFFFF, "GM204 [D17U-20](0x13C4)"},
{0x10DE, 0x13D7, 0xFFFF, 0xFFFF, "GM204M [GeForce GTX 980M](0x13D7)"},
{0x10DE, 0x13D8, 0xFFFF, 0xFFFF, "GM204M [GeForce GTX 960 OEM / 970M](0x13D8)"},
{0x10DE, 0x13D9, 0xFFFF, 0xFFFF, "GM204M [GeForce GTX 965M](0x13D9)"},
{0x10DE, 0x13DA, 0xFFFF, 0xFFFF, "GM204M [GeForce GTX 980 Mobile](0x13DA)"},
{0x10DE, 0x13E4, 0xFFFF, 0xFFFF, "GM204 [Graphics Device ES-A](0x13E4)"},
{0x10DE, 0x13E7, 0xFFFF, 0xFFFF, "GM204GL [GeForce GTX 980 Engineering Sample](0x13E7)"},
{0x10DE, 0x13F0, 0xFFFF, 0xFFFF, "GM204GL [Quadro M5000](0x13F0)"},
{0x10DE, 0x13F1, 0xFFFF, 0xFFFF, "GM204GL [Quadro M4000](0x13F1)"},
{0x10DE, 0x13F2, 0xFFFF, 0xFFFF, "GM204GL [Tesla M60](0x13F2)"},
{0x10DE, 0x13F2, 0x10DE, 0x114D, "GRID M60-1Q(0x10DE-0x114D)"},
{0x10DE, 0x13F2, 0x10DE, 0x114E, "GRID M60-2Q(0x10DE-0x114E)"},
{0x10DE, 0x13F2, 0x10DE, 0x1150, "GRID M60-8Q(0x10DE-0x1150)"},
{0x10DE, 0x13F2, 0x10DE, 0x11B0, "GRID M60-4A(0x10DE-0x11B0)"},
{0x10DE, 0x13F3, 0xFFFF, 0xFFFF, "GM204GL [Tesla M6](0x13F3)"},
{0x10DE, 0x13F3, 0x10DE, 0x1184, "GRID M6-8Q(0x10DE-0x1184)"},
{0x10DE, 0x13F8, 0xFFFF, 0xFFFF, "GM204GLM [Quadro M5000M / M5000 SE](0x13F8)"},
{0x10DE, 0x13F9, 0xFFFF, 0xFFFF, "GM204GLM [Quadro M4000M](0x13F9)"},
{0x10DE, 0x13FA, 0xFFFF, 0xFFFF, "GM204GLM [Quadro M3000M](0x13FA)"},
{0x10DE, 0x13FA, 0x10DE, 0x11C9, "Quadro M3000 SE(0x10DE-0x11C9)"},
{0x10DE, 0x13FB, 0xFFFF, 0xFFFF, "GM204GLM [Quadro M5500](0x13FB)"},
{0x10DE, 0x1401, 0xFFFF, 0xFFFF, "GM206 [GeForce GTX 960](0x1401)"},
{0x10DE, 0x1402, 0xFFFF, 0xFFFF, "GM206 [GeForce GTX 950](0x1402)"},
{0x10DE, 0x1404, 0xFFFF, 0xFFFF, "GM206 [GeForce GTX 960 FAKE](0x1404)"},
{0x10DE, 0x1406, 0xFFFF, 0xFFFF, "GM206 [GeForce GTX 960 OEM](0x1406)"},
{0x10DE, 0x1407, 0xFFFF, 0xFFFF, "GM206 [GeForce GTX 750 v2](0x1407)"},
{0x10DE, 0x1427, 0xFFFF, 0xFFFF, "GM206M [GeForce GTX 965M](0x1427)"},
{0x10DE, 0x1427, 0x103C, 0x825B, "OMEN-17-w001nv(0x103C-0x825B)"},
{0x10DE, 0x1430, 0xFFFF, 0xFFFF, "GM206GL [Quadro M2000](0x1430)"},
{0x10DE, 0x1431, 0xFFFF, 0xFFFF, "GM206GL [Tesla M4](0x1431)"},
{0x10DE, 0x1436, 0xFFFF, 0xFFFF, "GM206GLM [Quadro M2200 Mobile](0x1436)"},
{0x10DE, 0x15C2, 0xFFFF, 0xFFFF, "GP100 [CMP 100-100](0x15C2)"},
{0x10DE, 0x15F0, 0xFFFF, 0xFFFF, "GP100GL [Quadro GP100](0x15F0)"},
{0x10DE, 0x15F1, 0xFFFF, 0xFFFF, "GP100GL(0x15F1)"},
{0x10DE, 0x15F7, 0xFFFF, 0xFFFF, "GP100GL [Tesla P100 PCIe 12GB](0x15F7)"},
{0x10DE, 0x15F8, 0xFFFF, 0xFFFF, "GP100GL [Tesla P100 PCIe 16GB](0x15F8)"},
{0x10DE, 0x15F9, 0xFFFF, 0xFFFF, "GP100GL [Tesla P100 SXM2 16GB](0x15F9)"},
{0x10DE, 0x15FA, 0xFFFF, 0xFFFF, "GP100GL [DGX Station / PH402 SKU 200](0x15FA)"},
{0x10DE, 0x15FB, 0xFFFF, 0xFFFF, "GP100GL [GP100 SKU 200](0x15FB)"},
{0x10DE, 0x15FC, 0xFFFF, 0xFFFF, "GP100GL [Tesla P100-DGXS-16GB](0x15FC)"},
{0x10DE, 0x15FF, 0xFFFF, 0xFFFF, "GP100GL [GP100 SKU 15ff](0x15FF)"},
{0x10DE, 0x1617, 0xFFFF, 0xFFFF, "GM204M [GeForce GTX 980M](0x1617)"},
{0x10DE, 0x1618, 0xFFFF, 0xFFFF, "GM204M [GeForce GTX 970M](0x1618)"},
{0x10DE, 0x1619, 0xFFFF, 0xFFFF, "GM204M [GeForce GTX 965M](0x1619)"},
{0x10DE, 0x161A, 0xFFFF, 0xFFFF, "GM204M [GeForce GTX 980 Mobile](0x161A)"},
{0x10DE, 0x1667, 0xFFFF, 0xFFFF, "GM204M [GeForce GTX 965M](0x1667)"},
{0x10DE, 0x1725, 0xFFFF, 0xFFFF, "GP100(0x1725)"},
{0x10DE, 0x172E, 0xFFFF, 0xFFFF, "GP100(0x172E)"},
{0x10DE, 0x172F, 0xFFFF, 0xFFFF, "GP100(0x172F)"},
{0x10DE, 0x174D, 0xFFFF, 0xFFFF, "GM108M [GeForce MX130](0x174D)"},
{0x10DE, 0x174E, 0xFFFF, 0xFFFF, "GM108M [GeForce MX110](0x174E)"},
{0x10DE, 0x1789, 0xFFFF, 0xFFFF, "GM107GL [GRID M3-3020](0x1789)"},
{0x10DE, 0x179C, 0xFFFF, 0xFFFF, "GM107 [GeForce 940MX](0x179C)"},
{0x10DE, 0x179C, 0x1025, 0x1094, "Acer Aspire E5-575G(0x1025-0x1094)"},
{0x10DE, 0x17C2, 0xFFFF, 0xFFFF, "GM200 [GeForce GTX TITAN X](0x17C2)"},
{0x10DE, 0x17C8, 0xFFFF, 0xFFFF, "GM200 [GeForce GTX 980 Ti](0x17C8)"},
{0x10DE, 0x17F0, 0xFFFF, 0xFFFF, "GM200GL [Quadro M6000](0x17F0)"},
{0x10DE, 0x17F0, 0x10DE, 0x1141, "VCA 6000(0x10DE-0x1141)"},
{0x10DE, 0x17F1, 0xFFFF, 0xFFFF, "GM200GL [Quadro M6000 24GB](0x17F1)"},
{0x10DE, 0x17FD, 0xFFFF, 0xFFFF, "GM200GL [Tesla M40](0x17FD)"},
{0x10DE, 0x1AD0, 0xFFFF, 0xFFFF, "Tegra PCIe x8 Endpoint(0x1AD0)"},
{0x10DE, 0x1AD1, 0xFFFF, 0xFFFF, "Tegra PCIe x4/x8 Endpoint/Root Complex(0x1AD1)"},
{0x10DE, 0x1AD2, 0xFFFF, 0xFFFF, "Tegra PCIe x1 Root Complex(0x1AD2)"},
{0x10DE, 0x1AD3, 0xFFFF, 0xFFFF, "Xavier SATA Controller(0x1AD3)"},
{0x10DE, 0x1AD6, 0xFFFF, 0xFFFF, "TU102 USB 3.1 Host Controller(0x1AD6)"},
{0x10DE, 0x1AD7, 0xFFFF, 0xFFFF, "TU102 USB Type-C UCSI Controller(0x1AD7)"},
{0x10DE, 0x1AD8, 0xFFFF, 0xFFFF, "TU104 USB 3.1 Host Controller(0x1AD8)"},
{0x10DE, 0x1AD9, 0xFFFF, 0xFFFF, "TU104 USB Type-C UCSI Controller(0x1AD9)"},
{0x10DE, 0x1ADA, 0xFFFF, 0xFFFF, "TU106 USB 3.1 Host Controller(0x1ADA)"},
{0x10DE, 0x1ADA, 0x1043, 0x8673, "TURBO-RTX2070-8G(0x1043-0x8673)"},
{0x10DE, 0x1ADB, 0xFFFF, 0xFFFF, "TU106 USB Type-C UCSI Controller(0x1ADB)"},
{0x10DE, 0x1ADB, 0x1043, 0x8673, "TURBO-RTX2070-8G(0x1043-0x8673)"},
{0x10DE, 0x1AEB, 0xFFFF, 0xFFFF, "TU116 High Definition Audio Controller(0x1AEB)"},
{0x10DE, 0x1AEC, 0xFFFF, 0xFFFF, "TU116 USB 3.1 Host Controller(0x1AEC)"},
{0x10DE, 0x1AED, 0xFFFF, 0xFFFF, "TU116 USB Type-C UCSI Controller(0x1AED)"},
{0x10DE, 0x1AEF, 0xFFFF, 0xFFFF, "GA102 High Definition Audio Controller(0x1AEF)"},
{0x10DE, 0x1AF1, 0xFFFF, 0xFFFF, "GA100 [A100 NVSwitch](0x1AF1)"},
{0x10DE, 0x1B00, 0xFFFF, 0xFFFF, "GP102 [TITAN X Pascal](0x1B00)"},
{0x10DE, 0x1B01, 0xFFFF, 0xFFFF, "GP102 [GeForce GTX 1080 Ti 10GB](0x1B01)"},
{0x10DE, 0x1B02, 0xFFFF, 0xFFFF, "GP102 [TITAN Xp](0x1B02)"},
{0x10DE, 0x1B04, 0xFFFF, 0xFFFF, "GP102(0x1B04)"},
{0x10DE, 0x1B06, 0xFFFF, 0xFFFF, "GP102 [GeForce GTX 1080 Ti](0x1B06)"},
{0x10DE, 0x1B07, 0xFFFF, 0xFFFF, "GP102 [P102-100](0x1B07)"},
{0x10DE, 0x1B30, 0xFFFF, 0xFFFF, "GP102GL [Quadro P6000](0x1B30)"},
{0x10DE, 0x1B38, 0xFFFF, 0xFFFF, "GP102GL [Tesla P40](0x1B38)"},
{0x10DE, 0x1B39, 0xFFFF, 0xFFFF, "GP102GL [Tesla P10](0x1B39)"},
{0x10DE, 0x1B70, 0xFFFF, 0xFFFF, "GP102GL(0x1B70)"},
{0x10DE, 0x1B78, 0xFFFF, 0xFFFF, "GP102GL(0x1B78)"},
{0x10DE, 0x1B80, 0xFFFF, 0xFFFF, "GP104 [GeForce GTX 1080](0x1B80)"},
{0x10DE, 0x1B81, 0xFFFF, 0xFFFF, "GP104 [GeForce GTX 1070](0x1B81)"},
{0x10DE, 0x1B82, 0xFFFF, 0xFFFF, "GP104 [GeForce GTX 1070 Ti](0x1B82)"},
{0x10DE, 0x1B83, 0xFFFF, 0xFFFF, "GP104 [GeForce GTX 1060 6GB](0x1B83)"},
{0x10DE, 0x1B84, 0xFFFF, 0xFFFF, "GP104 [GeForce GTX 1060 3GB](0x1B84)"},
{0x10DE, 0x1B87, 0xFFFF, 0xFFFF, "GP104 [P104-100](0x1B87)"},
{0x10DE, 0x1BA0, 0xFFFF, 0xFFFF, "GP104M [GeForce GTX 1080 Mobile](0x1BA0)"},
{0x10DE, 0x1BA1, 0xFFFF, 0xFFFF, "GP104M [GeForce GTX 1070 Mobile](0x1BA1)"},
{0x10DE, 0x1BA1, 0x1458, 0x1651, "GeForce GTX 1070 Max-Q(0x1458-0x1651)"},
{0x10DE, 0x1BA1, 0x1462, 0x11E8, "GeForce GTX 1070 Max-Q(0x1462-0x11E8)"},
{0x10DE, 0x1BA1, 0x1462, 0x11E9, "GeForce GTX 1070 Max-Q(0x1462-0x11E9)"},
{0x10DE, 0x1BA1, 0x1558, 0x9501, "GeForce GTX 1070 Max-Q(0x1558-0x9501)"},
{0x10DE, 0x1BA2, 0xFFFF, 0xFFFF, "GP104M [GeForce GTX 1070 Mobile](0x1BA2)"},
{0x10DE, 0x1BA9, 0xFFFF, 0xFFFF, "GP104M(0x1BA9)"},
{0x10DE, 0x1BAA, 0xFFFF, 0xFFFF, "GP104M(0x1BAA)"},
{0x10DE, 0x1BAD, 0xFFFF, 0xFFFF, "GP104 [GeForce GTX 1070 Engineering Sample](0x1BAD)"},
{0x10DE, 0x1BB0, 0xFFFF, 0xFFFF, "GP104GL [Quadro P5000](0x1BB0)"},
{0x10DE, 0x1BB1, 0xFFFF, 0xFFFF, "GP104GL [Quadro P4000](0x1BB1)"},
{0x10DE, 0x1BB3, 0xFFFF, 0xFFFF, "GP104GL [Tesla P4](0x1BB3)"},
{0x10DE, 0x1BB4, 0xFFFF, 0xFFFF, "GP104GL [Tesla P6](0x1BB4)"},
{0x10DE, 0x1BB5, 0xFFFF, 0xFFFF, "GP104GLM [Quadro P5200 Mobile](0x1BB5)"},
{0x10DE, 0x1BB5, 0x103C, 0x842F, "P5200 [Zbook 17 G5 mobile workstation](0x103C-0x842F)"},
{0x10DE, 0x1BB6, 0xFFFF, 0xFFFF, "GP104GLM [Quadro P5000 Mobile](0x1BB6)"},
{0x10DE, 0x1BB7, 0xFFFF, 0xFFFF, "GP104GLM [Quadro P4000 Mobile](0x1BB7)"},
{0x10DE, 0x1BB7, 0x1462, 0x11E9, "Quadro P4000 Max-Q(0x1462-0x11E9)"},
{0x10DE, 0x1BB8, 0xFFFF, 0xFFFF, "GP104GLM [Quadro P3000 Mobile](0x1BB8)"},
{0x10DE, 0x1BB9, 0xFFFF, 0xFFFF, "GP104GLM [Quadro P4200 Mobile](0x1BB9)"},
{0x10DE, 0x1BB9, 0x103C, 0x842F, "P4200 [Zbook 17 G5 mobile workstation](0x103C-0x842F)"},
{0x10DE, 0x1BBB, 0xFFFF, 0xFFFF, "GP104GLM [Quadro P3200 Mobile](0x1BBB)"},
{0x10DE, 0x1BBB, 0x103C, 0x842F, "P3200 [Zbook 17 G5 moble workstation](0x103C-0x842F)"},
{0x10DE, 0x1BC7, 0xFFFF, 0xFFFF, "GP104 [P104-101](0x1BC7)"},
{0x10DE, 0x1BE0, 0xFFFF, 0xFFFF, "GP104BM [GeForce GTX 1080 Mobile](0x1BE0)"},
{0x10DE, 0x1BE0, 0x1028, 0x07C0, "GeForce GTX 1080 Max-Q(0x1028-0x07C0)"},
{0x10DE, 0x1BE0, 0x1458, 0x355B, "GeForce GTX 1080 Max-Q(0x1458-0x355B)"},
{0x10DE, 0x1BE1, 0xFFFF, 0xFFFF, "GP104BM [GeForce GTX 1070 Mobile](0x1BE1)"},
{0x10DE, 0x1C00, 0xFFFF, 0xFFFF, "GP106(0x1C00)"},
{0x10DE, 0x1C01, 0xFFFF, 0xFFFF, "GP106(0x1C01)"},
{0x10DE, 0x1C02, 0xFFFF, 0xFFFF, "GP106 [GeForce GTX 1060 3GB](0x1C02)"},
{0x10DE, 0x1C03, 0xFFFF, 0xFFFF, "GP106 [GeForce GTX 1060 6GB](0x1C03)"},
{0x10DE, 0x1C03, 0x1043, 0x85B6, "DUAL-GTX1060-O6G [GeForce GTX 1060 6GB Dual](0x1043-0x85B6)"},
{0x10DE, 0x1C04, 0xFFFF, 0xFFFF, "GP106 [GeForce GTX 1060 5GB](0x1C04)"},
{0x10DE, 0x1C06, 0xFFFF, 0xFFFF, "GP106 [GeForce GTX 1060 6GB Rev. 2](0x1C06)"},
{0x10DE, 0x1C07, 0xFFFF, 0xFFFF, "GP106 [P106-100](0x1C07)"},
{0x10DE, 0x1C09, 0xFFFF, 0xFFFF, "GP106 [P106-090](0x1C09)"},
{0x10DE, 0x1C20, 0xFFFF, 0xFFFF, "GP106M [GeForce GTX 1060 Mobile](0x1C20)"},
{0x10DE, 0x1C20, 0x17AA, 0x39B9, "GeForce GTX 1060 Max-Q 3GB(0x17AA-0x39B9)"},
{0x10DE, 0x1C21, 0xFFFF, 0xFFFF, "GP106M [GeForce GTX 1050 Ti Mobile](0x1C21)"},
{0x10DE, 0x1C22, 0xFFFF, 0xFFFF, "GP106M [GeForce GTX 1050 Mobile](0x1C22)"},
{0x10DE, 0x1C23, 0xFFFF, 0xFFFF, "GP106M [GeForce GTX 1060 Mobile Rev. 2](0x1C23)"},
{0x10DE, 0x1C23, 0x1414, 0x0020, "GTX 1060 Mobile(0x1414-0x0020)"},
{0x10DE, 0x1C2D, 0xFFFF, 0xFFFF, "GP106M(0x1C2D)"},
{0x10DE, 0x1C30, 0xFFFF, 0xFFFF, "GP106GL [Quadro P2000](0x1C30)"},
{0x10DE, 0x1C31, 0xFFFF, 0xFFFF, "GP106GL [Quadro P2200](0x1C31)"},
{0x10DE, 0x1C35, 0xFFFF, 0xFFFF, "GP106M [Quadro P2000 Mobile / DRIVE PX 2 AutoChauffeur](0x1C35)"},
{0x10DE, 0x1C36, 0xFFFF, 0xFFFF, "GP106 [P106M](0x1C36)"},
{0x10DE, 0x1C60, 0xFFFF, 0xFFFF, "GP106BM [GeForce GTX 1060 Mobile 6GB](0x1C60)"},
{0x10DE, 0x1C60, 0x103C, 0x8390, "GeForce GTX 1060 Max-Q 6GB(0x103C-0x8390)"},
{0x10DE, 0x1C61, 0xFFFF, 0xFFFF, "GP106BM [GeForce GTX 1050 Ti Mobile](0x1C61)"},
{0x10DE, 0x1C62, 0xFFFF, 0xFFFF, "GP106BM [GeForce GTX 1050 Mobile](0x1C62)"},
{0x10DE, 0x1C70, 0xFFFF, 0xFFFF, "GP106GL(0x1C70)"},
{0x10DE, 0x1C81, 0xFFFF, 0xFFFF, "GP107 [GeForce GTX 1050](0x1C81)"},
{0x10DE, 0x1C82, 0xFFFF, 0xFFFF, "GP107 [GeForce GTX 1050 Ti](0x1C82)"},
{0x10DE, 0x1C82, 0x1043, 0x8613, "PH-GTX1050TI-4G(0x1043-0x8613)"},
{0x10DE, 0x1C82, 0x1458, 0x3763, "GV-N105TOC-4GD(0x1458-0x3763)"},
{0x10DE, 0x1C83, 0xFFFF, 0xFFFF, "GP107 [GeForce GTX 1050 3GB](0x1C83)"},
{0x10DE, 0x1C8C, 0xFFFF, 0xFFFF, "GP107M [GeForce GTX 1050 Ti Mobile](0x1C8C)"},
{0x10DE, 0x1C8D, 0xFFFF, 0xFFFF, "GP107M [GeForce GTX 1050 Mobile](0x1C8D)"},
{0x10DE, 0x1C8E, 0xFFFF, 0xFFFF, "GP107M(0x1C8E)"},
{0x10DE, 0x1C8F, 0xFFFF, 0xFFFF, "GP107M [GeForce GTX 1050 Ti Max-Q](0x1C8F)"},
{0x10DE, 0x1C90, 0xFFFF, 0xFFFF, "GP107M [GeForce MX150](0x1C90)"},
{0x10DE, 0x1C91, 0xFFFF, 0xFFFF, "GP107M [GeForce GTX 1050 3 GB Max-Q](0x1C91)"},
{0x10DE, 0x1C92, 0xFFFF, 0xFFFF, "GP107M [GeForce GTX 1050 Mobile](0x1C92)"},
{0x10DE, 0x1C94, 0xFFFF, 0xFFFF, "GP107M [GeForce MX350](0x1C94)"},
{0x10DE, 0x1C96, 0xFFFF, 0xFFFF, "GP107M [GeForce MX350](0x1C96)"},
{0x10DE, 0x1CA7, 0xFFFF, 0xFFFF, "GP107GL(0x1CA7)"},
{0x10DE, 0x1CA8, 0xFFFF, 0xFFFF, "GP107GL(0x1CA8)"},
{0x10DE, 0x1CAA, 0xFFFF, 0xFFFF, "GP107GL(0x1CAA)"},
{0x10DE, 0x1CB1, 0xFFFF, 0xFFFF, "GP107GL [Quadro P1000](0x1CB1)"},
{0x10DE, 0x1CB2, 0xFFFF, 0xFFFF, "GP107GL [Quadro P600](0x1CB2)"},
{0x10DE, 0x1CB3, 0xFFFF, 0xFFFF, "GP107GL [Quadro P400](0x1CB3)"},
{0x10DE, 0x1CB6, 0xFFFF, 0xFFFF, "GP107GL [Quadro P620](0x1CB6)"},
{0x10DE, 0x1CBA, 0xFFFF, 0xFFFF, "GP107GLM [Quadro P2000 Mobile](0x1CBA)"},
{0x10DE, 0x1CBA, 0x103C, 0x842C, "P2000 [Zbook 15 G5 mobile workstation](0x103C-0x842C)"},
{0x10DE, 0x1CBA, 0x103C, 0x842F, "P2000 [Zbook 17 G5 mobile workstation](0x103C-0x842F)"},
{0x10DE, 0x1CBB, 0xFFFF, 0xFFFF, "GP107GLM [Quadro P1000 Mobile](0x1CBB)"},
{0x10DE, 0x1CBB, 0x103C, 0x8429, "P1000 [Zbook Studio G5 mobile workstation](0x103C-0x8429)"},
{0x10DE, 0x1CBB, 0x103C, 0x842C, "P1000 [Zbook 15 G5 mobile workstation](0x103C-0x842C)"},
{0x10DE, 0x1CBB, 0x103C, 0x842F, "P1000 [Zbook 17 G5 mobile workstation](0x103C-0x842F)"},
{0x10DE, 0x1CBB, 0x103C, 0x8451, "P1000 [Zbook Studio x360 G5 mobile workstation](0x103C-0x8451)"},
{0x10DE, 0x1CBC, 0xFFFF, 0xFFFF, "GP107GLM [Quadro P600 Mobile](0x1CBC)"},
{0x10DE, 0x1CBD, 0xFFFF, 0xFFFF, "GP107GLM [Quadro P620](0x1CBD)"},
{0x10DE, 0x1CCC, 0xFFFF, 0xFFFF, "GP107BM [GeForce GTX 1050 Ti Mobile](0x1CCC)"},
{0x10DE, 0x1CCD, 0xFFFF, 0xFFFF, "GP107BM [GeForce GTX 1050 Mobile](0x1CCD)"},
{0x10DE, 0x1CFA, 0xFFFF, 0xFFFF, "GP107GL [Quadro P2000](0x1CFA)"},
{0x10DE, 0x1CFB, 0xFFFF, 0xFFFF, "GP107GL [Quadro P1000](0x1CFB)"},
{0x10DE, 0x1D01, 0xFFFF, 0xFFFF, "GP108 [GeForce GT 1030](0x1D01)"},
{0x10DE, 0x1D02, 0xFFFF, 0xFFFF, "GP108 [GeForce GT 1010](0x1D02)"},
{0x10DE, 0x1D10, 0xFFFF, 0xFFFF, "GP108M [GeForce MX150](0x1D10)"},
{0x10DE, 0x1D10, 0x17AA, 0x225E, "ThinkPad T480(0x17AA-0x225E)"},
{0x10DE, 0x1D11, 0xFFFF, 0xFFFF, "GP108M [GeForce MX230](0x1D11)"},
{0x10DE, 0x1D12, 0xFFFF, 0xFFFF, "GP108M [GeForce MX150](0x1D12)"},
{0x10DE, 0x1D12, 0x1D72, 0x1701, "Mi Notebook Pro [GeForce MX150](0x1D72-0x1701)"},
{0x10DE, 0x1D13, 0xFFFF, 0xFFFF, "GP108M [GeForce MX250](0x1D13)"},
{0x10DE, 0x1D16, 0xFFFF, 0xFFFF, "GP108M [GeForce MX330](0x1D16)"},
{0x10DE, 0x1D33, 0xFFFF, 0xFFFF, "GP108GLM [Quadro P500 Mobile](0x1D33)"},
{0x10DE, 0x1D34, 0xFFFF, 0xFFFF, "GP108GLM [Quadro P520](0x1D34)"},
{0x10DE, 0x1D52, 0xFFFF, 0xFFFF, "GP108BM [GeForce MX250](0x1D52)"},
{0x10DE, 0x1D56, 0xFFFF, 0xFFFF, "GP108BM [GeForce MX330](0x1D56)"},
{0x10DE, 0x1D81, 0xFFFF, 0xFFFF, "GV100 [TITAN V](0x1D81)"},
{0x10DE, 0x1D83, 0xFFFF, 0xFFFF, "GV100 [CMP 100-200](0x1D83)"},
{0x10DE, 0x1D84, 0xFFFF, 0xFFFF, "GV100 [CMP 100-210](0x1D84)"},
{0x10DE, 0x1DB0, 0xFFFF, 0xFFFF, "GV100GL [Tesla GV100 SXM2-16GB SKU 890](0x1DB0)"},
{0x10DE, 0x1DB1, 0xFFFF, 0xFFFF, "GV100GL [Tesla V100 SXM2 16GB](0x1DB1)"},
{0x10DE, 0x1DB2, 0xFFFF, 0xFFFF, "GV100GL [Tesla V100 DGXS 16GB](0x1DB2)"},
{0x10DE, 0x1DB3, 0xFFFF, 0xFFFF, "GV100GL [Tesla V100 FHHL 16GB](0x1DB3)"},
{0x10DE, 0x1DB4, 0xFFFF, 0xFFFF, "GV100GL [Tesla V100 PCIe 16GB](0x1DB4)"},
{0x10DE, 0x1DB5, 0xFFFF, 0xFFFF, "GV100GL [Tesla V100 SXM2 32GB](0x1DB5)"},
{0x10DE, 0x1DB6, 0xFFFF, 0xFFFF, "GV100GL [Tesla V100 PCIe 32GB](0x1DB6)"},
{0x10DE, 0x1DB7, 0xFFFF, 0xFFFF, "GV100GL [Tesla V100 DGXS 32GB](0x1DB7)"},
{0x10DE, 0x1DB8, 0xFFFF, 0xFFFF, "GV100GL [Tesla V100 SXM3 32GB](0x1DB8)"},
{0x10DE, 0x1DB8, 0x10DE, 0x131D, "Tesla V100-SXM3-32GB-H(0x10DE-0x131D)"},
{0x10DE, 0x1DBA, 0xFFFF, 0xFFFF, "GV100GL [Quadro GV100](0x1DBA)"},
{0x10DE, 0x1DBA, 0x10DE, 0x12EB, "TITAN V CEO Edition(0x10DE-0x12EB)"},
{0x10DE, 0x1DBD, 0xFFFF, 0xFFFF, "GV100GL [Tesla GV100 DGX1-V](0x1DBD)"},
{0x10DE, 0x1DBE, 0xFFFF, 0xFFFF, "GV100 Engineering Sample(0x1DBE)"},
{0x10DE, 0x1DC1, 0xFFFF, 0xFFFF, "GV100 [CMP 100-200](0x1DC1)"},
{0x10DE, 0x1DF0, 0xFFFF, 0xFFFF, "GV100GL [Tesla PG500-216](0x1DF0)"},
{0x10DE, 0x1DF2, 0xFFFF, 0xFFFF, "GV100GL [Tesla PG503-216](0x1DF2)"},
{0x10DE, 0x1DF4, 0xFFFF, 0xFFFF, "GV100 [CMP 100-210](0x1DF4)"},
{0x10DE, 0x1DF5, 0xFFFF, 0xFFFF, "GV100GL [Tesla V100 SXM2 16GB](0x1DF5)"},
{0x10DE, 0x1DF6, 0xFFFF, 0xFFFF, "GV100GL [Tesla V100S PCIe 32GB](0x1DF6)"},
{0x10DE, 0x1E02, 0xFFFF, 0xFFFF, "TU102 [TITAN RTX](0x1E02)"},
{0x10DE, 0x1E03, 0xFFFF, 0xFFFF, "TU102 [GeForce RTX 2080 Ti 12GB](0x1E03)"},
{0x10DE, 0x1E04, 0xFFFF, 0xFFFF, "TU102 [GeForce RTX 2080 Ti](0x1E04)"},
{0x10DE, 0x1E07, 0xFFFF, 0xFFFF, "TU102 [GeForce RTX 2080 Ti Rev. A](0x1E07)"},
{0x10DE, 0x1E07, 0x1462, 0x3715, "RTX 2080 Ti GAMING X TRIO(0x1462-0x3715)"},
{0x10DE, 0x1E09, 0xFFFF, 0xFFFF, "TU102 [CMP 50HX](0x1E09)"},
{0x10DE, 0x1E2D, 0xFFFF, 0xFFFF, "TU102 [GeForce RTX 2080 Ti Engineering Sample](0x1E2D)"},
{0x10DE, 0x1E2E, 0xFFFF, 0xFFFF, "TU102 [GeForce RTX 2080 Ti 12GB Engineering Sample](0x1E2E)"},
{0x10DE, 0x1E30, 0xFFFF, 0xFFFF, "TU102GL [Quadro RTX 6000/8000](0x1E30)"},
{0x10DE, 0x1E30, 0x10DE, 0x129E, "Quadro RTX 8000(0x10DE-0x129E)"},
{0x10DE, 0x1E30, 0x10DE, 0x12BA, "Quadro RTX 6000(0x10DE-0x12BA)"},
{0x10DE, 0x1E35, 0xFFFF, 0xFFFF, "TU102GL [Tesla T10](0x1E35)"},
{0x10DE, 0x1E36, 0xFFFF, 0xFFFF, "TU102GL [Quadro RTX 6000](0x1E36)"},
{0x10DE, 0x1E37, 0xFFFF, 0xFFFF, "TU102GL [Tesla T10 16GB / GRID RTX T10-2/T10-4/T10-8](0x1E37)"},
{0x10DE, 0x1E37, 0x10DE, 0x1304, "Tesla T10 16GB(0x10DE-0x1304)"},
{0x10DE, 0x1E37, 0x10DE, 0x1347, "GRID RTX T10-8(0x10DE-0x1347)"},
{0x10DE, 0x1E37, 0x10DE, 0x1348, "GRID RTX T10-4(0x10DE-0x1348)"},
{0x10DE, 0x1E37, 0x10DE, 0x1349, "GRID RTX T10-2(0x10DE-0x1349)"},
{0x10DE, 0x1E37, 0x10DE, 0x1370, "Tesla T10 16GB(0x10DE-0x1370)"},
{0x10DE, 0x1E37, 0x10DE, 0x13A5, "GRID RTX T10-8(0x10DE-0x13A5)"},
{0x10DE, 0x1E38, 0xFFFF, 0xFFFF, "TU102GL [Tesla T40 24GB](0x1E38)"},
{0x10DE, 0x1E3C, 0xFFFF, 0xFFFF, "TU102GL(0x1E3C)"},
{0x10DE, 0x1E3D, 0xFFFF, 0xFFFF, "TU102GL(0x1E3D)"},
{0x10DE, 0x1E3E, 0xFFFF, 0xFFFF, "TU102GL(0x1E3E)"},
{0x10DE, 0x1E78, 0xFFFF, 0xFFFF, "TU102GL [Quadro RTX 6000/8000](0x1E78)"},
{0x10DE, 0x1E78, 0x10DE, 0x13D8, "Quadro RTX 8000(0x10DE-0x13D8)"},
{0x10DE, 0x1E78, 0x10DE, 0x13D9, "Quadro RTX 6000(0x10DE-0x13D9)"},
{0x10DE, 0x1E81, 0xFFFF, 0xFFFF, "TU104 [GeForce RTX 2080 SUPER](0x1E81)"},
{0x10DE, 0x1E82, 0xFFFF, 0xFFFF, "TU104 [GeForce RTX 2080](0x1E82)"},
{0x10DE, 0x1E84, 0xFFFF, 0xFFFF, "TU104 [GeForce RTX 2070 SUPER](0x1E84)"},
{0x10DE, 0x1E87, 0xFFFF, 0xFFFF, "TU104 [GeForce RTX 2080 Rev. A](0x1E87)"},
{0x10DE, 0x1E89, 0xFFFF, 0xFFFF, "TU104 [GeForce RTX 2060](0x1E89)"},
{0x10DE, 0x1E90, 0xFFFF, 0xFFFF, "TU104M [GeForce RTX 2080 Mobile](0x1E90)"},
{0x10DE, 0x1E91, 0xFFFF, 0xFFFF, "TU104M [GeForce RTX 2070 SUPER Mobile / Max-Q](0x1E91)"},
{0x10DE, 0x1E93, 0xFFFF, 0xFFFF, "TU104M [GeForce RTX 2080 SUPER Mobile / Max-Q](0x1E93)"},
{0x10DE, 0x1EAB, 0xFFFF, 0xFFFF, "TU104M(0x1EAB)"},
{0x10DE, 0x1EAE, 0xFFFF, 0xFFFF, "TU104M [GeForce GTX 2080 Engineering Sample](0x1EAE)"},
{0x10DE, 0x1EB0, 0xFFFF, 0xFFFF, "TU104GL [Quadro RTX 5000](0x1EB0)"},
{0x10DE, 0x1EB1, 0xFFFF, 0xFFFF, "TU104GL [Quadro RTX 4000](0x1EB1)"},
{0x10DE, 0x1EB4, 0xFFFF, 0xFFFF, "TU104GL [T4G](0x1EB4)"},
{0x10DE, 0x1EB5, 0xFFFF, 0xFFFF, "TU104GLM [Quadro RTX 5000 Mobile / Max-Q](0x1EB5)"},
{0x10DE, 0x1EB6, 0xFFFF, 0xFFFF, "TU104GLM [Quadro RTX 4000 Mobile / Max-Q](0x1EB6)"},
{0x10DE, 0x1EB8, 0xFFFF, 0xFFFF, "TU104GL [Tesla T4](0x1EB8)"},
{0x10DE, 0x1EB9, 0xFFFF, 0xFFFF, "TU104GL(0x1EB9)"},
{0x10DE, 0x1EBA, 0xFFFF, 0xFFFF, "TU104GL [PG189 SKU600](0x1EBA)"},
{0x10DE, 0x1EBE, 0xFFFF, 0xFFFF, "TU104GL(0x1EBE)"},
{0x10DE, 0x1EC2, 0xFFFF, 0xFFFF, "TU104 [GeForce RTX 2070 SUPER](0x1EC2)"},
{0x10DE, 0x1EC7, 0xFFFF, 0xFFFF, "TU104 [GeForce RTX 2070 SUPER](0x1EC7)"},
{0x10DE, 0x1ED0, 0xFFFF, 0xFFFF, "TU104BM [GeForce RTX 2080 Mobile](0x1ED0)"},
{0x10DE, 0x1ED1, 0xFFFF, 0xFFFF, "TU104BM [GeForce RTX 2070 SUPER Mobile / Max-Q](0x1ED1)"},
{0x10DE, 0x1ED3, 0xFFFF, 0xFFFF, "TU104BM [GeForce RTX 2080 SUPER Mobile / Max-Q](0x1ED3)"},
{0x10DE, 0x1EF5, 0xFFFF, 0xFFFF, "TU104GLM [Quadro RTX 5000 Mobile Refresh](0x1EF5)"},
{0x10DE, 0x1F02, 0xFFFF, 0xFFFF, "TU106 [GeForce RTX 2070](0x1F02)"},
{0x10DE, 0x1F02, 0x1043, 0x8673, "TURBO RTX 2070(0x1043-0x8673)"},
{0x10DE, 0x1F03, 0xFFFF, 0xFFFF, "TU106 [GeForce RTX 2060 12GB](0x1F03)"},
{0x10DE, 0x1F04, 0xFFFF, 0xFFFF, "TU106(0x1F04)"},
{0x10DE, 0x1F06, 0xFFFF, 0xFFFF, "TU106 [GeForce RTX 2060 SUPER](0x1F06)"},
{0x10DE, 0x1F07, 0xFFFF, 0xFFFF, "TU106 [GeForce RTX 2070 Rev. A](0x1F07)"},
{0x10DE, 0x1F08, 0xFFFF, 0xFFFF, "TU106 [GeForce RTX 2060 Rev. A](0x1F08)"},
{0x10DE, 0x1F09, 0xFFFF, 0xFFFF, "TU106 [GeForce GTX 1660 SUPER](0x1F09)"},
{0x10DE, 0x1F0A, 0xFFFF, 0xFFFF, "TU106 [GeForce GTX 1650](0x1F0A)"},
{0x10DE, 0x1F0B, 0xFFFF, 0xFFFF, "TU106 [CMP 40HX](0x1F0B)"},
{0x10DE, 0x1F10, 0xFFFF, 0xFFFF, "TU106M [GeForce RTX 2070 Mobile](0x1F10)"},
{0x10DE, 0x1F11, 0xFFFF, 0xFFFF, "TU106M [GeForce RTX 2060 Mobile](0x1F11)"},
{0x10DE, 0x1F12, 0xFFFF, 0xFFFF, "TU106M [GeForce RTX 2060 Max-Q](0x1F12)"},
{0x10DE, 0x1F14, 0xFFFF, 0xFFFF, "TU106M [GeForce RTX 2070 Mobile / Max-Q Refresh](0x1F14)"},
{0x10DE, 0x1F15, 0xFFFF, 0xFFFF, "TU106M [GeForce RTX 2060 Mobile](0x1F15)"},
{0x10DE, 0x1F2E, 0xFFFF, 0xFFFF, "TU106M(0x1F2E)"},
{0x10DE, 0x1F36, 0xFFFF, 0xFFFF, "TU106GLM [Quadro RTX 3000 Mobile / Max-Q](0x1F36)"},
{0x10DE, 0x1F42, 0xFFFF, 0xFFFF, "TU106 [GeForce RTX 2060 SUPER](0x1F42)"},
{0x10DE, 0x1F47, 0xFFFF, 0xFFFF, "TU106 [GeForce RTX 2060 SUPER](0x1F47)"},
{0x10DE, 0x1F50, 0xFFFF, 0xFFFF, "TU106BM [GeForce RTX 2070 Mobile / Max-Q](0x1F50)"},
{0x10DE, 0x1F51, 0xFFFF, 0xFFFF, "TU106BM [GeForce RTX 2060 Mobile](0x1F51)"},
{0x10DE, 0x1F54, 0xFFFF, 0xFFFF, "TU106BM [GeForce RTX 2070 Mobile](0x1F54)"},
{0x10DE, 0x1F55, 0xFFFF, 0xFFFF, "TU106BM [GeForce RTX 2060 Mobile](0x1F55)"},
{0x10DE, 0x1F76, 0xFFFF, 0xFFFF, "TU106GLM [Quadro RTX 3000 Mobile Refresh](0x1F76)"},
{0x10DE, 0x1F81, 0xFFFF, 0xFFFF, "TU117(0x1F81)"},
{0x10DE, 0x1F82, 0xFFFF, 0xFFFF, "TU117 [GeForce GTX 1650](0x1F82)"},
{0x10DE, 0x1F83, 0xFFFF, 0xFFFF, "TU117 [GeForce GTX 1630](0x1F83)"},
{0x10DE, 0x1F91, 0xFFFF, 0xFFFF, "TU117M [GeForce GTX 1650 Mobile / Max-Q](0x1F91)"},
{0x10DE, 0x1F92, 0xFFFF, 0xFFFF, "TU117M [GeForce GTX 1650 Mobile](0x1F92)"},
{0x10DE, 0x1F94, 0xFFFF, 0xFFFF, "TU117M [GeForce GTX 1650 Mobile](0x1F94)"},
{0x10DE, 0x1F95, 0xFFFF, 0xFFFF, "TU117M [GeForce GTX 1650 Ti Mobile](0x1F95)"},
{0x10DE, 0x1F96, 0xFFFF, 0xFFFF, "TU117M [GeForce GTX 1650 Mobile / Max-Q](0x1F96)"},
{0x10DE, 0x1F97, 0xFFFF, 0xFFFF, "TU117M [GeForce MX450](0x1F97)"},
{0x10DE, 0x1F98, 0xFFFF, 0xFFFF, "TU117M [GeForce MX450](0x1F98)"},
{0x10DE, 0x1F99, 0xFFFF, 0xFFFF, "TU117M [GeForce GTX 1650 Mobile / Max-Q](0x1F99)"},
{0x10DE, 0x1F9C, 0xFFFF, 0xFFFF, "TU117M [GeForce MX450](0x1F9C)"},
{0x10DE, 0x1F9D, 0xFFFF, 0xFFFF, "TU117M [GeForce GTX 1650 Mobile / Max-Q](0x1F9D)"},
{0x10DE, 0x1F9F, 0xFFFF, 0xFFFF, "TU117M [GeForce MX550](0x1F9F)"},
{0x10DE, 0x1FA0, 0xFFFF, 0xFFFF, "TU117M [GeForce MX550](0x1FA0)"},
{0x10DE, 0x1FA1, 0xFFFF, 0xFFFF, "TU117M(0x1FA1)"},
{0x10DE, 0x1FAE, 0xFFFF, 0xFFFF, "TU117GL(0x1FAE)"},
{0x10DE, 0x1FB0, 0xFFFF, 0xFFFF, "TU117GLM [Quadro T1000 Mobile](0x1FB0)"},
{0x10DE, 0x1FB1, 0xFFFF, 0xFFFF, "TU117GL [T600](0x1FB1)"},
{0x10DE, 0x1FB2, 0xFFFF, 0xFFFF, "TU117GLM [Quadro T400 Mobile](0x1FB2)"},
{0x10DE, 0x1FB6, 0xFFFF, 0xFFFF, "TU117GLM [T600 Laptop GPU](0x1FB6)"},
{0x10DE, 0x1FB6, 0x1028, 0x0B10, "Precision 3571(0x1028-0x0B10)"},
{0x10DE, 0x1FB7, 0xFFFF, 0xFFFF, "TU117GLM [T550 Laptop GPU](0x1FB7)"},
{0x10DE, 0x1FB8, 0xFFFF, 0xFFFF, "TU117GLM [Quadro T2000 Mobile / Max-Q](0x1FB8)"},
{0x10DE, 0x1FB9, 0xFFFF, 0xFFFF, "TU117GLM [Quadro T1000 Mobile](0x1FB9)"},
{0x10DE, 0x1FBA, 0xFFFF, 0xFFFF, "TU117GLM [T600 Mobile](0x1FBA)"},
{0x10DE, 0x1FBB, 0xFFFF, 0xFFFF, "TU117GLM [Quadro T500 Mobile](0x1FBB)"},
{0x10DE, 0x1FBC, 0xFFFF, 0xFFFF, "TU117GLM [T1200 Laptop GPU](0x1FBC)"},
{0x10DE, 0x1FBF, 0xFFFF, 0xFFFF, "TU117GL(0x1FBF)"},
{0x10DE, 0x1FD9, 0xFFFF, 0xFFFF, "TU117BM [GeForce GTX 1650 Mobile Refresh](0x1FD9)"},
{0x10DE, 0x1FDD, 0xFFFF, 0xFFFF, "TU117BM [GeForce GTX 1650 Mobile Refresh](0x1FDD)"},
{0x10DE, 0x1FF0, 0xFFFF, 0xFFFF, "TU117GL [T1000 8GB](0x1FF0)"},
{0x10DE, 0x1FF2, 0xFFFF, 0xFFFF, "TU117GL [T400 4GB / T400E](0x1FF2)"},
{0x10DE, 0x1FF9, 0xFFFF, 0xFFFF, "TU117GLM [Quadro T1000 Mobile](0x1FF9)"},
{0x10DE, 0x2080, 0xFFFF, 0xFFFF, "GA100(0x2080)"},
{0x10DE, 0x2081, 0xFFFF, 0xFFFF, "GA100(0x2081)"},
{0x10DE, 0x2082, 0xFFFF, 0xFFFF, "GA100 [CMP 170HX](0x2082)"},
{0x10DE, 0x20B0, 0xFFFF, 0xFFFF, "GA100 [A100 SXM4 40GB](0x20B0)"},
{0x10DE, 0x20B1, 0xFFFF, 0xFFFF, "GA100 [A100 PCIe 40GB](0x20B1)"},
{0x10DE, 0x20B2, 0xFFFF, 0xFFFF, "GA100 [A100 SXM4 80GB](0x20B2)"},
{0x10DE, 0x20B3, 0xFFFF, 0xFFFF, "GA100 [A100-SXM-64GB](0x20B3)"},
{0x10DE, 0x20B4, 0xFFFF, 0xFFFF, "GA100(0x20B4)"},
{0x10DE, 0x20B5, 0xFFFF, 0xFFFF, "GA100 [A100 PCIe 80GB](0x20B5)"},
{0x10DE, 0x20B6, 0xFFFF, 0xFFFF, "GA100GL [PG506-232](0x20B6)"},
{0x10DE, 0x20B7, 0xFFFF, 0xFFFF, "GA100GL [A30 PCIe](0x20B7)"},
{0x10DE, 0x20B8, 0xFFFF, 0xFFFF, "GA100 [A100X](0x20B8)"},
{0x10DE, 0x20B9, 0xFFFF, 0xFFFF, "GA100 [A30X](0x20B9)"},
{0x10DE, 0x20BB, 0xFFFF, 0xFFFF, "GA100 [DRIVE A100 PROD](0x20BB)"},
{0x10DE, 0x20BD, 0xFFFF, 0xFFFF, "GA100 [A800 SXM4 40GB](0x20BD)"},
{0x10DE, 0x20BE, 0xFFFF, 0xFFFF, "GA100 [GRID A100A](0x20BE)"},
{0x10DE, 0x20BF, 0xFFFF, 0xFFFF, "GA100 [GRID A100B](0x20BF)"},
{0x10DE, 0x20C0, 0xFFFF, 0xFFFF, "GA100 [Initial DevID](0x20C0)"},
{0x10DE, 0x20C2, 0xFFFF, 0xFFFF, "GA100 [CMP 170HX](0x20C2)"},
{0x10DE, 0x20F0, 0xFFFF, 0xFFFF, "GA100 [A100-PG506-207](0x20F0)"},
{0x10DE, 0x20F1, 0xFFFF, 0xFFFF, "GA100 [A100 PCIe 40GB](0x20F1)"},
{0x10DE, 0x20F2, 0xFFFF, 0xFFFF, "GA100 [A100-PG506-217](0x20F2)"},
{0x10DE, 0x20F3, 0xFFFF, 0xFFFF, "GA100 [A800-SXM4-80GB](0x20F3)"},
{0x10DE, 0x20F5, 0xFFFF, 0xFFFF, "GA100 [A800 80GB PCIe](0x20F5)"},
{0x10DE, 0x20F6, 0xFFFF, 0xFFFF, "GA100 [A800 40GB PCIe](0x20F6)"},
{0x10DE, 0x20FD, 0xFFFF, 0xFFFF, "GA100 [AX800 Converged Accelerator](0x20FD)"},
{0x10DE, 0x20FE, 0xFFFF, 0xFFFF, "GA100 [INT SKU](0x20FE)"},
{0x10DE, 0x20FF, 0xFFFF, 0xFFFF, "GA100(0x20FF)"},
{0x10DE, 0x2182, 0xFFFF, 0xFFFF, "TU116 [GeForce GTX 1660 Ti](0x2182)"},
{0x10DE, 0x2183, 0xFFFF, 0xFFFF, "TU116(0x2183)"},
{0x10DE, 0x2184, 0xFFFF, 0xFFFF, "TU116 [GeForce GTX 1660](0x2184)"},
{0x10DE, 0x2187, 0xFFFF, 0xFFFF, "TU116 [GeForce GTX 1650 SUPER](0x2187)"},
{0x10DE, 0x2188, 0xFFFF, 0xFFFF, "TU116 [GeForce GTX 1650](0x2188)"},
{0x10DE, 0x2189, 0xFFFF, 0xFFFF, "TU116 [CMP 30HX](0x2189)"},
{0x10DE, 0x2191, 0xFFFF, 0xFFFF, "TU116M [GeForce GTX 1660 Ti Mobile](0x2191)"},
{0x10DE, 0x2192, 0xFFFF, 0xFFFF, "TU116M [GeForce GTX 1650 Ti Mobile](0x2192)"},
{0x10DE, 0x21AE, 0xFFFF, 0xFFFF, "TU116GL(0x21AE)"},
{0x10DE, 0x21BF, 0xFFFF, 0xFFFF, "TU116GL(0x21BF)"},
{0x10DE, 0x21C2, 0xFFFF, 0xFFFF, "TU116(0x21C2)"},
{0x10DE, 0x21C3, 0xFFFF, 0xFFFF, "TU116(0x21C3)"},
{0x10DE, 0x21C4, 0xFFFF, 0xFFFF, "TU116 [GeForce GTX 1660 SUPER](0x21C4)"},
{0x10DE, 0x21D1, 0xFFFF, 0xFFFF, "TU116BM [GeForce GTX 1660 Ti Mobile](0x21D1)"},
{0x10DE, 0x2200, 0xFFFF, 0xFFFF, "GA102(0x2200)"},
{0x10DE, 0x2203, 0xFFFF, 0xFFFF, "GA102 [GeForce RTX 3090 Ti](0x2203)"},
{0x10DE, 0x2204, 0xFFFF, 0xFFFF, "GA102 [GeForce RTX 3090](0x2204)"},
{0x10DE, 0x2204, 0x147D, 0x10DE, "NVIDIA Geforce RTX 3090 Founders Edition(0x147D-0x10DE)"},
{0x10DE, 0x2205, 0xFFFF, 0xFFFF, "GA102 [GeForce RTX 3080 Ti 20GB](0x2205)"},
{0x10DE, 0x2206, 0xFFFF, 0xFFFF, "GA102 [GeForce RTX 3080](0x2206)"},
{0x10DE, 0x2206, 0x10DE, 0x1467, "GA102 [GeForce RTX 3080](0x10DE-0x1467)"},
{0x10DE, 0x2206, 0x10DE, 0x146D, "GA102 [GeForce RTX 3080 20GB](0x10DE-0x146D)"},
{0x10DE, 0x2206, 0x1462, 0x3892, "RTX 3080 10GB GAMING X TRIO(0x1462-0x3892)"},
{0x10DE, 0x2207, 0xFFFF, 0xFFFF, "GA102 [GeForce RTX 3070 Ti](0x2207)"},
{0x10DE, 0x2208, 0xFFFF, 0xFFFF, "GA102 [GeForce RTX 3080 Ti](0x2208)"},
{0x10DE, 0x220A, 0xFFFF, 0xFFFF, "GA102 [GeForce RTX 3080 12GB](0x220A)"},
{0x10DE, 0x220D, 0xFFFF, 0xFFFF, "GA102 [CMP 90HX](0x220D)"},
{0x10DE, 0x2216, 0xFFFF, 0xFFFF, "GA102 [GeForce RTX 3080 Lite Hash Rate](0x2216)"},
{0x10DE, 0x222B, 0xFFFF, 0xFFFF, "GA102 [GeForce RTX 3090 Engineering Sample](0x222B)"},
{0x10DE, 0x222F, 0xFFFF, 0xFFFF, "GA102 [GeForce RTX 3080 11GB / 12GB Engineering Sample](0x222F)"},
{0x10DE, 0x2230, 0xFFFF, 0xFFFF, "GA102GL [RTX A6000](0x2230)"},
{0x10DE, 0x2231, 0xFFFF, 0xFFFF, "GA102GL [RTX A5000](0x2231)"},
{0x10DE, 0x2232, 0xFFFF, 0xFFFF, "GA102GL [RTX A4500](0x2232)"},
{0x10DE, 0x2233, 0xFFFF, 0xFFFF, "GA102GL [RTX A5500](0x2233)"},
{0x10DE, 0x2235, 0xFFFF, 0xFFFF, "GA102GL [A40](0x2235)"},
{0x10DE, 0x2236, 0xFFFF, 0xFFFF, "GA102GL [A10](0x2236)"},
{0x10DE, 0x2237, 0xFFFF, 0xFFFF, "GA102GL [A10G](0x2237)"},
{0x10DE, 0x2238, 0xFFFF, 0xFFFF, "GA102GL [A10M](0x2238)"},
{0x10DE, 0x223F, 0xFFFF, 0xFFFF, "GA102GL(0x223F)"},
{0x10DE, 0x228B, 0xFFFF, 0xFFFF, "GA104 High Definition Audio Controller(0x228B)"},
{0x10DE, 0x228E, 0xFFFF, 0xFFFF, "GA106 High Definition Audio Controller(0x228E)"},
{0x10DE, 0x2291, 0xFFFF, 0xFFFF, "GA107 High Definition Audio Controller(0x2291)"},
{0x10DE, 0x2296, 0xFFFF, 0xFFFF, "Tegra PCIe Endpoint Virtual Network(0x2296)"},
{0x10DE, 0x229A, 0xFFFF, 0xFFFF, "Orin PCIe x8 Root Complex(0x229A)"},
{0x10DE, 0x229C, 0xFFFF, 0xFFFF, "Orin PCIe x4/x8 Endpoint/Root Complex(0x229C)"},
{0x10DE, 0x229E, 0xFFFF, 0xFFFF, "Orin PCIe x1 Root Complex(0x229E)"},
{0x10DE, 0x22A3, 0xFFFF, 0xFFFF, "GH100 [H100 NVSwitch](0x22A3)"},
{0x10DE, 0x22BA, 0xFFFF, 0xFFFF, "AD102 High Definition Audio Controller(0x22BA)"},
{0x10DE, 0x22BC, 0xFFFF, 0xFFFF, "AD104 High Definition Audio Controller(0x22BC)"},
{0x10DE, 0x22BD, 0xFFFF, 0xFFFF, "AD106M High Definition Audio Controller(0x22BD)"},
{0x10DE, 0x22BE, 0xFFFF, 0xFFFF, "AD107 High Definition Audio Controller(0x22BE)"},
{0x10DE, 0x22D8, 0xFFFF, 0xFFFF, "THOR Processor PCI Express Root Port(0x22D8)"},
{0x10DE, 0x22E6, 0xFFFF, 0xFFFF, "THOR Processor PCI Express x16 Controller(0x22E6)"},
{0x10DE, 0x2302, 0xFFFF, 0xFFFF, "GH100(0x2302)"},
{0x10DE, 0x230E, 0xFFFF, 0xFFFF, "GH100 [H20 NVL16](0x230E)"},
{0x10DE, 0x2313, 0xFFFF, 0xFFFF, "GH100 [H100 CNX](0x2313)"},
{0x10DE, 0x2321, 0xFFFF, 0xFFFF, "GH100 [H100L 94GB](0x2321)"},
{0x10DE, 0x2322, 0xFFFF, 0xFFFF, "GH100 [H800 PCIe](0x2322)"},
{0x10DE, 0x2324, 0xFFFF, 0xFFFF, "GH100 [H800](0x2324)"},
{0x10DE, 0x2328, 0xFFFF, 0xFFFF, "GH100 [H20B](0x2328)"},
{0x10DE, 0x2329, 0xFFFF, 0xFFFF, "GH100 [H20](0x2329)"},
{0x10DE, 0x232C, 0xFFFF, 0xFFFF, "GH100 [H20 HBM3e](0x232C)"},
{0x10DE, 0x2330, 0xFFFF, 0xFFFF, "GH100 [H100 SXM5 80GB](0x2330)"},
{0x10DE, 0x2331, 0xFFFF, 0xFFFF, "GH100 [H100 PCIe](0x2331)"},
{0x10DE, 0x2335, 0xFFFF, 0xFFFF, "GH100 [H200 SXM 141GB](0x2335)"},
{0x10DE, 0x2336, 0xFFFF, 0xFFFF, "GH100 [H100](0x2336)"},
{0x10DE, 0x2337, 0xFFFF, 0xFFFF, "GH100 [H100 SXM5 64GB](0x2337)"},
{0x10DE, 0x2338, 0xFFFF, 0xFFFF, "GH100 [H100 SXM5 96GB](0x2338)"},
{0x10DE, 0x2339, 0xFFFF, 0xFFFF, "GH100 [H100 SXM5 94GB](0x2339)"},
{0x10DE, 0x233A, 0xFFFF, 0xFFFF, "GH100 [H800L 94GB](0x233A)"},
{0x10DE, 0x233B, 0xFFFF, 0xFFFF, "GH100 [H200 NVL](0x233B)"},
{0x10DE, 0x233D, 0xFFFF, 0xFFFF, "GH100 [H100 96GB](0x233D)"},
{0x10DE, 0x2342, 0xFFFF, 0xFFFF, "GH100 [GH200 120GB / 480GB](0x2342)"},
{0x10DE, 0x2343, 0xFFFF, 0xFFFF, "GH100(0x2343)"},
{0x10DE, 0x2345, 0xFFFF, 0xFFFF, "GH100 [GH100-88K-A1](0x2345)"},
{0x10DE, 0x2348, 0xFFFF, 0xFFFF, "GH100 [GH200 144G HBM3e](0x2348)"},
{0x10DE, 0x237F, 0xFFFF, 0xFFFF, "GH100 [Skinny Joe](0x237F)"},
{0x10DE, 0x23B0, 0xFFFF, 0xFFFF, "GH100(0x23B0)"},
{0x10DE, 0x23F0, 0xFFFF, 0xFFFF, "GH100(0x23F0)"},
{0x10DE, 0x2414, 0xFFFF, 0xFFFF, "GA103 [GeForce RTX 3060 Ti](0x2414)"},
{0x10DE, 0x2420, 0xFFFF, 0xFFFF, "GA103M [GeForce RTX 3080 Ti Mobile](0x2420)"},
{0x10DE, 0x2438, 0xFFFF, 0xFFFF, "GA103GLM [RTX A5500 Laptop GPU](0x2438)"},
{0x10DE, 0x2460, 0xFFFF, 0xFFFF, "GA103M [GeForce RTX 3080 Ti Laptop GPU](0x2460)"},
{0x10DE, 0x2480, 0xFFFF, 0xFFFF, "GA104 [Reserved Dev ID A](0x2480)"},
{0x10DE, 0x2482, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3070 Ti](0x2482)"},
{0x10DE, 0x2483, 0xFFFF, 0xFFFF, "GA104(0x2483)"},
{0x10DE, 0x2484, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3070](0x2484)"},
{0x10DE, 0x2484, 0x10DE, 0x146B, "GA104 [GeForce RTX 3070](0x10DE-0x146B)"},
{0x10DE, 0x2484, 0x10DE, 0x14AE, "GA104 [GeForce RTX 3070 16GB](0x10DE-0x14AE)"},
{0x10DE, 0x2486, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3060 Ti](0x2486)"},
{0x10DE, 0x2486, 0x19DA, 0x6630, "ZT-A30610H-10M [RTX 3060 Ti Twin Edge OC](0x19DA-0x6630)"},
{0x10DE, 0x2487, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3060](0x2487)"},
{0x10DE, 0x2488, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3070 Lite Hash Rate](0x2488)"},
{0x10DE, 0x2489, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3060 Ti Lite Hash Rate](0x2489)"},
{0x10DE, 0x248A, 0xFFFF, 0xFFFF, "GA104 [CMP 70HX](0x248A)"},
{0x10DE, 0x248C, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3070 Ti](0x248C)"},
{0x10DE, 0x248D, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3070](0x248D)"},
{0x10DE, 0x248E, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3060 Ti](0x248E)"},
{0x10DE, 0x249C, 0xFFFF, 0xFFFF, "GA104M [GeForce RTX 3080 Mobile / Max-Q 8GB/16GB](0x249C)"},
{0x10DE, 0x249D, 0xFFFF, 0xFFFF, "GA104M [GeForce RTX 3070 Mobile / Max-Q](0x249D)"},
{0x10DE, 0x249F, 0xFFFF, 0xFFFF, "GA104M(0x249F)"},
{0x10DE, 0x24A0, 0xFFFF, 0xFFFF, "GA104 [Geforce RTX 3070 Ti Laptop GPU](0x24A0)"},
{0x10DE, 0x24A4, 0xFFFF, 0xFFFF, "GA104M(0x24A4)"},
{0x10DE, 0x24AC, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 30x0 Engineering Sample](0x24AC)"},
{0x10DE, 0x24AD, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3060 Engineering Sample](0x24AD)"},
{0x10DE, 0x24AF, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3070 Engineering Sample](0x24AF)"},
{0x10DE, 0x24B0, 0xFFFF, 0xFFFF, "GA104GL [RTX A4000](0x24B0)"},
{0x10DE, 0x24B1, 0xFFFF, 0xFFFF, "GA104GL [RTX A4000H](0x24B1)"},
{0x10DE, 0x24B6, 0xFFFF, 0xFFFF, "GA104GLM [RTX A5000 Mobile](0x24B6)"},
{0x10DE, 0x24B7, 0xFFFF, 0xFFFF, "GA104GLM [RTX A4000 Mobile](0x24B7)"},
{0x10DE, 0x24B8, 0xFFFF, 0xFFFF, "GA104GLM [RTX A3000 Mobile](0x24B8)"},
{0x10DE, 0x24B9, 0xFFFF, 0xFFFF, "GA104GLM [RTX A3000 12GB Laptop GPU](0x24B9)"},
{0x10DE, 0x24BA, 0xFFFF, 0xFFFF, "GA104GLM [RTX A4500 Laptop GPU](0x24BA)"},
{0x10DE, 0x24BB, 0xFFFF, 0xFFFF, "GA104GLM [RTX A3000 Laptop GPU](0x24BB)"},
{0x10DE, 0x24BF, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3070 Engineering Sample](0x24BF)"},
{0x10DE, 0x24C0, 0xFFFF, 0xFFFF, "GA104 [Initial Dev ID B](0x24C0)"},
{0x10DE, 0x24C7, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3060 8GB](0x24C7)"},
{0x10DE, 0x24C8, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3070 GDDR6X](0x24C8)"},
{0x10DE, 0x24C9, 0xFFFF, 0xFFFF, "GA104 [GeForce RTX 3060 Ti GDDR6X](0x24C9)"},
{0x10DE, 0x24DC, 0xFFFF, 0xFFFF, "GA104M [GeForce RTX 3080 Mobile / Max-Q 8GB/16GB](0x24DC)"},
{0x10DE, 0x24DD, 0xFFFF, 0xFFFF, "GA104M [GeForce RTX 3070 Mobile / Max-Q](0x24DD)"},
{0x10DE, 0x24DF, 0xFFFF, 0xFFFF, "GA104M(0x24DF)"},
{0x10DE, 0x24E0, 0xFFFF, 0xFFFF, "GA104M [Geforce RTX 3070 Ti Laptop GPU](0x24E0)"},
{0x10DE, 0x24FA, 0xFFFF, 0xFFFF, "GA104 [RTX A4500 Embedded GPU ](0x24FA)"},
{0x10DE, 0x2501, 0xFFFF, 0xFFFF, "GA106 [GeForce RTX 3060](0x2501)"},
{0x10DE, 0x2503, 0xFFFF, 0xFFFF, "GA106 [GeForce RTX 3060](0x2503)"},
{0x10DE, 0x2504, 0xFFFF, 0xFFFF, "GA106 [GeForce RTX 3060 Lite Hash Rate](0x2504)"},
{0x10DE, 0x2505, 0xFFFF, 0xFFFF, "GA106(0x2505)"},
{0x10DE, 0x2507, 0xFFFF, 0xFFFF, "GA106 [Geforce RTX 3050](0x2507)"},
{0x10DE, 0x2508, 0xFFFF, 0xFFFF, "GA106 [GeForce RTX 3050 OEM](0x2508)"},
{0x10DE, 0x2509, 0xFFFF, 0xFFFF, "GA106 [GeForce RTX 3060 12GB Rev. 2](0x2509)"},
{0x10DE, 0x2520, 0xFFFF, 0xFFFF, "GA106M [GeForce RTX 3060 Mobile / Max-Q](0x2520)"},
{0x10DE, 0x2521, 0xFFFF, 0xFFFF, "GA106M [GeForce RTX 3060 Laptop GPU](0x2521)"},
{0x10DE, 0x2523, 0xFFFF, 0xFFFF, "GA106M [GeForce RTX 3050 Ti Mobile / Max-Q](0x2523)"},
{0x10DE, 0x252F, 0xFFFF, 0xFFFF, "GA106 [GeForce RTX 3060 Engineering Sample](0x252F)"},
{0x10DE, 0x2531, 0xFFFF, 0xFFFF, "GA106 [RTX A2000](0x2531)"},
{0x10DE, 0x2544, 0xFFFF, 0xFFFF, "GA106 [GeForce RTX 3060](0x2544)"},
{0x10DE, 0x2560, 0xFFFF, 0xFFFF, "GA106M [GeForce RTX 3060 Mobile / Max-Q](0x2560)"},
{0x10DE, 0x2561, 0xFFFF, 0xFFFF, "GA106M [GeForce RTX 3060 Laptop GPU](0x2561)"},
{0x10DE, 0x2563, 0xFFFF, 0xFFFF, "GA106M [GeForce RTX 3050 Ti Mobile / Max-Q](0x2563)"},
{0x10DE, 0x2571, 0xFFFF, 0xFFFF, "GA106 [RTX A2000 12GB](0x2571)"},
{0x10DE, 0x2582, 0xFFFF, 0xFFFF, "GA107 [GeForce RTX 3050 8GB](0x2582)"},
{0x10DE, 0x2583, 0xFFFF, 0xFFFF, "GA107 [GeForce RTX 3050 4GB](0x2583)"},
{0x10DE, 0x2584, 0xFFFF, 0xFFFF, "GA107 [GeForce RTX 3050 6GB](0x2584)"},
{0x10DE, 0x25A0, 0xFFFF, 0xFFFF, "GA107M [GeForce RTX 3050 Ti Mobile](0x25A0)"},
{0x10DE, 0x25A2, 0xFFFF, 0xFFFF, "GA107M [GeForce RTX 3050 Mobile](0x25A2)"},
{0x10DE, 0x25A3, 0xFFFF, 0xFFFF, "GA107(0x25A3)"},
{0x10DE, 0x25A4, 0xFFFF, 0xFFFF, "GA107(0x25A4)"},
{0x10DE, 0x25A5, 0xFFFF, 0xFFFF, "GA107M [GeForce RTX 3050 Mobile](0x25A5)"},
{0x10DE, 0x25A6, 0xFFFF, 0xFFFF, "GA107M [GeForce MX570](0x25A6)"},
{0x10DE, 0x25A7, 0xFFFF, 0xFFFF, "GA107M [GeForce MX570](0x25A7)"},
{0x10DE, 0x25A9, 0xFFFF, 0xFFFF, "GA107M [GeForce RTX 2050](0x25A9)"},
{0x10DE, 0x25AA, 0xFFFF, 0xFFFF, "GA107M [GeForce MX570 A](0x25AA)"},
{0x10DE, 0x25AB, 0xFFFF, 0xFFFF, "GA107M [GeForce RTX 3050 4GB Laptop GPU](0x25AB)"},
{0x10DE, 0x25AC, 0xFFFF, 0xFFFF, "GA107BM / GN20-P0-R-K2 [GeForce RTX 3050 6GB Laptop GPU](0x25AC)"},
{0x10DE, 0x25AD, 0xFFFF, 0xFFFF, "GA107 [GeForce RTX 2050](0x25AD)"},
{0x10DE, 0x25AF, 0xFFFF, 0xFFFF, "GA107 [GeForce RTX 3050 Engineering Sample](0x25AF)"},
{0x10DE, 0x25B0, 0xFFFF, 0xFFFF, "GA107GL [RTX A1000](0x25B0)"},
{0x10DE, 0x25B2, 0xFFFF, 0xFFFF, "GA107GL [RTX A400](0x25B2)"},
{0x10DE, 0x25B5, 0xFFFF, 0xFFFF, "GA107GLM [RTX A4 Mobile](0x25B5)"},
{0x10DE, 0x25B6, 0xFFFF, 0xFFFF, "GA107GL [A2 / A16](0x25B6)"},
{0x10DE, 0x25B8, 0xFFFF, 0xFFFF, "GA107GLM [RTX A2000 Mobile](0x25B8)"},
{0x10DE, 0x25B9, 0xFFFF, 0xFFFF, "GA107GLM [RTX A1000 Laptop GPU](0x25B9)"},
{0x10DE, 0x25BA, 0xFFFF, 0xFFFF, "GA107GLM [RTX A2000 8GB Laptop GPU](0x25BA)"},
{0x10DE, 0x25BB, 0xFFFF, 0xFFFF, "GA107GLM [RTX A500 Laptop GPU](0x25BB)"},
{0x10DE, 0x25BC, 0xFFFF, 0xFFFF, "GA107GLM [RTX A1000 6GB Laptop GPU](0x25BC)"},
{0x10DE, 0x25BD, 0xFFFF, 0xFFFF, "GA107GLM [RTX A500 Laptop GPU](0x25BD)"},
{0x10DE, 0x25E0, 0xFFFF, 0xFFFF, "GA107BM [GeForce RTX 3050 Ti Mobile](0x25E0)"},
{0x10DE, 0x25E2, 0xFFFF, 0xFFFF, "GA107BM [GeForce RTX 3050 Mobile](0x25E2)"},
{0x10DE, 0x25E5, 0xFFFF, 0xFFFF, "GA107BM [GeForce RTX 3050 Mobile](0x25E5)"},
{0x10DE, 0x25EC, 0xFFFF, 0xFFFF, "GA107BM / GN20-P0-R-K2 [GeForce RTX 3050 6GB Laptop GPU](0x25EC)"},
{0x10DE, 0x25ED, 0xFFFF, 0xFFFF, "GA107 [GeForce RTX 2050](0x25ED)"},
{0x10DE, 0x25F9, 0xFFFF, 0xFFFF, "GA107 [RTX A1000 Embedded GPU ](0x25F9)"},
{0x10DE, 0x25FA, 0xFFFF, 0xFFFF, "GA107 [RTX A2000 Embedded GPU](0x25FA)"},
{0x10DE, 0x25FB, 0xFFFF, 0xFFFF, "GA107 [RTX A500 Embedded GPU](0x25FB)"},
{0x10DE, 0x2681, 0xFFFF, 0xFFFF, "AD102 [RTX TITAN Ada](0x2681)"},
{0x10DE, 0x2684, 0xFFFF, 0xFFFF, "AD102 [GeForce RTX 4090](0x2684)"},
{0x10DE, 0x2685, 0xFFFF, 0xFFFF, "AD102 [GeForce RTX 4090 D](0x2685)"},
{0x10DE, 0x2689, 0xFFFF, 0xFFFF, "AD102 [GeForce RTX 4070 Ti SUPER](0x2689)"},
{0x10DE, 0x26AF, 0xFFFF, 0xFFFF, "AD102 [PG137](0x26AF)"},
{0x10DE, 0x26B1, 0xFFFF, 0xFFFF, "AD102GL [RTX 6000 Ada Generation](0x26B1)"},
{0x10DE, 0x26B2, 0xFFFF, 0xFFFF, "AD102GL [RTX 5000 Ada Generation](0x26B2)"},
{0x10DE, 0x26B3, 0xFFFF, 0xFFFF, "AD102GL [RTX 5880 Ada Generation](0x26B3)"},
{0x10DE, 0x26B5, 0xFFFF, 0xFFFF, "AD102GL [L40](0x26B5)"},
{0x10DE, 0x26B7, 0xFFFF, 0xFFFF, "AD102GL [L20](0x26B7)"},
{0x10DE, 0x26B8, 0xFFFF, 0xFFFF, "AD102GL [L40G](0x26B8)"},
{0x10DE, 0x26B9, 0xFFFF, 0xFFFF, "AD102GL [L40S](0x26B9)"},
{0x10DE, 0x26BA, 0xFFFF, 0xFFFF, "AD102GL [L20](0x26BA)"},
{0x10DE, 0x26BB, 0xFFFF, 0xFFFF, "AD102GL [L30](0x26BB)"},
{0x10DE, 0x26F5, 0xFFFF, 0xFFFF, "AD102GL [L40 CNX](0x26F5)"},
{0x10DE, 0x2702, 0xFFFF, 0xFFFF, "AD103 [GeForce RTX 4080 SUPER](0x2702)"},
{0x10DE, 0x2703, 0xFFFF, 0xFFFF, "AD103 [GeForce RTX 4080 SUPER](0x2703)"},
{0x10DE, 0x2704, 0xFFFF, 0xFFFF, "AD103 [GeForce RTX 4080](0x2704)"},
{0x10DE, 0x2705, 0xFFFF, 0xFFFF, "AD103 [GeForce RTX 4070 Ti SUPER](0x2705)"},
{0x10DE, 0x2709, 0xFFFF, 0xFFFF, "AD103 [GeForce RTX 4070](0x2709)"},
{0x10DE, 0x2717, 0xFFFF, 0xFFFF, "AD103M / GN21-X11 [GeForce RTX 4090 Laptop GPU](0x2717)"},
{0x10DE, 0x2730, 0xFFFF, 0xFFFF, "AD103GLM [RTX 5000 Ada Generation Laptop GPU](0x2730)"},
{0x10DE, 0x2757, 0xFFFF, 0xFFFF, "AD103M / GN21-X11 [GeForce RTX 4090 Laptop GPU](0x2757)"},
{0x10DE, 0x2770, 0xFFFF, 0xFFFF, "AD103GLM [RTX 5000 Ada Generation Embedded GPU](0x2770)"},
{0x10DE, 0x2782, 0xFFFF, 0xFFFF, "AD104 [GeForce RTX 4070 Ti](0x2782)"},
{0x10DE, 0x2783, 0xFFFF, 0xFFFF, "AD104 [GeForce RTX 4070 SUPER](0x2783)"},
{0x10DE, 0x2785, 0xFFFF, 0xFFFF, "AD104 [AC AD104 20GB](0x2785)"},
{0x10DE, 0x2786, 0xFFFF, 0xFFFF, "AD104 [GeForce RTX 4070](0x2786)"},
{0x10DE, 0x2788, 0xFFFF, 0xFFFF, "AD104 [GeForce RTX 4060 Ti](0x2788)"},
{0x10DE, 0x27A0, 0xFFFF, 0xFFFF, "AD104M [GeForce RTX 4080 Max-Q / Mobile](0x27A0)"},
{0x10DE, 0x27B0, 0xFFFF, 0xFFFF, "AD104GL [RTX 4000 SFF Ada Generation](0x27B0)"},
{0x10DE, 0x27B1, 0xFFFF, 0xFFFF, "AD104GL [RTX 4500 Ada Generation](0x27B1)"},
{0x10DE, 0x27B2, 0xFFFF, 0xFFFF, "AD104GL [RTX 4000 Ada Generation](0x27B2)"},
{0x10DE, 0x27B6, 0xFFFF, 0xFFFF, "AD104GL [L2](0x27B6)"},
{0x10DE, 0x27B7, 0xFFFF, 0xFFFF, "AD104GL [L16](0x27B7)"},
{0x10DE, 0x27B8, 0xFFFF, 0xFFFF, "AD104GL [L4](0x27B8)"},
{0x10DE, 0x27BA, 0xFFFF, 0xFFFF, "AD104GLM [RTX 4000 Ada Generation Laptop GPU](0x27BA)"},
{0x10DE, 0x27BB, 0xFFFF, 0xFFFF, "AD104GLM [RTX 3500 Ada Generation Laptop GPU](0x27BB)"},
{0x10DE, 0x27E0, 0xFFFF, 0xFFFF, "AD104M [GeForce RTX 4080 Max-Q / Mobile](0x27E0)"},
{0x10DE, 0x27FA, 0xFFFF, 0xFFFF, "AD104GLM [RTX 4000 Ada Generation Embedded GPU](0x27FA)"},
{0x10DE, 0x27FB, 0xFFFF, 0xFFFF, "AD104GLM [RTX 3500 Ada Generation Embedded GPU](0x27FB)"},
{0x10DE, 0x2803, 0xFFFF, 0xFFFF, "AD106 [GeForce RTX 4060 Ti](0x2803)"},
{0x10DE, 0x2805, 0xFFFF, 0xFFFF, "AD106 [GeForce RTX 4060 Ti 16GB](0x2805)"},
{0x10DE, 0x2808, 0xFFFF, 0xFFFF, "AD106 [GeForce RTX 4060](0x2808)"},
{0x10DE, 0x2820, 0xFFFF, 0xFFFF, "AD106M [GeForce RTX 4070 Max-Q / Mobile](0x2820)"},
{0x10DE, 0x2822, 0xFFFF, 0xFFFF, "AD106M [GeForce RTX 3050 A Laptop GPU](0x2822)"},
{0x10DE, 0x2838, 0xFFFF, 0xFFFF, "AD106GLM [RTX 3000 Ada Generation Laptop GPU](0x2838)"},
{0x10DE, 0x2860, 0xFFFF, 0xFFFF, "AD106M [GeForce RTX 4070 Max-Q / Mobile](0x2860)"},
{0x10DE, 0x2878, 0xFFFF, 0xFFFF, "AD106GLM [RTX 3000 Ada Generation Embedded GPU](0x2878)"},
{0x10DE, 0x2882, 0xFFFF, 0xFFFF, "AD107 [GeForce RTX 4060](0x2882)"},
{0x10DE, 0x28A0, 0xFFFF, 0xFFFF, "AD107M [GeForce RTX 4060 Max-Q / Mobile](0x28A0)"},
{0x10DE, 0x28A1, 0xFFFF, 0xFFFF, "AD107M [GeForce RTX 4050 Max-Q / Mobile](0x28A1)"},
{0x10DE, 0x28A3, 0xFFFF, 0xFFFF, "AD107M [GeForce RTX 3050 A Laptop GPU](0x28A3)"},
{0x10DE, 0x28B0, 0xFFFF, 0xFFFF, "AD107GL [RTX 2000 / 2000E Ada Generation](0x28B0)"},
{0x10DE, 0x28B8, 0xFFFF, 0xFFFF, "AD107GLM [RTX 2000 Ada Generation Laptop GPU](0x28B8)"},
{0x10DE, 0x28B9, 0xFFFF, 0xFFFF, "AD107GLM [RTX 1000 Ada Generation Laptop GPU](0x28B9)"},
{0x10DE, 0x28BA, 0xFFFF, 0xFFFF, "AD107GLM [RTX 500 Ada Generation Laptop GPU](0x28BA)"},
{0x10DE, 0x28BB, 0xFFFF, 0xFFFF, "AD107GLM [RTX 500 Ada Generation Laptop GPU](0x28BB)"},
{0x10DE, 0x28E0, 0xFFFF, 0xFFFF, "AD107M [GeForce RTX 4060 Max-Q / Mobile](0x28E0)"},
{0x10DE, 0x28E1, 0xFFFF, 0xFFFF, "AD107M [GeForce RTX 4050 Max-Q / Mobile](0x28E1)"},
{0x10DE, 0x28E3, 0xFFFF, 0xFFFF, "AD107M [GeForce RTX 3050 A Laptop GPU](0x28E3)"},
{0x10DE, 0x28F8, 0xFFFF, 0xFFFF, "AD107GLM [RTX 2000 Ada Generation Embedded GPU](0x28F8)"},
{0x10DE, 0x2900, 0xFFFF, 0xFFFF, "GB100 [Reserved Dev ID A](0x2900)"},
{0x10DE, 0x2901, 0xFFFF, 0xFFFF, "GB100 [B200](0x2901)"},
{0x10DE, 0x2920, 0xFFFF, 0xFFFF, "GB100 [TS4 / B100](0x2920)"},
{0x10DE, 0x2924, 0xFFFF, 0xFFFF, "GB100(0x2924)"},
{0x10DE, 0x2925, 0xFFFF, 0xFFFF, "GB100(0x2925)"},
{0x10DE, 0x293D, 0xFFFF, 0xFFFF, "GB100(0x293D)"},
{0x10DE, 0x2940, 0xFFFF, 0xFFFF, "GB100 [Reserved Dev ID B](0x2940)"},
{0x10DE, 0x2941, 0xFFFF, 0xFFFF, "GB100 [HGX GB200](0x2941)"},
{0x10DE, 0x297E, 0xFFFF, 0xFFFF, "GB100(0x297E)"},
{0x10DE, 0x2980, 0xFFFF, 0xFFFF, "GB102 [Reserved Dev ID A](0x2980)"},
{0x10DE, 0x29BC, 0xFFFF, 0xFFFF, "GB102 [B100](0x29BC)"},
{0x10DE, 0x29C0, 0xFFFF, 0xFFFF, "GB102 [Reserved Dev ID B](0x29C0)"},
{0x10DE, 0x29F1, 0xFFFF, 0xFFFF, "GB102(0x29F1)"},
{0x10DE, 0x2B00, 0xFFFF, 0xFFFF, "TA1090SA [THOR](0x2B00)"},
{0x10DE, 0x2B85, 0xFFFF, 0xFFFF, "GB202 [GeForce RTX 5090](0x2B85)"},
{0x10DE, 0x2B87, 0xFFFF, 0xFFFF, "GB202 [GeForce RTX 5090 D](0x2B87)"},
{0x10DE, 0x2BB1, 0xFFFF, 0xFFFF, "GB202GL [RTX PRO 6000 Blackwell Workstation Edition](0x2BB1)"},
{0x10DE, 0x2BB3, 0xFFFF, 0xFFFF, "GB202GL [RTX PRO 5000 Blackwell](0x2BB3)"},
{0x10DE, 0x2BB4, 0xFFFF, 0xFFFF, "GB202GL [RTX PRO 6000 Blackwell Max-Q Workstation Edition](0x2BB4)"},
{0x10DE, 0x2BB5, 0xFFFF, 0xFFFF, "GB202GL [RTX PRO 6000 Blackwell Server Edition](0x2BB5)"},
{0x10DE, 0x2C02, 0xFFFF, 0xFFFF, "GB203 [GeForce RTX 5080](0x2C02)"},
{0x10DE, 0x2C05, 0xFFFF, 0xFFFF, "GB203 [GeForce RTX 5070 Ti](0x2C05)"},
{0x10DE, 0x2C18, 0xFFFF, 0xFFFF, "GB203M / GN22 [GeForce RTX 5090 Max-Q / Mobile](0x2C18)"},
{0x10DE, 0x2C19, 0xFFFF, 0xFFFF, "GB203M / GN22 [GeForce RTX 5080 Max-Q / Mobile](0x2C19)"},
{0x10DE, 0x2C2C, 0xFFFF, 0xFFFF, "GB6-256(N22W-ES-A1)(0x2C2C)"},
{0x10DE, 0x2C31, 0xFFFF, 0xFFFF, "GB203GL [RTX PRO 4500 Blackwell](0x2C31)"},
{0x10DE, 0x2C34, 0xFFFF, 0xFFFF, "GB203GL [RTX PRO 4000 Blackwell](0x2C34)"},
{0x10DE, 0x2C38, 0xFFFF, 0xFFFF, "GB203GLM [RTX PRO 5000 Blackwell Generation Laptop GPU](0x2C38)"},
{0x10DE, 0x2C39, 0xFFFF, 0xFFFF, "GB203GLM [RTX PRO 4000 Blackwell Generation Laptop GPU](0x2C39)"},
{0x10DE, 0x2C58, 0xFFFF, 0xFFFF, "GB203M / GN22-X11 [GeForce RTX 5090 Max-Q / Mobile](0x2C58)"},
{0x10DE, 0x2C59, 0xFFFF, 0xFFFF, "GB203M / GN22-X9 [GeForce RTX 5080 Max-Q / Mobile](0x2C59)"},
{0x10DE, 0x2D04, 0xFFFF, 0xFFFF, "GB206 [GeForce RTX 5060 Ti](0x2D04)"},
{0x10DE, 0x2D05, 0xFFFF, 0xFFFF, "GB206 [GeForce RTX 5060](0x2D05)"},
{0x10DE, 0x2D18, 0xFFFF, 0xFFFF, "GB206M [GeForce RTX 5070 Max-Q / Mobile](0x2D18)"},
{0x10DE, 0x2D19, 0xFFFF, 0xFFFF, "GB206M [GeForce RTX 5060 Max-Q / Mobile](0x2D19)"},
{0x10DE, 0x2D2C, 0xFFFF, 0xFFFF, "GB6-128 (N22Y-ES-A1)(0x2D2C)"},
{0x10DE, 0x2D39, 0xFFFF, 0xFFFF, "GB206GLM [RTX PRO 2000 Blackwell Generation Laptop GPU](0x2D39)"},
{0x10DE, 0x2D58, 0xFFFF, 0xFFFF, "GB206M [GeForce RTX 5070 Max-Q / Mobile](0x2D58)"},
{0x10DE, 0x2D59, 0xFFFF, 0xFFFF, "GB206M [GeForce RTX 5060 Max-Q / Mobile](0x2D59)"},
{0x10DE, 0x2D83, 0xFFFF, 0xFFFF, "GB207 [GeForce RTX 5050](0x2D83)"},
{0x10DE, 0x2D98, 0xFFFF, 0xFFFF, "GB207M [GeForce RTX 5050 Max-Q / Mobile](0x2D98)"},
{0x10DE, 0x2DB8, 0xFFFF, 0xFFFF, "GB207GLM [RTX PRO 1000 Blackwell Generation Laptop GPU](0x2DB8)"},
{0x10DE, 0x2DB9, 0xFFFF, 0xFFFF, "GB207GLM [RTX PRO 500 Blackwell Generation Laptop GPU](0x2DB9)"},
{0x10DE, 0x2DD8, 0xFFFF, 0xFFFF, "GB207M [GeForce RTX 5050 Max-Q / Mobile](0x2DD8)"},
{0x10DE, 0x2E2A, 0xFFFF, 0xFFFF, "GB20B(0x2E2A)"},
{0x10DE, 0x2F04, 0xFFFF, 0xFFFF, "GB205 [GeForce RTX 5070](0x2F04)"},
{0x10DE, 0x2F18, 0xFFFF, 0xFFFF, "GB205M [GeForce RTX 5070 Ti Mobile](0x2F18)"},
{0x10DE, 0x2F38, 0xFFFF, 0xFFFF, "GB205GLM [RTX PRO 3000 Blackwell Generation Laptop GPU](0x2F38)"},
{0x10DE, 0x2F58, 0xFFFF, 0xFFFF, "GB205M [GeForce RTX 5070 Ti Mobile](0x2F58)"},
{0x10DE, 0x31C0, 0xFFFF, 0xFFFF, "GB110(0x31C0)"},
{0x10DE, 0x3340, 0xFFFF, 0xFFFF, "GB120(0x3340)"},
}; /* pci_vid_10DE[] */

static pci_id_t const pci_vid_10DF[] = {
{0x10DF, 0xFFFF, 0xFFFF, 0xFFFF, "Emulex Corporation(0x10DF)"},
{0x10DF, 0x0720, 0xFFFF, 0xFFFF, "OneConnect NIC (Skyhawk)(0x0720)"},
{0x10DF, 0x0720, 0x103C, 0x1934, "FlexFabric 20Gb 2-port 650M Adapter(0x103C-0x1934)"},
{0x10DF, 0x0720, 0x103C, 0x1935, "FlexFabric 20Gb 2-port 650FLB Adapter(0x103C-0x1935)"},
{0x10DF, 0x0720, 0x103C, 0x21D4, "StoreFabric CN1200E 10Gb Converged Network Adapter(0x103C-0x21D4)"},
{0x10DF, 0x0720, 0x103C, 0x220A, "FlexFabric 10Gb 2-port 556FLR-SFP+ Adapter(0x103C-0x220A)"},
{0x10DF, 0x0720, 0x103C, 0x803F, "Ethernet 10Gb 2-port 557SFP+ Adapter(0x103C-0x803F)"},
{0x10DF, 0x0720, 0x103C, 0x8144, "FlexFabric 10GB 2-port 556FLR-T Adapter(0x103C-0x8144)"},
{0x10DF, 0x0720, 0x17AA, 0x1056, "ThinkServer OCm14102-UX-L AnyFabric(0x17AA-0x1056)"},
{0x10DF, 0x0720, 0x17AA, 0x1057, "ThinkServer OCm14104-UX-L AnyFabric(0x17AA-0x1057)"},
{0x10DF, 0x0720, 0x17AA, 0x1059, "ThinkServer OCm14104-UT-L AnyFabric(0x17AA-0x1059)"},
{0x10DF, 0x0720, 0x17AA, 0x4014, "ThinkServer OCm14102-NX-L AnyFabric(0x17AA-0x4014)"},
{0x10DF, 0x0722, 0xFFFF, 0xFFFF, "OneConnect iSCSI Initiator (Skyhawk)(0x0722)"},
{0x10DF, 0x0723, 0xFFFF, 0xFFFF, "OneConnect iSCSI Initiator + Target (Skyhawk)(0x0723)"},
{0x10DF, 0x0724, 0xFFFF, 0xFFFF, "OneConnect FCoE Initiator (Skyhawk)(0x0724)"},
{0x10DF, 0x0728, 0xFFFF, 0xFFFF, "OneConnect NIC (Skyhawk-VF)(0x0728)"},
{0x10DF, 0x072A, 0xFFFF, 0xFFFF, "OneConnect iSCSI Initiator (Skyhawk-VF)(0x072A)"},
{0x10DF, 0x072B, 0xFFFF, 0xFFFF, "OneConnect iSCSI Initiator + Target (Skyhawk-VF)(0x072B)"},
{0x10DF, 0x072C, 0xFFFF, 0xFFFF, "OneConnect FCoE Initiator (Skyhawk-VF)(0x072C)"},
{0x10DF, 0x1AE5, 0xFFFF, 0xFFFF, "LP6000 Fibre Channel Host Adapter(0x1AE5)"},
{0x10DF, 0xE100, 0xFFFF, 0xFFFF, "Proteus-X: LightPulse IOV Fibre Channel Host Adapter(0xE100)"},
{0x10DF, 0xE131, 0xFFFF, 0xFFFF, "LightPulse 8Gb/s PCIe Shared I/O Fibre Channel Adapter(0xE131)"},
{0x10DF, 0xE180, 0xFFFF, 0xFFFF, "Proteus-X: LightPulse IOV Fibre Channel Host Adapter(0xE180)"},
{0x10DF, 0xE200, 0xFFFF, 0xFFFF, "LPe15000/LPe16000 Series 8Gb/16Gb Fibre Channel Adapter(0xE200)"},
{0x10DF, 0xE200, 0x1014, 0x03F1, "PCIe2 2-Port 16Gb Fibre Channel Adapter for POWER (FC EL5B; CCIN 577F)(0x1014-0x03F1)"},
{0x10DF, 0xE200, 0x1014, 0x04E3, "PCIe3 4-Port 10GbE SR Adapter for POWER (FC EN15/EN16; CCIN 2CE3)(0x1014-0x04E3)"},
{0x10DF, 0xE200, 0x1014, 0x04E4, "PCIe3 4-Port 10GbE SFP+ Adapter for POWER (FC EN18; CCIN 2CE4)(0x1014-0x04E4)"},
{0x10DF, 0xE200, 0x10DF, 0xE280, "LPe16002B-M6 2-Port 16Gb Fibre Channel Adapter(0x10DF-0xE280)"},
{0x10DF, 0xE200, 0x10DF, 0xE281, "LPe16000B-M6 1-Port 16Gb Fibre Channel Adapter(0x10DF-0xE281)"},
{0x10DF, 0xE200, 0x10DF, 0xE282, "Flex System FC5054 4-port 16Gb FC Adapter(0x10DF-0xE282)"},
{0x10DF, 0xE208, 0xFFFF, 0xFFFF, "LightPulse 16Gb Fibre Channel Host Adapter (Lancer-VF)(0xE208)"},
{0x10DF, 0xE220, 0xFFFF, 0xFFFF, "OneConnect NIC (Lancer)(0xE220)"},
{0x10DF, 0xE220, 0x17AA, 0x1054, "ThinkServer LPm16002B-M6-L AnyFabric(0x17AA-0x1054)"},
{0x10DF, 0xE220, 0x17AA, 0x1055, "ThinkServer LPm16004B-M8-L AnyFabric(0x17AA-0x1055)"},
{0x10DF, 0xE240, 0xFFFF, 0xFFFF, "OneConnect iSCSI Initiator (Lancer)(0xE240)"},
{0x10DF, 0xE260, 0xFFFF, 0xFFFF, "OneConnect FCoE Initiator (Lancer)(0xE260)"},
{0x10DF, 0xE268, 0xFFFF, 0xFFFF, "OneConnect 10Gb FCoE Converged Network Adapter (Lancer-VF)(0xE268)"},
{0x10DF, 0xE300, 0xFFFF, 0xFFFF, "LPe31000/LPe32000 Series 16Gb/32Gb Fibre Channel Adapter(0xE300)"},
{0x10DF, 0xE300, 0x1014, 0x0614, "PCIe3 4-Port 16Gb Fibre Channel Adapter for POWER (FC EN1C/EN1D; CCIN 578E)(0x1014-0x0614)"},
{0x10DF, 0xE300, 0x1014, 0x0615, "PCIe3 2-Port 32Gb Fibre Channel Adapter for POWER (FC EN1A/EN1B; CCIN 578F)(0x1014-0x0615)"},
{0x10DF, 0xE300, 0x1014, 0x06A0, "PCIe3 2-Port 16Gb Fibre Channel Adapter for POWER (FC EN1L/EN1M; CCIN 2CFC)(0x1014-0x06A0)"},
{0x10DF, 0xE300, 0x10DF, 0xE300, "LPe32002-M2 2-Port 32Gb Fibre Channel Adapter(0x10DF-0xE300)"},
{0x10DF, 0xE300, 0x10DF, 0xE301, "LPe32000-M2 1-Port 32Gb Fibre Channel Adapter(0x10DF-0xE301)"},
{0x10DF, 0xE300, 0x10DF, 0xE310, "LPe31002-M6 2-Port 16Gb Fibre Channel Adapter(0x10DF-0xE310)"},
{0x10DF, 0xE300, 0x10DF, 0xE311, "LPe31000-M6 1-Port 16Gb Fibre Channel Adapter(0x10DF-0xE311)"},
{0x10DF, 0xE300, 0x10DF, 0xE312, "LPe31004-M6 4-Port 16Gb Fibre Channel Adapter(0x10DF-0xE312)"},
{0x10DF, 0xE300, 0x10DF, 0xE320, "LPe32002-M2-D 2-Port 32Gb Fibre Channel Adapter(0x10DF-0xE320)"},
{0x10DF, 0xE300, 0x10DF, 0xE321, "LPe32000-M2-D 1-Port 32Gb Fibre Channel Adapter(0x10DF-0xE321)"},
{0x10DF, 0xE300, 0x10DF, 0xE322, "LPe31002-M6-D 2-Port 16Gb Fibre Channel Adapter(0x10DF-0xE322)"},
{0x10DF, 0xE300, 0x10DF, 0xE323, "LPe31000-M6-D 1-Port 16Gb Fibre Channel Adapter(0x10DF-0xE323)"},
{0x10DF, 0xE300, 0x10DF, 0xE324, "LPm32002-D 2-Port 32Gb Fibre Channel Mezz Card(0x10DF-0xE324)"},
{0x10DF, 0xE300, 0x10DF, 0xE325, "LPm31002-D 2-Port 16Gb Fibre Channel Mezz Card(0x10DF-0xE325)"},
{0x10DF, 0xE300, 0x10DF, 0xE330, "LPe32002-M2-L 2-Port 32Gb PCIe Fibre Channel Adapter(0x10DF-0xE330)"},
{0x10DF, 0xE300, 0x10DF, 0xE331, "LPe32000-M2-L 1-Port 32Gb PCIe Fibre Channel Adapter(0x10DF-0xE331)"},
{0x10DF, 0xE300, 0x10DF, 0xE332, "LPe31002-M6-L 2-Port 16Gb PCIe Fibre Channel Adapter(0x10DF-0xE332)"},
{0x10DF, 0xE300, 0x10DF, 0xE333, "LPe31000-M6-L 1-Port 16Gb PCIe Fibre Channel Adapter(0x10DF-0xE333)"},
{0x10DF, 0xE300, 0x1590, 0x0201, "StoreFabric SN1600E 1-Port 32Gb Fibre Channel Adapter(0x1590-0x0201)"},
{0x10DF, 0xE300, 0x1590, 0x0202, "StoreFabric SN1600E 2-Port 32Gb Fibre Channel Adapter(0x1590-0x0202)"},
{0x10DF, 0xE300, 0x1590, 0x0213, "StoreFabric SN1200E 1-Port 16Gb Fibre Channel Adapter(0x1590-0x0213)"},
{0x10DF, 0xE300, 0x1590, 0x0214, "StoreFabric SN1200E 2-Port 16Gb Fibre Channel Adapter(0x1590-0x0214)"},
{0x10DF, 0xE300, 0x1590, 0x022E, "Synergy 5330C 2-Port 32Gb Fibre Channel Mezz Card(0x1590-0x022E)"},
{0x10DF, 0xE300, 0x193D, 0x1060, "NIC-FC730i-Mb-2P(0x193D-0x1060)"},
{0x10DF, 0xF011, 0xFFFF, 0xFFFF, "Saturn: LightPulse Fibre Channel Host Adapter(0xF011)"},
{0x10DF, 0xF015, 0xFFFF, 0xFFFF, "Saturn: LightPulse Fibre Channel Host Adapter(0xF015)"},
{0x10DF, 0xF085, 0xFFFF, 0xFFFF, "LP850 Fibre Channel Host Adapter(0xF085)"},
{0x10DF, 0xF095, 0xFFFF, 0xFFFF, "LP952 Fibre Channel Host Adapter(0xF095)"},
{0x10DF, 0xF098, 0xFFFF, 0xFFFF, "LP982 Fibre Channel Host Adapter(0xF098)"},
{0x10DF, 0xF0A1, 0xFFFF, 0xFFFF, "Thor LightPulse Fibre Channel Host Adapter(0xF0A1)"},
{0x10DF, 0xF0A5, 0xFFFF, 0xFFFF, "Thor LightPulse Fibre Channel Host Adapter(0xF0A5)"},
{0x10DF, 0xF0B5, 0xFFFF, 0xFFFF, "Viper LightPulse Fibre Channel Host Adapter(0xF0B5)"},
{0x10DF, 0xF0D1, 0xFFFF, 0xFFFF, "Helios LightPulse Fibre Channel Host Adapter(0xF0D1)"},
{0x10DF, 0xF0D5, 0xFFFF, 0xFFFF, "Helios LightPulse Fibre Channel Host Adapter(0xF0D5)"},
{0x10DF, 0xF0E1, 0xFFFF, 0xFFFF, "Zephyr LightPulse Fibre Channel Host Adapter(0xF0E1)"},
{0x10DF, 0xF0E5, 0xFFFF, 0xFFFF, "Zephyr LightPulse Fibre Channel Host Adapter(0xF0E5)"},
{0x10DF, 0xF0F5, 0xFFFF, 0xFFFF, "Neptune LightPulse Fibre Channel Host Adapter(0xF0F5)"},
{0x10DF, 0xF100, 0xFFFF, 0xFFFF, "LPe12000 Series 8Gb Fibre Channel Adapter(0xF100)"},
{0x10DF, 0xF100, 0x1014, 0x038A, "8Gb PCI Express Dual Port FC Adapter for POWER(0x1014-0x038A)"},
{0x10DF, 0xF100, 0x103C, 0x3282, "8Gb Dual-port PCI-e FC HBA(0x103C-0x3282)"},
{0x10DF, 0xF100, 0x10DF, 0xF140, "LPe12000-M8-L 1-Port 8Gb PCIe Fibre Channel Adapter(0x10DF-0xF140)"},
{0x10DF, 0xF100, 0x10DF, 0xF141, "LPe12002-M8-L 2-Port 8Gb PCIe Fibre Channel Adapter(0x10DF-0xF141)"},
{0x10DF, 0xF111, 0xFFFF, 0xFFFF, "Saturn-X LightPulse Fibre Channel Host Adapter(0xF111)"},
{0x10DF, 0xF112, 0xFFFF, 0xFFFF, "Saturn-X LightPulse Fibre Channel Host Adapter(0xF112)"},
{0x10DF, 0xF180, 0xFFFF, 0xFFFF, "LPSe12002 EmulexSecure Fibre Channel Adapter(0xF180)"},
{0x10DF, 0xF400, 0xFFFF, 0xFFFF, "LPe35000/LPe36000 Series 32Gb/64Gb Fibre Channel Adapter(0xF400)"},
{0x10DF, 0xF400, 0x10DF, 0xF401, "LPe35000-M2 1-Port 32Gb Fibre Channel Adapter(0x10DF-0xF401)"},
{0x10DF, 0xF400, 0x10DF, 0xF402, "LPe35002-M2 2-Port 32Gb Fibre Channel Adapter(0x10DF-0xF402)"},
{0x10DF, 0xF400, 0x10DF, 0xF403, "LPe36000-M64 1-Port 64Gb Fibre Channel Adapter(0x10DF-0xF403)"},
{0x10DF, 0xF400, 0x10DF, 0xF404, "LPe36002-M64 2-Port 64Gb Fibre Channel Adapter(0x10DF-0xF404)"},
{0x10DF, 0xF400, 0x10DF, 0xF405, "LPe35004-M2 4-Port 32Gb Fibre Channel Adapter(0x10DF-0xF405)"},
{0x10DF, 0xF400, 0x10DF, 0xF406, "LPe35004-X6 4-Port Fibre Channel Adapter(0x10DF-0xF406)"},
{0x10DF, 0xF400, 0x10DF, 0xF410, "LPe35002-M2-D 2-Port 32Gb Fibre Channel Adapter(0x10DF-0xF410)"},
{0x10DF, 0xF400, 0x10DF, 0xF411, "LPe35000-M2-D 1-Port 32Gb Fibre Channel Adapter(0x10DF-0xF411)"},
{0x10DF, 0xF400, 0x10DF, 0xF418, "LPe35000-M2-L 1-Port 32Gb PCIe Fibre Channel Adapter(0x10DF-0xF418)"},
{0x10DF, 0xF400, 0x10DF, 0xF419, "LPe35002-M2-L 2-Port 32Gb PCIe Fibre Channel Adapter(0x10DF-0xF419)"},
{0x10DF, 0xF400, 0x10DF, 0xF421, "LPe36002-M2-L 2-Port 64Gb PCIe Fibre Channel Adapter(0x10DF-0xF421)"},
{0x10DF, 0xF400, 0x10DF, 0xF422, "LPe36002-M64-D 2-Port 64Gb Fibre Channel Adapter(0x10DF-0xF422)"},
{0x10DF, 0xF400, 0x1590, 0x02D5, "StoreFabric SN1610E 1-Port 32Gb Fibre Channel Adapter(0x1590-0x02D5)"},
{0x10DF, 0xF400, 0x1590, 0x02D6, "StoreFabric SN1610E 2-Port 32Gb Fibre Channel Adapter(0x1590-0x02D6)"},
{0x10DF, 0xF500, 0xFFFF, 0xFFFF, "LPe37000/LPe38000 Series 32Gb/64Gb Fibre Channel Adapter(0xF500)"},
{0x10DF, 0xF500, 0x1014, 0x06C1, "PCIe4 4-Port 32Gb Fibre Channel Adapter for POWER (FC EN1L/EN1M; CCIN 2CFC)(0x1014-0x06C1)"},
{0x10DF, 0xF500, 0x1014, 0x06C2, "PCIe4 2-Port 64Gb Fibre Channel Adapter for POWER (FC EN1N/EN1P; CCIN 2CFD)(0x1014-0x06C2)"},
{0x10DF, 0xF500, 0x1590, 0x0454, "Synergy 5331C 32Gb Fibre Channel Host Bus Adapter(0x1590-0x0454)"},
{0x10DF, 0xF600, 0xFFFF, 0xFFFF, "LPe37100S/LPe38100S Series 32Gb/64Gb Fibre Channel Adapter(0xF600)"},
{0x10DF, 0xF700, 0xFFFF, 0xFFFF, "LP7000 Fibre Channel Host Adapter(0xF700)"},
{0x10DF, 0xF701, 0xFFFF, 0xFFFF, "LP7000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)(0xF701)"},
{0x10DF, 0xF800, 0xFFFF, 0xFFFF, "LP8000 Fibre Channel Host Adapter(0xF800)"},
{0x10DF, 0xF801, 0xFFFF, 0xFFFF, "LP8000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)(0xF801)"},
{0x10DF, 0xF900, 0xFFFF, 0xFFFF, "LP9000 Fibre Channel Host Adapter(0xF900)"},
{0x10DF, 0xF901, 0xFFFF, 0xFFFF, "LP9000 Fibre Channel Host Adapter Alternate ID (JX1:2-3, JX2:1-2)(0xF901)"},
{0x10DF, 0xF980, 0xFFFF, 0xFFFF, "LP9802 Fibre Channel Host Adapter(0xF980)"},
{0x10DF, 0xF981, 0xFFFF, 0xFFFF, "LP9802 Fibre Channel Host Adapter Alternate ID(0xF981)"},
{0x10DF, 0xF982, 0xFFFF, 0xFFFF, "LP9802 Fibre Channel Host Adapter Alternate ID(0xF982)"},
{0x10DF, 0xFA00, 0xFFFF, 0xFFFF, "Thor-X LightPulse Fibre Channel Host Adapter(0xFA00)"},
{0x10DF, 0xFB00, 0xFFFF, 0xFFFF, "Viper LightPulse Fibre Channel Host Adapter(0xFB00)"},
{0x10DF, 0xFC00, 0xFFFF, 0xFFFF, "Thor-X LightPulse Fibre Channel Host Adapter(0xFC00)"},
{0x10DF, 0xFC00, 0x10DF, 0xFC00, "LP10000 LightPulse Fibre Channel Host Adapter(0x10DF-0xFC00)"},
{0x10DF, 0xFC10, 0xFFFF, 0xFFFF, "Helios-X LightPulse Fibre Channel Host Adapter(0xFC10)"},
{0x10DF, 0xFC20, 0xFFFF, 0xFFFF, "Zephyr-X LightPulse Fibre Channel Host Adapter(0xFC20)"},
{0x10DF, 0xFC40, 0xFFFF, 0xFFFF, "Saturn-X: LightPulse Fibre Channel Host Adapter(0xFC40)"},
{0x10DF, 0xFC50, 0xFFFF, 0xFFFF, "Proteus-X: LightPulse IOV Fibre Channel Host Adapter(0xFC50)"},
{0x10DF, 0xFD00, 0xFFFF, 0xFFFF, "Helios-X LightPulse Fibre Channel Host Adapter(0xFD00)"},
{0x10DF, 0xFD00, 0x10DF, 0xFD02, "LightPulse LP11002 Dual-port 4Gigabit PCI Fibre Channel Adapter(0x10DF-0xFD02)"},
{0x10DF, 0xFD11, 0xFFFF, 0xFFFF, "Helios-X LightPulse Fibre Channel Host Adapter(0xFD11)"},
{0x10DF, 0xFD12, 0xFFFF, 0xFFFF, "Helios-X LightPulse Fibre Channel Host Adapter(0xFD12)"},
{0x10DF, 0xFE00, 0xFFFF, 0xFFFF, "Zephyr-X LightPulse Fibre Channel Host Adapter(0xFE00)"},
{0x10DF, 0xFE05, 0xFFFF, 0xFFFF, "Zephyr-X: LightPulse FCoE Adapter(0xFE05)"},
{0x10DF, 0xFE11, 0xFFFF, 0xFFFF, "Zephyr-X LightPulse Fibre Channel Host Adapter(0xFE11)"},
{0x10DF, 0xFE12, 0xFFFF, 0xFFFF, "Zephyr-X LightPulse FCoE Adapter(0xFE12)"},
{0x10DF, 0xFF00, 0xFFFF, 0xFFFF, "Neptune LightPulse Fibre Channel Host Adapter(0xFF00)"},
}; /* pci_vid_10DF[] */

static pci_id_t const pci_vid_10E0[] = {
{0x10E0, 0xFFFF, 0xFFFF, 0xFFFF, "Integrated Micro Solutions Inc.(0x10E0)"},
{0x10E0, 0x5026, 0xFFFF, 0xFFFF, "IMS5026/27/28(0x5026)"},
{0x10E0, 0x5027, 0xFFFF, 0xFFFF, "IMS5027(0x5027)"},
{0x10E0, 0x5028, 0xFFFF, 0xFFFF, "IMS5028(0x5028)"},
{0x10E0, 0x8849, 0xFFFF, 0xFFFF, "IMS8849(0x8849)"},
{0x10E0, 0x8853, 0xFFFF, 0xFFFF, "IMS8853(0x8853)"},
{0x10E0, 0x9128, 0xFFFF, 0xFFFF, "IMS9128 [Twin turbo 128](0x9128)"},
}; /* pci_vid_10E0[] */

static pci_id_t const pci_vid_10E1[] = {
{0x10E1, 0xFFFF, 0xFFFF, 0xFFFF, "Tekram Technology Co.,Ltd.(0x10E1)"},
{0x10E1, 0x0391, 0xFFFF, 0xFFFF, "TRM-S1040(0x0391)"},
{0x10E1, 0x0391, 0x10E1, 0x0391, "DC-315U SCSI-3 Host Adapter(0x10E1-0x0391)"},
{0x10E1, 0x690C, 0xFFFF, 0xFFFF, "DC-690c(0x690C)"},
{0x10E1, 0xDC29, 0xFFFF, 0xFFFF, "DC-290(0xDC29)"},
}; /* pci_vid_10E1[] */

static pci_id_t const pci_vid_10E2[] = {
{0x10E2, 0xFFFF, 0xFFFF, 0xFFFF, "Aptix Corporation(0x10E2)"},
}; /* pci_vid_10E2[] */

static pci_id_t const pci_vid_10E3[] = {
{0x10E3, 0xFFFF, 0xFFFF, 0xFFFF, "Tundra Semiconductor Corp.(0x10E3)"},
{0x10E3, 0x0000, 0xFFFF, 0xFFFF, "CA91C042 [Universe](0x0000)"},
{0x10E3, 0x0108, 0xFFFF, 0xFFFF, "Tsi108 Host Bridge for Single PowerPC(0x0108)"},
{0x10E3, 0x0148, 0xFFFF, 0xFFFF, "Tsi148 [Tempe](0x0148)"},
{0x10E3, 0x0148, 0x1775, 0x1100, "VR11 Single Board Computer(0x1775-0x1100)"},
{0x10E3, 0x0860, 0xFFFF, 0xFFFF, "CA91C860 [QSpan](0x0860)"},
{0x10E3, 0x0862, 0xFFFF, 0xFFFF, "CA91C862A [QSpan-II](0x0862)"},
{0x10E3, 0x8111, 0xFFFF, 0xFFFF, "Tsi381 PCIe to PCI Bridge(0x8111)"},
{0x10E3, 0x8113, 0xFFFF, 0xFFFF, "89HPEB383 PCIe-to-PCI Bridge(0x8113)"},
{0x10E3, 0x8260, 0xFFFF, 0xFFFF, "CA91L8200B [Dual PCI PowerSpan II](0x8260)"},
{0x10E3, 0x8261, 0xFFFF, 0xFFFF, "CA91L8260B [Single PCI PowerSpan II](0x8261)"},
{0x10E3, 0xA108, 0xFFFF, 0xFFFF, "Tsi109 Host Bridge for Dual PowerPC(0xA108)"},
}; /* pci_vid_10E3[] */

static pci_id_t const pci_vid_10E4[] = {
{0x10E4, 0xFFFF, 0xFFFF, 0xFFFF, "Tandem Computers(0x10E4)"},
{0x10E4, 0x8029, 0xFFFF, 0xFFFF, "Realtek 8029 Network Card(0x8029)"},
}; /* pci_vid_10E4[] */

static pci_id_t const pci_vid_10E5[] = {
{0x10E5, 0xFFFF, 0xFFFF, 0xFFFF, "Micro Industries Corporation(0x10E5)"},
}; /* pci_vid_10E5[] */

static pci_id_t const pci_vid_10E6[] = {
{0x10E6, 0xFFFF, 0xFFFF, 0xFFFF, "Gainbery Computer Products Inc.(0x10E6)"},
}; /* pci_vid_10E6[] */

static pci_id_t const pci_vid_10E7[] = {
{0x10E7, 0xFFFF, 0xFFFF, 0xFFFF, "Vadem(0x10E7)"},
}; /* pci_vid_10E7[] */

static pci_id_t const pci_vid_10E8[] = {
{0x10E8, 0xFFFF, 0xFFFF, 0xFFFF, "Applied Micro Circuits Corp.(0x10E8)"},
{0x10E8, 0x1072, 0xFFFF, 0xFFFF, "INES GPIB-PCI (AMCC5920 based)(0x1072)"},
{0x10E8, 0x2011, 0xFFFF, 0xFFFF, "Q-Motion Video Capture/Edit board(0x2011)"},
{0x10E8, 0x4750, 0xFFFF, 0xFFFF, "S5930 [Matchmaker](0x4750)"},
{0x10E8, 0x5920, 0xFFFF, 0xFFFF, "S5920(0x5920)"},
{0x10E8, 0x801D, 0xFFFF, 0xFFFF, "Roper Scientific PCI TAXI interface(0x801D)"},
{0x10E8, 0x8043, 0xFFFF, 0xFFFF, "LANai4.x [Myrinet LANai interface chip](0x8043)"},
{0x10E8, 0x8062, 0xFFFF, 0xFFFF, "S5933_PARASTATION(0x8062)"},
{0x10E8, 0x807D, 0xFFFF, 0xFFFF, "S5933 [Matchmaker](0x807D)"},
{0x10E8, 0x8081, 0xFFFF, 0xFFFF, "GPIB interface card [IOtech Inc. PCI488](0x8081)"},
{0x10E8, 0x8088, 0xFFFF, 0xFFFF, "Kongsberg Spacetec Format Synchronizer(0x8088)"},
{0x10E8, 0x8089, 0xFFFF, 0xFFFF, "Kongsberg Spacetec Serial Output Board(0x8089)"},
{0x10E8, 0x809C, 0xFFFF, 0xFFFF, "S5933_HEPC3(0x809C)"},
{0x10E8, 0x80B9, 0xFFFF, 0xFFFF, "Harmonix Hi-Card P8 (4x active ISDN BRI)(0x80B9)"},
{0x10E8, 0x80D7, 0xFFFF, 0xFFFF, "PCI-9112(0x80D7)"},
{0x10E8, 0x80D8, 0xFFFF, 0xFFFF, "PCI-7200(0x80D8)"},
{0x10E8, 0x80D9, 0xFFFF, 0xFFFF, "PCI-9118(0x80D9)"},
{0x10E8, 0x80DA, 0xFFFF, 0xFFFF, "PCI-9812(0x80DA)"},
{0x10E8, 0x80FC, 0xFFFF, 0xFFFF, "APCI1500 Signal processing controller (16 dig. inputs + 16 dig. outputs)(0x80FC)"},
{0x10E8, 0x811A, 0xFFFF, 0xFFFF, "PCI-IEEE1355-DS-DE Interface(0x811A)"},
{0x10E8, 0x814C, 0xFFFF, 0xFFFF, "Fastcom ESCC-PCI (Commtech, Inc.)(0x814C)"},
{0x10E8, 0x8170, 0xFFFF, 0xFFFF, "S5933 [Matchmaker] (Chipset Development Tool)(0x8170)"},
{0x10E8, 0x81E6, 0xFFFF, 0xFFFF, "Multimedia video controller(0x81E6)"},
{0x10E8, 0x828D, 0xFFFF, 0xFFFF, "APCI3001 Signal processing controller (up to 16 analog inputs)(0x828D)"},
{0x10E8, 0x8291, 0xFFFF, 0xFFFF, "Fastcom 232/8-PCI (Commtech, Inc.)(0x8291)"},
{0x10E8, 0x82C4, 0xFFFF, 0xFFFF, "Fastcom 422/4-PCI (Commtech, Inc.)(0x82C4)"},
{0x10E8, 0x82C5, 0xFFFF, 0xFFFF, "Fastcom 422/2-PCI (Commtech, Inc.)(0x82C5)"},
{0x10E8, 0x82C6, 0xFFFF, 0xFFFF, "Fastcom IG422/1-PCI (Commtech, Inc.)(0x82C6)"},
{0x10E8, 0x82C7, 0xFFFF, 0xFFFF, "Fastcom IG232/2-PCI (Commtech, Inc.)(0x82C7)"},
{0x10E8, 0x82CA, 0xFFFF, 0xFFFF, "Fastcom 232/4-PCI (Commtech, Inc.)(0x82CA)"},
{0x10E8, 0x82DB, 0xFFFF, 0xFFFF, "AJA HDNTV HD SDI Framestore(0x82DB)"},
{0x10E8, 0x82E2, 0xFFFF, 0xFFFF, "Fastcom DIO24H-PCI (Commtech, Inc.)(0x82E2)"},
{0x10E8, 0x8406, 0xFFFF, 0xFFFF, "PCIcanx/PCIcan CAN interface [Kvaser AB](0x8406)"},
{0x10E8, 0x8407, 0xFFFF, 0xFFFF, "PCIcan II CAN interface (A1021, PCB-07, PCB-08) [Kvaser AB](0x8407)"},
{0x10E8, 0x8851, 0xFFFF, 0xFFFF, "S5933 on Innes Corp FM Radio Capture card(0x8851)"},
{0x10E8, 0xE004, 0xFFFF, 0xFFFF, "X-Gene PCIe bridge(0xE004)"},
}; /* pci_vid_10E8[] */

static pci_id_t const pci_vid_10E9[] = {
{0x10E9, 0xFFFF, 0xFFFF, 0xFFFF, "Alps Electric Co., Ltd.(0x10E9)"},
}; /* pci_vid_10E9[] */

static pci_id_t const pci_vid_10EA[] = {
{0x10EA, 0xFFFF, 0xFFFF, 0xFFFF, "Integraphics(0x10EA)"},
{0x10EA, 0x1680, 0xFFFF, 0xFFFF, "IGA-1680(0x1680)"},
{0x10EA, 0x1682, 0xFFFF, 0xFFFF, "IGA-1682(0x1682)"},
{0x10EA, 0x1683, 0xFFFF, 0xFFFF, "IGA-1683(0x1683)"},
{0x10EA, 0x2000, 0xFFFF, 0xFFFF, "CyberPro 2000(0x2000)"},
{0x10EA, 0x2010, 0xFFFF, 0xFFFF, "CyberPro 2000A(0x2010)"},
{0x10EA, 0x5000, 0xFFFF, 0xFFFF, "CyberPro 5000(0x5000)"},
{0x10EA, 0x5050, 0xFFFF, 0xFFFF, "CyberPro 5050(0x5050)"},
{0x10EA, 0x5202, 0xFFFF, 0xFFFF, "CyberPro 5202(0x5202)"},
{0x10EA, 0x5252, 0xFFFF, 0xFFFF, "CyberPro5252(0x5252)"},
}; /* pci_vid_10EA[] */

static pci_id_t const pci_vid_10EB[] = {
{0x10EB, 0xFFFF, 0xFFFF, 0xFFFF, "Artists Graphics(0x10EB)"},
{0x10EB, 0x0101, 0xFFFF, 0xFFFF, "3GA(0x0101)"},
{0x10EB, 0x8111, 0xFFFF, 0xFFFF, "Twist3 Frame Grabber(0x8111)"},
}; /* pci_vid_10EB[] */

static pci_id_t const pci_vid_10EC[] = {
{0x10EC, 0xFFFF, 0xFFFF, 0xFFFF, "Realtek Semiconductor Co., Ltd.(0x10EC)"},
{0x10EC, 0x0139, 0xFFFF, 0xFFFF, "RTL-8139/8139C/8139C+ Ethernet Controller(0x0139)"},
{0x10EC, 0x2600, 0xFFFF, 0xFFFF, "Killer E2600 GbE Controller(0x2600)"},
{0x10EC, 0x3000, 0xFFFF, 0xFFFF, "Killer E3000 2.5GbE Controller(0x3000)"},
{0x10EC, 0x4321, 0xFFFF, 0xFFFF, "RTL8852BE 802.11ax PCIe Wireless Network Adapter(0x4321)"},
{0x10EC, 0x5208, 0xFFFF, 0xFFFF, "RTS5208 PCI Express Card Reader(0x5208)"},
{0x10EC, 0x5209, 0xFFFF, 0xFFFF, "RTS5209 PCI Express Card Reader(0x5209)"},
{0x10EC, 0x5227, 0xFFFF, 0xFFFF, "RTS5227 PCI Express Card Reader(0x5227)"},
{0x10EC, 0x5227, 0x17AA, 0x220E, "ThinkPad T440p(0x17AA-0x220E)"},
{0x10EC, 0x5227, 0x17AA, 0x2214, 