# git stripspace

> Read text (e.g. commit messages, notes, tags, and branch descriptions) from `stdin` and clean it into the manner used by Git.
> More information: <https://git-scm.com/docs/git-stripspace>.

- Trim whitespace from a file:

`cat {{path/to/file}} | git stripspace`

- Trim whitespace and Git comments from a file:

`cat {{path/to/file}} | git stripspace {{[-s|--strip-comments]}}`

- Convert all lines in a file into Git comments:

`git < {{path/to/file}} stripspace {{[-c|--comment-lines]}}`
