#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  INIT_UNDEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  FAKE_USE,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_ABDS,
  G_ABDU,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_FMAXIMUM,
  G_ATOMICRMW_FMINIMUM,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_ATOMICRMW_USUB_COND,
  G_ATOMICRMW_USUB_SAT,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_TRUNC_SSAT_S,
  G_TRUNC_SSAT_U,
  G_TRUNC_USAT_U,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FPTOSI_SAT,
  G_FPTOUI_SAT,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_FMINIMUMNUM,
  G_FMAXIMUMNUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_GET_ROUNDING,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_STEP_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FSINCOS,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FATAN2,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ADJCALLSTACKDOWN,
  ADJCALLSTACKUP,
  BuildPairF64Pseudo,
  G_CLZW,
  G_CTZW,
  G_DIVUW,
  G_DIVW,
  G_FCLASS,
  G_FCVT_WU_RV64,
  G_FCVT_W_RV64,
  G_READ_VLENB,
  G_REMUW,
  G_ROLW,
  G_RORW,
  G_SLLW,
  G_SPLAT_VECTOR_SPLIT_I64_VL,
  G_SRAW,
  G_SRLW,
  G_VMCLR_VL,
  G_VMSET_VL,
  G_VMV_V_V_VL,
  G_VSLIDEDOWN_VL,
  G_VSLIDEUP_VL,
  HWASAN_CHECK_MEMACCESS_SHORTGRANULES,
  KCFI_CHECK,
  PROBED_STACKALLOC,
  PROBED_STACKALLOC_DYN,
  PROBED_STACKALLOC_RVV,
  PseudoAddTPRel,
  PseudoAtomicLoadNand32,
  PseudoAtomicLoadNand64,
  PseudoBR,
  PseudoBRIND,
  PseudoBRINDNonX7,
  PseudoBRINDX7,
  PseudoCALL,
  PseudoCALLIndirect,
  PseudoCALLIndirectNonX7,
  PseudoCALLIndirectX7,
  PseudoCALLReg,
  PseudoCCADD,
  PseudoCCADDI,
  PseudoCCADDIW,
  PseudoCCADDW,
  PseudoCCAND,
  PseudoCCANDI,
  PseudoCCANDN,
  PseudoCCMOVGPR,
  PseudoCCMOVGPRNoX0,
  PseudoCCNDS_BFOS,
  PseudoCCNDS_BFOZ,
  PseudoCCOR,
  PseudoCCORI,
  PseudoCCORN,
  PseudoCCSLL,
  PseudoCCSLLI,
  PseudoCCSLLIW,
  PseudoCCSLLW,
  PseudoCCSRA,
  PseudoCCSRAI,
  PseudoCCSRAIW,
  PseudoCCSRAW,
  PseudoCCSRL,
  PseudoCCSRLI,
  PseudoCCSRLIW,
  PseudoCCSRLW,
  PseudoCCSUB,
  PseudoCCSUBW,
  PseudoCCXNOR,
  PseudoCCXOR,
  PseudoCCXORI,
  PseudoC_ADDI_NOP,
  PseudoCmpXchg32,
  PseudoCmpXchg64,
  PseudoFLD,
  PseudoFLH,
  PseudoFLQ,
  PseudoFLW,
  PseudoFROUND_D,
  PseudoFROUND_D_IN32X,
  PseudoFROUND_D_INX,
  PseudoFROUND_H,
  PseudoFROUND_H_INX,
  PseudoFROUND_S,
  PseudoFROUND_S_INX,
  PseudoFSD,
  PseudoFSH,
  PseudoFSQ,
  PseudoFSW,
  PseudoJump,
  PseudoLA,
  PseudoLAImm,
  PseudoLA_TLSDESC,
  PseudoLA_TLS_GD,
  PseudoLA_TLS_IE,
  PseudoLB,
  PseudoLBU,
  PseudoLD,
  PseudoLD_RV32,
  PseudoLGA,
  PseudoLH,
  PseudoLHU,
  PseudoLI,
  PseudoLLA,
  PseudoLLAImm,
  PseudoLW,
  PseudoLWU,
  PseudoLongBEQ,
  PseudoLongBGE,
  PseudoLongBGEU,
  PseudoLongBLT,
  PseudoLongBLTU,
  PseudoLongBNE,
  PseudoLongQC_BEQI,
  PseudoLongQC_BGEI,
  PseudoLongQC_BGEUI,
  PseudoLongQC_BLTI,
  PseudoLongQC_BLTUI,
  PseudoLongQC_BNEI,
  PseudoLongQC_E_BEQI,
  PseudoLongQC_E_BGEI,
  PseudoLongQC_E_BGEUI,
  PseudoLongQC_E_BLTI,
  PseudoLongQC_E_BLTUI,
  PseudoLongQC_E_BNEI,
  PseudoMV_FPR16INX,
  PseudoMV_FPR32INX,
  PseudoMaskedAtomicLoadAdd32,
  PseudoMaskedAtomicLoadMax32,
  PseudoMaskedAtomicLoadMin32,
  PseudoMaskedAtomicLoadNand32,
  PseudoMaskedAtomicLoadSub32,
  PseudoMaskedAtomicLoadUMax32,
  PseudoMaskedAtomicLoadUMin32,
  PseudoMaskedAtomicSwap32,
  PseudoMaskedCmpXchg32,
  PseudoMovAddr,
  PseudoMovImm,
  PseudoNDS_VD4DOTSU_VV_M1,
  PseudoNDS_VD4DOTSU_VV_M1_MASK,
  PseudoNDS_VD4DOTSU_VV_M2,
  PseudoNDS_VD4DOTSU_VV_M2_MASK,
  PseudoNDS_VD4DOTSU_VV_M4,
  PseudoNDS_VD4DOTSU_VV_M4_MASK,
  PseudoNDS_VD4DOTSU_VV_M8,
  PseudoNDS_VD4DOTSU_VV_M8_MASK,
  PseudoNDS_VD4DOTSU_VV_MF2,
  PseudoNDS_VD4DOTSU_VV_MF2_MASK,
  PseudoNDS_VD4DOTS_VV_M1,
  PseudoNDS_VD4DOTS_VV_M1_MASK,
  PseudoNDS_VD4DOTS_VV_M2,
  PseudoNDS_VD4DOTS_VV_M2_MASK,
  PseudoNDS_VD4DOTS_VV_M4,
  PseudoNDS_VD4DOTS_VV_M4_MASK,
  PseudoNDS_VD4DOTS_VV_M8,
  PseudoNDS_VD4DOTS_VV_M8_MASK,
  PseudoNDS_VD4DOTS_VV_MF2,
  PseudoNDS_VD4DOTS_VV_MF2_MASK,
  PseudoNDS_VD4DOTU_VV_M1,
  PseudoNDS_VD4DOTU_VV_M1_MASK,
  PseudoNDS_VD4DOTU_VV_M2,
  PseudoNDS_VD4DOTU_VV_M2_MASK,
  PseudoNDS_VD4DOTU_VV_M4,
  PseudoNDS_VD4DOTU_VV_M4_MASK,
  PseudoNDS_VD4DOTU_VV_M8,
  PseudoNDS_VD4DOTU_VV_M8_MASK,
  PseudoNDS_VD4DOTU_VV_MF2,
  PseudoNDS_VD4DOTU_VV_MF2_MASK,
  PseudoNDS_VFNCVT_BF16_S_M1,
  PseudoNDS_VFNCVT_BF16_S_M2,
  PseudoNDS_VFNCVT_BF16_S_M4,
  PseudoNDS_VFNCVT_BF16_S_MF2,
  PseudoNDS_VFNCVT_BF16_S_MF4,
  PseudoNDS_VFPMADB_VFPR16_M1,
  PseudoNDS_VFPMADB_VFPR16_M1_MASK,
  PseudoNDS_VFPMADB_VFPR16_M2,
  PseudoNDS_VFPMADB_VFPR16_M2_MASK,
  PseudoNDS_VFPMADB_VFPR16_M4,
  PseudoNDS_VFPMADB_VFPR16_M4_MASK,
  PseudoNDS_VFPMADB_VFPR16_M8,
  PseudoNDS_VFPMADB_VFPR16_M8_MASK,
  PseudoNDS_VFPMADB_VFPR16_MF2,
  PseudoNDS_VFPMADB_VFPR16_MF2_MASK,
  PseudoNDS_VFPMADB_VFPR16_MF4,
  PseudoNDS_VFPMADB_VFPR16_MF4_MASK,
  PseudoNDS_VFPMADT_VFPR16_M1,
  PseudoNDS_VFPMADT_VFPR16_M1_MASK,
  PseudoNDS_VFPMADT_VFPR16_M2,
  PseudoNDS_VFPMADT_VFPR16_M2_MASK,
  PseudoNDS_VFPMADT_VFPR16_M4,
  PseudoNDS_VFPMADT_VFPR16_M4_MASK,
  PseudoNDS_VFPMADT_VFPR16_M8,
  PseudoNDS_VFPMADT_VFPR16_M8_MASK,
  PseudoNDS_VFPMADT_VFPR16_MF2,
  PseudoNDS_VFPMADT_VFPR16_MF2_MASK,
  PseudoNDS_VFPMADT_VFPR16_MF4,
  PseudoNDS_VFPMADT_VFPR16_MF4_MASK,
  PseudoNDS_VFWCVT_S_BF16_M1,
  PseudoNDS_VFWCVT_S_BF16_M2,
  PseudoNDS_VFWCVT_S_BF16_M4,
  PseudoNDS_VFWCVT_S_BF16_MF2,
  PseudoNDS_VFWCVT_S_BF16_MF4,
  PseudoNDS_VLN8_V_M1,
  PseudoNDS_VLN8_V_M1_MASK,
  PseudoNDS_VLN8_V_M2,
  PseudoNDS_VLN8_V_M2_MASK,
  PseudoNDS_VLN8_V_M4,
  PseudoNDS_VLN8_V_M4_MASK,
  PseudoNDS_VLN8_V_M8,
  PseudoNDS_VLN8_V_M8_MASK,
  PseudoNDS_VLN8_V_MF2,
  PseudoNDS_VLN8_V_MF2_MASK,
  PseudoNDS_VLN8_V_MF4,
  PseudoNDS_VLN8_V_MF4_MASK,
  PseudoNDS_VLN8_V_MF8,
  PseudoNDS_VLN8_V_MF8_MASK,
  PseudoNDS_VLNU8_V_M1,
  PseudoNDS_VLNU8_V_M1_MASK,
  PseudoNDS_VLNU8_V_M2,
  PseudoNDS_VLNU8_V_M2_MASK,
  PseudoNDS_VLNU8_V_M4,
  PseudoNDS_VLNU8_V_M4_MASK,
  PseudoNDS_VLNU8_V_M8,
  PseudoNDS_VLNU8_V_M8_MASK,
  PseudoNDS_VLNU8_V_MF2,
  PseudoNDS_VLNU8_V_MF2_MASK,
  PseudoNDS_VLNU8_V_MF4,
  PseudoNDS_VLNU8_V_MF4_MASK,
  PseudoNDS_VLNU8_V_MF8,
  PseudoNDS_VLNU8_V_MF8_MASK,
  PseudoQC_E_LB,
  PseudoQC_E_LBU,
  PseudoQC_E_LH,
  PseudoQC_E_LHU,
  PseudoQC_E_LW,
  PseudoQC_E_SB,
  PseudoQC_E_SH,
  PseudoQC_E_SW,
  PseudoQuietFLE_D,
  PseudoQuietFLE_D_IN32X,
  PseudoQuietFLE_D_INX,
  PseudoQuietFLE_H,
  PseudoQuietFLE_H_INX,
  PseudoQuietFLE_S,
  PseudoQuietFLE_S_INX,
  PseudoQuietFLT_D,
  PseudoQuietFLT_D_IN32X,
  PseudoQuietFLT_D_INX,
  PseudoQuietFLT_H,
  PseudoQuietFLT_H_INX,
  PseudoQuietFLT_S,
  PseudoQuietFLT_S_INX,
  PseudoRET,
  PseudoRI_VEXTRACT_M1,
  PseudoRI_VEXTRACT_M2,
  PseudoRI_VEXTRACT_M4,
  PseudoRI_VEXTRACT_M8,
  PseudoRI_VEXTRACT_MF2,
  PseudoRI_VEXTRACT_MF4,
  PseudoRI_VEXTRACT_MF8,
  PseudoRI_VINSERT_M1,
  PseudoRI_VINSERT_M2,
  PseudoRI_VINSERT_M4,
  PseudoRI_VINSERT_M8,
  PseudoRI_VINSERT_MF2,
  PseudoRI_VINSERT_MF4,
  PseudoRI_VINSERT_MF8,
  PseudoRI_VUNZIP2A_VV_M1,
  PseudoRI_VUNZIP2A_VV_M1_MASK,
  PseudoRI_VUNZIP2A_VV_M2,
  PseudoRI_VUNZIP2A_VV_M2_MASK,
  PseudoRI_VUNZIP2A_VV_M4,
  PseudoRI_VUNZIP2A_VV_M4_MASK,
  PseudoRI_VUNZIP2A_VV_M8,
  PseudoRI_VUNZIP2A_VV_M8_MASK,
  PseudoRI_VUNZIP2A_VV_MF2,
  PseudoRI_VUNZIP2A_VV_MF2_MASK,
  PseudoRI_VUNZIP2A_VV_MF4,
  PseudoRI_VUNZIP2A_VV_MF4_MASK,
  PseudoRI_VUNZIP2A_VV_MF8,
  PseudoRI_VUNZIP2A_VV_MF8_MASK,
  PseudoRI_VUNZIP2B_VV_M1,
  PseudoRI_VUNZIP2B_VV_M1_MASK,
  PseudoRI_VUNZIP2B_VV_M2,
  PseudoRI_VUNZIP2B_VV_M2_MASK,
  PseudoRI_VUNZIP2B_VV_M4,
  PseudoRI_VUNZIP2B_VV_M4_MASK,
  PseudoRI_VUNZIP2B_VV_M8,
  PseudoRI_VUNZIP2B_VV_M8_MASK,
  PseudoRI_VUNZIP2B_VV_MF2,
  PseudoRI_VUNZIP2B_VV_MF2_MASK,
  PseudoRI_VUNZIP2B_VV_MF4,
  PseudoRI_VUNZIP2B_VV_MF4_MASK,
  PseudoRI_VUNZIP2B_VV_MF8,
  PseudoRI_VUNZIP2B_VV_MF8_MASK,
  PseudoRI_VZIP2A_VV_M1,
  PseudoRI_VZIP2A_VV_M1_MASK,
  PseudoRI_VZIP2A_VV_M2,
  PseudoRI_VZIP2A_VV_M2_MASK,
  PseudoRI_VZIP2A_VV_M4,
  PseudoRI_VZIP2A_VV_M4_MASK,
  PseudoRI_VZIP2A_VV_M8,
  PseudoRI_VZIP2A_VV_M8_MASK,
  PseudoRI_VZIP2A_VV_MF2,
  PseudoRI_VZIP2A_VV_MF2_MASK,
  PseudoRI_VZIP2A_VV_MF4,
  PseudoRI_VZIP2A_VV_MF4_MASK,
  PseudoRI_VZIP2A_VV_MF8,
  PseudoRI_VZIP2A_VV_MF8_MASK,
  PseudoRI_VZIP2B_VV_M1,
  PseudoRI_VZIP2B_VV_M1_MASK,
  PseudoRI_VZIP2B_VV_M2,
  PseudoRI_VZIP2B_VV_M2_MASK,
  PseudoRI_VZIP2B_VV_M4,
  PseudoRI_VZIP2B_VV_M4_MASK,
  PseudoRI_VZIP2B_VV_M8,
  PseudoRI_VZIP2B_VV_M8_MASK,
  PseudoRI_VZIP2B_VV_MF2,
  PseudoRI_VZIP2B_VV_MF2_MASK,
  PseudoRI_VZIP2B_VV_MF4,
  PseudoRI_VZIP2B_VV_MF4_MASK,
  PseudoRI_VZIP2B_VV_MF8,
  PseudoRI_VZIP2B_VV_MF8_MASK,
  PseudoRI_VZIPEVEN_VV_M1,
  PseudoRI_VZIPEVEN_VV_M1_MASK,
  PseudoRI_VZIPEVEN_VV_M2,
  PseudoRI_VZIPEVEN_VV_M2_MASK,
  PseudoRI_VZIPEVEN_VV_M4,
  PseudoRI_VZIPEVEN_VV_M4_MASK,
  PseudoRI_VZIPEVEN_VV_M8,
  PseudoRI_VZIPEVEN_VV_M8_MASK,
  PseudoRI_VZIPEVEN_VV_MF2,
  PseudoRI_VZIPEVEN_VV_MF2_MASK,
  PseudoRI_VZIPEVEN_VV_MF4,
  PseudoRI_VZIPEVEN_VV_MF4_MASK,
  PseudoRI_VZIPEVEN_VV_MF8,
  PseudoRI_VZIPEVEN_VV_MF8_MASK,
  PseudoRI_VZIPODD_VV_M1,
  PseudoRI_VZIPODD_VV_M1_MASK,
  PseudoRI_VZIPODD_VV_M2,
  PseudoRI_VZIPODD_VV_M2_MASK,
  PseudoRI_VZIPODD_VV_M4,
  PseudoRI_VZIPODD_VV_M4_MASK,
  PseudoRI_VZIPODD_VV_M8,
  PseudoRI_VZIPODD_VV_M8_MASK,
  PseudoRI_VZIPODD_VV_MF2,
  PseudoRI_VZIPODD_VV_MF2_MASK,
  PseudoRI_VZIPODD_VV_MF4,
  PseudoRI_VZIPODD_VV_MF4_MASK,
  PseudoRI_VZIPODD_VV_MF8,
  PseudoRI_VZIPODD_VV_MF8_MASK,
  PseudoRV32ZdinxLD,
  PseudoRV32ZdinxSD,
  PseudoReadVL,
  PseudoReadVLENB,
  PseudoReadVLENBViaVSETVLIX0,
  PseudoSB,
  PseudoSD,
  PseudoSD_RV32,
  PseudoSEXT_B,
  PseudoSEXT_H,
  PseudoSF_VC_FPR16VV_SE_M1,
  PseudoSF_VC_FPR16VV_SE_M2,
  PseudoSF_VC_FPR16VV_SE_M4,
  PseudoSF_VC_FPR16VV_SE_M8,
  PseudoSF_VC_FPR16VV_SE_MF2,
  PseudoSF_VC_FPR16VV_SE_MF4,
  PseudoSF_VC_FPR16VW_SE_M1,
  PseudoSF_VC_FPR16VW_SE_M2,
  PseudoSF_VC_FPR16VW_SE_M4,
  PseudoSF_VC_FPR16VW_SE_M8,
  PseudoSF_VC_FPR16VW_SE_MF2,
  PseudoSF_VC_FPR16VW_SE_MF4,
  PseudoSF_VC_FPR16V_SE_M1,
  PseudoSF_VC_FPR16V_SE_M2,
  PseudoSF_VC_FPR16V_SE_M4,
  PseudoSF_VC_FPR16V_SE_M8,
  PseudoSF_VC_FPR16V_SE_MF2,
  PseudoSF_VC_FPR16V_SE_MF4,
  PseudoSF_VC_FPR32VV_SE_M1,
  PseudoSF_VC_FPR32VV_SE_M2,
  PseudoSF_VC_FPR32VV_SE_M4,
  PseudoSF_VC_FPR32VV_SE_M8,
  PseudoSF_VC_FPR32VV_SE_MF2,
  PseudoSF_VC_FPR32VW_SE_M1,
  PseudoSF_VC_FPR32VW_SE_M2,
  PseudoSF_VC_FPR32VW_SE_M4,
  PseudoSF_VC_FPR32VW_SE_M8,
  PseudoSF_VC_FPR32VW_SE_MF2,
  PseudoSF_VC_FPR32V_SE_M1,
  PseudoSF_VC_FPR32V_SE_M2,
  PseudoSF_VC_FPR32V_SE_M4,
  PseudoSF_VC_FPR32V_SE_M8,
  PseudoSF_VC_FPR32V_SE_MF2,
  PseudoSF_VC_FPR64VV_SE_M1,
  PseudoSF_VC_FPR64VV_SE_M2,
  PseudoSF_VC_FPR64VV_SE_M4,
  PseudoSF_VC_FPR64VV_SE_M8,
  PseudoSF_VC_FPR64V_SE_M1,
  PseudoSF_VC_FPR64V_SE_M2,
  PseudoSF_VC_FPR64V_SE_M4,
  PseudoSF_VC_FPR64V_SE_M8,
  PseudoSF_VC_IVV_SE_M1,
  PseudoSF_VC_IVV_SE_M2,
  PseudoSF_VC_IVV_SE_M4,
  PseudoSF_VC_IVV_SE_M8,
  PseudoSF_VC_IVV_SE_MF2,
  PseudoSF_VC_IVV_SE_MF4,
  PseudoSF_VC_IVV_SE_MF8,
  PseudoSF_VC_IVW_SE_M1,
  PseudoSF_VC_IVW_SE_M2,
  PseudoSF_VC_IVW_SE_M4,
  PseudoSF_VC_IVW_SE_MF2,
  PseudoSF_VC_IVW_SE_MF4,
  PseudoSF_VC_IVW_SE_MF8,
  PseudoSF_VC_IV_SE_M1,
  PseudoSF_VC_IV_SE_M2,
  PseudoSF_VC_IV_SE_M4,
  PseudoSF_VC_IV_SE_M8,
  PseudoSF_VC_IV_SE_MF2,
  PseudoSF_VC_IV_SE_MF4,
  PseudoSF_VC_IV_SE_MF8,
  PseudoSF_VC_I_SE_M1,
  PseudoSF_VC_I_SE_M2,
  PseudoSF_VC_I_SE_M4,
  PseudoSF_VC_I_SE_M8,
  PseudoSF_VC_I_SE_MF2,
  PseudoSF_VC_I_SE_MF4,
  PseudoSF_VC_I_SE_MF8,
  PseudoSF_VC_VVV_SE_M1,
  PseudoSF_VC_VVV_SE_M2,
  PseudoSF_VC_VVV_SE_M4,
  PseudoSF_VC_VVV_SE_M8,
  PseudoSF_VC_VVV_SE_MF2,
  PseudoSF_VC_VVV_SE_MF4,
  PseudoSF_VC_VVV_SE_MF8,
  PseudoSF_VC_VVW_SE_M1,
  PseudoSF_VC_VVW_SE_M2,
  PseudoSF_VC_VVW_SE_M4,
  PseudoSF_VC_VVW_SE_MF2,
  PseudoSF_VC_VVW_SE_MF4,
  PseudoSF_VC_VVW_SE_MF8,
  PseudoSF_VC_VV_SE_M1,
  PseudoSF_VC_VV_SE_M2,
  PseudoSF_VC_VV_SE_M4,
  PseudoSF_VC_VV_SE_M8,
  PseudoSF_VC_VV_SE_MF2,
  PseudoSF_VC_VV_SE_MF4,
  PseudoSF_VC_VV_SE_MF8,
  PseudoSF_VC_V_FPR16VV_M1,
  PseudoSF_VC_V_FPR16VV_M2,
  PseudoSF_VC_V_FPR16VV_M4,
  PseudoSF_VC_V_FPR16VV_M8,
  PseudoSF_VC_V_FPR16VV_MF2,
  PseudoSF_VC_V_FPR16VV_MF4,
  PseudoSF_VC_V_FPR16VV_SE_M1,
  PseudoSF_VC_V_FPR16VV_SE_M2,
  PseudoSF_VC_V_FPR16VV_SE_M4,
  PseudoSF_VC_V_FPR16VV_SE_M8,
  PseudoSF_VC_V_FPR16VV_SE_MF2,
  PseudoSF_VC_V_FPR16VV_SE_MF4,
  PseudoSF_VC_V_FPR16VW_M1,
  PseudoSF_VC_V_FPR16VW_M2,
  PseudoSF_VC_V_FPR16VW_M4,
  PseudoSF_VC_V_FPR16VW_M8,
  PseudoSF_VC_V_FPR16VW_MF2,
  PseudoSF_VC_V_FPR16VW_MF4,
  PseudoSF_VC_V_FPR16VW_SE_M1,
  PseudoSF_VC_V_FPR16VW_SE_M2,
  PseudoSF_VC_V_FPR16VW_SE_M4,
  PseudoSF_VC_V_FPR16VW_SE_M8,
  PseudoSF_VC_V_FPR16VW_SE_MF2,
  PseudoSF_VC_V_FPR16VW_SE_MF4,
  PseudoSF_VC_V_FPR16V_M1,
  PseudoSF_VC_V_FPR16V_M2,
  PseudoSF_VC_V_FPR16V_M4,
  PseudoSF_VC_V_FPR16V_M8,
  PseudoSF_VC_V_FPR16V_MF2,
  PseudoSF_VC_V_FPR16V_MF4,
  PseudoSF_VC_V_FPR16V_SE_M1,
  PseudoSF_VC_V_FPR16V_SE_M2,
  PseudoSF_VC_V_FPR16V_SE_M4,
  PseudoSF_VC_V_FPR16V_SE_M8,
  PseudoSF_VC_V_FPR16V_SE_MF2,
  PseudoSF_VC_V_FPR16V_SE_MF4,
  PseudoSF_VC_V_FPR32VV_M1,
  PseudoSF_VC_V_FPR32VV_M2,
  PseudoSF_VC_V_FPR32VV_M4,
  PseudoSF_VC_V_FPR32VV_M8,
  PseudoSF_VC_V_FPR32VV_MF2,
  PseudoSF_VC_V_FPR32VV_SE_M1,
  PseudoSF_VC_V_FPR32VV_SE_M2,
  PseudoSF_VC_V_FPR32VV_SE_M4,
  PseudoSF_VC_V_FPR32VV_SE_M8,
  PseudoSF_VC_V_FPR32VV_SE_MF2,
  PseudoSF_VC_V_FPR32VW_M1,
  PseudoSF_VC_V_FPR32VW_M2,
  PseudoSF_VC_V_FPR32VW_M4,
  PseudoSF_VC_V_FPR32VW_M8,
  PseudoSF_VC_V_FPR32VW_MF2,
  PseudoSF_VC_V_FPR32VW_SE_M1,
  PseudoSF_VC_V_FPR32VW_SE_M2,
  PseudoSF_VC_V_FPR32VW_SE_M4,
  PseudoSF_VC_V_FPR32VW_SE_M8,
  PseudoSF_VC_V_FPR32VW_SE_MF2,
  PseudoSF_VC_V_FPR32V_M1,
  PseudoSF_VC_V_FPR32V_M2,
  PseudoSF_VC_V_FPR32V_M4,
  PseudoSF_VC_V_FPR32V_M8,
  PseudoSF_VC_V_FPR32V_MF2,
  PseudoSF_VC_V_FPR32V_SE_M1,
  PseudoSF_VC_V_FPR32V_SE_M2,
  PseudoSF_VC_V_FPR32V_SE_M4,
  PseudoSF_VC_V_FPR32V_SE_M8,
  PseudoSF_VC_V_FPR32V_SE_MF2,
  PseudoSF_VC_V_FPR64VV_M1,
  PseudoSF_VC_V_FPR64VV_M2,
  PseudoSF_VC_V_FPR64VV_M4,
  PseudoSF_VC_V_FPR64VV_M8,
  PseudoSF_VC_V_FPR64VV_SE_M1,
  PseudoSF_VC_V_FPR64VV_SE_M2,
  PseudoSF_VC_V_FPR64VV_SE_M4,
  PseudoSF_VC_V_FPR64VV_SE_M8,
  PseudoSF_VC_V_FPR64V_M1,
  PseudoSF_VC_V_FPR64V_M2,
  PseudoSF_VC_V_FPR64V_M4,
  PseudoSF_VC_V_FPR64V_M8,
  PseudoSF_VC_V_FPR64V_SE_M1,
  PseudoSF_VC_V_FPR64V_SE_M2,
  PseudoSF_VC_V_FPR64V_SE_M4,
  PseudoSF_VC_V_FPR64V_SE_M8,
  PseudoSF_VC_V_IVV_M1,
  PseudoSF_VC_V_IVV_M2,
  PseudoSF_VC_V_IVV_M4,
  PseudoSF_VC_V_IVV_M8,
  PseudoSF_VC_V_IVV_MF2,
  PseudoSF_VC_V_IVV_MF4,
  PseudoSF_VC_V_IVV_MF8,
  PseudoSF_VC_V_IVV_SE_M1,
  PseudoSF_VC_V_IVV_SE_M2,
  PseudoSF_VC_V_IVV_SE_M4,
  PseudoSF_VC_V_IVV_SE_M8,
  PseudoSF_VC_V_IVV_SE_MF2,
  PseudoSF_VC_V_IVV_SE_MF4,
  PseudoSF_VC_V_IVV_SE_MF8,
  PseudoSF_VC_V_IVW_M1,
  PseudoSF_VC_V_IVW_M2,
  PseudoSF_VC_V_IVW_M4,
  PseudoSF_VC_V_IVW_MF2,
  PseudoSF_VC_V_IVW_MF4,
  PseudoSF_VC_V_IVW_MF8,
  PseudoSF_VC_V_IVW_SE_M1,
  PseudoSF_VC_V_IVW_SE_M2,
  PseudoSF_VC_V_IVW_SE_M4,
  PseudoSF_VC_V_IVW_SE_MF2,
  PseudoSF_VC_V_IVW_SE_MF4,
  PseudoSF_VC_V_IVW_SE_MF8,
  PseudoSF_VC_V_IV_M1,
  PseudoSF_VC_V_IV_M2,
  PseudoSF_VC_V_IV_M4,
  PseudoSF_VC_V_IV_M8,
  PseudoSF_VC_V_IV_MF2,
  PseudoSF_VC_V_IV_MF4,
  PseudoSF_VC_V_IV_MF8,
  PseudoSF_VC_V_IV_SE_M1,
  PseudoSF_VC_V_IV_SE_M2,
  PseudoSF_VC_V_IV_SE_M4,
  PseudoSF_VC_V_IV_SE_M8,
  PseudoSF_VC_V_IV_SE_MF2,
  PseudoSF_VC_V_IV_SE_MF4,
  PseudoSF_VC_V_IV_SE_MF8,
  PseudoSF_VC_V_I_M1,
  PseudoSF_VC_V_I_M2,
  PseudoSF_VC_V_I_M4,
  PseudoSF_VC_V_I_M8,
  PseudoSF_VC_V_I_MF2,
  PseudoSF_VC_V_I_MF4,
  PseudoSF_VC_V_I_MF8,
  PseudoSF_VC_V_I_SE_M1,
  PseudoSF_VC_V_I_SE_M2,
  PseudoSF_VC_V_I_SE_M4,
  PseudoSF_VC_V_I_SE_M8,
  PseudoSF_VC_V_I_SE_MF2,
  PseudoSF_VC_V_I_SE_MF4,
  PseudoSF_VC_V_I_SE_MF8,
  PseudoSF_VC_V_VVV_M1,
  PseudoSF_VC_V_VVV_M2,
  PseudoSF_VC_V_VVV_M4,
  PseudoSF_VC_V_VVV_M8,
  PseudoSF_VC_V_VVV_MF2,
  PseudoSF_VC_V_VVV_MF4,
  PseudoSF_VC_V_VVV_MF8,
  PseudoSF_VC_V_VVV_SE_M1,
  PseudoSF_VC_V_VVV_SE_M2,
  PseudoSF_VC_V_VVV_SE_M4,
  PseudoSF_VC_V_VVV_SE_M8,
  PseudoSF_VC_V_VVV_SE_MF2,
  PseudoSF_VC_V_VVV_SE_MF4,
  PseudoSF_VC_V_VVV_SE_MF8,
  PseudoSF_VC_V_VVW_M1,
  PseudoSF_VC_V_VVW_M2,
  PseudoSF_VC_V_VVW_M4,
  PseudoSF_VC_V_VVW_MF2,
  PseudoSF_VC_V_VVW_MF4,
  PseudoSF_VC_V_VVW_MF8,
  PseudoSF_VC_V_VVW_SE_M1,
  PseudoSF_VC_V_VVW_SE_M2,
  PseudoSF_VC_V_VVW_SE_M4,
  PseudoSF_VC_V_VVW_SE_MF2,
  PseudoSF_VC_V_VVW_SE_MF4,
  PseudoSF_VC_V_VVW_SE_MF8,
  PseudoSF_VC_V_VV_M1,
  PseudoSF_VC_V_VV_M2,
  PseudoSF_VC_V_VV_M4,
  PseudoSF_VC_V_VV_M8,
  PseudoSF_VC_V_VV_MF2,
  PseudoSF_VC_V_VV_MF4,
  PseudoSF_VC_V_VV_MF8,
  PseudoSF_VC_V_VV_SE_M1,
  PseudoSF_VC_V_VV_SE_M2,
  PseudoSF_VC_V_VV_SE_M4,
  PseudoSF_VC_V_VV_SE_M8,
  PseudoSF_VC_V_VV_SE_MF2,
  PseudoSF_VC_V_VV_SE_MF4,
  PseudoSF_VC_V_VV_SE_MF8,
  PseudoSF_VC_V_XVV_M1,
  PseudoSF_VC_V_XVV_M2,
  PseudoSF_VC_V_XVV_M4,
  PseudoSF_VC_V_XVV_M8,
  PseudoSF_VC_V_XVV_MF2,
  PseudoSF_VC_V_XVV_MF4,
  PseudoSF_VC_V_XVV_MF8,
  PseudoSF_VC_V_XVV_SE_M1,
  PseudoSF_VC_V_XVV_SE_M2,
  PseudoSF_VC_V_XVV_SE_M4,
  PseudoSF_VC_V_XVV_SE_M8,
  PseudoSF_VC_V_XVV_SE_MF2,
  PseudoSF_VC_V_XVV_SE_MF4,
  PseudoSF_VC_V_XVV_SE_MF8,
  PseudoSF_VC_V_XVW_M1,
  PseudoSF_VC_V_XVW_M2,
  PseudoSF_VC_V_XVW_M4,
  PseudoSF_VC_V_XVW_MF2,
  PseudoSF_VC_V_XVW_MF4,
  PseudoSF_VC_V_XVW_MF8,
  PseudoSF_VC_V_XVW_SE_M1,
  PseudoSF_VC_V_XVW_SE_M2,
  PseudoSF_VC_V_XVW_SE_M4,
  PseudoSF_VC_V_XVW_SE_MF2,
  PseudoSF_VC_V_XVW_SE_MF4,
  PseudoSF_VC_V_XVW_SE_MF8,
  PseudoSF_VC_V_XV_M1,
  PseudoSF_VC_V_XV_M2,
  PseudoSF_VC_V_XV_M4,
  PseudoSF_VC_V_XV_M8,
  PseudoSF_VC_V_XV_MF2,
  PseudoSF_VC_V_XV_MF4,
  PseudoSF_VC_V_XV_MF8,
  PseudoSF_VC_V_XV_SE_M1,
  PseudoSF_VC_V_XV_SE_M2,
  PseudoSF_VC_V_XV_SE_M4,
  PseudoSF_VC_V_XV_SE_M8,
  PseudoSF_VC_V_XV_SE_MF2,
  PseudoSF_VC_V_XV_SE_MF4,
  PseudoSF_VC_V_XV_SE_MF8,
  PseudoSF_VC_V_X_M1,
  PseudoSF_VC_V_X_M2,
  PseudoSF_VC_V_X_M4,
  PseudoSF_VC_V_X_M8,
  PseudoSF_VC_V_X_MF2,
  PseudoSF_VC_V_X_MF4,
  PseudoSF_VC_V_X_MF8,
  PseudoSF_VC_V_X_SE_M1,
  PseudoSF_VC_V_X_SE_M2,
  PseudoSF_VC_V_X_SE_M4,
  PseudoSF_VC_V_X_SE_M8,
  PseudoSF_VC_V_X_SE_MF2,
  PseudoSF_VC_V_X_SE_MF4,
  PseudoSF_VC_V_X_SE_MF8,
  PseudoSF_VC_XVV_SE_M1,
  PseudoSF_VC_XVV_SE_M2,
  PseudoSF_VC_XVV_SE_M4,
  PseudoSF_VC_XVV_SE_M8,
  PseudoSF_VC_XVV_SE_MF2,
  PseudoSF_VC_XVV_SE_MF4,
  PseudoSF_VC_XVV_SE_MF8,
  PseudoSF_VC_XVW_SE_M1,
  PseudoSF_VC_XVW_SE_M2,
  PseudoSF_VC_XVW_SE_M4,
  PseudoSF_VC_XVW_SE_MF2,
  PseudoSF_VC_XVW_SE_MF4,
  PseudoSF_VC_XVW_SE_MF8,
  PseudoSF_VC_XV_SE_M1,
  PseudoSF_VC_XV_SE_M2,
  PseudoSF_VC_XV_SE_M4,
  PseudoSF_VC_XV_SE_M8,
  PseudoSF_VC_XV_SE_MF2,
  PseudoSF_VC_XV_SE_MF4,
  PseudoSF_VC_XV_SE_MF8,
  PseudoSF_VC_X_SE_M1,
  PseudoSF_VC_X_SE_M2,
  PseudoSF_VC_X_SE_M4,
  PseudoSF_VC_X_SE_M8,
  PseudoSF_VC_X_SE_MF2,
  PseudoSF_VC_X_SE_MF4,
  PseudoSF_VC_X_SE_MF8,
  PseudoSF_VFNRCLIP_XU_F_QF_M1,
  PseudoSF_VFNRCLIP_XU_F_QF_M1_MASK,
  PseudoSF_VFNRCLIP_XU_F_QF_M2,
  PseudoSF_VFNRCLIP_XU_F_QF_M2_MASK,
  PseudoSF_VFNRCLIP_XU_F_QF_MF2,
  PseudoSF_VFNRCLIP_XU_F_QF_MF2_MASK,
  PseudoSF_VFNRCLIP_XU_F_QF_MF4,
  PseudoSF_VFNRCLIP_XU_F_QF_MF4_MASK,
  PseudoSF_VFNRCLIP_XU_F_QF_MF8,
  PseudoSF_VFNRCLIP_XU_F_QF_MF8_MASK,
  PseudoSF_VFNRCLIP_X_F_QF_M1,
  PseudoSF_VFNRCLIP_X_F_QF_M1_MASK,
  PseudoSF_VFNRCLIP_X_F_QF_M2,
  PseudoSF_VFNRCLIP_X_F_QF_M2_MASK,
  PseudoSF_VFNRCLIP_X_F_QF_MF2,
  PseudoSF_VFNRCLIP_X_F_QF_MF2_MASK,
  PseudoSF_VFNRCLIP_X_F_QF_MF4,
  PseudoSF_VFNRCLIP_X_F_QF_MF4_MASK,
  PseudoSF_VFNRCLIP_X_F_QF_MF8,
  PseudoSF_VFNRCLIP_X_F_QF_MF8_MASK,
  PseudoSF_VFWMACC_4x4x4_M1,
  PseudoSF_VFWMACC_4x4x4_M2,
  PseudoSF_VFWMACC_4x4x4_M4,
  PseudoSF_VFWMACC_4x4x4_MF2,
  PseudoSF_VFWMACC_4x4x4_MF4,
  PseudoSF_VQMACCSU_2x8x2_M1,
  PseudoSF_VQMACCSU_2x8x2_M2,
  PseudoSF_VQMACCSU_2x8x2_M4,
  PseudoSF_VQMACCSU_2x8x2_M8,
  PseudoSF_VQMACCSU_4x8x4_M1,
  PseudoSF_VQMACCSU_4x8x4_M2,
  PseudoSF_VQMACCSU_4x8x4_M4,
  PseudoSF_VQMACCSU_4x8x4_MF2,
  PseudoSF_VQMACCUS_2x8x2_M1,
  PseudoSF_VQMACCUS_2x8x2_M2,
  PseudoSF_VQMACCUS_2x8x2_M4,
  PseudoSF_VQMACCUS_2x8x2_M8,
  PseudoSF_VQMACCUS_4x8x4_M1,
  PseudoSF_VQMACCUS_4x8x4_M2,
  PseudoSF_VQMACCUS_4x8x4_M4,
  PseudoSF_VQMACCUS_4x8x4_MF2,
  PseudoSF_VQMACCU_2x8x2_M1,
  PseudoSF_VQMACCU_2x8x2_M2,
  PseudoSF_VQMACCU_2x8x2_M4,
  PseudoSF_VQMACCU_2x8x2_M8,
  PseudoSF_VQMACCU_4x8x4_M1,
  PseudoSF_VQMACCU_4x8x4_M2,
  PseudoSF_VQMACCU_4x8x4_M4,
  PseudoSF_VQMACCU_4x8x4_MF2,
  PseudoSF_VQMACC_2x8x2_M1,
  PseudoSF_VQMACC_2x8x2_M2,
  PseudoSF_VQMACC_2x8x2_M4,
  PseudoSF_VQMACC_2x8x2_M8,
  PseudoSF_VQMACC_4x8x4_M1,
  PseudoSF_VQMACC_4x8x4_M2,
  PseudoSF_VQMACC_4x8x4_M4,
  PseudoSF_VQMACC_4x8x4_MF2,
  PseudoSH,
  PseudoSW,
  PseudoTAIL,
  PseudoTAILIndirect,
  PseudoTAILIndirectNonX7,
  PseudoTAILIndirectX7,
  PseudoTH_VMAQASU_VV_M1,
  PseudoTH_VMAQASU_VV_M1_MASK,
  PseudoTH_VMAQASU_VV_M2,
  PseudoTH_VMAQASU_VV_M2_MASK,
  PseudoTH_VMAQASU_VV_M4,
  PseudoTH_VMAQASU_VV_M4_MASK,
  PseudoTH_VMAQASU_VV_M8,
  PseudoTH_VMAQASU_VV_M8_MASK,
  PseudoTH_VMAQASU_VV_MF2,
  PseudoTH_VMAQASU_VV_MF2_MASK,
  PseudoTH_VMAQASU_VX_M1,
  PseudoTH_VMAQASU_VX_M1_MASK,
  PseudoTH_VMAQASU_VX_M2,
  PseudoTH_VMAQASU_VX_M2_MASK,
  PseudoTH_VMAQASU_VX_M4,
  PseudoTH_VMAQASU_VX_M4_MASK,
  PseudoTH_VMAQASU_VX_M8,
  PseudoTH_VMAQASU_VX_M8_MASK,
  PseudoTH_VMAQASU_VX_MF2,
  PseudoTH_VMAQASU_VX_MF2_MASK,
  PseudoTH_VMAQAUS_VX_M1,
  PseudoTH_VMAQAUS_VX_M1_MASK,
  PseudoTH_VMAQAUS_VX_M2,
  PseudoTH_VMAQAUS_VX_M2_MASK,
  PseudoTH_VMAQAUS_VX_M4,
  PseudoTH_VMAQAUS_VX_M4_MASK,
  PseudoTH_VMAQAUS_VX_M8,
  PseudoTH_VMAQAUS_VX_M8_MASK,
  PseudoTH_VMAQAUS_VX_MF2,
  PseudoTH_VMAQAUS_VX_MF2_MASK,
  PseudoTH_VMAQAU_VV_M1,
  PseudoTH_VMAQAU_VV_M1_MASK,
  PseudoTH_VMAQAU_VV_M2,
  PseudoTH_VMAQAU_VV_M2_MASK,
  PseudoTH_VMAQAU_VV_M4,
  PseudoTH_VMAQAU_VV_M4_MASK,
  PseudoTH_VMAQAU_VV_M8,
  PseudoTH_VMAQAU_VV_M8_MASK,
  PseudoTH_VMAQAU_VV_MF2,
  PseudoTH_VMAQAU_VV_MF2_MASK,
  PseudoTH_VMAQAU_VX_M1,
  PseudoTH_VMAQAU_VX_M1_MASK,
  PseudoTH_VMAQAU_VX_M2,
  PseudoTH_VMAQAU_VX_M2_MASK,
  PseudoTH_VMAQAU_VX_M4,
  PseudoTH_VMAQAU_VX_M4_MASK,
  PseudoTH_VMAQAU_VX_M8,
  PseudoTH_VMAQAU_VX_M8_MASK,
  PseudoTH_VMAQAU_VX_MF2,
  PseudoTH_VMAQAU_VX_MF2_MASK,
  PseudoTH_VMAQA_VV_M1,
  PseudoTH_VMAQA_VV_M1_MASK,
  PseudoTH_VMAQA_VV_M2,
  PseudoTH_VMAQA_VV_M2_MASK,
  PseudoTH_VMAQA_VV_M4,
  PseudoTH_VMAQA_VV_M4_MASK,
  PseudoTH_VMAQA_VV_M8,
  PseudoTH_VMAQA_VV_M8_MASK,
  PseudoTH_VMAQA_VV_MF2,
  PseudoTH_VMAQA_VV_MF2_MASK,
  PseudoTH_VMAQA_VX_M1,
  PseudoTH_VMAQA_VX_M1_MASK,
  PseudoTH_VMAQA_VX_M2,
  PseudoTH_VMAQA_VX_M2_MASK,
  PseudoTH_VMAQA_VX_M4,
  PseudoTH_VMAQA_VX_M4_MASK,
  PseudoTH_VMAQA_VX_M8,
  PseudoTH_VMAQA_VX_M8_MASK,
  PseudoTH_VMAQA_VX_MF2,
  PseudoTH_VMAQA_VX_MF2_MASK,
  PseudoTLSDESCCall,
  PseudoVAADDU_VV_M1,
  PseudoVAADDU_VV_M1_MASK,
  PseudoVAADDU_VV_M2,
  PseudoVAADDU_VV_M2_MASK,
  PseudoVAADDU_VV_M4,
  PseudoVAADDU_VV_M4_MASK,
  PseudoVAADDU_VV_M8,
  PseudoVAADDU_VV_M8_MASK,
  PseudoVAADDU_VV_MF2,
  PseudoVAADDU_VV_MF2_MASK,
  PseudoVAADDU_VV_MF4,
  PseudoVAADDU_VV_MF4_MASK,
  PseudoVAADDU_VV_MF8,
  PseudoVAADDU_VV_MF8_MASK,
  PseudoVAADDU_VX_M1,
  PseudoVAADDU_VX_M1_MASK,
  PseudoVAADDU_VX_M2,
  PseudoVAADDU_VX_M2_MASK,
  PseudoVAADDU_VX_M4,
  PseudoVAADDU_VX_M4_MASK,
  PseudoVAADDU_VX_M8,
  PseudoVAADDU_VX_M8_MASK,
  PseudoVAADDU_VX_MF2,
  PseudoVAADDU_VX_MF2_MASK,
  PseudoVAADDU_VX_MF4,
  PseudoVAADDU_VX_MF4_MASK,
  PseudoVAADDU_VX_MF8,
  PseudoVAADDU_VX_MF8_MASK,
  PseudoVAADD_VV_M1,
  PseudoVAADD_VV_M1_MASK,
  PseudoVAADD_VV_M2,
  PseudoVAADD_VV_M2_MASK,
  PseudoVAADD_VV_M4,
  PseudoVAADD_VV_M4_MASK,
  PseudoVAADD_VV_M8,
  PseudoVAADD_VV_M8_MASK,
  PseudoVAADD_VV_MF2,
  PseudoVAADD_VV_MF2_MASK,
  PseudoVAADD_VV_MF4,
  PseudoVAADD_VV_MF4_MASK,
  PseudoVAADD_VV_MF8,
  PseudoVAADD_VV_MF8_MASK,
  PseudoVAADD_VX_M1,
  PseudoVAADD_VX_M1_MASK,
  PseudoVAADD_VX_M2,
  PseudoVAADD_VX_M2_MASK,
  PseudoVAADD_VX_M4,
  PseudoVAADD_VX_M4_MASK,
  PseudoVAADD_VX_M8,
  PseudoVAADD_VX_M8_MASK,
  PseudoVAADD_VX_MF2,
  PseudoVAADD_VX_MF2_MASK,
  PseudoVAADD_VX_MF4,
  PseudoVAADD_VX_MF4_MASK,
  PseudoVAADD_VX_MF8,
  PseudoVAADD_VX_MF8_MASK,
  PseudoVADC_VIM_M1,
  PseudoVADC_VIM_M2,
  PseudoVADC_VIM_M4,
  PseudoVADC_VIM_M8,
  PseudoVADC_VIM_MF2,
  PseudoVADC_VIM_MF4,
  PseudoVADC_VIM_MF8,
  PseudoVADC_VVM_M1,
  PseudoVADC_VVM_M2,
  PseudoVADC_VVM_M4,
  PseudoVADC_VVM_M8,
  PseudoVADC_VVM_MF2,
  PseudoVADC_VVM_MF4,
  PseudoVADC_VVM_MF8,
  PseudoVADC_VXM_M1,
  PseudoVADC_VXM_M2,
  PseudoVADC_VXM_M4,
  PseudoVADC_VXM_M8,
  PseudoVADC_VXM_MF2,
  PseudoVADC_VXM_MF4,
  PseudoVADC_VXM_MF8,
  PseudoVADD_VI_M1,
  PseudoVADD_VI_M1_MASK,
  PseudoVADD_VI_M2,
  PseudoVADD_VI_M2_MASK,
  PseudoVADD_VI_M4,
  PseudoVADD_VI_M4_MASK,
  PseudoVADD_VI_M8,
  PseudoVADD_VI_M8_MASK,
  PseudoVADD_VI_MF2,
  PseudoVADD_VI_MF2_MASK,
  PseudoVADD_VI_MF4,
  PseudoVADD_VI_MF4_MASK,
  PseudoVADD_VI_MF8,
  PseudoVADD_VI_MF8_MASK,
  PseudoVADD_VV_M1,
  PseudoVADD_VV_M1_MASK,
  PseudoVADD_VV_M2,
  PseudoVADD_VV_M2_MASK,
  PseudoVADD_VV_M4,
  PseudoVADD_VV_M4_MASK,
  PseudoVADD_VV_M8,
  PseudoVADD_VV_M8_MASK,
  PseudoVADD_VV_MF2,
  PseudoVADD_VV_MF2_MASK,
  PseudoVADD_VV_MF4,
  PseudoVADD_VV_MF4_MASK,
  PseudoVADD_VV_MF8,
  PseudoVADD_VV_MF8_MASK,
  PseudoVADD_VX_M1,
  PseudoVADD_VX_M1_MASK,
  PseudoVADD_VX_M2,
  PseudoVADD_VX_M2_MASK,
  PseudoVADD_VX_M4,
  PseudoVADD_VX_M4_MASK,
  PseudoVADD_VX_M8,
  PseudoVADD_VX_M8_MASK,
  PseudoVADD_VX_MF2,
  PseudoVADD_VX_MF2_MASK,
  PseudoVADD_VX_MF4,
  PseudoVADD_VX_MF4_MASK,
  PseudoVADD_VX_MF8,
  PseudoVADD_VX_MF8_MASK,
  PseudoVAESDF_VS_M1_M1,
  PseudoVAESDF_VS_M1_MF2,
  PseudoVAESDF_VS_M1_MF4,
  PseudoVAESDF_VS_M1_MF8,
  PseudoVAESDF_VS_M2_M1,
  PseudoVAESDF_VS_M2_M2,
  PseudoVAESDF_VS_M2_MF2,
  PseudoVAESDF_VS_M2_MF4,
  PseudoVAESDF_VS_M2_MF8,
  PseudoVAESDF_VS_M4_M1,
  PseudoVAESDF_VS_M4_M2,
  PseudoVAESDF_VS_M4_M4,
  PseudoVAESDF_VS_M4_MF2,
  PseudoVAESDF_VS_M4_MF4,
  PseudoVAESDF_VS_M4_MF8,
  PseudoVAESDF_VS_M8_M1,
  PseudoVAESDF_VS_M8_M2,
  PseudoVAESDF_VS_M8_M4,
  PseudoVAESDF_VS_M8_MF2,
  PseudoVAESDF_VS_M8_MF4,
  PseudoVAESDF_VS_M8_MF8,
  PseudoVAESDF_VS_MF2_MF2,
  PseudoVAESDF_VS_MF2_MF4,
  PseudoVAESDF_VS_MF2_MF8,
  PseudoVAESDF_VV_M1,
  PseudoVAESDF_VV_M2,
  PseudoVAESDF_VV_M4,
  PseudoVAESDF_VV_M8,
  PseudoVAESDF_VV_MF2,
  PseudoVAESDM_VS_M1_M1,
  PseudoVAESDM_VS_M1_MF2,
  PseudoVAESDM_VS_M1_MF4,
  PseudoVAESDM_VS_M1_MF8,
  PseudoVAESDM_VS_M2_M1,
  PseudoVAESDM_VS_M2_M2,
  PseudoVAESDM_VS_M2_MF2,
  PseudoVAESDM_VS_M2_MF4,
  PseudoVAESDM_VS_M2_MF8,
  PseudoVAESDM_VS_M4_M1,
  PseudoVAESDM_VS_M4_M2,
  PseudoVAESDM_VS_M4_M4,
  PseudoVAESDM_VS_M4_MF2,
  PseudoVAESDM_VS_M4_MF4,
  PseudoVAESDM_VS_M4_MF8,
  PseudoVAESDM_VS_M8_M1,
  PseudoVAESDM_VS_M8_M2,
  PseudoVAESDM_VS_M8_M4,
  PseudoVAESDM_VS_M8_MF2,
  PseudoVAESDM_VS_M8_MF4,
  PseudoVAESDM_VS_M8_MF8,
  PseudoVAESDM_VS_MF2_MF2,
  PseudoVAESDM_VS_MF2_MF4,
  PseudoVAESDM_VS_MF2_MF8,
  PseudoVAESDM_VV_M1,
  PseudoVAESDM_VV_M2,
  PseudoVAESDM_VV_M4,
  PseudoVAESDM_VV_M8,
  PseudoVAESDM_VV_MF2,
  PseudoVAESEF_VS_M1_M1,
  PseudoVAESEF_VS_M1_MF2,
  PseudoVAESEF_VS_M1_MF4,
  PseudoVAESEF_VS_M1_MF8,
  PseudoVAESEF_VS_M2_M1,
  PseudoVAESEF_VS_M2_M2,
  PseudoVAESEF_VS_M2_MF2,
  PseudoVAESEF_VS_M2_MF4,
  PseudoVAESEF_VS_M2_MF8,
  PseudoVAESEF_VS_M4_M1,
  PseudoVAESEF_VS_M4_M2,
  PseudoVAESEF_VS_M4_M4,
  PseudoVAESEF_VS_M4_MF2,
  PseudoVAESEF_VS_M4_MF4,
  PseudoVAESEF_VS_M4_MF8,
  PseudoVAESEF_VS_M8_M1,
  PseudoVAESEF_VS_M8_M2,
  PseudoVAESEF_VS_M8_M4,
  PseudoVAESEF_VS_M8_MF2,
  PseudoVAESEF_VS_M8_MF4,
  PseudoVAESEF_VS_M8_MF8,
  PseudoVAESEF_VS_MF2_MF2,
  PseudoVAESEF_VS_MF2_MF4,
  PseudoVAESEF_VS_MF2_MF8,
  PseudoVAESEF_VV_M1,
  PseudoVAESEF_VV_M2,
  PseudoVAESEF_VV_M4,
  PseudoVAESEF_VV_M8,
  PseudoVAESEF_VV_MF2,
  PseudoVAESEM_VS_M1_M1,
  PseudoVAESEM_VS_M1_MF2,
  PseudoVAESEM_VS_M1_MF4,
  PseudoVAESEM_VS_M1_MF8,
  PseudoVAESEM_VS_M2_M1,
  PseudoVAESEM_VS_M2_M2,
  PseudoVAESEM_VS_M2_MF2,
  PseudoVAESEM_VS_M2_MF4,
  PseudoVAESEM_VS_M2_MF8,
  PseudoVAESEM_VS_M4_M1,
  PseudoVAESEM_VS_M4_M2,
  PseudoVAESEM_VS_M4_M4,
  PseudoVAESEM_VS_M4_MF2,
  PseudoVAESEM_VS_M4_MF4,
  PseudoVAESEM_VS_M4_MF8,
  PseudoVAESEM_VS_M8_M1,
  PseudoVAESEM_VS_M8_M2,
  PseudoVAESEM_VS_M8_M4,
  PseudoVAESEM_VS_M8_MF2,
  PseudoVAESEM_VS_M8_MF4,
  PseudoVAESEM_VS_M8_MF8,
  PseudoVAESEM_VS_MF2_MF2,
  PseudoVAESEM_VS_MF2_MF4,
  PseudoVAESEM_VS_MF2_MF8,
  PseudoVAESEM_VV_M1,
  PseudoVAESEM_VV_M2,
  PseudoVAESEM_VV_M4,
  PseudoVAESEM_VV_M8,
  PseudoVAESEM_VV_MF2,
  PseudoVAESKF1_VI_M1,
  PseudoVAESKF1_VI_M2,
  PseudoVAESKF1_VI_M4,
  PseudoVAESKF1_VI_M8,
  PseudoVAESKF1_VI_MF2,
  PseudoVAESKF2_VI_M1,
  PseudoVAESKF2_VI_M2,
  PseudoVAESKF2_VI_M4,
  PseudoVAESKF2_VI_M8,
  PseudoVAESKF2_VI_MF2,
  PseudoVAESZ_VS_M1_M1,
  PseudoVAESZ_VS_M1_MF2,
  PseudoVAESZ_VS_M1_MF4,
  PseudoVAESZ_VS_M1_MF8,
  PseudoVAESZ_VS_M2_M1,
  PseudoVAESZ_VS_M2_M2,
  PseudoVAESZ_VS_M2_MF2,
  PseudoVAESZ_VS_M2_MF4,
  PseudoVAESZ_VS_M2_MF8,
  PseudoVAESZ_VS_M4_M1,
  PseudoVAESZ_VS_M4_M2,
  PseudoVAESZ_VS_M4_M4,
  PseudoVAESZ_VS_M4_MF2,
  PseudoVAESZ_VS_M4_MF4,
  PseudoVAESZ_VS_M4_MF8,
  PseudoVAESZ_VS_M8_M1,
  PseudoVAESZ_VS_M8_M2,
  PseudoVAESZ_VS_M8_M4,
  PseudoVAESZ_VS_M8_MF2,
  PseudoVAESZ_VS_M8_MF4,
  PseudoVAESZ_VS_M8_MF8,
  PseudoVAESZ_VS_MF2_MF2,
  PseudoVAESZ_VS_MF2_MF4,
  PseudoVAESZ_VS_MF2_MF8,
  PseudoVANDN_VV_M1,
  PseudoVANDN_VV_M1_MASK,
  PseudoVANDN_VV_M2,
  PseudoVANDN_VV_M2_MASK,
  PseudoVANDN_VV_M4,
  PseudoVANDN_VV_M4_MASK,
  PseudoVANDN_VV_M8,
  PseudoVANDN_VV_M8_MASK,
  PseudoVANDN_VV_MF2,
  PseudoVANDN_VV_MF2_MASK,
  PseudoVANDN_VV_MF4,
  PseudoVANDN_VV_MF4_MASK,
  PseudoVANDN_VV_MF8,
  PseudoVANDN_VV_MF8_MASK,
  PseudoVANDN_VX_M1,
  PseudoVANDN_VX_M1_MASK,
  PseudoVANDN_VX_M2,
  PseudoVANDN_VX_M2_MASK,
  PseudoVANDN_VX_M4,
  PseudoVANDN_VX_M4_MASK,
  PseudoVANDN_VX_M8,
  PseudoVANDN_VX_M8_MASK,
  PseudoVANDN_VX_MF2,
  PseudoVANDN_VX_MF2_MASK,
  PseudoVANDN_VX_MF4,
  PseudoVANDN_VX_MF4_MASK,
  PseudoVANDN_VX_MF8,
  PseudoVANDN_VX_MF8_MASK,
  PseudoVAND_VI_M1,
  PseudoVAND_VI_M1_MASK,
  PseudoVAND_VI_M2,
  PseudoVAND_VI_M2_MASK,
  PseudoVAND_VI_M4,
  PseudoVAND_VI_M4_MASK,
  PseudoVAND_VI_M8,
  PseudoVAND_VI_M8_MASK,
  PseudoVAND_VI_MF2,
  PseudoVAND_VI_MF2_MASK,
  PseudoVAND_VI_MF4,
  PseudoVAND_VI_MF4_MASK,
  PseudoVAND_VI_MF8,
  PseudoVAND_VI_MF8_MASK,
  PseudoVAND_VV_M1,
  PseudoVAND_VV_M1_MASK,
  PseudoVAND_VV_M2,
  PseudoVAND_VV_M2_MASK,
  PseudoVAND_VV_M4,
  PseudoVAND_VV_M4_MASK,
  PseudoVAND_VV_M8,
  PseudoVAND_VV_M8_MASK,
  PseudoVAND_VV_MF2,
  PseudoVAND_VV_MF2_MASK,
  PseudoVAND_VV_MF4,
  PseudoVAND_VV_MF4_MASK,
  PseudoVAND_VV_MF8,
  PseudoVAND_VV_MF8_MASK,
  PseudoVAND_VX_M1,
  PseudoVAND_VX_M1_MASK,
  PseudoVAND_VX_M2,
  PseudoVAND_VX_M2_MASK,
  PseudoVAND_VX_M4,
  PseudoVAND_VX_M4_MASK,
  PseudoVAND_VX_M8,
  PseudoVAND_VX_M8_MASK,
  PseudoVAND_VX_MF2,
  PseudoVAND_VX_MF2_MASK,
  PseudoVAND_VX_MF4,
  PseudoVAND_VX_MF4_MASK,
  PseudoVAND_VX_MF8,
  PseudoVAND_VX_MF8_MASK,
  PseudoVASUBU_VV_M1,
  PseudoVASUBU_VV_M1_MASK,
  PseudoVASUBU_VV_M2,
  PseudoVASUBU_VV_M2_MASK,
  PseudoVASUBU_VV_M4,
  PseudoVASUBU_VV_M4_MASK,
  PseudoVASUBU_VV_M8,
  PseudoVASUBU_VV_M8_MASK,
  PseudoVASUBU_VV_MF2,
  PseudoVASUBU_VV_MF2_MASK,
  PseudoVASUBU_VV_MF4,
  PseudoVASUBU_VV_MF4_MASK,
  PseudoVASUBU_VV_MF8,
  PseudoVASUBU_VV_MF8_MASK,
  PseudoVASUBU_VX_M1,
  PseudoVASUBU_VX_M1_MASK,
  PseudoVASUBU_VX_M2,
  PseudoVASUBU_VX_M2_MASK,
  PseudoVASUBU_VX_M4,
  PseudoVASUBU_VX_M4_MASK,
  PseudoVASUBU_VX_M8,
  PseudoVASUBU_VX_M8_MASK,
  PseudoVASUBU_VX_MF2,
  PseudoVASUBU_VX_MF2_MASK,
  PseudoVASUBU_VX_MF4,
  PseudoVASUBU_VX_MF4_MASK,
  PseudoVASUBU_VX_MF8,
  PseudoVASUBU_VX_MF8_MASK,
  PseudoVASUB_VV_M1,
  PseudoVASUB_VV_M1_MASK,
  PseudoVASUB_VV_M2,
  PseudoVASUB_VV_M2_MASK,
  PseudoVASUB_VV_M4,
  PseudoVASUB_VV_M4_MASK,
  PseudoVASUB_VV_M8,
  PseudoVASUB_VV_M8_MASK,
  PseudoVASUB_VV_MF2,
  PseudoVASUB_VV_MF2_MASK,
  PseudoVASUB_VV_MF4,
  PseudoVASUB_VV_MF4_MASK,
  PseudoVASUB_VV_MF8,
  PseudoVASUB_VV_MF8_MASK,
  PseudoVASUB_VX_M1,
  PseudoVASUB_VX_M1_MASK,
  PseudoVASUB_VX_M2,
  PseudoVASUB_VX_M2_MASK,
  PseudoVASUB_VX_M4,
  PseudoVASUB_VX_M4_MASK,
  PseudoVASUB_VX_M8,
  PseudoVASUB_VX_M8_MASK,
  PseudoVASUB_VX_MF2,
  PseudoVASUB_VX_MF2_MASK,
  PseudoVASUB_VX_MF4,
  PseudoVASUB_VX_MF4_MASK,
  PseudoVASUB_VX_MF8,
  PseudoVASUB_VX_MF8_MASK,
  PseudoVBREV8_V_M1,
  PseudoVBREV8_V_M1_MASK,
  PseudoVBREV8_V_M2,
  PseudoVBREV8_V_M2_MASK,
  PseudoVBREV8_V_M4,
  PseudoVBREV8_V_M4_MASK,
  PseudoVBREV8_V_M8,
  PseudoVBREV8_V_M8_MASK,
  PseudoVBREV8_V_MF2,
  PseudoVBREV8_V_MF2_MASK,
  PseudoVBREV8_V_MF4,
  PseudoVBREV8_V_MF4_MASK,
  PseudoVBREV8_V_MF8,
  PseudoVBREV8_V_MF8_MASK,
  PseudoVBREV_V_M1,
  PseudoVBREV_V_M1_MASK,
  PseudoVBREV_V_M2,
  PseudoVBREV_V_M2_MASK,
  PseudoVBREV_V_M4,
  PseudoVBREV_V_M4_MASK,
  PseudoVBREV_V_M8,
  PseudoVBREV_V_M8_MASK,
  PseudoVBREV_V_MF2,
  PseudoVBREV_V_MF2_MASK,
  PseudoVBREV_V_MF4,
  PseudoVBREV_V_MF4_MASK,
  PseudoVBREV_V_MF8,
  PseudoVBREV_V_MF8_MASK,
  PseudoVCLMULH_VV_M1,
  PseudoVCLMULH_VV_M1_MASK,
  PseudoVCLMULH_VV_M2,
  PseudoVCLMULH_VV_M2_MASK,
  PseudoVCLMULH_VV_M4,
  PseudoVCLMULH_VV_M4_MASK,
  PseudoVCLMULH_VV_M8,
  PseudoVCLMULH_VV_M8_MASK,
  PseudoVCLMULH_VV_MF2,
  PseudoVCLMULH_VV_MF2_MASK,
  PseudoVCLMULH_VV_MF4,
  PseudoVCLMULH_VV_MF4_MASK,
  PseudoVCLMULH_VV_MF8,
  PseudoVCLMULH_VV_MF8_MASK,
  PseudoVCLMULH_VX_M1,
  PseudoVCLMULH_VX_M1_MASK,
  PseudoVCLMULH_VX_M2,
  PseudoVCLMULH_VX_M2_MASK,
  PseudoVCLMULH_VX_M4,
  PseudoVCLMULH_VX_M4_MASK,
  PseudoVCLMULH_VX_M8,
  PseudoVCLMULH_VX_M8_MASK,
  PseudoVCLMULH_VX_MF2,
  PseudoVCLMULH_VX_MF2_MASK,
  PseudoVCLMULH_VX_MF4,
  PseudoVCLMULH_VX_MF4_MASK,
  PseudoVCLMULH_VX_MF8,
  PseudoVCLMULH_VX_MF8_MASK,
  PseudoVCLMUL_VV_M1,
  PseudoVCLMUL_VV_M1_MASK,
  PseudoVCLMUL_VV_M2,
  PseudoVCLMUL_VV_M2_MASK,
  PseudoVCLMUL_VV_M4,
  PseudoVCLMUL_VV_M4_MASK,
  PseudoVCLMUL_VV_M8,
  PseudoVCLMUL_VV_M8_MASK,
  PseudoVCLMUL_VV_MF2,
  PseudoVCLMUL_VV_MF2_MASK,
  PseudoVCLMUL_VV_MF4,
  PseudoVCLMUL_VV_MF4_MASK,
  PseudoVCLMUL_VV_MF8,
  PseudoVCLMUL_VV_MF8_MASK,
  PseudoVCLMUL_VX_M1,
  PseudoVCLMUL_VX_M1_MASK,
  PseudoVCLMUL_VX_M2,
  PseudoVCLMUL_VX_M2_MASK,
  PseudoVCLMUL_VX_M4,
  PseudoVCLMUL_VX_M4_MASK,
  PseudoVCLMUL_VX_M8,
  PseudoVCLMUL_VX_M8_MASK,
  PseudoVCLMUL_VX_MF2,
  PseudoVCLMUL_VX_MF2_MASK,
  PseudoVCLMUL_VX_MF4,
  PseudoVCLMUL_VX_MF4_MASK,
  PseudoVCLMUL_VX_MF8,
  PseudoVCLMUL_VX_MF8_MASK,
  PseudoVCLZ_V_M1,
  PseudoVCLZ_V_M1_MASK,
  PseudoVCLZ_V_M2,
  PseudoVCLZ_V_M2_MASK,
  PseudoVCLZ_V_M4,
  PseudoVCLZ_V_M4_MASK,
  PseudoVCLZ_V_M8,
  PseudoVCLZ_V_M8_MASK,
  PseudoVCLZ_V_MF2,
  PseudoVCLZ_V_MF2_MASK,
  PseudoVCLZ_V_MF4,
  PseudoVCLZ_V_MF4_MASK,
  PseudoVCLZ_V_MF8,
  PseudoVCLZ_V_MF8_MASK,
  PseudoVCOMPRESS_VM_M1_E16,
  PseudoVCOMPRESS_VM_M1_E32,
  PseudoVCOMPRESS_VM_M1_E64,
  PseudoVCOMPRESS_VM_M1_E8,
  PseudoVCOMPRESS_VM_M2_E16,
  PseudoVCOMPRESS_VM_M2_E32,
  PseudoVCOMPRESS_VM_M2_E64,
  PseudoVCOMPRESS_VM_M2_E8,
  PseudoVCOMPRESS_VM_M4_E16,
  PseudoVCOMPRESS_VM_M4_E32,
  PseudoVCOMPRESS_VM_M4_E64,
  PseudoVCOMPRESS_VM_M4_E8,
  PseudoVCOMPRESS_VM_M8_E16,
  PseudoVCOMPRESS_VM_M8_E32,
  PseudoVCOMPRESS_VM_M8_E64,
  PseudoVCOMPRESS_VM_M8_E8,
  PseudoVCOMPRESS_VM_MF2_E16,
  PseudoVCOMPRESS_VM_MF2_E32,
  PseudoVCOMPRESS_VM_MF2_E8,
  PseudoVCOMPRESS_VM_MF4_E16,
  PseudoVCOMPRESS_VM_MF4_E8,
  PseudoVCOMPRESS_VM_MF8_E8,
  PseudoVCPOP_M_B1,
  PseudoVCPOP_M_B16,
  PseudoVCPOP_M_B16_MASK,
  PseudoVCPOP_M_B1_MASK,
  PseudoVCPOP_M_B2,
  PseudoVCPOP_M_B2_MASK,
  PseudoVCPOP_M_B32,
  PseudoVCPOP_M_B32_MASK,
  PseudoVCPOP_M_B4,
  PseudoVCPOP_M_B4_MASK,
  PseudoVCPOP_M_B64,
  PseudoVCPOP_M_B64_MASK,
  PseudoVCPOP_M_B8,
  PseudoVCPOP_M_B8_MASK,
  PseudoVCPOP_V_M1,
  PseudoVCPOP_V_M1_MASK,
  PseudoVCPOP_V_M2,
  PseudoVCPOP_V_M2_MASK,
  PseudoVCPOP_V_M4,
  PseudoVCPOP_V_M4_MASK,
  PseudoVCPOP_V_M8,
  PseudoVCPOP_V_M8_MASK,
  PseudoVCPOP_V_MF2,
  PseudoVCPOP_V_MF2_MASK,
  PseudoVCPOP_V_MF4,
  PseudoVCPOP_V_MF4_MASK,
  PseudoVCPOP_V_MF8,
  PseudoVCPOP_V_MF8_MASK,
  PseudoVCTZ_V_M1,
  PseudoVCTZ_V_M1_MASK,
  PseudoVCTZ_V_M2,
  PseudoVCTZ_V_M2_MASK,
  PseudoVCTZ_V_M4,
  PseudoVCTZ_V_M4_MASK,
  PseudoVCTZ_V_M8,
  PseudoVCTZ_V_M8_MASK,
  PseudoVCTZ_V_MF2,
  PseudoVCTZ_V_MF2_MASK,
  PseudoVCTZ_V_MF4,
  PseudoVCTZ_V_MF4_MASK,
  PseudoVCTZ_V_MF8,
  PseudoVCTZ_V_MF8_MASK,
  PseudoVDIVU_VV_M1_E16,
  PseudoVDIVU_VV_M1_E16_MASK,
  PseudoVDIVU_VV_M1_E32,
  PseudoVDIVU_VV_M1_E32_MASK,
  PseudoVDIVU_VV_M1_E64,
  PseudoVDIVU_VV_M1_E64_MASK,
  PseudoVDIVU_VV_M1_E8,
  PseudoVDIVU_VV_M1_E8_MASK,
  PseudoVDIVU_VV_M2_E16,
  PseudoVDIVU_VV_M2_E16_MASK,
  PseudoVDIVU_VV_M2_E32,
  PseudoVDIVU_VV_M2_E32_MASK,
  PseudoVDIVU_VV_M2_E64,
  PseudoVDIVU_VV_M2_E64_MASK,
  PseudoVDIVU_VV_M2_E8,
  PseudoVDIVU_VV_M2_E8_MASK,
  PseudoVDIVU_VV_M4_E16,
  PseudoVDIVU_VV_M4_E16_MASK,
  PseudoVDIVU_VV_M4_E32,
  PseudoVDIVU_VV_M4_E32_MASK,
  PseudoVDIVU_VV_M4_E64,
  PseudoVDIVU_VV_M4_E64_MASK,
  PseudoVDIVU_VV_M4_E8,
  PseudoVDIVU_VV_M4_E8_MASK,
  PseudoVDIVU_VV_M8_E16,
  PseudoVDIVU_VV_M8_E16_MASK,
  PseudoVDIVU_VV_M8_E32,
  PseudoVDIVU_VV_M8_E32_MASK,
  PseudoVDIVU_VV_M8_E64,
  PseudoVDIVU_VV_M8_E64_MASK,
  PseudoVDIVU_VV_M8_E8,
  PseudoVDIVU_VV_M8_E8_MASK,
  PseudoVDIVU_VV_MF2_E16,
  PseudoVDIVU_VV_MF2_E16_MASK,
  PseudoVDIVU_VV_MF2_E32,
  PseudoVDIVU_VV_MF2_E32_MASK,
  PseudoVDIVU_VV_MF2_E8,
  PseudoVDIVU_VV_MF2_E8_MASK,
  PseudoVDIVU_VV_MF4_E16,
  PseudoVDIVU_VV_MF4_E16_MASK,
  PseudoVDIVU_VV_MF4_E8,
  PseudoVDIVU_VV_MF4_E8_MASK,
  PseudoVDIVU_VV_MF8_E8,
  PseudoVDIVU_VV_MF8_E8_MASK,
  PseudoVDIVU_VX_M1_E16,
  PseudoVDIVU_VX_M1_E16_MASK,
  PseudoVDIVU_VX_M1_E32,
  PseudoVDIVU_VX_M1_E32_MASK,
  PseudoVDIVU_VX_M1_E64,
  PseudoVDIVU_VX_M1_E64_MASK,
  PseudoVDIVU_VX_M1_E8,
  PseudoVDIVU_VX_M1_E8_MASK,
  PseudoVDIVU_VX_M2_E16,
  PseudoVDIVU_VX_M2_E16_MASK,
  PseudoVDIVU_VX_M2_E32,
  PseudoVDIVU_VX_M2_E32_MASK,
  PseudoVDIVU_VX_M2_E64,
  PseudoVDIVU_VX_M2_E64_MASK,
  PseudoVDIVU_VX_M2_E8,
  PseudoVDIVU_VX_M2_E8_MASK,
  PseudoVDIVU_VX_M4_E16,
  PseudoVDIVU_VX_M4_E16_MASK,
  PseudoVDIVU_VX_M4_E32,
  PseudoVDIVU_VX_M4_E32_MASK,
  PseudoVDIVU_VX_M4_E64,
  PseudoVDIVU_VX_M4_E64_MASK,
  PseudoVDIVU_VX_M4_E8,
  PseudoVDIVU_VX_M4_E8_MASK,
  PseudoVDIVU_VX_M8_E16,
  PseudoVDIVU_VX_M8_E16_MASK,
  PseudoVDIVU_VX_M8_E32,
  PseudoVDIVU_VX_M8_E32_MASK,
  PseudoVDIVU_VX_M8_E64,
  PseudoVDIVU_VX_M8_E64_MASK,
  PseudoVDIVU_VX_M8_E8,
  PseudoVDIVU_VX_M8_E8_MASK,
  PseudoVDIVU_VX_MF2_E16,
  PseudoVDIVU_VX_MF2_E16_MASK,
  PseudoVDIVU_VX_MF2_E32,
  PseudoVDIVU_VX_MF2_E32_MASK,
  PseudoVDIVU_VX_MF2_E8,
  PseudoVDIVU_VX_MF2_E8_MASK,
  PseudoVDIVU_VX_MF4_E16,
  PseudoVDIVU_VX_MF4_E16_MASK,
  PseudoVDIVU_VX_MF4_E8,
  PseudoVDIVU_VX_MF4_E8_MASK,
  PseudoVDIVU_VX_MF8_E8,
  PseudoVDIVU_VX_MF8_E8_MASK,
  PseudoVDIV_VV_M1_E16,
  PseudoVDIV_VV_M1_E16_MASK,
  PseudoVDIV_VV_M1_E32,
  PseudoVDIV_VV_M1_E32_MASK,
  PseudoVDIV_VV_M1_E64,
  PseudoVDIV_VV_M1_E64_MASK,
  PseudoVDIV_VV_M1_E8,
  PseudoVDIV_VV_M1_E8_MASK,
  PseudoVDIV_VV_M2_E16,
  PseudoVDIV_VV_M2_E16_MASK,
  PseudoVDIV_VV_M2_E32,
  PseudoVDIV_VV_M2_E32_MASK,
  PseudoVDIV_VV_M2_E64,
  PseudoVDIV_VV_M2_E64_MASK,
  PseudoVDIV_VV_M2_E8,
  PseudoVDIV_VV_M2_E8_MASK,
  PseudoVDIV_VV_M4_E16,
  PseudoVDIV_VV_M4_E16_MASK,
  PseudoVDIV_VV_M4_E32,
  PseudoVDIV_VV_M4_E32_MASK,
  PseudoVDIV_VV_M4_E64,
  PseudoVDIV_VV_M4_E64_MASK,
  PseudoVDIV_VV_M4_E8,
  PseudoVDIV_VV_M4_E8_MASK,
  PseudoVDIV_VV_M8_E16,
  PseudoVDIV_VV_M8_E16_MASK,
  PseudoVDIV_VV_M8_E32,
  PseudoVDIV_VV_M8_E32_MASK,
  PseudoVDIV_VV_M8_E64,
  PseudoVDIV_VV_M8_E64_MASK,
  PseudoVDIV_VV_M8_E8,
  PseudoVDIV_VV_M8_E8_MASK,
  PseudoVDIV_VV_MF2_E16,
  PseudoVDIV_VV_MF2_E16_MASK,
  PseudoVDIV_VV_MF2_E32,
  PseudoVDIV_VV_MF2_E32_MASK,
  PseudoVDIV_VV_MF2_E8,
  PseudoVDIV_VV_MF2_E8_MASK,
  PseudoVDIV_VV_MF4_E16,
  PseudoVDIV_VV_MF4_E16_MASK,
  PseudoVDIV_VV_MF4_E8,
  PseudoVDIV_VV_MF4_E8_MASK,
  PseudoVDIV_VV_MF8_E8,
  PseudoVDIV_VV_MF8_E8_MASK,
  PseudoVDIV_VX_M1_E16,
  PseudoVDIV_VX_M1_E16_MASK,
  PseudoVDIV_VX_M1_E32,
  PseudoVDIV_VX_M1_E32_MASK,
  PseudoVDIV_VX_M1_E64,
  PseudoVDIV_VX_M1_E64_MASK,
  PseudoVDIV_VX_M1_E8,
  PseudoVDIV_VX_M1_E8_MASK,
  PseudoVDIV_VX_M2_E16,
  PseudoVDIV_VX_M2_E16_MASK,
  PseudoVDIV_VX_M2_E32,
  PseudoVDIV_VX_M2_E32_MASK,
  PseudoVDIV_VX_M2_E64,
  PseudoVDIV_VX_M2_E64_MASK,
  PseudoVDIV_VX_M2_E8,
  PseudoVDIV_VX_M2_E8_MASK,
  PseudoVDIV_VX_M4_E16,
  PseudoVDIV_VX_M4_E16_MASK,
  PseudoVDIV_VX_M4_E32,
  PseudoVDIV_VX_M4_E32_MASK,
  PseudoVDIV_VX_M4_E64,
  PseudoVDIV_VX_M4_E64_MASK,
  PseudoVDIV_VX_M4_E8,
  PseudoVDIV_VX_M4_E8_MASK,
  PseudoVDIV_VX_M8_E16,
  PseudoVDIV_VX_M8_E16_MASK,
  PseudoVDIV_VX_M8_E32,
  PseudoVDIV_VX_M8_E32_MASK,
  PseudoVDIV_VX_M8_E64,
  PseudoVDIV_VX_M8_E64_MASK,
  PseudoVDIV_VX_M8_E8,
  PseudoVDIV_VX_M8_E8_MASK,
  PseudoVDIV_VX_MF2_E16,
  PseudoVDIV_VX_MF2_E16_MASK,
  PseudoVDIV_VX_MF2_E32,
  PseudoVDIV_VX_MF2_E32_MASK,
  PseudoVDIV_VX_MF2_E8,
  PseudoVDIV_VX_MF2_E8_MASK,
  PseudoVDIV_VX_MF4_E16,
  PseudoVDIV_VX_MF4_E16_MASK,
  PseudoVDIV_VX_MF4_E8,
  PseudoVDIV_VX_MF4_E8_MASK,
  PseudoVDIV_VX_MF8_E8,
  PseudoVDIV_VX_MF8_E8_MASK,
  PseudoVFADD_VFPR16_M1_E16,
  PseudoVFADD_VFPR16_M1_E16_MASK,
  PseudoVFADD_VFPR16_M2_E16,
  PseudoVFADD_VFPR16_M2_E16_MASK,
  PseudoVFADD_VFPR16_M4_E16,
  PseudoVFADD_VFPR16_M4_E16_MASK,
  PseudoVFADD_VFPR16_M8_E16,
  PseudoVFADD_VFPR16_M8_E16_MASK,
  PseudoVFADD_VFPR16_MF2_E16,
  PseudoVFADD_VFPR16_MF2_E16_MASK,
  PseudoVFADD_VFPR16_MF4_E16,
  PseudoVFADD_VFPR16_MF4_E16_MASK,
  PseudoVFADD_VFPR32_M1_E32,
  PseudoVFADD_VFPR32_M1_E32_MASK,
  PseudoVFADD_VFPR32_M2_E32,
  PseudoVFADD_VFPR32_M2_E32_MASK,
  PseudoVFADD_VFPR32_M4_E32,
  PseudoVFADD_VFPR32_M4_E32_MASK,
  PseudoVFADD_VFPR32_M8_E32,
  PseudoVFADD_VFPR32_M8_E32_MASK,
  PseudoVFADD_VFPR32_MF2_E32,
  PseudoVFADD_VFPR32_MF2_E32_MASK,
  PseudoVFADD_VFPR64_M1_E64,
  PseudoVFADD_VFPR64_M1_E64_MASK,
  PseudoVFADD_VFPR64_M2_E64,
  PseudoVFADD_VFPR64_M2_E64_MASK,
  PseudoVFADD_VFPR64_M4_E64,
  PseudoVFADD_VFPR64_M4_E64_MASK,
  PseudoVFADD_VFPR64_M8_E64,
  PseudoVFADD_VFPR64_M8_E64_MASK,
  PseudoVFADD_VV_M1_E16,
  PseudoVFADD_VV_M1_E16_MASK,
  PseudoVFADD_VV_M1_E32,
  PseudoVFADD_VV_M1_E32_MASK,
  PseudoVFADD_VV_M1_E64,
  PseudoVFADD_VV_M1_E64_MASK,
  PseudoVFADD_VV_M2_E16,
  PseudoVFADD_VV_M2_E16_MASK,
  PseudoVFADD_VV_M2_E32,
  PseudoVFADD_VV_M2_E32_MASK,
  PseudoVFADD_VV_M2_E64,
  PseudoVFADD_VV_M2_E64_MASK,
  PseudoVFADD_VV_M4_E16,
  PseudoVFADD_VV_M4_E16_MASK,
  PseudoVFADD_VV_M4_E32,
  PseudoVFADD_VV_M4_E32_MASK,
  PseudoVFADD_VV_M4_E64,
  PseudoVFADD_VV_M4_E64_MASK,
  PseudoVFADD_VV_M8_E16,
  PseudoVFADD_VV_M8_E16_MASK,
  PseudoVFADD_VV_M8_E32,
  PseudoVFADD_VV_M8_E32_MASK,
  PseudoVFADD_VV_M8_E64,
  PseudoVFADD_VV_M8_E64_MASK,
  PseudoVFADD_VV_MF2_E16,
  PseudoVFADD_VV_MF2_E16_MASK,
  PseudoVFADD_VV_MF2_E32,
  PseudoVFADD_VV_MF2_E32_MASK,
  PseudoVFADD_VV_MF4_E16,
  PseudoVFADD_VV_MF4_E16_MASK,
  PseudoVFCLASS_V_M1,
  PseudoVFCLASS_V_M1_MASK,
  PseudoVFCLASS_V_M2,
  PseudoVFCLASS_V_M2_MASK,
  PseudoVFCLASS_V_M4,
  PseudoVFCLASS_V_M4_MASK,
  PseudoVFCLASS_V_M8,
  PseudoVFCLASS_V_M8_MASK,
  PseudoVFCLASS_V_MF2,
  PseudoVFCLASS_V_MF2_MASK,
  PseudoVFCLASS_V_MF4,
  PseudoVFCLASS_V_MF4_MASK,
  PseudoVFCVT_F_XU_V_M1_E16,
  PseudoVFCVT_F_XU_V_M1_E16_MASK,
  PseudoVFCVT_F_XU_V_M1_E32,
  PseudoVFCVT_F_XU_V_M1_E32_MASK,
  PseudoVFCVT_F_XU_V_M1_E64,
  PseudoVFCVT_F_XU_V_M1_E64_MASK,
  PseudoVFCVT_F_XU_V_M2_E16,
  PseudoVFCVT_F_XU_V_M2_E16_MASK,
  PseudoVFCVT_F_XU_V_M2_E32,
  PseudoVFCVT_F_XU_V_M2_E32_MASK,
  PseudoVFCVT_F_XU_V_M2_E64,
  PseudoVFCVT_F_XU_V_M2_E64_MASK,
  PseudoVFCVT_F_XU_V_M4_E16,
  PseudoVFCVT_F_XU_V_M4_E16_MASK,
  PseudoVFCVT_F_XU_V_M4_E32,
  PseudoVFCVT_F_XU_V_M4_E32_MASK,
  PseudoVFCVT_F_XU_V_M4_E64,
  PseudoVFCVT_F_XU_V_M4_E64_MASK,
  PseudoVFCVT_F_XU_V_M8_E16,
  PseudoVFCVT_F_XU_V_M8_E16_MASK,
  PseudoVFCVT_F_XU_V_M8_E32,
  PseudoVFCVT_F_XU_V_M8_E32_MASK,
  PseudoVFCVT_F_XU_V_M8_E64,
  PseudoVFCVT_F_XU_V_M8_E64_MASK,
  PseudoVFCVT_F_XU_V_MF2_E16,
  PseudoVFCVT_F_XU_V_MF2_E16_MASK,
  PseudoVFCVT_F_XU_V_MF2_E32,
  PseudoVFCVT_F_XU_V_MF2_E32_MASK,
  PseudoVFCVT_F_XU_V_MF4_E16,
  PseudoVFCVT_F_XU_V_MF4_E16_MASK,
  PseudoVFCVT_F_X_V_M1_E16,
  PseudoVFCVT_F_X_V_M1_E16_MASK,
  PseudoVFCVT_F_X_V_M1_E32,
  PseudoVFCVT_F_X_V_M1_E32_MASK,
  PseudoVFCVT_F_X_V_M1_E64,
  PseudoVFCVT_F_X_V_M1_E64_MASK,
  PseudoVFCVT_F_X_V_M2_E16,
  PseudoVFCVT_F_X_V_M2_E16_MASK,
  PseudoVFCVT_F_X_V_M2_E32,
  PseudoVFCVT_F_X_V_M2_E32_MASK,
  PseudoVFCVT_F_X_V_M2_E64,
  PseudoVFCVT_F_X_V_M2_E64_MASK,
  PseudoVFCVT_F_X_V_M4_E16,
  PseudoVFCVT_F_X_V_M4_E16_MASK,
  PseudoVFCVT_F_X_V_M4_E32,
  PseudoVFCVT_F_X_V_M4_E32_MASK,
  PseudoVFCVT_F_X_V_M4_E64,
  PseudoVFCVT_F_X_V_M4_E64_MASK,
  PseudoVFCVT_F_X_V_M8_E16,
  PseudoVFCVT_F_X_V_M8_E16_MASK,
  PseudoVFCVT_F_X_V_M8_E32,
  PseudoVFCVT_F_X_V_M8_E32_MASK,
  PseudoVFCVT_F_X_V_M8_E64,
  PseudoVFCVT_F_X_V_M8_E64_MASK,
  PseudoVFCVT_F_X_V_MF2_E16,
  PseudoVFCVT_F_X_V_MF2_E16_MASK,
  PseudoVFCVT_F_X_V_MF2_E32,
  PseudoVFCVT_F_X_V_MF2_E32_MASK,
  PseudoVFCVT_F_X_V_MF4_E16,
  PseudoVFCVT_F_X_V_MF4_E16_MASK,
  PseudoVFCVT_RTZ_XU_F_V_M1,
  PseudoVFCVT_RTZ_XU_F_V_M1_MASK,
  PseudoVFCVT_RTZ_XU_F_V_M2,
  PseudoVFCVT_RTZ_XU_F_V_M2_MASK,
  PseudoVFCVT_RTZ_XU_F_V_M4,
  PseudoVFCVT_RTZ_XU_F_V_M4_MASK,
  PseudoVFCVT_RTZ_XU_F_V_M8,
  PseudoVFCVT_RTZ_XU_F_V_M8_MASK,
  PseudoVFCVT_RTZ_XU_F_V_MF2,
  PseudoVFCVT_RTZ_XU_F_V_MF2_MASK,
  PseudoVFCVT_RTZ_XU_F_V_MF4,
  PseudoVFCVT_RTZ_XU_F_V_MF4_MASK,
  PseudoVFCVT_RTZ_X_F_V_M1,
  PseudoVFCVT_RTZ_X_F_V_M1_MASK,
  PseudoVFCVT_RTZ_X_F_V_M2,
  PseudoVFCVT_RTZ_X_F_V_M2_MASK,
  PseudoVFCVT_RTZ_X_F_V_M4,
  PseudoVFCVT_RTZ_X_F_V_M4_MASK,
  PseudoVFCVT_RTZ_X_F_V_M8,
  PseudoVFCVT_RTZ_X_F_V_M8_MASK,
  PseudoVFCVT_RTZ_X_F_V_MF2,
  PseudoVFCVT_RTZ_X_F_V_MF2_MASK,
  PseudoVFCVT_RTZ_X_F_V_MF4,
  PseudoVFCVT_RTZ_X_F_V_MF4_MASK,
  PseudoVFCVT_XU_F_V_M1,
  PseudoVFCVT_XU_F_V_M1_MASK,
  PseudoVFCVT_XU_F_V_M2,
  PseudoVFCVT_XU_F_V_M2_MASK,
  PseudoVFCVT_XU_F_V_M4,
  PseudoVFCVT_XU_F_V_M4_MASK,
  PseudoVFCVT_XU_F_V_M8,
  PseudoVFCVT_XU_F_V_M8_MASK,
  PseudoVFCVT_XU_F_V_MF2,
  PseudoVFCVT_XU_F_V_MF2_MASK,
  PseudoVFCVT_XU_F_V_MF4,
  PseudoVFCVT_XU_F_V_MF4_MASK,
  PseudoVFCVT_X_F_V_M1,
  PseudoVFCVT_X_F_V_M1_MASK,
  PseudoVFCVT_X_F_V_M2,
  PseudoVFCVT_X_F_V_M2_MASK,
  PseudoVFCVT_X_F_V_M4,
  PseudoVFCVT_X_F_V_M4_MASK,
  PseudoVFCVT_X_F_V_M8,
  PseudoVFCVT_X_F_V_M8_MASK,
  PseudoVFCVT_X_F_V_MF2,
  PseudoVFCVT_X_F_V_MF2_MASK,
  PseudoVFCVT_X_F_V_MF4,
  PseudoVFCVT_X_F_V_MF4_MASK,
  PseudoVFDIV_VFPR16_M1_E16,
  PseudoVFDIV_VFPR16_M1_E16_MASK,
  PseudoVFDIV_VFPR16_M2_E16,
  PseudoVFDIV_VFPR16_M2_E16_MASK,
  PseudoVFDIV_VFPR16_M4_E16,
  PseudoVFDIV_VFPR16_M4_E16_MASK,
  PseudoVFDIV_VFPR16_M8_E16,
  PseudoVFDIV_VFPR16_M8_E16_MASK,
  PseudoVFDIV_VFPR16_MF2_E16,
  PseudoVFDIV_VFPR16_MF2_E16_MASK,
  PseudoVFDIV_VFPR16_MF4_E16,
  PseudoVFDIV_VFPR16_MF4_E16_MASK,
  PseudoVFDIV_VFPR32_M1_E32,
  PseudoVFDIV_VFPR32_M1_E32_MASK,
  PseudoVFDIV_VFPR32_M2_E32,
  PseudoVFDIV_VFPR32_M2_E32_MASK,
  PseudoVFDIV_VFPR32_M4_E32,
  PseudoVFDIV_VFPR32_M4_E32_MASK,
  PseudoVFDIV_VFPR32_M8_E32,
  PseudoVFDIV_VFPR32_M8_E32_MASK,
  PseudoVFDIV_VFPR32_MF2_E32,
  PseudoVFDIV_VFPR32_MF2_E32_MASK,
  PseudoVFDIV_VFPR64_M1_E64,
  PseudoVFDIV_VFPR64_M1_E64_MASK,
  PseudoVFDIV_VFPR64_M2_E64,
  PseudoVFDIV_VFPR64_M2_E64_MASK,
  PseudoVFDIV_VFPR64_M4_E64,
  PseudoVFDIV_VFPR64_M4_E64_MASK,
  PseudoVFDIV_VFPR64_M8_E64,
  PseudoVFDIV_VFPR64_M8_E64_MASK,
  PseudoVFDIV_VV_M1_E16,
  PseudoVFDIV_VV_M1_E16_MASK,
  PseudoVFDIV_VV_M1_E32,
  PseudoVFDIV_VV_M1_E32_MASK,
  PseudoVFDIV_VV_M1_E64,
  PseudoVFDIV_VV_M1_E64_MASK,
  PseudoVFDIV_VV_M2_E16,
  PseudoVFDIV_VV_M2_E16_MASK,
  PseudoVFDIV_VV_M2_E32,
  PseudoVFDIV_VV_M2_E32_MASK,
  PseudoVFDIV_VV_M2_E64,
  PseudoVFDIV_VV_M2_E64_MASK,
  PseudoVFDIV_VV_M4_E16,
  PseudoVFDIV_VV_M4_E16_MASK,
  PseudoVFDIV_VV_M4_E32,
  PseudoVFDIV_VV_M4_E32_MASK,
  PseudoVFDIV_VV_M4_E64,
  PseudoVFDIV_VV_M4_E64_MASK,
  PseudoVFDIV_VV_M8_E16,
  PseudoVFDIV_VV_M8_E16_MASK,
  PseudoVFDIV_VV_M8_E32,
  PseudoVFDIV_VV_M8_E32_MASK,
  PseudoVFDIV_VV_M8_E64,
  PseudoVFDIV_VV_M8_E64_MASK,
  PseudoVFDIV_VV_MF2_E16,
  PseudoVFDIV_VV_MF2_E16_MASK,
  PseudoVFDIV_VV_MF2_E32,
  PseudoVFDIV_VV_MF2_E32_MASK,
  PseudoVFDIV_VV_MF4_E16,
  PseudoVFDIV_VV_MF4_E16_MASK,
  PseudoVFIRST_M_B1,
  PseudoVFIRST_M_B16,
  PseudoVFIRST_M_B16_MASK,
  PseudoVFIRST_M_B1_MASK,
  PseudoVFIRST_M_B2,
  PseudoVFIRST_M_B2_MASK,
  PseudoVFIRST_M_B32,
  PseudoVFIRST_M_B32_MASK,
  PseudoVFIRST_M_B4,
  PseudoVFIRST_M_B4_MASK,
  PseudoVFIRST_M_B64,
  PseudoVFIRST_M_B64_MASK,
  PseudoVFIRST_M_B8,
  PseudoVFIRST_M_B8_MASK,
  PseudoVFMACC_VFPR16_M1_E16,
  PseudoVFMACC_VFPR16_M1_E16_MASK,
  PseudoVFMACC_VFPR16_M2_E16,
  PseudoVFMACC_VFPR16_M2_E16_MASK,
  PseudoVFMACC_VFPR16_M4_E16,
  PseudoVFMACC_VFPR16_M4_E16_MASK,
  PseudoVFMACC_VFPR16_M8_E16,
  PseudoVFMACC_VFPR16_M8_E16_MASK,
  PseudoVFMACC_VFPR16_MF2_E16,
  PseudoVFMACC_VFPR16_MF2_E16_MASK,
  PseudoVFMACC_VFPR16_MF4_E16,
  PseudoVFMACC_VFPR16_MF4_E16_MASK,
  PseudoVFMACC_VFPR32_M1_E32,
  PseudoVFMACC_VFPR32_M1_E32_MASK,
  PseudoVFMACC_VFPR32_M2_E32,
  PseudoVFMACC_VFPR32_M2_E32_MASK,
  PseudoVFMACC_VFPR32_M4_E32,
  PseudoVFMACC_VFPR32_M4_E32_MASK,
  PseudoVFMACC_VFPR32_M8_E32,
  PseudoVFMACC_VFPR32_M8_E32_MASK,
  PseudoVFMACC_VFPR32_MF2_E32,
  PseudoVFMACC_VFPR32_MF2_E32_MASK,
  PseudoVFMACC_VFPR64_M1_E64,
  PseudoVFMACC_VFPR64_M1_E64_MASK,
  PseudoVFMACC_VFPR64_M2_E64,
  PseudoVFMACC_VFPR64_M2_E64_MASK,
  PseudoVFMACC_VFPR64_M4_E64,
  PseudoVFMACC_VFPR64_M4_E64_MASK,
  PseudoVFMACC_VFPR64_M8_E64,
  PseudoVFMACC_VFPR64_M8_E64_MASK,
  PseudoVFMACC_VV_M1_E16,
  PseudoVFMACC_VV_M1_E16_MASK,
  PseudoVFMACC_VV_M1_E32,
  PseudoVFMACC_VV_M1_E32_MASK,
  PseudoVFMACC_VV_M1_E64,
  PseudoVFMACC_VV_M1_E64_MASK,
  PseudoVFMACC_VV_M2_E16,
  PseudoVFMACC_VV_M2_E16_MASK,
  PseudoVFMACC_VV_M2_E32,
  PseudoVFMACC_VV_M2_E32_MASK,
  PseudoVFMACC_VV_M2_E64,
  PseudoVFMACC_VV_M2_E64_MASK,
  PseudoVFMACC_VV_M4_E16,
  PseudoVFMACC_VV_M4_E16_MASK,
  PseudoVFMACC_VV_M4_E32,
  PseudoVFMACC_VV_M4_E32_MASK,
  PseudoVFMACC_VV_M4_E64,
  PseudoVFMACC_VV_M4_E64_MASK,
  PseudoVFMACC_VV_M8_E16,
  PseudoVFMACC_VV_M8_E16_MASK,
  PseudoVFMACC_VV_M8_E32,
  PseudoVFMACC_VV_M8_E32_MASK,
  PseudoVFMACC_VV_M8_E64,
  PseudoVFMACC_VV_M8_E64_MASK,
  PseudoVFMACC_VV_MF2_E16,
  PseudoVFMACC_VV_MF2_E16_MASK,
  PseudoVFMACC_VV_MF2_E32,
  PseudoVFMACC_VV_MF2_E32_MASK,
  PseudoVFMACC_VV_MF4_E16,
  PseudoVFMACC_VV_MF4_E16_MASK,
  PseudoVFMADD_VFPR16_M1_E16,
  PseudoVFMADD_VFPR16_M1_E16_MASK,
  PseudoVFMADD_VFPR16_M2_E16,
  PseudoVFMADD_VFPR16_M2_E16_MASK,
  PseudoVFMADD_VFPR16_M4_E16,
  PseudoVFMADD_VFPR16_M4_E16_MASK,
  PseudoVFMADD_VFPR16_M8_E16,
  PseudoVFMADD_VFPR16_M8_E16_MASK,
  PseudoVFMADD_VFPR16_MF2_E16,
  PseudoVFMADD_VFPR16_MF2_E16_MASK,
  PseudoVFMADD_VFPR16_MF4_E16,
  PseudoVFMADD_VFPR16_MF4_E16_MASK,
  PseudoVFMADD_VFPR32_M1_E32,
  PseudoVFMADD_VFPR32_M1_E32_MASK,
  PseudoVFMADD_VFPR32_M2_E32,
  PseudoVFMADD_VFPR32_M2_E32_MASK,
  PseudoVFMADD_VFPR32_M4_E32,
  PseudoVFMADD_VFPR32_M4_E32_MASK,
  PseudoVFMADD_VFPR32_M8_E32,
  PseudoVFMADD_VFPR32_M8_E32_MASK,
  PseudoVFMADD_VFPR32_MF2_E32,
  PseudoVFMADD_VFPR32_MF2_E32_MASK,
  PseudoVFMADD_VFPR64_M1_E64,
  PseudoVFMADD_VFPR64_M1_E64_MASK,
  PseudoVFMADD_VFPR64_M2_E64,
  PseudoVFMADD_VFPR64_M2_E64_MASK,
  PseudoVFMADD_VFPR64_M4_E64,
  PseudoVFMADD_VFPR64_M4_E64_MASK,
  PseudoVFMADD_VFPR64_M8_E64,
  PseudoVFMADD_VFPR64_M8_E64_MASK,
  PseudoVFMADD_VV_M1_E16,
  PseudoVFMADD_VV_M1_E16_MASK,
  PseudoVFMADD_VV_M1_E32,
  PseudoVFMADD_VV_M1_E32_MASK,
  PseudoVFMADD_VV_M1_E64,
  PseudoVFMADD_VV_M1_E64_MASK,
  PseudoVFMADD_VV_M2_E16,
  PseudoVFMADD_VV_M2_E16_MASK,
  PseudoVFMADD_VV_M2_E32,
  PseudoVFMADD_VV_M2_E32_MASK,
  PseudoVFMADD_VV_M2_E64,
  PseudoVFMADD_VV_M2_E64_MASK,
  PseudoVFMADD_VV_M4_E16,
  PseudoVFMADD_VV_M4_E16_MASK,
  PseudoVFMADD_VV_M4_E32,
  PseudoVFMADD_VV_M4_E32_MASK,
  PseudoVFMADD_VV_M4_E64,
  PseudoVFMADD_VV_M4_E64_MASK,
  PseudoVFMADD_VV_M8_E16,
  PseudoVFMADD_VV_M8_E16_MASK,
  PseudoVFMADD_VV_M8_E32,
  PseudoVFMADD_VV_M8_E32_MASK,
  PseudoVFMADD_VV_M8_E64,
  PseudoVFMADD_VV_M8_E64_MASK,
  PseudoVFMADD_VV_MF2_E16,
  PseudoVFMADD_VV_MF2_E16_MASK,
  PseudoVFMADD_VV_MF2_E32,
  PseudoVFMADD_VV_MF2_E32_MASK,
  PseudoVFMADD_VV_MF4_E16,
  PseudoVFMADD_VV_MF4_E16_MASK,
  PseudoVFMAX_VFPR16_M1_E16,
  PseudoVFMAX_VFPR16_M1_E16_MASK,
  PseudoVFMAX_VFPR16_M2_E16,
  PseudoVFMAX_VFPR16_M2_E16_MASK,
  PseudoVFMAX_VFPR16_M4_E16,
  PseudoVFMAX_VFPR16_M4_E16_MASK,
  PseudoVFMAX_VFPR16_M8_E16,
  PseudoVFMAX_VFPR16_M8_E16_MASK,
  PseudoVFMAX_VFPR16_MF2_E16,
  PseudoVFMAX_VFPR16_MF2_E16_MASK,
  PseudoVFMAX_VFPR16_MF4_E16,
  PseudoVFMAX_VFPR16_MF4_E16_MASK,
  PseudoVFMAX_VFPR32_M1_E32,
  PseudoVFMAX_VFPR32_M1_E32_MASK,
  PseudoVFMAX_VFPR32_M2_E32,
  PseudoVFMAX_VFPR32_M2_E32_MASK,
  PseudoVFMAX_VFPR32_M4_E32,
  PseudoVFMAX_VFPR32_M4_E32_MASK,
  PseudoVFMAX_VFPR32_M8_E32,
  PseudoVFMAX_VFPR32_M8_E32_MASK,
  PseudoVFMAX_VFPR32_MF2_E32,
  PseudoVFMAX_VFPR32_MF2_E32_MASK,
  PseudoVFMAX_VFPR64_M1_E64,
  PseudoVFMAX_VFPR64_M1_E64_MASK,
  PseudoVFMAX_VFPR64_M2_E64,
  PseudoVFMAX_VFPR64_M2_E64_MASK,
  PseudoVFMAX_VFPR64_M4_E64,
  PseudoVFMAX_VFPR64_M4_E64_MASK,
  PseudoVFMAX_VFPR64_M8_E64,
  PseudoVFMAX_VFPR64_M8_E64_MASK,
  PseudoVFMAX_VV_M1_E16,
  PseudoVFMAX_VV_M1_E16_MASK,
  PseudoVFMAX_VV_M1_E32,
  PseudoVFMAX_VV_M1_E32_MASK,
  PseudoVFMAX_VV_M1_E64,
  PseudoVFMAX_VV_M1_E64_MASK,
  PseudoVFMAX_VV_M2_E16,
  PseudoVFMAX_VV_M2_E16_MASK,
  PseudoVFMAX_VV_M2_E32,
  PseudoVFMAX_VV_M2_E32_MASK,
  PseudoVFMAX_VV_M2_E64,
  PseudoVFMAX_VV_M2_E64_MASK,
  PseudoVFMAX_VV_M4_E16,
  PseudoVFMAX_VV_M4_E16_MASK,
  PseudoVFMAX_VV_M4_E32,
  PseudoVFMAX_VV_M4_E32_MASK,
  PseudoVFMAX_VV_M4_E64,
  PseudoVFMAX_VV_M4_E64_MASK,
  PseudoVFMAX_VV_M8_E16,
  PseudoVFMAX_VV_M8_E16_MASK,
  PseudoVFMAX_VV_M8_E32,
  PseudoVFMAX_VV_M8_E32_MASK,
  PseudoVFMAX_VV_M8_E64,
  PseudoVFMAX_VV_M8_E64_MASK,
  PseudoVFMAX_VV_MF2_E16,
  PseudoVFMAX_VV_MF2_E16_MASK,
  PseudoVFMAX_VV_MF2_E32,
  PseudoVFMAX_VV_MF2_E32_MASK,
  PseudoVFMAX_VV_MF4_E16,
  PseudoVFMAX_VV_MF4_E16_MASK,
  PseudoVFMERGE_VFPR16M_M1,
  PseudoVFMERGE_VFPR16M_M2,
  PseudoVFMERGE_VFPR16M_M4,
  PseudoVFMERGE_VFPR16M_M8,
  PseudoVFMERGE_VFPR16M_MF2,
  PseudoVFMERGE_VFPR16M_MF4,
  PseudoVFMERGE_VFPR32M_M1,
  PseudoVFMERGE_VFPR32M_M2,
  PseudoVFMERGE_VFPR32M_M4,
  PseudoVFMERGE_VFPR32M_M8,
  PseudoVFMERGE_VFPR32M_MF2,
  PseudoVFMERGE_VFPR64M_M1,
  PseudoVFMERGE_VFPR64M_M2,
  PseudoVFMERGE_VFPR64M_M4,
  PseudoVFMERGE_VFPR64M_M8,
  PseudoVFMIN_VFPR16_M1_E16,
  PseudoVFMIN_VFPR16_M1_E16_MASK,
  PseudoVFMIN_VFPR16_M2_E16,
  PseudoVFMIN_VFPR16_M2_E16_MASK,
  PseudoVFMIN_VFPR16_M4_E16,
  PseudoVFMIN_VFPR16_M4_E16_MASK,
  PseudoVFMIN_VFPR16_M8_E16,
  PseudoVFMIN_VFPR16_M8_E16_MASK,
  PseudoVFMIN_VFPR16_MF2_E16,
  PseudoVFMIN_VFPR16_MF2_E16_MASK,
  PseudoVFMIN_VFPR16_MF4_E16,
  PseudoVFMIN_VFPR16_MF4_E16_MASK,
  PseudoVFMIN_VFPR32_M1_E32,
  PseudoVFMIN_VFPR32_M1_E32_MASK,
  PseudoVFMIN_VFPR32_M2_E32,
  PseudoVFMIN_VFPR32_M2_E32_MASK,
  PseudoVFMIN_VFPR32_M4_E32,
  PseudoVFMIN_VFPR32_M4_E32_MASK,
  PseudoVFMIN_VFPR32_M8_E32,
  PseudoVFMIN_VFPR32_M8_E32_MASK,
  PseudoVFMIN_VFPR32_MF2_E32,
  PseudoVFMIN_VFPR32_MF2_E32_MASK,
  PseudoVFMIN_VFPR64_M1_E64,
  PseudoVFMIN_VFPR64_M1_E64_MASK,
  PseudoVFMIN_VFPR64_M2_E64,
  PseudoVFMIN_VFPR64_M2_E64_MASK,
  PseudoVFMIN_VFPR64_M4_E64,
  PseudoVFMIN_VFPR64_M4_E64_MASK,
  PseudoVFMIN_VFPR64_M8_E64,
  PseudoVFMIN_VFPR64_M8_E64_MASK,
  PseudoVFMIN_VV_M1_E16,
  PseudoVFMIN_VV_M1_E16_MASK,
  PseudoVFMIN_VV_M1_E32,
  PseudoVFMIN_VV_M1_E32_MASK,
  PseudoVFMIN_VV_M1_E64,
  PseudoVFMIN_VV_M1_E64_MASK,
  PseudoVFMIN_VV_M2_E16,
  PseudoVFMIN_VV_M2_E16_MASK,
  PseudoVFMIN_VV_M2_E32,
  PseudoVFMIN_VV_M2_E32_MASK,
  PseudoVFMIN_VV_M2_E64,
  PseudoVFMIN_VV_M2_E64_MASK,
  PseudoVFMIN_VV_M4_E16,
  PseudoVFMIN_VV_M4_E16_MASK,
  PseudoVFMIN_VV_M4_E32,
  PseudoVFMIN_VV_M4_E32_MASK,
  PseudoVFMIN_VV_M4_E64,
  PseudoVFMIN_VV_M4_E64_MASK,
  PseudoVFMIN_VV_M8_E16,
  PseudoVFMIN_VV_M8_E16_MASK,
  PseudoVFMIN_VV_M8_E32,
  PseudoVFMIN_VV_M8_E32_MASK,
  PseudoVFMIN_VV_M8_E64,
  PseudoVFMIN_VV_M8_E64_MASK,
  PseudoVFMIN_VV_MF2_E16,
  PseudoVFMIN_VV_MF2_E16_MASK,
  PseudoVFMIN_VV_MF2_E32,
  PseudoVFMIN_VV_MF2_E32_MASK,
  PseudoVFMIN_VV_MF4_E16,
  PseudoVFMIN_VV_MF4_E16_MASK,
  PseudoVFMSAC_VFPR16_M1_E16,
  PseudoVFMSAC_VFPR16_M1_E16_MASK,
  PseudoVFMSAC_VFPR16_M2_E16,
  PseudoVFMSAC_VFPR16_M2_E16_MASK,
  PseudoVFMSAC_VFPR16_M4_E16,
  PseudoVFMSAC_VFPR16_M4_E16_MASK,
  PseudoVFMSAC_VFPR16_M8_E16,
  PseudoVFMSAC_VFPR16_M8_E16_MASK,
  PseudoVFMSAC_VFPR16_MF2_E16,
  PseudoVFMSAC_VFPR16_MF2_E16_MASK,
  PseudoVFMSAC_VFPR16_MF4_E16,
  PseudoVFMSAC_VFPR16_MF4_E16_MASK,
  PseudoVFMSAC_VFPR32_M1_E32,
  PseudoVFMSAC_VFPR32_M1_E32_MASK,
  PseudoVFMSAC_VFPR32_M2_E32,
  PseudoVFMSAC_VFPR32_M2_E32_MASK,
  PseudoVFMSAC_VFPR32_M4_E32,
  PseudoVFMSAC_VFPR32_M4_E32_MASK,
  PseudoVFMSAC_VFPR32_M8_E32,
  PseudoVFMSAC_VFPR32_M8_E32_MASK,
  PseudoVFMSAC_VFPR32_MF2_E32,
  PseudoVFMSAC_VFPR32_MF2_E32_MASK,
  PseudoVFMSAC_VFPR64_M1_E64,
  PseudoVFMSAC_VFPR64_M1_E64_MASK,
  PseudoVFMSAC_VFPR64_M2_E64,
  PseudoVFMSAC_VFPR64_M2_E64_MASK,
  PseudoVFMSAC_VFPR64_M4_E64,
  PseudoVFMSAC_VFPR64_M4_E64_MASK,
  PseudoVFMSAC_VFPR64_M8_E64,
  PseudoVFMSAC_VFPR64_M8_E64_MASK,
  PseudoVFMSAC_VV_M1_E16,
  PseudoVFMSAC_VV_M1_E16_MASK,
  PseudoVFMSAC_VV_M1_E32,
  PseudoVFMSAC_VV_M1_E32_MASK,
  PseudoVFMSAC_VV_M1_E64,
  PseudoVFMSAC_VV_M1_E64_MASK,
  PseudoVFMSAC_VV_M2_E16,
  PseudoVFMSAC_VV_M2_E16_MASK,
  PseudoVFMSAC_VV_M2_E32,
  PseudoVFMSAC_VV_M2_E32_MASK,
  PseudoVFMSAC_VV_M2_E64,
  PseudoVFMSAC_VV_M2_E64_MASK,
  PseudoVFMSAC_VV_M4_E16,
  PseudoVFMSAC_VV_M4_E16_MASK,
  PseudoVFMSAC_VV_M4_E32,
  PseudoVFMSAC_VV_M4_E32_MASK,
  PseudoVFMSAC_VV_M4_E64,
  PseudoVFMSAC_VV_M4_E64_MASK,
  PseudoVFMSAC_VV_M8_E16,
  PseudoVFMSAC_VV_M8_E16_MASK,
  PseudoVFMSAC_VV_M8_E32,
  PseudoVFMSAC_VV_M8_E32_MASK,
  PseudoVFMSAC_VV_M8_E64,
  PseudoVFMSAC_VV_M8_E64_MASK,
  PseudoVFMSAC_VV_MF2_E16,
  PseudoVFMSAC_VV_MF2_E16_MASK,
  PseudoVFMSAC_VV_MF2_E32,
  PseudoVFMSAC_VV_MF2_E32_MASK,
  PseudoVFMSAC_VV_MF4_E16,
  PseudoVFMSAC_VV_MF4_E16_MASK,
  PseudoVFMSUB_VFPR16_M1_E16,
  PseudoVFMSUB_VFPR16_M1_E16_MASK,
  PseudoVFMSUB_VFPR16_M2_E16,
  PseudoVFMSUB_VFPR16_M2_E16_MASK,
  PseudoVFMSUB_VFPR16_M4_E16,
  PseudoVFMSUB_VFPR16_M4_E16_MASK,
  PseudoVFMSUB_VFPR16_M8_E16,
  PseudoVFMSUB_VFPR16_M8_E16_MASK,
  PseudoVFMSUB_VFPR16_MF2_E16,
  PseudoVFMSUB_VFPR16_MF2_E16_MASK,
  PseudoVFMSUB_VFPR16_MF4_E16,
  PseudoVFMSUB_VFPR16_MF4_E16_MASK,
  PseudoVFMSUB_VFPR32_M1_E32,
  PseudoVFMSUB_VFPR32_M1_E32_MASK,
  PseudoVFMSUB_VFPR32_M2_E32,
  PseudoVFMSUB_VFPR32_M2_E32_MASK,
  PseudoVFMSUB_VFPR32_M4_E32,
  PseudoVFMSUB_VFPR32_M4_E32_MASK,
  PseudoVFMSUB_VFPR32_M8_E32,
  PseudoVFMSUB_VFPR32_M8_E32_MASK,
  PseudoVFMSUB_VFPR32_MF2_E32,
  PseudoVFMSUB_VFPR32_MF2_E32_MASK,
  PseudoVFMSUB_VFPR64_M1_E64,
  PseudoVFMSUB_VFPR64_M1_E64_MASK,
  PseudoVFMSUB_VFPR64_M2_E64,
  PseudoVFMSUB_VFPR64_M2_E64_MASK,
  PseudoVFMSUB_VFPR64_M4_E64,
  PseudoVFMSUB_VFPR64_M4_E64_MASK,
  PseudoVFMSUB_VFPR64_M8_E64,
  PseudoVFMSUB_VFPR64_M8_E64_MASK,
  PseudoVFMSUB_VV_M1_E16,
  PseudoVFMSUB_VV_M1_E16_MASK,
  PseudoVFMSUB_VV_M1_E32,
  PseudoVFMSUB_VV_M1_E32_MASK,
  PseudoVFMSUB_VV_M1_E64,
  PseudoVFMSUB_VV_M1_E64_MASK,
  PseudoVFMSUB_VV_M2_E16,
  PseudoVFMSUB_VV_M2_E16_MASK,
  PseudoVFMSUB_VV_M2_E32,
  PseudoVFMSUB_VV_M2_E32_MASK,
  PseudoVFMSUB_VV_M2_E64,
  PseudoVFMSUB_VV_M2_E64_MASK,
  PseudoVFMSUB_VV_M4_E16,
  PseudoVFMSUB_VV_M4_E16_MASK,
  PseudoVFMSUB_VV_M4_E32,
  PseudoVFMSUB_VV_M4_E32_MASK,
  PseudoVFMSUB_VV_M4_E64,
  PseudoVFMSUB_VV_M4_E64_MASK,
  PseudoVFMSUB_VV_M8_E16,
  PseudoVFMSUB_VV_M8_E16_MASK,
  PseudoVFMSUB_VV_M8_E32,
  PseudoVFMSUB_VV_M8_E32_MASK,
  PseudoVFMSUB_VV_M8_E64,
  PseudoVFMSUB_VV_M8_E64_MASK,
  PseudoVFMSUB_VV_MF2_E16,
  PseudoVFMSUB_VV_MF2_E16_MASK,
  PseudoVFMSUB_VV_MF2_E32,
  PseudoVFMSUB_VV_MF2_E32_MASK,
  PseudoVFMSUB_VV_MF4_E16,
  PseudoVFMSUB_VV_MF4_E16_MASK,
  PseudoVFMUL_VFPR16_M1_E16,
  PseudoVFMUL_VFPR16_M1_E16_MASK,
  PseudoVFMUL_VFPR16_M2_E16,
  PseudoVFMUL_VFPR16_M2_E16_MASK,
  PseudoVFMUL_VFPR16_M4_E16,
  PseudoVFMUL_VFPR16_M4_E16_MASK,
  PseudoVFMUL_VFPR16_M8_E16,
  PseudoVFMUL_VFPR16_M8_E16_MASK,
  PseudoVFMUL_VFPR16_MF2_E16,
  PseudoVFMUL_VFPR16_MF2_E16_MASK,
  PseudoVFMUL_VFPR16_MF4_E16,
  PseudoVFMUL_VFPR16_MF4_E16_MASK,
  PseudoVFMUL_VFPR32_M1_E32,
  PseudoVFMUL_VFPR32_M1_E32_MASK,
  PseudoVFMUL_VFPR32_M2_E32,
  PseudoVFMUL_VFPR32_M2_E32_MASK,
  PseudoVFMUL_VFPR32_M4_E32,
  PseudoVFMUL_VFPR32_M4_E32_MASK,
  PseudoVFMUL_VFPR32_M8_E32,
  PseudoVFMUL_VFPR32_M8_E32_MASK,
  PseudoVFMUL_VFPR32_MF2_E32,
  PseudoVFMUL_VFPR32_MF2_E32_MASK,
  PseudoVFMUL_VFPR64_M1_E64,
  PseudoVFMUL_VFPR64_M1_E64_MASK,
  PseudoVFMUL_VFPR64_M2_E64,
  PseudoVFMUL_VFPR64_M2_E64_MASK,
  PseudoVFMUL_VFPR64_M4_E64,
  PseudoVFMUL_VFPR64_M4_E64_MASK,
  PseudoVFMUL_VFPR64_M8_E64,
  PseudoVFMUL_VFPR64_M8_E64_MASK,
  PseudoVFMUL_VV_M1_E16,
  PseudoVFMUL_VV_M1_E16_MASK,
  PseudoVFMUL_VV_M1_E32,
  PseudoVFMUL_VV_M1_E32_MASK,
  PseudoVFMUL_VV_M1_E64,
  PseudoVFMUL_VV_M1_E64_MASK,
  PseudoVFMUL_VV_M2_E16,
  PseudoVFMUL_VV_M2_E16_MASK,
  PseudoVFMUL_VV_M2_E32,
  PseudoVFMUL_VV_M2_E32_MASK,
  PseudoVFMUL_VV_M2_E64,
  PseudoVFMUL_VV_M2_E64_MASK,
  PseudoVFMUL_VV_M4_E16,
  PseudoVFMUL_VV_M4_E16_MASK,
  PseudoVFMUL_VV_M4_E32,
  PseudoVFMUL_VV_M4_E32_MASK,
  PseudoVFMUL_VV_M4_E64,
  PseudoVFMUL_VV_M4_E64_MASK,
  PseudoVFMUL_VV_M8_E16,
  PseudoVFMUL_VV_M8_E16_MASK,
  PseudoVFMUL_VV_M8_E32,
  PseudoVFMUL_VV_M8_E32_MASK,
  PseudoVFMUL_VV_M8_E64,
  PseudoVFMUL_VV_M8_E64_MASK,
  PseudoVFMUL_VV_MF2_E16,
  PseudoVFMUL_VV_MF2_E16_MASK,
  PseudoVFMUL_VV_MF2_E32,
  PseudoVFMUL_VV_MF2_E32_MASK,
  PseudoVFMUL_VV_MF4_E16,
  PseudoVFMUL_VV_MF4_E16_MASK,
  PseudoVFMV_FPR16_S,
  PseudoVFMV_FPR32_S,
  PseudoVFMV_FPR64_S,
  PseudoVFMV_S_FPR16,
  PseudoVFMV_S_FPR32,
  PseudoVFMV_S_FPR64,
  PseudoVFMV_V_FPR16_M1,
  PseudoVFMV_V_FPR16_M2,
  PseudoVFMV_V_FPR16_M4,
  PseudoVFMV_V_FPR16_M8,
  PseudoVFMV_V_FPR16_MF2,
  PseudoVFMV_V_FPR16_MF4,
  PseudoVFMV_V_FPR32_M1,
  PseudoVFMV_V_FPR32_M2,
  PseudoVFMV_V_FPR32_M4,
  PseudoVFMV_V_FPR32_M8,
  PseudoVFMV_V_FPR32_MF2,
  PseudoVFMV_V_FPR64_M1,
  PseudoVFMV_V_FPR64_M2,
  PseudoVFMV_V_FPR64_M4,
  PseudoVFMV_V_FPR64_M8,
  PseudoVFNCVTBF16_F_F_W_M1_E16,
  PseudoVFNCVTBF16_F_F_W_M1_E16_MASK,
  PseudoVFNCVTBF16_F_F_W_M1_E32,
  PseudoVFNCVTBF16_F_F_W_M1_E32_MASK,
  PseudoVFNCVTBF16_F_F_W_M2_E16,
  PseudoVFNCVTBF16_F_F_W_M2_E16_MASK,
  PseudoVFNCVTBF16_F_F_W_M2_E32,
  PseudoVFNCVTBF16_F_F_W_M2_E32_MASK,
  PseudoVFNCVTBF16_F_F_W_M4_E16,
  PseudoVFNCVTBF16_F_F_W_M4_E16_MASK,
  PseudoVFNCVTBF16_F_F_W_M4_E32,
  PseudoVFNCVTBF16_F_F_W_M4_E32_MASK,
  PseudoVFNCVTBF16_F_F_W_MF2_E16,
  PseudoVFNCVTBF16_F_F_W_MF2_E16_MASK,
  PseudoVFNCVTBF16_F_F_W_MF2_E32,
  PseudoVFNCVTBF16_F_F_W_MF2_E32_MASK,
  PseudoVFNCVTBF16_F_F_W_MF4_E16,
  PseudoVFNCVTBF16_F_F_W_MF4_E16_MASK,
  PseudoVFNCVT_F_F_W_M1_E16,
  PseudoVFNCVT_F_F_W_M1_E16_MASK,
  PseudoVFNCVT_F_F_W_M1_E32,
  PseudoVFNCVT_F_F_W_M1_E32_MASK,
  PseudoVFNCVT_F_F_W_M2_E16,
  PseudoVFNCVT_F_F_W_M2_E16_MASK,
  PseudoVFNCVT_F_F_W_M2_E32,
  PseudoVFNCVT_F_F_W_M2_E32_MASK,
  PseudoVFNCVT_F_F_W_M4_E16,
  PseudoVFNCVT_F_F_W_M4_E16_MASK,
  PseudoVFNCVT_F_F_W_M4_E32,
  PseudoVFNCVT_F_F_W_M4_E32_MASK,
  PseudoVFNCVT_F_F_W_MF2_E16,
  PseudoVFNCVT_F_F_W_MF2_E16_MASK,
  PseudoVFNCVT_F_F_W_MF2_E32,
  PseudoVFNCVT_F_F_W_MF2_E32_MASK,
  PseudoVFNCVT_F_F_W_MF4_E16,
  PseudoVFNCVT_F_F_W_MF4_E16_MASK,
  PseudoVFNCVT_F_XU_W_M1_E16,
  PseudoVFNCVT_F_XU_W_M1_E16_MASK,
  PseudoVFNCVT_F_XU_W_M1_E32,
  PseudoVFNCVT_F_XU_W_M1_E32_MASK,
  PseudoVFNCVT_F_XU_W_M2_E16,
  PseudoVFNCVT_F_XU_W_M2_E16_MASK,
  PseudoVFNCVT_F_XU_W_M2_E32,
  PseudoVFNCVT_F_XU_W_M2_E32_MASK,
  PseudoVFNCVT_F_XU_W_M4_E16,
  PseudoVFNCVT_F_XU_W_M4_E16_MASK,
  PseudoVFNCVT_F_XU_W_M4_E32,
  PseudoVFNCVT_F_XU_W_M4_E32_MASK,
  PseudoVFNCVT_F_XU_W_MF2_E16,
  PseudoVFNCVT_F_XU_W_MF2_E16_MASK,
  PseudoVFNCVT_F_XU_W_MF2_E32,
  PseudoVFNCVT_F_XU_W_MF2_E32_MASK,
  PseudoVFNCVT_F_XU_W_MF4_E16,
  PseudoVFNCVT_F_XU_W_MF4_E16_MASK,
  PseudoVFNCVT_F_X_W_M1_E16,
  PseudoVFNCVT_F_X_W_M1_E16_MASK,
  PseudoVFNCVT_F_X_W_M1_E32,
  PseudoVFNCVT_F_X_W_M1_E32_MASK,
  PseudoVFNCVT_F_X_W_M2_E16,
  PseudoVFNCVT_F_X_W_M2_E16_MASK,
  PseudoVFNCVT_F_X_W_M2_E32,
  PseudoVFNCVT_F_X_W_M2_E32_MASK,
  PseudoVFNCVT_F_X_W_M4_E16,
  PseudoVFNCVT_F_X_W_M4_E16_MASK,
  PseudoVFNCVT_F_X_W_M4_E32,
  PseudoVFNCVT_F_X_W_M4_E32_MASK,
  PseudoVFNCVT_F_X_W_MF2_E16,
  PseudoVFNCVT_F_X_W_MF2_E16_MASK,
  PseudoVFNCVT_F_X_W_MF2_E32,
  PseudoVFNCVT_F_X_W_MF2_E32_MASK,
  PseudoVFNCVT_F_X_W_MF4_E16,
  PseudoVFNCVT_F_X_W_MF4_E16_MASK,
  PseudoVFNCVT_ROD_F_F_W_M1_E16,
  PseudoVFNCVT_ROD_F_F_W_M1_E16_MASK,
  PseudoVFNCVT_ROD_F_F_W_M1_E32,
  PseudoVFNCVT_ROD_F_F_W_M1_E32_MASK,
  PseudoVFNCVT_ROD_F_F_W_M2_E16,
  PseudoVFNCVT_ROD_F_F_W_M2_E16_MASK,
  PseudoVFNCVT_ROD_F_F_W_M2_E32,
  PseudoVFNCVT_ROD_F_F_W_M2_E32_MASK,
  PseudoVFNCVT_ROD_F_F_W_M4_E16,
  PseudoVFNCVT_ROD_F_F_W_M4_E16_MASK,
  PseudoVFNCVT_ROD_F_F_W_M4_E32,
  PseudoVFNCVT_ROD_F_F_W_M4_E32_MASK,
  PseudoVFNCVT_ROD_F_F_W_MF2_E16,
  PseudoVFNCVT_ROD_F_F_W_MF2_E16_MASK,
  PseudoVFNCVT_ROD_F_F_W_MF2_E32,
  PseudoVFNCVT_ROD_F_F_W_MF2_E32_MASK,
  PseudoVFNCVT_ROD_F_F_W_MF4_E16,
  PseudoVFNCVT_ROD_F_F_W_MF4_E16_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_M1,
  PseudoVFNCVT_RTZ_XU_F_W_M1_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_M2,
  PseudoVFNCVT_RTZ_XU_F_W_M2_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_M4,
  PseudoVFNCVT_RTZ_XU_F_W_M4_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_MF2,
  PseudoVFNCVT_RTZ_XU_F_W_MF2_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_MF4,
  PseudoVFNCVT_RTZ_XU_F_W_MF4_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_MF8,
  PseudoVFNCVT_RTZ_XU_F_W_MF8_MASK,
  PseudoVFNCVT_RTZ_X_F_W_M1,
  PseudoVFNCVT_RTZ_X_F_W_M1_MASK,
  PseudoVFNCVT_RTZ_X_F_W_M2,
  PseudoVFNCVT_RTZ_X_F_W_M2_MASK,
  PseudoVFNCVT_RTZ_X_F_W_M4,
  PseudoVFNCVT_RTZ_X_F_W_M4_MASK,
  PseudoVFNCVT_RTZ_X_F_W_MF2,
  PseudoVFNCVT_RTZ_X_F_W_MF2_MASK,
  PseudoVFNCVT_RTZ_X_F_W_MF4,
  PseudoVFNCVT_RTZ_X_F_W_MF4_MASK,
  PseudoVFNCVT_RTZ_X_F_W_MF8,
  PseudoVFNCVT_RTZ_X_F_W_MF8_MASK,
  PseudoVFNCVT_XU_F_W_M1,
  PseudoVFNCVT_XU_F_W_M1_MASK,
  PseudoVFNCVT_XU_F_W_M2,
  PseudoVFNCVT_XU_F_W_M2_MASK,
  PseudoVFNCVT_XU_F_W_M4,
  PseudoVFNCVT_XU_F_W_M4_MASK,
  PseudoVFNCVT_XU_F_W_MF2,
  PseudoVFNCVT_XU_F_W_MF2_MASK,
  PseudoVFNCVT_XU_F_W_MF4,
  PseudoVFNCVT_XU_F_W_MF4_MASK,
  PseudoVFNCVT_XU_F_W_MF8,
  PseudoVFNCVT_XU_F_W_MF8_MASK,
  PseudoVFNCVT_X_F_W_M1,
  PseudoVFNCVT_X_F_W_M1_MASK,
  PseudoVFNCVT_X_F_W_M2,
  PseudoVFNCVT_X_F_W_M2_MASK,
  PseudoVFNCVT_X_F_W_M4,
  PseudoVFNCVT_X_F_W_M4_MASK,
  PseudoVFNCVT_X_F_W_MF2,
  PseudoVFNCVT_X_F_W_MF2_MASK,
  PseudoVFNCVT_X_F_W_MF4,
  PseudoVFNCVT_X_F_W_MF4_MASK,
  PseudoVFNCVT_X_F_W_MF8,
  PseudoVFNCVT_X_F_W_MF8_MASK,
  PseudoVFNMACC_VFPR16_M1_E16,
  PseudoVFNMACC_VFPR16_M1_E16_MASK,
  PseudoVFNMACC_VFPR16_M2_E16,
  PseudoVFNMACC_VFPR16_M2_E16_MASK,
  PseudoVFNMACC_VFPR16_M4_E16,
  PseudoVFNMACC_VFPR16_M4_E16_MASK,
  PseudoVFNMACC_VFPR16_M8_E16,
  PseudoVFNMACC_VFPR16_M8_E16_MASK,
  PseudoVFNMACC_VFPR16_MF2_E16,
  PseudoVFNMACC_VFPR16_MF2_E16_MASK,
  PseudoVFNMACC_VFPR16_MF4_E16,
  PseudoVFNMACC_VFPR16_MF4_E16_MASK,
  PseudoVFNMACC_VFPR32_M1_E32,
  PseudoVFNMACC_VFPR32_M1_E32_MASK,
  PseudoVFNMACC_VFPR32_M2_E32,
  PseudoVFNMACC_VFPR32_M2_E32_MASK,
  PseudoVFNMACC_VFPR32_M4_E32,
  PseudoVFNMACC_VFPR32_M4_E32_MASK,
  PseudoVFNMACC_VFPR32_M8_E32,
  PseudoVFNMACC_VFPR32_M8_E32_MASK,
  PseudoVFNMACC_VFPR32_MF2_E32,
  PseudoVFNMACC_VFPR32_MF2_E32_MASK,
  PseudoVFNMACC_VFPR64_M1_E64,
  PseudoVFNMACC_VFPR64_M1_E64_MASK,
  PseudoVFNMACC_VFPR64_M2_E64,
  PseudoVFNMACC_VFPR64_M2_E64_MASK,
  PseudoVFNMACC_VFPR64_M4_E64,
  PseudoVFNMACC_VFPR64_M4_E64_MASK,
  PseudoVFNMACC_VFPR64_M8_E64,
  PseudoVFNMACC_VFPR64_M8_E64_MASK,
  PseudoVFNMACC_VV_M1_E16,
  PseudoVFNMACC_VV_M1_E16_MASK,
  PseudoVFNMACC_VV_M1_E32,
  PseudoVFNMACC_VV_M1_E32_MASK,
  PseudoVFNMACC_VV_M1_E64,
  PseudoVFNMACC_VV_M1_E64_MASK,
  PseudoVFNMACC_VV_M2_E16,
  PseudoVFNMACC_VV_M2_E16_MASK,
  PseudoVFNMACC_VV_M2_E32,
  PseudoVFNMACC_VV_M2_E32_MASK,
  PseudoVFNMACC_VV_M2_E64,
  PseudoVFNMACC_VV_M2_E64_MASK,
  PseudoVFNMACC_VV_M4_E16,
  PseudoVFNMACC_VV_M4_E16_MASK,
  PseudoVFNMACC_VV_M4_E32,
  PseudoVFNMACC_VV_M4_E32_MASK,
  PseudoVFNMACC_VV_M4_E64,
  PseudoVFNMACC_VV_M4_E64_MASK,
  PseudoVFNMACC_VV_M8_E16,
  PseudoVFNMACC_VV_M8_E16_MASK,
  PseudoVFNMACC_VV_M8_E32,
  PseudoVFNMACC_VV_M8_E32_MASK,
  PseudoVFNMACC_VV_M8_E64,
  PseudoVFNMACC_VV_M8_E64_MASK,
  PseudoVFNMACC_VV_MF2_E16,
  PseudoVFNMACC_VV_MF2_E16_MASK,
  PseudoVFNMACC_VV_MF2_E32,
  PseudoVFNMACC_VV_MF2_E32_MASK,
  PseudoVFNMACC_VV_MF4_E16,
  PseudoVFNMACC_VV_MF4_E16_MASK,
  PseudoVFNMADD_VFPR16_M1_E16,
  PseudoVFNMADD_VFPR16_M1_E16_MASK,
  PseudoVFNMADD_VFPR16_M2_E16,
  PseudoVFNMADD_VFPR16_M2_E16_MASK,
  PseudoVFNMADD_VFPR16_M4_E16,
  PseudoVFNMADD_VFPR16_M4_E16_MASK,
  PseudoVFNMADD_VFPR16_M8_E16,
  PseudoVFNMADD_VFPR16_M8_E16_MASK,
  PseudoVFNMADD_VFPR16_MF2_E16,
  PseudoVFNMADD_VFPR16_MF2_E16_MASK,
  PseudoVFNMADD_VFPR16_MF4_E16,
  PseudoVFNMADD_VFPR16_MF4_E16_MASK,
  PseudoVFNMADD_VFPR32_M1_E32,
  PseudoVFNMADD_VFPR32_M1_E32_MASK,
  PseudoVFNMADD_VFPR32_M2_E32,
  PseudoVFNMADD_VFPR32_M2_E32_MASK,
  PseudoVFNMADD_VFPR32_M4_E32,
  PseudoVFNMADD_VFPR32_M4_E32_MASK,
  PseudoVFNMADD_VFPR32_M8_E32,
  PseudoVFNMADD_VFPR32_M8_E32_MASK,
  PseudoVFNMADD_VFPR32_MF2_E32,
  PseudoVFNMADD_VFPR32_MF2_E32_MASK,
  PseudoVFNMADD_VFPR64_M1_E64,
  PseudoVFNMADD_VFPR64_M1_E64_MASK,
  PseudoVFNMADD_VFPR64_M2_E64,
  PseudoVFNMADD_VFPR64_M2_E64_MASK,
  PseudoVFNMADD_VFPR64_M4_E64,
  PseudoVFNMADD_VFPR64_M4_E64_MASK,
  PseudoVFNMADD_VFPR64_M8_E64,
  PseudoVFNMADD_VFPR64_M8_E64_MASK,
  PseudoVFNMADD_VV_M1_E16,
  PseudoVFNMADD_VV_M1_E16_MASK,
  PseudoVFNMADD_VV_M1_E32,
  PseudoVFNMADD_VV_M1_E32_MASK,
  PseudoVFNMADD_VV_M1_E64,
  PseudoVFNMADD_VV_M1_E64_MASK,
  PseudoVFNMADD_VV_M2_E16,
  PseudoVFNMADD_VV_M2_E16_MASK,
  PseudoVFNMADD_VV_M2_E32,
  PseudoVFNMADD_VV_M2_E32_MASK,
  PseudoVFNMADD_VV_M2_E64,
  PseudoVFNMADD_VV_M2_E64_MASK,
  PseudoVFNMADD_VV_M4_E16,
  PseudoVFNMADD_VV_M4_E16_MASK,
  PseudoVFNMADD_VV_M4_E32,
  PseudoVFNMADD_VV_M4_E32_MASK,
  PseudoVFNMADD_VV_M4_E64,
  PseudoVFNMADD_VV_M4_E64_MASK,
  PseudoVFNMADD_VV_M8_E16,
  PseudoVFNMADD_VV_M8_E16_MASK,
  PseudoVFNMADD_VV_M8_E32,
  PseudoVFNMADD_VV_M8_E32_MASK,
  PseudoVFNMADD_VV_M8_E64,
  PseudoVFNMADD_VV_M8_E64_MASK,
  PseudoVFNMADD_VV_MF2_E16,
  PseudoVFNMADD_VV_MF2_E16_MASK,
  PseudoVFNMADD_VV_MF2_E32,
  PseudoVFNMADD_VV_MF2_E32_MASK,
  PseudoVFNMADD_VV_MF4_E16,
  PseudoVFNMADD_VV_MF4_E16_MASK,
  PseudoVFNMSAC_VFPR16_M1_E16,
  PseudoVFNMSAC_VFPR16_M1_E16_MASK,
  PseudoVFNMSAC_VFPR16_M2_E16,
  PseudoVFNMSAC_VFPR16_M2_E16_MASK,
  PseudoVFNMSAC_VFPR16_M4_E16,
  PseudoVFNMSAC_VFPR16_M4_E16_MASK,
  PseudoVFNMSAC_VFPR16_M8_E16,
  PseudoVFNMSAC_VFPR16_M8_E16_MASK,
  PseudoVFNMSAC_VFPR16_MF2_E16,
  PseudoVFNMSAC_VFPR16_MF2_E16_MASK,
  PseudoVFNMSAC_VFPR16_MF4_E16,
  PseudoVFNMSAC_VFPR16_MF4_E16_MASK,
  PseudoVFNMSAC_VFPR32_M1_E32,
  PseudoVFNMSAC_VFPR32_M1_E32_MASK,
  PseudoVFNMSAC_VFPR32_M2_E32,
  PseudoVFNMSAC_VFPR32_M2_E32_MASK,
  PseudoVFNMSAC_VFPR32_M4_E32,
  PseudoVFNMSAC_VFPR32_M4_E32_MASK,
  PseudoVFNMSAC_VFPR32_M8_E32,
  PseudoVFNMSAC_VFPR32_M8_E32_MASK,
  PseudoVFNMSAC_VFPR32_MF2_E32,
  PseudoVFNMSAC_VFPR32_MF2_E32_MASK,
  PseudoVFNMSAC_VFPR64_M1_E64,
  PseudoVFNMSAC_VFPR64_M1_E64_MASK,
  PseudoVFNMSAC_VFPR64_M2_E64,
  PseudoVFNMSAC_VFPR64_M2_E64_MASK,
  PseudoVFNMSAC_VFPR64_M4_E64,
  PseudoVFNMSAC_VFPR64_M4_E64_MASK,
  PseudoVFNMSAC_VFPR64_M8_E64,
  PseudoVFNMSAC_VFPR64_M8_E64_MASK,
  PseudoVFNMSAC_VV_M1_E16,
  PseudoVFNMSAC_VV_M1_E16_MASK,
  PseudoVFNMSAC_VV_M1_E32,
  PseudoVFNMSAC_VV_M1_E32_MASK,
  PseudoVFNMSAC_VV_M1_E64,
  PseudoVFNMSAC_VV_M1_E64_MASK,
  PseudoVFNMSAC_VV_M2_E16,
  PseudoVFNMSAC_VV_M2_E16_MASK,
  PseudoVFNMSAC_VV_M2_E32,
  PseudoVFNMSAC_VV_M2_E32_MASK,
  PseudoVFNMSAC_VV_M2_E64,
  PseudoVFNMSAC_VV_M2_E64_MASK,
  PseudoVFNMSAC_VV_M4_E16,
  PseudoVFNMSAC_VV_M4_E16_MASK,
  PseudoVFNMSAC_VV_M4_E32,
  PseudoVFNMSAC_VV_M4_E32_MASK,
  PseudoVFNMSAC_VV_M4_E64,
  PseudoVFNMSAC_VV_M4_E64_MASK,
  PseudoVFNMSAC_VV_M8_E16,
  PseudoVFNMSAC_VV_M8_E16_MASK,
  PseudoVFNMSAC_VV_M8_E32,
  PseudoVFNMSAC_VV_M8_E32_MASK,
  PseudoVFNMSAC_VV_M8_E64,
  PseudoVFNMSAC_VV_M8_E64_MASK,
  PseudoVFNMSAC_VV_MF2_E16,
  PseudoVFNMSAC_VV_MF2_E16_MASK,
  PseudoVFNMSAC_VV_MF2_E32,
  PseudoVFNMSAC_VV_MF2_E32_MASK,
  PseudoVFNMSAC_VV_MF4_E16,
  PseudoVFNMSAC_VV_MF4_E16_MASK,
  PseudoVFNMSUB_VFPR16_M1_E16,
  PseudoVFNMSUB_VFPR16_M1_E16_MASK,
  PseudoVFNMSUB_VFPR16_M2_E16,
  PseudoVFNMSUB_VFPR16_M2_E16_MASK,
  PseudoVFNMSUB_VFPR16_M4_E16,
  PseudoVFNMSUB_VFPR16_M4_E16_MASK,
  PseudoVFNMSUB_VFPR16_M8_E16,
  PseudoVFNMSUB_VFPR16_M8_E16_MASK,
  PseudoVFNMSUB_VFPR16_MF2_E16,
  PseudoVFNMSUB_VFPR16_MF2_E16_MASK,
  PseudoVFNMSUB_VFPR16_MF4_E16,
  PseudoVFNMSUB_VFPR16_MF4_E16_MASK,
  PseudoVFNMSUB_VFPR32_M1_E32,
  PseudoVFNMSUB_VFPR32_M1_E32_MASK,
  PseudoVFNMSUB_VFPR32_M2_E32,
  PseudoVFNMSUB_VFPR32_M2_E32_MASK,
  PseudoVFNMSUB_VFPR32_M4_E32,
  PseudoVFNMSUB_VFPR32_M4_E32_MASK,
  PseudoVFNMSUB_VFPR32_M8_E32,
  PseudoVFNMSUB_VFPR32_M8_E32_MASK,
  PseudoVFNMSUB_VFPR32_MF2_E32,
  PseudoVFNMSUB_VFPR32_MF2_E32_MASK,
  PseudoVFNMSUB_VFPR64_M1_E64,
  PseudoVFNMSUB_VFPR64_M1_E64_MASK,
  PseudoVFNMSUB_VFPR64_M2_E64,
  PseudoVFNMSUB_VFPR64_M2_E64_MASK,
  PseudoVFNMSUB_VFPR64_M4_E64,
  PseudoVFNMSUB_VFPR64_M4_E64_MASK,
  PseudoVFNMSUB_VFPR64_M8_E64,
  PseudoVFNMSUB_VFPR64_M8_E64_MASK,
  PseudoVFNMSUB_VV_M1_E16,
  PseudoVFNMSUB_VV_M1_E16_MASK,
  PseudoVFNMSUB_VV_M1_E32,
  PseudoVFNMSUB_VV_M1_E32_MASK,
  PseudoVFNMSUB_VV_M1_E64,
  PseudoVFNMSUB_VV_M1_E64_MASK,
  PseudoVFNMSUB_VV_M2_E16,
  PseudoVFNMSUB_VV_M2_E16_MASK,
  PseudoVFNMSUB_VV_M2_E32,
  PseudoVFNMSUB_VV_M2_E32_MASK,
  PseudoVFNMSUB_VV_M2_E64,
  PseudoVFNMSUB_VV_M2_E64_MASK,
  PseudoVFNMSUB_VV_M4_E16,
  PseudoVFNMSUB_VV_M4_E16_MASK,
  PseudoVFNMSUB_VV_M4_E32,
  PseudoVFNMSUB_VV_M4_E32_MASK,
  PseudoVFNMSUB_VV_M4_E64,
  PseudoVFNMSUB_VV_M4_E64_MASK,
  PseudoVFNMSUB_VV_M8_E16,
  PseudoVFNMSUB_VV_M8_E16_MASK,
  PseudoVFNMSUB_VV_M8_E32,
  PseudoVFNMSUB_VV_M8_E32_MASK,
  PseudoVFNMSUB_VV_M8_E64,
  PseudoVFNMSUB_VV_M8_E64_MASK,
  PseudoVFNMSUB_VV_MF2_E16,
  PseudoVFNMSUB_VV_MF2_E16_MASK,
  PseudoVFNMSUB_VV_MF2_E32,
  PseudoVFNMSUB_VV_MF2_E32_MASK,
  PseudoVFNMSUB_VV_MF4_E16,
  PseudoVFNMSUB_VV_MF4_E16_MASK,
  PseudoVFRDIV_VFPR16_M1_E16,
  PseudoVFRDIV_VFPR16_M1_E16_MASK,
  PseudoVFRDIV_VFPR16_M2_E16,
  PseudoVFRDIV_VFPR16_M2_E16_MASK,
  PseudoVFRDIV_VFPR16_M4_E16,
  PseudoVFRDIV_VFPR16_M4_E16_MASK,
  PseudoVFRDIV_VFPR16_M8_E16,
  PseudoVFRDIV_VFPR16_M8_E16_MASK,
  PseudoVFRDIV_VFPR16_MF2_E16,
  PseudoVFRDIV_VFPR16_MF2_E16_MASK,
  PseudoVFRDIV_VFPR16_MF4_E16,
  PseudoVFRDIV_VFPR16_MF4_E16_MASK,
  PseudoVFRDIV_VFPR32_M1_E32,
  PseudoVFRDIV_VFPR32_M1_E32_MASK,
  PseudoVFRDIV_VFPR32_M2_E32,
  PseudoVFRDIV_VFPR32_M2_E32_MASK,
  PseudoVFRDIV_VFPR32_M4_E32,
  PseudoVFRDIV_VFPR32_M4_E32_MASK,
  PseudoVFRDIV_VFPR32_M8_E32,
  PseudoVFRDIV_VFPR32_M8_E32_MASK,
  PseudoVFRDIV_VFPR32_MF2_E32,
  PseudoVFRDIV_VFPR32_MF2_E32_MASK,
  PseudoVFRDIV_VFPR64_M1_E64,
  PseudoVFRDIV_VFPR64_M1_E64_MASK,
  PseudoVFRDIV_VFPR64_M2_E64,
  PseudoVFRDIV_VFPR64_M2_E64_MASK,
  PseudoVFRDIV_VFPR64_M4_E64,
  PseudoVFRDIV_VFPR64_M4_E64_MASK,
  PseudoVFRDIV_VFPR64_M8_E64,
  PseudoVFRDIV_VFPR64_M8_E64_MASK,
  PseudoVFREC7_V_M1_E16,
  PseudoVFREC7_V_M1_E16_MASK,
  PseudoVFREC7_V_M1_E32,
  PseudoVFREC7_V_M1_E32_MASK,
  PseudoVFREC7_V_M1_E64,
  PseudoVFREC7_V_M1_E64_MASK,
  PseudoVFREC7_V_M2_E16,
  PseudoVFREC7_V_M2_E16_MASK,
  PseudoVFREC7_V_M2_E32,
  PseudoVFREC7_V_M2_E32_MASK,
  PseudoVFREC7_V_M2_E64,
  PseudoVFREC7_V_M2_E64_MASK,
  PseudoVFREC7_V_M4_E16,
  PseudoVFREC7_V_M4_E16_MASK,
  PseudoVFREC7_V_M4_E32,
  PseudoVFREC7_V_M4_E32_MASK,
  PseudoVFREC7_V_M4_E64,
  PseudoVFREC7_V_M4_E64_MASK,
  PseudoVFREC7_V_M8_E16,
  PseudoVFREC7_V_M8_E16_MASK,
  PseudoVFREC7_V_M8_E32,
  PseudoVFREC7_V_M8_E32_MASK,
  PseudoVFREC7_V_M8_E64,
  PseudoVFREC7_V_M8_E64_MASK,
  PseudoVFREC7_V_MF2_E16,
  PseudoVFREC7_V_MF2_E16_MASK,
  PseudoVFREC7_V_MF2_E32,
  PseudoVFREC7_V_MF2_E32_MASK,
  PseudoVFREC7_V_MF4_E16,
  PseudoVFREC7_V_MF4_E16_MASK,
  PseudoVFREDMAX_VS_M1_E16,
  PseudoVFREDMAX_VS_M1_E16_MASK,
  PseudoVFREDMAX_VS_M1_E32,
  PseudoVFREDMAX_VS_M1_E32_MASK,
  PseudoVFREDMAX_VS_M1_E64,
  PseudoVFREDMAX_VS_M1_E64_MASK,
  PseudoVFREDMAX_VS_M2_E16,
  PseudoVFREDMAX_VS_M2_E16_MASK,
  PseudoVFREDMAX_VS_M2_E32,
  PseudoVFREDMAX_VS_M2_E32_MASK,
  PseudoVFREDMAX_VS_M2_E64,
  PseudoVFREDMAX_VS_M2_E64_MASK,
  PseudoVFREDMAX_VS_M4_E16,
  PseudoVFREDMAX_VS_M4_E16_MASK,
  PseudoVFREDMAX_VS_M4_E32,
  PseudoVFREDMAX_VS_M4_E32_MASK,
  PseudoVFREDMAX_VS_M4_E64,
  PseudoVFREDMAX_VS_M4_E64_MASK,
  PseudoVFREDMAX_VS_M8_E16,
  PseudoVFREDMAX_VS_M8_E16_MASK,
  PseudoVFREDMAX_VS_M8_E32,
  PseudoVFREDMAX_VS_M8_E32_MASK,
  PseudoVFREDMAX_VS_M8_E64,
  PseudoVFREDMAX_VS_M8_E64_MASK,
  PseudoVFREDMAX_VS_MF2_E16,
  PseudoVFREDMAX_VS_MF2_E16_MASK,
  PseudoVFREDMAX_VS_MF2_E32,
  PseudoVFREDMAX_VS_MF2_E32_MASK,
  PseudoVFREDMAX_VS_MF4_E16,
  PseudoVFREDMAX_VS_MF4_E16_MASK,
  PseudoVFREDMIN_VS_M1_E16,
  PseudoVFREDMIN_VS_M1_E16_MASK,
  PseudoVFREDMIN_VS_M1_E32,
  PseudoVFREDMIN_VS_M1_E32_MASK,
  PseudoVFREDMIN_VS_M1_E64,
  PseudoVFREDMIN_VS_M1_E64_MASK,
  PseudoVFREDMIN_VS_M2_E16,
  PseudoVFREDMIN_VS_M2_E16_MASK,
  PseudoVFREDMIN_VS_M2_E32,
  PseudoVFREDMIN_VS_M2_E32_MASK,
  PseudoVFREDMIN_VS_M2_E64,
  PseudoVFREDMIN_VS_M2_E64_MASK,
  PseudoVFREDMIN_VS_M4_E16,
  PseudoVFREDMIN_VS_M4_E16_MASK,
  PseudoVFREDMIN_VS_M4_E32,
  PseudoVFREDMIN_VS_M4_E32_MASK,
  PseudoVFREDMIN_VS_M4_E64,
  PseudoVFREDMIN_VS_M4_E64_MASK,
  PseudoVFREDMIN_VS_M8_E16,
  PseudoVFREDMIN_VS_M8_E16_MASK,
  PseudoVFREDMIN_VS_M8_E32,
  PseudoVFREDMIN_VS_M8_E32_MASK,
  PseudoVFREDMIN_VS_M8_E64,
  PseudoVFREDMIN_VS_M8_E64_MASK,
  PseudoVFREDMIN_VS_MF2_E16,
  PseudoVFREDMIN_VS_MF2_E16_MASK,
  PseudoVFREDMIN_VS_MF2_E32,
  PseudoVFREDMIN_VS_MF2_E32_MASK,
  PseudoVFREDMIN_VS_MF4_E16,
  PseudoVFREDMIN_VS_MF4_E16_MASK,
  PseudoVFREDOSUM_VS_M1_E16,
  PseudoVFREDOSUM_VS_M1_E16_MASK,
  PseudoVFREDOSUM_VS_M1_E32,
  PseudoVFREDOSUM_VS_M1_E32_MASK,
  PseudoVFREDOSUM_VS_M1_E64,
  PseudoVFREDOSUM_VS_M1_E64_MASK,
  PseudoVFREDOSUM_VS_M2_E16,
  PseudoVFREDOSUM_VS_M2_E16_MASK,
  PseudoVFREDOSUM_VS_M2_E32,
  PseudoVFREDOSUM_VS_M2_E32_MASK,
  PseudoVFREDOSUM_VS_M2_E64,
  PseudoVFREDOSUM_VS_M2_E64_MASK,
  PseudoVFREDOSUM_VS_M4_E16,
  PseudoVFREDOSUM_VS_M4_E16_MASK,
  PseudoVFREDOSUM_VS_M4_E32,
  PseudoVFREDOSUM_VS_M4_E32_MASK,
  PseudoVFREDOSUM_VS_M4_E64,
  PseudoVFREDOSUM_VS_M4_E64_MASK,
  PseudoVFREDOSUM_VS_M8_E16,
  PseudoVFREDOSUM_VS_M8_E16_MASK,
  PseudoVFREDOSUM_VS_M8_E32,
  PseudoVFREDOSUM_VS_M8_E32_MASK,
  PseudoVFREDOSUM_VS_M8_E64,
  PseudoVFREDOSUM_VS_M8_E64_MASK,
  PseudoVFREDOSUM_VS_MF2_E16,
  PseudoVFREDOSUM_VS_MF2_E16_MASK,
  PseudoVFREDOSUM_VS_MF2_E32,
  PseudoVFREDOSUM_VS_MF2_E32_MASK,
  PseudoVFREDOSUM_VS_MF4_E16,
  PseudoVFREDOSUM_VS_MF4_E16_MASK,
  PseudoVFREDUSUM_VS_M1_E16,
  PseudoVFREDUSUM_VS_M1_E16_MASK,
  PseudoVFREDUSUM_VS_M1_E32,
  PseudoVFREDUSUM_VS_M1_E32_MASK,
  PseudoVFREDUSUM_VS_M1_E64,
  PseudoVFREDUSUM_VS_M1_E64_MASK,
  PseudoVFREDUSUM_VS_M2_E16,
  PseudoVFREDUSUM_VS_M2_E16_MASK,
  PseudoVFREDUSUM_VS_M2_E32,
  PseudoVFREDUSUM_VS_M2_E32_MASK,
  PseudoVFREDUSUM_VS_M2_E64,
  PseudoVFREDUSUM_VS_M2_E64_MASK,
  PseudoVFREDUSUM_VS_M4_E16,
  PseudoVFREDUSUM_VS_M4_E16_MASK,
  PseudoVFREDUSUM_VS_M4_E32,
  PseudoVFREDUSUM_VS_M4_E32_MASK,
  PseudoVFREDUSUM_VS_M4_E64,
  PseudoVFREDUSUM_VS_M4_E64_MASK,
  PseudoVFREDUSUM_VS_M8_E16,
  PseudoVFREDUSUM_VS_M8_E16_MASK,
  PseudoVFREDUSUM_VS_M8_E32,
  PseudoVFREDUSUM_VS_M8_E32_MASK,
  PseudoVFREDUSUM_VS_M8_E64,
  PseudoVFREDUSUM_VS_M8_E64_MASK,
  PseudoVFREDUSUM_VS_MF2_E16,
  PseudoVFREDUSUM_VS_MF2_E16_MASK,
  PseudoVFREDUSUM_VS_MF2_E32,
  PseudoVFREDUSUM_VS_MF2_E32_MASK,
  PseudoVFREDUSUM_VS_MF4_E16,
  PseudoVFREDUSUM_VS_MF4_E16_MASK,
  PseudoVFROUND_NOEXCEPT_V_M1_MASK,
  PseudoVFROUND_NOEXCEPT_V_M2_MASK,
  PseudoVFROUND_NOEXCEPT_V_M4_MASK,
  PseudoVFROUND_NOEXCEPT_V_M8_MASK,
  PseudoVFROUND_NOEXCEPT_V_MF2_MASK,
  PseudoVFROUND_NOEXCEPT_V_MF4_MASK,
  PseudoVFRSQRT7_V_M1_E16,
  PseudoVFRSQRT7_V_M1_E16_MASK,
  PseudoVFRSQRT7_V_M1_E32,
  PseudoVFRSQRT7_V_M1_E32_MASK,
  PseudoVFRSQRT7_V_M1_E64,
  PseudoVFRSQRT7_V_M1_E64_MASK,
  PseudoVFRSQRT7_V_M2_E16,
  PseudoVFRSQRT7_V_M2_E16_MASK,
  PseudoVFRSQRT7_V_M2_E32,
  PseudoVFRSQRT7_V_M2_E32_MASK,
  PseudoVFRSQRT7_V_M2_E64,
  PseudoVFRSQRT7_V_M2_E64_MASK,
  PseudoVFRSQRT7_V_M4_E16,
  PseudoVFRSQRT7_V_M4_E16_MASK,
  PseudoVFRSQRT7_V_M4_E32,
  PseudoVFRSQRT7_V_M4_E32_MASK,
  PseudoVFRSQRT7_V_M4_E64,
  PseudoVFRSQRT7_V_M4_E64_MASK,
  PseudoVFRSQRT7_V_M8_E16,
  PseudoVFRSQRT7_V_M8_E16_MASK,
  PseudoVFRSQRT7_V_M8_E32,
  PseudoVFRSQRT7_V_M8_E32_MASK,
  PseudoVFRSQRT7_V_M8_E64,
  PseudoVFRSQRT7_V_M8_E64_MASK,
  PseudoVFRSQRT7_V_MF2_E16,
  PseudoVFRSQRT7_V_MF2_E16_MASK,
  PseudoVFRSQRT7_V_MF2_E32,
  PseudoVFRSQRT7_V_MF2_E32_MASK,
  PseudoVFRSQRT7_V_MF4_E16,
  PseudoVFRSQRT7_V_MF4_E16_MASK,
  PseudoVFRSUB_VFPR16_M1_E16,
  PseudoVFRSUB_VFPR16_M1_E16_MASK,
  PseudoVFRSUB_VFPR16_M2_E16,
  PseudoVFRSUB_VFPR16_M2_E16_MASK,
  PseudoVFRSUB_VFPR16_M4_E16,
  PseudoVFRSUB_VFPR16_M4_E16_MASK,
  PseudoVFRSUB_VFPR16_M8_E16,
  PseudoVFRSUB_VFPR16_M8_E16_MASK,
  PseudoVFRSUB_VFPR16_MF2_E16,
  PseudoVFRSUB_VFPR16_MF2_E16_MASK,
  PseudoVFRSUB_VFPR16_MF4_E16,
  PseudoVFRSUB_VFPR16_MF4_E16_MASK,
  PseudoVFRSUB_VFPR32_M1_E32,
  PseudoVFRSUB_VFPR32_M1_E32_MASK,
  PseudoVFRSUB_VFPR32_M2_E32,
  PseudoVFRSUB_VFPR32_M2_E32_MASK,
  PseudoVFRSUB_VFPR32_M4_E32,
  PseudoVFRSUB_VFPR32_M4_E32_MASK,
  PseudoVFRSUB_VFPR32_M8_E32,
  PseudoVFRSUB_VFPR32_M8_E32_MASK,
  PseudoVFRSUB_VFPR32_MF2_E32,
  PseudoVFRSUB_VFPR32_MF2_E32_MASK,
  PseudoVFRSUB_VFPR64_M1_E64,
  PseudoVFRSUB_VFPR64_M1_E64_MASK,
  PseudoVFRSUB_VFPR64_M2_E64,
  PseudoVFRSUB_VFPR64_M2_E64_MASK,
  PseudoVFRSUB_VFPR64_M4_E64,
  PseudoVFRSUB_VFPR64_M4_E64_MASK,
  PseudoVFRSUB_VFPR64_M8_E64,
  PseudoVFRSUB_VFPR64_M8_E64_MASK,
  PseudoVFSGNJN_VFPR16_M1_E16,
  PseudoVFSGNJN_VFPR16_M1_E16_MASK,
  PseudoVFSGNJN_VFPR16_M2_E16,
  PseudoVFSGNJN_VFPR16_M2_E16_MASK,
  PseudoVFSGNJN_VFPR16_M4_E16,
  PseudoVFSGNJN_VFPR16_M4_E16_MASK,
  PseudoVFSGNJN_VFPR16_M8_E16,
  PseudoVFSGNJN_VFPR16_M8_E16_MASK,
  PseudoVFSGNJN_VFPR16_MF2_E16,
  PseudoVFSGNJN_VFPR16_MF2_E16_MASK,
  PseudoVFSGNJN_VFPR16_MF4_E16,
  PseudoVFSGNJN_VFPR16_MF4_E16_MASK,
  PseudoVFSGNJN_VFPR32_M1_E32,
  PseudoVFSGNJN_VFPR32_M1_E32_MASK,
  PseudoVFSGNJN_VFPR32_M2_E32,
  PseudoVFSGNJN_VFPR32_M2_E32_MASK,
  PseudoVFSGNJN_VFPR32_M4_E32,
  PseudoVFSGNJN_VFPR32_M4_E32_MASK,
  PseudoVFSGNJN_VFPR32_M8_E32,
  PseudoVFSGNJN_VFPR32_M8_E32_MASK,
  PseudoVFSGNJN_VFPR32_MF2_E32,
  PseudoVFSGNJN_VFPR32_MF2_E32_MASK,
  PseudoVFSGNJN_VFPR64_M1_E64,
  PseudoVFSGNJN_VFPR64_M1_E64_MASK,
  PseudoVFSGNJN_VFPR64_M2_E64,
  PseudoVFSGNJN_VFPR64_M2_E64_MASK,
  PseudoVFSGNJN_VFPR64_M4_E64,
  PseudoVFSGNJN_VFPR64_M4_E64_MASK,
  PseudoVFSGNJN_VFPR64_M8_E64,
  PseudoVFSGNJN_VFPR64_M8_E64_MASK,
  PseudoVFSGNJN_VV_M1_E16,
  PseudoVFSGNJN_VV_M1_E16_MASK,
  PseudoVFSGNJN_VV_M1_E32,
  PseudoVFSGNJN_VV_M1_E32_MASK,
  PseudoVFSGNJN_VV_M1_E64,
  PseudoVFSGNJN_VV_M1_E64_MASK,
  PseudoVFSGNJN_VV_M2_E16,
  PseudoVFSGNJN_VV_M2_E16_MASK,
  PseudoVFSGNJN_VV_M2_E32,
  PseudoVFSGNJN_VV_M2_E32_MASK,
  PseudoVFSGNJN_VV_M2_E64,
  PseudoVFSGNJN_VV_M2_E64_MASK,
  PseudoVFSGNJN_VV_M4_E16,
  PseudoVFSGNJN_VV_M4_E16_MASK,
  PseudoVFSGNJN_VV_M4_E32,
  PseudoVFSGNJN_VV_M4_E32_MASK,
  PseudoVFSGNJN_VV_M4_E64,
  PseudoVFSGNJN_VV_M4_E64_MASK,
  PseudoVFSGNJN_VV_M8_E16,
  PseudoVFSGNJN_VV_M8_E16_MASK,
  PseudoVFSGNJN_VV_M8_E32,
  PseudoVFSGNJN_VV_M8_E32_MASK,
  PseudoVFSGNJN_VV_M8_E64,
  PseudoVFSGNJN_VV_M8_E64_MASK,
  PseudoVFSGNJN_VV_MF2_E16,
  PseudoVFSGNJN_VV_MF2_E16_MASK,
  PseudoVFSGNJN_VV_MF2_E32,
  PseudoVFSGNJN_VV_MF2_E32_MASK,
  PseudoVFSGNJN_VV_MF4_E16,
  PseudoVFSGNJN_VV_MF4_E16_MASK,
  PseudoVFSGNJX_VFPR16_M1_E16,
  PseudoVFSGNJX_VFPR16_M1_E16_MASK,
  PseudoVFSGNJX_VFPR16_M2_E16,
  PseudoVFSGNJX_VFPR16_M2_E16_MASK,
  PseudoVFSGNJX_VFPR16_M4_E16,
  PseudoVFSGNJX_VFPR16_M4_E16_MASK,
  PseudoVFSGNJX_VFPR16_M8_E16,
  PseudoVFSGNJX_VFPR16_M8_E16_MASK,
  PseudoVFSGNJX_VFPR16_MF2_E16,
  PseudoVFSGNJX_VFPR16_MF2_E16_MASK,
  PseudoVFSGNJX_VFPR16_MF4_E16,
  PseudoVFSGNJX_VFPR16_MF4_E16_MASK,
  PseudoVFSGNJX_VFPR32_M1_E32,
  PseudoVFSGNJX_VFPR32_M1_E32_MASK,
  PseudoVFSGNJX_VFPR32_M2_E32,
  PseudoVFSGNJX_VFPR32_M2_E32_MASK,
  PseudoVFSGNJX_VFPR32_M4_E32,
  PseudoVFSGNJX_VFPR32_M4_E32_MASK,
  PseudoVFSGNJX_VFPR32_M8_E32,
  PseudoVFSGNJX_VFPR32_M8_E32_MASK,
  PseudoVFSGNJX_VFPR32_MF2_E32,
  PseudoVFSGNJX_VFPR32_MF2_E32_MASK,
  PseudoVFSGNJX_VFPR64_M1_E64,
  PseudoVFSGNJX_VFPR64_M1_E64_MASK,
  PseudoVFSGNJX_VFPR64_M2_E64,
  PseudoVFSGNJX_VFPR64_M2_E64_MASK,
  PseudoVFSGNJX_VFPR64_M4_E64,
  PseudoVFSGNJX_VFPR64_M4_E64_MASK,
  PseudoVFSGNJX_VFPR64_M8_E64,
  PseudoVFSGNJX_VFPR64_M8_E64_MASK,
  PseudoVFSGNJX_VV_M1_E16,
  PseudoVFSGNJX_VV_M1_E16_MASK,
  PseudoVFSGNJX_VV_M1_E32,
  PseudoVFSGNJX_VV_M1_E32_MASK,
  PseudoVFSGNJX_VV_M1_E64,
  PseudoVFSGNJX_VV_M1_E64_MASK,
  PseudoVFSGNJX_VV_M2_E16,
  PseudoVFSGNJX_VV_M2_E16_MASK,
  PseudoVFSGNJX_VV_M2_E32,
  PseudoVFSGNJX_VV_M2_E32_MASK,
  PseudoVFSGNJX_VV_M2_E64,
  PseudoVFSGNJX_VV_M2_E64_MASK,
  PseudoVFSGNJX_VV_M4_E16,
  PseudoVFSGNJX_VV_M4_E16_MASK,
  PseudoVFSGNJX_VV_M4_E32,
  PseudoVFSGNJX_VV_M4_E32_MASK,
  PseudoVFSGNJX_VV_M4_E64,
  PseudoVFSGNJX_VV_M4_E64_MASK,
  PseudoVFSGNJX_VV_M8_E16,
  PseudoVFSGNJX_VV_M8_E16_MASK,
  PseudoVFSGNJX_VV_M8_E32,
  PseudoVFSGNJX_VV_M8_E32_MASK,
  PseudoVFSGNJX_VV_M8_E64,
  PseudoVFSGNJX_VV_M8_E64_MASK,
  PseudoVFSGNJX_VV_MF2_E16,
  PseudoVFSGNJX_VV_MF2_E16_MASK,
  PseudoVFSGNJX_VV_MF2_E32,
  PseudoVFSGNJX_VV_MF2_E32_MASK,
  PseudoVFSGNJX_VV_MF4_E16,
  PseudoVFSGNJX_VV_MF4_E16_MASK,
  PseudoVFSGNJ_VFPR16_M1_E16,
  PseudoVFSGNJ_VFPR16_M1_E16_MASK,
  PseudoVFSGNJ_VFPR16_M2_E16,
  PseudoVFSGNJ_VFPR16_M2_E16_MASK,
  PseudoVFSGNJ_VFPR16_M4_E16,
  PseudoVFSGNJ_VFPR16_M4_E16_MASK,
  PseudoVFSGNJ_VFPR16_M8_E16,
  PseudoVFSGNJ_VFPR16_M8_E16_MASK,
  PseudoVFSGNJ_VFPR16_MF2_E16,
  PseudoVFSGNJ_VFPR16_MF2_E16_MASK,
  PseudoVFSGNJ_VFPR16_MF4_E16,
  PseudoVFSGNJ_VFPR16_MF4_E16_MASK,
  PseudoVFSGNJ_VFPR32_M1_E32,
  PseudoVFSGNJ_VFPR32_M1_E32_MASK,
  PseudoVFSGNJ_VFPR32_M2_E32,
  PseudoVFSGNJ_VFPR32_M2_E32_MASK,
  PseudoVFSGNJ_VFPR32_M4_E32,
  PseudoVFSGNJ_VFPR32_M4_E32_MASK,
  PseudoVFSGNJ_VFPR32_M8_E32,
  PseudoVFSGNJ_VFPR32_M8_E32_MASK,
  PseudoVFSGNJ_VFPR32_MF2_E32,
  PseudoVFSGNJ_VFPR32_MF2_E32_MASK,
  PseudoVFSGNJ_VFPR64_M1_E64,
  PseudoVFSGNJ_VFPR64_M1_E64_MASK,
  PseudoVFSGNJ_VFPR64_M2_E64,
  PseudoVFSGNJ_VFPR64_M2_E64_MASK,
  PseudoVFSGNJ_VFPR64_M4_E64,
  PseudoVFSGNJ_VFPR64_M4_E64_MASK,
  PseudoVFSGNJ_VFPR64_M8_E64,
  PseudoVFSGNJ_VFPR64_M8_E64_MASK,
  PseudoVFSGNJ_VV_M1_E16,
  PseudoVFSGNJ_VV_M1_E16_MASK,
  PseudoVFSGNJ_VV_M1_E32,
  PseudoVFSGNJ_VV_M1_E32_MASK,
  PseudoVFSGNJ_VV_M1_E64,
  PseudoVFSGNJ_VV_M1_E64_MASK,
  PseudoVFSGNJ_VV_M2_E16,
  PseudoVFSGNJ_VV_M2_E16_MASK,
  PseudoVFSGNJ_VV_M2_E32,
  PseudoVFSGNJ_VV_M2_E32_MASK,
  PseudoVFSGNJ_VV_M2_E64,
  PseudoVFSGNJ_VV_M2_E64_MASK,
  PseudoVFSGNJ_VV_M4_E16,
  PseudoVFSGNJ_VV_M4_E16_MASK,
  PseudoVFSGNJ_VV_M4_E32,
  PseudoVFSGNJ_VV_M4_E32_MASK,
  PseudoVFSGNJ_VV_M4_E64,
  PseudoVFSGNJ_VV_M4_E64_MASK,
  PseudoVFSGNJ_VV_M8_E16,
  PseudoVFSGNJ_VV_M8_E16_MASK,
  PseudoVFSGNJ_VV_M8_E32,
  PseudoVFSGNJ_VV_M8_E32_MASK,
  PseudoVFSGNJ_VV_M8_E64,
  PseudoVFSGNJ_VV_M8_E64_MASK,
  PseudoVFSGNJ_VV_MF2_E16,
  PseudoVFSGNJ_VV_MF2_E16_MASK,
  PseudoVFSGNJ_VV_MF2_E32,
  PseudoVFSGNJ_VV_MF2_E32_MASK,
  PseudoVFSGNJ_VV_MF4_E16,
  PseudoVFSGNJ_VV_MF4_E16_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_M1,
  PseudoVFSLIDE1DOWN_VFPR16_M1_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_M2,
  PseudoVFSLIDE1DOWN_VFPR16_M2_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_M4,
  PseudoVFSLIDE1DOWN_VFPR16_M4_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_M8,
  PseudoVFSLIDE1DOWN_VFPR16_M8_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_MF2,
  PseudoVFSLIDE1DOWN_VFPR16_MF2_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_MF4,
  PseudoVFSLIDE1DOWN_VFPR16_MF4_MASK,
  PseudoVFSLIDE1DOWN_VFPR32_M1,
  PseudoVFSLIDE1DOWN_VFPR32_M1_MASK,
  PseudoVFSLIDE1DOWN_VFPR32_M2,
  PseudoVFSLIDE1DOWN_VFPR32_M2_MASK,
  PseudoVFSLIDE1DOWN_VFPR32_M4,
  PseudoVFSLIDE1DOWN_VFPR32_M4_MASK,
  PseudoVFSLIDE1DOWN_VFPR32_M8,
  PseudoVFSLIDE1DOWN_VFPR32_M8_MASK,
  PseudoVFSLIDE1DOWN_VFPR32_MF2,
  PseudoVFSLIDE1DOWN_VFPR32_MF2_MASK,
  PseudoVFSLIDE1DOWN_VFPR64_M1,
  PseudoVFSLIDE1DOWN_VFPR64_M1_MASK,
  PseudoVFSLIDE1DOWN_VFPR64_M2,
  PseudoVFSLIDE1DOWN_VFPR64_M2_MASK,
  PseudoVFSLIDE1DOWN_VFPR64_M4,
  PseudoVFSLIDE1DOWN_VFPR64_M4_MASK,
  PseudoVFSLIDE1DOWN_VFPR64_M8,
  PseudoVFSLIDE1DOWN_VFPR64_M8_MASK,
  PseudoVFSLIDE1UP_VFPR16_M1,
  PseudoVFSLIDE1UP_VFPR16_M1_MASK,
  PseudoVFSLIDE1UP_VFPR16_M2,
  PseudoVFSLIDE1UP_VFPR16_M2_MASK,
  PseudoVFSLIDE1UP_VFPR16_M4,
  PseudoVFSLIDE1UP_VFPR16_M4_MASK,
  PseudoVFSLIDE1UP_VFPR16_M8,
  PseudoVFSLIDE1UP_VFPR16_M8_MASK,
  PseudoVFSLIDE1UP_VFPR16_MF2,
  PseudoVFSLIDE1UP_VFPR16_MF2_MASK,
  PseudoVFSLIDE1UP_VFPR16_MF4,
  PseudoVFSLIDE1UP_VFPR16_MF4_MASK,
  PseudoVFSLIDE1UP_VFPR32_M1,
  PseudoVFSLIDE1UP_VFPR32_M1_MASK,
  PseudoVFSLIDE1UP_VFPR32_M2,
  PseudoVFSLIDE1UP_VFPR32_M2_MASK,
  PseudoVFSLIDE1UP_VFPR32_M4,
  PseudoVFSLIDE1UP_VFPR32_M4_MASK,
  PseudoVFSLIDE1UP_VFPR32_M8,
  PseudoVFSLIDE1UP_VFPR32_M8_MASK,
  PseudoVFSLIDE1UP_VFPR32_MF2,
  PseudoVFSLIDE1UP_VFPR32_MF2_MASK,
  PseudoVFSLIDE1UP_VFPR64_M1,
  PseudoVFSLIDE1UP_VFPR64_M1_MASK,
  PseudoVFSLIDE1UP_VFPR64_M2,
  PseudoVFSLIDE1UP_VFPR64_M2_MASK,
  PseudoVFSLIDE1UP_VFPR64_M4,
  PseudoVFSLIDE1UP_VFPR64_M4_MASK,
  PseudoVFSLIDE1UP_VFPR64_M8,
  PseudoVFSLIDE1UP_VFPR64_M8_MASK,
  PseudoVFSQRT_V_M1_E16,
  PseudoVFSQRT_V_M1_E16_MASK,
  PseudoVFSQRT_V_M1_E32,
  PseudoVFSQRT_V_M1_E32_MASK,
  PseudoVFSQRT_V_M1_E64,
  PseudoVFSQRT_V_M1_E64_MASK,
  PseudoVFSQRT_V_M2_E16,
  PseudoVFSQRT_V_M2_E16_MASK,
  PseudoVFSQRT_V_M2_E32,
  PseudoVFSQRT_V_M2_E32_MASK,
  PseudoVFSQRT_V_M2_E64,
  PseudoVFSQRT_V_M2_E64_MASK,
  PseudoVFSQRT_V_M4_E16,
  PseudoVFSQRT_V_M4_E16_MASK,
  PseudoVFSQRT_V_M4_E32,
  PseudoVFSQRT_V_M4_E32_MASK,
  PseudoVFSQRT_V_M4_E64,
  PseudoVFSQRT_V_M4_E64_MASK,
  PseudoVFSQRT_V_M8_E16,
  PseudoVFSQRT_V_M8_E16_MASK,
  PseudoVFSQRT_V_M8_E32,
  PseudoVFSQRT_V_M8_E32_MASK,
  PseudoVFSQRT_V_M8_E64,
  PseudoVFSQRT_V_M8_E64_MASK,
  PseudoVFSQRT_V_MF2_E16,
  PseudoVFSQRT_V_MF2_E16_MASK,
  PseudoVFSQRT_V_MF2_E32,
  PseudoVFSQRT_V_MF2_E32_MASK,
  PseudoVFSQRT_V_MF4_E16,
  PseudoVFSQRT_V_MF4_E16_MASK,
  PseudoVFSUB_VFPR16_M1_E16,
  PseudoVFSUB_VFPR16_M1_E16_MASK,
  PseudoVFSUB_VFPR16_M2_E16,
  PseudoVFSUB_VFPR16_M2_E16_MASK,
  PseudoVFSUB_VFPR16_M4_E16,
  PseudoVFSUB_VFPR16_M4_E16_MASK,
  PseudoVFSUB_VFPR16_M8_E16,
  PseudoVFSUB_VFPR16_M8_E16_MASK,
  PseudoVFSUB_VFPR16_MF2_E16,
  PseudoVFSUB_VFPR16_MF2_E16_MASK,
  PseudoVFSUB_VFPR16_MF4_E16,
  PseudoVFSUB_VFPR16_MF4_E16_MASK,
  PseudoVFSUB_VFPR32_M1_E32,
  PseudoVFSUB_VFPR32_M1_E32_MASK,
  PseudoVFSUB_VFPR32_M2_E32,
  PseudoVFSUB_VFPR32_M2_E32_MASK,
  PseudoVFSUB_VFPR32_M4_E32,
  PseudoVFSUB_VFPR32_M4_E32_MASK,
  PseudoVFSUB_VFPR32_M8_E32,
  PseudoVFSUB_VFPR32_M8_E32_MASK,
  PseudoVFSUB_VFPR32_MF2_E32,
  PseudoVFSUB_VFPR32_MF2_E32_MASK,
  PseudoVFSUB_VFPR64_M1_E64,
  PseudoVFSUB_VFPR64_M1_E64_MASK,
  PseudoVFSUB_VFPR64_M2_E64,
  PseudoVFSUB_VFPR64_M2_E64_MASK,
  PseudoVFSUB_VFPR64_M4_E64,
  PseudoVFSUB_VFPR64_M4_E64_MASK,
  PseudoVFSUB_VFPR64_M8_E64,
  PseudoVFSUB_VFPR64_M8_E64_MASK,
  PseudoVFSUB_VV_M1_E16,
  PseudoVFSUB_VV_M1_E16_MASK,
  PseudoVFSUB_VV_M1_E32,
  PseudoVFSUB_VV_M1_E32_MASK,
  PseudoVFSUB_VV_M1_E64,
  PseudoVFSUB_VV_M1_E64_MASK,
  PseudoVFSUB_VV_M2_E16,
  PseudoVFSUB_VV_M2_E16_MASK,
  PseudoVFSUB_VV_M2_E32,
  PseudoVFSUB_VV_M2_E32_MASK,
  PseudoVFSUB_VV_M2_E64,
  PseudoVFSUB_VV_M2_E64_MASK,
  PseudoVFSUB_VV_M4_E16,
  PseudoVFSUB_VV_M4_E16_MASK,
  PseudoVFSUB_VV_M4_E32,
  PseudoVFSUB_VV_M4_E32_MASK,
  PseudoVFSUB_VV_M4_E64,
  PseudoVFSUB_VV_M4_E64_MASK,
  PseudoVFSUB_VV_M8_E16,
  PseudoVFSUB_VV_M8_E16_MASK,
  PseudoVFSUB_VV_M8_E32,
  PseudoVFSUB_VV_M8_E32_MASK,
  PseudoVFSUB_VV_M8_E64,
  PseudoVFSUB_VV_M8_E64_MASK,
  PseudoVFSUB_VV_MF2_E16,
  PseudoVFSUB_VV_MF2_E16_MASK,
  PseudoVFSUB_VV_MF2_E32,
  PseudoVFSUB_VV_MF2_E32_MASK,
  PseudoVFSUB_VV_MF4_E16,
  PseudoVFSUB_VV_MF4_E16_MASK,
  PseudoVFWADD_VFPR16_M1_E16,
  PseudoVFWADD_VFPR16_M1_E16_MASK,
  PseudoVFWADD_VFPR16_M2_E16,
  PseudoVFWADD_VFPR16_M2_E16_MASK,
  PseudoVFWADD_VFPR16_M4_E16,
  PseudoVFWADD_VFPR16_M4_E16_MASK,
  PseudoVFWADD_VFPR16_MF2_E16,
  PseudoVFWADD_VFPR16_MF2_E16_MASK,
  PseudoVFWADD_VFPR16_MF4_E16,
  PseudoVFWADD_VFPR16_MF4_E16_MASK,
  PseudoVFWADD_VFPR32_M1_E32,
  PseudoVFWADD_VFPR32_M1_E32_MASK,
  PseudoVFWADD_VFPR32_M2_E32,
  PseudoVFWADD_VFPR32_M2_E32_MASK,
  PseudoVFWADD_VFPR32_M4_E32,
  PseudoVFWADD_VFPR32_M4_E32_MASK,
  PseudoVFWADD_VFPR32_MF2_E32,
  PseudoVFWADD_VFPR32_MF2_E32_MASK,
  PseudoVFWADD_VV_M1_E16,
  PseudoVFWADD_VV_M1_E16_MASK,
  PseudoVFWADD_VV_M1_E32,
  PseudoVFWADD_VV_M1_E32_MASK,
  PseudoVFWADD_VV_M2_E16,
  PseudoVFWADD_VV_M2_E16_MASK,
  PseudoVFWADD_VV_M2_E32,
  PseudoVFWADD_VV_M2_E32_MASK,
  PseudoVFWADD_VV_M4_E16,
  PseudoVFWADD_VV_M4_E16_MASK,
  PseudoVFWADD_VV_M4_E32,
  PseudoVFWADD_VV_M4_E32_MASK,
  PseudoVFWADD_VV_MF2_E16,
  PseudoVFWADD_VV_MF2_E16_MASK,
  PseudoVFWADD_VV_MF2_E32,
  PseudoVFWADD_VV_MF2_E32_MASK,
  PseudoVFWADD_VV_MF4_E16,
  PseudoVFWADD_VV_MF4_E16_MASK,
  PseudoVFWADD_WFPR16_M1_E16,
  PseudoVFWADD_WFPR16_M1_E16_MASK,
  PseudoVFWADD_WFPR16_M2_E16,
  PseudoVFWADD_WFPR16_M2_E16_MASK,
  PseudoVFWADD_WFPR16_M4_E16,
  PseudoVFWADD_WFPR16_M4_E16_MASK,
  PseudoVFWADD_WFPR16_MF2_E16,
  PseudoVFWADD_WFPR16_MF2_E16_MASK,
  PseudoVFWADD_WFPR16_MF4_E16,
  PseudoVFWADD_WFPR16_MF4_E16_MASK,
  PseudoVFWADD_WFPR32_M1_E32,
  PseudoVFWADD_WFPR32_M1_E32_MASK,
  PseudoVFWADD_WFPR32_M2_E32,
  PseudoVFWADD_WFPR32_M2_E32_MASK,
  PseudoVFWADD_WFPR32_M4_E32,
  PseudoVFWADD_WFPR32_M4_E32_MASK,
  PseudoVFWADD_WFPR32_MF2_E32,
  PseudoVFWADD_WFPR32_MF2_E32_MASK,
  PseudoVFWADD_WV_M1_E16,
  PseudoVFWADD_WV_M1_E16_MASK,
  PseudoVFWADD_WV_M1_E16_MASK_TIED,
  PseudoVFWADD_WV_M1_E16_TIED,
  PseudoVFWADD_WV_M1_E32,
  PseudoVFWADD_WV_M1_E32_MASK,
  PseudoVFWADD_WV_M1_E32_MASK_TIED,
  PseudoVFWADD_WV_M1_E32_TIED,
  PseudoVFWADD_WV_M2_E16,
  PseudoVFWADD_WV_M2_E16_MASK,
  PseudoVFWADD_WV_M2_E16_MASK_TIED,
  PseudoVFWADD_WV_M2_E16_TIED,
  PseudoVFWADD_WV_M2_E32,
  PseudoVFWADD_WV_M2_E32_MASK,
  PseudoVFWADD_WV_M2_E32_MASK_TIED,
  PseudoVFWADD_WV_M2_E32_TIED,
  PseudoVFWADD_WV_M4_E16,
  PseudoVFWADD_WV_M4_E16_MASK,
  PseudoVFWADD_WV_M4_E16_MASK_TIED,
  PseudoVFWADD_WV_M4_E16_TIED,
  PseudoVFWADD_WV_M4_E32,
  PseudoVFWADD_WV_M4_E32_MASK,
  PseudoVFWADD_WV_M4_E32_MASK_TIED,
  PseudoVFWADD_WV_M4_E32_TIED,
  PseudoVFWADD_WV_MF2_E16,
  PseudoVFWADD_WV_MF2_E16_MASK,
  PseudoVFWADD_WV_MF2_E16_MASK_TIED,
  PseudoVFWADD_WV_MF2_E16_TIED,
  PseudoVFWADD_WV_MF2_E32,
  PseudoVFWADD_WV_MF2_E32_MASK,
  PseudoVFWADD_WV_MF2_E32_MASK_TIED,
  PseudoVFWADD_WV_MF2_E32_TIED,
  PseudoVFWADD_WV_MF4_E16,
  PseudoVFWADD_WV_MF4_E16_MASK,
  PseudoVFWADD_WV_MF4_E16_MASK_TIED,
  PseudoVFWADD_WV_MF4_E16_TIED,
  PseudoVFWCVTBF16_F_F_V_M1_E16,
  PseudoVFWCVTBF16_F_F_V_M1_E16_MASK,
  PseudoVFWCVTBF16_F_F_V_M1_E32,
  PseudoVFWCVTBF16_F_F_V_M1_E32_MASK,
  PseudoVFWCVTBF16_F_F_V_M2_E16,
  PseudoVFWCVTBF16_F_F_V_M2_E16_MASK,
  PseudoVFWCVTBF16_F_F_V_M2_E32,
  PseudoVFWCVTBF16_F_F_V_M2_E32_MASK,
  PseudoVFWCVTBF16_F_F_V_M4_E16,
  PseudoVFWCVTBF16_F_F_V_M4_E16_MASK,
  PseudoVFWCVTBF16_F_F_V_M4_E32,
  PseudoVFWCVTBF16_F_F_V_M4_E32_MASK,
  PseudoVFWCVTBF16_F_F_V_MF2_E16,
  PseudoVFWCVTBF16_F_F_V_MF2_E16_MASK,
  PseudoVFWCVTBF16_F_F_V_MF2_E32,
  PseudoVFWCVTBF16_F_F_V_MF2_E32_MASK,
  PseudoVFWCVTBF16_F_F_V_MF4_E16,
  PseudoVFWCVTBF16_F_F_V_MF4_E16_MASK,
  PseudoVFWCVT_F_F_V_M1_E16,
  PseudoVFWCVT_F_F_V_M1_E16_MASK,
  PseudoVFWCVT_F_F_V_M1_E32,
  PseudoVFWCVT_F_F_V_M1_E32_MASK,
  PseudoVFWCVT_F_F_V_M2_E16,
  PseudoVFWCVT_F_F_V_M2_E16_MASK,
  PseudoVFWCVT_F_F_V_M2_E32,
  PseudoVFWCVT_F_F_V_M2_E32_MASK,
  PseudoVFWCVT_F_F_V_M4_E16,
  PseudoVFWCVT_F_F_V_M4_E16_MASK,
  PseudoVFWCVT_F_F_V_M4_E32,
  PseudoVFWCVT_F_F_V_M4_E32_MASK,
  PseudoVFWCVT_F_F_V_MF2_E16,
  PseudoVFWCVT_F_F_V_MF2_E16_MASK,
  PseudoVFWCVT_F_F_V_MF2_E32,
  PseudoVFWCVT_F_F_V_MF2_E32_MASK,
  PseudoVFWCVT_F_F_V_MF4_E16,
  PseudoVFWCVT_F_F_V_MF4_E16_MASK,
  PseudoVFWCVT_F_XU_V_M1_E16,
  PseudoVFWCVT_F_XU_V_M1_E16_MASK,
  PseudoVFWCVT_F_XU_V_M1_E32,
  PseudoVFWCVT_F_XU_V_M1_E32_MASK,
  PseudoVFWCVT_F_XU_V_M1_E8,
  PseudoVFWCVT_F_XU_V_M1_E8_MASK,
  PseudoVFWCVT_F_XU_V_M2_E16,
  PseudoVFWCVT_F_XU_V_M2_E16_MASK,
  PseudoVFWCVT_F_XU_V_M2_E32,
  PseudoVFWCVT_F_XU_V_M2_E32_MASK,
  PseudoVFWCVT_F_XU_V_M2_E8,
  PseudoVFWCVT_F_XU_V_M2_E8_MASK,
  PseudoVFWCVT_F_XU_V_M4_E16,
  PseudoVFWCVT_F_XU_V_M4_E16_MASK,
  PseudoVFWCVT_F_XU_V_M4_E32,
  PseudoVFWCVT_F_XU_V_M4_E32_MASK,
  PseudoVFWCVT_F_XU_V_M4_E8,
  PseudoVFWCVT_F_XU_V_M4_E8_MASK,
  PseudoVFWCVT_F_XU_V_MF2_E16,
  PseudoVFWCVT_F_XU_V_MF2_E16_MASK,
  PseudoVFWCVT_F_XU_V_MF2_E32,
  PseudoVFWCVT_F_XU_V_MF2_E32_MASK,
  PseudoVFWCVT_F_XU_V_MF2_E8,
  PseudoVFWCVT_F_XU_V_MF2_E8_MASK,
  PseudoVFWCVT_F_XU_V_MF4_E16,
  PseudoVFWCVT_F_XU_V_MF4_E16_MASK,
  PseudoVFWCVT_F_XU_V_MF4_E8,
  PseudoVFWCVT_F_XU_V_MF4_E8_MASK,
  PseudoVFWCVT_F_XU_V_MF8_E8,
  PseudoVFWCVT_F_XU_V_MF8_E8_MASK,
  PseudoVFWCVT_F_X_V_M1_E16,
  PseudoVFWCVT_F_X_V_M1_E16_MASK,
  PseudoVFWCVT_F_X_V_M1_E32,
  PseudoVFWCVT_F_X_V_M1_E32_MASK,
  PseudoVFWCVT_F_X_V_M1_E8,
  PseudoVFWCVT_F_X_V_M1_E8_MASK,
  PseudoVFWCVT_F_X_V_M2_E16,
  PseudoVFWCVT_F_X_V_M2_E16_MASK,
  PseudoVFWCVT_F_X_V_M2_E32,
  PseudoVFWCVT_F_X_V_M2_E32_MASK,
  PseudoVFWCVT_F_X_V_M2_E8,
  PseudoVFWCVT_F_X_V_M2_E8_MASK,
  PseudoVFWCVT_F_X_V_M4_E16,
  PseudoVFWCVT_F_X_V_M4_E16_MASK,
  PseudoVFWCVT_F_X_V_M4_E32,
  PseudoVFWCVT_F_X_V_M4_E32_MASK,
  PseudoVFWCVT_F_X_V_M4_E8,
  PseudoVFWCVT_F_X_V_M4_E8_MASK,
  PseudoVFWCVT_F_X_V_MF2_E16,
  PseudoVFWCVT_F_X_V_MF2_E16_MASK,
  PseudoVFWCVT_F_X_V_MF2_E32,
  PseudoVFWCVT_F_X_V_MF2_E32_MASK,
  PseudoVFWCVT_F_X_V_MF2_E8,
  PseudoVFWCVT_F_X_V_MF2_E8_MASK,
  PseudoVFWCVT_F_X_V_MF4_E16,
  PseudoVFWCVT_F_X_V_MF4_E16_MASK,
  PseudoVFWCVT_F_X_V_MF4_E8,
  PseudoVFWCVT_F_X_V_MF4_E8_MASK,
  PseudoVFWCVT_F_X_V_MF8_E8,
  PseudoVFWCVT_F_X_V_MF8_E8_MASK,
  PseudoVFWCVT_RTZ_XU_F_V_M1,
  PseudoVFWCVT_RTZ_XU_F_V_M1_MASK,
  PseudoVFWCVT_RTZ_XU_F_V_M2,
  PseudoVFWCVT_RTZ_XU_F_V_M2_MASK,
  PseudoVFWCVT_RTZ_XU_F_V_M4,
  PseudoVFWCVT_RTZ_XU_F_V_M4_MASK,
  PseudoVFWCVT_RTZ_XU_F_V_MF2,
  PseudoVFWCVT_RTZ_XU_F_V_MF2_MASK,
  PseudoVFWCVT_RTZ_XU_F_V_MF4,
  PseudoVFWCVT_RTZ_XU_F_V_MF4_MASK,
  PseudoVFWCVT_RTZ_X_F_V_M1,
  PseudoVFWCVT_RTZ_X_F_V_M1_MASK,
  PseudoVFWCVT_RTZ_X_F_V_M2,
  PseudoVFWCVT_RTZ_X_F_V_M2_MASK,
  PseudoVFWCVT_RTZ_X_F_V_M4,
  PseudoVFWCVT_RTZ_X_F_V_M4_MASK,
  PseudoVFWCVT_RTZ_X_F_V_MF2,
  PseudoVFWCVT_RTZ_X_F_V_MF2_MASK,
  PseudoVFWCVT_RTZ_X_F_V_MF4,
  PseudoVFWCVT_RTZ_X_F_V_MF4_MASK,
  PseudoVFWCVT_XU_F_V_M1,
  PseudoVFWCVT_XU_F_V_M1_MASK,
  PseudoVFWCVT_XU_F_V_M2,
  PseudoVFWCVT_XU_F_V_M2_MASK,
  PseudoVFWCVT_XU_F_V_M4,
  PseudoVFWCVT_XU_F_V_M4_MASK,
  PseudoVFWCVT_XU_F_V_MF2,
  PseudoVFWCVT_XU_F_V_MF2_MASK,
  PseudoVFWCVT_XU_F_V_MF4,
  PseudoVFWCVT_XU_F_V_MF4_MASK,
  PseudoVFWCVT_X_F_V_M1,
  PseudoVFWCVT_X_F_V_M1_MASK,
  PseudoVFWCVT_X_F_V_M2,
  PseudoVFWCVT_X_F_V_M2_MASK,
  PseudoVFWCVT_X_F_V_M4,
  PseudoVFWCVT_X_F_V_M4_MASK,
  PseudoVFWCVT_X_F_V_MF2,
  PseudoVFWCVT_X_F_V_MF2_MASK,
  PseudoVFWCVT_X_F_V_MF4,
  PseudoVFWCVT_X_F_V_MF4_MASK,
  PseudoVFWMACCBF16_VFPR16_M1_E16,
  PseudoVFWMACCBF16_VFPR16_M1_E16_MASK,
  PseudoVFWMACCBF16_VFPR16_M2_E16,
  PseudoVFWMACCBF16_VFPR16_M2_E16_MASK,
  PseudoVFWMACCBF16_VFPR16_M4_E16,
  PseudoVFWMACCBF16_VFPR16_M4_E16_MASK,
  PseudoVFWMACCBF16_VFPR16_MF2_E16,
  PseudoVFWMACCBF16_VFPR16_MF2_E16_MASK,
  PseudoVFWMACCBF16_VFPR16_MF4_E16,
  PseudoVFWMACCBF16_VFPR16_MF4_E16_MASK,
  PseudoVFWMACCBF16_VV_M1_E16,
  PseudoVFWMACCBF16_VV_M1_E16_MASK,
  PseudoVFWMACCBF16_VV_M1_E32,
  PseudoVFWMACCBF16_VV_M1_E32_MASK,
  PseudoVFWMACCBF16_VV_M2_E16,
  PseudoVFWMACCBF16_VV_M2_E16_MASK,
  PseudoVFWMACCBF16_VV_M2_E32,
  PseudoVFWMACCBF16_VV_M2_E32_MASK,
  PseudoVFWMACCBF16_VV_M4_E16,
  PseudoVFWMACCBF16_VV_M4_E16_MASK,
  PseudoVFWMACCBF16_VV_M4_E32,
  PseudoVFWMACCBF16_VV_M4_E32_MASK,
  PseudoVFWMACCBF16_VV_MF2_E16,
  PseudoVFWMACCBF16_VV_MF2_E16_MASK,
  PseudoVFWMACCBF16_VV_MF2_E32,
  PseudoVFWMACCBF16_VV_MF2_E32_MASK,
  PseudoVFWMACCBF16_VV_MF4_E16,
  PseudoVFWMACCBF16_VV_MF4_E16_MASK,
  PseudoVFWMACC_VFPR16_M1_E16,
  PseudoVFWMACC_VFPR16_M1_E16_MASK,
  PseudoVFWMACC_VFPR16_M2_E16,
  PseudoVFWMACC_VFPR16_M2_E16_MASK,
  PseudoVFWMACC_VFPR16_M4_E16,
  PseudoVFWMACC_VFPR16_M4_E16_MASK,
  PseudoVFWMACC_VFPR16_MF2_E16,
  PseudoVFWMACC_VFPR16_MF2_E16_MASK,
  PseudoVFWMACC_VFPR16_MF4_E16,
  PseudoVFWMACC_VFPR16_MF4_E16_MASK,
  PseudoVFWMACC_VFPR32_M1_E32,
  PseudoVFWMACC_VFPR32_M1_E32_MASK,
  PseudoVFWMACC_VFPR32_M2_E32,
  PseudoVFWMACC_VFPR32_M2_E32_MASK,
  PseudoVFWMACC_VFPR32_M4_E32,
  PseudoVFWMACC_VFPR32_M4_E32_MASK,
  PseudoVFWMACC_VFPR32_MF2_E32,
  PseudoVFWMACC_VFPR32_MF2_E32_MASK,
  PseudoVFWMACC_VV_M1_E16,
  PseudoVFWMACC_VV_M1_E16_MASK,
  PseudoVFWMACC_VV_M1_E32,
  PseudoVFWMACC_VV_M1_E32_MASK,
  PseudoVFWMACC_VV_M2_E16,
  PseudoVFWMACC_VV_M2_E16_MASK,
  PseudoVFWMACC_VV_M2_E32,
  PseudoVFWMACC_VV_M2_E32_MASK,
  PseudoVFWMACC_VV_M4_E16,
  PseudoVFWMACC_VV_M4_E16_MASK,
  PseudoVFWMACC_VV_M4_E32,
  PseudoVFWMACC_VV_M4_E32_MASK,
  PseudoVFWMACC_VV_MF2_E16,
  PseudoVFWMACC_VV_MF2_E16_MASK,
  PseudoVFWMACC_VV_MF2_E32,
  PseudoVFWMACC_VV_MF2_E32_MASK,
  PseudoVFWMACC_VV_MF4_E16,
  PseudoVFWMACC_VV_MF4_E16_MASK,
  PseudoVFWMSAC_VFPR16_M1_E16,
  PseudoVFWMSAC_VFPR16_M1_E16_MASK,
  PseudoVFWMSAC_VFPR16_M2_E16,
  PseudoVFWMSAC_VFPR16_M2_E16_MASK,
  PseudoVFWMSAC_VFPR16_M4_E16,
  PseudoVFWMSAC_VFPR16_M4_E16_MASK,
  PseudoVFWMSAC_VFPR16_MF2_E16,
  PseudoVFWMSAC_VFPR16_MF2_E16_MASK,
  PseudoVFWMSAC_VFPR16_MF4_E16,
  PseudoVFWMSAC_VFPR16_MF4_E16_MASK,
  PseudoVFWMSAC_VFPR32_M1_E32,
  PseudoVFWMSAC_VFPR32_M1_E32_MASK,
  PseudoVFWMSAC_VFPR32_M2_E32,
  PseudoVFWMSAC_VFPR32_M2_E32_MASK,
  PseudoVFWMSAC_VFPR32_M4_E32,
  PseudoVFWMSAC_VFPR32_M4_E32_MASK,
  PseudoVFWMSAC_VFPR32_MF2_E32,
  PseudoVFWMSAC_VFPR32_MF2_E32_MASK,
  PseudoVFWMSAC_VV_M1_E16,
  PseudoVFWMSAC_VV_M1_E16_MASK,
  PseudoVFWMSAC_VV_M1_E32,
  PseudoVFWMSAC_VV_M1_E32_MASK,
  PseudoVFWMSAC_VV_M2_E16,
  PseudoVFWMSAC_VV_M2_E16_MASK,
  PseudoVFWMSAC_VV_M2_E32,
  PseudoVFWMSAC_VV_M2_E32_MASK,
  PseudoVFWMSAC_VV_M4_E16,
  PseudoVFWMSAC_VV_M4_E16_MASK,
  PseudoVFWMSAC_VV_M4_E32,
  PseudoVFWMSAC_VV_M4_E32_MASK,
  PseudoVFWMSAC_VV_MF2_E16,
  PseudoVFWMSAC_VV_MF2_E16_MASK,
  PseudoVFWMSAC_VV_MF2_E32,
  PseudoVFWMSAC_VV_MF2_E32_MASK,
  PseudoVFWMSAC_VV_MF4_E16,
  PseudoVFWMSAC_VV_MF4_E16_MASK,
  PseudoVFWMUL_VFPR16_M1_E16,
  PseudoVFWMUL_VFPR16_M1_E16_MASK,
  PseudoVFWMUL_VFPR16_M2_E16,
  PseudoVFWMUL_VFPR16_M2_E16_MASK,
  PseudoVFWMUL_VFPR16_M4_E16,
  PseudoVFWMUL_VFPR16_M4_E16_MASK,
  PseudoVFWMUL_VFPR16_MF2_E16,
  PseudoVFWMUL_VFPR16_MF2_E16_MASK,
  PseudoVFWMUL_VFPR16_MF4_E16,
  PseudoVFWMUL_VFPR16_MF4_E16_MASK,
  PseudoVFWMUL_VFPR32_M1_E32,
  PseudoVFWMUL_VFPR32_M1_E32_MASK,
  PseudoVFWMUL_VFPR32_M2_E32,
  PseudoVFWMUL_VFPR32_M2_E32_MASK,
  PseudoVFWMUL_VFPR32_M4_E32,
  PseudoVFWMUL_VFPR32_M4_E32_MASK,
  PseudoVFWMUL_VFPR32_MF2_E32,
  PseudoVFWMUL_VFPR32_MF2_E32_MASK,
  PseudoVFWMUL_VV_M1_E16,
  PseudoVFWMUL_VV_M1_E16_MASK,
  PseudoVFWMUL_VV_M1_E32,
  PseudoVFWMUL_VV_M1_E32_MASK,
  PseudoVFWMUL_VV_M2_E16,
  PseudoVFWMUL_VV_M2_E16_MASK,
  PseudoVFWMUL_VV_M2_E32,
  PseudoVFWMUL_VV_M2_E32_MASK,
  PseudoVFWMUL_VV_M4_E16,
  PseudoVFWMUL_VV_M4_E16_MASK,
  PseudoVFWMUL_VV_M4_E32,
  PseudoVFWMUL_VV_M4_E32_MASK,
  PseudoVFWMUL_VV_MF2_E16,
  PseudoVFWMUL_VV_MF2_E16_MASK,
  PseudoVFWMUL_VV_MF2_E32,
  PseudoVFWMUL_VV_MF2_E32_MASK,
  PseudoVFWMUL_VV_MF4_E16,
  PseudoVFWMUL_VV_MF4_E16_MASK,
  PseudoVFWNMACC_VFPR16_M1_E16,
  PseudoVFWNMACC_VFPR16_M1_E16_MASK,
  PseudoVFWNMACC_VFPR16_M2_E16,
  PseudoVFWNMACC_VFPR16_M2_E16_MASK,
  PseudoVFWNMACC_VFPR16_M4_E16,
  PseudoVFWNMACC_VFPR16_M4_E16_MASK,
  PseudoVFWNMACC_VFPR16_MF2_E16,
  PseudoVFWNMACC_VFPR16_MF2_E16_MASK,
  PseudoVFWNMACC_VFPR16_MF4_E16,
  PseudoVFWNMACC_VFPR16_MF4_E16_MASK,
  PseudoVFWNMACC_VFPR32_M1_E32,
  PseudoVFWNMACC_VFPR32_M1_E32_MASK,
  PseudoVFWNMACC_VFPR32_M2_E32,
  PseudoVFWNMACC_VFPR32_M2_E32_MASK,
  PseudoVFWNMACC_VFPR32_M4_E32,
  PseudoVFWNMACC_VFPR32_M4_E32_MASK,
  PseudoVFWNMACC_VFPR32_MF2_E32,
  PseudoVFWNMACC_VFPR32_MF2_E32_MASK,
  PseudoVFWNMACC_VV_M1_E16,
  PseudoVFWNMACC_VV_M1_E16_MASK,
  PseudoVFWNMACC_VV_M1_E32,
  PseudoVFWNMACC_VV_M1_E32_MASK,
  PseudoVFWNMACC_VV_M2_E16,
  PseudoVFWNMACC_VV_M2_E16_MASK,
  PseudoVFWNMACC_VV_M2_E32,
  PseudoVFWNMACC_VV_M2_E32_MASK,
  PseudoVFWNMACC_VV_M4_E16,
  PseudoVFWNMACC_VV_M4_E16_MASK,
  PseudoVFWNMACC_VV_M4_E32,
  PseudoVFWNMACC_VV_M4_E32_MASK,
  PseudoVFWNMACC_VV_MF2_E16,
  PseudoVFWNMACC_VV_MF2_E16_MASK,
  PseudoVFWNMACC_VV_MF2_E32,
  PseudoVFWNMACC_VV_MF2_E32_MASK,
  PseudoVFWNMACC_VV_MF4_E16,
  PseudoVFWNMACC_VV_MF4_E16_MASK,
  PseudoVFWNMSAC_VFPR16_M1_E16,
  PseudoVFWNMSAC_VFPR16_M1_E16_MASK,
  PseudoVFWNMSAC_VFPR16_M2_E16,
  PseudoVFWNMSAC_VFPR16_M2_E16_MASK,
  PseudoVFWNMSAC_VFPR16_M4_E16,
  PseudoVFWNMSAC_VFPR16_M4_E16_MASK,
  PseudoVFWNMSAC_VFPR16_MF2_E16,
  PseudoVFWNMSAC_VFPR16_MF2_E16_MASK,
  PseudoVFWNMSAC_VFPR16_MF4_E16,
  PseudoVFWNMSAC_VFPR16_MF4_E16_MASK,
  PseudoVFWNMSAC_VFPR32_M1_E32,
  PseudoVFWNMSAC_VFPR32_M1_E32_MASK,
  PseudoVFWNMSAC_VFPR32_M2_E32,
  PseudoVFWNMSAC_VFPR32_M2_E32_MASK,
  PseudoVFWNMSAC_VFPR32_M4_E32,
  PseudoVFWNMSAC_VFPR32_M4_E32_MASK,
  PseudoVFWNMSAC_VFPR32_MF2_E32,
  PseudoVFWNMSAC_VFPR32_MF2_E32_MASK,
  PseudoVFWNMSAC_VV_M1_E16,
  PseudoVFWNMSAC_VV_M1_E16_MASK,
  PseudoVFWNMSAC_VV_M1_E32,
  PseudoVFWNMSAC_VV_M1_E32_MASK,
  PseudoVFWNMSAC_VV_M2_E16,
  PseudoVFWNMSAC_VV_M2_E16_MASK,
  PseudoVFWNMSAC_VV_M2_E32,
  PseudoVFWNMSAC_VV_M2_E32_MASK,
  PseudoVFWNMSAC_VV_M4_E16,
  PseudoVFWNMSAC_VV_M4_E16_MASK,
  PseudoVFWNMSAC_VV_M4_E32,
  PseudoVFWNMSAC_VV_M4_E32_MASK,
  PseudoVFWNMSAC_VV_MF2_E16,
  PseudoVFWNMSAC_VV_MF2_E16_MASK,
  PseudoVFWNMSAC_VV_MF2_E32,
  PseudoVFWNMSAC_VV_MF2_E32_MASK,
  PseudoVFWNMSAC_VV_MF4_E16,
  PseudoVFWNMSAC_VV_MF4_E16_MASK,
  PseudoVFWREDOSUM_VS_M1_E16,
  PseudoVFWREDOSUM_VS_M1_E16_MASK,
  PseudoVFWREDOSUM_VS_M1_E32,
  PseudoVFWREDOSUM_VS_M1_E32_MASK,
  PseudoVFWREDOSUM_VS_M2_E16,
  PseudoVFWREDOSUM_VS_M2_E16_MASK,
  PseudoVFWREDOSUM_VS_M2_E32,
  PseudoVFWREDOSUM_VS_M2_E32_MASK,
  PseudoVFWREDOSUM_VS_M4_E16,
  PseudoVFWREDOSUM_VS_M4_E16_MASK,
  PseudoVFWREDOSUM_VS_M4_E32,
  PseudoVFWREDOSUM_VS_M4_E32_MASK,
  PseudoVFWREDOSUM_VS_M8_E16,
  PseudoVFWREDOSUM_VS_M8_E16_MASK,
  PseudoVFWREDOSUM_VS_M8_E32,
  PseudoVFWREDOSUM_VS_M8_E32_MASK,
  PseudoVFWREDOSUM_VS_MF2_E16,
  PseudoVFWREDOSUM_VS_MF2_E16_MASK,
  PseudoVFWREDOSUM_VS_MF2_E32,
  PseudoVFWREDOSUM_VS_MF2_E32_MASK,
  PseudoVFWREDOSUM_VS_MF4_E16,
  PseudoVFWREDOSUM_VS_MF4_E16_MASK,
  PseudoVFWREDUSUM_VS_M1_E16,
  PseudoVFWREDUSUM_VS_M1_E16_MASK,
  PseudoVFWREDUSUM_VS_M1_E32,
  PseudoVFWREDUSUM_VS_M1_E32_MASK,
  PseudoVFWREDUSUM_VS_M2_E16,
  PseudoVFWREDUSUM_VS_M2_E16_MASK,
  PseudoVFWREDUSUM_VS_M2_E32,
  PseudoVFWREDUSUM_VS_M2_E32_MASK,
  PseudoVFWREDUSUM_VS_M4_E16,
  PseudoVFWREDUSUM_VS_M4_E16_MASK,
  PseudoVFWREDUSUM_VS_M4_E32,
  PseudoVFWREDUSUM_VS_M4_E32_MASK,
  PseudoVFWREDUSUM_VS_M8_E16,
  PseudoVFWREDUSUM_VS_M8_E16_MASK,
  PseudoVFWREDUSUM_VS_M8_E32,
  PseudoVFWREDUSUM_VS_M8_E32_MASK,
  PseudoVFWREDUSUM_VS_MF2_E16,
  PseudoVFWREDUSUM_VS_MF2_E16_MASK,
  PseudoVFWREDUSUM_VS_MF2_E32,
  PseudoVFWREDUSUM_VS_MF2_E32_MASK,
  PseudoVFWREDUSUM_VS_MF4_E16,
  PseudoVFWREDUSUM_VS_MF4_E16_MASK,
  PseudoVFWSUB_VFPR16_M1_E16,
  PseudoVFWSUB_VFPR16_M1_E16_MASK,
  PseudoVFWSUB_VFPR16_M2_E16,
  PseudoVFWSUB_VFPR16_M2_E16_MASK,
  PseudoVFWSUB_VFPR16_M4_E16,
  PseudoVFWSUB_VFPR16_M4_E16_MASK,
  PseudoVFWSUB_VFPR16_MF2_E16,
  PseudoVFWSUB_VFPR16_MF2_E16_MASK,
  PseudoVFWSUB_VFPR16_MF4_E16,
  PseudoVFWSUB_VFPR16_MF4_E16_MASK,
  PseudoVFWSUB_VFPR32_M1_E32,
  PseudoVFWSUB_VFPR32_M1_E32_MASK,
  PseudoVFWSUB_VFPR32_M2_E32,
  PseudoVFWSUB_VFPR32_M2_E32_MASK,
  PseudoVFWSUB_VFPR32_M4_E32,
  PseudoVFWSUB_VFPR32_M4_E32_MASK,
  PseudoVFWSUB_VFPR32_MF2_E32,
  PseudoVFWSUB_VFPR32_MF2_E32_MASK,
  PseudoVFWSUB_VV_M1_E16,
  PseudoVFWSUB_VV_M1_E16_MASK,
  PseudoVFWSUB_VV_M1_E32,
  PseudoVFWSUB_VV_M1_E32_MASK,
  PseudoVFWSUB_VV_M2_E16,
  PseudoVFWSUB_VV_M2_E16_MASK,
  PseudoVFWSUB_VV_M2_E32,
  PseudoVFWSUB_VV_M2_E32_MASK,
  PseudoVFWSUB_VV_M4_E16,
  PseudoVFWSUB_VV_M4_E16_MASK,
  PseudoVFWSUB_VV_M4_E32,
  PseudoVFWSUB_VV_M4_E32_MASK,
  PseudoVFWSUB_VV_MF2_E16,
  PseudoVFWSUB_VV_MF2_E16_MASK,
  PseudoVFWSUB_VV_MF2_E32,
  PseudoVFWSUB_VV_MF2_E32_MASK,
  PseudoVFWSUB_VV_MF4_E16,
  PseudoVFWSUB_VV_MF4_E16_MASK,
  PseudoVFWSUB_WFPR16_M1_E16,
  PseudoVFWSUB_WFPR16_M1_E16_MASK,
  PseudoVFWSUB_WFPR16_M2_E16,
  PseudoVFWSUB_WFPR16_M2_E16_MASK,
  PseudoVFWSUB_WFPR16_M4_E16,
  PseudoVFWSUB_WFPR16_M4_E16_MASK,
  PseudoVFWSUB_WFPR16_MF2_E16,
  PseudoVFWSUB_WFPR16_MF2_E16_MASK,
  PseudoVFWSUB_WFPR16_MF4_E16,
  PseudoVFWSUB_WFPR16_MF4_E16_MASK,
  PseudoVFWSUB_WFPR32_M1_E32,
  PseudoVFWSUB_WFPR32_M1_E32_MASK,
  PseudoVFWSUB_WFPR32_M2_E32,
  PseudoVFWSUB_WFPR32_M2_E32_MASK,
  PseudoVFWSUB_WFPR32_M4_E32,
  PseudoVFWSUB_WFPR32_M4_E32_MASK,
  PseudoVFWSUB_WFPR32_MF2_E32,
  PseudoVFWSUB_WFPR32_MF2_E32_MASK,
  PseudoVFWSUB_WV_M1_E16,
  PseudoVFWSUB_WV_M1_E16_MASK,
  PseudoVFWSUB_WV_M1_E16_MASK_TIED,
  PseudoVFWSUB_WV_M1_E16_TIED,
  PseudoVFWSUB_WV_M1_E32,
  PseudoVFWSUB_WV_M1_E32_MASK,
  PseudoVFWSUB_WV_M1_E32_MASK_TIED,
  PseudoVFWSUB_WV_M1_E32_TIED,
  PseudoVFWSUB_WV_M2_E16,
  PseudoVFWSUB_WV_M2_E16_MASK,
  PseudoVFWSUB_WV_M2_E16_MASK_TIED,
  PseudoVFWSUB_WV_M2_E16_TIED,
  PseudoVFWSUB_WV_M2_E32,
  PseudoVFWSUB_WV_M2_E32_MASK,
  PseudoVFWSUB_WV_M2_E32_MASK_TIED,
  PseudoVFWSUB_WV_M2_E32_TIED,
  PseudoVFWSUB_WV_M4_E16,
  PseudoVFWSUB_WV_M4_E16_MASK,
  PseudoVFWSUB_WV_M4_E16_MASK_TIED,
  PseudoVFWSUB_WV_M4_E16_TIED,
  PseudoVFWSUB_WV_M4_E32,
  PseudoVFWSUB_WV_M4_E32_MASK,
  PseudoVFWSUB_WV_M4_E32_MASK_TIED,
  PseudoVFWSUB_WV_M4_E32_TIED,
  PseudoVFWSUB_WV_MF2_E16,
  PseudoVFWSUB_WV_MF2_E16_MASK,
  PseudoVFWSUB_WV_MF2_E16_MASK_TIED,
  PseudoVFWSUB_WV_MF2_E16_TIED,
  PseudoVFWSUB_WV_MF2_E32,
  PseudoVFWSUB_WV_MF2_E32_MASK,
  PseudoVFWSUB_WV_MF2_E32_MASK_TIED,
  PseudoVFWSUB_WV_MF2_E32_TIED,
  PseudoVFWSUB_WV_MF4_E16,
  PseudoVFWSUB_WV_MF4_E16_MASK,
  PseudoVFWSUB_WV_MF4_E16_MASK_TIED,
  PseudoVFWSUB_WV_MF4_E16_TIED,
  PseudoVGHSH_VV_M1,
  PseudoVGHSH_VV_M2,
  PseudoVGHSH_VV_M4,
  PseudoVGHSH_VV_M8,
  PseudoVGHSH_VV_MF2,
  PseudoVGMUL_VV_M1,
  PseudoVGMUL_VV_M2,
  PseudoVGMUL_VV_M4,
  PseudoVGMUL_VV_M8,
  PseudoVGMUL_VV_MF2,
  PseudoVID_V_M1,
  PseudoVID_V_M1_MASK,
  PseudoVID_V_M2,
  PseudoVID_V_M2_MASK,
  PseudoVID_V_M4,
  PseudoVID_V_M4_MASK,
  PseudoVID_V_M8,
  PseudoVID_V_M8_MASK,
  PseudoVID_V_MF2,
  PseudoVID_V_MF2_MASK,
  PseudoVID_V_MF4,
  PseudoVID_V_MF4_MASK,
  PseudoVID_V_MF8,
  PseudoVID_V_MF8_MASK,
  PseudoVIOTA_M_M1,
  PseudoVIOTA_M_M1_MASK,
  PseudoVIOTA_M_M2,
  PseudoVIOTA_M_M2_MASK,
  PseudoVIOTA_M_M4,
  PseudoVIOTA_M_M4_MASK,
  PseudoVIOTA_M_M8,
  PseudoVIOTA_M_M8_MASK,
  PseudoVIOTA_M_MF2,
  PseudoVIOTA_M_MF2_MASK,
  PseudoVIOTA_M_MF4,
  PseudoVIOTA_M_MF4_MASK,
  PseudoVIOTA_M_MF8,
  PseudoVIOTA_M_MF8_MASK,
  PseudoVLE16FF_V_M1,
  PseudoVLE16FF_V_M1_MASK,
  PseudoVLE16FF_V_M2,
  PseudoVLE16FF_V_M2_MASK,
  PseudoVLE16FF_V_M4,
  PseudoVLE16FF_V_M4_MASK,
  PseudoVLE16FF_V_M8,
  PseudoVLE16FF_V_M8_MASK,
  PseudoVLE16FF_V_MF2,
  PseudoVLE16FF_V_MF2_MASK,
  PseudoVLE16FF_V_MF4,
  PseudoVLE16FF_V_MF4_MASK,
  PseudoVLE16_V_M1,
  PseudoVLE16_V_M1_MASK,
  PseudoVLE16_V_M2,
  PseudoVLE16_V_M2_MASK,
  PseudoVLE16_V_M4,
  PseudoVLE16_V_M4_MASK,
  PseudoVLE16_V_M8,
  PseudoVLE16_V_M8_MASK,
  PseudoVLE16_V_MF2,
  PseudoVLE16_V_MF2_MASK,
  PseudoVLE16_V_MF4,
  PseudoVLE16_V_MF4_MASK,
  PseudoVLE32FF_V_M1,
  PseudoVLE32FF_V_M1_MASK,
  PseudoVLE32FF_V_M2,
  PseudoVLE32FF_V_M2_MASK,
  PseudoVLE32FF_V_M4,
  PseudoVLE32FF_V_M4_MASK,
  PseudoVLE32FF_V_M8,
  PseudoVLE32FF_V_M8_MASK,
  PseudoVLE32FF_V_MF2,
  PseudoVLE32FF_V_MF2_MASK,
  PseudoVLE32_V_M1,
  PseudoVLE32_V_M1_MASK,
  PseudoVLE32_V_M2,
  PseudoVLE32_V_M2_MASK,
  PseudoVLE32_V_M4,
  PseudoVLE32_V_M4_MASK,
  PseudoVLE32_V_M8,
  PseudoVLE32_V_M8_MASK,
  PseudoVLE32_V_MF2,
  PseudoVLE32_V_MF2_MASK,
  PseudoVLE64FF_V_M1,
  PseudoVLE64FF_V_M1_MASK,
  PseudoVLE64FF_V_M2,
  PseudoVLE64FF_V_M2_MASK,
  PseudoVLE64FF_V_M4,
  PseudoVLE64FF_V_M4_MASK,
  PseudoVLE64FF_V_M8,
  PseudoVLE64FF_V_M8_MASK,
  PseudoVLE64_V_M1,
  PseudoVLE64_V_M1_MASK,
  PseudoVLE64_V_M2,
  PseudoVLE64_V_M2_MASK,
  PseudoVLE64_V_M4,
  PseudoVLE64_V_M4_MASK,
  PseudoVLE64_V_M8,
  PseudoVLE64_V_M8_MASK,
  PseudoVLE8FF_V_M1,
  PseudoVLE8FF_V_M1_MASK,
  PseudoVLE8FF_V_M2,
  PseudoVLE8FF_V_M2_MASK,
  PseudoVLE8FF_V_M4,
  PseudoVLE8FF_V_M4_MASK,
  PseudoVLE8FF_V_M8,
  PseudoVLE8FF_V_M8_MASK,
  PseudoVLE8FF_V_MF2,
  PseudoVLE8FF_V_MF2_MASK,
  PseudoVLE8FF_V_MF4,
  PseudoVLE8FF_V_MF4_MASK,
  PseudoVLE8FF_V_MF8,
  PseudoVLE8FF_V_MF8_MASK,
  PseudoVLE8_V_M1,
  PseudoVLE8_V_M1_MASK,
  PseudoVLE8_V_M2,
  PseudoVLE8_V_M2_MASK,
  PseudoVLE8_V_M4,
  PseudoVLE8_V_M4_MASK,
  PseudoVLE8_V_M8,
  PseudoVLE8_V_M8_MASK,
  PseudoVLE8_V_MF2,
  PseudoVLE8_V_MF2_MASK,
  PseudoVLE8_V_MF4,
  PseudoVLE8_V_MF4_MASK,
  PseudoVLE8_V_MF8,
  PseudoVLE8_V_MF8_MASK,
  PseudoVLM_V_B1,
  PseudoVLM_V_B16,
  PseudoVLM_V_B2,
  PseudoVLM_V_B32,
  PseudoVLM_V_B4,
  PseudoVLM_V_B64,
  PseudoVLM_V_B8,
  PseudoVLOXEI16_V_M1_M1,
  PseudoVLOXEI16_V_M1_M1_MASK,
  PseudoVLOXEI16_V_M1_M2,
  PseudoVLOXEI16_V_M1_M2_MASK,
  PseudoVLOXEI16_V_M1_M4,
  PseudoVLOXEI16_V_M1_M4_MASK,
  PseudoVLOXEI16_V_M1_MF2,
  PseudoVLOXEI16_V_M1_MF2_MASK,
  PseudoVLOXEI16_V_M2_M1,
  PseudoVLOXEI16_V_M2_M1_MASK,
  PseudoVLOXEI16_V_M2_M2,
  PseudoVLOXEI16_V_M2_M2_MASK,
  PseudoVLOXEI16_V_M2_M4,
  PseudoVLOXEI16_V_M2_M4_MASK,
  PseudoVLOXEI16_V_M2_M8,
  PseudoVLOXEI16_V_M2_M8_MASK,
  PseudoVLOXEI16_V_M4_M2,
  PseudoVLOXEI16_V_M4_M2_MASK,
  PseudoVLOXEI16_V_M4_M4,
  PseudoVLOXEI16_V_M4_M4_MASK,
  PseudoVLOXEI16_V_M4_M8,
  PseudoVLOXEI16_V_M4_M8_MASK,
  PseudoVLOXEI16_V_M8_M4,
  PseudoVLOXEI16_V_M8_M4_MASK,
  PseudoVLOXEI16_V_M8_M8,
  PseudoVLOXEI16_V_M8_M8_MASK,
  PseudoVLOXEI16_V_MF2_M1,
  PseudoVLOXEI16_V_MF2_M1_MASK,
  PseudoVLOXEI16_V_MF2_M2,
  PseudoVLOXEI16_V_MF2_M2_MASK,
  PseudoVLOXEI16_V_MF2_MF2,
  PseudoVLOXEI16_V_MF2_MF2_MASK,
  PseudoVLOXEI16_V_MF2_MF4,
  PseudoVLOXEI16_V_MF2_MF4_MASK,
  PseudoVLOXEI16_V_MF4_M1,
  PseudoVLOXEI16_V_MF4_M1_MASK,
  PseudoVLOXEI16_V_MF4_MF2,
  PseudoVLOXEI16_V_MF4_MF2_MASK,
  PseudoVLOXEI16_V_MF4_MF4,
  PseudoVLOXEI16_V_MF4_MF4_MASK,
  PseudoVLOXEI16_V_MF4_MF8,
  PseudoVLOXEI16_V_MF4_MF8_MASK,
  PseudoVLOXEI32_V_M1_M1,
  PseudoVLOXEI32_V_M1_M1_MASK,
  PseudoVLOXEI32_V_M1_M2,
  PseudoVLOXEI32_V_M1_M2_MASK,
  PseudoVLOXEI32_V_M1_MF2,
  PseudoVLOXEI32_V_M1_MF2_MASK,
  PseudoVLOXEI32_V_M1_MF4,
  PseudoVLOXEI32_V_M1_MF4_MASK,
  PseudoVLOXEI32_V_M2_M1,
  PseudoVLOXEI32_V_M2_M1_MASK,
  PseudoVLOXEI32_V_M2_M2,
  PseudoVLOXEI32_V_M2_M2_MASK,
  PseudoVLOXEI32_V_M2_M4,
  PseudoVLOXEI32_V_M2_M4_MASK,
  PseudoVLOXEI32_V_M2_MF2,
  PseudoVLOXEI32_V_M2_MF2_MASK,
  PseudoVLOXEI32_V_M4_M1,
  PseudoVLOXEI32_V_M4_M1_MASK,
  PseudoVLOXEI32_V_M4_M2,
  PseudoVLOXEI32_V_M4_M2_MASK,
  PseudoVLOXEI32_V_M4_M4,
  PseudoVLOXEI32_V_M4_M4_MASK,
  PseudoVLOXEI32_V_M4_M8,
  PseudoVLOXEI32_V_M4_M8_MASK,
  PseudoVLOXEI32_V_M8_M2,
  PseudoVLOXEI32_V_M8_M2_MASK,
  PseudoVLOXEI32_V_M8_M4,
  PseudoVLOXEI32_V_M8_M4_MASK,
  PseudoVLOXEI32_V_M8_M8,
  PseudoVLOXEI32_V_M8_M8_MASK,
  PseudoVLOXEI32_V_MF2_M1,
  PseudoVLOXEI32_V_MF2_M1_MASK,
  PseudoVLOXEI32_V_MF2_MF2,
  PseudoVLOXEI32_V_MF2_MF2_MASK,
  PseudoVLOXEI32_V_MF2_MF4,
  PseudoVLOXEI32_V_MF2_MF4_MASK,
  PseudoVLOXEI32_V_MF2_MF8,
  PseudoVLOXEI32_V_MF2_MF8_MASK,
  PseudoVLOXEI64_V_M1_M1,
  PseudoVLOXEI64_V_M1_M1_MASK,
  PseudoVLOXEI64_V_M1_MF2,
  PseudoVLOXEI64_V_M1_MF2_MASK,
  PseudoVLOXEI64_V_M1_MF4,
  PseudoVLOXEI64_V_M1_MF4_MASK,
  PseudoVLOXEI64_V_M1_MF8,
  PseudoVLOXEI64_V_M1_MF8_MASK,
  PseudoVLOXEI64_V_M2_M1,
  PseudoVLOXEI64_V_M2_M1_MASK,
  PseudoVLOXEI64_V_M2_M2,
  PseudoVLOXEI64_V_M2_M2_MASK,
  PseudoVLOXEI64_V_M2_MF2,
  PseudoVLOXEI64_V_M2_MF2_MASK,
  PseudoVLOXEI64_V_M2_MF4,
  PseudoVLOXEI64_V_M2_MF4_MASK,
  PseudoVLOXEI64_V_M4_M1,
  PseudoVLOXEI64_V_M4_M1_MASK,
  PseudoVLOXEI64_V_M4_M2,
  PseudoVLOXEI64_V_M4_M2_MASK,
  PseudoVLOXEI64_V_M4_M4,
  PseudoVLOXEI64_V_M4_M4_MASK,
  PseudoVLOXEI64_V_M4_MF2,
  PseudoVLOXEI64_V_M4_MF2_MASK,
  PseudoVLOXEI64_V_M8_M1,
  PseudoVLOXEI64_V_M8_M1_MASK,
  PseudoVLOXEI64_V_M8_M2,
  PseudoVLOXEI64_V_M8_M2_MASK,
  PseudoVLOXEI64_V_M8_M4,
  PseudoVLOXEI64_V_M8_M4_MASK,
  PseudoVLOXEI64_V_M8_M8,
  PseudoVLOXEI64_V_M8_M8_MASK,
  PseudoVLOXEI8_V_M1_M1,
  PseudoVLOXEI8_V_M1_M1_MASK,
  PseudoVLOXEI8_V_M1_M2,
  PseudoVLOXEI8_V_M1_M2_MASK,
  PseudoVLOXEI8_V_M1_M4,
  PseudoVLOXEI8_V_M1_M4_MASK,
  PseudoVLOXEI8_V_M1_M8,
  PseudoVLOXEI8_V_M1_M8_MASK,
  PseudoVLOXEI8_V_M2_M2,
  PseudoVLOXEI8_V_M2_M2_MASK,
  PseudoVLOXEI8_V_M2_M4,
  PseudoVLOXEI8_V_M2_M4_MASK,
  PseudoVLOXEI8_V_M2_M8,
  PseudoVLOXEI8_V_M2_M8_MASK,
  PseudoVLOXEI8_V_M4_M4,
  PseudoVLOXEI8_V_M4_M4_MASK,
  PseudoVLOXEI8_V_M4_M8,
  PseudoVLOXEI8_V_M4_M8_MASK,
  PseudoVLOXEI8_V_M8_M8,
  PseudoVLOXEI8_V_M8_M8_MASK,
  PseudoVLOXEI8_V_MF2_M1,
  PseudoVLOXEI8_V_MF2_M1_MASK,
  PseudoVLOXEI8_V_MF2_M2,
  PseudoVLOXEI8_V_MF2_M2_MASK,
  PseudoVLOXEI8_V_MF2_M4,
  PseudoVLOXEI8_V_MF2_M4_MASK,
  PseudoVLOXEI8_V_MF2_MF2,
  PseudoVLOXEI8_V_MF2_MF2_MASK,
  PseudoVLOXEI8_V_MF4_M1,
  PseudoVLOXEI8_V_MF4_M1_MASK,
  PseudoVLOXEI8_V_MF4_M2,
  PseudoVLOXEI8_V_MF4_M2_MASK,
  PseudoVLOXEI8_V_MF4_MF2,
  PseudoVLOXEI8_V_MF4_MF2_MASK,
  PseudoVLOXEI8_V_MF4_MF4,
  PseudoVLOXEI8_V_MF4_MF4_MASK,
  PseudoVLOXEI8_V_MF8_M1,
  PseudoVLOXEI8_V_MF8_M1_MASK,
  PseudoVLOXEI8_V_MF8_MF2,
  PseudoVLOXEI8_V_MF8_MF2_MASK,
  PseudoVLOXEI8_V_MF8_MF4,
  PseudoVLOXEI8_V_MF8_MF4_MASK,
  PseudoVLOXEI8_V_MF8_MF8,
  PseudoVLOXEI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG2EI16_V_M1_M1,
  PseudoVLOXSEG2EI16_V_M1_M1_MASK,
  PseudoVLOXSEG2EI16_V_M1_M2,
  PseudoVLOXSEG2EI16_V_M1_M2_MASK,
  PseudoVLOXSEG2EI16_V_M1_M4,
  PseudoVLOXSEG2EI16_V_M1_M4_MASK,
  PseudoVLOXSEG2EI16_V_M1_MF2,
  PseudoVLOXSEG2EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG2EI16_V_M2_M1,
  PseudoVLOXSEG2EI16_V_M2_M1_MASK,
  PseudoVLOXSEG2EI16_V_M2_M2,
  PseudoVLOXSEG2EI16_V_M2_M2_MASK,
  PseudoVLOXSEG2EI16_V_M2_M4,
  PseudoVLOXSEG2EI16_V_M2_M4_MASK,
  PseudoVLOXSEG2EI16_V_M4_M2,
  PseudoVLOXSEG2EI16_V_M4_M2_MASK,
  PseudoVLOXSEG2EI16_V_M4_M4,
  PseudoVLOXSEG2EI16_V_M4_M4_MASK,
  PseudoVLOXSEG2EI16_V_M8_M4,
  PseudoVLOXSEG2EI16_V_M8_M4_MASK,
  PseudoVLOXSEG2EI16_V_MF2_M1,
  PseudoVLOXSEG2EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG2EI16_V_MF2_M2,
  PseudoVLOXSEG2EI16_V_MF2_M2_MASK,
  PseudoVLOXSEG2EI16_V_MF2_MF2,
  PseudoVLOXSEG2EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG2EI16_V_MF2_MF4,
  PseudoVLOXSEG2EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG2EI16_V_MF4_M1,
  PseudoVLOXSEG2EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG2EI16_V_MF4_MF2,
  PseudoVLOXSEG2EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG2EI16_V_MF4_MF4,
  PseudoVLOXSEG2EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG2EI16_V_MF4_MF8,
  PseudoVLOXSEG2EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG2EI32_V_M1_M1,
  PseudoVLOXSEG2EI32_V_M1_M1_MASK,
  PseudoVLOXSEG2EI32_V_M1_M2,
  PseudoVLOXSEG2EI32_V_M1_M2_MASK,
  PseudoVLOXSEG2EI32_V_M1_MF2,
  PseudoVLOXSEG2EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG2EI32_V_M1_MF4,
  PseudoVLOXSEG2EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG2EI32_V_M2_M1,
  PseudoVLOXSEG2EI32_V_M2_M1_MASK,
  PseudoVLOXSEG2EI32_V_M2_M2,
  PseudoVLOXSEG2EI32_V_M2_M2_MASK,
  PseudoVLOXSEG2EI32_V_M2_M4,
  PseudoVLOXSEG2EI32_V_M2_M4_MASK,
  PseudoVLOXSEG2EI32_V_M2_MF2,
  PseudoVLOXSEG2EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG2EI32_V_M4_M1,
  PseudoVLOXSEG2EI32_V_M4_M1_MASK,
  PseudoVLOXSEG2EI32_V_M4_M2,
  PseudoVLOXSEG2EI32_V_M4_M2_MASK,
  PseudoVLOXSEG2EI32_V_M4_M4,
  PseudoVLOXSEG2EI32_V_M4_M4_MASK,
  PseudoVLOXSEG2EI32_V_M8_M2,
  PseudoVLOXSEG2EI32_V_M8_M2_MASK,
  PseudoVLOXSEG2EI32_V_M8_M4,
  PseudoVLOXSEG2EI32_V_M8_M4_MASK,
  PseudoVLOXSEG2EI32_V_MF2_M1,
  PseudoVLOXSEG2EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG2EI32_V_MF2_MF2,
  PseudoVLOXSEG2EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG2EI32_V_MF2_MF4,
  PseudoVLOXSEG2EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG2EI32_V_MF2_MF8,
  PseudoVLOXSEG2EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG2EI64_V_M1_M1,
  PseudoVLOXSEG2EI64_V_M1_M1_MASK,
  PseudoVLOXSEG2EI64_V_M1_MF2,
  PseudoVLOXSEG2EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG2EI64_V_M1_MF4,
  PseudoVLOXSEG2EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG2EI64_V_M1_MF8,
  PseudoVLOXSEG2EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG2EI64_V_M2_M1,
  PseudoVLOXSEG2EI64_V_M2_M1_MASK,
  PseudoVLOXSEG2EI64_V_M2_M2,
  PseudoVLOXSEG2EI64_V_M2_M2_MASK,
  PseudoVLOXSEG2EI64_V_M2_MF2,
  PseudoVLOXSEG2EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG2EI64_V_M2_MF4,
  PseudoVLOXSEG2EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG2EI64_V_M4_M1,
  PseudoVLOXSEG2EI64_V_M4_M1_MASK,
  PseudoVLOXSEG2EI64_V_M4_M2,
  PseudoVLOXSEG2EI64_V_M4_M2_MASK,
  PseudoVLOXSEG2EI64_V_M4_M4,
  PseudoVLOXSEG2EI64_V_M4_M4_MASK,
  PseudoVLOXSEG2EI64_V_M4_MF2,
  PseudoVLOXSEG2EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG2EI64_V_M8_M1,
  PseudoVLOXSEG2EI64_V_M8_M1_MASK,
  PseudoVLOXSEG2EI64_V_M8_M2,
  PseudoVLOXSEG2EI64_V_M8_M2_MASK,
  PseudoVLOXSEG2EI64_V_M8_M4,
  PseudoVLOXSEG2EI64_V_M8_M4_MASK,
  PseudoVLOXSEG2EI8_V_M1_M1,
  PseudoVLOXSEG2EI8_V_M1_M1_MASK,
  PseudoVLOXSEG2EI8_V_M1_M2,
  PseudoVLOXSEG2EI8_V_M1_M2_MASK,
  PseudoVLOXSEG2EI8_V_M1_M4,
  PseudoVLOXSEG2EI8_V_M1_M4_MASK,
  PseudoVLOXSEG2EI8_V_M2_M2,
  PseudoVLOXSEG2EI8_V_M2_M2_MASK,
  PseudoVLOXSEG2EI8_V_M2_M4,
  PseudoVLOXSEG2EI8_V_M2_M4_MASK,
  PseudoVLOXSEG2EI8_V_M4_M4,
  PseudoVLOXSEG2EI8_V_M4_M4_MASK,
  PseudoVLOXSEG2EI8_V_MF2_M1,
  PseudoVLOXSEG2EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG2EI8_V_MF2_M2,
  PseudoVLOXSEG2EI8_V_MF2_M2_MASK,
  PseudoVLOXSEG2EI8_V_MF2_M4,
  PseudoVLOXSEG2EI8_V_MF2_M4_MASK,
  PseudoVLOXSEG2EI8_V_MF2_MF2,
  PseudoVLOXSEG2EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG2EI8_V_MF4_M1,
  PseudoVLOXSEG2EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG2EI8_V_MF4_M2,
  PseudoVLOXSEG2EI8_V_MF4_M2_MASK,
  PseudoVLOXSEG2EI8_V_MF4_MF2,
  PseudoVLOXSEG2EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG2EI8_V_MF4_MF4,
  PseudoVLOXSEG2EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG2EI8_V_MF8_M1,
  PseudoVLOXSEG2EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG2EI8_V_MF8_MF2,
  PseudoVLOXSEG2EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG2EI8_V_MF8_MF4,
  PseudoVLOXSEG2EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG2EI8_V_MF8_MF8,
  PseudoVLOXSEG2EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG3EI16_V_M1_M1,
  PseudoVLOXSEG3EI16_V_M1_M1_MASK,
  PseudoVLOXSEG3EI16_V_M1_M2,
  PseudoVLOXSEG3EI16_V_M1_M2_MASK,
  PseudoVLOXSEG3EI16_V_M1_MF2,
  PseudoVLOXSEG3EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG3EI16_V_M2_M1,
  PseudoVLOXSEG3EI16_V_M2_M1_MASK,
  PseudoVLOXSEG3EI16_V_M2_M2,
  PseudoVLOXSEG3EI16_V_M2_M2_MASK,
  PseudoVLOXSEG3EI16_V_M4_M2,
  PseudoVLOXSEG3EI16_V_M4_M2_MASK,
  PseudoVLOXSEG3EI16_V_MF2_M1,
  PseudoVLOXSEG3EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG3EI16_V_MF2_M2,
  PseudoVLOXSEG3EI16_V_MF2_M2_MASK,
  PseudoVLOXSEG3EI16_V_MF2_MF2,
  PseudoVLOXSEG3EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG3EI16_V_MF2_MF4,
  PseudoVLOXSEG3EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG3EI16_V_MF4_M1,
  PseudoVLOXSEG3EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG3EI16_V_MF4_MF2,
  PseudoVLOXSEG3EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG3EI16_V_MF4_MF4,
  PseudoVLOXSEG3EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG3EI16_V_MF4_MF8,
  PseudoVLOXSEG3EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG3EI32_V_M1_M1,
  PseudoVLOXSEG3EI32_V_M1_M1_MASK,
  PseudoVLOXSEG3EI32_V_M1_M2,
  PseudoVLOXSEG3EI32_V_M1_M2_MASK,
  PseudoVLOXSEG3EI32_V_M1_MF2,
  PseudoVLOXSEG3EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG3EI32_V_M1_MF4,
  PseudoVLOXSEG3EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG3EI32_V_M2_M1,
  PseudoVLOXSEG3EI32_V_M2_M1_MASK,
  PseudoVLOXSEG3EI32_V_M2_M2,
  PseudoVLOXSEG3EI32_V_M2_M2_MASK,
  PseudoVLOXSEG3EI32_V_M2_MF2,
  PseudoVLOXSEG3EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG3EI32_V_M4_M1,
  PseudoVLOXSEG3EI32_V_M4_M1_MASK,
  PseudoVLOXSEG3EI32_V_M4_M2,
  PseudoVLOXSEG3EI32_V_M4_M2_MASK,
  PseudoVLOXSEG3EI32_V_M8_M2,
  PseudoVLOXSEG3EI32_V_M8_M2_MASK,
  PseudoVLOXSEG3EI32_V_MF2_M1,
  PseudoVLOXSEG3EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG3EI32_V_MF2_MF2,
  PseudoVLOXSEG3EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG3EI32_V_MF2_MF4,
  PseudoVLOXSEG3EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG3EI32_V_MF2_MF8,
  PseudoVLOXSEG3EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG3EI64_V_M1_M1,
  PseudoVLOXSEG3EI64_V_M1_M1_MASK,
  PseudoVLOXSEG3EI64_V_M1_MF2,
  PseudoVLOXSEG3EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG3EI64_V_M1_MF4,
  PseudoVLOXSEG3EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG3EI64_V_M1_MF8,
  PseudoVLOXSEG3EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG3EI64_V_M2_M1,
  PseudoVLOXSEG3EI64_V_M2_M1_MASK,
  PseudoVLOXSEG3EI64_V_M2_M2,
  PseudoVLOXSEG3EI64_V_M2_M2_MASK,
  PseudoVLOXSEG3EI64_V_M2_MF2,
  PseudoVLOXSEG3EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG3EI64_V_M2_MF4,
  PseudoVLOXSEG3EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG3EI64_V_M4_M1,
  PseudoVLOXSEG3EI64_V_M4_M1_MASK,
  PseudoVLOXSEG3EI64_V_M4_M2,
  PseudoVLOXSEG3EI64_V_M4_M2_MASK,
  PseudoVLOXSEG3EI64_V_M4_MF2,
  PseudoVLOXSEG3EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG3EI64_V_M8_M1,
  PseudoVLOXSEG3EI64_V_M8_M1_MASK,
  PseudoVLOXSEG3EI64_V_M8_M2,
  PseudoVLOXSEG3EI64_V_M8_M2_MASK,
  PseudoVLOXSEG3EI8_V_M1_M1,
  PseudoVLOXSEG3EI8_V_M1_M1_MASK,
  PseudoVLOXSEG3EI8_V_M1_M2,
  PseudoVLOXSEG3EI8_V_M1_M2_MASK,
  PseudoVLOXSEG3EI8_V_M2_M2,
  PseudoVLOXSEG3EI8_V_M2_M2_MASK,
  PseudoVLOXSEG3EI8_V_MF2_M1,
  PseudoVLOXSEG3EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG3EI8_V_MF2_M2,
  PseudoVLOXSEG3EI8_V_MF2_M2_MASK,
  PseudoVLOXSEG3EI8_V_MF2_MF2,
  PseudoVLOXSEG3EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG3EI8_V_MF4_M1,
  PseudoVLOXSEG3EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG3EI8_V_MF4_M2,
  PseudoVLOXSEG3EI8_V_MF4_M2_MASK,
  PseudoVLOXSEG3EI8_V_MF4_MF2,
  PseudoVLOXSEG3EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG3EI8_V_MF4_MF4,
  PseudoVLOXSEG3EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG3EI8_V_MF8_M1,
  PseudoVLOXSEG3EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG3EI8_V_MF8_MF2,
  PseudoVLOXSEG3EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG3EI8_V_MF8_MF4,
  PseudoVLOXSEG3EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG3EI8_V_MF8_MF8,
  PseudoVLOXSEG3EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG4EI16_V_M1_M1,
  PseudoVLOXSEG4EI16_V_M1_M1_MASK,
  PseudoVLOXSEG4EI16_V_M1_M2,
  PseudoVLOXSEG4EI16_V_M1_M2_MASK,
  PseudoVLOXSEG4EI16_V_M1_MF2,
  PseudoVLOXSEG4EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG4EI16_V_M2_M1,
  PseudoVLOXSEG4EI16_V_M2_M1_MASK,
  PseudoVLOXSEG4EI16_V_M2_M2,
  PseudoVLOXSEG4EI16_V_M2_M2_MASK,
  PseudoVLOXSEG4EI16_V_M4_M2,
  PseudoVLOXSEG4EI16_V_M4_M2_MASK,
  PseudoVLOXSEG4EI16_V_MF2_M1,
  PseudoVLOXSEG4EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG4EI16_V_MF2_M2,
  PseudoVLOXSEG4EI16_V_MF2_M2_MASK,
  PseudoVLOXSEG4EI16_V_MF2_MF2,
  PseudoVLOXSEG4EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG4EI16_V_MF2_MF4,
  PseudoVLOXSEG4EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG4EI16_V_MF4_M1,
  PseudoVLOXSEG4EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG4EI16_V_MF4_MF2,
  PseudoVLOXSEG4EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG4EI16_V_MF4_MF4,
  PseudoVLOXSEG4EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG4EI16_V_MF4_MF8,
  PseudoVLOXSEG4EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG4EI32_V_M1_M1,
  PseudoVLOXSEG4EI32_V_M1_M1_MASK,
  PseudoVLOXSEG4EI32_V_M1_M2,
  PseudoVLOXSEG4EI32_V_M1_M2_MASK,
  PseudoVLOXSEG4EI32_V_M1_MF2,
  PseudoVLOXSEG4EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG4EI32_V_M1_MF4,
  PseudoVLOXSEG4EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG4EI32_V_M2_M1,
  PseudoVLOXSEG4EI32_V_M2_M1_MASK,
  PseudoVLOXSEG4EI32_V_M2_M2,
  PseudoVLOXSEG4EI32_V_M2_M2_MASK,
  PseudoVLOXSEG4EI32_V_M2_MF2,
  PseudoVLOXSEG4EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG4EI32_V_M4_M1,
  PseudoVLOXSEG4EI32_V_M4_M1_MASK,
  PseudoVLOXSEG4EI32_V_M4_M2,
  PseudoVLOXSEG4EI32_V_M4_M2_MASK,
  PseudoVLOXSEG4EI32_V_M8_M2,
  PseudoVLOXSEG4EI32_V_M8_M2_MASK,
  PseudoVLOXSEG4EI32_V_MF2_M1,
  PseudoVLOXSEG4EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG4EI32_V_MF2_MF2,
  PseudoVLOXSEG4EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG4EI32_V_MF2_MF4,
  PseudoVLOXSEG4EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG4EI32_V_MF2_MF8,
  PseudoVLOXSEG4EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG4EI64_V_M1_M1,
  PseudoVLOXSEG4EI64_V_M1_M1_MASK,
  PseudoVLOXSEG4EI64_V_M1_MF2,
  PseudoVLOXSEG4EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG4EI64_V_M1_MF4,
  PseudoVLOXSEG4EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG4EI64_V_M1_MF8,
  PseudoVLOXSEG4EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG4EI64_V_M2_M1,
  PseudoVLOXSEG4EI64_V_M2_M1_MASK,
  PseudoVLOXSEG4EI64_V_M2_M2,
  PseudoVLOXSEG4EI64_V_M2_M2_MASK,
  PseudoVLOXSEG4EI64_V_M2_MF2,
  PseudoVLOXSEG4EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG4EI64_V_M2_MF4,
  PseudoVLOXSEG4EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG4EI64_V_M4_M1,
  PseudoVLOXSEG4EI64_V_M4_M1_MASK,
  PseudoVLOXSEG4EI64_V_M4_M2,
  PseudoVLOXSEG4EI64_V_M4_M2_MASK,
  PseudoVLOXSEG4EI64_V_M4_MF2,
  PseudoVLOXSEG4EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG4EI64_V_M8_M1,
  PseudoVLOXSEG4EI64_V_M8_M1_MASK,
  PseudoVLOXSEG4EI64_V_M8_M2,
  PseudoVLOXSEG4EI64_V_M8_M2_MASK,
  PseudoVLOXSEG4EI8_V_M1_M1,
  PseudoVLOXSEG4EI8_V_M1_M1_MASK,
  PseudoVLOXSEG4EI8_V_M1_M2,
  PseudoVLOXSEG4EI8_V_M1_M2_MASK,
  PseudoVLOXSEG4EI8_V_M2_M2,
  PseudoVLOXSEG4EI8_V_M2_M2_MASK,
  PseudoVLOXSEG4EI8_V_MF2_M1,
  PseudoVLOXSEG4EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG4EI8_V_MF2_M2,
  PseudoVLOXSEG4EI8_V_MF2_M2_MASK,
  PseudoVLOXSEG4EI8_V_MF2_MF2,
  PseudoVLOXSEG4EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG4EI8_V_MF4_M1,
  PseudoVLOXSEG4EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG4EI8_V_MF4_M2,
  PseudoVLOXSEG4EI8_V_MF4_M2_MASK,
  PseudoVLOXSEG4EI8_V_MF4_MF2,
  PseudoVLOXSEG4EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG4EI8_V_MF4_MF4,
  PseudoVLOXSEG4EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG4EI8_V_MF8_M1,
  PseudoVLOXSEG4EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG4EI8_V_MF8_MF2,
  PseudoVLOXSEG4EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG4EI8_V_MF8_MF4,
  PseudoVLOXSEG4EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG4EI8_V_MF8_MF8,
  PseudoVLOXSEG4EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG5EI16_V_M1_M1,
  PseudoVLOXSEG5EI16_V_M1_M1_MASK,
  PseudoVLOXSEG5EI16_V_M1_MF2,
  PseudoVLOXSEG5EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG5EI16_V_M2_M1,
  PseudoVLOXSEG5EI16_V_M2_M1_MASK,
  PseudoVLOXSEG5EI16_V_MF2_M1,
  PseudoVLOXSEG5EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG5EI16_V_MF2_MF2,
  PseudoVLOXSEG5EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG5EI16_V_MF2_MF4,
  PseudoVLOXSEG5EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG5EI16_V_MF4_M1,
  PseudoVLOXSEG5EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG5EI16_V_MF4_MF2,
  PseudoVLOXSEG5EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG5EI16_V_MF4_MF4,
  PseudoVLOXSEG5EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG5EI16_V_MF4_MF8,
  PseudoVLOXSEG5EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG5EI32_V_M1_M1,
  PseudoVLOXSEG5EI32_V_M1_M1_MASK,
  PseudoVLOXSEG5EI32_V_M1_MF2,
  PseudoVLOXSEG5EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG5EI32_V_M1_MF4,
  PseudoVLOXSEG5EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG5EI32_V_M2_M1,
  PseudoVLOXSEG5EI32_V_M2_M1_MASK,
  PseudoVLOXSEG5EI32_V_M2_MF2,
  PseudoVLOXSEG5EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG5EI32_V_M4_M1,
  PseudoVLOXSEG5EI32_V_M4_M1_MASK,
  PseudoVLOXSEG5EI32_V_MF2_M1,
  PseudoVLOXSEG5EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG5EI32_V_MF2_MF2,
  PseudoVLOXSEG5EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG5EI32_V_MF2_MF4,
  PseudoVLOXSEG5EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG5EI32_V_MF2_MF8,
  PseudoVLOXSEG5EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG5EI64_V_M1_M1,
  PseudoVLOXSEG5EI64_V_M1_M1_MASK,
  PseudoVLOXSEG5EI64_V_M1_MF2,
  PseudoVLOXSEG5EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG5EI64_V_M1_MF4,
  PseudoVLOXSEG5EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG5EI64_V_M1_MF8,
  PseudoVLOXSEG5EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG5EI64_V_M2_M1,
  PseudoVLOXSEG5EI64_V_M2_M1_MASK,
  PseudoVLOXSEG5EI64_V_M2_MF2,
  PseudoVLOXSEG5EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG5EI64_V_M2_MF4,
  PseudoVLOXSEG5EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG5EI64_V_M4_M1,
  PseudoVLOXSEG5EI64_V_M4_M1_MASK,
  PseudoVLOXSEG5EI64_V_M4_MF2,
  PseudoVLOXSEG5EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG5EI64_V_M8_M1,
  PseudoVLOXSEG5EI64_V_M8_M1_MASK,
  PseudoVLOXSEG5EI8_V_M1_M1,
  PseudoVLOXSEG5EI8_V_M1_M1_MASK,
  PseudoVLOXSEG5EI8_V_MF2_M1,
  PseudoVLOXSEG5EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG5EI8_V_MF2_MF2,
  PseudoVLOXSEG5EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG5EI8_V_MF4_M1,
  PseudoVLOXSEG5EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG5EI8_V_MF4_MF2,
  PseudoVLOXSEG5EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG5EI8_V_MF4_MF4,
  PseudoVLOXSEG5EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG5EI8_V_MF8_M1,
  PseudoVLOXSEG5EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG5EI8_V_MF8_MF2,
  PseudoVLOXSEG5EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG5EI8_V_MF8_MF4,
  PseudoVLOXSEG5EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG5EI8_V_MF8_MF8,
  PseudoVLOXSEG5EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG6EI16_V_M1_M1,
  PseudoVLOXSEG6EI16_V_M1_M1_MASK,
  PseudoVLOXSEG6EI16_V_M1_MF2,
  PseudoVLOXSEG6EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG6EI16_V_M2_M1,
  PseudoVLOXSEG6EI16_V_M2_M1_MASK,
  PseudoVLOXSEG6EI16_V_MF2_M1,
  PseudoVLOXSEG6EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG6EI16_V_MF2_MF2,
  PseudoVLOXSEG6EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG6EI16_V_MF2_MF4,
  PseudoVLOXSEG6EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG6EI16_V_MF4_M1,
  PseudoVLOXSEG6EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG6EI16_V_MF4_MF2,
  PseudoVLOXSEG6EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG6EI16_V_MF4_MF4,
  PseudoVLOXSEG6EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG6EI16_V_MF4_MF8,
  PseudoVLOXSEG6EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG6EI32_V_M1_M1,
  PseudoVLOXSEG6EI32_V_M1_M1_MASK,
  PseudoVLOXSEG6EI32_V_M1_MF2,
  PseudoVLOXSEG6EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG6EI32_V_M1_MF4,
  PseudoVLOXSEG6EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG6EI32_V_M2_M1,
  PseudoVLOXSEG6EI32_V_M2_M1_MASK,
  PseudoVLOXSEG6EI32_V_M2_MF2,
  PseudoVLOXSEG6EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG6EI32_V_M4_M1,
  PseudoVLOXSEG6EI32_V_M4_M1_MASK,
  PseudoVLOXSEG6EI32_V_MF2_M1,
  PseudoVLOXSEG6EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG6EI32_V_MF2_MF2,
  PseudoVLOXSEG6EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG6EI32_V_MF2_MF4,
  PseudoVLOXSEG6EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG6EI32_V_MF2_MF8,
  PseudoVLOXSEG6EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG6EI64_V_M1_M1,
  PseudoVLOXSEG6EI64_V_M1_M1_MASK,
  PseudoVLOXSEG6EI64_V_M1_MF2,
  PseudoVLOXSEG6EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG6EI64_V_M1_MF4,
  PseudoVLOXSEG6EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG6EI64_V_M1_MF8,
  PseudoVLOXSEG6EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG6EI64_V_M2_M1,
  PseudoVLOXSEG6EI64_V_M2_M1_MASK,
  PseudoVLOXSEG6EI64_V_M2_MF2,
  PseudoVLOXSEG6EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG6EI64_V_M2_MF4,
  PseudoVLOXSEG6EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG6EI64_V_M4_M1,
  PseudoVLOXSEG6EI64_V_M4_M1_MASK,
  PseudoVLOXSEG6EI64_V_M4_MF2,
  PseudoVLOXSEG6EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG6EI64_V_M8_M1,
  PseudoVLOXSEG6EI64_V_M8_M1_MASK,
  PseudoVLOXSEG6EI8_V_M1_M1,
  PseudoVLOXSEG6EI8_V_M1_M1_MASK,
  PseudoVLOXSEG6EI8_V_MF2_M1,
  PseudoVLOXSEG6EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG6EI8_V_MF2_MF2,
  PseudoVLOXSEG6EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG6EI8_V_MF4_M1,
  PseudoVLOXSEG6EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG6EI8_V_MF4_MF2,
  PseudoVLOXSEG6EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG6EI8_V_MF4_MF4,
  PseudoVLOXSEG6EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG6EI8_V_MF8_M1,
  PseudoVLOXSEG6EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG6EI8_V_MF8_MF2,
  PseudoVLOXSEG6EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG6EI8_V_MF8_MF4,
  PseudoVLOXSEG6EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG6EI8_V_MF8_MF8,
  PseudoVLOXSEG6EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG7EI16_V_M1_M1,
  PseudoVLOXSEG7EI16_V_M1_M1_MASK,
  PseudoVLOXSEG7EI16_V_M1_MF2,
  PseudoVLOXSEG7EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG7EI16_V_M2_M1,
  PseudoVLOXSEG7EI16_V_M2_M1_MASK,
  PseudoVLOXSEG7EI16_V_MF2_M1,
  PseudoVLOXSEG7EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG7EI16_V_MF2_MF2,
  PseudoVLOXSEG7EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG7EI16_V_MF2_MF4,
  PseudoVLOXSEG7EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG7EI16_V_MF4_M1,
  PseudoVLOXSEG7EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG7EI16_V_MF4_MF2,
  PseudoVLOXSEG7EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG7EI16_V_MF4_MF4,
  PseudoVLOXSEG7EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG7EI16_V_MF4_MF8,
  PseudoVLOXSEG7EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG7EI32_V_M1_M1,
  PseudoVLOXSEG7EI32_V_M1_M1_MASK,
  PseudoVLOXSEG7EI32_V_M1_MF2,
  PseudoVLOXSEG7EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG7EI32_V_M1_MF4,
  PseudoVLOXSEG7EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG7EI32_V_M2_M1,
  PseudoVLOXSEG7EI32_V_M2_M1_MASK,
  PseudoVLOXSEG7EI32_V_M2_MF2,
  PseudoVLOXSEG7EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG7EI32_V_M4_M1,
  PseudoVLOXSEG7EI32_V_M4_M1_MASK,
  PseudoVLOXSEG7EI32_V_MF2_M1,
  PseudoVLOXSEG7EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG7EI32_V_MF2_MF2,
  PseudoVLOXSEG7EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG7EI32_V_MF2_MF4,
  PseudoVLOXSEG7EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG7EI32_V_MF2_MF8,
  PseudoVLOXSEG7EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG7EI64_V_M1_M1,
  PseudoVLOXSEG7EI64_V_M1_M1_MASK,
  PseudoVLOXSEG7EI64_V_M1_MF2,
  PseudoVLOXSEG7EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG7EI64_V_M1_MF4,
  PseudoVLOXSEG7EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG7EI64_V_M1_MF8,
  PseudoVLOXSEG7EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG7EI64_V_M2_M1,
  PseudoVLOXSEG7EI64_V_M2_M1_MASK,
  PseudoVLOXSEG7EI64_V_M2_MF2,
  PseudoVLOXSEG7EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG7EI64_V_M2_MF4,
  PseudoVLOXSEG7EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG7EI64_V_M4_M1,
  PseudoVLOXSEG7EI64_V_M4_M1_MASK,
  PseudoVLOXSEG7EI64_V_M4_MF2,
  PseudoVLOXSEG7EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG7EI64_V_M8_M1,
  PseudoVLOXSEG7EI64_V_M8_M1_MASK,
  PseudoVLOXSEG7EI8_V_M1_M1,
  PseudoVLOXSEG7EI8_V_M1_M1_MASK,
  PseudoVLOXSEG7EI8_V_MF2_M1,
  PseudoVLOXSEG7EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG7EI8_V_MF2_MF2,
  PseudoVLOXSEG7EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG7EI8_V_MF4_M1,
  PseudoVLOXSEG7EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG7EI8_V_MF4_MF2,
  PseudoVLOXSEG7EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG7EI8_V_MF4_MF4,
  PseudoVLOXSEG7EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG7EI8_V_MF8_M1,
  PseudoVLOXSEG7EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG7EI8_V_MF8_MF2,
  PseudoVLOXSEG7EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG7EI8_V_MF8_MF4,
  PseudoVLOXSEG7EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG7EI8_V_MF8_MF8,
  PseudoVLOXSEG7EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG8EI16_V_M1_M1,
  PseudoVLOXSEG8EI16_V_M1_M1_MASK,
  PseudoVLOXSEG8EI16_V_M1_MF2,
  PseudoVLOXSEG8EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG8EI16_V_M2_M1,
  PseudoVLOXSEG8EI16_V_M2_M1_MASK,
  PseudoVLOXSEG8EI16_V_MF2_M1,
  PseudoVLOXSEG8EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG8EI16_V_MF2_MF2,
  PseudoVLOXSEG8EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG8EI16_V_MF2_MF4,
  PseudoVLOXSEG8EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG8EI16_V_MF4_M1,
  PseudoVLOXSEG8EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG8EI16_V_MF4_MF2,
  PseudoVLOXSEG8EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG8EI16_V_MF4_MF4,
  PseudoVLOXSEG8EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG8EI16_V_MF4_MF8,
  PseudoVLOXSEG8EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG8EI32_V_M1_M1,
  PseudoVLOXSEG8EI32_V_M1_M1_MASK,
  PseudoVLOXSEG8EI32_V_M1_MF2,
  PseudoVLOXSEG8EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG8EI32_V_M1_MF4,
  PseudoVLOXSEG8EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG8EI32_V_M2_M1,
  PseudoVLOXSEG8EI32_V_M2_M1_MASK,
  PseudoVLOXSEG8EI32_V_M2_MF2,
  PseudoVLOXSEG8EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG8EI32_V_M4_M1,
  PseudoVLOXSEG8EI32_V_M4_M1_MASK,
  PseudoVLOXSEG8EI32_V_MF2_M1,
  PseudoVLOXSEG8EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG8EI32_V_MF2_MF2,
  PseudoVLOXSEG8EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG8EI32_V_MF2_MF4,
  PseudoVLOXSEG8EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG8EI32_V_MF2_MF8,
  PseudoVLOXSEG8EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG8EI64_V_M1_M1,
  PseudoVLOXSEG8EI64_V_M1_M1_MASK,
  PseudoVLOXSEG8EI64_V_M1_MF2,
  PseudoVLOXSEG8EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG8EI64_V_M1_MF4,
  PseudoVLOXSEG8EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG8EI64_V_M1_MF8,
  PseudoVLOXSEG8EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG8EI64_V_M2_M1,
  PseudoVLOXSEG8EI64_V_M2_M1_MASK,
  PseudoVLOXSEG8EI64_V_M2_MF2,
  PseudoVLOXSEG8EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG8EI64_V_M2_MF4,
  PseudoVLOXSEG8EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG8EI64_V_M4_M1,
  PseudoVLOXSEG8EI64_V_M4_M1_MASK,
  PseudoVLOXSEG8EI64_V_M4_MF2,
  PseudoVLOXSEG8EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG8EI64_V_M8_M1,
  PseudoVLOXSEG8EI64_V_M8_M1_MASK,
  PseudoVLOXSEG8EI8_V_M1_M1,
  PseudoVLOXSEG8EI8_V_M1_M1_MASK,
  PseudoVLOXSEG8EI8_V_MF2_M1,
  PseudoVLOXSEG8EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG8EI8_V_MF2_MF2,
  PseudoVLOXSEG8EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG8EI8_V_MF4_M1,
  PseudoVLOXSEG8EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG8EI8_V_MF4_MF2,
  PseudoVLOXSEG8EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG8EI8_V_MF4_MF4,
  PseudoVLOXSEG8EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG8EI8_V_MF8_M1,
  PseudoVLOXSEG8EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG8EI8_V_MF8_MF2,
  PseudoVLOXSEG8EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG8EI8_V_MF8_MF4,
  PseudoVLOXSEG8EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG8EI8_V_MF8_MF8,
  PseudoVLOXSEG8EI8_V_MF8_MF8_MASK,
  PseudoVLSE16_V_M1,
  PseudoVLSE16_V_M1_MASK,
  PseudoVLSE16_V_M2,
  PseudoVLSE16_V_M2_MASK,
  PseudoVLSE16_V_M4,
  PseudoVLSE16_V_M4_MASK,
  PseudoVLSE16_V_M8,
  PseudoVLSE16_V_M8_MASK,
  PseudoVLSE16_V_MF2,
  PseudoVLSE16_V_MF2_MASK,
  PseudoVLSE16_V_MF4,
  PseudoVLSE16_V_MF4_MASK,
  PseudoVLSE32_V_M1,
  PseudoVLSE32_V_M1_MASK,
  PseudoVLSE32_V_M2,
  PseudoVLSE32_V_M2_MASK,
  PseudoVLSE32_V_M4,
  PseudoVLSE32_V_M4_MASK,
  PseudoVLSE32_V_M8,
  PseudoVLSE32_V_M8_MASK,
  PseudoVLSE32_V_MF2,
  PseudoVLSE32_V_MF2_MASK,
  PseudoVLSE64_V_M1,
  PseudoVLSE64_V_M1_MASK,
  PseudoVLSE64_V_M2,
  PseudoVLSE64_V_M2_MASK,
  PseudoVLSE64_V_M4,
  PseudoVLSE64_V_M4_MASK,
  PseudoVLSE64_V_M8,
  PseudoVLSE64_V_M8_MASK,
  PseudoVLSE8_V_M1,
  PseudoVLSE8_V_M1_MASK,
  PseudoVLSE8_V_M2,
  PseudoVLSE8_V_M2_MASK,
  PseudoVLSE8_V_M4,
  PseudoVLSE8_V_M4_MASK,
  PseudoVLSE8_V_M8,
  PseudoVLSE8_V_M8_MASK,
  PseudoVLSE8_V_MF2,
  PseudoVLSE8_V_MF2_MASK,
  PseudoVLSE8_V_MF4,
  PseudoVLSE8_V_MF4_MASK,
  PseudoVLSE8_V_MF8,
  PseudoVLSE8_V_MF8_MASK,
  PseudoVLSEG2E16FF_V_M1,
  PseudoVLSEG2E16FF_V_M1_MASK,
  PseudoVLSEG2E16FF_V_M2,
  PseudoVLSEG2E16FF_V_M2_MASK,
  PseudoVLSEG2E16FF_V_M4,
  PseudoVLSEG2E16FF_V_M4_MASK,
  PseudoVLSEG2E16FF_V_MF2,
  PseudoVLSEG2E16FF_V_MF2_MASK,
  PseudoVLSEG2E16FF_V_MF4,
  PseudoVLSEG2E16FF_V_MF4_MASK,
  PseudoVLSEG2E16_V_M1,
  PseudoVLSEG2E16_V_M1_MASK,
  PseudoVLSEG2E16_V_M2,
  PseudoVLSEG2E16_V_M2_MASK,
  PseudoVLSEG2E16_V_M4,
  PseudoVLSEG2E16_V_M4_MASK,
  PseudoVLSEG2E16_V_MF2,
  PseudoVLSEG2E16_V_MF2_MASK,
  PseudoVLSEG2E16_V_MF4,
  PseudoVLSEG2E16_V_MF4_MASK,
  PseudoVLSEG2E32FF_V_M1,
  PseudoVLSEG2E32FF_V_M1_MASK,
  PseudoVLSEG2E32FF_V_M2,
  PseudoVLSEG2E32FF_V_M2_MASK,
  PseudoVLSEG2E32FF_V_M4,
  PseudoVLSEG2E32FF_V_M4_MASK,
  PseudoVLSEG2E32FF_V_MF2,
  PseudoVLSEG2E32FF_V_MF2_MASK,
  PseudoVLSEG2E32_V_M1,
  PseudoVLSEG2E32_V_M1_MASK,
  PseudoVLSEG2E32_V_M2,
  PseudoVLSEG2E32_V_M2_MASK,
  PseudoVLSEG2E32_V_M4,
  PseudoVLSEG2E32_V_M4_MASK,
  PseudoVLSEG2E32_V_MF2,
  PseudoVLSEG2E32_V_MF2_MASK,
  PseudoVLSEG2E64FF_V_M1,
  PseudoVLSEG2E64FF_V_M1_MASK,
  PseudoVLSEG2E64FF_V_M2,
  PseudoVLSEG2E64FF_V_M2_MASK,
  PseudoVLSEG2E64FF_V_M4,
  PseudoVLSEG2E64FF_V_M4_MASK,
  PseudoVLSEG2E64_V_M1,
  PseudoVLSEG2E64_V_M1_MASK,
  PseudoVLSEG2E64_V_M2,
  PseudoVLSEG2E64_V_M2_MASK,
  PseudoVLSEG2E64_V_M4,
  PseudoVLSEG2E64_V_M4_MASK,
  PseudoVLSEG2E8FF_V_M1,
  PseudoVLSEG2E8FF_V_M1_MASK,
  PseudoVLSEG2E8FF_V_M2,
  PseudoVLSEG2E8FF_V_M2_MASK,
  PseudoVLSEG2E8FF_V_M4,
  PseudoVLSEG2E8FF_V_M4_MASK,
  PseudoVLSEG2E8FF_V_MF2,
  PseudoVLSEG2E8FF_V_MF2_MASK,
  PseudoVLSEG2E8FF_V_MF4,
  PseudoVLSEG2E8FF_V_MF4_MASK,
  PseudoVLSEG2E8FF_V_MF8,
  PseudoVLSEG2E8FF_V_MF8_MASK,
  PseudoVLSEG2E8_V_M1,
  PseudoVLSEG2E8_V_M1_MASK,
  PseudoVLSEG2E8_V_M2,
  PseudoVLSEG2E8_V_M2_MASK,
  PseudoVLSEG2E8_V_M4,
  PseudoVLSEG2E8_V_M4_MASK,
  PseudoVLSEG2E8_V_MF2,
  PseudoVLSEG2E8_V_MF2_MASK,
  PseudoVLSEG2E8_V_MF4,
  PseudoVLSEG2E8_V_MF4_MASK,
  PseudoVLSEG2E8_V_MF8,
  PseudoVLSEG2E8_V_MF8_MASK,
  PseudoVLSEG3E16FF_V_M1,
  PseudoVLSEG3E16FF_V_M1_MASK,
  PseudoVLSEG3E16FF_V_M2,
  PseudoVLSEG3E16FF_V_M2_MASK,
  PseudoVLSEG3E16FF_V_MF2,
  PseudoVLSEG3E16FF_V_MF2_MASK,
  PseudoVLSEG3E16FF_V_MF4,
  PseudoVLSEG3E16FF_V_MF4_MASK,
  PseudoVLSEG3E16_V_M1,
  PseudoVLSEG3E16_V_M1_MASK,
  PseudoVLSEG3E16_V_M2,
  PseudoVLSEG3E16_V_M2_MASK,
  PseudoVLSEG3E16_V_MF2,
  PseudoVLSEG3E16_V_MF2_MASK,
  PseudoVLSEG3E16_V_MF4,
  PseudoVLSEG3E16_V_MF4_MASK,
  PseudoVLSEG3E32FF_V_M1,
  PseudoVLSEG3E32FF_V_M1_MASK,
  PseudoVLSEG3E32FF_V_M2,
  PseudoVLSEG3E32FF_V_M2_MASK,
  PseudoVLSEG3E32FF_V_MF2,
  PseudoVLSEG3E32FF_V_MF2_MASK,
  PseudoVLSEG3E32_V_M1,
  PseudoVLSEG3E32_V_M1_MASK,
  PseudoVLSEG3E32_V_M2,
  PseudoVLSEG3E32_V_M2_MASK,
  PseudoVLSEG3E32_V_MF2,
  PseudoVLSEG3E32_V_MF2_MASK,
  PseudoVLSEG3E64FF_V_M1,
  PseudoVLSEG3E64FF_V_M1_MASK,
  PseudoVLSEG3E64FF_V_M2,
  PseudoVLSEG3E64FF_V_M2_MASK,
  PseudoVLSEG3E64_V_M1,
  PseudoVLSEG3E64_V_M1_MASK,
  PseudoVLSEG3E64_V_M2,
  PseudoVLSEG3E64_V_M2_MASK,
  PseudoVLSEG3E8FF_V_M1,
  PseudoVLSEG3E8FF_V_M1_MASK,
  PseudoVLSEG3E8FF_V_M2,
  PseudoVLSEG3E8FF_V_M2_MASK,
  PseudoVLSEG3E8FF_V_MF2,
  PseudoVLSEG3E8FF_V_MF2_MASK,
  PseudoVLSEG3E8FF_V_MF4,
  PseudoVLSEG3E8FF_V_MF4_MASK,
  PseudoVLSEG3E8FF_V_MF8,
  PseudoVLSEG3E8FF_V_MF8_MASK,
  PseudoVLSEG3E8_V_M1,
  PseudoVLSEG3E8_V_M1_MASK,
  PseudoVLSEG3E8_V_M2,
  PseudoVLSEG3E8_V_M2_MASK,
  PseudoVLSEG3E8_V_MF2,
  PseudoVLSEG3E8_V_MF2_MASK,
  PseudoVLSEG3E8_V_MF4,
  PseudoVLSEG3E8_V_MF4_MASK,
  PseudoVLSEG3E8_V_MF8,
  PseudoVLSEG3E8_V_MF8_MASK,
  PseudoVLSEG4E16FF_V_M1,
  PseudoVLSEG4E16FF_V_M1_MASK,
  PseudoVLSEG4E16FF_V_M2,
  PseudoVLSEG4E16FF_V_M2_MASK,
  PseudoVLSEG4E16FF_V_MF2,
  PseudoVLSEG4E16FF_V_MF2_MASK,
  PseudoVLSEG4E16FF_V_MF4,
  PseudoVLSEG4E16FF_V_MF4_MASK,
  PseudoVLSEG4E16_V_M1,
  PseudoVLSEG4E16_V_M1_MASK,
  PseudoVLSEG4E16_V_M2,
  PseudoVLSEG4E16_V_M2_MASK,
  PseudoVLSEG4E16_V_MF2,
  PseudoVLSEG4E16_V_MF2_MASK,
  PseudoVLSEG4E16_V_MF4,
  PseudoVLSEG4E16_V_MF4_MASK,
  PseudoVLSEG4E32FF_V_M1,
  PseudoVLSEG4E32FF_V_M1_MASK,
  PseudoVLSEG4E32FF_V_M2,
  PseudoVLSEG4E32FF_V_M2_MASK,
  PseudoVLSEG4E32FF_V_MF2,
  PseudoVLSEG4E32FF_V_MF2_MASK,
  PseudoVLSEG4E32_V_M1,
  PseudoVLSEG4E32_V_M1_MASK,
  PseudoVLSEG4E32_V_M2,
  PseudoVLSEG4E32_V_M2_MASK,
  PseudoVLSEG4E32_V_MF2,
  PseudoVLSEG4E32_V_MF2_MASK,
  PseudoVLSEG4E64FF_V_M1,
  PseudoVLSEG4E64FF_V_M1_MASK,
  PseudoVLSEG4E64FF_V_M2,
  PseudoVLSEG4E64FF_V_M2_MASK,
  PseudoVLSEG4E64_V_M1,
  PseudoVLSEG4E64_V_M1_MASK,
  PseudoVLSEG4E64_V_M2,
  PseudoVLSEG4E64_V_M2_MASK,
  PseudoVLSEG4E8FF_V_M1,
  PseudoVLSEG4E8FF_V_M1_MASK,
  PseudoVLSEG4E8FF_V_M2,
  PseudoVLSEG4E8FF_V_M2_MASK,
  PseudoVLSEG4E8FF_V_MF2,
  PseudoVLSEG4E8FF_V_MF2_MASK,
  PseudoVLSEG4E8FF_V_MF4,
  PseudoVLSEG4E8FF_V_MF4_MASK,
  PseudoVLSEG4E8FF_V_MF8,
  PseudoVLSEG4E8FF_V_MF8_MASK,
  PseudoVLSEG4E8_V_M1,
  PseudoVLSEG4E8_V_M1_MASK,
  PseudoVLSEG4E8_V_M2,
  PseudoVLSEG4E8_V_M2_MASK,
  PseudoVLSEG4E8_V_MF2,
  PseudoVLSEG4E8_V_MF2_MASK,
  PseudoVLSEG4E8_V_MF4,
  PseudoVLSEG4E8_V_MF4_MASK,
  PseudoVLSEG4E8_V_MF8,
  PseudoVLSEG4E8_V_MF8_MASK,
  PseudoVLSEG5E16FF_V_M1,
  PseudoVLSEG5E16FF_V_M1_MASK,
  PseudoVLSEG5E16FF_V_MF2,
  PseudoVLSEG5E16FF_V_MF2_MASK,
  PseudoVLSEG5E16FF_V_MF4,
  PseudoVLSEG5E16FF_V_MF4_MASK,
  PseudoVLSEG5E16_V_M1,
  PseudoVLSEG5E16_V_M1_MASK,
  PseudoVLSEG5E16_V_MF2,
  PseudoVLSEG5E16_V_MF2_MASK,
  PseudoVLSEG5E16_V_MF4,
  PseudoVLSEG5E16_V_MF4_MASK,
  PseudoVLSEG5E32FF_V_M1,
  PseudoVLSEG5E32FF_V_M1_MASK,
  PseudoVLSEG5E32FF_V_MF2,
  PseudoVLSEG5E32FF_V_MF2_MASK,
  PseudoVLSEG5E32_V_M1,
  PseudoVLSEG5E32_V_M1_MASK,
  PseudoVLSEG5E32_V_MF2,
  PseudoVLSEG5E32_V_MF2_MASK,
  PseudoVLSEG5E64FF_V_M1,
  PseudoVLSEG5E64FF_V_M1_MASK,
  PseudoVLSEG5E64_V_M1,
  PseudoVLSEG5E64_V_M1_MASK,
  PseudoVLSEG5E8FF_V_M1,
  PseudoVLSEG5E8FF_V_M1_MASK,
  PseudoVLSEG5E8FF_V_MF2,
  PseudoVLSEG5E8FF_V_MF2_MASK,
  PseudoVLSEG5E8FF_V_MF4,
  PseudoVLSEG5E8FF_V_MF4_MASK,
  PseudoVLSEG5E8FF_V_MF8,
  PseudoVLSEG5E8FF_V_MF8_MASK,
  PseudoVLSEG5E8_V_M1,
  PseudoVLSEG5E8_V_M1_MASK,
  PseudoVLSEG5E8_V_MF2,
  PseudoVLSEG5E8_V_MF2_MASK,
  PseudoVLSEG5E8_V_MF4,
  PseudoVLSEG5E8_V_MF4_MASK,
  PseudoVLSEG5E8_V_MF8,
  PseudoVLSEG5E8_V_MF8_MASK,
  PseudoVLSEG6E16FF_V_M1,
  PseudoVLSEG6E16FF_V_M1_MASK,
  PseudoVLSEG6E16FF_V_MF2,
  PseudoVLSEG6E16FF_V_MF2_MASK,
  PseudoVLSEG6E16FF_V_MF4,
  PseudoVLSEG6E16FF_V_MF4_MASK,
  PseudoVLSEG6E16_V_M1,
  PseudoVLSEG6E16_V_M1_MASK,
  PseudoVLSEG6E16_V_MF2,
  PseudoVLSEG6E16_V_MF2_MASK,
  PseudoVLSEG6E16_V_MF4,
  PseudoVLSEG6E16_V_MF4_MASK,
  PseudoVLSEG6E32FF_V_M1,
  PseudoVLSEG6E32FF_V_M1_MASK,
  PseudoVLSEG6E32FF_V_MF2,
  PseudoVLSEG6E32FF_V_MF2_MASK,
  PseudoVLSEG6E32_V_M1,
  PseudoVLSEG6E32_V_M1_MASK,
  PseudoVLSEG6E32_V_MF2,
  PseudoVLSEG6E32_V_MF2_MASK,
  PseudoVLSEG6E64FF_V_M1,
  PseudoVLSEG6E64FF_V_M1_MASK,
  PseudoVLSEG6E64_V_M1,
  PseudoVLSEG6E64_V_M1_MASK,
  PseudoVLSEG6E8FF_V_M1,
  PseudoVLSEG6E8FF_V_M1_MASK,
  PseudoVLSEG6E8FF_V_MF2,
  PseudoVLSEG6E8FF_V_MF2_MASK,
  PseudoVLSEG6E8FF_V_MF4,
  PseudoVLSEG6E8FF_V_MF4_MASK,
  PseudoVLSEG6E8FF_V_MF8,
  PseudoVLSEG6E8FF_V_MF8_MASK,
  PseudoVLSEG6E8_V_M1,
  PseudoVLSEG6E8_V_M1_MASK,
  PseudoVLSEG6E8_V_MF2,
  PseudoVLSEG6E8_V_MF2_MASK,
  PseudoVLSEG6E8_V_MF4,
  PseudoVLSEG6E8_V_MF4_MASK,
  PseudoVLSEG6E8_V_MF8,
  PseudoVLSEG6E8_V_MF8_MASK,
  PseudoVLSEG7E16FF_V_M1,
  PseudoVLSEG7E16FF_V_M1_MASK,
  PseudoVLSEG7E16FF_V_MF2,
  PseudoVLSEG7E16FF_V_MF2_MASK,
  PseudoVLSEG7E16FF_V_MF4,
  PseudoVLSEG7E16FF_V_MF4_MASK,
  PseudoVLSEG7E16_V_M1,
  PseudoVLSEG7E16_V_M1_MASK,
  PseudoVLSEG7E16_V_MF2,
  PseudoVLSEG7E16_V_MF2_MASK,
  PseudoVLSEG7E16_V_MF4,
  PseudoVLSEG7E16_V_MF4_MASK,
  PseudoVLSEG7E32FF_V_M1,
  PseudoVLSEG7E32FF_V_M1_MASK,
  PseudoVLSEG7E32FF_V_MF2,
  PseudoVLSEG7E32FF_V_MF2_MASK,
  PseudoVLSEG7E32_V_M1,
  PseudoVLSEG7E32_V_M1_MASK,
  PseudoVLSEG7E32_V_MF2,
  PseudoVLSEG7E32_V_MF2_MASK,
  PseudoVLSEG7E64FF_V_M1,
  PseudoVLSEG7E64FF_V_M1_MASK,
  PseudoVLSEG7E64_V_M1,
  PseudoVLSEG7E64_V_M1_MASK,
  PseudoVLSEG7E8FF_V_M1,
  PseudoVLSEG7E8FF_V_M1_MASK,
  PseudoVLSEG7E8FF_V_MF2,
  PseudoVLSEG7E8FF_V_MF2_MASK,
  PseudoVLSEG7E8FF_V_MF4,
  PseudoVLSEG7E8FF_V_MF4_MASK,
  PseudoVLSEG7E8FF_V_MF8,
  PseudoVLSEG7E8FF_V_MF8_MASK,
  PseudoVLSEG7E8_V_M1,
  PseudoVLSEG7E8_V_M1_MASK,
  PseudoVLSEG7E8_V_MF2,
  PseudoVLSEG7E8_V_MF2_MASK,
  PseudoVLSEG7E8_V_MF4,
  PseudoVLSEG7E8_V_MF4_MASK,
  PseudoVLSEG7E8_V_MF8,
  PseudoVLSEG7E8_V_MF8_MASK,
  PseudoVLSEG8E16FF_V_M1,
  PseudoVLSEG8E16FF_V_M1_MASK,
  PseudoVLSEG8E16FF_V_MF2,
  PseudoVLSEG8E16FF_V_MF2_MASK,
  PseudoVLSEG8E16FF_V_MF4,
  PseudoVLSEG8E16FF_V_MF4_MASK,
  PseudoVLSEG8E16_V_M1,
  PseudoVLSEG8E16_V_M1_MASK,
  PseudoVLSEG8E16_V_MF2,
  PseudoVLSEG8E16_V_MF2_MASK,
  PseudoVLSEG8E16_V_MF4,
  PseudoVLSEG8E16_V_MF4_MASK,
  PseudoVLSEG8E32FF_V_M1,
  PseudoVLSEG8E32FF_V_M1_MASK,
  PseudoVLSEG8E32FF_V_MF2,
  PseudoVLSEG8E32FF_V_MF2_MASK,
  PseudoVLSEG8E32_V_M1,
  PseudoVLSEG8E32_V_M1_MASK,
  PseudoVLSEG8E32_V_MF2,
  PseudoVLSEG8E32_V_MF2_MASK,
  PseudoVLSEG8E64FF_V_M1,
  PseudoVLSEG8E64FF_V_M1_MASK,
  PseudoVLSEG8E64_V_M1,
  PseudoVLSEG8E64_V_M1_MASK,
  PseudoVLSEG8E8FF_V_M1,
  PseudoVLSEG8E8FF_V_M1_MASK,
  PseudoVLSEG8E8FF_V_MF2,
  PseudoVLSEG8E8FF_V_MF2_MASK,
  PseudoVLSEG8E8FF_V_MF4,
  PseudoVLSEG8E8FF_V_MF4_MASK,
  PseudoVLSEG8E8FF_V_MF8,
  PseudoVLSEG8E8FF_V_MF8_MASK,
  PseudoVLSEG8E8_V_M1,
  PseudoVLSEG8E8_V_M1_MASK,
  PseudoVLSEG8E8_V_MF2,
  PseudoVLSEG8E8_V_MF2_MASK,
  PseudoVLSEG8E8_V_MF4,
  PseudoVLSEG8E8_V_MF4_MASK,
  PseudoVLSEG8E8_V_MF8,
  PseudoVLSEG8E8_V_MF8_MASK,
  PseudoVLSSEG2E16_V_M1,
  PseudoVLSSEG2E16_V_M1_MASK,
  PseudoVLSSEG2E16_V_M2,
  PseudoVLSSEG2E16_V_M2_MASK,
  PseudoVLSSEG2E16_V_M4,
  PseudoVLSSEG2E16_V_M4_MASK,
  PseudoVLSSEG2E16_V_MF2,
  PseudoVLSSEG2E16_V_MF2_MASK,
  PseudoVLSSEG2E16_V_MF4,
  PseudoVLSSEG2E16_V_MF4_MASK,
  PseudoVLSSEG2E32_V_M1,
  PseudoVLSSEG2E32_V_M1_MASK,
  PseudoVLSSEG2E32_V_M2,
  PseudoVLSSEG2E32_V_M2_MASK,
  PseudoVLSSEG2E32_V_M4,
  PseudoVLSSEG2E32_V_M4_MASK,
  PseudoVLSSEG2E32_V_MF2,
  PseudoVLSSEG2E32_V_MF2_MASK,
  PseudoVLSSEG2E64_V_M1,
  PseudoVLSSEG2E64_V_M1_MASK,
  PseudoVLSSEG2E64_V_M2,
  PseudoVLSSEG2E64_V_M2_MASK,
  PseudoVLSSEG2E64_V_M4,
  PseudoVLSSEG2E64_V_M4_MASK,
  PseudoVLSSEG2E8_V_M1,
  PseudoVLSSEG2E8_V_M1_MASK,
  PseudoVLSSEG2E8_V_M2,
  PseudoVLSSEG2E8_V_M2_MASK,
  PseudoVLSSEG2E8_V_M4,
  PseudoVLSSEG2E8_V_M4_MASK,
  PseudoVLSSEG2E8_V_MF2,
  PseudoVLSSEG2E8_V_MF2_MASK,
  PseudoVLSSEG2E8_V_MF4,
  PseudoVLSSEG2E8_V_MF4_MASK,
  PseudoVLSSEG2E8_V_MF8,
  PseudoVLSSEG2E8_V_MF8_MASK,
  PseudoVLSSEG3E16_V_M1,
  PseudoVLSSEG3E16_V_M1_MASK,
  PseudoVLSSEG3E16_V_M2,
  PseudoVLSSEG3E16_V_M2_MASK,
  PseudoVLSSEG3E16_V_MF2,
  PseudoVLSSEG3E16_V_MF2_MASK,
  PseudoVLSSEG3E16_V_MF4,
  PseudoVLSSEG3E16_V_MF4_MASK,
  PseudoVLSSEG3E32_V_M1,
  PseudoVLSSEG3E32_V_M1_MASK,
  PseudoVLSSEG3E32_V_M2,
  PseudoVLSSEG3E32_V_M2_MASK,
  PseudoVLSSEG3E32_V_MF2,
  PseudoVLSSEG3E32_V_MF2_MASK,
  PseudoVLSSEG3E64_V_M1,
  PseudoVLSSEG3E64_V_M1_MASK,
  PseudoVLSSEG3E64_V_M2,
  PseudoVLSSEG3E64_V_M2_MASK,
  PseudoVLSSEG3E8_V_M1,
  PseudoVLSSEG3E8_V_M1_MASK,
  PseudoVLSSEG3E8_V_M2,
  PseudoVLSSEG3E8_V_M2_MASK,
  PseudoVLSSEG3E8_V_MF2,
  PseudoVLSSEG3E8_V_MF2_MASK,
  PseudoVLSSEG3E8_V_MF4,
  PseudoVLSSEG3E8_V_MF4_MASK,
  PseudoVLSSEG3E8_V_MF8,
  PseudoVLSSEG3E8_V_MF8_MASK,
  PseudoVLSSEG4E16_V_M1,
  PseudoVLSSEG4E16_V_M1_MASK,
  PseudoVLSSEG4E16_V_M2,
  PseudoVLSSEG4E16_V_M2_MASK,
  PseudoVLSSEG4E16_V_MF2,
  PseudoVLSSEG4E16_V_MF2_MASK,
  PseudoVLSSEG4E16_V_MF4,
  PseudoVLSSEG4E16_V_MF4_MASK,
  PseudoVLSSEG4E32_V_M1,
  PseudoVLSSEG4E32_V_M1_MASK,
  PseudoVLSSEG4E32_V_M2,
  PseudoVLSSEG4E32_V_M2_MASK,
  PseudoVLSSEG4E32_V_MF2,
  PseudoVLSSEG4E32_V_MF2_MASK,
  PseudoVLSSEG4E64_V_M1,
  PseudoVLSSEG4E64_V_M1_MASK,
  PseudoVLSSEG4E64_V_M2,
  PseudoVLSSEG4E64_V_M2_MASK,
  PseudoVLSSEG4E8_V_M1,
  PseudoVLSSEG4E8_V_M1_MASK,
  PseudoVLSSEG4E8_V_M2,
  PseudoVLSSEG4E8_V_M2_MASK,
  PseudoVLSSEG4E8_V_MF2,
  PseudoVLSSEG4E8_V_MF2_MASK,
  PseudoVLSSEG4E8_V_MF4,
  PseudoVLSSEG4E8_V_MF4_MASK,
  PseudoVLSSEG4E8_V_MF8,
  PseudoVLSSEG4E8_V_MF8_MASK,
  PseudoVLSSEG5E16_V_M1,
  PseudoVLSSEG5E16_V_M1_MASK,
  PseudoVLSSEG5E16_V_MF2,
  PseudoVLSSEG5E16_V_MF2_MASK,
  PseudoVLSSEG5E16_V_MF4,
  PseudoVLSSEG5E16_V_MF4_MASK,
  PseudoVLSSEG5E32_V_M1,
  PseudoVLSSEG5E32_V_M1_MASK,
  PseudoVLSSEG5E32_V_MF2,
  PseudoVLSSEG5E32_V_MF2_MASK,
  PseudoVLSSEG5E64_V_M1,
  PseudoVLSSEG5E64_V_M1_MASK,
  PseudoVLSSEG5E8_V_M1,
  PseudoVLSSEG5E8_V_M1_MASK,
  PseudoVLSSEG5E8_V_MF2,
  PseudoVLSSEG5E8_V_MF2_MASK,
  PseudoVLSSEG5E8_V_MF4,
  PseudoVLSSEG5E8_V_MF4_MASK,
  PseudoVLSSEG5E8_V_MF8,
  PseudoVLSSEG5E8_V_MF8_MASK,
  PseudoVLSSEG6E16_V_M1,
  PseudoVLSSEG6E16_V_M1_MASK,
  PseudoVLSSEG6E16_V_MF2,
  PseudoVLSSEG6E16_V_MF2_MASK,
  PseudoVLSSEG6E16_V_MF4,
  PseudoVLSSEG6E16_V_MF4_MASK,
  PseudoVLSSEG6E32_V_M1,
  PseudoVLSSEG6E32_V_M1_MASK,
  PseudoVLSSEG6E32_V_MF2,
  PseudoVLSSEG6E32_V_MF2_MASK,
  PseudoVLSSEG6E64_V_M1,
  PseudoVLSSEG6E64_V_M1_MASK,
  PseudoVLSSEG6E8_V_M1,
  PseudoVLSSEG6E8_V_M1_MASK,
  PseudoVLSSEG6E8_V_MF2,
  PseudoVLSSEG6E8_V_MF2_MASK,
  PseudoVLSSEG6E8_V_MF4,
  PseudoVLSSEG6E8_V_MF4_MASK,
  PseudoVLSSEG6E8_V_MF8,
  PseudoVLSSEG6E8_V_MF8_MASK,
  PseudoVLSSEG7E16_V_M1,
  PseudoVLSSEG7E16_V_M1_MASK,
  PseudoVLSSEG7E16_V_MF2,
  PseudoVLSSEG7E16_V_MF2_MASK,
  PseudoVLSSEG7E16_V_MF4,
  PseudoVLSSEG7E16_V_MF4_MASK,
  PseudoVLSSEG7E32_V_M1,
  PseudoVLSSEG7E32_V_M1_MASK,
  PseudoVLSSEG7E32_V_MF2,
  PseudoVLSSEG7E32_V_MF2_MASK,
  PseudoVLSSEG7E64_V_M1,
  PseudoVLSSEG7E64_V_M1_MASK,
  PseudoVLSSEG7E8_V_M1,
  PseudoVLSSEG7E8_V_M1_MASK,
  PseudoVLSSEG7E8_V_MF2,
  PseudoVLSSEG7E8_V_MF2_MASK,
  PseudoVLSSEG7E8_V_MF4,
  PseudoVLSSEG7E8_V_MF4_MASK,
  PseudoVLSSEG7E8_V_MF8,
  PseudoVLSSEG7E8_V_MF8_MASK,
  PseudoVLSSEG8E16_V_M1,
  PseudoVLSSEG8E16_V_M1_MASK,
  PseudoVLSSEG8E16_V_MF2,
  PseudoVLSSEG8E16_V_MF2_MASK,
  PseudoVLSSEG8E16_V_MF4,
  PseudoVLSSEG8E16_V_MF4_MASK,
  PseudoVLSSEG8E32_V_M1,
  PseudoVLSSEG8E32_V_M1_MASK,
  PseudoVLSSEG8E32_V_MF2,
  PseudoVLSSEG8E32_V_MF2_MASK,
  PseudoVLSSEG8E64_V_M1,
  PseudoVLSSEG8E64_V_M1_MASK,
  PseudoVLSSEG8E8_V_M1,
  PseudoVLSSEG8E8_V_M1_MASK,
  PseudoVLSSEG8E8_V_MF2,
  PseudoVLSSEG8E8_V_MF2_MASK,
  PseudoVLSSEG8E8_V_MF4,
  PseudoVLSSEG8E8_V_MF4_MASK,
  PseudoVLSSEG8E8_V_MF8,
  PseudoVLSSEG8E8_V_MF8_MASK,
  PseudoVLUXEI16_V_M1_M1,
  PseudoVLUXEI16_V_M1_M1_MASK,
  PseudoVLUXEI16_V_M1_M2,
  PseudoVLUXEI16_V_M1_M2_MASK,
  PseudoVLUXEI16_V_M1_M4,
  PseudoVLUXEI16_V_M1_M4_MASK,
  PseudoVLUXEI16_V_M1_MF2,
  PseudoVLUXEI16_V_M1_MF2_MASK,
  PseudoVLUXEI16_V_M2_M1,
  PseudoVLUXEI16_V_M2_M1_MASK,
  PseudoVLUXEI16_V_M2_M2,
  PseudoVLUXEI16_V_M2_M2_MASK,
  PseudoVLUXEI16_V_M2_M4,
  PseudoVLUXEI16_V_M2_M4_MASK,
  PseudoVLUXEI16_V_M2_M8,
  PseudoVLUXEI16_V_M2_M8_MASK,
  PseudoVLUXEI16_V_M4_M2,
  PseudoVLUXEI16_V_M4_M2_MASK,
  PseudoVLUXEI16_V_M4_M4,
  PseudoVLUXEI16_V_M4_M4_MASK,
  PseudoVLUXEI16_V_M4_M8,
  PseudoVLUXEI16_V_M4_M8_MASK,
  PseudoVLUXEI16_V_M8_M4,
  PseudoVLUXEI16_V_M8_M4_MASK,
  PseudoVLUXEI16_V_M8_M8,
  PseudoVLUXEI16_V_M8_M8_MASK,
  PseudoVLUXEI16_V_MF2_M1,
  PseudoVLUXEI16_V_MF2_M1_MASK,
  PseudoVLUXEI16_V_MF2_M2,
  PseudoVLUXEI16_V_MF2_M2_MASK,
  PseudoVLUXEI16_V_MF2_MF2,
  PseudoVLUXEI16_V_MF2_MF2_MASK,
  PseudoVLUXEI16_V_MF2_MF4,
  PseudoVLUXEI16_V_MF2_MF4_MASK,
  PseudoVLUXEI16_V_MF4_M1,
  PseudoVLUXEI16_V_MF4_M1_MASK,
  PseudoVLUXEI16_V_MF4_MF2,
  PseudoVLUXEI16_V_MF4_MF2_MASK,
  PseudoVLUXEI16_V_MF4_MF4,
  PseudoVLUXEI16_V_MF4_MF4_MASK,
  PseudoVLUXEI16_V_MF4_MF8,
  PseudoVLUXEI16_V_MF4_MF8_MASK,
  PseudoVLUXEI32_V_M1_M1,
  PseudoVLUXEI32_V_M1_M1_MASK,
  PseudoVLUXEI32_V_M1_M2,
  PseudoVLUXEI32_V_M1_M2_MASK,
  PseudoVLUXEI32_V_M1_MF2,
  PseudoVLUXEI32_V_M1_MF2_MASK,
  PseudoVLUXEI32_V_M1_MF4,
  PseudoVLUXEI32_V_M1_MF4_MASK,
  PseudoVLUXEI32_V_M2_M1,
  PseudoVLUXEI32_V_M2_M1_MASK,
  PseudoVLUXEI32_V_M2_M2,
  PseudoVLUXEI32_V_M2_M2_MASK,
  PseudoVLUXEI32_V_M2_M4,
  PseudoVLUXEI32_V_M2_M4_MASK,
  PseudoVLUXEI32_V_M2_MF2,
  PseudoVLUXEI32_V_M2_MF2_MASK,
  PseudoVLUXEI32_V_M4_M1,
  PseudoVLUXEI32_V_M4_M1_MASK,
  PseudoVLUXEI32_V_M4_M2,
  PseudoVLUXEI32_V_M4_M2_MASK,
  PseudoVLUXEI32_V_M4_M4,
  PseudoVLUXEI32_V_M4_M4_MASK,
  PseudoVLUXEI32_V_M4_M8,
  PseudoVLUXEI32_V_M4_M8_MASK,
  PseudoVLUXEI32_V_M8_M2,
  PseudoVLUXEI32_V_M8_M2_MASK,
  PseudoVLUXEI32_V_M8_M4,
  PseudoVLUXEI32_V_M8_M4_MASK,
  PseudoVLUXEI32_V_M8_M8,
  PseudoVLUXEI32_V_M8_M8_MASK,
  PseudoVLUXEI32_V_MF2_M1,
  PseudoVLUXEI32_V_MF2_M1_MASK,
  PseudoVLUXEI32_V_MF2_MF2,
  PseudoVLUXEI32_V_MF2_MF2_MASK,
  PseudoVLUXEI32_V_MF2_MF4,
  PseudoVLUXEI32_V_MF2_MF4_MASK,
  PseudoVLUXEI32_V_MF2_MF8,
  PseudoVLUXEI32_V_MF2_MF8_MASK,
  PseudoVLUXEI64_V_M1_M1,
  PseudoVLUXEI64_V_M1_M1_MASK,
  PseudoVLUXEI64_V_M1_MF2,
  PseudoVLUXEI64_V_M1_MF2_MASK,
  PseudoVLUXEI64_V_M1_MF4,
  PseudoVLUXEI64_V_M1_MF4_MASK,
  PseudoVLUXEI64_V_M1_MF8,
  PseudoVLUXEI64_V_M1_MF8_MASK,
  PseudoVLUXEI64_V_M2_M1,
  PseudoVLUXEI64_V_M2_M1_MASK,
  PseudoVLUXEI64_V_M2_M2,
  PseudoVLUXEI64_V_M2_M2_MASK,
  PseudoVLUXEI64_V_M2_MF2,
  PseudoVLUXEI64_V_M2_MF2_MASK,
  PseudoVLUXEI64_V_M2_MF4,
  PseudoVLUXEI64_V_M2_MF4_MASK,
  PseudoVLUXEI64_V_M4_M1,
  PseudoVLUXEI64_V_M4_M1_MASK,
  PseudoVLUXEI64_V_M4_M2,
  PseudoVLUXEI64_V_M4_M2_MASK,
  PseudoVLUXEI64_V_M4_M4,
  PseudoVLUXEI64_V_M4_M4_MASK,
  PseudoVLUXEI64_V_M4_MF2,
  PseudoVLUXEI64_V_M4_MF2_MASK,
  PseudoVLUXEI64_V_M8_M1,
  PseudoVLUXEI64_V_M8_M1_MASK,
  PseudoVLUXEI64_V_M8_M2,
  PseudoVLUXEI64_V_M8_M2_MASK,
  PseudoVLUXEI64_V_M8_M4,
  PseudoVLUXEI64_V_M8_M4_MASK,
  PseudoVLUXEI64_V_M8_M8,
  PseudoVLUXEI64_V_M8_M8_MASK,
  PseudoVLUXEI8_V_M1_M1,
  PseudoVLUXEI8_V_M1_M1_MASK,
  PseudoVLUXEI8_V_M1_M2,
  PseudoVLUXEI8_V_M1_M2_MASK,
  PseudoVLUXEI8_V_M1_M4,
  PseudoVLUXEI8_V_M1_M4_MASK,
  PseudoVLUXEI8_V_M1_M8,
  PseudoVLUXEI8_V_M1_M8_MASK,
  PseudoVLUXEI8_V_M2_M2,
  PseudoVLUXEI8_V_M2_M2_MASK,
  PseudoVLUXEI8_V_M2_M4,
  PseudoVLUXEI8_V_M2_M4_MASK,
  PseudoVLUXEI8_V_M2_M8,
  PseudoVLUXEI8_V_M2_M8_MASK,
  PseudoVLUXEI8_V_M4_M4,
  PseudoVLUXEI8_V_M4_M4_MASK,
  PseudoVLUXEI8_V_M4_M8,
  PseudoVLUXEI8_V_M4_M8_MASK,
  PseudoVLUXEI8_V_M8_M8,
  PseudoVLUXEI8_V_M8_M8_MASK,
  PseudoVLUXEI8_V_MF2_M1,
  PseudoVLUXEI8_V_MF2_M1_MASK,
  PseudoVLUXEI8_V_MF2_M2,
  PseudoVLUXEI8_V_MF2_M2_MASK,
  PseudoVLUXEI8_V_MF2_M4,
  PseudoVLUXEI8_V_MF2_M4_MASK,
  PseudoVLUXEI8_V_MF2_MF2,
  PseudoVLUXEI8_V_MF2_MF2_MASK,
  PseudoVLUXEI8_V_MF4_M1,
  PseudoVLUXEI8_V_MF4_M1_MASK,
  PseudoVLUXEI8_V_MF4_M2,
  PseudoVLUXEI8_V_MF4_M2_MASK,
  PseudoVLUXEI8_V_MF4_MF2,
  PseudoVLUXEI8_V_MF4_MF2_MASK,
  PseudoVLUXEI8_V_MF4_MF4,
  PseudoVLUXEI8_V_MF4_MF4_MASK,
  PseudoVLUXEI8_V_MF8_M1,
  PseudoVLUXEI8_V_MF8_M1_MASK,
  PseudoVLUXEI8_V_MF8_MF2,
  PseudoVLUXEI8_V_MF8_MF2_MASK,
  PseudoVLUXEI8_V_MF8_MF4,
  PseudoVLUXEI8_V_MF8_MF4_MASK,
  PseudoVLUXEI8_V_MF8_MF8,
  PseudoVLUXEI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG2EI16_V_M1_M1,
  PseudoVLUXSEG2EI16_V_M1_M1_MASK,
  PseudoVLUXSEG2EI16_V_M1_M2,
  PseudoVLUXSEG2EI16_V_M1_M2_MASK,
  PseudoVLUXSEG2EI16_V_M1_M4,
  PseudoVLUXSEG2EI16_V_M1_M4_MASK,
  PseudoVLUXSEG2EI16_V_M1_MF2,
  PseudoVLUXSEG2EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG2EI16_V_M2_M1,
  PseudoVLUXSEG2EI16_V_M2_M1_MASK,
  PseudoVLUXSEG2EI16_V_M2_M2,
  PseudoVLUXSEG2EI16_V_M2_M2_MASK,
  PseudoVLUXSEG2EI16_V_M2_M4,
  PseudoVLUXSEG2EI16_V_M2_M4_MASK,
  PseudoVLUXSEG2EI16_V_M4_M2,
  PseudoVLUXSEG2EI16_V_M4_M2_MASK,
  PseudoVLUXSEG2EI16_V_M4_M4,
  PseudoVLUXSEG2EI16_V_M4_M4_MASK,
  PseudoVLUXSEG2EI16_V_M8_M4,
  PseudoVLUXSEG2EI16_V_M8_M4_MASK,
  PseudoVLUXSEG2EI16_V_MF2_M1,
  PseudoVLUXSEG2EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG2EI16_V_MF2_M2,
  PseudoVLUXSEG2EI16_V_MF2_M2_MASK,
  PseudoVLUXSEG2EI16_V_MF2_MF2,
  PseudoVLUXSEG2EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG2EI16_V_MF2_MF4,
  PseudoVLUXSEG2EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG2EI16_V_MF4_M1,
  PseudoVLUXSEG2EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG2EI16_V_MF4_MF2,
  PseudoVLUXSEG2EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG2EI16_V_MF4_MF4,
  PseudoVLUXSEG2EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG2EI16_V_MF4_MF8,
  PseudoVLUXSEG2EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG2EI32_V_M1_M1,
  PseudoVLUXSEG2EI32_V_M1_M1_MASK,
  PseudoVLUXSEG2EI32_V_M1_M2,
  PseudoVLUXSEG2EI32_V_M1_M2_MASK,
  PseudoVLUXSEG2EI32_V_M1_MF2,
  PseudoVLUXSEG2EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG2EI32_V_M1_MF4,
  PseudoVLUXSEG2EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG2EI32_V_M2_M1,
  PseudoVLUXSEG2EI32_V_M2_M1_MASK,
  PseudoVLUXSEG2EI32_V_M2_M2,
  PseudoVLUXSEG2EI32_V_M2_M2_MASK,
  PseudoVLUXSEG2EI32_V_M2_M4,
  PseudoVLUXSEG2EI32_V_M2_M4_MASK,
  PseudoVLUXSEG2EI32_V_M2_MF2,
  PseudoVLUXSEG2EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG2EI32_V_M4_M1,
  PseudoVLUXSEG2EI32_V_M4_M1_MASK,
  PseudoVLUXSEG2EI32_V_M4_M2,
  PseudoVLUXSEG2EI32_V_M4_M2_MASK,
  PseudoVLUXSEG2EI32_V_M4_M4,
  PseudoVLUXSEG2EI32_V_M4_M4_MASK,
  PseudoVLUXSEG2EI32_V_M8_M2,
  PseudoVLUXSEG2EI32_V_M8_M2_MASK,
  PseudoVLUXSEG2EI32_V_M8_M4,
  PseudoVLUXSEG2EI32_V_M8_M4_MASK,
  PseudoVLUXSEG2EI32_V_MF2_M1,
  PseudoVLUXSEG2EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG2EI32_V_MF2_MF2,
  PseudoVLUXSEG2EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG2EI32_V_MF2_MF4,
  PseudoVLUXSEG2EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG2EI32_V_MF2_MF8,
  PseudoVLUXSEG2EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG2EI64_V_M1_M1,
  PseudoVLUXSEG2EI64_V_M1_M1_MASK,
  PseudoVLUXSEG2EI64_V_M1_MF2,
  PseudoVLUXSEG2EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG2EI64_V_M1_MF4,
  PseudoVLUXSEG2EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG2EI64_V_M1_MF8,
  PseudoVLUXSEG2EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG2EI64_V_M2_M1,
  PseudoVLUXSEG2EI64_V_M2_M1_MASK,
  PseudoVLUXSEG2EI64_V_M2_M2,
  PseudoVLUXSEG2EI64_V_M2_M2_MASK,
  PseudoVLUXSEG2EI64_V_M2_MF2,
  PseudoVLUXSEG2EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG2EI64_V_M2_MF4,
  PseudoVLUXSEG2EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG2EI64_V_M4_M1,
  PseudoVLUXSEG2EI64_V_M4_M1_MASK,
  PseudoVLUXSEG2EI64_V_M4_M2,
  PseudoVLUXSEG2EI64_V_M4_M2_MASK,
  PseudoVLUXSEG2EI64_V_M4_M4,
  PseudoVLUXSEG2EI64_V_M4_M4_MASK,
  PseudoVLUXSEG2EI64_V_M4_MF2,
  PseudoVLUXSEG2EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG2EI64_V_M8_M1,
  PseudoVLUXSEG2EI64_V_M8_M1_MASK,
  PseudoVLUXSEG2EI64_V_M8_M2,
  PseudoVLUXSEG2EI64_V_M8_M2_MASK,
  PseudoVLUXSEG2EI64_V_M8_M4,
  PseudoVLUXSEG2EI64_V_M8_M4_MASK,
  PseudoVLUXSEG2EI8_V_M1_M1,
  PseudoVLUXSEG2EI8_V_M1_M1_MASK,
  PseudoVLUXSEG2EI8_V_M1_M2,
  PseudoVLUXSEG2EI8_V_M1_M2_MASK,
  PseudoVLUXSEG2EI8_V_M1_M4,
  PseudoVLUXSEG2EI8_V_M1_M4_MASK,
  PseudoVLUXSEG2EI8_V_M2_M2,
  PseudoVLUXSEG2EI8_V_M2_M2_MASK,
  PseudoVLUXSEG2EI8_V_M2_M4,
  PseudoVLUXSEG2EI8_V_M2_M4_MASK,
  PseudoVLUXSEG2EI8_V_M4_M4,
  PseudoVLUXSEG2EI8_V_M4_M4_MASK,
  PseudoVLUXSEG2EI8_V_MF2_M1,
  PseudoVLUXSEG2EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG2EI8_V_MF2_M2,
  PseudoVLUXSEG2EI8_V_MF2_M2_MASK,
  PseudoVLUXSEG2EI8_V_MF2_M4,
  PseudoVLUXSEG2EI8_V_MF2_M4_MASK,
  PseudoVLUXSEG2EI8_V_MF2_MF2,
  PseudoVLUXSEG2EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG2EI8_V_MF4_M1,
  PseudoVLUXSEG2EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG2EI8_V_MF4_M2,
  PseudoVLUXSEG2EI8_V_MF4_M2_MASK,
  PseudoVLUXSEG2EI8_V_MF4_MF2,
  PseudoVLUXSEG2EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG2EI8_V_MF4_MF4,
  PseudoVLUXSEG2EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG2EI8_V_MF8_M1,
  PseudoVLUXSEG2EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG2EI8_V_MF8_MF2,
  PseudoVLUXSEG2EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG2EI8_V_MF8_MF4,
  PseudoVLUXSEG2EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG2EI8_V_MF8_MF8,
  PseudoVLUXSEG2EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG3EI16_V_M1_M1,
  PseudoVLUXSEG3EI16_V_M1_M1_MASK,
  PseudoVLUXSEG3EI16_V_M1_M2,
  PseudoVLUXSEG3EI16_V_M1_M2_MASK,
  PseudoVLUXSEG3EI16_V_M1_MF2,
  PseudoVLUXSEG3EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG3EI16_V_M2_M1,
  PseudoVLUXSEG3EI16_V_M2_M1_MASK,
  PseudoVLUXSEG3EI16_V_M2_M2,
  PseudoVLUXSEG3EI16_V_M2_M2_MASK,
  PseudoVLUXSEG3EI16_V_M4_M2,
  PseudoVLUXSEG3EI16_V_M4_M2_MASK,
  PseudoVLUXSEG3EI16_V_MF2_M1,
  PseudoVLUXSEG3EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG3EI16_V_MF2_M2,
  PseudoVLUXSEG3EI16_V_MF2_M2_MASK,
  PseudoVLUXSEG3EI16_V_MF2_MF2,
  PseudoVLUXSEG3EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG3EI16_V_MF2_MF4,
  PseudoVLUXSEG3EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG3EI16_V_MF4_M1,
  PseudoVLUXSEG3EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG3EI16_V_MF4_MF2,
  PseudoVLUXSEG3EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG3EI16_V_MF4_MF4,
  PseudoVLUXSEG3EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG3EI16_V_MF4_MF8,
  PseudoVLUXSEG3EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG3EI32_V_M1_M1,
  PseudoVLUXSEG3EI32_V_M1_M1_MASK,
  PseudoVLUXSEG3EI32_V_M1_M2,
  PseudoVLUXSEG3EI32_V_M1_M2_MASK,
  PseudoVLUXSEG3EI32_V_M1_MF2,
  PseudoVLUXSEG3EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG3EI32_V_M1_MF4,
  PseudoVLUXSEG3EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG3EI32_V_M2_M1,
  PseudoVLUXSEG3EI32_V_M2_M1_MASK,
  PseudoVLUXSEG3EI32_V_M2_M2,
  PseudoVLUXSEG3EI32_V_M2_M2_MASK,
  PseudoVLUXSEG3EI32_V_M2_MF2,
  PseudoVLUXSEG3EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG3EI32_V_M4_M1,
  PseudoVLUXSEG3EI32_V_M4_M1_MASK,
  PseudoVLUXSEG3EI32_V_M4_M2,
  PseudoVLUXSEG3EI32_V_M4_M2_MASK,
  PseudoVLUXSEG3EI32_V_M8_M2,
  PseudoVLUXSEG3EI32_V_M8_M2_MASK,
  PseudoVLUXSEG3EI32_V_MF2_M1,
  PseudoVLUXSEG3EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG3EI32_V_MF2_MF2,
  PseudoVLUXSEG3EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG3EI32_V_MF2_MF4,
  PseudoVLUXSEG3EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG3EI32_V_MF2_MF8,
  PseudoVLUXSEG3EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG3EI64_V_M1_M1,
  PseudoVLUXSEG3EI64_V_M1_M1_MASK,
  PseudoVLUXSEG3EI64_V_M1_MF2,
  PseudoVLUXSEG3EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG3EI64_V_M1_MF4,
  PseudoVLUXSEG3EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG3EI64_V_M1_MF8,
  PseudoVLUXSEG3EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG3EI64_V_M2_M1,
  PseudoVLUXSEG3EI64_V_M2_M1_MASK,
  PseudoVLUXSEG3EI64_V_M2_M2,
  PseudoVLUXSEG3EI64_V_M2_M2_MASK,
  PseudoVLUXSEG3EI64_V_M2_MF2,
  PseudoVLUXSEG3EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG3EI64_V_M2_MF4,
  PseudoVLUXSEG3EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG3EI64_V_M4_M1,
  PseudoVLUXSEG3EI64_V_M4_M1_MASK,
  PseudoVLUXSEG3EI64_V_M4_M2,
  PseudoVLUXSEG3EI64_V_M4_M2_MASK,
  PseudoVLUXSEG3EI64_V_M4_MF2,
  PseudoVLUXSEG3EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG3EI64_V_M8_M1,
  PseudoVLUXSEG3EI64_V_M8_M1_MASK,
  PseudoVLUXSEG3EI64_V_M8_M2,
  PseudoVLUXSEG3EI64_V_M8_M2_MASK,
  PseudoVLUXSEG3EI8_V_M1_M1,
  PseudoVLUXSEG3EI8_V_M1_M1_MASK,
  PseudoVLUXSEG3EI8_V_M1_M2,
  PseudoVLUXSEG3EI8_V_M1_M2_MASK,
  PseudoVLUXSEG3EI8_V_M2_M2,
  PseudoVLUXSEG3EI8_V_M2_M2_MASK,
  PseudoVLUXSEG3EI8_V_MF2_M1,
  PseudoVLUXSEG3EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG3EI8_V_MF2_M2,
  PseudoVLUXSEG3EI8_V_MF2_M2_MASK,
  PseudoVLUXSEG3EI8_V_MF2_MF2,
  PseudoVLUXSEG3EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG3EI8_V_MF4_M1,
  PseudoVLUXSEG3EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG3EI8_V_MF4_M2,
  PseudoVLUXSEG3EI8_V_MF4_M2_MASK,
  PseudoVLUXSEG3EI8_V_MF4_MF2,
  PseudoVLUXSEG3EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG3EI8_V_MF4_MF4,
  PseudoVLUXSEG3EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG3EI8_V_MF8_M1,
  PseudoVLUXSEG3EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG3EI8_V_MF8_MF2,
  PseudoVLUXSEG3EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG3EI8_V_MF8_MF4,
  PseudoVLUXSEG3EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG3EI8_V_MF8_MF8,
  PseudoVLUXSEG3EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG4EI16_V_M1_M1,
  PseudoVLUXSEG4EI16_V_M1_M1_MASK,
  PseudoVLUXSEG4EI16_V_M1_M2,
  PseudoVLUXSEG4EI16_V_M1_M2_MASK,
  PseudoVLUXSEG4EI16_V_M1_MF2,
  PseudoVLUXSEG4EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG4EI16_V_M2_M1,
  PseudoVLUXSEG4EI16_V_M2_M1_MASK,
  PseudoVLUXSEG4EI16_V_M2_M2,
  PseudoVLUXSEG4EI16_V_M2_M2_MASK,
  PseudoVLUXSEG4EI16_V_M4_M2,
  PseudoVLUXSEG4EI16_V_M4_M2_MASK,
  PseudoVLUXSEG4EI16_V_MF2_M1,
  PseudoVLUXSEG4EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG4EI16_V_MF2_M2,
  PseudoVLUXSEG4EI16_V_MF2_M2_MASK,
  PseudoVLUXSEG4EI16_V_MF2_MF2,
  PseudoVLUXSEG4EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG4EI16_V_MF2_MF4,
  PseudoVLUXSEG4EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG4EI16_V_MF4_M1,
  PseudoVLUXSEG4EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG4EI16_V_MF4_MF2,
  PseudoVLUXSEG4EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG4EI16_V_MF4_MF4,
  PseudoVLUXSEG4EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG4EI16_V_MF4_MF8,
  PseudoVLUXSEG4EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG4EI32_V_M1_M1,
  PseudoVLUXSEG4EI32_V_M1_M1_MASK,
  PseudoVLUXSEG4EI32_V_M1_M2,
  PseudoVLUXSEG4EI32_V_M1_M2_MASK,
  PseudoVLUXSEG4EI32_V_M1_MF2,
  PseudoVLUXSEG4EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG4EI32_V_M1_MF4,
  PseudoVLUXSEG4EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG4EI32_V_M2_M1,
  PseudoVLUXSEG4EI32_V_M2_M1_MASK,
  PseudoVLUXSEG4EI32_V_M2_M2,
  PseudoVLUXSEG4EI32_V_M2_M2_MASK,
  PseudoVLUXSEG4EI32_V_M2_MF2,
  PseudoVLUXSEG4EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG4EI32_V_M4_M1,
  PseudoVLUXSEG4EI32_V_M4_M1_MASK,
  PseudoVLUXSEG4EI32_V_M4_M2,
  PseudoVLUXSEG4EI32_V_M4_M2_MASK,
  PseudoVLUXSEG4EI32_V_M8_M2,
  PseudoVLUXSEG4EI32_V_M8_M2_MASK,
  PseudoVLUXSEG4EI32_V_MF2_M1,
  PseudoVLUXSEG4EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG4EI32_V_MF2_MF2,
  PseudoVLUXSEG4EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG4EI32_V_MF2_MF4,
  PseudoVLUXSEG4EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG4EI32_V_MF2_MF8,
  PseudoVLUXSEG4EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG4EI64_V_M1_M1,
  PseudoVLUXSEG4EI64_V_M1_M1_MASK,
  PseudoVLUXSEG4EI64_V_M1_MF2,
  PseudoVLUXSEG4EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG4EI64_V_M1_MF4,
  PseudoVLUXSEG4EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG4EI64_V_M1_MF8,
  PseudoVLUXSEG4EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG4EI64_V_M2_M1,
  PseudoVLUXSEG4EI64_V_M2_M1_MASK,
  PseudoVLUXSEG4EI64_V_M2_M2,
  PseudoVLUXSEG4EI64_V_M2_M2_MASK,
  PseudoVLUXSEG4EI64_V_M2_MF2,
  PseudoVLUXSEG4EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG4EI64_V_M2_MF4,
  PseudoVLUXSEG4EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG4EI64_V_M4_M1,
  PseudoVLUXSEG4EI64_V_M4_M1_MASK,
  PseudoVLUXSEG4EI64_V_M4_M2,
  PseudoVLUXSEG4EI64_V_M4_M2_MASK,
  PseudoVLUXSEG4EI64_V_M4_MF2,
  PseudoVLUXSEG4EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG4EI64_V_M8_M1,
  PseudoVLUXSEG4EI64_V_M8_M1_MASK,
  PseudoVLUXSEG4EI64_V_M8_M2,
  PseudoVLUXSEG4EI64_V_M8_M2_MASK,
  PseudoVLUXSEG4EI8_V_M1_M1,
  PseudoVLUXSEG4EI8_V_M1_M1_MASK,
  PseudoVLUXSEG4EI8_V_M1_M2,
  PseudoVLUXSEG4EI8_V_M1_M2_MASK,
  PseudoVLUXSEG4EI8_V_M2_M2,
  PseudoVLUXSEG4EI8_V_M2_M2_MASK,
  PseudoVLUXSEG4EI8_V_MF2_M1,
  PseudoVLUXSEG4EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG4EI8_V_MF2_M2,
  PseudoVLUXSEG4EI8_V_MF2_M2_MASK,
  PseudoVLUXSEG4EI8_V_MF2_MF2,
  PseudoVLUXSEG4EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG4EI8_V_MF4_M1,
  PseudoVLUXSEG4EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG4EI8_V_MF4_M2,
  PseudoVLUXSEG4EI8_V_MF4_M2_MASK,
  PseudoVLUXSEG4EI8_V_MF4_MF2,
  PseudoVLUXSEG4EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG4EI8_V_MF4_MF4,
  PseudoVLUXSEG4EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG4EI8_V_MF8_M1,
  PseudoVLUXSEG4EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG4EI8_V_MF8_MF2,
  PseudoVLUXSEG4EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG4EI8_V_MF8_MF4,
  PseudoVLUXSEG4EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG4EI8_V_MF8_MF8,
  PseudoVLUXSEG4EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG5EI16_V_M1_M1,
  PseudoVLUXSEG5EI16_V_M1_M1_MASK,
  PseudoVLUXSEG5EI16_V_M1_MF2,
  PseudoVLUXSEG5EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG5EI16_V_M2_M1,
  PseudoVLUXSEG5EI16_V_M2_M1_MASK,
  PseudoVLUXSEG5EI16_V_MF2_M1,
  PseudoVLUXSEG5EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG5EI16_V_MF2_MF2,
  PseudoVLUXSEG5EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG5EI16_V_MF2_MF4,
  PseudoVLUXSEG5EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG5EI16_V_MF4_M1,
  PseudoVLUXSEG5EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG5EI16_V_MF4_MF2,
  PseudoVLUXSEG5EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG5EI16_V_MF4_MF4,
  PseudoVLUXSEG5EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG5EI16_V_MF4_MF8,
  PseudoVLUXSEG5EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG5EI32_V_M1_M1,
  PseudoVLUXSEG5EI32_V_M1_M1_MASK,
  PseudoVLUXSEG5EI32_V_M1_MF2,
  PseudoVLUXSEG5EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG5EI32_V_M1_MF4,
  PseudoVLUXSEG5EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG5EI32_V_M2_M1,
  PseudoVLUXSEG5EI32_V_M2_M1_MASK,
  PseudoVLUXSEG5EI32_V_M2_MF2,
  PseudoVLUXSEG5EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG5EI32_V_M4_M1,
  PseudoVLUXSEG5EI32_V_M4_M1_MASK,
  PseudoVLUXSEG5EI32_V_MF2_M1,
  PseudoVLUXSEG5EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG5EI32_V_MF2_MF2,
  PseudoVLUXSEG5EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG5EI32_V_MF2_MF4,
  PseudoVLUXSEG5EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG5EI32_V_MF2_MF8,
  PseudoVLUXSEG5EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG5EI64_V_M1_M1,
  PseudoVLUXSEG5EI64_V_M1_M1_MASK,
  PseudoVLUXSEG5EI64_V_M1_MF2,
  PseudoVLUXSEG5EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG5EI64_V_M1_MF4,
  PseudoVLUXSEG5EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG5EI64_V_M1_MF8,
  PseudoVLUXSEG5EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG5EI64_V_M2_M1,
  PseudoVLUXSEG5EI64_V_M2_M1_MASK,
  PseudoVLUXSEG5EI64_V_M2_MF2,
  PseudoVLUXSEG5EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG5EI64_V_M2_MF4,
  PseudoVLUXSEG5EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG5EI64_V_M4_M1,
  PseudoVLUXSEG5EI64_V_M4_M1_MASK,
  PseudoVLUXSEG5EI64_V_M4_MF2,
  PseudoVLUXSEG5EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG5EI64_V_M8_M1,
  PseudoVLUXSEG5EI64_V_M8_M1_MASK,
  PseudoVLUXSEG5EI8_V_M1_M1,
  PseudoVLUXSEG5EI8_V_M1_M1_MASK,
  PseudoVLUXSEG5EI8_V_MF2_M1,
  PseudoVLUXSEG5EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG5EI8_V_MF2_MF2,
  PseudoVLUXSEG5EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG5EI8_V_MF4_M1,
  PseudoVLUXSEG5EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG5EI8_V_MF4_MF2,
  PseudoVLUXSEG5EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG5EI8_V_MF4_MF4,
  PseudoVLUXSEG5EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG5EI8_V_MF8_M1,
  PseudoVLUXSEG5EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG5EI8_V_MF8_MF2,
  PseudoVLUXSEG5EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG5EI8_V_MF8_MF4,
  PseudoVLUXSEG5EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG5EI8_V_MF8_MF8,
  PseudoVLUXSEG5EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG6EI16_V_M1_M1,
  PseudoVLUXSEG6EI16_V_M1_M1_MASK,
  PseudoVLUXSEG6EI16_V_M1_MF2,
  PseudoVLUXSEG6EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG6EI16_V_M2_M1,
  PseudoVLUXSEG6EI16_V_M2_M1_MASK,
  PseudoVLUXSEG6EI16_V_MF2_M1,
  PseudoVLUXSEG6EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG6EI16_V_MF2_MF2,
  PseudoVLUXSEG6EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG6EI16_V_MF2_MF4,
  PseudoVLUXSEG6EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG6EI16_V_MF4_M1,
  PseudoVLUXSEG6EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG6EI16_V_MF4_MF2,
  PseudoVLUXSEG6EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG6EI16_V_MF4_MF4,
  PseudoVLUXSEG6EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG6EI16_V_MF4_MF8,
  PseudoVLUXSEG6EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG6EI32_V_M1_M1,
  PseudoVLUXSEG6EI32_V_M1_M1_MASK,
  PseudoVLUXSEG6EI32_V_M1_MF2,
  PseudoVLUXSEG6EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG6EI32_V_M1_MF4,
  PseudoVLUXSEG6EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG6EI32_V_M2_M1,
  PseudoVLUXSEG6EI32_V_M2_M1_MASK,
  PseudoVLUXSEG6EI32_V_M2_MF2,
  PseudoVLUXSEG6EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG6EI32_V_M4_M1,
  PseudoVLUXSEG6EI32_V_M4_M1_MASK,
  PseudoVLUXSEG6EI32_V_MF2_M1,
  PseudoVLUXSEG6EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG6EI32_V_MF2_MF2,
  PseudoVLUXSEG6EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG6EI32_V_MF2_MF4,
  PseudoVLUXSEG6EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG6EI32_V_MF2_MF8,
  PseudoVLUXSEG6EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG6EI64_V_M1_M1,
  PseudoVLUXSEG6EI64_V_M1_M1_MASK,
  PseudoVLUXSEG6EI64_V_M1_MF2,
  PseudoVLUXSEG6EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG6EI64_V_M1_MF4,
  PseudoVLUXSEG6EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG6EI64_V_M1_MF8,
  PseudoVLUXSEG6EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG6EI64_V_M2_M1,
  PseudoVLUXSEG6EI64_V_M2_M1_MASK,
  PseudoVLUXSEG6EI64_V_M2_MF2,
  PseudoVLUXSEG6EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG6EI64_V_M2_MF4,
  PseudoVLUXSEG6EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG6EI64_V_M4_M1,
  PseudoVLUXSEG6EI64_V_M4_M1_MASK,
  PseudoVLUXSEG6EI64_V_M4_MF2,
  PseudoVLUXSEG6EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG6EI64_V_M8_M1,
  PseudoVLUXSEG6EI64_V_M8_M1_MASK,
  PseudoVLUXSEG6EI8_V_M1_M1,
  PseudoVLUXSEG6EI8_V_M1_M1_MASK,
  PseudoVLUXSEG6EI8_V_MF2_M1,
  PseudoVLUXSEG6EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG6EI8_V_MF2_MF2,
  PseudoVLUXSEG6EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG6EI8_V_MF4_M1,
  PseudoVLUXSEG6EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG6EI8_V_MF4_MF2,
  PseudoVLUXSEG6EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG6EI8_V_MF4_MF4,
  PseudoVLUXSEG6EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG6EI8_V_MF8_M1,
  PseudoVLUXSEG6EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG6EI8_V_MF8_MF2,
  PseudoVLUXSEG6EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG6EI8_V_MF8_MF4,
  PseudoVLUXSEG6EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG6EI8_V_MF8_MF8,
  PseudoVLUXSEG6EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG7EI16_V_M1_M1,
  PseudoVLUXSEG7EI16_V_M1_M1_MASK,
  PseudoVLUXSEG7EI16_V_M1_MF2,
  PseudoVLUXSEG7EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG7EI16_V_M2_M1,
  PseudoVLUXSEG7EI16_V_M2_M1_MASK,
  PseudoVLUXSEG7EI16_V_MF2_M1,
  PseudoVLUXSEG7EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG7EI16_V_MF2_MF2,
  PseudoVLUXSEG7EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG7EI16_V_MF2_MF4,
  PseudoVLUXSEG7EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG7EI16_V_MF4_M1,
  PseudoVLUXSEG7EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG7EI16_V_MF4_MF2,
  PseudoVLUXSEG7EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG7EI16_V_MF4_MF4,
  PseudoVLUXSEG7EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG7EI16_V_MF4_MF8,
  PseudoVLUXSEG7EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG7EI32_V_M1_M1,
  PseudoVLUXSEG7EI32_V_M1_M1_MASK,
  PseudoVLUXSEG7EI32_V_M1_MF2,
  PseudoVLUXSEG7EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG7EI32_V_M1_MF4,
  PseudoVLUXSEG7EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG7EI32_V_M2_M1,
  PseudoVLUXSEG7EI32_V_M2_M1_MASK,
  PseudoVLUXSEG7EI32_V_M2_MF2,
  PseudoVLUXSEG7EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG7EI32_V_M4_M1,
  PseudoVLUXSEG7EI32_V_M4_M1_MASK,
  PseudoVLUXSEG7EI32_V_MF2_M1,
  PseudoVLUXSEG7EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG7EI32_V_MF2_MF2,
  PseudoVLUXSEG7EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG7EI32_V_MF2_MF4,
  PseudoVLUXSEG7EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG7EI32_V_MF2_MF8,
  PseudoVLUXSEG7EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG7EI64_V_M1_M1,
  PseudoVLUXSEG7EI64_V_M1_M1_MASK,
  PseudoVLUXSEG7EI64_V_M1_MF2,
  PseudoVLUXSEG7EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG7EI64_V_M1_MF4,
  PseudoVLUXSEG7EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG7EI64_V_M1_MF8,
  PseudoVLUXSEG7EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG7EI64_V_M2_M1,
  PseudoVLUXSEG7EI64_V_M2_M1_MASK,
  PseudoVLUXSEG7EI64_V_M2_MF2,
  PseudoVLUXSEG7EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG7EI64_V_M2_MF4,
  PseudoVLUXSEG7EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG7EI64_V_M4_M1,
  PseudoVLUXSEG7EI64_V_M4_M1_MASK,
  PseudoVLUXSEG7EI64_V_M4_MF2,
  PseudoVLUXSEG7EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG7EI64_V_M8_M1,
  PseudoVLUXSEG7EI64_V_M8_M1_MASK,
  PseudoVLUXSEG7EI8_V_M1_M1,
  PseudoVLUXSEG7EI8_V_M1_M1_MASK,
  PseudoVLUXSEG7EI8_V_MF2_M1,
  PseudoVLUXSEG7EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG7EI8_V_MF2_MF2,
  PseudoVLUXSEG7EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG7EI8_V_MF4_M1,
  PseudoVLUXSEG7EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG7EI8_V_MF4_MF2,
  PseudoVLUXSEG7EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG7EI8_V_MF4_MF4,
  PseudoVLUXSEG7EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG7EI8_V_MF8_M1,
  PseudoVLUXSEG7EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG7EI8_V_MF8_MF2,
  PseudoVLUXSEG7EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG7EI8_V_MF8_MF4,
  PseudoVLUXSEG7EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG7EI8_V_MF8_MF8,
  PseudoVLUXSEG7EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG8EI16_V_M1_M1,
  PseudoVLUXSEG8EI16_V_M1_M1_MASK,
  PseudoVLUXSEG8EI16_V_M1_MF2,
  PseudoVLUXSEG8EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG8EI16_V_M2_M1,
  PseudoVLUXSEG8EI16_V_M2_M1_MASK,
  PseudoVLUXSEG8EI16_V_MF2_M1,
  PseudoVLUXSEG8EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG8EI16_V_MF2_MF2,
  PseudoVLUXSEG8EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG8EI16_V_MF2_MF4,
  PseudoVLUXSEG8EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG8EI16_V_MF4_M1,
  PseudoVLUXSEG8EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG8EI16_V_MF4_MF2,
  PseudoVLUXSEG8EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG8EI16_V_MF4_MF4,
  PseudoVLUXSEG8EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG8EI16_V_MF4_MF8,
  PseudoVLUXSEG8EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG8EI32_V_M1_M1,
  PseudoVLUXSEG8EI32_V_M1_M1_MASK,
  PseudoVLUXSEG8EI32_V_M1_MF2,
  PseudoVLUXSEG8EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG8EI32_V_M1_MF4,
  PseudoVLUXSEG8EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG8EI32_V_M2_M1,
  PseudoVLUXSEG8EI32_V_M2_M1_MASK,
  PseudoVLUXSEG8EI32_V_M2_MF2,
  PseudoVLUXSEG8EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG8EI32_V_M4_M1,
  PseudoVLUXSEG8EI32_V_M4_M1_MASK,
  PseudoVLUXSEG8EI32_V_MF2_M1,
  PseudoVLUXSEG8EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG8EI32_V_MF2_MF2,
  PseudoVLUXSEG8EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG8EI32_V_MF2_MF4,
  PseudoVLUXSEG8EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG8EI32_V_MF2_MF8,
  PseudoVLUXSEG8EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG8EI64_V_M1_M1,
  PseudoVLUXSEG8EI64_V_M1_M1_MASK,
  PseudoVLUXSEG8EI64_V_M1_MF2,
  PseudoVLUXSEG8EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG8EI64_V_M1_MF4,
  PseudoVLUXSEG8EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG8EI64_V_M1_MF8,
  PseudoVLUXSEG8EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG8EI64_V_M2_M1,
  PseudoVLUXSEG8EI64_V_M2_M1_MASK,
  PseudoVLUXSEG8EI64_V_M2_MF2,
  PseudoVLUXSEG8EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG8EI64_V_M2_MF4,
  PseudoVLUXSEG8EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG8EI64_V_M4_M1,
  PseudoVLUXSEG8EI64_V_M4_M1_MASK,
  PseudoVLUXSEG8EI64_V_M4_MF2,
  PseudoVLUXSEG8EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG8EI64_V_M8_M1,
  PseudoVLUXSEG8EI64_V_M8_M1_MASK,
  PseudoVLUXSEG8EI8_V_M1_M1,
  PseudoVLUXSEG8EI8_V_M1_M1_MASK,
  PseudoVLUXSEG8EI8_V_MF2_M1,
  PseudoVLUXSEG8EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG8EI8_V_MF2_MF2,
  PseudoVLUXSEG8EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG8EI8_V_MF4_M1,
  PseudoVLUXSEG8EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG8EI8_V_MF4_MF2,
  PseudoVLUXSEG8EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG8EI8_V_MF4_MF4,
  PseudoVLUXSEG8EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG8EI8_V_MF8_M1,
  PseudoVLUXSEG8EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG8EI8_V_MF8_MF2,
  PseudoVLUXSEG8EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG8EI8_V_MF8_MF4,
  PseudoVLUXSEG8EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG8EI8_V_MF8_MF8,
  PseudoVLUXSEG8EI8_V_MF8_MF8_MASK,
  PseudoVMACC_VV_M1,
  PseudoVMACC_VV_M1_MASK,
  PseudoVMACC_VV_M2,
  PseudoVMACC_VV_M2_MASK,
  PseudoVMACC_VV_M4,
  PseudoVMACC_VV_M4_MASK,
  PseudoVMACC_VV_M8,
  PseudoVMACC_VV_M8_MASK,
  PseudoVMACC_VV_MF2,
  PseudoVMACC_VV_MF2_MASK,
  PseudoVMACC_VV_MF4,
  PseudoVMACC_VV_MF4_MASK,
  PseudoVMACC_VV_MF8,
  PseudoVMACC_VV_MF8_MASK,
  PseudoVMACC_VX_M1,
  PseudoVMACC_VX_M1_MASK,
  PseudoVMACC_VX_M2,
  PseudoVMACC_VX_M2_MASK,
  PseudoVMACC_VX_M4,
  PseudoVMACC_VX_M4_MASK,
  PseudoVMACC_VX_M8,
  PseudoVMACC_VX_M8_MASK,
  PseudoVMACC_VX_MF2,
  PseudoVMACC_VX_MF2_MASK,
  PseudoVMACC_VX_MF4,
  PseudoVMACC_VX_MF4_MASK,
  PseudoVMACC_VX_MF8,
  PseudoVMACC_VX_MF8_MASK,
  PseudoVMADC_VIM_M1,
  PseudoVMADC_VIM_M2,
  PseudoVMADC_VIM_M4,
  PseudoVMADC_VIM_M8,
  PseudoVMADC_VIM_MF2,
  PseudoVMADC_VIM_MF4,
  PseudoVMADC_VIM_MF8,
  PseudoVMADC_VI_M1,
  PseudoVMADC_VI_M2,
  PseudoVMADC_VI_M4,
  PseudoVMADC_VI_M8,
  PseudoVMADC_VI_MF2,
  PseudoVMADC_VI_MF4,
  PseudoVMADC_VI_MF8,
  PseudoVMADC_VVM_M1,
  PseudoVMADC_VVM_M2,
  PseudoVMADC_VVM_M4,
  PseudoVMADC_VVM_M8,
  PseudoVMADC_VVM_MF2,
  PseudoVMADC_VVM_MF4,
  PseudoVMADC_VVM_MF8,
  PseudoVMADC_VV_M1,
  PseudoVMADC_VV_M2,
  PseudoVMADC_VV_M4,
  PseudoVMADC_VV_M8,
  PseudoVMADC_VV_MF2,
  PseudoVMADC_VV_MF4,
  PseudoVMADC_VV_MF8,
  PseudoVMADC_VXM_M1,
  PseudoVMADC_VXM_M2,
  PseudoVMADC_VXM_M4,
  PseudoVMADC_VXM_M8,
  PseudoVMADC_VXM_MF2,
  PseudoVMADC_VXM_MF4,
  PseudoVMADC_VXM_MF8,
  PseudoVMADC_VX_M1,
  PseudoVMADC_VX_M2,
  PseudoVMADC_VX_M4,
  PseudoVMADC_VX_M8,
  PseudoVMADC_VX_MF2,
  PseudoVMADC_VX_MF4,
  PseudoVMADC_VX_MF8,
  PseudoVMADD_VV_M1,
  PseudoVMADD_VV_M1_MASK,
  PseudoVMADD_VV_M2,
  PseudoVMADD_VV_M2_MASK,
  PseudoVMADD_VV_M4,
  PseudoVMADD_VV_M4_MASK,
  PseudoVMADD_VV_M8,
  PseudoVMADD_VV_M8_MASK,
  PseudoVMADD_VV_MF2,
  PseudoVMADD_VV_MF2_MASK,
  PseudoVMADD_VV_MF4,
  PseudoVMADD_VV_MF4_MASK,
  PseudoVMADD_VV_MF8,
  PseudoVMADD_VV_MF8_MASK,
  PseudoVMADD_VX_M1,
  PseudoVMADD_VX_M1_MASK,
  PseudoVMADD_VX_M2,
  PseudoVMADD_VX_M2_MASK,
  PseudoVMADD_VX_M4,
  PseudoVMADD_VX_M4_MASK,
  PseudoVMADD_VX_M8,
  PseudoVMADD_VX_M8_MASK,
  PseudoVMADD_VX_MF2,
  PseudoVMADD_VX_MF2_MASK,
  PseudoVMADD_VX_MF4,
  PseudoVMADD_VX_MF4_MASK,
  PseudoVMADD_VX_MF8,
  PseudoVMADD_VX_MF8_MASK,
  PseudoVMANDN_MM_B1,
  PseudoVMANDN_MM_B16,
  PseudoVMANDN_MM_B2,
  PseudoVMANDN_MM_B32,
  PseudoVMANDN_MM_B4,
  PseudoVMANDN_MM_B64,
  PseudoVMANDN_MM_B8,
  PseudoVMAND_MM_B1,
  PseudoVMAND_MM_B16,
  PseudoVMAND_MM_B2,
  PseudoVMAND_MM_B32,
  PseudoVMAND_MM_B4,
  PseudoVMAND_MM_B64,
  PseudoVMAND_MM_B8,
  PseudoVMAXU_VV_M1,
  PseudoVMAXU_VV_M1_MASK,
  PseudoVMAXU_VV_M2,
  PseudoVMAXU_VV_M2_MASK,
  PseudoVMAXU_VV_M4,
  PseudoVMAXU_VV_M4_MASK,
  PseudoVMAXU_VV_M8,
  PseudoVMAXU_VV_M8_MASK,
  PseudoVMAXU_VV_MF2,
  PseudoVMAXU_VV_MF2_MASK,
  PseudoVMAXU_VV_MF4,
  PseudoVMAXU_VV_MF4_MASK,
  PseudoVMAXU_VV_MF8,
  PseudoVMAXU_VV_MF8_MASK,
  PseudoVMAXU_VX_M1,
  PseudoVMAXU_VX_M1_MASK,
  PseudoVMAXU_VX_M2,
  PseudoVMAXU_VX_M2_MASK,
  PseudoVMAXU_VX_M4,
  PseudoVMAXU_VX_M4_MASK,
  PseudoVMAXU_VX_M8,
  PseudoVMAXU_VX_M8_MASK,
  PseudoVMAXU_VX_MF2,
  PseudoVMAXU_VX_MF2_MASK,
  PseudoVMAXU_VX_MF4,
  PseudoVMAXU_VX_MF4_MASK,
  PseudoVMAXU_VX_MF8,
  PseudoVMAXU_VX_MF8_MASK,
  PseudoVMAX_VV_M1,
  PseudoVMAX_VV_M1_MASK,
  PseudoVMAX_VV_M2,
  PseudoVMAX_VV_M2_MASK,
  PseudoVMAX_VV_M4,
  PseudoVMAX_VV_M4_MASK,
  PseudoVMAX_VV_M8,
  PseudoVMAX_VV_M8_MASK,
  PseudoVMAX_VV_MF2,
  PseudoVMAX_VV_MF2_MASK,
  PseudoVMAX_VV_MF4,
  PseudoVMAX_VV_MF4_MASK,
  PseudoVMAX_VV_MF8,
  PseudoVMAX_VV_MF8_MASK,
  PseudoVMAX_VX_M1,
  PseudoVMAX_VX_M1_MASK,
  PseudoVMAX_VX_M2,
  PseudoVMAX_VX_M2_MASK,
  PseudoVMAX_VX_M4,
  PseudoVMAX_VX_M4_MASK,
  PseudoVMAX_VX_M8,
  PseudoVMAX_VX_M8_MASK,
  PseudoVMAX_VX_MF2,
  PseudoVMAX_VX_MF2_MASK,
  PseudoVMAX_VX_MF4,
  PseudoVMAX_VX_MF4_MASK,
  PseudoVMAX_VX_MF8,
  PseudoVMAX_VX_MF8_MASK,
  PseudoVMCLR_M_B1,
  PseudoVMCLR_M_B16,
  PseudoVMCLR_M_B2,
  PseudoVMCLR_M_B32,
  PseudoVMCLR_M_B4,
  PseudoVMCLR_M_B64,
  PseudoVMCLR_M_B8,
  PseudoVMERGE_VIM_M1,
  PseudoVMERGE_VIM_M2,
  PseudoVMERGE_VIM_M4,
  PseudoVMERGE_VIM_M8,
  PseudoVMERGE_VIM_MF2,
  PseudoVMERGE_VIM_MF4,
  PseudoVMERGE_VIM_MF8,
  PseudoVMERGE_VVM_M1,
  PseudoVMERGE_VVM_M2,
  PseudoVMERGE_VVM_M4,
  PseudoVMERGE_VVM_M8,
  PseudoVMERGE_VVM_MF2,
  PseudoVMERGE_VVM_MF4,
  PseudoVMERGE_VVM_MF8,
  PseudoVMERGE_VXM_M1,
  PseudoVMERGE_VXM_M2,
  PseudoVMERGE_VXM_M4,
  PseudoVMERGE_VXM_M8,
  PseudoVMERGE_VXM_MF2,
  PseudoVMERGE_VXM_MF4,
  PseudoVMERGE_VXM_MF8,
  PseudoVMFEQ_VFPR16_M1,
  PseudoVMFEQ_VFPR16_M1_MASK,
  PseudoVMFEQ_VFPR16_M2,
  PseudoVMFEQ_VFPR16_M2_MASK,
  PseudoVMFEQ_VFPR16_M4,
  PseudoVMFEQ_VFPR16_M4_MASK,
  PseudoVMFEQ_VFPR16_M8,
  PseudoVMFEQ_VFPR16_M8_MASK,
  PseudoVMFEQ_VFPR16_MF2,
  PseudoVMFEQ_VFPR16_MF2_MASK,
  PseudoVMFEQ_VFPR16_MF4,
  PseudoVMFEQ_VFPR16_MF4_MASK,
  PseudoVMFEQ_VFPR32_M1,
  PseudoVMFEQ_VFPR32_M1_MASK,
  PseudoVMFEQ_VFPR32_M2,
  PseudoVMFEQ_VFPR32_M2_MASK,
  PseudoVMFEQ_VFPR32_M4,
  PseudoVMFEQ_VFPR32_M4_MASK,
  PseudoVMFEQ_VFPR32_M8,
  PseudoVMFEQ_VFPR32_M8_MASK,
  PseudoVMFEQ_VFPR32_MF2,
  PseudoVMFEQ_VFPR32_MF2_MASK,
  PseudoVMFEQ_VFPR64_M1,
  PseudoVMFEQ_VFPR64_M1_MASK,
  PseudoVMFEQ_VFPR64_M2,
  PseudoVMFEQ_VFPR64_M2_MASK,
  PseudoVMFEQ_VFPR64_M4,
  PseudoVMFEQ_VFPR64_M4_MASK,
  PseudoVMFEQ_VFPR64_M8,
  PseudoVMFEQ_VFPR64_M8_MASK,
  PseudoVMFEQ_VV_M1,
  PseudoVMFEQ_VV_M1_MASK,
  PseudoVMFEQ_VV_M2,
  PseudoVMFEQ_VV_M2_MASK,
  PseudoVMFEQ_VV_M4,
  PseudoVMFEQ_VV_M4_MASK,
  PseudoVMFEQ_VV_M8,
  PseudoVMFEQ_VV_M8_MASK,
  PseudoVMFEQ_VV_MF2,
  PseudoVMFEQ_VV_MF2_MASK,
  PseudoVMFEQ_VV_MF4,
  PseudoVMFEQ_VV_MF4_MASK,
  PseudoVMFGE_VFPR16_M1,
  PseudoVMFGE_VFPR16_M1_MASK,
  PseudoVMFGE_VFPR16_M2,
  PseudoVMFGE_VFPR16_M2_MASK,
  PseudoVMFGE_VFPR16_M4,
  PseudoVMFGE_VFPR16_M4_MASK,
  PseudoVMFGE_VFPR16_M8,
  PseudoVMFGE_VFPR16_M8_MASK,
  PseudoVMFGE_VFPR16_MF2,
  PseudoVMFGE_VFPR16_MF2_MASK,
  PseudoVMFGE_VFPR16_MF4,
  PseudoVMFGE_VFPR16_MF4_MASK,
  PseudoVMFGE_VFPR32_M1,
  PseudoVMFGE_VFPR32_M1_MASK,
  PseudoVMFGE_VFPR32_M2,
  PseudoVMFGE_VFPR32_M2_MASK,
  PseudoVMFGE_VFPR32_M4,
  PseudoVMFGE_VFPR32_M4_MASK,
  PseudoVMFGE_VFPR32_M8,
  PseudoVMFGE_VFPR32_M8_MASK,
  PseudoVMFGE_VFPR32_MF2,
  PseudoVMFGE_VFPR32_MF2_MASK,
  PseudoVMFGE_VFPR64_M1,
  PseudoVMFGE_VFPR64_M1_MASK,
  PseudoVMFGE_VFPR64_M2,
  PseudoVMFGE_VFPR64_M2_MASK,
  PseudoVMFGE_VFPR64_M4,
  PseudoVMFGE_VFPR64_M4_MASK,
  PseudoVMFGE_VFPR64_M8,
  PseudoVMFGE_VFPR64_M8_MASK,
  PseudoVMFGT_VFPR16_M1,
  PseudoVMFGT_VFPR16_M1_MASK,
  PseudoVMFGT_VFPR16_M2,
  PseudoVMFGT_VFPR16_M2_MASK,
  PseudoVMFGT_VFPR16_M4,
  PseudoVMFGT_VFPR16_M4_MASK,
  PseudoVMFGT_VFPR16_M8,
  PseudoVMFGT_VFPR16_M8_MASK,
  PseudoVMFGT_VFPR16_MF2,
  PseudoVMFGT_VFPR16_MF2_MASK,
  PseudoVMFGT_VFPR16_MF4,
  PseudoVMFGT_VFPR16_MF4_MASK,
  PseudoVMFGT_VFPR32_M1,
  PseudoVMFGT_VFPR32_M1_MASK,
  PseudoVMFGT_VFPR32_M2,
  PseudoVMFGT_VFPR32_M2_MASK,
  PseudoVMFGT_VFPR32_M4,
  PseudoVMFGT_VFPR32_M4_MASK,
  PseudoVMFGT_VFPR32_M8,
  PseudoVMFGT_VFPR32_M8_MASK,
  PseudoVMFGT_VFPR32_MF2,
  PseudoVMFGT_VFPR32_MF2_MASK,
  PseudoVMFGT_VFPR64_M1,
  PseudoVMFGT_VFPR64_M1_MASK,
  PseudoVMFGT_VFPR64_M2,
  PseudoVMFGT_VFPR64_M2_MASK,
  PseudoVMFGT_VFPR64_M4,
  PseudoVMFGT_VFPR64_M4_MASK,
  PseudoVMFGT_VFPR64_M8,
  PseudoVMFGT_VFPR64_M8_MASK,
  PseudoVMFLE_VFPR16_M1,
  PseudoVMFLE_VFPR16_M1_MASK,
  PseudoVMFLE_VFPR16_M2,
  PseudoVMFLE_VFPR16_M2_MASK,
  PseudoVMFLE_VFPR16_M4,
  PseudoVMFLE_VFPR16_M4_MASK,
  PseudoVMFLE_VFPR16_M8,
  PseudoVMFLE_VFPR16_M8_MASK,
  PseudoVMFLE_VFPR16_MF2,
  PseudoVMFLE_VFPR16_MF2_MASK,
  PseudoVMFLE_VFPR16_MF4,
  PseudoVMFLE_VFPR16_MF4_MASK,
  PseudoVMFLE_VFPR32_M1,
  PseudoVMFLE_VFPR32_M1_MASK,
  PseudoVMFLE_VFPR32_M2,
  PseudoVMFLE_VFPR32_M2_MASK,
  PseudoVMFLE_VFPR32_M4,
  PseudoVMFLE_VFPR32_M4_MASK,
  PseudoVMFLE_VFPR32_M8,
  PseudoVMFLE_VFPR32_M8_MASK,
  PseudoVMFLE_VFPR32_MF2,
  PseudoVMFLE_VFPR32_MF2_MASK,
  PseudoVMFLE_VFPR64_M1,
  PseudoVMFLE_VFPR64_M1_MASK,
  PseudoVMFLE_VFPR64_M2,
  PseudoVMFLE_VFPR64_M2_MASK,
  PseudoVMFLE_VFPR64_M4,
  PseudoVMFLE_VFPR64_M4_MASK,
  PseudoVMFLE_VFPR64_M8,
  PseudoVMFLE_VFPR64_M8_MASK,
  PseudoVMFLE_VV_M1,
  PseudoVMFLE_VV_M1_MASK,
  PseudoVMFLE_VV_M2,
  PseudoVMFLE_VV_M2_MASK,
  PseudoVMFLE_VV_M4,
  PseudoVMFLE_VV_M4_MASK,
  PseudoVMFLE_VV_M8,
  PseudoVMFLE_VV_M8_MASK,
  PseudoVMFLE_VV_MF2,
  PseudoVMFLE_VV_MF2_MASK,
  PseudoVMFLE_VV_MF4,
  PseudoVMFLE_VV_MF4_MASK,
  PseudoVMFLT_VFPR16_M1,
  PseudoVMFLT_VFPR16_M1_MASK,
  PseudoVMFLT_VFPR16_M2,
  PseudoVMFLT_VFPR16_M2_MASK,
  PseudoVMFLT_VFPR16_M4,
  PseudoVMFLT_VFPR16_M4_MASK,
  PseudoVMFLT_VFPR16_M8,
  PseudoVMFLT_VFPR16_M8_MASK,
  PseudoVMFLT_VFPR16_MF2,
  PseudoVMFLT_VFPR16_MF2_MASK,
  PseudoVMFLT_VFPR16_MF4,
  PseudoVMFLT_VFPR16_MF4_MASK,
  PseudoVMFLT_VFPR32_M1,
  PseudoVMFLT_VFPR32_M1_MASK,
  PseudoVMFLT_VFPR32_M2,
  PseudoVMFLT_VFPR32_M2_MASK,
  PseudoVMFLT_VFPR32_M4,
  PseudoVMFLT_VFPR32_M4_MASK,
  PseudoVMFLT_VFPR32_M8,
  PseudoVMFLT_VFPR32_M8_MASK,
  PseudoVMFLT_VFPR32_MF2,
  PseudoVMFLT_VFPR32_MF2_MASK,
  PseudoVMFLT_VFPR64_M1,
  PseudoVMFLT_VFPR64_M1_MASK,
  PseudoVMFLT_VFPR64_M2,
  PseudoVMFLT_VFPR64_M2_MASK,
  PseudoVMFLT_VFPR64_M4,
  PseudoVMFLT_VFPR64_M4_MASK,
  PseudoVMFLT_VFPR64_M8,
  PseudoVMFLT_VFPR64_M8_MASK,
  PseudoVMFLT_VV_M1,
  PseudoVMFLT_VV_M1_MASK,
  PseudoVMFLT_VV_M2,
  PseudoVMFLT_VV_M2_MASK,
  PseudoVMFLT_VV_M4,
  PseudoVMFLT_VV_M4_MASK,
  PseudoVMFLT_VV_M8,
  PseudoVMFLT_VV_M8_MASK,
  PseudoVMFLT_VV_MF2,
  PseudoVMFLT_VV_MF2_MASK,
  PseudoVMFLT_VV_MF4,
  PseudoVMFLT_VV_MF4_MASK,
  PseudoVMFNE_VFPR16_M1,
  PseudoVMFNE_VFPR16_M1_MASK,
  PseudoVMFNE_VFPR16_M2,
  PseudoVMFNE_VFPR16_M2_MASK,
  PseudoVMFNE_VFPR16_M4,
  PseudoVMFNE_VFPR16_M4_MASK,
  PseudoVMFNE_VFPR16_M8,
  PseudoVMFNE_VFPR16_M8_MASK,
  PseudoVMFNE_VFPR16_MF2,
  PseudoVMFNE_VFPR16_MF2_MASK,
  PseudoVMFNE_VFPR16_MF4,
  PseudoVMFNE_VFPR16_MF4_MASK,
  PseudoVMFNE_VFPR32_M1,
  PseudoVMFNE_VFPR32_M1_MASK,
  PseudoVMFNE_VFPR32_M2,
  PseudoVMFNE_VFPR32_M2_MASK,
  PseudoVMFNE_VFPR32_M4,
  PseudoVMFNE_VFPR32_M4_MASK,
  PseudoVMFNE_VFPR32_M8,
  PseudoVMFNE_VFPR32_M8_MASK,
  PseudoVMFNE_VFPR32_MF2,
  PseudoVMFNE_VFPR32_MF2_MASK,
  PseudoVMFNE_VFPR64_M1,
  PseudoVMFNE_VFPR64_M1_MASK,
  PseudoVMFNE_VFPR64_M2,
  PseudoVMFNE_VFPR64_M2_MASK,
  PseudoVMFNE_VFPR64_M4,
  PseudoVMFNE_VFPR64_M4_MASK,
  PseudoVMFNE_VFPR64_M8,
  PseudoVMFNE_VFPR64_M8_MASK,
  PseudoVMFNE_VV_M1,
  PseudoVMFNE_VV_M1_MASK,
  PseudoVMFNE_VV_M2,
  PseudoVMFNE_VV_M2_MASK,
  PseudoVMFNE_VV_M4,
  PseudoVMFNE_VV_M4_MASK,
  PseudoVMFNE_VV_M8,
  PseudoVMFNE_VV_M8_MASK,
  PseudoVMFNE_VV_MF2,
  PseudoVMFNE_VV_MF2_MASK,
  PseudoVMFNE_VV_MF4,
  PseudoVMFNE_VV_MF4_MASK,
  PseudoVMINU_VV_M1,
  PseudoVMINU_VV_M1_MASK,
  PseudoVMINU_VV_M2,
  PseudoVMINU_VV_M2_MASK,
  PseudoVMINU_VV_M4,
  PseudoVMINU_VV_M4_MASK,
  PseudoVMINU_VV_M8,
  PseudoVMINU_VV_M8_MASK,
  PseudoVMINU_VV_MF2,
  PseudoVMINU_VV_MF2_MASK,
  PseudoVMINU_VV_MF4,
  PseudoVMINU_VV_MF4_MASK,
  PseudoVMINU_VV_MF8,
  PseudoVMINU_VV_MF8_MASK,
  PseudoVMINU_VX_M1,
  PseudoVMINU_VX_M1_MASK,
  PseudoVMINU_VX_M2,
  PseudoVMINU_VX_M2_MASK,
  PseudoVMINU_VX_M4,
  PseudoVMINU_VX_M4_MASK,
  PseudoVMINU_VX_M8,
  PseudoVMINU_VX_M8_MASK,
  PseudoVMINU_VX_MF2,
  PseudoVMINU_VX_MF2_MASK,
  PseudoVMINU_VX_MF4,
  PseudoVMINU_VX_MF4_MASK,
  PseudoVMINU_VX_MF8,
  PseudoVMINU_VX_MF8_MASK,
  PseudoVMIN_VV_M1,
  PseudoVMIN_VV_M1_MASK,
  PseudoVMIN_VV_M2,
  PseudoVMIN_VV_M2_MASK,
  PseudoVMIN_VV_M4,
  PseudoVMIN_VV_M4_MASK,
  PseudoVMIN_VV_M8,
  PseudoVMIN_VV_M8_MASK,
  PseudoVMIN_VV_MF2,
  PseudoVMIN_VV_MF2_MASK,
  PseudoVMIN_VV_MF4,
  PseudoVMIN_VV_MF4_MASK,
  PseudoVMIN_VV_MF8,
  PseudoVMIN_VV_MF8_MASK,
  PseudoVMIN_VX_M1,
  PseudoVMIN_VX_M1_MASK,
  PseudoVMIN_VX_M2,
  PseudoVMIN_VX_M2_MASK,
  PseudoVMIN_VX_M4,
  PseudoVMIN_VX_M4_MASK,
  PseudoVMIN_VX_M8,
  PseudoVMIN_VX_M8_MASK,
  PseudoVMIN_VX_MF2,
  PseudoVMIN_VX_MF2_MASK,
  PseudoVMIN_VX_MF4,
  PseudoVMIN_VX_MF4_MASK,
  PseudoVMIN_VX_MF8,
  PseudoVMIN_VX_MF8_MASK,
  PseudoVMNAND_MM_B1,
  PseudoVMNAND_MM_B16,
  PseudoVMNAND_MM_B2,
  PseudoVMNAND_MM_B32,
  PseudoVMNAND_MM_B4,
  PseudoVMNAND_MM_B64,
  PseudoVMNAND_MM_B8,
  PseudoVMNOR_MM_B1,
  PseudoVMNOR_MM_B16,
  PseudoVMNOR_MM_B2,
  PseudoVMNOR_MM_B32,
  PseudoVMNOR_MM_B4,
  PseudoVMNOR_MM_B64,
  PseudoVMNOR_MM_B8,
  PseudoVMORN_MM_B1,
  PseudoVMORN_MM_B16,
  PseudoVMORN_MM_B2,
  PseudoVMORN_MM_B32,
  PseudoVMORN_MM_B4,
  PseudoVMORN_MM_B64,
  PseudoVMORN_MM_B8,
  PseudoVMOR_MM_B1,
  PseudoVMOR_MM_B16,
  PseudoVMOR_MM_B2,
  PseudoVMOR_MM_B32,
  PseudoVMOR_MM_B4,
  PseudoVMOR_MM_B64,
  PseudoVMOR_MM_B8,
  PseudoVMSBC_VVM_M1,
  PseudoVMSBC_VVM_M2,
  PseudoVMSBC_VVM_M4,
  PseudoVMSBC_VVM_M8,
  PseudoVMSBC_VVM_MF2,
  PseudoVMSBC_VVM_MF4,
  PseudoVMSBC_VVM_MF8,
  PseudoVMSBC_VV_M1,
  PseudoVMSBC_VV_M2,
  PseudoVMSBC_VV_M4,
  PseudoVMSBC_VV_M8,
  PseudoVMSBC_VV_MF2,
  PseudoVMSBC_VV_MF4,
  PseudoVMSBC_VV_MF8,
  PseudoVMSBC_VXM_M1,
  PseudoVMSBC_VXM_M2,
  PseudoVMSBC_VXM_M4,
  PseudoVMSBC_VXM_M8,
  PseudoVMSBC_VXM_MF2,
  PseudoVMSBC_VXM_MF4,
  PseudoVMSBC_VXM_MF8,
  PseudoVMSBC_VX_M1,
  PseudoVMSBC_VX_M2,
  PseudoVMSBC_VX_M4,
  PseudoVMSBC_VX_M8,
  PseudoVMSBC_VX_MF2,
  PseudoVMSBC_VX_MF4,
  PseudoVMSBC_VX_MF8,
  PseudoVMSBF_M_B1,
  PseudoVMSBF_M_B16,
  PseudoVMSBF_M_B16_MASK,
  PseudoVMSBF_M_B1_MASK,
  PseudoVMSBF_M_B2,
  PseudoVMSBF_M_B2_MASK,
  PseudoVMSBF_M_B32,
  PseudoVMSBF_M_B32_MASK,
  PseudoVMSBF_M_B4,
  PseudoVMSBF_M_B4_MASK,
  PseudoVMSBF_M_B64,
  PseudoVMSBF_M_B64_MASK,
  PseudoVMSBF_M_B8,
  PseudoVMSBF_M_B8_MASK,
  PseudoVMSEQ_VI_M1,
  PseudoVMSEQ_VI_M1_MASK,
  PseudoVMSEQ_VI_M2,
  PseudoVMSEQ_VI_M2_MASK,
  PseudoVMSEQ_VI_M4,
  PseudoVMSEQ_VI_M4_MASK,
  PseudoVMSEQ_VI_M8,
  PseudoVMSEQ_VI_M8_MASK,
  PseudoVMSEQ_VI_MF2,
  PseudoVMSEQ_VI_MF2_MASK,
  PseudoVMSEQ_VI_MF4,
  PseudoVMSEQ_VI_MF4_MASK,
  PseudoVMSEQ_VI_MF8,
  PseudoVMSEQ_VI_MF8_MASK,
  PseudoVMSEQ_VV_M1,
  PseudoVMSEQ_VV_M1_MASK,
  PseudoVMSEQ_VV_M2,
  PseudoVMSEQ_VV_M2_MASK,
  PseudoVMSEQ_VV_M4,
  PseudoVMSEQ_VV_M4_MASK,
  PseudoVMSEQ_VV_M8,
  PseudoVMSEQ_VV_M8_MASK,
  PseudoVMSEQ_VV_MF2,
  PseudoVMSEQ_VV_MF2_MASK,
  PseudoVMSEQ_VV_MF4,
  PseudoVMSEQ_VV_MF4_MASK,
  PseudoVMSEQ_VV_MF8,
  PseudoVMSEQ_VV_MF8_MASK,
  PseudoVMSEQ_VX_M1,
  PseudoVMSEQ_VX_M1_MASK,
  PseudoVMSEQ_VX_M2,
  PseudoVMSEQ_VX_M2_MASK,
  PseudoVMSEQ_VX_M4,
  PseudoVMSEQ_VX_M4_MASK,
  PseudoVMSEQ_VX_M8,
  PseudoVMSEQ_VX_M8_MASK,
  PseudoVMSEQ_VX_MF2,
  PseudoVMSEQ_VX_MF2_MASK,
  PseudoVMSEQ_VX_MF4,
  PseudoVMSEQ_VX_MF4_MASK,
  PseudoVMSEQ_VX_MF8,
  PseudoVMSEQ_VX_MF8_MASK,
  PseudoVMSET_M_B1,
  PseudoVMSET_M_B16,
  PseudoVMSET_M_B2,
  PseudoVMSET_M_B32,
  PseudoVMSET_M_B4,
  PseudoVMSET_M_B64,
  PseudoVMSET_M_B8,
  PseudoVMSGEU_VI,
  PseudoVMSGEU_VX,
  PseudoVMSGEU_VX_M,
  PseudoVMSGEU_VX_M_T,
  PseudoVMSGE_VI,
  PseudoVMSGE_VX,
  PseudoVMSGE_VX_M,
  PseudoVMSGE_VX_M_T,
  PseudoVMSGTU_VI_M1,
  PseudoVMSGTU_VI_M1_MASK,
  PseudoVMSGTU_VI_M2,
  PseudoVMSGTU_VI_M2_MASK,
  PseudoVMSGTU_VI_M4,
  PseudoVMSGTU_VI_M4_MASK,
  PseudoVMSGTU_VI_M8,
  PseudoVMSGTU_VI_M8_MASK,
  PseudoVMSGTU_VI_MF2,
  PseudoVMSGTU_VI_MF2_MASK,
  PseudoVMSGTU_VI_MF4,
  PseudoVMSGTU_VI_MF4_MASK,
  PseudoVMSGTU_VI_MF8,
  PseudoVMSGTU_VI_MF8_MASK,
  PseudoVMSGTU_VX_M1,
  PseudoVMSGTU_VX_M1_MASK,
  PseudoVMSGTU_VX_M2,
  PseudoVMSGTU_VX_M2_MASK,
  PseudoVMSGTU_VX_M4,
  PseudoVMSGTU_VX_M4_MASK,
  PseudoVMSGTU_VX_M8,
  PseudoVMSGTU_VX_M8_MASK,
  PseudoVMSGTU_VX_MF2,
  PseudoVMSGTU_VX_MF2_MASK,
  PseudoVMSGTU_VX_MF4,
  PseudoVMSGTU_VX_MF4_MASK,
  PseudoVMSGTU_VX_MF8,
  PseudoVMSGTU_VX_MF8_MASK,
  PseudoVMSGT_VI_M1,
  PseudoVMSGT_VI_M1_MASK,
  PseudoVMSGT_VI_M2,
  PseudoVMSGT_VI_M2_MASK,
  PseudoVMSGT_VI_M4,
  PseudoVMSGT_VI_M4_MASK,
  PseudoVMSGT_VI_M8,
  PseudoVMSGT_VI_M8_MASK,
  PseudoVMSGT_VI_MF2,
  PseudoVMSGT_VI_MF2_MASK,
  PseudoVMSGT_VI_MF4,
  PseudoVMSGT_VI_MF4_MASK,
  PseudoVMSGT_VI_MF8,
  PseudoVMSGT_VI_MF8_MASK,
  PseudoVMSGT_VX_M1,
  PseudoVMSGT_VX_M1_MASK,
  PseudoVMSGT_VX_M2,
  PseudoVMSGT_VX_M2_MASK,
  PseudoVMSGT_VX_M4,
  PseudoVMSGT_VX_M4_MASK,
  PseudoVMSGT_VX_M8,
  PseudoVMSGT_VX_M8_MASK,
  PseudoVMSGT_VX_MF2,
  PseudoVMSGT_VX_MF2_MASK,
  PseudoVMSGT_VX_MF4,
  PseudoVMSGT_VX_MF4_MASK,
  PseudoVMSGT_VX_MF8,
  PseudoVMSGT_VX_MF8_MASK,
  PseudoVMSIF_M_B1,
  PseudoVMSIF_M_B16,
  PseudoVMSIF_M_B16_MASK,
  PseudoVMSIF_M_B1_MASK,
  PseudoVMSIF_M_B2,
  PseudoVMSIF_M_B2_MASK,
  PseudoVMSIF_M_B32,
  PseudoVMSIF_M_B32_MASK,
  PseudoVMSIF_M_B4,
  PseudoVMSIF_M_B4_MASK,
  PseudoVMSIF_M_B64,
  PseudoVMSIF_M_B64_MASK,
  PseudoVMSIF_M_B8,
  PseudoVMSIF_M_B8_MASK,
  PseudoVMSLEU_VI_M1,
  PseudoVMSLEU_VI_M1_MASK,
  PseudoVMSLEU_VI_M2,
  PseudoVMSLEU_VI_M2_MASK,
  PseudoVMSLEU_VI_M4,
  PseudoVMSLEU_VI_M4_MASK,
  PseudoVMSLEU_VI_M8,
  PseudoVMSLEU_VI_M8_MASK,
  PseudoVMSLEU_VI_MF2,
  PseudoVMSLEU_VI_MF2_MASK,
  PseudoVMSLEU_VI_MF4,
  PseudoVMSLEU_VI_MF4_MASK,
  PseudoVMSLEU_VI_MF8,
  PseudoVMSLEU_VI_MF8_MASK,
  PseudoVMSLEU_VV_M1,
  PseudoVMSLEU_VV_M1_MASK,
  PseudoVMSLEU_VV_M2,
  PseudoVMSLEU_VV_M2_MASK,
  PseudoVMSLEU_VV_M4,
  PseudoVMSLEU_VV_M4_MASK,
  PseudoVMSLEU_VV_M8,
  PseudoVMSLEU_VV_M8_MASK,
  PseudoVMSLEU_VV_MF2,
  PseudoVMSLEU_VV_MF2_MASK,
  PseudoVMSLEU_VV_MF4,
  PseudoVMSLEU_VV_MF4_MASK,
  PseudoVMSLEU_VV_MF8,
  PseudoVMSLEU_VV_MF8_MASK,
  PseudoVMSLEU_VX_M1,
  PseudoVMSLEU_VX_M1_MASK,
  PseudoVMSLEU_VX_M2,
  PseudoVMSLEU_VX_M2_MASK,
  PseudoVMSLEU_VX_M4,
  PseudoVMSLEU_VX_M4_MASK,
  PseudoVMSLEU_VX_M8,
  PseudoVMSLEU_VX_M8_MASK,
  PseudoVMSLEU_VX_MF2,
  PseudoVMSLEU_VX_MF2_MASK,
  PseudoVMSLEU_VX_MF4,
  PseudoVMSLEU_VX_MF4_MASK,
  PseudoVMSLEU_VX_MF8,
  PseudoVMSLEU_VX_MF8_MASK,
  PseudoVMSLE_VI_M1,
  PseudoVMSLE_VI_M1_MASK,
  PseudoVMSLE_VI_M2,
  PseudoVMSLE_VI_M2_MASK,
  PseudoVMSLE_VI_M4,
  PseudoVMSLE_VI_M4_MASK,
  PseudoVMSLE_VI_M8,
  PseudoVMSLE_VI_M8_MASK,
  PseudoVMSLE_VI_MF2,
  PseudoVMSLE_VI_MF2_MASK,
  PseudoVMSLE_VI_MF4,
  PseudoVMSLE_VI_MF4_MASK,
  PseudoVMSLE_VI_MF8,
  PseudoVMSLE_VI_MF8_MASK,
  PseudoVMSLE_VV_M1,
  PseudoVMSLE_VV_M1_MASK,
  PseudoVMSLE_VV_M2,
  PseudoVMSLE_VV_M2_MASK,
  PseudoVMSLE_VV_M4,
  PseudoVMSLE_VV_M4_MASK,
  PseudoVMSLE_VV_M8,
  PseudoVMSLE_VV_M8_MASK,
  PseudoVMSLE_VV_MF2,
  PseudoVMSLE_VV_MF2_MASK,
  PseudoVMSLE_VV_MF4,
  PseudoVMSLE_VV_MF4_MASK,
  PseudoVMSLE_VV_MF8,
  PseudoVMSLE_VV_MF8_MASK,
  PseudoVMSLE_VX_M1,
  PseudoVMSLE_VX_M1_MASK,
  PseudoVMSLE_VX_M2,
  PseudoVMSLE_VX_M2_MASK,
  PseudoVMSLE_VX_M4,
  PseudoVMSLE_VX_M4_MASK,
  PseudoVMSLE_VX_M8,
  PseudoVMSLE_VX_M8_MASK,
  PseudoVMSLE_VX_MF2,
  PseudoVMSLE_VX_MF2_MASK,
  PseudoVMSLE_VX_MF4,
  PseudoVMSLE_VX_MF4_MASK,
  PseudoVMSLE_VX_MF8,
  PseudoVMSLE_VX_MF8_MASK,
  PseudoVMSLTU_VI,
  PseudoVMSLTU_VV_M1,
  PseudoVMSLTU_VV_M1_MASK,
  PseudoVMSLTU_VV_M2,
  PseudoVMSLTU_VV_M2_MASK,
  PseudoVMSLTU_VV_M4,
  PseudoVMSLTU_VV_M4_MASK,
  PseudoVMSLTU_VV_M8,
  PseudoVMSLTU_VV_M8_MASK,
  PseudoVMSLTU_VV_MF2,
  PseudoVMSLTU_VV_MF2_MASK,
  PseudoVMSLTU_VV_MF4,
  PseudoVMSLTU_VV_MF4_MASK,
  PseudoVMSLTU_VV_MF8,
  PseudoVMSLTU_VV_MF8_MASK,
  PseudoVMSLTU_VX_M1,
  PseudoVMSLTU_VX_M1_MASK,
  PseudoVMSLTU_VX_M2,
  PseudoVMSLTU_VX_M2_MASK,
  PseudoVMSLTU_VX_M4,
  PseudoVMSLTU_VX_M4_MASK,
  PseudoVMSLTU_VX_M8,
  PseudoVMSLTU_VX_M8_MASK,
  PseudoVMSLTU_VX_MF2,
  PseudoVMSLTU_VX_MF2_MASK,
  PseudoVMSLTU_VX_MF4,
  PseudoVMSLTU_VX_MF4_MASK,
  PseudoVMSLTU_VX_MF8,
  PseudoVMSLTU_VX_MF8_MASK,
  PseudoVMSLT_VI,
  PseudoVMSLT_VV_M1,
  PseudoVMSLT_VV_M1_MASK,
  PseudoVMSLT_VV_M2,
  PseudoVMSLT_VV_M2_MASK,
  PseudoVMSLT_VV_M4,
  PseudoVMSLT_VV_M4_MASK,
  PseudoVMSLT_VV_M8,
  PseudoVMSLT_VV_M8_MASK,
  PseudoVMSLT_VV_MF2,
  PseudoVMSLT_VV_MF2_MASK,
  PseudoVMSLT_VV_MF4,
  PseudoVMSLT_VV_MF4_MASK,
  PseudoVMSLT_VV_MF8,
  PseudoVMSLT_VV_MF8_MASK,
  PseudoVMSLT_VX_M1,
  PseudoVMSLT_VX_M1_MASK,
  PseudoVMSLT_VX_M2,
  PseudoVMSLT_VX_M2_MASK,
  PseudoVMSLT_VX_M4,
  PseudoVMSLT_VX_M4_MASK,
  PseudoVMSLT_VX_M8,
  PseudoVMSLT_VX_M8_MASK,
  PseudoVMSLT_VX_MF2,
  PseudoVMSLT_VX_MF2_MASK,
  PseudoVMSLT_VX_MF4,
  PseudoVMSLT_VX_MF4_MASK,
  PseudoVMSLT_VX_MF8,
  PseudoVMSLT_VX_MF8_MASK,
  PseudoVMSNE_VI_M1,
  PseudoVMSNE_VI_M1_MASK,
  PseudoVMSNE_VI_M2,
  PseudoVMSNE_VI_M2_MASK,
  PseudoVMSNE_VI_M4,
  PseudoVMSNE_VI_M4_MASK,
  PseudoVMSNE_VI_M8,
  PseudoVMSNE_VI_M8_MASK,
  PseudoVMSNE_VI_MF2,
  PseudoVMSNE_VI_MF2_MASK,
  PseudoVMSNE_VI_MF4,
  PseudoVMSNE_VI_MF4_MASK,
  PseudoVMSNE_VI_MF8,
  PseudoVMSNE_VI_MF8_MASK,
  PseudoVMSNE_VV_M1,
  PseudoVMSNE_VV_M1_MASK,
  PseudoVMSNE_VV_M2,
  PseudoVMSNE_VV_M2_MASK,
  PseudoVMSNE_VV_M4,
  PseudoVMSNE_VV_M4_MASK,
  PseudoVMSNE_VV_M8,
  PseudoVMSNE_VV_M8_MASK,
  PseudoVMSNE_VV_MF2,
  PseudoVMSNE_VV_MF2_MASK,
  PseudoVMSNE_VV_MF4,
  PseudoVMSNE_VV_MF4_MASK,
  PseudoVMSNE_VV_MF8,
  PseudoVMSNE_VV_MF8_MASK,
  PseudoVMSNE_VX_M1,
  PseudoVMSNE_VX_M1_MASK,
  PseudoVMSNE_VX_M2,
  PseudoVMSNE_VX_M2_MASK,
  PseudoVMSNE_VX_M4,
  PseudoVMSNE_VX_M4_MASK,
  PseudoVMSNE_VX_M8,
  PseudoVMSNE_VX_M8_MASK,
  PseudoVMSNE_VX_MF2,
  PseudoVMSNE_VX_MF2_MASK,
  PseudoVMSNE_VX_MF4,
  PseudoVMSNE_VX_MF4_MASK,
  PseudoVMSNE_VX_MF8,
  PseudoVMSNE_VX_MF8_MASK,
  PseudoVMSOF_M_B1,
  PseudoVMSOF_M_B16,
  PseudoVMSOF_M_B16_MASK,
  PseudoVMSOF_M_B1_MASK,
  PseudoVMSOF_M_B2,
  PseudoVMSOF_M_B2_MASK,
  PseudoVMSOF_M_B32,
  PseudoVMSOF_M_B32_MASK,
  PseudoVMSOF_M_B4,
  PseudoVMSOF_M_B4_MASK,
  PseudoVMSOF_M_B64,
  PseudoVMSOF_M_B64_MASK,
  PseudoVMSOF_M_B8,
  PseudoVMSOF_M_B8_MASK,
  PseudoVMULHSU_VV_M1,
  PseudoVMULHSU_VV_M1_MASK,
  PseudoVMULHSU_VV_M2,
  PseudoVMULHSU_VV_M2_MASK,
  PseudoVMULHSU_VV_M4,
  PseudoVMULHSU_VV_M4_MASK,
  PseudoVMULHSU_VV_M8,
  PseudoVMULHSU_VV_M8_MASK,
  PseudoVMULHSU_VV_MF2,
  PseudoVMULHSU_VV_MF2_MASK,
  PseudoVMULHSU_VV_MF4,
  PseudoVMULHSU_VV_MF4_MASK,
  PseudoVMULHSU_VV_MF8,
  PseudoVMULHSU_VV_MF8_MASK,
  PseudoVMULHSU_VX_M1,
  PseudoVMULHSU_VX_M1_MASK,
  PseudoVMULHSU_VX_M2,
  PseudoVMULHSU_VX_M2_MASK,
  PseudoVMULHSU_VX_M4,
  PseudoVMULHSU_VX_M4_MASK,
  PseudoVMULHSU_VX_M8,
  PseudoVMULHSU_VX_M8_MASK,
  PseudoVMULHSU_VX_MF2,
  PseudoVMULHSU_VX_MF2_MASK,
  PseudoVMULHSU_VX_MF4,
  PseudoVMULHSU_VX_MF4_MASK,
  PseudoVMULHSU_VX_MF8,
  PseudoVMULHSU_VX_MF8_MASK,
  PseudoVMULHU_VV_M1,
  PseudoVMULHU_VV_M1_MASK,
  PseudoVMULHU_VV_M2,
  PseudoVMULHU_VV_M2_MASK,
  PseudoVMULHU_VV_M4,
  PseudoVMULHU_VV_M4_MASK,
  PseudoVMULHU_VV_M8,
  PseudoVMULHU_VV_M8_MASK,
  PseudoVMULHU_VV_MF2,
  PseudoVMULHU_VV_MF2_MASK,
  PseudoVMULHU_VV_MF4,
  PseudoVMULHU_VV_MF4_MASK,
  PseudoVMULHU_VV_MF8,
  PseudoVMULHU_VV_MF8_MASK,
  PseudoVMULHU_VX_M1,
  PseudoVMULHU_VX_M1_MASK,
  PseudoVMULHU_VX_M2,
  PseudoVMULHU_VX_M2_MASK,
  PseudoVMULHU_VX_M4,
  PseudoVMULHU_VX_M4_MASK,
  PseudoVMULHU_VX_M8,
  PseudoVMULHU_VX_M8_MASK,
  PseudoVMULHU_VX_MF2,
  PseudoVMULHU_VX_MF2_MASK,
  PseudoVMULHU_VX_MF4,
  PseudoVMULHU_VX_MF4_MASK,
  PseudoVMULHU_VX_MF8,
  PseudoVMULHU_VX_MF8_MASK,
  PseudoVMULH_VV_M1,
  PseudoVMULH_VV_M1_MASK,
  PseudoVMULH_VV_M2,
  PseudoVMULH_VV_M2_MASK,
  PseudoVMULH_VV_M4,
  PseudoVMULH_VV_M4_MASK,
  PseudoVMULH_VV_M8,
  PseudoVMULH_VV_M8_MASK,
  PseudoVMULH_VV_MF2,
  PseudoVMULH_VV_MF2_MASK,
  PseudoVMULH_VV_MF4,
  PseudoVMULH_VV_MF4_MASK,
  PseudoVMULH_VV_MF8,
  PseudoVMULH_VV_MF8_MASK,
  PseudoVMULH_VX_M1,
  PseudoVMULH_VX_M1_MASK,
  PseudoVMULH_VX_M2,
  PseudoVMULH_VX_M2_MASK,
  PseudoVMULH_VX_M4,
  PseudoVMULH_VX_M4_MASK,
  PseudoVMULH_VX_M8,
  PseudoVMULH_VX_M8_MASK,
  PseudoVMULH_VX_MF2,
  PseudoVMULH_VX_MF2_MASK,
  PseudoVMULH_VX_MF4,
  PseudoVMULH_VX_MF4_MASK,
  PseudoVMULH_VX_MF8,
  PseudoVMULH_VX_MF8_MASK,
  PseudoVMUL_VV_M1,
  PseudoVMUL_VV_M1_MASK,
  PseudoVMUL_VV_M2,
  PseudoVMUL_VV_M2_MASK,
  PseudoVMUL_VV_M4,
  PseudoVMUL_VV_M4_MASK,
  PseudoVMUL_VV_M8,
  PseudoVMUL_VV_M8_MASK,
  PseudoVMUL_VV_MF2,
  PseudoVMUL_VV_MF2_MASK,
  PseudoVMUL_VV_MF4,
  PseudoVMUL_VV_MF4_MASK,
  PseudoVMUL_VV_MF8,
  PseudoVMUL_VV_MF8_MASK,
  PseudoVMUL_VX_M1,
  PseudoVMUL_VX_M1_MASK,
  PseudoVMUL_VX_M2,
  PseudoVMUL_VX_M2_MASK,
  PseudoVMUL_VX_M4,
  PseudoVMUL_VX_M4_MASK,
  PseudoVMUL_VX_M8,
  PseudoVMUL_VX_M8_MASK,
  PseudoVMUL_VX_MF2,
  PseudoVMUL_VX_MF2_MASK,
  PseudoVMUL_VX_MF4,
  PseudoVMUL_VX_MF4_MASK,
  PseudoVMUL_VX_MF8,
  PseudoVMUL_VX_MF8_MASK,
  PseudoVMV_S_X,
  PseudoVMV_V_I_M1,
  PseudoVMV_V_I_M2,
  PseudoVMV_V_I_M4,
  PseudoVMV_V_I_M8,
  PseudoVMV_V_I_MF2,
  PseudoVMV_V_I_MF4,
  PseudoVMV_V_I_MF8,
  PseudoVMV_V_V_M1,
  PseudoVMV_V_V_M2,
  PseudoVMV_V_V_M4,
  PseudoVMV_V_V_M8,
  PseudoVMV_V_V_MF2,
  PseudoVMV_V_V_MF4,
  PseudoVMV_V_V_MF8,
  PseudoVMV_V_X_M1,
  PseudoVMV_V_X_M2,
  PseudoVMV_V_X_M4,
  PseudoVMV_V_X_M8,
  PseudoVMV_V_X_MF2,
  PseudoVMV_V_X_MF4,
  PseudoVMV_V_X_MF8,
  PseudoVMV_X_S,
  PseudoVMXNOR_MM_B1,
  PseudoVMXNOR_MM_B16,
  PseudoVMXNOR_MM_B2,
  PseudoVMXNOR_MM_B32,
  PseudoVMXNOR_MM_B4,
  PseudoVMXNOR_MM_B64,
  PseudoVMXNOR_MM_B8,
  PseudoVMXOR_MM_B1,
  PseudoVMXOR_MM_B16,
  PseudoVMXOR_MM_B2,
  PseudoVMXOR_MM_B32,
  PseudoVMXOR_MM_B4,
  PseudoVMXOR_MM_B64,
  PseudoVMXOR_MM_B8,
  PseudoVNCLIPU_WI_M1,
  PseudoVNCLIPU_WI_M1_MASK,
  PseudoVNCLIPU_WI_M2,
  PseudoVNCLIPU_WI_M2_MASK,
  PseudoVNCLIPU_WI_M4,
  PseudoVNCLIPU_WI_M4_MASK,
  PseudoVNCLIPU_WI_MF2,
  PseudoVNCLIPU_WI_MF2_MASK,
  PseudoVNCLIPU_WI_MF4,
  PseudoVNCLIPU_WI_MF4_MASK,
  PseudoVNCLIPU_WI_MF8,
  PseudoVNCLIPU_WI_MF8_MASK,
  PseudoVNCLIPU_WV_M1,
  PseudoVNCLIPU_WV_M1_MASK,
  PseudoVNCLIPU_WV_M2,
  PseudoVNCLIPU_WV_M2_MASK,
  PseudoVNCLIPU_WV_M4,
  PseudoVNCLIPU_WV_M4_MASK,
  PseudoVNCLIPU_WV_MF2,
  PseudoVNCLIPU_WV_MF2_MASK,
  PseudoVNCLIPU_WV_MF4,
  PseudoVNCLIPU_WV_MF4_MASK,
  PseudoVNCLIPU_WV_MF8,
  PseudoVNCLIPU_WV_MF8_MASK,
  PseudoVNCLIPU_WX_M1,
  PseudoVNCLIPU_WX_M1_MASK,
  PseudoVNCLIPU_WX_M2,
  PseudoVNCLIPU_WX_M2_MASK,
  PseudoVNCLIPU_WX_M4,
  PseudoVNCLIPU_WX_M4_MASK,
  PseudoVNCLIPU_WX_MF2,
  PseudoVNCLIPU_WX_MF2_MASK,
  PseudoVNCLIPU_WX_MF4,
  PseudoVNCLIPU_WX_MF4_MASK,
  PseudoVNCLIPU_WX_MF8,
  PseudoVNCLIPU_WX_MF8_MASK,
  PseudoVNCLIP_WI_M1,
  PseudoVNCLIP_WI_M1_MASK,
  PseudoVNCLIP_WI_M2,
  PseudoVNCLIP_WI_M2_MASK,
  PseudoVNCLIP_WI_M4,
  PseudoVNCLIP_WI_M4_MASK,
  PseudoVNCLIP_WI_MF2,
  PseudoVNCLIP_WI_MF2_MASK,
  PseudoVNCLIP_WI_MF4,
  PseudoVNCLIP_WI_MF4_MASK,
  PseudoVNCLIP_WI_MF8,
  PseudoVNCLIP_WI_MF8_MASK,
  PseudoVNCLIP_WV_M1,
  PseudoVNCLIP_WV_M1_MASK,
  PseudoVNCLIP_WV_M2,
  PseudoVNCLIP_WV_M2_MASK,
  PseudoVNCLIP_WV_M4,
  PseudoVNCLIP_WV_M4_MASK,
  PseudoVNCLIP_WV_MF2,
  PseudoVNCLIP_WV_MF2_MASK,
  PseudoVNCLIP_WV_MF4,
  PseudoVNCLIP_WV_MF4_MASK,
  PseudoVNCLIP_WV_MF8,
  PseudoVNCLIP_WV_MF8_MASK,
  PseudoVNCLIP_WX_M1,
  PseudoVNCLIP_WX_M1_MASK,
  PseudoVNCLIP_WX_M2,
  PseudoVNCLIP_WX_M2_MASK,
  PseudoVNCLIP_WX_M4,
  PseudoVNCLIP_WX_M4_MASK,
  PseudoVNCLIP_WX_MF2,
  PseudoVNCLIP_WX_MF2_MASK,
  PseudoVNCLIP_WX_MF4,
  PseudoVNCLIP_WX_MF4_MASK,
  PseudoVNCLIP_WX_MF8,
  PseudoVNCLIP_WX_MF8_MASK,
  PseudoVNMSAC_VV_M1,
  PseudoVNMSAC_VV_M1_MASK,
  PseudoVNMSAC_VV_M2,
  PseudoVNMSAC_VV_M2_MASK,
  PseudoVNMSAC_VV_M4,
  PseudoVNMSAC_VV_M4_MASK,
  PseudoVNMSAC_VV_M8,
  PseudoVNMSAC_VV_M8_MASK,
  PseudoVNMSAC_VV_MF2,
  PseudoVNMSAC_VV_MF2_MASK,
  PseudoVNMSAC_VV_MF4,
  PseudoVNMSAC_VV_MF4_MASK,
  PseudoVNMSAC_VV_MF8,
  PseudoVNMSAC_VV_MF8_MASK,
  PseudoVNMSAC_VX_M1,
  PseudoVNMSAC_VX_M1_MASK,
  PseudoVNMSAC_VX_M2,
  PseudoVNMSAC_VX_M2_MASK,
  PseudoVNMSAC_VX_M4,
  PseudoVNMSAC_VX_M4_MASK,
  PseudoVNMSAC_VX_M8,
  PseudoVNMSAC_VX_M8_MASK,
  PseudoVNMSAC_VX_MF2,
  PseudoVNMSAC_VX_MF2_MASK,
  PseudoVNMSAC_VX_MF4,
  PseudoVNMSAC_VX_MF4_MASK,
  PseudoVNMSAC_VX_MF8,
  PseudoVNMSAC_VX_MF8_MASK,
  PseudoVNMSUB_VV_M1,
  PseudoVNMSUB_VV_M1_MASK,
  PseudoVNMSUB_VV_M2,
  PseudoVNMSUB_VV_M2_MASK,
  PseudoVNMSUB_VV_M4,
  PseudoVNMSUB_VV_M4_MASK,
  PseudoVNMSUB_VV_M8,
  PseudoVNMSUB_VV_M8_MASK,
  PseudoVNMSUB_VV_MF2,
  PseudoVNMSUB_VV_MF2_MASK,
  PseudoVNMSUB_VV_MF4,
  PseudoVNMSUB_VV_MF4_MASK,
  PseudoVNMSUB_VV_MF8,
  PseudoVNMSUB_VV_MF8_MASK,
  PseudoVNMSUB_VX_M1,
  PseudoVNMSUB_VX_M1_MASK,
  PseudoVNMSUB_VX_M2,
  PseudoVNMSUB_VX_M2_MASK,
  PseudoVNMSUB_VX_M4,
  PseudoVNMSUB_VX_M4_MASK,
  PseudoVNMSUB_VX_M8,
  PseudoVNMSUB_VX_M8_MASK,
  PseudoVNMSUB_VX_MF2,
  PseudoVNMSUB_VX_MF2_MASK,
  PseudoVNMSUB_VX_MF4,
  PseudoVNMSUB_VX_MF4_MASK,
  PseudoVNMSUB_VX_MF8,
  PseudoVNMSUB_VX_MF8_MASK,
  PseudoVNSRA_WI_M1,
  PseudoVNSRA_WI_M1_MASK,
  PseudoVNSRA_WI_M2,
  PseudoVNSRA_WI_M2_MASK,
  PseudoVNSRA_WI_M4,
  PseudoVNSRA_WI_M4_MASK,
  PseudoVNSRA_WI_MF2,
  PseudoVNSRA_WI_MF2_MASK,
  PseudoVNSRA_WI_MF4,
  PseudoVNSRA_WI_MF4_MASK,
  PseudoVNSRA_WI_MF8,
  PseudoVNSRA_WI_MF8_MASK,
  PseudoVNSRA_WV_M1,
  PseudoVNSRA_WV_M1_MASK,
  PseudoVNSRA_WV_M2,
  PseudoVNSRA_WV_M2_MASK,
  PseudoVNSRA_WV_M4,
  PseudoVNSRA_WV_M4_MASK,
  PseudoVNSRA_WV_MF2,
  PseudoVNSRA_WV_MF2_MASK,
  PseudoVNSRA_WV_MF4,
  PseudoVNSRA_WV_MF4_MASK,
  PseudoVNSRA_WV_MF8,
  PseudoVNSRA_WV_MF8_MASK,
  PseudoVNSRA_WX_M1,
  PseudoVNSRA_WX_M1_MASK,
  PseudoVNSRA_WX_M2,
  PseudoVNSRA_WX_M2_MASK,
  PseudoVNSRA_WX_M4,
  PseudoVNSRA_WX_M4_MASK,
  PseudoVNSRA_WX_MF2,
  PseudoVNSRA_WX_MF2_MASK,
  PseudoVNSRA_WX_MF4,
  PseudoVNSRA_WX_MF4_MASK,
  PseudoVNSRA_WX_MF8,
  PseudoVNSRA_WX_MF8_MASK,
  PseudoVNSRL_WI_M1,
  PseudoVNSRL_WI_M1_MASK,
  PseudoVNSRL_WI_M2,
  PseudoVNSRL_WI_M2_MASK,
  PseudoVNSRL_WI_M4,
  PseudoVNSRL_WI_M4_MASK,
  PseudoVNSRL_WI_MF2,
  PseudoVNSRL_WI_MF2_MASK,
  PseudoVNSRL_WI_MF4,
  PseudoVNSRL_WI_MF4_MASK,
  PseudoVNSRL_WI_MF8,
  PseudoVNSRL_WI_MF8_MASK,
  PseudoVNSRL_WV_M1,
  PseudoVNSRL_WV_M1_MASK,
  PseudoVNSRL_WV_M2,
  PseudoVNSRL_WV_M2_MASK,
  PseudoVNSRL_WV_M4,
  PseudoVNSRL_WV_M4_MASK,
  PseudoVNSRL_WV_MF2,
  PseudoVNSRL_WV_MF2_MASK,
  PseudoVNSRL_WV_MF4,
  PseudoVNSRL_WV_MF4_MASK,
  PseudoVNSRL_WV_MF8,
  PseudoVNSRL_WV_MF8_MASK,
  PseudoVNSRL_WX_M1,
  PseudoVNSRL_WX_M1_MASK,
  PseudoVNSRL_WX_M2,
  PseudoVNSRL_WX_M2_MASK,
  PseudoVNSRL_WX_M4,
  PseudoVNSRL_WX_M4_MASK,
  PseudoVNSRL_WX_MF2,
  PseudoVNSRL_WX_MF2_MASK,
  PseudoVNSRL_WX_MF4,
  PseudoVNSRL_WX_MF4_MASK,
  PseudoVNSRL_WX_MF8,
  PseudoVNSRL_WX_MF8_MASK,
  PseudoVOR_VI_M1,
  PseudoVOR_VI_M1_MASK,
  PseudoVOR_VI_M2,
  PseudoVOR_VI_M2_MASK,
  PseudoVOR_VI_M4,
  PseudoVOR_VI_M4_MASK,
  PseudoVOR_VI_M8,
  PseudoVOR_VI_M8_MASK,
  PseudoVOR_VI_MF2,
  PseudoVOR_VI_MF2_MASK,
  PseudoVOR_VI_MF4,
  PseudoVOR_VI_MF4_MASK,
  PseudoVOR_VI_MF8,
  PseudoVOR_VI_MF8_MASK,
  PseudoVOR_VV_M1,
  PseudoVOR_VV_M1_MASK,
  PseudoVOR_VV_M2,
  PseudoVOR_VV_M2_MASK,
  PseudoVOR_VV_M4,
  PseudoVOR_VV_M4_MASK,
  PseudoVOR_VV_M8,
  PseudoVOR_VV_M8_MASK,
  PseudoVOR_VV_MF2,
  PseudoVOR_VV_MF2_MASK,
  PseudoVOR_VV_MF4,
  PseudoVOR_VV_MF4_MASK,
  PseudoVOR_VV_MF8,
  PseudoVOR_VV_MF8_MASK,
  PseudoVOR_VX_M1,
  PseudoVOR_VX_M1_MASK,
  PseudoVOR_VX_M2,
  PseudoVOR_VX_M2_MASK,
  PseudoVOR_VX_M4,
  PseudoVOR_VX_M4_MASK,
  PseudoVOR_VX_M8,
  PseudoVOR_VX_M8_MASK,
  PseudoVOR_VX_MF2,
  PseudoVOR_VX_MF2_MASK,
  PseudoVOR_VX_MF4,
  PseudoVOR_VX_MF4_MASK,
  PseudoVOR_VX_MF8,
  PseudoVOR_VX_MF8_MASK,
  PseudoVQDOTSU_VV_M1,
  PseudoVQDOTSU_VV_M1_MASK,
  PseudoVQDOTSU_VV_M2,
  PseudoVQDOTSU_VV_M2_MASK,
  PseudoVQDOTSU_VV_M4,
  PseudoVQDOTSU_VV_M4_MASK,
  PseudoVQDOTSU_VV_M8,
  PseudoVQDOTSU_VV_M8_MASK,
  PseudoVQDOTSU_VV_MF2,
  PseudoVQDOTSU_VV_MF2_MASK,
  PseudoVQDOTSU_VX_M1,
  PseudoVQDOTSU_VX_M1_MASK,
  PseudoVQDOTSU_VX_M2,
  PseudoVQDOTSU_VX_M2_MASK,
  PseudoVQDOTSU_VX_M4,
  PseudoVQDOTSU_VX_M4_MASK,
  PseudoVQDOTSU_VX_M8,
  PseudoVQDOTSU_VX_M8_MASK,
  PseudoVQDOTSU_VX_MF2,
  PseudoVQDOTSU_VX_MF2_MASK,
  PseudoVQDOTU_VV_M1,
  PseudoVQDOTU_VV_M1_MASK,
  PseudoVQDOTU_VV_M2,
  PseudoVQDOTU_VV_M2_MASK,
  PseudoVQDOTU_VV_M4,
  PseudoVQDOTU_VV_M4_MASK,
  PseudoVQDOTU_VV_M8,
  PseudoVQDOTU_VV_M8_MASK,
  PseudoVQDOTU_VV_MF2,
  PseudoVQDOTU_VV_MF2_MASK,
  PseudoVQDOTU_VX_M1,
  PseudoVQDOTU_VX_M1_MASK,
  PseudoVQDOTU_VX_M2,
  PseudoVQDOTU_VX_M2_MASK,
  PseudoVQDOTU_VX_M4,
  PseudoVQDOTU_VX_M4_MASK,
  PseudoVQDOTU_VX_M8,
  PseudoVQDOTU_VX_M8_MASK,
  PseudoVQDOTU_VX_MF2,
  PseudoVQDOTU_VX_MF2_MASK,
  PseudoVQDOT_VV_M1,
  PseudoVQDOT_VV_M1_MASK,
  PseudoVQDOT_VV_M2,
  PseudoVQDOT_VV_M2_MASK,
  PseudoVQDOT_VV_M4,
  PseudoVQDOT_VV_M4_MASK,
  PseudoVQDOT_VV_M8,
  PseudoVQDOT_VV_M8_MASK,
  PseudoVQDOT_VV_MF2,
  PseudoVQDOT_VV_MF2_MASK,
  PseudoVQDOT_VX_M1,
  PseudoVQDOT_VX_M1_MASK,
  PseudoVQDOT_VX_M2,
  PseudoVQDOT_VX_M2_MASK,
  PseudoVQDOT_VX_M4,
  PseudoVQDOT_VX_M4_MASK,
  PseudoVQDOT_VX_M8,
  PseudoVQDOT_VX_M8_MASK,
  PseudoVQDOT_VX_MF2,
  PseudoVQDOT_VX_MF2_MASK,
  PseudoVREDAND_VS_M1_E16,
  PseudoVREDAND_VS_M1_E16_MASK,
  PseudoVREDAND_VS_M1_E32,
  PseudoVREDAND_VS_M1_E32_MASK,
  PseudoVREDAND_VS_M1_E64,
  PseudoVREDAND_VS_M1_E64_MASK,
  PseudoVREDAND_VS_M1_E8,
  PseudoVREDAND_VS_M1_E8_MASK,
  PseudoVREDAND_VS_M2_E16,
  PseudoVREDAND_VS_M2_E16_MASK,
  PseudoVREDAND_VS_M2_E32,
  PseudoVREDAND_VS_M2_E32_MASK,
  PseudoVREDAND_VS_M2_E64,
  PseudoVREDAND_VS_M2_E64_MASK,
  PseudoVREDAND_VS_M2_E8,
  PseudoVREDAND_VS_M2_E8_MASK,
  PseudoVREDAND_VS_M4_E16,
  PseudoVREDAND_VS_M4_E16_MASK,
  PseudoVREDAND_VS_M4_E32,
  PseudoVREDAND_VS_M4_E32_MASK,
  PseudoVREDAND_VS_M4_E64,
  PseudoVREDAND_VS_M4_E64_MASK,
  PseudoVREDAND_VS_M4_E8,
  PseudoVREDAND_VS_M4_E8_MASK,
  PseudoVREDAND_VS_M8_E16,
  PseudoVREDAND_VS_M8_E16_MASK,
  PseudoVREDAND_VS_M8_E32,
  PseudoVREDAND_VS_M8_E32_MASK,
  PseudoVREDAND_VS_M8_E64,
  PseudoVREDAND_VS_M8_E64_MASK,
  PseudoVREDAND_VS_M8_E8,
  PseudoVREDAND_VS_M8_E8_MASK,
  PseudoVREDAND_VS_MF2_E16,
  PseudoVREDAND_VS_MF2_E16_MASK,
  PseudoVREDAND_VS_MF2_E32,
  PseudoVREDAND_VS_MF2_E32_MASK,
  PseudoVREDAND_VS_MF2_E8,
  PseudoVREDAND_VS_MF2_E8_MASK,
  PseudoVREDAND_VS_MF4_E16,
  PseudoVREDAND_VS_MF4_E16_MASK,
  PseudoVREDAND_VS_MF4_E8,
  PseudoVREDAND_VS_MF4_E8_MASK,
  PseudoVREDAND_VS_MF8_E8,
  PseudoVREDAND_VS_MF8_E8_MASK,
  PseudoVREDMAXU_VS_M1_E16,
  PseudoVREDMAXU_VS_M1_E16_MASK,
  PseudoVREDMAXU_VS_M1_E32,
  PseudoVREDMAXU_VS_M1_E32_MASK,
  PseudoVREDMAXU_VS_M1_E64,
  PseudoVREDMAXU_VS_M1_E64_MASK,
  PseudoVREDMAXU_VS_M1_E8,
  PseudoVREDMAXU_VS_M1_E8_MASK,
  PseudoVREDMAXU_VS_M2_E16,
  PseudoVREDMAXU_VS_M2_E16_MASK,
  PseudoVREDMAXU_VS_M2_E32,
  PseudoVREDMAXU_VS_M2_E32_MASK,
  PseudoVREDMAXU_VS_M2_E64,
  PseudoVREDMAXU_VS_M2_E64_MASK,
  PseudoVREDMAXU_VS_M2_E8,
  PseudoVREDMAXU_VS_M2_E8_MASK,
  PseudoVREDMAXU_VS_M4_E16,
  PseudoVREDMAXU_VS_M4_E16_MASK,
  PseudoVREDMAXU_VS_M4_E32,
  PseudoVREDMAXU_VS_M4_E32_MASK,
  PseudoVREDMAXU_VS_M4_E64,
  PseudoVREDMAXU_VS_M4_E64_MASK,
  PseudoVREDMAXU_VS_M4_E8,
  PseudoVREDMAXU_VS_M4_E8_MASK,
  PseudoVREDMAXU_VS_M8_E16,
  PseudoVREDMAXU_VS_M8_E16_MASK,
  PseudoVREDMAXU_VS_M8_E32,
  PseudoVREDMAXU_VS_M8_E32_MASK,
  PseudoVREDMAXU_VS_M8_E64,
  PseudoVREDMAXU_VS_M8_E64_MASK,
  PseudoVREDMAXU_VS_M8_E8,
  PseudoVREDMAXU_VS_M8_E8_MASK,
  PseudoVREDMAXU_VS_MF2_E16,
  PseudoVREDMAXU_VS_MF2_E16_MASK,
  PseudoVREDMAXU_VS_MF2_E32,
  PseudoVREDMAXU_VS_MF2_E32_MASK,
  PseudoVREDMAXU_VS_MF2_E8,
  PseudoVREDMAXU_VS_MF2_E8_MASK,
  PseudoVREDMAXU_VS_MF4_E16,
  PseudoVREDMAXU_VS_MF4_E16_MASK,
  PseudoVREDMAXU_VS_MF4_E8,
  PseudoVREDMAXU_VS_MF4_E8_MASK,
  PseudoVREDMAXU_VS_MF8_E8,
  PseudoVREDMAXU_VS_MF8_E8_MASK,
  PseudoVREDMAX_VS_M1_E16,
  PseudoVREDMAX_VS_M1_E16_MASK,
  PseudoVREDMAX_VS_M1_E32,
  PseudoVREDMAX_VS_M1_E32_MASK,
  PseudoVREDMAX_VS_M1_E64,
  PseudoVREDMAX_VS_M1_E64_MASK,
  PseudoVREDMAX_VS_M1_E8,
  PseudoVREDMAX_VS_M1_E8_MASK,
  PseudoVREDMAX_VS_M2_E16,
  PseudoVREDMAX_VS_M2_E16_MASK,
  PseudoVREDMAX_VS_M2_E32,
  PseudoVREDMAX_VS_M2_E32_MASK,
  PseudoVREDMAX_VS_M2_E64,
  PseudoVREDMAX_VS_M2_E64_MASK,
  PseudoVREDMAX_VS_M2_E8,
  PseudoVREDMAX_VS_M2_E8_MASK,
  PseudoVREDMAX_VS_M4_E16,
  PseudoVREDMAX_VS_M4_E16_MASK,
  PseudoVREDMAX_VS_M4_E32,
  PseudoVREDMAX_VS_M4_E32_MASK,
  PseudoVREDMAX_VS_M4_E64,
  PseudoVREDMAX_VS_M4_E64_MASK,
  PseudoVREDMAX_VS_M4_E8,
  PseudoVREDMAX_VS_M4_E8_MASK,
  PseudoVREDMAX_VS_M8_E16,
  PseudoVREDMAX_VS_M8_E16_MASK,
  PseudoVREDMAX_VS_M8_E32,
  PseudoVREDMAX_VS_M8_E32_MASK,
  PseudoVREDMAX_VS_M8_E64,
  PseudoVREDMAX_VS_M8_E64_MASK,
  PseudoVREDMAX_VS_M8_E8,
  PseudoVREDMAX_VS_M8_E8_MASK,
  PseudoVREDMAX_VS_MF2_E16,
  PseudoVREDMAX_VS_MF2_E16_MASK,
  PseudoVREDMAX_VS_MF2_E32,
  PseudoVREDMAX_VS_MF2_E32_MASK,
  PseudoVREDMAX_VS_MF2_E8,
  PseudoVREDMAX_VS_MF2_E8_MASK,
  PseudoVREDMAX_VS_MF4_E16,
  PseudoVREDMAX_VS_MF4_E16_MASK,
  PseudoVREDMAX_VS_MF4_E8,
  PseudoVREDMAX_VS_MF4_E8_MASK,
  PseudoVREDMAX_VS_MF8_E8,
  PseudoVREDMAX_VS_MF8_E8_MASK,
  PseudoVREDMINU_VS_M1_E16,
  PseudoVREDMINU_VS_M1_E16_MASK,
  PseudoVREDMINU_VS_M1_E32,
  PseudoVREDMINU_VS_M1_E32_MASK,
  PseudoVREDMINU_VS_M1_E64,
  PseudoVREDMINU_VS_M1_E64_MASK,
  PseudoVREDMINU_VS_M1_E8,
  PseudoVREDMINU_VS_M1_E8_MASK,
  PseudoVREDMINU_VS_M2_E16,
  PseudoVREDMINU_VS_M2_E16_MASK,
  PseudoVREDMINU_VS_M2_E32,
  PseudoVREDMINU_VS_M2_E32_MASK,
  PseudoVREDMINU_VS_M2_E64,
  PseudoVREDMINU_VS_M2_E64_MASK,
  PseudoVREDMINU_VS_M2_E8,
  PseudoVREDMINU_VS_M2_E8_MASK,
  PseudoVREDMINU_VS_M4_E16,
  PseudoVREDMINU_VS_M4_E16_MASK,
  PseudoVREDMINU_VS_M4_E32,
  PseudoVREDMINU_VS_M4_E32_MASK,
  PseudoVREDMINU_VS_M4_E64,
  PseudoVREDMINU_VS_M4_E64_MASK,
  PseudoVREDMINU_VS_M4_E8,
  PseudoVREDMINU_VS_M4_E8_MASK,
  PseudoVREDMINU_VS_M8_E16,
  PseudoVREDMINU_VS_M8_E16_MASK,
  PseudoVREDMINU_VS_M8_E32,
  PseudoVREDMINU_VS_M8_E32_MASK,
  PseudoVREDMINU_VS_M8_E64,
  PseudoVREDMINU_VS_M8_E64_MASK,
  PseudoVREDMINU_VS_M8_E8,
  PseudoVREDMINU_VS_M8_E8_MASK,
  PseudoVREDMINU_VS_MF2_E16,
  PseudoVREDMINU_VS_MF2_E16_MASK,
  PseudoVREDMINU_VS_MF2_E32,
  PseudoVREDMINU_VS_MF2_E32_MASK,
  PseudoVREDMINU_VS_MF2_E8,
  PseudoVREDMINU_VS_MF2_E8_MASK,
  PseudoVREDMINU_VS_MF4_E16,
  PseudoVREDMINU_VS_MF4_E16_MASK,
  PseudoVREDMINU_VS_MF4_E8,
  PseudoVREDMINU_VS_MF4_E8_MASK,
  PseudoVREDMINU_VS_MF8_E8,
  PseudoVREDMINU_VS_MF8_E8_MASK,
  PseudoVREDMIN_VS_M1_E16,
  PseudoVREDMIN_VS_M1_E16_MASK,
  PseudoVREDMIN_VS_M1_E32,
  PseudoVREDMIN_VS_M1_E32_MASK,
  PseudoVREDMIN_VS_M1_E64,
  PseudoVREDMIN_VS_M1_E64_MASK,
  PseudoVREDMIN_VS_M1_E8,
  PseudoVREDMIN_VS_M1_E8_MASK,
  PseudoVREDMIN_VS_M2_E16,
  PseudoVREDMIN_VS_M2_E16_MASK,
  PseudoVREDMIN_VS_M2_E32,
  PseudoVREDMIN_VS_M2_E32_MASK,
  PseudoVREDMIN_VS_M2_E64,
  PseudoVREDMIN_VS_M2_E64_MASK,
  PseudoVREDMIN_VS_M2_E8,
  PseudoVREDMIN_VS_M2_E8_MASK,
  PseudoVREDMIN_VS_M4_E16,
  PseudoVREDMIN_VS_M4_E16_MASK,
  PseudoVREDMIN_VS_M4_E32,
  PseudoVREDMIN_VS_M4_E32_MASK,
  PseudoVREDMIN_VS_M4_E64,
  PseudoVREDMIN_VS_M4_E64_MASK,
  PseudoVREDMIN_VS_M4_E8,
  PseudoVREDMIN_VS_M4_E8_MASK,
  PseudoVREDMIN_VS_M8_E16,
  PseudoVREDMIN_VS_M8_E16_MASK,
  PseudoVREDMIN_VS_M8_E32,
  PseudoVREDMIN_VS_M8_E32_MASK,
  PseudoVREDMIN_VS_M8_E64,
  PseudoVREDMIN_VS_M8_E64_MASK,
  PseudoVREDMIN_VS_M8_E8,
  PseudoVREDMIN_VS_M8_E8_MASK,
  PseudoVREDMIN_VS_MF2_E16,
  PseudoVREDMIN_VS_MF2_E16_MASK,
  PseudoVREDMIN_VS_MF2_E32,
  PseudoVREDMIN_VS_MF2_E32_MASK,
  PseudoVREDMIN_VS_MF2_E8,
  PseudoVREDMIN_VS_MF2_E8_MASK,
  PseudoVREDMIN_VS_MF4_E16,
  PseudoVREDMIN_VS_MF4_E16_MASK,
  PseudoVREDMIN_VS_MF4_E8,
  PseudoVREDMIN_VS_MF4_E8_MASK,
  PseudoVREDMIN_VS_MF8_E8,
  PseudoVREDMIN_VS_MF8_E8_MASK,
  PseudoVREDOR_VS_M1_E16,
  PseudoVREDOR_VS_M1_E16_MASK,
  PseudoVREDOR_VS_M1_E32,
  PseudoVREDOR_VS_M1_E32_MASK,
  PseudoVREDOR_VS_M1_E64,
  PseudoVREDOR_VS_M1_E64_MASK,
  PseudoVREDOR_VS_M1_E8,
  PseudoVREDOR_VS_M1_E8_MASK,
  PseudoVREDOR_VS_M2_E16,
  PseudoVREDOR_VS_M2_E16_MASK,
  PseudoVREDOR_VS_M2_E32,
  PseudoVREDOR_VS_M2_E32_MASK,
  PseudoVREDOR_VS_M2_E64,
  PseudoVREDOR_VS_M2_E64_MASK,
  PseudoVREDOR_VS_M2_E8,
  PseudoVREDOR_VS_M2_E8_MASK,
  PseudoVREDOR_VS_M4_E16,
  PseudoVREDOR_VS_M4_E16_MASK,
  PseudoVREDOR_VS_M4_E32,
  PseudoVREDOR_VS_M4_E32_MASK,
  PseudoVREDOR_VS_M4_E64,
  PseudoVREDOR_VS_M4_E64_MASK,
  PseudoVREDOR_VS_M4_E8,
  PseudoVREDOR_VS_M4_E8_MASK,
  PseudoVREDOR_VS_M8_E16,
  PseudoVREDOR_VS_M8_E16_MASK,
  PseudoVREDOR_VS_M8_E32,
  PseudoVREDOR_VS_M8_E32_MASK,
  PseudoVREDOR_VS_M8_E64,
  PseudoVREDOR_VS_M8_E64_MASK,
  PseudoVREDOR_VS_M8_E8,
  PseudoVREDOR_VS_M8_E8_MASK,
  PseudoVREDOR_VS_MF2_E16,
  PseudoVREDOR_VS_MF2_E16_MASK,
  PseudoVREDOR_VS_MF2_E32,
  PseudoVREDOR_VS_MF2_E32_MASK,
  PseudoVREDOR_VS_MF2_E8,
  PseudoVREDOR_VS_MF2_E8_MASK,
  PseudoVREDOR_VS_MF4_E16,
  PseudoVREDOR_VS_MF4_E16_MASK,
  PseudoVREDOR_VS_MF4_E8,
  PseudoVREDOR_VS_MF4_E8_MASK,
  PseudoVREDOR_VS_MF8_E8,
  PseudoVREDOR_VS_MF8_E8_MASK,
  PseudoVREDSUM_VS_M1_E16,
  PseudoVREDSUM_VS_M1_E16_MASK,
  PseudoVREDSUM_VS_M1_E32,
  PseudoVREDSUM_VS_M1_E32_MASK,
  PseudoVREDSUM_VS_M1_E64,
  PseudoVREDSUM_VS_M1_E64_MASK,
  PseudoVREDSUM_VS_M1_E8,
  PseudoVREDSUM_VS_M1_E8_MASK,
  PseudoVREDSUM_VS_M2_E16,
  PseudoVREDSUM_VS_M2_E16_MASK,
  PseudoVREDSUM_VS_M2_E32,
  PseudoVREDSUM_VS_M2_E32_MASK,
  PseudoVREDSUM_VS_M2_E64,
  PseudoVREDSUM_VS_M2_E64_MASK,
  PseudoVREDSUM_VS_M2_E8,
  PseudoVREDSUM_VS_M2_E8_MASK,
  PseudoVREDSUM_VS_M4_E16,
  PseudoVREDSUM_VS_M4_E16_MASK,
  PseudoVREDSUM_VS_M4_E32,
  PseudoVREDSUM_VS_M4_E32_MASK,
  PseudoVREDSUM_VS_M4_E64,
  PseudoVREDSUM_VS_M4_E64_MASK,
  PseudoVREDSUM_VS_M4_E8,
  PseudoVREDSUM_VS_M4_E8_MASK,
  PseudoVREDSUM_VS_M8_E16,
  PseudoVREDSUM_VS_M8_E16_MASK,
  PseudoVREDSUM_VS_M8_E32,
  PseudoVREDSUM_VS_M8_E32_MASK,
  PseudoVREDSUM_VS_M8_E64,
  PseudoVREDSUM_VS_M8_E64_MASK,
  PseudoVREDSUM_VS_M8_E8,
  PseudoVREDSUM_VS_M8_E8_MASK,
  PseudoVREDSUM_VS_MF2_E16,
  PseudoVREDSUM_VS_MF2_E16_MASK,
  PseudoVREDSUM_VS_MF2_E32,
  PseudoVREDSUM_VS_MF2_E32_MASK,
  PseudoVREDSUM_VS_MF2_E8,
  PseudoVREDSUM_VS_MF2_E8_MASK,
  PseudoVREDSUM_VS_MF4_E16,
  PseudoVREDSUM_VS_MF4_E16_MASK,
  PseudoVREDSUM_VS_MF4_E8,
  PseudoVREDSUM_VS_MF4_E8_MASK,
  PseudoVREDSUM_VS_MF8_E8,
  PseudoVREDSUM_VS_MF8_E8_MASK,
  PseudoVREDXOR_VS_M1_E16,
  PseudoVREDXOR_VS_M1_E16_MASK,
  PseudoVREDXOR_VS_M1_E32,
  PseudoVREDXOR_VS_M1_E32_MASK,
  PseudoVREDXOR_VS_M1_E64,
  PseudoVREDXOR_VS_M1_E64_MASK,
  PseudoVREDXOR_VS_M1_E8,
  PseudoVREDXOR_VS_M1_E8_MASK,
  PseudoVREDXOR_VS_M2_E16,
  PseudoVREDXOR_VS_M2_E16_MASK,
  PseudoVREDXOR_VS_M2_E32,
  PseudoVREDXOR_VS_M2_E32_MASK,
  PseudoVREDXOR_VS_M2_E64,
  PseudoVREDXOR_VS_M2_E64_MASK,
  PseudoVREDXOR_VS_M2_E8,
  PseudoVREDXOR_VS_M2_E8_MASK,
  PseudoVREDXOR_VS_M4_E16,
  PseudoVREDXOR_VS_M4_E16_MASK,
  PseudoVREDXOR_VS_M4_E32,
  PseudoVREDXOR_VS_M4_E32_MASK,
  PseudoVREDXOR_VS_M4_E64,
  PseudoVREDXOR_VS_M4_E64_MASK,
  PseudoVREDXOR_VS_M4_E8,
  PseudoVREDXOR_VS_M4_E8_MASK,
  PseudoVREDXOR_VS_M8_E16,
  PseudoVREDXOR_VS_M8_E16_MASK,
  PseudoVREDXOR_VS_M8_E32,
  PseudoVREDXOR_VS_M8_E32_MASK,
  PseudoVREDXOR_VS_M8_E64,
  PseudoVREDXOR_VS_M8_E64_MASK,
  PseudoVREDXOR_VS_M8_E8,
  PseudoVREDXOR_VS_M8_E8_MASK,
  PseudoVREDXOR_VS_MF2_E16,
  PseudoVREDXOR_VS_MF2_E16_MASK,
  PseudoVREDXOR_VS_MF2_E32,
  PseudoVREDXOR_VS_MF2_E32_MASK,
  PseudoVREDXOR_VS_MF2_E8,
  PseudoVREDXOR_VS_MF2_E8_MASK,
  PseudoVREDXOR_VS_MF4_E16,
  PseudoVREDXOR_VS_MF4_E16_MASK,
  PseudoVREDXOR_VS_MF4_E8,
  PseudoVREDXOR_VS_MF4_E8_MASK,
  PseudoVREDXOR_VS_MF8_E8,
  PseudoVREDXOR_VS_MF8_E8_MASK,
  PseudoVRELOAD2_M1,
  PseudoVRELOAD2_M2,
  PseudoVRELOAD2_M4,
  PseudoVRELOAD2_MF2,
  PseudoVRELOAD2_MF4,
  PseudoVRELOAD2_MF8,
  PseudoVRELOAD3_M1,
  PseudoVRELOAD3_M2,
  PseudoVRELOAD3_MF2,
  PseudoVRELOAD3_MF4,
  PseudoVRELOAD3_MF8,
  PseudoVRELOAD4_M1,
  PseudoVRELOAD4_M2,
  PseudoVRELOAD4_MF2,
  PseudoVRELOAD4_MF4,
  PseudoVRELOAD4_MF8,
  PseudoVRELOAD5_M1,
  PseudoVRELOAD5_MF2,
  PseudoVRELOAD5_MF4,
  PseudoVRELOAD5_MF8,
  PseudoVRELOAD6_M1,
  PseudoVRELOAD6_MF2,
  PseudoVRELOAD6_MF4,
  PseudoVRELOAD6_MF8,
  PseudoVRELOAD7_M1,
  PseudoVRELOAD7_MF2,
  PseudoVRELOAD7_MF4,
  PseudoVRELOAD7_MF8,
  PseudoVRELOAD8_M1,
  PseudoVRELOAD8_MF2,
  PseudoVRELOAD8_MF4,
  PseudoVRELOAD8_MF8,
  PseudoVREMU_VV_M1_E16,
  PseudoVREMU_VV_M1_E16_MASK,
  PseudoVREMU_VV_M1_E32,
  PseudoVREMU_VV_M1_E32_MASK,
  PseudoVREMU_VV_M1_E64,
  PseudoVREMU_VV_M1_E64_MASK,
  PseudoVREMU_VV_M1_E8,
  PseudoVREMU_VV_M1_E8_MASK,
  PseudoVREMU_VV_M2_E16,
  PseudoVREMU_VV_M2_E16_MASK,
  PseudoVREMU_VV_M2_E32,
  PseudoVREMU_VV_M2_E32_MASK,
  PseudoVREMU_VV_M2_E64,
  PseudoVREMU_VV_M2_E64_MASK,
  PseudoVREMU_VV_M2_E8,
  PseudoVREMU_VV_M2_E8_MASK,
  PseudoVREMU_VV_M4_E16,
  PseudoVREMU_VV_M4_E16_MASK,
  PseudoVREMU_VV_M4_E32,
  PseudoVREMU_VV_M4_E32_MASK,
  PseudoVREMU_VV_M4_E64,
  PseudoVREMU_VV_M4_E64_MASK,
  PseudoVREMU_VV_M4_E8,
  PseudoVREMU_VV_M4_E8_MASK,
  PseudoVREMU_VV_M8_E16,
  PseudoVREMU_VV_M8_E16_MASK,
  PseudoVREMU_VV_M8_E32,
  PseudoVREMU_VV_M8_E32_MASK,
  PseudoVREMU_VV_M8_E64,
  PseudoVREMU_VV_M8_E64_MASK,
  PseudoVREMU_VV_M8_E8,
  PseudoVREMU_VV_M8_E8_MASK,
  PseudoVREMU_VV_MF2_E16,
  PseudoVREMU_VV_MF2_E16_MASK,
  PseudoVREMU_VV_MF2_E32,
  PseudoVREMU_VV_MF2_E32_MASK,
  PseudoVREMU_VV_MF2_E8,
  PseudoVREMU_VV_MF2_E8_MASK,
  PseudoVREMU_VV_MF4_E16,
  PseudoVREMU_VV_MF4_E16_MASK,
  PseudoVREMU_VV_MF4_E8,
  PseudoVREMU_VV_MF4_E8_MASK,
  PseudoVREMU_VV_MF8_E8,
  PseudoVREMU_VV_MF8_E8_MASK,
  PseudoVREMU_VX_M1_E16,
  PseudoVREMU_VX_M1_E16_MASK,
  PseudoVREMU_VX_M1_E32,
  PseudoVREMU_VX_M1_E32_MASK,
  PseudoVREMU_VX_M1_E64,
  PseudoVREMU_VX_M1_E64_MASK,
  PseudoVREMU_VX_M1_E8,
  PseudoVREMU_VX_M1_E8_MASK,
  PseudoVREMU_VX_M2_E16,
  PseudoVREMU_VX_M2_E16_MASK,
  PseudoVREMU_VX_M2_E32,
  PseudoVREMU_VX_M2_E32_MASK,
  PseudoVREMU_VX_M2_E64,
  PseudoVREMU_VX_M2_E64_MASK,
  PseudoVREMU_VX_M2_E8,
  PseudoVREMU_VX_M2_E8_MASK,
  PseudoVREMU_VX_M4_E16,
  PseudoVREMU_VX_M4_E16_MASK,
  PseudoVREMU_VX_M4_E32,
  PseudoVREMU_VX_M4_E32_MASK,
  PseudoVREMU_VX_M4_E64,
  PseudoVREMU_VX_M4_E64_MASK,
  PseudoVREMU_VX_M4_E8,
  PseudoVREMU_VX_M4_E8_MASK,
  PseudoVREMU_VX_M8_E16,
  PseudoVREMU_VX_M8_E16_MASK,
  PseudoVREMU_VX_M8_E32,
  PseudoVREMU_VX_M8_E32_MASK,
  PseudoVREMU_VX_M8_E64,
  PseudoVREMU_VX_M8_E64_MASK,
  PseudoVREMU_VX_M8_E8,
  PseudoVREMU_VX_M8_E8_MASK,
  PseudoVREMU_VX_MF2_E16,
  PseudoVREMU_VX_MF2_E16_MASK,
  PseudoVREMU_VX_MF2_E32,
  PseudoVREMU_VX_MF2_E32_MASK,
  PseudoVREMU_VX_MF2_E8,
  PseudoVREMU_VX_MF2_E8_MASK,
  PseudoVREMU_VX_MF4_E16,
  PseudoVREMU_VX_MF4_E16_MASK,
  PseudoVREMU_VX_MF4_E8,
  PseudoVREMU_VX_MF4_E8_MASK,
  PseudoVREMU_VX_MF8_E8,
  PseudoVREMU_VX_MF8_E8_MASK,
  PseudoVREM_VV_M1_E16,
  PseudoVREM_VV_M1_E16_MASK,
  PseudoVREM_VV_M1_E32,
  PseudoVREM_VV_M1_E32_MASK,
  PseudoVREM_VV_M1_E64,
  PseudoVREM_VV_M1_E64_MASK,
  PseudoVREM_VV_M1_E8,
  PseudoVREM_VV_M1_E8_MASK,
  PseudoVREM_VV_M2_E16,
  PseudoVREM_VV_M2_E16_MASK,
  PseudoVREM_VV_M2_E32,
  PseudoVREM_VV_M2_E32_MASK,
  PseudoVREM_VV_M2_E64,
  PseudoVREM_VV_M2_E64_MASK,
  PseudoVREM_VV_M2_E8,
  PseudoVREM_VV_M2_E8_MASK,
  PseudoVREM_VV_M4_E16,
  PseudoVREM_VV_M4_E16_MASK,
  PseudoVREM_VV_M4_E32,
  PseudoVREM_VV_M4_E32_MASK,
  PseudoVREM_VV_M4_E64,
  PseudoVREM_VV_M4_E64_MASK,
  PseudoVREM_VV_M4_E8,
  PseudoVREM_VV_M4_E8_MASK,
  PseudoVREM_VV_M8_E16,
  PseudoVREM_VV_M8_E16_MASK,
  PseudoVREM_VV_M8_E32,
  PseudoVREM_VV_M8_E32_MASK,
  PseudoVREM_VV_M8_E64,
  PseudoVREM_VV_M8_E64_MASK,
  PseudoVREM_VV_M8_E8,
  PseudoVREM_VV_M8_E8_MASK,
  PseudoVREM_VV_MF2_E16,
  PseudoVREM_VV_MF2_E16_MASK,
  PseudoVREM_VV_MF2_E32,
  PseudoVREM_VV_MF2_E32_MASK,
  PseudoVREM_VV_MF2_E8,
  PseudoVREM_VV_MF2_E8_MASK,
  PseudoVREM_VV_MF4_E16,
  PseudoVREM_VV_MF4_E16_MASK,
  PseudoVREM_VV_MF4_E8,
  PseudoVREM_VV_MF4_E8_MASK,
  PseudoVREM_VV_MF8_E8,
  PseudoVREM_VV_MF8_E8_MASK,
  PseudoVREM_VX_M1_E16,
  PseudoVREM_VX_M1_E16_MASK,
  PseudoVREM_VX_M1_E32,
  PseudoVREM_VX_M1_E32_MASK,
  PseudoVREM_VX_M1_E64,
  PseudoVREM_VX_M1_E64_MASK,
  PseudoVREM_VX_M1_E8,
  PseudoVREM_VX_M1_E8_MASK,
  PseudoVREM_VX_M2_E16,
  PseudoVREM_VX_M2_E16_MASK,
  PseudoVREM_VX_M2_E32,
  PseudoVREM_VX_M2_E32_MASK,
  PseudoVREM_VX_M2_E64,
  PseudoVREM_VX_M2_E64_MASK,
  PseudoVREM_VX_M2_E8,
  PseudoVREM_VX_M2_E8_MASK,
  PseudoVREM_VX_M4_E16,
  PseudoVREM_VX_M4_E16_MASK,
  PseudoVREM_VX_M4_E32,
  PseudoVREM_VX_M4_E32_MASK,
  PseudoVREM_VX_M4_E64,
  PseudoVREM_VX_M4_E64_MASK,
  PseudoVREM_VX_M4_E8,
  PseudoVREM_VX_M4_E8_MASK,
  PseudoVREM_VX_M8_E16,
  PseudoVREM_VX_M8_E16_MASK,
  PseudoVREM_VX_M8_E32,
  PseudoVREM_VX_M8_E32_MASK,
  PseudoVREM_VX_M8_E64,
  PseudoVREM_VX_M8_E64_MASK,
  PseudoVREM_VX_M8_E8,
  PseudoVREM_VX_M8_E8_MASK,
  PseudoVREM_VX_MF2_E16,
  PseudoVREM_VX_MF2_E16_MASK,
  PseudoVREM_VX_MF2_E32,
  PseudoVREM_VX_MF2_E32_MASK,
  PseudoVREM_VX_MF2_E8,
  PseudoVREM_VX_MF2_E8_MASK,
  PseudoVREM_VX_MF4_E16,
  PseudoVREM_VX_MF4_E16_MASK,
  PseudoVREM_VX_MF4_E8,
  PseudoVREM_VX_MF4_E8_MASK,
  PseudoVREM_VX_MF8_E8,
  PseudoVREM_VX_MF8_E8_MASK,
  PseudoVREV8_V_M1,
  PseudoVREV8_V_M1_MASK,
  PseudoVREV8_V_M2,
  PseudoVREV8_V_M2_MASK,
  PseudoVREV8_V_M4,
  PseudoVREV8_V_M4_MASK,
  PseudoVREV8_V_M8,
  PseudoVREV8_V_M8_MASK,
  PseudoVREV8_V_MF2,
  PseudoVREV8_V_MF2_MASK,
  PseudoVREV8_V_MF4,
  PseudoVREV8_V_MF4_MASK,
  PseudoVREV8_V_MF8,
  PseudoVREV8_V_MF8_MASK,
  PseudoVRGATHEREI16_VV_M1_E16_M1,
  PseudoVRGATHEREI16_VV_M1_E16_M1_MASK,
  PseudoVRGATHEREI16_VV_M1_E16_M2,
  PseudoVRGATHEREI16_VV_M1_E16_M2_MASK,
  PseudoVRGATHEREI16_VV_M1_E16_MF2,
  PseudoVRGATHEREI16_VV_M1_E16_MF2_MASK,
  PseudoVRGATHEREI16_VV_M1_E16_MF4,
  PseudoVRGATHEREI16_VV_M1_E16_MF4_MASK,
  PseudoVRGATHEREI16_VV_M1_E32_M1,
  PseudoVRGATHEREI16_VV_M1_E32_M1_MASK,
  PseudoVRGATHEREI16_VV_M1_E32_M2,
  PseudoVRGATHEREI16_VV_M1_E32_M2_MASK,
  PseudoVRGATHEREI16_VV_M1_E32_MF2,
  PseudoVRGATHEREI16_VV_M1_E32_MF2_MASK,
  PseudoVRGATHEREI16_VV_M1_E32_MF4,
  PseudoVRGATHEREI16_VV_M1_E32_MF4_MASK,
  PseudoVRGATHEREI16_VV_M1_E64_M1,
  PseudoVRGATHEREI16_VV_M1_E64_M1_MASK,
  PseudoVRGATHEREI16_VV_M1_E64_M2,
  PseudoVRGATHEREI16_VV_M1_E64_M2_MASK,
  PseudoVRGATHEREI16_VV_M1_E64_MF2,
  PseudoVRGATHEREI16_VV_M1_E64_MF2_MASK,
  PseudoVRGATHEREI16_VV_M1_E64_MF4,
  PseudoVRGATHEREI16_VV_M1_E64_MF4_MASK,
  PseudoVRGATHEREI16_VV_M1_E8_M1,
  PseudoVRGATHEREI16_VV_M1_E8_M1_MASK,
  PseudoVRGATHEREI16_VV_M1_E8_M2,
  PseudoVRGATHEREI16_VV_M1_E8_M2_MASK,
  PseudoVRGATHEREI16_VV_M1_E8_MF2,
  PseudoVRGATHEREI16_VV_M1_E8_MF2_MASK,
  PseudoVRGATHEREI16_VV_M1_E8_MF4,
  PseudoVRGATHEREI16_VV_M1_E8_MF4_MASK,
  PseudoVRGATHEREI16_VV_M2_E16_M1,
  PseudoVRGATHEREI16_VV_M2_E16_M1_MASK,
  PseudoVRGATHEREI16_VV_M2_E16_M2,
  PseudoVRGATHEREI16_VV_M2_E16_M2_MASK,
  PseudoVRGATHEREI16_VV_M2_E16_M4,
  PseudoVRGATHEREI16_VV_M2_E16_M4_MASK,
  PseudoVRGATHEREI16_VV_M2_E16_MF2,
  PseudoVRGATHEREI16_VV_M2_E16_MF2_MASK,
  PseudoVRGATHEREI16_VV_M2_E32_M1,
  PseudoVRGATHEREI16_VV_M2_E32_M1_MASK,
  PseudoVRGATHEREI16_VV_M2_E32_M2,
  PseudoVRGATHEREI16_VV_M2_E32_M2_MASK,
  PseudoVRGATHEREI16_VV_M2_E32_M4,
  PseudoVRGATHEREI16_VV_M2_E32_M4_MASK,
  PseudoVRGATHEREI16_VV_M2_E32_MF2,
  PseudoVRGATHEREI16_VV_M2_E32_MF2_MASK,
  PseudoVRGATHEREI16_VV_M2_E64_M1,
  PseudoVRGATHEREI16_VV_M2_E64_M1_MASK,
  PseudoVRGATHEREI16_VV_M2_E64_M2,
  PseudoVRGATHEREI16_VV_M2_E64_M2_MASK,
  PseudoVRGATHEREI16_VV_M2_E64_M4,
  PseudoVRGATHEREI16_VV_M2_E64_M4_MASK,
  PseudoVRGATHEREI16_VV_M2_E64_MF2,
  PseudoVRGATHEREI16_VV_M2_E64_MF2_MASK,
  PseudoVRGATHEREI16_VV_M2_E8_M1,
  PseudoVRGATHEREI16_VV_M2_E8_M1_MASK,
  PseudoVRGATHEREI16_VV_M2_E8_M2,
  PseudoVRGATHEREI16_VV_M2_E8_M2_MASK,
  PseudoVRGATHEREI16_VV_M2_E8_M4,
  PseudoVRGATHEREI16_VV_M2_E8_M4_MASK,
  PseudoVRGATHEREI16_VV_M2_E8_MF2,
  PseudoVRGATHEREI16_VV_M2_E8_MF2_MASK,
  PseudoVRGATHEREI16_VV_M4_E16_M1,
  PseudoVRGATHEREI16_VV_M4_E16_M1_MASK,
  PseudoVRGATHEREI16_VV_M4_E16_M2,
  PseudoVRGATHEREI16_VV_M4_E16_M2_MASK,
  PseudoVRGATHEREI16_VV_M4_E16_M4,
  PseudoVRGATHEREI16_VV_M4_E16_M4_MASK,
  PseudoVRGATHEREI16_VV_M4_E16_M8,
  PseudoVRGATHEREI16_VV_M4_E16_M8_MASK,
  PseudoVRGATHEREI16_VV_M4_E32_M1,
  PseudoVRGATHEREI16_VV_M4_E32_M1_MASK,
  PseudoVRGATHEREI16_VV_M4_E32_M2,
  PseudoVRGATHEREI16_VV_M4_E32_M2_MASK,
  PseudoVRGATHEREI16_VV_M4_E32_M4,
  PseudoVRGATHEREI16_VV_M4_E32_M4_MASK,
  PseudoVRGATHEREI16_VV_M4_E32_M8,
  PseudoVRGATHEREI16_VV_M4_E32_M8_MASK,
  PseudoVRGATHEREI16_VV_M4_E64_M1,
  PseudoVRGATHEREI16_VV_M4_E64_M1_MASK,
  PseudoVRGATHEREI16_VV_M4_E64_M2,
  PseudoVRGATHEREI16_VV_M4_E64_M2_MASK,
  PseudoVRGATHEREI16_VV_M4_E64_M4,
  PseudoVRGATHEREI16_VV_M4_E64_M4_MASK,
  PseudoVRGATHEREI16_VV_M4_E64_M8,
  PseudoVRGATHEREI16_VV_M4_E64_M8_MASK,
  PseudoVRGATHEREI16_VV_M4_E8_M1,
  PseudoVRGATHEREI16_VV_M4_E8_M1_MASK,
  PseudoVRGATHEREI16_VV_M4_E8_M2,
  PseudoVRGATHEREI16_VV_M4_E8_M2_MASK,
  PseudoVRGATHEREI16_VV_M4_E8_M4,
  PseudoVRGATHEREI16_VV_M4_E8_M4_MASK,
  PseudoVRGATHEREI16_VV_M4_E8_M8,
  PseudoVRGATHEREI16_VV_M4_E8_M8_MASK,
  PseudoVRGATHEREI16_VV_M8_E16_M2,
  PseudoVRGATHEREI16_VV_M8_E16_M2_MASK,
  PseudoVRGATHEREI16_VV_M8_E16_M4,
  PseudoVRGATHEREI16_VV_M8_E16_M4_MASK,
  PseudoVRGATHEREI16_VV_M8_E16_M8,
  PseudoVRGATHEREI16_VV_M8_E16_M8_MASK,
  PseudoVRGATHEREI16_VV_M8_E32_M2,
  PseudoVRGATHEREI16_VV_M8_E32_M2_MASK,
  PseudoVRGATHEREI16_VV_M8_E32_M4,
  PseudoVRGATHEREI16_VV_M8_E32_M4_MASK,
  PseudoVRGATHEREI16_VV_M8_E32_M8,
  PseudoVRGATHEREI16_VV_M8_E32_M8_MASK,
  PseudoVRGATHEREI16_VV_M8_E64_M2,
  PseudoVRGATHEREI16_VV_M8_E64_M2_MASK,
  PseudoVRGATHEREI16_VV_M8_E64_M4,
  PseudoVRGATHEREI16_VV_M8_E64_M4_MASK,
  PseudoVRGATHEREI16_VV_M8_E64_M8,
  PseudoVRGATHEREI16_VV_M8_E64_M8_MASK,
  PseudoVRGATHEREI16_VV_M8_E8_M2,
  PseudoVRGATHEREI16_VV_M8_E8_M2_MASK,
  PseudoVRGATHEREI16_VV_M8_E8_M4,
  PseudoVRGATHEREI16_VV_M8_E8_M4_MASK,
  PseudoVRGATHEREI16_VV_M8_E8_M8,
  PseudoVRGATHEREI16_VV_M8_E8_M8_MASK,
  PseudoVRGATHEREI16_VV_MF2_E16_M1,
  PseudoVRGATHEREI16_VV_MF2_E16_M1_MASK,
  PseudoVRGATHEREI16_VV_MF2_E16_MF2,
  PseudoVRGATHEREI16_VV_MF2_E16_MF2_MASK,
  PseudoVRGATHEREI16_VV_MF2_E16_MF4,
  PseudoVRGATHEREI16_VV_MF2_E16_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF2_E16_MF8,
  PseudoVRGATHEREI16_VV_MF2_E16_MF8_MASK,
  PseudoVRGATHEREI16_VV_MF2_E32_M1,
  PseudoVRGATHEREI16_VV_MF2_E32_M1_MASK,
  PseudoVRGATHEREI16_VV_MF2_E32_MF2,
  PseudoVRGATHEREI16_VV_MF2_E32_MF2_MASK,
  PseudoVRGATHEREI16_VV_MF2_E32_MF4,
  PseudoVRGATHEREI16_VV_MF2_E32_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF2_E32_MF8,
  PseudoVRGATHEREI16_VV_MF2_E32_MF8_MASK,
  PseudoVRGATHEREI16_VV_MF2_E8_M1,
  PseudoVRGATHEREI16_VV_MF2_E8_M1_MASK,
  PseudoVRGATHEREI16_VV_MF2_E8_MF2,
  PseudoVRGATHEREI16_VV_MF2_E8_MF2_MASK,
  PseudoVRGATHEREI16_VV_MF2_E8_MF4,
  PseudoVRGATHEREI16_VV_MF2_E8_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF2_E8_MF8,
  PseudoVRGATHEREI16_VV_MF2_E8_MF8_MASK,
  PseudoVRGATHEREI16_VV_MF4_E16_MF2,
  PseudoVRGATHEREI16_VV_MF4_E16_MF2_MASK,
  PseudoVRGATHEREI16_VV_MF4_E16_MF4,
  PseudoVRGATHEREI16_VV_MF4_E16_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF4_E16_MF8,
  PseudoVRGATHEREI16_VV_MF4_E16_MF8_MASK,
  PseudoVRGATHEREI16_VV_MF4_E8_MF2,
  PseudoVRGATHEREI16_VV_MF4_E8_MF2_MASK,
  PseudoVRGATHEREI16_VV_MF4_E8_MF4,
  PseudoVRGATHEREI16_VV_MF4_E8_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF4_E8_MF8,
  PseudoVRGATHEREI16_VV_MF4_E8_MF8_MASK,
  PseudoVRGATHEREI16_VV_MF8_E8_MF4,
  PseudoVRGATHEREI16_VV_MF8_E8_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF8_E8_MF8,
  PseudoVRGATHEREI16_VV_MF8_E8_MF8_MASK,
  PseudoVRGATHER_VI_M1,
  PseudoVRGATHER_VI_M1_MASK,
  PseudoVRGATHER_VI_M2,
  PseudoVRGATHER_VI_M2_MASK,
  PseudoVRGATHER_VI_M4,
  PseudoVRGATHER_VI_M4_MASK,
  PseudoVRGATHER_VI_M8,
  PseudoVRGATHER_VI_M8_MASK,
  PseudoVRGATHER_VI_MF2,
  PseudoVRGATHER_VI_MF2_MASK,
  PseudoVRGATHER_VI_MF4,
  PseudoVRGATHER_VI_MF4_MASK,
  PseudoVRGATHER_VI_MF8,
  PseudoVRGATHER_VI_MF8_MASK,
  PseudoVRGATHER_VV_M1_E16,
  PseudoVRGATHER_VV_M1_E16_MASK,
  PseudoVRGATHER_VV_M1_E32,
  PseudoVRGATHER_VV_M1_E32_MASK,
  PseudoVRGATHER_VV_M1_E64,
  PseudoVRGATHER_VV_M1_E64_MASK,
  PseudoVRGATHER_VV_M1_E8,
  PseudoVRGATHER_VV_M1_E8_MASK,
  PseudoVRGATHER_VV_M2_E16,
  PseudoVRGATHER_VV_M2_E16_MASK,
  PseudoVRGATHER_VV_M2_E32,
  PseudoVRGATHER_VV_M2_E32_MASK,
  PseudoVRGATHER_VV_M2_E64,
  PseudoVRGATHER_VV_M2_E64_MASK,
  PseudoVRGATHER_VV_M2_E8,
  PseudoVRGATHER_VV_M2_E8_MASK,
  PseudoVRGATHER_VV_M4_E16,
  PseudoVRGATHER_VV_M4_E16_MASK,
  PseudoVRGATHER_VV_M4_E32,
  PseudoVRGATHER_VV_M4_E32_MASK,
  PseudoVRGATHER_VV_M4_E64,
  PseudoVRGATHER_VV_M4_E64_MASK,
  PseudoVRGATHER_VV_M4_E8,
  PseudoVRGATHER_VV_M4_E8_MASK,
  PseudoVRGATHER_VV_M8_E16,
  PseudoVRGATHER_VV_M8_E16_MASK,
  PseudoVRGATHER_VV_M8_E32,
  PseudoVRGATHER_VV_M8_E32_MASK,
  PseudoVRGATHER_VV_M8_E64,
  PseudoVRGATHER_VV_M8_E64_MASK,
  PseudoVRGATHER_VV_M8_E8,
  PseudoVRGATHER_VV_M8_E8_MASK,
  PseudoVRGATHER_VV_MF2_E16,
  PseudoVRGATHER_VV_MF2_E16_MASK,
  PseudoVRGATHER_VV_MF2_E32,
  PseudoVRGATHER_VV_MF2_E32_MASK,
  PseudoVRGATHER_VV_MF2_E8,
  PseudoVRGATHER_VV_MF2_E8_MASK,
  PseudoVRGATHER_VV_MF4_E16,
  PseudoVRGATHER_VV_MF4_E16_MASK,
  PseudoVRGATHER_VV_MF4_E8,
  PseudoVRGATHER_VV_MF4_E8_MASK,
  PseudoVRGATHER_VV_MF8_E8,
  PseudoVRGATHER_VV_MF8_E8_MASK,
  PseudoVRGATHER_VX_M1,
  PseudoVRGATHER_VX_M1_MASK,
  PseudoVRGATHER_VX_M2,
  PseudoVRGATHER_VX_M2_MASK,
  PseudoVRGATHER_VX_M4,
  PseudoVRGATHER_VX_M4_MASK,
  PseudoVRGATHER_VX_M8,
  PseudoVRGATHER_VX_M8_MASK,
  PseudoVRGATHER_VX_MF2,
  PseudoVRGATHER_VX_MF2_MASK,
  PseudoVRGATHER_VX_MF4,
  PseudoVRGATHER_VX_MF4_MASK,
  PseudoVRGATHER_VX_MF8,
  PseudoVRGATHER_VX_MF8_MASK,
  PseudoVROL_VV_M1,
  PseudoVROL_VV_M1_MASK,
  PseudoVROL_VV_M2,
  PseudoVROL_VV_M2_MASK,
  PseudoVROL_VV_M4,
  PseudoVROL_VV_M4_MASK,
  PseudoVROL_VV_M8,
  PseudoVROL_VV_M8_MASK,
  PseudoVROL_VV_MF2,
  PseudoVROL_VV_MF2_MASK,
  PseudoVROL_VV_MF4,
  PseudoVROL_VV_MF4_MASK,
  PseudoVROL_VV_MF8,
  PseudoVROL_VV_MF8_MASK,
  PseudoVROL_VX_M1,
  PseudoVROL_VX_M1_MASK,
  PseudoVROL_VX_M2,
  PseudoVROL_VX_M2_MASK,
  PseudoVROL_VX_M4,
  PseudoVROL_VX_M4_MASK,
  PseudoVROL_VX_M8,
  PseudoVROL_VX_M8_MASK,
  PseudoVROL_VX_MF2,
  PseudoVROL_VX_MF2_MASK,
  PseudoVROL_VX_MF4,
  PseudoVROL_VX_MF4_MASK,
  PseudoVROL_VX_MF8,
  PseudoVROL_VX_MF8_MASK,
  PseudoVROR_VI_M1,
  PseudoVROR_VI_M1_MASK,
  PseudoVROR_VI_M2,
  PseudoVROR_VI_M2_MASK,
  PseudoVROR_VI_M4,
  PseudoVROR_VI_M4_MASK,
  PseudoVROR_VI_M8,
  PseudoVROR_VI_M8_MASK,
  PseudoVROR_VI_MF2,
  PseudoVROR_VI_MF2_MASK,
  PseudoVROR_VI_MF4,
  PseudoVROR_VI_MF4_MASK,
  PseudoVROR_VI_MF8,
  PseudoVROR_VI_MF8_MASK,
  PseudoVROR_VV_M1,
  PseudoVROR_VV_M1_MASK,
  PseudoVROR_VV_M2,
  PseudoVROR_VV_M2_MASK,
  PseudoVROR_VV_M4,
  PseudoVROR_VV_M4_MASK,
  PseudoVROR_VV_M8,
  PseudoVROR_VV_M8_MASK,
  PseudoVROR_VV_MF2,
  PseudoVROR_VV_MF2_MASK,
  PseudoVROR_VV_MF4,
  PseudoVROR_VV_MF4_MASK,
  PseudoVROR_VV_MF8,
  PseudoVROR_VV_MF8_MASK,
  PseudoVROR_VX_M1,
  PseudoVROR_VX_M1_MASK,
  PseudoVROR_VX_M2,
  PseudoVROR_VX_M2_MASK,
  PseudoVROR_VX_M4,
  PseudoVROR_VX_M4_MASK,
  PseudoVROR_VX_M8,
  PseudoVROR_VX_M8_MASK,
  PseudoVROR_VX_MF2,
  PseudoVROR_VX_MF2_MASK,
  PseudoVROR_VX_MF4,
  PseudoVROR_VX_MF4_MASK,
  PseudoVROR_VX_MF8,
  PseudoVROR_VX_MF8_MASK,
  PseudoVRSUB_VI_M1,
  PseudoVRSUB_VI_M1_MASK,
  PseudoVRSUB_VI_M2,
  PseudoVRSUB_VI_M2_MASK,
  PseudoVRSUB_VI_M4,
  PseudoVRSUB_VI_M4_MASK,
  PseudoVRSUB_VI_M8,
  PseudoVRSUB_VI_M8_MASK,
  PseudoVRSUB_VI_MF2,
  PseudoVRSUB_VI_MF2_MASK,
  PseudoVRSUB_VI_MF4,
  PseudoVRSUB_VI_MF4_MASK,
  PseudoVRSUB_VI_MF8,
  PseudoVRSUB_VI_MF8_MASK,
  PseudoVRSUB_VX_M1,
  PseudoVRSUB_VX_M1_MASK,
  PseudoVRSUB_VX_M2,
  PseudoVRSUB_VX_M2_MASK,
  PseudoVRSUB_VX_M4,
  PseudoVRSUB_VX_M4_MASK,
  PseudoVRSUB_VX_M8,
  PseudoVRSUB_VX_M8_MASK,
  PseudoVRSUB_VX_MF2,
  PseudoVRSUB_VX_MF2_MASK,
  PseudoVRSUB_VX_MF4,
  PseudoVRSUB_VX_MF4_MASK,
  PseudoVRSUB_VX_MF8,
  PseudoVRSUB_VX_MF8_MASK,
  PseudoVSADDU_VI_M1,
  PseudoVSADDU_VI_M1_MASK,
  PseudoVSADDU_VI_M2,
  PseudoVSADDU_VI_M2_MASK,
  PseudoVSADDU_VI_M4,
  PseudoVSADDU_VI_M4_MASK,
  PseudoVSADDU_VI_M8,
  PseudoVSADDU_VI_M8_MASK,
  PseudoVSADDU_VI_MF2,
  PseudoVSADDU_VI_MF2_MASK,
  PseudoVSADDU_VI_MF4,
  PseudoVSADDU_VI_MF4_MASK,
  PseudoVSADDU_VI_MF8,
  PseudoVSADDU_VI_MF8_MASK,
  PseudoVSADDU_VV_M1,
  PseudoVSADDU_VV_M1_MASK,
  PseudoVSADDU_VV_M2,
  PseudoVSADDU_VV_M2_MASK,
  PseudoVSADDU_VV_M4,
  PseudoVSADDU_VV_M4_MASK,
  PseudoVSADDU_VV_M8,
  PseudoVSADDU_VV_M8_MASK,
  PseudoVSADDU_VV_MF2,
  PseudoVSADDU_VV_MF2_MASK,
  PseudoVSADDU_VV_MF4,
  PseudoVSADDU_VV_MF4_MASK,
  PseudoVSADDU_VV_MF8,
  PseudoVSADDU_VV_MF8_MASK,
  PseudoVSADDU_VX_M1,
  PseudoVSADDU_VX_M1_MASK,
  PseudoVSADDU_VX_M2,
  PseudoVSADDU_VX_M2_MASK,
  PseudoVSADDU_VX_M4,
  PseudoVSADDU_VX_M4_MASK,
  PseudoVSADDU_VX_M8,
  PseudoVSADDU_VX_M8_MASK,
  PseudoVSADDU_VX_MF2,
  PseudoVSADDU_VX_MF2_MASK,
  PseudoVSADDU_VX_MF4,
  PseudoVSADDU_VX_MF4_MASK,
  PseudoVSADDU_VX_MF8,
  PseudoVSADDU_VX_MF8_MASK,
  PseudoVSADD_VI_M1,
  PseudoVSADD_VI_M1_MASK,
  PseudoVSADD_VI_M2,
  PseudoVSADD_VI_M2_MASK,
  PseudoVSADD_VI_M4,
  PseudoVSADD_VI_M4_MASK,
  PseudoVSADD_VI_M8,
  PseudoVSADD_VI_M8_MASK,
  PseudoVSADD_VI_MF2,
  PseudoVSADD_VI_MF2_MASK,
  PseudoVSADD_VI_MF4,
  PseudoVSADD_VI_MF4_MASK,
  PseudoVSADD_VI_MF8,
  PseudoVSADD_VI_MF8_MASK,
  PseudoVSADD_VV_M1,
  PseudoVSADD_VV_M1_MASK,
  PseudoVSADD_VV_M2,
  PseudoVSADD_VV_M2_MASK,
  PseudoVSADD_VV_M4,
  PseudoVSADD_VV_M4_MASK,
  PseudoVSADD_VV_M8,
  PseudoVSADD_VV_M8_MASK,
  PseudoVSADD_VV_MF2,
  PseudoVSADD_VV_MF2_MASK,
  PseudoVSADD_VV_MF4,
  PseudoVSADD_VV_MF4_MASK,
  PseudoVSADD_VV_MF8,
  PseudoVSADD_VV_MF8_MASK,
  PseudoVSADD_VX_M1,
  PseudoVSADD_VX_M1_MASK,
  PseudoVSADD_VX_M2,
  PseudoVSADD_VX_M2_MASK,
  PseudoVSADD_VX_M4,
  PseudoVSADD_VX_M4_MASK,
  PseudoVSADD_VX_M8,
  PseudoVSADD_VX_M8_MASK,
  PseudoVSADD_VX_MF2,
  PseudoVSADD_VX_MF2_MASK,
  PseudoVSADD_VX_MF4,
  PseudoVSADD_VX_MF4_MASK,
  PseudoVSADD_VX_MF8,
  PseudoVSADD_VX_MF8_MASK,
  PseudoVSBC_VVM_M1,
  PseudoVSBC_VVM_M2,
  PseudoVSBC_VVM_M4,
  PseudoVSBC_VVM_M8,
  PseudoVSBC_VVM_MF2,
  PseudoVSBC_VVM_MF4,
  PseudoVSBC_VVM_MF8,
  PseudoVSBC_VXM_M1,
  PseudoVSBC_VXM_M2,
  PseudoVSBC_VXM_M4,
  PseudoVSBC_VXM_M8,
  PseudoVSBC_VXM_MF2,
  PseudoVSBC_VXM_MF4,
  PseudoVSBC_VXM_MF8,
  PseudoVSE16_V_M1,
  PseudoVSE16_V_M1_MASK,
  PseudoVSE16_V_M2,
  PseudoVSE16_V_M2_MASK,
  PseudoVSE16_V_M4,
  PseudoVSE16_V_M4_MASK,
  PseudoVSE16_V_M8,
  PseudoVSE16_V_M8_MASK,
  PseudoVSE16_V_MF2,
  PseudoVSE16_V_MF2_MASK,
  PseudoVSE16_V_MF4,
  PseudoVSE16_V_MF4_MASK,
  PseudoVSE32_V_M1,
  PseudoVSE32_V_M1_MASK,
  PseudoVSE32_V_M2,
  PseudoVSE32_V_M2_MASK,
  PseudoVSE32_V_M4,
  PseudoVSE32_V_M4_MASK,
  PseudoVSE32_V_M8,
  PseudoVSE32_V_M8_MASK,
  PseudoVSE32_V_MF2,
  PseudoVSE32_V_MF2_MASK,
  PseudoVSE64_V_M1,
  PseudoVSE64_V_M1_MASK,
  PseudoVSE64_V_M2,
  PseudoVSE64_V_M2_MASK,
  PseudoVSE64_V_M4,
  PseudoVSE64_V_M4_MASK,
  PseudoVSE64_V_M8,
  PseudoVSE64_V_M8_MASK,
  PseudoVSE8_V_M1,
  PseudoVSE8_V_M1_MASK,
  PseudoVSE8_V_M2,
  PseudoVSE8_V_M2_MASK,
  PseudoVSE8_V_M4,
  PseudoVSE8_V_M4_MASK,
  PseudoVSE8_V_M8,
  PseudoVSE8_V_M8_MASK,
  PseudoVSE8_V_MF2,
  PseudoVSE8_V_MF2_MASK,
  PseudoVSE8_V_MF4,
  PseudoVSE8_V_MF4_MASK,
  PseudoVSE8_V_MF8,
  PseudoVSE8_V_MF8_MASK,
  PseudoVSETIVLI,
  PseudoVSETVLI,
  PseudoVSETVLIX0,
  PseudoVSETVLIX0X0,
  PseudoVSEXT_VF2_M1,
  PseudoVSEXT_VF2_M1_MASK,
  PseudoVSEXT_VF2_M2,
  PseudoVSEXT_VF2_M2_MASK,
  PseudoVSEXT_VF2_M4,
  PseudoVSEXT_VF2_M4_MASK,
  PseudoVSEXT_VF2_M8,
  PseudoVSEXT_VF2_M8_MASK,
  PseudoVSEXT_VF2_MF2,
  PseudoVSEXT_VF2_MF2_MASK,
  PseudoVSEXT_VF2_MF4,
  PseudoVSEXT_VF2_MF4_MASK,
  PseudoVSEXT_VF4_M1,
  PseudoVSEXT_VF4_M1_MASK,
  PseudoVSEXT_VF4_M2,
  PseudoVSEXT_VF4_M2_MASK,
  PseudoVSEXT_VF4_M4,
  PseudoVSEXT_VF4_M4_MASK,
  PseudoVSEXT_VF4_M8,
  PseudoVSEXT_VF4_M8_MASK,
  PseudoVSEXT_VF4_MF2,
  PseudoVSEXT_VF4_MF2_MASK,
  PseudoVSEXT_VF8_M1,
  PseudoVSEXT_VF8_M1_MASK,
  PseudoVSEXT_VF8_M2,
  PseudoVSEXT_VF8_M2_MASK,
  PseudoVSEXT_VF8_M4,
  PseudoVSEXT_VF8_M4_MASK,
  PseudoVSEXT_VF8_M8,
  PseudoVSEXT_VF8_M8_MASK,
  PseudoVSHA2CH_VV_M1,
  PseudoVSHA2CH_VV_M2,
  PseudoVSHA2CH_VV_M4,
  PseudoVSHA2CH_VV_M8,
  PseudoVSHA2CH_VV_MF2,
  PseudoVSHA2CL_VV_M1,
  PseudoVSHA2CL_VV_M2,
  PseudoVSHA2CL_VV_M4,
  PseudoVSHA2CL_VV_M8,
  PseudoVSHA2CL_VV_MF2,
  PseudoVSHA2MS_VV_M1_E32,
  PseudoVSHA2MS_VV_M1_E64,
  PseudoVSHA2MS_VV_M2_E32,
  PseudoVSHA2MS_VV_M2_E64,
  PseudoVSHA2MS_VV_M4_E32,
  PseudoVSHA2MS_VV_M4_E64,
  PseudoVSHA2MS_VV_M8_E32,
  PseudoVSHA2MS_VV_M8_E64,
  PseudoVSHA2MS_VV_MF2_E32,
  PseudoVSLIDE1DOWN_VX_M1,
  PseudoVSLIDE1DOWN_VX_M1_MASK,
  PseudoVSLIDE1DOWN_VX_M2,
  PseudoVSLIDE1DOWN_VX_M2_MASK,
  PseudoVSLIDE1DOWN_VX_M4,
  PseudoVSLIDE1DOWN_VX_M4_MASK,
  PseudoVSLIDE1DOWN_VX_M8,
  PseudoVSLIDE1DOWN_VX_M8_MASK,
  PseudoVSLIDE1DOWN_VX_MF2,
  PseudoVSLIDE1DOWN_VX_MF2_MASK,
  PseudoVSLIDE1DOWN_VX_MF4,
  PseudoVSLIDE1DOWN_VX_MF4_MASK,
  PseudoVSLIDE1DOWN_VX_MF8,
  PseudoVSLIDE1DOWN_VX_MF8_MASK,
  PseudoVSLIDE1UP_VX_M1,
  PseudoVSLIDE1UP_VX_M1_MASK,
  PseudoVSLIDE1UP_VX_M2,
  PseudoVSLIDE1UP_VX_M2_MASK,
  PseudoVSLIDE1UP_VX_M4,
  PseudoVSLIDE1UP_VX_M4_MASK,
  PseudoVSLIDE1UP_VX_M8,
  PseudoVSLIDE1UP_VX_M8_MASK,
  PseudoVSLIDE1UP_VX_MF2,
  PseudoVSLIDE1UP_VX_MF2_MASK,
  PseudoVSLIDE1UP_VX_MF4,
  PseudoVSLIDE1UP_VX_MF4_MASK,
  PseudoVSLIDE1UP_VX_MF8,
  PseudoVSLIDE1UP_VX_MF8_MASK,
  PseudoVSLIDEDOWN_VI_M1,
  PseudoVSLIDEDOWN_VI_M1_MASK,
  PseudoVSLIDEDOWN_VI_M2,
  PseudoVSLIDEDOWN_VI_M2_MASK,
  PseudoVSLIDEDOWN_VI_M4,
  PseudoVSLIDEDOWN_VI_M4_MASK,
  PseudoVSLIDEDOWN_VI_M8,
  PseudoVSLIDEDOWN_VI_M8_MASK,
  PseudoVSLIDEDOWN_VI_MF2,
  PseudoVSLIDEDOWN_VI_MF2_MASK,
  PseudoVSLIDEDOWN_VI_MF4,
  PseudoVSLIDEDOWN_VI_MF4_MASK,
  PseudoVSLIDEDOWN_VI_MF8,
  PseudoVSLIDEDOWN_VI_MF8_MASK,
  PseudoVSLIDEDOWN_VX_M1,
  PseudoVSLIDEDOWN_VX_M1_MASK,
  PseudoVSLIDEDOWN_VX_M2,
  PseudoVSLIDEDOWN_VX_M2_MASK,
  PseudoVSLIDEDOWN_VX_M4,
  PseudoVSLIDEDOWN_VX_M4_MASK,
  PseudoVSLIDEDOWN_VX_M8,
  PseudoVSLIDEDOWN_VX_M8_MASK,
  PseudoVSLIDEDOWN_VX_MF2,
  PseudoVSLIDEDOWN_VX_MF2_MASK,
  PseudoVSLIDEDOWN_VX_MF4,
  PseudoVSLIDEDOWN_VX_MF4_MASK,
  PseudoVSLIDEDOWN_VX_MF8,
  PseudoVSLIDEDOWN_VX_MF8_MASK,
  PseudoVSLIDEUP_VI_M1,
  PseudoVSLIDEUP_VI_M1_MASK,
  PseudoVSLIDEUP_VI_M2,
  PseudoVSLIDEUP_VI_M2_MASK,
  PseudoVSLIDEUP_VI_M4,
  PseudoVSLIDEUP_VI_M4_MASK,
  PseudoVSLIDEUP_VI_M8,
  PseudoVSLIDEUP_VI_M8_MASK,
  PseudoVSLIDEUP_VI_MF2,
  PseudoVSLIDEUP_VI_MF2_MASK,
  PseudoVSLIDEUP_VI_MF4,
  PseudoVSLIDEUP_VI_MF4_MASK,
  PseudoVSLIDEUP_VI_MF8,
  PseudoVSLIDEUP_VI_MF8_MASK,
  PseudoVSLIDEUP_VX_M1,
  PseudoVSLIDEUP_VX_M1_MASK,
  PseudoVSLIDEUP_VX_M2,
  PseudoVSLIDEUP_VX_M2_MASK,
  PseudoVSLIDEUP_VX_M4,
  PseudoVSLIDEUP_VX_M4_MASK,
  PseudoVSLIDEUP_VX_M8,
  PseudoVSLIDEUP_VX_M8_MASK,
  PseudoVSLIDEUP_VX_MF2,
  PseudoVSLIDEUP_VX_MF2_MASK,
  PseudoVSLIDEUP_VX_MF4,
  PseudoVSLIDEUP_VX_MF4_MASK,
  PseudoVSLIDEUP_VX_MF8,
  PseudoVSLIDEUP_VX_MF8_MASK,
  PseudoVSLL_VI_M1,
  PseudoVSLL_VI_M1_MASK,
  PseudoVSLL_VI_M2,
  PseudoVSLL_VI_M2_MASK,
  PseudoVSLL_VI_M4,
  PseudoVSLL_VI_M4_MASK,
  PseudoVSLL_VI_M8,
  PseudoVSLL_VI_M8_MASK,
  PseudoVSLL_VI_MF2,
  PseudoVSLL_VI_MF2_MASK,
  PseudoVSLL_VI_MF4,
  PseudoVSLL_VI_MF4_MASK,
  PseudoVSLL_VI_MF8,
  PseudoVSLL_VI_MF8_MASK,
  PseudoVSLL_VV_M1,
  PseudoVSLL_VV_M1_MASK,
  PseudoVSLL_VV_M2,
  PseudoVSLL_VV_M2_MASK,
  PseudoVSLL_VV_M4,
  PseudoVSLL_VV_M4_MASK,
  PseudoVSLL_VV_M8,
  PseudoVSLL_VV_M8_MASK,
  PseudoVSLL_VV_MF2,
  PseudoVSLL_VV_MF2_MASK,
  PseudoVSLL_VV_MF4,
  PseudoVSLL_VV_MF4_MASK,
  PseudoVSLL_VV_MF8,
  PseudoVSLL_VV_MF8_MASK,
  PseudoVSLL_VX_M1,
  PseudoVSLL_VX_M1_MASK,
  PseudoVSLL_VX_M2,
  PseudoVSLL_VX_M2_MASK,
  PseudoVSLL_VX_M4,
  PseudoVSLL_VX_M4_MASK,
  PseudoVSLL_VX_M8,
  PseudoVSLL_VX_M8_MASK,
  PseudoVSLL_VX_MF2,
  PseudoVSLL_VX_MF2_MASK,
  PseudoVSLL_VX_MF4,
  PseudoVSLL_VX_MF4_MASK,
  PseudoVSLL_VX_MF8,
  PseudoVSLL_VX_MF8_MASK,
  PseudoVSM3C_VI_M1,
  PseudoVSM3C_VI_M2,
  PseudoVSM3C_VI_M4,
  PseudoVSM3C_VI_M8,
  PseudoVSM3C_VI_MF2,
  PseudoVSM3ME_VV_M1,
  PseudoVSM3ME_VV_M2,
  PseudoVSM3ME_VV_M4,
  PseudoVSM3ME_VV_M8,
  PseudoVSM3ME_VV_MF2,
  PseudoVSM4K_VI_M1,
  PseudoVSM4K_VI_M2,
  PseudoVSM4K_VI_M4,
  PseudoVSM4K_VI_M8,
  PseudoVSM4K_VI_MF2,
  PseudoVSM4R_VS_M1_M1,
  PseudoVSM4R_VS_M1_MF2,
  PseudoVSM4R_VS_M1_MF4,
  PseudoVSM4R_VS_M1_MF8,
  PseudoVSM4R_VS_M2_M1,
  PseudoVSM4R_VS_M2_M2,
  PseudoVSM4R_VS_M2_MF2,
  PseudoVSM4R_VS_M2_MF4,
  PseudoVSM4R_VS_M2_MF8,
  PseudoVSM4R_VS_M4_M1,
  PseudoVSM4R_VS_M4_M2,
  PseudoVSM4R_VS_M4_M4,
  PseudoVSM4R_VS_M4_MF2,
  PseudoVSM4R_VS_M4_MF4,
  PseudoVSM4R_VS_M4_MF8,
  PseudoVSM4R_VS_M8_M1,
  PseudoVSM4R_VS_M8_M2,
  PseudoVSM4R_VS_M8_M4,
  PseudoVSM4R_VS_M8_MF2,
  PseudoVSM4R_VS_M8_MF4,
  PseudoVSM4R_VS_M8_MF8,
  PseudoVSM4R_VS_MF2_MF2,
  PseudoVSM4R_VS_MF2_MF4,
  PseudoVSM4R_VS_MF2_MF8,
  PseudoVSM4R_VV_M1,
  PseudoVSM4R_VV_M2,
  PseudoVSM4R_VV_M4,
  PseudoVSM4R_VV_M8,
  PseudoVSM4R_VV_MF2,
  PseudoVSMUL_VV_M1,
  PseudoVSMUL_VV_M1_MASK,
  PseudoVSMUL_VV_M2,
  PseudoVSMUL_VV_M2_MASK,
  PseudoVSMUL_VV_M4,
  PseudoVSMUL_VV_M4_MASK,
  PseudoVSMUL_VV_M8,
  PseudoVSMUL_VV_M8_MASK,
  PseudoVSMUL_VV_MF2,
  PseudoVSMUL_VV_MF2_MASK,
  PseudoVSMUL_VV_MF4,
  PseudoVSMUL_VV_MF4_MASK,
  PseudoVSMUL_VV_MF8,
  PseudoVSMUL_VV_MF8_MASK,
  PseudoVSMUL_VX_M1,
  PseudoVSMUL_VX_M1_MASK,
  PseudoVSMUL_VX_M2,
  PseudoVSMUL_VX_M2_MASK,
  PseudoVSMUL_VX_M4,
  PseudoVSMUL_VX_M4_MASK,
  PseudoVSMUL_VX_M8,
  PseudoVSMUL_VX_M8_MASK,
  PseudoVSMUL_VX_MF2,
  PseudoVSMUL_VX_MF2_MASK,
  PseudoVSMUL_VX_MF4,
  PseudoVSMUL_VX_MF4_MASK,
  PseudoVSMUL_VX_MF8,
  PseudoVSMUL_VX_MF8_MASK,
  PseudoVSM_V_B1,
  PseudoVSM_V_B16,
  PseudoVSM_V_B2,
  PseudoVSM_V_B32,
  PseudoVSM_V_B4,
  PseudoVSM_V_B64,
  PseudoVSM_V_B8,
  PseudoVSOXEI16_V_M1_M1,
  PseudoVSOXEI16_V_M1_M1_MASK,
  PseudoVSOXEI16_V_M1_M2,
  PseudoVSOXEI16_V_M1_M2_MASK,
  PseudoVSOXEI16_V_M1_M4,
  PseudoVSOXEI16_V_M1_M4_MASK,
  PseudoVSOXEI16_V_M1_MF2,
  PseudoVSOXEI16_V_M1_MF2_MASK,
  PseudoVSOXEI16_V_M2_M1,
  PseudoVSOXEI16_V_M2_M1_MASK,
  PseudoVSOXEI16_V_M2_M2,
  PseudoVSOXEI16_V_M2_M2_MASK,
  PseudoVSOXEI16_V_M2_M4,
  PseudoVSOXEI16_V_M2_M4_MASK,
  PseudoVSOXEI16_V_M2_M8,
  PseudoVSOXEI16_V_M2_M8_MASK,
  PseudoVSOXEI16_V_M4_M2,
  PseudoVSOXEI16_V_M4_M2_MASK,
  PseudoVSOXEI16_V_M4_M4,
  PseudoVSOXEI16_V_M4_M4_MASK,
  PseudoVSOXEI16_V_M4_M8,
  PseudoVSOXEI16_V_M4_M8_MASK,
  PseudoVSOXEI16_V_M8_M4,
  PseudoVSOXEI16_V_M8_M4_MASK,
  PseudoVSOXEI16_V_M8_M8,
  PseudoVSOXEI16_V_M8_M8_MASK,
  PseudoVSOXEI16_V_MF2_M1,
  PseudoVSOXEI16_V_MF2_M1_MASK,
  PseudoVSOXEI16_V_MF2_M2,
  PseudoVSOXEI16_V_MF2_M2_MASK,
  PseudoVSOXEI16_V_MF2_MF2,
  PseudoVSOXEI16_V_MF2_MF2_MASK,
  PseudoVSOXEI16_V_MF2_MF4,
  PseudoVSOXEI16_V_MF2_MF4_MASK,
  PseudoVSOXEI16_V_MF4_M1,
  PseudoVSOXEI16_V_MF4_M1_MASK,
  PseudoVSOXEI16_V_MF4_MF2,
  PseudoVSOXEI16_V_MF4_MF2_MASK,
  PseudoVSOXEI16_V_MF4_MF4,
  PseudoVSOXEI16_V_MF4_MF4_MASK,
  PseudoVSOXEI16_V_MF4_MF8,
  PseudoVSOXEI16_V_MF4_MF8_MASK,
  PseudoVSOXEI32_V_M1_M1,
  PseudoVSOXEI32_V_M1_M1_MASK,
  PseudoVSOXEI32_V_M1_M2,
  PseudoVSOXEI32_V_M1_M2_MASK,
  PseudoVSOXEI32_V_M1_MF2,
  PseudoVSOXEI32_V_M1_MF2_MASK,
  PseudoVSOXEI32_V_M1_MF4,
  PseudoVSOXEI32_V_M1_MF4_MASK,
  PseudoVSOXEI32_V_M2_M1,
  PseudoVSOXEI32_V_M2_M1_MASK,
  PseudoVSOXEI32_V_M2_M2,
  PseudoVSOXEI32_V_M2_M2_MASK,
  PseudoVSOXEI32_V_M2_M4,
  PseudoVSOXEI32_V_M2_M4_MASK,
  PseudoVSOXEI32_V_M2_MF2,
  PseudoVSOXEI32_V_M2_MF2_MASK,
  PseudoVSOXEI32_V_M4_M1,
  PseudoVSOXEI32_V_M4_M1_MASK,
  PseudoVSOXEI32_V_M4_M2,
  PseudoVSOXEI32_V_M4_M2_MASK,
  PseudoVSOXEI32_V_M4_M4,
  PseudoVSOXEI32_V_M4_M4_MASK,
  PseudoVSOXEI32_V_M4_M8,
  PseudoVSOXEI32_V_M4_M8_MASK,
  PseudoVSOXEI32_V_M8_M2,
  PseudoVSOXEI32_V_M8_M2_MASK,
  PseudoVSOXEI32_V_M8_M4,
  PseudoVSOXEI32_V_M8_M4_MASK,
  PseudoVSOXEI32_V_M8_M8,
  PseudoVSOXEI32_V_M8_M8_MASK,
  PseudoVSOXEI32_V_MF2_M1,
  PseudoVSOXEI32_V_MF2_M1_MASK,
  PseudoVSOXEI32_V_MF2_MF2,
  PseudoVSOXEI32_V_MF2_MF2_MASK,
  PseudoVSOXEI32_V_MF2_MF4,
  PseudoVSOXEI32_V_MF2_MF4_MASK,
  PseudoVSOXEI32_V_MF2_MF8,
  PseudoVSOXEI32_V_MF2_MF8_MASK,
  PseudoVSOXEI64_V_M1_M1,
  PseudoVSOXEI64_V_M1_M1_MASK,
  PseudoVSOXEI64_V_M1_MF2,
  PseudoVSOXEI64_V_M1_MF2_MASK,
  PseudoVSOXEI64_V_M1_MF4,
  PseudoVSOXEI64_V_M1_MF4_MASK,
  PseudoVSOXEI64_V_M1_MF8,
  PseudoVSOXEI64_V_M1_MF8_MASK,
  PseudoVSOXEI64_V_M2_M1,
  PseudoVSOXEI64_V_M2_M1_MASK,
  PseudoVSOXEI64_V_M2_M2,
  PseudoVSOXEI64_V_M2_M2_MASK,
  PseudoVSOXEI64_V_M2_MF2,
  PseudoVSOXEI64_V_M2_MF2_MASK,
  PseudoVSOXEI64_V_M2_MF4,
  PseudoVSOXEI64_V_M2_MF4_MASK,
  PseudoVSOXEI64_V_M4_M1,
  PseudoVSOXEI64_V_M4_M1_MASK,
  PseudoVSOXEI64_V_M4_M2,
  PseudoVSOXEI64_V_M4_M2_MASK,
  PseudoVSOXEI64_V_M4_M4,
  PseudoVSOXEI64_V_M4_M4_MASK,
  PseudoVSOXEI64_V_M4_MF2,
  PseudoVSOXEI64_V_M4_MF2_MASK,
  PseudoVSOXEI64_V_M8_M1,
  PseudoVSOXEI64_V_M8_M1_MASK,
  PseudoVSOXEI64_V_M8_M2,
  PseudoVSOXEI64_V_M8_M2_MASK,
  PseudoVSOXEI64_V_M8_M4,
  PseudoVSOXEI64_V_M8_M4_MASK,
  PseudoVSOXEI64_V_M8_M8,
  PseudoVSOXEI64_V_M8_M8_MASK,
  PseudoVSOXEI8_V_M1_M1,
  PseudoVSOXEI8_V_M1_M1_MASK,
  PseudoVSOXEI8_V_M1_M2,
  PseudoVSOXEI8_V_M1_M2_MASK,
  PseudoVSOXEI8_V_M1_M4,
  PseudoVSOXEI8_V_M1_M4_MASK,
  PseudoVSOXEI8_V_M1_M8,
  PseudoVSOXEI8_V_M1_M8_MASK,
  PseudoVSOXEI8_V_M2_M2,
  PseudoVSOXEI8_V_M2_M2_MASK,
  PseudoVSOXEI8_V_M2_M4,
  PseudoVSOXEI8_V_M2_M4_MASK,
  PseudoVSOXEI8_V_M2_M8,
  PseudoVSOXEI8_V_M2_M8_MASK,
  PseudoVSOXEI8_V_M4_M4,
  PseudoVSOXEI8_V_M4_M4_MASK,
  PseudoVSOXEI8_V_M4_M8,
  PseudoVSOXEI8_V_M4_M8_MASK,
  PseudoVSOXEI8_V_M8_M8,
  PseudoVSOXEI8_V_M8_M8_MASK,
  PseudoVSOXEI8_V_MF2_M1,
  PseudoVSOXEI8_V_MF2_M1_MASK,
  PseudoVSOXEI8_V_MF2_M2,
  PseudoVSOXEI8_V_MF2_M2_MASK,
  PseudoVSOXEI8_V_MF2_M4,
  PseudoVSOXEI8_V_MF2_M4_MASK,
  PseudoVSOXEI8_V_MF2_MF2,
  PseudoVSOXEI8_V_MF2_MF2_MASK,
  PseudoVSOXEI8_V_MF4_M1,
  PseudoVSOXEI8_V_MF4_M1_MASK,
  PseudoVSOXEI8_V_MF4_M2,
  PseudoVSOXEI8_V_MF4_M2_MASK,
  PseudoVSOXEI8_V_MF4_MF2,
  PseudoVSOXEI8_V_MF4_MF2_MASK,
  PseudoVSOXEI8_V_MF4_MF4,
  PseudoVSOXEI8_V_MF4_MF4_MASK,
  PseudoVSOXEI8_V_MF8_M1,
  PseudoVSOXEI8_V_MF8_M1_MASK,
  PseudoVSOXEI8_V_MF8_MF2,
  PseudoVSOXEI8_V_MF8_MF2_MASK,
  PseudoVSOXEI8_V_MF8_MF4,
  PseudoVSOXEI8_V_MF8_MF4_MASK,
  PseudoVSOXEI8_V_MF8_MF8,
  PseudoVSOXEI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG2EI16_V_M1_M1,
  PseudoVSOXSEG2EI16_V_M1_M1_MASK,
  PseudoVSOXSEG2EI16_V_M1_M2,
  PseudoVSOXSEG2EI16_V_M1_M2_MASK,
  PseudoVSOXSEG2EI16_V_M1_M4,
  PseudoVSOXSEG2EI16_V_M1_M4_MASK,
  PseudoVSOXSEG2EI16_V_M1_MF2,
  PseudoVSOXSEG2EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG2EI16_V_M2_M1,
  PseudoVSOXSEG2EI16_V_M2_M1_MASK,
  PseudoVSOXSEG2EI16_V_M2_M2,
  PseudoVSOXSEG2EI16_V_M2_M2_MASK,
  PseudoVSOXSEG2EI16_V_M2_M4,
  PseudoVSOXSEG2EI16_V_M2_M4_MASK,
  PseudoVSOXSEG2EI16_V_M4_M2,
  PseudoVSOXSEG2EI16_V_M4_M2_MASK,
  PseudoVSOXSEG2EI16_V_M4_M4,
  PseudoVSOXSEG2EI16_V_M4_M4_MASK,
  PseudoVSOXSEG2EI16_V_M8_M4,
  PseudoVSOXSEG2EI16_V_M8_M4_MASK,
  PseudoVSOXSEG2EI16_V_MF2_M1,
  PseudoVSOXSEG2EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG2EI16_V_MF2_M2,
  PseudoVSOXSEG2EI16_V_MF2_M2_MASK,
  PseudoVSOXSEG2EI16_V_MF2_MF2,
  PseudoVSOXSEG2EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG2EI16_V_MF2_MF4,
  PseudoVSOXSEG2EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG2EI16_V_MF4_M1,
  PseudoVSOXSEG2EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG2EI16_V_MF4_MF2,
  PseudoVSOXSEG2EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG2EI16_V_MF4_MF4,
  PseudoVSOXSEG2EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG2EI16_V_MF4_MF8,
  PseudoVSOXSEG2EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG2EI32_V_M1_M1,
  PseudoVSOXSEG2EI32_V_M1_M1_MASK,
  PseudoVSOXSEG2EI32_V_M1_M2,
  PseudoVSOXSEG2EI32_V_M1_M2_MASK,
  PseudoVSOXSEG2EI32_V_M1_MF2,
  PseudoVSOXSEG2EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG2EI32_V_M1_MF4,
  PseudoVSOXSEG2EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG2EI32_V_M2_M1,
  PseudoVSOXSEG2EI32_V_M2_M1_MASK,
  PseudoVSOXSEG2EI32_V_M2_M2,
  PseudoVSOXSEG2EI32_V_M2_M2_MASK,
  PseudoVSOXSEG2EI32_V_M2_M4,
  PseudoVSOXSEG2EI32_V_M2_M4_MASK,
  PseudoVSOXSEG2EI32_V_M2_MF2,
  PseudoVSOXSEG2EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG2EI32_V_M4_M1,
  PseudoVSOXSEG2EI32_V_M4_M1_MASK,
  PseudoVSOXSEG2EI32_V_M4_M2,
  PseudoVSOXSEG2EI32_V_M4_M2_MASK,
  PseudoVSOXSEG2EI32_V_M4_M4,
  PseudoVSOXSEG2EI32_V_M4_M4_MASK,
  PseudoVSOXSEG2EI32_V_M8_M2,
  PseudoVSOXSEG2EI32_V_M8_M2_MASK,
  PseudoVSOXSEG2EI32_V_M8_M4,
  PseudoVSOXSEG2EI32_V_M8_M4_MASK,
  PseudoVSOXSEG2EI32_V_MF2_M1,
  PseudoVSOXSEG2EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG2EI32_V_MF2_MF2,
  PseudoVSOXSEG2EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG2EI32_V_MF2_MF4,
  PseudoVSOXSEG2EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG2EI32_V_MF2_MF8,
  PseudoVSOXSEG2EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG2EI64_V_M1_M1,
  PseudoVSOXSEG2EI64_V_M1_M1_MASK,
  PseudoVSOXSEG2EI64_V_M1_MF2,
  PseudoVSOXSEG2EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG2EI64_V_M1_MF4,
  PseudoVSOXSEG2EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG2EI64_V_M1_MF8,
  PseudoVSOXSEG2EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG2EI64_V_M2_M1,
  PseudoVSOXSEG2EI64_V_M2_M1_MASK,
  PseudoVSOXSEG2EI64_V_M2_M2,
  PseudoVSOXSEG2EI64_V_M2_M2_MASK,
  PseudoVSOXSEG2EI64_V_M2_MF2,
  PseudoVSOXSEG2EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG2EI64_V_M2_MF4,
  PseudoVSOXSEG2EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG2EI64_V_M4_M1,
  PseudoVSOXSEG2EI64_V_M4_M1_MASK,
  PseudoVSOXSEG2EI64_V_M4_M2,
  PseudoVSOXSEG2EI64_V_M4_M2_MASK,
  PseudoVSOXSEG2EI64_V_M4_M4,
  PseudoVSOXSEG2EI64_V_M4_M4_MASK,
  PseudoVSOXSEG2EI64_V_M4_MF2,
  PseudoVSOXSEG2EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG2EI64_V_M8_M1,
  PseudoVSOXSEG2EI64_V_M8_M1_MASK,
  PseudoVSOXSEG2EI64_V_M8_M2,
  PseudoVSOXSEG2EI64_V_M8_M2_MASK,
  PseudoVSOXSEG2EI64_V_M8_M4,
  PseudoVSOXSEG2EI64_V_M8_M4_MASK,
  PseudoVSOXSEG2EI8_V_M1_M1,
  PseudoVSOXSEG2EI8_V_M1_M1_MASK,
  PseudoVSOXSEG2EI8_V_M1_M2,
  PseudoVSOXSEG2EI8_V_M1_M2_MASK,
  PseudoVSOXSEG2EI8_V_M1_M4,
  PseudoVSOXSEG2EI8_V_M1_M4_MASK,
  PseudoVSOXSEG2EI8_V_M2_M2,
  PseudoVSOXSEG2EI8_V_M2_M2_MASK,
  PseudoVSOXSEG2EI8_V_M2_M4,
  PseudoVSOXSEG2EI8_V_M2_M4_MASK,
  PseudoVSOXSEG2EI8_V_M4_M4,
  PseudoVSOXSEG2EI8_V_M4_M4_MASK,
  PseudoVSOXSEG2EI8_V_MF2_M1,
  PseudoVSOXSEG2EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG2EI8_V_MF2_M2,
  PseudoVSOXSEG2EI8_V_MF2_M2_MASK,
  PseudoVSOXSEG2EI8_V_MF2_M4,
  PseudoVSOXSEG2EI8_V_MF2_M4_MASK,
  PseudoVSOXSEG2EI8_V_MF2_MF2,
  PseudoVSOXSEG2EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG2EI8_V_MF4_M1,
  PseudoVSOXSEG2EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG2EI8_V_MF4_M2,
  PseudoVSOXSEG2EI8_V_MF4_M2_MASK,
  PseudoVSOXSEG2EI8_V_MF4_MF2,
  PseudoVSOXSEG2EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG2EI8_V_MF4_MF4,
  PseudoVSOXSEG2EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG2EI8_V_MF8_M1,
  PseudoVSOXSEG2EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG2EI8_V_MF8_MF2,
  PseudoVSOXSEG2EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG2EI8_V_MF8_MF4,
  PseudoVSOXSEG2EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG2EI8_V_MF8_MF8,
  PseudoVSOXSEG2EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG3EI16_V_M1_M1,
  PseudoVSOXSEG3EI16_V_M1_M1_MASK,
  PseudoVSOXSEG3EI16_V_M1_M2,
  PseudoVSOXSEG3EI16_V_M1_M2_MASK,
  PseudoVSOXSEG3EI16_V_M1_MF2,
  PseudoVSOXSEG3EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG3EI16_V_M2_M1,
  PseudoVSOXSEG3EI16_V_M2_M1_MASK,
  PseudoVSOXSEG3EI16_V_M2_M2,
  PseudoVSOXSEG3EI16_V_M2_M2_MASK,
  PseudoVSOXSEG3EI16_V_M4_M2,
  PseudoVSOXSEG3EI16_V_M4_M2_MASK,
  PseudoVSOXSEG3EI16_V_MF2_M1,
  PseudoVSOXSEG3EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG3EI16_V_MF2_M2,
  PseudoVSOXSEG3EI16_V_MF2_M2_MASK,
  PseudoVSOXSEG3EI16_V_MF2_MF2,
  PseudoVSOXSEG3EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG3EI16_V_MF2_MF4,
  PseudoVSOXSEG3EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG3EI16_V_MF4_M1,
  PseudoVSOXSEG3EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG3EI16_V_MF4_MF2,
  PseudoVSOXSEG3EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG3EI16_V_MF4_MF4,
  PseudoVSOXSEG3EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG3EI16_V_MF4_MF8,
  PseudoVSOXSEG3EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG3EI32_V_M1_M1,
  PseudoVSOXSEG3EI32_V_M1_M1_MASK,
  PseudoVSOXSEG3EI32_V_M1_M2,
  PseudoVSOXSEG3EI32_V_M1_M2_MASK,
  PseudoVSOXSEG3EI32_V_M1_MF2,
  PseudoVSOXSEG3EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG3EI32_V_M1_MF4,
  PseudoVSOXSEG3EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG3EI32_V_M2_M1,
  PseudoVSOXSEG3EI32_V_M2_M1_MASK,
  PseudoVSOXSEG3EI32_V_M2_M2,
  PseudoVSOXSEG3EI32_V_M2_M2_MASK,
  PseudoVSOXSEG3EI32_V_M2_MF2,
  PseudoVSOXSEG3EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG3EI32_V_M4_M1,
  PseudoVSOXSEG3EI32_V_M4_M1_MASK,
  PseudoVSOXSEG3EI32_V_M4_M2,
  PseudoVSOXSEG3EI32_V_M4_M2_MASK,
  PseudoVSOXSEG3EI32_V_M8_M2,
  PseudoVSOXSEG3EI32_V_M8_M2_MASK,
  PseudoVSOXSEG3EI32_V_MF2_M1,
  PseudoVSOXSEG3EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG3EI32_V_MF2_MF2,
  PseudoVSOXSEG3EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG3EI32_V_MF2_MF4,
  PseudoVSOXSEG3EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG3EI32_V_MF2_MF8,
  PseudoVSOXSEG3EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG3EI64_V_M1_M1,
  PseudoVSOXSEG3EI64_V_M1_M1_MASK,
  PseudoVSOXSEG3EI64_V_M1_MF2,
  PseudoVSOXSEG3EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG3EI64_V_M1_MF4,
  PseudoVSOXSEG3EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG3EI64_V_M1_MF8,
  PseudoVSOXSEG3EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG3EI64_V_M2_M1,
  PseudoVSOXSEG3EI64_V_M2_M1_MASK,
  PseudoVSOXSEG3EI64_V_M2_M2,
  PseudoVSOXSEG3EI64_V_M2_M2_MASK,
  PseudoVSOXSEG3EI64_V_M2_MF2,
  PseudoVSOXSEG3EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG3EI64_V_M2_MF4,
  PseudoVSOXSEG3EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG3EI64_V_M4_M1,
  PseudoVSOXSEG3EI64_V_M4_M1_MASK,
  PseudoVSOXSEG3EI64_V_M4_M2,
  PseudoVSOXSEG3EI64_V_M4_M2_MASK,
  PseudoVSOXSEG3EI64_V_M4_MF2,
  PseudoVSOXSEG3EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG3EI64_V_M8_M1,
  PseudoVSOXSEG3EI64_V_M8_M1_MASK,
  PseudoVSOXSEG3EI64_V_M8_M2,
  PseudoVSOXSEG3EI64_V_M8_M2_MASK,
  PseudoVSOXSEG3EI8_V_M1_M1,
  PseudoVSOXSEG3EI8_V_M1_M1_MASK,
  PseudoVSOXSEG3EI8_V_M1_M2,
  PseudoVSOXSEG3EI8_V_M1_M2_MASK,
  PseudoVSOXSEG3EI8_V_M2_M2,
  PseudoVSOXSEG3EI8_V_M2_M2_MASK,
  PseudoVSOXSEG3EI8_V_MF2_M1,
  PseudoVSOXSEG3EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG3EI8_V_MF2_M2,
  PseudoVSOXSEG3EI8_V_MF2_M2_MASK,
  PseudoVSOXSEG3EI8_V_MF2_MF2,
  PseudoVSOXSEG3EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG3EI8_V_MF4_M1,
  PseudoVSOXSEG3EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG3EI8_V_MF4_M2,
  PseudoVSOXSEG3EI8_V_MF4_M2_MASK,
  PseudoVSOXSEG3EI8_V_MF4_MF2,
  PseudoVSOXSEG3EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG3EI8_V_MF4_MF4,
  PseudoVSOXSEG3EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG3EI8_V_MF8_M1,
  PseudoVSOXSEG3EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG3EI8_V_MF8_MF2,
  PseudoVSOXSEG3EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG3EI8_V_MF8_MF4,
  PseudoVSOXSEG3EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG3EI8_V_MF8_MF8,
  PseudoVSOXSEG3EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG4EI16_V_M1_M1,
  PseudoVSOXSEG4EI16_V_M1_M1_MASK,
  PseudoVSOXSEG4EI16_V_M1_M2,
  PseudoVSOXSEG4EI16_V_M1_M2_MASK,
  PseudoVSOXSEG4EI16_V_M1_MF2,
  PseudoVSOXSEG4EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG4EI16_V_M2_M1,
  PseudoVSOXSEG4EI16_V_M2_M1_MASK,
  PseudoVSOXSEG4EI16_V_M2_M2,
  PseudoVSOXSEG4EI16_V_M2_M2_MASK,
  PseudoVSOXSEG4EI16_V_M4_M2,
  PseudoVSOXSEG4EI16_V_M4_M2_MASK,
  PseudoVSOXSEG4EI16_V_MF2_M1,
  PseudoVSOXSEG4EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG4EI16_V_MF2_M2,
  PseudoVSOXSEG4EI16_V_MF2_M2_MASK,
  PseudoVSOXSEG4EI16_V_MF2_MF2,
  PseudoVSOXSEG4EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG4EI16_V_MF2_MF4,
  PseudoVSOXSEG4EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG4EI16_V_MF4_M1,
  PseudoVSOXSEG4EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG4EI16_V_MF4_MF2,
  PseudoVSOXSEG4EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG4EI16_V_MF4_MF4,
  PseudoVSOXSEG4EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG4EI16_V_MF4_MF8,
  PseudoVSOXSEG4EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG4EI32_V_M1_M1,
  PseudoVSOXSEG4EI32_V_M1_M1_MASK,
  PseudoVSOXSEG4EI32_V_M1_M2,
  PseudoVSOXSEG4EI32_V_M1_M2_MASK,
  PseudoVSOXSEG4EI32_V_M1_MF2,
  PseudoVSOXSEG4EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG4EI32_V_M1_MF4,
  PseudoVSOXSEG4EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG4EI32_V_M2_M1,
  PseudoVSOXSEG4EI32_V_M2_M1_MASK,
  PseudoVSOXSEG4EI32_V_M2_M2,
  PseudoVSOXSEG4EI32_V_M2_M2_MASK,
  PseudoVSOXSEG4EI32_V_M2_MF2,
  PseudoVSOXSEG4EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG4EI32_V_M4_M1,
  PseudoVSOXSEG4EI32_V_M4_M1_MASK,
  PseudoVSOXSEG4EI32_V_M4_M2,
  PseudoVSOXSEG4EI32_V_M4_M2_MASK,
  PseudoVSOXSEG4EI32_V_M8_M2,
  PseudoVSOXSEG4EI32_V_M8_M2_MASK,
  PseudoVSOXSEG4EI32_V_MF2_M1,
  PseudoVSOXSEG4EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG4EI32_V_MF2_MF2,
  PseudoVSOXSEG4EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG4EI32_V_MF2_MF4,
  PseudoVSOXSEG4EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG4EI32_V_MF2_MF8,
  PseudoVSOXSEG4EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG4EI64_V_M1_M1,
  PseudoVSOXSEG4EI64_V_M1_M1_MASK,
  PseudoVSOXSEG4EI64_V_M1_MF2,
  PseudoVSOXSEG4EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG4EI64_V_M1_MF4,
  PseudoVSOXSEG4EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG4EI64_V_M1_MF8,
  PseudoVSOXSEG4EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG4EI64_V_M2_M1,
  PseudoVSOXSEG4EI64_V_M2_M1_MASK,
  PseudoVSOXSEG4EI64_V_M2_M2,
  PseudoVSOXSEG4EI64_V_M2_M2_MASK,
  PseudoVSOXSEG4EI64_V_M2_MF2,
  PseudoVSOXSEG4EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG4EI64_V_M2_MF4,
  PseudoVSOXSEG4EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG4EI64_V_M4_M1,
  PseudoVSOXSEG4EI64_V_M4_M1_MASK,
  PseudoVSOXSEG4EI64_V_M4_M2,
  PseudoVSOXSEG4EI64_V_M4_M2_MASK,
  PseudoVSOXSEG4EI64_V_M4_MF2,
  PseudoVSOXSEG4EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG4EI64_V_M8_M1,
  PseudoVSOXSEG4EI64_V_M8_M1_MASK,
  PseudoVSOXSEG4EI64_V_M8_M2,
  PseudoVSOXSEG4EI64_V_M8_M2_MASK,
  PseudoVSOXSEG4EI8_V_M1_M1,
  PseudoVSOXSEG4EI8_V_M1_M1_MASK,
  PseudoVSOXSEG4EI8_V_M1_M2,
  PseudoVSOXSEG4EI8_V_M1_M2_MASK,
  PseudoVSOXSEG4EI8_V_M2_M2,
  PseudoVSOXSEG4EI8_V_M2_M2_MASK,
  PseudoVSOXSEG4EI8_V_MF2_M1,
  PseudoVSOXSEG4EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG4EI8_V_MF2_M2,
  PseudoVSOXSEG4EI8_V_MF2_M2_MASK,
  PseudoVSOXSEG4EI8_V_MF2_MF2,
  PseudoVSOXSEG4EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG4EI8_V_MF4_M1,
  PseudoVSOXSEG4EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG4EI8_V_MF4_M2,
  PseudoVSOXSEG4EI8_V_MF4_M2_MASK,
  PseudoVSOXSEG4EI8_V_MF4_MF2,
  PseudoVSOXSEG4EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG4EI8_V_MF4_MF4,
  PseudoVSOXSEG4EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG4EI8_V_MF8_M1,
  PseudoVSOXSEG4EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG4EI8_V_MF8_MF2,
  PseudoVSOXSEG4EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG4EI8_V_MF8_MF4,
  PseudoVSOXSEG4EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG4EI8_V_MF8_MF8,
  PseudoVSOXSEG4EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG5EI16_V_M1_M1,
  PseudoVSOXSEG5EI16_V_M1_M1_MASK,
  PseudoVSOXSEG5EI16_V_M1_MF2,
  PseudoVSOXSEG5EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG5EI16_V_M2_M1,
  PseudoVSOXSEG5EI16_V_M2_M1_MASK,
  PseudoVSOXSEG5EI16_V_MF2_M1,
  PseudoVSOXSEG5EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG5EI16_V_MF2_MF2,
  PseudoVSOXSEG5EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG5EI16_V_MF2_MF4,
  PseudoVSOXSEG5EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG5EI16_V_MF4_M1,
  PseudoVSOXSEG5EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG5EI16_V_MF4_MF2,
  PseudoVSOXSEG5EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG5EI16_V_MF4_MF4,
  PseudoVSOXSEG5EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG5EI16_V_MF4_MF8,
  PseudoVSOXSEG5EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG5EI32_V_M1_M1,
  PseudoVSOXSEG5EI32_V_M1_M1_MASK,
  PseudoVSOXSEG5EI32_V_M1_MF2,
  PseudoVSOXSEG5EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG5EI32_V_M1_MF4,
  PseudoVSOXSEG5EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG5EI32_V_M2_M1,
  PseudoVSOXSEG5EI32_V_M2_M1_MASK,
  PseudoVSOXSEG5EI32_V_M2_MF2,
  PseudoVSOXSEG5EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG5EI32_V_M4_M1,
  PseudoVSOXSEG5EI32_V_M4_M1_MASK,
  PseudoVSOXSEG5EI32_V_MF2_M1,
  PseudoVSOXSEG5EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG5EI32_V_MF2_MF2,
  PseudoVSOXSEG5EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG5EI32_V_MF2_MF4,
  PseudoVSOXSEG5EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG5EI32_V_MF2_MF8,
  PseudoVSOXSEG5EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG5EI64_V_M1_M1,
  PseudoVSOXSEG5EI64_V_M1_M1_MASK,
  PseudoVSOXSEG5EI64_V_M1_MF2,
  PseudoVSOXSEG5EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG5EI64_V_M1_MF4,
  PseudoVSOXSEG5EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG5EI64_V_M1_MF8,
  PseudoVSOXSEG5EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG5EI64_V_M2_M1,
  PseudoVSOXSEG5EI64_V_M2_M1_MASK,
  PseudoVSOXSEG5EI64_V_M2_MF2,
  PseudoVSOXSEG5EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG5EI64_V_M2_MF4,
  PseudoVSOXSEG5EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG5EI64_V_M4_M1,
  PseudoVSOXSEG5EI64_V_M4_M1_MASK,
  PseudoVSOXSEG5EI64_V_M4_MF2,
  PseudoVSOXSEG5EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG5EI64_V_M8_M1,
  PseudoVSOXSEG5EI64_V_M8_M1_MASK,
  PseudoVSOXSEG5EI8_V_M1_M1,
  PseudoVSOXSEG5EI8_V_M1_M1_MASK,
  PseudoVSOXSEG5EI8_V_MF2_M1,
  PseudoVSOXSEG5EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG5EI8_V_MF2_MF2,
  PseudoVSOXSEG5EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG5EI8_V_MF4_M1,
  PseudoVSOXSEG5EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG5EI8_V_MF4_MF2,
  PseudoVSOXSEG5EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG5EI8_V_MF4_MF4,
  PseudoVSOXSEG5EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG5EI8_V_MF8_M1,
  PseudoVSOXSEG5EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG5EI8_V_MF8_MF2,
  PseudoVSOXSEG5EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG5EI8_V_MF8_MF4,
  PseudoVSOXSEG5EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG5EI8_V_MF8_MF8,
  PseudoVSOXSEG5EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG6EI16_V_M1_M1,
  PseudoVSOXSEG6EI16_V_M1_M1_MASK,
  PseudoVSOXSEG6EI16_V_M1_MF2,
  PseudoVSOXSEG6EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG6EI16_V_M2_M1,
  PseudoVSOXSEG6EI16_V_M2_M1_MASK,
  PseudoVSOXSEG6EI16_V_MF2_M1,
  PseudoVSOXSEG6EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG6EI16_V_MF2_MF2,
  PseudoVSOXSEG6EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG6EI16_V_MF2_MF4,
  PseudoVSOXSEG6EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG6EI16_V_MF4_M1,
  PseudoVSOXSEG6EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG6EI16_V_MF4_MF2,
  PseudoVSOXSEG6EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG6EI16_V_MF4_MF4,
  PseudoVSOXSEG6EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG6EI16_V_MF4_MF8,
  PseudoVSOXSEG6EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG6EI32_V_M1_M1,
  PseudoVSOXSEG6EI32_V_M1_M1_MASK,
  PseudoVSOXSEG6EI32_V_M1_MF2,
  PseudoVSOXSEG6EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG6EI32_V_M1_MF4,
  PseudoVSOXSEG6EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG6EI32_V_M2_M1,
  PseudoVSOXSEG6EI32_V_M2_M1_MASK,
  PseudoVSOXSEG6EI32_V_M2_MF2,
  PseudoVSOXSEG6EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG6EI32_V_M4_M1,
  PseudoVSOXSEG6EI32_V_M4_M1_MASK,
  PseudoVSOXSEG6EI32_V_MF2_M1,
  PseudoVSOXSEG6EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG6EI32_V_MF2_MF2,
  PseudoVSOXSEG6EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG6EI32_V_MF2_MF4,
  PseudoVSOXSEG6EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG6EI32_V_MF2_MF8,
  PseudoVSOXSEG6EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG6EI64_V_M1_M1,
  PseudoVSOXSEG6EI64_V_M1_M1_MASK,
  PseudoVSOXSEG6EI64_V_M1_MF2,
  PseudoVSOXSEG6EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG6EI64_V_M1_MF4,
  PseudoVSOXSEG6EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG6EI64_V_M1_MF8,
  PseudoVSOXSEG6EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG6EI64_V_M2_M1,
  PseudoVSOXSEG6EI64_V_M2_M1_MASK,
  PseudoVSOXSEG6EI64_V_M2_MF2,
  PseudoVSOXSEG6EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG6EI64_V_M2_MF4,
  PseudoVSOXSEG6EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG6EI64_V_M4_M1,
  PseudoVSOXSEG6EI64_V_M4_M1_MASK,
  PseudoVSOXSEG6EI64_V_M4_MF2,
  PseudoVSOXSEG6EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG6EI64_V_M8_M1,
  PseudoVSOXSEG6EI64_V_M8_M1_MASK,
  PseudoVSOXSEG6EI8_V_M1_M1,
  PseudoVSOXSEG6EI8_V_M1_M1_MASK,
  PseudoVSOXSEG6EI8_V_MF2_M1,
  PseudoVSOXSEG6EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG6EI8_V_MF2_MF2,
  PseudoVSOXSEG6EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG6EI8_V_MF4_M1,
  PseudoVSOXSEG6EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG6EI8_V_MF4_MF2,
  PseudoVSOXSEG6EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG6EI8_V_MF4_MF4,
  PseudoVSOXSEG6EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG6EI8_V_MF8_M1,
  PseudoVSOXSEG6EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG6EI8_V_MF8_MF2,
  PseudoVSOXSEG6EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG6EI8_V_MF8_MF4,
  PseudoVSOXSEG6EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG6EI8_V_MF8_MF8,
  PseudoVSOXSEG6EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG7EI16_V_M1_M1,
  PseudoVSOXSEG7EI16_V_M1_M1_MASK,
  PseudoVSOXSEG7EI16_V_M1_MF2,
  PseudoVSOXSEG7EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG7EI16_V_M2_M1,
  PseudoVSOXSEG7EI16_V_M2_M1_MASK,
  PseudoVSOXSEG7EI16_V_MF2_M1,
  PseudoVSOXSEG7EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG7EI16_V_MF2_MF2,
  PseudoVSOXSEG7EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG7EI16_V_MF2_MF4,
  PseudoVSOXSEG7EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG7EI16_V_MF4_M1,
  PseudoVSOXSEG7EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG7EI16_V_MF4_MF2,
  PseudoVSOXSEG7EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG7EI16_V_MF4_MF4,
  PseudoVSOXSEG7EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG7EI16_V_MF4_MF8,
  PseudoVSOXSEG7EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG7EI32_V_M1_M1,
  PseudoVSOXSEG7EI32_V_M1_M1_MASK,
  PseudoVSOXSEG7EI32_V_M1_MF2,
  PseudoVSOXSEG7EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG7EI32_V_M1_MF4,
  PseudoVSOXSEG7EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG7EI32_V_M2_M1,
  PseudoVSOXSEG7EI32_V_M2_M1_MASK,
  PseudoVSOXSEG7EI32_V_M2_MF2,
  PseudoVSOXSEG7EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG7EI32_V_M4_M1,
  PseudoVSOXSEG7EI32_V_M4_M1_MASK,
  PseudoVSOXSEG7EI32_V_MF2_M1,
  PseudoVSOXSEG7EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG7EI32_V_MF2_MF2,
  PseudoVSOXSEG7EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG7EI32_V_MF2_MF4,
  PseudoVSOXSEG7EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG7EI32_V_MF2_MF8,
  PseudoVSOXSEG7EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG7EI64_V_M1_M1,
  PseudoVSOXSEG7EI64_V_M1_M1_MASK,
  PseudoVSOXSEG7EI64_V_M1_MF2,
  PseudoVSOXSEG7EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG7EI64_V_M1_MF4,
  PseudoVSOXSEG7EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG7EI64_V_M1_MF8,
  PseudoVSOXSEG7EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG7EI64_V_M2_M1,
  PseudoVSOXSEG7EI64_V_M2_M1_MASK,
  PseudoVSOXSEG7EI64_V_M2_MF2,
  PseudoVSOXSEG7EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG7EI64_V_M2_MF4,
  PseudoVSOXSEG7EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG7EI64_V_M4_M1,
  PseudoVSOXSEG7EI64_V_M4_M1_MASK,
  PseudoVSOXSEG7EI64_V_M4_MF2,
  PseudoVSOXSEG7EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG7EI64_V_M8_M1,
  PseudoVSOXSEG7EI64_V_M8_M1_MASK,
  PseudoVSOXSEG7EI8_V_M1_M1,
  PseudoVSOXSEG7EI8_V_M1_M1_MASK,
  PseudoVSOXSEG7EI8_V_MF2_M1,
  PseudoVSOXSEG7EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG7EI8_V_MF2_MF2,
  PseudoVSOXSEG7EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG7EI8_V_MF4_M1,
  PseudoVSOXSEG7EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG7EI8_V_MF4_MF2,
  PseudoVSOXSEG7EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG7EI8_V_MF4_MF4,
  PseudoVSOXSEG7EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG7EI8_V_MF8_M1,
  PseudoVSOXSEG7EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG7EI8_V_MF8_MF2,
  PseudoVSOXSEG7EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG7EI8_V_MF8_MF4,
  PseudoVSOXSEG7EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG7EI8_V_MF8_MF8,
  PseudoVSOXSEG7EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG8EI16_V_M1_M1,
  PseudoVSOXSEG8EI16_V_M1_M1_MASK,
  PseudoVSOXSEG8EI16_V_M1_MF2,
  PseudoVSOXSEG8EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG8EI16_V_M2_M1,
  PseudoVSOXSEG8EI16_V_M2_M1_MASK,
  PseudoVSOXSEG8EI16_V_MF2_M1,
  PseudoVSOXSEG8EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG8EI16_V_MF2_MF2,
  PseudoVSOXSEG8EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG8EI16_V_MF2_MF4,
  PseudoVSOXSEG8EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG8EI16_V_MF4_M1,
  PseudoVSOXSEG8EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG8EI16_V_MF4_MF2,
  PseudoVSOXSEG8EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG8EI16_V_MF4_MF4,
  PseudoVSOXSEG8EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG8EI16_V_MF4_MF8,
  PseudoVSOXSEG8EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG8EI32_V_M1_M1,
  PseudoVSOXSEG8EI32_V_M1_M1_MASK,
  PseudoVSOXSEG8EI32_V_M1_MF2,
  PseudoVSOXSEG8EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG8EI32_V_M1_MF4,
  PseudoVSOXSEG8EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG8EI32_V_M2_M1,
  PseudoVSOXSEG8EI32_V_M2_M1_MASK,
  PseudoVSOXSEG8EI32_V_M2_MF2,
  PseudoVSOXSEG8EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG8EI32_V_M4_M1,
  PseudoVSOXSEG8EI32_V_M4_M1_MASK,
  PseudoVSOXSEG8EI32_V_MF2_M1,
  PseudoVSOXSEG8EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG8EI32_V_MF2_MF2,
  PseudoVSOXSEG8EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG8EI32_V_MF2_MF4,
  PseudoVSOXSEG8EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG8EI32_V_MF2_MF8,
  PseudoVSOXSEG8EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG8EI64_V_M1_M1,
  PseudoVSOXSEG8EI64_V_M1_M1_MASK,
  PseudoVSOXSEG8EI64_V_M1_MF2,
  PseudoVSOXSEG8EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG8EI64_V_M1_MF4,
  PseudoVSOXSEG8EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG8EI64_V_M1_MF8,
  PseudoVSOXSEG8EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG8EI64_V_M2_M1,
  PseudoVSOXSEG8EI64_V_M2_M1_MASK,
  PseudoVSOXSEG8EI64_V_M2_MF2,
  PseudoVSOXSEG8EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG8EI64_V_M2_MF4,
  PseudoVSOXSEG8EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG8EI64_V_M4_M1,
  PseudoVSOXSEG8EI64_V_M4_M1_MASK,
  PseudoVSOXSEG8EI64_V_M4_MF2,
  PseudoVSOXSEG8EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG8EI64_V_M8_M1,
  PseudoVSOXSEG8EI64_V_M8_M1_MASK,
  PseudoVSOXSEG8EI8_V_M1_M1,
  PseudoVSOXSEG8EI8_V_M1_M1_MASK,
  PseudoVSOXSEG8EI8_V_MF2_M1,
  PseudoVSOXSEG8EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG8EI8_V_MF2_MF2,
  PseudoVSOXSEG8EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG8EI8_V_MF4_M1,
  PseudoVSOXSEG8EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG8EI8_V_MF4_MF2,
  PseudoVSOXSEG8EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG8EI8_V_MF4_MF4,
  PseudoVSOXSEG8EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG8EI8_V_MF8_M1,
  PseudoVSOXSEG8EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG8EI8_V_MF8_MF2,
  PseudoVSOXSEG8EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG8EI8_V_MF8_MF4,
  PseudoVSOXSEG8EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG8EI8_V_MF8_MF8,
  PseudoVSOXSEG8EI8_V_MF8_MF8_MASK,
  PseudoVSPILL2_M1,
  PseudoVSPILL2_M2,
  PseudoVSPILL2_M4,
  PseudoVSPILL2_MF2,
  PseudoVSPILL2_MF4,
  PseudoVSPILL2_MF8,
  PseudoVSPILL3_M1,
  PseudoVSPILL3_M2,
  PseudoVSPILL3_MF2,
  PseudoVSPILL3_MF4,
  PseudoVSPILL3_MF8,
  PseudoVSPILL4_M1,
  PseudoVSPILL4_M2,
  PseudoVSPILL4_MF2,
  PseudoVSPILL4_MF4,
  PseudoVSPILL4_MF8,
  PseudoVSPILL5_M1,
  PseudoVSPILL5_MF2,
  PseudoVSPILL5_MF4,
  PseudoVSPILL5_MF8,
  PseudoVSPILL6_M1,
  PseudoVSPILL6_MF2,
  PseudoVSPILL6_MF4,
  PseudoVSPILL6_MF8,
  PseudoVSPILL7_M1,
  PseudoVSPILL7_MF2,
  PseudoVSPILL7_MF4,
  PseudoVSPILL7_MF8,
  PseudoVSPILL8_M1,
  PseudoVSPILL8_MF2,
  PseudoVSPILL8_MF4,
  PseudoVSPILL8_MF8,
  PseudoVSRA_VI_M1,
  PseudoVSRA_VI_M1_MASK,
  PseudoVSRA_VI_M2,
  PseudoVSRA_VI_M2_MASK,
  PseudoVSRA_VI_M4,
  PseudoVSRA_VI_M4_MASK,
  PseudoVSRA_VI_M8,
  PseudoVSRA_VI_M8_MASK,
  PseudoVSRA_VI_MF2,
  PseudoVSRA_VI_MF2_MASK,
  PseudoVSRA_VI_MF4,
  PseudoVSRA_VI_MF4_MASK,
  PseudoVSRA_VI_MF8,
  PseudoVSRA_VI_MF8_MASK,
  PseudoVSRA_VV_M1,
  PseudoVSRA_VV_M1_MASK,
  PseudoVSRA_VV_M2,
  PseudoVSRA_VV_M2_MASK,
  PseudoVSRA_VV_M4,
  PseudoVSRA_VV_M4_MASK,
  PseudoVSRA_VV_M8,
  PseudoVSRA_VV_M8_MASK,
  PseudoVSRA_VV_MF2,
  PseudoVSRA_VV_MF2_MASK,
  PseudoVSRA_VV_MF4,
  PseudoVSRA_VV_MF4_MASK,
  PseudoVSRA_VV_MF8,
  PseudoVSRA_VV_MF8_MASK,
  PseudoVSRA_VX_M1,
  PseudoVSRA_VX_M1_MASK,
  PseudoVSRA_VX_M2,
  PseudoVSRA_VX_M2_MASK,
  PseudoVSRA_VX_M4,
  PseudoVSRA_VX_M4_MASK,
  PseudoVSRA_VX_M8,
  PseudoVSRA_VX_M8_MASK,
  PseudoVSRA_VX_MF2,
  PseudoVSRA_VX_MF2_MASK,
  PseudoVSRA_VX_MF4,
  PseudoVSRA_VX_MF4_MASK,
  PseudoVSRA_VX_MF8,
  PseudoVSRA_VX_MF8_MASK,
  PseudoVSRL_VI_M1,
  PseudoVSRL_VI_M1_MASK,
  PseudoVSRL_VI_M2,
  PseudoVSRL_VI_M2_MASK,
  PseudoVSRL_VI_M4,
  PseudoVSRL_VI_M4_MASK,
  PseudoVSRL_VI_M8,
  PseudoVSRL_VI_M8_MASK,
  PseudoVSRL_VI_MF2,
  PseudoVSRL_VI_MF2_MASK,
  PseudoVSRL_VI_MF4,
  PseudoVSRL_VI_MF4_MASK,
  PseudoVSRL_VI_MF8,
  PseudoVSRL_VI_MF8_MASK,
  PseudoVSRL_VV_M1,
  PseudoVSRL_VV_M1_MASK,
  PseudoVSRL_VV_M2,
  PseudoVSRL_VV_M2_MASK,
  PseudoVSRL_VV_M4,
  PseudoVSRL_VV_M4_MASK,
  PseudoVSRL_VV_M8,
  PseudoVSRL_VV_M8_MASK,
  PseudoVSRL_VV_MF2,
  PseudoVSRL_VV_MF2_MASK,
  PseudoVSRL_VV_MF4,
  PseudoVSRL_VV_MF4_MASK,
  PseudoVSRL_VV_MF8,
  PseudoVSRL_VV_MF8_MASK,
  PseudoVSRL_VX_M1,
  PseudoVSRL_VX_M1_MASK,
  PseudoVSRL_VX_M2,
  PseudoVSRL_VX_M2_MASK,
  PseudoVSRL_VX_M4,
  PseudoVSRL_VX_M4_MASK,
  PseudoVSRL_VX_M8,
  PseudoVSRL_VX_M8_MASK,
  PseudoVSRL_VX_MF2,
  PseudoVSRL_VX_MF2_MASK,
  PseudoVSRL_VX_MF4,
  PseudoVSRL_VX_MF4_MASK,
  PseudoVSRL_VX_MF8,
  PseudoVSRL_VX_MF8_MASK,
  PseudoVSSE16_V_M1,
  PseudoVSSE16_V_M1_MASK,
  PseudoVSSE16_V_M2,
  PseudoVSSE16_V_M2_MASK,
  PseudoVSSE16_V_M4,
  PseudoVSSE16_V_M4_MASK,
  PseudoVSSE16_V_M8,
  PseudoVSSE16_V_M8_MASK,
  PseudoVSSE16_V_MF2,
  PseudoVSSE16_V_MF2_MASK,
  PseudoVSSE16_V_MF4,
  PseudoVSSE16_V_MF4_MASK,
  PseudoVSSE32_V_M1,
  PseudoVSSE32_V_M1_MASK,
  PseudoVSSE32_V_M2,
  PseudoVSSE32_V_M2_MASK,
  PseudoVSSE32_V_M4,
  PseudoVSSE32_V_M4_MASK,
  PseudoVSSE32_V_M8,
  PseudoVSSE32_V_M8_MASK,
  PseudoVSSE32_V_MF2,
  PseudoVSSE32_V_MF2_MASK,
  PseudoVSSE64_V_M1,
  PseudoVSSE64_V_M1_MASK,
  PseudoVSSE64_V_M2,
  PseudoVSSE64_V_M2_MASK,
  PseudoVSSE64_V_M4,
  PseudoVSSE64_V_M4_MASK,
  PseudoVSSE64_V_M8,
  PseudoVSSE64_V_M8_MASK,
  PseudoVSSE8_V_M1,
  PseudoVSSE8_V_M1_MASK,
  PseudoVSSE8_V_M2,
  PseudoVSSE8_V_M2_MASK,
  PseudoVSSE8_V_M4,
  PseudoVSSE8_V_M4_MASK,
  PseudoVSSE8_V_M8,
  PseudoVSSE8_V_M8_MASK,
  PseudoVSSE8_V_MF2,
  PseudoVSSE8_V_MF2_MASK,
  PseudoVSSE8_V_MF4,
  PseudoVSSE8_V_MF4_MASK,
  PseudoVSSE8_V_MF8,
  PseudoVSSE8_V_MF8_MASK,
  PseudoVSSEG2E16_V_M1,
  PseudoVSSEG2E16_V_M1_MASK,
  PseudoVSSEG2E16_V_M2,
  PseudoVSSEG2E16_V_M2_MASK,
  PseudoVSSEG2E16_V_M4,
  PseudoVSSEG2E16_V_M4_MASK,
  PseudoVSSEG2E16_V_MF2,
  PseudoVSSEG2E16_V_MF2_MASK,
  PseudoVSSEG2E16_V_MF4,
  PseudoVSSEG2E16_V_MF4_MASK,
  PseudoVSSEG2E32_V_M1,
  PseudoVSSEG2E32_V_M1_MASK,
  PseudoVSSEG2E32_V_M2,
  PseudoVSSEG2E32_V_M2_MASK,
  PseudoVSSEG2E32_V_M4,
  PseudoVSSEG2E32_V_M4_MASK,
  PseudoVSSEG2E32_V_MF2,
  PseudoVSSEG2E32_V_MF2_MASK,
  PseudoVSSEG2E64_V_M1,
  PseudoVSSEG2E64_V_M1_MASK,
  PseudoVSSEG2E64_V_M2,
  PseudoVSSEG2E64_V_M2_MASK,
  PseudoVSSEG2E64_V_M4,
  PseudoVSSEG2E64_V_M4_MASK,
  PseudoVSSEG2E8_V_M1,
  PseudoVSSEG2E8_V_M1_MASK,
  PseudoVSSEG2E8_V_M2,
  PseudoVSSEG2E8_V_M2_MASK,
  PseudoVSSEG2E8_V_M4,
  PseudoVSSEG2E8_V_M4_MASK,
  PseudoVSSEG2E8_V_MF2,
  PseudoVSSEG2E8_V_MF2_MASK,
  PseudoVSSEG2E8_V_MF4,
  PseudoVSSEG2E8_V_MF4_MASK,
  PseudoVSSEG2E8_V_MF8,
  PseudoVSSEG2E8_V_MF8_MASK,
  PseudoVSSEG3E16_V_M1,
  PseudoVSSEG3E16_V_M1_MASK,
  PseudoVSSEG3E16_V_M2,
  PseudoVSSEG3E16_V_M2_MASK,
  PseudoVSSEG3E16_V_MF2,
  PseudoVSSEG3E16_V_MF2_MASK,
  PseudoVSSEG3E16_V_MF4,
  PseudoVSSEG3E16_V_MF4_MASK,
  PseudoVSSEG3E32_V_M1,
  PseudoVSSEG3E32_V_M1_MASK,
  PseudoVSSEG3E32_V_M2,
  PseudoVSSEG3E32_V_M2_MASK,
  PseudoVSSEG3E32_V_MF2,
  PseudoVSSEG3E32_V_MF2_MASK,
  PseudoVSSEG3E64_V_M1,
  PseudoVSSEG3E64_V_M1_MASK,
  PseudoVSSEG3E64_V_M2,
  PseudoVSSEG3E64_V_M2_MASK,
  PseudoVSSEG3E8_V_M1,
  PseudoVSSEG3E8_V_M1_MASK,
  PseudoVSSEG3E8_V_M2,
  PseudoVSSEG3E8_V_M2_MASK,
  PseudoVSSEG3E8_V_MF2,
  PseudoVSSEG3E8_V_MF2_MASK,
  PseudoVSSEG3E8_V_MF4,
  PseudoVSSEG3E8_V_MF4_MASK,
  PseudoVSSEG3E8_V_MF8,
  PseudoVSSEG3E8_V_MF8_MASK,
  PseudoVSSEG4E16_V_M1,
  PseudoVSSEG4E16_V_M1_MASK,
  PseudoVSSEG4E16_V_M2,
  PseudoVSSEG4E16_V_M2_MASK,
  PseudoVSSEG4E16_V_MF2,
  PseudoVSSEG4E16_V_MF2_MASK,
  PseudoVSSEG4E16_V_MF4,
  PseudoVSSEG4E16_V_MF4_MASK,
  PseudoVSSEG4E32_V_M1,
  PseudoVSSEG4E32_V_M1_MASK,
  PseudoVSSEG4E32_V_M2,
  PseudoVSSEG4E32_V_M2_MASK,
  PseudoVSSEG4E32_V_MF2,
  PseudoVSSEG4E32_V_MF2_MASK,
  PseudoVSSEG4E64_V_M1,
  PseudoVSSEG4E64_V_M1_MASK,
  PseudoVSSEG4E64_V_M2,
  PseudoVSSEG4E64_V_M2_MASK,
  PseudoVSSEG4E8_V_M1,
  PseudoVSSEG4E8_V_M1_MASK,
  PseudoVSSEG4E8_V_M2,
  PseudoVSSEG4E8_V_M2_MASK,
  PseudoVSSEG4E8_V_MF2,
  PseudoVSSEG4E8_V_MF2_MASK,
  PseudoVSSEG4E8_V_MF4,
  PseudoVSSEG4E8_V_MF4_MASK,
  PseudoVSSEG4E8_V_MF8,
  PseudoVSSEG4E8_V_MF8_MASK,
  PseudoVSSEG5E16_V_M1,
  PseudoVSSEG5E16_V_M1_MASK,
  PseudoVSSEG5E16_V_MF2,
  PseudoVSSEG5E16_V_MF2_MASK,
  PseudoVSSEG5E16_V_MF4,
  PseudoVSSEG5E16_V_MF4_MASK,
  PseudoVSSEG5E32_V_M1,
  PseudoVSSEG5E32_V_M1_MASK,
  PseudoVSSEG5E32_V_MF2,
  PseudoVSSEG5E32_V_MF2_MASK,
  PseudoVSSEG5E64_V_M1,
  PseudoVSSEG5E64_V_M1_MASK,
  PseudoVSSEG5E8_V_M1,
  PseudoVSSEG5E8_V_M1_MASK,
  PseudoVSSEG5E8_V_MF2,
  PseudoVSSEG5E8_V_MF2_MASK,
  PseudoVSSEG5E8_V_MF4,
  PseudoVSSEG5E8_V_MF4_MASK,
  PseudoVSSEG5E8_V_MF8,
  PseudoVSSEG5E8_V_MF8_MASK,
  PseudoVSSEG6E16_V_M1,
  PseudoVSSEG6E16_V_M1_MASK,
  PseudoVSSEG6E16_V_MF2,
  PseudoVSSEG6E16_V_MF2_MASK,
  PseudoVSSEG6E16_V_MF4,
  PseudoVSSEG6E16_V_MF4_MASK,
  PseudoVSSEG6E32_V_M1,
  PseudoVSSEG6E32_V_M1_MASK,
  PseudoVSSEG6E32_V_MF2,
  PseudoVSSEG6E32_V_MF2_MASK,
  PseudoVSSEG6E64_V_M1,
  PseudoVSSEG6E64_V_M1_MASK,
  PseudoVSSEG6E8_V_M1,
  PseudoVSSEG6E8_V_M1_MASK,
  PseudoVSSEG6E8_V_MF2,
  PseudoVSSEG6E8_V_MF2_MASK,
  PseudoVSSEG6E8_V_MF4,
  PseudoVSSEG6E8_V_MF4_MASK,
  PseudoVSSEG6E8_V_MF8,
  PseudoVSSEG6E8_V_MF8_MASK,
  PseudoVSSEG7E16_V_M1,
  PseudoVSSEG7E16_V_M1_MASK,
  PseudoVSSEG7E16_V_MF2,
  PseudoVSSEG7E16_V_MF2_MASK,
  PseudoVSSEG7E16_V_MF4,
  PseudoVSSEG7E16_V_MF4_MASK,
  PseudoVSSEG7E32_V_M1,
  PseudoVSSEG7E32_V_M1_MASK,
  PseudoVSSEG7E32_V_MF2,
  PseudoVSSEG7E32_V_MF2_MASK,
  PseudoVSSEG7E64_V_M1,
  PseudoVSSEG7E64_V_M1_MASK,
  PseudoVSSEG7E8_V_M1,
  PseudoVSSEG7E8_V_M1_MASK,
  PseudoVSSEG7E8_V_MF2,
  PseudoVSSEG7E8_V_MF2_MASK,
  PseudoVSSEG7E8_V_MF4,
  PseudoVSSEG7E8_V_MF4_MASK,
  PseudoVSSEG7E8_V_MF8,
  PseudoVSSEG7E8_V_MF8_MASK,
  PseudoVSSEG8E16_V_M1,
  PseudoVSSEG8E16_V_M1_MASK,
  PseudoVSSEG8E16_V_MF2,
  PseudoVSSEG8E16_V_MF2_MASK,
  PseudoVSSEG8E16_V_MF4,
  PseudoVSSEG8E16_V_MF4_MASK,
  PseudoVSSEG8E32_V_M1,
  PseudoVSSEG8E32_V_M1_MASK,
  PseudoVSSEG8E32_V_MF2,
  PseudoVSSEG8E32_V_MF2_MASK,
  PseudoVSSEG8E64_V_M1,
  PseudoVSSEG8E64_V_M1_MASK,
  PseudoVSSEG8E8_V_M1,
  PseudoVSSEG8E8_V_M1_MASK,
  PseudoVSSEG8E8_V_MF2,
  PseudoVSSEG8E8_V_MF2_MASK,
  PseudoVSSEG8E8_V_MF4,
  PseudoVSSEG8E8_V_MF4_MASK,
  PseudoVSSEG8E8_V_MF8,
  PseudoVSSEG8E8_V_MF8_MASK,
  PseudoVSSRA_VI_M1,
  PseudoVSSRA_VI_M1_MASK,
  PseudoVSSRA_VI_M2,
  PseudoVSSRA_VI_M2_MASK,
  PseudoVSSRA_VI_M4,
  PseudoVSSRA_VI_M4_MASK,
  PseudoVSSRA_VI_M8,
  PseudoVSSRA_VI_M8_MASK,
  PseudoVSSRA_VI_MF2,
  PseudoVSSRA_VI_MF2_MASK,
  PseudoVSSRA_VI_MF4,
  PseudoVSSRA_VI_MF4_MASK,
  PseudoVSSRA_VI_MF8,
  PseudoVSSRA_VI_MF8_MASK,
  PseudoVSSRA_VV_M1,
  PseudoVSSRA_VV_M1_MASK,
  PseudoVSSRA_VV_M2,
  PseudoVSSRA_VV_M2_MASK,
  PseudoVSSRA_VV_M4,
  PseudoVSSRA_VV_M4_MASK,
  PseudoVSSRA_VV_M8,
  PseudoVSSRA_VV_M8_MASK,
  PseudoVSSRA_VV_MF2,
  PseudoVSSRA_VV_MF2_MASK,
  PseudoVSSRA_VV_MF4,
  PseudoVSSRA_VV_MF4_MASK,
  PseudoVSSRA_VV_MF8,
  PseudoVSSRA_VV_MF8_MASK,
  PseudoVSSRA_VX_M1,
  PseudoVSSRA_VX_M1_MASK,
  PseudoVSSRA_VX_M2,
  PseudoVSSRA_VX_M2_MASK,
  PseudoVSSRA_VX_M4,
  PseudoVSSRA_VX_M4_MASK,
  PseudoVSSRA_VX_M8,
  PseudoVSSRA_VX_M8_MASK,
  PseudoVSSRA_VX_MF2,
  PseudoVSSRA_VX_MF2_MASK,
  PseudoVSSRA_VX_MF4,
  PseudoVSSRA_VX_MF4_MASK,
  PseudoVSSRA_VX_MF8,
  PseudoVSSRA_VX_MF8_MASK,
  PseudoVSSRL_VI_M1,
  PseudoVSSRL_VI_M1_MASK,
  PseudoVSSRL_VI_M2,
  PseudoVSSRL_VI_M2_MASK,
  PseudoVSSRL_VI_M4,
  PseudoVSSRL_VI_M4_MASK,
  PseudoVSSRL_VI_M8,
  PseudoVSSRL_VI_M8_MASK,
  PseudoVSSRL_VI_MF2,
  PseudoVSSRL_VI_MF2_MASK,
  PseudoVSSRL_VI_MF4,
  PseudoVSSRL_VI_MF4_MASK,
  PseudoVSSRL_VI_MF8,
  PseudoVSSRL_VI_MF8_MASK,
  PseudoVSSRL_VV_M1,
  PseudoVSSRL_VV_M1_MASK,
  PseudoVSSRL_VV_M2,
  PseudoVSSRL_VV_M2_MASK,
  PseudoVSSRL_VV_M4,
  PseudoVSSRL_VV_M4_MASK,
  PseudoVSSRL_VV_M8,
  PseudoVSSRL_VV_M8_MASK,
  PseudoVSSRL_VV_MF2,
  PseudoVSSRL_VV_MF2_MASK,
  PseudoVSSRL_VV_MF4,
  PseudoVSSRL_VV_MF4_MASK,
  PseudoVSSRL_VV_MF8,
  PseudoVSSRL_VV_MF8_MASK,
  PseudoVSSRL_VX_M1,
  PseudoVSSRL_VX_M1_MASK,
  PseudoVSSRL_VX_M2,
  PseudoVSSRL_VX_M2_MASK,
  PseudoVSSRL_VX_M4,
  PseudoVSSRL_VX_M4_MASK,
  PseudoVSSRL_VX_M8,
  PseudoVSSRL_VX_M8_MASK,
  PseudoVSSRL_VX_MF2,
  PseudoVSSRL_VX_MF2_MASK,
  PseudoVSSRL_VX_MF4,
  PseudoVSSRL_VX_MF4_MASK,
  PseudoVSSRL_VX_MF8,
  PseudoVSSRL_VX_MF8_MASK,
  PseudoVSSSEG2E16_V_M1,
  PseudoVSSSEG2E16_V_M1_MASK,
  PseudoVSSSEG2E16_V_M2,
  PseudoVSSSEG2E16_V_M2_MASK,
  PseudoVSSSEG2E16_V_M4,
  PseudoVSSSEG2E16_V_M4_MASK,
  PseudoVSSSEG2E16_V_MF2,
  PseudoVSSSEG2E16_V_MF2_MASK,
  PseudoVSSSEG2E16_V_MF4,
  PseudoVSSSEG2E16_V_MF4_MASK,
  PseudoVSSSEG2E32_V_M1,
  PseudoVSSSEG2E32_V_M1_MASK,
  PseudoVSSSEG2E32_V_M2,
  PseudoVSSSEG2E32_V_M2_MASK,
  PseudoVSSSEG2E32_V_M4,
  PseudoVSSSEG2E32_V_M4_MASK,
  PseudoVSSSEG2E32_V_MF2,
  PseudoVSSSEG2E32_V_MF2_MASK,
  PseudoVSSSEG2E64_V_M1,
  PseudoVSSSEG2E64_V_M1_MASK,
  PseudoVSSSEG2E64_V_M2,
  PseudoVSSSEG2E64_V_M2_MASK,
  PseudoVSSSEG2E64_V_M4,
  PseudoVSSSEG2E64_V_M4_MASK,
  PseudoVSSSEG2E8_V_M1,
  PseudoVSSSEG2E8_V_M1_MASK,
  PseudoVSSSEG2E8_V_M2,
  PseudoVSSSEG2E8_V_M2_MASK,
  PseudoVSSSEG2E8_V_M4,
  PseudoVSSSEG2E8_V_M4_MASK,
  PseudoVSSSEG2E8_V_MF2,
  PseudoVSSSEG2E8_V_MF2_MASK,
  PseudoVSSSEG2E8_V_MF4,
  PseudoVSSSEG2E8_V_MF4_MASK,
  PseudoVSSSEG2E8_V_MF8,
  PseudoVSSSEG2E8_V_MF8_MASK,
  PseudoVSSSEG3E16_V_M1,
  PseudoVSSSEG3E16_V_M1_MASK,
  PseudoVSSSEG3E16_V_M2,
  PseudoVSSSEG3E16_V_M2_MASK,
  PseudoVSSSEG3E16_V_MF2,
  PseudoVSSSEG3E16_V_MF2_MASK,
  PseudoVSSSEG3E16_V_MF4,
  PseudoVSSSEG3E16_V_MF4_MASK,
  PseudoVSSSEG3E32_V_M1,
  PseudoVSSSEG3E32_V_M1_MASK,
  PseudoVSSSEG3E32_V_M2,
  PseudoVSSSEG3E32_V_M2_MASK,
  PseudoVSSSEG3E32_V_MF2,
  PseudoVSSSEG3E32_V_MF2_MASK,
  PseudoVSSSEG3E64_V_M1,
  PseudoVSSSEG3E64_V_M1_MASK,
  PseudoVSSSEG3E64_V_M2,
  PseudoVSSSEG3E64_V_M2_MASK,
  PseudoVSSSEG3E8_V_M1,
  PseudoVSSSEG3E8_V_M1_MASK,
  PseudoVSSSEG3E8_V_M2,
  PseudoVSSSEG3E8_V_M2_MASK,
  PseudoVSSSEG3E8_V_MF2,
  PseudoVSSSEG3E8_V_MF2_MASK,
  PseudoVSSSEG3E8_V_MF4,
  PseudoVSSSEG3E8_V_MF4_MASK,
  PseudoVSSSEG3E8_V_MF8,
  PseudoVSSSEG3E8_V_MF8_MASK,
  PseudoVSSSEG4E16_V_M1,
  PseudoVSSSEG4E16_V_M1_MASK,
  PseudoVSSSEG4E16_V_M2,
  PseudoVSSSEG4E16_V_M2_MASK,
  PseudoVSSSEG4E16_V_MF2,
  PseudoVSSSEG4E16_V_MF2_MASK,
  PseudoVSSSEG4E16_V_MF4,
  PseudoVSSSEG4E16_V_MF4_MASK,
  PseudoVSSSEG4E32_V_M1,
  PseudoVSSSEG4E32_V_M1_MASK,
  PseudoVSSSEG4E32_V_M2,
  PseudoVSSSEG4E32_V_M2_MASK,
  PseudoVSSSEG4E32_V_MF2,
  PseudoVSSSEG4E32_V_MF2_MASK,
  PseudoVSSSEG4E64_V_M1,
  PseudoVSSSEG4E64_V_M1_MASK,
  PseudoVSSSEG4E64_V_M2,
  PseudoVSSSEG4E64_V_M2_MASK,
  PseudoVSSSEG4E8_V_M1,
  PseudoVSSSEG4E8_V_M1_MASK,
  PseudoVSSSEG4E8_V_M2,
  PseudoVSSSEG4E8_V_M2_MASK,
  PseudoVSSSEG4E8_V_MF2,
  PseudoVSSSEG4E8_V_MF2_MASK,
  PseudoVSSSEG4E8_V_MF4,
  PseudoVSSSEG4E8_V_MF4_MASK,
  PseudoVSSSEG4E8_V_MF8,
  PseudoVSSSEG4E8_V_MF8_MASK,
  PseudoVSSSEG5E16_V_M1,
  PseudoVSSSEG5E16_V_M1_MASK,
  PseudoVSSSEG5E16_V_MF2,
  PseudoVSSSEG5E16_V_MF2_MASK,
  PseudoVSSSEG5E16_V_MF4,
  PseudoVSSSEG5E16_V_MF4_MASK,
  PseudoVSSSEG5E32_V_M1,
  PseudoVSSSEG5E32_V_M1_MASK,
  PseudoVSSSEG5E32_V_MF2,
  PseudoVSSSEG5E32_V_MF2_MASK,
  PseudoVSSSEG5E64_V_M1,
  PseudoVSSSEG5E64_V_M1_MASK,
  PseudoVSSSEG5E8_V_M1,
  PseudoVSSSEG5E8_V_M1_MASK,
  PseudoVSSSEG5E8_V_MF2,
  PseudoVSSSEG5E8_V_MF2_MASK,
  PseudoVSSSEG5E8_V_MF4,
  PseudoVSSSEG5E8_V_MF4_MASK,
  PseudoVSSSEG5E8_V_MF8,
  PseudoVSSSEG5E8_V_MF8_MASK,
  PseudoVSSSEG6E16_V_M1,
  PseudoVSSSEG6E16_V_M1_MASK,
  PseudoVSSSEG6E16_V_MF2,
  PseudoVSSSEG6E16_V_MF2_MASK,
  PseudoVSSSEG6E16_V_MF4,
  PseudoVSSSEG6E16_V_MF4_MASK,
  PseudoVSSSEG6E32_V_M1,
  PseudoVSSSEG6E32_V_M1_MASK,
  PseudoVSSSEG6E32_V_MF2,
  PseudoVSSSEG6E32_V_MF2_MASK,
  PseudoVSSSEG6E64_V_M1,
  PseudoVSSSEG6E64_V_M1_MASK,
  PseudoVSSSEG6E8_V_M1,
  PseudoVSSSEG6E8_V_M1_MASK,
  PseudoVSSSEG6E8_V_MF2,
  PseudoVSSSEG6E8_V_MF2_MASK,
  PseudoVSSSEG6E8_V_MF4,
  PseudoVSSSEG6E8_V_MF4_MASK,
  PseudoVSSSEG6E8_V_MF8,
  PseudoVSSSEG6E8_V_MF8_MASK,
  PseudoVSSSEG7E16_V_M1,
  PseudoVSSSEG7E16_V_M1_MASK,
  PseudoVSSSEG7E16_V_MF2,
  PseudoVSSSEG7E16_V_MF2_MASK,
  PseudoVSSSEG7E16_V_MF4,
  PseudoVSSSEG7E16_V_MF4_MASK,
  PseudoVSSSEG7E32_V_M1,
  PseudoVSSSEG7E32_V_M1_MASK,
  PseudoVSSSEG7E32_V_MF2,
  PseudoVSSSEG7E32_V_MF2_MASK,
  PseudoVSSSEG7E64_V_M1,
  PseudoVSSSEG7E64_V_M1_MASK,
  PseudoVSSSEG7E8_V_M1,
  PseudoVSSSEG7E8_V_M1_MASK,
  PseudoVSSSEG7E8_V_MF2,
  PseudoVSSSEG7E8_V_MF2_MASK,
  PseudoVSSSEG7E8_V_MF4,
  PseudoVSSSEG7E8_V_MF4_MASK,
  PseudoVSSSEG7E8_V_MF8,
  PseudoVSSSEG7E8_V_MF8_MASK,
  PseudoVSSSEG8E16_V_M1,
  PseudoVSSSEG8E16_V_M1_MASK,
  PseudoVSSSEG8E16_V_MF2,
  PseudoVSSSEG8E16_V_MF2_MASK,
  PseudoVSSSEG8E16_V_MF4,
  PseudoVSSSEG8E16_V_MF4_MASK,
  PseudoVSSSEG8E32_V_M1,
  PseudoVSSSEG8E32_V_M1_MASK,
  PseudoVSSSEG8E32_V_MF2,
  PseudoVSSSEG8E32_V_MF2_MASK,
  PseudoVSSSEG8E64_V_M1,
  PseudoVSSSEG8E64_V_M1_MASK,
  PseudoVSSSEG8E8_V_M1,
  PseudoVSSSEG8E8_V_M1_MASK,
  PseudoVSSSEG8E8_V_MF2,
  PseudoVSSSEG8E8_V_MF2_MASK,
  PseudoVSSSEG8E8_V_MF4,
  PseudoVSSSEG8E8_V_MF4_MASK,
  PseudoVSSSEG8E8_V_MF8,
  PseudoVSSSEG8E8_V_MF8_MASK,
  PseudoVSSUBU_VV_M1,
  PseudoVSSUBU_VV_M1_MASK,
  PseudoVSSUBU_VV_M2,
  PseudoVSSUBU_VV_M2_MASK,
  PseudoVSSUBU_VV_M4,
  PseudoVSSUBU_VV_M4_MASK,
  PseudoVSSUBU_VV_M8,
  PseudoVSSUBU_VV_M8_MASK,
  PseudoVSSUBU_VV_MF2,
  PseudoVSSUBU_VV_MF2_MASK,
  PseudoVSSUBU_VV_MF4,
  PseudoVSSUBU_VV_MF4_MASK,
  PseudoVSSUBU_VV_MF8,
  PseudoVSSUBU_VV_MF8_MASK,
  PseudoVSSUBU_VX_M1,
  PseudoVSSUBU_VX_M1_MASK,
  PseudoVSSUBU_VX_M2,
  PseudoVSSUBU_VX_M2_MASK,
  PseudoVSSUBU_VX_M4,
  PseudoVSSUBU_VX_M4_MASK,
  PseudoVSSUBU_VX_M8,
  PseudoVSSUBU_VX_M8_MASK,
  PseudoVSSUBU_VX_MF2,
  PseudoVSSUBU_VX_MF2_MASK,
  PseudoVSSUBU_VX_MF4,
  PseudoVSSUBU_VX_MF4_MASK,
  PseudoVSSUBU_VX_MF8,
  PseudoVSSUBU_VX_MF8_MASK,
  PseudoVSSUB_VV_M1,
  PseudoVSSUB_VV_M1_MASK,
  PseudoVSSUB_VV_M2,
  PseudoVSSUB_VV_M2_MASK,
  PseudoVSSUB_VV_M4,
  PseudoVSSUB_VV_M4_MASK,
  PseudoVSSUB_VV_M8,
  PseudoVSSUB_VV_M8_MASK,
  PseudoVSSUB_VV_MF2,
  PseudoVSSUB_VV_MF2_MASK,
  PseudoVSSUB_VV_MF4,
  PseudoVSSUB_VV_MF4_MASK,
  PseudoVSSUB_VV_MF8,
  PseudoVSSUB_VV_MF8_MASK,
  PseudoVSSUB_VX_M1,
  PseudoVSSUB_VX_M1_MASK,
  PseudoVSSUB_VX_M2,
  PseudoVSSUB_VX_M2_MASK,
  PseudoVSSUB_VX_M4,
  PseudoVSSUB_VX_M4_MASK,
  PseudoVSSUB_VX_M8,
  PseudoVSSUB_VX_M8_MASK,
  PseudoVSSUB_VX_MF2,
  PseudoVSSUB_VX_MF2_MASK,
  PseudoVSSUB_VX_MF4,
  PseudoVSSUB_VX_MF4_MASK,
  PseudoVSSUB_VX_MF8,
  PseudoVSSUB_VX_MF8_MASK,
  PseudoVSUB_VV_M1,
  PseudoVSUB_VV_M1_MASK,
  PseudoVSUB_VV_M2,
  PseudoVSUB_VV_M2_MASK,
  PseudoVSUB_VV_M4,
  PseudoVSUB_VV_M4_MASK,
  PseudoVSUB_VV_M8,
  PseudoVSUB_VV_M8_MASK,
  PseudoVSUB_VV_MF2,
  PseudoVSUB_VV_MF2_MASK,
  PseudoVSUB_VV_MF4,
  PseudoVSUB_VV_MF4_MASK,
  PseudoVSUB_VV_MF8,
  PseudoVSUB_VV_MF8_MASK,
  PseudoVSUB_VX_M1,
  PseudoVSUB_VX_M1_MASK,
  PseudoVSUB_VX_M2,
  PseudoVSUB_VX_M2_MASK,
  PseudoVSUB_VX_M4,
  PseudoVSUB_VX_M4_MASK,
  PseudoVSUB_VX_M8,
  PseudoVSUB_VX_M8_MASK,
  PseudoVSUB_VX_MF2,
  PseudoVSUB_VX_MF2_MASK,
  PseudoVSUB_VX_MF4,
  PseudoVSUB_VX_MF4_MASK,
  PseudoVSUB_VX_MF8,
  PseudoVSUB_VX_MF8_MASK,
  PseudoVSUXEI16_V_M1_M1,
  PseudoVSUXEI16_V_M1_M1_MASK,
  PseudoVSUXEI16_V_M1_M2,
  PseudoVSUXEI16_V_M1_M2_MASK,
  PseudoVSUXEI16_V_M1_M4,
  PseudoVSUXEI16_V_M1_M4_MASK,
  PseudoVSUXEI16_V_M1_MF2,
  PseudoVSUXEI16_V_M1_MF2_MASK,
  PseudoVSUXEI16_V_M2_M1,
  PseudoVSUXEI16_V_M2_M1_MASK,
  PseudoVSUXEI16_V_M2_M2,
  PseudoVSUXEI16_V_M2_M2_MASK,
  PseudoVSUXEI16_V_M2_M4,
  PseudoVSUXEI16_V_M2_M4_MASK,
  PseudoVSUXEI16_V_M2_M8,
  PseudoVSUXEI16_V_M2_M8_MASK,
  PseudoVSUXEI16_V_M4_M2,
  PseudoVSUXEI16_V_M4_M2_MASK,
  PseudoVSUXEI16_V_M4_M4,
  PseudoVSUXEI16_V_M4_M4_MASK,
  PseudoVSUXEI16_V_M4_M8,
  PseudoVSUXEI16_V_M4_M8_MASK,
  PseudoVSUXEI16_V_M8_M4,
  PseudoVSUXEI16_V_M8_M4_MASK,
  PseudoVSUXEI16_V_M8_M8,
  PseudoVSUXEI16_V_M8_M8_MASK,
  PseudoVSUXEI16_V_MF2_M1,
  PseudoVSUXEI16_V_MF2_M1_MASK,
  PseudoVSUXEI16_V_MF2_M2,
  PseudoVSUXEI16_V_MF2_M2_MASK,
  PseudoVSUXEI16_V_MF2_MF2,
  PseudoVSUXEI16_V_MF2_MF2_MASK,
  PseudoVSUXEI16_V_MF2_MF4,
  PseudoVSUXEI16_V_MF2_MF4_MASK,
  PseudoVSUXEI16_V_MF4_M1,
  PseudoVSUXEI16_V_MF4_M1_MASK,
  PseudoVSUXEI16_V_MF4_MF2,
  PseudoVSUXEI16_V_MF4_MF2_MASK,
  PseudoVSUXEI16_V_MF4_MF4,
  PseudoVSUXEI16_V_MF4_MF4_MASK,
  PseudoVSUXEI16_V_MF4_MF8,
  PseudoVSUXEI16_V_MF4_MF8_MASK,
  PseudoVSUXEI32_V_M1_M1,
  PseudoVSUXEI32_V_M1_M1_MASK,
  PseudoVSUXEI32_V_M1_M2,
  PseudoVSUXEI32_V_M1_M2_MASK,
  PseudoVSUXEI32_V_M1_MF2,
  PseudoVSUXEI32_V_M1_MF2_MASK,
  PseudoVSUXEI32_V_M1_MF4,
  PseudoVSUXEI32_V_M1_MF4_MASK,
  PseudoVSUXEI32_V_M2_M1,
  PseudoVSUXEI32_V_M2_M1_MASK,
  PseudoVSUXEI32_V_M2_M2,
  PseudoVSUXEI32_V_M2_M2_MASK,
  PseudoVSUXEI32_V_M2_M4,
  PseudoVSUXEI32_V_M2_M4_MASK,
  PseudoVSUXEI32_V_M2_MF2,
  PseudoVSUXEI32_V_M2_MF2_MASK,
  PseudoVSUXEI32_V_M4_M1,
  PseudoVSUXEI32_V_M4_M1_MASK,
  PseudoVSUXEI32_V_M4_M2,
  PseudoVSUXEI32_V_M4_M2_MASK,
  PseudoVSUXEI32_V_M4_M4,
  PseudoVSUXEI32_V_M4_M4_MASK,
  PseudoVSUXEI32_V_M4_M8,
  PseudoVSUXEI32_V_M4_M8_MASK,
  PseudoVSUXEI32_V_M8_M2,
  PseudoVSUXEI32_V_M8_M2_MASK,
  PseudoVSUXEI32_V_M8_M4,
  PseudoVSUXEI32_V_M8_M4_MASK,
  PseudoVSUXEI32_V_M8_M8,
  PseudoVSUXEI32_V_M8_M8_MASK,
  PseudoVSUXEI32_V_MF2_M1,
  PseudoVSUXEI32_V_MF2_M1_MASK,
  PseudoVSUXEI32_V_MF2_MF2,
  PseudoVSUXEI32_V_MF2_MF2_MASK,
  PseudoVSUXEI32_V_MF2_MF4,
  PseudoVSUXEI32_V_MF2_MF4_MASK,
  PseudoVSUXEI32_V_MF2_MF8,
  PseudoVSUXEI32_V_MF2_MF8_MASK,
  PseudoVSUXEI64_V_M1_M1,
  PseudoVSUXEI64_V_M1_M1_MASK,
  PseudoVSUXEI64_V_M1_MF2,
  PseudoVSUXEI64_V_M1_MF2_MASK,
  PseudoVSUXEI64_V_M1_MF4,
  PseudoVSUXEI64_V_M1_MF4_MASK,
  PseudoVSUXEI64_V_M1_MF8,
  PseudoVSUXEI64_V_M1_MF8_MASK,
  PseudoVSUXEI64_V_M2_M1,
  PseudoVSUXEI64_V_M2_M1_MASK,
  PseudoVSUXEI64_V_M2_M2,
  PseudoVSUXEI64_V_M2_M2_MASK,
  PseudoVSUXEI64_V_M2_MF2,
  PseudoVSUXEI64_V_M2_MF2_MASK,
  PseudoVSUXEI64_V_M2_MF4,
  PseudoVSUXEI64_V_M2_MF4_MASK,
  PseudoVSUXEI64_V_M4_M1,
  PseudoVSUXEI64_V_M4_M1_MASK,
  PseudoVSUXEI64_V_M4_M2,
  PseudoVSUXEI64_V_M4_M2_MASK,
  PseudoVSUXEI64_V_M4_M4,
  PseudoVSUXEI64_V_M4_M4_MASK,
  PseudoVSUXEI64_V_M4_MF2,
  PseudoVSUXEI64_V_M4_MF2_MASK,
  PseudoVSUXEI64_V_M8_M1,
  PseudoVSUXEI64_V_M8_M1_MASK,
  PseudoVSUXEI64_V_M8_M2,
  PseudoVSUXEI64_V_M8_M2_MASK,
  PseudoVSUXEI64_V_M8_M4,
  PseudoVSUXEI64_V_M8_M4_MASK,
  PseudoVSUXEI64_V_M8_M8,
  PseudoVSUXEI64_V_M8_M8_MASK,
  PseudoVSUXEI8_V_M1_M1,
  PseudoVSUXEI8_V_M1_M1_MASK,
  PseudoVSUXEI8_V_M1_M2,
  PseudoVSUXEI8_V_M1_M2_MASK,
  PseudoVSUXEI8_V_M1_M4,
  PseudoVSUXEI8_V_M1_M4_MASK,
  PseudoVSUXEI8_V_M1_M8,
  PseudoVSUXEI8_V_M1_M8_MASK,
  PseudoVSUXEI8_V_M2_M2,
  PseudoVSUXEI8_V_M2_M2_MASK,
  PseudoVSUXEI8_V_M2_M4,
  PseudoVSUXEI8_V_M2_M4_MASK,
  PseudoVSUXEI8_V_M2_M8,
  PseudoVSUXEI8_V_M2_M8_MASK,
  PseudoVSUXEI8_V_M4_M4,
  PseudoVSUXEI8_V_M4_M4_MASK,
  PseudoVSUXEI8_V_M4_M8,
  PseudoVSUXEI8_V_M4_M8_MASK,
  PseudoVSUXEI8_V_M8_M8,
  PseudoVSUXEI8_V_M8_M8_MASK,
  PseudoVSUXEI8_V_MF2_M1,
  PseudoVSUXEI8_V_MF2_M1_MASK,
  PseudoVSUXEI8_V_MF2_M2,
  PseudoVSUXEI8_V_MF2_M2_MASK,
  PseudoVSUXEI8_V_MF2_M4,
  PseudoVSUXEI8_V_MF2_M4_MASK,
  PseudoVSUXEI8_V_MF2_MF2,
  PseudoVSUXEI8_V_MF2_MF2_MASK,
  PseudoVSUXEI8_V_MF4_M1,
  PseudoVSUXEI8_V_MF4_M1_MASK,
  PseudoVSUXEI8_V_MF4_M2,
  PseudoVSUXEI8_V_MF4_M2_MASK,
  PseudoVSUXEI8_V_MF4_MF2,
  PseudoVSUXEI8_V_MF4_MF2_MASK,
  PseudoVSUXEI8_V_MF4_MF4,
  PseudoVSUXEI8_V_MF4_MF4_MASK,
  PseudoVSUXEI8_V_MF8_M1,
  PseudoVSUXEI8_V_MF8_M1_MASK,
  PseudoVSUXEI8_V_MF8_MF2,
  PseudoVSUXEI8_V_MF8_MF2_MASK,
  PseudoVSUXEI8_V_MF8_MF4,
  PseudoVSUXEI8_V_MF8_MF4_MASK,
  PseudoVSUXEI8_V_MF8_MF8,
  PseudoVSUXEI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG2EI16_V_M1_M1,
  PseudoVSUXSEG2EI16_V_M1_M1_MASK,
  PseudoVSUXSEG2EI16_V_M1_M2,
  PseudoVSUXSEG2EI16_V_M1_M2_MASK,
  PseudoVSUXSEG2EI16_V_M1_M4,
  PseudoVSUXSEG2EI16_V_M1_M4_MASK,
  PseudoVSUXSEG2EI16_V_M1_MF2,
  PseudoVSUXSEG2EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG2EI16_V_M2_M1,
  PseudoVSUXSEG2EI16_V_M2_M1_MASK,
  PseudoVSUXSEG2EI16_V_M2_M2,
  PseudoVSUXSEG2EI16_V_M2_M2_MASK,
  PseudoVSUXSEG2EI16_V_M2_M4,
  PseudoVSUXSEG2EI16_V_M2_M4_MASK,
  PseudoVSUXSEG2EI16_V_M4_M2,
  PseudoVSUXSEG2EI16_V_M4_M2_MASK,
  PseudoVSUXSEG2EI16_V_M4_M4,
  PseudoVSUXSEG2EI16_V_M4_M4_MASK,
  PseudoVSUXSEG2EI16_V_M8_M4,
  PseudoVSUXSEG2EI16_V_M8_M4_MASK,
  PseudoVSUXSEG2EI16_V_MF2_M1,
  PseudoVSUXSEG2EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG2EI16_V_MF2_M2,
  PseudoVSUXSEG2EI16_V_MF2_M2_MASK,
  PseudoVSUXSEG2EI16_V_MF2_MF2,
  PseudoVSUXSEG2EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG2EI16_V_MF2_MF4,
  PseudoVSUXSEG2EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG2EI16_V_MF4_M1,
  PseudoVSUXSEG2EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG2EI16_V_MF4_MF2,
  PseudoVSUXSEG2EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG2EI16_V_MF4_MF4,
  PseudoVSUXSEG2EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG2EI16_V_MF4_MF8,
  PseudoVSUXSEG2EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG2EI32_V_M1_M1,
  PseudoVSUXSEG2EI32_V_M1_M1_MASK,
  PseudoVSUXSEG2EI32_V_M1_M2,
  PseudoVSUXSEG2EI32_V_M1_M2_MASK,
  PseudoVSUXSEG2EI32_V_M1_MF2,
  PseudoVSUXSEG2EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG2EI32_V_M1_MF4,
  PseudoVSUXSEG2EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG2EI32_V_M2_M1,
  PseudoVSUXSEG2EI32_V_M2_M1_MASK,
  PseudoVSUXSEG2EI32_V_M2_M2,
  PseudoVSUXSEG2EI32_V_M2_M2_MASK,
  PseudoVSUXSEG2EI32_V_M2_M4,
  PseudoVSUXSEG2EI32_V_M2_M4_MASK,
  PseudoVSUXSEG2EI32_V_M2_MF2,
  PseudoVSUXSEG2EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG2EI32_V_M4_M1,
  PseudoVSUXSEG2EI32_V_M4_M1_MASK,
  PseudoVSUXSEG2EI32_V_M4_M2,
  PseudoVSUXSEG2EI32_V_M4_M2_MASK,
  PseudoVSUXSEG2EI32_V_M4_M4,
  PseudoVSUXSEG2EI32_V_M4_M4_MASK,
  PseudoVSUXSEG2EI32_V_M8_M2,
  PseudoVSUXSEG2EI32_V_M8_M2_MASK,
  PseudoVSUXSEG2EI32_V_M8_M4,
  PseudoVSUXSEG2EI32_V_M8_M4_MASK,
  PseudoVSUXSEG2EI32_V_MF2_M1,
  PseudoVSUXSEG2EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG2EI32_V_MF2_MF2,
  PseudoVSUXSEG2EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG2EI32_V_MF2_MF4,
  PseudoVSUXSEG2EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG2EI32_V_MF2_MF8,
  PseudoVSUXSEG2EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG2EI64_V_M1_M1,
  PseudoVSUXSEG2EI64_V_M1_M1_MASK,
  PseudoVSUXSEG2EI64_V_M1_MF2,
  PseudoVSUXSEG2EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG2EI64_V_M1_MF4,
  PseudoVSUXSEG2EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG2EI64_V_M1_MF8,
  PseudoVSUXSEG2EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG2EI64_V_M2_M1,
  PseudoVSUXSEG2EI64_V_M2_M1_MASK,
  PseudoVSUXSEG2EI64_V_M2_M2,
  PseudoVSUXSEG2EI64_V_M2_M2_MASK,
  PseudoVSUXSEG2EI64_V_M2_MF2,
  PseudoVSUXSEG2EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG2EI64_V_M2_MF4,
  PseudoVSUXSEG2EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG2EI64_V_M4_M1,
  PseudoVSUXSEG2EI64_V_M4_M1_MASK,
  PseudoVSUXSEG2EI64_V_M4_M2,
  PseudoVSUXSEG2EI64_V_M4_M2_MASK,
  PseudoVSUXSEG2EI64_V_M4_M4,
  PseudoVSUXSEG2EI64_V_M4_M4_MASK,
  PseudoVSUXSEG2EI64_V_M4_MF2,
  PseudoVSUXSEG2EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG2EI64_V_M8_M1,
  PseudoVSUXSEG2EI64_V_M8_M1_MASK,
  PseudoVSUXSEG2EI64_V_M8_M2,
  PseudoVSUXSEG2EI64_V_M8_M2_MASK,
  PseudoVSUXSEG2EI64_V_M8_M4,
  PseudoVSUXSEG2EI64_V_M8_M4_MASK,
  PseudoVSUXSEG2EI8_V_M1_M1,
  PseudoVSUXSEG2EI8_V_M1_M1_MASK,
  PseudoVSUXSEG2EI8_V_M1_M2,
  PseudoVSUXSEG2EI8_V_M1_M2_MASK,
  PseudoVSUXSEG2EI8_V_M1_M4,
  PseudoVSUXSEG2EI8_V_M1_M4_MASK,
  PseudoVSUXSEG2EI8_V_M2_M2,
  PseudoVSUXSEG2EI8_V_M2_M2_MASK,
  PseudoVSUXSEG2EI8_V_M2_M4,
  PseudoVSUXSEG2EI8_V_M2_M4_MASK,
  PseudoVSUXSEG2EI8_V_M4_M4,
  PseudoVSUXSEG2EI8_V_M4_M4_MASK,
  PseudoVSUXSEG2EI8_V_MF2_M1,
  PseudoVSUXSEG2EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG2EI8_V_MF2_M2,
  PseudoVSUXSEG2EI8_V_MF2_M2_MASK,
  PseudoVSUXSEG2EI8_V_MF2_M4,
  PseudoVSUXSEG2EI8_V_MF2_M4_MASK,
  PseudoVSUXSEG2EI8_V_MF2_MF2,
  PseudoVSUXSEG2EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG2EI8_V_MF4_M1,
  PseudoVSUXSEG2EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG2EI8_V_MF4_M2,
  PseudoVSUXSEG2EI8_V_MF4_M2_MASK,
  PseudoVSUXSEG2EI8_V_MF4_MF2,
  PseudoVSUXSEG2EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG2EI8_V_MF4_MF4,
  PseudoVSUXSEG2EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG2EI8_V_MF8_M1,
  PseudoVSUXSEG2EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG2EI8_V_MF8_MF2,
  PseudoVSUXSEG2EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG2EI8_V_MF8_MF4,
  PseudoVSUXSEG2EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG2EI8_V_MF8_MF8,
  PseudoVSUXSEG2EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG3EI16_V_M1_M1,
  PseudoVSUXSEG3EI16_V_M1_M1_MASK,
  PseudoVSUXSEG3EI16_V_M1_M2,
  PseudoVSUXSEG3EI16_V_M1_M2_MASK,
  PseudoVSUXSEG3EI16_V_M1_MF2,
  PseudoVSUXSEG3EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG3EI16_V_M2_M1,
  PseudoVSUXSEG3EI16_V_M2_M1_MASK,
  PseudoVSUXSEG3EI16_V_M2_M2,
  PseudoVSUXSEG3EI16_V_M2_M2_MASK,
  PseudoVSUXSEG3EI16_V_M4_M2,
  PseudoVSUXSEG3EI16_V_M4_M2_MASK,
  PseudoVSUXSEG3EI16_V_MF2_M1,
  PseudoVSUXSEG3EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG3EI16_V_MF2_M2,
  PseudoVSUXSEG3EI16_V_MF2_M2_MASK,
  PseudoVSUXSEG3EI16_V_MF2_MF2,
  PseudoVSUXSEG3EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG3EI16_V_MF2_MF4,
  PseudoVSUXSEG3EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG3EI16_V_MF4_M1,
  PseudoVSUXSEG3EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG3EI16_V_MF4_MF2,
  PseudoVSUXSEG3EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG3EI16_V_MF4_MF4,
  PseudoVSUXSEG3EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG3EI16_V_MF4_MF8,
  PseudoVSUXSEG3EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG3EI32_V_M1_M1,
  PseudoVSUXSEG3EI32_V_M1_M1_MASK,
  PseudoVSUXSEG3EI32_V_M1_M2,
  PseudoVSUXSEG3EI32_V_M1_M2_MASK,
  PseudoVSUXSEG3EI32_V_M1_MF2,
  PseudoVSUXSEG3EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG3EI32_V_M1_MF4,
  PseudoVSUXSEG3EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG3EI32_V_M2_M1,
  PseudoVSUXSEG3EI32_V_M2_M1_MASK,
  PseudoVSUXSEG3EI32_V_M2_M2,
  PseudoVSUXSEG3EI32_V_M2_M2_MASK,
  PseudoVSUXSEG3EI32_V_M2_MF2,
  PseudoVSUXSEG3EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG3EI32_V_M4_M1,
  PseudoVSUXSEG3EI32_V_M4_M1_MASK,
  PseudoVSUXSEG3EI32_V_M4_M2,
  PseudoVSUXSEG3EI32_V_M4_M2_MASK,
  PseudoVSUXSEG3EI32_V_M8_M2,
  PseudoVSUXSEG3EI32_V_M8_M2_MASK,
  PseudoVSUXSEG3EI32_V_MF2_M1,
  PseudoVSUXSEG3EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG3EI32_V_MF2_MF2,
  PseudoVSUXSEG3EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG3EI32_V_MF2_MF4,
  PseudoVSUXSEG3EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG3EI32_V_MF2_MF8,
  PseudoVSUXSEG3EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG3EI64_V_M1_M1,
  PseudoVSUXSEG3EI64_V_M1_M1_MASK,
  PseudoVSUXSEG3EI64_V_M1_MF2,
  PseudoVSUXSEG3EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG3EI64_V_M1_MF4,
  PseudoVSUXSEG3EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG3EI64_V_M1_MF8,
  PseudoVSUXSEG3EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG3EI64_V_M2_M1,
  PseudoVSUXSEG3EI64_V_M2_M1_MASK,
  PseudoVSUXSEG3EI64_V_M2_M2,
  PseudoVSUXSEG3EI64_V_M2_M2_MASK,
  PseudoVSUXSEG3EI64_V_M2_MF2,
  PseudoVSUXSEG3EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG3EI64_V_M2_MF4,
  PseudoVSUXSEG3EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG3EI64_V_M4_M1,
  PseudoVSUXSEG3EI64_V_M4_M1_MASK,
  PseudoVSUXSEG3EI64_V_M4_M2,
  PseudoVSUXSEG3EI64_V_M4_M2_MASK,
  PseudoVSUXSEG3EI64_V_M4_MF2,
  PseudoVSUXSEG3EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG3EI64_V_M8_M1,
  PseudoVSUXSEG3EI64_V_M8_M1_MASK,
  PseudoVSUXSEG3EI64_V_M8_M2,
  PseudoVSUXSEG3EI64_V_M8_M2_MASK,
  PseudoVSUXSEG3EI8_V_M1_M1,
  PseudoVSUXSEG3EI8_V_M1_M1_MASK,
  PseudoVSUXSEG3EI8_V_M1_M2,
  PseudoVSUXSEG3EI8_V_M1_M2_MASK,
  PseudoVSUXSEG3EI8_V_M2_M2,
  PseudoVSUXSEG3EI8_V_M2_M2_MASK,
  PseudoVSUXSEG3EI8_V_MF2_M1,
  PseudoVSUXSEG3EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG3EI8_V_MF2_M2,
  PseudoVSUXSEG3EI8_V_MF2_M2_MASK,
  PseudoVSUXSEG3EI8_V_MF2_MF2,
  PseudoVSUXSEG3EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG3EI8_V_MF4_M1,
  PseudoVSUXSEG3EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG3EI8_V_MF4_M2,
  PseudoVSUXSEG3EI8_V_MF4_M2_MASK,
  PseudoVSUXSEG3EI8_V_MF4_MF2,
  PseudoVSUXSEG3EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG3EI8_V_MF4_MF4,
  PseudoVSUXSEG3EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG3EI8_V_MF8_M1,
  PseudoVSUXSEG3EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG3EI8_V_MF8_MF2,
  PseudoVSUXSEG3EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG3EI8_V_MF8_MF4,
  PseudoVSUXSEG3EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG3EI8_V_MF8_MF8,
  PseudoVSUXSEG3EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG4EI16_V_M1_M1,
  PseudoVSUXSEG4EI16_V_M1_M1_MASK,
  PseudoVSUXSEG4EI16_V_M1_M2,
  PseudoVSUXSEG4EI16_V_M1_M2_MASK,
  PseudoVSUXSEG4EI16_V_M1_MF2,
  PseudoVSUXSEG4EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG4EI16_V_M2_M1,
  PseudoVSUXSEG4EI16_V_M2_M1_MASK,
  PseudoVSUXSEG4EI16_V_M2_M2,
  PseudoVSUXSEG4EI16_V_M2_M2_MASK,
  PseudoVSUXSEG4EI16_V_M4_M2,
  PseudoVSUXSEG4EI16_V_M4_M2_MASK,
  PseudoVSUXSEG4EI16_V_MF2_M1,
  PseudoVSUXSEG4EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG4EI16_V_MF2_M2,
  PseudoVSUXSEG4EI16_V_MF2_M2_MASK,
  PseudoVSUXSEG4EI16_V_MF2_MF2,
  PseudoVSUXSEG4EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG4EI16_V_MF2_MF4,
  PseudoVSUXSEG4EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG4EI16_V_MF4_M1,
  PseudoVSUXSEG4EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG4EI16_V_MF4_MF2,
  PseudoVSUXSEG4EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG4EI16_V_MF4_MF4,
  PseudoVSUXSEG4EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG4EI16_V_MF4_MF8,
  PseudoVSUXSEG4EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG4EI32_V_M1_M1,
  PseudoVSUXSEG4EI32_V_M1_M1_MASK,
  PseudoVSUXSEG4EI32_V_M1_M2,
  PseudoVSUXSEG4EI32_V_M1_M2_MASK,
  PseudoVSUXSEG4EI32_V_M1_MF2,
  PseudoVSUXSEG4EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG4EI32_V_M1_MF4,
  PseudoVSUXSEG4EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG4EI32_V_M2_M1,
  PseudoVSUXSEG4EI32_V_M2_M1_MASK,
  PseudoVSUXSEG4EI32_V_M2_M2,
  PseudoVSUXSEG4EI32_V_M2_M2_MASK,
  PseudoVSUXSEG4EI32_V_M2_MF2,
  PseudoVSUXSEG4EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG4EI32_V_M4_M1,
  PseudoVSUXSEG4EI32_V_M4_M1_MASK,
  PseudoVSUXSEG4EI32_V_M4_M2,
  PseudoVSUXSEG4EI32_V_M4_M2_MASK,
  PseudoVSUXSEG4EI32_V_M8_M2,
  PseudoVSUXSEG4EI32_V_M8_M2_MASK,
  PseudoVSUXSEG4EI32_V_MF2_M1,
  PseudoVSUXSEG4EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG4EI32_V_MF2_MF2,
  PseudoVSUXSEG4EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG4EI32_V_MF2_MF4,
  PseudoVSUXSEG4EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG4EI32_V_MF2_MF8,
  PseudoVSUXSEG4EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG4EI64_V_M1_M1,
  PseudoVSUXSEG4EI64_V_M1_M1_MASK,
  PseudoVSUXSEG4EI64_V_M1_MF2,
  PseudoVSUXSEG4EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG4EI64_V_M1_MF4,
  PseudoVSUXSEG4EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG4EI64_V_M1_MF8,
  PseudoVSUXSEG4EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG4EI64_V_M2_M1,
  PseudoVSUXSEG4EI64_V_M2_M1_MASK,
  PseudoVSUXSEG4EI64_V_M2_M2,
  PseudoVSUXSEG4EI64_V_M2_M2_MASK,
  PseudoVSUXSEG4EI64_V_M2_MF2,
  PseudoVSUXSEG4EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG4EI64_V_M2_MF4,
  PseudoVSUXSEG4EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG4EI64_V_M4_M1,
  PseudoVSUXSEG4EI64_V_M4_M1_MASK,
  PseudoVSUXSEG4EI64_V_M4_M2,
  PseudoVSUXSEG4EI64_V_M4_M2_MASK,
  PseudoVSUXSEG4EI64_V_M4_MF2,
  PseudoVSUXSEG4EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG4EI64_V_M8_M1,
  PseudoVSUXSEG4EI64_V_M8_M1_MASK,
  PseudoVSUXSEG4EI64_V_M8_M2,
  PseudoVSUXSEG4EI64_V_M8_M2_MASK,
  PseudoVSUXSEG4EI8_V_M1_M1,
  PseudoVSUXSEG4EI8_V_M1_M1_MASK,
  PseudoVSUXSEG4EI8_V_M1_M2,
  PseudoVSUXSEG4EI8_V_M1_M2_MASK,
  PseudoVSUXSEG4EI8_V_M2_M2,
  PseudoVSUXSEG4EI8_V_M2_M2_MASK,
  PseudoVSUXSEG4EI8_V_MF2_M1,
  PseudoVSUXSEG4EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG4EI8_V_MF2_M2,
  PseudoVSUXSEG4EI8_V_MF2_M2_MASK,
  PseudoVSUXSEG4EI8_V_MF2_MF2,
  PseudoVSUXSEG4EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG4EI8_V_MF4_M1,
  PseudoVSUXSEG4EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG4EI8_V_MF4_M2,
  PseudoVSUXSEG4EI8_V_MF4_M2_MASK,
  PseudoVSUXSEG4EI8_V_MF4_MF2,
  PseudoVSUXSEG4EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG4EI8_V_MF4_MF4,
  PseudoVSUXSEG4EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG4EI8_V_MF8_M1,
  PseudoVSUXSEG4EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG4EI8_V_MF8_MF2,
  PseudoVSUXSEG4EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG4EI8_V_MF8_MF4,
  PseudoVSUXSEG4EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG4EI8_V_MF8_MF8,
  PseudoVSUXSEG4EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG5EI16_V_M1_M1,
  PseudoVSUXSEG5EI16_V_M1_M1_MASK,
  PseudoVSUXSEG5EI16_V_M1_MF2,
  PseudoVSUXSEG5EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG5EI16_V_M2_M1,
  PseudoVSUXSEG5EI16_V_M2_M1_MASK,
  PseudoVSUXSEG5EI16_V_MF2_M1,
  PseudoVSUXSEG5EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG5EI16_V_MF2_MF2,
  PseudoVSUXSEG5EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG5EI16_V_MF2_MF4,
  PseudoVSUXSEG5EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG5EI16_V_MF4_M1,
  PseudoVSUXSEG5EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG5EI16_V_MF4_MF2,
  PseudoVSUXSEG5EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG5EI16_V_MF4_MF4,
  PseudoVSUXSEG5EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG5EI16_V_MF4_MF8,
  PseudoVSUXSEG5EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG5EI32_V_M1_M1,
  PseudoVSUXSEG5EI32_V_M1_M1_MASK,
  PseudoVSUXSEG5EI32_V_M1_MF2,
  PseudoVSUXSEG5EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG5EI32_V_M1_MF4,
  PseudoVSUXSEG5EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG5EI32_V_M2_M1,
  PseudoVSUXSEG5EI32_V_M2_M1_MASK,
  PseudoVSUXSEG5EI32_V_M2_MF2,
  PseudoVSUXSEG5EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG5EI32_V_M4_M1,
  PseudoVSUXSEG5EI32_V_M4_M1_MASK,
  PseudoVSUXSEG5EI32_V_MF2_M1,
  PseudoVSUXSEG5EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG5EI32_V_MF2_MF2,
  PseudoVSUXSEG5EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG5EI32_V_MF2_MF4,
  PseudoVSUXSEG5EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG5EI32_V_MF2_MF8,
  PseudoVSUXSEG5EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG5EI64_V_M1_M1,
  PseudoVSUXSEG5EI64_V_M1_M1_MASK,
  PseudoVSUXSEG5EI64_V_M1_MF2,
  PseudoVSUXSEG5EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG5EI64_V_M1_MF4,
  PseudoVSUXSEG5EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG5EI64_V_M1_MF8,
  PseudoVSUXSEG5EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG5EI64_V_M2_M1,
  PseudoVSUXSEG5EI64_V_M2_M1_MASK,
  PseudoVSUXSEG5EI64_V_M2_MF2,
  PseudoVSUXSEG5EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG5EI64_V_M2_MF4,
  PseudoVSUXSEG5EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG5EI64_V_M4_M1,
  PseudoVSUXSEG5EI64_V_M4_M1_MASK,
  PseudoVSUXSEG5EI64_V_M4_MF2,
  PseudoVSUXSEG5EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG5EI64_V_M8_M1,
  PseudoVSUXSEG5EI64_V_M8_M1_MASK,
  PseudoVSUXSEG5EI8_V_M1_M1,
  PseudoVSUXSEG5EI8_V_M1_M1_MASK,
  PseudoVSUXSEG5EI8_V_MF2_M1,
  PseudoVSUXSEG5EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG5EI8_V_MF2_MF2,
  PseudoVSUXSEG5EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG5EI8_V_MF4_M1,
  PseudoVSUXSEG5EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG5EI8_V_MF4_MF2,
  PseudoVSUXSEG5EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG5EI8_V_MF4_MF4,
  PseudoVSUXSEG5EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG5EI8_V_MF8_M1,
  PseudoVSUXSEG5EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG5EI8_V_MF8_MF2,
  PseudoVSUXSEG5EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG5EI8_V_MF8_MF4,
  PseudoVSUXSEG5EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG5EI8_V_MF8_MF8,
  PseudoVSUXSEG5EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG6EI16_V_M1_M1,
  PseudoVSUXSEG6EI16_V_M1_M1_MASK,
  PseudoVSUXSEG6EI16_V_M1_MF2,
  PseudoVSUXSEG6EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG6EI16_V_M2_M1,
  PseudoVSUXSEG6EI16_V_M2_M1_MASK,
  PseudoVSUXSEG6EI16_V_MF2_M1,
  PseudoVSUXSEG6EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG6EI16_V_MF2_MF2,
  PseudoVSUXSEG6EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG6EI16_V_MF2_MF4,
  PseudoVSUXSEG6EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG6EI16_V_MF4_M1,
  PseudoVSUXSEG6EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG6EI16_V_MF4_MF2,
  PseudoVSUXSEG6EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG6EI16_V_MF4_MF4,
  PseudoVSUXSEG6EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG6EI16_V_MF4_MF8,
  PseudoVSUXSEG6EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG6EI32_V_M1_M1,
  PseudoVSUXSEG6EI32_V_M1_M1_MASK,
  PseudoVSUXSEG6EI32_V_M1_MF2,
  PseudoVSUXSEG6EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG6EI32_V_M1_MF4,
  PseudoVSUXSEG6EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG6EI32_V_M2_M1,
  PseudoVSUXSEG6EI32_V_M2_M1_MASK,
  PseudoVSUXSEG6EI32_V_M2_MF2,
  PseudoVSUXSEG6EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG6EI32_V_M4_M1,
  PseudoVSUXSEG6EI32_V_M4_M1_MASK,
  PseudoVSUXSEG6EI32_V_MF2_M1,
  PseudoVSUXSEG6EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG6EI32_V_MF2_MF2,
  PseudoVSUXSEG6EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG6EI32_V_MF2_MF4,
  PseudoVSUXSEG6EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG6EI32_V_MF2_MF8,
  PseudoVSUXSEG6EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG6EI64_V_M1_M1,
  PseudoVSUXSEG6EI64_V_M1_M1_MASK,
  PseudoVSUXSEG6EI64_V_M1_MF2,
  PseudoVSUXSEG6EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG6EI64_V_M1_MF4,
  PseudoVSUXSEG6EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG6EI64_V_M1_MF8,
  PseudoVSUXSEG6EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG6EI64_V_M2_M1,
  PseudoVSUXSEG6EI64_V_M2_M1_MASK,
  PseudoVSUXSEG6EI64_V_M2_MF2,
  PseudoVSUXSEG6EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG6EI64_V_M2_MF4,
  PseudoVSUXSEG6EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG6EI64_V_M4_M1,
  PseudoVSUXSEG6EI64_V_M4_M1_MASK,
  PseudoVSUXSEG6EI64_V_M4_MF2,
  PseudoVSUXSEG6EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG6EI64_V_M8_M1,
  PseudoVSUXSEG6EI64_V_M8_M1_MASK,
  PseudoVSUXSEG6EI8_V_M1_M1,
  PseudoVSUXSEG6EI8_V_M1_M1_MASK,
  PseudoVSUXSEG6EI8_V_MF2_M1,
  PseudoVSUXSEG6EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG6EI8_V_MF2_MF2,
  PseudoVSUXSEG6EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG6EI8_V_MF4_M1,
  PseudoVSUXSEG6EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG6EI8_V_MF4_MF2,
  PseudoVSUXSEG6EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG6EI8_V_MF4_MF4,
  PseudoVSUXSEG6EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG6EI8_V_MF8_M1,
  PseudoVSUXSEG6EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG6EI8_V_MF8_MF2,
  PseudoVSUXSEG6EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG6EI8_V_MF8_MF4,
  PseudoVSUXSEG6EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG6EI8_V_MF8_MF8,
  PseudoVSUXSEG6EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG7EI16_V_M1_M1,
  PseudoVSUXSEG7EI16_V_M1_M1_MASK,
  PseudoVSUXSEG7EI16_V_M1_MF2,
  PseudoVSUXSEG7EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG7EI16_V_M2_M1,
  PseudoVSUXSEG7EI16_V_M2_M1_MASK,
  PseudoVSUXSEG7EI16_V_MF2_M1,
  PseudoVSUXSEG7EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG7EI16_V_MF2_MF2,
  PseudoVSUXSEG7EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG7EI16_V_MF2_MF4,
  PseudoVSUXSEG7EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG7EI16_V_MF4_M1,
  PseudoVSUXSEG7EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG7EI16_V_MF4_MF2,
  PseudoVSUXSEG7EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG7EI16_V_MF4_MF4,
  PseudoVSUXSEG7EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG7EI16_V_MF4_MF8,
  PseudoVSUXSEG7EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG7EI32_V_M1_M1,
  PseudoVSUXSEG7EI32_V_M1_M1_MASK,
  PseudoVSUXSEG7EI32_V_M1_MF2,
  PseudoVSUXSEG7EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG7EI32_V_M1_MF4,
  PseudoVSUXSEG7EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG7EI32_V_M2_M1,
  PseudoVSUXSEG7EI32_V_M2_M1_MASK,
  PseudoVSUXSEG7EI32_V_M2_MF2,
  PseudoVSUXSEG7EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG7EI32_V_M4_M1,
  PseudoVSUXSEG7EI32_V_M4_M1_MASK,
  PseudoVSUXSEG7EI32_V_MF2_M1,
  PseudoVSUXSEG7EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG7EI32_V_MF2_MF2,
  PseudoVSUXSEG7EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG7EI32_V_MF2_MF4,
  PseudoVSUXSEG7EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG7EI32_V_MF2_MF8,
  PseudoVSUXSEG7EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG7EI64_V_M1_M1,
  PseudoVSUXSEG7EI64_V_M1_M1_MASK,
  PseudoVSUXSEG7EI64_V_M1_MF2,
  PseudoVSUXSEG7EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG7EI64_V_M1_MF4,
  PseudoVSUXSEG7EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG7EI64_V_M1_MF8,
  PseudoVSUXSEG7EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG7EI64_V_M2_M1,
  PseudoVSUXSEG7EI64_V_M2_M1_MASK,
  PseudoVSUXSEG7EI64_V_M2_MF2,
  PseudoVSUXSEG7EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG7EI64_V_M2_MF4,
  PseudoVSUXSEG7EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG7EI64_V_M4_M1,
  PseudoVSUXSEG7EI64_V_M4_M1_MASK,
  PseudoVSUXSEG7EI64_V_M4_MF2,
  PseudoVSUXSEG7EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG7EI64_V_M8_M1,
  PseudoVSUXSEG7EI64_V_M8_M1_MASK,
  PseudoVSUXSEG7EI8_V_M1_M1,
  PseudoVSUXSEG7EI8_V_M1_M1_MASK,
  PseudoVSUXSEG7EI8_V_MF2_M1,
  PseudoVSUXSEG7EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG7EI8_V_MF2_MF2,
  PseudoVSUXSEG7EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG7EI8_V_MF4_M1,
  PseudoVSUXSEG7EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG7EI8_V_MF4_MF2,
  PseudoVSUXSEG7EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG7EI8_V_MF4_MF4,
  PseudoVSUXSEG7EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG7EI8_V_MF8_M1,
  PseudoVSUXSEG7EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG7EI8_V_MF8_MF2,
  PseudoVSUXSEG7EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG7EI8_V_MF8_MF4,
  PseudoVSUXSEG7EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG7EI8_V_MF8_MF8,
  PseudoVSUXSEG7EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG8EI16_V_M1_M1,
  PseudoVSUXSEG8EI16_V_M1_M1_MASK,
  PseudoVSUXSEG8EI16_V_M1_MF2,
  PseudoVSUXSEG8EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG8EI16_V_M2_M1,
  PseudoVSUXSEG8EI16_V_M2_M1_MASK,
  PseudoVSUXSEG8EI16_V_MF2_M1,
  PseudoVSUXSEG8EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG8EI16_V_MF2_MF2,
  PseudoVSUXSEG8EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG8EI16_V_MF2_MF4,
  PseudoVSUXSEG8EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG8EI16_V_MF4_M1,
  PseudoVSUXSEG8EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG8EI16_V_MF4_MF2,
  PseudoVSUXSEG8EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG8EI16_V_MF4_MF4,
  PseudoVSUXSEG8EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG8EI16_V_MF4_MF8,
  PseudoVSUXSEG8EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG8EI32_V_M1_M1,
  PseudoVSUXSEG8EI32_V_M1_M1_MASK,
  PseudoVSUXSEG8EI32_V_M1_MF2,
  PseudoVSUXSEG8EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG8EI32_V_M1_MF4,
  PseudoVSUXSEG8EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG8EI32_V_M2_M1,
  PseudoVSUXSEG8EI32_V_M2_M1_MASK,
  PseudoVSUXSEG8EI32_V_M2_MF2,
  PseudoVSUXSEG8EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG8EI32_V_M4_M1,
  PseudoVSUXSEG8EI32_V_M4_M1_MASK,
  PseudoVSUXSEG8EI32_V_MF2_M1,
  PseudoVSUXSEG8EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG8EI32_V_MF2_MF2,
  PseudoVSUXSEG8EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG8EI32_V_MF2_MF4,
  PseudoVSUXSEG8EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG8EI32_V_MF2_MF8,
  PseudoVSUXSEG8EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG8EI64_V_M1_M1,
  PseudoVSUXSEG8EI64_V_M1_M1_MASK,
  PseudoVSUXSEG8EI64_V_M1_MF2,
  PseudoVSUXSEG8EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG8EI64_V_M1_MF4,
  PseudoVSUXSEG8EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG8EI64_V_M1_MF8,
  PseudoVSUXSEG8EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG8EI64_V_M2_M1,
  PseudoVSUXSEG8EI64_V_M2_M1_MASK,
  PseudoVSUXSEG8EI64_V_M2_MF2,
  PseudoVSUXSEG8EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG8EI64_V_M2_MF4,
  PseudoVSUXSEG8EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG8EI64_V_M4_M1,
  PseudoVSUXSEG8EI64_V_M4_M1_MASK,
  PseudoVSUXSEG8EI64_V_M4_MF2,
  PseudoVSUXSEG8EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG8EI64_V_M8_M1,
  PseudoVSUXSEG8EI64_V_M8_M1_MASK,
  PseudoVSUXSEG8EI8_V_M1_M1,
  PseudoVSUXSEG8EI8_V_M1_M1_MASK,
  PseudoVSUXSEG8EI8_V_MF2_M1,
  PseudoVSUXSEG8EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG8EI8_V_MF2_MF2,
  PseudoVSUXSEG8EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG8EI8_V_MF4_M1,
  PseudoVSUXSEG8EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG8EI8_V_MF4_MF2,
  PseudoVSUXSEG8EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG8EI8_V_MF4_MF4,
  PseudoVSUXSEG8EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG8EI8_V_MF8_M1,
  PseudoVSUXSEG8EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG8EI8_V_MF8_MF2,
  PseudoVSUXSEG8EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG8EI8_V_MF8_MF4,
  PseudoVSUXSEG8EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG8EI8_V_MF8_MF8,
  PseudoVSUXSEG8EI8_V_MF8_MF8_MASK,
  PseudoVWADDU_VV_M1,
  PseudoVWADDU_VV_M1_MASK,
  PseudoVWADDU_VV_M2,
  PseudoVWADDU_VV_M2_MASK,
  PseudoVWADDU_VV_M4,
  PseudoVWADDU_VV_M4_MASK,
  PseudoVWADDU_VV_MF2,
  PseudoVWADDU_VV_MF2_MASK,
  PseudoVWADDU_VV_MF4,
  PseudoVWADDU_VV_MF4_MASK,
  PseudoVWADDU_VV_MF8,
  PseudoVWADDU_VV_MF8_MASK,
  PseudoVWADDU_VX_M1,
  PseudoVWADDU_VX_M1_MASK,
  PseudoVWADDU_VX_M2,
  PseudoVWADDU_VX_M2_MASK,
  PseudoVWADDU_VX_M4,
  PseudoVWADDU_VX_M4_MASK,
  PseudoVWADDU_VX_MF2,
  PseudoVWADDU_VX_MF2_MASK,
  PseudoVWADDU_VX_MF4,
  PseudoVWADDU_VX_MF4_MASK,
  PseudoVWADDU_VX_MF8,
  PseudoVWADDU_VX_MF8_MASK,
  PseudoVWADDU_WV_M1,
  PseudoVWADDU_WV_M1_MASK,
  PseudoVWADDU_WV_M1_MASK_TIED,
  PseudoVWADDU_WV_M1_TIED,
  PseudoVWADDU_WV_M2,
  PseudoVWADDU_WV_M2_MASK,
  PseudoVWADDU_WV_M2_MASK_TIED,
  PseudoVWADDU_WV_M2_TIED,
  PseudoVWADDU_WV_M4,
  PseudoVWADDU_WV_M4_MASK,
  PseudoVWADDU_WV_M4_MASK_TIED,
  PseudoVWADDU_WV_M4_TIED,
  PseudoVWADDU_WV_MF2,
  PseudoVWADDU_WV_MF2_MASK,
  PseudoVWADDU_WV_MF2_MASK_TIED,
  PseudoVWADDU_WV_MF2_TIED,
  PseudoVWADDU_WV_MF4,
  PseudoVWADDU_WV_MF4_MASK,
  PseudoVWADDU_WV_MF4_MASK_TIED,
  PseudoVWADDU_WV_MF4_TIED,
  PseudoVWADDU_WV_MF8,
  PseudoVWADDU_WV_MF8_MASK,
  PseudoVWADDU_WV_MF8_MASK_TIED,
  PseudoVWADDU_WV_MF8_TIED,
  PseudoVWADDU_WX_M1,
  PseudoVWADDU_WX_M1_MASK,
  PseudoVWADDU_WX_M2,
  PseudoVWADDU_WX_M2_MASK,
  PseudoVWADDU_WX_M4,
  PseudoVWADDU_WX_M4_MASK,
  PseudoVWADDU_WX_MF2,
  PseudoVWADDU_WX_MF2_MASK,
  PseudoVWADDU_WX_MF4,
  PseudoVWADDU_WX_MF4_MASK,
  PseudoVWADDU_WX_MF8,
  PseudoVWADDU_WX_MF8_MASK,
  PseudoVWADD_VV_M1,
  PseudoVWADD_VV_M1_MASK,
  PseudoVWADD_VV_M2,
  PseudoVWADD_VV_M2_MASK,
  PseudoVWADD_VV_M4,
  PseudoVWADD_VV_M4_MASK,
  PseudoVWADD_VV_MF2,
  PseudoVWADD_VV_MF2_MASK,
  PseudoVWADD_VV_MF4,
  PseudoVWADD_VV_MF4_MASK,
  PseudoVWADD_VV_MF8,
  PseudoVWADD_VV_MF8_MASK,
  PseudoVWADD_VX_M1,
  PseudoVWADD_VX_M1_MASK,
  PseudoVWADD_VX_M2,
  PseudoVWADD_VX_M2_MASK,
  PseudoVWADD_VX_M4,
  PseudoVWADD_VX_M4_MASK,
  PseudoVWADD_VX_MF2,
  PseudoVWADD_VX_MF2_MASK,
  PseudoVWADD_VX_MF4,
  PseudoVWADD_VX_MF4_MASK,
  PseudoVWADD_VX_MF8,
  PseudoVWADD_VX_MF8_MASK,
  PseudoVWADD_WV_M1,
  PseudoVWADD_WV_M1_MASK,
  PseudoVWADD_WV_M1_MASK_TIED,
  PseudoVWADD_WV_M1_TIED,
  PseudoVWADD_WV_M2,
  PseudoVWADD_WV_M2_MASK,
  PseudoVWADD_WV_M2_MASK_TIED,
  PseudoVWADD_WV_M2_TIED,
  PseudoVWADD_WV_M4,
  PseudoVWADD_WV_M4_MASK,
  PseudoVWADD_WV_M4_MASK_TIED,
  PseudoVWADD_WV_M4_TIED,
  PseudoVWADD_WV_MF2,
  PseudoVWADD_WV_MF2_MASK,
  PseudoVWADD_WV_MF2_MASK_TIED,
  PseudoVWADD_WV_MF2_TIED,
  PseudoVWADD_WV_MF4,
  PseudoVWADD_WV_MF4_MASK,
  PseudoVWADD_WV_MF4_MASK_TIED,
  PseudoVWADD_WV_MF4_TIED,
  PseudoVWADD_WV_MF8,
  PseudoVWADD_WV_MF8_MASK,
  PseudoVWADD_WV_MF8_MASK_TIED,
  PseudoVWADD_WV_MF8_TIED,
  PseudoVWADD_WX_M1,
  PseudoVWADD_WX_M1_MASK,
  PseudoVWADD_WX_M2,
  PseudoVWADD_WX_M2_MASK,
  PseudoVWADD_WX_M4,
  PseudoVWADD_WX_M4_MASK,
  PseudoVWADD_WX_MF2,
  PseudoVWADD_WX_MF2_MASK,
  PseudoVWADD_WX_MF4,
  PseudoVWADD_WX_MF4_MASK,
  PseudoVWADD_WX_MF8,
  PseudoVWADD_WX_MF8_MASK,
  PseudoVWMACCSU_VV_M1,
  PseudoVWMACCSU_VV_M1_MASK,
  PseudoVWMACCSU_VV_M2,
  PseudoVWMACCSU_VV_M2_MASK,
  PseudoVWMACCSU_VV_M4,
  PseudoVWMACCSU_VV_M4_MASK,
  PseudoVWMACCSU_VV_MF2,
  PseudoVWMACCSU_VV_MF2_MASK,
  PseudoVWMACCSU_VV_MF4,
  PseudoVWMACCSU_VV_MF4_MASK,
  PseudoVWMACCSU_VV_MF8,
  PseudoVWMACCSU_VV_MF8_MASK,
  PseudoVWMACCSU_VX_M1,
  PseudoVWMACCSU_VX_M1_MASK,
  PseudoVWMACCSU_VX_M2,
  PseudoVWMACCSU_VX_M2_MASK,
  PseudoVWMACCSU_VX_M4,
  PseudoVWMACCSU_VX_M4_MASK,
  PseudoVWMACCSU_VX_MF2,
  PseudoVWMACCSU_VX_MF2_MASK,
  PseudoVWMACCSU_VX_MF4,
  PseudoVWMACCSU_VX_MF4_MASK,
  PseudoVWMACCSU_VX_MF8,
  PseudoVWMACCSU_VX_MF8_MASK,
  PseudoVWMACCUS_VX_M1,
  PseudoVWMACCUS_VX_M1_MASK,
  PseudoVWMACCUS_VX_M2,
  PseudoVWMACCUS_VX_M2_MASK,
  PseudoVWMACCUS_VX_M4,
  PseudoVWMACCUS_VX_M4_MASK,
  PseudoVWMACCUS_VX_MF2,
  PseudoVWMACCUS_VX_MF2_MASK,
  PseudoVWMACCUS_VX_MF4,
  PseudoVWMACCUS_VX_MF4_MASK,
  PseudoVWMACCUS_VX_MF8,
  PseudoVWMACCUS_VX_MF8_MASK,
  PseudoVWMACCU_VV_M1,
  PseudoVWMACCU_VV_M1_MASK,
  PseudoVWMACCU_VV_M2,
  PseudoVWMACCU_VV_M2_MASK,
  PseudoVWMACCU_VV_M4,
  PseudoVWMACCU_VV_M4_MASK,
  PseudoVWMACCU_VV_MF2,
  PseudoVWMACCU_VV_MF2_MASK,
  PseudoVWMACCU_VV_MF4,
  PseudoVWMACCU_VV_MF4_MASK,
  PseudoVWMACCU_VV_MF8,
  PseudoVWMACCU_VV_MF8_MASK,
  PseudoVWMACCU_VX_M1,
  PseudoVWMACCU_VX_M1_MASK,
  PseudoVWMACCU_VX_M2,
  PseudoVWMACCU_VX_M2_MASK,
  PseudoVWMACCU_VX_M4,
  PseudoVWMACCU_VX_M4_MASK,
  PseudoVWMACCU_VX_MF2,
  PseudoVWMACCU_VX_MF2_MASK,
  PseudoVWMACCU_VX_MF4,
  PseudoVWMACCU_VX_MF4_MASK,
  PseudoVWMACCU_VX_MF8,
  PseudoVWMACCU_VX_MF8_MASK,
  PseudoVWMACC_VV_M1,
  PseudoVWMACC_VV_M1_MASK,
  PseudoVWMACC_VV_M2,
  PseudoVWMACC_VV_M2_MASK,
  PseudoVWMACC_VV_M4,
  PseudoVWMACC_VV_M4_MASK,
  PseudoVWMACC_VV_MF2,
  PseudoVWMACC_VV_MF2_MASK,
  PseudoVWMACC_VV_MF4,
  PseudoVWMACC_VV_MF4_MASK,
  PseudoVWMACC_VV_MF8,
  PseudoVWMACC_VV_MF8_MASK,
  PseudoVWMACC_VX_M1,
  PseudoVWMACC_VX_M1_MASK,
  PseudoVWMACC_VX_M2,
  PseudoVWMACC_VX_M2_MASK,
  PseudoVWMACC_VX_M4,
  PseudoVWMACC_VX_M4_MASK,
  PseudoVWMACC_VX_MF2,
  PseudoVWMACC_VX_MF2_MASK,
  PseudoVWMACC_VX_MF4,
  PseudoVWMACC_VX_MF4_MASK,
  PseudoVWMACC_VX_MF8,
  PseudoVWMACC_VX_MF8_MASK,
  PseudoVWMULSU_VV_M1,
  PseudoVWMULSU_VV_M1_MASK,
  PseudoVWMULSU_VV_M2,
  PseudoVWMULSU_VV_M2_MASK,
  PseudoVWMULSU_VV_M4,
  PseudoVWMULSU_VV_M4_MASK,
  PseudoVWMULSU_VV_MF2,
  PseudoVWMULSU_VV_MF2_MASK,
  PseudoVWMULSU_VV_MF4,
  PseudoVWMULSU_VV_MF4_MASK,
  PseudoVWMULSU_VV_MF8,
  PseudoVWMULSU_VV_MF8_MASK,
  PseudoVWMULSU_VX_M1,
  PseudoVWMULSU_VX_M1_MASK,
  PseudoVWMULSU_VX_M2,
  PseudoVWMULSU_VX_M2_MASK,
  PseudoVWMULSU_VX_M4,
  PseudoVWMULSU_VX_M4_MASK,
  PseudoVWMULSU_VX_MF2,
  PseudoVWMULSU_VX_MF2_MASK,
  PseudoVWMULSU_VX_MF4,
  PseudoVWMULSU_VX_MF4_MASK,
  PseudoVWMULSU_VX_MF8,
  PseudoVWMULSU_VX_MF8_MASK,
  PseudoVWMULU_VV_M1,
  PseudoVWMULU_VV_M1_MASK,
  PseudoVWMULU_VV_M2,
  PseudoVWMULU_VV_M2_MASK,
  PseudoVWMULU_VV_M4,
  PseudoVWMULU_VV_M4_MASK,
  PseudoVWMULU_VV_MF2,
  PseudoVWMULU_VV_MF2_MASK,
  PseudoVWMULU_VV_MF4,
  PseudoVWMULU_VV_MF4_MASK,
  PseudoVWMULU_VV_MF8,
  PseudoVWMULU_VV_MF8_MASK,
  PseudoVWMULU_VX_M1,
  PseudoVWMULU_VX_M1_MASK,
  PseudoVWMULU_VX_M2,
  PseudoVWMULU_VX_M2_MASK,
  PseudoVWMULU_VX_M4,
  PseudoVWMULU_VX_M4_MASK,
  PseudoVWMULU_VX_MF2,
  PseudoVWMULU_VX_MF2_MASK,
  PseudoVWMULU_VX_MF4,
  PseudoVWMULU_VX_MF4_MASK,
  PseudoVWMULU_VX_MF8,
  PseudoVWMULU_VX_MF8_MASK,
  PseudoVWMUL_VV_M1,
  PseudoVWMUL_VV_M1_MASK,
  PseudoVWMUL_VV_M2,
  PseudoVWMUL_VV_M2_MASK,
  PseudoVWMUL_VV_M4,
  PseudoVWMUL_VV_M4_MASK,
  PseudoVWMUL_VV_MF2,
  PseudoVWMUL_VV_MF2_MASK,
  PseudoVWMUL_VV_MF4,
  PseudoVWMUL_VV_MF4_MASK,
  PseudoVWMUL_VV_MF8,
  PseudoVWMUL_VV_MF8_MASK,
  PseudoVWMUL_VX_M1,
  PseudoVWMUL_VX_M1_MASK,
  PseudoVWMUL_VX_M2,
  PseudoVWMUL_VX_M2_MASK,
  PseudoVWMUL_VX_M4,
  PseudoVWMUL_VX_M4_MASK,
  PseudoVWMUL_VX_MF2,
  PseudoVWMUL_VX_MF2_MASK,
  PseudoVWMUL_VX_MF4,
  PseudoVWMUL_VX_MF4_MASK,
  PseudoVWMUL_VX_MF8,
  PseudoVWMUL_VX_MF8_MASK,
  PseudoVWREDSUMU_VS_M1_E16,
  PseudoVWREDSUMU_VS_M1_E16_MASK,
  PseudoVWREDSUMU_VS_M1_E32,
  PseudoVWREDSUMU_VS_M1_E32_MASK,
  PseudoVWREDSUMU_VS_M1_E8,
  PseudoVWREDSUMU_VS_M1_E8_MASK,
  PseudoVWREDSUMU_VS_M2_E16,
  PseudoVWREDSUMU_VS_M2_E16_MASK,
  PseudoVWREDSUMU_VS_M2_E32,
  PseudoVWREDSUMU_VS_M2_E32_MASK,
  PseudoVWREDSUMU_VS_M2_E8,
  PseudoVWREDSUMU_VS_M2_E8_MASK,
  PseudoVWREDSUMU_VS_M4_E16,
  PseudoVWREDSUMU_VS_M4_E16_MASK,
  PseudoVWREDSUMU_VS_M4_E32,
  PseudoVWREDSUMU_VS_M4_E32_MASK,
  PseudoVWREDSUMU_VS_M4_E8,
  PseudoVWREDSUMU_VS_M4_E8_MASK,
  PseudoVWREDSUMU_VS_M8_E16,
  PseudoVWREDSUMU_VS_M8_E16_MASK,
  PseudoVWREDSUMU_VS_M8_E32,
  PseudoVWREDSUMU_VS_M8_E32_MASK,
  PseudoVWREDSUMU_VS_M8_E8,
  PseudoVWREDSUMU_VS_M8_E8_MASK,
  PseudoVWREDSUMU_VS_MF2_E16,
  PseudoVWREDSUMU_VS_MF2_E16_MASK,
  PseudoVWREDSUMU_VS_MF2_E32,
  PseudoVWREDSUMU_VS_MF2_E32_MASK,
  PseudoVWREDSUMU_VS_MF2_E8,
  PseudoVWREDSUMU_VS_MF2_E8_MASK,
  PseudoVWREDSUMU_VS_MF4_E16,
  PseudoVWREDSUMU_VS_MF4_E16_MASK,
  PseudoVWREDSUMU_VS_MF4_E8,
  PseudoVWREDSUMU_VS_MF4_E8_MASK,
  PseudoVWREDSUMU_VS_MF8_E8,
  PseudoVWREDSUMU_VS_MF8_E8_MASK,
  PseudoVWREDSUM_VS_M1_E16,
  PseudoVWREDSUM_VS_M1_E16_MASK,
  PseudoVWREDSUM_VS_M1_E32,
  PseudoVWREDSUM_VS_M1_E32_MASK,
  PseudoVWREDSUM_VS_M1_E8,
  PseudoVWREDSUM_VS_M1_E8_MASK,
  PseudoVWREDSUM_VS_M2_E16,
  PseudoVWREDSUM_VS_M2_E16_MASK,
  PseudoVWREDSUM_VS_M2_E32,
  PseudoVWREDSUM_VS_M2_E32_MASK,
  PseudoVWREDSUM_VS_M2_E8,
  PseudoVWREDSUM_VS_M2_E8_MASK,
  PseudoVWREDSUM_VS_M4_E16,
  PseudoVWREDSUM_VS_M4_E16_MASK,
  PseudoVWREDSUM_VS_M4_E32,
  PseudoVWREDSUM_VS_M4_E32_MASK,
  PseudoVWREDSUM_VS_M4_E8,
  PseudoVWREDSUM_VS_M4_E8_MASK,
  PseudoVWREDSUM_VS_M8_E16,
  PseudoVWREDSUM_VS_M8_E16_MASK,
  PseudoVWREDSUM_VS_M8_E32,
  PseudoVWREDSUM_VS_M8_E32_MASK,
  PseudoVWREDSUM_VS_M8_E8,
  PseudoVWREDSUM_VS_M8_E8_MASK,
  PseudoVWREDSUM_VS_MF2_E16,
  PseudoVWREDSUM_VS_MF2_E16_MASK,
  PseudoVWREDSUM_VS_MF2_E32,
  PseudoVWREDSUM_VS_MF2_E32_MASK,
  PseudoVWREDSUM_VS_MF2_E8,
  PseudoVWREDSUM_VS_MF2_E8_MASK,
  PseudoVWREDSUM_VS_MF4_E16,
  PseudoVWREDSUM_VS_MF4_E16_MASK,
  PseudoVWREDSUM_VS_MF4_E8,
  PseudoVWREDSUM_VS_MF4_E8_MASK,
  PseudoVWREDSUM_VS_MF8_E8,
  PseudoVWREDSUM_VS_MF8_E8_MASK,
  PseudoVWSLL_VI_M1,
  PseudoVWSLL_VI_M1_MASK,
  PseudoVWSLL_VI_M2,
  PseudoVWSLL_VI_M2_MASK,
  PseudoVWSLL_VI_M4,
  PseudoVWSLL_VI_M4_MASK,
  PseudoVWSLL_VI_MF2,
  PseudoVWSLL_VI_MF2_MASK,
  PseudoVWSLL_VI_MF4,
  PseudoVWSLL_VI_MF4_MASK,
  PseudoVWSLL_VI_MF8,
  PseudoVWSLL_VI_MF8_MASK,
  PseudoVWSLL_VV_M1,
  PseudoVWSLL_VV_M1_MASK,
  PseudoVWSLL_VV_M2,
  PseudoVWSLL_VV_M2_MASK,
  PseudoVWSLL_VV_M4,
  PseudoVWSLL_VV_M4_MASK,
  PseudoVWSLL_VV_MF2,
  PseudoVWSLL_VV_MF2_MASK,
  PseudoVWSLL_VV_MF4,
  PseudoVWSLL_VV_MF4_MASK,
  PseudoVWSLL_VV_MF8,
  PseudoVWSLL_VV_MF8_MASK,
  PseudoVWSLL_VX_M1,
  PseudoVWSLL_VX_M1_MASK,
  PseudoVWSLL_VX_M2,
  PseudoVWSLL_VX_M2_MASK,
  PseudoVWSLL_VX_M4,
  PseudoVWSLL_VX_M4_MASK,
  PseudoVWSLL_VX_MF2,
  PseudoVWSLL_VX_MF2_MASK,
  PseudoVWSLL_VX_MF4,
  PseudoVWSLL_VX_MF4_MASK,
  PseudoVWSLL_VX_MF8,
  PseudoVWSLL_VX_MF8_MASK,
  PseudoVWSUBU_VV_M1,
  PseudoVWSUBU_VV_M1_MASK,
  PseudoVWSUBU_VV_M2,
  PseudoVWSUBU_VV_M2_MASK,
  PseudoVWSUBU_VV_M4,
  PseudoVWSUBU_VV_M4_MASK,
  PseudoVWSUBU_VV_MF2,
  PseudoVWSUBU_VV_MF2_MASK,
  PseudoVWSUBU_VV_MF4,
  PseudoVWSUBU_VV_MF4_MASK,
  PseudoVWSUBU_VV_MF8,
  PseudoVWSUBU_VV_MF8_MASK,
  PseudoVWSUBU_VX_M1,
  PseudoVWSUBU_VX_M1_MASK,
  PseudoVWSUBU_VX_M2,
  PseudoVWSUBU_VX_M2_MASK,
  PseudoVWSUBU_VX_M4,
  PseudoVWSUBU_VX_M4_MASK,
  PseudoVWSUBU_VX_MF2,
  PseudoVWSUBU_VX_MF2_MASK,
  PseudoVWSUBU_VX_MF4,
  PseudoVWSUBU_VX_MF4_MASK,
  PseudoVWSUBU_VX_MF8,
  PseudoVWSUBU_VX_MF8_MASK,
  PseudoVWSUBU_WV_M1,
  PseudoVWSUBU_WV_M1_MASK,
  PseudoVWSUBU_WV_M1_MASK_TIED,
  PseudoVWSUBU_WV_M1_TIED,
  PseudoVWSUBU_WV_M2,
  PseudoVWSUBU_WV_M2_MASK,
  PseudoVWSUBU_WV_M2_MASK_TIED,
  PseudoVWSUBU_WV_M2_TIED,
  PseudoVWSUBU_WV_M4,
  PseudoVWSUBU_WV_M4_MASK,
  PseudoVWSUBU_WV_M4_MASK_TIED,
  PseudoVWSUBU_WV_M4_TIED,
  PseudoVWSUBU_WV_MF2,
  PseudoVWSUBU_WV_MF2_MASK,
  PseudoVWSUBU_WV_MF2_MASK_TIED,
  PseudoVWSUBU_WV_MF2_TIED,
  PseudoVWSUBU_WV_MF4,
  PseudoVWSUBU_WV_MF4_MASK,
  PseudoVWSUBU_WV_MF4_MASK_TIED,
  PseudoVWSUBU_WV_MF4_TIED,
  PseudoVWSUBU_WV_MF8,
  PseudoVWSUBU_WV_MF8_MASK,
  PseudoVWSUBU_WV_MF8_MASK_TIED,
  PseudoVWSUBU_WV_MF8_TIED,
  PseudoVWSUBU_WX_M1,
  PseudoVWSUBU_WX_M1_MASK,
  PseudoVWSUBU_WX_M2,
  PseudoVWSUBU_WX_M2_MASK,
  PseudoVWSUBU_WX_M4,
  PseudoVWSUBU_WX_M4_MASK,
  PseudoVWSUBU_WX_MF2,
  PseudoVWSUBU_WX_MF2_MASK,
  PseudoVWSUBU_WX_MF4,
  PseudoVWSUBU_WX_MF4_MASK,
  PseudoVWSUBU_WX_MF8,
  PseudoVWSUBU_WX_MF8_MASK,
  PseudoVWSUB_VV_M1,
  PseudoVWSUB_VV_M1_MASK,
  PseudoVWSUB_VV_M2,
  PseudoVWSUB_VV_M2_MASK,
  PseudoVWSUB_VV_M4,
  PseudoVWSUB_VV_M4_MASK,
  PseudoVWSUB_VV_MF2,
  PseudoVWSUB_VV_MF2_MASK,
  PseudoVWSUB_VV_MF4,
  PseudoVWSUB_VV_MF4_MASK,
  PseudoVWSUB_VV_MF8,
  PseudoVWSUB_VV_MF8_MASK,
  PseudoVWSUB_VX_M1,
  PseudoVWSUB_VX_M1_MASK,
  PseudoVWSUB_VX_M2,
  PseudoVWSUB_VX_M2_MASK,
  PseudoVWSUB_VX_M4,
  PseudoVWSUB_VX_M4_MASK,
  PseudoVWSUB_VX_MF2,
  PseudoVWSUB_VX_MF2_MASK,
  PseudoVWSUB_VX_MF4,
  PseudoVWSUB_VX_MF4_MASK,
  PseudoVWSUB_VX_MF8,
  PseudoVWSUB_VX_MF8_MASK,
  PseudoVWSUB_WV_M1,
  PseudoVWSUB_WV_M1_MASK,
  PseudoVWSUB_WV_M1_MASK_TIED,
  PseudoVWSUB_WV_M1_TIED,
  PseudoVWSUB_WV_M2,
  PseudoVWSUB_WV_M2_MASK,
  PseudoVWSUB_WV_M2_MASK_TIED,
  PseudoVWSUB_WV_M2_TIED,
  PseudoVWSUB_WV_M4,
  PseudoVWSUB_WV_M4_MASK,
  PseudoVWSUB_WV_M4_MASK_TIED,
  PseudoVWSUB_WV_M4_TIED,
  PseudoVWSUB_WV_MF2,
  PseudoVWSUB_WV_MF2_MASK,
  PseudoVWSUB_WV_MF2_MASK_TIED,
  PseudoVWSUB_WV_MF2_TIED,
  PseudoVWSUB_WV_MF4,
  PseudoVWSUB_WV_MF4_MASK,
  PseudoVWSUB_WV_MF4_MASK_TIED,
  PseudoVWSUB_WV_MF4_TIED,
  PseudoVWSUB_WV_MF8,
  PseudoVWSUB_WV_MF8_MASK,
  PseudoVWSUB_WV_MF8_MASK_TIED,
  PseudoVWSUB_WV_MF8_TIED,
  PseudoVWSUB_WX_M1,
  PseudoVWSUB_WX_M1_MASK,
  PseudoVWSUB_WX_M2,
  PseudoVWSUB_WX_M2_MASK,
  PseudoVWSUB_WX_M4,
  PseudoVWSUB_WX_M4_MASK,
  PseudoVWSUB_WX_MF2,
  PseudoVWSUB_WX_MF2_MASK,
  PseudoVWSUB_WX_MF4,
  PseudoVWSUB_WX_MF4_MASK,
  PseudoVWSUB_WX_MF8,
  PseudoVWSUB_WX_MF8_MASK,
  PseudoVXOR_VI_M1,
  PseudoVXOR_VI_M1_MASK,
  PseudoVXOR_VI_M2,
  PseudoVXOR_VI_M2_MASK,
  PseudoVXOR_VI_M4,
  PseudoVXOR_VI_M4_MASK,
  PseudoVXOR_VI_M8,
  PseudoVXOR_VI_M8_MASK,
  PseudoVXOR_VI_MF2,
  PseudoVXOR_VI_MF2_MASK,
  PseudoVXOR_VI_MF4,
  PseudoVXOR_VI_MF4_MASK,
  PseudoVXOR_VI_MF8,
  PseudoVXOR_VI_MF8_MASK,
  PseudoVXOR_VV_M1,
  PseudoVXOR_VV_M1_MASK,
  PseudoVXOR_VV_M2,
  PseudoVXOR_VV_M2_MASK,
  PseudoVXOR_VV_M4,
  PseudoVXOR_VV_M4_MASK,
  PseudoVXOR_VV_M8,
  PseudoVXOR_VV_M8_MASK,
  PseudoVXOR_VV_MF2,
  PseudoVXOR_VV_MF2_MASK,
  PseudoVXOR_VV_MF4,
  PseudoVXOR_VV_MF4_MASK,
  PseudoVXOR_VV_MF8,
  PseudoVXOR_VV_MF8_MASK,
  PseudoVXOR_VX_M1,
  PseudoVXOR_VX_M1_MASK,
  PseudoVXOR_VX_M2,
  PseudoVXOR_VX_M2_MASK,
  PseudoVXOR_VX_M4,
  PseudoVXOR_VX_M4_MASK,
  PseudoVXOR_VX_M8,
  PseudoVXOR_VX_M8_MASK,
  PseudoVXOR_VX_MF2,
  PseudoVXOR_VX_MF2_MASK,
  PseudoVXOR_VX_MF4,
  PseudoVXOR_VX_MF4_MASK,
  PseudoVXOR_VX_MF8,
  PseudoVXOR_VX_MF8_MASK,
  PseudoVZEXT_VF2_M1,
  PseudoVZEXT_VF2_M1_MASK,
  PseudoVZEXT_VF2_M2,
  PseudoVZEXT_VF2_M2_MASK,
  PseudoVZEXT_VF2_M4,
  PseudoVZEXT_VF2_M4_MASK,
  PseudoVZEXT_VF2_M8,
  PseudoVZEXT_VF2_M8_MASK,
  PseudoVZEXT_VF2_MF2,
  PseudoVZEXT_VF2_MF2_MASK,
  PseudoVZEXT_VF2_MF4,
  PseudoVZEXT_VF2_MF4_MASK,
  PseudoVZEXT_VF4_M1,
  PseudoVZEXT_VF4_M1_MASK,
  PseudoVZEXT_VF4_M2,
  PseudoVZEXT_VF4_M2_MASK,
  PseudoVZEXT_VF4_M4,
  PseudoVZEXT_VF4_M4_MASK,
  PseudoVZEXT_VF4_M8,
  PseudoVZEXT_VF4_M8_MASK,
  PseudoVZEXT_VF4_MF2,
  PseudoVZEXT_VF4_MF2_MASK,
  PseudoVZEXT_VF8_M1,
  PseudoVZEXT_VF8_M1_MASK,
  PseudoVZEXT_VF8_M2,
  PseudoVZEXT_VF8_M2_MASK,
  PseudoVZEXT_VF8_M4,
  PseudoVZEXT_VF8_M4_MASK,
  PseudoVZEXT_VF8_M8,
  PseudoVZEXT_VF8_M8_MASK,
  PseudoZEXT_H,
  PseudoZEXT_W,
  ReadCounterWide,
  ReadFCSR,
  ReadFFLAGS,
  ReadFRM,
  Select_FPR16INX_Using_CC_GPR,
  Select_FPR16_Using_CC_GPR,
  Select_FPR32INX_Using_CC_GPR,
  Select_FPR32_Using_CC_GPR,
  Select_FPR64IN32X_Using_CC_GPR,
  Select_FPR64INX_Using_CC_GPR,
  Select_FPR64_Using_CC_GPR,
  Select_GPRNoX0_Using_CC_SImm16NonZero_QC,
  Select_GPRNoX0_Using_CC_SImm5NonZero_QC,
  Select_GPRNoX0_Using_CC_UImm16NonZero_QC,
  Select_GPRNoX0_Using_CC_UImm5NonZero_QC,
  Select_GPR_Using_CC_GPR,
  Select_GPR_Using_CC_SImm5_CV,
  Select_GPR_Using_CC_UImm7_NDS,
  Select_GPR_Using_CC_UImmLog2XLen_NDS,
  SplitF64Pseudo,
  SwapFRMImm,
  WriteFCSR,
  WriteFCSRImm,
  WriteFFLAGS,
  WriteFRM,
  WriteFRMImm,
  WriteVXRMImm,
  ABS,
  ABSW,
  ADD,
  ADDI,
  ADDIW,
  ADDW,
  ADD_UW,
  AES32DSI,
  AES32DSMI,
  AES32ESI,
  AES32ESMI,
  AES64DS,
  AES64DSM,
  AES64ES,
  AES64ESM,
  AES64IM,
  AES64KS1I,
  AES64KS2,
  AMOADD_B,
  AMOADD_B_AQ,
  AMOADD_B_AQ_RL,
  AMOADD_B_RL,
  AMOADD_D,
  AMOADD_D_AQ,
  AMOADD_D_AQ_RL,
  AMOADD_D_RL,
  AMOADD_H,
  AMOADD_H_AQ,
  AMOADD_H_AQ_RL,
  AMOADD_H_RL,
  AMOADD_W,
  AMOADD_W_AQ,
  AMOADD_W_AQ_RL,
  AMOADD_W_RL,
  AMOAND_B,
  AMOAND_B_AQ,
  AMOAND_B_AQ_RL,
  AMOAND_B_RL,
  AMOAND_D,
  AMOAND_D_AQ,
  AMOAND_D_AQ_RL,
  AMOAND_D_RL,
  AMOAND_H,
  AMOAND_H_AQ,
  AMOAND_H_AQ_RL,
  AMOAND_H_RL,
  AMOAND_W,
  AMOAND_W_AQ,
  AMOAND_W_AQ_RL,
  AMOAND_W_RL,
  AMOCAS_B,
  AMOCAS_B_AQ,
  AMOCAS_B_AQ_RL,
  AMOCAS_B_RL,
  AMOCAS_D_RV32,
  AMOCAS_D_RV32_AQ,
  AMOCAS_D_RV32_AQ_RL,
  AMOCAS_D_RV32_RL,
  AMOCAS_D_RV64,
  AMOCAS_D_RV64_AQ,
  AMOCAS_D_RV64_AQ_RL,
  AMOCAS_D_RV64_RL,
  AMOCAS_H,
  AMOCAS_H_AQ,
  AMOCAS_H_AQ_RL,
  AMOCAS_H_RL,
  AMOCAS_Q,
  AMOCAS_Q_AQ,
  AMOCAS_Q_AQ_RL,
  AMOCAS_Q_RL,
  AMOCAS_W,
  AMOCAS_W_AQ,
  AMOCAS_W_AQ_RL,
  AMOCAS_W_RL,
  AMOMAXU_B,
  AMOMAXU_B_AQ,
  AMOMAXU_B_AQ_RL,
  AMOMAXU_B_RL,
  AMOMAXU_D,
  AMOMAXU_D_AQ,
  AMOMAXU_D_AQ_RL,
  AMOMAXU_D_RL,
  AMOMAXU_H,
  AMOMAXU_H_AQ,
  AMOMAXU_H_AQ_RL,
  AMOMAXU_H_RL,
  AMOMAXU_W,
  AMOMAXU_W_AQ,
  AMOMAXU_W_AQ_RL,
  AMOMAXU_W_RL,
  AMOMAX_B,
  AMOMAX_B_AQ,
  AMOMAX_B_AQ_RL,
  AMOMAX_B_RL,
  AMOMAX_D,
  AMOMAX_D_AQ,
  AMOMAX_D_AQ_RL,
  AMOMAX_D_RL,
  AMOMAX_H,
  AMOMAX_H_AQ,
  AMOMAX_H_AQ_RL,
  AMOMAX_H_RL,
  AMOMAX_W,
  AMOMAX_W_AQ,
  AMOMAX_W_AQ_RL,
  AMOMAX_W_RL,
  AMOMINU_B,
  AMOMINU_B_AQ,
  AMOMINU_B_AQ_RL,
  AMOMINU_B_RL,
  AMOMINU_D,
  AMOMINU_D_AQ,
  AMOMINU_D_AQ_RL,
  AMOMINU_D_RL,
  AMOMINU_H,
  AMOMINU_H_AQ,
  AMOMINU_H_AQ_RL,
  AMOMINU_H_RL,
  AMOMINU_W,
  AMOMINU_W_AQ,
  AMOMINU_W_AQ_RL,
  AMOMINU_W_RL,
  AMOMIN_B,
  AMOMIN_B_AQ,
  AMOMIN_B_AQ_RL,
  AMOMIN_B_RL,
  AMOMIN_D,
  AMOMIN_D_AQ,
  AMOMIN_D_AQ_RL,
  AMOMIN_D_RL,
  AMOMIN_H,
  AMOMIN_H_AQ,
  AMOMIN_H_AQ_RL,
  AMOMIN_H_RL,
  AMOMIN_W,
  AMOMIN_W_AQ,
  AMOMIN_W_AQ_RL,
  AMOMIN_W_RL,
  AMOOR_B,
  AMOOR_B_AQ,
  AMOOR_B_AQ_RL,
  AMOOR_B_RL,
  AMOOR_D,
  AMOOR_D_AQ,
  AMOOR_D_AQ_RL,
  AMOOR_D_RL,
  AMOOR_H,
  AMOOR_H_AQ,
  AMOOR_H_AQ_RL,
  AMOOR_H_RL,
  AMOOR_W,
  AMOOR_W_AQ,
  AMOOR_W_AQ_RL,
  AMOOR_W_RL,
  AMOSWAP_B,
  AMOSWAP_B_AQ,
  AMOSWAP_B_AQ_RL,
  AMOSWAP_B_RL,
  AMOSWAP_D,
  AMOSWAP_D_AQ,
  AMOSWAP_D_AQ_RL,
  AMOSWAP_D_RL,
  AMOSWAP_H,
  AMOSWAP_H_AQ,
  AMOSWAP_H_AQ_RL,
  AMOSWAP_H_RL,
  AMOSWAP_W,
  AMOSWAP_W_AQ,
  AMOSWAP_W_AQ_RL,
  AMOSWAP_W_RL,
  AMOXOR_B,
  AMOXOR_B_AQ,
  AMOXOR_B_AQ_RL,
  AMOXOR_B_RL,
  AMOXOR_D,
  AMOXOR_D_AQ,
  AMOXOR_D_AQ_RL,
  AMOXOR_D_RL,
  AMOXOR_H,
  AMOXOR_H_AQ,
  AMOXOR_H_AQ_RL,
  AMOXOR_H_RL,
  AMOXOR_W,
  AMOXOR_W_AQ,
  AMOXOR_W_AQ_RL,
  AMOXOR_W_RL,
  AND,
  ANDI,
  ANDN,
  AUIPC,
  BCLR,
  BCLRI,
  BEQ,
  BEXT,
  BEXTI,
  BGE,
  BGEU,
  BINV,
  BINVI,
  BLT,
  BLTU,
  BNE,
  BREV8,
  BSET,
  BSETI,
  CBO_CLEAN,
  CBO_FLUSH,
  CBO_INVAL,
  CBO_ZERO,
  CLMUL,
  CLMULH,
  CLMULR,
  CLS,
  CLSW,
  CLZ,
  CLZW,
  CM_JALT,
  CM_JT,
  CM_MVA01S,
  CM_MVSA01,
  CM_POP,
  CM_POPRET,
  CM_POPRETZ,
  CM_PUSH,
  CPOP,
  CPOPW,
  CSRRC,
  CSRRCI,
  CSRRS,
  CSRRSI,
  CSRRW,
  CSRRWI,
  CTZ,
  CTZW,
  CV_ABS,
  CV_ABS_B,
  CV_ABS_H,
  CV_ADDN,
  CV_ADDNR,
  CV_ADDRN,
  CV_ADDRNR,
  CV_ADDUN,
  CV_ADDUNR,
  CV_ADDURN,
  CV_ADDURNR,
  CV_ADD_B,
  CV_ADD_DIV2,
  CV_ADD_DIV4,
  CV_ADD_DIV8,
  CV_ADD_H,
  CV_ADD_SCI_B,
  CV_ADD_SCI_H,
  CV_ADD_SC_B,
  CV_ADD_SC_H,
  CV_AND_B,
  CV_AND_H,
  CV_AND_SCI_B,
  CV_AND_SCI_H,
  CV_AND_SC_B,
  CV_AND_SC_H,
  CV_AVGU_B,
  CV_AVGU_H,
  CV_AVGU_SCI_B,
  CV_AVGU_SCI_H,
  CV_AVGU_SC_B,
  CV_AVGU_SC_H,
  CV_AVG_B,
  CV_AVG_H,
  CV_AVG_SCI_B,
  CV_AVG_SCI_H,
  CV_AVG_SC_B,
  CV_AVG_SC_H,
  CV_BCLR,
  CV_BCLRR,
  CV_BEQIMM,
  CV_BITREV,
  CV_BNEIMM,
  CV_BSET,
  CV_BSETR,
  CV_CLB,
  CV_CLIP,
  CV_CLIPR,
  CV_CLIPU,
  CV_CLIPUR,
  CV_CMPEQ_B,
  CV_CMPEQ_H,
  CV_CMPEQ_SCI_B,
  CV_CMPEQ_SCI_H,
  CV_CMPEQ_SC_B,
  CV_CMPEQ_SC_H,
  CV_CMPGEU_B,
  CV_CMPGEU_H,
  CV_CMPGEU_SCI_B,
  CV_CMPGEU_SCI_H,
  CV_CMPGEU_SC_B,
  CV_CMPGEU_SC_H,
  CV_CMPGE_B,
  CV_CMPGE_H,
  CV_CMPGE_SCI_B,
  CV_CMPGE_SCI_H,
  CV_CMPGE_SC_B,
  CV_CMPGE_SC_H,
  CV_CMPGTU_B,
  CV_CMPGTU_H,
  CV_CMPGTU_SCI_B,
  CV_CMPGTU_SCI_H,
  CV_CMPGTU_SC_B,
  CV_CMPGTU_SC_H,
  CV_CMPGT_B,
  CV_CMPGT_H,
  CV_CMPGT_SCI_B,
  CV_CMPGT_SCI_H,
  CV_CMPGT_SC_B,
  CV_CMPGT_SC_H,
  CV_CMPLEU_B,
  CV_CMPLEU_H,
  CV_CMPLEU_SCI_B,
  CV_CMPLEU_SCI_H,
  CV_CMPLEU_SC_B,
  CV_CMPLEU_SC_H,
  CV_CMPLE_B,
  CV_CMPLE_H,
  CV_CMPLE_SCI_B,
  CV_CMPLE_SCI_H,
  CV_CMPLE_SC_B,
  CV_CMPLE_SC_H,
  CV_CMPLTU_B,
  CV_CMPLTU_H,
  CV_CMPLTU_SCI_B,
  CV_CMPLTU_SCI_H,
  CV_CMPLTU_SC_B,
  CV_CMPLTU_SC_H,
  CV_CMPLT_B,
  CV_CMPLT_H,
  CV_CMPLT_SCI_B,
  CV_CMPLT_SCI_H,
  CV_CMPLT_SC_B,
  CV_CMPLT_SC_H,
  CV_CMPNE_B,
  CV_CMPNE_H,
  CV_CMPNE_SCI_B,
  CV_CMPNE_SCI_H,
  CV_CMPNE_SC_B,
  CV_CMPNE_SC_H,
  CV_CNT,
  CV_CPLXCONJ,
  CV_CPLXMUL_I,
  CV_CPLXMUL_I_DIV2,
  CV_CPLXMUL_I_DIV4,
  CV_CPLXMUL_I_DIV8,
  CV_CPLXMUL_R,
  CV_CPLXMUL_R_DIV2,
  CV_CPLXMUL_R_DIV4,
  CV_CPLXMUL_R_DIV8,
  CV_DOTSP_B,
  CV_DOTSP_H,
  CV_DOTSP_SCI_B,
  CV_DOTSP_SCI_H,
  CV_DOTSP_SC_B,
  CV_DOTSP_SC_H,
  CV_DOTUP_B,
  CV_DOTUP_H,
  CV_DOTUP_SCI_B,
  CV_DOTUP_SCI_H,
  CV_DOTUP_SC_B,
  CV_DOTUP_SC_H,
  CV_DOTUSP_B,
  CV_DOTUSP_H,
  CV_DOTUSP_SCI_B,
  CV_DOTUSP_SCI_H,
  CV_DOTUSP_SC_B,
  CV_DOTUSP_SC_H,
  CV_ELW,
  CV_EXTBS,
  CV_EXTBZ,
  CV_EXTHS,
  CV_EXTHZ,
  CV_EXTRACT,
  CV_EXTRACTR,
  CV_EXTRACTU,
  CV_EXTRACTUR,
  CV_EXTRACTU_B,
  CV_EXTRACTU_H,
  CV_EXTRACT_B,
  CV_EXTRACT_H,
  CV_FF1,
  CV_FL1,
  CV_INSERT,
  CV_INSERTR,
  CV_INSERT_B,
  CV_INSERT_H,
  CV_LBU_ri_inc,
  CV_LBU_rr,
  CV_LBU_rr_inc,
  CV_LB_ri_inc,
  CV_LB_rr,
  CV_LB_rr_inc,
  CV_LHU_ri_inc,
  CV_LHU_rr,
  CV_LHU_rr_inc,
  CV_LH_ri_inc,
  CV_LH_rr,
  CV_LH_rr_inc,
  CV_LW_ri_inc,
  CV_LW_rr,
  CV_LW_rr_inc,
  CV_MAC,
  CV_MACHHSN,
  CV_MACHHSRN,
  CV_MACHHUN,
  CV_MACHHURN,
  CV_MACSN,
  CV_MACSRN,
  CV_MACUN,
  CV_MACURN,
  CV_MAX,
  CV_MAXU,
  CV_MAXU_B,
  CV_MAXU_H,
  CV_MAXU_SCI_B,
  CV_MAXU_SCI_H,
  CV_MAXU_SC_B,
  CV_MAXU_SC_H,
  CV_MAX_B,
  CV_MAX_H,
  CV_MAX_SCI_B,
  CV_MAX_SCI_H,
  CV_MAX_SC_B,
  CV_MAX_SC_H,
  CV_MIN,
  CV_MINU,
  CV_MINU_B,
  CV_MINU_H,
  CV_MINU_SCI_B,
  CV_MINU_SCI_H,
  CV_MINU_SC_B,
  CV_MINU_SC_H,
  CV_MIN_B,
  CV_MIN_H,
  CV_MIN_SCI_B,
  CV_MIN_SCI_H,
  CV_MIN_SC_B,
  CV_MIN_SC_H,
  CV_MSU,
  CV_MULHHSN,
  CV_MULHHSRN,
  CV_MULHHUN,
  CV_MULHHURN,
  CV_MULSN,
  CV_MULSRN,
  CV_MULUN,
  CV_MULURN,
  CV_OR_B,
  CV_OR_H,
  CV_OR_SCI_B,
  CV_OR_SCI_H,
  CV_OR_SC_B,
  CV_OR_SC_H,
  CV_PACK,
  CV_PACKHI_B,
  CV_PACKLO_B,
  CV_PACK_H,
  CV_ROR,
  CV_SB_ri_inc,
  CV_SB_rr,
  CV_SB_rr_inc,
  CV_SDOTSP_B,
  CV_SDOTSP_H,
  CV_SDOTSP_SCI_B,
  CV_SDOTSP_SCI_H,
  CV_SDOTSP_SC_B,
  CV_SDOTSP_SC_H,
  CV_SDOTUP_B,
  CV_SDOTUP_H,
  CV_SDOTUP_SCI_B,
  CV_SDOTUP_SCI_H,
  CV_SDOTUP_SC_B,
  CV_SDOTUP_SC_H,
  CV_SDOTUSP_B,
  CV_SDOTUSP_H,
  CV_SDOTUSP_SCI_B,
  CV_SDOTUSP_SCI_H,
  CV_SDOTUSP_SC_B,
  CV_SDOTUSP_SC_H,
  CV_SHUFFLE2_B,
  CV_SHUFFLE2_H,
  CV_SHUFFLEI0_SCI_B,
  CV_SHUFFLEI1_SCI_B,
  CV_SHUFFLEI2_SCI_B,
  CV_SHUFFLEI3_SCI_B,
  CV_SHUFFLE_B,
  CV_SHUFFLE_H,
  CV_SHUFFLE_SCI_H,
  CV_SH_ri_inc,
  CV_SH_rr,
  CV_SH_rr_inc,
  CV_SLE,
  CV_SLEU,
  CV_SLL_B,
  CV_SLL_H,
  CV_SLL_SCI_B,
  CV_SLL_SCI_H,
  CV_SLL_SC_B,
  CV_SLL_SC_H,
  CV_SRA_B,
  CV_SRA_H,
  CV_SRA_SCI_B,
  CV_SRA_SCI_H,
  CV_SRA_SC_B,
  CV_SRA_SC_H,
  CV_SRL_B,
  CV_SRL_H,
  CV_SRL_SCI_B,
  CV_SRL_SCI_H,
  CV_SRL_SC_B,
  CV_SRL_SC_H,
  CV_SUBN,
  CV_SUBNR,
  CV_SUBRN,
  CV_SUBRNR,
  CV_SUBROTMJ,
  CV_SUBROTMJ_DIV2,
  CV_SUBROTMJ_DIV4,
  CV_SUBROTMJ_DIV8,
  CV_SUBUN,
  CV_SUBUNR,
  CV_SUBURN,
  CV_SUBURNR,
  CV_SUB_B,
  CV_SUB_DIV2,
  CV_SUB_DIV4,
  CV_SUB_DIV8,
  CV_SUB_H,
  CV_SUB_SCI_B,
  CV_SUB_SCI_H,
  CV_SUB_SC_B,
  CV_SUB_SC_H,
  CV_SW_ri_inc,
  CV_SW_rr,
  CV_SW_rr_inc,
  CV_XOR_B,
  CV_XOR_H,
  CV_XOR_SCI_B,
  CV_XOR_SCI_H,
  CV_XOR_SC_B,
  CV_XOR_SC_H,
  CZERO_EQZ,
  CZERO_NEZ,
  C_ADD,
  C_ADDI,
  C_ADDI16SP,
  C_ADDI4SPN,
  C_ADDIW,
  C_ADDI_HINT_IMM_ZERO,
  C_ADDW,
  C_ADD_HINT,
  C_AND,
  C_ANDI,
  C_BEQZ,
  C_BNEZ,
  C_EBREAK,
  C_FLD,
  C_FLDSP,
  C_FLW,
  C_FLWSP,
  C_FSD,
  C_FSDSP,
  C_FSW,
  C_FSWSP,
  C_J,
  C_JAL,
  C_JALR,
  C_JR,
  C_LBU,
  C_LD,
  C_LDSP,
  C_LDSP_RV32,
  C_LD_RV32,
  C_LH,
  C_LHU,
  C_LH_INX,
  C_LI,
  C_LI_HINT,
  C_LUI,
  C_LUI_HINT,
  C_LW,
  C_LWSP,
  C_LWSP_INX,
  C_LW_INX,
  C_MOP1,
  C_MOP11,
  C_MOP13,
  C_MOP15,
  C_MOP3,
  C_MOP5,
  C_MOP7,
  C_MOP9,
  C_MUL,
  C_MV,
  C_MV_HINT,
  C_NOP,
  C_NOP_HINT,
  C_NOT,
  C_OR,
  C_SB,
  C_SD,
  C_SDSP,
  C_SDSP_RV32,
  C_SD_RV32,
  C_SEXT_B,
  C_SEXT_H,
  C_SH,
  C_SH_INX,
  C_SLLI,
  C_SLLI64_HINT,
  C_SLLI_HINT,
  C_SRAI,
  C_SRAI64_HINT,
  C_SRLI,
  C_SRLI64_HINT,
  C_SSPOPCHK,
  C_SSPUSH,
  C_SUB,
  C_SUBW,
  C_SW,
  C_SWSP,
  C_SWSP_INX,
  C_SW_INX,
  C_UNIMP,
  C_XOR,
  C_ZEXT_B,
  C_ZEXT_H,
  C_ZEXT_W,
  DIV,
  DIVU,
  DIVUW,
  DIVW,
  DRET,
  EBREAK,
  ECALL,
  FADD_D,
  FADD_D_IN32X,
  FADD_D_INX,
  FADD_H,
  FADD_H_INX,
  FADD_Q,
  FADD_S,
  FADD_S_INX,
  FCLASS_D,
  FCLASS_D_IN32X,
  FCLASS_D_INX,
  FCLASS_H,
  FCLASS_H_INX,
  FCLASS_Q,
  FCLASS_S,
  FCLASS_S_INX,
  FCVTMOD_W_D,
  FCVT_BF16_S,
  FCVT_D_H,
  FCVT_D_H_IN32X,
  FCVT_D_H_INX,
  FCVT_D_L,
  FCVT_D_LU,
  FCVT_D_LU_INX,
  FCVT_D_L_INX,
  FCVT_D_Q,
  FCVT_D_S,
  FCVT_D_S_IN32X,
  FCVT_D_S_INX,
  FCVT_D_W,
  FCVT_D_WU,
  FCVT_D_WU_IN32X,
  FCVT_D_WU_INX,
  FCVT_D_W_IN32X,
  FCVT_D_W_INX,
  FCVT_H_D,
  FCVT_H_D_IN32X,
  FCVT_H_D_INX,
  FCVT_H_L,
  FCVT_H_LU,
  FCVT_H_LU_INX,
  FCVT_H_L_INX,
  FCVT_H_S,
  FCVT_H_S_INX,
  FCVT_H_W,
  FCVT_H_WU,
  FCVT_H_WU_INX,
  FCVT_H_W_INX,
  FCVT_LU_D,
  FCVT_LU_D_INX,
  FCVT_LU_H,
  FCVT_LU_H_INX,
  FCVT_LU_Q,
  FCVT_LU_S,
  FCVT_LU_S_INX,
  FCVT_L_D,
  FCVT_L_D_INX,
  FCVT_L_H,
  FCVT_L_H_INX,
  FCVT_L_Q,
  FCVT_L_S,
  FCVT_L_S_INX,
  FCVT_Q_D,
  FCVT_Q_L,
  FCVT_Q_LU,
  FCVT_Q_S,
  FCVT_Q_W,
  FCVT_Q_WU,
  FCVT_S_BF16,
  FCVT_S_D,
  FCVT_S_D_IN32X,
  FCVT_S_D_INX,
  FCVT_S_H,
  FCVT_S_H_INX,
  FCVT_S_L,
  FCVT_S_LU,
  FCVT_S_LU_INX,
  FCVT_S_L_INX,
  FCVT_S_Q,
  FCVT_S_W,
  FCVT_S_WU,
  FCVT_S_WU_INX,
  FCVT_S_W_INX,
  FCVT_WU_D,
  FCVT_WU_D_IN32X,
  FCVT_WU_D_INX,
  FCVT_WU_H,
  FCVT_WU_H_INX,
  FCVT_WU_Q,
  FCVT_WU_S,
  FCVT_WU_S_INX,
  FCVT_W_D,
  FCVT_W_D_IN32X,
  FCVT_W_D_INX,
  FCVT_W_H,
  FCVT_W_H_INX,
  FCVT_W_Q,
  FCVT_W_S,
  FCVT_W_S_INX,
  FDIV_D,
  FDIV_D_IN32X,
  FDIV_D_INX,
  FDIV_H,
  FDIV_H_INX,
  FDIV_Q,
  FDIV_S,
  FDIV_S_INX,
  FENCE,
  FENCE_I,
  FENCE_TSO,
  FEQ_D,
  FEQ_D_IN32X,
  FEQ_D_INX,
  FEQ_H,
  FEQ_H_INX,
  FEQ_Q,
  FEQ_S,
  FEQ_S_INX,
  FLD,
  FLEQ_D,
  FLEQ_H,
  FLEQ_Q,
  FLEQ_S,
  FLE_D,
  FLE_D_IN32X,
  FLE_D_INX,
  FLE_H,
  FLE_H_INX,
  FLE_Q,
  FLE_S,
  FLE_S_INX,
  FLH,
  FLI_D,
  FLI_H,
  FLI_Q,
  FLI_S,
  FLQ,
  FLTQ_D,
  FLTQ_H,
  FLTQ_Q,
  FLTQ_S,
  FLT_D,
  FLT_D_IN32X,
  FLT_D_INX,
  FLT_H,
  FLT_H_INX,
  FLT_Q,
  FLT_S,
  FLT_S_INX,
  FLW,
  FMADD_D,
  FMADD_D_IN32X,
  FMADD_D_INX,
  FMADD_H,
  FMADD_H_INX,
  FMADD_Q,
  FMADD_S,
  FMADD_S_INX,
  FMAXM_D,
  FMAXM_H,
  FMAXM_Q,
  FMAXM_S,
  FMAX_D,
  FMAX_D_IN32X,
  FMAX_D_INX,
  FMAX_H,
  FMAX_H_INX,
  FMAX_Q,
  FMAX_S,
  FMAX_S_INX,
  FMINM_D,
  FMINM_H,
  FMINM_Q,
  FMINM_S,
  FMIN_D,
  FMIN_D_IN32X,
  FMIN_D_INX,
  FMIN_H,
  FMIN_H_INX,
  FMIN_Q,
  FMIN_S,
  FMIN_S_INX,
  FMSUB_D,
  FMSUB_D_IN32X,
  FMSUB_D_INX,
  FMSUB_H,
  FMSUB_H_INX,
  FMSUB_Q,
  FMSUB_S,
  FMSUB_S_INX,
  FMUL_D,
  FMUL_D_IN32X,
  FMUL_D_INX,
  FMUL_H,
  FMUL_H_INX,
  FMUL_Q,
  FMUL_S,
  FMUL_S_INX,
  FMVH_X_D,
  FMVH_X_Q,
  FMVP_D_X,
  FMVP_Q_X,
  FMV_D_X,
  FMV_H_X,
  FMV_W_X,
  FMV_X_D,
  FMV_X_H,
  FMV_X_W,
  FMV_X_W_FPR64,
  FNMADD_D,
  FNMADD_D_IN32X,
  FNMADD_D_INX,
  FNMADD_H,
  FNMADD_H_INX,
  FNMADD_Q,
  FNMADD_S,
  FNMADD_S_INX,
  FNMSUB_D,
  FNMSUB_D_IN32X,
  FNMSUB_D_INX,
  FNMSUB_H,
  FNMSUB_H_INX,
  FNMSUB_Q,
  FNMSUB_S,
  FNMSUB_S_INX,
  FROUNDNX_D,
  FROUNDNX_H,
  FROUNDNX_Q,
  FROUNDNX_S,
  FROUND_D,
  FROUND_H,
  FROUND_Q,
  FROUND_S,
  FSD,
  FSGNJN_D,
  FSGNJN_D_IN32X,
  FSGNJN_D_INX,
  FSGNJN_H,
  FSGNJN_H_INX,
  FSGNJN_Q,
  FSGNJN_S,
  FSGNJN_S_INX,
  FSGNJX_D,
  FSGNJX_D_IN32X,
  FSGNJX_D_INX,
  FSGNJX_H,
  FSGNJX_H_INX,
  FSGNJX_Q,
  FSGNJX_S,
  FSGNJX_S_INX,
  FSGNJ_D,
  FSGNJ_D_IN32X,
  FSGNJ_D_INX,
  FSGNJ_H,
  FSGNJ_H_INX,
  FSGNJ_Q,
  FSGNJ_S,
  FSGNJ_S_INX,
  FSH,
  FSQ,
  FSQRT_D,
  FSQRT_D_IN32X,
  FSQRT_D_INX,
  FSQRT_H,
  FSQRT_H_INX,
  FSQRT_Q,
  FSQRT_S,
  FSQRT_S_INX,
  FSUB_D,
  FSUB_D_IN32X,
  FSUB_D_INX,
  FSUB_H,
  FSUB_H_INX,
  FSUB_Q,
  FSUB_S,
  FSUB_S_INX,
  FSW,
  HFENCE_GVMA,
  HFENCE_VVMA,
  HINVAL_GVMA,
  HINVAL_VVMA,
  HLVX_HU,
  HLVX_WU,
  HLV_B,
  HLV_BU,
  HLV_D,
  HLV_H,
  HLV_HU,
  HLV_W,
  HLV_WU,
  HSV_B,
  HSV_D,
  HSV_H,
  HSV_W,
  Insn16,
  Insn32,
  Insn48,
  Insn64,
  InsnB,
  InsnCA,
  InsnCB,
  InsnCI,
  InsnCIW,
  InsnCJ,
  InsnCL,
  InsnCR,
  InsnCS,
  InsnCSS,
  InsnI,
  InsnI_Mem,
  InsnJ,
  InsnQC_EAI,
  InsnQC_EB,
  InsnQC_EI,
  InsnQC_EI_Mem,
  InsnQC_EJ,
  InsnQC_ES,
  InsnR,
  InsnR4,
  InsnS,
  InsnU,
  JAL,
  JALR,
  LB,
  LBU,
  LB_AQ,
  LB_AQ_RL,
  LD,
  LD_AQ,
  LD_AQ_RL,
  LD_RV32,
  LH,
  LHU,
  LH_AQ,
  LH_AQ_RL,
  LH_INX,
  LR_D,
  LR_D_AQ,
  LR_D_AQ_RL,
  LR_D_RL,
  LR_W,
  LR_W_AQ,
  LR_W_AQ_RL,
  LR_W_RL,
  LUI,
  LW,
  LWU,
  LW_AQ,
  LW_AQ_RL,
  LW_INX,
  MAX,
  MAXU,
  MIN,
  MINU,
  MIPS_CCMOV,
  MIPS_LDP,
  MIPS_LWP,
  MIPS_PREFETCH,
  MIPS_SDP,
  MIPS_SWP,
  MNRET,
  MOPR0,
  MOPR1,
  MOPR10,
  MOPR11,
  MOPR12,
  MOPR13,
  MOPR14,
  MOPR15,
  MOPR16,
  MOPR17,
  MOPR18,
  MOPR19,
  MOPR2,
  MOPR20,
  MOPR21,
  MOPR22,
  MOPR23,
  MOPR24,
  MOPR25,
  MOPR26,
  MOPR27,
  MOPR28,
  MOPR29,
  MOPR3,
  MOPR30,
  MOPR31,
  MOPR4,
  MOPR5,
  MOPR6,
  MOPR7,
  MOPR8,
  MOPR9,
  MOPRR0,
  MOPRR1,
  MOPRR2,
  MOPRR3,
  MOPRR4,
  MOPRR5,
  MOPRR6,
  MOPRR7,
  MRET,
  MUL,
  MULH,
  MULHSU,
  MULHU,
  MULW,
  NDS_ADDIGP,
  NDS_BBC,
  NDS_BBS,
  NDS_BEQC,
  NDS_BFOS,
  NDS_BFOZ,
  NDS_BNEC,
  NDS_FCVT_BF16_S,
  NDS_FCVT_S_BF16,
  NDS_FFB,
  NDS_FFMISM,
  NDS_FFZMISM,
  NDS_FLMISM,
  NDS_LBGP,
  NDS_LBUGP,
  NDS_LDGP,
  NDS_LEA_B_ZE,
  NDS_LEA_D,
  NDS_LEA_D_ZE,
  NDS_LEA_H,
  NDS_LEA_H_ZE,
  NDS_LEA_W,
  NDS_LEA_W_ZE,
  NDS_LHGP,
  NDS_LHUGP,
  NDS_LWGP,
  NDS_LWUGP,
  NDS_SBGP,
  NDS_SDGP,
  NDS_SHGP,
  NDS_SWGP,
  NDS_VD4DOTSU_VV,
  NDS_VD4DOTS_VV,
  NDS_VD4DOTU_VV,
  NDS_VFNCVT_BF16_S,
  NDS_VFPMADB_VF,
  NDS_VFPMADT_VF,
  NDS_VFWCVT_S_BF16,
  NDS_VLN8_V,
  NDS_VLNU8_V,
  OR,
  ORC_B,
  ORI,
  ORN,
  PACK,
  PACKH,
  PACKW,
  PLI_B,
  PLI_H,
  PLI_W,
  PLUI_H,
  PLUI_W,
  PREFETCH_I,
  PREFETCH_R,
  PREFETCH_W,
  PSABS_B,
  PSABS_H,
  PSEXT_H_B,
  PSEXT_W_B,
  PSEXT_W_H,
  PSLLI_B,
  PSLLI_H,
  PSLLI_W,
  PSSLAI_H,
  PSSLAI_W,
  QC_ADDSAT,
  QC_ADDUSAT,
  QC_BEQI,
  QC_BGEI,
  QC_BGEUI,
  QC_BLTI,
  QC_BLTUI,
  QC_BNEI,
  QC_BREV32,
  QC_CLO,
  QC_CLRINTI,
  QC_CM_MVA01S,
  QC_CM_MVSA01,
  QC_CM_POP,
  QC_CM_POPRET,
  QC_CM_POPRETZ,
  QC_CM_PUSH,
  QC_CM_PUSHFP,
  QC_COMPRESS2,
  QC_COMPRESS3,
  QC_CSRRWR,
  QC_CSRRWRI,
  QC_CTO,
  QC_C_BEXTI,
  QC_C_BSETI,
  QC_C_CLRINT,
  QC_C_DELAY,
  QC_C_DI,
  QC_C_DIR,
  QC_C_EI,
  QC_C_EIR,
  QC_C_EXTU,
  QC_C_MIENTER,
  QC_C_MIENTER_NEST,
  QC_C_MILEAVERET,
  QC_C_MNRET,
  QC_C_MRET,
  QC_C_MULIADD,
  QC_C_MVEQZ,
  QC_C_PTRACE,
  QC_C_SETINT,
  QC_C_SYNC,
  QC_C_SYNCR,
  QC_C_SYNCWF,
  QC_C_SYNCWL,
  QC_EXPAND2,
  QC_EXPAND3,
  QC_EXT,
  QC_EXTD,
  QC_EXTDPR,
  QC_EXTDPRH,
  QC_EXTDR,
  QC_EXTDU,
  QC_EXTDUPR,
  QC_EXTDUPRH,
  QC_EXTDUR,
  QC_EXTU,
  QC_E_ADDAI,
  QC_E_ADDI,
  QC_E_ANDAI,
  QC_E_ANDI,
  QC_E_BEQI,
  QC_E_BGEI,
  QC_E_BGEUI,
  QC_E_BLTI,
  QC_E_BLTUI,
  QC_E_BNEI,
  QC_E_J,
  QC_E_JAL,
  QC_E_LB,
  QC_E_LBU,
  QC_E_LH,
  QC_E_LHU,
  QC_E_LI,
  QC_E_LW,
  QC_E_ORAI,
  QC_E_ORI,
  QC_E_SB,
  QC_E_SH,
  QC_E_SW,
  QC_E_XORAI,
  QC_E_XORI,
  QC_INSB,
  QC_INSBH,
  QC_INSBHR,
  QC_INSBI,
  QC_INSBPR,
  QC_INSBPRH,
  QC_INSBR,
  QC_INSBRI,
  QC_INW,
  QC_LI,
  QC_LIEQ,
  QC_LIEQI,
  QC_LIGE,
  QC_LIGEI,
  QC_LIGEU,
  QC_LIGEUI,
  QC_LILT,
  QC_LILTI,
  QC_LILTU,
  QC_LILTUI,
  QC_LINE,
  QC_LINEI,
  QC_LRB,
  QC_LRBU,
  QC_LRH,
  QC_LRHU,
  QC_LRW,
  QC_LWM,
  QC_LWMI,
  QC_MULIADD,
  QC_MVEQ,
  QC_MVEQI,
  QC_MVGE,
  QC_MVGEI,
  QC_MVGEU,
  QC_MVGEUI,
  QC_MVLT,
  QC_MVLTI,
  QC_MVLTU,
  QC_MVLTUI,
  QC_MVNE,
  QC_MVNEI,
  QC_NORM,
  QC_NORMEU,
  QC_NORMU,
  QC_OUTW,
  QC_PCOREDUMP,
  QC_PEXIT,
  QC_PPREG,
  QC_PPREGS,
  QC_PPUTC,
  QC_PPUTCI,
  QC_PPUTS,
  QC_PSYSCALL,
  QC_PSYSCALLI,
  QC_SELECTEQI,
  QC_SELECTIEQ,
  QC_SELECTIEQI,
  QC_SELECTIIEQ,
  QC_SELECTIINE,
  QC_SELECTINE,
  QC_SELECTINEI,
  QC_SELECTNEI,
  QC_SETINTI,
  QC_SETWM,
  QC_SETWMI,
  QC_SHLADD,
  QC_SHLSAT,
  QC_SHLUSAT,
  QC_SRB,
  QC_SRH,
  QC_SRW,
  QC_SUBSAT,
  QC_SUBUSAT,
  QC_SWM,
  QC_SWMI,
  QC_SYNC,
  QC_SYNCR,
  QC_SYNCWF,
  QC_SYNCWL,
  QC_WRAP,
  QC_WRAPI,
  QK_C_LBU,
  QK_C_LBUSP,
  QK_C_LHU,
  QK_C_LHUSP,
  QK_C_SB,
  QK_C_SBSP,
  QK_C_SH,
  QK_C_SHSP,
  REM,
  REMU,
  REMUW,
  REMW,
  REV16,
  REV8_RV32,
  REV8_RV64,
  REV_RV32,
  REV_RV64,
  RI_VEXTRACT,
  RI_VINSERT,
  RI_VUNZIP2A_VV,
  RI_VUNZIP2B_VV,
  RI_VZERO,
  RI_VZIP2A_VV,
  RI_VZIP2B_VV,
  RI_VZIPEVEN_VV,
  RI_VZIPODD_VV,
  ROL,
  ROLW,
  ROR,
  RORI,
  RORIW,
  RORW,
  SB,
  SB_AQ_RL,
  SB_RL,
  SCTRCLR,
  SC_D,
  SC_D_AQ,
  SC_D_AQ_RL,
  SC_D_RL,
  SC_W,
  SC_W_AQ,
  SC_W_AQ_RL,
  SC_W_RL,
  SD,
  SD_AQ_RL,
  SD_RL,
  SD_RV32,
  SEXT_B,
  SEXT_H,
  SFENCE_INVAL_IR,
  SFENCE_VMA,
  SFENCE_W_INVAL,
  SF_CDISCARD_D_L1,
  SF_CEASE,
  SF_CFLUSH_D_L1,
  SF_MM_E4M3_E4M3,
  SF_MM_E4M3_E5M2,
  SF_MM_E5M2_E4M3,
  SF_MM_E5M2_E5M2,
  SF_MM_F_F,
  SF_MM_S_S,
  SF_MM_S_U,
  SF_MM_U_S,
  SF_MM_U_U,
  SF_VC_FV,
  SF_VC_FVV,
  SF_VC_FVW,
  SF_VC_I,
  SF_VC_IV,
  SF_VC_IVV,
  SF_VC_IVW,
  SF_VC_VV,
  SF_VC_VVV,
  SF_VC_VVW,
  SF_VC_V_FV,
  SF_VC_V_FVV,
  SF_VC_V_FVW,
  SF_VC_V_I,
  SF_VC_V_IV,
  SF_VC_V_IVV,
  SF_VC_V_IVW,
  SF_VC_V_VV,
  SF_VC_V_VVV,
  SF_VC_V_VVW,
  SF_VC_V_X,
  SF_VC_V_XV,
  SF_VC_V_XVV,
  SF_VC_V_XVW,
  SF_VC_X,
  SF_VC_XV,
  SF_VC_XVV,
  SF_VC_XVW,
  SF_VFNRCLIP_XU_F_QF,
  SF_VFNRCLIP_X_F_QF,
  SF_VFWMACC_4x4x4,
  SF_VLTE16,
  SF_VLTE32,
  SF_VLTE64,
  SF_VLTE8,
  SF_VQMACCSU_2x8x2,
  SF_VQMACCSU_4x8x4,
  SF_VQMACCUS_2x8x2,
  SF_VQMACCUS_4x8x4,
  SF_VQMACCU_2x8x2,
  SF_VQMACCU_4x8x4,
  SF_VQMACC_2x8x2,
  SF_VQMACC_4x8x4,
  SF_VSETTK,
  SF_VSETTM,
  SF_VSETTN,
  SF_VSTE16,
  SF_VSTE32,
  SF_VSTE64,
  SF_VSTE8,
  SF_VTDISCARD,
  SF_VTMV_T_V,
  SF_VTMV_V_T,
  SF_VTZERO_T,
  SH,
  SH1ADD,
  SH1ADD_UW,
  SH2ADD,
  SH2ADD_UW,
  SH3ADD,
  SH3ADD_UW,
  SHA256SIG0,
  SHA256SIG1,
  SHA256SUM0,
  SHA256SUM1,
  SHA512SIG0,
  SHA512SIG0H,
  SHA512SIG0L,
  SHA512SIG1,
  SHA512SIG1H,
  SHA512SIG1L,
  SHA512SUM0,
  SHA512SUM0R,
  SHA512SUM1,
  SHA512SUM1R,
  SH_AQ_RL,
  SH_INX,
  SH_RL,
  SINVAL_VMA,
  SLL,
  SLLI,
  SLLIW,
  SLLI_UW,
  SLLW,
  SLT,
  SLTI,
  SLTIU,
  SLTU,
  SM3P0,
  SM3P1,
  SM4ED,
  SM4KS,
  SRA,
  SRAI,
  SRAIW,
  SRAW,
  SRET,
  SRL,
  SRLI,
  SRLIW,
  SRLW,
  SSAMOSWAP_D,
  SSAMOSWAP_D_AQ,
  SSAMOSWAP_D_AQ_RL,
  SSAMOSWAP_D_RL,
  SSAMOSWAP_W,
  SSAMOSWAP_W_AQ,
  SSAMOSWAP_W_AQ_RL,
  SSAMOSWAP_W_RL,
  SSLAI,
  SSPOPCHK,
  SSPUSH,
  SSRDP,
  SUB,
  SUBW,
  SW,
  SW_AQ_RL,
  SW_INX,
  SW_RL,
  TH_ADDSL,
  TH_DCACHE_CALL,
  TH_DCACHE_CIALL,
  TH_DCACHE_CIPA,
  TH_DCACHE_CISW,
  TH_DCACHE_CIVA,
  TH_DCACHE_CPA,
  TH_DCACHE_CPAL1,
  TH_DCACHE_CSW,
  TH_DCACHE_CVA,
  TH_DCACHE_CVAL1,
  TH_DCACHE_IALL,
  TH_DCACHE_IPA,
  TH_DCACHE_ISW,
  TH_DCACHE_IVA,
  TH_EXT,
  TH_EXTU,
  TH_FF0,
  TH_FF1,
  TH_FLRD,
  TH_FLRW,
  TH_FLURD,
  TH_FLURW,
  TH_FSRD,
  TH_FSRW,
  TH_FSURD,
  TH_FSURW,
  TH_ICACHE_IALL,
  TH_ICACHE_IALLS,
  TH_ICACHE_IPA,
  TH_ICACHE_IVA,
  TH_L2CACHE_CALL,
  TH_L2CACHE_CIALL,
  TH_L2CACHE_IALL,
  TH_LBIA,
  TH_LBIB,
  TH_LBUIA,
  TH_LBUIB,
  TH_LDD,
  TH_LDIA,
  TH_LDIB,
  TH_LHIA,
  TH_LHIB,
  TH_LHUIA,
  TH_LHUIB,
  TH_LRB,
  TH_LRBU,
  TH_LRD,
  TH_LRH,
  TH_LRHU,
  TH_LRW,
  TH_LRWU,
  TH_LURB,
  TH_LURBU,
  TH_LURD,
  TH_LURH,
  TH_LURHU,
  TH_LURW,
  TH_LURWU,
  TH_LWD,
  TH_LWIA,
  TH_LWIB,
  TH_LWUD,
  TH_LWUIA,
  TH_LWUIB,
  TH_MULA,
  TH_MULAH,
  TH_MULAW,
  TH_MULS,
  TH_MULSH,
  TH_MULSW,
  TH_MVEQZ,
  TH_MVNEZ,
  TH_REV,
  TH_REVW,
  TH_SBIA,
  TH_SBIB,
  TH_SDD,
  TH_SDIA,
  TH_SDIB,
  TH_SFENCE_VMAS,
  TH_SHIA,
  TH_SHIB,
  TH_SRB,
  TH_SRD,
  TH_SRH,
  TH_SRRI,
  TH_SRRIW,
  TH_SRW,
  TH_SURB,
  TH_SURD,
  TH_SURH,
  TH_SURW,
  TH_SWD,
  TH_SWIA,
  TH_SWIB,
  TH_SYNC,
  TH_SYNC_I,
  TH_SYNC_IS,
  TH_SYNC_S,
  TH_TST,
  TH_TSTNBZ,
  TH_VMAQASU_VV,
  TH_VMAQASU_VX,
  TH_VMAQAUS_VX,
  TH_VMAQAU_VV,
  TH_VMAQAU_VX,
  TH_VMAQA_VV,
  TH_VMAQA_VX,
  UNIMP,
  UNZIP_RV32,
  VAADDU_VV,
  VAADDU_VX,
  VAADD_VV,
  VAADD_VX,
  VADC_VIM,
  VADC_VVM,
  VADC_VXM,
  VADD_VI,
  VADD_VV,
  VADD_VX,
  VAESDF_VS,
  VAESDF_VV,
  VAESDM_VS,
  VAESDM_VV,
  VAESEF_VS,
  VAESEF_VV,
  VAESEM_VS,
  VAESEM_VV,
  VAESKF1_VI,
  VAESKF2_VI,
  VAESZ_VS,
  VANDN_VV,
  VANDN_VX,
  VAND_VI,
  VAND_VV,
  VAND_VX,
  VASUBU_VV,
  VASUBU_VX,
  VASUB_VV,
  VASUB_VX,
  VBREV8_V,
  VBREV_V,
  VCLMULH_VV,
  VCLMULH_VX,
  VCLMUL_VV,
  VCLMUL_VX,
  VCLZ_V,
  VCOMPRESS_VM,
  VCPOP_M,
  VCPOP_V,
  VCTZ_V,
  VDIVU_VV,
  VDIVU_VX,
  VDIV_VV,
  VDIV_VX,
  VFADD_VF,
  VFADD_VV,
  VFCLASS_V,
  VFCVT_F_XU_V,
  VFCVT_F_X_V,
  VFCVT_RTZ_XU_F_V,
  VFCVT_RTZ_X_F_V,
  VFCVT_XU_F_V,
  VFCVT_X_F_V,
  VFDIV_VF,
  VFDIV_VV,
  VFIRST_M,
  VFMACC_VF,
  VFMACC_VV,
  VFMADD_VF,
  VFMADD_VV,
  VFMAX_VF,
  VFMAX_VV,
  VFMERGE_VFM,
  VFMIN_VF,
  VFMIN_VV,
  VFMSAC_VF,
  VFMSAC_VV,
  VFMSUB_VF,
  VFMSUB_VV,
  VFMUL_VF,
  VFMUL_VV,
  VFMV_F_S,
  VFMV_S_F,
  VFMV_V_F,
  VFNCVTBF16_F_F_W,
  VFNCVT_F_F_W,
  VFNCVT_F_XU_W,
  VFNCVT_F_X_W,
  VFNCVT_ROD_F_F_W,
  VFNCVT_RTZ_XU_F_W,
  VFNCVT_RTZ_X_F_W,
  VFNCVT_XU_F_W,
  VFNCVT_X_F_W,
  VFNMACC_VF,
  VFNMACC_VV,
  VFNMADD_VF,
  VFNMADD_VV,
  VFNMSAC_VF,
  VFNMSAC_VV,
  VFNMSUB_VF,
  VFNMSUB_VV,
  VFRDIV_VF,
  VFREC7_V,
  VFREDMAX_VS,
  VFREDMIN_VS,
  VFREDOSUM_VS,
  VFREDUSUM_VS,
  VFRSQRT7_V,
  VFRSUB_VF,
  VFSGNJN_VF,
  VFSGNJN_VV,
  VFSGNJX_VF,
  VFSGNJX_VV,
  VFSGNJ_VF,
  VFSGNJ_VV,
  VFSLIDE1DOWN_VF,
  VFSLIDE1UP_VF,
  VFSQRT_V,
  VFSUB_VF,
  VFSUB_VV,
  VFWADD_VF,
  VFWADD_VV,
  VFWADD_WF,
  VFWADD_WV,
  VFWCVTBF16_F_F_V,
  VFWCVT_F_F_V,
  VFWCVT_F_XU_V,
  VFWCVT_F_X_V,
  VFWCVT_RTZ_XU_F_V,
  VFWCVT_RTZ_X_F_V,
  VFWCVT_XU_F_V,
  VFWCVT_X_F_V,
  VFWMACCBF16_VF,
  VFWMACCBF16_VV,
  VFWMACC_VF,
  VFWMACC_VV,
  VFWMSAC_VF,
  VFWMSAC_VV,
  VFWMUL_VF,
  VFWMUL_VV,
  VFWNMACC_VF,
  VFWNMACC_VV,
  VFWNMSAC_VF,
  VFWNMSAC_VV,
  VFWREDOSUM_VS,
  VFWREDUSUM_VS,
  VFWSUB_VF,
  VFWSUB_VV,
  VFWSUB_WF,
  VFWSUB_WV,
  VGHSH_VS,
  VGHSH_VV,
  VGMUL_VS,
  VGMUL_VV,
  VID_V,
  VIOTA_M,
  VL1RE16_V,
  VL1RE32_V,
  VL1RE64_V,
  VL1RE8_V,
  VL2RE16_V,
  VL2RE32_V,
  VL2RE64_V,
  VL2RE8_V,
  VL4RE16_V,
  VL4RE32_V,
  VL4RE64_V,
  VL4RE8_V,
  VL8RE16_V,
  VL8RE32_V,
  VL8RE64_V,
  VL8RE8_V,
  VLE16FF_V,
  VLE16_V,
  VLE32FF_V,
  VLE32_V,
  VLE64FF_V,
  VLE64_V,
  VLE8FF_V,
  VLE8_V,
  VLM_V,
  VLOXEI16_V,
  VLOXEI32_V,
  VLOXEI64_V,
  VLOXEI8_V,
  VLOXSEG2EI16_V,
  VLOXSEG2EI32_V,
  VLOXSEG2EI64_V,
  VLOXSEG2EI8_V,
  VLOXSEG3EI16_V,
  VLOXSEG3EI32_V,
  VLOXSEG3EI64_V,
  VLOXSEG3EI8_V,
  VLOXSEG4EI16_V,
  VLOXSEG4EI32_V,
  VLOXSEG4EI64_V,
  VLOXSEG4EI8_V,
  VLOXSEG5EI16_V,
  VLOXSEG5EI32_V,
  VLOXSEG5EI64_V,
  VLOXSEG5EI8_V,
  VLOXSEG6EI16_V,
  VLOXSEG6EI32_V,
  VLOXSEG6EI64_V,
  VLOXSEG6EI8_V,
  VLOXSEG7EI16_V,
  VLOXSEG7EI32_V,
  VLOXSEG7EI64_V,
  VLOXSEG7EI8_V,
  VLOXSEG8EI16_V,
  VLOXSEG8EI32_V,
  VLOXSEG8EI64_V,
  VLOXSEG8EI8_V,
  VLSE16_V,
  VLSE32_V,
  VLSE64_V,
  VLSE8_V,
  VLSEG2E16FF_V,
  VLSEG2E16_V,
  VLSEG2E32FF_V,
  VLSEG2E32_V,
  VLSEG2E64FF_V,
  VLSEG2E64_V,
  VLSEG2E8FF_V,
  VLSEG2E8_V,
  VLSEG3E16FF_V,
  VLSEG3E16_V,
  VLSEG3E32FF_V,
  VLSEG3E32_V,
  VLSEG3E64FF_V,
  VLSEG3E64_V,
  VLSEG3E8FF_V,
  VLSEG3E8_V,
  VLSEG4E16FF_V,
  VLSEG4E16_V,
  VLSEG4E32FF_V,
  VLSEG4E32_V,
  VLSEG4E64FF_V,
  VLSEG4E64_V,
  VLSEG4E8FF_V,
  VLSEG4E8_V,
  VLSEG5E16FF_V,
  VLSEG5E16_V,
  VLSEG5E32FF_V,
  VLSEG5E32_V,
  VLSEG5E64FF_V,
  VLSEG5E64_V,
  VLSEG5E8FF_V,
  VLSEG5E8_V,
  VLSEG6E16FF_V,
  VLSEG6E16_V,
  VLSEG6E32FF_V,
  VLSEG6E32_V,
  VLSEG6E64FF_V,
  VLSEG6E64_V,
  VLSEG6E8FF_V,
  VLSEG6E8_V,
  VLSEG7E16FF_V,
  VLSEG7E16_V,
  VLSEG7E32FF_V,
  VLSEG7E32_V,
  VLSEG7E64FF_V,
  VLSEG7E64_V,
  VLSEG7E8FF_V,
  VLSEG7E8_V,
  VLSEG8E16FF_V,
  VLSEG8E16_V,
  VLSEG8E32FF_V,
  VLSEG8E32_V,
  VLSEG8E64FF_V,
  VLSEG8E64_V,
  VLSEG8E8FF_V,
  VLSEG8E8_V,
  VLSSEG2E16_V,
  VLSSEG2E32_V,
  VLSSEG2E64_V,
  VLSSEG2E8_V,
  VLSSEG3E16_V,
  VLSSEG3E32_V,
  VLSSEG3E64_V,
  VLSSEG3E8_V,
  VLSSEG4E16_V,
  VLSSEG4E32_V,
  VLSSEG4E64_V,
  VLSSEG4E8_V,
  VLSSEG5E16_V,
  VLSSEG5E32_V,
  VLSSEG5E64_V,
  VLSSEG5E8_V,
  VLSSEG6E16_V,
  VLSSEG6E32_V,
  VLSSEG6E64_V,
  VLSSEG6E8_V,
  VLSSEG7E16_V,
  VLSSEG7E32_V,
  VLSSEG7E64_V,
  VLSSEG7E8_V,
  VLSSEG8E16_V,
  VLSSEG8E32_V,
  VLSSEG8E64_V,
  VLSSEG8E8_V,
  VLUXEI16_V,
  VLUXEI32_V,
  VLUXEI64_V,
  VLUXEI8_V,
  VLUXSEG2EI16_V,
  VLUXSEG2EI32_V,
  VLUXSEG2EI64_V,
  VLUXSEG2EI8_V,
  VLUXSEG3EI16_V,
  VLUXSEG3EI32_V,
  VLUXSEG3EI64_V,
  VLUXSEG3EI8_V,
  VLUXSEG4EI16_V,
  VLUXSEG4EI32_V,
  VLUXSEG4EI64_V,
  VLUXSEG4EI8_V,
  VLUXSEG5EI16_V,
  VLUXSEG5EI32_V,
  VLUXSEG5EI64_V,
  VLUXSEG5EI8_V,
  VLUXSEG6EI16_V,
  VLUXSEG6EI32_V,
  VLUXSEG6EI64_V,
  VLUXSEG6EI8_V,
  VLUXSEG7EI16_V,
  VLUXSEG7EI32_V,
  VLUXSEG7EI64_V,
  VLUXSEG7EI8_V,
  VLUXSEG8EI16_V,
  VLUXSEG8EI32_V,
  VLUXSEG8EI64_V,
  VLUXSEG8EI8_V,
  VMACC_VV,
  VMACC_VX,
  VMADC_VI,
  VMADC_VIM,
  VMADC_VV,
  VMADC_VVM,
  VMADC_VX,
  VMADC_VXM,
  VMADD_VV,
  VMADD_VX,
  VMANDN_MM,
  VMAND_MM,
  VMAXU_VV,
  VMAXU_VX,
  VMAX_VV,
  VMAX_VX,
  VMERGE_VIM,
  VMERGE_VVM,
  VMERGE_VXM,
  VMFEQ_VF,
  VMFEQ_VV,
  VMFGE_VF,
  VMFGT_VF,
  VMFLE_VF,
  VMFLE_VV,
  VMFLT_VF,
  VMFLT_VV,
  VMFNE_VF,
  VMFNE_VV,
  VMINU_VV,
  VMINU_VX,
  VMIN_VV,
  VMIN_VX,
  VMNAND_MM,
  VMNOR_MM,
  VMORN_MM,
  VMOR_MM,
  VMSBC_VV,
  VMSBC_VVM,
  VMSBC_VX,
  VMSBC_VXM,
  VMSBF_M,
  VMSEQ_VI,
  VMSEQ_VV,
  VMSEQ_VX,
  VMSGTU_VI,
  VMSGTU_VX,
  VMSGT_VI,
  VMSGT_VX,
  VMSIF_M,
  VMSLEU_VI,
  VMSLEU_VV,
  VMSLEU_VX,
  VMSLE_VI,
  VMSLE_VV,
  VMSLE_VX,
  VMSLTU_VV,
  VMSLTU_VX,
  VMSLT_VV,
  VMSLT_VX,
  VMSNE_VI,
  VMSNE_VV,
  VMSNE_VX,
  VMSOF_M,
  VMULHSU_VV,
  VMULHSU_VX,
  VMULHU_VV,
  VMULHU_VX,
  VMULH_VV,
  VMULH_VX,
  VMUL_VV,
  VMUL_VX,
  VMV1R_V,
  VMV2R_V,
  VMV4R_V,
  VMV8R_V,
  VMV_S_X,
  VMV_V_I,
  VMV_V_V,
  VMV_V_X,
  VMV_X_S,
  VMXNOR_MM,
  VMXOR_MM,
  VNCLIPU_WI,
  VNCLIPU_WV,
  VNCLIPU_WX,
  VNCLIP_WI,
  VNCLIP_WV,
  VNCLIP_WX,
  VNMSAC_VV,
  VNMSAC_VX,
  VNMSUB_VV,
  VNMSUB_VX,
  VNSRA_WI,
  VNSRA_WV,
  VNSRA_WX,
  VNSRL_WI,
  VNSRL_WV,
  VNSRL_WX,
  VOR_VI,
  VOR_VV,
  VOR_VX,
  VQDOTSU_VV,
  VQDOTSU_VX,
  VQDOTUS_VX,
  VQDOTU_VV,
  VQDOTU_VX,
  VQDOT_VV,
  VQDOT_VX,
  VREDAND_VS,
  VREDMAXU_VS,
  VREDMAX_VS,
  VREDMINU_VS,
  VREDMIN_VS,
  VREDOR_VS,
  VREDSUM_VS,
  VREDXOR_VS,
  VREMU_VV,
  VREMU_VX,
  VREM_VV,
  VREM_VX,
  VREV8_V,
  VRGATHEREI16_VV,
  VRGATHER_VI,
  VRGATHER_VV,
  VRGATHER_VX,
  VROL_VV,
  VROL_VX,
  VROR_VI,
  VROR_VV,
  VROR_VX,
  VRSUB_VI,
  VRSUB_VX,
  VS1R_V,
  VS2R_V,
  VS4R_V,
  VS8R_V,
  VSADDU_VI,
  VSADDU_VV,
  VSADDU_VX,
  VSADD_VI,
  VSADD_VV,
  VSADD_VX,
  VSBC_VVM,
  VSBC_VXM,
  VSE16_V,
  VSE32_V,
  VSE64_V,
  VSE8_V,
  VSETIVLI,
  VSETVL,
  VSETVLI,
  VSEXT_VF2,
  VSEXT_VF4,
  VSEXT_VF8,
  VSHA2CH_VV,
  VSHA2CL_VV,
  VSHA2MS_VV,
  VSLIDE1DOWN_VX,
  VSLIDE1UP_VX,
  VSLIDEDOWN_VI,
  VSLIDEDOWN_VX,
  VSLIDEUP_VI,
  VSLIDEUP_VX,
  VSLL_VI,
  VSLL_VV,
  VSLL_VX,
  VSM3C_VI,
  VSM3ME_VV,
  VSM4K_VI,
  VSM4R_VS,
  VSM4R_VV,
  VSMUL_VV,
  VSMUL_VX,
  VSM_V,
  VSOXEI16_V,
  VSOXEI32_V,
  VSOXEI64_V,
  VSOXEI8_V,
  VSOXSEG2EI16_V,
  VSOXSEG2EI32_V,
  VSOXSEG2EI64_V,
  VSOXSEG2EI8_V,
  VSOXSEG3EI16_V,
  VSOXSEG3EI32_V,
  VSOXSEG3EI64_V,
  VSOXSEG3EI8_V,
  VSOXSEG4EI16_V,
  VSOXSEG4EI32_V,
  VSOXSEG4EI64_V,
  VSOXSEG4EI8_V,
  VSOXSEG5EI16_V,
  VSOXSEG5EI32_V,
  VSOXSEG5EI64_V,
  VSOXSEG5EI8_V,
  VSOXSEG6EI16_V,
  VSOXSEG6EI32_V,
  VSOXSEG6EI64_V,
  VSOXSEG6EI8_V,
  VSOXSEG7EI16_V,
  VSOXSEG7EI32_V,
  VSOXSEG7EI64_V,
  VSOXSEG7EI8_V,
  VSOXSEG8EI16_V,
  VSOXSEG8EI32_V,
  VSOXSEG8EI64_V,
  VSOXSEG8EI8_V,
  VSRA_VI,
  VSRA_VV,
  VSRA_VX,
  VSRL_VI,
  VSRL_VV,
  VSRL_VX,
  VSSE16_V,
  VSSE32_V,
  VSSE64_V,
  VSSE8_V,
  VSSEG2E16_V,
  VSSEG2E32_V,
  VSSEG2E64_V,
  VSSEG2E8_V,
  VSSEG3E16_V,
  VSSEG3E32_V,
  VSSEG3E64_V,
  VSSEG3E8_V,
  VSSEG4E16_V,
  VSSEG4E32_V,
  VSSEG4E64_V,
  VSSEG4E8_V,
  VSSEG5E16_V,
  VSSEG5E32_V,
  VSSEG5E64_V,
  VSSEG5E8_V,
  VSSEG6E16_V,
  VSSEG6E32_V,
  VSSEG6E64_V,
  VSSEG6E8_V,
  VSSEG7E16_V,
  VSSEG7E32_V,
  VSSEG7E64_V,
  VSSEG7E8_V,
  VSSEG8E16_V,
  VSSEG8E32_V,
  VSSEG8E64_V,
  VSSEG8E8_V,
  VSSRA_VI,
  VSSRA_VV,
  VSSRA_VX,
  VSSRL_VI,
  VSSRL_VV,
  VSSRL_VX,
  VSSSEG2E16_V,
  VSSSEG2E32_V,
  VSSSEG2E64_V,
  VSSSEG2E8_V,
  VSSSEG3E16_V,
  VSSSEG3E32_V,
  VSSSEG3E64_V,
  VSSSEG3E8_V,
  VSSSEG4E16_V,
  VSSSEG4E32_V,
  VSSSEG4E64_V,
  VSSSEG4E8_V,
  VSSSEG5E16_V,
  VSSSEG5E32_V,
  VSSSEG5E64_V,
  VSSSEG5E8_V,
  VSSSEG6E16_V,
  VSSSEG6E32_V,
  VSSSEG6E64_V,
  VSSSEG6E8_V,
  VSSSEG7E16_V,
  VSSSEG7E32_V,
  VSSSEG7E64_V,
  VSSSEG7E8_V,
  VSSSEG8E16_V,
  VSSSEG8E32_V,
  VSSSEG8E64_V,
  VSSSEG8E8_V,
  VSSUBU_VV,
  VSSUBU_VX,
  VSSUB_VV,
  VSSUB_VX,
  VSUB_VV,
  VSUB_VX,
  VSUXEI16_V,
  VSUXEI32_V,
  VSUXEI64_V,
  VSUXEI8_V,
  VSUXSEG2EI16_V,
  VSUXSEG2EI32_V,
  VSUXSEG2EI64_V,
  VSUXSEG2EI8_V,
  VSUXSEG3EI16_V,
  VSUXSEG3EI32_V,
  VSUXSEG3EI64_V,
  VSUXSEG3EI8_V,
  VSUXSEG4EI16_V,
  VSUXSEG4EI32_V,
  VSUXSEG4EI64_V,
  VSUXSEG4EI8_V,
  VSUXSEG5EI16_V,
  VSUXSEG5EI32_V,
  VSUXSEG5EI64_V,
  VSUXSEG5EI8_V,
  VSUXSEG6EI16_V,
  VSUXSEG6EI32_V,
  VSUXSEG6EI64_V,
  VSUXSEG6EI8_V,
  VSUXSEG7EI16_V,
  VSUXSEG7EI32_V,
  VSUXSEG7EI64_V,
  VSUXSEG7EI8_V,
  VSUXSEG8EI16_V,
  VSUXSEG8EI32_V,
  VSUXSEG8EI64_V,
  VSUXSEG8EI8_V,
  VT_MASKC,
  VT_MASKCN,
  VWADDU_VV,
  VWADDU_VX,
  VWADDU_WV,
  VWADDU_WX,
  VWADD_VV,
  VWADD_VX,
  VWADD_WV,
  VWADD_WX,
  VWMACCSU_VV,
  VWMACCSU_VX,
  VWMACCUS_VX,
  VWMACCU_VV,
  VWMACCU_VX,
  VWMACC_VV,
  VWMACC_VX,
  VWMULSU_VV,
  VWMULSU_VX,
  VWMULU_VV,
  VWMULU_VX,
  VWMUL_VV,
  VWMUL_VX,
  VWREDSUMU_VS,
  VWREDSUM_VS,
  VWSLL_VI,
  VWSLL_VV,
  VWSLL_VX,
  VWSUBU_VV,
  VWSUBU_VX,
  VWSUBU_WV,
  VWSUBU_WX,
  VWSUB_VV,
  VWSUB_VX,
  VWSUB_WV,
  VWSUB_WX,
  VXOR_VI,
  VXOR_VV,
  VXOR_VX,
  VZEXT_VF2,
  VZEXT_VF4,
  VZEXT_VF8,
  WFI,
  WRS_NTO,
  WRS_STO,
  XNOR,
  XOR,
  XORI,
  XPERM4,
  XPERM8,
  ZEXT_H_RV32,
  ZEXT_H_RV64,
  ZIP_RV32,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::INIT_UNDEF,
          12 => Opcode::SUBREG_TO_REG,
          13 => Opcode::COPY_TO_REGCLASS,
          14 => Opcode::DBG_VALUE,
          15 => Opcode::DBG_VALUE_LIST,
          16 => Opcode::DBG_INSTR_REF,
          17 => Opcode::DBG_PHI,
          18 => Opcode::DBG_LABEL,
          19 => Opcode::REG_SEQUENCE,
          20 => Opcode::COPY,
          21 => Opcode::BUNDLE,
          22 => Opcode::LIFETIME_START,
          23 => Opcode::LIFETIME_END,
          24 => Opcode::PSEUDO_PROBE,
          25 => Opcode::ARITH_FENCE,
          26 => Opcode::STACKMAP,
          27 => Opcode::FENTRY_CALL,
          28 => Opcode::PATCHPOINT,
          29 => Opcode::LOAD_STACK_GUARD,
          30 => Opcode::PREALLOCATED_SETUP,
          31 => Opcode::PREALLOCATED_ARG,
          32 => Opcode::STATEPOINT,
          33 => Opcode::LOCAL_ESCAPE,
          34 => Opcode::FAULTING_OP,
          35 => Opcode::PATCHABLE_OP,
          36 => Opcode::PATCHABLE_FUNCTION_ENTER,
          37 => Opcode::PATCHABLE_RET,
          38 => Opcode::PATCHABLE_FUNCTION_EXIT,
          39 => Opcode::PATCHABLE_TAIL_CALL,
          40 => Opcode::PATCHABLE_EVENT_CALL,
          41 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          42 => Opcode::ICALL_BRANCH_FUNNEL,
          43 => Opcode::FAKE_USE,
          44 => Opcode::MEMBARRIER,
          45 => Opcode::JUMP_TABLE_DEBUG_INFO,
          46 => Opcode::CONVERGENCECTRL_ENTRY,
          47 => Opcode::CONVERGENCECTRL_ANCHOR,
          48 => Opcode::CONVERGENCECTRL_LOOP,
          49 => Opcode::CONVERGENCECTRL_GLUE,
          50 => Opcode::G_ASSERT_SEXT,
          51 => Opcode::G_ASSERT_ZEXT,
          52 => Opcode::G_ASSERT_ALIGN,
          53 => Opcode::G_ADD,
          54 => Opcode::G_SUB,
          55 => Opcode::G_MUL,
          56 => Opcode::G_SDIV,
          57 => Opcode::G_UDIV,
          58 => Opcode::G_SREM,
          59 => Opcode::G_UREM,
          60 => Opcode::G_SDIVREM,
          61 => Opcode::G_UDIVREM,
          62 => Opcode::G_AND,
          63 => Opcode::G_OR,
          64 => Opcode::G_XOR,
          65 => Opcode::G_ABDS,
          66 => Opcode::G_ABDU,
          67 => Opcode::G_IMPLICIT_DEF,
          68 => Opcode::G_PHI,
          69 => Opcode::G_FRAME_INDEX,
          70 => Opcode::G_GLOBAL_VALUE,
          71 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          72 => Opcode::G_CONSTANT_POOL,
          73 => Opcode::G_EXTRACT,
          74 => Opcode::G_UNMERGE_VALUES,
          75 => Opcode::G_INSERT,
          76 => Opcode::G_MERGE_VALUES,
          77 => Opcode::G_BUILD_VECTOR,
          78 => Opcode::G_BUILD_VECTOR_TRUNC,
          79 => Opcode::G_CONCAT_VECTORS,
          80 => Opcode::G_PTRTOINT,
          81 => Opcode::G_INTTOPTR,
          82 => Opcode::G_BITCAST,
          83 => Opcode::G_FREEZE,
          84 => Opcode::G_CONSTANT_FOLD_BARRIER,
          85 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          86 => Opcode::G_INTRINSIC_TRUNC,
          87 => Opcode::G_INTRINSIC_ROUND,
          88 => Opcode::G_INTRINSIC_LRINT,
          89 => Opcode::G_INTRINSIC_LLRINT,
          90 => Opcode::G_INTRINSIC_ROUNDEVEN,
          91 => Opcode::G_READCYCLECOUNTER,
          92 => Opcode::G_READSTEADYCOUNTER,
          93 => Opcode::G_LOAD,
          94 => Opcode::G_SEXTLOAD,
          95 => Opcode::G_ZEXTLOAD,
          96 => Opcode::G_INDEXED_LOAD,
          97 => Opcode::G_INDEXED_SEXTLOAD,
          98 => Opcode::G_INDEXED_ZEXTLOAD,
          99 => Opcode::G_STORE,
          100 => Opcode::G_INDEXED_STORE,
          101 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          102 => Opcode::G_ATOMIC_CMPXCHG,
          103 => Opcode::G_ATOMICRMW_XCHG,
          104 => Opcode::G_ATOMICRMW_ADD,
          105 => Opcode::G_ATOMICRMW_SUB,
          106 => Opcode::G_ATOMICRMW_AND,
          107 => Opcode::G_ATOMICRMW_NAND,
          108 => Opcode::G_ATOMICRMW_OR,
          109 => Opcode::G_ATOMICRMW_XOR,
          110 => Opcode::G_ATOMICRMW_MAX,
          111 => Opcode::G_ATOMICRMW_MIN,
          112 => Opcode::G_ATOMICRMW_UMAX,
          113 => Opcode::G_ATOMICRMW_UMIN,
          114 => Opcode::G_ATOMICRMW_FADD,
          115 => Opcode::G_ATOMICRMW_FSUB,
          116 => Opcode::G_ATOMICRMW_FMAX,
          117 => Opcode::G_ATOMICRMW_FMIN,
          118 => Opcode::G_ATOMICRMW_FMAXIMUM,
          119 => Opcode::G_ATOMICRMW_FMINIMUM,
          120 => Opcode::G_ATOMICRMW_UINC_WRAP,
          121 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          122 => Opcode::G_ATOMICRMW_USUB_COND,
          123 => Opcode::G_ATOMICRMW_USUB_SAT,
          124 => Opcode::G_FENCE,
          125 => Opcode::G_PREFETCH,
          126 => Opcode::G_BRCOND,
          127 => Opcode::G_BRINDIRECT,
          128 => Opcode::G_INVOKE_REGION_START,
          129 => Opcode::G_INTRINSIC,
          130 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          131 => Opcode::G_INTRINSIC_CONVERGENT,
          132 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          133 => Opcode::G_ANYEXT,
          134 => Opcode::G_TRUNC,
          135 => Opcode::G_TRUNC_SSAT_S,
          136 => Opcode::G_TRUNC_SSAT_U,
          137 => Opcode::G_TRUNC_USAT_U,
          138 => Opcode::G_CONSTANT,
          139 => Opcode::G_FCONSTANT,
          140 => Opcode::G_VASTART,
          141 => Opcode::G_VAARG,
          142 => Opcode::G_SEXT,
          143 => Opcode::G_SEXT_INREG,
          144 => Opcode::G_ZEXT,
          145 => Opcode::G_SHL,
          146 => Opcode::G_LSHR,
          147 => Opcode::G_ASHR,
          148 => Opcode::G_FSHL,
          149 => Opcode::G_FSHR,
          150 => Opcode::G_ROTR,
          151 => Opcode::G_ROTL,
          152 => Opcode::G_ICMP,
          153 => Opcode::G_FCMP,
          154 => Opcode::G_SCMP,
          155 => Opcode::G_UCMP,
          156 => Opcode::G_SELECT,
          157 => Opcode::G_UADDO,
          158 => Opcode::G_UADDE,
          159 => Opcode::G_USUBO,
          160 => Opcode::G_USUBE,
          161 => Opcode::G_SADDO,
          162 => Opcode::G_SADDE,
          163 => Opcode::G_SSUBO,
          164 => Opcode::G_SSUBE,
          165 => Opcode::G_UMULO,
          166 => Opcode::G_SMULO,
          167 => Opcode::G_UMULH,
          168 => Opcode::G_SMULH,
          169 => Opcode::G_UADDSAT,
          170 => Opcode::G_SADDSAT,
          171 => Opcode::G_USUBSAT,
          172 => Opcode::G_SSUBSAT,
          173 => Opcode::G_USHLSAT,
          174 => Opcode::G_SSHLSAT,
          175 => Opcode::G_SMULFIX,
          176 => Opcode::G_UMULFIX,
          177 => Opcode::G_SMULFIXSAT,
          178 => Opcode::G_UMULFIXSAT,
          179 => Opcode::G_SDIVFIX,
          180 => Opcode::G_UDIVFIX,
          181 => Opcode::G_SDIVFIXSAT,
          182 => Opcode::G_UDIVFIXSAT,
          183 => Opcode::G_FADD,
          184 => Opcode::G_FSUB,
          185 => Opcode::G_FMUL,
          186 => Opcode::G_FMA,
          187 => Opcode::G_FMAD,
          188 => Opcode::G_FDIV,
          189 => Opcode::G_FREM,
          190 => Opcode::G_FPOW,
          191 => Opcode::G_FPOWI,
          192 => Opcode::G_FEXP,
          193 => Opcode::G_FEXP2,
          194 => Opcode::G_FEXP10,
          195 => Opcode::G_FLOG,
          196 => Opcode::G_FLOG2,
          197 => Opcode::G_FLOG10,
          198 => Opcode::G_FLDEXP,
          199 => Opcode::G_FFREXP,
          200 => Opcode::G_FNEG,
          201 => Opcode::G_FPEXT,
          202 => Opcode::G_FPTRUNC,
          203 => Opcode::G_FPTOSI,
          204 => Opcode::G_FPTOUI,
          205 => Opcode::G_SITOFP,
          206 => Opcode::G_UITOFP,
          207 => Opcode::G_FPTOSI_SAT,
          208 => Opcode::G_FPTOUI_SAT,
          209 => Opcode::G_FABS,
          210 => Opcode::G_FCOPYSIGN,
          211 => Opcode::G_IS_FPCLASS,
          212 => Opcode::G_FCANONICALIZE,
          213 => Opcode::G_FMINNUM,
          214 => Opcode::G_FMAXNUM,
          215 => Opcode::G_FMINNUM_IEEE,
          216 => Opcode::G_FMAXNUM_IEEE,
          217 => Opcode::G_FMINIMUM,
          218 => Opcode::G_FMAXIMUM,
          219 => Opcode::G_FMINIMUMNUM,
          220 => Opcode::G_FMAXIMUMNUM,
          221 => Opcode::G_GET_FPENV,
          222 => Opcode::G_SET_FPENV,
          223 => Opcode::G_RESET_FPENV,
          224 => Opcode::G_GET_FPMODE,
          225 => Opcode::G_SET_FPMODE,
          226 => Opcode::G_RESET_FPMODE,
          227 => Opcode::G_GET_ROUNDING,
          228 => Opcode::G_PTR_ADD,
          229 => Opcode::G_PTRMASK,
          230 => Opcode::G_SMIN,
          231 => Opcode::G_SMAX,
          232 => Opcode::G_UMIN,
          233 => Opcode::G_UMAX,
          234 => Opcode::G_ABS,
          235 => Opcode::G_LROUND,
          236 => Opcode::G_LLROUND,
          237 => Opcode::G_BR,
          238 => Opcode::G_BRJT,
          239 => Opcode::G_VSCALE,
          240 => Opcode::G_INSERT_SUBVECTOR,
          241 => Opcode::G_EXTRACT_SUBVECTOR,
          242 => Opcode::G_INSERT_VECTOR_ELT,
          243 => Opcode::G_EXTRACT_VECTOR_ELT,
          244 => Opcode::G_SHUFFLE_VECTOR,
          245 => Opcode::G_SPLAT_VECTOR,
          246 => Opcode::G_STEP_VECTOR,
          247 => Opcode::G_VECTOR_COMPRESS,
          248 => Opcode::G_CTTZ,
          249 => Opcode::G_CTTZ_ZERO_UNDEF,
          250 => Opcode::G_CTLZ,
          251 => Opcode::G_CTLZ_ZERO_UNDEF,
          252 => Opcode::G_CTPOP,
          253 => Opcode::G_BSWAP,
          254 => Opcode::G_BITREVERSE,
          255 => Opcode::G_FCEIL,
          256 => Opcode::G_FCOS,
          257 => Opcode::G_FSIN,
          258 => Opcode::G_FSINCOS,
          259 => Opcode::G_FTAN,
          260 => Opcode::G_FACOS,
          261 => Opcode::G_FASIN,
          262 => Opcode::G_FATAN,
          263 => Opcode::G_FATAN2,
          264 => Opcode::G_FCOSH,
          265 => Opcode::G_FSINH,
          266 => Opcode::G_FTANH,
          267 => Opcode::G_FSQRT,
          268 => Opcode::G_FFLOOR,
          269 => Opcode::G_FRINT,
          270 => Opcode::G_FNEARBYINT,
          271 => Opcode::G_ADDRSPACE_CAST,
          272 => Opcode::G_BLOCK_ADDR,
          273 => Opcode::G_JUMP_TABLE,
          274 => Opcode::G_DYN_STACKALLOC,
          275 => Opcode::G_STACKSAVE,
          276 => Opcode::G_STACKRESTORE,
          277 => Opcode::G_STRICT_FADD,
          278 => Opcode::G_STRICT_FSUB,
          279 => Opcode::G_STRICT_FMUL,
          280 => Opcode::G_STRICT_FDIV,
          281 => Opcode::G_STRICT_FREM,
          282 => Opcode::G_STRICT_FMA,
          283 => Opcode::G_STRICT_FSQRT,
          284 => Opcode::G_STRICT_FLDEXP,
          285 => Opcode::G_READ_REGISTER,
          286 => Opcode::G_WRITE_REGISTER,
          287 => Opcode::G_MEMCPY,
          288 => Opcode::G_MEMCPY_INLINE,
          289 => Opcode::G_MEMMOVE,
          290 => Opcode::G_MEMSET,
          291 => Opcode::G_BZERO,
          292 => Opcode::G_TRAP,
          293 => Opcode::G_DEBUGTRAP,
          294 => Opcode::G_UBSANTRAP,
          295 => Opcode::G_VECREDUCE_SEQ_FADD,
          296 => Opcode::G_VECREDUCE_SEQ_FMUL,
          297 => Opcode::G_VECREDUCE_FADD,
          298 => Opcode::G_VECREDUCE_FMUL,
          299 => Opcode::G_VECREDUCE_FMAX,
          300 => Opcode::G_VECREDUCE_FMIN,
          301 => Opcode::G_VECREDUCE_FMAXIMUM,
          302 => Opcode::G_VECREDUCE_FMINIMUM,
          303 => Opcode::G_VECREDUCE_ADD,
          304 => Opcode::G_VECREDUCE_MUL,
          305 => Opcode::G_VECREDUCE_AND,
          306 => Opcode::G_VECREDUCE_OR,
          307 => Opcode::G_VECREDUCE_XOR,
          308 => Opcode::G_VECREDUCE_SMAX,
          309 => Opcode::G_VECREDUCE_SMIN,
          310 => Opcode::G_VECREDUCE_UMAX,
          311 => Opcode::G_VECREDUCE_UMIN,
          312 => Opcode::G_SBFX,
          313 => Opcode::G_UBFX,
          314 => Opcode::ADJCALLSTACKDOWN,
          315 => Opcode::ADJCALLSTACKUP,
          316 => Opcode::BuildPairF64Pseudo,
          317 => Opcode::G_CLZW,
          318 => Opcode::G_CTZW,
          319 => Opcode::G_DIVUW,
          320 => Opcode::G_DIVW,
          321 => Opcode::G_FCLASS,
          322 => Opcode::G_FCVT_WU_RV64,
          323 => Opcode::G_FCVT_W_RV64,
          324 => Opcode::G_READ_VLENB,
          325 => Opcode::G_REMUW,
          326 => Opcode::G_ROLW,
          327 => Opcode::G_RORW,
          328 => Opcode::G_SLLW,
          329 => Opcode::G_SPLAT_VECTOR_SPLIT_I64_VL,
          330 => Opcode::G_SRAW,
          331 => Opcode::G_SRLW,
          332 => Opcode::G_VMCLR_VL,
          333 => Opcode::G_VMSET_VL,
          334 => Opcode::G_VMV_V_V_VL,
          335 => Opcode::G_VSLIDEDOWN_VL,
          336 => Opcode::G_VSLIDEUP_VL,
          337 => Opcode::HWASAN_CHECK_MEMACCESS_SHORTGRANULES,
          338 => Opcode::KCFI_CHECK,
          339 => Opcode::PROBED_STACKALLOC,
          340 => Opcode::PROBED_STACKALLOC_DYN,
          341 => Opcode::PROBED_STACKALLOC_RVV,
          342 => Opcode::PseudoAddTPRel,
          343 => Opcode::PseudoAtomicLoadNand32,
          344 => Opcode::PseudoAtomicLoadNand64,
          345 => Opcode::PseudoBR,
          346 => Opcode::PseudoBRIND,
          347 => Opcode::PseudoBRINDNonX7,
          348 => Opcode::PseudoBRINDX7,
          349 => Opcode::PseudoCALL,
          350 => Opcode::PseudoCALLIndirect,
          351 => Opcode::PseudoCALLIndirectNonX7,
          352 => Opcode::PseudoCALLIndirectX7,
          353 => Opcode::PseudoCALLReg,
          354 => Opcode::PseudoCCADD,
          355 => Opcode::PseudoCCADDI,
          356 => Opcode::PseudoCCADDIW,
          357 => Opcode::PseudoCCADDW,
          358 => Opcode::PseudoCCAND,
          359 => Opcode::PseudoCCANDI,
          360 => Opcode::PseudoCCANDN,
          361 => Opcode::PseudoCCMOVGPR,
          362 => Opcode::PseudoCCMOVGPRNoX0,
          363 => Opcode::PseudoCCNDS_BFOS,
          364 => Opcode::PseudoCCNDS_BFOZ,
          365 => Opcode::PseudoCCOR,
          366 => Opcode::PseudoCCORI,
          367 => Opcode::PseudoCCORN,
          368 => Opcode::PseudoCCSLL,
          369 => Opcode::PseudoCCSLLI,
          370 => Opcode::PseudoCCSLLIW,
          371 => Opcode::PseudoCCSLLW,
          372 => Opcode::PseudoCCSRA,
          373 => Opcode::PseudoCCSRAI,
          374 => Opcode::PseudoCCSRAIW,
          375 => Opcode::PseudoCCSRAW,
          376 => Opcode::PseudoCCSRL,
          377 => Opcode::PseudoCCSRLI,
          378 => Opcode::PseudoCCSRLIW,
          379 => Opcode::PseudoCCSRLW,
          380 => Opcode::PseudoCCSUB,
          381 => Opcode::PseudoCCSUBW,
          382 => Opcode::PseudoCCXNOR,
          383 => Opcode::PseudoCCXOR,
          384 => Opcode::PseudoCCXORI,
          385 => Opcode::PseudoC_ADDI_NOP,
          386 => Opcode::PseudoCmpXchg32,
          387 => Opcode::PseudoCmpXchg64,
          388 => Opcode::PseudoFLD,
          389 => Opcode::PseudoFLH,
          390 => Opcode::PseudoFLQ,
          391 => Opcode::PseudoFLW,
          392 => Opcode::PseudoFROUND_D,
          393 => Opcode::PseudoFROUND_D_IN32X,
          394 => Opcode::PseudoFROUND_D_INX,
          395 => Opcode::PseudoFROUND_H,
          396 => Opcode::PseudoFROUND_H_INX,
          397 => Opcode::PseudoFROUND_S,
          398 => Opcode::PseudoFROUND_S_INX,
          399 => Opcode::PseudoFSD,
          400 => Opcode::PseudoFSH,
          401 => Opcode::PseudoFSQ,
          402 => Opcode::PseudoFSW,
          403 => Opcode::PseudoJump,
          404 => Opcode::PseudoLA,
          405 => Opcode::PseudoLAImm,
          406 => Opcode::PseudoLA_TLSDESC,
          407 => Opcode::PseudoLA_TLS_GD,
          408 => Opcode::PseudoLA_TLS_IE,
          409 => Opcode::PseudoLB,
          410 => Opcode::PseudoLBU,
          411 => Opcode::PseudoLD,
          412 => Opcode::PseudoLD_RV32,
          413 => Opcode::PseudoLGA,
          414 => Opcode::PseudoLH,
          415 => Opcode::PseudoLHU,
          416 => Opcode::PseudoLI,
          417 => Opcode::PseudoLLA,
          418 => Opcode::PseudoLLAImm,
          419 => Opcode::PseudoLW,
          420 => Opcode::PseudoLWU,
          421 => Opcode::PseudoLongBEQ,
          422 => Opcode::PseudoLongBGE,
          423 => Opcode::PseudoLongBGEU,
          424 => Opcode::PseudoLongBLT,
          425 => Opcode::PseudoLongBLTU,
          426 => Opcode::PseudoLongBNE,
          427 => Opcode::PseudoLongQC_BEQI,
          428 => Opcode::PseudoLongQC_BGEI,
          429 => Opcode::PseudoLongQC_BGEUI,
          430 => Opcode::PseudoLongQC_BLTI,
          431 => Opcode::PseudoLongQC_BLTUI,
          432 => Opcode::PseudoLongQC_BNEI,
          433 => Opcode::PseudoLongQC_E_BEQI,
          434 => Opcode::PseudoLongQC_E_BGEI,
          435 => Opcode::PseudoLongQC_E_BGEUI,
          436 => Opcode::PseudoLongQC_E_BLTI,
          437 => Opcode::PseudoLongQC_E_BLTUI,
          438 => Opcode::PseudoLongQC_E_BNEI,
          439 => Opcode::PseudoMV_FPR16INX,
          440 => Opcode::PseudoMV_FPR32INX,
          441 => Opcode::PseudoMaskedAtomicLoadAdd32,
          442 => Opcode::PseudoMaskedAtomicLoadMax32,
          443 => Opcode::PseudoMaskedAtomicLoadMin32,
          444 => Opcode::PseudoMaskedAtomicLoadNand32,
          445 => Opcode::PseudoMaskedAtomicLoadSub32,
          446 => Opcode::PseudoMaskedAtomicLoadUMax32,
          447 => Opcode::PseudoMaskedAtomicLoadUMin32,
          448 => Opcode::PseudoMaskedAtomicSwap32,
          449 => Opcode::PseudoMaskedCmpXchg32,
          450 => Opcode::PseudoMovAddr,
          451 => Opcode::PseudoMovImm,
          452 => Opcode::PseudoNDS_VD4DOTSU_VV_M1,
          453 => Opcode::PseudoNDS_VD4DOTSU_VV_M1_MASK,
          454 => Opcode::PseudoNDS_VD4DOTSU_VV_M2,
          455 => Opcode::PseudoNDS_VD4DOTSU_VV_M2_MASK,
          456 => Opcode::PseudoNDS_VD4DOTSU_VV_M4,
          457 => Opcode::PseudoNDS_VD4DOTSU_VV_M4_MASK,
          458 => Opcode::PseudoNDS_VD4DOTSU_VV_M8,
          459 => Opcode::PseudoNDS_VD4DOTSU_VV_M8_MASK,
          460 => Opcode::PseudoNDS_VD4DOTSU_VV_MF2,
          461 => Opcode::PseudoNDS_VD4DOTSU_VV_MF2_MASK,
          462 => Opcode::PseudoNDS_VD4DOTS_VV_M1,
          463 => Opcode::PseudoNDS_VD4DOTS_VV_M1_MASK,
          464 => Opcode::PseudoNDS_VD4DOTS_VV_M2,
          465 => Opcode::PseudoNDS_VD4DOTS_VV_M2_MASK,
          466 => Opcode::PseudoNDS_VD4DOTS_VV_M4,
          467 => Opcode::PseudoNDS_VD4DOTS_VV_M4_MASK,
          468 => Opcode::PseudoNDS_VD4DOTS_VV_M8,
          469 => Opcode::PseudoNDS_VD4DOTS_VV_M8_MASK,
          470 => Opcode::PseudoNDS_VD4DOTS_VV_MF2,
          471 => Opcode::PseudoNDS_VD4DOTS_VV_MF2_MASK,
          472 => Opcode::PseudoNDS_VD4DOTU_VV_M1,
          473 => Opcode::PseudoNDS_VD4DOTU_VV_M1_MASK,
          474 => Opcode::PseudoNDS_VD4DOTU_VV_M2,
          475 => Opcode::PseudoNDS_VD4DOTU_VV_M2_MASK,
          476 => Opcode::PseudoNDS_VD4DOTU_VV_M4,
          477 => Opcode::PseudoNDS_VD4DOTU_VV_M4_MASK,
          478 => Opcode::PseudoNDS_VD4DOTU_VV_M8,
          479 => Opcode::PseudoNDS_VD4DOTU_VV_M8_MASK,
          480 => Opcode::PseudoNDS_VD4DOTU_VV_MF2,
          481 => Opcode::PseudoNDS_VD4DOTU_VV_MF2_MASK,
          482 => Opcode::PseudoNDS_VFNCVT_BF16_S_M1,
          483 => Opcode::PseudoNDS_VFNCVT_BF16_S_M2,
          484 => Opcode::PseudoNDS_VFNCVT_BF16_S_M4,
          485 => Opcode::PseudoNDS_VFNCVT_BF16_S_MF2,
          486 => Opcode::PseudoNDS_VFNCVT_BF16_S_MF4,
          487 => Opcode::PseudoNDS_VFPMADB_VFPR16_M1,
          488 => Opcode::PseudoNDS_VFPMADB_VFPR16_M1_MASK,
          489 => Opcode::PseudoNDS_VFPMADB_VFPR16_M2,
          490 => Opcode::PseudoNDS_VFPMADB_VFPR16_M2_MASK,
          491 => Opcode::PseudoNDS_VFPMADB_VFPR16_M4,
          492 => Opcode::PseudoNDS_VFPMADB_VFPR16_M4_MASK,
          493 => Opcode::PseudoNDS_VFPMADB_VFPR16_M8,
          494 => Opcode::PseudoNDS_VFPMADB_VFPR16_M8_MASK,
          495 => Opcode::PseudoNDS_VFPMADB_VFPR16_MF2,
          496 => Opcode::PseudoNDS_VFPMADB_VFPR16_MF2_MASK,
          497 => Opcode::PseudoNDS_VFPMADB_VFPR16_MF4,
          498 => Opcode::PseudoNDS_VFPMADB_VFPR16_MF4_MASK,
          499 => Opcode::PseudoNDS_VFPMADT_VFPR16_M1,
          500 => Opcode::PseudoNDS_VFPMADT_VFPR16_M1_MASK,
          501 => Opcode::PseudoNDS_VFPMADT_VFPR16_M2,
          502 => Opcode::PseudoNDS_VFPMADT_VFPR16_M2_MASK,
          503 => Opcode::PseudoNDS_VFPMADT_VFPR16_M4,
          504 => Opcode::PseudoNDS_VFPMADT_VFPR16_M4_MASK,
          505 => Opcode::PseudoNDS_VFPMADT_VFPR16_M8,
          506 => Opcode::PseudoNDS_VFPMADT_VFPR16_M8_MASK,
          507 => Opcode::PseudoNDS_VFPMADT_VFPR16_MF2,
          508 => Opcode::PseudoNDS_VFPMADT_VFPR16_MF2_MASK,
          509 => Opcode::PseudoNDS_VFPMADT_VFPR16_MF4,
          510 => Opcode::PseudoNDS_VFPMADT_VFPR16_MF4_MASK,
          511 => Opcode::PseudoNDS_VFWCVT_S_BF16_M1,
          512 => Opcode::PseudoNDS_VFWCVT_S_BF16_M2,
          513 => Opcode::PseudoNDS_VFWCVT_S_BF16_M4,
          514 => Opcode::PseudoNDS_VFWCVT_S_BF16_MF2,
          515 => Opcode::PseudoNDS_VFWCVT_S_BF16_MF4,
          516 => Opcode::PseudoNDS_VLN8_V_M1,
          517 => Opcode::PseudoNDS_VLN8_V_M1_MASK,
          518 => Opcode::PseudoNDS_VLN8_V_M2,
          519 => Opcode::PseudoNDS_VLN8_V_M2_MASK,
          520 => Opcode::PseudoNDS_VLN8_V_M4,
          521 => Opcode::PseudoNDS_VLN8_V_M4_MASK,
          522 => Opcode::PseudoNDS_VLN8_V_M8,
          523 => Opcode::PseudoNDS_VLN8_V_M8_MASK,
          524 => Opcode::PseudoNDS_VLN8_V_MF2,
          525 => Opcode::PseudoNDS_VLN8_V_MF2_MASK,
          526 => Opcode::PseudoNDS_VLN8_V_MF4,
          527 => Opcode::PseudoNDS_VLN8_V_MF4_MASK,
          528 => Opcode::PseudoNDS_VLN8_V_MF8,
          529 => Opcode::PseudoNDS_VLN8_V_MF8_MASK,
          530 => Opcode::PseudoNDS_VLNU8_V_M1,
          531 => Opcode::PseudoNDS_VLNU8_V_M1_MASK,
          532 => Opcode::PseudoNDS_VLNU8_V_M2,
          533 => Opcode::PseudoNDS_VLNU8_V_M2_MASK,
          534 => Opcode::PseudoNDS_VLNU8_V_M4,
          535 => Opcode::PseudoNDS_VLNU8_V_M4_MASK,
          536 => Opcode::PseudoNDS_VLNU8_V_M8,
          537 => Opcode::PseudoNDS_VLNU8_V_M8_MASK,
          538 => Opcode::PseudoNDS_VLNU8_V_MF2,
          539 => Opcode::PseudoNDS_VLNU8_V_MF2_MASK,
          540 => Opcode::PseudoNDS_VLNU8_V_MF4,
          541 => Opcode::PseudoNDS_VLNU8_V_MF4_MASK,
          542 => Opcode::PseudoNDS_VLNU8_V_MF8,
          543 => Opcode::PseudoNDS_VLNU8_V_MF8_MASK,
          544 => Opcode::PseudoQC_E_LB,
          545 => Opcode::PseudoQC_E_LBU,
          546 => Opcode::PseudoQC_E_LH,
          547 => Opcode::PseudoQC_E_LHU,
          548 => Opcode::PseudoQC_E_LW,
          549 => Opcode::PseudoQC_E_SB,
          550 => Opcode::PseudoQC_E_SH,
          551 => Opcode::PseudoQC_E_SW,
          552 => Opcode::PseudoQuietFLE_D,
          553 => Opcode::PseudoQuietFLE_D_IN32X,
          554 => Opcode::PseudoQuietFLE_D_INX,
          555 => Opcode::PseudoQuietFLE_H,
          556 => Opcode::PseudoQuietFLE_H_INX,
          557 => Opcode::PseudoQuietFLE_S,
          558 => Opcode::PseudoQuietFLE_S_INX,
          559 => Opcode::PseudoQuietFLT_D,
          560 => Opcode::PseudoQuietFLT_D_IN32X,
          561 => Opcode::PseudoQuietFLT_D_INX,
          562 => Opcode::PseudoQuietFLT_H,
          563 => Opcode::PseudoQuietFLT_H_INX,
          564 => Opcode::PseudoQuietFLT_S,
          565 => Opcode::PseudoQuietFLT_S_INX,
          566 => Opcode::PseudoRET,
          567 => Opcode::PseudoRI_VEXTRACT_M1,
          568 => Opcode::PseudoRI_VEXTRACT_M2,
          569 => Opcode::PseudoRI_VEXTRACT_M4,
          570 => Opcode::PseudoRI_VEXTRACT_M8,
          571 => Opcode::PseudoRI_VEXTRACT_MF2,
          572 => Opcode::PseudoRI_VEXTRACT_MF4,
          573 => Opcode::PseudoRI_VEXTRACT_MF8,
          574 => Opcode::PseudoRI_VINSERT_M1,
          575 => Opcode::PseudoRI_VINSERT_M2,
          576 => Opcode::PseudoRI_VINSERT_M4,
          577 => Opcode::PseudoRI_VINSERT_M8,
          578 => Opcode::PseudoRI_VINSERT_MF2,
          579 => Opcode::PseudoRI_VINSERT_MF4,
          580 => Opcode::PseudoRI_VINSERT_MF8,
          581 => Opcode::PseudoRI_VUNZIP2A_VV_M1,
          582 => Opcode::PseudoRI_VUNZIP2A_VV_M1_MASK,
          583 => Opcode::PseudoRI_VUNZIP2A_VV_M2,
          584 => Opcode::PseudoRI_VUNZIP2A_VV_M2_MASK,
          585 => Opcode::PseudoRI_VUNZIP2A_VV_M4,
          586 => Opcode::PseudoRI_VUNZIP2A_VV_M4_MASK,
          587 => Opcode::PseudoRI_VUNZIP2A_VV_M8,
          588 => Opcode::PseudoRI_VUNZIP2A_VV_M8_MASK,
          589 => Opcode::PseudoRI_VUNZIP2A_VV_MF2,
          590 => Opcode::PseudoRI_VUNZIP2A_VV_MF2_MASK,
          591 => Opcode::PseudoRI_VUNZIP2A_VV_MF4,
          592 => Opcode::PseudoRI_VUNZIP2A_VV_MF4_MASK,
          593 => Opcode::PseudoRI_VUNZIP2A_VV_MF8,
          594 => Opcode::PseudoRI_VUNZIP2A_VV_MF8_MASK,
          595 => Opcode::PseudoRI_VUNZIP2B_VV_M1,
          596 => Opcode::PseudoRI_VUNZIP2B_VV_M1_MASK,
          597 => Opcode::PseudoRI_VUNZIP2B_VV_M2,
          598 => Opcode::PseudoRI_VUNZIP2B_VV_M2_MASK,
          599 => Opcode::PseudoRI_VUNZIP2B_VV_M4,
          600 => Opcode::PseudoRI_VUNZIP2B_VV_M4_MASK,
          601 => Opcode::PseudoRI_VUNZIP2B_VV_M8,
          602 => Opcode::PseudoRI_VUNZIP2B_VV_M8_MASK,
          603 => Opcode::PseudoRI_VUNZIP2B_VV_MF2,
          604 => Opcode::PseudoRI_VUNZIP2B_VV_MF2_MASK,
          605 => Opcode::PseudoRI_VUNZIP2B_VV_MF4,
          606 => Opcode::PseudoRI_VUNZIP2B_VV_MF4_MASK,
          607 => Opcode::PseudoRI_VUNZIP2B_VV_MF8,
          608 => Opcode::PseudoRI_VUNZIP2B_VV_MF8_MASK,
          609 => Opcode::PseudoRI_VZIP2A_VV_M1,
          610 => Opcode::PseudoRI_VZIP2A_VV_M1_MASK,
          611 => Opcode::PseudoRI_VZIP2A_VV_M2,
          612 => Opcode::PseudoRI_VZIP2A_VV_M2_MASK,
          613 => Opcode::PseudoRI_VZIP2A_VV_M4,
          614 => Opcode::PseudoRI_VZIP2A_VV_M4_MASK,
          615 => Opcode::PseudoRI_VZIP2A_VV_M8,
          616 => Opcode::PseudoRI_VZIP2A_VV_M8_MASK,
          617 => Opcode::PseudoRI_VZIP2A_VV_MF2,
          618 => Opcode::PseudoRI_VZIP2A_VV_MF2_MASK,
          619 => Opcode::PseudoRI_VZIP2A_VV_MF4,
          620 => Opcode::PseudoRI_VZIP2A_VV_MF4_MASK,
          621 => Opcode::PseudoRI_VZIP2A_VV_MF8,
          622 => Opcode::PseudoRI_VZIP2A_VV_MF8_MASK,
          623 => Opcode::PseudoRI_VZIP2B_VV_M1,
          624 => Opcode::PseudoRI_VZIP2B_VV_M1_MASK,
          625 => Opcode::PseudoRI_VZIP2B_VV_M2,
          626 => Opcode::PseudoRI_VZIP2B_VV_M2_MASK,
          627 => Opcode::PseudoRI_VZIP2B_VV_M4,
          628 => Opcode::PseudoRI_VZIP2B_VV_M4_MASK,
          629 => Opcode::PseudoRI_VZIP2B_VV_M8,
          630 => Opcode::PseudoRI_VZIP2B_VV_M8_MASK,
          631 => Opcode::PseudoRI_VZIP2B_VV_MF2,
          632 => Opcode::PseudoRI_VZIP2B_VV_MF2_MASK,
          633 => Opcode::PseudoRI_VZIP2B_VV_MF4,
          634 => Opcode::PseudoRI_VZIP2B_VV_MF4_MASK,
          635 => Opcode::PseudoRI_VZIP2B_VV_MF8,
          636 => Opcode::PseudoRI_VZIP2B_VV_MF8_MASK,
          637 => Opcode::PseudoRI_VZIPEVEN_VV_M1,
          638 => Opcode::PseudoRI_VZIPEVEN_VV_M1_MASK,
          639 => Opcode::PseudoRI_VZIPEVEN_VV_M2,
          640 => Opcode::PseudoRI_VZIPEVEN_VV_M2_MASK,
          641 => Opcode::PseudoRI_VZIPEVEN_VV_M4,
          642 => Opcode::PseudoRI_VZIPEVEN_VV_M4_MASK,
          643 => Opcode::PseudoRI_VZIPEVEN_VV_M8,
          644 => Opcode::PseudoRI_VZIPEVEN_VV_M8_MASK,
          645 => Opcode::PseudoRI_VZIPEVEN_VV_MF2,
          646 => Opcode::PseudoRI_VZIPEVEN_VV_MF2_MASK,
          647 => Opcode::PseudoRI_VZIPEVEN_VV_MF4,
          648 => Opcode::PseudoRI_VZIPEVEN_VV_MF4_MASK,
          649 => Opcode::PseudoRI_VZIPEVEN_VV_MF8,
          650 => Opcode::PseudoRI_VZIPEVEN_VV_MF8_MASK,
          651 => Opcode::PseudoRI_VZIPODD_VV_M1,
          652 => Opcode::PseudoRI_VZIPODD_VV_M1_MASK,
          653 => Opcode::PseudoRI_VZIPODD_VV_M2,
          654 => Opcode::PseudoRI_VZIPODD_VV_M2_MASK,
          655 => Opcode::PseudoRI_VZIPODD_VV_M4,
          656 => Opcode::PseudoRI_VZIPODD_VV_M4_MASK,
          657 => Opcode::PseudoRI_VZIPODD_VV_M8,
          658 => Opcode::PseudoRI_VZIPODD_VV_M8_MASK,
          659 => Opcode::PseudoRI_VZIPODD_VV_MF2,
          660 => Opcode::PseudoRI_VZIPODD_VV_MF2_MASK,
          661 => Opcode::PseudoRI_VZIPODD_VV_MF4,
          662 => Opcode::PseudoRI_VZIPODD_VV_MF4_MASK,
          663 => Opcode::PseudoRI_VZIPODD_VV_MF8,
          664 => Opcode::PseudoRI_VZIPODD_VV_MF8_MASK,
          665 => Opcode::PseudoRV32ZdinxLD,
          666 => Opcode::PseudoRV32ZdinxSD,
          667 => Opcode::PseudoReadVL,
          668 => Opcode::PseudoReadVLENB,
          669 => Opcode::PseudoReadVLENBViaVSETVLIX0,
          670 => Opcode::PseudoSB,
          671 => Opcode::PseudoSD,
          672 => Opcode::PseudoSD_RV32,
          673 => Opcode::PseudoSEXT_B,
          674 => Opcode::PseudoSEXT_H,
          675 => Opcode::PseudoSF_VC_FPR16VV_SE_M1,
          676 => Opcode::PseudoSF_VC_FPR16VV_SE_M2,
          677 => Opcode::PseudoSF_VC_FPR16VV_SE_M4,
          678 => Opcode::PseudoSF_VC_FPR16VV_SE_M8,
          679 => Opcode::PseudoSF_VC_FPR16VV_SE_MF2,
          680 => Opcode::PseudoSF_VC_FPR16VV_SE_MF4,
          681 => Opcode::PseudoSF_VC_FPR16VW_SE_M1,
          682 => Opcode::PseudoSF_VC_FPR16VW_SE_M2,
          683 => Opcode::PseudoSF_VC_FPR16VW_SE_M4,
          684 => Opcode::PseudoSF_VC_FPR16VW_SE_M8,
          685 => Opcode::PseudoSF_VC_FPR16VW_SE_MF2,
          686 => Opcode::PseudoSF_VC_FPR16VW_SE_MF4,
          687 => Opcode::PseudoSF_VC_FPR16V_SE_M1,
          688 => Opcode::PseudoSF_VC_FPR16V_SE_M2,
          689 => Opcode::PseudoSF_VC_FPR16V_SE_M4,
          690 => Opcode::PseudoSF_VC_FPR16V_SE_M8,
          691 => Opcode::PseudoSF_VC_FPR16V_SE_MF2,
          692 => Opcode::PseudoSF_VC_FPR16V_SE_MF4,
          693 => Opcode::PseudoSF_VC_FPR32VV_SE_M1,
          694 => Opcode::PseudoSF_VC_FPR32VV_SE_M2,
          695 => Opcode::PseudoSF_VC_FPR32VV_SE_M4,
          696 => Opcode::PseudoSF_VC_FPR32VV_SE_M8,
          697 => Opcode::PseudoSF_VC_FPR32VV_SE_MF2,
          698 => Opcode::PseudoSF_VC_FPR32VW_SE_M1,
          699 => Opcode::PseudoSF_VC_FPR32VW_SE_M2,
          700 => Opcode::PseudoSF_VC_FPR32VW_SE_M4,
          701 => Opcode::PseudoSF_VC_FPR32VW_SE_M8,
          702 => Opcode::PseudoSF_VC_FPR32VW_SE_MF2,
          703 => Opcode::PseudoSF_VC_FPR32V_SE_M1,
          704 => Opcode::PseudoSF_VC_FPR32V_SE_M2,
          705 => Opcode::PseudoSF_VC_FPR32V_SE_M4,
          706 => Opcode::PseudoSF_VC_FPR32V_SE_M8,
          707 => Opcode::PseudoSF_VC_FPR32V_SE_MF2,
          708 => Opcode::PseudoSF_VC_FPR64VV_SE_M1,
          709 => Opcode::PseudoSF_VC_FPR64VV_SE_M2,
          710 => Opcode::PseudoSF_VC_FPR64VV_SE_M4,
          711 => Opcode::PseudoSF_VC_FPR64VV_SE_M8,
          712 => Opcode::PseudoSF_VC_FPR64V_SE_M1,
          713 => Opcode::PseudoSF_VC_FPR64V_SE_M2,
          714 => Opcode::PseudoSF_VC_FPR64V_SE_M4,
          715 => Opcode::PseudoSF_VC_FPR64V_SE_M8,
          716 => Opcode::PseudoSF_VC_IVV_SE_M1,
          717 => Opcode::PseudoSF_VC_IVV_SE_M2,
          718 => Opcode::PseudoSF_VC_IVV_SE_M4,
          719 => Opcode::PseudoSF_VC_IVV_SE_M8,
          720 => Opcode::PseudoSF_VC_IVV_SE_MF2,
          721 => Opcode::PseudoSF_VC_IVV_SE_MF4,
          722 => Opcode::PseudoSF_VC_IVV_SE_MF8,
          723 => Opcode::PseudoSF_VC_IVW_SE_M1,
          724 => Opcode::PseudoSF_VC_IVW_SE_M2,
          725 => Opcode::PseudoSF_VC_IVW_SE_M4,
          726 => Opcode::PseudoSF_VC_IVW_SE_MF2,
          727 => Opcode::PseudoSF_VC_IVW_SE_MF4,
          728 => Opcode::PseudoSF_VC_IVW_SE_MF8,
          729 => Opcode::PseudoSF_VC_IV_SE_M1,
          730 => Opcode::PseudoSF_VC_IV_SE_M2,
          731 => Opcode::PseudoSF_VC_IV_SE_M4,
          732 => Opcode::PseudoSF_VC_IV_SE_M8,
          733 => Opcode::PseudoSF_VC_IV_SE_MF2,
          734 => Opcode::PseudoSF_VC_IV_SE_MF4,
          735 => Opcode::PseudoSF_VC_IV_SE_MF8,
          736 => Opcode::PseudoSF_VC_I_SE_M1,
          737 => Opcode::PseudoSF_VC_I_SE_M2,
          738 => Opcode::PseudoSF_VC_I_SE_M4,
          739 => Opcode::PseudoSF_VC_I_SE_M8,
          740 => Opcode::PseudoSF_VC_I_SE_MF2,
          741 => Opcode::PseudoSF_VC_I_SE_MF4,
          742 => Opcode::PseudoSF_VC_I_SE_MF8,
          743 => Opcode::PseudoSF_VC_VVV_SE_M1,
          744 => Opcode::PseudoSF_VC_VVV_SE_M2,
          745 => Opcode::PseudoSF_VC_VVV_SE_M4,
          746 => Opcode::PseudoSF_VC_VVV_SE_M8,
          747 => Opcode::PseudoSF_VC_VVV_SE_MF2,
          748 => Opcode::PseudoSF_VC_VVV_SE_MF4,
          749 => Opcode::PseudoSF_VC_VVV_SE_MF8,
          750 => Opcode::PseudoSF_VC_VVW_SE_M1,
          751 => Opcode::PseudoSF_VC_VVW_SE_M2,
          752 => Opcode::PseudoSF_VC_VVW_SE_M4,
          753 => Opcode::PseudoSF_VC_VVW_SE_MF2,
          754 => Opcode::PseudoSF_VC_VVW_SE_MF4,
          755 => Opcode::PseudoSF_VC_VVW_SE_MF8,
          756 => Opcode::PseudoSF_VC_VV_SE_M1,
          757 => Opcode::PseudoSF_VC_VV_SE_M2,
          758 => Opcode::PseudoSF_VC_VV_SE_M4,
          759 => Opcode::PseudoSF_VC_VV_SE_M8,
          760 => Opcode::PseudoSF_VC_VV_SE_MF2,
          761 => Opcode::PseudoSF_VC_VV_SE_MF4,
          762 => Opcode::PseudoSF_VC_VV_SE_MF8,
          763 => Opcode::PseudoSF_VC_V_FPR16VV_M1,
          764 => Opcode::PseudoSF_VC_V_FPR16VV_M2,
          765 => Opcode::PseudoSF_VC_V_FPR16VV_M4,
          766 => Opcode::PseudoSF_VC_V_FPR16VV_M8,
          767 => Opcode::PseudoSF_VC_V_FPR16VV_MF2,
          768 => Opcode::PseudoSF_VC_V_FPR16VV_MF4,
          769 => Opcode::PseudoSF_VC_V_FPR16VV_SE_M1,
          770 => Opcode::PseudoSF_VC_V_FPR16VV_SE_M2,
          771 => Opcode::PseudoSF_VC_V_FPR16VV_SE_M4,
          772 => Opcode::PseudoSF_VC_V_FPR16VV_SE_M8,
          773 => Opcode::PseudoSF_VC_V_FPR16VV_SE_MF2,
          774 => Opcode::PseudoSF_VC_V_FPR16VV_SE_MF4,
          775 => Opcode::PseudoSF_VC_V_FPR16VW_M1,
          776 => Opcode::PseudoSF_VC_V_FPR16VW_M2,
          777 => Opcode::PseudoSF_VC_V_FPR16VW_M4,
          778 => Opcode::PseudoSF_VC_V_FPR16VW_M8,
          779 => Opcode::PseudoSF_VC_V_FPR16VW_MF2,
          780 => Opcode::PseudoSF_VC_V_FPR16VW_MF4,
          781 => Opcode::PseudoSF_VC_V_FPR16VW_SE_M1,
          782 => Opcode::PseudoSF_VC_V_FPR16VW_SE_M2,
          783 => Opcode::PseudoSF_VC_V_FPR16VW_SE_M4,
          784 => Opcode::PseudoSF_VC_V_FPR16VW_SE_M8,
          785 => Opcode::PseudoSF_VC_V_FPR16VW_SE_MF2,
          786 => Opcode::PseudoSF_VC_V_FPR16VW_SE_MF4,
          787 => Opcode::PseudoSF_VC_V_FPR16V_M1,
          788 => Opcode::PseudoSF_VC_V_FPR16V_M2,
          789 => Opcode::PseudoSF_VC_V_FPR16V_M4,
          790 => Opcode::PseudoSF_VC_V_FPR16V_M8,
          791 => Opcode::PseudoSF_VC_V_FPR16V_MF2,
          792 => Opcode::PseudoSF_VC_V_FPR16V_MF4,
          793 => Opcode::PseudoSF_VC_V_FPR16V_SE_M1,
          794 => Opcode::PseudoSF_VC_V_FPR16V_SE_M2,
          795 => Opcode::PseudoSF_VC_V_FPR16V_SE_M4,
          796 => Opcode::PseudoSF_VC_V_FPR16V_SE_M8,
          797 => Opcode::PseudoSF_VC_V_FPR16V_SE_MF2,
          798 => Opcode::PseudoSF_VC_V_FPR16V_SE_MF4,
          799 => Opcode::PseudoSF_VC_V_FPR32VV_M1,
          800 => Opcode::PseudoSF_VC_V_FPR32VV_M2,
          801 => Opcode::PseudoSF_VC_V_FPR32VV_M4,
          802 => Opcode::PseudoSF_VC_V_FPR32VV_M8,
          803 => Opcode::PseudoSF_VC_V_FPR32VV_MF2,
          804 => Opcode::PseudoSF_VC_V_FPR32VV_SE_M1,
          805 => Opcode::PseudoSF_VC_V_FPR32VV_SE_M2,
          806 => Opcode::PseudoSF_VC_V_FPR32VV_SE_M4,
          807 => Opcode::PseudoSF_VC_V_FPR32VV_SE_M8,
          808 => Opcode::PseudoSF_VC_V_FPR32VV_SE_MF2,
          809 => Opcode::PseudoSF_VC_V_FPR32VW_M1,
          810 => Opcode::PseudoSF_VC_V_FPR32VW_M2,
          811 => Opcode::PseudoSF_VC_V_FPR32VW_M4,
          812 => Opcode::PseudoSF_VC_V_FPR32VW_M8,
          813 => Opcode::PseudoSF_VC_V_FPR32VW_MF2,
          814 => Opcode::PseudoSF_VC_V_FPR32VW_SE_M1,
          815 => Opcode::PseudoSF_VC_V_FPR32VW_SE_M2,
          816 => Opcode::PseudoSF_VC_V_FPR32VW_SE_M4,
          817 => Opcode::PseudoSF_VC_V_FPR32VW_SE_M8,
          818 => Opcode::PseudoSF_VC_V_FPR32VW_SE_MF2,
          819 => Opcode::PseudoSF_VC_V_FPR32V_M1,
          820 => Opcode::PseudoSF_VC_V_FPR32V_M2,
          821 => Opcode::PseudoSF_VC_V_FPR32V_M4,
          822 => Opcode::PseudoSF_VC_V_FPR32V_M8,
          823 => Opcode::PseudoSF_VC_V_FPR32V_MF2,
          824 => Opcode::PseudoSF_VC_V_FPR32V_SE_M1,
          825 => Opcode::PseudoSF_VC_V_FPR32V_SE_M2,
          826 => Opcode::PseudoSF_VC_V_FPR32V_SE_M4,
          827 => Opcode::PseudoSF_VC_V_FPR32V_SE_M8,
          828 => Opcode::PseudoSF_VC_V_FPR32V_SE_MF2,
          829 => Opcode::PseudoSF_VC_V_FPR64VV_M1,
          830 => Opcode::PseudoSF_VC_V_FPR64VV_M2,
          831 => Opcode::PseudoSF_VC_V_FPR64VV_M4,
          832 => Opcode::PseudoSF_VC_V_FPR64VV_M8,
          833 => Opcode::PseudoSF_VC_V_FPR64VV_SE_M1,
          834 => Opcode::PseudoSF_VC_V_FPR64VV_SE_M2,
          835 => Opcode::PseudoSF_VC_V_FPR64VV_SE_M4,
          836 => Opcode::PseudoSF_VC_V_FPR64VV_SE_M8,
          837 => Opcode::PseudoSF_VC_V_FPR64V_M1,
          838 => Opcode::PseudoSF_VC_V_FPR64V_M2,
          839 => Opcode::PseudoSF_VC_V_FPR64V_M4,
          840 => Opcode::PseudoSF_VC_V_FPR64V_M8,
          841 => Opcode::PseudoSF_VC_V_FPR64V_SE_M1,
          842 => Opcode::PseudoSF_VC_V_FPR64V_SE_M2,
          843 => Opcode::PseudoSF_VC_V_FPR64V_SE_M4,
          844 => Opcode::PseudoSF_VC_V_FPR64V_SE_M8,
          845 => Opcode::PseudoSF_VC_V_IVV_M1,
          846 => Opcode::PseudoSF_VC_V_IVV_M2,
          847 => Opcode::PseudoSF_VC_V_IVV_M4,
          848 => Opcode::PseudoSF_VC_V_IVV_M8,
          849 => Opcode::PseudoSF_VC_V_IVV_MF2,
          850 => Opcode::PseudoSF_VC_V_IVV_MF4,
          851 => Opcode::PseudoSF_VC_V_IVV_MF8,
          852 => Opcode::PseudoSF_VC_V_IVV_SE_M1,
          853 => Opcode::PseudoSF_VC_V_IVV_SE_M2,
          854 => Opcode::PseudoSF_VC_V_IVV_SE_M4,
          855 => Opcode::PseudoSF_VC_V_IVV_SE_M8,
          856 => Opcode::PseudoSF_VC_V_IVV_SE_MF2,
          857 => Opcode::PseudoSF_VC_V_IVV_SE_MF4,
          858 => Opcode::PseudoSF_VC_V_IVV_SE_MF8,
          859 => Opcode::PseudoSF_VC_V_IVW_M1,
          860 => Opcode::PseudoSF_VC_V_IVW_M2,
          861 => Opcode::PseudoSF_VC_V_IVW_M4,
          862 => Opcode::PseudoSF_VC_V_IVW_MF2,
          863 => Opcode::PseudoSF_VC_V_IVW_MF4,
          864 => Opcode::PseudoSF_VC_V_IVW_MF8,
          865 => Opcode::PseudoSF_VC_V_IVW_SE_M1,
          866 => Opcode::PseudoSF_VC_V_IVW_SE_M2,
          867 => Opcode::PseudoSF_VC_V_IVW_SE_M4,
          868 => Opcode::PseudoSF_VC_V_IVW_SE_MF2,
          869 => Opcode::PseudoSF_VC_V_IVW_SE_MF4,
          870 => Opcode::PseudoSF_VC_V_IVW_SE_MF8,
          871 => Opcode::PseudoSF_VC_V_IV_M1,
          872 => Opcode::PseudoSF_VC_V_IV_M2,
          873 => Opcode::PseudoSF_VC_V_IV_M4,
          874 => Opcode::PseudoSF_VC_V_IV_M8,
          875 => Opcode::PseudoSF_VC_V_IV_MF2,
          876 => Opcode::PseudoSF_VC_V_IV_MF4,
          877 => Opcode::PseudoSF_VC_V_IV_MF8,
          878 => Opcode::PseudoSF_VC_V_IV_SE_M1,
          879 => Opcode::PseudoSF_VC_V_IV_SE_M2,
          880 => Opcode::PseudoSF_VC_V_IV_SE_M4,
          881 => Opcode::PseudoSF_VC_V_IV_SE_M8,
          882 => Opcode::PseudoSF_VC_V_IV_SE_MF2,
          883 => Opcode::PseudoSF_VC_V_IV_SE_MF4,
          884 => Opcode::PseudoSF_VC_V_IV_SE_MF8,
          885 => Opcode::PseudoSF_VC_V_I_M1,
          886 => Opcode::PseudoSF_VC_V_I_M2,
          887 => Opcode::PseudoSF_VC_V_I_M4,
          888 => Opcode::PseudoSF_VC_V_I_M8,
          889 => Opcode::PseudoSF_VC_V_I_MF2,
          890 => Opcode::PseudoSF_VC_V_I_MF4,
          891 => Opcode::PseudoSF_VC_V_I_MF8,
          892 => Opcode::PseudoSF_VC_V_I_SE_M1,
          893 => Opcode::PseudoSF_VC_V_I_SE_M2,
          894 => Opcode::PseudoSF_VC_V_I_SE_M4,
          895 => Opcode::PseudoSF_VC_V_I_SE_M8,
          896 => Opcode::PseudoSF_VC_V_I_SE_MF2,
          897 => Opcode::PseudoSF_VC_V_I_SE_MF4,
          898 => Opcode::PseudoSF_VC_V_I_SE_MF8,
          899 => Opcode::PseudoSF_VC_V_VVV_M1,
          900 => Opcode::PseudoSF_VC_V_VVV_M2,
          901 => Opcode::PseudoSF_VC_V_VVV_M4,
          902 => Opcode::PseudoSF_VC_V_VVV_M8,
          903 => Opcode::PseudoSF_VC_V_VVV_MF2,
          904 => Opcode::PseudoSF_VC_V_VVV_MF4,
          905 => Opcode::PseudoSF_VC_V_VVV_MF8,
          906 => Opcode::PseudoSF_VC_V_VVV_SE_M1,
          907 => Opcode::PseudoSF_VC_V_VVV_SE_M2,
          908 => Opcode::PseudoSF_VC_V_VVV_SE_M4,
          909 => Opcode::PseudoSF_VC_V_VVV_SE_M8,
          910 => Opcode::PseudoSF_VC_V_VVV_SE_MF2,
          911 => Opcode::PseudoSF_VC_V_VVV_SE_MF4,
          912 => Opcode::PseudoSF_VC_V_VVV_SE_MF8,
          913 => Opcode::PseudoSF_VC_V_VVW_M1,
          914 => Opcode::PseudoSF_VC_V_VVW_M2,
          915 => Opcode::PseudoSF_VC_V_VVW_M4,
          916 => Opcode::PseudoSF_VC_V_VVW_MF2,
          917 => Opcode::PseudoSF_VC_V_VVW_MF4,
          918 => Opcode::PseudoSF_VC_V_VVW_MF8,
          919 => Opcode::PseudoSF_VC_V_VVW_SE_M1,
          920 => Opcode::PseudoSF_VC_V_VVW_SE_M2,
          921 => Opcode::PseudoSF_VC_V_VVW_SE_M4,
          922 => Opcode::PseudoSF_VC_V_VVW_SE_MF2,
          923 => Opcode::PseudoSF_VC_V_VVW_SE_MF4,
          924 => Opcode::PseudoSF_VC_V_VVW_SE_MF8,
          925 => Opcode::PseudoSF_VC_V_VV_M1,
          926 => Opcode::PseudoSF_VC_V_VV_M2,
          927 => Opcode::PseudoSF_VC_V_VV_M4,
          928 => Opcode::PseudoSF_VC_V_VV_M8,
          929 => Opcode::PseudoSF_VC_V_VV_MF2,
          930 => Opcode::PseudoSF_VC_V_VV_MF4,
          931 => Opcode::PseudoSF_VC_V_VV_MF8,
          932 => Opcode::PseudoSF_VC_V_VV_SE_M1,
          933 => Opcode::PseudoSF_VC_V_VV_SE_M2,
          934 => Opcode::PseudoSF_VC_V_VV_SE_M4,
          935 => Opcode::PseudoSF_VC_V_VV_SE_M8,
          936 => Opcode::PseudoSF_VC_V_VV_SE_MF2,
          937 => Opcode::PseudoSF_VC_V_VV_SE_MF4,
          938 => Opcode::PseudoSF_VC_V_VV_SE_MF8,
          939 => Opcode::PseudoSF_VC_V_XVV_M1,
          940 => Opcode::PseudoSF_VC_V_XVV_M2,
          941 => Opcode::PseudoSF_VC_V_XVV_M4,
          942 => Opcode::PseudoSF_VC_V_XVV_M8,
          943 => Opcode::PseudoSF_VC_V_XVV_MF2,
          944 => Opcode::PseudoSF_VC_V_XVV_MF4,
          945 => Opcode::PseudoSF_VC_V_XVV_MF8,
          946 => Opcode::PseudoSF_VC_V_XVV_SE_M1,
          947 => Opcode::PseudoSF_VC_V_XVV_SE_M2,
          948 => Opcode::PseudoSF_VC_V_XVV_SE_M4,
          949 => Opcode::PseudoSF_VC_V_XVV_SE_M8,
          950 => Opcode::PseudoSF_VC_V_XVV_SE_MF2,
          951 => Opcode::PseudoSF_VC_V_XVV_SE_MF4,
          952 => Opcode::PseudoSF_VC_V_XVV_SE_MF8,
          953 => Opcode::PseudoSF_VC_V_XVW_M1,
          954 => Opcode::PseudoSF_VC_V_XVW_M2,
          955 => Opcode::PseudoSF_VC_V_XVW_M4,
          956 => Opcode::PseudoSF_VC_V_XVW_MF2,
          957 => Opcode::PseudoSF_VC_V_XVW_MF4,
          958 => Opcode::PseudoSF_VC_V_XVW_MF8,
          959 => Opcode::PseudoSF_VC_V_XVW_SE_M1,
          960 => Opcode::PseudoSF_VC_V_XVW_SE_M2,
          961 => Opcode::PseudoSF_VC_V_XVW_SE_M4,
          962 => Opcode::PseudoSF_VC_V_XVW_SE_MF2,
          963 => Opcode::PseudoSF_VC_V_XVW_SE_MF4,
          964 => Opcode::PseudoSF_VC_V_XVW_SE_MF8,
          965 => Opcode::PseudoSF_VC_V_XV_M1,
          966 => Opcode::PseudoSF_VC_V_XV_M2,
          967 => Opcode::PseudoSF_VC_V_XV_M4,
          968 => Opcode::PseudoSF_VC_V_XV_M8,
          969 => Opcode::PseudoSF_VC_V_XV_MF2,
          970 => Opcode::PseudoSF_VC_V_XV_MF4,
          971 => Opcode::PseudoSF_VC_V_XV_MF8,
          972 => Opcode::PseudoSF_VC_V_XV_SE_M1,
          973 => Opcode::PseudoSF_VC_V_XV_SE_M2,
          974 => Opcode::PseudoSF_VC_V_XV_SE_M4,
          975 => Opcode::PseudoSF_VC_V_XV_SE_M8,
          976 => Opcode::PseudoSF_VC_V_XV_SE_MF2,
          977 => Opcode::PseudoSF_VC_V_XV_SE_MF4,
          978 => Opcode::PseudoSF_VC_V_XV_SE_MF8,
          979 => Opcode::PseudoSF_VC_V_X_M1,
          980 => Opcode::PseudoSF_VC_V_X_M2,
          981 => Opcode::PseudoSF_VC_V_X_M4,
          982 => Opcode::PseudoSF_VC_V_X_M8,
          983 => Opcode::PseudoSF_VC_V_X_MF2,
          984 => Opcode::PseudoSF_VC_V_X_MF4,
          985 => Opcode::PseudoSF_VC_V_X_MF8,
          986 => Opcode::PseudoSF_VC_V_X_SE_M1,
          987 => Opcode::PseudoSF_VC_V_X_SE_M2,
          988 => Opcode::PseudoSF_VC_V_X_SE_M4,
          989 => Opcode::PseudoSF_VC_V_X_SE_M8,
          990 => Opcode::PseudoSF_VC_V_X_SE_MF2,
          991 => Opcode::PseudoSF_VC_V_X_SE_MF4,
          992 => Opcode::PseudoSF_VC_V_X_SE_MF8,
          993 => Opcode::PseudoSF_VC_XVV_SE_M1,
          994 => Opcode::PseudoSF_VC_XVV_SE_M2,
          995 => Opcode::PseudoSF_VC_XVV_SE_M4,
          996 => Opcode::PseudoSF_VC_XVV_SE_M8,
          997 => Opcode::PseudoSF_VC_XVV_SE_MF2,
          998 => Opcode::PseudoSF_VC_XVV_SE_MF4,
          999 => Opcode::PseudoSF_VC_XVV_SE_MF8,
          1000 => Opcode::PseudoSF_VC_XVW_SE_M1,
          1001 => Opcode::PseudoSF_VC_XVW_SE_M2,
          1002 => Opcode::PseudoSF_VC_XVW_SE_M4,
          1003 => Opcode::PseudoSF_VC_XVW_SE_MF2,
          1004 => Opcode::PseudoSF_VC_XVW_SE_MF4,
          1005 => Opcode::PseudoSF_VC_XVW_SE_MF8,
          1006 => Opcode::PseudoSF_VC_XV_SE_M1,
          1007 => Opcode::PseudoSF_VC_XV_SE_M2,
          1008 => Opcode::PseudoSF_VC_XV_SE_M4,
          1009 => Opcode::PseudoSF_VC_XV_SE_M8,
          1010 => Opcode::PseudoSF_VC_XV_SE_MF2,
          1011 => Opcode::PseudoSF_VC_XV_SE_MF4,
          1012 => Opcode::PseudoSF_VC_XV_SE_MF8,
          1013 => Opcode::PseudoSF_VC_X_SE_M1,
          1014 => Opcode::PseudoSF_VC_X_SE_M2,
          1015 => Opcode::PseudoSF_VC_X_SE_M4,
          1016 => Opcode::PseudoSF_VC_X_SE_M8,
          1017 => Opcode::PseudoSF_VC_X_SE_MF2,
          1018 => Opcode::PseudoSF_VC_X_SE_MF4,
          1019 => Opcode::PseudoSF_VC_X_SE_MF8,
          1020 => Opcode::PseudoSF_VFNRCLIP_XU_F_QF_M1,
          1021 => Opcode::PseudoSF_VFNRCLIP_XU_F_QF_M1_MASK,
          1022 => Opcode::PseudoSF_VFNRCLIP_XU_F_QF_M2,
          1023 => Opcode::PseudoSF_VFNRCLIP_XU_F_QF_M2_MASK,
          1024 => Opcode::PseudoSF_VFNRCLIP_XU_F_QF_MF2,
          1025 => Opcode::PseudoSF_VFNRCLIP_XU_F_QF_MF2_MASK,
          1026 => Opcode::PseudoSF_VFNRCLIP_XU_F_QF_MF4,
          1027 => Opcode::PseudoSF_VFNRCLIP_XU_F_QF_MF4_MASK,
          1028 => Opcode::PseudoSF_VFNRCLIP_XU_F_QF_MF8,
          1029 => Opcode::PseudoSF_VFNRCLIP_XU_F_QF_MF8_MASK,
          1030 => Opcode::PseudoSF_VFNRCLIP_X_F_QF_M1,
          1031 => Opcode::PseudoSF_VFNRCLIP_X_F_QF_M1_MASK,
          1032 => Opcode::PseudoSF_VFNRCLIP_X_F_QF_M2,
          1033 => Opcode::PseudoSF_VFNRCLIP_X_F_QF_M2_MASK,
          1034 => Opcode::PseudoSF_VFNRCLIP_X_F_QF_MF2,
          1035 => Opcode::PseudoSF_VFNRCLIP_X_F_QF_MF2_MASK,
          1036 => Opcode::PseudoSF_VFNRCLIP_X_F_QF_MF4,
          1037 => Opcode::PseudoSF_VFNRCLIP_X_F_QF_MF4_MASK,
          1038 => Opcode::PseudoSF_VFNRCLIP_X_F_QF_MF8,
          1039 => Opcode::PseudoSF_VFNRCLIP_X_F_QF_MF8_MASK,
          1040 => Opcode::PseudoSF_VFWMACC_4x4x4_M1,
          1041 => Opcode::PseudoSF_VFWMACC_4x4x4_M2,
          1042 => Opcode::PseudoSF_VFWMACC_4x4x4_M4,
          1043 => Opcode::PseudoSF_VFWMACC_4x4x4_MF2,
          1044 => Opcode::PseudoSF_VFWMACC_4x4x4_MF4,
          1045 => Opcode::PseudoSF_VQMACCSU_2x8x2_M1,
          1046 => Opcode::PseudoSF_VQMACCSU_2x8x2_M2,
          1047 => Opcode::PseudoSF_VQMACCSU_2x8x2_M4,
          1048 => Opcode::PseudoSF_VQMACCSU_2x8x2_M8,
          1049 => Opcode::PseudoSF_VQMACCSU_4x8x4_M1,
          1050 => Opcode::PseudoSF_VQMACCSU_4x8x4_M2,
          1051 => Opcode::PseudoSF_VQMACCSU_4x8x4_M4,
          1052 => Opcode::PseudoSF_VQMACCSU_4x8x4_MF2,
          1053 => Opcode::PseudoSF_VQMACCUS_2x8x2_M1,
          1054 => Opcode::PseudoSF_VQMACCUS_2x8x2_M2,
          1055 => Opcode::PseudoSF_VQMACCUS_2x8x2_M4,
          1056 => Opcode::PseudoSF_VQMACCUS_2x8x2_M8,
          1057 => Opcode::PseudoSF_VQMACCUS_4x8x4_M1,
          1058 => Opcode::PseudoSF_VQMACCUS_4x8x4_M2,
          1059 => Opcode::PseudoSF_VQMACCUS_4x8x4_M4,
          1060 => Opcode::PseudoSF_VQMACCUS_4x8x4_MF2,
          1061 => Opcode::PseudoSF_VQMACCU_2x8x2_M1,
          1062 => Opcode::PseudoSF_VQMACCU_2x8x2_M2,
          1063 => Opcode::PseudoSF_VQMACCU_2x8x2_M4,
          1064 => Opcode::PseudoSF_VQMACCU_2x8x2_M8,
          1065 => Opcode::PseudoSF_VQMACCU_4x8x4_M1,
          1066 => Opcode::PseudoSF_VQMACCU_4x8x4_M2,
          1067 => Opcode::PseudoSF_VQMACCU_4x8x4_M4,
          1068 => Opcode::PseudoSF_VQMACCU_4x8x4_MF2,
          1069 => Opcode::PseudoSF_VQMACC_2x8x2_M1,
          1070 => Opcode::PseudoSF_VQMACC_2x8x2_M2,
          1071 => Opcode::PseudoSF_VQMACC_2x8x2_M4,
          1072 => Opcode::PseudoSF_VQMACC_2x8x2_M8,
          1073 => Opcode::PseudoSF_VQMACC_4x8x4_M1,
          1074 => Opcode::PseudoSF_VQMACC_4x8x4_M2,
          1075 => Opcode::PseudoSF_VQMACC_4x8x4_M4,
          1076 => Opcode::PseudoSF_VQMACC_4x8x4_MF2,
          1077 => Opcode::PseudoSH,
          1078 => Opcode::PseudoSW,
          1079 => Opcode::PseudoTAIL,
          1080 => Opcode::PseudoTAILIndirect,
          1081 => Opcode::PseudoTAILIndirectNonX7,
          1082 => Opcode::PseudoTAILIndirectX7,
          1083 => Opcode::PseudoTH_VMAQASU_VV_M1,
          1084 => Opcode::PseudoTH_VMAQASU_VV_M1_MASK,
          1085 => Opcode::PseudoTH_VMAQASU_VV_M2,
          1086 => Opcode::PseudoTH_VMAQASU_VV_M2_MASK,
          1087 => Opcode::PseudoTH_VMAQASU_VV_M4,
          1088 => Opcode::PseudoTH_VMAQASU_VV_M4_MASK,
          1089 => Opcode::PseudoTH_VMAQASU_VV_M8,
          1090 => Opcode::PseudoTH_VMAQASU_VV_M8_MASK,
          1091 => Opcode::PseudoTH_VMAQASU_VV_MF2,
          1092 => Opcode::PseudoTH_VMAQASU_VV_MF2_MASK,
          1093 => Opcode::PseudoTH_VMAQASU_VX_M1,
          1094 => Opcode::PseudoTH_VMAQASU_VX_M1_MASK,
          1095 => Opcode::PseudoTH_VMAQASU_VX_M2,
          1096 => Opcode::PseudoTH_VMAQASU_VX_M2_MASK,
          1097 => Opcode::PseudoTH_VMAQASU_VX_M4,
          1098 => Opcode::PseudoTH_VMAQASU_VX_M4_MASK,
          1099 => Opcode::PseudoTH_VMAQASU_VX_M8,
          1100 => Opcode::PseudoTH_VMAQASU_VX_M8_MASK,
          1101 => Opcode::PseudoTH_VMAQASU_VX_MF2,
          1102 => Opcode::PseudoTH_VMAQASU_VX_MF2_MASK,
          1103 => Opcode::PseudoTH_VMAQAUS_VX_M1,
          1104 => Opcode::PseudoTH_VMAQAUS_VX_M1_MASK,
          1105 => Opcode::PseudoTH_VMAQAUS_VX_M2,
          1106 => Opcode::PseudoTH_VMAQAUS_VX_M2_MASK,
          1107 => Opcode::PseudoTH_VMAQAUS_VX_M4,
          1108 => Opcode::PseudoTH_VMAQAUS_VX_M4_MASK,
          1109 => Opcode::PseudoTH_VMAQAUS_VX_M8,
          1110 => Opcode::PseudoTH_VMAQAUS_VX_M8_MASK,
          1111 => Opcode::PseudoTH_VMAQAUS_VX_MF2,
          1112 => Opcode::PseudoTH_VMAQAUS_VX_MF2_MASK,
          1113 => Opcode::PseudoTH_VMAQAU_VV_M1,
          1114 => Opcode::PseudoTH_VMAQAU_VV_M1_MASK,
          1115 => Opcode::PseudoTH_VMAQAU_VV_M2,
          1116 => Opcode::PseudoTH_VMAQAU_VV_M2_MASK,
          1117 => Opcode::PseudoTH_VMAQAU_VV_M4,
          1118 => Opcode::PseudoTH_VMAQAU_VV_M4_MASK,
          1119 => Opcode::PseudoTH_VMAQAU_VV_M8,
          1120 => Opcode::PseudoTH_VMAQAU_VV_M8_MASK,
          1121 => Opcode::PseudoTH_VMAQAU_VV_MF2,
          1122 => Opcode::PseudoTH_VMAQAU_VV_MF2_MASK,
          1123 => Opcode::PseudoTH_VMAQAU_VX_M1,
          1124 => Opcode::PseudoTH_VMAQAU_VX_M1_MASK,
          1125 => Opcode::PseudoTH_VMAQAU_VX_M2,
          1126 => Opcode::PseudoTH_VMAQAU_VX_M2_MASK,
          1127 => Opcode::PseudoTH_VMAQAU_VX_M4,
          1128 => Opcode::PseudoTH_VMAQAU_VX_M4_MASK,
          1129 => Opcode::PseudoTH_VMAQAU_VX_M8,
          1130 => Opcode::PseudoTH_VMAQAU_VX_M8_MASK,
          1131 => Opcode::PseudoTH_VMAQAU_VX_MF2,
          1132 => Opcode::PseudoTH_VMAQAU_VX_MF2_MASK,
          1133 => Opcode::PseudoTH_VMAQA_VV_M1,
          1134 => Opcode::PseudoTH_VMAQA_VV_M1_MASK,
          1135 => Opcode::PseudoTH_VMAQA_VV_M2,
          1136 => Opcode::PseudoTH_VMAQA_VV_M2_MASK,
          1137 => Opcode::PseudoTH_VMAQA_VV_M4,
          1138 => Opcode::PseudoTH_VMAQA_VV_M4_MASK,
          1139 => Opcode::PseudoTH_VMAQA_VV_M8,
          1140 => Opcode::PseudoTH_VMAQA_VV_M8_MASK,
          1141 => Opcode::PseudoTH_VMAQA_VV_MF2,
          1142 => Opcode::PseudoTH_VMAQA_VV_MF2_MASK,
          1143 => Opcode::PseudoTH_VMAQA_VX_M1,
          1144 => Opcode::PseudoTH_VMAQA_VX_M1_MASK,
          1145 => Opcode::PseudoTH_VMAQA_VX_M2,
          1146 => Opcode::PseudoTH_VMAQA_VX_M2_MASK,
          1147 => Opcode::PseudoTH_VMAQA_VX_M4,
          1148 => Opcode::PseudoTH_VMAQA_VX_M4_MASK,
          1149 => Opcode::PseudoTH_VMAQA_VX_M8,
          1150 => Opcode::PseudoTH_VMAQA_VX_M8_MASK,
          1151 => Opcode::PseudoTH_VMAQA_VX_MF2,
          1152 => Opcode::PseudoTH_VMAQA_VX_MF2_MASK,
          1153 => Opcode::PseudoTLSDESCCall,
          1154 => Opcode::PseudoVAADDU_VV_M1,
          1155 => Opcode::PseudoVAADDU_VV_M1_MASK,
          1156 => Opcode::PseudoVAADDU_VV_M2,
          1157 => Opcode::PseudoVAADDU_VV_M2_MASK,
          1158 => Opcode::PseudoVAADDU_VV_M4,
          1159 => Opcode::PseudoVAADDU_VV_M4_MASK,
          1160 => Opcode::PseudoVAADDU_VV_M8,
          1161 => Opcode::PseudoVAADDU_VV_M8_MASK,
          1162 => Opcode::PseudoVAADDU_VV_MF2,
          1163 => Opcode::PseudoVAADDU_VV_MF2_MASK,
          1164 => Opcode::PseudoVAADDU_VV_MF4,
          1165 => Opcode::PseudoVAADDU_VV_MF4_MASK,
          1166 => Opcode::PseudoVAADDU_VV_MF8,
          1167 => Opcode::PseudoVAADDU_VV_MF8_MASK,
          1168 => Opcode::PseudoVAADDU_VX_M1,
          1169 => Opcode::PseudoVAADDU_VX_M1_MASK,
          1170 => Opcode::PseudoVAADDU_VX_M2,
          1171 => Opcode::PseudoVAADDU_VX_M2_MASK,
          1172 => Opcode::PseudoVAADDU_VX_M4,
          1173 => Opcode::PseudoVAADDU_VX_M4_MASK,
          1174 => Opcode::PseudoVAADDU_VX_M8,
          1175 => Opcode::PseudoVAADDU_VX_M8_MASK,
          1176 => Opcode::PseudoVAADDU_VX_MF2,
          1177 => Opcode::PseudoVAADDU_VX_MF2_MASK,
          1178 => Opcode::PseudoVAADDU_VX_MF4,
          1179 => Opcode::PseudoVAADDU_VX_MF4_MASK,
          1180 => Opcode::PseudoVAADDU_VX_MF8,
          1181 => Opcode::PseudoVAADDU_VX_MF8_MASK,
          1182 => Opcode::PseudoVAADD_VV_M1,
          1183 => Opcode::PseudoVAADD_VV_M1_MASK,
          1184 => Opcode::PseudoVAADD_VV_M2,
          1185 => Opcode::PseudoVAADD_VV_M2_MASK,
          1186 => Opcode::PseudoVAADD_VV_M4,
          1187 => Opcode::PseudoVAADD_VV_M4_MASK,
          1188 => Opcode::PseudoVAADD_VV_M8,
          1189 => Opcode::PseudoVAADD_VV_M8_MASK,
          1190 => Opcode::PseudoVAADD_VV_MF2,
          1191 => Opcode::PseudoVAADD_VV_MF2_MASK,
          1192 => Opcode::PseudoVAADD_VV_MF4,
          1193 => Opcode::PseudoVAADD_VV_MF4_MASK,
          1194 => Opcode::PseudoVAADD_VV_MF8,
          1195 => Opcode::PseudoVAADD_VV_MF8_MASK,
          1196 => Opcode::PseudoVAADD_VX_M1,
          1197 => Opcode::PseudoVAADD_VX_M1_MASK,
          1198 => Opcode::PseudoVAADD_VX_M2,
          1199 => Opcode::PseudoVAADD_VX_M2_MASK,
          1200 => Opcode::PseudoVAADD_VX_M4,
          1201 => Opcode::PseudoVAADD_VX_M4_MASK,
          1202 => Opcode::PseudoVAADD_VX_M8,
          1203 => Opcode::PseudoVAADD_VX_M8_MASK,
          1204 => Opcode::PseudoVAADD_VX_MF2,
          1205 => Opcode::PseudoVAADD_VX_MF2_MASK,
          1206 => Opcode::PseudoVAADD_VX_MF4,
          1207 => Opcode::PseudoVAADD_VX_MF4_MASK,
          1208 => Opcode::PseudoVAADD_VX_MF8,
          1209 => Opcode::PseudoVAADD_VX_MF8_MASK,
          1210 => Opcode::PseudoVADC_VIM_M1,
          1211 => Opcode::PseudoVADC_VIM_M2,
          1212 => Opcode::PseudoVADC_VIM_M4,
          1213 => Opcode::PseudoVADC_VIM_M8,
          1214 => Opcode::PseudoVADC_VIM_MF2,
          1215 => Opcode::PseudoVADC_VIM_MF4,
          1216 => Opcode::PseudoVADC_VIM_MF8,
          1217 => Opcode::PseudoVADC_VVM_M1,
          1218 => Opcode::PseudoVADC_VVM_M2,
          1219 => Opcode::PseudoVADC_VVM_M4,
          1220 => Opcode::PseudoVADC_VVM_M8,
          1221 => Opcode::PseudoVADC_VVM_MF2,
          1222 => Opcode::PseudoVADC_VVM_MF4,
          1223 => Opcode::PseudoVADC_VVM_MF8,
          1224 => Opcode::PseudoVADC_VXM_M1,
          1225 => Opcode::PseudoVADC_VXM_M2,
          1226 => Opcode::PseudoVADC_VXM_M4,
          1227 => Opcode::PseudoVADC_VXM_M8,
          1228 => Opcode::PseudoVADC_VXM_MF2,
          1229 => Opcode::PseudoVADC_VXM_MF4,
          1230 => Opcode::PseudoVADC_VXM_MF8,
          1231 => Opcode::PseudoVADD_VI_M1,
          1232 => Opcode::PseudoVADD_VI_M1_MASK,
          1233 => Opcode::PseudoVADD_VI_M2,
          1234 => Opcode::PseudoVADD_VI_M2_MASK,
          1235 => Opcode::PseudoVADD_VI_M4,
          1236 => Opcode::PseudoVADD_VI_M4_MASK,
          1237 => Opcode::PseudoVADD_VI_M8,
          1238 => Opcode::PseudoVADD_VI_M8_MASK,
          1239 => Opcode::PseudoVADD_VI_MF2,
          1240 => Opcode::PseudoVADD_VI_MF2_MASK,
          1241 => Opcode::PseudoVADD_VI_MF4,
          1242 => Opcode::PseudoVADD_VI_MF4_MASK,
          1243 => Opcode::PseudoVADD_VI_MF8,
          1244 => Opcode::PseudoVADD_VI_MF8_MASK,
          1245 => Opcode::PseudoVADD_VV_M1,
          1246 => Opcode::PseudoVADD_VV_M1_MASK,
          1247 => Opcode::PseudoVADD_VV_M2,
          1248 => Opcode::PseudoVADD_VV_M2_MASK,
          1249 => Opcode::PseudoVADD_VV_M4,
          1250 => Opcode::PseudoVADD_VV_M4_MASK,
          1251 => Opcode::PseudoVADD_VV_M8,
          1252 => Opcode::PseudoVADD_VV_M8_MASK,
          1253 => Opcode::PseudoVADD_VV_MF2,
          1254 => Opcode::PseudoVADD_VV_MF2_MASK,
          1255 => Opcode::PseudoVADD_VV_MF4,
          1256 => Opcode::PseudoVADD_VV_MF4_MASK,
          1257 => Opcode::PseudoVADD_VV_MF8,
          1258 => Opcode::PseudoVADD_VV_MF8_MASK,
          1259 => Opcode::PseudoVADD_VX_M1,
          1260 => Opcode::PseudoVADD_VX_M1_MASK,
          1261 => Opcode::PseudoVADD_VX_M2,
          1262 => Opcode::PseudoVADD_VX_M2_MASK,
          1263 => Opcode::PseudoVADD_VX_M4,
          1264 => Opcode::PseudoVADD_VX_M4_MASK,
          1265 => Opcode::PseudoVADD_VX_M8,
          1266 => Opcode::PseudoVADD_VX_M8_MASK,
          1267 => Opcode::PseudoVADD_VX_MF2,
          1268 => Opcode::PseudoVADD_VX_MF2_MASK,
          1269 => Opcode::PseudoVADD_VX_MF4,
          1270 => Opcode::PseudoVADD_VX_MF4_MASK,
          1271 => Opcode::PseudoVADD_VX_MF8,
          1272 => Opcode::PseudoVADD_VX_MF8_MASK,
          1273 => Opcode::PseudoVAESDF_VS_M1_M1,
          1274 => Opcode::PseudoVAESDF_VS_M1_MF2,
          1275 => Opcode::PseudoVAESDF_VS_M1_MF4,
          1276 => Opcode::PseudoVAESDF_VS_M1_MF8,
          1277 => Opcode::PseudoVAESDF_VS_M2_M1,
          1278 => Opcode::PseudoVAESDF_VS_M2_M2,
          1279 => Opcode::PseudoVAESDF_VS_M2_MF2,
          1280 => Opcode::PseudoVAESDF_VS_M2_MF4,
          1281 => Opcode::PseudoVAESDF_VS_M2_MF8,
          1282 => Opcode::PseudoVAESDF_VS_M4_M1,
          1283 => Opcode::PseudoVAESDF_VS_M4_M2,
          1284 => Opcode::PseudoVAESDF_VS_M4_M4,
          1285 => Opcode::PseudoVAESDF_VS_M4_MF2,
          1286 => Opcode::PseudoVAESDF_VS_M4_MF4,
          1287 => Opcode::PseudoVAESDF_VS_M4_MF8,
          1288 => Opcode::PseudoVAESDF_VS_M8_M1,
          1289 => Opcode::PseudoVAESDF_VS_M8_M2,
          1290 => Opcode::PseudoVAESDF_VS_M8_M4,
          1291 => Opcode::PseudoVAESDF_VS_M8_MF2,
          1292 => Opcode::PseudoVAESDF_VS_M8_MF4,
          1293 => Opcode::PseudoVAESDF_VS_M8_MF8,
          1294 => Opcode::PseudoVAESDF_VS_MF2_MF2,
          1295 => Opcode::PseudoVAESDF_VS_MF2_MF4,
          1296 => Opcode::PseudoVAESDF_VS_MF2_MF8,
          1297 => Opcode::PseudoVAESDF_VV_M1,
          1298 => Opcode::PseudoVAESDF_VV_M2,
          1299 => Opcode::PseudoVAESDF_VV_M4,
          1300 => Opcode::PseudoVAESDF_VV_M8,
          1301 => Opcode::PseudoVAESDF_VV_MF2,
          1302 => Opcode::PseudoVAESDM_VS_M1_M1,
          1303 => Opcode::PseudoVAESDM_VS_M1_MF2,
          1304 => Opcode::PseudoVAESDM_VS_M1_MF4,
          1305 => Opcode::PseudoVAESDM_VS_M1_MF8,
          1306 => Opcode::PseudoVAESDM_VS_M2_M1,
          1307 => Opcode::PseudoVAESDM_VS_M2_M2,
          1308 => Opcode::PseudoVAESDM_VS_M2_MF2,
          1309 => Opcode::PseudoVAESDM_VS_M2_MF4,
          1310 => Opcode::PseudoVAESDM_VS_M2_MF8,
          1311 => Opcode::PseudoVAESDM_VS_M4_M1,
          1312 => Opcode::PseudoVAESDM_VS_M4_M2,
          1313 => Opcode::PseudoVAESDM_VS_M4_M4,
          1314 => Opcode::PseudoVAESDM_VS_M4_MF2,
          1315 => Opcode::PseudoVAESDM_VS_M4_MF4,
          1316 => Opcode::PseudoVAESDM_VS_M4_MF8,
          1317 => Opcode::PseudoVAESDM_VS_M8_M1,
          1318 => Opcode::PseudoVAESDM_VS_M8_M2,
          1319 => Opcode::PseudoVAESDM_VS_M8_M4,
          1320 => Opcode::PseudoVAESDM_VS_M8_MF2,
          1321 => Opcode::PseudoVAESDM_VS_M8_MF4,
          1322 => Opcode::PseudoVAESDM_VS_M8_MF8,
          1323 => Opcode::PseudoVAESDM_VS_MF2_MF2,
          1324 => Opcode::PseudoVAESDM_VS_MF2_MF4,
          1325 => Opcode::PseudoVAESDM_VS_MF2_MF8,
          1326 => Opcode::PseudoVAESDM_VV_M1,
          1327 => Opcode::PseudoVAESDM_VV_M2,
          1328 => Opcode::PseudoVAESDM_VV_M4,
          1329 => Opcode::PseudoVAESDM_VV_M8,
          1330 => Opcode::PseudoVAESDM_VV_MF2,
          1331 => Opcode::PseudoVAESEF_VS_M1_M1,
          1332 => Opcode::PseudoVAESEF_VS_M1_MF2,
          1333 => Opcode::PseudoVAESEF_VS_M1_MF4,
          1334 => Opcode::PseudoVAESEF_VS_M1_MF8,
          1335 => Opcode::PseudoVAESEF_VS_M2_M1,
          1336 => Opcode::PseudoVAESEF_VS_M2_M2,
          1337 => Opcode::PseudoVAESEF_VS_M2_MF2,
          1338 => Opcode::PseudoVAESEF_VS_M2_MF4,
          1339 => Opcode::PseudoVAESEF_VS_M2_MF8,
          1340 => Opcode::PseudoVAESEF_VS_M4_M1,
          1341 => Opcode::PseudoVAESEF_VS_M4_M2,
          1342 => Opcode::PseudoVAESEF_VS_M4_M4,
          1343 => Opcode::PseudoVAESEF_VS_M4_MF2,
          1344 => Opcode::PseudoVAESEF_VS_M4_MF4,
          1345 => Opcode::PseudoVAESEF_VS_M4_MF8,
          1346 => Opcode::PseudoVAESEF_VS_M8_M1,
          1347 => Opcode::PseudoVAESEF_VS_M8_M2,
          1348 => Opcode::PseudoVAESEF_VS_M8_M4,
          1349 => Opcode::PseudoVAESEF_VS_M8_MF2,
          1350 => Opcode::PseudoVAESEF_VS_M8_MF4,
          1351 => Opcode::PseudoVAESEF_VS_M8_MF8,
          1352 => Opcode::PseudoVAESEF_VS_MF2_MF2,
          1353 => Opcode::PseudoVAESEF_VS_MF2_MF4,
          1354 => Opcode::PseudoVAESEF_VS_MF2_MF8,
          1355 => Opcode::PseudoVAESEF_VV_M1,
          1356 => Opcode::PseudoVAESEF_VV_M2,
          1357 => Opcode::PseudoVAESEF_VV_M4,
          1358 => Opcode::PseudoVAESEF_VV_M8,
          1359 => Opcode::PseudoVAESEF_VV_MF2,
          1360 => Opcode::PseudoVAESEM_VS_M1_M1,
          1361 => Opcode::PseudoVAESEM_VS_M1_MF2,
          1362 => Opcode::PseudoVAESEM_VS_M1_MF4,
          1363 => Opcode::PseudoVAESEM_VS_M1_MF8,
          1364 => Opcode::PseudoVAESEM_VS_M2_M1,
          1365 => Opcode::PseudoVAESEM_VS_M2_M2,
          1366 => Opcode::PseudoVAESEM_VS_M2_MF2,
          1367 => Opcode::PseudoVAESEM_VS_M2_MF4,
          1368 => Opcode::PseudoVAESEM_VS_M2_MF8,
          1369 => Opcode::PseudoVAESEM_VS_M4_M1,
          1370 => Opcode::PseudoVAESEM_VS_M4_M2,
          1371 => Opcode::PseudoVAESEM_VS_M4_M4,
          1372 => Opcode::PseudoVAESEM_VS_M4_MF2,
          1373 => Opcode::PseudoVAESEM_VS_M4_MF4,
          1374 => Opcode::PseudoVAESEM_VS_M4_MF8,
          1375 => Opcode::PseudoVAESEM_VS_M8_M1,
          1376 => Opcode::PseudoVAESEM_VS_M8_M2,
          1377 => Opcode::PseudoVAESEM_VS_M8_M4,
          1378 => Opcode::PseudoVAESEM_VS_M8_MF2,
          1379 => Opcode::PseudoVAESEM_VS_M8_MF4,
          1380 => Opcode::PseudoVAESEM_VS_M8_MF8,
          1381 => Opcode::PseudoVAESEM_VS_MF2_MF2,
          1382 => Opcode::PseudoVAESEM_VS_MF2_MF4,
          1383 => Opcode::PseudoVAESEM_VS_MF2_MF8,
          1384 => Opcode::PseudoVAESEM_VV_M1,
          1385 => Opcode::PseudoVAESEM_VV_M2,
          1386 => Opcode::PseudoVAESEM_VV_M4,
          1387 => Opcode::PseudoVAESEM_VV_M8,
          1388 => Opcode::PseudoVAESEM_VV_MF2,
          1389 => Opcode::PseudoVAESKF1_VI_M1,
          1390 => Opcode::PseudoVAESKF1_VI_M2,
          1391 => Opcode::PseudoVAESKF1_VI_M4,
          1392 => Opcode::PseudoVAESKF1_VI_M8,
          1393 => Opcode::PseudoVAESKF1_VI_MF2,
          1394 => Opcode::PseudoVAESKF2_VI_M1,
          1395 => Opcode::PseudoVAESKF2_VI_M2,
          1396 => Opcode::PseudoVAESKF2_VI_M4,
          1397 => Opcode::PseudoVAESKF2_VI_M8,
          1398 => Opcode::PseudoVAESKF2_VI_MF2,
          1399 => Opcode::PseudoVAESZ_VS_M1_M1,
          1400 => Opcode::PseudoVAESZ_VS_M1_MF2,
          1401 => Opcode::PseudoVAESZ_VS_M1_MF4,
          1402 => Opcode::PseudoVAESZ_VS_M1_MF8,
          1403 => Opcode::PseudoVAESZ_VS_M2_M1,
          1404 => Opcode::PseudoVAESZ_VS_M2_M2,
          1405 => Opcode::PseudoVAESZ_VS_M2_MF2,
          1406 => Opcode::PseudoVAESZ_VS_M2_MF4,
          1407 => Opcode::PseudoVAESZ_VS_M2_MF8,
          1408 => Opcode::PseudoVAESZ_VS_M4_M1,
          1409 => Opcode::PseudoVAESZ_VS_M4_M2,
          1410 => Opcode::PseudoVAESZ_VS_M4_M4,
          1411 => Opcode::PseudoVAESZ_VS_M4_MF2,
          1412 => Opcode::PseudoVAESZ_VS_M4_MF4,
          1413 => Opcode::PseudoVAESZ_VS_M4_MF8,
          1414 => Opcode::PseudoVAESZ_VS_M8_M1,
          1415 => Opcode::PseudoVAESZ_VS_M8_M2,
          1416 => Opcode::PseudoVAESZ_VS_M8_M4,
          1417 => Opcode::PseudoVAESZ_VS_M8_MF2,
          1418 => Opcode::PseudoVAESZ_VS_M8_MF4,
          1419 => Opcode::PseudoVAESZ_VS_M8_MF8,
          1420 => Opcode::PseudoVAESZ_VS_MF2_MF2,
          1421 => Opcode::PseudoVAESZ_VS_MF2_MF4,
          1422 => Opcode::PseudoVAESZ_VS_MF2_MF8,
          1423 => Opcode::PseudoVANDN_VV_M1,
          1424 => Opcode::PseudoVANDN_VV_M1_MASK,
          1425 => Opcode::PseudoVANDN_VV_M2,
          1426 => Opcode::PseudoVANDN_VV_M2_MASK,
          1427 => Opcode::PseudoVANDN_VV_M4,
          1428 => Opcode::PseudoVANDN_VV_M4_MASK,
          1429 => Opcode::PseudoVANDN_VV_M8,
          1430 => Opcode::PseudoVANDN_VV_M8_MASK,
          1431 => Opcode::PseudoVANDN_VV_MF2,
          1432 => Opcode::PseudoVANDN_VV_MF2_MASK,
          1433 => Opcode::PseudoVANDN_VV_MF4,
          1434 => Opcode::PseudoVANDN_VV_MF4_MASK,
          1435 => Opcode::PseudoVANDN_VV_MF8,
          1436 => Opcode::PseudoVANDN_VV_MF8_MASK,
          1437 => Opcode::PseudoVANDN_VX_M1,
          1438 => Opcode::PseudoVANDN_VX_M1_MASK,
          1439 => Opcode::PseudoVANDN_VX_M2,
          1440 => Opcode::PseudoVANDN_VX_M2_MASK,
          1441 => Opcode::PseudoVANDN_VX_M4,
          1442 => Opcode::PseudoVANDN_VX_M4_MASK,
          1443 => Opcode::PseudoVANDN_VX_M8,
          1444 => Opcode::PseudoVANDN_VX_M8_MASK,
          1445 => Opcode::PseudoVANDN_VX_MF2,
          1446 => Opcode::PseudoVANDN_VX_MF2_MASK,
          1447 => Opcode::PseudoVANDN_VX_MF4,
          1448 => Opcode::PseudoVANDN_VX_MF4_MASK,
          1449 => Opcode::PseudoVANDN_VX_MF8,
          1450 => Opcode::PseudoVANDN_VX_MF8_MASK,
          1451 => Opcode::PseudoVAND_VI_M1,
          1452 => Opcode::PseudoVAND_VI_M1_MASK,
          1453 => Opcode::PseudoVAND_VI_M2,
          1454 => Opcode::PseudoVAND_VI_M2_MASK,
          1455 => Opcode::PseudoVAND_VI_M4,
          1456 => Opcode::PseudoVAND_VI_M4_MASK,
          1457 => Opcode::PseudoVAND_VI_M8,
          1458 => Opcode::PseudoVAND_VI_M8_MASK,
          1459 => Opcode::PseudoVAND_VI_MF2,
          1460 => Opcode::PseudoVAND_VI_MF2_MASK,
          1461 => Opcode::PseudoVAND_VI_MF4,
          1462 => Opcode::PseudoVAND_VI_MF4_MASK,
          1463 => Opcode::PseudoVAND_VI_MF8,
          1464 => Opcode::PseudoVAND_VI_MF8_MASK,
          1465 => Opcode::PseudoVAND_VV_M1,
          1466 => Opcode::PseudoVAND_VV_M1_MASK,
          1467 => Opcode::PseudoVAND_VV_M2,
          1468 => Opcode::PseudoVAND_VV_M2_MASK,
          1469 => Opcode::PseudoVAND_VV_M4,
          1470 => Opcode::PseudoVAND_VV_M4_MASK,
          1471 => Opcode::PseudoVAND_VV_M8,
          1472 => Opcode::PseudoVAND_VV_M8_MASK,
          1473 => Opcode::PseudoVAND_VV_MF2,
          1474 => Opcode::PseudoVAND_VV_MF2_MASK,
          1475 => Opcode::PseudoVAND_VV_MF4,
          1476 => Opcode::PseudoVAND_VV_MF4_MASK,
          1477 => Opcode::PseudoVAND_VV_MF8,
          1478 => Opcode::PseudoVAND_VV_MF8_MASK,
          1479 => Opcode::PseudoVAND_VX_M1,
          1480 => Opcode::PseudoVAND_VX_M1_MASK,
          1481 => Opcode::PseudoVAND_VX_M2,
          1482 => Opcode::PseudoVAND_VX_M2_MASK,
          1483 => Opcode::PseudoVAND_VX_M4,
          1484 => Opcode::PseudoVAND_VX_M4_MASK,
          1485 => Opcode::PseudoVAND_VX_M8,
          1486 => Opcode::PseudoVAND_VX_M8_MASK,
          1487 => Opcode::PseudoVAND_VX_MF2,
          1488 => Opcode::PseudoVAND_VX_MF2_MASK,
          1489 => Opcode::PseudoVAND_VX_MF4,
          1490 => Opcode::PseudoVAND_VX_MF4_MASK,
          1491 => Opcode::PseudoVAND_VX_MF8,
          1492 => Opcode::PseudoVAND_VX_MF8_MASK,
          1493 => Opcode::PseudoVASUBU_VV_M1,
          1494 => Opcode::PseudoVASUBU_VV_M1_MASK,
          1495 => Opcode::PseudoVASUBU_VV_M2,
          1496 => Opcode::PseudoVASUBU_VV_M2_MASK,
          1497 => Opcode::PseudoVASUBU_VV_M4,
          1498 => Opcode::PseudoVASUBU_VV_M4_MASK,
          1499 => Opcode::PseudoVASUBU_VV_M8,
          1500 => Opcode::PseudoVASUBU_VV_M8_MASK,
          1501 => Opcode::PseudoVASUBU_VV_MF2,
          1502 => Opcode::PseudoVASUBU_VV_MF2_MASK,
          1503 => Opcode::PseudoVASUBU_VV_MF4,
          1504 => Opcode::PseudoVASUBU_VV_MF4_MASK,
          1505 => Opcode::PseudoVASUBU_VV_MF8,
          1506 => Opcode::PseudoVASUBU_VV_MF8_MASK,
          1507 => Opcode::PseudoVASUBU_VX_M1,
          1508 => Opcode::PseudoVASUBU_VX_M1_MASK,
          1509 => Opcode::PseudoVASUBU_VX_M2,
          1510 => Opcode::PseudoVASUBU_VX_M2_MASK,
          1511 => Opcode::PseudoVASUBU_VX_M4,
          1512 => Opcode::PseudoVASUBU_VX_M4_MASK,
          1513 => Opcode::PseudoVASUBU_VX_M8,
          1514 => Opcode::PseudoVASUBU_VX_M8_MASK,
          1515 => Opcode::PseudoVASUBU_VX_MF2,
          1516 => Opcode::PseudoVASUBU_VX_MF2_MASK,
          1517 => Opcode::PseudoVASUBU_VX_MF4,
          1518 => Opcode::PseudoVASUBU_VX_MF4_MASK,
          1519 => Opcode::PseudoVASUBU_VX_MF8,
          1520 => Opcode::PseudoVASUBU_VX_MF8_MASK,
          1521 => Opcode::PseudoVASUB_VV_M1,
          1522 => Opcode::PseudoVASUB_VV_M1_MASK,
          1523 => Opcode::PseudoVASUB_VV_M2,
          1524 => Opcode::PseudoVASUB_VV_M2_MASK,
          1525 => Opcode::PseudoVASUB_VV_M4,
          1526 => Opcode::PseudoVASUB_VV_M4_MASK,
          1527 => Opcode::PseudoVASUB_VV_M8,
          1528 => Opcode::PseudoVASUB_VV_M8_MASK,
          1529 => Opcode::PseudoVASUB_VV_MF2,
          1530 => Opcode::PseudoVASUB_VV_MF2_MASK,
          1531 => Opcode::PseudoVASUB_VV_MF4,
          1532 => Opcode::PseudoVASUB_VV_MF4_MASK,
          1533 => Opcode::PseudoVASUB_VV_MF8,
          1534 => Opcode::PseudoVASUB_VV_MF8_MASK,
          1535 => Opcode::PseudoVASUB_VX_M1,
          1536 => Opcode::PseudoVASUB_VX_M1_MASK,
          1537 => Opcode::PseudoVASUB_VX_M2,
          1538 => Opcode::PseudoVASUB_VX_M2_MASK,
          1539 => Opcode::PseudoVASUB_VX_M4,
          1540 => Opcode::PseudoVASUB_VX_M4_MASK,
          1541 => Opcode::PseudoVASUB_VX_M8,
          1542 => Opcode::PseudoVASUB_VX_M8_MASK,
          1543 => Opcode::PseudoVASUB_VX_MF2,
          1544 => Opcode::PseudoVASUB_VX_MF2_MASK,
          1545 => Opcode::PseudoVASUB_VX_MF4,
          1546 => Opcode::PseudoVASUB_VX_MF4_MASK,
          1547 => Opcode::PseudoVASUB_VX_MF8,
          1548 => Opcode::PseudoVASUB_VX_MF8_MASK,
          1549 => Opcode::PseudoVBREV8_V_M1,
          1550 => Opcode::PseudoVBREV8_V_M1_MASK,
          1551 => Opcode::PseudoVBREV8_V_M2,
          1552 => Opcode::PseudoVBREV8_V_M2_MASK,
          1553 => Opcode::PseudoVBREV8_V_M4,
          1554 => Opcode::PseudoVBREV8_V_M4_MASK,
          1555 => Opcode::PseudoVBREV8_V_M8,
          1556 => Opcode::PseudoVBREV8_V_M8_MASK,
          1557 => Opcode::PseudoVBREV8_V_MF2,
          1558 => Opcode::PseudoVBREV8_V_MF2_MASK,
          1559 => Opcode::PseudoVBREV8_V_MF4,
          1560 => Opcode::PseudoVBREV8_V_MF4_MASK,
          1561 => Opcode::PseudoVBREV8_V_MF8,
          1562 => Opcode::PseudoVBREV8_V_MF8_MASK,
          1563 => Opcode::PseudoVBREV_V_M1,
          1564 => Opcode::PseudoVBREV_V_M1_MASK,
          1565 => Opcode::PseudoVBREV_V_M2,
          1566 => Opcode::PseudoVBREV_V_M2_MASK,
          1567 => Opcode::PseudoVBREV_V_M4,
          1568 => Opcode::PseudoVBREV_V_M4_MASK,
          1569 => Opcode::PseudoVBREV_V_M8,
          1570 => Opcode::PseudoVBREV_V_M8_MASK,
          1571 => Opcode::PseudoVBREV_V_MF2,
          1572 => Opcode::PseudoVBREV_V_MF2_MASK,
          1573 => Opcode::PseudoVBREV_V_MF4,
          1574 => Opcode::PseudoVBREV_V_MF4_MASK,
          1575 => Opcode::PseudoVBREV_V_MF8,
          1576 => Opcode::PseudoVBREV_V_MF8_MASK,
          1577 => Opcode::PseudoVCLMULH_VV_M1,
          1578 => Opcode::PseudoVCLMULH_VV_M1_MASK,
          1579 => Opcode::PseudoVCLMULH_VV_M2,
          1580 => Opcode::PseudoVCLMULH_VV_M2_MASK,
          1581 => Opcode::PseudoVCLMULH_VV_M4,
          1582 => Opcode::PseudoVCLMULH_VV_M4_MASK,
          1583 => Opcode::PseudoVCLMULH_VV_M8,
          1584 => Opcode::PseudoVCLMULH_VV_M8_MASK,
          1585 => Opcode::PseudoVCLMULH_VV_MF2,
          1586 => Opcode::PseudoVCLMULH_VV_MF2_MASK,
          1587 => Opcode::PseudoVCLMULH_VV_MF4,
          1588 => Opcode::PseudoVCLMULH_VV_MF4_MASK,
          1589 => Opcode::PseudoVCLMULH_VV_MF8,
          1590 => Opcode::PseudoVCLMULH_VV_MF8_MASK,
          1591 => Opcode::PseudoVCLMULH_VX_M1,
          1592 => Opcode::PseudoVCLMULH_VX_M1_MASK,
          1593 => Opcode::PseudoVCLMULH_VX_M2,
          1594 => Opcode::PseudoVCLMULH_VX_M2_MASK,
          1595 => Opcode::PseudoVCLMULH_VX_M4,
          1596 => Opcode::PseudoVCLMULH_VX_M4_MASK,
          1597 => Opcode::PseudoVCLMULH_VX_M8,
          1598 => Opcode::PseudoVCLMULH_VX_M8_MASK,
          1599 => Opcode::PseudoVCLMULH_VX_MF2,
          1600 => Opcode::PseudoVCLMULH_VX_MF2_MASK,
          1601 => Opcode::PseudoVCLMULH_VX_MF4,
          1602 => Opcode::PseudoVCLMULH_VX_MF4_MASK,
          1603 => Opcode::PseudoVCLMULH_VX_MF8,
          1604 => Opcode::PseudoVCLMULH_VX_MF8_MASK,
          1605 => Opcode::PseudoVCLMUL_VV_M1,
          1606 => Opcode::PseudoVCLMUL_VV_M1_MASK,
          1607 => Opcode::PseudoVCLMUL_VV_M2,
          1608 => Opcode::PseudoVCLMUL_VV_M2_MASK,
          1609 => Opcode::PseudoVCLMUL_VV_M4,
          1610 => Opcode::PseudoVCLMUL_VV_M4_MASK,
          1611 => Opcode::PseudoVCLMUL_VV_M8,
          1612 => Opcode::PseudoVCLMUL_VV_M8_MASK,
          1613 => Opcode::PseudoVCLMUL_VV_MF2,
          1614 => Opcode::PseudoVCLMUL_VV_MF2_MASK,
          1615 => Opcode::PseudoVCLMUL_VV_MF4,
          1616 => Opcode::PseudoVCLMUL_VV_MF4_MASK,
          1617 => Opcode::PseudoVCLMUL_VV_MF8,
          1618 => Opcode::PseudoVCLMUL_VV_MF8_MASK,
          1619 => Opcode::PseudoVCLMUL_VX_M1,
          1620 => Opcode::PseudoVCLMUL_VX_M1_MASK,
          1621 => Opcode::PseudoVCLMUL_VX_M2,
          1622 => Opcode::PseudoVCLMUL_VX_M2_MASK,
          1623 => Opcode::PseudoVCLMUL_VX_M4,
          1624 => Opcode::PseudoVCLMUL_VX_M4_MASK,
          1625 => Opcode::PseudoVCLMUL_VX_M8,
          1626 => Opcode::PseudoVCLMUL_VX_M8_MASK,
          1627 => Opcode::PseudoVCLMUL_VX_MF2,
          1628 => Opcode::PseudoVCLMUL_VX_MF2_MASK,
          1629 => Opcode::PseudoVCLMUL_VX_MF4,
          1630 => Opcode::PseudoVCLMUL_VX_MF4_MASK,
          1631 => Opcode::PseudoVCLMUL_VX_MF8,
          1632 => Opcode::PseudoVCLMUL_VX_MF8_MASK,
          1633 => Opcode::PseudoVCLZ_V_M1,
          1634 => Opcode::PseudoVCLZ_V_M1_MASK,
          1635 => Opcode::PseudoVCLZ_V_M2,
          1636 => Opcode::PseudoVCLZ_V_M2_MASK,
          1637 => Opcode::PseudoVCLZ_V_M4,
          1638 => Opcode::PseudoVCLZ_V_M4_MASK,
          1639 => Opcode::PseudoVCLZ_V_M8,
          1640 => Opcode::PseudoVCLZ_V_M8_MASK,
          1641 => Opcode::PseudoVCLZ_V_MF2,
          1642 => Opcode::PseudoVCLZ_V_MF2_MASK,
          1643 => Opcode::PseudoVCLZ_V_MF4,
          1644 => Opcode::PseudoVCLZ_V_MF4_MASK,
          1645 => Opcode::PseudoVCLZ_V_MF8,
          1646 => Opcode::PseudoVCLZ_V_MF8_MASK,
          1647 => Opcode::PseudoVCOMPRESS_VM_M1_E16,
          1648 => Opcode::PseudoVCOMPRESS_VM_M1_E32,
          1649 => Opcode::PseudoVCOMPRESS_VM_M1_E64,
          1650 => Opcode::PseudoVCOMPRESS_VM_M1_E8,
          1651 => Opcode::PseudoVCOMPRESS_VM_M2_E16,
          1652 => Opcode::PseudoVCOMPRESS_VM_M2_E32,
          1653 => Opcode::PseudoVCOMPRESS_VM_M2_E64,
          1654 => Opcode::PseudoVCOMPRESS_VM_M2_E8,
          1655 => Opcode::PseudoVCOMPRESS_VM_M4_E16,
          1656 => Opcode::PseudoVCOMPRESS_VM_M4_E32,
          1657 => Opcode::PseudoVCOMPRESS_VM_M4_E64,
          1658 => Opcode::PseudoVCOMPRESS_VM_M4_E8,
          1659 => Opcode::PseudoVCOMPRESS_VM_M8_E16,
          1660 => Opcode::PseudoVCOMPRESS_VM_M8_E32,
          1661 => Opcode::PseudoVCOMPRESS_VM_M8_E64,
          1662 => Opcode::PseudoVCOMPRESS_VM_M8_E8,
          1663 => Opcode::PseudoVCOMPRESS_VM_MF2_E16,
          1664 => Opcode::PseudoVCOMPRESS_VM_MF2_E32,
          1665 => Opcode::PseudoVCOMPRESS_VM_MF2_E8,
          1666 => Opcode::PseudoVCOMPRESS_VM_MF4_E16,
          1667 => Opcode::PseudoVCOMPRESS_VM_MF4_E8,
          1668 => Opcode::PseudoVCOMPRESS_VM_MF8_E8,
          1669 => Opcode::PseudoVCPOP_M_B1,
          1670 => Opcode::PseudoVCPOP_M_B16,
          1671 => Opcode::PseudoVCPOP_M_B16_MASK,
          1672 => Opcode::PseudoVCPOP_M_B1_MASK,
          1673 => Opcode::PseudoVCPOP_M_B2,
          1674 => Opcode::PseudoVCPOP_M_B2_MASK,
          1675 => Opcode::PseudoVCPOP_M_B32,
          1676 => Opcode::PseudoVCPOP_M_B32_MASK,
          1677 => Opcode::PseudoVCPOP_M_B4,
          1678 => Opcode::PseudoVCPOP_M_B4_MASK,
          1679 => Opcode::PseudoVCPOP_M_B64,
          1680 => Opcode::PseudoVCPOP_M_B64_MASK,
          1681 => Opcode::PseudoVCPOP_M_B8,
          1682 => Opcode::PseudoVCPOP_M_B8_MASK,
          1683 => Opcode::PseudoVCPOP_V_M1,
          1684 => Opcode::PseudoVCPOP_V_M1_MASK,
          1685 => Opcode::PseudoVCPOP_V_M2,
          1686 => Opcode::PseudoVCPOP_V_M2_MASK,
          1687 => Opcode::PseudoVCPOP_V_M4,
          1688 => Opcode::PseudoVCPOP_V_M4_MASK,
          1689 => Opcode::PseudoVCPOP_V_M8,
          1690 => Opcode::PseudoVCPOP_V_M8_MASK,
          1691 => Opcode::PseudoVCPOP_V_MF2,
          1692 => Opcode::PseudoVCPOP_V_MF2_MASK,
          1693 => Opcode::PseudoVCPOP_V_MF4,
          1694 => Opcode::PseudoVCPOP_V_MF4_MASK,
          1695 => Opcode::PseudoVCPOP_V_MF8,
          1696 => Opcode::PseudoVCPOP_V_MF8_MASK,
          1697 => Opcode::PseudoVCTZ_V_M1,
          1698 => Opcode::PseudoVCTZ_V_M1_MASK,
          1699 => Opcode::PseudoVCTZ_V_M2,
          1700 => Opcode::PseudoVCTZ_V_M2_MASK,
          1701 => Opcode::PseudoVCTZ_V_M4,
          1702 => Opcode::PseudoVCTZ_V_M4_MASK,
          1703 => Opcode::PseudoVCTZ_V_M8,
          1704 => Opcode::PseudoVCTZ_V_M8_MASK,
          1705 => Opcode::PseudoVCTZ_V_MF2,
          1706 => Opcode::PseudoVCTZ_V_MF2_MASK,
          1707 => Opcode::PseudoVCTZ_V_MF4,
          1708 => Opcode::PseudoVCTZ_V_MF4_MASK,
          1709 => Opcode::PseudoVCTZ_V_MF8,
          1710 => Opcode::PseudoVCTZ_V_MF8_MASK,
          1711 => Opcode::PseudoVDIVU_VV_M1_E16,
          1712 => Opcode::PseudoVDIVU_VV_M1_E16_MASK,
          1713 => Opcode::PseudoVDIVU_VV_M1_E32,
          1714 => Opcode::PseudoVDIVU_VV_M1_E32_MASK,
          1715 => Opcode::PseudoVDIVU_VV_M1_E64,
          1716 => Opcode::PseudoVDIVU_VV_M1_E64_MASK,
          1717 => Opcode::PseudoVDIVU_VV_M1_E8,
          1718 => Opcode::PseudoVDIVU_VV_M1_E8_MASK,
          1719 => Opcode::PseudoVDIVU_VV_M2_E16,
          1720 => Opcode::PseudoVDIVU_VV_M2_E16_MASK,
          1721 => Opcode::PseudoVDIVU_VV_M2_E32,
          1722 => Opcode::PseudoVDIVU_VV_M2_E32_MASK,
          1723 => Opcode::PseudoVDIVU_VV_M2_E64,
          1724 => Opcode::PseudoVDIVU_VV_M2_E64_MASK,
          1725 => Opcode::PseudoVDIVU_VV_M2_E8,
          1726 => Opcode::PseudoVDIVU_VV_M2_E8_MASK,
          1727 => Opcode::PseudoVDIVU_VV_M4_E16,
          1728 => Opcode::PseudoVDIVU_VV_M4_E16_MASK,
          1729 => Opcode::PseudoVDIVU_VV_M4_E32,
          1730 => Opcode::PseudoVDIVU_VV_M4_E32_MASK,
          1731 => Opcode::PseudoVDIVU_VV_M4_E64,
          1732 => Opcode::PseudoVDIVU_VV_M4_E64_MASK,
          1733 => Opcode::PseudoVDIVU_VV_M4_E8,
          1734 => Opcode::PseudoVDIVU_VV_M4_E8_MASK,
          1735 => Opcode::PseudoVDIVU_VV_M8_E16,
          1736 => Opcode::PseudoVDIVU_VV_M8_E16_MASK,
          1737 => Opcode::PseudoVDIVU_VV_M8_E32,
          1738 => Opcode::PseudoVDIVU_VV_M8_E32_MASK,
          1739 => Opcode::PseudoVDIVU_VV_M8_E64,
          1740 => Opcode::PseudoVDIVU_VV_M8_E64_MASK,
          1741 => Opcode::PseudoVDIVU_VV_M8_E8,
          1742 => Opcode::PseudoVDIVU_VV_M8_E8_MASK,
          1743 => Opcode::PseudoVDIVU_VV_MF2_E16,
          1744 => Opcode::PseudoVDIVU_VV_MF2_E16_MASK,
          1745 => Opcode::PseudoVDIVU_VV_MF2_E32,
          1746 => Opcode::PseudoVDIVU_VV_MF2_E32_MASK,
          1747 => Opcode::PseudoVDIVU_VV_MF2_E8,
          1748 => Opcode::PseudoVDIVU_VV_MF2_E8_MASK,
          1749 => Opcode::PseudoVDIVU_VV_MF4_E16,
          1750 => Opcode::PseudoVDIVU_VV_MF4_E16_MASK,
          1751 => Opcode::PseudoVDIVU_VV_MF4_E8,
          1752 => Opcode::PseudoVDIVU_VV_MF4_E8_MASK,
          1753 => Opcode::PseudoVDIVU_VV_MF8_E8,
          1754 => Opcode::PseudoVDIVU_VV_MF8_E8_MASK,
          1755 => Opcode::PseudoVDIVU_VX_M1_E16,
          1756 => Opcode::PseudoVDIVU_VX_M1_E16_MASK,
          1757 => Opcode::PseudoVDIVU_VX_M1_E32,
          1758 => Opcode::PseudoVDIVU_VX_M1_E32_MASK,
          1759 => Opcode::PseudoVDIVU_VX_M1_E64,
          1760 => Opcode::PseudoVDIVU_VX_M1_E64_MASK,
          1761 => Opcode::PseudoVDIVU_VX_M1_E8,
          1762 => Opcode::PseudoVDIVU_VX_M1_E8_MASK,
          1763 => Opcode::PseudoVDIVU_VX_M2_E16,
          1764 => Opcode::PseudoVDIVU_VX_M2_E16_MASK,
          1765 => Opcode::PseudoVDIVU_VX_M2_E32,
          1766 => Opcode::PseudoVDIVU_VX_M2_E32_MASK,
          1767 => Opcode::PseudoVDIVU_VX_M2_E64,
          1768 => Opcode::PseudoVDIVU_VX_M2_E64_MASK,
          1769 => Opcode::PseudoVDIVU_VX_M2_E8,
          1770 => Opcode::PseudoVDIVU_VX_M2_E8_MASK,
          1771 => Opcode::PseudoVDIVU_VX_M4_E16,
          1772 => Opcode::PseudoVDIVU_VX_M4_E16_MASK,
          1773 => Opcode::PseudoVDIVU_VX_M4_E32,
          1774 => Opcode::PseudoVDIVU_VX_M4_E32_MASK,
          1775 => Opcode::PseudoVDIVU_VX_M4_E64,
          1776 => Opcode::PseudoVDIVU_VX_M4_E64_MASK,
          1777 => Opcode::PseudoVDIVU_VX_M4_E8,
          1778 => Opcode::PseudoVDIVU_VX_M4_E8_MASK,
          1779 => Opcode::PseudoVDIVU_VX_M8_E16,
          1780 => Opcode::PseudoVDIVU_VX_M8_E16_MASK,
          1781 => Opcode::PseudoVDIVU_VX_M8_E32,
          1782 => Opcode::PseudoVDIVU_VX_M8_E32_MASK,
          1783 => Opcode::PseudoVDIVU_VX_M8_E64,
          1784 => Opcode::PseudoVDIVU_VX_M8_E64_MASK,
          1785 => Opcode::PseudoVDIVU_VX_M8_E8,
          1786 => Opcode::PseudoVDIVU_VX_M8_E8_MASK,
          1787 => Opcode::PseudoVDIVU_VX_MF2_E16,
          1788 => Opcode::PseudoVDIVU_VX_MF2_E16_MASK,
          1789 => Opcode::PseudoVDIVU_VX_MF2_E32,
          1790 => Opcode::PseudoVDIVU_VX_MF2_E32_MASK,
          1791 => Opcode::PseudoVDIVU_VX_MF2_E8,
          1792 => Opcode::PseudoVDIVU_VX_MF2_E8_MASK,
          1793 => Opcode::PseudoVDIVU_VX_MF4_E16,
          1794 => Opcode::PseudoVDIVU_VX_MF4_E16_MASK,
          1795 => Opcode::PseudoVDIVU_VX_MF4_E8,
          1796 => Opcode::PseudoVDIVU_VX_MF4_E8_MASK,
          1797 => Opcode::PseudoVDIVU_VX_MF8_E8,
          1798 => Opcode::PseudoVDIVU_VX_MF8_E8_MASK,
          1799 => Opcode::PseudoVDIV_VV_M1_E16,
          1800 => Opcode::PseudoVDIV_VV_M1_E16_MASK,
          1801 => Opcode::PseudoVDIV_VV_M1_E32,
          1802 => Opcode::PseudoVDIV_VV_M1_E32_MASK,
          1803 => Opcode::PseudoVDIV_VV_M1_E64,
          1804 => Opcode::PseudoVDIV_VV_M1_E64_MASK,
          1805 => Opcode::PseudoVDIV_VV_M1_E8,
          1806 => Opcode::PseudoVDIV_VV_M1_E8_MASK,
          1807 => Opcode::PseudoVDIV_VV_M2_E16,
          1808 => Opcode::PseudoVDIV_VV_M2_E16_MASK,
          1809 => Opcode::PseudoVDIV_VV_M2_E32,
          1810 => Opcode::PseudoVDIV_VV_M2_E32_MASK,
          1811 => Opcode::PseudoVDIV_VV_M2_E64,
          1812 => Opcode::PseudoVDIV_VV_M2_E64_MASK,
          1813 => Opcode::PseudoVDIV_VV_M2_E8,
          1814 => Opcode::PseudoVDIV_VV_M2_E8_MASK,
          1815 => Opcode::PseudoVDIV_VV_M4_E16,
          1816 => Opcode::PseudoVDIV_VV_M4_E16_MASK,
          1817 => Opcode::PseudoVDIV_VV_M4_E32,
          1818 => Opcode::PseudoVDIV_VV_M4_E32_MASK,
          1819 => Opcode::PseudoVDIV_VV_M4_E64,
          1820 => Opcode::PseudoVDIV_VV_M4_E64_MASK,
          1821 => Opcode::PseudoVDIV_VV_M4_E8,
          1822 => Opcode::PseudoVDIV_VV_M4_E8_MASK,
          1823 => Opcode::PseudoVDIV_VV_M8_E16,
          1824 => Opcode::PseudoVDIV_VV_M8_E16_MASK,
          1825 => Opcode::PseudoVDIV_VV_M8_E32,
          1826 => Opcode::PseudoVDIV_VV_M8_E32_MASK,
          1827 => Opcode::PseudoVDIV_VV_M8_E64,
          1828 => Opcode::PseudoVDIV_VV_M8_E64_MASK,
          1829 => Opcode::PseudoVDIV_VV_M8_E8,
          1830 => Opcode::PseudoVDIV_VV_M8_E8_MASK,
          1831 => Opcode::PseudoVDIV_VV_MF2_E16,
          1832 => Opcode::PseudoVDIV_VV_MF2_E16_MASK,
          1833 => Opcode::PseudoVDIV_VV_MF2_E32,
          1834 => Opcode::PseudoVDIV_VV_MF2_E32_MASK,
          1835 => Opcode::PseudoVDIV_VV_MF2_E8,
          1836 => Opcode::PseudoVDIV_VV_MF2_E8_MASK,
          1837 => Opcode::PseudoVDIV_VV_MF4_E16,
          1838 => Opcode::PseudoVDIV_VV_MF4_E16_MASK,
          1839 => Opcode::PseudoVDIV_VV_MF4_E8,
          1840 => Opcode::PseudoVDIV_VV_MF4_E8_MASK,
          1841 => Opcode::PseudoVDIV_VV_MF8_E8,
          1842 => Opcode::PseudoVDIV_VV_MF8_E8_MASK,
          1843 => Opcode::PseudoVDIV_VX_M1_E16,
          1844 => Opcode::PseudoVDIV_VX_M1_E16_MASK,
          1845 => Opcode::PseudoVDIV_VX_M1_E32,
          1846 => Opcode::PseudoVDIV_VX_M1_E32_MASK,
          1847 => Opcode::PseudoVDIV_VX_M1_E64,
          1848 => Opcode::PseudoVDIV_VX_M1_E64_MASK,
          1849 => Opcode::PseudoVDIV_VX_M1_E8,
          1850 => Opcode::PseudoVDIV_VX_M1_E8_MASK,
          1851 => Opcode::PseudoVDIV_VX_M2_E16,
          1852 => Opcode::PseudoVDIV_VX_M2_E16_MASK,
          1853 => Opcode::PseudoVDIV_VX_M2_E32,
          1854 => Opcode::PseudoVDIV_VX_M2_E32_MASK,
          1855 => Opcode::PseudoVDIV_VX_M2_E64,
          1856 => Opcode::PseudoVDIV_VX_M2_E64_MASK,
          1857 => Opcode::PseudoVDIV_VX_M2_E8,
          1858 => Opcode::PseudoVDIV_VX_M2_E8_MASK,
          1859 => Opcode::PseudoVDIV_VX_M4_E16,
          1860 => Opcode::PseudoVDIV_VX_M4_E16_MASK,
          1861 => Opcode::PseudoVDIV_VX_M4_E32,
          1862 => Opcode::PseudoVDIV_VX_M4_E32_MASK,
          1863 => Opcode::PseudoVDIV_VX_M4_E64,
          1864 => Opcode::PseudoVDIV_VX_M4_E64_MASK,
          1865 => Opcode::PseudoVDIV_VX_M4_E8,
          1866 => Opcode::PseudoVDIV_VX_M4_E8_MASK,
          1867 => Opcode::PseudoVDIV_VX_M8_E16,
          1868 => Opcode::PseudoVDIV_VX_M8_E16_MASK,
          1869 => Opcode::PseudoVDIV_VX_M8_E32,
          1870 => Opcode::PseudoVDIV_VX_M8_E32_MASK,
          1871 => Opcode::PseudoVDIV_VX_M8_E64,
          1872 => Opcode::PseudoVDIV_VX_M8_E64_MASK,
          1873 => Opcode::PseudoVDIV_VX_M8_E8,
          1874 => Opcode::PseudoVDIV_VX_M8_E8_MASK,
          1875 => Opcode::PseudoVDIV_VX_MF2_E16,
          1876 => Opcode::PseudoVDIV_VX_MF2_E16_MASK,
          1877 => Opcode::PseudoVDIV_VX_MF2_E32,
          1878 => Opcode::PseudoVDIV_VX_MF2_E32_MASK,
          1879 => Opcode::PseudoVDIV_VX_MF2_E8,
          1880 => Opcode::PseudoVDIV_VX_MF2_E8_MASK,
          1881 => Opcode::PseudoVDIV_VX_MF4_E16,
          1882 => Opcode::PseudoVDIV_VX_MF4_E16_MASK,
          1883 => Opcode::PseudoVDIV_VX_MF4_E8,
          1884 => Opcode::PseudoVDIV_VX_MF4_E8_MASK,
          1885 => Opcode::PseudoVDIV_VX_MF8_E8,
          1886 => Opcode::PseudoVDIV_VX_MF8_E8_MASK,
          1887 => Opcode::PseudoVFADD_VFPR16_M1_E16,
          1888 => Opcode::PseudoVFADD_VFPR16_M1_E16_MASK,
          1889 => Opcode::PseudoVFADD_VFPR16_M2_E16,
          1890 => Opcode::PseudoVFADD_VFPR16_M2_E16_MASK,
          1891 => Opcode::PseudoVFADD_VFPR16_M4_E16,
          1892 => Opcode::PseudoVFADD_VFPR16_M4_E16_MASK,
          1893 => Opcode::PseudoVFADD_VFPR16_M8_E16,
          1894 => Opcode::PseudoVFADD_VFPR16_M8_E16_MASK,
          1895 => Opcode::PseudoVFADD_VFPR16_MF2_E16,
          1896 => Opcode::PseudoVFADD_VFPR16_MF2_E16_MASK,
          1897 => Opcode::PseudoVFADD_VFPR16_MF4_E16,
          1898 => Opcode::PseudoVFADD_VFPR16_MF4_E16_MASK,
          1899 => Opcode::PseudoVFADD_VFPR32_M1_E32,
          1900 => Opcode::PseudoVFADD_VFPR32_M1_E32_MASK,
          1901 => Opcode::PseudoVFADD_VFPR32_M2_E32,
          1902 => Opcode::PseudoVFADD_VFPR32_M2_E32_MASK,
          1903 => Opcode::PseudoVFADD_VFPR32_M4_E32,
          1904 => Opcode::PseudoVFADD_VFPR32_M4_E32_MASK,
          1905 => Opcode::PseudoVFADD_VFPR32_M8_E32,
          1906 => Opcode::PseudoVFADD_VFPR32_M8_E32_MASK,
          1907 => Opcode::PseudoVFADD_VFPR32_MF2_E32,
          1908 => Opcode::PseudoVFADD_VFPR32_MF2_E32_MASK,
          1909 => Opcode::PseudoVFADD_VFPR64_M1_E64,
          1910 => Opcode::PseudoVFADD_VFPR64_M1_E64_MASK,
          1911 => Opcode::PseudoVFADD_VFPR64_M2_E64,
          1912 => Opcode::PseudoVFADD_VFPR64_M2_E64_MASK,
          1913 => Opcode::PseudoVFADD_VFPR64_M4_E64,
          1914 => Opcode::PseudoVFADD_VFPR64_M4_E64_MASK,
          1915 => Opcode::PseudoVFADD_VFPR64_M8_E64,
          1916 => Opcode::PseudoVFADD_VFPR64_M8_E64_MASK,
          1917 => Opcode::PseudoVFADD_VV_M1_E16,
          1918 => Opcode::PseudoVFADD_VV_M1_E16_MASK,
          1919 => Opcode::PseudoVFADD_VV_M1_E32,
          1920 => Opcode::PseudoVFADD_VV_M1_E32_MASK,
          1921 => Opcode::PseudoVFADD_VV_M1_E64,
          1922 => Opcode::PseudoVFADD_VV_M1_E64_MASK,
          1923 => Opcode::PseudoVFADD_VV_M2_E16,
          1924 => Opcode::PseudoVFADD_VV_M2_E16_MASK,
          1925 => Opcode::PseudoVFADD_VV_M2_E32,
          1926 => Opcode::PseudoVFADD_VV_M2_E32_MASK,
          1927 => Opcode::PseudoVFADD_VV_M2_E64,
          1928 => Opcode::PseudoVFADD_VV_M2_E64_MASK,
          1929 => Opcode::PseudoVFADD_VV_M4_E16,
          1930 => Opcode::PseudoVFADD_VV_M4_E16_MASK,
          1931 => Opcode::PseudoVFADD_VV_M4_E32,
          1932 => Opcode::PseudoVFADD_VV_M4_E32_MASK,
          1933 => Opcode::PseudoVFADD_VV_M4_E64,
          1934 => Opcode::PseudoVFADD_VV_M4_E64_MASK,
          1935 => Opcode::PseudoVFADD_VV_M8_E16,
          1936 => Opcode::PseudoVFADD_VV_M8_E16_MASK,
          1937 => Opcode::PseudoVFADD_VV_M8_E32,
          1938 => Opcode::PseudoVFADD_VV_M8_E32_MASK,
          1939 => Opcode::PseudoVFADD_VV_M8_E64,
          1940 => Opcode::PseudoVFADD_VV_M8_E64_MASK,
          1941 => Opcode::PseudoVFADD_VV_MF2_E16,
          1942 => Opcode::PseudoVFADD_VV_MF2_E16_MASK,
          1943 => Opcode::PseudoVFADD_VV_MF2_E32,
          1944 => Opcode::PseudoVFADD_VV_MF2_E32_MASK,
          1945 => Opcode::PseudoVFADD_VV_MF4_E16,
          1946 => Opcode::PseudoVFADD_VV_MF4_E16_MASK,
          1947 => Opcode::PseudoVFCLASS_V_M1,
          1948 => Opcode::PseudoVFCLASS_V_M1_MASK,
          1949 => Opcode::PseudoVFCLASS_V_M2,
          1950 => Opcode::PseudoVFCLASS_V_M2_MASK,
          1951 => Opcode::PseudoVFCLASS_V_M4,
          1952 => Opcode::PseudoVFCLASS_V_M4_MASK,
          1953 => Opcode::PseudoVFCLASS_V_M8,
          1954 => Opcode::PseudoVFCLASS_V_M8_MASK,
          1955 => Opcode::PseudoVFCLASS_V_MF2,
          1956 => Opcode::PseudoVFCLASS_V_MF2_MASK,
          1957 => Opcode::PseudoVFCLASS_V_MF4,
          1958 => Opcode::PseudoVFCLASS_V_MF4_MASK,
          1959 => Opcode::PseudoVFCVT_F_XU_V_M1_E16,
          1960 => Opcode::PseudoVFCVT_F_XU_V_M1_E16_MASK,
          1961 => Opcode::PseudoVFCVT_F_XU_V_M1_E32,
          1962 => Opcode::PseudoVFCVT_F_XU_V_M1_E32_MASK,
          1963 => Opcode::PseudoVFCVT_F_XU_V_M1_E64,
          1964 => Opcode::PseudoVFCVT_F_XU_V_M1_E64_MASK,
          1965 => Opcode::PseudoVFCVT_F_XU_V_M2_E16,
          1966 => Opcode::PseudoVFCVT_F_XU_V_M2_E16_MASK,
          1967 => Opcode::PseudoVFCVT_F_XU_V_M2_E32,
          1968 => Opcode::PseudoVFCVT_F_XU_V_M2_E32_MASK,
          1969 => Opcode::PseudoVFCVT_F_XU_V_M2_E64,
          1970 => Opcode::PseudoVFCVT_F_XU_V_M2_E64_MASK,
          1971 => Opcode::PseudoVFCVT_F_XU_V_M4_E16,
          1972 => Opcode::PseudoVFCVT_F_XU_V_M4_E16_MASK,
          1973 => Opcode::PseudoVFCVT_F_XU_V_M4_E32,
          1974 => Opcode::PseudoVFCVT_F_XU_V_M4_E32_MASK,
          1975 => Opcode::PseudoVFCVT_F_XU_V_M4_E64,
          1976 => Opcode::PseudoVFCVT_F_XU_V_M4_E64_MASK,
          1977 => Opcode::PseudoVFCVT_F_XU_V_M8_E16,
          1978 => Opcode::PseudoVFCVT_F_XU_V_M8_E16_MASK,
          1979 => Opcode::PseudoVFCVT_F_XU_V_M8_E32,
          1980 => Opcode::PseudoVFCVT_F_XU_V_M8_E32_MASK,
          1981 => Opcode::PseudoVFCVT_F_XU_V_M8_E64,
          1982 => Opcode::PseudoVFCVT_F_XU_V_M8_E64_MASK,
          1983 => Opcode::PseudoVFCVT_F_XU_V_MF2_E16,
          1984 => Opcode::PseudoVFCVT_F_XU_V_MF2_E16_MASK,
          1985 => Opcode::PseudoVFCVT_F_XU_V_MF2_E32,
          1986 => Opcode::PseudoVFCVT_F_XU_V_MF2_E32_MASK,
          1987 => Opcode::PseudoVFCVT_F_XU_V_MF4_E16,
          1988 => Opcode::PseudoVFCVT_F_XU_V_MF4_E16_MASK,
          1989 => Opcode::PseudoVFCVT_F_X_V_M1_E16,
          1990 => Opcode::PseudoVFCVT_F_X_V_M1_E16_MASK,
          1991 => Opcode::PseudoVFCVT_F_X_V_M1_E32,
          1992 => Opcode::PseudoVFCVT_F_X_V_M1_E32_MASK,
          1993 => Opcode::PseudoVFCVT_F_X_V_M1_E64,
          1994 => Opcode::PseudoVFCVT_F_X_V_M1_E64_MASK,
          1995 => Opcode::PseudoVFCVT_F_X_V_M2_E16,
          1996 => Opcode::PseudoVFCVT_F_X_V_M2_E16_MASK,
          1997 => Opcode::PseudoVFCVT_F_X_V_M2_E32,
          1998 => Opcode::PseudoVFCVT_F_X_V_M2_E32_MASK,
          1999 => Opcode::PseudoVFCVT_F_X_V_M2_E64,
          2000 => Opcode::PseudoVFCVT_F_X_V_M2_E64_MASK,
          2001 => Opcode::PseudoVFCVT_F_X_V_M4_E16,
          2002 => Opcode::PseudoVFCVT_F_X_V_M4_E16_MASK,
          2003 => Opcode::PseudoVFCVT_F_X_V_M4_E32,
          2004 => Opcode::PseudoVFCVT_F_X_V_M4_E32_MASK,
          2005 => Opcode::PseudoVFCVT_F_X_V_M4_E64,
          2006 => Opcode::PseudoVFCVT_F_X_V_M4_E64_MASK,
          2007 => Opcode::PseudoVFCVT_F_X_V_M8_E16,
          2008 => Opcode::PseudoVFCVT_F_X_V_M8_E16_MASK,
          2009 => Opcode::PseudoVFCVT_F_X_V_M8_E32,
          2010 => Opcode::PseudoVFCVT_F_X_V_M8_E32_MASK,
          2011 => Opcode::PseudoVFCVT_F_X_V_M8_E64,
          2012 => Opcode::PseudoVFCVT_F_X_V_M8_E64_MASK,
          2013 => Opcode::PseudoVFCVT_F_X_V_MF2_E16,
          2014 => Opcode::PseudoVFCVT_F_X_V_MF2_E16_MASK,
          2015 => Opcode::PseudoVFCVT_F_X_V_MF2_E32,
          2016 => Opcode::PseudoVFCVT_F_X_V_MF2_E32_MASK,
          2017 => Opcode::PseudoVFCVT_F_X_V_MF4_E16,
          2018 => Opcode::PseudoVFCVT_F_X_V_MF4_E16_MASK,
          2019 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M1,
          2020 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M1_MASK,
          2021 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M2,
          2022 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M2_MASK,
          2023 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M4,
          2024 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M4_MASK,
          2025 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M8,
          2026 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M8_MASK,
          2027 => Opcode::PseudoVFCVT_RTZ_XU_F_V_MF2,
          2028 => Opcode::PseudoVFCVT_RTZ_XU_F_V_MF2_MASK,
          2029 => Opcode::PseudoVFCVT_RTZ_XU_F_V_MF4,
          2030 => Opcode::PseudoVFCVT_RTZ_XU_F_V_MF4_MASK,
          2031 => Opcode::PseudoVFCVT_RTZ_X_F_V_M1,
          2032 => Opcode::PseudoVFCVT_RTZ_X_F_V_M1_MASK,
          2033 => Opcode::PseudoVFCVT_RTZ_X_F_V_M2,
          2034 => Opcode::PseudoVFCVT_RTZ_X_F_V_M2_MASK,
          2035 => Opcode::PseudoVFCVT_RTZ_X_F_V_M4,
          2036 => Opcode::PseudoVFCVT_RTZ_X_F_V_M4_MASK,
          2037 => Opcode::PseudoVFCVT_RTZ_X_F_V_M8,
          2038 => Opcode::PseudoVFCVT_RTZ_X_F_V_M8_MASK,
          2039 => Opcode::PseudoVFCVT_RTZ_X_F_V_MF2,
          2040 => Opcode::PseudoVFCVT_RTZ_X_F_V_MF2_MASK,
          2041 => Opcode::PseudoVFCVT_RTZ_X_F_V_MF4,
          2042 => Opcode::PseudoVFCVT_RTZ_X_F_V_MF4_MASK,
          2043 => Opcode::PseudoVFCVT_XU_F_V_M1,
          2044 => Opcode::PseudoVFCVT_XU_F_V_M1_MASK,
          2045 => Opcode::PseudoVFCVT_XU_F_V_M2,
          2046 => Opcode::PseudoVFCVT_XU_F_V_M2_MASK,
          2047 => Opcode::PseudoVFCVT_XU_F_V_M4,
          2048 => Opcode::PseudoVFCVT_XU_F_V_M4_MASK,
          2049 => Opcode::PseudoVFCVT_XU_F_V_M8,
          2050 => Opcode::PseudoVFCVT_XU_F_V_M8_MASK,
          2051 => Opcode::PseudoVFCVT_XU_F_V_MF2,
          2052 => Opcode::PseudoVFCVT_XU_F_V_MF2_MASK,
          2053 => Opcode::PseudoVFCVT_XU_F_V_MF4,
          2054 => Opcode::PseudoVFCVT_XU_F_V_MF4_MASK,
          2055 => Opcode::PseudoVFCVT_X_F_V_M1,
          2056 => Opcode::PseudoVFCVT_X_F_V_M1_MASK,
          2057 => Opcode::PseudoVFCVT_X_F_V_M2,
          2058 => Opcode::PseudoVFCVT_X_F_V_M2_MASK,
          2059 => Opcode::PseudoVFCVT_X_F_V_M4,
          2060 => Opcode::PseudoVFCVT_X_F_V_M4_MASK,
          2061 => Opcode::PseudoVFCVT_X_F_V_M8,
          2062 => Opcode::PseudoVFCVT_X_F_V_M8_MASK,
          2063 => Opcode::PseudoVFCVT_X_F_V_MF2,
          2064 => Opcode::PseudoVFCVT_X_F_V_MF2_MASK,
          2065 => Opcode::PseudoVFCVT_X_F_V_MF4,
          2066 => Opcode::PseudoVFCVT_X_F_V_MF4_MASK,
          2067 => Opcode::PseudoVFDIV_VFPR16_M1_E16,
          2068 => Opcode::PseudoVFDIV_VFPR16_M1_E16_MASK,
          2069 => Opcode::PseudoVFDIV_VFPR16_M2_E16,
          2070 => Opcode::PseudoVFDIV_VFPR16_M2_E16_MASK,
          2071 => Opcode::PseudoVFDIV_VFPR16_M4_E16,
          2072 => Opcode::PseudoVFDIV_VFPR16_M4_E16_MASK,
          2073 => Opcode::PseudoVFDIV_VFPR16_M8_E16,
          2074 => Opcode::PseudoVFDIV_VFPR16_M8_E16_MASK,
          2075 => Opcode::PseudoVFDIV_VFPR16_MF2_E16,
          2076 => Opcode::PseudoVFDIV_VFPR16_MF2_E16_MASK,
          2077 => Opcode::PseudoVFDIV_VFPR16_MF4_E16,
          2078 => Opcode::PseudoVFDIV_VFPR16_MF4_E16_MASK,
          2079 => Opcode::PseudoVFDIV_VFPR32_M1_E32,
          2080 => Opcode::PseudoVFDIV_VFPR32_M1_E32_MASK,
          2081 => Opcode::PseudoVFDIV_VFPR32_M2_E32,
          2082 => Opcode::PseudoVFDIV_VFPR32_M2_E32_MASK,
          2083 => Opcode::PseudoVFDIV_VFPR32_M4_E32,
          2084 => Opcode::PseudoVFDIV_VFPR32_M4_E32_MASK,
          2085 => Opcode::PseudoVFDIV_VFPR32_M8_E32,
          2086 => Opcode::PseudoVFDIV_VFPR32_M8_E32_MASK,
          2087 => Opcode::PseudoVFDIV_VFPR32_MF2_E32,
          2088 => Opcode::PseudoVFDIV_VFPR32_MF2_E32_MASK,
          2089 => Opcode::PseudoVFDIV_VFPR64_M1_E64,
          2090 => Opcode::PseudoVFDIV_VFPR64_M1_E64_MASK,
          2091 => Opcode::PseudoVFDIV_VFPR64_M2_E64,
          2092 => Opcode::PseudoVFDIV_VFPR64_M2_E64_MASK,
          2093 => Opcode::PseudoVFDIV_VFPR64_M4_E64,
          2094 => Opcode::PseudoVFDIV_VFPR64_M4_E64_MASK,
          2095 => Opcode::PseudoVFDIV_VFPR64_M8_E64,
          2096 => Opcode::PseudoVFDIV_VFPR64_M8_E64_MASK,
          2097 => Opcode::PseudoVFDIV_VV_M1_E16,
          2098 => Opcode::PseudoVFDIV_VV_M1_E16_MASK,
          2099 => Opcode::PseudoVFDIV_VV_M1_E32,
          2100 => Opcode::PseudoVFDIV_VV_M1_E32_MASK,
          2101 => Opcode::PseudoVFDIV_VV_M1_E64,
          2102 => Opcode::PseudoVFDIV_VV_M1_E64_MASK,
          2103 => Opcode::PseudoVFDIV_VV_M2_E16,
          2104 => Opcode::PseudoVFDIV_VV_M2_E16_MASK,
          2105 => Opcode::PseudoVFDIV_VV_M2_E32,
          2106 => Opcode::PseudoVFDIV_VV_M2_E32_MASK,
          2107 => Opcode::PseudoVFDIV_VV_M2_E64,
          2108 => Opcode::PseudoVFDIV_VV_M2_E64_MASK,
          2109 => Opcode::PseudoVFDIV_VV_M4_E16,
          2110 => Opcode::PseudoVFDIV_VV_M4_E16_MASK,
          2111 => Opcode::PseudoVFDIV_VV_M4_E32,
          2112 => Opcode::PseudoVFDIV_VV_M4_E32_MASK,
          2113 => Opcode::PseudoVFDIV_VV_M4_E64,
          2114 => Opcode::PseudoVFDIV_VV_M4_E64_MASK,
          2115 => Opcode::PseudoVFDIV_VV_M8_E16,
          2116 => Opcode::PseudoVFDIV_VV_M8_E16_MASK,
          2117 => Opcode::PseudoVFDIV_VV_M8_E32,
          2118 => Opcode::PseudoVFDIV_VV_M8_E32_MASK,
          2119 => Opcode::PseudoVFDIV_VV_M8_E64,
          2120 => Opcode::PseudoVFDIV_VV_M8_E64_MASK,
          2121 => Opcode::PseudoVFDIV_VV_MF2_E16,
          2122 => Opcode::PseudoVFDIV_VV_MF2_E16_MASK,
          2123 => Opcode::PseudoVFDIV_VV_MF2_E32,
          2124 => Opcode::PseudoVFDIV_VV_MF2_E32_MASK,
          2125 => Opcode::PseudoVFDIV_VV_MF4_E16,
          2126 => Opcode::PseudoVFDIV_VV_MF4_E16_MASK,
          2127 => Opcode::PseudoVFIRST_M_B1,
          2128 => Opcode::PseudoVFIRST_M_B16,
          2129 => Opcode::PseudoVFIRST_M_B16_MASK,
          2130 => Opcode::PseudoVFIRST_M_B1_MASK,
          2131 => Opcode::PseudoVFIRST_M_B2,
          2132 => Opcode::PseudoVFIRST_M_B2_MASK,
          2133 => Opcode::PseudoVFIRST_M_B32,
          2134 => Opcode::PseudoVFIRST_M_B32_MASK,
          2135 => Opcode::PseudoVFIRST_M_B4,
          2136 => Opcode::PseudoVFIRST_M_B4_MASK,
          2137 => Opcode::PseudoVFIRST_M_B64,
          2138 => Opcode::PseudoVFIRST_M_B64_MASK,
          2139 => Opcode::PseudoVFIRST_M_B8,
          2140 => Opcode::PseudoVFIRST_M_B8_MASK,
          2141 => Opcode::PseudoVFMACC_VFPR16_M1_E16,
          2142 => Opcode::PseudoVFMACC_VFPR16_M1_E16_MASK,
          2143 => Opcode::PseudoVFMACC_VFPR16_M2_E16,
          2144 => Opcode::PseudoVFMACC_VFPR16_M2_E16_MASK,
          2145 => Opcode::PseudoVFMACC_VFPR16_M4_E16,
          2146 => Opcode::PseudoVFMACC_VFPR16_M4_E16_MASK,
          2147 => Opcode::PseudoVFMACC_VFPR16_M8_E16,
          2148 => Opcode::PseudoVFMACC_VFPR16_M8_E16_MASK,
          2149 => Opcode::PseudoVFMACC_VFPR16_MF2_E16,
          2150 => Opcode::PseudoVFMACC_VFPR16_MF2_E16_MASK,
          2151 => Opcode::PseudoVFMACC_VFPR16_MF4_E16,
          2152 => Opcode::PseudoVFMACC_VFPR16_MF4_E16_MASK,
          2153 => Opcode::PseudoVFMACC_VFPR32_M1_E32,
          2154 => Opcode::PseudoVFMACC_VFPR32_M1_E32_MASK,
          2155 => Opcode::PseudoVFMACC_VFPR32_M2_E32,
          2156 => Opcode::PseudoVFMACC_VFPR32_M2_E32_MASK,
          2157 => Opcode::PseudoVFMACC_VFPR32_M4_E32,
          2158 => Opcode::PseudoVFMACC_VFPR32_M4_E32_MASK,
          2159 => Opcode::PseudoVFMACC_VFPR32_M8_E32,
          2160 => Opcode::PseudoVFMACC_VFPR32_M8_E32_MASK,
          2161 => Opcode::PseudoVFMACC_VFPR32_MF2_E32,
          2162 => Opcode::PseudoVFMACC_VFPR32_MF2_E32_MASK,
          2163 => Opcode::PseudoVFMACC_VFPR64_M1_E64,
          2164 => Opcode::PseudoVFMACC_VFPR64_M1_E64_MASK,
          2165 => Opcode::PseudoVFMACC_VFPR64_M2_E64,
          2166 => Opcode::PseudoVFMACC_VFPR64_M2_E64_MASK,
          2167 => Opcode::PseudoVFMACC_VFPR64_M4_E64,
          2168 => Opcode::PseudoVFMACC_VFPR64_M4_E64_MASK,
          2169 => Opcode::PseudoVFMACC_VFPR64_M8_E64,
          2170 => Opcode::PseudoVFMACC_VFPR64_M8_E64_MASK,
          2171 => Opcode::PseudoVFMACC_VV_M1_E16,
          2172 => Opcode::PseudoVFMACC_VV_M1_E16_MASK,
          2173 => Opcode::PseudoVFMACC_VV_M1_E32,
          2174 => Opcode::PseudoVFMACC_VV_M1_E32_MASK,
          2175 => Opcode::PseudoVFMACC_VV_M1_E64,
          2176 => Opcode::PseudoVFMACC_VV_M1_E64_MASK,
          2177 => Opcode::PseudoVFMACC_VV_M2_E16,
          2178 => Opcode::PseudoVFMACC_VV_M2_E16_MASK,
          2179 => Opcode::PseudoVFMACC_VV_M2_E32,
          2180 => Opcode::PseudoVFMACC_VV_M2_E32_MASK,
          2181 => Opcode::PseudoVFMACC_VV_M2_E64,
          2182 => Opcode::PseudoVFMACC_VV_M2_E64_MASK,
          2183 => Opcode::PseudoVFMACC_VV_M4_E16,
          2184 => Opcode::PseudoVFMACC_VV_M4_E16_MASK,
          2185 => Opcode::PseudoVFMACC_VV_M4_E32,
          2186 => Opcode::PseudoVFMACC_VV_M4_E32_MASK,
          2187 => Opcode::PseudoVFMACC_VV_M4_E64,
          2188 => Opcode::PseudoVFMACC_VV_M4_E64_MASK,
          2189 => Opcode::PseudoVFMACC_VV_M8_E16,
          2190 => Opcode::PseudoVFMACC_VV_M8_E16_MASK,
          2191 => Opcode::PseudoVFMACC_VV_M8_E32,
          2192 => Opcode::PseudoVFMACC_VV_M8_E32_MASK,
          2193 => Opcode::PseudoVFMACC_VV_M8_E64,
          2194 => Opcode::PseudoVFMACC_VV_M8_E64_MASK,
          2195 => Opcode::PseudoVFMACC_VV_MF2_E16,
          2196 => Opcode::PseudoVFMACC_VV_MF2_E16_MASK,
          2197 => Opcode::PseudoVFMACC_VV_MF2_E32,
          2198 => Opcode::PseudoVFMACC_VV_MF2_E32_MASK,
          2199 => Opcode::PseudoVFMACC_VV_MF4_E16,
          2200 => Opcode::PseudoVFMACC_VV_MF4_E16_MASK,
          2201 => Opcode::PseudoVFMADD_VFPR16_M1_E16,
          2202 => Opcode::PseudoVFMADD_VFPR16_M1_E16_MASK,
          2203 => Opcode::PseudoVFMADD_VFPR16_M2_E16,
          2204 => Opcode::PseudoVFMADD_VFPR16_M2_E16_MASK,
          2205 => Opcode::PseudoVFMADD_VFPR16_M4_E16,
          2206 => Opcode::PseudoVFMADD_VFPR16_M4_E16_MASK,
          2207 => Opcode::PseudoVFMADD_VFPR16_M8_E16,
          2208 => Opcode::PseudoVFMADD_VFPR16_M8_E16_MASK,
          2209 => Opcode::PseudoVFMADD_VFPR16_MF2_E16,
          2210 => Opcode::PseudoVFMADD_VFPR16_MF2_E16_MASK,
          2211 => Opcode::PseudoVFMADD_VFPR16_MF4_E16,
          2212 => Opcode::PseudoVFMADD_VFPR16_MF4_E16_MASK,
          2213 => Opcode::PseudoVFMADD_VFPR32_M1_E32,
          2214 => Opcode::PseudoVFMADD_VFPR32_M1_E32_MASK,
          2215 => Opcode::PseudoVFMADD_VFPR32_M2_E32,
          2216 => Opcode::PseudoVFMADD_VFPR32_M2_E32_MASK,
          2217 => Opcode::PseudoVFMADD_VFPR32_M4_E32,
          2218 => Opcode::PseudoVFMADD_VFPR32_M4_E32_MASK,
          2219 => Opcode::PseudoVFMADD_VFPR32_M8_E32,
          2220 => Opcode::PseudoVFMADD_VFPR32_M8_E32_MASK,
          2221 => Opcode::PseudoVFMADD_VFPR32_MF2_E32,
          2222 => Opcode::PseudoVFMADD_VFPR32_MF2_E32_MASK,
          2223 => Opcode::PseudoVFMADD_VFPR64_M1_E64,
          2224 => Opcode::PseudoVFMADD_VFPR64_M1_E64_MASK,
          2225 => Opcode::PseudoVFMADD_VFPR64_M2_E64,
          2226 => Opcode::PseudoVFMADD_VFPR64_M2_E64_MASK,
          2227 => Opcode::PseudoVFMADD_VFPR64_M4_E64,
          2228 => Opcode::PseudoVFMADD_VFPR64_M4_E64_MASK,
          2229 => Opcode::PseudoVFMADD_VFPR64_M8_E64,
          2230 => Opcode::PseudoVFMADD_VFPR64_M8_E64_MASK,
          2231 => Opcode::PseudoVFMADD_VV_M1_E16,
          2232 => Opcode::PseudoVFMADD_VV_M1_E16_MASK,
          2233 => Opcode::PseudoVFMADD_VV_M1_E32,
          2234 => Opcode::PseudoVFMADD_VV_M1_E32_MASK,
          2235 => Opcode::PseudoVFMADD_VV_M1_E64,
          2236 => Opcode::PseudoVFMADD_VV_M1_E64_MASK,
          2237 => Opcode::PseudoVFMADD_VV_M2_E16,
          2238 => Opcode::PseudoVFMADD_VV_M2_E16_MASK,
          2239 => Opcode::PseudoVFMADD_VV_M2_E32,
          2240 => Opcode::PseudoVFMADD_VV_M2_E32_MASK,
          2241 => Opcode::PseudoVFMADD_VV_M2_E64,
          2242 => Opcode::PseudoVFMADD_VV_M2_E64_MASK,
          2243 => Opcode::PseudoVFMADD_VV_M4_E16,
          2244 => Opcode::PseudoVFMADD_VV_M4_E16_MASK,
          2245 => Opcode::PseudoVFMADD_VV_M4_E32,
          2246 => Opcode::PseudoVFMADD_VV_M4_E32_MASK,
          2247 => Opcode::PseudoVFMADD_VV_M4_E64,
          2248 => Opcode::PseudoVFMADD_VV_M4_E64_MASK,
          2249 => Opcode::PseudoVFMADD_VV_M8_E16,
          2250 => Opcode::PseudoVFMADD_VV_M8_E16_MASK,
          2251 => Opcode::PseudoVFMADD_VV_M8_E32,
          2252 => Opcode::PseudoVFMADD_VV_M8_E32_MASK,
          2253 => Opcode::PseudoVFMADD_VV_M8_E64,
          2254 => Opcode::PseudoVFMADD_VV_M8_E64_MASK,
          2255 => Opcode::PseudoVFMADD_VV_MF2_E16,
          2256 => Opcode::PseudoVFMADD_VV_MF2_E16_MASK,
          2257 => Opcode::PseudoVFMADD_VV_MF2_E32,
          2258 => Opcode::PseudoVFMADD_VV_MF2_E32_MASK,
          2259 => Opcode::PseudoVFMADD_VV_MF4_E16,
          2260 => Opcode::PseudoVFMADD_VV_MF4_E16_MASK,
          2261 => Opcode::PseudoVFMAX_VFPR16_M1_E16,
          2262 => Opcode::PseudoVFMAX_VFPR16_M1_E16_MASK,
          2263 => Opcode::PseudoVFMAX_VFPR16_M2_E16,
          2264 => Opcode::PseudoVFMAX_VFPR16_M2_E16_MASK,
          2265 => Opcode::PseudoVFMAX_VFPR16_M4_E16,
          2266 => Opcode::PseudoVFMAX_VFPR16_M4_E16_MASK,
          2267 => Opcode::PseudoVFMAX_VFPR16_M8_E16,
          2268 => Opcode::PseudoVFMAX_VFPR16_M8_E16_MASK,
          2269 => Opcode::PseudoVFMAX_VFPR16_MF2_E16,
          2270 => Opcode::PseudoVFMAX_VFPR16_MF2_E16_MASK,
          2271 => Opcode::PseudoVFMAX_VFPR16_MF4_E16,
          2272 => Opcode::PseudoVFMAX_VFPR16_MF4_E16_MASK,
          2273 => Opcode::PseudoVFMAX_VFPR32_M1_E32,
          2274 => Opcode::PseudoVFMAX_VFPR32_M1_E32_MASK,
          2275 => Opcode::PseudoVFMAX_VFPR32_M2_E32,
          2276 => Opcode::PseudoVFMAX_VFPR32_M2_E32_MASK,
          2277 => Opcode::PseudoVFMAX_VFPR32_M4_E32,
          2278 => Opcode::PseudoVFMAX_VFPR32_M4_E32_MASK,
          2279 => Opcode::PseudoVFMAX_VFPR32_M8_E32,
          2280 => Opcode::PseudoVFMAX_VFPR32_M8_E32_MASK,
          2281 => Opcode::PseudoVFMAX_VFPR32_MF2_E32,
          2282 => Opcode::PseudoVFMAX_VFPR32_MF2_E32_MASK,
          2283 => Opcode::PseudoVFMAX_VFPR64_M1_E64,
          2284 => Opcode::PseudoVFMAX_VFPR64_M1_E64_MASK,
          2285 => Opcode::PseudoVFMAX_VFPR64_M2_E64,
          2286 => Opcode::PseudoVFMAX_VFPR64_M2_E64_MASK,
          2287 => Opcode::PseudoVFMAX_VFPR64_M4_E64,
          2288 => Opcode::PseudoVFMAX_VFPR64_M4_E64_MASK,
          2289 => Opcode::PseudoVFMAX_VFPR64_M8_E64,
          2290 => Opcode::PseudoVFMAX_VFPR64_M8_E64_MASK,
          2291 => Opcode::PseudoVFMAX_VV_M1_E16,
          2292 => Opcode::PseudoVFMAX_VV_M1_E16_MASK,
          2293 => Opcode::PseudoVFMAX_VV_M1_E32,
          2294 => Opcode::PseudoVFMAX_VV_M1_E32_MASK,
          2295 => Opcode::PseudoVFMAX_VV_M1_E64,
          2296 => Opcode::PseudoVFMAX_VV_M1_E64_MASK,
          2297 => Opcode::PseudoVFMAX_VV_M2_E16,
          2298 => Opcode::PseudoVFMAX_VV_M2_E16_MASK,
          2299 => Opcode::PseudoVFMAX_VV_M2_E32,
          2300 => Opcode::PseudoVFMAX_VV_M2_E32_MASK,
          2301 => Opcode::PseudoVFMAX_VV_M2_E64,
          2302 => Opcode::PseudoVFMAX_VV_M2_E64_MASK,
          2303 => Opcode::PseudoVFMAX_VV_M4_E16,
          2304 => Opcode::PseudoVFMAX_VV_M4_E16_MASK,
          2305 => Opcode::PseudoVFMAX_VV_M4_E32,
          2306 => Opcode::PseudoVFMAX_VV_M4_E32_MASK,
          2307 => Opcode::PseudoVFMAX_VV_M4_E64,
          2308 => Opcode::PseudoVFMAX_VV_M4_E64_MASK,
          2309 => Opcode::PseudoVFMAX_VV_M8_E16,
          2310 => Opcode::PseudoVFMAX_VV_M8_E16_MASK,
          2311 => Opcode::PseudoVFMAX_VV_M8_E32,
          2312 => Opcode::PseudoVFMAX_VV_M8_E32_MASK,
          2313 => Opcode::PseudoVFMAX_VV_M8_E64,
          2314 => Opcode::PseudoVFMAX_VV_M8_E64_MASK,
          2315 => Opcode::PseudoVFMAX_VV_MF2_E16,
          2316 => Opcode::PseudoVFMAX_VV_MF2_E16_MASK,
          2317 => Opcode::PseudoVFMAX_VV_MF2_E32,
          2318 => Opcode::PseudoVFMAX_VV_MF2_E32_MASK,
          2319 => Opcode::PseudoVFMAX_VV_MF4_E16,
          2320 => Opcode::PseudoVFMAX_VV_MF4_E16_MASK,
          2321 => Opcode::PseudoVFMERGE_VFPR16M_M1,
          2322 => Opcode::PseudoVFMERGE_VFPR16M_M2,
          2323 => Opcode::PseudoVFMERGE_VFPR16M_M4,
          2324 => Opcode::PseudoVFMERGE_VFPR16M_M8,
          2325 => Opcode::PseudoVFMERGE_VFPR16M_MF2,
          2326 => Opcode::PseudoVFMERGE_VFPR16M_MF4,
          2327 => Opcode::PseudoVFMERGE_VFPR32M_M1,
          2328 => Opcode::PseudoVFMERGE_VFPR32M_M2,
          2329 => Opcode::PseudoVFMERGE_VFPR32M_M4,
          2330 => Opcode::PseudoVFMERGE_VFPR32M_M8,
          2331 => Opcode::PseudoVFMERGE_VFPR32M_MF2,
          2332 => Opcode::PseudoVFMERGE_VFPR64M_M1,
          2333 => Opcode::PseudoVFMERGE_VFPR64M_M2,
          2334 => Opcode::PseudoVFMERGE_VFPR64M_M4,
          2335 => Opcode::PseudoVFMERGE_VFPR64M_M8,
          2336 => Opcode::PseudoVFMIN_VFPR16_M1_E16,
          2337 => Opcode::PseudoVFMIN_VFPR16_M1_E16_MASK,
          2338 => Opcode::PseudoVFMIN_VFPR16_M2_E16,
          2339 => Opcode::PseudoVFMIN_VFPR16_M2_E16_MASK,
          2340 => Opcode::PseudoVFMIN_VFPR16_M4_E16,
          2341 => Opcode::PseudoVFMIN_VFPR16_M4_E16_MASK,
          2342 => Opcode::PseudoVFMIN_VFPR16_M8_E16,
          2343 => Opcode::PseudoVFMIN_VFPR16_M8_E16_MASK,
          2344 => Opcode::PseudoVFMIN_VFPR16_MF2_E16,
          2345 => Opcode::PseudoVFMIN_VFPR16_MF2_E16_MASK,
          2346 => Opcode::PseudoVFMIN_VFPR16_MF4_E16,
          2347 => Opcode::PseudoVFMIN_VFPR16_MF4_E16_MASK,
          2348 => Opcode::PseudoVFMIN_VFPR32_M1_E32,
          2349 => Opcode::PseudoVFMIN_VFPR32_M1_E32_MASK,
          2350 => Opcode::PseudoVFMIN_VFPR32_M2_E32,
          2351 => Opcode::PseudoVFMIN_VFPR32_M2_E32_MASK,
          2352 => Opcode::PseudoVFMIN_VFPR32_M4_E32,
          2353 => Opcode::PseudoVFMIN_VFPR32_M4_E32_MASK,
          2354 => Opcode::PseudoVFMIN_VFPR32_M8_E32,
          2355 => Opcode::PseudoVFMIN_VFPR32_M8_E32_MASK,
          2356 => Opcode::PseudoVFMIN_VFPR32_MF2_E32,
          2357 => Opcode::PseudoVFMIN_VFPR32_MF2_E32_MASK,
          2358 => Opcode::PseudoVFMIN_VFPR64_M1_E64,
          2359 => Opcode::PseudoVFMIN_VFPR64_M1_E64_MASK,
          2360 => Opcode::PseudoVFMIN_VFPR64_M2_E64,
          2361 => Opcode::PseudoVFMIN_VFPR64_M2_E64_MASK,
          2362 => Opcode::PseudoVFMIN_VFPR64_M4_E64,
          2363 => Opcode::PseudoVFMIN_VFPR64_M4_E64_MASK,
          2364 => Opcode::PseudoVFMIN_VFPR64_M8_E64,
          2365 => Opcode::PseudoVFMIN_VFPR64_M8_E64_MASK,
          2366 => Opcode::PseudoVFMIN_VV_M1_E16,
          2367 => Opcode::PseudoVFMIN_VV_M1_E16_MASK,
          2368 => Opcode::PseudoVFMIN_VV_M1_E32,
          2369 => Opcode::PseudoVFMIN_VV_M1_E32_MASK,
          2370 => Opcode::PseudoVFMIN_VV_M1_E64,
          2371 => Opcode::PseudoVFMIN_VV_M1_E64_MASK,
          2372 => Opcode::PseudoVFMIN_VV_M2_E16,
          2373 => Opcode::PseudoVFMIN_VV_M2_E16_MASK,
          2374 => Opcode::PseudoVFMIN_VV_M2_E32,
          2375 => Opcode::PseudoVFMIN_VV_M2_E32_MASK,
          2376 => Opcode::PseudoVFMIN_VV_M2_E64,
          2377 => Opcode::PseudoVFMIN_VV_M2_E64_MASK,
          2378 => Opcode::PseudoVFMIN_VV_M4_E16,
          2379 => Opcode::PseudoVFMIN_VV_M4_E16_MASK,
          2380 => Opcode::PseudoVFMIN_VV_M4_E32,
          2381 => Opcode::PseudoVFMIN_VV_M4_E32_MASK,
          2382 => Opcode::PseudoVFMIN_VV_M4_E64,
          2383 => Opcode::PseudoVFMIN_VV_M4_E64_MASK,
          2384 => Opcode::PseudoVFMIN_VV_M8_E16,
          2385 => Opcode::PseudoVFMIN_VV_M8_E16_MASK,
          2386 => Opcode::PseudoVFMIN_VV_M8_E32,
          2387 => Opcode::PseudoVFMIN_VV_M8_E32_MASK,
          2388 => Opcode::PseudoVFMIN_VV_M8_E64,
          2389 => Opcode::PseudoVFMIN_VV_M8_E64_MASK,
          2390 => Opcode::PseudoVFMIN_VV_MF2_E16,
          2391 => Opcode::PseudoVFMIN_VV_MF2_E16_MASK,
          2392 => Opcode::PseudoVFMIN_VV_MF2_E32,
          2393 => Opcode::PseudoVFMIN_VV_MF2_E32_MASK,
          2394 => Opcode::PseudoVFMIN_VV_MF4_E16,
          2395 => Opcode::PseudoVFMIN_VV_MF4_E16_MASK,
          2396 => Opcode::PseudoVFMSAC_VFPR16_M1_E16,
          2397 => Opcode::PseudoVFMSAC_VFPR16_M1_E16_MASK,
          2398 => Opcode::PseudoVFMSAC_VFPR16_M2_E16,
          2399 => Opcode::PseudoVFMSAC_VFPR16_M2_E16_MASK,
          2400 => Opcode::PseudoVFMSAC_VFPR16_M4_E16,
          2401 => Opcode::PseudoVFMSAC_VFPR16_M4_E16_MASK,
          2402 => Opcode::PseudoVFMSAC_VFPR16_M8_E16,
          2403 => Opcode::PseudoVFMSAC_VFPR16_M8_E16_MASK,
          2404 => Opcode::PseudoVFMSAC_VFPR16_MF2_E16,
          2405 => Opcode::PseudoVFMSAC_VFPR16_MF2_E16_MASK,
          2406 => Opcode::PseudoVFMSAC_VFPR16_MF4_E16,
          2407 => Opcode::PseudoVFMSAC_VFPR16_MF4_E16_MASK,
          2408 => Opcode::PseudoVFMSAC_VFPR32_M1_E32,
          2409 => Opcode::PseudoVFMSAC_VFPR32_M1_E32_MASK,
          2410 => Opcode::PseudoVFMSAC_VFPR32_M2_E32,
          2411 => Opcode::PseudoVFMSAC_VFPR32_M2_E32_MASK,
          2412 => Opcode::PseudoVFMSAC_VFPR32_M4_E32,
          2413 => Opcode::PseudoVFMSAC_VFPR32_M4_E32_MASK,
          2414 => Opcode::PseudoVFMSAC_VFPR32_M8_E32,
          2415 => Opcode::PseudoVFMSAC_VFPR32_M8_E32_MASK,
          2416 => Opcode::PseudoVFMSAC_VFPR32_MF2_E32,
          2417 => Opcode::PseudoVFMSAC_VFPR32_MF2_E32_MASK,
          2418 => Opcode::PseudoVFMSAC_VFPR64_M1_E64,
          2419 => Opcode::PseudoVFMSAC_VFPR64_M1_E64_MASK,
          2420 => Opcode::PseudoVFMSAC_VFPR64_M2_E64,
          2421 => Opcode::PseudoVFMSAC_VFPR64_M2_E64_MASK,
          2422 => Opcode::PseudoVFMSAC_VFPR64_M4_E64,
          2423 => Opcode::PseudoVFMSAC_VFPR64_M4_E64_MASK,
          2424 => Opcode::PseudoVFMSAC_VFPR64_M8_E64,
          2425 => Opcode::PseudoVFMSAC_VFPR64_M8_E64_MASK,
          2426 => Opcode::PseudoVFMSAC_VV_M1_E16,
          2427 => Opcode::PseudoVFMSAC_VV_M1_E16_MASK,
          2428 => Opcode::PseudoVFMSAC_VV_M1_E32,
          2429 => Opcode::PseudoVFMSAC_VV_M1_E32_MASK,
          2430 => Opcode::PseudoVFMSAC_VV_M1_E64,
          2431 => Opcode::PseudoVFMSAC_VV_M1_E64_MASK,
          2432 => Opcode::PseudoVFMSAC_VV_M2_E16,
          2433 => Opcode::PseudoVFMSAC_VV_M2_E16_MASK,
          2434 => Opcode::PseudoVFMSAC_VV_M2_E32,
          2435 => Opcode::PseudoVFMSAC_VV_M2_E32_MASK,
          2436 => Opcode::PseudoVFMSAC_VV_M2_E64,
          2437 => Opcode::PseudoVFMSAC_VV_M2_E64_MASK,
          2438 => Opcode::PseudoVFMSAC_VV_M4_E16,
          2439 => Opcode::PseudoVFMSAC_VV_M4_E16_MASK,
          2440 => Opcode::PseudoVFMSAC_VV_M4_E32,
          2441 => Opcode::PseudoVFMSAC_VV_M4_E32_MASK,
          2442 => Opcode::PseudoVFMSAC_VV_M4_E64,
          2443 => Opcode::PseudoVFMSAC_VV_M4_E64_MASK,
          2444 => Opcode::PseudoVFMSAC_VV_M8_E16,
          2445 => Opcode::PseudoVFMSAC_VV_M8_E16_MASK,
          2446 => Opcode::PseudoVFMSAC_VV_M8_E32,
          2447 => Opcode::PseudoVFMSAC_VV_M8_E32_MASK,
          2448 => Opcode::PseudoVFMSAC_VV_M8_E64,
          2449 => Opcode::PseudoVFMSAC_VV_M8_E64_MASK,
          2450 => Opcode::PseudoVFMSAC_VV_MF2_E16,
          2451 => Opcode::PseudoVFMSAC_VV_MF2_E16_MASK,
          2452 => Opcode::PseudoVFMSAC_VV_MF2_E32,
          2453 => Opcode::PseudoVFMSAC_VV_MF2_E32_MASK,
          2454 => Opcode::PseudoVFMSAC_VV_MF4_E16,
          2455 => Opcode::PseudoVFMSAC_VV_MF4_E16_MASK,
          2456 => Opcode::PseudoVFMSUB_VFPR16_M1_E16,
          2457 => Opcode::PseudoVFMSUB_VFPR16_M1_E16_MASK,
          2458 => Opcode::PseudoVFMSUB_VFPR16_M2_E16,
          2459 => Opcode::PseudoVFMSUB_VFPR16_M2_E16_MASK,
          2460 => Opcode::PseudoVFMSUB_VFPR16_M4_E16,
          2461 => Opcode::PseudoVFMSUB_VFPR16_M4_E16_MASK,
          2462 => Opcode::PseudoVFMSUB_VFPR16_M8_E16,
          2463 => Opcode::PseudoVFMSUB_VFPR16_M8_E16_MASK,
          2464 => Opcode::PseudoVFMSUB_VFPR16_MF2_E16,
          2465 => Opcode::PseudoVFMSUB_VFPR16_MF2_E16_MASK,
          2466 => Opcode::PseudoVFMSUB_VFPR16_MF4_E16,
          2467 => Opcode::PseudoVFMSUB_VFPR16_MF4_E16_MASK,
          2468 => Opcode::PseudoVFMSUB_VFPR32_M1_E32,
          2469 => Opcode::PseudoVFMSUB_VFPR32_M1_E32_MASK,
          2470 => Opcode::PseudoVFMSUB_VFPR32_M2_E32,
          2471 => Opcode::PseudoVFMSUB_VFPR32_M2_E32_MASK,
          2472 => Opcode::PseudoVFMSUB_VFPR32_M4_E32,
          2473 => Opcode::PseudoVFMSUB_VFPR32_M4_E32_MASK,
          2474 => Opcode::PseudoVFMSUB_VFPR32_M8_E32,
          2475 => Opcode::PseudoVFMSUB_VFPR32_M8_E32_MASK,
          2476 => Opcode::PseudoVFMSUB_VFPR32_MF2_E32,
          2477 => Opcode::PseudoVFMSUB_VFPR32_MF2_E32_MASK,
          2478 => Opcode::PseudoVFMSUB_VFPR64_M1_E64,
          2479 => Opcode::PseudoVFMSUB_VFPR64_M1_E64_MASK,
          2480 => Opcode::PseudoVFMSUB_VFPR64_M2_E64,
          2481 => Opcode::PseudoVFMSUB_VFPR64_M2_E64_MASK,
          2482 => Opcode::PseudoVFMSUB_VFPR64_M4_E64,
          2483 => Opcode::PseudoVFMSUB_VFPR64_M4_E64_MASK,
          2484 => Opcode::PseudoVFMSUB_VFPR64_M8_E64,
          2485 => Opcode::PseudoVFMSUB_VFPR64_M8_E64_MASK,
          2486 => Opcode::PseudoVFMSUB_VV_M1_E16,
          2487 => Opcode::PseudoVFMSUB_VV_M1_E16_MASK,
          2488 => Opcode::PseudoVFMSUB_VV_M1_E32,
          2489 => Opcode::PseudoVFMSUB_VV_M1_E32_MASK,
          2490 => Opcode::PseudoVFMSUB_VV_M1_E64,
          2491 => Opcode::PseudoVFMSUB_VV_M1_E64_MASK,
          2492 => Opcode::PseudoVFMSUB_VV_M2_E16,
          2493 => Opcode::PseudoVFMSUB_VV_M2_E16_MASK,
          2494 => Opcode::PseudoVFMSUB_VV_M2_E32,
          2495 => Opcode::PseudoVFMSUB_VV_M2_E32_MASK,
          2496 => Opcode::PseudoVFMSUB_VV_M2_E64,
          2497 => Opcode::PseudoVFMSUB_VV_M2_E64_MASK,
          2498 => Opcode::PseudoVFMSUB_VV_M4_E16,
          2499 => Opcode::PseudoVFMSUB_VV_M4_E16_MASK,
          2500 => Opcode::PseudoVFMSUB_VV_M4_E32,
          2501 => Opcode::PseudoVFMSUB_VV_M4_E32_MASK,
          2502 => Opcode::PseudoVFMSUB_VV_M4_E64,
          2503 => Opcode::PseudoVFMSUB_VV_M4_E64_MASK,
          2504 => Opcode::PseudoVFMSUB_VV_M8_E16,
          2505 => Opcode::PseudoVFMSUB_VV_M8_E16_MASK,
          2506 => Opcode::PseudoVFMSUB_VV_M8_E32,
          2507 => Opcode::PseudoVFMSUB_VV_M8_E32_MASK,
          2508 => Opcode::PseudoVFMSUB_VV_M8_E64,
          2509 => Opcode::PseudoVFMSUB_VV_M8_E64_MASK,
          2510 => Opcode::PseudoVFMSUB_VV_MF2_E16,
          2511 => Opcode::PseudoVFMSUB_VV_MF2_E16_MASK,
          2512 => Opcode::PseudoVFMSUB_VV_MF2_E32,
          2513 => Opcode::PseudoVFMSUB_VV_MF2_E32_MASK,
          2514 => Opcode::PseudoVFMSUB_VV_MF4_E16,
          2515 => Opcode::PseudoVFMSUB_VV_MF4_E16_MASK,
          2516 => Opcode::PseudoVFMUL_VFPR16_M1_E16,
          2517 => Opcode::PseudoVFMUL_VFPR16_M1_E16_MASK,
          2518 => Opcode::PseudoVFMUL_VFPR16_M2_E16,
          2519 => Opcode::PseudoVFMUL_VFPR16_M2_E16_MASK,
          2520 => Opcode::PseudoVFMUL_VFPR16_M4_E16,
          2521 => Opcode::PseudoVFMUL_VFPR16_M4_E16_MASK,
          2522 => Opcode::PseudoVFMUL_VFPR16_M8_E16,
          2523 => Opcode::PseudoVFMUL_VFPR16_M8_E16_MASK,
          2524 => Opcode::PseudoVFMUL_VFPR16_MF2_E16,
          2525 => Opcode::PseudoVFMUL_VFPR16_MF2_E16_MASK,
          2526 => Opcode::PseudoVFMUL_VFPR16_MF4_E16,
          2527 => Opcode::PseudoVFMUL_VFPR16_MF4_E16_MASK,
          2528 => Opcode::PseudoVFMUL_VFPR32_M1_E32,
          2529 => Opcode::PseudoVFMUL_VFPR32_M1_E32_MASK,
          2530 => Opcode::PseudoVFMUL_VFPR32_M2_E32,
          2531 => Opcode::PseudoVFMUL_VFPR32_M2_E32_MASK,
          2532 => Opcode::PseudoVFMUL_VFPR32_M4_E32,
          2533 => Opcode::PseudoVFMUL_VFPR32_M4_E32_MASK,
          2534 => Opcode::PseudoVFMUL_VFPR32_M8_E32,
          2535 => Opcode::PseudoVFMUL_VFPR32_M8_E32_MASK,
          2536 => Opcode::PseudoVFMUL_VFPR32_MF2_E32,
          2537 => Opcode::PseudoVFMUL_VFPR32_MF2_E32_MASK,
          2538 => Opcode::PseudoVFMUL_VFPR64_M1_E64,
          2539 => Opcode::PseudoVFMUL_VFPR64_M1_E64_MASK,
          2540 => Opcode::PseudoVFMUL_VFPR64_M2_E64,
          2541 => Opcode::PseudoVFMUL_VFPR64_M2_E64_MASK,
          2542 => Opcode::PseudoVFMUL_VFPR64_M4_E64,
          2543 => Opcode::PseudoVFMUL_VFPR64_M4_E64_MASK,
          2544 => Opcode::PseudoVFMUL_VFPR64_M8_E64,
          2545 => Opcode::PseudoVFMUL_VFPR64_M8_E64_MASK,
          2546 => Opcode::PseudoVFMUL_VV_M1_E16,
          2547 => Opcode::PseudoVFMUL_VV_M1_E16_MASK,
          2548 => Opcode::PseudoVFMUL_VV_M1_E32,
          2549 => Opcode::PseudoVFMUL_VV_M1_E32_MASK,
          2550 => Opcode::PseudoVFMUL_VV_M1_E64,
          2551 => Opcode::PseudoVFMUL_VV_M1_E64_MASK,
          2552 => Opcode::PseudoVFMUL_VV_M2_E16,
          2553 => Opcode::PseudoVFMUL_VV_M2_E16_MASK,
          2554 => Opcode::PseudoVFMUL_VV_M2_E32,
          2555 => Opcode::PseudoVFMUL_VV_M2_E32_MASK,
          2556 => Opcode::PseudoVFMUL_VV_M2_E64,
          2557 => Opcode::PseudoVFMUL_VV_M2_E64_MASK,
          2558 => Opcode::PseudoVFMUL_VV_M4_E16,
          2559 => Opcode::PseudoVFMUL_VV_M4_E16_MASK,
          2560 => Opcode::PseudoVFMUL_VV_M4_E32,
          2561 => Opcode::PseudoVFMUL_VV_M4_E32_MASK,
          2562 => Opcode::PseudoVFMUL_VV_M4_E64,
          2563 => Opcode::PseudoVFMUL_VV_M4_E64_MASK,
          2564 => Opcode::PseudoVFMUL_VV_M8_E16,
          2565 => Opcode::PseudoVFMUL_VV_M8_E16_MASK,
          2566 => Opcode::PseudoVFMUL_VV_M8_E32,
          2567 => Opcode::PseudoVFMUL_VV_M8_E32_MASK,
          2568 => Opcode::PseudoVFMUL_VV_M8_E64,
          2569 => Opcode::PseudoVFMUL_VV_M8_E64_MASK,
          2570 => Opcode::PseudoVFMUL_VV_MF2_E16,
          2571 => Opcode::PseudoVFMUL_VV_MF2_E16_MASK,
          2572 => Opcode::PseudoVFMUL_VV_MF2_E32,
          2573 => Opcode::PseudoVFMUL_VV_MF2_E32_MASK,
          2574 => Opcode::PseudoVFMUL_VV_MF4_E16,
          2575 => Opcode::PseudoVFMUL_VV_MF4_E16_MASK,
          2576 => Opcode::PseudoVFMV_FPR16_S,
          2577 => Opcode::PseudoVFMV_FPR32_S,
          2578 => Opcode::PseudoVFMV_FPR64_S,
          2579 => Opcode::PseudoVFMV_S_FPR16,
          2580 => Opcode::PseudoVFMV_S_FPR32,
          2581 => Opcode::PseudoVFMV_S_FPR64,
          2582 => Opcode::PseudoVFMV_V_FPR16_M1,
          2583 => Opcode::PseudoVFMV_V_FPR16_M2,
          2584 => Opcode::PseudoVFMV_V_FPR16_M4,
          2585 => Opcode::PseudoVFMV_V_FPR16_M8,
          2586 => Opcode::PseudoVFMV_V_FPR16_MF2,
          2587 => Opcode::PseudoVFMV_V_FPR16_MF4,
          2588 => Opcode::PseudoVFMV_V_FPR32_M1,
          2589 => Opcode::PseudoVFMV_V_FPR32_M2,
          2590 => Opcode::PseudoVFMV_V_FPR32_M4,
          2591 => Opcode::PseudoVFMV_V_FPR32_M8,
          2592 => Opcode::PseudoVFMV_V_FPR32_MF2,
          2593 => Opcode::PseudoVFMV_V_FPR64_M1,
          2594 => Opcode::PseudoVFMV_V_FPR64_M2,
          2595 => Opcode::PseudoVFMV_V_FPR64_M4,
          2596 => Opcode::PseudoVFMV_V_FPR64_M8,
          2597 => Opcode::PseudoVFNCVTBF16_F_F_W_M1_E16,
          2598 => Opcode::PseudoVFNCVTBF16_F_F_W_M1_E16_MASK,
          2599 => Opcode::PseudoVFNCVTBF16_F_F_W_M1_E32,
          2600 => Opcode::PseudoVFNCVTBF16_F_F_W_M1_E32_MASK,
          2601 => Opcode::PseudoVFNCVTBF16_F_F_W_M2_E16,
          2602 => Opcode::PseudoVFNCVTBF16_F_F_W_M2_E16_MASK,
          2603 => Opcode::PseudoVFNCVTBF16_F_F_W_M2_E32,
          2604 => Opcode::PseudoVFNCVTBF16_F_F_W_M2_E32_MASK,
          2605 => Opcode::PseudoVFNCVTBF16_F_F_W_M4_E16,
          2606 => Opcode::PseudoVFNCVTBF16_F_F_W_M4_E16_MASK,
          2607 => Opcode::PseudoVFNCVTBF16_F_F_W_M4_E32,
          2608 => Opcode::PseudoVFNCVTBF16_F_F_W_M4_E32_MASK,
          2609 => Opcode::PseudoVFNCVTBF16_F_F_W_MF2_E16,
          2610 => Opcode::PseudoVFNCVTBF16_F_F_W_MF2_E16_MASK,
          2611 => Opcode::PseudoVFNCVTBF16_F_F_W_MF2_E32,
          2612 => Opcode::PseudoVFNCVTBF16_F_F_W_MF2_E32_MASK,
          2613 => Opcode::PseudoVFNCVTBF16_F_F_W_MF4_E16,
          2614 => Opcode::PseudoVFNCVTBF16_F_F_W_MF4_E16_MASK,
          2615 => Opcode::PseudoVFNCVT_F_F_W_M1_E16,
          2616 => Opcode::PseudoVFNCVT_F_F_W_M1_E16_MASK,
          2617 => Opcode::PseudoVFNCVT_F_F_W_M1_E32,
          2618 => Opcode::PseudoVFNCVT_F_F_W_M1_E32_MASK,
          2619 => Opcode::PseudoVFNCVT_F_F_W_M2_E16,
          2620 => Opcode::PseudoVFNCVT_F_F_W_M2_E16_MASK,
          2621 => Opcode::PseudoVFNCVT_F_F_W_M2_E32,
          2622 => Opcode::PseudoVFNCVT_F_F_W_M2_E32_MASK,
          2623 => Opcode::PseudoVFNCVT_F_F_W_M4_E16,
          2624 => Opcode::PseudoVFNCVT_F_F_W_M4_E16_MASK,
          2625 => Opcode::PseudoVFNCVT_F_F_W_M4_E32,
          2626 => Opcode::PseudoVFNCVT_F_F_W_M4_E32_MASK,
          2627 => Opcode::PseudoVFNCVT_F_F_W_MF2_E16,
          2628 => Opcode::PseudoVFNCVT_F_F_W_MF2_E16_MASK,
          2629 => Opcode::PseudoVFNCVT_F_F_W_MF2_E32,
          2630 => Opcode::PseudoVFNCVT_F_F_W_MF2_E32_MASK,
          2631 => Opcode::PseudoVFNCVT_F_F_W_MF4_E16,
          2632 => Opcode::PseudoVFNCVT_F_F_W_MF4_E16_MASK,
          2633 => Opcode::PseudoVFNCVT_F_XU_W_M1_E16,
          2634 => Opcode::PseudoVFNCVT_F_XU_W_M1_E16_MASK,
          2635 => Opcode::PseudoVFNCVT_F_XU_W_M1_E32,
          2636 => Opcode::PseudoVFNCVT_F_XU_W_M1_E32_MASK,
          2637 => Opcode::PseudoVFNCVT_F_XU_W_M2_E16,
          2638 => Opcode::PseudoVFNCVT_F_XU_W_M2_E16_MASK,
          2639 => Opcode::PseudoVFNCVT_F_XU_W_M2_E32,
          2640 => Opcode::PseudoVFNCVT_F_XU_W_M2_E32_MASK,
          2641 => Opcode::PseudoVFNCVT_F_XU_W_M4_E16,
          2642 => Opcode::PseudoVFNCVT_F_XU_W_M4_E16_MASK,
          2643 => Opcode::PseudoVFNCVT_F_XU_W_M4_E32,
          2644 => Opcode::PseudoVFNCVT_F_XU_W_M4_E32_MASK,
          2645 => Opcode::PseudoVFNCVT_F_XU_W_MF2_E16,
          2646 => Opcode::PseudoVFNCVT_F_XU_W_MF2_E16_MASK,
          2647 => Opcode::PseudoVFNCVT_F_XU_W_MF2_E32,
          2648 => Opcode::PseudoVFNCVT_F_XU_W_MF2_E32_MASK,
          2649 => Opcode::PseudoVFNCVT_F_XU_W_MF4_E16,
          2650 => Opcode::PseudoVFNCVT_F_XU_W_MF4_E16_MASK,
          2651 => Opcode::PseudoVFNCVT_F_X_W_M1_E16,
          2652 => Opcode::PseudoVFNCVT_F_X_W_M1_E16_MASK,
          2653 => Opcode::PseudoVFNCVT_F_X_W_M1_E32,
          2654 => Opcode::PseudoVFNCVT_F_X_W_M1_E32_MASK,
          2655 => Opcode::PseudoVFNCVT_F_X_W_M2_E16,
          2656 => Opcode::PseudoVFNCVT_F_X_W_M2_E16_MASK,
          2657 => Opcode::PseudoVFNCVT_F_X_W_M2_E32,
          2658 => Opcode::PseudoVFNCVT_F_X_W_M2_E32_MASK,
          2659 => Opcode::PseudoVFNCVT_F_X_W_M4_E16,
          2660 => Opcode::PseudoVFNCVT_F_X_W_M4_E16_MASK,
          2661 => Opcode::PseudoVFNCVT_F_X_W_M4_E32,
          2662 => Opcode::PseudoVFNCVT_F_X_W_M4_E32_MASK,
          2663 => Opcode::PseudoVFNCVT_F_X_W_MF2_E16,
          2664 => Opcode::PseudoVFNCVT_F_X_W_MF2_E16_MASK,
          2665 => Opcode::PseudoVFNCVT_F_X_W_MF2_E32,
          2666 => Opcode::PseudoVFNCVT_F_X_W_MF2_E32_MASK,
          2667 => Opcode::PseudoVFNCVT_F_X_W_MF4_E16,
          2668 => Opcode::PseudoVFNCVT_F_X_W_MF4_E16_MASK,
          2669 => Opcode::PseudoVFNCVT_ROD_F_F_W_M1_E16,
          2670 => Opcode::PseudoVFNCVT_ROD_F_F_W_M1_E16_MASK,
          2671 => Opcode::PseudoVFNCVT_ROD_F_F_W_M1_E32,
          2672 => Opcode::PseudoVFNCVT_ROD_F_F_W_M1_E32_MASK,
          2673 => Opcode::PseudoVFNCVT_ROD_F_F_W_M2_E16,
          2674 => Opcode::PseudoVFNCVT_ROD_F_F_W_M2_E16_MASK,
          2675 => Opcode::PseudoVFNCVT_ROD_F_F_W_M2_E32,
          2676 => Opcode::PseudoVFNCVT_ROD_F_F_W_M2_E32_MASK,
          2677 => Opcode::PseudoVFNCVT_ROD_F_F_W_M4_E16,
          2678 => Opcode::PseudoVFNCVT_ROD_F_F_W_M4_E16_MASK,
          2679 => Opcode::PseudoVFNCVT_ROD_F_F_W_M4_E32,
          2680 => Opcode::PseudoVFNCVT_ROD_F_F_W_M4_E32_MASK,
          2681 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF2_E16,
          2682 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF2_E16_MASK,
          2683 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF2_E32,
          2684 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF2_E32_MASK,
          2685 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF4_E16,
          2686 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF4_E16_MASK,
          2687 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M1,
          2688 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M1_MASK,
          2689 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M2,
          2690 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M2_MASK,
          2691 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M4,
          2692 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M4_MASK,
          2693 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF2,
          2694 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF2_MASK,
          2695 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF4,
          2696 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF4_MASK,
          2697 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF8,
          2698 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF8_MASK,
          2699 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M1,
          2700 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M1_MASK,
          2701 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M2,
          2702 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M2_MASK,
          2703 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M4,
          2704 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M4_MASK,
          2705 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF2,
          2706 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF2_MASK,
          2707 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF4,
          2708 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF4_MASK,
          2709 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF8,
          2710 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF8_MASK,
          2711 => Opcode::PseudoVFNCVT_XU_F_W_M1,
          2712 => Opcode::PseudoVFNCVT_XU_F_W_M1_MASK,
          2713 => Opcode::PseudoVFNCVT_XU_F_W_M2,
          2714 => Opcode::PseudoVFNCVT_XU_F_W_M2_MASK,
          2715 => Opcode::PseudoVFNCVT_XU_F_W_M4,
          2716 => Opcode::PseudoVFNCVT_XU_F_W_M4_MASK,
          2717 => Opcode::PseudoVFNCVT_XU_F_W_MF2,
          2718 => Opcode::PseudoVFNCVT_XU_F_W_MF2_MASK,
          2719 => Opcode::PseudoVFNCVT_XU_F_W_MF4,
          2720 => Opcode::PseudoVFNCVT_XU_F_W_MF4_MASK,
          2721 => Opcode::PseudoVFNCVT_XU_F_W_MF8,
          2722 => Opcode::PseudoVFNCVT_XU_F_W_MF8_MASK,
          2723 => Opcode::PseudoVFNCVT_X_F_W_M1,
          2724 => Opcode::PseudoVFNCVT_X_F_W_M1_MASK,
          2725 => Opcode::PseudoVFNCVT_X_F_W_M2,
          2726 => Opcode::PseudoVFNCVT_X_F_W_M2_MASK,
          2727 => Opcode::PseudoVFNCVT_X_F_W_M4,
          2728 => Opcode::PseudoVFNCVT_X_F_W_M4_MASK,
          2729 => Opcode::PseudoVFNCVT_X_F_W_MF2,
          2730 => Opcode::PseudoVFNCVT_X_F_W_MF2_MASK,
          2731 => Opcode::PseudoVFNCVT_X_F_W_MF4,
          2732 => Opcode::PseudoVFNCVT_X_F_W_MF4_MASK,
          2733 => Opcode::PseudoVFNCVT_X_F_W_MF8,
          2734 => Opcode::PseudoVFNCVT_X_F_W_MF8_MASK,
          2735 => Opcode::PseudoVFNMACC_VFPR16_M1_E16,
          2736 => Opcode::PseudoVFNMACC_VFPR16_M1_E16_MASK,
          2737 => Opcode::PseudoVFNMACC_VFPR16_M2_E16,
          2738 => Opcode::PseudoVFNMACC_VFPR16_M2_E16_MASK,
          2739 => Opcode::PseudoVFNMACC_VFPR16_M4_E16,
          2740 => Opcode::PseudoVFNMACC_VFPR16_M4_E16_MASK,
          2741 => Opcode::PseudoVFNMACC_VFPR16_M8_E16,
          2742 => Opcode::PseudoVFNMACC_VFPR16_M8_E16_MASK,
          2743 => Opcode::PseudoVFNMACC_VFPR16_MF2_E16,
          2744 => Opcode::PseudoVFNMACC_VFPR16_MF2_E16_MASK,
          2745 => Opcode::PseudoVFNMACC_VFPR16_MF4_E16,
          2746 => Opcode::PseudoVFNMACC_VFPR16_MF4_E16_MASK,
          2747 => Opcode::PseudoVFNMACC_VFPR32_M1_E32,
          2748 => Opcode::PseudoVFNMACC_VFPR32_M1_E32_MASK,
          2749 => Opcode::PseudoVFNMACC_VFPR32_M2_E32,
          2750 => Opcode::PseudoVFNMACC_VFPR32_M2_E32_MASK,
          2751 => Opcode::PseudoVFNMACC_VFPR32_M4_E32,
          2752 => Opcode::PseudoVFNMACC_VFPR32_M4_E32_MASK,
          2753 => Opcode::PseudoVFNMACC_VFPR32_M8_E32,
          2754 => Opcode::PseudoVFNMACC_VFPR32_M8_E32_MASK,
          2755 => Opcode::PseudoVFNMACC_VFPR32_MF2_E32,
          2756 => Opcode::PseudoVFNMACC_VFPR32_MF2_E32_MASK,
          2757 => Opcode::PseudoVFNMACC_VFPR64_M1_E64,
          2758 => Opcode::PseudoVFNMACC_VFPR64_M1_E64_MASK,
          2759 => Opcode::PseudoVFNMACC_VFPR64_M2_E64,
          2760 => Opcode::PseudoVFNMACC_VFPR64_M2_E64_MASK,
          2761 => Opcode::PseudoVFNMACC_VFPR64_M4_E64,
          2762 => Opcode::PseudoVFNMACC_VFPR64_M4_E64_MASK,
          2763 => Opcode::PseudoVFNMACC_VFPR64_M8_E64,
          2764 => Opcode::PseudoVFNMACC_VFPR64_M8_E64_MASK,
          2765 => Opcode::PseudoVFNMACC_VV_M1_E16,
          2766 => Opcode::PseudoVFNMACC_VV_M1_E16_MASK,
          2767 => Opcode::PseudoVFNMACC_VV_M1_E32,
          2768 => Opcode::PseudoVFNMACC_VV_M1_E32_MASK,
          2769 => Opcode::PseudoVFNMACC_VV_M1_E64,
          2770 => Opcode::PseudoVFNMACC_VV_M1_E64_MASK,
          2771 => Opcode::PseudoVFNMACC_VV_M2_E16,
          2772 => Opcode::PseudoVFNMACC_VV_M2_E16_MASK,
          2773 => Opcode::PseudoVFNMACC_VV_M2_E32,
          2774 => Opcode::PseudoVFNMACC_VV_M2_E32_MASK,
          2775 => Opcode::PseudoVFNMACC_VV_M2_E64,
          2776 => Opcode::PseudoVFNMACC_VV_M2_E64_MASK,
          2777 => Opcode::PseudoVFNMACC_VV_M4_E16,
          2778 => Opcode::PseudoVFNMACC_VV_M4_E16_MASK,
          2779 => Opcode::PseudoVFNMACC_VV_M4_E32,
          2780 => Opcode::PseudoVFNMACC_VV_M4_E32_MASK,
          2781 => Opcode::PseudoVFNMACC_VV_M4_E64,
          2782 => Opcode::PseudoVFNMACC_VV_M4_E64_MASK,
          2783 => Opcode::PseudoVFNMACC_VV_M8_E16,
          2784 => Opcode::PseudoVFNMACC_VV_M8_E16_MASK,
          2785 => Opcode::PseudoVFNMACC_VV_M8_E32,
          2786 => Opcode::PseudoVFNMACC_VV_M8_E32_MASK,
          2787 => Opcode::PseudoVFNMACC_VV_M8_E64,
          2788 => Opcode::PseudoVFNMACC_VV_M8_E64_MASK,
          2789 => Opcode::PseudoVFNMACC_VV_MF2_E16,
          2790 => Opcode::PseudoVFNMACC_VV_MF2_E16_MASK,
          2791 => Opcode::PseudoVFNMACC_VV_MF2_E32,
          2792 => Opcode::PseudoVFNMACC_VV_MF2_E32_MASK,
          2793 => Opcode::PseudoVFNMACC_VV_MF4_E16,
          2794 => Opcode::PseudoVFNMACC_VV_MF4_E16_MASK,
          2795 => Opcode::PseudoVFNMADD_VFPR16_M1_E16,
          2796 => Opcode::PseudoVFNMADD_VFPR16_M1_E16_MASK,
          2797 => Opcode::PseudoVFNMADD_VFPR16_M2_E16,
          2798 => Opcode::PseudoVFNMADD_VFPR16_M2_E16_MASK,
          2799 => Opcode::PseudoVFNMADD_VFPR16_M4_E16,
          2800 => Opcode::PseudoVFNMADD_VFPR16_M4_E16_MASK,
          2801 => Opcode::PseudoVFNMADD_VFPR16_M8_E16,
          2802 => Opcode::PseudoVFNMADD_VFPR16_M8_E16_MASK,
          2803 => Opcode::PseudoVFNMADD_VFPR16_MF2_E16,
          2804 => Opcode::PseudoVFNMADD_VFPR16_MF2_E16_MASK,
          2805 => Opcode::PseudoVFNMADD_VFPR16_MF4_E16,
          2806 => Opcode::PseudoVFNMADD_VFPR16_MF4_E16_MASK,
          2807 => Opcode::PseudoVFNMADD_VFPR32_M1_E32,
          2808 => Opcode::PseudoVFNMADD_VFPR32_M1_E32_MASK,
          2809 => Opcode::PseudoVFNMADD_VFPR32_M2_E32,
          2810 => Opcode::PseudoVFNMADD_VFPR32_M2_E32_MASK,
          2811 => Opcode::PseudoVFNMADD_VFPR32_M4_E32,
          2812 => Opcode::PseudoVFNMADD_VFPR32_M4_E32_MASK,
          2813 => Opcode::PseudoVFNMADD_VFPR32_M8_E32,
          2814 => Opcode::PseudoVFNMADD_VFPR32_M8_E32_MASK,
          2815 => Opcode::PseudoVFNMADD_VFPR32_MF2_E32,
          2816 => Opcode::PseudoVFNMADD_VFPR32_MF2_E32_MASK,
          2817 => Opcode::PseudoVFNMADD_VFPR64_M1_E64,
          2818 => Opcode::PseudoVFNMADD_VFPR64_M1_E64_MASK,
          2819 => Opcode::PseudoVFNMADD_VFPR64_M2_E64,
          2820 => Opcode::PseudoVFNMADD_VFPR64_M2_E64_MASK,
          2821 => Opcode::PseudoVFNMADD_VFPR64_M4_E64,
          2822 => Opcode::PseudoVFNMADD_VFPR64_M4_E64_MASK,
          2823 => Opcode::PseudoVFNMADD_VFPR64_M8_E64,
          2824 => Opcode::PseudoVFNMADD_VFPR64_M8_E64_MASK,
          2825 => Opcode::PseudoVFNMADD_VV_M1_E16,
          2826 => Opcode::PseudoVFNMADD_VV_M1_E16_MASK,
          2827 => Opcode::PseudoVFNMADD_VV_M1_E32,
          2828 => Opcode::PseudoVFNMADD_VV_M1_E32_MASK,
          2829 => Opcode::PseudoVFNMADD_VV_M1_E64,
          2830 => Opcode::PseudoVFNMADD_VV_M1_E64_MASK,
          2831 => Opcode::PseudoVFNMADD_VV_M2_E16,
          2832 => Opcode::PseudoVFNMADD_VV_M2_E16_MASK,
          2833 => Opcode::PseudoVFNMADD_VV_M2_E32,
          2834 => Opcode::PseudoVFNMADD_VV_M2_E32_MASK,
          2835 => Opcode::PseudoVFNMADD_VV_M2_E64,
          2836 => Opcode::PseudoVFNMADD_VV_M2_E64_MASK,
          2837 => Opcode::PseudoVFNMADD_VV_M4_E16,
          2838 => Opcode::PseudoVFNMADD_VV_M4_E16_MASK,
          2839 => Opcode::PseudoVFNMADD_VV_M4_E32,
          2840 => Opcode::PseudoVFNMADD_VV_M4_E32_MASK,
          2841 => Opcode::PseudoVFNMADD_VV_M4_E64,
          2842 => Opcode::PseudoVFNMADD_VV_M4_E64_MASK,
          2843 => Opcode::PseudoVFNMADD_VV_M8_E16,
          2844 => Opcode::PseudoVFNMADD_VV_M8_E16_MASK,
          2845 => Opcode::PseudoVFNMADD_VV_M8_E32,
          2846 => Opcode::PseudoVFNMADD_VV_M8_E32_MASK,
          2847 => Opcode::PseudoVFNMADD_VV_M8_E64,
          2848 => Opcode::PseudoVFNMADD_VV_M8_E64_MASK,
          2849 => Opcode::PseudoVFNMADD_VV_MF2_E16,
          2850 => Opcode::PseudoVFNMADD_VV_MF2_E16_MASK,
          2851 => Opcode::PseudoVFNMADD_VV_MF2_E32,
          2852 => Opcode::PseudoVFNMADD_VV_MF2_E32_MASK,
          2853 => Opcode::PseudoVFNMADD_VV_MF4_E16,
          2854 => Opcode::PseudoVFNMADD_VV_MF4_E16_MASK,
          2855 => Opcode::PseudoVFNMSAC_VFPR16_M1_E16,
          2856 => Opcode::PseudoVFNMSAC_VFPR16_M1_E16_MASK,
          2857 => Opcode::PseudoVFNMSAC_VFPR16_M2_E16,
          2858 => Opcode::PseudoVFNMSAC_VFPR16_M2_E16_MASK,
          2859 => Opcode::PseudoVFNMSAC_VFPR16_M4_E16,
          2860 => Opcode::PseudoVFNMSAC_VFPR16_M4_E16_MASK,
          2861 => Opcode::PseudoVFNMSAC_VFPR16_M8_E16,
          2862 => Opcode::PseudoVFNMSAC_VFPR16_M8_E16_MASK,
          2863 => Opcode::PseudoVFNMSAC_VFPR16_MF2_E16,
          2864 => Opcode::PseudoVFNMSAC_VFPR16_MF2_E16_MASK,
          2865 => Opcode::PseudoVFNMSAC_VFPR16_MF4_E16,
          2866 => Opcode::PseudoVFNMSAC_VFPR16_MF4_E16_MASK,
          2867 => Opcode::PseudoVFNMSAC_VFPR32_M1_E32,
          2868 => Opcode::PseudoVFNMSAC_VFPR32_M1_E32_MASK,
          2869 => Opcode::PseudoVFNMSAC_VFPR32_M2_E32,
          2870 => Opcode::PseudoVFNMSAC_VFPR32_M2_E32_MASK,
          2871 => Opcode::PseudoVFNMSAC_VFPR32_M4_E32,
          2872 => Opcode::PseudoVFNMSAC_VFPR32_M4_E32_MASK,
          2873 => Opcode::PseudoVFNMSAC_VFPR32_M8_E32,
          2874 => Opcode::PseudoVFNMSAC_VFPR32_M8_E32_MASK,
          2875 => Opcode::PseudoVFNMSAC_VFPR32_MF2_E32,
          2876 => Opcode::PseudoVFNMSAC_VFPR32_MF2_E32_MASK,
          2877 => Opcode::PseudoVFNMSAC_VFPR64_M1_E64,
          2878 => Opcode::PseudoVFNMSAC_VFPR64_M1_E64_MASK,
          2879 => Opcode::PseudoVFNMSAC_VFPR64_M2_E64,
          2880 => Opcode::PseudoVFNMSAC_VFPR64_M2_E64_MASK,
          2881 => Opcode::PseudoVFNMSAC_VFPR64_M4_E64,
          2882 => Opcode::PseudoVFNMSAC_VFPR64_M4_E64_MASK,
          2883 => Opcode::PseudoVFNMSAC_VFPR64_M8_E64,
          2884 => Opcode::PseudoVFNMSAC_VFPR64_M8_E64_MASK,
          2885 => Opcode::PseudoVFNMSAC_VV_M1_E16,
          2886 => Opcode::PseudoVFNMSAC_VV_M1_E16_MASK,
          2887 => Opcode::PseudoVFNMSAC_VV_M1_E32,
          2888 => Opcode::PseudoVFNMSAC_VV_M1_E32_MASK,
          2889 => Opcode::PseudoVFNMSAC_VV_M1_E64,
          2890 => Opcode::PseudoVFNMSAC_VV_M1_E64_MASK,
          2891 => Opcode::PseudoVFNMSAC_VV_M2_E16,
          2892 => Opcode::PseudoVFNMSAC_VV_M2_E16_MASK,
          2893 => Opcode::PseudoVFNMSAC_VV_M2_E32,
          2894 => Opcode::PseudoVFNMSAC_VV_M2_E32_MASK,
          2895 => Opcode::PseudoVFNMSAC_VV_M2_E64,
          2896 => Opcode::PseudoVFNMSAC_VV_M2_E64_MASK,
          2897 => Opcode::PseudoVFNMSAC_VV_M4_E16,
          2898 => Opcode::PseudoVFNMSAC_VV_M4_E16_MASK,
          2899 => Opcode::PseudoVFNMSAC_VV_M4_E32,
          2900 => Opcode::PseudoVFNMSAC_VV_M4_E32_MASK,
          2901 => Opcode::PseudoVFNMSAC_VV_M4_E64,
          2902 => Opcode::PseudoVFNMSAC_VV_M4_E64_MASK,
          2903 => Opcode::PseudoVFNMSAC_VV_M8_E16,
          2904 => Opcode::PseudoVFNMSAC_VV_M8_E16_MASK,
          2905 => Opcode::PseudoVFNMSAC_VV_M8_E32,
          2906 => Opcode::PseudoVFNMSAC_VV_M8_E32_MASK,
          2907 => Opcode::PseudoVFNMSAC_VV_M8_E64,
          2908 => Opcode::PseudoVFNMSAC_VV_M8_E64_MASK,
          2909 => Opcode::PseudoVFNMSAC_VV_MF2_E16,
          2910 => Opcode::PseudoVFNMSAC_VV_MF2_E16_MASK,
          2911 => Opcode::PseudoVFNMSAC_VV_MF2_E32,
          2912 => Opcode::PseudoVFNMSAC_VV_MF2_E32_MASK,
          2913 => Opcode::PseudoVFNMSAC_VV_MF4_E16,
          2914 => Opcode::PseudoVFNMSAC_VV_MF4_E16_MASK,
          2915 => Opcode::PseudoVFNMSUB_VFPR16_M1_E16,
          2916 => Opcode::PseudoVFNMSUB_VFPR16_M1_E16_MASK,
          2917 => Opcode::PseudoVFNMSUB_VFPR16_M2_E16,
          2918 => Opcode::PseudoVFNMSUB_VFPR16_M2_E16_MASK,
          2919 => Opcode::PseudoVFNMSUB_VFPR16_M4_E16,
          2920 => Opcode::PseudoVFNMSUB_VFPR16_M4_E16_MASK,
          2921 => Opcode::PseudoVFNMSUB_VFPR16_M8_E16,
          2922 => Opcode::PseudoVFNMSUB_VFPR16_M8_E16_MASK,
          2923 => Opcode::PseudoVFNMSUB_VFPR16_MF2_E16,
          2924 => Opcode::PseudoVFNMSUB_VFPR16_MF2_E16_MASK,
          2925 => Opcode::PseudoVFNMSUB_VFPR16_MF4_E16,
          2926 => Opcode::PseudoVFNMSUB_VFPR16_MF4_E16_MASK,
          2927 => Opcode::PseudoVFNMSUB_VFPR32_M1_E32,
          2928 => Opcode::PseudoVFNMSUB_VFPR32_M1_E32_MASK,
          2929 => Opcode::PseudoVFNMSUB_VFPR32_M2_E32,
          2930 => Opcode::PseudoVFNMSUB_VFPR32_M2_E32_MASK,
          2931 => Opcode::PseudoVFNMSUB_VFPR32_M4_E32,
          2932 => Opcode::PseudoVFNMSUB_VFPR32_M4_E32_MASK,
          2933 => Opcode::PseudoVFNMSUB_VFPR32_M8_E32,
          2934 => Opcode::PseudoVFNMSUB_VFPR32_M8_E32_MASK,
          2935 => Opcode::PseudoVFNMSUB_VFPR32_MF2_E32,
          2936 => Opcode::PseudoVFNMSUB_VFPR32_MF2_E32_MASK,
          2937 => Opcode::PseudoVFNMSUB_VFPR64_M1_E64,
          2938 => Opcode::PseudoVFNMSUB_VFPR64_M1_E64_MASK,
          2939 => Opcode::PseudoVFNMSUB_VFPR64_M2_E64,
          2940 => Opcode::PseudoVFNMSUB_VFPR64_M2_E64_MASK,
          2941 => Opcode::PseudoVFNMSUB_VFPR64_M4_E64,
          2942 => Opcode::PseudoVFNMSUB_VFPR64_M4_E64_MASK,
          2943 => Opcode::PseudoVFNMSUB_VFPR64_M8_E64,
          2944 => Opcode::PseudoVFNMSUB_VFPR64_M8_E64_MASK,
          2945 => Opcode::PseudoVFNMSUB_VV_M1_E16,
          2946 => Opcode::PseudoVFNMSUB_VV_M1_E16_MASK,
          2947 => Opcode::PseudoVFNMSUB_VV_M1_E32,
          2948 => Opcode::PseudoVFNMSUB_VV_M1_E32_MASK,
          2949 => Opcode::PseudoVFNMSUB_VV_M1_E64,
          2950 => Opcode::PseudoVFNMSUB_VV_M1_E64_MASK,
          2951 => Opcode::PseudoVFNMSUB_VV_M2_E16,
          2952 => Opcode::PseudoVFNMSUB_VV_M2_E16_MASK,
          2953 => Opcode::PseudoVFNMSUB_VV_M2_E32,
          2954 => Opcode::PseudoVFNMSUB_VV_M2_E32_MASK,
          2955 => Opcode::PseudoVFNMSUB_VV_M2_E64,
          2956 => Opcode::PseudoVFNMSUB_VV_M2_E64_MASK,
          2957 => Opcode::PseudoVFNMSUB_VV_M4_E16,
          2958 => Opcode::PseudoVFNMSUB_VV_M4_E16_MASK,
          2959 => Opcode::PseudoVFNMSUB_VV_M4_E32,
          2960 => Opcode::PseudoVFNMSUB_VV_M4_E32_MASK,
          2961 => Opcode::PseudoVFNMSUB_VV_M4_E64,
          2962 => Opcode::PseudoVFNMSUB_VV_M4_E64_MASK,
          2963 => Opcode::PseudoVFNMSUB_VV_M8_E16,
          2964 => Opcode::PseudoVFNMSUB_VV_M8_E16_MASK,
          2965 => Opcode::PseudoVFNMSUB_VV_M8_E32,
          2966 => Opcode::PseudoVFNMSUB_VV_M8_E32_MASK,
          2967 => Opcode::PseudoVFNMSUB_VV_M8_E64,
          2968 => Opcode::PseudoVFNMSUB_VV_M8_E64_MASK,
          2969 => Opcode::PseudoVFNMSUB_VV_MF2_E16,
          2970 => Opcode::PseudoVFNMSUB_VV_MF2_E16_MASK,
          2971 => Opcode::PseudoVFNMSUB_VV_MF2_E32,
          2972 => Opcode::PseudoVFNMSUB_VV_MF2_E32_MASK,
          2973 => Opcode::PseudoVFNMSUB_VV_MF4_E16,
          2974 => Opcode::PseudoVFNMSUB_VV_MF4_E16_MASK,
          2975 => Opcode::PseudoVFRDIV_VFPR16_M1_E16,
          2976 => Opcode::PseudoVFRDIV_VFPR16_M1_E16_MASK,
          2977 => Opcode::PseudoVFRDIV_VFPR16_M2_E16,
          2978 => Opcode::PseudoVFRDIV_VFPR16_M2_E16_MASK,
          2979 => Opcode::PseudoVFRDIV_VFPR16_M4_E16,
          2980 => Opcode::PseudoVFRDIV_VFPR16_M4_E16_MASK,
          2981 => Opcode::PseudoVFRDIV_VFPR16_M8_E16,
          2982 => Opcode::PseudoVFRDIV_VFPR16_M8_E16_MASK,
          2983 => Opcode::PseudoVFRDIV_VFPR16_MF2_E16,
          2984 => Opcode::PseudoVFRDIV_VFPR16_MF2_E16_MASK,
          2985 => Opcode::PseudoVFRDIV_VFPR16_MF4_E16,
          2986 => Opcode::PseudoVFRDIV_VFPR16_MF4_E16_MASK,
          2987 => Opcode::PseudoVFRDIV_VFPR32_M1_E32,
          2988 => Opcode::PseudoVFRDIV_VFPR32_M1_E32_MASK,
          2989 => Opcode::PseudoVFRDIV_VFPR32_M2_E32,
          2990 => Opcode::PseudoVFRDIV_VFPR32_M2_E32_MASK,
          2991 => Opcode::PseudoVFRDIV_VFPR32_M4_E32,
          2992 => Opcode::PseudoVFRDIV_VFPR32_M4_E32_MASK,
          2993 => Opcode::PseudoVFRDIV_VFPR32_M8_E32,
          2994 => Opcode::PseudoVFRDIV_VFPR32_M8_E32_MASK,
          2995 => Opcode::PseudoVFRDIV_VFPR32_MF2_E32,
          2996 => Opcode::PseudoVFRDIV_VFPR32_MF2_E32_MASK,
          2997 => Opcode::PseudoVFRDIV_VFPR64_M1_E64,
          2998 => Opcode::PseudoVFRDIV_VFPR64_M1_E64_MASK,
          2999 => Opcode::PseudoVFRDIV_VFPR64_M2_E64,
          3000 => Opcode::PseudoVFRDIV_VFPR64_M2_E64_MASK,
          3001 => Opcode::PseudoVFRDIV_VFPR64_M4_E64,
          3002 => Opcode::PseudoVFRDIV_VFPR64_M4_E64_MASK,
          3003 => Opcode::PseudoVFRDIV_VFPR64_M8_E64,
          3004 => Opcode::PseudoVFRDIV_VFPR64_M8_E64_MASK,
          3005 => Opcode::PseudoVFREC7_V_M1_E16,
          3006 => Opcode::PseudoVFREC7_V_M1_E16_MASK,
          3007 => Opcode::PseudoVFREC7_V_M1_E32,
          3008 => Opcode::PseudoVFREC7_V_M1_E32_MASK,
          3009 => Opcode::PseudoVFREC7_V_M1_E64,
          3010 => Opcode::PseudoVFREC7_V_M1_E64_MASK,
          3011 => Opcode::PseudoVFREC7_V_M2_E16,
          3012 => Opcode::PseudoVFREC7_V_M2_E16_MASK,
          3013 => Opcode::PseudoVFREC7_V_M2_E32,
          3014 => Opcode::PseudoVFREC7_V_M2_E32_MASK,
          3015 => Opcode::PseudoVFREC7_V_M2_E64,
          3016 => Opcode::PseudoVFREC7_V_M2_E64_MASK,
          3017 => Opcode::PseudoVFREC7_V_M4_E16,
          3018 => Opcode::PseudoVFREC7_V_M4_E16_MASK,
          3019 => Opcode::PseudoVFREC7_V_M4_E32,
          3020 => Opcode::PseudoVFREC7_V_M4_E32_MASK,
          3021 => Opcode::PseudoVFREC7_V_M4_E64,
          3022 => Opcode::PseudoVFREC7_V_M4_E64_MASK,
          3023 => Opcode::PseudoVFREC7_V_M8_E16,
          3024 => Opcode::PseudoVFREC7_V_M8_E16_MASK,
          3025 => Opcode::PseudoVFREC7_V_M8_E32,
          3026 => Opcode::PseudoVFREC7_V_M8_E32_MASK,
          3027 => Opcode::PseudoVFREC7_V_M8_E64,
          3028 => Opcode::PseudoVFREC7_V_M8_E64_MASK,
          3029 => Opcode::PseudoVFREC7_V_MF2_E16,
          3030 => Opcode::PseudoVFREC7_V_MF2_E16_MASK,
          3031 => Opcode::PseudoVFREC7_V_MF2_E32,
          3032 => Opcode::PseudoVFREC7_V_MF2_E32_MASK,
          3033 => Opcode::PseudoVFREC7_V_MF4_E16,
          3034 => Opcode::PseudoVFREC7_V_MF4_E16_MASK,
          3035 => Opcode::PseudoVFREDMAX_VS_M1_E16,
          3036 => Opcode::PseudoVFREDMAX_VS_M1_E16_MASK,
          3037 => Opcode::PseudoVFREDMAX_VS_M1_E32,
          3038 => Opcode::PseudoVFREDMAX_VS_M1_E32_MASK,
          3039 => Opcode::PseudoVFREDMAX_VS_M1_E64,
          3040 => Opcode::PseudoVFREDMAX_VS_M1_E64_MASK,
          3041 => Opcode::PseudoVFREDMAX_VS_M2_E16,
          3042 => Opcode::PseudoVFREDMAX_VS_M2_E16_MASK,
          3043 => Opcode::PseudoVFREDMAX_VS_M2_E32,
          3044 => Opcode::PseudoVFREDMAX_VS_M2_E32_MASK,
          3045 => Opcode::PseudoVFREDMAX_VS_M2_E64,
          3046 => Opcode::PseudoVFREDMAX_VS_M2_E64_MASK,
          3047 => Opcode::PseudoVFREDMAX_VS_M4_E16,
          3048 => Opcode::PseudoVFREDMAX_VS_M4_E16_MASK,
          3049 => Opcode::PseudoVFREDMAX_VS_M4_E32,
          3050 => Opcode::PseudoVFREDMAX_VS_M4_E32_MASK,
          3051 => Opcode::PseudoVFREDMAX_VS_M4_E64,
          3052 => Opcode::PseudoVFREDMAX_VS_M4_E64_MASK,
          3053 => Opcode::PseudoVFREDMAX_VS_M8_E16,
          3054 => Opcode::PseudoVFREDMAX_VS_M8_E16_MASK,
          3055 => Opcode::PseudoVFREDMAX_VS_M8_E32,
          3056 => Opcode::PseudoVFREDMAX_VS_M8_E32_MASK,
          3057 => Opcode::PseudoVFREDMAX_VS_M8_E64,
          3058 => Opcode::PseudoVFREDMAX_VS_M8_E64_MASK,
          3059 => Opcode::PseudoVFREDMAX_VS_MF2_E16,
          3060 => Opcode::PseudoVFREDMAX_VS_MF2_E16_MASK,
          3061 => Opcode::PseudoVFREDMAX_VS_MF2_E32,
          3062 => Opcode::PseudoVFREDMAX_VS_MF2_E32_MASK,
          3063 => Opcode::PseudoVFREDMAX_VS_MF4_E16,
          3064 => Opcode::PseudoVFREDMAX_VS_MF4_E16_MASK,
          3065 => Opcode::PseudoVFREDMIN_VS_M1_E16,
          3066 => Opcode::PseudoVFREDMIN_VS_M1_E16_MASK,
          3067 => Opcode::PseudoVFREDMIN_VS_M1_E32,
          3068 => Opcode::PseudoVFREDMIN_VS_M1_E32_MASK,
          3069 => Opcode::PseudoVFREDMIN_VS_M1_E64,
          3070 => Opcode::PseudoVFREDMIN_VS_M1_E64_MASK,
          3071 => Opcode::PseudoVFREDMIN_VS_M2_E16,
          3072 => Opcode::PseudoVFREDMIN_VS_M2_E16_MASK,
          3073 => Opcode::PseudoVFREDMIN_VS_M2_E32,
          3074 => Opcode::PseudoVFREDMIN_VS_M2_E32_MASK,
          3075 => Opcode::PseudoVFREDMIN_VS_M2_E64,
          3076 => Opcode::PseudoVFREDMIN_VS_M2_E64_MASK,
          3077 => Opcode::PseudoVFREDMIN_VS_M4_E16,
          3078 => Opcode::PseudoVFREDMIN_VS_M4_E16_MASK,
          3079 => Opcode::PseudoVFREDMIN_VS_M4_E32,
          3080 => Opcode::PseudoVFREDMIN_VS_M4_E32_MASK,
          3081 => Opcode::PseudoVFREDMIN_VS_M4_E64,
          3082 => Opcode::PseudoVFREDMIN_VS_M4_E64_MASK,
          3083 => Opcode::PseudoVFREDMIN_VS_M8_E16,
          3084 => Opcode::PseudoVFREDMIN_VS_M8_E16_MASK,
          3085 => Opcode::PseudoVFREDMIN_VS_M8_E32,
          3086 => Opcode::PseudoVFREDMIN_VS_M8_E32_MASK,
          3087 => Opcode::PseudoVFREDMIN_VS_M8_E64,
          3088 => Opcode::PseudoVFREDMIN_VS_M8_E64_MASK,
          3089 => Opcode::PseudoVFREDMIN_VS_MF2_E16,
          3090 => Opcode::PseudoVFREDMIN_VS_MF2_E16_MASK,
          3091 => Opcode::PseudoVFREDMIN_VS_MF2_E32,
          3092 => Opcode::PseudoVFREDMIN_VS_MF2_E32_MASK,
          3093 => Opcode::PseudoVFREDMIN_VS_MF4_E16,
          3094 => Opcode::PseudoVFREDMIN_VS_MF4_E16_MASK,
          3095 => Opcode::PseudoVFREDOSUM_VS_M1_E16,
          3096 => Opcode::PseudoVFREDOSUM_VS_M1_E16_MASK,
          3097 => Opcode::PseudoVFREDOSUM_VS_M1_E32,
          3098 => Opcode::PseudoVFREDOSUM_VS_M1_E32_MASK,
          3099 => Opcode::PseudoVFREDOSUM_VS_M1_E64,
          3100 => Opcode::PseudoVFREDOSUM_VS_M1_E64_MASK,
          3101 => Opcode::PseudoVFREDOSUM_VS_M2_E16,
          3102 => Opcode::PseudoVFREDOSUM_VS_M2_E16_MASK,
          3103 => Opcode::PseudoVFREDOSUM_VS_M2_E32,
          3104 => Opcode::PseudoVFREDOSUM_VS_M2_E32_MASK,
          3105 => Opcode::PseudoVFREDOSUM_VS_M2_E64,
          3106 => Opcode::PseudoVFREDOSUM_VS_M2_E64_MASK,
          3107 => Opcode::PseudoVFREDOSUM_VS_M4_E16,
          3108 => Opcode::PseudoVFREDOSUM_VS_M4_E16_MASK,
          3109 => Opcode::PseudoVFREDOSUM_VS_M4_E32,
          3110 => Opcode::PseudoVFREDOSUM_VS_M4_E32_MASK,
          3111 => Opcode::PseudoVFREDOSUM_VS_M4_E64,
          3112 => Opcode::PseudoVFREDOSUM_VS_M4_E64_MASK,
          3113 => Opcode::PseudoVFREDOSUM_VS_M8_E16,
          3114 => Opcode::PseudoVFREDOSUM_VS_M8_E16_MASK,
          3115 => Opcode::PseudoVFREDOSUM_VS_M8_E32,
          3116 => Opcode::PseudoVFREDOSUM_VS_M8_E32_MASK,
          3117 => Opcode::PseudoVFREDOSUM_VS_M8_E64,
          3118 => Opcode::PseudoVFREDOSUM_VS_M8_E64_MASK,
          3119 => Opcode::PseudoVFREDOSUM_VS_MF2_E16,
          3120 => Opcode::PseudoVFREDOSUM_VS_MF2_E16_MASK,
          3121 => Opcode::PseudoVFREDOSUM_VS_MF2_E32,
          3122 => Opcode::PseudoVFREDOSUM_VS_MF2_E32_MASK,
          3123 => Opcode::PseudoVFREDOSUM_VS_MF4_E16,
          3124 => Opcode::PseudoVFREDOSUM_VS_MF4_E16_MASK,
          3125 => Opcode::PseudoVFREDUSUM_VS_M1_E16,
          3126 => Opcode::PseudoVFREDUSUM_VS_M1_E16_MASK,
          3127 => Opcode::PseudoVFREDUSUM_VS_M1_E32,
          3128 => Opcode::PseudoVFREDUSUM_VS_M1_E32_MASK,
          3129 => Opcode::PseudoVFREDUSUM_VS_M1_E64,
          3130 => Opcode::PseudoVFREDUSUM_VS_M1_E64_MASK,
          3131 => Opcode::PseudoVFREDUSUM_VS_M2_E16,
          3132 => Opcode::PseudoVFREDUSUM_VS_M2_E16_MASK,
          3133 => Opcode::PseudoVFREDUSUM_VS_M2_E32,
          3134 => Opcode::PseudoVFREDUSUM_VS_M2_E32_MASK,
          3135 => Opcode::PseudoVFREDUSUM_VS_M2_E64,
          3136 => Opcode::PseudoVFREDUSUM_VS_M2_E64_MASK,
          3137 => Opcode::PseudoVFREDUSUM_VS_M4_E16,
          3138 => Opcode::PseudoVFREDUSUM_VS_M4_E16_MASK,
          3139 => Opcode::PseudoVFREDUSUM_VS_M4_E32,
          3140 => Opcode::PseudoVFREDUSUM_VS_M4_E32_MASK,
          3141 => Opcode::PseudoVFREDUSUM_VS_M4_E64,
          3142 => Opcode::PseudoVFREDUSUM_VS_M4_E64_MASK,
          3143 => Opcode::PseudoVFREDUSUM_VS_M8_E16,
          3144 => Opcode::PseudoVFREDUSUM_VS_M8_E16_MASK,
          3145 => Opcode::PseudoVFREDUSUM_VS_M8_E32,
          3146 => Opcode::PseudoVFREDUSUM_VS_M8_E32_MASK,
          3147 => Opcode::PseudoVFREDUSUM_VS_M8_E64,
          3148 => Opcode::PseudoVFREDUSUM_VS_M8_E64_MASK,
          3149 => Opcode::PseudoVFREDUSUM_VS_MF2_E16,
          3150 => Opcode::PseudoVFREDUSUM_VS_MF2_E16_MASK,
          3151 => Opcode::PseudoVFREDUSUM_VS_MF2_E32,
          3152 => Opcode::PseudoVFREDUSUM_VS_MF2_E32_MASK,
          3153 => Opcode::PseudoVFREDUSUM_VS_MF4_E16,
          3154 => Opcode::PseudoVFREDUSUM_VS_MF4_E16_MASK,
          3155 => Opcode::PseudoVFROUND_NOEXCEPT_V_M1_MASK,
          3156 => Opcode::PseudoVFROUND_NOEXCEPT_V_M2_MASK,
          3157 => Opcode::PseudoVFROUND_NOEXCEPT_V_M4_MASK,
          3158 => Opcode::PseudoVFROUND_NOEXCEPT_V_M8_MASK,
          3159 => Opcode::PseudoVFROUND_NOEXCEPT_V_MF2_MASK,
          3160 => Opcode::PseudoVFROUND_NOEXCEPT_V_MF4_MASK,
          3161 => Opcode::PseudoVFRSQRT7_V_M1_E16,
          3162 => Opcode::PseudoVFRSQRT7_V_M1_E16_MASK,
          3163 => Opcode::PseudoVFRSQRT7_V_M1_E32,
          3164 => Opcode::PseudoVFRSQRT7_V_M1_E32_MASK,
          3165 => Opcode::PseudoVFRSQRT7_V_M1_E64,
          3166 => Opcode::PseudoVFRSQRT7_V_M1_E64_MASK,
          3167 => Opcode::PseudoVFRSQRT7_V_M2_E16,
          3168 => Opcode::PseudoVFRSQRT7_V_M2_E16_MASK,
          3169 => Opcode::PseudoVFRSQRT7_V_M2_E32,
          3170 => Opcode::PseudoVFRSQRT7_V_M2_E32_MASK,
          3171 => Opcode::PseudoVFRSQRT7_V_M2_E64,
          3172 => Opcode::PseudoVFRSQRT7_V_M2_E64_MASK,
          3173 => Opcode::PseudoVFRSQRT7_V_M4_E16,
          3174 => Opcode::PseudoVFRSQRT7_V_M4_E16_MASK,
          3175 => Opcode::PseudoVFRSQRT7_V_M4_E32,
          3176 => Opcode::PseudoVFRSQRT7_V_M4_E32_MASK,
          3177 => Opcode::PseudoVFRSQRT7_V_M4_E64,
          3178 => Opcode::PseudoVFRSQRT7_V_M4_E64_MASK,
          3179 => Opcode::PseudoVFRSQRT7_V_M8_E16,
          3180 => Opcode::PseudoVFRSQRT7_V_M8_E16_MASK,
          3181 => Opcode::PseudoVFRSQRT7_V_M8_E32,
          3182 => Opcode::PseudoVFRSQRT7_V_M8_E32_MASK,
          3183 => Opcode::PseudoVFRSQRT7_V_M8_E64,
          3184 => Opcode::PseudoVFRSQRT7_V_M8_E64_MASK,
          3185 => Opcode::PseudoVFRSQRT7_V_MF2_E16,
          3186 => Opcode::PseudoVFRSQRT7_V_MF2_E16_MASK,
          3187 => Opcode::PseudoVFRSQRT7_V_MF2_E32,
          3188 => Opcode::PseudoVFRSQRT7_V_MF2_E32_MASK,
          3189 => Opcode::PseudoVFRSQRT7_V_MF4_E16,
          3190 => Opcode::PseudoVFRSQRT7_V_MF4_E16_MASK,
          3191 => Opcode::PseudoVFRSUB_VFPR16_M1_E16,
          3192 => Opcode::PseudoVFRSUB_VFPR16_M1_E16_MASK,
          3193 => Opcode::PseudoVFRSUB_VFPR16_M2_E16,
          3194 => Opcode::PseudoVFRSUB_VFPR16_M2_E16_MASK,
          3195 => Opcode::PseudoVFRSUB_VFPR16_M4_E16,
          3196 => Opcode::PseudoVFRSUB_VFPR16_M4_E16_MASK,
          3197 => Opcode::PseudoVFRSUB_VFPR16_M8_E16,
          3198 => Opcode::PseudoVFRSUB_VFPR16_M8_E16_MASK,
          3199 => Opcode::PseudoVFRSUB_VFPR16_MF2_E16,
          3200 => Opcode::PseudoVFRSUB_VFPR16_MF2_E16_MASK,
          3201 => Opcode::PseudoVFRSUB_VFPR16_MF4_E16,
          3202 => Opcode::PseudoVFRSUB_VFPR16_MF4_E16_MASK,
          3203 => Opcode::PseudoVFRSUB_VFPR32_M1_E32,
          3204 => Opcode::PseudoVFRSUB_VFPR32_M1_E32_MASK,
          3205 => Opcode::PseudoVFRSUB_VFPR32_M2_E32,
          3206 => Opcode::PseudoVFRSUB_VFPR32_M2_E32_MASK,
          3207 => Opcode::PseudoVFRSUB_VFPR32_M4_E32,
          3208 => Opcode::PseudoVFRSUB_VFPR32_M4_E32_MASK,
          3209 => Opcode::PseudoVFRSUB_VFPR32_M8_E32,
          3210 => Opcode::PseudoVFRSUB_VFPR32_M8_E32_MASK,
          3211 => Opcode::PseudoVFRSUB_VFPR32_MF2_E32,
          3212 => Opcode::PseudoVFRSUB_VFPR32_MF2_E32_MASK,
          3213 => Opcode::PseudoVFRSUB_VFPR64_M1_E64,
          3214 => Opcode::PseudoVFRSUB_VFPR64_M1_E64_MASK,
          3215 => Opcode::PseudoVFRSUB_VFPR64_M2_E64,
          3216 => Opcode::PseudoVFRSUB_VFPR64_M2_E64_MASK,
          3217 => Opcode::PseudoVFRSUB_VFPR64_M4_E64,
          3218 => Opcode::PseudoVFRSUB_VFPR64_M4_E64_MASK,
          3219 => Opcode::PseudoVFRSUB_VFPR64_M8_E64,
          3220 => Opcode::PseudoVFRSUB_VFPR64_M8_E64_MASK,
          3221 => Opcode::PseudoVFSGNJN_VFPR16_M1_E16,
          3222 => Opcode::PseudoVFSGNJN_VFPR16_M1_E16_MASK,
          3223 => Opcode::PseudoVFSGNJN_VFPR16_M2_E16,
          3224 => Opcode::PseudoVFSGNJN_VFPR16_M2_E16_MASK,
          3225 => Opcode::PseudoVFSGNJN_VFPR16_M4_E16,
          3226 => Opcode::PseudoVFSGNJN_VFPR16_M4_E16_MASK,
          3227 => Opcode::PseudoVFSGNJN_VFPR16_M8_E16,
          3228 => Opcode::PseudoVFSGNJN_VFPR16_M8_E16_MASK,
          3229 => Opcode::PseudoVFSGNJN_VFPR16_MF2_E16,
          3230 => Opcode::PseudoVFSGNJN_VFPR16_MF2_E16_MASK,
          3231 => Opcode::PseudoVFSGNJN_VFPR16_MF4_E16,
          3232 => Opcode::PseudoVFSGNJN_VFPR16_MF4_E16_MASK,
          3233 => Opcode::PseudoVFSGNJN_VFPR32_M1_E32,
          3234 => Opcode::PseudoVFSGNJN_VFPR32_M1_E32_MASK,
          3235 => Opcode::PseudoVFSGNJN_VFPR32_M2_E32,
          3236 => Opcode::PseudoVFSGNJN_VFPR32_M2_E32_MASK,
          3237 => Opcode::PseudoVFSGNJN_VFPR32_M4_E32,
          3238 => Opcode::PseudoVFSGNJN_VFPR32_M4_E32_MASK,
          3239 => Opcode::PseudoVFSGNJN_VFPR32_M8_E32,
          3240 => Opcode::PseudoVFSGNJN_VFPR32_M8_E32_MASK,
          3241 => Opcode::PseudoVFSGNJN_VFPR32_MF2_E32,
          3242 => Opcode::PseudoVFSGNJN_VFPR32_MF2_E32_MASK,
          3243 => Opcode::PseudoVFSGNJN_VFPR64_M1_E64,
          3244 => Opcode::PseudoVFSGNJN_VFPR64_M1_E64_MASK,
          3245 => Opcode::PseudoVFSGNJN_VFPR64_M2_E64,
          3246 => Opcode::PseudoVFSGNJN_VFPR64_M2_E64_MASK,
          3247 => Opcode::PseudoVFSGNJN_VFPR64_M4_E64,
          3248 => Opcode::PseudoVFSGNJN_VFPR64_M4_E64_MASK,
          3249 => Opcode::PseudoVFSGNJN_VFPR64_M8_E64,
          3250 => Opcode::PseudoVFSGNJN_VFPR64_M8_E64_MASK,
          3251 => Opcode::PseudoVFSGNJN_VV_M1_E16,
          3252 => Opcode::PseudoVFSGNJN_VV_M1_E16_MASK,
          3253 => Opcode::PseudoVFSGNJN_VV_M1_E32,
          3254 => Opcode::PseudoVFSGNJN_VV_M1_E32_MASK,
          3255 => Opcode::PseudoVFSGNJN_VV_M1_E64,
          3256 => Opcode::PseudoVFSGNJN_VV_M1_E64_MASK,
          3257 => Opcode::PseudoVFSGNJN_VV_M2_E16,
          3258 => Opcode::PseudoVFSGNJN_VV_M2_E16_MASK,
          3259 => Opcode::PseudoVFSGNJN_VV_M2_E32,
          3260 => Opcode::PseudoVFSGNJN_VV_M2_E32_MASK,
          3261 => Opcode::PseudoVFSGNJN_VV_M2_E64,
          3262 => Opcode::PseudoVFSGNJN_VV_M2_E64_MASK,
          3263 => Opcode::PseudoVFSGNJN_VV_M4_E16,
          3264 => Opcode::PseudoVFSGNJN_VV_M4_E16_MASK,
          3265 => Opcode::PseudoVFSGNJN_VV_M4_E32,
          3266 => Opcode::PseudoVFSGNJN_VV_M4_E32_MASK,
          3267 => Opcode::PseudoVFSGNJN_VV_M4_E64,
          3268 => Opcode::PseudoVFSGNJN_VV_M4_E64_MASK,
          3269 => Opcode::PseudoVFSGNJN_VV_M8_E16,
          3270 => Opcode::PseudoVFSGNJN_VV_M8_E16_MASK,
          3271 => Opcode::PseudoVFSGNJN_VV_M8_E32,
          3272 => Opcode::PseudoVFSGNJN_VV_M8_E32_MASK,
          3273 => Opcode::PseudoVFSGNJN_VV_M8_E64,
          3274 => Opcode::PseudoVFSGNJN_VV_M8_E64_MASK,
          3275 => Opcode::PseudoVFSGNJN_VV_MF2_E16,
          3276 => Opcode::PseudoVFSGNJN_VV_MF2_E16_MASK,
          3277 => Opcode::PseudoVFSGNJN_VV_MF2_E32,
          3278 => Opcode::PseudoVFSGNJN_VV_MF2_E32_MASK,
          3279 => Opcode::PseudoVFSGNJN_VV_MF4_E16,
          3280 => Opcode::PseudoVFSGNJN_VV_MF4_E16_MASK,
          3281 => Opcode::PseudoVFSGNJX_VFPR16_M1_E16,
          3282 => Opcode::PseudoVFSGNJX_VFPR16_M1_E16_MASK,
          3283 => Opcode::PseudoVFSGNJX_VFPR16_M2_E16,
          3284 => Opcode::PseudoVFSGNJX_VFPR16_M2_E16_MASK,
          3285 => Opcode::PseudoVFSGNJX_VFPR16_M4_E16,
          3286 => Opcode::PseudoVFSGNJX_VFPR16_M4_E16_MASK,
          3287 => Opcode::PseudoVFSGNJX_VFPR16_M8_E16,
          3288 => Opcode::PseudoVFSGNJX_VFPR16_M8_E16_MASK,
          3289 => Opcode::PseudoVFSGNJX_VFPR16_MF2_E16,
          3290 => Opcode::PseudoVFSGNJX_VFPR16_MF2_E16_MASK,
          3291 => Opcode::PseudoVFSGNJX_VFPR16_MF4_E16,
          3292 => Opcode::PseudoVFSGNJX_VFPR16_MF4_E16_MASK,
          3293 => Opcode::PseudoVFSGNJX_VFPR32_M1_E32,
          3294 => Opcode::PseudoVFSGNJX_VFPR32_M1_E32_MASK,
          3295 => Opcode::PseudoVFSGNJX_VFPR32_M2_E32,
          3296 => Opcode::PseudoVFSGNJX_VFPR32_M2_E32_MASK,
          3297 => Opcode::PseudoVFSGNJX_VFPR32_M4_E32,
          3298 => Opcode::PseudoVFSGNJX_VFPR32_M4_E32_MASK,
          3299 => Opcode::PseudoVFSGNJX_VFPR32_M8_E32,
          3300 => Opcode::PseudoVFSGNJX_VFPR32_M8_E32_MASK,
          3301 => Opcode::PseudoVFSGNJX_VFPR32_MF2_E32,
          3302 => Opcode::PseudoVFSGNJX_VFPR32_MF2_E32_MASK,
          3303 => Opcode::PseudoVFSGNJX_VFPR64_M1_E64,
          3304 => Opcode::PseudoVFSGNJX_VFPR64_M1_E64_MASK,
          3305 => Opcode::PseudoVFSGNJX_VFPR64_M2_E64,
          3306 => Opcode::PseudoVFSGNJX_VFPR64_M2_E64_MASK,
          3307 => Opcode::PseudoVFSGNJX_VFPR64_M4_E64,
          3308 => Opcode::PseudoVFSGNJX_VFPR64_M4_E64_MASK,
          3309 => Opcode::PseudoVFSGNJX_VFPR64_M8_E64,
          3310 => Opcode::PseudoVFSGNJX_VFPR64_M8_E64_MASK,
          3311 => Opcode::PseudoVFSGNJX_VV_M1_E16,
          3312 => Opcode::PseudoVFSGNJX_VV_M1_E16_MASK,
          3313 => Opcode::PseudoVFSGNJX_VV_M1_E32,
          3314 => Opcode::PseudoVFSGNJX_VV_M1_E32_MASK,
          3315 => Opcode::PseudoVFSGNJX_VV_M1_E64,
          3316 => Opcode::PseudoVFSGNJX_VV_M1_E64_MASK,
          3317 => Opcode::PseudoVFSGNJX_VV_M2_E16,
          3318 => Opcode::PseudoVFSGNJX_VV_M2_E16_MASK,
          3319 => Opcode::PseudoVFSGNJX_VV_M2_E32,
          3320 => Opcode::PseudoVFSGNJX_VV_M2_E32_MASK,
          3321 => Opcode::PseudoVFSGNJX_VV_M2_E64,
          3322 => Opcode::PseudoVFSGNJX_VV_M2_E64_MASK,
          3323 => Opcode::PseudoVFSGNJX_VV_M4_E16,
          3324 => Opcode::PseudoVFSGNJX_VV_M4_E16_MASK,
          3325 => Opcode::PseudoVFSGNJX_VV_M4_E32,
          3326 => Opcode::PseudoVFSGNJX_VV_M4_E32_MASK,
          3327 => Opcode::PseudoVFSGNJX_VV_M4_E64,
          3328 => Opcode::PseudoVFSGNJX_VV_M4_E64_MASK,
          3329 => Opcode::PseudoVFSGNJX_VV_M8_E16,
          3330 => Opcode::PseudoVFSGNJX_VV_M8_E16_MASK,
          3331 => Opcode::PseudoVFSGNJX_VV_M8_E32,
          3332 => Opcode::PseudoVFSGNJX_VV_M8_E32_MASK,
          3333 => Opcode::PseudoVFSGNJX_VV_M8_E64,
          3334 => Opcode::PseudoVFSGNJX_VV_M8_E64_MASK,
          3335 => Opcode::PseudoVFSGNJX_VV_MF2_E16,
          3336 => Opcode::PseudoVFSGNJX_VV_MF2_E16_MASK,
          3337 => Opcode::PseudoVFSGNJX_VV_MF2_E32,
          3338 => Opcode::PseudoVFSGNJX_VV_MF2_E32_MASK,
          3339 => Opcode::PseudoVFSGNJX_VV_MF4_E16,
          3340 => Opcode::PseudoVFSGNJX_VV_MF4_E16_MASK,
          3341 => Opcode::PseudoVFSGNJ_VFPR16_M1_E16,
          3342 => Opcode::PseudoVFSGNJ_VFPR16_M1_E16_MASK,
          3343 => Opcode::PseudoVFSGNJ_VFPR16_M2_E16,
          3344 => Opcode::PseudoVFSGNJ_VFPR16_M2_E16_MASK,
          3345 => Opcode::PseudoVFSGNJ_VFPR16_M4_E16,
          3346 => Opcode::PseudoVFSGNJ_VFPR16_M4_E16_MASK,
          3347 => Opcode::PseudoVFSGNJ_VFPR16_M8_E16,
          3348 => Opcode::PseudoVFSGNJ_VFPR16_M8_E16_MASK,
          3349 => Opcode::PseudoVFSGNJ_VFPR16_MF2_E16,
          3350 => Opcode::PseudoVFSGNJ_VFPR16_MF2_E16_MASK,
          3351 => Opcode::PseudoVFSGNJ_VFPR16_MF4_E16,
          3352 => Opcode::PseudoVFSGNJ_VFPR16_MF4_E16_MASK,
          3353 => Opcode::PseudoVFSGNJ_VFPR32_M1_E32,
          3354 => Opcode::PseudoVFSGNJ_VFPR32_M1_E32_MASK,
          3355 => Opcode::PseudoVFSGNJ_VFPR32_M2_E32,
          3356 => Opcode::PseudoVFSGNJ_VFPR32_M2_E32_MASK,
          3357 => Opcode::PseudoVFSGNJ_VFPR32_M4_E32,
          3358 => Opcode::PseudoVFSGNJ_VFPR32_M4_E32_MASK,
          3359 => Opcode::PseudoVFSGNJ_VFPR32_M8_E32,
          3360 => Opcode::PseudoVFSGNJ_VFPR32_M8_E32_MASK,
          3361 => Opcode::PseudoVFSGNJ_VFPR32_MF2_E32,
          3362 => Opcode::PseudoVFSGNJ_VFPR32_MF2_E32_MASK,
          3363 => Opcode::PseudoVFSGNJ_VFPR64_M1_E64,
          3364 => Opcode::PseudoVFSGNJ_VFPR64_M1_E64_MASK,
          3365 => Opcode::PseudoVFSGNJ_VFPR64_M2_E64,
          3366 => Opcode::PseudoVFSGNJ_VFPR64_M2_E64_MASK,
          3367 => Opcode::PseudoVFSGNJ_VFPR64_M4_E64,
          3368 => Opcode::PseudoVFSGNJ_VFPR64_M4_E64_MASK,
          3369 => Opcode::PseudoVFSGNJ_VFPR64_M8_E64,
          3370 => Opcode::PseudoVFSGNJ_VFPR64_M8_E64_MASK,
          3371 => Opcode::PseudoVFSGNJ_VV_M1_E16,
          3372 => Opcode::PseudoVFSGNJ_VV_M1_E16_MASK,
          3373 => Opcode::PseudoVFSGNJ_VV_M1_E32,
          3374 => Opcode::PseudoVFSGNJ_VV_M1_E32_MASK,
          3375 => Opcode::PseudoVFSGNJ_VV_M1_E64,
          3376 => Opcode::PseudoVFSGNJ_VV_M1_E64_MASK,
          3377 => Opcode::PseudoVFSGNJ_VV_M2_E16,
          3378 => Opcode::PseudoVFSGNJ_VV_M2_E16_MASK,
          3379 => Opcode::PseudoVFSGNJ_VV_M2_E32,
          3380 => Opcode::PseudoVFSGNJ_VV_M2_E32_MASK,
          3381 => Opcode::PseudoVFSGNJ_VV_M2_E64,
          3382 => Opcode::PseudoVFSGNJ_VV_M2_E64_MASK,
          3383 => Opcode::PseudoVFSGNJ_VV_M4_E16,
          3384 => Opcode::PseudoVFSGNJ_VV_M4_E16_MASK,
          3385 => Opcode::PseudoVFSGNJ_VV_M4_E32,
          3386 => Opcode::PseudoVFSGNJ_VV_M4_E32_MASK,
          3387 => Opcode::PseudoVFSGNJ_VV_M4_E64,
          3388 => Opcode::PseudoVFSGNJ_VV_M4_E64_MASK,
          3389 => Opcode::PseudoVFSGNJ_VV_M8_E16,
          3390 => Opcode::PseudoVFSGNJ_VV_M8_E16_MASK,
          3391 => Opcode::PseudoVFSGNJ_VV_M8_E32,
          3392 => Opcode::PseudoVFSGNJ_VV_M8_E32_MASK,
          3393 => Opcode::PseudoVFSGNJ_VV_M8_E64,
          3394 => Opcode::PseudoVFSGNJ_VV_M8_E64_MASK,
          3395 => Opcode::PseudoVFSGNJ_VV_MF2_E16,
          3396 => Opcode::PseudoVFSGNJ_VV_MF2_E16_MASK,
          3397 => Opcode::PseudoVFSGNJ_VV_MF2_E32,
          3398 => Opcode::PseudoVFSGNJ_VV_MF2_E32_MASK,
          3399 => Opcode::PseudoVFSGNJ_VV_MF4_E16,
          3400 => Opcode::PseudoVFSGNJ_VV_MF4_E16_MASK,
          3401 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M1,
          3402 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M1_MASK,
          3403 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M2,
          3404 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M2_MASK,
          3405 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M4,
          3406 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M4_MASK,
          3407 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M8,
          3408 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M8_MASK,
          3409 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_MF2,
          3410 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_MF2_MASK,
          3411 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_MF4,
          3412 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_MF4_MASK,
          3413 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M1,
          3414 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M1_MASK,
          3415 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M2,
          3416 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M2_MASK,
          3417 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M4,
          3418 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M4_MASK,
          3419 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M8,
          3420 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M8_MASK,
          3421 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_MF2,
          3422 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_MF2_MASK,
          3423 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M1,
          3424 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M1_MASK,
          3425 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M2,
          3426 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M2_MASK,
          3427 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M4,
          3428 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M4_MASK,
          3429 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M8,
          3430 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M8_MASK,
          3431 => Opcode::PseudoVFSLIDE1UP_VFPR16_M1,
          3432 => Opcode::PseudoVFSLIDE1UP_VFPR16_M1_MASK,
          3433 => Opcode::PseudoVFSLIDE1UP_VFPR16_M2,
          3434 => Opcode::PseudoVFSLIDE1UP_VFPR16_M2_MASK,
          3435 => Opcode::PseudoVFSLIDE1UP_VFPR16_M4,
          3436 => Opcode::PseudoVFSLIDE1UP_VFPR16_M4_MASK,
          3437 => Opcode::PseudoVFSLIDE1UP_VFPR16_M8,
          3438 => Opcode::PseudoVFSLIDE1UP_VFPR16_M8_MASK,
          3439 => Opcode::PseudoVFSLIDE1UP_VFPR16_MF2,
          3440 => Opcode::PseudoVFSLIDE1UP_VFPR16_MF2_MASK,
          3441 => Opcode::PseudoVFSLIDE1UP_VFPR16_MF4,
          3442 => Opcode::PseudoVFSLIDE1UP_VFPR16_MF4_MASK,
          3443 => Opcode::PseudoVFSLIDE1UP_VFPR32_M1,
          3444 => Opcode::PseudoVFSLIDE1UP_VFPR32_M1_MASK,
          3445 => Opcode::PseudoVFSLIDE1UP_VFPR32_M2,
          3446 => Opcode::PseudoVFSLIDE1UP_VFPR32_M2_MASK,
          3447 => Opcode::PseudoVFSLIDE1UP_VFPR32_M4,
          3448 => Opcode::PseudoVFSLIDE1UP_VFPR32_M4_MASK,
          3449 => Opcode::PseudoVFSLIDE1UP_VFPR32_M8,
          3450 => Opcode::PseudoVFSLIDE1UP_VFPR32_M8_MASK,
          3451 => Opcode::PseudoVFSLIDE1UP_VFPR32_MF2,
          3452 => Opcode::PseudoVFSLIDE1UP_VFPR32_MF2_MASK,
          3453 => Opcode::PseudoVFSLIDE1UP_VFPR64_M1,
          3454 => Opcode::PseudoVFSLIDE1UP_VFPR64_M1_MASK,
          3455 => Opcode::PseudoVFSLIDE1UP_VFPR64_M2,
          3456 => Opcode::PseudoVFSLIDE1UP_VFPR64_M2_MASK,
          3457 => Opcode::PseudoVFSLIDE1UP_VFPR64_M4,
          3458 => Opcode::PseudoVFSLIDE1UP_VFPR64_M4_MASK,
          3459 => Opcode::PseudoVFSLIDE1UP_VFPR64_M8,
          3460 => Opcode::PseudoVFSLIDE1UP_VFPR64_M8_MASK,
          3461 => Opcode::PseudoVFSQRT_V_M1_E16,
          3462 => Opcode::PseudoVFSQRT_V_M1_E16_MASK,
          3463 => Opcode::PseudoVFSQRT_V_M1_E32,
          3464 => Opcode::PseudoVFSQRT_V_M1_E32_MASK,
          3465 => Opcode::PseudoVFSQRT_V_M1_E64,
          3466 => Opcode::PseudoVFSQRT_V_M1_E64_MASK,
          3467 => Opcode::PseudoVFSQRT_V_M2_E16,
          3468 => Opcode::PseudoVFSQRT_V_M2_E16_MASK,
          3469 => Opcode::PseudoVFSQRT_V_M2_E32,
          3470 => Opcode::PseudoVFSQRT_V_M2_E32_MASK,
          3471 => Opcode::PseudoVFSQRT_V_M2_E64,
          3472 => Opcode::PseudoVFSQRT_V_M2_E64_MASK,
          3473 => Opcode::PseudoVFSQRT_V_M4_E16,
          3474 => Opcode::PseudoVFSQRT_V_M4_E16_MASK,
          3475 => Opcode::PseudoVFSQRT_V_M4_E32,
          3476 => Opcode::PseudoVFSQRT_V_M4_E32_MASK,
          3477 => Opcode::PseudoVFSQRT_V_M4_E64,
          3478 => Opcode::PseudoVFSQRT_V_M4_E64_MASK,
          3479 => Opcode::PseudoVFSQRT_V_M8_E16,
          3480 => Opcode::PseudoVFSQRT_V_M8_E16_MASK,
          3481 => Opcode::PseudoVFSQRT_V_M8_E32,
          3482 => Opcode::PseudoVFSQRT_V_M8_E32_MASK,
          3483 => Opcode::PseudoVFSQRT_V_M8_E64,
          3484 => Opcode::PseudoVFSQRT_V_M8_E64_MASK,
          3485 => Opcode::PseudoVFSQRT_V_MF2_E16,
          3486 => Opcode::PseudoVFSQRT_V_MF2_E16_MASK,
          3487 => Opcode::PseudoVFSQRT_V_MF2_E32,
          3488 => Opcode::PseudoVFSQRT_V_MF2_E32_MASK,
          3489 => Opcode::PseudoVFSQRT_V_MF4_E16,
          3490 => Opcode::PseudoVFSQRT_V_MF4_E16_MASK,
          3491 => Opcode::PseudoVFSUB_VFPR16_M1_E16,
          3492 => Opcode::PseudoVFSUB_VFPR16_M1_E16_MASK,
          3493 => Opcode::PseudoVFSUB_VFPR16_M2_E16,
          3494 => Opcode::PseudoVFSUB_VFPR16_M2_E16_MASK,
          3495 => Opcode::PseudoVFSUB_VFPR16_M4_E16,
          3496 => Opcode::PseudoVFSUB_VFPR16_M4_E16_MASK,
          3497 => Opcode::PseudoVFSUB_VFPR16_M8_E16,
          3498 => Opcode::PseudoVFSUB_VFPR16_M8_E16_MASK,
          3499 => Opcode::PseudoVFSUB_VFPR16_MF2_E16,
          3500 => Opcode::PseudoVFSUB_VFPR16_MF2_E16_MASK,
          3501 => Opcode::PseudoVFSUB_VFPR16_MF4_E16,
          3502 => Opcode::PseudoVFSUB_VFPR16_MF4_E16_MASK,
          3503 => Opcode::PseudoVFSUB_VFPR32_M1_E32,
          3504 => Opcode::PseudoVFSUB_VFPR32_M1_E32_MASK,
          3505 => Opcode::PseudoVFSUB_VFPR32_M2_E32,
          3506 => Opcode::PseudoVFSUB_VFPR32_M2_E32_MASK,
          3507 => Opcode::PseudoVFSUB_VFPR32_M4_E32,
          3508 => Opcode::PseudoVFSUB_VFPR32_M4_E32_MASK,
          3509 => Opcode::PseudoVFSUB_VFPR32_M8_E32,
          3510 => Opcode::PseudoVFSUB_VFPR32_M8_E32_MASK,
          3511 => Opcode::PseudoVFSUB_VFPR32_MF2_E32,
          3512 => Opcode::PseudoVFSUB_VFPR32_MF2_E32_MASK,
          3513 => Opcode::PseudoVFSUB_VFPR64_M1_E64,
          3514 => Opcode::PseudoVFSUB_VFPR64_M1_E64_MASK,
          3515 => Opcode::PseudoVFSUB_VFPR64_M2_E64,
          3516 => Opcode::PseudoVFSUB_VFPR64_M2_E64_MASK,
          3517 => Opcode::PseudoVFSUB_VFPR64_M4_E64,
          3518 => Opcode::PseudoVFSUB_VFPR64_M4_E64_MASK,
          3519 => Opcode::PseudoVFSUB_VFPR64_M8_E64,
          3520 => Opcode::PseudoVFSUB_VFPR64_M8_E64_MASK,
          3521 => Opcode::PseudoVFSUB_VV_M1_E16,
          3522 => Opcode::PseudoVFSUB_VV_M1_E16_MASK,
          3523 => Opcode::PseudoVFSUB_VV_M1_E32,
          3524 => Opcode::PseudoVFSUB_VV_M1_E32_MASK,
          3525 => Opcode::PseudoVFSUB_VV_M1_E64,
          3526 => Opcode::PseudoVFSUB_VV_M1_E64_MASK,
          3527 => Opcode::PseudoVFSUB_VV_M2_E16,
          3528 => Opcode::PseudoVFSUB_VV_M2_E16_MASK,
          3529 => Opcode::PseudoVFSUB_VV_M2_E32,
          3530 => Opcode::PseudoVFSUB_VV_M2_E32_MASK,
          3531 => Opcode::PseudoVFSUB_VV_M2_E64,
          3532 => Opcode::PseudoVFSUB_VV_M2_E64_MASK,
          3533 => Opcode::PseudoVFSUB_VV_M4_E16,
          3534 => Opcode::PseudoVFSUB_VV_M4_E16_MASK,
          3535 => Opcode::PseudoVFSUB_VV_M4_E32,
          3536 => Opcode::PseudoVFSUB_VV_M4_E32_MASK,
          3537 => Opcode::PseudoVFSUB_VV_M4_E64,
          3538 => Opcode::PseudoVFSUB_VV_M4_E64_MASK,
          3539 => Opcode::PseudoVFSUB_VV_M8_E16,
          3540 => Opcode::PseudoVFSUB_VV_M8_E16_MASK,
          3541 => Opcode::PseudoVFSUB_VV_M8_E32,
          3542 => Opcode::PseudoVFSUB_VV_M8_E32_MASK,
          3543 => Opcode::PseudoVFSUB_VV_M8_E64,
          3544 => Opcode::PseudoVFSUB_VV_M8_E64_MASK,
          3545 => Opcode::PseudoVFSUB_VV_MF2_E16,
          3546 => Opcode::PseudoVFSUB_VV_MF2_E16_MASK,
          3547 => Opcode::PseudoVFSUB_VV_MF2_E32,
          3548 => Opcode::PseudoVFSUB_VV_MF2_E32_MASK,
          3549 => Opcode::PseudoVFSUB_VV_MF4_E16,
          3550 => Opcode::PseudoVFSUB_VV_MF4_E16_MASK,
          3551 => Opcode::PseudoVFWADD_VFPR16_M1_E16,
          3552 => Opcode::PseudoVFWADD_VFPR16_M1_E16_MASK,
          3553 => Opcode::PseudoVFWADD_VFPR16_M2_E16,
          3554 => Opcode::PseudoVFWADD_VFPR16_M2_E16_MASK,
          3555 => Opcode::PseudoVFWADD_VFPR16_M4_E16,
          3556 => Opcode::PseudoVFWADD_VFPR16_M4_E16_MASK,
          3557 => Opcode::PseudoVFWADD_VFPR16_MF2_E16,
          3558 => Opcode::PseudoVFWADD_VFPR16_MF2_E16_MASK,
          3559 => Opcode::PseudoVFWADD_VFPR16_MF4_E16,
          3560 => Opcode::PseudoVFWADD_VFPR16_MF4_E16_MASK,
          3561 => Opcode::PseudoVFWADD_VFPR32_M1_E32,
          3562 => Opcode::PseudoVFWADD_VFPR32_M1_E32_MASK,
          3563 => Opcode::PseudoVFWADD_VFPR32_M2_E32,
          3564 => Opcode::PseudoVFWADD_VFPR32_M2_E32_MASK,
          3565 => Opcode::PseudoVFWADD_VFPR32_M4_E32,
          3566 => Opcode::PseudoVFWADD_VFPR32_M4_E32_MASK,
          3567 => Opcode::PseudoVFWADD_VFPR32_MF2_E32,
          3568 => Opcode::PseudoVFWADD_VFPR32_MF2_E32_MASK,
          3569 => Opcode::PseudoVFWADD_VV_M1_E16,
          3570 => Opcode::PseudoVFWADD_VV_M1_E16_MASK,
          3571 => Opcode::PseudoVFWADD_VV_M1_E32,
          3572 => Opcode::PseudoVFWADD_VV_M1_E32_MASK,
          3573 => Opcode::PseudoVFWADD_VV_M2_E16,
          3574 => Opcode::PseudoVFWADD_VV_M2_E16_MASK,
          3575 => Opcode::PseudoVFWADD_VV_M2_E32,
          3576 => Opcode::PseudoVFWADD_VV_M2_E32_MASK,
          3577 => Opcode::PseudoVFWADD_VV_M4_E16,
          3578 => Opcode::PseudoVFWADD_VV_M4_E16_MASK,
          3579 => Opcode::PseudoVFWADD_VV_M4_E32,
          3580 => Opcode::PseudoVFWADD_VV_M4_E32_MASK,
          3581 => Opcode::PseudoVFWADD_VV_MF2_E16,
          3582 => Opcode::PseudoVFWADD_VV_MF2_E16_MASK,
          3583 => Opcode::PseudoVFWADD_VV_MF2_E32,
          3584 => Opcode::PseudoVFWADD_VV_MF2_E32_MASK,
          3585 => Opcode::PseudoVFWADD_VV_MF4_E16,
          3586 => Opcode::PseudoVFWADD_VV_MF4_E16_MASK,
          3587 => Opcode::PseudoVFWADD_WFPR16_M1_E16,
          3588 => Opcode::PseudoVFWADD_WFPR16_M1_E16_MASK,
          3589 => Opcode::PseudoVFWADD_WFPR16_M2_E16,
          3590 => Opcode::PseudoVFWADD_WFPR16_M2_E16_MASK,
          3591 => Opcode::PseudoVFWADD_WFPR16_M4_E16,
          3592 => Opcode::PseudoVFWADD_WFPR16_M4_E16_MASK,
          3593 => Opcode::PseudoVFWADD_WFPR16_MF2_E16,
          3594 => Opcode::PseudoVFWADD_WFPR16_MF2_E16_MASK,
          3595 => Opcode::PseudoVFWADD_WFPR16_MF4_E16,
          3596 => Opcode::PseudoVFWADD_WFPR16_MF4_E16_MASK,
          3597 => Opcode::PseudoVFWADD_WFPR32_M1_E32,
          3598 => Opcode::PseudoVFWADD_WFPR32_M1_E32_MASK,
          3599 => Opcode::PseudoVFWADD_WFPR32_M2_E32,
          3600 => Opcode::PseudoVFWADD_WFPR32_M2_E32_MASK,
          3601 => Opcode::PseudoVFWADD_WFPR32_M4_E32,
          3602 => Opcode::PseudoVFWADD_WFPR32_M4_E32_MASK,
          3603 => Opcode::PseudoVFWADD_WFPR32_MF2_E32,
          3604 => Opcode::PseudoVFWADD_WFPR32_MF2_E32_MASK,
          3605 => Opcode::PseudoVFWADD_WV_M1_E16,
          3606 => Opcode::PseudoVFWADD_WV_M1_E16_MASK,
          3607 => Opcode::PseudoVFWADD_WV_M1_E16_MASK_TIED,
          3608 => Opcode::PseudoVFWADD_WV_M1_E16_TIED,
          3609 => Opcode::PseudoVFWADD_WV_M1_E32,
          3610 => Opcode::PseudoVFWADD_WV_M1_E32_MASK,
          3611 => Opcode::PseudoVFWADD_WV_M1_E32_MASK_TIED,
          3612 => Opcode::PseudoVFWADD_WV_M1_E32_TIED,
          3613 => Opcode::PseudoVFWADD_WV_M2_E16,
          3614 => Opcode::PseudoVFWADD_WV_M2_E16_MASK,
          3615 => Opcode::PseudoVFWADD_WV_M2_E16_MASK_TIED,
          3616 => Opcode::PseudoVFWADD_WV_M2_E16_TIED,
          3617 => Opcode::PseudoVFWADD_WV_M2_E32,
          3618 => Opcode::PseudoVFWADD_WV_M2_E32_MASK,
          3619 => Opcode::PseudoVFWADD_WV_M2_E32_MASK_TIED,
          3620 => Opcode::PseudoVFWADD_WV_M2_E32_TIED,
          3621 => Opcode::PseudoVFWADD_WV_M4_E16,
          3622 => Opcode::PseudoVFWADD_WV_M4_E16_MASK,
          3623 => Opcode::PseudoVFWADD_WV_M4_E16_MASK_TIED,
          3624 => Opcode::PseudoVFWADD_WV_M4_E16_TIED,
          3625 => Opcode::PseudoVFWADD_WV_M4_E32,
          3626 => Opcode::PseudoVFWADD_WV_M4_E32_MASK,
          3627 => Opcode::PseudoVFWADD_WV_M4_E32_MASK_TIED,
          3628 => Opcode::PseudoVFWADD_WV_M4_E32_TIED,
          3629 => Opcode::PseudoVFWADD_WV_MF2_E16,
          3630 => Opcode::PseudoVFWADD_WV_MF2_E16_MASK,
          3631 => Opcode::PseudoVFWADD_WV_MF2_E16_MASK_TIED,
          3632 => Opcode::PseudoVFWADD_WV_MF2_E16_TIED,
          3633 => Opcode::PseudoVFWADD_WV_MF2_E32,
          3634 => Opcode::PseudoVFWADD_WV_MF2_E32_MASK,
          3635 => Opcode::PseudoVFWADD_WV_MF2_E32_MASK_TIED,
          3636 => Opcode::PseudoVFWADD_WV_MF2_E32_TIED,
          3637 => Opcode::PseudoVFWADD_WV_MF4_E16,
          3638 => Opcode::PseudoVFWADD_WV_MF4_E16_MASK,
          3639 => Opcode::PseudoVFWADD_WV_MF4_E16_MASK_TIED,
          3640 => Opcode::PseudoVFWADD_WV_MF4_E16_TIED,
          3641 => Opcode::PseudoVFWCVTBF16_F_F_V_M1_E16,
          3642 => Opcode::PseudoVFWCVTBF16_F_F_V_M1_E16_MASK,
          3643 => Opcode::PseudoVFWCVTBF16_F_F_V_M1_E32,
          3644 => Opcode::PseudoVFWCVTBF16_F_F_V_M1_E32_MASK,
          3645 => Opcode::PseudoVFWCVTBF16_F_F_V_M2_E16,
          3646 => Opcode::PseudoVFWCVTBF16_F_F_V_M2_E16_MASK,
          3647 => Opcode::PseudoVFWCVTBF16_F_F_V_M2_E32,
          3648 => Opcode::PseudoVFWCVTBF16_F_F_V_M2_E32_MASK,
          3649 => Opcode::PseudoVFWCVTBF16_F_F_V_M4_E16,
          3650 => Opcode::PseudoVFWCVTBF16_F_F_V_M4_E16_MASK,
          3651 => Opcode::PseudoVFWCVTBF16_F_F_V_M4_E32,
          3652 => Opcode::PseudoVFWCVTBF16_F_F_V_M4_E32_MASK,
          3653 => Opcode::PseudoVFWCVTBF16_F_F_V_MF2_E16,
          3654 => Opcode::PseudoVFWCVTBF16_F_F_V_MF2_E16_MASK,
          3655 => Opcode::PseudoVFWCVTBF16_F_F_V_MF2_E32,
          3656 => Opcode::PseudoVFWCVTBF16_F_F_V_MF2_E32_MASK,
          3657 => Opcode::PseudoVFWCVTBF16_F_F_V_MF4_E16,
          3658 => Opcode::PseudoVFWCVTBF16_F_F_V_MF4_E16_MASK,
          3659 => Opcode::PseudoVFWCVT_F_F_V_M1_E16,
          3660 => Opcode::PseudoVFWCVT_F_F_V_M1_E16_MASK,
          3661 => Opcode::PseudoVFWCVT_F_F_V_M1_E32,
          3662 => Opcode::PseudoVFWCVT_F_F_V_M1_E32_MASK,
          3663 => Opcode::PseudoVFWCVT_F_F_V_M2_E16,
          3664 => Opcode::PseudoVFWCVT_F_F_V_M2_E16_MASK,
          3665 => Opcode::PseudoVFWCVT_F_F_V_M2_E32,
          3666 => Opcode::PseudoVFWCVT_F_F_V_M2_E32_MASK,
          3667 => Opcode::PseudoVFWCVT_F_F_V_M4_E16,
          3668 => Opcode::PseudoVFWCVT_F_F_V_M4_E16_MASK,
          3669 => Opcode::PseudoVFWCVT_F_F_V_M4_E32,
          3670 => Opcode::PseudoVFWCVT_F_F_V_M4_E32_MASK,
          3671 => Opcode::PseudoVFWCVT_F_F_V_MF2_E16,
          3672 => Opcode::PseudoVFWCVT_F_F_V_MF2_E16_MASK,
          3673 => Opcode::PseudoVFWCVT_F_F_V_MF2_E32,
          3674 => Opcode::PseudoVFWCVT_F_F_V_MF2_E32_MASK,
          3675 => Opcode::PseudoVFWCVT_F_F_V_MF4_E16,
          3676 => Opcode::PseudoVFWCVT_F_F_V_MF4_E16_MASK,
          3677 => Opcode::PseudoVFWCVT_F_XU_V_M1_E16,
          3678 => Opcode::PseudoVFWCVT_F_XU_V_M1_E16_MASK,
          3679 => Opcode::PseudoVFWCVT_F_XU_V_M1_E32,
          3680 => Opcode::PseudoVFWCVT_F_XU_V_M1_E32_MASK,
          3681 => Opcode::PseudoVFWCVT_F_XU_V_M1_E8,
          3682 => Opcode::PseudoVFWCVT_F_XU_V_M1_E8_MASK,
          3683 => Opcode::PseudoVFWCVT_F_XU_V_M2_E16,
          3684 => Opcode::PseudoVFWCVT_F_XU_V_M2_E16_MASK,
          3685 => Opcode::PseudoVFWCVT_F_XU_V_M2_E32,
          3686 => Opcode::PseudoVFWCVT_F_XU_V_M2_E32_MASK,
          3687 => Opcode::PseudoVFWCVT_F_XU_V_M2_E8,
          3688 => Opcode::PseudoVFWCVT_F_XU_V_M2_E8_MASK,
          3689 => Opcode::PseudoVFWCVT_F_XU_V_M4_E16,
          3690 => Opcode::PseudoVFWCVT_F_XU_V_M4_E16_MASK,
          3691 => Opcode::PseudoVFWCVT_F_XU_V_M4_E32,
          3692 => Opcode::PseudoVFWCVT_F_XU_V_M4_E32_MASK,
          3693 => Opcode::PseudoVFWCVT_F_XU_V_M4_E8,
          3694 => Opcode::PseudoVFWCVT_F_XU_V_M4_E8_MASK,
          3695 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E16,
          3696 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E16_MASK,
          3697 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E32,
          3698 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E32_MASK,
          3699 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E8,
          3700 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E8_MASK,
          3701 => Opcode::PseudoVFWCVT_F_XU_V_MF4_E16,
          3702 => Opcode::PseudoVFWCVT_F_XU_V_MF4_E16_MASK,
          3703 => Opcode::PseudoVFWCVT_F_XU_V_MF4_E8,
          3704 => Opcode::PseudoVFWCVT_F_XU_V_MF4_E8_MASK,
          3705 => Opcode::PseudoVFWCVT_F_XU_V_MF8_E8,
          3706 => Opcode::PseudoVFWCVT_F_XU_V_MF8_E8_MASK,
          3707 => Opcode::PseudoVFWCVT_F_X_V_M1_E16,
          3708 => Opcode::PseudoVFWCVT_F_X_V_M1_E16_MASK,
          3709 => Opcode::PseudoVFWCVT_F_X_V_M1_E32,
          3710 => Opcode::PseudoVFWCVT_F_X_V_M1_E32_MASK,
          3711 => Opcode::PseudoVFWCVT_F_X_V_M1_E8,
          3712 => Opcode::PseudoVFWCVT_F_X_V_M1_E8_MASK,
          3713 => Opcode::PseudoVFWCVT_F_X_V_M2_E16,
          3714 => Opcode::PseudoVFWCVT_F_X_V_M2_E16_MASK,
          3715 => Opcode::PseudoVFWCVT_F_X_V_M2_E32,
          3716 => Opcode::PseudoVFWCVT_F_X_V_M2_E32_MASK,
          3717 => Opcode::PseudoVFWCVT_F_X_V_M2_E8,
          3718 => Opcode::PseudoVFWCVT_F_X_V_M2_E8_MASK,
          3719 => Opcode::PseudoVFWCVT_F_X_V_M4_E16,
          3720 => Opcode::PseudoVFWCVT_F_X_V_M4_E16_MASK,
          3721 => Opcode::PseudoVFWCVT_F_X_V_M4_E32,
          3722 => Opcode::PseudoVFWCVT_F_X_V_M4_E32_MASK,
          3723 => Opcode::PseudoVFWCVT_F_X_V_M4_E8,
          3724 => Opcode::PseudoVFWCVT_F_X_V_M4_E8_MASK,
          3725 => Opcode::PseudoVFWCVT_F_X_V_MF2_E16,
          3726 => Opcode::PseudoVFWCVT_F_X_V_MF2_E16_MASK,
          3727 => Opcode::PseudoVFWCVT_F_X_V_MF2_E32,
          3728 => Opcode::PseudoVFWCVT_F_X_V_MF2_E32_MASK,
          3729 => Opcode::PseudoVFWCVT_F_X_V_MF2_E8,
          3730 => Opcode::PseudoVFWCVT_F_X_V_MF2_E8_MASK,
          3731 => Opcode::PseudoVFWCVT_F_X_V_MF4_E16,
          3732 => Opcode::PseudoVFWCVT_F_X_V_MF4_E16_MASK,
          3733 => Opcode::PseudoVFWCVT_F_X_V_MF4_E8,
          3734 => Opcode::PseudoVFWCVT_F_X_V_MF4_E8_MASK,
          3735 => Opcode::PseudoVFWCVT_F_X_V_MF8_E8,
          3736 => Opcode::PseudoVFWCVT_F_X_V_MF8_E8_MASK,
          3737 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M1,
          3738 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M1_MASK,
          3739 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M2,
          3740 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M2_MASK,
          3741 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M4,
          3742 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M4_MASK,
          3743 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_MF2,
          3744 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_MF2_MASK,
          3745 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_MF4,
          3746 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_MF4_MASK,
          3747 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M1,
          3748 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M1_MASK,
          3749 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M2,
          3750 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M2_MASK,
          3751 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M4,
          3752 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M4_MASK,
          3753 => Opcode::PseudoVFWCVT_RTZ_X_F_V_MF2,
          3754 => Opcode::PseudoVFWCVT_RTZ_X_F_V_MF2_MASK,
          3755 => Opcode::PseudoVFWCVT_RTZ_X_F_V_MF4,
          3756 => Opcode::PseudoVFWCVT_RTZ_X_F_V_MF4_MASK,
          3757 => Opcode::PseudoVFWCVT_XU_F_V_M1,
          3758 => Opcode::PseudoVFWCVT_XU_F_V_M1_MASK,
          3759 => Opcode::PseudoVFWCVT_XU_F_V_M2,
          3760 => Opcode::PseudoVFWCVT_XU_F_V_M2_MASK,
          3761 => Opcode::PseudoVFWCVT_XU_F_V_M4,
          3762 => Opcode::PseudoVFWCVT_XU_F_V_M4_MASK,
          3763 => Opcode::PseudoVFWCVT_XU_F_V_MF2,
          3764 => Opcode::PseudoVFWCVT_XU_F_V_MF2_MASK,
          3765 => Opcode::PseudoVFWCVT_XU_F_V_MF4,
          3766 => Opcode::PseudoVFWCVT_XU_F_V_MF4_MASK,
          3767 => Opcode::PseudoVFWCVT_X_F_V_M1,
          3768 => Opcode::PseudoVFWCVT_X_F_V_M1_MASK,
          3769 => Opcode::PseudoVFWCVT_X_F_V_M2,
          3770 => Opcode::PseudoVFWCVT_X_F_V_M2_MASK,
          3771 => Opcode::PseudoVFWCVT_X_F_V_M4,
          3772 => Opcode::PseudoVFWCVT_X_F_V_M4_MASK,
          3773 => Opcode::PseudoVFWCVT_X_F_V_MF2,
          3774 => Opcode::PseudoVFWCVT_X_F_V_MF2_MASK,
          3775 => Opcode::PseudoVFWCVT_X_F_V_MF4,
          3776 => Opcode::PseudoVFWCVT_X_F_V_MF4_MASK,
          3777 => Opcode::PseudoVFWMACCBF16_VFPR16_M1_E16,
          3778 => Opcode::PseudoVFWMACCBF16_VFPR16_M1_E16_MASK,
          3779 => Opcode::PseudoVFWMACCBF16_VFPR16_M2_E16,
          3780 => Opcode::PseudoVFWMACCBF16_VFPR16_M2_E16_MASK,
          3781 => Opcode::PseudoVFWMACCBF16_VFPR16_M4_E16,
          3782 => Opcode::PseudoVFWMACCBF16_VFPR16_M4_E16_MASK,
          3783 => Opcode::PseudoVFWMACCBF16_VFPR16_MF2_E16,
          3784 => Opcode::PseudoVFWMACCBF16_VFPR16_MF2_E16_MASK,
          3785 => Opcode::PseudoVFWMACCBF16_VFPR16_MF4_E16,
          3786 => Opcode::PseudoVFWMACCBF16_VFPR16_MF4_E16_MASK,
          3787 => Opcode::PseudoVFWMACCBF16_VV_M1_E16,
          3788 => Opcode::PseudoVFWMACCBF16_VV_M1_E16_MASK,
          3789 => Opcode::PseudoVFWMACCBF16_VV_M1_E32,
          3790 => Opcode::PseudoVFWMACCBF16_VV_M1_E32_MASK,
          3791 => Opcode::PseudoVFWMACCBF16_VV_M2_E16,
          3792 => Opcode::PseudoVFWMACCBF16_VV_M2_E16_MASK,
          3793 => Opcode::PseudoVFWMACCBF16_VV_M2_E32,
          3794 => Opcode::PseudoVFWMACCBF16_VV_M2_E32_MASK,
          3795 => Opcode::PseudoVFWMACCBF16_VV_M4_E16,
          3796 => Opcode::PseudoVFWMACCBF16_VV_M4_E16_MASK,
          3797 => Opcode::PseudoVFWMACCBF16_VV_M4_E32,
          3798 => Opcode::PseudoVFWMACCBF16_VV_M4_E32_MASK,
          3799 => Opcode::PseudoVFWMACCBF16_VV_MF2_E16,
          3800 => Opcode::PseudoVFWMACCBF16_VV_MF2_E16_MASK,
          3801 => Opcode::PseudoVFWMACCBF16_VV_MF2_E32,
          3802 => Opcode::PseudoVFWMACCBF16_VV_MF2_E32_MASK,
          3803 => Opcode::PseudoVFWMACCBF16_VV_MF4_E16,
          3804 => Opcode::PseudoVFWMACCBF16_VV_MF4_E16_MASK,
          3805 => Opcode::PseudoVFWMACC_VFPR16_M1_E16,
          3806 => Opcode::PseudoVFWMACC_VFPR16_M1_E16_MASK,
          3807 => Opcode::PseudoVFWMACC_VFPR16_M2_E16,
          3808 => Opcode::PseudoVFWMACC_VFPR16_M2_E16_MASK,
          3809 => Opcode::PseudoVFWMACC_VFPR16_M4_E16,
          3810 => Opcode::PseudoVFWMACC_VFPR16_M4_E16_MASK,
          3811 => Opcode::PseudoVFWMACC_VFPR16_MF2_E16,
          3812 => Opcode::PseudoVFWMACC_VFPR16_MF2_E16_MASK,
          3813 => Opcode::PseudoVFWMACC_VFPR16_MF4_E16,
          3814 => Opcode::PseudoVFWMACC_VFPR16_MF4_E16_MASK,
          3815 => Opcode::PseudoVFWMACC_VFPR32_M1_E32,
          3816 => Opcode::PseudoVFWMACC_VFPR32_M1_E32_MASK,
          3817 => Opcode::PseudoVFWMACC_VFPR32_M2_E32,
          3818 => Opcode::PseudoVFWMACC_VFPR32_M2_E32_MASK,
          3819 => Opcode::PseudoVFWMACC_VFPR32_M4_E32,
          3820 => Opcode::PseudoVFWMACC_VFPR32_M4_E32_MASK,
          3821 => Opcode::PseudoVFWMACC_VFPR32_MF2_E32,
          3822 => Opcode::PseudoVFWMACC_VFPR32_MF2_E32_MASK,
          3823 => Opcode::PseudoVFWMACC_VV_M1_E16,
          3824 => Opcode::PseudoVFWMACC_VV_M1_E16_MASK,
          3825 => Opcode::PseudoVFWMACC_VV_M1_E32,
          3826 => Opcode::PseudoVFWMACC_VV_M1_E32_MASK,
          3827 => Opcode::PseudoVFWMACC_VV_M2_E16,
          3828 => Opcode::PseudoVFWMACC_VV_M2_E16_MASK,
          3829 => Opcode::PseudoVFWMACC_VV_M2_E32,
          3830 => Opcode::PseudoVFWMACC_VV_M2_E32_MASK,
          3831 => Opcode::PseudoVFWMACC_VV_M4_E16,
          3832 => Opcode::PseudoVFWMACC_VV_M4_E16_MASK,
          3833 => Opcode::PseudoVFWMACC_VV_M4_E32,
          3834 => Opcode::PseudoVFWMACC_VV_M4_E32_MASK,
          3835 => Opcode::PseudoVFWMACC_VV_MF2_E16,
          3836 => Opcode::PseudoVFWMACC_VV_MF2_E16_MASK,
          3837 => Opcode::PseudoVFWMACC_VV_MF2_E32,
          3838 => Opcode::PseudoVFWMACC_VV_MF2_E32_MASK,
          3839 => Opcode::PseudoVFWMACC_VV_MF4_E16,
          3840 => Opcode::PseudoVFWMACC_VV_MF4_E16_MASK,
          3841 => Opcode::PseudoVFWMSAC_VFPR16_M1_E16,
          3842 => Opcode::PseudoVFWMSAC_VFPR16_M1_E16_MASK,
          3843 => Opcode::PseudoVFWMSAC_VFPR16_M2_E16,
          3844 => Opcode::PseudoVFWMSAC_VFPR16_M2_E16_MASK,
          3845 => Opcode::PseudoVFWMSAC_VFPR16_M4_E16,
          3846 => Opcode::PseudoVFWMSAC_VFPR16_M4_E16_MASK,
          3847 => Opcode::PseudoVFWMSAC_VFPR16_MF2_E16,
          3848 => Opcode::PseudoVFWMSAC_VFPR16_MF2_E16_MASK,
          3849 => Opcode::PseudoVFWMSAC_VFPR16_MF4_E16,
          3850 => Opcode::PseudoVFWMSAC_VFPR16_MF4_E16_MASK,
          3851 => Opcode::PseudoVFWMSAC_VFPR32_M1_E32,
          3852 => Opcode::PseudoVFWMSAC_VFPR32_M1_E32_MASK,
          3853 => Opcode::PseudoVFWMSAC_VFPR32_M2_E32,
          3854 => Opcode::PseudoVFWMSAC_VFPR32_M2_E32_MASK,
          3855 => Opcode::PseudoVFWMSAC_VFPR32_M4_E32,
          3856 => Opcode::PseudoVFWMSAC_VFPR32_M4_E32_MASK,
          3857 => Opcode::PseudoVFWMSAC_VFPR32_MF2_E32,
          3858 => Opcode::PseudoVFWMSAC_VFPR32_MF2_E32_MASK,
          3859 => Opcode::PseudoVFWMSAC_VV_M1_E16,
          3860 => Opcode::PseudoVFWMSAC_VV_M1_E16_MASK,
          3861 => Opcode::PseudoVFWMSAC_VV_M1_E32,
          3862 => Opcode::PseudoVFWMSAC_VV_M1_E32_MASK,
          3863 => Opcode::PseudoVFWMSAC_VV_M2_E16,
          3864 => Opcode::PseudoVFWMSAC_VV_M2_E16_MASK,
          3865 => Opcode::PseudoVFWMSAC_VV_M2_E32,
          3866 => Opcode::PseudoVFWMSAC_VV_M2_E32_MASK,
          3867 => Opcode::PseudoVFWMSAC_VV_M4_E16,
          3868 => Opcode::PseudoVFWMSAC_VV_M4_E16_MASK,
          3869 => Opcode::PseudoVFWMSAC_VV_M4_E32,
          3870 => Opcode::PseudoVFWMSAC_VV_M4_E32_MASK,
          3871 => Opcode::PseudoVFWMSAC_VV_MF2_E16,
          3872 => Opcode::PseudoVFWMSAC_VV_MF2_E16_MASK,
          3873 => Opcode::PseudoVFWMSAC_VV_MF2_E32,
          3874 => Opcode::PseudoVFWMSAC_VV_MF2_E32_MASK,
          3875 => Opcode::PseudoVFWMSAC_VV_MF4_E16,
          3876 => Opcode::PseudoVFWMSAC_VV_MF4_E16_MASK,
          3877 => Opcode::PseudoVFWMUL_VFPR16_M1_E16,
          3878 => Opcode::PseudoVFWMUL_VFPR16_M1_E16_MASK,
          3879 => Opcode::PseudoVFWMUL_VFPR16_M2_E16,
          3880 => Opcode::PseudoVFWMUL_VFPR16_M2_E16_MASK,
          3881 => Opcode::PseudoVFWMUL_VFPR16_M4_E16,
          3882 => Opcode::PseudoVFWMUL_VFPR16_M4_E16_MASK,
          3883 => Opcode::PseudoVFWMUL_VFPR16_MF2_E16,
          3884 => Opcode::PseudoVFWMUL_VFPR16_MF2_E16_MASK,
          3885 => Opcode::PseudoVFWMUL_VFPR16_MF4_E16,
          3886 => Opcode::PseudoVFWMUL_VFPR16_MF4_E16_MASK,
          3887 => Opcode::PseudoVFWMUL_VFPR32_M1_E32,
          3888 => Opcode::PseudoVFWMUL_VFPR32_M1_E32_MASK,
          3889 => Opcode::PseudoVFWMUL_VFPR32_M2_E32,
          3890 => Opcode::PseudoVFWMUL_VFPR32_M2_E32_MASK,
          3891 => Opcode::PseudoVFWMUL_VFPR32_M4_E32,
          3892 => Opcode::PseudoVFWMUL_VFPR32_M4_E32_MASK,
          3893 => Opcode::PseudoVFWMUL_VFPR32_MF2_E32,
          3894 => Opcode::PseudoVFWMUL_VFPR32_MF2_E32_MASK,
          3895 => Opcode::PseudoVFWMUL_VV_M1_E16,
          3896 => Opcode::PseudoVFWMUL_VV_M1_E16_MASK,
          3897 => Opcode::PseudoVFWMUL_VV_M1_E32,
          3898 => Opcode::PseudoVFWMUL_VV_M1_E32_MASK,
          3899 => Opcode::PseudoVFWMUL_VV_M2_E16,
          3900 => Opcode::PseudoVFWMUL_VV_M2_E16_MASK,
          3901 => Opcode::PseudoVFWMUL_VV_M2_E32,
          3902 => Opcode::PseudoVFWMUL_VV_M2_E32_MASK,
          3903 => Opcode::PseudoVFWMUL_VV_M4_E16,
          3904 => Opcode::PseudoVFWMUL_VV_M4_E16_MASK,
          3905 => Opcode::PseudoVFWMUL_VV_M4_E32,
          3906 => Opcode::PseudoVFWMUL_VV_M4_E32_MASK,
          3907 => Opcode::PseudoVFWMUL_VV_MF2_E16,
          3908 => Opcode::PseudoVFWMUL_VV_MF2_E16_MASK,
          3909 => Opcode::PseudoVFWMUL_VV_MF2_E32,
          3910 => Opcode::PseudoVFWMUL_VV_MF2_E32_MASK,
          3911 => Opcode::PseudoVFWMUL_VV_MF4_E16,
          3912 => Opcode::PseudoVFWMUL_VV_MF4_E16_MASK,
          3913 => Opcode::PseudoVFWNMACC_VFPR16_M1_E16,
          3914 => Opcode::PseudoVFWNMACC_VFPR16_M1_E16_MASK,
          3915 => Opcode::PseudoVFWNMACC_VFPR16_M2_E16,
          3916 => Opcode::PseudoVFWNMACC_VFPR16_M2_E16_MASK,
          3917 => Opcode::PseudoVFWNMACC_VFPR16_M4_E16,
          3918 => Opcode::PseudoVFWNMACC_VFPR16_M4_E16_MASK,
          3919 => Opcode::PseudoVFWNMACC_VFPR16_MF2_E16,
          3920 => Opcode::PseudoVFWNMACC_VFPR16_MF2_E16_MASK,
          3921 => Opcode::PseudoVFWNMACC_VFPR16_MF4_E16,
          3922 => Opcode::PseudoVFWNMACC_VFPR16_MF4_E16_MASK,
          3923 => Opcode::PseudoVFWNMACC_VFPR32_M1_E32,
          3924 => Opcode::PseudoVFWNMACC_VFPR32_M1_E32_MASK,
          3925 => Opcode::PseudoVFWNMACC_VFPR32_M2_E32,
          3926 => Opcode::PseudoVFWNMACC_VFPR32_M2_E32_MASK,
          3927 => Opcode::PseudoVFWNMACC_VFPR32_M4_E32,
          3928 => Opcode::PseudoVFWNMACC_VFPR32_M4_E32_MASK,
          3929 => Opcode::PseudoVFWNMACC_VFPR32_MF2_E32,
          3930 => Opcode::PseudoVFWNMACC_VFPR32_MF2_E32_MASK,
          3931 => Opcode::PseudoVFWNMACC_VV_M1_E16,
          3932 => Opcode::PseudoVFWNMACC_VV_M1_E16_MASK,
          3933 => Opcode::PseudoVFWNMACC_VV_M1_E32,
          3934 => Opcode::PseudoVFWNMACC_VV_M1_E32_MASK,
          3935 => Opcode::PseudoVFWNMACC_VV_M2_E16,
          3936 => Opcode::PseudoVFWNMACC_VV_M2_E16_MASK,
          3937 => Opcode::PseudoVFWNMACC_VV_M2_E32,
          3938 => Opcode::PseudoVFWNMACC_VV_M2_E32_MASK,
          3939 => Opcode::PseudoVFWNMACC_VV_M4_E16,
          3940 => Opcode::PseudoVFWNMACC_VV_M4_E16_MASK,
          3941 => Opcode::PseudoVFWNMACC_VV_M4_E32,
          3942 => Opcode::PseudoVFWNMACC_VV_M4_E32_MASK,
          3943 => Opcode::PseudoVFWNMACC_VV_MF2_E16,
          3944 => Opcode::PseudoVFWNMACC_VV_MF2_E16_MASK,
          3945 => Opcode::PseudoVFWNMACC_VV_MF2_E32,
          3946 => Opcode::PseudoVFWNMACC_VV_MF2_E32_MASK,
          3947 => Opcode::PseudoVFWNMACC_VV_MF4_E16,
          3948 => Opcode::PseudoVFWNMACC_VV_MF4_E16_MASK,
          3949 => Opcode::PseudoVFWNMSAC_VFPR16_M1_E16,
          3950 => Opcode::PseudoVFWNMSAC_VFPR16_M1_E16_MASK,
          3951 => Opcode::PseudoVFWNMSAC_VFPR16_M2_E16,
          3952 => Opcode::PseudoVFWNMSAC_VFPR16_M2_E16_MASK,
          3953 => Opcode::PseudoVFWNMSAC_VFPR16_M4_E16,
          3954 => Opcode::PseudoVFWNMSAC_VFPR16_M4_E16_MASK,
          3955 => Opcode::PseudoVFWNMSAC_VFPR16_MF2_E16,
          3956 => Opcode::PseudoVFWNMSAC_VFPR16_MF2_E16_MASK,
          3957 => Opcode::PseudoVFWNMSAC_VFPR16_MF4_E16,
          3958 => Opcode::PseudoVFWNMSAC_VFPR16_MF4_E16_MASK,
          3959 => Opcode::PseudoVFWNMSAC_VFPR32_M1_E32,
          3960 => Opcode::PseudoVFWNMSAC_VFPR32_M1_E32_MASK,
          3961 => Opcode::PseudoVFWNMSAC_VFPR32_M2_E32,
          3962 => Opcode::PseudoVFWNMSAC_VFPR32_M2_E32_MASK,
          3963 => Opcode::PseudoVFWNMSAC_VFPR32_M4_E32,
          3964 => Opcode::PseudoVFWNMSAC_VFPR32_M4_E32_MASK,
          3965 => Opcode::PseudoVFWNMSAC_VFPR32_MF2_E32,
          3966 => Opcode::PseudoVFWNMSAC_VFPR32_MF2_E32_MASK,
          3967 => Opcode::PseudoVFWNMSAC_VV_M1_E16,
          3968 => Opcode::PseudoVFWNMSAC_VV_M1_E16_MASK,
          3969 => Opcode::PseudoVFWNMSAC_VV_M1_E32,
          3970 => Opcode::PseudoVFWNMSAC_VV_M1_E32_MASK,
          3971 => Opcode::PseudoVFWNMSAC_VV_M2_E16,
          3972 => Opcode::PseudoVFWNMSAC_VV_M2_E16_MASK,
          3973 => Opcode::PseudoVFWNMSAC_VV_M2_E32,
          3974 => Opcode::PseudoVFWNMSAC_VV_M2_E32_MASK,
          3975 => Opcode::PseudoVFWNMSAC_VV_M4_E16,
          3976 => Opcode::PseudoVFWNMSAC_VV_M4_E16_MASK,
          3977 => Opcode::PseudoVFWNMSAC_VV_M4_E32,
          3978 => Opcode::PseudoVFWNMSAC_VV_M4_E32_MASK,
          3979 => Opcode::PseudoVFWNMSAC_VV_MF2_E16,
          3980 => Opcode::PseudoVFWNMSAC_VV_MF2_E16_MASK,
          3981 => Opcode::PseudoVFWNMSAC_VV_MF2_E32,
          3982 => Opcode::PseudoVFWNMSAC_VV_MF2_E32_MASK,
          3983 => Opcode::PseudoVFWNMSAC_VV_MF4_E16,
          3984 => Opcode::PseudoVFWNMSAC_VV_MF4_E16_MASK,
          3985 => Opcode::PseudoVFWREDOSUM_VS_M1_E16,
          3986 => Opcode::PseudoVFWREDOSUM_VS_M1_E16_MASK,
          3987 => Opcode::PseudoVFWREDOSUM_VS_M1_E32,
          3988 => Opcode::PseudoVFWREDOSUM_VS_M1_E32_MASK,
          3989 => Opcode::PseudoVFWREDOSUM_VS_M2_E16,
          3990 => Opcode::PseudoVFWREDOSUM_VS_M2_E16_MASK,
          3991 => Opcode::PseudoVFWREDOSUM_VS_M2_E32,
          3992 => Opcode::PseudoVFWREDOSUM_VS_M2_E32_MASK,
          3993 => Opcode::PseudoVFWREDOSUM_VS_M4_E16,
          3994 => Opcode::PseudoVFWREDOSUM_VS_M4_E16_MASK,
          3995 => Opcode::PseudoVFWREDOSUM_VS_M4_E32,
          3996 => Opcode::PseudoVFWREDOSUM_VS_M4_E32_MASK,
          3997 => Opcode::PseudoVFWREDOSUM_VS_M8_E16,
          3998 => Opcode::PseudoVFWREDOSUM_VS_M8_E16_MASK,
          3999 => Opcode::PseudoVFWREDOSUM_VS_M8_E32,
          4000 => Opcode::PseudoVFWREDOSUM_VS_M8_E32_MASK,
          4001 => Opcode::PseudoVFWREDOSUM_VS_MF2_E16,
          4002 => Opcode::PseudoVFWREDOSUM_VS_MF2_E16_MASK,
          4003 => Opcode::PseudoVFWREDOSUM_VS_MF2_E32,
          4004 => Opcode::PseudoVFWREDOSUM_VS_MF2_E32_MASK,
          4005 => Opcode::PseudoVFWREDOSUM_VS_MF4_E16,
          4006 => Opcode::PseudoVFWREDOSUM_VS_MF4_E16_MASK,
          4007 => Opcode::PseudoVFWREDUSUM_VS_M1_E16,
          4008 => Opcode::PseudoVFWREDUSUM_VS_M1_E16_MASK,
          4009 => Opcode::PseudoVFWREDUSUM_VS_M1_E32,
          4010 => Opcode::PseudoVFWREDUSUM_VS_M1_E32_MASK,
          4011 => Opcode::PseudoVFWREDUSUM_VS_M2_E16,
          4012 => Opcode::PseudoVFWREDUSUM_VS_M2_E16_MASK,
          4013 => Opcode::PseudoVFWREDUSUM_VS_M2_E32,
          4014 => Opcode::PseudoVFWREDUSUM_VS_M2_E32_MASK,
          4015 => Opcode::PseudoVFWREDUSUM_VS_M4_E16,
          4016 => Opcode::PseudoVFWREDUSUM_VS_M4_E16_MASK,
          4017 => Opcode::PseudoVFWREDUSUM_VS_M4_E32,
          4018 => Opcode::PseudoVFWREDUSUM_VS_M4_E32_MASK,
          4019 => Opcode::PseudoVFWREDUSUM_VS_M8_E16,
          4020 => Opcode::PseudoVFWREDUSUM_VS_M8_E16_MASK,
          4021 => Opcode::PseudoVFWREDUSUM_VS_M8_E32,
          4022 => Opcode::PseudoVFWREDUSUM_VS_M8_E32_MASK,
          4023 => Opcode::PseudoVFWREDUSUM_VS_MF2_E16,
          4024 => Opcode::PseudoVFWREDUSUM_VS_MF2_E16_MASK,
          4025 => Opcode::PseudoVFWREDUSUM_VS_MF2_E32,
          4026 => Opcode::PseudoVFWREDUSUM_VS_MF2_E32_MASK,
          4027 => Opcode::PseudoVFWREDUSUM_VS_MF4_E16,
          4028 => Opcode::PseudoVFWREDUSUM_VS_MF4_E16_MASK,
          4029 => Opcode::PseudoVFWSUB_VFPR16_M1_E16,
          4030 => Opcode::PseudoVFWSUB_VFPR16_M1_E16_MASK,
          4031 => Opcode::PseudoVFWSUB_VFPR16_M2_E16,
          4032 => Opcode::PseudoVFWSUB_VFPR16_M2_E16_MASK,
          4033 => Opcode::PseudoVFWSUB_VFPR16_M4_E16,
          4034 => Opcode::PseudoVFWSUB_VFPR16_M4_E16_MASK,
          4035 => Opcode::PseudoVFWSUB_VFPR16_MF2_E16,
          4036 => Opcode::PseudoVFWSUB_VFPR16_MF2_E16_MASK,
          4037 => Opcode::PseudoVFWSUB_VFPR16_MF4_E16,
          4038 => Opcode::PseudoVFWSUB_VFPR16_MF4_E16_MASK,
          4039 => Opcode::PseudoVFWSUB_VFPR32_M1_E32,
          4040 => Opcode::PseudoVFWSUB_VFPR32_M1_E32_MASK,
          4041 => Opcode::PseudoVFWSUB_VFPR32_M2_E32,
          4042 => Opcode::PseudoVFWSUB_VFPR32_M2_E32_MASK,
          4043 => Opcode::PseudoVFWSUB_VFPR32_M4_E32,
          4044 => Opcode::PseudoVFWSUB_VFPR32_M4_E32_MASK,
          4045 => Opcode::PseudoVFWSUB_VFPR32_MF2_E32,
          4046 => Opcode::PseudoVFWSUB_VFPR32_MF2_E32_MASK,
          4047 => Opcode::PseudoVFWSUB_VV_M1_E16,
          4048 => Opcode::PseudoVFWSUB_VV_M1_E16_MASK,
          4049 => Opcode::PseudoVFWSUB_VV_M1_E32,
          4050 => Opcode::PseudoVFWSUB_VV_M1_E32_MASK,
          4051 => Opcode::PseudoVFWSUB_VV_M2_E16,
          4052 => Opcode::PseudoVFWSUB_VV_M2_E16_MASK,
          4053 => Opcode::PseudoVFWSUB_VV_M2_E32,
          4054 => Opcode::PseudoVFWSUB_VV_M2_E32_MASK,
          4055 => Opcode::PseudoVFWSUB_VV_M4_E16,
          4056 => Opcode::PseudoVFWSUB_VV_M4_E16_MASK,
          4057 => Opcode::PseudoVFWSUB_VV_M4_E32,
          4058 => Opcode::PseudoVFWSUB_VV_M4_E32_MASK,
          4059 => Opcode::PseudoVFWSUB_VV_MF2_E16,
          4060 => Opcode::PseudoVFWSUB_VV_MF2_E16_MASK,
          4061 => Opcode::PseudoVFWSUB_VV_MF2_E32,
          4062 => Opcode::PseudoVFWSUB_VV_MF2_E32_MASK,
          4063 => Opcode::PseudoVFWSUB_VV_MF4_E16,
          4064 => Opcode::PseudoVFWSUB_VV_MF4_E16_MASK,
          4065 => Opcode::PseudoVFWSUB_WFPR16_M1_E16,
          4066 => Opcode::PseudoVFWSUB_WFPR16_M1_E16_MASK,
          4067 => Opcode::PseudoVFWSUB_WFPR16_M2_E16,
          4068 => Opcode::PseudoVFWSUB_WFPR16_M2_E16_MASK,
          4069 => Opcode::PseudoVFWSUB_WFPR16_M4_E16,
          4070 => Opcode::PseudoVFWSUB_WFPR16_M4_E16_MASK,
          4071 => Opcode::PseudoVFWSUB_WFPR16_MF2_E16,
          4072 => Opcode::PseudoVFWSUB_WFPR16_MF2_E16_MASK,
          4073 => Opcode::PseudoVFWSUB_WFPR16_MF4_E16,
          4074 => Opcode::PseudoVFWSUB_WFPR16_MF4_E16_MASK,
          4075 => Opcode::PseudoVFWSUB_WFPR32_M1_E32,
          4076 => Opcode::PseudoVFWSUB_WFPR32_M1_E32_MASK,
          4077 => Opcode::PseudoVFWSUB_WFPR32_M2_E32,
          4078 => Opcode::PseudoVFWSUB_WFPR32_M2_E32_MASK,
          4079 => Opcode::PseudoVFWSUB_WFPR32_M4_E32,
          4080 => Opcode::PseudoVFWSUB_WFPR32_M4_E32_MASK,
          4081 => Opcode::PseudoVFWSUB_WFPR32_MF2_E32,
          4082 => Opcode::PseudoVFWSUB_WFPR32_MF2_E32_MASK,
          4083 => Opcode::PseudoVFWSUB_WV_M1_E16,
          4084 => Opcode::PseudoVFWSUB_WV_M1_E16_MASK,
          4085 => Opcode::PseudoVFWSUB_WV_M1_E16_MASK_TIED,
          4086 => Opcode::PseudoVFWSUB_WV_M1_E16_TIED,
          4087 => Opcode::PseudoVFWSUB_WV_M1_E32,
          4088 => Opcode::PseudoVFWSUB_WV_M1_E32_MASK,
          4089 => Opcode::PseudoVFWSUB_WV_M1_E32_MASK_TIED,
          4090 => Opcode::PseudoVFWSUB_WV_M1_E32_TIED,
          4091 => Opcode::PseudoVFWSUB_WV_M2_E16,
          4092 => Opcode::PseudoVFWSUB_WV_M2_E16_MASK,
          4093 => Opcode::PseudoVFWSUB_WV_M2_E16_MASK_TIED,
          4094 => Opcode::PseudoVFWSUB_WV_M2_E16_TIED,
          4095 => Opcode::PseudoVFWSUB_WV_M2_E32,
          4096 => Opcode::PseudoVFWSUB_WV_M2_E32_MASK,
          4097 => Opcode::PseudoVFWSUB_WV_M2_E32_MASK_TIED,
          4098 => Opcode::PseudoVFWSUB_WV_M2_E32_TIED,
          4099 => Opcode::PseudoVFWSUB_WV_M4_E16,
          4100 => Opcode::PseudoVFWSUB_WV_M4_E16_MASK,
          4101 => Opcode::PseudoVFWSUB_WV_M4_E16_MASK_TIED,
          4102 => Opcode::PseudoVFWSUB_WV_M4_E16_TIED,
          4103 => Opcode::PseudoVFWSUB_WV_M4_E32,
          4104 => Opcode::PseudoVFWSUB_WV_M4_E32_MASK,
          4105 => Opcode::PseudoVFWSUB_WV_M4_E32_MASK_TIED,
          4106 => Opcode::PseudoVFWSUB_WV_M4_E32_TIED,
          4107 => Opcode::PseudoVFWSUB_WV_MF2_E16,
          4108 => Opcode::PseudoVFWSUB_WV_MF2_E16_MASK,
          4109 => Opcode::PseudoVFWSUB_WV_MF2_E16_MASK_TIED,
          4110 => Opcode::PseudoVFWSUB_WV_MF2_E16_TIED,
          4111 => Opcode::PseudoVFWSUB_WV_MF2_E32,
          4112 => Opcode::PseudoVFWSUB_WV_MF2_E32_MASK,
          4113 => Opcode::PseudoVFWSUB_WV_MF2_E32_MASK_TIED,
          4114 => Opcode::PseudoVFWSUB_WV_MF2_E32_TIED,
          4115 => Opcode::PseudoVFWSUB_WV_MF4_E16,
          4116 => Opcode::PseudoVFWSUB_WV_MF4_E16_MASK,
          4117 => Opcode::PseudoVFWSUB_WV_MF4_E16_MASK_TIED,
          4118 => Opcode::PseudoVFWSUB_WV_MF4_E16_TIED,
          4119 => Opcode::PseudoVGHSH_VV_M1,
          4120 => Opcode::PseudoVGHSH_VV_M2,
          4121 => Opcode::PseudoVGHSH_VV_M4,
          4122 => Opcode::PseudoVGHSH_VV_M8,
          4123 => Opcode::PseudoVGHSH_VV_MF2,
          4124 => Opcode::PseudoVGMUL_VV_M1,
          4125 => Opcode::PseudoVGMUL_VV_M2,
          4126 => Opcode::PseudoVGMUL_VV_M4,
          4127 => Opcode::PseudoVGMUL_VV_M8,
          4128 => Opcode::PseudoVGMUL_VV_MF2,
          4129 => Opcode::PseudoVID_V_M1,
          4130 => Opcode::PseudoVID_V_M1_MASK,
          4131 => Opcode::PseudoVID_V_M2,
          4132 => Opcode::PseudoVID_V_M2_MASK,
          4133 => Opcode::PseudoVID_V_M4,
          4134 => Opcode::PseudoVID_V_M4_MASK,
          4135 => Opcode::PseudoVID_V_M8,
          4136 => Opcode::PseudoVID_V_M8_MASK,
          4137 => Opcode::PseudoVID_V_MF2,
          4138 => Opcode::PseudoVID_V_MF2_MASK,
          4139 => Opcode::PseudoVID_V_MF4,
          4140 => Opcode::PseudoVID_V_MF4_MASK,
          4141 => Opcode::PseudoVID_V_MF8,
          4142 => Opcode::PseudoVID_V_MF8_MASK,
          4143 => Opcode::PseudoVIOTA_M_M1,
          4144 => Opcode::PseudoVIOTA_M_M1_MASK,
          4145 => Opcode::PseudoVIOTA_M_M2,
          4146 => Opcode::PseudoVIOTA_M_M2_MASK,
          4147 => Opcode::PseudoVIOTA_M_M4,
          4148 => Opcode::PseudoVIOTA_M_M4_MASK,
          4149 => Opcode::PseudoVIOTA_M_M8,
          4150 => Opcode::PseudoVIOTA_M_M8_MASK,
          4151 => Opcode::PseudoVIOTA_M_MF2,
          4152 => Opcode::PseudoVIOTA_M_MF2_MASK,
          4153 => Opcode::PseudoVIOTA_M_MF4,
          4154 => Opcode::PseudoVIOTA_M_MF4_MASK,
          4155 => Opcode::PseudoVIOTA_M_MF8,
          4156 => Opcode::PseudoVIOTA_M_MF8_MASK,
          4157 => Opcode::PseudoVLE16FF_V_M1,
          4158 => Opcode::PseudoVLE16FF_V_M1_MASK,
          4159 => Opcode::PseudoVLE16FF_V_M2,
          4160 => Opcode::PseudoVLE16FF_V_M2_MASK,
          4161 => Opcode::PseudoVLE16FF_V_M4,
          4162 => Opcode::PseudoVLE16FF_V_M4_MASK,
          4163 => Opcode::PseudoVLE16FF_V_M8,
          4164 => Opcode::PseudoVLE16FF_V_M8_MASK,
          4165 => Opcode::PseudoVLE16FF_V_MF2,
          4166 => Opcode::PseudoVLE16FF_V_MF2_MASK,
          4167 => Opcode::PseudoVLE16FF_V_MF4,
          4168 => Opcode::PseudoVLE16FF_V_MF4_MASK,
          4169 => Opcode::PseudoVLE16_V_M1,
          4170 => Opcode::PseudoVLE16_V_M1_MASK,
          4171 => Opcode::PseudoVLE16_V_M2,
          4172 => Opcode::PseudoVLE16_V_M2_MASK,
          4173 => Opcode::PseudoVLE16_V_M4,
          4174 => Opcode::PseudoVLE16_V_M4_MASK,
          4175 => Opcode::PseudoVLE16_V_M8,
          4176 => Opcode::PseudoVLE16_V_M8_MASK,
          4177 => Opcode::PseudoVLE16_V_MF2,
          4178 => Opcode::PseudoVLE16_V_MF2_MASK,
          4179 => Opcode::PseudoVLE16_V_MF4,
          4180 => Opcode::PseudoVLE16_V_MF4_MASK,
          4181 => Opcode::PseudoVLE32FF_V_M1,
          4182 => Opcode::PseudoVLE32FF_V_M1_MASK,
          4183 => Opcode::PseudoVLE32FF_V_M2,
          4184 => Opcode::PseudoVLE32FF_V_M2_MASK,
          4185 => Opcode::PseudoVLE32FF_V_M4,
          4186 => Opcode::PseudoVLE32FF_V_M4_MASK,
          4187 => Opcode::PseudoVLE32FF_V_M8,
          4188 => Opcode::PseudoVLE32FF_V_M8_MASK,
          4189 => Opcode::PseudoVLE32FF_V_MF2,
          4190 => Opcode::PseudoVLE32FF_V_MF2_MASK,
          4191 => Opcode::PseudoVLE32_V_M1,
          4192 => Opcode::PseudoVLE32_V_M1_MASK,
          4193 => Opcode::PseudoVLE32_V_M2,
          4194 => Opcode::PseudoVLE32_V_M2_MASK,
          4195 => Opcode::PseudoVLE32_V_M4,
          4196 => Opcode::PseudoVLE32_V_M4_MASK,
          4197 => Opcode::PseudoVLE32_V_M8,
          4198 => Opcode::PseudoVLE32_V_M8_MASK,
          4199 => Opcode::PseudoVLE32_V_MF2,
          4200 => Opcode::PseudoVLE32_V_MF2_MASK,
          4201 => Opcode::PseudoVLE64FF_V_M1,
          4202 => Opcode::PseudoVLE64FF_V_M1_MASK,
          4203 => Opcode::PseudoVLE64FF_V_M2,
          4204 => Opcode::PseudoVLE64FF_V_M2_MASK,
          4205 => Opcode::PseudoVLE64FF_V_M4,
          4206 => Opcode::PseudoVLE64FF_V_M4_MASK,
          4207 => Opcode::PseudoVLE64FF_V_M8,
          4208 => Opcode::PseudoVLE64FF_V_M8_MASK,
          4209 => Opcode::PseudoVLE64_V_M1,
          4210 => Opcode::PseudoVLE64_V_M1_MASK,
          4211 => Opcode::PseudoVLE64_V_M2,
          4212 => Opcode::PseudoVLE64_V_M2_MASK,
          4213 => Opcode::PseudoVLE64_V_M4,
          4214 => Opcode::PseudoVLE64_V_M4_MASK,
          4215 => Opcode::PseudoVLE64_V_M8,
          4216 => Opcode::PseudoVLE64_V_M8_MASK,
          4217 => Opcode::PseudoVLE8FF_V_M1,
          4218 => Opcode::PseudoVLE8FF_V_M1_MASK,
          4219 => Opcode::PseudoVLE8FF_V_M2,
          4220 => Opcode::PseudoVLE8FF_V_M2_MASK,
          4221 => Opcode::PseudoVLE8FF_V_M4,
          4222 => Opcode::PseudoVLE8FF_V_M4_MASK,
          4223 => Opcode::PseudoVLE8FF_V_M8,
          4224 => Opcode::PseudoVLE8FF_V_M8_MASK,
          4225 => Opcode::PseudoVLE8FF_V_MF2,
          4226 => Opcode::PseudoVLE8FF_V_MF2_MASK,
          4227 => Opcode::PseudoVLE8FF_V_MF4,
          4228 => Opcode::PseudoVLE8FF_V_MF4_MASK,
          4229 => Opcode::PseudoVLE8FF_V_MF8,
          4230 => Opcode::PseudoVLE8FF_V_MF8_MASK,
          4231 => Opcode::PseudoVLE8_V_M1,
          4232 => Opcode::PseudoVLE8_V_M1_MASK,
          4233 => Opcode::PseudoVLE8_V_M2,
          4234 => Opcode::PseudoVLE8_V_M2_MASK,
          4235 => Opcode::PseudoVLE8_V_M4,
          4236 => Opcode::PseudoVLE8_V_M4_MASK,
          4237 => Opcode::PseudoVLE8_V_M8,
          4238 => Opcode::PseudoVLE8_V_M8_MASK,
          4239 => Opcode::PseudoVLE8_V_MF2,
          4240 => Opcode::PseudoVLE8_V_MF2_MASK,
          4241 => Opcode::PseudoVLE8_V_MF4,
          4242 => Opcode::PseudoVLE8_V_MF4_MASK,
          4243 => Opcode::PseudoVLE8_V_MF8,
          4244 => Opcode::PseudoVLE8_V_MF8_MASK,
          4245 => Opcode::PseudoVLM_V_B1,
          4246 => Opcode::PseudoVLM_V_B16,
          4247 => Opcode::PseudoVLM_V_B2,
          4248 => Opcode::PseudoVLM_V_B32,
          4249 => Opcode::PseudoVLM_V_B4,
          4250 => Opcode::PseudoVLM_V_B64,
          4251 => Opcode::PseudoVLM_V_B8,
          4252 => Opcode::PseudoVLOXEI16_V_M1_M1,
          4253 => Opcode::PseudoVLOXEI16_V_M1_M1_MASK,
          4254 => Opcode::PseudoVLOXEI16_V_M1_M2,
          4255 => Opcode::PseudoVLOXEI16_V_M1_M2_MASK,
          4256 => Opcode::PseudoVLOXEI16_V_M1_M4,
          4257 => Opcode::PseudoVLOXEI16_V_M1_M4_MASK,
          4258 => Opcode::PseudoVLOXEI16_V_M1_MF2,
          4259 => Opcode::PseudoVLOXEI16_V_M1_MF2_MASK,
          4260 => Opcode::PseudoVLOXEI16_V_M2_M1,
          4261 => Opcode::PseudoVLOXEI16_V_M2_M1_MASK,
          4262 => Opcode::PseudoVLOXEI16_V_M2_M2,
          4263 => Opcode::PseudoVLOXEI16_V_M2_M2_MASK,
          4264 => Opcode::PseudoVLOXEI16_V_M2_M4,
          4265 => Opcode::PseudoVLOXEI16_V_M2_M4_MASK,
          4266 => Opcode::PseudoVLOXEI16_V_M2_M8,
          4267 => Opcode::PseudoVLOXEI16_V_M2_M8_MASK,
          4268 => Opcode::PseudoVLOXEI16_V_M4_M2,
          4269 => Opcode::PseudoVLOXEI16_V_M4_M2_MASK,
          4270 => Opcode::PseudoVLOXEI16_V_M4_M4,
          4271 => Opcode::PseudoVLOXEI16_V_M4_M4_MASK,
          4272 => Opcode::PseudoVLOXEI16_V_M4_M8,
          4273 => Opcode::PseudoVLOXEI16_V_M4_M8_MASK,
          4274 => Opcode::PseudoVLOXEI16_V_M8_M4,
          4275 => Opcode::PseudoVLOXEI16_V_M8_M4_MASK,
          4276 => Opcode::PseudoVLOXEI16_V_M8_M8,
          4277 => Opcode::PseudoVLOXEI16_V_M8_M8_MASK,
          4278 => Opcode::PseudoVLOXEI16_V_MF2_M1,
          4279 => Opcode::PseudoVLOXEI16_V_MF2_M1_MASK,
          4280 => Opcode::PseudoVLOXEI16_V_MF2_M2,
          4281 => Opcode::PseudoVLOXEI16_V_MF2_M2_MASK,
          4282 => Opcode::PseudoVLOXEI16_V_MF2_MF2,
          4283 => Opcode::PseudoVLOXEI16_V_MF2_MF2_MASK,
          4284 => Opcode::PseudoVLOXEI16_V_MF2_MF4,
          4285 => Opcode::PseudoVLOXEI16_V_MF2_MF4_MASK,
          4286 => Opcode::PseudoVLOXEI16_V_MF4_M1,
          4287 => Opcode::PseudoVLOXEI16_V_MF4_M1_MASK,
          4288 => Opcode::PseudoVLOXEI16_V_MF4_MF2,
          4289 => Opcode::PseudoVLOXEI16_V_MF4_MF2_MASK,
          4290 => Opcode::PseudoVLOXEI16_V_MF4_MF4,
          4291 => Opcode::PseudoVLOXEI16_V_MF4_MF4_MASK,
          4292 => Opcode::PseudoVLOXEI16_V_MF4_MF8,
          4293 => Opcode::PseudoVLOXEI16_V_MF4_MF8_MASK,
          4294 => Opcode::PseudoVLOXEI32_V_M1_M1,
          4295 => Opcode::PseudoVLOXEI32_V_M1_M1_MASK,
          4296 => Opcode::PseudoVLOXEI32_V_M1_M2,
          4297 => Opcode::PseudoVLOXEI32_V_M1_M2_MASK,
          4298 => Opcode::PseudoVLOXEI32_V_M1_MF2,
          4299 => Opcode::PseudoVLOXEI32_V_M1_MF2_MASK,
          4300 => Opcode::PseudoVLOXEI32_V_M1_MF4,
          4301 => Opcode::PseudoVLOXEI32_V_M1_MF4_MASK,
          4302 => Opcode::PseudoVLOXEI32_V_M2_M1,
          4303 => Opcode::PseudoVLOXEI32_V_M2_M1_MASK,
          4304 => Opcode::PseudoVLOXEI32_V_M2_M2,
          4305 => Opcode::PseudoVLOXEI32_V_M2_M2_MASK,
          4306 => Opcode::PseudoVLOXEI32_V_M2_M4,
          4307 => Opcode::PseudoVLOXEI32_V_M2_M4_MASK,
          4308 => Opcode::PseudoVLOXEI32_V_M2_MF2,
          4309 => Opcode::PseudoVLOXEI32_V_M2_MF2_MASK,
          4310 => Opcode::PseudoVLOXEI32_V_M4_M1,
          4311 => Opcode::PseudoVLOXEI32_V_M4_M1_MASK,
          4312 => Opcode::PseudoVLOXEI32_V_M4_M2,
          4313 => Opcode::PseudoVLOXEI32_V_M4_M2_MASK,
          4314 => Opcode::PseudoVLOXEI32_V_M4_M4,
          4315 => Opcode::PseudoVLOXEI32_V_M4_M4_MASK,
          4316 => Opcode::PseudoVLOXEI32_V_M4_M8,
          4317 => Opcode::PseudoVLOXEI32_V_M4_M8_MASK,
          4318 => Opcode::PseudoVLOXEI32_V_M8_M2,
          4319 => Opcode::PseudoVLOXEI32_V_M8_M2_MASK,
          4320 => Opcode::PseudoVLOXEI32_V_M8_M4,
          4321 => Opcode::PseudoVLOXEI32_V_M8_M4_MASK,
          4322 => Opcode::PseudoVLOXEI32_V_M8_M8,
          4323 => Opcode::PseudoVLOXEI32_V_M8_M8_MASK,
          4324 => Opcode::PseudoVLOXEI32_V_MF2_M1,
          4325 => Opcode::PseudoVLOXEI32_V_MF2_M1_MASK,
          4326 => Opcode::PseudoVLOXEI32_V_MF2_MF2,
          4327 => Opcode::PseudoVLOXEI32_V_MF2_MF2_MASK,
          4328 => Opcode::PseudoVLOXEI32_V_MF2_MF4,
          4329 => Opcode::PseudoVLOXEI32_V_MF2_MF4_MASK,
          4330 => Opcode::PseudoVLOXEI32_V_MF2_MF8,
          4331 => Opcode::PseudoVLOXEI32_V_MF2_MF8_MASK,
          4332 => Opcode::PseudoVLOXEI64_V_M1_M1,
          4333 => Opcode::PseudoVLOXEI64_V_M1_M1_MASK,
          4334 => Opcode::PseudoVLOXEI64_V_M1_MF2,
          4335 => Opcode::PseudoVLOXEI64_V_M1_MF2_MASK,
          4336 => Opcode::PseudoVLOXEI64_V_M1_MF4,
          4337 => Opcode::PseudoVLOXEI64_V_M1_MF4_MASK,
          4338 => Opcode::PseudoVLOXEI64_V_M1_MF8,
          4339 => Opcode::PseudoVLOXEI64_V_M1_MF8_MASK,
          4340 => Opcode::PseudoVLOXEI64_V_M2_M1,
          4341 => Opcode::PseudoVLOXEI64_V_M2_M1_MASK,
          4342 => Opcode::PseudoVLOXEI64_V_M2_M2,
          4343 => Opcode::PseudoVLOXEI64_V_M2_M2_MASK,
          4344 => Opcode::PseudoVLOXEI64_V_M2_MF2,
          4345 => Opcode::PseudoVLOXEI64_V_M2_MF2_MASK,
          4346 => Opcode::PseudoVLOXEI64_V_M2_MF4,
          4347 => Opcode::PseudoVLOXEI64_V_M2_MF4_MASK,
          4348 => Opcode::PseudoVLOXEI64_V_M4_M1,
          4349 => Opcode::PseudoVLOXEI64_V_M4_M1_MASK,
          4350 => Opcode::PseudoVLOXEI64_V_M4_M2,
          4351 => Opcode::PseudoVLOXEI64_V_M4_M2_MASK,
          4352 => Opcode::PseudoVLOXEI64_V_M4_M4,
          4353 => Opcode::PseudoVLOXEI64_V_M4_M4_MASK,
          4354 => Opcode::PseudoVLOXEI64_V_M4_MF2,
          4355 => Opcode::PseudoVLOXEI64_V_M4_MF2_MASK,
          4356 => Opcode::PseudoVLOXEI64_V_M8_M1,
          4357 => Opcode::PseudoVLOXEI64_V_M8_M1_MASK,
          4358 => Opcode::PseudoVLOXEI64_V_M8_M2,
          4359 => Opcode::PseudoVLOXEI64_V_M8_M2_MASK,
          4360 => Opcode::PseudoVLOXEI64_V_M8_M4,
          4361 => Opcode::PseudoVLOXEI64_V_M8_M4_MASK,
          4362 => Opcode::PseudoVLOXEI64_V_M8_M8,
          4363 => Opcode::PseudoVLOXEI64_V_M8_M8_MASK,
          4364 => Opcode::PseudoVLOXEI8_V_M1_M1,
          4365 => Opcode::PseudoVLOXEI8_V_M1_M1_MASK,
          4366 => Opcode::PseudoVLOXEI8_V_M1_M2,
          4367 => Opcode::PseudoVLOXEI8_V_M1_M2_MASK,
          4368 => Opcode::PseudoVLOXEI8_V_M1_M4,
          4369 => Opcode::PseudoVLOXEI8_V_M1_M4_MASK,
          4370 => Opcode::PseudoVLOXEI8_V_M1_M8,
          4371 => Opcode::PseudoVLOXEI8_V_M1_M8_MASK,
          4372 => Opcode::PseudoVLOXEI8_V_M2_M2,
          4373 => Opcode::PseudoVLOXEI8_V_M2_M2_MASK,
          4374 => Opcode::PseudoVLOXEI8_V_M2_M4,
          4375 => Opcode::PseudoVLOXEI8_V_M2_M4_MASK,
          4376 => Opcode::PseudoVLOXEI8_V_M2_M8,
          4377 => Opcode::PseudoVLOXEI8_V_M2_M8_MASK,
          4378 => Opcode::PseudoVLOXEI8_V_M4_M4,
          4379 => Opcode::PseudoVLOXEI8_V_M4_M4_MASK,
          4380 => Opcode::PseudoVLOXEI8_V_M4_M8,
          4381 => Opcode::PseudoVLOXEI8_V_M4_M8_MASK,
          4382 => Opcode::PseudoVLOXEI8_V_M8_M8,
          4383 => Opcode::PseudoVLOXEI8_V_M8_M8_MASK,
          4384 => Opcode::PseudoVLOXEI8_V_MF2_M1,
          4385 => Opcode::PseudoVLOXEI8_V_MF2_M1_MASK,
          4386 => Opcode::PseudoVLOXEI8_V_MF2_M2,
          4387 => Opcode::PseudoVLOXEI8_V_MF2_M2_MASK,
          4388 => Opcode::PseudoVLOXEI8_V_MF2_M4,
          4389 => Opcode::PseudoVLOXEI8_V_MF2_M4_MASK,
          4390 => Opcode::PseudoVLOXEI8_V_MF2_MF2,
          4391 => Opcode::PseudoVLOXEI8_V_MF2_MF2_MASK,
          4392 => Opcode::PseudoVLOXEI8_V_MF4_M1,
          4393 => Opcode::PseudoVLOXEI8_V_MF4_M1_MASK,
          4394 => Opcode::PseudoVLOXEI8_V_MF4_M2,
          4395 => Opcode::PseudoVLOXEI8_V_MF4_M2_MASK,
          4396 => Opcode::PseudoVLOXEI8_V_MF4_MF2,
          4397 => Opcode::PseudoVLOXEI8_V_MF4_MF2_MASK,
          4398 => Opcode::PseudoVLOXEI8_V_MF4_MF4,
          4399 => Opcode::PseudoVLOXEI8_V_MF4_MF4_MASK,
          4400 => Opcode::PseudoVLOXEI8_V_MF8_M1,
          4401 => Opcode::PseudoVLOXEI8_V_MF8_M1_MASK,
          4402 => Opcode::PseudoVLOXEI8_V_MF8_MF2,
          4403 => Opcode::PseudoVLOXEI8_V_MF8_MF2_MASK,
          4404 => Opcode::PseudoVLOXEI8_V_MF8_MF4,
          4405 => Opcode::PseudoVLOXEI8_V_MF8_MF4_MASK,
          4406 => Opcode::PseudoVLOXEI8_V_MF8_MF8,
          4407 => Opcode::PseudoVLOXEI8_V_MF8_MF8_MASK,
          4408 => Opcode::PseudoVLOXSEG2EI16_V_M1_M1,
          4409 => Opcode::PseudoVLOXSEG2EI16_V_M1_M1_MASK,
          4410 => Opcode::PseudoVLOXSEG2EI16_V_M1_M2,
          4411 => Opcode::PseudoVLOXSEG2EI16_V_M1_M2_MASK,
          4412 => Opcode::PseudoVLOXSEG2EI16_V_M1_M4,
          4413 => Opcode::PseudoVLOXSEG2EI16_V_M1_M4_MASK,
          4414 => Opcode::PseudoVLOXSEG2EI16_V_M1_MF2,
          4415 => Opcode::PseudoVLOXSEG2EI16_V_M1_MF2_MASK,
          4416 => Opcode::PseudoVLOXSEG2EI16_V_M2_M1,
          4417 => Opcode::PseudoVLOXSEG2EI16_V_M2_M1_MASK,
          4418 => Opcode::PseudoVLOXSEG2EI16_V_M2_M2,
          4419 => Opcode::PseudoVLOXSEG2EI16_V_M2_M2_MASK,
          4420 => Opcode::PseudoVLOXSEG2EI16_V_M2_M4,
          4421 => Opcode::PseudoVLOXSEG2EI16_V_M2_M4_MASK,
          4422 => Opcode::PseudoVLOXSEG2EI16_V_M4_M2,
          4423 => Opcode::PseudoVLOXSEG2EI16_V_M4_M2_MASK,
          4424 => Opcode::PseudoVLOXSEG2EI16_V_M4_M4,
          4425 => Opcode::PseudoVLOXSEG2EI16_V_M4_M4_MASK,
          4426 => Opcode::PseudoVLOXSEG2EI16_V_M8_M4,
          4427 => Opcode::PseudoVLOXSEG2EI16_V_M8_M4_MASK,
          4428 => Opcode::PseudoVLOXSEG2EI16_V_MF2_M1,
          4429 => Opcode::PseudoVLOXSEG2EI16_V_MF2_M1_MASK,
          4430 => Opcode::PseudoVLOXSEG2EI16_V_MF2_M2,
          4431 => Opcode::PseudoVLOXSEG2EI16_V_MF2_M2_MASK,
          4432 => Opcode::PseudoVLOXSEG2EI16_V_MF2_MF2,
          4433 => Opcode::PseudoVLOXSEG2EI16_V_MF2_MF2_MASK,
          4434 => Opcode::PseudoVLOXSEG2EI16_V_MF2_MF4,
          4435 => Opcode::PseudoVLOXSEG2EI16_V_MF2_MF4_MASK,
          4436 => Opcode::PseudoVLOXSEG2EI16_V_MF4_M1,
          4437 => Opcode::PseudoVLOXSEG2EI16_V_MF4_M1_MASK,
          4438 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF2,
          4439 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF2_MASK,
          4440 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF4,
          4441 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF4_MASK,
          4442 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF8,
          4443 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF8_MASK,
          4444 => Opcode::PseudoVLOXSEG2EI32_V_M1_M1,
          4445 => Opcode::PseudoVLOXSEG2EI32_V_M1_M1_MASK,
          4446 => Opcode::PseudoVLOXSEG2EI32_V_M1_M2,
          4447 => Opcode::PseudoVLOXSEG2EI32_V_M1_M2_MASK,
          4448 => Opcode::PseudoVLOXSEG2EI32_V_M1_MF2,
          4449 => Opcode::PseudoVLOXSEG2EI32_V_M1_MF2_MASK,
          4450 => Opcode::PseudoVLOXSEG2EI32_V_M1_MF4,
          4451 => Opcode::PseudoVLOXSEG2EI32_V_M1_MF4_MASK,
          4452 => Opcode::PseudoVLOXSEG2EI32_V_M2_M1,
          4453 => Opcode::PseudoVLOXSEG2EI32_V_M2_M1_MASK,
          4454 => Opcode::PseudoVLOXSEG2EI32_V_M2_M2,
          4455 => Opcode::PseudoVLOXSEG2EI32_V_M2_M2_MASK,
          4456 => Opcode::PseudoVLOXSEG2EI32_V_M2_M4,
          4457 => Opcode::PseudoVLOXSEG2EI32_V_M2_M4_MASK,
          4458 => Opcode::PseudoVLOXSEG2EI32_V_M2_MF2,
          4459 => Opcode::PseudoVLOXSEG2EI32_V_M2_MF2_MASK,
          4460 => Opcode::PseudoVLOXSEG2EI32_V_M4_M1,
          4461 => Opcode::PseudoVLOXSEG2EI32_V_M4_M1_MASK,
          4462 => Opcode::PseudoVLOXSEG2EI32_V_M4_M2,
          4463 => Opcode::PseudoVLOXSEG2EI32_V_M4_M2_MASK,
          4464 => Opcode::PseudoVLOXSEG2EI32_V_M4_M4,
          4465 => Opcode::PseudoVLOXSEG2EI32_V_M4_M4_MASK,
          4466 => Opcode::PseudoVLOXSEG2EI32_V_M8_M2,
          4467 => Opcode::PseudoVLOXSEG2EI32_V_M8_M2_MASK,
          4468 => Opcode::PseudoVLOXSEG2EI32_V_M8_M4,
          4469 => Opcode::PseudoVLOXSEG2EI32_V_M8_M4_MASK,
          4470 => Opcode::PseudoVLOXSEG2EI32_V_MF2_M1,
          4471 => Opcode::PseudoVLOXSEG2EI32_V_MF2_M1_MASK,
          4472 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF2,
          4473 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF2_MASK,
          4474 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF4,
          4475 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF4_MASK,
          4476 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF8,
          4477 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF8_MASK,
          4478 => Opcode::PseudoVLOXSEG2EI64_V_M1_M1,
          4479 => Opcode::PseudoVLOXSEG2EI64_V_M1_M1_MASK,
          4480 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF2,
          4481 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF2_MASK,
          4482 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF4,
          4483 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF4_MASK,
          4484 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF8,
          4485 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF8_MASK,
          4486 => Opcode::PseudoVLOXSEG2EI64_V_M2_M1,
          4487 => Opcode::PseudoVLOXSEG2EI64_V_M2_M1_MASK,
          4488 => Opcode::PseudoVLOXSEG2EI64_V_M2_M2,
          4489 => Opcode::PseudoVLOXSEG2EI64_V_M2_M2_MASK,
          4490 => Opcode::PseudoVLOXSEG2EI64_V_M2_MF2,
          4491 => Opcode::PseudoVLOXSEG2EI64_V_M2_MF2_MASK,
          4492 => Opcode::PseudoVLOXSEG2EI64_V_M2_MF4,
          4493 => Opcode::PseudoVLOXSEG2EI64_V_M2_MF4_MASK,
          4494 => Opcode::PseudoVLOXSEG2EI64_V_M4_M1,
          4495 => Opcode::PseudoVLOXSEG2EI64_V_M4_M1_MASK,
          4496 => Opcode::PseudoVLOXSEG2EI64_V_M4_M2,
          4497 => Opcode::PseudoVLOXSEG2EI64_V_M4_M2_MASK,
          4498 => Opcode::PseudoVLOXSEG2EI64_V_M4_M4,
          4499 => Opcode::PseudoVLOXSEG2EI64_V_M4_M4_MASK,
          4500 => Opcode::PseudoVLOXSEG2EI64_V_M4_MF2,
          4501 => Opcode::PseudoVLOXSEG2EI64_V_M4_MF2_MASK,
          4502 => Opcode::PseudoVLOXSEG2EI64_V_M8_M1,
          4503 => Opcode::PseudoVLOXSEG2EI64_V_M8_M1_MASK,
          4504 => Opcode::PseudoVLOXSEG2EI64_V_M8_M2,
          4505 => Opcode::PseudoVLOXSEG2EI64_V_M8_M2_MASK,
          4506 => Opcode::PseudoVLOXSEG2EI64_V_M8_M4,
          4507 => Opcode::PseudoVLOXSEG2EI64_V_M8_M4_MASK,
          4508 => Opcode::PseudoVLOXSEG2EI8_V_M1_M1,
          4509 => Opcode::PseudoVLOXSEG2EI8_V_M1_M1_MASK,
          4510 => Opcode::PseudoVLOXSEG2EI8_V_M1_M2,
          4511 => Opcode::PseudoVLOXSEG2EI8_V_M1_M2_MASK,
          4512 => Opcode::PseudoVLOXSEG2EI8_V_M1_M4,
          4513 => Opcode::PseudoVLOXSEG2EI8_V_M1_M4_MASK,
          4514 => Opcode::PseudoVLOXSEG2EI8_V_M2_M2,
          4515 => Opcode::PseudoVLOXSEG2EI8_V_M2_M2_MASK,
          4516 => Opcode::PseudoVLOXSEG2EI8_V_M2_M4,
          4517 => Opcode::PseudoVLOXSEG2EI8_V_M2_M4_MASK,
          4518 => Opcode::PseudoVLOXSEG2EI8_V_M4_M4,
          4519 => Opcode::PseudoVLOXSEG2EI8_V_M4_M4_MASK,
          4520 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M1,
          4521 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M1_MASK,
          4522 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M2,
          4523 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M2_MASK,
          4524 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M4,
          4525 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M4_MASK,
          4526 => Opcode::PseudoVLOXSEG2EI8_V_MF2_MF2,
          4527 => Opcode::PseudoVLOXSEG2EI8_V_MF2_MF2_MASK,
          4528 => Opcode::PseudoVLOXSEG2EI8_V_MF4_M1,
          4529 => Opcode::PseudoVLOXSEG2EI8_V_MF4_M1_MASK,
          4530 => Opcode::PseudoVLOXSEG2EI8_V_MF4_M2,
          4531 => Opcode::PseudoVLOXSEG2EI8_V_MF4_M2_MASK,
          4532 => Opcode::PseudoVLOXSEG2EI8_V_MF4_MF2,
          4533 => Opcode::PseudoVLOXSEG2EI8_V_MF4_MF2_MASK,
          4534 => Opcode::PseudoVLOXSEG2EI8_V_MF4_MF4,
          4535 => Opcode::PseudoVLOXSEG2EI8_V_MF4_MF4_MASK,
          4536 => Opcode::PseudoVLOXSEG2EI8_V_MF8_M1,
          4537 => Opcode::PseudoVLOXSEG2EI8_V_MF8_M1_MASK,
          4538 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF2,
          4539 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF2_MASK,
          4540 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF4,
          4541 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF4_MASK,
          4542 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF8,
          4543 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF8_MASK,
          4544 => Opcode::PseudoVLOXSEG3EI16_V_M1_M1,
          4545 => Opcode::PseudoVLOXSEG3EI16_V_M1_M1_MASK,
          4546 => Opcode::PseudoVLOXSEG3EI16_V_M1_M2,
          4547 => Opcode::PseudoVLOXSEG3EI16_V_M1_M2_MASK,
          4548 => Opcode::PseudoVLOXSEG3EI16_V_M1_MF2,
          4549 => Opcode::PseudoVLOXSEG3EI16_V_M1_MF2_MASK,
          4550 => Opcode::PseudoVLOXSEG3EI16_V_M2_M1,
          4551 => Opcode::PseudoVLOXSEG3EI16_V_M2_M1_MASK,
          4552 => Opcode::PseudoVLOXSEG3EI16_V_M2_M2,
          4553 => Opcode::PseudoVLOXSEG3EI16_V_M2_M2_MASK,
          4554 => Opcode::PseudoVLOXSEG3EI16_V_M4_M2,
          4555 => Opcode::PseudoVLOXSEG3EI16_V_M4_M2_MASK,
          4556 => Opcode::PseudoVLOXSEG3EI16_V_MF2_M1,
          4557 => Opcode::PseudoVLOXSEG3EI16_V_MF2_M1_MASK,
          4558 => Opcode::PseudoVLOXSEG3EI16_V_MF2_M2,
          4559 => Opcode::PseudoVLOXSEG3EI16_V_MF2_M2_MASK,
          4560 => Opcode::PseudoVLOXSEG3EI16_V_MF2_MF2,
          4561 => Opcode::PseudoVLOXSEG3EI16_V_MF2_MF2_MASK,
          4562 => Opcode::PseudoVLOXSEG3EI16_V_MF2_MF4,
          4563 => Opcode::PseudoVLOXSEG3EI16_V_MF2_MF4_MASK,
          4564 => Opcode::PseudoVLOXSEG3EI16_V_MF4_M1,
          4565 => Opcode::PseudoVLOXSEG3EI16_V_MF4_M1_MASK,
          4566 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF2,
          4567 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF2_MASK,
          4568 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF4,
          4569 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF4_MASK,
          4570 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF8,
          4571 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF8_MASK,
          4572 => Opcode::PseudoVLOXSEG3EI32_V_M1_M1,
          4573 => Opcode::PseudoVLOXSEG3EI32_V_M1_M1_MASK,
          4574 => Opcode::PseudoVLOXSEG3EI32_V_M1_M2,
          4575 => Opcode::PseudoVLOXSEG3EI32_V_M1_M2_MASK,
          4576 => Opcode::PseudoVLOXSEG3EI32_V_M1_MF2,
          4577 => Opcode::PseudoVLOXSEG3EI32_V_M1_MF2_MASK,
          4578 => Opcode::PseudoVLOXSEG3EI32_V_M1_MF4,
          4579 => Opcode::PseudoVLOXSEG3EI32_V_M1_MF4_MASK,
          4580 => Opcode::PseudoVLOXSEG3EI32_V_M2_M1,
          4581 => Opcode::PseudoVLOXSEG3EI32_V_M2_M1_MASK,
          4582 => Opcode::PseudoVLOXSEG3EI32_V_M2_M2,
          4583 => Opcode::PseudoVLOXSEG3EI32_V_M2_M2_MASK,
          4584 => Opcode::PseudoVLOXSEG3EI32_V_M2_MF2,
          4585 => Opcode::PseudoVLOXSEG3EI32_V_M2_MF2_MASK,
          4586 => Opcode::PseudoVLOXSEG3EI32_V_M4_M1,
          4587 => Opcode::PseudoVLOXSEG3EI32_V_M4_M1_MASK,
          4588 => Opcode::PseudoVLOXSEG3EI32_V_M4_M2,
          4589 => Opcode::PseudoVLOXSEG3EI32_V_M4_M2_MASK,
          4590 => Opcode::PseudoVLOXSEG3EI32_V_M8_M2,
          4591 => Opcode::PseudoVLOXSEG3EI32_V_M8_M2_MASK,
          4592 => Opcode::PseudoVLOXSEG3EI32_V_MF2_M1,
          4593 => Opcode::PseudoVLOXSEG3EI32_V_MF2_M1_MASK,
          4594 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF2,
          4595 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF2_MASK,
          4596 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF4,
          4597 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF4_MASK,
          4598 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF8,
          4599 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF8_MASK,
          4600 => Opcode::PseudoVLOXSEG3EI64_V_M1_M1,
          4601 => Opcode::PseudoVLOXSEG3EI64_V_M1_M1_MASK,
          4602 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF2,
          4603 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF2_MASK,
          4604 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF4,
          4605 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF4_MASK,
          4606 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF8,
          4607 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF8_MASK,
          4608 => Opcode::PseudoVLOXSEG3EI64_V_M2_M1,
          4609 => Opcode::PseudoVLOXSEG3EI64_V_M2_M1_MASK,
          4610 => Opcode::PseudoVLOXSEG3EI64_V_M2_M2,
          4611 => Opcode::PseudoVLOXSEG3EI64_V_M2_M2_MASK,
          4612 => Opcode::PseudoVLOXSEG3EI64_V_M2_MF2,
          4613 => Opcode::PseudoVLOXSEG3EI64_V_M2_MF2_MASK,
          4614 => Opcode::PseudoVLOXSEG3EI64_V_M2_MF4,
          4615 => Opcode::PseudoVLOXSEG3EI64_V_M2_MF4_MASK,
          4616 => Opcode::PseudoVLOXSEG3EI64_V_M4_M1,
          4617 => Opcode::PseudoVLOXSEG3EI64_V_M4_M1_MASK,
          4618 => Opcode::PseudoVLOXSEG3EI64_V_M4_M2,
          4619 => Opcode::PseudoVLOXSEG3EI64_V_M4_M2_MASK,
          4620 => Opcode::PseudoVLOXSEG3EI64_V_M4_MF2,
          4621 => Opcode::PseudoVLOXSEG3EI64_V_M4_MF2_MASK,
          4622 => Opcode::PseudoVLOXSEG3EI64_V_M8_M1,
          4623 => Opcode::PseudoVLOXSEG3EI64_V_M8_M1_MASK,
          4624 => Opcode::PseudoVLOXSEG3EI64_V_M8_M2,
          4625 => Opcode::PseudoVLOXSEG3EI64_V_M8_M2_MASK,
          4626 => Opcode::PseudoVLOXSEG3EI8_V_M1_M1,
          4627 => Opcode::PseudoVLOXSEG3EI8_V_M1_M1_MASK,
          4628 => Opcode::PseudoVLOXSEG3EI8_V_M1_M2,
          4629 => Opcode::PseudoVLOXSEG3EI8_V_M1_M2_MASK,
          4630 => Opcode::PseudoVLOXSEG3EI8_V_M2_M2,
          4631 => Opcode::PseudoVLOXSEG3EI8_V_M2_M2_MASK,
          4632 => Opcode::PseudoVLOXSEG3EI8_V_MF2_M1,
          4633 => Opcode::PseudoVLOXSEG3EI8_V_MF2_M1_MASK,
          4634 => Opcode::PseudoVLOXSEG3EI8_V_MF2_M2,
          4635 => Opcode::PseudoVLOXSEG3EI8_V_MF2_M2_MASK,
          4636 => Opcode::PseudoVLOXSEG3EI8_V_MF2_MF2,
          4637 => Opcode::PseudoVLOXSEG3EI8_V_MF2_MF2_MASK,
          4638 => Opcode::PseudoVLOXSEG3EI8_V_MF4_M1,
          4639 => Opcode::PseudoVLOXSEG3EI8_V_MF4_M1_MASK,
          4640 => Opcode::PseudoVLOXSEG3EI8_V_MF4_M2,
          4641 => Opcode::PseudoVLOXSEG3EI8_V_MF4_M2_MASK,
          4642 => Opcode::PseudoVLOXSEG3EI8_V_MF4_MF2,
          4643 => Opcode::PseudoVLOXSEG3EI8_V_MF4_MF2_MASK,
          4644 => Opcode::PseudoVLOXSEG3EI8_V_MF4_MF4,
          4645 => Opcode::PseudoVLOXSEG3EI8_V_MF4_MF4_MASK,
          4646 => Opcode::PseudoVLOXSEG3EI8_V_MF8_M1,
          4647 => Opcode::PseudoVLOXSEG3EI8_V_MF8_M1_MASK,
          4648 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF2,
          4649 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF2_MASK,
          4650 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF4,
          4651 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF4_MASK,
          4652 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF8,
          4653 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF8_MASK,
          4654 => Opcode::PseudoVLOXSEG4EI16_V_M1_M1,
          4655 => Opcode::PseudoVLOXSEG4EI16_V_M1_M1_MASK,
          4656 => Opcode::PseudoVLOXSEG4EI16_V_M1_M2,
          4657 => Opcode::PseudoVLOXSEG4EI16_V_M1_M2_MASK,
          4658 => Opcode::PseudoVLOXSEG4EI16_V_M1_MF2,
          4659 => Opcode::PseudoVLOXSEG4EI16_V_M1_MF2_MASK,
          4660 => Opcode::PseudoVLOXSEG4EI16_V_M2_M1,
          4661 => Opcode::PseudoVLOXSEG4EI16_V_M2_M1_MASK,
          4662 => Opcode::PseudoVLOXSEG4EI16_V_M2_M2,
          4663 => Opcode::PseudoVLOXSEG4EI16_V_M2_M2_MASK,
          4664 => Opcode::PseudoVLOXSEG4EI16_V_M4_M2,
          4665 => Opcode::PseudoVLOXSEG4EI16_V_M4_M2_MASK,
          4666 => Opcode::PseudoVLOXSEG4EI16_V_MF2_M1,
          4667 => Opcode::PseudoVLOXSEG4EI16_V_MF2_M1_MASK,
          4668 => Opcode::PseudoVLOXSEG4EI16_V_MF2_M2,
          4669 => Opcode::PseudoVLOXSEG4EI16_V_MF2_M2_MASK,
          4670 => Opcode::PseudoVLOXSEG4EI16_V_MF2_MF2,
          4671 => Opcode::PseudoVLOXSEG4EI16_V_MF2_MF2_MASK,
          4672 => Opcode::PseudoVLOXSEG4EI16_V_MF2_MF4,
          4673 => Opcode::PseudoVLOXSEG4EI16_V_MF2_MF4_MASK,
          4674 => Opcode::PseudoVLOXSEG4EI16_V_MF4_M1,
          4675 => Opcode::PseudoVLOXSEG4EI16_V_MF4_M1_MASK,
          4676 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF2,
          4677 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF2_MASK,
          4678 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF4,
          4679 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF4_MASK,
          4680 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF8,
          4681 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF8_MASK,
          4682 => Opcode::PseudoVLOXSEG4EI32_V_M1_M1,
          4683 => Opcode::PseudoVLOXSEG4EI32_V_M1_M1_MASK,
          4684 => Opcode::PseudoVLOXSEG4EI32_V_M1_M2,
          4685 => Opcode::PseudoVLOXSEG4EI32_V_M1_M2_MASK,
          4686 => Opcode::PseudoVLOXSEG4EI32_V_M1_MF2,
          4687 => Opcode::PseudoVLOXSEG4EI32_V_M1_MF2_MASK,
          4688 => Opcode::PseudoVLOXSEG4EI32_V_M1_MF4,
          4689 => Opcode::PseudoVLOXSEG4EI32_V_M1_MF4_MASK,
          4690 => Opcode::PseudoVLOXSEG4EI32_V_M2_M1,
          4691 => Opcode::PseudoVLOXSEG4EI32_V_M2_M1_MASK,
          4692 => Opcode::PseudoVLOXSEG4EI32_V_M2_M2,
          4693 => Opcode::PseudoVLOXSEG4EI32_V_M2_M2_MASK,
          4694 => Opcode::PseudoVLOXSEG4EI32_V_M2_MF2,
          4695 => Opcode::PseudoVLOXSEG4EI32_V_M2_MF2_MASK,
          4696 => Opcode::PseudoVLOXSEG4EI32_V_M4_M1,
          4697 => Opcode::PseudoVLOXSEG4EI32_V_M4_M1_MASK,
          4698 => Opcode::PseudoVLOXSEG4EI32_V_M4_M2,
          4699 => Opcode::PseudoVLOXSEG4EI32_V_M4_M2_MASK,
          4700 => Opcode::PseudoVLOXSEG4EI32_V_M8_M2,
          4701 => Opcode::PseudoVLOXSEG4EI32_V_M8_M2_MASK,
          4702 => Opcode::PseudoVLOXSEG4EI32_V_MF2_M1,
          4703 => Opcode::PseudoVLOXSEG4EI32_V_MF2_M1_MASK,
          4704 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF2,
          4705 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF2_MASK,
          4706 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF4,
          4707 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF4_MASK,
          4708 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF8,
          4709 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF8_MASK,
          4710 => Opcode::PseudoVLOXSEG4EI64_V_M1_M1,
          4711 => Opcode::PseudoVLOXSEG4EI64_V_M1_M1_MASK,
          4712 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF2,
          4713 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF2_MASK,
          4714 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF4,
          4715 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF4_MASK,
          4716 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF8,
          4717 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF8_MASK,
          4718 => Opcode::PseudoVLOXSEG4EI64_V_M2_M1,
          4719 => Opcode::PseudoVLOXSEG4EI64_V_M2_M1_MASK,
          4720 => Opcode::PseudoVLOXSEG4EI64_V_M2_M2,
          4721 => Opcode::PseudoVLOXSEG4EI64_V_M2_M2_MASK,
          4722 => Opcode::PseudoVLOXSEG4EI64_V_M2_MF2,
          4723 => Opcode::PseudoVLOXSEG4EI64_V_M2_MF2_MASK,
          4724 => Opcode::PseudoVLOXSEG4EI64_V_M2_MF4,
          4725 => Opcode::PseudoVLOXSEG4EI64_V_M2_MF4_MASK,
          4726 => Opcode::PseudoVLOXSEG4EI64_V_M4_M1,
          4727 => Opcode::PseudoVLOXSEG4EI64_V_M4_M1_MASK,
          4728 => Opcode::PseudoVLOXSEG4EI64_V_M4_M2,
          4729 => Opcode::PseudoVLOXSEG4EI64_V_M4_M2_MASK,
          4730 => Opcode::PseudoVLOXSEG4EI64_V_M4_MF2,
          4731 => Opcode::PseudoVLOXSEG4EI64_V_M4_MF2_MASK,
          4732 => Opcode::PseudoVLOXSEG4EI64_V_M8_M1,
          4733 => Opcode::PseudoVLOXSEG4EI64_V_M8_M1_MASK,
          4734 => Opcode::PseudoVLOXSEG4EI64_V_M8_M2,
          4735 => Opcode::PseudoVLOXSEG4EI64_V_M8_M2_MASK,
          4736 => Opcode::PseudoVLOXSEG4EI8_V_M1_M1,
          4737 => Opcode::PseudoVLOXSEG4EI8_V_M1_M1_MASK,
          4738 => Opcode::PseudoVLOXSEG4EI8_V_M1_M2,
          4739 => Opcode::PseudoVLOXSEG4EI8_V_M1_M2_MASK,
          4740 => Opcode::PseudoVLOXSEG4EI8_V_M2_M2,
          4741 => Opcode::PseudoVLOXSEG4EI8_V_M2_M2_MASK,
          4742 => Opcode::PseudoVLOXSEG4EI8_V_MF2_M1,
          4743 => Opcode::PseudoVLOXSEG4EI8_V_MF2_M1_MASK,
          4744 => Opcode::PseudoVLOXSEG4EI8_V_MF2_M2,
          4745 => Opcode::PseudoVLOXSEG4EI8_V_MF2_M2_MASK,
          4746 => Opcode::PseudoVLOXSEG4EI8_V_MF2_MF2,
          4747 => Opcode::PseudoVLOXSEG4EI8_V_MF2_MF2_MASK,
          4748 => Opcode::PseudoVLOXSEG4EI8_V_MF4_M1,
          4749 => Opcode::PseudoVLOXSEG4EI8_V_MF4_M1_MASK,
          4750 => Opcode::PseudoVLOXSEG4EI8_V_MF4_M2,
          4751 => Opcode::PseudoVLOXSEG4EI8_V_MF4_M2_MASK,
          4752 => Opcode::PseudoVLOXSEG4EI8_V_MF4_MF2,
          4753 => Opcode::PseudoVLOXSEG4EI8_V_MF4_MF2_MASK,
          4754 => Opcode::PseudoVLOXSEG4EI8_V_MF4_MF4,
          4755 => Opcode::PseudoVLOXSEG4EI8_V_MF4_MF4_MASK,
          4756 => Opcode::PseudoVLOXSEG4EI8_V_MF8_M1,
          4757 => Opcode::PseudoVLOXSEG4EI8_V_MF8_M1_MASK,
          4758 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF2,
          4759 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF2_MASK,
          4760 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF4,
          4761 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF4_MASK,
          4762 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF8,
          4763 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF8_MASK,
          4764 => Opcode::PseudoVLOXSEG5EI16_V_M1_M1,
          4765 => Opcode::PseudoVLOXSEG5EI16_V_M1_M1_MASK,
          4766 => Opcode::PseudoVLOXSEG5EI16_V_M1_MF2,
          4767 => Opcode::PseudoVLOXSEG5EI16_V_M1_MF2_MASK,
          4768 => Opcode::PseudoVLOXSEG5EI16_V_M2_M1,
          4769 => Opcode::PseudoVLOXSEG5EI16_V_M2_M1_MASK,
          4770 => Opcode::PseudoVLOXSEG5EI16_V_MF2_M1,
          4771 => Opcode::PseudoVLOXSEG5EI16_V_MF2_M1_MASK,
          4772 => Opcode::PseudoVLOXSEG5EI16_V_MF2_MF2,
          4773 => Opcode::PseudoVLOXSEG5EI16_V_MF2_MF2_MASK,
          4774 => Opcode::PseudoVLOXSEG5EI16_V_MF2_MF4,
          4775 => Opcode::PseudoVLOXSEG5EI16_V_MF2_MF4_MASK,
          4776 => Opcode::PseudoVLOXSEG5EI16_V_MF4_M1,
          4777 => Opcode::PseudoVLOXSEG5EI16_V_MF4_M1_MASK,
          4778 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF2,
          4779 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF2_MASK,
          4780 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF4,
          4781 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF4_MASK,
          4782 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF8,
          4783 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF8_MASK,
          4784 => Opcode::PseudoVLOXSEG5EI32_V_M1_M1,
          4785 => Opcode::PseudoVLOXSEG5EI32_V_M1_M1_MASK,
          4786 => Opcode::PseudoVLOXSEG5EI32_V_M1_MF2,
          4787 => Opcode::PseudoVLOXSEG5EI32_V_M1_MF2_MASK,
          4788 => Opcode::PseudoVLOXSEG5EI32_V_M1_MF4,
          4789 => Opcode::PseudoVLOXSEG5EI32_V_M1_MF4_MASK,
          4790 => Opcode::PseudoVLOXSEG5EI32_V_M2_M1,
          4791 => Opcode::PseudoVLOXSEG5EI32_V_M2_M1_MASK,
          4792 => Opcode::PseudoVLOXSEG5EI32_V_M2_MF2,
          4793 => Opcode::PseudoVLOXSEG5EI32_V_M2_MF2_MASK,
          4794 => Opcode::PseudoVLOXSEG5EI32_V_M4_M1,
          4795 => Opcode::PseudoVLOXSEG5EI32_V_M4_M1_MASK,
          4796 => Opcode::PseudoVLOXSEG5EI32_V_MF2_M1,
          4797 => Opcode::PseudoVLOXSEG5EI32_V_MF2_M1_MASK,
          4798 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF2,
          4799 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF2_MASK,
          4800 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF4,
          4801 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF4_MASK,
          4802 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF8,
          4803 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF8_MASK,
          4804 => Opcode::PseudoVLOXSEG5EI64_V_M1_M1,
          4805 => Opcode::PseudoVLOXSEG5EI64_V_M1_M1_MASK,
          4806 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF2,
          4807 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF2_MASK,
          4808 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF4,
          4809 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF4_MASK,
          4810 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF8,
          4811 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF8_MASK,
          4812 => Opcode::PseudoVLOXSEG5EI64_V_M2_M1,
          4813 => Opcode::PseudoVLOXSEG5EI64_V_M2_M1_MASK,
          4814 => Opcode::PseudoVLOXSEG5EI64_V_M2_MF2,
          4815 => Opcode::PseudoVLOXSEG5EI64_V_M2_MF2_MASK,
          4816 => Opcode::PseudoVLOXSEG5EI64_V_M2_MF4,
          4817 => Opcode::PseudoVLOXSEG5EI64_V_M2_MF4_MASK,
          4818 => Opcode::PseudoVLOXSEG5EI64_V_M4_M1,
          4819 => Opcode::PseudoVLOXSEG5EI64_V_M4_M1_MASK,
          4820 => Opcode::PseudoVLOXSEG5EI64_V_M4_MF2,
          4821 => Opcode::PseudoVLOXSEG5EI64_V_M4_MF2_MASK,
          4822 => Opcode::PseudoVLOXSEG5EI64_V_M8_M1,
          4823 => Opcode::PseudoVLOXSEG5EI64_V_M8_M1_MASK,
          4824 => Opcode::PseudoVLOXSEG5EI8_V_M1_M1,
          4825 => Opcode::PseudoVLOXSEG5EI8_V_M1_M1_MASK,
          4826 => Opcode::PseudoVLOXSEG5EI8_V_MF2_M1,
          4827 => Opcode::PseudoVLOXSEG5EI8_V_MF2_M1_MASK,
          4828 => Opcode::PseudoVLOXSEG5EI8_V_MF2_MF2,
          4829 => Opcode::PseudoVLOXSEG5EI8_V_MF2_MF2_MASK,
          4830 => Opcode::PseudoVLOXSEG5EI8_V_MF4_M1,
          4831 => Opcode::PseudoVLOXSEG5EI8_V_MF4_M1_MASK,
          4832 => Opcode::PseudoVLOXSEG5EI8_V_MF4_MF2,
          4833 => Opcode::PseudoVLOXSEG5EI8_V_MF4_MF2_MASK,
          4834 => Opcode::PseudoVLOXSEG5EI8_V_MF4_MF4,
          4835 => Opcode::PseudoVLOXSEG5EI8_V_MF4_MF4_MASK,
          4836 => Opcode::PseudoVLOXSEG5EI8_V_MF8_M1,
          4837 => Opcode::PseudoVLOXSEG5EI8_V_MF8_M1_MASK,
          4838 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF2,
          4839 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF2_MASK,
          4840 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF4,
          4841 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF4_MASK,
          4842 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF8,
          4843 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF8_MASK,
          4844 => Opcode::PseudoVLOXSEG6EI16_V_M1_M1,
          4845 => Opcode::PseudoVLOXSEG6EI16_V_M1_M1_MASK,
          4846 => Opcode::PseudoVLOXSEG6EI16_V_M1_MF2,
          4847 => Opcode::PseudoVLOXSEG6EI16_V_M1_MF2_MASK,
          4848 => Opcode::PseudoVLOXSEG6EI16_V_M2_M1,
          4849 => Opcode::PseudoVLOXSEG6EI16_V_M2_M1_MASK,
          4850 => Opcode::PseudoVLOXSEG6EI16_V_MF2_M1,
          4851 => Opcode::PseudoVLOXSEG6EI16_V_MF2_M1_MASK,
          4852 => Opcode::PseudoVLOXSEG6EI16_V_MF2_MF2,
          4853 => Opcode::PseudoVLOXSEG6EI16_V_MF2_MF2_MASK,
          4854 => Opcode::PseudoVLOXSEG6EI16_V_MF2_MF4,
          4855 => Opcode::PseudoVLOXSEG6EI16_V_MF2_MF4_MASK,
          4856 => Opcode::PseudoVLOXSEG6EI16_V_MF4_M1,
          4857 => Opcode::PseudoVLOXSEG6EI16_V_MF4_M1_MASK,
          4858 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF2,
          4859 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF2_MASK,
          4860 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF4,
          4861 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF4_MASK,
          4862 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF8,
          4863 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF8_MASK,
          4864 => Opcode::PseudoVLOXSEG6EI32_V_M1_M1,
          4865 => Opcode::PseudoVLOXSEG6EI32_V_M1_M1_MASK,
          4866 => Opcode::PseudoVLOXSEG6EI32_V_M1_MF2,
          4867 => Opcode::PseudoVLOXSEG6EI32_V_M1_MF2_MASK,
          4868 => Opcode::PseudoVLOXSEG6EI32_V_M1_MF4,
          4869 => Opcode::PseudoVLOXSEG6EI32_V_M1_MF4_MASK,
          4870 => Opcode::PseudoVLOXSEG6EI32_V_M2_M1,
          4871 => Opcode::PseudoVLOXSEG6EI32_V_M2_M1_MASK,
          4872 => Opcode::PseudoVLOXSEG6EI32_V_M2_MF2,
          4873 => Opcode::PseudoVLOXSEG6EI32_V_M2_MF2_MASK,
          4874 => Opcode::PseudoVLOXSEG6EI32_V_M4_M1,
          4875 => Opcode::PseudoVLOXSEG6EI32_V_M4_M1_MASK,
          4876 => Opcode::PseudoVLOXSEG6EI32_V_MF2_M1,
          4877 => Opcode::PseudoVLOXSEG6EI32_V_MF2_M1_MASK,
          4878 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF2,
          4879 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF2_MASK,
          4880 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF4,
          4881 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF4_MASK,
          4882 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF8,
          4883 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF8_MASK,
          4884 => Opcode::PseudoVLOXSEG6EI64_V_M1_M1,
          4885 => Opcode::PseudoVLOXSEG6EI64_V_M1_M1_MASK,
          4886 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF2,
          4887 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF2_MASK,
          4888 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF4,
          4889 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF4_MASK,
          4890 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF8,
          4891 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF8_MASK,
          4892 => Opcode::PseudoVLOXSEG6EI64_V_M2_M1,
          4893 => Opcode::PseudoVLOXSEG6EI64_V_M2_M1_MASK,
          4894 => Opcode::PseudoVLOXSEG6EI64_V_M2_MF2,
          4895 => Opcode::PseudoVLOXSEG6EI64_V_M2_MF2_MASK,
          4896 => Opcode::PseudoVLOXSEG6EI64_V_M2_MF4,
          4897 => Opcode::PseudoVLOXSEG6EI64_V_M2_MF4_MASK,
          4898 => Opcode::PseudoVLOXSEG6EI64_V_M4_M1,
          4899 => Opcode::PseudoVLOXSEG6EI64_V_M4_M1_MASK,
          4900 => Opcode::PseudoVLOXSEG6EI64_V_M4_MF2,
          4901 => Opcode::PseudoVLOXSEG6EI64_V_M4_MF2_MASK,
          4902 => Opcode::PseudoVLOXSEG6EI64_V_M8_M1,
          4903 => Opcode::PseudoVLOXSEG6EI64_V_M8_M1_MASK,
          4904 => Opcode::PseudoVLOXSEG6EI8_V_M1_M1,
          4905 => Opcode::PseudoVLOXSEG6EI8_V_M1_M1_MASK,
          4906 => Opcode::PseudoVLOXSEG6EI8_V_MF2_M1,
          4907 => Opcode::PseudoVLOXSEG6EI8_V_MF2_M1_MASK,
          4908 => Opcode::PseudoVLOXSEG6EI8_V_MF2_MF2,
          4909 => Opcode::PseudoVLOXSEG6EI8_V_MF2_MF2_MASK,
          4910 => Opcode::PseudoVLOXSEG6EI8_V_MF4_M1,
          4911 => Opcode::PseudoVLOXSEG6EI8_V_MF4_M1_MASK,
          4912 => Opcode::PseudoVLOXSEG6EI8_V_MF4_MF2,
          4913 => Opcode::PseudoVLOXSEG6EI8_V_MF4_MF2_MASK,
          4914 => Opcode::PseudoVLOXSEG6EI8_V_MF4_MF4,
          4915 => Opcode::PseudoVLOXSEG6EI8_V_MF4_MF4_MASK,
          4916 => Opcode::PseudoVLOXSEG6EI8_V_MF8_M1,
          4917 => Opcode::PseudoVLOXSEG6EI8_V_MF8_M1_MASK,
          4918 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF2,
          4919 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF2_MASK,
          4920 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF4,
          4921 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF4_MASK,
          4922 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF8,
          4923 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF8_MASK,
          4924 => Opcode::PseudoVLOXSEG7EI16_V_M1_M1,
          4925 => Opcode::PseudoVLOXSEG7EI16_V_M1_M1_MASK,
          4926 => Opcode::PseudoVLOXSEG7EI16_V_M1_MF2,
          4927 => Opcode::PseudoVLOXSEG7EI16_V_M1_MF2_MASK,
          4928 => Opcode::PseudoVLOXSEG7EI16_V_M2_M1,
          4929 => Opcode::PseudoVLOXSEG7EI16_V_M2_M1_MASK,
          4930 => Opcode::PseudoVLOXSEG7EI16_V_MF2_M1,
          4931 => Opcode::PseudoVLOXSEG7EI16_V_MF2_M1_MASK,
          4932 => Opcode::PseudoVLOXSEG7EI16_V_MF2_MF2,
          4933 => Opcode::PseudoVLOXSEG7EI16_V_MF2_MF2_MASK,
          4934 => Opcode::PseudoVLOXSEG7EI16_V_MF2_MF4,
          4935 => Opcode::PseudoVLOXSEG7EI16_V_MF2_MF4_MASK,
          4936 => Opcode::PseudoVLOXSEG7EI16_V_MF4_M1,
          4937 => Opcode::PseudoVLOXSEG7EI16_V_MF4_M1_MASK,
          4938 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF2,
          4939 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF2_MASK,
          4940 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF4,
          4941 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF4_MASK,
          4942 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF8,
          4943 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF8_MASK,
          4944 => Opcode::PseudoVLOXSEG7EI32_V_M1_M1,
          4945 => Opcode::PseudoVLOXSEG7EI32_V_M1_M1_MASK,
          4946 => Opcode::PseudoVLOXSEG7EI32_V_M1_MF2,
          4947 => Opcode::PseudoVLOXSEG7EI32_V_M1_MF2_MASK,
          4948 => Opcode::PseudoVLOXSEG7EI32_V_M1_MF4,
          4949 => Opcode::PseudoVLOXSEG7EI32_V_M1_MF4_MASK,
          4950 => Opcode::PseudoVLOXSEG7EI32_V_M2_M1,
          4951 => Opcode::PseudoVLOXSEG7EI32_V_M2_M1_MASK,
          4952 => Opcode::PseudoVLOXSEG7EI32_V_M2_MF2,
          4953 => Opcode::PseudoVLOXSEG7EI32_V_M2_MF2_MASK,
          4954 => Opcode::PseudoVLOXSEG7EI32_V_M4_M1,
          4955 => Opcode::PseudoVLOXSEG7EI32_V_M4_M1_MASK,
          4956 => Opcode::PseudoVLOXSEG7EI32_V_MF2_M1,
          4957 => Opcode::PseudoVLOXSEG7EI32_V_MF2_M1_MASK,
          4958 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF2,
          4959 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF2_MASK,
          4960 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF4,
          4961 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF4_MASK,
          4962 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF8,
          4963 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF8_MASK,
          4964 => Opcode::PseudoVLOXSEG7EI64_V_M1_M1,
          4965 => Opcode::PseudoVLOXSEG7EI64_V_M1_M1_MASK,
          4966 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF2,
          4967 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF2_MASK,
          4968 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF4,
          4969 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF4_MASK,
          4970 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF8,
          4971 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF8_MASK,
          4972 => Opcode::PseudoVLOXSEG7EI64_V_M2_M1,
          4973 => Opcode::PseudoVLOXSEG7EI64_V_M2_M1_MASK,
          4974 => Opcode::PseudoVLOXSEG7EI64_V_M2_MF2,
          4975 => Opcode::PseudoVLOXSEG7EI64_V_M2_MF2_MASK,
          4976 => Opcode::PseudoVLOXSEG7EI64_V_M2_MF4,
          4977 => Opcode::PseudoVLOXSEG7EI64_V_M2_MF4_MASK,
          4978 => Opcode::PseudoVLOXSEG7EI64_V_M4_M1,
          4979 => Opcode::PseudoVLOXSEG7EI64_V_M4_M1_MASK,
          4980 => Opcode::PseudoVLOXSEG7EI64_V_M4_MF2,
          4981 => Opcode::PseudoVLOXSEG7EI64_V_M4_MF2_MASK,
          4982 => Opcode::PseudoVLOXSEG7EI64_V_M8_M1,
          4983 => Opcode::PseudoVLOXSEG7EI64_V_M8_M1_MASK,
          4984 => Opcode::PseudoVLOXSEG7EI8_V_M1_M1,
          4985 => Opcode::PseudoVLOXSEG7EI8_V_M1_M1_MASK,
          4986 => Opcode::PseudoVLOXSEG7EI8_V_MF2_M1,
          4987 => Opcode::PseudoVLOXSEG7EI8_V_MF2_M1_MASK,
          4988 => Opcode::PseudoVLOXSEG7EI8_V_MF2_MF2,
          4989 => Opcode::PseudoVLOXSEG7EI8_V_MF2_MF2_MASK,
          4990 => Opcode::PseudoVLOXSEG7EI8_V_MF4_M1,
          4991 => Opcode::PseudoVLOXSEG7EI8_V_MF4_M1_MASK,
          4992 => Opcode::PseudoVLOXSEG7EI8_V_MF4_MF2,
          4993 => Opcode::PseudoVLOXSEG7EI8_V_MF4_MF2_MASK,
          4994 => Opcode::PseudoVLOXSEG7EI8_V_MF4_MF4,
          4995 => Opcode::PseudoVLOXSEG7EI8_V_MF4_MF4_MASK,
          4996 => Opcode::PseudoVLOXSEG7EI8_V_MF8_M1,
          4997 => Opcode::PseudoVLOXSEG7EI8_V_MF8_M1_MASK,
          4998 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF2,
          4999 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF2_MASK,
          5000 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF4,
          5001 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF4_MASK,
          5002 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF8,
          5003 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF8_MASK,
          5004 => Opcode::PseudoVLOXSEG8EI16_V_M1_M1,
          5005 => Opcode::PseudoVLOXSEG8EI16_V_M1_M1_MASK,
          5006 => Opcode::PseudoVLOXSEG8EI16_V_M1_MF2,
          5007 => Opcode::PseudoVLOXSEG8EI16_V_M1_MF2_MASK,
          5008 => Opcode::PseudoVLOXSEG8EI16_V_M2_M1,
          5009 => Opcode::PseudoVLOXSEG8EI16_V_M2_M1_MASK,
          5010 => Opcode::PseudoVLOXSEG8EI16_V_MF2_M1,
          5011 => Opcode::PseudoVLOXSEG8EI16_V_MF2_M1_MASK,
          5012 => Opcode::PseudoVLOXSEG8EI16_V_MF2_MF2,
          5013 => Opcode::PseudoVLOXSEG8EI16_V_MF2_MF2_MASK,
          5014 => Opcode::PseudoVLOXSEG8EI16_V_MF2_MF4,
          5015 => Opcode::PseudoVLOXSEG8EI16_V_MF2_MF4_MASK,
          5016 => Opcode::PseudoVLOXSEG8EI16_V_MF4_M1,
          5017 => Opcode::PseudoVLOXSEG8EI16_V_MF4_M1_MASK,
          5018 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF2,
          5019 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF2_MASK,
          5020 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF4,
          5021 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF4_MASK,
          5022 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF8,
          5023 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF8_MASK,
          5024 => Opcode::PseudoVLOXSEG8EI32_V_M1_M1,
          5025 => Opcode::PseudoVLOXSEG8EI32_V_M1_M1_MASK,
          5026 => Opcode::PseudoVLOXSEG8EI32_V_M1_MF2,
          5027 => Opcode::PseudoVLOXSEG8EI32_V_M1_MF2_MASK,
          5028 => Opcode::PseudoVLOXSEG8EI32_V_M1_MF4,
          5029 => Opcode::PseudoVLOXSEG8EI32_V_M1_MF4_MASK,
          5030 => Opcode::PseudoVLOXSEG8EI32_V_M2_M1,
          5031 => Opcode::PseudoVLOXSEG8EI32_V_M2_M1_MASK,
          5032 => Opcode::PseudoVLOXSEG8EI32_V_M2_MF2,
          5033 => Opcode::PseudoVLOXSEG8EI32_V_M2_MF2_MASK,
          5034 => Opcode::PseudoVLOXSEG8EI32_V_M4_M1,
          5035 => Opcode::PseudoVLOXSEG8EI32_V_M4_M1_MASK,
          5036 => Opcode::PseudoVLOXSEG8EI32_V_MF2_M1,
          5037 => Opcode::PseudoVLOXSEG8EI32_V_MF2_M1_MASK,
          5038 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF2,
          5039 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF2_MASK,
          5040 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF4,
          5041 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF4_MASK,
          5042 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF8,
          5043 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF8_MASK,
          5044 => Opcode::PseudoVLOXSEG8EI64_V_M1_M1,
          5045 => Opcode::PseudoVLOXSEG8EI64_V_M1_M1_MASK,
          5046 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF2,
          5047 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF2_MASK,
          5048 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF4,
          5049 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF4_MASK,
          5050 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF8,
          5051 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF8_MASK,
          5052 => Opcode::PseudoVLOXSEG8EI64_V_M2_M1,
          5053 => Opcode::PseudoVLOXSEG8EI64_V_M2_M1_MASK,
          5054 => Opcode::PseudoVLOXSEG8EI64_V_M2_MF2,
          5055 => Opcode::PseudoVLOXSEG8EI64_V_M2_MF2_MASK,
          5056 => Opcode::PseudoVLOXSEG8EI64_V_M2_MF4,
          5057 => Opcode::PseudoVLOXSEG8EI64_V_M2_MF4_MASK,
          5058 => Opcode::PseudoVLOXSEG8EI64_V_M4_M1,
          5059 => Opcode::PseudoVLOXSEG8EI64_V_M4_M1_MASK,
          5060 => Opcode::PseudoVLOXSEG8EI64_V_M4_MF2,
          5061 => Opcode::PseudoVLOXSEG8EI64_V_M4_MF2_MASK,
          5062 => Opcode::PseudoVLOXSEG8EI64_V_M8_M1,
          5063 => Opcode::PseudoVLOXSEG8EI64_V_M8_M1_MASK,
          5064 => Opcode::PseudoVLOXSEG8EI8_V_M1_M1,
          5065 => Opcode::PseudoVLOXSEG8EI8_V_M1_M1_MASK,
          5066 => Opcode::PseudoVLOXSEG8EI8_V_MF2_M1,
          5067 => Opcode::PseudoVLOXSEG8EI8_V_MF2_M1_MASK,
          5068 => Opcode::PseudoVLOXSEG8EI8_V_MF2_MF2,
          5069 => Opcode::PseudoVLOXSEG8EI8_V_MF2_MF2_MASK,
          5070 => Opcode::PseudoVLOXSEG8EI8_V_MF4_M1,
          5071 => Opcode::PseudoVLOXSEG8EI8_V_MF4_M1_MASK,
          5072 => Opcode::PseudoVLOXSEG8EI8_V_MF4_MF2,
          5073 => Opcode::PseudoVLOXSEG8EI8_V_MF4_MF2_MASK,
          5074 => Opcode::PseudoVLOXSEG8EI8_V_MF4_MF4,
          5075 => Opcode::PseudoVLOXSEG8EI8_V_MF4_MF4_MASK,
          5076 => Opcode::PseudoVLOXSEG8EI8_V_MF8_M1,
          5077 => Opcode::PseudoVLOXSEG8EI8_V_MF8_M1_MASK,
          5078 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF2,
          5079 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF2_MASK,
          5080 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF4,
          5081 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF4_MASK,
          5082 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF8,
          5083 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF8_MASK,
          5084 => Opcode::PseudoVLSE16_V_M1,
          5085 => Opcode::PseudoVLSE16_V_M1_MASK,
          5086 => Opcode::PseudoVLSE16_V_M2,
          5087 => Opcode::PseudoVLSE16_V_M2_MASK,
          5088 => Opcode::PseudoVLSE16_V_M4,
          5089 => Opcode::PseudoVLSE16_V_M4_MASK,
          5090 => Opcode::PseudoVLSE16_V_M8,
          5091 => Opcode::PseudoVLSE16_V_M8_MASK,
          5092 => Opcode::PseudoVLSE16_V_MF2,
          5093 => Opcode::PseudoVLSE16_V_MF2_MASK,
          5094 => Opcode::PseudoVLSE16_V_MF4,
          5095 => Opcode::PseudoVLSE16_V_MF4_MASK,
          5096 => Opcode::PseudoVLSE32_V_M1,
          5097 => Opcode::PseudoVLSE32_V_M1_MASK,
          5098 => Opcode::PseudoVLSE32_V_M2,
          5099 => Opcode::PseudoVLSE32_V_M2_MASK,
          5100 => Opcode::PseudoVLSE32_V_M4,
          5101 => Opcode::PseudoVLSE32_V_M4_MASK,
          5102 => Opcode::PseudoVLSE32_V_M8,
          5103 => Opcode::PseudoVLSE32_V_M8_MASK,
          5104 => Opcode::PseudoVLSE32_V_MF2,
          5105 => Opcode::PseudoVLSE32_V_MF2_MASK,
          5106 => Opcode::PseudoVLSE64_V_M1,
          5107 => Opcode::PseudoVLSE64_V_M1_MASK,
          5108 => Opcode::PseudoVLSE64_V_M2,
          5109 => Opcode::PseudoVLSE64_V_M2_MASK,
          5110 => Opcode::PseudoVLSE64_V_M4,
          5111 => Opcode::PseudoVLSE64_V_M4_MASK,
          5112 => Opcode::PseudoVLSE64_V_M8,
          5113 => Opcode::PseudoVLSE64_V_M8_MASK,
          5114 => Opcode::PseudoVLSE8_V_M1,
          5115 => Opcode::PseudoVLSE8_V_M1_MASK,
          5116 => Opcode::PseudoVLSE8_V_M2,
          5117 => Opcode::PseudoVLSE8_V_M2_MASK,
          5118 => Opcode::PseudoVLSE8_V_M4,
          5119 => Opcode::PseudoVLSE8_V_M4_MASK,
          5120 => Opcode::PseudoVLSE8_V_M8,
          5121 => Opcode::PseudoVLSE8_V_M8_MASK,
          5122 => Opcode::PseudoVLSE8_V_MF2,
          5123 => Opcode::PseudoVLSE8_V_MF2_MASK,
          5124 => Opcode::PseudoVLSE8_V_MF4,
          5125 => Opcode::PseudoVLSE8_V_MF4_MASK,
          5126 => Opcode::PseudoVLSE8_V_MF8,
          5127 => Opcode::PseudoVLSE8_V_MF8_MASK,
          5128 => Opcode::PseudoVLSEG2E16FF_V_M1,
          5129 => Opcode::PseudoVLSEG2E16FF_V_M1_MASK,
          5130 => Opcode::PseudoVLSEG2E16FF_V_M2,
          5131 => Opcode::PseudoVLSEG2E16FF_V_M2_MASK,
          5132 => Opcode::PseudoVLSEG2E16FF_V_M4,
          5133 => Opcode::PseudoVLSEG2E16FF_V_M4_MASK,
          5134 => Opcode::PseudoVLSEG2E16FF_V_MF2,
          5135 => Opcode::PseudoVLSEG2E16FF_V_MF2_MASK,
          5136 => Opcode::PseudoVLSEG2E16FF_V_MF4,
          5137 => Opcode::PseudoVLSEG2E16FF_V_MF4_MASK,
          5138 => Opcode::PseudoVLSEG2E16_V_M1,
          5139 => Opcode::PseudoVLSEG2E16_V_M1_MASK,
          5140 => Opcode::PseudoVLSEG2E16_V_M2,
          5141 => Opcode::PseudoVLSEG2E16_V_M2_MASK,
          5142 => Opcode::PseudoVLSEG2E16_V_M4,
          5143 => Opcode::PseudoVLSEG2E16_V_M4_MASK,
          5144 => Opcode::PseudoVLSEG2E16_V_MF2,
          5145 => Opcode::PseudoVLSEG2E16_V_MF2_MASK,
          5146 => Opcode::PseudoVLSEG2E16_V_MF4,
          5147 => Opcode::PseudoVLSEG2E16_V_MF4_MASK,
          5148 => Opcode::PseudoVLSEG2E32FF_V_M1,
          5149 => Opcode::PseudoVLSEG2E32FF_V_M1_MASK,
          5150 => Opcode::PseudoVLSEG2E32FF_V_M2,
          5151 => Opcode::PseudoVLSEG2E32FF_V_M2_MASK,
          5152 => Opcode::PseudoVLSEG2E32FF_V_M4,
          5153 => Opcode::PseudoVLSEG2E32FF_V_M4_MASK,
          5154 => Opcode::PseudoVLSEG2E32FF_V_MF2,
          5155 => Opcode::PseudoVLSEG2E32FF_V_MF2_MASK,
          5156 => Opcode::PseudoVLSEG2E32_V_M1,
          5157 => Opcode::PseudoVLSEG2E32_V_M1_MASK,
          5158 => Opcode::PseudoVLSEG2E32_V_M2,
          5159 => Opcode::PseudoVLSEG2E32_V_M2_MASK,
          5160 => Opcode::PseudoVLSEG2E32_V_M4,
          5161 => Opcode::PseudoVLSEG2E32_V_M4_MASK,
          5162 => Opcode::PseudoVLSEG2E32_V_MF2,
          5163 => Opcode::PseudoVLSEG2E32_V_MF2_MASK,
          5164 => Opcode::PseudoVLSEG2E64FF_V_M1,
          5165 => Opcode::PseudoVLSEG2E64FF_V_M1_MASK,
          5166 => Opcode::PseudoVLSEG2E64FF_V_M2,
          5167 => Opcode::PseudoVLSEG2E64FF_V_M2_MASK,
          5168 => Opcode::PseudoVLSEG2E64FF_V_M4,
          5169 => Opcode::PseudoVLSEG2E64FF_V_M4_MASK,
          5170 => Opcode::PseudoVLSEG2E64_V_M1,
          5171 => Opcode::PseudoVLSEG2E64_V_M1_MASK,
          5172 => Opcode::PseudoVLSEG2E64_V_M2,
          5173 => Opcode::PseudoVLSEG2E64_V_M2_MASK,
          5174 => Opcode::PseudoVLSEG2E64_V_M4,
          5175 => Opcode::PseudoVLSEG2E64_V_M4_MASK,
          5176 => Opcode::PseudoVLSEG2E8FF_V_M1,
          5177 => Opcode::PseudoVLSEG2E8FF_V_M1_MASK,
          5178 => Opcode::PseudoVLSEG2E8FF_V_M2,
          5179 => Opcode::PseudoVLSEG2E8FF_V_M2_MASK,
          5180 => Opcode::PseudoVLSEG2E8FF_V_M4,
          5181 => Opcode::PseudoVLSEG2E8FF_V_M4_MASK,
          5182 => Opcode::PseudoVLSEG2E8FF_V_MF2,
          5183 => Opcode::PseudoVLSEG2E8FF_V_MF2_MASK,
          5184 => Opcode::PseudoVLSEG2E8FF_V_MF4,
          5185 => Opcode::PseudoVLSEG2E8FF_V_MF4_MASK,
          5186 => Opcode::PseudoVLSEG2E8FF_V_MF8,
          5187 => Opcode::PseudoVLSEG2E8FF_V_MF8_MASK,
          5188 => Opcode::PseudoVLSEG2E8_V_M1,
          5189 => Opcode::PseudoVLSEG2E8_V_M1_MASK,
          5190 => Opcode::PseudoVLSEG2E8_V_M2,
          5191 => Opcode::PseudoVLSEG2E8_V_M2_MASK,
          5192 => Opcode::PseudoVLSEG2E8_V_M4,
          5193 => Opcode::PseudoVLSEG2E8_V_M4_MASK,
          5194 => Opcode::PseudoVLSEG2E8_V_MF2,
          5195 => Opcode::PseudoVLSEG2E8_V_MF2_MASK,
          5196 => Opcode::PseudoVLSEG2E8_V_MF4,
          5197 => Opcode::PseudoVLSEG2E8_V_MF4_MASK,
          5198 => Opcode::PseudoVLSEG2E8_V_MF8,
          5199 => Opcode::PseudoVLSEG2E8_V_MF8_MASK,
          5200 => Opcode::PseudoVLSEG3E16FF_V_M1,
          5201 => Opcode::PseudoVLSEG3E16FF_V_M1_MASK,
          5202 => Opcode::PseudoVLSEG3E16FF_V_M2,
          5203 => Opcode::PseudoVLSEG3E16FF_V_M2_MASK,
          5204 => Opcode::PseudoVLSEG3E16FF_V_MF2,
          5205 => Opcode::PseudoVLSEG3E16FF_V_MF2_MASK,
          5206 => Opcode::PseudoVLSEG3E16FF_V_MF4,
          5207 => Opcode::PseudoVLSEG3E16FF_V_MF4_MASK,
          5208 => Opcode::PseudoVLSEG3E16_V_M1,
          5209 => Opcode::PseudoVLSEG3E16_V_M1_MASK,
          5210 => Opcode::PseudoVLSEG3E16_V_M2,
          5211 => Opcode::PseudoVLSEG3E16_V_M2_MASK,
          5212 => Opcode::PseudoVLSEG3E16_V_MF2,
          5213 => Opcode::PseudoVLSEG3E16_V_MF2_MASK,
          5214 => Opcode::PseudoVLSEG3E16_V_MF4,
          5215 => Opcode::PseudoVLSEG3E16_V_MF4_MASK,
          5216 => Opcode::PseudoVLSEG3E32FF_V_M1,
          5217 => Opcode::PseudoVLSEG3E32FF_V_M1_MASK,
          5218 => Opcode::PseudoVLSEG3E32FF_V_M2,
          5219 => Opcode::PseudoVLSEG3E32FF_V_M2_MASK,
          5220 => Opcode::PseudoVLSEG3E32FF_V_MF2,
          5221 => Opcode::PseudoVLSEG3E32FF_V_MF2_MASK,
          5222 => Opcode::PseudoVLSEG3E32_V_M1,
          5223 => Opcode::PseudoVLSEG3E32_V_M1_MASK,
          5224 => Opcode::PseudoVLSEG3E32_V_M2,
          5225 => Opcode::PseudoVLSEG3E32_V_M2_MASK,
          5226 => Opcode::PseudoVLSEG3E32_V_MF2,
          5227 => Opcode::PseudoVLSEG3E32_V_MF2_MASK,
          5228 => Opcode::PseudoVLSEG3E64FF_V_M1,
          5229 => Opcode::PseudoVLSEG3E64FF_V_M1_MASK,
          5230 => Opcode::PseudoVLSEG3E64FF_V_M2,
          5231 => Opcode::PseudoVLSEG3E64FF_V_M2_MASK,
          5232 => Opcode::PseudoVLSEG3E64_V_M1,
          5233 => Opcode::PseudoVLSEG3E64_V_M1_MASK,
          5234 => Opcode::PseudoVLSEG3E64_V_M2,
          5235 => Opcode::PseudoVLSEG3E64_V_M2_MASK,
          5236 => Opcode::PseudoVLSEG3E8FF_V_M1,
          5237 => Opcode::PseudoVLSEG3E8FF_V_M1_MASK,
          5238 => Opcode::PseudoVLSEG3E8FF_V_M2,
          5239 => Opcode::PseudoVLSEG3E8FF_V_M2_MASK,
          5240 => Opcode::PseudoVLSEG3E8FF_V_MF2,
          5241 => Opcode::PseudoVLSEG3E8FF_V_MF2_MASK,
          5242 => Opcode::PseudoVLSEG3E8FF_V_MF4,
          5243 => Opcode::PseudoVLSEG3E8FF_V_MF4_MASK,
          5244 => Opcode::PseudoVLSEG3E8FF_V_MF8,
          5245 => Opcode::PseudoVLSEG3E8FF_V_MF8_MASK,
          5246 => Opcode::PseudoVLSEG3E8_V_M1,
          5247 => Opcode::PseudoVLSEG3E8_V_M1_MASK,
          5248 => Opcode::PseudoVLSEG3E8_V_M2,
          5249 => Opcode::PseudoVLSEG3E8_V_M2_MASK,
          5250 => Opcode::PseudoVLSEG3E8_V_MF2,
          5251 => Opcode::PseudoVLSEG3E8_V_MF2_MASK,
          5252 => Opcode::PseudoVLSEG3E8_V_MF4,
          5253 => Opcode::PseudoVLSEG3E8_V_MF4_MASK,
          5254 => Opcode::PseudoVLSEG3E8_V_MF8,
          5255 => Opcode::PseudoVLSEG3E8_V_MF8_MASK,
          5256 => Opcode::PseudoVLSEG4E16FF_V_M1,
          5257 => Opcode::PseudoVLSEG4E16FF_V_M1_MASK,
          5258 => Opcode::PseudoVLSEG4E16FF_V_M2,
          5259 => Opcode::PseudoVLSEG4E16FF_V_M2_MASK,
          5260 => Opcode::PseudoVLSEG4E16FF_V_MF2,
          5261 => Opcode::PseudoVLSEG4E16FF_V_MF2_MASK,
          5262 => Opcode::PseudoVLSEG4E16FF_V_MF4,
          5263 => Opcode::PseudoVLSEG4E16FF_V_MF4_MASK,
          5264 => Opcode::PseudoVLSEG4E16_V_M1,
          5265 => Opcode::PseudoVLSEG4E16_V_M1_MASK,
          5266 => Opcode::PseudoVLSEG4E16_V_M2,
          5267 => Opcode::PseudoVLSEG4E16_V_M2_MASK,
          5268 => Opcode::PseudoVLSEG4E16_V_MF2,
          5269 => Opcode::PseudoVLSEG4E16_V_MF2_MASK,
          5270 => Opcode::PseudoVLSEG4E16_V_MF4,
          5271 => Opcode::PseudoVLSEG4E16_V_MF4_MASK,
          5272 => Opcode::PseudoVLSEG4E32FF_V_M1,
          5273 => Opcode::PseudoVLSEG4E32FF_V_M1_MASK,
          5274 => Opcode::PseudoVLSEG4E32FF_V_M2,
          5275 => Opcode::PseudoVLSEG4E32FF_V_M2_MASK,
          5276 => Opcode::PseudoVLSEG4E32FF_V_MF2,
          5277 => Opcode::PseudoVLSEG4E32FF_V_MF2_MASK,
          5278 => Opcode::PseudoVLSEG4E32_V_M1,
          5279 => Opcode::PseudoVLSEG4E32_V_M1_MASK,
          5280 => Opcode::PseudoVLSEG4E32_V_M2,
          5281 => Opcode::PseudoVLSEG4E32_V_M2_MASK,
          5282 => Opcode::PseudoVLSEG4E32_V_MF2,
          5283 => Opcode::PseudoVLSEG4E32_V_MF2_MASK,
          5284 => Opcode::PseudoVLSEG4E64FF_V_M1,
          5285 => Opcode::PseudoVLSEG4E64FF_V_M1_MASK,
          5286 => Opcode::PseudoVLSEG4E64FF_V_M2,
          5287 => Opcode::PseudoVLSEG4E64FF_V_M2_MASK,
          5288 => Opcode::PseudoVLSEG4E64_V_M1,
          5289 => Opcode::PseudoVLSEG4E64_V_M1_MASK,
          5290 => Opcode::PseudoVLSEG4E64_V_M2,
          5291 => Opcode::PseudoVLSEG4E64_V_M2_MASK,
          5292 => Opcode::PseudoVLSEG4E8FF_V_M1,
          5293 => Opcode::PseudoVLSEG4E8FF_V_M1_MASK,
          5294 => Opcode::PseudoVLSEG4E8FF_V_M2,
          5295 => Opcode::PseudoVLSEG4E8FF_V_M2_MASK,
          5296 => Opcode::PseudoVLSEG4E8FF_V_MF2,
          5297 => Opcode::PseudoVLSEG4E8FF_V_MF2_MASK,
          5298 => Opcode::PseudoVLSEG4E8FF_V_MF4,
          5299 => Opcode::PseudoVLSEG4E8FF_V_MF4_MASK,
          5300 => Opcode::PseudoVLSEG4E8FF_V_MF8,
          5301 => Opcode::PseudoVLSEG4E8FF_V_MF8_MASK,
          5302 => Opcode::PseudoVLSEG4E8_V_M1,
          5303 => Opcode::PseudoVLSEG4E8_V_M1_MASK,
          5304 => Opcode::PseudoVLSEG4E8_V_M2,
          5305 => Opcode::PseudoVLSEG4E8_V_M2_MASK,
          5306 => Opcode::PseudoVLSEG4E8_V_MF2,
          5307 => Opcode::PseudoVLSEG4E8_V_MF2_MASK,
          5308 => Opcode::PseudoVLSEG4E8_V_MF4,
          5309 => Opcode::PseudoVLSEG4E8_V_MF4_MASK,
          5310 => Opcode::PseudoVLSEG4E8_V_MF8,
          5311 => Opcode::PseudoVLSEG4E8_V_MF8_MASK,
          5312 => Opcode::PseudoVLSEG5E16FF_V_M1,
          5313 => Opcode::PseudoVLSEG5E16FF_V_M1_MASK,
          5314 => Opcode::PseudoVLSEG5E16FF_V_MF2,
          5315 => Opcode::PseudoVLSEG5E16FF_V_MF2_MASK,
          5316 => Opcode::PseudoVLSEG5E16FF_V_MF4,
          5317 => Opcode::PseudoVLSEG5E16FF_V_MF4_MASK,
          5318 => Opcode::PseudoVLSEG5E16_V_M1,
          5319 => Opcode::PseudoVLSEG5E16_V_M1_MASK,
          5320 => Opcode::PseudoVLSEG5E16_V_MF2,
          5321 => Opcode::PseudoVLSEG5E16_V_MF2_MASK,
          5322 => Opcode::PseudoVLSEG5E16_V_MF4,
          5323 => Opcode::PseudoVLSEG5E16_V_MF4_MASK,
          5324 => Opcode::PseudoVLSEG5E32FF_V_M1,
          5325 => Opcode::PseudoVLSEG5E32FF_V_M1_MASK,
          5326 => Opcode::PseudoVLSEG5E32FF_V_MF2,
          5327 => Opcode::PseudoVLSEG5E32FF_V_MF2_MASK,
          5328 => Opcode::PseudoVLSEG5E32_V_M1,
          5329 => Opcode::PseudoVLSEG5E32_V_M1_MASK,
          5330 => Opcode::PseudoVLSEG5E32_V_MF2,
          5331 => Opcode::PseudoVLSEG5E32_V_MF2_MASK,
          5332 => Opcode::PseudoVLSEG5E64FF_V_M1,
          5333 => Opcode::PseudoVLSEG5E64FF_V_M1_MASK,
          5334 => Opcode::PseudoVLSEG5E64_V_M1,
          5335 => Opcode::PseudoVLSEG5E64_V_M1_MASK,
          5336 => Opcode::PseudoVLSEG5E8FF_V_M1,
          5337 => Opcode::PseudoVLSEG5E8FF_V_M1_MASK,
          5338 => Opcode::PseudoVLSEG5E8FF_V_MF2,
          5339 => Opcode::PseudoVLSEG5E8FF_V_MF2_MASK,
          5340 => Opcode::PseudoVLSEG5E8FF_V_MF4,
          5341 => Opcode::PseudoVLSEG5E8FF_V_MF4_MASK,
          5342 => Opcode::PseudoVLSEG5E8FF_V_MF8,
          5343 => Opcode::PseudoVLSEG5E8FF_V_MF8_MASK,
          5344 => Opcode::PseudoVLSEG5E8_V_M1,
          5345 => Opcode::PseudoVLSEG5E8_V_M1_MASK,
          5346 => Opcode::PseudoVLSEG5E8_V_MF2,
          5347 => Opcode::PseudoVLSEG5E8_V_MF2_MASK,
          5348 => Opcode::PseudoVLSEG5E8_V_MF4,
          5349 => Opcode::PseudoVLSEG5E8_V_MF4_MASK,
          5350 => Opcode::PseudoVLSEG5E8_V_MF8,
          5351 => Opcode::PseudoVLSEG5E8_V_MF8_MASK,
          5352 => Opcode::PseudoVLSEG6E16FF_V_M1,
          5353 => Opcode::PseudoVLSEG6E16FF_V_M1_MASK,
          5354 => Opcode::PseudoVLSEG6E16FF_V_MF2,
          5355 => Opcode::PseudoVLSEG6E16FF_V_MF2_MASK,
          5356 => Opcode::PseudoVLSEG6E16FF_V_MF4,
          5357 => Opcode::PseudoVLSEG6E16FF_V_MF4_MASK,
          5358 => Opcode::PseudoVLSEG6E16_V_M1,
          5359 => Opcode::PseudoVLSEG6E16_V_M1_MASK,
          5360 => Opcode::PseudoVLSEG6E16_V_MF2,
          5361 => Opcode::PseudoVLSEG6E16_V_MF2_MASK,
          5362 => Opcode::PseudoVLSEG6E16_V_MF4,
          5363 => Opcode::PseudoVLSEG6E16_V_MF4_MASK,
          5364 => Opcode::PseudoVLSEG6E32FF_V_M1,
          5365 => Opcode::PseudoVLSEG6E32FF_V_M1_MASK,
          5366 => Opcode::PseudoVLSEG6E32FF_V_MF2,
          5367 => Opcode::PseudoVLSEG6E32FF_V_MF2_MASK,
          5368 => Opcode::PseudoVLSEG6E32_V_M1,
          5369 => Opcode::PseudoVLSEG6E32_V_M1_MASK,
          5370 => Opcode::PseudoVLSEG6E32_V_MF2,
          5371 => Opcode::PseudoVLSEG6E32_V_MF2_MASK,
          5372 => Opcode::PseudoVLSEG6E64FF_V_M1,
          5373 => Opcode::PseudoVLSEG6E64FF_V_M1_MASK,
          5374 => Opcode::PseudoVLSEG6E64_V_M1,
          5375 => Opcode::PseudoVLSEG6E64_V_M1_MASK,
          5376 => Opcode::PseudoVLSEG6E8FF_V_M1,
          5377 => Opcode::PseudoVLSEG6E8FF_V_M1_MASK,
          5378 => Opcode::PseudoVLSEG6E8FF_V_MF2,
          5379 => Opcode::PseudoVLSEG6E8FF_V_MF2_MASK,
          5380 => Opcode::PseudoVLSEG6E8FF_V_MF4,
          5381 => Opcode::PseudoVLSEG6E8FF_V_MF4_MASK,
          5382 => Opcode::PseudoVLSEG6E8FF_V_MF8,
          5383 => Opcode::PseudoVLSEG6E8FF_V_MF8_MASK,
          5384 => Opcode::PseudoVLSEG6E8_V_M1,
          5385 => Opcode::PseudoVLSEG6E8_V_M1_MASK,
          5386 => Opcode::PseudoVLSEG6E8_V_MF2,
          5387 => Opcode::PseudoVLSEG6E8_V_MF2_MASK,
          5388 => Opcode::PseudoVLSEG6E8_V_MF4,
          5389 => Opcode::PseudoVLSEG6E8_V_MF4_MASK,
          5390 => Opcode::PseudoVLSEG6E8_V_MF8,
          5391 => Opcode::PseudoVLSEG6E8_V_MF8_MASK,
          5392 => Opcode::PseudoVLSEG7E16FF_V_M1,
          5393 => Opcode::PseudoVLSEG7E16FF_V_M1_MASK,
          5394 => Opcode::PseudoVLSEG7E16FF_V_MF2,
          5395 => Opcode::PseudoVLSEG7E16FF_V_MF2_MASK,
          5396 => Opcode::PseudoVLSEG7E16FF_V_MF4,
          5397 => Opcode::PseudoVLSEG7E16FF_V_MF4_MASK,
          5398 => Opcode::PseudoVLSEG7E16_V_M1,
          5399 => Opcode::PseudoVLSEG7E16_V_M1_MASK,
          5400 => Opcode::PseudoVLSEG7E16_V_MF2,
          5401 => Opcode::PseudoVLSEG7E16_V_MF2_MASK,
          5402 => Opcode::PseudoVLSEG7E16_V_MF4,
          5403 => Opcode::PseudoVLSEG7E16_V_MF4_MASK,
          5404 => Opcode::PseudoVLSEG7E32FF_V_M1,
          5405 => Opcode::PseudoVLSEG7E32FF_V_M1_MASK,
          5406 => Opcode::PseudoVLSEG7E32FF_V_MF2,
          5407 => Opcode::PseudoVLSEG7E32FF_V_MF2_MASK,
          5408 => Opcode::PseudoVLSEG7E32_V_M1,
          5409 => Opcode::PseudoVLSEG7E32_V_M1_MASK,
          5410 => Opcode::PseudoVLSEG7E32_V_MF2,
          5411 => Opcode::PseudoVLSEG7E32_V_MF2_MASK,
          5412 => Opcode::PseudoVLSEG7E64FF_V_M1,
          5413 => Opcode::PseudoVLSEG7E64FF_V_M1_MASK,
          5414 => Opcode::PseudoVLSEG7E64_V_M1,
          5415 => Opcode::PseudoVLSEG7E64_V_M1_MASK,
          5416 => Opcode::PseudoVLSEG7E8FF_V_M1,
          5417 => Opcode::PseudoVLSEG7E8FF_V_M1_MASK,
          5418 => Opcode::PseudoVLSEG7E8FF_V_MF2,
          5419 => Opcode::PseudoVLSEG7E8FF_V_MF2_MASK,
          5420 => Opcode::PseudoVLSEG7E8FF_V_MF4,
          5421 => Opcode::PseudoVLSEG7E8FF_V_MF4_MASK,
          5422 => Opcode::PseudoVLSEG7E8FF_V_MF8,
          5423 => Opcode::PseudoVLSEG7E8FF_V_MF8_MASK,
          5424 => Opcode::PseudoVLSEG7E8_V_M1,
          5425 => Opcode::PseudoVLSEG7E8_V_M1_MASK,
          5426 => Opcode::PseudoVLSEG7E8_V_MF2,
          5427 => Opcode::PseudoVLSEG7E8_V_MF2_MASK,
          5428 => Opcode::PseudoVLSEG7E8_V_MF4,
          5429 => Opcode::PseudoVLSEG7E8_V_MF4_MASK,
          5430 => Opcode::PseudoVLSEG7E8_V_MF8,
          5431 => Opcode::PseudoVLSEG7E8_V_MF8_MASK,
          5432 => Opcode::PseudoVLSEG8E16FF_V_M1,
          5433 => Opcode::PseudoVLSEG8E16FF_V_M1_MASK,
          5434 => Opcode::PseudoVLSEG8E16FF_V_MF2,
          5435 => Opcode::PseudoVLSEG8E16FF_V_MF2_MASK,
          5436 => Opcode::PseudoVLSEG8E16FF_V_MF4,
          5437 => Opcode::PseudoVLSEG8E16FF_V_MF4_MASK,
          5438 => Opcode::PseudoVLSEG8E16_V_M1,
          5439 => Opcode::PseudoVLSEG8E16_V_M1_MASK,
          5440 => Opcode::PseudoVLSEG8E16_V_MF2,
          5441 => Opcode::PseudoVLSEG8E16_V_MF2_MASK,
          5442 => Opcode::PseudoVLSEG8E16_V_MF4,
          5443 => Opcode::PseudoVLSEG8E16_V_MF4_MASK,
          5444 => Opcode::PseudoVLSEG8E32FF_V_M1,
          5445 => Opcode::PseudoVLSEG8E32FF_V_M1_MASK,
          5446 => Opcode::PseudoVLSEG8E32FF_V_MF2,
          5447 => Opcode::PseudoVLSEG8E32FF_V_MF2_MASK,
          5448 => Opcode::PseudoVLSEG8E32_V_M1,
          5449 => Opcode::PseudoVLSEG8E32_V_M1_MASK,
          5450 => Opcode::PseudoVLSEG8E32_V_MF2,
          5451 => Opcode::PseudoVLSEG8E32_V_MF2_MASK,
          5452 => Opcode::PseudoVLSEG8E64FF_V_M1,
          5453 => Opcode::PseudoVLSEG8E64FF_V_M1_MASK,
          5454 => Opcode::PseudoVLSEG8E64_V_M1,
          5455 => Opcode::PseudoVLSEG8E64_V_M1_MASK,
          5456 => Opcode::PseudoVLSEG8E8FF_V_M1,
          5457 => Opcode::PseudoVLSEG8E8FF_V_M1_MASK,
          5458 => Opcode::PseudoVLSEG8E8FF_V_MF2,
          5459 => Opcode::PseudoVLSEG8E8FF_V_MF2_MASK,
          5460 => Opcode::PseudoVLSEG8E8FF_V_MF4,
          5461 => Opcode::PseudoVLSEG8E8FF_V_MF4_MASK,
          5462 => Opcode::PseudoVLSEG8E8FF_V_MF8,
          5463 => Opcode::PseudoVLSEG8E8FF_V_MF8_MASK,
          5464 => Opcode::PseudoVLSEG8E8_V_M1,
          5465 => Opcode::PseudoVLSEG8E8_V_M1_MASK,
          5466 => Opcode::PseudoVLSEG8E8_V_MF2,
          5467 => Opcode::PseudoVLSEG8E8_V_MF2_MASK,
          5468 => Opcode::PseudoVLSEG8E8_V_MF4,
          5469 => Opcode::PseudoVLSEG8E8_V_MF4_MASK,
          5470 => Opcode::PseudoVLSEG8E8_V_MF8,
          5471 => Opcode::PseudoVLSEG8E8_V_MF8_MASK,
          5472 => Opcode::PseudoVLSSEG2E16_V_M1,
          5473 => Opcode::PseudoVLSSEG2E16_V_M1_MASK,
          5474 => Opcode::PseudoVLSSEG2E16_V_M2,
          5475 => Opcode::PseudoVLSSEG2E16_V_M2_MASK,
          5476 => Opcode::PseudoVLSSEG2E16_V_M4,
          5477 => Opcode::PseudoVLSSEG2E16_V_M4_MASK,
          5478 => Opcode::PseudoVLSSEG2E16_V_MF2,
          5479 => Opcode::PseudoVLSSEG2E16_V_MF2_MASK,
          5480 => Opcode::PseudoVLSSEG2E16_V_MF4,
          5481 => Opcode::PseudoVLSSEG2E16_V_MF4_MASK,
          5482 => Opcode::PseudoVLSSEG2E32_V_M1,
          5483 => Opcode::PseudoVLSSEG2E32_V_M1_MASK,
          5484 => Opcode::PseudoVLSSEG2E32_V_M2,
          5485 => Opcode::PseudoVLSSEG2E32_V_M2_MASK,
          5486 => Opcode::PseudoVLSSEG2E32_V_M4,
          5487 => Opcode::PseudoVLSSEG2E32_V_M4_MASK,
          5488 => Opcode::PseudoVLSSEG2E32_V_MF2,
          5489 => Opcode::PseudoVLSSEG2E32_V_MF2_MASK,
          5490 => Opcode::PseudoVLSSEG2E64_V_M1,
          5491 => Opcode::PseudoVLSSEG2E64_V_M1_MASK,
          5492 => Opcode::PseudoVLSSEG2E64_V_M2,
          5493 => Opcode::PseudoVLSSEG2E64_V_M2_MASK,
          5494 => Opcode::PseudoVLSSEG2E64_V_M4,
          5495 => Opcode::PseudoVLSSEG2E64_V_M4_MASK,
          5496 => Opcode::PseudoVLSSEG2E8_V_M1,
          5497 => Opcode::PseudoVLSSEG2E8_V_M1_MASK,
          5498 => Opcode::PseudoVLSSEG2E8_V_M2,
          5499 => Opcode::PseudoVLSSEG2E8_V_M2_MASK,
          5500 => Opcode::PseudoVLSSEG2E8_V_M4,
          5501 => Opcode::PseudoVLSSEG2E8_V_M4_MASK,
          5502 => Opcode::PseudoVLSSEG2E8_V_MF2,
          5503 => Opcode::PseudoVLSSEG2E8_V_MF2_MASK,
          5504 => Opcode::PseudoVLSSEG2E8_V_MF4,
          5505 => Opcode::PseudoVLSSEG2E8_V_MF4_MASK,
          5506 => Opcode::PseudoVLSSEG2E8_V_MF8,
          5507 => Opcode::PseudoVLSSEG2E8_V_MF8_MASK,
          5508 => Opcode::PseudoVLSSEG3E16_V_M1,
          5509 => Opcode::PseudoVLSSEG3E16_V_M1_MASK,
          5510 => Opcode::PseudoVLSSEG3E16_V_M2,
          5511 => Opcode::PseudoVLSSEG3E16_V_M2_MASK,
          5512 => Opcode::PseudoVLSSEG3E16_V_MF2,
          5513 => Opcode::PseudoVLSSEG3E16_V_MF2_MASK,
          5514 => Opcode::PseudoVLSSEG3E16_V_MF4,
          5515 => Opcode::PseudoVLSSEG3E16_V_MF4_MASK,
          5516 => Opcode::PseudoVLSSEG3E32_V_M1,
          5517 => Opcode::PseudoVLSSEG3E32_V_M1_MASK,
          5518 => Opcode::PseudoVLSSEG3E32_V_M2,
          5519 => Opcode::PseudoVLSSEG3E32_V_M2_MASK,
          5520 => Opcode::PseudoVLSSEG3E32_V_MF2,
          5521 => Opcode::PseudoVLSSEG3E32_V_MF2_MASK,
          5522 => Opcode::PseudoVLSSEG3E64_V_M1,
          5523 => Opcode::PseudoVLSSEG3E64_V_M1_MASK,
          5524 => Opcode::PseudoVLSSEG3E64_V_M2,
          5525 => Opcode::PseudoVLSSEG3E64_V_M2_MASK,
          5526 => Opcode::PseudoVLSSEG3E8_V_M1,
          5527 => Opcode::PseudoVLSSEG3E8_V_M1_MASK,
          5528 => Opcode::PseudoVLSSEG3E8_V_M2,
          5529 => Opcode::PseudoVLSSEG3E8_V_M2_MASK,
          5530 => Opcode::PseudoVLSSEG3E8_V_MF2,
          5531 => Opcode::PseudoVLSSEG3E8_V_MF2_MASK,
          5532 => Opcode::PseudoVLSSEG3E8_V_MF4,
          5533 => Opcode::PseudoVLSSEG3E8_V_MF4_MASK,
          5534 => Opcode::PseudoVLSSEG3E8_V_MF8,
          5535 => Opcode::PseudoVLSSEG3E8_V_MF8_MASK,
          5536 => Opcode::PseudoVLSSEG4E16_V_M1,
          5537 => Opcode::PseudoVLSSEG4E16_V_M1_MASK,
          5538 => Opcode::PseudoVLSSEG4E16_V_M2,
          5539 => Opcode::PseudoVLSSEG4E16_V_M2_MASK,
          5540 => Opcode::PseudoVLSSEG4E16_V_MF2,
          5541 => Opcode::PseudoVLSSEG4E16_V_MF2_MASK,
          5542 => Opcode::PseudoVLSSEG4E16_V_MF4,
          5543 => Opcode::PseudoVLSSEG4E16_V_MF4_MASK,
          5544 => Opcode::PseudoVLSSEG4E32_V_M1,
          5545 => Opcode::PseudoVLSSEG4E32_V_M1_MASK,
          5546 => Opcode::PseudoVLSSEG4E32_V_M2,
          5547 => Opcode::PseudoVLSSEG4E32_V_M2_MASK,
          5548 => Opcode::PseudoVLSSEG4E32_V_MF2,
          5549 => Opcode::PseudoVLSSEG4E32_V_MF2_MASK,
          5550 => Opcode::PseudoVLSSEG4E64_V_M1,
          5551 => Opcode::PseudoVLSSEG4E64_V_M1_MASK,
          5552 => Opcode::PseudoVLSSEG4E64_V_M2,
          5553 => Opcode::PseudoVLSSEG4E64_V_M2_MASK,
          5554 => Opcode::PseudoVLSSEG4E8_V_M1,
          5555 => Opcode::PseudoVLSSEG4E8_V_M1_MASK,
          5556 => Opcode::PseudoVLSSEG4E8_V_M2,
          5557 => Opcode::PseudoVLSSEG4E8_V_M2_MASK,
          5558 => Opcode::PseudoVLSSEG4E8_V_MF2,
          5559 => Opcode::PseudoVLSSEG4E8_V_MF2_MASK,
          5560 => Opcode::PseudoVLSSEG4E8_V_MF4,
          5561 => Opcode::PseudoVLSSEG4E8_V_MF4_MASK,
          5562 => Opcode::PseudoVLSSEG4E8_V_MF8,
          5563 => Opcode::PseudoVLSSEG4E8_V_MF8_MASK,
          5564 => Opcode::PseudoVLSSEG5E16_V_M1,
          5565 => Opcode::PseudoVLSSEG5E16_V_M1_MASK,
          5566 => Opcode::PseudoVLSSEG5E16_V_MF2,
          5567 => Opcode::PseudoVLSSEG5E16_V_MF2_MASK,
          5568 => Opcode::PseudoVLSSEG5E16_V_MF4,
          5569 => Opcode::PseudoVLSSEG5E16_V_MF4_MASK,
          5570 => Opcode::PseudoVLSSEG5E32_V_M1,
          5571 => Opcode::PseudoVLSSEG5E32_V_M1_MASK,
          5572 => Opcode::PseudoVLSSEG5E32_V_MF2,
          5573 => Opcode::PseudoVLSSEG5E32_V_MF2_MASK,
          5574 => Opcode::PseudoVLSSEG5E64_V_M1,
          5575 => Opcode::PseudoVLSSEG5E64_V_M1_MASK,
          5576 => Opcode::PseudoVLSSEG5E8_V_M1,
          5577 => Opcode::PseudoVLSSEG5E8_V_M1_MASK,
          5578 => Opcode::PseudoVLSSEG5E8_V_MF2,
          5579 => Opcode::PseudoVLSSEG5E8_V_MF2_MASK,
          5580 => Opcode::PseudoVLSSEG5E8_V_MF4,
          5581 => Opcode::PseudoVLSSEG5E8_V_MF4_MASK,
          5582 => Opcode::PseudoVLSSEG5E8_V_MF8,
          5583 => Opcode::PseudoVLSSEG5E8_V_MF8_MASK,
          5584 => Opcode::PseudoVLSSEG6E16_V_M1,
          5585 => Opcode::PseudoVLSSEG6E16_V_M1_MASK,
          5586 => Opcode::PseudoVLSSEG6E16_V_MF2,
          5587 => Opcode::PseudoVLSSEG6E16_V_MF2_MASK,
          5588 => Opcode::PseudoVLSSEG6E16_V_MF4,
          5589 => Opcode::PseudoVLSSEG6E16_V_MF4_MASK,
          5590 => Opcode::PseudoVLSSEG6E32_V_M1,
          5591 => Opcode::PseudoVLSSEG6E32_V_M1_MASK,
          5592 => Opcode::PseudoVLSSEG6E32_V_MF2,
          5593 => Opcode::PseudoVLSSEG6E32_V_MF2_MASK,
          5594 => Opcode::PseudoVLSSEG6E64_V_M1,
          5595 => Opcode::PseudoVLSSEG6E64_V_M1_MASK,
          5596 => Opcode::PseudoVLSSEG6E8_V_M1,
          5597 => Opcode::PseudoVLSSEG6E8_V_M1_MASK,
          5598 => Opcode::PseudoVLSSEG6E8_V_MF2,
          5599 => Opcode::PseudoVLSSEG6E8_V_MF2_MASK,
          5600 => Opcode::PseudoVLSSEG6E8_V_MF4,
          5601 => Opcode::PseudoVLSSEG6E8_V_MF4_MASK,
          5602 => Opcode::PseudoVLSSEG6E8_V_MF8,
          5603 => Opcode::PseudoVLSSEG6E8_V_MF8_MASK,
          5604 => Opcode::PseudoVLSSEG7E16_V_M1,
          5605 => Opcode::PseudoVLSSEG7E16_V_M1_MASK,
          5606 => Opcode::PseudoVLSSEG7E16_V_MF2,
          5607 => Opcode::PseudoVLSSEG7E16_V_MF2_MASK,
          5608 => Opcode::PseudoVLSSEG7E16_V_MF4,
          5609 => Opcode::PseudoVLSSEG7E16_V_MF4_MASK,
          5610 => Opcode::PseudoVLSSEG7E32_V_M1,
          5611 => Opcode::PseudoVLSSEG7E32_V_M1_MASK,
          5612 => Opcode::PseudoVLSSEG7E32_V_MF2,
          5613 => Opcode::PseudoVLSSEG7E32_V_MF2_MASK,
          5614 => Opcode::PseudoVLSSEG7E64_V_M1,
          5615 => Opcode::PseudoVLSSEG7E64_V_M1_MASK,
          5616 => Opcode::PseudoVLSSEG7E8_V_M1,
          5617 => Opcode::PseudoVLSSEG7E8_V_M1_MASK,
          5618 => Opcode::PseudoVLSSEG7E8_V_MF2,
          5619 => Opcode::PseudoVLSSEG7E8_V_MF2_MASK,
          5620 => Opcode::PseudoVLSSEG7E8_V_MF4,
          5621 => Opcode::PseudoVLSSEG7E8_V_MF4_MASK,
          5622 => Opcode::PseudoVLSSEG7E8_V_MF8,
          5623 => Opcode::PseudoVLSSEG7E8_V_MF8_MASK,
          5624 => Opcode::PseudoVLSSEG8E16_V_M1,
          5625 => Opcode::PseudoVLSSEG8E16_V_M1_MASK,
          5626 => Opcode::PseudoVLSSEG8E16_V_MF2,
          5627 => Opcode::PseudoVLSSEG8E16_V_MF2_MASK,
          5628 => Opcode::PseudoVLSSEG8E16_V_MF4,
          5629 => Opcode::PseudoVLSSEG8E16_V_MF4_MASK,
          5630 => Opcode::PseudoVLSSEG8E32_V_M1,
          5631 => Opcode::PseudoVLSSEG8E32_V_M1_MASK,
          5632 => Opcode::PseudoVLSSEG8E32_V_MF2,
          5633 => Opcode::PseudoVLSSEG8E32_V_MF2_MASK,
          5634 => Opcode::PseudoVLSSEG8E64_V_M1,
          5635 => Opcode::PseudoVLSSEG8E64_V_M1_MASK,
          5636 => Opcode::PseudoVLSSEG8E8_V_M1,
          5637 => Opcode::PseudoVLSSEG8E8_V_M1_MASK,
          5638 => Opcode::PseudoVLSSEG8E8_V_MF2,
          5639 => Opcode::PseudoVLSSEG8E8_V_MF2_MASK,
          5640 => Opcode::PseudoVLSSEG8E8_V_MF4,
          5641 => Opcode::PseudoVLSSEG8E8_V_MF4_MASK,
          5642 => Opcode::PseudoVLSSEG8E8_V_MF8,
          5643 => Opcode::PseudoVLSSEG8E8_V_MF8_MASK,
          5644 => Opcode::PseudoVLUXEI16_V_M1_M1,
          5645 => Opcode::PseudoVLUXEI16_V_M1_M1_MASK,
          5646 => Opcode::PseudoVLUXEI16_V_M1_M2,
          5647 => Opcode::PseudoVLUXEI16_V_M1_M2_MASK,
          5648 => Opcode::PseudoVLUXEI16_V_M1_M4,
          5649 => Opcode::PseudoVLUXEI16_V_M1_M4_MASK,
          5650 => Opcode::PseudoVLUXEI16_V_M1_MF2,
          5651 => Opcode::PseudoVLUXEI16_V_M1_MF2_MASK,
          5652 => Opcode::PseudoVLUXEI16_V_M2_M1,
          5653 => Opcode::PseudoVLUXEI16_V_M2_M1_MASK,
          5654 => Opcode::PseudoVLUXEI16_V_M2_M2,
          5655 => Opcode::PseudoVLUXEI16_V_M2_M2_MASK,
          5656 => Opcode::PseudoVLUXEI16_V_M2_M4,
          5657 => Opcode::PseudoVLUXEI16_V_M2_M4_MASK,
          5658 => Opcode::PseudoVLUXEI16_V_M2_M8,
          5659 => Opcode::PseudoVLUXEI16_V_M2_M8_MASK,
          5660 => Opcode::PseudoVLUXEI16_V_M4_M2,
          5661 => Opcode::PseudoVLUXEI16_V_M4_M2_MASK,
          5662 => Opcode::PseudoVLUXEI16_V_M4_M4,
          5663 => Opcode::PseudoVLUXEI16_V_M4_M4_MASK,
          5664 => Opcode::PseudoVLUXEI16_V_M4_M8,
          5665 => Opcode::PseudoVLUXEI16_V_M4_M8_MASK,
          5666 => Opcode::PseudoVLUXEI16_V_M8_M4,
          5667 => Opcode::PseudoVLUXEI16_V_M8_M4_MASK,
          5668 => Opcode::PseudoVLUXEI16_V_M8_M8,
          5669 => Opcode::PseudoVLUXEI16_V_M8_M8_MASK,
          5670 => Opcode::PseudoVLUXEI16_V_MF2_M1,
          5671 => Opcode::PseudoVLUXEI16_V_MF2_M1_MASK,
          5672 => Opcode::PseudoVLUXEI16_V_MF2_M2,
          5673 => Opcode::PseudoVLUXEI16_V_MF2_M2_MASK,
          5674 => Opcode::PseudoVLUXEI16_V_MF2_MF2,
          5675 => Opcode::PseudoVLUXEI16_V_MF2_MF2_MASK,
          5676 => Opcode::PseudoVLUXEI16_V_MF2_MF4,
          5677 => Opcode::PseudoVLUXEI16_V_MF2_MF4_MASK,
          5678 => Opcode::PseudoVLUXEI16_V_MF4_M1,
          5679 => Opcode::PseudoVLUXEI16_V_MF4_M1_MASK,
          5680 => Opcode::PseudoVLUXEI16_V_MF4_MF2,
          5681 => Opcode::PseudoVLUXEI16_V_MF4_MF2_MASK,
          5682 => Opcode::PseudoVLUXEI16_V_MF4_MF4,
          5683 => Opcode::PseudoVLUXEI16_V_MF4_MF4_MASK,
          5684 => Opcode::PseudoVLUXEI16_V_MF4_MF8,
          5685 => Opcode::PseudoVLUXEI16_V_MF4_MF8_MASK,
          5686 => Opcode::PseudoVLUXEI32_V_M1_M1,
          5687 => Opcode::PseudoVLUXEI32_V_M1_M1_MASK,
          5688 => Opcode::PseudoVLUXEI32_V_M1_M2,
          5689 => Opcode::PseudoVLUXEI32_V_M1_M2_MASK,
          5690 => Opcode::PseudoVLUXEI32_V_M1_MF2,
          5691 => Opcode::PseudoVLUXEI32_V_M1_MF2_MASK,
          5692 => Opcode::PseudoVLUXEI32_V_M1_MF4,
          5693 => Opcode::PseudoVLUXEI32_V_M1_MF4_MASK,
          5694 => Opcode::PseudoVLUXEI32_V_M2_M1,
          5695 => Opcode::PseudoVLUXEI32_V_M2_M1_MASK,
          5696 => Opcode::PseudoVLUXEI32_V_M2_M2,
          5697 => Opcode::PseudoVLUXEI32_V_M2_M2_MASK,
          5698 => Opcode::PseudoVLUXEI32_V_M2_M4,
          5699 => Opcode::PseudoVLUXEI32_V_M2_M4_MASK,
          5700 => Opcode::PseudoVLUXEI32_V_M2_MF2,
          5701 => Opcode::PseudoVLUXEI32_V_M2_MF2_MASK,
          5702 => Opcode::PseudoVLUXEI32_V_M4_M1,
          5703 => Opcode::PseudoVLUXEI32_V_M4_M1_MASK,
          5704 => Opcode::PseudoVLUXEI32_V_M4_M2,
          5705 => Opcode::PseudoVLUXEI32_V_M4_M2_MASK,
          5706 => Opcode::PseudoVLUXEI32_V_M4_M4,
          5707 => Opcode::PseudoVLUXEI32_V_M4_M4_MASK,
          5708 => Opcode::PseudoVLUXEI32_V_M4_M8,
          5709 => Opcode::PseudoVLUXEI32_V_M4_M8_MASK,
          5710 => Opcode::PseudoVLUXEI32_V_M8_M2,
          5711 => Opcode::PseudoVLUXEI32_V_M8_M2_MASK,
          5712 => Opcode::PseudoVLUXEI32_V_M8_M4,
          5713 => Opcode::PseudoVLUXEI32_V_M8_M4_MASK,
          5714 => Opcode::PseudoVLUXEI32_V_M8_M8,
          5715 => Opcode::PseudoVLUXEI32_V_M8_M8_MASK,
          5716 => Opcode::PseudoVLUXEI32_V_MF2_M1,
          5717 => Opcode::PseudoVLUXEI32_V_MF2_M1_MASK,
          5718 => Opcode::PseudoVLUXEI32_V_MF2_MF2,
          5719 => Opcode::PseudoVLUXEI32_V_MF2_MF2_MASK,
          5720 => Opcode::PseudoVLUXEI32_V_MF2_MF4,
          5721 => Opcode::PseudoVLUXEI32_V_MF2_MF4_MASK,
          5722 => Opcode::PseudoVLUXEI32_V_MF2_MF8,
          5723 => Opcode::PseudoVLUXEI32_V_MF2_MF8_MASK,
          5724 => Opcode::PseudoVLUXEI64_V_M1_M1,
          5725 => Opcode::PseudoVLUXEI64_V_M1_M1_MASK,
          5726 => Opcode::PseudoVLUXEI64_V_M1_MF2,
          5727 => Opcode::PseudoVLUXEI64_V_M1_MF2_MASK,
          5728 => Opcode::PseudoVLUXEI64_V_M1_MF4,
          5729 => Opcode::PseudoVLUXEI64_V_M1_MF4_MASK,
          5730 => Opcode::PseudoVLUXEI64_V_M1_MF8,
          5731 => Opcode::PseudoVLUXEI64_V_M1_MF8_MASK,
          5732 => Opcode::PseudoVLUXEI64_V_M2_M1,
          5733 => Opcode::PseudoVLUXEI64_V_M2_M1_MASK,
          5734 => Opcode::PseudoVLUXEI64_V_M2_M2,
          5735 => Opcode::PseudoVLUXEI64_V_M2_M2_MASK,
          5736 => Opcode::PseudoVLUXEI64_V_M2_MF2,
          5737 => Opcode::PseudoVLUXEI64_V_M2_MF2_MASK,
          5738 => Opcode::PseudoVLUXEI64_V_M2_MF4,
          5739 => Opcode::PseudoVLUXEI64_V_M2_MF4_MASK,
          5740 => Opcode::PseudoVLUXEI64_V_M4_M1,
          5741 => Opcode::PseudoVLUXEI64_V_M4_M1_MASK,
          5742 => Opcode::PseudoVLUXEI64_V_M4_M2,
          5743 => Opcode::PseudoVLUXEI64_V_M4_M2_MASK,
          5744 => Opcode::PseudoVLUXEI64_V_M4_M4,
          5745 => Opcode::PseudoVLUXEI64_V_M4_M4_MASK,
          5746 => Opcode::PseudoVLUXEI64_V_M4_MF2,
          5747 => Opcode::PseudoVLUXEI64_V_M4_MF2_MASK,
          5748 => Opcode::PseudoVLUXEI64_V_M8_M1,
          5749 => Opcode::PseudoVLUXEI64_V_M8_M1_MASK,
          5750 => Opcode::PseudoVLUXEI64_V_M8_M2,
          5751 => Opcode::PseudoVLUXEI64_V_M8_M2_MASK,
          5752 => Opcode::PseudoVLUXEI64_V_M8_M4,
          5753 => Opcode::PseudoVLUXEI64_V_M8_M4_MASK,
          5754 => Opcode::PseudoVLUXEI64_V_M8_M8,
          5755 => Opcode::PseudoVLUXEI64_V_M8_M8_MASK,
          5756 => Opcode::PseudoVLUXEI8_V_M1_M1,
          5757 => Opcode::PseudoVLUXEI8_V_M1_M1_MASK,
          5758 => Opcode::PseudoVLUXEI8_V_M1_M2,
          5759 => Opcode::PseudoVLUXEI8_V_M1_M2_MASK,
          5760 => Opcode::PseudoVLUXEI8_V_M1_M4,
          5761 => Opcode::PseudoVLUXEI8_V_M1_M4_MASK,
          5762 => Opcode::PseudoVLUXEI8_V_M1_M8,
          5763 => Opcode::PseudoVLUXEI8_V_M1_M8_MASK,
          5764 => Opcode::PseudoVLUXEI8_V_M2_M2,
          5765 => Opcode::PseudoVLUXEI8_V_M2_M2_MASK,
          5766 => Opcode::PseudoVLUXEI8_V_M2_M4,
          5767 => Opcode::PseudoVLUXEI8_V_M2_M4_MASK,
          5768 => Opcode::PseudoVLUXEI8_V_M2_M8,
          5769 => Opcode::PseudoVLUXEI8_V_M2_M8_MASK,
          5770 => Opcode::PseudoVLUXEI8_V_M4_M4,
          5771 => Opcode::PseudoVLUXEI8_V_M4_M4_MASK,
          5772 => Opcode::PseudoVLUXEI8_V_M4_M8,
          5773 => Opcode::PseudoVLUXEI8_V_M4_M8_MASK,
          5774 => Opcode::PseudoVLUXEI8_V_M8_M8,
          5775 => Opcode::PseudoVLUXEI8_V_M8_M8_MASK,
          5776 => Opcode::PseudoVLUXEI8_V_MF2_M1,
          5777 => Opcode::PseudoVLUXEI8_V_MF2_M1_MASK,
          5778 => Opcode::PseudoVLUXEI8_V_MF2_M2,
          5779 => Opcode::PseudoVLUXEI8_V_MF2_M2_MASK,
          5780 => Opcode::PseudoVLUXEI8_V_MF2_M4,
          5781 => Opcode::PseudoVLUXEI8_V_MF2_M4_MASK,
          5782 => Opcode::PseudoVLUXEI8_V_MF2_MF2,
          5783 => Opcode::PseudoVLUXEI8_V_MF2_MF2_MASK,
          5784 => Opcode::PseudoVLUXEI8_V_MF4_M1,
          5785 => Opcode::PseudoVLUXEI8_V_MF4_M1_MASK,
          5786 => Opcode::PseudoVLUXEI8_V_MF4_M2,
          5787 => Opcode::PseudoVLUXEI8_V_MF4_M2_MASK,
          5788 => Opcode::PseudoVLUXEI8_V_MF4_MF2,
          5789 => Opcode::PseudoVLUXEI8_V_MF4_MF2_MASK,
          5790 => Opcode::PseudoVLUXEI8_V_MF4_MF4,
          5791 => Opcode::PseudoVLUXEI8_V_MF4_MF4_MASK,
          5792 => Opcode::PseudoVLUXEI8_V_MF8_M1,
          5793 => Opcode::PseudoVLUXEI8_V_MF8_M1_MASK,
          5794 => Opcode::PseudoVLUXEI8_V_MF8_MF2,
          5795 => Opcode::PseudoVLUXEI8_V_MF8_MF2_MASK,
          5796 => Opcode::PseudoVLUXEI8_V_MF8_MF4,
          5797 => Opcode::PseudoVLUXEI8_V_MF8_MF4_MASK,
          5798 => Opcode::PseudoVLUXEI8_V_MF8_MF8,
          5799 => Opcode::PseudoVLUXEI8_V_MF8_MF8_MASK,
          5800 => Opcode::PseudoVLUXSEG2EI16_V_M1_M1,
          5801 => Opcode::PseudoVLUXSEG2EI16_V_M1_M1_MASK,
          5802 => Opcode::PseudoVLUXSEG2EI16_V_M1_M2,
          5803 => Opcode::PseudoVLUXSEG2EI16_V_M1_M2_MASK,
          5804 => Opcode::PseudoVLUXSEG2EI16_V_M1_M4,
          5805 => Opcode::PseudoVLUXSEG2EI16_V_M1_M4_MASK,
          5806 => Opcode::PseudoVLUXSEG2EI16_V_M1_MF2,
          5807 => Opcode::PseudoVLUXSEG2EI16_V_M1_MF2_MASK,
          5808 => Opcode::PseudoVLUXSEG2EI16_V_M2_M1,
          5809 => Opcode::PseudoVLUXSEG2EI16_V_M2_M1_MASK,
          5810 => Opcode::PseudoVLUXSEG2EI16_V_M2_M2,
          5811 => Opcode::PseudoVLUXSEG2EI16_V_M2_M2_MASK,
          5812 => Opcode::PseudoVLUXSEG2EI16_V_M2_M4,
          5813 => Opcode::PseudoVLUXSEG2EI16_V_M2_M4_MASK,
          5814 => Opcode::PseudoVLUXSEG2EI16_V_M4_M2,
          5815 => Opcode::PseudoVLUXSEG2EI16_V_M4_M2_MASK,
          5816 => Opcode::PseudoVLUXSEG2EI16_V_M4_M4,
          5817 => Opcode::PseudoVLUXSEG2EI16_V_M4_M4_MASK,
          5818 => Opcode::PseudoVLUXSEG2EI16_V_M8_M4,
          5819 => Opcode::PseudoVLUXSEG2EI16_V_M8_M4_MASK,
          5820 => Opcode::PseudoVLUXSEG2EI16_V_MF2_M1,
          5821 => Opcode::PseudoVLUXSEG2EI16_V_MF2_M1_MASK,
          5822 => Opcode::PseudoVLUXSEG2EI16_V_MF2_M2,
          5823 => Opcode::PseudoVLUXSEG2EI16_V_MF2_M2_MASK,
          5824 => Opcode::PseudoVLUXSEG2EI16_V_MF2_MF2,
          5825 => Opcode::PseudoVLUXSEG2EI16_V_MF2_MF2_MASK,
          5826 => Opcode::PseudoVLUXSEG2EI16_V_MF2_MF4,
          5827 => Opcode::PseudoVLUXSEG2EI16_V_MF2_MF4_MASK,
          5828 => Opcode::PseudoVLUXSEG2EI16_V_MF4_M1,
          5829 => Opcode::PseudoVLUXSEG2EI16_V_MF4_M1_MASK,
          5830 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF2,
          5831 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF2_MASK,
          5832 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF4,
          5833 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF4_MASK,
          5834 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF8,
          5835 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF8_MASK,
          5836 => Opcode::PseudoVLUXSEG2EI32_V_M1_M1,
          5837 => Opcode::PseudoVLUXSEG2EI32_V_M1_M1_MASK,
          5838 => Opcode::PseudoVLUXSEG2EI32_V_M1_M2,
          5839 => Opcode::PseudoVLUXSEG2EI32_V_M1_M2_MASK,
          5840 => Opcode::PseudoVLUXSEG2EI32_V_M1_MF2,
          5841 => Opcode::PseudoVLUXSEG2EI32_V_M1_MF2_MASK,
          5842 => Opcode::PseudoVLUXSEG2EI32_V_M1_MF4,
          5843 => Opcode::PseudoVLUXSEG2EI32_V_M1_MF4_MASK,
          5844 => Opcode::PseudoVLUXSEG2EI32_V_M2_M1,
          5845 => Opcode::PseudoVLUXSEG2EI32_V_M2_M1_MASK,
          5846 => Opcode::PseudoVLUXSEG2EI32_V_M2_M2,
          5847 => Opcode::PseudoVLUXSEG2EI32_V_M2_M2_MASK,
          5848 => Opcode::PseudoVLUXSEG2EI32_V_M2_M4,
          5849 => Opcode::PseudoVLUXSEG2EI32_V_M2_M4_MASK,
          5850 => Opcode::PseudoVLUXSEG2EI32_V_M2_MF2,
          5851 => Opcode::PseudoVLUXSEG2EI32_V_M2_MF2_MASK,
          5852 => Opcode::PseudoVLUXSEG2EI32_V_M4_M1,
          5853 => Opcode::PseudoVLUXSEG2EI32_V_M4_M1_MASK,
          5854 => Opcode::PseudoVLUXSEG2EI32_V_M4_M2,
          5855 => Opcode::PseudoVLUXSEG2EI32_V_M4_M2_MASK,
          5856 => Opcode::PseudoVLUXSEG2EI32_V_M4_M4,
          5857 => Opcode::PseudoVLUXSEG2EI32_V_M4_M4_MASK,
          5858 => Opcode::PseudoVLUXSEG2EI32_V_M8_M2,
          5859 => Opcode::PseudoVLUXSEG2EI32_V_M8_M2_MASK,
          5860 => Opcode::PseudoVLUXSEG2EI32_V_M8_M4,
          5861 => Opcode::PseudoVLUXSEG2EI32_V_M8_M4_MASK,
          5862 => Opcode::PseudoVLUXSEG2EI32_V_MF2_M1,
          5863 => Opcode::PseudoVLUXSEG2EI32_V_MF2_M1_MASK,
          5864 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF2,
          5865 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF2_MASK,
          5866 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF4,
          5867 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF4_MASK,
          5868 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF8,
          5869 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF8_MASK,
          5870 => Opcode::PseudoVLUXSEG2EI64_V_M1_M1,
          5871 => Opcode::PseudoVLUXSEG2EI64_V_M1_M1_MASK,
          5872 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF2,
          5873 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF2_MASK,
          5874 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF4,
          5875 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF4_MASK,
          5876 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF8,
          5877 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF8_MASK,
          5878 => Opcode::PseudoVLUXSEG2EI64_V_M2_M1,
          5879 => Opcode::PseudoVLUXSEG2EI64_V_M2_M1_MASK,
          5880 => Opcode::PseudoVLUXSEG2EI64_V_M2_M2,
          5881 => Opcode::PseudoVLUXSEG2EI64_V_M2_M2_MASK,
          5882 => Opcode::PseudoVLUXSEG2EI64_V_M2_MF2,
          5883 => Opcode::PseudoVLUXSEG2EI64_V_M2_MF2_MASK,
          5884 => Opcode::PseudoVLUXSEG2EI64_V_M2_MF4,
          5885 => Opcode::PseudoVLUXSEG2EI64_V_M2_MF4_MASK,
          5886 => Opcode::PseudoVLUXSEG2EI64_V_M4_M1,
          5887 => Opcode::PseudoVLUXSEG2EI64_V_M4_M1_MASK,
          5888 => Opcode::PseudoVLUXSEG2EI64_V_M4_M2,
          5889 => Opcode::PseudoVLUXSEG2EI64_V_M4_M2_MASK,
          5890 => Opcode::PseudoVLUXSEG2EI64_V_M4_M4,
          5891 => Opcode::PseudoVLUXSEG2EI64_V_M4_M4_MASK,
          5892 => Opcode::PseudoVLUXSEG2EI64_V_M4_MF2,
          5893 => Opcode::PseudoVLUXSEG2EI64_V_M4_MF2_MASK,
          5894 => Opcode::PseudoVLUXSEG2EI64_V_M8_M1,
          5895 => Opcode::PseudoVLUXSEG2EI64_V_M8_M1_MASK,
          5896 => Opcode::PseudoVLUXSEG2EI64_V_M8_M2,
          5897 => Opcode::PseudoVLUXSEG2EI64_V_M8_M2_MASK,
          5898 => Opcode::PseudoVLUXSEG2EI64_V_M8_M4,
          5899 => Opcode::PseudoVLUXSEG2EI64_V_M8_M4_MASK,
          5900 => Opcode::PseudoVLUXSEG2EI8_V_M1_M1,
          5901 => Opcode::PseudoVLUXSEG2EI8_V_M1_M1_MASK,
          5902 => Opcode::PseudoVLUXSEG2EI8_V_M1_M2,
          5903 => Opcode::PseudoVLUXSEG2EI8_V_M1_M2_MASK,
          5904 => Opcode::PseudoVLUXSEG2EI8_V_M1_M4,
          5905 => Opcode::PseudoVLUXSEG2EI8_V_M1_M4_MASK,
          5906 => Opcode::PseudoVLUXSEG2EI8_V_M2_M2,
          5907 => Opcode::PseudoVLUXSEG2EI8_V_M2_M2_MASK,
          5908 => Opcode::PseudoVLUXSEG2EI8_V_M2_M4,
          5909 => Opcode::PseudoVLUXSEG2EI8_V_M2_M4_MASK,
          5910 => Opcode::PseudoVLUXSEG2EI8_V_M4_M4,
          5911 => Opcode::PseudoVLUXSEG2EI8_V_M4_M4_MASK,
          5912 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M1,
          5913 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M1_MASK,
          5914 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M2,
          5915 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M2_MASK,
          5916 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M4,
          5917 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M4_MASK,
          5918 => Opcode::PseudoVLUXSEG2EI8_V_MF2_MF2,
          5919 => Opcode::PseudoVLUXSEG2EI8_V_MF2_MF2_MASK,
          5920 => Opcode::PseudoVLUXSEG2EI8_V_MF4_M1,
          5921 => Opcode::PseudoVLUXSEG2EI8_V_MF4_M1_MASK,
          5922 => Opcode::PseudoVLUXSEG2EI8_V_MF4_M2,
          5923 => Opcode::PseudoVLUXSEG2EI8_V_MF4_M2_MASK,
          5924 => Opcode::PseudoVLUXSEG2EI8_V_MF4_MF2,
          5925 => Opcode::PseudoVLUXSEG2EI8_V_MF4_MF2_MASK,
          5926 => Opcode::PseudoVLUXSEG2EI8_V_MF4_MF4,
          5927 => Opcode::PseudoVLUXSEG2EI8_V_MF4_MF4_MASK,
          5928 => Opcode::PseudoVLUXSEG2EI8_V_MF8_M1,
          5929 => Opcode::PseudoVLUXSEG2EI8_V_MF8_M1_MASK,
          5930 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF2,
          5931 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF2_MASK,
          5932 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF4,
          5933 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF4_MASK,
          5934 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF8,
          5935 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF8_MASK,
          5936 => Opcode::PseudoVLUXSEG3EI16_V_M1_M1,
          5937 => Opcode::PseudoVLUXSEG3EI16_V_M1_M1_MASK,
          5938 => Opcode::PseudoVLUXSEG3EI16_V_M1_M2,
          5939 => Opcode::PseudoVLUXSEG3EI16_V_M1_M2_MASK,
          5940 => Opcode::PseudoVLUXSEG3EI16_V_M1_MF2,
          5941 => Opcode::PseudoVLUXSEG3EI16_V_M1_MF2_MASK,
          5942 => Opcode::PseudoVLUXSEG3EI16_V_M2_M1,
          5943 => Opcode::PseudoVLUXSEG3EI16_V_M2_M1_MASK,
          5944 => Opcode::PseudoVLUXSEG3EI16_V_M2_M2,
          5945 => Opcode::PseudoVLUXSEG3EI16_V_M2_M2_MASK,
          5946 => Opcode::PseudoVLUXSEG3EI16_V_M4_M2,
          5947 => Opcode::PseudoVLUXSEG3EI16_V_M4_M2_MASK,
          5948 => Opcode::PseudoVLUXSEG3EI16_V_MF2_M1,
          5949 => Opcode::PseudoVLUXSEG3EI16_V_MF2_M1_MASK,
          5950 => Opcode::PseudoVLUXSEG3EI16_V_MF2_M2,
          5951 => Opcode::PseudoVLUXSEG3EI16_V_MF2_M2_MASK,
          5952 => Opcode::PseudoVLUXSEG3EI16_V_MF2_MF2,
          5953 => Opcode::PseudoVLUXSEG3EI16_V_MF2_MF2_MASK,
          5954 => Opcode::PseudoVLUXSEG3EI16_V_MF2_MF4,
          5955 => Opcode::PseudoVLUXSEG3EI16_V_MF2_MF4_MASK,
          5956 => Opcode::PseudoVLUXSEG3EI16_V_MF4_M1,
          5957 => Opcode::PseudoVLUXSEG3EI16_V_MF4_M1_MASK,
          5958 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF2,
          5959 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF2_MASK,
          5960 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF4,
          5961 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF4_MASK,
          5962 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF8,
          5963 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF8_MASK,
          5964 => Opcode::PseudoVLUXSEG3EI32_V_M1_M1,
          5965 => Opcode::PseudoVLUXSEG3EI32_V_M1_M1_MASK,
          5966 => Opcode::PseudoVLUXSEG3EI32_V_M1_M2,
          5967 => Opcode::PseudoVLUXSEG3EI32_V_M1_M2_MASK,
          5968 => Opcode::PseudoVLUXSEG3EI32_V_M1_MF2,
          5969 => Opcode::PseudoVLUXSEG3EI32_V_M1_MF2_MASK,
          5970 => Opcode::PseudoVLUXSEG3EI32_V_M1_MF4,
          5971 => Opcode::PseudoVLUXSEG3EI32_V_M1_MF4_MASK,
          5972 => Opcode::PseudoVLUXSEG3EI32_V_M2_M1,
          5973 => Opcode::PseudoVLUXSEG3EI32_V_M2_M1_MASK,
          5974 => Opcode::PseudoVLUXSEG3EI32_V_M2_M2,
          5975 => Opcode::PseudoVLUXSEG3EI32_V_M2_M2_MASK,
          5976 => Opcode::PseudoVLUXSEG3EI32_V_M2_MF2,
          5977 => Opcode::PseudoVLUXSEG3EI32_V_M2_MF2_MASK,
          5978 => Opcode::PseudoVLUXSEG3EI32_V_M4_M1,
          5979 => Opcode::PseudoVLUXSEG3EI32_V_M4_M1_MASK,
          5980 => Opcode::PseudoVLUXSEG3EI32_V_M4_M2,
          5981 => Opcode::PseudoVLUXSEG3EI32_V_M4_M2_MASK,
          5982 => Opcode::PseudoVLUXSEG3EI32_V_M8_M2,
          5983 => Opcode::PseudoVLUXSEG3EI32_V_M8_M2_MASK,
          5984 => Opcode::PseudoVLUXSEG3EI32_V_MF2_M1,
          5985 => Opcode::PseudoVLUXSEG3EI32_V_MF2_M1_MASK,
          5986 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF2,
          5987 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF2_MASK,
          5988 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF4,
          5989 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF4_MASK,
          5990 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF8,
          5991 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF8_MASK,
          5992 => Opcode::PseudoVLUXSEG3EI64_V_M1_M1,
          5993 => Opcode::PseudoVLUXSEG3EI64_V_M1_M1_MASK,
          5994 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF2,
          5995 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF2_MASK,
          5996 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF4,
          5997 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF4_MASK,
          5998 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF8,
          5999 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF8_MASK,
          6000 => Opcode::PseudoVLUXSEG3EI64_V_M2_M1,
          6001 => Opcode::PseudoVLUXSEG3EI64_V_M2_M1_MASK,
          6002 => Opcode::PseudoVLUXSEG3EI64_V_M2_M2,
          6003 => Opcode::PseudoVLUXSEG3EI64_V_M2_M2_MASK,
          6004 => Opcode::PseudoVLUXSEG3EI64_V_M2_MF2,
          6005 => Opcode::PseudoVLUXSEG3EI64_V_M2_MF2_MASK,
          6006 => Opcode::PseudoVLUXSEG3EI64_V_M2_MF4,
          6007 => Opcode::PseudoVLUXSEG3EI64_V_M2_MF4_MASK,
          6008 => Opcode::PseudoVLUXSEG3EI64_V_M4_M1,
          6009 => Opcode::PseudoVLUXSEG3EI64_V_M4_M1_MASK,
          6010 => Opcode::PseudoVLUXSEG3EI64_V_M4_M2,
          6011 => Opcode::PseudoVLUXSEG3EI64_V_M4_M2_MASK,
          6012 => Opcode::PseudoVLUXSEG3EI64_V_M4_MF2,
          6013 => Opcode::PseudoVLUXSEG3EI64_V_M4_MF2_MASK,
          6014 => Opcode::PseudoVLUXSEG3EI64_V_M8_M1,
          6015 => Opcode::PseudoVLUXSEG3EI64_V_M8_M1_MASK,
          6016 => Opcode::PseudoVLUXSEG3EI64_V_M8_M2,
          6017 => Opcode::PseudoVLUXSEG3EI64_V_M8_M2_MASK,
          6018 => Opcode::PseudoVLUXSEG3EI8_V_M1_M1,
          6019 => Opcode::PseudoVLUXSEG3EI8_V_M1_M1_MASK,
          6020 => Opcode::PseudoVLUXSEG3EI8_V_M1_M2,
          6021 => Opcode::PseudoVLUXSEG3EI8_V_M1_M2_MASK,
          6022 => Opcode::PseudoVLUXSEG3EI8_V_M2_M2,
          6023 => Opcode::PseudoVLUXSEG3EI8_V_M2_M2_MASK,
          6024 => Opcode::PseudoVLUXSEG3EI8_V_MF2_M1,
          6025 => Opcode::PseudoVLUXSEG3EI8_V_MF2_M1_MASK,
          6026 => Opcode::PseudoVLUXSEG3EI8_V_MF2_M2,
          6027 => Opcode::PseudoVLUXSEG3EI8_V_MF2_M2_MASK,
          6028 => Opcode::PseudoVLUXSEG3EI8_V_MF2_MF2,
          6029 => Opcode::PseudoVLUXSEG3EI8_V_MF2_MF2_MASK,
          6030 => Opcode::PseudoVLUXSEG3EI8_V_MF4_M1,
          6031 => Opcode::PseudoVLUXSEG3EI8_V_MF4_M1_MASK,
          6032 => Opcode::PseudoVLUXSEG3EI8_V_MF4_M2,
          6033 => Opcode::PseudoVLUXSEG3EI8_V_MF4_M2_MASK,
          6034 => Opcode::PseudoVLUXSEG3EI8_V_MF4_MF2,
          6035 => Opcode::PseudoVLUXSEG3EI8_V_MF4_MF2_MASK,
          6036 => Opcode::PseudoVLUXSEG3EI8_V_MF4_MF4,
          6037 => Opcode::PseudoVLUXSEG3EI8_V_MF4_MF4_MASK,
          6038 => Opcode::PseudoVLUXSEG3EI8_V_MF8_M1,
          6039 => Opcode::PseudoVLUXSEG3EI8_V_MF8_M1_MASK,
          6040 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF2,
          6041 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF2_MASK,
          6042 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF4,
          6043 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF4_MASK,
          6044 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF8,
          6045 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF8_MASK,
          6046 => Opcode::PseudoVLUXSEG4EI16_V_M1_M1,
          6047 => Opcode::PseudoVLUXSEG4EI16_V_M1_M1_MASK,
          6048 => Opcode::PseudoVLUXSEG4EI16_V_M1_M2,
          6049 => Opcode::PseudoVLUXSEG4EI16_V_M1_M2_MASK,
          6050 => Opcode::PseudoVLUXSEG4EI16_V_M1_MF2,
          6051 => Opcode::PseudoVLUXSEG4EI16_V_M1_MF2_MASK,
          6052 => Opcode::PseudoVLUXSEG4EI16_V_M2_M1,
          6053 => Opcode::PseudoVLUXSEG4EI16_V_M2_M1_MASK,
          6054 => Opcode::PseudoVLUXSEG4EI16_V_M2_M2,
          6055 => Opcode::PseudoVLUXSEG4EI16_V_M2_M2_MASK,
          6056 => Opcode::PseudoVLUXSEG4EI16_V_M4_M2,
          6057 => Opcode::PseudoVLUXSEG4EI16_V_M4_M2_MASK,
          6058 => Opcode::PseudoVLUXSEG4EI16_V_MF2_M1,
          6059 => Opcode::PseudoVLUXSEG4EI16_V_MF2_M1_MASK,
          6060 => Opcode::PseudoVLUXSEG4EI16_V_MF2_M2,
          6061 => Opcode::PseudoVLUXSEG4EI16_V_MF2_M2_MASK,
          6062 => Opcode::PseudoVLUXSEG4EI16_V_MF2_MF2,
          6063 => Opcode::PseudoVLUXSEG4EI16_V_MF2_MF2_MASK,
          6064 => Opcode::PseudoVLUXSEG4EI16_V_MF2_MF4,
          6065 => Opcode::PseudoVLUXSEG4EI16_V_MF2_MF4_MASK,
          6066 => Opcode::PseudoVLUXSEG4EI16_V_MF4_M1,
          6067 => Opcode::PseudoVLUXSEG4EI16_V_MF4_M1_MASK,
          6068 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF2,
          6069 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF2_MASK,
          6070 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF4,
          6071 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF4_MASK,
          6072 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF8,
          6073 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF8_MASK,
          6074 => Opcode::PseudoVLUXSEG4EI32_V_M1_M1,
          6075 => Opcode::PseudoVLUXSEG4EI32_V_M1_M1_MASK,
          6076 => Opcode::PseudoVLUXSEG4EI32_V_M1_M2,
          6077 => Opcode::PseudoVLUXSEG4EI32_V_M1_M2_MASK,
          6078 => Opcode::PseudoVLUXSEG4EI32_V_M1_MF2,
          6079 => Opcode::PseudoVLUXSEG4EI32_V_M1_MF2_MASK,
          6080 => Opcode::PseudoVLUXSEG4EI32_V_M1_MF4,
          6081 => Opcode::PseudoVLUXSEG4EI32_V_M1_MF4_MASK,
          6082 => Opcode::PseudoVLUXSEG4EI32_V_M2_M1,
          6083 => Opcode::PseudoVLUXSEG4EI32_V_M2_M1_MASK,
          6084 => Opcode::PseudoVLUXSEG4EI32_V_M2_M2,
          6085 => Opcode::PseudoVLUXSEG4EI32_V_M2_M2_MASK,
          6086 => Opcode::PseudoVLUXSEG4EI32_V_M2_MF2,
          6087 => Opcode::PseudoVLUXSEG4EI32_V_M2_MF2_MASK,
          6088 => Opcode::PseudoVLUXSEG4EI32_V_M4_M1,
          6089 => Opcode::PseudoVLUXSEG4EI32_V_M4_M1_MASK,
          6090 => Opcode::PseudoVLUXSEG4EI32_V_M4_M2,
          6091 => Opcode::PseudoVLUXSEG4EI32_V_M4_M2_MASK,
          6092 => Opcode::PseudoVLUXSEG4EI32_V_M8_M2,
          6093 => Opcode::PseudoVLUXSEG4EI32_V_M8_M2_MASK,
          6094 => Opcode::PseudoVLUXSEG4EI32_V_MF2_M1,
          6095 => Opcode::PseudoVLUXSEG4EI32_V_MF2_M1_MASK,
          6096 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF2,
          6097 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF2_MASK,
          6098 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF4,
          6099 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF4_MASK,
          6100 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF8,
          6101 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF8_MASK,
          6102 => Opcode::PseudoVLUXSEG4EI64_V_M1_M1,
          6103 => Opcode::PseudoVLUXSEG4EI64_V_M1_M1_MASK,
          6104 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF2,
          6105 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF2_MASK,
          6106 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF4,
          6107 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF4_MASK,
          6108 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF8,
          6109 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF8_MASK,
          6110 => Opcode::PseudoVLUXSEG4EI64_V_M2_M1,
          6111 => Opcode::PseudoVLUXSEG4EI64_V_M2_M1_MASK,
          6112 => Opcode::PseudoVLUXSEG4EI64_V_M2_M2,
          6113 => Opcode::PseudoVLUXSEG4EI64_V_M2_M2_MASK,
          6114 => Opcode::PseudoVLUXSEG4EI64_V_M2_MF2,
          6115 => Opcode::PseudoVLUXSEG4EI64_V_M2_MF2_MASK,
          6116 => Opcode::PseudoVLUXSEG4EI64_V_M2_MF4,
          6117 => Opcode::PseudoVLUXSEG4EI64_V_M2_MF4_MASK,
          6118 => Opcode::PseudoVLUXSEG4EI64_V_M4_M1,
          6119 => Opcode::PseudoVLUXSEG4EI64_V_M4_M1_MASK,
          6120 => Opcode::PseudoVLUXSEG4EI64_V_M4_M2,
          6121 => Opcode::PseudoVLUXSEG4EI64_V_M4_M2_MASK,
          6122 => Opcode::PseudoVLUXSEG4EI64_V_M4_MF2,
          6123 => Opcode::PseudoVLUXSEG4EI64_V_M4_MF2_MASK,
          6124 => Opcode::PseudoVLUXSEG4EI64_V_M8_M1,
          6125 => Opcode::PseudoVLUXSEG4EI64_V_M8_M1_MASK,
          6126 => Opcode::PseudoVLUXSEG4EI64_V_M8_M2,
          6127 => Opcode::PseudoVLUXSEG4EI64_V_M8_M2_MASK,
          6128 => Opcode::PseudoVLUXSEG4EI8_V_M1_M1,
          6129 => Opcode::PseudoVLUXSEG4EI8_V_M1_M1_MASK,
          6130 => Opcode::PseudoVLUXSEG4EI8_V_M1_M2,
          6131 => Opcode::PseudoVLUXSEG4EI8_V_M1_M2_MASK,
          6132 => Opcode::PseudoVLUXSEG4EI8_V_M2_M2,
          6133 => Opcode::PseudoVLUXSEG4EI8_V_M2_M2_MASK,
          6134 => Opcode::PseudoVLUXSEG4EI8_V_MF2_M1,
          6135 => Opcode::PseudoVLUXSEG4EI8_V_MF2_M1_MASK,
          6136 => Opcode::PseudoVLUXSEG4EI8_V_MF2_M2,
          6137 => Opcode::PseudoVLUXSEG4EI8_V_MF2_M2_MASK,
          6138 => Opcode::PseudoVLUXSEG4EI8_V_MF2_MF2,
          6139 => Opcode::PseudoVLUXSEG4EI8_V_MF2_MF2_MASK,
          6140 => Opcode::PseudoVLUXSEG4EI8_V_MF4_M1,
          6141 => Opcode::PseudoVLUXSEG4EI8_V_MF4_M1_MASK,
          6142 => Opcode::PseudoVLUXSEG4EI8_V_MF4_M2,
          6143 => Opcode::PseudoVLUXSEG4EI8_V_MF4_M2_MASK,
          6144 => Opcode::PseudoVLUXSEG4EI8_V_MF4_MF2,
          6145 => Opcode::PseudoVLUXSEG4EI8_V_MF4_MF2_MASK,
          6146 => Opcode::PseudoVLUXSEG4EI8_V_MF4_MF4,
          6147 => Opcode::PseudoVLUXSEG4EI8_V_MF4_MF4_MASK,
          6148 => Opcode::PseudoVLUXSEG4EI8_V_MF8_M1,
          6149 => Opcode::PseudoVLUXSEG4EI8_V_MF8_M1_MASK,
          6150 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF2,
          6151 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF2_MASK,
          6152 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF4,
          6153 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF4_MASK,
          6154 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF8,
          6155 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF8_MASK,
          6156 => Opcode::PseudoVLUXSEG5EI16_V_M1_M1,
          6157 => Opcode::PseudoVLUXSEG5EI16_V_M1_M1_MASK,
          6158 => Opcode::PseudoVLUXSEG5EI16_V_M1_MF2,
          6159 => Opcode::PseudoVLUXSEG5EI16_V_M1_MF2_MASK,
          6160 => Opcode::PseudoVLUXSEG5EI16_V_M2_M1,
          6161 => Opcode::PseudoVLUXSEG5EI16_V_M2_M1_MASK,
          6162 => Opcode::PseudoVLUXSEG5EI16_V_MF2_M1,
          6163 => Opcode::PseudoVLUXSEG5EI16_V_MF2_M1_MASK,
          6164 => Opcode::PseudoVLUXSEG5EI16_V_MF2_MF2,
          6165 => Opcode::PseudoVLUXSEG5EI16_V_MF2_MF2_MASK,
          6166 => Opcode::PseudoVLUXSEG5EI16_V_MF2_MF4,
          6167 => Opcode::PseudoVLUXSEG5EI16_V_MF2_MF4_MASK,
          6168 => Opcode::PseudoVLUXSEG5EI16_V_MF4_M1,
          6169 => Opcode::PseudoVLUXSEG5EI16_V_MF4_M1_MASK,
          6170 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF2,
          6171 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF2_MASK,
          6172 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF4,
          6173 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF4_MASK,
          6174 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF8,
          6175 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF8_MASK,
          6176 => Opcode::PseudoVLUXSEG5EI32_V_M1_M1,
          6177 => Opcode::PseudoVLUXSEG5EI32_V_M1_M1_MASK,
          6178 => Opcode::PseudoVLUXSEG5EI32_V_M1_MF2,
          6179 => Opcode::PseudoVLUXSEG5EI32_V_M1_MF2_MASK,
          6180 => Opcode::PseudoVLUXSEG5EI32_V_M1_MF4,
          6181 => Opcode::PseudoVLUXSEG5EI32_V_M1_MF4_MASK,
          6182 => Opcode::PseudoVLUXSEG5EI32_V_M2_M1,
          6183 => Opcode::PseudoVLUXSEG5EI32_V_M2_M1_MASK,
          6184 => Opcode::PseudoVLUXSEG5EI32_V_M2_MF2,
          6185 => Opcode::PseudoVLUXSEG5EI32_V_M2_MF2_MASK,
          6186 => Opcode::PseudoVLUXSEG5EI32_V_M4_M1,
          6187 => Opcode::PseudoVLUXSEG5EI32_V_M4_M1_MASK,
          6188 => Opcode::PseudoVLUXSEG5EI32_V_MF2_M1,
          6189 => Opcode::PseudoVLUXSEG5EI32_V_MF2_M1_MASK,
          6190 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF2,
          6191 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF2_MASK,
          6192 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF4,
          6193 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF4_MASK,
          6194 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF8,
          6195 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF8_MASK,
          6196 => Opcode::PseudoVLUXSEG5EI64_V_M1_M1,
          6197 => Opcode::PseudoVLUXSEG5EI64_V_M1_M1_MASK,
          6198 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF2,
          6199 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF2_MASK,
          6200 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF4,
          6201 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF4_MASK,
          6202 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF8,
          6203 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF8_MASK,
          6204 => Opcode::PseudoVLUXSEG5EI64_V_M2_M1,
          6205 => Opcode::PseudoVLUXSEG5EI64_V_M2_M1_MASK,
          6206 => Opcode::PseudoVLUXSEG5EI64_V_M2_MF2,
          6207 => Opcode::PseudoVLUXSEG5EI64_V_M2_MF2_MASK,
          6208 => Opcode::PseudoVLUXSEG5EI64_V_M2_MF4,
          6209 => Opcode::PseudoVLUXSEG5EI64_V_M2_MF4_MASK,
          6210 => Opcode::PseudoVLUXSEG5EI64_V_M4_M1,
          6211 => Opcode::PseudoVLUXSEG5EI64_V_M4_M1_MASK,
          6212 => Opcode::PseudoVLUXSEG5EI64_V_M4_MF2,
          6213 => Opcode::PseudoVLUXSEG5EI64_V_M4_MF2_MASK,
          6214 => Opcode::PseudoVLUXSEG5EI64_V_M8_M1,
          6215 => Opcode::PseudoVLUXSEG5EI64_V_M8_M1_MASK,
          6216 => Opcode::PseudoVLUXSEG5EI8_V_M1_M1,
          6217 => Opcode::PseudoVLUXSEG5EI8_V_M1_M1_MASK,
          6218 => Opcode::PseudoVLUXSEG5EI8_V_MF2_M1,
          6219 => Opcode::PseudoVLUXSEG5EI8_V_MF2_M1_MASK,
          6220 => Opcode::PseudoVLUXSEG5EI8_V_MF2_MF2,
          6221 => Opcode::PseudoVLUXSEG5EI8_V_MF2_MF2_MASK,
          6222 => Opcode::PseudoVLUXSEG5EI8_V_MF4_M1,
          6223 => Opcode::PseudoVLUXSEG5EI8_V_MF4_M1_MASK,
          6224 => Opcode::PseudoVLUXSEG5EI8_V_MF4_MF2,
          6225 => Opcode::PseudoVLUXSEG5EI8_V_MF4_MF2_MASK,
          6226 => Opcode::PseudoVLUXSEG5EI8_V_MF4_MF4,
          6227 => Opcode::PseudoVLUXSEG5EI8_V_MF4_MF4_MASK,
          6228 => Opcode::PseudoVLUXSEG5EI8_V_MF8_M1,
          6229 => Opcode::PseudoVLUXSEG5EI8_V_MF8_M1_MASK,
          6230 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF2,
          6231 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF2_MASK,
          6232 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF4,
          6233 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF4_MASK,
          6234 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF8,
          6235 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF8_MASK,
          6236 => Opcode::PseudoVLUXSEG6EI16_V_M1_M1,
          6237 => Opcode::PseudoVLUXSEG6EI16_V_M1_M1_MASK,
          6238 => Opcode::PseudoVLUXSEG6EI16_V_M1_MF2,
          6239 => Opcode::PseudoVLUXSEG6EI16_V_M1_MF2_MASK,
          6240 => Opcode::PseudoVLUXSEG6EI16_V_M2_M1,
          6241 => Opcode::PseudoVLUXSEG6EI16_V_M2_M1_MASK,
          6242 => Opcode::PseudoVLUXSEG6EI16_V_MF2_M1,
          6243 => Opcode::PseudoVLUXSEG6EI16_V_MF2_M1_MASK,
          6244 => Opcode::PseudoVLUXSEG6EI16_V_MF2_MF2,
          6245 => Opcode::PseudoVLUXSEG6EI16_V_MF2_MF2_MASK,
          6246 => Opcode::PseudoVLUXSEG6EI16_V_MF2_MF4,
          6247 => Opcode::PseudoVLUXSEG6EI16_V_MF2_MF4_MASK,
          6248 => Opcode::PseudoVLUXSEG6EI16_V_MF4_M1,
          6249 => Opcode::PseudoVLUXSEG6EI16_V_MF4_M1_MASK,
          6250 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF2,
          6251 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF2_MASK,
          6252 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF4,
          6253 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF4_MASK,
          6254 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF8,
          6255 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF8_MASK,
          6256 => Opcode::PseudoVLUXSEG6EI32_V_M1_M1,
          6257 => Opcode::PseudoVLUXSEG6EI32_V_M1_M1_MASK,
          6258 => Opcode::PseudoVLUXSEG6EI32_V_M1_MF2,
          6259 => Opcode::PseudoVLUXSEG6EI32_V_M1_MF2_MASK,
          6260 => Opcode::PseudoVLUXSEG6EI32_V_M1_MF4,
          6261 => Opcode::PseudoVLUXSEG6EI32_V_M1_MF4_MASK,
          6262 => Opcode::PseudoVLUXSEG6EI32_V_M2_M1,
          6263 => Opcode::PseudoVLUXSEG6EI32_V_M2_M1_MASK,
          6264 => Opcode::PseudoVLUXSEG6EI32_V_M2_MF2,
          6265 => Opcode::PseudoVLUXSEG6EI32_V_M2_MF2_MASK,
          6266 => Opcode::PseudoVLUXSEG6EI32_V_M4_M1,
          6267 => Opcode::PseudoVLUXSEG6EI32_V_M4_M1_MASK,
          6268 => Opcode::PseudoVLUXSEG6EI32_V_MF2_M1,
          6269 => Opcode::PseudoVLUXSEG6EI32_V_MF2_M1_MASK,
          6270 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF2,
          6271 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF2_MASK,
          6272 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF4,
          6273 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF4_MASK,
          6274 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF8,
          6275 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF8_MASK,
          6276 => Opcode::PseudoVLUXSEG6EI64_V_M1_M1,
          6277 => Opcode::PseudoVLUXSEG6EI64_V_M1_M1_MASK,
          6278 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF2,
          6279 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF2_MASK,
          6280 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF4,
          6281 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF4_MASK,
          6282 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF8,
          6283 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF8_MASK,
          6284 => Opcode::PseudoVLUXSEG6EI64_V_M2_M1,
          6285 => Opcode::PseudoVLUXSEG6EI64_V_M2_M1_MASK,
          6286 => Opcode::PseudoVLUXSEG6EI64_V_M2_MF2,
          6287 => Opcode::PseudoVLUXSEG6EI64_V_M2_MF2_MASK,
          6288 => Opcode::PseudoVLUXSEG6EI64_V_M2_MF4,
          6289 => Opcode::PseudoVLUXSEG6EI64_V_M2_MF4_MASK,
          6290 => Opcode::PseudoVLUXSEG6EI64_V_M4_M1,
          6291 => Opcode::PseudoVLUXSEG6EI64_V_M4_M1_MASK,
          6292 => Opcode::PseudoVLUXSEG6EI64_V_M4_MF2,
          6293 => Opcode::PseudoVLUXSEG6EI64_V_M4_MF2_MASK,
          6294 => Opcode::PseudoVLUXSEG6EI64_V_M8_M1,
          6295 => Opcode::PseudoVLUXSEG6EI64_V_M8_M1_MASK,
          6296 => Opcode::PseudoVLUXSEG6EI8_V_M1_M1,
          6297 => Opcode::PseudoVLUXSEG6EI8_V_M1_M1_MASK,
          6298 => Opcode::PseudoVLUXSEG6EI8_V_MF2_M1,
          6299 => Opcode::PseudoVLUXSEG6EI8_V_MF2_M1_MASK,
          6300 => Opcode::PseudoVLUXSEG6EI8_V_MF2_MF2,
          6301 => Opcode::PseudoVLUXSEG6EI8_V_MF2_MF2_MASK,
          6302 => Opcode::PseudoVLUXSEG6EI8_V_MF4_M1,
          6303 => Opcode::PseudoVLUXSEG6EI8_V_MF4_M1_MASK,
          6304 => Opcode::PseudoVLUXSEG6EI8_V_MF4_MF2,
          6305 => Opcode::PseudoVLUXSEG6EI8_V_MF4_MF2_MASK,
          6306 => Opcode::PseudoVLUXSEG6EI8_V_MF4_MF4,
          6307 => Opcode::PseudoVLUXSEG6EI8_V_MF4_MF4_MASK,
          6308 => Opcode::PseudoVLUXSEG6EI8_V_MF8_M1,
          6309 => Opcode::PseudoVLUXSEG6EI8_V_MF8_M1_MASK,
          6310 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF2,
          6311 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF2_MASK,
          6312 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF4,
          6313 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF4_MASK,
          6314 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF8,
          6315 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF8_MASK,
          6316 => Opcode::PseudoVLUXSEG7EI16_V_M1_M1,
          6317 => Opcode::PseudoVLUXSEG7EI16_V_M1_M1_MASK,
          6318 => Opcode::PseudoVLUXSEG7EI16_V_M1_MF2,
          6319 => Opcode::PseudoVLUXSEG7EI16_V_M1_MF2_MASK,
          6320 => Opcode::PseudoVLUXSEG7EI16_V_M2_M1,
          6321 => Opcode::PseudoVLUXSEG7EI16_V_M2_M1_MASK,
          6322 => Opcode::PseudoVLUXSEG7EI16_V_MF2_M1,
          6323 => Opcode::PseudoVLUXSEG7EI16_V_MF2_M1_MASK,
          6324 => Opcode::PseudoVLUXSEG7EI16_V_MF2_MF2,
          6325 => Opcode::PseudoVLUXSEG7EI16_V_MF2_MF2_MASK,
          6326 => Opcode::PseudoVLUXSEG7EI16_V_MF2_MF4,
          6327 => Opcode::PseudoVLUXSEG7EI16_V_MF2_MF4_MASK,
          6328 => Opcode::PseudoVLUXSEG7EI16_V_MF4_M1,
          6329 => Opcode::PseudoVLUXSEG7EI16_V_MF4_M1_MASK,
          6330 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF2,
          6331 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF2_MASK,
          6332 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF4,
          6333 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF4_MASK,
          6334 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF8,
          6335 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF8_MASK,
          6336 => Opcode::PseudoVLUXSEG7EI32_V_M1_M1,
          6337 => Opcode::PseudoVLUXSEG7EI32_V_M1_M1_MASK,
          6338 => Opcode::PseudoVLUXSEG7EI32_V_M1_MF2,
          6339 => Opcode::PseudoVLUXSEG7EI32_V_M1_MF2_MASK,
          6340 => Opcode::PseudoVLUXSEG7EI32_V_M1_MF4,
          6341 => Opcode::PseudoVLUXSEG7EI32_V_M1_MF4_MASK,
          6342 => Opcode::PseudoVLUXSEG7EI32_V_M2_M1,
          6343 => Opcode::PseudoVLUXSEG7EI32_V_M2_M1_MASK,
          6344 => Opcode::PseudoVLUXSEG7EI32_V_M2_MF2,
          6345 => Opcode::PseudoVLUXSEG7EI32_V_M2_MF2_MASK,
          6346 => Opcode::PseudoVLUXSEG7EI32_V_M4_M1,
          6347 => Opcode::PseudoVLUXSEG7EI32_V_M4_M1_MASK,
          6348 => Opcode::PseudoVLUXSEG7EI32_V_MF2_M1,
          6349 => Opcode::PseudoVLUXSEG7EI32_V_MF2_M1_MASK,
          6350 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF2,
          6351 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF2_MASK,
          6352 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF4,
          6353 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF4_MASK,
          6354 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF8,
          6355 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF8_MASK,
          6356 => Opcode::PseudoVLUXSEG7EI64_V_M1_M1,
          6357 => Opcode::PseudoVLUXSEG7EI64_V_M1_M1_MASK,
          6358 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF2,
          6359 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF2_MASK,
          6360 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF4,
          6361 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF4_MASK,
          6362 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF8,
          6363 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF8_MASK,
          6364 => Opcode::PseudoVLUXSEG7EI64_V_M2_M1,
          6365 => Opcode::PseudoVLUXSEG7EI64_V_M2_M1_MASK,
          6366 => Opcode::PseudoVLUXSEG7EI64_V_M2_MF2,
          6367 => Opcode::PseudoVLUXSEG7EI64_V_M2_MF2_MASK,
          6368 => Opcode::PseudoVLUXSEG7EI64_V_M2_MF4,
          6369 => Opcode::PseudoVLUXSEG7EI64_V_M2_MF4_MASK,
          6370 => Opcode::PseudoVLUXSEG7EI64_V_M4_M1,
          6371 => Opcode::PseudoVLUXSEG7EI64_V_M4_M1_MASK,
          6372 => Opcode::PseudoVLUXSEG7EI64_V_M4_MF2,
          6373 => Opcode::PseudoVLUXSEG7EI64_V_M4_MF2_MASK,
          6374 => Opcode::PseudoVLUXSEG7EI64_V_M8_M1,
          6375 => Opcode::PseudoVLUXSEG7EI64_V_M8_M1_MASK,
          6376 => Opcode::PseudoVLUXSEG7EI8_V_M1_M1,
          6377 => Opcode::PseudoVLUXSEG7EI8_V_M1_M1_MASK,
          6378 => Opcode::PseudoVLUXSEG7EI8_V_MF2_M1,
          6379 => Opcode::PseudoVLUXSEG7EI8_V_MF2_M1_MASK,
          6380 => Opcode::PseudoVLUXSEG7EI8_V_MF2_MF2,
          6381 => Opcode::PseudoVLUXSEG7EI8_V_MF2_MF2_MASK,
          6382 => Opcode::PseudoVLUXSEG7EI8_V_MF4_M1,
          6383 => Opcode::PseudoVLUXSEG7EI8_V_MF4_M1_MASK,
          6384 => Opcode::PseudoVLUXSEG7EI8_V_MF4_MF2,
          6385 => Opcode::PseudoVLUXSEG7EI8_V_MF4_MF2_MASK,
          6386 => Opcode::PseudoVLUXSEG7EI8_V_MF4_MF4,
          6387 => Opcode::PseudoVLUXSEG7EI8_V_MF4_MF4_MASK,
          6388 => Opcode::PseudoVLUXSEG7EI8_V_MF8_M1,
          6389 => Opcode::PseudoVLUXSEG7EI8_V_MF8_M1_MASK,
          6390 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF2,
          6391 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF2_MASK,
          6392 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF4,
          6393 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF4_MASK,
          6394 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF8,
          6395 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF8_MASK,
          6396 => Opcode::PseudoVLUXSEG8EI16_V_M1_M1,
          6397 => Opcode::PseudoVLUXSEG8EI16_V_M1_M1_MASK,
          6398 => Opcode::PseudoVLUXSEG8EI16_V_M1_MF2,
          6399 => Opcode::PseudoVLUXSEG8EI16_V_M1_MF2_MASK,
          6400 => Opcode::PseudoVLUXSEG8EI16_V_M2_M1,
          6401 => Opcode::PseudoVLUXSEG8EI16_V_M2_M1_MASK,
          6402 => Opcode::PseudoVLUXSEG8EI16_V_MF2_M1,
          6403 => Opcode::PseudoVLUXSEG8EI16_V_MF2_M1_MASK,
          6404 => Opcode::PseudoVLUXSEG8EI16_V_MF2_MF2,
          6405 => Opcode::PseudoVLUXSEG8EI16_V_MF2_MF2_MASK,
          6406 => Opcode::PseudoVLUXSEG8EI16_V_MF2_MF4,
          6407 => Opcode::PseudoVLUXSEG8EI16_V_MF2_MF4_MASK,
          6408 => Opcode::PseudoVLUXSEG8EI16_V_MF4_M1,
          6409 => Opcode::PseudoVLUXSEG8EI16_V_MF4_M1_MASK,
          6410 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF2,
          6411 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF2_MASK,
          6412 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF4,
          6413 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF4_MASK,
          6414 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF8,
          6415 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF8_MASK,
          6416 => Opcode::PseudoVLUXSEG8EI32_V_M1_M1,
          6417 => Opcode::PseudoVLUXSEG8EI32_V_M1_M1_MASK,
          6418 => Opcode::PseudoVLUXSEG8EI32_V_M1_MF2,
          6419 => Opcode::PseudoVLUXSEG8EI32_V_M1_MF2_MASK,
          6420 => Opcode::PseudoVLUXSEG8EI32_V_M1_MF4,
          6421 => Opcode::PseudoVLUXSEG8EI32_V_M1_MF4_MASK,
          6422 => Opcode::PseudoVLUXSEG8EI32_V_M2_M1,
          6423 => Opcode::PseudoVLUXSEG8EI32_V_M2_M1_MASK,
          6424 => Opcode::PseudoVLUXSEG8EI32_V_M2_MF2,
          6425 => Opcode::PseudoVLUXSEG8EI32_V_M2_MF2_MASK,
          6426 => Opcode::PseudoVLUXSEG8EI32_V_M4_M1,
          6427 => Opcode::PseudoVLUXSEG8EI32_V_M4_M1_MASK,
          6428 => Opcode::PseudoVLUXSEG8EI32_V_MF2_M1,
          6429 => Opcode::PseudoVLUXSEG8EI32_V_MF2_M1_MASK,
          6430 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF2,
          6431 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF2_MASK,
          6432 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF4,
          6433 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF4_MASK,
          6434 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF8,
          6435 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF8_MASK,
          6436 => Opcode::PseudoVLUXSEG8EI64_V_M1_M1,
          6437 => Opcode::PseudoVLUXSEG8EI64_V_M1_M1_MASK,
          6438 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF2,
          6439 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF2_MASK,
          6440 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF4,
          6441 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF4_MASK,
          6442 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF8,
          6443 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF8_MASK,
          6444 => Opcode::PseudoVLUXSEG8EI64_V_M2_M1,
          6445 => Opcode::PseudoVLUXSEG8EI64_V_M2_M1_MASK,
          6446 => Opcode::PseudoVLUXSEG8EI64_V_M2_MF2,
          6447 => Opcode::PseudoVLUXSEG8EI64_V_M2_MF2_MASK,
          6448 => Opcode::PseudoVLUXSEG8EI64_V_M2_MF4,
          6449 => Opcode::PseudoVLUXSEG8EI64_V_M2_MF4_MASK,
          6450 => Opcode::PseudoVLUXSEG8EI64_V_M4_M1,
          6451 => Opcode::PseudoVLUXSEG8EI64_V_M4_M1_MASK,
          6452 => Opcode::PseudoVLUXSEG8EI64_V_M4_MF2,
          6453 => Opcode::PseudoVLUXSEG8EI64_V_M4_MF2_MASK,
          6454 => Opcode::PseudoVLUXSEG8EI64_V_M8_M1,
          6455 => Opcode::PseudoVLUXSEG8EI64_V_M8_M1_MASK,
          6456 => Opcode::PseudoVLUXSEG8EI8_V_M1_M1,
          6457 => Opcode::PseudoVLUXSEG8EI8_V_M1_M1_MASK,
          6458 => Opcode::PseudoVLUXSEG8EI8_V_MF2_M1,
          6459 => Opcode::PseudoVLUXSEG8EI8_V_MF2_M1_MASK,
          6460 => Opcode::PseudoVLUXSEG8EI8_V_MF2_MF2,
          6461 => Opcode::PseudoVLUXSEG8EI8_V_MF2_MF2_MASK,
          6462 => Opcode::PseudoVLUXSEG8EI8_V_MF4_M1,
          6463 => Opcode::PseudoVLUXSEG8EI8_V_MF4_M1_MASK,
          6464 => Opcode::PseudoVLUXSEG8EI8_V_MF4_MF2,
          6465 => Opcode::PseudoVLUXSEG8EI8_V_MF4_MF2_MASK,
          6466 => Opcode::PseudoVLUXSEG8EI8_V_MF4_MF4,
          6467 => Opcode::PseudoVLUXSEG8EI8_V_MF4_MF4_MASK,
          6468 => Opcode::PseudoVLUXSEG8EI8_V_MF8_M1,
          6469 => Opcode::PseudoVLUXSEG8EI8_V_MF8_M1_MASK,
          6470 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF2,
          6471 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF2_MASK,
          6472 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF4,
          6473 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF4_MASK,
          6474 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF8,
          6475 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF8_MASK,
          6476 => Opcode::PseudoVMACC_VV_M1,
          6477 => Opcode::PseudoVMACC_VV_M1_MASK,
          6478 => Opcode::PseudoVMACC_VV_M2,
          6479 => Opcode::PseudoVMACC_VV_M2_MASK,
          6480 => Opcode::PseudoVMACC_VV_M4,
          6481 => Opcode::PseudoVMACC_VV_M4_MASK,
          6482 => Opcode::PseudoVMACC_VV_M8,
          6483 => Opcode::PseudoVMACC_VV_M8_MASK,
          6484 => Opcode::PseudoVMACC_VV_MF2,
          6485 => Opcode::PseudoVMACC_VV_MF2_MASK,
          6486 => Opcode::PseudoVMACC_VV_MF4,
          6487 => Opcode::PseudoVMACC_VV_MF4_MASK,
          6488 => Opcode::PseudoVMACC_VV_MF8,
          6489 => Opcode::PseudoVMACC_VV_MF8_MASK,
          6490 => Opcode::PseudoVMACC_VX_M1,
          6491 => Opcode::PseudoVMACC_VX_M1_MASK,
          6492 => Opcode::PseudoVMACC_VX_M2,
          6493 => Opcode::PseudoVMACC_VX_M2_MASK,
          6494 => Opcode::PseudoVMACC_VX_M4,
          6495 => Opcode::PseudoVMACC_VX_M4_MASK,
          6496 => Opcode::PseudoVMACC_VX_M8,
          6497 => Opcode::PseudoVMACC_VX_M8_MASK,
          6498 => Opcode::PseudoVMACC_VX_MF2,
          6499 => Opcode::PseudoVMACC_VX_MF2_MASK,
          6500 => Opcode::PseudoVMACC_VX_MF4,
          6501 => Opcode::PseudoVMACC_VX_MF4_MASK,
          6502 => Opcode::PseudoVMACC_VX_MF8,
          6503 => Opcode::PseudoVMACC_VX_MF8_MASK,
          6504 => Opcode::PseudoVMADC_VIM_M1,
          6505 => Opcode::PseudoVMADC_VIM_M2,
          6506 => Opcode::PseudoVMADC_VIM_M4,
          6507 => Opcode::PseudoVMADC_VIM_M8,
          6508 => Opcode::PseudoVMADC_VIM_MF2,
          6509 => Opcode::PseudoVMADC_VIM_MF4,
          6510 => Opcode::PseudoVMADC_VIM_MF8,
          6511 => Opcode::PseudoVMADC_VI_M1,
          6512 => Opcode::PseudoVMADC_VI_M2,
          6513 => Opcode::PseudoVMADC_VI_M4,
          6514 => Opcode::PseudoVMADC_VI_M8,
          6515 => Opcode::PseudoVMADC_VI_MF2,
          6516 => Opcode::PseudoVMADC_VI_MF4,
          6517 => Opcode::PseudoVMADC_VI_MF8,
          6518 => Opcode::PseudoVMADC_VVM_M1,
          6519 => Opcode::PseudoVMADC_VVM_M2,
          6520 => Opcode::PseudoVMADC_VVM_M4,
          6521 => Opcode::PseudoVMADC_VVM_M8,
          6522 => Opcode::PseudoVMADC_VVM_MF2,
          6523 => Opcode::PseudoVMADC_VVM_MF4,
          6524 => Opcode::PseudoVMADC_VVM_MF8,
          6525 => Opcode::PseudoVMADC_VV_M1,
          6526 => Opcode::PseudoVMADC_VV_M2,
          6527 => Opcode::PseudoVMADC_VV_M4,
          6528 => Opcode::PseudoVMADC_VV_M8,
          6529 => Opcode::PseudoVMADC_VV_MF2,
          6530 => Opcode::PseudoVMADC_VV_MF4,
          6531 => Opcode::PseudoVMADC_VV_MF8,
          6532 => Opcode::PseudoVMADC_VXM_M1,
          6533 => Opcode::PseudoVMADC_VXM_M2,
          6534 => Opcode::PseudoVMADC_VXM_M4,
          6535 => Opcode::PseudoVMADC_VXM_M8,
          6536 => Opcode::PseudoVMADC_VXM_MF2,
          6537 => Opcode::PseudoVMADC_VXM_MF4,
          6538 => Opcode::PseudoVMADC_VXM_MF8,
          6539 => Opcode::PseudoVMADC_VX_M1,
          6540 => Opcode::PseudoVMADC_VX_M2,
          6541 => Opcode::PseudoVMADC_VX_M4,
          6542 => Opcode::PseudoVMADC_VX_M8,
          6543 => Opcode::PseudoVMADC_VX_MF2,
          6544 => Opcode::PseudoVMADC_VX_MF4,
          6545 => Opcode::PseudoVMADC_VX_MF8,
          6546 => Opcode::PseudoVMADD_VV_M1,
          6547 => Opcode::PseudoVMADD_VV_M1_MASK,
          6548 => Opcode::PseudoVMADD_VV_M2,
          6549 => Opcode::PseudoVMADD_VV_M2_MASK,
          6550 => Opcode::PseudoVMADD_VV_M4,
          6551 => Opcode::PseudoVMADD_VV_M4_MASK,
          6552 => Opcode::PseudoVMADD_VV_M8,
          6553 => Opcode::PseudoVMADD_VV_M8_MASK,
          6554 => Opcode::PseudoVMADD_VV_MF2,
          6555 => Opcode::PseudoVMADD_VV_MF2_MASK,
          6556 => Opcode::PseudoVMADD_VV_MF4,
          6557 => Opcode::PseudoVMADD_VV_MF4_MASK,
          6558 => Opcode::PseudoVMADD_VV_MF8,
          6559 => Opcode::PseudoVMADD_VV_MF8_MASK,
          6560 => Opcode::PseudoVMADD_VX_M1,
          6561 => Opcode::PseudoVMADD_VX_M1_MASK,
          6562 => Opcode::PseudoVMADD_VX_M2,
          6563 => Opcode::PseudoVMADD_VX_M2_MASK,
          6564 => Opcode::PseudoVMADD_VX_M4,
          6565 => Opcode::PseudoVMADD_VX_M4_MASK,
          6566 => Opcode::PseudoVMADD_VX_M8,
          6567 => Opcode::PseudoVMADD_VX_M8_MASK,
          6568 => Opcode::PseudoVMADD_VX_MF2,
          6569 => Opcode::PseudoVMADD_VX_MF2_MASK,
          6570 => Opcode::PseudoVMADD_VX_MF4,
          6571 => Opcode::PseudoVMADD_VX_MF4_MASK,
          6572 => Opcode::PseudoVMADD_VX_MF8,
          6573 => Opcode::PseudoVMADD_VX_MF8_MASK,
          6574 => Opcode::PseudoVMANDN_MM_B1,
          6575 => Opcode::PseudoVMANDN_MM_B16,
          6576 => Opcode::PseudoVMANDN_MM_B2,
          6577 => Opcode::PseudoVMANDN_MM_B32,
          6578 => Opcode::PseudoVMANDN_MM_B4,
          6579 => Opcode::PseudoVMANDN_MM_B64,
          6580 => Opcode::PseudoVMANDN_MM_B8,
          6581 => Opcode::PseudoVMAND_MM_B1,
          6582 => Opcode::PseudoVMAND_MM_B16,
          6583 => Opcode::PseudoVMAND_MM_B2,
          6584 => Opcode::PseudoVMAND_MM_B32,
          6585 => Opcode::PseudoVMAND_MM_B4,
          6586 => Opcode::PseudoVMAND_MM_B64,
          6587 => Opcode::PseudoVMAND_MM_B8,
          6588 => Opcode::PseudoVMAXU_VV_M1,
          6589 => Opcode::PseudoVMAXU_VV_M1_MASK,
          6590 => Opcode::PseudoVMAXU_VV_M2,
          6591 => Opcode::PseudoVMAXU_VV_M2_MASK,
          6592 => Opcode::PseudoVMAXU_VV_M4,
          6593 => Opcode::PseudoVMAXU_VV_M4_MASK,
          6594 => Opcode::PseudoVMAXU_VV_M8,
          6595 => Opcode::PseudoVMAXU_VV_M8_MASK,
          6596 => Opcode::PseudoVMAXU_VV_MF2,
          6597 => Opcode::PseudoVMAXU_VV_MF2_MASK,
          6598 => Opcode::PseudoVMAXU_VV_MF4,
          6599 => Opcode::PseudoVMAXU_VV_MF4_MASK,
          6600 => Opcode::PseudoVMAXU_VV_MF8,
          6601 => Opcode::PseudoVMAXU_VV_MF8_MASK,
          6602 => Opcode::PseudoVMAXU_VX_M1,
          6603 => Opcode::PseudoVMAXU_VX_M1_MASK,
          6604 => Opcode::PseudoVMAXU_VX_M2,
          6605 => Opcode::PseudoVMAXU_VX_M2_MASK,
          6606 => Opcode::PseudoVMAXU_VX_M4,
          6607 => Opcode::PseudoVMAXU_VX_M4_MASK,
          6608 => Opcode::PseudoVMAXU_VX_M8,
          6609 => Opcode::PseudoVMAXU_VX_M8_MASK,
          6610 => Opcode::PseudoVMAXU_VX_MF2,
          6611 => Opcode::PseudoVMAXU_VX_MF2_MASK,
          6612 => Opcode::PseudoVMAXU_VX_MF4,
          6613 => Opcode::PseudoVMAXU_VX_MF4_MASK,
          6614 => Opcode::PseudoVMAXU_VX_MF8,
          6615 => Opcode::PseudoVMAXU_VX_MF8_MASK,
          6616 => Opcode::PseudoVMAX_VV_M1,
          6617 => Opcode::PseudoVMAX_VV_M1_MASK,
          6618 => Opcode::PseudoVMAX_VV_M2,
          6619 => Opcode::PseudoVMAX_VV_M2_MASK,
          6620 => Opcode::PseudoVMAX_VV_M4,
          6621 => Opcode::PseudoVMAX_VV_M4_MASK,
          6622 => Opcode::PseudoVMAX_VV_M8,
          6623 => Opcode::PseudoVMAX_VV_M8_MASK,
          6624 => Opcode::PseudoVMAX_VV_MF2,
          6625 => Opcode::PseudoVMAX_VV_MF2_MASK,
          6626 => Opcode::PseudoVMAX_VV_MF4,
          6627 => Opcode::PseudoVMAX_VV_MF4_MASK,
          6628 => Opcode::PseudoVMAX_VV_MF8,
          6629 => Opcode::PseudoVMAX_VV_MF8_MASK,
          6630 => Opcode::PseudoVMAX_VX_M1,
          6631 => Opcode::PseudoVMAX_VX_M1_MASK,
          6632 => Opcode::PseudoVMAX_VX_M2,
          6633 => Opcode::PseudoVMAX_VX_M2_MASK,
          6634 => Opcode::PseudoVMAX_VX_M4,
          6635 => Opcode::PseudoVMAX_VX_M4_MASK,
          6636 => Opcode::PseudoVMAX_VX_M8,
          6637 => Opcode::PseudoVMAX_VX_M8_MASK,
          6638 => Opcode::PseudoVMAX_VX_MF2,
          6639 => Opcode::PseudoVMAX_VX_MF2_MASK,
          6640 => Opcode::PseudoVMAX_VX_MF4,
          6641 => Opcode::PseudoVMAX_VX_MF4_MASK,
          6642 => Opcode::PseudoVMAX_VX_MF8,
          6643 => Opcode::PseudoVMAX_VX_MF8_MASK,
          6644 => Opcode::PseudoVMCLR_M_B1,
          6645 => Opcode::PseudoVMCLR_M_B16,
          6646 => Opcode::PseudoVMCLR_M_B2,
          6647 => Opcode::PseudoVMCLR_M_B32,
          6648 => Opcode::PseudoVMCLR_M_B4,
          6649 => Opcode::PseudoVMCLR_M_B64,
          6650 => Opcode::PseudoVMCLR_M_B8,
          6651 => Opcode::PseudoVMERGE_VIM_M1,
          6652 => Opcode::PseudoVMERGE_VIM_M2,
          6653 => Opcode::PseudoVMERGE_VIM_M4,
          6654 => Opcode::PseudoVMERGE_VIM_M8,
          6655 => Opcode::PseudoVMERGE_VIM_MF2,
          6656 => Opcode::PseudoVMERGE_VIM_MF4,
          6657 => Opcode::PseudoVMERGE_VIM_MF8,
          6658 => Opcode::PseudoVMERGE_VVM_M1,
          6659 => Opcode::PseudoVMERGE_VVM_M2,
          6660 => Opcode::PseudoVMERGE_VVM_M4,
          6661 => Opcode::PseudoVMERGE_VVM_M8,
          6662 => Opcode::PseudoVMERGE_VVM_MF2,
          6663 => Opcode::PseudoVMERGE_VVM_MF4,
          6664 => Opcode::PseudoVMERGE_VVM_MF8,
          6665 => Opcode::PseudoVMERGE_VXM_M1,
          6666 => Opcode::PseudoVMERGE_VXM_M2,
          6667 => Opcode::PseudoVMERGE_VXM_M4,
          6668 => Opcode::PseudoVMERGE_VXM_M8,
          6669 => Opcode::PseudoVMERGE_VXM_MF2,
          6670 => Opcode::PseudoVMERGE_VXM_MF4,
          6671 => Opcode::PseudoVMERGE_VXM_MF8,
          6672 => Opcode::PseudoVMFEQ_VFPR16_M1,
          6673 => Opcode::PseudoVMFEQ_VFPR16_M1_MASK,
          6674 => Opcode::PseudoVMFEQ_VFPR16_M2,
          6675 => Opcode::PseudoVMFEQ_VFPR16_M2_MASK,
          6676 => Opcode::PseudoVMFEQ_VFPR16_M4,
          6677 => Opcode::PseudoVMFEQ_VFPR16_M4_MASK,
          6678 => Opcode::PseudoVMFEQ_VFPR16_M8,
          6679 => Opcode::PseudoVMFEQ_VFPR16_M8_MASK,
          6680 => Opcode::PseudoVMFEQ_VFPR16_MF2,
          6681 => Opcode::PseudoVMFEQ_VFPR16_MF2_MASK,
          6682 => Opcode::PseudoVMFEQ_VFPR16_MF4,
          6683 => Opcode::PseudoVMFEQ_VFPR16_MF4_MASK,
          6684 => Opcode::PseudoVMFEQ_VFPR32_M1,
          6685 => Opcode::PseudoVMFEQ_VFPR32_M1_MASK,
          6686 => Opcode::PseudoVMFEQ_VFPR32_M2,
          6687 => Opcode::PseudoVMFEQ_VFPR32_M2_MASK,
          6688 => Opcode::PseudoVMFEQ_VFPR32_M4,
          6689 => Opcode::PseudoVMFEQ_VFPR32_M4_MASK,
          6690 => Opcode::PseudoVMFEQ_VFPR32_M8,
          6691 => Opcode::PseudoVMFEQ_VFPR32_M8_MASK,
          6692 => Opcode::PseudoVMFEQ_VFPR32_MF2,
          6693 => Opcode::PseudoVMFEQ_VFPR32_MF2_MASK,
          6694 => Opcode::PseudoVMFEQ_VFPR64_M1,
          6695 => Opcode::PseudoVMFEQ_VFPR64_M1_MASK,
          6696 => Opcode::PseudoVMFEQ_VFPR64_M2,
          6697 => Opcode::PseudoVMFEQ_VFPR64_M2_MASK,
          6698 => Opcode::PseudoVMFEQ_VFPR64_M4,
          6699 => Opcode::PseudoVMFEQ_VFPR64_M4_MASK,
          6700 => Opcode::PseudoVMFEQ_VFPR64_M8,
          6701 => Opcode::PseudoVMFEQ_VFPR64_M8_MASK,
          6702 => Opcode::PseudoVMFEQ_VV_M1,
          6703 => Opcode::PseudoVMFEQ_VV_M1_MASK,
          6704 => Opcode::PseudoVMFEQ_VV_M2,
          6705 => Opcode::PseudoVMFEQ_VV_M2_MASK,
          6706 => Opcode::PseudoVMFEQ_VV_M4,
          6707 => Opcode::PseudoVMFEQ_VV_M4_MASK,
          6708 => Opcode::PseudoVMFEQ_VV_M8,
          6709 => Opcode::PseudoVMFEQ_VV_M8_MASK,
          6710 => Opcode::PseudoVMFEQ_VV_MF2,
          6711 => Opcode::PseudoVMFEQ_VV_MF2_MASK,
          6712 => Opcode::PseudoVMFEQ_VV_MF4,
          6713 => Opcode::PseudoVMFEQ_VV_MF4_MASK,
          6714 => Opcode::PseudoVMFGE_VFPR16_M1,
          6715 => Opcode::PseudoVMFGE_VFPR16_M1_MASK,
          6716 => Opcode::PseudoVMFGE_VFPR16_M2,
          6717 => Opcode::PseudoVMFGE_VFPR16_M2_MASK,
          6718 => Opcode::PseudoVMFGE_VFPR16_M4,
          6719 => Opcode::PseudoVMFGE_VFPR16_M4_MASK,
          6720 => Opcode::PseudoVMFGE_VFPR16_M8,
          6721 => Opcode::PseudoVMFGE_VFPR16_M8_MASK,
          6722 => Opcode::PseudoVMFGE_VFPR16_MF2,
          6723 => Opcode::PseudoVMFGE_VFPR16_MF2_MASK,
          6724 => Opcode::PseudoVMFGE_VFPR16_MF4,
          6725 => Opcode::PseudoVMFGE_VFPR16_MF4_MASK,
          6726 => Opcode::PseudoVMFGE_VFPR32_M1,
          6727 => Opcode::PseudoVMFGE_VFPR32_M1_MASK,
          6728 => Opcode::PseudoVMFGE_VFPR32_M2,
          6729 => Opcode::PseudoVMFGE_VFPR32_M2_MASK,
          6730 => Opcode::PseudoVMFGE_VFPR32_M4,
          6731 => Opcode::PseudoVMFGE_VFPR32_M4_MASK,
          6732 => Opcode::PseudoVMFGE_VFPR32_M8,
          6733 => Opcode::PseudoVMFGE_VFPR32_M8_MASK,
          6734 => Opcode::PseudoVMFGE_VFPR32_MF2,
          6735 => Opcode::PseudoVMFGE_VFPR32_MF2_MASK,
          6736 => Opcode::PseudoVMFGE_VFPR64_M1,
          6737 => Opcode::PseudoVMFGE_VFPR64_M1_MASK,
          6738 => Opcode::PseudoVMFGE_VFPR64_M2,
          6739 => Opcode::PseudoVMFGE_VFPR64_M2_MASK,
          6740 => Opcode::PseudoVMFGE_VFPR64_M4,
          6741 => Opcode::PseudoVMFGE_VFPR64_M4_MASK,
          6742 => Opcode::PseudoVMFGE_VFPR64_M8,
          6743 => Opcode::PseudoVMFGE_VFPR64_M8_MASK,
          6744 => Opcode::PseudoVMFGT_VFPR16_M1,
          6745 => Opcode::PseudoVMFGT_VFPR16_M1_MASK,
          6746 => Opcode::PseudoVMFGT_VFPR16_M2,
          6747 => Opcode::PseudoVMFGT_VFPR16_M2_MASK,
          6748 => Opcode::PseudoVMFGT_VFPR16_M4,
          6749 => Opcode::PseudoVMFGT_VFPR16_M4_MASK,
          6750 => Opcode::PseudoVMFGT_VFPR16_M8,
          6751 => Opcode::PseudoVMFGT_VFPR16_M8_MASK,
          6752 => Opcode::PseudoVMFGT_VFPR16_MF2,
          6753 => Opcode::PseudoVMFGT_VFPR16_MF2_MASK,
          6754 => Opcode::PseudoVMFGT_VFPR16_MF4,
          6755 => Opcode::PseudoVMFGT_VFPR16_MF4_MASK,
          6756 => Opcode::PseudoVMFGT_VFPR32_M1,
          6757 => Opcode::PseudoVMFGT_VFPR32_M1_MASK,
          6758 => Opcode::PseudoVMFGT_VFPR32_M2,
          6759 => Opcode::PseudoVMFGT_VFPR32_M2_MASK,
          6760 => Opcode::PseudoVMFGT_VFPR32_M4,
          6761 => Opcode::PseudoVMFGT_VFPR32_M4_MASK,
          6762 => Opcode::PseudoVMFGT_VFPR32_M8,
          6763 => Opcode::PseudoVMFGT_VFPR32_M8_MASK,
          6764 => Opcode::PseudoVMFGT_VFPR32_MF2,
          6765 => Opcode::PseudoVMFGT_VFPR32_MF2_MASK,
          6766 => Opcode::PseudoVMFGT_VFPR64_M1,
          6767 => Opcode::PseudoVMFGT_VFPR64_M1_MASK,
          6768 => Opcode::PseudoVMFGT_VFPR64_M2,
          6769 => Opcode::PseudoVMFGT_VFPR64_M2_MASK,
          6770 => Opcode::PseudoVMFGT_VFPR64_M4,
          6771 => Opcode::PseudoVMFGT_VFPR64_M4_MASK,
          6772 => Opcode::PseudoVMFGT_VFPR64_M8,
          6773 => Opcode::PseudoVMFGT_VFPR64_M8_MASK,
          6774 => Opcode::PseudoVMFLE_VFPR16_M1,
          6775 => Opcode::PseudoVMFLE_VFPR16_M1_MASK,
          6776 => Opcode::PseudoVMFLE_VFPR16_M2,
          6777 => Opcode::PseudoVMFLE_VFPR16_M2_MASK,
          6778 => Opcode::PseudoVMFLE_VFPR16_M4,
          6779 => Opcode::PseudoVMFLE_VFPR16_M4_MASK,
          6780 => Opcode::PseudoVMFLE_VFPR16_M8,
          6781 => Opcode::PseudoVMFLE_VFPR16_M8_MASK,
          6782 => Opcode::PseudoVMFLE_VFPR16_MF2,
          6783 => Opcode::PseudoVMFLE_VFPR16_MF2_MASK,
          6784 => Opcode::PseudoVMFLE_VFPR16_MF4,
          6785 => Opcode::PseudoVMFLE_VFPR16_MF4_MASK,
          6786 => Opcode::PseudoVMFLE_VFPR32_M1,
          6787 => Opcode::PseudoVMFLE_VFPR32_M1_MASK,
          6788 => Opcode::PseudoVMFLE_VFPR32_M2,
          6789 => Opcode::PseudoVMFLE_VFPR32_M2_MASK,
          6790 => Opcode::PseudoVMFLE_VFPR32_M4,
          6791 => Opcode::PseudoVMFLE_VFPR32_M4_MASK,
          6792 => Opcode::PseudoVMFLE_VFPR32_M8,
          6793 => Opcode::PseudoVMFLE_VFPR32_M8_MASK,
          6794 => Opcode::PseudoVMFLE_VFPR32_MF2,
          6795 => Opcode::PseudoVMFLE_VFPR32_MF2_MASK,
          6796 => Opcode::PseudoVMFLE_VFPR64_M1,
          6797 => Opcode::PseudoVMFLE_VFPR64_M1_MASK,
          6798 => Opcode::PseudoVMFLE_VFPR64_M2,
          6799 => Opcode::PseudoVMFLE_VFPR64_M2_MASK,
          6800 => Opcode::PseudoVMFLE_VFPR64_M4,
          6801 => Opcode::PseudoVMFLE_VFPR64_M4_MASK,
          6802 => Opcode::PseudoVMFLE_VFPR64_M8,
          6803 => Opcode::PseudoVMFLE_VFPR64_M8_MASK,
          6804 => Opcode::PseudoVMFLE_VV_M1,
          6805 => Opcode::PseudoVMFLE_VV_M1_MASK,
          6806 => Opcode::PseudoVMFLE_VV_M2,
          6807 => Opcode::PseudoVMFLE_VV_M2_MASK,
          6808 => Opcode::PseudoVMFLE_VV_M4,
          6809 => Opcode::PseudoVMFLE_VV_M4_MASK,
          6810 => Opcode::PseudoVMFLE_VV_M8,
          6811 => Opcode::PseudoVMFLE_VV_M8_MASK,
          6812 => Opcode::PseudoVMFLE_VV_MF2,
          6813 => Opcode::PseudoVMFLE_VV_MF2_MASK,
          6814 => Opcode::PseudoVMFLE_VV_MF4,
          6815 => Opcode::PseudoVMFLE_VV_MF4_MASK,
          6816 => Opcode::PseudoVMFLT_VFPR16_M1,
          6817 => Opcode::PseudoVMFLT_VFPR16_M1_MASK,
          6818 => Opcode::PseudoVMFLT_VFPR16_M2,
          6819 => Opcode::PseudoVMFLT_VFPR16_M2_MASK,
          6820 => Opcode::PseudoVMFLT_VFPR16_M4,
          6821 => Opcode::PseudoVMFLT_VFPR16_M4_MASK,
          6822 => Opcode::PseudoVMFLT_VFPR16_M8,
          6823 => Opcode::PseudoVMFLT_VFPR16_M8_MASK,
          6824 => Opcode::PseudoVMFLT_VFPR16_MF2,
          6825 => Opcode::PseudoVMFLT_VFPR16_MF2_MASK,
          6826 => Opcode::PseudoVMFLT_VFPR16_MF4,
          6827 => Opcode::PseudoVMFLT_VFPR16_MF4_MASK,
          6828 => Opcode::PseudoVMFLT_VFPR32_M1,
          6829 => Opcode::PseudoVMFLT_VFPR32_M1_MASK,
          6830 => Opcode::PseudoVMFLT_VFPR32_M2,
          6831 => Opcode::PseudoVMFLT_VFPR32_M2_MASK,
          6832 => Opcode::PseudoVMFLT_VFPR32_M4,
          6833 => Opcode::PseudoVMFLT_VFPR32_M4_MASK,
          6834 => Opcode::PseudoVMFLT_VFPR32_M8,
          6835 => Opcode::PseudoVMFLT_VFPR32_M8_MASK,
          6836 => Opcode::PseudoVMFLT_VFPR32_MF2,
          6837 => Opcode::PseudoVMFLT_VFPR32_MF2_MASK,
          6838 => Opcode::PseudoVMFLT_VFPR64_M1,
          6839 => Opcode::PseudoVMFLT_VFPR64_M1_MASK,
          6840 => Opcode::PseudoVMFLT_VFPR64_M2,
          6841 => Opcode::PseudoVMFLT_VFPR64_M2_MASK,
          6842 => Opcode::PseudoVMFLT_VFPR64_M4,
          6843 => Opcode::PseudoVMFLT_VFPR64_M4_MASK,
          6844 => Opcode::PseudoVMFLT_VFPR64_M8,
          6845 => Opcode::PseudoVMFLT_VFPR64_M8_MASK,
          6846 => Opcode::PseudoVMFLT_VV_M1,
          6847 => Opcode::PseudoVMFLT_VV_M1_MASK,
          6848 => Opcode::PseudoVMFLT_VV_M2,
          6849 => Opcode::PseudoVMFLT_VV_M2_MASK,
          6850 => Opcode::PseudoVMFLT_VV_M4,
          6851 => Opcode::PseudoVMFLT_VV_M4_MASK,
          6852 => Opcode::PseudoVMFLT_VV_M8,
          6853 => Opcode::PseudoVMFLT_VV_M8_MASK,
          6854 => Opcode::PseudoVMFLT_VV_MF2,
          6855 => Opcode::PseudoVMFLT_VV_MF2_MASK,
          6856 => Opcode::PseudoVMFLT_VV_MF4,
          6857 => Opcode::PseudoVMFLT_VV_MF4_MASK,
          6858 => Opcode::PseudoVMFNE_VFPR16_M1,
          6859 => Opcode::PseudoVMFNE_VFPR16_M1_MASK,
          6860 => Opcode::PseudoVMFNE_VFPR16_M2,
          6861 => Opcode::PseudoVMFNE_VFPR16_M2_MASK,
          6862 => Opcode::PseudoVMFNE_VFPR16_M4,
          6863 => Opcode::PseudoVMFNE_VFPR16_M4_MASK,
          6864 => Opcode::PseudoVMFNE_VFPR16_M8,
          6865 => Opcode::PseudoVMFNE_VFPR16_M8_MASK,
          6866 => Opcode::PseudoVMFNE_VFPR16_MF2,
          6867 => Opcode::PseudoVMFNE_VFPR16_MF2_MASK,
          6868 => Opcode::PseudoVMFNE_VFPR16_MF4,
          6869 => Opcode::PseudoVMFNE_VFPR16_MF4_MASK,
          6870 => Opcode::PseudoVMFNE_VFPR32_M1,
          6871 => Opcode::PseudoVMFNE_VFPR32_M1_MASK,
          6872 => Opcode::PseudoVMFNE_VFPR32_M2,
          6873 => Opcode::PseudoVMFNE_VFPR32_M2_MASK,
          6874 => Opcode::PseudoVMFNE_VFPR32_M4,
          6875 => Opcode::PseudoVMFNE_VFPR32_M4_MASK,
          6876 => Opcode::PseudoVMFNE_VFPR32_M8,
          6877 => Opcode::PseudoVMFNE_VFPR32_M8_MASK,
          6878 => Opcode::PseudoVMFNE_VFPR32_MF2,
          6879 => Opcode::PseudoVMFNE_VFPR32_MF2_MASK,
          6880 => Opcode::PseudoVMFNE_VFPR64_M1,
          6881 => Opcode::PseudoVMFNE_VFPR64_M1_MASK,
          6882 => Opcode::PseudoVMFNE_VFPR64_M2,
          6883 => Opcode::PseudoVMFNE_VFPR64_M2_MASK,
          6884 => Opcode::PseudoVMFNE_VFPR64_M4,
          6885 => Opcode::PseudoVMFNE_VFPR64_M4_MASK,
          6886 => Opcode::PseudoVMFNE_VFPR64_M8,
          6887 => Opcode::PseudoVMFNE_VFPR64_M8_MASK,
          6888 => Opcode::PseudoVMFNE_VV_M1,
          6889 => Opcode::PseudoVMFNE_VV_M1_MASK,
          6890 => Opcode::PseudoVMFNE_VV_M2,
          6891 => Opcode::PseudoVMFNE_VV_M2_MASK,
          6892 => Opcode::PseudoVMFNE_VV_M4,
          6893 => Opcode::PseudoVMFNE_VV_M4_MASK,
          6894 => Opcode::PseudoVMFNE_VV_M8,
          6895 => Opcode::PseudoVMFNE_VV_M8_MASK,
          6896 => Opcode::PseudoVMFNE_VV_MF2,
          6897 => Opcode::PseudoVMFNE_VV_MF2_MASK,
          6898 => Opcode::PseudoVMFNE_VV_MF4,
          6899 => Opcode::PseudoVMFNE_VV_MF4_MASK,
          6900 => Opcode::PseudoVMINU_VV_M1,
          6901 => Opcode::PseudoVMINU_VV_M1_MASK,
          6902 => Opcode::PseudoVMINU_VV_M2,
          6903 => Opcode::PseudoVMINU_VV_M2_MASK,
          6904 => Opcode::PseudoVMINU_VV_M4,
          6905 => Opcode::PseudoVMINU_VV_M4_MASK,
          6906 => Opcode::PseudoVMINU_VV_M8,
          6907 => Opcode::PseudoVMINU_VV_M8_MASK,
          6908 => Opcode::PseudoVMINU_VV_MF2,
          6909 => Opcode::PseudoVMINU_VV_MF2_MASK,
          6910 => Opcode::PseudoVMINU_VV_MF4,
          6911 => Opcode::PseudoVMINU_VV_MF4_MASK,
          6912 => Opcode::PseudoVMINU_VV_MF8,
          6913 => Opcode::PseudoVMINU_VV_MF8_MASK,
          6914 => Opcode::PseudoVMINU_VX_M1,
          6915 => Opcode::PseudoVMINU_VX_M1_MASK,
          6916 => Opcode::PseudoVMINU_VX_M2,
          6917 => Opcode::PseudoVMINU_VX_M2_MASK,
          6918 => Opcode::PseudoVMINU_VX_M4,
          6919 => Opcode::PseudoVMINU_VX_M4_MASK,
          6920 => Opcode::PseudoVMINU_VX_M8,
          6921 => Opcode::PseudoVMINU_VX_M8_MASK,
          6922 => Opcode::PseudoVMINU_VX_MF2,
          6923 => Opcode::PseudoVMINU_VX_MF2_MASK,
          6924 => Opcode::PseudoVMINU_VX_MF4,
          6925 => Opcode::PseudoVMINU_VX_MF4_MASK,
          6926 => Opcode::PseudoVMINU_VX_MF8,
          6927 => Opcode::PseudoVMINU_VX_MF8_MASK,
          6928 => Opcode::PseudoVMIN_VV_M1,
          6929 => Opcode::PseudoVMIN_VV_M1_MASK,
          6930 => Opcode::PseudoVMIN_VV_M2,
          6931 => Opcode::PseudoVMIN_VV_M2_MASK,
          6932 => Opcode::PseudoVMIN_VV_M4,
          6933 => Opcode::PseudoVMIN_VV_M4_MASK,
          6934 => Opcode::PseudoVMIN_VV_M8,
          6935 => Opcode::PseudoVMIN_VV_M8_MASK,
          6936 => Opcode::PseudoVMIN_VV_MF2,
          6937 => Opcode::PseudoVMIN_VV_MF2_MASK,
          6938 => Opcode::PseudoVMIN_VV_MF4,
          6939 => Opcode::PseudoVMIN_VV_MF4_MASK,
          6940 => Opcode::PseudoVMIN_VV_MF8,
          6941 => Opcode::PseudoVMIN_VV_MF8_MASK,
          6942 => Opcode::PseudoVMIN_VX_M1,
          6943 => Opcode::PseudoVMIN_VX_M1_MASK,
          6944 => Opcode::PseudoVMIN_VX_M2,
          6945 => Opcode::PseudoVMIN_VX_M2_MASK,
          6946 => Opcode::PseudoVMIN_VX_M4,
          6947 => Opcode::PseudoVMIN_VX_M4_MASK,
          6948 => Opcode::PseudoVMIN_VX_M8,
          6949 => Opcode::PseudoVMIN_VX_M8_MASK,
          6950 => Opcode::PseudoVMIN_VX_MF2,
          6951 => Opcode::PseudoVMIN_VX_MF2_MASK,
          6952 => Opcode::PseudoVMIN_VX_MF4,
          6953 => Opcode::PseudoVMIN_VX_MF4_MASK,
          6954 => Opcode::PseudoVMIN_VX_MF8,
          6955 => Opcode::PseudoVMIN_VX_MF8_MASK,
          6956 => Opcode::PseudoVMNAND_MM_B1,
          6957 => Opcode::PseudoVMNAND_MM_B16,
          6958 => Opcode::PseudoVMNAND_MM_B2,
          6959 => Opcode::PseudoVMNAND_MM_B32,
          6960 => Opcode::PseudoVMNAND_MM_B4,
          6961 => Opcode::PseudoVMNAND_MM_B64,
          6962 => Opcode::PseudoVMNAND_MM_B8,
          6963 => Opcode::PseudoVMNOR_MM_B1,
          6964 => Opcode::PseudoVMNOR_MM_B16,
          6965 => Opcode::PseudoVMNOR_MM_B2,
          6966 => Opcode::PseudoVMNOR_MM_B32,
          6967 => Opcode::PseudoVMNOR_MM_B4,
          6968 => Opcode::PseudoVMNOR_MM_B64,
          6969 => Opcode::PseudoVMNOR_MM_B8,
          6970 => Opcode::PseudoVMORN_MM_B1,
          6971 => Opcode::PseudoVMORN_MM_B16,
          6972 => Opcode::PseudoVMORN_MM_B2,
          6973 => Opcode::PseudoVMORN_MM_B32,
          6974 => Opcode::PseudoVMORN_MM_B4,
          6975 => Opcode::PseudoVMORN_MM_B64,
          6976 => Opcode::PseudoVMORN_MM_B8,
          6977 => Opcode::PseudoVMOR_MM_B1,
          6978 => Opcode::PseudoVMOR_MM_B16,
          6979 => Opcode::PseudoVMOR_MM_B2,
          6980 => Opcode::PseudoVMOR_MM_B32,
          6981 => Opcode::PseudoVMOR_MM_B4,
          6982 => Opcode::PseudoVMOR_MM_B64,
          6983 => Opcode::PseudoVMOR_MM_B8,
          6984 => Opcode::PseudoVMSBC_VVM_M1,
          6985 => Opcode::PseudoVMSBC_VVM_M2,
          6986 => Opcode::PseudoVMSBC_VVM_M4,
          6987 => Opcode::PseudoVMSBC_VVM_M8,
          6988 => Opcode::PseudoVMSBC_VVM_MF2,
          6989 => Opcode::PseudoVMSBC_VVM_MF4,
          6990 => Opcode::PseudoVMSBC_VVM_MF8,
          6991 => Opcode::PseudoVMSBC_VV_M1,
          6992 => Opcode::PseudoVMSBC_VV_M2,
          6993 => Opcode::PseudoVMSBC_VV_M4,
          6994 => Opcode::PseudoVMSBC_VV_M8,
          6995 => Opcode::PseudoVMSBC_VV_MF2,
          6996 => Opcode::PseudoVMSBC_VV_MF4,
          6997 => Opcode::PseudoVMSBC_VV_MF8,
          6998 => Opcode::PseudoVMSBC_VXM_M1,
          6999 => Opcode::PseudoVMSBC_VXM_M2,
          7000 => Opcode::PseudoVMSBC_VXM_M4,
          7001 => Opcode::PseudoVMSBC_VXM_M8,
          7002 => Opcode::PseudoVMSBC_VXM_MF2,
          7003 => Opcode::PseudoVMSBC_VXM_MF4,
          7004 => Opcode::PseudoVMSBC_VXM_MF8,
          7005 => Opcode::PseudoVMSBC_VX_M1,
          7006 => Opcode::PseudoVMSBC_VX_M2,
          7007 => Opcode::PseudoVMSBC_VX_M4,
          7008 => Opcode::PseudoVMSBC_VX_M8,
          7009 => Opcode::PseudoVMSBC_VX_MF2,
          7010 => Opcode::PseudoVMSBC_VX_MF4,
          7011 => Opcode::PseudoVMSBC_VX_MF8,
          7012 => Opcode::PseudoVMSBF_M_B1,
          7013 => Opcode::PseudoVMSBF_M_B16,
          7014 => Opcode::PseudoVMSBF_M_B16_MASK,
          7015 => Opcode::PseudoVMSBF_M_B1_MASK,
          7016 => Opcode::PseudoVMSBF_M_B2,
          7017 => Opcode::PseudoVMSBF_M_B2_MASK,
          7018 => Opcode::PseudoVMSBF_M_B32,
          7019 => Opcode::PseudoVMSBF_M_B32_MASK,
          7020 => Opcode::PseudoVMSBF_M_B4,
          7021 => Opcode::PseudoVMSBF_M_B4_MASK,
          7022 => Opcode::PseudoVMSBF_M_B64,
          7023 => Opcode::PseudoVMSBF_M_B64_MASK,
          7024 => Opcode::PseudoVMSBF_M_B8,
          7025 => Opcode::PseudoVMSBF_M_B8_MASK,
          7026 => Opcode::PseudoVMSEQ_VI_M1,
          7027 => Opcode::PseudoVMSEQ_VI_M1_MASK,
          7028 => Opcode::PseudoVMSEQ_VI_M2,
          7029 => Opcode::PseudoVMSEQ_VI_M2_MASK,
          7030 => Opcode::PseudoVMSEQ_VI_M4,
          7031 => Opcode::PseudoVMSEQ_VI_M4_MASK,
          7032 => Opcode::PseudoVMSEQ_VI_M8,
          7033 => Opcode::PseudoVMSEQ_VI_M8_MASK,
          7034 => Opcode::PseudoVMSEQ_VI_MF2,
          7035 => Opcode::PseudoVMSEQ_VI_MF2_MASK,
          7036 => Opcode::PseudoVMSEQ_VI_MF4,
          7037 => Opcode::PseudoVMSEQ_VI_MF4_MASK,
          7038 => Opcode::PseudoVMSEQ_VI_MF8,
          7039 => Opcode::PseudoVMSEQ_VI_MF8_MASK,
          7040 => Opcode::PseudoVMSEQ_VV_M1,
          7041 => Opcode::PseudoVMSEQ_VV_M1_MASK,
          7042 => Opcode::PseudoVMSEQ_VV_M2,
          7043 => Opcode::PseudoVMSEQ_VV_M2_MASK,
          7044 => Opcode::PseudoVMSEQ_VV_M4,
          7045 => Opcode::PseudoVMSEQ_VV_M4_MASK,
          7046 => Opcode::PseudoVMSEQ_VV_M8,
          7047 => Opcode::PseudoVMSEQ_VV_M8_MASK,
          7048 => Opcode::PseudoVMSEQ_VV_MF2,
          7049 => Opcode::PseudoVMSEQ_VV_MF2_MASK,
          7050 => Opcode::PseudoVMSEQ_VV_MF4,
          7051 => Opcode::PseudoVMSEQ_VV_MF4_MASK,
          7052 => Opcode::PseudoVMSEQ_VV_MF8,
          7053 => Opcode::PseudoVMSEQ_VV_MF8_MASK,
          7054 => Opcode::PseudoVMSEQ_VX_M1,
          7055 => Opcode::PseudoVMSEQ_VX_M1_MASK,
          7056 => Opcode::PseudoVMSEQ_VX_M2,
          7057 => Opcode::PseudoVMSEQ_VX_M2_MASK,
          7058 => Opcode::PseudoVMSEQ_VX_M4,
          7059 => Opcode::PseudoVMSEQ_VX_M4_MASK,
          7060 => Opcode::PseudoVMSEQ_VX_M8,
          7061 => Opcode::PseudoVMSEQ_VX_M8_MASK,
          7062 => Opcode::PseudoVMSEQ_VX_MF2,
          7063 => Opcode::PseudoVMSEQ_VX_MF2_MASK,
          7064 => Opcode::PseudoVMSEQ_VX_MF4,
          7065 => Opcode::PseudoVMSEQ_VX_MF4_MASK,
          7066 => Opcode::PseudoVMSEQ_VX_MF8,
          7067 => Opcode::PseudoVMSEQ_VX_MF8_MASK,
          7068 => Opcode::PseudoVMSET_M_B1,
          7069 => Opcode::PseudoVMSET_M_B16,
          7070 => Opcode::PseudoVMSET_M_B2,
          7071 => Opcode::PseudoVMSET_M_B32,
          7072 => Opcode::PseudoVMSET_M_B4,
          7073 => Opcode::PseudoVMSET_M_B64,
          7074 => Opcode::PseudoVMSET_M_B8,
          7075 => Opcode::PseudoVMSGEU_VI,
          7076 => Opcode::PseudoVMSGEU_VX,
          7077 => Opcode::PseudoVMSGEU_VX_M,
          7078 => Opcode::PseudoVMSGEU_VX_M_T,
          7079 => Opcode::PseudoVMSGE_VI,
          7080 => Opcode::PseudoVMSGE_VX,
          7081 => Opcode::PseudoVMSGE_VX_M,
          7082 => Opcode::PseudoVMSGE_VX_M_T,
          7083 => Opcode::PseudoVMSGTU_VI_M1,
          7084 => Opcode::PseudoVMSGTU_VI_M1_MASK,
          7085 => Opcode::PseudoVMSGTU_VI_M2,
          7086 => Opcode::PseudoVMSGTU_VI_M2_MASK,
          7087 => Opcode::PseudoVMSGTU_VI_M4,
          7088 => Opcode::PseudoVMSGTU_VI_M4_MASK,
          7089 => Opcode::PseudoVMSGTU_VI_M8,
          7090 => Opcode::PseudoVMSGTU_VI_M8_MASK,
          7091 => Opcode::PseudoVMSGTU_VI_MF2,
          7092 => Opcode::PseudoVMSGTU_VI_MF2_MASK,
          7093 => Opcode::PseudoVMSGTU_VI_MF4,
          7094 => Opcode::PseudoVMSGTU_VI_MF4_MASK,
          7095 => Opcode::PseudoVMSGTU_VI_MF8,
          7096 => Opcode::PseudoVMSGTU_VI_MF8_MASK,
          7097 => Opcode::PseudoVMSGTU_VX_M1,
          7098 => Opcode::PseudoVMSGTU_VX_M1_MASK,
          7099 => Opcode::PseudoVMSGTU_VX_M2,
          7100 => Opcode::PseudoVMSGTU_VX_M2_MASK,
          7101 => Opcode::PseudoVMSGTU_VX_M4,
          7102 => Opcode::PseudoVMSGTU_VX_M4_MASK,
          7103 => Opcode::PseudoVMSGTU_VX_M8,
          7104 => Opcode::PseudoVMSGTU_VX_M8_MASK,
          7105 => Opcode::PseudoVMSGTU_VX_MF2,
          7106 => Opcode::PseudoVMSGTU_VX_MF2_MASK,
          7107 => Opcode::PseudoVMSGTU_VX_MF4,
          7108 => Opcode::PseudoVMSGTU_VX_MF4_MASK,
          7109 => Opcode::PseudoVMSGTU_VX_MF8,
          7110 => Opcode::PseudoVMSGTU_VX_MF8_MASK,
          7111 => Opcode::PseudoVMSGT_VI_M1,
          7112 => Opcode::PseudoVMSGT_VI_M1_MASK,
          7113 => Opcode::PseudoVMSGT_VI_M2,
          7114 => Opcode::PseudoVMSGT_VI_M2_MASK,
          7115 => Opcode::PseudoVMSGT_VI_M4,
          7116 => Opcode::PseudoVMSGT_VI_M4_MASK,
          7117 => Opcode::PseudoVMSGT_VI_M8,
          7118 => Opcode::PseudoVMSGT_VI_M8_MASK,
          7119 => Opcode::PseudoVMSGT_VI_MF2,
          7120 => Opcode::PseudoVMSGT_VI_MF2_MASK,
          7121 => Opcode::PseudoVMSGT_VI_MF4,
          7122 => Opcode::PseudoVMSGT_VI_MF4_MASK,
          7123 => Opcode::PseudoVMSGT_VI_MF8,
          7124 => Opcode::PseudoVMSGT_VI_MF8_MASK,
          7125 => Opcode::PseudoVMSGT_VX_M1,
          7126 => Opcode::PseudoVMSGT_VX_M1_MASK,
          7127 => Opcode::PseudoVMSGT_VX_M2,
          7128 => Opcode::PseudoVMSGT_VX_M2_MASK,
          7129 => Opcode::PseudoVMSGT_VX_M4,
          7130 => Opcode::PseudoVMSGT_VX_M4_MASK,
          7131 => Opcode::PseudoVMSGT_VX_M8,
          7132 => Opcode::PseudoVMSGT_VX_M8_MASK,
          7133 => Opcode::PseudoVMSGT_VX_MF2,
          7134 => Opcode::PseudoVMSGT_VX_MF2_MASK,
          7135 => Opcode::PseudoVMSGT_VX_MF4,
          7136 => Opcode::PseudoVMSGT_VX_MF4_MASK,
          7137 => Opcode::PseudoVMSGT_VX_MF8,
          7138 => Opcode::PseudoVMSGT_VX_MF8_MASK,
          7139 => Opcode::PseudoVMSIF_M_B1,
          7140 => Opcode::PseudoVMSIF_M_B16,
          7141 => Opcode::PseudoVMSIF_M_B16_MASK,
          7142 => Opcode::PseudoVMSIF_M_B1_MASK,
          7143 => Opcode::PseudoVMSIF_M_B2,
          7144 => Opcode::PseudoVMSIF_M_B2_MASK,
          7145 => Opcode::PseudoVMSIF_M_B32,
          7146 => Opcode::PseudoVMSIF_M_B32_MASK,
          7147 => Opcode::PseudoVMSIF_M_B4,
          7148 => Opcode::PseudoVMSIF_M_B4_MASK,
          7149 => Opcode::PseudoVMSIF_M_B64,
          7150 => Opcode::PseudoVMSIF_M_B64_MASK,
          7151 => Opcode::PseudoVMSIF_M_B8,
          7152 => Opcode::PseudoVMSIF_M_B8_MASK,
          7153 => Opcode::PseudoVMSLEU_VI_M1,
          7154 => Opcode::PseudoVMSLEU_VI_M1_MASK,
          7155 => Opcode::PseudoVMSLEU_VI_M2,
          7156 => Opcode::PseudoVMSLEU_VI_M2_MASK,
          7157 => Opcode::PseudoVMSLEU_VI_M4,
          7158 => Opcode::PseudoVMSLEU_VI_M4_MASK,
          7159 => Opcode::PseudoVMSLEU_VI_M8,
          7160 => Opcode::PseudoVMSLEU_VI_M8_MASK,
          7161 => Opcode::PseudoVMSLEU_VI_MF2,
          7162 => Opcode::PseudoVMSLEU_VI_MF2_MASK,
          7163 => Opcode::PseudoVMSLEU_VI_MF4,
          7164 => Opcode::PseudoVMSLEU_VI_MF4_MASK,
          7165 => Opcode::PseudoVMSLEU_VI_MF8,
          7166 => Opcode::PseudoVMSLEU_VI_MF8_MASK,
          7167 => Opcode::PseudoVMSLEU_VV_M1,
          7168 => Opcode::PseudoVMSLEU_VV_M1_MASK,
          7169 => Opcode::PseudoVMSLEU_VV_M2,
          7170 => Opcode::PseudoVMSLEU_VV_M2_MASK,
          7171 => Opcode::PseudoVMSLEU_VV_M4,
          7172 => Opcode::PseudoVMSLEU_VV_M4_MASK,
          7173 => Opcode::PseudoVMSLEU_VV_M8,
          7174 => Opcode::PseudoVMSLEU_VV_M8_MASK,
          7175 => Opcode::PseudoVMSLEU_VV_MF2,
          7176 => Opcode::PseudoVMSLEU_VV_MF2_MASK,
          7177 => Opcode::PseudoVMSLEU_VV_MF4,
          7178 => Opcode::PseudoVMSLEU_VV_MF4_MASK,
          7179 => Opcode::PseudoVMSLEU_VV_MF8,
          7180 => Opcode::PseudoVMSLEU_VV_MF8_MASK,
          7181 => Opcode::PseudoVMSLEU_VX_M1,
          7182 => Opcode::PseudoVMSLEU_VX_M1_MASK,
          7183 => Opcode::PseudoVMSLEU_VX_M2,
          7184 => Opcode::PseudoVMSLEU_VX_M2_MASK,
          7185 => Opcode::PseudoVMSLEU_VX_M4,
          7186 => Opcode::PseudoVMSLEU_VX_M4_MASK,
          7187 => Opcode::PseudoVMSLEU_VX_M8,
          7188 => Opcode::PseudoVMSLEU_VX_M8_MASK,
          7189 => Opcode::PseudoVMSLEU_VX_MF2,
          7190 => Opcode::PseudoVMSLEU_VX_MF2_MASK,
          7191 => Opcode::PseudoVMSLEU_VX_MF4,
          7192 => Opcode::PseudoVMSLEU_VX_MF4_MASK,
          7193 => Opcode::PseudoVMSLEU_VX_MF8,
          7194 => Opcode::PseudoVMSLEU_VX_MF8_MASK,
          7195 => Opcode::PseudoVMSLE_VI_M1,
          7196 => Opcode::PseudoVMSLE_VI_M1_MASK,
          7197 => Opcode::PseudoVMSLE_VI_M2,
          7198 => Opcode::PseudoVMSLE_VI_M2_MASK,
          7199 => Opcode::PseudoVMSLE_VI_M4,
          7200 => Opcode::PseudoVMSLE_VI_M4_MASK,
          7201 => Opcode::PseudoVMSLE_VI_M8,
          7202 => Opcode::PseudoVMSLE_VI_M8_MASK,
          7203 => Opcode::PseudoVMSLE_VI_MF2,
          7204 => Opcode::PseudoVMSLE_VI_MF2_MASK,
          7205 => Opcode::PseudoVMSLE_VI_MF4,
          7206 => Opcode::PseudoVMSLE_VI_MF4_MASK,
          7207 => Opcode::PseudoVMSLE_VI_MF8,
          7208 => Opcode::PseudoVMSLE_VI_MF8_MASK,
          7209 => Opcode::PseudoVMSLE_VV_M1,
          7210 => Opcode::PseudoVMSLE_VV_M1_MASK,
          7211 => Opcode::PseudoVMSLE_VV_M2,
          7212 => Opcode::PseudoVMSLE_VV_M2_MASK,
          7213 => Opcode::PseudoVMSLE_VV_M4,
          7214 => Opcode::PseudoVMSLE_VV_M4_MASK,
          7215 => Opcode::PseudoVMSLE_VV_M8,
          7216 => Opcode::PseudoVMSLE_VV_M8_MASK,
          7217 => Opcode::PseudoVMSLE_VV_MF2,
          7218 => Opcode::PseudoVMSLE_VV_MF2_MASK,
          7219 => Opcode::PseudoVMSLE_VV_MF4,
          7220 => Opcode::PseudoVMSLE_VV_MF4_MASK,
          7221 => Opcode::PseudoVMSLE_VV_MF8,
          7222 => Opcode::PseudoVMSLE_VV_MF8_MASK,
          7223 => Opcode::PseudoVMSLE_VX_M1,
          7224 => Opcode::PseudoVMSLE_VX_M1_MASK,
          7225 => Opcode::PseudoVMSLE_VX_M2,
          7226 => Opcode::PseudoVMSLE_VX_M2_MASK,
          7227 => Opcode::PseudoVMSLE_VX_M4,
          7228 => Opcode::PseudoVMSLE_VX_M4_MASK,
          7229 => Opcode::PseudoVMSLE_VX_M8,
          7230 => Opcode::PseudoVMSLE_VX_M8_MASK,
          7231 => Opcode::PseudoVMSLE_VX_MF2,
          7232 => Opcode::PseudoVMSLE_VX_MF2_MASK,
          7233 => Opcode::PseudoVMSLE_VX_MF4,
          7234 => Opcode::PseudoVMSLE_VX_MF4_MASK,
          7235 => Opcode::PseudoVMSLE_VX_MF8,
          7236 => Opcode::PseudoVMSLE_VX_MF8_MASK,
          7237 => Opcode::PseudoVMSLTU_VI,
          7238 => Opcode::PseudoVMSLTU_VV_M1,
          7239 => Opcode::PseudoVMSLTU_VV_M1_MASK,
          7240 => Opcode::PseudoVMSLTU_VV_M2,
          7241 => Opcode::PseudoVMSLTU_VV_M2_MASK,
          7242 => Opcode::PseudoVMSLTU_VV_M4,
          7243 => Opcode::PseudoVMSLTU_VV_M4_MASK,
          7244 => Opcode::PseudoVMSLTU_VV_M8,
          7245 => Opcode::PseudoVMSLTU_VV_M8_MASK,
          7246 => Opcode::PseudoVMSLTU_VV_MF2,
          7247 => Opcode::PseudoVMSLTU_VV_MF2_MASK,
          7248 => Opcode::PseudoVMSLTU_VV_MF4,
          7249 => Opcode::PseudoVMSLTU_VV_MF4_MASK,
          7250 => Opcode::PseudoVMSLTU_VV_MF8,
          7251 => Opcode::PseudoVMSLTU_VV_MF8_MASK,
          7252 => Opcode::PseudoVMSLTU_VX_M1,
          7253 => Opcode::PseudoVMSLTU_VX_M1_MASK,
          7254 => Opcode::PseudoVMSLTU_VX_M2,
          7255 => Opcode::PseudoVMSLTU_VX_M2_MASK,
          7256 => Opcode::PseudoVMSLTU_VX_M4,
          7257 => Opcode::PseudoVMSLTU_VX_M4_MASK,
          7258 => Opcode::PseudoVMSLTU_VX_M8,
          7259 => Opcode::PseudoVMSLTU_VX_M8_MASK,
          7260 => Opcode::PseudoVMSLTU_VX_MF2,
          7261 => Opcode::PseudoVMSLTU_VX_MF2_MASK,
          7262 => Opcode::PseudoVMSLTU_VX_MF4,
          7263 => Opcode::PseudoVMSLTU_VX_MF4_MASK,
          7264 => Opcode::PseudoVMSLTU_VX_MF8,
          7265 => Opcode::PseudoVMSLTU_VX_MF8_MASK,
          7266 => Opcode::PseudoVMSLT_VI,
          7267 => Opcode::PseudoVMSLT_VV_M1,
          7268 => Opcode::PseudoVMSLT_VV_M1_MASK,
          7269 => Opcode::PseudoVMSLT_VV_M2,
          7270 => Opcode::PseudoVMSLT_VV_M2_MASK,
          7271 => Opcode::PseudoVMSLT_VV_M4,
          7272 => Opcode::PseudoVMSLT_VV_M4_MASK,
          7273 => Opcode::PseudoVMSLT_VV_M8,
          7274 => Opcode::PseudoVMSLT_VV_M8_MASK,
          7275 => Opcode::PseudoVMSLT_VV_MF2,
          7276 => Opcode::PseudoVMSLT_VV_MF2_MASK,
          7277 => Opcode::PseudoVMSLT_VV_MF4,
          7278 => Opcode::PseudoVMSLT_VV_MF4_MASK,
          7279 => Opcode::PseudoVMSLT_VV_MF8,
          7280 => Opcode::PseudoVMSLT_VV_MF8_MASK,
          7281 => Opcode::PseudoVMSLT_VX_M1,
          7282 => Opcode::PseudoVMSLT_VX_M1_MASK,
          7283 => Opcode::PseudoVMSLT_VX_M2,
          7284 => Opcode::PseudoVMSLT_VX_M2_MASK,
          7285 => Opcode::PseudoVMSLT_VX_M4,
          7286 => Opcode::PseudoVMSLT_VX_M4_MASK,
          7287 => Opcode::PseudoVMSLT_VX_M8,
          7288 => Opcode::PseudoVMSLT_VX_M8_MASK,
          7289 => Opcode::PseudoVMSLT_VX_MF2,
          7290 => Opcode::PseudoVMSLT_VX_MF2_MASK,
          7291 => Opcode::PseudoVMSLT_VX_MF4,
          7292 => Opcode::PseudoVMSLT_VX_MF4_MASK,
          7293 => Opcode::PseudoVMSLT_VX_MF8,
          7294 => Opcode::PseudoVMSLT_VX_MF8_MASK,
          7295 => Opcode::PseudoVMSNE_VI_M1,
          7296 => Opcode::PseudoVMSNE_VI_M1_MASK,
          7297 => Opcode::PseudoVMSNE_VI_M2,
          7298 => Opcode::PseudoVMSNE_VI_M2_MASK,
          7299 => Opcode::PseudoVMSNE_VI_M4,
          7300 => Opcode::PseudoVMSNE_VI_M4_MASK,
          7301 => Opcode::PseudoVMSNE_VI_M8,
          7302 => Opcode::PseudoVMSNE_VI_M8_MASK,
          7303 => Opcode::PseudoVMSNE_VI_MF2,
          7304 => Opcode::PseudoVMSNE_VI_MF2_MASK,
          7305 => Opcode::PseudoVMSNE_VI_MF4,
          7306 => Opcode::PseudoVMSNE_VI_MF4_MASK,
          7307 => Opcode::PseudoVMSNE_VI_MF8,
          7308 => Opcode::PseudoVMSNE_VI_MF8_MASK,
          7309 => Opcode::PseudoVMSNE_VV_M1,
          7310 => Opcode::PseudoVMSNE_VV_M1_MASK,
          7311 => Opcode::PseudoVMSNE_VV_M2,
          7312 => Opcode::PseudoVMSNE_VV_M2_MASK,
          7313 => Opcode::PseudoVMSNE_VV_M4,
          7314 => Opcode::PseudoVMSNE_VV_M4_MASK,
          7315 => Opcode::PseudoVMSNE_VV_M8,
          7316 => Opcode::PseudoVMSNE_VV_M8_MASK,
          7317 => Opcode::PseudoVMSNE_VV_MF2,
          7318 => Opcode::PseudoVMSNE_VV_MF2_MASK,
          7319 => Opcode::PseudoVMSNE_VV_MF4,
          7320 => Opcode::PseudoVMSNE_VV_MF4_MASK,
          7321 => Opcode::PseudoVMSNE_VV_MF8,
          7322 => Opcode::PseudoVMSNE_VV_MF8_MASK,
          7323 => Opcode::PseudoVMSNE_VX_M1,
          7324 => Opcode::PseudoVMSNE_VX_M1_MASK,
          7325 => Opcode::PseudoVMSNE_VX_M2,
          7326 => Opcode::PseudoVMSNE_VX_M2_MASK,
          7327 => Opcode::PseudoVMSNE_VX_M4,
          7328 => Opcode::PseudoVMSNE_VX_M4_MASK,
          7329 => Opcode::PseudoVMSNE_VX_M8,
          7330 => Opcode::PseudoVMSNE_VX_M8_MASK,
          7331 => Opcode::PseudoVMSNE_VX_MF2,
          7332 => Opcode::PseudoVMSNE_VX_MF2_MASK,
          7333 => Opcode::PseudoVMSNE_VX_MF4,
          7334 => Opcode::PseudoVMSNE_VX_MF4_MASK,
          7335 => Opcode::PseudoVMSNE_VX_MF8,
          7336 => Opcode::PseudoVMSNE_VX_MF8_MASK,
          7337 => Opcode::PseudoVMSOF_M_B1,
          7338 => Opcode::PseudoVMSOF_M_B16,
          7339 => Opcode::PseudoVMSOF_M_B16_MASK,
          7340 => Opcode::PseudoVMSOF_M_B1_MASK,
          7341 => Opcode::PseudoVMSOF_M_B2,
          7342 => Opcode::PseudoVMSOF_M_B2_MASK,
          7343 => Opcode::PseudoVMSOF_M_B32,
          7344 => Opcode::PseudoVMSOF_M_B32_MASK,
          7345 => Opcode::PseudoVMSOF_M_B4,
          7346 => Opcode::PseudoVMSOF_M_B4_MASK,
          7347 => Opcode::PseudoVMSOF_M_B64,
          7348 => Opcode::PseudoVMSOF_M_B64_MASK,
          7349 => Opcode::PseudoVMSOF_M_B8,
          7350 => Opcode::PseudoVMSOF_M_B8_MASK,
          7351 => Opcode::PseudoVMULHSU_VV_M1,
          7352 => Opcode::PseudoVMULHSU_VV_M1_MASK,
          7353 => Opcode::PseudoVMULHSU_VV_M2,
          7354 => Opcode::PseudoVMULHSU_VV_M2_MASK,
          7355 => Opcode::PseudoVMULHSU_VV_M4,
          7356 => Opcode::PseudoVMULHSU_VV_M4_MASK,
          7357 => Opcode::PseudoVMULHSU_VV_M8,
          7358 => Opcode::PseudoVMULHSU_VV_M8_MASK,
          7359 => Opcode::PseudoVMULHSU_VV_MF2,
          7360 => Opcode::PseudoVMULHSU_VV_MF2_MASK,
          7361 => Opcode::PseudoVMULHSU_VV_MF4,
          7362 => Opcode::PseudoVMULHSU_VV_MF4_MASK,
          7363 => Opcode::PseudoVMULHSU_VV_MF8,
          7364 => Opcode::PseudoVMULHSU_VV_MF8_MASK,
          7365 => Opcode::PseudoVMULHSU_VX_M1,
          7366 => Opcode::PseudoVMULHSU_VX_M1_MASK,
          7367 => Opcode::PseudoVMULHSU_VX_M2,
          7368 => Opcode::PseudoVMULHSU_VX_M2_MASK,
          7369 => Opcode::PseudoVMULHSU_VX_M4,
          7370 => Opcode::PseudoVMULHSU_VX_M4_MASK,
          7371 => Opcode::PseudoVMULHSU_VX_M8,
          7372 => Opcode::PseudoVMULHSU_VX_M8_MASK,
          7373 => Opcode::PseudoVMULHSU_VX_MF2,
          7374 => Opcode::PseudoVMULHSU_VX_MF2_MASK,
          7375 => Opcode::PseudoVMULHSU_VX_MF4,
          7376 => Opcode::PseudoVMULHSU_VX_MF4_MASK,
          7377 => Opcode::PseudoVMULHSU_VX_MF8,
          7378 => Opcode::PseudoVMULHSU_VX_MF8_MASK,
          7379 => Opcode::PseudoVMULHU_VV_M1,
          7380 => Opcode::PseudoVMULHU_VV_M1_MASK,
          7381 => Opcode::PseudoVMULHU_VV_M2,
          7382 => Opcode::PseudoVMULHU_VV_M2_MASK,
          7383 => Opcode::PseudoVMULHU_VV_M4,
          7384 => Opcode::PseudoVMULHU_VV_M4_MASK,
          7385 => Opcode::PseudoVMULHU_VV_M8,
          7386 => Opcode::PseudoVMULHU_VV_M8_MASK,
          7387 => Opcode::PseudoVMULHU_VV_MF2,
          7388 => Opcode::PseudoVMULHU_VV_MF2_MASK,
          7389 => Opcode::PseudoVMULHU_VV_MF4,
          7390 => Opcode::PseudoVMULHU_VV_MF4_MASK,
          7391 => Opcode::PseudoVMULHU_VV_MF8,
          7392 => Opcode::PseudoVMULHU_VV_MF8_MASK,
          7393 => Opcode::PseudoVMULHU_VX_M1,
          7394 => Opcode::PseudoVMULHU_VX_M1_MASK,
          7395 => Opcode::PseudoVMULHU_VX_M2,
          7396 => Opcode::PseudoVMULHU_VX_M2_MASK,
          7397 => Opcode::PseudoVMULHU_VX_M4,
          7398 => Opcode::PseudoVMULHU_VX_M4_MASK,
          7399 => Opcode::PseudoVMULHU_VX_M8,
          7400 => Opcode::PseudoVMULHU_VX_M8_MASK,
          7401 => Opcode::PseudoVMULHU_VX_MF2,
          7402 => Opcode::PseudoVMULHU_VX_MF2_MASK,
          7403 => Opcode::PseudoVMULHU_VX_MF4,
          7404 => Opcode::PseudoVMULHU_VX_MF4_MASK,
          7405 => Opcode::PseudoVMULHU_VX_MF8,
          7406 => Opcode::PseudoVMULHU_VX_MF8_MASK,
          7407 => Opcode::PseudoVMULH_VV_M1,
          7408 => Opcode::PseudoVMULH_VV_M1_MASK,
          7409 => Opcode::PseudoVMULH_VV_M2,
          7410 => Opcode::PseudoVMULH_VV_M2_MASK,
          7411 => Opcode::PseudoVMULH_VV_M4,
          7412 => Opcode::PseudoVMULH_VV_M4_MASK,
          7413 => Opcode::PseudoVMULH_VV_M8,
          7414 => Opcode::PseudoVMULH_VV_M8_MASK,
          7415 => Opcode::PseudoVMULH_VV_MF2,
          7416 => Opcode::PseudoVMULH_VV_MF2_MASK,
          7417 => Opcode::PseudoVMULH_VV_MF4,
          7418 => Opcode::PseudoVMULH_VV_MF4_MASK,
          7419 => Opcode::PseudoVMULH_VV_MF8,
          7420 => Opcode::PseudoVMULH_VV_MF8_MASK,
          7421 => Opcode::PseudoVMULH_VX_M1,
          7422 => Opcode::PseudoVMULH_VX_M1_MASK,
          7423 => Opcode::PseudoVMULH_VX_M2,
          7424 => Opcode::PseudoVMULH_VX_M2_MASK,
          7425 => Opcode::PseudoVMULH_VX_M4,
          7426 => Opcode::PseudoVMULH_VX_M4_MASK,
          7427 => Opcode::PseudoVMULH_VX_M8,
          7428 => Opcode::PseudoVMULH_VX_M8_MASK,
          7429 => Opcode::PseudoVMULH_VX_MF2,
          7430 => Opcode::PseudoVMULH_VX_MF2_MASK,
          7431 => Opcode::PseudoVMULH_VX_MF4,
          7432 => Opcode::PseudoVMULH_VX_MF4_MASK,
          7433 => Opcode::PseudoVMULH_VX_MF8,
          7434 => Opcode::PseudoVMULH_VX_MF8_MASK,
          7435 => Opcode::PseudoVMUL_VV_M1,
          7436 => Opcode::PseudoVMUL_VV_M1_MASK,
          7437 => Opcode::PseudoVMUL_VV_M2,
          7438 => Opcode::PseudoVMUL_VV_M2_MASK,
          7439 => Opcode::PseudoVMUL_VV_M4,
          7440 => Opcode::PseudoVMUL_VV_M4_MASK,
          7441 => Opcode::PseudoVMUL_VV_M8,
          7442 => Opcode::PseudoVMUL_VV_M8_MASK,
          7443 => Opcode::PseudoVMUL_VV_MF2,
          7444 => Opcode::PseudoVMUL_VV_MF2_MASK,
          7445 => Opcode::PseudoVMUL_VV_MF4,
          7446 => Opcode::PseudoVMUL_VV_MF4_MASK,
          7447 => Opcode::PseudoVMUL_VV_MF8,
          7448 => Opcode::PseudoVMUL_VV_MF8_MASK,
          7449 => Opcode::PseudoVMUL_VX_M1,
          7450 => Opcode::PseudoVMUL_VX_M1_MASK,
          7451 => Opcode::PseudoVMUL_VX_M2,
          7452 => Opcode::PseudoVMUL_VX_M2_MASK,
          7453 => Opcode::PseudoVMUL_VX_M4,
          7454 => Opcode::PseudoVMUL_VX_M4_MASK,
          7455 => Opcode::PseudoVMUL_VX_M8,
          7456 => Opcode::PseudoVMUL_VX_M8_MASK,
          7457 => Opcode::PseudoVMUL_VX_MF2,
          7458 => Opcode::PseudoVMUL_VX_MF2_MASK,
          7459 => Opcode::PseudoVMUL_VX_MF4,
          7460 => Opcode::PseudoVMUL_VX_MF4_MASK,
          7461 => Opcode::PseudoVMUL_VX_MF8,
          7462 => Opcode::PseudoVMUL_VX_MF8_MASK,
          7463 => Opcode::PseudoVMV_S_X,
          7464 => Opcode::PseudoVMV_V_I_M1,
          7465 => Opcode::PseudoVMV_V_I_M2,
          7466 => Opcode::PseudoVMV_V_I_M4,
          7467 => Opcode::PseudoVMV_V_I_M8,
          7468 => Opcode::PseudoVMV_V_I_MF2,
          7469 => Opcode::PseudoVMV_V_I_MF4,
          7470 => Opcode::PseudoVMV_V_I_MF8,
          7471 => Opcode::PseudoVMV_V_V_M1,
          7472 => Opcode::PseudoVMV_V_V_M2,
          7473 => Opcode::PseudoVMV_V_V_M4,
          7474 => Opcode::PseudoVMV_V_V_M8,
          7475 => Opcode::PseudoVMV_V_V_MF2,
          7476 => Opcode::PseudoVMV_V_V_MF4,
          7477 => Opcode::PseudoVMV_V_V_MF8,
          7478 => Opcode::PseudoVMV_V_X_M1,
          7479 => Opcode::PseudoVMV_V_X_M2,
          7480 => Opcode::PseudoVMV_V_X_M4,
          7481 => Opcode::PseudoVMV_V_X_M8,
          7482 => Opcode::PseudoVMV_V_X_MF2,
          7483 => Opcode::PseudoVMV_V_X_MF4,
          7484 => Opcode::PseudoVMV_V_X_MF8,
          7485 => Opcode::PseudoVMV_X_S,
          7486 => Opcode::PseudoVMXNOR_MM_B1,
          7487 => Opcode::PseudoVMXNOR_MM_B16,
          7488 => Opcode::PseudoVMXNOR_MM_B2,
          7489 => Opcode::PseudoVMXNOR_MM_B32,
          7490 => Opcode::PseudoVMXNOR_MM_B4,
          7491 => Opcode::PseudoVMXNOR_MM_B64,
          7492 => Opcode::PseudoVMXNOR_MM_B8,
          7493 => Opcode::PseudoVMXOR_MM_B1,
          7494 => Opcode::PseudoVMXOR_MM_B16,
          7495 => Opcode::PseudoVMXOR_MM_B2,
          7496 => Opcode::PseudoVMXOR_MM_B32,
          7497 => Opcode::PseudoVMXOR_MM_B4,
          7498 => Opcode::PseudoVMXOR_MM_B64,
          7499 => Opcode::PseudoVMXOR_MM_B8,
          7500 => Opcode::PseudoVNCLIPU_WI_M1,
          7501 => Opcode::PseudoVNCLIPU_WI_M1_MASK,
          7502 => Opcode::PseudoVNCLIPU_WI_M2,
          7503 => Opcode::PseudoVNCLIPU_WI_M2_MASK,
          7504 => Opcode::PseudoVNCLIPU_WI_M4,
          7505 => Opcode::PseudoVNCLIPU_WI_M4_MASK,
          7506 => Opcode::PseudoVNCLIPU_WI_MF2,
          7507 => Opcode::PseudoVNCLIPU_WI_MF2_MASK,
          7508 => Opcode::PseudoVNCLIPU_WI_MF4,
          7509 => Opcode::PseudoVNCLIPU_WI_MF4_MASK,
          7510 => Opcode::PseudoVNCLIPU_WI_MF8,
          7511 => Opcode::PseudoVNCLIPU_WI_MF8_MASK,
          7512 => Opcode::PseudoVNCLIPU_WV_M1,
          7513 => Opcode::PseudoVNCLIPU_WV_M1_MASK,
          7514 => Opcode::PseudoVNCLIPU_WV_M2,
          7515 => Opcode::PseudoVNCLIPU_WV_M2_MASK,
          7516 => Opcode::PseudoVNCLIPU_WV_M4,
          7517 => Opcode::PseudoVNCLIPU_WV_M4_MASK,
          7518 => Opcode::PseudoVNCLIPU_WV_MF2,
          7519 => Opcode::PseudoVNCLIPU_WV_MF2_MASK,
          7520 => Opcode::PseudoVNCLIPU_WV_MF4,
          7521 => Opcode::PseudoVNCLIPU_WV_MF4_MASK,
          7522 => Opcode::PseudoVNCLIPU_WV_MF8,
          7523 => Opcode::PseudoVNCLIPU_WV_MF8_MASK,
          7524 => Opcode::PseudoVNCLIPU_WX_M1,
          7525 => Opcode::PseudoVNCLIPU_WX_M1_MASK,
          7526 => Opcode::PseudoVNCLIPU_WX_M2,
          7527 => Opcode::PseudoVNCLIPU_WX_M2_MASK,
          7528 => Opcode::PseudoVNCLIPU_WX_M4,
          7529 => Opcode::PseudoVNCLIPU_WX_M4_MASK,
          7530 => Opcode::PseudoVNCLIPU_WX_MF2,
          7531 => Opcode::PseudoVNCLIPU_WX_MF2_MASK,
          7532 => Opcode::PseudoVNCLIPU_WX_MF4,
          7533 => Opcode::PseudoVNCLIPU_WX_MF4_MASK,
          7534 => Opcode::PseudoVNCLIPU_WX_MF8,
          7535 => Opcode::PseudoVNCLIPU_WX_MF8_MASK,
          7536 => Opcode::PseudoVNCLIP_WI_M1,
          7537 => Opcode::PseudoVNCLIP_WI_M1_MASK,
          7538 => Opcode::PseudoVNCLIP_WI_M2,
          7539 => Opcode::PseudoVNCLIP_WI_M2_MASK,
          7540 => Opcode::PseudoVNCLIP_WI_M4,
          7541 => Opcode::PseudoVNCLIP_WI_M4_MASK,
          7542 => Opcode::PseudoVNCLIP_WI_MF2,
          7543 => Opcode::PseudoVNCLIP_WI_MF2_MASK,
          7544 => Opcode::PseudoVNCLIP_WI_MF4,
          7545 => Opcode::PseudoVNCLIP_WI_MF4_MASK,
          7546 => Opcode::PseudoVNCLIP_WI_MF8,
          7547 => Opcode::PseudoVNCLIP_WI_MF8_MASK,
          7548 => Opcode::PseudoVNCLIP_WV_M1,
          7549 => Opcode::PseudoVNCLIP_WV_M1_MASK,
          7550 => Opcode::PseudoVNCLIP_WV_M2,
          7551 => Opcode::PseudoVNCLIP_WV_M2_MASK,
          7552 => Opcode::PseudoVNCLIP_WV_M4,
          7553 => Opcode::PseudoVNCLIP_WV_M4_MASK,
          7554 => Opcode::PseudoVNCLIP_WV_MF2,
          7555 => Opcode::PseudoVNCLIP_WV_MF2_MASK,
          7556 => Opcode::PseudoVNCLIP_WV_MF4,
          7557 => Opcode::PseudoVNCLIP_WV_MF4_MASK,
          7558 => Opcode::PseudoVNCLIP_WV_MF8,
          7559 => Opcode::PseudoVNCLIP_WV_MF8_MASK,
          7560 => Opcode::PseudoVNCLIP_WX_M1,
          7561 => Opcode::PseudoVNCLIP_WX_M1_MASK,
          7562 => Opcode::PseudoVNCLIP_WX_M2,
          7563 => Opcode::PseudoVNCLIP_WX_M2_MASK,
          7564 => Opcode::PseudoVNCLIP_WX_M4,
          7565 => Opcode::PseudoVNCLIP_WX_M4_MASK,
          7566 => Opcode::PseudoVNCLIP_WX_MF2,
          7567 => Opcode::PseudoVNCLIP_WX_MF2_MASK,
          7568 => Opcode::PseudoVNCLIP_WX_MF4,
          7569 => Opcode::PseudoVNCLIP_WX_MF4_MASK,
          7570 => Opcode::PseudoVNCLIP_WX_MF8,
          7571 => Opcode::PseudoVNCLIP_WX_MF8_MASK,
          7572 => Opcode::PseudoVNMSAC_VV_M1,
          7573 => Opcode::PseudoVNMSAC_VV_M1_MASK,
          7574 => Opcode::PseudoVNMSAC_VV_M2,
          7575 => Opcode::PseudoVNMSAC_VV_M2_MASK,
          7576 => Opcode::PseudoVNMSAC_VV_M4,
          7577 => Opcode::PseudoVNMSAC_VV_M4_MASK,
          7578 => Opcode::PseudoVNMSAC_VV_M8,
          7579 => Opcode::PseudoVNMSAC_VV_M8_MASK,
          7580 => Opcode::PseudoVNMSAC_VV_MF2,
          7581 => Opcode::PseudoVNMSAC_VV_MF2_MASK,
          7582 => Opcode::PseudoVNMSAC_VV_MF4,
          7583 => Opcode::PseudoVNMSAC_VV_MF4_MASK,
          7584 => Opcode::PseudoVNMSAC_VV_MF8,
          7585 => Opcode::PseudoVNMSAC_VV_MF8_MASK,
          7586 => Opcode::PseudoVNMSAC_VX_M1,
          7587 => Opcode::PseudoVNMSAC_VX_M1_MASK,
          7588 => Opcode::PseudoVNMSAC_VX_M2,
          7589 => Opcode::PseudoVNMSAC_VX_M2_MASK,
          7590 => Opcode::PseudoVNMSAC_VX_M4,
          7591 => Opcode::PseudoVNMSAC_VX_M4_MASK,
          7592 => Opcode::PseudoVNMSAC_VX_M8,
          7593 => Opcode::PseudoVNMSAC_VX_M8_MASK,
          7594 => Opcode::PseudoVNMSAC_VX_MF2,
          7595 => Opcode::PseudoVNMSAC_VX_MF2_MASK,
          7596 => Opcode::PseudoVNMSAC_VX_MF4,
          7597 => Opcode::PseudoVNMSAC_VX_MF4_MASK,
          7598 => Opcode::PseudoVNMSAC_VX_MF8,
          7599 => Opcode::PseudoVNMSAC_VX_MF8_MASK,
          7600 => Opcode::PseudoVNMSUB_VV_M1,
          7601 => Opcode::PseudoVNMSUB_VV_M1_MASK,
          7602 => Opcode::PseudoVNMSUB_VV_M2,
          7603 => Opcode::PseudoVNMSUB_VV_M2_MASK,
          7604 => Opcode::PseudoVNMSUB_VV_M4,
          7605 => Opcode::PseudoVNMSUB_VV_M4_MASK,
          7606 => Opcode::PseudoVNMSUB_VV_M8,
          7607 => Opcode::PseudoVNMSUB_VV_M8_MASK,
          7608 => Opcode::PseudoVNMSUB_VV_MF2,
          7609 => Opcode::PseudoVNMSUB_VV_MF2_MASK,
          7610 => Opcode::PseudoVNMSUB_VV_MF4,
          7611 => Opcode::PseudoVNMSUB_VV_MF4_MASK,
          7612 => Opcode::PseudoVNMSUB_VV_MF8,
          7613 => Opcode::PseudoVNMSUB_VV_MF8_MASK,
          7614 => Opcode::PseudoVNMSUB_VX_M1,
          7615 => Opcode::PseudoVNMSUB_VX_M1_MASK,
          7616 => Opcode::PseudoVNMSUB_VX_M2,
          7617 => Opcode::PseudoVNMSUB_VX_M2_MASK,
          7618 => Opcode::PseudoVNMSUB_VX_M4,
          7619 => Opcode::PseudoVNMSUB_VX_M4_MASK,
          7620 => Opcode::PseudoVNMSUB_VX_M8,
          7621 => Opcode::PseudoVNMSUB_VX_M8_MASK,
          7622 => Opcode::PseudoVNMSUB_VX_MF2,
          7623 => Opcode::PseudoVNMSUB_VX_MF2_MASK,
          7624 => Opcode::PseudoVNMSUB_VX_MF4,
          7625 => Opcode::PseudoVNMSUB_VX_MF4_MASK,
          7626 => Opcode::PseudoVNMSUB_VX_MF8,
          7627 => Opcode::PseudoVNMSUB_VX_MF8_MASK,
          7628 => Opcode::PseudoVNSRA_WI_M1,
          7629 => Opcode::PseudoVNSRA_WI_M1_MASK,
          7630 => Opcode::PseudoVNSRA_WI_M2,
          7631 => Opcode::PseudoVNSRA_WI_M2_MASK,
          7632 => Opcode::PseudoVNSRA_WI_M4,
          7633 => Opcode::PseudoVNSRA_WI_M4_MASK,
          7634 => Opcode::PseudoVNSRA_WI_MF2,
          7635 => Opcode::PseudoVNSRA_WI_MF2_MASK,
          7636 => Opcode::PseudoVNSRA_WI_MF4,
          7637 => Opcode::PseudoVNSRA_WI_MF4_MASK,
          7638 => Opcode::PseudoVNSRA_WI_MF8,
          7639 => Opcode::PseudoVNSRA_WI_MF8_MASK,
          7640 => Opcode::PseudoVNSRA_WV_M1,
          7641 => Opcode::PseudoVNSRA_WV_M1_MASK,
          7642 => Opcode::PseudoVNSRA_WV_M2,
          7643 => Opcode::PseudoVNSRA_WV_M2_MASK,
          7644 => Opcode::PseudoVNSRA_WV_M4,
          7645 => Opcode::PseudoVNSRA_WV_M4_MASK,
          7646 => Opcode::PseudoVNSRA_WV_MF2,
          7647 => Opcode::PseudoVNSRA_WV_MF2_MASK,
          7648 => Opcode::PseudoVNSRA_WV_MF4,
          7649 => Opcode::PseudoVNSRA_WV_MF4_MASK,
          7650 => Opcode::PseudoVNSRA_WV_MF8,
          7651 => Opcode::PseudoVNSRA_WV_MF8_MASK,
          7652 => Opcode::PseudoVNSRA_WX_M1,
          7653 => Opcode::PseudoVNSRA_WX_M1_MASK,
          7654 => Opcode::PseudoVNSRA_WX_M2,
          7655 => Opcode::PseudoVNSRA_WX_M2_MASK,
          7656 => Opcode::PseudoVNSRA_WX_M4,
          7657 => Opcode::PseudoVNSRA_WX_M4_MASK,
          7658 => Opcode::PseudoVNSRA_WX_MF2,
          7659 => Opcode::PseudoVNSRA_WX_MF2_MASK,
          7660 => Opcode::PseudoVNSRA_WX_MF4,
          7661 => Opcode::PseudoVNSRA_WX_MF4_MASK,
          7662 => Opcode::PseudoVNSRA_WX_MF8,
          7663 => Opcode::PseudoVNSRA_WX_MF8_MASK,
          7664 => Opcode::PseudoVNSRL_WI_M1,
          7665 => Opcode::PseudoVNSRL_WI_M1_MASK,
          7666 => Opcode::PseudoVNSRL_WI_M2,
          7667 => Opcode::PseudoVNSRL_WI_M2_MASK,
          7668 => Opcode::PseudoVNSRL_WI_M4,
          7669 => Opcode::PseudoVNSRL_WI_M4_MASK,
          7670 => Opcode::PseudoVNSRL_WI_MF2,
          7671 => Opcode::PseudoVNSRL_WI_MF2_MASK,
          7672 => Opcode::PseudoVNSRL_WI_MF4,
          7673 => Opcode::PseudoVNSRL_WI_MF4_MASK,
          7674 => Opcode::PseudoVNSRL_WI_MF8,
          7675 => Opcode::PseudoVNSRL_WI_MF8_MASK,
          7676 => Opcode::PseudoVNSRL_WV_M1,
          7677 => Opcode::PseudoVNSRL_WV_M1_MASK,
          7678 => Opcode::PseudoVNSRL_WV_M2,
          7679 => Opcode::PseudoVNSRL_WV_M2_MASK,
          7680 => Opcode::PseudoVNSRL_WV_M4,
          7681 => Opcode::PseudoVNSRL_WV_M4_MASK,
          7682 => Opcode::PseudoVNSRL_WV_MF2,
          7683 => Opcode::PseudoVNSRL_WV_MF2_MASK,
          7684 => Opcode::PseudoVNSRL_WV_MF4,
          7685 => Opcode::PseudoVNSRL_WV_MF4_MASK,
          7686 => Opcode::PseudoVNSRL_WV_MF8,
          7687 => Opcode::PseudoVNSRL_WV_MF8_MASK,
          7688 => Opcode::PseudoVNSRL_WX_M1,
          7689 => Opcode::PseudoVNSRL_WX_M1_MASK,
          7690 => Opcode::PseudoVNSRL_WX_M2,
          7691 => Opcode::PseudoVNSRL_WX_M2_MASK,
          7692 => Opcode::PseudoVNSRL_WX_M4,
          7693 => Opcode::PseudoVNSRL_WX_M4_MASK,
          7694 => Opcode::PseudoVNSRL_WX_MF2,
          7695 => Opcode::PseudoVNSRL_WX_MF2_MASK,
          7696 => Opcode::PseudoVNSRL_WX_MF4,
          7697 => Opcode::PseudoVNSRL_WX_MF4_MASK,
          7698 => Opcode::PseudoVNSRL_WX_MF8,
          7699 => Opcode::PseudoVNSRL_WX_MF8_MASK,
          7700 => Opcode::PseudoVOR_VI_M1,
          7701 => Opcode::PseudoVOR_VI_M1_MASK,
          7702 => Opcode::PseudoVOR_VI_M2,
          7703 => Opcode::PseudoVOR_VI_M2_MASK,
          7704 => Opcode::PseudoVOR_VI_M4,
          7705 => Opcode::PseudoVOR_VI_M4_MASK,
          7706 => Opcode::PseudoVOR_VI_M8,
          7707 => Opcode::PseudoVOR_VI_M8_MASK,
          7708 => Opcode::PseudoVOR_VI_MF2,
          7709 => Opcode::PseudoVOR_VI_MF2_MASK,
          7710 => Opcode::PseudoVOR_VI_MF4,
          7711 => Opcode::PseudoVOR_VI_MF4_MASK,
          7712 => Opcode::PseudoVOR_VI_MF8,
          7713 => Opcode::PseudoVOR_VI_MF8_MASK,
          7714 => Opcode::PseudoVOR_VV_M1,
          7715 => Opcode::PseudoVOR_VV_M1_MASK,
          7716 => Opcode::PseudoVOR_VV_M2,
          7717 => Opcode::PseudoVOR_VV_M2_MASK,
          7718 => Opcode::PseudoVOR_VV_M4,
          7719 => Opcode::PseudoVOR_VV_M4_MASK,
          7720 => Opcode::PseudoVOR_VV_M8,
          7721 => Opcode::PseudoVOR_VV_M8_MASK,
          7722 => Opcode::PseudoVOR_VV_MF2,
          7723 => Opcode::PseudoVOR_VV_MF2_MASK,
          7724 => Opcode::PseudoVOR_VV_MF4,
          7725 => Opcode::PseudoVOR_VV_MF4_MASK,
          7726 => Opcode::PseudoVOR_VV_MF8,
          7727 => Opcode::PseudoVOR_VV_MF8_MASK,
          7728 => Opcode::PseudoVOR_VX_M1,
          7729 => Opcode::PseudoVOR_VX_M1_MASK,
          7730 => Opcode::PseudoVOR_VX_M2,
          7731 => Opcode::PseudoVOR_VX_M2_MASK,
          7732 => Opcode::PseudoVOR_VX_M4,
          7733 => Opcode::PseudoVOR_VX_M4_MASK,
          7734 => Opcode::PseudoVOR_VX_M8,
          7735 => Opcode::PseudoVOR_VX_M8_MASK,
          7736 => Opcode::PseudoVOR_VX_MF2,
          7737 => Opcode::PseudoVOR_VX_MF2_MASK,
          7738 => Opcode::PseudoVOR_VX_MF4,
          7739 => Opcode::PseudoVOR_VX_MF4_MASK,
          7740 => Opcode::PseudoVOR_VX_MF8,
          7741 => Opcode::PseudoVOR_VX_MF8_MASK,
          7742 => Opcode::PseudoVQDOTSU_VV_M1,
          7743 => Opcode::PseudoVQDOTSU_VV_M1_MASK,
          7744 => Opcode::PseudoVQDOTSU_VV_M2,
          7745 => Opcode::PseudoVQDOTSU_VV_M2_MASK,
          7746 => Opcode::PseudoVQDOTSU_VV_M4,
          7747 => Opcode::PseudoVQDOTSU_VV_M4_MASK,
          7748 => Opcode::PseudoVQDOTSU_VV_M8,
          7749 => Opcode::PseudoVQDOTSU_VV_M8_MASK,
          7750 => Opcode::PseudoVQDOTSU_VV_MF2,
          7751 => Opcode::PseudoVQDOTSU_VV_MF2_MASK,
          7752 => Opcode::PseudoVQDOTSU_VX_M1,
          7753 => Opcode::PseudoVQDOTSU_VX_M1_MASK,
          7754 => Opcode::PseudoVQDOTSU_VX_M2,
          7755 => Opcode::PseudoVQDOTSU_VX_M2_MASK,
          7756 => Opcode::PseudoVQDOTSU_VX_M4,
          7757 => Opcode::PseudoVQDOTSU_VX_M4_MASK,
          7758 => Opcode::PseudoVQDOTSU_VX_M8,
          7759 => Opcode::PseudoVQDOTSU_VX_M8_MASK,
          7760 => Opcode::PseudoVQDOTSU_VX_MF2,
          7761 => Opcode::PseudoVQDOTSU_VX_MF2_MASK,
          7762 => Opcode::PseudoVQDOTU_VV_M1,
          7763 => Opcode::PseudoVQDOTU_VV_M1_MASK,
          7764 => Opcode::PseudoVQDOTU_VV_M2,
          7765 => Opcode::PseudoVQDOTU_VV_M2_MASK,
          7766 => Opcode::PseudoVQDOTU_VV_M4,
          7767 => Opcode::PseudoVQDOTU_VV_M4_MASK,
          7768 => Opcode::PseudoVQDOTU_VV_M8,
          7769 => Opcode::PseudoVQDOTU_VV_M8_MASK,
          7770 => Opcode::PseudoVQDOTU_VV_MF2,
          7771 => Opcode::PseudoVQDOTU_VV_MF2_MASK,
          7772 => Opcode::PseudoVQDOTU_VX_M1,
          7773 => Opcode::PseudoVQDOTU_VX_M1_MASK,
          7774 => Opcode::PseudoVQDOTU_VX_M2,
          7775 => Opcode::PseudoVQDOTU_VX_M2_MASK,
          7776 => Opcode::PseudoVQDOTU_VX_M4,
          7777 => Opcode::PseudoVQDOTU_VX_M4_MASK,
          7778 => Opcode::PseudoVQDOTU_VX_M8,
          7779 => Opcode::PseudoVQDOTU_VX_M8_MASK,
          7780 => Opcode::PseudoVQDOTU_VX_MF2,
          7781 => Opcode::PseudoVQDOTU_VX_MF2_MASK,
          7782 => Opcode::PseudoVQDOT_VV_M1,
          7783 => Opcode::PseudoVQDOT_VV_M1_MASK,
          7784 => Opcode::PseudoVQDOT_VV_M2,
          7785 => Opcode::PseudoVQDOT_VV_M2_MASK,
          7786 => Opcode::PseudoVQDOT_VV_M4,
          7787 => Opcode::PseudoVQDOT_VV_M4_MASK,
          7788 => Opcode::PseudoVQDOT_VV_M8,
          7789 => Opcode::PseudoVQDOT_VV_M8_MASK,
          7790 => Opcode::PseudoVQDOT_VV_MF2,
          7791 => Opcode::PseudoVQDOT_VV_MF2_MASK,
          7792 => Opcode::PseudoVQDOT_VX_M1,
          7793 => Opcode::PseudoVQDOT_VX_M1_MASK,
          7794 => Opcode::PseudoVQDOT_VX_M2,
          7795 => Opcode::PseudoVQDOT_VX_M2_MASK,
          7796 => Opcode::PseudoVQDOT_VX_M4,
          7797 => Opcode::PseudoVQDOT_VX_M4_MASK,
          7798 => Opcode::PseudoVQDOT_VX_M8,
          7799 => Opcode::PseudoVQDOT_VX_M8_MASK,
          7800 => Opcode::PseudoVQDOT_VX_MF2,
          7801 => Opcode::PseudoVQDOT_VX_MF2_MASK,
          7802 => Opcode::PseudoVREDAND_VS_M1_E16,
          7803 => Opcode::PseudoVREDAND_VS_M1_E16_MASK,
          7804 => Opcode::PseudoVREDAND_VS_M1_E32,
          7805 => Opcode::PseudoVREDAND_VS_M1_E32_MASK,
          7806 => Opcode::PseudoVREDAND_VS_M1_E64,
          7807 => Opcode::PseudoVREDAND_VS_M1_E64_MASK,
          7808 => Opcode::PseudoVREDAND_VS_M1_E8,
          7809 => Opcode::PseudoVREDAND_VS_M1_E8_MASK,
          7810 => Opcode::PseudoVREDAND_VS_M2_E16,
          7811 => Opcode::PseudoVREDAND_VS_M2_E16_MASK,
          7812 => Opcode::PseudoVREDAND_VS_M2_E32,
          7813 => Opcode::PseudoVREDAND_VS_M2_E32_MASK,
          7814 => Opcode::PseudoVREDAND_VS_M2_E64,
          7815 => Opcode::PseudoVREDAND_VS_M2_E64_MASK,
          7816 => Opcode::PseudoVREDAND_VS_M2_E8,
          7817 => Opcode::PseudoVREDAND_VS_M2_E8_MASK,
          7818 => Opcode::PseudoVREDAND_VS_M4_E16,
          7819 => Opcode::PseudoVREDAND_VS_M4_E16_MASK,
          7820 => Opcode::PseudoVREDAND_VS_M4_E32,
          7821 => Opcode::PseudoVREDAND_VS_M4_E32_MASK,
          7822 => Opcode::PseudoVREDAND_VS_M4_E64,
          7823 => Opcode::PseudoVREDAND_VS_M4_E64_MASK,
          7824 => Opcode::PseudoVREDAND_VS_M4_E8,
          7825 => Opcode::PseudoVREDAND_VS_M4_E8_MASK,
          7826 => Opcode::PseudoVREDAND_VS_M8_E16,
          7827 => Opcode::PseudoVREDAND_VS_M8_E16_MASK,
          7828 => Opcode::PseudoVREDAND_VS_M8_E32,
          7829 => Opcode::PseudoVREDAND_VS_M8_E32_MASK,
          7830 => Opcode::PseudoVREDAND_VS_M8_E64,
          7831 => Opcode::PseudoVREDAND_VS_M8_E64_MASK,
          7832 => Opcode::PseudoVREDAND_VS_M8_E8,
          7833 => Opcode::PseudoVREDAND_VS_M8_E8_MASK,
          7834 => Opcode::PseudoVREDAND_VS_MF2_E16,
          7835 => Opcode::PseudoVREDAND_VS_MF2_E16_MASK,
          7836 => Opcode::PseudoVREDAND_VS_MF2_E32,
          7837 => Opcode::PseudoVREDAND_VS_MF2_E32_MASK,
          7838 => Opcode::PseudoVREDAND_VS_MF2_E8,
          7839 => Opcode::PseudoVREDAND_VS_MF2_E8_MASK,
          7840 => Opcode::PseudoVREDAND_VS_MF4_E16,
          7841 => Opcode::PseudoVREDAND_VS_MF4_E16_MASK,
          7842 => Opcode::PseudoVREDAND_VS_MF4_E8,
          7843 => Opcode::PseudoVREDAND_VS_MF4_E8_MASK,
          7844 => Opcode::PseudoVREDAND_VS_MF8_E8,
          7845 => Opcode::PseudoVREDAND_VS_MF8_E8_MASK,
          7846 => Opcode::PseudoVREDMAXU_VS_M1_E16,
          7847 => Opcode::PseudoVREDMAXU_VS_M1_E16_MASK,
          7848 => Opcode::PseudoVREDMAXU_VS_M1_E32,
          7849 => Opcode::PseudoVREDMAXU_VS_M1_E32_MASK,
          7850 => Opcode::PseudoVREDMAXU_VS_M1_E64,
          7851 => Opcode::PseudoVREDMAXU_VS_M1_E64_MASK,
          7852 => Opcode::PseudoVREDMAXU_VS_M1_E8,
          7853 => Opcode::PseudoVREDMAXU_VS_M1_E8_MASK,
          7854 => Opcode::PseudoVREDMAXU_VS_M2_E16,
          7855 => Opcode::PseudoVREDMAXU_VS_M2_E16_MASK,
          7856 => Opcode::PseudoVREDMAXU_VS_M2_E32,
          7857 => Opcode::PseudoVREDMAXU_VS_M2_E32_MASK,
          7858 => Opcode::PseudoVREDMAXU_VS_M2_E64,
          7859 => Opcode::PseudoVREDMAXU_VS_M2_E64_MASK,
          7860 => Opcode::PseudoVREDMAXU_VS_M2_E8,
          7861 => Opcode::PseudoVREDMAXU_VS_M2_E8_MASK,
          7862 => Opcode::PseudoVREDMAXU_VS_M4_E16,
          7863 => Opcode::PseudoVREDMAXU_VS_M4_E16_MASK,
          7864 => Opcode::PseudoVREDMAXU_VS_M4_E32,
          7865 => Opcode::PseudoVREDMAXU_VS_M4_E32_MASK,
          7866 => Opcode::PseudoVREDMAXU_VS_M4_E64,
          7867 => Opcode::PseudoVREDMAXU_VS_M4_E64_MASK,
          7868 => Opcode::PseudoVREDMAXU_VS_M4_E8,
          7869 => Opcode::PseudoVREDMAXU_VS_M4_E8_MASK,
          7870 => Opcode::PseudoVREDMAXU_VS_M8_E16,
          7871 => Opcode::PseudoVREDMAXU_VS_M8_E16_MASK,
          7872 => Opcode::PseudoVREDMAXU_VS_M8_E32,
          7873 => Opcode::PseudoVREDMAXU_VS_M8_E32_MASK,
          7874 => Opcode::PseudoVREDMAXU_VS_M8_E64,
          7875 => Opcode::PseudoVREDMAXU_VS_M8_E64_MASK,
          7876 => Opcode::PseudoVREDMAXU_VS_M8_E8,
          7877 => Opcode::PseudoVREDMAXU_VS_M8_E8_MASK,
          7878 => Opcode::PseudoVREDMAXU_VS_MF2_E16,
          7879 => Opcode::PseudoVREDMAXU_VS_MF2_E16_MASK,
          7880 => Opcode::PseudoVREDMAXU_VS_MF2_E32,
          7881 => Opcode::PseudoVREDMAXU_VS_MF2_E32_MASK,
          7882 => Opcode::PseudoVREDMAXU_VS_MF2_E8,
          7883 => Opcode::PseudoVREDMAXU_VS_MF2_E8_MASK,
          7884 => Opcode::PseudoVREDMAXU_VS_MF4_E16,
          7885 => Opcode::PseudoVREDMAXU_VS_MF4_E16_MASK,
          7886 => Opcode::PseudoVREDMAXU_VS_MF4_E8,
          7887 => Opcode::PseudoVREDMAXU_VS_MF4_E8_MASK,
          7888 => Opcode::PseudoVREDMAXU_VS_MF8_E8,
          7889 => Opcode::PseudoVREDMAXU_VS_MF8_E8_MASK,
          7890 => Opcode::PseudoVREDMAX_VS_M1_E16,
          7891 => Opcode::PseudoVREDMAX_VS_M1_E16_MASK,
          7892 => Opcode::PseudoVREDMAX_VS_M1_E32,
          7893 => Opcode::PseudoVREDMAX_VS_M1_E32_MASK,
          7894 => Opcode::PseudoVREDMAX_VS_M1_E64,
          7895 => Opcode::PseudoVREDMAX_VS_M1_E64_MASK,
          7896 => Opcode::PseudoVREDMAX_VS_M1_E8,
          7897 => Opcode::PseudoVREDMAX_VS_M1_E8_MASK,
          7898 => Opcode::PseudoVREDMAX_VS_M2_E16,
          7899 => Opcode::PseudoVREDMAX_VS_M2_E16_MASK,
          7900 => Opcode::PseudoVREDMAX_VS_M2_E32,
          7901 => Opcode::PseudoVREDMAX_VS_M2_E32_MASK,
          7902 => Opcode::PseudoVREDMAX_VS_M2_E64,
          7903 => Opcode::PseudoVREDMAX_VS_M2_E64_MASK,
          7904 => Opcode::PseudoVREDMAX_VS_M2_E8,
          7905 => Opcode::PseudoVREDMAX_VS_M2_E8_MASK,
          7906 => Opcode::PseudoVREDMAX_VS_M4_E16,
          7907 => Opcode::PseudoVREDMAX_VS_M4_E16_MASK,
          7908 => Opcode::PseudoVREDMAX_VS_M4_E32,
          7909 => Opcode::PseudoVREDMAX_VS_M4_E32_MASK,
          7910 => Opcode::PseudoVREDMAX_VS_M4_E64,
          7911 => Opcode::PseudoVREDMAX_VS_M4_E64_MASK,
          7912 => Opcode::PseudoVREDMAX_VS_M4_E8,
          7913 => Opcode::PseudoVREDMAX_VS_M4_E8_MASK,
          7914 => Opcode::PseudoVREDMAX_VS_M8_E16,
          7915 => Opcode::PseudoVREDMAX_VS_M8_E16_MASK,
          7916 => Opcode::PseudoVREDMAX_VS_M8_E32,
          7917 => Opcode::PseudoVREDMAX_VS_M8_E32_MASK,
          7918 => Opcode::PseudoVREDMAX_VS_M8_E64,
          7919 => Opcode::PseudoVREDMAX_VS_M8_E64_MASK,
          7920 => Opcode::PseudoVREDMAX_VS_M8_E8,
          7921 => Opcode::PseudoVREDMAX_VS_M8_E8_MASK,
          7922 => Opcode::PseudoVREDMAX_VS_MF2_E16,
          7923 => Opcode::PseudoVREDMAX_VS_MF2_E16_MASK,
          7924 => Opcode::PseudoVREDMAX_VS_MF2_E32,
          7925 => Opcode::PseudoVREDMAX_VS_MF2_E32_MASK,
          7926 => Opcode::PseudoVREDMAX_VS_MF2_E8,
          7927 => Opcode::PseudoVREDMAX_VS_MF2_E8_MASK,
          7928 => Opcode::PseudoVREDMAX_VS_MF4_E16,
          7929 => Opcode::PseudoVREDMAX_VS_MF4_E16_MASK,
          7930 => Opcode::PseudoVREDMAX_VS_MF4_E8,
          7931 => Opcode::PseudoVREDMAX_VS_MF4_E8_MASK,
          7932 => Opcode::PseudoVREDMAX_VS_MF8_E8,
          7933 => Opcode::PseudoVREDMAX_VS_MF8_E8_MASK,
          7934 => Opcode::PseudoVREDMINU_VS_M1_E16,
          7935 => Opcode::PseudoVREDMINU_VS_M1_E16_MASK,
          7936 => Opcode::PseudoVREDMINU_VS_M1_E32,
          7937 => Opcode::PseudoVREDMINU_VS_M1_E32_MASK,
          7938 => Opcode::PseudoVREDMINU_VS_M1_E64,
          7939 => Opcode::PseudoVREDMINU_VS_M1_E64_MASK,
          7940 => Opcode::PseudoVREDMINU_VS_M1_E8,
          7941 => Opcode::PseudoVREDMINU_VS_M1_E8_MASK,
          7942 => Opcode::PseudoVREDMINU_VS_M2_E16,
          7943 => Opcode::PseudoVREDMINU_VS_M2_E16_MASK,
          7944 => Opcode::PseudoVREDMINU_VS_M2_E32,
          7945 => Opcode::PseudoVREDMINU_VS_M2_E32_MASK,
          7946 => Opcode::PseudoVREDMINU_VS_M2_E64,
          7947 => Opcode::PseudoVREDMINU_VS_M2_E64_MASK,
          7948 => Opcode::PseudoVREDMINU_VS_M2_E8,
          7949 => Opcode::PseudoVREDMINU_VS_M2_E8_MASK,
          7950 => Opcode::PseudoVREDMINU_VS_M4_E16,
          7951 => Opcode::PseudoVREDMINU_VS_M4_E16_MASK,
          7952 => Opcode::PseudoVREDMINU_VS_M4_E32,
          7953 => Opcode::PseudoVREDMINU_VS_M4_E32_MASK,
          7954 => Opcode::PseudoVREDMINU_VS_M4_E64,
          7955 => Opcode::PseudoVREDMINU_VS_M4_E64_MASK,
          7956 => Opcode::PseudoVREDMINU_VS_M4_E8,
          7957 => Opcode::PseudoVREDMINU_VS_M4_E8_MASK,
          7958 => Opcode::PseudoVREDMINU_VS_M8_E16,
          7959 => Opcode::PseudoVREDMINU_VS_M8_E16_MASK,
          7960 => Opcode::PseudoVREDMINU_VS_M8_E32,
          7961 => Opcode::PseudoVREDMINU_VS_M8_E32_MASK,
          7962 => Opcode::PseudoVREDMINU_VS_M8_E64,
          7963 => Opcode::PseudoVREDMINU_VS_M8_E64_MASK,
          7964 => Opcode::PseudoVREDMINU_VS_M8_E8,
          7965 => Opcode::PseudoVREDMINU_VS_M8_E8_MASK,
          7966 => Opcode::PseudoVREDMINU_VS_MF2_E16,
          7967 => Opcode::PseudoVREDMINU_VS_MF2_E16_MASK,
          7968 => Opcode::PseudoVREDMINU_VS_MF2_E32,
          7969 => Opcode::PseudoVREDMINU_VS_MF2_E32_MASK,
          7970 => Opcode::PseudoVREDMINU_VS_MF2_E8,
          7971 => Opcode::PseudoVREDMINU_VS_MF2_E8_MASK,
          7972 => Opcode::PseudoVREDMINU_VS_MF4_E16,
          7973 => Opcode::PseudoVREDMINU_VS_MF4_E16_MASK,
          7974 => Opcode::PseudoVREDMINU_VS_MF4_E8,
          7975 => Opcode::PseudoVREDMINU_VS_MF4_E8_MASK,
          7976 => Opcode::PseudoVREDMINU_VS_MF8_E8,
          7977 => Opcode::PseudoVREDMINU_VS_MF8_E8_MASK,
          7978 => Opcode::PseudoVREDMIN_VS_M1_E16,
          7979 => Opcode::PseudoVREDMIN_VS_M1_E16_MASK,
          7980 => Opcode::PseudoVREDMIN_VS_M1_E32,
          7981 => Opcode::PseudoVREDMIN_VS_M1_E32_MASK,
          7982 => Opcode::PseudoVREDMIN_VS_M1_E64,
          7983 => Opcode::PseudoVREDMIN_VS_M1_E64_MASK,
          7984 => Opcode::PseudoVREDMIN_VS_M1_E8,
          7985 => Opcode::PseudoVREDMIN_VS_M1_E8_MASK,
          7986 => Opcode::PseudoVREDMIN_VS_M2_E16,
          7987 => Opcode::PseudoVREDMIN_VS_M2_E16_MASK,
          7988 => Opcode::PseudoVREDMIN_VS_M2_E32,
          7989 => Opcode::PseudoVREDMIN_VS_M2_E32_MASK,
          7990 => Opcode::PseudoVREDMIN_VS_M2_E64,
          7991 => Opcode::PseudoVREDMIN_VS_M2_E64_MASK,
          7992 => Opcode::PseudoVREDMIN_VS_M2_E8,
          7993 => Opcode::PseudoVREDMIN_VS_M2_E8_MASK,
          7994 => Opcode::PseudoVREDMIN_VS_M4_E16,
          7995 => Opcode::PseudoVREDMIN_VS_M4_E16_MASK,
          7996 => Opcode::PseudoVREDMIN_VS_M4_E32,
          7997 => Opcode::PseudoVREDMIN_VS_M4_E32_MASK,
          7998 => Opcode::PseudoVREDMIN_VS_M4_E64,
          7999 => Opcode::PseudoVREDMIN_VS_M4_E64_MASK,
          8000 => Opcode::PseudoVREDMIN_VS_M4_E8,
          8001 => Opcode::PseudoVREDMIN_VS_M4_E8_MASK,
          8002 => Opcode::PseudoVREDMIN_VS_M8_E16,
          8003 => Opcode::PseudoVREDMIN_VS_M8_E16_MASK,
          8004 => Opcode::PseudoVREDMIN_VS_M8_E32,
          8005 => Opcode::PseudoVREDMIN_VS_M8_E32_MASK,
          8006 => Opcode::PseudoVREDMIN_VS_M8_E64,
          8007 => Opcode::PseudoVREDMIN_VS_M8_E64_MASK,
          8008 => Opcode::PseudoVREDMIN_VS_M8_E8,
          8009 => Opcode::PseudoVREDMIN_VS_M8_E8_MASK,
          8010 => Opcode::PseudoVREDMIN_VS_MF2_E16,
          8011 => Opcode::PseudoVREDMIN_VS_MF2_E16_MASK,
          8012 => Opcode::PseudoVREDMIN_VS_MF2_E32,
          8013 => Opcode::PseudoVREDMIN_VS_MF2_E32_MASK,
          8014 => Opcode::PseudoVREDMIN_VS_MF2_E8,
          8015 => Opcode::PseudoVREDMIN_VS_MF2_E8_MASK,
          8016 => Opcode::PseudoVREDMIN_VS_MF4_E16,
          8017 => Opcode::PseudoVREDMIN_VS_MF4_E16_MASK,
          8018 => Opcode::PseudoVREDMIN_VS_MF4_E8,
          8019 => Opcode::PseudoVREDMIN_VS_MF4_E8_MASK,
          8020 => Opcode::PseudoVREDMIN_VS_MF8_E8,
          8021 => Opcode::PseudoVREDMIN_VS_MF8_E8_MASK,
          8022 => Opcode::PseudoVREDOR_VS_M1_E16,
          8023 => Opcode::PseudoVREDOR_VS_M1_E16_MASK,
          8024 => Opcode::PseudoVREDOR_VS_M1_E32,
          8025 => Opcode::PseudoVREDOR_VS_M1_E32_MASK,
          8026 => Opcode::PseudoVREDOR_VS_M1_E64,
          8027 => Opcode::PseudoVREDOR_VS_M1_E64_MASK,
          8028 => Opcode::PseudoVREDOR_VS_M1_E8,
          8029 => Opcode::PseudoVREDOR_VS_M1_E8_MASK,
          8030 => Opcode::PseudoVREDOR_VS_M2_E16,
          8031 => Opcode::PseudoVREDOR_VS_M2_E16_MASK,
          8032 => Opcode::PseudoVREDOR_VS_M2_E32,
          8033 => Opcode::PseudoVREDOR_VS_M2_E32_MASK,
          8034 => Opcode::PseudoVREDOR_VS_M2_E64,
          8035 => Opcode::PseudoVREDOR_VS_M2_E64_MASK,
          8036 => Opcode::PseudoVREDOR_VS_M2_E8,
          8037 => Opcode::PseudoVREDOR_VS_M2_E8_MASK,
          8038 => Opcode::PseudoVREDOR_VS_M4_E16,
          8039 => Opcode::PseudoVREDOR_VS_M4_E16_MASK,
          8040 => Opcode::PseudoVREDOR_VS_M4_E32,
          8041 => Opcode::PseudoVREDOR_VS_M4_E32_MASK,
          8042 => Opcode::PseudoVREDOR_VS_M4_E64,
          8043 => Opcode::PseudoVREDOR_VS_M4_E64_MASK,
          8044 => Opcode::PseudoVREDOR_VS_M4_E8,
          8045 => Opcode::PseudoVREDOR_VS_M4_E8_MASK,
          8046 => Opcode::PseudoVREDOR_VS_M8_E16,
          8047 => Opcode::PseudoVREDOR_VS_M8_E16_MASK,
          8048 => Opcode::PseudoVREDOR_VS_M8_E32,
          8049 => Opcode::PseudoVREDOR_VS_M8_E32_MASK,
          8050 => Opcode::PseudoVREDOR_VS_M8_E64,
          8051 => Opcode::PseudoVREDOR_VS_M8_E64_MASK,
          8052 => Opcode::PseudoVREDOR_VS_M8_E8,
          8053 => Opcode::PseudoVREDOR_VS_M8_E8_MASK,
          8054 => Opcode::PseudoVREDOR_VS_MF2_E16,
          8055 => Opcode::PseudoVREDOR_VS_MF2_E16_MASK,
          8056 => Opcode::PseudoVREDOR_VS_MF2_E32,
          8057 => Opcode::PseudoVREDOR_VS_MF2_E32_MASK,
          8058 => Opcode::PseudoVREDOR_VS_MF2_E8,
          8059 => Opcode::PseudoVREDOR_VS_MF2_E8_MASK,
          8060 => Opcode::PseudoVREDOR_VS_MF4_E16,
          8061 => Opcode::PseudoVREDOR_VS_MF4_E16_MASK,
          8062 => Opcode::PseudoVREDOR_VS_MF4_E8,
          8063 => Opcode::PseudoVREDOR_VS_MF4_E8_MASK,
          8064 => Opcode::PseudoVREDOR_VS_MF8_E8,
          8065 => Opcode::PseudoVREDOR_VS_MF8_E8_MASK,
          8066 => Opcode::PseudoVREDSUM_VS_M1_E16,
          8067 => Opcode::PseudoVREDSUM_VS_M1_E16_MASK,
          8068 => Opcode::PseudoVREDSUM_VS_M1_E32,
          8069 => Opcode::PseudoVREDSUM_VS_M1_E32_MASK,
          8070 => Opcode::PseudoVREDSUM_VS_M1_E64,
          8071 => Opcode::PseudoVREDSUM_VS_M1_E64_MASK,
          8072 => Opcode::PseudoVREDSUM_VS_M1_E8,
          8073 => Opcode::PseudoVREDSUM_VS_M1_E8_MASK,
          8074 => Opcode::PseudoVREDSUM_VS_M2_E16,
          8075 => Opcode::PseudoVREDSUM_VS_M2_E16_MASK,
          8076 => Opcode::PseudoVREDSUM_VS_M2_E32,
          8077 => Opcode::PseudoVREDSUM_VS_M2_E32_MASK,
          8078 => Opcode::PseudoVREDSUM_VS_M2_E64,
          8079 => Opcode::PseudoVREDSUM_VS_M2_E64_MASK,
          8080 => Opcode::PseudoVREDSUM_VS_M2_E8,
          8081 => Opcode::PseudoVREDSUM_VS_M2_E8_MASK,
          8082 => Opcode::PseudoVREDSUM_VS_M4_E16,
          8083 => Opcode::PseudoVREDSUM_VS_M4_E16_MASK,
          8084 => Opcode::PseudoVREDSUM_VS_M4_E32,
          8085 => Opcode::PseudoVREDSUM_VS_M4_E32_MASK,
          8086 => Opcode::PseudoVREDSUM_VS_M4_E64,
          8087 => Opcode::PseudoVREDSUM_VS_M4_E64_MASK,
          8088 => Opcode::PseudoVREDSUM_VS_M4_E8,
          8089 => Opcode::PseudoVREDSUM_VS_M4_E8_MASK,
          8090 => Opcode::PseudoVREDSUM_VS_M8_E16,
          8091 => Opcode::PseudoVREDSUM_VS_M8_E16_MASK,
          8092 => Opcode::PseudoVREDSUM_VS_M8_E32,
          8093 => Opcode::PseudoVREDSUM_VS_M8_E32_MASK,
          8094 => Opcode::PseudoVREDSUM_VS_M8_E64,
          8095 => Opcode::PseudoVREDSUM_VS_M8_E64_MASK,
          8096 => Opcode::PseudoVREDSUM_VS_M8_E8,
          8097 => Opcode::PseudoVREDSUM_VS_M8_E8_MASK,
          8098 => Opcode::PseudoVREDSUM_VS_MF2_E16,
          8099 => Opcode::PseudoVREDSUM_VS_MF2_E16_MASK,
          8100 => Opcode::PseudoVREDSUM_VS_MF2_E32,
          8101 => Opcode::PseudoVREDSUM_VS_MF2_E32_MASK,
          8102 => Opcode::PseudoVREDSUM_VS_MF2_E8,
          8103 => Opcode::PseudoVREDSUM_VS_MF2_E8_MASK,
          8104 => Opcode::PseudoVREDSUM_VS_MF4_E16,
          8105 => Opcode::PseudoVREDSUM_VS_MF4_E16_MASK,
          8106 => Opcode::PseudoVREDSUM_VS_MF4_E8,
          8107 => Opcode::PseudoVREDSUM_VS_MF4_E8_MASK,
          8108 => Opcode::PseudoVREDSUM_VS_MF8_E8,
          8109 => Opcode::PseudoVREDSUM_VS_MF8_E8_MASK,
          8110 => Opcode::PseudoVREDXOR_VS_M1_E16,
          8111 => Opcode::PseudoVREDXOR_VS_M1_E16_MASK,
          8112 => Opcode::PseudoVREDXOR_VS_M1_E32,
          8113 => Opcode::PseudoVREDXOR_VS_M1_E32_MASK,
          8114 => Opcode::PseudoVREDXOR_VS_M1_E64,
          8115 => Opcode::PseudoVREDXOR_VS_M1_E64_MASK,
          8116 => Opcode::PseudoVREDXOR_VS_M1_E8,
          8117 => Opcode::PseudoVREDXOR_VS_M1_E8_MASK,
          8118 => Opcode::PseudoVREDXOR_VS_M2_E16,
          8119 => Opcode::PseudoVREDXOR_VS_M2_E16_MASK,
          8120 => Opcode::PseudoVREDXOR_VS_M2_E32,
          8121 => Opcode::PseudoVREDXOR_VS_M2_E32_MASK,
          8122 => Opcode::PseudoVREDXOR_VS_M2_E64,
          8123 => Opcode::PseudoVREDXOR_VS_M2_E64_MASK,
          8124 => Opcode::PseudoVREDXOR_VS_M2_E8,
          8125 => Opcode::PseudoVREDXOR_VS_M2_E8_MASK,
          8126 => Opcode::PseudoVREDXOR_VS_M4_E16,
          8127 => Opcode::PseudoVREDXOR_VS_M4_E16_MASK,
          8128 => Opcode::PseudoVREDXOR_VS_M4_E32,
          8129 => Opcode::PseudoVREDXOR_VS_M4_E32_MASK,
          8130 => Opcode::PseudoVREDXOR_VS_M4_E64,
          8131 => Opcode::PseudoVREDXOR_VS_M4_E64_MASK,
          8132 => Opcode::PseudoVREDXOR_VS_M4_E8,
          8133 => Opcode::PseudoVREDXOR_VS_M4_E8_MASK,
          8134 => Opcode::PseudoVREDXOR_VS_M8_E16,
          8135 => Opcode::PseudoVREDXOR_VS_M8_E16_MASK,
          8136 => Opcode::PseudoVREDXOR_VS_M8_E32,
          8137 => Opcode::PseudoVREDXOR_VS_M8_E32_MASK,
          8138 => Opcode::PseudoVREDXOR_VS_M8_E64,
          8139 => Opcode::PseudoVREDXOR_VS_M8_E64_MASK,
          8140 => Opcode::PseudoVREDXOR_VS_M8_E8,
          8141 => Opcode::PseudoVREDXOR_VS_M8_E8_MASK,
          8142 => Opcode::PseudoVREDXOR_VS_MF2_E16,
          8143 => Opcode::PseudoVREDXOR_VS_MF2_E16_MASK,
          8144 => Opcode::PseudoVREDXOR_VS_MF2_E32,
          8145 => Opcode::PseudoVREDXOR_VS_MF2_E32_MASK,
          8146 => Opcode::PseudoVREDXOR_VS_MF2_E8,
          8147 => Opcode::PseudoVREDXOR_VS_MF2_E8_MASK,
          8148 => Opcode::PseudoVREDXOR_VS_MF4_E16,
          8149 => Opcode::PseudoVREDXOR_VS_MF4_E16_MASK,
          8150 => Opcode::PseudoVREDXOR_VS_MF4_E8,
          8151 => Opcode::PseudoVREDXOR_VS_MF4_E8_MASK,
          8152 => Opcode::PseudoVREDXOR_VS_MF8_E8,
          8153 => Opcode::PseudoVREDXOR_VS_MF8_E8_MASK,
          8154 => Opcode::PseudoVRELOAD2_M1,
          8155 => Opcode::PseudoVRELOAD2_M2,
          8156 => Opcode::PseudoVRELOAD2_M4,
          8157 => Opcode::PseudoVRELOAD2_MF2,
          8158 => Opcode::PseudoVRELOAD2_MF4,
          8159 => Opcode::PseudoVRELOAD2_MF8,
          8160 => Opcode::PseudoVRELOAD3_M1,
          8161 => Opcode::PseudoVRELOAD3_M2,
          8162 => Opcode::PseudoVRELOAD3_MF2,
          8163 => Opcode::PseudoVRELOAD3_MF4,
          8164 => Opcode::PseudoVRELOAD3_MF8,
          8165 => Opcode::PseudoVRELOAD4_M1,
          8166 => Opcode::PseudoVRELOAD4_M2,
          8167 => Opcode::PseudoVRELOAD4_MF2,
          8168 => Opcode::PseudoVRELOAD4_MF4,
          8169 => Opcode::PseudoVRELOAD4_MF8,
          8170 => Opcode::PseudoVRELOAD5_M1,
          8171 => Opcode::PseudoVRELOAD5_MF2,
          8172 => Opcode::PseudoVRELOAD5_MF4,
          8173 => Opcode::PseudoVRELOAD5_MF8,
          8174 => Opcode::PseudoVRELOAD6_M1,
          8175 => Opcode::PseudoVRELOAD6_MF2,
          8176 => Opcode::PseudoVRELOAD6_MF4,
          8177 => Opcode::PseudoVRELOAD6_MF8,
          8178 => Opcode::PseudoVRELOAD7_M1,
          8179 => Opcode::PseudoVRELOAD7_MF2,
          8180 => Opcode::PseudoVRELOAD7_MF4,
          8181 => Opcode::PseudoVRELOAD7_MF8,
          8182 => Opcode::PseudoVRELOAD8_M1,
          8183 => Opcode::PseudoVRELOAD8_MF2,
          8184 => Opcode::PseudoVRELOAD8_MF4,
          8185 => Opcode::PseudoVRELOAD8_MF8,
          8186 => Opcode::PseudoVREMU_VV_M1_E16,
          8187 => Opcode::PseudoVREMU_VV_M1_E16_MASK,
          8188 => Opcode::PseudoVREMU_VV_M1_E32,
          8189 => Opcode::PseudoVREMU_VV_M1_E32_MASK,
          8190 => Opcode::PseudoVREMU_VV_M1_E64,
          8191 => Opcode::PseudoVREMU_VV_M1_E64_MASK,
          8192 => Opcode::PseudoVREMU_VV_M1_E8,
          8193 => Opcode::PseudoVREMU_VV_M1_E8_MASK,
          8194 => Opcode::PseudoVREMU_VV_M2_E16,
          8195 => Opcode::PseudoVREMU_VV_M2_E16_MASK,
          8196 => Opcode::PseudoVREMU_VV_M2_E32,
          8197 => Opcode::PseudoVREMU_VV_M2_E32_MASK,
          8198 => Opcode::PseudoVREMU_VV_M2_E64,
          8199 => Opcode::PseudoVREMU_VV_M2_E64_MASK,
          8200 => Opcode::PseudoVREMU_VV_M2_E8,
          8201 => Opcode::PseudoVREMU_VV_M2_E8_MASK,
          8202 => Opcode::PseudoVREMU_VV_M4_E16,
          8203 => Opcode::PseudoVREMU_VV_M4_E16_MASK,
          8204 => Opcode::PseudoVREMU_VV_M4_E32,
          8205 => Opcode::PseudoVREMU_VV_M4_E32_MASK,
          8206 => Opcode::PseudoVREMU_VV_M4_E64,
          8207 => Opcode::PseudoVREMU_VV_M4_E64_MASK,
          8208 => Opcode::PseudoVREMU_VV_M4_E8,
          8209 => Opcode::PseudoVREMU_VV_M4_E8_MASK,
          8210 => Opcode::PseudoVREMU_VV_M8_E16,
          8211 => Opcode::PseudoVREMU_VV_M8_E16_MASK,
          8212 => Opcode::PseudoVREMU_VV_M8_E32,
          8213 => Opcode::PseudoVREMU_VV_M8_E32_MASK,
          8214 => Opcode::PseudoVREMU_VV_M8_E64,
          8215 => Opcode::PseudoVREMU_VV_M8_E64_MASK,
          8216 => Opcode::PseudoVREMU_VV_M8_E8,
          8217 => Opcode::PseudoVREMU_VV_M8_E8_MASK,
          8218 => Opcode::PseudoVREMU_VV_MF2_E16,
          8219 => Opcode::PseudoVREMU_VV_MF2_E16_MASK,
          8220 => Opcode::PseudoVREMU_VV_MF2_E32,
          8221 => Opcode::PseudoVREMU_VV_MF2_E32_MASK,
          8222 => Opcode::PseudoVREMU_VV_MF2_E8,
          8223 => Opcode::PseudoVREMU_VV_MF2_E8_MASK,
          8224 => Opcode::PseudoVREMU_VV_MF4_E16,
          8225 => Opcode::PseudoVREMU_VV_MF4_E16_MASK,
          8226 => Opcode::PseudoVREMU_VV_MF4_E8,
          8227 => Opcode::PseudoVREMU_VV_MF4_E8_MASK,
          8228 => Opcode::PseudoVREMU_VV_MF8_E8,
          8229 => Opcode::PseudoVREMU_VV_MF8_E8_MASK,
          8230 => Opcode::PseudoVREMU_VX_M1_E16,
          8231 => Opcode::PseudoVREMU_VX_M1_E16_MASK,
          8232 => Opcode::PseudoVREMU_VX_M1_E32,
          8233 => Opcode::PseudoVREMU_VX_M1_E32_MASK,
          8234 => Opcode::PseudoVREMU_VX_M1_E64,
          8235 => Opcode::PseudoVREMU_VX_M1_E64_MASK,
          8236 => Opcode::PseudoVREMU_VX_M1_E8,
          8237 => Opcode::PseudoVREMU_VX_M1_E8_MASK,
          8238 => Opcode::PseudoVREMU_VX_M2_E16,
          8239 => Opcode::PseudoVREMU_VX_M2_E16_MASK,
          8240 => Opcode::PseudoVREMU_VX_M2_E32,
          8241 => Opcode::PseudoVREMU_VX_M2_E32_MASK,
          8242 => Opcode::PseudoVREMU_VX_M2_E64,
          8243 => Opcode::PseudoVREMU_VX_M2_E64_MASK,
          8244 => Opcode::PseudoVREMU_VX_M2_E8,
          8245 => Opcode::PseudoVREMU_VX_M2_E8_MASK,
          8246 => Opcode::PseudoVREMU_VX_M4_E16,
          8247 => Opcode::PseudoVREMU_VX_M4_E16_MASK,
          8248 => Opcode::PseudoVREMU_VX_M4_E32,
          8249 => Opcode::PseudoVREMU_VX_M4_E32_MASK,
          8250 => Opcode::PseudoVREMU_VX_M4_E64,
          8251 => Opcode::PseudoVREMU_VX_M4_E64_MASK,
          8252 => Opcode::PseudoVREMU_VX_M4_E8,
          8253 => Opcode::PseudoVREMU_VX_M4_E8_MASK,
          8254 => Opcode::PseudoVREMU_VX_M8_E16,
          8255 => Opcode::PseudoVREMU_VX_M8_E16_MASK,
          8256 => Opcode::PseudoVREMU_VX_M8_E32,
          8257 => Opcode::PseudoVREMU_VX_M8_E32_MASK,
          8258 => Opcode::PseudoVREMU_VX_M8_E64,
          8259 => Opcode::PseudoVREMU_VX_M8_E64_MASK,
          8260 => Opcode::PseudoVREMU_VX_M8_E8,
          8261 => Opcode::PseudoVREMU_VX_M8_E8_MASK,
          8262 => Opcode::PseudoVREMU_VX_MF2_E16,
          8263 => Opcode::PseudoVREMU_VX_MF2_E16_MASK,
          8264 => Opcode::PseudoVREMU_VX_MF2_E32,
          8265 => Opcode::PseudoVREMU_VX_MF2_E32_MASK,
          8266 => Opcode::PseudoVREMU_VX_MF2_E8,
          8267 => Opcode::PseudoVREMU_VX_MF2_E8_MASK,
          8268 => Opcode::PseudoVREMU_VX_MF4_E16,
          8269 => Opcode::PseudoVREMU_VX_MF4_E16_MASK,
          8270 => Opcode::PseudoVREMU_VX_MF4_E8,
          8271 => Opcode::PseudoVREMU_VX_MF4_E8_MASK,
          8272 => Opcode::PseudoVREMU_VX_MF8_E8,
          8273 => Opcode::PseudoVREMU_VX_MF8_E8_MASK,
          8274 => Opcode::PseudoVREM_VV_M1_E16,
          8275 => Opcode::PseudoVREM_VV_M1_E16_MASK,
          8276 => Opcode::PseudoVREM_VV_M1_E32,
          8277 => Opcode::PseudoVREM_VV_M1_E32_MASK,
          8278 => Opcode::PseudoVREM_VV_M1_E64,
          8279 => Opcode::PseudoVREM_VV_M1_E64_MASK,
          8280 => Opcode::PseudoVREM_VV_M1_E8,
          8281 => Opcode::PseudoVREM_VV_M1_E8_MASK,
          8282 => Opcode::PseudoVREM_VV_M2_E16,
          8283 => Opcode::PseudoVREM_VV_M2_E16_MASK,
          8284 => Opcode::PseudoVREM_VV_M2_E32,
          8285 => Opcode::PseudoVREM_VV_M2_E32_MASK,
          8286 => Opcode::PseudoVREM_VV_M2_E64,
          8287 => Opcode::PseudoVREM_VV_M2_E64_MASK,
          8288 => Opcode::PseudoVREM_VV_M2_E8,
          8289 => Opcode::PseudoVREM_VV_M2_E8_MASK,
          8290 => Opcode::PseudoVREM_VV_M4_E16,
          8291 => Opcode::PseudoVREM_VV_M4_E16_MASK,
          8292 => Opcode::PseudoVREM_VV_M4_E32,
          8293 => Opcode::PseudoVREM_VV_M4_E32_MASK,
          8294 => Opcode::PseudoVREM_VV_M4_E64,
          8295 => Opcode::PseudoVREM_VV_M4_E64_MASK,
          8296 => Opcode::PseudoVREM_VV_M4_E8,
          8297 => Opcode::PseudoVREM_VV_M4_E8_MASK,
          8298 => Opcode::PseudoVREM_VV_M8_E16,
          8299 => Opcode::PseudoVREM_VV_M8_E16_MASK,
          8300 => Opcode::PseudoVREM_VV_M8_E32,
          8301 => Opcode::PseudoVREM_VV_M8_E32_MASK,
          8302 => Opcode::PseudoVREM_VV_M8_E64,
          8303 => Opcode::PseudoVREM_VV_M8_E64_MASK,
          8304 => Opcode::PseudoVREM_VV_M8_E8,
          8305 => Opcode::PseudoVREM_VV_M8_E8_MASK,
          8306 => Opcode::PseudoVREM_VV_MF2_E16,
          8307 => Opcode::PseudoVREM_VV_MF2_E16_MASK,
          8308 => Opcode::PseudoVREM_VV_MF2_E32,
          8309 => Opcode::PseudoVREM_VV_MF2_E32_MASK,
          8310 => Opcode::PseudoVREM_VV_MF2_E8,
          8311 => Opcode::PseudoVREM_VV_MF2_E8_MASK,
          8312 => Opcode::PseudoVREM_VV_MF4_E16,
          8313 => Opcode::PseudoVREM_VV_MF4_E16_MASK,
          8314 => Opcode::PseudoVREM_VV_MF4_E8,
          8315 => Opcode::PseudoVREM_VV_MF4_E8_MASK,
          8316 => Opcode::PseudoVREM_VV_MF8_E8,
          8317 => Opcode::PseudoVREM_VV_MF8_E8_MASK,
          8318 => Opcode::PseudoVREM_VX_M1_E16,
          8319 => Opcode::PseudoVREM_VX_M1_E16_MASK,
          8320 => Opcode::PseudoVREM_VX_M1_E32,
          8321 => Opcode::PseudoVREM_VX_M1_E32_MASK,
          8322 => Opcode::PseudoVREM_VX_M1_E64,
          8323 => Opcode::PseudoVREM_VX_M1_E64_MASK,
          8324 => Opcode::PseudoVREM_VX_M1_E8,
          8325 => Opcode::PseudoVREM_VX_M1_E8_MASK,
          8326 => Opcode::PseudoVREM_VX_M2_E16,
          8327 => Opcode::PseudoVREM_VX_M2_E16_MASK,
          8328 => Opcode::PseudoVREM_VX_M2_E32,
          8329 => Opcode::PseudoVREM_VX_M2_E32_MASK,
          8330 => Opcode::PseudoVREM_VX_M2_E64,
          8331 => Opcode::PseudoVREM_VX_M2_E64_MASK,
          8332 => Opcode::PseudoVREM_VX_M2_E8,
          8333 => Opcode::PseudoVREM_VX_M2_E8_MASK,
          8334 => Opcode::PseudoVREM_VX_M4_E16,
          8335 => Opcode::PseudoVREM_VX_M4_E16_MASK,
          8336 => Opcode::PseudoVREM_VX_M4_E32,
          8337 => Opcode::PseudoVREM_VX_M4_E32_MASK,
          8338 => Opcode::PseudoVREM_VX_M4_E64,
          8339 => Opcode::PseudoVREM_VX_M4_E64_MASK,
          8340 => Opcode::PseudoVREM_VX_M4_E8,
          8341 => Opcode::PseudoVREM_VX_M4_E8_MASK,
          8342 => Opcode::PseudoVREM_VX_M8_E16,
          8343 => Opcode::PseudoVREM_VX_M8_E16_MASK,
          8344 => Opcode::PseudoVREM_VX_M8_E32,
          8345 => Opcode::PseudoVREM_VX_M8_E32_MASK,
          8346 => Opcode::PseudoVREM_VX_M8_E64,
          8347 => Opcode::PseudoVREM_VX_M8_E64_MASK,
          8348 => Opcode::PseudoVREM_VX_M8_E8,
          8349 => Opcode::PseudoVREM_VX_M8_E8_MASK,
          8350 => Opcode::PseudoVREM_VX_MF2_E16,
          8351 => Opcode::PseudoVREM_VX_MF2_E16_MASK,
          8352 => Opcode::PseudoVREM_VX_MF2_E32,
          8353 => Opcode::PseudoVREM_VX_MF2_E32_MASK,
          8354 => Opcode::PseudoVREM_VX_MF2_E8,
          8355 => Opcode::PseudoVREM_VX_MF2_E8_MASK,
          8356 => Opcode::PseudoVREM_VX_MF4_E16,
          8357 => Opcode::PseudoVREM_VX_MF4_E16_MASK,
          8358 => Opcode::PseudoVREM_VX_MF4_E8,
          8359 => Opcode::PseudoVREM_VX_MF4_E8_MASK,
          8360 => Opcode::PseudoVREM_VX_MF8_E8,
          8361 => Opcode::PseudoVREM_VX_MF8_E8_MASK,
          8362 => Opcode::PseudoVREV8_V_M1,
          8363 => Opcode::PseudoVREV8_V_M1_MASK,
          8364 => Opcode::PseudoVREV8_V_M2,
          8365 => Opcode::PseudoVREV8_V_M2_MASK,
          8366 => Opcode::PseudoVREV8_V_M4,
          8367 => Opcode::PseudoVREV8_V_M4_MASK,
          8368 => Opcode::PseudoVREV8_V_M8,
          8369 => Opcode::PseudoVREV8_V_M8_MASK,
          8370 => Opcode::PseudoVREV8_V_MF2,
          8371 => Opcode::PseudoVREV8_V_MF2_MASK,
          8372 => Opcode::PseudoVREV8_V_MF4,
          8373 => Opcode::PseudoVREV8_V_MF4_MASK,
          8374 => Opcode::PseudoVREV8_V_MF8,
          8375 => Opcode::PseudoVREV8_V_MF8_MASK,
          8376 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_M1,
          8377 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_M1_MASK,
          8378 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_M2,
          8379 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_M2_MASK,
          8380 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_MF2,
          8381 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_MF2_MASK,
          8382 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_MF4,
          8383 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_MF4_MASK,
          8384 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_M1,
          8385 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_M1_MASK,
          8386 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_M2,
          8387 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_M2_MASK,
          8388 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_MF2,
          8389 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_MF2_MASK,
          8390 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_MF4,
          8391 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_MF4_MASK,
          8392 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_M1,
          8393 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_M1_MASK,
          8394 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_M2,
          8395 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_M2_MASK,
          8396 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_MF2,
          8397 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_MF2_MASK,
          8398 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_MF4,
          8399 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_MF4_MASK,
          8400 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_M1,
          8401 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_M1_MASK,
          8402 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_M2,
          8403 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_M2_MASK,
          8404 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_MF2,
          8405 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_MF2_MASK,
          8406 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_MF4,
          8407 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_MF4_MASK,
          8408 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M1,
          8409 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M1_MASK,
          8410 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M2,
          8411 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M2_MASK,
          8412 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M4,
          8413 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M4_MASK,
          8414 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_MF2,
          8415 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_MF2_MASK,
          8416 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M1,
          8417 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M1_MASK,
          8418 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M2,
          8419 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M2_MASK,
          8420 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M4,
          8421 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M4_MASK,
          8422 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_MF2,
          8423 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_MF2_MASK,
          8424 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M1,
          8425 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M1_MASK,
          8426 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M2,
          8427 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M2_MASK,
          8428 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M4,
          8429 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M4_MASK,
          8430 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_MF2,
          8431 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_MF2_MASK,
          8432 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M1,
          8433 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M1_MASK,
          8434 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M2,
          8435 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M2_MASK,
          8436 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M4,
          8437 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M4_MASK,
          8438 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_MF2,
          8439 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_MF2_MASK,
          8440 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M1,
          8441 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M1_MASK,
          8442 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M2,
          8443 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M2_MASK,
          8444 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M4,
          8445 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M4_MASK,
          8446 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M8,
          8447 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M8_MASK,
          8448 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M1,
          8449 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M1_MASK,
          8450 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M2,
          8451 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M2_MASK,
          8452 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M4,
          8453 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M4_MASK,
          8454 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M8,
          8455 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M8_MASK,
          8456 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M1,
          8457 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M1_MASK,
          8458 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M2,
          8459 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M2_MASK,
          8460 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M4,
          8461 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M4_MASK,
          8462 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M8,
          8463 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M8_MASK,
          8464 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M1,
          8465 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M1_MASK,
          8466 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M2,
          8467 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M2_MASK,
          8468 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M4,
          8469 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M4_MASK,
          8470 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M8,
          8471 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M8_MASK,
          8472 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M2,
          8473 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M2_MASK,
          8474 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M4,
          8475 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M4_MASK,
          8476 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M8,
          8477 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M8_MASK,
          8478 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M2,
          8479 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M2_MASK,
          8480 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M4,
          8481 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M4_MASK,
          8482 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M8,
          8483 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M8_MASK,
          8484 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M2,
          8485 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M2_MASK,
          8486 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M4,
          8487 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M4_MASK,
          8488 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M8,
          8489 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M8_MASK,
          8490 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M2,
          8491 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M2_MASK,
          8492 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M4,
          8493 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M4_MASK,
          8494 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M8,
          8495 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M8_MASK,
          8496 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_M1,
          8497 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_M1_MASK,
          8498 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF2,
          8499 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF2_MASK,
          8500 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF4,
          8501 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF4_MASK,
          8502 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF8,
          8503 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF8_MASK,
          8504 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_M1,
          8505 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_M1_MASK,
          8506 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF2,
          8507 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF2_MASK,
          8508 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF4,
          8509 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF4_MASK,
          8510 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF8,
          8511 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF8_MASK,
          8512 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_M1,
          8513 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_M1_MASK,
          8514 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF2,
          8515 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF2_MASK,
          8516 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF4,
          8517 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF4_MASK,
          8518 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF8,
          8519 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF8_MASK,
          8520 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF2,
          8521 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF2_MASK,
          8522 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF4,
          8523 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF4_MASK,
          8524 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF8,
          8525 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF8_MASK,
          8526 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF2,
          8527 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF2_MASK,
          8528 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF4,
          8529 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF4_MASK,
          8530 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF8,
          8531 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF8_MASK,
          8532 => Opcode::PseudoVRGATHEREI16_VV_MF8_E8_MF4,
          8533 => Opcode::PseudoVRGATHEREI16_VV_MF8_E8_MF4_MASK,
          8534 => Opcode::PseudoVRGATHEREI16_VV_MF8_E8_MF8,
          8535 => Opcode::PseudoVRGATHEREI16_VV_MF8_E8_MF8_MASK,
          8536 => Opcode::PseudoVRGATHER_VI_M1,
          8537 => Opcode::PseudoVRGATHER_VI_M1_MASK,
          8538 => Opcode::PseudoVRGATHER_VI_M2,
          8539 => Opcode::PseudoVRGATHER_VI_M2_MASK,
          8540 => Opcode::PseudoVRGATHER_VI_M4,
          8541 => Opcode::PseudoVRGATHER_VI_M4_MASK,
          8542 => Opcode::PseudoVRGATHER_VI_M8,
          8543 => Opcode::PseudoVRGATHER_VI_M8_MASK,
          8544 => Opcode::PseudoVRGATHER_VI_MF2,
          8545 => Opcode::PseudoVRGATHER_VI_MF2_MASK,
          8546 => Opcode::PseudoVRGATHER_VI_MF4,
          8547 => Opcode::PseudoVRGATHER_VI_MF4_MASK,
          8548 => Opcode::PseudoVRGATHER_VI_MF8,
          8549 => Opcode::PseudoVRGATHER_VI_MF8_MASK,
          8550 => Opcode::PseudoVRGATHER_VV_M1_E16,
          8551 => Opcode::PseudoVRGATHER_VV_M1_E16_MASK,
          8552 => Opcode::PseudoVRGATHER_VV_M1_E32,
          8553 => Opcode::PseudoVRGATHER_VV_M1_E32_MASK,
          8554 => Opcode::PseudoVRGATHER_VV_M1_E64,
          8555 => Opcode::PseudoVRGATHER_VV_M1_E64_MASK,
          8556 => Opcode::PseudoVRGATHER_VV_M1_E8,
          8557 => Opcode::PseudoVRGATHER_VV_M1_E8_MASK,
          8558 => Opcode::PseudoVRGATHER_VV_M2_E16,
          8559 => Opcode::PseudoVRGATHER_VV_M2_E16_MASK,
          8560 => Opcode::PseudoVRGATHER_VV_M2_E32,
          8561 => Opcode::PseudoVRGATHER_VV_M2_E32_MASK,
          8562 => Opcode::PseudoVRGATHER_VV_M2_E64,
          8563 => Opcode::PseudoVRGATHER_VV_M2_E64_MASK,
          8564 => Opcode::PseudoVRGATHER_VV_M2_E8,
          8565 => Opcode::PseudoVRGATHER_VV_M2_E8_MASK,
          8566 => Opcode::PseudoVRGATHER_VV_M4_E16,
          8567 => Opcode::PseudoVRGATHER_VV_M4_E16_MASK,
          8568 => Opcode::PseudoVRGATHER_VV_M4_E32,
          8569 => Opcode::PseudoVRGATHER_VV_M4_E32_MASK,
          8570 => Opcode::PseudoVRGATHER_VV_M4_E64,
          8571 => Opcode::PseudoVRGATHER_VV_M4_E64_MASK,
          8572 => Opcode::PseudoVRGATHER_VV_M4_E8,
          8573 => Opcode::PseudoVRGATHER_VV_M4_E8_MASK,
          8574 => Opcode::PseudoVRGATHER_VV_M8_E16,
          8575 => Opcode::PseudoVRGATHER_VV_M8_E16_MASK,
          8576 => Opcode::PseudoVRGATHER_VV_M8_E32,
          8577 => Opcode::PseudoVRGATHER_VV_M8_E32_MASK,
          8578 => Opcode::PseudoVRGATHER_VV_M8_E64,
          8579 => Opcode::PseudoVRGATHER_VV_M8_E64_MASK,
          8580 => Opcode::PseudoVRGATHER_VV_M8_E8,
          8581 => Opcode::PseudoVRGATHER_VV_M8_E8_MASK,
          8582 => Opcode::PseudoVRGATHER_VV_MF2_E16,
          8583 => Opcode::PseudoVRGATHER_VV_MF2_E16_MASK,
          8584 => Opcode::PseudoVRGATHER_VV_MF2_E32,
          8585 => Opcode::PseudoVRGATHER_VV_MF2_E32_MASK,
          8586 => Opcode::PseudoVRGATHER_VV_MF2_E8,
          8587 => Opcode::PseudoVRGATHER_VV_MF2_E8_MASK,
          8588 => Opcode::PseudoVRGATHER_VV_MF4_E16,
          8589 => Opcode::PseudoVRGATHER_VV_MF4_E16_MASK,
          8590 => Opcode::PseudoVRGATHER_VV_MF4_E8,
          8591 => Opcode::PseudoVRGATHER_VV_MF4_E8_MASK,
          8592 => Opcode::PseudoVRGATHER_VV_MF8_E8,
          8593 => Opcode::PseudoVRGATHER_VV_MF8_E8_MASK,
          8594 => Opcode::PseudoVRGATHER_VX_M1,
          8595 => Opcode::PseudoVRGATHER_VX_M1_MASK,
          8596 => Opcode::PseudoVRGATHER_VX_M2,
          8597 => Opcode::PseudoVRGATHER_VX_M2_MASK,
          8598 => Opcode::PseudoVRGATHER_VX_M4,
          8599 => Opcode::PseudoVRGATHER_VX_M4_MASK,
          8600 => Opcode::PseudoVRGATHER_VX_M8,
          8601 => Opcode::PseudoVRGATHER_VX_M8_MASK,
          8602 => Opcode::PseudoVRGATHER_VX_MF2,
          8603 => Opcode::PseudoVRGATHER_VX_MF2_MASK,
          8604 => Opcode::PseudoVRGATHER_VX_MF4,
          8605 => Opcode::PseudoVRGATHER_VX_MF4_MASK,
          8606 => Opcode::PseudoVRGATHER_VX_MF8,
          8607 => Opcode::PseudoVRGATHER_VX_MF8_MASK,
          8608 => Opcode::PseudoVROL_VV_M1,
          8609 => Opcode::PseudoVROL_VV_M1_MASK,
          8610 => Opcode::PseudoVROL_VV_M2,
          8611 => Opcode::PseudoVROL_VV_M2_MASK,
          8612 => Opcode::PseudoVROL_VV_M4,
          8613 => Opcode::PseudoVROL_VV_M4_MASK,
          8614 => Opcode::PseudoVROL_VV_M8,
          8615 => Opcode::PseudoVROL_VV_M8_MASK,
          8616 => Opcode::PseudoVROL_VV_MF2,
          8617 => Opcode::PseudoVROL_VV_MF2_MASK,
          8618 => Opcode::PseudoVROL_VV_MF4,
          8619 => Opcode::PseudoVROL_VV_MF4_MASK,
          8620 => Opcode::PseudoVROL_VV_MF8,
          8621 => Opcode::PseudoVROL_VV_MF8_MASK,
          8622 => Opcode::PseudoVROL_VX_M1,
          8623 => Opcode::PseudoVROL_VX_M1_MASK,
          8624 => Opcode::PseudoVROL_VX_M2,
          8625 => Opcode::PseudoVROL_VX_M2_MASK,
          8626 => Opcode::PseudoVROL_VX_M4,
          8627 => Opcode::PseudoVROL_VX_M4_MASK,
          8628 => Opcode::PseudoVROL_VX_M8,
          8629 => Opcode::PseudoVROL_VX_M8_MASK,
          8630 => Opcode::PseudoVROL_VX_MF2,
          8631 => Opcode::PseudoVROL_VX_MF2_MASK,
          8632 => Opcode::PseudoVROL_VX_MF4,
          8633 => Opcode::PseudoVROL_VX_MF4_MASK,
          8634 => Opcode::PseudoVROL_VX_MF8,
          8635 => Opcode::PseudoVROL_VX_MF8_MASK,
          8636 => Opcode::PseudoVROR_VI_M1,
          8637 => Opcode::PseudoVROR_VI_M1_MASK,
          8638 => Opcode::PseudoVROR_VI_M2,
          8639 => Opcode::PseudoVROR_VI_M2_MASK,
          8640 => Opcode::PseudoVROR_VI_M4,
          8641 => Opcode::PseudoVROR_VI_M4_MASK,
          8642 => Opcode::PseudoVROR_VI_M8,
          8643 => Opcode::PseudoVROR_VI_M8_MASK,
          8644 => Opcode::PseudoVROR_VI_MF2,
          8645 => Opcode::PseudoVROR_VI_MF2_MASK,
          8646 => Opcode::PseudoVROR_VI_MF4,
          8647 => Opcode::PseudoVROR_VI_MF4_MASK,
          8648 => Opcode::PseudoVROR_VI_MF8,
          8649 => Opcode::PseudoVROR_VI_MF8_MASK,
          8650 => Opcode::PseudoVROR_VV_M1,
          8651 => Opcode::PseudoVROR_VV_M1_MASK,
          8652 => Opcode::PseudoVROR_VV_M2,
          8653 => Opcode::PseudoVROR_VV_M2_MASK,
          8654 => Opcode::PseudoVROR_VV_M4,
          8655 => Opcode::PseudoVROR_VV_M4_MASK,
          8656 => Opcode::PseudoVROR_VV_M8,
          8657 => Opcode::PseudoVROR_VV_M8_MASK,
          8658 => Opcode::PseudoVROR_VV_MF2,
          8659 => Opcode::PseudoVROR_VV_MF2_MASK,
          8660 => Opcode::PseudoVROR_VV_MF4,
          8661 => Opcode::PseudoVROR_VV_MF4_MASK,
          8662 => Opcode::PseudoVROR_VV_MF8,
          8663 => Opcode::PseudoVROR_VV_MF8_MASK,
          8664 => Opcode::PseudoVROR_VX_M1,
          8665 => Opcode::PseudoVROR_VX_M1_MASK,
          8666 => Opcode::PseudoVROR_VX_M2,
          8667 => Opcode::PseudoVROR_VX_M2_MASK,
          8668 => Opcode::PseudoVROR_VX_M4,
          8669 => Opcode::PseudoVROR_VX_M4_MASK,
          8670 => Opcode::PseudoVROR_VX_M8,
          8671 => Opcode::PseudoVROR_VX_M8_MASK,
          8672 => Opcode::PseudoVROR_VX_MF2,
          8673 => Opcode::PseudoVROR_VX_MF2_MASK,
          8674 => Opcode::PseudoVROR_VX_MF4,
          8675 => Opcode::PseudoVROR_VX_MF4_MASK,
          8676 => Opcode::PseudoVROR_VX_MF8,
          8677 => Opcode::PseudoVROR_VX_MF8_MASK,
          8678 => Opcode::PseudoVRSUB_VI_M1,
          8679 => Opcode::PseudoVRSUB_VI_M1_MASK,
          8680 => Opcode::PseudoVRSUB_VI_M2,
          8681 => Opcode::PseudoVRSUB_VI_M2_MASK,
          8682 => Opcode::PseudoVRSUB_VI_M4,
          8683 => Opcode::PseudoVRSUB_VI_M4_MASK,
          8684 => Opcode::PseudoVRSUB_VI_M8,
          8685 => Opcode::PseudoVRSUB_VI_M8_MASK,
          8686 => Opcode::PseudoVRSUB_VI_MF2,
          8687 => Opcode::PseudoVRSUB_VI_MF2_MASK,
          8688 => Opcode::PseudoVRSUB_VI_MF4,
          8689 => Opcode::PseudoVRSUB_VI_MF4_MASK,
          8690 => Opcode::PseudoVRSUB_VI_MF8,
          8691 => Opcode::PseudoVRSUB_VI_MF8_MASK,
          8692 => Opcode::PseudoVRSUB_VX_M1,
          8693 => Opcode::PseudoVRSUB_VX_M1_MASK,
          8694 => Opcode::PseudoVRSUB_VX_M2,
          8695 => Opcode::PseudoVRSUB_VX_M2_MASK,
          8696 => Opcode::PseudoVRSUB_VX_M4,
          8697 => Opcode::PseudoVRSUB_VX_M4_MASK,
          8698 => Opcode::PseudoVRSUB_VX_M8,
          8699 => Opcode::PseudoVRSUB_VX_M8_MASK,
          8700 => Opcode::PseudoVRSUB_VX_MF2,
          8701 => Opcode::PseudoVRSUB_VX_MF2_MASK,
          8702 => Opcode::PseudoVRSUB_VX_MF4,
          8703 => Opcode::PseudoVRSUB_VX_MF4_MASK,
          8704 => Opcode::PseudoVRSUB_VX_MF8,
          8705 => Opcode::PseudoVRSUB_VX_MF8_MASK,
          8706 => Opcode::PseudoVSADDU_VI_M1,
          8707 => Opcode::PseudoVSADDU_VI_M1_MASK,
          8708 => Opcode::PseudoVSADDU_VI_M2,
          8709 => Opcode::PseudoVSADDU_VI_M2_MASK,
          8710 => Opcode::PseudoVSADDU_VI_M4,
          8711 => Opcode::PseudoVSADDU_VI_M4_MASK,
          8712 => Opcode::PseudoVSADDU_VI_M8,
          8713 => Opcode::PseudoVSADDU_VI_M8_MASK,
          8714 => Opcode::PseudoVSADDU_VI_MF2,
          8715 => Opcode::PseudoVSADDU_VI_MF2_MASK,
          8716 => Opcode::PseudoVSADDU_VI_MF4,
          8717 => Opcode::PseudoVSADDU_VI_MF4_MASK,
          8718 => Opcode::PseudoVSADDU_VI_MF8,
          8719 => Opcode::PseudoVSADDU_VI_MF8_MASK,
          8720 => Opcode::PseudoVSADDU_VV_M1,
          8721 => Opcode::PseudoVSADDU_VV_M1_MASK,
          8722 => Opcode::PseudoVSADDU_VV_M2,
          8723 => Opcode::PseudoVSADDU_VV_M2_MASK,
          8724 => Opcode::PseudoVSADDU_VV_M4,
          8725 => Opcode::PseudoVSADDU_VV_M4_MASK,
          8726 => Opcode::PseudoVSADDU_VV_M8,
          8727 => Opcode::PseudoVSADDU_VV_M8_MASK,
          8728 => Opcode::PseudoVSADDU_VV_MF2,
          8729 => Opcode::PseudoVSADDU_VV_MF2_MASK,
          8730 => Opcode::PseudoVSADDU_VV_MF4,
          8731 => Opcode::PseudoVSADDU_VV_MF4_MASK,
          8732 => Opcode::PseudoVSADDU_VV_MF8,
          8733 => Opcode::PseudoVSADDU_VV_MF8_MASK,
          8734 => Opcode::PseudoVSADDU_VX_M1,
          8735 => Opcode::PseudoVSADDU_VX_M1_MASK,
          8736 => Opcode::PseudoVSADDU_VX_M2,
          8737 => Opcode::PseudoVSADDU_VX_M2_MASK,
          8738 => Opcode::PseudoVSADDU_VX_M4,
          8739 => Opcode::PseudoVSADDU_VX_M4_MASK,
          8740 => Opcode::PseudoVSADDU_VX_M8,
          8741 => Opcode::PseudoVSADDU_VX_M8_MASK,
          8742 => Opcode::PseudoVSADDU_VX_MF2,
          8743 => Opcode::PseudoVSADDU_VX_MF2_MASK,
          8744 => Opcode::PseudoVSADDU_VX_MF4,
          8745 => Opcode::PseudoVSADDU_VX_MF4_MASK,
          8746 => Opcode::PseudoVSADDU_VX_MF8,
          8747 => Opcode::PseudoVSADDU_VX_MF8_MASK,
          8748 => Opcode::PseudoVSADD_VI_M1,
          8749 => Opcode::PseudoVSADD_VI_M1_MASK,
          8750 => Opcode::PseudoVSADD_VI_M2,
          8751 => Opcode::PseudoVSADD_VI_M2_MASK,
          8752 => Opcode::PseudoVSADD_VI_M4,
          8753 => Opcode::PseudoVSADD_VI_M4_MASK,
          8754 => Opcode::PseudoVSADD_VI_M8,
          8755 => Opcode::PseudoVSADD_VI_M8_MASK,
          8756 => Opcode::PseudoVSADD_VI_MF2,
          8757 => Opcode::PseudoVSADD_VI_MF2_MASK,
          8758 => Opcode::PseudoVSADD_VI_MF4,
          8759 => Opcode::PseudoVSADD_VI_MF4_MASK,
          8760 => Opcode::PseudoVSADD_VI_MF8,
          8761 => Opcode::PseudoVSADD_VI_MF8_MASK,
          8762 => Opcode::PseudoVSADD_VV_M1,
          8763 => Opcode::PseudoVSADD_VV_M1_MASK,
          8764 => Opcode::PseudoVSADD_VV_M2,
          8765 => Opcode::PseudoVSADD_VV_M2_MASK,
          8766 => Opcode::PseudoVSADD_VV_M4,
          8767 => Opcode::PseudoVSADD_VV_M4_MASK,
          8768 => Opcode::PseudoVSADD_VV_M8,
          8769 => Opcode::PseudoVSADD_VV_M8_MASK,
          8770 => Opcode::PseudoVSADD_VV_MF2,
          8771 => Opcode::PseudoVSADD_VV_MF2_MASK,
          8772 => Opcode::PseudoVSADD_VV_MF4,
          8773 => Opcode::PseudoVSADD_VV_MF4_MASK,
          8774 => Opcode::PseudoVSADD_VV_MF8,
          8775 => Opcode::PseudoVSADD_VV_MF8_MASK,
          8776 => Opcode::PseudoVSADD_VX_M1,
          8777 => Opcode::PseudoVSADD_VX_M1_MASK,
          8778 => Opcode::PseudoVSADD_VX_M2,
          8779 => Opcode::PseudoVSADD_VX_M2_MASK,
          8780 => Opcode::PseudoVSADD_VX_M4,
          8781 => Opcode::PseudoVSADD_VX_M4_MASK,
          8782 => Opcode::PseudoVSADD_VX_M8,
          8783 => Opcode::PseudoVSADD_VX_M8_MASK,
          8784 => Opcode::PseudoVSADD_VX_MF2,
          8785 => Opcode::PseudoVSADD_VX_MF2_MASK,
          8786 => Opcode::PseudoVSADD_VX_MF4,
          8787 => Opcode::PseudoVSADD_VX_MF4_MASK,
          8788 => Opcode::PseudoVSADD_VX_MF8,
          8789 => Opcode::PseudoVSADD_VX_MF8_MASK,
          8790 => Opcode::PseudoVSBC_VVM_M1,
          8791 => Opcode::PseudoVSBC_VVM_M2,
          8792 => Opcode::PseudoVSBC_VVM_M4,
          8793 => Opcode::PseudoVSBC_VVM_M8,
          8794 => Opcode::PseudoVSBC_VVM_MF2,
          8795 => Opcode::PseudoVSBC_VVM_MF4,
          8796 => Opcode::PseudoVSBC_VVM_MF8,
          8797 => Opcode::PseudoVSBC_VXM_M1,
          8798 => Opcode::PseudoVSBC_VXM_M2,
          8799 => Opcode::PseudoVSBC_VXM_M4,
          8800 => Opcode::PseudoVSBC_VXM_M8,
          8801 => Opcode::PseudoVSBC_VXM_MF2,
          8802 => Opcode::PseudoVSBC_VXM_MF4,
          8803 => Opcode::PseudoVSBC_VXM_MF8,
          8804 => Opcode::PseudoVSE16_V_M1,
          8805 => Opcode::PseudoVSE16_V_M1_MASK,
          8806 => Opcode::PseudoVSE16_V_M2,
          8807 => Opcode::PseudoVSE16_V_M2_MASK,
          8808 => Opcode::PseudoVSE16_V_M4,
          8809 => Opcode::PseudoVSE16_V_M4_MASK,
          8810 => Opcode::PseudoVSE16_V_M8,
          8811 => Opcode::PseudoVSE16_V_M8_MASK,
          8812 => Opcode::PseudoVSE16_V_MF2,
          8813 => Opcode::PseudoVSE16_V_MF2_MASK,
          8814 => Opcode::PseudoVSE16_V_MF4,
          8815 => Opcode::PseudoVSE16_V_MF4_MASK,
          8816 => Opcode::PseudoVSE32_V_M1,
          8817 => Opcode::PseudoVSE32_V_M1_MASK,
          8818 => Opcode::PseudoVSE32_V_M2,
          8819 => Opcode::PseudoVSE32_V_M2_MASK,
          8820 => Opcode::PseudoVSE32_V_M4,
          8821 => Opcode::PseudoVSE32_V_M4_MASK,
          8822 => Opcode::PseudoVSE32_V_M8,
          8823 => Opcode::PseudoVSE32_V_M8_MASK,
          8824 => Opcode::PseudoVSE32_V_MF2,
          8825 => Opcode::PseudoVSE32_V_MF2_MASK,
          8826 => Opcode::PseudoVSE64_V_M1,
          8827 => Opcode::PseudoVSE64_V_M1_MASK,
          8828 => Opcode::PseudoVSE64_V_M2,
          8829 => Opcode::PseudoVSE64_V_M2_MASK,
          8830 => Opcode::PseudoVSE64_V_M4,
          8831 => Opcode::PseudoVSE64_V_M4_MASK,
          8832 => Opcode::PseudoVSE64_V_M8,
          8833 => Opcode::PseudoVSE64_V_M8_MASK,
          8834 => Opcode::PseudoVSE8_V_M1,
          8835 => Opcode::PseudoVSE8_V_M1_MASK,
          8836 => Opcode::PseudoVSE8_V_M2,
          8837 => Opcode::PseudoVSE8_V_M2_MASK,
          8838 => Opcode::PseudoVSE8_V_M4,
          8839 => Opcode::PseudoVSE8_V_M4_MASK,
          8840 => Opcode::PseudoVSE8_V_M8,
          8841 => Opcode::PseudoVSE8_V_M8_MASK,
          8842 => Opcode::PseudoVSE8_V_MF2,
          8843 => Opcode::PseudoVSE8_V_MF2_MASK,
          8844 => Opcode::PseudoVSE8_V_MF4,
          8845 => Opcode::PseudoVSE8_V_MF4_MASK,
          8846 => Opcode::PseudoVSE8_V_MF8,
          8847 => Opcode::PseudoVSE8_V_MF8_MASK,
          8848 => Opcode::PseudoVSETIVLI,
          8849 => Opcode::PseudoVSETVLI,
          8850 => Opcode::PseudoVSETVLIX0,
          8851 => Opcode::PseudoVSETVLIX0X0,
          8852 => Opcode::PseudoVSEXT_VF2_M1,
          8853 => Opcode::PseudoVSEXT_VF2_M1_MASK,
          8854 => Opcode::PseudoVSEXT_VF2_M2,
          8855 => Opcode::PseudoVSEXT_VF2_M2_MASK,
          8856 => Opcode::PseudoVSEXT_VF2_M4,
          8857 => Opcode::PseudoVSEXT_VF2_M4_MASK,
          8858 => Opcode::PseudoVSEXT_VF2_M8,
          8859 => Opcode::PseudoVSEXT_VF2_M8_MASK,
          8860 => Opcode::PseudoVSEXT_VF2_MF2,
          8861 => Opcode::PseudoVSEXT_VF2_MF2_MASK,
          8862 => Opcode::PseudoVSEXT_VF2_MF4,
          8863 => Opcode::PseudoVSEXT_VF2_MF4_MASK,
          8864 => Opcode::PseudoVSEXT_VF4_M1,
          8865 => Opcode::PseudoVSEXT_VF4_M1_MASK,
          8866 => Opcode::PseudoVSEXT_VF4_M2,
          8867 => Opcode::PseudoVSEXT_VF4_M2_MASK,
          8868 => Opcode::PseudoVSEXT_VF4_M4,
          8869 => Opcode::PseudoVSEXT_VF4_M4_MASK,
          8870 => Opcode::PseudoVSEXT_VF4_M8,
          8871 => Opcode::PseudoVSEXT_VF4_M8_MASK,
          8872 => Opcode::PseudoVSEXT_VF4_MF2,
          8873 => Opcode::PseudoVSEXT_VF4_MF2_MASK,
          8874 => Opcode::PseudoVSEXT_VF8_M1,
          8875 => Opcode::PseudoVSEXT_VF8_M1_MASK,
          8876 => Opcode::PseudoVSEXT_VF8_M2,
          8877 => Opcode::PseudoVSEXT_VF8_M2_MASK,
          8878 => Opcode::PseudoVSEXT_VF8_M4,
          8879 => Opcode::PseudoVSEXT_VF8_M4_MASK,
          8880 => Opcode::PseudoVSEXT_VF8_M8,
          8881 => Opcode::PseudoVSEXT_VF8_M8_MASK,
          8882 => Opcode::PseudoVSHA2CH_VV_M1,
          8883 => Opcode::PseudoVSHA2CH_VV_M2,
          8884 => Opcode::PseudoVSHA2CH_VV_M4,
          8885 => Opcode::PseudoVSHA2CH_VV_M8,
          8886 => Opcode::PseudoVSHA2CH_VV_MF2,
          8887 => Opcode::PseudoVSHA2CL_VV_M1,
          8888 => Opcode::PseudoVSHA2CL_VV_M2,
          8889 => Opcode::PseudoVSHA2CL_VV_M4,
          8890 => Opcode::PseudoVSHA2CL_VV_M8,
          8891 => Opcode::PseudoVSHA2CL_VV_MF2,
          8892 => Opcode::PseudoVSHA2MS_VV_M1_E32,
          8893 => Opcode::PseudoVSHA2MS_VV_M1_E64,
          8894 => Opcode::PseudoVSHA2MS_VV_M2_E32,
          8895 => Opcode::PseudoVSHA2MS_VV_M2_E64,
          8896 => Opcode::PseudoVSHA2MS_VV_M4_E32,
          8897 => Opcode::PseudoVSHA2MS_VV_M4_E64,
          8898 => Opcode::PseudoVSHA2MS_VV_M8_E32,
          8899 => Opcode::PseudoVSHA2MS_VV_M8_E64,
          8900 => Opcode::PseudoVSHA2MS_VV_MF2_E32,
          8901 => Opcode::PseudoVSLIDE1DOWN_VX_M1,
          8902 => Opcode::PseudoVSLIDE1DOWN_VX_M1_MASK,
          8903 => Opcode::PseudoVSLIDE1DOWN_VX_M2,
          8904 => Opcode::PseudoVSLIDE1DOWN_VX_M2_MASK,
          8905 => Opcode::PseudoVSLIDE1DOWN_VX_M4,
          8906 => Opcode::PseudoVSLIDE1DOWN_VX_M4_MASK,
          8907 => Opcode::PseudoVSLIDE1DOWN_VX_M8,
          8908 => Opcode::PseudoVSLIDE1DOWN_VX_M8_MASK,
          8909 => Opcode::PseudoVSLIDE1DOWN_VX_MF2,
          8910 => Opcode::PseudoVSLIDE1DOWN_VX_MF2_MASK,
          8911 => Opcode::PseudoVSLIDE1DOWN_VX_MF4,
          8912 => Opcode::PseudoVSLIDE1DOWN_VX_MF4_MASK,
          8913 => Opcode::PseudoVSLIDE1DOWN_VX_MF8,
          8914 => Opcode::PseudoVSLIDE1DOWN_VX_MF8_MASK,
          8915 => Opcode::PseudoVSLIDE1UP_VX_M1,
          8916 => Opcode::PseudoVSLIDE1UP_VX_M1_MASK,
          8917 => Opcode::PseudoVSLIDE1UP_VX_M2,
          8918 => Opcode::PseudoVSLIDE1UP_VX_M2_MASK,
          8919 => Opcode::PseudoVSLIDE1UP_VX_M4,
          8920 => Opcode::PseudoVSLIDE1UP_VX_M4_MASK,
          8921 => Opcode::PseudoVSLIDE1UP_VX_M8,
          8922 => Opcode::PseudoVSLIDE1UP_VX_M8_MASK,
          8923 => Opcode::PseudoVSLIDE1UP_VX_MF2,
          8924 => Opcode::PseudoVSLIDE1UP_VX_MF2_MASK,
          8925 => Opcode::PseudoVSLIDE1UP_VX_MF4,
          8926 => Opcode::PseudoVSLIDE1UP_VX_MF4_MASK,
          8927 => Opcode::PseudoVSLIDE1UP_VX_MF8,
          8928 => Opcode::PseudoVSLIDE1UP_VX_MF8_MASK,
          8929 => Opcode::PseudoVSLIDEDOWN_VI_M1,
          8930 => Opcode::PseudoVSLIDEDOWN_VI_M1_MASK,
          8931 => Opcode::PseudoVSLIDEDOWN_VI_M2,
          8932 => Opcode::PseudoVSLIDEDOWN_VI_M2_MASK,
          8933 => Opcode::PseudoVSLIDEDOWN_VI_M4,
          8934 => Opcode::PseudoVSLIDEDOWN_VI_M4_MASK,
          8935 => Opcode::PseudoVSLIDEDOWN_VI_M8,
          8936 => Opcode::PseudoVSLIDEDOWN_VI_M8_MASK,
          8937 => Opcode::PseudoVSLIDEDOWN_VI_MF2,
          8938 => Opcode::PseudoVSLIDEDOWN_VI_MF2_MASK,
          8939 => Opcode::PseudoVSLIDEDOWN_VI_MF4,
          8940 => Opcode::PseudoVSLIDEDOWN_VI_MF4_MASK,
          8941 => Opcode::PseudoVSLIDEDOWN_VI_MF8,
          8942 => Opcode::PseudoVSLIDEDOWN_VI_MF8_MASK,
          8943 => Opcode::PseudoVSLIDEDOWN_VX_M1,
          8944 => Opcode::PseudoVSLIDEDOWN_VX_M1_MASK,
          8945 => Opcode::PseudoVSLIDEDOWN_VX_M2,
          8946 => Opcode::PseudoVSLIDEDOWN_VX_M2_MASK,
          8947 => Opcode::PseudoVSLIDEDOWN_VX_M4,
          8948 => Opcode::PseudoVSLIDEDOWN_VX_M4_MASK,
          8949 => Opcode::PseudoVSLIDEDOWN_VX_M8,
          8950 => Opcode::PseudoVSLIDEDOWN_VX_M8_MASK,
          8951 => Opcode::PseudoVSLIDEDOWN_VX_MF2,
          8952 => Opcode::PseudoVSLIDEDOWN_VX_MF2_MASK,
          8953 => Opcode::PseudoVSLIDEDOWN_VX_MF4,
          8954 => Opcode::PseudoVSLIDEDOWN_VX_MF4_MASK,
          8955 => Opcode::PseudoVSLIDEDOWN_VX_MF8,
          8956 => Opcode::PseudoVSLIDEDOWN_VX_MF8_MASK,
          8957 => Opcode::PseudoVSLIDEUP_VI_M1,
          8958 => Opcode::PseudoVSLIDEUP_VI_M1_MASK,
          8959 => Opcode::PseudoVSLIDEUP_VI_M2,
          8960 => Opcode::PseudoVSLIDEUP_VI_M2_MASK,
          8961 => Opcode::PseudoVSLIDEUP_VI_M4,
          8962 => Opcode::PseudoVSLIDEUP_VI_M4_MASK,
          8963 => Opcode::PseudoVSLIDEUP_VI_M8,
          8964 => Opcode::PseudoVSLIDEUP_VI_M8_MASK,
          8965 => Opcode::PseudoVSLIDEUP_VI_MF2,
          8966 => Opcode::PseudoVSLIDEUP_VI_MF2_MASK,
          8967 => Opcode::PseudoVSLIDEUP_VI_MF4,
          8968 => Opcode::PseudoVSLIDEUP_VI_MF4_MASK,
          8969 => Opcode::PseudoVSLIDEUP_VI_MF8,
          8970 => Opcode::PseudoVSLIDEUP_VI_MF8_MASK,
          8971 => Opcode::PseudoVSLIDEUP_VX_M1,
          8972 => Opcode::PseudoVSLIDEUP_VX_M1_MASK,
          8973 => Opcode::PseudoVSLIDEUP_VX_M2,
          8974 => Opcode::PseudoVSLIDEUP_VX_M2_MASK,
          8975 => Opcode::PseudoVSLIDEUP_VX_M4,
          8976 => Opcode::PseudoVSLIDEUP_VX_M4_MASK,
          8977 => Opcode::PseudoVSLIDEUP_VX_M8,
          8978 => Opcode::PseudoVSLIDEUP_VX_M8_MASK,
          8979 => Opcode::PseudoVSLIDEUP_VX_MF2,
          8980 => Opcode::PseudoVSLIDEUP_VX_MF2_MASK,
          8981 => Opcode::PseudoVSLIDEUP_VX_MF4,
          8982 => Opcode::PseudoVSLIDEUP_VX_MF4_MASK,
          8983 => Opcode::PseudoVSLIDEUP_VX_MF8,
          8984 => Opcode::PseudoVSLIDEUP_VX_MF8_MASK,
          8985 => Opcode::PseudoVSLL_VI_M1,
          8986 => Opcode::PseudoVSLL_VI_M1_MASK,
          8987 => Opcode::PseudoVSLL_VI_M2,
          8988 => Opcode::PseudoVSLL_VI_M2_MASK,
          8989 => Opcode::PseudoVSLL_VI_M4,
          8990 => Opcode::PseudoVSLL_VI_M4_MASK,
          8991 => Opcode::PseudoVSLL_VI_M8,
          8992 => Opcode::PseudoVSLL_VI_M8_MASK,
          8993 => Opcode::PseudoVSLL_VI_MF2,
          8994 => Opcode::PseudoVSLL_VI_MF2_MASK,
          8995 => Opcode::PseudoVSLL_VI_MF4,
          8996 => Opcode::PseudoVSLL_VI_MF4_MASK,
          8997 => Opcode::PseudoVSLL_VI_MF8,
          8998 => Opcode::PseudoVSLL_VI_MF8_MASK,
          8999 => Opcode::PseudoVSLL_VV_M1,
          9000 => Opcode::PseudoVSLL_VV_M1_MASK,
          9001 => Opcode::PseudoVSLL_VV_M2,
          9002 => Opcode::PseudoVSLL_VV_M2_MASK,
          9003 => Opcode::PseudoVSLL_VV_M4,
          9004 => Opcode::PseudoVSLL_VV_M4_MASK,
          9005 => Opcode::PseudoVSLL_VV_M8,
          9006 => Opcode::PseudoVSLL_VV_M8_MASK,
          9007 => Opcode::PseudoVSLL_VV_MF2,
          9008 => Opcode::PseudoVSLL_VV_MF2_MASK,
          9009 => Opcode::PseudoVSLL_VV_MF4,
          9010 => Opcode::PseudoVSLL_VV_MF4_MASK,
          9011 => Opcode::PseudoVSLL_VV_MF8,
          9012 => Opcode::PseudoVSLL_VV_MF8_MASK,
          9013 => Opcode::PseudoVSLL_VX_M1,
          9014 => Opcode::PseudoVSLL_VX_M1_MASK,
          9015 => Opcode::PseudoVSLL_VX_M2,
          9016 => Opcode::PseudoVSLL_VX_M2_MASK,
          9017 => Opcode::PseudoVSLL_VX_M4,
          9018 => Opcode::PseudoVSLL_VX_M4_MASK,
          9019 => Opcode::PseudoVSLL_VX_M8,
          9020 => Opcode::PseudoVSLL_VX_M8_MASK,
          9021 => Opcode::PseudoVSLL_VX_MF2,
          9022 => Opcode::PseudoVSLL_VX_MF2_MASK,
          9023 => Opcode::PseudoVSLL_VX_MF4,
          9024 => Opcode::PseudoVSLL_VX_MF4_MASK,
          9025 => Opcode::PseudoVSLL_VX_MF8,
          9026 => Opcode::PseudoVSLL_VX_MF8_MASK,
          9027 => Opcode::PseudoVSM3C_VI_M1,
          9028 => Opcode::PseudoVSM3C_VI_M2,
          9029 => Opcode::PseudoVSM3C_VI_M4,
          9030 => Opcode::PseudoVSM3C_VI_M8,
          9031 => Opcode::PseudoVSM3C_VI_MF2,
          9032 => Opcode::PseudoVSM3ME_VV_M1,
          9033 => Opcode::PseudoVSM3ME_VV_M2,
          9034 => Opcode::PseudoVSM3ME_VV_M4,
          9035 => Opcode::PseudoVSM3ME_VV_M8,
          9036 => Opcode::PseudoVSM3ME_VV_MF2,
          9037 => Opcode::PseudoVSM4K_VI_M1,
          9038 => Opcode::PseudoVSM4K_VI_M2,
          9039 => Opcode::PseudoVSM4K_VI_M4,
          9040 => Opcode::PseudoVSM4K_VI_M8,
          9041 => Opcode::PseudoVSM4K_VI_MF2,
          9042 => Opcode::PseudoVSM4R_VS_M1_M1,
          9043 => Opcode::PseudoVSM4R_VS_M1_MF2,
          9044 => Opcode::PseudoVSM4R_VS_M1_MF4,
          9045 => Opcode::PseudoVSM4R_VS_M1_MF8,
          9046 => Opcode::PseudoVSM4R_VS_M2_M1,
          9047 => Opcode::PseudoVSM4R_VS_M2_M2,
          9048 => Opcode::PseudoVSM4R_VS_M2_MF2,
          9049 => Opcode::PseudoVSM4R_VS_M2_MF4,
          9050 => Opcode::PseudoVSM4R_VS_M2_MF8,
          9051 => Opcode::PseudoVSM4R_VS_M4_M1,
          9052 => Opcode::PseudoVSM4R_VS_M4_M2,
          9053 => Opcode::PseudoVSM4R_VS_M4_M4,
          9054 => Opcode::PseudoVSM4R_VS_M4_MF2,
          9055 => Opcode::PseudoVSM4R_VS_M4_MF4,
          9056 => Opcode::PseudoVSM4R_VS_M4_MF8,
          9057 => Opcode::PseudoVSM4R_VS_M8_M1,
          9058 => Opcode::PseudoVSM4R_VS_M8_M2,
          9059 => Opcode::PseudoVSM4R_VS_M8_M4,
          9060 => Opcode::PseudoVSM4R_VS_M8_MF2,
          9061 => Opcode::PseudoVSM4R_VS_M8_MF4,
          9062 => Opcode::PseudoVSM4R_VS_M8_MF8,
          9063 => Opcode::PseudoVSM4R_VS_MF2_MF2,
          9064 => Opcode::PseudoVSM4R_VS_MF2_MF4,
          9065 => Opcode::PseudoVSM4R_VS_MF2_MF8,
          9066 => Opcode::PseudoVSM4R_VV_M1,
          9067 => Opcode::PseudoVSM4R_VV_M2,
          9068 => Opcode::PseudoVSM4R_VV_M4,
          9069 => Opcode::PseudoVSM4R_VV_M8,
          9070 => Opcode::PseudoVSM4R_VV_MF2,
          9071 => Opcode::PseudoVSMUL_VV_M1,
          9072 => Opcode::PseudoVSMUL_VV_M1_MASK,
          9073 => Opcode::PseudoVSMUL_VV_M2,
          9074 => Opcode::PseudoVSMUL_VV_M2_MASK,
          9075 => Opcode::PseudoVSMUL_VV_M4,
          9076 => Opcode::PseudoVSMUL_VV_M4_MASK,
          9077 => Opcode::PseudoVSMUL_VV_M8,
          9078 => Opcode::PseudoVSMUL_VV_M8_MASK,
          9079 => Opcode::PseudoVSMUL_VV_MF2,
          9080 => Opcode::PseudoVSMUL_VV_MF2_MASK,
          9081 => Opcode::PseudoVSMUL_VV_MF4,
          9082 => Opcode::PseudoVSMUL_VV_MF4_MASK,
          9083 => Opcode::PseudoVSMUL_VV_MF8,
          9084 => Opcode::PseudoVSMUL_VV_MF8_MASK,
          9085 => Opcode::PseudoVSMUL_VX_M1,
          9086 => Opcode::PseudoVSMUL_VX_M1_MASK,
          9087 => Opcode::PseudoVSMUL_VX_M2,
          9088 => Opcode::PseudoVSMUL_VX_M2_MASK,
          9089 => Opcode::PseudoVSMUL_VX_M4,
          9090 => Opcode::PseudoVSMUL_VX_M4_MASK,
          9091 => Opcode::PseudoVSMUL_VX_M8,
          9092 => Opcode::PseudoVSMUL_VX_M8_MASK,
          9093 => Opcode::PseudoVSMUL_VX_MF2,
          9094 => Opcode::PseudoVSMUL_VX_MF2_MASK,
          9095 => Opcode::PseudoVSMUL_VX_MF4,
          9096 => Opcode::PseudoVSMUL_VX_MF4_MASK,
          9097 => Opcode::PseudoVSMUL_VX_MF8,
          9098 => Opcode::PseudoVSMUL_VX_MF8_MASK,
          9099 => Opcode::PseudoVSM_V_B1,
          9100 => Opcode::PseudoVSM_V_B16,
          9101 => Opcode::PseudoVSM_V_B2,
          9102 => Opcode::PseudoVSM_V_B32,
          9103 => Opcode::PseudoVSM_V_B4,
          9104 => Opcode::PseudoVSM_V_B64,
          9105 => Opcode::PseudoVSM_V_B8,
          9106 => Opcode::PseudoVSOXEI16_V_M1_M1,
          9107 => Opcode::PseudoVSOXEI16_V_M1_M1_MASK,
          9108 => Opcode::PseudoVSOXEI16_V_M1_M2,
          9109 => Opcode::PseudoVSOXEI16_V_M1_M2_MASK,
          9110 => Opcode::PseudoVSOXEI16_V_M1_M4,
          9111 => Opcode::PseudoVSOXEI16_V_M1_M4_MASK,
          9112 => Opcode::PseudoVSOXEI16_V_M1_MF2,
          9113 => Opcode::PseudoVSOXEI16_V_M1_MF2_MASK,
          9114 => Opcode::PseudoVSOXEI16_V_M2_M1,
          9115 => Opcode::PseudoVSOXEI16_V_M2_M1_MASK,
          9116 => Opcode::PseudoVSOXEI16_V_M2_M2,
          9117 => Opcode::PseudoVSOXEI16_V_M2_M2_MASK,
          9118 => Opcode::PseudoVSOXEI16_V_M2_M4,
          9119 => Opcode::PseudoVSOXEI16_V_M2_M4_MASK,
          9120 => Opcode::PseudoVSOXEI16_V_M2_M8,
          9121 => Opcode::PseudoVSOXEI16_V_M2_M8_MASK,
          9122 => Opcode::PseudoVSOXEI16_V_M4_M2,
          9123 => Opcode::PseudoVSOXEI16_V_M4_M2_MASK,
          9124 => Opcode::PseudoVSOXEI16_V_M4_M4,
          9125 => Opcode::PseudoVSOXEI16_V_M4_M4_MASK,
          9126 => Opcode::PseudoVSOXEI16_V_M4_M8,
          9127 => Opcode::PseudoVSOXEI16_V_M4_M8_MASK,
          9128 => Opcode::PseudoVSOXEI16_V_M8_M4,
          9129 => Opcode::PseudoVSOXEI16_V_M8_M4_MASK,
          9130 => Opcode::PseudoVSOXEI16_V_M8_M8,
          9131 => Opcode::PseudoVSOXEI16_V_M8_M8_MASK,
          9132 => Opcode::PseudoVSOXEI16_V_MF2_M1,
          9133 => Opcode::PseudoVSOXEI16_V_MF2_M1_MASK,
          9134 => Opcode::PseudoVSOXEI16_V_MF2_M2,
          9135 => Opcode::PseudoVSOXEI16_V_MF2_M2_MASK,
          9136 => Opcode::PseudoVSOXEI16_V_MF2_MF2,
          9137 => Opcode::PseudoVSOXEI16_V_MF2_MF2_MASK,
          9138 => Opcode::PseudoVSOXEI16_V_MF2_MF4,
          9139 => Opcode::PseudoVSOXEI16_V_MF2_MF4_MASK,
          9140 => Opcode::PseudoVSOXEI16_V_MF4_M1,
          9141 => Opcode::PseudoVSOXEI16_V_MF4_M1_MASK,
          9142 => Opcode::PseudoVSOXEI16_V_MF4_MF2,
          9143 => Opcode::PseudoVSOXEI16_V_MF4_MF2_MASK,
          9144 => Opcode::PseudoVSOXEI16_V_MF4_MF4,
          9145 => Opcode::PseudoVSOXEI16_V_MF4_MF4_MASK,
          9146 => Opcode::PseudoVSOXEI16_V_MF4_MF8,
          9147 => Opcode::PseudoVSOXEI16_V_MF4_MF8_MASK,
          9148 => Opcode::PseudoVSOXEI32_V_M1_M1,
          9149 => Opcode::PseudoVSOXEI32_V_M1_M1_MASK,
          9150 => Opcode::PseudoVSOXEI32_V_M1_M2,
          9151 => Opcode::PseudoVSOXEI32_V_M1_M2_MASK,
          9152 => Opcode::PseudoVSOXEI32_V_M1_MF2,
          9153 => Opcode::PseudoVSOXEI32_V_M1_MF2_MASK,
          9154 => Opcode::PseudoVSOXEI32_V_M1_MF4,
          9155 => Opcode::PseudoVSOXEI32_V_M1_MF4_MASK,
          9156 => Opcode::PseudoVSOXEI32_V_M2_M1,
          9157 => Opcode::PseudoVSOXEI32_V_M2_M1_MASK,
          9158 => Opcode::PseudoVSOXEI32_V_M2_M2,
          9159 => Opcode::PseudoVSOXEI32_V_M2_M2_MASK,
          9160 => Opcode::PseudoVSOXEI32_V_M2_M4,
          9161 => Opcode::PseudoVSOXEI32_V_M2_M4_MASK,
          9162 => Opcode::PseudoVSOXEI32_V_M2_MF2,
          9163 => Opcode::PseudoVSOXEI32_V_M2_MF2_MASK,
          9164 => Opcode::PseudoVSOXEI32_V_M4_M1,
          9165 => Opcode::PseudoVSOXEI32_V_M4_M1_MASK,
          9166 => Opcode::PseudoVSOXEI32_V_M4_M2,
          9167 => Opcode::PseudoVSOXEI32_V_M4_M2_MASK,
          9168 => Opcode::PseudoVSOXEI32_V_M4_M4,
          9169 => Opcode::PseudoVSOXEI32_V_M4_M4_MASK,
          9170 => Opcode::PseudoVSOXEI32_V_M4_M8,
          9171 => Opcode::PseudoVSOXEI32_V_M4_M8_MASK,
          9172 => Opcode::PseudoVSOXEI32_V_M8_M2,
          9173 => Opcode::PseudoVSOXEI32_V_M8_M2_MASK,
          9174 => Opcode::PseudoVSOXEI32_V_M8_M4,
          9175 => Opcode::PseudoVSOXEI32_V_M8_M4_MASK,
          9176 => Opcode::PseudoVSOXEI32_V_M8_M8,
          9177 => Opcode::PseudoVSOXEI32_V_M8_M8_MASK,
          9178 => Opcode::PseudoVSOXEI32_V_MF2_M1,
          9179 => Opcode::PseudoVSOXEI32_V_MF2_M1_MASK,
          9180 => Opcode::PseudoVSOXEI32_V_MF2_MF2,
          9181 => Opcode::PseudoVSOXEI32_V_MF2_MF2_MASK,
          9182 => Opcode::PseudoVSOXEI32_V_MF2_MF4,
          9183 => Opcode::PseudoVSOXEI32_V_MF2_MF4_MASK,
          9184 => Opcode::PseudoVSOXEI32_V_MF2_MF8,
          9185 => Opcode::PseudoVSOXEI32_V_MF2_MF8_MASK,
          9186 => Opcode::PseudoVSOXEI64_V_M1_M1,
          9187 => Opcode::PseudoVSOXEI64_V_M1_M1_MASK,
          9188 => Opcode::PseudoVSOXEI64_V_M1_MF2,
          9189 => Opcode::PseudoVSOXEI64_V_M1_MF2_MASK,
          9190 => Opcode::PseudoVSOXEI64_V_M1_MF4,
          9191 => Opcode::PseudoVSOXEI64_V_M1_MF4_MASK,
          9192 => Opcode::PseudoVSOXEI64_V_M1_MF8,
          9193 => Opcode::PseudoVSOXEI64_V_M1_MF8_MASK,
          9194 => Opcode::PseudoVSOXEI64_V_M2_M1,
          9195 => Opcode::PseudoVSOXEI64_V_M2_M1_MASK,
          9196 => Opcode::PseudoVSOXEI64_V_M2_M2,
          9197 => Opcode::PseudoVSOXEI64_V_M2_M2_MASK,
          9198 => Opcode::PseudoVSOXEI64_V_M2_MF2,
          9199 => Opcode::PseudoVSOXEI64_V_M2_MF2_MASK,
          9200 => Opcode::PseudoVSOXEI64_V_M2_MF4,
          9201 => Opcode::PseudoVSOXEI64_V_M2_MF4_MASK,
          9202 => Opcode::PseudoVSOXEI64_V_M4_M1,
          9203 => Opcode::PseudoVSOXEI64_V_M4_M1_MASK,
          9204 => Opcode::PseudoVSOXEI64_V_M4_M2,
          9205 => Opcode::PseudoVSOXEI64_V_M4_M2_MASK,
          9206 => Opcode::PseudoVSOXEI64_V_M4_M4,
          9207 => Opcode::PseudoVSOXEI64_V_M4_M4_MASK,
          9208 => Opcode::PseudoVSOXEI64_V_M4_MF2,
          9209 => Opcode::PseudoVSOXEI64_V_M4_MF2_MASK,
          9210 => Opcode::PseudoVSOXEI64_V_M8_M1,
          9211 => Opcode::PseudoVSOXEI64_V_M8_M1_MASK,
          9212 => Opcode::PseudoVSOXEI64_V_M8_M2,
          9213 => Opcode::PseudoVSOXEI64_V_M8_M2_MASK,
          9214 => Opcode::PseudoVSOXEI64_V_M8_M4,
          9215 => Opcode::PseudoVSOXEI64_V_M8_M4_MASK,
          9216 => Opcode::PseudoVSOXEI64_V_M8_M8,
          9217 => Opcode::PseudoVSOXEI64_V_M8_M8_MASK,
          9218 => Opcode::PseudoVSOXEI8_V_M1_M1,
          9219 => Opcode::PseudoVSOXEI8_V_M1_M1_MASK,
          9220 => Opcode::PseudoVSOXEI8_V_M1_M2,
          9221 => Opcode::PseudoVSOXEI8_V_M1_M2_MASK,
          9222 => Opcode::PseudoVSOXEI8_V_M1_M4,
          9223 => Opcode::PseudoVSOXEI8_V_M1_M4_MASK,
          9224 => Opcode::PseudoVSOXEI8_V_M1_M8,
          9225 => Opcode::PseudoVSOXEI8_V_M1_M8_MASK,
          9226 => Opcode::PseudoVSOXEI8_V_M2_M2,
          9227 => Opcode::PseudoVSOXEI8_V_M2_M2_MASK,
          9228 => Opcode::PseudoVSOXEI8_V_M2_M4,
          9229 => Opcode::PseudoVSOXEI8_V_M2_M4_MASK,
          9230 => Opcode::PseudoVSOXEI8_V_M2_M8,
          9231 => Opcode::PseudoVSOXEI8_V_M2_M8_MASK,
          9232 => Opcode::PseudoVSOXEI8_V_M4_M4,
          9233 => Opcode::PseudoVSOXEI8_V_M4_M4_MASK,
          9234 => Opcode::PseudoVSOXEI8_V_M4_M8,
          9235 => Opcode::PseudoVSOXEI8_V_M4_M8_MASK,
          9236 => Opcode::PseudoVSOXEI8_V_M8_M8,
          9237 => Opcode::PseudoVSOXEI8_V_M8_M8_MASK,
          9238 => Opcode::PseudoVSOXEI8_V_MF2_M1,
          9239 => Opcode::PseudoVSOXEI8_V_MF2_M1_MASK,
          9240 => Opcode::PseudoVSOXEI8_V_MF2_M2,
          9241 => Opcode::PseudoVSOXEI8_V_MF2_M2_MASK,
          9242 => Opcode::PseudoVSOXEI8_V_MF2_M4,
          9243 => Opcode::PseudoVSOXEI8_V_MF2_M4_MASK,
          9244 => Opcode::PseudoVSOXEI8_V_MF2_MF2,
          9245 => Opcode::PseudoVSOXEI8_V_MF2_MF2_MASK,
          9246 => Opcode::PseudoVSOXEI8_V_MF4_M1,
          9247 => Opcode::PseudoVSOXEI8_V_MF4_M1_MASK,
          9248 => Opcode::PseudoVSOXEI8_V_MF4_M2,
          9249 => Opcode::PseudoVSOXEI8_V_MF4_M2_MASK,
          9250 => Opcode::PseudoVSOXEI8_V_MF4_MF2,
          9251 => Opcode::PseudoVSOXEI8_V_MF4_MF2_MASK,
          9252 => Opcode::PseudoVSOXEI8_V_MF4_MF4,
          9253 => Opcode::PseudoVSOXEI8_V_MF4_MF4_MASK,
          9254 => Opcode::PseudoVSOXEI8_V_MF8_M1,
          9255 => Opcode::PseudoVSOXEI8_V_MF8_M1_MASK,
          9256 => Opcode::PseudoVSOXEI8_V_MF8_MF2,
          9257 => Opcode::PseudoVSOXEI8_V_MF8_MF2_MASK,
          9258 => Opcode::PseudoVSOXEI8_V_MF8_MF4,
          9259 => Opcode::PseudoVSOXEI8_V_MF8_MF4_MASK,
          9260 => Opcode::PseudoVSOXEI8_V_MF8_MF8,
          9261 => Opcode::PseudoVSOXEI8_V_MF8_MF8_MASK,
          9262 => Opcode::PseudoVSOXSEG2EI16_V_M1_M1,
          9263 => Opcode::PseudoVSOXSEG2EI16_V_M1_M1_MASK,
          9264 => Opcode::PseudoVSOXSEG2EI16_V_M1_M2,
          9265 => Opcode::PseudoVSOXSEG2EI16_V_M1_M2_MASK,
          9266 => Opcode::PseudoVSOXSEG2EI16_V_M1_M4,
          9267 => Opcode::PseudoVSOXSEG2EI16_V_M1_M4_MASK,
          9268 => Opcode::PseudoVSOXSEG2EI16_V_M1_MF2,
          9269 => Opcode::PseudoVSOXSEG2EI16_V_M1_MF2_MASK,
          9270 => Opcode::PseudoVSOXSEG2EI16_V_M2_M1,
          9271 => Opcode::PseudoVSOXSEG2EI16_V_M2_M1_MASK,
          9272 => Opcode::PseudoVSOXSEG2EI16_V_M2_M2,
          9273 => Opcode::PseudoVSOXSEG2EI16_V_M2_M2_MASK,
          9274 => Opcode::PseudoVSOXSEG2EI16_V_M2_M4,
          9275 => Opcode::PseudoVSOXSEG2EI16_V_M2_M4_MASK,
          9276 => Opcode::PseudoVSOXSEG2EI16_V_M4_M2,
          9277 => Opcode::PseudoVSOXSEG2EI16_V_M4_M2_MASK,
          9278 => Opcode::PseudoVSOXSEG2EI16_V_M4_M4,
          9279 => Opcode::PseudoVSOXSEG2EI16_V_M4_M4_MASK,
          9280 => Opcode::PseudoVSOXSEG2EI16_V_M8_M4,
          9281 => Opcode::PseudoVSOXSEG2EI16_V_M8_M4_MASK,
          9282 => Opcode::PseudoVSOXSEG2EI16_V_MF2_M1,
          9283 => Opcode::PseudoVSOXSEG2EI16_V_MF2_M1_MASK,
          9284 => Opcode::PseudoVSOXSEG2EI16_V_MF2_M2,
          9285 => Opcode::PseudoVSOXSEG2EI16_V_MF2_M2_MASK,
          9286 => Opcode::PseudoVSOXSEG2EI16_V_MF2_MF2,
          9287 => Opcode::PseudoVSOXSEG2EI16_V_MF2_MF2_MASK,
          9288 => Opcode::PseudoVSOXSEG2EI16_V_MF2_MF4,
          9289 => Opcode::PseudoVSOXSEG2EI16_V_MF2_MF4_MASK,
          9290 => Opcode::PseudoVSOXSEG2EI16_V_MF4_M1,
          9291 => Opcode::PseudoVSOXSEG2EI16_V_MF4_M1_MASK,
          9292 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF2,
          9293 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF2_MASK,
          9294 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF4,
          9295 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF4_MASK,
          9296 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF8,
          9297 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF8_MASK,
          9298 => Opcode::PseudoVSOXSEG2EI32_V_M1_M1,
          9299 => Opcode::PseudoVSOXSEG2EI32_V_M1_M1_MASK,
          9300 => Opcode::PseudoVSOXSEG2EI32_V_M1_M2,
          9301 => Opcode::PseudoVSOXSEG2EI32_V_M1_M2_MASK,
          9302 => Opcode::PseudoVSOXSEG2EI32_V_M1_MF2,
          9303 => Opcode::PseudoVSOXSEG2EI32_V_M1_MF2_MASK,
          9304 => Opcode::PseudoVSOXSEG2EI32_V_M1_MF4,
          9305 => Opcode::PseudoVSOXSEG2EI32_V_M1_MF4_MASK,
          9306 => Opcode::PseudoVSOXSEG2EI32_V_M2_M1,
          9307 => Opcode::PseudoVSOXSEG2EI32_V_M2_M1_MASK,
          9308 => Opcode::PseudoVSOXSEG2EI32_V_M2_M2,
          9309 => Opcode::PseudoVSOXSEG2EI32_V_M2_M2_MASK,
          9310 => Opcode::PseudoVSOXSEG2EI32_V_M2_M4,
          9311 => Opcode::PseudoVSOXSEG2EI32_V_M2_M4_MASK,
          9312 => Opcode::PseudoVSOXSEG2EI32_V_M2_MF2,
          9313 => Opcode::PseudoVSOXSEG2EI32_V_M2_MF2_MASK,
          9314 => Opcode::PseudoVSOXSEG2EI32_V_M4_M1,
          9315 => Opcode::PseudoVSOXSEG2EI32_V_M4_M1_MASK,
          9316 => Opcode::PseudoVSOXSEG2EI32_V_M4_M2,
          9317 => Opcode::PseudoVSOXSEG2EI32_V_M4_M2_MASK,
          9318 => Opcode::PseudoVSOXSEG2EI32_V_M4_M4,
          9319 => Opcode::PseudoVSOXSEG2EI32_V_M4_M4_MASK,
          9320 => Opcode::PseudoVSOXSEG2EI32_V_M8_M2,
          9321 => Opcode::PseudoVSOXSEG2EI32_V_M8_M2_MASK,
          9322 => Opcode::PseudoVSOXSEG2EI32_V_M8_M4,
          9323 => Opcode::PseudoVSOXSEG2EI32_V_M8_M4_MASK,
          9324 => Opcode::PseudoVSOXSEG2EI32_V_MF2_M1,
          9325 => Opcode::PseudoVSOXSEG2EI32_V_MF2_M1_MASK,
          9326 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF2,
          9327 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF2_MASK,
          9328 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF4,
          9329 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF4_MASK,
          9330 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF8,
          9331 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF8_MASK,
          9332 => Opcode::PseudoVSOXSEG2EI64_V_M1_M1,
          9333 => Opcode::PseudoVSOXSEG2EI64_V_M1_M1_MASK,
          9334 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF2,
          9335 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF2_MASK,
          9336 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF4,
          9337 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF4_MASK,
          9338 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF8,
          9339 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF8_MASK,
          9340 => Opcode::PseudoVSOXSEG2EI64_V_M2_M1,
          9341 => Opcode::PseudoVSOXSEG2EI64_V_M2_M1_MASK,
          9342 => Opcode::PseudoVSOXSEG2EI64_V_M2_M2,
          9343 => Opcode::PseudoVSOXSEG2EI64_V_M2_M2_MASK,
          9344 => Opcode::PseudoVSOXSEG2EI64_V_M2_MF2,
          9345 => Opcode::PseudoVSOXSEG2EI64_V_M2_MF2_MASK,
          9346 => Opcode::PseudoVSOXSEG2EI64_V_M2_MF4,
          9347 => Opcode::PseudoVSOXSEG2EI64_V_M2_MF4_MASK,
          9348 => Opcode::PseudoVSOXSEG2EI64_V_M4_M1,
          9349 => Opcode::PseudoVSOXSEG2EI64_V_M4_M1_MASK,
          9350 => Opcode::PseudoVSOXSEG2EI64_V_M4_M2,
          9351 => Opcode::PseudoVSOXSEG2EI64_V_M4_M2_MASK,
          9352 => Opcode::PseudoVSOXSEG2EI64_V_M4_M4,
          9353 => Opcode::PseudoVSOXSEG2EI64_V_M4_M4_MASK,
          9354 => Opcode::PseudoVSOXSEG2EI64_V_M4_MF2,
          9355 => Opcode::PseudoVSOXSEG2EI64_V_M4_MF2_MASK,
          9356 => Opcode::PseudoVSOXSEG2EI64_V_M8_M1,
          9357 => Opcode::PseudoVSOXSEG2EI64_V_M8_M1_MASK,
          9358 => Opcode::PseudoVSOXSEG2EI64_V_M8_M2,
          9359 => Opcode::PseudoVSOXSEG2EI64_V_M8_M2_MASK,
          9360 => Opcode::PseudoVSOXSEG2EI64_V_M8_M4,
          9361 => Opcode::PseudoVSOXSEG2EI64_V_M8_M4_MASK,
          9362 => Opcode::PseudoVSOXSEG2EI8_V_M1_M1,
          9363 => Opcode::PseudoVSOXSEG2EI8_V_M1_M1_MASK,
          9364 => Opcode::PseudoVSOXSEG2EI8_V_M1_M2,
          9365 => Opcode::PseudoVSOXSEG2EI8_V_M1_M2_MASK,
          9366 => Opcode::PseudoVSOXSEG2EI8_V_M1_M4,
          9367 => Opcode::PseudoVSOXSEG2EI8_V_M1_M4_MASK,
          9368 => Opcode::PseudoVSOXSEG2EI8_V_M2_M2,
          9369 => Opcode::PseudoVSOXSEG2EI8_V_M2_M2_MASK,
          9370 => Opcode::PseudoVSOXSEG2EI8_V_M2_M4,
          9371 => Opcode::PseudoVSOXSEG2EI8_V_M2_M4_MASK,
          9372 => Opcode::PseudoVSOXSEG2EI8_V_M4_M4,
          9373 => Opcode::PseudoVSOXSEG2EI8_V_M4_M4_MASK,
          9374 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M1,
          9375 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M1_MASK,
          9376 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M2,
          9377 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M2_MASK,
          9378 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M4,
          9379 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M4_MASK,
          9380 => Opcode::PseudoVSOXSEG2EI8_V_MF2_MF2,
          9381 => Opcode::PseudoVSOXSEG2EI8_V_MF2_MF2_MASK,
          9382 => Opcode::PseudoVSOXSEG2EI8_V_MF4_M1,
          9383 => Opcode::PseudoVSOXSEG2EI8_V_MF4_M1_MASK,
          9384 => Opcode::PseudoVSOXSEG2EI8_V_MF4_M2,
          9385 => Opcode::PseudoVSOXSEG2EI8_V_MF4_M2_MASK,
          9386 => Opcode::PseudoVSOXSEG2EI8_V_MF4_MF2,
          9387 => Opcode::PseudoVSOXSEG2EI8_V_MF4_MF2_MASK,
          9388 => Opcode::PseudoVSOXSEG2EI8_V_MF4_MF4,
          9389 => Opcode::PseudoVSOXSEG2EI8_V_MF4_MF4_MASK,
          9390 => Opcode::PseudoVSOXSEG2EI8_V_MF8_M1,
          9391 => Opcode::PseudoVSOXSEG2EI8_V_MF8_M1_MASK,
          9392 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF2,
          9393 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF2_MASK,
          9394 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF4,
          9395 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF4_MASK,
          9396 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF8,
          9397 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF8_MASK,
          9398 => Opcode::PseudoVSOXSEG3EI16_V_M1_M1,
          9399 => Opcode::PseudoVSOXSEG3EI16_V_M1_M1_MASK,
          9400 => Opcode::PseudoVSOXSEG3EI16_V_M1_M2,
          9401 => Opcode::PseudoVSOXSEG3EI16_V_M1_M2_MASK,
          9402 => Opcode::PseudoVSOXSEG3EI16_V_M1_MF2,
          9403 => Opcode::PseudoVSOXSEG3EI16_V_M1_MF2_MASK,
          9404 => Opcode::PseudoVSOXSEG3EI16_V_M2_M1,
          9405 => Opcode::PseudoVSOXSEG3EI16_V_M2_M1_MASK,
          9406 => Opcode::PseudoVSOXSEG3EI16_V_M2_M2,
          9407 => Opcode::PseudoVSOXSEG3EI16_V_M2_M2_MASK,
          9408 => Opcode::PseudoVSOXSEG3EI16_V_M4_M2,
          9409 => Opcode::PseudoVSOXSEG3EI16_V_M4_M2_MASK,
          9410 => Opcode::PseudoVSOXSEG3EI16_V_MF2_M1,
          9411 => Opcode::PseudoVSOXSEG3EI16_V_MF2_M1_MASK,
          9412 => Opcode::PseudoVSOXSEG3EI16_V_MF2_M2,
          9413 => Opcode::PseudoVSOXSEG3EI16_V_MF2_M2_MASK,
          9414 => Opcode::PseudoVSOXSEG3EI16_V_MF2_MF2,
          9415 => Opcode::PseudoVSOXSEG3EI16_V_MF2_MF2_MASK,
          9416 => Opcode::PseudoVSOXSEG3EI16_V_MF2_MF4,
          9417 => Opcode::PseudoVSOXSEG3EI16_V_MF2_MF4_MASK,
          9418 => Opcode::PseudoVSOXSEG3EI16_V_MF4_M1,
          9419 => Opcode::PseudoVSOXSEG3EI16_V_MF4_M1_MASK,
          9420 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF2,
          9421 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF2_MASK,
          9422 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF4,
          9423 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF4_MASK,
          9424 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF8,
          9425 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF8_MASK,
          9426 => Opcode::PseudoVSOXSEG3EI32_V_M1_M1,
          9427 => Opcode::PseudoVSOXSEG3EI32_V_M1_M1_MASK,
          9428 => Opcode::PseudoVSOXSEG3EI32_V_M1_M2,
          9429 => Opcode::PseudoVSOXSEG3EI32_V_M1_M2_MASK,
          9430 => Opcode::PseudoVSOXSEG3EI32_V_M1_MF2,
          9431 => Opcode::PseudoVSOXSEG3EI32_V_M1_MF2_MASK,
          9432 => Opcode::PseudoVSOXSEG3EI32_V_M1_MF4,
          9433 => Opcode::PseudoVSOXSEG3EI32_V_M1_MF4_MASK,
          9434 => Opcode::PseudoVSOXSEG3EI32_V_M2_M1,
          9435 => Opcode::PseudoVSOXSEG3EI32_V_M2_M1_MASK,
          9436 => Opcode::PseudoVSOXSEG3EI32_V_M2_M2,
          9437 => Opcode::PseudoVSOXSEG3EI32_V_M2_M2_MASK,
          9438 => Opcode::PseudoVSOXSEG3EI32_V_M2_MF2,
          9439 => Opcode::PseudoVSOXSEG3EI32_V_M2_MF2_MASK,
          9440 => Opcode::PseudoVSOXSEG3EI32_V_M4_M1,
          9441 => Opcode::PseudoVSOXSEG3EI32_V_M4_M1_MASK,
          9442 => Opcode::PseudoVSOXSEG3EI32_V_M4_M2,
          9443 => Opcode::PseudoVSOXSEG3EI32_V_M4_M2_MASK,
          9444 => Opcode::PseudoVSOXSEG3EI32_V_M8_M2,
          9445 => Opcode::PseudoVSOXSEG3EI32_V_M8_M2_MASK,
          9446 => Opcode::PseudoVSOXSEG3EI32_V_MF2_M1,
          9447 => Opcode::PseudoVSOXSEG3EI32_V_MF2_M1_MASK,
          9448 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF2,
          9449 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF2_MASK,
          9450 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF4,
          9451 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF4_MASK,
          9452 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF8,
          9453 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF8_MASK,
          9454 => Opcode::PseudoVSOXSEG3EI64_V_M1_M1,
          9455 => Opcode::PseudoVSOXSEG3EI64_V_M1_M1_MASK,
          9456 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF2,
          9457 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF2_MASK,
          9458 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF4,
          9459 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF4_MASK,
          9460 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF8,
          9461 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF8_MASK,
          9462 => Opcode::PseudoVSOXSEG3EI64_V_M2_M1,
          9463 => Opcode::PseudoVSOXSEG3EI64_V_M2_M1_MASK,
          9464 => Opcode::PseudoVSOXSEG3EI64_V_M2_M2,
          9465 => Opcode::PseudoVSOXSEG3EI64_V_M2_M2_MASK,
          9466 => Opcode::PseudoVSOXSEG3EI64_V_M2_MF2,
          9467 => Opcode::PseudoVSOXSEG3EI64_V_M2_MF2_MASK,
          9468 => Opcode::PseudoVSOXSEG3EI64_V_M2_MF4,
          9469 => Opcode::PseudoVSOXSEG3EI64_V_M2_MF4_MASK,
          9470 => Opcode::PseudoVSOXSEG3EI64_V_M4_M1,
          9471 => Opcode::PseudoVSOXSEG3EI64_V_M4_M1_MASK,
          9472 => Opcode::PseudoVSOXSEG3EI64_V_M4_M2,
          9473 => Opcode::PseudoVSOXSEG3EI64_V_M4_M2_MASK,
          9474 => Opcode::PseudoVSOXSEG3EI64_V_M4_MF2,
          9475 => Opcode::PseudoVSOXSEG3EI64_V_M4_MF2_MASK,
          9476 => Opcode::PseudoVSOXSEG3EI64_V_M8_M1,
          9477 => Opcode::PseudoVSOXSEG3EI64_V_M8_M1_MASK,
          9478 => Opcode::PseudoVSOXSEG3EI64_V_M8_M2,
          9479 => Opcode::PseudoVSOXSEG3EI64_V_M8_M2_MASK,
          9480 => Opcode::PseudoVSOXSEG3EI8_V_M1_M1,
          9481 => Opcode::PseudoVSOXSEG3EI8_V_M1_M1_MASK,
          9482 => Opcode::PseudoVSOXSEG3EI8_V_M1_M2,
          9483 => Opcode::PseudoVSOXSEG3EI8_V_M1_M2_MASK,
          9484 => Opcode::PseudoVSOXSEG3EI8_V_M2_M2,
          9485 => Opcode::PseudoVSOXSEG3EI8_V_M2_M2_MASK,
          9486 => Opcode::PseudoVSOXSEG3EI8_V_MF2_M1,
          9487 => Opcode::PseudoVSOXSEG3EI8_V_MF2_M1_MASK,
          9488 => Opcode::PseudoVSOXSEG3EI8_V_MF2_M2,
          9489 => Opcode::PseudoVSOXSEG3EI8_V_MF2_M2_MASK,
          9490 => Opcode::PseudoVSOXSEG3EI8_V_MF2_MF2,
          9491 => Opcode::PseudoVSOXSEG3EI8_V_MF2_MF2_MASK,
          9492 => Opcode::PseudoVSOXSEG3EI8_V_MF4_M1,
          9493 => Opcode::PseudoVSOXSEG3EI8_V_MF4_M1_MASK,
          9494 => Opcode::PseudoVSOXSEG3EI8_V_MF4_M2,
          9495 => Opcode::PseudoVSOXSEG3EI8_V_MF4_M2_MASK,
          9496 => Opcode::PseudoVSOXSEG3EI8_V_MF4_MF2,
          9497 => Opcode::PseudoVSOXSEG3EI8_V_MF4_MF2_MASK,
          9498 => Opcode::PseudoVSOXSEG3EI8_V_MF4_MF4,
          9499 => Opcode::PseudoVSOXSEG3EI8_V_MF4_MF4_MASK,
          9500 => Opcode::PseudoVSOXSEG3EI8_V_MF8_M1,
          9501 => Opcode::PseudoVSOXSEG3EI8_V_MF8_M1_MASK,
          9502 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF2,
          9503 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF2_MASK,
          9504 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF4,
          9505 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF4_MASK,
          9506 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF8,
          9507 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF8_MASK,
          9508 => Opcode::PseudoVSOXSEG4EI16_V_M1_M1,
          9509 => Opcode::PseudoVSOXSEG4EI16_V_M1_M1_MASK,
          9510 => Opcode::PseudoVSOXSEG4EI16_V_M1_M2,
          9511 => Opcode::PseudoVSOXSEG4EI16_V_M1_M2_MASK,
          9512 => Opcode::PseudoVSOXSEG4EI16_V_M1_MF2,
          9513 => Opcode::PseudoVSOXSEG4EI16_V_M1_MF2_MASK,
          9514 => Opcode::PseudoVSOXSEG4EI16_V_M2_M1,
          9515 => Opcode::PseudoVSOXSEG4EI16_V_M2_M1_MASK,
          9516 => Opcode::PseudoVSOXSEG4EI16_V_M2_M2,
          9517 => Opcode::PseudoVSOXSEG4EI16_V_M2_M2_MASK,
          9518 => Opcode::PseudoVSOXSEG4EI16_V_M4_M2,
          9519 => Opcode::PseudoVSOXSEG4EI16_V_M4_M2_MASK,
          9520 => Opcode::PseudoVSOXSEG4EI16_V_MF2_M1,
          9521 => Opcode::PseudoVSOXSEG4EI16_V_MF2_M1_MASK,
          9522 => Opcode::PseudoVSOXSEG4EI16_V_MF2_M2,
          9523 => Opcode::PseudoVSOXSEG4EI16_V_MF2_M2_MASK,
          9524 => Opcode::PseudoVSOXSEG4EI16_V_MF2_MF2,
          9525 => Opcode::PseudoVSOXSEG4EI16_V_MF2_MF2_MASK,
          9526 => Opcode::PseudoVSOXSEG4EI16_V_MF2_MF4,
          9527 => Opcode::PseudoVSOXSEG4EI16_V_MF2_MF4_MASK,
          9528 => Opcode::PseudoVSOXSEG4EI16_V_MF4_M1,
          9529 => Opcode::PseudoVSOXSEG4EI16_V_MF4_M1_MASK,
          9530 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF2,
          9531 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF2_MASK,
          9532 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF4,
          9533 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF4_MASK,
          9534 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF8,
          9535 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF8_MASK,
          9536 => Opcode::PseudoVSOXSEG4EI32_V_M1_M1,
          9537 => Opcode::PseudoVSOXSEG4EI32_V_M1_M1_MASK,
          9538 => Opcode::PseudoVSOXSEG4EI32_V_M1_M2,
          9539 => Opcode::PseudoVSOXSEG4EI32_V_M1_M2_MASK,
          9540 => Opcode::PseudoVSOXSEG4EI32_V_M1_MF2,
          9541 => Opcode::PseudoVSOXSEG4EI32_V_M1_MF2_MASK,
          9542 => Opcode::PseudoVSOXSEG4EI32_V_M1_MF4,
          9543 => Opcode::PseudoVSOXSEG4EI32_V_M1_MF4_MASK,
          9544 => Opcode::PseudoVSOXSEG4EI32_V_M2_M1,
          9545 => Opcode::PseudoVSOXSEG4EI32_V_M2_M1_MASK,
          9546 => Opcode::PseudoVSOXSEG4EI32_V_M2_M2,
          9547 => Opcode::PseudoVSOXSEG4EI32_V_M2_M2_MASK,
          9548 => Opcode::PseudoVSOXSEG4EI32_V_M2_MF2,
          9549 => Opcode::PseudoVSOXSEG4EI32_V_M2_MF2_MASK,
          9550 => Opcode::PseudoVSOXSEG4EI32_V_M4_M1,
          9551 => Opcode::PseudoVSOXSEG4EI32_V_M4_M1_MASK,
          9552 => Opcode::PseudoVSOXSEG4EI32_V_M4_M2,
          9553 => Opcode::PseudoVSOXSEG4EI32_V_M4_M2_MASK,
          9554 => Opcode::PseudoVSOXSEG4EI32_V_M8_M2,
          9555 => Opcode::PseudoVSOXSEG4EI32_V_M8_M2_MASK,
          9556 => Opcode::PseudoVSOXSEG4EI32_V_MF2_M1,
          9557 => Opcode::PseudoVSOXSEG4EI32_V_MF2_M1_MASK,
          9558 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF2,
          9559 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF2_MASK,
          9560 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF4,
          9561 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF4_MASK,
          9562 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF8,
          9563 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF8_MASK,
          9564 => Opcode::PseudoVSOXSEG4EI64_V_M1_M1,
          9565 => Opcode::PseudoVSOXSEG4EI64_V_M1_M1_MASK,
          9566 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF2,
          9567 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF2_MASK,
          9568 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF4,
          9569 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF4_MASK,
          9570 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF8,
          9571 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF8_MASK,
          9572 => Opcode::PseudoVSOXSEG4EI64_V_M2_M1,
          9573 => Opcode::PseudoVSOXSEG4EI64_V_M2_M1_MASK,
          9574 => Opcode::PseudoVSOXSEG4EI64_V_M2_M2,
          9575 => Opcode::PseudoVSOXSEG4EI64_V_M2_M2_MASK,
          9576 => Opcode::PseudoVSOXSEG4EI64_V_M2_MF2,
          9577 => Opcode::PseudoVSOXSEG4EI64_V_M2_MF2_MASK,
          9578 => Opcode::PseudoVSOXSEG4EI64_V_M2_MF4,
          9579 => Opcode::PseudoVSOXSEG4EI64_V_M2_MF4_MASK,
          9580 => Opcode::PseudoVSOXSEG4EI64_V_M4_M1,
          9581 => Opcode::PseudoVSOXSEG4EI64_V_M4_M1_MASK,
          9582 => Opcode::PseudoVSOXSEG4EI64_V_M4_M2,
          9583 => Opcode::PseudoVSOXSEG4EI64_V_M4_M2_MASK,
          9584 => Opcode::PseudoVSOXSEG4EI64_V_M4_MF2,
          9585 => Opcode::PseudoVSOXSEG4EI64_V_M4_MF2_MASK,
          9586 => Opcode::PseudoVSOXSEG4EI64_V_M8_M1,
          9587 => Opcode::PseudoVSOXSEG4EI64_V_M8_M1_MASK,
          9588 => Opcode::PseudoVSOXSEG4EI64_V_M8_M2,
          9589 => Opcode::PseudoVSOXSEG4EI64_V_M8_M2_MASK,
          9590 => Opcode::PseudoVSOXSEG4EI8_V_M1_M1,
          9591 => Opcode::PseudoVSOXSEG4EI8_V_M1_M1_MASK,
          9592 => Opcode::PseudoVSOXSEG4EI8_V_M1_M2,
          9593 => Opcode::PseudoVSOXSEG4EI8_V_M1_M2_MASK,
          9594 => Opcode::PseudoVSOXSEG4EI8_V_M2_M2,
          9595 => Opcode::PseudoVSOXSEG4EI8_V_M2_M2_MASK,
          9596 => Opcode::PseudoVSOXSEG4EI8_V_MF2_M1,
          9597 => Opcode::PseudoVSOXSEG4EI8_V_MF2_M1_MASK,
          9598 => Opcode::PseudoVSOXSEG4EI8_V_MF2_M2,
          9599 => Opcode::PseudoVSOXSEG4EI8_V_MF2_M2_MASK,
          9600 => Opcode::PseudoVSOXSEG4EI8_V_MF2_MF2,
          9601 => Opcode::PseudoVSOXSEG4EI8_V_MF2_MF2_MASK,
          9602 => Opcode::PseudoVSOXSEG4EI8_V_MF4_M1,
          9603 => Opcode::PseudoVSOXSEG4EI8_V_MF4_M1_MASK,
          9604 => Opcode::PseudoVSOXSEG4EI8_V_MF4_M2,
          9605 => Opcode::PseudoVSOXSEG4EI8_V_MF4_M2_MASK,
          9606 => Opcode::PseudoVSOXSEG4EI8_V_MF4_MF2,
          9607 => Opcode::PseudoVSOXSEG4EI8_V_MF4_MF2_MASK,
          9608 => Opcode::PseudoVSOXSEG4EI8_V_MF4_MF4,
          9609 => Opcode::PseudoVSOXSEG4EI8_V_MF4_MF4_MASK,
          9610 => Opcode::PseudoVSOXSEG4EI8_V_MF8_M1,
          9611 => Opcode::PseudoVSOXSEG4EI8_V_MF8_M1_MASK,
          9612 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF2,
          9613 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF2_MASK,
          9614 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF4,
          9615 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF4_MASK,
          9616 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF8,
          9617 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF8_MASK,
          9618 => Opcode::PseudoVSOXSEG5EI16_V_M1_M1,
          9619 => Opcode::PseudoVSOXSEG5EI16_V_M1_M1_MASK,
          9620 => Opcode::PseudoVSOXSEG5EI16_V_M1_MF2,
          9621 => Opcode::PseudoVSOXSEG5EI16_V_M1_MF2_MASK,
          9622 => Opcode::PseudoVSOXSEG5EI16_V_M2_M1,
          9623 => Opcode::PseudoVSOXSEG5EI16_V_M2_M1_MASK,
          9624 => Opcode::PseudoVSOXSEG5EI16_V_MF2_M1,
          9625 => Opcode::PseudoVSOXSEG5EI16_V_MF2_M1_MASK,
          9626 => Opcode::PseudoVSOXSEG5EI16_V_MF2_MF2,
          9627 => Opcode::PseudoVSOXSEG5EI16_V_MF2_MF2_MASK,
          9628 => Opcode::PseudoVSOXSEG5EI16_V_MF2_MF4,
          9629 => Opcode::PseudoVSOXSEG5EI16_V_MF2_MF4_MASK,
          9630 => Opcode::PseudoVSOXSEG5EI16_V_MF4_M1,
          9631 => Opcode::PseudoVSOXSEG5EI16_V_MF4_M1_MASK,
          9632 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF2,
          9633 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF2_MASK,
          9634 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF4,
          9635 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF4_MASK,
          9636 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF8,
          9637 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF8_MASK,
          9638 => Opcode::PseudoVSOXSEG5EI32_V_M1_M1,
          9639 => Opcode::PseudoVSOXSEG5EI32_V_M1_M1_MASK,
          9640 => Opcode::PseudoVSOXSEG5EI32_V_M1_MF2,
          9641 => Opcode::PseudoVSOXSEG5EI32_V_M1_MF2_MASK,
          9642 => Opcode::PseudoVSOXSEG5EI32_V_M1_MF4,
          9643 => Opcode::PseudoVSOXSEG5EI32_V_M1_MF4_MASK,
          9644 => Opcode::PseudoVSOXSEG5EI32_V_M2_M1,
          9645 => Opcode::PseudoVSOXSEG5EI32_V_M2_M1_MASK,
          9646 => Opcode::PseudoVSOXSEG5EI32_V_M2_MF2,
          9647 => Opcode::PseudoVSOXSEG5EI32_V_M2_MF2_MASK,
          9648 => Opcode::PseudoVSOXSEG5EI32_V_M4_M1,
          9649 => Opcode::PseudoVSOXSEG5EI32_V_M4_M1_MASK,
          9650 => Opcode::PseudoVSOXSEG5EI32_V_MF2_M1,
          9651 => Opcode::PseudoVSOXSEG5EI32_V_MF2_M1_MASK,
          9652 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF2,
          9653 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF2_MASK,
          9654 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF4,
          9655 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF4_MASK,
          9656 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF8,
          9657 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF8_MASK,
          9658 => Opcode::PseudoVSOXSEG5EI64_V_M1_M1,
          9659 => Opcode::PseudoVSOXSEG5EI64_V_M1_M1_MASK,
          9660 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF2,
          9661 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF2_MASK,
          9662 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF4,
          9663 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF4_MASK,
          9664 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF8,
          9665 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF8_MASK,
          9666 => Opcode::PseudoVSOXSEG5EI64_V_M2_M1,
          9667 => Opcode::PseudoVSOXSEG5EI64_V_M2_M1_MASK,
          9668 => Opcode::PseudoVSOXSEG5EI64_V_M2_MF2,
          9669 => Opcode::PseudoVSOXSEG5EI64_V_M2_MF2_MASK,
          9670 => Opcode::PseudoVSOXSEG5EI64_V_M2_MF4,
          9671 => Opcode::PseudoVSOXSEG5EI64_V_M2_MF4_MASK,
          9672 => Opcode::PseudoVSOXSEG5EI64_V_M4_M1,
          9673 => Opcode::PseudoVSOXSEG5EI64_V_M4_M1_MASK,
          9674 => Opcode::PseudoVSOXSEG5EI64_V_M4_MF2,
          9675 => Opcode::PseudoVSOXSEG5EI64_V_M4_MF2_MASK,
          9676 => Opcode::PseudoVSOXSEG5EI64_V_M8_M1,
          9677 => Opcode::PseudoVSOXSEG5EI64_V_M8_M1_MASK,
          9678 => Opcode::PseudoVSOXSEG5EI8_V_M1_M1,
          9679 => Opcode::PseudoVSOXSEG5EI8_V_M1_M1_MASK,
          9680 => Opcode::PseudoVSOXSEG5EI8_V_MF2_M1,
          9681 => Opcode::PseudoVSOXSEG5EI8_V_MF2_M1_MASK,
          9682 => Opcode::PseudoVSOXSEG5EI8_V_MF2_MF2,
          9683 => Opcode::PseudoVSOXSEG5EI8_V_MF2_MF2_MASK,
          9684 => Opcode::PseudoVSOXSEG5EI8_V_MF4_M1,
          9685 => Opcode::PseudoVSOXSEG5EI8_V_MF4_M1_MASK,
          9686 => Opcode::PseudoVSOXSEG5EI8_V_MF4_MF2,
          9687 => Opcode::PseudoVSOXSEG5EI8_V_MF4_MF2_MASK,
          9688 => Opcode::PseudoVSOXSEG5EI8_V_MF4_MF4,
          9689 => Opcode::PseudoVSOXSEG5EI8_V_MF4_MF4_MASK,
          9690 => Opcode::PseudoVSOXSEG5EI8_V_MF8_M1,
          9691 => Opcode::PseudoVSOXSEG5EI8_V_MF8_M1_MASK,
          9692 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF2,
          9693 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF2_MASK,
          9694 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF4,
          9695 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF4_MASK,
          9696 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF8,
          9697 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF8_MASK,
          9698 => Opcode::PseudoVSOXSEG6EI16_V_M1_M1,
          9699 => Opcode::PseudoVSOXSEG6EI16_V_M1_M1_MASK,
          9700 => Opcode::PseudoVSOXSEG6EI16_V_M1_MF2,
          9701 => Opcode::PseudoVSOXSEG6EI16_V_M1_MF2_MASK,
          9702 => Opcode::PseudoVSOXSEG6EI16_V_M2_M1,
          9703 => Opcode::PseudoVSOXSEG6EI16_V_M2_M1_MASK,
          9704 => Opcode::PseudoVSOXSEG6EI16_V_MF2_M1,
          9705 => Opcode::PseudoVSOXSEG6EI16_V_MF2_M1_MASK,
          9706 => Opcode::PseudoVSOXSEG6EI16_V_MF2_MF2,
          9707 => Opcode::PseudoVSOXSEG6EI16_V_MF2_MF2_MASK,
          9708 => Opcode::PseudoVSOXSEG6EI16_V_MF2_MF4,
          9709 => Opcode::PseudoVSOXSEG6EI16_V_MF2_MF4_MASK,
          9710 => Opcode::PseudoVSOXSEG6EI16_V_MF4_M1,
          9711 => Opcode::PseudoVSOXSEG6EI16_V_MF4_M1_MASK,
          9712 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF2,
          9713 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF2_MASK,
          9714 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF4,
          9715 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF4_MASK,
          9716 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF8,
          9717 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF8_MASK,
          9718 => Opcode::PseudoVSOXSEG6EI32_V_M1_M1,
          9719 => Opcode::PseudoVSOXSEG6EI32_V_M1_M1_MASK,
          9720 => Opcode::PseudoVSOXSEG6EI32_V_M1_MF2,
          9721 => Opcode::PseudoVSOXSEG6EI32_V_M1_MF2_MASK,
          9722 => Opcode::PseudoVSOXSEG6EI32_V_M1_MF4,
          9723 => Opcode::PseudoVSOXSEG6EI32_V_M1_MF4_MASK,
          9724 => Opcode::PseudoVSOXSEG6EI32_V_M2_M1,
          9725 => Opcode::PseudoVSOXSEG6EI32_V_M2_M1_MASK,
          9726 => Opcode::PseudoVSOXSEG6EI32_V_M2_MF2,
          9727 => Opcode::PseudoVSOXSEG6EI32_V_M2_MF2_MASK,
          9728 => Opcode::PseudoVSOXSEG6EI32_V_M4_M1,
          9729 => Opcode::PseudoVSOXSEG6EI32_V_M4_M1_MASK,
          9730 => Opcode::PseudoVSOXSEG6EI32_V_MF2_M1,
          9731 => Opcode::PseudoVSOXSEG6EI32_V_MF2_M1_MASK,
          9732 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF2,
          9733 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF2_MASK,
          9734 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF4,
          9735 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF4_MASK,
          9736 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF8,
          9737 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF8_MASK,
          9738 => Opcode::PseudoVSOXSEG6EI64_V_M1_M1,
          9739 => Opcode::PseudoVSOXSEG6EI64_V_M1_M1_MASK,
          9740 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF2,
          9741 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF2_MASK,
          9742 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF4,
          9743 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF4_MASK,
          9744 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF8,
          9745 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF8_MASK,
          9746 => Opcode::PseudoVSOXSEG6EI64_V_M2_M1,
          9747 => Opcode::PseudoVSOXSEG6EI64_V_M2_M1_MASK,
          9748 => Opcode::PseudoVSOXSEG6EI64_V_M2_MF2,
          9749 => Opcode::PseudoVSOXSEG6EI64_V_M2_MF2_MASK,
          9750 => Opcode::PseudoVSOXSEG6EI64_V_M2_MF4,
          9751 => Opcode::PseudoVSOXSEG6EI64_V_M2_MF4_MASK,
          9752 => Opcode::PseudoVSOXSEG6EI64_V_M4_M1,
          9753 => Opcode::PseudoVSOXSEG6EI64_V_M4_M1_MASK,
          9754 => Opcode::PseudoVSOXSEG6EI64_V_M4_MF2,
          9755 => Opcode::PseudoVSOXSEG6EI64_V_M4_MF2_MASK,
          9756 => Opcode::PseudoVSOXSEG6EI64_V_M8_M1,
          9757 => Opcode::PseudoVSOXSEG6EI64_V_M8_M1_MASK,
          9758 => Opcode::PseudoVSOXSEG6EI8_V_M1_M1,
          9759 => Opcode::PseudoVSOXSEG6EI8_V_M1_M1_MASK,
          9760 => Opcode::PseudoVSOXSEG6EI8_V_MF2_M1,
          9761 => Opcode::PseudoVSOXSEG6EI8_V_MF2_M1_MASK,
          9762 => Opcode::PseudoVSOXSEG6EI8_V_MF2_MF2,
          9763 => Opcode::PseudoVSOXSEG6EI8_V_MF2_MF2_MASK,
          9764 => Opcode::PseudoVSOXSEG6EI8_V_MF4_M1,
          9765 => Opcode::PseudoVSOXSEG6EI8_V_MF4_M1_MASK,
          9766 => Opcode::PseudoVSOXSEG6EI8_V_MF4_MF2,
          9767 => Opcode::PseudoVSOXSEG6EI8_V_MF4_MF2_MASK,
          9768 => Opcode::PseudoVSOXSEG6EI8_V_MF4_MF4,
          9769 => Opcode::PseudoVSOXSEG6EI8_V_MF4_MF4_MASK,
          9770 => Opcode::PseudoVSOXSEG6EI8_V_MF8_M1,
          9771 => Opcode::PseudoVSOXSEG6EI8_V_MF8_M1_MASK,
          9772 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF2,
          9773 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF2_MASK,
          9774 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF4,
          9775 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF4_MASK,
          9776 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF8,
          9777 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF8_MASK,
          9778 => Opcode::PseudoVSOXSEG7EI16_V_M1_M1,
          9779 => Opcode::PseudoVSOXSEG7EI16_V_M1_M1_MASK,
          9780 => Opcode::PseudoVSOXSEG7EI16_V_M1_MF2,
          9781 => Opcode::PseudoVSOXSEG7EI16_V_M1_MF2_MASK,
          9782 => Opcode::PseudoVSOXSEG7EI16_V_M2_M1,
          9783 => Opcode::PseudoVSOXSEG7EI16_V_M2_M1_MASK,
          9784 => Opcode::PseudoVSOXSEG7EI16_V_MF2_M1,
          9785 => Opcode::PseudoVSOXSEG7EI16_V_MF2_M1_MASK,
          9786 => Opcode::PseudoVSOXSEG7EI16_V_MF2_MF2,
          9787 => Opcode::PseudoVSOXSEG7EI16_V_MF2_MF2_MASK,
          9788 => Opcode::PseudoVSOXSEG7EI16_V_MF2_MF4,
          9789 => Opcode::PseudoVSOXSEG7EI16_V_MF2_MF4_MASK,
          9790 => Opcode::PseudoVSOXSEG7EI16_V_MF4_M1,
          9791 => Opcode::PseudoVSOXSEG7EI16_V_MF4_M1_MASK,
          9792 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF2,
          9793 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF2_MASK,
          9794 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF4,
          9795 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF4_MASK,
          9796 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF8,
          9797 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF8_MASK,
          9798 => Opcode::PseudoVSOXSEG7EI32_V_M1_M1,
          9799 => Opcode::PseudoVSOXSEG7EI32_V_M1_M1_MASK,
          9800 => Opcode::PseudoVSOXSEG7EI32_V_M1_MF2,
          9801 => Opcode::PseudoVSOXSEG7EI32_V_M1_MF2_MASK,
          9802 => Opcode::PseudoVSOXSEG7EI32_V_M1_MF4,
          9803 => Opcode::PseudoVSOXSEG7EI32_V_M1_MF4_MASK,
          9804 => Opcode::PseudoVSOXSEG7EI32_V_M2_M1,
          9805 => Opcode::PseudoVSOXSEG7EI32_V_M2_M1_MASK,
          9806 => Opcode::PseudoVSOXSEG7EI32_V_M2_MF2,
          9807 => Opcode::PseudoVSOXSEG7EI32_V_M2_MF2_MASK,
          9808 => Opcode::PseudoVSOXSEG7EI32_V_M4_M1,
          9809 => Opcode::PseudoVSOXSEG7EI32_V_M4_M1_MASK,
          9810 => Opcode::PseudoVSOXSEG7EI32_V_MF2_M1,
          9811 => Opcode::PseudoVSOXSEG7EI32_V_MF2_M1_MASK,
          9812 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF2,
          9813 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF2_MASK,
          9814 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF4,
          9815 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF4_MASK,
          9816 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF8,
          9817 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF8_MASK,
          9818 => Opcode::PseudoVSOXSEG7EI64_V_M1_M1,
          9819 => Opcode::PseudoVSOXSEG7EI64_V_M1_M1_MASK,
          9820 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF2,
          9821 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF2_MASK,
          9822 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF4,
          9823 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF4_MASK,
          9824 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF8,
          9825 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF8_MASK,
          9826 => Opcode::PseudoVSOXSEG7EI64_V_M2_M1,
          9827 => Opcode::PseudoVSOXSEG7EI64_V_M2_M1_MASK,
          9828 => Opcode::PseudoVSOXSEG7EI64_V_M2_MF2,
          9829 => Opcode::PseudoVSOXSEG7EI64_V_M2_MF2_MASK,
          9830 => Opcode::PseudoVSOXSEG7EI64_V_M2_MF4,
          9831 => Opcode::PseudoVSOXSEG7EI64_V_M2_MF4_MASK,
          9832 => Opcode::PseudoVSOXSEG7EI64_V_M4_M1,
          9833 => Opcode::PseudoVSOXSEG7EI64_V_M4_M1_MASK,
          9834 => Opcode::PseudoVSOXSEG7EI64_V_M4_MF2,
          9835 => Opcode::PseudoVSOXSEG7EI64_V_M4_MF2_MASK,
          9836 => Opcode::PseudoVSOXSEG7EI64_V_M8_M1,
          9837 => Opcode::PseudoVSOXSEG7EI64_V_M8_M1_MASK,
          9838 => Opcode::PseudoVSOXSEG7EI8_V_M1_M1,
          9839 => Opcode::PseudoVSOXSEG7EI8_V_M1_M1_MASK,
          9840 => Opcode::PseudoVSOXSEG7EI8_V_MF2_M1,
          9841 => Opcode::PseudoVSOXSEG7EI8_V_MF2_M1_MASK,
          9842 => Opcode::PseudoVSOXSEG7EI8_V_MF2_MF2,
          9843 => Opcode::PseudoVSOXSEG7EI8_V_MF2_MF2_MASK,
          9844 => Opcode::PseudoVSOXSEG7EI8_V_MF4_M1,
          9845 => Opcode::PseudoVSOXSEG7EI8_V_MF4_M1_MASK,
          9846 => Opcode::PseudoVSOXSEG7EI8_V_MF4_MF2,
          9847 => Opcode::PseudoVSOXSEG7EI8_V_MF4_MF2_MASK,
          9848 => Opcode::PseudoVSOXSEG7EI8_V_MF4_MF4,
          9849 => Opcode::PseudoVSOXSEG7EI8_V_MF4_MF4_MASK,
          9850 => Opcode::PseudoVSOXSEG7EI8_V_MF8_M1,
          9851 => Opcode::PseudoVSOXSEG7EI8_V_MF8_M1_MASK,
          9852 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF2,
          9853 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF2_MASK,
          9854 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF4,
          9855 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF4_MASK,
          9856 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF8,
          9857 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF8_MASK,
          9858 => Opcode::PseudoVSOXSEG8EI16_V_M1_M1,
          9859 => Opcode::PseudoVSOXSEG8EI16_V_M1_M1_MASK,
          9860 => Opcode::PseudoVSOXSEG8EI16_V_M1_MF2,
          9861 => Opcode::PseudoVSOXSEG8EI16_V_M1_MF2_MASK,
          9862 => Opcode::PseudoVSOXSEG8EI16_V_M2_M1,
          9863 => Opcode::PseudoVSOXSEG8EI16_V_M2_M1_MASK,
          9864 => Opcode::PseudoVSOXSEG8EI16_V_MF2_M1,
          9865 => Opcode::PseudoVSOXSEG8EI16_V_MF2_M1_MASK,
          9866 => Opcode::PseudoVSOXSEG8EI16_V_MF2_MF2,
          9867 => Opcode::PseudoVSOXSEG8EI16_V_MF2_MF2_MASK,
          9868 => Opcode::PseudoVSOXSEG8EI16_V_MF2_MF4,
          9869 => Opcode::PseudoVSOXSEG8EI16_V_MF2_MF4_MASK,
          9870 => Opcode::PseudoVSOXSEG8EI16_V_MF4_M1,
          9871 => Opcode::PseudoVSOXSEG8EI16_V_MF4_M1_MASK,
          9872 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF2,
          9873 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF2_MASK,
          9874 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF4,
          9875 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF4_MASK,
          9876 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF8,
          9877 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF8_MASK,
          9878 => Opcode::PseudoVSOXSEG8EI32_V_M1_M1,
          9879 => Opcode::PseudoVSOXSEG8EI32_V_M1_M1_MASK,
          9880 => Opcode::PseudoVSOXSEG8EI32_V_M1_MF2,
          9881 => Opcode::PseudoVSOXSEG8EI32_V_M1_MF2_MASK,
          9882 => Opcode::PseudoVSOXSEG8EI32_V_M1_MF4,
          9883 => Opcode::PseudoVSOXSEG8EI32_V_M1_MF4_MASK,
          9884 => Opcode::PseudoVSOXSEG8EI32_V_M2_M1,
          9885 => Opcode::PseudoVSOXSEG8EI32_V_M2_M1_MASK,
          9886 => Opcode::PseudoVSOXSEG8EI32_V_M2_MF2,
          9887 => Opcode::PseudoVSOXSEG8EI32_V_M2_MF2_MASK,
          9888 => Opcode::PseudoVSOXSEG8EI32_V_M4_M1,
          9889 => Opcode::PseudoVSOXSEG8EI32_V_M4_M1_MASK,
          9890 => Opcode::PseudoVSOXSEG8EI32_V_MF2_M1,
          9891 => Opcode::PseudoVSOXSEG8EI32_V_MF2_M1_MASK,
          9892 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF2,
          9893 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF2_MASK,
          9894 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF4,
          9895 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF4_MASK,
          9896 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF8,
          9897 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF8_MASK,
          9898 => Opcode::PseudoVSOXSEG8EI64_V_M1_M1,
          9899 => Opcode::PseudoVSOXSEG8EI64_V_M1_M1_MASK,
          9900 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF2,
          9901 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF2_MASK,
          9902 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF4,
          9903 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF4_MASK,
          9904 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF8,
          9905 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF8_MASK,
          9906 => Opcode::PseudoVSOXSEG8EI64_V_M2_M1,
          9907 => Opcode::PseudoVSOXSEG8EI64_V_M2_M1_MASK,
          9908 => Opcode::PseudoVSOXSEG8EI64_V_M2_MF2,
          9909 => Opcode::PseudoVSOXSEG8EI64_V_M2_MF2_MASK,
          9910 => Opcode::PseudoVSOXSEG8EI64_V_M2_MF4,
          9911 => Opcode::PseudoVSOXSEG8EI64_V_M2_MF4_MASK,
          9912 => Opcode::PseudoVSOXSEG8EI64_V_M4_M1,
          9913 => Opcode::PseudoVSOXSEG8EI64_V_M4_M1_MASK,
          9914 => Opcode::PseudoVSOXSEG8EI64_V_M4_MF2,
          9915 => Opcode::PseudoVSOXSEG8EI64_V_M4_MF2_MASK,
          9916 => Opcode::PseudoVSOXSEG8EI64_V_M8_M1,
          9917 => Opcode::PseudoVSOXSEG8EI64_V_M8_M1_MASK,
          9918 => Opcode::PseudoVSOXSEG8EI8_V_M1_M1,
          9919 => Opcode::PseudoVSOXSEG8EI8_V_M1_M1_MASK,
          9920 => Opcode::PseudoVSOXSEG8EI8_V_MF2_M1,
          9921 => Opcode::PseudoVSOXSEG8EI8_V_MF2_M1_MASK,
          9922 => Opcode::PseudoVSOXSEG8EI8_V_MF2_MF2,
          9923 => Opcode::PseudoVSOXSEG8EI8_V_MF2_MF2_MASK,
          9924 => Opcode::PseudoVSOXSEG8EI8_V_MF4_M1,
          9925 => Opcode::PseudoVSOXSEG8EI8_V_MF4_M1_MASK,
          9926 => Opcode::PseudoVSOXSEG8EI8_V_MF4_MF2,
          9927 => Opcode::PseudoVSOXSEG8EI8_V_MF4_MF2_MASK,
          9928 => Opcode::PseudoVSOXSEG8EI8_V_MF4_MF4,
          9929 => Opcode::PseudoVSOXSEG8EI8_V_MF4_MF4_MASK,
          9930 => Opcode::PseudoVSOXSEG8EI8_V_MF8_M1,
          9931 => Opcode::PseudoVSOXSEG8EI8_V_MF8_M1_MASK,
          9932 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF2,
          9933 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF2_MASK,
          9934 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF4,
          9935 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF4_MASK,
          9936 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF8,
          9937 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF8_MASK,
          9938 => Opcode::PseudoVSPILL2_M1,
          9939 => Opcode::PseudoVSPILL2_M2,
          9940 => Opcode::PseudoVSPILL2_M4,
          9941 => Opcode::PseudoVSPILL2_MF2,
          9942 => Opcode::PseudoVSPILL2_MF4,
          9943 => Opcode::PseudoVSPILL2_MF8,
          9944 => Opcode::PseudoVSPILL3_M1,
          9945 => Opcode::PseudoVSPILL3_M2,
          9946 => Opcode::PseudoVSPILL3_MF2,
          9947 => Opcode::PseudoVSPILL3_MF4,
          9948 => Opcode::PseudoVSPILL3_MF8,
          9949 => Opcode::PseudoVSPILL4_M1,
          9950 => Opcode::PseudoVSPILL4_M2,
          9951 => Opcode::PseudoVSPILL4_MF2,
          9952 => Opcode::PseudoVSPILL4_MF4,
          9953 => Opcode::PseudoVSPILL4_MF8,
          9954 => Opcode::PseudoVSPILL5_M1,
          9955 => Opcode::PseudoVSPILL5_MF2,
          9956 => Opcode::PseudoVSPILL5_MF4,
          9957 => Opcode::PseudoVSPILL5_MF8,
          9958 => Opcode::PseudoVSPILL6_M1,
          9959 => Opcode::PseudoVSPILL6_MF2,
          9960 => Opcode::PseudoVSPILL6_MF4,
          9961 => Opcode::PseudoVSPILL6_MF8,
          9962 => Opcode::PseudoVSPILL7_M1,
          9963 => Opcode::PseudoVSPILL7_MF2,
          9964 => Opcode::PseudoVSPILL7_MF4,
          9965 => Opcode::PseudoVSPILL7_MF8,
          9966 => Opcode::PseudoVSPILL8_M1,
          9967 => Opcode::PseudoVSPILL8_MF2,
          9968 => Opcode::PseudoVSPILL8_MF4,
          9969 => Opcode::PseudoVSPILL8_MF8,
          9970 => Opcode::PseudoVSRA_VI_M1,
          9971 => Opcode::PseudoVSRA_VI_M1_MASK,
          9972 => Opcode::PseudoVSRA_VI_M2,
          9973 => Opcode::PseudoVSRA_VI_M2_MASK,
          9974 => Opcode::PseudoVSRA_VI_M4,
          9975 => Opcode::PseudoVSRA_VI_M4_MASK,
          9976 => Opcode::PseudoVSRA_VI_M8,
          9977 => Opcode::PseudoVSRA_VI_M8_MASK,
          9978 => Opcode::PseudoVSRA_VI_MF2,
          9979 => Opcode::PseudoVSRA_VI_MF2_MASK,
          9980 => Opcode::PseudoVSRA_VI_MF4,
          9981 => Opcode::PseudoVSRA_VI_MF4_MASK,
          9982 => Opcode::PseudoVSRA_VI_MF8,
          9983 => Opcode::PseudoVSRA_VI_MF8_MASK,
          9984 => Opcode::PseudoVSRA_VV_M1,
          9985 => Opcode::PseudoVSRA_VV_M1_MASK,
          9986 => Opcode::PseudoVSRA_VV_M2,
          9987 => Opcode::PseudoVSRA_VV_M2_MASK,
          9988 => Opcode::PseudoVSRA_VV_M4,
          9989 => Opcode::PseudoVSRA_VV_M4_MASK,
          9990 => Opcode::PseudoVSRA_VV_M8,
          9991 => Opcode::PseudoVSRA_VV_M8_MASK,
          9992 => Opcode::PseudoVSRA_VV_MF2,
          9993 => Opcode::PseudoVSRA_VV_MF2_MASK,
          9994 => Opcode::PseudoVSRA_VV_MF4,
          9995 => Opcode::PseudoVSRA_VV_MF4_MASK,
          9996 => Opcode::PseudoVSRA_VV_MF8,
          9997 => Opcode::PseudoVSRA_VV_MF8_MASK,
          9998 => Opcode::PseudoVSRA_VX_M1,
          9999 => Opcode::PseudoVSRA_VX_M1_MASK,
          10000 => Opcode::PseudoVSRA_VX_M2,
          10001 => Opcode::PseudoVSRA_VX_M2_MASK,
          10002 => Opcode::PseudoVSRA_VX_M4,
          10003 => Opcode::PseudoVSRA_VX_M4_MASK,
          10004 => Opcode::PseudoVSRA_VX_M8,
          10005 => Opcode::PseudoVSRA_VX_M8_MASK,
          10006 => Opcode::PseudoVSRA_VX_MF2,
          10007 => Opcode::PseudoVSRA_VX_MF2_MASK,
          10008 => Opcode::PseudoVSRA_VX_MF4,
          10009 => Opcode::PseudoVSRA_VX_MF4_MASK,
          10010 => Opcode::PseudoVSRA_VX_MF8,
          10011 => Opcode::PseudoVSRA_VX_MF8_MASK,
          10012 => Opcode::PseudoVSRL_VI_M1,
          10013 => Opcode::PseudoVSRL_VI_M1_MASK,
          10014 => Opcode::PseudoVSRL_VI_M2,
          10015 => Opcode::PseudoVSRL_VI_M2_MASK,
          10016 => Opcode::PseudoVSRL_VI_M4,
          10017 => Opcode::PseudoVSRL_VI_M4_MASK,
          10018 => Opcode::PseudoVSRL_VI_M8,
          10019 => Opcode::PseudoVSRL_VI_M8_MASK,
          10020 => Opcode::PseudoVSRL_VI_MF2,
          10021 => Opcode::PseudoVSRL_VI_MF2_MASK,
          10022 => Opcode::PseudoVSRL_VI_MF4,
          10023 => Opcode::PseudoVSRL_VI_MF4_MASK,
          10024 => Opcode::PseudoVSRL_VI_MF8,
          10025 => Opcode::PseudoVSRL_VI_MF8_MASK,
          10026 => Opcode::PseudoVSRL_VV_M1,
          10027 => Opcode::PseudoVSRL_VV_M1_MASK,
          10028 => Opcode::PseudoVSRL_VV_M2,
          10029 => Opcode::PseudoVSRL_VV_M2_MASK,
          10030 => Opcode::PseudoVSRL_VV_M4,
          10031 => Opcode::PseudoVSRL_VV_M4_MASK,
          10032 => Opcode::PseudoVSRL_VV_M8,
          10033 => Opcode::PseudoVSRL_VV_M8_MASK,
          10034 => Opcode::PseudoVSRL_VV_MF2,
          10035 => Opcode::PseudoVSRL_VV_MF2_MASK,
          10036 => Opcode::PseudoVSRL_VV_MF4,
          10037 => Opcode::PseudoVSRL_VV_MF4_MASK,
          10038 => Opcode::PseudoVSRL_VV_MF8,
          10039 => Opcode::PseudoVSRL_VV_MF8_MASK,
          10040 => Opcode::PseudoVSRL_VX_M1,
          10041 => Opcode::PseudoVSRL_VX_M1_MASK,
          10042 => Opcode::PseudoVSRL_VX_M2,
          10043 => Opcode::PseudoVSRL_VX_M2_MASK,
          10044 => Opcode::PseudoVSRL_VX_M4,
          10045 => Opcode::PseudoVSRL_VX_M4_MASK,
          10046 => Opcode::PseudoVSRL_VX_M8,
          10047 => Opcode::PseudoVSRL_VX_M8_MASK,
          10048 => Opcode::PseudoVSRL_VX_MF2,
          10049 => Opcode::PseudoVSRL_VX_MF2_MASK,
          10050 => Opcode::PseudoVSRL_VX_MF4,
          10051 => Opcode::PseudoVSRL_VX_MF4_MASK,
          10052 => Opcode::PseudoVSRL_VX_MF8,
          10053 => Opcode::PseudoVSRL_VX_MF8_MASK,
          10054 => Opcode::PseudoVSSE16_V_M1,
          10055 => Opcode::PseudoVSSE16_V_M1_MASK,
          10056 => Opcode::PseudoVSSE16_V_M2,
          10057 => Opcode::PseudoVSSE16_V_M2_MASK,
          10058 => Opcode::PseudoVSSE16_V_M4,
          10059 => Opcode::PseudoVSSE16_V_M4_MASK,
          10060 => Opcode::PseudoVSSE16_V_M8,
          10061 => Opcode::PseudoVSSE16_V_M8_MASK,
          10062 => Opcode::PseudoVSSE16_V_MF2,
          10063 => Opcode::PseudoVSSE16_V_MF2_MASK,
          10064 => Opcode::PseudoVSSE16_V_MF4,
          10065 => Opcode::PseudoVSSE16_V_MF4_MASK,
          10066 => Opcode::PseudoVSSE32_V_M1,
          10067 => Opcode::PseudoVSSE32_V_M1_MASK,
          10068 => Opcode::PseudoVSSE32_V_M2,
          10069 => Opcode::PseudoVSSE32_V_M2_MASK,
          10070 => Opcode::PseudoVSSE32_V_M4,
          10071 => Opcode::PseudoVSSE32_V_M4_MASK,
          10072 => Opcode::PseudoVSSE32_V_M8,
          10073 => Opcode::PseudoVSSE32_V_M8_MASK,
          10074 => Opcode::PseudoVSSE32_V_MF2,
          10075 => Opcode::PseudoVSSE32_V_MF2_MASK,
          10076 => Opcode::PseudoVSSE64_V_M1,
          10077 => Opcode::PseudoVSSE64_V_M1_MASK,
          10078 => Opcode::PseudoVSSE64_V_M2,
          10079 => Opcode::PseudoVSSE64_V_M2_MASK,
          10080 => Opcode::PseudoVSSE64_V_M4,
          10081 => Opcode::PseudoVSSE64_V_M4_MASK,
          10082 => Opcode::PseudoVSSE64_V_M8,
          10083 => Opcode::PseudoVSSE64_V_M8_MASK,
          10084 => Opcode::PseudoVSSE8_V_M1,
          10085 => Opcode::PseudoVSSE8_V_M1_MASK,
          10086 => Opcode::PseudoVSSE8_V_M2,
          10087 => Opcode::PseudoVSSE8_V_M2_MASK,
          10088 => Opcode::PseudoVSSE8_V_M4,
          10089 => Opcode::PseudoVSSE8_V_M4_MASK,
          10090 => Opcode::PseudoVSSE8_V_M8,
          10091 => Opcode::PseudoVSSE8_V_M8_MASK,
          10092 => Opcode::PseudoVSSE8_V_MF2,
          10093 => Opcode::PseudoVSSE8_V_MF2_MASK,
          10094 => Opcode::PseudoVSSE8_V_MF4,
          10095 => Opcode::PseudoVSSE8_V_MF4_MASK,
          10096 => Opcode::PseudoVSSE8_V_MF8,
          10097 => Opcode::PseudoVSSE8_V_MF8_MASK,
          10098 => Opcode::PseudoVSSEG2E16_V_M1,
          10099 => Opcode::PseudoVSSEG2E16_V_M1_MASK,
          10100 => Opcode::PseudoVSSEG2E16_V_M2,
          10101 => Opcode::PseudoVSSEG2E16_V_M2_MASK,
          10102 => Opcode::PseudoVSSEG2E16_V_M4,
          10103 => Opcode::PseudoVSSEG2E16_V_M4_MASK,
          10104 => Opcode::PseudoVSSEG2E16_V_MF2,
          10105 => Opcode::PseudoVSSEG2E16_V_MF2_MASK,
          10106 => Opcode::PseudoVSSEG2E16_V_MF4,
          10107 => Opcode::PseudoVSSEG2E16_V_MF4_MASK,
          10108 => Opcode::PseudoVSSEG2E32_V_M1,
          10109 => Opcode::PseudoVSSEG2E32_V_M1_MASK,
          10110 => Opcode::PseudoVSSEG2E32_V_M2,
          10111 => Opcode::PseudoVSSEG2E32_V_M2_MASK,
          10112 => Opcode::PseudoVSSEG2E32_V_M4,
          10113 => Opcode::PseudoVSSEG2E32_V_M4_MASK,
          10114 => Opcode::PseudoVSSEG2E32_V_MF2,
          10115 => Opcode::PseudoVSSEG2E32_V_MF2_MASK,
          10116 => Opcode::PseudoVSSEG2E64_V_M1,
          10117 => Opcode::PseudoVSSEG2E64_V_M1_MASK,
          10118 => Opcode::PseudoVSSEG2E64_V_M2,
          10119 => Opcode::PseudoVSSEG2E64_V_M2_MASK,
          10120 => Opcode::PseudoVSSEG2E64_V_M4,
          10121 => Opcode::PseudoVSSEG2E64_V_M4_MASK,
          10122 => Opcode::PseudoVSSEG2E8_V_M1,
          10123 => Opcode::PseudoVSSEG2E8_V_M1_MASK,
          10124 => Opcode::PseudoVSSEG2E8_V_M2,
          10125 => Opcode::PseudoVSSEG2E8_V_M2_MASK,
          10126 => Opcode::PseudoVSSEG2E8_V_M4,
          10127 => Opcode::PseudoVSSEG2E8_V_M4_MASK,
          10128 => Opcode::PseudoVSSEG2E8_V_MF2,
          10129 => Opcode::PseudoVSSEG2E8_V_MF2_MASK,
          10130 => Opcode::PseudoVSSEG2E8_V_MF4,
          10131 => Opcode::PseudoVSSEG2E8_V_MF4_MASK,
          10132 => Opcode::PseudoVSSEG2E8_V_MF8,
          10133 => Opcode::PseudoVSSEG2E8_V_MF8_MASK,
          10134 => Opcode::PseudoVSSEG3E16_V_M1,
          10135 => Opcode::PseudoVSSEG3E16_V_M1_MASK,
          10136 => Opcode::PseudoVSSEG3E16_V_M2,
          10137 => Opcode::PseudoVSSEG3E16_V_M2_MASK,
          10138 => Opcode::PseudoVSSEG3E16_V_MF2,
          10139 => Opcode::PseudoVSSEG3E16_V_MF2_MASK,
          10140 => Opcode::PseudoVSSEG3E16_V_MF4,
          10141 => Opcode::PseudoVSSEG3E16_V_MF4_MASK,
          10142 => Opcode::PseudoVSSEG3E32_V_M1,
          10143 => Opcode::PseudoVSSEG3E32_V_M1_MASK,
          10144 => Opcode::PseudoVSSEG3E32_V_M2,
          10145 => Opcode::PseudoVSSEG3E32_V_M2_MASK,
          10146 => Opcode::PseudoVSSEG3E32_V_MF2,
          10147 => Opcode::PseudoVSSEG3E32_V_MF2_MASK,
          10148 => Opcode::PseudoVSSEG3E64_V_M1,
          10149 => Opcode::PseudoVSSEG3E64_V_M1_MASK,
          10150 => Opcode::PseudoVSSEG3E64_V_M2,
          10151 => Opcode::PseudoVSSEG3E64_V_M2_MASK,
          10152 => Opcode::PseudoVSSEG3E8_V_M1,
          10153 => Opcode::PseudoVSSEG3E8_V_M1_MASK,
          10154 => Opcode::PseudoVSSEG3E8_V_M2,
          10155 => Opcode::PseudoVSSEG3E8_V_M2_MASK,
          10156 => Opcode::PseudoVSSEG3E8_V_MF2,
          10157 => Opcode::PseudoVSSEG3E8_V_MF2_MASK,
          10158 => Opcode::PseudoVSSEG3E8_V_MF4,
          10159 => Opcode::PseudoVSSEG3E8_V_MF4_MASK,
          10160 => Opcode::PseudoVSSEG3E8_V_MF8,
          10161 => Opcode::PseudoVSSEG3E8_V_MF8_MASK,
          10162 => Opcode::PseudoVSSEG4E16_V_M1,
          10163 => Opcode::PseudoVSSEG4E16_V_M1_MASK,
          10164 => Opcode::PseudoVSSEG4E16_V_M2,
          10165 => Opcode::PseudoVSSEG4E16_V_M2_MASK,
          10166 => Opcode::PseudoVSSEG4E16_V_MF2,
          10167 => Opcode::PseudoVSSEG4E16_V_MF2_MASK,
          10168 => Opcode::PseudoVSSEG4E16_V_MF4,
          10169 => Opcode::PseudoVSSEG4E16_V_MF4_MASK,
          10170 => Opcode::PseudoVSSEG4E32_V_M1,
          10171 => Opcode::PseudoVSSEG4E32_V_M1_MASK,
          10172 => Opcode::PseudoVSSEG4E32_V_M2,
          10173 => Opcode::PseudoVSSEG4E32_V_M2_MASK,
          10174 => Opcode::PseudoVSSEG4E32_V_MF2,
          10175 => Opcode::PseudoVSSEG4E32_V_MF2_MASK,
          10176 => Opcode::PseudoVSSEG4E64_V_M1,
          10177 => Opcode::PseudoVSSEG4E64_V_M1_MASK,
          10178 => Opcode::PseudoVSSEG4E64_V_M2,
          10179 => Opcode::PseudoVSSEG4E64_V_M2_MASK,
          10180 => Opcode::PseudoVSSEG4E8_V_M1,
          10181 => Opcode::PseudoVSSEG4E8_V_M1_MASK,
          10182 => Opcode::PseudoVSSEG4E8_V_M2,
          10183 => Opcode::PseudoVSSEG4E8_V_M2_MASK,
          10184 => Opcode::PseudoVSSEG4E8_V_MF2,
          10185 => Opcode::PseudoVSSEG4E8_V_MF2_MASK,
          10186 => Opcode::PseudoVSSEG4E8_V_MF4,
          10187 => Opcode::PseudoVSSEG4E8_V_MF4_MASK,
          10188 => Opcode::PseudoVSSEG4E8_V_MF8,
          10189 => Opcode::PseudoVSSEG4E8_V_MF8_MASK,
          10190 => Opcode::PseudoVSSEG5E16_V_M1,
          10191 => Opcode::PseudoVSSEG5E16_V_M1_MASK,
          10192 => Opcode::PseudoVSSEG5E16_V_MF2,
          10193 => Opcode::PseudoVSSEG5E16_V_MF2_MASK,
          10194 => Opcode::PseudoVSSEG5E16_V_MF4,
          10195 => Opcode::PseudoVSSEG5E16_V_MF4_MASK,
          10196 => Opcode::PseudoVSSEG5E32_V_M1,
          10197 => Opcode::PseudoVSSEG5E32_V_M1_MASK,
          10198 => Opcode::PseudoVSSEG5E32_V_MF2,
          10199 => Opcode::PseudoVSSEG5E32_V_MF2_MASK,
          10200 => Opcode::PseudoVSSEG5E64_V_M1,
          10201 => Opcode::PseudoVSSEG5E64_V_M1_MASK,
          10202 => Opcode::PseudoVSSEG5E8_V_M1,
          10203 => Opcode::PseudoVSSEG5E8_V_M1_MASK,
          10204 => Opcode::PseudoVSSEG5E8_V_MF2,
          10205 => Opcode::PseudoVSSEG5E8_V_MF2_MASK,
          10206 => Opcode::PseudoVSSEG5E8_V_MF4,
          10207 => Opcode::PseudoVSSEG5E8_V_MF4_MASK,
          10208 => Opcode::PseudoVSSEG5E8_V_MF8,
          10209 => Opcode::PseudoVSSEG5E8_V_MF8_MASK,
          10210 => Opcode::PseudoVSSEG6E16_V_M1,
          10211 => Opcode::PseudoVSSEG6E16_V_M1_MASK,
          10212 => Opcode::PseudoVSSEG6E16_V_MF2,
          10213 => Opcode::PseudoVSSEG6E16_V_MF2_MASK,
          10214 => Opcode::PseudoVSSEG6E16_V_MF4,
          10215 => Opcode::PseudoVSSEG6E16_V_MF4_MASK,
          10216 => Opcode::PseudoVSSEG6E32_V_M1,
          10217 => Opcode::PseudoVSSEG6E32_V_M1_MASK,
          10218 => Opcode::PseudoVSSEG6E32_V_MF2,
          10219 => Opcode::PseudoVSSEG6E32_V_MF2_MASK,
          10220 => Opcode::PseudoVSSEG6E64_V_M1,
          10221 => Opcode::PseudoVSSEG6E64_V_M1_MASK,
          10222 => Opcode::PseudoVSSEG6E8_V_M1,
          10223 => Opcode::PseudoVSSEG6E8_V_M1_MASK,
          10224 => Opcode::PseudoVSSEG6E8_V_MF2,
          10225 => Opcode::PseudoVSSEG6E8_V_MF2_MASK,
          10226 => Opcode::PseudoVSSEG6E8_V_MF4,
          10227 => Opcode::PseudoVSSEG6E8_V_MF4_MASK,
          10228 => Opcode::PseudoVSSEG6E8_V_MF8,
          10229 => Opcode::PseudoVSSEG6E8_V_MF8_MASK,
          10230 => Opcode::PseudoVSSEG7E16_V_M1,
          10231 => Opcode::PseudoVSSEG7E16_V_M1_MASK,
          10232 => Opcode::PseudoVSSEG7E16_V_MF2,
          10233 => Opcode::PseudoVSSEG7E16_V_MF2_MASK,
          10234 => Opcode::PseudoVSSEG7E16_V_MF4,
          10235 => Opcode::PseudoVSSEG7E16_V_MF4_MASK,
          10236 => Opcode::PseudoVSSEG7E32_V_M1,
          10237 => Opcode::PseudoVSSEG7E32_V_M1_MASK,
          10238 => Opcode::PseudoVSSEG7E32_V_MF2,
          10239 => Opcode::PseudoVSSEG7E32_V_MF2_MASK,
          10240 => Opcode::PseudoVSSEG7E64_V_M1,
          10241 => Opcode::PseudoVSSEG7E64_V_M1_MASK,
          10242 => Opcode::PseudoVSSEG7E8_V_M1,
          10243 => Opcode::PseudoVSSEG7E8_V_M1_MASK,
          10244 => Opcode::PseudoVSSEG7E8_V_MF2,
          10245 => Opcode::PseudoVSSEG7E8_V_MF2_MASK,
          10246 => Opcode::PseudoVSSEG7E8_V_MF4,
          10247 => Opcode::PseudoVSSEG7E8_V_MF4_MASK,
          10248 => Opcode::PseudoVSSEG7E8_V_MF8,
          10249 => Opcode::PseudoVSSEG7E8_V_MF8_MASK,
          10250 => Opcode::PseudoVSSEG8E16_V_M1,
          10251 => Opcode::PseudoVSSEG8E16_V_M1_MASK,
          10252 => Opcode::PseudoVSSEG8E16_V_MF2,
          10253 => Opcode::PseudoVSSEG8E16_V_MF2_MASK,
          10254 => Opcode::PseudoVSSEG8E16_V_MF4,
          10255 => Opcode::PseudoVSSEG8E16_V_MF4_MASK,
          10256 => Opcode::PseudoVSSEG8E32_V_M1,
          10257 => Opcode::PseudoVSSEG8E32_V_M1_MASK,
          10258 => Opcode::PseudoVSSEG8E32_V_MF2,
          10259 => Opcode::PseudoVSSEG8E32_V_MF2_MASK,
          10260 => Opcode::PseudoVSSEG8E64_V_M1,
          10261 => Opcode::PseudoVSSEG8E64_V_M1_MASK,
          10262 => Opcode::PseudoVSSEG8E8_V_M1,
          10263 => Opcode::PseudoVSSEG8E8_V_M1_MASK,
          10264 => Opcode::PseudoVSSEG8E8_V_MF2,
          10265 => Opcode::PseudoVSSEG8E8_V_MF2_MASK,
          10266 => Opcode::PseudoVSSEG8E8_V_MF4,
          10267 => Opcode::PseudoVSSEG8E8_V_MF4_MASK,
          10268 => Opcode::PseudoVSSEG8E8_V_MF8,
          10269 => Opcode::PseudoVSSEG8E8_V_MF8_MASK,
          10270 => Opcode::PseudoVSSRA_VI_M1,
          10271 => Opcode::PseudoVSSRA_VI_M1_MASK,
          10272 => Opcode::PseudoVSSRA_VI_M2,
          10273 => Opcode::PseudoVSSRA_VI_M2_MASK,
          10274 => Opcode::PseudoVSSRA_VI_M4,
          10275 => Opcode::PseudoVSSRA_VI_M4_MASK,
          10276 => Opcode::PseudoVSSRA_VI_M8,
          10277 => Opcode::PseudoVSSRA_VI_M8_MASK,
          10278 => Opcode::PseudoVSSRA_VI_MF2,
          10279 => Opcode::PseudoVSSRA_VI_MF2_MASK,
          10280 => Opcode::PseudoVSSRA_VI_MF4,
          10281 => Opcode::PseudoVSSRA_VI_MF4_MASK,
          10282 => Opcode::PseudoVSSRA_VI_MF8,
          10283 => Opcode::PseudoVSSRA_VI_MF8_MASK,
          10284 => Opcode::PseudoVSSRA_VV_M1,
          10285 => Opcode::PseudoVSSRA_VV_M1_MASK,
          10286 => Opcode::PseudoVSSRA_VV_M2,
          10287 => Opcode::PseudoVSSRA_VV_M2_MASK,
          10288 => Opcode::PseudoVSSRA_VV_M4,
          10289 => Opcode::PseudoVSSRA_VV_M4_MASK,
          10290 => Opcode::PseudoVSSRA_VV_M8,
          10291 => Opcode::PseudoVSSRA_VV_M8_MASK,
          10292 => Opcode::PseudoVSSRA_VV_MF2,
          10293 => Opcode::PseudoVSSRA_VV_MF2_MASK,
          10294 => Opcode::PseudoVSSRA_VV_MF4,
          10295 => Opcode::PseudoVSSRA_VV_MF4_MASK,
          10296 => Opcode::PseudoVSSRA_VV_MF8,
          10297 => Opcode::PseudoVSSRA_VV_MF8_MASK,
          10298 => Opcode::PseudoVSSRA_VX_M1,
          10299 => Opcode::PseudoVSSRA_VX_M1_MASK,
          10300 => Opcode::PseudoVSSRA_VX_M2,
          10301 => Opcode::PseudoVSSRA_VX_M2_MASK,
          10302 => Opcode::PseudoVSSRA_VX_M4,
          10303 => Opcode::PseudoVSSRA_VX_M4_MASK,
          10304 => Opcode::PseudoVSSRA_VX_M8,
          10305 => Opcode::PseudoVSSRA_VX_M8_MASK,
          10306 => Opcode::PseudoVSSRA_VX_MF2,
          10307 => Opcode::PseudoVSSRA_VX_MF2_MASK,
          10308 => Opcode::PseudoVSSRA_VX_MF4,
          10309 => Opcode::PseudoVSSRA_VX_MF4_MASK,
          10310 => Opcode::PseudoVSSRA_VX_MF8,
          10311 => Opcode::PseudoVSSRA_VX_MF8_MASK,
          10312 => Opcode::PseudoVSSRL_VI_M1,
          10313 => Opcode::PseudoVSSRL_VI_M1_MASK,
          10314 => Opcode::PseudoVSSRL_VI_M2,
          10315 => Opcode::PseudoVSSRL_VI_M2_MASK,
          10316 => Opcode::PseudoVSSRL_VI_M4,
          10317 => Opcode::PseudoVSSRL_VI_M4_MASK,
          10318 => Opcode::PseudoVSSRL_VI_M8,
          10319 => Opcode::PseudoVSSRL_VI_M8_MASK,
          10320 => Opcode::PseudoVSSRL_VI_MF2,
          10321 => Opcode::PseudoVSSRL_VI_MF2_MASK,
          10322 => Opcode::PseudoVSSRL_VI_MF4,
          10323 => Opcode::PseudoVSSRL_VI_MF4_MASK,
          10324 => Opcode::PseudoVSSRL_VI_MF8,
          10325 => Opcode::PseudoVSSRL_VI_MF8_MASK,
          10326 => Opcode::PseudoVSSRL_VV_M1,
          10327 => Opcode::PseudoVSSRL_VV_M1_MASK,
          10328 => Opcode::PseudoVSSRL_VV_M2,
          10329 => Opcode::PseudoVSSRL_VV_M2_MASK,
          10330 => Opcode::PseudoVSSRL_VV_M4,
          10331 => Opcode::PseudoVSSRL_VV_M4_MASK,
          10332 => Opcode::PseudoVSSRL_VV_M8,
          10333 => Opcode::PseudoVSSRL_VV_M8_MASK,
          10334 => Opcode::PseudoVSSRL_VV_MF2,
          10335 => Opcode::PseudoVSSRL_VV_MF2_MASK,
          10336 => Opcode::PseudoVSSRL_VV_MF4,
          10337 => Opcode::PseudoVSSRL_VV_MF4_MASK,
          10338 => Opcode::PseudoVSSRL_VV_MF8,
          10339 => Opcode::PseudoVSSRL_VV_MF8_MASK,
          10340 => Opcode::PseudoVSSRL_VX_M1,
          10341 => Opcode::PseudoVSSRL_VX_M1_MASK,
          10342 => Opcode::PseudoVSSRL_VX_M2,
          10343 => Opcode::PseudoVSSRL_VX_M2_MASK,
          10344 => Opcode::PseudoVSSRL_VX_M4,
          10345 => Opcode::PseudoVSSRL_VX_M4_MASK,
          10346 => Opcode::PseudoVSSRL_VX_M8,
          10347 => Opcode::PseudoVSSRL_VX_M8_MASK,
          10348 => Opcode::PseudoVSSRL_VX_MF2,
          10349 => Opcode::PseudoVSSRL_VX_MF2_MASK,
          10350 => Opcode::PseudoVSSRL_VX_MF4,
          10351 => Opcode::PseudoVSSRL_VX_MF4_MASK,
          10352 => Opcode::PseudoVSSRL_VX_MF8,
          10353 => Opcode::PseudoVSSRL_VX_MF8_MASK,
          10354 => Opcode::PseudoVSSSEG2E16_V_M1,
          10355 => Opcode::PseudoVSSSEG2E16_V_M1_MASK,
          10356 => Opcode::PseudoVSSSEG2E16_V_M2,
          10357 => Opcode::PseudoVSSSEG2E16_V_M2_MASK,
          10358 => Opcode::PseudoVSSSEG2E16_V_M4,
          10359 => Opcode::PseudoVSSSEG2E16_V_M4_MASK,
          10360 => Opcode::PseudoVSSSEG2E16_V_MF2,
          10361 => Opcode::PseudoVSSSEG2E16_V_MF2_MASK,
          10362 => Opcode::PseudoVSSSEG2E16_V_MF4,
          10363 => Opcode::PseudoVSSSEG2E16_V_MF4_MASK,
          10364 => Opcode::PseudoVSSSEG2E32_V_M1,
          10365 => Opcode::PseudoVSSSEG2E32_V_M1_MASK,
          10366 => Opcode::PseudoVSSSEG2E32_V_M2,
          10367 => Opcode::PseudoVSSSEG2E32_V_M2_MASK,
          10368 => Opcode::PseudoVSSSEG2E32_V_M4,
          10369 => Opcode::PseudoVSSSEG2E32_V_M4_MASK,
          10370 => Opcode::PseudoVSSSEG2E32_V_MF2,
          10371 => Opcode::PseudoVSSSEG2E32_V_MF2_MASK,
          10372 => Opcode::PseudoVSSSEG2E64_V_M1,
          10373 => Opcode::PseudoVSSSEG2E64_V_M1_MASK,
          10374 => Opcode::PseudoVSSSEG2E64_V_M2,
          10375 => Opcode::PseudoVSSSEG2E64_V_M2_MASK,
          10376 => Opcode::PseudoVSSSEG2E64_V_M4,
          10377 => Opcode::PseudoVSSSEG2E64_V_M4_MASK,
          10378 => Opcode::PseudoVSSSEG2E8_V_M1,
          10379 => Opcode::PseudoVSSSEG2E8_V_M1_MASK,
          10380 => Opcode::PseudoVSSSEG2E8_V_M2,
          10381 => Opcode::PseudoVSSSEG2E8_V_M2_MASK,
          10382 => Opcode::PseudoVSSSEG2E8_V_M4,
          10383 => Opcode::PseudoVSSSEG2E8_V_M4_MASK,
          10384 => Opcode::PseudoVSSSEG2E8_V_MF2,
          10385 => Opcode::PseudoVSSSEG2E8_V_MF2_MASK,
          10386 => Opcode::PseudoVSSSEG2E8_V_MF4,
          10387 => Opcode::PseudoVSSSEG2E8_V_MF4_MASK,
          10388 => Opcode::PseudoVSSSEG2E8_V_MF8,
          10389 => Opcode::PseudoVSSSEG2E8_V_MF8_MASK,
          10390 => Opcode::PseudoVSSSEG3E16_V_M1,
          10391 => Opcode::PseudoVSSSEG3E16_V_M1_MASK,
          10392 => Opcode::PseudoVSSSEG3E16_V_M2,
          10393 => Opcode::PseudoVSSSEG3E16_V_M2_MASK,
          10394 => Opcode::PseudoVSSSEG3E16_V_MF2,
          10395 => Opcode::PseudoVSSSEG3E16_V_MF2_MASK,
          10396 => Opcode::PseudoVSSSEG3E16_V_MF4,
          10397 => Opcode::PseudoVSSSEG3E16_V_MF4_MASK,
          10398 => Opcode::PseudoVSSSEG3E32_V_M1,
          10399 => Opcode::PseudoVSSSEG3E32_V_M1_MASK,
          10400 => Opcode::PseudoVSSSEG3E32_V_M2,
          10401 => Opcode::PseudoVSSSEG3E32_V_M2_MASK,
          10402 => Opcode::PseudoVSSSEG3E32_V_MF2,
          10403 => Opcode::PseudoVSSSEG3E32_V_MF2_MASK,
          10404 => Opcode::PseudoVSSSEG3E64_V_M1,
          10405 => Opcode::PseudoVSSSEG3E64_V_M1_MASK,
          10406 => Opcode::PseudoVSSSEG3E64_V_M2,
          10407 => Opcode::PseudoVSSSEG3E64_V_M2_MASK,
          10408 => Opcode::PseudoVSSSEG3E8_V_M1,
          10409 => Opcode::PseudoVSSSEG3E8_V_M1_MASK,
          10410 => Opcode::PseudoVSSSEG3E8_V_M2,
          10411 => Opcode::PseudoVSSSEG3E8_V_M2_MASK,
          10412 => Opcode::PseudoVSSSEG3E8_V_MF2,
          10413 => Opcode::PseudoVSSSEG3E8_V_MF2_MASK,
          10414 => Opcode::PseudoVSSSEG3E8_V_MF4,
          10415 => Opcode::PseudoVSSSEG3E8_V_MF4_MASK,
          10416 => Opcode::PseudoVSSSEG3E8_V_MF8,
          10417 => Opcode::PseudoVSSSEG3E8_V_MF8_MASK,
          10418 => Opcode::PseudoVSSSEG4E16_V_M1,
          10419 => Opcode::PseudoVSSSEG4E16_V_M1_MASK,
          10420 => Opcode::PseudoVSSSEG4E16_V_M2,
          10421 => Opcode::PseudoVSSSEG4E16_V_M2_MASK,
          10422 => Opcode::PseudoVSSSEG4E16_V_MF2,
          10423 => Opcode::PseudoVSSSEG4E16_V_MF2_MASK,
          10424 => Opcode::PseudoVSSSEG4E16_V_MF4,
          10425 => Opcode::PseudoVSSSEG4E16_V_MF4_MASK,
          10426 => Opcode::PseudoVSSSEG4E32_V_M1,
          10427 => Opcode::PseudoVSSSEG4E32_V_M1_MASK,
          10428 => Opcode::PseudoVSSSEG4E32_V_M2,
          10429 => Opcode::PseudoVSSSEG4E32_V_M2_MASK,
          10430 => Opcode::PseudoVSSSEG4E32_V_MF2,
          10431 => Opcode::PseudoVSSSEG4E32_V_MF2_MASK,
          10432 => Opcode::PseudoVSSSEG4E64_V_M1,
          10433 => Opcode::PseudoVSSSEG4E64_V_M1_MASK,
          10434 => Opcode::PseudoVSSSEG4E64_V_M2,
          10435 => Opcode::PseudoVSSSEG4E64_V_M2_MASK,
          10436 => Opcode::PseudoVSSSEG4E8_V_M1,
          10437 => Opcode::PseudoVSSSEG4E8_V_M1_MASK,
          10438 => Opcode::PseudoVSSSEG4E8_V_M2,
          10439 => Opcode::PseudoVSSSEG4E8_V_M2_MASK,
          10440 => Opcode::PseudoVSSSEG4E8_V_MF2,
          10441 => Opcode::PseudoVSSSEG4E8_V_MF2_MASK,
          10442 => Opcode::PseudoVSSSEG4E8_V_MF4,
          10443 => Opcode::PseudoVSSSEG4E8_V_MF4_MASK,
          10444 => Opcode::PseudoVSSSEG4E8_V_MF8,
          10445 => Opcode::PseudoVSSSEG4E8_V_MF8_MASK,
          10446 => Opcode::PseudoVSSSEG5E16_V_M1,
          10447 => Opcode::PseudoVSSSEG5E16_V_M1_MASK,
          10448 => Opcode::PseudoVSSSEG5E16_V_MF2,
          10449 => Opcode::PseudoVSSSEG5E16_V_MF2_MASK,
          10450 => Opcode::PseudoVSSSEG5E16_V_MF4,
          10451 => Opcode::PseudoVSSSEG5E16_V_MF4_MASK,
          10452 => Opcode::PseudoVSSSEG5E32_V_M1,
          10453 => Opcode::PseudoVSSSEG5E32_V_M1_MASK,
          10454 => Opcode::PseudoVSSSEG5E32_V_MF2,
          10455 => Opcode::PseudoVSSSEG5E32_V_MF2_MASK,
          10456 => Opcode::PseudoVSSSEG5E64_V_M1,
          10457 => Opcode::PseudoVSSSEG5E64_V_M1_MASK,
          10458 => Opcode::PseudoVSSSEG5E8_V_M1,
          10459 => Opcode::PseudoVSSSEG5E8_V_M1_MASK,
          10460 => Opcode::PseudoVSSSEG5E8_V_MF2,
          10461 => Opcode::PseudoVSSSEG5E8_V_MF2_MASK,
          10462 => Opcode::PseudoVSSSEG5E8_V_MF4,
          10463 => Opcode::PseudoVSSSEG5E8_V_MF4_MASK,
          10464 => Opcode::PseudoVSSSEG5E8_V_MF8,
          10465 => Opcode::PseudoVSSSEG5E8_V_MF8_MASK,
          10466 => Opcode::PseudoVSSSEG6E16_V_M1,
          10467 => Opcode::PseudoVSSSEG6E16_V_M1_MASK,
          10468 => Opcode::PseudoVSSSEG6E16_V_MF2,
          10469 => Opcode::PseudoVSSSEG6E16_V_MF2_MASK,
          10470 => Opcode::PseudoVSSSEG6E16_V_MF4,
          10471 => Opcode::PseudoVSSSEG6E16_V_MF4_MASK,
          10472 => Opcode::PseudoVSSSEG6E32_V_M1,
          10473 => Opcode::PseudoVSSSEG6E32_V_M1_MASK,
          10474 => Opcode::PseudoVSSSEG6E32_V_MF2,
          10475 => Opcode::PseudoVSSSEG6E32_V_MF2_MASK,
          10476 => Opcode::PseudoVSSSEG6E64_V_M1,
          10477 => Opcode::PseudoVSSSEG6E64_V_M1_MASK,
          10478 => Opcode::PseudoVSSSEG6E8_V_M1,
          10479 => Opcode::PseudoVSSSEG6E8_V_M1_MASK,
          10480 => Opcode::PseudoVSSSEG6E8_V_MF2,
          10481 => Opcode::PseudoVSSSEG6E8_V_MF2_MASK,
          10482 => Opcode::PseudoVSSSEG6E8_V_MF4,
          10483 => Opcode::PseudoVSSSEG6E8_V_MF4_MASK,
          10484 => Opcode::PseudoVSSSEG6E8_V_MF8,
          10485 => Opcode::PseudoVSSSEG6E8_V_MF8_MASK,
          10486 => Opcode::PseudoVSSSEG7E16_V_M1,
          10487 => Opcode::PseudoVSSSEG7E16_V_M1_MASK,
          10488 => Opcode::PseudoVSSSEG7E16_V_MF2,
          10489 => Opcode::PseudoVSSSEG7E16_V_MF2_MASK,
          10490 => Opcode::PseudoVSSSEG7E16_V_MF4,
          10491 => Opcode::PseudoVSSSEG7E16_V_MF4_MASK,
          10492 => Opcode::PseudoVSSSEG7E32_V_M1,
          10493 => Opcode::PseudoVSSSEG7E32_V_M1_MASK,
          10494 => Opcode::PseudoVSSSEG7E32_V_MF2,
          10495 => Opcode::PseudoVSSSEG7E32_V_MF2_MASK,
          10496 => Opcode::PseudoVSSSEG7E64_V_M1,
          10497 => Opcode::PseudoVSSSEG7E64_V_M1_MASK,
          10498 => Opcode::PseudoVSSSEG7E8_V_M1,
          10499 => Opcode::PseudoVSSSEG7E8_V_M1_MASK,
          10500 => Opcode::PseudoVSSSEG7E8_V_MF2,
          10501 => Opcode::PseudoVSSSEG7E8_V_MF2_MASK,
          10502 => Opcode::PseudoVSSSEG7E8_V_MF4,
          10503 => Opcode::PseudoVSSSEG7E8_V_MF4_MASK,
          10504 => Opcode::PseudoVSSSEG7E8_V_MF8,
          10505 => Opcode::PseudoVSSSEG7E8_V_MF8_MASK,
          10506 => Opcode::PseudoVSSSEG8E16_V_M1,
          10507 => Opcode::PseudoVSSSEG8E16_V_M1_MASK,
          10508 => Opcode::PseudoVSSSEG8E16_V_MF2,
          10509 => Opcode::PseudoVSSSEG8E16_V_MF2_MASK,
          10510 => Opcode::PseudoVSSSEG8E16_V_MF4,
          10511 => Opcode::PseudoVSSSEG8E16_V_MF4_MASK,
          10512 => Opcode::PseudoVSSSEG8E32_V_M1,
          10513 => Opcode::PseudoVSSSEG8E32_V_M1_MASK,
          10514 => Opcode::PseudoVSSSEG8E32_V_MF2,
          10515 => Opcode::PseudoVSSSEG8E32_V_MF2_MASK,
          10516 => Opcode::PseudoVSSSEG8E64_V_M1,
          10517 => Opcode::PseudoVSSSEG8E64_V_M1_MASK,
          10518 => Opcode::PseudoVSSSEG8E8_V_M1,
          10519 => Opcode::PseudoVSSSEG8E8_V_M1_MASK,
          10520 => Opcode::PseudoVSSSEG8E8_V_MF2,
          10521 => Opcode::PseudoVSSSEG8E8_V_MF2_MASK,
          10522 => Opcode::PseudoVSSSEG8E8_V_MF4,
          10523 => Opcode::PseudoVSSSEG8E8_V_MF4_MASK,
          10524 => Opcode::PseudoVSSSEG8E8_V_MF8,
          10525 => Opcode::PseudoVSSSEG8E8_V_MF8_MASK,
          10526 => Opcode::PseudoVSSUBU_VV_M1,
          10527 => Opcode::PseudoVSSUBU_VV_M1_MASK,
          10528 => Opcode::PseudoVSSUBU_VV_M2,
          10529 => Opcode::PseudoVSSUBU_VV_M2_MASK,
          10530 => Opcode::PseudoVSSUBU_VV_M4,
          10531 => Opcode::PseudoVSSUBU_VV_M4_MASK,
          10532 => Opcode::PseudoVSSUBU_VV_M8,
          10533 => Opcode::PseudoVSSUBU_VV_M8_MASK,
          10534 => Opcode::PseudoVSSUBU_VV_MF2,
          10535 => Opcode::PseudoVSSUBU_VV_MF2_MASK,
          10536 => Opcode::PseudoVSSUBU_VV_MF4,
          10537 => Opcode::PseudoVSSUBU_VV_MF4_MASK,
          10538 => Opcode::PseudoVSSUBU_VV_MF8,
          10539 => Opcode::PseudoVSSUBU_VV_MF8_MASK,
          10540 => Opcode::PseudoVSSUBU_VX_M1,
          10541 => Opcode::PseudoVSSUBU_VX_M1_MASK,
          10542 => Opcode::PseudoVSSUBU_VX_M2,
          10543 => Opcode::PseudoVSSUBU_VX_M2_MASK,
          10544 => Opcode::PseudoVSSUBU_VX_M4,
          10545 => Opcode::PseudoVSSUBU_VX_M4_MASK,
          10546 => Opcode::PseudoVSSUBU_VX_M8,
          10547 => Opcode::PseudoVSSUBU_VX_M8_MASK,
          10548 => Opcode::PseudoVSSUBU_VX_MF2,
          10549 => Opcode::PseudoVSSUBU_VX_MF2_MASK,
          10550 => Opcode::PseudoVSSUBU_VX_MF4,
          10551 => Opcode::PseudoVSSUBU_VX_MF4_MASK,
          10552 => Opcode::PseudoVSSUBU_VX_MF8,
          10553 => Opcode::PseudoVSSUBU_VX_MF8_MASK,
          10554 => Opcode::PseudoVSSUB_VV_M1,
          10555 => Opcode::PseudoVSSUB_VV_M1_MASK,
          10556 => Opcode::PseudoVSSUB_VV_M2,
          10557 => Opcode::PseudoVSSUB_VV_M2_MASK,
          10558 => Opcode::PseudoVSSUB_VV_M4,
          10559 => Opcode::PseudoVSSUB_VV_M4_MASK,
          10560 => Opcode::PseudoVSSUB_VV_M8,
          10561 => Opcode::PseudoVSSUB_VV_M8_MASK,
          10562 => Opcode::PseudoVSSUB_VV_MF2,
          10563 => Opcode::PseudoVSSUB_VV_MF2_MASK,
          10564 => Opcode::PseudoVSSUB_VV_MF4,
          10565 => Opcode::PseudoVSSUB_VV_MF4_MASK,
          10566 => Opcode::PseudoVSSUB_VV_MF8,
          10567 => Opcode::PseudoVSSUB_VV_MF8_MASK,
          10568 => Opcode::PseudoVSSUB_VX_M1,
          10569 => Opcode::PseudoVSSUB_VX_M1_MASK,
          10570 => Opcode::PseudoVSSUB_VX_M2,
          10571 => Opcode::PseudoVSSUB_VX_M2_MASK,
          10572 => Opcode::PseudoVSSUB_VX_M4,
          10573 => Opcode::PseudoVSSUB_VX_M4_MASK,
          10574 => Opcode::PseudoVSSUB_VX_M8,
          10575 => Opcode::PseudoVSSUB_VX_M8_MASK,
          10576 => Opcode::PseudoVSSUB_VX_MF2,
          10577 => Opcode::PseudoVSSUB_VX_MF2_MASK,
          10578 => Opcode::PseudoVSSUB_VX_MF4,
          10579 => Opcode::PseudoVSSUB_VX_MF4_MASK,
          10580 => Opcode::PseudoVSSUB_VX_MF8,
          10581 => Opcode::PseudoVSSUB_VX_MF8_MASK,
          10582 => Opcode::PseudoVSUB_VV_M1,
          10583 => Opcode::PseudoVSUB_VV_M1_MASK,
          10584 => Opcode::PseudoVSUB_VV_M2,
          10585 => Opcode::PseudoVSUB_VV_M2_MASK,
          10586 => Opcode::PseudoVSUB_VV_M4,
          10587 => Opcode::PseudoVSUB_VV_M4_MASK,
          10588 => Opcode::PseudoVSUB_VV_M8,
          10589 => Opcode::PseudoVSUB_VV_M8_MASK,
          10590 => Opcode::PseudoVSUB_VV_MF2,
          10591 => Opcode::PseudoVSUB_VV_MF2_MASK,
          10592 => Opcode::PseudoVSUB_VV_MF4,
          10593 => Opcode::PseudoVSUB_VV_MF4_MASK,
          10594 => Opcode::PseudoVSUB_VV_MF8,
          10595 => Opcode::PseudoVSUB_VV_MF8_MASK,
          10596 => Opcode::PseudoVSUB_VX_M1,
          10597 => Opcode::PseudoVSUB_VX_M1_MASK,
          10598 => Opcode::PseudoVSUB_VX_M2,
          10599 => Opcode::PseudoVSUB_VX_M2_MASK,
          10600 => Opcode::PseudoVSUB_VX_M4,
          10601 => Opcode::PseudoVSUB_VX_M4_MASK,
          10602 => Opcode::PseudoVSUB_VX_M8,
          10603 => Opcode::PseudoVSUB_VX_M8_MASK,
          10604 => Opcode::PseudoVSUB_VX_MF2,
          10605 => Opcode::PseudoVSUB_VX_MF2_MASK,
          10606 => Opcode::PseudoVSUB_VX_MF4,
          10607 => Opcode::PseudoVSUB_VX_MF4_MASK,
          10608 => Opcode::PseudoVSUB_VX_MF8,
          10609 => Opcode::PseudoVSUB_VX_MF8_MASK,
          10610 => Opcode::PseudoVSUXEI16_V_M1_M1,
          10611 => Opcode::PseudoVSUXEI16_V_M1_M1_MASK,
          10612 => Opcode::PseudoVSUXEI16_V_M1_M2,
          10613 => Opcode::PseudoVSUXEI16_V_M1_M2_MASK,
          10614 => Opcode::PseudoVSUXEI16_V_M1_M4,
          10615 => Opcode::PseudoVSUXEI16_V_M1_M4_MASK,
          10616 => Opcode::PseudoVSUXEI16_V_M1_MF2,
          10617 => Opcode::PseudoVSUXEI16_V_M1_MF2_MASK,
          10618 => Opcode::PseudoVSUXEI16_V_M2_M1,
          10619 => Opcode::PseudoVSUXEI16_V_M2_M1_MASK,
          10620 => Opcode::PseudoVSUXEI16_V_M2_M2,
          10621 => Opcode::PseudoVSUXEI16_V_M2_M2_MASK,
          10622 => Opcode::PseudoVSUXEI16_V_M2_M4,
          10623 => Opcode::PseudoVSUXEI16_V_M2_M4_MASK,
          10624 => Opcode::PseudoVSUXEI16_V_M2_M8,
          10625 => Opcode::PseudoVSUXEI16_V_M2_M8_MASK,
          10626 => Opcode::PseudoVSUXEI16_V_M4_M2,
          10627 => Opcode::PseudoVSUXEI16_V_M4_M2_MASK,
          10628 => Opcode::PseudoVSUXEI16_V_M4_M4,
          10629 => Opcode::PseudoVSUXEI16_V_M4_M4_MASK,
          10630 => Opcode::PseudoVSUXEI16_V_M4_M8,
          10631 => Opcode::PseudoVSUXEI16_V_M4_M8_MASK,
          10632 => Opcode::PseudoVSUXEI16_V_M8_M4,
          10633 => Opcode::PseudoVSUXEI16_V_M8_M4_MASK,
          10634 => Opcode::PseudoVSUXEI16_V_M8_M8,
          10635 => Opcode::PseudoVSUXEI16_V_M8_M8_MASK,
          10636 => Opcode::PseudoVSUXEI16_V_MF2_M1,
          10637 => Opcode::PseudoVSUXEI16_V_MF2_M1_MASK,
          10638 => Opcode::PseudoVSUXEI16_V_MF2_M2,
          10639 => Opcode::PseudoVSUXEI16_V_MF2_M2_MASK,
          10640 => Opcode::PseudoVSUXEI16_V_MF2_MF2,
          10641 => Opcode::PseudoVSUXEI16_V_MF2_MF2_MASK,
          10642 => Opcode::PseudoVSUXEI16_V_MF2_MF4,
          10643 => Opcode::PseudoVSUXEI16_V_MF2_MF4_MASK,
          10644 => Opcode::PseudoVSUXEI16_V_MF4_M1,
          10645 => Opcode::PseudoVSUXEI16_V_MF4_M1_MASK,
          10646 => Opcode::PseudoVSUXEI16_V_MF4_MF2,
          10647 => Opcode::PseudoVSUXEI16_V_MF4_MF2_MASK,
          10648 => Opcode::PseudoVSUXEI16_V_MF4_MF4,
          10649 => Opcode::PseudoVSUXEI16_V_MF4_MF4_MASK,
          10650 => Opcode::PseudoVSUXEI16_V_MF4_MF8,
          10651 => Opcode::PseudoVSUXEI16_V_MF4_MF8_MASK,
          10652 => Opcode::PseudoVSUXEI32_V_M1_M1,
          10653 => Opcode::PseudoVSUXEI32_V_M1_M1_MASK,
          10654 => Opcode::PseudoVSUXEI32_V_M1_M2,
          10655 => Opcode::PseudoVSUXEI32_V_M1_M2_MASK,
          10656 => Opcode::PseudoVSUXEI32_V_M1_MF2,
          10657 => Opcode::PseudoVSUXEI32_V_M1_MF2_MASK,
          10658 => Opcode::PseudoVSUXEI32_V_M1_MF4,
          10659 => Opcode::PseudoVSUXEI32_V_M1_MF4_MASK,
          10660 => Opcode::PseudoVSUXEI32_V_M2_M1,
          10661 => Opcode::PseudoVSUXEI32_V_M2_M1_MASK,
          10662 => Opcode::PseudoVSUXEI32_V_M2_M2,
          10663 => Opcode::PseudoVSUXEI32_V_M2_M2_MASK,
          10664 => Opcode::PseudoVSUXEI32_V_M2_M4,
          10665 => Opcode::PseudoVSUXEI32_V_M2_M4_MASK,
          10666 => Opcode::PseudoVSUXEI32_V_M2_MF2,
          10667 => Opcode::PseudoVSUXEI32_V_M2_MF2_MASK,
          10668 => Opcode::PseudoVSUXEI32_V_M4_M1,
          10669 => Opcode::PseudoVSUXEI32_V_M4_M1_MASK,
          10670 => Opcode::PseudoVSUXEI32_V_M4_M2,
          10671 => Opcode::PseudoVSUXEI32_V_M4_M2_MASK,
          10672 => Opcode::PseudoVSUXEI32_V_M4_M4,
          10673 => Opcode::PseudoVSUXEI32_V_M4_M4_MASK,
          10674 => Opcode::PseudoVSUXEI32_V_M4_M8,
          10675 => Opcode::PseudoVSUXEI32_V_M4_M8_MASK,
          10676 => Opcode::PseudoVSUXEI32_V_M8_M2,
          10677 => Opcode::PseudoVSUXEI32_V_M8_M2_MASK,
          10678 => Opcode::PseudoVSUXEI32_V_M8_M4,
          10679 => Opcode::PseudoVSUXEI32_V_M8_M4_MASK,
          10680 => Opcode::PseudoVSUXEI32_V_M8_M8,
          10681 => Opcode::PseudoVSUXEI32_V_M8_M8_MASK,
          10682 => Opcode::PseudoVSUXEI32_V_MF2_M1,
          10683 => Opcode::PseudoVSUXEI32_V_MF2_M1_MASK,
          10684 => Opcode::PseudoVSUXEI32_V_MF2_MF2,
          10685 => Opcode::PseudoVSUXEI32_V_MF2_MF2_MASK,
          10686 => Opcode::PseudoVSUXEI32_V_MF2_MF4,
          10687 => Opcode::PseudoVSUXEI32_V_MF2_MF4_MASK,
          10688 => Opcode::PseudoVSUXEI32_V_MF2_MF8,
          10689 => Opcode::PseudoVSUXEI32_V_MF2_MF8_MASK,
          10690 => Opcode::PseudoVSUXEI64_V_M1_M1,
          10691 => Opcode::PseudoVSUXEI64_V_M1_M1_MASK,
          10692 => Opcode::PseudoVSUXEI64_V_M1_MF2,
          10693 => Opcode::PseudoVSUXEI64_V_M1_MF2_MASK,
          10694 => Opcode::PseudoVSUXEI64_V_M1_MF4,
          10695 => Opcode::PseudoVSUXEI64_V_M1_MF4_MASK,
          10696 => Opcode::PseudoVSUXEI64_V_M1_MF8,
          10697 => Opcode::PseudoVSUXEI64_V_M1_MF8_MASK,
          10698 => Opcode::PseudoVSUXEI64_V_M2_M1,
          10699 => Opcode::PseudoVSUXEI64_V_M2_M1_MASK,
          10700 => Opcode::PseudoVSUXEI64_V_M2_M2,
          10701 => Opcode::PseudoVSUXEI64_V_M2_M2_MASK,
          10702 => Opcode::PseudoVSUXEI64_V_M2_MF2,
          10703 => Opcode::PseudoVSUXEI64_V_M2_MF2_MASK,
          10704 => Opcode::PseudoVSUXEI64_V_M2_MF4,
          10705 => Opcode::PseudoVSUXEI64_V_M2_MF4_MASK,
          10706 => Opcode::PseudoVSUXEI64_V_M4_M1,
          10707 => Opcode::PseudoVSUXEI64_V_M4_M1_MASK,
          10708 => Opcode::PseudoVSUXEI64_V_M4_M2,
          10709 => Opcode::PseudoVSUXEI64_V_M4_M2_MASK,
          10710 => Opcode::PseudoVSUXEI64_V_M4_M4,
          10711 => Opcode::PseudoVSUXEI64_V_M4_M4_MASK,
          10712 => Opcode::PseudoVSUXEI64_V_M4_MF2,
          10713 => Opcode::PseudoVSUXEI64_V_M4_MF2_MASK,
          10714 => Opcode::PseudoVSUXEI64_V_M8_M1,
          10715 => Opcode::PseudoVSUXEI64_V_M8_M1_MASK,
          10716 => Opcode::PseudoVSUXEI64_V_M8_M2,
          10717 => Opcode::PseudoVSUXEI64_V_M8_M2_MASK,
          10718 => Opcode::PseudoVSUXEI64_V_M8_M4,
          10719 => Opcode::PseudoVSUXEI64_V_M8_M4_MASK,
          10720 => Opcode::PseudoVSUXEI64_V_M8_M8,
          10721 => Opcode::PseudoVSUXEI64_V_M8_M8_MASK,
          10722 => Opcode::PseudoVSUXEI8_V_M1_M1,
          10723 => Opcode::PseudoVSUXEI8_V_M1_M1_MASK,
          10724 => Opcode::PseudoVSUXEI8_V_M1_M2,
          10725 => Opcode::PseudoVSUXEI8_V_M1_M2_MASK,
          10726 => Opcode::PseudoVSUXEI8_V_M1_M4,
          10727 => Opcode::PseudoVSUXEI8_V_M1_M4_MASK,
          10728 => Opcode::PseudoVSUXEI8_V_M1_M8,
          10729 => Opcode::PseudoVSUXEI8_V_M1_M8_MASK,
          10730 => Opcode::PseudoVSUXEI8_V_M2_M2,
          10731 => Opcode::PseudoVSUXEI8_V_M2_M2_MASK,
          10732 => Opcode::PseudoVSUXEI8_V_M2_M4,
          10733 => Opcode::PseudoVSUXEI8_V_M2_M4_MASK,
          10734 => Opcode::PseudoVSUXEI8_V_M2_M8,
          10735 => Opcode::PseudoVSUXEI8_V_M2_M8_MASK,
          10736 => Opcode::PseudoVSUXEI8_V_M4_M4,
          10737 => Opcode::PseudoVSUXEI8_V_M4_M4_MASK,
          10738 => Opcode::PseudoVSUXEI8_V_M4_M8,
          10739 => Opcode::PseudoVSUXEI8_V_M4_M8_MASK,
          10740 => Opcode::PseudoVSUXEI8_V_M8_M8,
          10741 => Opcode::PseudoVSUXEI8_V_M8_M8_MASK,
          10742 => Opcode::PseudoVSUXEI8_V_MF2_M1,
          10743 => Opcode::PseudoVSUXEI8_V_MF2_M1_MASK,
          10744 => Opcode::PseudoVSUXEI8_V_MF2_M2,
          10745 => Opcode::PseudoVSUXEI8_V_MF2_M2_MASK,
          10746 => Opcode::PseudoVSUXEI8_V_MF2_M4,
          10747 => Opcode::PseudoVSUXEI8_V_MF2_M4_MASK,
          10748 => Opcode::PseudoVSUXEI8_V_MF2_MF2,
          10749 => Opcode::PseudoVSUXEI8_V_MF2_MF2_MASK,
          10750 => Opcode::PseudoVSUXEI8_V_MF4_M1,
          10751 => Opcode::PseudoVSUXEI8_V_MF4_M1_MASK,
          10752 => Opcode::PseudoVSUXEI8_V_MF4_M2,
          10753 => Opcode::PseudoVSUXEI8_V_MF4_M2_MASK,
          10754 => Opcode::PseudoVSUXEI8_V_MF4_MF2,
          10755 => Opcode::PseudoVSUXEI8_V_MF4_MF2_MASK,
          10756 => Opcode::PseudoVSUXEI8_V_MF4_MF4,
          10757 => Opcode::PseudoVSUXEI8_V_MF4_MF4_MASK,
          10758 => Opcode::PseudoVSUXEI8_V_MF8_M1,
          10759 => Opcode::PseudoVSUXEI8_V_MF8_M1_MASK,
          10760 => Opcode::PseudoVSUXEI8_V_MF8_MF2,
          10761 => Opcode::PseudoVSUXEI8_V_MF8_MF2_MASK,
          10762 => Opcode::PseudoVSUXEI8_V_MF8_MF4,
          10763 => Opcode::PseudoVSUXEI8_V_MF8_MF4_MASK,
          10764 => Opcode::PseudoVSUXEI8_V_MF8_MF8,
          10765 => Opcode::PseudoVSUXEI8_V_MF8_MF8_MASK,
          10766 => Opcode::PseudoVSUXSEG2EI16_V_M1_M1,
          10767 => Opcode::PseudoVSUXSEG2EI16_V_M1_M1_MASK,
          10768 => Opcode::PseudoVSUXSEG2EI16_V_M1_M2,
          10769 => Opcode::PseudoVSUXSEG2EI16_V_M1_M2_MASK,
          10770 => Opcode::PseudoVSUXSEG2EI16_V_M1_M4,
          10771 => Opcode::PseudoVSUXSEG2EI16_V_M1_M4_MASK,
          10772 => Opcode::PseudoVSUXSEG2EI16_V_M1_MF2,
          10773 => Opcode::PseudoVSUXSEG2EI16_V_M1_MF2_MASK,
          10774 => Opcode::PseudoVSUXSEG2EI16_V_M2_M1,
          10775 => Opcode::PseudoVSUXSEG2EI16_V_M2_M1_MASK,
          10776 => Opcode::PseudoVSUXSEG2EI16_V_M2_M2,
          10777 => Opcode::PseudoVSUXSEG2EI16_V_M2_M2_MASK,
          10778 => Opcode::PseudoVSUXSEG2EI16_V_M2_M4,
          10779 => Opcode::PseudoVSUXSEG2EI16_V_M2_M4_MASK,
          10780 => Opcode::PseudoVSUXSEG2EI16_V_M4_M2,
          10781 => Opcode::PseudoVSUXSEG2EI16_V_M4_M2_MASK,
          10782 => Opcode::PseudoVSUXSEG2EI16_V_M4_M4,
          10783 => Opcode::PseudoVSUXSEG2EI16_V_M4_M4_MASK,
          10784 => Opcode::PseudoVSUXSEG2EI16_V_M8_M4,
          10785 => Opcode::PseudoVSUXSEG2EI16_V_M8_M4_MASK,
          10786 => Opcode::PseudoVSUXSEG2EI16_V_MF2_M1,
          10787 => Opcode::PseudoVSUXSEG2EI16_V_MF2_M1_MASK,
          10788 => Opcode::PseudoVSUXSEG2EI16_V_MF2_M2,
          10789 => Opcode::PseudoVSUXSEG2EI16_V_MF2_M2_MASK,
          10790 => Opcode::PseudoVSUXSEG2EI16_V_MF2_MF2,
          10791 => Opcode::PseudoVSUXSEG2EI16_V_MF2_MF2_MASK,
          10792 => Opcode::PseudoVSUXSEG2EI16_V_MF2_MF4,
          10793 => Opcode::PseudoVSUXSEG2EI16_V_MF2_MF4_MASK,
          10794 => Opcode::PseudoVSUXSEG2EI16_V_MF4_M1,
          10795 => Opcode::PseudoVSUXSEG2EI16_V_MF4_M1_MASK,
          10796 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF2,
          10797 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF2_MASK,
          10798 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF4,
          10799 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF4_MASK,
          10800 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF8,
          10801 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF8_MASK,
          10802 => Opcode::PseudoVSUXSEG2EI32_V_M1_M1,
          10803 => Opcode::PseudoVSUXSEG2EI32_V_M1_M1_MASK,
          10804 => Opcode::PseudoVSUXSEG2EI32_V_M1_M2,
          10805 => Opcode::PseudoVSUXSEG2EI32_V_M1_M2_MASK,
          10806 => Opcode::PseudoVSUXSEG2EI32_V_M1_MF2,
          10807 => Opcode::PseudoVSUXSEG2EI32_V_M1_MF2_MASK,
          10808 => Opcode::PseudoVSUXSEG2EI32_V_M1_MF4,
          10809 => Opcode::PseudoVSUXSEG2EI32_V_M1_MF4_MASK,
          10810 => Opcode::PseudoVSUXSEG2EI32_V_M2_M1,
          10811 => Opcode::PseudoVSUXSEG2EI32_V_M2_M1_MASK,
          10812 => Opcode::PseudoVSUXSEG2EI32_V_M2_M2,
          10813 => Opcode::PseudoVSUXSEG2EI32_V_M2_M2_MASK,
          10814 => Opcode::PseudoVSUXSEG2EI32_V_M2_M4,
          10815 => Opcode::PseudoVSUXSEG2EI32_V_M2_M4_MASK,
          10816 => Opcode::PseudoVSUXSEG2EI32_V_M2_MF2,
          10817 => Opcode::PseudoVSUXSEG2EI32_V_M2_MF2_MASK,
          10818 => Opcode::PseudoVSUXSEG2EI32_V_M4_M1,
          10819 => Opcode::PseudoVSUXSEG2EI32_V_M4_M1_MASK,
          10820 => Opcode::PseudoVSUXSEG2EI32_V_M4_M2,
          10821 => Opcode::PseudoVSUXSEG2EI32_V_M4_M2_MASK,
          10822 => Opcode::PseudoVSUXSEG2EI32_V_M4_M4,
          10823 => Opcode::PseudoVSUXSEG2EI32_V_M4_M4_MASK,
          10824 => Opcode::PseudoVSUXSEG2EI32_V_M8_M2,
          10825 => Opcode::PseudoVSUXSEG2EI32_V_M8_M2_MASK,
          10826 => Opcode::PseudoVSUXSEG2EI32_V_M8_M4,
          10827 => Opcode::PseudoVSUXSEG2EI32_V_M8_M4_MASK,
          10828 => Opcode::PseudoVSUXSEG2EI32_V_MF2_M1,
          10829 => Opcode::PseudoVSUXSEG2EI32_V_MF2_M1_MASK,
          10830 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF2,
          10831 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF2_MASK,
          10832 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF4,
          10833 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF4_MASK,
          10834 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF8,
          10835 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF8_MASK,
          10836 => Opcode::PseudoVSUXSEG2EI64_V_M1_M1,
          10837 => Opcode::PseudoVSUXSEG2EI64_V_M1_M1_MASK,
          10838 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF2,
          10839 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF2_MASK,
          10840 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF4,
          10841 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF4_MASK,
          10842 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF8,
          10843 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF8_MASK,
          10844 => Opcode::PseudoVSUXSEG2EI64_V_M2_M1,
          10845 => Opcode::PseudoVSUXSEG2EI64_V_M2_M1_MASK,
          10846 => Opcode::PseudoVSUXSEG2EI64_V_M2_M2,
          10847 => Opcode::PseudoVSUXSEG2EI64_V_M2_M2_MASK,
          10848 => Opcode::PseudoVSUXSEG2EI64_V_M2_MF2,
          10849 => Opcode::PseudoVSUXSEG2EI64_V_M2_MF2_MASK,
          10850 => Opcode::PseudoVSUXSEG2EI64_V_M2_MF4,
          10851 => Opcode::PseudoVSUXSEG2EI64_V_M2_MF4_MASK,
          10852 => Opcode::PseudoVSUXSEG2EI64_V_M4_M1,
          10853 => Opcode::PseudoVSUXSEG2EI64_V_M4_M1_MASK,
          10854 => Opcode::PseudoVSUXSEG2EI64_V_M4_M2,
          10855 => Opcode::PseudoVSUXSEG2EI64_V_M4_M2_MASK,
          10856 => Opcode::PseudoVSUXSEG2EI64_V_M4_M4,
          10857 => Opcode::PseudoVSUXSEG2EI64_V_M4_M4_MASK,
          10858 => Opcode::PseudoVSUXSEG2EI64_V_M4_MF2,
          10859 => Opcode::PseudoVSUXSEG2EI64_V_M4_MF2_MASK,
          10860 => Opcode::PseudoVSUXSEG2EI64_V_M8_M1,
          10861 => Opcode::PseudoVSUXSEG2EI64_V_M8_M1_MASK,
          10862 => Opcode::PseudoVSUXSEG2EI64_V_M8_M2,
          10863 => Opcode::PseudoVSUXSEG2EI64_V_M8_M2_MASK,
          10864 => Opcode::PseudoVSUXSEG2EI64_V_M8_M4,
          10865 => Opcode::PseudoVSUXSEG2EI64_V_M8_M4_MASK,
          10866 => Opcode::PseudoVSUXSEG2EI8_V_M1_M1,
          10867 => Opcode::PseudoVSUXSEG2EI8_V_M1_M1_MASK,
          10868 => Opcode::PseudoVSUXSEG2EI8_V_M1_M2,
          10869 => Opcode::PseudoVSUXSEG2EI8_V_M1_M2_MASK,
          10870 => Opcode::PseudoVSUXSEG2EI8_V_M1_M4,
          10871 => Opcode::PseudoVSUXSEG2EI8_V_M1_M4_MASK,
          10872 => Opcode::PseudoVSUXSEG2EI8_V_M2_M2,
          10873 => Opcode::PseudoVSUXSEG2EI8_V_M2_M2_MASK,
          10874 => Opcode::PseudoVSUXSEG2EI8_V_M2_M4,
          10875 => Opcode::PseudoVSUXSEG2EI8_V_M2_M4_MASK,
          10876 => Opcode::PseudoVSUXSEG2EI8_V_M4_M4,
          10877 => Opcode::PseudoVSUXSEG2EI8_V_M4_M4_MASK,
          10878 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M1,
          10879 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M1_MASK,
          10880 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M2,
          10881 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M2_MASK,
          10882 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M4,
          10883 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M4_MASK,
          10884 => Opcode::PseudoVSUXSEG2EI8_V_MF2_MF2,
          10885 => Opcode::PseudoVSUXSEG2EI8_V_MF2_MF2_MASK,
          10886 => Opcode::PseudoVSUXSEG2EI8_V_MF4_M1,
          10887 => Opcode::PseudoVSUXSEG2EI8_V_MF4_M1_MASK,
          10888 => Opcode::PseudoVSUXSEG2EI8_V_MF4_M2,
          10889 => Opcode::PseudoVSUXSEG2EI8_V_MF4_M2_MASK,
          10890 => Opcode::PseudoVSUXSEG2EI8_V_MF4_MF2,
          10891 => Opcode::PseudoVSUXSEG2EI8_V_MF4_MF2_MASK,
          10892 => Opcode::PseudoVSUXSEG2EI8_V_MF4_MF4,
          10893 => Opcode::PseudoVSUXSEG2EI8_V_MF4_MF4_MASK,
          10894 => Opcode::PseudoVSUXSEG2EI8_V_MF8_M1,
          10895 => Opcode::PseudoVSUXSEG2EI8_V_MF8_M1_MASK,
          10896 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF2,
          10897 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF2_MASK,
          10898 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF4,
          10899 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF4_MASK,
          10900 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF8,
          10901 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF8_MASK,
          10902 => Opcode::PseudoVSUXSEG3EI16_V_M1_M1,
          10903 => Opcode::PseudoVSUXSEG3EI16_V_M1_M1_MASK,
          10904 => Opcode::PseudoVSUXSEG3EI16_V_M1_M2,
          10905 => Opcode::PseudoVSUXSEG3EI16_V_M1_M2_MASK,
          10906 => Opcode::PseudoVSUXSEG3EI16_V_M1_MF2,
          10907 => Opcode::PseudoVSUXSEG3EI16_V_M1_MF2_MASK,
          10908 => Opcode::PseudoVSUXSEG3EI16_V_M2_M1,
          10909 => Opcode::PseudoVSUXSEG3EI16_V_M2_M1_MASK,
          10910 => Opcode::PseudoVSUXSEG3EI16_V_M2_M2,
          10911 => Opcode::PseudoVSUXSEG3EI16_V_M2_M2_MASK,
          10912 => Opcode::PseudoVSUXSEG3EI16_V_M4_M2,
          10913 => Opcode::PseudoVSUXSEG3EI16_V_M4_M2_MASK,
          10914 => Opcode::PseudoVSUXSEG3EI16_V_MF2_M1,
          10915 => Opcode::PseudoVSUXSEG3EI16_V_MF2_M1_MASK,
          10916 => Opcode::PseudoVSUXSEG3EI16_V_MF2_M2,
          10917 => Opcode::PseudoVSUXSEG3EI16_V_MF2_M2_MASK,
          10918 => Opcode::PseudoVSUXSEG3EI16_V_MF2_MF2,
          10919 => Opcode::PseudoVSUXSEG3EI16_V_MF2_MF2_MASK,
          10920 => Opcode::PseudoVSUXSEG3EI16_V_MF2_MF4,
          10921 => Opcode::PseudoVSUXSEG3EI16_V_MF2_MF4_MASK,
          10922 => Opcode::PseudoVSUXSEG3EI16_V_MF4_M1,
          10923 => Opcode::PseudoVSUXSEG3EI16_V_MF4_M1_MASK,
          10924 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF2,
          10925 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF2_MASK,
          10926 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF4,
          10927 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF4_MASK,
          10928 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF8,
          10929 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF8_MASK,
          10930 => Opcode::PseudoVSUXSEG3EI32_V_M1_M1,
          10931 => Opcode::PseudoVSUXSEG3EI32_V_M1_M1_MASK,
          10932 => Opcode::PseudoVSUXSEG3EI32_V_M1_M2,
          10933 => Opcode::PseudoVSUXSEG3EI32_V_M1_M2_MASK,
          10934 => Opcode::PseudoVSUXSEG3EI32_V_M1_MF2,
          10935 => Opcode::PseudoVSUXSEG3EI32_V_M1_MF2_MASK,
          10936 => Opcode::PseudoVSUXSEG3EI32_V_M1_MF4,
          10937 => Opcode::PseudoVSUXSEG3EI32_V_M1_MF4_MASK,
          10938 => Opcode::PseudoVSUXSEG3EI32_V_M2_M1,
          10939 => Opcode::PseudoVSUXSEG3EI32_V_M2_M1_MASK,
          10940 => Opcode::PseudoVSUXSEG3EI32_V_M2_M2,
          10941 => Opcode::PseudoVSUXSEG3EI32_V_M2_M2_MASK,
          10942 => Opcode::PseudoVSUXSEG3EI32_V_M2_MF2,
          10943 => Opcode::PseudoVSUXSEG3EI32_V_M2_MF2_MASK,
          10944 => Opcode::PseudoVSUXSEG3EI32_V_M4_M1,
          10945 => Opcode::PseudoVSUXSEG3EI32_V_M4_M1_MASK,
          10946 => Opcode::PseudoVSUXSEG3EI32_V_M4_M2,
          10947 => Opcode::PseudoVSUXSEG3EI32_V_M4_M2_MASK,
          10948 => Opcode::PseudoVSUXSEG3EI32_V_M8_M2,
          10949 => Opcode::PseudoVSUXSEG3EI32_V_M8_M2_MASK,
          10950 => Opcode::PseudoVSUXSEG3EI32_V_MF2_M1,
          10951 => Opcode::PseudoVSUXSEG3EI32_V_MF2_M1_MASK,
          10952 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF2,
          10953 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF2_MASK,
          10954 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF4,
          10955 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF4_MASK,
          10956 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF8,
          10957 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF8_MASK,
          10958 => Opcode::PseudoVSUXSEG3EI64_V_M1_M1,
          10959 => Opcode::PseudoVSUXSEG3EI64_V_M1_M1_MASK,
          10960 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF2,
          10961 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF2_MASK,
          10962 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF4,
          10963 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF4_MASK,
          10964 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF8,
          10965 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF8_MASK,
          10966 => Opcode::PseudoVSUXSEG3EI64_V_M2_M1,
          10967 => Opcode::PseudoVSUXSEG3EI64_V_M2_M1_MASK,
          10968 => Opcode::PseudoVSUXSEG3EI64_V_M2_M2,
          10969 => Opcode::PseudoVSUXSEG3EI64_V_M2_M2_MASK,
          10970 => Opcode::PseudoVSUXSEG3EI64_V_M2_MF2,
          10971 => Opcode::PseudoVSUXSEG3EI64_V_M2_MF2_MASK,
          10972 => Opcode::PseudoVSUXSEG3EI64_V_M2_MF4,
          10973 => Opcode::PseudoVSUXSEG3EI64_V_M2_MF4_MASK,
          10974 => Opcode::PseudoVSUXSEG3EI64_V_M4_M1,
          10975 => Opcode::PseudoVSUXSEG3EI64_V_M4_M1_MASK,
          10976 => Opcode::PseudoVSUXSEG3EI64_V_M4_M2,
          10977 => Opcode::PseudoVSUXSEG3EI64_V_M4_M2_MASK,
          10978 => Opcode::PseudoVSUXSEG3EI64_V_M4_MF2,
          10979 => Opcode::PseudoVSUXSEG3EI64_V_M4_MF2_MASK,
          10980 => Opcode::PseudoVSUXSEG3EI64_V_M8_M1,
          10981 => Opcode::PseudoVSUXSEG3EI64_V_M8_M1_MASK,
          10982 => Opcode::PseudoVSUXSEG3EI64_V_M8_M2,
          10983 => Opcode::PseudoVSUXSEG3EI64_V_M8_M2_MASK,
          10984 => Opcode::PseudoVSUXSEG3EI8_V_M1_M1,
          10985 => Opcode::PseudoVSUXSEG3EI8_V_M1_M1_MASK,
          10986 => Opcode::PseudoVSUXSEG3EI8_V_M1_M2,
          10987 => Opcode::PseudoVSUXSEG3EI8_V_M1_M2_MASK,
          10988 => Opcode::PseudoVSUXSEG3EI8_V_M2_M2,
          10989 => Opcode::PseudoVSUXSEG3EI8_V_M2_M2_MASK,
          10990 => Opcode::PseudoVSUXSEG3EI8_V_MF2_M1,
          10991 => Opcode::PseudoVSUXSEG3EI8_V_MF2_M1_MASK,
          10992 => Opcode::PseudoVSUXSEG3EI8_V_MF2_M2,
          10993 => Opcode::PseudoVSUXSEG3EI8_V_MF2_M2_MASK,
          10994 => Opcode::PseudoVSUXSEG3EI8_V_MF2_MF2,
          10995 => Opcode::PseudoVSUXSEG3EI8_V_MF2_MF2_MASK,
          10996 => Opcode::PseudoVSUXSEG3EI8_V_MF4_M1,
          10997 => Opcode::PseudoVSUXSEG3EI8_V_MF4_M1_MASK,
          10998 => Opcode::PseudoVSUXSEG3EI8_V_MF4_M2,
          10999 => Opcode::PseudoVSUXSEG3EI8_V_MF4_M2_MASK,
          11000 => Opcode::PseudoVSUXSEG3EI8_V_MF4_MF2,
          11001 => Opcode::PseudoVSUXSEG3EI8_V_MF4_MF2_MASK,
          11002 => Opcode::PseudoVSUXSEG3EI8_V_MF4_MF4,
          11003 => Opcode::PseudoVSUXSEG3EI8_V_MF4_MF4_MASK,
          11004 => Opcode::PseudoVSUXSEG3EI8_V_MF8_M1,
          11005 => Opcode::PseudoVSUXSEG3EI8_V_MF8_M1_MASK,
          11006 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF2,
          11007 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF2_MASK,
          11008 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF4,
          11009 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF4_MASK,
          11010 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF8,
          11011 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF8_MASK,
          11012 => Opcode::PseudoVSUXSEG4EI16_V_M1_M1,
          11013 => Opcode::PseudoVSUXSEG4EI16_V_M1_M1_MASK,
          11014 => Opcode::PseudoVSUXSEG4EI16_V_M1_M2,
          11015 => Opcode::PseudoVSUXSEG4EI16_V_M1_M2_MASK,
          11016 => Opcode::PseudoVSUXSEG4EI16_V_M1_MF2,
          11017 => Opcode::PseudoVSUXSEG4EI16_V_M1_MF2_MASK,
          11018 => Opcode::PseudoVSUXSEG4EI16_V_M2_M1,
          11019 => Opcode::PseudoVSUXSEG4EI16_V_M2_M1_MASK,
          11020 => Opcode::PseudoVSUXSEG4EI16_V_M2_M2,
          11021 => Opcode::PseudoVSUXSEG4EI16_V_M2_M2_MASK,
          11022 => Opcode::PseudoVSUXSEG4EI16_V_M4_M2,
          11023 => Opcode::PseudoVSUXSEG4EI16_V_M4_M2_MASK,
          11024 => Opcode::PseudoVSUXSEG4EI16_V_MF2_M1,
          11025 => Opcode::PseudoVSUXSEG4EI16_V_MF2_M1_MASK,
          11026 => Opcode::PseudoVSUXSEG4EI16_V_MF2_M2,
          11027 => Opcode::PseudoVSUXSEG4EI16_V_MF2_M2_MASK,
          11028 => Opcode::PseudoVSUXSEG4EI16_V_MF2_MF2,
          11029 => Opcode::PseudoVSUXSEG4EI16_V_MF2_MF2_MASK,
          11030 => Opcode::PseudoVSUXSEG4EI16_V_MF2_MF4,
          11031 => Opcode::PseudoVSUXSEG4EI16_V_MF2_MF4_MASK,
          11032 => Opcode::PseudoVSUXSEG4EI16_V_MF4_M1,
          11033 => Opcode::PseudoVSUXSEG4EI16_V_MF4_M1_MASK,
          11034 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF2,
          11035 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF2_MASK,
          11036 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF4,
          11037 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF4_MASK,
          11038 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF8,
          11039 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF8_MASK,
          11040 => Opcode::PseudoVSUXSEG4EI32_V_M1_M1,
          11041 => Opcode::PseudoVSUXSEG4EI32_V_M1_M1_MASK,
          11042 => Opcode::PseudoVSUXSEG4EI32_V_M1_M2,
          11043 => Opcode::PseudoVSUXSEG4EI32_V_M1_M2_MASK,
          11044 => Opcode::PseudoVSUXSEG4EI32_V_M1_MF2,
          11045 => Opcode::PseudoVSUXSEG4EI32_V_M1_MF2_MASK,
          11046 => Opcode::PseudoVSUXSEG4EI32_V_M1_MF4,
          11047 => Opcode::PseudoVSUXSEG4EI32_V_M1_MF4_MASK,
          11048 => Opcode::PseudoVSUXSEG4EI32_V_M2_M1,
          11049 => Opcode::PseudoVSUXSEG4EI32_V_M2_M1_MASK,
          11050 => Opcode::PseudoVSUXSEG4EI32_V_M2_M2,
          11051 => Opcode::PseudoVSUXSEG4EI32_V_M2_M2_MASK,
          11052 => Opcode::PseudoVSUXSEG4EI32_V_M2_MF2,
          11053 => Opcode::PseudoVSUXSEG4EI32_V_M2_MF2_MASK,
          11054 => Opcode::PseudoVSUXSEG4EI32_V_M4_M1,
          11055 => Opcode::PseudoVSUXSEG4EI32_V_M4_M1_MASK,
          11056 => Opcode::PseudoVSUXSEG4EI32_V_M4_M2,
          11057 => Opcode::PseudoVSUXSEG4EI32_V_M4_M2_MASK,
          11058 => Opcode::PseudoVSUXSEG4EI32_V_M8_M2,
          11059 => Opcode::PseudoVSUXSEG4EI32_V_M8_M2_MASK,
          11060 => Opcode::PseudoVSUXSEG4EI32_V_MF2_M1,
          11061 => Opcode::PseudoVSUXSEG4EI32_V_MF2_M1_MASK,
          11062 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF2,
          11063 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF2_MASK,
          11064 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF4,
          11065 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF4_MASK,
          11066 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF8,
          11067 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF8_MASK,
          11068 => Opcode::PseudoVSUXSEG4EI64_V_M1_M1,
          11069 => Opcode::PseudoVSUXSEG4EI64_V_M1_M1_MASK,
          11070 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF2,
          11071 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF2_MASK,
          11072 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF4,
          11073 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF4_MASK,
          11074 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF8,
          11075 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF8_MASK,
          11076 => Opcode::PseudoVSUXSEG4EI64_V_M2_M1,
          11077 => Opcode::PseudoVSUXSEG4EI64_V_M2_M1_MASK,
          11078 => Opcode::PseudoVSUXSEG4EI64_V_M2_M2,
          11079 => Opcode::PseudoVSUXSEG4EI64_V_M2_M2_MASK,
          11080 => Opcode::PseudoVSUXSEG4EI64_V_M2_MF2,
          11081 => Opcode::PseudoVSUXSEG4EI64_V_M2_MF2_MASK,
          11082 => Opcode::PseudoVSUXSEG4EI64_V_M2_MF4,
          11083 => Opcode::PseudoVSUXSEG4EI64_V_M2_MF4_MASK,
          11084 => Opcode::PseudoVSUXSEG4EI64_V_M4_M1,
          11085 => Opcode::PseudoVSUXSEG4EI64_V_M4_M1_MASK,
          11086 => Opcode::PseudoVSUXSEG4EI64_V_M4_M2,
          11087 => Opcode::PseudoVSUXSEG4EI64_V_M4_M2_MASK,
          11088 => Opcode::PseudoVSUXSEG4EI64_V_M4_MF2,
          11089 => Opcode::PseudoVSUXSEG4EI64_V_M4_MF2_MASK,
          11090 => Opcode::PseudoVSUXSEG4EI64_V_M8_M1,
          11091 => Opcode::PseudoVSUXSEG4EI64_V_M8_M1_MASK,
          11092 => Opcode::PseudoVSUXSEG4EI64_V_M8_M2,
          11093 => Opcode::PseudoVSUXSEG4EI64_V_M8_M2_MASK,
          11094 => Opcode::PseudoVSUXSEG4EI8_V_M1_M1,
          11095 => Opcode::PseudoVSUXSEG4EI8_V_M1_M1_MASK,
          11096 => Opcode::PseudoVSUXSEG4EI8_V_M1_M2,
          11097 => Opcode::PseudoVSUXSEG4EI8_V_M1_M2_MASK,
          11098 => Opcode::PseudoVSUXSEG4EI8_V_M2_M2,
          11099 => Opcode::PseudoVSUXSEG4EI8_V_M2_M2_MASK,
          11100 => Opcode::PseudoVSUXSEG4EI8_V_MF2_M1,
          11101 => Opcode::PseudoVSUXSEG4EI8_V_MF2_M1_MASK,
          11102 => Opcode::PseudoVSUXSEG4EI8_V_MF2_M2,
          11103 => Opcode::PseudoVSUXSEG4EI8_V_MF2_M2_MASK,
          11104 => Opcode::PseudoVSUXSEG4EI8_V_MF2_MF2,
          11105 => Opcode::PseudoVSUXSEG4EI8_V_MF2_MF2_MASK,
          11106 => Opcode::PseudoVSUXSEG4EI8_V_MF4_M1,
          11107 => Opcode::PseudoVSUXSEG4EI8_V_MF4_M1_MASK,
          11108 => Opcode::PseudoVSUXSEG4EI8_V_MF4_M2,
          11109 => Opcode::PseudoVSUXSEG4EI8_V_MF4_M2_MASK,
          11110 => Opcode::PseudoVSUXSEG4EI8_V_MF4_MF2,
          11111 => Opcode::PseudoVSUXSEG4EI8_V_MF4_MF2_MASK,
          11112 => Opcode::PseudoVSUXSEG4EI8_V_MF4_MF4,
          11113 => Opcode::PseudoVSUXSEG4EI8_V_MF4_MF4_MASK,
          11114 => Opcode::PseudoVSUXSEG4EI8_V_MF8_M1,
          11115 => Opcode::PseudoVSUXSEG4EI8_V_MF8_M1_MASK,
          11116 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF2,
          11117 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF2_MASK,
          11118 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF4,
          11119 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF4_MASK,
          11120 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF8,
          11121 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF8_MASK,
          11122 => Opcode::PseudoVSUXSEG5EI16_V_M1_M1,
          11123 => Opcode::PseudoVSUXSEG5EI16_V_M1_M1_MASK,
          11124 => Opcode::PseudoVSUXSEG5EI16_V_M1_MF2,
          11125 => Opcode::PseudoVSUXSEG5EI16_V_M1_MF2_MASK,
          11126 => Opcode::PseudoVSUXSEG5EI16_V_M2_M1,
          11127 => Opcode::PseudoVSUXSEG5EI16_V_M2_M1_MASK,
          11128 => Opcode::PseudoVSUXSEG5EI16_V_MF2_M1,
          11129 => Opcode::PseudoVSUXSEG5EI16_V_MF2_M1_MASK,
          11130 => Opcode::PseudoVSUXSEG5EI16_V_MF2_MF2,
          11131 => Opcode::PseudoVSUXSEG5EI16_V_MF2_MF2_MASK,
          11132 => Opcode::PseudoVSUXSEG5EI16_V_MF2_MF4,
          11133 => Opcode::PseudoVSUXSEG5EI16_V_MF2_MF4_MASK,
          11134 => Opcode::PseudoVSUXSEG5EI16_V_MF4_M1,
          11135 => Opcode::PseudoVSUXSEG5EI16_V_MF4_M1_MASK,
          11136 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF2,
          11137 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF2_MASK,
          11138 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF4,
          11139 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF4_MASK,
          11140 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF8,
          11141 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF8_MASK,
          11142 => Opcode::PseudoVSUXSEG5EI32_V_M1_M1,
          11143 => Opcode::PseudoVSUXSEG5EI32_V_M1_M1_MASK,
          11144 => Opcode::PseudoVSUXSEG5EI32_V_M1_MF2,
          11145 => Opcode::PseudoVSUXSEG5EI32_V_M1_MF2_MASK,
          11146 => Opcode::PseudoVSUXSEG5EI32_V_M1_MF4,
          11147 => Opcode::PseudoVSUXSEG5EI32_V_M1_MF4_MASK,
          11148 => Opcode::PseudoVSUXSEG5EI32_V_M2_M1,
          11149 => Opcode::PseudoVSUXSEG5EI32_V_M2_M1_MASK,
          11150 => Opcode::PseudoVSUXSEG5EI32_V_M2_MF2,
          11151 => Opcode::PseudoVSUXSEG5EI32_V_M2_MF2_MASK,
          11152 => Opcode::PseudoVSUXSEG5EI32_V_M4_M1,
          11153 => Opcode::PseudoVSUXSEG5EI32_V_M4_M1_MASK,
          11154 => Opcode::PseudoVSUXSEG5EI32_V_MF2_M1,
          11155 => Opcode::PseudoVSUXSEG5EI32_V_MF2_M1_MASK,
          11156 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF2,
          11157 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF2_MASK,
          11158 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF4,
          11159 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF4_MASK,
          11160 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF8,
          11161 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF8_MASK,
          11162 => Opcode::PseudoVSUXSEG5EI64_V_M1_M1,
          11163 => Opcode::PseudoVSUXSEG5EI64_V_M1_M1_MASK,
          11164 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF2,
          11165 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF2_MASK,
          11166 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF4,
          11167 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF4_MASK,
          11168 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF8,
          11169 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF8_MASK,
          11170 => Opcode::PseudoVSUXSEG5EI64_V_M2_M1,
          11171 => Opcode::PseudoVSUXSEG5EI64_V_M2_M1_MASK,
          11172 => Opcode::PseudoVSUXSEG5EI64_V_M2_MF2,
          11173 => Opcode::PseudoVSUXSEG5EI64_V_M2_MF2_MASK,
          11174 => Opcode::PseudoVSUXSEG5EI64_V_M2_MF4,
          11175 => Opcode::PseudoVSUXSEG5EI64_V_M2_MF4_MASK,
          11176 => Opcode::PseudoVSUXSEG5EI64_V_M4_M1,
          11177 => Opcode::PseudoVSUXSEG5EI64_V_M4_M1_MASK,
          11178 => Opcode::PseudoVSUXSEG5EI64_V_M4_MF2,
          11179 => Opcode::PseudoVSUXSEG5EI64_V_M4_MF2_MASK,
          11180 => Opcode::PseudoVSUXSEG5EI64_V_M8_M1,
          11181 => Opcode::PseudoVSUXSEG5EI64_V_M8_M1_MASK,
          11182 => Opcode::PseudoVSUXSEG5EI8_V_M1_M1,
          11183 => Opcode::PseudoVSUXSEG5EI8_V_M1_M1_MASK,
          11184 => Opcode::PseudoVSUXSEG5EI8_V_MF2_M1,
          11185 => Opcode::PseudoVSUXSEG5EI8_V_MF2_M1_MASK,
          11186 => Opcode::PseudoVSUXSEG5EI8_V_MF2_MF2,
          11187 => Opcode::PseudoVSUXSEG5EI8_V_MF2_MF2_MASK,
          11188 => Opcode::PseudoVSUXSEG5EI8_V_MF4_M1,
          11189 => Opcode::PseudoVSUXSEG5EI8_V_MF4_M1_MASK,
          11190 => Opcode::PseudoVSUXSEG5EI8_V_MF4_MF2,
          11191 => Opcode::PseudoVSUXSEG5EI8_V_MF4_MF2_MASK,
          11192 => Opcode::PseudoVSUXSEG5EI8_V_MF4_MF4,
          11193 => Opcode::PseudoVSUXSEG5EI8_V_MF4_MF4_MASK,
          11194 => Opcode::PseudoVSUXSEG5EI8_V_MF8_M1,
          11195 => Opcode::PseudoVSUXSEG5EI8_V_MF8_M1_MASK,
          11196 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF2,
          11197 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF2_MASK,
          11198 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF4,
          11199 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF4_MASK,
          11200 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF8,
          11201 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF8_MASK,
          11202 => Opcode::PseudoVSUXSEG6EI16_V_M1_M1,
          11203 => Opcode::PseudoVSUXSEG6EI16_V_M1_M1_MASK,
          11204 => Opcode::PseudoVSUXSEG6EI16_V_M1_MF2,
          11205 => Opcode::PseudoVSUXSEG6EI16_V_M1_MF2_MASK,
          11206 => Opcode::PseudoVSUXSEG6EI16_V_M2_M1,
          11207 => Opcode::PseudoVSUXSEG6EI16_V_M2_M1_MASK,
          11208 => Opcode::PseudoVSUXSEG6EI16_V_MF2_M1,
          11209 => Opcode::PseudoVSUXSEG6EI16_V_MF2_M1_MASK,
          11210 => Opcode::PseudoVSUXSEG6EI16_V_MF2_MF2,
          11211 => Opcode::PseudoVSUXSEG6EI16_V_MF2_MF2_MASK,
          11212 => Opcode::PseudoVSUXSEG6EI16_V_MF2_MF4,
          11213 => Opcode::PseudoVSUXSEG6EI16_V_MF2_MF4_MASK,
          11214 => Opcode::PseudoVSUXSEG6EI16_V_MF4_M1,
          11215 => Opcode::PseudoVSUXSEG6EI16_V_MF4_M1_MASK,
          11216 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF2,
          11217 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF2_MASK,
          11218 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF4,
          11219 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF4_MASK,
          11220 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF8,
          11221 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF8_MASK,
          11222 => Opcode::PseudoVSUXSEG6EI32_V_M1_M1,
          11223 => Opcode::PseudoVSUXSEG6EI32_V_M1_M1_MASK,
          11224 => Opcode::PseudoVSUXSEG6EI32_V_M1_MF2,
          11225 => Opcode::PseudoVSUXSEG6EI32_V_M1_MF2_MASK,
          11226 => Opcode::PseudoVSUXSEG6EI32_V_M1_MF4,
          11227 => Opcode::PseudoVSUXSEG6EI32_V_M1_MF4_MASK,
          11228 => Opcode::PseudoVSUXSEG6EI32_V_M2_M1,
          11229 => Opcode::PseudoVSUXSEG6EI32_V_M2_M1_MASK,
          11230 => Opcode::PseudoVSUXSEG6EI32_V_M2_MF2,
          11231 => Opcode::PseudoVSUXSEG6EI32_V_M2_MF2_MASK,
          11232 => Opcode::PseudoVSUXSEG6EI32_V_M4_M1,
          11233 => Opcode::PseudoVSUXSEG6EI32_V_M4_M1_MASK,
          11234 => Opcode::PseudoVSUXSEG6EI32_V_MF2_M1,
          11235 => Opcode::PseudoVSUXSEG6EI32_V_MF2_M1_MASK,
          11236 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF2,
          11237 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF2_MASK,
          11238 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF4,
          11239 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF4_MASK,
          11240 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF8,
          11241 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF8_MASK,
          11242 => Opcode::PseudoVSUXSEG6EI64_V_M1_M1,
          11243 => Opcode::PseudoVSUXSEG6EI64_V_M1_M1_MASK,
          11244 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF2,
          11245 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF2_MASK,
          11246 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF4,
          11247 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF4_MASK,
          11248 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF8,
          11249 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF8_MASK,
          11250 => Opcode::PseudoVSUXSEG6EI64_V_M2_M1,
          11251 => Opcode::PseudoVSUXSEG6EI64_V_M2_M1_MASK,
          11252 => Opcode::PseudoVSUXSEG6EI64_V_M2_MF2,
          11253 => Opcode::PseudoVSUXSEG6EI64_V_M2_MF2_MASK,
          11254 => Opcode::PseudoVSUXSEG6EI64_V_M2_MF4,
          11255 => Opcode::PseudoVSUXSEG6EI64_V_M2_MF4_MASK,
          11256 => Opcode::PseudoVSUXSEG6EI64_V_M4_M1,
          11257 => Opcode::PseudoVSUXSEG6EI64_V_M4_M1_MASK,
          11258 => Opcode::PseudoVSUXSEG6EI64_V_M4_MF2,
          11259 => Opcode::PseudoVSUXSEG6EI64_V_M4_MF2_MASK,
          11260 => Opcode::PseudoVSUXSEG6EI64_V_M8_M1,
          11261 => Opcode::PseudoVSUXSEG6EI64_V_M8_M1_MASK,
          11262 => Opcode::PseudoVSUXSEG6EI8_V_M1_M1,
          11263 => Opcode::PseudoVSUXSEG6EI8_V_M1_M1_MASK,
          11264 => Opcode::PseudoVSUXSEG6EI8_V_MF2_M1,
          11265 => Opcode::PseudoVSUXSEG6EI8_V_MF2_M1_MASK,
          11266 => Opcode::PseudoVSUXSEG6EI8_V_MF2_MF2,
          11267 => Opcode::PseudoVSUXSEG6EI8_V_MF2_MF2_MASK,
          11268 => Opcode::PseudoVSUXSEG6EI8_V_MF4_M1,
          11269 => Opcode::PseudoVSUXSEG6EI8_V_MF4_M1_MASK,
          11270 => Opcode::PseudoVSUXSEG6EI8_V_MF4_MF2,
          11271 => Opcode::PseudoVSUXSEG6EI8_V_MF4_MF2_MASK,
          11272 => Opcode::PseudoVSUXSEG6EI8_V_MF4_MF4,
          11273 => Opcode::PseudoVSUXSEG6EI8_V_MF4_MF4_MASK,
          11274 => Opcode::PseudoVSUXSEG6EI8_V_MF8_M1,
          11275 => Opcode::PseudoVSUXSEG6EI8_V_MF8_M1_MASK,
          11276 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF2,
          11277 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF2_MASK,
          11278 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF4,
          11279 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF4_MASK,
          11280 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF8,
          11281 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF8_MASK,
          11282 => Opcode::PseudoVSUXSEG7EI16_V_M1_M1,
          11283 => Opcode::PseudoVSUXSEG7EI16_V_M1_M1_MASK,
          11284 => Opcode::PseudoVSUXSEG7EI16_V_M1_MF2,
          11285 => Opcode::PseudoVSUXSEG7EI16_V_M1_MF2_MASK,
          11286 => Opcode::PseudoVSUXSEG7EI16_V_M2_M1,
          11287 => Opcode::PseudoVSUXSEG7EI16_V_M2_M1_MASK,
          11288 => Opcode::PseudoVSUXSEG7EI16_V_MF2_M1,
          11289 => Opcode::PseudoVSUXSEG7EI16_V_MF2_M1_MASK,
          11290 => Opcode::PseudoVSUXSEG7EI16_V_MF2_MF2,
          11291 => Opcode::PseudoVSUXSEG7EI16_V_MF2_MF2_MASK,
          11292 => Opcode::PseudoVSUXSEG7EI16_V_MF2_MF4,
          11293 => Opcode::PseudoVSUXSEG7EI16_V_MF2_MF4_MASK,
          11294 => Opcode::PseudoVSUXSEG7EI16_V_MF4_M1,
          11295 => Opcode::PseudoVSUXSEG7EI16_V_MF4_M1_MASK,
          11296 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF2,
          11297 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF2_MASK,
          11298 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF4,
          11299 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF4_MASK,
          11300 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF8,
          11301 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF8_MASK,
          11302 => Opcode::PseudoVSUXSEG7EI32_V_M1_M1,
          11303 => Opcode::PseudoVSUXSEG7EI32_V_M1_M1_MASK,
          11304 => Opcode::PseudoVSUXSEG7EI32_V_M1_MF2,
          11305 => Opcode::PseudoVSUXSEG7EI32_V_M1_MF2_MASK,
          11306 => Opcode::PseudoVSUXSEG7EI32_V_M1_MF4,
          11307 => Opcode::PseudoVSUXSEG7EI32_V_M1_MF4_MASK,
          11308 => Opcode::PseudoVSUXSEG7EI32_V_M2_M1,
          11309 => Opcode::PseudoVSUXSEG7EI32_V_M2_M1_MASK,
          11310 => Opcode::PseudoVSUXSEG7EI32_V_M2_MF2,
          11311 => Opcode::PseudoVSUXSEG7EI32_V_M2_MF2_MASK,
          11312 => Opcode::PseudoVSUXSEG7EI32_V_M4_M1,
          11313 => Opcode::PseudoVSUXSEG7EI32_V_M4_M1_MASK,
          11314 => Opcode::PseudoVSUXSEG7EI32_V_MF2_M1,
          11315 => Opcode::PseudoVSUXSEG7EI32_V_MF2_M1_MASK,
          11316 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF2,
          11317 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF2_MASK,
          11318 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF4,
          11319 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF4_MASK,
          11320 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF8,
          11321 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF8_MASK,
          11322 => Opcode::PseudoVSUXSEG7EI64_V_M1_M1,
          11323 => Opcode::PseudoVSUXSEG7EI64_V_M1_M1_MASK,
          11324 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF2,
          11325 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF2_MASK,
          11326 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF4,
          11327 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF4_MASK,
          11328 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF8,
          11329 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF8_MASK,
          11330 => Opcode::PseudoVSUXSEG7EI64_V_M2_M1,
          11331 => Opcode::PseudoVSUXSEG7EI64_V_M2_M1_MASK,
          11332 => Opcode::PseudoVSUXSEG7EI64_V_M2_MF2,
          11333 => Opcode::PseudoVSUXSEG7EI64_V_M2_MF2_MASK,
          11334 => Opcode::PseudoVSUXSEG7EI64_V_M2_MF4,
          11335 => Opcode::PseudoVSUXSEG7EI64_V_M2_MF4_MASK,
          11336 => Opcode::PseudoVSUXSEG7EI64_V_M4_M1,
          11337 => Opcode::PseudoVSUXSEG7EI64_V_M4_M1_MASK,
          11338 => Opcode::PseudoVSUXSEG7EI64_V_M4_MF2,
          11339 => Opcode::PseudoVSUXSEG7EI64_V_M4_MF2_MASK,
          11340 => Opcode::PseudoVSUXSEG7EI64_V_M8_M1,
          11341 => Opcode::PseudoVSUXSEG7EI64_V_M8_M1_MASK,
          11342 => Opcode::PseudoVSUXSEG7EI8_V_M1_M1,
          11343 => Opcode::PseudoVSUXSEG7EI8_V_M1_M1_MASK,
          11344 => Opcode::PseudoVSUXSEG7EI8_V_MF2_M1,
          11345 => Opcode::PseudoVSUXSEG7EI8_V_MF2_M1_MASK,
          11346 => Opcode::PseudoVSUXSEG7EI8_V_MF2_MF2,
          11347 => Opcode::PseudoVSUXSEG7EI8_V_MF2_MF2_MASK,
          11348 => Opcode::PseudoVSUXSEG7EI8_V_MF4_M1,
          11349 => Opcode::PseudoVSUXSEG7EI8_V_MF4_M1_MASK,
          11350 => Opcode::PseudoVSUXSEG7EI8_V_MF4_MF2,
          11351 => Opcode::PseudoVSUXSEG7EI8_V_MF4_MF2_MASK,
          11352 => Opcode::PseudoVSUXSEG7EI8_V_MF4_MF4,
          11353 => Opcode::PseudoVSUXSEG7EI8_V_MF4_MF4_MASK,
          11354 => Opcode::PseudoVSUXSEG7EI8_V_MF8_M1,
          11355 => Opcode::PseudoVSUXSEG7EI8_V_MF8_M1_MASK,
          11356 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF2,
          11357 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF2_MASK,
          11358 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF4,
          11359 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF4_MASK,
          11360 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF8,
          11361 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF8_MASK,
          11362 => Opcode::PseudoVSUXSEG8EI16_V_M1_M1,
          11363 => Opcode::PseudoVSUXSEG8EI16_V_M1_M1_MASK,
          11364 => Opcode::PseudoVSUXSEG8EI16_V_M1_MF2,
          11365 => Opcode::PseudoVSUXSEG8EI16_V_M1_MF2_MASK,
          11366 => Opcode::PseudoVSUXSEG8EI16_V_M2_M1,
          11367 => Opcode::PseudoVSUXSEG8EI16_V_M2_M1_MASK,
          11368 => Opcode::PseudoVSUXSEG8EI16_V_MF2_M1,
          11369 => Opcode::PseudoVSUXSEG8EI16_V_MF2_M1_MASK,
          11370 => Opcode::PseudoVSUXSEG8EI16_V_MF2_MF2,
          11371 => Opcode::PseudoVSUXSEG8EI16_V_MF2_MF2_MASK,
          11372 => Opcode::PseudoVSUXSEG8EI16_V_MF2_MF4,
          11373 => Opcode::PseudoVSUXSEG8EI16_V_MF2_MF4_MASK,
          11374 => Opcode::PseudoVSUXSEG8EI16_V_MF4_M1,
          11375 => Opcode::PseudoVSUXSEG8EI16_V_MF4_M1_MASK,
          11376 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF2,
          11377 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF2_MASK,
          11378 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF4,
          11379 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF4_MASK,
          11380 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF8,
          11381 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF8_MASK,
          11382 => Opcode::PseudoVSUXSEG8EI32_V_M1_M1,
          11383 => Opcode::PseudoVSUXSEG8EI32_V_M1_M1_MASK,
          11384 => Opcode::PseudoVSUXSEG8EI32_V_M1_MF2,
          11385 => Opcode::PseudoVSUXSEG8EI32_V_M1_MF2_MASK,
          11386 => Opcode::PseudoVSUXSEG8EI32_V_M1_MF4,
          11387 => Opcode::PseudoVSUXSEG8EI32_V_M1_MF4_MASK,
          11388 => Opcode::PseudoVSUXSEG8EI32_V_M2_M1,
          11389 => Opcode::PseudoVSUXSEG8EI32_V_M2_M1_MASK,
          11390 => Opcode::PseudoVSUXSEG8EI32_V_M2_MF2,
          11391 => Opcode::PseudoVSUXSEG8EI32_V_M2_MF2_MASK,
          11392 => Opcode::PseudoVSUXSEG8EI32_V_M4_M1,
          11393 => Opcode::PseudoVSUXSEG8EI32_V_M4_M1_MASK,
          11394 => Opcode::PseudoVSUXSEG8EI32_V_MF2_M1,
          11395 => Opcode::PseudoVSUXSEG8EI32_V_MF2_M1_MASK,
          11396 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF2,
          11397 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF2_MASK,
          11398 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF4,
          11399 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF4_MASK,
          11400 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF8,
          11401 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF8_MASK,
          11402 => Opcode::PseudoVSUXSEG8EI64_V_M1_M1,
          11403 => Opcode::PseudoVSUXSEG8EI64_V_M1_M1_MASK,
          11404 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF2,
          11405 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF2_MASK,
          11406 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF4,
          11407 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF4_MASK,
          11408 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF8,
          11409 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF8_MASK,
          11410 => Opcode::PseudoVSUXSEG8EI64_V_M2_M1,
          11411 => Opcode::PseudoVSUXSEG8EI64_V_M2_M1_MASK,
          11412 => Opcode::PseudoVSUXSEG8EI64_V_M2_MF2,
          11413 => Opcode::PseudoVSUXSEG8EI64_V_M2_MF2_MASK,
          11414 => Opcode::PseudoVSUXSEG8EI64_V_M2_MF4,
          11415 => Opcode::PseudoVSUXSEG8EI64_V_M2_MF4_MASK,
          11416 => Opcode::PseudoVSUXSEG8EI64_V_M4_M1,
          11417 => Opcode::PseudoVSUXSEG8EI64_V_M4_M1_MASK,
          11418 => Opcode::PseudoVSUXSEG8EI64_V_M4_MF2,
          11419 => Opcode::PseudoVSUXSEG8EI64_V_M4_MF2_MASK,
          11420 => Opcode::PseudoVSUXSEG8EI64_V_M8_M1,
          11421 => Opcode::PseudoVSUXSEG8EI64_V_M8_M1_MASK,
          11422 => Opcode::PseudoVSUXSEG8EI8_V_M1_M1,
          11423 => Opcode::PseudoVSUXSEG8EI8_V_M1_M1_MASK,
          11424 => Opcode::PseudoVSUXSEG8EI8_V_MF2_M1,
          11425 => Opcode::PseudoVSUXSEG8EI8_V_MF2_M1_MASK,
          11426 => Opcode::PseudoVSUXSEG8EI8_V_MF2_MF2,
          11427 => Opcode::PseudoVSUXSEG8EI8_V_MF2_MF2_MASK,
          11428 => Opcode::PseudoVSUXSEG8EI8_V_MF4_M1,
          11429 => Opcode::PseudoVSUXSEG8EI8_V_MF4_M1_MASK,
          11430 => Opcode::PseudoVSUXSEG8EI8_V_MF4_MF2,
          11431 => Opcode::PseudoVSUXSEG8EI8_V_MF4_MF2_MASK,
          11432 => Opcode::PseudoVSUXSEG8EI8_V_MF4_MF4,
          11433 => Opcode::PseudoVSUXSEG8EI8_V_MF4_MF4_MASK,
          11434 => Opcode::PseudoVSUXSEG8EI8_V_MF8_M1,
          11435 => Opcode::PseudoVSUXSEG8EI8_V_MF8_M1_MASK,
          11436 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF2,
          11437 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF2_MASK,
          11438 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF4,
          11439 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF4_MASK,
          11440 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF8,
          11441 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF8_MASK,
          11442 => Opcode::PseudoVWADDU_VV_M1,
          11443 => Opcode::PseudoVWADDU_VV_M1_MASK,
          11444 => Opcode::PseudoVWADDU_VV_M2,
          11445 => Opcode::PseudoVWADDU_VV_M2_MASK,
          11446 => Opcode::PseudoVWADDU_VV_M4,
          11447 => Opcode::PseudoVWADDU_VV_M4_MASK,
          11448 => Opcode::PseudoVWADDU_VV_MF2,
          11449 => Opcode::PseudoVWADDU_VV_MF2_MASK,
          11450 => Opcode::PseudoVWADDU_VV_MF4,
          11451 => Opcode::PseudoVWADDU_VV_MF4_MASK,
          11452 => Opcode::PseudoVWADDU_VV_MF8,
          11453 => Opcode::PseudoVWADDU_VV_MF8_MASK,
          11454 => Opcode::PseudoVWADDU_VX_M1,
          11455 => Opcode::PseudoVWADDU_VX_M1_MASK,
          11456 => Opcode::PseudoVWADDU_VX_M2,
          11457 => Opcode::PseudoVWADDU_VX_M2_MASK,
          11458 => Opcode::PseudoVWADDU_VX_M4,
          11459 => Opcode::PseudoVWADDU_VX_M4_MASK,
          11460 => Opcode::PseudoVWADDU_VX_MF2,
          11461 => Opcode::PseudoVWADDU_VX_MF2_MASK,
          11462 => Opcode::PseudoVWADDU_VX_MF4,
          11463 => Opcode::PseudoVWADDU_VX_MF4_MASK,
          11464 => Opcode::PseudoVWADDU_VX_MF8,
          11465 => Opcode::PseudoVWADDU_VX_MF8_MASK,
          11466 => Opcode::PseudoVWADDU_WV_M1,
          11467 => Opcode::PseudoVWADDU_WV_M1_MASK,
          11468 => Opcode::PseudoVWADDU_WV_M1_MASK_TIED,
          11469 => Opcode::PseudoVWADDU_WV_M1_TIED,
          11470 => Opcode::PseudoVWADDU_WV_M2,
          11471 => Opcode::PseudoVWADDU_WV_M2_MASK,
          11472 => Opcode::PseudoVWADDU_WV_M2_MASK_TIED,
          11473 => Opcode::PseudoVWADDU_WV_M2_TIED,
          11474 => Opcode::PseudoVWADDU_WV_M4,
          11475 => Opcode::PseudoVWADDU_WV_M4_MASK,
          11476 => Opcode::PseudoVWADDU_WV_M4_MASK_TIED,
          11477 => Opcode::PseudoVWADDU_WV_M4_TIED,
          11478 => Opcode::PseudoVWADDU_WV_MF2,
          11479 => Opcode::PseudoVWADDU_WV_MF2_MASK,
          11480 => Opcode::PseudoVWADDU_WV_MF2_MASK_TIED,
          11481 => Opcode::PseudoVWADDU_WV_MF2_TIED,
          11482 => Opcode::PseudoVWADDU_WV_MF4,
          11483 => Opcode::PseudoVWADDU_WV_MF4_MASK,
          11484 => Opcode::PseudoVWADDU_WV_MF4_MASK_TIED,
          11485 => Opcode::PseudoVWADDU_WV_MF4_TIED,
          11486 => Opcode::PseudoVWADDU_WV_MF8,
          11487 => Opcode::PseudoVWADDU_WV_MF8_MASK,
          11488 => Opcode::PseudoVWADDU_WV_MF8_MASK_TIED,
          11489 => Opcode::PseudoVWADDU_WV_MF8_TIED,
          11490 => Opcode::PseudoVWADDU_WX_M1,
          11491 => Opcode::PseudoVWADDU_WX_M1_MASK,
          11492 => Opcode::PseudoVWADDU_WX_M2,
          11493 => Opcode::PseudoVWADDU_WX_M2_MASK,
          11494 => Opcode::PseudoVWADDU_WX_M4,
          11495 => Opcode::PseudoVWADDU_WX_M4_MASK,
          11496 => Opcode::PseudoVWADDU_WX_MF2,
          11497 => Opcode::PseudoVWADDU_WX_MF2_MASK,
          11498 => Opcode::PseudoVWADDU_WX_MF4,
          11499 => Opcode::PseudoVWADDU_WX_MF4_MASK,
          11500 => Opcode::PseudoVWADDU_WX_MF8,
          11501 => Opcode::PseudoVWADDU_WX_MF8_MASK,
          11502 => Opcode::PseudoVWADD_VV_M1,
          11503 => Opcode::PseudoVWADD_VV_M1_MASK,
          11504 => Opcode::PseudoVWADD_VV_M2,
          11505 => Opcode::PseudoVWADD_VV_M2_MASK,
          11506 => Opcode::PseudoVWADD_VV_M4,
          11507 => Opcode::PseudoVWADD_VV_M4_MASK,
          11508 => Opcode::PseudoVWADD_VV_MF2,
          11509 => Opcode::PseudoVWADD_VV_MF2_MASK,
          11510 => Opcode::PseudoVWADD_VV_MF4,
          11511 => Opcode::PseudoVWADD_VV_MF4_MASK,
          11512 => Opcode::PseudoVWADD_VV_MF8,
          11513 => Opcode::PseudoVWADD_VV_MF8_MASK,
          11514 => Opcode::PseudoVWADD_VX_M1,
          11515 => Opcode::PseudoVWADD_VX_M1_MASK,
          11516 => Opcode::PseudoVWADD_VX_M2,
          11517 => Opcode::PseudoVWADD_VX_M2_MASK,
          11518 => Opcode::PseudoVWADD_VX_M4,
          11519 => Opcode::PseudoVWADD_VX_M4_MASK,
          11520 => Opcode::PseudoVWADD_VX_MF2,
          11521 => Opcode::PseudoVWADD_VX_MF2_MASK,
          11522 => Opcode::PseudoVWADD_VX_MF4,
          11523 => Opcode::PseudoVWADD_VX_MF4_MASK,
          11524 => Opcode::PseudoVWADD_VX_MF8,
          11525 => Opcode::PseudoVWADD_VX_MF8_MASK,
          11526 => Opcode::PseudoVWADD_WV_M1,
          11527 => Opcode::PseudoVWADD_WV_M1_MASK,
          11528 => Opcode::PseudoVWADD_WV_M1_MASK_TIED,
          11529 => Opcode::PseudoVWADD_WV_M1_TIED,
          11530 => Opcode::PseudoVWADD_WV_M2,
          11531 => Opcode::PseudoVWADD_WV_M2_MASK,
          11532 => Opcode::PseudoVWADD_WV_M2_MASK_TIED,
          11533 => Opcode::PseudoVWADD_WV_M2_TIED,
          11534 => Opcode::PseudoVWADD_WV_M4,
          11535 => Opcode::PseudoVWADD_WV_M4_MASK,
          11536 => Opcode::PseudoVWADD_WV_M4_MASK_TIED,
          11537 => Opcode::PseudoVWADD_WV_M4_TIED,
          11538 => Opcode::PseudoVWADD_WV_MF2,
          11539 => Opcode::PseudoVWADD_WV_MF2_MASK,
          11540 => Opcode::PseudoVWADD_WV_MF2_MASK_TIED,
          11541 => Opcode::PseudoVWADD_WV_MF2_TIED,
          11542 => Opcode::PseudoVWADD_WV_MF4,
          11543 => Opcode::PseudoVWADD_WV_MF4_MASK,
          11544 => Opcode::PseudoVWADD_WV_MF4_MASK_TIED,
          11545 => Opcode::PseudoVWADD_WV_MF4_TIED,
          11546 => Opcode::PseudoVWADD_WV_MF8,
          11547 => Opcode::PseudoVWADD_WV_MF8_MASK,
          11548 => Opcode::PseudoVWADD_WV_MF8_MASK_TIED,
          11549 => Opcode::PseudoVWADD_WV_MF8_TIED,
          11550 => Opcode::PseudoVWADD_WX_M1,
          11551 => Opcode::PseudoVWADD_WX_M1_MASK,
          11552 => Opcode::PseudoVWADD_WX_M2,
          11553 => Opcode::PseudoVWADD_WX_M2_MASK,
          11554 => Opcode::PseudoVWADD_WX_M4,
          11555 => Opcode::PseudoVWADD_WX_M4_MASK,
          11556 => Opcode::PseudoVWADD_WX_MF2,
          11557 => Opcode::PseudoVWADD_WX_MF2_MASK,
          11558 => Opcode::PseudoVWADD_WX_MF4,
          11559 => Opcode::PseudoVWADD_WX_MF4_MASK,
          11560 => Opcode::PseudoVWADD_WX_MF8,
          11561 => Opcode::PseudoVWADD_WX_MF8_MASK,
          11562 => Opcode::PseudoVWMACCSU_VV_M1,
          11563 => Opcode::PseudoVWMACCSU_VV_M1_MASK,
          11564 => Opcode::PseudoVWMACCSU_VV_M2,
          11565 => Opcode::PseudoVWMACCSU_VV_M2_MASK,
          11566 => Opcode::PseudoVWMACCSU_VV_M4,
          11567 => Opcode::PseudoVWMACCSU_VV_M4_MASK,
          11568 => Opcode::PseudoVWMACCSU_VV_MF2,
          11569 => Opcode::PseudoVWMACCSU_VV_MF2_MASK,
          11570 => Opcode::PseudoVWMACCSU_VV_MF4,
          11571 => Opcode::PseudoVWMACCSU_VV_MF4_MASK,
          11572 => Opcode::PseudoVWMACCSU_VV_MF8,
          11573 => Opcode::PseudoVWMACCSU_VV_MF8_MASK,
          11574 => Opcode::PseudoVWMACCSU_VX_M1,
          11575 => Opcode::PseudoVWMACCSU_VX_M1_MASK,
          11576 => Opcode::PseudoVWMACCSU_VX_M2,
          11577 => Opcode::PseudoVWMACCSU_VX_M2_MASK,
          11578 => Opcode::PseudoVWMACCSU_VX_M4,
          11579 => Opcode::PseudoVWMACCSU_VX_M4_MASK,
          11580 => Opcode::PseudoVWMACCSU_VX_MF2,
          11581 => Opcode::PseudoVWMACCSU_VX_MF2_MASK,
          11582 => Opcode::PseudoVWMACCSU_VX_MF4,
          11583 => Opcode::PseudoVWMACCSU_VX_MF4_MASK,
          11584 => Opcode::PseudoVWMACCSU_VX_MF8,
          11585 => Opcode::PseudoVWMACCSU_VX_MF8_MASK,
          11586 => Opcode::PseudoVWMACCUS_VX_M1,
          11587 => Opcode::PseudoVWMACCUS_VX_M1_MASK,
          11588 => Opcode::PseudoVWMACCUS_VX_M2,
          11589 => Opcode::PseudoVWMACCUS_VX_M2_MASK,
          11590 => Opcode::PseudoVWMACCUS_VX_M4,
          11591 => Opcode::PseudoVWMACCUS_VX_M4_MASK,
          11592 => Opcode::PseudoVWMACCUS_VX_MF2,
          11593 => Opcode::PseudoVWMACCUS_VX_MF2_MASK,
          11594 => Opcode::PseudoVWMACCUS_VX_MF4,
          11595 => Opcode::PseudoVWMACCUS_VX_MF4_MASK,
          11596 => Opcode::PseudoVWMACCUS_VX_MF8,
          11597 => Opcode::PseudoVWMACCUS_VX_MF8_MASK,
          11598 => Opcode::PseudoVWMACCU_VV_M1,
          11599 => Opcode::PseudoVWMACCU_VV_M1_MASK,
          11600 => Opcode::PseudoVWMACCU_VV_M2,
          11601 => Opcode::PseudoVWMACCU_VV_M2_MASK,
          11602 => Opcode::PseudoVWMACCU_VV_M4,
          11603 => Opcode::PseudoVWMACCU_VV_M4_MASK,
          11604 => Opcode::PseudoVWMACCU_VV_MF2,
          11605 => Opcode::PseudoVWMACCU_VV_MF2_MASK,
          11606 => Opcode::PseudoVWMACCU_VV_MF4,
          11607 => Opcode::PseudoVWMACCU_VV_MF4_MASK,
          11608 => Opcode::PseudoVWMACCU_VV_MF8,
          11609 => Opcode::PseudoVWMACCU_VV_MF8_MASK,
          11610 => Opcode::PseudoVWMACCU_VX_M1,
          11611 => Opcode::PseudoVWMACCU_VX_M1_MASK,
          11612 => Opcode::PseudoVWMACCU_VX_M2,
          11613 => Opcode::PseudoVWMACCU_VX_M2_MASK,
          11614 => Opcode::PseudoVWMACCU_VX_M4,
          11615 => Opcode::PseudoVWMACCU_VX_M4_MASK,
          11616 => Opcode::PseudoVWMACCU_VX_MF2,
          11617 => Opcode::PseudoVWMACCU_VX_MF2_MASK,
          11618 => Opcode::PseudoVWMACCU_VX_MF4,
          11619 => Opcode::PseudoVWMACCU_VX_MF4_MASK,
          11620 => Opcode::PseudoVWMACCU_VX_MF8,
          11621 => Opcode::PseudoVWMACCU_VX_MF8_MASK,
          11622 => Opcode::PseudoVWMACC_VV_M1,
          11623 => Opcode::PseudoVWMACC_VV_M1_MASK,
          11624 => Opcode::PseudoVWMACC_VV_M2,
          11625 => Opcode::PseudoVWMACC_VV_M2_MASK,
          11626 => Opcode::PseudoVWMACC_VV_M4,
          11627 => Opcode::PseudoVWMACC_VV_M4_MASK,
          11628 => Opcode::PseudoVWMACC_VV_MF2,
          11629 => Opcode::PseudoVWMACC_VV_MF2_MASK,
          11630 => Opcode::PseudoVWMACC_VV_MF4,
          11631 => Opcode::PseudoVWMACC_VV_MF4_MASK,
          11632 => Opcode::PseudoVWMACC_VV_MF8,
          11633 => Opcode::PseudoVWMACC_VV_MF8_MASK,
          11634 => Opcode::PseudoVWMACC_VX_M1,
          11635 => Opcode::PseudoVWMACC_VX_M1_MASK,
          11636 => Opcode::PseudoVWMACC_VX_M2,
          11637 => Opcode::PseudoVWMACC_VX_M2_MASK,
          11638 => Opcode::PseudoVWMACC_VX_M4,
          11639 => Opcode::PseudoVWMACC_VX_M4_MASK,
          11640 => Opcode::PseudoVWMACC_VX_MF2,
          11641 => Opcode::PseudoVWMACC_VX_MF2_MASK,
          11642 => Opcode::PseudoVWMACC_VX_MF4,
          11643 => Opcode::PseudoVWMACC_VX_MF4_MASK,
          11644 => Opcode::PseudoVWMACC_VX_MF8,
          11645 => Opcode::PseudoVWMACC_VX_MF8_MASK,
          11646 => Opcode::PseudoVWMULSU_VV_M1,
          11647 => Opcode::PseudoVWMULSU_VV_M1_MASK,
          11648 => Opcode::PseudoVWMULSU_VV_M2,
          11649 => Opcode::PseudoVWMULSU_VV_M2_MASK,
          11650 => Opcode::PseudoVWMULSU_VV_M4,
          11651 => Opcode::PseudoVWMULSU_VV_M4_MASK,
          11652 => Opcode::PseudoVWMULSU_VV_MF2,
          11653 => Opcode::PseudoVWMULSU_VV_MF2_MASK,
          11654 => Opcode::PseudoVWMULSU_VV_MF4,
          11655 => Opcode::PseudoVWMULSU_VV_MF4_MASK,
          11656 => Opcode::PseudoVWMULSU_VV_MF8,
          11657 => Opcode::PseudoVWMULSU_VV_MF8_MASK,
          11658 => Opcode::PseudoVWMULSU_VX_M1,
          11659 => Opcode::PseudoVWMULSU_VX_M1_MASK,
          11660 => Opcode::PseudoVWMULSU_VX_M2,
          11661 => Opcode::PseudoVWMULSU_VX_M2_MASK,
          11662 => Opcode::PseudoVWMULSU_VX_M4,
          11663 => Opcode::PseudoVWMULSU_VX_M4_MASK,
          11664 => Opcode::PseudoVWMULSU_VX_MF2,
          11665 => Opcode::PseudoVWMULSU_VX_MF2_MASK,
          11666 => Opcode::PseudoVWMULSU_VX_MF4,
          11667 => Opcode::PseudoVWMULSU_VX_MF4_MASK,
          11668 => Opcode::PseudoVWMULSU_VX_MF8,
          11669 => Opcode::PseudoVWMULSU_VX_MF8_MASK,
          11670 => Opcode::PseudoVWMULU_VV_M1,
          11671 => Opcode::PseudoVWMULU_VV_M1_MASK,
          11672 => Opcode::PseudoVWMULU_VV_M2,
          11673 => Opcode::PseudoVWMULU_VV_M2_MASK,
          11674 => Opcode::PseudoVWMULU_VV_M4,
          11675 => Opcode::PseudoVWMULU_VV_M4_MASK,
          11676 => Opcode::PseudoVWMULU_VV_MF2,
          11677 => Opcode::PseudoVWMULU_VV_MF2_MASK,
          11678 => Opcode::PseudoVWMULU_VV_MF4,
          11679 => Opcode::PseudoVWMULU_VV_MF4_MASK,
          11680 => Opcode::PseudoVWMULU_VV_MF8,
          11681 => Opcode::PseudoVWMULU_VV_MF8_MASK,
          11682 => Opcode::PseudoVWMULU_VX_M1,
          11683 => Opcode::PseudoVWMULU_VX_M1_MASK,
          11684 => Opcode::PseudoVWMULU_VX_M2,
          11685 => Opcode::PseudoVWMULU_VX_M2_MASK,
          11686 => Opcode::PseudoVWMULU_VX_M4,
          11687 => Opcode::PseudoVWMULU_VX_M4_MASK,
          11688 => Opcode::PseudoVWMULU_VX_MF2,
          11689 => Opcode::PseudoVWMULU_VX_MF2_MASK,
          11690 => Opcode::PseudoVWMULU_VX_MF4,
          11691 => Opcode::PseudoVWMULU_VX_MF4_MASK,
          11692 => Opcode::PseudoVWMULU_VX_MF8,
          11693 => Opcode::PseudoVWMULU_VX_MF8_MASK,
          11694 => Opcode::PseudoVWMUL_VV_M1,
          11695 => Opcode::PseudoVWMUL_VV_M1_MASK,
          11696 => Opcode::PseudoVWMUL_VV_M2,
          11697 => Opcode::PseudoVWMUL_VV_M2_MASK,
          11698 => Opcode::PseudoVWMUL_VV_M4,
          11699 => Opcode::PseudoVWMUL_VV_M4_MASK,
          11700 => Opcode::PseudoVWMUL_VV_MF2,
          11701 => Opcode::PseudoVWMUL_VV_MF2_MASK,
          11702 => Opcode::PseudoVWMUL_VV_MF4,
          11703 => Opcode::PseudoVWMUL_VV_MF4_MASK,
          11704 => Opcode::PseudoVWMUL_VV_MF8,
          11705 => Opcode::PseudoVWMUL_VV_MF8_MASK,
          11706 => Opcode::PseudoVWMUL_VX_M1,
          11707 => Opcode::PseudoVWMUL_VX_M1_MASK,
          11708 => Opcode::PseudoVWMUL_VX_M2,
          11709 => Opcode::PseudoVWMUL_VX_M2_MASK,
          11710 => Opcode::PseudoVWMUL_VX_M4,
          11711 => Opcode::PseudoVWMUL_VX_M4_MASK,
          11712 => Opcode::PseudoVWMUL_VX_MF2,
          11713 => Opcode::PseudoVWMUL_VX_MF2_MASK,
          11714 => Opcode::PseudoVWMUL_VX_MF4,
          11715 => Opcode::PseudoVWMUL_VX_MF4_MASK,
          11716 => Opcode::PseudoVWMUL_VX_MF8,
          11717 => Opcode::PseudoVWMUL_VX_MF8_MASK,
          11718 => Opcode::PseudoVWREDSUMU_VS_M1_E16,
          11719 => Opcode::PseudoVWREDSUMU_VS_M1_E16_MASK,
          11720 => Opcode::PseudoVWREDSUMU_VS_M1_E32,
          11721 => Opcode::PseudoVWREDSUMU_VS_M1_E32_MASK,
          11722 => Opcode::PseudoVWREDSUMU_VS_M1_E8,
          11723 => Opcode::PseudoVWREDSUMU_VS_M1_E8_MASK,
          11724 => Opcode::PseudoVWREDSUMU_VS_M2_E16,
          11725 => Opcode::PseudoVWREDSUMU_VS_M2_E16_MASK,
          11726 => Opcode::PseudoVWREDSUMU_VS_M2_E32,
          11727 => Opcode::PseudoVWREDSUMU_VS_M2_E32_MASK,
          11728 => Opcode::PseudoVWREDSUMU_VS_M2_E8,
          11729 => Opcode::PseudoVWREDSUMU_VS_M2_E8_MASK,
          11730 => Opcode::PseudoVWREDSUMU_VS_M4_E16,
          11731 => Opcode::PseudoVWREDSUMU_VS_M4_E16_MASK,
          11732 => Opcode::PseudoVWREDSUMU_VS_M4_E32,
          11733 => Opcode::PseudoVWREDSUMU_VS_M4_E32_MASK,
          11734 => Opcode::PseudoVWREDSUMU_VS_M4_E8,
          11735 => Opcode::PseudoVWREDSUMU_VS_M4_E8_MASK,
          11736 => Opcode::PseudoVWREDSUMU_VS_M8_E16,
          11737 => Opcode::PseudoVWREDSUMU_VS_M8_E16_MASK,
          11738 => Opcode::PseudoVWREDSUMU_VS_M8_E32,
          11739 => Opcode::PseudoVWREDSUMU_VS_M8_E32_MASK,
          11740 => Opcode::PseudoVWREDSUMU_VS_M8_E8,
          11741 => Opcode::PseudoVWREDSUMU_VS_M8_E8_MASK,
          11742 => Opcode::PseudoVWREDSUMU_VS_MF2_E16,
          11743 => Opcode::PseudoVWREDSUMU_VS_MF2_E16_MASK,
          11744 => Opcode::PseudoVWREDSUMU_VS_MF2_E32,
          11745 => Opcode::PseudoVWREDSUMU_VS_MF2_E32_MASK,
          11746 => Opcode::PseudoVWREDSUMU_VS_MF2_E8,
          11747 => Opcode::PseudoVWREDSUMU_VS_MF2_E8_MASK,
          11748 => Opcode::PseudoVWREDSUMU_VS_MF4_E16,
          11749 => Opcode::PseudoVWREDSUMU_VS_MF4_E16_MASK,
          11750 => Opcode::PseudoVWREDSUMU_VS_MF4_E8,
          11751 => Opcode::PseudoVWREDSUMU_VS_MF4_E8_MASK,
          11752 => Opcode::PseudoVWREDSUMU_VS_MF8_E8,
          11753 => Opcode::PseudoVWREDSUMU_VS_MF8_E8_MASK,
          11754 => Opcode::PseudoVWREDSUM_VS_M1_E16,
          11755 => Opcode::PseudoVWREDSUM_VS_M1_E16_MASK,
          11756 => Opcode::PseudoVWREDSUM_VS_M1_E32,
          11757 => Opcode::PseudoVWREDSUM_VS_M1_E32_MASK,
          11758 => Opcode::PseudoVWREDSUM_VS_M1_E8,
          11759 => Opcode::PseudoVWREDSUM_VS_M1_E8_MASK,
          11760 => Opcode::PseudoVWREDSUM_VS_M2_E16,
          11761 => Opcode::PseudoVWREDSUM_VS_M2_E16_MASK,
          11762 => Opcode::PseudoVWREDSUM_VS_M2_E32,
          11763 => Opcode::PseudoVWREDSUM_VS_M2_E32_MASK,
          11764 => Opcode::PseudoVWREDSUM_VS_M2_E8,
          11765 => Opcode::PseudoVWREDSUM_VS_M2_E8_MASK,
          11766 => Opcode::PseudoVWREDSUM_VS_M4_E16,
          11767 => Opcode::PseudoVWREDSUM_VS_M4_E16_MASK,
          11768 => Opcode::PseudoVWREDSUM_VS_M4_E32,
          11769 => Opcode::PseudoVWREDSUM_VS_M4_E32_MASK,
          11770 => Opcode::PseudoVWREDSUM_VS_M4_E8,
          11771 => Opcode::PseudoVWREDSUM_VS_M4_E8_MASK,
          11772 => Opcode::PseudoVWREDSUM_VS_M8_E16,
          11773 => Opcode::PseudoVWREDSUM_VS_M8_E16_MASK,
          11774 => Opcode::PseudoVWREDSUM_VS_M8_E32,
          11775 => Opcode::PseudoVWREDSUM_VS_M8_E32_MASK,
          11776 => Opcode::PseudoVWREDSUM_VS_M8_E8,
          11777 => Opcode::PseudoVWREDSUM_VS_M8_E8_MASK,
          11778 => Opcode::PseudoVWREDSUM_VS_MF2_E16,
          11779 => Opcode::PseudoVWREDSUM_VS_MF2_E16_MASK,
          11780 => Opcode::PseudoVWREDSUM_VS_MF2_E32,
          11781 => Opcode::PseudoVWREDSUM_VS_MF2_E32_MASK,
          11782 => Opcode::PseudoVWREDSUM_VS_MF2_E8,
          11783 => Opcode::PseudoVWREDSUM_VS_MF2_E8_MASK,
          11784 => Opcode::PseudoVWREDSUM_VS_MF4_E16,
          11785 => Opcode::PseudoVWREDSUM_VS_MF4_E16_MASK,
          11786 => Opcode::PseudoVWREDSUM_VS_MF4_E8,
          11787 => Opcode::PseudoVWREDSUM_VS_MF4_E8_MASK,
          11788 => Opcode::PseudoVWREDSUM_VS_MF8_E8,
          11789 => Opcode::PseudoVWREDSUM_VS_MF8_E8_MASK,
          11790 => Opcode::PseudoVWSLL_VI_M1,
          11791 => Opcode::PseudoVWSLL_VI_M1_MASK,
          11792 => Opcode::PseudoVWSLL_VI_M2,
          11793 => Opcode::PseudoVWSLL_VI_M2_MASK,
          11794 => Opcode::PseudoVWSLL_VI_M4,
          11795 => Opcode::PseudoVWSLL_VI_M4_MASK,
          11796 => Opcode::PseudoVWSLL_VI_MF2,
          11797 => Opcode::PseudoVWSLL_VI_MF2_MASK,
          11798 => Opcode::PseudoVWSLL_VI_MF4,
          11799 => Opcode::PseudoVWSLL_VI_MF4_MASK,
          11800 => Opcode::PseudoVWSLL_VI_MF8,
          11801 => Opcode::PseudoVWSLL_VI_MF8_MASK,
          11802 => Opcode::PseudoVWSLL_VV_M1,
          11803 => Opcode::PseudoVWSLL_VV_M1_MASK,
          11804 => Opcode::PseudoVWSLL_VV_M2,
          11805 => Opcode::PseudoVWSLL_VV_M2_MASK,
          11806 => Opcode::PseudoVWSLL_VV_M4,
          11807 => Opcode::PseudoVWSLL_VV_M4_MASK,
          11808 => Opcode::PseudoVWSLL_VV_MF2,
          11809 => Opcode::PseudoVWSLL_VV_MF2_MASK,
          11810 => Opcode::PseudoVWSLL_VV_MF4,
          11811 => Opcode::PseudoVWSLL_VV_MF4_MASK,
          11812 => Opcode::PseudoVWSLL_VV_MF8,
          11813 => Opcode::PseudoVWSLL_VV_MF8_MASK,
          11814 => Opcode::PseudoVWSLL_VX_M1,
          11815 => Opcode::PseudoVWSLL_VX_M1_MASK,
          11816 => Opcode::PseudoVWSLL_VX_M2,
          11817 => Opcode::PseudoVWSLL_VX_M2_MASK,
          11818 => Opcode::PseudoVWSLL_VX_M4,
          11819 => Opcode::PseudoVWSLL_VX_M4_MASK,
          11820 => Opcode::PseudoVWSLL_VX_MF2,
          11821 => Opcode::PseudoVWSLL_VX_MF2_MASK,
          11822 => Opcode::PseudoVWSLL_VX_MF4,
          11823 => Opcode::PseudoVWSLL_VX_MF4_MASK,
          11824 => Opcode::PseudoVWSLL_VX_MF8,
          11825 => Opcode::PseudoVWSLL_VX_MF8_MASK,
          11826 => Opcode::PseudoVWSUBU_VV_M1,
          11827 => Opcode::PseudoVWSUBU_VV_M1_MASK,
          11828 => Opcode::PseudoVWSUBU_VV_M2,
          11829 => Opcode::PseudoVWSUBU_VV_M2_MASK,
          11830 => Opcode::PseudoVWSUBU_VV_M4,
          11831 => Opcode::PseudoVWSUBU_VV_M4_MASK,
          11832 => Opcode::PseudoVWSUBU_VV_MF2,
          11833 => Opcode::PseudoVWSUBU_VV_MF2_MASK,
          11834 => Opcode::PseudoVWSUBU_VV_MF4,
          11835 => Opcode::PseudoVWSUBU_VV_MF4_MASK,
          11836 => Opcode::PseudoVWSUBU_VV_MF8,
          11837 => Opcode::PseudoVWSUBU_VV_MF8_MASK,
          11838 => Opcode::PseudoVWSUBU_VX_M1,
          11839 => Opcode::PseudoVWSUBU_VX_M1_MASK,
          11840 => Opcode::PseudoVWSUBU_VX_M2,
          11841 => Opcode::PseudoVWSUBU_VX_M2_MASK,
          11842 => Opcode::PseudoVWSUBU_VX_M4,
          11843 => Opcode::PseudoVWSUBU_VX_M4_MASK,
          11844 => Opcode::PseudoVWSUBU_VX_MF2,
          11845 => Opcode::PseudoVWSUBU_VX_MF2_MASK,
          11846 => Opcode::PseudoVWSUBU_VX_MF4,
          11847 => Opcode::PseudoVWSUBU_VX_MF4_MASK,
          11848 => Opcode::PseudoVWSUBU_VX_MF8,
          11849 => Opcode::PseudoVWSUBU_VX_MF8_MASK,
          11850 => Opcode::PseudoVWSUBU_WV_M1,
          11851 => Opcode::PseudoVWSUBU_WV_M1_MASK,
          11852 => Opcode::PseudoVWSUBU_WV_M1_MASK_TIED,
          11853 => Opcode::PseudoVWSUBU_WV_M1_TIED,
          11854 => Opcode::PseudoVWSUBU_WV_M2,
          11855 => Opcode::PseudoVWSUBU_WV_M2_MASK,
          11856 => Opcode::PseudoVWSUBU_WV_M2_MASK_TIED,
          11857 => Opcode::PseudoVWSUBU_WV_M2_TIED,
          11858 => Opcode::PseudoVWSUBU_WV_M4,
          11859 => Opcode::PseudoVWSUBU_WV_M4_MASK,
          11860 => Opcode::PseudoVWSUBU_WV_M4_MASK_TIED,
          11861 => Opcode::PseudoVWSUBU_WV_M4_TIED,
          11862 => Opcode::PseudoVWSUBU_WV_MF2,
          11863 => Opcode::PseudoVWSUBU_WV_MF2_MASK,
          11864 => Opcode::PseudoVWSUBU_WV_MF2_MASK_TIED,
          11865 => Opcode::PseudoVWSUBU_WV_MF2_TIED,
          11866 => Opcode::PseudoVWSUBU_WV_MF4,
          11867 => Opcode::PseudoVWSUBU_WV_MF4_MASK,
          11868 => Opcode::PseudoVWSUBU_WV_MF4_MASK_TIED,
          11869 => Opcode::PseudoVWSUBU_WV_MF4_TIED,
          11870 => Opcode::PseudoVWSUBU_WV_MF8,
          11871 => Opcode::PseudoVWSUBU_WV_MF8_MASK,
          11872 => Opcode::PseudoVWSUBU_WV_MF8_MASK_TIED,
          11873 => Opcode::PseudoVWSUBU_WV_MF8_TIED,
          11874 => Opcode::PseudoVWSUBU_WX_M1,
          11875 => Opcode::PseudoVWSUBU_WX_M1_MASK,
          11876 => Opcode::PseudoVWSUBU_WX_M2,
          11877 => Opcode::PseudoVWSUBU_WX_M2_MASK,
          11878 => Opcode::PseudoVWSUBU_WX_M4,
          11879 => Opcode::PseudoVWSUBU_WX_M4_MASK,
          11880 => Opcode::PseudoVWSUBU_WX_MF2,
          11881 => Opcode::PseudoVWSUBU_WX_MF2_MASK,
          11882 => Opcode::PseudoVWSUBU_WX_MF4,
          11883 => Opcode::PseudoVWSUBU_WX_MF4_MASK,
          11884 => Opcode::PseudoVWSUBU_WX_MF8,
          11885 => Opcode::PseudoVWSUBU_WX_MF8_MASK,
          11886 => Opcode::PseudoVWSUB_VV_M1,
          11887 => Opcode::PseudoVWSUB_VV_M1_MASK,
          11888 => Opcode::PseudoVWSUB_VV_M2,
          11889 => Opcode::PseudoVWSUB_VV_M2_MASK,
          11890 => Opcode::PseudoVWSUB_VV_M4,
          11891 => Opcode::PseudoVWSUB_VV_M4_MASK,
          11892 => Opcode::PseudoVWSUB_VV_MF2,
          11893 => Opcode::PseudoVWSUB_VV_MF2_MASK,
          11894 => Opcode::PseudoVWSUB_VV_MF4,
          11895 => Opcode::PseudoVWSUB_VV_MF4_MASK,
          11896 => Opcode::PseudoVWSUB_VV_MF8,
          11897 => Opcode::PseudoVWSUB_VV_MF8_MASK,
          11898 => Opcode::PseudoVWSUB_VX_M1,
          11899 => Opcode::PseudoVWSUB_VX_M1_MASK,
          11900 => Opcode::PseudoVWSUB_VX_M2,
          11901 => Opcode::PseudoVWSUB_VX_M2_MASK,
          11902 => Opcode::PseudoVWSUB_VX_M4,
          11903 => Opcode::PseudoVWSUB_VX_M4_MASK,
          11904 => Opcode::PseudoVWSUB_VX_MF2,
          11905 => Opcode::PseudoVWSUB_VX_MF2_MASK,
          11906 => Opcode::PseudoVWSUB_VX_MF4,
          11907 => Opcode::PseudoVWSUB_VX_MF4_MASK,
          11908 => Opcode::PseudoVWSUB_VX_MF8,
          11909 => Opcode::PseudoVWSUB_VX_MF8_MASK,
          11910 => Opcode::PseudoVWSUB_WV_M1,
          11911 => Opcode::PseudoVWSUB_WV_M1_MASK,
          11912 => Opcode::PseudoVWSUB_WV_M1_MASK_TIED,
          11913 => Opcode::PseudoVWSUB_WV_M1_TIED,
          11914 => Opcode::PseudoVWSUB_WV_M2,
          11915 => Opcode::PseudoVWSUB_WV_M2_MASK,
          11916 => Opcode::PseudoVWSUB_WV_M2_MASK_TIED,
          11917 => Opcode::PseudoVWSUB_WV_M2_TIED,
          11918 => Opcode::PseudoVWSUB_WV_M4,
          11919 => Opcode::PseudoVWSUB_WV_M4_MASK,
          11920 => Opcode::PseudoVWSUB_WV_M4_MASK_TIED,
          11921 => Opcode::PseudoVWSUB_WV_M4_TIED,
          11922 => Opcode::PseudoVWSUB_WV_MF2,
          11923 => Opcode::PseudoVWSUB_WV_MF2_MASK,
          11924 => Opcode::PseudoVWSUB_WV_MF2_MASK_TIED,
          11925 => Opcode::PseudoVWSUB_WV_MF2_TIED,
          11926 => Opcode::PseudoVWSUB_WV_MF4,
          11927 => Opcode::PseudoVWSUB_WV_MF4_MASK,
          11928 => Opcode::PseudoVWSUB_WV_MF4_MASK_TIED,
          11929 => Opcode::PseudoVWSUB_WV_MF4_TIED,
          11930 => Opcode::PseudoVWSUB_WV_MF8,
          11931 => Opcode::PseudoVWSUB_WV_MF8_MASK,
          11932 => Opcode::PseudoVWSUB_WV_MF8_MASK_TIED,
          11933 => Opcode::PseudoVWSUB_WV_MF8_TIED,
          11934 => Opcode::PseudoVWSUB_WX_M1,
          11935 => Opcode::PseudoVWSUB_WX_M1_MASK,
          11936 => Opcode::PseudoVWSUB_WX_M2,
          11937 => Opcode::PseudoVWSUB_WX_M2_MASK,
          11938 => Opcode::PseudoVWSUB_WX_M4,
          11939 => Opcode::PseudoVWSUB_WX_M4_MASK,
          11940 => Opcode::PseudoVWSUB_WX_MF2,
          11941 => Opcode::PseudoVWSUB_WX_MF2_MASK,
          11942 => Opcode::PseudoVWSUB_WX_MF4,
          11943 => Opcode::PseudoVWSUB_WX_MF4_MASK,
          11944 => Opcode::PseudoVWSUB_WX_MF8,
          11945 => Opcode::PseudoVWSUB_WX_MF8_MASK,
          11946 => Opcode::PseudoVXOR_VI_M1,
          11947 => Opcode::PseudoVXOR_VI_M1_MASK,
          11948 => Opcode::PseudoVXOR_VI_M2,
          11949 => Opcode::PseudoVXOR_VI_M2_MASK,
          11950 => Opcode::PseudoVXOR_VI_M4,
          11951 => Opcode::PseudoVXOR_VI_M4_MASK,
          11952 => Opcode::PseudoVXOR_VI_M8,
          11953 => Opcode::PseudoVXOR_VI_M8_MASK,
          11954 => Opcode::PseudoVXOR_VI_MF2,
          11955 => Opcode::PseudoVXOR_VI_MF2_MASK,
          11956 => Opcode::PseudoVXOR_VI_MF4,
          11957 => Opcode::PseudoVXOR_VI_MF4_MASK,
          11958 => Opcode::PseudoVXOR_VI_MF8,
          11959 => Opcode::PseudoVXOR_VI_MF8_MASK,
          11960 => Opcode::PseudoVXOR_VV_M1,
          11961 => Opcode::PseudoVXOR_VV_M1_MASK,
          11962 => Opcode::PseudoVXOR_VV_M2,
          11963 => Opcode::PseudoVXOR_VV_M2_MASK,
          11964 => Opcode::PseudoVXOR_VV_M4,
          11965 => Opcode::PseudoVXOR_VV_M4_MASK,
          11966 => Opcode::PseudoVXOR_VV_M8,
          11967 => Opcode::PseudoVXOR_VV_M8_MASK,
          11968 => Opcode::PseudoVXOR_VV_MF2,
          11969 => Opcode::PseudoVXOR_VV_MF2_MASK,
          11970 => Opcode::PseudoVXOR_VV_MF4,
          11971 => Opcode::PseudoVXOR_VV_MF4_MASK,
          11972 => Opcode::PseudoVXOR_VV_MF8,
          11973 => Opcode::PseudoVXOR_VV_MF8_MASK,
          11974 => Opcode::PseudoVXOR_VX_M1,
          11975 => Opcode::PseudoVXOR_VX_M1_MASK,
          11976 => Opcode::PseudoVXOR_VX_M2,
          11977 => Opcod