// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <TecplotPluginInfo.h>
#include <avtTecplotFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtTecplotOptions.h>

// ****************************************************************************
//  Method:  TecplotCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Tecplot database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
TecplotCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method: TecplotCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a Tecplot database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Tecplot database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:41:50 PST 2005
//
//  Modifications:
//    Brad Whitlock, Fri Jun  6 15:34:53 PDT 2008
//    Check for Tecplot binary and instantiate the right reader class.
//
//    Jeremy Meredith, Tue Oct 25 12:38:28 EDT 2011
//    Added read options.
//
// ****************************************************************************
#include <avtTecplotBinaryFileFormat.h>

avtDatabase *
TecplotCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    bool isBinary = avtTecplotBinaryFileFormat::MatchFormat(list[0]);

    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        if(isBinary)
            ffl[i] = new avtTecplotBinaryFileFormat(list[i], readOptions);
        else
            ffl[i] = new avtTecplotFileFormat(list[i], readOptions);
    }
    avtSTMDFileFormatInterface *inter
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}


// ****************************************************************************
//  Method: TecplotCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
TecplotCommonPluginInfo::GetReadOptions() const
{
    return GetTecplotReadOptions();
}

// ****************************************************************************
//  Method: TecplotCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
TecplotCommonPluginInfo::GetWriteOptions() const
{
    return GetTecplotWriteOptions();
}

