#version 150

uniform vec2 LensCentre;
uniform vec2 Scale;
uniform vec2 ScaleIn;
uniform vec4 HmdWarpParam;
uniform vec4 ChromAbParam;
uniform float projOffset;

varying vec2 uv;
uniform sampler2D LeftTex;
uniform sampler2D RightTex;


void main()
{
	vec2 tc = uv;
	if(uv.x <= 0.5)
	{
	  vec2 lCentre = vec2(LensCentre.x + (projOffset / 2.0), LensCentre.y);
	  vec2 in01 = vec2(uv.x * 2.0, uv.y);
	  vec2 theta = (in01 - lCentre) * ScaleIn; // Scales to [-1, 1]
  	float rSq = theta.x * theta.x + theta.y * theta.y;
  	vec2 rvector = theta * (HmdWarpParam.x + HmdWarpParam.y * rSq + HmdWarpParam.z * rSq * rSq + HmdWarpParam.w * rSq * rSq * rSq);
  	tc = lCentre + Scale * rvector;
		
    float vignette = clamp((min(min(tc.x, 1.0-tc.x), min(tc.y, 1.0-tc.y)) / 0.03), 0.0 ,1.0);
    
    // Detect whether blue texture coordinates are out of range
    // since these will scaled out the furthest.
    vec2 thetaBlue = rvector * (ChromAbParam.z + ChromAbParam.w * rSq);
    vec2 tcBlue = lCentre + Scale * thetaBlue;
    
    //todo break out early here note the following lines are hlsl while the rest is in cg
    //if (any(clamp(tcBlue, ScreenCenter -vec2(0.25, 0.5),
    //ScreenCenter+vec2(0.25, 0.5)) - tcBlue)
    
    // Now do blue texture lookup.
    float blue = texture2D(LeftTex, tcBlue).b;
    // Do green lookup (no scaling).
    vec2 tcGreen = lCentre + Scale * rvector;
    float green = texture2D(LeftTex, tcGreen).g;
    // Do red scale and lookup.
    vec2 thetaRed = rvector * (ChromAbParam.x + ChromAbParam.y * rSq);
    vec2 tcRed = lCentre + Scale * thetaRed;
    float red = texture2D(LeftTex, tcRed).r;
    
    gl_FragColor = mix(vec4(0.0, 0.0, 0.0 ,1.0), vec4(red, green, blue, 1.0), vec4(vignette, vignette, vignette, 1.0));
	}
	else
	{
	  vec2 lCentre = vec2(LensCentre.x - (projOffset / 2.0), LensCentre.y);
	  vec2 in01 = vec2((uv.x - 0.5) * 2.0, uv.y);
		vec2 theta = (in01 - lCentre) * ScaleIn; // Scales to [-1, 1]
  	float rSq = theta.x * theta.x + theta.y * theta.y;
  	vec2 rvector = theta * (HmdWarpParam.x + HmdWarpParam.y * rSq + HmdWarpParam.z * rSq * rSq + HmdWarpParam.w * rSq * rSq * rSq);
  	tc = lCentre + Scale * rvector;
		
    float vignette = clamp((min(min(tc.x, 1.0-tc.x), min(tc.y, 1.0-tc.y)) / 0.03), 0.0 ,1.0);
    
    // Detect whether blue texture coordinates are out of range
    // since these will scaled out the furthest.
    vec2 thetaBlue = rvector * (ChromAbParam.z + ChromAbParam.w * rSq);
    vec2 tcBlue = lCentre + Scale * thetaBlue;
    
    //todo break out early here note the following lines are hlsl while the rest is in cg
    //if (any(clamp(tcBlue, ScreenCenter -vec2(0.25, 0.5),
    //ScreenCenter+vec2(0.25, 0.5)) - tcBlue)
    
    // Now do blue texture lookup.
    float blue = texture2D(RightTex, tcBlue).b;
    // Do green lookup (no scaling).
    vec2 tcGreen = lCentre + Scale * rvector;
    float green = texture2D(RightTex, tcGreen).g;
    // Do red scale and lookup.
    vec2 thetaRed = rvector * (ChromAbParam.x + ChromAbParam.y * rSq);
    vec2 tcRed = lCentre + Scale * thetaRed;
    float red = texture2D(RightTex, tcRed).r;
    
    gl_FragColor = mix(vec4(0.0, 0.0, 0.0 ,1.0), vec4(red, green, blue, 1.0), vec4(vignette, vignette, vignette, 1.0));
	}
}
