#version 120
precision mediump int;
precision mediump float;

varying vec2 uv;

uniform sampler2D inRTT;
uniform sampler2D inBloom;
uniform sampler2D inLum;
uniform sampler2D inKey;
uniform float effectAmount;
uniform float blurAmount;
uniform float gamma;

vec4 toneMap(vec4 inColour, vec4 lum, vec4 key)
{  
  //Reinhard's Photographic Tone Reproduction Operator
  vec4 scaledlum = inColour * (key/(lum + vec4(0.0001)));
  inColour.rgb = (scaledlum * (vec4(1) + scaledlum / (lum + vec4(0.0001) * lum + vec4(0.0001))) / (vec4(0.5) + scaledlum)).rgb;

	return clamp(inColour, vec4(0.0), vec4(1.0));
}

vec4 radial(sampler2D tex,
              vec2 texcoord,
              int samples,
              float startScale,
              float scaleMul,
              vec4 lum,
              vec4 key)
{
    vec4 c = vec4(0.0, 0.0, 0.0, 0.0);
    float scale = startScale;
    for(int i=0; i < samples; i++)
    {
        vec2 uv = ((texcoord - vec2(0.5))* vec4(scale)) + vec4(0.5);
        vec4 s = toneMap(texture2D(tex, uv), lum, key);
        c += s;
        scale *= scaleMul;
    }
    c /= vec4(samples);
    return c;
}

void main()
{
	// Get main scene colour
  vec4 sceneCol = texture2D(inRTT, uv);

	// Get luminence value
	vec4 lum = texture2D(inLum, vec2(0.5, 0.5));

	// Get key
	vec4 key = texture2D(inKey, vec2(0.5, 0.5));

	// tone map this
	vec4 toneMappedSceneCol = toneMap(sceneCol, lum, key);
	
	// Get bloom colour
  vec4 toneMappedBloom = toneMap(texture2D(inBloom, uv), lum, key);
  vec4 effect = radial(inBloom, uv, 30, 1.0, 0.95, lum, key);

  vec4 c = mix(toneMappedSceneCol, toneMappedBloom, blurAmount);
	c += c * vec4(1.0 - effectAmount);
	c += effect * vec4(effectAmount);
  
  // vignette effect
  //c *= vignette(uv*2-1, 0.7, 1.5);

  // gamma correction
  c.rgb = pow(c.rgb, vec3(gamma));

  return c;