#version 120
precision mediump int;
precision mediump float;

varying vec2 uv;

uniform sampler2D inRTT;
uniform sampler2D inLum;
uniform sampler2D inKey;
uniform vec2 texelSize;

vec4 toneMap(vec4 inColour, vec4 lum, vec4 key)
{  
  //Reinhard's Photographic Tone Reproduction Operator
  vec4 scaledlum = inColour * (key/(lum + vec4(0.0001)));
  inColour.rgb = (scaledlum * (vec4(1) + scaledlum / (lum + vec4(0.0001) * lum + vec4(0.0001))) / (vec4(0.5) + scaledlum)).rgb;

	return clamp(inColour, vec4(0.0), vec4(1.0));
}

void main()
{
	vec4 avgLum = texture2D(inLum, vec2(0.5, 0.5));
	vec4 Key = texture2D(inKey, vec2(0.5, 0.5));
	
	vec4 accum = vec4(0.0, 0.0, 0.0, 0.0);

  // Get colour from source
  accum += texture2D(inRTT, uv + texelSize * vec2(-0.5, -0.5));
  accum += texture2D(inRTT, uv + texelSize * vec2(-0.5, 0.5));
  accum += texture2D(inRTT, uv + texelSize * vec2(0.5, 0.5));
  accum += texture2D(inRTT, uv + texelSize * vec2(0.5, -0.5));

	// take average of 4 samples
	accum *= 0.25;
  
	gl_FragColor = toneMap(accum, avgLum, Key);
}