; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple aarch64-none-linux-gnu | FileCheck %s

; Test the (concat_vectors (trunc (lshr)), (trunc (lshr))) pattern.

define <16 x i8> @test_combine_v8i16_to_v16i8(<8 x i16> %x, <8 x i16> %y) {
; CHECK-LABEL: test_combine_v8i16_to_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp2 v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %lshr1 = lshr <8 x i16> %x, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  %trunc1 = trunc <8 x i16> %lshr1 to <8 x i8>
  %lshr2 = lshr <8 x i16> %y, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  %trunc2 = trunc <8 x i16> %lshr2 to <8 x i8>
  %shuffle = shufflevector <8 x i8> %trunc1, <8 x i8> %trunc2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %shuffle
}

define <8 x i16> @test_combine_v4i32_to_v8i16(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: test_combine_v4i32_to_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp2 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
entry:
  %lshr1 = lshr <4 x i32> %x, <i32 16, i32 16, i32 16, i32 16>
  %trunc1 = trunc <4 x i32> %lshr1 to <4 x i16>
  %lshr2 = lshr <4 x i32> %y, <i32 16, i32 16, i32 16, i32 16>
  %trunc2 = trunc <4 x i32> %lshr2 to <4 x i16>
  %shuffle = shufflevector <4 x i16> %trunc1, <4 x i16> %trunc2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %shuffle
}

define <4 x i32> @test_combine_v2i64_to_v4i32(<2 x i64> %x, <2 x i64> %y) {
; CHECK-LABEL: test_combine_v2i64_to_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp2 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %lshr1 = lshr <2 x i64> %x, <i64 32, i64 32>
  %trunc1 = trunc <2 x i64> %lshr1 to <2 x i32>
  %lshr2 = lshr <2 x i64> %y, <i64 32, i64 32>
  %trunc2 = trunc <2 x i64> %lshr2 to <2 x i32>
  %shuffle = shufflevector <2 x i32> %trunc1, <2 x i32> %trunc2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %shuffle
}

