; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=loop-distribute -enable-loop-distribute -verify-loop-info -verify-dom-info -S < %s \
; RUN:   | FileCheck %s

; We should distribute this loop along === but not along ---.  The last
; partition won't be vectorized due to conditional stores so it's better to
; keep it with the second partition which has a dependence cycle.

; (1st statement):
;   for (i = 0; i < n; i++) {
;     C[i] = D[i] * E[i];
;=============================
;     A[i + 1] = A[i] * B[i];
;-----------------------------
;     if (F[i])
;        G[i] = H[i] * J[i];
;   }

; Ensure that we have only two partitions, the first with one multiplication
; and the second with two.
define void @f(ptr noalias %a, ptr noalias %b, ptr noalias %c, ptr noalias %d, ptr noalias %e, ptr noalias %g, ptr noalias %h, ptr noalias %j, i64 %x) {
; CHECK-LABEL: define void @f(
; CHECK-SAME: ptr noalias [[A:%.*]], ptr noalias [[B:%.*]], ptr noalias [[C:%.*]], ptr noalias [[D:%.*]], ptr noalias [[E:%.*]], ptr noalias [[G:%.*]], ptr noalias [[H:%.*]], ptr noalias [[J:%.*]], i64 [[X:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    br label %[[ENTRY_SPLIT_LDIST1:.*]]
; CHECK:       [[ENTRY_SPLIT_LDIST1]]:
; CHECK-NEXT:    br label %[[FOR_BODY_LDIST1:.*]]
; CHECK:       [[FOR_BODY_LDIST1]]:
; CHECK-NEXT:    [[IND_LDIST1:%.*]] = phi i64 [ 0, %[[ENTRY_SPLIT_LDIST1]] ], [ [[ADD_LDIST1:%.*]], %[[IF_END_LDIST1:.*]] ]
; CHECK-NEXT:    [[ARRAYIDXD_LDIST1:%.*]] = getelementptr inbounds i32, ptr [[D]], i64 [[IND_LDIST1]]
; CHECK-NEXT:    [[LOADD_LDIST1:%.*]] = load i32, ptr [[ARRAYIDXD_LDIST1]], align 4
; CHECK-NEXT:    [[ARRAYIDXE_LDIST1:%.*]] = getelementptr inbounds i32, ptr [[E]], i64 [[IND_LDIST1]]
; CHECK-NEXT:    [[LOADE_LDIST1:%.*]] = load i32, ptr [[ARRAYIDXE_LDIST1]], align 4
; CHECK-NEXT:    [[MULC_LDIST1:%.*]] = mul i32 [[LOADD_LDIST1]], [[LOADE_LDIST1]]
; CHECK-NEXT:    [[ARRAYIDXC_LDIST1:%.*]] = getelementptr inbounds i32, ptr [[C]], i64 [[IND_LDIST1]]
; CHECK-NEXT:    store i32 [[MULC_LDIST1]], ptr [[ARRAYIDXC_LDIST1]], align 4
; CHECK-NEXT:    [[ADD_LDIST1]] = add nuw nsw i64 [[IND_LDIST1]], 1
; CHECK-NEXT:    [[IF_COND_LDIST1:%.*]] = icmp eq i64 [[IND_LDIST1]], [[X]]
; CHECK-NEXT:    br i1 [[IF_COND_LDIST1]], label %[[IF_THEN_LDIST1:.*]], label %[[IF_END_LDIST1]]
; CHECK:       [[IF_THEN_LDIST1]]:
; CHECK-NEXT:    br label %[[IF_END_LDIST1]]
; CHECK:       [[IF_END_LDIST1]]:
; CHECK-NEXT:    [[EXITCOND_LDIST1:%.*]] = icmp eq i64 [[ADD_LDIST1]], 20
; CHECK-NEXT:    br i1 [[EXITCOND_LDIST1]], label %[[ENTRY_SPLIT:.*]], label %[[FOR_BODY_LDIST1]]
; CHECK:       [[ENTRY_SPLIT]]:
; CHECK-NEXT:    br label %[[FOR_BODY:.*]]
; CHECK:       [[FOR_BODY]]:
; CHECK-NEXT:    [[IND:%.*]] = phi i64 [ 0, %[[ENTRY_SPLIT]] ], [ [[ADD:%.*]], %[[IF_END:.*]] ]
; CHECK-NEXT:    [[ARRAYIDXA:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[IND]]
; CHECK-NEXT:    [[LOADA:%.*]] = load i32, ptr [[ARRAYIDXA]], align 4
; CHECK-NEXT:    [[ARRAYIDXB:%.*]] = getelementptr inbounds i32, ptr [[B]], i64 [[IND]]
; CHECK-NEXT:    [[LOADB:%.*]] = load i32, ptr [[ARRAYIDXB]], align 4
; CHECK-NEXT:    [[MULA:%.*]] = mul i32 [[LOADB]], [[LOADA]]
; CHECK-NEXT:    [[ADD]] = add nuw nsw i64 [[IND]], 1
; CHECK-NEXT:    [[ARRAYIDXA_PLUS_4:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[ADD]]
; CHECK-NEXT:    store i32 [[MULA]], ptr [[ARRAYIDXA_PLUS_4]], align 4
; CHECK-NEXT:    [[IF_COND:%.*]] = icmp eq i64 [[IND]], [[X]]
; CHECK-NEXT:    br i1 [[IF_COND]], label %[[IF_THEN:.*]], label %[[IF_END]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    [[ARRAYIDXH:%.*]] = getelementptr inbounds i32, ptr [[H]], i64 [[IND]]
; CHECK-NEXT:    [[LOADH:%.*]] = load i32, ptr [[ARRAYIDXH]], align 4
; CHECK-NEXT:    [[ARRAYIDXJ:%.*]] = getelementptr inbounds i32, ptr [[J]], i64 [[IND]]
; CHECK-NEXT:    [[LOADJ:%.*]] = load i32, ptr [[ARRAYIDXJ]], align 4
; CHECK-NEXT:    [[MULG:%.*]] = mul i32 [[LOADH]], [[LOADJ]]
; CHECK-NEXT:    [[ARRAYIDXG:%.*]] = getelementptr inbounds i32, ptr [[G]], i64 [[IND]]
; CHECK-NEXT:    store i32 [[MULG]], ptr [[ARRAYIDXG]], align 4
; CHECK-NEXT:    br label %[[IF_END]]
; CHECK:       [[IF_END]]:
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[ADD]], 20
; CHECK-NEXT:    br i1 [[EXITCOND]], label %[[FOR_END:.*]], label %[[FOR_BODY]]
; CHECK:       [[FOR_END]]:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %ind = phi i64 [ 0, %entry ], [ %add, %if.end ]

  %arrayidxD = getelementptr inbounds i32, ptr %d, i64 %ind
  %loadD = load i32, ptr %arrayidxD, align 4

  %arrayidxE = getelementptr inbounds i32, ptr %e, i64 %ind
  %loadE = load i32, ptr %arrayidxE, align 4

  %mulC = mul i32 %loadD, %loadE

  %arrayidxC = getelementptr inbounds i32, ptr %c, i64 %ind
  store i32 %mulC, ptr %arrayidxC, align 4


  %arrayidxA = getelementptr inbounds i32, ptr %a, i64 %ind
  %loadA = load i32, ptr %arrayidxA, align 4

  %arrayidxB = getelementptr inbounds i32, ptr %b, i64 %ind
  %loadB = load i32, ptr %arrayidxB, align 4

  %mulA = mul i32 %loadB, %loadA

  %add = add nuw nsw i64 %ind, 1
  %arrayidxA_plus_4 = getelementptr inbounds i32, ptr %a, i64 %add
  store i32 %mulA, ptr %arrayidxA_plus_4, align 4

  %if.cond = icmp eq i64 %ind, %x
  br i1 %if.cond, label %if.then, label %if.end

if.then:
  %arrayidxH = getelementptr inbounds i32, ptr %h, i64 %ind
  %loadH = load i32, ptr %arrayidxH, align 4

  %arrayidxJ = getelementptr inbounds i32, ptr %j, i64 %ind
  %loadJ = load i32, ptr %arrayidxJ, align 4

  %mulG = mul i32 %loadH, %loadJ

  %arrayidxG = getelementptr inbounds i32, ptr %g, i64 %ind
  store i32 %mulG, ptr %arrayidxG, align 4
  br label %if.end

if.end:
  %exitcond = icmp eq i64 %add, 20
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}
