; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN:  sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v,+zvfh,+xsfvcp \
; RUN:    -verify-machineinstrs | FileCheck %s
; RUN:  sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v,+zvfh,+xsfvcp \
; RUN:    -verify-machineinstrs | FileCheck %s

define void @test_sf_vc_vv_se_e8mf8(<1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i8.nxv1i8.iXLen(iXLen 3, iXLen 31, <1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i8.nxv1i8.iXLen(iXLen, iXLen, <1 x i8>, <1 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8mf4(<2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i8.nxv2i8.iXLen(iXLen 3, iXLen 31, <2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i8.nxv2i8.iXLen(iXLen, iXLen, <2 x i8>, <2 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8mf2(<4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i8.nxv4i8.iXLen(iXLen 3, iXLen 31, <4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i8.nxv4i8.iXLen(iXLen, iXLen, <4 x i8>, <4 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8m1(<8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i8.nxv8i8.iXLen(iXLen 3, iXLen 31, <8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i8.nxv8i8.iXLen(iXLen, iXLen, <8 x i8>, <8 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8m2(<16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i8.nxv16i8.iXLen(iXLen 3, iXLen 31, <16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i8.nxv16i8.iXLen(iXLen, iXLen, <16 x i8>, <16 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8m4(<32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv32i8.nxv32i8.iXLen(iXLen 3, iXLen 31, <32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv32i8.nxv32i8.iXLen(iXLen, iXLen, <32 x i8>, <32 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8m8(<64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv64i8.nxv64i8.iXLen(iXLen 3, iXLen 31, <64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv64i8.nxv64i8.iXLen(iXLen, iXLen, <64 x i8>, <64 x i8>, iXLen)

define void @test_sf_vc_vv_se_e16mf4(<1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i16.nxv1i16.iXLen(iXLen 3, iXLen 31, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i16.nxv1i16.iXLen(iXLen, iXLen, <1 x i16>, <1 x i16>, iXLen)

define void @test_sf_vc_vv_se_e16mf2(<2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i16.nxv2i16.iXLen(iXLen 3, iXLen 31, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i16.nxv2i16.iXLen(iXLen, iXLen, <2 x i16>, <2 x i16>, iXLen)

define void @test_sf_vc_vv_se_e16m1(<4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i16.nxv4i16.iXLen(iXLen 3, iXLen 31, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i16.nxv4i16.iXLen(iXLen, iXLen, <4 x i16>, <4 x i16>, iXLen)

define void @test_sf_vc_vv_se_e16m2(<8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i16.nxv8i16.iXLen(iXLen 3, iXLen 31, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i16.nxv8i16.iXLen(iXLen, iXLen, <8 x i16>, <8 x i16>, iXLen)

define void @test_sf_vc_vv_se_e16m4(<16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i16.nxv16i16.iXLen(iXLen 3, iXLen 31, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i16.nxv16i16.iXLen(iXLen, iXLen, <16 x i16>, <16 x i16>, iXLen)

define void @test_sf_vc_vv_se_e16m8(<32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv32i16.nxv32i16.iXLen(iXLen 3, iXLen 31, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv32i16.nxv32i16.iXLen(iXLen, iXLen, <32 x i16>, <32 x i16>, iXLen)

define void @test_sf_vc_vv_se_e32mf2(<1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i32.nxv1i32.iXLen(iXLen 3, iXLen 31, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i32.nxv1i32.iXLen(iXLen, iXLen, <1 x i32>, <1 x i32>, iXLen)

define void @test_sf_vc_vv_se_e32m1(<2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i32.nxv2i32.iXLen(iXLen 3, iXLen 31, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i32.nxv2i32.iXLen(iXLen, iXLen, <2 x i32>, <2 x i32>, iXLen)

define void @test_sf_vc_vv_se_e32m2(<4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i32.nxv4i32.iXLen(iXLen 3, iXLen 31, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i32.nxv4i32.iXLen(iXLen, iXLen, <4 x i32>, <4 x i32>, iXLen)

define void @test_sf_vc_vv_se_e32m4(<8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i32.nxv8i32.iXLen(iXLen 3, iXLen 31, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i32.nxv8i32.iXLen(iXLen, iXLen, <8 x i32>, <8 x i32>, iXLen)

define void @test_sf_vc_vv_se_e32m8(<16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i32.nxv16i32.iXLen(iXLen 3, iXLen 31, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i32.nxv16i32.iXLen(iXLen, iXLen, <16 x i32>, <16 x i32>, iXLen)

define void @test_sf_vc_vv_se_e64m1(<1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i64.nxv1i64.iXLen(iXLen 3, iXLen 31, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i64.nxv1i64.iXLen(iXLen, iXLen, <1 x i64>, <1 x i64>, iXLen)

define void @test_sf_vc_vv_se_e64m2(<2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i64.nxv2i64.iXLen(iXLen 3, iXLen 31, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i64.nxv2i64.iXLen(iXLen, iXLen, <2 x i64>, <2 x i64>, iXLen)

define void @test_sf_vc_vv_se_e64m4(<4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i64.nxv4i64.iXLen(iXLen 3, iXLen 31, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i64.nxv4i64.iXLen(iXLen, iXLen, <4 x i64>, <4 x i64>, iXLen)

define void @test_sf_vc_vv_se_e64m8(<8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i64.nxv8i64.iXLen(iXLen 3, iXLen 31, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i64.nxv8i64.iXLen(iXLen, iXLen, <8 x i64>, <8 x i64>, iXLen)

define <1 x i8> @test_sf_vc_v_vv_se_e8mf8(<1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv1i8.iXLen.nxv1i8.iXLen(iXLen 3, <1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv1i8.iXLen.nxv1i8.iXLen(iXLen, <1 x i8>, <1 x i8>, iXLen)

define <2 x i8> @test_sf_vc_v_vv_se_e8mf4(<2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv2i8.iXLen.nxv2i8.iXLen(iXLen 3, <2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv2i8.iXLen.nxv2i8.iXLen(iXLen, <2 x i8>, <2 x i8>, iXLen)

define <4 x i8> @test_sf_vc_v_vv_se_e8mf2(<4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv4i8.iXLen.nxv4i8.iXLen(iXLen 3, <4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv4i8.iXLen.nxv4i8.iXLen(iXLen, <4 x i8>, <4 x i8>, iXLen)

define <8 x i8> @test_sf_vc_v_vv_se_e8m1(<8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv8i8.iXLen.nxv8i8.iXLen(iXLen 3, <8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv8i8.iXLen.nxv8i8.iXLen(iXLen, <8 x i8>, <8 x i8>, iXLen)

define <16 x i8> @test_sf_vc_v_vv_se_e8m2(<16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv16i8.iXLen.nxv16i8.iXLen(iXLen 3, <16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv16i8.iXLen.nxv16i8.iXLen(iXLen, <16 x i8>, <16 x i8>, iXLen)

define <32 x i8> @test_sf_vc_v_vv_se_e8m4(<32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv32i8.iXLen.nxv32i8.iXLen(iXLen 3, <32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv32i8.iXLen.nxv32i8.iXLen(iXLen, <32 x i8>, <32 x i8>, iXLen)

define <64 x i8> @test_sf_vc_v_vv_se_e8m8(<64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv64i8.iXLen.nxv64i8.iXLen(iXLen 3, <64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv64i8.iXLen.nxv64i8.iXLen(iXLen, <64 x i8>, <64 x i8>, iXLen)

define <1 x i16> @test_sf_vc_v_vv_se_e16mf4(<1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv1i16.iXLen.nxv1i16.iXLen(iXLen 3, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv1i16.iXLen.nxv1i16.iXLen(iXLen, <1 x i16>, <1 x i16>, iXLen)

define <2 x i16> @test_sf_vc_v_vv_se_e16mf2(<2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv2i16.iXLen.nxv2i16.iXLen(iXLen 3, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv2i16.iXLen.nxv2i16.iXLen(iXLen, <2 x i16>, <2 x i16>, iXLen)

define <4 x i16> @test_sf_vc_v_vv_se_e16m1(<4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv4i16.iXLen.nxv4i16.iXLen(iXLen 3, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv4i16.iXLen.nxv4i16.iXLen(iXLen, <4 x i16>, <4 x i16>, iXLen)

define <8 x i16> @test_sf_vc_v_vv_se_e16m2(<8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv8i16.iXLen.nxv8i16.iXLen(iXLen 3, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv8i16.iXLen.nxv8i16.iXLen(iXLen, <8 x i16>, <8 x i16>, iXLen)

define <16 x i16> @test_sf_vc_v_vv_se_e16m4(<16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv16i16.iXLen.nxv16i16.iXLen(iXLen 3, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv16i16.iXLen.nxv16i16.iXLen(iXLen, <16 x i16>, <16 x i16>, iXLen)

define <32 x i16> @test_sf_vc_v_vv_se_e16m8(<32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv32i16.iXLen.nxv32i16.iXLen(iXLen 3, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv32i16.iXLen.nxv32i16.iXLen(iXLen, <32 x i16>, <32 x i16>, iXLen)

define <1 x i32> @test_sf_vc_v_vv_se_e32mf2(<1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv1i32.iXLen.nxv1i32.iXLen(iXLen 3, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv1i32.iXLen.nxv1i32.iXLen(iXLen, <1 x i32>, <1 x i32>, iXLen)

define <2 x i32> @test_sf_vc_v_vv_se_e32m1(<2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv2i32.iXLen.nxv2i32.iXLen(iXLen 3, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv2i32.iXLen.nxv2i32.iXLen(iXLen, <2 x i32>, <2 x i32>, iXLen)

define <4 x i32> @test_sf_vc_v_vv_se_e32m2(<4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv4i32.iXLen.nxv4i32.iXLen(iXLen 3, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv4i32.iXLen.nxv4i32.iXLen(iXLen, <4 x i32>, <4 x i32>, iXLen)

define <8 x i32> @test_sf_vc_v_vv_se_e32m4(<8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv8i32.iXLen.nxv8i32.iXLen(iXLen 3, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv8i32.iXLen.nxv8i32.iXLen(iXLen, <8 x i32>, <8 x i32>, iXLen)

define <16 x i32> @test_sf_vc_v_vv_se_e32m8(<16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv16i32.iXLen.nxv16i32.iXLen(iXLen 3, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv16i32.iXLen.nxv16i32.iXLen(iXLen, <16 x i32>, <16 x i32>, iXLen)

define <1 x i64> @test_sf_vc_v_vv_se_e64m1(<1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv1i64.iXLen.nxv1i64.iXLen(iXLen 3, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl)
  ret <1 x i64> %0
}

declare <1 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv1i64.iXLen.nxv1i64.iXLen(iXLen, <1 x i64>, <1 x i64>, iXLen)

define <2 x i64> @test_sf_vc_v_vv_se_e64m2(<2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv2i64.iXLen.nxv2i64.iXLen(iXLen 3, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl)
  ret <2 x i64> %0
}

declare <2 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv2i64.iXLen.nxv2i64.iXLen(iXLen, <2 x i64>, <2 x i64>, iXLen)

define <4 x i64> @test_sf_vc_v_vv_se_e64m4(<4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv4i64.iXLen.nxv4i64.iXLen(iXLen 3, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl)
  ret <4 x i64> %0
}

declare <4 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv4i64.iXLen.nxv4i64.iXLen(iXLen, <4 x i64>, <4 x i64>, iXLen)

define <8 x i64> @test_sf_vc_v_vv_se_e64m8(<8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv8i64.iXLen.nxv8i64.iXLen(iXLen 3, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl)
  ret <8 x i64> %0
}

declare <8 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv8i64.iXLen.nxv8i64.iXLen(iXLen, <8 x i64>, <8 x i64>, iXLen)

define <1 x i8> @test_sf_vc_v_vv_e8mf8(<1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.vv.nxv1i8.iXLen.nxv1i8.iXLen(iXLen 3, <1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.vv.nxv1i8.iXLen.nxv1i8.iXLen(iXLen, <1 x i8>, <1 x i8>, iXLen)

define <2 x i8> @test_sf_vc_v_vv_e8mf4(<2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.vv.nxv2i8.iXLen.nxv2i8.iXLen(iXLen 3, <2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.vv.nxv2i8.iXLen.nxv2i8.iXLen(iXLen, <2 x i8>, <2 x i8>, iXLen)

define <4 x i8> @test_sf_vc_v_vv_e8mf2(<4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.vv.nxv4i8.iXLen.nxv4i8.iXLen(iXLen 3, <4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.vv.nxv4i8.iXLen.nxv4i8.iXLen(iXLen, <4 x i8>, <4 x i8>, iXLen)

define <8 x i8> @test_sf_vc_v_vv_e8m1(<8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.vv.nxv8i8.iXLen.nxv8i8.iXLen(iXLen 3, <8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.vv.nxv8i8.iXLen.nxv8i8.iXLen(iXLen, <8 x i8>, <8 x i8>, iXLen)

define <16 x i8> @test_sf_vc_v_vv_e8m2(<16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.vv.nxv16i8.iXLen.nxv16i8.iXLen(iXLen 3, <16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.vv.nxv16i8.iXLen.nxv16i8.iXLen(iXLen, <16 x i8>, <16 x i8>, iXLen)

define <32 x i8> @test_sf_vc_v_vv_e8m4(<32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.vv.nxv32i8.iXLen.nxv32i8.iXLen(iXLen 3, <32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.vv.nxv32i8.iXLen.nxv32i8.iXLen(iXLen, <32 x i8>, <32 x i8>, iXLen)

define <64 x i8> @test_sf_vc_v_vv_e8m8(<64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.vv.nxv64i8.iXLen.nxv64i8.iXLen(iXLen 3, <64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.vv.nxv64i8.iXLen.nxv64i8.iXLen(iXLen, <64 x i8>, <64 x i8>, iXLen)

define <1 x i16> @test_sf_vc_v_vv_e16mf4(<1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.vv.nxv1i16.iXLen.nxv1i16.iXLen(iXLen 3, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.vv.nxv1i16.iXLen.nxv1i16.iXLen(iXLen, <1 x i16>, <1 x i16>, iXLen)

define <2 x i16> @test_sf_vc_v_vv_e16mf2(<2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.vv.nxv2i16.iXLen.nxv2i16.iXLen(iXLen 3, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.vv.nxv2i16.iXLen.nxv2i16.iXLen(iXLen, <2 x i16>, <2 x i16>, iXLen)

define <4 x i16> @test_sf_vc_v_vv_e16m1(<4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.vv.nxv4i16.iXLen.nxv4i16.iXLen(iXLen 3, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.vv.nxv4i16.iXLen.nxv4i16.iXLen(iXLen, <4 x i16>, <4 x i16>, iXLen)

define <8 x i16> @test_sf_vc_v_vv_e16m2(<8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.vv.nxv8i16.iXLen.nxv8i16.iXLen(iXLen 3, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.vv.nxv8i16.iXLen.nxv8i16.iXLen(iXLen, <8 x i16>, <8 x i16>, iXLen)

define <16 x i16> @test_sf_vc_v_vv_e16m4(<16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.vv.nxv16i16.iXLen.nxv16i16.iXLen(iXLen 3, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.vv.nxv16i16.iXLen.nxv16i16.iXLen(iXLen, <16 x i16>, <16 x i16>, iXLen)

define <32 x i16> @test_sf_vc_v_vv_e16m8(<32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.vv.nxv32i16.iXLen.nxv32i16.iXLen(iXLen 3, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.vv.nxv32i16.iXLen.nxv32i16.iXLen(iXLen, <32 x i16>, <32 x i16>, iXLen)

define <1 x i32> @test_sf_vc_v_vv_e32mf2(<1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.vv.nxv1i32.iXLen.nxv1i32.iXLen(iXLen 3, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.vv.nxv1i32.iXLen.nxv1i32.iXLen(iXLen, <1 x i32>, <1 x i32>, iXLen)

define <2 x i32> @test_sf_vc_v_vv_e32m1(<2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.vv.nxv2i32.iXLen.nxv2i32.iXLen(iXLen 3, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.vv.nxv2i32.iXLen.nxv2i32.iXLen(iXLen, <2 x i32>, <2 x i32>, iXLen)

define <4 x i32> @test_sf_vc_v_vv_e32m2(<4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.vv.nxv4i32.iXLen.nxv4i32.iXLen(iXLen 3, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.vv.nxv4i32.iXLen.nxv4i32.iXLen(iXLen, <4 x i32>, <4 x i32>, iXLen)

define <8 x i32> @test_sf_vc_v_vv_e32m4(<8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.vv.nxv8i32.iXLen.nxv8i32.iXLen(iXLen 3, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.vv.nxv8i32.iXLen.nxv8i32.iXLen(iXLen, <8 x i32>, <8 x i32>, iXLen)

define <16 x i32> @test_sf_vc_v_vv_e32m8(<16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.vv.nxv16i32.iXLen.nxv16i32.iXLen(iXLen 3, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.vv.nxv16i32.iXLen.nxv16i32.iXLen(iXLen, <16 x i32>, <16 x i32>, iXLen)

define <1 x i64> @test_sf_vc_v_vv_e64m1(<1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i64> @llvm.riscv.sf.vc.v.vv.nxv1i64.iXLen.nxv1i64.iXLen(iXLen 3, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl)
  ret <1 x i64> %0
}

declare <1 x i64> @llvm.riscv.sf.vc.v.vv.nxv1i64.iXLen.nxv1i64.iXLen(iXLen, <1 x i64>, <1 x i64>, iXLen)

define <2 x i64> @test_sf_vc_v_vv_e64m2(<2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> @llvm.riscv.sf.vc.v.vv.nxv2i64.iXLen.nxv2i64.iXLen(iXLen 3, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl)
  ret <2 x i64> %0
}

declare <2 x i64> @llvm.riscv.sf.vc.v.vv.nxv2i64.iXLen.nxv2i64.iXLen(iXLen, <2 x i64>, <2 x i64>, iXLen)

define <4 x i64> @test_sf_vc_v_vv_e64m4(<4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i64> @llvm.riscv.sf.vc.v.vv.nxv4i64.iXLen.nxv4i64.iXLen(iXLen 3, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl)
  ret <4 x i64> %0
}

declare <4 x i64> @llvm.riscv.sf.vc.v.vv.nxv4i64.iXLen.nxv4i64.iXLen(iXLen, <4 x i64>, <4 x i64>, iXLen)

define <8 x i64> @test_sf_vc_v_vv_e64m8(<8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i64> @llvm.riscv.sf.vc.v.vv.nxv8i64.iXLen.nxv8i64.iXLen(iXLen 3, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl)
  ret <8 x i64> %0
}

declare <8 x i64> @llvm.riscv.sf.vc.v.vv.nxv8i64.iXLen.nxv8i64.iXLen(iXLen, <8 x i64>, <8 x i64>, iXLen)

define void @test_sf_vc_xv_se_e8mf8(<1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i8.i8.iXLen(iXLen 3, iXLen 31, <1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i8.i8.iXLen(iXLen, iXLen, <1 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8mf4(<2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i8.i8.iXLen(iXLen 3, iXLen 31, <2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i8.i8.iXLen(iXLen, iXLen, <2 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8mf2(<4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i8.i8.iXLen(iXLen 3, iXLen 31, <4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i8.i8.iXLen(iXLen, iXLen, <4 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8m1(<8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i8.i8.iXLen(iXLen 3, iXLen 31, <8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i8.i8.iXLen(iXLen, iXLen, <8 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8m2(<16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i8.i8.iXLen(iXLen 3, iXLen 31, <16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i8.i8.iXLen(iXLen, iXLen, <16 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8m4(<32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv32i8.i8.iXLen(iXLen 3, iXLen 31, <32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv32i8.i8.iXLen(iXLen, iXLen, <32 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8m8(<64 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv64i8.i8.iXLen(iXLen 3, iXLen 31, <64 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv64i8.i8.iXLen(iXLen, iXLen, <64 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e16mf4(<1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i16.i16.iXLen(iXLen 3, iXLen 31, <1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i16.i16.iXLen(iXLen, iXLen, <1 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e16mf2(<2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i16.i16.iXLen(iXLen 3, iXLen 31, <2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i16.i16.iXLen(iXLen, iXLen, <2 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e16m1(<4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i16.i16.iXLen(iXLen 3, iXLen 31, <4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i16.i16.iXLen(iXLen, iXLen, <4 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e16m2(<8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i16.i16.iXLen(iXLen 3, iXLen 31, <8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i16.i16.iXLen(iXLen, iXLen, <8 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e16m4(<16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i16.i16.iXLen(iXLen 3, iXLen 31, <16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i16.i16.iXLen(iXLen, iXLen, <16 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e16m8(<32 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv32i16.i16.iXLen(iXLen 3, iXLen 31, <32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv32i16.i16.iXLen(iXLen, iXLen, <32 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e32mf2(<1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i32.i32.iXLen(iXLen 3, iXLen 31, <1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i32.i32.iXLen(iXLen, iXLen, <1 x i32>, i32, iXLen)

define void @test_sf_vc_xv_se_e32m1(<2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i32.i32.iXLen(iXLen 3, iXLen 31, <2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i32.i32.iXLen(iXLen, iXLen, <2 x i32>, i32, iXLen)

define void @test_sf_vc_xv_se_e32m2(<4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i32.i32.iXLen(iXLen 3, iXLen 31, <4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i32.i32.iXLen(iXLen, iXLen, <4 x i32>, i32, iXLen)

define void @test_sf_vc_xv_se_e32m4(<8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i32.i32.iXLen(iXLen 3, iXLen 31, <8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i32.i32.iXLen(iXLen, iXLen, <8 x i32>, i32, iXLen)

define void @test_sf_vc_xv_se_e32m8(<16 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i32.i32.iXLen(iXLen 3, iXLen 31, <16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i32.i32.iXLen(iXLen, iXLen, <16 x i32>, i32, iXLen)

define <1 x i8> @test_sf_vc_v_xv_se_e8mf8(<1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv1i8.iXLen.i8.iXLen(iXLen 3, <1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv1i8.iXLen.i8.iXLen(iXLen, <1 x i8>, i8, iXLen)

define <2 x i8> @test_sf_vc_v_xv_se_e8mf4(<2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv2i8.iXLen.i8.iXLen(iXLen 3, <2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv2i8.iXLen.i8.iXLen(iXLen, <2 x i8>, i8, iXLen)

define <4 x i8> @test_sf_vc_v_xv_se_e8mf2(<4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv4i8.iXLen.i8.iXLen(iXLen 3, <4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv4i8.iXLen.i8.iXLen(iXLen, <4 x i8>, i8, iXLen)

define <8 x i8> @test_sf_vc_v_xv_se_e8m1(<8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv8i8.iXLen.i8.iXLen(iXLen 3, <8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv8i8.iXLen.i8.iXLen(iXLen, <8 x i8>, i8, iXLen)

define <16 x i8> @test_sf_vc_v_xv_se_e8m2(<16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv16i8.iXLen.i8.iXLen(iXLen 3, <16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv16i8.iXLen.i8.iXLen(iXLen, <16 x i8>, i8, iXLen)

define <32 x i8> @test_sf_vc_v_xv_se_e8m4(<32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv32i8.iXLen.i8.iXLen(iXLen 3, <32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv32i8.iXLen.i8.iXLen(iXLen, <32 x i8>, i8, iXLen)

define <64 x i8> @test_sf_vc_v_xv_se_e8m8(<64 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv64i8.iXLen.i8.iXLen(iXLen 3, <64 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv64i8.iXLen.i8.iXLen(iXLen, <64 x i8>, i8, iXLen)

define <1 x i16> @test_sf_vc_v_xv_se_e16mf4(<1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv1i16.iXLen.i16.iXLen(iXLen 3, <1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv1i16.iXLen.i16.iXLen(iXLen, <1 x i16>, i16, iXLen)

define <2 x i16> @test_sf_vc_v_xv_se_e16mf2(<2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv2i16.iXLen.i16.iXLen(iXLen 3, <2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv2i16.iXLen.i16.iXLen(iXLen, <2 x i16>, i16, iXLen)

define <4 x i16> @test_sf_vc_v_xv_se_e16m1(<4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv4i16.iXLen.i16.iXLen(iXLen 3, <4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv4i16.iXLen.i16.iXLen(iXLen, <4 x i16>, i16, iXLen)

define <8 x i16> @test_sf_vc_v_xv_se_e16m2(<8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv8i16.iXLen.i16.iXLen(iXLen 3, <8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv8i16.iXLen.i16.iXLen(iXLen, <8 x i16>, i16, iXLen)

define <16 x i16> @test_sf_vc_v_xv_se_e16m4(<16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv16i16.iXLen.i16.iXLen(iXLen 3, <16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv16i16.iXLen.i16.iXLen(iXLen, <16 x i16>, i16, iXLen)

define <32 x i16> @test_sf_vc_v_xv_se_e16m8(<32 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv32i16.iXLen.i16.iXLen(iXLen 3, <32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv32i16.iXLen.i16.iXLen(iXLen, <32 x i16>, i16, iXLen)

define <1 x i32> @test_sf_vc_v_xv_se_e32mf2(<1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv1i32.i32.i32.iXLen(iXLen 3, <1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv1i32.i32.i32.iXLen(iXLen, <1 x i32>, i32, iXLen)

define <2 x i32> @test_sf_vc_v_xv_se_e32m1(<2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv2i32.i32.i32.iXLen(iXLen 3, <2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv2i32.i32.i32.iXLen(iXLen, <2 x i32>, i32, iXLen)

define <4 x i32> @test_sf_vc_v_xv_se_e32m2(<4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv4i32.i32.i32.iXLen(iXLen 3, <4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv4i32.i32.i32.iXLen(iXLen, <4 x i32>, i32, iXLen)

define <8 x i32> @test_sf_vc_v_xv_se_e32m4(<8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv8i32.i32.i32.iXLen(iXLen 3, <8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv8i32.i32.i32.iXLen(iXLen, <8 x i32>, i32, iXLen)

define <16 x i32> @test_sf_vc_v_xv_se_e32m8(<16 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv16i32.i32.i32.iXLen(iXLen 3, <16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv16i32.i32.i32.iXLen(iXLen, <16 x i32>, i32, iXLen)

define <1 x i8> @test_sf_vc_v_xv_e8mf8(<1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.xv.nxv1i8.iXLen.i8.iXLen(iXLen 3, <1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.xv.nxv1i8.iXLen.i8.iXLen(iXLen, <1 x i8>, i8, iXLen)

define <2 x i8> @test_sf_vc_v_xv_e8mf4(<2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.xv.nxv2i8.iXLen.i8.iXLen(iXLen 3, <2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.xv.nxv2i8.iXLen.i8.iXLen(iXLen, <2 x i8>, i8, iXLen)

define <4 x i8> @test_sf_vc_v_xv_e8mf2(<4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.xv.nxv4i8.iXLen.i8.iXLen(iXLen 3, <4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.xv.nxv4i8.iXLen.i8.iXLen(iXLen, <4 x i8>, i8, iXLen)

define <8 x i8> @test_sf_vc_v_xv_e8m1(<8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.xv.nxv8i8.iXLen.i8.iXLen(iXLen 3, <8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.xv.nxv8i8.iXLen.i8.iXLen(iXLen, <8 x i8>, i8, iXLen)

define <16 x i8> @test_sf_vc_v_xv_e8m2(<16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.xv.nxv16i8.iXLen.i8.iXLen(iXLen 3, <16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.xv.nxv16i8.iXLen.i8.iXLen(iXLen, <16 x i8>, i8, iXLen)

define <32 x i8> @test_sf_vc_v_xv_e8m4(<32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.xv.nxv32i8.iXLen.i8.iXLen(iXLen 3, <32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.xv.nxv32i8.iXLen.i8.iXLen(iXLen, <32 x i8>, i8, iXLen)

define <64 x i8> @test_sf_vc_v_xv_e8m8(<64 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.xv.nxv64i8.iXLen.i8.iXLen(iXLen 3, <64 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.xv.nxv64i8.iXLen.i8.iXLen(iXLen, <64 x i8>, i8, iXLen)

define <1 x i16> @test_sf_vc_v_xv_e16mf4(<1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.xv.nxv1i16.iXLen.i16.iXLen(iXLen 3, <1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.xv.nxv1i16.iXLen.i16.iXLen(iXLen, <1 x i16>, i16, iXLen)

define <2 x i16> @test_sf_vc_v_xv_e16mf2(<2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.xv.nxv2i16.iXLen.i16.iXLen(iXLen 3, <2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.xv.nxv2i16.iXLen.i16.iXLen(iXLen, <2 x i16>, i16, iXLen)

define <4 x i16> @test_sf_vc_v_xv_e16m1(<4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.xv.nxv4i16.iXLen.i16.iXLen(iXLen 3, <4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.xv.nxv4i16.iXLen.i16.iXLen(iXLen, <4 x i16>, i16, iXLen)

define <8 x i16> @test_sf_vc_v_xv_e16m2(<8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.xv.nxv8i16.iXLen.i16.iXLen(iXLen 3, <8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.xv.nxv8i16.iXLen.i16.iXLen(iXLen, <8 x i16>, i16, iXLen)

define <16 x i16> @test_sf_vc_v_xv_e16m4(<16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.xv.nxv16i16.iXLen.i16.iXLen(iXLen 3, <16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.xv.nxv16i16.iXLen.i16.iXLen(iXLen, <16 x i16>, i16, iXLen)

define <32 x i16> @test_sf_vc_v_xv_e16m8(<32 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.xv.nxv32i16.iXLen.i16.iXLen(iXLen 3, <32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.xv.nxv32i16.iXLen.i16.iXLen(iXLen, <32 x i16>, i16, iXLen)

define <1 x i32> @test_sf_vc_v_xv_e32mf2(<1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.xv.nxv1i32.i32.i32.iXLen(iXLen 3, <1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.xv.nxv1i32.i32.i32.iXLen(iXLen, <1 x i32>, i32, iXLen)

define <2 x i32> @test_sf_vc_v_xv_e32m1(<2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.xv.nxv2i32.i32.i32.iXLen(iXLen 3, <2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.xv.nxv2i32.i32.i32.iXLen(iXLen, <2 x i32>, i32, iXLen)

define <4 x i32> @test_sf_vc_v_xv_e32m2(<4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.xv.nxv4i32.i32.i32.iXLen(iXLen 3, <4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.xv.nxv4i32.i32.i32.iXLen(iXLen, <4 x i32>, i32, iXLen)

define <8 x i32> @test_sf_vc_v_xv_e32m4(<8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.xv.nxv8i32.i32.i32.iXLen(iXLen 3, <8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.xv.nxv8i32.i32.i32.iXLen(iXLen, <8 x i32>, i32, iXLen)

define <16 x i32> @test_sf_vc_v_xv_e32m8(<16 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.xv.nxv16i32.i32.i32.iXLen(iXLen 3, <16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.xv.nxv16i32.i32.i32.iXLen(iXLen, <16 x i32>, i32, iXLen)

define void @test_sf_vc_iv_se_e8mf8(<1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i8.iXLen.iXLen(iXLen 3, iXLen 31, <1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i8.iXLen.iXLen(iXLen, iXLen, <1 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8mf4(<2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i8.iXLen.iXLen(iXLen 3, iXLen 31, <2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i8.iXLen.iXLen(iXLen, iXLen, <2 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8mf2(<4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i8.iXLen.iXLen(iXLen 3, iXLen 31, <4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i8.iXLen.iXLen(iXLen, iXLen, <4 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8m1(<8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i8.iXLen.iXLen(iXLen 3, iXLen 31, <8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i8.iXLen.iXLen(iXLen, iXLen, <8 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8m2(<16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i8.iXLen.iXLen(iXLen 3, iXLen 31, <16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i8.iXLen.iXLen(iXLen, iXLen, <16 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8m4(<32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv32i8.iXLen.iXLen(iXLen 3, iXLen 31, <32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv32i8.iXLen.iXLen(iXLen, iXLen, <32 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8m8(<64 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv64i8.iXLen.iXLen(iXLen 3, iXLen 31, <64 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv64i8.iXLen.iXLen(iXLen, iXLen, <64 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16mf4(<1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i16.iXLen.iXLen(iXLen 3, iXLen 31, <1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i16.iXLen.iXLen(iXLen, iXLen, <1 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16mf2(<2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i16.iXLen.iXLen(iXLen 3, iXLen 31, <2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i16.iXLen.iXLen(iXLen, iXLen, <2 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16m1(<4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i16.iXLen.iXLen(iXLen 3, iXLen 31, <4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i16.iXLen.iXLen(iXLen, iXLen, <4 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16m2(<8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i16.iXLen.iXLen(iXLen 3, iXLen 31, <8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i16.iXLen.iXLen(iXLen, iXLen, <8 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16m4(<16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i16.iXLen.iXLen(iXLen 3, iXLen 31, <16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i16.iXLen.iXLen(iXLen, iXLen, <16 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16m8(<32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv32i16.iXLen.iXLen(iXLen 3, iXLen 31, <32 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv32i16.iXLen.iXLen(iXLen, iXLen, <32 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e32mf2(<1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i32.iXLen.iXLen(iXLen 3, iXLen 31, <1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i32.iXLen.iXLen(iXLen, iXLen, <1 x i32>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e32m1(<2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i32.iXLen.iXLen(iXLen 3, iXLen 31, <2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i32.iXLen.iXLen(iXLen, iXLen, <2 x i32>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e32m2(<4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i32.iXLen.iXLen(iXLen 3, iXLen 31, <4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i32.iXLen.iXLen(iXLen, iXLen, <4 x i32>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e32m4(<8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i32.iXLen.iXLen(iXLen 3, iXLen 31, <8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i32.iXLen.iXLen(iXLen, iXLen, <8 x i32>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e32m8(<16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i32.iXLen.iXLen(iXLen 3, iXLen 31, <16 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i32.iXLen.iXLen(iXLen, iXLen, <16 x i32>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e64m1(<1 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i64.iXLen.iXLen(iXLen 3, iXLen 31, <1 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i64.iXLen.iXLen(iXLen, iXLen, <1 x i64>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e64m2(<2 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i64.iXLen.iXLen(iXLen 3, iXLen 31, <2 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i64.iXLen.iXLen(iXLen, iXLen, <2 x i64>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e64m4(<4 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i64.iXLen.iXLen(iXLen 3, iXLen 31, <4 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i64.iXLen.iXLen(iXLen, iXLen, <4 x i64>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e64m8(<8 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i64.iXLen.iXLen(iXLen 3, iXLen 31, <8 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i64.iXLen.iXLen(iXLen, iXLen, <8 x i64>, iXLen, iXLen)

define <1 x i8> @test_sf_vc_v_iv_se_e8mf8(<1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv1i8.iXLen.iXLen.iXLen(iXLen 3, <1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv1i8.iXLen.iXLen.iXLen(iXLen, <1 x i8>, iXLen, iXLen)

define <2 x i8> @test_sf_vc_v_iv_se_e8mf4(<2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv2i8.iXLen.iXLen.iXLen(iXLen 3, <2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv2i8.iXLen.iXLen.iXLen(iXLen, <2 x i8>, iXLen, iXLen)

define <4 x i8> @test_sf_vc_v_iv_se_e8mf2(<4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv4i8.iXLen.iXLen.iXLen(iXLen 3, <4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv4i8.iXLen.iXLen.iXLen(iXLen, <4 x i8>, iXLen, iXLen)

define <8 x i8> @test_sf_vc_v_iv_se_e8m1(<8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv8i8.iXLen.iXLen.iXLen(iXLen 3, <8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv8i8.iXLen.iXLen.iXLen(iXLen, <8 x i8>, iXLen, iXLen)

define <16 x i8> @test_sf_vc_v_iv_se_e8m2(<16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv16i8.iXLen.iXLen.iXLen(iXLen 3, <16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv16i8.iXLen.iXLen.iXLen(iXLen, <16 x i8>, iXLen, iXLen)

define <32 x i8> @test_sf_vc_v_iv_se_e8m4(<32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv32i8.iXLen.iXLen.iXLen(iXLen 3, <32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv32i8.iXLen.iXLen.iXLen(iXLen, <32 x i8>, iXLen, iXLen)

define <64 x i8> @test_sf_vc_v_iv_se_e8m8(<64 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv64i8.iXLen.iXLen.iXLen(iXLen 3, <64 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv64i8.iXLen.iXLen.iXLen(iXLen, <64 x i8>, iXLen, iXLen)

define <1 x i16> @test_sf_vc_v_iv_se_e16mf4(<1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv1i16.iXLen.iXLen.iXLen(iXLen 3, <1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv1i16.iXLen.iXLen.iXLen(iXLen, <1 x i16>, iXLen, iXLen)

define <2 x i16> @test_sf_vc_v_iv_se_e16mf2(<2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv2i16.iXLen.iXLen.iXLen(iXLen 3, <2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv2i16.iXLen.iXLen.iXLen(iXLen, <2 x i16>, iXLen, iXLen)

define <4 x i16> @test_sf_vc_v_iv_se_e16m1(<4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv4i16.iXLen.iXLen.iXLen(iXLen 3, <4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv4i16.iXLen.iXLen.iXLen(iXLen, <4 x i16>, iXLen, iXLen)

define <8 x i16> @test_sf_vc_v_iv_se_e16m2(<8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv8i16.iXLen.iXLen.iXLen(iXLen 3, <8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv8i16.iXLen.iXLen.iXLen(iXLen, <8 x i16>, iXLen, iXLen)

define <16 x i16> @test_sf_vc_v_iv_se_e16m4(<16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv16i16.iXLen.iXLen.iXLen(iXLen 3, <16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv16i16.iXLen.iXLen.iXLen(iXLen, <16 x i16>, iXLen, iXLen)

define <32 x i16> @test_sf_vc_v_iv_se_e16m8(<32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv32i16.iXLen.iXLen.iXLen(iXLen 3, <32 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv32i16.iXLen.iXLen.iXLen(iXLen, <32 x i16>, iXLen, iXLen)

define <1 x i32> @test_sf_vc_v_iv_se_e32mf2(<1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv1i32.iXLen.iXLen.iXLen(iXLen 3, <1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv1i32.iXLen.iXLen.iXLen(iXLen, <1 x i32>, iXLen, iXLen)

define <2 x i32> @test_sf_vc_v_iv_se_e32m1(<2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv2i32.iXLen.iXLen.iXLen(iXLen 3, <2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv2i32.iXLen.iXLen.iXLen(iXLen, <2 x i32>, iXLen, iXLen)

define <4 x i32> @test_sf_vc_v_iv_se_e32m2(<4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv4i32.iXLen.iXLen.iXLen(iXLen 3, <4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv4i32.iXLen.iXLen.iXLen(iXLen, <4 x i32>, iXLen, iXLen)

define <8 x i32> @test_sf_vc_v_iv_se_e32m4(<8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv8i32.iXLen.iXLen.iXLen(iXLen 3, <8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv8i32.iXLen.iXLen.iXLen(iXLen, <8 x i32>, iXLen, iXLen)

define <16 x i32> @test_sf_vc_v_iv_se_e32m8(<16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv16i32.iXLen.iXLen.iXLen(iXLen 3, <16 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv16i32.iXLen.iXLen.iXLen(iXLen, <16 x i32>, iXLen, iXLen)

define <1 x i64> @test_sf_vc_v_iv_se_e64m1(<1 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv1i64.iXLen.iXLen.iXLen(iXLen 3, <1 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i64> %0
}

declare <1 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv1i64.iXLen.iXLen.iXLen(iXLen, <1 x i64>, iXLen, iXLen)

define <2 x i64> @test_sf_vc_v_iv_se_e64m2(<2 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv2i64.iXLen.iXLen.iXLen(iXLen 3, <2 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i64> %0
}

declare <2 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv2i64.iXLen.iXLen.iXLen(iXLen, <2 x i64>, iXLen, iXLen)

define <4 x i64> @test_sf_vc_v_iv_se_e64m4(<4 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv4i64.iXLen.iXLen.iXLen(iXLen 3, <4 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i64> %0
}

declare <4 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv4i64.iXLen.iXLen.iXLen(iXLen, <4 x i64>, iXLen, iXLen)

define <8 x i64> @test_sf_vc_v_iv_se_e64m8(<8 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv8i64.iXLen.iXLen.iXLen(iXLen 3, <8 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i64> %0
}

declare <8 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv8i64.iXLen.iXLen.iXLen(iXLen, <8 x i64>, iXLen, iXLen)

define <1 x i8> @test_sf_vc_v_iv_e8mf8(<1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.iv.nxv1i8.iXLen.iXLen.iXLen(iXLen 3, <1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.iv.nxv1i8.iXLen.iXLen.iXLen(iXLen, <1 x i8>, iXLen, iXLen)

define <2 x i8> @test_sf_vc_v_iv_e8mf4(<2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.iv.nxv2i8.iXLen.iXLen.iXLen(iXLen 3, <2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.iv.nxv2i8.iXLen.iXLen.iXLen(iXLen, <2 x i8>, iXLen, iXLen)

define <4 x i8> @test_sf_vc_v_iv_e8mf2(<4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.iv.nxv4i8.iXLen.iXLen.iXLen(iXLen 3, <4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.iv.nxv4i8.iXLen.iXLen.iXLen(iXLen, <4 x i8>, iXLen, iXLen)

define <8 x i8> @test_sf_vc_v_iv_e8m1(<8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.iv.nxv8i8.iXLen.iXLen.iXLen(iXLen 3, <8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.iv.nxv8i8.iXLen.iXLen.iXLen(iXLen, <8 x i8>, iXLen, iXLen)

define <16 x i8> @test_sf_vc_v_iv_e8m2(<16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.iv.nxv16i8.iXLen.iXLen.iXLen(iXLen 3, <16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.iv.nxv16i8.iXLen.iXLen.iXLen(iXLen, <16 x i8>, iXLen, iXLen)

define <32 x i8> @test_sf_vc_v_iv_e8m4(<32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.iv.nxv32i8.iXLen.iXLen.iXLen(iXLen 3, <32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.iv.nxv32i8.iXLen.iXLen.iXLen(iXLen, <32 x i8>, iXLen, iXLen)

define <64 x i8> @test_sf_vc_v_iv_e8m8(<64 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.iv.nxv64i8.iXLen.iXLen.iXLen(iXLen 3, <64 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.iv.nxv64i8.iXLen.iXLen.iXLen(iXLen, <64 x i8>, iXLen, iXLen)

define <1 x i16> @test_sf_vc_v_iv_e16mf4(<1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.iv.nxv1i16.iXLen.iXLen.iXLen(iXLen 3, <1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.iv.nxv1i16.iXLen.iXLen.iXLen(iXLen, <1 x i16>, iXLen, iXLen)

define <2 x i16> @test_sf_vc_v_iv_e16mf2(<2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.iv.nxv2i16.iXLen.iXLen.iXLen(iXLen 3, <2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.iv.nxv2i16.iXLen.iXLen.iXLen(iXLen, <2 x i16>, iXLen, iXLen)

define <4 x i16> @test_sf_vc_v_iv_e16m1(<4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.iv.nxv4i16.iXLen.iXLen.iXLen(iXLen 3, <4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.iv.nxv4i16.iXLen.iXLen.iXLen(iXLen, <4 x i16>, iXLen, iXLen)

define <8 x i16> @test_sf_vc_v_iv_e16m2(<8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.iv.nxv8i16.iXLen.iXLen.iXLen(iXLen 3, <8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.iv.nxv8i16.iXLen.iXLen.iXLen(iXLen, <8 x i16>, iXLen, iXLen)

define <16 x i16> @test_sf_vc_v_iv_e16m4(<16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.iv.nxv16i16.iXLen.iXLen.iXLen(iXLen 3, <16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.iv.nxv16i16.iXLen.iXLen.iXLen(iXLen, <16 x i16>, iXLen, iXLen)

define <32 x i16> @test_sf_vc_v_iv_e16m8(<32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.iv.nxv32i16.iXLen.iXLen.iXLen(iXLen 3, <32 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.iv.nxv32i16.iXLen.iXLen.iXLen(iXLen, <32 x i16>, iXLen, iXLen)

define <1 x i32> @test_sf_vc_v_iv_e32mf2(<1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.iv.nxv1i32.iXLen.iXLen.iXLen(iXLen 3, <1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.iv.nxv1i32.iXLen.iXLen.iXLen(iXLen, <1 x i32>, iXLen, iXLen)

define <2 x i32> @test_sf_vc_v_iv_e32m1(<2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.iv.nxv2i32.iXLen.iXLen.iXLen(iXLen 3, <2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.iv.nxv2i32.iXLen.iXLen.iXLen(iXLen, <2 x i32>, iXLen, iXLen)

define <4 x i32> @test_sf_vc_v_iv_e32m2(<4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.iv.nxv4i32.iXLen.iXLen.iXLen(iXLen 3, <4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.iv.nxv4i32.iXLen.iXLen.iXLen(iXLen, <4 x i32>, iXLen, iXLen)

define <8 x i32> @test_sf_vc_v_iv_e32m4(<8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.iv.nxv8i32.iXLen.iXLen.iXLen(iXLen 3, <8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.iv.nxv8i32.iXLen.iXLen.iXLen(iXLen, <8 x i32>, iXLen, iXLen)

define <16 x i32> @test_sf_vc_v_iv_e32m8(<16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.iv.nxv16i32.iXLen.iXLen.iXLen(iXLen 3, <16 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.iv.nxv16i32.iXLen.iXLen.iXLen(iXLen, <16 x i32>, iXLen, iXLen)

define <1 x i64> @test_sf_vc_v_iv_e64m1(<1 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i64> @llvm.riscv.sf.vc.v.iv.nxv1i64.iXLen.iXLen.iXLen(iXLen 3, <1 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i64> %0
}

declare <1 x i64> @llvm.riscv.sf.vc.v.iv.nxv1i64.iXLen.iXLen.iXLen(iXLen, <1 x i64>, iXLen, iXLen)

define <2 x i64> @test_sf_vc_v_iv_e64m2(<2 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> @llvm.riscv.sf.vc.v.iv.nxv2i64.iXLen.iXLen.iXLen(iXLen 3, <2 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i64> %0
}

declare <2 x i64> @llvm.riscv.sf.vc.v.iv.nxv2i64.iXLen.iXLen.iXLen(iXLen, <2 x i64>, iXLen, iXLen)

define <4 x i64> @test_sf_vc_v_iv_e64m4(<4 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i64> @llvm.riscv.sf.vc.v.iv.nxv4i64.iXLen.iXLen.iXLen(iXLen 3, <4 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i64> %0
}

declare <4 x i64> @llvm.riscv.sf.vc.v.iv.nxv4i64.iXLen.iXLen.iXLen(iXLen, <4 x i64>, iXLen, iXLen)

define <8 x i64> @test_sf_vc_v_iv_e64m8(<8 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i64> @llvm.riscv.sf.vc.v.iv.nxv8i64.iXLen.iXLen.iXLen(iXLen 3, <8 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i64> %0
}

declare <8 x i64> @llvm.riscv.sf.vc.v.iv.nxv8i64.iXLen.iXLen.iXLen(iXLen, <8 x i64>, iXLen, iXLen)

define void @test_sf_vc_fvv_se_e16mf4(<1 x half> %vs2, <1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1f16.nxv1i16.iXLen(iXLen 3, iXLen 31, <1 x half> %vs2, <1 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1f16.nxv1i16.iXLen(iXLen, iXLen, <1 x half>, <1 x i16>, iXLen)

define <1 x half> @test_sf_vc_v_fvv_se_e16mf4(<1 x half> %vs2, <1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x half> @llvm.riscv.sf.vc.v.vv.se.nxv1f16.iXLen.nxv1f16.iXLen(iXLen 3, <1 x half> %vs2, <1 x i16> %vs1, iXLen %vl)
  ret <1 x half> %0
}

declare <1 x half> @llvm.riscv.sf.vc.v.vv.se.nxv1f16.iXLen.nxv1f16.iXLen(iXLen, <1 x half>, <1 x i16>, iXLen)

define void @test_sf_vc_fvv_se_e16mf2(<2 x half> %vs2, <2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2f16.nxv2i16.iXLen(iXLen 3, iXLen 31, <2 x half> %vs2, <2 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2f16.nxv2i16.iXLen(iXLen, iXLen, <2 x half>, <2 x i16>, iXLen)

define <2 x half> @test_sf_vc_v_fvv_se_e16mf2(<2 x half> %vs2, <2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x half> @llvm.riscv.sf.vc.v.vv.se.nxv2f16.iXLen.nxv2f16.iXLen(iXLen 3, <2 x half> %vs2, <2 x i16> %vs1, iXLen %vl)
  ret <2 x half> %0
}

declare <2 x half> @llvm.riscv.sf.vc.v.vv.se.nxv2f16.iXLen.nxv2f16.iXLen(iXLen, <2 x half>, <2 x i16>, iXLen)

define void @test_sf_vc_fvv_se_e16m1(<4 x half> %vs2, <4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4f16.nxv4i16.iXLen(iXLen 3, iXLen 31, <4 x half> %vs2, <4 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4f16.nxv4i16.iXLen(iXLen, iXLen, <4 x half>, <4 x i16>, iXLen)

define <4 x half> @test_sf_vc_v_fvv_se_e16m1(<4 x half> %vs2, <4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x half> @llvm.riscv.sf.vc.v.vv.se.nxv4f16.iXLen.nxv4f16.iXLen(iXLen 3, <4 x half> %vs2, <4 x i16> %vs1, iXLen %vl)
  ret <4 x half> %0
}

declare <4 x half> @llvm.riscv.sf.vc.v.vv.se.nxv4f16.iXLen.nxv4f16.iXLen(iXLen, <4 x half>, <4 x i16>, iXLen)

define void @test_sf_vc_fvv_se_e16m2(<8 x half> %vs2, <8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8f16.nxv8i16.iXLen(iXLen 3, iXLen 31, <8 x half> %vs2, <8 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8f16.nxv8i16.iXLen(iXLen, iXLen, <8 x half>, <8 x i16>, iXLen)

define <8 x half> @test_sf_vc_v_fvv_se_e16m2(<8 x half> %vs2, <8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x half> @llvm.riscv.sf.vc.v.vv.se.nxv8f16.iXLen.nxv8f16.iXLen(iXLen 3, <8 x half> %vs2, <8 x i16> %vs1, iXLen %vl)
  ret <8 x half> %0
}

declare <8 x half> @llvm.riscv.sf.vc.v.vv.se.nxv8f16.iXLen.nxv8f16.iXLen(iXLen, <8 x half>, <8 x i16>, iXLen)

define void @test_sf_vc_fvv_se_e16m4(<16 x half> %vs2, <16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16f16.nxv16i16.iXLen(iXLen 3, iXLen 31, <16 x half> %vs2, <16 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16f16.nxv16i16.iXLen(iXLen, iXLen, <16 x half>, <16 x i16>, iXLen)

define <16 x half> @test_sf_vc_v_fvv_se_e16m4(<16 x half> %vs2, <16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x half> @llvm.riscv.sf.vc.v.vv.se.nxv16f16.iXLen.nxv16f16.iXLen(iXLen 3, <16 x half> %vs2, <16 x i16> %vs1, iXLen %vl)
  ret <16 x half> %0
}

declare <16 x half> @llvm.riscv.sf.vc.v.vv.se.nxv16f16.iXLen.nxv16f16.iXLen(iXLen, <16 x half>, <16 x i16>, iXLen)

define void @test_sf_vc_fvv_se_e16m8(<32 x half> %vs2, <32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv32f16.nxv32i16.iXLen(iXLen 3, iXLen 31, <32 x half> %vs2, <32 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv32f16.nxv32i16.iXLen(iXLen, iXLen, <32 x half>, <32 x i16>, iXLen)

define <32 x half> @test_sf_vc_v_fvv_se_e16m8(<32 x half> %vs2, <32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x half> @llvm.riscv.sf.vc.v.vv.se.nxv32f16.iXLen.nxv32f16.iXLen(iXLen 3, <32 x half> %vs2, <32 x i16> %vs1, iXLen %vl)
  ret <32 x half> %0
}

declare <32 x half> @llvm.riscv.sf.vc.v.vv.se.nxv32f16.iXLen.nxv32f16.iXLen(iXLen, <32 x half>, <32 x i16>, iXLen)

define void @test_sf_vc_fvv_se_e32mf2(<1 x float> %vs2, <1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1f32.nxv1i32.iXLen(iXLen 3, iXLen 31, <1 x float> %vs2, <1 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1f32.nxv1i32.iXLen(iXLen, iXLen, <1 x float>, <1 x i32>, iXLen)

define <1 x float> @test_sf_vc_v_fvv_se_e32mf2(<1 x float> %vs2, <1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x float> @llvm.riscv.sf.vc.v.vv.se.nxv1f32.iXLen.nxv1f32.iXLen(iXLen 3, <1 x float> %vs2, <1 x i32> %vs1, iXLen %vl)
  ret <1 x float> %0
}

declare <1 x float> @llvm.riscv.sf.vc.v.vv.se.nxv1f32.iXLen.nxv1f32.iXLen(iXLen, <1 x float>, <1 x i32>, iXLen)

define void @test_sf_vc_fvv_se_e32m1(<2 x float> %vs2, <2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2f32.nxv2i32.iXLen(iXLen 3, iXLen 31, <2 x float> %vs2, <2 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2f32.nxv2i32.iXLen(iXLen, iXLen, <2 x float>, <2 x i32>, iXLen)

define <2 x float> @test_sf_vc_v_fvv_se_e32m1(<2 x float> %vs2, <2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x float> @llvm.riscv.sf.vc.v.vv.se.nxv2f32.iXLen.nxv2f32.iXLen(iXLen 3, <2 x float> %vs2, <2 x i32> %vs1, iXLen %vl)
  ret <2 x float> %0
}

declare <2 x float> @llvm.riscv.sf.vc.v.vv.se.nxv2f32.iXLen.nxv2f32.iXLen(iXLen, <2 x float>, <2 x i32>, iXLen)

define void @test_sf_vc_fvv_se_e32m2(<4 x float> %vs2, <4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4f32.nxv4i32.iXLen(iXLen 3, iXLen 31, <4 x float> %vs2, <4 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4f32.nxv4i32.iXLen(iXLen, iXLen, <4 x float>, <4 x i32>, iXLen)

define <4 x float> @test_sf_vc_v_fvv_se_e32m2(<4 x float> %vs2, <4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x float> @llvm.riscv.sf.vc.v.vv.se.nxv4f32.iXLen.nxv4f32.iXLen(iXLen 3, <4 x float> %vs2, <4 x i32> %vs1, iXLen %vl)
  ret <4 x float> %0
}

declare <4 x float> @llvm.riscv.sf.vc.v.vv.se.nxv4f32.iXLen.nxv4f32.iXLen(iXLen, <4 x float>, <4 x i32>, iXLen)

define void @test_sf_vc_fvv_se_e32m4(<8 x float> %vs2, <8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8f32.nxv8i32.iXLen(iXLen 3, iXLen 31, <8 x float> %vs2, <8 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8f32.nxv8i32.iXLen(iXLen, iXLen, <8 x float>, <8 x i32>, iXLen)

define <8 x float> @test_sf_vc_v_fvv_se_e32m4(<8 x float> %vs2, <8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x float> @llvm.riscv.sf.vc.v.vv.se.nxv8f32.iXLen.nxv8f32.iXLen(iXLen 3, <8 x float> %vs2, <8 x i32> %vs1, iXLen %vl)
  ret <8 x float> %0
}

declare <8 x float> @llvm.riscv.sf.vc.v.vv.se.nxv8f32.iXLen.nxv8f32.iXLen(iXLen, <8 x float>, <8 x i32>, iXLen)

define void @test_sf_vc_fvv_se_e32m8(<16 x float> %vs2, <16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16f32.nxv16i32.iXLen(iXLen 3, iXLen 31, <16 x float> %vs2, <16 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16f32.nxv16i32.iXLen(iXLen, iXLen, <16 x float>, <16 x i32>, iXLen)

define <16 x float> @test_sf_vc_v_fvv_se_e32m8(<16 x float> %vs2, <16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x float> @llvm.riscv.sf.vc.v.vv.se.nxv16f32.iXLen.nxv16f32.iXLen(iXLen 3, <16 x float> %vs2, <16 x i32> %vs1, iXLen %vl)
  ret <16 x float> %0
}

declare <16 x float> @llvm.riscv.sf.vc.v.vv.se.nxv16f32.iXLen.nxv16f32.iXLen(iXLen, <16 x float>, <16 x i32>, iXLen)

define void @test_sf_vc_fvv_se_e64m1(<1 x double> %vs2, <1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1f64.nxv1i64.iXLen(iXLen 3, iXLen 31, <1 x double> %vs2, <1 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1f64.nxv1i64.iXLen(iXLen, iXLen, <1 x double>, <1 x i64>, iXLen)

define <1 x double> @test_sf_vc_v_fvv_se_e64m1(<1 x double> %vs2, <1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x double> @llvm.riscv.sf.vc.v.vv.se.nxv1f64.iXLen.nxv1f64.iXLen(iXLen 3, <1 x double> %vs2, <1 x i64> %vs1, iXLen %vl)
  ret <1 x double> %0
}

declare <1 x double> @llvm.riscv.sf.vc.v.vv.se.nxv1f64.iXLen.nxv1f64.iXLen(iXLen, <1 x double>, <1 x i64>, iXLen)

define void @test_sf_vc_fvv_se_e64m2(<2 x double> %vs2, <2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2f64.nxv2i64.iXLen(iXLen 3, iXLen 31, <2 x double> %vs2, <2 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2f64.nxv2i64.iXLen(iXLen, iXLen, <2 x double>, <2 x i64>, iXLen)

define <2 x double> @test_sf_vc_v_fvv_se_e64m2(<2 x double> %vs2, <2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x double> @llvm.riscv.sf.vc.v.vv.se.nxv2f64.iXLen.nxv2f64.iXLen(iXLen 3, <2 x double> %vs2, <2 x i64> %vs1, iXLen %vl)
  ret <2 x double> %0
}

declare <2 x double> @llvm.riscv.sf.vc.v.vv.se.nxv2f64.iXLen.nxv2f64.iXLen(iXLen, <2 x double>, <2 x i64>, iXLen)

define void @test_sf_vc_fvv_se_e64m4(<4 x double> %vs2, <4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4f64.nxv4i64.iXLen(iXLen 3, iXLen 31, <4 x double> %vs2, <4 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4f64.nxv4i64.iXLen(iXLen, iXLen, <4 x double>, <4 x i64>, iXLen)

define <4 x double> @test_sf_vc_v_fvv_se_e64m4(<4 x double> %vs2, <4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x double> @llvm.riscv.sf.vc.v.vv.se.nxv4f64.iXLen.nxv4f64.iXLen(iXLen 3, <4 x double> %vs2, <4 x i64> %vs1, iXLen %vl)
  ret <4 x double> %0
}

declare <4 x double> @llvm.riscv.sf.vc.v.vv.se.nxv4f64.iXLen.nxv4f64.iXLen(iXLen, <4 x double>, <4 x i64>, iXLen)

define void @test_sf_vc_fvv_se_e64m8(<8 x double> %vs2, <8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8f64.nxv8i64.iXLen(iXLen 3, iXLen 31, <8 x double> %vs2, <8 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8f64.nxv8i64.iXLen(iXLen, iXLen, <8 x double>, <8 x i64>, iXLen)

define <8 x double> @test_sf_vc_v_fvv_se_e64m8(<8 x double> %vs2, <8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x double> @llvm.riscv.sf.vc.v.vv.se.nxv8f64.iXLen.nxv8f64.iXLen(iXLen 3, <8 x double> %vs2, <8 x i64> %vs1, iXLen %vl)
  ret <8 x double> %0
}

declare <8 x double> @llvm.riscv.sf.vc.v.vv.se.nxv8f64.iXLen.nxv8f64.iXLen(iXLen, <8 x double>, <8 x i64>, iXLen)

define void @test_sf_vc_fvx_se_e16mf4(<1 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1f16.nxv1f16.i16.iXLen(iXLen 3, iXLen 31, <1 x half> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1f16.nxv1f16.i16.iXLen(iXLen, iXLen, <1 x half>, i16, iXLen)

define <1 x half> @test_sf_vc_v_fvx_se_e16mf4(<1 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x half> @llvm.riscv.sf.vc.v.xv.se.nxv1f16.nxv1f16.i16.iXLen(iXLen 3, <1 x half> %vs2, i16 %rs1, iXLen %vl)
  ret <1 x half> %0
}

declare <1 x half> @llvm.riscv.sf.vc.v.xv.se.nxv1f16.nxv1f16.i16.iXLen(iXLen, <1 x half>, i16, iXLen)

define void @test_sf_vc_fvx_se_e16mf2(<2 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2f16.nxv2f16.i16.iXLen(iXLen 3, iXLen 31, <2 x half> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2f16.nxv2f16.i16.iXLen(iXLen, iXLen, <2 x half>, i16, iXLen)

define <2 x half> @test_sf_vc_v_fvx_se_e16mf2(<2 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x half> @llvm.riscv.sf.vc.v.xv.se.nxv2f16.nxv2f16.i16.iXLen(iXLen 3, <2 x half> %vs2, i16 %rs1, iXLen %vl)
  ret <2 x half> %0
}

declare <2 x half> @llvm.riscv.sf.vc.v.xv.se.nxv2f16.nxv2f16.i16.iXLen(iXLen, <2 x half>, i16, iXLen)

define void @test_sf_vc_fvx_se_e16m1(<4 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4f16.nxv4f16.i16.iXLen(iXLen 3, iXLen 31, <4 x half> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4f16.nxv4f16.i16.iXLen(iXLen, iXLen, <4 x half>, i16, iXLen)

define <4 x half> @test_sf_vc_v_fvx_se_e16m1(<4 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x half> @llvm.riscv.sf.vc.v.xv.se.nxv4f16.nxv4f16.i16.iXLen(iXLen 3, <4 x half> %vs2, i16 %rs1, iXLen %vl)
  ret <4 x half> %0
}

declare <4 x half> @llvm.riscv.sf.vc.v.xv.se.nxv4f16.nxv4f16.i16.iXLen(iXLen, <4 x half>, i16, iXLen)

define void @test_sf_vc_fvx_se_e16m2(<8 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8f16.nxv8f16.i16.iXLen(iXLen 3, iXLen 31, <8 x half> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8f16.nxv8f16.i16.iXLen(iXLen, iXLen, <8 x half>, i16, iXLen)

define <8 x half> @test_sf_vc_v_fvx_se_e16m2(<8 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x half> @llvm.riscv.sf.vc.v.xv.se.nxv8f16.nxv8f16.i16.iXLen(iXLen 3, <8 x half> %vs2, i16 %rs1, iXLen %vl)
  ret <8 x half> %0
}

declare <8 x half> @llvm.riscv.sf.vc.v.xv.se.nxv8f16.nxv8f16.i16.iXLen(iXLen, <8 x half>, i16, iXLen)

define void @test_sf_vc_fvx_se_e16m4(<16 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16f16.nxv16f16.i16.iXLen(iXLen 3, iXLen 31, <16 x half> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16f16.nxv16f16.i16.iXLen(iXLen, iXLen, <16 x half>, i16, iXLen)

define <16 x half> @test_sf_vc_v_fvx_se_e16m4(<16 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x half> @llvm.riscv.sf.vc.v.xv.se.nxv16f16.nxv16f16.i16.iXLen(iXLen 3, <16 x half> %vs2, i16 %rs1, iXLen %vl)
  ret <16 x half> %0
}

declare <16 x half> @llvm.riscv.sf.vc.v.xv.se.nxv16f16.nxv16f16.i16.iXLen(iXLen, <16 x half>, i16, iXLen)

define void @test_sf_vc_fvx_se_e16m8(<32 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv32f16.nxv32f16.i16.iXLen(iXLen 3, iXLen 31, <32 x half> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv32f16.nxv32f16.i16.iXLen(iXLen, iXLen, <32 x half>, i16, iXLen)

define <32 x half> @test_sf_vc_v_fvx_se_e16m8(<32 x half> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x half> @llvm.riscv.sf.vc.v.xv.se.nxv32f16.nxv32f16.i16.iXLen(iXLen 3, <32 x half> %vs2, i16 %rs1, iXLen %vl)
  ret <32 x half> %0
}

declare <32 x half> @llvm.riscv.sf.vc.v.xv.se.nxv32f16.nxv32f16.i16.iXLen(iXLen, <32 x half>, i16, iXLen)

define void @test_sf_vc_fvx_se_e32mf2(<1 x float> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1f32.nxv1f32.i32.iXLen(iXLen 3, iXLen 31, <1 x float> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1f32.nxv1f32.i32.iXLen(iXLen, iXLen, <1 x float>, i32, iXLen)

define <1 x float> @test_sf_vc_v_fvx_se_e32mf2(<1 x float> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x float> @llvm.riscv.sf.vc.v.xv.se.nxv1f32.nxv1f32.i32.iXLen(iXLen 3, <1 x float> %vs2, i32 %rs1, iXLen %vl)
  ret <1 x float> %0
}

declare <1 x float> @llvm.riscv.sf.vc.v.xv.se.nxv1f32.nxv1f32.i32.iXLen(iXLen, <1 x float>, i32, iXLen)

define void @test_sf_vc_fvx_se_e32m1(<2 x float> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2f32.nxv2f32.i32.iXLen(iXLen 3, iXLen 31, <2 x float> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2f32.nxv2f32.i32.iXLen(iXLen, iXLen, <2 x float>, i32, iXLen)

define <2 x float> @test_sf_vc_v_fvx_se_e32m1(<2 x float> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x float> @llvm.riscv.sf.vc.v.xv.se.nxv2f32.nxv2f32.i32.iXLen(iXLen 3, <2 x float> %vs2, i32 %rs1, iXLen %vl)
  ret <2 x float> %0
}

declare <2 x float> @llvm.riscv.sf.vc.v.xv.se.nxv2f32.nxv2f32.i32.iXLen(iXLen, <2 x float>, i32, iXLen)

define void @test_sf_vc_fvx_se_e32m2(<4 x float> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4f32.nxv4f32.i32.iXLen(iXLen 3, iXLen 31, <4 x float> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4f32.nxv4f32.i32.iXLen(iXLen, iXLen, <4 x float>, i32, iXLen)

define <4 x float> @test_sf_vc_v_fvx_se_e32m2(<4 x float> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x float> @llvm.riscv.sf.vc.v.xv.se.nxv4f32.nxv4f32.i32.iXLen(iXLen 3, <4 x float> %vs2, i32 %rs1, iXLen %vl)
  ret <4 x float> %0
}

declare <4 x float> @llvm.riscv.sf.vc.v.xv.se.nxv4f32.nxv4f32.i32.iXLen(iXLen, <4 x float>, i32, iXLen)

define void @test_sf_vc_fvx_se_e32m4(<8 x float> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8f32.nxv8f32.i32.iXLen(iXLen 3, iXLen 31, <8 x float> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8f32.nxv8f32.i32.iXLen(iXLen, iXLen, <8 x float>, i32, iXLen)

define <8 x float> @test_sf_vc_v_fvx_se_e32m4(<8 x float> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x float> @llvm.riscv.sf.vc.v.xv.se.nxv8f32.nxv8f32.i32.iXLen(iXLen 3, <8 x float> %vs2, i32 %rs1, iXLen %vl)
  ret <8 x float> %0
}

declare <8 x float> @llvm.riscv.sf.vc.v.xv.se.nxv8f32.nxv8f32.i32.iXLen(iXLen, <8 x float>, i32, iXLen)

define void @test_sf_vc_fvx_se_e32m8(<16 x float> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvx_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16f32.nxv16f32.i32.iXLen(iXLen 3, iXLen 31, <16 x float> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16f32.nxv16f32.i32.iXLen(iXLen, iXLen, <16 x float>, i32, iXLen)

define <16 x float> @test_sf_vc_v_fvx_se_e32m8(<16 x float> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvx_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x float> @llvm.riscv.sf.vc.v.xv.se.nxv16f32.nxv16f32.i32.iXLen(iXLen 3, <16 x float> %vs2, i32 %rs1, iXLen %vl)
  ret <16 x float> %0
}

declare <16 x float> @llvm.riscv.sf.vc.v.xv.se.nxv16f32.nxv16f32.i32.iXLen(iXLen, <16 x float>, i32, iXLen)

define void @test_sf_vc_fvi_se_e16mf4(<1 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1f16.nxv1f16.iXLen.iXLen(iXLen 3, iXLen 31, <1 x half> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1f16.nxv1f16.iXLen.iXLen(iXLen, iXLen, <1 x half>, iXLen, iXLen)

define <1 x half> @test_sf_vc_v_fvi_se_e16mf4(<1 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x half> @llvm.riscv.sf.vc.v.iv.se.nxv1f16.nxv1f16.iXLen.iXLen(iXLen 3, <1 x half> %vs2, iXLen 8, iXLen %vl)
  ret <1 x half> %0
}

declare <1 x half> @llvm.riscv.sf.vc.v.iv.se.nxv1f16.nxv1f16.iXLen.iXLen(iXLen, <1 x half>, iXLen, iXLen)

define void @test_sf_vc_fvi_se_e16mf2(<2 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2f16.nxv2f16.iXLen.iXLen(iXLen 3, iXLen 31, <2 x half> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2f16.nxv2f16.iXLen.iXLen(iXLen, iXLen, <2 x half>, iXLen, iXLen)

define <2 x half> @test_sf_vc_v_fvi_se_e16mf2(<2 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x half> @llvm.riscv.sf.vc.v.iv.se.nxv2f16.nxv2f16.iXLen.iXLen(iXLen 3, <2 x half> %vs2, iXLen 8, iXLen %vl)
  ret <2 x half> %0
}

declare <2 x half> @llvm.riscv.sf.vc.v.iv.se.nxv2f16.nxv2f16.iXLen.iXLen(iXLen, <2 x half>, iXLen, iXLen)

define void @test_sf_vc_fvi_se_e16m1(<4 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4f16.nxv4f16.iXLen.iXLen(iXLen 3, iXLen 31, <4 x half> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4f16.nxv4f16.iXLen.iXLen(iXLen, iXLen, <4 x half>, iXLen, iXLen)

define <4 x half> @test_sf_vc_v_fvi_se_e16m1(<4 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x half> @llvm.riscv.sf.vc.v.iv.se.nxv4f16.nxv4f16.iXLen.iXLen(iXLen 3, <4 x half> %vs2, iXLen 8, iXLen %vl)
  ret <4 x half> %0
}

declare <4 x half> @llvm.riscv.sf.vc.v.iv.se.nxv4f16.nxv4f16.iXLen.iXLen(iXLen, <4 x half>, iXLen, iXLen)

define void @test_sf_vc_fvi_se_e16m2(<8 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8f16.nxv8f16.iXLen.iXLen(iXLen 3, iXLen 31, <8 x half> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8f16.nxv8f16.iXLen.iXLen(iXLen, iXLen, <8 x half>, iXLen, iXLen)

define <8 x half> @test_sf_vc_v_fvi_se_e16m2(<8 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x half> @llvm.riscv.sf.vc.v.iv.se.nxv8f16.nxv8f16.iXLen.iXLen(iXLen 3, <8 x half> %vs2, iXLen 8, iXLen %vl)
  ret <8 x half> %0
}

declare <8 x half> @llvm.riscv.sf.vc.v.iv.se.nxv8f16.nxv8f16.iXLen.iXLen(iXLen, <8 x half>, iXLen, iXLen)

define void @test_sf_vc_fvi_se_e16m4(<16 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16f16.nxv16f16.iXLen.iXLen(iXLen 3, iXLen 31, <16 x half> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16f16.nxv16f16.iXLen.iXLen(iXLen, iXLen, <16 x half>, iXLen, iXLen)

define <16 x half> @test_sf_vc_v_fvi_se_e16m4(<16 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x half> @llvm.riscv.sf.vc.v.iv.se.nxv16f16.nxv16f16.iXLen.iXLen(iXLen 3, <16 x half> %vs2, iXLen 8, iXLen %vl)
  ret <16 x half> %0
}

declare <16 x half> @llvm.riscv.sf.vc.v.iv.se.nxv16f16.nxv16f16.iXLen.iXLen(iXLen, <16 x half>, iXLen, iXLen)

define void @test_sf_vc_fvi_se_e16m8(<32 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv32f16.nxv32f16.iXLen.iXLen(iXLen 3, iXLen 31, <32 x half> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv32f16.nxv32f16.iXLen.iXLen(iXLen, iXLen, <32 x half>, iXLen, iXLen)

define <32 x half> @test_sf_vc_v_fvi_se_e16m8(<32 x half> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x half> @llvm.riscv.sf.vc.v.iv.se.nxv32f16.nxv32f16.iXLen.iXLen(iXLen 3, <32 x half> %vs2, iXLen 8, iXLen %vl)
  ret <32 x half> %0
}

declare <32 x half> @llvm.riscv.sf.vc.v.iv.se.nxv32f16.nxv32f16.iXLen.iXLen(iXLen, <32 x half>, iXLen, iXLen)

define void @test_sf_vc_fvi_se_e32mf2(<1 x float> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1f32.nxv1f32.iXLen.iXLen(iXLen 3, iXLen 31, <1 x float> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1f32.nxv1f32.iXLen.iXLen(iXLen, iXLen, <1 x float>, iXLen, iXLen)

define <1 x float> @test_sf_vc_v_fvi_se_e32mf2(<1 x float> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x float> @llvm.riscv.sf.vc.v.iv.se.nxv1f32.nxv1f32.iXLen.iXLen(iXLen 3, <1 x float> %vs2, iXLen 8, iXLen %vl)
  ret <1 x float> %0
}

declare <1 x float> @llvm.riscv.sf.vc.v.iv.se.nxv1f32.nxv1f32.iXLen.iXLen(iXLen, <1 x float>, iXLen, iXLen)

define void @test_sf_vc_fvi_se_e32m1(<2 x float> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2f32.nxv2f32.iXLen.iXLen(iXLen 3, iXLen 31, <2 x float> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2f32.nxv2f32.iXLen.iXLen(iXLen, iXLen, <2 x float>, iXLen, iXLen)

define <2 x float> @test_sf_vc_v_fvi_se_e32m1(<2 x float> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x float> @llvm.riscv.sf.vc.v.iv.se.nxv2f32.nxv2f32.iXLen.iXLen(iXLen 3, <2 x float> %vs2, iXLen 8, iXLen %vl)
  ret <2 x float> %0
}

declare <2 x float> @llvm.riscv.sf.vc.v.iv.se.nxv2f32.nxv2f32.iXLen.iXLen(iXLen, <2 x float>, iXLen, iXLen)

define void @test_sf_vc_fvi_se_e32m2(<4 x float> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4f32.nxv4f32.iXLen.iXLen(iXLen 3, iXLen 31, <4 x float> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4f32.nxv4f32.iXLen.iXLen(iXLen, iXLen, <4 x float>, iXLen, iXLen)

define <4 x float> @test_sf_vc_v_fvi_se_e32m2(<4 x float> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x float> @llvm.riscv.sf.vc.v.iv.se.nxv4f32.nxv4f32.iXLen.iXLen(iXLen 3, <4 x float> %vs2, iXLen 8, iXLen %vl)
  ret <4 x float> %0
}

declare <4 x float> @llvm.riscv.sf.vc.v.iv.se.nxv4f32.nxv4f32.iXLen.iXLen(iXLen, <4 x float>, iXLen, iXLen)

define void @test_sf_vc_fvi_se_e32m4(<8 x float> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8f32.nxv8f32.iXLen.iXLen(iXLen 3, iXLen 31, <8 x float> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8f32.nxv8f32.iXLen.iXLen(iXLen, iXLen, <8 x float>, iXLen, iXLen)

define <8 x float> @test_sf_vc_v_fvi_se_e32m4(<8 x float> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x float> @llvm.riscv.sf.vc.v.iv.se.nxv8f32.nxv8f32.iXLen.iXLen(iXLen 3, <8 x float> %vs2, iXLen 8, iXLen %vl)
  ret <8 x float> %0
}

declare <8 x float> @llvm.riscv.sf.vc.v.iv.se.nxv8f32.nxv8f32.iXLen.iXLen(iXLen, <8 x float>, iXLen, iXLen)

define void @test_sf_vc_fvi_se_e32m8(<16 x float> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvi_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 8
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16f32.nxv16f32.iXLen.iXLen(iXLen 3, iXLen 31, <16 x float> %vs2, iXLen 8, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16f32.nxv16f32.iXLen.iXLen(iXLen, iXLen, <16 x float>, iXLen, iXLen)

define <16 x float> @test_sf_vc_v_fvi_se_e32m8(<16 x float> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvi_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 8
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x float> @llvm.riscv.sf.vc.v.iv.se.nxv16f32.nxv16f32.iXLen.iXLen(iXLen 3, <16 x float> %vs2, iXLen 8, iXLen %vl)
  ret <16 x float> %0
}

declare <16 x float> @llvm.riscv.sf.vc.v.iv.se.nxv16f32.nxv16f32.iXLen.iXLen(iXLen, <16 x float>, iXLen, iXLen)

define void @test_sf_vc_fvf_se_e16mf4(<1 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv1f16.nxv1f16.f16.iXLen(iXLen 1, iXLen 31, <1 x half> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv1f16.nxv1f16.f16.iXLen(iXLen, iXLen, <1 x half>, half, iXLen)

define <1 x half> @test_sf_vc_v_fvf_se_e16mf4(<1 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x half> @llvm.riscv.sf.vc.v.fv.se.nxv1f16.nxv1f16.iXLen.f16(iXLen 1, <1 x half> %vs2, half %rs1, iXLen %vl)
  ret <1 x half> %0
}

declare <1 x half> @llvm.riscv.sf.vc.v.fv.se.nxv1f16.nxv1f16.iXLen.f16(iXLen, <1 x half>, half, iXLen)

define void @test_sf_vc_fvf_se_e16mf2(<2 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv2f16.nxv2f16.f16.iXLen(iXLen 1, iXLen 31, <2 x half> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv2f16.nxv2f16.f16.iXLen(iXLen, iXLen, <2 x half>, half, iXLen)

define <2 x half> @test_sf_vc_v_fvf_se_e16mf2(<2 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x half> @llvm.riscv.sf.vc.v.fv.se.nxv2f16.nxv2f16.iXLen.f16(iXLen 1, <2 x half> %vs2, half %rs1, iXLen %vl)
  ret <2 x half> %0
}

declare <2 x half> @llvm.riscv.sf.vc.v.fv.se.nxv2f16.nxv2f16.iXLen.f16(iXLen, <2 x half>, half, iXLen)

define void @test_sf_vc_fvf_se_e16m1(<4 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv4f16.nxv4f16.f16.iXLen(iXLen 1, iXLen 31, <4 x half> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv4f16.nxv4f16.f16.iXLen(iXLen, iXLen, <4 x half>, half, iXLen)

define <4 x half> @test_sf_vc_v_fvf_se_e16m1(<4 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x half> @llvm.riscv.sf.vc.v.fv.se.nxv4f16.nxv4f16.iXLen.f16(iXLen 1, <4 x half> %vs2, half %rs1, iXLen %vl)
  ret <4 x half> %0
}

declare <4 x half> @llvm.riscv.sf.vc.v.fv.se.nxv4f16.nxv4f16.iXLen.f16(iXLen, <4 x half>, half, iXLen)

define void @test_sf_vc_fvf_se_e16m2(<8 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv8f16.nxv8f16.f16.iXLen(iXLen 1, iXLen 31, <8 x half> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv8f16.nxv8f16.f16.iXLen(iXLen, iXLen, <8 x half>, half, iXLen)

define <8 x half> @test_sf_vc_v_fvf_se_e16m2(<8 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x half> @llvm.riscv.sf.vc.v.fv.se.nxv8f16.nxv8f16.iXLen.f16(iXLen 1, <8 x half> %vs2, half %rs1, iXLen %vl)
  ret <8 x half> %0
}

declare <8 x half> @llvm.riscv.sf.vc.v.fv.se.nxv8f16.nxv8f16.iXLen.f16(iXLen, <8 x half>, half, iXLen)

define void @test_sf_vc_fvf_se_e16m4(<16 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv16f16.nxv16f16.f16.iXLen(iXLen 1, iXLen 31, <16 x half> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv16f16.nxv16f16.f16.iXLen(iXLen, iXLen, <16 x half>, half, iXLen)

define <16 x half> @test_sf_vc_v_fvf_se_e16m4(<16 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x half> @llvm.riscv.sf.vc.v.fv.se.nxv16f16.nxv16f16.iXLen.f16(iXLen 1, <16 x half> %vs2, half %rs1, iXLen %vl)
  ret <16 x half> %0
}

declare <16 x half> @llvm.riscv.sf.vc.v.fv.se.nxv16f16.nxv16f16.iXLen.f16(iXLen, <16 x half>, half, iXLen)

define void @test_sf_vc_fvf_se_e16m8(<32 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv32f16.nxv32f16.f16.iXLen(iXLen 1, iXLen 31, <32 x half> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv32f16.nxv32f16.f16.iXLen(iXLen, iXLen, <32 x half>, half, iXLen)

define <32 x half> @test_sf_vc_v_fvf_se_e16m8(<32 x half> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x half> @llvm.riscv.sf.vc.v.fv.se.nxv32f16.nxv32f16.iXLen.f16(iXLen 1, <32 x half> %vs2, half %rs1, iXLen %vl)
  ret <32 x half> %0
}

declare <32 x half> @llvm.riscv.sf.vc.v.fv.se.nxv32f16.nxv32f16.iXLen.f16(iXLen, <32 x half>, half, iXLen)

define void @test_sf_vc_fvf_se_e32mf2(<1 x float> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv1f32.nxv1f32.f32.iXLen(iXLen 1, iXLen 31, <1 x float> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv1f32.nxv1f32.f32.iXLen(iXLen, iXLen, <1 x float>, float, iXLen)

define <1 x float> @test_sf_vc_v_fvf_se_e32mf2(<1 x float> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x float> @llvm.riscv.sf.vc.v.fv.se.nxv1f32.nxv1f32.iXLen.f32(iXLen 1, <1 x float> %vs2, float %rs1, iXLen %vl)
  ret <1 x float> %0
}

declare <1 x float> @llvm.riscv.sf.vc.v.fv.se.nxv1f32.nxv1f32.iXLen.f32(iXLen, <1 x float>, float, iXLen)

define void @test_sf_vc_fvf_se_e32m1(<2 x float> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv2f32.nxv2f32.f32.iXLen(iXLen 1, iXLen 31, <2 x float> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv2f32.nxv2f32.f32.iXLen(iXLen, iXLen, <2 x float>, float, iXLen)

define <2 x float> @test_sf_vc_v_fvf_se_e32m1(<2 x float> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x float> @llvm.riscv.sf.vc.v.fv.se.nxv2f32.nxv2f32.iXLen.f32(iXLen 1, <2 x float> %vs2, float %rs1, iXLen %vl)
  ret <2 x float> %0
}

declare <2 x float> @llvm.riscv.sf.vc.v.fv.se.nxv2f32.nxv2f32.iXLen.f32(iXLen, <2 x float>, float, iXLen)

define void @test_sf_vc_fvf_se_e32m2(<4 x float> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv4f32.nxv4f32.f32.iXLen(iXLen 1, iXLen 31, <4 x float> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv4f32.nxv4f32.f32.iXLen(iXLen, iXLen, <4 x float>, float, iXLen)

define <4 x float> @test_sf_vc_v_fvf_se_e32m2(<4 x float> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x float> @llvm.riscv.sf.vc.v.fv.se.nxv4f32.nxv4f32.iXLen.f32(iXLen 1, <4 x float> %vs2, float %rs1, iXLen %vl)
  ret <4 x float> %0
}

declare <4 x float> @llvm.riscv.sf.vc.v.fv.se.nxv4f32.nxv4f32.iXLen.f32(iXLen, <4 x float>, float, iXLen)

define void @test_sf_vc_fvf_se_e32m4(<8 x float> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv8f32.nxv8f32.f32.iXLen(iXLen 1, iXLen 31, <8 x float> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv8f32.nxv8f32.f32.iXLen(iXLen, iXLen, <8 x float>, float, iXLen)

define <8 x float> @test_sf_vc_v_fvf_se_e32m4(<8 x float> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x float> @llvm.riscv.sf.vc.v.fv.se.nxv8f32.nxv8f32.iXLen.f32(iXLen 1, <8 x float> %vs2, float %rs1, iXLen %vl)
  ret <8 x float> %0
}

declare <8 x float> @llvm.riscv.sf.vc.v.fv.se.nxv8f32.nxv8f32.iXLen.f32(iXLen, <8 x float>, float, iXLen)

define void @test_sf_vc_fvf_se_e32m8(<16 x float> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvf_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv16f32.nxv16f32.f32.iXLen(iXLen 1, iXLen 31, <16 x float> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv16f32.nxv16f32.f32.iXLen(iXLen, iXLen, <16 x float>, float, iXLen)

define <16 x float> @test_sf_vc_v_fvf_se_e32m8(<16 x float> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvf_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x float> @llvm.riscv.sf.vc.v.fv.se.nxv16f32.nxv16f32.iXLen.f32(iXLen 1, <16 x float> %vs2, float %rs1, iXLen %vl)
  ret <16 x float> %0
}

declare <16 x float> @llvm.riscv.sf.vc.v.fv.se.nxv16f32.nxv16f32.iXLen.f32(iXLen, <16 x float>, float, iXLen)
