; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=+d --mcpu=generic < %s \
; RUN:   | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch32 -mattr=+d --mcpu=generic-la32 < %s \
; RUN:   | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 -mattr=+d --mcpu=generic < %s \
; RUN:   | FileCheck %s --check-prefix=LA64
; RUN: llc --mtriple=loongarch64 -mattr=+d --mcpu=generic-la64 < %s \
; RUN:   | FileCheck %s --check-prefix=LA64

;; The CPU name "generic" should map to the corresponding concrete names
;; according to the target triple's bitness.
define i64 @f(i64 signext %a, i64 signext %b) {
; LA32-LABEL: f:
; LA32:       # %bb.0:
; LA32-NEXT:    add.w $a1, $a1, $a3
; LA32-NEXT:    add.w $a2, $a0, $a2
; LA32-NEXT:    sltu $a0, $a2, $a0
; LA32-NEXT:    add.w $a1, $a1, $a0
; LA32-NEXT:    move $a0, $a2
; LA32-NEXT:    ret
;
; LA64-LABEL: f:
; LA64:       # %bb.0:
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    ret
  %1 = add nsw i64 %a, %b
  ret i64 %1
}
