/* BEGIN_LEGAL 

Copyright (c) 2017 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
/// @file enumer-test.cpp

// This file was automatically generated.
// Do not edit this file.

#include <string.h>
#include <assert.h>
#include "enumer-test.H"

typedef struct {
    const char* name;
    test_type_t value;
} name_table_test_type_t;
static const name_table_test_type_t name_array_test_type_t[] = {
{"aaa", TEST_TYPE_aaa},
{"bbb", TEST_TYPE_bbb},
{"ccc", TEST_TYPE_ccc},
{"LAST", TEST_TYPE_LAST},
{0, TEST_TYPE_LAST},
};

        
test_type_t str2test_type_t(const char* s)
{
   const name_table_test_type_t* p = name_array_test_type_t;
   while( p->name ) {
     if (strcmp(p->name,s) == 0) {
      return p->value;
     }
     p++;
   }
        

   return TEST_TYPE_LAST;
}


const char* test_type_t2str(const test_type_t p)
{
   test_type_t type_idx = p;
   if ( p > TEST_TYPE_LAST) type_idx = TEST_TYPE_LAST;
   return name_array_test_type_t[type_idx].name;
}

test_type_t test_type_t_last(void) {
    return TEST_TYPE_LAST;
}
       
/*

Here is a skeleton switch statement embedded in a comment


  switch(p) {
  case TEST_TYPE_aaa:
  case TEST_TYPE_bbb:
  case TEST_TYPE_ccc:
  case TEST_TYPE_LAST:
  default:
     xed_assert(0);
  }
*/
