/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.java.helics;

public class helics implements helicsConstants {
  public static int getHELICS_INVALID_OPTION_INDEX() {
    return helicsJNI.HELICS_INVALID_OPTION_INDEX_get();
  }

  /**
   *  result returned for requesting the value of an invalid/unknown property 
   */
  public static int getHELICS_INVALID_PROPERTY_VALUE() {
    return helicsJNI.HELICS_INVALID_PROPERTY_VALUE_get();
  }

  public static double getCHelicsBigNumber() {
    return helicsJNI.cHelicsBigNumber_get();
  }

  /**
   *  definition of time zero-the beginning of simulation 
   */
  public static double getHELICS_TIME_ZERO() {
    return helicsJNI.HELICS_TIME_ZERO_get();
  }

  /**
   *  definition of the minimum time resolution 
   */
  public static double getHELICS_TIME_EPSILON() {
    return helicsJNI.HELICS_TIME_EPSILON_get();
  }

  /**
   *  definition of an invalid time that has no meaning 
   */
  public static double getHELICS_TIME_INVALID() {
    return helicsJNI.HELICS_TIME_INVALID_get();
  }

  /**
   *  definition of time signifying the federate has<br>
   *                                                              terminated or run until the end of the simulation
   */
  public static double getHELICS_TIME_MAXTIME() {
    return helicsJNI.HELICS_TIME_MAXTIME_get();
  }

  /**
   *  indicator used for a true response 
   */
  public static int getHELICS_TRUE() {
    return helicsJNI.HELICS_TRUE_get();
  }

  /**
   *  indicator used for a false response 
   */
  public static int getHELICS_FALSE() {
    return helicsJNI.HELICS_FALSE_get();
  }

  /**
   *  create a helics managed data buffer with initial capacity
   */
  public static SWIGTYPE_p_void helicsCreateDataBuffer(SWIGTYPE_p_int32_t initialCapacity) {
    long cPtr = helicsJNI.helicsCreateDataBuffer(SWIGTYPE_p_int32_t.getCPtr(initialCapacity));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   *  check whether a buffer is valid
   */
  public static int helicsDataBufferIsValid(SWIGTYPE_p_void data) {
    return helicsJNI.helicsDataBufferIsValid(SWIGTYPE_p_void.getCPtr(data));
  }

  /**
   *  wrap user data in a buffer object
   */
  public static SWIGTYPE_p_void helicsWrapDataInBuffer(SWIGTYPE_p_void data, int dataSize, int dataCapacity) {
    long cPtr = helicsJNI.helicsWrapDataInBuffer(SWIGTYPE_p_void.getCPtr(data), dataSize, dataCapacity);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   *  free a DataBuffer 
   */
  public static void helicsDataBufferFree(SWIGTYPE_p_void data) {
    helicsJNI.helicsDataBufferFree(SWIGTYPE_p_void.getCPtr(data));
  }

  /**
   *  get the data buffer size
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferSize(SWIGTYPE_p_void data) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferSize(SWIGTYPE_p_void.getCPtr(data)), true);
  }

  /**
   *  get the data buffer capacity
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferCapacity(SWIGTYPE_p_void data) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferCapacity(SWIGTYPE_p_void.getCPtr(data)), true);
  }

  /**
   *  get a pointer to the raw data
   */
  public static SWIGTYPE_p_void helicsDataBufferData(SWIGTYPE_p_void data) {
    long cPtr = helicsJNI.helicsDataBufferData(SWIGTYPE_p_void.getCPtr(data));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   *  increase the capacity a data buffer can hold without reallocating memory<br>
   * @return HELICS_TRUE if the reservation was successful HELICS_FALSE otherwise
   */
  public static int helicsDataBufferReserve(SWIGTYPE_p_void data, SWIGTYPE_p_int32_t newCapacity) {
    return helicsJNI.helicsDataBufferReserve(SWIGTYPE_p_void.getCPtr(data), SWIGTYPE_p_int32_t.getCPtr(newCapacity));
  }

  /**
   *  create a new data buffer and copy an existing buffer<br>
   * @return a data buffer object with a copy of the data
   */
  public static SWIGTYPE_p_void helicsDataBufferClone(SWIGTYPE_p_void data) {
    long cPtr = helicsJNI.helicsDataBufferClone(SWIGTYPE_p_void.getCPtr(data));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   *  convert an integer to serialized bytes in a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param value the value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromInteger(SWIGTYPE_p_void data, long value) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromInteger(SWIGTYPE_p_void.getCPtr(data), value), true);
  }

  /**
   *  convert a double to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param value the value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromDouble(SWIGTYPE_p_void data, double value) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromDouble(SWIGTYPE_p_void.getCPtr(data), value), true);
  }

  /**
   *  convert a string to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param value the value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromString(SWIGTYPE_p_void data, String value) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromString(SWIGTYPE_p_void.getCPtr(data), value), true);
  }

  /**
   *  convert a raw string (may contain nulls) to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param str the value to serialize into the dataBuffer<br>
   * @param stringSize the size of the string value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromRawString(SWIGTYPE_p_void data, String str, int stringSize) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromRawString(SWIGTYPE_p_void.getCPtr(data), str, stringSize), true);
  }

  /**
   *  convert a bool to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param value the value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromBoolean(SWIGTYPE_p_void data, int value) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromBoolean(SWIGTYPE_p_void.getCPtr(data), value), true);
  }

  /**
   *  convert a char to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param value the value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromChar(SWIGTYPE_p_void data, char value) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromChar(SWIGTYPE_p_void.getCPtr(data), value), true);
  }

  /**
   *  convert a time to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param value the value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromTime(SWIGTYPE_p_void data, double value) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromTime(SWIGTYPE_p_void.getCPtr(data), value), true);
  }

  /**
   *  convert a complex pair to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param real the real part of the imaginary number to serialize into the dataBuffer<br>
   * @param imag the imaginary part of the imaginary number to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromComplex(SWIGTYPE_p_void data, double real, double imag) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromComplex(SWIGTYPE_p_void.getCPtr(data), real, imag), true);
  }

  /**
   *  convert a complex object to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param value the value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromComplexObject(SWIGTYPE_p_void data, HelicsComplex value) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromComplexObject(SWIGTYPE_p_void.getCPtr(data), HelicsComplex.getCPtr(value), value), true);
  }

  /**
   *  convert a real vector to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param value the value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromVector(SWIGTYPE_p_void data, double[] value, int dataSize) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromVector(SWIGTYPE_p_void.getCPtr(data), value, dataSize), true);
  }

  /**
   *  convert a named point to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param value the value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromNamedPoint(SWIGTYPE_p_void data, String name, double value) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromNamedPoint(SWIGTYPE_p_void.getCPtr(data), name, value), true);
  }

  /**
   *  convert a complex vector to serialized bytesin a buffer<br>
   * @param data the HelicsDataBuffer to fill<br>
   * @param value the value to serialize into the dataBuffer<br>
   * @return the buffer size after filling
   */
  public static SWIGTYPE_p_int32_t helicsDataBufferFillFromComplexVector(SWIGTYPE_p_void data, double[] value, int dataSize) {
    return new SWIGTYPE_p_int32_t(helicsJNI.helicsDataBufferFillFromComplexVector(SWIGTYPE_p_void.getCPtr(data), value, dataSize), true);
  }

  /**
   *  extract the data type from the data buffer, if the type isn't recognized UNKNOWN is returned
   */
  public static int helicsDataBufferType(SWIGTYPE_p_void data) {
    return helicsJNI.helicsDataBufferType(SWIGTYPE_p_void.getCPtr(data));
  }

  /**
   *  convert a data buffer to an int
   */
  public static long helicsDataBufferToInteger(SWIGTYPE_p_void data) {
    return helicsJNI.helicsDataBufferToInteger(SWIGTYPE_p_void.getCPtr(data));
  }

  /**
   *  convert a data buffer to a double
   */
  public static double helicsDataBufferToDouble(SWIGTYPE_p_void data) {
    return helicsJNI.helicsDataBufferToDouble(SWIGTYPE_p_void.getCPtr(data));
  }

  /**
   *  convert a data buffer to a boolean
   */
  public static int helicsDataBufferToBoolean(SWIGTYPE_p_void data) {
    return helicsJNI.helicsDataBufferToBoolean(SWIGTYPE_p_void.getCPtr(data));
  }

  /**
   *  convert a data buffer to a char
   */
  public static char helicsDataBufferToChar(SWIGTYPE_p_void data) {
    return helicsJNI.helicsDataBufferToChar(SWIGTYPE_p_void.getCPtr(data));
  }

  /**
   *  get the size of memory required to retrieve a string from a data buffer this includes space for a null terminator
   */
  public static int helicsDataBufferStringSize(SWIGTYPE_p_void data) {
    return helicsJNI.helicsDataBufferStringSize(SWIGTYPE_p_void.getCPtr(data));
  }

  public static void helicsDataBufferToString(SWIGTYPE_p_void data, String outputString, int maxStringLen, int[] actualLength) {
    helicsJNI.helicsDataBufferToString(SWIGTYPE_p_void.getCPtr(data), outputString, maxStringLen, actualLength);
  }

  public static void helicsDataBufferToRawString(SWIGTYPE_p_void data, String outputString, int maxStringLen, int[] actualLength) {
    helicsJNI.helicsDataBufferToRawString(SWIGTYPE_p_void.getCPtr(data), outputString, maxStringLen, actualLength);
  }

  /**
   *  convert a data buffer to a time
   */
  public static double helicsDataBufferToTime(SWIGTYPE_p_void data) {
    return helicsJNI.helicsDataBufferToTime(SWIGTYPE_p_void.getCPtr(data));
  }

  /**
   *  convert a data buffer to a complex object
   */
  public static HelicsComplex helicsDataBufferToComplexObject(SWIGTYPE_p_void data) {
    return new HelicsComplex(helicsJNI.helicsDataBufferToComplexObject(SWIGTYPE_p_void.getCPtr(data)), true);
  }

  /**
   *  convert a data buffer to complex values
   */
  public static void helicsDataBufferToComplex(SWIGTYPE_p_void data, double[] real, double[] imag) {
    helicsJNI.helicsDataBufferToComplex(SWIGTYPE_p_void.getCPtr(data), real, imag);
  }

  /**
   *  get the number of elements that would be required if a vector were retrieved
   */
  public static int helicsDataBufferVectorSize(SWIGTYPE_p_void data) {
    return helicsJNI.helicsDataBufferVectorSize(SWIGTYPE_p_void.getCPtr(data));
  }

  /**
   *  convert a data buffer to double vector values
   */
  public static void helicsDataBufferToVector(SWIGTYPE_p_void data, SWIGTYPE_p_double values, int maxlen, int[] actualSize) {
    helicsJNI.helicsDataBufferToVector(SWIGTYPE_p_void.getCPtr(data), SWIGTYPE_p_double.getCPtr(values), maxlen, actualSize);
  }

  /**
   *  convert a data buffer to complex double vector values<br>
   * @param data the buffer containing data<br>
   * @param values the storage for the converted data<br>
   * @param maxlen the number of complex values that the values vector can hold<br>
   * @param actualSize the number of complex values copied to values array
   */
  public static void helicsDataBufferToComplexVector(SWIGTYPE_p_void data, SWIGTYPE_p_double values, int maxlen, int[] actualSize) {
    helicsJNI.helicsDataBufferToComplexVector(SWIGTYPE_p_void.getCPtr(data), SWIGTYPE_p_double.getCPtr(values), maxlen, actualSize);
  }

  public static void helicsDataBufferToNamedPoint(SWIGTYPE_p_void data, byte[] outputString, int[] actualLength, double[] val) {
    helicsJNI.helicsDataBufferToNamedPoint(SWIGTYPE_p_void.getCPtr(data), outputString, actualLength, val);
  }

  /**
   *  convert the data in a data buffer to a different type representation<br>
   * @param data the buffer to convert<br>
   * @param newDataType the type that it is desired for the buffer to be converted to<br>
   * @return true if the conversion was successful
   */
  public static int helicsDataBufferConvertToType(SWIGTYPE_p_void data, int newDataType) {
    return helicsJNI.helicsDataBufferConvertToType(SWIGTYPE_p_void.getCPtr(data), newDataType);
  }

  /**
   * Get a version string for HELICS.
   */
  public static String helicsGetVersion() {
    return helicsJNI.helicsGetVersion();
  }

  /**
   * Get the build flags used to compile HELICS.
   */
  public static String helicsGetBuildFlags() {
    return helicsJNI.helicsGetBuildFlags();
  }

  /**
   * Get the compiler version used to compile HELICS.
   */
  public static String helicsGetCompilerVersion() {
    return helicsJNI.helicsGetCompilerVersion();
  }

  /**
   * Get a json formatted system information string, containing version info.<br>
   * The string contains fields with system information like cpu, core count, operating system, and memory,<br>
   * as well as information about the HELICS build.  Used for debugging reports and gathering other information.
   */
  public static String helicsGetSystemInfo() {
    return helicsJNI.helicsGetSystemInfo();
  }

  /**
   *  Load a signal handler that handles Ctrl-C and shuts down all HELICS brokers, cores,<br>
   * and federates then exits the process.
   */
  public static void helicsLoadSignalHandler() {
    helicsJNI.helicsLoadSignalHandler();
  }

  /**
   *  Load a signal handler that handles Ctrl-C and shuts down all HELICS brokers, cores,<br>
   * and federates then exits the process.  This operation will execute in a newly created and detached thread returning control back to the<br>
   * calling program before completing operations.
   */
  public static void helicsLoadThreadedSignalHandler() {
    helicsJNI.helicsLoadThreadedSignalHandler();
  }

  /**
   *  Clear HELICS based signal handlers.
   */
  public static void helicsClearSignalHandler() {
    helicsJNI.helicsClearSignalHandler();
  }

  /**
   *  Load a custom signal handler to execute prior to the abort signal handler. The signal handler does not call exit.<br>
   * This function is not 100% reliable. It will most likely work but uses some functions and<br>
   * techniques that are not 100% guaranteed to work in a signal handler<br>
   * and in worst case it could deadlock.  That is somewhat unlikely given usage patterns<br>
   * but it is possible.  The callback has signature HelicsBool(*handler)(int) and it will take the SIG_INT as an argument<br>
   * and return a boolean.  If the boolean return value is HELICS_TRUE (or the callback is null) the no exit signal handler is run after the<br>
   * callback finishes; if it is HELICS_FALSE the default callback is not run and the default signal handler is executed. If the second<br>
   * argument is set to HELICS_TRUE the default signal handler will execute in a separate thread (this may be a bad idea). 
   */
  public static void helicsLoadSignalHandlerCallbackNoExit(SWIGTYPE_p_f_int__int handler, int useSeparateThread) {
    helicsJNI.helicsLoadSignalHandlerCallbackNoExit(SWIGTYPE_p_f_int__int.getCPtr(handler), useSeparateThread);
  }

  /**
   *  Execute a global abort by sending an error code to all cores, brokers,<br>
   * and federates that were created through the current library instance.
   */
  public static void helicsAbort(int errorCode, String errorString) {
    helicsJNI.helicsAbort(errorCode, errorString);
  }

  /**
   * Returns true if core/broker type specified is available in current compilation.<br>
   * <br>
   * @param type A string representing a core type.<br>
   * <br>
   * Options include "zmq", "udp", "ipc", "interprocess", "tcp", "default", "mpi".
   */
  public static int helicsIsCoreTypeAvailable(String type) {
    return helicsJNI.helicsIsCoreTypeAvailable(type);
  }

  /**
   * Create a core object.<br>
   * <br>
   * @param type The type of the core to create.<br>
   * @param name The name of the core. It can be a nullptr or empty string to have a name automatically assigned.<br>
   * @param initString An initialization string to send to the core. The format is similar to command line arguments.<br>
   *                   Typical options include a broker name, the broker address, the number of federates, etc.  Can also be a<br>
   *                   file (toml, ini, json) or json object containing the core configuration.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return A HelicsCore object.<br>
   * <br>
   * If the core is invalid, err will contain the corresponding error message and the returned object will be NULL.
   */
  public static SWIGTYPE_p_void helicsCreateCore(String type, String name, String initString) {
    long cPtr = helicsJNI.helicsCreateCore(type, name, initString);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a core object by passing command line arguments.<br>
   * <br>
   * @param type The type of the core to create.<br>
   * @param name The name of the core. It can be a nullptr or empty string to have a name automatically assigned.<br>
   * <br>
   * @param argc The number of arguments.<br>
   * <br>
   * @param argv The list of string values from a command line.<br>
   * <br>
   * @param err An error object that will contain an error code and string<br>
   *                    if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return A HelicsCore object.
   */
  public static SWIGTYPE_p_void helicsCreateCoreFromArgs(String type, String name, String[] argc) {
    long cPtr = helicsJNI.helicsCreateCoreFromArgs(type, name, argc);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a new reference to an existing core.<br>
   * <br>
   * This will create a new broker object that references the existing broker. The new broker object must be freed as well.<br>
   * <br>
   * @param core An existing HelicsCore.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return A new reference to the same broker.
   */
  public static SWIGTYPE_p_void helicsCoreClone(SWIGTYPE_p_void core) {
    long cPtr = helicsJNI.helicsCoreClone(SWIGTYPE_p_void.getCPtr(core));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Check if a core object is a valid object.<br>
   * <br>
   * @param core The HelicsCore object to test.
   */
  public static int helicsCoreIsValid(SWIGTYPE_p_void core) {
    return helicsJNI.helicsCoreIsValid(SWIGTYPE_p_void.getCPtr(core));
  }

  /**
   * Create a broker object.<br>
   * <br>
   * @param type The type of the broker to create.<br>
   * @param name The name of the broker. It can be a nullptr or empty string to have a name automatically assigned.<br>
   * @param initString An initialization string to send to the core-the format is similar to command line arguments.<br>
   *                   Typical options include a broker address such as --broker="XSSAF" if this is a subbroker, or the number of federates,<br>
   *                    or it can also be a json or toml file with broker configuration.<br>
   * or the address.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return A HelicsBroker object.<br>
   * <br>
   * It will be NULL if there was an error indicated in the err object.
   */
  public static SWIGTYPE_p_void helicsCreateBroker(String type, String name, String initString) {
    long cPtr = helicsJNI.helicsCreateBroker(type, name, initString);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a core object by passing command line arguments.<br>
   * <br>
   * @param type The type of the core to create.<br>
   * @param name The name of the core. It can be a nullptr or empty string to have a name automatically assigned.<br>
   * @param argc The number of arguments.<br>
   * @param argv The list of string values from a command line.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return A HelicsCore object.
   */
  public static SWIGTYPE_p_void helicsCreateBrokerFromArgs(String type, String name, String[] argc) {
    long cPtr = helicsJNI.helicsCreateBrokerFromArgs(type, name, argc);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a new reference to an existing broker.<br>
   * <br>
   * This will create a new broker object that references the existing broker it must be freed as well.<br>
   * <br>
   * @param broker An existing HelicsBroker.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return A new reference to the same broker.
   */
  public static SWIGTYPE_p_void helicsBrokerClone(SWIGTYPE_p_void broker) {
    long cPtr = helicsJNI.helicsBrokerClone(SWIGTYPE_p_void.getCPtr(broker));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Check if a broker object is a valid object.<br>
   * <br>
   * @param broker The HelicsBroker object to test.
   */
  public static int helicsBrokerIsValid(SWIGTYPE_p_void broker) {
    return helicsJNI.helicsBrokerIsValid(SWIGTYPE_p_void.getCPtr(broker));
  }

  /**
   * Check if a broker is connected.<br>
   * <br>
   * A connected broker implies it is attached to cores or cores could reach out to communicate.<br>
   * <br>
   * @return HELICS_FALSE if not connected.
   */
  public static int helicsBrokerIsConnected(SWIGTYPE_p_void broker) {
    return helicsJNI.helicsBrokerIsConnected(SWIGTYPE_p_void.getCPtr(broker));
  }

  /**
   * Link a named publication and named input using a broker.<br>
   * <br>
   * @param broker The broker to generate the connection from.<br>
   * @param source The name of the publication (cannot be NULL).<br>
   * @param target The name of the target to send the publication data (cannot be NULL).<br>
   * <br>
   * @param err A HelicsError object, can be NULL if the errors are to be ignored.
   */
  public static void helicsBrokerDataLink(SWIGTYPE_p_void broker, String source, String target) {
    helicsJNI.helicsBrokerDataLink(SWIGTYPE_p_void.getCPtr(broker), source, target);
  }

  /**
   * Link a named filter to a source endpoint.<br>
   * <br>
   * @param broker The broker to generate the connection from.<br>
   * @param filter The name of the filter (cannot be NULL).<br>
   * @param endpoint The name of the endpoint to filter the data from (cannot be NULL).<br>
   * <br>
   * @param err A HelicsError object, can be NULL if the errors are to be ignored.
   */
  public static void helicsBrokerAddSourceFilterToEndpoint(SWIGTYPE_p_void broker, String filter, String endpoint) {
    helicsJNI.helicsBrokerAddSourceFilterToEndpoint(SWIGTYPE_p_void.getCPtr(broker), filter, endpoint);
  }

  /**
   * Link a named filter to a destination endpoint.<br>
   * <br>
   * @param broker The broker to generate the connection from.<br>
   * @param filter The name of the filter (cannot be NULL).<br>
   * @param endpoint The name of the endpoint to filter the data going to (cannot be NULL).<br>
   * <br>
   * @param err A HelicsError object, can be NULL if the errors are to be ignored.
   */
  public static void helicsBrokerAddDestinationFilterToEndpoint(SWIGTYPE_p_void broker, String filter, String endpoint) {
    helicsJNI.helicsBrokerAddDestinationFilterToEndpoint(SWIGTYPE_p_void.getCPtr(broker), filter, endpoint);
  }

  /**
   * Load a file containing connection information.<br>
   * <br>
   * @param broker The broker to generate the connections from.<br>
   * @param file A JSON or TOML file containing connection information.<br>
   * <br>
   * @param err A HelicsError object, can be NULL if the errors are to be ignored.
   */
  public static void helicsBrokerMakeConnections(SWIGTYPE_p_void broker, String file) {
    helicsJNI.helicsBrokerMakeConnections(SWIGTYPE_p_void.getCPtr(broker), file);
  }

  /**
   * Wait for the core to disconnect.<br>
   * <br>
   * @param core The core to wait for.<br>
   * @param msToWait The time out in millisecond (&lt;0 for infinite timeout).<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return HELICS_TRUE if the disconnect was successful, HELICS_FALSE if there was a timeout.
   */
  public static int helicsCoreWaitForDisconnect(SWIGTYPE_p_void core, int msToWait) {
    return helicsJNI.helicsCoreWaitForDisconnect(SWIGTYPE_p_void.getCPtr(core), msToWait);
  }

  /**
   * Wait for the broker to disconnect.<br>
   * <br>
   * @param broker The broker to wait for.<br>
   * @param msToWait The time out in millisecond (&lt;0 for infinite timeout).<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return HELICS_TRUE if the disconnect was successful, HELICS_FALSE if there was a timeout.
   */
  public static int helicsBrokerWaitForDisconnect(SWIGTYPE_p_void broker, int msToWait) {
    return helicsJNI.helicsBrokerWaitForDisconnect(SWIGTYPE_p_void.getCPtr(broker), msToWait);
  }

  /**
   * Check if a core is connected.<br>
   * <br>
   * A connected core implies it is attached to federates or federates could be attached to it<br>
   * <br>
   * @return HELICS_FALSE if not connected, HELICS_TRUE if it is connected.
   */
  public static int helicsCoreIsConnected(SWIGTYPE_p_void core) {
    return helicsJNI.helicsCoreIsConnected(SWIGTYPE_p_void.getCPtr(core));
  }

  /**
   * Link a named publication and named input using a core.<br>
   * <br>
   * @param core The core to generate the connection from.<br>
   * @param source The name of the publication (cannot be NULL).<br>
   * @param target The name of the target to send the publication data (cannot be NULL).<br>
   * <br>
   * @param err A HelicsError object, can be NULL if the errors are to be ignored.
   */
  public static void helicsCoreDataLink(SWIGTYPE_p_void core, String source, String target) {
    helicsJNI.helicsCoreDataLink(SWIGTYPE_p_void.getCPtr(core), source, target);
  }

  /**
   * Link a named filter to a source endpoint.<br>
   * <br>
   * @param core The core to generate the connection from.<br>
   * @param filter The name of the filter (cannot be NULL).<br>
   * @param endpoint The name of the endpoint to filter the data from (cannot be NULL).<br>
   * <br>
   * @param err A HelicsError object, can be NULL if the errors are to be ignored.
   */
  public static void helicsCoreAddSourceFilterToEndpoint(SWIGTYPE_p_void core, String filter, String endpoint) {
    helicsJNI.helicsCoreAddSourceFilterToEndpoint(SWIGTYPE_p_void.getCPtr(core), filter, endpoint);
  }

  /**
   * Link a named filter to a destination endpoint.<br>
   * <br>
   * @param core The core to generate the connection from.<br>
   * @param filter The name of the filter (cannot be NULL).<br>
   * @param endpoint The name of the endpoint to filter the data going to (cannot be NULL).<br>
   * <br>
   * @param err A HelicsError object, can be NULL if the errors are to be ignored.
   */
  public static void helicsCoreAddDestinationFilterToEndpoint(SWIGTYPE_p_void core, String filter, String endpoint) {
    helicsJNI.helicsCoreAddDestinationFilterToEndpoint(SWIGTYPE_p_void.getCPtr(core), filter, endpoint);
  }

  /**
   * Load a file containing connection information.<br>
   * <br>
   * @param core The core to generate the connections from.<br>
   * @param file A JSON or TOML file containing connection information.<br>
   * <br>
   * @param err A HelicsError object, can be NULL if the errors are to be ignored.
   */
  public static void helicsCoreMakeConnections(SWIGTYPE_p_void core, String file) {
    helicsJNI.helicsCoreMakeConnections(SWIGTYPE_p_void.getCPtr(core), file);
  }

  /**
   * Get an identifier for the broker.<br>
   * <br>
   * @param broker The broker to query.<br>
   * <br>
   * @return A string containing the identifier for the broker.
   */
  public static String helicsBrokerGetIdentifier(SWIGTYPE_p_void broker) {
    return helicsJNI.helicsBrokerGetIdentifier(SWIGTYPE_p_void.getCPtr(broker));
  }

  /**
   * Get an identifier for the core.<br>
   * <br>
   * @param core The core to query.<br>
   * <br>
   * @return A string with the identifier of the core.
   */
  public static String helicsCoreGetIdentifier(SWIGTYPE_p_void core) {
    return helicsJNI.helicsCoreGetIdentifier(SWIGTYPE_p_void.getCPtr(core));
  }

  /**
   * Get the network address associated with a broker.<br>
   * <br>
   * @param broker The broker to query.<br>
   * <br>
   * @return A string with the network address of the broker.
   */
  public static String helicsBrokerGetAddress(SWIGTYPE_p_void broker) {
    return helicsJNI.helicsBrokerGetAddress(SWIGTYPE_p_void.getCPtr(broker));
  }

  /**
   * Get the network address associated with a core.<br>
   * <br>
   * @param core The core to query.<br>
   * <br>
   * @return A string with the network address of the broker.
   */
  public static String helicsCoreGetAddress(SWIGTYPE_p_void core) {
    return helicsJNI.helicsCoreGetAddress(SWIGTYPE_p_void.getCPtr(core));
  }

  /**
   * Set the core to ready for init.<br>
   * <br>
   * This function is used for cores that have filters but no federates so there needs to be<br>
   *          a direct signal to the core to trigger the federation initialization.<br>
   * <br>
   * @param core The core object to enable init values for.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsCoreSetReadyToInit(SWIGTYPE_p_void core) {
    helicsJNI.helicsCoreSetReadyToInit(SWIGTYPE_p_void.getCPtr(core));
  }

  /**
   * Connect a core to the federate based on current configuration.<br>
   * <br>
   * @param core The core to connect.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return HELICS_FALSE if not connected, HELICS_TRUE if it is connected.
   */
  public static int helicsCoreConnect(SWIGTYPE_p_void core) {
    return helicsJNI.helicsCoreConnect(SWIGTYPE_p_void.getCPtr(core));
  }

  /**
   * Disconnect a core from the federation.<br>
   * <br>
   * @param core The core to query.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsCoreDisconnect(SWIGTYPE_p_void core) {
    helicsJNI.helicsCoreDisconnect(SWIGTYPE_p_void.getCPtr(core));
  }

  /**
   * Get an existing federate object from a core by name.<br>
   * <br>
   * The federate must have been created by one of the other functions and at least one of the objects referencing the created<br>
   *          federate must still be active in the process.<br>
   * <br>
   * @param fedName The name of the federate to retrieve.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return NULL if no fed is available by that name otherwise a HelicsFederate with that name.
   */
  public static SWIGTYPE_p_void helicsGetFederateByName(String fedName) {
    long cPtr = helicsJNI.helicsGetFederateByName(fedName);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Disconnect a broker.<br>
   * <br>
   * @param broker The broker to disconnect.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsBrokerDisconnect(SWIGTYPE_p_void broker) {
    helicsJNI.helicsBrokerDisconnect(SWIGTYPE_p_void.getCPtr(broker));
  }

  /**
   * Disconnect and free a federate.
   */
  public static void helicsFederateDestroy(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateDestroy(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Disconnect and free a broker.
   */
  public static void helicsBrokerDestroy(SWIGTYPE_p_void broker) {
    helicsJNI.helicsBrokerDestroy(SWIGTYPE_p_void.getCPtr(broker));
  }

  /**
   * Disconnect and free a core.
   */
  public static void helicsCoreDestroy(SWIGTYPE_p_void core) {
    helicsJNI.helicsCoreDestroy(SWIGTYPE_p_void.getCPtr(core));
  }

  /**
   * Release the memory associated with a core.
   */
  public static void helicsCoreFree(SWIGTYPE_p_void core) {
    helicsJNI.helicsCoreFree(SWIGTYPE_p_void.getCPtr(core));
  }

  /**
   * Release the memory associated with a broker.
   */
  public static void helicsBrokerFree(SWIGTYPE_p_void broker) {
    helicsJNI.helicsBrokerFree(SWIGTYPE_p_void.getCPtr(broker));
  }

  /**
   * Create a value federate from a federate info object.<br>
   * <br>
   * HelicsFederate objects can be used in all functions that take a HelicsFederate or HelicsFederate object as an argument.<br>
   * <br>
   * @param fedName The name of the federate to create, can NULL or an empty string to use the default name from fedInfo or an assigned name.<br>
   * @param fedInfo The federate info object that contains details on the federate.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return An opaque value federate object.
   */
  public static SWIGTYPE_p_void helicsCreateValueFederate(String fedName, SWIGTYPE_p_void fedInfo) {
    long cPtr = helicsJNI.helicsCreateValueFederate(fedName, SWIGTYPE_p_void.getCPtr(fedInfo));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a value federate from a JSON file, JSON string, or TOML file.<br>
   * <br>
   * HelicsFederate objects can be used in all functions that take a HelicsFederate or HelicsFederate object as an argument.<br>
   * <br>
   * @param configFile A JSON file or a JSON string or TOML file that contains setup and configuration information.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return An opaque value federate object.
   */
  public static SWIGTYPE_p_void helicsCreateValueFederateFromConfig(String configFile) {
    long cPtr = helicsJNI.helicsCreateValueFederateFromConfig(configFile);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a message federate from a federate info object.<br>
   * <br>
   * helics_message_federate objects can be used in all functions that take a helics_message_federate or HelicsFederate object as an<br>
   * argument.<br>
   * <br>
   * @param fedName The name of the federate to create.<br>
   * @param fedInfo The federate info object that contains details on the federate.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return An opaque message federate object.
   */
  public static SWIGTYPE_p_void helicsCreateMessageFederate(String fedName, SWIGTYPE_p_void fedInfo) {
    long cPtr = helicsJNI.helicsCreateMessageFederate(fedName, SWIGTYPE_p_void.getCPtr(fedInfo));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a message federate from a JSON file or JSON string or TOML file.<br>
   * <br>
   * helics_message_federate objects can be used in all functions that take a helics_message_federate or HelicsFederate object as an<br>
   * argument.<br>
   * <br>
   * @param configFile A Config(JSON,TOML) file or a JSON string that contains setup and configuration information.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return An opaque message federate object.
   */
  public static SWIGTYPE_p_void helicsCreateMessageFederateFromConfig(String configFile) {
    long cPtr = helicsJNI.helicsCreateMessageFederateFromConfig(configFile);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a combination federate from a federate info object.<br>
   * <br>
   * Combination federates are both value federates and message federates, objects can be used in all functions<br>
   *                      that take a HelicsFederate, helics_message_federate or HelicsFederate object as an argument<br>
   * <br>
   * @param fedName A string with the name of the federate, can be NULL or an empty string to pull the default name from fedInfo.<br>
   * @param fedInfo The federate info object that contains details on the federate.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return An opaque value federate object nullptr if the object creation failed.
   */
  public static SWIGTYPE_p_void helicsCreateCombinationFederate(String fedName, SWIGTYPE_p_void fedInfo) {
    long cPtr = helicsJNI.helicsCreateCombinationFederate(fedName, SWIGTYPE_p_void.getCPtr(fedInfo));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a combination federate from a JSON file or JSON string or TOML file.<br>
   * <br>
   * Combination federates are both value federates and message federates, objects can be used in all functions<br>
   *          that take a HelicsFederate, helics_message_federate or HelicsFederate object as an argument<br>
   * <br>
   * @param configFile A JSON file or a JSON string,TOML file, or command line arguments that contains setup and configuration information.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return An opaque combination federate object.
   */
  public static SWIGTYPE_p_void helicsCreateCombinationFederateFromConfig(String configFile) {
    long cPtr = helicsJNI.helicsCreateCombinationFederateFromConfig(configFile);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a callback federate from a federate info object.<br>
   * <br>
   * Callback federates are combination federates that run a series of callback for execution in a completely automated fashion.<br>
   * <br>
   * @param fedName A string with the name of the federate, can be NULL or an empty string to pull the default name from fedInfo.<br>
   * @param fedInfo The federate info object that contains details on the federate.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return An opaque value federate object; nullptr if the object creation failed.
   */
  public static SWIGTYPE_p_void helicsCreateCallbackFederate(String fedName, SWIGTYPE_p_void fedInfo) {
    long cPtr = helicsJNI.helicsCreateCallbackFederate(fedName, SWIGTYPE_p_void.getCPtr(fedInfo));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a callback federate from a JSON file or JSON string or TOML file.<br>
   * <br>
   * Callback federates are combination federates that run a series of callbacks for execution in a completely automated fashion.<br>
   * The enterInitializingMode call transfers complete control of the federate to the Core and no further user interaction is expected.<br>
   * <br>
   * @param configFile A JSON file or a JSON string or TOML file that contains setup and configuration information.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return An opaque combination federate object.
   */
  public static SWIGTYPE_p_void helicsCreateCallbackFederateFromConfig(String configFile) {
    long cPtr = helicsJNI.helicsCreateCallbackFederateFromConfig(configFile);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a new reference to an existing federate.<br>
   * <br>
   * This will create a new HelicsFederate object that references the existing federate. The new object must be freed as well.<br>
   * <br>
   * @param fed An existing HelicsFederate.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return A new reference to the same federate.
   */
  public static SWIGTYPE_p_void helicsFederateClone(SWIGTYPE_p_void fed) {
    long cPtr = helicsJNI.helicsFederateClone(SWIGTYPE_p_void.getCPtr(fed));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Protect a federate from finalizing and closing if all references go out of scope<br>
   * <br>
   * this function allows a federate to be retrieved on demand, it must be explicitly close later otherwise it will be destroyed<br>
   * when the library is closed<br>
   * <br>
   * @param fedName The name of an existing HelicsFederate.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error<br>
   *  occurred during the execution of the function, in particular if no federate with the given name exists
   */
  public static void helicsFederateProtect(String fedName) {
    helicsJNI.helicsFederateProtect(fedName);
  }

  /**
   * remove the protection of an existing federate<br>
   * <br>
   * this function allows a federate to be retrieved on demand, it must be explicitly close<br>
   *  later otherwise it will be destroyed<br>
   * when the library is closed<br>
   * <br>
   * @param fedName the name of an existing federate that should not be protected<br>
   * <br>
   * @param err An error object that will contain an error code and string if the federate was not found.
   */
  public static void helicsFederateUnProtect(String fedName) {
    helicsJNI.helicsFederateUnProtect(fedName);
  }

  /**
   * checks if an existing federate is protected<br>
   * <br>
   * <br>
   * @param fedName the name of an existing federate to check the protection status<br>
   * <br>
   * @param err An error object that will contain an error code and string if the federate was not found.
   */
  public static int helicsFederateIsProtected(String fedName) {
    return helicsJNI.helicsFederateIsProtected(fedName);
  }

  /**
   * Create a federate info object for specifying federate information when constructing a federate.<br>
   * <br>
   * @return A HelicsFederateInfo object which is a reference to the created object.
   */
  public static SWIGTYPE_p_void helicsCreateFederateInfo() {
    long cPtr = helicsJNI.helicsCreateFederateInfo();
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a federate info object from an existing one and clone the information.<br>
   * <br>
   * @param fedInfo A federateInfo object to duplicate.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   *  @return A HelicsFederateInfo object which is a reference to the created object.
   */
  public static SWIGTYPE_p_void helicsFederateInfoClone(SWIGTYPE_p_void fedInfo) {
    long cPtr = helicsJNI.helicsFederateInfoClone(SWIGTYPE_p_void.getCPtr(fedInfo));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Load federate info from command line arguments.<br>
   * <br>
   * @param fedInfo A federateInfo object.<br>
   * @param argc The number of command line arguments.<br>
   * @param argv An array of strings from the command line.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoLoadFromArgs(SWIGTYPE_p_void fedInfo, String[] argc) {
    helicsJNI.helicsFederateInfoLoadFromArgs(SWIGTYPE_p_void.getCPtr(fedInfo), argc);
  }

  /**
   * Load federate info from command line arguments contained in a string.<br>
   * <br>
   * @param fedInfo A federateInfo object.<br>
   * @param args Command line arguments specified in a string.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoLoadFromString(SWIGTYPE_p_void fedInfo, String args) {
    helicsJNI.helicsFederateInfoLoadFromString(SWIGTYPE_p_void.getCPtr(fedInfo), args);
  }

  /**
   * Delete the memory associated with a federate info object.
   */
  public static void helicsFederateInfoFree(SWIGTYPE_p_void fedInfo) {
    helicsJNI.helicsFederateInfoFree(SWIGTYPE_p_void.getCPtr(fedInfo));
  }

  /**
   * Check if a federate_object is valid.<br>
   * <br>
   * @return HELICS_TRUE if the federate is a valid active federate, HELICS_FALSE otherwise
   */
  public static int helicsFederateIsValid(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateIsValid(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Set the name of the core to link to for a federate.<br>
   * <br>
   * @param fedInfo The federate info object to alter.<br>
   * @param corename The identifier for a core to link to.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetCoreName(SWIGTYPE_p_void fedInfo, String corename) {
    helicsJNI.helicsFederateInfoSetCoreName(SWIGTYPE_p_void.getCPtr(fedInfo), corename);
  }

  /**
   * Set the initialization string for the core usually in the form of command line arguments.<br>
   * <br>
   * @param fedInfo The federate info object to alter.<br>
   * @param coreInit A string containing command line arguments to be passed to the core.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetCoreInitString(SWIGTYPE_p_void fedInfo, String coreInit) {
    helicsJNI.helicsFederateInfoSetCoreInitString(SWIGTYPE_p_void.getCPtr(fedInfo), coreInit);
  }

  /**
   * Set the initialization string that a core will pass to a generated broker usually in the form of command line arguments.<br>
   * <br>
   * @param fedInfo The federate info object to alter.<br>
   * @param brokerInit A string with command line arguments for a generated broker.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetBrokerInitString(SWIGTYPE_p_void fedInfo, String brokerInit) {
    helicsJNI.helicsFederateInfoSetBrokerInitString(SWIGTYPE_p_void.getCPtr(fedInfo), brokerInit);
  }

  /**
   * Set the core type by integer code.<br>
   * <br>
   * Valid values available by definitions in api-data.h.<br>
   * @param fedInfo The federate info object to alter.<br>
   * @param coretype An numerical code for a core type see /ref helics_CoreType.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetCoreType(SWIGTYPE_p_void fedInfo, int coretype) {
    helicsJNI.helicsFederateInfoSetCoreType(SWIGTYPE_p_void.getCPtr(fedInfo), coretype);
  }

  /**
   * Set the core type from a string.<br>
   * <br>
   * @param fedInfo The federate info object to alter.<br>
   * @param coretype A string naming a core type.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetCoreTypeFromString(SWIGTYPE_p_void fedInfo, String coretype) {
    helicsJNI.helicsFederateInfoSetCoreTypeFromString(SWIGTYPE_p_void.getCPtr(fedInfo), coretype);
  }

  /**
   * Set the name or connection information for a broker.<br>
   * <br>
   * This is only used if the core is automatically created, the broker information will be transferred to the core for connection.<br>
   * @param fedInfo The federate info object to alter.<br>
   * @param broker A string which defines the connection information for a broker either a name or an address.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetBroker(SWIGTYPE_p_void fedInfo, String broker) {
    helicsJNI.helicsFederateInfoSetBroker(SWIGTYPE_p_void.getCPtr(fedInfo), broker);
  }

  /**
   * Set the key for a broker connection.<br>
   * <br>
   * This is only used if the core is automatically created, the broker information will be transferred to the core for connection.<br>
   * @param fedInfo The federate info object to alter.<br>
   * @param brokerkey A string containing a key for the broker to connect.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetBrokerKey(SWIGTYPE_p_void fedInfo, String brokerkey) {
    helicsJNI.helicsFederateInfoSetBrokerKey(SWIGTYPE_p_void.getCPtr(fedInfo), brokerkey);
  }

  /**
   * Set the port to use for the broker.<br>
   * <br>
   * This is only used if the core is automatically created, the broker information will be transferred to the core for connection.<br>
   * This will only be useful for network broker connections.<br>
   * @param fedInfo The federate info object to alter.<br>
   * @param brokerPort The integer port number to use for connection with a broker.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetBrokerPort(SWIGTYPE_p_void fedInfo, int brokerPort) {
    helicsJNI.helicsFederateInfoSetBrokerPort(SWIGTYPE_p_void.getCPtr(fedInfo), brokerPort);
  }

  /**
   * Set the local port to use.<br>
   * <br>
   * This is only used if the core is automatically created, the port information will be transferred to the core for connection.<br>
   * @param fedInfo The federate info object to alter.<br>
   * @param localPort A string with the port information to use as the local server port can be a number or "auto" or "os_local".<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetLocalPort(SWIGTYPE_p_void fedInfo, String localPort) {
    helicsJNI.helicsFederateInfoSetLocalPort(SWIGTYPE_p_void.getCPtr(fedInfo), localPort);
  }

  /**
   * Get a property index for use in /ref helicsFederateInfoSetFlagOption, /ref helicsFederateInfoSetTimeProperty,<br>
   * or /ref helicsFederateInfoSetIntegerProperty<br>
   * @param val A string with the property name.<br>
   * @return An int with the property code or (-1) if not a valid property.
   */
  public static int helicsGetPropertyIndex(String val) {
    return helicsJNI.helicsGetPropertyIndex(val);
  }

  /**
   * Get a property index for use in /ref helicsFederateInfoSetFlagOption, /ref helicsFederateSetFlagOption,<br>
   * @param val A string with the option name.<br>
   * @return An int with the property code or (-1) if not a valid property.
   */
  public static int helicsGetFlagIndex(String val) {
    return helicsJNI.helicsGetFlagIndex(val);
  }

  /**
   * Get an option index for use in /ref helicsPublicationSetOption, /ref helicsInputSetOption, /ref helicsEndpointSetOption,<br>
   * /ref helicsFilterSetOption, and the corresponding get functions.<br>
   * <br>
   * @param val A string with the option name.<br>
   * <br>
   * @return An int with the option index or (-1) if not a valid property.
   */
  public static int helicsGetOptionIndex(String val) {
    return helicsJNI.helicsGetOptionIndex(val);
  }

  /**
   * Get an option value for use in /ref helicsPublicationSetOption, /ref helicsInputSetOption, /ref helicsEndpointSetOption,<br>
   * /ref helicsFilterSetOption.<br>
   * <br>
   * @param val A string representing the value.<br>
   * <br>
   * @return An int with the option value or (-1) if not a valid value.
   */
  public static int helicsGetOptionValue(String val) {
    return helicsJNI.helicsGetOptionValue(val);
  }

  /**
   * Get the data type for use in /ref helicsFederateRegisterPublication, /ref helicsFederateRegisterInput,<br>
   * /ref helicsFilterSetOption.<br>
   * <br>
   * @param val A string representing a data type.<br>
   * <br>
   * @return An int with the data type or HELICS_DATA_TYPE_UNKNOWN(-1) if not a valid value.
   */
  public static int helicsGetDataType(String val) {
    return helicsJNI.helicsGetDataType(val);
  }

  /**
   * Set a flag in the info structure.<br>
   * <br>
   * Valid flags are available /ref helics_federate_flags.<br>
   * @param fedInfo The federate info object to alter.<br>
   * @param flag A numerical index for a flag.<br>
   * @param value The desired value of the flag HELICS_TRUE or HELICS_FALSE.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetFlagOption(SWIGTYPE_p_void fedInfo, int flag, int value) {
    helicsJNI.helicsFederateInfoSetFlagOption(SWIGTYPE_p_void.getCPtr(fedInfo), flag, value);
  }

  /**
   * Set the separator character in the info structure.<br>
   * <br>
   * The separator character is the separation character for local publications/endpoints in creating their global name.<br>
   * For example if the separator character is '/'  then a local endpoint would have a globally reachable name of fedName/localName.<br>
   * @param fedInfo The federate info object to alter.<br>
   * @param separator The character to use as a separator.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetSeparator(SWIGTYPE_p_void fedInfo, char separator) {
    helicsJNI.helicsFederateInfoSetSeparator(SWIGTYPE_p_void.getCPtr(fedInfo), separator);
  }

  /**
   * Set the output delay for a federate.<br>
   * <br>
   * @param fedInfo The federate info object to alter.<br>
   * @param timeProperty An integer representation of the time based property to set see /ref helics_properties.<br>
   * @param propertyValue The value of the property to set the timeProperty to.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetTimeProperty(SWIGTYPE_p_void fedInfo, int timeProperty, double propertyValue) {
    helicsJNI.helicsFederateInfoSetTimeProperty(SWIGTYPE_p_void.getCPtr(fedInfo), timeProperty, propertyValue);
  }

  /**
   * Set an integer property for a federate.<br>
   * <br>
   * Set known properties.<br>
   * <br>
   * @param fedInfo The federateInfo object to alter.<br>
   * @param intProperty An int identifying the property.<br>
   * @param propertyValue The value to set the property to.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateInfoSetIntegerProperty(SWIGTYPE_p_void fedInfo, int intProperty, int propertyValue) {
    helicsJNI.helicsFederateInfoSetIntegerProperty(SWIGTYPE_p_void.getCPtr(fedInfo), intProperty, propertyValue);
  }

  /**
   * Load interfaces from a file.<br>
   * <br>
   * @param fed The federate to which to load interfaces.<br>
   * @param file The name of a file to load the interfaces from either JSON, or TOML.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateRegisterInterfaces(SWIGTYPE_p_void fed, String file) {
    helicsJNI.helicsFederateRegisterInterfaces(SWIGTYPE_p_void.getCPtr(fed), file);
  }

  /**
   * Generate a global error from a federate.<br>
   * <br>
   * A global error halts the co-simulation completely.<br>
   * <br>
   * @param fed The federate to create an error in.<br>
   * @param errorCode The integer code for the error.<br>
   * @param errorString A string describing the error.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateGlobalError(SWIGTYPE_p_void fed, int errorCode, String errorString) {
    helicsJNI.helicsFederateGlobalError(SWIGTYPE_p_void.getCPtr(fed), errorCode, errorString);
  }

  /**
   * Generate a local error in a federate.<br>
   * <br>
   * This will propagate through the co-simulation but not necessarily halt the co-simulation, it has a similar effect to finalize<br>
   * but does allow some interaction with a core for a brief time.<br>
   * @param fed The federate to create an error in.<br>
   * @param errorCode The integer code for the error.<br>
   * @param errorString A string describing the error.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateLocalError(SWIGTYPE_p_void fed, int errorCode, String errorString) {
    helicsJNI.helicsFederateLocalError(SWIGTYPE_p_void.getCPtr(fed), errorCode, errorString);
  }

  /**
   * Disconnect/finalize the federate. This function halts all communication in the federate and disconnects it from the core.
   */
  public static void helicsFederateFinalize(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateFinalize(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Disconnect/finalize the federate in an async call.
   */
  public static void helicsFederateFinalizeAsync(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateFinalizeAsync(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Complete the asynchronous disconnect/finalize call.
   */
  public static void helicsFederateFinalizeComplete(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateFinalizeComplete(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Disconnect/finalize the federate. This function halts all communication in the federate and disconnects it<br>
   * from the core.  This call is identical to helicsFederateFinalize.
   */
  public static void helicsFederateDisconnect(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateDisconnect(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Disconnect/finalize the federate in an async call.  This call is identical to helicsFederateFinalizeAsync.
   */
  public static void helicsFederateDisconnectAsync(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateDisconnectAsync(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Complete the asynchronous disconnect/finalize call.  This call is identical to helicsFederateFinalizeComplete
   */
  public static void helicsFederateDisconnectComplete(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateDisconnectComplete(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Release the memory associated with a federate.
   */
  public static void helicsFederateFree(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateFree(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Call when done using the helics library.<br>
   * This function will ensure the threads are closed properly. If possible this should be the last call before exiting.
   */
  public static void helicsCloseLibrary() {
    helicsJNI.helicsCloseLibrary();
  }

  /**
   * Enter the initialization state of a federate.<br>
   * <br>
   * The initialization state allows initial values to be set and received if the iteration is requested on entry to the execution<br>
   * state. This is a blocking call and will block until the core allows it to proceed.<br>
   * <br>
   * @param fed The federate to operate on.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateEnterInitializingMode(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateEnterInitializingMode(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Non blocking alternative to <a href="#helicsFederateEnterInitializingMode">helicsFederateEnterInitializingMode</a>.<br>
   * <br>
   * The function helicsFederateEnterInitializationModeComplete must be called to finish the operation.<br>
   * <br>
   * @param fed The federate to operate on.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateEnterInitializingModeAsync(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateEnterInitializingModeAsync(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Complete the entry to initialize mode that was initiated with /ref heliceEnterInitializingModeAsync.<br>
   * <br>
   * @param fed The federate desiring to complete the initialization step.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateEnterInitializingModeComplete(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateEnterInitializingModeComplete(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Trigger a blocking call and return to created state after all federates have either triggered an iteration or are waiting to enter<br>
   * initializing mode.<br>
   * <br>
   * This call will return the federate to the created state to allow additional setup to occur with federates either iterating in<br>
   * the mode or waiting.<br>
   * <br>
   * @param fed The federate to operate on.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateEnterInitializingModeIterative(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateEnterInitializingModeIterative(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Non blocking alternative to <a href="#helicsFederateEnterInitializingModeIterative">helicsFederateEnterInitializingModeIterative</a>.<br>
   * <br>
   * The function helicsFederateEnterInitializationModeIterativeComplete must be called to finish the operation.<br>
   * <br>
   * @param fed The federate to operate on.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateEnterInitializingModeIterativeAsync(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateEnterInitializingModeIterativeAsync(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Complete the call to enter initializing mode Iterative that was initiated with /ref heliceEnterInitializingModeIterativeAsync.  The<br>
   * federate will be in created or error mode on return<br>
   * <br>
   * @param fed The federate used in the corresponding async call<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateEnterInitializingModeIterativeComplete(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateEnterInitializingModeIterativeComplete(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Check if the current Asynchronous operation has completed.<br>
   * <br>
   * @param fed The federate to operate on.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return HELICS_FALSE if not completed, HELICS_TRUE if completed.
   */
  public static int helicsFederateIsAsyncOperationCompleted(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateIsAsyncOperationCompleted(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Request that the federate enter the Execution mode.<br>
   * <br>
   * This call is blocking until granted entry by the core object. On return from this call the federate will be at time 0.<br>
   *          For an asynchronous alternative call see /ref helicsFederateEnterExecutingModeAsync.<br>
   * <br>
   * @param fed A federate to change modes.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateEnterExecutingMode(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateEnterExecutingMode(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Request that the federate enter the Execution mode.<br>
   * <br>
   * This call is non-blocking and will return immediately. Call /ref helicsFederateEnterExecutingModeComplete to finish the call<br>
   * sequence.<br>
   * <br>
   * @param fed The federate object to complete the call.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateEnterExecutingModeAsync(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateEnterExecutingModeAsync(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Complete the call to /ref helicsFederateEnterExecutingModeAsync.<br>
   * <br>
   * @param fed The federate object to complete the call.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateEnterExecutingModeComplete(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateEnterExecutingModeComplete(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Request an iterative time.<br>
   * <br>
   * This call allows for finer grain control of the iterative process than /ref helicsFederateRequestTime. It takes a time and<br>
   *          iteration request, and returns a time and iteration status.<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * @param iterate The requested iteration mode.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return An iteration structure with field containing the time and iteration status.
   */
  public static HelicsIterationResult helicsFederateEnterExecutingModeIterative(SWIGTYPE_p_void fed, HelicsIterationRequest iterate) {
    return HelicsIterationResult.swigToEnum(helicsJNI.helicsFederateEnterExecutingModeIterative(SWIGTYPE_p_void.getCPtr(fed), iterate.swigValue()));
  }

  /**
   * Request an iterative entry to the execution mode.<br>
   * <br>
   * This call allows for finer grain control of the iterative process than /ref helicsFederateRequestTime. It takes a time and<br>
   *          iteration request, and returns a time and iteration status<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * @param iterate The requested iteration mode.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateEnterExecutingModeIterativeAsync(SWIGTYPE_p_void fed, HelicsIterationRequest iterate) {
    helicsJNI.helicsFederateEnterExecutingModeIterativeAsync(SWIGTYPE_p_void.getCPtr(fed), iterate.swigValue());
  }

  /**
   * Complete the asynchronous iterative call into ExecutionMode.<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return An iteration object containing the iteration time and iteration_status.
   */
  public static HelicsIterationResult helicsFederateEnterExecutingModeIterativeComplete(SWIGTYPE_p_void fed) {
    return HelicsIterationResult.swigToEnum(helicsJNI.helicsFederateEnterExecutingModeIterativeComplete(SWIGTYPE_p_void.getCPtr(fed)));
  }

  /**
   * Get the current state of a federate.<br>
   * <br>
   * @param fed The federate to query.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * The err object will be removed in a future release as it is not necessary for use the function will not error, invalid federate return<br>
   * HELICS_STATE_UNKOWN<br>
   * <br>
   * @return State the resulting state if the federate is invalid will return HELICS_STATE_UNKNOWN
   */
  public static HelicsFederateState helicsFederateGetState(SWIGTYPE_p_void fed) {
    return HelicsFederateState.swigToEnum(helicsJNI.helicsFederateGetState(SWIGTYPE_p_void.getCPtr(fed)));
  }

  /**
   * Get the core object associated with a federate.<br>
   * <br>
   * @param fed A federate object.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return A core object, nullptr if invalid.
   */
  public static SWIGTYPE_p_void helicsFederateGetCore(SWIGTYPE_p_void fed) {
    long cPtr = helicsJNI.helicsFederateGetCore(SWIGTYPE_p_void.getCPtr(fed));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Request the next time for federate execution.<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * @param requestTime The next requested time.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return The time granted to the federate, will return HELICS_TIME_MAXTIME if the simulation has terminated or is invalid.
   */
  public static double helicsFederateRequestTime(SWIGTYPE_p_void fed, double requestTime) {
    return helicsJNI.helicsFederateRequestTime(SWIGTYPE_p_void.getCPtr(fed), requestTime);
  }

  /**
   * Request the next time for federate execution.<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * @param timeDelta The requested amount of time to advance.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return The time granted to the federate, will return HELICS_TIME_MAXTIME if the simulation has terminated or is invalid
   */
  public static double helicsFederateRequestTimeAdvance(SWIGTYPE_p_void fed, double timeDelta) {
    return helicsJNI.helicsFederateRequestTimeAdvance(SWIGTYPE_p_void.getCPtr(fed), timeDelta);
  }

  /**
   * Request the next time step for federate execution.<br>
   * <br>
   * Feds should have setup the period or minDelta for this to work well but it will request the next time step which is the current<br>
   * time plus the minimum time step.<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return The time granted to the federate, will return HELICS_TIME_MAXTIME if the simulation has terminated or is invalid
   */
  public static double helicsFederateRequestNextStep(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateRequestNextStep(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Request an iterative time.<br>
   * <br>
   * This call allows for finer grain control of the iterative process than /ref helicsFederateRequestTime. It takes a time and and<br>
   * iteration request, and returns a time and iteration status.<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * @param requestTime The next desired time.<br>
   * @param iterate The requested iteration mode.<br>
   * <br>
   * @param outIteration  The iteration specification of the result.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return The granted time, will return HELICS_TIME_MAXTIME if the simulation has terminated along with the appropriate iteration result.
   */
  public static double helicsFederateRequestTimeIterative(SWIGTYPE_p_void fed, double requestTime, HelicsIterationRequest iterate, int[] outIteration) {
    return helicsJNI.helicsFederateRequestTimeIterative(SWIGTYPE_p_void.getCPtr(fed), requestTime, iterate.swigValue(), outIteration);
  }

  /**
   * Request the next time for federate execution in an asynchronous call.<br>
   * <br>
   * Call /ref helicsFederateRequestTimeComplete to finish the call.<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * @param requestTime The next requested time.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateRequestTimeAsync(SWIGTYPE_p_void fed, double requestTime) {
    helicsJNI.helicsFederateRequestTimeAsync(SWIGTYPE_p_void.getCPtr(fed), requestTime);
  }

  /**
   * Complete an asynchronous requestTime call.<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return The time granted to the federate, will return HELICS_TIME_MAXTIME if the simulation has terminated.
   */
  public static double helicsFederateRequestTimeComplete(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateRequestTimeComplete(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Request an iterative time through an asynchronous call.<br>
   * <br>
   * This call allows for finer grain control of the iterative process than /ref helicsFederateRequestTime. It takes a time and<br>
   * iteration request, and returns a time and iteration status. Call /ref helicsFederateRequestTimeIterativeComplete to finish the process.<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * @param requestTime The next desired time.<br>
   * @param iterate The requested iteration mode.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateRequestTimeIterativeAsync(SWIGTYPE_p_void fed, double requestTime, HelicsIterationRequest iterate) {
    helicsJNI.helicsFederateRequestTimeIterativeAsync(SWIGTYPE_p_void.getCPtr(fed), requestTime, iterate.swigValue());
  }

  /**
   * Complete an iterative time request asynchronous call.<br>
   * <br>
   * @param fed The federate to make the request of.<br>
   * <br>
   * @param outIterate The iteration specification of the result.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return The granted time, will return HELICS_TIME_MAXTIME if the simulation has terminated.
   */
  public static double helicsFederateRequestTimeIterativeComplete(SWIGTYPE_p_void fed, int[] outIterate) {
    return helicsJNI.helicsFederateRequestTimeIterativeComplete(SWIGTYPE_p_void.getCPtr(fed), outIterate);
  }

  /**
   * Tell helics to process internal communications for a period of time.<br>
   * <br>
   * @param fed The federate to tell to process.<br>
   * <br>
   * @param period The length of time to process communications and then return control.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateProcessCommunications(SWIGTYPE_p_void fed, double period) {
    helicsJNI.helicsFederateProcessCommunications(SWIGTYPE_p_void.getCPtr(fed), period);
  }

  /**
   * Get the name of the federate.<br>
   * <br>
   * @param fed The federate object to query.<br>
   * <br>
   * @return A pointer to a string with the name.
   */
  public static String helicsFederateGetName(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateGetName(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Set a time based property for a federate.<br>
   * <br>
   * @param fed The federate object to set the property for.<br>
   * @param timeProperty A integer code for a time property.<br>
   * @param time The requested value of the property.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateSetTimeProperty(SWIGTYPE_p_void fed, int timeProperty, double time) {
    helicsJNI.helicsFederateSetTimeProperty(SWIGTYPE_p_void.getCPtr(fed), timeProperty, time);
  }

  /**
   * Set a flag for the federate.<br>
   * <br>
   * @param fed The federate to alter a flag for.<br>
   * @param flag The flag to change.<br>
   * @param flagValue The new value of the flag. 0 for false, !=0 for true.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateSetFlagOption(SWIGTYPE_p_void fed, int flag, int flagValue) {
    helicsJNI.helicsFederateSetFlagOption(SWIGTYPE_p_void.getCPtr(fed), flag, flagValue);
  }

  /**
   * Set the separator character in a federate.<br>
   * <br>
   * The separator character is the separation character for local publications/endpoints in creating their global name.<br>
   *          For example if the separator character is '/' then a local endpoint would have a globally reachable name of fedName/localName.<br>
   * <br>
   * @param fed The federate info object to alter.<br>
   * @param separator The character to use as a separator.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateSetSeparator(SWIGTYPE_p_void fed, char separator) {
    helicsJNI.helicsFederateSetSeparator(SWIGTYPE_p_void.getCPtr(fed), separator);
  }

  /**
   * Set an integer based property of a federate.<br>
   * <br>
   * @param fed The federate to change the property for.<br>
   * @param intProperty The property to set.<br>
   * @param propertyVal The value of the property.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateSetIntegerProperty(SWIGTYPE_p_void fed, int intProperty, int propertyVal) {
    helicsJNI.helicsFederateSetIntegerProperty(SWIGTYPE_p_void.getCPtr(fed), intProperty, propertyVal);
  }

  /**
   * Get the current value of a time based property in a federate.<br>
   * <br>
   * @param fed The federate query.<br>
   * @param timeProperty The property to query.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static double helicsFederateGetTimeProperty(SWIGTYPE_p_void fed, int timeProperty) {
    return helicsJNI.helicsFederateGetTimeProperty(SWIGTYPE_p_void.getCPtr(fed), timeProperty);
  }

  /**
   * Get a flag value for a federate.<br>
   * <br>
   * @param fed The federate to get the flag for.<br>
   * @param flag The flag to query.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * @return The value of the flag.
   */
  public static int helicsFederateGetFlagOption(SWIGTYPE_p_void fed, int flag) {
    return helicsJNI.helicsFederateGetFlagOption(SWIGTYPE_p_void.getCPtr(fed), flag);
  }

  /**
   * Get the current value of an integer property (such as a logging level).<br>
   * <br>
   * @param fed The federate to get the flag for.<br>
   * @param intProperty A code for the property to set /ref helics_handle_options.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * @return The value of the property.
   */
  public static int helicsFederateGetIntegerProperty(SWIGTYPE_p_void fed, int intProperty) {
    return helicsJNI.helicsFederateGetIntegerProperty(SWIGTYPE_p_void.getCPtr(fed), intProperty);
  }

  /**
   * Get the current time of the federate.<br>
   * <br>
   * @param fed The federate object to query.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * @return The current time of the federate.
   */
  public static double helicsFederateGetCurrentTime(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateGetCurrentTime(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Create an alias for an interface.<br>
   * <br>
   * @param fed The federate to use to set the alias.<br>
   * @param interfaceName The current name of an interface.<br>
   * @param alias The additional name to use for the given interface.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateAddAlias(SWIGTYPE_p_void fed, String interfaceName, String alias) {
    helicsJNI.helicsFederateAddAlias(SWIGTYPE_p_void.getCPtr(fed), interfaceName, alias);
  }

  /**
   * Set a federation global value through a federate.<br>
   * <br>
   * This overwrites any previous value for this name.<br>
   * @param fed The federate to set the global through.<br>
   * @param valueName The name of the global to set.<br>
   * @param value The value of the global.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateSetGlobal(SWIGTYPE_p_void fed, String valueName, String value) {
    helicsJNI.helicsFederateSetGlobal(SWIGTYPE_p_void.getCPtr(fed), valueName, value);
  }

  /**
   * Set a federate tag value.<br>
   * <br>
   * This overwrites any previous value for this tag.<br>
   * @param fed The federate to set the tag for.<br>
   * @param tagName The name of the tag to set.<br>
   * @param value The value of the tag.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateSetTag(SWIGTYPE_p_void fed, String tagName, String value) {
    helicsJNI.helicsFederateSetTag(SWIGTYPE_p_void.getCPtr(fed), tagName, value);
  }

  /**
   * Get a federate tag value.<br>
   * <br>
   * @param fed The federate to get the tag for.<br>
   * @param tagName The name of the tag to query.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static String helicsFederateGetTag(SWIGTYPE_p_void fed, String tagName) {
    return helicsJNI.helicsFederateGetTag(SWIGTYPE_p_void.getCPtr(fed), tagName);
  }

  /**
   * Add a time dependency for a federate. The federate will depend on the given named federate for time synchronization.<br>
   * <br>
   * @param fed The federate to add the dependency for.<br>
   * @param fedName The name of the federate to depend on.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateAddDependency(SWIGTYPE_p_void fed, String fedName) {
    helicsJNI.helicsFederateAddDependency(SWIGTYPE_p_void.getCPtr(fed), fedName);
  }

  /**
   * Set the logging file for a federate (actually on the core associated with a federate).<br>
   * <br>
   * @param fed The federate to set the log file for.<br>
   * @param logFile The name of the log file.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateSetLogFile(SWIGTYPE_p_void fed, String logFile) {
    helicsJNI.helicsFederateSetLogFile(SWIGTYPE_p_void.getCPtr(fed), logFile);
  }

  /**
   * Log an error message through a federate.<br>
   * <br>
   * @param fed The federate to log the error message through.<br>
   * @param logmessage The message to put in the log.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateLogErrorMessage(SWIGTYPE_p_void fed, String logmessage) {
    helicsJNI.helicsFederateLogErrorMessage(SWIGTYPE_p_void.getCPtr(fed), logmessage);
  }

  /**
   * Log a warning message through a federate.<br>
   * <br>
   * @param fed The federate to log the warning message through.<br>
   * @param logmessage The message to put in the log.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateLogWarningMessage(SWIGTYPE_p_void fed, String logmessage) {
    helicsJNI.helicsFederateLogWarningMessage(SWIGTYPE_p_void.getCPtr(fed), logmessage);
  }

  /**
   * Log an info message through a federate.<br>
   * <br>
   * @param fed The federate to log the info message through.<br>
   * @param logmessage The message to put in the log.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateLogInfoMessage(SWIGTYPE_p_void fed, String logmessage) {
    helicsJNI.helicsFederateLogInfoMessage(SWIGTYPE_p_void.getCPtr(fed), logmessage);
  }

  /**
   * Log a debug message through a federate.<br>
   * <br>
   * @param fed The federate to log the debug message through.<br>
   * @param logmessage The message to put in the log.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateLogDebugMessage(SWIGTYPE_p_void fed, String logmessage) {
    helicsJNI.helicsFederateLogDebugMessage(SWIGTYPE_p_void.getCPtr(fed), logmessage);
  }

  /**
   * Log a message through a federate.<br>
   * <br>
   * @param fed The federate to log the message through.<br>
   * @param loglevel The level of the message to log see /ref helics_log_levels.<br>
   * @param logmessage The message to put in the log.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateLogLevelMessage(SWIGTYPE_p_void fed, int loglevel, String logmessage) {
    helicsJNI.helicsFederateLogLevelMessage(SWIGTYPE_p_void.getCPtr(fed), loglevel, logmessage);
  }

  /**
   * Send a command to another helics object through a federate.<br>
   * <br>
   * @param fed The federate to send the command through.<br>
   * @param target The name of the object to send the command to.<br>
   * @param command The command to send.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsFederateSendCommand(SWIGTYPE_p_void fed, String target, String command) {
    helicsJNI.helicsFederateSendCommand(SWIGTYPE_p_void.getCPtr(fed), target, command);
  }

  /**
   * Get a command sent to the federate.<br>
   * <br>
   * @param fed The federate to get the command for.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return A string with the command for the federate, if the string is empty no command is available.
   */
  public static String helicsFederateGetCommand(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateGetCommand(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Get the source of the most recently retrieved command sent to the federate.<br>
   * <br>
   * @param fed The federate to get the command for.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return A string with the command for the federate, if the string is empty no command is available.
   */
  public static String helicsFederateGetCommandSource(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateGetCommandSource(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Get a command sent to the federate. Blocks until a command is received.<br>
   * <br>
   * @param fed The federate to get the command for.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return A string with the command for the federate, if the string is empty no command is available.
   */
  public static String helicsFederateWaitCommand(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateWaitCommand(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Set a global value in a core.<br>
   * <br>
   * This overwrites any previous value for this name.<br>
   * <br>
   * @param core The core to set the global through.<br>
   * @param valueName The name of the global to set.<br>
   * @param value The value of the global.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsCoreSetGlobal(SWIGTYPE_p_void core, String valueName, String value) {
    helicsJNI.helicsCoreSetGlobal(SWIGTYPE_p_void.getCPtr(core), valueName, value);
  }

  /**
   * Set a federation global value.<br>
   * <br>
   * This overwrites any previous value for this name.<br>
   * <br>
   * @param broker The broker to set the global through.<br>
   * @param valueName The name of the global to set.<br>
   * @param value The value of the global.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsBrokerSetGlobal(SWIGTYPE_p_void broker, String valueName, String value) {
    helicsJNI.helicsBrokerSetGlobal(SWIGTYPE_p_void.getCPtr(broker), valueName, value);
  }

  /**
   * Create an alias for an interface.<br>
   * <br>
   * @param core The core to use to set the alias.<br>
   * @param interfaceName The current name of an interface.<br>
   * @param alias The additional name to use for the given interface.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsCoreAddAlias(SWIGTYPE_p_void core, String interfaceName, String alias) {
    helicsJNI.helicsCoreAddAlias(SWIGTYPE_p_void.getCPtr(core), interfaceName, alias);
  }

  /**
   * Create an alias for an interface.<br>
   * <br>
   * @param broker The broker to use to set the alias.<br>
   * @param interfaceName The current name of an interface.<br>
   * @param alias The additional name to use for the given interface.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsBrokerAddAlias(SWIGTYPE_p_void broker, String interfaceName, String alias) {
    helicsJNI.helicsBrokerAddAlias(SWIGTYPE_p_void.getCPtr(broker), interfaceName, alias);
  }

  /**
   * Send a command to another helics object though a core using asynchronous(fast) operations.<br>
   * <br>
   * @param core The core to send the command through.<br>
   * @param target The name of the object to send the command to.<br>
   * @param command The command to send.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsCoreSendCommand(SWIGTYPE_p_void core, String target, String command) {
    helicsJNI.helicsCoreSendCommand(SWIGTYPE_p_void.getCPtr(core), target, command);
  }

  /**
   * Send a command to another helics object though a core using ordered operations.<br>
   * <br>
   * @param core The core to send the command through.<br>
   * @param target The name of the object to send the command to.<br>
   * @param command The command to send.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsCoreSendOrderedCommand(SWIGTYPE_p_void core, String target, String command) {
    helicsJNI.helicsCoreSendOrderedCommand(SWIGTYPE_p_void.getCPtr(core), target, command);
  }

  /**
   * Send a command to another helics object through a broker using asynchronous(fast) messages.<br>
   * <br>
   * @param broker The broker to send the command through.<br>
   * @param target The name of the object to send the command to.<br>
   * @param command The command to send.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsBrokerSendCommand(SWIGTYPE_p_void broker, String target, String command) {
    helicsJNI.helicsBrokerSendCommand(SWIGTYPE_p_void.getCPtr(broker), target, command);
  }

  /**
   * Send a command to another helics object through a broker using ordered sequencing.<br>
   * <br>
   * @param broker The broker to send the command through.<br>
   * @param target The name of the object to send the command to.<br>
   * @param command The command to send.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsBrokerSendOrderedCommand(SWIGTYPE_p_void broker, String target, String command) {
    helicsJNI.helicsBrokerSendOrderedCommand(SWIGTYPE_p_void.getCPtr(broker), target, command);
  }

  /**
   * Set the log file on a core.<br>
   * <br>
   * @param core The core to set the log file for.<br>
   * @param logFileName The name of the file to log to.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsCoreSetLogFile(SWIGTYPE_p_void core, String logFileName) {
    helicsJNI.helicsCoreSetLogFile(SWIGTYPE_p_void.getCPtr(core), logFileName);
  }

  /**
   * Set the log file on a broker.<br>
   * <br>
   * @param broker The broker to set the log file for.<br>
   * @param logFileName The name of the file to log to.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsBrokerSetLogFile(SWIGTYPE_p_void broker, String logFileName) {
    helicsJNI.helicsBrokerSetLogFile(SWIGTYPE_p_void.getCPtr(broker), logFileName);
  }

  /**
   * Set a broker time barrier.<br>
   * <br>
   * @param broker The broker to set the time barrier for.<br>
   * @param barrierTime The time to set the barrier at.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsBrokerSetTimeBarrier(SWIGTYPE_p_void broker, double barrierTime) {
    helicsJNI.helicsBrokerSetTimeBarrier(SWIGTYPE_p_void.getCPtr(broker), barrierTime);
  }

  /**
   * Clear any time barrier on a broker.<br>
   * <br>
   * @param broker The broker to clear the barriers on.
   */
  public static void helicsBrokerClearTimeBarrier(SWIGTYPE_p_void broker) {
    helicsJNI.helicsBrokerClearTimeBarrier(SWIGTYPE_p_void.getCPtr(broker));
  }

  /**
   * Generate a global error through a broker. This will terminate the federation.<br>
   * <br>
   * @param broker The broker to generate the global error on.<br>
   * @param errorCode The error code to associate with the global error.<br>
   * @param errorString An error message to associate with the global error.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsBrokerGlobalError(SWIGTYPE_p_void broker, int errorCode, String errorString) {
    helicsJNI.helicsBrokerGlobalError(SWIGTYPE_p_void.getCPtr(broker), errorCode, errorString);
  }

  /**
   * Generate a global error through a broker. This will terminate the federation.<br>
   * <br>
   * @param core The core to generate the global error.<br>
   * @param errorCode The error code to associate with the global error.<br>
   * @param errorString An error message to associate with the global error.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsCoreGlobalError(SWIGTYPE_p_void core, int errorCode, String errorString) {
    helicsJNI.helicsCoreGlobalError(SWIGTYPE_p_void.getCPtr(core), errorCode, errorString);
  }

  /**
   * Create a query object.<br>
   * <br>
   * A query object consists of a target and query string.<br>
   * <br>
   * @param target The name of the target to query.<br>
   * @param query The query to make of the target.
   */
  public static SWIGTYPE_p_void helicsCreateQuery(String target, String query) {
    long cPtr = helicsJNI.helicsCreateQuery(target, query);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Execute a query.<br>
   * <br>
   * The call will block until the query finishes which may require communication or other delays.<br>
   * <br>
   * @param query The query object to use in the query.<br>
   * @param fed A federate to send the query through.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return A pointer to a string.  The string will remain valid until the query is freed or executed again.<br>
   * The return will be nullptr if fed or query is an invalid object, the return string will be "#invalid" if the query itself was<br>
   * invalid.
   */
  public static String helicsQueryExecute(SWIGTYPE_p_void query, SWIGTYPE_p_void fed) {
    return helicsJNI.helicsQueryExecute(SWIGTYPE_p_void.getCPtr(query), SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Execute a query directly on a core.<br>
   * <br>
   * The call will block until the query finishes which may require communication or other delays.<br>
   * <br>
   * @param query The query object to use in the query.<br>
   * @param core The core to send the query to.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return A pointer to a string.  The string will remain valid until the query is freed or executed again.<br>
   * The return will be nullptr if core or query is an invalid object, the return string will be "#invalid" if the query itself was<br>
   * invalid.
   */
  public static String helicsQueryCoreExecute(SWIGTYPE_p_void query, SWIGTYPE_p_void core) {
    return helicsJNI.helicsQueryCoreExecute(SWIGTYPE_p_void.getCPtr(query), SWIGTYPE_p_void.getCPtr(core));
  }

  /**
   * Execute a query directly on a broker.<br>
   * <br>
   * The call will block until the query finishes which may require communication or other delays.<br>
   * <br>
   * @param query The query object to use in the query.<br>
   * @param broker The broker to send the query to.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return A pointer to a string.  The string will remain valid until the query is freed or executed again.<br>
   * The return will be nullptr if broker or query is an invalid object, the return string will be "#invalid" if the query itself was<br>
   * invalid
   */
  public static String helicsQueryBrokerExecute(SWIGTYPE_p_void query, SWIGTYPE_p_void broker) {
    return helicsJNI.helicsQueryBrokerExecute(SWIGTYPE_p_void.getCPtr(query), SWIGTYPE_p_void.getCPtr(broker));
  }

  /**
   * Execute a query in a non-blocking call.<br>
   * <br>
   * @param query The query object to use in the query.<br>
   * @param fed A federate to send the query through.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsQueryExecuteAsync(SWIGTYPE_p_void query, SWIGTYPE_p_void fed) {
    helicsJNI.helicsQueryExecuteAsync(SWIGTYPE_p_void.getCPtr(query), SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Complete the return from a query called with /ref helicsExecuteQueryAsync.<br>
   * <br>
   * The function will block until the query completes /ref isQueryComplete can be called to determine if a query has completed or<br>
   * not.<br>
   * <br>
   * @param query The query object to complete execution of.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return A pointer to a string. The string will remain valid until the query is freed or executed again.<br>
   * The return will be nullptr if query is an invalid object
   */
  public static String helicsQueryExecuteComplete(SWIGTYPE_p_void query) {
    return helicsJNI.helicsQueryExecuteComplete(SWIGTYPE_p_void.getCPtr(query));
  }

  /**
   * Check if an asynchronously executed query has completed.<br>
   * <br>
   * This function should usually be called after a QueryExecuteAsync function has been called.<br>
   * <br>
   * @param query The query object to check if completed.<br>
   * <br>
   * @return Will return HELICS_TRUE if an asynchronous query has completed or a regular query call was made with a result,<br>
   * and false if an asynchronous query has not completed or is invalid
   */
  public static int helicsQueryIsCompleted(SWIGTYPE_p_void query) {
    return helicsJNI.helicsQueryIsCompleted(SWIGTYPE_p_void.getCPtr(query));
  }

  /**
   * Update the target of a query.<br>
   * <br>
   * @param query The query object to change the target of.<br>
   * @param target the name of the target to query<br>
   * <br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsQuerySetTarget(SWIGTYPE_p_void query, String target) {
    helicsJNI.helicsQuerySetTarget(SWIGTYPE_p_void.getCPtr(query), target);
  }

  /**
   * Update the queryString of a query.<br>
   * <br>
   * @param query The query object to change the target of.<br>
   * @param queryString the new queryString<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsQuerySetQueryString(SWIGTYPE_p_void query, String queryString) {
    helicsJNI.helicsQuerySetQueryString(SWIGTYPE_p_void.getCPtr(query), queryString);
  }

  /**
   * Update the ordering mode of the query, fast runs on priority channels, ordered goes on normal channels but goes in sequence<br>
   * <br>
   * @param query The query object to change the order for.<br>
   * @param mode 0 for fast, 1 for ordered<br>
   * <br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsQuerySetOrdering(SWIGTYPE_p_void query, SWIGTYPE_p_int32_t mode) {
    helicsJNI.helicsQuerySetOrdering(SWIGTYPE_p_void.getCPtr(query), SWIGTYPE_p_int32_t.getCPtr(mode));
  }

  /**
   * Free the memory associated with a query object.
   */
  public static void helicsQueryFree(SWIGTYPE_p_void query) {
    helicsJNI.helicsQueryFree(SWIGTYPE_p_void.getCPtr(query));
  }

  /**
   * Function to do some housekeeping work.<br>
   * <br>
   * This runs some cleanup routines and tries to close out any residual thread that haven't been shutdown yet.
   */
  public static void helicsCleanupLibrary() {
    helicsJNI.helicsCleanupLibrary();
  }

  /**
   *  HELICS_TRUE if the app library is enabled
   */
  public static int helicsAppEnabled() {
    return helicsJNI.helicsAppEnabled();
  }

  /**
   * Create a HelicsApp object.<br>
   * <br>
   * Create a HelicsApp object.<br>
   * <br>
   * @param appName A string with the name of the app, can be NULL or an empty string to pull the default name from fedInfo or the config file.<br>
   * @param appType The type of app to create.<br>
   * @param configFile Configuration file or string to pass into the app, can be NULL or empty.<br>
   * @param fedInfo The federate information to pass into the app, can be NULL.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * <br>
   * @return An opaque value app object, or nullptr if the object creation failed.
   */
  public static SWIGTYPE_p_void helicsCreateApp(String appName, String appType, String configFile, SWIGTYPE_p_void fedInfo) {
    long cPtr = helicsJNI.helicsCreateApp(appName, appType, configFile, SWIGTYPE_p_void.getCPtr(fedInfo));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   *  Run the HelicsApp.<br>
   * Execute the HelicsApp to completion<br>
   * @param app The app to execute.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * <br>
   * @return An opaque value federate object that can be used in any of the federate methods, not recommended to use this object to advance<br>
   * time, the app will not likely function normally; other query, information calls, or modification calls on the federate are fine.
   */
  public static SWIGTYPE_p_void helicsAppGetFederate(SWIGTYPE_p_void app) {
    long cPtr = helicsJNI.helicsAppGetFederate(SWIGTYPE_p_void.getCPtr(app));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Load a file to an App.<br>
   * <br>
   * Loads a configuration file for an app.<br>
   * <br>
   * @param app The app to load a file.<br>
   * @param configFile Configuration file or string to pass into the app, can be NULL or empty.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsAppLoadFile(SWIGTYPE_p_void app, String configFile) {
    helicsJNI.helicsAppLoadFile(SWIGTYPE_p_void.getCPtr(app), configFile);
  }

  /**
   *  Initialize the HelicsApp federate.<br>
   * Generate all the interfaces and load data for the application.<br>
   * @param app The app to initialize.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsAppInitialize(SWIGTYPE_p_void app) {
    helicsJNI.helicsAppInitialize(SWIGTYPE_p_void.getCPtr(app));
  }

  /**
   *  Run the HelicsApp.<br>
   * Execute the app to completion.<br>
   * @param app The app to execute.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsAppRun(SWIGTYPE_p_void app) {
    helicsJNI.helicsAppRun(SWIGTYPE_p_void.getCPtr(app));
  }

  /**
   *  Run a HelicsApp to a specified stop time.<br>
   * It is possible to call this method repeatedly with different times.<br>
   * @param app The app to run.<br>
   * @param stopTime The desired stop time.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsAppRunTo(SWIGTYPE_p_void app, double stopTime) {
    helicsJNI.helicsAppRunTo(SWIGTYPE_p_void.getCPtr(app), stopTime);
  }

  /**
   *  Finalize the HelicsApp.<br>
   * @param app The app to finalize.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsAppFinalize(SWIGTYPE_p_void app) {
    helicsJNI.helicsAppFinalize(SWIGTYPE_p_void.getCPtr(app));
  }

  /**
   *  Free the HelicsApp object.<br>
   * @param app The app to free.
   */
  public static void helicsAppFree(SWIGTYPE_p_void app) {
    helicsJNI.helicsAppFree(SWIGTYPE_p_void.getCPtr(app));
  }

  /**
   *  Disconnect and free a HelicsApp.<br>
   * @param app The app to destroy.
   */
  public static void helicsAppDestroy(SWIGTYPE_p_void app) {
    helicsJNI.helicsAppDestroy(SWIGTYPE_p_void.getCPtr(app));
  }

  /**
   *  Check if the HelicsApp is active and ready to run.<br>
   * @param app The app to check.<br>
   * @return True if the app is active, otherwise false.
   */
  public static int helicsAppIsActive(SWIGTYPE_p_void app) {
    return helicsJNI.helicsAppIsActive(SWIGTYPE_p_void.getCPtr(app));
  }

  /**
   * input/publication registration<br>
   * <br>
   * Create an input and add a publication target.<br>
   * <br>
   * this method is a wrapper method to create and unnamed input and add a publication target to it<br>
   * <br>
   * @param fed The federate object in which to create an input, must have been created with /ref helicsCreateValueFederate or<br>
   * /ref helicsCreateCombinationFederate.<br>
   * @param key The identifier matching a publication to add as an input target.<br>
   * @param units A string listing the units of the input (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return An object containing the input.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterSubscription(SWIGTYPE_p_void fed, String key, String units) {
    long cPtr = helicsJNI.helicsFederateRegisterSubscription(SWIGTYPE_p_void.getCPtr(fed), key, units);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Register a publication with a known type.<br>
   * <br>
   * The publication becomes part of the federate and is destroyed when the federate is freed so there are no separate free<br>
   * functions for inputs and publications.<br>
   * <br>
   * @param fed The federate object in which to create a publication.<br>
   * @param key The identifier for the publication the global publication key will be prepended with the federate name (may be NULL).<br>
   * @param type A code identifying the type of the input see /ref HelicsDataTypes for available options.<br>
   * @param units A string listing the units of the publication (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return An object containing the publication.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterPublication(SWIGTYPE_p_void fed, String key, HelicsDataTypes type, String units) {
    long cPtr = helicsJNI.helicsFederateRegisterPublication(SWIGTYPE_p_void.getCPtr(fed), key, type.swigValue(), units);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Register a publication with a defined type.<br>
   * <br>
   * The publication becomes part of the federate and is destroyed when the federate is freed so there are no separate free<br>
   * functions for inputs and publications.<br>
   * <br>
   * @param fed The federate object in which to create a publication.<br>
   * @param key The identifier for the publication (may be NULL).<br>
   * @param type A string labeling the type of the publication (may be NULL).<br>
   * @param units A string listing the units of the publication (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return An object containing the publication.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterTypePublication(SWIGTYPE_p_void fed, String key, String type, String units) {
    long cPtr = helicsJNI.helicsFederateRegisterTypePublication(SWIGTYPE_p_void.getCPtr(fed), key, type, units);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Register a global named publication with an arbitrary type.<br>
   * <br>
   * The publication becomes part of the federate and is destroyed when the federate is freed so there are no separate free<br>
   * functions for inputs and publications.<br>
   * <br>
   * @param fed The federate object in which to create a publication.<br>
   * @param key The identifier for the publication (may be NULL).<br>
   * @param type A code identifying the type of the input see /ref HelicsDataTypes for available options.<br>
   * @param units A string listing the units of the publication (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return An object containing the publication.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterGlobalPublication(SWIGTYPE_p_void fed, String key, HelicsDataTypes type, String units) {
    long cPtr = helicsJNI.helicsFederateRegisterGlobalPublication(SWIGTYPE_p_void.getCPtr(fed), key, type.swigValue(), units);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Register a global publication with a defined type.<br>
   * <br>
   * The publication becomes part of the federate and is destroyed when the federate is freed so there are no separate free<br>
   * functions for inputs and publications.<br>
   * <br>
   * @param fed The federate object in which to create a publication.<br>
   * @param key The identifier for the publication (may be NULL).<br>
   * @param type A string describing the expected type of the publication (may be NULL).<br>
   * @param units A string listing the units of the publication (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return An object containing the publication.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterGlobalTypePublication(SWIGTYPE_p_void fed, String key, String type, String units) {
    long cPtr = helicsJNI.helicsFederateRegisterGlobalTypePublication(SWIGTYPE_p_void.getCPtr(fed), key, type, units);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Register a named input.<br>
   * <br>
   * The input becomes part of the federate and is destroyed when the federate is freed so there are no separate free<br>
   * functions for inputs, and publications.<br>
   * <br>
   * @param fed The federate object in which to create an input.<br>
   * @param key The identifier for the publication the global input key will be prepended with the federate name (may be NULL).<br>
   * @param type A code identifying the type of the input see /ref HelicsDataTypes for available options.<br>
   * @param units A string listing the units of the input (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return An object containing the input.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterInput(SWIGTYPE_p_void fed, String key, HelicsDataTypes type, String units) {
    long cPtr = helicsJNI.helicsFederateRegisterInput(SWIGTYPE_p_void.getCPtr(fed), key, type.swigValue(), units);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Register an input with a defined type.<br>
   * <br>
   * The input becomes part of the federate and is destroyed when the federate is freed so there are no separate free<br>
   * functions for inputs, and publications.<br>
   * <br>
   * @param fed The federate object in which to create an input.<br>
   * @param key The identifier for the input (may be NULL).<br>
   * @param type A string describing the expected type of the input (may be NULL).<br>
   * @param units A string listing the units of the input maybe NULL.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return An object containing the publication.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterTypeInput(SWIGTYPE_p_void fed, String key, String type, String units) {
    long cPtr = helicsJNI.helicsFederateRegisterTypeInput(SWIGTYPE_p_void.getCPtr(fed), key, type, units);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Register a global named input.<br>
   * <br>
   * The publication becomes part of the federate and is destroyed when the federate is freed so there are no separate free<br>
   * functions for inputs and publications.<br>
   * <br>
   * @param fed The federate object in which to create a publication.<br>
   * @param key The identifier for the input (may be NULL).<br>
   * @param type A code identifying the type of the input see /ref HelicsDataTypes for available options.<br>
   * @param units A string listing the units of the input (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return An object containing the input.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterGlobalInput(SWIGTYPE_p_void fed, String key, HelicsDataTypes type, String units) {
    long cPtr = helicsJNI.helicsFederateRegisterGlobalInput(SWIGTYPE_p_void.getCPtr(fed), key, type.swigValue(), units);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Register an input with an arbitrary type.<br>
   * <br>
   * The input becomes part of the federate and is destroyed when the federate is freed so there are no separate free<br>
   * functions for interfaces.<br>
   * <br>
   * @param fed The federate object in which to create an input.<br>
   * @param key The identifier for the input (may be NULL).<br>
   * @param type A string defining the type of the input (may be NULL).<br>
   * @param units A string listing the units of the input (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * @return An object containing the input.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterGlobalTypeInput(SWIGTYPE_p_void fed, String key, String type, String units) {
    long cPtr = helicsJNI.helicsFederateRegisterGlobalTypeInput(SWIGTYPE_p_void.getCPtr(fed), key, type, units);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get a publication object from a key.<br>
   * <br>
   * @param fed The value federate object to use to get the publication.<br>
   * @param key The name of the publication.<br>
   * <br>
   * @param err The error object to complete if there is an error.<br>
   * <br>
   * <br>
   * @return A HelicsPublication object, the object will not be valid and err will contain an error code if no publication with the<br>
   * specified key exists.
   */
  public static SWIGTYPE_p_void helicsFederateGetPublication(SWIGTYPE_p_void fed, String key) {
    long cPtr = helicsJNI.helicsFederateGetPublication(SWIGTYPE_p_void.getCPtr(fed), key);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get a publication by its index, typically already created via registerInterfaces file or something of that nature.<br>
   * <br>
   * @param fed The federate object in which to create a publication.<br>
   * @param index The index of the publication to get.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsPublication.
   */
  public static SWIGTYPE_p_void helicsFederateGetPublicationByIndex(SWIGTYPE_p_void fed, int index) {
    long cPtr = helicsJNI.helicsFederateGetPublicationByIndex(SWIGTYPE_p_void.getCPtr(fed), index);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get an input object from a key.<br>
   * <br>
   * @param fed The value federate object to use to get the publication.<br>
   * @param key The name of the input.<br>
   * <br>
   * @param err The error object to complete if there is an error.<br>
   * <br>
   * <br>
   * @return A HelicsInput object, the object will not be valid and err will contain an error code if no input with the specified<br>
   * key exists.
   */
  public static SWIGTYPE_p_void helicsFederateGetInput(SWIGTYPE_p_void fed, String key) {
    long cPtr = helicsJNI.helicsFederateGetInput(SWIGTYPE_p_void.getCPtr(fed), key);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get an input by its index, typically already created via registerInterfaces file or something of that nature.<br>
   * <br>
   * @param fed The federate object in which to create a publication.<br>
   * @param index The index of the publication to get.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsInput, which will be NULL if an invalid index.
   */
  public static SWIGTYPE_p_void helicsFederateGetInputByIndex(SWIGTYPE_p_void fed, int index) {
    long cPtr = helicsJNI.helicsFederateGetInputByIndex(SWIGTYPE_p_void.getCPtr(fed), index);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get an input object from a subscription target.<br>
   * DEPRECATED: use helicsFederateGetInputByTarget instead<br>
   * <br>
   * @param fed The value federate object to use to get the publication.<br>
   * @param key The name of the publication that a subscription is targeting.<br>
   * <br>
   * @param err The error object to complete if there is an error.<br>
   * <br>
   * <br>
   * @return A HelicsInput object, the object will not be valid and err will contain an error code if no input with the specified<br>
   * key exists.
   */
  public static SWIGTYPE_p_void helicsFederateGetSubscription(SWIGTYPE_p_void fed, String key) {
    long cPtr = helicsJNI.helicsFederateGetSubscription(SWIGTYPE_p_void.getCPtr(fed), key);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get an input object from a target.<br>
   * <br>
   * @param fed The value federate object to use to get the input.<br>
   * @param target The name of the publication that an input is targeting.<br>
   * <br>
   * @param err The error object to complete if there is an error.<br>
   * <br>
   * <br>
   * @return A HelicsInput object, the object will not be valid and err will contain an error code if no input with the specified<br>
   * key exists.
   */
  public static SWIGTYPE_p_void helicsFederateGetInputByTarget(SWIGTYPE_p_void fed, String target) {
    long cPtr = helicsJNI.helicsFederateGetInputByTarget(SWIGTYPE_p_void.getCPtr(fed), target);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Clear all the update flags from a federates inputs.<br>
   * <br>
   * @param fed The value federate object for which to clear update flags.
   */
  public static void helicsFederateClearUpdates(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateClearUpdates(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Register the publications via JSON publication string.<br>
   * <br>
   * @param fed The value federate object to use to register the publications.<br>
   * @param json The JSON publication string.<br>
   * <br>
   * @param err The error object to complete if there is an error.<br>
   * <br>
   * <br>
   * This would be the same JSON that would be used to publish data.
   */
  public static void helicsFederateRegisterFromPublicationJSON(SWIGTYPE_p_void fed, String json) {
    helicsJNI.helicsFederateRegisterFromPublicationJSON(SWIGTYPE_p_void.getCPtr(fed), json);
  }

  /**
   * Publish data contained in a JSON file or string.<br>
   * <br>
   * @param fed The value federate object through which to publish the data.<br>
   * @param json The publication file name or literal JSON data string.<br>
   * <br>
   * @param err The error object to complete if there is an error.
   */
  public static void helicsFederatePublishJSON(SWIGTYPE_p_void fed, String json) {
    helicsJNI.helicsFederatePublishJSON(SWIGTYPE_p_void.getCPtr(fed), json);
  }

  /**
   * Check if a publication is valid.<br>
   * <br>
   * @param pub The publication to check.<br>
   * <br>
   * @return HELICS_TRUE if the publication is a valid publication.
   */
  public static int helicsPublicationIsValid(SWIGTYPE_p_void pub) {
    return helicsJNI.helicsPublicationIsValid(SWIGTYPE_p_void.getCPtr(pub));
  }

  /**
   * Publish raw data from a char * and length.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param data A pointer to the raw data.<br>
   * @param inputDataLength The size in bytes of the data to publish.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishBytes(SWIGTYPE_p_void pub, SWIGTYPE_p_void data, int inputDataLength) {
    helicsJNI.helicsPublicationPublishBytes(SWIGTYPE_p_void.getCPtr(pub), SWIGTYPE_p_void.getCPtr(data), inputDataLength);
  }

  /**
   * Publish a string.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param val The null terminated string to publish.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishString(SWIGTYPE_p_void pub, String val) {
    helicsJNI.helicsPublicationPublishString(SWIGTYPE_p_void.getCPtr(pub), val);
  }

  /**
   * Publish an integer value.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param val The numerical value to publish.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishInteger(SWIGTYPE_p_void pub, long val) {
    helicsJNI.helicsPublicationPublishInteger(SWIGTYPE_p_void.getCPtr(pub), val);
  }

  /**
   * Publish a Boolean Value.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param val The boolean value to publish.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishBoolean(SWIGTYPE_p_void pub, int val) {
    helicsJNI.helicsPublicationPublishBoolean(SWIGTYPE_p_void.getCPtr(pub), val);
  }

  /**
   * Publish a double floating point value.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param val The numerical value to publish.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishDouble(SWIGTYPE_p_void pub, double val) {
    helicsJNI.helicsPublicationPublishDouble(SWIGTYPE_p_void.getCPtr(pub), val);
  }

  /**
   * Publish a time value.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param val The numerical value to publish.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishTime(SWIGTYPE_p_void pub, double val) {
    helicsJNI.helicsPublicationPublishTime(SWIGTYPE_p_void.getCPtr(pub), val);
  }

  /**
   * Publish a single character.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param val The numerical value to publish.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishChar(SWIGTYPE_p_void pub, char val) {
    helicsJNI.helicsPublicationPublishChar(SWIGTYPE_p_void.getCPtr(pub), val);
  }

  /**
   * Publish a complex value (or pair of values).<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param real The real part of a complex number to publish.<br>
   * @param imag The imaginary part of a complex number to publish.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishComplex(SWIGTYPE_p_void pub, double real, double imag) {
    helicsJNI.helicsPublicationPublishComplex(SWIGTYPE_p_void.getCPtr(pub), real, imag);
  }

  /**
   * Publish a vector of doubles.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param vectorInput A pointer to an array of double data.<br>
   * <br>
   * @param vectorLength The number of points to publish.<br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishVector(SWIGTYPE_p_void pub, double[] vectorInput, int vectorLength) {
    helicsJNI.helicsPublicationPublishVector(SWIGTYPE_p_void.getCPtr(pub), vectorInput, vectorLength);
  }

  /**
   * Publish a vector of complex doubles.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param vectorInput A pointer to an array of complex double data (alternating real and imaginary values).<br>
   * <br>
   * @param vectorLength The number of values to publish; vectorInput must contain 2xvectorLength values.<br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishComplexVector(SWIGTYPE_p_void pub, double[] vectorInput, int vectorLength) {
    helicsJNI.helicsPublicationPublishComplexVector(SWIGTYPE_p_void.getCPtr(pub), vectorInput, vectorLength);
  }

  /**
   * Publish a named point.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param field A null terminated string for the field name of the namedPoint to publish.<br>
   * @param val A double for the value to publish.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishNamedPoint(SWIGTYPE_p_void pub, String field, double val) {
    helicsJNI.helicsPublicationPublishNamedPoint(SWIGTYPE_p_void.getCPtr(pub), field, val);
  }

  /**
   * Publish the contents of a helicsDataBuffer.<br>
   * <br>
   * @param pub The publication to publish for.<br>
   * @param buffer a HelicsDataBuffer object containing the data to publish<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationPublishDataBuffer(SWIGTYPE_p_void pub, SWIGTYPE_p_void buffer) {
    helicsJNI.helicsPublicationPublishDataBuffer(SWIGTYPE_p_void.getCPtr(pub), SWIGTYPE_p_void.getCPtr(buffer));
  }

  /**
   * Add a named input to the list of targets a publication publishes to.<br>
   * <br>
   * @param pub The publication to add the target for.<br>
   * @param target The name of an input that the data should be sent to.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsPublicationAddTarget(SWIGTYPE_p_void pub, String target) {
    helicsJNI.helicsPublicationAddTarget(SWIGTYPE_p_void.getCPtr(pub), target);
  }

  /**
   * Check if an input is valid.<br>
   * <br>
   * @param ipt The input to check.<br>
   * <br>
   * @return HELICS_TRUE if the Input object represents a valid input.
   */
  public static int helicsInputIsValid(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputIsValid(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Add a publication to the list of data that an input subscribes to.<br>
   * <br>
   * @param ipt The named input to modify.<br>
   * @param target The name of a publication that an input should subscribe to.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsInputAddTarget(SWIGTYPE_p_void ipt, String target) {
    helicsJNI.helicsInputAddTarget(SWIGTYPE_p_void.getCPtr(ipt), target);
  }

  /**
   * <br>
   * Get the size of the raw value for an input.<br>
   * <br>
   * @return The size of the raw data/string in bytes.
   */
  public static int helicsInputGetByteCount(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetByteCount(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the raw data for the latest value of an input.<br>
   * <br>
   * @param ipt The input to get the data for.<br>
   * <br>
   * @param data The memory location of the data<br>
   * @param maxDataLength The maximum size of information that data can hold.<br>
   * @param actualSize The actual length of data copied to data.<br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsInputGetBytes(SWIGTYPE_p_void ipt, SWIGTYPE_p_void data, int maxDataLength, int[] actualSize) {
    helicsJNI.helicsInputGetBytes(SWIGTYPE_p_void.getCPtr(ipt), SWIGTYPE_p_void.getCPtr(data), maxDataLength, actualSize);
  }

  /**
   * Get a copy of the raw data in a HelicsDataBuffer<br>
   * <br>
   * @param inp The input to get the data for.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * @return A HelicsDataBuffer object containing the data
   */
  public static SWIGTYPE_p_void helicsInputGetDataBuffer(SWIGTYPE_p_void inp) {
    long cPtr = helicsJNI.helicsInputGetDataBuffer(SWIGTYPE_p_void.getCPtr(inp));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get the size of a value for an input assuming return as a string.<br>
   * <br>
   * @return The size of the string.
   */
  public static int helicsInputGetStringSize(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetStringSize(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get a string value from an input.<br>
   * <br>
   * @param ipt The input to get the data for.<br>
   * <br>
   * @param outputString Storage for copying a null terminated string.<br>
   * @param maxStringLength The maximum size of information that str can hold.<br>
   * @param actualLength The actual length of the string.<br>
   * @param err Error term for capturing errors.
   */
  public static void helicsInputGetString(SWIGTYPE_p_void ipt, byte[] outputString, int[] actualLength) {
    helicsJNI.helicsInputGetString(SWIGTYPE_p_void.getCPtr(ipt), outputString, actualLength);
  }

  /**
   * Get an integer value from an input.<br>
   * <br>
   * @param ipt The input to get the data for.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * @return An int64_t value with the current value of the input.
   */
  public static long helicsInputGetInteger(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetInteger(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get a boolean value from an input.<br>
   * <br>
   * @param ipt The input to get the data for.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * @return A boolean value of current input value.
   */
  public static int helicsInputGetBoolean(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetBoolean(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get a double value from an input.<br>
   * <br>
   * @param ipt The input to get the data for.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * @return The double value of the input.
   */
  public static double helicsInputGetDouble(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetDouble(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get a time value from an input.<br>
   * <br>
   * @param ipt The input to get the data for.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * @return The resulting time value.
   */
  public static double helicsInputGetTime(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetTime(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get a single character value from an input.<br>
   * <br>
   * @param ipt The input to get the data for.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * @return The resulting character value.<br>
   *         NAK (negative acknowledgment) symbol returned on error
   */
  public static char helicsInputGetChar(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetChar(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get a complex object from an input object.<br>
   * <br>
   * @param ipt The input to get the data for.<br>
   * <br>
   * @param err A helics error object, if the object is not empty the function is bypassed otherwise it is filled in if there is an<br>
   * error.<br>
   * <br>
   * @return A HelicsComplex structure with the value.
   */
  public static HelicsComplex helicsInputGetComplexObject(SWIGTYPE_p_void ipt) {
    return new HelicsComplex(helicsJNI.helicsInputGetComplexObject(SWIGTYPE_p_void.getCPtr(ipt)), true);
  }

  /**
   * Get a pair of double forming a complex number from an input.<br>
   * <br>
   * @param ipt The input to get the data for.<br>
   * <br>
   * @param real Memory location to place the real part of a value.<br>
   * @param imag Memory location to place the imaginary part of a value.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.<br>
   * On error the values will not be altered.
   */
  public static void helicsInputGetComplex(SWIGTYPE_p_void ipt, double[] real, double[] imag) {
    helicsJNI.helicsInputGetComplex(SWIGTYPE_p_void.getCPtr(ipt), real, imag);
  }

  /**
   * Get the size of a value for an ionput assuming return as an array of doubles.<br>
   * <br>
   * @return The number of doubles in a returned vector.
   */
  public static int helicsInputGetVectorSize(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetVectorSize(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get a vector from an input.<br>
   * <br>
   * @param ipt The input to get the result for.<br>
   * <br>
   * @param data The location to store the data.<br>
   * @param maxLength The maximum size of the vector.<br>
   * @param actualSize Location to place the actual length of the resulting vector.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputGetVector(SWIGTYPE_p_void ipt, SWIGTYPE_p_double data, int maxLength, int[] actualSize) {
    helicsJNI.helicsInputGetVector(SWIGTYPE_p_void.getCPtr(ipt), SWIGTYPE_p_double.getCPtr(data), maxLength, actualSize);
  }

  /**
   * Get a complex vector from an input.<br>
   * <br>
   * @param ipt The input to get the result for.<br>
   * <br>
   * @param data The location to store the data. The data will be stored in alternating real and imaginary values.<br>
   * @param maxLength The maximum number of values data can hold.<br>
   * @param actualSize Location to place the actual length of the resulting complex vector (will be 1/2 the number of values assigned).<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputGetComplexVector(SWIGTYPE_p_void ipt, SWIGTYPE_p_double data, int maxLength, int[] actualSize) {
    helicsJNI.helicsInputGetComplexVector(SWIGTYPE_p_void.getCPtr(ipt), SWIGTYPE_p_double.getCPtr(data), maxLength, actualSize);
  }

  /**
   * Get a named point from an input.<br>
   * <br>
   * @param ipt The input to get the result for.<br>
   * <br>
   * @param outputString Storage for copying a null terminated string.<br>
   * @param maxStringLength The maximum size of information that str can hold.<br>
   * @param actualLength The actual length of the string<br>
   * @param val The double value for the named point.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputGetNamedPoint(SWIGTYPE_p_void ipt, byte[] outputString, int[] actualLength, double[] val) {
    helicsJNI.helicsInputGetNamedPoint(SWIGTYPE_p_void.getCPtr(ipt), outputString, actualLength, val);
  }

  /**
   * <br>
   * Set the default as a raw data array.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param data A pointer to the raw data to use for the default.<br>
   * <br>
   * @param inputDataLength The size of the raw data.<br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultBytes(SWIGTYPE_p_void ipt, SWIGTYPE_p_void data, int inputDataLength) {
    helicsJNI.helicsInputSetDefaultBytes(SWIGTYPE_p_void.getCPtr(ipt), SWIGTYPE_p_void.getCPtr(data), inputDataLength);
  }

  /**
   * Set the default as a string.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param defaultString A pointer to the default string.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultString(SWIGTYPE_p_void ipt, String defaultString) {
    helicsJNI.helicsInputSetDefaultString(SWIGTYPE_p_void.getCPtr(ipt), defaultString);
  }

  /**
   * Set the default as an integer.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param val The default integer.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultInteger(SWIGTYPE_p_void ipt, long val) {
    helicsJNI.helicsInputSetDefaultInteger(SWIGTYPE_p_void.getCPtr(ipt), val);
  }

  /**
   * Set the default as a boolean.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param val The default boolean value.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultBoolean(SWIGTYPE_p_void ipt, int val) {
    helicsJNI.helicsInputSetDefaultBoolean(SWIGTYPE_p_void.getCPtr(ipt), val);
  }

  /**
   * Set the default as a time.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param val The default time value.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultTime(SWIGTYPE_p_void ipt, double val) {
    helicsJNI.helicsInputSetDefaultTime(SWIGTYPE_p_void.getCPtr(ipt), val);
  }

  /**
   * Set the default as a char.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param val The default char value.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultChar(SWIGTYPE_p_void ipt, char val) {
    helicsJNI.helicsInputSetDefaultChar(SWIGTYPE_p_void.getCPtr(ipt), val);
  }

  /**
   * Set the default as a double.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param val The default double value.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultDouble(SWIGTYPE_p_void ipt, double val) {
    helicsJNI.helicsInputSetDefaultDouble(SWIGTYPE_p_void.getCPtr(ipt), val);
  }

  /**
   * Set the default as a complex number.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param real The default real value.<br>
   * @param imag The default imaginary value.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultComplex(SWIGTYPE_p_void ipt, double real, double imag) {
    helicsJNI.helicsInputSetDefaultComplex(SWIGTYPE_p_void.getCPtr(ipt), real, imag);
  }

  /**
   * Set the default as a vector of doubles.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param vectorInput A pointer to an array of double data.<br>
   * @param vectorLength The number of doubles in the vector.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultVector(SWIGTYPE_p_void ipt, double[] vectorInput, int vectorLength) {
    helicsJNI.helicsInputSetDefaultVector(SWIGTYPE_p_void.getCPtr(ipt), vectorInput, vectorLength);
  }

  /**
   * Set the default as a vector of complex doubles. The format is alternating real, imag doubles.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param vectorInput A pointer to an array of double data alternating between real and imaginary.<br>
   * @param vectorLength the number of complex values in the publication (vectorInput must contain 2xvectorLength elements).<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultComplexVector(SWIGTYPE_p_void ipt, double[] vectorInput, int vectorLength) {
    helicsJNI.helicsInputSetDefaultComplexVector(SWIGTYPE_p_void.getCPtr(ipt), vectorInput, vectorLength);
  }

  /**
   * Set the default as a NamedPoint.<br>
   * <br>
   * @param ipt The input to set the default for.<br>
   * @param defaultName A pointer to a null terminated string representing the field name to use in the named point.<br>
   * @param val A double value for the value of the named point.<br>
   * <br>
   * @param err An error object that will contain an error code and string if any error occurred during the execution of the function.
   */
  public static void helicsInputSetDefaultNamedPoint(SWIGTYPE_p_void ipt, String defaultName, double val) {
    helicsJNI.helicsInputSetDefaultNamedPoint(SWIGTYPE_p_void.getCPtr(ipt), defaultName, val);
  }

  /**
   * <br>
   * Get the type of an input.<br>
   * <br>
   * @param ipt The input to query.<br>
   * <br>
   * @return A void enumeration, HELICS_OK if everything worked.
   */
  public static String helicsInputGetType(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetType(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the type the publisher to an input is sending.<br>
   * <br>
   * @param ipt The input to query.<br>
   * <br>
   * @return A const char * with the type name.
   */
  public static String helicsInputGetPublicationType(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetPublicationType(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the type the publisher to an input is sending.<br>
   * <br>
   * @param ipt The input to query.<br>
   * <br>
   * @return An int containing the enumeration value of the publication type.
   */
  public static int helicsInputGetPublicationDataType(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetPublicationDataType(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the type of a publication.<br>
   * <br>
   * @param pub The publication to query.<br>
   * <br>
   * @return A void enumeration, HELICS_OK if everything worked.
   */
  public static String helicsPublicationGetType(SWIGTYPE_p_void pub) {
    return helicsJNI.helicsPublicationGetType(SWIGTYPE_p_void.getCPtr(pub));
  }

  /**
   * Get the key of an input.<br>
   * <br>
   * @param ipt The input to query.<br>
   * <br>
   * @return A const char with the input name.
   */
  public static String helicsInputGetName(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetName(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the target of a subscription.<br>
   * <br>
   * @return A const char with the subscription target.
   */
  public static String helicsSubscriptionGetTarget(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsSubscriptionGetTarget(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the target of an input.<br>
   * <br>
   * @return A const char with the input target.
   */
  public static String helicsInputGetTarget(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetTarget(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the name of a publication.<br>
   * <br>
   * This will be the global key used to identify the publication to the federation.<br>
   * <br>
   * @param pub The publication to query.<br>
   * <br>
   * @return A const char with the publication name.
   */
  public static String helicsPublicationGetName(SWIGTYPE_p_void pub) {
    return helicsJNI.helicsPublicationGetName(SWIGTYPE_p_void.getCPtr(pub));
  }

  /**
   * Get the units of an input.<br>
   * <br>
   * @param ipt The input to query.<br>
   * <br>
   * @return A void enumeration, HELICS_OK if everything worked.
   */
  public static String helicsInputGetUnits(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetUnits(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the units of the publication that an input is linked to.<br>
   * <br>
   * @param ipt The input to query.<br>
   * <br>
   * @return A void enumeration, HELICS_OK if everything worked.
   */
  public static String helicsInputGetInjectionUnits(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetInjectionUnits(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the units of an input.<br>
   * <br>
   * The same as helicsInputGetUnits.<br>
   * <br>
   * @param ipt The input to query.<br>
   * <br>
   * @return A void enumeration, HELICS_OK if everything worked.
   */
  public static String helicsInputGetExtractionUnits(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputGetExtractionUnits(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the units of a publication.<br>
   * <br>
   * @param pub The publication to query.<br>
   * <br>
   * @return A void enumeration, HELICS_OK if everything worked.
   */
  public static String helicsPublicationGetUnits(SWIGTYPE_p_void pub) {
    return helicsJNI.helicsPublicationGetUnits(SWIGTYPE_p_void.getCPtr(pub));
  }

  /**
   * Get the data in the info field of an input.<br>
   * <br>
   * @param inp The input to query.<br>
   * <br>
   * @return A string with the info field string.
   */
  public static String helicsInputGetInfo(SWIGTYPE_p_void inp) {
    return helicsJNI.helicsInputGetInfo(SWIGTYPE_p_void.getCPtr(inp));
  }

  /**
   * Set the data in the info field for an input.<br>
   * <br>
   * @param inp The input to query.<br>
   * @param info The string to set.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsInputSetInfo(SWIGTYPE_p_void inp, String info) {
    helicsJNI.helicsInputSetInfo(SWIGTYPE_p_void.getCPtr(inp), info);
  }

  /**
   * Get the data in a specified tag of an input.<br>
   * <br>
   * @param inp The input object to query.<br>
   * @param tagname The name of the tag to get the value for.<br>
   * @return A string with the tag data.
   */
  public static String helicsInputGetTag(SWIGTYPE_p_void inp, String tagname) {
    return helicsJNI.helicsInputGetTag(SWIGTYPE_p_void.getCPtr(inp), tagname);
  }

  /**
   * Set the data in a specific tag for an input.<br>
   * <br>
   * @param inp The input object to query.<br>
   * @param tagname The string to set.<br>
   * @param tagvalue The string value to associate with a tag.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsInputSetTag(SWIGTYPE_p_void inp, String tagname, String tagvalue) {
    helicsJNI.helicsInputSetTag(SWIGTYPE_p_void.getCPtr(inp), tagname, tagvalue);
  }

  /**
   * Get the data in the info field of an publication.<br>
   * <br>
   * @param pub The publication to query.<br>
   * <br>
   * @return A string with the info field string.
   */
  public static String helicsPublicationGetInfo(SWIGTYPE_p_void pub) {
    return helicsJNI.helicsPublicationGetInfo(SWIGTYPE_p_void.getCPtr(pub));
  }

  /**
   * Set the data in the info field for a publication.<br>
   * <br>
   * @param pub The publication to set the info field for.<br>
   * @param info The string to set.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsPublicationSetInfo(SWIGTYPE_p_void pub, String info) {
    helicsJNI.helicsPublicationSetInfo(SWIGTYPE_p_void.getCPtr(pub), info);
  }

  /**
   * Get the data in a specified tag of a publication.<br>
   * <br>
   * @param pub The publication object to query.<br>
   * @param tagname The name of the tag to query.<br>
   * @return A string with the tag data.
   */
  public static String helicsPublicationGetTag(SWIGTYPE_p_void pub, String tagname) {
    return helicsJNI.helicsPublicationGetTag(SWIGTYPE_p_void.getCPtr(pub), tagname);
  }

  /**
   * Set the data in a specific tag for a publication.<br>
   * <br>
   * @param pub The publication object to set a tag for.<br>
   * @param tagname The name of the tag to set.<br>
   * @param tagvalue The string value to associate with a tag.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsPublicationSetTag(SWIGTYPE_p_void pub, String tagname, String tagvalue) {
    helicsJNI.helicsPublicationSetTag(SWIGTYPE_p_void.getCPtr(pub), tagname, tagvalue);
  }

  /**
   * Get the current value of an input handle option<br>
   * <br>
   * @param inp The input to query.<br>
   * @param option Integer representation of the option in question see /ref helics_handle_options.<br>
   * <br>
   * @return An integer value with the current value of the given option.
   */
  public static int helicsInputGetOption(SWIGTYPE_p_void inp, int option) {
    return helicsJNI.helicsInputGetOption(SWIGTYPE_p_void.getCPtr(inp), option);
  }

  /**
   * Set an option on an input<br>
   * <br>
   * @param inp The input to query.<br>
   * @param option The option to set for the input /ref helics_handle_options.<br>
   * @param value The value to set the option to.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsInputSetOption(SWIGTYPE_p_void inp, int option, int value) {
    helicsJNI.helicsInputSetOption(SWIGTYPE_p_void.getCPtr(inp), option, value);
  }

  /**
   * Get the value of an option for a publication<br>
   * <br>
   * @param pub The publication to query.<br>
   * @param option The value to query see /ref helics_handle_options.<br>
   * <br>
   * @return A string with the info field string.
   */
  public static int helicsPublicationGetOption(SWIGTYPE_p_void pub, int option) {
    return helicsJNI.helicsPublicationGetOption(SWIGTYPE_p_void.getCPtr(pub), option);
  }

  /**
   * Set the value of an option for a publication<br>
   * <br>
   * @param pub The publication to query.<br>
   * @param option Integer code for the option to set /ref helics_handle_options.<br>
   * @param val The value to set the option to.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsPublicationSetOption(SWIGTYPE_p_void pub, int option, int val) {
    helicsJNI.helicsPublicationSetOption(SWIGTYPE_p_void.getCPtr(pub), option, val);
  }

  /**
   * Set the minimum change detection tolerance.<br>
   * <br>
   * @param pub The publication to modify.<br>
   * @param tolerance The tolerance level for publication, values changing less than this value will not be published.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsPublicationSetMinimumChange(SWIGTYPE_p_void pub, double tolerance) {
    helicsJNI.helicsPublicationSetMinimumChange(SWIGTYPE_p_void.getCPtr(pub), tolerance);
  }

  /**
   * Set the minimum change detection tolerance.<br>
   * <br>
   * @param inp The input to modify.<br>
   * @param tolerance The tolerance level for registering an update, values changing less than this value will not show as being updated.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsInputSetMinimumChange(SWIGTYPE_p_void inp, double tolerance) {
    helicsJNI.helicsInputSetMinimumChange(SWIGTYPE_p_void.getCPtr(inp), tolerance);
  }

  /**
   * <br>
   * Check if a particular input was updated.<br>
   * <br>
   * @return HELICS_TRUE if it has been updated since the last value retrieval.
   */
  public static int helicsInputIsUpdated(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputIsUpdated(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the last time a input was updated.
   */
  public static double helicsInputLastUpdateTime(SWIGTYPE_p_void ipt) {
    return helicsJNI.helicsInputLastUpdateTime(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Clear the updated flag from an input.
   */
  public static void helicsInputClearUpdate(SWIGTYPE_p_void ipt) {
    helicsJNI.helicsInputClearUpdate(SWIGTYPE_p_void.getCPtr(ipt));
  }

  /**
   * Get the number of publications in a federate.<br>
   * <br>
   * @return (-1) if fed was not a valid federate otherwise returns the number of publications.
   */
  public static int helicsFederateGetPublicationCount(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateGetPublicationCount(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Get the number of inputs in a federate.<br>
   * <br>
   * @return (-1) if fed was not a valid federate otherwise returns the number of inputs.
   */
  public static int helicsFederateGetInputCount(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateGetInputCount(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Create an endpoint.<br>
   * <br>
   * The endpoint becomes part of the federate and is destroyed when the federate is freed<br>
   *          so there are no separate free functions for endpoints.<br>
   * <br>
   * @param fed The federate object in which to create an endpoint must have been created<br>
   *           with helicsCreateMessageFederate or helicsCreateCombinationFederate.<br>
   * @param name The identifier for the endpoint. This will be prepended with the federate name for the global identifier.<br>
   * @param type A string describing the expected type of the publication (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return An object containing the endpoint, or nullptr on failure.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterEndpoint(SWIGTYPE_p_void fed, String name, String type) {
    long cPtr = helicsJNI.helicsFederateRegisterEndpoint(SWIGTYPE_p_void.getCPtr(fed), name, type);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create an endpoint.<br>
   * <br>
   * The endpoint becomes part of the federate and is destroyed when the federate is freed<br>
   *          so there are no separate free functions for endpoints.<br>
   * <br>
   * @param fed The federate object in which to create an endpoint must have been created<br>
   *               with helicsCreateMessageFederate or helicsCreateCombinationFederate.<br>
   * @param name The identifier for the endpoint, the given name is the global identifier.<br>
   * @param type A string describing the expected type of the publication (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * @return An object containing the endpoint, or nullptr on failure.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterGlobalEndpoint(SWIGTYPE_p_void fed, String name, String type) {
    long cPtr = helicsJNI.helicsFederateRegisterGlobalEndpoint(SWIGTYPE_p_void.getCPtr(fed), name, type);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a targeted endpoint.  Targeted endpoints have specific destinations predefined and do not allow sending messages to other<br>
   * endpoints<br>
   * <br>
   * The endpoint becomes part of the federate and is destroyed when the federate is freed<br>
   *          so there are no separate free functions for endpoints.<br>
   * <br>
   * @param fed The federate object in which to create an endpoint must have been created<br>
   *           with helicsCreateMessageFederate or helicsCreateCombinationFederate.<br>
   * @param name The identifier for the endpoint. This will be prepended with the federate name for the global identifier.<br>
   * @param type A string describing the expected type of the publication (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return An object containing the endpoint, or nullptr on failure.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterTargetedEndpoint(SWIGTYPE_p_void fed, String name, String type) {
    long cPtr = helicsJNI.helicsFederateRegisterTargetedEndpoint(SWIGTYPE_p_void.getCPtr(fed), name, type);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a global targeted endpoint, Targeted endpoints have specific destinations predefined and do not allow sending messages to other<br>
   *  endpoints<br>
   * <br>
   * The endpoint becomes part of the federate and is destroyed when the federate is freed<br>
   *          so there are no separate free functions for endpoints.<br>
   * <br>
   * @param fed The federate object in which to create an endpoint must have been created<br>
   *               with helicsCreateMessageFederate or helicsCreateCombinationFederate.<br>
   * @param name The identifier for the endpoint, the given name is the global identifier.<br>
   * @param type A string describing the expected type of the publication (may be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * @return An object containing the endpoint, or nullptr on failure.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterGlobalTargetedEndpoint(SWIGTYPE_p_void fed, String name, String type) {
    long cPtr = helicsJNI.helicsFederateRegisterGlobalTargetedEndpoint(SWIGTYPE_p_void.getCPtr(fed), name, type);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get an endpoint object from a name.<br>
   * <br>
   * @param fed The message federate object to use to get the endpoint.<br>
   * @param name The name of the endpoint.<br>
   * <br>
   * @param err The error object to complete if there is an error.<br>
   * <br>
   * <br>
   * @return A HelicsEndpoint object.<br>
   * <br>
   * The object will not be valid and err will contain an error code if no endpoint with the specified name exists.
   */
  public static SWIGTYPE_p_void helicsFederateGetEndpoint(SWIGTYPE_p_void fed, String name) {
    long cPtr = helicsJNI.helicsFederateGetEndpoint(SWIGTYPE_p_void.getCPtr(fed), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get an endpoint by its index, typically already created via registerInterfaces file or something of that nature.<br>
   * <br>
   * @param fed The federate object in which to create a publication.<br>
   * @param index The index of the publication to get.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsEndpoint.<br>
   * <br>
   * The HelicsEndpoint returned will be NULL if given an invalid index.
   */
  public static SWIGTYPE_p_void helicsFederateGetEndpointByIndex(SWIGTYPE_p_void fed, int index) {
    long cPtr = helicsJNI.helicsFederateGetEndpointByIndex(SWIGTYPE_p_void.getCPtr(fed), index);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Check if an endpoint is valid.<br>
   * <br>
   * @param endpoint The endpoint object to check.<br>
   * <br>
   * @return HELICS_TRUE if the Endpoint object represents a valid endpoint.
   */
  public static int helicsEndpointIsValid(SWIGTYPE_p_void endpoint) {
    return helicsJNI.helicsEndpointIsValid(SWIGTYPE_p_void.getCPtr(endpoint));
  }

  /**
   * Set the default destination for an endpoint if no other endpoint is given.<br>
   * <br>
   * @param endpoint The endpoint to set the destination for.<br>
   * @param dst A string naming the desired default endpoint.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSetDefaultDestination(SWIGTYPE_p_void endpoint, String dst) {
    helicsJNI.helicsEndpointSetDefaultDestination(SWIGTYPE_p_void.getCPtr(endpoint), dst);
  }

  /**
   * Get the default destination for an endpoint.<br>
   * <br>
   * @param endpoint The endpoint to set the destination for.<br>
   * <br>
   * @return A string with the default destination.
   */
  public static String helicsEndpointGetDefaultDestination(SWIGTYPE_p_void endpoint) {
    return helicsJNI.helicsEndpointGetDefaultDestination(SWIGTYPE_p_void.getCPtr(endpoint));
  }

  /**
   * Send a message to the targeted destination.<br>
   * <br>
   * @param endpoint The endpoint to send the data from.<br>
   * @param message The string to send.<br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSendString(SWIGTYPE_p_void endpoint, String message) {
    helicsJNI.helicsEndpointSendString(SWIGTYPE_p_void.getCPtr(endpoint), message);
  }

  /**
   * Send a message to the specified destination.<br>
   * <br>
   * @param endpoint The endpoint to send the data from.<br>
   * <br>
   * @param message The string to send.<br>
   * <br>
   * @param dst The target destination. Use nullptr to send to the default destination.<br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSendStringTo(SWIGTYPE_p_void endpoint, String message, String dst) {
    helicsJNI.helicsEndpointSendStringTo(SWIGTYPE_p_void.getCPtr(endpoint), message, dst);
  }

  /**
   * Send a message to the specified destination at a specific time.<br>
   * <br>
   * @param endpoint The endpoint to send the data from.<br>
   * @param message The data to send.<br>
   * <br>
   * @param dst The target destination. Use nullptr to send to the default destination.<br>
   * <br>
   * @param time The time the message should be sent.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSendStringToAt(SWIGTYPE_p_void endpoint, String message, String dst, double time) {
    helicsJNI.helicsEndpointSendStringToAt(SWIGTYPE_p_void.getCPtr(endpoint), message, dst, time);
  }

  /**
   * Send a message at a specific time to the targeted destinations.<br>
   * <br>
   * @param endpoint The endpoint to send the data from.<br>
   * <br>
   * @param message The data to send.<br>
   * <br>
   * @param time The time the message should be sent.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSendStringAt(SWIGTYPE_p_void endpoint, String message, double time) {
    helicsJNI.helicsEndpointSendStringAt(SWIGTYPE_p_void.getCPtr(endpoint), message, time);
  }

  /**
   * Send a message to the targeted destination.<br>
   * <br>
   * @param endpoint The endpoint to send the data from.<br>
   * @param data The data to send.<br>
   * <br>
   * @param inputDataLength The length of the data to send.<br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSendBytes(SWIGTYPE_p_void endpoint, SWIGTYPE_p_void data, int inputDataLength) {
    helicsJNI.helicsEndpointSendBytes(SWIGTYPE_p_void.getCPtr(endpoint), SWIGTYPE_p_void.getCPtr(data), inputDataLength);
  }

  /**
   * Send a message to the specified destination.<br>
   * <br>
   * @param endpoint The endpoint to send the data from.<br>
   * <br>
   * @param data The data to send.<br>
   * <br>
   * @param inputDataLength The length of the data to send.<br>
   * @param dst The target destination. Use nullptr to send to the default destination.<br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSendBytesTo(SWIGTYPE_p_void endpoint, SWIGTYPE_p_void data, int inputDataLength, String dst) {
    helicsJNI.helicsEndpointSendBytesTo(SWIGTYPE_p_void.getCPtr(endpoint), SWIGTYPE_p_void.getCPtr(data), inputDataLength, dst);
  }

  /**
   * Send a message to the specified destination at a specific time.<br>
   * <br>
   * @param endpoint The endpoint to send the data from.<br>
   * @param data The data to send.<br>
   * <br>
   * @param inputDataLength The length of the data to send.<br>
   * <br>
   * @param dst The target destination. Use nullptr to send to the default destination.<br>
   * <br>
   * @param time The time the message should be sent.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSendBytesToAt(SWIGTYPE_p_void endpoint, SWIGTYPE_p_void data, int inputDataLength, String dst, double time) {
    helicsJNI.helicsEndpointSendBytesToAt(SWIGTYPE_p_void.getCPtr(endpoint), SWIGTYPE_p_void.getCPtr(data), inputDataLength, dst, time);
  }

  /**
   * Send a message at a specific time to the targeted destinations<br>
   * <br>
   * @param endpoint The endpoint to send the data from.<br>
   * <br>
   * @param data The data to send.<br>
   * <br>
   * @param inputDataLength The length of the data to send.<br>
   * <br>
   * @param time The time the message should be sent.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSendBytesAt(SWIGTYPE_p_void endpoint, SWIGTYPE_p_void data, int inputDataLength, double time) {
    helicsJNI.helicsEndpointSendBytesAt(SWIGTYPE_p_void.getCPtr(endpoint), SWIGTYPE_p_void.getCPtr(data), inputDataLength, time);
  }

  /**
   * Send a message object from a specific endpoint.<br>
   * <br>
   * @param endpoint The endpoint to send the data from.<br>
   * @param message The actual message to send which will be copied.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSendMessage(SWIGTYPE_p_void endpoint, SWIGTYPE_p_void message) {
    helicsJNI.helicsEndpointSendMessage(SWIGTYPE_p_void.getCPtr(endpoint), SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Send a message object from a specific endpoint, the message will not be copied and the message object will no longer be valid<br>
   * after the call.<br>
   * <br>
   * @param endpoint The endpoint to send the data from.<br>
   * @param message The actual message to send which will be copied.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSendMessageZeroCopy(SWIGTYPE_p_void endpoint, SWIGTYPE_p_void message) {
    helicsJNI.helicsEndpointSendMessageZeroCopy(SWIGTYPE_p_void.getCPtr(endpoint), SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Subscribe an endpoint to a publication.<br>
   * <br>
   * @param endpoint The endpoint to use.<br>
   * @param key The name of the publication.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsEndpointSubscribe(SWIGTYPE_p_void endpoint, String key) {
    helicsJNI.helicsEndpointSubscribe(SWIGTYPE_p_void.getCPtr(endpoint), key);
  }

  /**
   * Check if the federate has any outstanding messages.<br>
   * <br>
   * @param fed The federate to check.<br>
   * <br>
   * @return HELICS_TRUE if the federate has a message waiting, HELICS_FALSE otherwise.
   */
  public static int helicsFederateHasMessage(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateHasMessage(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Check if a given endpoint has any unread messages.<br>
   * <br>
   * @param endpoint The endpoint to check.<br>
   * <br>
   * @return HELICS_TRUE if the endpoint has a message, HELICS_FALSE otherwise.
   */
  public static int helicsEndpointHasMessage(SWIGTYPE_p_void endpoint) {
    return helicsJNI.helicsEndpointHasMessage(SWIGTYPE_p_void.getCPtr(endpoint));
  }

  /**
   * Returns the number of pending receives for the specified destination endpoint.<br>
   * <br>
   * @param fed The federate to get the number of waiting messages from.
   */
  public static int helicsFederatePendingMessageCount(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederatePendingMessageCount(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Returns the number of pending receives for all endpoints of a particular federate.<br>
   * <br>
   * @param endpoint The endpoint to query.
   */
  public static int helicsEndpointPendingMessageCount(SWIGTYPE_p_void endpoint) {
    return helicsJNI.helicsEndpointPendingMessageCount(SWIGTYPE_p_void.getCPtr(endpoint));
  }

  /**
   * Receive a packet from a particular endpoint.<br>
   * <br>
   * @param endpoint The identifier for the endpoint.<br>
   * <br>
   * @return A message object.
   */
  public static SWIGTYPE_p_void helicsEndpointGetMessage(SWIGTYPE_p_void endpoint) {
    long cPtr = helicsJNI.helicsEndpointGetMessage(SWIGTYPE_p_void.getCPtr(endpoint));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a new empty message object.<br>
   * <br>
   * The message is empty and isValid will return false since there is no data associated with the message yet.<br>
   * <br>
   * @param endpoint The endpoint object to associate the message with.<br>
   * <br>
   * @param err An error object to fill out in case of an error.<br>
   * <br>
   * <br>
   * @return A new HelicsMessage.
   */
  public static SWIGTYPE_p_void helicsEndpointCreateMessage(SWIGTYPE_p_void endpoint) {
    long cPtr = helicsJNI.helicsEndpointCreateMessage(SWIGTYPE_p_void.getCPtr(endpoint));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Clear all stored messages stored from an endpoint.<br>
   * <br>
   * This clears messages retrieved through helicsEndpointGetMessage or helicsEndpointCreateMessage<br>
   * <br>
   * @param endpoint The endpoint to clear the message for.
   */
  public static void helicsEndpointClearMessages(SWIGTYPE_p_void endpoint) {
    helicsJNI.helicsEndpointClearMessages(SWIGTYPE_p_void.getCPtr(endpoint));
  }

  /**
   * Receive a communication message for any endpoint in the federate.<br>
   * <br>
   * The return order will be in order of endpoint creation.<br>
   *          So all messages that are available for the first endpoint, then all for the second, and so on.<br>
   *          Within a single endpoint, the messages are ordered by time, then source_id, then order of arrival.<br>
   * <br>
   * @return A HelicsMessage which references the data in the message.
   */
  public static SWIGTYPE_p_void helicsFederateGetMessage(SWIGTYPE_p_void fed) {
    long cPtr = helicsJNI.helicsFederateGetMessage(SWIGTYPE_p_void.getCPtr(fed));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a new empty message object.<br>
   * <br>
   * The message is empty and isValid will return false since there is no data associated with the message yet.<br>
   * <br>
   * @param fed the federate object to associate the message with<br>
   * <br>
   * @param err An error object to fill out in case of an error.<br>
   * <br>
   * <br>
   * @return A HelicsMessage containing the message data.
   */
  public static SWIGTYPE_p_void helicsFederateCreateMessage(SWIGTYPE_p_void fed) {
    long cPtr = helicsJNI.helicsFederateCreateMessage(SWIGTYPE_p_void.getCPtr(fed));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Clear all stored messages from a federate.<br>
   * <br>
   * This clears messages retrieved through helicsEndpointGetMessage or helicsFederateGetMessage<br>
   * <br>
   * @param fed The federate to clear the message for.
   */
  public static void helicsFederateClearMessages(SWIGTYPE_p_void fed) {
    helicsJNI.helicsFederateClearMessages(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Get the type specified for an endpoint.<br>
   * <br>
   * @param endpoint The endpoint object in question.<br>
   * <br>
   * @return The defined type of the endpoint.
   */
  public static String helicsEndpointGetType(SWIGTYPE_p_void endpoint) {
    return helicsJNI.helicsEndpointGetType(SWIGTYPE_p_void.getCPtr(endpoint));
  }

  /**
   * Get the name of an endpoint.<br>
   * <br>
   * @param endpoint The endpoint object in question.<br>
   * <br>
   * @return The name of the endpoint.
   */
  public static String helicsEndpointGetName(SWIGTYPE_p_void endpoint) {
    return helicsJNI.helicsEndpointGetName(SWIGTYPE_p_void.getCPtr(endpoint));
  }

  /**
   * Get the number of endpoints in a federate.<br>
   * <br>
   * @param fed The message federate to query.<br>
   * <br>
   * @return (-1) if fed was not a valid federate, otherwise returns the number of endpoints.
   */
  public static int helicsFederateGetEndpointCount(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateGetEndpointCount(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Get the local information field of an endpoint.<br>
   * <br>
   * @param end The endpoint to query.<br>
   * <br>
   * @return A string with the info field string.
   */
  public static String helicsEndpointGetInfo(SWIGTYPE_p_void end) {
    return helicsJNI.helicsEndpointGetInfo(SWIGTYPE_p_void.getCPtr(end));
  }

  /**
   * Set the data in the interface information field for an endpoint.<br>
   * <br>
   * @param endpoint The endpoint to set the information for<br>
   * @param info The string to store in the field<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsEndpointSetInfo(SWIGTYPE_p_void endpoint, String info) {
    helicsJNI.helicsEndpointSetInfo(SWIGTYPE_p_void.getCPtr(endpoint), info);
  }

  /**
   * Get the data in a specified tag of an endpoint<br>
   * <br>
   * @param endpoint The endpoint to query.<br>
   * @param tagname The name of the tag to query.<br>
   * @return A string with the tag data.
   */
  public static String helicsEndpointGetTag(SWIGTYPE_p_void endpoint, String tagname) {
    return helicsJNI.helicsEndpointGetTag(SWIGTYPE_p_void.getCPtr(endpoint), tagname);
  }

  /**
   * Set the data in a specific tag for an endpoint.<br>
   * <br>
   * @param endpoint The endpoint to query.<br>
   * @param tagname The string to set.<br>
   * @param tagvalue The string value to associate with a tag.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsEndpointSetTag(SWIGTYPE_p_void endpoint, String tagname, String tagvalue) {
    helicsJNI.helicsEndpointSetTag(SWIGTYPE_p_void.getCPtr(endpoint), tagname, tagvalue);
  }

  /**
   * Set a handle option on an endpoint.<br>
   * <br>
   * @param endpoint The endpoint to modify.<br>
   * @param option Integer code for the option to set /ref helics_handle_options.<br>
   * @param value The value to set the option to.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsEndpointSetOption(SWIGTYPE_p_void endpoint, int option, int value) {
    helicsJNI.helicsEndpointSetOption(SWIGTYPE_p_void.getCPtr(endpoint), option, value);
  }

  /**
   * Set a handle option on an endpoint.<br>
   * <br>
   * @param endpoint The endpoint to modify.<br>
   * @param option Integer code for the option to set /ref helics_handle_options.<br>
   * @return the value of the option, for boolean options will be 0 or 1
   */
  public static int helicsEndpointGetOption(SWIGTYPE_p_void endpoint, int option) {
    return helicsJNI.helicsEndpointGetOption(SWIGTYPE_p_void.getCPtr(endpoint), option);
  }

  /**
   * add a source target to an endpoint,  Specifying an endpoint to receive undirected messages from<br>
   * <br>
   * @param endpoint The endpoint to modify.<br>
   * @param targetEndpoint the endpoint to get messages from<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsEndpointAddSourceTarget(SWIGTYPE_p_void endpoint, String targetEndpoint) {
    helicsJNI.helicsEndpointAddSourceTarget(SWIGTYPE_p_void.getCPtr(endpoint), targetEndpoint);
  }

  /**
   * add a destination target to an endpoint,  Specifying an endpoint to send undirected messages to<br>
   * <br>
   * @param endpoint The endpoint to modify.<br>
   * @param targetEndpoint the name of the endpoint to send messages to<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsEndpointAddDestinationTarget(SWIGTYPE_p_void endpoint, String targetEndpoint) {
    helicsJNI.helicsEndpointAddDestinationTarget(SWIGTYPE_p_void.getCPtr(endpoint), targetEndpoint);
  }

  /**
   * remove an endpoint from being targeted<br>
   * <br>
   * @param endpoint The endpoint to modify.<br>
   * @param targetEndpoint the name of the endpoint to send messages to<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsEndpointRemoveTarget(SWIGTYPE_p_void endpoint, String targetEndpoint) {
    helicsJNI.helicsEndpointRemoveTarget(SWIGTYPE_p_void.getCPtr(endpoint), targetEndpoint);
  }

  /**
   * add a source Filter to an endpoint<br>
   * <br>
   * @param endpoint The endpoint to modify.<br>
   * @param filterName the name of the filter to add<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsEndpointAddSourceFilter(SWIGTYPE_p_void endpoint, String filterName) {
    helicsJNI.helicsEndpointAddSourceFilter(SWIGTYPE_p_void.getCPtr(endpoint), filterName);
  }

  /**
   * add a destination filter to an endpoint<br>
   * <br>
   * @param endpoint The endpoint to modify.<br>
   * @param filterName The name of the filter to add.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsEndpointAddDestinationFilter(SWIGTYPE_p_void endpoint, String filterName) {
    helicsJNI.helicsEndpointAddDestinationFilter(SWIGTYPE_p_void.getCPtr(endpoint), filterName);
  }

  /**
   * Get the source endpoint of a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * <br>
   * @return A string with the source endpoint.
   */
  public static String helicsMessageGetSource(SWIGTYPE_p_void message) {
    return helicsJNI.helicsMessageGetSource(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Get the destination endpoint of a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * <br>
   * @return A string with the destination endpoint.
   */
  public static String helicsMessageGetDestination(SWIGTYPE_p_void message) {
    return helicsJNI.helicsMessageGetDestination(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Get the original source endpoint of a message, the source may have been modified by filters or other actions.<br>
   * <br>
   * @param message The message object in question.<br>
   * <br>
   * @return A string with the source of a message.
   */
  public static String helicsMessageGetOriginalSource(SWIGTYPE_p_void message) {
    return helicsJNI.helicsMessageGetOriginalSource(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Get the original destination endpoint of a message, the destination may have been modified by filters or other actions.<br>
   * <br>
   * @param message The message object in question.<br>
   * <br>
   * @return A string with the original destination of a message.
   */
  public static String helicsMessageGetOriginalDestination(SWIGTYPE_p_void message) {
    return helicsJNI.helicsMessageGetOriginalDestination(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Get the helics time associated with a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * <br>
   * @return The time associated with a message.
   */
  public static double helicsMessageGetTime(SWIGTYPE_p_void message) {
    return helicsJNI.helicsMessageGetTime(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Get the payload of a message as a string.<br>
   * <br>
   * @param message The message object in question.<br>
   * <br>
   * @return A string representing the payload of a message.
   */
  public static String helicsMessageGetString(SWIGTYPE_p_void message) {
    return helicsJNI.helicsMessageGetString(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Get the messageID of a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * <br>
   * @return The messageID.
   */
  public static int helicsMessageGetMessageID(SWIGTYPE_p_void message) {
    return helicsJNI.helicsMessageGetMessageID(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Check if a flag is set on a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param flag The flag to check should be between [0,15].<br>
   * <br>
   * @return The flags associated with a message.
   */
  public static int helicsMessageGetFlagOption(SWIGTYPE_p_void message, int flag) {
    return helicsJNI.helicsMessageGetFlagOption(SWIGTYPE_p_void.getCPtr(message), flag);
  }

  /**
   * Get the size of the data payload in bytes.<br>
   * <br>
   * @param message The message object in question.<br>
   * <br>
   * @return The size of the data payload.
   */
  public static int helicsMessageGetByteCount(SWIGTYPE_p_void message) {
    return helicsJNI.helicsMessageGetByteCount(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Get the raw data for a message object.<br>
   * <br>
   * @param message A message object to get the data for.<br>
   * <br>
   * @param data The memory location of the data.<br>
   * @param maxMessageLength The maximum size of information that data can hold.<br>
   * @param actualSize The actual length of data copied to data.<br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsMessageGetBytes(SWIGTYPE_p_void message, SWIGTYPE_p_void data, int maxMessageLength, int[] actualSize) {
    helicsJNI.helicsMessageGetBytes(SWIGTYPE_p_void.getCPtr(message), SWIGTYPE_p_void.getCPtr(data), maxMessageLength, actualSize);
  }

  /**
   * Get a pointer to the raw data of a message.<br>
   * <br>
   * @param message A message object to get the data for.<br>
   * <br>
   * @return A pointer to the raw data in memory, the pointer may be NULL if the message is not a valid message.
   */
  public static SWIGTYPE_p_void helicsMessageGetBytesPointer(SWIGTYPE_p_void message) {
    long cPtr = helicsJNI.helicsMessageGetBytesPointer(SWIGTYPE_p_void.getCPtr(message));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get a data buffer to the message object<br>
   * <br>
   * @param message A message object to get the dataBuffer for<br>
   * <br>
   * @return A HelicsDataBuffer object to the data in a message.  Modifying the buffer will directly modify the message contents.
   */
  public static SWIGTYPE_p_void helicsMessageDataBuffer(SWIGTYPE_p_void message) {
    long cPtr = helicsJNI.helicsMessageDataBuffer(SWIGTYPE_p_void.getCPtr(message));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * A check if the message contains a valid payload.<br>
   * <br>
   * @param message The message object in question.<br>
   * <br>
   * @return HELICS_TRUE if the message contains a payload.
   */
  public static int helicsMessageIsValid(SWIGTYPE_p_void message) {
    return helicsJNI.helicsMessageIsValid(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Set the source of a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param src A string containing the source.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageSetSource(SWIGTYPE_p_void message, String src) {
    helicsJNI.helicsMessageSetSource(SWIGTYPE_p_void.getCPtr(message), src);
  }

  /**
   * Set the destination of a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param dst A string containing the new destination.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageSetDestination(SWIGTYPE_p_void message, String dst) {
    helicsJNI.helicsMessageSetDestination(SWIGTYPE_p_void.getCPtr(message), dst);
  }

  /**
   * Set the original source of a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param src A string containing the new original source.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageSetOriginalSource(SWIGTYPE_p_void message, String src) {
    helicsJNI.helicsMessageSetOriginalSource(SWIGTYPE_p_void.getCPtr(message), src);
  }

  /**
   * Set the original destination of a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param dst A string containing the new original source.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageSetOriginalDestination(SWIGTYPE_p_void message, String dst) {
    helicsJNI.helicsMessageSetOriginalDestination(SWIGTYPE_p_void.getCPtr(message), dst);
  }

  /**
   * Set the delivery time for a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param time The time the message should be delivered.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageSetTime(SWIGTYPE_p_void message, double time) {
    helicsJNI.helicsMessageSetTime(SWIGTYPE_p_void.getCPtr(message), time);
  }

  /**
   * Reserve space in a buffer but don't actually resize.<br>
   * <br>
   * The message data buffer will be reserved but not resized.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param reserveSize The number of bytes to reserve in the message object.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageReserve(SWIGTYPE_p_void message, int reserveSize) {
    helicsJNI.helicsMessageReserve(SWIGTYPE_p_void.getCPtr(message), reserveSize);
  }

  /**
   * Set the message ID for the message.<br>
   * <br>
   * Normally this is not needed and the core of HELICS will adjust as needed.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param messageID A new message ID.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageSetMessageID(SWIGTYPE_p_void message, SWIGTYPE_p_int32_t messageID) {
    helicsJNI.helicsMessageSetMessageID(SWIGTYPE_p_void.getCPtr(message), SWIGTYPE_p_int32_t.getCPtr(messageID));
  }

  /**
   * Clear the flags of a message.<br>
   * <br>
   * @param message The message object in question
   */
  public static void helicsMessageClearFlags(SWIGTYPE_p_void message) {
    helicsJNI.helicsMessageClearFlags(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Set a flag on a message.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param flag An index of a flag to set on the message.<br>
   * @param flagValue The desired value of the flag.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageSetFlagOption(SWIGTYPE_p_void message, int flag, int flagValue) {
    helicsJNI.helicsMessageSetFlagOption(SWIGTYPE_p_void.getCPtr(message), flag, flagValue);
  }

  /**
   * Set the data payload of a message as a string.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param data A null terminated string containing the message data.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageSetString(SWIGTYPE_p_void message, String data) {
    helicsJNI.helicsMessageSetString(SWIGTYPE_p_void.getCPtr(message), data);
  }

  /**
   * Set the data payload of a message as raw data.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param data A string containing the message data.<br>
   * @param inputDataLength The length of the data to input.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageSetData(SWIGTYPE_p_void message, SWIGTYPE_p_void data, int inputDataLength) {
    helicsJNI.helicsMessageSetData(SWIGTYPE_p_void.getCPtr(message), SWIGTYPE_p_void.getCPtr(data), inputDataLength);
  }

  /**
   * Set the data payload of a message from a HelicsDataBuffer Object<br>
   * <br>
   * @param message The message object in question.<br>
   * @param data the dataBuffer containing the appropriate data, if null will clear the message payload<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageSetDataBuffer(SWIGTYPE_p_void message, SWIGTYPE_p_void data) {
    helicsJNI.helicsMessageSetDataBuffer(SWIGTYPE_p_void.getCPtr(message), SWIGTYPE_p_void.getCPtr(data));
  }

  /**
   * Append data to the payload.<br>
   * <br>
   * @param message The message object in question.<br>
   * @param data A string containing the message data to append.<br>
   * @param inputDataLength The length of the data to input.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageAppendData(SWIGTYPE_p_void message, SWIGTYPE_p_void data, int inputDataLength) {
    helicsJNI.helicsMessageAppendData(SWIGTYPE_p_void.getCPtr(message), SWIGTYPE_p_void.getCPtr(data), inputDataLength);
  }

  /**
   * Copy a message object.<br>
   * <br>
   * @param src_message The message object to copy from.<br>
   * @param dst_message The message object to copy to.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageCopy(SWIGTYPE_p_void src_message, SWIGTYPE_p_void dst_message) {
    helicsJNI.helicsMessageCopy(SWIGTYPE_p_void.getCPtr(src_message), SWIGTYPE_p_void.getCPtr(dst_message));
  }

  /**
   * Clone a message object.<br>
   * <br>
   * @param message The message object to copy from.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static SWIGTYPE_p_void helicsMessageClone(SWIGTYPE_p_void message) {
    long cPtr = helicsJNI.helicsMessageClone(SWIGTYPE_p_void.getCPtr(message));
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Free a message object from memory<br>
   * @param message The message object to copy from.<br>
   * memory for message is managed so not using this function does not create memory leaks, this is an indication<br>
   * to the system that the memory for this message is done being used and can be reused for a new message.<br>
   * helicsFederateClearMessages() can also be used to clear up all stored messages at once
   */
  public static void helicsMessageFree(SWIGTYPE_p_void message) {
    helicsJNI.helicsMessageFree(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * Reset a message to empty state<br>
   * @param message The message object to copy from.<br>
   * The message after this function will be empty, with no source or destination<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsMessageClear(SWIGTYPE_p_void message) {
    helicsJNI.helicsMessageClear(SWIGTYPE_p_void.getCPtr(message));
  }

  /**
   * <br>
   * Create a source Filter on the specified federate.<br>
   * <br>
   * Filters can be created through a federate or a core, linking through a federate allows<br>
   *          a few extra features of name matching to function on the federate interface but otherwise equivalent behavior<br>
   * <br>
   * @param fed The federate to register through.<br>
   * @param type The type of filter to create /ref HelicsFilterTypes.<br>
   * @param name The name of the filter (can be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsFilter object.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterFilter(SWIGTYPE_p_void fed, HelicsFilterTypes type, String name) {
    long cPtr = helicsJNI.helicsFederateRegisterFilter(SWIGTYPE_p_void.getCPtr(fed), type.swigValue(), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a global source filter through a federate.<br>
   * <br>
   * Filters can be created through a federate or a core, linking through a federate allows<br>
   *          a few extra features of name matching to function on the federate interface but otherwise equivalent behavior.<br>
   * <br>
   * @param fed The federate to register through.<br>
   * @param type The type of filter to create /ref HelicsFilterTypes.<br>
   * @param name The name of the filter (can be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsFilter object.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterGlobalFilter(SWIGTYPE_p_void fed, HelicsFilterTypes type, String name) {
    long cPtr = helicsJNI.helicsFederateRegisterGlobalFilter(SWIGTYPE_p_void.getCPtr(fed), type.swigValue(), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a cloning Filter on the specified federate.<br>
   * <br>
   * Cloning filters copy a message and send it to multiple locations, source and destination can be added<br>
   *          through other functions.<br>
   * <br>
   * @param fed The federate to register through.<br>
   * @param name The name of the filter (can be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsFilter object.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterCloningFilter(SWIGTYPE_p_void fed, String name) {
    long cPtr = helicsJNI.helicsFederateRegisterCloningFilter(SWIGTYPE_p_void.getCPtr(fed), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a global cloning Filter on the specified federate.<br>
   * <br>
   * Cloning filters copy a message and send it to multiple locations, source and destination can be added<br>
   *          through other functions.<br>
   * <br>
   * @param fed The federate to register through.<br>
   * @param name The name of the filter (can be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsFilter object.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterGlobalCloningFilter(SWIGTYPE_p_void fed, String name) {
    long cPtr = helicsJNI.helicsFederateRegisterGlobalCloningFilter(SWIGTYPE_p_void.getCPtr(fed), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a source Filter on the specified core.<br>
   * <br>
   * Filters can be created through a federate or a core, linking through a federate allows<br>
   *          a few extra features of name matching to function on the federate interface but otherwise equivalent behavior.<br>
   * <br>
   * @param core The core to register through.<br>
   * @param type The type of filter to create /ref HelicsFilterTypes.<br>
   * @param name The name of the filter (can be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsFilter object.
   */
  public static SWIGTYPE_p_void helicsCoreRegisterFilter(SWIGTYPE_p_void core, HelicsFilterTypes type, String name) {
    long cPtr = helicsJNI.helicsCoreRegisterFilter(SWIGTYPE_p_void.getCPtr(core), type.swigValue(), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a cloning Filter on the specified core.<br>
   * <br>
   * Cloning filters copy a message and send it to multiple locations, source and destination can be added<br>
   *          through other functions.<br>
   * <br>
   * @param core The core to register through.<br>
   * @param name The name of the filter (can be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsFilter object.
   */
  public static SWIGTYPE_p_void helicsCoreRegisterCloningFilter(SWIGTYPE_p_void core, String name) {
    long cPtr = helicsJNI.helicsCoreRegisterCloningFilter(SWIGTYPE_p_void.getCPtr(core), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get the number of filters registered through a federate.<br>
   * <br>
   * @param fed The federate object to use to get the filter.<br>
   * <br>
   * @return A count of the number of filters registered through a federate.
   */
  public static int helicsFederateGetFilterCount(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateGetFilterCount(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Get a filter by its name, typically already created via registerInterfaces file or something of that nature.<br>
   * <br>
   * @param fed The federate object to use to get the filter.<br>
   * @param name The name of the filter.<br>
   * <br>
   * @param err The error object to complete if there is an error.<br>
   * <br>
   * <br>
   * @return A HelicsFilter object, the object will not be valid and err will contain an error code if no filter with the specified name<br>
   * exists.
   */
  public static SWIGTYPE_p_void helicsFederateGetFilter(SWIGTYPE_p_void fed, String name) {
    long cPtr = helicsJNI.helicsFederateGetFilter(SWIGTYPE_p_void.getCPtr(fed), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get a filter by its index, typically already created via registerInterfaces file or something of that nature.<br>
   * <br>
   * @param fed The federate object in which to create a publication.<br>
   * @param index The index of the publication to get.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsFilter, which will be NULL if an invalid index is given.
   */
  public static SWIGTYPE_p_void helicsFederateGetFilterByIndex(SWIGTYPE_p_void fed, int index) {
    long cPtr = helicsJNI.helicsFederateGetFilterByIndex(SWIGTYPE_p_void.getCPtr(fed), index);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Check if a filter is valid.<br>
   * <br>
   * @param filt The filter object to check.<br>
   * <br>
   * @return HELICS_TRUE if the Filter object represents a valid filter.
   */
  public static int helicsFilterIsValid(SWIGTYPE_p_void filt) {
    return helicsJNI.helicsFilterIsValid(SWIGTYPE_p_void.getCPtr(filt));
  }

  /**
   * Get the name of the filter and store in the given string.<br>
   * <br>
   * @param filt The given filter.<br>
   * <br>
   * @return A string with the name of the filter.
   */
  public static String helicsFilterGetName(SWIGTYPE_p_void filt) {
    return helicsJNI.helicsFilterGetName(SWIGTYPE_p_void.getCPtr(filt));
  }

  /**
   * Set a property on a filter.<br>
   * <br>
   * @param filt The filter to modify.<br>
   * @param prop A string containing the property to set.<br>
   * @param val A numerical value for the property.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFilterSet(SWIGTYPE_p_void filt, String prop, double val) {
    helicsJNI.helicsFilterSet(SWIGTYPE_p_void.getCPtr(filt), prop, val);
  }

  /**
   * Set a string property on a filter.<br>
   * <br>
   * @param filt The filter to modify.<br>
   * @param prop A string containing the property to set.<br>
   * @param val A string containing the new value.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFilterSetString(SWIGTYPE_p_void filt, String prop, String val) {
    helicsJNI.helicsFilterSetString(SWIGTYPE_p_void.getCPtr(filt), prop, val);
  }

  /**
   * Get a double property from a filter.<br>
   * <br>
   * @param filt The filter to retrieve a value from.<br>
   * @param prop A string containing the property to get.
   */
  public static double helicsFilterGetPropertyDouble(SWIGTYPE_p_void filt, String prop) {
    return helicsJNI.helicsFilterGetPropertyDouble(SWIGTYPE_p_void.getCPtr(filt), prop);
  }

  /**
   * Get a string property on a filter.  The string output memory is valid until a subsequent call to getPropertyString on the particular<br>
   * filter.<br>
   * <br>
   * @param filt The filter to retrieve a value from.<br>
   * @param prop A string containing the property to get.
   */
  public static String helicsFilterGetPropertyString(SWIGTYPE_p_void filt, String prop) {
    return helicsJNI.helicsFilterGetPropertyString(SWIGTYPE_p_void.getCPtr(filt), prop);
  }

  /**
   * Add a destination target to a filter.<br>
   * <br>
   * All messages going to a destination are copied to the delivery address(es).<br>
   * @param filt The given filter to add a destination target to.<br>
   * @param dst The name of the endpoint to add as a destination target.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFilterAddDestinationTarget(SWIGTYPE_p_void filt, String dst) {
    helicsJNI.helicsFilterAddDestinationTarget(SWIGTYPE_p_void.getCPtr(filt), dst);
  }

  /**
   * Add a source target to a filter.<br>
   * <br>
   * All messages coming from a source are copied to the delivery address(es).<br>
   * <br>
   * @param filt The given filter.<br>
   * @param source The name of the endpoint to add as a source target.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFilterAddSourceTarget(SWIGTYPE_p_void filt, String source) {
    helicsJNI.helicsFilterAddSourceTarget(SWIGTYPE_p_void.getCPtr(filt), source);
  }

  /**
   * Add a delivery endpoint to a cloning filter.<br>
   * <br>
   * All cloned messages are sent to the delivery address(es).<br>
   * <br>
   * @param filt The given filter.<br>
   * @param deliveryEndpoint The name of the endpoint to deliver messages to.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFilterAddDeliveryEndpoint(SWIGTYPE_p_void filt, String deliveryEndpoint) {
    helicsJNI.helicsFilterAddDeliveryEndpoint(SWIGTYPE_p_void.getCPtr(filt), deliveryEndpoint);
  }

  /**
   * Remove a destination target from a filter.<br>
   * <br>
   * @param filt The given filter.<br>
   * @param target The named endpoint to remove as a target.<br>
   * <br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFilterRemoveTarget(SWIGTYPE_p_void filt, String target) {
    helicsJNI.helicsFilterRemoveTarget(SWIGTYPE_p_void.getCPtr(filt), target);
  }

  /**
   * Remove a delivery destination from a cloning filter.<br>
   * <br>
   * @param filt The given filter (must be a cloning filter).<br>
   * @param deliveryEndpoint A string with the delivery endpoint to remove.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFilterRemoveDeliveryEndpoint(SWIGTYPE_p_void filt, String deliveryEndpoint) {
    helicsJNI.helicsFilterRemoveDeliveryEndpoint(SWIGTYPE_p_void.getCPtr(filt), deliveryEndpoint);
  }

  /**
   * Get the data in the info field of a filter.<br>
   * <br>
   * @param filt The given filter.<br>
   * <br>
   * @return A string with the info field string.
   */
  public static String helicsFilterGetInfo(SWIGTYPE_p_void filt) {
    return helicsJNI.helicsFilterGetInfo(SWIGTYPE_p_void.getCPtr(filt));
  }

  /**
   * Set the data in the info field for a filter.<br>
   * <br>
   * @param filt The given filter.<br>
   * @param info The string to set.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsFilterSetInfo(SWIGTYPE_p_void filt, String info) {
    helicsJNI.helicsFilterSetInfo(SWIGTYPE_p_void.getCPtr(filt), info);
  }

  /**
   * Get the data in a specified tag of a filter.<br>
   * <br>
   * @param filt The filter to query.<br>
   * @param tagname The name of the tag to query.<br>
   * @return A string with the tag data.
   */
  public static String helicsFilterGetTag(SWIGTYPE_p_void filt, String tagname) {
    return helicsJNI.helicsFilterGetTag(SWIGTYPE_p_void.getCPtr(filt), tagname);
  }

  /**
   * Set the data in a specific tag for a filter.<br>
   * <br>
   * @param filt The filter object to set the tag for.<br>
   * @param tagname The string to set.<br>
   * @param tagvalue the string value to associate with a tag.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsFilterSetTag(SWIGTYPE_p_void filt, String tagname, String tagvalue) {
    helicsJNI.helicsFilterSetTag(SWIGTYPE_p_void.getCPtr(filt), tagname, tagvalue);
  }

  /**
   * Set an option value for a filter.<br>
   * <br>
   * @param filt The given filter.<br>
   * @param option The option to set /ref helics_handle_options.<br>
   * @param value The value of the option commonly 0 for false 1 for true.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsFilterSetOption(SWIGTYPE_p_void filt, int option, int value) {
    helicsJNI.helicsFilterSetOption(SWIGTYPE_p_void.getCPtr(filt), option, value);
  }

  /**
   * Get a handle option for the filter.<br>
   * <br>
   * @param filt The given filter to query.<br>
   * @param option The option to query /ref helics_handle_options.
   */
  public static int helicsFilterGetOption(SWIGTYPE_p_void filt, int option) {
    return helicsJNI.helicsFilterGetOption(SWIGTYPE_p_void.getCPtr(filt), option);
  }

  /**
   * <br>
   * <br>
   * Create a Translator on the specified federate.<br>
   * <br>
   * Translators can be created through a federate or a core. Linking through a federate allows<br>
   *          a few extra features of name matching to function on the federate interface but otherwise have equivalent behavior.<br>
   * <br>
   * @param fed The federate to register through.<br>
   * @param type The type of translator to create /ref HelicsTranslatorTypes.<br>
   * @param name The name of the translator (can be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsTranslator object.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterTranslator(SWIGTYPE_p_void fed, HelicsTranslatorTypes type, String name) {
    long cPtr = helicsJNI.helicsFederateRegisterTranslator(SWIGTYPE_p_void.getCPtr(fed), type.swigValue(), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a global translator through a federate.<br>
   * <br>
   * Translators can be created through a federate or a core. Linking through a federate allows<br>
   *          a few extra features of name matching to function on the federate interface but otherwise have equivalent behavior.<br>
   * <br>
   * @param fed The federate to register through.<br>
   * @param type The type of translator to create /ref HelicsTranslatorTypes.<br>
   * @param name The name of the translator (can be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsTranslator object.
   */
  public static SWIGTYPE_p_void helicsFederateRegisterGlobalTranslator(SWIGTYPE_p_void fed, HelicsTranslatorTypes type, String name) {
    long cPtr = helicsJNI.helicsFederateRegisterGlobalTranslator(SWIGTYPE_p_void.getCPtr(fed), type.swigValue(), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Create a Translator on the specified core.<br>
   * <br>
   * Translators can be created through a federate or a core. Linking through a federate allows<br>
   *          a few extra features of name matching to function on the federate interface but otherwise have equivalent behavior.<br>
   * <br>
   * @param core The core to register through.<br>
   * @param type The type of translator to create /ref HelicsTranslatorTypes.<br>
   * @param name The name of the translator (can be NULL).<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsTranslator object.
   */
  public static SWIGTYPE_p_void helicsCoreRegisterTranslator(SWIGTYPE_p_void core, HelicsTranslatorTypes type, String name) {
    long cPtr = helicsJNI.helicsCoreRegisterTranslator(SWIGTYPE_p_void.getCPtr(core), type.swigValue(), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get the number of translators registered through a federate.<br>
   * <br>
   * @param fed The federate object to use to get the translator.<br>
   * <br>
   * @return A count of the number of translators registered through a federate.
   */
  public static int helicsFederateGetTranslatorCount(SWIGTYPE_p_void fed) {
    return helicsJNI.helicsFederateGetTranslatorCount(SWIGTYPE_p_void.getCPtr(fed));
  }

  /**
   * Get a translator by its name, typically already created via registerInterfaces file or something of that nature.<br>
   * <br>
   * @param fed The federate object to use to get the translator.<br>
   * @param name The name of the translator.<br>
   * <br>
   * @param err The error object to complete if there is an error.<br>
   * <br>
   * <br>
   * @return A HelicsTranslator object. If no translator with the specified name exists, the object will not be valid and<br>
   * err will contain an error code.
   */
  public static SWIGTYPE_p_void helicsFederateGetTranslator(SWIGTYPE_p_void fed, String name) {
    long cPtr = helicsJNI.helicsFederateGetTranslator(SWIGTYPE_p_void.getCPtr(fed), name);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Get a translator by its index, typically already created via registerInterfaces file or something of that nature.<br>
   * <br>
   * @param fed The federate object in which to create a publication.<br>
   * @param index The index of the translator to get.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.<br>
   * <br>
   * <br>
   * @return A HelicsTranslator, which will be NULL if an invalid index is given.
   */
  public static SWIGTYPE_p_void helicsFederateGetTranslatorByIndex(SWIGTYPE_p_void fed, int index) {
    long cPtr = helicsJNI.helicsFederateGetTranslatorByIndex(SWIGTYPE_p_void.getCPtr(fed), index);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  /**
   * Check if a translator is valid.<br>
   * <br>
   * @param trans The translator object to check.<br>
   * <br>
   * @return HELICS_TRUE if the Translator object represents a valid translator.
   */
  public static int helicsTranslatorIsValid(SWIGTYPE_p_void trans) {
    return helicsJNI.helicsTranslatorIsValid(SWIGTYPE_p_void.getCPtr(trans));
  }

  /**
   * Get the name of the translator and store in the given string.<br>
   * <br>
   * @param trans The given translator.<br>
   * <br>
   * @return A string with the name of the translator.
   */
  public static String helicsTranslatorGetName(SWIGTYPE_p_void trans) {
    return helicsJNI.helicsTranslatorGetName(SWIGTYPE_p_void.getCPtr(trans));
  }

  /**
   * Set a property on a translator.<br>
   * <br>
   * @param trans The translator to modify.<br>
   * @param prop A string containing the property to set.<br>
   * @param val A numerical value for the property.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsTranslatorSet(SWIGTYPE_p_void trans, String prop, double val) {
    helicsJNI.helicsTranslatorSet(SWIGTYPE_p_void.getCPtr(trans), prop, val);
  }

  /**
   * Set a string property on a translator.<br>
   * <br>
   * @param trans The translator to modify.<br>
   * @param prop A string containing the property to set.<br>
   * @param val A string containing the new value.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsTranslatorSetString(SWIGTYPE_p_void trans, String prop, String val) {
    helicsJNI.helicsTranslatorSetString(SWIGTYPE_p_void.getCPtr(trans), prop, val);
  }

  /**
   * Add an input to send a translator output.<br>
   * <br>
   * All messages sent to a translator endpoint get translated and published to the translators target inputs.<br>
   * This method adds an input to a translators which will receive translated messages.<br>
   * @param trans The given translator to add a destination target to.<br>
   * @param input The name of the input which will be receiving translated messages<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsTranslatorAddInputTarget(SWIGTYPE_p_void trans, String input) {
    helicsJNI.helicsTranslatorAddInputTarget(SWIGTYPE_p_void.getCPtr(trans), input);
  }

  /**
   * Add a source publication target to a translator.<br>
   * <br>
   * When a publication publishes data the translator will receive it and convert it to a message sent to a translators destination<br>
   *  endpoints.<br>
   * This method adds a publication which publishes data the translator receives and sends to its destination endpoints.<br>
   * <br>
   * @param trans The given translator.<br>
   * @param pub The name of the publication to subscribe.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsTranslatorAddPublicationTarget(SWIGTYPE_p_void trans, String pub) {
    helicsJNI.helicsTranslatorAddPublicationTarget(SWIGTYPE_p_void.getCPtr(trans), pub);
  }

  /**
   * Add a source endpoint target to a translator.<br>
   * <br>
   * The translator will "translate" all message sent to it.  This method adds an endpoint which can send the translator data.<br>
   * <br>
   * @param trans The given translator.<br>
   * @param ept The name of the endpoint which will send the endpoint data<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsTranslatorAddSourceEndpoint(SWIGTYPE_p_void trans, String ept) {
    helicsJNI.helicsTranslatorAddSourceEndpoint(SWIGTYPE_p_void.getCPtr(trans), ept);
  }

  /**
   * Add a destination target endpoint to a translator.<br>
   * <br>
   * The translator will "translate" all message sent to it.  This method adds an endpoint which will receive data published to the<br>
   *  translator.<br>
   * <br>
   * @param trans The given translator.<br>
   * @param ept The name of the endpoint the translator sends data to.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsTranslatorAddDestinationEndpoint(SWIGTYPE_p_void trans, String ept) {
    helicsJNI.helicsTranslatorAddDestinationEndpoint(SWIGTYPE_p_void.getCPtr(trans), ept);
  }

  /**
   * Remove a target from a translator.<br>
   * <br>
   * @param trans The given translator.<br>
   * @param target The name of the interface to remove as a target.<br>
   * <br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsTranslatorRemoveTarget(SWIGTYPE_p_void trans, String target) {
    helicsJNI.helicsTranslatorRemoveTarget(SWIGTYPE_p_void.getCPtr(trans), target);
  }

  /**
   * Get the data in the info field of a translator.<br>
   * <br>
   * @param trans The given translator.<br>
   * <br>
   * @return A string with the info field string.
   */
  public static String helicsTranslatorGetInfo(SWIGTYPE_p_void trans) {
    return helicsJNI.helicsTranslatorGetInfo(SWIGTYPE_p_void.getCPtr(trans));
  }

  /**
   * Set the data in the info field for a translator.<br>
   * <br>
   * @param trans The given translator.<br>
   * @param info The string to set.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsTranslatorSetInfo(SWIGTYPE_p_void trans, String info) {
    helicsJNI.helicsTranslatorSetInfo(SWIGTYPE_p_void.getCPtr(trans), info);
  }

  /**
   * Get the data in a specified tag of a translator.<br>
   * <br>
   * @param trans The translator to query.<br>
   * @param tagname The name of the tag to query.<br>
   * @return A string with the tag data.
   */
  public static String helicsTranslatorGetTag(SWIGTYPE_p_void trans, String tagname) {
    return helicsJNI.helicsTranslatorGetTag(SWIGTYPE_p_void.getCPtr(trans), tagname);
  }

  /**
   * Set the data in a specific tag for a translator.<br>
   * <br>
   * @param trans The translator object to set the tag for.<br>
   * @param tagname The string to set.<br>
   * @param tagvalue The string value to associate with a tag.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsTranslatorSetTag(SWIGTYPE_p_void trans, String tagname, String tagvalue) {
    helicsJNI.helicsTranslatorSetTag(SWIGTYPE_p_void.getCPtr(trans), tagname, tagvalue);
  }

  /**
   * Set an option value for a translator.<br>
   * <br>
   * @param trans The given translator.<br>
   * @param option The option to set /ref helics_handle_options.<br>
   * @param value The value of the option, commonly 0 for false or 1 for true.<br>
   * <br>
   * @param err An error object to fill out in case of an error.
   */
  public static void helicsTranslatorSetOption(SWIGTYPE_p_void trans, int option, int value) {
    helicsJNI.helicsTranslatorSetOption(SWIGTYPE_p_void.getCPtr(trans), option, value);
  }

  /**
   * Get a handle option for the translator.<br>
   * <br>
   * @param trans The given translator to query.<br>
   * @param option The option to query /ref helics_handle_options.
   */
  public static int helicsTranslatorGetOption(SWIGTYPE_p_void trans, int option) {
    return helicsJNI.helicsTranslatorGetOption(SWIGTYPE_p_void.getCPtr(trans), option);
  }

  /**
   * Set callback for the time request.<br>
   * <br>
   * This callback will be executed when a valid time request is made. It is intended for the possibility of embedded data grabbers<br>
   *  in a callback to simplify user code.<br>
   * <br>
   * @param fed The federate to set the callback for.<br>
   * @param requestTime A callback with signature void(HelicsTime currentTime, HelicsTime requestTime, bool iterating, void *userdata);<br>
   *                 The function arguments are the current time value, the requested time value, a bool indicating that the time is<br>
   *  iterating, and pointer to the userdata.<br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateSetTimeRequestEntryCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_double_double_int_p_void__void requestTime, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsFederateSetTimeRequestEntryCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_double_double_int_p_void__void.getCPtr(requestTime), SWIGTYPE_p_void.getCPtr(userdata));
  }

  /**
   * Set callback for the time update.<br>
   * <br>
   * This callback will be executed every time the simulation time is updated starting on entry to executing mode.<br>
   * <br>
   * @param fed The federate to set the callback for.<br>
   * @param timeUpdate A callback with signature void(HelicsTime newTime, bool iterating, void *userdata);<br>
   *                 The function arguments are the new time value, a bool indicating that the time is iterating, and pointer to the userdata.<br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateSetTimeUpdateCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_double_int_p_void__void timeUpdate, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsFederateSetTimeUpdateCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_double_int_p_void__void.getCPtr(timeUpdate), SWIGTYPE_p_void.getCPtr(userdata));
  }

  /**
   * Set callback for the federate mode change.<br>
   * <br>
   * This callback will be executed every time the operating mode of the federate changes.<br>
   * <br>
   * @param fed The federate to set the callback for.<br>
   * @param stateChange A callback with signature void(HelicsFederateState newState, HelicsFederateState oldState, void *userdata);<br>
   *                 The function arguments are the new state, the old state, and pointer to the userdata.<br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateSetStateChangeCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_enum_HelicsFederateState_enum_HelicsFederateState_p_void__void stateChange, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsFederateSetStateChangeCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_enum_HelicsFederateState_enum_HelicsFederateState_p_void__void.getCPtr(stateChange), SWIGTYPE_p_void.getCPtr(userdata));
  }

  /**
   * Set callback for the time request return.<br>
   * <br>
   * This callback will be executed after all other callbacks for a time request return.  This callback will be the last thing<br>
   *  executed before returning control to the user program.<br>
   * The difference between this and the TimeUpdate callback is the order of execution.  The timeUpdate callback is executed prior to<br>
   *  individual interface callbacks, this callback is executed after all others.<br>
   * @param fed The federate to set the callback for.<br>
   * @param requestTimeReturn A callback with signature void(HelicsTime newTime, bool iterating, void *userdata);<br>
   *                 The function arguments are the new time value, a bool indicating that the time is iterating, and pointer to the userdata.<br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateSetTimeRequestReturnCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_double_int_p_void__void requestTimeReturn, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsFederateSetTimeRequestReturnCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_double_int_p_void__void.getCPtr(requestTimeReturn), SWIGTYPE_p_void.getCPtr(userdata));
  }

  /**
   * Set callback for the entry to initializingMode.<br>
   * <br>
   * This callback will be executed when the initializingMode is entered<br>
   * <br>
   * @param fed The federate to set the callback for.<br>
   * @param initializingEntry A callback with signature void(HelicsBool iterating, void *userdata);<br>
   * the bool parameter is set to true if the entry is iterative, therefore the first time this is called the bool is false<br>
   * and all subsequent times it is true.<br>
   * <br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateInitializingEntryCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_int_p_void__void initializingEntry, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsFederateInitializingEntryCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_int_p_void__void.getCPtr(initializingEntry), SWIGTYPE_p_void.getCPtr(userdata));
  }

  /**
   * Set callback for the entry to ExecutingMode.<br>
   * <br>
   * This callback will be executed once on first entry to executingMode<br>
   * <br>
   * @param fed The federate to set the callback for.<br>
   * @param executingEntry A callback with signature void(void *userdata);<br>
   * <br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateExecutingEntryCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_p_void__void executingEntry, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsFederateExecutingEntryCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_p_void__void.getCPtr(executingEntry), SWIGTYPE_p_void.getCPtr(userdata));
  }

  /**
   * Set callback for cosimulation termination.<br>
   * <br>
   * This callback will be executed once when the time advancement of the federate/co-simulation has terminated.<br>
   * This may be called as part of the finalize operation, or when a maxTime signal is returned from requestTime or when an error is<br>
   * encountered.<br>
   * <br>
   * @param fed The federate to set the callback for.<br>
   * @param cosimTermination A callback with signature void(void *userdata);<br>
   * <br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateCosimulationTerminationCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_p_void__void cosimTermination, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsFederateCosimulationTerminationCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_p_void__void.getCPtr(cosimTermination), SWIGTYPE_p_void.getCPtr(userdata));
  }

  /**
   * Set callback for error handling.<br>
   * <br>
   * This callback will be called when a federate error is encountered.<br>
   * <br>
   * @param fed The federate to set the callback for.<br>
   * @param errorHandler A callback with signature void(int errorCode, const char *errorString, void *userdata);<br>
   * <br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsFederateErrorHandlerCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_int_p_q_const__char_p_void__void errorHandler, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsFederateErrorHandlerCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_int_p_q_const__char_p_void__void.getCPtr(errorHandler), SWIGTYPE_p_void.getCPtr(userdata));
  }

  /**
   * Set callback for the next time update.<br>
   * <br>
   * This callback will be triggered to compute the next time update for a callback federate.<br>
   * <br>
   * @param fed The federate to set the callback for.<br>
   * @param timeUpdate A callback with signature HelicsTime(HelicsTime time, void *userdata);<br>
   * <br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsCallbackFederateNextTimeCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_double_p_void__double timeUpdate, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsCallbackFederateNextTimeCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_double_p_void__double.getCPtr(timeUpdate), SWIGTYPE_p_void.getCPtr(userdata));
  }

  /**
   * Set callback for the next time update with iteration capability.<br>
   * <br>
   * This callback will be triggered to compute the next time update for a callback federate.<br>
   * <br>
   * @param fed The federate to set the callback for.<br>
   * @param timeUpdate A callback with signature HelicsTime(HelicsTime time, HelicsIterationResult result, HelicsIterationRequest* iteration,<br>
   * void *userdata);<br>
   * <br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsCallbackFederateNextTimeIterativeCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_double_enum_HelicsIterationResult_p_enum_HelicsIterationRequest_p_void__double timeUpdate, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsCallbackFederateNextTimeIterativeCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_double_enum_HelicsIterationResult_p_enum_HelicsIterationRequest_p_void__double.getCPtr(timeUpdate), SWIGTYPE_p_void.getCPtr(userdata));
  }

  /**
   * Set callback for initialization.<br>
   * <br>
   * This callback will be executed when computing whether to iterate in initialization mode.<br>
   * <br>
   * @param fed The federate to set the callback for.<br>
   * @param initialize A callback with signature HelicsIterationRequest(void *userdata);<br>
   * <br>
   * @param userdata A pointer to user data that is passed to the function when executing.<br>
   * <br>
   * @param err A pointer to an error object for catching errors.
   */
  public static void helicsCallbackFederateInitializeCallback(SWIGTYPE_p_void fed, SWIGTYPE_p_f_p_void__HelicsIterationRequest initialize, SWIGTYPE_p_void userdata) {
    helicsJNI.helicsCallbackFederateInitializeCallback(SWIGTYPE_p_void.getCPtr(fed), SWIGTYPE_p_f_p_void__HelicsIterationRequest.getCPtr(initialize), SWIGTYPE_p_void.getCPtr(userdata));
  }

}
