// Generated by gmmproc 2.77.0 -- DO NOT MODIFY!

// Needed before gtkmm/private/application_p.h is included.
typedef struct _GtkWindow GtkWindow;
 

#include <glibmm.h>

#include <gtkmm/application.h>
#include <gtkmm/private/application_p.h>


/* Copyright 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/vectorutils.h>

#include <gtk/gtk.h>
#include <gtkmm/window.h>
#include <glibmm/init.h>
#include <giomm/init.h>
#include <pangomm/wrap_init.h>
#include <gdkmm/wrap_init.h>
#include <gtkmm/wrap_init.h>
#include <locale>
#include <clocale>
#include <stdexcept>

namespace
{

static void init_gtkmm_internals()
{
  static bool init_done = false;

  if(!init_done)
  {
    Glib::init();
    Gio::init();

    // Populate the map of GTypes to C++ wrap_new() functions.
    Pango::wrap_init();
    Gdk::wrap_init();
    Gtk::wrap_init();

    // Shall gtk_init() set the global C locale to the user's preferred locale?
    if (!Glib::get_init_to_users_preferred_locale())
      gtk_disable_setlocale();

    init_done = true;
  }
}

// Make sure the C++ locale is the same as the C locale.
// The first call to Glib::init() fixes this. We repeat it here just to be sure.
// The application program may have changed the locale settings after
// the first call to Glib::init(). Unlikely, but possible.
static void set_cxx_locale_to_c_locale()
{
  try
  {
    // Make the C++ locale equal to the C locale.
    std::locale::global(std::locale(std::setlocale(LC_ALL, nullptr)));
  }
  catch (const std::runtime_error& ex)
  {
    g_warning("Can't make the global C++ locale equal to the C locale.\n"
      "   %s\n   C locale = %s\n", ex.what(), std::setlocale(LC_ALL, nullptr));
  }
}

} // anonymous namespace

namespace Gtk
{

const Glib::Class& Application::custom_class_init()
{
  init_gtkmm_internals();
  return application_class_.init();
}

Application::Application(const Glib::ustring& application_id, Gio::Application::Flags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  // GApplication complains about "" but allows nullptr, so we avoid passing "".
  Glib::ObjectBase(nullptr),
  Gio::Application(Glib::ConstructParams(custom_class_init(),
    "application_id", Glib::c_str_or_nullptr(application_id),
    "flags", static_cast<GApplicationFlags>(flags), nullptr))
{
  // gtk_init() is called by the 'startup' default signal handler when g_application_run() is called.
  // It's also called here, to make it possible for users of gtkmm to create
  // a window and other widgets before calling run(). (This is not recommended.)
  // See https://bugzilla.gnome.org/show_bug.cgi?id=639925
  gtk_init();
  set_cxx_locale_to_c_locale();
}

Glib::RefPtr<Application> Application::create(const Glib::ustring& application_id, Gio::Application::Flags flags)
{
  return Glib::RefPtr<Application>( new Application(application_id, flags) );
}

int Application::run(int argc, char** argv)
{
  return Gio::Application::run(argc, argv);
}

int Application::run()
{
  return Gio::Application::run(0, nullptr);
}

void Application::set_accel_for_action(const Glib::ustring& detailed_action_name, const Glib::ustring& accel)
{
  std::vector<Glib::ustring> vec;
  vec.push_back(accel);
  set_accels_for_action(detailed_action_name, vec);
}

void Application::unset_accels_for_action(const Glib::ustring& detailed_action_name)
{
  //gtk_application_set_accels_for_action() can take an empty array, but not NULL.
  //See https://bugzilla.gnome.org/show_bug.cgi?id=708905#c10
  std::vector<Glib::ustring> vec;
  set_accels_for_action(detailed_action_name, vec);
}

} // namespace Gtk

namespace
{


extern "C" {
static void Application_signal_window_added_connect_callback(GtkApplication* self, GtkWindow* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Window*)>;

  auto obj = dynamic_cast<Application*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}
} // extern "C"

static const Glib::SignalProxyInfo Application_signal_window_added_info =
{
  "window-added",
  (GCallback) &Application_signal_window_added_connect_callback,
  (GCallback) &Application_signal_window_added_connect_callback
};


using Application_signal_window_added_functype = void (*)(GtkApplication* self, GtkWindow* p0);
Application_signal_window_added_functype Application_signal_window_added_funcptr;
extern "C" {
static void Application_signal_window_added_default_callback(GtkApplication* self, GtkWindow* p0)
{
  Application_signal_window_added_funcptr( self, p0);
}
} // extern "C"


extern "C" {
static void Application_signal_window_removed_connect_callback(GtkApplication* self, GtkWindow* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Window*)>;

  auto obj = dynamic_cast<Application*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}
} // extern "C"

static const Glib::SignalProxyInfo Application_signal_window_removed_info =
{
  "window-removed",
  (GCallback) &Application_signal_window_removed_connect_callback,
  (GCallback) &Application_signal_window_removed_connect_callback
};


using Application_signal_window_removed_functype = void (*)(GtkApplication* self, GtkWindow* p0);
Application_signal_window_removed_functype Application_signal_window_removed_funcptr;
extern "C" {
static void Application_signal_window_removed_default_callback(GtkApplication* self, GtkWindow* p0)
{
  Application_signal_window_removed_funcptr( self, p0);
}
} // extern "C"


static const Glib::SignalProxyInfo Application_signal_query_end_info =
{
  "query-end",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gtk::Application::InhibitFlags>::value_type()
{
  return gtk_application_inhibit_flags_get_type();
}


namespace Glib
{

Glib::RefPtr<Gtk::Application> wrap(GtkApplication* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gtk::Application>( dynamic_cast<Gtk::Application*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Application_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Application_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_application_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Application_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->window_added = &Application_signal_window_added_default_callback;
  Application_signal_window_added_funcptr = &window_added_callback;
  klass->window_removed = &Application_signal_window_removed_default_callback;
  Application_signal_window_removed_funcptr = &window_removed_callback;
}


void Application_Class::window_added_callback(GtkApplication* self, GtkWindow* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_window_added(Glib::wrap(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_added)
    (*base->window_added)(self, p0);
}
void Application_Class::window_removed_callback(GtkApplication* self, GtkWindow* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_window_removed(Glib::wrap(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_removed)
    (*base->window_removed)(self, p0);
}


Glib::ObjectBase* Application_Class::wrap_new(GObject* object)
{
  return new Application((GtkApplication*)object);
}


/* The implementation: */

GtkApplication* Application::gobj_copy()
{
  reference();
  return gobj();
}

Application::Application(const Glib::ConstructParams& construct_params)
:
  Gio::Application(construct_params)
{

}

Application::Application(GtkApplication* castitem)
:
  Gio::Application((GApplication*)(castitem))
{}


Application::Application(Application&& src) noexcept
: Gio::Application(std::move(src))
{}

Application& Application::operator=(Application&& src) noexcept
{
  Gio::Application::operator=(std::move(src));
  return *this;
}


Application::~Application() noexcept
{}


Application::CppClassType Application::application_class_; // initialize static member

GType Application::get_type()
{
  return application_class_.init().get_type();
}


GType Application::get_base_type()
{
  return gtk_application_get_type();
}


std::vector<Window*> Application::get_windows()
{
  return Glib::ListHandler<Window*>::list_to_vector(gtk_application_get_windows(gobj()), Glib::OWNERSHIP_NONE);
}

std::vector<const Window*> Application::get_windows() const
{
  return Glib::ListHandler<const Window*>::list_to_vector(gtk_application_get_windows(const_cast<GtkApplication*>(gobj())), Glib::OWNERSHIP_NONE);
}

void Application::add_window(Window& window)
{
  gtk_application_add_window(gobj(), (window).gobj());
}

void Application::remove_window(Window& window)
{
  gtk_application_remove_window(gobj(), (window).gobj());
}

Glib::RefPtr<Gio::MenuModel> Application::get_menubar()
{
  auto retvalue = Glib::wrap(gtk_application_get_menubar(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gio::MenuModel> Application::get_menubar() const
{
  return const_cast<Application*>(this)->get_menubar();
}

void Application::set_menubar(const Glib::RefPtr<Gio::MenuModel>& menubar)
{
  gtk_application_set_menubar(gobj(), Glib::unwrap(menubar));
}

guint Application::inhibit(Window& window, InhibitFlags flags, const Glib::ustring& reason)
{
  return gtk_application_inhibit(gobj(), (window).gobj(), static_cast<GtkApplicationInhibitFlags>(flags), reason.c_str());
}

void Application::uninhibit(guint cookie)
{
  gtk_application_uninhibit(gobj(), cookie);
}

Window* Application::get_window_by_id(guint id)
{
  auto retvalue = Glib::wrap(gtk_application_get_window_by_id(gobj(), id));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

const Window* Application::get_window_by_id(guint id) const
{
  return const_cast<Application*>(this)->get_window_by_id(id);
}

Window* Application::get_active_window()
{
  auto retvalue = Glib::wrap(gtk_application_get_active_window(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

const Window* Application::get_active_window() const
{
  return const_cast<Application*>(this)->get_active_window();
}

std::vector<Glib::ustring> Application::list_action_descriptions() const
{
  return Glib::ArrayHandler<Glib::ustring>::array_to_vector(gtk_application_list_action_descriptions(const_cast<GtkApplication*>(gobj())), Glib::OWNERSHIP_DEEP);
}

std::vector<Glib::ustring> Application::get_accels_for_action(const Glib::ustring& detailed_action_name) const
{
  return Glib::ArrayHandler<Glib::ustring>::array_to_vector(gtk_application_get_accels_for_action(const_cast<GtkApplication*>(gobj()), detailed_action_name.c_str()), Glib::OWNERSHIP_DEEP);
}

std::vector<Glib::ustring> Application::get_actions_for_accel(const Glib::ustring& accel) const
{
  return Glib::ArrayHandler<Glib::ustring>::array_to_vector(gtk_application_get_actions_for_accel(const_cast<GtkApplication*>(gobj()), accel.c_str()), Glib::OWNERSHIP_DEEP);
}

void Application::set_accels_for_action(const Glib::ustring& detailed_action_name, const std::vector<Glib::ustring>& accels)
{
  gtk_application_set_accels_for_action(gobj(), detailed_action_name.c_str(), Glib::ArrayHandler<Glib::ustring>::vector_to_array(accels).data ());
}

Glib::RefPtr<Gio::Menu> Application::get_menu_by_id(const Glib::ustring& id)
{
  auto retvalue = Glib::wrap(gtk_application_get_menu_by_id(gobj(), id.c_str()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gio::Menu> Application::get_menu_by_id(const Glib::ustring& id) const
{
  return const_cast<Application*>(this)->get_menu_by_id(id);
}


Glib::SignalProxy<void(Window*)> Application::signal_window_added()
{
  return Glib::SignalProxy<void(Window*) >(this, &Application_signal_window_added_info);
}


Glib::SignalProxy<void(Window*)> Application::signal_window_removed()
{
  return Glib::SignalProxy<void(Window*) >(this, &Application_signal_window_removed_info);
}


Glib::SignalProxy<void()> Application::signal_query_end()
{
  return Glib::SignalProxy<void() >(this, &Application_signal_query_end_info);
}


static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Gio::MenuModel>>::value,
  "Type Glib::RefPtr<Gio::MenuModel> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> > Application::property_menubar() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> >(this, "menubar");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> > Application::property_menubar() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> >(this, "menubar");
}

Glib::PropertyProxy< bool > Application::property_register_session() 
{
  return Glib::PropertyProxy< bool >(this, "register-session");
}

Glib::PropertyProxy_ReadOnly< bool > Application::property_register_session() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "register-session");
}

Glib::PropertyProxy_ReadOnly< bool > Application::property_screensaver_active() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "screensaver-active");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Window*>::value,
  "Type Window* cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Window* > Application::property_active_window() const
{
  return Glib::PropertyProxy_ReadOnly< Window* >(this, "active-window");
}


void Gtk::Application::on_window_added(Window* window)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_added)
    (*base->window_added)(gobj(),(GtkWindow*)Glib::unwrap(window));
}
void Gtk::Application::on_window_removed(Window* window)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_removed)
    (*base->window_removed)(gobj(),(GtkWindow*)Glib::unwrap(window));
}


} // namespace Gtk


