#![allow(
    non_snake_case,
    non_upper_case_globals,
    non_camel_case_types,
    dead_code,
    clippy::all
)]

pub mod Windows {
    pub mod Foundation {
        windows_core::imp::define_interface!(
            IClosable,
            IClosable_Vtbl,
            0x30d5a829_7fa4_4026_83bb_d75bae4ea99e
        );
        impl windows_core::RuntimeType for IClosable {
            const SIGNATURE: windows_core::imp::ConstBuffer =
                windows_core::imp::ConstBuffer::for_interface::<Self>();
        }
        windows_core::imp::interface_hierarchy!(
            IClosable,
            windows_core::IUnknown,
            windows_core::IInspectable
        );
        impl IClosable {
            pub fn Close(&self) -> windows_core::Result<()> {
                let this = self;
                unsafe {
                    (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(
                        this,
                    ))
                    .ok()
                }
            }
        }
        impl windows_core::RuntimeName for IClosable {
            const NAME: &'static str = "Windows.Foundation.IClosable";
        }
        pub trait IClosable_Impl: windows_core::IUnknownImpl {
            fn Close(&self) -> windows_core::Result<()>;
        }
        impl IClosable_Vtbl {
            pub const fn new<Identity: IClosable_Impl, const OFFSET: isize>() -> Self {
                unsafe extern "system" fn Close<Identity: IClosable_Impl, const OFFSET: isize>(
                    this: *mut core::ffi::c_void,
                ) -> windows_core::HRESULT {
                    unsafe {
                        let this: &Identity =
                            &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                        IClosable_Impl::Close(this).into()
                    }
                }
                Self {
                    base__: windows_core::IInspectable_Vtbl::new::<Identity, IClosable, OFFSET>(),
                    Close: Close::<Identity, OFFSET>,
                }
            }
            pub fn matches(iid: &windows_core::GUID) -> bool {
                iid == &<IClosable as windows_core::Interface>::IID
            }
        }
        #[repr(C)]
        #[doc(hidden)]
        pub struct IClosable_Vtbl {
            pub base__: windows_core::IInspectable_Vtbl,
            pub Close: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
        }
        windows_core::imp::define_interface!(
            IMemoryBufferReference,
            IMemoryBufferReference_Vtbl,
            0xfbc4dd29_245b_11e4_af98_689423260cf8
        );
        impl windows_core::RuntimeType for IMemoryBufferReference {
            const SIGNATURE: windows_core::imp::ConstBuffer =
                windows_core::imp::ConstBuffer::for_interface::<Self>();
        }
        windows_core::imp::interface_hierarchy!(
            IMemoryBufferReference,
            windows_core::IUnknown,
            windows_core::IInspectable
        );
        windows_core::imp::required_hierarchy!(IMemoryBufferReference, IClosable);
        impl IMemoryBufferReference {
            pub fn Capacity(&self) -> windows_core::Result<u32> {
                let this = self;
                unsafe {
                    let mut result__ = core::mem::zeroed();
                    (windows_core::Interface::vtable(this).Capacity)(
                        windows_core::Interface::as_raw(this),
                        &mut result__,
                    )
                    .map(|| result__)
                }
            }
            pub fn RemoveClosed(&self, cookie: i64) -> windows_core::Result<()> {
                let this = self;
                unsafe {
                    (windows_core::Interface::vtable(this).RemoveClosed)(
                        windows_core::Interface::as_raw(this),
                        cookie,
                    )
                    .ok()
                }
            }
            pub fn Close(&self) -> windows_core::Result<()> {
                let this = &windows_core::Interface::cast::<IClosable>(self)?;
                unsafe {
                    (windows_core::Interface::vtable(this).Close)(windows_core::Interface::as_raw(
                        this,
                    ))
                    .ok()
                }
            }
        }
        impl windows_core::RuntimeName for IMemoryBufferReference {
            const NAME: &'static str = "Windows.Foundation.IMemoryBufferReference";
        }
        pub trait IMemoryBufferReference_Impl: IClosable_Impl {
            fn Capacity(&self) -> windows_core::Result<u32>;
            fn RemoveClosed(&self, cookie: i64) -> windows_core::Result<()>;
        }
        impl IMemoryBufferReference_Vtbl {
            pub const fn new<Identity: IMemoryBufferReference_Impl, const OFFSET: isize>() -> Self {
                unsafe extern "system" fn Capacity<
                    Identity: IMemoryBufferReference_Impl,
                    const OFFSET: isize,
                >(
                    this: *mut core::ffi::c_void,
                    result__: *mut u32,
                ) -> windows_core::HRESULT {
                    unsafe {
                        let this: &Identity =
                            &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                        match IMemoryBufferReference_Impl::Capacity(this) {
                            Ok(ok__) => {
                                result__.write(core::mem::transmute_copy(&ok__));
                                windows_core::HRESULT(0)
                            }
                            Err(err) => err.into(),
                        }
                    }
                }
                unsafe extern "system" fn RemoveClosed<
                    Identity: IMemoryBufferReference_Impl,
                    const OFFSET: isize,
                >(
                    this: *mut core::ffi::c_void,
                    cookie: i64,
                ) -> windows_core::HRESULT {
                    unsafe {
                        let this: &Identity =
                            &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                        IMemoryBufferReference_Impl::RemoveClosed(this, cookie).into()
                    }
                }
                Self {
                    base__: windows_core::IInspectable_Vtbl::new::<
                        Identity,
                        IMemoryBufferReference,
                        OFFSET,
                    >(),
                    Capacity: Capacity::<Identity, OFFSET>,
                    Closed: 0,
                    RemoveClosed: RemoveClosed::<Identity, OFFSET>,
                }
            }
            pub fn matches(iid: &windows_core::GUID) -> bool {
                iid == &<IMemoryBufferReference as windows_core::Interface>::IID
            }
        }
        #[repr(C)]
        #[doc(hidden)]
        pub struct IMemoryBufferReference_Vtbl {
            pub base__: windows_core::IInspectable_Vtbl,
            pub Capacity: unsafe extern "system" fn(
                *mut core::ffi::c_void,
                *mut u32,
            ) -> windows_core::HRESULT,
            Closed: usize,
            pub RemoveClosed:
                unsafe extern "system" fn(*mut core::ffi::c_void, i64) -> windows_core::HRESULT,
        }
    }
}
