/** 
 @file callbacks.c
 @brief ENet callback functions
*/
#define ENET_BUILDING_LIB 1
#include "enet/enet.h"

static ENetCallbacks callbacks = {malloc, free, abort};

int enet_initialize_with_callbacks(ENetVersion version, const ENetCallbacks* inits)
{
	if (version < ENET_VERSION_CREATE(1, 3, 0))
		return -1;

	if (inits->malloc != NULL || inits->free != NULL)
	{
		if (inits->malloc == NULL || inits->free == NULL)
			return -1;

		callbacks.malloc = inits->malloc;
		callbacks.free = inits->free;
	}

	if (inits->no_memory != NULL)
		callbacks.no_memory = inits->no_memory;

	return enet_initialize();
}

void* enet_malloc(size_t size)
{
	void* memory = callbacks.malloc(size);

	if (memory == NULL)
		callbacks.no_memory();

	return memory;
}

void enet_free(void* memory)
{
	callbacks.free(memory);
}
