/*******************************************************************************
 * Copyright 2009-2023 Jörg Müller
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

#include "respec/JOSResampleReader.h"

// sinc filter coefficients, Nz = 16, L = 128, freq = 0.834068, Kaiser Window B = 10

AUD_NAMESPACE_BEGIN

const int JOSResampleReader::m_len_low = 2455;
const int JOSResampleReader::m_L_low = 128;

const float JOSResampleReader::m_coeff_low[m_len_low + 1] = {
8.340675360e-01f, 8.340086260e-01f, 8.338319113e-01f, 8.335374374e-01f, 8.331252804e-01f, 8.325955465e-01f, 8.319483724e-01f, 8.311839250e-01f, 8.303024016e-01f, 8.293040294e-01f, 
8.281890659e-01f, 8.269577985e-01f, 8.256105446e-01f, 8.241476514e-01f, 8.225694958e-01f, 8.208764844e-01f, 8.190690531e-01f, 8.171476673e-01f, 8.151128215e-01f, 8.129650394e-01f, 
8.107048733e-01f, 8.083329044e-01f, 8.058497425e-01f, 8.032560255e-01f, 8.005524197e-01f, 7.977396190e-01f, 7.948183455e-01f, 7.917893483e-01f, 7.886534040e-01f, 7.854113162e-01f, 
7.820639153e-01f, 7.786120581e-01f, 7.750566278e-01f, 7.713985334e-01f, 7.676387098e-01f, 7.637781170e-01f, 7.598177404e-01f, 7.557585901e-01f, 7.516017006e-01f, 7.473481306e-01f, 
7.429989628e-01f, 7.385553031e-01f, 7.340182809e-01f, 7.293890482e-01f, 7.246687795e-01f, 7.198586714e-01f, 7.149599422e-01f, 7.099738317e-01f, 7.049016004e-01f, 6.997445297e-01f, 
6.945039210e-01f, 6.891810954e-01f, 6.837773936e-01f, 6.782941751e-01f, 6.727328182e-01f, 6.670947189e-01f, 6.613812914e-01f, 6.555939668e-01f, 6.497341931e-01f, 6.438034349e-01f, 
6.378031726e-01f, 6.317349019e-01f, 6.256001340e-01f, 6.194003941e-01f, 6.131372220e-01f, 6.068121709e-01f, 6.004268072e-01f, 5.939827100e-01f, 5.874814706e-01f, 5.809246921e-01f, 
5.743139887e-01f, 5.676509855e-01f, 5.609373179e-01f, 5.541746308e-01f, 5.473645787e-01f, 5.405088246e-01f, 5.336090401e-01f, 5.266669041e-01f, 5.196841033e-01f, 5.126623308e-01f, 
5.056032861e-01f, 4.985086742e-01f, 4.913802058e-01f, 4.842195959e-01f, 4.770285640e-01f, 4.698088330e-01f, 4.625621292e-01f, 4.552901816e-01f, 4.479947212e-01f, 4.406774808e-01f, 
4.333401942e-01f, 4.259845960e-01f, 4.186124207e-01f, 4.112254026e-01f, 4.038252749e-01f, 3.964137695e-01f, 3.889926163e-01f, 3.815635430e-01f, 3.741282740e-01f, 3.666885305e-01f, 
3.592460298e-01f, 3.518024845e-01f, 3.443596025e-01f, 3.369190863e-01f, 3.294826322e-01f, 3.220519305e-01f, 3.146286642e-01f, 3.072145092e-01f, 2.998111334e-01f, 2.924201965e-01f, 
2.850433492e-01f, 2.776822332e-01f, 2.703384802e-01f, 2.630137118e-01f, 2.557095391e-01f, 2.484275618e-01f, 2.411693682e-01f, 2.339365347e-01f, 2.267306252e-01f, 2.195531905e-01f, 
2.124057684e-01f, 2.052898829e-01f, 1.982070438e-01f, 1.911587464e-01f, 1.841464709e-01f, 1.771716824e-01f, 1.702358299e-01f, 1.633403466e-01f, 1.564866489e-01f, 1.496761364e-01f, 
1.429101914e-01f, 1.361901786e-01f, 1.295174446e-01f, 1.228933176e-01f, 1.163191072e-01f, 1.097961040e-01f, 1.033255791e-01f, 9.690878384e-02f, 9.054694972e-02f, 8.424128778e-02f, 
7.799298847e-02f, 7.180322128e-02f, 6.567313448e-02f, 5.960385485e-02f, 5.359648739e-02f, 4.765211504e-02f, 4.177179845e-02f, 3.595657571e-02f, 3.020746213e-02f, 2.452544995e-02f, 
1.891150820e-02f, 1.336658241e-02f, 7.891594418e-03f, 2.487442186e-03f, -2.845000411e-03f, -8.104883769e-03f, -1.329138273e-02f, -1.840369674e-02f, -2.344105004e-02f, -2.840269178e-02f, 
-3.328789619e-02f, -3.809596272e-02f, -4.282621612e-02f, -4.747800662e-02f, -5.205071001e-02f, -5.654372772e-02f, -6.095648694e-02f, -6.528844073e-02f, -6.953906802e-02f, -7.370787373e-02f, 
-7.779438884e-02f, -8.179817038e-02f, -8.571880154e-02f, -8.955589165e-02f, -9.330907621e-02f, -9.697801694e-02f, -1.005624018e-01f, -1.040619447e-01f, -1.074763862e-01f, -1.108054927e-01f, 
-1.140490566e-01f, -1.172068969e-01f, -1.202788582e-01f, -1.232648112e-01f, -1.261646528e-01f, -1.289783055e-01f, -1.317057177e-01f, -1.343468635e-01f, -1.369017425e-01f, -1.393703800e-01f, 
-1.417528266e-01f, -1.440491581e-01f, -1.462594757e-01f, -1.483839054e-01f, -1.504225980e-01f, -1.523757294e-01f, -1.542434996e-01f, -1.560261333e-01f, -1.577238794e-01f, -1.593370108e-01f, 
-1.608658242e-01f, -1.623106400e-01f, -1.636718021e-01f, -1.649496777e-01f, -1.661446569e-01f, -1.672571527e-01f, -1.682876007e-01f, -1.692364587e-01f, -1.701042067e-01f, -1.708913467e-01f, 
-1.715984020e-01f, -1.722259174e-01f, -1.727744588e-01f, -1.732446127e-01f, -1.736369864e-01f, -1.739522071e-01f, -1.741909221e-01f, -1.743537984e-01f, -1.744415220e-01f, -1.744547983e-01f, 
-1.743943513e-01f, -1.742609231e-01f, -1.740552741e-01f, -1.737781826e-01f, -1.734304438e-01f, -1.730128704e-01f, -1.725262917e-01f, -1.719715531e-01f, -1.713495164e-01f, -1.706610587e-01f, 
-1.699070727e-01f, -1.690884657e-01f, -1.682061600e-01f, -1.672610916e-01f, -1.662542107e-01f, -1.651864808e-01f, -1.640588783e-01f, -1.628723926e-01f, -1.616280250e-01f, -1.603267891e-01f, 
-1.589697097e-01f, -1.575578229e-01f, -1.560921753e-01f, -1.545738241e-01f, -1.530038362e-01f, -1.513832882e-01f, -1.497132655e-01f, -1.479948625e-01f, -1.462291818e-01f, -1.444173339e-01f, 
-1.425604367e-01f, -1.406596153e-01f, -1.387160013e-01f, -1.367307328e-01f, -1.347049534e-01f, -1.326398125e-01f, -1.305364641e-01f, -1.283960672e-01f, -1.262197847e-01f, -1.240087834e-01f, 
-1.217642334e-01f, -1.194873077e-01f, -1.171791822e-01f, -1.148410344e-01f, -1.124740438e-01f, -1.100793913e-01f, -1.076582586e-01f, -1.052118278e-01f, -1.027412812e-01f, -1.002478010e-01f, 
-9.773256819e-02f, -9.519676317e-02f, -9.264156458e-02f, -9.006814922e-02f, -8.747769162e-02f, -8.487136363e-02f, -8.225033404e-02f, -7.961576821e-02f, -7.696882766e-02f, -7.431066972e-02f, 
-7.164244715e-02f, -6.896530775e-02f, -6.628039401e-02f, -6.358884275e-02f, -6.089178474e-02f, -5.819034435e-02f, -5.548563919e-02f, -5.277877979e-02f, -5.007086921e-02f, -4.736300275e-02f, 
-4.465626755e-02f, -4.195174230e-02f, -3.925049692e-02f, -3.655359221e-02f, -3.386207952e-02f, -3.117700047e-02f, -2.849938664e-02f, -2.583025921e-02f, -2.317062874e-02f, -2.052149482e-02f, 
-1.788384579e-02f, -1.525865848e-02f, -1.264689789e-02f, -1.004951695e-02f, -7.467456264e-03f, -4.901643800e-03f, -2.352994671e-03f, 1.775891258e-04f, 2.689218953e-03f, 5.181019775e-03f, 
7.652130387e-03f, 1.010170364e-02f, 1.252890668e-02f, 1.493292112e-02f, 1.731294330e-02f, 1.966818445e-02f, 2.199787092e-02f, 2.430124433e-02f, 2.657756179e-02f, 2.882609604e-02f, 
3.104613567e-02f, 3.323698523e-02f, 3.539796542e-02f, 3.752841324e-02f, 3.962768211e-02f, 4.169514205e-02f, 4.373017976e-02f, 4.573219878e-02f, 4.770061960e-02f, 4.963487977e-02f, 
5.153443398e-02f, 5.339875422e-02f, 5.522732978e-02f, 5.701966743e-02f, 5.877529142e-02f, 6.049374359e-02f, 6.217458343e-02f, 6.381738813e-02f, 6.542175263e-02f, 6.698728967e-02f, 
6.851362982e-02f, 7.000042150e-02f, 7.144733103e-02f, 7.285404264e-02f, 7.422025846e-02f, 7.554569853e-02f, 7.683010081e-02f, 7.807322118e-02f, 7.927483339e-02f, 8.043472904e-02f, 
8.155271759e-02f, 8.262862630e-02f, 8.366230017e-02f, 8.465360192e-02f, 8.560241191e-02f, 8.650862813e-02f, 8.737216606e-02f, 8.819295865e-02f, 8.897095621e-02f, 8.970612636e-02f, 
9.039845391e-02f, 9.104794075e-02f, 9.165460580e-02f, 9.221848484e-02f, 9.273963044e-02f, 9.321811182e-02f, 9.365401471e-02f, 9.404744127e-02f, 9.439850988e-02f, 9.470735506e-02f, 
9.497412730e-02f, 9.519899289e-02f, 9.538213378e-02f, 9.552374743e-02f, 9.562404661e-02f, 9.568325925e-02f, 9.570162826e-02f, 9.567941134e-02f, 9.561688078e-02f, 9.551432332e-02f, 
9.537203988e-02f, 9.519034542e-02f, 9.496956871e-02f, 9.471005212e-02f, 9.441215142e-02f, 9.407623554e-02f, 9.370268637e-02f, 9.329189854e-02f, 9.284427915e-02f, 9.236024760e-02f, 
9.184023532e-02f, 9.128468551e-02f, 9.069405295e-02f, 9.006880371e-02f, 8.940941493e-02f, 8.871637454e-02f, 8.799018106e-02f, 8.723134327e-02f, 8.644038002e-02f, 8.561781990e-02f, 
8.476420106e-02f, 8.388007085e-02f, 8.296598562e-02f, 8.202251044e-02f, 8.105021879e-02f, 8.004969233e-02f, 7.902152059e-02f, 7.796630071e-02f, 7.688463715e-02f, 7.577714145e-02f, 
7.464443188e-02f, 7.348713320e-02f, 7.230587637e-02f, 7.110129827e-02f, 6.987404141e-02f, 6.862475362e-02f, 6.735408781e-02f, 6.606270164e-02f, 6.475125724e-02f, 6.342042097e-02f, 
6.207086305e-02f, 6.070325734e-02f, 5.931828101e-02f, 5.791661428e-02f, 5.649894012e-02f, 5.506594396e-02f, 5.361831341e-02f, 5.215673796e-02f, 5.068190873e-02f, 4.919451813e-02f, 
4.769525964e-02f, 4.618482747e-02f, 4.466391632e-02f, 4.313322107e-02f, 4.159343654e-02f, 4.004525715e-02f, 3.848937674e-02f, 3.692648818e-02f, 3.535728319e-02f, 3.378245204e-02f, 
3.220268326e-02f, 3.061866340e-02f, 2.903107678e-02f, 2.744060518e-02f, 2.584792761e-02f, 2.425372007e-02f, 2.265865525e-02f, 2.106340233e-02f, 1.946862670e-02f, 1.787498970e-02f, 
1.628314842e-02f, 1.469375542e-02f, 1.310745851e-02f, 1.152490053e-02f, 9.946719066e-03f, 8.373546295e-03f, 6.806008703e-03f, 5.244726891e-03f, 3.690315348e-03f, 2.143382242e-03f, 
6.045292037e-04f, -9.256488754e-04f, -2.446564049e-03f, -3.957635514e-03f, -5.458289806e-03f, -6.947960994e-03f, -8.426090862e-03f, -9.892129097e-03f, -1.134553347e-02f, -1.278577000e-02f, 
-1.421231315e-02f, -1.562464596e-02f, -1.702226024e-02f, -1.840465671e-02f, -1.977134515e-02f, -2.112184458e-02f, -2.245568338e-02f, -2.377239941e-02f, -2.507154019e-02f, -2.635266303e-02f, 
-2.761533509e-02f, -2.885913361e-02f, -3.008364591e-02f, -3.128846961e-02f, -3.247321267e-02f, -3.363749351e-02f, -3.478094111e-02f, -3.590319513e-02f, -3.700390594e-02f, -3.808273477e-02f, 
-3.913935375e-02f, -4.017344600e-02f, -4.118470568e-02f, -4.217283808e-02f, -4.313755969e-02f, -4.407859821e-02f, -4.499569263e-02f, -4.588859329e-02f, -4.675706190e-02f, -4.760087157e-02f, 
-4.841980688e-02f, -4.921366385e-02f, -4.998225002e-02f, -5.072538441e-02f, -5.144289759e-02f, -5.213463166e-02f, -5.280044024e-02f, -5.344018849e-02f, -5.405375310e-02f, -5.464102226e-02f, 
-5.520189569e-02f, -5.573628457e-02f, -5.624411154e-02f, -5.672531067e-02f, -5.717982742e-02f, -5.760761861e-02f, -5.800865239e-02f, -5.838290814e-02f, -5.873037650e-02f, -5.905105923e-02f, 
-5.934496922e-02f, -5.961213039e-02f, -5.985257762e-02f, -6.006635671e-02f, -6.025352426e-02f, -6.041414762e-02f, -6.054830480e-02f, -6.065608438e-02f, -6.073758540e-02f, -6.079291731e-02f, 
-6.082219983e-02f, -6.082556284e-02f, -6.080314633e-02f, -6.075510022e-02f, -6.068158430e-02f, -6.058276808e-02f, -6.045883067e-02f, -6.030996070e-02f, -6.013635612e-02f, -5.993822414e-02f, 
-5.971578105e-02f, -5.946925209e-02f, -5.919887134e-02f, -5.890488155e-02f, -5.858753399e-02f, -5.824708832e-02f, -5.788381245e-02f, -5.749798234e-02f, -5.708988189e-02f, -5.665980276e-02f, 
-5.620804421e-02f, -5.573491296e-02f, -5.524072299e-02f, -5.472579539e-02f, -5.419045818e-02f, -5.363504618e-02f, -5.305990075e-02f, -5.246536973e-02f, -5.185180715e-02f, -5.121957313e-02f, 
-5.056903367e-02f, -4.990056046e-02f, -4.921453072e-02f, -4.851132699e-02f, -4.779133696e-02f, -4.705495329e-02f, -4.630257340e-02f, -4.553459930e-02f, -4.475143739e-02f, -4.395349825e-02f, 
-4.314119650e-02f, -4.231495057e-02f, -4.147518249e-02f, -4.062231775e-02f, -3.975678505e-02f, -3.887901616e-02f, -3.798944566e-02f, -3.708851081e-02f, -3.617665132e-02f, -3.525430915e-02f, 
-3.432192833e-02f, -3.337995477e-02f, -3.242883605e-02f, -3.146902123e-02f, -3.050096066e-02f, -2.952510577e-02f, -2.854190892e-02f, -2.755182314e-02f, -2.655530202e-02f, -2.555279943e-02f, 
-2.454476939e-02f, -2.353166588e-02f, -2.251394262e-02f, -2.149205290e-02f, -2.046644940e-02f, -1.943758397e-02f, -1.840590751e-02f, -1.737186972e-02f, -1.633591896e-02f, -1.529850207e-02f, 
-1.426006415e-02f, -1.322104844e-02f, -1.218189612e-02f, -1.114304610e-02f, -1.010493492e-02f, -9.067996527e-03f, -8.032662132e-03f, -6.999360026e-03f, -5.968515431e-03f, -4.940550333e-03f, 
-3.915883321e-03f, -2.894929432e-03f, -1.878099995e-03f, -8.658024758e-04f, 1.415596690e-04f, 1.143587144e-03f, 2.139884957e-03f, 3.130062569e-03f, 4.113734024e-03f, 5.090518098e-03f, 
6.060038428e-03f, 7.021923644e-03f, 7.975807504e-03f, 8.921329017e-03f, 9.858132569e-03f, 1.078586804e-02f, 1.170419094e-02f, 1.261276249e-02f, 1.351124977e-02f, 1.439932581e-02f, 
1.527666972e-02f, 1.614296673e-02f, 1.699790839e-02f, 1.784119258e-02f, 1.867252364e-02f, 1.949161247e-02f, 2.029817659e-02f, 2.109194026e-02f, 2.187263454e-02f, 2.263999735e-02f, 
2.339377360e-02f, 2.413371520e-02f, 2.485958117e-02f, 2.557113769e-02f, 2.626815817e-02f, 2.695042329e-02f, 2.761772107e-02f, 2.826984694e-02f, 2.890660373e-02f, 2.952780179e-02f, 
3.013325897e-02f, 3.072280071e-02f, 3.129626003e-02f, 3.185347757e-02f, 3.239430166e-02f, 3.291858829e-02f, 3.342620117e-02f, 3.391701173e-02f, 3.439089914e-02f, 3.484775032e-02f, 
3.528745994e-02f, 3.570993047e-02f, 3.611507210e-02f, 3.650280283e-02f, 3.687304838e-02f, 3.722574227e-02f, 3.756082573e-02f, 3.787824771e-02f, 3.817796491e-02f, 3.845994168e-02f, 
3.872415007e-02f, 3.897056975e-02f, 3.919918800e-02f, 3.940999968e-02f, 3.960300721e-02f, 3.977822049e-02f, 3.993565688e-02f, 4.007534117e-02f, 4.019730552e-02f, 4.030158939e-02f, 
4.038823952e-02f, 4.045730985e-02f, 4.050886147e-02f, 4.054296258e-02f, 4.055968836e-02f, 4.055912098e-02f, 4.054134950e-02f, 4.050646977e-02f, 4.045458441e-02f, 4.038580266e-02f, 
4.030024040e-02f, 4.019801998e-02f, 4.007927016e-02f, 3.994412604e-02f, 3.979272899e-02f, 3.962522649e-02f, 3.944177211e-02f, 3.924252536e-02f, 3.902765163e-02f, 3.879732207e-02f, 
3.855171352e-02f, 3.829100835e-02f, 3.801539440e-02f, 3.772506487e-02f, 3.742021820e-02f, 3.710105796e-02f, 3.676779274e-02f, 3.642063603e-02f, 3.605980615e-02f, 3.568552605e-02f, 
3.529802327e-02f, 3.489752978e-02f, 3.448428187e-02f, 3.405852003e-02f, 3.362048884e-02f, 3.317043681e-02f, 3.270861629e-02f, 3.223528332e-02f, 3.175069754e-02f, 3.125512201e-02f, 
3.074882313e-02f, 3.023207048e-02f, 2.970513668e-02f, 2.916829733e-02f, 2.862183077e-02f, 2.806601804e-02f, 2.750114271e-02f, 2.692749074e-02f, 2.634535036e-02f, 2.575501195e-02f, 
2.515676788e-02f, 2.455091237e-02f, 2.393774140e-02f, 2.331755254e-02f, 2.269064482e-02f, 2.205731860e-02f, 2.141787545e-02f, 2.077261799e-02f, 2.012184978e-02f, 1.946587517e-02f, 
1.880499916e-02f, 1.813952732e-02f, 1.746976558e-02f, 1.679602016e-02f, 1.611859741e-02f, 1.543780367e-02f, 1.475394519e-02f, 1.406732793e-02f, 1.337825750e-02f, 1.268703897e-02f, 
1.199397680e-02f, 1.129937467e-02f, 1.060353537e-02f, 9.906760706e-03f, 9.209351318e-03f, 8.511606604e-03f, 7.813824583e-03f, 7.116301778e-03f, 6.419333097e-03f, 5.723211713e-03f, 
5.028228955e-03f, 4.334674187e-03f, 3.642834699e-03f, 2.952995594e-03f, 2.265439678e-03f, 1.580447350e-03f, 8.982964989e-04f, 2.192623934e-04f, -4.563824188e-04f, -1.128368214e-03f, 
-1.796428193e-03f, -2.460298580e-03f, -3.119718718e-03f, -3.774431168e-03f, -4.424181796e-03f, -5.068719870e-03f, -5.707798147e-03f, -6.341172962e-03f, -6.968604310e-03f, -7.589855934e-03f, 
-8.204695405e-03f, -8.812894202e-03f, -9.414227788e-03f, -1.000847569e-02f, -1.059542156e-02f, -1.117485327e-02f, -1.174656295e-02f, -1.231034708e-02f, -1.286600655e-02f, -1.341334671e-02f, 
-1.395217745e-02f, -1.448231324e-02f, -1.500357318e-02f, -1.551578110e-02f, -1.601876555e-02f, -1.651235989e-02f, -1.699640232e-02f, -1.747073593e-02f, -1.793520873e-02f, -1.838967373e-02f, 
-1.883398891e-02f, -1.926801733e-02f, -1.969162711e-02f, -2.010469147e-02f, -2.050708877e-02f, -2.089870255e-02f, -2.127942151e-02f, -2.164913957e-02f, -2.200775587e-02f, -2.235517480e-02f, 
-2.269130599e-02f, -2.301606437e-02f, -2.332937011e-02f, -2.363114870e-02f, -2.392133089e-02f, -2.419985275e-02f, -2.446665562e-02f, -2.472168617e-02f, -2.496489630e-02f, -2.519624326e-02f, 
-2.541568952e-02f, -2.562320285e-02f, -2.581875624e-02f, -2.600232793e-02f, -2.617390140e-02f, -2.633346529e-02f, -2.648101343e-02f, -2.661654483e-02f, -2.674006360e-02f, -2.685157896e-02f, 
-2.695110520e-02f, -2.703866166e-02f, -2.711427266e-02f, -2.717796751e-02f, -2.722978046e-02f, -2.726975063e-02f, -2.729792201e-02f, -2.731434339e-02f, -2.731906832e-02f, -2.731215506e-02f, 
-2.729366657e-02f, -2.726367039e-02f, -2.722223863e-02f, -2.716944792e-02f, -2.710537936e-02f, -2.703011840e-02f, -2.694375488e-02f, -2.684638289e-02f, -2.673810074e-02f, -2.661901089e-02f, 
-2.648921990e-02f, -2.634883835e-02f, -2.619798076e-02f, -2.603676554e-02f, -2.586531493e-02f, -2.568375489e-02f, -2.549221506e-02f, -2.529082869e-02f, -2.507973253e-02f, -2.485906677e-02f, 
-2.462897499e-02f, -2.438960404e-02f, -2.414110399e-02f, -2.388362803e-02f, -2.361733240e-02f, -2.334237630e-02f, -2.305892182e-02f, -2.276713383e-02f, -2.246717992e-02f, -2.215923033e-02f, 
-2.184345779e-02f, -2.152003754e-02f, -2.118914714e-02f, -2.085096645e-02f, -2.050567751e-02f, -2.015346447e-02f, -1.979451348e-02f, -1.942901262e-02f, -1.905715178e-02f, -1.867912262e-02f, 
-1.829511842e-02f, -1.790533403e-02f, -1.750996576e-02f, -1.710921129e-02f, -1.670326961e-02f, -1.629234086e-02f, -1.587662631e-02f, -1.545632821e-02f, -1.503164974e-02f, -1.460279490e-02f, 
-1.416996843e-02f, -1.373337569e-02f, -1.329322261e-02f, -1.284971556e-02f, -1.240306127e-02f, -1.195346677e-02f, -1.150113927e-02f, -1.104628605e-02f, -1.058911443e-02f, -1.012983162e-02f, 
-9.668644671e-03f, -9.205760380e-03f, -8.741385190e-03f, -8.275725108e-03f, -7.808985628e-03f, -7.341371634e-03f, -6.873087321e-03f, -6.404336112e-03f, -5.935320569e-03f, -5.466242317e-03f, 
-4.997301958e-03f, -4.528698990e-03f, -4.060631732e-03f, -3.593297236e-03f, -3.126891220e-03f, -2.661607980e-03f, -2.197640322e-03f, -1.735179484e-03f, -1.274415058e-03f, -8.155349253e-04f, 
-3.587251773e-04f, 9.582995142e-05f, 5.479481540e-04f, 9.974491193e-04f, 1.444154599e-03f, 1.887888474e-03f, 2.328476817e-03f, 2.765747962e-03f, 3.199532556e-03f, 3.629663631e-03f, 
4.055976657e-03f, 4.478309598e-03f, 4.896502978e-03f, 5.310399925e-03f, 5.719846234e-03f, 6.124690414e-03f, 6.524783741e-03f, 6.919980310e-03f, 7.310137077e-03f, 7.695113911e-03f, 
8.074773638e-03f, 8.448982084e-03f, 8.817608116e-03f, 9.180523686e-03f, 9.537603865e-03f, 9.888726886e-03f, 1.023377418e-02f, 1.057263039e-02f, 1.090518345e-02f, 1.123132457e-02f, 
1.155094829e-02f, 1.186395249e-02f, 1.217023844e-02f, 1.246971082e-02f, 1.276227770e-02f, 1.304785065e-02f, 1.332634467e-02f, 1.359767826e-02f, 1.386177341e-02f, 1.411855565e-02f, 
1.436795404e-02f, 1.460990116e-02f, 1.484433317e-02f, 1.507118978e-02f, 1.529041427e-02f, 1.550195352e-02f, 1.570575796e-02f, 1.590178162e-02f, 1.608998211e-02f, 1.627032063e-02f, 
1.644276195e-02f, 1.660727443e-02f, 1.676382999e-02f, 1.691240414e-02f, 1.705297592e-02f, 1.718552793e-02f, 1.731004632e-02f, 1.742652075e-02f, 1.753494439e-02f, 1.763531391e-02f, 
1.772762946e-02f, 1.781189465e-02f, 1.788811652e-02f, 1.795630554e-02f, 1.801647558e-02f, 1.806864385e-02f, 1.811283096e-02f, 1.814906080e-02f, 1.817736056e-02f, 1.819776071e-02f, 
1.821029493e-02f, 1.821500012e-02f, 1.821191634e-02f, 1.820108678e-02f, 1.818255775e-02f, 1.815637861e-02f, 1.812260172e-02f, 1.808128248e-02f, 1.803247918e-02f, 1.797625307e-02f, 
1.791266822e-02f, 1.784179156e-02f, 1.776369275e-02f, 1.767844424e-02f, 1.758612111e-02f, 1.748680113e-02f, 1.738056463e-02f, 1.726749450e-02f, 1.714767611e-02f, 1.702119729e-02f, 
1.688814826e-02f, 1.674862157e-02f, 1.660271208e-02f, 1.645051687e-02f, 1.629213521e-02f, 1.612766849e-02f, 1.595722018e-02f, 1.578089576e-02f, 1.559880269e-02f, 1.541105031e-02f, 
1.521774981e-02f, 1.501901418e-02f, 1.481495812e-02f, 1.460569803e-02f, 1.439135190e-02f, 1.417203927e-02f, 1.394788119e-02f, 1.371900012e-02f, 1.348551990e-02f, 1.324756569e-02f, 
1.300526389e-02f, 1.275874208e-02f, 1.250812898e-02f, 1.225355436e-02f, 1.199514900e-02f, 1.173304463e-02f, 1.146737384e-02f, 1.119827005e-02f, 1.092586741e-02f, 1.065030080e-02f, 
1.037170571e-02f, 1.009021818e-02f, 9.805974783e-03f, 9.519112526e-03f, 9.229768795e-03f, 8.938081301e-03f, 8.644188012e-03f, 8.348227095e-03f, 8.050336853e-03f, 7.750655666e-03f, 
7.449321932e-03f, 7.146474002e-03f, 6.842250127e-03f, 6.536788391e-03f, 6.230226659e-03f, 5.922702516e-03f, 5.614353207e-03f, 5.305315582e-03f, 4.995726037e-03f, 4.685720460e-03f, 
4.375434170e-03f, 4.065001866e-03f, 3.754557573e-03f, 3.444234581e-03f, 3.134165397e-03f, 2.824481690e-03f, 2.515314240e-03f, 2.206792882e-03f, 1.899046461e-03f, 1.592202775e-03f, 
1.286388530e-03f, 9.817292888e-04f, 6.783494245e-04f, 3.763720713e-04f, 7.591907869e-05f, -2.228890345e-04f, -5.199331250e-04f, -8.150954692e-04f, -1.108259807e-03f, -1.399311383e-03f, 
-1.688136989e-03f, -1.974625006e-03f, -2.258665439e-03f, -2.540149963e-03f, -2.818971955e-03f, -3.095026533e-03f, -3.368210592e-03f, -3.638422839e-03f, -3.905563826e-03f, -4.169535987e-03f, 
-4.430243662e-03f, -4.687593137e-03f, -4.941492669e-03f, -5.191852513e-03f, -5.438584957e-03f, -5.681604341e-03f, -5.920827090e-03f, -6.156171731e-03f, -6.387558926e-03f, -6.614911485e-03f, 
-6.838154395e-03f, -7.057214839e-03f, -7.272022211e-03f, -7.482508139e-03f, -7.688606504e-03f, -7.890253449e-03f, -8.087387402e-03f, -8.279949084e-03f, -8.467881525e-03f, -8.651130079e-03f, 
-8.829642427e-03f, -9.003368593e-03f, -9.172260951e-03f, -9.336274233e-03f, -9.495365534e-03f, -9.649494319e-03f, -9.798622427e-03f, -9.942714075e-03f, -1.008173586e-02f, -1.021565675e-02f, 
-1.034444812e-02f, -1.046808369e-02f, -1.058653959e-02f, -1.069979431e-02f, -1.080782870e-02f, -1.091062600e-02f, -1.100817181e-02f, -1.110045406e-02f, -1.118746304e-02f, -1.126919138e-02f, 
-1.134563404e-02f, -1.141678828e-02f, -1.148265367e-02f, -1.154323209e-02f, -1.159852767e-02f, -1.164854681e-02f, -1.169329818e-02f, -1.173279266e-02f, -1.176704334e-02f, -1.179606551e-02f, 
-1.181987666e-02f, -1.183849639e-02f, -1.185194649e-02f, -1.186025082e-02f, -1.186343535e-02f, -1.186152813e-02f, -1.185455923e-02f, -1.184256076e-02f, -1.182556682e-02f, -1.180361347e-02f, 
-1.177673873e-02f, -1.174498251e-02f, -1.170838664e-02f, -1.166699477e-02f, -1.162085240e-02f, -1.157000682e-02f, -1.151450709e-02f, -1.145440400e-02f, -1.138975006e-02f, -1.132059942e-02f, 
-1.124700789e-02f, -1.116903289e-02f, -1.108673338e-02f, -1.100016989e-02f, -1.090940441e-02f, -1.081450044e-02f, -1.071552288e-02f, -1.061253801e-02f, -1.050561350e-02f, -1.039481831e-02f, 
-1.028022269e-02f, -1.016189813e-02f, -1.003991732e-02f, -9.914354127e-03f, -9.785283532e-03f, -9.652781607e-03f, -9.516925470e-03f, -9.377793250e-03f, -9.235464042e-03f, -9.090017867e-03f, 
-8.941535636e-03f, -8.790099106e-03f, -8.635790842e-03f, -8.478694172e-03f, -8.318893152e-03f, -8.156472520e-03f, -7.991517658e-03f, -7.824114551e-03f, -7.654349743e-03f, -7.482310301e-03f, 
-7.308083768e-03f, -7.131758128e-03f, -6.953421760e-03f, -6.773163400e-03f, -6.591072099e-03f, -6.407237184e-03f, -6.221748213e-03f, -6.034694942e-03f, -5.846167276e-03f, -5.656255234e-03f, 
-5.465048911e-03f, -5.272638430e-03f, -5.079113913e-03f, -4.884565431e-03f, -4.689082975e-03f, -4.492756410e-03f, -4.295675437e-03f, -4.097929560e-03f, -3.899608042e-03f, -3.700799871e-03f, 
-3.501593721e-03f, -3.302077915e-03f, -3.102340391e-03f, -2.902468661e-03f, -2.702549781e-03f, -2.502670311e-03f, -2.302916282e-03f, -2.103373160e-03f, -1.904125815e-03f, -1.705258484e-03f, 
-1.506854739e-03f, -1.308997457e-03f, -1.111768782e-03f, -9.152500997e-04f, -7.195220014e-04f, -5.246642566e-04f, -3.307557813e-04f, -1.378746090e-04f, 5.390213843e-05f, 2.444982788e-04f, 
4.338385978e-04f, 6.218488759e-04f, 8.084559154e-04f, 9.935875659e-04f, 1.177172750e-03f, 1.359141488e-03f, 1.539424923e-03f, 1.717955341e-03f, 1.894666200e-03f, 2.069492144e-03f, 
2.242369034e-03f, 2.413233959e-03f, 2.582025266e-03f, 2.748682570e-03f, 2.913146782e-03f, 3.075360119e-03f, 3.235266129e-03f, 3.392809701e-03f, 3.547937086e-03f, 3.700595911e-03f, 
3.850735193e-03f, 3.998305353e-03f, 4.143258230e-03f, 4.285547095e-03f, 4.425126661e-03f, 4.561953092e-03f, 4.695984021e-03f, 4.827178551e-03f, 4.955497270e-03f, 5.080902256e-03f, 
5.203357088e-03f, 5.322826851e-03f, 5.439278141e-03f, 5.552679073e-03f, 5.662999284e-03f, 5.770209939e-03f, 5.874283733e-03f, 5.975194894e-03f, 6.072919186e-03f, 6.167433909e-03f, 
6.258717899e-03f, 6.346751532e-03f, 6.431516720e-03f, 6.512996907e-03f, 6.591177076e-03f, 6.666043735e-03f, 6.737584922e-03f, 6.805790199e-03f, 6.870650644e-03f, 6.932158851e-03f, 
6.990308919e-03f, 7.045096449e-03f, 7.096518534e-03f, 7.144573756e-03f, 7.189262171e-03f, 7.230585305e-03f, 7.268546141e-03f, 7.303149114e-03f, 7.334400093e-03f, 7.362306374e-03f, 
7.386876669e-03f, 7.408121092e-03f, 7.426051143e-03f, 7.440679700e-03f, 7.452021001e-03f, 7.460090632e-03f, 7.464905510e-03f, 7.466483867e-03f, 7.464845236e-03f, 7.460010432e-03f, 
7.452001538e-03f, 7.440841883e-03f, 7.426556031e-03f, 7.409169754e-03f, 7.388710021e-03f, 7.365204973e-03f, 7.338683907e-03f, 7.309177254e-03f, 7.276716561e-03f, 7.241334465e-03f, 
7.203064680e-03f, 7.161941968e-03f, 7.118002120e-03f, 7.071281936e-03f, 7.021819199e-03f, 6.969652654e-03f, 6.914821987e-03f, 6.857367795e-03f, 6.797331571e-03f, 6.734755675e-03f, 
6.669683311e-03f, 6.602158502e-03f, 6.532226066e-03f, 6.459931595e-03f, 6.385321422e-03f, 6.308442604e-03f, 6.229342892e-03f, 6.148070708e-03f, 6.064675116e-03f, 5.979205802e-03f, 
5.891713044e-03f, 5.802247686e-03f, 5.710861115e-03f, 5.617605232e-03f, 5.522532427e-03f, 5.425695553e-03f, 5.327147902e-03f, 5.226943172e-03f, 5.125135449e-03f, 5.021779175e-03f, 
4.916929125e-03f, 4.810640378e-03f, 4.702968292e-03f, 4.593968479e-03f, 4.483696779e-03f, 4.372209230e-03f, 4.259562046e-03f, 4.145811591e-03f, 4.031014350e-03f, 3.915226907e-03f, 
3.798505918e-03f, 3.680908082e-03f, 3.562490124e-03f, 3.443308761e-03f, 3.323420682e-03f, 3.202882522e-03f, 3.081750836e-03f, 2.960082079e-03f, 2.837932575e-03f, 2.715358499e-03f, 
2.592415847e-03f, 2.469160421e-03f, 2.345647797e-03f, 2.221933306e-03f, 2.098072011e-03f, 1.974118685e-03f, 1.850127785e-03f, 1.726153435e-03f, 1.602249400e-03f, 1.478469067e-03f, 
1.354865425e-03f, 1.231491038e-03f, 1.108398033e-03f, 9.856380731e-04f, 8.632623400e-04f, 7.413215153e-04f, 6.198657603e-04f, 4.989446971e-04f, 3.786073905e-04f, 2.589023299e-04f, 
1.398774111e-04f, 2.157991938e-05f, -9.594348750e-05f, -2.126467961e-04f, -3.284846535e-04f, -4.434123828e-04f, -5.573859987e-04f, -6.703622229e-04f, -7.822984977e-04f, -8.931530012e-04f, 
-1.002884660e-03f, -1.111453165e-03f, -1.218818979e-03f, -1.324943356e-03f, -1.429788347e-03f, -1.533316817e-03f, -1.635492452e-03f, -1.736279772e-03f, -1.835644139e-03f, -1.933551770e-03f, 
-2.029969746e-03f, -2.124866016e-03f, -2.218209413e-03f, -2.309969656e-03f, -2.400117361e-03f, -2.488624048e-03f, -2.575462143e-03f, -2.660604994e-03f, -2.744026865e-03f, -2.825702950e-03f, 
-2.905609376e-03f, -2.983723205e-03f, -3.060022439e-03f, -3.134486027e-03f, -3.207093862e-03f, -3.277826789e-03f, -3.346666604e-03f, -3.413596058e-03f, -3.478598857e-03f, -3.541659662e-03f, 
-3.602764093e-03f, -3.661898724e-03f, -3.719051089e-03f, -3.774209673e-03f, -3.827363920e-03f, -3.878504224e-03f, -3.927621929e-03f, -3.974709330e-03f, -4.019759664e-03f, -4.062767113e-03f, 
-4.103726796e-03f, -4.142634766e-03f, -4.179488005e-03f, -4.214284423e-03f, -4.247022845e-03f, -4.277703016e-03f, -4.306325583e-03f, -4.332892098e-03f, -4.357405008e-03f, -4.379867647e-03f, 
-4.400284230e-03f, -4.418659844e-03f, -4.435000441e-03f, -4.449312829e-03f, -4.461604665e-03f, -4.471884441e-03f, -4.480161479e-03f, -4.486445923e-03f, -4.490748722e-03f, -4.493081627e-03f, 
-4.493457174e-03f, -4.491888678e-03f, -4.488390221e-03f, -4.482976638e-03f, -4.475663508e-03f, -4.466467140e-03f, -4.455404562e-03f, -4.442493510e-03f, -4.427752410e-03f, -4.411200373e-03f, 
-4.392857175e-03f, -4.372743246e-03f, -4.350879658e-03f, -4.327288110e-03f, -4.301990913e-03f, -4.275010977e-03f, -4.246371798e-03f, -4.216097441e-03f, -4.184212527e-03f, -4.150742217e-03f, 
-4.115712199e-03f, -4.079148672e-03f, -4.041078329e-03f, -4.001528346e-03f, -3.960526361e-03f, -3.918100463e-03f, -3.874279176e-03f, -3.829091441e-03f, -3.782566601e-03f, -3.734734386e-03f, 
-3.685624897e-03f, -3.635268590e-03f, -3.583696257e-03f, -3.530939016e-03f, -3.477028289e-03f, -3.421995791e-03f, -3.365873508e-03f, -3.308693686e-03f, -3.250488813e-03f, -3.191291600e-03f, 
-3.131134972e-03f, -3.070052042e-03f, -3.008076105e-03f, -2.945240615e-03f, -2.881579170e-03f, -2.817125499e-03f, -2.751913444e-03f, -2.685976942e-03f, -2.619350013e-03f, -2.552066743e-03f, 
-2.484161268e-03f, -2.415667756e-03f, -2.346620397e-03f, -2.277053381e-03f, -2.207000890e-03f, -2.136497075e-03f, -2.065576048e-03f, -1.994271861e-03f, -1.922618496e-03f, -1.850649848e-03f, 
-1.778399710e-03f, -1.705901761e-03f, -1.633189549e-03f, -1.560296477e-03f, -1.487255793e-03f, -1.414100570e-03f, -1.340863698e-03f, -1.267577868e-03f, -1.194275559e-03f, -1.120989025e-03f, 
-1.047750283e-03f, -9.745910968e-04f, -9.015429712e-04f, -8.286371336e-04f, -7.559045249e-04f, -6.833757869e-04f, -6.110812510e-04f, -5.390509267e-04f, -4.673144903e-04f, -3.959012741e-04f, 
-3.248402558e-04f, -2.541600480e-04f, -1.838888878e-04f, -1.140546271e-04f, -4.468472254e-05f, 2.419377358e-05f, 9.255422288e-05f, 1.603704097e-04f, 2.276165499e-04f, 2.942672994e-04f, 
3.602977621e-04f, 4.256834981e-04f, 4.904005315e-04f, 5.544253575e-04f, 6.177349495e-04f, 6.803067666e-04f, 7.421187596e-04f, 8.031493774e-04f, 8.633775735e-04f, 9.227828114e-04f, 
9.813450703e-04f, 1.039044851e-03f, 1.095863178e-03f, 1.151781610e-03f, 1.206782237e-03f, 1.260847692e-03f, 1.313961148e-03f, 1.366106326e-03f, 1.417267498e-03f, 1.467429487e-03f, 
1.516577675e-03f, 1.564697999e-03f, 1.611776960e-03f, 1.657801619e-03f, 1.702759604e-03f, 1.746639107e-03f, 1.789428887e-03f, 1.831118272e-03f, 1.871697160e-03f, 1.911156014e-03f, 
1.949485869e-03f, 1.986678329e-03f, 2.022725566e-03f, 2.057620320e-03f, 2.091355898e-03f, 2.123926172e-03f, 2.155325581e-03f, 2.185549124e-03f, 2.214592363e-03f, 2.242451417e-03f, 
2.269122963e-03f, 2.294604232e-03f, 2.318893004e-03f, 2.341987609e-03f, 2.363886920e-03f, 2.384590352e-03f, 2.404097858e-03f, 2.422409923e-03f, 2.439527562e-03f, 2.455452314e-03f, 
2.470186240e-03f, 2.483731914e-03f, 2.496092422e-03f, 2.507271355e-03f, 2.517272804e-03f, 2.526101353e-03f, 2.533762078e-03f, 2.540260533e-03f, 2.545602752e-03f, 2.549795237e-03f, 
2.552844955e-03f, 2.554759330e-03f, 2.555546236e-03f, 2.555213990e-03f, 2.553771347e-03f, 2.551227489e-03f, 2.547592022e-03f, 2.542874964e-03f, 2.537086741e-03f, 2.530238177e-03f, 
2.522340488e-03f, 2.513405272e-03f, 2.503444503e-03f, 2.492470518e-03f, 2.480496018e-03f, 2.467534048e-03f, 2.453597998e-03f, 2.438701589e-03f, 2.422858867e-03f, 2.406084191e-03f, 
2.388392227e-03f, 2.369797940e-03f, 2.350316581e-03f, 2.329963680e-03f, 2.308755038e-03f, 2.286706717e-03f, 2.263835030e-03f, 2.240156531e-03f, 2.215688008e-03f, 2.190446472e-03f, 
2.164449149e-03f, 2.137713469e-03f, 2.110257055e-03f, 2.082097719e-03f, 2.053253448e-03f, 2.023742395e-03f, 1.993582870e-03f, 1.962793331e-03f, 1.931392375e-03f, 1.899398727e-03f, 
1.866831231e-03f, 1.833708840e-03f, 1.800050610e-03f, 1.765875684e-03f, 1.731203289e-03f, 1.696052723e-03f, 1.660443349e-03f, 1.624394581e-03f, 1.587925878e-03f, 1.551056734e-03f, 
1.513806671e-03f, 1.476195225e-03f, 1.438241941e-03f, 1.399966365e-03f, 1.361388030e-03f, 1.322526452e-03f, 1.283401121e-03f, 1.244031488e-03f, 1.204436963e-03f, 1.164636898e-03f, 
1.124650590e-03f, 1.084497260e-03f, 1.044196057e-03f, 1.003766039e-03f, 9.632261729e-04f, 9.225953234e-04f, 8.818922452e-04f, 8.411355758e-04f, 8.003438281e-04f, 7.595353823e-04f, 
7.187284795e-04f, 6.779412139e-04f, 6.371915256e-04f, 5.964971942e-04f, 5.558758316e-04f, 5.153448754e-04f, 4.749215822e-04f, 4.346230215e-04f, 3.944660692e-04f, 3.544674015e-04f, 
3.146434886e-04f, 2.750105896e-04f, 2.355847457e-04f, 1.963817757e-04f, 1.574172698e-04f, 1.187065847e-04f, 8.026483832e-05f, 4.210690478e-05f, 4.247409714e-06f, -3.329927451e-05f, 
-7.051903330e-05f, -1.073980142e-04f, -1.439226311e-04f, -1.800795685e-04f, -2.158557848e-04f, -2.512385170e-04f, -2.862152833e-04f, -3.207738872e-04f, -3.549024207e-04f, -3.885892670e-04f, 
-4.218231039e-04f, -4.545929064e-04f, -4.868879492e-04f, -5.186978096e-04f, -5.500123693e-04f, -5.808218168e-04f, -6.111166496e-04f, -6.408876757e-04f, -6.701260154e-04f, -6.988231029e-04f, 
-7.269706874e-04f, -7.545608348e-04f, -7.815859282e-04f, -8.080386691e-04f, -8.339120783e-04f, -8.591994961e-04f, -8.838945828e-04f, -9.079913193e-04f, -9.314840070e-04f, -9.543672678e-04f, 
-9.766360438e-04f, -9.982855973e-04f, -1.019311510e-03f, -1.039709683e-03f, -1.059476335e-03f, -1.078608003e-03f, -1.097101539e-03f, -1.114954111e-03f, -1.132163201e-03f, -1.148726603e-03f, 
-1.164642422e-03f, -1.179909071e-03f, -1.194525273e-03f, -1.208490054e-03f, -1.221802743e-03f, -1.234462973e-03f, -1.246470672e-03f, -1.257826067e-03f, -1.268529677e-03f, -1.278582313e-03f, 
-1.287985075e-03f, -1.296739346e-03f, -1.304846792e-03f, -1.312309360e-03f, -1.319129271e-03f, -1.325309020e-03f, -1.330851370e-03f, -1.335759349e-03f, -1.340036250e-03f, -1.343685621e-03f, 
-1.346711267e-03f, -1.349117241e-03f, -1.350907847e-03f, -1.352087626e-03f, -1.352661362e-03f, -1.352634071e-03f, -1.352010999e-03f, -1.350797619e-03f, -1.348999625e-03f, -1.346622925e-03f, 
-1.343673642e-03f, -1.340158106e-03f, -1.336082850e-03f, -1.331454603e-03f, -1.326280289e-03f, -1.320567022e-03f, -1.314322096e-03f, -1.307552986e-03f, -1.300267341e-03f, -1.292472978e-03f, 
-1.284177877e-03f, -1.275390177e-03f, -1.266118171e-03f, -1.256370299e-03f, -1.246155147e-03f, -1.235481434e-03f, -1.224358018e-03f, -1.212793878e-03f, -1.200798121e-03f, -1.188379967e-03f, 
-1.175548749e-03f, -1.162313907e-03f, -1.148684982e-03f, -1.134671610e-03f, -1.120283519e-03f, -1.105530521e-03f, -1.090422509e-03f, -1.074969449e-03f, -1.059181380e-03f, -1.043068401e-03f, 
-1.026640674e-03f, -1.009908411e-03f, -9.928818764e-04f, -9.755713750e-04f, -9.579872515e-04f, -9.401398832e-04f, -9.220396756e-04f, -9.036970571e-04f, -8.851224742e-04f, -8.663263863e-04f, 
-8.473192607e-04f, -8.281115678e-04f, -8.087137763e-04f, -7.891363482e-04f, -7.693897339e-04f, -7.494843677e-04f, -7.294306631e-04f, -7.092390079e-04f, -6.889197599e-04f, -6.684832419e-04f, 
-6.479397380e-04f, -6.272994882e-04f, -6.065726848e-04f, -5.857694678e-04f, -5.648999205e-04f, -5.439740656e-04f, -5.230018608e-04f, -5.019931951e-04f, -4.809578845e-04f, -4.599056681e-04f, 
-4.388462044e-04f, -4.177890676e-04f, -3.967437435e-04f, -3.757196263e-04f, -3.547260150e-04f, -3.337721094e-04f, -3.128670075e-04f, -2.920197015e-04f, -2.712390750e-04f, -2.505338997e-04f, 
-2.299128320e-04f, -2.093844106e-04f, -1.889570532e-04f, -1.686390535e-04f, -1.484385789e-04f, -1.283636676e-04f, -1.084222258e-04f, -8.862202577e-05f, -6.897070277e-05f, -4.947575319e-05f, 
-3.014453212e-05f, -1.098425124e-05f, 7.998023237e-06f, 2.679537259e-05f, 4.540102745e-05f, 6.380836958e-05f, 8.201093367e-05f, 1.000024089e-04f, 1.177766404e-04f, 1.353276310e-04f, 
1.526495422e-04f, 1.697366958e-04f, 1.865835749e-04f, 2.031848250e-04f, 2.195352551e-04f, 2.356298385e-04f, 2.514637138e-04f, 2.670321857e-04f, 2.823307254e-04f, 2.973549714e-04f, 
3.121007300e-04f, 3.265639755e-04f, 3.407408511e-04f, 3.546276682e-04f, 3.682209076e-04f, 3.815172188e-04f, 3.945134205e-04f, 4.072065003e-04f, 4.195936146e-04f, 4.316720881e-04f, 
4.434394141e-04f, 4.548932536e-04f, 4.660314350e-04f, 4.768519534e-04f, 4.873529703e-04f, 4.975328127e-04f, 5.073899723e-04f, 5.169231048e-04f, 5.261310289e-04f, 5.350127255e-04f, 
5.435673362e-04f, 5.517941629e-04f, 5.596926660e-04f, 5.672624633e-04f, 5.745033291e-04f, 5.814151921e-04f, 5.879981349e-04f, 5.942523915e-04f, 6.001783466e-04f, 6.057765335e-04f, 
6.110476326e-04f, 6.159924697e-04f, 6.206120142e-04f, 6.249073772e-04f, 6.288798098e-04f, 6.325307010e-04f, 6.358615759e-04f, 6.388740935e-04f, 6.415700448e-04f, 6.439513505e-04f, 
6.460200591e-04f, 6.477783444e-04f, 6.492285038e-04f, 6.503729553e-04f, 6.512142356e-04f, 6.517549980e-04f, 6.519980096e-04f, 6.519461488e-04f, 6.516024036e-04f, 6.509698682e-04f, 
6.500517411e-04f, 6.488513225e-04f, 6.473720116e-04f, 6.456173039e-04f, 6.435907892e-04f, 6.412961483e-04f, 6.387371507e-04f, 6.359176518e-04f, 6.328415907e-04f, 6.295129868e-04f, 
6.259359375e-04f, 6.221146157e-04f, 6.180532664e-04f, 6.137562048e-04f, 6.092278130e-04f, 6.044725374e-04f, 5.994948860e-04f, 5.942994257e-04f, 5.888907793e-04f, 5.832736232e-04f, 
5.774526842e-04f, 5.714327368e-04f, 5.652186008e-04f, 5.588151382e-04f, 5.522272507e-04f, 5.454598768e-04f, 5.385179891e-04f, 5.314065917e-04f, 5.241307175e-04f, 5.166954253e-04f, 
5.091057973e-04f, 5.013669366e-04f, 4.934839641e-04f, 4.854620164e-04f, 4.773062426e-04f, 4.690218024e-04f, 4.606138630e-04f, 4.520875968e-04f, 4.434481786e-04f, 4.347007835e-04f, 
4.258505841e-04f, 4.169027483e-04f, 4.078624366e-04f, 3.987347999e-04f, 3.895249770e-04f, 3.802380925e-04f, 3.708792540e-04f, 3.614535504e-04f, 3.519660494e-04f, 3.424217950e-04f, 
3.328258057e-04f, 3.231830724e-04f, 3.134985559e-04f, 3.037771851e-04f, 2.940238550e-04f, 2.842434242e-04f, 2.744407139e-04f, 2.646205049e-04f, 2.547875364e-04f, 2.449465038e-04f, 
2.351020572e-04f, 2.252587994e-04f, 2.154212842e-04f, 2.055940145e-04f, 1.957814413e-04f, 1.859879613e-04f, 1.762179158e-04f, 1.664755893e-04f, 1.567652075e-04f, 1.470909363e-04f, 
1.374568803e-04f, 1.278670813e-04f, 1.183255172e-04f, 1.088361008e-04f, 9.940267807e-05f, 9.002902776e-05f, 8.071885966e-05f, 7.147581376e-05f, 6.230345923e-05f, 5.320529333e-05f, 
4.418474059e-05f, 3.524515179e-05f, 2.638980320e-05f, 1.762189572e-05f, 8.944554141e-06f, 3.608264200e-07f, -8.126316992e-06f, -1.651398378e-05f, -2.479936033e-05f, -3.297971229e-05f, 
-4.105238505e-05f, -4.901480420e-05f, -5.686447591e-05f, -6.459898732e-05f, -7.221600683e-05f, -7.971328440e-05f, -8.708865176e-05f, -9.434002260e-05f, -1.014653927e-04f, -1.084628402e-04f, 
-1.153305252e-04f, -1.220666904e-04f, -1.286696606e-04f, -1.351378429e-04f, -1.414697264e-04f, -1.476638823e-04f, -1.537189635e-04f, -1.596337044e-04f, -1.654069209e-04f, -1.710375098e-04f, 
-1.765244486e-04f, -1.818667949e-04f, -1.870636866e-04f, -1.921143409e-04f, -1.970180538e-04f, -2.017741999e-04f, -2.063822320e-04f, -2.108416799e-04f, -2.151521503e-04f, -2.193133260e-04f, 
-2.233249653e-04f, -2.271869010e-04f, -2.308990403e-04f, -2.344613633e-04f, -2.378739228e-04f, -2.411368429e-04f, -2.442503189e-04f, -2.472146158e-04f, -2.500300676e-04f, -2.526970764e-04f, 
-2.552161116e-04f, -2.575877086e-04f, -2.598124682e-04f, -2.618910551e-04f, -2.638241975e-04f, -2.656126853e-04f, -2.672573697e-04f, -2.687591616e-04f, -2.701190310e-04f, -2.713380052e-04f, 
-2.724171683e-04f, -2.733576595e-04f, -2.741606726e-04f, -2.748274539e-04f, -2.753593017e-04f, -2.757575649e-04f, -2.760236418e-04f, -2.761589784e-04f, -2.761650679e-04f, -2.760434489e-04f, 
-2.757957044e-04f, -2.754234601e-04f, -2.749283839e-04f, -2.743121836e-04f, -2.735766064e-04f, -2.727234373e-04f, -2.717544976e-04f, -2.706716441e-04f, -2.694767670e-04f, -2.681717894e-04f, 
-2.667586653e-04f, -2.652393789e-04f, -2.636159426e-04f, -2.618903962e-04f, -2.600648053e-04f, -2.581412601e-04f, -2.561218741e-04f, -2.540087826e-04f, -2.518041415e-04f, -2.495101260e-04f, 
-2.471289294e-04f, -2.446627613e-04f, -2.421138472e-04f, -2.394844262e-04f, -2.367767505e-04f, -2.339930837e-04f, -2.311356997e-04f, -2.282068813e-04f, -2.252089192e-04f, -2.221441104e-04f, 
-2.190147574e-04f, -2.158231667e-04f, -2.125716475e-04f, -2.092625109e-04f, -2.058980682e-04f, -2.024806303e-04f, -1.990125060e-04f, -1.954960013e-04f, -1.919334180e-04f, -1.883270527e-04f, 
-1.846791957e-04f, -1.809921299e-04f, -1.772681296e-04f, -1.735094597e-04f, -1.697183746e-04f, -1.658971170e-04f, -1.620479172e-04f, -1.581729919e-04f, -1.542745431e-04f, -1.503547576e-04f, 
-1.464158058e-04f, -1.424598408e-04f, -1.384889974e-04f, -1.345053917e-04f, -1.305111195e-04f, -1.265082562e-04f, -1.224988556e-04f, -1.184849493e-04f, -1.144685456e-04f, -1.104516293e-04f, 
-1.064361604e-04f, -1.024240738e-04f, -9.841727849e-05f, -9.441765685e-05f, -9.042706406e-05f, -8.644732744e-05f, -8.248024590e-05f, -7.852758935e-05f, -7.459109811e-05f, -7.067248246e-05f, 
-6.677342203e-05f, -6.289556540e-05f, -5.904052959e-05f, -5.520989960e-05f, -5.140522804e-05f, -4.762803470e-05f, -4.387980617e-05f, -4.016199546e-05f, -3.647602174e-05f, -3.282326994e-05f, 
-2.920509052e-05f, -2.562279916e-05f, -2.207767654e-05f, -1.857096810e-05f, -1.510388381e-05f, -1.167759804e-05f, -8.293249350e-06f, -4.951940350e-06f, -1.654737597e-06f, 1.597328525e-06f, 
4.803263881e-06f, 7.962110648e-06f, 1.107294736e-05f, 1.413488894e-05f, 1.714708667e-05f, 2.010872824e-05f, 2.301903763e-05f, 2.587727512e-05f, 2.868273722e-05f, 3.143475653e-05f, 
3.413270168e-05f, 3.677597718e-05f, 3.936402328e-05f, 4.189631583e-05f, 4.437236606e-05f, 4.679172045e-05f, 4.915396045e-05f, 5.145870230e-05f, 5.370559679e-05f, 5.589432897e-05f, 
5.802461790e-05f, 6.009621637e-05f, 6.210891058e-05f, 6.406251985e-05f, 6.595689624e-05f, 6.779192428e-05f, 6.956752056e-05f, 7.128363337e-05f, 7.294024234e-05f, 7.453735803e-05f, 
7.607502154e-05f, 7.755330405e-05f, 7.897230646e-05f, 8.033215892e-05f, 8.163302036e-05f, 8.287507807e-05f, 8.405854720e-05f, 8.518367033e-05f, 8.625071692e-05f, 8.725998288e-05f, 
8.821179002e-05f, 8.910648556e-05f, 8.994444163e-05f, 9.072605472e-05f, 9.145174516e-05f, 9.212195658e-05f, 9.273715536e-05f, 9.329783012e-05f, 9.380449111e-05f, 9.425766969e-05f, 
9.465791777e-05f, 9.500580723e-05f, 9.530192933e-05f, 9.554689418e-05f, 9.574133013e-05f, 9.588588322e-05f, 9.598121657e-05f, 9.602800981e-05f, 9.602695848e-05f, 9.597877349e-05f, 
9.588418047e-05f, 9.574391922e-05f, 9.555874313e-05f, 9.532941855e-05f, 9.505672426e-05f, 9.474145083e-05f, 9.438440006e-05f, 9.398638441e-05f, 9.354822637e-05f, 9.307075794e-05f, 
9.255482000e-05f, 9.200126176e-05f, 9.141094019e-05f, 9.078471942e-05f, 9.012347022e-05f, 8.942806939e-05f, 8.869939924e-05f, 8.793834701e-05f, 8.714580431e-05f, 8.632266662e-05f, 
8.546983271e-05f, 8.458820411e-05f, 8.367868458e-05f, 8.274217961e-05f, 8.177959586e-05f, 8.079184068e-05f, 7.977982159e-05f, 7.874444578e-05f, 7.768661963e-05f, 7.660724819e-05f, 
7.550723476e-05f, 7.438748036e-05f, 7.324888328e-05f, 7.209233865e-05f, 7.091873796e-05f, 6.972896865e-05f, 6.852391365e-05f, 6.730445094e-05f, 6.607145319e-05f, 6.482578732e-05f, 
6.356831407e-05f, 6.229988768e-05f, 6.102135543e-05f, 5.973355734e-05f, 5.843732575e-05f, 5.713348499e-05f, 5.582285105e-05f, 5.450623121e-05f, 5.318442374e-05f, 5.185821756e-05f, 
5.052839196e-05f, 4.919571629e-05f, 4.786094965e-05f, 4.652484066e-05f, 4.518812713e-05f, 4.385153586e-05f, 4.251578234e-05f, 4.118157056e-05f, 3.984959273e-05f, 3.852052909e-05f, 
3.719504771e-05f, 3.587380425e-05f, 3.455744180e-05f, 3.324659070e-05f, 3.194186835e-05f, 3.064387906e-05f, 2.935321390e-05f, 2.807045056e-05f, 2.679615319e-05f, 2.553087233e-05f, 
2.427514476e-05f, 2.302949337e-05f, 2.179442715e-05f, 2.057044100e-05f, 1.935801575e-05f, 1.815761802e-05f, 1.696970021e-05f, 1.579470044e-05f, 1.463304247e-05f, 1.348513575e-05f, 
1.235137531e-05f, 1.123214182e-05f, 1.012780154e-05f, 9.038706330e-06f, 7.965193684e-06f, 6.907586728e-06f, 5.866194255e-06f, 4.841310764e-06f, 3.833216503e-06f, 2.842177519e-06f, 
1.868445716e-06f, 9.122589295e-07f, -2.615900858e-08f, -9.465981827e-07f, -1.848862507e-06f, -2.732769630e-06f, -3.598150832e-06f, -4.444850917e-06f, -5.272728097e-06f, -6.081653872e-06f, 
-6.871512899e-06f, -7.642202862e-06f, -8.393634332e-06f, -9.125730619e-06f, -9.838427626e-06f, -1.053167369e-05f, -1.120542942e-05f, -1.185966753e-05f, -1.249437268e-05f, -1.310954128e-05f, 
-1.370518132e-05f, -1.428131221e-05f, -1.483796452e-05f, -1.537517989e-05f, -1.589301073e-05f, -1.639152010e-05f, -1.687078145e-05f, -1.733087846e-05f, -1.777190479e-05f, -1.819396389e-05f, 
-1.859716877e-05f, -1.898164179e-05f, -1.934751444e-05f, -1.969492712e-05f, -2.002402890e-05f, -2.033497728e-05f, -2.062793802e-05f, -2.090308484e-05f, -2.116059923e-05f, -2.140067018e-05f, 
-2.162349399e-05f, -2.182927400e-05f, -2.201822037e-05f, -2.219054982e-05f, -2.234648542e-05f, -2.248625633e-05f, -2.261009757e-05f, -2.271824978e-05f, -2.281095898e-05f, -2.288847634e-05f, 
-2.295105790e-05f, -2.299896441e-05f, -2.303246101e-05f, -2.305181705e-05f, -2.305730582e-05f, -2.304920434e-05f, -2.302779311e-05f, -2.299335588e-05f, -2.294617942e-05f, -2.288655331e-05f, 
-2.281476967e-05f, -2.273112298e-05f, -2.263590982e-05f, -2.252942867e-05f, -2.241197967e-05f, -2.228386443e-05f, -2.214538578e-05f, -2.199684761e-05f, -2.183855459e-05f, -2.167081201e-05f, 
-2.149392557e-05f, -2.130820115e-05f, -2.111394467e-05f, -2.091146180e-05f, -2.070105788e-05f, -2.048303762e-05f, -2.025770499e-05f, -2.002536302e-05f, -1.978631358e-05f, -1.954085726e-05f, 
-1.928929316e-05f, -1.903191873e-05f, -1.876902961e-05f, -1.850091945e-05f, -1.822787978e-05f, -1.795019983e-05f, -1.766816639e-05f, -1.738206365e-05f, -1.709217309e-05f, -1.679877329e-05f, 
-1.650213984e-05f, -1.620254520e-05f, -1.590025854e-05f, -1.559554566e-05f, -1.528866884e-05f, -1.497988675e-05f, -1.466945431e-05f, -1.435762262e-05f, -1.404463883e-05f, -1.373074603e-05f, 
-1.341618320e-05f, -1.310118507e-05f, -1.278598210e-05f, -1.247080031e-05f, -1.215586127e-05f, -1.184138203e-05f, -1.152757498e-05f, -1.121464786e-05f, -1.090280369e-05f, -1.059224065e-05f, 
-1.028315211e-05f, -9.975726524e-06f, -9.670147411e-06f, -9.366593307e-06f, -9.065237732e-06f, -8.766249151e-06f, -8.469790953e-06f, -8.176021421e-06f, -7.885093711e-06f, -7.597155839e-06f, 
-7.312350661e-06f, -7.030815871e-06f, -6.752683989e-06f, -6.478082358e-06f, -6.207133152e-06f, -5.939953373e-06f, -5.676654863e-06f, -5.417344314e-06f, -5.162123286e-06f, -4.911088220e-06f, 
-4.664330463e-06f, -4.421936292e-06f, -4.183986942e-06f, -3.950558636e-06f, -3.721722618e-06f, -3.497545191e-06f, -3.278087756e-06f, -3.063406857e-06f, -2.853554220e-06f, -2.648576807e-06f, 
-2.448516863e-06f, -2.253411969e-06f, -2.063295098e-06f, -1.878194673e-06f, -1.698134627e-06f, -1.523134463e-06f, -1.353209320e-06f, -1.188370042e-06f, -1.028623241e-06f, -8.739713713e-07f, 
-7.244128008e-07f, -5.799418844e-07f, -4.405490400e-07f, -3.062208261e-07f, -1.769400201e-07f, -5.268569926e-08f
};

AUD_NAMESPACE_END
