package main

// Code generated by peg delocate.peg DO NOT EDIT.

import (
	"fmt"
	"io"
	"os"
	"sort"
	"strconv"
	"strings"
)

const endSymbol rune = 1114112

/* The rule types inferred from the grammar are below. */
type pegRule uint8

const (
	ruleUnknown pegRule = iota
	ruleAsmFile
	ruleStatement
	ruleGlobalDirective
	ruleDirective
	ruleDirectiveName
	ruleLocationDirective
	ruleFileDirective
	ruleLocDirective
	ruleArgs
	ruleArg
	ruleQuotedArg
	ruleQuotedText
	ruleLabelContainingDirective
	ruleLabelContainingDirectiveName
	ruleSymbolArgs
	ruleSymbolArg
	ruleSymbolExpr
	ruleSymbolAtom
	ruleSymbolOperator
	ruleOpenParen
	ruleCloseParen
	ruleSymbolType
	ruleDot
	ruleTCMarker
	ruleEscapedChar
	ruleWS
	ruleComment
	ruleLabel
	ruleSymbolName
	ruleLocalSymbol
	ruleLocalLabel
	ruleLocalLabelRef
	ruleInstructionPrefix
	ruleInstruction
	ruleInstructionName
	ruleInstructionArg
	ruleGOTLocation
	ruleGOTAddress
	ruleGOTSymbolOffset
	ruleAVX512Token
	ruleTOCRefHigh
	ruleTOCRefLow
	ruleIndirectionIndicator
	ruleRegisterOrConstant
	ruleARMConstantTweak
	ruleARMRegister
	ruleARMVectorRegister
	ruleSVE2PredicateRegister
	ruleSVE2SpecialValue
	ruleMemoryRef
	ruleSymbolRef
	ruleLow12BitsSymbolRef
	ruleARMBaseIndexScale
	ruleARMGOTLow12
	ruleARMPostincrement
	ruleBaseIndexScale
	ruleOperator
	ruleOffset
	ruleSection
	ruleSegmentRegister
)

var rul3s = [...]string{
	"Unknown",
	"AsmFile",
	"Statement",
	"GlobalDirective",
	"Directive",
	"DirectiveName",
	"LocationDirective",
	"FileDirective",
	"LocDirective",
	"Args",
	"Arg",
	"QuotedArg",
	"QuotedText",
	"LabelContainingDirective",
	"LabelContainingDirectiveName",
	"SymbolArgs",
	"SymbolArg",
	"SymbolExpr",
	"SymbolAtom",
	"SymbolOperator",
	"OpenParen",
	"CloseParen",
	"SymbolType",
	"Dot",
	"TCMarker",
	"EscapedChar",
	"WS",
	"Comment",
	"Label",
	"SymbolName",
	"LocalSymbol",
	"LocalLabel",
	"LocalLabelRef",
	"InstructionPrefix",
	"Instruction",
	"InstructionName",
	"InstructionArg",
	"GOTLocation",
	"GOTAddress",
	"GOTSymbolOffset",
	"AVX512Token",
	"TOCRefHigh",
	"TOCRefLow",
	"IndirectionIndicator",
	"RegisterOrConstant",
	"ARMConstantTweak",
	"ARMRegister",
	"ARMVectorRegister",
	"SVE2PredicateRegister",
	"SVE2SpecialValue",
	"MemoryRef",
	"SymbolRef",
	"Low12BitsSymbolRef",
	"ARMBaseIndexScale",
	"ARMGOTLow12",
	"ARMPostincrement",
	"BaseIndexScale",
	"Operator",
	"Offset",
	"Section",
	"SegmentRegister",
}

type token32 struct {
	pegRule
	begin, end uint32
}

func (t *token32) String() string {
	return fmt.Sprintf("\x1B[34m%v\x1B[m %v %v", rul3s[t.pegRule], t.begin, t.end)
}

type node32 struct {
	token32
	up, next *node32
}

func (node *node32) print(w io.Writer, pretty bool, buffer string) {
	var print func(node *node32, depth int)
	print = func(node *node32, depth int) {
		for node != nil {
			for c := 0; c < depth; c++ {
				fmt.Fprintf(w, " ")
			}
			rule := rul3s[node.pegRule]
			quote := strconv.Quote(string(([]rune(buffer)[node.begin:node.end])))
			if !pretty {
				fmt.Fprintf(w, "%v %v\n", rule, quote)
			} else {
				fmt.Fprintf(w, "\x1B[36m%v\x1B[m %v\n", rule, quote)
			}
			if node.up != nil {
				print(node.up, depth+1)
			}
			node = node.next
		}
	}
	print(node, 0)
}

func (node *node32) Print(w io.Writer, buffer string) {
	node.print(w, false, buffer)
}

func (node *node32) PrettyPrint(w io.Writer, buffer string) {
	node.print(w, true, buffer)
}

type tokens32 struct {
	tree []token32
}

func (t *tokens32) Trim(length uint32) {
	t.tree = t.tree[:length]
}

func (t *tokens32) Print() {
	for _, token := range t.tree {
		fmt.Println(token.String())
	}
}

func (t *tokens32) AST() *node32 {
	type element struct {
		node *node32
		down *element
	}
	tokens := t.Tokens()
	var stack *element
	for _, token := range tokens {
		if token.begin == token.end {
			continue
		}
		node := &node32{token32: token}
		for stack != nil && stack.node.begin >= token.begin && stack.node.end <= token.end {
			stack.node.next = node.up
			node.up = stack.node
			stack = stack.down
		}
		stack = &element{node: node, down: stack}
	}
	if stack != nil {
		return stack.node
	}
	return nil
}

func (t *tokens32) PrintSyntaxTree(buffer string) {
	t.AST().Print(os.Stdout, buffer)
}

func (t *tokens32) WriteSyntaxTree(w io.Writer, buffer string) {
	t.AST().Print(w, buffer)
}

func (t *tokens32) PrettyPrintSyntaxTree(buffer string) {
	t.AST().PrettyPrint(os.Stdout, buffer)
}

func (t *tokens32) Add(rule pegRule, begin, end, index uint32) {
	tree, i := t.tree, int(index)
	if i >= len(tree) {
		t.tree = append(tree, token32{pegRule: rule, begin: begin, end: end})
		return
	}
	tree[i] = token32{pegRule: rule, begin: begin, end: end}
}

func (t *tokens32) Tokens() []token32 {
	return t.tree
}

type Asm struct {
	Buffer string
	buffer []rune
	rules  [61]func() bool
	parse  func(rule ...int) error
	reset  func()
	Pretty bool
	tokens32
}

func (p *Asm) Parse(rule ...int) error {
	return p.parse(rule...)
}

func (p *Asm) Reset() {
	p.reset()
}

type textPosition struct {
	line, symbol int
}

type textPositionMap map[int]textPosition

func translatePositions(buffer []rune, positions []int) textPositionMap {
	length, translations, j, line, symbol := len(positions), make(textPositionMap, len(positions)), 0, 1, 0
	sort.Ints(positions)

search:
	for i, c := range buffer {
		if c == '\n' {
			line, symbol = line+1, 0
		} else {
			symbol++
		}
		if i == positions[j] {
			translations[positions[j]] = textPosition{line, symbol}
			for j++; j < length; j++ {
				if i != positions[j] {
					continue search
				}
			}
			break search
		}
	}

	return translations
}

type parseError struct {
	p   *Asm
	max token32
}

func (e *parseError) Error() string {
	tokens, err := []token32{e.max}, "\n"
	positions, p := make([]int, 2*len(tokens)), 0
	for _, token := range tokens {
		positions[p], p = int(token.begin), p+1
		positions[p], p = int(token.end), p+1
	}
	translations := translatePositions(e.p.buffer, positions)
	format := "parse error near %v (line %v symbol %v - line %v symbol %v):\n%v\n"
	if e.p.Pretty {
		format = "parse error near \x1B[34m%v\x1B[m (line %v symbol %v - line %v symbol %v):\n%v\n"
	}
	for _, token := range tokens {
		begin, end := int(token.begin), int(token.end)
		err += fmt.Sprintf(format,
			rul3s[token.pegRule],
			translations[begin].line, translations[begin].symbol,
			translations[end].line, translations[end].symbol,
			strconv.Quote(string(e.p.buffer[begin:end])))
	}

	return err
}

func (p *Asm) PrintSyntaxTree() {
	if p.Pretty {
		p.tokens32.PrettyPrintSyntaxTree(p.Buffer)
	} else {
		p.tokens32.PrintSyntaxTree(p.Buffer)
	}
}

func (p *Asm) WriteSyntaxTree(w io.Writer) {
	p.tokens32.WriteSyntaxTree(w, p.Buffer)
}

func (p *Asm) SprintSyntaxTree() string {
	var bldr strings.Builder
	p.WriteSyntaxTree(&bldr)
	return bldr.String()
}

func Pretty(pretty bool) func(*Asm) error {
	return func(p *Asm) error {
		p.Pretty = pretty
		return nil
	}
}

func Size(size int) func(*Asm) error {
	return func(p *Asm) error {
		p.tokens32 = tokens32{tree: make([]token32, 0, size)}
		return nil
	}
}
func (p *Asm) Init(options ...func(*Asm) error) error {
	var (
		max                  token32
		position, tokenIndex uint32
		buffer               []rune
	)
	for _, option := range options {
		err := option(p)
		if err != nil {
			return err
		}
	}
	p.reset = func() {
		max = token32{}
		position, tokenIndex = 0, 0

		p.buffer = []rune(p.Buffer)
		if len(p.buffer) == 0 || p.buffer[len(p.buffer)-1] != endSymbol {
			p.buffer = append(p.buffer, endSymbol)
		}
		buffer = p.buffer
	}
	p.reset()

	_rules := p.rules
	tree := p.tokens32
	p.parse = func(rule ...int) error {
		r := 1
		if len(rule) > 0 {
			r = rule[0]
		}
		matches := p.rules[r]()
		p.tokens32 = tree
		if matches {
			p.Trim(tokenIndex)
			return nil
		}
		return &parseError{p, max}
	}

	add := func(rule pegRule, begin uint32) {
		tree.Add(rule, begin, position, tokenIndex)
		tokenIndex++
		if begin != position && position > max.end {
			max = token32{rule, begin, position}
		}
	}

	matchDot := func() bool {
		if buffer[position] != endSymbol {
			position++
			return true
		}
		return false
	}

	/*matchChar := func(c byte) bool {
		if buffer[position] == c {
			position++
			return true
		}
		return false
	}*/

	/*matchRange := func(lower byte, upper byte) bool {
		if c := buffer[position]; c >= lower && c <= upper {
			position++
			return true
		}
		return false
	}*/

	_rules = [...]func() bool{
		nil,
		/* 0 AsmFile <- <(Statement* !.)> */
		func() bool {
			position0, tokenIndex0 := position, tokenIndex
			{
				position1 := position
			l2:
				{
					position3, tokenIndex3 := position, tokenIndex
					if !_rules[ruleStatement]() {
						goto l3
					}
					goto l2
				l3:
					position, tokenIndex = position3, tokenIndex3
				}
				{
					position4, tokenIndex4 := position, tokenIndex
					if !matchDot() {
						goto l4
					}
					goto l0
				l4:
					position, tokenIndex = position4, tokenIndex4
				}
				add(ruleAsmFile, position1)
			}
			return true
		l0:
			position, tokenIndex = position0, tokenIndex0
			return false
		},
		/* 1 Statement <- <(WS? (Label / ((GlobalDirective / LocationDirective / LabelContainingDirective / Instruction / Directive / Comment / ) WS? ((Comment? '\n') / ';'))))> */
		func() bool {
			position5, tokenIndex5 := position, tokenIndex
			{
				position6 := position
				{
					position7, tokenIndex7 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l7
					}
					goto l8
				l7:
					position, tokenIndex = position7, tokenIndex7
				}
			l8:
				{
					position9, tokenIndex9 := position, tokenIndex
					if !_rules[ruleLabel]() {
						goto l10
					}
					goto l9
				l10:
					position, tokenIndex = position9, tokenIndex9
					{
						position11, tokenIndex11 := position, tokenIndex
						if !_rules[ruleGlobalDirective]() {
							goto l12
						}
						goto l11
					l12:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleLocationDirective]() {
							goto l13
						}
						goto l11
					l13:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleLabelContainingDirective]() {
							goto l14
						}
						goto l11
					l14:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleInstruction]() {
							goto l15
						}
						goto l11
					l15:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleDirective]() {
							goto l16
						}
						goto l11
					l16:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleComment]() {
							goto l17
						}
						goto l11
					l17:
						position, tokenIndex = position11, tokenIndex11
					}
				l11:
					{
						position18, tokenIndex18 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l18
						}
						goto l19
					l18:
						position, tokenIndex = position18, tokenIndex18
					}
				l19:
					{
						position20, tokenIndex20 := position, tokenIndex
						{
							position22, tokenIndex22 := position, tokenIndex
							if !_rules[ruleComment]() {
								goto l22
							}
							goto l23
						l22:
							position, tokenIndex = position22, tokenIndex22
						}
					l23:
						if buffer[position] != rune('\n') {
							goto l21
						}
						position++
						goto l20
					l21:
						position, tokenIndex = position20, tokenIndex20
						if buffer[position] != rune(';') {
							goto l5
						}
						position++
					}
				l20:
				}
			l9:
				add(ruleStatement, position6)
			}
			return true
		l5:
			position, tokenIndex = position5, tokenIndex5
			return false
		},
		/* 2 GlobalDirective <- <((('.' ('g' / 'G') ('l' / 'L') ('o' / 'O') ('b' / 'B') ('a' / 'A') ('l' / 'L')) / ('.' ('g' / 'G') ('l' / 'L') ('o' / 'O') ('b' / 'B') ('l' / 'L'))) WS SymbolName)> */
		func() bool {
			position24, tokenIndex24 := position, tokenIndex
			{
				position25 := position
				{
					position26, tokenIndex26 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l27
					}
					position++
					{
						position28, tokenIndex28 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l29
						}
						position++
						goto l28
					l29:
						position, tokenIndex = position28, tokenIndex28
						if buffer[position] != rune('G') {
							goto l27
						}
						position++
					}
				l28:
					{
						position30, tokenIndex30 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l31
						}
						position++
						goto l30
					l31:
						position, tokenIndex = position30, tokenIndex30
						if buffer[position] != rune('L') {
							goto l27
						}
						position++
					}
				l30:
					{
						position32, tokenIndex32 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l33
						}
						position++
						goto l32
					l33:
						position, tokenIndex = position32, tokenIndex32
						if buffer[position] != rune('O') {
							goto l27
						}
						position++
					}
				l32:
					{
						position34, tokenIndex34 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l35
						}
						position++
						goto l34
					l35:
						position, tokenIndex = position34, tokenIndex34
						if buffer[position] != rune('B') {
							goto l27
						}
						position++
					}
				l34:
					{
						position36, tokenIndex36 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l37
						}
						position++
						goto l36
					l37:
						position, tokenIndex = position36, tokenIndex36
						if buffer[position] != rune('A') {
							goto l27
						}
						position++
					}
				l36:
					{
						position38, tokenIndex38 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l39
						}
						position++
						goto l38
					l39:
						position, tokenIndex = position38, tokenIndex38
						if buffer[position] != rune('L') {
							goto l27
						}
						position++
					}
				l38:
					goto l26
				l27:
					position, tokenIndex = position26, tokenIndex26
					if buffer[position] != rune('.') {
						goto l24
					}
					position++
					{
						position40, tokenIndex40 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l41
						}
						position++
						goto l40
					l41:
						position, tokenIndex = position40, tokenIndex40
						if buffer[position] != rune('G') {
							goto l24
						}
						position++
					}
				l40:
					{
						position42, tokenIndex42 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l43
						}
						position++
						goto l42
					l43:
						position, tokenIndex = position42, tokenIndex42
						if buffer[position] != rune('L') {
							goto l24
						}
						position++
					}
				l42:
					{
						position44, tokenIndex44 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l45
						}
						position++
						goto l44
					l45:
						position, tokenIndex = position44, tokenIndex44
						if buffer[position] != rune('O') {
							goto l24
						}
						position++
					}
				l44:
					{
						position46, tokenIndex46 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l47
						}
						position++
						goto l46
					l47:
						position, tokenIndex = position46, tokenIndex46
						if buffer[position] != rune('B') {
							goto l24
						}
						position++
					}
				l46:
					{
						position48, tokenIndex48 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l49
						}
						position++
						goto l48
					l49:
						position, tokenIndex = position48, tokenIndex48
						if buffer[position] != rune('L') {
							goto l24
						}
						position++
					}
				l48:
				}
			l26:
				if !_rules[ruleWS]() {
					goto l24
				}
				if !_rules[ruleSymbolName]() {
					goto l24
				}
				add(ruleGlobalDirective, position25)
			}
			return true
		l24:
			position, tokenIndex = position24, tokenIndex24
			return false
		},
		/* 3 Directive <- <('.' DirectiveName (WS Args)?)> */
		func() bool {
			position50, tokenIndex50 := position, tokenIndex
			{
				position51 := position
				if buffer[position] != rune('.') {
					goto l50
				}
				position++
				if !_rules[ruleDirectiveName]() {
					goto l50
				}
				{
					position52, tokenIndex52 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l52
					}
					if !_rules[ruleArgs]() {
						goto l52
					}
					goto l53
				l52:
					position, tokenIndex = position52, tokenIndex52
				}
			l53:
				add(ruleDirective, position51)
			}
			return true
		l50:
			position, tokenIndex = position50, tokenIndex50
			return false
		},
		/* 4 DirectiveName <- <([a-z] / [A-Z] / ([0-9] / [0-9]) / '_')+> */
		func() bool {
			position54, tokenIndex54 := position, tokenIndex
			{
				position55 := position
				{
					position58, tokenIndex58 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l59
					}
					position++
					goto l58
				l59:
					position, tokenIndex = position58, tokenIndex58
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l60
					}
					position++
					goto l58
				l60:
					position, tokenIndex = position58, tokenIndex58
					{
						position62, tokenIndex62 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l63
						}
						position++
						goto l62
					l63:
						position, tokenIndex = position62, tokenIndex62
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l61
						}
						position++
					}
				l62:
					goto l58
				l61:
					position, tokenIndex = position58, tokenIndex58
					if buffer[position] != rune('_') {
						goto l54
					}
					position++
				}
			l58:
			l56:
				{
					position57, tokenIndex57 := position, tokenIndex
					{
						position64, tokenIndex64 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l65
						}
						position++
						goto l64
					l65:
						position, tokenIndex = position64, tokenIndex64
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l66
						}
						position++
						goto l64
					l66:
						position, tokenIndex = position64, tokenIndex64
						{
							position68, tokenIndex68 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l69
							}
							position++
							goto l68
						l69:
							position, tokenIndex = position68, tokenIndex68
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l67
							}
							position++
						}
					l68:
						goto l64
					l67:
						position, tokenIndex = position64, tokenIndex64
						if buffer[position] != rune('_') {
							goto l57
						}
						position++
					}
				l64:
					goto l56
				l57:
					position, tokenIndex = position57, tokenIndex57
				}
				add(ruleDirectiveName, position55)
			}
			return true
		l54:
			position, tokenIndex = position54, tokenIndex54
			return false
		},
		/* 5 LocationDirective <- <(FileDirective / LocDirective)> */
		func() bool {
			position70, tokenIndex70 := position, tokenIndex
			{
				position71 := position
				{
					position72, tokenIndex72 := position, tokenIndex
					if !_rules[ruleFileDirective]() {
						goto l73
					}
					goto l72
				l73:
					position, tokenIndex = position72, tokenIndex72
					if !_rules[ruleLocDirective]() {
						goto l70
					}
				}
			l72:
				add(ruleLocationDirective, position71)
			}
			return true
		l70:
			position, tokenIndex = position70, tokenIndex70
			return false
		},
		/* 6 FileDirective <- <('.' ('f' / 'F') ('i' / 'I') ('l' / 'L') ('e' / 'E') WS (!('#' / '\n') .)+)> */
		func() bool {
			position74, tokenIndex74 := position, tokenIndex
			{
				position75 := position
				if buffer[position] != rune('.') {
					goto l74
				}
				position++
				{
					position76, tokenIndex76 := position, tokenIndex
					if buffer[position] != rune('f') {
						goto l77
					}
					position++
					goto l76
				l77:
					position, tokenIndex = position76, tokenIndex76
					if buffer[position] != rune('F') {
						goto l74
					}
					position++
				}
			l76:
				{
					position78, tokenIndex78 := position, tokenIndex
					if buffer[position] != rune('i') {
						goto l79
					}
					position++
					goto l78
				l79:
					position, tokenIndex = position78, tokenIndex78
					if buffer[position] != rune('I') {
						goto l74
					}
					position++
				}
			l78:
				{
					position80, tokenIndex80 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l81
					}
					position++
					goto l80
				l81:
					position, tokenIndex = position80, tokenIndex80
					if buffer[position] != rune('L') {
						goto l74
					}
					position++
				}
			l80:
				{
					position82, tokenIndex82 := position, tokenIndex
					if buffer[position] != rune('e') {
						goto l83
					}
					position++
					goto l82
				l83:
					position, tokenIndex = position82, tokenIndex82
					if buffer[position] != rune('E') {
						goto l74
					}
					position++
				}
			l82:
				if !_rules[ruleWS]() {
					goto l74
				}
				{
					position86, tokenIndex86 := position, tokenIndex
					{
						position87, tokenIndex87 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l88
						}
						position++
						goto l87
					l88:
						position, tokenIndex = position87, tokenIndex87
						if buffer[position] != rune('\n') {
							goto l86
						}
						position++
					}
				l87:
					goto l74
				l86:
					position, tokenIndex = position86, tokenIndex86
				}
				if !matchDot() {
					goto l74
				}
			l84:
				{
					position85, tokenIndex85 := position, tokenIndex
					{
						position89, tokenIndex89 := position, tokenIndex
						{
							position90, tokenIndex90 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l91
							}
							position++
							goto l90
						l91:
							position, tokenIndex = position90, tokenIndex90
							if buffer[position] != rune('\n') {
								goto l89
							}
							position++
						}
					l90:
						goto l85
					l89:
						position, tokenIndex = position89, tokenIndex89
					}
					if !matchDot() {
						goto l85
					}
					goto l84
				l85:
					position, tokenIndex = position85, tokenIndex85
				}
				add(ruleFileDirective, position75)
			}
			return true
		l74:
			position, tokenIndex = position74, tokenIndex74
			return false
		},
		/* 7 LocDirective <- <('.' ('l' / 'L') ('o' / 'O') ('c' / 'C') WS (!('#' / '/' / '\n') .)+)> */
		func() bool {
			position92, tokenIndex92 := position, tokenIndex
			{
				position93 := position
				if buffer[position] != rune('.') {
					goto l92
				}
				position++
				{
					position94, tokenIndex94 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l95
					}
					position++
					goto l94
				l95:
					position, tokenIndex = position94, tokenIndex94
					if buffer[position] != rune('L') {
						goto l92
					}
					position++
				}
			l94:
				{
					position96, tokenIndex96 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l97
					}
					position++
					goto l96
				l97:
					position, tokenIndex = position96, tokenIndex96
					if buffer[position] != rune('O') {
						goto l92
					}
					position++
				}
			l96:
				{
					position98, tokenIndex98 := position, tokenIndex
					if buffer[position] != rune('c') {
						goto l99
					}
					position++
					goto l98
				l99:
					position, tokenIndex = position98, tokenIndex98
					if buffer[position] != rune('C') {
						goto l92
					}
					position++
				}
			l98:
				if !_rules[ruleWS]() {
					goto l92
				}
				{
					position102, tokenIndex102 := position, tokenIndex
					{
						position103, tokenIndex103 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l104
						}
						position++
						goto l103
					l104:
						position, tokenIndex = position103, tokenIndex103
						if buffer[position] != rune('/') {
							goto l105
						}
						position++
						goto l103
					l105:
						position, tokenIndex = position103, tokenIndex103
						if buffer[position] != rune('\n') {
							goto l102
						}
						position++
					}
				l103:
					goto l92
				l102:
					position, tokenIndex = position102, tokenIndex102
				}
				if !matchDot() {
					goto l92
				}
			l100:
				{
					position101, tokenIndex101 := position, tokenIndex
					{
						position106, tokenIndex106 := position, tokenIndex
						{
							position107, tokenIndex107 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l108
							}
							position++
							goto l107
						l108:
							position, tokenIndex = position107, tokenIndex107
							if buffer[position] != rune('/') {
								goto l109
							}
							position++
							goto l107
						l109:
							position, tokenIndex = position107, tokenIndex107
							if buffer[position] != rune('\n') {
								goto l106
							}
							position++
						}
					l107:
						goto l101
					l106:
						position, tokenIndex = position106, tokenIndex106
					}
					if !matchDot() {
						goto l101
					}
					goto l100
				l101:
					position, tokenIndex = position101, tokenIndex101
				}
				add(ruleLocDirective, position93)
			}
			return true
		l92:
			position, tokenIndex = position92, tokenIndex92
			return false
		},
		/* 8 Args <- <(Arg (WS? ',' WS? Arg)*)> */
		func() bool {
			position110, tokenIndex110 := position, tokenIndex
			{
				position111 := position
				if !_rules[ruleArg]() {
					goto l110
				}
			l112:
				{
					position113, tokenIndex113 := position, tokenIndex
					{
						position114, tokenIndex114 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l114
						}
						goto l115
					l114:
						position, tokenIndex = position114, tokenIndex114
					}
				l115:
					if buffer[position] != rune(',') {
						goto l113
					}
					position++
					{
						position116, tokenIndex116 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l116
						}
						goto l117
					l116:
						position, tokenIndex = position116, tokenIndex116
					}
				l117:
					if !_rules[ruleArg]() {
						goto l113
					}
					goto l112
				l113:
					position, tokenIndex = position113, tokenIndex113
				}
				add(ruleArgs, position111)
			}
			return true
		l110:
			position, tokenIndex = position110, tokenIndex110
			return false
		},
		/* 9 Arg <- <(QuotedArg / ([0-9] / [0-9] / ([a-z] / [A-Z]) / '%' / '+' / '-' / '*' / '_' / '@' / '.')*)> */
		func() bool {
			{
				position119 := position
				{
					position120, tokenIndex120 := position, tokenIndex
					if !_rules[ruleQuotedArg]() {
						goto l121
					}
					goto l120
				l121:
					position, tokenIndex = position120, tokenIndex120
				l122:
					{
						position123, tokenIndex123 := position, tokenIndex
						{
							position124, tokenIndex124 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l125
							}
							position++
							goto l124
						l125:
							position, tokenIndex = position124, tokenIndex124
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l126
							}
							position++
							goto l124
						l126:
							position, tokenIndex = position124, tokenIndex124
							{
								position128, tokenIndex128 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l129
								}
								position++
								goto l128
							l129:
								position, tokenIndex = position128, tokenIndex128
								if c := buffer[position]; c < rune('A') || c > rune('Z') {
									goto l127
								}
								position++
							}
						l128:
							goto l124
						l127:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('%') {
								goto l130
							}
							position++
							goto l124
						l130:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('+') {
								goto l131
							}
							position++
							goto l124
						l131:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('-') {
								goto l132
							}
							position++
							goto l124
						l132:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('*') {
								goto l133
							}
							position++
							goto l124
						l133:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('_') {
								goto l134
							}
							position++
							goto l124
						l134:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('@') {
								goto l135
							}
							position++
							goto l124
						l135:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('.') {
								goto l123
							}
							position++
						}
					l124:
						goto l122
					l123:
						position, tokenIndex = position123, tokenIndex123
					}
				}
			l120:
				add(ruleArg, position119)
			}
			return true
		},
		/* 10 QuotedArg <- <('"' QuotedText '"')> */
		func() bool {
			position136, tokenIndex136 := position, tokenIndex
			{
				position137 := position
				if buffer[position] != rune('"') {
					goto l136
				}
				position++
				if !_rules[ruleQuotedText]() {
					goto l136
				}
				if buffer[position] != rune('"') {
					goto l136
				}
				position++
				add(ruleQuotedArg, position137)
			}
			return true
		l136:
			position, tokenIndex = position136, tokenIndex136
			return false
		},
		/* 11 QuotedText <- <(EscapedChar / (!'"' .))*> */
		func() bool {
			{
				position139 := position
			l140:
				{
					position141, tokenIndex141 := position, tokenIndex
					{
						position142, tokenIndex142 := position, tokenIndex
						if !_rules[ruleEscapedChar]() {
							goto l143
						}
						goto l142
					l143:
						position, tokenIndex = position142, tokenIndex142
						{
							position144, tokenIndex144 := position, tokenIndex
							if buffer[position] != rune('"') {
								goto l144
							}
							position++
							goto l141
						l144:
							position, tokenIndex = position144, tokenIndex144
						}
						if !matchDot() {
							goto l141
						}
					}
				l142:
					goto l140
				l141:
					position, tokenIndex = position141, tokenIndex141
				}
				add(ruleQuotedText, position139)
			}
			return true
		},
		/* 12 LabelContainingDirective <- <(LabelContainingDirectiveName WS SymbolArgs)> */
		func() bool {
			position145, tokenIndex145 := position, tokenIndex
			{
				position146 := position
				if !_rules[ruleLabelContainingDirectiveName]() {
					goto l145
				}
				if !_rules[ruleWS]() {
					goto l145
				}
				if !_rules[ruleSymbolArgs]() {
					goto l145
				}
				add(ruleLabelContainingDirective, position146)
			}
			return true
		l145:
			position, tokenIndex = position145, tokenIndex145
			return false
		},
		/* 13 LabelContainingDirectiveName <- <(('.' ('x' / 'X') ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('h' / 'H') ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('l' / 'L') ('o' / 'O') ('n' / 'N') ('g' / 'G')) / ('.' ('s' / 'S') ('e' / 'E') ('t' / 'T')) / ('.' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' '8' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' '4' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' ('q' / 'Q') ('u' / 'U') ('a' / 'A') ('d' / 'D')) / ('.' ('t' / 'T') ('c' / 'C')) / ('.' ('l' / 'L') ('o' / 'O') ('c' / 'C') ('a' / 'A') ('l' / 'L') ('e' / 'E') ('n' / 'N') ('t' / 'T') ('r' / 'R') ('y' / 'Y')) / ('.' ('s' / 'S') ('i' / 'I') ('z' / 'Z') ('e' / 'E')) / ('.' ('t' / 'T') ('y' / 'Y') ('p' / 'P') ('e' / 'E')) / ('.' ('u' / 'U') ('l' / 'L') ('e' / 'E') ('b' / 'B') '1' '2' '8') / ('.' ('s' / 'S') ('l' / 'L') ('e' / 'E') ('b' / 'B') '1' '2' '8'))> */
		func() bool {
			position147, tokenIndex147 := position, tokenIndex
			{
				position148 := position
				{
					position149, tokenIndex149 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l150
					}
					position++
					{
						position151, tokenIndex151 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l152
						}
						position++
						goto l151
					l152:
						position, tokenIndex = position151, tokenIndex151
						if buffer[position] != rune('X') {
							goto l150
						}
						position++
					}
				l151:
					{
						position153, tokenIndex153 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l154
						}
						position++
						goto l153
					l154:
						position, tokenIndex = position153, tokenIndex153
						if buffer[position] != rune('W') {
							goto l150
						}
						position++
					}
				l153:
					{
						position155, tokenIndex155 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l156
						}
						position++
						goto l155
					l156:
						position, tokenIndex = position155, tokenIndex155
						if buffer[position] != rune('O') {
							goto l150
						}
						position++
					}
				l155:
					{
						position157, tokenIndex157 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l158
						}
						position++
						goto l157
					l158:
						position, tokenIndex = position157, tokenIndex157
						if buffer[position] != rune('R') {
							goto l150
						}
						position++
					}
				l157:
					{
						position159, tokenIndex159 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l160
						}
						position++
						goto l159
					l160:
						position, tokenIndex = position159, tokenIndex159
						if buffer[position] != rune('D') {
							goto l150
						}
						position++
					}
				l159:
					goto l149
				l150:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l161
					}
					position++
					{
						position162, tokenIndex162 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l163
						}
						position++
						goto l162
					l163:
						position, tokenIndex = position162, tokenIndex162
						if buffer[position] != rune('W') {
							goto l161
						}
						position++
					}
				l162:
					{
						position164, tokenIndex164 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l165
						}
						position++
						goto l164
					l165:
						position, tokenIndex = position164, tokenIndex164
						if buffer[position] != rune('O') {
							goto l161
						}
						position++
					}
				l164:
					{
						position166, tokenIndex166 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l167
						}
						position++
						goto l166
					l167:
						position, tokenIndex = position166, tokenIndex166
						if buffer[position] != rune('R') {
							goto l161
						}
						position++
					}
				l166:
					{
						position168, tokenIndex168 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l169
						}
						position++
						goto l168
					l169:
						position, tokenIndex = position168, tokenIndex168
						if buffer[position] != rune('D') {
							goto l161
						}
						position++
					}
				l168:
					goto l149
				l161:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l170
					}
					position++
					{
						position171, tokenIndex171 := position, tokenIndex
						if buffer[position] != rune('h') {
							goto l172
						}
						position++
						goto l171
					l172:
						position, tokenIndex = position171, tokenIndex171
						if buffer[position] != rune('H') {
							goto l170
						}
						position++
					}
				l171:
					{
						position173, tokenIndex173 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l174
						}
						position++
						goto l173
					l174:
						position, tokenIndex = position173, tokenIndex173
						if buffer[position] != rune('W') {
							goto l170
						}
						position++
					}
				l173:
					{
						position175, tokenIndex175 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l176
						}
						position++
						goto l175
					l176:
						position, tokenIndex = position175, tokenIndex175
						if buffer[position] != rune('O') {
							goto l170
						}
						position++
					}
				l175:
					{
						position177, tokenIndex177 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l178
						}
						position++
						goto l177
					l178:
						position, tokenIndex = position177, tokenIndex177
						if buffer[position] != rune('R') {
							goto l170
						}
						position++
					}
				l177:
					{
						position179, tokenIndex179 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l180
						}
						position++
						goto l179
					l180:
						position, tokenIndex = position179, tokenIndex179
						if buffer[position] != rune('D') {
							goto l170
						}
						position++
					}
				l179:
					goto l149
				l170:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l181
					}
					position++
					{
						position182, tokenIndex182 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l183
						}
						position++
						goto l182
					l183:
						position, tokenIndex = position182, tokenIndex182
						if buffer[position] != rune('L') {
							goto l181
						}
						position++
					}
				l182:
					{
						position184, tokenIndex184 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l185
						}
						position++
						goto l184
					l185:
						position, tokenIndex = position184, tokenIndex184
						if buffer[position] != rune('O') {
							goto l181
						}
						position++
					}
				l184:
					{
						position186, tokenIndex186 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l187
						}
						position++
						goto l186
					l187:
						position, tokenIndex = position186, tokenIndex186
						if buffer[position] != rune('N') {
							goto l181
						}
						position++
					}
				l186:
					{
						position188, tokenIndex188 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l189
						}
						position++
						goto l188
					l189:
						position, tokenIndex = position188, tokenIndex188
						if buffer[position] != rune('G') {
							goto l181
						}
						position++
					}
				l188:
					goto l149
				l181:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l190
					}
					position++
					{
						position191, tokenIndex191 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l192
						}
						position++
						goto l191
					l192:
						position, tokenIndex = position191, tokenIndex191
						if buffer[position] != rune('S') {
							goto l190
						}
						position++
					}
				l191:
					{
						position193, tokenIndex193 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l194
						}
						position++
						goto l193
					l194:
						position, tokenIndex = position193, tokenIndex193
						if buffer[position] != rune('E') {
							goto l190
						}
						position++
					}
				l193:
					{
						position195, tokenIndex195 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l196
						}
						position++
						goto l195
					l196:
						position, tokenIndex = position195, tokenIndex195
						if buffer[position] != rune('T') {
							goto l190
						}
						position++
					}
				l195:
					goto l149
				l190:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l197
					}
					position++
					{
						position198, tokenIndex198 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l199
						}
						position++
						goto l198
					l199:
						position, tokenIndex = position198, tokenIndex198
						if buffer[position] != rune('B') {
							goto l197
						}
						position++
					}
				l198:
					{
						position200, tokenIndex200 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l201
						}
						position++
						goto l200
					l201:
						position, tokenIndex = position200, tokenIndex200
						if buffer[position] != rune('Y') {
							goto l197
						}
						position++
					}
				l200:
					{
						position202, tokenIndex202 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l203
						}
						position++
						goto l202
					l203:
						position, tokenIndex = position202, tokenIndex202
						if buffer[position] != rune('T') {
							goto l197
						}
						position++
					}
				l202:
					{
						position204, tokenIndex204 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l205
						}
						position++
						goto l204
					l205:
						position, tokenIndex = position204, tokenIndex204
						if buffer[position] != rune('E') {
							goto l197
						}
						position++
					}
				l204:
					goto l149
				l197:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l206
					}
					position++
					if buffer[position] != rune('8') {
						goto l206
					}
					position++
					{
						position207, tokenIndex207 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l208
						}
						position++
						goto l207
					l208:
						position, tokenIndex = position207, tokenIndex207
						if buffer[position] != rune('B') {
							goto l206
						}
						position++
					}
				l207:
					{
						position209, tokenIndex209 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l210
						}
						position++
						goto l209
					l210:
						position, tokenIndex = position209, tokenIndex209
						if buffer[position] != rune('Y') {
							goto l206
						}
						position++
					}
				l209:
					{
						position211, tokenIndex211 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l212
						}
						position++
						goto l211
					l212:
						position, tokenIndex = position211, tokenIndex211
						if buffer[position] != rune('T') {
							goto l206
						}
						position++
					}
				l211:
					{
						position213, tokenIndex213 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l214
						}
						position++
						goto l213
					l214:
						position, tokenIndex = position213, tokenIndex213
						if buffer[position] != rune('E') {
							goto l206
						}
						position++
					}
				l213:
					goto l149
				l206:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l215
					}
					position++
					if buffer[position] != rune('4') {
						goto l215
					}
					position++
					{
						position216, tokenIndex216 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l217
						}
						position++
						goto l216
					l217:
						position, tokenIndex = position216, tokenIndex216
						if buffer[position] != rune('B') {
							goto l215
						}
						position++
					}
				l216:
					{
						position218, tokenIndex218 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l219
						}
						position++
						goto l218
					l219:
						position, tokenIndex = position218, tokenIndex218
						if buffer[position] != rune('Y') {
							goto l215
						}
						position++
					}
				l218:
					{
						position220, tokenIndex220 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l221
						}
						position++
						goto l220
					l221:
						position, tokenIndex = position220, tokenIndex220
						if buffer[position] != rune('T') {
							goto l215
						}
						position++
					}
				l220:
					{
						position222, tokenIndex222 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l223
						}
						position++
						goto l222
					l223:
						position, tokenIndex = position222, tokenIndex222
						if buffer[position] != rune('E') {
							goto l215
						}
						position++
					}
				l222:
					goto l149
				l215:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l224
					}
					position++
					{
						position225, tokenIndex225 := position, tokenIndex
						if buffer[position] != rune('q') {
							goto l226
						}
						position++
						goto l225
					l226:
						position, tokenIndex = position225, tokenIndex225
						if buffer[position] != rune('Q') {
							goto l224
						}
						position++
					}
				l225:
					{
						position227, tokenIndex227 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l228
						}
						position++
						goto l227
					l228:
						position, tokenIndex = position227, tokenIndex227
						if buffer[position] != rune('U') {
							goto l224
						}
						position++
					}
				l227:
					{
						position229, tokenIndex229 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l230
						}
						position++
						goto l229
					l230:
						position, tokenIndex = position229, tokenIndex229
						if buffer[position] != rune('A') {
							goto l224
						}
						position++
					}
				l229:
					{
						position231, tokenIndex231 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l232
						}
						position++
						goto l231
					l232:
						position, tokenIndex = position231, tokenIndex231
						if buffer[position] != rune('D') {
							goto l224
						}
						position++
					}
				l231:
					goto l149
				l224:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l233
					}
					position++
					{
						position234, tokenIndex234 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l235
						}
						position++
						goto l234
					l235:
						position, tokenIndex = position234, tokenIndex234
						if buffer[position] != rune('T') {
							goto l233
						}
						position++
					}
				l234:
					{
						position236, tokenIndex236 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l237
						}
						position++
						goto l236
					l237:
						position, tokenIndex = position236, tokenIndex236
						if buffer[position] != rune('C') {
							goto l233
						}
						position++
					}
				l236:
					goto l149
				l233:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l238
					}
					position++
					{
						position239, tokenIndex239 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l240
						}
						position++
						goto l239
					l240:
						position, tokenIndex = position239, tokenIndex239
						if buffer[position] != rune('L') {
							goto l238
						}
						position++
					}
				l239:
					{
						position241, tokenIndex241 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l242
						}
						position++
						goto l241
					l242:
						position, tokenIndex = position241, tokenIndex241
						if buffer[position] != rune('O') {
							goto l238
						}
						position++
					}
				l241:
					{
						position243, tokenIndex243 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l244
						}
						position++
						goto l243
					l244:
						position, tokenIndex = position243, tokenIndex243
						if buffer[position] != rune('C') {
							goto l238
						}
						position++
					}
				l243:
					{
						position245, tokenIndex245 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l246
						}
						position++
						goto l245
					l246:
						position, tokenIndex = position245, tokenIndex245
						if buffer[position] != rune('A') {
							goto l238
						}
						position++
					}
				l245:
					{
						position247, tokenIndex247 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l248
						}
						position++
						goto l247
					l248:
						position, tokenIndex = position247, tokenIndex247
						if buffer[position] != rune('L') {
							goto l238
						}
						position++
					}
				l247:
					{
						position249, tokenIndex249 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l250
						}
						position++
						goto l249
					l250:
						position, tokenIndex = position249, tokenIndex249
						if buffer[position] != rune('E') {
							goto l238
						}
						position++
					}
				l249:
					{
						position251, tokenIndex251 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l252
						}
						position++
						goto l251
					l252:
						position, tokenIndex = position251, tokenIndex251
						if buffer[position] != rune('N') {
							goto l238
						}
						position++
					}
				l251:
					{
						position253, tokenIndex253 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l254
						}
						position++
						goto l253
					l254:
						position, tokenIndex = position253, tokenIndex253
						if buffer[position] != rune('T') {
							goto l238
						}
						position++
					}
				l253:
					{
						position255, tokenIndex255 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l256
						}
						position++
						goto l255
					l256:
						position, tokenIndex = position255, tokenIndex255
						if buffer[position] != rune('R') {
							goto l238
						}
						position++
					}
				l255:
					{
						position257, tokenIndex257 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l258
						}
						position++
						goto l257
					l258:
						position, tokenIndex = position257, tokenIndex257
						if buffer[position] != rune('Y') {
							goto l238
						}
						position++
					}
				l257:
					goto l149
				l238:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l259
					}
					position++
					{
						position260, tokenIndex260 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l261
						}
						position++
						goto l260
					l261:
						position, tokenIndex = position260, tokenIndex260
						if buffer[position] != rune('S') {
							goto l259
						}
						position++
					}
				l260:
					{
						position262, tokenIndex262 := position, tokenIndex
						if buffer[position] != rune('i') {
							goto l263
						}
						position++
						goto l262
					l263:
						position, tokenIndex = position262, tokenIndex262
						if buffer[position] != rune('I') {
							goto l259
						}
						position++
					}
				l262:
					{
						position264, tokenIndex264 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l265
						}
						position++
						goto l264
					l265:
						position, tokenIndex = position264, tokenIndex264
						if buffer[position] != rune('Z') {
							goto l259
						}
						position++
					}
				l264:
					{
						position266, tokenIndex266 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l267
						}
						position++
						goto l266
					l267:
						position, tokenIndex = position266, tokenIndex266
						if buffer[position] != rune('E') {
							goto l259
						}
						position++
					}
				l266:
					goto l149
				l259:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l268
					}
					position++
					{
						position269, tokenIndex269 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l270
						}
						position++
						goto l269
					l270:
						position, tokenIndex = position269, tokenIndex269
						if buffer[position] != rune('T') {
							goto l268
						}
						position++
					}
				l269:
					{
						position271, tokenIndex271 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l272
						}
						position++
						goto l271
					l272:
						position, tokenIndex = position271, tokenIndex271
						if buffer[position] != rune('Y') {
							goto l268
						}
						position++
					}
				l271:
					{
						position273, tokenIndex273 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l274
						}
						position++
						goto l273
					l274:
						position, tokenIndex = position273, tokenIndex273
						if buffer[position] != rune('P') {
							goto l268
						}
						position++
					}
				l273:
					{
						position275, tokenIndex275 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l276
						}
						position++
						goto l275
					l276:
						position, tokenIndex = position275, tokenIndex275
						if buffer[position] != rune('E') {
							goto l268
						}
						position++
					}
				l275:
					goto l149
				l268:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l277
					}
					position++
					{
						position278, tokenIndex278 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l279
						}
						position++
						goto l278
					l279:
						position, tokenIndex = position278, tokenIndex278
						if buffer[position] != rune('U') {
							goto l277
						}
						position++
					}
				l278:
					{
						position280, tokenIndex280 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l281
						}
						position++
						goto l280
					l281:
						position, tokenIndex = position280, tokenIndex280
						if buffer[position] != rune('L') {
							goto l277
						}
						position++
					}
				l280:
					{
						position282, tokenIndex282 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l283
						}
						position++
						goto l282
					l283:
						position, tokenIndex = position282, tokenIndex282
						if buffer[position] != rune('E') {
							goto l277
						}
						position++
					}
				l282:
					{
						position284, tokenIndex284 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l285
						}
						position++
						goto l284
					l285:
						position, tokenIndex = position284, tokenIndex284
						if buffer[position] != rune('B') {
							goto l277
						}
						position++
					}
				l284:
					if buffer[position] != rune('1') {
						goto l277
					}
					position++
					if buffer[position] != rune('2') {
						goto l277
					}
					position++
					if buffer[position] != rune('8') {
						goto l277
					}
					position++
					goto l149
				l277:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l147
					}
					position++
					{
						position286, tokenIndex286 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l287
						}
						position++
						goto l286
					l287:
						position, tokenIndex = position286, tokenIndex286
						if buffer[position] != rune('S') {
							goto l147
						}
						position++
					}
				l286:
					{
						position288, tokenIndex288 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l289
						}
						position++
						goto l288
					l289:
						position, tokenIndex = position288, tokenIndex288
						if buffer[position] != rune('L') {
							goto l147
						}
						position++
					}
				l288:
					{
						position290, tokenIndex290 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l291
						}
						position++
						goto l290
					l291:
						position, tokenIndex = position290, tokenIndex290
						if buffer[position] != rune('E') {
							goto l147
						}
						position++
					}
				l290:
					{
						position292, tokenIndex292 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l293
						}
						position++
						goto l292
					l293:
						position, tokenIndex = position292, tokenIndex292
						if buffer[position] != rune('B') {
							goto l147
						}
						position++
					}
				l292:
					if buffer[position] != rune('1') {
						goto l147
					}
					position++
					if buffer[position] != rune('2') {
						goto l147
					}
					position++
					if buffer[position] != rune('8') {
						goto l147
					}
					position++
				}
			l149:
				add(ruleLabelContainingDirectiveName, position148)
			}
			return true
		l147:
			position, tokenIndex = position147, tokenIndex147
			return false
		},
		/* 14 SymbolArgs <- <(SymbolArg (WS? ',' WS? SymbolArg)*)> */
		func() bool {
			position294, tokenIndex294 := position, tokenIndex
			{
				position295 := position
				if !_rules[ruleSymbolArg]() {
					goto l294
				}
			l296:
				{
					position297, tokenIndex297 := position, tokenIndex
					{
						position298, tokenIndex298 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l298
						}
						goto l299
					l298:
						position, tokenIndex = position298, tokenIndex298
					}
				l299:
					if buffer[position] != rune(',') {
						goto l297
					}
					position++
					{
						position300, tokenIndex300 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l300
						}
						goto l301
					l300:
						position, tokenIndex = position300, tokenIndex300
					}
				l301:
					if !_rules[ruleSymbolArg]() {
						goto l297
					}
					goto l296
				l297:
					position, tokenIndex = position297, tokenIndex297
				}
				add(ruleSymbolArgs, position295)
			}
			return true
		l294:
			position, tokenIndex = position294, tokenIndex294
			return false
		},
		/* 15 SymbolArg <- <SymbolExpr> */
		func() bool {
			position302, tokenIndex302 := position, tokenIndex
			{
				position303 := position
				if !_rules[ruleSymbolExpr]() {
					goto l302
				}
				add(ruleSymbolArg, position303)
			}
			return true
		l302:
			position, tokenIndex = position302, tokenIndex302
			return false
		},
		/* 16 SymbolExpr <- <(SymbolAtom (WS? SymbolOperator WS? SymbolExpr)?)> */
		func() bool {
			position304, tokenIndex304 := position, tokenIndex
			{
				position305 := position
				if !_rules[ruleSymbolAtom]() {
					goto l304
				}
				{
					position306, tokenIndex306 := position, tokenIndex
					{
						position308, tokenIndex308 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l308
						}
						goto l309
					l308:
						position, tokenIndex = position308, tokenIndex308
					}
				l309:
					if !_rules[ruleSymbolOperator]() {
						goto l306
					}
					{
						position310, tokenIndex310 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l310
						}
						goto l311
					l310:
						position, tokenIndex = position310, tokenIndex310
					}
				l311:
					if !_rules[ruleSymbolExpr]() {
						goto l306
					}
					goto l307
				l306:
					position, tokenIndex = position306, tokenIndex306
				}
			l307:
				add(ruleSymbolExpr, position305)
			}
			return true
		l304:
			position, tokenIndex = position304, tokenIndex304
			return false
		},
		/* 17 SymbolAtom <- <(LocalLabelRef / Offset / SymbolType / (LocalSymbol TCMarker?) / (SymbolName Offset) / (SymbolName TCMarker?) / Dot / (OpenParen WS? SymbolExpr WS? CloseParen))> */
		func() bool {
			position312, tokenIndex312 := position, tokenIndex
			{
				position313 := position
				{
					position314, tokenIndex314 := position, tokenIndex
					if !_rules[ruleLocalLabelRef]() {
						goto l315
					}
					goto l314
				l315:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleOffset]() {
						goto l316
					}
					goto l314
				l316:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleSymbolType]() {
						goto l317
					}
					goto l314
				l317:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleLocalSymbol]() {
						goto l318
					}
					{
						position319, tokenIndex319 := position, tokenIndex
						if !_rules[ruleTCMarker]() {
							goto l319
						}
						goto l320
					l319:
						position, tokenIndex = position319, tokenIndex319
					}
				l320:
					goto l314
				l318:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleSymbolName]() {
						goto l321
					}
					if !_rules[ruleOffset]() {
						goto l321
					}
					goto l314
				l321:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleSymbolName]() {
						goto l322
					}
					{
						position323, tokenIndex323 := position, tokenIndex
						if !_rules[ruleTCMarker]() {
							goto l323
						}
						goto l324
					l323:
						position, tokenIndex = position323, tokenIndex323
					}
				l324:
					goto l314
				l322:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleDot]() {
						goto l325
					}
					goto l314
				l325:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleOpenParen]() {
						goto l312
					}
					{
						position326, tokenIndex326 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l326
						}
						goto l327
					l326:
						position, tokenIndex = position326, tokenIndex326
					}
				l327:
					if !_rules[ruleSymbolExpr]() {
						goto l312
					}
					{
						position328, tokenIndex328 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l328
						}
						goto l329
					l328:
						position, tokenIndex = position328, tokenIndex328
					}
				l329:
					if !_rules[ruleCloseParen]() {
						goto l312
					}
				}
			l314:
				add(ruleSymbolAtom, position313)
			}
			return true
		l312:
			position, tokenIndex = position312, tokenIndex312
			return false
		},
		/* 18 SymbolOperator <- <('+' / '-' / '|' / ('<' '<') / ('>' '>'))> */
		func() bool {
			position330, tokenIndex330 := position, tokenIndex
			{
				position331 := position
				{
					position332, tokenIndex332 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l333
					}
					position++
					goto l332
				l333:
					position, tokenIndex = position332, tokenIndex332
					if buffer[position] != rune('-') {
						goto l334
					}
					position++
					goto l332
				l334:
					position, tokenIndex = position332, tokenIndex332
					if buffer[position] != rune('|') {
						goto l335
					}
					position++
					goto l332
				l335:
					position, tokenIndex = position332, tokenIndex332
					if buffer[position] != rune('<') {
						goto l336
					}
					position++
					if buffer[position] != rune('<') {
						goto l336
					}
					position++
					goto l332
				l336:
					position, tokenIndex = position332, tokenIndex332
					if buffer[position] != rune('>') {
						goto l330
					}
					position++
					if buffer[position] != rune('>') {
						goto l330
					}
					position++
				}
			l332:
				add(ruleSymbolOperator, position331)
			}
			return true
		l330:
			position, tokenIndex = position330, tokenIndex330
			return false
		},
		/* 19 OpenParen <- <'('> */
		func() bool {
			position337, tokenIndex337 := position, tokenIndex
			{
				position338 := position
				if buffer[position] != rune('(') {
					goto l337
				}
				position++
				add(ruleOpenParen, position338)
			}
			return true
		l337:
			position, tokenIndex = position337, tokenIndex337
			return false
		},
		/* 20 CloseParen <- <')'> */
		func() bool {
			position339, tokenIndex339 := position, tokenIndex
			{
				position340 := position
				if buffer[position] != rune(')') {
					goto l339
				}
				position++
				add(ruleCloseParen, position340)
			}
			return true
		l339:
			position, tokenIndex = position339, tokenIndex339
			return false
		},
		/* 21 SymbolType <- <(('@' / '%') (('f' 'u' 'n' 'c' 't' 'i' 'o' 'n') / ('o' 'b' 'j' 'e' 'c' 't')))> */
		func() bool {
			position341, tokenIndex341 := position, tokenIndex
			{
				position342 := position
				{
					position343, tokenIndex343 := position, tokenIndex
					if buffer[position] != rune('@') {
						goto l344
					}
					position++
					goto l343
				l344:
					position, tokenIndex = position343, tokenIndex343
					if buffer[position] != rune('%') {
						goto l341
					}
					position++
				}
			l343:
				{
					position345, tokenIndex345 := position, tokenIndex
					if buffer[position] != rune('f') {
						goto l346
					}
					position++
					if buffer[position] != rune('u') {
						goto l346
					}
					position++
					if buffer[position] != rune('n') {
						goto l346
					}
					position++
					if buffer[position] != rune('c') {
						goto l346
					}
					position++
					if buffer[position] != rune('t') {
						goto l346
					}
					position++
					if buffer[position] != rune('i') {
						goto l346
					}
					position++
					if buffer[position] != rune('o') {
						goto l346
					}
					position++
					if buffer[position] != rune('n') {
						goto l346
					}
					position++
					goto l345
				l346:
					position, tokenIndex = position345, tokenIndex345
					if buffer[position] != rune('o') {
						goto l341
					}
					position++
					if buffer[position] != rune('b') {
						goto l341
					}
					position++
					if buffer[position] != rune('j') {
						goto l341
					}
					position++
					if buffer[position] != rune('e') {
						goto l341
					}
					position++
					if buffer[position] != rune('c') {
						goto l341
					}
					position++
					if buffer[position] != rune('t') {
						goto l341
					}
					position++
				}
			l345:
				add(ruleSymbolType, position342)
			}
			return true
		l341:
			position, tokenIndex = position341, tokenIndex341
			return false
		},
		/* 22 Dot <- <'.'> */
		func() bool {
			position347, tokenIndex347 := position, tokenIndex
			{
				position348 := position
				if buffer[position] != rune('.') {
					goto l347
				}
				position++
				add(ruleDot, position348)
			}
			return true
		l347:
			position, tokenIndex = position347, tokenIndex347
			return false
		},
		/* 23 TCMarker <- <('[' 'T' 'C' ']')> */
		func() bool {
			position349, tokenIndex349 := position, tokenIndex
			{
				position350 := position
				if buffer[position] != rune('[') {
					goto l349
				}
				position++
				if buffer[position] != rune('T') {
					goto l349
				}
				position++
				if buffer[position] != rune('C') {
					goto l349
				}
				position++
				if buffer[position] != rune(']') {
					goto l349
				}
				position++
				add(ruleTCMarker, position350)
			}
			return true
		l349:
			position, tokenIndex = position349, tokenIndex349
			return false
		},
		/* 24 EscapedChar <- <('\\' .)> */
		func() bool {
			position351, tokenIndex351 := position, tokenIndex
			{
				position352 := position
				if buffer[position] != rune('\\') {
					goto l351
				}
				position++
				if !matchDot() {
					goto l351
				}
				add(ruleEscapedChar, position352)
			}
			return true
		l351:
			position, tokenIndex = position351, tokenIndex351
			return false
		},
		/* 25 WS <- <(' ' / '\t')+> */
		func() bool {
			position353, tokenIndex353 := position, tokenIndex
			{
				position354 := position
				{
					position357, tokenIndex357 := position, tokenIndex
					if buffer[position] != rune(' ') {
						goto l358
					}
					position++
					goto l357
				l358:
					position, tokenIndex = position357, tokenIndex357
					if buffer[position] != rune('\t') {
						goto l353
					}
					position++
				}
			l357:
			l355:
				{
					position356, tokenIndex356 := position, tokenIndex
					{
						position359, tokenIndex359 := position, tokenIndex
						if buffer[position] != rune(' ') {
							goto l360
						}
						position++
						goto l359
					l360:
						position, tokenIndex = position359, tokenIndex359
						if buffer[position] != rune('\t') {
							goto l356
						}
						position++
					}
				l359:
					goto l355
				l356:
					position, tokenIndex = position356, tokenIndex356
				}
				add(ruleWS, position354)
			}
			return true
		l353:
			position, tokenIndex = position353, tokenIndex353
			return false
		},
		/* 26 Comment <- <((('/' '/') / '#') (!'\n' .)*)> */
		func() bool {
			position361, tokenIndex361 := position, tokenIndex
			{
				position362 := position
				{
					position363, tokenIndex363 := position, tokenIndex
					if buffer[position] != rune('/') {
						goto l364
					}
					position++
					if buffer[position] != rune('/') {
						goto l364
					}
					position++
					goto l363
				l364:
					position, tokenIndex = position363, tokenIndex363
					if buffer[position] != rune('#') {
						goto l361
					}
					position++
				}
			l363:
			l365:
				{
					position366, tokenIndex366 := position, tokenIndex
					{
						position367, tokenIndex367 := position, tokenIndex
						if buffer[position] != rune('\n') {
							goto l367
						}
						position++
						goto l366
					l367:
						position, tokenIndex = position367, tokenIndex367
					}
					if !matchDot() {
						goto l366
					}
					goto l365
				l366:
					position, tokenIndex = position366, tokenIndex366
				}
				add(ruleComment, position362)
			}
			return true
		l361:
			position, tokenIndex = position361, tokenIndex361
			return false
		},
		/* 27 Label <- <((LocalSymbol / LocalLabel / SymbolName) ':')> */
		func() bool {
			position368, tokenIndex368 := position, tokenIndex
			{
				position369 := position
				{
					position370, tokenIndex370 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l371
					}
					goto l370
				l371:
					position, tokenIndex = position370, tokenIndex370
					if !_rules[ruleLocalLabel]() {
						goto l372
					}
					goto l370
				l372:
					position, tokenIndex = position370, tokenIndex370
					if !_rules[ruleSymbolName]() {
						goto l368
					}
				}
			l370:
				if buffer[position] != rune(':') {
					goto l368
				}
				position++
				add(ruleLabel, position369)
			}
			return true
		l368:
			position, tokenIndex = position368, tokenIndex368
			return false
		},
		/* 28 SymbolName <- <(([a-z] / [A-Z] / '.' / '_') ([a-z] / [A-Z] / '.' / ([0-9] / [0-9]) / '$' / '_')*)> */
		func() bool {
			position373, tokenIndex373 := position, tokenIndex
			{
				position374 := position
				{
					position375, tokenIndex375 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l376
					}
					position++
					goto l375
				l376:
					position, tokenIndex = position375, tokenIndex375
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l377
					}
					position++
					goto l375
				l377:
					position, tokenIndex = position375, tokenIndex375
					if buffer[position] != rune('.') {
						goto l378
					}
					position++
					goto l375
				l378:
					position, tokenIndex = position375, tokenIndex375
					if buffer[position] != rune('_') {
						goto l373
					}
					position++
				}
			l375:
			l379:
				{
					position380, tokenIndex380 := position, tokenIndex
					{
						position381, tokenIndex381 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l382
						}
						position++
						goto l381
					l382:
						position, tokenIndex = position381, tokenIndex381
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l383
						}
						position++
						goto l381
					l383:
						position, tokenIndex = position381, tokenIndex381
						if buffer[position] != rune('.') {
							goto l384
						}
						position++
						goto l381
					l384:
						position, tokenIndex = position381, tokenIndex381
						{
							position386, tokenIndex386 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l387
							}
							position++
							goto l386
						l387:
							position, tokenIndex = position386, tokenIndex386
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l385
							}
							position++
						}
					l386:
						goto l381
					l385:
						position, tokenIndex = position381, tokenIndex381
						if buffer[position] != rune('$') {
							goto l388
						}
						position++
						goto l381
					l388:
						position, tokenIndex = position381, tokenIndex381
						if buffer[position] != rune('_') {
							goto l380
						}
						position++
					}
				l381:
					goto l379
				l380:
					position, tokenIndex = position380, tokenIndex380
				}
				add(ruleSymbolName, position374)
			}
			return true
		l373:
			position, tokenIndex = position373, tokenIndex373
			return false
		},
		/* 29 LocalSymbol <- <('.' 'L' ([a-z] / [A-Z] / ([a-z] / [A-Z]) / '.' / ([0-9] / [0-9]) / '$' / '_')+)> */
		func() bool {
			position389, tokenIndex389 := position, tokenIndex
			{
				position390 := position
				if buffer[position] != rune('.') {
					goto l389
				}
				position++
				if buffer[position] != rune('L') {
					goto l389
				}
				position++
				{
					position393, tokenIndex393 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l394
					}
					position++
					goto l393
				l394:
					position, tokenIndex = position393, tokenIndex393
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l395
					}
					position++
					goto l393
				l395:
					position, tokenIndex = position393, tokenIndex393
					{
						position397, tokenIndex397 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l398
						}
						position++
						goto l397
					l398:
						position, tokenIndex = position397, tokenIndex397
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l396
						}
						position++
					}
				l397:
					goto l393
				l396:
					position, tokenIndex = position393, tokenIndex393
					if buffer[position] != rune('.') {
						goto l399
					}
					position++
					goto l393
				l399:
					position, tokenIndex = position393, tokenIndex393
					{
						position401, tokenIndex401 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l402
						}
						position++
						goto l401
					l402:
						position, tokenIndex = position401, tokenIndex401
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l400
						}
						position++
					}
				l401:
					goto l393
				l400:
					position, tokenIndex = position393, tokenIndex393
					if buffer[position] != rune('$') {
						goto l403
					}
					position++
					goto l393
				l403:
					position, tokenIndex = position393, tokenIndex393
					if buffer[position] != rune('_') {
						goto l389
					}
					position++
				}
			l393:
			l391:
				{
					position392, tokenIndex392 := position, tokenIndex
					{
						position404, tokenIndex404 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l405
						}
						position++
						goto l404
					l405:
						position, tokenIndex = position404, tokenIndex404
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l406
						}
						position++
						goto l404
					l406:
						position, tokenIndex = position404, tokenIndex404
						{
							position408, tokenIndex408 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l409
							}
							position++
							goto l408
						l409:
							position, tokenIndex = position408, tokenIndex408
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l407
							}
							position++
						}
					l408:
						goto l404
					l407:
						position, tokenIndex = position404, tokenIndex404
						if buffer[position] != rune('.') {
							goto l410
						}
						position++
						goto l404
					l410:
						position, tokenIndex = position404, tokenIndex404
						{
							position412, tokenIndex412 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l413
							}
							position++
							goto l412
						l413:
							position, tokenIndex = position412, tokenIndex412
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l411
							}
							position++
						}
					l412:
						goto l404
					l411:
						position, tokenIndex = position404, tokenIndex404
						if buffer[position] != rune('$') {
							goto l414
						}
						position++
						goto l404
					l414:
						position, tokenIndex = position404, tokenIndex404
						if buffer[position] != rune('_') {
							goto l392
						}
						position++
					}
				l404:
					goto l391
				l392:
					position, tokenIndex = position392, tokenIndex392
				}
				add(ruleLocalSymbol, position390)
			}
			return true
		l389:
			position, tokenIndex = position389, tokenIndex389
			return false
		},
		/* 30 LocalLabel <- <([0-9] ([0-9] / '$')*)> */
		func() bool {
			position415, tokenIndex415 := position, tokenIndex
			{
				position416 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l415
				}
				position++
			l417:
				{
					position418, tokenIndex418 := position, tokenIndex
					{
						position419, tokenIndex419 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l420
						}
						position++
						goto l419
					l420:
						position, tokenIndex = position419, tokenIndex419
						if buffer[position] != rune('$') {
							goto l418
						}
						position++
					}
				l419:
					goto l417
				l418:
					position, tokenIndex = position418, tokenIndex418
				}
				add(ruleLocalLabel, position416)
			}
			return true
		l415:
			position, tokenIndex = position415, tokenIndex415
			return false
		},
		/* 31 LocalLabelRef <- <([0-9] ([0-9] / '$')* ('b' / 'f'))> */
		func() bool {
			position421, tokenIndex421 := position, tokenIndex
			{
				position422 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l421
				}
				position++
			l423:
				{
					position424, tokenIndex424 := position, tokenIndex
					{
						position425, tokenIndex425 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l426
						}
						position++
						goto l425
					l426:
						position, tokenIndex = position425, tokenIndex425
						if buffer[position] != rune('$') {
							goto l424
						}
						position++
					}
				l425:
					goto l423
				l424:
					position, tokenIndex = position424, tokenIndex424
				}
				{
					position427, tokenIndex427 := position, tokenIndex
					if buffer[position] != rune('b') {
						goto l428
					}
					position++
					goto l427
				l428:
					position, tokenIndex = position427, tokenIndex427
					if buffer[position] != rune('f') {
						goto l421
					}
					position++
				}
			l427:
				add(ruleLocalLabelRef, position422)
			}
			return true
		l421:
			position, tokenIndex = position421, tokenIndex421
			return false
		},
		/* 32 InstructionPrefix <- <(('n' / 'N') ('o' / 'O') ('t' / 'T') ('r' / 'R') ('a' / 'A') ('c' / 'C') ('k' / 'K'))> */
		func() bool {
			position429, tokenIndex429 := position, tokenIndex
			{
				position430 := position
				{
					position431, tokenIndex431 := position, tokenIndex
					if buffer[position] != rune('n') {
						goto l432
					}
					position++
					goto l431
				l432:
					position, tokenIndex = position431, tokenIndex431
					if buffer[position] != rune('N') {
						goto l429
					}
					position++
				}
			l431:
				{
					position433, tokenIndex433 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l434
					}
					position++
					goto l433
				l434:
					position, tokenIndex = position433, tokenIndex433
					if buffer[position] != rune('O') {
						goto l429
					}
					position++
				}
			l433:
				{
					position435, tokenIndex435 := position, tokenIndex
					if buffer[position] != rune('t') {
						goto l436
					}
					position++
					goto l435
				l436:
					position, tokenIndex = position435, tokenIndex435
					if buffer[position] != rune('T') {
						goto l429
					}
					position++
				}
			l435:
				{
					position437, tokenIndex437 := position, tokenIndex
					if buffer[position] != rune('r') {
						goto l438
					}
					position++
					goto l437
				l438:
					position, tokenIndex = position437, tokenIndex437
					if buffer[position] != rune('R') {
						goto l429
					}
					position++
				}
			l437:
				{
					position439, tokenIndex439 := position, tokenIndex
					if buffer[position] != rune('a') {
						goto l440
					}
					position++
					goto l439
				l440:
					position, tokenIndex = position439, tokenIndex439
					if buffer[position] != rune('A') {
						goto l429
					}
					position++
				}
			l439:
				{
					position441, tokenIndex441 := position, tokenIndex
					if buffer[position] != rune('c') {
						goto l442
					}
					position++
					goto l441
				l442:
					position, tokenIndex = position441, tokenIndex441
					if buffer[position] != rune('C') {
						goto l429
					}
					position++
				}
			l441:
				{
					position443, tokenIndex443 := position, tokenIndex
					if buffer[position] != rune('k') {
						goto l444
					}
					position++
					goto l443
				l444:
					position, tokenIndex = position443, tokenIndex443
					if buffer[position] != rune('K') {
						goto l429
					}
					position++
				}
			l443:
				add(ruleInstructionPrefix, position430)
			}
			return true
		l429:
			position, tokenIndex = position429, tokenIndex429
			return false
		},
		/* 33 Instruction <- <((InstructionPrefix WS)? InstructionName (WS InstructionArg (WS? ',' WS? InstructionArg)*)?)> */
		func() bool {
			position445, tokenIndex445 := position, tokenIndex
			{
				position446 := position
				{
					position447, tokenIndex447 := position, tokenIndex
					if !_rules[ruleInstructionPrefix]() {
						goto l447
					}
					if !_rules[ruleWS]() {
						goto l447
					}
					goto l448
				l447:
					position, tokenIndex = position447, tokenIndex447
				}
			l448:
				if !_rules[ruleInstructionName]() {
					goto l445
				}
				{
					position449, tokenIndex449 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l449
					}
					if !_rules[ruleInstructionArg]() {
						goto l449
					}
				l451:
					{
						position452, tokenIndex452 := position, tokenIndex
						{
							position453, tokenIndex453 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l453
							}
							goto l454
						l453:
							position, tokenIndex = position453, tokenIndex453
						}
					l454:
						if buffer[position] != rune(',') {
							goto l452
						}
						position++
						{
							position455, tokenIndex455 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l455
							}
							goto l456
						l455:
							position, tokenIndex = position455, tokenIndex455
						}
					l456:
						if !_rules[ruleInstructionArg]() {
							goto l452
						}
						goto l451
					l452:
						position, tokenIndex = position452, tokenIndex452
					}
					goto l450
				l449:
					position, tokenIndex = position449, tokenIndex449
				}
			l450:
				add(ruleInstruction, position446)
			}
			return true
		l445:
			position, tokenIndex = position445, tokenIndex445
			return false
		},
		/* 34 InstructionName <- <(([a-z] / [A-Z]) ([a-z] / [A-Z] / '.' / ([0-9] / [0-9]))* ('.' / '+' / '-')?)> */
		func() bool {
			position457, tokenIndex457 := position, tokenIndex
			{
				position458 := position
				{
					position459, tokenIndex459 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l460
					}
					position++
					goto l459
				l460:
					position, tokenIndex = position459, tokenIndex459
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l457
					}
					position++
				}
			l459:
			l461:
				{
					position462, tokenIndex462 := position, tokenIndex
					{
						position463, tokenIndex463 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l464
						}
						position++
						goto l463
					l464:
						position, tokenIndex = position463, tokenIndex463
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l465
						}
						position++
						goto l463
					l465:
						position, tokenIndex = position463, tokenIndex463
						if buffer[position] != rune('.') {
							goto l466
						}
						position++
						goto l463
					l466:
						position, tokenIndex = position463, tokenIndex463
						{
							position467, tokenIndex467 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l468
							}
							position++
							goto l467
						l468:
							position, tokenIndex = position467, tokenIndex467
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l462
							}
							position++
						}
					l467:
					}
				l463:
					goto l461
				l462:
					position, tokenIndex = position462, tokenIndex462
				}
				{
					position469, tokenIndex469 := position, tokenIndex
					{
						position471, tokenIndex471 := position, tokenIndex
						if buffer[position] != rune('.') {
							goto l472
						}
						position++
						goto l471
					l472:
						position, tokenIndex = position471, tokenIndex471
						if buffer[position] != rune('+') {
							goto l473
						}
						position++
						goto l471
					l473:
						position, tokenIndex = position471, tokenIndex471
						if buffer[position] != rune('-') {
							goto l469
						}
						position++
					}
				l471:
					goto l470
				l469:
					position, tokenIndex = position469, tokenIndex469
				}
			l470:
				add(ruleInstructionName, position458)
			}
			return true
		l457:
			position, tokenIndex = position457, tokenIndex457
			return false
		},
		/* 35 InstructionArg <- <(IndirectionIndicator? (ARMConstantTweak / RegisterOrConstant / LocalLabelRef / TOCRefHigh / TOCRefLow / GOTLocation / GOTAddress / GOTSymbolOffset / MemoryRef) AVX512Token*)> */
		func() bool {
			position474, tokenIndex474 := position, tokenIndex
			{
				position475 := position
				{
					position476, tokenIndex476 := position, tokenIndex
					if !_rules[ruleIndirectionIndicator]() {
						goto l476
					}
					goto l477
				l476:
					position, tokenIndex = position476, tokenIndex476
				}
			l477:
				{
					position478, tokenIndex478 := position, tokenIndex
					if !_rules[ruleARMConstantTweak]() {
						goto l479
					}
					goto l478
				l479:
					position, tokenIndex = position478, tokenIndex478
					if !_rules[ruleRegisterOrConstant]() {
						goto l480
					}
					goto l478
				l480:
					position, tokenIndex = position478, tokenIndex478
					if !_rules[ruleLocalLabelRef]() {
						goto l481
					}
					goto l478
				l481:
					position, tokenIndex = position478, tokenIndex478
					if !_rules[ruleTOCRefHigh]() {
						goto l482
					}
					goto l478
				l482:
					position, tokenIndex = position478, tokenIndex478
					if !_rules[ruleTOCRefLow]() {
						goto l483
					}
					goto l478
				l483:
					position, tokenIndex = position478, tokenIndex478
					if !_rules[ruleGOTLocation]() {
						goto l484
					}
					goto l478
				l484:
					position, tokenIndex = position478, tokenIndex478
					if !_rules[ruleGOTAddress]() {
						goto l485
					}
					goto l478
				l485:
					position, tokenIndex = position478, tokenIndex478
					if !_rules[ruleGOTSymbolOffset]() {
						goto l486
					}
					goto l478
				l486:
					position, tokenIndex = position478, tokenIndex478
					if !_rules[ruleMemoryRef]() {
						goto l474
					}
				}
			l478:
			l487:
				{
					position488, tokenIndex488 := position, tokenIndex
					if !_rules[ruleAVX512Token]() {
						goto l488
					}
					goto l487
				l488:
					position, tokenIndex = position488, tokenIndex488
				}
				add(ruleInstructionArg, position475)
			}
			return true
		l474:
			position, tokenIndex = position474, tokenIndex474
			return false
		},
		/* 36 GOTLocation <- <('$' '_' 'G' 'L' 'O' 'B' 'A' 'L' '_' 'O' 'F' 'F' 'S' 'E' 'T' '_' 'T' 'A' 'B' 'L' 'E' '_' '-' LocalSymbol)> */
		func() bool {
			position489, tokenIndex489 := position, tokenIndex
			{
				position490 := position
				if buffer[position] != rune('$') {
					goto l489
				}
				position++
				if buffer[position] != rune('_') {
					goto l489
				}
				position++
				if buffer[position] != rune('G') {
					goto l489
				}
				position++
				if buffer[position] != rune('L') {
					goto l489
				}
				position++
				if buffer[position] != rune('O') {
					goto l489
				}
				position++
				if buffer[position] != rune('B') {
					goto l489
				}
				position++
				if buffer[position] != rune('A') {
					goto l489
				}
				position++
				if buffer[position] != rune('L') {
					goto l489
				}
				position++
				if buffer[position] != rune('_') {
					goto l489
				}
				position++
				if buffer[position] != rune('O') {
					goto l489
				}
				position++
				if buffer[position] != rune('F') {
					goto l489
				}
				position++
				if buffer[position] != rune('F') {
					goto l489
				}
				position++
				if buffer[position] != rune('S') {
					goto l489
				}
				position++
				if buffer[position] != rune('E') {
					goto l489
				}
				position++
				if buffer[position] != rune('T') {
					goto l489
				}
				position++
				if buffer[position] != rune('_') {
					goto l489
				}
				position++
				if buffer[position] != rune('T') {
					goto l489
				}
				position++
				if buffer[position] != rune('A') {
					goto l489
				}
				position++
				if buffer[position] != rune('B') {
					goto l489
				}
				position++
				if buffer[position] != rune('L') {
					goto l489
				}
				position++
				if buffer[position] != rune('E') {
					goto l489
				}
				position++
				if buffer[position] != rune('_') {
					goto l489
				}
				position++
				if buffer[position] != rune('-') {
					goto l489
				}
				position++
				if !_rules[ruleLocalSymbol]() {
					goto l489
				}
				add(ruleGOTLocation, position490)
			}
			return true
		l489:
			position, tokenIndex = position489, tokenIndex489
			return false
		},
		/* 37 GOTAddress <- <('_' 'G' 'L' 'O' 'B' 'A' 'L' '_' 'O' 'F' 'F' 'S' 'E' 'T' '_' 'T' 'A' 'B' 'L' 'E' '_' '(' '%' 'r' 'i' 'p' ')')> */
		func() bool {
			position491, tokenIndex491 := position, tokenIndex
			{
				position492 := position
				if buffer[position] != rune('_') {
					goto l491
				}
				position++
				if buffer[position] != rune('G') {
					goto l491
				}
				position++
				if buffer[position] != rune('L') {
					goto l491
				}
				position++
				if buffer[position] != rune('O') {
					goto l491
				}
				position++
				if buffer[position] != rune('B') {
					goto l491
				}
				position++
				if buffer[position] != rune('A') {
					goto l491
				}
				position++
				if buffer[position] != rune('L') {
					goto l491
				}
				position++
				if buffer[position] != rune('_') {
					goto l491
				}
				position++
				if buffer[position] != rune('O') {
					goto l491
				}
				position++
				if buffer[position] != rune('F') {
					goto l491
				}
				position++
				if buffer[position] != rune('F') {
					goto l491
				}
				position++
				if buffer[position] != rune('S') {
					goto l491
				}
				position++
				if buffer[position] != rune('E') {
					goto l491
				}
				position++
				if buffer[position] != rune('T') {
					goto l491
				}
				position++
				if buffer[position] != rune('_') {
					goto l491
				}
				position++
				if buffer[position] != rune('T') {
					goto l491
				}
				position++
				if buffer[position] != rune('A') {
					goto l491
				}
				position++
				if buffer[position] != rune('B') {
					goto l491
				}
				position++
				if buffer[position] != rune('L') {
					goto l491
				}
				position++
				if buffer[position] != rune('E') {
					goto l491
				}
				position++
				if buffer[position] != rune('_') {
					goto l491
				}
				position++
				if buffer[position] != rune('(') {
					goto l491
				}
				position++
				if buffer[position] != rune('%') {
					goto l491
				}
				position++
				if buffer[position] != rune('r') {
					goto l491
				}
				position++
				if buffer[position] != rune('i') {
					goto l491
				}
				position++
				if buffer[position] != rune('p') {
					goto l491
				}
				position++
				if buffer[position] != rune(')') {
					goto l491
				}
				position++
				add(ruleGOTAddress, position492)
			}
			return true
		l491:
			position, tokenIndex = position491, tokenIndex491
			return false
		},
		/* 38 GOTSymbolOffset <- <(('$' SymbolName ('@' 'G' 'O' 'T') ('O' 'F' 'F')?) / (':' ('g' / 'G') ('o' / 'O') ('t' / 'T') ':' SymbolName))> */
		func() bool {
			position493, tokenIndex493 := position, tokenIndex
			{
				position494 := position
				{
					position495, tokenIndex495 := position, tokenIndex
					if buffer[position] != rune('$') {
						goto l496
					}
					position++
					if !_rules[ruleSymbolName]() {
						goto l496
					}
					if buffer[position] != rune('@') {
						goto l496
					}
					position++
					if buffer[position] != rune('G') {
						goto l496
					}
					position++
					if buffer[position] != rune('O') {
						goto l496
					}
					position++
					if buffer[position] != rune('T') {
						goto l496
					}
					position++
					{
						position497, tokenIndex497 := position, tokenIndex
						if buffer[position] != rune('O') {
							goto l497
						}
						position++
						if buffer[position] != rune('F') {
							goto l497
						}
						position++
						if buffer[position] != rune('F') {
							goto l497
						}
						position++
						goto l498
					l497:
						position, tokenIndex = position497, tokenIndex497
					}
				l498:
					goto l495
				l496:
					position, tokenIndex = position495, tokenIndex495
					if buffer[position] != rune(':') {
						goto l493
					}
					position++
					{
						position499, tokenIndex499 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l500
						}
						position++
						goto l499
					l500:
						position, tokenIndex = position499, tokenIndex499
						if buffer[position] != rune('G') {
							goto l493
						}
						position++
					}
				l499:
					{
						position501, tokenIndex501 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l502
						}
						position++
						goto l501
					l502:
						position, tokenIndex = position501, tokenIndex501
						if buffer[position] != rune('O') {
							goto l493
						}
						position++
					}
				l501:
					{
						position503, tokenIndex503 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l504
						}
						position++
						goto l503
					l504:
						position, tokenIndex = position503, tokenIndex503
						if buffer[position] != rune('T') {
							goto l493
						}
						position++
					}
				l503:
					if buffer[position] != rune(':') {
						goto l493
					}
					position++
					if !_rules[ruleSymbolName]() {
						goto l493
					}
				}
			l495:
				add(ruleGOTSymbolOffset, position494)
			}
			return true
		l493:
			position, tokenIndex = position493, tokenIndex493
			return false
		},
		/* 39 AVX512Token <- <(WS? '{' '%'? ([0-9] / [a-z])* '}')> */
		func() bool {
			position505, tokenIndex505 := position, tokenIndex
			{
				position506 := position
				{
					position507, tokenIndex507 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l507
					}
					goto l508
				l507:
					position, tokenIndex = position507, tokenIndex507
				}
			l508:
				if buffer[position] != rune('{') {
					goto l505
				}
				position++
				{
					position509, tokenIndex509 := position, tokenIndex
					if buffer[position] != rune('%') {
						goto l509
					}
					position++
					goto l510
				l509:
					position, tokenIndex = position509, tokenIndex509
				}
			l510:
			l511:
				{
					position512, tokenIndex512 := position, tokenIndex
					{
						position513, tokenIndex513 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l514
						}
						position++
						goto l513
					l514:
						position, tokenIndex = position513, tokenIndex513
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l512
						}
						position++
					}
				l513:
					goto l511
				l512:
					position, tokenIndex = position512, tokenIndex512
				}
				if buffer[position] != rune('}') {
					goto l505
				}
				position++
				add(ruleAVX512Token, position506)
			}
			return true
		l505:
			position, tokenIndex = position505, tokenIndex505
			return false
		},
		/* 40 TOCRefHigh <- <('.' 'T' 'O' 'C' '.' '-' (('0' 'b') / ('.' 'L' ([a-z] / [A-Z] / '_' / [0-9])+)) ('@' ('h' / 'H') ('a' / 'A')))> */
		func() bool {
			position515, tokenIndex515 := position, tokenIndex
			{
				position516 := position
				if buffer[position] != rune('.') {
					goto l515
				}
				position++
				if buffer[position] != rune('T') {
					goto l515
				}
				position++
				if buffer[position] != rune('O') {
					goto l515
				}
				position++
				if buffer[position] != rune('C') {
					goto l515
				}
				position++
				if buffer[position] != rune('.') {
					goto l515
				}
				position++
				if buffer[position] != rune('-') {
					goto l515
				}
				position++
				{
					position517, tokenIndex517 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l518
					}
					position++
					if buffer[position] != rune('b') {
						goto l518
					}
					position++
					goto l517
				l518:
					position, tokenIndex = position517, tokenIndex517
					if buffer[position] != rune('.') {
						goto l515
					}
					position++
					if buffer[position] != rune('L') {
						goto l515
					}
					position++
					{
						position521, tokenIndex521 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l522
						}
						position++
						goto l521
					l522:
						position, tokenIndex = position521, tokenIndex521
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l523
						}
						position++
						goto l521
					l523:
						position, tokenIndex = position521, tokenIndex521
						if buffer[position] != rune('_') {
							goto l524
						}
						position++
						goto l521
					l524:
						position, tokenIndex = position521, tokenIndex521
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l515
						}
						position++
					}
				l521:
				l519:
					{
						position520, tokenIndex520 := position, tokenIndex
						{
							position525, tokenIndex525 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l526
							}
							position++
							goto l525
						l526:
							position, tokenIndex = position525, tokenIndex525
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l527
							}
							position++
							goto l525
						l527:
							position, tokenIndex = position525, tokenIndex525
							if buffer[position] != rune('_') {
								goto l528
							}
							position++
							goto l525
						l528:
							position, tokenIndex = position525, tokenIndex525
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l520
							}
							position++
						}
					l525:
						goto l519
					l520:
						position, tokenIndex = position520, tokenIndex520
					}
				}
			l517:
				if buffer[position] != rune('@') {
					goto l515
				}
				position++
				{
					position529, tokenIndex529 := position, tokenIndex
					if buffer[position] != rune('h') {
						goto l530
					}
					position++
					goto l529
				l530:
					position, tokenIndex = position529, tokenIndex529
					if buffer[position] != rune('H') {
						goto l515
					}
					position++
				}
			l529:
				{
					position531, tokenIndex531 := position, tokenIndex
					if buffer[position] != rune('a') {
						goto l532
					}
					position++
					goto l531
				l532:
					position, tokenIndex = position531, tokenIndex531
					if buffer[position] != rune('A') {
						goto l515
					}
					position++
				}
			l531:
				add(ruleTOCRefHigh, position516)
			}
			return true
		l515:
			position, tokenIndex = position515, tokenIndex515
			return false
		},
		/* 41 TOCRefLow <- <('.' 'T' 'O' 'C' '.' '-' (('0' 'b') / ('.' 'L' ([a-z] / [A-Z] / '_' / [0-9])+)) ('@' ('l' / 'L')))> */
		func() bool {
			position533, tokenIndex533 := position, tokenIndex
			{
				position534 := position
				if buffer[position] != rune('.') {
					goto l533
				}
				position++
				if buffer[position] != rune('T') {
					goto l533
				}
				position++
				if buffer[position] != rune('O') {
					goto l533
				}
				position++
				if buffer[position] != rune('C') {
					goto l533
				}
				position++
				if buffer[position] != rune('.') {
					goto l533
				}
				position++
				if buffer[position] != rune('-') {
					goto l533
				}
				position++
				{
					position535, tokenIndex535 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l536
					}
					position++
					if buffer[position] != rune('b') {
						goto l536
					}
					position++
					goto l535
				l536:
					position, tokenIndex = position535, tokenIndex535
					if buffer[position] != rune('.') {
						goto l533
					}
					position++
					if buffer[position] != rune('L') {
						goto l533
					}
					position++
					{
						position539, tokenIndex539 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l540
						}
						position++
						goto l539
					l540:
						position, tokenIndex = position539, tokenIndex539
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l541
						}
						position++
						goto l539
					l541:
						position, tokenIndex = position539, tokenIndex539
						if buffer[position] != rune('_') {
							goto l542
						}
						position++
						goto l539
					l542:
						position, tokenIndex = position539, tokenIndex539
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l533
						}
						position++
					}
				l539:
				l537:
					{
						position538, tokenIndex538 := position, tokenIndex
						{
							position543, tokenIndex543 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l544
							}
							position++
							goto l543
						l544:
							position, tokenIndex = position543, tokenIndex543
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l545
							}
							position++
							goto l543
						l545:
							position, tokenIndex = position543, tokenIndex543
							if buffer[position] != rune('_') {
								goto l546
							}
							position++
							goto l543
						l546:
							position, tokenIndex = position543, tokenIndex543
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l538
							}
							position++
						}
					l543:
						goto l537
					l538:
						position, tokenIndex = position538, tokenIndex538
					}
				}
			l535:
				if buffer[position] != rune('@') {
					goto l533
				}
				position++
				{
					position547, tokenIndex547 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l548
					}
					position++
					goto l547
				l548:
					position, tokenIndex = position547, tokenIndex547
					if buffer[position] != rune('L') {
						goto l533
					}
					position++
				}
			l547:
				add(ruleTOCRefLow, position534)
			}
			return true
		l533:
			position, tokenIndex = position533, tokenIndex533
			return false
		},
		/* 42 IndirectionIndicator <- <'*'> */
		func() bool {
			position549, tokenIndex549 := position, tokenIndex
			{
				position550 := position
				if buffer[position] != rune('*') {
					goto l549
				}
				position++
				add(ruleIndirectionIndicator, position550)
			}
			return true
		l549:
			position, tokenIndex = position549, tokenIndex549
			return false
		},
		/* 43 RegisterOrConstant <- <((('%' ([a-z] / [A-Z]) ([a-z] / [A-Z] / ([0-9] / [0-9]))*) / ('$'? ((Offset Offset) / Offset)) / ('#' Offset ('*' [0-9]+ ('-' [0-9] [0-9]*)?)?) / ('#' '~'? '(' [0-9] WS? ('<' '<') WS? [0-9] ')') / ARMRegister) !('f' / 'b' / ':' / '(' / '+' / '-'))> */
		func() bool {
			position551, tokenIndex551 := position, tokenIndex
			{
				position552 := position
				{
					position553, tokenIndex553 := position, tokenIndex
					if buffer[position] != rune('%') {
						goto l554
					}
					position++
					{
						position555, tokenIndex555 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l556
						}
						position++
						goto l555
					l556:
						position, tokenIndex = position555, tokenIndex555
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l554
						}
						position++
					}
				l555:
				l557:
					{
						position558, tokenIndex558 := position, tokenIndex
						{
							position559, tokenIndex559 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l560
							}
							position++
							goto l559
						l560:
							position, tokenIndex = position559, tokenIndex559
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l561
							}
							position++
							goto l559
						l561:
							position, tokenIndex = position559, tokenIndex559
							{
								position562, tokenIndex562 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l563
								}
								position++
								goto l562
							l563:
								position, tokenIndex = position562, tokenIndex562
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l558
								}
								position++
							}
						l562:
						}
					l559:
						goto l557
					l558:
						position, tokenIndex = position558, tokenIndex558
					}
					goto l553
				l554:
					position, tokenIndex = position553, tokenIndex553
					{
						position565, tokenIndex565 := position, tokenIndex
						if buffer[position] != rune('$') {
							goto l565
						}
						position++
						goto l566
					l565:
						position, tokenIndex = position565, tokenIndex565
					}
				l566:
					{
						position567, tokenIndex567 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l568
						}
						if !_rules[ruleOffset]() {
							goto l568
						}
						goto l567
					l568:
						position, tokenIndex = position567, tokenIndex567
						if !_rules[ruleOffset]() {
							goto l564
						}
					}
				l567:
					goto l553
				l564:
					position, tokenIndex = position553, tokenIndex553
					if buffer[position] != rune('#') {
						goto l569
					}
					position++
					if !_rules[ruleOffset]() {
						goto l569
					}
					{
						position570, tokenIndex570 := position, tokenIndex
						if buffer[position] != rune('*') {
							goto l570
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l570
						}
						position++
					l572:
						{
							position573, tokenIndex573 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l573
							}
							position++
							goto l572
						l573:
							position, tokenIndex = position573, tokenIndex573
						}
						{
							position574, tokenIndex574 := position, tokenIndex
							if buffer[position] != rune('-') {
								goto l574
							}
							position++
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l574
							}
							position++
						l576:
							{
								position577, tokenIndex577 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l577
								}
								position++
								goto l576
							l577:
								position, tokenIndex = position577, tokenIndex577
							}
							goto l575
						l574:
							position, tokenIndex = position574, tokenIndex574
						}
					l575:
						goto l571
					l570:
						position, tokenIndex = position570, tokenIndex570
					}
				l571:
					goto l553
				l569:
					position, tokenIndex = position553, tokenIndex553
					if buffer[position] != rune('#') {
						goto l578
					}
					position++
					{
						position579, tokenIndex579 := position, tokenIndex
						if buffer[position] != rune('~') {
							goto l579
						}
						position++
						goto l580
					l579:
						position, tokenIndex = position579, tokenIndex579
					}
				l580:
					if buffer[position] != rune('(') {
						goto l578
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l578
					}
					position++
					{
						position581, tokenIndex581 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l581
						}
						goto l582
					l581:
						position, tokenIndex = position581, tokenIndex581
					}
				l582:
					if buffer[position] != rune('<') {
						goto l578
					}
					position++
					if buffer[position] != rune('<') {
						goto l578
					}
					position++
					{
						position583, tokenIndex583 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l583
						}
						goto l584
					l583:
						position, tokenIndex = position583, tokenIndex583
					}
				l584:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l578
					}
					position++
					if buffer[position] != rune(')') {
						goto l578
					}
					position++
					goto l553
				l578:
					position, tokenIndex = position553, tokenIndex553
					if !_rules[ruleARMRegister]() {
						goto l551
					}
				}
			l553:
				{
					position585, tokenIndex585 := position, tokenIndex
					{
						position586, tokenIndex586 := position, tokenIndex
						if buffer[position] != rune('f') {
							goto l587
						}
						position++
						goto l586
					l587:
						position, tokenIndex = position586, tokenIndex586
						if buffer[position] != rune('b') {
							goto l588
						}
						position++
						goto l586
					l588:
						position, tokenIndex = position586, tokenIndex586
						if buffer[position] != rune(':') {
							goto l589
						}
						position++
						goto l586
					l589:
						position, tokenIndex = position586, tokenIndex586
						if buffer[position] != rune('(') {
							goto l590
						}
						position++
						goto l586
					l590:
						position, tokenIndex = position586, tokenIndex586
						if buffer[position] != rune('+') {
							goto l591
						}
						position++
						goto l586
					l591:
						position, tokenIndex = position586, tokenIndex586
						if buffer[position] != rune('-') {
							goto l585
						}
						position++
					}
				l586:
					goto l551
				l585:
					position, tokenIndex = position585, tokenIndex585
				}
				add(ruleRegisterOrConstant, position552)
			}
			return true
		l551:
			position, tokenIndex = position551, tokenIndex551
			return false
		},
		/* 44 ARMConstantTweak <- <((((('u' / 's') (('x' / 'X') ('t' / 'T')) ('x' / 'w' / 'h' / 'b')) / (('l' / 'L') ('s' / 'S') ('l' / 'L')) / (('l' / 'L') ('s' / 'S') ('r' / 'R')) / (('r' / 'R') ('o' / 'O') ('r' / 'R')) / (('a' / 'A') ('s' / 'S') ('r' / 'R'))) (WS '#' Offset)?) / (('m' / 'M') ('u' / 'U') ('l' / 'L') ' ' ('v' / 'V') ('l' / 'L')) / (('m' / 'M') ('u' / 'U') ('l' / 'L') ' ' '#' [0-9]))> */
		func() bool {
			position592, tokenIndex592 := position, tokenIndex
			{
				position593 := position
				{
					position594, tokenIndex594 := position, tokenIndex
					{
						position596, tokenIndex596 := position, tokenIndex
						{
							position598, tokenIndex598 := position, tokenIndex
							if buffer[position] != rune('u') {
								goto l599
							}
							position++
							goto l598
						l599:
							position, tokenIndex = position598, tokenIndex598
							if buffer[position] != rune('s') {
								goto l597
							}
							position++
						}
					l598:
						{
							position600, tokenIndex600 := position, tokenIndex
							if buffer[position] != rune('x') {
								goto l601
							}
							position++
							goto l600
						l601:
							position, tokenIndex = position600, tokenIndex600
							if buffer[position] != rune('X') {
								goto l597
							}
							position++
						}
					l600:
						{
							position602, tokenIndex602 := position, tokenIndex
							if buffer[position] != rune('t') {
								goto l603
							}
							position++
							goto l602
						l603:
							position, tokenIndex = position602, tokenIndex602
							if buffer[position] != rune('T') {
								goto l597
							}
							position++
						}
					l602:
						{
							position604, tokenIndex604 := position, tokenIndex
							if buffer[position] != rune('x') {
								goto l605
							}
							position++
							goto l604
						l605:
							position, tokenIndex = position604, tokenIndex604
							if buffer[position] != rune('w') {
								goto l606
							}
							position++
							goto l604
						l606:
							position, tokenIndex = position604, tokenIndex604
							if buffer[position] != rune('h') {
								goto l607
							}
							position++
							goto l604
						l607:
							position, tokenIndex = position604, tokenIndex604
							if buffer[position] != rune('b') {
								goto l597
							}
							position++
						}
					l604:
						goto l596
					l597:
						position, tokenIndex = position596, tokenIndex596
						{
							position609, tokenIndex609 := position, tokenIndex
							if buffer[position] != rune('l') {
								goto l610
							}
							position++
							goto l609
						l610:
							position, tokenIndex = position609, tokenIndex609
							if buffer[position] != rune('L') {
								goto l608
							}
							position++
						}
					l609:
						{
							position611, tokenIndex611 := position, tokenIndex
							if buffer[position] != rune('s') {
								goto l612
							}
							position++
							goto l611
						l612:
							position, tokenIndex = position611, tokenIndex611
							if buffer[position] != rune('S') {
								goto l608
							}
							position++
						}
					l611:
						{
							position613, tokenIndex613 := position, tokenIndex
							if buffer[position] != rune('l') {
								goto l614
							}
							position++
							goto l613
						l614:
							position, tokenIndex = position613, tokenIndex613
							if buffer[position] != rune('L') {
								goto l608
							}
							position++
						}
					l613:
						goto l596
					l608:
						position, tokenIndex = position596, tokenIndex596
						{
							position616, tokenIndex616 := position, tokenIndex
							if buffer[position] != rune('l') {
								goto l617
							}
							position++
							goto l616
						l617:
							position, tokenIndex = position616, tokenIndex616
							if buffer[position] != rune('L') {
								goto l615
							}
							position++
						}
					l616:
						{
							position618, tokenIndex618 := position, tokenIndex
							if buffer[position] != rune('s') {
								goto l619
							}
							position++
							goto l618
						l619:
							position, tokenIndex = position618, tokenIndex618
							if buffer[position] != rune('S') {
								goto l615
							}
							position++
						}
					l618:
						{
							position620, tokenIndex620 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l621
							}
							position++
							goto l620
						l621:
							position, tokenIndex = position620, tokenIndex620
							if buffer[position] != rune('R') {
								goto l615
							}
							position++
						}
					l620:
						goto l596
					l615:
						position, tokenIndex = position596, tokenIndex596
						{
							position623, tokenIndex623 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l624
							}
							position++
							goto l623
						l624:
							position, tokenIndex = position623, tokenIndex623
							if buffer[position] != rune('R') {
								goto l622
							}
							position++
						}
					l623:
						{
							position625, tokenIndex625 := position, tokenIndex
							if buffer[position] != rune('o') {
								goto l626
							}
							position++
							goto l625
						l626:
							position, tokenIndex = position625, tokenIndex625
							if buffer[position] != rune('O') {
								goto l622
							}
							position++
						}
					l625:
						{
							position627, tokenIndex627 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l628
							}
							position++
							goto l627
						l628:
							position, tokenIndex = position627, tokenIndex627
							if buffer[position] != rune('R') {
								goto l622
							}
							position++
						}
					l627:
						goto l596
					l622:
						position, tokenIndex = position596, tokenIndex596
						{
							position629, tokenIndex629 := position, tokenIndex
							if buffer[position] != rune('a') {
								goto l630
							}
							position++
							goto l629
						l630:
							position, tokenIndex = position629, tokenIndex629
							if buffer[position] != rune('A') {
								goto l595
							}
							position++
						}
					l629:
						{
							position631, tokenIndex631 := position, tokenIndex
							if buffer[position] != rune('s') {
								goto l632
							}
							position++
							goto l631
						l632:
							position, tokenIndex = position631, tokenIndex631
							if buffer[position] != rune('S') {
								goto l595
							}
							position++
						}
					l631:
						{
							position633, tokenIndex633 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l634
							}
							position++
							goto l633
						l634:
							position, tokenIndex = position633, tokenIndex633
							if buffer[position] != rune('R') {
								goto l595
							}
							position++
						}
					l633:
					}
				l596:
					{
						position635, tokenIndex635 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l635
						}
						if buffer[position] != rune('#') {
							goto l635
						}
						position++
						if !_rules[ruleOffset]() {
							goto l635
						}
						goto l636
					l635:
						position, tokenIndex = position635, tokenIndex635
					}
				l636:
					goto l594
				l595:
					position, tokenIndex = position594, tokenIndex594
					{
						position638, tokenIndex638 := position, tokenIndex
						if buffer[position] != rune('m') {
							goto l639
						}
						position++
						goto l638
					l639:
						position, tokenIndex = position638, tokenIndex638
						if buffer[position] != rune('M') {
							goto l637
						}
						position++
					}
				l638:
					{
						position640, tokenIndex640 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l641
						}
						position++
						goto l640
					l641:
						position, tokenIndex = position640, tokenIndex640
						if buffer[position] != rune('U') {
							goto l637
						}
						position++
					}
				l640:
					{
						position642, tokenIndex642 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l643
						}
						position++
						goto l642
					l643:
						position, tokenIndex = position642, tokenIndex642
						if buffer[position] != rune('L') {
							goto l637
						}
						position++
					}
				l642:
					if buffer[position] != rune(' ') {
						goto l637
					}
					position++
					{
						position644, tokenIndex644 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l645
						}
						position++
						goto l644
					l645:
						position, tokenIndex = position644, tokenIndex644
						if buffer[position] != rune('V') {
							goto l637
						}
						position++
					}
				l644:
					{
						position646, tokenIndex646 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l647
						}
						position++
						goto l646
					l647:
						position, tokenIndex = position646, tokenIndex646
						if buffer[position] != rune('L') {
							goto l637
						}
						position++
					}
				l646:
					goto l594
				l637:
					position, tokenIndex = position594, tokenIndex594
					{
						position648, tokenIndex648 := position, tokenIndex
						if buffer[position] != rune('m') {
							goto l649
						}
						position++
						goto l648
					l649:
						position, tokenIndex = position648, tokenIndex648
						if buffer[position] != rune('M') {
							goto l592
						}
						position++
					}
				l648:
					{
						position650, tokenIndex650 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l651
						}
						position++
						goto l650
					l651:
						position, tokenIndex = position650, tokenIndex650
						if buffer[position] != rune('U') {
							goto l592
						}
						position++
					}
				l650:
					{
						position652, tokenIndex652 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l653
						}
						position++
						goto l652
					l653:
						position, tokenIndex = position652, tokenIndex652
						if buffer[position] != rune('L') {
							goto l592
						}
						position++
					}
				l652:
					if buffer[position] != rune(' ') {
						goto l592
					}
					position++
					if buffer[position] != rune('#') {
						goto l592
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l592
					}
					position++
				}
			l594:
				add(ruleARMConstantTweak, position593)
			}
			return true
		l592:
			position, tokenIndex = position592, tokenIndex592
			return false
		},
		/* 45 ARMRegister <- <((('s' / 'S') ('p' / 'P')) / (('x' / 'w' / 'd' / 'q' / 's' / 'h' / 'b') [0-9] [0-9]?) / (('x' / 'X') ('z' / 'Z') ('r' / 'R')) / (('w' / 'W') ('z' / 'Z') ('r' / 'R')) / (('n' / 'N') ('z' / 'Z') ('c' / 'C') ('v' / 'V')) / SVE2PredicateRegister / ARMVectorRegister / SVE2SpecialValue / ('{' WS? ARMVectorRegister (',' WS? ARMVectorRegister)* WS? '}' ('[' [0-9] [0-9]? ']')?))> */
		func() bool {
			position654, tokenIndex654 := position, tokenIndex
			{
				position655 := position
				{
					position656, tokenIndex656 := position, tokenIndex
					{
						position658, tokenIndex658 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l659
						}
						position++
						goto l658
					l659:
						position, tokenIndex = position658, tokenIndex658
						if buffer[position] != rune('S') {
							goto l657
						}
						position++
					}
				l658:
					{
						position660, tokenIndex660 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l661
						}
						position++
						goto l660
					l661:
						position, tokenIndex = position660, tokenIndex660
						if buffer[position] != rune('P') {
							goto l657
						}
						position++
					}
				l660:
					goto l656
				l657:
					position, tokenIndex = position656, tokenIndex656
					{
						position663, tokenIndex663 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l664
						}
						position++
						goto l663
					l664:
						position, tokenIndex = position663, tokenIndex663
						if buffer[position] != rune('w') {
							goto l665
						}
						position++
						goto l663
					l665:
						position, tokenIndex = position663, tokenIndex663
						if buffer[position] != rune('d') {
							goto l666
						}
						position++
						goto l663
					l666:
						position, tokenIndex = position663, tokenIndex663
						if buffer[position] != rune('q') {
							goto l667
						}
						position++
						goto l663
					l667:
						position, tokenIndex = position663, tokenIndex663
						if buffer[position] != rune('s') {
							goto l668
						}
						position++
						goto l663
					l668:
						position, tokenIndex = position663, tokenIndex663
						if buffer[position] != rune('h') {
							goto l669
						}
						position++
						goto l663
					l669:
						position, tokenIndex = position663, tokenIndex663
						if buffer[position] != rune('b') {
							goto l662
						}
						position++
					}
				l663:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l662
					}
					position++
					{
						position670, tokenIndex670 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l670
						}
						position++
						goto l671
					l670:
						position, tokenIndex = position670, tokenIndex670
					}
				l671:
					goto l656
				l662:
					position, tokenIndex = position656, tokenIndex656
					{
						position673, tokenIndex673 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l674
						}
						position++
						goto l673
					l674:
						position, tokenIndex = position673, tokenIndex673
						if buffer[position] != rune('X') {
							goto l672
						}
						position++
					}
				l673:
					{
						position675, tokenIndex675 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l676
						}
						position++
						goto l675
					l676:
						position, tokenIndex = position675, tokenIndex675
						if buffer[position] != rune('Z') {
							goto l672
						}
						position++
					}
				l675:
					{
						position677, tokenIndex677 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l678
						}
						position++
						goto l677
					l678:
						position, tokenIndex = position677, tokenIndex677
						if buffer[position] != rune('R') {
							goto l672
						}
						position++
					}
				l677:
					goto l656
				l672:
					position, tokenIndex = position656, tokenIndex656
					{
						position680, tokenIndex680 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l681
						}
						position++
						goto l680
					l681:
						position, tokenIndex = position680, tokenIndex680
						if buffer[position] != rune('W') {
							goto l679
						}
						position++
					}
				l680:
					{
						position682, tokenIndex682 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l683
						}
						position++
						goto l682
					l683:
						position, tokenIndex = position682, tokenIndex682
						if buffer[position] != rune('Z') {
							goto l679
						}
						position++
					}
				l682:
					{
						position684, tokenIndex684 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l685
						}
						position++
						goto l684
					l685:
						position, tokenIndex = position684, tokenIndex684
						if buffer[position] != rune('R') {
							goto l679
						}
						position++
					}
				l684:
					goto l656
				l679:
					position, tokenIndex = position656, tokenIndex656
					{
						position687, tokenIndex687 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l688
						}
						position++
						goto l687
					l688:
						position, tokenIndex = position687, tokenIndex687
						if buffer[position] != rune('N') {
							goto l686
						}
						position++
					}
				l687:
					{
						position689, tokenIndex689 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l690
						}
						position++
						goto l689
					l690:
						position, tokenIndex = position689, tokenIndex689
						if buffer[position] != rune('Z') {
							goto l686
						}
						position++
					}
				l689:
					{
						position691, tokenIndex691 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l692
						}
						position++
						goto l691
					l692:
						position, tokenIndex = position691, tokenIndex691
						if buffer[position] != rune('C') {
							goto l686
						}
						position++
					}
				l691:
					{
						position693, tokenIndex693 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l694
						}
						position++
						goto l693
					l694:
						position, tokenIndex = position693, tokenIndex693
						if buffer[position] != rune('V') {
							goto l686
						}
						position++
					}
				l693:
					goto l656
				l686:
					position, tokenIndex = position656, tokenIndex656
					if !_rules[ruleSVE2PredicateRegister]() {
						goto l695
					}
					goto l656
				l695:
					position, tokenIndex = position656, tokenIndex656
					if !_rules[ruleARMVectorRegister]() {
						goto l696
					}
					goto l656
				l696:
					position, tokenIndex = position656, tokenIndex656
					if !_rules[ruleSVE2SpecialValue]() {
						goto l697
					}
					goto l656
				l697:
					position, tokenIndex = position656, tokenIndex656
					if buffer[position] != rune('{') {
						goto l654
					}
					position++
					{
						position698, tokenIndex698 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l698
						}
						goto l699
					l698:
						position, tokenIndex = position698, tokenIndex698
					}
				l699:
					if !_rules[ruleARMVectorRegister]() {
						goto l654
					}
				l700:
					{
						position701, tokenIndex701 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l701
						}
						position++
						{
							position702, tokenIndex702 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l702
							}
							goto l703
						l702:
							position, tokenIndex = position702, tokenIndex702
						}
					l703:
						if !_rules[ruleARMVectorRegister]() {
							goto l701
						}
						goto l700
					l701:
						position, tokenIndex = position701, tokenIndex701
					}
					{
						position704, tokenIndex704 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l704
						}
						goto l705
					l704:
						position, tokenIndex = position704, tokenIndex704
					}
				l705:
					if buffer[position] != rune('}') {
						goto l654
					}
					position++
					{
						position706, tokenIndex706 := position, tokenIndex
						if buffer[position] != rune('[') {
							goto l706
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l706
						}
						position++
						{
							position708, tokenIndex708 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l708
							}
							position++
							goto l709
						l708:
							position, tokenIndex = position708, tokenIndex708
						}
					l709:
						if buffer[position] != rune(']') {
							goto l706
						}
						position++
						goto l707
					l706:
						position, tokenIndex = position706, tokenIndex706
					}
				l707:
				}
			l656:
				add(ruleARMRegister, position655)
			}
			return true
		l654:
			position, tokenIndex = position654, tokenIndex654
			return false
		},
		/* 46 ARMVectorRegister <- <(('p' / 'v' / 'z') [0-9] [0-9]? !([0-9] / [0-9] / ([a-z] / [A-Z]) / '_') ('.' [0-9]* ('b' / 's' / 'd' / 'h' / 'q') ('[' [0-9] [0-9]? ']')?)?)> */
		func() bool {
			position710, tokenIndex710 := position, tokenIndex
			{
				position711 := position
				{
					position712, tokenIndex712 := position, tokenIndex
					if buffer[position] != rune('p') {
						goto l713
					}
					position++
					goto l712
				l713:
					position, tokenIndex = position712, tokenIndex712
					if buffer[position] != rune('v') {
						goto l714
					}
					position++
					goto l712
				l714:
					position, tokenIndex = position712, tokenIndex712
					if buffer[position] != rune('z') {
						goto l710
					}
					position++
				}
			l712:
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l710
				}
				position++
				{
					position715, tokenIndex715 := position, tokenIndex
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l715
					}
					position++
					goto l716
				l715:
					position, tokenIndex = position715, tokenIndex715
				}
			l716:
				{
					position717, tokenIndex717 := position, tokenIndex
					{
						position718, tokenIndex718 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l719
						}
						position++
						goto l718
					l719:
						position, tokenIndex = position718, tokenIndex718
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l720
						}
						position++
						goto l718
					l720:
						position, tokenIndex = position718, tokenIndex718
						{
							position722, tokenIndex722 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l723
							}
							position++
							goto l722
						l723:
							position, tokenIndex = position722, tokenIndex722
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l721
							}
							position++
						}
					l722:
						goto l718
					l721:
						position, tokenIndex = position718, tokenIndex718
						if buffer[position] != rune('_') {
							goto l717
						}
						position++
					}
				l718:
					goto l710
				l717:
					position, tokenIndex = position717, tokenIndex717
				}
				{
					position724, tokenIndex724 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l724
					}
					position++
				l726:
					{
						position727, tokenIndex727 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l727
						}
						position++
						goto l726
					l727:
						position, tokenIndex = position727, tokenIndex727
					}
					{
						position728, tokenIndex728 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l729
						}
						position++
						goto l728
					l729:
						position, tokenIndex = position728, tokenIndex728
						if buffer[position] != rune('s') {
							goto l730
						}
						position++
						goto l728
					l730:
						position, tokenIndex = position728, tokenIndex728
						if buffer[position] != rune('d') {
							goto l731
						}
						position++
						goto l728
					l731:
						position, tokenIndex = position728, tokenIndex728
						if buffer[position] != rune('h') {
							goto l732
						}
						position++
						goto l728
					l732:
						position, tokenIndex = position728, tokenIndex728
						if buffer[position] != rune('q') {
							goto l724
						}
						position++
					}
				l728:
					{
						position733, tokenIndex733 := position, tokenIndex
						if buffer[position] != rune('[') {
							goto l733
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l733
						}
						position++
						{
							position735, tokenIndex735 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l735
							}
							position++
							goto l736
						l735:
							position, tokenIndex = position735, tokenIndex735
						}
					l736:
						if buffer[position] != rune(']') {
							goto l733
						}
						position++
						goto l734
					l733:
						position, tokenIndex = position733, tokenIndex733
					}
				l734:
					goto l725
				l724:
					position, tokenIndex = position724, tokenIndex724
				}
			l725:
				add(ruleARMVectorRegister, position711)
			}
			return true
		l710:
			position, tokenIndex = position710, tokenIndex710
			return false
		},
		/* 47 SVE2PredicateRegister <- <(('p' / 'P') [0-9] [0-9]? '/' ('m' / 'M' / ('z' / 'Z')))> */
		func() bool {
			position737, tokenIndex737 := position, tokenIndex
			{
				position738 := position
				{
					position739, tokenIndex739 := position, tokenIndex
					if buffer[position] != rune('p') {
						goto l740
					}
					position++
					goto l739
				l740:
					position, tokenIndex = position739, tokenIndex739
					if buffer[position] != rune('P') {
						goto l737
					}
					position++
				}
			l739:
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l737
				}
				position++
				{
					position741, tokenIndex741 := position, tokenIndex
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l741
					}
					position++
					goto l742
				l741:
					position, tokenIndex = position741, tokenIndex741
				}
			l742:
				if buffer[position] != rune('/') {
					goto l737
				}
				position++
				{
					position743, tokenIndex743 := position, tokenIndex
					if buffer[position] != rune('m') {
						goto l744
					}
					position++
					goto l743
				l744:
					position, tokenIndex = position743, tokenIndex743
					if buffer[position] != rune('M') {
						goto l745
					}
					position++
					goto l743
				l745:
					position, tokenIndex = position743, tokenIndex743
					{
						position746, tokenIndex746 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l747
						}
						position++
						goto l746
					l747:
						position, tokenIndex = position746, tokenIndex746
						if buffer[position] != rune('Z') {
							goto l737
						}
						position++
					}
				l746:
				}
			l743:
				add(ruleSVE2PredicateRegister, position738)
			}
			return true
		l737:
			position, tokenIndex = position737, tokenIndex737
			return false
		},
		/* 48 SVE2SpecialValue <- <(((('p' / 'P') ('o' / 'O') ('w' / 'W') '2') / (('v' / 'V') ('l' / 'L') ('1' / '2' / '3' / '4' / '5' / '6' / '7' / '8') ![0-9]) / (('v' / 'V') ('l' / 'L') '1' '6') / (('v' / 'V') ('l' / 'L') '3' '2') / (('v' / 'V') ('l' / 'L') '6' '4') / (('v' / 'V') ('l' / 'L') '1' '2' '8') / (('v' / 'V') ('l' / 'L') '2' '5' '6') / (('m' / 'M') ('u' / 'U') ('l' / 'L') '3') / (('m' / 'M') ('u' / 'U') ('l' / 'L') '4') / (('a' / 'A') ('l' / 'L') ('l' / 'L'))) !([0-9] / [0-9] / ([a-z] / [A-Z]) / '_'))> */
		func() bool {
			position748, tokenIndex748 := position, tokenIndex
			{
				position749 := position
				{
					position750, tokenIndex750 := position, tokenIndex
					{
						position752, tokenIndex752 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l753
						}
						position++
						goto l752
					l753:
						position, tokenIndex = position752, tokenIndex752
						if buffer[position] != rune('P') {
							goto l751
						}
						position++
					}
				l752:
					{
						position754, tokenIndex754 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l755
						}
						position++
						goto l754
					l755:
						position, tokenIndex = position754, tokenIndex754
						if buffer[position] != rune('O') {
							goto l751
						}
						position++
					}
				l754:
					{
						position756, tokenIndex756 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l757
						}
						position++
						goto l756
					l757:
						position, tokenIndex = position756, tokenIndex756
						if buffer[position] != rune('W') {
							goto l751
						}
						position++
					}
				l756:
					if buffer[position] != rune('2') {
						goto l751
					}
					position++
					goto l750
				l751:
					position, tokenIndex = position750, tokenIndex750
					{
						position759, tokenIndex759 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l760
						}
						position++
						goto l759
					l760:
						position, tokenIndex = position759, tokenIndex759
						if buffer[position] != rune('V') {
							goto l758
						}
						position++
					}
				l759:
					{
						position761, tokenIndex761 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l762
						}
						position++
						goto l761
					l762:
						position, tokenIndex = position761, tokenIndex761
						if buffer[position] != rune('L') {
							goto l758
						}
						position++
					}
				l761:
					{
						position763, tokenIndex763 := position, tokenIndex
						if buffer[position] != rune('1') {
							goto l764
						}
						position++
						goto l763
					l764:
						position, tokenIndex = position763, tokenIndex763
						if buffer[position] != rune('2') {
							goto l765
						}
						position++
						goto l763
					l765:
						position, tokenIndex = position763, tokenIndex763
						if buffer[position] != rune('3') {
							goto l766
						}
						position++
						goto l763
					l766:
						position, tokenIndex = position763, tokenIndex763
						if buffer[position] != rune('4') {
							goto l767
						}
						position++
						goto l763
					l767:
						position, tokenIndex = position763, tokenIndex763
						if buffer[position] != rune('5') {
							goto l768
						}
						position++
						goto l763
					l768:
						position, tokenIndex = position763, tokenIndex763
						if buffer[position] != rune('6') {
							goto l769
						}
						position++
						goto l763
					l769:
						position, tokenIndex = position763, tokenIndex763
						if buffer[position] != rune('7') {
							goto l770
						}
						position++
						goto l763
					l770:
						position, tokenIndex = position763, tokenIndex763
						if buffer[position] != rune('8') {
							goto l758
						}
						position++
					}
				l763:
					{
						position771, tokenIndex771 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l771
						}
						position++
						goto l758
					l771:
						position, tokenIndex = position771, tokenIndex771
					}
					goto l750
				l758:
					position, tokenIndex = position750, tokenIndex750
					{
						position773, tokenIndex773 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l774
						}
						position++
						goto l773
					l774:
						position, tokenIndex = position773, tokenIndex773
						if buffer[position] != rune('V') {
							goto l772
						}
						position++
					}
				l773:
					{
						position775, tokenIndex775 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l776
						}
						position++
						goto l775
					l776:
						position, tokenIndex = position775, tokenIndex775
						if buffer[position] != rune('L') {
							goto l772
						}
						position++
					}
				l775:
					if buffer[position] != rune('1') {
						goto l772
					}
					position++
					if buffer[position] != rune('6') {
						goto l772
					}
					position++
					goto l750
				l772:
					position, tokenIndex = position750, tokenIndex750
					{
						position778, tokenIndex778 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l779
						}
						position++
						goto l778
					l779:
						position, tokenIndex = position778, tokenIndex778
						if buffer[position] != rune('V') {
							goto l777
						}
						position++
					}
				l778:
					{
						position780, tokenIndex780 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l781
						}
						position++
						goto l780
					l781:
						position, tokenIndex = position780, tokenIndex780
						if buffer[position] != rune('L') {
							goto l777
						}
						position++
					}
				l780:
					if buffer[position] != rune('3') {
						goto l777
					}
					position++
					if buffer[position] != rune('2') {
						goto l777
					}
					position++
					goto l750
				l777:
					position, tokenIndex = position750, tokenIndex750
					{
						position783, tokenIndex783 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l784
						}
						position++
						goto l783
					l784:
						position, tokenIndex = position783, tokenIndex783
						if buffer[position] != rune('V') {
							goto l782
						}
						position++
					}
				l783:
					{
						position785, tokenIndex785 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l786
						}
						position++
						goto l785
					l786:
						position, tokenIndex = position785, tokenIndex785
						if buffer[position] != rune('L') {
							goto l782
						}
						position++
					}
				l785:
					if buffer[position] != rune('6') {
						goto l782
					}
					position++
					if buffer[position] != rune('4') {
						goto l782
					}
					position++
					goto l750
				l782:
					position, tokenIndex = position750, tokenIndex750
					{
						position788, tokenIndex788 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l789
						}
						position++
						goto l788
					l789:
						position, tokenIndex = position788, tokenIndex788
						if buffer[position] != rune('V') {
							goto l787
						}
						position++
					}
				l788:
					{
						position790, tokenIndex790 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l791
						}
						position++
						goto l790
					l791:
						position, tokenIndex = position790, tokenIndex790
						if buffer[position] != rune('L') {
							goto l787
						}
						position++
					}
				l790:
					if buffer[position] != rune('1') {
						goto l787
					}
					position++
					if buffer[position] != rune('2') {
						goto l787
					}
					position++
					if buffer[position] != rune('8') {
						goto l787
					}
					position++
					goto l750
				l787:
					position, tokenIndex = position750, tokenIndex750
					{
						position793, tokenIndex793 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l794
						}
						position++
						goto l793
					l794:
						position, tokenIndex = position793, tokenIndex793
						if buffer[position] != rune('V') {
							goto l792
						}
						position++
					}
				l793:
					{
						position795, tokenIndex795 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l796
						}
						position++
						goto l795
					l796:
						position, tokenIndex = position795, tokenIndex795
						if buffer[position] != rune('L') {
							goto l792
						}
						position++
					}
				l795:
					if buffer[position] != rune('2') {
						goto l792
					}
					position++
					if buffer[position] != rune('5') {
						goto l792
					}
					position++
					if buffer[position] != rune('6') {
						goto l792
					}
					position++
					goto l750
				l792:
					position, tokenIndex = position750, tokenIndex750
					{
						position798, tokenIndex798 := position, tokenIndex
						if buffer[position] != rune('m') {
							goto l799
						}
						position++
						goto l798
					l799:
						position, tokenIndex = position798, tokenIndex798
						if buffer[position] != rune('M') {
							goto l797
						}
						position++
					}
				l798:
					{
						position800, tokenIndex800 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l801
						}
						position++
						goto l800
					l801:
						position, tokenIndex = position800, tokenIndex800
						if buffer[position] != rune('U') {
							goto l797
						}
						position++
					}
				l800:
					{
						position802, tokenIndex802 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l803
						}
						position++
						goto l802
					l803:
						position, tokenIndex = position802, tokenIndex802
						if buffer[position] != rune('L') {
							goto l797
						}
						position++
					}
				l802:
					if buffer[position] != rune('3') {
						goto l797
					}
					position++
					goto l750
				l797:
					position, tokenIndex = position750, tokenIndex750
					{
						position805, tokenIndex805 := position, tokenIndex
						if buffer[position] != rune('m') {
							goto l806
						}
						position++
						goto l805
					l806:
						position, tokenIndex = position805, tokenIndex805
						if buffer[position] != rune('M') {
							goto l804
						}
						position++
					}
				l805:
					{
						position807, tokenIndex807 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l808
						}
						position++
						goto l807
					l808:
						position, tokenIndex = position807, tokenIndex807
						if buffer[position] != rune('U') {
							goto l804
						}
						position++
					}
				l807:
					{
						position809, tokenIndex809 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l810
						}
						position++
						goto l809
					l810:
						position, tokenIndex = position809, tokenIndex809
						if buffer[position] != rune('L') {
							goto l804
						}
						position++
					}
				l809:
					if buffer[position] != rune('4') {
						goto l804
					}
					position++
					goto l750
				l804:
					position, tokenIndex = position750, tokenIndex750
					{
						position811, tokenIndex811 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l812
						}
						position++
						goto l811
					l812:
						position, tokenIndex = position811, tokenIndex811
						if buffer[position] != rune('A') {
							goto l748
						}
						position++
					}
				l811:
					{
						position813, tokenIndex813 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l814
						}
						position++
						goto l813
					l814:
						position, tokenIndex = position813, tokenIndex813
						if buffer[position] != rune('L') {
							goto l748
						}
						position++
					}
				l813:
					{
						position815, tokenIndex815 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l816
						}
						position++
						goto l815
					l816:
						position, tokenIndex = position815, tokenIndex815
						if buffer[position] != rune('L') {
							goto l748
						}
						position++
					}
				l815:
				}
			l750:
				{
					position817, tokenIndex817 := position, tokenIndex
					{
						position818, tokenIndex818 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l819
						}
						position++
						goto l818
					l819:
						position, tokenIndex = position818, tokenIndex818
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l820
						}
						position++
						goto l818
					l820:
						position, tokenIndex = position818, tokenIndex818
						{
							position822, tokenIndex822 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l823
							}
							position++
							goto l822
						l823:
							position, tokenIndex = position822, tokenIndex822
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l821
							}
							position++
						}
					l822:
						goto l818
					l821:
						position, tokenIndex = position818, tokenIndex818
						if buffer[position] != rune('_') {
							goto l817
						}
						position++
					}
				l818:
					goto l748
				l817:
					position, tokenIndex = position817, tokenIndex817
				}
				add(ruleSVE2SpecialValue, position749)
			}
			return true
		l748:
			position, tokenIndex = position748, tokenIndex748
			return false
		},
		/* 49 MemoryRef <- <((SymbolRef BaseIndexScale) / SymbolRef / Low12BitsSymbolRef / (Offset* BaseIndexScale) / (SegmentRegister Offset BaseIndexScale) / (SegmentRegister BaseIndexScale) / (SegmentRegister Offset) / ARMBaseIndexScale / BaseIndexScale)> */
		func() bool {
			position824, tokenIndex824 := position, tokenIndex
			{
				position825 := position
				{
					position826, tokenIndex826 := position, tokenIndex
					if !_rules[ruleSymbolRef]() {
						goto l827
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l827
					}
					goto l826
				l827:
					position, tokenIndex = position826, tokenIndex826
					if !_rules[ruleSymbolRef]() {
						goto l828
					}
					goto l826
				l828:
					position, tokenIndex = position826, tokenIndex826
					if !_rules[ruleLow12BitsSymbolRef]() {
						goto l829
					}
					goto l826
				l829:
					position, tokenIndex = position826, tokenIndex826
				l831:
					{
						position832, tokenIndex832 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l832
						}
						goto l831
					l832:
						position, tokenIndex = position832, tokenIndex832
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l830
					}
					goto l826
				l830:
					position, tokenIndex = position826, tokenIndex826
					if !_rules[ruleSegmentRegister]() {
						goto l833
					}
					if !_rules[ruleOffset]() {
						goto l833
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l833
					}
					goto l826
				l833:
					position, tokenIndex = position826, tokenIndex826
					if !_rules[ruleSegmentRegister]() {
						goto l834
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l834
					}
					goto l826
				l834:
					position, tokenIndex = position826, tokenIndex826
					if !_rules[ruleSegmentRegister]() {
						goto l835
					}
					if !_rules[ruleOffset]() {
						goto l835
					}
					goto l826
				l835:
					position, tokenIndex = position826, tokenIndex826
					if !_rules[ruleARMBaseIndexScale]() {
						goto l836
					}
					goto l826
				l836:
					position, tokenIndex = position826, tokenIndex826
					if !_rules[ruleBaseIndexScale]() {
						goto l824
					}
				}
			l826:
				add(ruleMemoryRef, position825)
			}
			return true
		l824:
			position, tokenIndex = position824, tokenIndex824
			return false
		},
		/* 50 SymbolRef <- <((Offset* '+')? (LocalSymbol / SymbolName) Offset* ('@' Section Offset*)?)> */
		func() bool {
			position837, tokenIndex837 := position, tokenIndex
			{
				position838 := position
				{
					position839, tokenIndex839 := position, tokenIndex
				l841:
					{
						position842, tokenIndex842 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l842
						}
						goto l841
					l842:
						position, tokenIndex = position842, tokenIndex842
					}
					if buffer[position] != rune('+') {
						goto l839
					}
					position++
					goto l840
				l839:
					position, tokenIndex = position839, tokenIndex839
				}
			l840:
				{
					position843, tokenIndex843 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l844
					}
					goto l843
				l844:
					position, tokenIndex = position843, tokenIndex843
					if !_rules[ruleSymbolName]() {
						goto l837
					}
				}
			l843:
			l845:
				{
					position846, tokenIndex846 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l846
					}
					goto l845
				l846:
					position, tokenIndex = position846, tokenIndex846
				}
				{
					position847, tokenIndex847 := position, tokenIndex
					if buffer[position] != rune('@') {
						goto l847
					}
					position++
					if !_rules[ruleSection]() {
						goto l847
					}
				l849:
					{
						position850, tokenIndex850 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l850
						}
						goto l849
					l850:
						position, tokenIndex = position850, tokenIndex850
					}
					goto l848
				l847:
					position, tokenIndex = position847, tokenIndex847
				}
			l848:
				add(ruleSymbolRef, position838)
			}
			return true
		l837:
			position, tokenIndex = position837, tokenIndex837
			return false
		},
		/* 51 Low12BitsSymbolRef <- <(':' ('l' / 'L') ('o' / 'O') '1' '2' ':' (LocalSymbol / SymbolName) Offset?)> */
		func() bool {
			position851, tokenIndex851 := position, tokenIndex
			{
				position852 := position
				if buffer[position] != rune(':') {
					goto l851
				}
				position++
				{
					position853, tokenIndex853 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l854
					}
					position++
					goto l853
				l854:
					position, tokenIndex = position853, tokenIndex853
					if buffer[position] != rune('L') {
						goto l851
					}
					position++
				}
			l853:
				{
					position855, tokenIndex855 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l856
					}
					position++
					goto l855
				l856:
					position, tokenIndex = position855, tokenIndex855
					if buffer[position] != rune('O') {
						goto l851
					}
					position++
				}
			l855:
				if buffer[position] != rune('1') {
					goto l851
				}
				position++
				if buffer[position] != rune('2') {
					goto l851
				}
				position++
				if buffer[position] != rune(':') {
					goto l851
				}
				position++
				{
					position857, tokenIndex857 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l858
					}
					goto l857
				l858:
					position, tokenIndex = position857, tokenIndex857
					if !_rules[ruleSymbolName]() {
						goto l851
					}
				}
			l857:
				{
					position859, tokenIndex859 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l859
					}
					goto l860
				l859:
					position, tokenIndex = position859, tokenIndex859
				}
			l860:
				add(ruleLow12BitsSymbolRef, position852)
			}
			return true
		l851:
			position, tokenIndex = position851, tokenIndex851
			return false
		},
		/* 52 ARMBaseIndexScale <- <('[' ARMRegister (',' WS? (('#' Offset (('*' [0-9]+) / ('*' '(' [0-9]+ Operator [0-9]+ ')') / ('+' [0-9]+)*)?) / ARMGOTLow12 / Low12BitsSymbolRef / ARMRegister) (',' WS? ARMConstantTweak)?)? ']' ARMPostincrement?)> */
		func() bool {
			position861, tokenIndex861 := position, tokenIndex
			{
				position862 := position
				if buffer[position] != rune('[') {
					goto l861
				}
				position++
				if !_rules[ruleARMRegister]() {
					goto l861
				}
				{
					position863, tokenIndex863 := position, tokenIndex
					if buffer[position] != rune(',') {
						goto l863
					}
					position++
					{
						position865, tokenIndex865 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l865
						}
						goto l866
					l865:
						position, tokenIndex = position865, tokenIndex865
					}
				l866:
					{
						position867, tokenIndex867 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l868
						}
						position++
						if !_rules[ruleOffset]() {
							goto l868
						}
						{
							position869, tokenIndex869 := position, tokenIndex
							{
								position871, tokenIndex871 := position, tokenIndex
								if buffer[position] != rune('*') {
									goto l872
								}
								position++
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l872
								}
								position++
							l873:
								{
									position874, tokenIndex874 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l874
									}
									position++
									goto l873
								l874:
									position, tokenIndex = position874, tokenIndex874
								}
								goto l871
							l872:
								position, tokenIndex = position871, tokenIndex871
								if buffer[position] != rune('*') {
									goto l875
								}
								position++
								if buffer[position] != rune('(') {
									goto l875
								}
								position++
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l875
								}
								position++
							l876:
								{
									position877, tokenIndex877 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l877
									}
									position++
									goto l876
								l877:
									position, tokenIndex = position877, tokenIndex877
								}
								if !_rules[ruleOperator]() {
									goto l875
								}
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l875
								}
								position++
							l878:
								{
									position879, tokenIndex879 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l879
									}
									position++
									goto l878
								l879:
									position, tokenIndex = position879, tokenIndex879
								}
								if buffer[position] != rune(')') {
									goto l875
								}
								position++
								goto l871
							l875:
								position, tokenIndex = position871, tokenIndex871
							l880:
								{
									position881, tokenIndex881 := position, tokenIndex
									if buffer[position] != rune('+') {
										goto l881
									}
									position++
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l881
									}
									position++
								l882:
									{
										position883, tokenIndex883 := position, tokenIndex
										if c := buffer[position]; c < rune('0') || c > rune('9') {
											goto l883
										}
										position++
										goto l882
									l883:
										position, tokenIndex = position883, tokenIndex883
									}
									goto l880
								l881:
									position, tokenIndex = position881, tokenIndex881
								}
							}
						l871:
							goto l870

							position, tokenIndex = position869, tokenIndex869
						}
					l870:
						goto l867
					l868:
						position, tokenIndex = position867, tokenIndex867
						if !_rules[ruleARMGOTLow12]() {
							goto l884
						}
						goto l867
					l884:
						position, tokenIndex = position867, tokenIndex867
						if !_rules[ruleLow12BitsSymbolRef]() {
							goto l885
						}
						goto l867
					l885:
						position, tokenIndex = position867, tokenIndex867
						if !_rules[ruleARMRegister]() {
							goto l863
						}
					}
				l867:
					{
						position886, tokenIndex886 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l886
						}
						position++
						{
							position888, tokenIndex888 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l888
							}
							goto l889
						l888:
							position, tokenIndex = position888, tokenIndex888
						}
					l889:
						if !_rules[ruleARMConstantTweak]() {
							goto l886
						}
						goto l887
					l886:
						position, tokenIndex = position886, tokenIndex886
					}
				l887:
					goto l864
				l863:
					position, tokenIndex = position863, tokenIndex863
				}
			l864:
				if buffer[position] != rune(']') {
					goto l861
				}
				position++
				{
					position890, tokenIndex890 := position, tokenIndex
					if !_rules[ruleARMPostincrement]() {
						goto l890
					}
					goto l891
				l890:
					position, tokenIndex = position890, tokenIndex890
				}
			l891:
				add(ruleARMBaseIndexScale, position862)
			}
			return true
		l861:
			position, tokenIndex = position861, tokenIndex861
			return false
		},
		/* 53 ARMGOTLow12 <- <(':' ('g' / 'G') ('o' / 'O') ('t' / 'T') '_' ('l' / 'L') ('o' / 'O') '1' '2' ':' SymbolName)> */
		func() bool {
			position892, tokenIndex892 := position, tokenIndex
			{
				position893 := position
				if buffer[position] != rune(':') {
					goto l892
				}
				position++
				{
					position894, tokenIndex894 := position, tokenIndex
					if buffer[position] != rune('g') {
						goto l895
					}
					position++
					goto l894
				l895:
					position, tokenIndex = position894, tokenIndex894
					if buffer[position] != rune('G') {
						goto l892
					}
					position++
				}
			l894:
				{
					position896, tokenIndex896 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l897
					}
					position++
					goto l896
				l897:
					position, tokenIndex = position896, tokenIndex896
					if buffer[position] != rune('O') {
						goto l892
					}
					position++
				}
			l896:
				{
					position898, tokenIndex898 := position, tokenIndex
					if buffer[position] != rune('t') {
						goto l899
					}
					position++
					goto l898
				l899:
					position, tokenIndex = position898, tokenIndex898
					if buffer[position] != rune('T') {
						goto l892
					}
					position++
				}
			l898:
				if buffer[position] != rune('_') {
					goto l892
				}
				position++
				{
					position900, tokenIndex900 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l901
					}
					position++
					goto l900
				l901:
					position, tokenIndex = position900, tokenIndex900
					if buffer[position] != rune('L') {
						goto l892
					}
					position++
				}
			l900:
				{
					position902, tokenIndex902 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l903
					}
					position++
					goto l902
				l903:
					position, tokenIndex = position902, tokenIndex902
					if buffer[position] != rune('O') {
						goto l892
					}
					position++
				}
			l902:
				if buffer[position] != rune('1') {
					goto l892
				}
				position++
				if buffer[position] != rune('2') {
					goto l892
				}
				position++
				if buffer[position] != rune(':') {
					goto l892
				}
				position++
				if !_rules[ruleSymbolName]() {
					goto l892
				}
				add(ruleARMGOTLow12, position893)
			}
			return true
		l892:
			position, tokenIndex = position892, tokenIndex892
			return false
		},
		/* 54 ARMPostincrement <- <'!'> */
		func() bool {
			position904, tokenIndex904 := position, tokenIndex
			{
				position905 := position
				if buffer[position] != rune('!') {
					goto l904
				}
				position++
				add(ruleARMPostincrement, position905)
			}
			return true
		l904:
			position, tokenIndex = position904, tokenIndex904
			return false
		},
		/* 55 BaseIndexScale <- <('(' RegisterOrConstant? WS? (',' WS? RegisterOrConstant WS? (',' [0-9]+)?)? ')')> */
		func() bool {
			position906, tokenIndex906 := position, tokenIndex
			{
				position907 := position
				if buffer[position] != rune('(') {
					goto l906
				}
				position++
				{
					position908, tokenIndex908 := position, tokenIndex
					if !_rules[ruleRegisterOrConstant]() {
						goto l908
					}
					goto l909
				l908:
					position, tokenIndex = position908, tokenIndex908
				}
			l909:
				{
					position910, tokenIndex910 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l910
					}
					goto l911
				l910:
					position, tokenIndex = position910, tokenIndex910
				}
			l911:
				{
					position912, tokenIndex912 := position, tokenIndex
					if buffer[position] != rune(',') {
						goto l912
					}
					position++
					{
						position914, tokenIndex914 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l914
						}
						goto l915
					l914:
						position, tokenIndex = position914, tokenIndex914
					}
				l915:
					if !_rules[ruleRegisterOrConstant]() {
						goto l912
					}
					{
						position916, tokenIndex916 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l916
						}
						goto l917
					l916:
						position, tokenIndex = position916, tokenIndex916
					}
				l917:
					{
						position918, tokenIndex918 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l918
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l918
						}
						position++
					l920:
						{
							position921, tokenIndex921 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l921
							}
							position++
							goto l920
						l921:
							position, tokenIndex = position921, tokenIndex921
						}
						goto l919
					l918:
						position, tokenIndex = position918, tokenIndex918
					}
				l919:
					goto l913
				l912:
					position, tokenIndex = position912, tokenIndex912
				}
			l913:
				if buffer[position] != rune(')') {
					goto l906
				}
				position++
				add(ruleBaseIndexScale, position907)
			}
			return true
		l906:
			position, tokenIndex = position906, tokenIndex906
			return false
		},
		/* 56 Operator <- <('+' / '-')> */
		func() bool {
			position922, tokenIndex922 := position, tokenIndex
			{
				position923 := position
				{
					position924, tokenIndex924 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l925
					}
					position++
					goto l924
				l925:
					position, tokenIndex = position924, tokenIndex924
					if buffer[position] != rune('-') {
						goto l922
					}
					position++
				}
			l924:
				add(ruleOperator, position923)
			}
			return true
		l922:
			position, tokenIndex = position922, tokenIndex922
			return false
		},
		/* 57 Offset <- <('+'? '-'? (('0' ('b' / 'B') ('0' / '1')+) / ('0' ('x' / 'X') ([0-9] / [0-9] / ([a-f] / [A-F]))+) / [0-9]+))> */
		func() bool {
			position926, tokenIndex926 := position, tokenIndex
			{
				position927 := position
				{
					position928, tokenIndex928 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l928
					}
					position++
					goto l929
				l928:
					position, tokenIndex = position928, tokenIndex928
				}
			l929:
				{
					position930, tokenIndex930 := position, tokenIndex
					if buffer[position] != rune('-') {
						goto l930
					}
					position++
					goto l931
				l930:
					position, tokenIndex = position930, tokenIndex930
				}
			l931:
				{
					position932, tokenIndex932 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l933
					}
					position++
					{
						position934, tokenIndex934 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l935
						}
						position++
						goto l934
					l935:
						position, tokenIndex = position934, tokenIndex934
						if buffer[position] != rune('B') {
							goto l933
						}
						position++
					}
				l934:
					{
						position938, tokenIndex938 := position, tokenIndex
						if buffer[position] != rune('0') {
							goto l939
						}
						position++
						goto l938
					l939:
						position, tokenIndex = position938, tokenIndex938
						if buffer[position] != rune('1') {
							goto l933
						}
						position++
					}
				l938:
				l936:
					{
						position937, tokenIndex937 := position, tokenIndex
						{
							position940, tokenIndex940 := position, tokenIndex
							if buffer[position] != rune('0') {
								goto l941
							}
							position++
							goto l940
						l941:
							position, tokenIndex = position940, tokenIndex940
							if buffer[position] != rune('1') {
								goto l937
							}
							position++
						}
					l940:
						goto l936
					l937:
						position, tokenIndex = position937, tokenIndex937
					}
					goto l932
				l933:
					position, tokenIndex = position932, tokenIndex932
					if buffer[position] != rune('0') {
						goto l942
					}
					position++
					{
						position943, tokenIndex943 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l944
						}
						position++
						goto l943
					l944:
						position, tokenIndex = position943, tokenIndex943
						if buffer[position] != rune('X') {
							goto l942
						}
						position++
					}
				l943:
					{
						position947, tokenIndex947 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l948
						}
						position++
						goto l947
					l948:
						position, tokenIndex = position947, tokenIndex947
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l949
						}
						position++
						goto l947
					l949:
						position, tokenIndex = position947, tokenIndex947
						{
							position950, tokenIndex950 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('f') {
								goto l951
							}
							position++
							goto l950
						l951:
							position, tokenIndex = position950, tokenIndex950
							if c := buffer[position]; c < rune('A') || c > rune('F') {
								goto l942
							}
							position++
						}
					l950:
					}
				l947:
				l945:
					{
						position946, tokenIndex946 := position, tokenIndex
						{
							position952, tokenIndex952 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l953
							}
							position++
							goto l952
						l953:
							position, tokenIndex = position952, tokenIndex952
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l954
							}
							position++
							goto l952
						l954:
							position, tokenIndex = position952, tokenIndex952
							{
								position955, tokenIndex955 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('f') {
									goto l956
								}
								position++
								goto l955
							l956:
								position, tokenIndex = position955, tokenIndex955
								if c := buffer[position]; c < rune('A') || c > rune('F') {
									goto l946
								}
								position++
							}
						l955:
						}
					l952:
						goto l945
					l946:
						position, tokenIndex = position946, tokenIndex946
					}
					goto l932
				l942:
					position, tokenIndex = position932, tokenIndex932
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l926
					}
					position++
				l957:
					{
						position958, tokenIndex958 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l958
						}
						position++
						goto l957
					l958:
						position, tokenIndex = position958, tokenIndex958
					}
				}
			l932:
				add(ruleOffset, position927)
			}
			return true
		l926:
			position, tokenIndex = position926, tokenIndex926
			return false
		},
		/* 58 Section <- <([a-z] / [A-Z] / '@')+> */
		func() bool {
			position959, tokenIndex959 := position, tokenIndex
			{
				position960 := position
				{
					position963, tokenIndex963 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l964
					}
					position++
					goto l963
				l964:
					position, tokenIndex = position963, tokenIndex963
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l965
					}
					position++
					goto l963
				l965:
					position, tokenIndex = position963, tokenIndex963
					if buffer[position] != rune('@') {
						goto l959
					}
					position++
				}
			l963:
			l961:
				{
					position962, tokenIndex962 := position, tokenIndex
					{
						position966, tokenIndex966 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l967
						}
						position++
						goto l966
					l967:
						position, tokenIndex = position966, tokenIndex966
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l968
						}
						position++
						goto l966
					l968:
						position, tokenIndex = position966, tokenIndex966
						if buffer[position] != rune('@') {
							goto l962
						}
						position++
					}
				l966:
					goto l961
				l962:
					position, tokenIndex = position962, tokenIndex962
				}
				add(ruleSection, position960)
			}
			return true
		l959:
			position, tokenIndex = position959, tokenIndex959
			return false
		},
		/* 59 SegmentRegister <- <('%' ([c-g] / 's') ('s' ':'))> */
		func() bool {
			position969, tokenIndex969 := position, tokenIndex
			{
				position970 := position
				if buffer[position] != rune('%') {
					goto l969
				}
				position++
				{
					position971, tokenIndex971 := position, tokenIndex
					if c := buffer[position]; c < rune('c') || c > rune('g') {
						goto l972
					}
					position++
					goto l971
				l972:
					position, tokenIndex = position971, tokenIndex971
					if buffer[position] != rune('s') {
						goto l969
					}
					position++
				}
			l971:
				if buffer[position] != rune('s') {
					goto l969
				}
				position++
				if buffer[position] != rune(':') {
					goto l969
				}
				position++
				add(ruleSegmentRegister, position970)
			}
			return true
		l969:
			position, tokenIndex = position969, tokenIndex969
			return false
		},
	}
	p.rules = _rules
	return nil
}
