'''OpenGL extension EXT.texture_sRGB_R8

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.texture_sRGB_R8 to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces SR8_EXT as an acceptable internal format.
	This allows efficient sRGB sampling for source images stored as a separate
	texture per channel.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/texture_sRGB_R8.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.texture_sRGB_R8 import *
from OpenGL.raw.GLES2.EXT.texture_sRGB_R8 import _EXTENSION_NAME

def glInitTextureSrgbR8EXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION