# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Function primitives."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _func
else:
    import _func

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _func.delete_SwigPyIterator

    def value(self):
        return _func.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _func.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _func.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _func.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _func.SwigPyIterator_equal(self, x)

    def copy(self):
        return _func.SwigPyIterator_copy(self)

    def next(self):
        return _func.SwigPyIterator_next(self)

    def __next__(self):
        return _func.SwigPyIterator___next__(self)

    def previous(self):
        return _func.SwigPyIterator_previous(self)

    def advance(self, n):
        return _func.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _func.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _func.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _func.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _func.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _func.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _func.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _func:
_func.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.common
import openturns.typ
class NearestNeighbourAlgorithmImplementation(openturns.common.PersistentObject):
    r"""
    Nearest neighbour lookup.

    Base class to define an algorithm to search for nearest neighbours of
    a list of points.

    Parameters
    ----------
    sample : :class:`~openturns.Sample`
        Input points.

    Notes
    -----

    Two algorithms can be selected in any dimension:

    * :class:`~openturns.NaiveNearestNeighbour` loops over all points
      of the sample to find the closest one.
    * :class:`~openturns.KDTree` builds a binary tree.

    Two algorithms are specific to 1D input dimension, and much more efficient:

    * :class:`~openturns.RegularGridNearestNeighbour` is the most efficient
      algorithm when points corresponds to a :class:`~openturns.RegularGrid`,
      :meth:`query` works in constant time.
    * :class:`~openturns.NearestNeighbour1D` looks for nearest neighbour by
      dichotomy in 1D.

    It is recommended to use derived classes in order to select the best algorithm
    according to your data.  If you create a generic :class:`NearestNeighbourAlgorithm`,
    here is how the derived class is selected:

    * If points correspond to a :class:`~openturns.RegularGrid`,
      :class:`~openturns.RegularGridNearestNeighbour` algorithm is selected.
    * If input dimension is 1, :class:`~openturns.NearestNeighbour1D` is selected.
    * Otherwise, :class:`~openturns.KDTree` is selected.

    See also
    --------
    KDTree, NearestNeighbour1D, RegularGridNearestNeighbour, NaiveNearestNeighbour

    Examples
    --------
    >>> import openturns as ot
    >>> sample = ot.Normal(2).getSample(10)
    >>> finder = ot.NearestNeighbourAlgorithm(sample)
    >>> neighbour = sample[finder.query([0.1, 0.2])]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NearestNeighbourAlgorithmImplementation_getClassName(self)

    def getSample(self):
        r"""
        Get the points which have been used to build this nearest neighbour algorithm.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Input points.
        """
        return _func.NearestNeighbourAlgorithmImplementation_getSample(self)

    def setSample(self, sample):
        r"""
        Build a NearestNeighbourAlgorithm from these points.

        Parameters
        ----------
        sample : :class:`~openturns.Sample`
            Input points.
        """
        return _func.NearestNeighbourAlgorithmImplementation_setSample(self, sample)

    def query(self, *args):
        r"""
        Get the index of the nearest neighbour of the given point.

        Available usages:
            query(*point*)

            query(*sample*)

        Parameters
        ----------
        point : sequence of float
            Given point.
        sample : 2-d sequence of float
            Given points.

        Returns
        -------
        index : int
            Index of the nearest neighbour of the given point.
        indices : :class:`~openturns.Indices`
            Index of the nearest neighbour of the given points.
        """
        return _func.NearestNeighbourAlgorithmImplementation_query(self, *args)

    def queryK(self, x, k, sorted=False):
        r"""
        Get the indices of nearest neighbours of the given point.

        Parameters
        ----------
        x : sequence of float
            Given point.
        k : int
            Number of indices to return.
        sorted : bool, optional
            Boolean to tell whether returned indices are sorted according to
            the distance to the given point.

        Returns
        -------
        indices : sequence of int
            Indices of the `k` nearest neighbours of the given point.
        """
        return _func.NearestNeighbourAlgorithmImplementation_queryK(self, x, k, sorted)

    def __repr__(self):
        return _func.NearestNeighbourAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _func.NearestNeighbourAlgorithmImplementation___str__(self, *args)

    def __init__(self, *args):
        _func.NearestNeighbourAlgorithmImplementation_swiginit(self, _func.new_NearestNeighbourAlgorithmImplementation(*args))
    __swig_destroy__ = _func.delete_NearestNeighbourAlgorithmImplementation

# Register NearestNeighbourAlgorithmImplementation in _func:
_func.NearestNeighbourAlgorithmImplementation_swigregister(NearestNeighbourAlgorithmImplementation)
class _NearestNeighbourAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._NearestNeighbourAlgorithmImplementationTypedInterfaceObject_swiginit(self, _func.new__NearestNeighbourAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._NearestNeighbourAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._NearestNeighbourAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._NearestNeighbourAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._NearestNeighbourAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._NearestNeighbourAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__NearestNeighbourAlgorithmImplementationTypedInterfaceObject

# Register _NearestNeighbourAlgorithmImplementationTypedInterfaceObject in _func:
_func._NearestNeighbourAlgorithmImplementationTypedInterfaceObject_swigregister(_NearestNeighbourAlgorithmImplementationTypedInterfaceObject)
class NearestNeighbourAlgorithm(_NearestNeighbourAlgorithmImplementationTypedInterfaceObject):
    r"""
    Nearest neighbour lookup.

    Base class to define an algorithm to search for nearest neighbours of
    a list of points.

    Parameters
    ----------
    sample : :class:`~openturns.Sample`
        Input points.

    Notes
    -----

    Two algorithms can be selected in any dimension:

    * :class:`~openturns.NaiveNearestNeighbour` loops over all points
      of the sample to find the closest one.
    * :class:`~openturns.KDTree` builds a binary tree.

    Two algorithms are specific to 1D input dimension, and much more efficient:

    * :class:`~openturns.RegularGridNearestNeighbour` is the most efficient
      algorithm when points corresponds to a :class:`~openturns.RegularGrid`,
      :meth:`query` works in constant time.
    * :class:`~openturns.NearestNeighbour1D` looks for nearest neighbour by
      dichotomy in 1D.

    It is recommended to use derived classes in order to select the best algorithm
    according to your data.  If you create a generic :class:`NearestNeighbourAlgorithm`,
    here is how the derived class is selected:

    * If points correspond to a :class:`~openturns.RegularGrid`,
      :class:`~openturns.RegularGridNearestNeighbour` algorithm is selected.
    * If input dimension is 1, :class:`~openturns.NearestNeighbour1D` is selected.
    * Otherwise, :class:`~openturns.KDTree` is selected.

    See also
    --------
    KDTree, NearestNeighbour1D, RegularGridNearestNeighbour, NaiveNearestNeighbour

    Examples
    --------
    >>> import openturns as ot
    >>> sample = ot.Normal(2).getSample(10)
    >>> finder = ot.NearestNeighbourAlgorithm(sample)
    >>> neighbour = sample[finder.query([0.1, 0.2])]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NearestNeighbourAlgorithm_getClassName(self)

    def getSample(self):
        r"""
        Get the points which have been used to build this nearest neighbour algorithm.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Input points.
        """
        return _func.NearestNeighbourAlgorithm_getSample(self)

    def setSample(self, sample):
        r"""
        Build a NearestNeighbourAlgorithm from these points.

        Parameters
        ----------
        sample : :class:`~openturns.Sample`
            Input points.
        """
        return _func.NearestNeighbourAlgorithm_setSample(self, sample)

    def query(self, *args):
        r"""
        Get the index of the nearest neighbour of the given point.

        Available usages:
            query(*point*)

            query(*sample*)

        Parameters
        ----------
        point : sequence of float
            Given point.
        sample : 2-d sequence of float
            Given points.

        Returns
        -------
        index : int
            Index of the nearest neighbour of the given point.
        indices : :class:`~openturns.Indices`
            Index of the nearest neighbour of the given points.
        """
        return _func.NearestNeighbourAlgorithm_query(self, *args)

    def queryK(self, x, k, sorted=False):
        r"""
        Get the indices of nearest neighbours of the given point.

        Parameters
        ----------
        x : sequence of float
            Given point.
        k : int
            Number of indices to return.
        sorted : bool, optional
            Boolean to tell whether returned indices are sorted according to
            the distance to the given point.

        Returns
        -------
        indices : sequence of int
            Indices of the `k` nearest neighbours of the given point.
        """
        return _func.NearestNeighbourAlgorithm_queryK(self, x, k, sorted)

    def __repr__(self):
        return _func.NearestNeighbourAlgorithm___repr__(self)

    def __str__(self, *args):
        return _func.NearestNeighbourAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _func.NearestNeighbourAlgorithm_swiginit(self, _func.new_NearestNeighbourAlgorithm(*args))
    __swig_destroy__ = _func.delete_NearestNeighbourAlgorithm

# Register NearestNeighbourAlgorithm in _func:
_func.NearestNeighbourAlgorithm_swigregister(NearestNeighbourAlgorithm)
import openturns.geom
import openturns.graph
class EnumerateFunctionImplementation(openturns.common.PersistentObject):
    r"""
    Enumerate function.

    Notes
    -----
    *EnumerateFunction* is a bijection :math:`\vect{\alpha}`  from :math:`\Nset` to
    :math:`\Nset^{n_X}`. This bijection is based on a particular enumeration rule
    of the set of multi-indices.
    For any integer :math:`i \in \Nset`, the value of the enumerate function is:

    .. math::

        \vect{\alpha}(i) = (\alpha_1(i),\dots, \alpha_{n_X}(i)) \in {\Nset}^{n_X}.

    The first multi-index is:

    .. math::

        \vect{\alpha}(0) = (0, 0, \dots, 0).

    Let :math:`i, j \in \Nset` be any pair of indices. If :math:`|i - j|\leq 1` then:

    .. math::

        \left|\sum_{k=1}^{n_X} \left[ \alpha_k(i) - \alpha_k(j) \right]\right| \leq 1

    where :math:`\alpha_k(i)` is the k-th component of the multi-index :math:`\vect{\alpha}(i)`.
    This provides a necessary but insufficient condition 
    for the construction of the bijection: 
    a supplementary hypothesis must be made. 

    For example, consider the dimension :math:`\textrm{dim}=2`. 
    The following mapping is an enumerate function:

    .. math::

        \vect{\alpha}(0) &= (0, \; 0) \\
        \vect{\alpha}(1) &= (1, \; 0) \\
        \vect{\alpha}(2) &= (0, \; 1) \\
        \vect{\alpha}(3) &= (2, \; 0) \\
        \vect{\alpha}(4) &= (1, \; 1) \\
        \vect{\alpha}(5) &= (0, \; 2) \\
        \vect{\alpha}(6) &= (3, \; 0)

    For the functional expansion (respectively polynomial chaos expansion), the
    multi-index :math:`\vect{\alpha}` is the collection of marginal degrees of the
    selected orthogonal functions (respectively orthogonal polynomials). 
    More precisely, after the selection of the type of orthogonal functions (respectively
    orthogonal polynomials) for the construction of the orthogonal basis, the
    *EnumerateFunction* defines the
    marginal degrees of the univariate functions (respectively univariate polynomials).
    The multivariate tensor product function
    is based on the product of marginal univariate functions:

    .. math::

        \psi_{\vect{\alpha}}(\vect{x}) = \prod_{i = 1}^{n_X} \pi_{\alpha_i}^{(i)}(x_i)

    for any point :math:`\vect{x}` where :math:`\pi_{\alpha_i}^{(i)}` is the
    polynomial of degree :math:`\alpha_i` for the i-th marginal.
    The total degree of the polynomial is equal to the sum of the integers 
    in the multi-index:

    .. math::

        \operatorname{degree} \left(\psi_{\vect{\alpha}} \right) 
        = \sum_{i = 1}^{n_X} \alpha_i = \|\vect{\alpha}\|_1.

    For example, consider the multi-index :math:`\vect{\alpha} = (2, 0, 3)`. 
    This multi-index defines a multivariate polynomial which has a input
    vector of dimension 3.
    The marginal degree of the polynomial of the first dimension is equal to 2, 
    the marginal degree of the polynomial of the second dimension is equal to 0 
    and the marginal degree of the polynomial of the third dimension is equal to 3.

    Examples
    --------
    >>> import openturns as ot
    >>> dim = 2
    >>> enum_func = ot.LinearEnumerateFunction(dim)
    >>> for i in range(6):
    ...     print(enum_func(i))
    [0,0]
    [1,0]
    [0,1]
    [2,0]
    [1,1]
    [0,2]

    See Also
    --------
    LinearEnumerateFunction, HyperbolicAnisotropicEnumerateFunction, NormInfEnumerateFunction
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.EnumerateFunctionImplementation_getClassName(self)

    def __repr__(self):
        return _func.EnumerateFunctionImplementation___repr__(self)

    def __call__(self, index):
        return _func.EnumerateFunctionImplementation___call__(self, index)

    def inverse(self, indices):
        r"""
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enum_func(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enum_func.inverse([1,1]))
        4
        """
        return _func.EnumerateFunctionImplementation_inverse(self, indices)

    def getStrataCardinal(self, strataIndex):
        r"""
        Get the number of multi-indices in the basis inside a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata of the tensorized basis.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis inside the strata *strataIndex*.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        the strata *strataIndex* consists of a hyperplane of all the multi-indices of total degree
        *strataIndex*, and its cardinal is *strataIndex* + 1.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getStrataCardinal(2)
        3
        """
        return _func.EnumerateFunctionImplementation_getStrataCardinal(self, strataIndex)

    def getStrataCumulatedCardinal(self, strataIndex):
        r"""
        Get the number of multi-indices in the basis inside a range of stratas.

        Parameters
        ----------
        strataIndex : int
            Index of the strata of the tensorized basis.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis inside the stratas of index lower or equal to *strataIndex*.

        Notes
        -----
        The number of multi-indices is the total of multi-indices inside the stratas.
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this returns the number of multi-indices of maximal total degree *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getStrataCumulatedCardinal(2)
        6
        >>> sum([enum_func.getStrataCardinal(i) for i in range(3)])
        6
        """
        return _func.EnumerateFunctionImplementation_getStrataCumulatedCardinal(self, strataIndex)

    def getMaximumDegreeStrataIndex(self, maximumDegree):
        r"""
        Get the largest index of the strata containing multi-indices lower or equal to the given maximum degree.

        Parameters
        ----------
        max_deg : int
            Maximum total degree.

        Returns
        -------
        index : int
            Index of the last strata that contains multi-indices of total degree :math:`\leq \max_{deg}`.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this is the strata of index *max_deg*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getMaximumDegreeStrataIndex(2)
        2
        """
        return _func.EnumerateFunctionImplementation_getMaximumDegreeStrataIndex(self, maximumDegree)

    def getMaximumDegreeCardinal(self, maximumDegree):
        r"""
        Get the number of multi-indices of total degree lower or equal to a threshold.

        Parameters
        ----------
        max_deg : int
            Maximum total degree.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis of total degree :math:`\leq \max_{deg}`.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this is also the cumulated cardinal of stratas of index :math:`\leq \max_{deg}`.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getMaximumDegreeCardinal(2)
        6
        """
        return _func.EnumerateFunctionImplementation_getMaximumDegreeCardinal(self, maximumDegree)

    def getBasisSizeFromTotalDegree(self, maximumDegree):
        r"""
        Get the basis size corresponding to a total degree.

        Parameters
        ----------
        max_deg : int
            Maximum total degree.

        Returns
        -------
        size : int
            Number of multi-indices in the basis of total degree :math:`\leq \max_{deg}`.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this is also the cumulated cardinal of stratas up to *max_deg*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getBasisSizeFromTotalDegree(3)
        10
        >>> enum_func.getStrataCumulatedCardinal(3)
        10
        """
        return _func.EnumerateFunctionImplementation_getBasisSizeFromTotalDegree(self, maximumDegree)

    def getMarginal(self, *args):
        r"""
        Get the marginal enumerate function.

        Parameters
        ----------
        indices : int or sequence of int, :math:`0 \leq i < n`
            List of marginal indices.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            The marginal enumerate function.
        """
        return _func.EnumerateFunctionImplementation_getMarginal(self, *args)

    def setDimension(self, dimension):
        r"""
        Set the dimension of the *EnumerateFunction*.

        Parameters
        ----------
        dim : int, :math:`dim \geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunctionImplementation_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Return the dimension of the *EnumerateFunction*.

        Returns
        -------
        dim : int, :math:`dim \geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunctionImplementation_getDimension(self)

    def setUpperBound(self, upperBound):
        r"""
        Accessor to the upper bound.

        Parameters
        ----------
        ub : sequence of int
            Upper bound of the indices (inclusive).
        """
        return _func.EnumerateFunctionImplementation_setUpperBound(self, upperBound)

    def getUpperBound(self):
        r"""
        Accessor to the upper bound.

        Returns
        -------
        ub : sequence of int
            Upper bound of the indices (inclusive).
        """
        return _func.EnumerateFunctionImplementation_getUpperBound(self)

    def __init__(self, *args):
        _func.EnumerateFunctionImplementation_swiginit(self, _func.new_EnumerateFunctionImplementation(*args))
    __swig_destroy__ = _func.delete_EnumerateFunctionImplementation

# Register EnumerateFunctionImplementation in _func:
_func.EnumerateFunctionImplementation_swigregister(EnumerateFunctionImplementation)
class _EnumerateFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._EnumerateFunctionImplementationTypedInterfaceObject_swiginit(self, _func.new__EnumerateFunctionImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._EnumerateFunctionImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._EnumerateFunctionImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._EnumerateFunctionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._EnumerateFunctionImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._EnumerateFunctionImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__EnumerateFunctionImplementationTypedInterfaceObject

# Register _EnumerateFunctionImplementationTypedInterfaceObject in _func:
_func._EnumerateFunctionImplementationTypedInterfaceObject_swigregister(_EnumerateFunctionImplementationTypedInterfaceObject)
class EnumerateFunction(_EnumerateFunctionImplementationTypedInterfaceObject):
    r"""
    Enumerate function.

    Notes
    -----
    *EnumerateFunction* is a bijection :math:`\vect{\alpha}`  from :math:`\Nset` to
    :math:`\Nset^{n_X}`. This bijection is based on a particular enumeration rule
    of the set of multi-indices.
    For any integer :math:`i \in \Nset`, the value of the enumerate function is:

    .. math::

        \vect{\alpha}(i) = (\alpha_1(i),\dots, \alpha_{n_X}(i)) \in {\Nset}^{n_X}.

    The first multi-index is:

    .. math::

        \vect{\alpha}(0) = (0, 0, \dots, 0).

    Let :math:`i, j \in \Nset` be any pair of indices. If :math:`|i - j|\leq 1` then:

    .. math::

        \left|\sum_{k=1}^{n_X} \left[ \alpha_k(i) - \alpha_k(j) \right]\right| \leq 1

    where :math:`\alpha_k(i)` is the k-th component of the multi-index :math:`\vect{\alpha}(i)`.
    This provides a necessary but insufficient condition 
    for the construction of the bijection: 
    a supplementary hypothesis must be made. 

    For example, consider the dimension :math:`\textrm{dim}=2`. 
    The following mapping is an enumerate function:

    .. math::

        \vect{\alpha}(0) &= (0, \; 0) \\
        \vect{\alpha}(1) &= (1, \; 0) \\
        \vect{\alpha}(2) &= (0, \; 1) \\
        \vect{\alpha}(3) &= (2, \; 0) \\
        \vect{\alpha}(4) &= (1, \; 1) \\
        \vect{\alpha}(5) &= (0, \; 2) \\
        \vect{\alpha}(6) &= (3, \; 0)

    For the functional expansion (respectively polynomial chaos expansion), the
    multi-index :math:`\vect{\alpha}` is the collection of marginal degrees of the
    selected orthogonal functions (respectively orthogonal polynomials). 
    More precisely, after the selection of the type of orthogonal functions (respectively
    orthogonal polynomials) for the construction of the orthogonal basis, the
    *EnumerateFunction* defines the
    marginal degrees of the univariate functions (respectively univariate polynomials).
    The multivariate tensor product function
    is based on the product of marginal univariate functions:

    .. math::

        \psi_{\vect{\alpha}}(\vect{x}) = \prod_{i = 1}^{n_X} \pi_{\alpha_i}^{(i)}(x_i)

    for any point :math:`\vect{x}` where :math:`\pi_{\alpha_i}^{(i)}` is the
    polynomial of degree :math:`\alpha_i` for the i-th marginal.
    The total degree of the polynomial is equal to the sum of the integers 
    in the multi-index:

    .. math::

        \operatorname{degree} \left(\psi_{\vect{\alpha}} \right) 
        = \sum_{i = 1}^{n_X} \alpha_i = \|\vect{\alpha}\|_1.

    For example, consider the multi-index :math:`\vect{\alpha} = (2, 0, 3)`. 
    This multi-index defines a multivariate polynomial which has a input
    vector of dimension 3.
    The marginal degree of the polynomial of the first dimension is equal to 2, 
    the marginal degree of the polynomial of the second dimension is equal to 0 
    and the marginal degree of the polynomial of the third dimension is equal to 3.

    Examples
    --------
    >>> import openturns as ot
    >>> dim = 2
    >>> enum_func = ot.LinearEnumerateFunction(dim)
    >>> for i in range(6):
    ...     print(enum_func(i))
    [0,0]
    [1,0]
    [0,1]
    [2,0]
    [1,1]
    [0,2]

    See Also
    --------
    LinearEnumerateFunction, HyperbolicAnisotropicEnumerateFunction, NormInfEnumerateFunction
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.EnumerateFunction_getClassName(self)

    def __repr__(self):
        return _func.EnumerateFunction___repr__(self)

    def __str__(self, *args):
        return _func.EnumerateFunction___str__(self, *args)

    def __call__(self, index):
        return _func.EnumerateFunction___call__(self, index)

    def inverse(self, indices):
        r"""
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enum_func(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enum_func.inverse([1,1]))
        4
        """
        return _func.EnumerateFunction_inverse(self, indices)

    def getStrataCardinal(self, strataIndex):
        r"""
        Get the number of multi-indices in the basis inside a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata of the tensorized basis.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis inside the strata *strataIndex*.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        the strata *strataIndex* consists of a hyperplane of all the multi-indices of total degree
        *strataIndex*, and its cardinal is *strataIndex* + 1.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getStrataCardinal(2)
        3
        """
        return _func.EnumerateFunction_getStrataCardinal(self, strataIndex)

    def getStrataCumulatedCardinal(self, strataIndex):
        r"""
        Get the number of multi-indices in the basis inside a range of stratas.

        Parameters
        ----------
        strataIndex : int
            Index of the strata of the tensorized basis.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis inside the stratas of index lower or equal to *strataIndex*.

        Notes
        -----
        The number of multi-indices is the total of multi-indices inside the stratas.
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this returns the number of multi-indices of maximal total degree *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getStrataCumulatedCardinal(2)
        6
        >>> sum([enum_func.getStrataCardinal(i) for i in range(3)])
        6
        """
        return _func.EnumerateFunction_getStrataCumulatedCardinal(self, strataIndex)

    def getMaximumDegreeStrataIndex(self, maximumDegree):
        r"""
        Get the largest index of the strata containing multi-indices lower or equal to the given maximum degree.

        Parameters
        ----------
        max_deg : int
            Maximum total degree.

        Returns
        -------
        index : int
            Index of the last strata that contains multi-indices of total degree :math:`\leq \max_{deg}`.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this is the strata of index *max_deg*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getMaximumDegreeStrataIndex(2)
        2
        """
        return _func.EnumerateFunction_getMaximumDegreeStrataIndex(self, maximumDegree)

    def getMaximumDegreeCardinal(self, maximumDegree):
        r"""
        Get the number of multi-indices of total degree lower or equal to a threshold.

        Parameters
        ----------
        max_deg : int
            Maximum total degree.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis of total degree :math:`\leq \max_{deg}`.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this is also the cumulated cardinal of stratas of index :math:`\leq \max_{deg}`.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getMaximumDegreeCardinal(2)
        6
        """
        return _func.EnumerateFunction_getMaximumDegreeCardinal(self, maximumDegree)

    def getBasisSizeFromTotalDegree(self, maximumDegree):
        r"""
        Get the basis size corresponding to a total degree.

        Parameters
        ----------
        max_deg : int
            Maximum total degree.

        Returns
        -------
        size : int
            Number of multi-indices in the basis of total degree :math:`\leq \max_{deg}`.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this is also the cumulated cardinal of stratas up to *max_deg*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getBasisSizeFromTotalDegree(3)
        10
        >>> enum_func.getStrataCumulatedCardinal(3)
        10
        """
        return _func.EnumerateFunction_getBasisSizeFromTotalDegree(self, maximumDegree)

    def getMarginal(self, *args):
        r"""
        Get the marginal enumerate function.

        Parameters
        ----------
        indices : int or sequence of int, :math:`0 \leq i < n`
            List of marginal indices.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            The marginal enumerate function.
        """
        return _func.EnumerateFunction_getMarginal(self, *args)

    def setDimension(self, dimension):
        r"""
        Set the dimension of the *EnumerateFunction*.

        Parameters
        ----------
        dim : int, :math:`dim \geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunction_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Return the dimension of the *EnumerateFunction*.

        Returns
        -------
        dim : int, :math:`dim \geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunction_getDimension(self)

    def setUpperBound(self, upperBound):
        r"""
        Accessor to the upper bound.

        Parameters
        ----------
        ub : sequence of int
            Upper bound of the indices (inclusive).
        """
        return _func.EnumerateFunction_setUpperBound(self, upperBound)

    def getUpperBound(self):
        r"""
        Accessor to the upper bound.

        Returns
        -------
        ub : sequence of int
            Upper bound of the indices (inclusive).
        """
        return _func.EnumerateFunction_getUpperBound(self)

    def __init__(self, *args):
        _func.EnumerateFunction_swiginit(self, _func.new_EnumerateFunction(*args))
    __swig_destroy__ = _func.delete_EnumerateFunction

# Register EnumerateFunction in _func:
_func.EnumerateFunction_swigregister(EnumerateFunction)
class LinearEnumerateFunction(EnumerateFunctionImplementation):
    r"""
    Linear enumerate function.

    Parameters
    ----------
    dim : int
        Dimension.

    Notes
    -----
    Given an input random vector :math:`\vect{X}` with prescribed probability
    density function (PDF) :math:`f_{\vect{X}}(\vect{x})`, it is possible to build
    up a *polynomial chaos* (PC) basis
    :math:`\{\psi_{\vect{\alpha}},\vect{\alpha} \in \Nset^{n_X}\}`. Of interest is
    the definition of enumeration strategies for exploring this basis, i.e. of
    suitable *enumeration functions* :math:`\tau` from :math:`\Nset` to
    :math:`\Nset^{n_X}`, which creates a one-to-one mapping between an integer
    :math:`j` and a multi-index :math:`\Nset^{n_X}`.

    Let us first define the *total degree* of any multi-index :math:`\vect{\alpha}`
    in :math:`\Nset^{n_X}` by :math:`\sum_{i=1}^{n_X} \alpha_i`. A natural choice to
    sort the PC basis (i.e. the multi-indices :math:`\vect{\alpha}`)
    is the lexicographical order with a constraint of increasing total degree.
    Mathematically speaking, a bijective enumeration function :math:`\tau` is
    defined by:

    .. math::

        \begin{array}{llcl}
          \tau \, : & \Nset & \longrightarrow & \Nset^{n_X} \\
          &  j & \longmapsto & \{\alpha_1,\dots, \alpha_{n_X}\} \,
                     \equiv \, \{\tau_1(j),\dots,\tau_{n_X}(j)\} \\
        \end{array}

    such that:

    .. math::

        \tau(0) = \{0,\dots,0\}

    and

    .. math::

        \forall 1 \leq j<k  \quad \, , \quad \, \left\{
        \begin{array}{l}
          \displaystyle{\sum_{i=1}^{n_X} \tau_i(j) < \sum_{i=1}^{n_X} \tau_i(k)}  \\
          \\
          \mbox{ or} \\
          \\
          \displaystyle{\exists \; m \in \{1,\dots,n_X\} \; : \;
              \left(\forall i \leq m , \; \tau_i(j) = \tau_i(k) \; \right)
              \, \, \, \mbox{ and } \, \, \,
              \left(\tau_m(j) < \tau_m(k) \right)} \\
        \end{array}
        \right.

    Such an enumeration strategy is illustrated in a two-dimensional case
    (i.e. :math:`n_X=2`) in the figure below:

    .. plot:: pyplots/LinearEnumerateFunction.py
        :include-source: False

    This corresponds to the following enumeration of the multi-indices:

    ===== =====================
      j   :math:`\vect{\alpha} = \{\alpha_1,\alpha_2\}`
    ===== =====================
      0       {0, 0}
      1       {1, 0}
      2       {0, 1}
      3       {2, 0}
      4       {1, 1}
      5       {0, 2}
      6       {3, 0}
      7       {2, 1}
      8       {1, 2}
      9       {0, 3}
    ===== =====================

    See also
    --------
    EnumerateFunction, HyperbolicAnisotropicEnumerateFunction

    Examples
    --------
    >>> import openturns as ot
    >>> # 4-dimensional case
    >>> enumerateFunction = ot.LinearEnumerateFunction(4)
    >>> for i in range(9):
    ...     print(enumerateFunction(i))
    [0,0,0,0]
    [1,0,0,0]
    [0,1,0,0]
    [0,0,1,0]
    [0,0,0,1]
    [2,0,0,0]
    [1,1,0,0]
    [1,0,1,0]
    [1,0,0,1]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearEnumerateFunction_getClassName(self)

    def __repr__(self):
        return _func.LinearEnumerateFunction___repr__(self)

    def __call__(self, index):
        return _func.LinearEnumerateFunction___call__(self, index)

    def inverse(self, indices):
        r"""
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enum_func(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enum_func.inverse([1,1]))
        4
        """
        return _func.LinearEnumerateFunction_inverse(self, indices)

    def getStrataCardinal(self, strataIndex):
        r"""
        Get the number of multi-indices in the basis inside a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata of the tensorized basis.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis inside the strata *strataIndex*.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        the strata *strataIndex* consists of a hyperplane of all the multi-indices of total degree
        *strataIndex*, and its cardinal is *strataIndex* + 1.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getStrataCardinal(2)
        3
        """
        return _func.LinearEnumerateFunction_getStrataCardinal(self, strataIndex)

    def getStrataCumulatedCardinal(self, strataIndex):
        r"""
        Get the number of multi-indices in the basis inside a range of stratas.

        Parameters
        ----------
        strataIndex : int
            Index of the strata of the tensorized basis.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis inside the stratas of index lower or equal to *strataIndex*.

        Notes
        -----
        The number of multi-indices is the total of multi-indices inside the stratas.
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this returns the number of multi-indices of maximal total degree *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getStrataCumulatedCardinal(2)
        6
        >>> sum([enum_func.getStrataCardinal(i) for i in range(3)])
        6
        """
        return _func.LinearEnumerateFunction_getStrataCumulatedCardinal(self, strataIndex)

    def getMaximumDegreeStrataIndex(self, maximumDegree):
        r"""
        Get the largest index of the strata containing multi-indices lower or equal to the given maximum degree.

        Parameters
        ----------
        max_deg : int
            Maximum total degree.

        Returns
        -------
        index : int
            Index of the last strata that contains multi-indices of total degree :math:`\leq \max_{deg}`.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this is the strata of index *max_deg*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getMaximumDegreeStrataIndex(2)
        2
        """
        return _func.LinearEnumerateFunction_getMaximumDegreeStrataIndex(self, maximumDegree)

    def setUpperBound(self, upperBound):
        r"""
        Accessor to the upper bound.

        Parameters
        ----------
        ub : sequence of int
            Upper bound of the indices (inclusive).
        """
        return _func.LinearEnumerateFunction_setUpperBound(self, upperBound)

    def getMarginal(self, *args):
        r"""
        Get the marginal enumerate function.

        Parameters
        ----------
        indices : int or sequence of int, :math:`0 \leq i < n`
            List of marginal indices.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            The marginal enumerate function.
        """
        return _func.LinearEnumerateFunction_getMarginal(self, *args)

    def __init__(self, *args):
        _func.LinearEnumerateFunction_swiginit(self, _func.new_LinearEnumerateFunction(*args))
    __swig_destroy__ = _func.delete_LinearEnumerateFunction

# Register LinearEnumerateFunction in _func:
_func.LinearEnumerateFunction_swigregister(LinearEnumerateFunction)
class HyperbolicAnisotropicEnumerateFunction(EnumerateFunctionImplementation):
    r"""
    Hyperbolic and anisotropic enumerate function.

    Available constructors:
        HyperbolicAnisotropicEnumerateFunction(*dim*)

        HyperbolicAnisotropicEnumerateFunction(*dim, q*)

        HyperbolicAnisotropicEnumerateFunction(*weight*)

        HyperbolicAnisotropicEnumerateFunction(*weight, q*)

    Parameters
    ----------
    dim : int
        Dimension of the :class:`~openturns.EnumerateFunction`. *dim* must be equal
        to the dimension of the :class:`~openturns.OrthogonalBasis`.
    q : float
        Correspond to the q-quasi norm parameter. If not precised, :math:`q = 0.4`.
    weight : sequence of float
        Weights of the indices in each dimension. If not precised, all weights are
        equals to :math:`w_i = 1`.

    See also
    --------
    EnumerateFunction, LinearEnumerateFunction

    Notes
    -----
    The hyperbolic truncation strategy is inspired by the so-called sparsity-of-
    effects principle, which states that most models are principally governed by
    main effects and low-order interactions. Accordingly, one wishes to define an
    enumeration strategy which first selects those multi-indices related to main
    effects, i.e. with a reasonably small number of nonzero components, prior to
    selecting those associated with higher-order interactions.

    For any real number :math:`q \in ]0, 1]`, one defines the anisotropic hyperbolic
    norm of a multi-index :math:`\vect{\alpha}` by:

    .. math::

        \| \vect{\alpha} \|_{\vect{w}, q} = \left( \sum_{i=1}^{n_X} w_i \alpha_i^q \right)^{1/q}

    where :math:`n_X` is the number of input variables and :math:`(w_1, \dots , w_{n_X})` is a sequence of
    real positive numbers called weights.
    Functions of input variables with smaller weights are selected first
    for the functional basis.

    Examples
    --------

    In the following example, we create an hyperbolic enumerate function
    in 2 dimension with a quasi-norm equal to 0.5.
    Notice, for example, that the function with multi-index [3,0]
    come before [1,1], although the sum of marginal indices is lower: this
    is the result of the hyperbolic quasi-norm.

    >>> import openturns as ot
    >>> enumerateFunction = ot.HyperbolicAnisotropicEnumerateFunction(2, 0.5)
    >>> for i in range(10):
    ...     print(enumerateFunction(i))
    [0,0]
    [1,0]
    [0,1]
    [2,0]
    [0,2]
    [3,0]
    [0,3]
    [1,1]
    [4,0]
    [0,4]

    In the following example, we create an hyperbolic enumerate function
    in 3 dimensions based on the weights [1,2,4].
    Notice that the first marginal index, with weight equal to 1, comes
    first in the enumeration.

    >>> import openturns as ot
    >>> enumerateFunction = ot.HyperbolicAnisotropicEnumerateFunction([1, 2, 4])
    >>> for i in range(20):
    ...     print('i=', i, 'enum=', enumerateFunction(i))
    i= 0 enum= [0,0,0]
    i= 1 enum= [1,0,0]
    i= 2 enum= [0,1,0]
    i= 3 enum= [2,0,0]
    i= 4 enum= [3,0,0]
    i= 5 enum= [0,0,1]
    i= 6 enum= [0,2,0]
    i= 7 enum= [4,0,0]
    i= 8 enum= [5,0,0]
    i= 9 enum= [0,3,0]
    i= 10 enum= [6,0,0]
    i= 11 enum= [7,0,0]
    i= 12 enum= [0,0,2]
    i= 13 enum= [0,4,0]
    i= 14 enum= [8,0,0]
    i= 15 enum= [1,1,0]
    i= 16 enum= [9,0,0]
    i= 17 enum= [0,5,0]
    i= 18 enum= [10,0,0]
    i= 19 enum= [11,0,0]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getClassName(self)

    def __repr__(self):
        return _func.HyperbolicAnisotropicEnumerateFunction___repr__(self)

    def __call__(self, index):
        return _func.HyperbolicAnisotropicEnumerateFunction___call__(self, index)

    def inverse(self, indices):
        r"""
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enum_func(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enum_func.inverse([1,1]))
        4
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_inverse(self, indices)

    def getStrataCardinal(self, strataIndex):
        r"""
        Get the number of multi-indices in the basis inside a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata of the tensorized basis.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis inside the strata *strataIndex*.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        the strata *strataIndex* consists of a hyperplane of all the multi-indices of total degree
        *strataIndex*, and its cardinal is *strataIndex* + 1.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getStrataCardinal(2)
        3
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getStrataCardinal(self, strataIndex)

    def getStrataCumulatedCardinal(self, strataIndex):
        r"""
        Get the number of multi-indices in the basis inside a range of stratas.

        Parameters
        ----------
        strataIndex : int
            Index of the strata of the tensorized basis.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis inside the stratas of index lower or equal to *strataIndex*.

        Notes
        -----
        The number of multi-indices is the total of multi-indices inside the stratas.
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this returns the number of multi-indices of maximal total degree *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getStrataCumulatedCardinal(2)
        6
        >>> sum([enum_func.getStrataCardinal(i) for i in range(3)])
        6
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getStrataCumulatedCardinal(self, strataIndex)

    def getMaximumDegreeStrataIndex(self, maximumDegree):
        r"""
        Get the largest index of the strata containing multi-indices lower or equal to the given maximum degree.

        Parameters
        ----------
        max_deg : int
            Maximum total degree.

        Returns
        -------
        index : int
            Index of the last strata that contains multi-indices of total degree :math:`\leq \max_{deg}`.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this is the strata of index *max_deg*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getMaximumDegreeStrataIndex(2)
        2
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getMaximumDegreeStrataIndex(self, maximumDegree)

    def setQ(self, q):
        r"""
        Accessor to the norm.

        Parameters
        ----------
        q : float
            q-quasi norm parameter.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_setQ(self, q)

    def getQ(self):
        r"""
        Accessor to the norm.

        Returns
        -------
        q : float
            q-quasi norm parameter.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getQ(self)

    def setWeight(self, weight):
        r"""
        Accessor to the weights.

        Parameters
        ----------
        w : sequence of float
            Weights of the indices in each dimension.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_setWeight(self, weight)

    def getWeight(self):
        r"""
        Accessor to the weights.

        Returns
        -------
        w : :class:`~openturns.Point`
            Weights of the indices in each dimension.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getWeight(self)

    def setUpperBound(self, upperBound):
        r"""
        Accessor to the upper bound.

        Parameters
        ----------
        ub : sequence of int
            Upper bound of the indices (inclusive).
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_setUpperBound(self, upperBound)

    def getMarginal(self, *args):
        r"""
        Get the marginal enumerate function.

        Parameters
        ----------
        indices : int or sequence of int, :math:`0 \leq i < n`
            List of marginal indices.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            The marginal enumerate function.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getMarginal(self, *args)

    def __init__(self, *args):
        _func.HyperbolicAnisotropicEnumerateFunction_swiginit(self, _func.new_HyperbolicAnisotropicEnumerateFunction(*args))
    __swig_destroy__ = _func.delete_HyperbolicAnisotropicEnumerateFunction

# Register HyperbolicAnisotropicEnumerateFunction in _func:
_func.HyperbolicAnisotropicEnumerateFunction_swigregister(HyperbolicAnisotropicEnumerateFunction)
class NormInfEnumerateFunction(EnumerateFunctionImplementation):
    r"""
    Infinite norm enumerate function.

    Parameters
    ----------
    dim : int, default=1
        Dimension of the :class:`~openturns.EnumerateFunction`. *dim* must be equal
        to the dimension of the :class:`~openturns.OrthogonalBasis`.

    See also
    --------
    EnumerateFunction, LinearEnumerateFunction

    Notes
    -----
    One defines the infinity norm of a multi-index :math:`a` by:

    .. math::

        \| \vect{\alpha} \|_{\infty} = \max_{i=1} \; \alpha_i

    This would lead to first select the basis polynomials depending on a specific subset of input variables.

    Examples
    --------
    >>> import openturns as ot
    >>> # 2-dimensional case
    >>> enumerateFunction = ot.NormInfEnumerateFunction(2)
    >>> for i in range(10):
    ...     print(enumerateFunction(i))
    [0,0]
    [1,0]
    [0,1]
    [1,1]
    [2,0]
    [2,1]
    [0,2]
    [1,2]
    [2,2]
    [3,0]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NormInfEnumerateFunction_getClassName(self)

    def __repr__(self):
        return _func.NormInfEnumerateFunction___repr__(self)

    def __call__(self, index):
        return _func.NormInfEnumerateFunction___call__(self, index)

    def getStrataCardinal(self, strataIndex):
        r"""
        Get the number of multi-indices in the basis inside a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata of the tensorized basis.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis inside the strata *strataIndex*.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        the strata *strataIndex* consists of a hyperplane of all the multi-indices of total degree
        *strataIndex*, and its cardinal is *strataIndex* + 1.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getStrataCardinal(2)
        3
        """
        return _func.NormInfEnumerateFunction_getStrataCardinal(self, strataIndex)

    def getStrataCumulatedCardinal(self, strataIndex):
        r"""
        Get the number of multi-indices in the basis inside a range of stratas.

        Parameters
        ----------
        strataIndex : int
            Index of the strata of the tensorized basis.

        Returns
        -------
        cardinal : int
            Number of multi-indices in the basis inside the stratas of index lower or equal to *strataIndex*.

        Notes
        -----
        The number of multi-indices is the total of multi-indices inside the stratas.
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this returns the number of multi-indices of maximal total degree *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getStrataCumulatedCardinal(2)
        6
        >>> sum([enum_func.getStrataCardinal(i) for i in range(3)])
        6
        """
        return _func.NormInfEnumerateFunction_getStrataCumulatedCardinal(self, strataIndex)

    def getMaximumDegreeStrataIndex(self, maximumDegree):
        r"""
        Get the largest index of the strata containing multi-indices lower or equal to the given maximum degree.

        Parameters
        ----------
        max_deg : int
            Maximum total degree.

        Returns
        -------
        index : int
            Index of the last strata that contains multi-indices of total degree :math:`\leq \max_{deg}`.

        Notes
        -----
        In the specific context of a linear enumeration (:class:`LinearEnumerateFunction`)
        this is the strata of index *max_deg*.

        Examples
        --------
        >>> import openturns as ot
        >>> dim = 2
        >>> enum_func = ot.LinearEnumerateFunction(dim)
        >>> enum_func.getMaximumDegreeStrataIndex(2)
        2
        """
        return _func.NormInfEnumerateFunction_getMaximumDegreeStrataIndex(self, maximumDegree)

    def getMarginal(self, *args):
        r"""
        Get the marginal enumerate function.

        Parameters
        ----------
        indices : int or sequence of int, :math:`0 \leq i < n`
            List of marginal indices.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            The marginal enumerate function.
        """
        return _func.NormInfEnumerateFunction_getMarginal(self, *args)

    def __init__(self, *args):
        _func.NormInfEnumerateFunction_swiginit(self, _func.new_NormInfEnumerateFunction(*args))
    __swig_destroy__ = _func.delete_NormInfEnumerateFunction

# Register NormInfEnumerateFunction in _func:
_func.NormInfEnumerateFunction_swigregister(NormInfEnumerateFunction)
OT_TYPECHECK_FIELDIMPLEMENTATION = _func.OT_TYPECHECK_FIELDIMPLEMENTATION
class FieldImplementation(openturns.common.PersistentObject):
    r"""
    Base class for Fields.

    Available constructors:
        Field(*mesh, dim*)

        Field(*mesh, values*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
           Each vertice of the mesh is in :math:`\cD` a domain of :math:`\Rset^n`.
    dim : int
          Dimension :math:`d` of the values.
    values : 2-d sequence of float of dimension :math:`d`
        The values associated to the vertices of the mesh. The size of *values* is
        equal to the number of vertices in the associated mesh. So we must have the
        equality between *values.getSize()* and *mesh.getVerticesNumber()*.

    Notes
    -----
    A field :math:`F` is an association between vertices and values: 

    .. math::

        F = (\vect{t}_i, \vect{v}_i)_{1 \leq i \leq N}

    where the :math:`(\vect{t}_i)_{1 \leq i \leq N}` are the vertices of a mesh of the domain :math:`\cD` and :math:`(\vect{v}_i)_{1 \leq i \leq N}` are the associated values.

    Mathematically speaking, :math:`F` is an element :math:`\cM_N \times (\Rset^d)^N` where :math:`N` is the number of vertices of the mesh :math:`\cM_N` of the domain :math:`\cD \subset \Rset^n`.


    Examples
    --------
    Create a field:

    >>> import openturns as ot
    >>> myVertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0], [2.0, 1.5], [0.5, 1.5]]
    >>> mySimplicies = [[0,1,2], [1,2,3], [2,3,4], [2,4,5], [0,2,5]]
    >>> myMesh = ot.Mesh(myVertices, mySimplicies)
    >>> myValues = [[2.0],[2.5],[4.0], [4.5], [6.0], [7.0]]
    >>> myField = ot.Field(myMesh, myValues)

    Draw the field:

    >>> myGraph = myField.draw()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldImplementation_getClassName(self)

    def getValueAtIndex(self, index):
        r"""
        Get the value of the field at the vertex of the given index.

        Parameters
        ----------
        index : int
            Vertex of the mesh of index *index*.

        Returns
        -------
        value : :class:`~openturns.Point`
            The value of the field associated to the selected vertex, in :math:`\Rset^d`.
        """
        return _func.FieldImplementation_getValueAtIndex(self, index)

    def setValueAtIndex(self, index, val):
        r"""
        Assign the value of the field to the vertex at the given index.

        Parameters
        ----------
        index : int
            Index that characterizes one vertex of the mesh.
        value : :class:`~openturns.Point` in :math:`\Rset^d`.
            New value assigned to the selected vertex.
        """
        return _func.FieldImplementation_setValueAtIndex(self, index, val)

    def setDescription(self, description):
        r"""
        Set the description of the vertices and values of the field.

        Parameters
        ----------
        myDescription : :class:`~openturns.Description`
            Description of the field values. Must be of size :math:`n+d` and give the
            description of the vertices and the values.
        """
        return _func.FieldImplementation_setDescription(self, description)

    def getDescription(self):
        r"""
        Get the description of the field values.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the vertices and values of the field, size :math:`n+d`.
        """
        return _func.FieldImplementation_getDescription(self)

    def getMesh(self):
        r"""
        Get the mesh on which the field is defined.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _func.FieldImplementation_getMesh(self)

    def getTimeGrid(self):
        r"""
        Get the mesh as a time grid if it is 1D and regular.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Mesh of the field when it can be interpreted as a 
            :class:`~openturns.RegularGrid`. We check if the vertices of the mesh are
            scalar and are regularly spaced in :math:`\Rset` but we don't check if the
            connectivity of the mesh is conform to the one of a regular grid (without
            any hole and composed of ordered instants).
        """
        return _func.FieldImplementation_getTimeGrid(self)

    def __eq__(self, *args):
        return _func.FieldImplementation___eq__(self, *args)

    def __repr__(self):
        return _func.FieldImplementation___repr__(self)

    def __str__(self, *args):
        return _func.FieldImplementation___str__(self, *args)

    def getSize(self):
        r"""
        Get the number of values inside the field.

        Returns
        -------
        size : int
            Number :math:`N` of vertices in the mesh.
        """
        return _func.FieldImplementation_getSize(self)

    def getInputDimension(self):
        r"""
        Get the dimension of the domain :math:`\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\cD`: :math:`n`.
        """
        return _func.FieldImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension :math:`d` of the values.

        Returns
        -------
        d : int
            Dimension of the field values: :math:`d`.
        """
        return _func.FieldImplementation_getOutputDimension(self)

    def getValues(self):
        r"""
        Get the values of the field.

        Returns
        -------
        values : :class:`~openturns.Sample`
            Values associated to the mesh. The size of the sample is the number of
            vertices of the mesh and the dimension is the dimension of the values
            (:math:`d`).
        """
        return _func.FieldImplementation_getValues(self)

    def setValues(self, values):
        r"""
        Assign values to a field.

        Parameters
        ----------
        values : 2-d sequence of float
            Values assigned to the mesh. The size of the values is the number of
            vertices of the mesh and the dimension is :math:`d`.
        """
        return _func.FieldImplementation_setValues(self, values)

    def getMarginal(self, *args):
        r"""
        Marginal accessor.

        Parameters
        ----------
        i : int or sequence of int
            Index of the marginal.

        Returns
        -------
        value : :class:`~openturns.Field`.
            Marginal field.
        """
        return _func.FieldImplementation_getMarginal(self, *args)

    def asSample(self):
        r"""
        Convert to Sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Data as a Sample object.
        """
        return _func.FieldImplementation_asSample(self)

    def asDeformedMesh(self, *args):
        r"""
        Get the mesh deformed according to the values of the field.

        Parameters
        ----------
        verticesPadding : sequence of int
               The positions at which the coordinates of vertices are set to zero when extending the vertices dimension. By default the sequence is empty.
        valuesPadding : sequence of int
               The positions at which the components of values are set to zero when extending the values dimension. By default the sequence is empty.

        Returns
        -------
        deformedMesh : :class:`~openturns.Mesh`
            The initial mesh is deformed as follows: each vertex of the mesh is
            translated by the value of the field at this vertex. Only works when
            the input dimension :math:`n`: is equal to the dimension of the field
            :math:`d` after extension.
        """
        return _func.FieldImplementation_asDeformedMesh(self, *args)

    def getInputMean(self):
        r"""
        Get the input weighted mean of the values of the field.

        Returns
        -------
        inputMean : :class:`~openturns.Point`
            Weighted mean of the  values of the field, weighted by the volume of each
            simplex.

        Notes
        -----
        The input mean of the field is defined by:

        .. math::

           \displaystyle \frac{1}{V} \sum_{S_i \in \cM} \left( \frac{1}{n+1}\sum_{k=0}^{n} \vect{v}_{i_k}\right) |S_i|

        where :math:`S_i` is the simplex of index :math:`i` of the mesh, :math:`|S_i|`
        its volume and :math:`(\vect{v}_{i_0}, \dots, \vect{v}_{i_n})` the values of
        the field associated to the  vertices of :math:`S_i`, and
        :math:`\displaystyle V=\sum_{S_i \in \cD} |S_i|`.
        """
        return _func.FieldImplementation_getInputMean(self)

    def getOutputMean(self):
        r"""
        Get the mean of the values of the field.

        Returns
        -------
        temporalMean : :class:`~openturns.Point`
            Mean of the values of the field.

        Notes
        -----
        If we note :math:`(\vect{x}_0, \dots, \vect{x}_{N-1})` the values in
        :math:`\Rset^d` of the field, then the temporal mean is defined by:

        .. math::

           \displaystyle  \frac{1}{N} \sum_{i=0}^{N-1} \vect{v}_i

        Only makes sense in the case of a regular grid.
        """
        return _func.FieldImplementation_getOutputMean(self)

    def norm(self):
        r"""
        Compute the (:math:`L^2`) norm.

        Returns
        -------
        norm : float
            The field's norm computed using the mesh weights.
        """
        return _func.FieldImplementation_norm(self)

    def drawMarginal(self, index=0, interpolate=True):
        r"""
        Draw one marginal field if the input dimension is less than 2.

        Parameters
        ----------
        index : int
            The selected marginal.
        interpolate : bool
            Indicates whether the values at the vertices are linearly interpolated.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            - If the dimension of the mesh is :math:`n=1` and *interpolate=True*: it
              draws the graph of the piecewise linear function based on the selected
              marginal values of the field and the vertices coordinates
              (in :math:`\Rset`).

            - If the dimension of the mesh is :math:`n=1` and *interpolate=False*: it
              draws the cloud of points which coordinates are (vertex, value of the
              marginal *index*).

            - If the dimension of the mesh is :math:`n=2` and *interpolate=True*: it
              draws several iso-values curves of the selected marginal, based on a
              piecewise linear interpolation within the simplices (triangles) of the
              mesh. You get an empty graph if the vertices are not connected through
              simplicies.

            - If the dimension of the mesh is :math:`n=2` and *interpolate=False*: if
              the vertices are connected through simplicies, each simplex is drawn with
              a color defined by the mean of the values of the vertices of the simplex.
              In the other case, it draws each vertex colored by its value.
        """
        return _func.FieldImplementation_drawMarginal(self, index, interpolate)

    def draw(self):
        r"""
        Draw the first marginal of the field if the input dimension is less than 2.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Calls *drawMarginal(0, False)*.

        See also
        --------
        drawMarginal
        """
        return _func.FieldImplementation_draw(self)

    def exportToVTKFile(self, fileName):
        r"""
        Create the VTK format file of the field.

        Parameters
        ----------
        myVTKFile : str
            Name of the output file. No extension is append to the filename.

        Notes
        -----
        Creates the VTK format file that contains the mesh and the associated values
        that can be visualised with the open source software
        `Paraview <http://www.paraview.org/>`_ .
        """
        return _func.FieldImplementation_exportToVTKFile(self, fileName)

    def __iadd__(self, *args):
        return _func.FieldImplementation___iadd__(self, *args)

    def __isub__(self, *args):
        return _func.FieldImplementation___isub__(self, *args)

    def __add__(self, *args):
        return _func.FieldImplementation___add__(self, *args)

    def __sub__(self, *args):
        return _func.FieldImplementation___sub__(self, *args)

    def __len__(self):
        return _func.FieldImplementation___len__(self)

    def __getitem__(self, *args):
        return _func.FieldImplementation___getitem__(self, *args)

    def __setitem__(self, *args):
        return _func.FieldImplementation___setitem__(self, *args)

    def __init__(self, *args):
        _func.FieldImplementation_swiginit(self, _func.new_FieldImplementation(*args))
    __swig_destroy__ = _func.delete_FieldImplementation

# Register FieldImplementation in _func:
_func.FieldImplementation_swigregister(FieldImplementation)
class _FieldImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._FieldImplementationTypedInterfaceObject_swiginit(self, _func.new__FieldImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._FieldImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._FieldImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._FieldImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._FieldImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._FieldImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__FieldImplementationTypedInterfaceObject

# Register _FieldImplementationTypedInterfaceObject in _func:
_func._FieldImplementationTypedInterfaceObject_swigregister(_FieldImplementationTypedInterfaceObject)
class Field(_FieldImplementationTypedInterfaceObject):
    r"""
    Base class for Fields.

    Available constructors:
        Field(*mesh, dim*)

        Field(*mesh, values*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
           Each vertice of the mesh is in :math:`\cD` a domain of :math:`\Rset^n`.
    dim : int
          Dimension :math:`d` of the values.
    values : 2-d sequence of float of dimension :math:`d`
        The values associated to the vertices of the mesh. The size of *values* is
        equal to the number of vertices in the associated mesh. So we must have the
        equality between *values.getSize()* and *mesh.getVerticesNumber()*.

    Notes
    -----
    A field :math:`F` is an association between vertices and values: 

    .. math::

        F = (\vect{t}_i, \vect{v}_i)_{1 \leq i \leq N}

    where the :math:`(\vect{t}_i)_{1 \leq i \leq N}` are the vertices of a mesh of the domain :math:`\cD` and :math:`(\vect{v}_i)_{1 \leq i \leq N}` are the associated values.

    Mathematically speaking, :math:`F` is an element :math:`\cM_N \times (\Rset^d)^N` where :math:`N` is the number of vertices of the mesh :math:`\cM_N` of the domain :math:`\cD \subset \Rset^n`.


    Examples
    --------
    Create a field:

    >>> import openturns as ot
    >>> myVertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0], [2.0, 1.5], [0.5, 1.5]]
    >>> mySimplicies = [[0,1,2], [1,2,3], [2,3,4], [2,4,5], [0,2,5]]
    >>> myMesh = ot.Mesh(myVertices, mySimplicies)
    >>> myValues = [[2.0],[2.5],[4.0], [4.5], [6.0], [7.0]]
    >>> myField = ot.Field(myMesh, myValues)

    Draw the field:

    >>> myGraph = myField.draw()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Field_getClassName(self)

    def getValueAtIndex(self, index):
        r"""
        Get the value of the field at the vertex of the given index.

        Parameters
        ----------
        index : int
            Vertex of the mesh of index *index*.

        Returns
        -------
        value : :class:`~openturns.Point`
            The value of the field associated to the selected vertex, in :math:`\Rset^d`.
        """
        return _func.Field_getValueAtIndex(self, index)

    def setValueAtIndex(self, index, val):
        r"""
        Assign the value of the field to the vertex at the given index.

        Parameters
        ----------
        index : int
            Index that characterizes one vertex of the mesh.
        value : :class:`~openturns.Point` in :math:`\Rset^d`.
            New value assigned to the selected vertex.
        """
        return _func.Field_setValueAtIndex(self, index, val)

    def getMarginal(self, *args):
        r"""
        Marginal accessor.

        Parameters
        ----------
        i : int or sequence of int
            Index of the marginal.

        Returns
        -------
        value : :class:`~openturns.Field`.
            Marginal field.
        """
        return _func.Field_getMarginal(self, *args)

    def setDescription(self, description):
        r"""
        Set the description of the vertices and values of the field.

        Parameters
        ----------
        myDescription : :class:`~openturns.Description`
            Description of the field values. Must be of size :math:`n+d` and give the
            description of the vertices and the values.
        """
        return _func.Field_setDescription(self, description)

    def getDescription(self):
        r"""
        Get the description of the field values.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the vertices and values of the field, size :math:`n+d`.
        """
        return _func.Field_getDescription(self)

    def getMesh(self):
        r"""
        Get the mesh on which the field is defined.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _func.Field_getMesh(self)

    def getTimeGrid(self):
        r"""
        Get the mesh as a time grid if it is 1D and regular.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Mesh of the field when it can be interpreted as a 
            :class:`~openturns.RegularGrid`. We check if the vertices of the mesh are
            scalar and are regularly spaced in :math:`\Rset` but we don't check if the
            connectivity of the mesh is conform to the one of a regular grid (without
            any hole and composed of ordered instants).
        """
        return _func.Field_getTimeGrid(self)

    def __eq__(self, *args):
        return _func.Field___eq__(self, *args)

    def __repr__(self):
        return _func.Field___repr__(self)

    def __str__(self, *args):
        return _func.Field___str__(self, *args)

    def getSize(self):
        r"""
        Get the number of values inside the field.

        Returns
        -------
        size : int
            Number :math:`N` of vertices in the mesh.
        """
        return _func.Field_getSize(self)

    def getInputDimension(self):
        r"""
        Get the dimension of the domain :math:`\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\cD`: :math:`n`.
        """
        return _func.Field_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension :math:`d` of the values.

        Returns
        -------
        d : int
            Dimension of the field values: :math:`d`.
        """
        return _func.Field_getOutputDimension(self)

    def getValues(self):
        r"""
        Get the values of the field.

        Returns
        -------
        values : :class:`~openturns.Sample`
            Values associated to the mesh. The size of the sample is the number of
            vertices of the mesh and the dimension is the dimension of the values
            (:math:`d`).
        """
        return _func.Field_getValues(self)

    def setValues(self, values):
        r"""
        Assign values to a field.

        Parameters
        ----------
        values : 2-d sequence of float
            Values assigned to the mesh. The size of the values is the number of
            vertices of the mesh and the dimension is :math:`d`.
        """
        return _func.Field_setValues(self, values)

    def asDeformedMesh(self, *args):
        r"""
        Get the mesh deformed according to the values of the field.

        Parameters
        ----------
        verticesPadding : sequence of int
               The positions at which the coordinates of vertices are set to zero when extending the vertices dimension. By default the sequence is empty.
        valuesPadding : sequence of int
               The positions at which the components of values are set to zero when extending the values dimension. By default the sequence is empty.

        Returns
        -------
        deformedMesh : :class:`~openturns.Mesh`
            The initial mesh is deformed as follows: each vertex of the mesh is
            translated by the value of the field at this vertex. Only works when
            the input dimension :math:`n`: is equal to the dimension of the field
            :math:`d` after extension.
        """
        return _func.Field_asDeformedMesh(self, *args)

    def getInputMean(self):
        r"""
        Get the input weighted mean of the values of the field.

        Returns
        -------
        inputMean : :class:`~openturns.Point`
            Weighted mean of the  values of the field, weighted by the volume of each
            simplex.

        Notes
        -----
        The input mean of the field is defined by:

        .. math::

           \displaystyle \frac{1}{V} \sum_{S_i \in \cM} \left( \frac{1}{n+1}\sum_{k=0}^{n} \vect{v}_{i_k}\right) |S_i|

        where :math:`S_i` is the simplex of index :math:`i` of the mesh, :math:`|S_i|`
        its volume and :math:`(\vect{v}_{i_0}, \dots, \vect{v}_{i_n})` the values of
        the field associated to the  vertices of :math:`S_i`, and
        :math:`\displaystyle V=\sum_{S_i \in \cD} |S_i|`.
        """
        return _func.Field_getInputMean(self)

    def norm(self):
        r"""
        Compute the (:math:`L^2`) norm.

        Returns
        -------
        norm : float
            The field's norm computed using the mesh weights.
        """
        return _func.Field_norm(self)

    def drawMarginal(self, index=0, interpolate=True):
        r"""
        Draw one marginal field if the input dimension is less than 2.

        Parameters
        ----------
        index : int
            The selected marginal.
        interpolate : bool
            Indicates whether the values at the vertices are linearly interpolated.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            - If the dimension of the mesh is :math:`n=1` and *interpolate=True*: it
              draws the graph of the piecewise linear function based on the selected
              marginal values of the field and the vertices coordinates
              (in :math:`\Rset`).

            - If the dimension of the mesh is :math:`n=1` and *interpolate=False*: it
              draws the cloud of points which coordinates are (vertex, value of the
              marginal *index*).

            - If the dimension of the mesh is :math:`n=2` and *interpolate=True*: it
              draws several iso-values curves of the selected marginal, based on a
              piecewise linear interpolation within the simplices (triangles) of the
              mesh. You get an empty graph if the vertices are not connected through
              simplicies.

            - If the dimension of the mesh is :math:`n=2` and *interpolate=False*: if
              the vertices are connected through simplicies, each simplex is drawn with
              a color defined by the mean of the values of the vertices of the simplex.
              In the other case, it draws each vertex colored by its value.
        """
        return _func.Field_drawMarginal(self, index, interpolate)

    def draw(self):
        r"""
        Draw the first marginal of the field if the input dimension is less than 2.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Calls *drawMarginal(0, False)*.

        See also
        --------
        drawMarginal
        """
        return _func.Field_draw(self)

    def exportToVTKFile(self, fileName):
        r"""
        Create the VTK format file of the field.

        Parameters
        ----------
        myVTKFile : str
            Name of the output file. No extension is append to the filename.

        Notes
        -----
        Creates the VTK format file that contains the mesh and the associated values
        that can be visualised with the open source software
        `Paraview <http://www.paraview.org/>`_ .
        """
        return _func.Field_exportToVTKFile(self, fileName)

    def __iadd__(self, *args):
        return _func.Field___iadd__(self, *args)

    def __isub__(self, *args):
        return _func.Field___isub__(self, *args)

    def __add__(self, *args):
        return _func.Field___add__(self, *args)

    def __sub__(self, *args):
        return _func.Field___sub__(self, *args)

    def __init__(self, *args):
        _func.Field_swiginit(self, _func.new_Field(*args))

    def __len__(self):
        return _func.Field___len__(self)

    def __getitem__(self, *args):
        return _func.Field___getitem__(self, *args)

    def __setitem__(self, *args):
        return _func.Field___setitem__(self, *args)
    __swig_destroy__ = _func.delete_Field

# Register Field in _func:
_func.Field_swigregister(Field)

def Field__repr_html_(self):
    """Get HTML representation."""
    data = self.getMesh().getVertices()
    data.stack(self.getValues())
    return data._repr_html_()
Field._repr_html_ = Field__repr_html_

class TimeSeries(FieldImplementation):
    r"""
    Time series.

    Available constructors:
        TimeSeries(*nSteps,dim*)

        TimeSeries(*timeGrid, dim*)

        TimeSeries(*timeGrid, sample*)

        TimeSeries(*field*)

    Parameters
    ----------
    nSteps : int
        Enables to create a regular time grid on :math:`[0, nSteps]` which time step is equal to 1.

    timeGrid : :class:`~openturns.RegularGrid`
        Regular time grid of the time series.

    dim : int
        Dimension of the values of the time series at each time stamp. By default, the values are equal to the null vector.

    sample : 2-d sequence of float
        Values assigned to each time stamp of the time series.

    field : :class:`~openturns.Field`
        Maps a field into a time series when the associated mesh can be interpretated as a regular time grid.

    Examples
    --------
    Create a time series:

    >>> import openturns as ot
    >>> tmin = 0.0
    >>> timeStep = 0.1
    >>> n = 5
    >>> myTimeGrid = ot.RegularGrid(tmin, timeStep, n)
    >>> myValues = [[1.0], [2.0], [1.5], [4.5], [0.5]]
    >>> myTimeSeries = ot.TimeSeries(myTimeGrid, myValues)

    Draw the time series:

    >>> graph = myTimeSeries.draw()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TimeSeries_getClassName(self)

    def __repr__(self):
        return _func.TimeSeries___repr__(self)

    def __str__(self, *args):
        return _func.TimeSeries___str__(self, *args)

    def __eq__(self, *args):
        return _func.TimeSeries___eq__(self, *args)

    def add(self, *args):
        r"""
        Add a new value to the time series and extend the associated time grid.

        Available usages:
            add(*sample*)

            add(*timeSeries*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension the same as the dimension of the values of the time series.

        timeSeries : :class:`~openturns.TimeSeries`, which time grid must match with the initial time grid (one follows the other).

        Returns
        -------
        newTimeSeries : :class:`~openturns.TimeSeries`, whose regular grid has been extended with a new time stamp or a second time grid, associated to the new values.

        """
        return _func.TimeSeries_add(self, *args)

    def __init__(self, *args):
        _func.TimeSeries_swiginit(self, _func.new_TimeSeries(*args))
    __swig_destroy__ = _func.delete_TimeSeries

# Register TimeSeries in _func:
_func.TimeSeries_swigregister(TimeSeries)
class ProcessSampleImplementation(openturns.common.PersistentObject):
    r"""
    Collection of fields.

    Available constructors:
        ProcessSample(*mesh, K, d*)

        ProcessSample(*mesh, coll*)

        ProcessSample(*K, field*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        The mesh shared by all the fields in the collection.
    K : int
        Number of fields in the collection.
    d : int
        Dimension  of the values of the field.
    field : :class:`~openturns.Field`
        One field.
    coll : sequence of :class:`~openturns.Sample`
        List of field values.

    Notes
    -----
    A :class:`~openturns.ProcessSample` stores a sample of fields.
    We note `K` the number of fields contained in the process sample and `d` the dimension of the values associated to each vertex of the common mesh :math:`\cM \in \Rset^n`.

    These fields can be generated by a stochastic process.

    - In the first usage, we fix the common mesh with `mesh`, the number of fields contained in the sample with `K` and the dimension of the values with `d`.
      The values of the fields are by default fixed to zero.

    - In the second usage, the  collection of fields is filled with `K` copies of the given field `field`.

    We note :math:`\vect{x}_i^k \in \Rset^d` the value of the field `k` at the vertex `i`.
    We note `N` the number of vertices of :math:`\cM`, with :math:`0 \leq i \leq N-1` and :math:`1 \leq k \leq K`.

    Examples
    --------
    Create a bi dimensional mesh as a box:

    >>> import openturns as ot
    >>> myIndices = [10, 5]
    >>> myMesher = ot.IntervalMesher(myIndices)
    >>> lowerBound = [0.0, 0.0]
    >>> upperBound = [2.0, 1.0]
    >>> myInterval = ot.Interval(lowerBound, upperBound)
    >>> myMesh = myMesher.build(myInterval)

    Create a second order normal process of dimension 3:

    >>> amplitude = [5]
    >>> scale = [3, 3]
    >>> model = ot.ExponentialModel(scale, amplitude)
    >>> myProcess = ot.GaussianProcess(model, myMesh)

    Generate a sample of different fields:

    >>> n = 10
    >>> mySampleFields = myProcess.getSample(n)

    Duplicate the same field:

    >>> myField = myProcess.getRealization()
    >>> n = 10
    >>> mySampleFields2 = ot.ProcessSample(n, myField)

    We now show how to create a process sample from a collection of samples and a mesh.
    Here, the distribution at each vertex is considered to be a three-dimensional normal distribution

    >>> outputDimension = 3
    >>> sampleSize = 250
    >>> numberOfVertices = myMesh.getVerticesNumber()
    >>> normal = ot.Normal(outputDimension)
    >>> coll = [normal.getSample(numberOfVertices) for i in range(sampleSize)]
    >>> mySampleFields3 = ot.ProcessSample(myMesh, coll)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProcessSampleImplementation_getClassName(self)

    def add(self, *args):
        r"""
        Add a field to the collection.

        Parameters
        ----------
        field : :class:`~openturns.Field`
            A new field to add. 
            This field shares the same mesh and the same dimension as the other
            fields of the collection.

        """
        return _func.ProcessSampleImplementation_add(self, *args)

    def erase(self, first, last):
        r"""
        Erase point(s) at or between index(es) (in-place).

        Parameters
        ----------
        f : int, :math:`0 \leq f < m`
            The index of the first point to erase.
        l : int, :math:`f < l \leq m`, optional
            The index after the last point to erase.
            Default uses `l = f + 1` and only removes `sample[f]`.
        """
        return _func.ProcessSampleImplementation_erase(self, first, last)

    def clear(self):
        r"""Erase all field values."""
        return _func.ProcessSampleImplementation_clear(self)

    def setField(self, field, i):
        r"""
        Field accessor.

        Parameters
        ----------
        i : int
            Field index
        field : :class:`~openturns.Field`
            i-th field in the sample.

        """
        return _func.ProcessSampleImplementation_setField(self, field, i)

    def getField(self, i):
        r"""
        Field accessor.

        Parameters
        ----------
        i : int
            Field index

        Returns
        -------
        field : :class:`~openturns.Field`
            i-th field in the sample.

        """
        return _func.ProcessSampleImplementation_getField(self, i)

    def __repr__(self):
        return _func.ProcessSampleImplementation___repr__(self)

    def __str__(self, *args):
        return _func.ProcessSampleImplementation___str__(self, *args)

    def getTimeGrid(self):
        r"""
        Get the time grid of the fields.

        Returns
        -------
        mesh : :class:`~openturns.RegularGrid`
            The time grid shared by all the fields of the collection.
            Can be used only if the mesh can be interpreted as a regular time grid.

        """
        return _func.ProcessSampleImplementation_getTimeGrid(self)

    def getMesh(self):
        r"""
        Get the mesh of the fields.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh shared by all the fields of the collection.

        """
        return _func.ProcessSampleImplementation_getMesh(self)

    def getSize(self):
        r"""
        Get the size of the collection of fields.

        Returns
        -------
        K : int
            Number of fields in the collection.

        """
        return _func.ProcessSampleImplementation_getSize(self)

    def getDimension(self):
        r"""
        Get the dimension of the values of fields.

        Returns
        -------
        d : int
            Dimension of the values of the fields.

        """
        return _func.ProcessSampleImplementation_getDimension(self)

    def computeMean(self):
        r"""
        Compute the mean field of the collection of fields.

        Returns
        -------
        mean : :class:`~openturns.Field`
            The mean field has the same dimension `d` and the same mesh as the fields
            contained in the collection. At each vertex of the mesh, we compute
            the mean of the values at this vertex of the `K` fields contained
            in the process sample:

            .. math::

                \forall i \in [0,N-1], \quad \dfrac{1}{K} \sum_{k=1}^K \vect{x}_i^k

        """
        return _func.ProcessSampleImplementation_computeMean(self)

    def computeTemporalMean(self):
        r"""
        Compute the temporal mean of the values of the fields.

        Returns
        -------
        spatialMean : :class:`~openturns.Sample`
            Its size is the number `K` of fields in the collection.
            Its dimension is `d`.
            The `k` numerical point is the temporal mean of the field `k`:

            .. math::

                \forall k \in [1,K], \quad \dfrac{1}{N}\sum_{i=0}^{N-1} \vect{x}_i^k

        This method can be used only when the mesh can be interpreted as a regular grid.

        """
        return _func.ProcessSampleImplementation_computeTemporalMean(self)

    def computeSpatialMean(self):
        r"""
        Compute the spatial mean of the values of the fields.

        Returns
        -------
        spatialMean : :class:`~openturns.Sample`
            Its size is the number `K` of fields in the collection.
            Its dimension is `d`. The `k` numerical point is the spatial mean of the field `k`:

            .. math::

                \forall k \in [1,K], \quad \dfrac{1}{N}\sum_{i=0}^{N-1} \vect{x}_i^k

        """
        return _func.ProcessSampleImplementation_computeSpatialMean(self)

    def computeStandardDeviation(self):
        r"""
        Compute the standard deviation field of the collection of fields.

        Returns
        -------
        stddev : :class:`~openturns.Field`
            The standard deviation field has the same dimension `d` and the same mesh
            as the fields contained in the collection.
            At each vertex of the mesh, we compute the standard deviation of the
            values at this vertex of the `K` fields contained in the process sample:

            .. math::

                \forall i \in [0,N-1], \quad \sqrt{\dfrac{1}{K-1} \sum_{k=1}^K (\vect{x}_i^k - \hat{\mu}_i)^2}
        """
        return _func.ProcessSampleImplementation_computeStandardDeviation(self)

    def computeRange(self):
        r"""
        Compute the range field of the collection of fields.

        Returns
        -------
        range : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise range, i.e. the difference between the largest and
            the lowest value in the field collection.

        """
        return _func.ProcessSampleImplementation_computeRange(self)

    def computeMedian(self):
        r"""
        Compute the median field of the collection of fields.

        Returns
        -------
        median : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise empirical median. It is the same as
            `computeQuantilePerComponent(0.5)`.

        """
        return _func.ProcessSampleImplementation_computeMedian(self)

    def computeVariance(self):
        r"""
        Compute the variance field of the collection of fields.

        Returns
        -------
        variance : :class:`~openturns.Field`
            The variance field has the same dimension `d` and the same mesh
            as the fields contained in the collection.
            At each vertex of the mesh, we compute the variance of the
            values at this vertex of the `K` fields contained in the process sample.

        """
        return _func.ProcessSampleImplementation_computeVariance(self)

    def computeSkewness(self):
        r"""
        Compute the skewness field of the collection of fields.

        Returns
        -------
        skewness : :class:`~openturns.Field`
            The squewness field has the same dimension `d` and the same mesh
            as the fields contained in the collection.
            At each vertex of the mesh, we compute the skewness of the
            values at this vertex of the `K` fields contained in the process sample.

        """
        return _func.ProcessSampleImplementation_computeSkewness(self)

    def computeKurtosis(self):
        r"""
        Compute the kurtosis field of the collection of fields.

        Returns
        -------
        kurtosis : :class:`~openturns.Field`
            The squewness field has the same dimension `d` and the same mesh
            as the fields contained in the collection.
            At each vertex of the mesh, we compute the kurtosis of the
            values at this vertex of the `K` fields contained in the process sample.

        """
        return _func.ProcessSampleImplementation_computeKurtosis(self)

    def computeCentralMoment(self, k):
        r"""
        Compute the central moment field of the collection of fields.

        Parameters
        ----------
        k : int
            Order of the moment.

        Returns
        -------
        moment : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise central moment of order `n`.

        """
        return _func.ProcessSampleImplementation_computeCentralMoment(self, k)

    def computeRawMoment(self, k):
        r"""
        Compute the raw moment field of the collection of fields.

        Parameters
        ----------
        k : int
            Order of the moment.

        Returns
        -------
        moment : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise raw moment of order `n`.

        """
        return _func.ProcessSampleImplementation_computeRawMoment(self, k)

    def computeEmpiricalCDF(self, point, tail=False):
        r"""
        Compute the empirical CDF field of the collection of fields.

        Parameters
        ----------
        point : sequence of float
            The point at which all the marginal CDF are computed. Its dimension
            must match the process sample dimension.
        tail : bool (optional, default=False)
            Flag to if it is the CDF or the complementary CDF which is computed.

        Returns
        -------
        cdf : :class:`~openturns.Field`
            This field is scalar and has the same size as the process sample.
            At each vertex of the mesh, we compute the component-wise empirical
            CDF at the given point.

        """
        return _func.ProcessSampleImplementation_computeEmpiricalCDF(self, point, tail)

    def getMax(self):
        r"""
        Compute the max field of the collection of fields.

        Returns
        -------
        max : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise maximum.

        """
        return _func.ProcessSampleImplementation_getMax(self)

    def getMin(self):
        r"""
        Compute the min field of the collection of fields.

        Returns
        -------
        min : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise minimum.

        """
        return _func.ProcessSampleImplementation_getMin(self)

    def computeQuantilePerComponent(self, *args):
        r"""
        Compute the quantile field of the collection of fields.

        Parameters
        ----------
        p : float, :math:`0 \leq p \leq 1`, or sequence of float
            Order of the quantile.

        Returns
        -------
        quantile : :class:`~openturns.Field` or :class:`~openturns.ProcessSample`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise empirical quantile of order `p`.

        """
        return _func.ProcessSampleImplementation_computeQuantilePerComponent(self, *args)

    def getMarginal(self, *args):
        r"""
        Marginal sample accessor.

        Parameters
        ----------
        indice : int or sequence of int
            Index of the marginals.

        Returns
        -------
        sample : :class:`~openturns.ProcessSample`
            The marginal sample.

        """
        return _func.ProcessSampleImplementation_getMarginal(self, *args)

    def drawMarginal(self, index=0, interpolate=True):
        r"""
        Draw the selected field.

        Parameters
        ----------
        indice : int
            Index of the field that is drawn in the graph.
        interpolate : bool (optional, default=True)
            Whether to draw interpolated values.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of the selected field using the `interpolate` method.

        """
        return _func.ProcessSampleImplementation_drawMarginal(self, index, interpolate)

    def draw(self, interpolate=True):
        r"""
        Draw the whole field.

        Parameters
        ----------
        interpolate : bool (optional, default=True)
            Whether to draw interpolated values.

        Returns
        -------
        graph : :class:`~openturns.GridLayout`
            The graph of the whole field using the `interpolate` method.

        """
        return _func.ProcessSampleImplementation_draw(self, interpolate)

    def drawMarginalCorrelation(self, i, j):
        r"""
        Draw correlation between 2 marginals.

        This is only available on a 1-d mesh.

        Parameters
        ----------
        i, j : int, :math:`i, j < d`
            Marginal indices.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of the correlation between 2 marginals.

        """
        return _func.ProcessSampleImplementation_drawMarginalCorrelation(self, i, j)

    def drawCorrelation(self):
        r"""
        Draw correlation between all marginals.

        This is only available on a 1-d mesh.

        Returns
        -------
        graph : :class:`~openturns.GridLayout`
            The graph of the correlation between all marginals.

        """
        return _func.ProcessSampleImplementation_drawCorrelation(self)

    def __eq__(self, *args):
        return _func.ProcessSampleImplementation___eq__(self, *args)

    def __iadd__(self, *args):
        return _func.ProcessSampleImplementation___iadd__(self, *args)

    def __isub__(self, *args):
        return _func.ProcessSampleImplementation___isub__(self, *args)

    def __add__(self, *args):
        return _func.ProcessSampleImplementation___add__(self, *args)

    def __sub__(self, *args):
        return _func.ProcessSampleImplementation___sub__(self, *args)

    def getSampleAtVertex(self, index):
        r"""
        Extract sample at specific vertex of the mesh.

        Parameters
        ----------
        index : int, :math:`index < N`
            Node index in the mesh.

        Returns
        -------
        sample_at_i : :class:`Sample`
            The sample of all values of the trajectories at the desired node.

        """
        return _func.ProcessSampleImplementation_getSampleAtVertex(self, index)

    def __init__(self, *args):
        _func.ProcessSampleImplementation_swiginit(self, _func.new_ProcessSampleImplementation(*args))

    def __getitem__(self, index):
        return _func.ProcessSampleImplementation___getitem__(self, index)

    def __setitem__(self, index, field):
        return _func.ProcessSampleImplementation___setitem__(self, index, field)

    def __len__(self):
        return _func.ProcessSampleImplementation___len__(self)
    __swig_destroy__ = _func.delete_ProcessSampleImplementation

# Register ProcessSampleImplementation in _func:
_func.ProcessSampleImplementation_swigregister(ProcessSampleImplementation)
class _ProcessSampleImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._ProcessSampleImplementationTypedInterfaceObject_swiginit(self, _func.new__ProcessSampleImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._ProcessSampleImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._ProcessSampleImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._ProcessSampleImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._ProcessSampleImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._ProcessSampleImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__ProcessSampleImplementationTypedInterfaceObject

# Register _ProcessSampleImplementationTypedInterfaceObject in _func:
_func._ProcessSampleImplementationTypedInterfaceObject_swigregister(_ProcessSampleImplementationTypedInterfaceObject)
class ProcessSample(_ProcessSampleImplementationTypedInterfaceObject):
    r"""
    Collection of fields.

    Available constructors:
        ProcessSample(*mesh, K, d*)

        ProcessSample(*mesh, coll*)

        ProcessSample(*K, field*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        The mesh shared by all the fields in the collection.
    K : int
        Number of fields in the collection.
    d : int
        Dimension  of the values of the field.
    field : :class:`~openturns.Field`
        One field.
    coll : sequence of :class:`~openturns.Sample`
        List of field values.

    Notes
    -----
    A :class:`~openturns.ProcessSample` stores a sample of fields.
    We note `K` the number of fields contained in the process sample and `d` the dimension of the values associated to each vertex of the common mesh :math:`\cM \in \Rset^n`.

    These fields can be generated by a stochastic process.

    - In the first usage, we fix the common mesh with `mesh`, the number of fields contained in the sample with `K` and the dimension of the values with `d`.
      The values of the fields are by default fixed to zero.

    - In the second usage, the  collection of fields is filled with `K` copies of the given field `field`.

    We note :math:`\vect{x}_i^k \in \Rset^d` the value of the field `k` at the vertex `i`.
    We note `N` the number of vertices of :math:`\cM`, with :math:`0 \leq i \leq N-1` and :math:`1 \leq k \leq K`.

    Examples
    --------
    Create a bi dimensional mesh as a box:

    >>> import openturns as ot
    >>> myIndices = [10, 5]
    >>> myMesher = ot.IntervalMesher(myIndices)
    >>> lowerBound = [0.0, 0.0]
    >>> upperBound = [2.0, 1.0]
    >>> myInterval = ot.Interval(lowerBound, upperBound)
    >>> myMesh = myMesher.build(myInterval)

    Create a second order normal process of dimension 3:

    >>> amplitude = [5]
    >>> scale = [3, 3]
    >>> model = ot.ExponentialModel(scale, amplitude)
    >>> myProcess = ot.GaussianProcess(model, myMesh)

    Generate a sample of different fields:

    >>> n = 10
    >>> mySampleFields = myProcess.getSample(n)

    Duplicate the same field:

    >>> myField = myProcess.getRealization()
    >>> n = 10
    >>> mySampleFields2 = ot.ProcessSample(n, myField)

    We now show how to create a process sample from a collection of samples and a mesh.
    Here, the distribution at each vertex is considered to be a three-dimensional normal distribution

    >>> outputDimension = 3
    >>> sampleSize = 250
    >>> numberOfVertices = myMesh.getVerticesNumber()
    >>> normal = ot.Normal(outputDimension)
    >>> coll = [normal.getSample(numberOfVertices) for i in range(sampleSize)]
    >>> mySampleFields3 = ot.ProcessSample(myMesh, coll)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProcessSample_getClassName(self)

    def add(self, *args):
        r"""
        Add a field to the collection.

        Parameters
        ----------
        field : :class:`~openturns.Field`
            A new field to add. 
            This field shares the same mesh and the same dimension as the other
            fields of the collection.

        """
        return _func.ProcessSample_add(self, *args)

    def erase(self, *args):
        r"""
        Erase point(s) at or between index(es) (in-place).

        Parameters
        ----------
        f : int, :math:`0 \leq f < m`
            The index of the first point to erase.
        l : int, :math:`f < l \leq m`, optional
            The index after the last point to erase.
            Default uses `l = f + 1` and only removes `sample[f]`.
        """
        return _func.ProcessSample_erase(self, *args)

    def clear(self):
        r"""Erase all field values."""
        return _func.ProcessSample_clear(self)

    def setField(self, field, i):
        r"""
        Field accessor.

        Parameters
        ----------
        i : int
            Field index
        field : :class:`~openturns.Field`
            i-th field in the sample.

        """
        return _func.ProcessSample_setField(self, field, i)

    def getField(self, i):
        r"""
        Field accessor.

        Parameters
        ----------
        i : int
            Field index

        Returns
        -------
        field : :class:`~openturns.Field`
            i-th field in the sample.

        """
        return _func.ProcessSample_getField(self, i)

    def __repr__(self):
        return _func.ProcessSample___repr__(self)

    def __str__(self, *args):
        return _func.ProcessSample___str__(self, *args)

    def getTimeGrid(self):
        r"""
        Get the time grid of the fields.

        Returns
        -------
        mesh : :class:`~openturns.RegularGrid`
            The time grid shared by all the fields of the collection.
            Can be used only if the mesh can be interpreted as a regular time grid.

        """
        return _func.ProcessSample_getTimeGrid(self)

    def getMesh(self):
        r"""
        Get the mesh of the fields.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh shared by all the fields of the collection.

        """
        return _func.ProcessSample_getMesh(self)

    def getSize(self):
        r"""
        Get the size of the collection of fields.

        Returns
        -------
        K : int
            Number of fields in the collection.

        """
        return _func.ProcessSample_getSize(self)

    def getDimension(self):
        r"""
        Get the dimension of the values of fields.

        Returns
        -------
        d : int
            Dimension of the values of the fields.

        """
        return _func.ProcessSample_getDimension(self)

    def computeMean(self):
        r"""
        Compute the mean field of the collection of fields.

        Returns
        -------
        mean : :class:`~openturns.Field`
            The mean field has the same dimension `d` and the same mesh as the fields
            contained in the collection. At each vertex of the mesh, we compute
            the mean of the values at this vertex of the `K` fields contained
            in the process sample:

            .. math::

                \forall i \in [0,N-1], \quad \dfrac{1}{K} \sum_{k=1}^K \vect{x}_i^k

        """
        return _func.ProcessSample_computeMean(self)

    def computeTemporalMean(self):
        r"""
        Compute the temporal mean of the values of the fields.

        Returns
        -------
        spatialMean : :class:`~openturns.Sample`
            Its size is the number `K` of fields in the collection.
            Its dimension is `d`.
            The `k` numerical point is the temporal mean of the field `k`:

            .. math::

                \forall k \in [1,K], \quad \dfrac{1}{N}\sum_{i=0}^{N-1} \vect{x}_i^k

        This method can be used only when the mesh can be interpreted as a regular grid.

        """
        return _func.ProcessSample_computeTemporalMean(self)

    def computeSpatialMean(self):
        r"""
        Compute the spatial mean of the values of the fields.

        Returns
        -------
        spatialMean : :class:`~openturns.Sample`
            Its size is the number `K` of fields in the collection.
            Its dimension is `d`. The `k` numerical point is the spatial mean of the field `k`:

            .. math::

                \forall k \in [1,K], \quad \dfrac{1}{N}\sum_{i=0}^{N-1} \vect{x}_i^k

        """
        return _func.ProcessSample_computeSpatialMean(self)

    def computeStandardDeviation(self):
        r"""
        Compute the standard deviation field of the collection of fields.

        Returns
        -------
        stddev : :class:`~openturns.Field`
            The standard deviation field has the same dimension `d` and the same mesh
            as the fields contained in the collection.
            At each vertex of the mesh, we compute the standard deviation of the
            values at this vertex of the `K` fields contained in the process sample:

            .. math::

                \forall i \in [0,N-1], \quad \sqrt{\dfrac{1}{K-1} \sum_{k=1}^K (\vect{x}_i^k - \hat{\mu}_i)^2}
        """
        return _func.ProcessSample_computeStandardDeviation(self)

    def computeRange(self):
        r"""
        Compute the range field of the collection of fields.

        Returns
        -------
        range : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise range, i.e. the difference between the largest and
            the lowest value in the field collection.

        """
        return _func.ProcessSample_computeRange(self)

    def computeMedian(self):
        r"""
        Compute the median field of the collection of fields.

        Returns
        -------
        median : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise empirical median. It is the same as
            `computeQuantilePerComponent(0.5)`.

        """
        return _func.ProcessSample_computeMedian(self)

    def computeVariance(self):
        r"""
        Compute the variance field of the collection of fields.

        Returns
        -------
        variance : :class:`~openturns.Field`
            The variance field has the same dimension `d` and the same mesh
            as the fields contained in the collection.
            At each vertex of the mesh, we compute the variance of the
            values at this vertex of the `K` fields contained in the process sample.

        """
        return _func.ProcessSample_computeVariance(self)

    def computeSkewness(self):
        r"""
        Compute the skewness field of the collection of fields.

        Returns
        -------
        skewness : :class:`~openturns.Field`
            The squewness field has the same dimension `d` and the same mesh
            as the fields contained in the collection.
            At each vertex of the mesh, we compute the skewness of the
            values at this vertex of the `K` fields contained in the process sample.

        """
        return _func.ProcessSample_computeSkewness(self)

    def computeKurtosis(self):
        r"""
        Compute the kurtosis field of the collection of fields.

        Returns
        -------
        kurtosis : :class:`~openturns.Field`
            The squewness field has the same dimension `d` and the same mesh
            as the fields contained in the collection.
            At each vertex of the mesh, we compute the kurtosis of the
            values at this vertex of the `K` fields contained in the process sample.

        """
        return _func.ProcessSample_computeKurtosis(self)

    def computeCentralMoment(self, k):
        r"""
        Compute the central moment field of the collection of fields.

        Parameters
        ----------
        k : int
            Order of the moment.

        Returns
        -------
        moment : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise central moment of order `n`.

        """
        return _func.ProcessSample_computeCentralMoment(self, k)

    def computeRawMoment(self, k):
        r"""
        Compute the raw moment field of the collection of fields.

        Parameters
        ----------
        k : int
            Order of the moment.

        Returns
        -------
        moment : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise raw moment of order `n`.

        """
        return _func.ProcessSample_computeRawMoment(self, k)

    def computeEmpiricalCDF(self, point, tail=False):
        r"""
        Compute the empirical CDF field of the collection of fields.

        Parameters
        ----------
        point : sequence of float
            The point at which all the marginal CDF are computed. Its dimension
            must match the process sample dimension.
        tail : bool (optional, default=False)
            Flag to if it is the CDF or the complementary CDF which is computed.

        Returns
        -------
        cdf : :class:`~openturns.Field`
            This field is scalar and has the same size as the process sample.
            At each vertex of the mesh, we compute the component-wise empirical
            CDF at the given point.

        """
        return _func.ProcessSample_computeEmpiricalCDF(self, point, tail)

    def getMax(self):
        r"""
        Compute the max field of the collection of fields.

        Returns
        -------
        max : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise maximum.

        """
        return _func.ProcessSample_getMax(self)

    def getMin(self):
        r"""
        Compute the min field of the collection of fields.

        Returns
        -------
        min : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise minimum.

        """
        return _func.ProcessSample_getMin(self)

    def computeQuantilePerComponent(self, *args):
        r"""
        Compute the quantile field of the collection of fields.

        Parameters
        ----------
        p : float, :math:`0 \leq p \leq 1`, or sequence of float
            Order of the quantile.

        Returns
        -------
        quantile : :class:`~openturns.Field` or :class:`~openturns.ProcessSample`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we compute the
            component-wise empirical quantile of order `p`.

        """
        return _func.ProcessSample_computeQuantilePerComponent(self, *args)

    def getMarginal(self, *args):
        r"""
        Marginal sample accessor.

        Parameters
        ----------
        indice : int or sequence of int
            Index of the marginals.

        Returns
        -------
        sample : :class:`~openturns.ProcessSample`
            The marginal sample.

        """
        return _func.ProcessSample_getMarginal(self, *args)

    def drawMarginal(self, index=0, interpolate=True):
        r"""
        Draw the selected field.

        Parameters
        ----------
        indice : int
            Index of the field that is drawn in the graph.
        interpolate : bool (optional, default=True)
            Whether to draw interpolated values.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of the selected field using the `interpolate` method.

        """
        return _func.ProcessSample_drawMarginal(self, index, interpolate)

    def draw(self, interpolate=True):
        r"""
        Draw the whole field.

        Parameters
        ----------
        interpolate : bool (optional, default=True)
            Whether to draw interpolated values.

        Returns
        -------
        graph : :class:`~openturns.GridLayout`
            The graph of the whole field using the `interpolate` method.

        """
        return _func.ProcessSample_draw(self, interpolate)

    def drawMarginalCorrelation(self, i, j):
        r"""
        Draw correlation between 2 marginals.

        This is only available on a 1-d mesh.

        Parameters
        ----------
        i, j : int, :math:`i, j < d`
            Marginal indices.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of the correlation between 2 marginals.

        """
        return _func.ProcessSample_drawMarginalCorrelation(self, i, j)

    def drawCorrelation(self):
        r"""
        Draw correlation between all marginals.

        This is only available on a 1-d mesh.

        Returns
        -------
        graph : :class:`~openturns.GridLayout`
            The graph of the correlation between all marginals.

        """
        return _func.ProcessSample_drawCorrelation(self)

    def __eq__(self, *args):
        return _func.ProcessSample___eq__(self, *args)

    def __iadd__(self, *args):
        return _func.ProcessSample___iadd__(self, *args)

    def __isub__(self, *args):
        return _func.ProcessSample___isub__(self, *args)

    def __add__(self, *args):
        return _func.ProcessSample___add__(self, *args)

    def __sub__(self, *args):
        return _func.ProcessSample___sub__(self, *args)

    def getSampleAtVertex(self, index):
        r"""
        Extract sample at specific vertex of the mesh.

        Parameters
        ----------
        index : int, :math:`index < N`
            Node index in the mesh.

        Returns
        -------
        sample_at_i : :class:`Sample`
            The sample of all values of the trajectories at the desired node.

        """
        return _func.ProcessSample_getSampleAtVertex(self, index)

    def __init__(self, *args):
        _func.ProcessSample_swiginit(self, _func.new_ProcessSample(*args))

    def __getitem__(self, index):
        return _func.ProcessSample___getitem__(self, index)

    def __setitem__(self, index, values):
        return _func.ProcessSample___setitem__(self, index, values)

    def __len__(self):
        return _func.ProcessSample___len__(self)
    __swig_destroy__ = _func.delete_ProcessSample

# Register ProcessSample in _func:
_func.ProcessSample_swigregister(ProcessSample)
class EvaluationImplementation(openturns.common.PersistentObject):
    r"""
    Numerical math evaluation implementation.

    Available constructors:
        EvaluationImplementation()

    See also
    --------
    Function, AggregatedEvaluation,
    DatabaseEvaluation,
    DualLinearCombinationEvaluation, LinearFunction

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.EvaluationImplementation_getClassName(self)

    def __eq__(self, *args):
        return _func.EvaluationImplementation___eq__(self, *args)

    def __repr__(self):
        return _func.EvaluationImplementation___repr__(self)

    def __str__(self, *args):
        return _func.EvaluationImplementation___str__(self, *args)

    def _repr_html_(self):
        return _func.EvaluationImplementation__repr_html_(self)

    def setDescription(self, description):
        r"""
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.EvaluationImplementation_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        """
        return _func.EvaluationImplementation_getDescription(self)

    def getInputDescription(self):
        r"""
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.EvaluationImplementation_getInputDescription(self)

    def setInputDescription(self, inputDescription):
        r"""
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.
        """
        return _func.EvaluationImplementation_setInputDescription(self, inputDescription)

    def getOutputDescription(self):
        r"""
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func.EvaluationImplementation_getOutputDescription(self)

    def setOutputDescription(self, outputDescription):
        r"""
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.
        """
        return _func.EvaluationImplementation_setOutputDescription(self, outputDescription)

    def isActualImplementation(self):
        r"""
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.EvaluationImplementation_isActualImplementation(self)

    def __call__(self, *args):
        return _func.EvaluationImplementation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.EvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.EvaluationImplementation_getOutputDimension(self)

    def getParameterDimension(self):
        r"""
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func.EvaluationImplementation_getParameterDimension(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.EvaluationImplementation_getMarginal(self, *args)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.EvaluationImplementation_parameterGradient(self, inP)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.EvaluationImplementation_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.EvaluationImplementation_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.EvaluationImplementation_getParameterDescription(self)

    def setParameterDescription(self, description):
        r"""
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.EvaluationImplementation_setParameterDescription(self, description)

    def getCallsNumber(self):
        r"""
        Accessor to the number of times the function has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.EvaluationImplementation_getCallsNumber(self)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func.EvaluationImplementation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.EvaluationImplementation_isLinearlyDependent(self, index)

    def setCheckOutput(self, checkOutput):
        r"""
        Accessor to the output verification flag.

        Parameters
        ----------
        check_output : bool
            Whether to check return values for nan or inf.
        """
        return _func.EvaluationImplementation_setCheckOutput(self, checkOutput)

    def getCheckOutput(self):
        r"""
        Accessor to the output verification flag.

        Returns
        -------
        check_output : bool
            Whether to check return values for nan or inf.
        """
        return _func.EvaluationImplementation_getCheckOutput(self)

    def draw(self, *args):
        r"""
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb, scale*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs, scale, isFilled*)

            draw(*xiMin, xiMax, ptNb, scale*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs, scale*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0`
            The number of points to draw the curves.
        ptNbs : sequence of int of dimension 2 :math:`ptNbs_k > 0, k=1,2`
            The number of points to draw the contour in the 2D case.
        scale : bool
            scale indicates whether the logarithmic scale is used either for one or both axes:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        isFilled : bool
            isFilled indicates whether the contour graph is filled or not

        Notes
        -----
        We note :math:`f: \Rset^n \rightarrow \Rset^p`
        where :math:`\vect{x} = (x_1, \dots, x_n)` and
        :math:`f(\vect{x}) = (f_1(\vect{x}), \dots,f_p(\vect{x}))`,
        with :math:`n\geq 1` and :math:`p\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \Rset^n \rightarrow \Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then it draws the graph:
        :math:`t\in [x_i^{min}, x_i^{max}] \mapsto f_k(CP_1, \dots, CP_{i-1}, t,  CP_{i+1} \dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then it draws the graph:
        :math:`(t,u) \in [x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}] \mapsto f_k(CP_1, \dots, CP_{i-1}, t, CP_{i+1}, \dots, CP_{j-1}, u,  CP_{j+1} \dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \Rset \rightarrow \Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \Rset^2 \rightarrow \Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction(['x'], ['sin(2*pi_*x)*exp(-x^2/2)'])
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.EvaluationImplementation_draw(self, *args)

    def drawCrossCuts(self, *args):
        r"""
        Draw the 2D and 1D cross cuts of a 1D output function as a :class:`~openturns.GridLayout`.

        Parameters
        ----------
        centralPoint : sequence of float
            Central point with dimension equal to the input dimension of the function.
        xMin, xMax : sequence of float
            Define the interval where the curve is plotted.
        pointNumber : sequence of int
            The number of points to draw the contours and the curves.
        withMonoDimensionalCuts : bool, optional
            withMonoDimensionalCuts indicates whether the mono dimension cuts are drawn or not
            Default value is specified in the `CrossCuts-DefaultWithMonoDimensionalCuts` ResourceMap key.
        isFilled : bool, optional
            isFilled indicates whether the contour graphs are filled or not
            Default value is specified in the `Contour-DefaultIsFilled` ResourceMap key
        vMin, vMax : float, optional
            Define the interval used to build the color map for the contours
            If not specified, these values are computed to best fit the graphs.
            Either specify both values or do not specify any.

        Notes
        -----
        We note :math:`f: \Rset^n \rightarrow \Rset^p`
        where :math:`\vect{x} = (x_1, \dots, x_n)` and
        :math:`f(\vect{x}) = (f_1(\vect{x}), \dots, f_p(\vect{x}))`,
        with :math:`n\geq 1` and :math:`p\geq 1`.

        In all usages, draw the 1D and 2D cross cuts of
        :math:`f_k: \Rset^n \rightarrow \Rset` as a function of all input coordinates for 1D cuts
        and all couples of coordinates for 2D cuts. Variable coordinates :math:`x_i` are sampled
        regularly using :math:`ptNb[i]` points in the interval :math:`[x_i^{min}, x_i^{max}]`,
        when all the other components of :math:`\vect{x}` are fixed to the corresponding components
        of the *centralPoint* :math:`\vect{c}`. In the first usage, vMin and vMax are evaluated as
        the min and max of all samples of the function value calculated in all cross cuts performed.

        - For 1D cross cuts:

        OpenTURNS draws the graph:

        .. math::
            y = f_k^{(i)}(s)

        for any :math:`s \in [x_i^{min}, x_i^{max}]` where :math:`f_k^{(i)}(s)` is defined by the equation:

        .. math::
            f_k^{(i)}(s) = f_k(c_1, \dots, c_{i-1}, s,  c_{i+1} \dots, c_n).

        - For 2D cross cuts:

        .. math::
            y = f_k^{(i,j)}(s, t)

        for any :math:`(s, t) \in [x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]` where :math:`f_k^{(i,j)}` 
        is defined by the equation:

        .. math::
            f_k^{(i,j)}(s,t) = f_k(c_1, \dots, c_{i-1}, s, c_{i+1}, \dots, c_{j-1}, t,  c_{j+1} \dots, c_n).

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction(['x0', 'x1', 'x2'], ['sin(1*pi_*x0) + x1 - x2 ^ 2'])
        >>> grid = f.drawCrossCuts([0., 0., 0.], [-3., -3, -3], [3, 3, 3], [100, 20, 20], True, True)
        >>> View(grid).show()
        """
        return _func.EvaluationImplementation_drawCrossCuts(self, *args)

    def setStopCallback(self, callBack, state=None):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop an evaluation.

        Parameters
        ----------
        callback : callable
            Returns a bool deciding whether to stop or continue.

        """
        return _func.EvaluationImplementation_setStopCallback(self, callBack, state)

    def __init__(self, *args):
        _func.EvaluationImplementation_swiginit(self, _func.new_EvaluationImplementation(*args))
    __swig_destroy__ = _func.delete_EvaluationImplementation

# Register EvaluationImplementation in _func:
_func.EvaluationImplementation_swigregister(EvaluationImplementation)
class _EvaluationImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._EvaluationImplementationTypedInterfaceObject_swiginit(self, _func.new__EvaluationImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._EvaluationImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._EvaluationImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._EvaluationImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._EvaluationImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._EvaluationImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__EvaluationImplementationTypedInterfaceObject

# Register _EvaluationImplementationTypedInterfaceObject in _func:
_func._EvaluationImplementationTypedInterfaceObject_swigregister(_EvaluationImplementationTypedInterfaceObject)
class Evaluation(_EvaluationImplementationTypedInterfaceObject):
    r"""
    Numerical math evaluation implementation.

    Available constructors:
        EvaluationImplementation()

    See also
    --------
    Function, AggregatedEvaluation,
    DatabaseEvaluation,
    DualLinearCombinationEvaluation, LinearFunction

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Evaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.Evaluation___eq__(self, *args)

    def __repr__(self):
        return _func.Evaluation___repr__(self)

    def __str__(self, *args):
        return _func.Evaluation___str__(self, *args)

    def _repr_html_(self):
        return _func.Evaluation__repr_html_(self)

    def setDescription(self, description):
        r"""
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.Evaluation_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        """
        return _func.Evaluation_getDescription(self)

    def getInputDescription(self):
        r"""
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.Evaluation_getInputDescription(self)

    def setInputDescription(self, inputDescription):
        r"""
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.
        """
        return _func.Evaluation_setInputDescription(self, inputDescription)

    def getOutputDescription(self):
        r"""
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func.Evaluation_getOutputDescription(self)

    def setOutputDescription(self, outputDescription):
        r"""
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.
        """
        return _func.Evaluation_setOutputDescription(self, outputDescription)

    def __call__(self, *args):
        return _func.Evaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.Evaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.Evaluation_getOutputDimension(self)

    def getParameterDimension(self):
        r"""
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func.Evaluation_getParameterDimension(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.Evaluation_getMarginal(self, *args)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.Evaluation_parameterGradient(self, inP)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.Evaluation_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.Evaluation_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.Evaluation_getParameterDescription(self)

    def setParameterDescription(self, description):
        r"""
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.Evaluation_setParameterDescription(self, description)

    def getCallsNumber(self):
        r"""
        Accessor to the number of times the function has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.Evaluation_getCallsNumber(self)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func.Evaluation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.Evaluation_isLinearlyDependent(self, index)

    def setCheckOutput(self, checkOutput):
        r"""
        Accessor to the output verification flag.

        Parameters
        ----------
        check_output : bool
            Whether to check return values for nan or inf.
        """
        return _func.Evaluation_setCheckOutput(self, checkOutput)

    def getCheckOutput(self):
        r"""
        Accessor to the output verification flag.

        Returns
        -------
        check_output : bool
            Whether to check return values for nan or inf.
        """
        return _func.Evaluation_getCheckOutput(self)

    def draw(self, *args):
        r"""
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb, scale*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs, scale, isFilled*)

            draw(*xiMin, xiMax, ptNb, scale*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs, scale*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0`
            The number of points to draw the curves.
        ptNbs : sequence of int of dimension 2 :math:`ptNbs_k > 0, k=1,2`
            The number of points to draw the contour in the 2D case.
        scale : bool
            scale indicates whether the logarithmic scale is used either for one or both axes:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        isFilled : bool
            isFilled indicates whether the contour graph is filled or not

        Notes
        -----
        We note :math:`f: \Rset^n \rightarrow \Rset^p`
        where :math:`\vect{x} = (x_1, \dots, x_n)` and
        :math:`f(\vect{x}) = (f_1(\vect{x}), \dots,f_p(\vect{x}))`,
        with :math:`n\geq 1` and :math:`p\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \Rset^n \rightarrow \Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then it draws the graph:
        :math:`t\in [x_i^{min}, x_i^{max}] \mapsto f_k(CP_1, \dots, CP_{i-1}, t,  CP_{i+1} \dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then it draws the graph:
        :math:`(t,u) \in [x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}] \mapsto f_k(CP_1, \dots, CP_{i-1}, t, CP_{i+1}, \dots, CP_{j-1}, u,  CP_{j+1} \dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \Rset \rightarrow \Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \Rset^2 \rightarrow \Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction(['x'], ['sin(2*pi_*x)*exp(-x^2/2)'])
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.Evaluation_draw(self, *args)

    def drawCrossCuts(self, *args):
        r"""
        Draw the 2D and 1D cross cuts of a 1D output function as a :class:`~openturns.GridLayout`.

        Parameters
        ----------
        centralPoint : sequence of float
            Central point with dimension equal to the input dimension of the function.
        xMin, xMax : sequence of float
            Define the interval where the curve is plotted.
        pointNumber : sequence of int
            The number of points to draw the contours and the curves.
        withMonoDimensionalCuts : bool, optional
            withMonoDimensionalCuts indicates whether the mono dimension cuts are drawn or not
            Default value is specified in the `CrossCuts-DefaultWithMonoDimensionalCuts` ResourceMap key.
        isFilled : bool, optional
            isFilled indicates whether the contour graphs are filled or not
            Default value is specified in the `Contour-DefaultIsFilled` ResourceMap key
        vMin, vMax : float, optional
            Define the interval used to build the color map for the contours
            If not specified, these values are computed to best fit the graphs.
            Either specify both values or do not specify any.

        Notes
        -----
        We note :math:`f: \Rset^n \rightarrow \Rset^p`
        where :math:`\vect{x} = (x_1, \dots, x_n)` and
        :math:`f(\vect{x}) = (f_1(\vect{x}), \dots, f_p(\vect{x}))`,
        with :math:`n\geq 1` and :math:`p\geq 1`.

        In all usages, draw the 1D and 2D cross cuts of
        :math:`f_k: \Rset^n \rightarrow \Rset` as a function of all input coordinates for 1D cuts
        and all couples of coordinates for 2D cuts. Variable coordinates :math:`x_i` are sampled
        regularly using :math:`ptNb[i]` points in the interval :math:`[x_i^{min}, x_i^{max}]`,
        when all the other components of :math:`\vect{x}` are fixed to the corresponding components
        of the *centralPoint* :math:`\vect{c}`. In the first usage, vMin and vMax are evaluated as
        the min and max of all samples of the function value calculated in all cross cuts performed.

        - For 1D cross cuts:

        OpenTURNS draws the graph:

        .. math::
            y = f_k^{(i)}(s)

        for any :math:`s \in [x_i^{min}, x_i^{max}]` where :math:`f_k^{(i)}(s)` is defined by the equation:

        .. math::
            f_k^{(i)}(s) = f_k(c_1, \dots, c_{i-1}, s,  c_{i+1} \dots, c_n).

        - For 2D cross cuts:

        .. math::
            y = f_k^{(i,j)}(s, t)

        for any :math:`(s, t) \in [x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]` where :math:`f_k^{(i,j)}` 
        is defined by the equation:

        .. math::
            f_k^{(i,j)}(s,t) = f_k(c_1, \dots, c_{i-1}, s, c_{i+1}, \dots, c_{j-1}, t,  c_{j+1} \dots, c_n).

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction(['x0', 'x1', 'x2'], ['sin(1*pi_*x0) + x1 - x2 ^ 2'])
        >>> grid = f.drawCrossCuts([0., 0., 0.], [-3., -3, -3], [3, 3, 3], [100, 20, 20], True, True)
        >>> View(grid).show()
        """
        return _func.Evaluation_drawCrossCuts(self, *args)

    def setStopCallback(self, callBack, state=None):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop an evaluation.

        Parameters
        ----------
        callback : callable
            Returns a bool deciding whether to stop or continue.

        """
        return _func.Evaluation_setStopCallback(self, callBack, state)

    def __init__(self, *args):
        _func.Evaluation_swiginit(self, _func.new_Evaluation(*args))
    __swig_destroy__ = _func.delete_Evaluation

# Register Evaluation in _func:
_func.Evaluation_swigregister(Evaluation)
class GradientImplementation(openturns.common.PersistentObject):
    r"""
    Numerical math gradient implementation.

    See also
    --------
    Function, HessianImplementation

    Notes
    -----
    This object is the result of the method *getGradient* of a 
    :class:`~openturns.Function`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.GradientImplementation_getClassName(self)

    def __eq__(self, *args):
        return _func.GradientImplementation___eq__(self, *args)

    def __repr__(self):
        return _func.GradientImplementation___repr__(self)

    def __str__(self, *args):
        return _func.GradientImplementation___str__(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : int
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.GradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.GradientImplementation_getMarginal(self, *args)

    def isActualImplementation(self):
        r"""
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.GradientImplementation_isActualImplementation(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.GradientImplementation_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.GradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.GradientImplementation_getOutputDimension(self)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.GradientImplementation_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.GradientImplementation_setParameter(self, parameter)

    def getCallsNumber(self):
        r"""
        Accessor to the number of times the gradient has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the gradient has been called
            since its creation.
        """
        return _func.GradientImplementation_getCallsNumber(self)

    def __init__(self, *args):
        _func.GradientImplementation_swiginit(self, _func.new_GradientImplementation(*args))
    __swig_destroy__ = _func.delete_GradientImplementation

# Register GradientImplementation in _func:
_func.GradientImplementation_swigregister(GradientImplementation)
class _GradientImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._GradientImplementationTypedInterfaceObject_swiginit(self, _func.new__GradientImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._GradientImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._GradientImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._GradientImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._GradientImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._GradientImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__GradientImplementationTypedInterfaceObject

# Register _GradientImplementationTypedInterfaceObject in _func:
_func._GradientImplementationTypedInterfaceObject_swigregister(_GradientImplementationTypedInterfaceObject)
class Gradient(_GradientImplementationTypedInterfaceObject):
    r"""
    Numerical math gradient implementation.

    See also
    --------
    Function, HessianImplementation

    Notes
    -----
    This object is the result of the method *getGradient* of a 
    :class:`~openturns.Function`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Gradient_getClassName(self)

    def __eq__(self, *args):
        return _func.Gradient___eq__(self, *args)

    def __repr__(self):
        return _func.Gradient___repr__(self)

    def __str__(self, *args):
        return _func.Gradient___str__(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : int
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.GradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.Gradient_getMarginal(self, *args)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.Gradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.Gradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.Gradient_getOutputDimension(self)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.Gradient_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.Gradient_setParameter(self, parameter)

    def getCallsNumber(self):
        r"""
        Accessor to the number of times the gradient has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the gradient has been called
            since its creation.
        """
        return _func.Gradient_getCallsNumber(self)

    def __init__(self, *args):
        _func.Gradient_swiginit(self, _func.new_Gradient(*args))
    __swig_destroy__ = _func.delete_Gradient

# Register Gradient in _func:
_func.Gradient_swigregister(Gradient)
class HessianImplementation(openturns.common.PersistentObject):
    r"""
    Numerical math hessian implementation.

    See also
    --------
    Function, GradientImplementation

    Notes
    -----
    This object is the result of the method *getHessian* of a 
    :class:`~openturns.Function`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.HessianImplementation_getClassName(self)

    def __eq__(self, *args):
        return _func.HessianImplementation___eq__(self, *args)

    def __repr__(self):
        return _func.HessianImplementation___repr__(self)

    def __str__(self, *args):
        return _func.HessianImplementation___str__(self, *args)

    def isActualImplementation(self):
        r"""
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.HessianImplementation_isActualImplementation(self)

    def getMarginal(self, *args):
        r"""
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : int
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.HessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.HessianImplementation_getMarginal(self, *args)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.HessianImplementation_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.HessianImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.HessianImplementation_getOutputDimension(self)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.HessianImplementation_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.HessianImplementation_setParameter(self, parameter)

    def getCallsNumber(self):
        r"""
        Accessor to the number of times the hessian has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the hessian has been called
            since its creation.
        """
        return _func.HessianImplementation_getCallsNumber(self)

    def __init__(self, *args):
        _func.HessianImplementation_swiginit(self, _func.new_HessianImplementation(*args))
    __swig_destroy__ = _func.delete_HessianImplementation

# Register HessianImplementation in _func:
_func.HessianImplementation_swigregister(HessianImplementation)
class _HessianImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._HessianImplementationTypedInterfaceObject_swiginit(self, _func.new__HessianImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._HessianImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._HessianImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._HessianImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._HessianImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._HessianImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__HessianImplementationTypedInterfaceObject

# Register _HessianImplementationTypedInterfaceObject in _func:
_func._HessianImplementationTypedInterfaceObject_swigregister(_HessianImplementationTypedInterfaceObject)
class Hessian(_HessianImplementationTypedInterfaceObject):
    r"""
    Numerical math hessian implementation.

    See also
    --------
    Function, GradientImplementation

    Notes
    -----
    This object is the result of the method *getHessian* of a 
    :class:`~openturns.Function`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Hessian_getClassName(self)

    def __eq__(self, *args):
        return _func.Hessian___eq__(self, *args)

    def __repr__(self):
        return _func.Hessian___repr__(self)

    def __str__(self, *args):
        return _func.Hessian___str__(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : int
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.HessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.Hessian_getMarginal(self, *args)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.Hessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.Hessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.Hessian_getOutputDimension(self)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.Hessian_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.Hessian_setParameter(self, parameter)

    def getCallsNumber(self):
        r"""
        Accessor to the number of times the hessian has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the hessian has been called
            since its creation.
        """
        return _func.Hessian_getCallsNumber(self)

    def __init__(self, *args):
        _func.Hessian_swiginit(self, _func.new_Hessian(*args))
    __swig_destroy__ = _func.delete_Hessian

# Register Hessian in _func:
_func.Hessian_swigregister(Hessian)
class NoEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::NoEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NoEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.NoEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.NoEvaluation___repr__(self)

    def isActualImplementation(self):
        r"""
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.NoEvaluation_isActualImplementation(self)

    def __call__(self, inP):
        return _func.NoEvaluation___call__(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.NoEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.NoEvaluation_getOutputDimension(self)

    def __init__(self, *args):
        _func.NoEvaluation_swiginit(self, _func.new_NoEvaluation(*args))
    __swig_destroy__ = _func.delete_NoEvaluation

# Register NoEvaluation in _func:
_func.NoEvaluation_swigregister(NoEvaluation)
class NoGradient(GradientImplementation):
    r"""Proxy of C++ OT::NoGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NoGradient_getClassName(self)

    def __eq__(self, *args):
        return _func.NoGradient___eq__(self, *args)

    def __repr__(self):
        return _func.NoGradient___repr__(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NoGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NoGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NoGradient_getOutputDimension(self)

    def isActualImplementation(self):
        r"""
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.NoGradient_isActualImplementation(self)

    def __init__(self, *args):
        _func.NoGradient_swiginit(self, _func.new_NoGradient(*args))
    __swig_destroy__ = _func.delete_NoGradient

# Register NoGradient in _func:
_func.NoGradient_swigregister(NoGradient)
class NoHessian(HessianImplementation):
    r"""Proxy of C++ OT::NoHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NoHessian_getClassName(self)

    def __eq__(self, *args):
        return _func.NoHessian___eq__(self, *args)

    def __repr__(self):
        return _func.NoHessian___repr__(self)

    def isActualImplementation(self):
        r"""
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.NoHessian_isActualImplementation(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NoHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NoHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NoHessian_getOutputDimension(self)

    def __init__(self, *args):
        _func.NoHessian_swiginit(self, _func.new_NoHessian(*args))
    __swig_destroy__ = _func.delete_NoHessian

# Register NoHessian in _func:
_func.NoHessian_swigregister(NoHessian)
class TranslationEvaluation(EvaluationImplementation):
    r"""
    Translation evaluation.

    Parameters
    ----------
    constant : sequence of float
        Vector :math:`\vect{c}`.

    See also
    --------
    Function

    Notes
    -----
    This implements a :class:`~openturns.Function` :math:`f`
    defined as :

    .. math::

        f : & \Rset^n \rightarrow \Rset^n  \\
            & \vect{X} \mapsto \vect{X} + \vect{c}

    where:

    - :math:`\vect{c}` is the :math:`\Rset^n` vector defined by the object *constant*.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TranslationEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.TranslationEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.TranslationEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.TranslationEvaluation___str__(self, *args)

    def getConstant(self):
        r"""
        Accessor to the constant.

        Returns
        -------
        constant : :class:`~openturns.Point`
            The constant :math:`\vect{c}`.
        """
        return _func.TranslationEvaluation_getConstant(self)

    def setConstant(self, constant):
        r"""
        Accessor to the constant.

        Parameters
        ----------
        constant : sequence of float
            The constant :math:`\vect{c}`.
        """
        return _func.TranslationEvaluation_setConstant(self, constant)

    def __call__(self, *args):
        return _func.TranslationEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.TranslationEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.TranslationEvaluation_getOutputDimension(self)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func.TranslationEvaluation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.TranslationEvaluation_isLinearlyDependent(self, index)

    def __init__(self, *args):
        _func.TranslationEvaluation_swiginit(self, _func.new_TranslationEvaluation(*args))
    __swig_destroy__ = _func.delete_TranslationEvaluation

# Register TranslationEvaluation in _func:
_func.TranslationEvaluation_swigregister(TranslationEvaluation)
class LinearEvaluation(EvaluationImplementation):
    r"""
    Linear numerical math evaluation implementation.

    Parameters
    ----------
    center : sequence of float
        Vector :math:`\vect{b}`.
    constant : sequence of float
        Vector :math:`\vect{c}`.
    linear : :class:`~openturns.Matrix`
        Matrix :math:`\mat{A}`.

    See also
    --------
    Function

    Notes
    -----
    This implements a linear :class:`~openturns.Function` :math:`f` 
    defined as :

    .. math::

        f : & \Rset^n \rightarrow \Rset^p  \\
            & \vect{X} \mapsto \mat{A} ( \vect{X} - \vect{b} ) + \vect{c}

    where:

    - :math:`\mat{A}` is the :math:`\Rset^p \times \Rset^n` matrix defined by the
      input *linear*
    - :math:`\vect{b}` is the :math:`\Rset^n` vector defined by the object *center*
    - :math:`\vect{c}` is the :math:`\Rset^p` vector defined by the object *constant*.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.LinearEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.LinearEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.LinearEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.LinearEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.LinearEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.LinearEvaluation_getOutputDimension(self)

    def getCenter(self):
        r"""
        Accessor to the center.

        Returns
        -------
        center : :class:`~openturns.Point`
            The center :math:`\vect{b}`.
        """
        return _func.LinearEvaluation_getCenter(self)

    def getConstant(self):
        r"""
        Accessor to the constant.

        Returns
        -------
        constant : :class:`~openturns.Point`
            The constant :math:`\vect{c}`.
        """
        return _func.LinearEvaluation_getConstant(self)

    def getLinear(self):
        r"""
        Accessor to the matrix.

        Returns
        -------
        linear : :class:`~openturns.Matrix`
            The matrix :math:`\mat{A}`.
        """
        return _func.LinearEvaluation_getLinear(self)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func.LinearEvaluation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.LinearEvaluation_isLinearlyDependent(self, index)

    def __init__(self, *args):
        _func.LinearEvaluation_swiginit(self, _func.new_LinearEvaluation(*args))
    __swig_destroy__ = _func.delete_LinearEvaluation

# Register LinearEvaluation in _func:
_func.LinearEvaluation_swigregister(LinearEvaluation)
class LinearGradient(GradientImplementation):
    r"""Linear numerical math gradient implementation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearGradient_getClassName(self)

    def __eq__(self, *args):
        return _func.LinearGradient___eq__(self, *args)

    def __repr__(self):
        return _func.LinearGradient___repr__(self)

    def __str__(self, *args):
        return _func.LinearGradient___str__(self, *args)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.LinearGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.LinearGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.LinearGradient_getOutputDimension(self)

    def getCenter(self):
        return _func.LinearGradient_getCenter(self)

    def getConstant(self):
        return _func.LinearGradient_getConstant(self)

    def getLinear(self):
        return _func.LinearGradient_getLinear(self)

    def __init__(self, *args):
        _func.LinearGradient_swiginit(self, _func.new_LinearGradient(*args))
    __swig_destroy__ = _func.delete_LinearGradient

# Register LinearGradient in _func:
_func.LinearGradient_swigregister(LinearGradient)
class QuadraticEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::QuadraticEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.QuadraticEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.QuadraticEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.QuadraticEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.QuadraticEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.QuadraticEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.QuadraticEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.QuadraticEvaluation_getOutputDimension(self)

    def getCenter(self):
        return _func.QuadraticEvaluation_getCenter(self)

    def getConstant(self):
        return _func.QuadraticEvaluation_getConstant(self)

    def getLinear(self):
        return _func.QuadraticEvaluation_getLinear(self)

    def getQuadratic(self):
        return _func.QuadraticEvaluation_getQuadratic(self)

    def __init__(self, *args):
        _func.QuadraticEvaluation_swiginit(self, _func.new_QuadraticEvaluation(*args))
    __swig_destroy__ = _func.delete_QuadraticEvaluation

# Register QuadraticEvaluation in _func:
_func.QuadraticEvaluation_swigregister(QuadraticEvaluation)
class ConstantGradient(GradientImplementation):
    r"""Proxy of C++ OT::ConstantGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ConstantGradient_getClassName(self)

    def __eq__(self, *args):
        return _func.ConstantGradient___eq__(self, *args)

    def __repr__(self):
        return _func.ConstantGradient___repr__(self)

    def __str__(self, *args):
        return _func.ConstantGradient___str__(self, *args)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ConstantGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ConstantGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ConstantGradient_getOutputDimension(self)

    def getConstant(self):
        return _func.ConstantGradient_getConstant(self)

    def __init__(self, *args):
        _func.ConstantGradient_swiginit(self, _func.new_ConstantGradient(*args))
    __swig_destroy__ = _func.delete_ConstantGradient

# Register ConstantGradient in _func:
_func.ConstantGradient_swigregister(ConstantGradient)
class ConstantHessian(HessianImplementation):
    r"""Proxy of C++ OT::ConstantHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ConstantHessian_getClassName(self)

    def __eq__(self, *args):
        return _func.ConstantHessian___eq__(self, *args)

    def __repr__(self):
        return _func.ConstantHessian___repr__(self)

    def __str__(self, *args):
        return _func.ConstantHessian___str__(self, *args)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ConstantHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ConstantHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ConstantHessian_getOutputDimension(self)

    def getConstant(self):
        return _func.ConstantHessian_getConstant(self)

    def __init__(self, *args):
        _func.ConstantHessian_swiginit(self, _func.new_ConstantHessian(*args))
    __swig_destroy__ = _func.delete_ConstantHessian

# Register ConstantHessian in _func:
_func.ConstantHessian_swigregister(ConstantHessian)
class ComposedEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::ComposedEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.ComposedEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.ComposedEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.ComposedEvaluation___str__(self, *args)

    def _repr_html_(self):
        return _func.ComposedEvaluation__repr_html_(self)

    def __call__(self, *args):
        return _func.ComposedEvaluation___call__(self, *args)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.ComposedEvaluation_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.ComposedEvaluation_setParameter(self, parameter)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.ComposedEvaluation_getParameterDescription(self)

    def setParameterDescription(self, description):
        r"""
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.ComposedEvaluation_setParameterDescription(self, description)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ComposedEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ComposedEvaluation_getOutputDimension(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.ComposedEvaluation_getMarginal(self, *args)

    def getLeftEvaluation(self):
        return _func.ComposedEvaluation_getLeftEvaluation(self)

    def getRightEvaluation(self):
        return _func.ComposedEvaluation_getRightEvaluation(self)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func.ComposedEvaluation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.ComposedEvaluation_isLinearlyDependent(self, index)

    def setStopCallback(self, callBack, state=None):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop an evaluation.

        Parameters
        ----------
        callback : callable
            Returns a bool deciding whether to stop or continue.

        """
        return _func.ComposedEvaluation_setStopCallback(self, callBack, state)

    def __init__(self, *args):
        _func.ComposedEvaluation_swiginit(self, _func.new_ComposedEvaluation(*args))
    __swig_destroy__ = _func.delete_ComposedEvaluation

# Register ComposedEvaluation in _func:
_func.ComposedEvaluation_swigregister(ComposedEvaluation)
class ComposedGradient(GradientImplementation):
    r"""Proxy of C++ OT::ComposedGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedGradient_getClassName(self)

    def __eq__(self, *args):
        return _func.ComposedGradient___eq__(self, *args)

    def __repr__(self):
        return _func.ComposedGradient___repr__(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ComposedGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ComposedGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ComposedGradient_getOutputDimension(self)

    def __init__(self, *args):
        _func.ComposedGradient_swiginit(self, _func.new_ComposedGradient(*args))
    __swig_destroy__ = _func.delete_ComposedGradient

# Register ComposedGradient in _func:
_func.ComposedGradient_swigregister(ComposedGradient)
class ComposedHessian(HessianImplementation):
    r"""Proxy of C++ OT::ComposedHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedHessian_getClassName(self)

    def __eq__(self, *args):
        return _func.ComposedHessian___eq__(self, *args)

    def __repr__(self):
        return _func.ComposedHessian___repr__(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ComposedHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ComposedHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ComposedHessian_getOutputDimension(self)

    def __init__(self, *args):
        _func.ComposedHessian_swiginit(self, _func.new_ComposedHessian(*args))
    __swig_destroy__ = _func.delete_ComposedHessian

# Register ComposedHessian in _func:
_func.ComposedHessian_swigregister(ComposedHessian)
class ProductEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::ProductEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.ProductEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.ProductEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.ProductEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.ProductEvaluation___call__(self, *args)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.ProductEvaluation_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.ProductEvaluation_setParameter(self, parameter)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.ProductEvaluation_getParameterDescription(self)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ProductEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ProductEvaluation_getOutputDimension(self)

    def __init__(self, *args):
        _func.ProductEvaluation_swiginit(self, _func.new_ProductEvaluation(*args))
    __swig_destroy__ = _func.delete_ProductEvaluation

# Register ProductEvaluation in _func:
_func.ProductEvaluation_swigregister(ProductEvaluation)
class ProductGradient(GradientImplementation):
    r"""Proxy of C++ OT::ProductGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductGradient_getClassName(self)

    def __eq__(self, *args):
        return _func.ProductGradient___eq__(self, *args)

    def __repr__(self):
        return _func.ProductGradient___repr__(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ProductGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ProductGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ProductGradient_getOutputDimension(self)

    def __init__(self, *args):
        _func.ProductGradient_swiginit(self, _func.new_ProductGradient(*args))
    __swig_destroy__ = _func.delete_ProductGradient

# Register ProductGradient in _func:
_func.ProductGradient_swigregister(ProductGradient)
class ProductHessian(HessianImplementation):
    r"""Proxy of C++ OT::ProductHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductHessian_getClassName(self)

    def __eq__(self, *args):
        return _func.ProductHessian___eq__(self, *args)

    def __repr__(self):
        return _func.ProductHessian___repr__(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ProductHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ProductHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ProductHessian_getOutputDimension(self)

    def __init__(self, *args):
        _func.ProductHessian_swiginit(self, _func.new_ProductHessian(*args))
    __swig_destroy__ = _func.delete_ProductHessian

# Register ProductHessian in _func:
_func.ProductHessian_swigregister(ProductHessian)
class _EvaluationImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_func._EvaluationImplementationPointer_ptr__get, _func._EvaluationImplementationPointer_ptr__set)

    def __init__(self, *args):
        _func._EvaluationImplementationPointer_swiginit(self, _func.new__EvaluationImplementationPointer(*args))
    __swig_destroy__ = _func.delete__EvaluationImplementationPointer

    def reset(self):
        return _func._EvaluationImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _func._EvaluationImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _func._EvaluationImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _func._EvaluationImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _func._EvaluationImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _func._EvaluationImplementationPointer_get(self)

    def getImplementation(self):
        return _func._EvaluationImplementationPointer_getImplementation(self)

    def unique(self):
        return _func._EvaluationImplementationPointer_unique(self)

    def use_count(self):
        return _func._EvaluationImplementationPointer_use_count(self)

    def swap(self, other):
        return _func._EvaluationImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func._EvaluationImplementationPointer_getClassName(self)

    def __eq__(self, *args):
        return _func._EvaluationImplementationPointer___eq__(self, *args)

    def __repr__(self):
        return _func._EvaluationImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _func._EvaluationImplementationPointer___str__(self, *args)

    def _repr_html_(self):
        return _func._EvaluationImplementationPointer__repr_html_(self)

    def setDescription(self, description):
        r"""
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func._EvaluationImplementationPointer_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        """
        return _func._EvaluationImplementationPointer_getDescription(self)

    def getInputDescription(self):
        r"""
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func._EvaluationImplementationPointer_getInputDescription(self)

    def setInputDescription(self, inputDescription):
        r"""
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.
        """
        return _func._EvaluationImplementationPointer_setInputDescription(self, inputDescription)

    def getOutputDescription(self):
        r"""
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func._EvaluationImplementationPointer_getOutputDescription(self)

    def setOutputDescription(self, outputDescription):
        r"""
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.
        """
        return _func._EvaluationImplementationPointer_setOutputDescription(self, outputDescription)

    def isActualImplementation(self):
        r"""
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func._EvaluationImplementationPointer_isActualImplementation(self)

    def __call__(self, *args):
        return _func._EvaluationImplementationPointer___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func._EvaluationImplementationPointer_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func._EvaluationImplementationPointer_getOutputDimension(self)

    def getParameterDimension(self):
        r"""
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func._EvaluationImplementationPointer_getParameterDimension(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func._EvaluationImplementationPointer_getMarginal(self, *args)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func._EvaluationImplementationPointer_parameterGradient(self, inP)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func._EvaluationImplementationPointer_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func._EvaluationImplementationPointer_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func._EvaluationImplementationPointer_getParameterDescription(self)

    def setParameterDescription(self, description):
        r"""
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func._EvaluationImplementationPointer_setParameterDescription(self, description)

    def getCallsNumber(self):
        r"""
        Accessor to the number of times the function has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func._EvaluationImplementationPointer_getCallsNumber(self)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func._EvaluationImplementationPointer_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func._EvaluationImplementationPointer_isLinearlyDependent(self, index)

    def setCheckOutput(self, checkOutput):
        r"""
        Accessor to the output verification flag.

        Parameters
        ----------
        check_output : bool
            Whether to check return values for nan or inf.
        """
        return _func._EvaluationImplementationPointer_setCheckOutput(self, checkOutput)

    def getCheckOutput(self):
        r"""
        Accessor to the output verification flag.

        Returns
        -------
        check_output : bool
            Whether to check return values for nan or inf.
        """
        return _func._EvaluationImplementationPointer_getCheckOutput(self)

    def draw(self, *args):
        r"""
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb, scale*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs, scale, isFilled*)

            draw(*xiMin, xiMax, ptNb, scale*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs, scale*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0`
            The number of points to draw the curves.
        ptNbs : sequence of int of dimension 2 :math:`ptNbs_k > 0, k=1,2`
            The number of points to draw the contour in the 2D case.
        scale : bool
            scale indicates whether the logarithmic scale is used either for one or both axes:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        isFilled : bool
            isFilled indicates whether the contour graph is filled or not

        Notes
        -----
        We note :math:`f: \Rset^n \rightarrow \Rset^p`
        where :math:`\vect{x} = (x_1, \dots, x_n)` and
        :math:`f(\vect{x}) = (f_1(\vect{x}), \dots,f_p(\vect{x}))`,
        with :math:`n\geq 1` and :math:`p\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \Rset^n \rightarrow \Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then it draws the graph:
        :math:`t\in [x_i^{min}, x_i^{max}] \mapsto f_k(CP_1, \dots, CP_{i-1}, t,  CP_{i+1} \dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then it draws the graph:
        :math:`(t,u) \in [x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}] \mapsto f_k(CP_1, \dots, CP_{i-1}, t, CP_{i+1}, \dots, CP_{j-1}, u,  CP_{j+1} \dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \Rset \rightarrow \Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \Rset^2 \rightarrow \Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction(['x'], ['sin(2*pi_*x)*exp(-x^2/2)'])
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func._EvaluationImplementationPointer_draw(self, *args)

    def drawCrossCuts(self, *args):
        r"""
        Draw the 2D and 1D cross cuts of a 1D output function as a :class:`~openturns.GridLayout`.

        Parameters
        ----------
        centralPoint : sequence of float
            Central point with dimension equal to the input dimension of the function.
        xMin, xMax : sequence of float
            Define the interval where the curve is plotted.
        pointNumber : sequence of int
            The number of points to draw the contours and the curves.
        withMonoDimensionalCuts : bool, optional
            withMonoDimensionalCuts indicates whether the mono dimension cuts are drawn or not
            Default value is specified in the `CrossCuts-DefaultWithMonoDimensionalCuts` ResourceMap key.
        isFilled : bool, optional
            isFilled indicates whether the contour graphs are filled or not
            Default value is specified in the `Contour-DefaultIsFilled` ResourceMap key
        vMin, vMax : float, optional
            Define the interval used to build the color map for the contours
            If not specified, these values are computed to best fit the graphs.
            Either specify both values or do not specify any.

        Notes
        -----
        We note :math:`f: \Rset^n \rightarrow \Rset^p`
        where :math:`\vect{x} = (x_1, \dots, x_n)` and
        :math:`f(\vect{x}) = (f_1(\vect{x}), \dots, f_p(\vect{x}))`,
        with :math:`n\geq 1` and :math:`p\geq 1`.

        In all usages, draw the 1D and 2D cross cuts of
        :math:`f_k: \Rset^n \rightarrow \Rset` as a function of all input coordinates for 1D cuts
        and all couples of coordinates for 2D cuts. Variable coordinates :math:`x_i` are sampled
        regularly using :math:`ptNb[i]` points in the interval :math:`[x_i^{min}, x_i^{max}]`,
        when all the other components of :math:`\vect{x}` are fixed to the corresponding components
        of the *centralPoint* :math:`\vect{c}`. In the first usage, vMin and vMax are evaluated as
        the min and max of all samples of the function value calculated in all cross cuts performed.

        - For 1D cross cuts:

        OpenTURNS draws the graph:

        .. math::
            y = f_k^{(i)}(s)

        for any :math:`s \in [x_i^{min}, x_i^{max}]` where :math:`f_k^{(i)}(s)` is defined by the equation:

        .. math::
            f_k^{(i)}(s) = f_k(c_1, \dots, c_{i-1}, s,  c_{i+1} \dots, c_n).

        - For 2D cross cuts:

        .. math::
            y = f_k^{(i,j)}(s, t)

        for any :math:`(s, t) \in [x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]` where :math:`f_k^{(i,j)}` 
        is defined by the equation:

        .. math::
            f_k^{(i,j)}(s,t) = f_k(c_1, \dots, c_{i-1}, s, c_{i+1}, \dots, c_{j-1}, t,  c_{j+1} \dots, c_n).

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction(['x0', 'x1', 'x2'], ['sin(1*pi_*x0) + x1 - x2 ^ 2'])
        >>> grid = f.drawCrossCuts([0., 0., 0.], [-3., -3, -3], [3, 3, 3], [100, 20, 20], True, True)
        >>> View(grid).show()
        """
        return _func._EvaluationImplementationPointer_drawCrossCuts(self, *args)

    def setStopCallback(self, callBack, state=None):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop an evaluation.

        Parameters
        ----------
        callback : callable
            Returns a bool deciding whether to stop or continue.

        """
        return _func._EvaluationImplementationPointer_setStopCallback(self, callBack, state)

    def __ne__(self, other):
        return _func._EvaluationImplementationPointer___ne__(self, other)

    def __repr_markdown__(self):
        return _func._EvaluationImplementationPointer___repr_markdown__(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func._EvaluationImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._EvaluationImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._EvaluationImplementationPointer_setName(self, name)

# Register _EvaluationImplementationPointer in _func:
_func._EvaluationImplementationPointer_swigregister(_EvaluationImplementationPointer)
class _GradientImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_func._GradientImplementationPointer_ptr__get, _func._GradientImplementationPointer_ptr__set)

    def __init__(self, *args):
        _func._GradientImplementationPointer_swiginit(self, _func.new__GradientImplementationPointer(*args))
    __swig_destroy__ = _func.delete__GradientImplementationPointer

    def reset(self):
        return _func._GradientImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _func._GradientImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _func._GradientImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _func._GradientImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _func._GradientImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _func._GradientImplementationPointer_get(self)

    def getImplementation(self):
        return _func._GradientImplementationPointer_getImplementation(self)

    def unique(self):
        return _func._GradientImplementationPointer_unique(self)

    def use_count(self):
        return _func._GradientImplementationPointer_use_count(self)

    def swap(self, other):
        return _func._GradientImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func._GradientImplementationPointer_getClassName(self)

    def __eq__(self, *args):
        return _func._GradientImplementationPointer___eq__(self, *args)

    def __repr__(self):
        return _func._GradientImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _func._GradientImplementationPointer___str__(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : int
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.GradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func._GradientImplementationPointer_getMarginal(self, *args)

    def isActualImplementation(self):
        r"""
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func._GradientImplementationPointer_isActualImplementation(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func._GradientImplementationPointer_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func._GradientImplementationPointer_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func._GradientImplementationPointer_getOutputDimension(self)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func._GradientImplementationPointer_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func._GradientImplementationPointer_setParameter(self, parameter)

    def getCallsNumber(self):
        r"""
        Accessor to the number of times the gradient has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the gradient has been called
            since its creation.
        """
        return _func._GradientImplementationPointer_getCallsNumber(self)

    def __ne__(self, other):
        return _func._GradientImplementationPointer___ne__(self, other)

    def __repr_markdown__(self):
        return _func._GradientImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _func._GradientImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func._GradientImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._GradientImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._GradientImplementationPointer_setName(self, name)

# Register _GradientImplementationPointer in _func:
_func._GradientImplementationPointer_swigregister(_GradientImplementationPointer)
class _HessianImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_func._HessianImplementationPointer_ptr__get, _func._HessianImplementationPointer_ptr__set)

    def __init__(self, *args):
        _func._HessianImplementationPointer_swiginit(self, _func.new__HessianImplementationPointer(*args))
    __swig_destroy__ = _func.delete__HessianImplementationPointer

    def reset(self):
        return _func._HessianImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _func._HessianImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _func._HessianImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _func._HessianImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _func._HessianImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _func._HessianImplementationPointer_get(self)

    def getImplementation(self):
        return _func._HessianImplementationPointer_getImplementation(self)

    def unique(self):
        return _func._HessianImplementationPointer_unique(self)

    def use_count(self):
        return _func._HessianImplementationPointer_use_count(self)

    def swap(self, other):
        return _func._HessianImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func._HessianImplementationPointer_getClassName(self)

    def __eq__(self, *args):
        return _func._HessianImplementationPointer___eq__(self, *args)

    def __repr__(self):
        return _func._HessianImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _func._HessianImplementationPointer___str__(self, *args)

    def isActualImplementation(self):
        r"""
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func._HessianImplementationPointer_isActualImplementation(self)

    def getMarginal(self, *args):
        r"""
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : int
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.HessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func._HessianImplementationPointer_getMarginal(self, *args)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func._HessianImplementationPointer_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func._HessianImplementationPointer_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func._HessianImplementationPointer_getOutputDimension(self)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func._HessianImplementationPointer_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func._HessianImplementationPointer_setParameter(self, parameter)

    def getCallsNumber(self):
        r"""
        Accessor to the number of times the hessian has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the hessian has been called
            since its creation.
        """
        return _func._HessianImplementationPointer_getCallsNumber(self)

    def __ne__(self, other):
        return _func._HessianImplementationPointer___ne__(self, other)

    def __repr_markdown__(self):
        return _func._HessianImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _func._HessianImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func._HessianImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._HessianImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._HessianImplementationPointer_setName(self, name)

# Register _HessianImplementationPointer in _func:
_func._HessianImplementationPointer_swigregister(_HessianImplementationPointer)
class FunctionImplementation(openturns.common.PersistentObject):
    r"""
    Function base class.

    Notes
    -----
    A function acts on points to produce points: :math:`f: \Rset^d \rightarrow \Rset^{d'}`.

    A function enables to evaluate its gradient and its hessian when mathematically defined.


    Examples
    --------
    Create a *Function* from a list of analytical formulas and
    descriptions of the input vector and the output vector :

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x0', 'x1'],
    ...                         ['x0 + x1', 'x0 - x1'])
    >>> print(f([1, 2]))
    [3,-1]


    Create a *Function* from strings:

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction('x', '2.0*sqrt(x)')
    >>> print(f(([16],[4])))
        [ y0 ]
    0 : [ 8  ]
    1 : [ 4  ]


    Create a *Function* from a Python function:

    >>> def a_function(X):
    ...     return [X[0] + X[1]]
    >>> f = ot.PythonFunction(2, 1, a_function)
    >>> print(f(((10, 5),(6, 7))))
        [ y0 ]
    0 : [ 15 ]
    1 : [ 13 ]


    See :class:`~openturns.PythonFunction` for further details.

    Create a *Function* from a Python class:

    >>> class FUNC(ot.OpenTURNSPythonFunction):
    ...     def __init__(self):
    ...         super(FUNC, self).__init__(2, 1)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T'])
    ...     def _exec(self, X):
    ...         Y = [X[0] + X[1]]
    ...         return Y
    >>> F = FUNC()
    >>> func = ot.Function(F)
    >>> print(func((1.0, 2.0)))
    [3]


    See :class:`~openturns.PythonFunction` for further details.

    Create a *Function* from another *Function*:

    >>> f = ot.SymbolicFunction(ot.Description.BuildDefault(4, 'x'),
    ...                         ['x0', 'x0 + x1', 'x0 + x2 + x3'])

    Then create another function by setting x1=4 and x3=10:

    >>> g = ot.ParametricFunction(f, [3, 1], [10.0, 4.0], True)
    >>> print(g.getInputDescription())
    [x0,x2]
    >>> print(g((1, 2)))
    [1,5,13]

    Or by setting x0=6 and x2=5:

    >>> g = ot.ParametricFunction(f, [3, 1], [6.0, 5.0], False)
    >>> print(g.getInputDescription())
    [x3,x1]
    >>> print(g((1, 2)))
    [6,8,12]


    Create a *Function* from another *Function*
    and by using a comparison operator:

    >>> analytical = ot.SymbolicFunction(['x0','x1'], ['x0 + x1'])
    >>> indicator = ot.IndicatorFunction(ot.LevelSet(analytical, ot.Less(), 0.0))
    >>> print(indicator([2, 3]))
    [0]
    >>> print(indicator([2, -3]))
    [1]

    Create a *Function* from a collection of functions:

    >>> functions = list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1^2 + x2', 'x1 + x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1 + 2 * x2 + x3', 'x1 + x2 - x3']))
    >>> function = ot.AggregatedFunction(functions)
    >>> print(function([1.0, 2.0, 3.0]))
    [3,6,8,0]

    Create a *Function* which is the linear combination *linComb*
    of the functions defined in  *functionCollection* with scalar weights
    defined in *scalarCoefficientColl*:

    :math:`functionCollection  = (f_1, \hdots, f_N)`
    where :math:`\forall 1 \leq i \leq N, \,     f_i: \Rset^n \rightarrow \Rset^{p}`
    and :math:`scalarCoefficientColl = (c_1, \hdots, c_N) \in \Rset^N`
    then the linear combination is:

    .. math::

        linComb: \left|\begin{array}{rcl}
                      \Rset^n & \rightarrow & \Rset^{p} \\
                      \vect{X} & \mapsto & \displaystyle \sum_i c_if_i (\vect{X})
                  \end{array}\right.

    >>> function2 = ot.LinearCombinationFunction(functions, [2.0, 4.0])
    >>> print(function2([1.0, 2.0, 3.0]))
    [38,12]


    Create a *Function* which is the linear combination
    *vectLinComb* of the scalar functions defined in
    *scalarFunctionCollection* with vectorial weights defined in
    *vectorCoefficientColl*:

    If :math:`scalarFunctionCollection = (f_1, \hdots, f_N)`
    where :math:`\forall 1 \leq i \leq N, \,    f_i: \Rset^n \rightarrow \Rset`
    and :math:`vectorCoefficientColl = (\vect{c}_1, \hdots, \vect{c}_N)`
    where :math:`\forall 1 \leq i \leq N, \,   \vect{c}_i \in \Rset^p`

    .. math::

        vectLinComb: \left|\begin{array}{rcl}
                         \Rset^n & \rightarrow & \Rset^{p} \\
                         \vect{X} & \mapsto & \displaystyle \sum_i \vect{c}_if_i (\vect{X})
                     \end{array}\right.

    >>> functions=list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1 + 2 * x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1^2 + x2']))
    >>> function2 = ot.DualLinearCombinationFunction(functions, [[2., 4.], [3., 1.]])
    >>> print(function2([1, 2, 3]))
    [25,35]

    If the input and output dimensions of two functions are equal
    then we can perform arithmetic operations on these functions
    using the `+`, `-` and `*` operators.

    >>> g1 = ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                          ['x1 + 2 * x2 + x3'])
    >>> g2 = ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                          ['x1^2 + x2'])
    >>> g_sum = g1 + g2
    >>> g_difference = g1 - g2
    >>> g_product = g1 * g2

    Create a *Function* from values of the inputs and the outputs:

    >>> inputSample = [[1.0, 1.0], [2.0, 2.0]]
    >>> outputSample = [[4.0], [5.0]]
    >>> database = ot.DatabaseFunction(inputSample, outputSample)
    >>> x = [1.8]*database.getInputDimension()
    >>> print(database(x))
    [5]


    Create a *Function* which is the composition function
    :math:`f\circ g`:

    >>> g = ot.SymbolicFunction(['x1', 'x2'],
    ...                         ['x1 + x2','3 * x1 * x2'])
    >>> f = ot.SymbolicFunction(['x1', 'x2'], ['2 * x1 - x2'])
    >>> composed = ot.ComposedFunction(f, g)
    >>> print(composed([3, 4]))
    [-22]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FunctionImplementation_getClassName(self)

    def __mul__(self, *args):
        return _func.FunctionImplementation___mul__(self, *args)

    def __eq__(self, *args):
        return _func.FunctionImplementation___eq__(self, *args)

    def __repr__(self):
        return _func.FunctionImplementation___repr__(self)

    def __str__(self, *args):
        return _func.FunctionImplementation___str__(self, *args)

    def _repr_html_(self):
        return _func.FunctionImplementation__repr_html_(self)

    def setEvaluation(self, evaluation):
        r"""
        Accessor to the evaluation function.

        Parameters
        ----------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.
        """
        return _func.FunctionImplementation_setEvaluation(self, evaluation)

    def getEvaluation(self):
        r"""
        Accessor to the evaluation function.

        Returns
        -------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getEvaluation())
        [x1,x2]->[2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6]
        """
        return _func.FunctionImplementation_getEvaluation(self)

    def setGradient(self, gradient):
        r"""
        Accessor to the gradient function.

        Parameters
        ----------
        gradient_function : :class:`~openturns.GradientImplementation`
            The gradient function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setGradient(ot.CenteredFiniteDifferenceGradient(
        ...  ot.ResourceMap.GetAsScalar('CenteredFiniteDifferenceGradient-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.FunctionImplementation_setGradient(self, gradient)

    def getGradient(self):
        r"""
        Accessor to the gradient function.

        Returns
        -------
        gradient : :class:`~openturns.GradientImplementation`
            The gradient function.
        """
        return _func.FunctionImplementation_getGradient(self)

    def setHessian(self, hessian):
        r"""
        Accessor to the hessian function.

        Parameters
        ----------
        hessian_function : :class:`~openturns.HessianImplementation`
            The hessian function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setHessian(ot.CenteredFiniteDifferenceHessian(
        ...  ot.ResourceMap.GetAsScalar('CenteredFiniteDifferenceHessian-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.FunctionImplementation_setHessian(self, hessian)

    def getHessian(self):
        r"""
        Accessor to the hessian function.

        Returns
        -------
        hessian : :class:`~openturns.HessianImplementation`
            The hessian function.
        """
        return _func.FunctionImplementation_getHessian(self)

    def __call__(self, *args):
        return _func.FunctionImplementation___call__(self, *args)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.gradient([3.14, 4]))
        [[ 13.5345   1       ]
         [  4.00001  1       ]]
        """
        return _func.FunctionImplementation_gradient(self, inP)

    def hessian(self, inP):
        r"""
        Return the hessian of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the hessian of the function is calculated.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.hessian([3.14, 4]))
        sheet #0
        [[ 20          -0.00637061 ]
         [ -0.00637061  0          ]]
        sheet #1
        [[  0           0          ]
         [  0           0          ]]
        """
        return _func.FunctionImplementation_hessian(self, inP)

    def parameterGradient(self, inP):
        r"""
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.FunctionImplementation_parameterGradient(self, inP)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.FunctionImplementation_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.FunctionImplementation_setParameter(self, parameter)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.FunctionImplementation_getParameterDescription(self)

    def setParameterDescription(self, description):
        r"""
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.FunctionImplementation_setParameterDescription(self, description)

    def getParameterDimension(self):
        r"""
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameterDimension : int
            Dimension of the parameter.
        """
        return _func.FunctionImplementation_getParameterDimension(self)

    def getInputDimension(self):
        r"""
        Accessor to the dimension of the input vector.

        Returns
        -------
        inputDim : int
            Dimension of the input vector :math:`d`.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.FunctionImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Dimension of the output vector :math:`d'`.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.FunctionImplementation_getOutputDimension(self)

    def setDescription(self, description):
        r"""
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.FunctionImplementation_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        """
        return _func.FunctionImplementation_getDescription(self)

    def setInputDescription(self, inputDescription):
        r"""
        Accessor to the description of the input vector.

        Parameters
        ----------
        description : :class:`~openturns.Description`
            Description of the input vector.
        """
        return _func.FunctionImplementation_setInputDescription(self, inputDescription)

    def getInputDescription(self):
        r"""
        Accessor to the description of the input vector.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the input vector.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.FunctionImplementation_getInputDescription(self)

    def setOutputDescription(self, outputDescription):
        r"""
        Accessor to the description of the output vector.

        Parameters
        ----------
        description : :class:`~openturns.Description`
            Description of the output vector.
        """
        return _func.FunctionImplementation_setOutputDescription(self, outputDescription)

    def getOutputDescription(self):
        r"""
        Accessor to the description of the output vector.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the output vector.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func.FunctionImplementation_getOutputDescription(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.FunctionImplementation_getMarginal(self, *args)

    def getCallsNumber(self):
        r"""
        Accessor to the number of direct calls to the function.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            directly through the `()` operator.
        """
        return _func.FunctionImplementation_getCallsNumber(self)

    def getEvaluationCallsNumber(self):
        r"""
        Accessor to the number of times the evaluation of the function has been called.

        Returns
        -------
        evaluation_calls_number : int
            Integer that counts the number of times the evaluation of the function
            has been called since its creation.
            This may include indirect calls via finite-difference gradient or Hessian.
        """
        return _func.FunctionImplementation_getEvaluationCallsNumber(self)

    def getGradientCallsNumber(self):
        r"""
        Accessor to the number of times the gradient of the function has been called.

        Returns
        -------
        gradient_calls_number : int
            Integer that counts the number of times the gradient of the
            Function has been called since its creation.
            Note that if the gradient is implemented by a finite difference method,
            the gradient calls number is equal to 0 and the different calls are
            counted in the evaluation calls number.
        """
        return _func.FunctionImplementation_getGradientCallsNumber(self)

    def getHessianCallsNumber(self):
        r"""
        Accessor to the number of times the hessian of the function has been called.

        Returns
        -------
        hessian_calls_number : int
            Integer that counts the number of times the hessian of the
            Function has been called since its creation.
            Note that if the hessian is implemented by a finite difference method,
            the hessian calls number is equal to 0 and the different calls are counted
            in the evaluation calls number.
        """
        return _func.FunctionImplementation_getHessianCallsNumber(self)

    def isLinear(self):
        r"""
        Accessor to the linearity of the function.

        Returns
        -------
        linear : bool
            *True* if the function is linear, *False* otherwise.
        """
        return _func.FunctionImplementation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the function with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the function is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.FunctionImplementation_isLinearlyDependent(self, index)

    def draw(self, *args):
        r"""
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, centralPoint, xiMin, xiMax, ptNb, scale*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, centralPoint, xiMin_xjMin, xiMax_xjMax, ptNbs, scale, isFilled*)

            draw(*xiMin, xiMax, ptNb, scale*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs, scale*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        centralPoint : sequence of float
            Central point with dimension equal to the input dimension of the function.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0`
            The number of points to draw the curves.
        ptNbs : list of int of dimension 2 :math:`ptNbs_k > 0, k=1,2`
            The number of points to draw the contour in the 2D case.
        scale : bool
            scale indicates whether the logarithmic scale is used either for one or both axes:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        isFilled : bool
            isFilled indicates whether the contour graph is filled or not

        Notes
        -----
        We note :math:`f: \Rset^n \rightarrow \Rset^p`
        where :math:`\vect{x} = (x_1, \dots, x_n)` and
        :math:`f(\vect{x}) = (f_1(\vect{x}), \dots, f_p(\vect{x}))`,
        with :math:`n\geq 1` and :math:`p\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \Rset^n \rightarrow \Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\vect{x}` are fixed to the corresponding components of the *centralPoint* :math:`\vect{c}`.
        Then OpenTURNS draws the graph:

        .. math::
            y = f_k^{(i)}(s)

        for any :math:`s \in [x_i^{min}, x_i^{max}]` where :math:`f_k^{(i)}(s)` is defined by the equation:

        .. math::
            f_k^{(i)}(s) = f_k(c_1, \dots, c_{i-1}, s,  c_{i+1} \dots, c_n).

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\vect{x}` are fixed to the corresponding components of the
        *centralPoint* :math:`\vect{c}`.
        Then OpenTURNS draws the graph:

        .. math::
            y = f_k^{(i,j)}(s, t)

        for any :math:`(s, t) \in [x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]` where :math:`f_k^{(i,j)}` 
        is defined by the equation:

        .. math::
            f_k^{(i,j)}(s,t) = f_k(c_1, \dots, c_{i-1}, s, c_{i+1}, \dots, c_{j-1}, t,  c_{j+1} \dots, c_n).

        - In the third usage:

        The same as the first usage but only for function :math:`f: \Rset \rightarrow \Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \Rset^2 \rightarrow \Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction('x', 'sin(2*pi_*x)*exp(-x^2/2)')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.FunctionImplementation_draw(self, *args)

    def drawCrossCuts(self, *args):
        r"""
        Draw the 2D and 1D cross cuts of a 1D output function as a :class:`~openturns.GridLayout`.

        Parameters
        ----------
        centralPoint : list of float
            Central point with dimension equal to the input dimension of the function.
        xMin, xMax : list of float
            Define the interval where the curve is plotted.
        pointNumber : :class:`~openturns.Indices`
            The number of points to draw the contours and the curves.
        withMonoDimensionalCuts : bool, optional
            withMonoDimensionalCuts indicates whether the mono dimension cuts are drawn or not
            Default value is specified in the `CrossCuts-DefaultWithMonoDimensionalCuts` ResourceMap key.
        isFilled : bool, optional
            isFilled indicates whether the contour graphs are filled or not
            Default value is specified in the `Contour-DefaultIsFilled` ResourceMap key
        vMin, vMax : float, optional
            Define the interval used to build the color map for the contours
            If not specified, these values are computed to best fit the graphs.
            Either specify both values or do not specify any.

        Notes
        -----
        We note :math:`f: \Rset^n \rightarrow \Rset^p`
        where :math:`\vect{x} = (x_1, \dots, x_n)` and
        :math:`f(\vect{x}) = (f_1(\vect{x}), \dots, f_p(\vect{x}))`,
        with :math:`n\geq 1` and :math:`p\geq 1`.

        In all usages, draw the 1D and 2D cross cuts of
        :math:`f_k: \Rset^n \rightarrow \Rset` as a function of all input coordinates for 1D cuts
        and all couples of coordinates for 2D cuts. Variable coordinates :math:`x_i` are sampled
        regularly using :math:`ptNb[i]` points in the interval :math:`[x_i^{min}, x_i^{max}]`,
        when all the other components of :math:`\vect{x}` are fixed to the corresponding components
        of the *centralPoint* :math:`\vect{c}`. In the first usage, vMin and vMax are evaluated as
        the min and max of all samples of the function value calculated in all cross cuts performed.

        For 1D cross cuts the graph shows:

        .. math::
            y = f_k^{(i)}(s)

        for any :math:`s \in [x_i^{min}, x_i^{max}]` where :math:`f_k^{(i)}(s)` is defined by the equation:

        .. math::
            f_k^{(i)}(s) = f_k(c_1, \dots, c_{i-1}, s,  c_{i+1} \dots, c_n).

        - For 2D cross cuts:

        .. math::
            y = f_k^{(i,j)}(s, t)

        for any :math:`(s, t) \in [x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]` where :math:`f_k^{(i,j)}` 
        is defined by the equation:

        .. math::
            f_k^{(i,j)}(s,t) = f_k(c_1, \dots, c_{i-1}, s, c_{i+1}, \dots, c_{j-1}, t,  c_{j+1} \dots, c_n).

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction(['x0', 'x1', 'x2'], ['sin(1*pi_*x0) + x1 - x2 ^ 2'])
        >>> grid = f.drawCrossCuts([0., 0., 0.], [-3., -3, -3], [3, 3, 3], [100, 20, 20], True, True)
        >>> View(grid).show()
        """
        return _func.FunctionImplementation_drawCrossCuts(self, *args)

    def setStopCallback(self, callBack, state=None):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop an evaluation.

        Parameters
        ----------
        callback : callable
            Returns a bool deciding whether to stop or continue.

        """
        return _func.FunctionImplementation_setStopCallback(self, callBack, state)

    def __init__(self, *args):
        _func.FunctionImplementation_swiginit(self, _func.new_FunctionImplementation(*args))
    __swig_destroy__ = _func.delete_FunctionImplementation

# Register FunctionImplementation in _func:
_func.FunctionImplementation_swigregister(FunctionImplementation)
class ProductFunction(FunctionImplementation):
    r"""
    Product function.

    The function is the product function :math:`f\times g`.

    Parameters
    ----------
    f,g : two :class:`~openturns.FunctionImplementation`
        The functions to multiply.

    Examples
    --------
    >>> import openturns as ot
    >>> g = ot.SymbolicFunction(['x1', 'x2'], ['x1'])
    >>> f = ot.SymbolicFunction(['x1', 'x2'], ['x2'])
    >>> product = f * g
    >>> print(product([3, 4]))
    [12]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.ProductFunction___eq__(self, *args)

    def __repr__(self):
        return _func.ProductFunction___repr__(self)

    def __str__(self, *args):
        return _func.ProductFunction___str__(self, *args)

    def parameterGradient(self, inP):
        r"""
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.ProductFunction_parameterGradient(self, inP)

    def __init__(self, *args):
        _func.ProductFunction_swiginit(self, _func.new_ProductFunction(*args))
    __swig_destroy__ = _func.delete_ProductFunction

# Register ProductFunction in _func:
_func.ProductFunction_swigregister(ProductFunction)
class _FunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._FunctionImplementationTypedInterfaceObject_swiginit(self, _func.new__FunctionImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._FunctionImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._FunctionImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._FunctionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._FunctionImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._FunctionImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__FunctionImplementationTypedInterfaceObject

# Register _FunctionImplementationTypedInterfaceObject in _func:
_func._FunctionImplementationTypedInterfaceObject_swigregister(_FunctionImplementationTypedInterfaceObject)
class FunctionCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _func.delete_FunctionCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _func.FunctionCollection_clear(self)

    def __len__(self):
        return _func.FunctionCollection___len__(self)

    def __eq__(self, rhs):
        return _func.FunctionCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _func.FunctionCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _func.FunctionCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _func.FunctionCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _func.FunctionCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _func.FunctionCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.FunctionCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.FunctionCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.FunctionCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.FunctionCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.FunctionCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _func.FunctionCollection_find(self, val)

    def __repr__(self):
        return _func.FunctionCollection___repr__(self)

    def __str__(self, *args):
        return _func.FunctionCollection___str__(self, *args)

    def __init__(self, *args):
        _func.FunctionCollection_swiginit(self, _func.new_FunctionCollection(*args))

# Register FunctionCollection in _func:
_func.FunctionCollection_swigregister(FunctionCollection)
class _FunctionPersistentCollection(openturns.common.PersistentObject, FunctionCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func._FunctionPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _func._FunctionPersistentCollection_swiginit(self, _func.new__FunctionPersistentCollection(*args))

    def __repr__(self):
        return _func._FunctionPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _func._FunctionPersistentCollection___str__(self, *args)
    __swig_destroy__ = _func.delete__FunctionPersistentCollection

# Register _FunctionPersistentCollection in _func:
_func._FunctionPersistentCollection_swigregister(_FunctionPersistentCollection)
class Function(_FunctionImplementationTypedInterfaceObject):
    r"""
    Function base class.

    Notes
    -----
    A function acts on points to produce points: :math:`f: \Rset^d \rightarrow \Rset^{d'}`.

    A function enables to evaluate its gradient and its hessian when mathematically defined.


    Examples
    --------
    Create a *Function* from a list of analytical formulas and
    descriptions of the input vector and the output vector :

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x0', 'x1'],
    ...                         ['x0 + x1', 'x0 - x1'])
    >>> print(f([1, 2]))
    [3,-1]


    Create a *Function* from strings:

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction('x', '2.0*sqrt(x)')
    >>> print(f(([16],[4])))
        [ y0 ]
    0 : [ 8  ]
    1 : [ 4  ]


    Create a *Function* from a Python function:

    >>> def a_function(X):
    ...     return [X[0] + X[1]]
    >>> f = ot.PythonFunction(2, 1, a_function)
    >>> print(f(((10, 5),(6, 7))))
        [ y0 ]
    0 : [ 15 ]
    1 : [ 13 ]


    See :class:`~openturns.PythonFunction` for further details.

    Create a *Function* from a Python class:

    >>> class FUNC(ot.OpenTURNSPythonFunction):
    ...     def __init__(self):
    ...         super(FUNC, self).__init__(2, 1)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T'])
    ...     def _exec(self, X):
    ...         Y = [X[0] + X[1]]
    ...         return Y
    >>> F = FUNC()
    >>> func = ot.Function(F)
    >>> print(func((1.0, 2.0)))
    [3]


    See :class:`~openturns.PythonFunction` for further details.

    Create a *Function* from another *Function*:

    >>> f = ot.SymbolicFunction(ot.Description.BuildDefault(4, 'x'),
    ...                         ['x0', 'x0 + x1', 'x0 + x2 + x3'])

    Then create another function by setting x1=4 and x3=10:

    >>> g = ot.ParametricFunction(f, [3, 1], [10.0, 4.0], True)
    >>> print(g.getInputDescription())
    [x0,x2]
    >>> print(g((1, 2)))
    [1,5,13]

    Or by setting x0=6 and x2=5:

    >>> g = ot.ParametricFunction(f, [3, 1], [6.0, 5.0], False)
    >>> print(g.getInputDescription())
    [x3,x1]
    >>> print(g((1, 2)))
    [6,8,12]


    Create a *Function* from another *Function*
    and by using a comparison operator:

    >>> analytical = ot.SymbolicFunction(['x0','x1'], ['x0 + x1'])
    >>> indicator = ot.IndicatorFunction(ot.LevelSet(analytical, ot.Less(), 0.0))
    >>> print(indicator([2, 3]))
    [0]
    >>> print(indicator([2, -3]))
    [1]

    Create a *Function* from a collection of functions:

    >>> functions = list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1^2 + x2', 'x1 + x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1 + 2 * x2 + x3', 'x1 + x2 - x3']))
    >>> function = ot.AggregatedFunction(functions)
    >>> print(function([1.0, 2.0, 3.0]))
    [3,6,8,0]

    Create a *Function* which is the linear combination *linComb*
    of the functions defined in  *functionCollection* with scalar weights
    defined in *scalarCoefficientColl*:

    :math:`functionCollection  = (f_1, \hdots, f_N)`
    where :math:`\forall 1 \leq i \leq N, \,     f_i: \Rset^n \rightarrow \Rset^{p}`
    and :math:`scalarCoefficientColl = (c_1, \hdots, c_N) \in \Rset^N`
    then the linear combination is:

    .. math::

        linComb: \left|\begin{array}{rcl}
                      \Rset^n & \rightarrow & \Rset^{p} \\
                      \vect{X} & \mapsto & \displaystyle \sum_i c_if_i (\vect{X})
                  \end{array}\right.

    >>> function2 = ot.LinearCombinationFunction(functions, [2.0, 4.0])
    >>> print(function2([1.0, 2.0, 3.0]))
    [38,12]


    Create a *Function* which is the linear combination
    *vectLinComb* of the scalar functions defined in
    *scalarFunctionCollection* with vectorial weights defined in
    *vectorCoefficientColl*:

    If :math:`scalarFunctionCollection = (f_1, \hdots, f_N)`
    where :math:`\forall 1 \leq i \leq N, \,    f_i: \Rset^n \rightarrow \Rset`
    and :math:`vectorCoefficientColl = (\vect{c}_1, \hdots, \vect{c}_N)`
    where :math:`\forall 1 \leq i \leq N, \,   \vect{c}_i \in \Rset^p`

    .. math::

        vectLinComb: \left|\begin{array}{rcl}
                         \Rset^n & \rightarrow & \Rset^{p} \\
                         \vect{X} & \mapsto & \displaystyle \sum_i \vect{c}_if_i (\vect{X})
                     \end{array}\right.

    >>> functions=list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1 + 2 * x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1^2 + x2']))
    >>> function2 = ot.DualLinearCombinationFunction(functions, [[2., 4.], [3., 1.]])
    >>> print(function2([1, 2, 3]))
    [25,35]

    If the input and output dimensions of two functions are equal
    then we can perform arithmetic operations on these functions
    using the `+`, `-` and `*` operators.

    >>> g1 = ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                          ['x1 + 2 * x2 + x3'])
    >>> g2 = ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                          ['x1^2 + x2'])
    >>> g_sum = g1 + g2
    >>> g_difference = g1 - g2
    >>> g_product = g1 * g2

    Create a *Function* from values of the inputs and the outputs:

    >>> inputSample = [[1.0, 1.0], [2.0, 2.0]]
    >>> outputSample = [[4.0], [5.0]]
    >>> database = ot.DatabaseFunction(inputSample, outputSample)
    >>> x = [1.8]*database.getInputDimension()
    >>> print(database(x))
    [5]


    Create a *Function* which is the composition function
    :math:`f\circ g`:

    >>> g = ot.SymbolicFunction(['x1', 'x2'],
    ...                         ['x1 + x2','3 * x1 * x2'])
    >>> f = ot.SymbolicFunction(['x1', 'x2'], ['2 * x1 - x2'])
    >>> composed = ot.ComposedFunction(f, g)
    >>> print(composed([3, 4]))
    [-22]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Function_getClassName(self)

    def __eq__(self, *args):
        return _func.Function___eq__(self, *args)

    def __repr__(self):
        return _func.Function___repr__(self)

    def __str__(self, *args):
        return _func.Function___str__(self, *args)

    def _repr_html_(self):
        return _func.Function__repr_html_(self)

    def setEvaluation(self, evaluation):
        r"""
        Accessor to the evaluation function.

        Parameters
        ----------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.
        """
        return _func.Function_setEvaluation(self, evaluation)

    def getEvaluation(self):
        r"""
        Accessor to the evaluation function.

        Returns
        -------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getEvaluation())
        [x1,x2]->[2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6]
        """
        return _func.Function_getEvaluation(self)

    def setGradient(self, gradient):
        r"""
        Accessor to the gradient function.

        Parameters
        ----------
        gradient_function : :class:`~openturns.GradientImplementation`
            The gradient function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setGradient(ot.CenteredFiniteDifferenceGradient(
        ...  ot.ResourceMap.GetAsScalar('CenteredFiniteDifferenceGradient-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.Function_setGradient(self, gradient)

    def getGradient(self):
        r"""
        Accessor to the gradient function.

        Returns
        -------
        gradient : :class:`~openturns.GradientImplementation`
            The gradient function.
        """
        return _func.Function_getGradient(self)

    def setHessian(self, hessian):
        r"""
        Accessor to the hessian function.

        Parameters
        ----------
        hessian_function : :class:`~openturns.HessianImplementation`
            The hessian function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setHessian(ot.CenteredFiniteDifferenceHessian(
        ...  ot.ResourceMap.GetAsScalar('CenteredFiniteDifferenceHessian-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.Function_setHessian(self, hessian)

    def getHessian(self):
        r"""
        Accessor to the hessian function.

        Returns
        -------
        hessian : :class:`~openturns.HessianImplementation`
            The hessian function.
        """
        return _func.Function_getHessian(self)

    def __mul__(self, right):
        return _func.Function___mul__(self, right)

    def __add__(self, right):
        return _func.Function___add__(self, right)

    def __sub__(self, right):
        return _func.Function___sub__(self, right)

    def __call__(self, *args):
        return _func.Function___call__(self, *args)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.gradient([3.14, 4]))
        [[ 13.5345   1       ]
         [  4.00001  1       ]]
        """
        return _func.Function_gradient(self, inP)

    def hessian(self, inP):
        r"""
        Return the hessian of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the hessian of the function is calculated.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.hessian([3.14, 4]))
        sheet #0
        [[ 20          -0.00637061 ]
         [ -0.00637061  0          ]]
        sheet #1
        [[  0           0          ]
         [  0           0          ]]
        """
        return _func.Function_hessian(self, inP)

    def parameterGradient(self, inP):
        r"""
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.Function_parameterGradient(self, inP)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.Function_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.Function_setParameter(self, parameter)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.Function_getParameterDescription(self)

    def setParameterDescription(self, description):
        r"""
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.Function_setParameterDescription(self, description)

    def getParameterDimension(self):
        r"""
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameterDimension : int
            Dimension of the parameter.
        """
        return _func.Function_getParameterDimension(self)

    def getInputDimension(self):
        r"""
        Accessor to the dimension of the input vector.

        Returns
        -------
        inputDim : int
            Dimension of the input vector :math:`d`.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.Function_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Dimension of the output vector :math:`d'`.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.Function_getOutputDimension(self)

    def setDescription(self, description):
        r"""
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.Function_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        """
        return _func.Function_getDescription(self)

    def setInputDescription(self, inputDescription):
        r"""
        Accessor to the description of the input vector.

        Parameters
        ----------
        description : :class:`~openturns.Description`
            Description of the input vector.
        """
        return _func.Function_setInputDescription(self, inputDescription)

    def getInputDescription(self):
        r"""
        Accessor to the description of the input vector.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the input vector.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.Function_getInputDescription(self)

    def setOutputDescription(self, inputDescription):
        r"""
        Accessor to the description of the output vector.

        Parameters
        ----------
        description : :class:`~openturns.Description`
            Description of the output vector.
        """
        return _func.Function_setOutputDescription(self, inputDescription)

    def getOutputDescription(self):
        r"""
        Accessor to the description of the output vector.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the output vector.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func.Function_getOutputDescription(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.Function_getMarginal(self, *args)

    def getCallsNumber(self):
        r"""
        Accessor to the number of direct calls to the function.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            directly through the `()` operator.
        """
        return _func.Function_getCallsNumber(self)

    def getEvaluationCallsNumber(self):
        r"""
        Accessor to the number of times the evaluation of the function has been called.

        Returns
        -------
        evaluation_calls_number : int
            Integer that counts the number of times the evaluation of the function
            has been called since its creation.
            This may include indirect calls via finite-difference gradient or Hessian.
        """
        return _func.Function_getEvaluationCallsNumber(self)

    def getGradientCallsNumber(self):
        r"""
        Accessor to the number of times the gradient of the function has been called.

        Returns
        -------
        gradient_calls_number : int
            Integer that counts the number of times the gradient of the
            Function has been called since its creation.
            Note that if the gradient is implemented by a finite difference method,
            the gradient calls number is equal to 0 and the different calls are
            counted in the evaluation calls number.
        """
        return _func.Function_getGradientCallsNumber(self)

    def getHessianCallsNumber(self):
        r"""
        Accessor to the number of times the hessian of the function has been called.

        Returns
        -------
        hessian_calls_number : int
            Integer that counts the number of times the hessian of the
            Function has been called since its creation.
            Note that if the hessian is implemented by a finite difference method,
            the hessian calls number is equal to 0 and the different calls are counted
            in the evaluation calls number.
        """
        return _func.Function_getHessianCallsNumber(self)

    def isLinear(self):
        r"""
        Accessor to the linearity of the function.

        Returns
        -------
        linear : bool
            *True* if the function is linear, *False* otherwise.
        """
        return _func.Function_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the function with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the function is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.Function_isLinearlyDependent(self, index)

    def draw(self, *args):
        r"""
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, centralPoint, xiMin, xiMax, ptNb, scale*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, centralPoint, xiMin_xjMin, xiMax_xjMax, ptNbs, scale, isFilled*)

            draw(*xiMin, xiMax, ptNb, scale*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs, scale*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        centralPoint : sequence of float
            Central point with dimension equal to the input dimension of the function.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0`
            The number of points to draw the curves.
        ptNbs : list of int of dimension 2 :math:`ptNbs_k > 0, k=1,2`
            The number of points to draw the contour in the 2D case.
        scale : bool
            scale indicates whether the logarithmic scale is used either for one or both axes:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        isFilled : bool
            isFilled indicates whether the contour graph is filled or not

        Notes
        -----
        We note :math:`f: \Rset^n \rightarrow \Rset^p`
        where :math:`\vect{x} = (x_1, \dots, x_n)` and
        :math:`f(\vect{x}) = (f_1(\vect{x}), \dots, f_p(\vect{x}))`,
        with :math:`n\geq 1` and :math:`p\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \Rset^n \rightarrow \Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\vect{x}` are fixed to the corresponding components of the *centralPoint* :math:`\vect{c}`.
        Then OpenTURNS draws the graph:

        .. math::
            y = f_k^{(i)}(s)

        for any :math:`s \in [x_i^{min}, x_i^{max}]` where :math:`f_k^{(i)}(s)` is defined by the equation:

        .. math::
            f_k^{(i)}(s) = f_k(c_1, \dots, c_{i-1}, s,  c_{i+1} \dots, c_n).

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\vect{x}` are fixed to the corresponding components of the
        *centralPoint* :math:`\vect{c}`.
        Then OpenTURNS draws the graph:

        .. math::
            y = f_k^{(i,j)}(s, t)

        for any :math:`(s, t) \in [x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]` where :math:`f_k^{(i,j)}` 
        is defined by the equation:

        .. math::
            f_k^{(i,j)}(s,t) = f_k(c_1, \dots, c_{i-1}, s, c_{i+1}, \dots, c_{j-1}, t,  c_{j+1} \dots, c_n).

        - In the third usage:

        The same as the first usage but only for function :math:`f: \Rset \rightarrow \Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \Rset^2 \rightarrow \Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction('x', 'sin(2*pi_*x)*exp(-x^2/2)')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.Function_draw(self, *args)

    def drawCrossCuts(self, *args):
        r"""
        Draw the 2D and 1D cross cuts of a 1D output function as a :class:`~openturns.GridLayout`.

        Parameters
        ----------
        centralPoint : list of float
            Central point with dimension equal to the input dimension of the function.
        xMin, xMax : list of float
            Define the interval where the curve is plotted.
        pointNumber : :class:`~openturns.Indices`
            The number of points to draw the contours and the curves.
        withMonoDimensionalCuts : bool, optional
            withMonoDimensionalCuts indicates whether the mono dimension cuts are drawn or not
            Default value is specified in the `CrossCuts-DefaultWithMonoDimensionalCuts` ResourceMap key.
        isFilled : bool, optional
            isFilled indicates whether the contour graphs are filled or not
            Default value is specified in the `Contour-DefaultIsFilled` ResourceMap key
        vMin, vMax : float, optional
            Define the interval used to build the color map for the contours
            If not specified, these values are computed to best fit the graphs.
            Either specify both values or do not specify any.

        Notes
        -----
        We note :math:`f: \Rset^n \rightarrow \Rset^p`
        where :math:`\vect{x} = (x_1, \dots, x_n)` and
        :math:`f(\vect{x}) = (f_1(\vect{x}), \dots, f_p(\vect{x}))`,
        with :math:`n\geq 1` and :math:`p\geq 1`.

        In all usages, draw the 1D and 2D cross cuts of
        :math:`f_k: \Rset^n \rightarrow \Rset` as a function of all input coordinates for 1D cuts
        and all couples of coordinates for 2D cuts. Variable coordinates :math:`x_i` are sampled
        regularly using :math:`ptNb[i]` points in the interval :math:`[x_i^{min}, x_i^{max}]`,
        when all the other components of :math:`\vect{x}` are fixed to the corresponding components
        of the *centralPoint* :math:`\vect{c}`. In the first usage, vMin and vMax are evaluated as
        the min and max of all samples of the function value calculated in all cross cuts performed.

        For 1D cross cuts the graph shows:

        .. math::
            y = f_k^{(i)}(s)

        for any :math:`s \in [x_i^{min}, x_i^{max}]` where :math:`f_k^{(i)}(s)` is defined by the equation:

        .. math::
            f_k^{(i)}(s) = f_k(c_1, \dots, c_{i-1}, s,  c_{i+1} \dots, c_n).

        - For 2D cross cuts:

        .. math::
            y = f_k^{(i,j)}(s, t)

        for any :math:`(s, t) \in [x_i^{min}, x_i^{max}] \times [x_j^{min}, x_j^{max}]` where :math:`f_k^{(i,j)}` 
        is defined by the equation:

        .. math::
            f_k^{(i,j)}(s,t) = f_k(c_1, \dots, c_{i-1}, s, c_{i+1}, \dots, c_{j-1}, t,  c_{j+1} \dots, c_n).

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction(['x0', 'x1', 'x2'], ['sin(1*pi_*x0) + x1 - x2 ^ 2'])
        >>> grid = f.drawCrossCuts([0., 0., 0.], [-3., -3, -3], [3, 3, 3], [100, 20, 20], True, True)
        >>> View(grid).show()
        """
        return _func.Function_drawCrossCuts(self, *args)

    def setStopCallback(self, callBack, state=None):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop an evaluation.

        Parameters
        ----------
        callback : callable
            Returns a bool deciding whether to stop or continue.

        """
        return _func.Function_setStopCallback(self, callBack, state)

    def __init__(self, *args):
        _func.Function_swiginit(self, _func.new_Function(*args))
    __swig_destroy__ = _func.delete_Function

# Register Function in _func:
_func.Function_swigregister(Function)

# We have to make sure the submodule is loaded with absolute path
import openturns.typ

class OpenTURNSPythonFunction:
    """
    Override Function from Python.

    Parameters
    ----------
    inputDim : positive int
        Dimension of the input vector
    outputDim : positive int
        Dimension of the output vector

    Notes
    -----
    You have to overload the function:
        _exec(X): single evaluation, X is a sequence of float,
        returns a sequence of float

    You can also optionally override these functions:
        _exec_sample(X): multiple evaluations, X is a 2-d sequence of float,
        returns a 2-d sequence of float

        _gradient(X): gradient, X is a sequence of float,
        returns a 2-d sequence of float

        _hessian(X): hessian, X is a sequence of float,
        returns a 3-d sequence of float

    Examples
    --------
    >>> import openturns as ot
    >>> class FUNC(ot.OpenTURNSPythonFunction):
    ...     def __init__(self):
    ...         super(FUNC, self).__init__(2, 1)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T'])
    ...     def _exec(self, X):
    ...         Y = [X[0] + X[1]]
    ...         return Y
    >>> F = FUNC()

    Create the associated Function:

    >>> func = ot.Function(F)
    """
    def __init__(self, n=0, p=0):
        try:
            self.__n = int(n)
        except:
            raise TypeError('inputDim argument is not an integer.')
        try:
            self.__p = int(p)
        except:
            raise TypeError('outputDim argument is not an integer.')
        self.__descIn = ['x' + str(i) for i in range(n)]
        self.__descOut = ['y' + str(i) for i in range(p)]

    def setInputDescription(self, descIn):
        """Input description accessor."""
        if (len(descIn) != self.__n):
            raise ValueError('Input description size does NOT match input dimension')
        self.__descIn = descIn

    def getInputDescription(self):
        """Input description accessor."""
        return self.__descIn

    def setOutputDescription(self, descOut):
        """Output description accessor."""
        if (len(descOut) != self.__p):
            raise ValueError('Output description size does NOT match output dimension')
        self.__descOut = descOut

    def getOutputDescription(self):
        """Output description accessor."""
        return self.__descOut

    def getInputDimension(self):
        """Input dimension accessor."""
        return self.__n

    def getOutputDimension(self):
        """Output dimension accessor."""
        return self.__p

    def __str__(self):
        return f"OpenTURNSPythonFunction( {self.__descIn} #{self.__n} ) -> {self.__descOut} #{self.__p}"

    def __repr__(self):
        return self.__str__()

    def __call__(self, X):
        Y = None
        try:
            pt = openturns.typ.Point(X)
        except TypeError:
            try:
                ns = openturns.typ.Sample(X)
            except TypeError:
                raise TypeError('Expect a 1-d or 2-d sequence of float as argument')
            else:
                Y = self._exec_sample(ns)
        else:
            Y = self._exec(pt)
        return Y

    def _exec(self, X):
        raise RuntimeError('You must define a method _exec(X) -> Y, where X and Y are 1-d sequence of float')

    def _exec_sample(self, X):
        """Implement exec_sample from exec."""
        return [self._exec(point) for point in X]

    def _exec_point_on_exec_sample(self, X):
        """Implement exec from exec_sample."""
        return self._exec_sample([X])[0]

def _exec_point_on_func_sample(func_sample):
    """Return a _exec function.

    Parameters
    ----------
    func_sample : Function or callable
        A callable python object. Called when evaluated on multiple points at once.

    Returns
    -------
    _exec : Function or callable
        The exec point function.
    """
    def _exec(X):
        return func_sample([X])[0]
    return _exec

def _exec_sample_multiprocessing_func(func, n_cpus):
    """Return a distributed function using multiprocessing.

    Parameters
    ----------
    func : Function or callable
        A callable python object, usually a function. The function should take
        an input vector as argument and return an output vector.

    n_cpus : int
        Number of CPUs on which to distribute the function calls.

    Returns
    -------
    _exec_sample : Function or callable
        The parallelized function.
    """
    def _exec_sample(X):
        try:
            from multiprocessing import Pool
            p = Pool(processes=n_cpus)
        except:
# multiprocessing is not working on this platform,
# fallback to sequential computations.
            return [func(point) for point in X]
        rs = p.map_async(func, X)
        p.close()
        return rs.get()
    return _exec_sample

def _exec_sample_multiprocessing_func_sample(func_sample, n_cpus):
    """Return a distributed function using multiprocessing.

    Parameters
    ----------
    func_sample : Function or callable
        A callable python object. Called when evaluated on multiple points at once.

    n_cpus : int
        Number of CPUs on which to distribute the function calls.

    Returns
    -------
    _exec_sample : Function or callable
        The parallelized function.
    """
    def _exec_sample(X):
        import warnings
        try:
            from multiprocessing import Pool
            p = Pool(processes=n_cpus)
        except:
# multiprocessing is not working on this platform,
# fallback to sequential computations.
            warnings.warn("-- Multiprocessing is not working on this platform"
                  " fallback to sequential computations.")
            return func_sample(X)
        try:
            import numpy as np
        except:
            warnings.warn("-- Without numpy multiprocessing is not efficient")
            p.close()
            return func_sample(X)

        nsim = len(X)
        if nsim < n_cpus:
            return func_sample(X)

        a = np.asarray(X)
        rs = p.map(func_sample, [a[r:r+(nsim//n_cpus), :] for r in range(0, nsim, nsim//n_cpus)])
        p.close()
        p.join()
        return np.vstack(rs)
    return _exec_sample

class PythonFunction(Function):
    """
    Override Function from Python.

    Parameters
    ----------
    inputDim : positive int
        Dimension of the input vector
    outputDim : positive int
        Dimension of the output vector
    func : a callable python object, optional
        Called when evaluated on a single point.
        Default is None.
    func_sample : a callable python object, optional
        Called when evaluated on multiple points at once.
        Default is None.
    gradient : a callable python objects, optional
        Returns the gradient as a 2-d sequence of float.
        Default is None (uses finite-difference).
    hessian : a callable python object, optional
        Returns the hessian as a 3-d sequence of float.
        Default is None (uses finite-difference).
    n_cpus : int, default=None
        Number of cpus on which func should be distributed using multiprocessing.
        If -1, it uses all the cpus available. If 1, it does nothing.
        Note that you should enforce the multiprocessing guidelines to enable this option, see
        https://docs.python.org/3/library/multiprocessing.html#multiprocessing-programming
        For example on Windows, the entry point of your program should be
        protected using the `if __name__== '__main__'` idiom.
    copy : bool, optional
        If True, input sample is converted into a Python 2-d sequence before calling
        func_sample.  Otherwise, it is passed directly to func_sample.
        Default is False.
    functionLinearity : bool, optional
        Indicates if the function is linear.
        Default is False.
    variablesLinearity : list of bool, optional
        Indicates for each input variable if the function is linear with regard to this variable.
        Default is [False]*inputDim

    Notes
    -----
    You must provide at least func or func_sample arguments. For efficiency
    reasons, these functions do not receive a :class:`~openturns.Point` or
    :class:`~openturns.Sample` as arguments, but a proxy object which gives
    access to internal object data. This object supports indexing, but nothing
    more. It must be wrapped into another object, for instance
    :class:`~openturns.Point` in func and :class:`~openturns.Sample` in
    func_sample, or in a Numpy array, for vectorized operations.

    Note that if PythonFunction is distributed (n_cpus > 1), the traceback of a raised
    exception by a func call is lost due to the way multiprocessing dispatches
    and handles func calls. This can be solved by temporarily deactivating
    n_cpus during the development of the wrapper or by manually handling the
    distribution of the wrapper with external libraries like joblib that keep
    track of a raised exception and shows the traceback to the user.

    Examples
    --------
    >>> import openturns as ot
    >>> def a_exec(X):
    ...     Y = [3.0 * X[0] - X[1]]
    ...     return Y
    >>> def a_grad(X):
    ...     dY = [[3.0], [-1.0]]
    ...     return dY
    >>> f = ot.PythonFunction(2, 1, a_exec, gradient=a_grad)
    >>> X = [100.0, 100.0]
    >>> Y = f(X)
    >>> print(Y)
    [200]
    >>> dY = f.gradient(X)
    >>> print(dY)
    [[  3 ]
     [ -1 ]]

    Same example, but optimized for best performance with Numpy when function
    is going to be evaluated on large samples.

    >>> import openturns as ot
    >>> import numpy as np
    >>> def a_exec_sample(X):
    ...     Xarray = np.asarray(X)
    ...     Y = 3.0 * Xarray[:,0] - Xarray[:,1]
    ...     return np.expand_dims(Y, axis=1)
    >>> def a_grad(X):
    ...     dY = [[3.0], [-1.0]]
    ...     return dY
    >>> f = ot.PythonFunction(2, 1, func_sample=a_exec_sample, gradient=a_grad)
    >>> X = [100.0, 100.0]
    >>> Y = f(X)
    >>> print(Y)
    [200]
    >>> dY = f.gradient(X)
    >>> print(dY)
    [[  3 ]
     [ -1 ]]
    """
    def __new__(self, inputDim, outputDim, func=None, func_sample=None, gradient=None, hessian=None, n_cpus=None, copy=False, functionLinearity=None, variablesLinearity=None):
        if func is None and func_sample is None:
            raise RuntimeError('no func nor func_sample given.')
        instance = OpenTURNSPythonFunction(inputDim, outputDim)
        if copy:
            instance._discard_openturns_memoryview = True

        if n_cpus is not None:
            if not isinstance(n_cpus, int):
                raise RuntimeError('n_cpus is not an integer')
            if n_cpus == -1:
                import multiprocessing
                n_cpus = multiprocessing.cpu_count()
            if n_cpus <= 1:
                n_cpus = None

        if func is not None:
            if not callable(func):
                raise RuntimeError('func argument is not callable.')
            instance._exec = func
        else:
            instance._exec = _exec_point_on_func_sample(func_sample)

        instance._has_exec = True

        if func_sample is not None:
            if n_cpus is not None:
                instance._exec_sample = _exec_sample_multiprocessing_func_sample(func_sample, n_cpus)
            else:
                instance._exec_sample = func_sample
            instance._has_exec_sample = True
        else:
            if n_cpus is not None:
                instance._exec_sample = _exec_sample_multiprocessing_func(func, n_cpus)
                instance._has_exec_sample = True

        if gradient is not None:
            if not callable(gradient):
                raise RuntimeError('gradient argument is not callable.')
            instance._gradient = gradient
        if hessian is not None:
            if not callable(hessian):
                raise RuntimeError('hessian argument is not callable.')
            instance._hessian = hessian 

        if functionLinearity is not None:
            instance.isLinear = functionLinearity

        if variablesLinearity is not None:
            instance.isVariableLinear = variablesLinearity

        return Function(instance)

class MemoizeEvaluation(object):
    r"""
    Evaluation which keeps tracks of input and output.

    Usually we use :class:`~openturns.MemoizeFunction` (aa function 
    provides both the evaluation, the gradient and the hessian). that 
    relies on a :class:`~openturns.Function` passed as argument, and store
    input and output :class:`~openturns.Sample`.
    It also has a caching behavior, enabled by default.

    Parameters
    ----------
    function : :class:`~openturns.Evaluation`
        Delegate evaluation
    historyStrategy : :class:`~openturns.HistoryStrategy` (optional)
        Strategy used to store points, default is :class:`~openturns.Full`.


    See also
    --------
    HistoryStrategy, Full, Last, Compact, Null

    Examples
    --------

    >>> import openturns as ot
    >>> f = ot.SymbolicEvaluation(['x'], ['y'], ['x^2'])
    >>> inputSample = ot.Sample([[1], [2], [3], [4]])
    >>> f = ot.MemoizeEvaluation(f)
    >>> outputSample = f(inputSample)

    Retrieve input sample:

    >>> print(f.getInputHistory())
    0 : [ 1 ]
    1 : [ 2 ]
    2 : [ 3 ]
    3 : [ 4 ]

    Retrieve output sample:

    >>> print(f.getOutputHistory())
    0 : [  1 ]
    1 : [  4 ]
    2 : [  9 ]
    3 : [ 16 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.MemoizeEvaluation_getClassName(self)

    def setEvaluation(self, evaluation):
        r"""
        Set the evaluation.

        Parameters
        ----------
        evaluation : :class:`~openturns.Evaluation`
            Evaluation.

        Notes
        -----
        This sets a new evaluation of interest. Cache and history are cleaned and the 
        class will stores new one accounting for the given evaluation 
        and store input and output :class:`~openturns.Sample`.
        It also has a caching behavior, enabled by default.
        """
        return _func.MemoizeEvaluation_setEvaluation(self, evaluation)

    def getEvaluation(self):
        return _func.MemoizeEvaluation_getEvaluation(self)

    def __eq__(self, *args):
        return _func.MemoizeEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.MemoizeEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.MemoizeEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.MemoizeEvaluation___call__(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.MemoizeEvaluation_getMarginal(self, *args)

    def enableCache(self):
        r"""Enable the cache."""
        return _func.MemoizeEvaluation_enableCache(self)

    def disableCache(self):
        r"""Disable the cache."""
        return _func.MemoizeEvaluation_disableCache(self)

    def isCacheEnabled(self):
        r"""
        Test whether the cache is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache is enabled.
            It is enabled by default.
        """
        return _func.MemoizeEvaluation_isCacheEnabled(self)

    def getCacheHits(self):
        r"""
        Accessor to the number of computations saved thanks to the cache.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache.
        """
        return _func.MemoizeEvaluation_getCacheHits(self)

    def addCacheContent(self, inSample, outSample):
        r"""
        Add input and output points to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input points to be added to the cache.
        output_sample : 2-d sequence of float
            Output points associated with the input_sample to be added to the
            cache.
        """
        return _func.MemoizeEvaluation_addCacheContent(self, inSample, outSample)

    def getCacheInput(self):
        r"""
        Accessor to the input points stored in the cache.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            The input points stored in the cache.
        """
        return _func.MemoizeEvaluation_getCacheInput(self)

    def getCacheOutput(self):
        r"""
        Accessor to the output points stored in the cache.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            The output points stored in the cache.
        """
        return _func.MemoizeEvaluation_getCacheOutput(self)

    def clearCache(self):
        r"""Empty the content of the cache."""
        return _func.MemoizeEvaluation_clearCache(self)

    def enableHistory(self):
        r"""Enable the history."""
        return _func.MemoizeEvaluation_enableHistory(self)

    def disableHistory(self):
        r"""Disable the history."""
        return _func.MemoizeEvaluation_disableHistory(self)

    def isHistoryEnabled(self):
        r"""
        Test whether the history is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history is enabled.
        """
        return _func.MemoizeEvaluation_isHistoryEnabled(self)

    def clearHistory(self):
        r"""Clear input and output history."""
        return _func.MemoizeEvaluation_clearHistory(self)

    def getInputHistory(self):
        r"""
        Get the input sample history.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input points which have been evaluated.
        """
        return _func.MemoizeEvaluation_getInputHistory(self)

    def getOutputHistory(self):
        r"""
        Get the output sample history.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output points which have been evaluated.
        """
        return _func.MemoizeEvaluation_getOutputHistory(self)

    def __init__(self, *args):
        _func.MemoizeEvaluation_swiginit(self, _func.new_MemoizeEvaluation(*args))
    __swig_destroy__ = _func.delete_MemoizeEvaluation

# Register MemoizeEvaluation in _func:
_func.MemoizeEvaluation_swigregister(MemoizeEvaluation)
class MemoizeFunction(FunctionImplementation):
    r"""
    Function which keeps tracks of input and output.

    When this function is evaluated, it calls the
    :class:`~openturns.Function` passed as argument, and store
    input and output :class:`~openturns.Sample`.
    It also has a caching behavior, enabled by default.

    Parameters
    ----------
    function : :class:`~openturns.Function`
        Delegate function
    historyStrategy : :class:`~openturns.HistoryStrategy` (optional)
        Strategy used to store points, default is :class:`~openturns.Full`.

    Notes
    -----

    When the function passed as argument is a :class:`~openturns.MemoizeFunction`,
    its input and output history are copied into current instance.
    This allows one to retrieve this history from a :class:`~openturns.Function`
    object which is in fact a :class:`~openturns.MemoizeFunction`.
    Thus, if you create a :class:`~openturns.MemoizeFunction` from an unknown
    :class:`~openturns.Function`, it is better to call :meth:`clearHistory`.
    The cache size is initialized by the value of the :class:`~openturns.ResourceMap` `Cache-MaxSize` entry.

    See also
    --------
    Function, HistoryStrategy, Full, Last, Compact, Null

    Examples
    --------

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction('x', 'x^2')
    >>> inputSample = ot.Sample([[1], [2], [3], [4]])
    >>> f = ot.MemoizeFunction(f)
    >>> outputSample = f(inputSample)

    Retrieve input sample:

    >>> print(f.getInputHistory())
    0 : [ 1 ]
    1 : [ 2 ]
    2 : [ 3 ]
    3 : [ 4 ]

    Retrieve output sample:

    >>> print(f.getOutputHistory())
    0 : [  1 ]
    1 : [  4 ]
    2 : [  9 ]
    3 : [ 16 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.MemoizeFunction_getClassName(self)

    def __repr__(self):
        return _func.MemoizeFunction___repr__(self)

    def setEvaluation(self, evaluation):
        r"""
        Accessor to the evaluation function.

        Parameters
        ----------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.
        """
        return _func.MemoizeFunction_setEvaluation(self, evaluation)

    def __eq__(self, *args):
        return _func.MemoizeFunction___eq__(self, *args)

    def __call__(self, *args):
        return _func.MemoizeFunction___call__(self, *args)

    def enableCache(self):
        r"""Enable the cache mechanism."""
        return _func.MemoizeFunction_enableCache(self)

    def disableCache(self):
        r"""Disable the cache mechanism."""
        return _func.MemoizeFunction_disableCache(self)

    def isCacheEnabled(self):
        r"""
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is enabled by default.
        """
        return _func.MemoizeFunction_isCacheEnabled(self)

    def getCacheHits(self):
        r"""
        Accessor to the number of computations saved thanks to the cache mechanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mechanism.
        """
        return _func.MemoizeFunction_getCacheHits(self)

    def addCacheContent(self, inSample, outSample):
        r"""
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.MemoizeFunction_addCacheContent(self, inSample, outSample)

    def getCacheInput(self):
        r"""
        Accessor to all the input numerical points stored in the cache mechanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the input numerical points stored in the cache mechanism.
        """
        return _func.MemoizeFunction_getCacheInput(self)

    def getCacheOutput(self):
        r"""
        Accessor to all the output numerical points stored in the cache mechanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the output numerical points stored in the cache mechanism.
        """
        return _func.MemoizeFunction_getCacheOutput(self)

    def clearCache(self):
        r"""Empty the content of the cache."""
        return _func.MemoizeFunction_clearCache(self)

    def enableHistory(self):
        r"""Enable the history mechanism."""
        return _func.MemoizeFunction_enableHistory(self)

    def disableHistory(self):
        r"""Disable the history mechanism."""
        return _func.MemoizeFunction_disableHistory(self)

    def isHistoryEnabled(self):
        r"""
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
        """
        return _func.MemoizeFunction_isHistoryEnabled(self)

    def clearHistory(self):
        r"""Clear input and output history."""
        return _func.MemoizeFunction_clearHistory(self)

    def getInputHistory(self):
        r"""
        Get the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input points which have been evaluated.
        """
        return _func.MemoizeFunction_getInputHistory(self)

    def getOutputHistory(self):
        r"""
        Get the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output points which have been evaluated.
        """
        return _func.MemoizeFunction_getOutputHistory(self)

    def __init__(self, *args):
        _func.MemoizeFunction_swiginit(self, _func.new_MemoizeFunction(*args))
    __swig_destroy__ = _func.delete_MemoizeFunction

# Register MemoizeFunction in _func:
_func.MemoizeFunction_swigregister(MemoizeFunction)
class AggregatedFunction(Function):
    r"""
    Aggregated function.

    The built function stacks all the outputs from each function in the list.

    :math:`functionCollection  = (f_1, \hdots, f_N)`
    where :math:`\forall 1 \leq i \leq N, \,     f_i: \Rset^n \rightarrow \Rset^{p_i}`

    .. math::

        agregFct \left|\begin{array}{rcl}
                      \Rset^n & \rightarrow & \Rset^{p} \\
                      \vect{X} & \mapsto & \displaystyle (f_1(\vect{X}), \hdots, f_N(\vect{X}))^t
                  \end{array}\right.

    with

    .. math::

        p = \sum_{i=1}^N p_i

    Parameters
    ----------
    functionCollection : sequence of :class:`~openturns.Function`
        Functions to aggregate.

    Examples
    --------
    >>> import openturns as ot
    >>> f1 = ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                          ['x1^2 + x2', 'x1 + x2 + x3'])
    >>> f2 = ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                          ['x1 + 2 * x2 + x3', 'x1 + x2 - x3'])
    >>> functions = [f1, f2]
    >>> agregFct = ot.AggregatedFunction(functions)
    >>> print(agregFct([1.0, 2.0, 3.0]))
    [3,6,8,0]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.AggregatedFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.AggregatedFunction___eq__(self, *args)

    def __repr__(self):
        return _func.AggregatedFunction___repr__(self)

    def __str__(self, *args):
        return _func.AggregatedFunction___str__(self, *args)

    def __init__(self, *args):
        _func.AggregatedFunction_swiginit(self, _func.new_AggregatedFunction(*args))
    __swig_destroy__ = _func.delete_AggregatedFunction

# Register AggregatedFunction in _func:
_func.AggregatedFunction_swigregister(AggregatedFunction)
class SymbolicFunction(Function):
    r"""
    Symbolic function.

    Parameters
    ----------
    inputs : sequence of str, or str
        List of input variables names of the function.
    formulas : sequence of str, or str
        List of analytical formulas between the inputs and the outputs.
        The function is defined by *outputs = formulas(inputs)*.

    Available functions:

        - sin
        - cos
        - tan
        - asin
        - acos
        - atan
        - sinh
        - cosh
        - tanh
        - asinh
        - acosh
        - atanh
        - log2
        - log10
        - log
        - ln
        - lngamma
        - gamma
        - exp
        - erf
        - erfc
        - sqrt
        - cbrt
        - besselJ0
        - besselJ1
        - besselY0
        - besselY1
        - sign
        - rint
        - abs
        - min
        - max
        - sum
        - avg
        - floor
        - ceil
        - trunc
        - round

    Available operators:

        - <= (less or equal)
        - >= (greater or equal)
        - != (not equal)
        - == (equal)
        - > (greater than)
        - < (less than)
        - \+ (addition)
        - \- (subtraction)
        - \* (multiplication)
        - / (division)
        - ^ (raise x to the power of y)

    Available constants:

        - e\_ (Euler's constant)
        - pi\_ (Pi)

    Notes
    -----

    Up to version 1.10, OpenTURNS relied on `muParser <https://beltoforion.de/en/muparser/>`_
    to parse analytical formulas. Since version 1.11, `ExprTk <http://www.partow.net/programming/exprtk/>`_
    is used by default, but both parsers can be used if their support have been compiled.
    This is controlled by the `SymbolicParser-Backend` :class:`~openturns.ResourceMap` entry.

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x0', 'x1'], ['x0 + x1', 'x0 - x1'])
    >>> print(f([1, 2]))
    [3,-1]

    `ExprTk <http://www.partow.net/programming/exprtk/>`_
    allows one to write multiple outputs; in this case, the constructor has a special syntax,
    it contains input variables names, but also output variables names, and formula is a string:

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x0', 'x1'], ['y0', 'y1'], 'y0 := x0 + x1; y1 := x0 - x1')
    >>> print(f([1, 2]))
    [3,-1]

    The following example uses the min and sqrt functions:

    >>> formula = 'min(-x1 - x2 - x3 + 3 * sqrt(3), -x3 + 3)'
    >>> limitStateFunction = ot.SymbolicFunction(['x1', 'x2', 'x3'], [formula])
    >>> print(limitStateFunction([1, 2, 3]))
    [-0.803848]

    The following example splits the formula into four parts to manage its length:

    >>> formula = '15.59 * 1e4 - x1 *x2^3 / (2 * x3^3) *'
    >>> formula += '((x4^2 - 4 * x5 * x6 * x7^2 + '
    >>> formula += 'x4 * (x6 + 4 * x5 + 2 *x6 * x7)) / '
    >>> formula += '(x4 * x5 * (x4 + x6 + 2 *x6 *x7)))'
    >>> input_variables = ['x1', 'x2', 'x3', 'x4', 'x5', 'x6', 'x7']
    >>> limitStateFunction = ot.SymbolicFunction(input_variables, [formula])
    >>> print(limitStateFunction([1, 2, 3, 4, 5, 6, 7]))
    [155900]

    `ExprTk <http://www.partow.net/programming/exprtk/>`_
    allows one to manage intermediate variables with the `var` keyword.
    This is convenient in the situation where several outputs require
    the same intermediate calculation or if the output is a complex
    function of the input.
    In the following example, we compute the `alpha` variable which is
    the slope of the river in the flooding example.
    This slope is then used in the computation of the height `H`.

    >>> import openturns as ot
    >>> inputs = ['Q', 'Ks', 'Zv', 'Zm', 'Hd', 'Zb', 'L', 'B']
    >>> outputs = ['H', 'S']
    >>> formula = 'var alpha := (Zm - Zv)/L;'
    >>> formula += 'H := (Q / (Ks * B * sqrt(alpha)))^(3.0 / 5.0);'
    >>> formula += 'var Zc := H + Zv;'
    >>> formula += 'var Zd := Zb + Hd;'
    >>> formula += 'S := Zc - Zd'
    >>> myFunction = ot.SymbolicFunction(inputs, outputs, formula)
    >>> X = [1013.0, 30.0, 50.0, 55.0, 8, 55.5, 5000.0, 300.0]
    >>> print(myFunction(X))
    [2.142,-11.358]

    The following example illustrates a function for a system of two components.

    >>> equations = ['var g1 := x1^2 -8 * x2 + 16']
    >>> equations.append('var g2 := -16 * x1 + x2 + 32')
    >>> equations.append('gsys := max(g1, g2)')
    >>> formula = ';'.join(equations)
    >>> limitStateFunction = ot.SymbolicFunction(['x1', 'x2'], ['gsys'], formula)
    >>> print(limitStateFunction([1, 2]))
    [18]

    See the `ExprTk <http://www.partow.net/programming/exprtk/>`_
    documentation for details.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.SymbolicFunction_getClassName(self)

    def __repr__(self):
        return _func.SymbolicFunction___repr__(self)

    def __str__(self, *args):
        return _func.SymbolicFunction___str__(self, *args)

    def getFormulas(self):
        r"""
        Formulas accessor.

        Returns
        -------
        list_functions : :class:`~openturns.Description`
            List of the formulas.

        """
        return _func.SymbolicFunction_getFormulas(self)

    @staticmethod
    def GetValidParsers():
        r"""
        Return the list of built-in parsers.

        Analytical formulas can be parsed by 'MuParser' or 'ExprTk'
        parsers, but this support may be disabled at build-time.
        This method returns the list of parsers available at run-time.
        Parser can be switched by changing 'SymbolicParser-Backend'
        ResourceMap entry.

        Returns
        -------
        list_constants : :class:`~openturns.Description`
            List of the available parsers.
        """
        return _func.SymbolicFunction_GetValidParsers()

    @staticmethod
    def GetValidConstants():
        r"""
        Return the list of valid constants.

        Returns
        -------
        list_constants : :class:`~openturns.Description`
            List of the available constants.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.SymbolicFunction.GetValidConstants()[0])
        e_ -> Euler's constant (2.71828...)
        """
        return _func.SymbolicFunction_GetValidConstants()

    @staticmethod
    def GetValidFunctions():
        r"""
        Return the list of valid functions.

        Returns
        -------
        list_functions : :class:`~openturns.Description`
            List of the available functions.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.SymbolicFunction.GetValidFunctions()[0])
        sin(arg) -> sine function
        """
        return _func.SymbolicFunction_GetValidFunctions()

    @staticmethod
    def GetValidOperators():
        r"""
        Return the list of valid operators.

        Returns
        -------
        list_operators : :class:`~openturns.Description`
            List of the available operators.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.SymbolicFunction.GetValidOperators()[0])
        = -> assignment, can only be applied to variable names (priority -1)
        """
        return _func.SymbolicFunction_GetValidOperators()

    def __init__(self, *args):
        _func.SymbolicFunction_swiginit(self, _func.new_SymbolicFunction(*args))
    __swig_destroy__ = _func.delete_SymbolicFunction

# Register SymbolicFunction in _func:
_func.SymbolicFunction_swigregister(SymbolicFunction)
class LinearCombinationFunction(Function):
    r"""
    Linear combination of functions.

    Allows one to create a function which is the linear combination of functions
    with scalar weights.

    :math:`functionCollection  = (f_1, \hdots, f_N)`
    where :math:`\forall 1 \leq i \leq N, \,     f_i: \Rset^n \rightarrow \Rset^{p}`
    and :math:`scalarCoefficientColl = (c_1, \hdots, c_N) \in \Rset^N`
    then the linear combination is:

    .. math::

        linComb  \left|\begin{array}{rcl}
                      \Rset^n & \rightarrow & \Rset^{p} \\
                      \vect{X} & \mapsto & \displaystyle \sum_{i=1}^N c_i f_i (\vect{X})
                  \end{array}\right.

    Parameters
    ----------
    functionCollection : sequence of :class:`~openturns.Function`
        Collection of functions to sum.
    scalarCoefficientColl : sequence of float
        Collection of scalar weights.

    Examples
    --------
    >>> import openturns as ot
    >>> f1 = ot.SymbolicFunction(['x'], ['sin(x)'])
    >>> f2 = ot.SymbolicFunction(['x'], ['x'])
    >>> f3 = ot.SymbolicFunction(['x'], ['cos(x)'])
    >>> f = ot.LinearCombinationFunction([f1, f2, f3], [1.0, 2.0, 3.0])

    Evaluate the function:

    >>> x = [1.0]
    >>> y = f(x)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.LinearCombinationFunction___eq__(self, *args)

    def __repr__(self):
        return _func.LinearCombinationFunction___repr__(self)

    def __str__(self, *args):
        return _func.LinearCombinationFunction___str__(self, *args)

    def __init__(self, *args):
        _func.LinearCombinationFunction_swiginit(self, _func.new_LinearCombinationFunction(*args))
    __swig_destroy__ = _func.delete_LinearCombinationFunction

# Register LinearCombinationFunction in _func:
_func.LinearCombinationFunction_swigregister(LinearCombinationFunction)
class ComposedFunction(FunctionImplementation):
    r"""
    Composed function.

    Available constructor:
        ComposedFunction(*f, g*)

    The function is the composed function :math:`f\circ g`.

    Parameters
    ----------
    f,g : two :class:`~openturns.Function`
        The functions to compose.

    Examples
    --------
    >>> import openturns as ot
    >>> g = ot.SymbolicFunction(['x1', 'x2'],
    ...                           ['x1 + x2','3 * x1 * x2'])
    >>> f = ot.SymbolicFunction(['x1', 'x2'], ['2 * x1 - x2'])
    >>> composed = ot.ComposedFunction(f, g)
    >>> print(composed([3, 4]))
    [-22]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.ComposedFunction___eq__(self, *args)

    def __repr__(self):
        return _func.ComposedFunction___repr__(self)

    def parameterGradient(self, inP):
        r"""
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.ComposedFunction_parameterGradient(self, inP)

    def __init__(self, *args):
        _func.ComposedFunction_swiginit(self, _func.new_ComposedFunction(*args))
    __swig_destroy__ = _func.delete_ComposedFunction

# Register ComposedFunction in _func:
_func.ComposedFunction_swigregister(ComposedFunction)
class IdentityFunction(Function):
    r"""
    Identity function.

    Parameters
    ----------
    dimension : int
        Input dimension

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.IdentityFunction(3)
    >>> print(f([1.0, 2.0, 3.0]))
    [1,2,3]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.IdentityFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.IdentityFunction___eq__(self, *args)

    def __repr__(self):
        return _func.IdentityFunction___repr__(self)

    def __str__(self, *args):
        return _func.IdentityFunction___str__(self, *args)

    def __init__(self, *args):
        _func.IdentityFunction_swiginit(self, _func.new_IdentityFunction(*args))
    __swig_destroy__ = _func.delete_IdentityFunction

# Register IdentityFunction in _func:
_func.IdentityFunction_swigregister(IdentityFunction)
class ParametricFunction(Function):
    r"""
    Parametric function.

    It defines a parametric function from *function* by freezing the variables
    marked by the *indices* set to the values of *referencePoint*.

    Please read the example below and :doc:`/auto_functional_modeling/vectorial_functions/plot_parametric_function` 
    for a detailed example of this class.

    Parameters
    ----------
    function : :class:`~openturns.Function`
        Function with full parameters from which the parametric function is built.
    indices : sequence of int
        Indices of the frozen variables.
    referencePoint : sequence of float
        Values of the frozen variables.
        Must be of size of *indices* if *parametersSet* is *True* (default),
        else its size should be the complementary size of *indices*.
    parametersSet : bool, optional
        If *True* (default), the frozen variables are the ones referenced
        in *indices*.
        Otherwise, the set variables are the ones referenced in the complementary
        set of *indices*.

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x', 'y', 'z'], ['x + y', 'x * z + y'])
    >>> print(f)
    [x,y,z]->[x + y,x * z + y]

    Then create another function by setting x=2 and y=3:

    >>> g=ot.ParametricFunction(f, [0,1], [2.0, 3.0])
    >>> print(g)
    ParametricEvaluation([x,y,z]->[x + y,x * z + y], parameters positions=[0,1], parameters=[x : 2, y : 3], input positions=[2])

    Or by setting z=4 using the complementary set flag:

    >>> g = ot.ParametricFunction(f, [0, 1], [4.0], False)
    >>> print(g.getInputDescription())
    [x,y]
    >>> print(g)
    ParametricEvaluation([x,y,z]->[x + y,x * z + y], parameters positions=[2], parameters=[z : 4], input positions=[0,1])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.ParametricFunction___eq__(self, *args)

    def __repr__(self):
        return _func.ParametricFunction___repr__(self)

    def __str__(self, *args):
        return _func.ParametricFunction___str__(self, *args)

    def __init__(self, *args):
        _func.ParametricFunction_swiginit(self, _func.new_ParametricFunction(*args))
    __swig_destroy__ = _func.delete_ParametricFunction

# Register ParametricFunction in _func:
_func.ParametricFunction_swigregister(ParametricFunction)
class DualLinearCombinationFunction(Function):
    r"""
    Linear combination of functions with vectorial weights.

    Allows one to create a function which is the linear combination
    of scalar functions with vectorial weights.

    :math:`functionCollection  = (f_1, \hdots, f_N)`
    where :math:`\forall 1 \leq i \leq N, \,     f_i: \Rset^n \rightarrow \Rset`
    and :math:`scalarCoefficientColl = (\vect{c}_1, \hdots, \vect{c}_N), \vect{c}_i \in \Rset^p`
    then the linear combination is:

    .. math::

        vectLinComb  \left|\begin{array}{rcl}
                      \Rset^n & \rightarrow & \Rset^{p} \\
                      \vect{X} & \mapsto & \displaystyle \sum_{i=1}^N \vect{c}_i f_i (\vect{X})
                  \end{array}\right.

    Parameters
    ----------
    functionCollection : sequence of :class:`~openturns.Function`
        Collection of functions.
    vectorCoefficientColl : 2-d sequence of float
        Collection of vectorial weights.

    Examples
    --------
    >>> import openturns as ot
    >>> f1 = ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                          ['x1 + 2 * x2 + x3'])
    >>> f2 = ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                          ['x1^2 + x2'])
    >>> functions = [f1, f2]
    >>> coefficients = [[2.0, 4.0], [3.0, 1.0]]
    >>> vectLinComb = ot.DualLinearCombinationFunction(functions, coefficients)
    >>> print(vectLinComb([1, 2, 3]))
    [25,35]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.DualLinearCombinationFunction___eq__(self, *args)

    def __repr__(self):
        return _func.DualLinearCombinationFunction___repr__(self)

    def __str__(self, *args):
        return _func.DualLinearCombinationFunction___str__(self, *args)

    def __init__(self, *args):
        _func.DualLinearCombinationFunction_swiginit(self, _func.new_DualLinearCombinationFunction(*args))
    __swig_destroy__ = _func.delete_DualLinearCombinationFunction

# Register DualLinearCombinationFunction in _func:
_func.DualLinearCombinationFunction_swigregister(DualLinearCombinationFunction)
class FieldFunctionImplementation(openturns.common.PersistentObject):
    r"""
    Function mapping a field to a field.

    Parameters
    ----------
    inputMesh : :class:`~openturns.Mesh`
        The input mesh
    inputDim : int, :math:`\geq 1`
        Dimension :math:`d` of the values of the input field
    outputMesh : :class:`~openturns.Mesh`
        The output mesh
    outputDim : int, :math:`\geq 1`
        Dimension :math:`d'` of the values of the output field

    Notes
    -----
    Field functions act on fields to produce fields:

    .. math::

        f: \left| \begin{array}{rcl}
                    \cM_N \times (\Rset^d)^N & \rightarrow & \cM_{N'} \times (\Rset^{d'})^{N'} \\
                    F & \mapsto & F'
                  \end{array} \right.

    with  :math:`\cM_N` a mesh of :math:`\cD \subset \Rset^n`,  :math:`\cM_{N'}` a mesh of :math:`\cD' \subset \Rset^{n'}`.

    A field is represented by a collection :math:`(\vect{t}_i, \vect{v}_i)_{1 \leq i \leq N}`
    of elements of :math:`\cM_N \times (\Rset^d)^N` where :math:`\vect{t}_i` is a vertex
    of :math:`\cM_N` and :math:`\vect{v}_i` the associated value in :math:`\Rset^d`.

    The constructor builds an object which evaluation operator is not defined (it throws a *NotYetImplementedException*).
    The instantiation of such an object is used to extract an actual :class:`~openturns.FieldFunction` from a  :class:`~openturns.Study`.

    See also
    --------
    PythonFieldFunction, OpenTURNSPythonFieldFunction 


    Examples
    --------
    >>> import openturns as ot

    Using the class :class:`~openturns.OpenTURNSPythonFieldFunction` allows one to define a persistent state between the evaluations of the function.

    >>> class FUNC(ot.OpenTURNSPythonFieldFunction):
    ...     def __init__(self):
    ...         # first argument:
    ...         mesh = ot.RegularGrid(0.0, 0.1, 11)
    ...         super(FUNC, self).__init__(mesh, 2, mesh, 2)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T', 'U'])
    ...     def _exec(self, X):
    ...         Xs = ot.Sample(X)
    ...         Y = Xs * ([2.0]*Xs.getDimension())
    ...         return Y
    >>> F = FUNC()

    Create the associated FieldFunction: 

    >>> myFunc = ot.FieldFunction(F)

    It is also possible to create a FieldFunction from a python function as follows:

    >>> mesh = ot.RegularGrid(0.0, 0.1, 11)
    >>> def myPyFunc(X):
    ...     Xs = ot.Sample(X)
    ...     values = Xs * ([2.0]*Xs.getDimension())
    ...     return values
    >>> inputDim = 2
    >>> outputDim = 2
    >>> myFunc = ot.PythonFieldFunction(mesh, inputDim, mesh, outputDim, myPyFunc)

    Evaluate the function on a field:

    >>> X = ot.Field(mesh, ot.Normal(2).getSample(11))
    >>> Y = myFunc(X)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldFunctionImplementation_getClassName(self)

    def __eq__(self, other):
        return _func.FieldFunctionImplementation___eq__(self, other)

    def __repr__(self):
        return _func.FieldFunctionImplementation___repr__(self)

    def __str__(self, *args):
        return _func.FieldFunctionImplementation___str__(self, *args)

    def __call__(self, *args):
        return _func.FieldFunctionImplementation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Get the dimension of the input field values.

        Returns
        -------
        d : int
            Dimension :math:`d` of the input field values.
        """
        return _func.FieldFunctionImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the output field values.

        Returns
        -------
        d' : int
            Dimension :math:`d'` of the output field values.
        """
        return _func.FieldFunctionImplementation_getOutputDimension(self)

    def setInputDescription(self, inputDescription):
        r"""
        Set the description of the input field values.

        Parameters
        ----------
        inputDescription : sequence of str
            Description of the input field values.
        """
        return _func.FieldFunctionImplementation_setInputDescription(self, inputDescription)

    def getInputDescription(self):
        r"""
        Get the description of the input field values.

        Returns
        -------
        inputDescription : :class:`~openturns.Description`
            Description of the input field values.
        """
        return _func.FieldFunctionImplementation_getInputDescription(self)

    def setOutputDescription(self, outputDescription):
        r"""
        Set the description of the output field values.

        Parameters
        ----------
        outputDescription : sequence of str
            Describes the outputs of the output field values.
        """
        return _func.FieldFunctionImplementation_setOutputDescription(self, outputDescription)

    def getOutputDescription(self):
        r"""
        Get the description of the output field values.

        Returns
        -------
        outputDescription : :class:`~openturns.Description`
            Description of the output field values.
        """
        return _func.FieldFunctionImplementation_getOutputDescription(self)

    def setInputMesh(self, inputMesh):
        r"""
        Set the mesh associated to the input domain.

        Parameters
        ----------
        inputMesh : :class:`~openturns.Mesh`
            The input mesh :math:`\cM_{N'}`.
        """
        return _func.FieldFunctionImplementation_setInputMesh(self, inputMesh)

    def getInputMesh(self):
        r"""
        Get the mesh associated to the input domain.

        Returns
        -------
        inputMesh : :class:`~openturns.Mesh`
            The input mesh :math:`\cM_{N'}`.
        """
        return _func.FieldFunctionImplementation_getInputMesh(self)

    def setOutputMesh(self, outputMesh):
        r"""
        Set the mesh associated to the output domain.

        Parameters
        ----------
        outputMesh : :class:`~openturns.Mesh`
            The output mesh :math:`\cM_{N'}`.
        """
        return _func.FieldFunctionImplementation_setOutputMesh(self, outputMesh)

    def getOutputMesh(self):
        r"""
        Get the mesh associated to the output domain.

        Returns
        -------
        outputMesh : :class:`~openturns.Mesh`
            The output mesh :math:`\cM_{N'}`.
        """
        return _func.FieldFunctionImplementation_getOutputMesh(self)

    def isActingPointwise(self):
        r"""
        Whether the function acts point-wise.

        Returns
        -------
        pointWise : bool
            Returns true if the function evaluation at each vertex depends only on the
            vertex or the value at the vertex.
        """
        return _func.FieldFunctionImplementation_isActingPointwise(self)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d'`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        fieldFunction : :class:`~openturns.FieldFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.FieldFunctionImplementation_getMarginal(self, *args)

    def getCallsNumber(self):
        r"""
        Get the number of calls of the function.

        Returns
        -------
        callsNumber : int
            Counts the number of times the function has been called since its
            creation.
        """
        return _func.FieldFunctionImplementation_getCallsNumber(self)

    def __init__(self, *args):
        _func.FieldFunctionImplementation_swiginit(self, _func.new_FieldFunctionImplementation(*args))
    __swig_destroy__ = _func.delete_FieldFunctionImplementation

# Register FieldFunctionImplementation in _func:
_func.FieldFunctionImplementation_swigregister(FieldFunctionImplementation)
class _FieldFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._FieldFunctionImplementationTypedInterfaceObject_swiginit(self, _func.new__FieldFunctionImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._FieldFunctionImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._FieldFunctionImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._FieldFunctionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._FieldFunctionImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._FieldFunctionImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__FieldFunctionImplementationTypedInterfaceObject

# Register _FieldFunctionImplementationTypedInterfaceObject in _func:
_func._FieldFunctionImplementationTypedInterfaceObject_swigregister(_FieldFunctionImplementationTypedInterfaceObject)
class FieldFunction(_FieldFunctionImplementationTypedInterfaceObject):
    r"""
    Function mapping a field to a field.

    Parameters
    ----------
    inputMesh : :class:`~openturns.Mesh`
        The input mesh
    inputDim : int, :math:`\geq 1`
        Dimension :math:`d` of the values of the input field
    outputMesh : :class:`~openturns.Mesh`
        The output mesh
    outputDim : int, :math:`\geq 1`
        Dimension :math:`d'` of the values of the output field

    Notes
    -----
    Field functions act on fields to produce fields:

    .. math::

        f: \left| \begin{array}{rcl}
                    \cM_N \times (\Rset^d)^N & \rightarrow & \cM_{N'} \times (\Rset^{d'})^{N'} \\
                    F & \mapsto & F'
                  \end{array} \right.

    with  :math:`\cM_N` a mesh of :math:`\cD \subset \Rset^n`,  :math:`\cM_{N'}` a mesh of :math:`\cD' \subset \Rset^{n'}`.

    A field is represented by a collection :math:`(\vect{t}_i, \vect{v}_i)_{1 \leq i \leq N}`
    of elements of :math:`\cM_N \times (\Rset^d)^N` where :math:`\vect{t}_i` is a vertex
    of :math:`\cM_N` and :math:`\vect{v}_i` the associated value in :math:`\Rset^d`.

    The constructor builds an object which evaluation operator is not defined (it throws a *NotYetImplementedException*).
    The instantiation of such an object is used to extract an actual :class:`~openturns.FieldFunction` from a  :class:`~openturns.Study`.

    See also
    --------
    PythonFieldFunction, OpenTURNSPythonFieldFunction 


    Examples
    --------
    >>> import openturns as ot

    Using the class :class:`~openturns.OpenTURNSPythonFieldFunction` allows one to define a persistent state between the evaluations of the function.

    >>> class FUNC(ot.OpenTURNSPythonFieldFunction):
    ...     def __init__(self):
    ...         # first argument:
    ...         mesh = ot.RegularGrid(0.0, 0.1, 11)
    ...         super(FUNC, self).__init__(mesh, 2, mesh, 2)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T', 'U'])
    ...     def _exec(self, X):
    ...         Xs = ot.Sample(X)
    ...         Y = Xs * ([2.0]*Xs.getDimension())
    ...         return Y
    >>> F = FUNC()

    Create the associated FieldFunction: 

    >>> myFunc = ot.FieldFunction(F)

    It is also possible to create a FieldFunction from a python function as follows:

    >>> mesh = ot.RegularGrid(0.0, 0.1, 11)
    >>> def myPyFunc(X):
    ...     Xs = ot.Sample(X)
    ...     values = Xs * ([2.0]*Xs.getDimension())
    ...     return values
    >>> inputDim = 2
    >>> outputDim = 2
    >>> myFunc = ot.PythonFieldFunction(mesh, inputDim, mesh, outputDim, myPyFunc)

    Evaluate the function on a field:

    >>> X = ot.Field(mesh, ot.Normal(2).getSample(11))
    >>> Y = myFunc(X)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.FieldFunction___eq__(self, *args)

    def __repr__(self):
        return _func.FieldFunction___repr__(self)

    def __str__(self, *args):
        return _func.FieldFunction___str__(self, *args)

    def __call__(self, *args):
        return _func.FieldFunction___call__(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d'`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        fieldFunction : :class:`~openturns.FieldFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.FieldFunction_getMarginal(self, *args)

    def getInputDimension(self):
        r"""
        Get the dimension of the input field values.

        Returns
        -------
        d : int
            Dimension :math:`d` of the input field values.
        """
        return _func.FieldFunction_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the output field values.

        Returns
        -------
        d' : int
            Dimension :math:`d'` of the output field values.
        """
        return _func.FieldFunction_getOutputDimension(self)

    def setInputMesh(self, inputMesh):
        r"""
        Set the mesh associated to the input domain.

        Parameters
        ----------
        inputMesh : :class:`~openturns.Mesh`
            The input mesh :math:`\cM_{N'}`.
        """
        return _func.FieldFunction_setInputMesh(self, inputMesh)

    def getInputMesh(self):
        r"""
        Get the mesh associated to the input domain.

        Returns
        -------
        inputMesh : :class:`~openturns.Mesh`
            The input mesh :math:`\cM_{N'}`.
        """
        return _func.FieldFunction_getInputMesh(self)

    def setOutputMesh(self, outputMesh):
        r"""
        Set the mesh associated to the output domain.

        Parameters
        ----------
        outputMesh : :class:`~openturns.Mesh`
            The output mesh :math:`\cM_{N'}`.
        """
        return _func.FieldFunction_setOutputMesh(self, outputMesh)

    def getOutputMesh(self):
        r"""
        Get the mesh associated to the output domain.

        Returns
        -------
        outputMesh : :class:`~openturns.Mesh`
            The output mesh :math:`\cM_{N'}`.
        """
        return _func.FieldFunction_getOutputMesh(self)

    def isActingPointwise(self):
        r"""
        Whether the function acts point-wise.

        Returns
        -------
        pointWise : bool
            Returns true if the function evaluation at each vertex depends only on the
            vertex or the value at the vertex.
        """
        return _func.FieldFunction_isActingPointwise(self)

    def getInputDescription(self):
        r"""
        Get the description of the input field values.

        Returns
        -------
        inputDescription : :class:`~openturns.Description`
            Description of the input field values.
        """
        return _func.FieldFunction_getInputDescription(self)

    def getOutputDescription(self):
        r"""
        Get the description of the output field values.

        Returns
        -------
        outputDescription : :class:`~openturns.Description`
            Description of the output field values.
        """
        return _func.FieldFunction_getOutputDescription(self)

    def getCallsNumber(self):
        r"""
        Get the number of calls of the function.

        Returns
        -------
        callsNumber : int
            Counts the number of times the function has been called since its
            creation.
        """
        return _func.FieldFunction_getCallsNumber(self)

    def __init__(self, *args):
        _func.FieldFunction_swiginit(self, _func.new_FieldFunction(*args))
    __swig_destroy__ = _func.delete_FieldFunction

# Register FieldFunction in _func:
_func.FieldFunction_swigregister(FieldFunction)

# We have to make sure the submodule is loaded with absolute path
import openturns.geom

class OpenTURNSPythonFieldFunction:
    r"""
    Override FieldFunction from Python.

    Parameters
    ----------
    inputMesh : :class:`~openturns.Mesh`
        The input mesh
    inputDim : int, :math:`\geq 1`
        Dimension :math:`d` of the values of the input field
    outputMesh : :class:`~openturns.Mesh`
        The output mesh
    outputDim : int, :math:`\geq 1`
        Dimension :math:`d'` of the values of the output field

    Notes
    -----
    You have to overload the function:
        _exec(X): single evaluation, X is a :class:`~openturns.Field`,
        returns a :class:`~openturns.Field`

    Examples
    --------
    >>> import openturns as ot
    >>> mesh = ot.Mesh(1)
    >>> class FUNC(ot.OpenTURNSPythonFieldFunction):
    ...     def __init__(self):
    ...         # first argument:
    ...         super(FUNC, self).__init__(mesh, 2, mesh, 2)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T', 'U'])
    ...     def _exec(self, X):
    ...         Y = ot.Field(self.getOutputMesh(), X.getValues() * ([2.0]*X.getValues().getDimension()))
    ...         return Y
    >>> F = FUNC()

    Create the associated FieldFunction: 

    >>> myFunc = ot.FieldFunction(F)
    """
    def __init__(self, inputMesh, inputDim, outputMesh, outputDim):
        if not isinstance(inputMesh, openturns.geom.Mesh):
            raise TypeError('inputMesh argument is not a Mesh.')
        self.__inputMesh = inputMesh
        try:
            self.__inputDim = int(inputDim)
        except:
            raise TypeError('inputDim argument is not an integer.')
        if not isinstance(outputMesh, openturns.geom.Mesh):
            raise TypeError('outputMesh argument is not a Mesh.')
        self.__outputMesh = outputMesh
        try:
            self.__outputDim = int(outputDim)
        except:
            raise TypeError('outputDim argument is not an integer.')
        self.__descIn = ['x' + str(i) for i in range(inputDim)]
        self.__descOut = ['y' + str(i) for i in range(outputDim)]

    def setInputDescription(self, descIn):
        if (len(descIn) != self.__inputDim):
            raise ValueError('Input description size does NOT match input dimension')
        self.__descIn = descIn

    def getInputDescription(self):
        return self.__descIn

    def setOutputDescription(self, descOut):
        if (len(descOut) != self.__outputDim):
            raise ValueError('Output description size does NOT match output dimension')
        self.__descOut = descOut

    def getOutputDescription(self):
        return self.__descOut

    def getInputDimension(self):
        return self.__inputDim

    def getOutputDimension(self):
        return self.__outputDim

    def getInputMesh(self):
        return self.__inputMesh

    def getOutputMesh(self):
        return self.__outputMesh

    def __str__(self):
        return f"OpenTURNSPythonFieldFunction( {self.__descIn} #{self.__inputDim} ) -> {self.__descOut} #{self.__outputDim}"

    def __repr__(self):
        return self.__str__()

    def __call__(self, X):
        Y = None
        if isinstance(X, ProcessSample):
            Y = self._exec_sample(X)
        else:
            Y = self._exec(X)
        return Y

    def _exec(self, X):
        raise RuntimeError('You must define a method _exec(X) -> Y, where X and Y are Fields objects')

    def _exec_sample(self, X):
        res = ProcessSample(self.getOutputMesh(), 0, self.getOutputDimension())
        for i in range(len(X)):
            res.add(self._exec(X[i]))
        return res

    def _exec_point_on_exec_sample(self, X):
        """Implement exec from exec_sample."""
        return self._exec_sample([X])[0]

class PythonFieldFunction(FieldFunction):
    r"""
    Override FieldFunction from Python.

    Parameters
    ----------
    inputMesh : :class:`~openturns.Mesh`
        The input mesh
    inputDim : int, :math:`\geq 1`
        Dimension :math:`d` of the values of the input field
    outputMesh : :class:`~openturns.Mesh`
        The output mesh
    outputDim : int, :math:`\geq 1`
        Dimension :math:`d'` of the values of the output field 
    func : a callable python object
        called on a :class:`~openturns.Field` object.
        Returns a :class:`~openturns.Field`.
        Default is None.

    Examples
    --------
    >>> import openturns as ot
    >>> mesh = ot.Mesh(1)
    >>> def myPyFunc(X):
    ...     mesh = X.getMesh()
    ...     values = X.getValues() * ([2.0]*X.getValues().getDimension())
    ...     values.setDescription(ot.Description.BuildDefault(values.getDimension(), 'Y'))
    ...     Y = ot.Field(mesh, values)
    ...     return Y
    >>> inputDim = 2
    >>> outputDim = 2
    >>> myFunc = ot.PythonFieldFunction(mesh, inputDim, mesh, outputDim, myPyFunc)
    """
    def __new__(self, inputMesh, inputDim, outputMesh, outputDim, func=None):
        if func is None:
            raise RuntimeError('func not provided.')
        instance = OpenTURNSPythonFieldFunction(inputMesh, inputDim, outputMesh, outputDim)
        if func is not None:
            if not callable(func):
                raise RuntimeError('func argument is not callable.')
            instance._exec = func
        return FieldFunction(instance)



class FieldToPointFunctionImplementation(openturns.common.PersistentObject):
    r"""
    Function mapping a field into a point.

    Parameters
    ----------
    inputMesh : :class:`~openturns.Mesh`
        The input mesh
    inputDim : positive int
        Dimension of the input field values d
    outputDim : positive int
        Dimension of the output vector d'

    Notes
    -----
    Field to point functions  act on fields to produce points:

    .. math::

        f: \left| \begin{array}{rcl}
                    \cM_N \times (\Rset^d)^N & \rightarrow &\Rset^{d'} \\
                    F & \mapsto & \vect{v}'
                  \end{array} \right.

    with  :math:`\cM_N` a mesh of :math:`\cD \subset \Rset^n`.

    A field is represented by a collection :math:`(\vect{t}_i, \vect{v}_i)_{1 \leq i \leq N}`
    of elements of :math:`\cM_N \times (\Rset^d)^N` where :math:`\vect{t}_i` is a vertex of :math:`\cM_N` and :math:`\vect{v}_i` the associated value in :math:`\Rset^d`.

    The two first constructors build an object which evaluation operator is not defined (it throws a *NotYetImplementedException*).
    The instantiation of such an object is used to extract an actual :class:`~openturns.FieldToPointFunction` from a  :class:`~openturns.Study`.

    See also
    --------
    PythonFieldToPointFunction, OpenTURNSPythonFieldToPointFunction, PointToFieldFunction 

    Examples
    --------
    >>> import openturns as ot

    Use the class :class:`~openturns.OpenTURNSPythonFieldToPointFunction` to create a function
    that acts on fields of input dimension :math:`n=1` and input dimension :math:`d=2`
    and returns their spatial mean vector of dimension :math:`d'=2`.

    Using the class :class:`~openturns.OpenTURNSPythonFieldToPointFunction` allows one to define a persistent state between the evaluations of the function.

    >>> class FUNC(ot.OpenTURNSPythonFieldToPointFunction):
    ...     def __init__(self):
    ...         # first argument:
    ...         mesh = ot.RegularGrid(0.0, 0.1, 11)
    ...         super(FUNC, self).__init__(mesh, 2, 2)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T', 'U'])  
    ...     def _exec(self, X):
    ...         Xs = ot.Sample(X)
    ...         Y = Xs.computeMean()
    ...         return Y
    >>> F = FUNC()

    Create the associated FieldToPointFunction: 

    >>> myFunc = ot.FieldToPointFunction(F)

    It is also possible to create a FieldToPointFunction from a python function as follows:

    >>> def myPyFunc(X):
    ...     Xs = ot.Sample(X)
    ...     Y = Xs.computeMean()
    ...     return Y
    >>> inputDim = 2
    >>> outputDim = 2
    >>> mesh = ot.RegularGrid(0.0, 0.1, 11)
    >>> myFunc = ot.PythonFieldToPointFunction(mesh, inputDim, outputDim, myPyFunc)

    Evaluate the function on a field:

    >>> myField = ot.Field(mesh, ot.Normal(2).getSample(11))
    >>> Y = myFunc(myField)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldToPointFunctionImplementation_getClassName(self)

    def __eq__(self, other):
        return _func.FieldToPointFunctionImplementation___eq__(self, other)

    def __repr__(self):
        return _func.FieldToPointFunctionImplementation___repr__(self)

    def __str__(self, *args):
        return _func.FieldToPointFunctionImplementation___str__(self, *args)

    def __call__(self, *args):
        return _func.FieldToPointFunctionImplementation___call__(self, *args)

    def getInputMesh(self):
        r"""
        Get the mesh associated to the input domain.

        Returns
        -------
        inputMesh : :class:`~openturns.Mesh`
            The input mesh :math:`\cM_{N'}`.
        """
        return _func.FieldToPointFunctionImplementation_getInputMesh(self)

    def getInputDimension(self):
        r"""
        Get the dimension of the input field values.

        Returns
        -------
        d : int
            Dimension :math:`d` of the input field values.
        """
        return _func.FieldToPointFunctionImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the output vector.

        Returns
        -------
        d' : int
            Dimension :math:`d'` of the output vector.
        """
        return _func.FieldToPointFunctionImplementation_getOutputDimension(self)

    def setInputDescription(self, inputDescription):
        r"""
        Set the description of the input field values.

        Parameters
        ----------
        inputDescription : sequence of str
            Description of the input field values.
        """
        return _func.FieldToPointFunctionImplementation_setInputDescription(self, inputDescription)

    def getInputDescription(self):
        r"""
        Get the description of the input field values.

        Returns
        -------
        inputDescription : :class:`~openturns.Description`
            Description of the input field values.
        """
        return _func.FieldToPointFunctionImplementation_getInputDescription(self)

    def setOutputDescription(self, outputDescription):
        r"""
        Set the description of the output vector.

        Parameters
        ----------
        outputDescription : sequence of str
            Description of the output vector.
        """
        return _func.FieldToPointFunctionImplementation_setOutputDescription(self, outputDescription)

    def getOutputDescription(self):
        r"""
        Get the description of the output vector.

        Returns
        -------
        outputDescription : :class:`~openturns.Description`
            Description of the output vector.
        """
        return _func.FieldToPointFunctionImplementation_getOutputDescription(self)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        function : :class:`~openturns.FieldToPointFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.FieldToPointFunctionImplementation_getMarginal(self, *args)

    def getCallsNumber(self):
        r"""
        Get the number of calls of the function.

        Returns
        -------
        callsNumber : int
            Counts the number of times the function has been called since its
            creation.
        """
        return _func.FieldToPointFunctionImplementation_getCallsNumber(self)

    def __init__(self, *args):
        _func.FieldToPointFunctionImplementation_swiginit(self, _func.new_FieldToPointFunctionImplementation(*args))
    __swig_destroy__ = _func.delete_FieldToPointFunctionImplementation

# Register FieldToPointFunctionImplementation in _func:
_func.FieldToPointFunctionImplementation_swigregister(FieldToPointFunctionImplementation)
class _FieldToPointFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._FieldToPointFunctionImplementationTypedInterfaceObject_swiginit(self, _func.new__FieldToPointFunctionImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._FieldToPointFunctionImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._FieldToPointFunctionImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._FieldToPointFunctionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._FieldToPointFunctionImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._FieldToPointFunctionImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__FieldToPointFunctionImplementationTypedInterfaceObject

# Register _FieldToPointFunctionImplementationTypedInterfaceObject in _func:
_func._FieldToPointFunctionImplementationTypedInterfaceObject_swigregister(_FieldToPointFunctionImplementationTypedInterfaceObject)
class FieldToPointFunction(_FieldToPointFunctionImplementationTypedInterfaceObject):
    r"""
    Function mapping a field into a point.

    Parameters
    ----------
    inputMesh : :class:`~openturns.Mesh`
        The input mesh
    inputDim : positive int
        Dimension of the input field values d
    outputDim : positive int
        Dimension of the output vector d'

    Notes
    -----
    Field to point functions  act on fields to produce points:

    .. math::

        f: \left| \begin{array}{rcl}
                    \cM_N \times (\Rset^d)^N & \rightarrow &\Rset^{d'} \\
                    F & \mapsto & \vect{v}'
                  \end{array} \right.

    with  :math:`\cM_N` a mesh of :math:`\cD \subset \Rset^n`.

    A field is represented by a collection :math:`(\vect{t}_i, \vect{v}_i)_{1 \leq i \leq N}`
    of elements of :math:`\cM_N \times (\Rset^d)^N` where :math:`\vect{t}_i` is a vertex of :math:`\cM_N` and :math:`\vect{v}_i` the associated value in :math:`\Rset^d`.

    The two first constructors build an object which evaluation operator is not defined (it throws a *NotYetImplementedException*).
    The instantiation of such an object is used to extract an actual :class:`~openturns.FieldToPointFunction` from a  :class:`~openturns.Study`.

    See also
    --------
    PythonFieldToPointFunction, OpenTURNSPythonFieldToPointFunction, PointToFieldFunction 

    Examples
    --------
    >>> import openturns as ot

    Use the class :class:`~openturns.OpenTURNSPythonFieldToPointFunction` to create a function
    that acts on fields of input dimension :math:`n=1` and input dimension :math:`d=2`
    and returns their spatial mean vector of dimension :math:`d'=2`.

    Using the class :class:`~openturns.OpenTURNSPythonFieldToPointFunction` allows one to define a persistent state between the evaluations of the function.

    >>> class FUNC(ot.OpenTURNSPythonFieldToPointFunction):
    ...     def __init__(self):
    ...         # first argument:
    ...         mesh = ot.RegularGrid(0.0, 0.1, 11)
    ...         super(FUNC, self).__init__(mesh, 2, 2)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T', 'U'])  
    ...     def _exec(self, X):
    ...         Xs = ot.Sample(X)
    ...         Y = Xs.computeMean()
    ...         return Y
    >>> F = FUNC()

    Create the associated FieldToPointFunction: 

    >>> myFunc = ot.FieldToPointFunction(F)

    It is also possible to create a FieldToPointFunction from a python function as follows:

    >>> def myPyFunc(X):
    ...     Xs = ot.Sample(X)
    ...     Y = Xs.computeMean()
    ...     return Y
    >>> inputDim = 2
    >>> outputDim = 2
    >>> mesh = ot.RegularGrid(0.0, 0.1, 11)
    >>> myFunc = ot.PythonFieldToPointFunction(mesh, inputDim, outputDim, myPyFunc)

    Evaluate the function on a field:

    >>> myField = ot.Field(mesh, ot.Normal(2).getSample(11))
    >>> Y = myFunc(myField)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldToPointFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.FieldToPointFunction___eq__(self, *args)

    def __repr__(self):
        return _func.FieldToPointFunction___repr__(self)

    def __str__(self, *args):
        return _func.FieldToPointFunction___str__(self, *args)

    def __call__(self, *args):
        return _func.FieldToPointFunction___call__(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        function : :class:`~openturns.FieldToPointFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.FieldToPointFunction_getMarginal(self, *args)

    def getInputMesh(self):
        r"""
        Get the mesh associated to the input domain.

        Returns
        -------
        inputMesh : :class:`~openturns.Mesh`
            The input mesh :math:`\cM_{N'}`.
        """
        return _func.FieldToPointFunction_getInputMesh(self)

    def getInputDimension(self):
        r"""
        Get the dimension of the input field values.

        Returns
        -------
        d : int
            Dimension :math:`d` of the input field values.
        """
        return _func.FieldToPointFunction_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the output vector.

        Returns
        -------
        d' : int
            Dimension :math:`d'` of the output vector.
        """
        return _func.FieldToPointFunction_getOutputDimension(self)

    def getInputDescription(self):
        r"""
        Get the description of the input field values.

        Returns
        -------
        inputDescription : :class:`~openturns.Description`
            Description of the input field values.
        """
        return _func.FieldToPointFunction_getInputDescription(self)

    def setInputDescription(self, inputDescription):
        r"""
        Set the description of the input field values.

        Parameters
        ----------
        inputDescription : sequence of str
            Description of the input field values.
        """
        return _func.FieldToPointFunction_setInputDescription(self, inputDescription)

    def getOutputDescription(self):
        r"""
        Get the description of the output vector.

        Returns
        -------
        outputDescription : :class:`~openturns.Description`
            Description of the output vector.
        """
        return _func.FieldToPointFunction_getOutputDescription(self)

    def setOutputDescription(self, outputDescription):
        r"""
        Set the description of the output vector.

        Parameters
        ----------
        outputDescription : sequence of str
            Description of the output vector.
        """
        return _func.FieldToPointFunction_setOutputDescription(self, outputDescription)

    def getCallsNumber(self):
        r"""
        Get the number of calls of the function.

        Returns
        -------
        callsNumber : int
            Counts the number of times the function has been called since its
            creation.
        """
        return _func.FieldToPointFunction_getCallsNumber(self)

    def __init__(self, *args):
        _func.FieldToPointFunction_swiginit(self, _func.new_FieldToPointFunction(*args))
    __swig_destroy__ = _func.delete_FieldToPointFunction

# Register FieldToPointFunction in _func:
_func.FieldToPointFunction_swigregister(FieldToPointFunction)


class OpenTURNSPythonFieldToPointFunction:
    """
    Override FieldToPointFunction from Python.

    Parameters
    ----------
    inputMesh : :class:`~openturns.Mesh`
        The input mesh
    inputDim : positive int
        Dimension of the input field values d
    outputDim : positive int
        Dimension of the output vector d'

    Notes
    -----
    You have to overload the function:
        _exec(X): single evaluation, X is a :class:`~openturns.Field`,
        returns a :class:`~openturns.Field`

    Examples
    --------
    >>> import openturns as ot
    >>> mesh = ot.Mesh(1)
    >>> class FUNC(ot.OpenTURNSPythonFieldToPointFunction):
    ...    def __init__(self):
    ...         # first argument:
    ...         super(FUNC, self).__init__(mesh, 2, 2)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T', 'U'])
    ...    def _exec(self, X):
    ...         Y = ot.Sample(X).computeMean()
    ...         return Y
    >>> F = FUNC()
    """
    def __init__(self, inputMesh, inputDim, outputDim):
        if not isinstance(inputMesh, openturns.geom.Mesh):
            raise TypeError('inputMesh argument is not a Mesh.')
        self.__inputMesh = inputMesh
        try:
            self.__inputDim = int(inputDim)
        except:
            raise TypeError('inputDim argument is not an integer.')
        try:
            self.__outputDim = int(outputDim)
        except:
            raise TypeError('outputDim argument is not an integer.')
        self.__descIn = ['x' + str(i) for i in range(inputDim)]
        self.__descOut = ['y' + str(i) for i in range(outputDim)]

    def setInputDescription(self, descIn):
        if (len(descIn) != self.__inputDim):
            raise ValueError('Input description size does NOT match input dimension')
        self.__descIn = descIn

    def getInputDescription(self):
        return self.__descIn

    def setOutputDescription(self, descOut):
        if (len(descOut) != self.__outputDim):
            raise ValueError('Output description size does NOT match output dimension')
        self.__descOut = descOut

    def getOutputDescription(self):
        return self.__descOut

    def getInputDimension(self):
        return self.__inputDim

    def getOutputDimension(self):
        return self.__outputDim

    def getInputMesh(self):
        return self.__inputMesh

    def __str__(self):
        return f"OpenTURNSPythonFieldToPointFunction( {self.__descIn} #{self.__inputDim} ) -> {self.__descOut} #{self.__outputDim}"

    def __repr__(self):
        return self.__str__()

    def __call__(self, X):
        Y = None
        if isinstance(X, ProcessSample):
            Y = self._exec_sample(X)
        else:
            Y = self._exec(X)
        return Y

    def _exec(self, X):
        raise RuntimeError('You must define a method _exec(X) -> Y, where X is a Field object and Y a Point object')

    def _exec_sample(self, X):
        res = list()
        for i in range(len(X)):
            res.append(self._exec(X[i]))
        return res

    def _exec_point_on_exec_sample(self, X):
        """Implement exec from exec_sample."""
        return self._exec_sample([X])[0]

class PythonFieldToPointFunction(FieldToPointFunction):
    """
    Override FieldToPointFunction from Python.

    Parameters
    ----------
    inputMesh : :class:`~openturns.Mesh`
        The input mesh
    inputDim : positive int
        Dimension of the input field values d
    outputDim : positive int
        Dimension of the output vector d'
    func : a callable python object
        called on a :class:`~openturns.Field` object.
        Returns a :class:`~openturns.Field`.
        Default is None.

    Examples
    --------
    >>> import openturns as ot
    >>> mesh = ot.Mesh(1)
    >>> def myPyFunc(X):
    ...     Y = ot.Sample(X).computeMean()
    ...     return Y
    >>> inputDim = 2
    >>> outputDim = 2
    >>> myFunc = ot.PythonFieldToPointFunction(mesh, inputDim, outputDim, myPyFunc)
    """
    def __new__(self, inputMesh, inputDim, outputDim, func=None):
        if func is None:
            raise RuntimeError('func not provided.')
        instance = OpenTURNSPythonFieldToPointFunction(inputMesh, inputDim, outputDim)
        if func is not None:
            if not callable(func):
                raise RuntimeError('func argument is not callable.')
            instance._exec = func
        return FieldToPointFunction(instance)



class PointToFieldFunctionImplementation(openturns.common.PersistentObject):
    r"""
    Function mapping a point into a field.

    Parameters
    ----------
    inputDim : int, :math:`\geq 1`
        Dimension :math:`d` of the input vector
    outputMesh : :class:`~openturns.Mesh`
        The output mesh
    outputDim : int, :math:`\geq 1`
        Dimension :math:`d'` of the output field

    Notes
    -----
    Point to field functions act on points to produce fields:

    .. math::

        f: \left| \begin{array}{rcl}
                   \Rset^{d} &  \rightarrow & \cM_{N'} \times (\Rset^{d'})^{N'}  \\
                    \vect{v} & \mapsto  & F' 
                  \end{array} \right.

    with  :math:`\cM_{N'}` a mesh of :math:`\cD' \subset \Rset^{n'}`.

    A field is represented by a collection :math:`(\vect{t}'_i, \vect{v}'_i)_{1 \leq i \leq N'}` of elements of :math:`\cM_{N'} \times (\Rset^{d'})^{N'}` where :math:`\vect{t}'_i` is a vertex of :math:`\cM_{N'}` and :math:`\vect{v}'_i` the associated value in :math:`\Rset^{d'}`.

    The two first constructors build an object which evaluation operator is not defined (it throws a *NotYetImplementedException*).
    The instantiation of such an object is used to extract an actual :class:`~openturns.PointToFieldFunction` from a  :class:`~openturns.Study`.

    See also
    --------
    PythonPointToFieldFunction, OpenTURNSPythonPointToFieldFunction, FieldToPointFunction 

    Examples
    --------
    >>> import openturns as ot

    Use the class :class:`~openturns.OpenTURNSPythonPointToFieldFunction` to create a function that acts a vector :math:`\vect{v}` of dimension :math:`d=2` and returns a field defined by:

        - the mesh that discretizes :math:`[0, 1]` into 10 regular intervals of length 0.1 (:math:`n=1`)
        - the value associated to the vertex number :math:`i` is :math:`\vect{v}'_i = i*\vect{v}` (:math:`d'=2`)

    Using the class :class:`~openturns.OpenTURNSPythonFieldToPointFunction` allows one to define a persistent state between the evaluations of the function.

    >>> class FUNC(ot.OpenTURNSPythonPointToFieldFunction):
    ...     def __init__(self):
    ...         mesh = ot.RegularGrid(0.0, 0.1, 11)
    ...         super(FUNC, self).__init__(2, mesh, 2)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T', 'U'])
    ...     def _exec(self, X):
    ...         size = self.getOutputMesh().getVerticesNumber()
    ...         Y = [ot.Point(X)*i for i in range(size)]
    ...         return Y
    >>> F = FUNC()

    Create the associated PointToFieldFunction: 

    >>> myFunc = ot.PointToFieldFunction(F)

    It is also possible to create a PointToFieldFunction from a python function as follows: 

    >>> mesh = ot.RegularGrid(0.0, 0.1, 11)
    >>> def myPyFunc(X):
    ...     size = 11
    ...     Y = [ot.Point(X)*i for i in range(size)]
    ...     return Y
    >>> inputDim = 2
    >>> outputDim = 2
    >>> myFunc = ot.PythonPointToFieldFunction(inputDim, mesh, outputDim, myPyFunc)

    Evaluation the function on a vector:

    >>> Yfield = myFunc([1.1, 2.2])

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PointToFieldFunctionImplementation_getClassName(self)

    def __eq__(self, *args):
        return _func.PointToFieldFunctionImplementation___eq__(self, *args)

    def __repr__(self):
        return _func.PointToFieldFunctionImplementation___repr__(self)

    def __str__(self, *args):
        return _func.PointToFieldFunctionImplementation___str__(self, *args)

    def __call__(self, *args):
        return _func.PointToFieldFunctionImplementation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Get the dimension of the input vector.

        Returns
        -------
        d : int
            Dimension :math:`d` of the input vector.
        """
        return _func.PointToFieldFunctionImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the output field values.

        Returns
        -------
        d' : int
            Dimension :math:`d'` of the output field values.
        """
        return _func.PointToFieldFunctionImplementation_getOutputDimension(self)

    def setInputDescription(self, inputDescription):
        r"""
        Set the description of the input vector.

        Parameters
        ----------
        inputDescription : sequence of str
            Description of the input vector.
        """
        return _func.PointToFieldFunctionImplementation_setInputDescription(self, inputDescription)

    def getInputDescription(self):
        r"""
        Get the description of the input vector.

        Returns
        -------
        inputDescription : :class:`~openturns.Description`
            Description of the input vector.
        """
        return _func.PointToFieldFunctionImplementation_getInputDescription(self)

    def setOutputDescription(self, outputDescription):
        r"""
        Set the description of the output field values.

        Parameters
        ----------
        outputDescription : sequence of str
            Description of the output field values.
        """
        return _func.PointToFieldFunctionImplementation_setOutputDescription(self, outputDescription)

    def getOutputDescription(self):
        r"""
        Get the description of the output field values.

        Returns
        -------
        outputDescription : :class:`~openturns.Description`
            Description of the output field values.
        """
        return _func.PointToFieldFunctionImplementation_getOutputDescription(self)

    def getOutputMesh(self):
        r"""
        Get the output mesh.

        Returns
        -------
        outputMesh : :class:`~openturns.Mesh`
            The mesh :math:`\cM_{N'}` of the output field.
        """
        return _func.PointToFieldFunctionImplementation_getOutputMesh(self)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        function : :class:`~openturns.PointToFieldFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.PointToFieldFunctionImplementation_getMarginal(self, *args)

    def getCallsNumber(self):
        r"""
        Get the number of calls of the function.

        Returns
        -------
        callsNumber : int
            Counts the number of times the function has been called since its
            creation.
        """
        return _func.PointToFieldFunctionImplementation_getCallsNumber(self)

    def __init__(self, *args):
        _func.PointToFieldFunctionImplementation_swiginit(self, _func.new_PointToFieldFunctionImplementation(*args))
    __swig_destroy__ = _func.delete_PointToFieldFunctionImplementation

# Register PointToFieldFunctionImplementation in _func:
_func.PointToFieldFunctionImplementation_swigregister(PointToFieldFunctionImplementation)
class _PointToFieldFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._PointToFieldFunctionImplementationTypedInterfaceObject_swiginit(self, _func.new__PointToFieldFunctionImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._PointToFieldFunctionImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._PointToFieldFunctionImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._PointToFieldFunctionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._PointToFieldFunctionImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._PointToFieldFunctionImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__PointToFieldFunctionImplementationTypedInterfaceObject

# Register _PointToFieldFunctionImplementationTypedInterfaceObject in _func:
_func._PointToFieldFunctionImplementationTypedInterfaceObject_swigregister(_PointToFieldFunctionImplementationTypedInterfaceObject)
class PointToFieldFunction(_PointToFieldFunctionImplementationTypedInterfaceObject):
    r"""
    Function mapping a point into a field.

    Parameters
    ----------
    inputDim : int, :math:`\geq 1`
        Dimension :math:`d` of the input vector
    outputMesh : :class:`~openturns.Mesh`
        The output mesh
    outputDim : int, :math:`\geq 1`
        Dimension :math:`d'` of the output field

    Notes
    -----
    Point to field functions act on points to produce fields:

    .. math::

        f: \left| \begin{array}{rcl}
                   \Rset^{d} &  \rightarrow & \cM_{N'} \times (\Rset^{d'})^{N'}  \\
                    \vect{v} & \mapsto  & F' 
                  \end{array} \right.

    with  :math:`\cM_{N'}` a mesh of :math:`\cD' \subset \Rset^{n'}`.

    A field is represented by a collection :math:`(\vect{t}'_i, \vect{v}'_i)_{1 \leq i \leq N'}` of elements of :math:`\cM_{N'} \times (\Rset^{d'})^{N'}` where :math:`\vect{t}'_i` is a vertex of :math:`\cM_{N'}` and :math:`\vect{v}'_i` the associated value in :math:`\Rset^{d'}`.

    The two first constructors build an object which evaluation operator is not defined (it throws a *NotYetImplementedException*).
    The instantiation of such an object is used to extract an actual :class:`~openturns.PointToFieldFunction` from a  :class:`~openturns.Study`.

    See also
    --------
    PythonPointToFieldFunction, OpenTURNSPythonPointToFieldFunction, FieldToPointFunction 

    Examples
    --------
    >>> import openturns as ot

    Use the class :class:`~openturns.OpenTURNSPythonPointToFieldFunction` to create a function that acts a vector :math:`\vect{v}` of dimension :math:`d=2` and returns a field defined by:

        - the mesh that discretizes :math:`[0, 1]` into 10 regular intervals of length 0.1 (:math:`n=1`)
        - the value associated to the vertex number :math:`i` is :math:`\vect{v}'_i = i*\vect{v}` (:math:`d'=2`)

    Using the class :class:`~openturns.OpenTURNSPythonFieldToPointFunction` allows one to define a persistent state between the evaluations of the function.

    >>> class FUNC(ot.OpenTURNSPythonPointToFieldFunction):
    ...     def __init__(self):
    ...         mesh = ot.RegularGrid(0.0, 0.1, 11)
    ...         super(FUNC, self).__init__(2, mesh, 2)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T', 'U'])
    ...     def _exec(self, X):
    ...         size = self.getOutputMesh().getVerticesNumber()
    ...         Y = [ot.Point(X)*i for i in range(size)]
    ...         return Y
    >>> F = FUNC()

    Create the associated PointToFieldFunction: 

    >>> myFunc = ot.PointToFieldFunction(F)

    It is also possible to create a PointToFieldFunction from a python function as follows: 

    >>> mesh = ot.RegularGrid(0.0, 0.1, 11)
    >>> def myPyFunc(X):
    ...     size = 11
    ...     Y = [ot.Point(X)*i for i in range(size)]
    ...     return Y
    >>> inputDim = 2
    >>> outputDim = 2
    >>> myFunc = ot.PythonPointToFieldFunction(inputDim, mesh, outputDim, myPyFunc)

    Evaluation the function on a vector:

    >>> Yfield = myFunc([1.1, 2.2])

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PointToFieldFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.PointToFieldFunction___eq__(self, *args)

    def __repr__(self):
        return _func.PointToFieldFunction___repr__(self)

    def __str__(self, *args):
        return _func.PointToFieldFunction___str__(self, *args)

    def __call__(self, *args):
        return _func.PointToFieldFunction___call__(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        function : :class:`~openturns.PointToFieldFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.PointToFieldFunction_getMarginal(self, *args)

    def getInputDimension(self):
        r"""
        Get the dimension of the input vector.

        Returns
        -------
        d : int
            Dimension :math:`d` of the input vector.
        """
        return _func.PointToFieldFunction_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the output field values.

        Returns
        -------
        d' : int
            Dimension :math:`d'` of the output field values.
        """
        return _func.PointToFieldFunction_getOutputDimension(self)

    def getOutputMesh(self):
        r"""
        Get the output mesh.

        Returns
        -------
        outputMesh : :class:`~openturns.Mesh`
            The mesh :math:`\cM_{N'}` of the output field.
        """
        return _func.PointToFieldFunction_getOutputMesh(self)

    def setInputDescription(self, inputDescription):
        r"""
        Set the description of the input vector.

        Parameters
        ----------
        inputDescription : sequence of str
            Description of the input vector.
        """
        return _func.PointToFieldFunction_setInputDescription(self, inputDescription)

    def getInputDescription(self):
        r"""
        Get the description of the input vector.

        Returns
        -------
        inputDescription : :class:`~openturns.Description`
            Description of the input vector.
        """
        return _func.PointToFieldFunction_getInputDescription(self)

    def setOutputDescription(self, outputDescription):
        r"""
        Set the description of the output field values.

        Parameters
        ----------
        outputDescription : sequence of str
            Description of the output field values.
        """
        return _func.PointToFieldFunction_setOutputDescription(self, outputDescription)

    def getOutputDescription(self):
        r"""
        Get the description of the output field values.

        Returns
        -------
        outputDescription : :class:`~openturns.Description`
            Description of the output field values.
        """
        return _func.PointToFieldFunction_getOutputDescription(self)

    def getCallsNumber(self):
        r"""
        Get the number of calls of the function.

        Returns
        -------
        callsNumber : int
            Counts the number of times the function has been called since its
            creation.
        """
        return _func.PointToFieldFunction_getCallsNumber(self)

    def __init__(self, *args):
        _func.PointToFieldFunction_swiginit(self, _func.new_PointToFieldFunction(*args))
    __swig_destroy__ = _func.delete_PointToFieldFunction

# Register PointToFieldFunction in _func:
_func.PointToFieldFunction_swigregister(PointToFieldFunction)

# We have to make sure the submodule is loaded with absolute path
import openturns.typ

class OpenTURNSPythonPointToFieldFunction:
    """
    Override PointToFieldFunction from Python.

    Parameters
    ----------
    inputDim : positive int
        Dimension of the input vector d
    outputMesh : :class:`~openturns.Mesh`
        The output mesh
    outputDim : positive int
        Dimension of the output field values d'

    Notes
    -----
    You have to overload the function:
        _exec(X): single evaluation, X is a :class:`~openturns.Field`,
        returns a :class:`~openturns.Field`

    Examples
    --------
    >>> import openturns as ot
    >>> class FUNC(ot.OpenTURNSPythonPointToFieldFunction):
    ...     def __init__(self):
    ...         mesh = ot.RegularGrid(0.0, 0.1, 11)
    ...         super(FUNC, self).__init__(2, mesh, 2)
    ...         self.setInputDescription(['R', 'S'])
    ...         self.setOutputDescription(['T', 'U'])
    ...     def _exec(self, X):
    ...         size = self.getOutputMesh().getVerticesNumber()
    ...         Y = [ot.Point(X)*i for i in range(size)]
    ...         return Y
    >>> F = FUNC()
    """
    def __init__(self, inputDim, outputMesh, outputDim):
        try:
            self.__inputDim = int(inputDim)
        except:
            raise TypeError('inputDim argument is not an integer.')
        if not isinstance(outputMesh, openturns.geom.Mesh):
            raise TypeError('outputMesh argument is not a Mesh.')
        self.__outputMesh = outputMesh
        try:
            self.__outputDim = int(outputDim)
        except:
            raise TypeError('outputDim argument is not an integer.')
        self.__descIn = ['x' + str(i) for i in range(inputDim)]
        self.__descOut = ['y' + str(i) for i in range(outputDim)]

    def setInputDescription(self, descIn):
        if (len(descIn) != self.__inputDim):
            raise ValueError('Input description size does NOT match input dimension')
        self.__descIn = descIn

    def getInputDescription(self):
        return self.__descIn

    def setOutputDescription(self, descOut):
        if (len(descOut) != self.__outputDim):
            raise ValueError('Output description size does NOT match output dimension')
        self.__descOut = descOut

    def getOutputDescription(self):
        return self.__descOut

    def getInputDimension(self):
        return self.__inputDim

    def getOutputDimension(self):
        return self.__outputDim

    def getOutputMesh(self):
        return self.__outputMesh

    def __str__(self):
        return f"OpenTURNSPythonPointToFieldFunction( {self.__descIn} #{self.__inputDim} ) -> {self.__descOut} #{self.__outputDim}"

    def __repr__(self):
        return self.__str__()

    def __call__(self, X):
        Y = None
        try:
            pt = openturns.typ.Point(X)
        except:
            try:
                sp = openturns.typ.Sample(X)
            except:
                raise TypeError('Expect a Point or a Sample as argument')
            else:
                Y = self._exec_sample(sp)
        else:
            Y = self._exec(pt)
        return Y

    def _exec(self, X):
        raise RuntimeError('You must define a method _exec(X) -> Y, where X is a Point object and Y a Field object')

    def _exec_sample(self, X):
        res = ProcessSample(self.getOutputMesh(), 0, self.getOutputDimension())
        for i in range(len(X)):
            res.add(self._exec(X[i]))
        return res

    def _exec_point_on_exec_sample(self, X):
        """Implement exec from exec_sample."""
        return self._exec_sample([X])[0]

class PythonPointToFieldFunction(PointToFieldFunction):
    """
    Override PointToFieldFunction from Python.

    Parameters
    ----------
    inputDim : positive int
        Dimension of the input vector d
    outputMesh : :class:`~openturns.Mesh`
        The output mesh
    outputDim : positive int
        Dimension of the output field values d'
    func : a callable python object
        called on a :class:`~openturns.Field` object.
        Returns a :class:`~openturns.Field`.
        Default is None.

    Examples
    --------
    >>> import openturns as ot
    >>> mesh = ot.RegularGrid(0.0, 0.1, 11)
    >>> def  myPyFunc(X):
    ...     size = 11
    ...     Y = [ot.Point(X)*i for i in range(size)]
    ...     return Y
    >>> inputDim = 2
    >>> outputDim = 2
    >>> myFunc = ot.PythonPointToFieldFunction(inputDim, mesh, outputDim, myPyFunc)

    Evaluation on a vector:

    >>> Yfield = myFunc([1.1, 2.2])
    """
    def __new__(self, inputDim, outputMesh, outputDim, func=None):
        if func is None:
            raise RuntimeError('func not provided.')
        instance = OpenTURNSPythonPointToFieldFunction(inputDim, outputMesh, outputDim)
        if func is not None:
            if not callable(func):
                raise RuntimeError('func argument is not callable.')
            instance._exec = func
        return PointToFieldFunction(instance)



class ParametricPointToFieldFunction(PointToFieldFunctionImplementation):
    r"""
    Parametric Point to Field function.

    It defines a parametric function from *function* by freezing the variables
    marked by the *indices* set to the values of *referencePoint*.

    Parameters
    ----------
    function : :class:`~openturns.PointToFieldFunction`
        Function with full parameters from which the parametric function is built.
    indices : sequence of int
        Indices of the frozen variables.
    referencePoint : sequence of float
        Values of the frozen variables.
        Must be of size of *indices*.

    Examples
    --------
    >>> import openturns as ot
    >>> size = 5
    >>> mesh = ot.RegularGrid(0.0, 0.1, size)
    >>> def f(X):
    ...     Y = [ot.Point(X)*i for i in range(size)]
    ...     return Y
    >>> inputDim = 2
    >>> outputDim = 2
    >>> function = ot.PythonPointToFieldFunction(inputDim, mesh, outputDim, f)

    Then create another function by freezing the parameter x2=5.0:

    >>> g = ot.ParametricPointToFieldFunction(function, [1], [5.0])
    >>> print(g.getInputDescription())
    [x0]
    >>> print(g([1.0]))
        [ y0 y1 ]
    0 : [  0  0 ]
    1 : [  1  5 ]
    2 : [  2 10 ]
    3 : [  3 15 ]
    4 : [  4 20 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricPointToFieldFunction_getClassName(self)

    def __init__(self, *args):
        _func.ParametricPointToFieldFunction_swiginit(self, _func.new_ParametricPointToFieldFunction(*args))

    def getParametersPositions(self):
        r"""
        Parameters positions accessor.

        Returns
        -------
        parameters_positions : :class:`~openturns.Indices`
            Positions of the parameters in the underlying function.
        """
        return _func.ParametricPointToFieldFunction_getParametersPositions(self)

    def getInputPositions(self):
        r"""
        Indices positions accessor.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Positions of the inputs in the underlying function.
        """
        return _func.ParametricPointToFieldFunction_getInputPositions(self)

    def getFunction(self):
        r"""
        Function accessor.

        Returns
        -------
        function : :class:`~openturns.PointToFieldFunction`
            Function with full parameters from which the parametric function is built.
        """
        return _func.ParametricPointToFieldFunction_getFunction(self)

    def setParameter(self, parameter):
        r"""
        Parameter accessor.

        Parameters
        ----------
        parameter : :class:`~openturns.Point`
            Parameter value.
        """
        return _func.ParametricPointToFieldFunction_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Parameter accessor.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter value.
        """
        return _func.ParametricPointToFieldFunction_getParameter(self)

    def __call__(self, *args):
        return _func.ParametricPointToFieldFunction___call__(self, *args)

    def getInputDimension(self):
        r"""
        Get the dimension of the input vector.

        Returns
        -------
        d : int
            Dimension :math:`d` of the input vector.
        """
        return _func.ParametricPointToFieldFunction_getInputDimension(self)

    def __repr__(self):
        return _func.ParametricPointToFieldFunction___repr__(self)

    def __str__(self, *args):
        return _func.ParametricPointToFieldFunction___str__(self, *args)
    __swig_destroy__ = _func.delete_ParametricPointToFieldFunction

# Register ParametricPointToFieldFunction in _func:
_func.ParametricPointToFieldFunction_swigregister(ParametricPointToFieldFunction)
class VertexValuePointToFieldFunction(PointToFieldFunctionImplementation):
    r"""
    Function mapping a (vertex, value) point to a field.

    Parameters
    ----------
    g : :class:`~openturns.Function`
        Function :math:`g: \Rset^n \times \Rset^d \rightarrow \Rset^{d'}`.
    mesh : :class:`~openturns.Mesh`
        Mesh on which the function is defined.

    Notes
    -----
    Let us note :math:`g : \Rset^{d} \rightarrow \Rset^{d'}` a function, :math:`\cM_N` a mesh of :math:`\cD \subset \Rset^{p}`. Vertex value (point to field) functions are particular functions that map the field :math:`F = (\vect{t}_i, \vect{v}_i)_{1 \leq i \leq N}` onto  :math:`F'` relying on the `g` function such as: 

    .. math:

         \forall \vect{t}_i \in \cM_N, \quad \vect{v} \in \Rset^{d-p},\quad `F' = (\vect{t}_i, g(\vect{t}_i, \vect{v}_i))_{1 \leq i \leq N}`  

    .. math::

        f: \left| \begin{array}{rcl}
                   \Rset^d & \rightarrow & \cM_N \times (\Rset^{d'})^{N} \\
                    F & \mapsto & F'
                  \end{array} \right.

    with :math:`F = (\vect{t}_i, \vect{v}_i)_{1 \leq i \leq N}`, :math:`F' = (\vect{t}_i, \vect{v}'_i)_{1 \leq i \leq N}` and :math:`\cM_{N}` a mesh of :math:`\cD \subset \Rset^{n}`.

    A vertex value function keeps the mesh unchanged: the input mesh is equal to the output mesh.

    The field :math:`F'` is defined by the function :math:`g: \Rset^n \times \Rset^d \rightarrow \Rset^{d'}`:

    .. math::

        \forall \vect{t}_i \in \cM_N, \quad \vect{v}'_i = g(\vect{t}_i, \vect{v}_i)

    When :math:`g` is not specified, the constructor builds an object which evaluation operator is not defined (it throws a *NotYetImplementedException*).
    The instantiation of such an object is used to extract an actual :class:`~openturns.VertexValuePointToFieldFunction` from a :class:`~openturns.Study`.

    See also
    --------
    ParametricPointToFieldFunction

    Examples
    --------
    >>> import openturns as ot

    Create a function :math:`g : \Rset \times \Rset \rightarrow \Rset` such as:

    .. math::

        g: \left|\begin{array}{rcl}
                    \Rset \times \Rset & \rightarrow & \Rset \\
                    (t, x) & \mapsto & (x + t^2)
                \end{array}\right.

    >>> g = ot.SymbolicFunction(['t', 'x'], ['x + t^2'])

    Convert :math:`g` into a vertex value function with :math:`n=1`:

    >>> n = 1
    >>> grid = ot.RegularGrid(0.0, 0.2, 6)
    >>> f = ot.VertexValuePointToFieldFunction(g, grid)
    >>> x = [4.0]
    >>> print(f(x))
        [ y0   ]
    0 : [ 4    ]
    1 : [ 4.04 ]
    2 : [ 4.16 ]
    3 : [ 4.36 ]
    4 : [ 4.64 ]
    5 : [ 5    ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.VertexValuePointToFieldFunction_getClassName(self)

    def __call__(self, *args):
        return _func.VertexValuePointToFieldFunction___call__(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        function : :class:`~openturns.PointToFieldFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.VertexValuePointToFieldFunction_getMarginal(self, *args)

    def __repr__(self):
        return _func.VertexValuePointToFieldFunction___repr__(self)

    def __str__(self, *args):
        return _func.VertexValuePointToFieldFunction___str__(self, *args)

    def getFunction(self):
        r"""
        Get the function of :math:`\ell`.

        Returns
        -------
        l : :class:`~openturns.Function`
           Function :math:`\ell: \Rset^n \times \Rset^d \rightarrow \Rset^{d'}`.

        Examples
        --------
        >>> import openturns as ot
        >>> h = ot.SymbolicFunction(['t', 'x'], ['x + t^2'])
        >>> n = 1
        >>> mesh = ot.Mesh(n)
        >>> myVertexValuePointToFieldFunction = ot.ValueFunction(h, mesh)
        >>> print(myVertexValuePointToFieldFunction.getFunction())
        [t,x]->[x + t^2]
        """
        return _func.VertexValuePointToFieldFunction_getFunction(self)

    def __init__(self, *args):
        _func.VertexValuePointToFieldFunction_swiginit(self, _func.new_VertexValuePointToFieldFunction(*args))
    __swig_destroy__ = _func.delete_VertexValuePointToFieldFunction

# Register VertexValuePointToFieldFunction in _func:
_func.VertexValuePointToFieldFunction_swigregister(VertexValuePointToFieldFunction)
class FieldToFieldConnection(FieldFunctionImplementation):
    r"""
    Composition function :math:`f \circ g` where :math:`g` acts on fields and :math:`f` produces fields.

    Available constructors:
       FieldToPointConnection(*f_FieldFunction, g_FieldFunction*)

       FieldToPointConnection(*f_PointToField, g_FieldToPoint*)

    Parameters
    ----------
    f_FieldFunction, g_FieldFunction : :class:`~openturns.FieldFunction`
        Function that acts on fields and produces fields
    g_FieldToPoint : :class:`~openturns.FieldToPointFunction`
        Function that acts on fields and produces points
    f_PointToField :  :class:`~openturns.PointToFieldFunction`
        Function that acts on points and produces points

    Notes
    -----
    This class is a particular case  of the general class :class:`~openturns.FieldFunction`. Thus it doesn't implement the  gradient nor the hessian.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldToFieldConnection_getClassName(self)

    def __eq__(self, *args):
        return _func.FieldToFieldConnection___eq__(self, *args)

    def __repr__(self):
        return _func.FieldToFieldConnection___repr__(self)

    def __str__(self, *args):
        return _func.FieldToFieldConnection___str__(self, *args)

    def __call__(self, *args):
        return _func.FieldToFieldConnection___call__(self, *args)

    def getInputDimension(self):
        r"""
        Get the dimension of the input field values.

        Returns
        -------
        d : int
            Dimension :math:`d` of the input field values.
        """
        return _func.FieldToFieldConnection_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the output field values.

        Returns
        -------
        d' : int
            Dimension :math:`d'` of the output field values.
        """
        return _func.FieldToFieldConnection_getOutputDimension(self)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d'`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        fieldFunction : :class:`~openturns.FieldFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.FieldToFieldConnection_getMarginal(self, *args)

    def getLeftFieldFunction(self):
        r"""
        Accessor to the function :math:`f` of class :class:`~openturns.FieldFunction`.

        Returns
        -------
        f : :class:`~openturns.FieldFunction`
            The function :math:`f` that acts on fields to produce fields.
        """
        return _func.FieldToFieldConnection_getLeftFieldFunction(self)

    def getRightFieldFunction(self):
        r"""
        Accessor to the function :math:`g` of class :class:`~openturns.FieldFunction`.

        Returns
        -------
        g : :class:`~openturns.FieldFunction`
            The function :math:`g` that acts on fields to produce fields.
        """
        return _func.FieldToFieldConnection_getRightFieldFunction(self)

    def getPointToFieldFunction(self):
        r"""
        Accessor to the function :math:`f` of class :class:`~openturns.PointToFieldFunction`.

        Returns
        -------
        f : :class:`~openturns.PointToFieldFunction`
            The function :math:`f` that acts on points to produce fields.
        """
        return _func.FieldToFieldConnection_getPointToFieldFunction(self)

    def getFieldToPointFunction(self):
        r"""
        Accessor to the function  :math:`g` of class :class:`~openturns.FieldToPointFunction`.

        Returns
        -------
        g : :class:`~openturns.FieldToPointFunction`
            The function :math:`g` that acts on fields to produce points.
        """
        return _func.FieldToFieldConnection_getFieldToPointFunction(self)

    def __init__(self, *args):
        _func.FieldToFieldConnection_swiginit(self, _func.new_FieldToFieldConnection(*args))
    __swig_destroy__ = _func.delete_FieldToFieldConnection

# Register FieldToFieldConnection in _func:
_func.FieldToFieldConnection_swigregister(FieldToFieldConnection)
class FieldToPointConnection(FieldToPointFunctionImplementation):
    r"""
    Composition function :math:`f \circ g` where :math:`g` acts on fields and :math:`f` produces points.

    Available constructors:
       FieldToPointConnection(*f_Function, g_FieldToPoint*)

       FieldToPointConnection(*f_FieldToPoint, g_FieldFunction*)

    Parameters
    ----------
    f_Function :  :class:`~openturns.Function`
        Function that acts on points and produces points
    g_FieldFunction : :class:`~openturns.FieldFunction`
        Function that acts on fields and produces fields
    f_FieldToPoint, g_FieldToPoint : :class:`~openturns.FieldToPointFunction`
        Function that acts on fields and produces points

    Notes
    -----
    This class is a particular case  of the general class :class:`~openturns.FieldToPointFunction`. Thus it doesn't implement the  gradient nor the hessian.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldToPointConnection_getClassName(self)

    def __eq__(self, *args):
        return _func.FieldToPointConnection___eq__(self, *args)

    def __call__(self, *args):
        return _func.FieldToPointConnection___call__(self, *args)

    def __repr__(self):
        return _func.FieldToPointConnection___repr__(self)

    def __str__(self, *args):
        return _func.FieldToPointConnection___str__(self, *args)

    def getInputDimension(self):
        r"""
        Get the dimension of the input field values.

        Returns
        -------
        d : int
            Dimension :math:`d` of the input field values.
        """
        return _func.FieldToPointConnection_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the output vector.

        Returns
        -------
        d' : int
            Dimension :math:`d'` of the output vector.
        """
        return _func.FieldToPointConnection_getOutputDimension(self)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        function : :class:`~openturns.FieldToPointFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.FieldToPointConnection_getMarginal(self, *args)

    def getFieldFunction(self):
        r"""
        Accessor to the function :math:`g` of class :class:`~openturns.FieldFunction`.

        Returns
        -------
        g : :class:`~openturns.FieldFunction`
            The function :math:`f` that acts on fields to produce fields.
        """
        return _func.FieldToPointConnection_getFieldFunction(self)

    def getFunction(self):
        r"""
        Accessor to the function :math:`f` of class :class:`~openturns.Function`.

        Returns
        -------
        f : :class:`~openturns.Function`
            The function :math:`f` that acts on points to produce points.
        """
        return _func.FieldToPointConnection_getFunction(self)

    def getFieldToPointFunction(self):
        r"""
        Accessor to the function  of class :class:`~openturns.FieldToPointFunction`.

        Returns
        -------
        func : :class:`~openturns.FieldToPointFunction`
            The function :math:`f` or :math:`g` that acts on fields to produce points.
        """
        return _func.FieldToPointConnection_getFieldToPointFunction(self)

    def __init__(self, *args):
        _func.FieldToPointConnection_swiginit(self, _func.new_FieldToPointConnection(*args))
    __swig_destroy__ = _func.delete_FieldToPointConnection

# Register FieldToPointConnection in _func:
_func.FieldToPointConnection_swigregister(FieldToPointConnection)
class PointToFieldConnection(PointToFieldFunctionImplementation):
    r"""
    Composition function :math:`f \circ g` where :math:`g` acts on points and :math:`f` produces fields.

    Available constructors:
       PointToFieldConnection(*f_FieldFunction, g_PointToField*)

       PointToFieldConnection(*f_PointToField, g_Function*)

    Parameters
    ----------
    f_FieldFunction : :class:`~openturns.FieldFunction`
        Function that acts on fields and produces fields
    f_PointToField, g_PointToField : :class:`~openturns.PointToFieldFunction`
        Function that acts on points and produces fields
    g_Function :  :class:`~openturns.Function`
        Function that acts on points and produces points

    Notes
    -----
    This class is a particular case  of the general class :class:`~openturns.PointToFieldFunction`. Thus it doesn't implement the  gradient nor the hessian.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PointToFieldConnection_getClassName(self)

    def __eq__(self, *args):
        return _func.PointToFieldConnection___eq__(self, *args)

    def __repr__(self):
        return _func.PointToFieldConnection___repr__(self)

    def __str__(self, *args):
        return _func.PointToFieldConnection___str__(self, *args)

    def __call__(self, *args):
        return _func.PointToFieldConnection___call__(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        function : :class:`~openturns.PointToFieldFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.PointToFieldConnection_getMarginal(self, *args)

    def getFunction(self):
        r"""
        Accessor to the function :math:`g` of class :class:`~openturns.Function`.

        Returns
        -------
        g : :class:`~openturns.Function`
            The function :math:`g` that acts on points to produce points.
        """
        return _func.PointToFieldConnection_getFunction(self)

    def getFieldFunction(self):
        r"""
        Accessor to the function :math:`f` of class :class:`~openturns.FieldFunction`.

        Returns
        -------
        f : :class:`~openturns.FieldFunction`
            The function :math:`f` that acts on fields to produce fields.
        """
        return _func.PointToFieldConnection_getFieldFunction(self)

    def getPointToFieldFunction(self):
        r"""
        Accessor to the function  of class :class:`~openturns.PointToFieldFunction`.

        Returns
        -------
        func : :class:`~openturns.PointToFieldFunction`
            The function :math:`f` or :math:`g` that acts on points to produce fields.
        """
        return _func.PointToFieldConnection_getPointToFieldFunction(self)

    def __init__(self, *args):
        _func.PointToFieldConnection_swiginit(self, _func.new_PointToFieldConnection(*args))
    __swig_destroy__ = _func.delete_PointToFieldConnection

# Register PointToFieldConnection in _func:
_func.PointToFieldConnection_swigregister(PointToFieldConnection)
class PointToPointEvaluation(EvaluationImplementation):
    r"""
    Evaluation of the composition :math:`f \circ g` where :math:`g` acts on points and :math:`f` produces points.

    Available constructors:
       PointToPointEvaluation(*f_Function, g_Function*)

       PointToPointEvaluation(*f_FieldToPoint, g_PointToField*)

    Parameters
    ----------
    f_Function, g_Function :  :class:`~openturns.Function`
        A function that acts on points and produces points
    f_FieldToPoint : :class:`~openturns.FieldToPointFunction`
        A function that acts on fields and produces points
    g_PointToField : :class:`~openturns.PointToFieldFunction`
        A function that acts on points and produces fields

    Notes
    -----
    This class only implements the evaluation operator and does not propose any implementation for the gradient nor the hessian of the composition.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PointToPointEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.PointToPointEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.PointToPointEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.PointToPointEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.PointToPointEvaluation___call__(self, *args)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.PointToPointEvaluation_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.PointToPointEvaluation_setParameter(self, parameter)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.PointToPointEvaluation_getParameterDescription(self)

    def setParameterDescription(self, description):
        r"""
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.PointToPointEvaluation_setParameterDescription(self, description)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.PointToPointEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.PointToPointEvaluation_getOutputDimension(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.PointToPointEvaluation_getMarginal(self, *args)

    def getLeftFunction(self):
        r"""
        Accessor to the left function :math:`f`.

        Returns
        -------
        f : :class:`~openturns.Function`
            The function :math:`f` acting on points to produce points.

        """
        return _func.PointToPointEvaluation_getLeftFunction(self)

    def getRightFunction(self):
        r"""
        Accessor to the left function :math:`g`.

        Returns
        -------
        g : :class:`~openturns.Function`
            The function :math:`g` acting on points to produce points.

        """
        return _func.PointToPointEvaluation_getRightFunction(self)

    def getPointToFieldFunction(self):
        r"""
        Accessor to the left function :math:`g`.

        Returns
        -------
        g : :class:`~openturns.PointToFieldFunction`
            The function :math:`g` acting on points to produce fields.
        """
        return _func.PointToPointEvaluation_getPointToFieldFunction(self)

    def getFieldToPointFunction(self):
        r"""
        Accessor to the left function :math:`f`.

        Returns
        -------
        f : :class:`~openturns.FieldToPointFunction`
            The function :math:`f` acting on fields to produce points.

        """
        return _func.PointToPointEvaluation_getFieldToPointFunction(self)

    def __init__(self, *args):
        _func.PointToPointEvaluation_swiginit(self, _func.new_PointToPointEvaluation(*args))
    __swig_destroy__ = _func.delete_PointToPointEvaluation

# Register PointToPointEvaluation in _func:
_func.PointToPointEvaluation_swigregister(PointToPointEvaluation)
class PointToPointConnection(FunctionImplementation):
    r"""
    Composition function :math:`f \circ g` where :math:`g` acts on points and :math:`f` produces points.

    Available constructors:
       PointToPointEvaluation(*f_Function, g_Function*)

       PointToPointEvaluation(*f_FieldToPoint, g_PointToField*)

    Parameters
    ----------
    f_Function, g_Function :  :class:`~openturns.Function`
        Function that acts on points and produces points
    f_FieldToPoint : :class:`~openturns.FieldToPointFunction`
        Function that acts on fields and produces points
    g_PointToField : :class:`~openturns.PointToFieldFunction`
        Function that acts on points and produces fields

    Notes
    -----
    This class is a particular case  of the general class :class:`~openturns.Function`. Thus it implements the evaluation operator and the evaluation of the gradient and the hessian.

    By default, the gradient and hessian are evaluated using  centered finite differences described in :class:`~openturns.CenteredFiniteDifferenceGradient` and :class:`~openturns.CenteredFiniteDifferenceHessian`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PointToPointConnection_getClassName(self)

    def __eq__(self, *args):
        return _func.PointToPointConnection___eq__(self, *args)

    def __repr__(self):
        return _func.PointToPointConnection___repr__(self)

    def __init__(self, *args):
        _func.PointToPointConnection_swiginit(self, _func.new_PointToPointConnection(*args))
    __swig_destroy__ = _func.delete_PointToPointConnection

# Register PointToPointConnection in _func:
_func.PointToPointConnection_swigregister(PointToPointConnection)
class IndicatorFunction(Function):
    r"""
    Indicator function of a :class:`~openturns.Domain` :math:`\mathcal{D}`.

    .. math::

        l = 1_{\mathcal{D}}

    Parameters
    ----------
    domain : :class:`~openturns.Domain`
        The indicator function checks whether a point belongs to this domain.

    Examples
    --------
    Indicator function of an :class:`~openturns.Interval`:

    >>> import openturns as ot
    >>> domain = ot.Interval(0.0, 1.0)
    >>> indicator = ot.IndicatorFunction(domain)
    >>> print(indicator([1.2]))
    [0]

    Indicator function of a :class:`~openturns.LevelSet`:

    >>> analytical = ot.SymbolicFunction(['x'], ['2*x-8'])
    >>> levelset = ot.LevelSet(analytical, ot.Less(), 0.0)
    >>> f = ot.IndicatorFunction(levelset)
    >>> print(f([1.3]))
    [1]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.IndicatorFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.IndicatorFunction___eq__(self, *args)

    def __repr__(self):
        return _func.IndicatorFunction___repr__(self)

    def __str__(self, *args):
        return _func.IndicatorFunction___str__(self, *args)

    def __init__(self, *args):
        _func.IndicatorFunction_swiginit(self, _func.new_IndicatorFunction(*args))
    __swig_destroy__ = _func.delete_IndicatorFunction

# Register IndicatorFunction in _func:
_func.IndicatorFunction_swigregister(IndicatorFunction)
class DistanceToDomainFunction(Function):
    r"""
    Function which outputs the Euclidean distance to a :class:`~openturns.Domain` :math:`\mathcal{D}`.

    .. math::

        \left.\begin{array}{rcl}
                      \Rset^n & \rightarrow & [0, +\infty( \\
                      \vect{X} & \mapsto & \displaystyle \inf \{ \| \vect{X} - \vect{Y} \| : \vect{Y} \in \mathcal{D} \}
               \end{array} \right.

    Parameters
    ----------
    domain : :class:`~openturns.Domain`
        The :class:`~openturns.Function` will output the Euclidean distance to this domain.

    Examples
    --------
    Distance to an :class:`~openturns.Interval`:

    >>> import openturns as ot
    >>> domain = ot.Interval([0.0, 1.0], [1.0, 3.0])
    >>> distanceToDomain = ot.DistanceToDomainFunction(domain)
    >>> print(distanceToDomain([1.2, 1.5]))
    [0.2]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DistanceToDomainFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.DistanceToDomainFunction___eq__(self, *args)

    def __repr__(self):
        return _func.DistanceToDomainFunction___repr__(self)

    def __str__(self, *args):
        return _func.DistanceToDomainFunction___str__(self, *args)

    def __init__(self, *args):
        _func.DistanceToDomainFunction_swiginit(self, _func.new_DistanceToDomainFunction(*args))
    __swig_destroy__ = _func.delete_DistanceToDomainFunction

# Register DistanceToDomainFunction in _func:
_func.DistanceToDomainFunction_swigregister(DistanceToDomainFunction)
class ValueFunction(FieldFunctionImplementation):
    r"""
    Function mapping a field to a field.

    Parameters
    ----------
    g : :class:`~openturns.Function`
        Function :math:`g: \Rset^d \rightarrow \Rset^{d'}`.
    mesh : :class:`~openturns.Mesh`
        The mesh of the domain :math:`\cD`.

    Notes
    -----
    Value functions act on fields to produce fields such that:

    .. math::

        f: \left| \begin{array}{rcl}
                   \cM_N \times (\Rset^d)^N & \rightarrow & \cM_N \times (\Rset^{d'})^{N} \\
                    F & \mapsto & F'
                  \end{array} \right.

    with :math:`F = (\vect{t}_i, \vect{v}_i)_{1 \leq i \leq N}`, :math:`F' = (\vect{t}_i, \vect{v}'_i)_{1 \leq i \leq N}` and :math:`\cM_{N}` a mesh of :math:`\cD \subset \Rset^{n}`.

    A value function keeps the mesh unchanged: the input mesh is equal to the output mesh.

    The  field :math:`F'` is defined by the function :math:`g: \Rset^d \rightarrow \Rset^{d'}`:

    .. math::

        \forall \vect{t}_i \in \cM_N, \quad \vect{v}'_i = g(\vect{v}_i)


    The first constructor builds an object which evaluation operator is not defined (it throws a *NotYetImplementedException*).
    The instantiation of such an object is used to extract an actual :class:`~openturns.ValueFunction` from a  :class:`~openturns.Study`.

    See also
    --------
    FieldFunction, VertexValueFunction, OpenTURNSPythonFunction, PythonFunction

    Examples
    --------
    >>> import openturns as ot

    Create the function :math:`g : \Rset \rightarrow \Rset` defined by:

    .. math::

        g: \left|\begin{array}{rcl}
                    \Rset & \rightarrow & \Rset \\
                    x & \mapsto & x^2
                \end{array}\right.

    >>> g = ot.SymbolicFunction('x', 'x^2')

    Convert :math:`g` into a value function with :math:`n=1` the dimension of the
    mesh of the field on which :math:`g` will be applied:

    >>> n = 1
    >>> tg = ot.RegularGrid(0.0, 0.2, 6)
    >>> myValueFunction = ot.ValueFunction(g, tg)
    >>> # Create a TimeSeries
    >>> data = ot.Sample(tg.getN(), g.getInputDimension())
    >>> for i in range(data.getSize()):
    ...     for j in range(data.getDimension()):
    ...         data[i, j] = i * data.getDimension() + j
    >>> ts = ot.TimeSeries(tg, data)
    >>> print(ts)
        [ t   v0  ]
    0 : [ 0   0   ]
    1 : [ 0.2 1   ]
    2 : [ 0.4 2   ]
    3 : [ 0.6 3   ]
    4 : [ 0.8 4   ]
    5 : [ 1   5   ]
    >>> print(myValueFunction(ts))
        [ y0 ]
    0 : [  0 ]
    1 : [  1 ]
    2 : [  4 ]
    3 : [  9 ]
    4 : [ 16 ]
    5 : [ 25 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ValueFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.ValueFunction___eq__(self, *args)

    def __repr__(self):
        return _func.ValueFunction___repr__(self)

    def __str__(self, *args):
        return _func.ValueFunction___str__(self, *args)

    def __call__(self, *args):
        return _func.ValueFunction___call__(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d'`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        function : :class:`~openturns.ValueFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.ValueFunction_getMarginal(self, *args)

    def getFunction(self):
        r"""
        Get the function :math:`g`.

        Returns
        -------
        g : :class:`~openturns.Function`
            Function :math:`g: \Rset^d \rightarrow \Rset^{d'}`.

        Examples
        --------
        >>> import openturns as ot
        >>> g = ot.SymbolicFunction('x', 'x^2')
        >>> n = 1
        >>> mesh = ot.Mesh(n)
        >>> myValueFunction = ot.ValueFunction(g, mesh)
        >>> print(myValueFunction.getFunction())
        [x]->[x^2]
        """
        return _func.ValueFunction_getFunction(self)

    def isActingPointwise(self):
        r"""
        Whether the function acts point-wise.

        Returns
        -------
        pointWise : bool
            Returns true if the function evaluation at each vertex depends only on the
            vertex or the value at the vertex.
        """
        return _func.ValueFunction_isActingPointwise(self)

    def __init__(self, *args):
        _func.ValueFunction_swiginit(self, _func.new_ValueFunction(*args))
    __swig_destroy__ = _func.delete_ValueFunction

# Register ValueFunction in _func:
_func.ValueFunction_swigregister(ValueFunction)
class VertexValueFunction(FieldFunctionImplementation):
    r"""
    Function mapping a field to a field.

    Parameters
    ----------
    g : :class:`~openturns.Function`
        Function :math:`g: \Rset^n \times \Rset^d \rightarrow \Rset^{d'}`.
    mesh : :class:`~openturns.Mesh`
        Mesh on which the function is defined.

    Notes
    -----
    Vertex value functions act on fields to produce fields such that:

    .. math::

        f: \left| \begin{array}{rcl}
                   \cM_N \times (\Rset^d)^N & \rightarrow & \cM_N \times (\Rset^{d'})^{N} \\
                    F & \mapsto & F'
                  \end{array} \right.

    with :math:`F = (\vect{t}_i, \vect{v}_i)_{1 \leq i \leq N}`, :math:`F' = (\vect{t}_i, \vect{v}'_i)_{1 \leq i \leq N}` and :math:`\cM_{N}` a mesh of :math:`\cD \subset \Rset^{n}`.

    A vertex value function keeps the mesh unchanged: the input mesh is equal to the output mesh.

    The field :math:`F'` is defined by the function :math:`g: \Rset^n \times \Rset^d \rightarrow \Rset^{d'}`:

    .. math::

        \forall \vect{t}_i \in \cM_N, \quad \vect{v}'_i = g(\vect{t}_i, \vect{v}_i)

    When :math:`g` is not specified, the constructor builds an object which evaluation operator is not defined (it throws a *NotYetImplementedException*).
    The instantiation of such an object is used to extract an actual :class:`~openturns.VertexValueFunction` from a :class:`~openturns.Study`.

    See also
    --------
    FieldFunction, ValueFunction, VertexValueFunction

    Examples
    --------
    >>> import openturns as ot

    Create a function :math:`g : \Rset \times \Rset \rightarrow \Rset` such as:

    .. math::

        g: \left|\begin{array}{rcl}
                    \Rset \times \Rset & \rightarrow & \Rset \\
                    (t, x) & \mapsto & (x + t^2)
                \end{array}\right.

    >>> g = ot.SymbolicFunction(['t', 'x'], ['x + t^2'])

    Convert :math:`g` into a vertex value function with :math:`n=1`:

    >>> n = 1
    >>> grid = ot.RegularGrid(0.0, 0.2, 6)
    >>> myVertexValueFunction = ot.VertexValueFunction(g, grid)
    >>> # Create a TimeSeries
    >>> data = ot.Sample(grid.getN(), g.getInputDimension()-1)
    >>> for i in range(data.getSize()):
    ...     for j in range(data.getDimension()):
    ...         data[i, j] = i * data.getDimension() + j
    >>> ts = ot.TimeSeries(grid, data)
    >>> print(ts)
        [ t   v0  ]
    0 : [ 0   0   ]
    1 : [ 0.2 1   ]
    2 : [ 0.4 2   ]
    3 : [ 0.6 3   ]
    4 : [ 0.8 4   ]
    5 : [ 1   5   ]
    >>> print(myVertexValueFunction(ts))
        [ y0   ]
    0 : [ 0    ]
    1 : [ 1.04 ]
    2 : [ 2.16 ]
    3 : [ 3.36 ]
    4 : [ 4.64 ]
    5 : [ 6    ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.VertexValueFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.VertexValueFunction___eq__(self, *args)

    def __repr__(self):
        return _func.VertexValueFunction___repr__(self)

    def __str__(self, *args):
        return _func.VertexValueFunction___str__(self, *args)

    def __call__(self, *args):
        return _func.VertexValueFunction___call__(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d'`
            Indice(s) of the marginal(s) to be extracted.

        Returns
        -------
        function : :class:`~openturns.VertexValueFunction`
            The initial function restricted to the concerned marginal(s) at the indice(s)
            :math:`i`.
        """
        return _func.VertexValueFunction_getMarginal(self, *args)

    def getFunction(self):
        r"""
        Get the function of :math:`\ell`.

        Returns
        -------
        l : :class:`~openturns.Function`
           Function :math:`\ell: \Rset^n \times \Rset^d \rightarrow \Rset^{d'}`.

        Examples
        --------
        >>> import openturns as ot
        >>> h = ot.SymbolicFunction(['t', 'x'], ['x + t^2'])
        >>> n = 1
        >>> mesh = ot.Mesh(n)
        >>> myVertexValueFunction = ot.ValueFunction(h, mesh)
        >>> print(myVertexValueFunction.getFunction())
        [t,x]->[x + t^2]
        """
        return _func.VertexValueFunction_getFunction(self)

    def isActingPointwise(self):
        r"""
        Whether the function acts point-wise.

        Returns
        -------
        pointWise : bool
            Returns true if the function evaluation at each vertex depends only on the
            vertex or the value at the vertex.
        """
        return _func.VertexValueFunction_isActingPointwise(self)

    def __init__(self, *args):
        _func.VertexValueFunction_swiginit(self, _func.new_VertexValueFunction(*args))
    __swig_destroy__ = _func.delete_VertexValueFunction

# Register VertexValueFunction in _func:
_func.VertexValueFunction_swigregister(VertexValueFunction)
class DualLinearCombinationEvaluation(EvaluationImplementation):
    r"""
    Dual linear combination evaluation implementation.

    Available constructors:

        DualLinearCombinationEvaluation(*scalarFctColl, vectCoefColl*)

    Parameters
    ----------
    scalarFctColl : sequence of :class:`~openturns.Function`
        A collection of functions :math:`(f_i)_{i = 1, \ldots, l}` of size :math:`l`,
        such that :math:`\forall i \in \{1, \ldots, l\}`, 
        :math:`f_i : \Rset^n \rightarrow \Rset`.
    vectCoefColl : 2-d sequence of float
        Sample :math:`\cC = \{\vect{c}_1, \ldots, \vect{c}_l \}` of size :math:`l` and dimension :math:`p`.

    See also
    --------
    Function, AggregatedEvaluation, DatabaseEvaluation,
    LinearFunction

    Notes
    -----
    It returns a :class:`~openturns.Function` which is the function
    :math:`f: \Rset^n \rightarrow \Rset^p` defined as the linear combination of the functions :math:`f_i` with vector coefficients in :math:`\cC`:

    .. math::
        \forall \vect{x} \in \Rset^n, f(\vect{x}) = \left\{ \sum_{i=1}^l f_i( \vect{x} ) c_i^{(j)} \right\}_{j = 1, \ldots, p}

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationEvaluation_getClassName(self)

    def setDescription(self, description):
        r"""
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.DualLinearCombinationEvaluation_setDescription(self, description)

    def __repr__(self):
        return _func.DualLinearCombinationEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.DualLinearCombinationEvaluation___str__(self, *args)

    def _repr_html_(self):
        return _func.DualLinearCombinationEvaluation__repr_html_(self)

    def __call__(self, *args):
        return _func.DualLinearCombinationEvaluation___call__(self, *args)

    def getCoefficients(self):
        r"""
        Accessor to the coefficients.

        Returns
        -------
        coef : :class:`~openturns.Sample`
            The vectorial coefficients :math:`\cC = \{\vect{c}_1, \ldots, \vect{c}_l \}`
            which define the linear combination of :math:`f`.
        """
        return _func.DualLinearCombinationEvaluation_getCoefficients(self)

    def getFunctionsCollection(self):
        r"""
        Accessor to the collection of functions.

        Returns
        -------
        fctColl : :class:`~openturns.FunctionCollection`
            The collection of scalar functions :math:`(f_i)_{i = 1, \ldots, l}` which
            defines the linear combination of :math:`f`.
        """
        return _func.DualLinearCombinationEvaluation_getFunctionsCollection(self)

    def setFunctionsCollectionAndCoefficients(self, functionsCollection, coefficients):
        r"""
        Accessor to the coefficients and the collection of functions.

        Parameters
        ----------
        scalarFctColl : sequence of :class:`~openturns.Function`
            The collection of functions :math:`(f_i)_{i = 1, \ldots, l}`.
        vectCoefColl : 2-d sequence of float
            The sample of coefficients :math:`\cC = \{\vect{c}_1, \ldots, \vect{c}_l \}`.
        """
        return _func.DualLinearCombinationEvaluation_setFunctionsCollectionAndCoefficients(self, functionsCollection, coefficients)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.DualLinearCombinationEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.DualLinearCombinationEvaluation_getOutputDimension(self)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.DualLinearCombinationEvaluation_parameterGradient(self, inP)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.DualLinearCombinationEvaluation_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.DualLinearCombinationEvaluation_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.DualLinearCombinationEvaluation_getParameterDescription(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.DualLinearCombinationEvaluation_getMarginal(self, *args)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func.DualLinearCombinationEvaluation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.DualLinearCombinationEvaluation_isLinearlyDependent(self, index)

    def __init__(self, *args):
        _func.DualLinearCombinationEvaluation_swiginit(self, _func.new_DualLinearCombinationEvaluation(*args))
    __swig_destroy__ = _func.delete_DualLinearCombinationEvaluation

# Register DualLinearCombinationEvaluation in _func:
_func.DualLinearCombinationEvaluation_swigregister(DualLinearCombinationEvaluation)
class DualLinearCombinationGradient(GradientImplementation):
    r"""
    Dual linear combination gradient implementation.

    Parameters
    ----------
    myDLCEI : :class:`~openturns.DualLinearCombinationEvaluation`
        A dual linear combination evaluation implementation.

    See also
    --------
    DualLinearCombinationEvaluation,
    DualLinearCombinationHessian

    Notes
    -----
    It returns the implementation of the gradient. By default, the analytical
    gradient is implemented.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationGradient_getClassName(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.DualLinearCombinationGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.DualLinearCombinationGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.DualLinearCombinationGradient_getOutputDimension(self)

    def __repr__(self):
        return _func.DualLinearCombinationGradient___repr__(self)

    def __init__(self, *args):
        _func.DualLinearCombinationGradient_swiginit(self, _func.new_DualLinearCombinationGradient(*args))
    __swig_destroy__ = _func.delete_DualLinearCombinationGradient

# Register DualLinearCombinationGradient in _func:
_func.DualLinearCombinationGradient_swigregister(DualLinearCombinationGradient)
class DualLinearCombinationHessian(HessianImplementation):
    r"""
    Dual linear combination hessian implementation.

    Parameters
    ----------
    myDLCEI : :class:`~openturns.DualLinearCombinationEvaluation`
        A dual linear combination evaluation implementation.

    See also
    --------
    DualLinearCombinationEvaluation,
    DualLinearCombinationGradient

    Notes
    -----
    It returns the implementation of the hessian. By default, the analytical
    hessian is implemented.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationHessian_getClassName(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.DualLinearCombinationHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.DualLinearCombinationHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.DualLinearCombinationHessian_getOutputDimension(self)

    def __repr__(self):
        return _func.DualLinearCombinationHessian___repr__(self)

    def __init__(self, *args):
        _func.DualLinearCombinationHessian_swiginit(self, _func.new_DualLinearCombinationHessian(*args))
    __swig_destroy__ = _func.delete_DualLinearCombinationHessian

# Register DualLinearCombinationHessian in _func:
_func.DualLinearCombinationHessian_swigregister(DualLinearCombinationHessian)
class LinearCombinationEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::LinearCombinationEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationEvaluation_getClassName(self)

    def __repr__(self):
        return _func.LinearCombinationEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.LinearCombinationEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.LinearCombinationEvaluation___call__(self, *args)

    def getCoefficients(self):
        return _func.LinearCombinationEvaluation_getCoefficients(self)

    def getFunctionsCollection(self):
        return _func.LinearCombinationEvaluation_getFunctionsCollection(self)

    def setFunctionsCollectionAndCoefficients(self, functionsCollection, coefficients):
        return _func.LinearCombinationEvaluation_setFunctionsCollectionAndCoefficients(self, functionsCollection, coefficients)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.LinearCombinationEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.LinearCombinationEvaluation_getOutputDimension(self)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.LinearCombinationEvaluation_parameterGradient(self, inP)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.LinearCombinationEvaluation_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.LinearCombinationEvaluation_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.LinearCombinationEvaluation_getParameterDescription(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.LinearCombinationEvaluation_getMarginal(self, *args)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func.LinearCombinationEvaluation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.LinearCombinationEvaluation_isLinearlyDependent(self, index)

    def __init__(self, *args):
        _func.LinearCombinationEvaluation_swiginit(self, _func.new_LinearCombinationEvaluation(*args))
    __swig_destroy__ = _func.delete_LinearCombinationEvaluation

# Register LinearCombinationEvaluation in _func:
_func.LinearCombinationEvaluation_swigregister(LinearCombinationEvaluation)
class LinearCombinationGradient(GradientImplementation):
    r"""Proxy of C++ OT::LinearCombinationGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationGradient_getClassName(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.LinearCombinationGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.LinearCombinationGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.LinearCombinationGradient_getOutputDimension(self)

    def __repr__(self):
        return _func.LinearCombinationGradient___repr__(self)

    def __str__(self, *args):
        return _func.LinearCombinationGradient___str__(self, *args)

    def __init__(self, *args):
        _func.LinearCombinationGradient_swiginit(self, _func.new_LinearCombinationGradient(*args))
    __swig_destroy__ = _func.delete_LinearCombinationGradient

# Register LinearCombinationGradient in _func:
_func.LinearCombinationGradient_swigregister(LinearCombinationGradient)
class LinearCombinationHessian(HessianImplementation):
    r"""Proxy of C++ OT::LinearCombinationHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationHessian_getClassName(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.LinearCombinationHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.LinearCombinationHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.LinearCombinationHessian_getOutputDimension(self)

    def __repr__(self):
        return _func.LinearCombinationHessian___repr__(self)

    def __str__(self, *args):
        return _func.LinearCombinationHessian___str__(self, *args)

    def __init__(self, *args):
        _func.LinearCombinationHessian_swiginit(self, _func.new_LinearCombinationHessian(*args))
    __swig_destroy__ = _func.delete_LinearCombinationHessian

# Register LinearCombinationHessian in _func:
_func.LinearCombinationHessian_swigregister(LinearCombinationHessian)
class LinearFunction(Function):
    r"""
    Linear numerical math function.

    Parameters
    ----------
    center : sequence of float
        Vector :math:`\vect{b}`.
    constant : sequence of float
        Vector :math:`\vect{c}`.
    linear : :class:`~openturns.Matrix`
        Matrix :math:`\mat{A}`.

    See also
    --------
    Function

    Notes
    -----
    This implements a linear :class:`~openturns.Function` :math:`f` 
    defined as :

    .. math::

        f : & \Rset^n \rightarrow \Rset^p  \\
            & \vect{X} \mapsto \mat{A} ( \vect{X} - \vect{b} ) + \vect{c}

    where:

    - :math:`\mat{A}` is the :math:`\Rset^p \times \Rset^n` matrix defined by the
      input *linear*,
    - :math:`\vect{b}` is the :math:`\Rset^n` vector defined by the object *center*,

    - :math:`\vect{c}` is the :math:`\Rset^p` vector defined by the object *constant*.

    Examples
    --------
    In the next example, we create the linear function :math:`f(x) = 2x + 3` 
    for any :math:`x \in \Rset`.

    >>> import openturns as ot
    >>> center = [0.0]
    >>> constant = [3.0]
    >>> linear = ot.Matrix([[2.0]])
    >>> f = ot.LinearFunction(center, constant, linear)
    >>> print(f([1.0]))
    [5]

    In the next example, we create the linear function :math:`f(x, y) = 2x - y + 3` 
    for any :math:`x \in \Rset`.

    >>> centerCoefficient = [0.0, 0.0]
    >>> constantCoefficient = [3.0]
    >>> linearCoefficient = ot.Matrix([[2.0, -1.0]])
    >>> f = ot.LinearFunction(centerCoefficient, constantCoefficient, linearCoefficient)
    >>> print(f([1.0, 2.0]))
    [3]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.LinearFunction___eq__(self, *args)

    def __repr__(self):
        return _func.LinearFunction___repr__(self)

    def __str__(self, *args):
        return _func.LinearFunction___str__(self, *args)

    def __init__(self, *args):
        _func.LinearFunction_swiginit(self, _func.new_LinearFunction(*args))
    __swig_destroy__ = _func.delete_LinearFunction

# Register LinearFunction in _func:
_func.LinearFunction_swigregister(LinearFunction)
class TranslationFunction(Function):
    r"""
    Translation function.

    Parameters
    ----------
    constant : sequence of float
        Vector :math:`\vect{c}`.

    See also
    --------
    Function

    Notes
    -----
    This implements a :class:`~openturns.Function` :math:`f`
    defined as :

    .. math::

        f : & \Rset^n \rightarrow \Rset^n  \\
            & \vect{X} \mapsto \vect{X} + \vect{c}

    where:

    - :math:`\vect{c}` is the :math:`\Rset^n` vector defined by the object *constant*.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TranslationFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.TranslationFunction___eq__(self, *args)

    def __repr__(self):
        return _func.TranslationFunction___repr__(self)

    def __str__(self, *args):
        return _func.TranslationFunction___str__(self, *args)

    def getConstant(self):
        r"""
        Accessor to the constant.

        Returns
        -------
        constant : :class:`~openturns.Point`
            Vector :math:`\vect{c}`

        """
        return _func.TranslationFunction_getConstant(self)

    def setConstant(self, constant):
        r"""
        Accessor to the constant.

        Parameters
        ----------
        constant : sequence of float
            Vector :math:`\vect{c}`

        """
        return _func.TranslationFunction_setConstant(self, constant)

    def __init__(self, *args):
        _func.TranslationFunction_swiginit(self, _func.new_TranslationFunction(*args))
    __swig_destroy__ = _func.delete_TranslationFunction

# Register TranslationFunction in _func:
_func.TranslationFunction_swigregister(TranslationFunction)
class QuadraticFunction(Function):
    r"""
    Quadratic function.

    Parameters
    ----------
    center : sequence of float
        Vector :math:`\vect{b}`.
    constant : sequence of float
        Vector :math:`\vect{c}`.
    linear : :class:`~openturns.Matrix`
        Matrix :math:`\mat{A}`.
    quadratic : :class:`~openturns.SymmetricTensor`
        Tensor :math:`\underline{\underline{\underline{M}}}`.

    Notes
    -----
    This implements a quadratic function :math:`f` defined as:

    .. math::

        f : & \Rset^n \rightarrow \Rset^p  \\
            & \vect{X} \mapsto \mat{A} ( \vect{X} - \vect{b} ) + \vect{c} + \frac{1}{2} \vect{X}^T \times \underline{\underline{\underline{M}}} \times \vect{X}

    where:

    - :math:`\mat{A}` is the :math:`\Rset^p \times \Rset^n` matrix defined by *linear*,

    - :math:`\vect{b}` is the :math:`\Rset^n` vector defined by *center*,

    - :math:`\vect{c}` is the :math:`\Rset^p` vector defined by *constant*.

    - :math:`\underline{\underline{\underline{M}}}` is a :math:`\Rset^p \times \Rset^n \times \Rset^n` symmetric tensor defined by *quadratic*.

    Examples
    --------
    >>> import openturns as ot
    >>> inputDimension = 3
    >>> outputDimension = 2
    >>> center = [1.0] * inputDimension
    >>> constant = [-1.0, 2.0]
    >>> linear = ot.Matrix(inputDimension, outputDimension)
    >>> quadratic = ot.SymmetricTensor(inputDimension, outputDimension)
    >>> function = ot.QuadraticFunction(center, constant, linear, quadratic)
    >>> inP = [7.0, 8.0, 9.0]
    >>> print(function(inP))
    [-1,2]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.QuadraticFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.QuadraticFunction___eq__(self, *args)

    def __repr__(self):
        return _func.QuadraticFunction___repr__(self)

    def __str__(self, *args):
        return _func.QuadraticFunction___str__(self, *args)

    def __init__(self, *args):
        _func.QuadraticFunction_swiginit(self, _func.new_QuadraticFunction(*args))
    __swig_destroy__ = _func.delete_QuadraticFunction

# Register QuadraticFunction in _func:
_func.QuadraticFunction_swigregister(QuadraticFunction)
class UniVariateFunctionImplementation(openturns.common.PersistentObject):
    r"""Base class for univariate functions."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariateFunctionImplementation_getClassName(self)

    def __repr__(self):
        return _func.UniVariateFunctionImplementation___repr__(self)

    def __str__(self, *args):
        return _func.UniVariateFunctionImplementation___str__(self, *args)

    def __call__(self, x):
        return _func.UniVariateFunctionImplementation___call__(self, x)

    def gradient(self, x):
        r"""
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariateFunctionImplementation_gradient(self, x)

    def hessian(self, x):
        r"""
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariateFunctionImplementation_hessian(self, x)

    def draw(self, xMin, xMax, pointNumber):
        r"""
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\max} > x_{\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariateFunctionImplementation_draw(self, xMin, xMax, pointNumber)

    def __init__(self, *args):
        _func.UniVariateFunctionImplementation_swiginit(self, _func.new_UniVariateFunctionImplementation(*args))
    __swig_destroy__ = _func.delete_UniVariateFunctionImplementation

# Register UniVariateFunctionImplementation in _func:
_func.UniVariateFunctionImplementation_swigregister(UniVariateFunctionImplementation)
class _UniVariateFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._UniVariateFunctionImplementationTypedInterfaceObject_swiginit(self, _func.new__UniVariateFunctionImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._UniVariateFunctionImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._UniVariateFunctionImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._UniVariateFunctionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._UniVariateFunctionImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._UniVariateFunctionImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__UniVariateFunctionImplementationTypedInterfaceObject

# Register _UniVariateFunctionImplementationTypedInterfaceObject in _func:
_func._UniVariateFunctionImplementationTypedInterfaceObject_swigregister(_UniVariateFunctionImplementationTypedInterfaceObject)
class UniVariateFunction(_UniVariateFunctionImplementationTypedInterfaceObject):
    r"""Base class for univariate functions."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariateFunction_getClassName(self)

    def __repr__(self):
        return _func.UniVariateFunction___repr__(self)

    def __str__(self, *args):
        return _func.UniVariateFunction___str__(self, *args)

    def __call__(self, x):
        return _func.UniVariateFunction___call__(self, x)

    def gradient(self, x):
        r"""
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariateFunction_gradient(self, x)

    def hessian(self, x):
        r"""
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariateFunction_hessian(self, x)

    def draw(self, xMin, xMax, pointNumber):
        r"""
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\max} > x_{\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariateFunction_draw(self, xMin, xMax, pointNumber)

    def __init__(self, *args):
        _func.UniVariateFunction_swiginit(self, _func.new_UniVariateFunction(*args))
    __swig_destroy__ = _func.delete_UniVariateFunction

# Register UniVariateFunction in _func:
_func.UniVariateFunction_swigregister(UniVariateFunction)
class MonomialFunction(UniVariateFunctionImplementation):
    r"""
    Monomial function class.

    Parameters
    ----------
    degre : int
        Degree of the monomial function

    Notes
    -----
    The *monomial function* defines as :

    .. math::

        P(x)  = X^n


    Examples
    --------
    Create a standard absolute exponential covariance function:

    >>> import openturns as ot
    >>> P = ot.MonomialFunction(3)


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.MonomialFunction_getClassName(self)

    def __repr__(self):
        return _func.MonomialFunction___repr__(self)

    def __str__(self, *args):
        return _func.MonomialFunction___str__(self, *args)

    def __call__(self, x):
        return _func.MonomialFunction___call__(self, x)

    def gradient(self, x):
        r"""
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the monomial's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.MonomialFunction(3)
        >>> print(P.gradient(1.0))
        3.0
        """
        return _func.MonomialFunction_gradient(self, x)

    def hessian(self, x):
        r"""
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the monomial's second-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.MonomialFunction(3)
        >>> print(P.hessian(1.0))
        6.0
        """
        return _func.MonomialFunction_hessian(self, x)

    def __init__(self, *args):
        _func.MonomialFunction_swiginit(self, _func.new_MonomialFunction(*args))
    __swig_destroy__ = _func.delete_MonomialFunction

# Register MonomialFunction in _func:
_func.MonomialFunction_swigregister(MonomialFunction)
class UniVariatePolynomialImplementation(UniVariateFunctionImplementation):
    r"""
    Base class for univariate polynomials.

    Parameters
    ----------
    coefficients : sequence of float
        Polynomial coefficients in increasing polynomial order.

    Examples
    --------
    >>> import openturns as ot

    Create a univariate polynomial from a list of coefficients:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> print(P)
    1 + 2 * X + 3 * X^2

    Univariate polynomials are of course callable:

    >>> print(P(1.0))
    6.0

    Addition, subtraction and multiplication of univariate polynomials:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> Q = ot.UniVariatePolynomial([1.0, 2.0])
    >>> print(f'({P}) + ({Q}) = {P + Q}')
    (1 + 2 * X + 3 * X^2) + (1 + 2 * X) = 2 + 4 * X + 3 * X^2
    >>> print(f'({P}) - ({Q}) = {P - Q}')
    (1 + 2 * X + 3 * X^2) - (1 + 2 * X) = 3 * X^2
    >>> print(f'({P}) * ({Q}) = {P * Q}')
    (1 + 2 * X + 3 * X^2) * (1 + 2 * X) = 1 + 4 * X + 7 * X^2 + 6 * X^3
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariatePolynomialImplementation_getClassName(self)

    def __repr__(self):
        return _func.UniVariatePolynomialImplementation___repr__(self)

    def __str__(self, *args):
        return _func.UniVariatePolynomialImplementation___str__(self, *args)

    def _repr_html_(self, *args):
        return _func.UniVariatePolynomialImplementation__repr_html_(self, *args)

    def __call__(self, *args):
        return _func.UniVariatePolynomialImplementation___call__(self, *args)

    def gradient(self, x):
        r"""
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariatePolynomialImplementation_gradient(self, x)

    def hessian(self, x):
        r"""
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariatePolynomialImplementation_hessian(self, x)

    def derivate(self):
        r"""
        Build the first-order derivative polynomial.

        Returns
        -------
        derivated_polynomial : :class:`~openturns.UniVariatePolynomial`
            The first-order derivated polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.derivate())
        2 + 6 * X
        """
        return _func.UniVariatePolynomialImplementation_derivate(self)

    def __mul__(self, *args):
        return _func.UniVariatePolynomialImplementation___mul__(self, *args)

    def incrementDegree(self, degree=1):
        r"""
        Multiply the polynomial by :math:`x^k`.

        Parameters
        ----------
        degree : int, optional
            The incremented degree :math:`k`.
            Default uses :math:`k = 1`.

        Returns
        -------
        incremented_degree_polynomial : :class:`~openturns.UniVariatePolynomial`
            Polynomial with incremented degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.incrementDegree())
        X + 2 * X^2 + 3 * X^3
        >>> print(P.incrementDegree(2))
        X^2 + 2 * X^3 + 3 * X^4
        """
        return _func.UniVariatePolynomialImplementation_incrementDegree(self, degree)

    def __add__(self, uniVariatePolynomial):
        return _func.UniVariatePolynomialImplementation___add__(self, uniVariatePolynomial)

    def __sub__(self, uniVariatePolynomial):
        return _func.UniVariatePolynomialImplementation___sub__(self, uniVariatePolynomial)

    def setCoefficients(self, coefficients):
        r"""
        Accessor to the polynomials's coefficients.

        Parameters
        ----------
        coefficients : sequence of float
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        getCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> P.setCoefficients([4.0, 2.0, 1.0])
        >>> print(P)
        4 + 2 * X + X^2
        """
        return _func.UniVariatePolynomialImplementation_setCoefficients(self, coefficients)

    def getCoefficients(self):
        r"""
        Accessor to the polynomials's coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.Point`
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        setCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getCoefficients())
        [1,2,3]
        """
        return _func.UniVariatePolynomialImplementation_getCoefficients(self)

    def getDegree(self):
        r"""
        Accessor to the polynomials's degree.

        Returns
        -------
        degree : int
            Polynomial's degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getDegree())
        2
        """
        return _func.UniVariatePolynomialImplementation_getDegree(self)

    def getRoots(self):
        r"""
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _func.UniVariatePolynomialImplementation_getRoots(self)

    def __init__(self, *args):
        _func.UniVariatePolynomialImplementation_swiginit(self, _func.new_UniVariatePolynomialImplementation(*args))
    __swig_destroy__ = _func.delete_UniVariatePolynomialImplementation

# Register UniVariatePolynomialImplementation in _func:
_func.UniVariatePolynomialImplementation_swigregister(UniVariatePolynomialImplementation)
class _UniVariatePolynomialImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._UniVariatePolynomialImplementationTypedInterfaceObject_swiginit(self, _func.new__UniVariatePolynomialImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._UniVariatePolynomialImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._UniVariatePolynomialImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._UniVariatePolynomialImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._UniVariatePolynomialImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._UniVariatePolynomialImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__UniVariatePolynomialImplementationTypedInterfaceObject

# Register _UniVariatePolynomialImplementationTypedInterfaceObject in _func:
_func._UniVariatePolynomialImplementationTypedInterfaceObject_swigregister(_UniVariatePolynomialImplementationTypedInterfaceObject)
class UniVariatePolynomial(_UniVariatePolynomialImplementationTypedInterfaceObject):
    r"""
    Base class for univariate polynomials.

    Parameters
    ----------
    coefficients : sequence of float
        Polynomial coefficients in increasing polynomial order.

    Examples
    --------
    >>> import openturns as ot

    Create a univariate polynomial from a list of coefficients:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> print(P)
    1 + 2 * X + 3 * X^2

    Univariate polynomials are of course callable:

    >>> print(P(1.0))
    6.0

    Addition, subtraction and multiplication of univariate polynomials:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> Q = ot.UniVariatePolynomial([1.0, 2.0])
    >>> print(f'({P}) + ({Q}) = {P + Q}')
    (1 + 2 * X + 3 * X^2) + (1 + 2 * X) = 2 + 4 * X + 3 * X^2
    >>> print(f'({P}) - ({Q}) = {P - Q}')
    (1 + 2 * X + 3 * X^2) - (1 + 2 * X) = 3 * X^2
    >>> print(f'({P}) * ({Q}) = {P * Q}')
    (1 + 2 * X + 3 * X^2) * (1 + 2 * X) = 1 + 4 * X + 7 * X^2 + 6 * X^3
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariatePolynomial_getClassName(self)

    def __repr__(self):
        return _func.UniVariatePolynomial___repr__(self)

    def _repr_html_(self, *args):
        return _func.UniVariatePolynomial__repr_html_(self, *args)

    def __str__(self, *args):
        return _func.UniVariatePolynomial___str__(self, *args)

    def __call__(self, *args):
        return _func.UniVariatePolynomial___call__(self, *args)

    def gradient(self, x):
        r"""
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariatePolynomial_gradient(self, x)

    def hessian(self, x):
        r"""
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariatePolynomial_hessian(self, x)

    def derivate(self):
        r"""
        Build the first-order derivative polynomial.

        Returns
        -------
        derivated_polynomial : :class:`~openturns.UniVariatePolynomial`
            The first-order derivated polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.derivate())
        2 + 6 * X
        """
        return _func.UniVariatePolynomial_derivate(self)

    def __mul__(self, *args):
        return _func.UniVariatePolynomial___mul__(self, *args)

    def incrementDegree(self, degree=1):
        r"""
        Multiply the polynomial by :math:`x^k`.

        Parameters
        ----------
        degree : int, optional
            The incremented degree :math:`k`.
            Default uses :math:`k = 1`.

        Returns
        -------
        incremented_degree_polynomial : :class:`~openturns.UniVariatePolynomial`
            Polynomial with incremented degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.incrementDegree())
        X + 2 * X^2 + 3 * X^3
        >>> print(P.incrementDegree(2))
        X^2 + 2 * X^3 + 3 * X^4
        """
        return _func.UniVariatePolynomial_incrementDegree(self, degree)

    def __add__(self, uniVariatePolynomial):
        return _func.UniVariatePolynomial___add__(self, uniVariatePolynomial)

    def __sub__(self, uniVariatePolynomial):
        return _func.UniVariatePolynomial___sub__(self, uniVariatePolynomial)

    def setCoefficients(self, coefficients):
        r"""
        Accessor to the polynomials's coefficients.

        Parameters
        ----------
        coefficients : sequence of float
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        getCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> P.setCoefficients([4.0, 2.0, 1.0])
        >>> print(P)
        4 + 2 * X + X^2
        """
        return _func.UniVariatePolynomial_setCoefficients(self, coefficients)

    def getCoefficients(self):
        r"""
        Accessor to the polynomials's coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.Point`
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        setCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getCoefficients())
        [1,2,3]
        """
        return _func.UniVariatePolynomial_getCoefficients(self)

    def getDegree(self):
        r"""
        Accessor to the polynomials's degree.

        Returns
        -------
        degree : int
            Polynomial's degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getDegree())
        2
        """
        return _func.UniVariatePolynomial_getDegree(self)

    def getRoots(self):
        r"""
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _func.UniVariatePolynomial_getRoots(self)

    def draw(self, xMin, xMax, pointNumber):
        r"""
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\max} > x_{\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariatePolynomial_draw(self, xMin, xMax, pointNumber)

    def __init__(self, *args):
        _func.UniVariatePolynomial_swiginit(self, _func.new_UniVariatePolynomial(*args))
    __swig_destroy__ = _func.delete_UniVariatePolynomial

# Register UniVariatePolynomial in _func:
_func.UniVariatePolynomial_swigregister(UniVariatePolynomial)
class AggregatedEvaluation(EvaluationImplementation):
    r"""
    Aggregated numerical math evaluation implementation.

    Parameters
    ----------
    functionsCollection : sequence of :class:`~openturns.Function`
        A collection of functions :math:`(f_i)_{i = 1, \ldots, l}` of size :math:`l`,
        such that :math:`\forall i \in \{1, \ldots, l\}`, 
        :math:`f_i : \Rset^n \rightarrow \Rset^{p_i}`.

    See also
    --------
    Function, DatabaseEvaluation, DualLinearCombinationEvaluation,
    LinearFunction

    Notes
    -----
    It implements a :class:`~openturns.Function`
    :math:`f : \Rset^n \rightarrow \Rset^{p_1 + \ldots + p_l}` defined by:

    .. math::
        \forall \vect{x} \in \Rset^n, f(\vect{x}) = \Tr{(f_1(\vect{x}), \ldots, f_l(\vect{x}))}

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.AggregatedEvaluation_getClassName(self)

    def __repr__(self):
        return _func.AggregatedEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.AggregatedEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.AggregatedEvaluation___call__(self, *args)

    def getFunctionsCollection(self):
        r"""
        Accessor to the collection of functions.

        Returns
        -------
        functionCol : :class:`~openturns.FunctionCollection`
            The collection of functions defining :math:`f`.
        """
        return _func.AggregatedEvaluation_getFunctionsCollection(self)

    def setFunctionsCollection(self, functionsCollection):
        r"""
        Accessor to the collection of functions.

        Parameters
        ----------
        functionsCollection : sequence of :class:`~openturns.Function`
            The collection of functions :math:`(f_i)_{i = 1, \ldots, l}` of size :math:`l`.
        """
        return _func.AggregatedEvaluation_setFunctionsCollection(self, functionsCollection)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.AggregatedEvaluation_getMarginal(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.AggregatedEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.AggregatedEvaluation_getOutputDimension(self)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.AggregatedEvaluation_parameterGradient(self, inP)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.AggregatedEvaluation_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.AggregatedEvaluation_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.AggregatedEvaluation_getParameterDescription(self)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func.AggregatedEvaluation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.AggregatedEvaluation_isLinearlyDependent(self, index)

    def setStopCallback(self, callBack, state=None):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop an evaluation.

        Parameters
        ----------
        callback : callable
            Returns a bool deciding whether to stop or continue.

        """
        return _func.AggregatedEvaluation_setStopCallback(self, callBack, state)

    def __init__(self, *args):
        _func.AggregatedEvaluation_swiginit(self, _func.new_AggregatedEvaluation(*args))
    __swig_destroy__ = _func.delete_AggregatedEvaluation

# Register AggregatedEvaluation in _func:
_func.AggregatedEvaluation_swigregister(AggregatedEvaluation)
class PiecewiseLinearEvaluation(EvaluationImplementation):
    r"""
    Piecewise linear interpolation evaluation.

    Parameters
    ----------
    locations : sequence of float
        Locations
    values : 1-d or 2-d sequence of float
        Values at each location

    See also
    --------
    PiecewiseHermiteEvaluation

    Examples
    --------
    >>> import openturns as ot
    >>> locations = [1.0, 2.0, 3.0, 4.0, 5.0]
    >>> values = [-2.0, 2.0, 1.0, 3.0, 5.0]
    >>> evaluation = ot.PiecewiseLinearEvaluation(locations, values)
    >>> f = ot.Function(evaluation)
    >>> print(f([2.5]))
    [1.5]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PiecewiseLinearEvaluation_getClassName(self)

    def __repr__(self):
        return _func.PiecewiseLinearEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.PiecewiseLinearEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.PiecewiseLinearEvaluation___call__(self, *args)

    def getLocations(self):
        return _func.PiecewiseLinearEvaluation_getLocations(self)

    def setLocations(self, locations):
        return _func.PiecewiseLinearEvaluation_setLocations(self, locations)

    def getValues(self):
        return _func.PiecewiseLinearEvaluation_getValues(self)

    def setValues(self, *args):
        return _func.PiecewiseLinearEvaluation_setValues(self, *args)

    def setLocationsAndValues(self, locations, values):
        return _func.PiecewiseLinearEvaluation_setLocationsAndValues(self, locations, values)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.PiecewiseLinearEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.PiecewiseLinearEvaluation_getOutputDimension(self)

    def __init__(self, *args):
        _func.PiecewiseLinearEvaluation_swiginit(self, _func.new_PiecewiseLinearEvaluation(*args))
    __swig_destroy__ = _func.delete_PiecewiseLinearEvaluation

# Register PiecewiseLinearEvaluation in _func:
_func.PiecewiseLinearEvaluation_swigregister(PiecewiseLinearEvaluation)
class PiecewiseHermiteEvaluation(EvaluationImplementation):
    r"""
    Piecewise Hermite interpolation evaluation.

    Parameters
    ----------
    locations : sequence of float
        Locations
    values : 1-d or 2-d sequence of float
        Values at each location
    derivatives : 1-d or 2-d sequence of float
        Derivatives at each location

    See also
    --------
    PiecewiseLinearEvaluation

    Examples
    --------
    >>> import openturns as ot
    >>> locations = [1.0, 2.0, 3.0, 4.0, 5.0]
    >>> values = [-2.0, 2.0, 1.0, 3.0, 5.0]
    >>> derivatives = [0.0]*5
    >>> evaluation = ot.PiecewiseHermiteEvaluation(locations, values, derivatives)
    >>> f = ot.Function(evaluation)
    >>> print(f([2.5]))
    [1.5]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PiecewiseHermiteEvaluation_getClassName(self)

    def __repr__(self):
        return _func.PiecewiseHermiteEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.PiecewiseHermiteEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.PiecewiseHermiteEvaluation___call__(self, *args)

    def derivate(self, inP):
        return _func.PiecewiseHermiteEvaluation_derivate(self, inP)

    def getLocations(self):
        return _func.PiecewiseHermiteEvaluation_getLocations(self)

    def setLocations(self, locations):
        return _func.PiecewiseHermiteEvaluation_setLocations(self, locations)

    def getValues(self):
        return _func.PiecewiseHermiteEvaluation_getValues(self)

    def setValues(self, values):
        return _func.PiecewiseHermiteEvaluation_setValues(self, values)

    def getDerivatives(self):
        return _func.PiecewiseHermiteEvaluation_getDerivatives(self)

    def setDerivatives(self, derivatives):
        return _func.PiecewiseHermiteEvaluation_setDerivatives(self, derivatives)

    def setLocationsValuesAndDerivatives(self, locations, values, derivatives):
        return _func.PiecewiseHermiteEvaluation_setLocationsValuesAndDerivatives(self, locations, values, derivatives)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.PiecewiseHermiteEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.PiecewiseHermiteEvaluation_getOutputDimension(self)

    def __init__(self, *args):
        _func.PiecewiseHermiteEvaluation_swiginit(self, _func.new_PiecewiseHermiteEvaluation(*args))
    __swig_destroy__ = _func.delete_PiecewiseHermiteEvaluation

# Register PiecewiseHermiteEvaluation in _func:
_func.PiecewiseHermiteEvaluation_swigregister(PiecewiseHermiteEvaluation)
class SymbolicEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::SymbolicEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.SymbolicEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.SymbolicEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.SymbolicEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.SymbolicEvaluation___str__(self, *args)

    def _repr_html_(self):
        return _func.SymbolicEvaluation__repr_html_(self)

    def __call__(self, *args):
        return _func.SymbolicEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.SymbolicEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.SymbolicEvaluation_getOutputDimension(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal.

        Parameters
        ----------
        indices : int or sequence of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \in indices}`, with :math:`f:\Rset^n \rightarrow \Rset^p`
            and :math:`f=(f_0 , \dots, f_{p-1})`.
        """
        return _func.SymbolicEvaluation_getMarginal(self, *args)

    def getInputVariablesNames(self):
        return _func.SymbolicEvaluation_getInputVariablesNames(self)

    def getOutputVariablesNames(self):
        return _func.SymbolicEvaluation_getOutputVariablesNames(self)

    def getFormulas(self):
        return _func.SymbolicEvaluation_getFormulas(self)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func.SymbolicEvaluation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.SymbolicEvaluation_isLinearlyDependent(self, index)

    def setCheckOutput(self, checkOutput):
        r"""
        Accessor to the output verification flag.

        Parameters
        ----------
        check_output : bool
            Whether to check return values for nan or inf.
        """
        return _func.SymbolicEvaluation_setCheckOutput(self, checkOutput)

    def __init__(self, *args):
        _func.SymbolicEvaluation_swiginit(self, _func.new_SymbolicEvaluation(*args))
    __swig_destroy__ = _func.delete_SymbolicEvaluation

# Register SymbolicEvaluation in _func:
_func.SymbolicEvaluation_swigregister(SymbolicEvaluation)
class SymbolicGradient(GradientImplementation):
    r"""Proxy of C++ OT::SymbolicGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.SymbolicGradient_getClassName(self)

    def __eq__(self, *args):
        return _func.SymbolicGradient___eq__(self, *args)

    def __repr__(self):
        return _func.SymbolicGradient___repr__(self)

    def __str__(self, *args):
        return _func.SymbolicGradient___str__(self, *args)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.SymbolicGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.SymbolicGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.SymbolicGradient_getOutputDimension(self)

    def getFormula(self, i, j):
        return _func.SymbolicGradient_getFormula(self, i, j)

    def getMarginal(self, *args):
        r"""
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : int
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.GradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.SymbolicGradient_getMarginal(self, *args)

    def __init__(self, *args):
        _func.SymbolicGradient_swiginit(self, _func.new_SymbolicGradient(*args))
    __swig_destroy__ = _func.delete_SymbolicGradient

# Register SymbolicGradient in _func:
_func.SymbolicGradient_swigregister(SymbolicGradient)
class SymbolicHessian(HessianImplementation):
    r"""Proxy of C++ OT::SymbolicHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.SymbolicHessian_getClassName(self)

    def __eq__(self, *args):
        return _func.SymbolicHessian___eq__(self, *args)

    def __repr__(self):
        return _func.SymbolicHessian___repr__(self)

    def __str__(self, *args):
        return _func.SymbolicHessian___str__(self, *args)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.SymbolicHessian_hessian(self, inP)

    def getFormula(self, i, j, k):
        return _func.SymbolicHessian_getFormula(self, i, j, k)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.SymbolicHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.SymbolicHessian_getOutputDimension(self)

    def getMarginal(self, *args):
        r"""
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : int
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.HessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.SymbolicHessian_getMarginal(self, *args)

    def __init__(self, *args):
        _func.SymbolicHessian_swiginit(self, _func.new_SymbolicHessian(*args))
    __swig_destroy__ = _func.delete_SymbolicHessian

# Register SymbolicHessian in _func:
_func.SymbolicHessian_swigregister(SymbolicHessian)
class DatabaseFunction(Function):
    r"""
    Pre-evaluated function.

    Available constructor:
        DatabaseFunction(*inputSample, outputSample*)

    Allows one to build a function takes a value in the output sample when presented
    the corresponding point in the input sample .

    Parameters
    ----------
    inputSample : 2-d sequence of float
        Values of the inputs.
    outputSample : 2-d sequence of float
        Values of the outputs.

    Examples
    --------
    >>> import openturns as ot
    >>> inputSample = [[1.0, 1.0], [2.0, 2.0]]
    >>> outputSample = [[4.0], [5.0]]
    >>> database = ot.DatabaseFunction(inputSample, outputSample)
    >>> x = [1.8] * database.getInputDimension()
    >>> print(database(x))
    [5]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DatabaseFunction_getClassName(self)

    def __eq__(self, *args):
        return _func.DatabaseFunction___eq__(self, *args)

    def __repr__(self):
        return _func.DatabaseFunction___repr__(self)

    def __str__(self, *args):
        return _func.DatabaseFunction___str__(self, *args)

    def __init__(self, *args):
        _func.DatabaseFunction_swiginit(self, _func.new_DatabaseFunction(*args))
    __swig_destroy__ = _func.delete_DatabaseFunction

# Register DatabaseFunction in _func:
_func.DatabaseFunction_swigregister(DatabaseFunction)
class DatabaseEvaluation(EvaluationImplementation):
    r"""
    Data based math evaluation implementation.

    Parameters
    ----------
    inputSample : 2-d sequence of float
        Sample :math:`\cS^{in}` of size :math:`l` and dimension :math:`n`.
    outputSample : 2-d sequence of float
        Sample :math:`\cS^{out}` of size :math:`l` and dimension :math:`p`.

    See also
    --------
    Function, AggregatedEvaluation, DualLinearCombinationEvaluation,
    LinearFunction

    Notes
    -----
    It returns a :class:`~openturns.Function` that implements a 
    nearest-neighbor function :math:`f : \Rset^n \rightarrow \Rset^p` based on the 
    input sample :math:`S^{in}` and taking values in the outputSample :math:`S^{out}`:

    .. math::
        \forall \vect{x} \in \Rset^n, f(\vect{x}) = y_{i*}

    where:

    .. math::
        i^* = \underset{ \vect{x}_i \in S^{in} }{ \argmin_{i \in \{1, \ldots, l\}} } \|\vect{x} - \vect{x}_i \|

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DatabaseEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.DatabaseEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.DatabaseEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.DatabaseEvaluation___str__(self, *args)

    def setInputSample(self, inputSample):
        r"""
        Accessor to the input sample defining the functions.

        Parameters
        ----------
        inputSample : :class:`~openturns.Sample`
            The input sample defining the function.
        """
        return _func.DatabaseEvaluation_setInputSample(self, inputSample)

    def getInputSample(self):
        r"""
        Accessor to the input sample defining the functions.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The input sample defining the function.
        """
        return _func.DatabaseEvaluation_getInputSample(self)

    def setOutputSample(self, outputSample):
        r"""
        Accessor to the output sample defining the functions.

        Parameters
        ----------
        outputSample : :class:`~openturns.Sample`
            The output sample defining the function.
        """
        return _func.DatabaseEvaluation_setOutputSample(self, outputSample)

    def getOutputSample(self):
        r"""
        Accessor to the output sample defining the functions.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The output sample defining the function.
        """
        return _func.DatabaseEvaluation_getOutputSample(self)

    def getNearestNeighbourAlgorithm(self):
        return _func.DatabaseEvaluation_getNearestNeighbourAlgorithm(self)

    def setNearestNeighbourAlgorithm(self, tree):
        return _func.DatabaseEvaluation_setNearestNeighbourAlgorithm(self, tree)

    def __call__(self, *args):
        return _func.DatabaseEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.DatabaseEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.DatabaseEvaluation_getOutputDimension(self)

    def __init__(self, *args):
        _func.DatabaseEvaluation_swiginit(self, _func.new_DatabaseEvaluation(*args))
    __swig_destroy__ = _func.delete_DatabaseEvaluation

# Register DatabaseEvaluation in _func:
_func.DatabaseEvaluation_swigregister(DatabaseEvaluation)
class IndicatorEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::IndicatorEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.IndicatorEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.IndicatorEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.IndicatorEvaluation___repr__(self)

    def __call__(self, *args):
        return _func.IndicatorEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.IndicatorEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.IndicatorEvaluation_getOutputDimension(self)

    def __init__(self, *args):
        _func.IndicatorEvaluation_swiginit(self, _func.new_IndicatorEvaluation(*args))
    __swig_destroy__ = _func.delete_IndicatorEvaluation

# Register IndicatorEvaluation in _func:
_func.IndicatorEvaluation_swigregister(IndicatorEvaluation)
class DistanceToDomainEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::DistanceToDomainEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DistanceToDomainEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.DistanceToDomainEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.DistanceToDomainEvaluation___repr__(self)

    def __call__(self, *args):
        return _func.DistanceToDomainEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.DistanceToDomainEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.DistanceToDomainEvaluation_getOutputDimension(self)

    def __init__(self, *args):
        _func.DistanceToDomainEvaluation_swiginit(self, _func.new_DistanceToDomainEvaluation(*args))
    __swig_destroy__ = _func.delete_DistanceToDomainEvaluation

# Register DistanceToDomainEvaluation in _func:
_func.DistanceToDomainEvaluation_swigregister(DistanceToDomainEvaluation)
class PolynomialCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _func.delete_PolynomialCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _func.PolynomialCollection_clear(self)

    def __len__(self):
        return _func.PolynomialCollection___len__(self)

    def __eq__(self, rhs):
        return _func.PolynomialCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _func.PolynomialCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _func.PolynomialCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _func.PolynomialCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _func.PolynomialCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _func.PolynomialCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.PolynomialCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.PolynomialCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.PolynomialCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.PolynomialCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.PolynomialCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _func.PolynomialCollection_find(self, val)

    def __repr__(self):
        return _func.PolynomialCollection___repr__(self)

    def __str__(self, *args):
        return _func.PolynomialCollection___str__(self, *args)

    def __init__(self, *args):
        _func.PolynomialCollection_swiginit(self, _func.new_PolynomialCollection(*args))

# Register PolynomialCollection in _func:
_func.PolynomialCollection_swigregister(PolynomialCollection)
class _PolynomialPersistentCollection(openturns.common.PersistentObject, PolynomialCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func._PolynomialPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _func._PolynomialPersistentCollection_swiginit(self, _func.new__PolynomialPersistentCollection(*args))

    def __repr__(self):
        return _func._PolynomialPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _func._PolynomialPersistentCollection___str__(self, *args)
    __swig_destroy__ = _func.delete__PolynomialPersistentCollection

# Register _PolynomialPersistentCollection in _func:
_func._PolynomialPersistentCollection_swigregister(_PolynomialPersistentCollection)
class ProductPolynomialEvaluation(EvaluationImplementation):
    r"""
    Product polynomial evaluation implementation.

    Parameters
    ----------
    distColl : :class:`~openturns.PolynomialCollection`
        A collection of :class:`~openturns.UniVariatePolynomial`.

    Notes
    -----
    It returns the product of the polynomials of *polCollection*. The input
    dimension *n* is equal to the number of polynomials in *polCollection*.

    Examples
    --------
    >>> import openturns as ot
    >>> P1 = ot.UniVariatePolynomial([1.0, 2.0, 3.0, 0])
    >>> P2 = ot.UniVariatePolynomial([3.0, 2.0, 4.0, 5.0])
    >>> P3 = ot.UniVariatePolynomial([-1.0, 0.0, 4, 0.0])
    >>> polyCol = ot.PolynomialCollection(1, P1)
    >>> polyCol.add(P2)
    >>> polyCol.add(P3)
    >>> productPoly = ot.ProductPolynomialEvaluation(polyCol)
    >>> productPoly([2, 1, 3])
    class=Point name=Unnamed dimension=1 values=[8330]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductPolynomialEvaluation_getClassName(self)

    def __repr__(self):
        return _func.ProductPolynomialEvaluation___repr__(self)

    def _repr_html_(self):
        return _func.ProductPolynomialEvaluation__repr_html_(self)

    def __str__(self, *args):
        return _func.ProductPolynomialEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.ProductPolynomialEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ProductPolynomialEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ProductPolynomialEvaluation_getOutputDimension(self)

    def __init__(self, *args):
        _func.ProductPolynomialEvaluation_swiginit(self, _func.new_ProductPolynomialEvaluation(*args))
    __swig_destroy__ = _func.delete_ProductPolynomialEvaluation

# Register ProductPolynomialEvaluation in _func:
_func.ProductPolynomialEvaluation_swigregister(ProductPolynomialEvaluation)
class ParametricEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::ParametricEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricEvaluation_getClassName(self)

    def __call__(self, *args):
        return _func.ParametricEvaluation___call__(self, *args)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.ParametricEvaluation_parameterGradient(self, inP)

    def getParametersPositions(self):
        return _func.ParametricEvaluation_getParametersPositions(self)

    def getInputPositions(self):
        return _func.ParametricEvaluation_getInputPositions(self)

    def getFunction(self):
        return _func.ParametricEvaluation_getFunction(self)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ParametricEvaluation_getInputDimension(self)

    def getParameterDimension(self):
        r"""
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func.ParametricEvaluation_getParameterDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ParametricEvaluation_getOutputDimension(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.ParametricEvaluation_setParameter(self, parameters)

    def isLinear(self):
        r"""
        Accessor to the linearity of the evaluation.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linear, *False* otherwise.
        """
        return _func.ParametricEvaluation_isLinear(self)

    def isLinearlyDependent(self, index):
        r"""
        Accessor to the linearity of the evaluation with regard to a specific variable.

        Parameters
        ----------
        index : int
            The index of the variable with regard to which linearity is evaluated.

        Returns
        -------
        linear : bool
            *True* if the evaluation is linearly dependent on the specified variable, *False* otherwise.
        """
        return _func.ParametricEvaluation_isLinearlyDependent(self, index)

    def __repr__(self):
        return _func.ParametricEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.ParametricEvaluation___str__(self, *args)

    def getInputDescription(self):
        r"""
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.ParametricEvaluation_getInputDescription(self)

    def setInputDescription(self, inputDescription):
        r"""
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.
        """
        return _func.ParametricEvaluation_setInputDescription(self, inputDescription)

    def getOutputDescription(self):
        r"""
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func.ParametricEvaluation_getOutputDescription(self)

    def setOutputDescription(self, outputDescription):
        r"""
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.
        """
        return _func.ParametricEvaluation_setOutputDescription(self, outputDescription)

    def setStopCallback(self, callBack, state=None):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop an evaluation.

        Parameters
        ----------
        callback : callable
            Returns a bool deciding whether to stop or continue.

        """
        return _func.ParametricEvaluation_setStopCallback(self, callBack, state)

    def __init__(self, *args):
        _func.ParametricEvaluation_swiginit(self, _func.new_ParametricEvaluation(*args))
    __swig_destroy__ = _func.delete_ParametricEvaluation

# Register ParametricEvaluation in _func:
_func.ParametricEvaluation_swigregister(ParametricEvaluation)
class ParametricGradient(GradientImplementation):
    r"""Proxy of C++ OT::ParametricGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricGradient_getClassName(self)

    def gradient(self, point):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ParametricGradient_gradient(self, point)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ParametricGradient_getInputDimension(self)

    def getParameterDimension(self):
        return _func.ParametricGradient_getParameterDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ParametricGradient_getOutputDimension(self)

    def __repr__(self):
        return _func.ParametricGradient___repr__(self)

    def __str__(self, *args):
        return _func.ParametricGradient___str__(self, *args)

    def __init__(self, *args):
        _func.ParametricGradient_swiginit(self, _func.new_ParametricGradient(*args))
    __swig_destroy__ = _func.delete_ParametricGradient

# Register ParametricGradient in _func:
_func.ParametricGradient_swigregister(ParametricGradient)
class ParametricHessian(HessianImplementation):
    r"""Proxy of C++ OT::ParametricHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricHessian_getClassName(self)

    def hessian(self, point):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ParametricHessian_hessian(self, point)

    def getEvaluation(self):
        return _func.ParametricHessian_getEvaluation(self)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ParametricHessian_getInputDimension(self)

    def getParameterDimension(self):
        return _func.ParametricHessian_getParameterDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ParametricHessian_getOutputDimension(self)

    def __repr__(self):
        return _func.ParametricHessian___repr__(self)

    def __str__(self, *args):
        return _func.ParametricHessian___str__(self, *args)

    def __init__(self, *args):
        _func.ParametricHessian_swiginit(self, _func.new_ParametricHessian(*args))
    __swig_destroy__ = _func.delete_ParametricHessian

# Register ParametricHessian in _func:
_func.ParametricHessian_swigregister(ParametricHessian)
class P1LagrangeEvaluation(EvaluationImplementation):
    r"""
    Evaluation of a P1 Lagrange interpolation over a field.

    Available constructors:

        P1LagrangeEvaluation(*field*)

    Parameters
    ----------
    field : :class:`~openturns.Field`
        Field :math:`\cF` defining the parameters of a P1 Lagrange interpolation function.

    See also
    --------
    Function, AggregatedEvaluation, DualLinearCombinationEvaluation,
    LinearFunction

    Notes
    -----
    It returns a :class:`~openturns.Function` that implements the P1 Lagrange interpolation function :math:`f : \cD_N \rightarrow \Rset^p` :

    .. math::
        \forall \vect{x} \in \Rset^n, f(\vect{x}) = \sum_{\vect{\xi}_i\in\cV(\vect{x})}\alpha_i f(\vect{\xi}_i)

    where :math:`\cD_N` is a :class:`~openturns.Mesh`, :math:`\cV(\vect{x})` is the simplex in :math:`\cD_N` that contains :math:`\vect{x}`, :math:`\alpha_i` are the barycentric coordinates of :math:`\vect{x}` wrt the vertices :math:`\vect{\xi}_i` of :math:`\cV(\vect{x})`:

    .. math::
        \vect{x}=\sum_{\vect{\xi}_i\in\cV(\vect{x})}\alpha_i\vect{\xi}_i

    Examples
    --------
    Create a P1 Lagrange evaluation:

    >>> import openturns as ot
    >>> field = ot.Field(ot.RegularGrid(0.0, 1.0, 4), [[0.5], [1.5], [1.0], [-0.5]])
    >>> evaluation = ot.P1LagrangeEvaluation(field)
    >>> print(evaluation([2.3]))
    [0.55]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.P1LagrangeEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.P1LagrangeEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.P1LagrangeEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.P1LagrangeEvaluation___str__(self, *args)

    def setField(self, field):
        r"""
        Accessor to the field defining the functions.

        Parameters
        ----------
        field : :class:`~openturns.Field`
            The field defining the function.
        """
        return _func.P1LagrangeEvaluation_setField(self, field)

    def getField(self):
        r"""
        Accessor to the field defining the functions.

        Returns
        -------
        field : :class:`~openturns.Field`
            The field defining the function.
        """
        return _func.P1LagrangeEvaluation_getField(self)

    def setMesh(self, mesh):
        r"""
        Accessor to the mesh over which the interpolation is defined.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            The mesh over which the interpolation is defined.
        """
        return _func.P1LagrangeEvaluation_setMesh(self, mesh)

    def getMesh(self):
        r"""
        Accessor to the mesh over which the interpolation is defined.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh over which the interpolation is defined.
        """
        return _func.P1LagrangeEvaluation_getMesh(self)

    def setValues(self, values):
        r"""
        Accessor to the values in which the interpolation is done.

        Parameters
        ----------
        mesh : 2-d sequence of floats
            The values in which the interpolation is done.
        """
        return _func.P1LagrangeEvaluation_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the values in which the interpolation is done.

        Returns
        -------
        values : :class:`~openturns.Sample`
            The values in which the interpolation is done.
        """
        return _func.P1LagrangeEvaluation_getValues(self)

    def setNearestNeighbourAlgorithm(self, nearestNeighbour):
        r"""
        Accessor to the algorithm used to find the vertex nearest to a given point.

        Parameters
        ----------
        algo : :class:`~openturns.NearestNeighbourAlgorithm`
            The algorithm used to find the vertex nearest to a given point.
        """
        return _func.P1LagrangeEvaluation_setNearestNeighbourAlgorithm(self, nearestNeighbour)

    def getNearestNeighbourAlgorithm(self):
        r"""
        Accessor to the algorithm used to find the vertex nearest to a given point.

        Returns
        -------
        algo : :class:`~openturns.NearestNeighbourAlgorithm`
            The algorithm used to find the vertex nearest to a given point.
        """
        return _func.P1LagrangeEvaluation_getNearestNeighbourAlgorithm(self)

    def setEnclosingSimplexAlgorithm(self, enclosingSimplex):
        r"""
        Accessor to the algorithm used to find the simplex containing a given point.

        Parameters
        ----------
        algo : :class:`~openturns.EnclosingSimplexAlgorithm`
            The algorithm used to find the simplex containing a given point.
        """
        return _func.P1LagrangeEvaluation_setEnclosingSimplexAlgorithm(self, enclosingSimplex)

    def getEnclosingSimplexAlgorithm(self):
        r"""
        Accessor to the algorithm used to find the simplex containing a given point.

        Returns
        -------
        algo : :class:`~openturns.EnclosingSimplexAlgorithm`
            The algorithm used to find the simplex containing a given point.
        """
        return _func.P1LagrangeEvaluation_getEnclosingSimplexAlgorithm(self)

    def __call__(self, *args):
        return _func.P1LagrangeEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.P1LagrangeEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.P1LagrangeEvaluation_getOutputDimension(self)

    def __init__(self, *args):
        _func.P1LagrangeEvaluation_swiginit(self, _func.new_P1LagrangeEvaluation(*args))
    __swig_destroy__ = _func.delete_P1LagrangeEvaluation

# Register P1LagrangeEvaluation in _func:
_func.P1LagrangeEvaluation_swigregister(P1LagrangeEvaluation)
class P1LagrangeInterpolation(FieldFunctionImplementation):
    r"""
    P1 interpolation of values between two meshes.

    This class is a :class:`~openturns.FieldFunction`, it first builds a projection
    matrix between two meshes, and can then interpolate a :class:`~openturns.Field` defined
    on input mesh onto a :class:`~openturns.Field` defined on output mesh.

    Available constructors:

        P1LagrangeInterpolation(*inputMesh, outputMesh, dimension*)

        P1LagrangeInterpolation(*inputMesh, outputMesh, dimension, enclosingSimplex, nearestNeighbour*)

    Parameters
    ----------
    inputMesh : :class:`~openturns.Mesh`
        Input mesh.

    outputMesh : :class:`~openturns.Mesh`
        Output mesh.

    dimension : int
        Dimension of fields to evaluate.

    enclosingSimplex : :class:`~openturns.EnclosingSimplexAlgorithm`
        Algorithm used to find the enclosing simplex of each output point in
        input mesh.  If a point is not contained in any mesh simplex, the
        nearest point is used.

    nearestNeighbour : :class:`~openturns.NearestNeighbourAlgorithm`
        Algorithm used to find nearest neighbour of an output point, when it
        is not contained in any simplex of input mesh.

    Notes
    -----

    A :class:`~openturns.FieldFunction` is usually defined by three numbers,
    the input dimension, and dimensions of input and output fields.
    Before evaluating a :class:`~openturns.Field`, classes check that its
    dimensions are the ones which had been declared.

    This class is special because it can deal with fields of any dimension,
    and output field will have the same dimension as input field.  This
    dimension is passed to constructor, but method :meth:`setDimension` can
    be called to interpolate fields of different dimensions without having
    to rebuild the projection between meshes.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.P1LagrangeInterpolation_getClassName(self)

    def setDimension(self, dimension):
        r"""
        Accessor to dimension of fields which are evaluated.

        Parameters
        ----------
        dimension : int
            Dimension of input fields which are going to be evaluated.
        """
        return _func.P1LagrangeInterpolation_setDimension(self, dimension)

    def getEnclosingSimplexAlgorithm(self):
        r"""
        Accessor to the algorithm used to find enclosing simplex.

        Returns
        -------
        enclosingSimplex : :class:`~openturns.EnclosingSimplexAlgorithm`
            Enclosing simplex algorithm.
        """
        return _func.P1LagrangeInterpolation_getEnclosingSimplexAlgorithm(self)

    def getNearestNeighbourAlgorithm(self):
        r"""
        Accessor to the algorithm used to find nearest neighbours.

        This algorithm is used only when point is not contained in any simplex.

        Returns
        -------
        nearestNeighbour : :class:`~openturns.NearestNeighbourAlgorithm`
            Nearest neighbour algorithm.
        """
        return _func.P1LagrangeInterpolation_getNearestNeighbourAlgorithm(self)

    def __eq__(self, *args):
        return _func.P1LagrangeInterpolation___eq__(self, *args)

    def __repr__(self):
        return _func.P1LagrangeInterpolation___repr__(self)

    def __str__(self, *args):
        return _func.P1LagrangeInterpolation___str__(self, *args)

    def __call__(self, field):
        return _func.P1LagrangeInterpolation___call__(self, field)

    def __init__(self, *args):
        _func.P1LagrangeInterpolation_swiginit(self, _func.new_P1LagrangeInterpolation(*args))
    __swig_destroy__ = _func.delete_P1LagrangeInterpolation

# Register P1LagrangeInterpolation in _func:
_func.P1LagrangeInterpolation_swigregister(P1LagrangeInterpolation)
class BasisImplementation(openturns.common.PersistentObject):
    r"""
    Basis.

    Available constructors:
        Basis(*functionsColl*)

        Basis(*size*)

    Parameters
    ----------
    functionsColl : list of :class:`~openturns.Function`
        Functions constituting the Basis.
    size : int
        Size of the Basis.

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> input = ['x0', 'x1', 'x2']
    >>> functions = []
    >>> for i in range(dimension):
    ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
    >>> basis = ot.Basis(functions)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisImplementation_getClassName(self)

    def build(self, index):
        r"""
        Build the element of the given index.

        Parameters
        ----------
        index : int, :math:`index \geq 0`
            Index of an element of the Basis.

        Returns
        -------
        function : :class:`~openturns.Function`
            The function at the index *index* of the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> print(basis.build(0).getEvaluation())
        [x0,x1,x2]->[x0]
        """
        return _func.BasisImplementation_build(self, index)

    def getSubBasis(self, indices):
        r"""
        Get a sub-basis of the Basis.

        Parameters
        ----------
        indices : list of int
            Indices of the terms of the Basis put in the sub-basis.

        Returns
        -------
        subBasis : list of :class:`~openturns.Function`
            Functions defining a sub-basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> subbasis = basis.getSubBasis([1])
        >>> print(subbasis[0].getEvaluation())
        [x0,x1,x2]->[x1]
        """
        return _func.BasisImplementation_getSubBasis(self, indices)

    def __repr__(self):
        return _func.BasisImplementation___repr__(self)

    def getInputDimension(self):
        r"""
        Get the input dimension of the Basis.

        Returns
        -------
        inDim : int
            Input dimension of the functions.
        """
        return _func.BasisImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the output dimension of the Basis.

        Returns
        -------
        outDim : int
            Output dimension of the functions.
        """
        return _func.BasisImplementation_getOutputDimension(self)

    def getSize(self):
        r"""
        Get the size of the Basis.

        Returns
        -------
        size : int
            Size of the Basis.
        """
        return _func.BasisImplementation_getSize(self)

    def isOrthogonal(self):
        r"""
        Tell whether the basis is orthogonal.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is orthogonal.
        """
        return _func.BasisImplementation_isOrthogonal(self)

    def isTensorProduct(self):
        r"""
        Tell whether the basis is a tensor product

        Returns
        -------
        isTensorProduct : bool
            `True` if the basis is a tensor product.
        """
        return _func.BasisImplementation_isTensorProduct(self)

    def isFinite(self):
        r"""
        Tell whether the basis is finite.

        Returns
        -------
        isFinite : bool
            `True` if the basis is finite.
        """
        return _func.BasisImplementation_isFinite(self)

    def add(self, elt):
        r"""
        Add a function.

        Parameters
        ----------
        function : a :class:`~openturns.Function`
            Function to be added.
        """
        return _func.BasisImplementation_add(self, elt)

    def __init__(self, *args):
        _func.BasisImplementation_swiginit(self, _func.new_BasisImplementation(*args))
    __swig_destroy__ = _func.delete_BasisImplementation

# Register BasisImplementation in _func:
_func.BasisImplementation_swigregister(BasisImplementation)
class BasisCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _func.delete_BasisCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _func.BasisCollection_clear(self)

    def __len__(self):
        return _func.BasisCollection___len__(self)

    def __eq__(self, rhs):
        return _func.BasisCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _func.BasisCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _func.BasisCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _func.BasisCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _func.BasisCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _func.BasisCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.BasisCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.BasisCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.BasisCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.BasisCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.BasisCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _func.BasisCollection_find(self, val)

    def __repr__(self):
        return _func.BasisCollection___repr__(self)

    def __str__(self, *args):
        return _func.BasisCollection___str__(self, *args)

    def __init__(self, *args):
        _func.BasisCollection_swiginit(self, _func.new_BasisCollection(*args))

# Register BasisCollection in _func:
_func.BasisCollection_swigregister(BasisCollection)
class _BasisPersistentCollection(openturns.common.PersistentObject, BasisCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func._BasisPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _func._BasisPersistentCollection_swiginit(self, _func.new__BasisPersistentCollection(*args))

    def __repr__(self):
        return _func._BasisPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _func._BasisPersistentCollection___str__(self, *args)
    __swig_destroy__ = _func.delete__BasisPersistentCollection

# Register _BasisPersistentCollection in _func:
_func._BasisPersistentCollection_swigregister(_BasisPersistentCollection)
class _BasisImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._BasisImplementationTypedInterfaceObject_swiginit(self, _func.new__BasisImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._BasisImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._BasisImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._BasisImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._BasisImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._BasisImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__BasisImplementationTypedInterfaceObject

# Register _BasisImplementationTypedInterfaceObject in _func:
_func._BasisImplementationTypedInterfaceObject_swigregister(_BasisImplementationTypedInterfaceObject)
class Basis(_BasisImplementationTypedInterfaceObject):
    r"""
    Basis.

    Available constructors:
        Basis(*functionsColl*)

        Basis(*size*)

    Parameters
    ----------
    functionsColl : list of :class:`~openturns.Function`
        Functions constituting the Basis.
    size : int
        Size of the Basis.

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> input = ['x0', 'x1', 'x2']
    >>> functions = []
    >>> for i in range(dimension):
    ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
    >>> basis = ot.Basis(functions)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Basis_getClassName(self)

    def build(self, index):
        r"""
        Build the element of the given index.

        Parameters
        ----------
        index : int, :math:`index \geq 0`
            Index of an element of the Basis.

        Returns
        -------
        function : :class:`~openturns.Function`
            The function at the index *index* of the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> print(basis.build(0).getEvaluation())
        [x0,x1,x2]->[x0]
        """
        return _func.Basis_build(self, index)

    def getSubBasis(self, indices):
        r"""
        Get a sub-basis of the Basis.

        Parameters
        ----------
        indices : list of int
            Indices of the terms of the Basis put in the sub-basis.

        Returns
        -------
        subBasis : list of :class:`~openturns.Function`
            Functions defining a sub-basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> subbasis = basis.getSubBasis([1])
        >>> print(subbasis[0].getEvaluation())
        [x0,x1,x2]->[x1]
        """
        return _func.Basis_getSubBasis(self, indices)

    def getInputDimension(self):
        r"""
        Get the input dimension of the Basis.

        Returns
        -------
        inDim : int
            Input dimension of the functions.
        """
        return _func.Basis_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the output dimension of the Basis.

        Returns
        -------
        outDim : int
            Output dimension of the functions.
        """
        return _func.Basis_getOutputDimension(self)

    def getSize(self):
        r"""
        Get the size of the Basis.

        Returns
        -------
        size : int
            Size of the Basis.
        """
        return _func.Basis_getSize(self)

    def add(self, elt):
        r"""
        Add a function.

        Parameters
        ----------
        function : a :class:`~openturns.Function`
            Function to be added.
        """
        return _func.Basis_add(self, elt)

    def isOrthogonal(self):
        r"""
        Tell whether the basis is orthogonal.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is orthogonal.
        """
        return _func.Basis_isOrthogonal(self)

    def isFinite(self):
        r"""
        Tell whether the basis is finite.

        Returns
        -------
        isFinite : bool
            `True` if the basis is finite.
        """
        return _func.Basis_isFinite(self)

    def __repr__(self):
        return _func.Basis___repr__(self)

    def __str__(self, *args):
        return _func.Basis___str__(self, *args)

    def __len__(self):
        return _func.Basis___len__(self)

    def __init__(self, *args):
        _func.Basis_swiginit(self, _func.new_Basis(*args))
    __swig_destroy__ = _func.delete_Basis

# Register Basis in _func:
_func.Basis_swigregister(Basis)
class _BasisSequenceImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._BasisSequenceImplementationTypedInterfaceObject_swiginit(self, _func.new__BasisSequenceImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._BasisSequenceImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._BasisSequenceImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._BasisSequenceImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._BasisSequenceImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._BasisSequenceImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__BasisSequenceImplementationTypedInterfaceObject

# Register _BasisSequenceImplementationTypedInterfaceObject in _func:
_func._BasisSequenceImplementationTypedInterfaceObject_swigregister(_BasisSequenceImplementationTypedInterfaceObject)
class BasisSequence(_BasisSequenceImplementationTypedInterfaceObject):
    r"""
    Sequence of basis.

    Parameters
    ----------
    basis : a :class:`~openturns.Basis`
        A Basis.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequence_getClassName(self)

    def getDimension(self):
        return _func.BasisSequence_getDimension(self)

    def getMasterBasis(self):
        return _func.BasisSequence_getMasterBasis(self)

    def getBasis(self, index):
        return _func.BasisSequence_getBasis(self, index)

    def getIndices(self, index):
        return _func.BasisSequence_getIndices(self, index)

    def getSize(self):
        return _func.BasisSequence_getSize(self)

    def add(self, indices):
        return _func.BasisSequence_add(self, indices)

    def __repr__(self):
        return _func.BasisSequence___repr__(self)

    def __str__(self, *args):
        return _func.BasisSequence___str__(self, *args)

    def __init__(self, *args):
        _func.BasisSequence_swiginit(self, _func.new_BasisSequence(*args))
    __swig_destroy__ = _func.delete_BasisSequence

# Register BasisSequence in _func:
_func.BasisSequence_swigregister(BasisSequence)
class BasisSequenceFactoryImplementation(openturns.common.PersistentObject):
    r"""
    Basis sequence factory.

    Available constructors:
        BasisSequenceFactory(*basisSeqFacImp*)

    Parameters
    ----------
    basisSeqFacImp : a BasisSequenceFactoryImplementation

    See also
    --------
    LARS

    Notes
    -----
    BasisSequenceFactory is the interface of the BasisSequenceFactoryImplementation.
    This class is not usable because it operates only within the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequenceFactoryImplementation_getClassName(self)

    def build(self, x, y, psi, indices):
        r"""
        Run the algorithm.

        Parameters
        ----------
        x : 2-d sequence of float
            Input sample
        y : 2-d sequence of float
            Output sample
        psi : sequence of :class:`~openturns.Function`
            Basis
        indices : sequence of int
            Current indices of the basis

        Returns
        -------
        measure : :class:`~openturns.BasisSequence`
            Fitting measure
        """
        return _func.BasisSequenceFactoryImplementation_build(self, x, y, psi, indices)

    def setMaximumRelativeConvergence(self, coefficientsPaths):
        r"""
        Accessor to the stopping criterion on the L1-norm of the coefficients.

        Parameters
        ----------
        e : float
            Stopping criterion.
        """
        return _func.BasisSequenceFactoryImplementation_setMaximumRelativeConvergence(self, coefficientsPaths)

    def getMaximumRelativeConvergence(self):
        r"""
        Accessor to the stopping criterion on the L1-norm of the coefficients.

        Returns
        -------
        e : float
            Stopping criterion.
        """
        return _func.BasisSequenceFactoryImplementation_getMaximumRelativeConvergence(self)

    def __repr__(self):
        return _func.BasisSequenceFactoryImplementation___repr__(self)

    def __str__(self, *args):
        return _func.BasisSequenceFactoryImplementation___str__(self, *args)

    def __init__(self, *args):
        _func.BasisSequenceFactoryImplementation_swiginit(self, _func.new_BasisSequenceFactoryImplementation(*args))
    __swig_destroy__ = _func.delete_BasisSequenceFactoryImplementation

# Register BasisSequenceFactoryImplementation in _func:
_func.BasisSequenceFactoryImplementation_swigregister(BasisSequenceFactoryImplementation)
class _BasisSequenceFactoryImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._BasisSequenceFactoryImplementationTypedInterfaceObject_swiginit(self, _func.new__BasisSequenceFactoryImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._BasisSequenceFactoryImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._BasisSequenceFactoryImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._BasisSequenceFactoryImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._BasisSequenceFactoryImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._BasisSequenceFactoryImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__BasisSequenceFactoryImplementationTypedInterfaceObject

# Register _BasisSequenceFactoryImplementationTypedInterfaceObject in _func:
_func._BasisSequenceFactoryImplementationTypedInterfaceObject_swigregister(_BasisSequenceFactoryImplementationTypedInterfaceObject)
class BasisSequenceFactory(_BasisSequenceFactoryImplementationTypedInterfaceObject):
    r"""
    Basis sequence factory.

    Available constructors:
        BasisSequenceFactory(*basisSeqFacImp*)

    Parameters
    ----------
    basisSeqFacImp : a BasisSequenceFactoryImplementation

    See also
    --------
    LARS

    Notes
    -----
    BasisSequenceFactory is the interface of the BasisSequenceFactoryImplementation.
    This class is not usable because it operates only within the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequenceFactory_getClassName(self)

    def __repr__(self):
        return _func.BasisSequenceFactory___repr__(self)

    def __str__(self, *args):
        return _func.BasisSequenceFactory___str__(self, *args)

    def build(self, x, y, psi, indices):
        r"""
        Run the algorithm.

        Parameters
        ----------
        x : 2-d sequence of float
            Input sample
        y : 2-d sequence of float
            Output sample
        psi : sequence of :class:`~openturns.Function`
            Basis
        indices : sequence of int
            Current indices of the basis

        Returns
        -------
        measure : :class:`~openturns.BasisSequence`
            Fitting measure
        """
        return _func.BasisSequenceFactory_build(self, x, y, psi, indices)

    def setMaximumRelativeConvergence(self, coefficientsPaths):
        r"""
        Accessor to the stopping criterion on the L1-norm of the coefficients.

        Parameters
        ----------
        e : float
            Stopping criterion.
        """
        return _func.BasisSequenceFactory_setMaximumRelativeConvergence(self, coefficientsPaths)

    def getMaximumRelativeConvergence(self):
        r"""
        Accessor to the stopping criterion on the L1-norm of the coefficients.

        Returns
        -------
        e : float
            Stopping criterion.
        """
        return _func.BasisSequenceFactory_getMaximumRelativeConvergence(self)

    def __init__(self, *args):
        _func.BasisSequenceFactory_swiginit(self, _func.new_BasisSequenceFactory(*args))
    __swig_destroy__ = _func.delete_BasisSequenceFactory

# Register BasisSequenceFactory in _func:
_func.BasisSequenceFactory_swigregister(BasisSequenceFactory)
class UniVariateFunctionFactory(openturns.common.PersistentObject):
    r"""Base class for univariate function factories."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariateFunctionFactory_getClassName(self)

    def __repr__(self):
        return _func.UniVariateFunctionFactory___repr__(self)

    def build(self, order):
        r"""
        Build the :math:`n`-th order univariate function.

        Parameters
        ----------
        n : int, :math:`0 \leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested univariate function.
        """
        return _func.UniVariateFunctionFactory_build(self, order)

    def __init__(self, *args):
        _func.UniVariateFunctionFactory_swiginit(self, _func.new_UniVariateFunctionFactory(*args))
    __swig_destroy__ = _func.delete_UniVariateFunctionFactory

# Register UniVariateFunctionFactory in _func:
_func.UniVariateFunctionFactory_swigregister(UniVariateFunctionFactory)
class MonomialFunctionFactory(UniVariateFunctionFactory):
    r"""Factory for univariate monomial functions."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.MonomialFunctionFactory_getClassName(self)

    def __repr__(self):
        return _func.MonomialFunctionFactory___repr__(self)

    def buildAsMonomialFunction(self, order):
        r"""
        Build the :math:`n`-th order monomial function.

        Parameters
        ----------
        n : int, :math:`0 \leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.MonomialFunction`
            Requested monomial function.
        """
        return _func.MonomialFunctionFactory_buildAsMonomialFunction(self, order)

    def build(self, order):
        r"""
        Build the :math:`n`-th order univariate function.

        Parameters
        ----------
        n : int, :math:`0 \leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested univariate function.
        """
        return _func.MonomialFunctionFactory_build(self, order)

    def __init__(self, *args):
        _func.MonomialFunctionFactory_swiginit(self, _func.new_MonomialFunctionFactory(*args))
    __swig_destroy__ = _func.delete_MonomialFunctionFactory

# Register MonomialFunctionFactory in _func:
_func.MonomialFunctionFactory_swigregister(MonomialFunctionFactory)
class _UniVariateFunctionFactoryTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _func._UniVariateFunctionFactoryTypedInterfaceObject_swiginit(self, _func.new__UniVariateFunctionFactoryTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _func._UniVariateFunctionFactoryTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._UniVariateFunctionFactoryTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._UniVariateFunctionFactoryTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _func._UniVariateFunctionFactoryTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _func._UniVariateFunctionFactoryTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _func.delete__UniVariateFunctionFactoryTypedInterfaceObject

# Register _UniVariateFunctionFactoryTypedInterfaceObject in _func:
_func._UniVariateFunctionFactoryTypedInterfaceObject_swigregister(_UniVariateFunctionFactoryTypedInterfaceObject)
class FunctionFamilyCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _func.delete_FunctionFamilyCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _func.FunctionFamilyCollection_clear(self)

    def __len__(self):
        return _func.FunctionFamilyCollection___len__(self)

    def __eq__(self, rhs):
        return _func.FunctionFamilyCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _func.FunctionFamilyCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _func.FunctionFamilyCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _func.FunctionFamilyCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _func.FunctionFamilyCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _func.FunctionFamilyCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.FunctionFamilyCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.FunctionFamilyCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.FunctionFamilyCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.FunctionFamilyCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.FunctionFamilyCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _func.FunctionFamilyCollection_find(self, val)

    def __repr__(self):
        return _func.FunctionFamilyCollection___repr__(self)

    def __str__(self, *args):
        return _func.FunctionFamilyCollection___str__(self, *args)

    def __init__(self, *args):
        _func.FunctionFamilyCollection_swiginit(self, _func.new_FunctionFamilyCollection(*args))

# Register FunctionFamilyCollection in _func:
_func.FunctionFamilyCollection_swigregister(FunctionFamilyCollection)
class UniVariateFunctionFamily(_UniVariateFunctionFactoryTypedInterfaceObject):
    r"""Base class for univariate function factories."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariateFunctionFamily_getClassName(self)

    def __init__(self, *args):
        _func.UniVariateFunctionFamily_swiginit(self, _func.new_UniVariateFunctionFamily(*args))

    def __repr__(self):
        return _func.UniVariateFunctionFamily___repr__(self)

    def build(self, order):
        r"""
        Build the :math:`n`-th order univariate function.

        Parameters
        ----------
        n : int, :math:`0 \leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested univariate function.
        """
        return _func.UniVariateFunctionFamily_build(self, order)
    __swig_destroy__ = _func.delete_UniVariateFunctionFamily

# Register UniVariateFunctionFamily in _func:
_func.UniVariateFunctionFamily_swigregister(UniVariateFunctionFamily)
class TensorizedUniVariateFunctionFactory(BasisImplementation):
    r"""
    Base class for tensorized multivariate functions.

    Parameters
    ----------
    functions : list of :class:`~openturns.UniVariateFunctionFamily`
        List of univariate function factories.
    enumerateFunction : :class:`~openturns.EnumerateFunction`, optional
        Associates to an integer its multi-index image in the :math:`\Nset^d`
        dimension, which is the dimension of the basis. This multi-index represents
        the collection of degrees of the univariate polynomials.

    Notes
    -----
    TensorizedUniVariateFunctionFactory allows one to create multidimensional functions as the tensor product of univariate
    functions created by their respective factories (i.e. :class:`~openturns.UniVariateFunctionFamily`):

    .. math::

       \Phi_n(x_1,\dots,x_d)=\prod_{i=1}^d \phi^i_{enum(n)_i}(x_i)


    where :math:`\phi^i_k` is the univariate basis of degree :math:`k` associated to the component :math:`x_i`
    and :math:`enum(n)_i` is the ith component of the multi-index :math:`enum(n)`


    Let's note that the exact hessian and gradient have been implemented
    for the product of polynomials.

    Examples
    --------
    >>> import openturns as ot
    >>> funcColl = [ot.HaarWaveletFactory(), ot.FourierSeriesFactory(), ot.MonomialFunctionFactory()]
    >>> dim = len(funcColl)
    >>> enumerateFunction = ot.LinearEnumerateFunction(dim)
    >>> productBasis = ot.TensorizedUniVariateFunctionFactory(funcColl, enumerateFunction)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TensorizedUniVariateFunctionFactory_getClassName(self)

    def build(self, index):
        r"""
        Build the element of the given index.

        Parameters
        ----------
        index : int, :math:`index \geq 0`
            Index of an element of the Basis.

        Returns
        -------
        function : :class:`~openturns.Function`
            The function at the index *index* of the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> print(basis.build(0).getEvaluation())
        [x0,x1,x2]->[x0]
        """
        return _func.TensorizedUniVariateFunctionFactory_build(self, index)

    def getEnumerateFunction(self):
        return _func.TensorizedUniVariateFunctionFactory_getEnumerateFunction(self)

    def setEnumerateFunction(self, phi):
        return _func.TensorizedUniVariateFunctionFactory_setEnumerateFunction(self, phi)

    def getFunctionFamilyCollection(self):
        return _func.TensorizedUniVariateFunctionFactory_getFunctionFamilyCollection(self)

    def setFunctionFamilyCollection(self, coll):
        return _func.TensorizedUniVariateFunctionFactory_setFunctionFamilyCollection(self, coll)

    def __repr__(self):
        return _func.TensorizedUniVariateFunctionFactory___repr__(self)

    def __init__(self, *args):
        _func.TensorizedUniVariateFunctionFactory_swiginit(self, _func.new_TensorizedUniVariateFunctionFactory(*args))
    __swig_destroy__ = _func.delete_TensorizedUniVariateFunctionFactory

# Register TensorizedUniVariateFunctionFactory in _func:
_func.TensorizedUniVariateFunctionFactory_swigregister(TensorizedUniVariateFunctionFactory)
class LARS(BasisSequenceFactoryImplementation):
    r"""
    Least Angle Regression.

    Refer to :ref:`polynomial_sparse_least_squares`.

    See also
    --------
    BasisSequenceFactory

    Notes
    -----
    LARS inherits from :class:`~openturns.BasisSequenceFactory`.

    If the size :math:`P` of the PC basis is of similar size to :math:`N`, or even
    possibly significantly larger than :math:`N` , then the following ordinary least
    squares problem is ill-posed:

    .. math::

        \vect{a} = \argmin_{\vect{b} \in \Rset^P} E_{\mu} \left[ \left( g \circ T^{-1}
                (\vect{U}) - \vect{b}^{\intercal} \vect{\Psi}(\vect{U}) \right)^2 \right]

    The sparse least squares approaches may be employed instead. Eventually a sparse
    PC representation is obtained, that is an approximation which only contains a
    small number of active basis functions.

    Examples
    --------
    >>> import openturns as ot
    >>> from openturns.usecases import ishigami_function
    >>> im = ishigami_function.IshigamiModel()
    >>> # Create the orthogonal basis
    >>> polynomialCollection = [ot.LegendreFactory()] * im.dim
    >>> enumerateFunction = ot.LinearEnumerateFunction(im.dim)
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polynomialCollection, enumerateFunction)
    >>> # experimental design
    >>> samplingSize = 75
    >>> experiment = ot.LowDiscrepancyExperiment(ot.SobolSequence(), im.inputDistribution, samplingSize)
    >>> # generate sample
    >>> x = experiment.generate()
    >>> y = im.model(x)
    >>> # iso transfo
    >>> xToU = ot.DistributionTransformation(im.inputDistribution, productBasis.getMeasure())
    >>> u = xToU(x)
    >>> # build basis
    >>> degree = 10
    >>> basisSize = enumerateFunction.getStrataCumulatedCardinal(degree)
    >>> basis = [productBasis.build(i) for i in range(basisSize)]
    >>> # run algorithm
    >>> factory = ot.BasisSequenceFactory(ot.LARS())
    >>> seq = factory.build(u, y, basis, list(range(basisSize)))

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LARS_getClassName(self)

    def build(self, x, y, psi, indices):
        r"""
        Run the algorithm.

        Parameters
        ----------
        x : 2-d sequence of float
            Input sample
        y : 2-d sequence of float
            Output sample
        psi : sequence of :class:`~openturns.Function`
            Basis
        indices : sequence of int
            Current indices of the basis

        Returns
        -------
        measure : :class:`~openturns.BasisSequence`
            Fitting measure
        """
        return _func.LARS_build(self, x, y, psi, indices)

    def __repr__(self):
        return _func.LARS___repr__(self)

    def __str__(self, *args):
        return _func.LARS___str__(self, *args)

    def __init__(self, *args):
        _func.LARS_swiginit(self, _func.new_LARS(*args))
    __swig_destroy__ = _func.delete_LARS

# Register LARS in _func:
_func.LARS_swigregister(LARS)
class BoxCoxEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::BoxCoxEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BoxCoxEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.BoxCoxEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.BoxCoxEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.BoxCoxEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.BoxCoxEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.BoxCoxEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.BoxCoxEvaluation_getOutputDimension(self)

    def getLambda(self):
        return _func.BoxCoxEvaluation_getLambda(self)

    def getShift(self):
        return _func.BoxCoxEvaluation_getShift(self)

    def __init__(self, *args):
        _func.BoxCoxEvaluation_swiginit(self, _func.new_BoxCoxEvaluation(*args))
    __swig_destroy__ = _func.delete_BoxCoxEvaluation

# Register BoxCoxEvaluation in _func:
_func.BoxCoxEvaluation_swigregister(BoxCoxEvaluation)
class BoxCoxTransform(Function):
    r"""
    BoxCox transformation.

    Refer to :ref:`boxcox_transformation`.

    Available constructors:
        BoxCoxTransform(*lambdaVect, shiftVect*)

        BoxCoxTransform(*lambda, shift*)

    Parameters
    ----------
    lambdaVect : sequence of float
        The  :math:`(\lambda_1, \dots, \lambda_d)` parameter.
    shiftVect : sequence of float
        The  :math:`(\alpha_1, \dots, \alpha_d)` parameter. 

        Default is :math:`(\alpha_1, \dots, \alpha_d)=(0, \dots, 0)`.
    lambda : float
        The  :math:`\lambda` parameter in the univariate case.
    shift : float
        The   :math:`\alpha` parameter in the univariate case.

        Default is :math:`\alpha = 0`.


    Notes
    -----
    The Box Cox transformation :math:`h_{\vect{\lambda}, \vect{\alpha}}: \Rset^d \rightarrow \Rset^d` writes for each component :math:`h_{\lambda_i, \alpha_i}: \Rset \rightarrow \Rset`:

    .. math::

        h_{\lambda_i, \alpha_i} (x)= 
        \left\{
        \begin{array}{ll}
        \dfrac{(x+\alpha_i)^{\lambda_i}-1}{\lambda} & \lambda_i \neq 0 \\
        \log(x+\alpha_i)                        & \lambda_i = 0
        \end{array}
        \right.

    for all :math:`x+\alpha_i >0`.

    The inverse Box Cox transformation writes:

    .. math::

        \begin{array}{lcl}
          h_{\lambda_i, \alpha_i}^{-1}(y) & = &
          \left\{
          \begin{array}{ll}
        \displaystyle (\lambda_i y + 1)^{\frac{1}{\lambda_i}} - \alpha_i & \lambda_i \neq 0 \\
        \displaystyle \exp(y) - \alpha_i                         & \lambda_i = 0
          \end{array}
          \right.
        \end{array}

    Examples
    --------

    Create a Box Cox transformation:

    >>> import openturns as ot
    >>> myLambda = 0.1
    >>> myBoxCox = ot.BoxCoxTransform(myLambda)

    Estimate a transformation from a sample:

    >>> mySample = ot.Exponential(2).getSample(100)
    >>> myModelTransform = ot.BoxCoxFactory().build(mySample)

    Apply ot to the sample:

    >>> myNormalSample = myModelTransform(mySample)

    >>> hist = ot.HistogramFactory().build(myNormalSample)
    >>> graph = hist.drawPDF()

    Apply it to a field:

    >>> myIndices= ot.Indices([10,5])
    >>> myMesher=ot.IntervalMesher(myIndices)
    >>> myInterval = ot.Interval([0.0, 0.0], [2.0, 1.0])
    >>> myMesh=myMesher.build(myInterval)
    >>> amplitude=[1.0]
    >>> scale=[0.2, 0.2]
    >>> myCovModel=ot.ExponentialModel(scale, amplitude)
    >>> myXproc=ot.GaussianProcess(myCovModel, myMesh)
    >>> g = ot.SymbolicFunction(['x1'],  ['exp(x1)'])
    >>> myDynTransform = ot.ValueFunction(g, myMesh)
    >>> myXtProcess = ot.CompositeProcess(myDynTransform, myXproc)

    >>> myField = myXtProcess.getRealization()
    >>> myModelTransform = ot.BoxCoxFactory().build(myField)
    >>> myStabilizedField = myModelTransform(myField.getValues())

    >>> marginal = ot.HistogramFactory().build(myStabilizedField)
    >>> graph2 = marginal.drawPDF()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BoxCoxTransform_getClassName(self)

    def getLambda(self):
        r"""
        Accessor to the :math:`\vect{\lambda}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.Point`
            The :math:`\vect{\lambda}` parameter.


        """
        return _func.BoxCoxTransform_getLambda(self)

    def getShift(self):
        r"""
        Accessor to the :math:`\vect{\alpha}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.Point`
            The :math:`\vect{\Lambda}` parameter.


        """
        return _func.BoxCoxTransform_getShift(self)

    def getInverse(self):
        r"""
        Accessor to the inverse Box Cox transformation.

        Returns
        -------
        myInverseBoxCox : :class:`~openturns.InverseBoxCoxTransform`
            The inverse Box Cox transformation.


        """
        return _func.BoxCoxTransform_getInverse(self)

    def __init__(self, *args):
        _func.BoxCoxTransform_swiginit(self, _func.new_BoxCoxTransform(*args))
    __swig_destroy__ = _func.delete_BoxCoxTransform

# Register BoxCoxTransform in _func:
_func.BoxCoxTransform_swigregister(BoxCoxTransform)
class InverseBoxCoxEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::InverseBoxCoxEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseBoxCoxEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.InverseBoxCoxEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.InverseBoxCoxEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.InverseBoxCoxEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.InverseBoxCoxEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.InverseBoxCoxEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.InverseBoxCoxEvaluation_getOutputDimension(self)

    def getLambda(self):
        return _func.InverseBoxCoxEvaluation_getLambda(self)

    def getShift(self):
        return _func.InverseBoxCoxEvaluation_getShift(self)

    def __init__(self, *args):
        _func.InverseBoxCoxEvaluation_swiginit(self, _func.new_InverseBoxCoxEvaluation(*args))
    __swig_destroy__ = _func.delete_InverseBoxCoxEvaluation

# Register InverseBoxCoxEvaluation in _func:
_func.InverseBoxCoxEvaluation_swigregister(InverseBoxCoxEvaluation)
class InverseBoxCoxTransform(Function):
    r"""
    BoxCox transformation.

    Available constructors:
        InverseBoxCoxTransform(*lambdaVect, shiftVect = 0*)

        InverseBoxCoxTransform(*lambda, shift=0*)

    Parameters
    ----------
    lambdaVect : :class:`~openturns.Point`
        The  :math:`(\lambda_1, \dots, \lambda_d)` parameter.
    shiftVect : :class:`~openturns.Point`
        The  :math:`(\alpha_1, \dots, \alpha_d)` parameter. 

        Default is :math:`(\alpha_1, \dots, \alpha_d)=(0, \dots, 0)`.
    lambda : float
        The  :math:`\lambda` parameter in the univariate case.
    shift : float
        The   :math:`\alpha` parameter in the univariate case.

        Default is :math:`\alpha = 0`.


    Notes
    -----
    The inverse Box Cox transformation :math:`h_{\vect{\lambda}, \vect{\alpha}}^{-1}: \Rset^d \rightarrow \Rset^d` writes for each component :math:`h_{\lambda_i, \alpha_i}^{-1}: \Rset \rightarrow \Rset`:

    .. math::

        \begin{array}{lcl}
          h_{\lambda_i, \alpha_i}^{-1}(y) & = &
          \left\{
          \begin{array}{ll}
        \displaystyle (\lambda_i y + 1)^{\frac{1}{\lambda_i}} - \alpha_i & \lambda_i \neq 0 \\
        \displaystyle \exp(y) - \alpha_i                         & \lambda_i = 0
          \end{array}
          \right.
        \end{array}

    The  Box Cox transformation writes:

    .. math::

        h_{\lambda_i, \alpha_i}^{-1} (x)= 
        \left\{
        \begin{array}{ll}
        \dfrac{(x+\alpha_i)^\lambda_i-1}{\lambda} & \lambda_i \neq 0 \\
        \log(x+\alpha_i)                        & \lambda_i = 0
        \end{array}
        \right.

    for all :math:`x+\alpha_i >0`.

    Examples
    --------

    Create an inverse Box Cox transformation:

    >>> import openturns as ot
    >>> myLambda = 0.1
    >>> myInverseBoxCox = ot.InverseBoxCoxTransform(myLambda)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseBoxCoxTransform_getClassName(self)

    def getLambda(self):
        r"""
        Accessor to the :math:`\vect{\lambda}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.Point`
            The :math:`\vect{\lambda}` parameter.


        """
        return _func.InverseBoxCoxTransform_getLambda(self)

    def getShift(self):
        r"""
        Accessor to the :math:`\vect{\alpha}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.Point`
            The :math:`\vect{\Lambda}` parameter.


        """
        return _func.InverseBoxCoxTransform_getShift(self)

    def getInverse(self):
        r"""
        Accessor to the  Box Cox transformation.

        Returns
        -------
        myInverseBoxCox : :class:`~openturns.BoxCoxTransform`
            The Box Cox transformation.


        """
        return _func.InverseBoxCoxTransform_getInverse(self)

    def __init__(self, *args):
        _func.InverseBoxCoxTransform_swiginit(self, _func.new_InverseBoxCoxTransform(*args))
    __swig_destroy__ = _func.delete_InverseBoxCoxTransform

# Register InverseBoxCoxTransform in _func:
_func.InverseBoxCoxTransform_swigregister(InverseBoxCoxTransform)
class TrendEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::TrendEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TrendEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.TrendEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.TrendEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.TrendEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.TrendEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.TrendEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.TrendEvaluation_getOutputDimension(self)

    def getFunction(self):
        return _func.TrendEvaluation_getFunction(self)

    def __init__(self, *args):
        _func.TrendEvaluation_swiginit(self, _func.new_TrendEvaluation(*args))
    __swig_destroy__ = _func.delete_TrendEvaluation

# Register TrendEvaluation in _func:
_func.TrendEvaluation_swigregister(TrendEvaluation)
class TrendTransform(VertexValueFunction):
    r"""
    Trend transformation.

    Parameters
    ----------
    trend : :class:`~openturns.Function`
        The trend function :math:`f_{trend}` of a process.
    mesh : :class:`~openturns.Mesh`
        The mesh on which :math:`f_{trend}` is applied.

    Notes
    -----
    A multivariate stochastic process :math:`X: \Omega \times\cD \rightarrow \Rset^d` of dimension *d* where :math:`\cD \in \Rset^n` may write as the sum of a trend function :math:`f_{trend}: \Rset^n \rightarrow \Rset^d` and a stationary multivariate stochastic process :math:`X_{stat}: \Omega \times\cD \rightarrow \Rset^d` of dimension *d* as follows:

    .. math::

        X(\omega,\vect{t}) = X_{stat}(\omega,\vect{t}) + f_{trend}(\vect{t})


    We note :math:`(\vect{x}_0, \dots, \vect{x}_{N-1})` the values of one field of the process *X*, associated to the mesh :math:`\cM = (\vect{t}_0, \dots, \vect{t}_{N-1})` of :math:`\cD`. We note :math:`(\vect{x}^{stat}_0, \dots, \vect{x}^{stat}_{N-1})` the values of the resulting stationary field. Then we have:

    .. math::

        \vect{x}^{stat}_i = \vect{x}_i - f_{trend}(\vect{t}_i)


    Examples
    --------
    Create a trend function: :math:`f_{trend} : \Rset \mapsto \Rset` where :math:`f_{trend}(t)=1+2t+t^2`:

    >>> import openturns as ot
    >>> myGrid = ot.RegularGrid(0.0, 0.1, 10)
    >>> f = ot.SymbolicFunction(['t'], ['1+2*t+t^2'])
    >>> fTrend = ot.TrendTransform(f, myGrid)

    Add it to a process:

    >>> amplitude=[5.0]
    >>> scale=[0.2]
    >>> myCovModel=ot.ExponentialModel(scale, amplitude)
    >>> myXProcess=ot.GaussianProcess(myCovModel, myGrid)
    >>> myYProcess = ot.CompositeProcess(fTrend, myXProcess)

    Remove it from a field:

    >>> myField = myYProcess.getRealization()
    >>> myStatField = fTrend.getInverse()(myField)

    Then re-add it:

    >>> myInitialField = fTrend(myStatField)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TrendTransform_getClassName(self)

    def __eq__(self, *args):
        return _func.TrendTransform___eq__(self, *args)

    def __repr__(self):
        return _func.TrendTransform___repr__(self)

    def __str__(self, *args):
        return _func.TrendTransform___str__(self, *args)

    def getInverse(self):
        r"""
        Accessor to the inverse trend function.

        Returns
        -------
        myInverseTrendTransform : :class:`~openturns.InverseTrendTransform`
            The :math:`f_{trend}^{-1}` function.


        """
        return _func.TrendTransform_getInverse(self)

    def getTrendFunction(self):
        r"""
        Accessor to the trend function.

        Returns
        -------
        trend : :class:`~openturns.Function`
            The trend function :math:`f_{trend}` of a process.

        """
        return _func.TrendTransform_getTrendFunction(self)

    def __init__(self, *args):
        _func.TrendTransform_swiginit(self, _func.new_TrendTransform(*args))
    __swig_destroy__ = _func.delete_TrendTransform

# Register TrendTransform in _func:
_func.TrendTransform_swigregister(TrendTransform)
class InverseTrendEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::InverseTrendEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseTrendEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.InverseTrendEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.InverseTrendEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.InverseTrendEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.InverseTrendEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.InverseTrendEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.InverseTrendEvaluation_getOutputDimension(self)

    def getFunction(self):
        return _func.InverseTrendEvaluation_getFunction(self)

    def __init__(self, *args):
        _func.InverseTrendEvaluation_swiginit(self, _func.new_InverseTrendEvaluation(*args))
    __swig_destroy__ = _func.delete_InverseTrendEvaluation

# Register InverseTrendEvaluation in _func:
_func.InverseTrendEvaluation_swigregister(InverseTrendEvaluation)
class InverseTrendTransform(VertexValueFunction):
    r"""
    Inverse Trend transformation.

    Parameters
    ----------
    myInverseTrendFunc : :class:`~openturns.Function`
        The  inverse trend function :math:`f_{trend}^{-1}`.


    Notes
    -----
    A multivariate stochastic  process :math:`X: \Omega \times\cD \rightarrow \Rset^d` of dimension *d* where :math:`\cD \in \Rset^n` may write as the sum of a trend function :math:`f_{trend}: \Rset^n \rightarrow \Rset^d` and a stationary multivariate stochastic process :math:`X_{stat}: \Omega \times\cD \rightarrow \Rset^d` of dimension *d* as follows:

    .. math::

        X(\omega,\vect{t}) = X_{stat}(\omega,\vect{t}) + f_{trend}(\vect{t})


    We note :math:`(\vect{x}_0, \dots, \vect{x}_{N-1})` the values of one field of the process *X*, associated to the mesh :math:`\cM = (\vect{t}_0, \dots, \vect{t}_{N-1})` of :math:`\cD`. We note :math:`(\vect{x}^{stat}_0, \dots, \vect{x}^{stat}_{N-1})` the values of the resulting stationary field. Then we have:

    .. math::

        \vect{x}^{stat}_i = \vect{x}_i - f_{trend}(\vect{t}_i)

    The inverse trend transformation enables to get the :math:`X_{stat}` process or to get the :math:`(\vect{x}^{stat}_0, \dots, \vect{x}^{stat}_{N-1})` field.


    Examples
    --------
    Create a trend function: :math:`f_{trend} : \Rset \mapsto \Rset` where :math:`f_{trend}(t,s)=-(1+2t+t^2)`:

    >>> import openturns as ot
    >>> h = ot.SymbolicFunction(['t'], ['-(1+2*t+t^2)'])
    >>> mesh = ot.RegularGrid(0.0, 0.1, 11)
    >>> fTrendInv = ot.InverseTrendTransform(h, mesh)


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseTrendTransform_getClassName(self)

    def getInverse(self):
        r"""
        Accessor to the  trend function.

        Returns
        -------
        myTrendTransform : :class:`~openturns.TrendTransform`
            The :math:`f_{trend}` function.


        """
        return _func.InverseTrendTransform_getInverse(self)

    def getTrendFunction(self):
        return _func.InverseTrendTransform_getTrendFunction(self)

    def __repr__(self):
        return _func.InverseTrendTransform___repr__(self)

    def __init__(self, *args):
        _func.InverseTrendTransform_swiginit(self, _func.new_InverseTrendTransform(*args))
    __swig_destroy__ = _func.delete_InverseTrendTransform

# Register InverseTrendTransform in _func:
_func.InverseTrendTransform_swigregister(InverseTrendTransform)
class BasisFactory(openturns.common.PersistentObject):
    r"""
    Basis factory base class.

    Parameters
    ----------
    orthogUniVarPolFactory : :class:`~openturns.OrthogonalUniVariatePolynomialFactory`
        Factory that builds particular univariate polynomial (e.g. Hermite,
        Legendre, Laguerre, ...).

    See also
    --------
    ConstantBasisFactory, LinearBasisFactory, QuadraticBasisFactory

    Notes
    -----
    BasisFactory is the interface of the OrthogonalUniVariatePolynomialFactory
    implementation. It represents the factory that allows the construction of any
    univariate orthonormal polynomial with any degree.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisFactory_getClassName(self)

    def __repr__(self):
        return _func.BasisFactory___repr__(self)

    def build(self):
        r"""
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.BasisFactory_build(self)

    def __init__(self, *args):
        _func.BasisFactory_swiginit(self, _func.new_BasisFactory(*args))
    __swig_destroy__ = _func.delete_BasisFactory

# Register BasisFactory in _func:
_func.BasisFactory_swigregister(BasisFactory)
class ConstantBasisFactory(BasisFactory):
    r"""
    Constant basis factory.

    Parameters
    ----------
    dimension : int
        Input dimension of the basis.

    See also
    --------
    BasisFactory, LinearBasisFactory, QuadraticBasisFactory

    Notes
    -----
    A factory for constant basis of input dimension *dimension*.

    Examples
    --------
    >>> import openturns as ot
    >>> basis = ot.ConstantBasisFactory(2).build()
    >>> f = ot.AggregatedFunction(basis)
    >>> x = [2, 3]
    >>> print(f(x))
    [1]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ConstantBasisFactory_getClassName(self)

    def __repr__(self):
        return _func.ConstantBasisFactory___repr__(self)

    def build(self):
        r"""
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.ConstantBasisFactory_build(self)

    def __init__(self, *args):
        _func.ConstantBasisFactory_swiginit(self, _func.new_ConstantBasisFactory(*args))
    __swig_destroy__ = _func.delete_ConstantBasisFactory

# Register ConstantBasisFactory in _func:
_func.ConstantBasisFactory_swigregister(ConstantBasisFactory)
class LinearBasisFactory(BasisFactory):
    r"""
    Linear basis factory.

    The linear basis is the collection of functions :math:`\psi_k: \mathbb{R}^d \mapsto \mathbb{R}` for :math:`0 \leq k \leq d` defined:

    .. math::

        \psi_0(x_1, \dots, x_d) & = 1 \\
        \psi_k(x_1, \dots, x_d) & = x_k \mbox{for } 1 \leq k \leq d

    Parameters
    ----------
    dimension : int
        Input dimension :math:`d` of the basis.

    See also
    --------
    BasisFactory, ConstantBasisFactory, QuadraticBasisFactory

    Examples
    --------
    >>> import openturns as ot
    >>> basis = ot.LinearBasisFactory(2).build()
    >>> psi_1 = basis.build(1)
    >>> print(psi_1)
    class=LinearEvaluation name=Unnamed center=[0,0] constant=[0] linear=[[ 1 ]
     [ 0 ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearBasisFactory_getClassName(self)

    def __repr__(self):
        return _func.LinearBasisFactory___repr__(self)

    def build(self):
        r"""
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.LinearBasisFactory_build(self)

    def __init__(self, *args):
        _func.LinearBasisFactory_swiginit(self, _func.new_LinearBasisFactory(*args))
    __swig_destroy__ = _func.delete_LinearBasisFactory

# Register LinearBasisFactory in _func:
_func.LinearBasisFactory_swigregister(LinearBasisFactory)
class QuadraticBasisFactory(BasisFactory):
    r"""
    Quadratic basis factory.

    The quadratic basis is composed of the quadratic terms of the canonical basis:

    .. math::

        \{ \psi_k(x) \} = \{ 1, x_1, \hdots, x_n, x_i x_j \forall i,j \in [1,n] \}

    Parameters
    ----------
    dimension : int
        Input dimension of the basis.

    See also
    --------
    BasisFactory, ConstantBasisFactory, LinearBasisFactory

    Examples
    --------
    >>> import openturns as ot
    >>> basis = ot.QuadraticBasisFactory(2).build()
    >>> f = ot.AggregatedFunction(basis)
    >>> x = [2, 3]
    >>> print(f(x))
    [1,2,3,4,6,9]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.QuadraticBasisFactory_getClassName(self)

    def __repr__(self):
        return _func.QuadraticBasisFactory___repr__(self)

    def build(self):
        r"""
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.QuadraticBasisFactory_build(self)

    def __init__(self, *args):
        _func.QuadraticBasisFactory_swiginit(self, _func.new_QuadraticBasisFactory(*args))
    __swig_destroy__ = _func.delete_QuadraticBasisFactory

# Register QuadraticBasisFactory in _func:
_func.QuadraticBasisFactory_swigregister(QuadraticBasisFactory)
class NullHessian(HessianImplementation):
    r"""Proxy of C++ OT::NullHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NullHessian_getClassName(self)

    def __eq__(self, *args):
        return _func.NullHessian___eq__(self, *args)

    def __repr__(self):
        return _func.NullHessian___repr__(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NullHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NullHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NullHessian_getOutputDimension(self)

    def __init__(self, *args):
        _func.NullHessian_swiginit(self, _func.new_NullHessian(*args))
    __swig_destroy__ = _func.delete_NullHessian

# Register NullHessian in _func:
_func.NullHessian_swigregister(NullHessian)
class MarginalEvaluation(EvaluationImplementation):
    r"""Proxy of C++ OT::MarginalEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.MarginalEvaluation_getClassName(self)

    def __eq__(self, *args):
        return _func.MarginalEvaluation___eq__(self, *args)

    def __repr__(self):
        return _func.MarginalEvaluation___repr__(self)

    def getIndices(self):
        return _func.MarginalEvaluation_getIndices(self)

    def getEvaluation(self):
        return _func.MarginalEvaluation_getEvaluation(self)

    def __call__(self, *args):
        return _func.MarginalEvaluation___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.MarginalEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.MarginalEvaluation_getOutputDimension(self)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.MarginalEvaluation_parameterGradient(self, inP)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.MarginalEvaluation_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.MarginalEvaluation_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.MarginalEvaluation_getParameterDescription(self)

    def setParameterDescription(self, description):
        r"""
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.MarginalEvaluation_setParameterDescription(self, description)

    def setCheckOutput(self, checkOutput):
        r"""
        Accessor to the output verification flag.

        Parameters
        ----------
        check_output : bool
            Whether to check return values for nan or inf.
        """
        return _func.MarginalEvaluation_setCheckOutput(self, checkOutput)

    def getCheckOutput(self):
        r"""
        Accessor to the output verification flag.

        Returns
        -------
        check_output : bool
            Whether to check return values for nan or inf.
        """
        return _func.MarginalEvaluation_getCheckOutput(self)

    def __init__(self, *args):
        _func.MarginalEvaluation_swiginit(self, _func.new_MarginalEvaluation(*args))
    __swig_destroy__ = _func.delete_MarginalEvaluation

# Register MarginalEvaluation in _func:
_func.MarginalEvaluation_swigregister(MarginalEvaluation)
class MarginalGradient(GradientImplementation):
    r"""Proxy of C++ OT::MarginalGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.MarginalGradient_getClassName(self)

    def __eq__(self, *args):
        return _func.MarginalGradient___eq__(self, *args)

    def __repr__(self):
        return _func.MarginalGradient___repr__(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.MarginalGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.MarginalGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.MarginalGradient_getOutputDimension(self)

    def __init__(self, *args):
        _func.MarginalGradient_swiginit(self, _func.new_MarginalGradient(*args))
    __swig_destroy__ = _func.delete_MarginalGradient

# Register MarginalGradient in _func:
_func.MarginalGradient_swigregister(MarginalGradient)
class MarginalHessian(HessianImplementation):
    r"""Proxy of C++ OT::MarginalHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.MarginalHessian_getClassName(self)

    def __eq__(self, *args):
        return _func.MarginalHessian___eq__(self, *args)

    def __repr__(self):
        return _func.MarginalHessian___repr__(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.MarginalHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.MarginalHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.MarginalHessian_getOutputDimension(self)

    def __init__(self, *args):
        _func.MarginalHessian_swiginit(self, _func.new_MarginalHessian(*args))
    __swig_destroy__ = _func.delete_MarginalHessian

# Register MarginalHessian in _func:
_func.MarginalHessian_swigregister(MarginalHessian)
class _UniVariatePolynomialImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_func._UniVariatePolynomialImplementationPointer_ptr__get, _func._UniVariatePolynomialImplementationPointer_ptr__set)

    def __init__(self, *args):
        _func._UniVariatePolynomialImplementationPointer_swiginit(self, _func.new__UniVariatePolynomialImplementationPointer(*args))
    __swig_destroy__ = _func.delete__UniVariatePolynomialImplementationPointer

    def reset(self):
        return _func._UniVariatePolynomialImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _func._UniVariatePolynomialImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _func._UniVariatePolynomialImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _func._UniVariatePolynomialImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _func._UniVariatePolynomialImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _func._UniVariatePolynomialImplementationPointer_get(self)

    def getImplementation(self):
        return _func._UniVariatePolynomialImplementationPointer_getImplementation(self)

    def unique(self):
        return _func._UniVariatePolynomialImplementationPointer_unique(self)

    def use_count(self):
        return _func._UniVariatePolynomialImplementationPointer_use_count(self)

    def swap(self, other):
        return _func._UniVariatePolynomialImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func._UniVariatePolynomialImplementationPointer_getClassName(self)

    def __repr__(self):
        return _func._UniVariatePolynomialImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _func._UniVariatePolynomialImplementationPointer___str__(self, *args)

    def _repr_html_(self, *args):
        return _func._UniVariatePolynomialImplementationPointer__repr_html_(self, *args)

    def __call__(self, *args):
        return _func._UniVariatePolynomialImplementationPointer___call__(self, *args)

    def gradient(self, x):
        r"""
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func._UniVariatePolynomialImplementationPointer_gradient(self, x)

    def hessian(self, x):
        r"""
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func._UniVariatePolynomialImplementationPointer_hessian(self, x)

    def derivate(self):
        r"""
        Build the first-order derivative polynomial.

        Returns
        -------
        derivated_polynomial : :class:`~openturns.UniVariatePolynomial`
            The first-order derivated polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.derivate())
        2 + 6 * X
        """
        return _func._UniVariatePolynomialImplementationPointer_derivate(self)

    def __mul__(self, *args):
        return _func._UniVariatePolynomialImplementationPointer___mul__(self, *args)

    def incrementDegree(self, degree=1):
        r"""
        Multiply the polynomial by :math:`x^k`.

        Parameters
        ----------
        degree : int, optional
            The incremented degree :math:`k`.
            Default uses :math:`k = 1`.

        Returns
        -------
        incremented_degree_polynomial : :class:`~openturns.UniVariatePolynomial`
            Polynomial with incremented degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.incrementDegree())
        X + 2 * X^2 + 3 * X^3
        >>> print(P.incrementDegree(2))
        X^2 + 2 * X^3 + 3 * X^4
        """
        return _func._UniVariatePolynomialImplementationPointer_incrementDegree(self, degree)

    def __add__(self, uniVariatePolynomial):
        return _func._UniVariatePolynomialImplementationPointer___add__(self, uniVariatePolynomial)

    def __sub__(self, uniVariatePolynomial):
        return _func._UniVariatePolynomialImplementationPointer___sub__(self, uniVariatePolynomial)

    def setCoefficients(self, coefficients):
        r"""
        Accessor to the polynomials's coefficients.

        Parameters
        ----------
        coefficients : sequence of float
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        getCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> P.setCoefficients([4.0, 2.0, 1.0])
        >>> print(P)
        4 + 2 * X + X^2
        """
        return _func._UniVariatePolynomialImplementationPointer_setCoefficients(self, coefficients)

    def getCoefficients(self):
        r"""
        Accessor to the polynomials's coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.Point`
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        setCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getCoefficients())
        [1,2,3]
        """
        return _func._UniVariatePolynomialImplementationPointer_getCoefficients(self)

    def getDegree(self):
        r"""
        Accessor to the polynomials's degree.

        Returns
        -------
        degree : int
            Polynomial's degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getDegree())
        2
        """
        return _func._UniVariatePolynomialImplementationPointer_getDegree(self)

    def getRoots(self):
        r"""
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _func._UniVariatePolynomialImplementationPointer_getRoots(self)

    def draw(self, xMin, xMax, pointNumber):
        r"""
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\max} > x_{\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func._UniVariatePolynomialImplementationPointer_draw(self, xMin, xMax, pointNumber)

    def __eq__(self, other):
        return _func._UniVariatePolynomialImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _func._UniVariatePolynomialImplementationPointer___ne__(self, other)

    def __repr_markdown__(self):
        return _func._UniVariatePolynomialImplementationPointer___repr_markdown__(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func._UniVariatePolynomialImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func._UniVariatePolynomialImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func._UniVariatePolynomialImplementationPointer_setName(self, name)

# Register _UniVariatePolynomialImplementationPointer in _func:
_func._UniVariatePolynomialImplementationPointer_swigregister(_UniVariatePolynomialImplementationPointer)

