%define OT_LinearProfile_doc
"Linear temperature profile.

Available constructor:
    LinearProfile(*T0, iMax*)


Parameters
----------
T0 : float
    Initial temperature
iMax : int
    Number of maximal iterations

Notes
-----
The temperature write:

.. math::
    :nowrap:

    \\begin{equation*}
        T(i) = T_0*(1 - \\frac{i}{iMax}), i \\in [0,iMax]
    \\end{equation*}

Examples
--------
>>> import openturns as ot
>>> # Define a profile
>>> T0 = 10.0
>>> iMax = 100
>>> linearProfile = ot.LinearProfile(T0, iMax)
"
%enddef
%feature("docstring") OT::LinearProfile
OT_LinearProfile_doc
// ---------------------------------------------------------------------
%define OT_LinearProfile_call_doc
"Compute the temperature T(i).

Parameters
----------
i : int
    The index for whome we seek temperature

Returns
-------
temperature:  float
    The temperature

Examples
--------
>>> import openturns as ot
>>> # Define a profile
>>> T0 = 10.0
>>> iMax = 100
>>> linearProfile = ot.LinearProfile(T0, iMax)
>>> temperature = linearProfile(10)
>>> print(temperature)
9.0"
%enddef
%feature("docstring") OT::LinearProfile::operator()
OT_LinearProfile_call_doc
// ---------------------------------------------------------------------
