
"""
This script is meant to be sourced inside GDB when debugging a program that
uses liblktlang. It installs Langkit's "GDB helpers": pretty-printers and
custom commands that are convenient when debugging liblktlang. Note that GDB
helpers require the Langkit Python library.
"""

import sys


sys.path.append('D:/a/msys64/mingw64/lib/python3.12/site-packages')


try:
    import langkit.gdb
except ImportError as exc:
    print(
        f"{__file__}: Cannot import the 'langkit.gdb' Python package: langkit"
        " GDB helpers require it",
        file=sys.stderr,
    )
else:
    
    langkit.gdb.setup(
        lib_name='liblktlang',
        astnode_names=['Lkt_Node', 'Base_Lexer_Case_Rule_Alt', 'Lexer_Case_Rule_Cond_Alt', 'Lexer_Case_Rule_Default_Alt', 'Block_String_Line', 'Class_Qualifier', 'Class_Qualifier_Absent', 'Class_Qualifier_Present', 'Decl', 'Base_Grammar_Rule_Decl', 'Grammar_Rule_Decl', 'Synthetic_Lexer_Decl', 'Base_Val_Decl', 'Node_Decl', 'Self_Decl', 'User_Val_Decl', 'Enum_Lit_Decl', 'Explicitly_Typed_Decl', 'Component_Decl', 'Field_Decl', 'Fun_Arg_Decl', 'Lambda_Arg_Decl', 'Dyn_Var_Decl', 'Match_Val_Decl', 'Val_Decl', 'Fun_Decl', 'Env_Spec_Decl', 'Generic_Decl', 'Grammar_Decl', 'Lexer_Decl', 'Lexer_Family_Decl', 'Type_Decl', 'Enum_Class_Alt_Decl', 'Function_Type', 'Generic_Formal_Type_Decl', 'Instantiated_Generic_Type', 'Named_Type_Decl', 'Basic_Class_Decl', 'Class_Decl', 'Enum_Class_Decl', 'Enum_Type_Decl', 'Struct_Decl', 'Trait_Decl', 'Decl_Annotation', 'Decl_Annotation_Params', 'Elsif_Branch', 'Enum_Class_Case', 'Excludes_Null', 'Excludes_Null_Absent', 'Excludes_Null_Present', 'Expr', 'Any_Of', 'Array_Literal', 'Base_Dot_Expr', 'Dot_Expr', 'Null_Cond_Dotted_Name', 'Bin_Op', 'Block_Expr', 'Call_Expr', 'Cast_Expr', 'Error_On_Null', 'Generic_Instantiation', 'Grammar_Expr', 'Grammar_Cut', 'Grammar_Discard', 'Grammar_Dont_Skip', 'Grammar_List', 'Grammar_Null', 'Grammar_Opt', 'Grammar_Opt_Error', 'Grammar_Opt_Error_Group', 'Grammar_Opt_Group', 'Grammar_Or_Expr', 'Grammar_Pick', 'Grammar_Implicit_Pick', 'Grammar_Predicate', 'Grammar_Rule_Ref', 'Grammar_Skip', 'Grammar_Stop_Cut', 'Parse_Node_Expr', 'Token_Lit', 'Token_No_Case_Lit', 'Token_Pattern_Lit', 'Token_Ref', 'Id', 'Def_Id', 'Module_Ref_Id', 'Ref_Id', 'If_Expr', 'Isa', 'Keep_Expr', 'Lambda_Expr', 'Lit', 'Big_Num_Lit', 'Char_Lit', 'Null_Lit', 'Num_Lit', 'String_Lit', 'Block_String_Lit', 'Single_Line_String_Lit', 'Pattern_Single_Line_String_Lit', 'Logic_Expr', 'Match_Expr', 'Not_Expr', 'Paren_Expr', 'Raise_Expr', 'Subscript_Expr', 'Null_Cond_Subscript_Expr', 'Try_Expr', 'Un_Op', 'Full_Decl', 'Grammar_List_Sep', 'Import', 'Langkit_Root', 'Lexer_Case_Rule', 'Lexer_Case_Rule_Send', 'List_Kind', 'List_Kind_One', 'List_Kind_Zero', 'Lkt_Node_Base_List', 'Base_Lexer_Case_Rule_Alt_List', 'Block_String_Line_List', 'Call_Expr_List', 'Decl_Annotation_List', 'Elsif_Branch_List', 'Enum_Class_Alt_Decl_List', 'Enum_Class_Case_List', 'Enum_Lit_Decl_List', 'Expr_List', 'Any_Of_List', 'Full_Decl_List', 'Decl_Block', 'Generic_Formal_Decl_List', 'Fun_Arg_Decl_List', 'Grammar_Expr_List', 'Grammar_Expr_List_List', 'Import_List', 'Lambda_Arg_Decl_List', 'Lkt_Node_List', 'Block_Decl_List', 'Match_Branch_List', 'Param_List', 'Ref_Id_List', 'Type_Ref_List', 'Isa_List', 'Match_Branch', 'Op', 'Op_Amp', 'Op_And', 'Op_Div', 'Op_Eq', 'Op_Gt', 'Op_Gte', 'Op_Lt', 'Op_Lte', 'Op_Minus', 'Op_Mult', 'Op_Ne', 'Op_Or', 'Op_Or_Int', 'Op_Plus', 'Param', 'Type_Ref', 'Default_List_Type_Ref', 'Function_Type_Ref', 'Generic_Type_Ref', 'Simple_Type_Ref', 'Var_Bind'],
        astnode_kinds={1: 'Lexer_Case_Rule_Cond_Alt', 2: 'Lexer_Case_Rule_Default_Alt', 3: 'Block_String_Line', 4: 'Class_Qualifier_Absent', 5: 'Class_Qualifier_Present', 6: 'Grammar_Rule_Decl', 7: 'Synthetic_Lexer_Decl', 8: 'Node_Decl', 9: 'Self_Decl', 10: 'Enum_Lit_Decl', 11: 'Field_Decl', 12: 'Fun_Arg_Decl', 13: 'Lambda_Arg_Decl', 14: 'Dyn_Var_Decl', 15: 'Match_Val_Decl', 16: 'Val_Decl', 17: 'Fun_Decl', 18: 'Env_Spec_Decl', 19: 'Generic_Decl', 20: 'Grammar_Decl', 21: 'Lexer_Decl', 22: 'Lexer_Family_Decl', 23: 'Enum_Class_Alt_Decl', 24: 'Function_Type', 25: 'Generic_Formal_Type_Decl', 26: 'Instantiated_Generic_Type', 27: 'Class_Decl', 28: 'Enum_Class_Decl', 29: 'Enum_Type_Decl', 30: 'Struct_Decl', 31: 'Trait_Decl', 32: 'Decl_Annotation', 33: 'Decl_Annotation_Params', 34: 'Elsif_Branch', 35: 'Enum_Class_Case', 36: 'Excludes_Null_Absent', 37: 'Excludes_Null_Present', 38: 'Any_Of', 39: 'Array_Literal', 40: 'Dot_Expr', 41: 'Null_Cond_Dotted_Name', 42: 'Bin_Op', 43: 'Block_Expr', 44: 'Call_Expr', 45: 'Cast_Expr', 46: 'Error_On_Null', 47: 'Generic_Instantiation', 48: 'Grammar_Cut', 49: 'Grammar_Discard', 50: 'Grammar_Dont_Skip', 51: 'Grammar_List', 52: 'Grammar_Null', 53: 'Grammar_Opt', 54: 'Grammar_Opt_Error', 55: 'Grammar_Opt_Error_Group', 56: 'Grammar_Opt_Group', 57: 'Grammar_Or_Expr', 58: 'Grammar_Pick', 59: 'Grammar_Implicit_Pick', 60: 'Grammar_Predicate', 61: 'Grammar_Rule_Ref', 62: 'Grammar_Skip', 63: 'Grammar_Stop_Cut', 64: 'Parse_Node_Expr', 65: 'Token_Lit', 66: 'Token_No_Case_Lit', 67: 'Token_Pattern_Lit', 68: 'Token_Ref', 69: 'Id', 70: 'Def_Id', 71: 'Module_Ref_Id', 72: 'Ref_Id', 73: 'If_Expr', 74: 'Isa', 75: 'Keep_Expr', 76: 'Lambda_Expr', 77: 'Big_Num_Lit', 78: 'Char_Lit', 79: 'Null_Lit', 80: 'Num_Lit', 81: 'Block_String_Lit', 82: 'Single_Line_String_Lit', 83: 'Pattern_Single_Line_String_Lit', 84: 'Logic_Expr', 85: 'Match_Expr', 86: 'Not_Expr', 87: 'Paren_Expr', 88: 'Raise_Expr', 89: 'Subscript_Expr', 90: 'Null_Cond_Subscript_Expr', 91: 'Try_Expr', 92: 'Un_Op', 93: 'Full_Decl', 94: 'Grammar_List_Sep', 95: 'Import', 96: 'Langkit_Root', 97: 'Lexer_Case_Rule', 98: 'Lexer_Case_Rule_Send', 99: 'List_Kind_One', 100: 'List_Kind_Zero', 101: 'Base_Lexer_Case_Rule_Alt_List', 102: 'Block_String_Line_List', 103: 'Call_Expr_List', 104: 'Decl_Annotation_List', 105: 'Elsif_Branch_List', 106: 'Enum_Class_Alt_Decl_List', 107: 'Enum_Class_Case_List', 108: 'Enum_Lit_Decl_List', 109: 'Expr_List', 110: 'Any_Of_List', 111: 'Full_Decl_List', 112: 'Decl_Block', 113: 'Generic_Formal_Decl_List', 114: 'Fun_Arg_Decl_List', 115: 'Grammar_Expr_List', 116: 'Grammar_Expr_List_List', 117: 'Import_List', 118: 'Lambda_Arg_Decl_List', 119: 'Lkt_Node_List', 120: 'Block_Decl_List', 121: 'Match_Branch_List', 122: 'Param_List', 123: 'Ref_Id_List', 124: 'Type_Ref_List', 125: 'Isa_List', 126: 'Match_Branch', 127: 'Op_Amp', 128: 'Op_And', 129: 'Op_Div', 130: 'Op_Eq', 131: 'Op_Gt', 132: 'Op_Gte', 133: 'Op_Lt', 134: 'Op_Lte', 135: 'Op_Minus', 136: 'Op_Mult', 137: 'Op_Ne', 138: 'Op_Or', 139: 'Op_Or_Int', 140: 'Op_Plus', 141: 'Param', 142: 'Default_List_Type_Ref', 143: 'Function_Type_Ref', 144: 'Generic_Type_Ref', 145: 'Simple_Type_Ref', 146: 'Var_Bind'},
        prefix='lkt'
    )
