package body GPR2.KB.Embedded is
begin

   Knowledge_Base.Include
     ("gprconfig.xsd",
      "<?xml version=""1.0""?>" & ASCII.LF &
      "<!--" & ASCII.LF &
      "  This file contains the XML Schema for the knowledge base of gprconfig." & ASCII.LF &
      "-->" & ASCII.LF &
      "" & ASCII.LF &
      "<xsd:schema xmlns:xsd=""http://www.w3.org/2001/XMLSchema""" & ASCII.LF &
      "   xmlns:xsi=""http://www.w3.org/2001/XMLSchema-instance"">" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:element name=""gprconfig"">" & ASCII.LF &
      "      <xsd:complexType>" & ASCII.LF &
      "         <xsd:choice>" & ASCII.LF &
      "            <xsd:element ref=""compiler_description"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "            <xsd:element ref=""configuration"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "            <xsd:element ref=""targetset"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "            <xsd:element ref=""fallback_targets"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "         </xsd:choice>" & ASCII.LF &
      "      </xsd:complexType>" & ASCII.LF &
      "   </xsd:element>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:element name=""compiler_description"">" & ASCII.LF &
      "      <xsd:complexType>" & ASCII.LF &
      "         <xsd:sequence>" & ASCII.LF &
      "            <xsd:element name=""name""       type=""xsd:string"" />" & ASCII.LF &
      "            <xsd:element name=""executable"" type=""Texecutable"" minOccurs=""0"" />" & ASCII.LF &
      "            <xsd:element name=""version""    type=""Texternal""   minOccurs=""0"" />" & ASCII.LF &
      "            <xsd:element name=""languages""  type=""Texternal""   minOccurs=""0"" />" & ASCII.LF &
      "            <xsd:element name=""variable""   type=""Texternal_with_name""" & ASCII.LF &
      "                         minOccurs=""0"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "            <xsd:element name=""runtimes""   type=""Texternal_with_default""" & ASCII.LF &
      "                         minOccurs=""0"" />" & ASCII.LF &
      "            <xsd:element name=""target""     type=""Texternal""   minOccurs=""0"" />" & ASCII.LF &
      "         </xsd:sequence>" & ASCII.LF &
      "      </xsd:complexType>" & ASCII.LF &
      "   </xsd:element>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:element name=""configuration"">" & ASCII.LF &
      "      <xsd:complexType>" & ASCII.LF &
      "         <xsd:sequence>" & ASCII.LF &
      "            <xsd:element name=""compilers"" type=""Tcompilers""" & ASCII.LF &
      "                         minOccurs=""0"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "            <xsd:element name=""targets"" type=""Ttargets""" & ASCII.LF &
      "                         minOccurs=""0"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "            <xsd:element name=""hosts"" type=""Thosts""" & ASCII.LF &
      "                         minOccurs=""0"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "            <xsd:element name=""config"" type=""xsd:string"" minOccurs=""1""/>" & ASCII.LF &
      "         </xsd:sequence>" & ASCII.LF &
      "      </xsd:complexType>" & ASCII.LF &
      "   </xsd:element>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:element name=""targetset"">" & ASCII.LF &
      "      <xsd:complexType>" & ASCII.LF &
      "         <xsd:sequence>" & ASCII.LF &
      "            <xsd:element name=""target"" type=""xsd:string""" & ASCII.LF &
      "               maxOccurs=""unbounded"" minOccurs=""1""/>" & ASCII.LF &
      "         </xsd:sequence>" & ASCII.LF &
      "         <xsd:attribute name=""canonical"" type=""xsd:string"" />" & ASCII.LF &
      "      </xsd:complexType>" & ASCII.LF &
      "   </xsd:element>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:element name=""fallback_targets"">" & ASCII.LF &
      "      <xsd:complexType>" & ASCII.LF &
      "         <xsd:sequence>" & ASCII.LF &
      "            <xsd:element name=""target"" type=""xsd:string""" & ASCII.LF &
      "               maxOccurs=""unbounded"" minOccurs=""1""/>" & ASCII.LF &
      "         </xsd:sequence>" & ASCII.LF &
      "      </xsd:complexType>" & ASCII.LF &
      "   </xsd:element>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!--  The ""executable"" node in a ""compiler_description"" -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Texecutable"">" & ASCII.LF &
      "      <xsd:simpleContent>" & ASCII.LF &
      "         <xsd:extension base=""xsd:string"">" & ASCII.LF &
      "            <xsd:attribute name=""prefix"" type=""xsd:string"" />" & ASCII.LF &
      "         </xsd:extension>" & ASCII.LF &
      "      </xsd:simpleContent>" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- All nodes in a ""compiler_description"" that get their value from" & ASCII.LF &
      "        the environment (a process, environment variable,...)" & ASCII.LF &
      "" & ASCII.LF &
      "        ??? How do we show in the schema that if a simple content is used" & ASCII.LF &
      "        we cannot specify any child ?" & ASCII.LF &
      "    -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Texternal"" mixed=""true"">" & ASCII.LF &
      "      <xsd:sequence minOccurs=""0"" maxOccurs=""1"">" & ASCII.LF &
      "         <xsd:choice>" & ASCII.LF &
      "            <xsd:element name=""external"" type=""xsd:string"" />" & ASCII.LF &
      "            <xsd:element name=""getenv"" type=""Tgetenv"" />" & ASCII.LF &
      "            <xsd:element name=""directory"" type=""Tdirectory""" & ASCII.LF &
      "                         maxOccurs=""unbounded""/>" & ASCII.LF &
      "         </xsd:choice>" & ASCII.LF &
      "         <xsd:element name=""nogrep"" type=""Tgrep"" minOccurs=""0"" />" & ASCII.LF &
      "         <xsd:element name=""grep"" type=""Tgrep"" minOccurs=""0"" />" & ASCII.LF &
      "         <xsd:element name=""must_match"" type=""xsd:string"" minOccurs=""0"" />" & ASCII.LF &
      "      </xsd:sequence>" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Texternal_with_name"" mixed=""true"">" & ASCII.LF &
      "      <xsd:complexContent>" & ASCII.LF &
      "         <xsd:extension base=""Texternal"">" & ASCII.LF &
      "            <xsd:attribute name=""name"" type=""xsd:string"" />" & ASCII.LF &
      "         </xsd:extension>" & ASCII.LF &
      "      </xsd:complexContent>" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Texternal_with_default"" mixed=""true"">" & ASCII.LF &
      "      <xsd:complexContent>" & ASCII.LF &
      "         <xsd:extension base=""Texternal"">" & ASCII.LF &
      "            <xsd:attribute name=""default"" type=""xsd:string"" />" & ASCII.LF &
      "         </xsd:extension>" & ASCII.LF &
      "      </xsd:complexContent>" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!--  ??? Could check that ""group"" is a valid parenthesis count for the" & ASCII.LF &
      "         regexp." & ASCII.LF &
      "   -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Tgrep"">  <!--  No text allowed, no children -->" & ASCII.LF &
      "      <xsd:attribute name=""regexp"" type=""xsd:string"" />" & ASCII.LF &
      "      <xsd:attribute name=""group"" type=""xsd:nonNegativeInteger"" />" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Tgetenv""> <!-- No text allowed, no children -->" & ASCII.LF &
      "      <xsd:attribute name=""name"" type=""xsd:string"" />" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:simpleType name=""TpositiveOrDefault"">" & ASCII.LF &
      "      <xsd:union>" & ASCII.LF &
      "        <xsd:simpleType>" & ASCII.LF &
      "          <xsd:restriction base=""xsd:nonNegativeInteger""/>" & ASCII.LF &
      "        </xsd:simpleType>" & ASCII.LF &
      "        <xsd:simpleType>" & ASCII.LF &
      "          <xsd:restriction base=""xsd:string"">" & ASCII.LF &
      "            <xsd:enumeration value=""default""/>" & ASCII.LF &
      "          </xsd:restriction>" & ASCII.LF &
      "        </xsd:simpleType>" & ASCII.LF &
      "      </xsd:union> " & ASCII.LF &
      "   </xsd:simpleType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Tdirectory"">" & ASCII.LF &
      "      <xsd:simpleContent>" & ASCII.LF &
      "         <xsd:extension base=""xsd:string"">" & ASCII.LF &
      "            <xsd:attribute name=""group"" type=""xsd:string"" />" & ASCII.LF &
      "            <xsd:attribute name=""contents"" type=""xsd:string"" />" & ASCII.LF &
      "         </xsd:extension>" & ASCII.LF &
      "      </xsd:simpleContent>" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Tcompilers"">" & ASCII.LF &
      "      <xsd:sequence>" & ASCII.LF &
      "         <xsd:element name=""compiler"" type=""Tcompiler"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "      </xsd:sequence>" & ASCII.LF &
      "      <xsd:attribute name=""negate"" type=""xsd:boolean"" />" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Tcompiler""> <!-- No text allowed, no children -->" & ASCII.LF &
      "      <xsd:attribute name=""name"" type=""xsd:string""/>" & ASCII.LF &
      "      <xsd:attribute name=""version"" type=""xsd:string""/>" & ASCII.LF &
      "      <xsd:attribute name=""runtime"" type=""xsd:string""/>" & ASCII.LF &
      "      <xsd:attribute name=""language"" type=""xsd:string""/>" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Ttargets"">" & ASCII.LF &
      "      <xsd:sequence>" & ASCII.LF &
      "         <xsd:element name=""target"" type=""Ttarget"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "      </xsd:sequence>" & ASCII.LF &
      "      <xsd:attribute name=""negate"" type=""xsd:boolean"" />" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Ttarget""> <!-- No text allowed, no children -->" & ASCII.LF &
      "      <xsd:attribute name=""name"" type=""xsd:string""/>" & ASCII.LF &
      "      <xsd:attribute name=""except"" type=""xsd:string""/>" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Thosts"">" & ASCII.LF &
      "      <xsd:sequence>" & ASCII.LF &
      "         <xsd:element name=""host"" type=""Thost"" maxOccurs=""unbounded""/>" & ASCII.LF &
      "      </xsd:sequence>" & ASCII.LF &
      "      <xsd:attribute name=""negate"" type=""xsd:boolean"" />" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "   <xsd:complexType name=""Thost""> <!-- No text allowed, no children -->" & ASCII.LF &
      "      <xsd:attribute name=""name"" type=""xsd:string""/>" & ASCII.LF &
      "      <xsd:attribute name=""except"" type=""xsd:string""/>" & ASCII.LF &
      "   </xsd:complexType>" & ASCII.LF &
      "" & ASCII.LF &
      "" & ASCII.LF &
      "</xsd:schema>");

   Knowledge_Base.Include
     ("env.ent",
      "   <!ENTITY environment" & ASCII.LF &
      "    '" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "" & ASCII.LF &
      "   EXEC_ADA := ""${EXEC(Ada)}"";" & ASCII.LF &
      "   EXEC_C   := ""${EXEC(C)}"";" & ASCII.LF &
      "   EXEC_CPP := ""${EXEC(C++)}"";" & ASCII.LF &
      "" & ASCII.LF &
      "   HOST_ADA := ""${HOST(Ada)}"";" & ASCII.LF &
      "   HOST_C   := ""${HOST(C)}"";" & ASCII.LF &
      "   HOST_CPP := ""${HOST(C++)}"";" & ASCII.LF &
      "" & ASCII.LF &
      "   TARGET_ADA := ""${TARGET(Ada)}"";" & ASCII.LF &
      "   TARGET_C   := ""${TARGET(C)}"";" & ASCII.LF &
      "   TARGET_CPP := ""${TARGET(C++)}"";" & ASCII.LF &
      "" & ASCII.LF &
      "   VERSION_ADA := ""${VERSION(Ada)}"";" & ASCII.LF &
      "   VERSION_C   := ""${VERSION(C)}"";" & ASCII.LF &
      "   VERSION_CPP := ""${VERSION(C++)}"";" & ASCII.LF &
      "" & ASCII.LF &
      "   PREFIX_ADA := ""${PREFIX(Ada)}"";" & ASCII.LF &
      "   PREFIX_C   := ""${PREFIX(C)}"";" & ASCII.LF &
      "   PREFIX_CPP := ""${PREFIX(C++)}"";" & ASCII.LF &
      "" & ASCII.LF &
      "   PATH_ADA := ""${PATH(Ada)}"";" & ASCII.LF &
      "   PATH_C   := ""${PATH(C)}"";" & ASCII.LF &
      "   PATH_CPP := ""${PATH(C++)}"";" & ASCII.LF &
      "" & ASCII.LF &
      "   RUNTIME_ADA := ""${RUNTIME(Ada)}"";" & ASCII.LF &
      "   RUNTIME_C   := ""${RUNTIME(C)}"";" & ASCII.LF &
      "   RUNTIME_CPP := ""${RUNTIME(C++)}"";" & ASCII.LF &
      "" & ASCII.LF &
      "   GPRCONFIG_PREFIX := ""${GPRCONFIG_PREFIX}"";" & ASCII.LF &
      "" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "    '" & ASCII.LF &
      "   >");

   Knowledge_Base.Include
     ("shortcuts.ent",
      "   <!ENTITY languages_c" & ASCII.LF &
      "    '<languages>C</languages>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "   <!ENTITY languages_cpp" & ASCII.LF &
      "    '<languages>C++</languages>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY if_no_ada" & ASCII.LF &
      "   '<compilers negate=""true"" >" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY if_ada" & ASCII.LF &
      "   '<compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY if_adacore_c" & ASCII.LF &
      "   '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY if_cpp" & ASCII.LF &
      "   '<compilers>" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY if_no_cpp" & ASCII.LF &
      "   '<compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY if_adacore_cpp" & ASCII.LF &
      "   '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY if_c_only" & ASCII.LF &
      "   '<compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "       <compiler language=""Fortran"" />" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""C"" />" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY if_this_target" & ASCII.LF &
      "    '<targets>" & ASCII.LF &
      "       <target name=""^&this_target;$"" />" & ASCII.LF &
      "     </targets>'>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY config_gnat_ar" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   for Archive_Builder  use (""&this_target;-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""&this_target;-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY configurations_gnat_ar" & ASCII.LF &
      "    '<configuration>" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_gnat_ar;" & ASCII.LF &
      "     </configuration>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY config_ada_partial_link" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   for Library_Partial_Linker use" & ASCII.LF &
      "         (PATH_ADA &amp; PREFIX_ADA &amp; ""gcc"", ""-nostdlib"", ""-Wl,-r"", ""-o"");" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY config_cpp_partial_link" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   for Library_Partial_Linker use" & ASCII.LF &
      "         (PATH_CPP &amp; EXEC_CPP, ""-nostdlib"", ""-Wl,-r"", ""-o"");" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY config_c_partial_link" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   for Library_Partial_Linker use" & ASCII.LF &
      "         (PATH_C &amp; EXEC_C, ""-nostdlib"", ""-Wl,-r"", ""-o"");" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY gnat_post_20" & ASCII.LF &
      "     '<compiler language=""Ada"" version=""[2-3][0-9]"" />" & ASCII.LF &
      "      <compiler name=""^GCC_Pro$"" language=""C"" version=""([8-9]|1[0-9]).*"" />" & ASCII.LF &
      "      <compiler name=""^G\+\+_Pro$"" language=""C++"" version=""([8-9]|1[0-9]).*"" />'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_gnat_20_pre" & ASCII.LF &
      "   '<compilers negate=""true"" >" & ASCII.LF &
      "      &gnat_post_20;" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_gnat_20_and_later" & ASCII.LF &
      "   '<compilers>" & ASCII.LF &
      "      &gnat_post_20;" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "  >");

   Knowledge_Base.Include
     ("vx6.ent",
      "   <!ENTITY version_from_wind_base" & ASCII.LF &
      "    '<version>" & ASCII.LF &
      "      <getenv name=""WIND_BASE""></getenv>" & ASCII.LF &
      "      <grep regexp="".*[/\\](vxworks-6[0-9.]*).*"" group=""1""></grep>" & ASCII.LF &
      "      <must_match>vxworks-6.*</must_match>" & ASCII.LF &
      "     </version>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY version_from_wind_base_cert" & ASCII.LF &
      "    '<version>" & ASCII.LF &
      "      <getenv name=""WIND_BASE""></getenv>" & ASCII.LF &
      "      <grep regexp="".*[/\\](vxworks-cert-6[0-9.]*).*"" group=""1""></grep>" & ASCII.LF &
      "      <must_match>vxworks-cert-6.*</must_match>" & ASCII.LF &
      "     </version>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY runtimes_vx6" & ASCII.LF &
      "    '<runtimes>kernel,kernel-smp,kernel-sjlj,rtp,rtp-smp</runtimes>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY runtimes_vx6cert" & ASCII.LF &
      "    '<runtimes>" & ASCII.LF &
      "      kernel,cert,ravenscar-cert,zfp,rtp,ravenscar-cert-rtp" & ASCII.LF &
      "     </runtimes>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY gnat_pre_6.4" & ASCII.LF &
      "     '<compiler language=""Ada"" version=""3.16"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""5.00"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""5.01"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""5.02"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""5.03"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""5.04"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""6.0"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""6.1"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""6.2"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""6.3"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""6.4"" />'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_gnat_pre_6.4" & ASCII.LF &
      "   '<compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "      &gnat_pre_6.4;" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_gnat_post_6.4" & ASCII.LF &
      "   '<compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers negate=""true"" >" & ASCII.LF &
      "      &gnat_pre_6.4;" & ASCII.LF &
      "    </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_rtp_cflags" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C"") &amp; (""-mrtp"")" & ASCII.LF &
      "        &amp; (""-I"" &amp; Wind_Base &amp; ""/target/usr/h""," & ASCII.LF &
      "               ""-I"" &amp; Wind_Base &amp; ""/target/usr/h/wrn/coreip"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C++"") &amp; (""-mrtp"")" & ASCII.LF &
      "        &amp; (""-I"" &amp; Wind_Base &amp; ""/target/usr/h""," & ASCII.LF &
      "               ""-I"" &amp; Wind_Base &amp; ""/target/usr/h/wrn/coreip"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_rtp_lib" & ASCII.LF &
      "    '" & ASCII.LF &
      "     <!-- As a special exception, on arm-vx6, rts-rtp is smp-based. -->" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "     rtp_smp_suffix := """";" & ASCII.LF &
      "     case TARGET_ADA is" & ASCII.LF &
      "       when ""arm-wrs-vxworks"" =>" & ASCII.LF &
      "         rtp_smp_suffix := ""_smp"";" & ASCII.LF &
      "       when others =>" & ASCII.LF &
      "         rtp_smp_suffix := """";" & ASCII.LF &
      "     end case;" & ASCII.LF &
      "" & ASCII.LF &
      "     package Linker is" & ASCII.LF &
      "        for Required_Switches use" & ASCII.LF &
      "          Linker &apos; Required_Switches" & ASCII.LF &
      "          &amp; (""-L"" &amp; Wind_Base" & ASCII.LF &
      "                 &amp; ""/target/lib"" &amp; rtp_smp_suffix &amp; ""/usr/lib/""" & ASCII.LF &
      "                 &amp; ""&this_cpu_subdir;""," & ASCII.LF &
      "                 ""-L"" &amp; Wind_Base" & ASCII.LF &
      "                 &amp; ""/target/usr/lib"" &amp; rtp_smp_suffix &amp; ""/""" & ASCII.LF &
      "                 &amp; ""&this_cpu_subdir;"");" & ASCII.LF &
      "     end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_rtp_smp_lib" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "     package Linker is" & ASCII.LF &
      "        for Required_Switches use" & ASCII.LF &
      "          Linker &apos; Required_Switches" & ASCII.LF &
      "          &amp; (""-L"" &amp; Wind_Base" & ASCII.LF &
      "                 &amp; ""/target/lib_smp/usr/lib/""" & ASCII.LF &
      "                 &amp; ""&this_cpu_subdir;"");" & ASCII.LF &
      "     end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_rtp_cert_lib" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "     package Linker is" & ASCII.LF &
      "        for Required_Switches use" & ASCII.LF &
      "          Linker &apos; Required_Switches" & ASCII.LF &
      "          &amp; (""-L"" &amp; Wind_Base" & ASCII.LF &
      "                 &amp; ""/target/usr/lib_cert_rtp/""" & ASCII.LF &
      "                 &amp; ""&this_cpu_subdir;"");" & ASCII.LF &
      "     end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_no_startfiles_no_defaultlibs" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "     package Linker is" & ASCII.LF &
      "        for Required_Switches use" & ASCII.LF &
      "          Linker &apos; Required_Switches" & ASCII.LF &
      "          &amp; (""-nostartfiles"", ""-nodefaultlibs"");" & ASCII.LF &
      "     end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_kernel_cflags" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-I"" &amp; Wind_Base &amp; ""/target/h""," & ASCII.LF &
      "               ""-I"" &amp; Wind_Base &amp; ""/target/h/wrn/coreip"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-I"" &amp; Wind_Base &amp; ""/target/h""," & ASCII.LF &
      "               ""-I"" &amp; Wind_Base &amp; ""/target/h/wrn/coreip"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_wrs_ar" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   for Archive_Builder  use (""ar"" &amp; ""&this_gnu_wrs_suffix;"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""ranlib"" &amp; ""&this_gnu_wrs_suffix;"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY configurations_vx6" & ASCII.LF &
      "  '" & ASCII.LF &
      "  <!--  Note: vx6 and vx6cert share the same target name, so" & ASCII.LF &
      "        in configurations chunks are added into vx6-specific" & ASCII.LF &
      "        files if_this_target will match both vx6 and vx6cert." & ASCII.LF &
      "        A way to discriminate the two kind of platforms is to" & ASCII.LF &
      "        use runtime names and compiler names." & ASCII.LF &
      "" & ASCII.LF &
      "        For now, however, we still have one global target-independant" & ASCII.LF &
      "        compiler for GNAT. So most of the following chuncks apply on" & ASCII.LF &
      "        both vx6 and vx6cert. In order to ease the maintenance," & ASCII.LF &
      "        have a comment to make it explicit when they apply to both." & ASCII.LF &
      "   -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_wind_base;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    &if_gnat_pre_6.4;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "    <!-- vx6 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_wrs_ar;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    &if_gnat_post_6.4;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "    <!-- vx6 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_gnat_ar;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    &if_no_ada;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "    <!-- vx6 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_gnat_ar;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_rtp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_rtp_cflags;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    &if_ravenscar_cert_rtp;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "    <!-- vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_wrs_rtp_base;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_kernel_full;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_kernel_cflags;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_zfp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_kernel_cflags;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_ravenscar_cert;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_kernel_cflags;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- In Cert and 653 printf should not be considered as a builtin -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_zfp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_no_builtin;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_restricted_rts;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_no_builtin;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- -L options. Should only be needed for non-Ada projects." & ASCII.LF &
      "        They would be useless for programs that have Ada in them," & ASCII.LF &
      "        since these are passed by specs file passed to gcc" & ASCII.LF &
      "        by a pragma Linker_Options in system; and would be harmless" & ASCII.LF &
      "        if it were for x86-vx6: on this target," & ASCII.LF &
      "        to discriminate between vxsim and real target, we only" & ASCII.LF &
      "        have an option on command line, and gprconfig/gprbuild" & ASCII.LF &
      "        do not have a way to look for such an option on the command line." & ASCII.LF &
      "        All in all, we do not pass them if there is Ada in the project." & ASCII.LF &
      "    -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_no_ada;" & ASCII.LF &
      "     &if_rtp_strict;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_rtp_lib;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_no_ada;" & ASCII.LF &
      "     &if_rtp_smp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_rtp_smp_lib;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    &if_no_ada;" & ASCII.LF &
      "    &if_ravenscar_cert_rtp;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "    <!-- vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_rtp_cert_lib;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_restricted_rts;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "    <!-- vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_no_startfiles_no_defaultlibs;" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "  '" & ASCII.LF &
      "  >");

   Knowledge_Base.Include
     ("vx653.ent",
      "   <!ENTITY version_from_wind_base_vx653" & ASCII.LF &
      "    '<version>" & ASCII.LF &
      "      <getenv name=""WIND_BASE""></getenv>" & ASCII.LF &
      "      <grep regexp="".*[/\\](vxworks653-[0-9.]*).*"" group=""1""></grep>" & ASCII.LF &
      "      <must_match>vxworks653.*</must_match>" & ASCII.LF &
      "     </version>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY runtimes_vx653" & ASCII.LF &
      "    '<runtimes>full,cert,ravenscar-cert,zfp</runtimes>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_vx653_cflags" & ASCII.LF &
      "  '" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-DVTHREADS""," & ASCII.LF &
      "               ""-I"" &amp; Wind_Base &amp; ""/target/vThreads/h""," & ASCII.LF &
      "               ""-I"" &amp; Wind_Base &amp; ""/target/val/h"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-DVTHREADS""," & ASCII.LF &
      "               ""-I"" &amp; Wind_Base &amp; ""/target/vThreads/h""," & ASCII.LF &
      "               ""-I"" &amp; Wind_Base &amp; ""/target/val/h"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "  '" & ASCII.LF &
      "  >" & ASCII.LF &
      "  <!ENTITY configurations_vx653" & ASCII.LF &
      "  '" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_wind_base;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_out_suffix;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_vx653_cflags;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_zfp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_no_builtin;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_restricted_rts;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_no_builtin;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_gnat_ar;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- For VxWorks use Ada driver as default for linking, since cc*" & ASCII.LF &
      "       and c++* do not recognize the -crtbe switch needed for ZCX -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "     &if_ada;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_ada_linker;" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_no_ada;" & ASCII.LF &
      "     &if_cpp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_cpp_linker;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_no_ada;" & ASCII.LF &
      "     &if_no_cpp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_c_linker;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "  '" & ASCII.LF &
      "  >");

   Knowledge_Base.Include
     ("vx7.ent",
      "   <!ENTITY version_from_wrs7_gnu_cc" & ASCII.LF &
      "    '<version>" & ASCII.LF &
      "      <external>cc${PREFIX} --version</external>" & ASCII.LF &
      "      <grep regexp="".*\) ([0-9.]*)"" group=""1""></grep>" & ASCII.LF &
      "" & ASCII.LF &
      "      <!--  Two gcc versions provided on vx7r1 (SR05xx):" & ASCII.LF &
      "            * 4.3 for compat69;" & ASCII.LF &
      "            * 4.8.1 for regular vx7." & ASCII.LF &
      "            We do not support the former." & ASCII.LF &
      "        -->" & ASCII.LF &
      "      <must_match>4.8.1</must_match>" & ASCII.LF &
      "     </version>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY version_from_wrs7r2_gnu_cc" & ASCII.LF &
      "    '<version>" & ASCII.LF &
      "      <external>cc${PREFIX} --version</external>" & ASCII.LF &
      "      <grep regexp="".*\) ([0-9.]*)"" group=""1""></grep>" & ASCII.LF &
      "     </version>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY runtimes_vx7" & ASCII.LF &
      "    '<runtimes>kernel,rtp,kernel-large,rtp-large</runtimes>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_vsb_dir" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   VSB_Dir := external (""VSB_DIR"");" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_nostdlib" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "     package Linker is" & ASCII.LF &
      "        for Required_Switches use" & ASCII.LF &
      "          Linker &apos; Required_Switches" & ASCII.LF &
      "          &amp; (""-nostdlib"");" & ASCII.LF &
      "     end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY configurations_vx7" & ASCII.LF &
      "  '" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_vsb_dir;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_rtp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_wrs_rtp_base;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_restricted_rts;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx7r2cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_nostdlib;" & ASCII.LF &
      "  </configuration>'" & ASCII.LF &
      "  >");

   Knowledge_Base.Include
     ("vxworks.ent",
      "   <!ENTITY version_from_wrs_gnu_cc_vx5" & ASCII.LF &
      "    '<version>" & ASCII.LF &
      "      <external>cc${PREFIX} -v</external>" & ASCII.LF &
      "      <grep regexp="".*(tornado 2|VxWorks 5).*"" group=""1""></grep>" & ASCII.LF &
      "      <must_match>(tornado 2|VxWorks 5)</must_match>" & ASCII.LF &
      "     </version>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY version_from_wrs_gnu_cpp_vx5" & ASCII.LF &
      "    '<version>" & ASCII.LF &
      "      <external>c++${PREFIX} -v</external>" & ASCII.LF &
      "      <grep regexp="".*(tornado 2|VxWorks 5).*"" group=""1""></grep>" & ASCII.LF &
      "      <must_match>(tornado 2|VxWorks 5)</must_match>" & ASCII.LF &
      "     </version>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY target_from_wrs_gnu_cc" & ASCII.LF &
      "    '<target>" & ASCII.LF &
      "      <external>cc${PREFIX} -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "     </target>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY target_from_wrs_gnu_cpp" & ASCII.LF &
      "    '<target>" & ASCII.LF &
      "      <external>c++${PREFIX} -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY config_wind_base" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   Wind_Base := external (""WIND_BASE"");" & ASCII.LF &
      "   Wind_Usr := external (""WIND_USR"", Wind_Base &amp; ""/target/usr/"");" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY config_mrtp" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "  package Linker is" & ASCII.LF &
      "     for Required_Switches use" & ASCII.LF &
      "      Linker &apos; Required_Switches &amp; (""-mrtp"");" & ASCII.LF &
      "  end Linker;" & ASCII.LF &
      "    </config>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY config_mlongcall_c" & ASCII.LF &
      "     '<config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      case TARGET_C is" & ASCII.LF &
      "         when ""arm-wrs-vxworks"" =>" & ASCII.LF &
      "           for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "             Compiler &apos; Leading_Required_Switches (""C"")" & ASCII.LF &
      "             &amp; (""-mlong-calls"");" & ASCII.LF &
      "" & ASCII.LF &
      "         when ""powerpc-wrs-vxworks"" =>" & ASCII.LF &
      "           for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "             Compiler &apos; Leading_Required_Switches (""C"")" & ASCII.LF &
      "             &amp; (""-mlongcall"");" & ASCII.LF &
      "        when others =>" & ASCII.LF &
      "           null;" & ASCII.LF &
      "      end case;" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "   <!ENTITY config_mlongcall_cpp" & ASCII.LF &
      "     '<config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      case TARGET_CPP is" & ASCII.LF &
      "         when ""arm-wrs-vxworks"" =>" & ASCII.LF &
      "           for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "             Compiler &apos; Leading_Required_Switches (""C++"")" & ASCII.LF &
      "             &amp; (""-mlong-calls"");" & ASCII.LF &
      "" & ASCII.LF &
      "         when ""powerpc-wrs-vxworks"" | ""powerpc-wrs-vxworks7"" =>" & ASCII.LF &
      "           for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "             Compiler &apos; Leading_Required_Switches (""C++"")" & ASCII.LF &
      "             &amp; (""-mlongcall"");" & ASCII.LF &
      "" & ASCII.LF &
      "        when others =>" & ASCII.LF &
      "           null;" & ASCII.LF &
      "      end case;" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "   >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_wrs_rtp_base" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   WRS_RTP_Base := external (""WRS_RTP_BASE"", ""&this_wrs_rtp_base;"");" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Leading_Switches (""Ada"") use" & ASCII.LF &
      "        Linker &apos; Leading_Switches (""Ada"")" & ASCII.LF &
      "        &amp; (""-Wl,--defsym,__wrs_rtp_base="" &amp; WRS_RTP_Base);" & ASCII.LF &
      "      for Leading_Switches (""C"") use" & ASCII.LF &
      "        Linker &apos; Leading_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-Wl,--defsym,__wrs_rtp_base="" &amp; WRS_RTP_Base);" & ASCII.LF &
      "      for Leading_Switches (""C++"") use" & ASCII.LF &
      "        Linker &apos; Leading_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-Wl,--defsym,__wrs_rtp_base="" &amp; WRS_RTP_Base);" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_target_gpp" & ASCII.LF &
      "    '<targets>" & ASCII.LF &
      "       <target name=""^.*-wrs-vxworks$"" />" & ASCII.LF &
      "       <target name=""^.*-wrs-vxworks7$"" />" & ASCII.LF &
      "       <target name=""^.*-wrs-vxworks7r2$"" />" & ASCII.LF &
      "     </targets>'>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY rtp_runtimes" & ASCII.LF &
      "     '<compiler runtime=""^rtp$"" />" & ASCII.LF &
      "      <compiler runtime=""-rtp$"" />" & ASCII.LF &
      "      <compiler runtime=""^rtp-"" />" & ASCII.LF &
      "      <compiler runtime=""-rtp-"" />'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_rtp" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "      &rtp_runtimes;" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_not_rtp" & ASCII.LF &
      "    '<compilers negate=""true"">" & ASCII.LF &
      "      &rtp_runtimes;" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_ravenscar_cert_rtp" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler runtime=""^ravenscar-cert-rtp$"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_ravenscar_cert" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler runtime=""^ravenscar-cert$"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_restricted_rts" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler runtime=""cert"" />" & ASCII.LF &
      "       <compiler runtime=""light"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_zfp" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler runtime=""^zfp$"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Our naming scheme is such that the name of full rtp runtimes" & ASCII.LF &
      "       start with a ""rtp"" token -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_rtp_full" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler runtime=""^rtp$"" />" & ASCII.LF &
      "       <compiler runtime=""^rtp-"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_rtp_strict" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler runtime=""^rtp$"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_rtp_smp" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler runtime=""^rtp-smp$"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Our naming scheme is such that the name of full dkm runtimes" & ASCII.LF &
      "       start with a ""kernel"" token -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_kernel_full" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler runtime=""^kernel$"" />" & ASCII.LF &
      "       <compiler runtime=""^kernel-"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_not_kernel_full" & ASCII.LF &
      "    '<compilers negate=""true"">" & ASCII.LF &
      "       <compiler runtime=""^kernel$"" />" & ASCII.LF &
      "       <compiler runtime=""^kernel-"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_ada_rtp" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "      <compiler name=""^GNAT$"" runtime=""^rtp$"" />" & ASCII.LF &
      "      <compiler name=""^GNAT$"" runtime=""-rtp$"" />" & ASCII.LF &
      "      <compiler name=""^GNAT$"" runtime=""^rtp-"" />" & ASCII.LF &
      "      <compiler name=""^GNAT$"" runtime=""-rtp-"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_ada_rtp" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""Ada"") &amp; (""-mrtp"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY if_large_rts" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "      <compiler runtime=""-large$"" />" & ASCII.LF &
      "     </compilers>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_no_builtin" & ASCII.LF &
      "  '" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-fno-builtin"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-fno-builtin"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "  '" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_e500v2_cflags" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-te500v2"", ""-fno-implicit-fp"");" & ASCII.LF &
      "" & ASCII.LF &
      "      for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-te500v2"", ""-fno-implicit-fp"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_x86_64_cmodel_large_flags" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""Ada"")" & ASCII.LF &
      "        &amp; (""-mcmodel=large"");" & ASCII.LF &
      "" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-mcmodel=large"");" & ASCII.LF &
      "" & ASCII.LF &
      "      for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "        Compiler &apos; Leading_Required_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-mcmodel=large"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Leading_Switches (""Ada"") use" & ASCII.LF &
      "        Linker &apos; Leading_Switches (""Ada"")" & ASCII.LF &
      "        &amp; (""-mcmodel=large"");" & ASCII.LF &
      "      for Leading_Switches (""C"") use" & ASCII.LF &
      "        Linker &apos; Leading_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-mcmodel=large"");" & ASCII.LF &
      "      for Leading_Switches (""C++"") use" & ASCII.LF &
      "        Linker &apos; Leading_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-mcmodel=large"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_out_suffix" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Builder is" & ASCII.LF &
      "      for Executable_Suffix use "".out"";" & ASCII.LF &
      "   end Builder;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_vxe_suffix" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Builder is" & ASCII.LF &
      "      for Executable_Suffix use "".vxe"";" & ASCII.LF &
      "   end Builder;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_ada_linker" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use Compiler &apos; Driver (""Ada"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_c_linker" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use Compiler &apos; Driver (""C"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_cpp_linker" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use Compiler &apos; Driver (""C++"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY config_dkm_linker" & ASCII.LF &
      "    '<config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use ""&this_target;-vxlink"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "     </config>'" & ASCII.LF &
      "  >" & ASCII.LF &
      "" & ASCII.LF &
      "  <!ENTITY configurations_vxworks_gpp" & ASCII.LF &
      "  '" & ASCII.LF &
      "  <!--  Note: vx6 and vx6cert share the same target name, so" & ASCII.LF &
      "       in configurations chunks are added into vx6-specific" & ASCII.LF &
      "        files if_this_target will match both vx6 and vx6cert." & ASCII.LF &
      "        A way to discriminate the two kind of platforms is to" & ASCII.LF &
      "    use runtime names and compiler names." & ASCII.LF &
      "" & ASCII.LF &
      "        For now, however, we still have one global target-independant" & ASCII.LF &
      "        compiler for GNAT. So most of the following chuncks apply on" & ASCII.LF &
      "        both vx6 and vx6cert. In order to ease the maintenance," & ASCII.LF &
      "        have a comment to make it explicit when they apply to both." & ASCII.LF &
      "   -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    &if_rtp;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "    <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_vxe_suffix;" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    &if_not_rtp;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "    <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_out_suffix;" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    &if_ada_rtp;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "    <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_ada_rtp;" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    &if_rtp;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "    <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "    &config_mrtp;" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- mlongcall is passed by default in the case of GNAT." & ASCII.LF &
      "        Do the same thing for WRS compilers for consistency.  -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_these_gnu_wrs_compilers;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6 and vx7 -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_mlongcall_c;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_these_cpp_compilers;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6 and vx7 -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_mlongcall_cpp;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- For VxWorks kernel modules, use vxlink for linking: this tool takes" & ASCII.LF &
      "        care of generating the proper _ctors and _dtors symbols used to" & ASCII.LF &
      "        elaborate DKMs. -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_not_rtp;" & ASCII.LF &
      "     &if_gnat_20_and_later;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_dkm_linker;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- For older versions of GNAT Pro, use Ada driver as default for" & ASCII.LF &
      "        linking, since cc* and c++* do not recognize the -crtbe swtich needed" & ASCII.LF &
      "        for ZCX." & ASCII.LF &
      "        If no Ada is used in the project, default to the natural linker for" & ASCII.LF &
      "        the language. -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_ada;" & ASCII.LF &
      "     &if_not_rtp;" & ASCII.LF &
      "     &if_gnat_20_pre;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_ada_linker;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_no_ada;" & ASCII.LF &
      "     &if_not_rtp;" & ASCII.LF &
      "     &if_gnat_20_pre;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_cpp_linker;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_cpp;" & ASCII.LF &
      "     &if_rtp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_cpp_linker;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_ada;" & ASCII.LF &
      "     &if_no_cpp;" & ASCII.LF &
      "     &if_rtp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_ada_linker;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_c_only;" & ASCII.LF &
      "     &if_rtp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_c_linker;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- Partial link enabled when generating static libraries -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_ada;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_ada_partial_link;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_no_ada;" & ASCII.LF &
      "     &if_cpp;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_cpp_partial_link;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_c_only;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_c_partial_link;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     &if_large_rts;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6, vx7 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_x86_64_cmodel_large_flags;" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "  '>");

   Knowledge_Base.Include
     ("0_default.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "   <!--  This package provides default settings for GNAT toolchains -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Naming is" & ASCII.LF &
      "" & ASCII.LF &
      "      for Spec_Suffix (""Ada"") use "".ads"";" & ASCII.LF &
      "      for Body_Suffix (""Ada"") use "".adb"";" & ASCII.LF &
      "" & ASCII.LF &
      "      for Body_Suffix (""Asm"") use "".s"";" & ASCII.LF &
      "      for Body_Suffix (""Asm2"") use "".asm"";" & ASCII.LF &
      "      for Body_Suffix (""Asm_Cpp"") use "".S"";" & ASCII.LF &
      "" & ASCII.LF &
      "      for Body_Suffix (""C"") use "".c"";" & ASCII.LF &
      "      for Spec_Suffix (""C"") use "".h"";" & ASCII.LF &
      "" & ASCII.LF &
      "      for Spec_Suffix (""C++"") use "".hh"";" & ASCII.LF &
      "      for Body_Suffix (""C++"") use "".cpp"";" & ASCII.LF &
      "" & ASCII.LF &
      "      for Body_Suffix (""Fortran"") use "".f"";" & ASCII.LF &
      "" & ASCII.LF &
      "      for Body_Suffix (""Rust"") use "".rs"";" & ASCII.LF &
      "" & ASCII.LF &
      "      for Casing use ""lowercase"";" & ASCII.LF &
      "      for Dot_Replacement use ""-"";" & ASCII.LF &
      "" & ASCII.LF &
      "   end Naming;" & ASCII.LF &
      "" & ASCII.LF &
      "   for Inherit_Source_Path (""C++"") use (""C"");" & ASCII.LF &
      "   for Inherit_Source_Path (""Asm_Cpp"") use (""Asm"");" & ASCII.LF &
      "   for Default_Language use ""Ada"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Language_Kind (""ada"") use ""unit_based"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Clean is" & ASCII.LF &
      "      for Source_Artifact_Extensions (""Ada"") use ("".dg"", "".rep"");" & ASCII.LF &
      "      for Object_Artifact_Extensions (""Ada"") use ("".s"", "".ci"", "".gcno"", "".su"");" & ASCII.LF &
      "" & ASCII.LF &
      "      for Source_Artifact_Extensions (""C"")   use ("".gli"");" & ASCII.LF &
      "      for Object_Artifact_Extensions (""C"")   use ("".s"", ""ci"", "".gcno"", "".su"");" & ASCII.LF &
      "" & ASCII.LF &
      "      for Source_Artifact_Extensions (""C++"") use ("".gli"");" & ASCII.LF &
      "      for Object_Artifact_Extensions (""C++"") use ("".s"", ""ci"", "".gcno"", "".su"");" & ASCII.LF &
      "   end Clean;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Binder is" & ASCII.LF &
      "      for Bindfile_Option_Substitution (""-static"") use (""-static-libgcc"");" & ASCII.LF &
      "      for Bindfile_Option_Substitution (""-shared"") use (""-shared-libgcc"");" & ASCII.LF &
      "   end Binder;" & ASCII.LF &
      "" & ASCII.LF &
      "      </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("aamp.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  AAMP Platform -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""aamp"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Builder is" & ASCII.LF &
      "      for Executable_Suffix use "".axe"";" & ASCII.LF &
      "   end Builder;" & ASCII.LF &
      "" & ASCII.LF &
      "   for Library_Support use ""none"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use ""aa_link"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "      <compiler name=""GNAAMP"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Naming is" & ASCII.LF &
      "      for Spec_Suffix (""Ada"") use "".ads"";" & ASCII.LF &
      "      for Body_Suffix (""Ada"") use "".adb"";" & ASCII.LF &
      "      for Casing use ""lowercase"";" & ASCII.LF &
      "      for Dot_Replacement use ""-"";" & ASCII.LF &
      "   end Naming;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver                   (""Ada"") use ""gnaamp"";" & ASCII.LF &
      "      for Language_Kind            (""Ada"") use ""unit_based"";" & ASCII.LF &
      "      for Dependency_Kind          (""Ada"") use ""ALI_File"";" & ASCII.LF &
      "      for Required_Switches        (""Ada"") use" & ASCII.LF &
      "          Compiler'Required_Switches (""Ada"")" & ASCII.LF &
      "             &amp; (""-gnatA"");" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use" & ASCII.LF &
      "          Compiler'Leading_Required_Switches (""Ada"") &amp; (""-aamp_target=${RUNTIME(ada)}"");" & ASCII.LF &
      "      for Object_File_Suffix       (""Ada"") use "".obj"";" & ASCII.LF &
      "      for Mapping_File_Switches    (""Ada"") use (""-gnatem="");" & ASCII.LF &
      "      for Mapping_Spec_Suffix      (""Ada"") use ""%s"";" & ASCII.LF &
      "      for Mapping_Body_Suffix      (""Ada"") use ""%b"";" & ASCII.LF &
      "      for Config_File_Switches     (""Ada"") use (""-gnatec="");" & ASCII.LF &
      "      for Include_Path_File     (""Ada"") use ""ADA_PRJ_INCLUDE_FILE"";" & ASCII.LF &
      "      for Config_Body_File_Name    (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project (%u, Body_File_Name => """"%f"""");"";" & ASCII.LF &
      "      for Config_Spec_File_Name    (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project (%u, Spec_File_Name => """"%f"""");"";" & ASCII.LF &
      "      for Config_Body_File_Name_Pattern (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project "" &amp;" & ASCII.LF &
      "           ""  (Body_File_Name  => """"*%b"""","" &amp;" & ASCII.LF &
      "           ""   Casing          => %c,"" &amp;" & ASCII.LF &
      "           ""   Dot_Replacement => """"%d"""");"";" & ASCII.LF &
      "      for Config_Spec_File_Name_Pattern (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project "" &amp;" & ASCII.LF &
      "           ""  (Spec_File_Name  => """"*%s"""","" &amp;" & ASCII.LF &
      "           ""   Casing          => %c,"" &amp;" & ASCII.LF &
      "           ""   Dot_Replacement => """"%d"""");"";" & ASCII.LF &
      "      for Config_File_Unique    (""Ada"") use ""False"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Binder is" & ASCII.LF &
      "      for Objects_Path_File     (""Ada"") use ""ADA_PRJ_OBJECTS_FILE"";" & ASCII.LF &
      "      for Required_Switches     (""Ada"") use" & ASCII.LF &
      "          Binder'Required_Switches (""Ada"")  &amp;" & ASCII.LF &
      "          (""ada_binder=gnaampbind"");" & ASCII.LF &
      "      for Required_Switches (""Ada"") use" & ASCII.LF &
      "          Binder'Required_Switches (""Ada"") &amp; (""--RTS=${RUNTIME_DIR(ada)}"");" & ASCII.LF &
      "      for Driver         (""Ada"") use" & ASCII.LF &
      "          ""${GPRCONFIG_PREFIX}/libexec/gprbuild/gprbind"";" & ASCII.LF &
      "   end Binder;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Default_Switches (""Ada"") use (""-aamp_target=${RUNTIME(ada)}"");" & ASCII.LF &
      "      for Driver use ""aa_link"";" & ASCII.LF &
      "      for Max_Command_Line_Length use ""10000"";" & ASCII.LF &
      "      for Response_File_Format    use ""object_list"";" & ASCII.LF &
      "      for Response_File_Switches  use ("""");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "" & ASCII.LF &
      "   for Toolchain_Version     (""Ada"") use ""GNAT ${VERSION(ada)}"";" & ASCII.LF &
      "   for Runtime_Dir           (""Ada"") use ""${RUNTIME_DIR(ada)}"";" & ASCII.LF &
      "   for Runtime_Library_Dir   (""Ada"") use ""${RUNTIME_DIR(ada)}/adalib/"";" & ASCII.LF &
      "   for Runtime_Source_Dir    (""Ada"") use ""${RUNTIME_DIR(ada)}/adainclude/"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "      <compiler name=""AAMP_MAC""/>" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Objects_Linked (""aamp_macro_assembly"") use ""False"";" & ASCII.LF &
      "   for Runtime_Library_Dir   (""aamp_macro_assembly"") use ""${RUNTIME_DIR(aamp_macro_assembly)}"";" & ASCII.LF &
      "   package Naming is" & ASCII.LF &
      "      -- How to recognize MAC files" & ASCII.LF &
      "      for Body_Suffix (""aamp_macro_assembly"") use "".mac"";" & ASCII.LF &
      "   end Naming;" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      -- describes our code generation" & ASCII.LF &
      "      for Driver (""aamp_macro_assembly"") use ""macasm"";" & ASCII.LF &
      "      for Object_File_Suffix (""aamp_macro_assembly"") use "".obj"";" & ASCII.LF &
      "      for Default_Switches (""aamp_macro_assembly"") use " & ASCII.LF &
      "          (""-list""," & ASCII.LF &
      "           ""-cross""," & ASCII.LF &
      "           ""-instr""," & ASCII.LF &
      "           ""-in_mac=${RUNTIME_DIR(aamp_macro_assembly)}..\${RUNTIME(aamp_macro_assembly)}.mlb"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("aamp_compilers.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  GNAAMP -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GNAAMP</name>" & ASCII.LF &
      "    <executable>gnaampmake</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>gnaampls -v</external>" & ASCII.LF &
      "      <grep  regexp=""^GNATLS.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada</languages>" & ASCII.LF &
      "    <runtimes>" & ASCII.LF &
      "      <directory group=""1"" contents="""">\.\./lib/(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>aamp</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  AAMP_MAC -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>AAMP_MAC</name>" & ASCII.LF &
      "    <executable>macasm</executable>" & ASCII.LF &
      "    <version>1.0</version>" & ASCII.LF &
      "    <languages>aamp_macro_assembly</languages>" & ASCII.LF &
      "    <runtimes>" & ASCII.LF &
      "      <directory group=""1"" contents="""">\.\./lib/(.*)/adainclude</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>aamp</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("aarch64-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'aarch64-wrs-vxworks7'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^LLVMC-AARCH64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^LLVMC-AARCH64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x80000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("aarch64-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'aarch64-wrs-vxworks7r2'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^LLVMC-AARCH64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^LLVMC-AARCH64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x80000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--" & ASCII.LF &
      "   __aarch64_swp1_acq is provided by libgcc, but we want to avoid that" & ASCII.LF &
      "   dependency since we don't want users to link with libgcc when using" & ASCII.LF &
      "   restricted runtimes (this would introduce issues with certification)." & ASCII.LF &
      "  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    &if_ada;" & ASCII.LF &
      "    &if_restricted_rts;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "    <!-- vx7r2cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""Ada"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Ada"")" & ASCII.LF &
      "        &amp; (""-mno-outline-atomics"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    &if_adacore_c;" & ASCII.LF &
      "    &if_restricted_rts;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "    <!-- vx7r2cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-mno-outline-atomics"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    &if_adacore_cpp;" & ASCII.LF &
      "    &if_restricted_rts;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "    <!-- vx7r2cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C++"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-mno-outline-atomics"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("arm-vx6.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx6.ent SYSTEM ""vx6.ent""> %vx6.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'arm-wrs-vxworks'>" & ASCII.LF &
      "<!ENTITY this_gnu_wrs_suffix 'arm'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6$"" />" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x40000000'>" & ASCII.LF &
      "<!-- For vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_cpu_subdir 'arm/ARMARCH7/common'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx6;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("arm-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'arm-wrs-vxworks7'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7ARM$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7ARM$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x80000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("arm-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'arm-wrs-vxworks7r2'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^LLVMC-ARM$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^LLVMC-ARM$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x80000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("asis.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  ASIS -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "    <compiler name=""^ASIS$"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver                   (""Ada"") use ""${PATH(ada)}asis-gcc"";" & ASCII.LF &
      "      for Language_Kind            (""Ada"") use ""unit_based"";" & ASCII.LF &
      "      for Dependency_Kind          (""Ada"") use ""ALI_File"";" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use (""-c"", ""-x"", ""ada"", ""-gnatct"");" & ASCII.LF &
      "      for Config_File_Switches     (""Ada"") use (""-gnatec="");" & ASCII.LF &
      "      for Object_File_Suffix       (""Ada"") use "".adt"";" & ASCII.LF &
      "      for Include_Path_File     (""Ada"") use ""ADA_PRJ_INCLUDE_FILE"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   for Toolchain_Version (""Ada"") use ""GNAT ${VERSION(ada)}"";" & ASCII.LF &
      "   for Runtime_Dir       (""Ada"") use ""${RUNTIME_DIR(ada)}"";" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("asm.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "   <!--  This package provides the default standard options for a gcc" & ASCII.LF &
      "         Asm compiler -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-ASM$"" language=""Asm_Cpp"" />" & ASCII.LF &
      "       <compiler name=""^GCC-ASM_Pro$"" language=""Asm_Cpp"" />" & ASCII.LF &
      "       <compiler name=""^LLVM$"" language=""Asm_Cpp"" />" & ASCII.LF &
      "       <compiler name=""^CLANG-ASM$"" language=""Asm_Cpp"" />" & ASCII.LF &
      "       <compiler name=""^GNAT_LLVM_ASM$"" language=""Asm_Cpp"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver            (""Asm_Cpp"") use ""${PATH(asm_cpp)}${EXEC(asm_cpp)}"";" & ASCII.LF &
      "      for Leading_Required_Switches (""Asm_Cpp"") use" & ASCII.LF &
      "         Compiler'Leading_Required_Switches (""Asm_Cpp"") &amp;" & ASCII.LF &
      "         (""-c"", ""-x"", ""assembler-with-cpp"");" & ASCII.LF &
      "      for Include_Switches        (""Asm_Cpp"") use (""-I"");" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "      for Response_File_Format    (""Asm_Cpp"") use ""GCC_GNU"";" & ASCII.LF &
      "      for Dependency_Switches (""Asm_Cpp"") use (""-MMD"", ""-MF"", """");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-ASM$"" language=""Asm"" />" & ASCII.LF &
      "       <compiler name=""^GCC-ASM_Pro$"" language=""Asm"" />" & ASCII.LF &
      "       <compiler name=""^LLVM$"" language=""Asm"" />" & ASCII.LF &
      "       <compiler name=""^CLANG-ASM$"" language=""Asm"" />" & ASCII.LF &
      "       <compiler name=""^GNAT_LLVM_ASM$"" language=""Asm"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver            (""Asm"") use ""${PATH(asm)}${EXEC(asm)}"";" & ASCII.LF &
      "      for Leading_Required_Switches (""Asm"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Asm"") &amp;" & ASCII.LF &
      "        (""-c"", ""-x"", ""assembler"");" & ASCII.LF &
      "      for Include_Switches        (""Asm"") use (""-I"");" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "      for Response_File_Format    (""Asm"") use ""GCC_GNU"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-ASM$"" language=""Asm2"" />" & ASCII.LF &
      "       <compiler name=""^GCC-ASM_Pro$"" language=""Asm2"" />" & ASCII.LF &
      "       <compiler name=""^LLVM$"" language=""Asm2"" />" & ASCII.LF &
      "       <compiler name=""^CLANG-ASM$"" language=""Asm2"" />" & ASCII.LF &
      "       <compiler name=""^GNAT_LLVM_ASM$"" language=""Asm2"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver            (""Asm2"") use ""${PATH(asm2)}${EXEC(asm2)}"";" & ASCII.LF &
      "      for Leading_Required_Switches (""Asm2"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Asm2"") &amp;" & ASCII.LF &
      "        (""-c"", ""-x"", ""assembler"");" & ASCII.LF &
      "      for Include_Switches        (""Asm2"") use (""-I"");" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "      for Response_File_Format    (""Asm2"") use ""GCC_GNU"";" & ASCII.LF &
      "      for Dependency_Switches (""Asm2"") use (""-MMD"", ""-MF"", """");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("baselined.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^i686-elinos-linux$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""i686-elinos-linux-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""i686-elinos-linux-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-elinos-linux$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""powerpc-elinos-linux-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""powerpc-elinos-linux-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^powerpc-wrs-linux$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   for Archive_Builder  use (""powerpc-wrs-linux-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""powerpc-wrs-linux-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^e500v2-wrs-linux$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   for Archive_Builder  use (""e500v2-wrs-linux-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""e500v2-wrs-linux-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^.*-wrs-linux.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use Compiler'Driver (""Ada"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("bin_img.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "   <!--  This package provides the default standard options for binary image embedding -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^LD$"" language=""Bin_Img"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Naming is" & ASCII.LF &
      "      for Implementation_Suffix (""Bin_Img"") use """";" & ASCII.LF &
      "   end Naming;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver            (""Bin_Img"") use ""${PATH(bin_img)}${PREFIX(bin_img)}ld"";" & ASCII.LF &
      "      for Leading_Required_Switches (""Bin_Img"") use" & ASCII.LF &
      "         Compiler'Leading_Required_Switches (""Bin_Img"") &amp;" & ASCII.LF &
      "         (""-r"", ""-b"", ""binary"");" & ASCII.LF &
      "      for Object_File_Suffix (""Bin_Img"") use "".o"";" & ASCII.LF &
      "      for Object_File_Switches (""Bin_Img"") use (""-o"", """");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("c.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "   <!--  This package provides the default standard options for a gcc" & ASCII.LF &
      "         C compiler -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-28$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-CYGMING$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-SYSGO-X86$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-SYSGO-PPC$"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver              (""C"") use ""${PATH(c)}${EXEC(c)}"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "        <compiler name=""^GCC-MINGW32$"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver              (""C"") use ""${PATH(c)}${PREFIX(c)}gcc"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS5$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6CERT$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6CERTE500V2$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6E500V2$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS653-PPC$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS653-E500V2$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7ARM$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7E500V2$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7PPC$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86_64$"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver              (""C"") use ""${PATH(c)}cc${PREFIX(c)}"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""DIABC"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver              (""C"") use ""${PATH(c)}dcc"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""CLANG-C"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""LLVM"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver              (""C"") use ""${PATH(c)}${PREFIX(c)}clang"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--     GCC -I parameter passing" & ASCII.LF &
      "   Starting with 4.5, we use spec file to avoid line length limitations" & ASCII.LF &
      "   -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""GCC"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "   <compilers negate=""true"">" & ASCII.LF &
      "     <compiler version=""^2\.\d+"" />" & ASCII.LF &
      "     <compiler version=""^3\.\d+"" />" & ASCII.LF &
      "     <compiler version=""^4\.[01234]"" />" & ASCII.LF &
      "     <!--" & ASCII.LF &
      "     On VxWorks 6, 6 cert and 653, version is not the version of" & ASCII.LF &
      "     gcc but the version of the OS. All of these are using gcc" & ASCII.LF &
      "     that are older than 4.5, and we do not expect more releases" & ASCII.LF &
      "     for these products at this point. FTR, here are the most recent" & ASCII.LF &
      "     versions:" & ASCII.LF &
      "     - VxWorks Cert 6.6.4.1: 4.1.2" & ASCII.LF &
      "     - VxWorks 6.9: gcc 4.3.3" & ASCII.LF &
      "     - VxWorks 653 2.5.0.2: gcc 4.3.3" & ASCII.LF &
      "     - VxWorks 653 3.1.3: gcc 4.3.3.2" & ASCII.LF &
      "     -->" & ASCII.LF &
      "     <compiler version=""^vxworks-6\.\d+"" />" & ASCII.LF &
      "     <compiler version=""^vxworks-cert-6\.\d+"" />" & ASCII.LF &
      "     <compiler version=""^vxworks653-.*"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C"") use" & ASCII.LF &
      "         (""-c"", ""-x"", ""c"") &amp; Compiler'Leading_Required_Switches (""C"");" & ASCII.LF &
      "      for Include_Switches_Via_Spec   (""C"") use (""cc1"", ""-I"");" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "      for Response_File_Format    (""C"") use ""GCC_GNU"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""GCC"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler version=""^2\.\d+"" />" & ASCII.LF &
      "     <compiler version=""^3\.\d+"" />" & ASCII.LF &
      "     <compiler version=""^4\.[01234]"" />" & ASCII.LF &
      "     <compiler version=""^vxworks-6\.\d+"" />" & ASCII.LF &
      "     <compiler version=""^vxworks-cert-6\.\d+"" />" & ASCII.LF &
      "     <compiler version=""^vxworks653-.*"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C"") use" & ASCII.LF &
      "         (""-c"", ""-x"", ""c"") &amp; Compiler'Leading_Required_Switches (""C"");" & ASCII.LF &
      "      for Include_Switches   (""C"") use (""-I"");" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "      for Response_File_Format    (""C"") use ""GCC_GNU"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""CLANG-C"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""LLVM"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C"") use" & ASCII.LF &
      "         (""-c"", ""-x"", ""c"") &amp; Compiler'Leading_Required_Switches (""C"");" & ASCII.LF &
      "      for Include_Switches   (""C"") use (""-I"");" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "      for Response_File_Format    (""C"") use ""GCC_GNU"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--     GCC 2.8.1 & VxWorks 5" & ASCII.LF &
      "   Switch -MMD is not supported on GCC 2.8.1. So, we use an undocumented" & ASCII.LF &
      "   switch. -MF is not supported by the VxWorks 5 gcc" & ASCII.LF &
      "   -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-28$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS5$"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Dependency_Switches (""C"") use (""-Wp,-MMD,"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^CLANG-C$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-CYGMING$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-MINGW32$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6E500V2$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6CERT$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6CERTE500V2$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS653-PPC$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS653-E500V2$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86_64$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7PPC$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7E500V2$"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Dependency_Switches (""C"") use (""-MMD"", ""-MF"", """");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^DIABC-PPC$"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C"") use" & ASCII.LF &
      "         Compiler'Leading_Required_Switches (""C"") &amp; (""-tPPC750EH:cross"", ""-c"");" & ASCII.LF &
      "      for Dependency_Switches (""C"") use" & ASCII.LF &
      "         (""-Xmake-dependency=6"", ""-Xmake-dependency-savefile="");" & ASCII.LF &
      "      for Include_Path        (""C"") use ""CPATH"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^DIABC-PPC64$"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-tPPCLP64FH:vxworks7""," & ASCII.LF &
      "               ""-c""," & ASCII.LF &
      "               ""-ffixed-r13""," & ASCII.LF &
      "               ""-Xclib-optim-off""," & ASCII.LF &
      "               ""-Xlocal-data-area-static-only""," & ASCII.LF &
      "               ""-Xc-new""," & ASCII.LF &
      "               ""-Xcode-absolute-far""," & ASCII.LF &
      "               ""-D_WRS_HARDWARE_FP""," & ASCII.LF &
      "               ""-DCPU=_VX_PPCE6500""," & ASCII.LF &
      "               ""-D_WRS_VX_SMP""," & ASCII.LF &
      "               ""-D_WRS_CONFIG_SMP"");" & ASCII.LF &
      "      for Dependency_Switches (""C"") use" & ASCII.LF &
      "         (""-Xmake-dependency=6"", ""-Xmake-dependency-savefile="");" & ASCII.LF &
      "      for Include_Path        (""C"") use ""CPATH"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!--  Additional switches needed on some platforms -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^CLANG-C$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" language=""C"" />" & ASCII.LF &
      "       <compiler name=""^GCC-28$"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <targets negate=""true"">" & ASCII.LF &
      "       <target name=""^.*LynxOS.*$"" />" & ASCII.LF &
      "       <target name=""^.*mingw.*$"" />" & ASCII.LF &
      "       <target name=""^.*cygwin.*$"" />" & ASCII.LF &
      "       <target name=""^.*dec-osf.*$"" />" & ASCII.LF &
      "       <target name=""^.*wrs-vxworks.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for PIC_Option (""C"") use (""-fPIC"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- for cygming we make sure that the option -mno-cygwin is used -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-CYGMING$"" language=""C"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"") &amp; (""-mno-cygwin"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- VxWorks 7.x C support using the WRS compilers  -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7ARM$"" runtime=""^kernel$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7PPC$"" runtime=""^kernel$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7E500V2$"" runtime=""^kernel$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86$"" runtime=""^kernel$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86_64$"" runtime=""^kernel$"" />" & ASCII.LF &
      "       <compiler name=""^DIABC-PPC64$"" runtime=""^kernel$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-I"" &amp; VSB_Dir &amp; ""/h""," & ASCII.LF &
      "               ""-I"" &amp; VSB_Dir &amp; ""/share/h""," & ASCII.LF &
      "               ""-I"" &amp; VSB_Dir &amp; ""/krnl/h/system""," & ASCII.LF &
      "               ""-I"" &amp; VSB_Dir &amp; ""/krnl/h/public""," & ASCII.LF &
      "               ""-D_WRS_KERNEL"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" runtime=""^rtp$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"") &amp; (""-mrtp"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7ARM$"" runtime=""^rtp$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7PPC$"" runtime=""^rtp$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7E500V2$"" runtime=""^rtp$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86$"" runtime=""^rtp$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86_64$"" runtime=""^rtp$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"") &amp; (""-mrtp"")" & ASCII.LF &
      "        &amp; (""-I"" &amp; VSB_Dir &amp; ""/h""," & ASCII.LF &
      "               ""-I"" &amp; VSB_Dir &amp; ""/share/h""," & ASCII.LF &
      "               ""-I"" &amp; VSB_Dir &amp; ""/usr/h/public""," & ASCII.LF &
      "               ""-I"" &amp; VSB_Dir &amp; ""/usr/h"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7ARM$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7E500V2$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7PPC$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86_64$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-DTOOL_FAMILY=gnu""," & ASCII.LF &
      "               ""-DTOOL=gnu""," & ASCII.LF &
      "               ""-D_VSB_CONFIG_FILE=&lt;config/vsbConfig.h&gt;"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^DIABC-PPC64$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-DTOOL_FAMILY=diab""," & ASCII.LF &
      "               ""-DTOOL=diab""," & ASCII.LF &
      "               ""-D_VSB_CONFIG_FILE=&lt;config/vsbConfig.h&gt;"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86_64$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-m64"", ""-mcmodel=large"",  ""-mno-red-zone"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7ARM$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-DCPU=_VX_ARMARCH7""," & ASCII.LF &
      "               ""-t7""," & ASCII.LF &
      "               ""-mfpu=vfp""," & ASCII.LF &
      "               ""-mfloat-abi=softfp"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7E500V2$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-DCPU=_VX_PPCE500V2""," & ASCII.LF &
      "               ""-te500v2""," & ASCII.LF &
      "               ""-mhard-float""," & ASCII.LF &
      "               ""-mstrict-align"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7PPC$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-DCPU=_VX_PPCE500MC""," & ASCII.LF &
      "               ""-mno-powerpc-gfxopt""," & ASCII.LF &
      "               ""-mno-isel"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("clean.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "      <config>" & ASCII.LF &
      "   package Clean is" & ASCII.LF &
      "" & ASCII.LF &
      "      --  Remove the files generated by gnatinspect (in the context of GPS)" & ASCII.LF &
      "      for Artifacts_In_Object_Dir use Clean'Artifacts_In_Object_Dir" & ASCII.LF &
      "         &amp; (""gnatinspect.*"");" & ASCII.LF &
      "   end Clean;" & ASCII.LF &
      "      </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-arm-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS7ARM</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(arm)</executable>" & ASCII.LF &
      "    &version_from_wrs7_gnu_cc;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx7;" & ASCII.LF &
      "    <target>arm-wrs-vxworks7</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-asis.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  ASIS tree generator  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>ASIS</name>" & ASCII.LF &
      "    <executable>asis-gcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "     <external>asis-gcc -v</external>" & ASCII.LF &
      "     <grep  regexp="".*for GNAT Pro.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada</languages>" & ASCII.LF &
      "    <runtimes default=""default"">" & ASCII.LF &
      "       <directory group=""default"" >\.\./lib/gcc/(.*)/(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>asis</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-baselined.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- G++ for WRS Linux -->" & ASCII.LF &
      "   <compiler_description>" & ASCII.LF &
      "     <name>G++-WRSLINUX</name>" & ASCII.LF &
      "     <executable prefix=""1"">(powerpc-wrs-linux-gnu)-cpp</executable>" & ASCII.LF &
      "     <version>" & ASCII.LF &
      "       <external>${PREFIX}-cpp -v</external>" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "     </version>" & ASCII.LF &
      "     <languages>C++</languages>" & ASCII.LF &
      "     <runtimes>full</runtimes>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>${PREFIX}-cpp -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""(.*)-gnu"" group=""1""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "   </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "   <compiler_description>" & ASCII.LF &
      "     <name>G++-WRSLINUXE500V2</name>" & ASCII.LF &
      "     <executable prefix=""1"">(powerpc-wrs-linux-gnu)-cpp</executable>" & ASCII.LF &
      "     <version>" & ASCII.LF &
      "       <external>${PREFIX}-cpp -v</external>" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "     </version>" & ASCII.LF &
      "     <languages>C++</languages>" & ASCII.LF &
      "     <runtimes>full</runtimes>" & ASCII.LF &
      "     <target>e500v2-wrs-linux</target>" & ASCII.LF &
      "   </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- C for WRS Linux -->" & ASCII.LF &
      "   <compiler_description>" & ASCII.LF &
      "     <name>GCC-WRSLINUX</name>" & ASCII.LF &
      "     <executable prefix=""1"">(powerpc-wrs-linux-gnu)-gcc</executable>" & ASCII.LF &
      "     <version>" & ASCII.LF &
      "       <external>${PREFIX}-cpp -v</external>" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "     </version>" & ASCII.LF &
      "     <languages>C</languages>" & ASCII.LF &
      "     <runtimes>full</runtimes>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>${PREFIX} -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""(.*)-gnu"" group=""1""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "   </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "   <compiler_description>" & ASCII.LF &
      "     <name>GCC-WRSLINUXE500V2</name>" & ASCII.LF &
      "     <executable prefix=""1"">(powerpc-wrs-linux-gnu)-gcc</executable>" & ASCII.LF &
      "     <version>" & ASCII.LF &
      "       <external>${PREFIX}-cpp -v</external>" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "     </version>" & ASCII.LF &
      "     <languages>C</languages>" & ASCII.LF &
      "     <runtimes>full</runtimes>" & ASCII.LF &
      "     <target>e500v2-wrs-linux</target>" & ASCII.LF &
      "   </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-e500v2-vx6.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx6.ent SYSTEM ""vx6.ent""> %vx6.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>E500V2-VX6-GCC-WRS</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(ppc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wind_base;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx6;" & ASCII.LF &
      "    <target>e500v2-wrs-vxworks</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>E500V2-VX6-G++-WRS</name>" & ASCII.LF &
      "    <executable prefix=""1"">c\+\+(ppc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wind_base;" & ASCII.LF &
      "    &languages_cpp;" & ASCII.LF &
      "    &runtimes_vx6;" & ASCII.LF &
      "    <target>e500v2-wrs-vxworks</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS6CERTE500V2</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(ppc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wind_base_cert;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx6cert;" & ASCII.LF &
      "    <target>e500v2-wrs-vxworks</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>G++-WRS6CERTE500V2</name>" & ASCII.LF &
      "    <executable prefix=""1"">c\+\+(ppc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wind_base_cert;" & ASCII.LF &
      "    &languages_cpp;" & ASCII.LF &
      "    &runtimes_vx6cert;" & ASCII.LF &
      "    <target>e500v2-wrs-vxworks</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-e500v2-vx653.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx653.ent SYSTEM ""vx653.ent""> %vx653.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- WRS gcc -v or -dumpmachine have different results depending on" & ASCII.LF &
      "       the version: on 2.3.0.1 and before, it would return" & ASCII.LF &
      "       powerpc-wrs-vxworksae; on 2.4 and later it would return" & ASCII.LF &
      "       powerpc-wrs-vxworks. That (plus the fact the e500v2 and ppc" & ASCII.LF &
      "       compilers use the same executables: ccppc and c++ppc) makes" & ASCII.LF &
      "       us specify one compiler description per CPU. In each of these" & ASCII.LF &
      "       descriptions, the target is hard-coded instead of being deduced" & ASCII.LF &
      "       from cc${PREFIX} -v.  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS653-E500V2</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(ppc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wind_base_vx653;" & ASCII.LF &
      "    &languages_cpp;" & ASCII.LF &
      "    &runtimes_vx653;" & ASCII.LF &
      "    <target>e500v2-wrs-vxworksae</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>G++-WRS653-E500V2</name>" & ASCII.LF &
      "    <executable prefix=""1"">c\+\+(ppc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wind_base_vx653;" & ASCII.LF &
      "    &languages_cpp;" & ASCII.LF &
      "    &runtimes_vx653;" & ASCII.LF &
      "    <target>e500v2-wrs-vxworksae</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-e500v2-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS7E500V2</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(ppc)</executable>" & ASCII.LF &
      "    &version_from_wrs7_gnu_cc;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx7;" & ASCII.LF &
      "    <target>e500v2-wrs-vxworks7</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-e500v2-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS7R2E500V2</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(ppc)</executable>" & ASCII.LF &
      "    &version_from_wrs7r2_gnu_cc;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx7;" & ASCII.LF &
      "    <target>e500v2-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-ppc-vx653.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx653.ent SYSTEM ""vx653.ent""> %vx653.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- WRS gcc -v or -dumpmachine have different results depending on" & ASCII.LF &
      "       the version: on 2.3.0.1 and before, it would return" & ASCII.LF &
      "       powerpc-wrs-vxworksae; on 2.4 and later it would return" & ASCII.LF &
      "       powerpc-wrs-vxworks. That (plus the fact the e500v2 and ppc" & ASCII.LF &
      "       compilers use the same executables: ccppc and c++ppc) makes" & ASCII.LF &
      "       us specify one compiler description per CPU. In each of these" & ASCII.LF &
      "       descriptions, the target is hard-coded instead of being deduced" & ASCII.LF &
      "       from cc${PREFIX} -v.  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS653-PPC</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(ppc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wind_base_vx653;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx653;" & ASCII.LF &
      "    <target>powerpc-wrs-vxworksae</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>G++-WRS653-PPC</name>" & ASCII.LF &
      "    <executable prefix=""1"">c\+\+(ppc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wind_base_vx653;" & ASCII.LF &
      "    &languages_cpp;" & ASCII.LF &
      "    &runtimes_vx653;" & ASCII.LF &
      "    <target>powerpc-wrs-vxworksae</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-ppc-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS7PPC</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(ppc)</executable>" & ASCII.LF &
      "    &version_from_wrs7_gnu_cc;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx7;" & ASCII.LF &
      "    <target>powerpc-wrs-vxworks7</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-ppc-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS7R2PPC</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(ppc)</executable>" & ASCII.LF &
      "    &version_from_wrs7r2_gnu_cc;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx7;" & ASCII.LF &
      "    <target>powerpc-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-ppc64-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Diab PPC64 C Compiler -->" & ASCII.LF &
      "  <!-- check that the version is >= 5.9.6.0 -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>DIABC-PPC64</name>" & ASCII.LF &
      "    <executable>dcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>dcc -V</external>" & ASCII.LF &
      "      <grep regexp="".*dcc(.exe)? Rel ([0-9.]*)"" group=""2""></grep>" & ASCII.LF &
      "      <must_match>5[.]9[.][6-9].*</must_match>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    &runtimes_vx7;" & ASCII.LF &
      "    <target>powerpc64-wrs-vxworks7</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-ppc64-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS7R2PPC64</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(ppc)</executable>" & ASCII.LF &
      "    &version_from_wrs7r2_gnu_cc;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx7;" & ASCII.LF &
      "    <target>powerpc64-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-vxworks.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx6.ent SYSTEM ""vx6.ent""> %vx6.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS6</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(arm|pentium|ppc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wind_base;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx6;" & ASCII.LF &
      "    &target_from_wrs_gnu_cc;" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>G++-WRS6</name>" & ASCII.LF &
      "    <executable prefix=""1"">c\+\+(arm|pentium|ppc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wind_base;" & ASCII.LF &
      "    &languages_cpp;" & ASCII.LF &
      "    &runtimes_vx6;" & ASCII.LF &
      "    &target_from_wrs_gnu_cpp;" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- VxWorks 6 Cert -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS6CERT</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(arm|pentium|ppc)</executable>" & ASCII.LF &
      "    &version_from_wind_base_cert;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx6cert;" & ASCII.LF &
      "    &target_from_wrs_gnu_cc;" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>G++-WRS6CERT</name>" & ASCII.LF &
      "    <executable prefix=""1"">c\+\+(arm|pentium|ppc)</executable>" & ASCII.LF &
      "    &version_from_wind_base_cert;" & ASCII.LF &
      "    &languages_cpp;" & ASCII.LF &
      "    &runtimes_vx6cert;" & ASCII.LF &
      "    &target_from_wrs_gnu_cpp;" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- VxWorks 5 -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS5</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(arm|pentium|sh|mips|ppc|sparc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wrs_gnu_cc_vx5;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &target_from_wrs_gnu_cc;" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>G++-WRS5</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(arm|pentium|sh|mips|ppc|sparc)</executable>" & ASCII.LF &
      "" & ASCII.LF &
      "    &version_from_wrs_gnu_cpp_vx5;" & ASCII.LF &
      "    &languages_cpp;" & ASCII.LF &
      "    &target_from_wrs_gnu_cpp;" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-x86-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS7X86</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(pentium)</executable>" & ASCII.LF &
      "    &version_from_wrs7_gnu_cc;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx7;" & ASCII.LF &
      "    <target>i586-wrs-vxworks7</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers-x86_64-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-WRS7X86_64</name>" & ASCII.LF &
      "    <executable prefix=""1"">cc(pentium)</executable>" & ASCII.LF &
      "    &version_from_wrs7_gnu_cc;" & ASCII.LF &
      "    &languages_c;" & ASCII.LF &
      "    &runtimes_vx7;" & ASCII.LF &
      "    <target>x86_64-wrs-vxworks7</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("compilers.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "  <!--  Languages that require no compiler, but can be selected through" & ASCII.LF &
      "        -config -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>SIMULINK</name>" & ASCII.LF &
      "    <languages>Simulink</languages>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>MATLAB</name>" & ASCII.LF &
      "    <languages>Matlab</languages>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>PRJFILE</name>" & ASCII.LF &
      "    <languages>Project File</languages>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--    GCC 3.x & 4.x (not for GNAT Pro)-->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC</name>" & ASCII.LF &
      "    <executable prefix=""1"">(.*-wrs-.*|.*-sysgo.*|.*-elf-.*|.*-eabi-.*|.*-eabispe-.*|avr-.*|.*-elinos-linux.*|.*-linux-gnu-|.*mingw32.*|.*-xcoff-.*|.*linux-android.*|arm-linux-gnueabi-|arm-linux-gnueabihf-|e500v2-gnu-linux-|powerpc-.*-linux.*-|.*-darwin.*-|.*-freebsd.*)?gcc(-\d+)?</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>$EXEC -v</external>" & ASCII.LF &
      "      <nogrep regexp=""for GNAT Pro""></nogrep>" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>$EXEC -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--    GCC for GNAT Pro 3.x & 4.x -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC_Pro</name>" & ASCII.LF &
      "    <executable prefix=""1"">(.*-wrs-.*|.*-sysgo.*|.*-elf-.*|.*-eabi-.*|.*-eabispe-.*|avr-.*|.*-elinos-linux.*|.*-linux-gnu-|.*mingw32.*|.*-xcoff-.*|.*linux-android.*|arm-linux-gnueabi-|arm-linux-gnueabihf-|e500v2-gnu-linux-|powerpc-.*-linux.*-|.*-darwin.*-|.*-fastos.*|.*-freebsd.*|.*-qnx.*|.*-rtems.*)?gcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}gcc -v</external>" & ASCII.LF &
      "" & ASCII.LF &
      "      <!--  'gcc version 4.7.4 20131104 for GNAT Pro ...' -->" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+) \d+ (\(prerelease\) )?\(?for GNAT Pro"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>${PREFIX}gcc -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- PikeOS -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-SYSGO-ARM</name>" & ASCII.LF &
      "    <executable prefix=""1"">(arm_v7hf-)gcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <getenv name=""PIKEOS_VERSION"" />" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>arm-sysgo-pikeos</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-SYSGO-X86</name>" & ASCII.LF &
      "    <executable prefix=""1"">(x86_i586-)gcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <getenv name=""PIKEOS_VERSION"" />" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>i586-sysgo-pikeos</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-SYSGO-PPC</name>" & ASCII.LF &
      "    <executable prefix=""1"">(ppc_oea-)gcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <getenv name=""PIKEOS_VERSION"" />" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>powerpc-sysgo-pikeos</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--     GCC 2.8.1" & ASCII.LF &
      "    There is no switch, in such versions, to find out the list of languages," & ASCII.LF &
      "    so we just assume there is only C." & ASCII.LF &
      "    C++ could be found by looking for the ""g++"" executable" & ASCII.LF &
      "  -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-28</name>" & ASCII.LF &
      "    <executable>gcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "      <must_match>2\.8\.</must_match>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>gcc -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  G++ compilers (not for GNAT Pro)  -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>G++</name>" & ASCII.LF &
      "    <executable>g\+\+(-\d+)?</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>$EXEC -v</external>" & ASCII.LF &
      "      <nogrep regexp=""for GNAT Pro""></nogrep>" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C++</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>$EXEC -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  G++ compilers for GNAT Pro  -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>G++_Pro</name>" & ASCII.LF &
      "    <executable prefix=""1"">(.*-elf-.*|.*-eabi-.*|.*-wrs-.*|.*-fastos.*|.*-freebsd.*|.*-linux-gnu.*-|.*-linux-android.*|.*-rtems.*)?g\+\+</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}g++ -v</external>" & ASCII.LF &
      "" & ASCII.LF &
      "      <!--  'gcc version 4.7.4 20131104 for GNAT Pro ...' -->" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+) \d+ \(?for GNAT Pro"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C++</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>${PREFIX}g++ -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Assembler (not for GNAT Pro) -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-ASM</name>" & ASCII.LF &
      "    <executable prefix=""1"">(.*-wrs-.*|.*-sysgo.*|.*-elf-.*|.*-eabi-.*|.*-eabispe-.*|avr-.*|.*-elinos-linux.*|.*-linux-gnu-|.*mingw32.*|.*-xcoff-.*|.*linux-android.*|arm-linux-gnueabi-|arm-linux-gnueabihf-|e500v2-gnu-linux-|powerpc-.*-linux.*-|.*-darwin.*-|.*-fastos.*|.*-freebsd.*|.*-qnx.*|.*-rtems.*)?gcc(-\d+)?</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>$EXEC -v</external>" & ASCII.LF &
      "      <nogrep regexp=""for GNAT Pro""></nogrep>" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Asm,Asm_Cpp,Asm2</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>$EXEC -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Assembler (for GNAT Pro) -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-ASM_Pro</name>" & ASCII.LF &
      "    <executable prefix=""1"">(.*-wrs-.*|.*-sysgo.*|.*-elf-.*|.*-eabi-.*|.*-eabispe-.*|avr-.*|.*-elinos-linux.*|.*-linux-gnu-|.*mingw32.*|.*-xcoff-.*|.*linux-android.*|arm-linux-gnueabi-|arm-linux-gnueabihf-|e500v2-gnu-linux-|powerpc-.*-linux.*-|.*-darwin.*-|.*-.*fastos.*|.*-freebsd.*|.*-qnx.*|.*-rtems.*)?gcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+) \d+ (\(prerelease\) )?\(?for GNAT Pro"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Asm,Asm_Cpp,Asm2</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>${PREFIX}gcc -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Binary image -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>LD</name>" & ASCII.LF &
      "    <executable prefix=""1"">(.*-wrs.*-|.*-sysgo.*-|.*-elf.*-|.*-eabi.*-|.*-eabispe.*-|avr.*-|.*-elinos-linux.*-|.*-linux-gnu-|.*mingw32.*-|.*-xcoff.*-|.*linux-android.*|arm-linux-gnueabi-|arm-linux-gnueabihf-|e500v2-gnu-linux-|powerpc-.*-linux.*-|.*-darwin.*-|.*-fastos.*|.*-freebsd.*|.*-qnx.*-|.*-rtems.*-)?ld</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}ld -v</external>" & ASCII.LF &
      "      <grep regexp=""^(GNU ld.*|LLD) (\S+)"" group=""2""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Bin_Img</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>${PREFIX}gcc -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!--   GNAT" & ASCII.LF &
      "    To find the list of supported runtimes, we check the contents of" & ASCII.LF &
      "    the directory. To be compatible with older versions of GNAT (3.16" & ASCII.LF &
      "    for instance), we also accept lib/gcc-lib as the directory that" & ASCII.LF &
      "    contains the runtime files." & ASCII.LF &
      "   -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GNAT</name>" & ASCII.LF &
      "    <executable prefix=""1"">(.*-wrs-.*|.*-sysgo.*|.*-elf-.*|.*-eabi-.*|.*-eabispe-.*|avr-.*|.*-elinos-linux.*|.*-linux-gnu-|.*mingw32.*|.*-xcoff-.*|.*linux-android.*|arm-linux-gnueabi-|arm-linux-gnueabihf-|e500v2-gnu-linux-|powerpc-.*-linux.*-|.*-darwin.*-|.*-fastos.*|.*-freebsd.*|.*-qnx.*|.*-rtems.*)?gnatls</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}gnatls -v --version</external>" & ASCII.LF &
      "      <grep regexp=""^GNATLS.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada</languages>" & ASCII.LF &
      "    <variable name=""gcc_version"">" & ASCII.LF &
      "      <external>${PREFIX}gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^[-\w]*gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </variable>" & ASCII.LF &
      "    <variable name=""gcc_version_major"">" & ASCII.LF &
      "      <external>${PREFIX}gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^[-\w]*gcc \S+ (\d+)\.\d+\.\d+"" group=""1""></grep>" & ASCII.LF &
      "    </variable>" & ASCII.LF &
      "    <runtimes default=""default,kernel,native"">" & ASCII.LF &
      "       <directory group=""default"" >\.\./lib(32|64)?/gcc(-lib)?/$TARGET/($gcc_version|$gcc_version_major)/adalib/</directory>" & ASCII.LF &
      "       <directory group=""default"" contents=""^rts-"">\.\./lib(32|64)?/gcc(-lib)?/$TARGET/($gcc_version|$gcc_version_major)/ada_object_path</directory>" & ASCII.LF &
      "       <directory group=""4"" >\.\./lib(32|64)?/gcc(-lib)?/$TARGET/($gcc_version|$gcc_version_major)/rts-(.*)/adalib/</directory>" & ASCII.LF &
      "       <directory group=""2"" >\.\./$TARGET/lib(32|64)?/gnat/(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>${PREFIX}gcc -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  CodePeer -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GNAT_CODEPEER</name>" & ASCII.LF &
      "    <executable prefix=""1"">(.*gnatsas-|.*gnsa-|.*codepeer-)gnatls</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}gnatls -v</external>" & ASCII.LF &
      "      <grep regexp=""^GNATLS.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada,C,C++</languages>" & ASCII.LF &
      "    <variable name=""gcc_version"">" & ASCII.LF &
      "      <external>${PREFIX}gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^[-\w]*gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </variable>" & ASCII.LF &
      "    <runtimes default=""default,native"">" & ASCII.LF &
      "       <directory group=""default"" >\.\./lib/codepeer/lib/gcc/.*/$gcc_version/adalib/</directory>" & ASCII.LF &
      "       <directory group=""1"" >\.\./lib/codepeer/lib/gnat/(.*)/adalib/</directory>" & ASCII.LF &
      "       <directory group=""1"" >\.\./lib/codepeer/lib/gcc/.*/$gcc_version/rts-(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>codepeer</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Generic GNAT LLVM Target -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GNAT_LLVM_NATIVE</name>" & ASCII.LF &
      "    <executable prefix=""1"">(llvm-)gnatls</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}gnatls -v</external>" & ASCII.LF &
      "      <grep regexp=""^GNATLS.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada</languages>" & ASCII.LF &
      "    <variable name=""gcc_version"">" & ASCII.LF &
      "      <external>${PREFIX}gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^[-\w]*gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </variable>" & ASCII.LF &
      "    <runtimes default=""default,native"">" & ASCII.LF &
      "       <directory group=""default"" >\.\./lib/rts-native/adalib/</directory>" & ASCII.LF &
      "       <directory group=""1"" >\.\./lib/rts-(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>llvm</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Architecture-specific GNAT-LLVM Ada compiler  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GNAT_LLVM</name>" & ASCII.LF &
      "    <executable prefix=""1"">((.*-elf-|.*-linux-gnu-)?llvm-)gnatls</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}gnatls -v</external>" & ASCII.LF &
      "      <grep regexp=""^GNATLS.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada</languages>" & ASCII.LF &
      "    <variable name=""gcc_version"">" & ASCII.LF &
      "      <external>${PREFIX}gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^[-\w]*gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </variable>" & ASCII.LF &
      "    <runtimes default=""default,native"">" & ASCII.LF &
      "       <directory group=""default"" >\.\./lib/rts-native/adalib/</directory>" & ASCII.LF &
      "       <directory group=""1"" >\.\./lib/rts-(.*)/adalib/</directory>" & ASCII.LF &
      "       <directory group=""2"" >\.\./$TARGET/lib(32|64)?/gnat-llvm/(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>${PREFIX}gcc -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Architecture-specific GNAT-LLVM assembler  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GNAT_LLVM_ASM</name>" & ASCII.LF &
      "    <executable prefix=""1"">((.*-elf-|.*-linux-gnu-)?llvm-)gcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>$EXEC -v</external>" & ASCII.LF &
      "      <grep regexp=""^llvm-.*gcc.+GNAT Pro (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Asm,Asm_Cpp,Asm2</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>$EXEC -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Generic C compiler for LLVM  -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>C_LLVM</name>" & ASCII.LF &
      "    <executable>clang</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>clang --version</external>" & ASCII.LF &
      "" & ASCII.LF &
      "      <!--  '...clang version 6.0.0...'  -->" & ASCII.LF &
      "      <grep regexp=""clang version (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>llvm</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Generic C++ compiler for LLVM  -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>C++_LLVM</name>" & ASCII.LF &
      "    <executable>clang\+\+</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>clang++ --version</external>" & ASCII.LF &
      "" & ASCII.LF &
      "      <!--  '...clang version 6.0.0...'  -->" & ASCII.LF &
      "      <grep regexp=""clang version (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C++</languages>" & ASCII.LF &
      "    <target>llvm</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  C Target -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GNAT_C</name>" & ASCII.LF &
      "    <executable prefix=""1"">(c-)gnatls</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}gnatls -v</external>" & ASCII.LF &
      "      <grep regexp=""^GNATLS.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada</languages>" & ASCII.LF &
      "    <variable name=""gcc_version"">" & ASCII.LF &
      "      <external>${PREFIX}gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^[-\w]*gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </variable>" & ASCII.LF &
      "    <runtimes default=""default,ccg"">" & ASCII.LF &
      "       <directory group=""default"" >\.\./lib/gnat_ccg/lib/gcc/.*/$gcc_version/adalib/</directory>" & ASCII.LF &
      "       <directory group=""1"" >\.\./lib/gnat_ccg/lib/gcc/.*/$gcc_version/rts-(.*)/adalib/</directory>" & ASCII.LF &
      "       <directory group=""1"" >\.\./lib/gnat/(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>c</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  CCG Target (C generation via LLVM) -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GNAT_CCG</name>" & ASCII.LF &
      "    <executable prefix=""1"">(c-|llvm-)gnatls</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}gnatls -v</external>" & ASCII.LF &
      "      <grep regexp=""^GNATLS.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada</languages>" & ASCII.LF &
      "    <variable name=""gcc_version"">" & ASCII.LF &
      "      <external>${PREFIX}gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^[-\w]*gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </variable>" & ASCII.LF &
      "    <runtimes default=""default,ccg"">" & ASCII.LF &
      "       <directory group=""default"" >\.\./lib/rts-ccg/adalib/</directory>" & ASCII.LF &
      "       <directory group=""1"" >\.\./lib/rts-(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>c</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  GNAT CUDA Target -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GNAT_CUDA</name>" & ASCII.LF &
      "    <executable prefix=""1"">llvm-gnatls</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>llvm-gnatls -v</external>" & ASCII.LF &
      "      <grep regexp=""^GNATLS.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada</languages>" & ASCII.LF &
      "    <variable name=""gcc_version"">" & ASCII.LF &
      "      <external>cuda-gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^[-\w]*gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </variable>" & ASCII.LF &
      "    <runtimes default=""default,device-cuda"">" & ASCII.LF &
      "       <directory group=""default"" >\.\./lib/rts-device-cuda/adalib/</directory>" & ASCII.LF &
      "       <directory group=""1"" >\.\./lib/rts-(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>cuda</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  GNAT_DOTNET -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GNAT_DOTNET</name>" & ASCII.LF &
      "    <executable prefix=""1"">(.*dotnet-)gnatls</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}gnatls -v</external>" & ASCII.LF &
      "      <grep regexp=""^GNATLS.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada</languages>" & ASCII.LF &
      "    <runtimes default=""default,kernel"">" & ASCII.LF &
      "       <directory group=""default"" >\.\./lib/dotgnat/adalib/</directory>" & ASCII.LF &
      "       <directory group=""1"" >\.\./lib/dotgnat/rts-(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>dotnet</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  JGNAT -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>JGNAT</name>" & ASCII.LF &
      "    <executable prefix=""1"">(.*jvm-)gnatls</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}gnatls -v</external>" & ASCII.LF &
      "      <grep regexp=""^GNATLS.+?(\d+(\.\d+)?)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Ada</languages>" & ASCII.LF &
      "    <runtimes default=""default"">" & ASCII.LF &
      "       <directory group=""default"" >\.\./lib/jgnat/adalib/</directory>" & ASCII.LF &
      "       <directory group=""1"" >\.\./lib/jgnat/rts-(.*)/adalib/</directory>" & ASCII.LF &
      "    </runtimes>" & ASCII.LF &
      "    <target>jvm</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--    G77  -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>G77</name>" & ASCII.LF &
      "    <executable>g77</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>g77 --version</external>" & ASCII.LF &
      "      <grep regexp=""\(GCC.*\) (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Fortran</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>g77 -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--    GFortran  -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GFORTRAN</name>" & ASCII.LF &
      "    <executable>gfortran(-\d+)?</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>$EXEC -v</external>" & ASCII.LF &
      "      <grep regexp=""^gcc \S+ (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Fortran</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>$EXEC -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--    mingw-cygwin compiler  -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-CYGMING</name>" & ASCII.LF &
      "    <executable>gcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>gcc --version</external>" & ASCII.LF &
      "      <grep regexp=""\(GCC\) (\S+).*\(cygming special\)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C,C++,Fortran</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>gcc -mno-cygwin -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>GCC-MINGW32</name>" & ASCII.LF &
      "    <executable prefix=""1"">gcc(-sjlj|)</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>gcc${PREFIX} --version</external>" & ASCII.LF &
      "      <grep regexp=""\(GCC\) (\S+).*\(mingw32.*\)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C,C++,Fortran</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>gcc${PREFIX} -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Diab C Compiler -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>DIABC-PPC</name>" & ASCII.LF &
      "    <executable>dcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>dcc -V</external>" & ASCII.LF &
      "      <grep regexp="".*dcc(.exe)? Rel ([0-9.]*)"" group=""2""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>powerpc-elf</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- LynxWorks C compiler for LynxOS-178 -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>LYNXWORKS-C</name>" & ASCII.LF &
      "    <executable>gcc</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>gcc -v</external>" & ASCII.LF &
      "      <grep regexp=""^gcc version (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>gcc -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "      <must_match>.*xcoff-lynxos.*</must_match>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- LynxWorks C++ compiler for LynxOS-178 -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>LYNXWORKS-C++</name>" & ASCII.LF &
      "    <executable>c\+\+</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>c++ -v</external>" & ASCII.LF &
      "      <grep regexp=""^gcc version (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C++</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>c++ -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "      <must_match>.*xcoff-lynxos.*</must_match>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Clang C compiler -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>CLANG-C</name>" & ASCII.LF &
      "    <executable prefix=""1"">((.*-elf-|.*-linux-gnu-)?)clang</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>$EXEC -v</external>" & ASCII.LF &
      "      <grep regexp="".*(LLVM|clang) version ([0-9.]*)"" group=""2""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>$EXEC -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Clang++ C++ compiler -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>CLANG-C++</name>" & ASCII.LF &
      "    <executable prefix=""1"">((.*-elf-|.*-linux-gnu-)?)clang\+\+</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>$EXEC -v</external>" & ASCII.LF &
      "      <grep regexp="".*(LLVM|clang) version ([0-9.]*)"" group=""2""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>C++</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>$EXEC -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Clang assembler -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>CLANG-ASM</name>" & ASCII.LF &
      "    <executable prefix=""1"">((.*-elf-|.*-linux-gnu-)?)clang</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>$EXEC -v</external>" & ASCII.LF &
      "      <grep regexp="".*(LLVM|clang) version ([0-9.]*)"" group=""2""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>Asm,Asm_Cpp,Asm2</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>$EXEC -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Windres compiler -->" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>WINDRES</name>" & ASCII.LF &
      "    <executable prefix=""1"">(i686-.*-mingw32-|x86_64-.*-mingw32-)?windres</executable>" & ASCII.LF &
      "    <version>" & ASCII.LF &
      "      <external>${PREFIX}windres --version</external>" & ASCII.LF &
      "      <grep regexp=""^GNU windres \(GNU Binutils\) (\S+)"" group=""1""></grep>" & ASCII.LF &
      "    </version>" & ASCII.LF &
      "    <languages>WinRes</languages>" & ASCII.LF &
      "    <target>" & ASCII.LF &
      "      <external>${PREFIX}gcc -dumpmachine</external>" & ASCII.LF &
      "      <grep regexp=""[^\r\n]+""></grep>" & ASCII.LF &
      "    </target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("cpp.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "   <!--  This package provides the default standard options for a gcc" & ASCII.LF &
      "         C++ compiler -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "        <compiler name=""^G\+\+$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+_Pro$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^GCC-CYGMING$"" language=""C++"" />" & ASCII.LF &
      "       <compiler name=""^GCC-MINGW32$"" language=""C++"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver              (""C++"") use ""${PATH(c++)}${EXEC(c++)}"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS653-PPC$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS653-E500V2$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS5$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS6$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS6E500V2$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS6CERT$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS6CERTE500V2$"" language=""C++"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver              (""C++"") use ""${PATH(c++)}c++${PREFIX(c++)}"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^DIABC-PPC64$"" language=""C++"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver              (""C++"") use ""${PATH(c++)}dcc"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""CLANG-C\+\+"" language=""C++"" />" & ASCII.LF &
      "       <compiler name=""LLVM"" language=""C++"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver              (""C++"") use ""${PATH(c++)}${PREFIX(c++)}clang++"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "        <compiler name=""^G\+\+$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+_Pro$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS653-PPC$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS653-E500V2$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS6$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS6E500V2$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS6CERT$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS6CERTE500V2$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^GCC-CYGMING$"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""^GCC-MINGW32$"" language=""C++"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C++"") use" & ASCII.LF &
      "        (""-c"", ""-x"", ""c++"") &amp;" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C++"");" & ASCII.LF &
      "      for Dependency_Switches (""C++"") use (""-MMD"", ""-MF"", """");" & ASCII.LF &
      "      for Include_Switches_Via_Spec (""C++"") use (""cc1plus"", ""-I"");" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "      for Response_File_Format    (""C++"") use ""GCC_GNU"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "        <compiler name=""CLANG-C\+\+"" language=""C++"" />" & ASCII.LF &
      "        <compiler name=""LLVM"" language=""C++"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C++"") use" & ASCII.LF &
      "        (""-c"", ""-x"", ""c++"") &amp;" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C++"");" & ASCII.LF &
      "      for Dependency_Switches (""C++"") use (""-MMD"", ""-MF"", """");" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "      for Response_File_Format    (""C++"") use ""GCC_GNU"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^DIABC-PPC64$"" language=""C++"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C++"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-tPPCLP64FH:vxworks7""," & ASCII.LF &
      "               ""-c""," & ASCII.LF &
      "               ""-ffixed-r13""," & ASCII.LF &
      "               ""-Xclib-optim-off""," & ASCII.LF &
      "               ""-Xlocal-data-area-static-only""," & ASCII.LF &
      "               ""-Xc-new""," & ASCII.LF &
      "               ""-Xcode-absolute-far""," & ASCII.LF &
      "               ""-D_WRS_HARDWARE_FP""," & ASCII.LF &
      "               ""-DCPU=_VX_PPCE6500""," & ASCII.LF &
      "               ""-D_WRS_VX_SMP""," & ASCII.LF &
      "               ""-D_WRS_CONFIG_SMP"");" & ASCII.LF &
      "      for Dependency_Switches (""C"") use" & ASCII.LF &
      "         (""-Xmake-dependency=6"", ""-Xmake-dependency-savefile="");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- G++-WRS5 does not support -MF switch -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "        <compiler name=""^G\+\+-WRS5$"" language=""C++"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C++"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C++"") &amp;" & ASCII.LF &
      "        (""-c"", ""-x"", ""c++"");" & ASCII.LF &
      "      for Dependency_Switches (""C++"") use (""-Wp,-MMD,"");" & ASCII.LF &
      "      for Include_Path        (""C++"") use ""CPATH"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!--  Additional switches on some platforms -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+$"" language=""C++"" />" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" language=""C++"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <targets negate=""true"">" & ASCII.LF &
      "       <target name=""^.*LynxOS.*$"" />" & ASCII.LF &
      "       <target name=""^.*mingw.*$"" />" & ASCII.LF &
      "       <target name=""^.*cygwin.*$"" />" & ASCII.LF &
      "       <target name=""^.*tru64.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for PIC_Option      (""C++"") use (""-fPIC"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- in cygminw mode, make sure that the option -mno-cygwin is used -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-CYGMING$"" language=""C++"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "         Compiler'Leading_Required_Switches (""C++"") &amp; (""-mno-cygwin"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- this compiler is not compatible with GNAT's default zcx runtime -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers><compiler name=""^GNAT$"" runtime=""default"" /></compilers>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-CYGMING$"" language=""C++"" />" & ASCII.LF &
      "       <compiler name=""^GCC-CYGMING$"" language=""Fortran"" />" & ASCII.LF &
      "       <compiler name=""^GCC-MINGW32$"" language=""C++"" />" & ASCII.LF &
      "       <compiler name=""^GCC-MINGW32$"" language=""Fortran"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config></config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" runtime=""^rtp$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C++"") &amp; (""-mrtp"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("cross.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "   <!--  This package provides adjustments for cross compilers -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- Windows executables have extension .exe -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""dotnet"" />" & ASCII.LF &
      "       <target name=""mingw"" />" & ASCII.LF &
      "       <!-- LLVM version of the ""mingw"" triplet -->" & ASCII.LF &
      "       <target name=""windows"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Builder is" & ASCII.LF &
      "      for Executable_Suffix use "".exe"";" & ASCII.LF &
      "   end Builder;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- on some targets, executables do not have any extension -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^x86_64-elf$"" />" & ASCII.LF &
      "       <target name=""^i686-elf$"" />" & ASCII.LF &
      "       <target name=""^visium-elf$"" />" & ASCII.LF &
      "       <target name=""^r7-elf$"" />" & ASCII.LF &
      "       <target name=""^riscv(32|64)(-none|-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^m68020-elf$"" />" & ASCII.LF &
      "       <target name=""^morello(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^powerpc-elf$"" />" & ASCII.LF &
      "       <target name=""^powerpc-elf-lynxos5$"" />" & ASCII.LF &
      "       <target name=""^.*-elf-lynxos178e$"" />" & ASCII.LF &
      "       <target name=""^powerpc-xcoff-lynxos178$"" />" & ASCII.LF &
      "       <target name=""^powerpc-eabispe$"" />" & ASCII.LF &
      "       <target name=""^avr$"" />" & ASCII.LF &
      "       <target name=""^leon-elf$"" />" & ASCII.LF &
      "       <target name=""^leon3-elf$"" />" & ASCII.LF &
      "       <target name=""^aarch64(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^arm(-none)?-eabi$"" />" & ASCII.LF &
      "       <target name=""^.*-elinos-linux$"" />" & ASCII.LF &
      "       <target name=""^.*-fastos.*$"" />" & ASCII.LF &
      "       <target name=""^.*-generic-linux-gnu$"" />" & ASCII.LF &
      "       <target name=""^.*-pikeos.*$"" />" & ASCII.LF &
      "       <target name=""^.*-qnx[0-9]*$"" />" & ASCII.LF &
      "       <target name=""^.*-rtems.*$"" />" & ASCII.LF &
      "       <target name=""^arm-linux-androideabi"" />" & ASCII.LF &
      "       <target name=""^arm-linux-gnueabi"" />" & ASCII.LF &
      "       <target name=""^arm-linux-gnueabihf"" />" & ASCII.LF &
      "       <target name=""^aarch64-linux-android"" />" & ASCII.LF &
      "       <target name=""^aarch64-.*linux-gnu"" />" & ASCII.LF &
      "       <target name=""^e500v2-gnu-linux"" />" & ASCII.LF &
      "       <target name=""^.*-netbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*-dragonfly.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Builder is" & ASCII.LF &
      "      for Executable_Suffix use """";" & ASCII.LF &
      "   end Builder;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- Import PIKEOS_TARGET_FILES on PikeOS targets.  -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^.*-sysgo-pikeos.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   Pikeos_Target_Files := external (""PIKEOS_TARGET_FILES"");" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- Forbid mixing restricted rts with full rts.  -->" & ASCII.LF &
      "   <!-- Watch out: ""ravenscar-cert-rtp"" matches both ""rtp"" and ""cert"" -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers><compiler runtime=""rtp"" /></compilers>" & ASCII.LF &
      "     <compilers><compiler runtime=""kernel"" /></compilers>" & ASCII.LF &
      "     <config></config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers><compiler runtime=""cert"" /></compilers>" & ASCII.LF &
      "     <compilers><compiler runtime=""kernel"" /></compilers>" & ASCII.LF &
      "     <config></config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers><compiler runtime=""light"" /></compilers>" & ASCII.LF &
      "     <compilers><compiler runtime=""kernel"" /></compilers>" & ASCII.LF &
      "     <config></config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers><compiler runtime=""cert"" /></compilers>" & ASCII.LF &
      "     <compilers><compiler runtime=""^rtp$"" /></compilers>" & ASCII.LF &
      "     <config></config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers><compiler runtime=""light"" /></compilers>" & ASCII.LF &
      "     <compilers><compiler runtime=""^rtp$"" /></compilers>" & ASCII.LF &
      "     <config></config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers><compiler runtime=""rtp"" /></compilers>" & ASCII.LF &
      "     <compilers><compiler runtime=""^ravenscar-cert$"" /></compilers>" & ASCII.LF &
      "     <config></config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers><compiler runtime=""rtp"" /></compilers>" & ASCII.LF &
      "     <compilers><compiler runtime=""^light-tasking$"" /></compilers>" & ASCII.LF &
      "     <config></config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- mlongcall is passed by default in the case of GNAT." & ASCII.LF &
      "        Do the same thing for WRS compilers for consistency.  -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS5$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^powerpc-wrs-vxworks.*$"" />" & ASCII.LF &
      "       <target name=""^e500v2-wrs-vxworks.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-mlongcall"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS5$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^powerpc-wrs-vxworks.*$"" />" & ASCII.LF &
      "       <target name=""^e500v2-wrs-vxworks.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-mlongcall"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GNAT$""/>" & ASCII.LF &
      "       <compiler name=""^GCC$""/>" & ASCII.LF &
      "       <compiler name=""^GCC-SYSGO-X86$""/>" & ASCII.LF &
      "       <compiler name=""^GCC-SYSGO-PPC$""/>" & ASCII.LF &
      "       <compiler name=""^G\+\+$""/>" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^.*-sysgo-pikeos.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-fno-builtin"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Required_Switches use" & ASCII.LF &
      "        Linker'Required_Switches" & ASCII.LF &
      "        &amp; (""-L"" &amp; Pikeos_Target_Files &amp; ""/scripts""," & ASCII.LF &
      "               ""-L"" &amp; Pikeos_Target_Files &amp; ""/lib"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- require specification of run-time for VxWorks 5 using GNAT for C -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC$"" runtime=""^soft-float$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS5$"" runtime=""^soft-float$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^.*-wrs-vxworks$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-I"" &amp; Wind_Base &amp; ""/target/h""," & ASCII.LF &
      "               ""-msoft-float"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- require specification of run-time for VxWorks 5 using GNAT for C -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC$"" runtime=""^default$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS5$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS5$"" runtime=""^default$"" />" & ASCII.LF &
      "      </compilers>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^.*-wrs-vxworks$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-I"" &amp; Wind_Base &amp; ""/target/h"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!--  Set prefix of gnatbind -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GNAT$"" />" & ASCII.LF &
      "       <compiler name=""^GNAT_DOTNET$"" />" & ASCII.LF &
      "       <compiler name=""^JGNAT$"" />" & ASCII.LF &
      "       <compiler name=""^GNAT_C$"" />" & ASCII.LF &
      "       <compiler name=""^GNAT_CODEPEER$"" />" & ASCII.LF &
      "       <compiler name=""^GNAT_LLVM$"" />" & ASCII.LF &
      "       <compiler name=""^GNAT_LLVM_NATIVE$"" />" & ASCII.LF &
      "       <compiler name=""^GNAT_CCG$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Binder is" & ASCII.LF &
      "      for Required_Switches (""Ada"") use" & ASCII.LF &
      "          Binder'Required_Switches (""Ada"") &amp;" & ASCII.LF &
      "          (""gnatbind_prefix=${PREFIX(ada)}"");" & ASCII.LF &
      "   end Binder;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!--  Set prefix of gnatbind for CUDA -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GNAT_CUDA$"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Binder is" & ASCII.LF &
      "      for Required_Switches (""Ada"") use" & ASCII.LF &
      "          Binder'Required_Switches (""Ada"") &amp;" & ASCII.LF &
      "          (""gnatbind_prefix=llvm-"");" & ASCII.LF &
      "   end Binder;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Set mcmodel large for x86_64-vx7r2 for kernel-large rts -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "         <compiler runtime=""kernel-large"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^x86_64-wrs-vxworks7r2.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "        package Compiler is" & ASCII.LF &
      "           for Required_Switches (""Ada"")  use" & ASCII.LF &
      "               Compiler'Required_Switches  (""Ada"") &amp;" & ASCII.LF &
      "               (""-mcmodel=large"");" & ASCII.LF &
      "           for Required_Switches (""C"")  use" & ASCII.LF &
      "               Compiler'Required_Switches  (""C"") &amp;" & ASCII.LF &
      "               (""-mcmodel=large"");" & ASCII.LF &
      "           for Required_Switches (""C++"")  use" & ASCII.LF &
      "               Compiler'Required_Switches  (""C++"") &amp;" & ASCII.LF &
      "               (""-mcmodel=large"");" & ASCII.LF &
      "           for Required_Switches (""Asm"")  use" & ASCII.LF &
      "               Compiler'Required_Switches  (""Asm"") &amp;" & ASCII.LF &
      "               (""-mcmodel=large"");" & ASCII.LF &
      "           for Required_Switches (""Asm2"")  use" & ASCII.LF &
      "               Compiler'Required_Switches  (""Asm2"") &amp;" & ASCII.LF &
      "               (""-mcmodel=large"");" & ASCII.LF &
      "           for Required_Switches (""Asm_Cpp"")  use" & ASCII.LF &
      "               Compiler'Required_Switches  (""Asm_Cpp"") &amp;" & ASCII.LF &
      "               (""-mcmodel=large"");" & ASCII.LF &
      "        end Compiler;" & ASCII.LF &
      "        package Linker is" & ASCII.LF &
      "           for Required_Switches use" & ASCII.LF &
      "               Linker'Required_Switches &amp;" & ASCII.LF &
      "               (""-mcmodel=large"");" & ASCII.LF &
      "        end Linker;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Forward the sysroot from ENV_PREFIX to Clang  -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "      <compiler name=""^CLANG-.*$"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-unknown-linux-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <host name=""^aarch64-linux-gnu$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   Env_Prefix := External (""ENV_PREFIX"", """");" & ASCII.LF &
      "" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      case Env_Prefix is" & ASCII.LF &
      "         when """" =>" & ASCII.LF &
      "            null;" & ASCII.LF &
      "         when others =>" & ASCII.LF &
      "            for Required_Switches (""C"") use" & ASCII.LF &
      "              Compiler'Required_Switches (""C"") &amp;" & ASCII.LF &
      "              (""--sysroot="" &amp; Env_Prefix);" & ASCII.LF &
      "            for Required_Switches (""C++"") use" & ASCII.LF &
      "              Compiler'Required_Switches (""C++"") &amp;" & ASCII.LF &
      "              (""--sysroot="" &amp; Env_Prefix);" & ASCII.LF &
      "            for Required_Switches (""Asm"") use" & ASCII.LF &
      "              Compiler'Required_Switches (""Asm"") &amp;" & ASCII.LF &
      "              (""--sysroot="" &amp; Env_Prefix);" & ASCII.LF &
      "            for Required_Switches (""Asm2"") use" & ASCII.LF &
      "              Compiler'Required_Switches (""Asm2"") &amp;" & ASCII.LF &
      "              (""--sysroot="" &amp; Env_Prefix);" & ASCII.LF &
      "            for Required_Switches (""Asm_Cpp"") use" & ASCII.LF &
      "              Compiler'Required_Switches (""Asm_Cpp"") &amp;" & ASCII.LF &
      "              (""--sysroot="" &amp; Env_Prefix);" & ASCII.LF &
      "      end case;" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("e500v2-vx6.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx6.ent SYSTEM ""vx6.ent""> %vx6.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'e500v2-wrs-vxworks'>" & ASCII.LF &
      "<!ENTITY this_gnu_wrs_suffix 'ppc'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <!--  ??? Eventually GCC_Pro will be replaced by a e500v2-vx6-specific" & ASCII.LF &
      "       definition:" & ASCII.LF &
      "       <compiler name=""^E500V2-VX6-GCC-ADACORE$"" />" & ASCII.LF &
      "       -->" & ASCII.LF &
      "       <compiler name=""^E500V2-VX6-GCC-WRS$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^E500V2-VX6-G\+\+-WRS$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^E500V2-VX6-G\+\+-WRS$"" />" & ASCII.LF &
      "       <compiler name=""^E500V2-VX6-GCC-WRS$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6CERTE500V2$"" />" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6CERTE500V2$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^E500V2-VX6-G\+\+-WRS$"" />" & ASCII.LF &
      "       <compiler name=""^E500V2-VX6-GCC-WRS$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6CERTE500V2$"" />" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6CERTE500V2$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x40000000'>" & ASCII.LF &
      "<!-- For vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_cpu_subdir 'ppc/PPC32/e500v2common'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   for Archive_Builder  use (""e500v2-wrs-vxworks-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""e500v2-wrs-vxworks-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "  &configurations_vx6;" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- e500v2-specific part -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "     &if_these_wrs_compilers;" & ASCII.LF &
      "     &if_this_target;" & ASCII.LF &
      "     <!-- vx6 and vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "     &config_e500v2_cflags;" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("e500v2-vx653.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx653.ent SYSTEM ""vx653.ent""> %vx653.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'e500v2-wrs-vxworksae'>" & ASCII.LF &
      "<!ENTITY this_gnu_wrs_suffix 'ppc'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <!--  ??? Eventually GCC_Pro will be replaced by a e500v2-vx6-specific" & ASCII.LF &
      "       definition:" & ASCII.LF &
      "       <compiler name=""^E500V2-VX653-GCC-ADACORE$"" />" & ASCII.LF &
      "       -->" & ASCII.LF &
      "       <compiler name=""^GCC-WRS653-E500V2$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS653-E500V2$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS653-E500V2$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS653-E500V2$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS653-E500V2$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS653-E500V2$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx653;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("e500v2-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'e500v2-wrs-vxworks7'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7E500V2$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7E500V2$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x80000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("e500v2-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'e500v2-wrs-vxworks7r2'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7R2E500V2$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS7R2E500V2$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7R2E500V2$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x80000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("fallback_targets.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "  <fallback_targets>" & ASCII.LF &
      "    <target>x86-windows</target>" & ASCII.LF &
      "    <target>x86_64-windows</target>" & ASCII.LF &
      "  </fallback_targets>" & ASCII.LF &
      "" & ASCII.LF &
      "  <fallback_targets>" & ASCII.LF &
      "    <target>x86-linux</target>" & ASCII.LF &
      "    <target>x86_64-linux</target>" & ASCII.LF &
      "  </fallback_targets>" & ASCII.LF &
      "" & ASCII.LF &
      "  <fallback_targets>" & ASCII.LF &
      "    <target>x86_64-darwin</target>" & ASCII.LF &
      "    <target>aarch64-darwin</target>" & ASCII.LF &
      "  </fallback_targets>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("fortran.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "   <!--  This package provides the default standard options for a g77" & ASCII.LF &
      "         Fortran compiler -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^G77$"" language=""Fortran"" />" & ASCII.LF &
      "       <compiler name=""^GCC-CYGMING$"" language=""Fortran"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver            (""Fortran"") use ""${PATH(fortran)}g77"";" & ASCII.LF &
      "      for Leading_Required_Switches (""Fortran"") use" & ASCII.LF &
      "         Compiler'Leading_Required_Switches (""Fortran"") &amp;" & ASCII.LF &
      "         (""-c"", ""-fno-underscoring"");" & ASCII.LF &
      "      for Include_Switches  (""Fortran"") use (""-I"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- in cygminw mode, make sure that the option -mno-cygwin is used -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-CYGMING$"" language=""Fortran"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""Fortran"") use" & ASCII.LF &
      "      Compiler'Leading_Required_Switches (""Fortran"") &amp; (""-mno-cygwin"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- Configuration for GFortran: the GCC Fortran 95 compiler -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^GFORTRAN$"" language=""Fortran"" />" & ASCII.LF &
      "       <compiler name=""^GCC-MINGW32$"" language=""Fortran"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver            (""Fortran"") use ""${PATH(fortran)}${EXEC(fortran)}"";" & ASCII.LF &
      "      for Leading_Required_Switches (""Fortran"") use" & ASCII.LF &
      "         Compiler'Leading_Required_Switches (""Fortran"") &amp;" & ASCII.LF &
      "         (""-c"", ""-fno-underscoring"");" & ASCII.LF &
      "      for Include_Switches  (""Fortran"") use (""-I"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!--  Additional switches needed on some platforms -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler name=""^G77$"" language=""Fortran"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <targets negate=""true"">" & ASCII.LF &
      "       <target name=""^.*LynxOS.*$"" />" & ASCII.LF &
      "       <target name=""^.*pentium-mingw.*$"" />" & ASCII.LF &
      "       <target name=""^.*cygwin.*$"" />" & ASCII.LF &
      "       <target name=""^.*dec-osf.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for PIC_Option      (""Fortran"") use (""-fPIC"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("gnat.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "  <!ENTITY filter_gnat '<compilers><compiler name=""^GNAT$"" /><compiler name=""^GNAT_DOTNET$"" /><compiler name=""^JGNAT$"" /><compiler name=""^GNAT_CODEPEER$"" /><compiler name=""^GNAT_C$"" /><compiler name=""^GNAT_CCG$"" /><compiler name=""^GNAT_CUDA$"" /><compiler name=""^GNAT_LLVM$"" /><compiler name=""^GNAT_LLVM_NATIVE$"" /></compilers>'>" & ASCII.LF &
      "] >" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- GNAT -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   &filter_gnat;" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver                   (""Ada"") use ""${PATH(ada)}${PREFIX(ada)}gcc"";" & ASCII.LF &
      "      for Language_Kind            (""Ada"") use ""unit_based"";" & ASCII.LF &
      "      for Dependency_Kind          (""Ada"") use ""ALI_File"";" & ASCII.LF &
      "      for Leading_Required_Switches        (""Ada"") use" & ASCII.LF &
      "      (""-c"", ""-x"", ""ada"", ""-gnatA"")" & ASCII.LF &
      "             &amp; Compiler'Leading_Required_Switches (""Ada"");" & ASCII.LF &
      "      for Mapping_File_Switches    (""Ada"") use (""-gnatem="");" & ASCII.LF &
      "      for Mapping_Spec_Suffix      (""Ada"") use ""%s"";" & ASCII.LF &
      "      for Mapping_Body_Suffix      (""Ada"") use ""%b"";" & ASCII.LF &
      "      for Config_File_Switches     (""Ada"") use (""-gnatec="");" & ASCII.LF &
      "      for Include_Path_File     (""Ada"") use ""ADA_PRJ_INCLUDE_FILE"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Binder is" & ASCII.LF &
      "      for Objects_Path_File     (""Ada"") use ""ADA_PRJ_OBJECTS_FILE"";" & ASCII.LF &
      "      for Driver         (""Ada"") use" & ASCII.LF &
      "          ""${GPRCONFIG_PREFIX}lib/gprbuild/gprbind"";" & ASCII.LF &
      "   end Binder;" & ASCII.LF &
      "" & ASCII.LF &
      "   for Toolchain_Version (""Ada"") use ""GNAT ${VERSION(ada)}"";" & ASCII.LF &
      "   for Runtime_Dir       (""Ada"") use ""${RUNTIME_DIR(ada)}"";" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- CUDA -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "    <compiler name=""^GNAT_CUDA$""/>" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Object_File_Suffix       (""Ada"") use "".cubin"";" & ASCII.LF &
      "      for Driver                   (""Ada"") use ""${PATH(ada)}cuda-gcc"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- DOTNET -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "    <compiler name=""^GNAT_DOTNET$""/>" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Object_File_Suffix       (""Ada"") use "".il"";" & ASCII.LF &
      "      for Driver                   (""Ada"") use ""${PATH(ada)}${PREFIX(ada)}gnatcompile"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- JGNAT -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "    <compiler name=""^JGNAT$""/>" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Object_File_Suffix       (""Ada"") use "".class"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- C Target common settings -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler name=""^GNAT_C$""/>" & ASCII.LF &
      "     <compiler name=""^GNAT_CCG$""/>" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Object_File_Suffix        (""Ada"") use "".c"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   package Clean is" & ASCII.LF &
      "      for Object_Artifact_Extensions (""Ada"") use ("".h"");" & ASCII.LF &
      "   end Clean;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Old C Target using -gnatceg -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler name=""^GNAT_C$""/>" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Ada"") &amp; (""-gnatceg"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Add -G to binder switches for C/CCG targets starting with version 20 -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler name=""^GNAT_C$""/>" & ASCII.LF &
      "     <compiler name=""^GNAT_CCG$""/>" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <compilers negate=""true"">" & ASCII.LF &
      "     <compiler version=""18"" />" & ASCII.LF &
      "     <compiler version=""19"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Binder is" & ASCII.LF &
      "      for Required_Switches (""Ada"") use" & ASCII.LF &
      "        Binder'Required_Switches (""Ada"") &amp; (""-G"");" & ASCII.LF &
      "   end Binder;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Add -m32 on linux and windows 64bits hosts for C target -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler name=""^GNAT_C$""/>" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <hosts>" & ASCII.LF &
      "     <host name=""^x86_64-.*linux.*$"" />" & ASCII.LF &
      "     <host name=""^x86_64-.*mingw.*$"" />" & ASCII.LF &
      "   </hosts>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Ada"") &amp; (""-m32"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   &filter_gnat;" & ASCII.LF &
      "   <compilers negate=""true"">" & ASCII.LF &
      "     <compiler version=""3.16"" />" & ASCII.LF &
      "     <compiler version=""5.00"" />" & ASCII.LF &
      "     <compiler version=""5.01"" />" & ASCII.LF &
      "     <compiler version=""5.02"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Multi_Unit_Switches (""Ada"") use (""-gnateI"");" & ASCII.LF &
      "      for Multi_Unit_Object_Separator (""Ada"") use ""~"";" & ASCII.LF &
      "      for Config_Body_File_Name (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project (%u, Body_File_Name => """"%f"""");"";" & ASCII.LF &
      "      for Config_Spec_File_Name (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project (%u, Spec_File_Name => """"%f"""");"";" & ASCII.LF &
      "      for Config_Body_File_Name_Index (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project (%u, Body_File_Name => """"%f"""", Index => %i);"";" & ASCII.LF &
      "      for Config_Spec_File_Name_Index (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project (%u, Spec_File_Name => """"%f"""", Index => %i);"";" & ASCII.LF &
      "      for Config_Body_File_Name_Pattern (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project "" &amp;" & ASCII.LF &
      "           ""  (Body_File_Name  => """"*%b"""","" &amp;" & ASCII.LF &
      "           ""   Casing          => %c,"" &amp;" & ASCII.LF &
      "           ""   Dot_Replacement => """"%d"""");"";" & ASCII.LF &
      "      for Config_Spec_File_Name_Pattern (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project "" &amp;" & ASCII.LF &
      "           ""  (Spec_File_Name  => """"*%s"""","" &amp;" & ASCII.LF &
      "           ""   Casing          => %c,"" &amp;" & ASCII.LF &
      "           ""   Dot_Replacement => """"%d"""");"";" & ASCII.LF &
      "      for Config_File_Unique    (""Ada"") use ""False"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   &filter_gnat;" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler version=""3.16"" />" & ASCII.LF &
      "     <compiler version=""5.00"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Config_Body_File_Name    (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name (%u, Body_File_Name => """"%f"""");"";" & ASCII.LF &
      "      for Config_Spec_File_Name    (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name (%u, Spec_File_Name => """"%f"""");"";" & ASCII.LF &
      "      for Config_Body_File_Name_Pattern (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name "" &amp;" & ASCII.LF &
      "           ""  (Body_File_Name  => """"*%b"""","" &amp;" & ASCII.LF &
      "           ""   Casing          => %c,"" &amp;" & ASCII.LF &
      "           ""   Dot_Replacement => """"%d"""");"";" & ASCII.LF &
      "      for Config_Spec_File_Name_Pattern (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name "" &amp;" & ASCII.LF &
      "           ""  (Spec_File_Name  => """"*%s"""","" &amp;" & ASCII.LF &
      "           ""   Casing          => %c,"" &amp;" & ASCII.LF &
      "           ""   Dot_Replacement => """"%d"""");"";" & ASCII.LF &
      "      for Config_File_Unique    (""Ada"") use ""True"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   &filter_gnat;" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler version=""5.01"" />" & ASCII.LF &
      "     <compiler version=""5.02"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Config_Body_File_Name    (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project (%u, Body_File_Name => """"%f"""");"";" & ASCII.LF &
      "      for Config_Spec_File_Name    (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project (%u, Spec_File_Name => """"%f"""");"";" & ASCII.LF &
      "      for Config_Body_File_Name_Pattern (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project "" &amp;" & ASCII.LF &
      "           ""  (Body_File_Name  => """"*%b"""","" &amp;" & ASCII.LF &
      "           ""   Casing          => %c,"" &amp;" & ASCII.LF &
      "           ""   Dot_Replacement => """"%d"""");"";" & ASCII.LF &
      "      for Config_Spec_File_Name_Pattern (""Ada"") use" & ASCII.LF &
      "           ""pragma Source_File_Name_Project "" &amp;" & ASCII.LF &
      "           ""  (Spec_File_Name  => """"*%s"""","" &amp;" & ASCII.LF &
      "           ""   Casing          => %c,"" &amp;" & ASCII.LF &
      "           ""   Dot_Replacement => """"%d"""");"";" & ASCII.LF &
      "      for Config_File_Unique    (""Ada"") use ""False"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Whether -fPIC is needed -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   &filter_gnat;" & ASCII.LF &
      "   <targets negate=""true"">" & ASCII.LF &
      "      <target name=""^.*lynxos.*$"" />" & ASCII.LF &
      "      <target name=""^.*mingw.*$"" />" & ASCII.LF &
      "      <target name=""^.*dec-osf.*$"" />" & ASCII.LF &
      "      <target name=""^.*vms.*$"" />" & ASCII.LF &
      "      <target name=""^.*dotnet.*$"" />" & ASCII.LF &
      "      <target name=""^.*jvm.*$"" />" & ASCII.LF &
      "   </targets>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for PIC_Option      (""Ada"") use (""-fPIC"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Whether encapsulated library is supported -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   &filter_gnat;" & ASCII.LF &
      "   <targets>" & ASCII.LF &
      "      <target name=""^.*mingw.*$"" />" & ASCII.LF &
      "      <target name=""^.*linux.*$"" />" & ASCII.LF &
      "      <target name=""^.*sunos.*$"" />" & ASCII.LF &
      "      <target name=""^sparc-.*solaris.*$""/>" & ASCII.LF &
      "      <target name=""^i.86-.*-solaris.*$""/>" & ASCII.LF &
      "      <target name=""^i.86-.*darwin.*$"" />" & ASCII.LF &
      "      <target name=""^powerpc-.*darwin.*$"" />" & ASCII.LF &
      "      <target name=""^x86_64-.*darwin.*$"" />" & ASCII.LF &
      "      <target name=""^.*android.*$"" />" & ASCII.LF &
      "      <target name=""^.*-fastos.*$"" />" & ASCII.LF &
      "      <target name=""^.*-qnx[0-9]*$"" />" & ASCII.LF &
      "      <target name=""^.*freebsd.*$"" />" & ASCII.LF &
      "      <target name=""^.*netbsd.*$"" />" & ASCII.LF &
      "      <target name=""^.*dragonfly.*$"" />" & ASCII.LF &
      "      <target name=""^.*cuda.*$"" />" & ASCII.LF &
      "   </targets>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "      for Library_Encapsulated_Supported use ""true"";" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- add switch __RTS= to the compiler and binder for GNAT, if not default -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler name=""^GNAT$"" />" & ASCII.LF &
      "     <compiler name=""^GNAT_CODEPEER$"" />" & ASCII.LF &
      "     <compiler name=""^GNAT_LLVM$"" />" & ASCII.LF &
      "     <compiler name=""^GNAT_LLVM_NATIVE$"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <compilers negate=""true"">" & ASCII.LF &
      "     <compiler runtime=""default"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Ada"") &amp; (""--RTS=${RUNTIME_DIR(ada)}"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Binder is" & ASCII.LF &
      "      for Required_Switches (""Ada"") use" & ASCII.LF &
      "        Binder'Required_Switches (""Ada"") &amp; (""--RTS=${RUNTIME_DIR(ada)}"");" & ASCII.LF &
      "   end Binder;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Always add switch __RTS= to the compiler and binder for GNAT CCG and CUDA -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler name=""^GNAT_CCG$"" />" & ASCII.LF &
      "     <compiler name=""^GNAT_CUDA$"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Ada"") &amp; (""--RTS=${RUNTIME_DIR(ada)}"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Binder is" & ASCII.LF &
      "      for Required_Switches (""Ada"") use" & ASCII.LF &
      "        Binder'Required_Switches (""Ada"") &amp; (""--RTS=${RUNTIME_DIR(ada)}"");" & ASCII.LF &
      "   end Binder;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler name=""^GNAT_DOTNET$"" runtime=""compact"" />" & ASCII.LF &
      "     <compiler name=""^GNAT_DOTNET$"" runtime=""silverlight"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Ada"") &amp; (""--RTS=${RUNTIME(ada)}/.."");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Binder is" & ASCII.LF &
      "      for Required_Switches (""Ada"") use" & ASCII.LF &
      "        Binder'Required_Switches (""Ada"") &amp; (""--RTS=${RUNTIME(ada)}/.."");" & ASCII.LF &
      "   end Binder;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- add compiler option -msoft-float when the runtime is soft-float -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler name=""^GNAT$"" runtime=""soft-float"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Ada"") &amp; (""-msoft-float"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- When using the (Ada) ios-simulator runtime, always compile all files" & ASCII.LF &
      "       with -mios-simulator-version-min (including non-Ada files).  -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" runtime=""ios-simulator"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches (""Ada"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Ada"")" & ASCII.LF &
      "        &amp; (""-mios-simulator-version-min=8.0"");" & ASCII.LF &
      "      for Leading_Required_Switches (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-mios-simulator-version-min=8.0"");" & ASCII.LF &
      "      for Leading_Required_Switches (""C++"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-mios-simulator-version-min=8.0"");" & ASCII.LF &
      "      for Leading_Required_Switches (""Asm"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Asm"")" & ASCII.LF &
      "        &amp; (""-mios-simulator-version-min=8.0"");" & ASCII.LF &
      "      for Leading_Required_Switches (""Asm2"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Asm2"")" & ASCII.LF &
      "        &amp; (""-mios-simulator-version-min=8.0"");" & ASCII.LF &
      "      for Leading_Required_Switches (""Asm_Cpp"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Asm_Cpp"")" & ASCII.LF &
      "        &amp; (""-mios-simulator-version-min=8.0"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <!-- GNAT including 7.2.2 and older does not support dependence on" & ASCII.LF &
      "        configuration pragma files -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "   &filter_gnat;" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "     <compiler language=""Ada"" version=""^7\.[012]\.*"" />" & ASCII.LF &
      "     <compiler language=""Ada"" version=""^[3456]\.*"" />" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "     package Compiler is" & ASCII.LF &
      "        for Config_File_Dependency_Support (""Ada"") use ""False"";" & ASCII.LF &
      "     end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("linker.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "   <!ENTITY gnat_pre_6.4" & ASCII.LF &
      "     '<compiler language=""Ada"" version=""3.16"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""5.00"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""5.01"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""5.02"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""5.03"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""5.04"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""6.0"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""6.1"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""6.2"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""6.3"" />" & ASCII.LF &
      "      <compiler language=""Ada"" version=""6.4"" />'" & ASCII.LF &
      "   >" & ASCII.LF &
      "]>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  This configuration shows how to link a multi language" & ASCII.LF &
      "        application with GNAT and either GCC or toolchains" & ASCII.LF &
      "        derived from gcc -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Export File / Object Lister  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^i686-pc-mingw32$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <host name=""^i686-.*-mingw32$"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""i686-pc-mingw32-nm"", ""-g"", ""--no-demangle"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRB] _(.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""DEF"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^x86_64-pc-mingw32$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <host name=""^i686-.*-mingw32$"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""x86_64-pc-mingw32-nm"", ""-g"", ""--no-demangle"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRB] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^x86_64-w64-mingw32$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <host name=""^i686-.*-mingw32$"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""x86_64-w64-mingw32-nm"", ""-g"", ""--no-demangle"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRB] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^i686-pc-mingw32$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <host name=""^i686-.*-mingw32$"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""nm"", ""-g"", ""--no-demangle"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRB] _(.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""DEF"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "      <!-- LLVM version of the mingw32 triplet -->" & ASCII.LF &
      "      <target name=""^x86_64-.*-windows-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <host name=""^i686-.*-mingw32$"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""nm"", ""-g"", ""--no-demangle"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRB] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^i686.*-linux.*$"" />" & ASCII.LF &
      "      <target name=""^x86_64.*-linux.*"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <host name=""^x86_64.*-linux.*"" />" & ASCII.LF &
      "      <host name=""^i686.*-linux.*$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRB] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""Ada"" runtime=""ios-simulator"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^i.86-.*darwin.*$"" />" & ASCII.LF &
      "       <target name=""^x86_64-.*darwin.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDS] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""FLAT"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,-exported_symbols_list,"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <!-- aarch64-linux - native compiler. -->" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-linux-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <host name=""^aarch64-linux-gnu$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRBSG] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <!-- aarch64-linux - cross compiler. -->" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-.*linux-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <host name=""^aarch64-linux-gnu$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""aarch64-linux-gnu-nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRBSG] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm-linux-gnueabi$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""arm-linux-gnueabi-nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDSR] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm-linux-gnueabihf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""arm-linux-gnueabihf-nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRBSG] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-.*linux.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <!-- Cross compiler case -->" & ASCII.LF &
      "      <host name=""^(ppc|powerpc)-.*linux.*$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""powerpc-generic-linux-gnu-nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRBSG] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-.*linux.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <!-- Native compiler case -->" & ASCII.LF &
      "      <host name=""^(ppc|powerpc)-.*linux.*$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRBSG] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc64-generic-linux-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""powerpc64-generic-linux-gnu-nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRBSG] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^e500v2-gnu-linux$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""e500v2-gnu-linux-nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRBSG] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-nto-qnx$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""aarch64-nto-qnx-nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRBS] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-thales-fastos$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""aarch64-thales-fastos-nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRBS] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm-nto-qnx$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Object_Lister use (""arm-nto-qnx-nm"", ""-g"");" & ASCII.LF &
      "   for Object_Lister_Matcher use "" [TDRBS] (.*)"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Export_File_Format use ""GNU"";" & ASCII.LF &
      "      for Export_File_Switch use ""-Wl,--version-script="";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Archiver.  -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^x86_64-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""x86_64-elf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""x86_64-elf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^i686-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""i686-elf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""i686-elf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^visium-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""visium-elf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""visium-elf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^cuda$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""cuda-gcc"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use ("""");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- This is the Ada version of this rule using ${PREFIX(Ada)} -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "      <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm(-none)?-eabi$"" />" & ASCII.LF &
      "      <target name=""^r7-elf$"" />" & ASCII.LF &
      "      <target name=""^riscv(32|64)(-none|-unknown)?-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""${PREFIX(Ada)}ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""${PREFIX(Ada)}ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- This is the C version of this rule using ${PREFIX(C)} -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "      <compiler language=""c"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm(-none)?-eabi$"" />" & ASCII.LF &
      "      <target name=""^r7-elf$"" />" & ASCII.LF &
      "      <target name=""^riscv(32|64)(-none|-unknown)?-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""${PREFIX(c)}ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""${PREFIX(c)}ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- This is the C++ version of this rule using ${PREFIX(c++)} -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "      <compiler language=""c++"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm(-none)?-eabi$"" />" & ASCII.LF &
      "      <target name=""^r7-elf$"" />" & ASCII.LF &
      "      <target name=""^riscv(32|64)(-none|-unknown)?-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""${PREFIX(c++)}ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""${PREFIX(c++)}ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^m68020-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""m68020-elf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""m68020-elf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^morello(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""morello-elf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""morello-elf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""powerpc-elf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""powerpc-elf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-elf-lynxos$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""ar"", ""crs"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-xcoff-lynxos178$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""powerpc-xcoff-lynxos178-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""powerpc-xcoff-lynxos178-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-eabispe$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""powerpc-eabispe-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""powerpc-eabispe-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^i686-pc-mingw32$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <host name=""^i686-.*-mingw32$"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""i686-pc-mingw32-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""i686-pc-mingw32-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^i686-pc-mingw32$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <host name=""^i686-.*-mingw32$"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^x86_64-pc-mingw32$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <host name=""^i686-.*-mingw32$"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""x86_64-pc-mingw32-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""x86_64-pc-mingw32-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^x86_64-w64-mingw32$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <host name=""^i686-.*-mingw32$"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""x86_64-w64-mingw32-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""x86_64-w64-mingw32-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "      <!-- LLVM version of the mingw32 triplet -->" & ASCII.LF &
      "      <target name=""^x86_64-.*-windows-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <host name=""^i686-.*-mingw32$"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*-mingw32$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-generic-linux-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <!-- Cross compiler case -->" & ASCII.LF &
      "      <host name=""^(ppc|powerpc)-.*linux.*$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""powerpc-generic-linux-gnu-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""powerpc-generic-linux-gnu-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-generic-linux-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <!-- Native compiler case -->" & ASCII.LF &
      "      <host name=""^(ppc|powerpc)-.*linux.*$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc64-generic-linux-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""powerpc64-generic-linux-gnu-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""powerpc64-generic-linux-gnu-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm-linux-androideabi$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""arm-linux-androideabi-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""arm-linux-androideabi-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm-linux-gnueabi$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""arm-linux-gnueabi-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""arm-linux-gnueabi-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm-linux-gnueabihf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""arm-linux-gnueabihf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""arm-linux-gnueabihf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <!-- aarch64-android - cross compiler. -->" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-linux-android$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""aarch64-linux-android-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""aarch64-linux-android-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <!-- aarch64-linux - native compiler. -->" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-linux-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <host name=""^aarch64-linux-gnu$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <!-- aarch64-linux - cross compiler. -->" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-.*linux-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <host name=""^aarch64-linux-gnu$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""aarch64-linux-gnu-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""aarch64-linux-gnu-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-thales-fastos$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""aarch64-thales-fastos-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""aarch64-thales-fastos-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-nto-qnx$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""aarch64-nto-qnx-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""aarch64-nto-qnx-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm-nto-qnx$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""arm-nto-qnx-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""arm-nto-qnx-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-rtems.*$""/>" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""aarch64-rtems6-gcc-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""aarch64-rtems6-gcc-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^e500v2-gnu-linux$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""e500v2-gnu-linux-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""e500v2-gnu-linux-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^erc32-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""erc32-elf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""erc32-elf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^leon-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""leon-elf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""leon-elf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^leon3-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""leon3-elf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""leon3-elf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""aarch64-elf-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""aarch64-elf-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^avr$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""avr-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""avr-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^aarch64-sysgo-pikeos5$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""aarch64-sysgo-pikeos5-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""aarch64-sysgo-pikeos5-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm-sysgo-pikeos$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""arm-sysgo-pikeos-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""arm-sysgo-pikeos-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm-sysgo-pikeos4$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""arm-sysgo-pikeos4-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""arm-sysgo-pikeos4-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^arm-sysgo-pikeos5$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""arm-sysgo-pikeos5-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""arm-sysgo-pikeos5-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^i586-sysgo-pikeos$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""i586-sysgo-pikeos-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""i586-sysgo-pikeos-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-sysgo-pikeos$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""powerpc-sysgo-pikeos-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""powerpc-sysgo-pikeos-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-sysgo-pikeos5$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""powerpc-sysgo-pikeos5-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""powerpc-sysgo-pikeos5-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Do not run ranlib on AIX -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^.*aix.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Max_Command_Line_Length use ""15000"";" & ASCII.LF &
      "      for Response_File_Format    use ""object_list"";" & ASCII.LF &
      "      for Response_File_Switches  use (""-Wl,-f,"");" & ASCII.LF &
      "      for Map_File_Option         use ""-Wl,-Map,"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Do not run ranlib on IA64 HPUX -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name="".*ia64.*hpux.*"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Provide a dummy Archive_Builder and no ranlib when generating C -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^c$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""c-gcc"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets negate=""true"">" & ASCII.LF &
      "      <target name=""^x86_64-elf$""/>" & ASCII.LF &
      "      <target name=""^i686-elf$""/>" & ASCII.LF &
      "      <target name=""^.*-wrs-vxworks.*$"" />" & ASCII.LF &
      "      <target name=""^visium-elf$""/>" & ASCII.LF &
      "      <target name=""^r7-elf$"" />" & ASCII.LF &
      "      <target name=""^riscv(32|64)(-none|-unknown)?-elf$"" />" & ASCII.LF &
      "      <target name=""^m68020-elf$""/>" & ASCII.LF &
      "      <target name=""^morello(-unknown-unknown)?-elf$""/>" & ASCII.LF &
      "      <target name=""^powerpc-elf$""/>" & ASCII.LF &
      "      <target name=""^powerpc-elf-lynxos$"" />" & ASCII.LF &
      "      <target name=""^powerpc-xcoff-lynxos178$"" />" & ASCII.LF &
      "      <target name=""^powerpc-eabispe$""/>" & ASCII.LF &
      "      <target name=""^avr$""/>" & ASCII.LF &
      "      <target name=""^erc32-elf$""/>" & ASCII.LF &
      "      <target name=""^leon-elf$""/>" & ASCII.LF &
      "      <target name=""^leon3-elf$""/>" & ASCII.LF &
      "      <target name=""^arm(-none)?-eabi$""/>" & ASCII.LF &
      "      <target name=""^aarch64(-unknown-unknown)?-elf$""/>" & ASCII.LF &
      "      <target name=""^.*aix.*$"" />" & ASCII.LF &
      "      <target name=""^.*ia64.*hpux.*$"" />" & ASCII.LF &
      "      <target name=""^.*pc-mingw32$"" />" & ASCII.LF &
      "      <target name=""^.*-pikeos.*$"" />" & ASCII.LF &
      "      <target name=""^.*-linux.*"" />" & ASCII.LF &
      "      <target name=""^.*-fastos.*$"" />" & ASCII.LF &
      "      <target name=""^.*-gnueabihf$"" />" & ASCII.LF &
      "      <target name=""^.*-gnueabi$"" />" & ASCII.LF &
      "      <target name=""^c$"" />" & ASCII.LF &
      "      <target name=""^.*-qnx[0-9]*$""/>" & ASCII.LF &
      "      <target name=""^.*-rtems.*$""/>" & ASCII.LF &
      "      <target name=""^cuda$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Do not use the native ar on cross linuxes." & ASCII.LF &
      "       ??? This will be simplified when switching to the new scheme for" & ASCII.LF &
      "       cross linuxes; then we'll have a simple way to check if a toolchain" & ASCII.LF &
      "       is native or cross.  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^i.86-.*linux.*"" />" & ASCII.LF &
      "      <target name=""^x86_64-.*linux.*"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <host name=""^i.86-.*linux.*"" />" & ASCII.LF &
      "      <host name=""^x86_64-.*linux.*"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- powerpc-elf-lynxos178e, after the previous one" & ASCII.LF &
      "       to overwrite the attributes -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^powerpc-elf-lynxos178e$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""powerpc-elf-lynxos178e-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""powerpc-elf-lynxos178e-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^i586-elf-lynxos178e$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Archive_Builder  use (""i586-elf-lynxos178e-ar"", ""cr"");" & ASCII.LF &
      "   for Archive_Builder_Append_Option use (""q"");" & ASCII.LF &
      "   for Archive_Indexer  use (""i586-elf-lynxos178e-ranlib"");" & ASCII.LF &
      "   for Archive_Suffix   use "".a"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "<!--  Systems with no support for shared libraries, but with static libraries -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*aix.*$"" />" & ASCII.LF &
      "       <target name=""^.*lynxos.*$"" />" & ASCII.LF &
      "       <target name=""^x86_64-elf$"" />" & ASCII.LF &
      "       <target name=""^i686-elf$"" />" & ASCII.LF &
      "       <target name=""^visium-elf$"" />" & ASCII.LF &
      "       <target name=""^r7-elf$"" />" & ASCII.LF &
      "       <target name=""^riscv(32|64)(-none|-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^m68020-elf$"" />" & ASCII.LF &
      "       <target name=""^morello(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^powerpc-elf$"" />" & ASCII.LF &
      "       <target name=""^powerpc-eabispe$"" />" & ASCII.LF &
      "       <target name=""^erc32-elf$"" />" & ASCII.LF &
      "       <target name=""^leon-elf$"" />" & ASCII.LF &
      "       <target name=""^leon3-elf$"" />" & ASCII.LF &
      "       <target name=""^aarch64(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^arm(-none)?-eabi$"" />" & ASCII.LF &
      "       <target name=""^arm-apple-darwin.*$"" />" & ASCII.LF &
      "       <target name=""^(arm|powerpc|i586)-wrs-vxworks.*$"" />" & ASCII.LF &
      "       <target name=""^avr$"" />" & ASCII.LF &
      "       <target name=""^.*-pikeos.*$"" />" & ASCII.LF &
      "       <target name=""^c$"" />" & ASCII.LF &
      "       <target name=""^llvm$"" />" & ASCII.LF &
      "       <target name=""^.*-rtems.*$""/>" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Support  use ""static_only"";" & ASCII.LF &
      "   for Library_Builder  use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- DOTNET -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""dotnet"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Support use ""none"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use ""dotnet-ld"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- JGNAT -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""jvm"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Support use ""none"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Symbolic links supported everywhere except on mingw and VMS -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <hosts negate=""true"">" & ASCII.LF &
      "      <host name=""^.*mingw.*$"" />" & ASCII.LF &
      "      <host name=""^.*vms.*$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Symbolic_Link_Supported use ""true"";" & ASCII.LF &
      "   for Library_Major_Minor_Id_Supported use ""true"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <hosts>" & ASCII.LF &
      "      <host name=""^.*mingw.*$"" />" & ASCII.LF &
      "      <host name=""^.*vms.*$"" />" & ASCII.LF &
      "    </hosts>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Symbolic_Link_Supported use ""false"";" & ASCII.LF &
      "   for Library_Major_Minor_Id_Supported use ""false"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Darwin (MacOS): not applicable to iOS  -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler runtime=""ios-simulator"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^i.86-.*darwin.*$"" />" & ASCII.LF &
      "       <target name=""^powerpc-.*darwin.*$"" />" & ASCII.LF &
      "       <target name=""^x86_64-.*darwin.*$"" />" & ASCII.LF &
      "       <target name=""^aarch64-.*darwin.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Builder use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "   for Library_Support use ""full"";" & ASCII.LF &
      "   for Shared_Library_Prefix use ""lib"";" & ASCII.LF &
      "" & ASCII.LF &
      "   for Run_Path_Option  use (""-Wl,-rpath,"");" & ASCII.LF &
      "   for Separate_Run_Path_Options use ""true"";" & ASCII.LF &
      "   for Run_Path_Origin use ""@executable_path"";" & ASCII.LF &
      "   for Library_Install_Name_Option use ""-Wl,-install_name,@rpath"";" & ASCII.LF &
      "" & ASCII.LF &
      "   for Shared_Library_Suffix use "".dylib"";" & ASCII.LF &
      "   for Library_Auto_Init_Supported use ""true"";" & ASCII.LF &
      "   for Archive_Indexer use project'Archive_Indexer &amp; (""-c"");" & ASCII.LF &
      "   for Shared_Library_Minimum_Switches use" & ASCII.LF &
      "         (""-dynamiclib"", ""-shared-libgcc"");" & ASCII.LF &
      "   for Library_Encapsulated_Options use (""-shared"", ""-static-libgcc"");" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Map_File_Option         use ""-Wl,-map,"";" & ASCII.LF &
      "      for Max_Command_Line_Length use ""128000"";" & ASCII.LF &
      "      for Response_File_Format    use ""object_list"";" & ASCII.LF &
      "      for Response_File_Switches  use (""-Wl,-filelist,"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "        <compiler name=""^G\+\+$"" language=""C++"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^i.86-.*darwin.*$"" />" & ASCII.LF &
      "       <target name=""^powerpc-.*darwin.*$"" />" & ASCII.LF &
      "       <target name=""^x86_64-.*darwin.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "    for Library_Rpath_Options (""C++"") use (""-print-file-name=libstdc++.dylib"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  HPUX -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*hpux.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Builder  use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "   for Library_Support  use ""full"";" & ASCII.LF &
      "   for Shared_Library_Prefix use ""lib"";" & ASCII.LF &
      "   for Shared_Library_Minimum_Switches use (""-shared"", ""-fPIC"");" & ASCII.LF &
      "   for Library_Version_Switches use (""-Wl,-soname,"");" & ASCII.LF &
      "" & ASCII.LF &
      "   for Shared_Library_Suffix use "".sl"";" & ASCII.LF &
      "   for Library_Auto_Init_Supported use ""true"";" & ASCII.LF &
      "   for Run_Path_Option  use (""-Wl,+b,"");" & ASCII.LF &
      "   for Library_Partial_Linker use (""gcc"", ""-nostdlib"", ""-Wl,-r"", ""-o"");" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Max_Command_Line_Length use ""5000"";" & ASCII.LF &
      "      for Response_File_Format    use ""object_list"";" & ASCII.LF &
      "      for Response_File_Switches  use (""-Wl,-c,"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- On IA64 HPUX, the shared library suffix is .so," & ASCII.LF &
      "       and the ld switch for internal names in +h -->" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name="".*ia64.*hpux.*"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Shared_Library_Suffix use "".so"";" & ASCII.LF &
      "   for Library_Version_Switches use (""-Wl,+h,"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- linux, freebsd, Irix, OpenBSD, NetBSD, Dragonfly BSD, QNX -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*linux.*$"" />" & ASCII.LF &
      "       <target name=""^.*freebsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*irix.*$"" />" & ASCII.LF &
      "       <target name=""^.*openbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*netbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*dragonfly.*$"" />" & ASCII.LF &
      "       <target name=""^.*-fastos.*$"" />" & ASCII.LF &
      "       <target name=""^.*qnx[0-9]*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Builder  use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "   for Library_Support  use ""full"";" & ASCII.LF &
      "   for Shared_Library_Prefix use ""lib"";" & ASCII.LF &
      "   for Shared_Library_Minimum_Switches use (""-shared"");" & ASCII.LF &
      "   for Library_Version_Switches use (""-Wl,-soname,"");" & ASCII.LF &
      "" & ASCII.LF &
      "   for Shared_Library_Suffix use "".so"";" & ASCII.LF &
      "   for Library_Auto_Init_Supported use ""true"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- VxWorks7r2 -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler runtime=""^rtp$"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^powerpc64-wrs-vxworks7r2"" />" & ASCII.LF &
      "       <target name=""^aarch64-wrs-vxworks7r2"" />" & ASCII.LF &
      "       <target name=""^morello-wrs-vxworks7r2"" />" & ASCII.LF &
      "       <target name=""^x86_64-wrs-vxworks7r2"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Builder  use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "   for Library_Support  use ""full"";" & ASCII.LF &
      "   for Shared_Library_Prefix use ""lib"";" & ASCII.LF &
      "   for Shared_Library_Minimum_Switches use (""-shared"", ""-mrtp"");" & ASCII.LF &
      "   for Library_Version_Switches use (""-Wl,-soname,"");" & ASCII.LF &
      "" & ASCII.LF &
      "   for Shared_Library_Suffix use "".so"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler runtime=""^rtp$"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^powerpc64-wrs-vxworks7r2"" />" & ASCII.LF &
      "       <target name=""^aarch64-wrs-vxworks7r2"" />" & ASCII.LF &
      "       <target name=""^morello-wrs-vxworks7r2"" />" & ASCII.LF &
      "       <target name=""^x86_64-wrs-vxworks7r2"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Support  use ""static_only"";" & ASCII.LF &
      "   for Library_Builder  use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^.*-wrs-vxworks7r2"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Auto_Init_Supported use ""true"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- linux, freebsd, OpenBSD, NetBSD, Dragonfly BSD, QNX -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*linux.*$"" />" & ASCII.LF &
      "       <target name=""^.*qnx[0-9]*$"" />" & ASCII.LF &
      "       <target name=""^.*-fastos.*$"" />" & ASCII.LF &
      "       <target name=""^.*freebsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*openbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*netbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*dragonfly.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Run_Path_Option  use (""-Wl,-z,origin,-rpath,"");" & ASCII.LF &
      "   for Run_Path_Origin use ""$$ORIGIN"";" & ASCII.LF &
      "   for Library_Encapsulated_Options use (""-shared"", ""-static-libgcc"");" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Map_File_Option         use ""-Wl,-Map,"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Cross linux, QNX: add rpath-link to the runtime -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^.*-linux.*$"" />" & ASCII.LF &
      "       <target name=""^.*-fastos.*$"" />" & ASCII.LF &
      "       <target name=""^.*-qnx[0-9]*""/>" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "     GCC_Prefix := ""${PREFIX(ada)}"";" & ASCII.LF &
      "     case GCC_Prefix is" & ASCII.LF &
      "        when """" =>" & ASCII.LF &
      "           null;" & ASCII.LF &
      "        when others =>" & ASCII.LF &
      "           package Linker is" & ASCII.LF &
      "              for Required_Switches use" & ASCII.LF &
      "                Linker'Required_Switches" & ASCII.LF &
      "                &amp; (""-Wl,-rpath-link,${RUNTIME_DIR(ada)}/adalib"");" & ASCII.LF &
      "           end Linker;" & ASCII.LF &
      "     end case;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Settings for Library_Partial_Linker -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- The partial linking option (-r) conflicts with -pie. Recent GNU/Linux" & ASCII.LF &
      "       distributions tune GCC to automatically pass -pie, so we need to pass" & ASCII.LF &
      "       -no-pie for partial linking. GNAT started supporting -no-pie flag only" & ASCII.LF &
      "       for the 17.1 release: leave -r alone for earlier versions and hope for" & ASCII.LF &
      "       the best. -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler name=""^GNAT$"" />" & ASCII.LF &
      "       <compiler name=""GCC"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "      <compiler version=""^3\."" />" & ASCII.LF &
      "      <compiler version=""^5\."" />" & ASCII.LF &
      "      <compiler version=""^6\."" />" & ASCII.LF &
      "      <compiler version=""^7\."" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "        GCC_No_Pie := ();" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler name=""^GNAT$"" />" & ASCII.LF &
      "       <compiler name=""GCC"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "      <compiler version=""^3\."" />" & ASCII.LF &
      "      <compiler version=""^5\."" />" & ASCII.LF &
      "      <compiler version=""^6\."" />" & ASCII.LF &
      "      <compiler version=""^7\."" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "        GCC_No_Pie := (""-no-pie"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler name=""^GNAT$"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*-fastos.*$"" />" & ASCII.LF &
      "       <!-- The Android exception was added in OA23-038 due to a conflict with" & ASCII.LF &
      "            -pie; is it still valid? -->" & ASCII.LF &
      "       <target name=""linux"" except=""androideabi"" />" & ASCII.LF &
      "       <target name=""^.*qnx[0-9]*$"" />" & ASCII.LF &
      "       <target name=""darwin"" />" & ASCII.LF &
      "       <target name=""mingw"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Partial_Linker use" & ASCII.LF &
      "     (""${PATH(ada)}${PREFIX(ada)}gcc"", ""-nostdlib"")" & ASCII.LF &
      "      &amp; GCC_No_Pie" & ASCII.LF &
      "      &amp; (""-Wl,-r"", ""-o"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler name=""^GNAT$"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler name=""GCC"" language=""c""/>" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*-fastos.*$"" />" & ASCII.LF &
      "       <!-- The Android exception was added in OA23-038 due to a conflict with" & ASCII.LF &
      "            -pie; is it still valid? -->" & ASCII.LF &
      "       <target name=""linux"" except=""androideabi"" />" & ASCII.LF &
      "       <target name=""^.*qnx[0-9]*$"" />" & ASCII.LF &
      "       <target name=""darwin"" />" & ASCII.LF &
      "       <target name=""mingw"" />" & ASCII.LF &
      "       <!-- LLVM version of the ""mingw"" triplet -->" & ASCII.LF &
      "       <target name=""windows"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Partial_Linker use" & ASCII.LF &
      "     (""${PATH(c)}${PREFIX(c)}gcc"", ""-nostdlib"")" & ASCII.LF &
      "      &amp; GCC_No_Pie" & ASCII.LF &
      "      &amp; (""-Wl,-r"", ""-o"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Clang automatically disables -pie when the driver gets the -r option" & ASCII.LF &
      "       (which is forwarded to the linker). The same applies to GNAT-LLVM" & ASCII.LF &
      "       because it uses Clang for linking. -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler name=""^GNAT_LLVM$"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""linux"" />" & ASCII.LF &
      "       <!-- LLVM version of the ""mingw"" triplet -->" & ASCII.LF &
      "       <target name=""windows"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Partial_Linker use" & ASCII.LF &
      "     (""${PATH(ada)}${PREFIX(ada)}gcc"", ""-nostdlib"", ""-r"", ""-o"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler name=""CLANG"" language=""c""/>" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""linux"" />" & ASCII.LF &
      "       <!-- LLVM version of the ""mingw"" triplet -->" & ASCII.LF &
      "       <target name=""windows"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Partial_Linker use" & ASCII.LF &
      "     (""${PATH(c)}${PREFIX(c)}clang"", ""-nostdlib"", ""-r"", ""-o"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Settings for Library_Rpath_Options -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "        <compiler name=""^G\+\+$"" language=""C++"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*linux.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "    for Library_Rpath_Options (""C++"") use (""-print-file-name=libstdc++.so"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- irix -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*irix.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Run_Path_Option  use (""-Wl,-rpath,"");" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Max_Command_Line_Length use ""5000"";" & ASCII.LF &
      "      for Response_File_Format    use ""object_list"";" & ASCII.LF &
      "      for Response_File_Switches  use (""-Wl,-objectlist,"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Solaris -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*sunos.*$"" />" & ASCII.LF &
      "       <target name=""^.*solaris.*$""/>" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Builder  use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "   for Library_Support  use ""full"";" & ASCII.LF &
      "   for Shared_Library_Prefix use ""lib"";" & ASCII.LF &
      "   for Shared_Library_Minimum_Switches use (""-shared"");" & ASCII.LF &
      "" & ASCII.LF &
      "   for Library_Version_Switches use (""-Wl,-h,"");" & ASCII.LF &
      "" & ASCII.LF &
      "   for Shared_Library_Suffix use "".so"";" & ASCII.LF &
      "   for Library_Auto_Init_Supported use ""true"";" & ASCII.LF &
      "   for Library_Encapsulated_Options use" & ASCII.LF &
      "      (""-shared"", ""-static-libgcc"", ""-mimpure-text"");" & ASCII.LF &
      "   for Run_Path_Option  use (""-Wl,-z,origin,-R,"");" & ASCII.LF &
      "   for Run_Path_Origin use ""$$ORIGIN"";" & ASCII.LF &
      "   for Library_Partial_Linker use (""gcc"", ""-nostdlib"", ""-Wl,-r"", ""-o"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "        <compiler name=""^G\+\+$"" language=""C++"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*sunos.*$"" />" & ASCII.LF &
      "       <target name=""^.*solaris.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "    for Library_Rpath_Options (""C++"") use (""-print-file-name=libstdc++.so"");" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Windows -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^.*mingw.*$"" />" & ASCII.LF &
      "      <!-- LLVM version of the mingw32 triplet -->" & ASCII.LF &
      "      <target name=""^.*-windows-gnu$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Builder  use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "   for Library_Support  use ""full"";" & ASCII.LF &
      "   for Shared_Library_Prefix use ""lib"";" & ASCII.LF &
      "   for Shared_Library_Minimum_Switches use (""-shared"", ""-shared-libgcc"");" & ASCII.LF &
      "   for Library_Version_Switches use (""-Wl,-soname,"");" & ASCII.LF &
      "   for Shared_Library_Suffix use "".dll"";" & ASCII.LF &
      "   for Library_Encapsulated_Options use (""-shared"", ""-static-libgcc"");" & ASCII.LF &
      "   for Library_Auto_Init_Supported use ""true"";" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Map_File_Option         use ""-Wl,-Map,"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Tru64-->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*osf.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Builder  use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "   for Library_Support  use ""full"";" & ASCII.LF &
      "   for Shared_Library_Prefix use ""lib"";" & ASCII.LF &
      "   for Shared_Library_Minimum_Switches use" & ASCII.LF &
      "      (""-shared"", ""-Wl,-expect_unresolved,*"");" & ASCII.LF &
      "   for Library_Version_Switches use (""-Wl,-soname,"");" & ASCII.LF &
      "" & ASCII.LF &
      "   for Shared_Library_Suffix use "".so"";" & ASCII.LF &
      "   for Library_Auto_Init_Supported use ""true"";" & ASCII.LF &
      "   for Run_Path_Option  use (""-Wl,-rpath,"");" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Max_Command_Line_Length use ""10000"";" & ASCII.LF &
      "      for Response_File_Format    use ""object_list"";" & ASCII.LF &
      "      for Response_File_Switches  use (""-Wl,-input,"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Cygming -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers><compiler name=""^GCC-CYGMING$""/></compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "       for Required_Switches use (""-mno-cygwin"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- CodePeer -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""codepeer"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Support use ""full"";" & ASCII.LF &
      "   for Library_Builder use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- CUDA -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^cuda$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Library_Support use ""full"";" & ASCII.LF &
      "   for Library_Builder  use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "   for Shared_Library_Suffix use "".fatbin.o"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  use C++, Fortran, Ada or C driver to link in this order -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets negate=""true"">" & ASCII.LF &
      "      <target name=""^.*-wrs-vxworks.*$"" />" & ASCII.LF &
      "      <target name=""^.*-wrs-linux.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use Compiler'Driver (""C++"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- On most platforms, g++ would use shared-libstdc++ by default:" & ASCII.LF &
      "       some features (e.g. thread cancellation) are known to be broken" & ASCII.LF &
      "       with static linking for C/C++. On the other hand, Ada uses" & ASCII.LF &
      "       -static-libgcc by default. This static/shared mix would not work." & ASCII.LF &
      "       In order to fix that, we follow the choice of C++ (shared libs)" & ASCII.LF &
      "       when C++ is in the partition." & ASCII.LF &
      "       For more details, see eng/gpr/gpr-issues#93 and P918-005.  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^.*linux.*$"" />" & ASCII.LF &
      "      <target name=""^.*fastos.*$"" />" & ASCII.LF &
      "      <target name=""^.*sunos.*$"" />" & ASCII.LF &
      "      <target name=""^.*solaris.*$"" />" & ASCII.LF &
      "      <target name=""^.*mingw.*$"" />" & ASCII.LF &
      "      <!-- LLVM version of the ""mingw"" triplet -->" & ASCII.LF &
      "      <target name=""^.*windows.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "     package Linker is" & ASCII.LF &
      "        for Required_Switches use Linker'Required_Switches &amp; (""-shared-libgcc"");" & ASCII.LF &
      "     end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""Fortran"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use Compiler'Driver (""Fortran"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "       <compiler language=""Fortran"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets negate=""true"">" & ASCII.LF &
      "       <target name=""aamp"" />" & ASCII.LF &
      "       <target name=""dotnet"" />" & ASCII.LF &
      "       <target name=""jvm"" />" & ASCII.LF &
      "       <target name=""^.*-sysgo-pikeos.*$"" />" & ASCII.LF &
      "       <target name=""^.*-wrs-vxworks.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use Compiler'Driver (""Ada"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- For PikeOS use C drivers as default for linking," & ASCII.LF &
      "       to use SYSGO's libgcc -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""C"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^.*-sysgo-pikeos.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use Compiler'Driver (""C"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^.*-sysgo-pikeos.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use Compiler'Driver (""Ada"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "       <compiler language=""Fortran"" />" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""C"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets negate=""true"">" & ASCII.LF &
      "      <target name=""^.*-wrs-vxworks.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Driver use Compiler'Driver (""C"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- cross targets that use GNU ld -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "       <target name=""^.*-vxworks.*$"" />" & ASCII.LF &
      "       <target name=""^.*-lynxos.*$"" />" & ASCII.LF &
      "       <target name=""^.*-pikeos.*$"" />" & ASCII.LF &
      "       <target name=""^.*-elf$"" />" & ASCII.LF &
      "       <target name=""^.*-eabispe$"" />" & ASCII.LF &
      "       <target name=""^.*-eabi$"" />" & ASCII.LF &
      "       <target name=""^avr$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "     package Linker is" & ASCII.LF &
      "        for Map_File_Option use ""-Wl,-Map,"";" & ASCII.LF &
      "     end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "       <compiler language=""Fortran"" />" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7ARM$"" runtime=""rtp""/>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7E500V2$"" runtime=""rtp""/>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7PPC$"" runtime=""rtp""/>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86$"" runtime=""rtp""/>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86_64$"" runtime=""rtp""/>" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "     package Linker is" & ASCII.LF &
      "        for Required_Switches use" & ASCII.LF &
      "          Linker'Required_Switches" & ASCII.LF &
      "          &amp; (""-mrtp"", ""-L"" &amp; VSB_Dir &amp; ""/usr/lib/common"");" & ASCII.LF &
      "     end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- On x86_64 vxWorks, when Linker'Driver is WRS gcc, -m64," & ASCII.LF &
      "       -mcmodel=large and -mno-red-zone have to be specified" & ASCII.LF &
      "       explicitely. When Linker'Driver is GNAT, this is the default" & ASCII.LF &
      "       already, so it is harmless to pass it twice.  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86_64$""/>" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "        for Required_Switches use" & ASCII.LF &
      "          Linker'Required_Switches" & ASCII.LF &
      "          &amp; (""-m64"", ""-mcmodel=large"", ""-mno-red-zone"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--  Define the right response file mechanism for linking" & ASCII.LF &
      "        when possible use both the GCC @response file (available starting with" & ASCII.LF &
      "        GNAT Pro 6) and the GNU linker mechanism. The latter can be used with" & ASCII.LF &
      "        all cross since they rely on GNU ld and some of the major natives." & ASCII.LF &
      "        Max_Command_Line could be made different for different hosts but we" & ASCII.LF &
      "        use the smallest value of all the hosts instead for uniformity." & ASCII.LF &
      "  -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "       <compiler language=""Fortran"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "      <compiler version=""3.16"" />" & ASCII.LF &
      "      <compiler version=""5.00"" />" & ASCII.LF &
      "      <compiler version=""5.01"" />" & ASCII.LF &
      "      <compiler version=""5.02"" />" & ASCII.LF &
      "      <compiler version=""5.03"" />" & ASCII.LF &
      "      <compiler version=""5.04"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^.*-wrs-vxworks.*$"" />" & ASCII.LF &
      "       <target name=""^.*-elf-lynx.*$"" />" & ASCII.LF &
      "       <target name=""^x86_64-elf$"" />" & ASCII.LF &
      "       <target name=""^i686-elf$"" />" & ASCII.LF &
      "       <target name=""^visium-elf$"" />" & ASCII.LF &
      "       <target name=""^r7-elf$"" />" & ASCII.LF &
      "       <target name=""^riscv(32|64)(-none|-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^m68020-elf$"" />" & ASCII.LF &
      "       <target name=""^morello(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^powerpc-elf$"" />" & ASCII.LF &
      "       <target name=""^powerpc-eabispe$"" />" & ASCII.LF &
      "       <target name=""^erc32-elf$"" />" & ASCII.LF &
      "       <target name=""^leon-elf$"" />" & ASCII.LF &
      "       <target name=""^leon3-elf$"" />" & ASCII.LF &
      "       <target name=""^aarch64(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^arm(-none)?-eabi$"" />" & ASCII.LF &
      "       <target name=""^arm-elf$"" />" & ASCII.LF &
      "       <target name=""^avr$"" />" & ASCII.LF &
      "       <target name=""^.*wrs-vxworks.*$"" />" & ASCII.LF &
      "       <target name=""^powerpc-xcoff-lynxos178$"" />" & ASCII.LF &
      "       <target name=""^.*-elinos-linux$"" />" & ASCII.LF &
      "       <target name=""^.*-fastos.*$"" />" & ASCII.LF &
      "       <target name=""^.*-generic-linux-gnu$"" />" & ASCII.LF &
      "       <target name=""^.*-wrs-linux$"" />" & ASCII.LF &
      "       <target name=""^.*-pikeos.*$"" />" & ASCII.LF &
      "       <target name=""^.*mingw.*$"" />" & ASCII.LF &
      "       <!-- LLVM version of the ""mingw"" triplet -->" & ASCII.LF &
      "       <target name=""^.*windows.*$"" />" & ASCII.LF &
      "       <target name=""^.*linux.*$"" />" & ASCII.LF &
      "       <target name=""^.*freebsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*openbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*netbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*dragonfly.*$"" />" & ASCII.LF &
      "       <target name=""^.*-qnx[0-9]*""/>" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Response_File_Format use ""GCC_GNU"";" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "       <compiler language=""Fortran"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "      <compiler version=""3.16"" />" & ASCII.LF &
      "      <compiler version=""5.00"" />" & ASCII.LF &
      "      <compiler version=""5.01"" />" & ASCII.LF &
      "      <compiler version=""5.02"" />" & ASCII.LF &
      "      <compiler version=""5.03"" />" & ASCII.LF &
      "      <compiler version=""5.04"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^.*wrs-vxworks.*$"" />" & ASCII.LF &
      "       <target name=""^.*-elf-lynx.*$"" />" & ASCII.LF &
      "       <target name=""^x86_64-elf$"" />" & ASCII.LF &
      "       <target name=""^i686-elf$"" />" & ASCII.LF &
      "       <target name=""^visium-elf$"" />" & ASCII.LF &
      "       <target name=""^r7-elf$"" />" & ASCII.LF &
      "       <target name=""^riscv(32|64)(-none|-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^m68020-elf$"" />" & ASCII.LF &
      "       <target name=""^morello(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^powerpc-elf$"" />" & ASCII.LF &
      "       <target name=""^powerpc-eabispe$"" />" & ASCII.LF &
      "       <target name=""^erc32-elf$"" />" & ASCII.LF &
      "       <target name=""^leon-elf$"" />" & ASCII.LF &
      "       <target name=""^leon3-elf$"" />" & ASCII.LF &
      "       <target name=""^arm(-none)?-eabi$"" />" & ASCII.LF &
      "       <target name=""^arm-elf$"" />" & ASCII.LF &
      "       <target name=""^avr$"" />" & ASCII.LF &
      "       <target name=""^.*-elinos-linux$"" />" & ASCII.LF &
      "       <target name=""^.*-generic-linux-gnu$"" />" & ASCII.LF &
      "       <target name=""^.*-wrs-linux$"" />" & ASCII.LF &
      "       <target name=""^.*mingw.*$"" />" & ASCII.LF &
      "       <target name=""^.*linux.*$"" />" & ASCII.LF &
      "       <target name=""^.*freebsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*openbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*netbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*dragonfly.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Response_File_Format use ""GNU"";" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "     <targets>" & ASCII.LF &
      "       <target name=""^.*wrs-vxworks.*$"" />" & ASCII.LF &
      "       <target name=""^.*-elf-lynx.*$"" />" & ASCII.LF &
      "       <target name=""^x86_64-elf$"" />" & ASCII.LF &
      "       <target name=""^i686-elf$"" />" & ASCII.LF &
      "       <target name=""^visium-elf$"" />" & ASCII.LF &
      "       <target name=""^r7-elf$"" />" & ASCII.LF &
      "       <target name=""^riscv(32|64)(-none|-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^m68020-elf$"" />" & ASCII.LF &
      "       <target name=""^morello(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^powerpc-elf$"" />" & ASCII.LF &
      "       <target name=""^powerpc-eabispe$"" />" & ASCII.LF &
      "       <target name=""^erc32-elf$"" />" & ASCII.LF &
      "       <target name=""^leon-elf$"" />" & ASCII.LF &
      "       <target name=""^leon3-elf$"" />" & ASCII.LF &
      "       <target name=""^aarch64(-unknown-unknown)?-elf$"" />" & ASCII.LF &
      "       <target name=""^arm(-none)?-eabi$"" />" & ASCII.LF &
      "       <target name=""^arm-elf$"" />" & ASCII.LF &
      "       <target name=""^avr$"" />" & ASCII.LF &
      "       <target name=""^.*-elinos-linux$"" />" & ASCII.LF &
      "       <target name=""^.*-generic-linux-gnu$"" />" & ASCII.LF &
      "       <target name=""^.*-wrs-linux$"" />" & ASCII.LF &
      "       <target name=""^.*mingw.*$"" />" & ASCII.LF &
      "       <target name=""^.*linux.*$"" />" & ASCII.LF &
      "       <target name=""^.*freebsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*openbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*netbsd.*$"" />" & ASCII.LF &
      "       <target name=""^.*dragonfly.*$"" />" & ASCII.LF &
      "     </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Response_File_Format use ""GNU"";" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "       <compiler language=""Fortran"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "      <compiler version=""3.16"" />" & ASCII.LF &
      "      <compiler version=""5.00"" />" & ASCII.LF &
      "      <compiler version=""5.01"" />" & ASCII.LF &
      "      <compiler version=""5.02"" />" & ASCII.LF &
      "      <compiler version=""5.03"" />" & ASCII.LF &
      "      <compiler version=""5.04"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""^.*aix.*$"" />" & ASCII.LF &
      "      <target name=""^.*hpux.*$"" />" & ASCII.LF &
      "      <target name=""^.*irix.*$"" />" & ASCII.LF &
      "      <target name=""^.*osf.*$"" />" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Response_File_Format use ""GCC_Object_List"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      " <!-- Default language is Ada, C, Fortran, C++ in that order -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Default_Language use ""Ada"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""C"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Default_Language use ""C"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C"" />" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""Fortran"" /></compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Default_Language use ""Fortran"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers negate=""true"">" & ASCII.LF &
      "       <compiler language=""C"" />" & ASCII.LF &
      "       <compiler language=""Fortran"" />" & ASCII.LF &
      "       <compiler language=""Ada"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "       <compiler language=""C++"" />" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   for Default_Language use ""C++"";" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- When using the (Ada) ios-simulator runtime, some additional" & ASCII.LF &
      "       arguments are needed to complete the link.  -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler runtime=""ios-simulator"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   for Library_Support  use ""static_only"";" & ASCII.LF &
      "   for Library_Builder  use ""${GPRCONFIG_PREFIX}lib/gprbuild/gprlib"";" & ASCII.LF &
      "   for Library_Partial_Linker use (""${PATH(ada)}${PREFIX(ada)}gcc""," & ASCII.LF &
      "                                   ""-mios-simulator-version-min=8.0""," & ASCII.LF &
      "                                   ""-nostdlib"", ""-Wl,-r"", ""-o"");" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Required_Switches use Linker'Required_Switches" & ASCII.LF &
      "        &amp; (""-mios-simulator-version-min=8.0""," & ASCII.LF &
      "               ""-nostartfiles""," & ASCII.LF &
      "               ""-Wl,-syslibroot,/Applications/Xcode.app/Contents/Developer/Platforms/iPhoneSimulator.platform/Developer/SDKs/iPhoneSimulator.sdk"");" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("morello-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'morello-wrs-vxworks7r2'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^LLVMC-AARCH64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^LLVMC-AARCH64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x80000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "  <!--" & ASCII.LF &
      "   __aarch64_swp1_acq is provided by libgcc, but we want to avoid that" & ASCII.LF &
      "   dependency since we don't want users to link with libgcc when using" & ASCII.LF &
      "   restricted runtimes (this would introduce issues with certification)." & ASCII.LF &
      "  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    &if_ada;" & ASCII.LF &
      "    &if_restricted_rts;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "    <!-- vx7r2cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""Ada"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""Ada"")" & ASCII.LF &
      "        &amp; (""-mno-outline-atomics"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    &if_adacore_c;" & ASCII.LF &
      "    &if_restricted_rts;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "    <!-- vx7r2cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C"")" & ASCII.LF &
      "        &amp; (""-mno-outline-atomics"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    &if_adacore_cpp;" & ASCII.LF &
      "    &if_restricted_rts;" & ASCII.LF &
      "    &if_this_target;" & ASCII.LF &
      "" & ASCII.LF &
      "    <!-- vx7r2cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Leading_Required_Switches   (""C++"") use" & ASCII.LF &
      "        Compiler'Leading_Required_Switches (""C++"")" & ASCII.LF &
      "        &amp; (""-mno-outline-atomics"");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("nocompiler.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!--  For languages with no compiler -->" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "    <compiler language=""Project File""/>" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "package Compiler is" & ASCII.LF &
      "   for Driver (""Project File"") use """";" & ASCII.LF &
      "end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "package Naming is" & ASCII.LF &
      "   for Spec_Suffix (""Project File"") use "".gpr"";" & ASCII.LF &
      "end Naming;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "    <compiler language=""Simulink""/>" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "package Compiler is" & ASCII.LF &
      "   for Driver (""Simulink"") use """";" & ASCII.LF &
      "end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "package Naming is" & ASCII.LF &
      "   for Spec_Suffix (""Simulink"") use "".mdl"";" & ASCII.LF &
      "end Naming;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "   <compilers>" & ASCII.LF &
      "    <compiler language=""Matlab""/>" & ASCII.LF &
      "   </compilers>" & ASCII.LF &
      "   <config>" & ASCII.LF &
      "package Compiler is" & ASCII.LF &
      "   for Driver (""Matlab"") use """";" & ASCII.LF &
      "end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "package Naming is" & ASCII.LF &
      "   for Spec_Suffix (""Matlab"") use "".m"";" & ASCII.LF &
      "end Naming;" & ASCII.LF &
      "   </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("ppc-vx6.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx6.ent SYSTEM ""vx6.ent""> %vx6.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'powerpc-wrs-vxworks'>" & ASCII.LF &
      "<!ENTITY this_gnu_wrs_suffix 'ppc'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6CERT$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6$"" />" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6CERT$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6$"" />" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6CERT$"" />" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6CERT$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x40000000'>" & ASCII.LF &
      "<!-- For vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_cpu_subdir 'ppc/PPC32/common'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx6;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("ppc-vx653.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx653.ent SYSTEM ""vx653.ent""> %vx653.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'powerpc-wrs-vxworksae'>" & ASCII.LF &
      "<!ENTITY this_gnu_wrs_suffix 'ppc'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <!--  ??? Eventually GCC_Pro will be replaced by a e500v2-vx6-specific" & ASCII.LF &
      "       definition:" & ASCII.LF &
      "       <compiler name=""^PPC-VX653-GCC-ADACORE$"" />" & ASCII.LF &
      "       -->" & ASCII.LF &
      "       <compiler name=""^GCC-WRS653-PPC$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS653-PPC$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS653-PPC$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS653-PPC$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS653-PPC$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS653-PPC$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx653;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("ppc-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'powerpc-wrs-vxworks7'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7PPC$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7PPC$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x80000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("ppc-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'powerpc-wrs-vxworks7r2'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7R2PPC$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS7R2PPC$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7R2PPC$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x80000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("ppc64-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'powerpc64-wrs-vxworks7'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^DIABC-PPC64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <!--  No GNU WRS compilers are defined in compilers-ppc64-vx7.xml," & ASCII.LF &
      "             so this will never match. So this is here for consistency" & ASCII.LF &
      "             only, and to allow a refactoring of the macro later on." & ASCII.LF &
      "       -->" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7PPC64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x40000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("ppc64-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'powerpc64-wrs-vxworks7r2'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7R2PPC64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <!--  No GNU WRS compilers are defined in compilers-ppc64-vx7.xml," & ASCII.LF &
      "             so this will never match. So this is here for consistency" & ASCII.LF &
      "             only, and to allow a refactoring of the macro later on." & ASCII.LF &
      "       -->" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS7R2PPC64$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7R2PPC64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x40000000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("targetset.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Add elinos ports *before* native ports to" & ASCII.LF &
      "     be matched before native compiler -->" & ASCII.LF &
      " <!-- x86-elinos-.* -->" & ASCII.LF &
      "  <targetset canonical=""x86-elinos"">" & ASCII.LF &
      "    <target>x86-elinos</target>" & ASCII.LF &
      "    <target>x86-elinos-linux</target>" & ASCII.LF &
      "    <target>i686-elinos-linux</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-elinos-.* -->" & ASCII.LF &
      "  <targetset canonical=""ppc-elinos"">" & ASCII.LF &
      "    <target>ppc-elinos</target>" & ASCII.LF &
      "    <target>ppc-elinos-linux</target>" & ASCII.LF &
      "    <target>powerpc-elinos-linux</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Add wrs-linux ports *before* native ports to" & ASCII.LF &
      "     be matched before native compiler -->" & ASCII.LF &
      "  <targetset canonical=""e500v2-wrslinux"">" & ASCII.LF &
      "    <target>e500v2-wrslinux</target>" & ASCII.LF &
      "    <target>e500v2-wrs-linux</target>" & ASCII.LF &
      "    <target>e500v2-wrs-linux</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""ppc-wrslinux"">" & ASCII.LF &
      "    <target>ppc-wrslinux</target>" & ASCII.LF &
      "    <target>ppc-wrs-linux</target>" & ASCII.LF &
      "    <target>powerpc-wrs-linux</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Add plain linux ports *before* native ports to" & ASCII.LF &
      "     be matched before native compiler -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-linux"">" & ASCII.LF &
      "    <target>aarch64-linux</target>" & ASCII.LF &
      "    <target>aarch64-linux-gnu</target>" & ASCII.LF &
      "    <target>aarch64-unknown-linux-gnu</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""arm-linux"">" & ASCII.LF &
      "    <target>arm-linux</target>" & ASCII.LF &
      "    <target>arm-linux-gnueabi</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""armhf-linux"">" & ASCII.LF &
      "    <target>armhf-linux</target>" & ASCII.LF &
      "    <target>arm-linux-gnueabihf</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""e500v2-linux"">" & ASCII.LF &
      "    <target>e500v2-linux</target>" & ASCII.LF &
      "    <target>e500v2-gnu-linux</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""ppc-linux"">" & ASCII.LF &
      "    <target>ppc-linux</target>" & ASCII.LF &
      "    <target>powerpc-generic-linux-gnu</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""ppc64-linux"">" & ASCII.LF &
      "    <target>ppc64-linux</target>" & ASCII.LF &
      "    <target>powerpc64-generic-linux-gnu</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Native ports -->" & ASCII.LF &
      "<!-- ************ -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-linux -->" & ASCII.LF &
      "  <targetset canonical=""x86-linux"">" & ASCII.LF &
      "    <target>x86-linux</target>" & ASCII.LF &
      "    <target>x86_32-linux</target>" & ASCII.LF &
      "    <target>i.86-.*linux.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86_64-linux -->" & ASCII.LF &
      "  <targetset canonical=""x86_64-linux"">" & ASCII.LF &
      "    <target>x86_64-linux</target>" & ASCII.LF &
      "    <target>x86_64-.*linux.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ia64-.*-linux -->" & ASCII.LF &
      "  <targetset canonical=""ia64-linux"">" & ASCII.LF &
      "    <target>ia64-linux</target>" & ASCII.LF &
      "    <target>ia64-hp_linux</target>" & ASCII.LF &
      "    <target>ia64-sgi_linux</target>" & ASCII.LF &
      "    <target>ia64-.*linux.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- sparc-solaris -->" & ASCII.LF &
      "  <targetset canonical=""sparc-solaris"">" & ASCII.LF &
      "    <target>sparc-solaris</target>" & ASCII.LF &
      "    <target>sparc-.*solaris.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- sparc64-solaris -->" & ASCII.LF &
      "  <targetset canonical=""sparc64-solaris"">" & ASCII.LF &
      "    <target>sparc64-solaris</target>" & ASCII.LF &
      "    <target>sparc64-.*solaris.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-solaris -->" & ASCII.LF &
      "  <targetset canonical=""x86-solaris"">" & ASCII.LF &
      "    <target>x86-solaris</target>" & ASCII.LF &
      "    <target>i.86-(pc-)?solaris.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-windows (mingw) -->" & ASCII.LF &
      "  <targetset canonical=""x86-windows"">" & ASCII.LF &
      "    <!--  known targets: pentium-mingw32msv, i686-pc-mingw32 -->" & ASCII.LF &
      "    <target>x86-windows</target>" & ASCII.LF &
      "    <target>x86_32-windows</target>" & ASCII.LF &
      "    <target>mingw32</target>" & ASCII.LF &
      "    <target>i.86-.*mingw32.*</target>" & ASCII.LF &
      "    <target>pentium-.*mingw32.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86_64-windows (mingw) -->" & ASCII.LF &
      "  <targetset canonical=""x86_64-windows"">" & ASCII.LF &
      "    <!--  known targets: x86_64-pc-mingw32 -->" & ASCII.LF &
      "    <target>x86_64-windows</target>" & ASCII.LF &
      "    <target>x86_64-.*mingw32.*</target>" & ASCII.LF &
      "    <!-- canonical LLVM target for MinGW -->" & ASCII.LF &
      "    <!-- x86_64-{pc,w64}-windows-gnu for our Windows triplets -->" & ASCII.LF &
      "    <target>x86_64-.*windows-gnu</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- aarch64-darwin (iOS 64bit) -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-darwin"">" & ASCII.LF &
      "    <target>aarch64-ios</target>" & ASCII.LF &
      "    <target>aarch64-darwin</target>" & ASCII.LF &
      "    <target>aarch64.*-darwin.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm-darwin (iOS) -->" & ASCII.LF &
      "  <targetset canonical=""arm-darwin"">" & ASCII.LF &
      "    <target>arm-ios</target>" & ASCII.LF &
      "    <target>arm-darwin</target>" & ASCII.LF &
      "    <target>arm.*-darwin.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-darwin -->" & ASCII.LF &
      "  <targetset canonical=""ppc-darwin"">" & ASCII.LF &
      "    <target>ppc-darwin</target>" & ASCII.LF &
      "    <target>powerpc.*darwin.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-darwin -->" & ASCII.LF &
      "  <targetset canonical=""x86-darwin"">" & ASCII.LF &
      "    <target>x86-darwin</target>" & ASCII.LF &
      "    <target>x86_32-darwin</target>" & ASCII.LF &
      "    <target>i.86-.*-darwin.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86_64-darwin -->" & ASCII.LF &
      "  <targetset canonical=""x86_64-darwin"">" & ASCII.LF &
      "    <target>x86_64-darwin</target>" & ASCII.LF &
      "    <target>x86_64-.*-darwin.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- pa-hpux -->" & ASCII.LF &
      "  <targetset canonical=""pa-hpux"">" & ASCII.LF &
      "    <target>pa-hpux</target>" & ASCII.LF &
      "    <target>hppa.*-hpux.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ia64-hpux -->" & ASCII.LF &
      "  <targetset canonical=""ia64-hpux"">" & ASCII.LF &
      "    <target>ia64-hpux</target>" & ASCII.LF &
      "    <target>ia64-.*hpux.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- alpha-tru64 -->" & ASCII.LF &
      "  <targetset canonical=""alpha-tru64"">" & ASCII.LF &
      "    <target>alpha-tru64</target>" & ASCII.LF &
      "    <target>alpha.*osf.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- alpha-openvms -->" & ASCII.LF &
      "  <targetset canonical=""alpha-openvms"">" & ASCII.LF &
      "    <target>alpha-openvms</target>" & ASCII.LF &
      "    <target>alpha64-dec-openvms.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- mips-irix -->" & ASCII.LF &
      "  <targetset canonical=""mips-irix"">" & ASCII.LF &
      "    <target>mips-irix</target>" & ASCII.LF &
      "    <target>mips-.*irix.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-aix -->" & ASCII.LF &
      "  <targetset canonical=""ppc-aix"">" & ASCII.LF &
      "    <target>ppc-aix</target>" & ASCII.LF &
      "    <target>powerpc.*-aix.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-linux -->" & ASCII.LF &
      "  <targetset canonical=""ppc-linux"">" & ASCII.LF &
      "    <target>ppc-linux</target>" & ASCII.LF &
      "    <target>powerpc-.*-linux.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-lynx -->" & ASCII.LF &
      "  <targetset canonical=""x86-lynx"">" & ASCII.LF &
      "    <target>x86-lynx</target>" & ASCII.LF &
      "    <target>i.86-.*-lynxos</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Additional Natives -->" & ASCII.LF &
      "<!-- ******************* -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-windows cygwin -->" & ASCII.LF &
      "  <targetset canonical=""x86-cygwin"">" & ASCII.LF &
      "    <target>i.*-cygwin.*</target>" & ASCII.LF &
      "    <target>pent.*-cygwin.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- aarch64 FreeBSD -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-freebsd"">" & ASCII.LF &
      "    <target>aarch64-freebsd</target>" & ASCII.LF &
      "    <target>aarch64-.*freebsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86 FreeBSD -->" & ASCII.LF &
      "  <targetset canonical=""x86-freebsd"">" & ASCII.LF &
      "    <target>x86-freebsd</target>" & ASCII.LF &
      "    <target>x86_32-freebsd</target>" & ASCII.LF &
      "    <target>i.86-.*freebsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86_64 FreeBSD -->" & ASCII.LF &
      "  <targetset canonical=""x86_64-freebsd"">" & ASCII.LF &
      "    <target>x86_64-freebsd</target>" & ASCII.LF &
      "    <target>x86_64-.*freebsd.*</target>" & ASCII.LF &
      "    <target>amd64-.*freebsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86 NetBSD -->" & ASCII.LF &
      "  <targetset canonical=""x86-netbsd"">" & ASCII.LF &
      "    <target>x86-netbsd</target>" & ASCII.LF &
      "    <target>x86_32-netbsd</target>" & ASCII.LF &
      "    <target>i.86-.*netbsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86_64 NetBSD -->" & ASCII.LF &
      "  <targetset canonical=""x86_64-netbsd"">" & ASCII.LF &
      "    <target>x86_64-netbsd</target>" & ASCII.LF &
      "    <target>x86_64-.*netbsd.*</target>" & ASCII.LF &
      "    <target>amd64-.*netbsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm* NetBSD support -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-netbsd"">" & ASCII.LF &
      "    <target>aarch64-netbsd</target>" & ASCII.LF &
      "    <target>aarch64-.*netbsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""arm7-netbsd"">" & ASCII.LF &
      "    <target>arm7-netbsd</target>" & ASCII.LF &
      "    <target>arm7-.*netbsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""arm7eb-netbsd"">" & ASCII.LF &
      "    <target>arm7eb-netbsd</target>" & ASCII.LF &
      "    <target>arm7eb-.*netbsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- Other arm* NetBSD support -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-netbsd"">" & ASCII.LF &
      "    <target>arm*-.*netbsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- RISC-V NetBSD support -->" & ASCII.LF &
      "  <targetset canonical=""riscv32-netbsd"">" & ASCII.LF &
      "    <target>riscv32-netbsd</target>" & ASCII.LF &
      "    <target>riscv32-.*netbsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""riscv64-netbsd"">" & ASCII.LF &
      "    <target>riscv64-netbsd</target>" & ASCII.LF &
      "    <target>riscv64-.*netbsd.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86_64 DragonflyBSD -->" & ASCII.LF &
      "  <targetset canonical=""x86_64-dragonfly"">" & ASCII.LF &
      "    <target>x86_64-dragonfly</target>" & ASCII.LF &
      "    <target>x86_64-.*dragonlfy.*</target>" & ASCII.LF &
      "    <target>amd64-.*dragonfly.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Cross Ports -->" & ASCII.LF &
      "<!-- *********** -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- aamp -->" & ASCII.LF &
      "  <targetset canonical=""aamp"">" & ASCII.LF &
      "    <target>aamp</target>" & ASCII.LF &
      "    <target>.*aamp.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-lynx178elf -->" & ASCII.LF &
      "  <targetset canonical=""ppc-lynx178elf"">" & ASCII.LF &
      "    <target>ppc-lynx178elf</target>" & ASCII.LF &
      "    <target>powerpc-elf-lynxos178e</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-lynx5-.* -->" & ASCII.LF &
      "  <targetset canonical=""ppc-lynx5"">" & ASCII.LF &
      "    <target>ppc-lynx5</target>" & ASCII.LF &
      "    <target>ppc-lynx5.*</target>" & ASCII.LF &
      "    <target>powerpc-elf-lynxos5.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-lynx-.* -->" & ASCII.LF &
      "  <targetset canonical=""ppc-lynx"">" & ASCII.LF &
      "    <target>ppc-lynx</target>" & ASCII.LF &
      "    <target>ppc-lynx-solaris</target>" & ASCII.LF &
      "    <target>ppc-lynx-.*</target>" & ASCII.LF &
      "    <target>powerpc-elf-lynxos.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-xcoff-lynxos178-.* -->" & ASCII.LF &
      "  <targetset canonical=""ppc-lynx178"">" & ASCII.LF &
      "    <target>ppc-lynx178</target>" & ASCII.LF &
      "    <target>ppc-xcoff-lynxos</target>" & ASCII.LF &
      "    <target>ppc-xcoff-lynxos178.*</target>" & ASCII.LF &
      "    <target>powerpc-xcoff-lynxos178.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-lynx178elf -->" & ASCII.LF &
      "  <targetset canonical=""x86-lynx178elf"">" & ASCII.LF &
      "    <target>x86-lynx178elf</target>" & ASCII.LF &
      "    <target>i586-elf-lynxos178e</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-lynx5-.* -->" & ASCII.LF &
      "  <targetset canonical=""x86-lynx5"">" & ASCII.LF &
      "    <target>x86-lynx5</target>" & ASCII.LF &
      "    <target>x86-lynx5.*</target>" & ASCII.LF &
      "    <target>i386-elf-lynxos5.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm-vx7 (vxworks 7) -->" & ASCII.LF &
      "  <targetset canonical=""arm-vx7"">" & ASCII.LF &
      "    <target>arm-vx7</target>" & ASCII.LF &
      "    <target>arm-wrs-vxworks7</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm-vx7r2 (vxworks 7.2) -->" & ASCII.LF &
      "  <targetset canonical=""arm-vx7r2"">" & ASCII.LF &
      "    <target>arm-vx7r2</target>" & ASCII.LF &
      "    <!-- vx7r2cert platforms use the same target triplet as" & ASCII.LF &
      "         the corresponding vx7r2 (non-cert) platform." & ASCII.LF &
      "         Add them to the same targetset as well (see TB12-012). -->" & ASCII.LF &
      "    <target>arm-vx7r2cert</target>" & ASCII.LF &
      "    <target>arm-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- e500v2-vx7 (vxworks 7) -->" & ASCII.LF &
      "  <targetset canonical=""e500v2-vx7"">" & ASCII.LF &
      "    <target>e500v2-vx7</target>" & ASCII.LF &
      "    <target>e500v2-wrs-vxworks7</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- e500v2-vx7 (vxworks 7) -->" & ASCII.LF &
      "  <targetset canonical=""e500v2-vx7r2"">" & ASCII.LF &
      "    <target>e500v2-vx7r2</target>" & ASCII.LF &
      "    <!-- vx7r2cert platforms use the same target triplet as" & ASCII.LF &
      "         the corresponding vx7r2 (non-cert) platform." & ASCII.LF &
      "         Add them to the same targetset as well (see TB12-012). -->" & ASCII.LF &
      "    <target>e500v2-vx7r2cert</target>" & ASCII.LF &
      "    <target>e500v2-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-vx7 (vxworks 7) -->" & ASCII.LF &
      "  <targetset canonical=""ppc-vx7"">" & ASCII.LF &
      "    <target>ppc-vx7</target>" & ASCII.LF &
      "    <target>powerpc-wrs-vxworks7</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-vx7r2 (vxworks 7.2) -->" & ASCII.LF &
      "  <targetset canonical=""ppc-vx7r2"">" & ASCII.LF &
      "    <target>ppc-vx7r2</target>" & ASCII.LF &
      "    <!-- vx7r2cert platforms use the same target triplet as" & ASCII.LF &
      "         the corresponding vx7r2 (non-cert) platform." & ASCII.LF &
      "         Add them to the same targetset as well (see TB12-012). -->" & ASCII.LF &
      "    <target>ppc-vx7r2cert</target>" & ASCII.LF &
      "    <target>powerpc-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc64-vx7 (vxworks 7) -->" & ASCII.LF &
      "  <targetset canonical=""ppc64-vx7"">" & ASCII.LF &
      "    <target>ppc64-vx7</target>" & ASCII.LF &
      "    <target>powerpc64-wrs-vxworks7</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc64-vx7r2 (vxworks 7.2) -->" & ASCII.LF &
      "  <targetset canonical=""ppc64-vx7r2"">" & ASCII.LF &
      "    <target>ppc64-vx7r2</target>" & ASCII.LF &
      "    <!-- vx7r2cert platforms use the same target triplet as" & ASCII.LF &
      "         the corresponding vx7r2 (non-cert) platform." & ASCII.LF &
      "         Add them to the same targetset as well (see TB12-012). -->" & ASCII.LF &
      "    <target>ppc64-vx7r2cert</target>" & ASCII.LF &
      "    <target>powerpc64-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-vx7-.* (vxworks 7) -->" & ASCII.LF &
      "  <targetset canonical=""x86-vx7"">" & ASCII.LF &
      "    <target>x86-vx7</target>" & ASCII.LF &
      "    <target>x86-wrs-vxworks7</target>" & ASCII.LF &
      "    <target>i.86-wrs-vxworks7</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-vx7r2-.* (vxworks 7.2) -->" & ASCII.LF &
      "  <targetset canonical=""x86-vx7r2"">" & ASCII.LF &
      "    <target>x86-vx7r2</target>" & ASCII.LF &
      "    <!-- vx7r2cert platforms use the same target triplet as" & ASCII.LF &
      "         the corresponding vx7r2 (non-cert) platform." & ASCII.LF &
      "         Add them to the same targetset as well (see TB12-012). -->" & ASCII.LF &
      "    <target>x86-vx7r2cert</target>" & ASCII.LF &
      "    <target>x86-wrs-vxworks7r2</target>" & ASCII.LF &
      "    <target>i.86-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86_64-vx7 (vxworks 7) -->" & ASCII.LF &
      "  <targetset canonical=""x86_64-vx7"">" & ASCII.LF &
      "    <target>x86_64-wrs-vxworks7</target>" & ASCII.LF &
      "    <target>x86_64-vx7</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86_64-vx7r2 (vxworks 7.2) -->" & ASCII.LF &
      "  <targetset canonical=""x86_64-vx7r2"">" & ASCII.LF &
      "    <target>x86_64-vx7r2</target>" & ASCII.LF &
      "    <!-- vx7r2cert platforms use the same target triplet as" & ASCII.LF &
      "         the corresponding vx7r2 (non-cert) platform." & ASCII.LF &
      "         Add them to the same targetset as well (see TB12-012). -->" & ASCII.LF &
      "    <target>x86_64-vx7r2cert</target>" & ASCII.LF &
      "    <target>x86_64-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm-vx6 (vxworks 6) -->" & ASCII.LF &
      "  <targetset canonical=""arm-vx6"">" & ASCII.LF &
      "    <target>arm-vx6</target>" & ASCII.LF &
      "    <target>arm-wrs-vxworks</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-vx6-.* (vxworks 6) -->" & ASCII.LF &
      "  <targetset canonical=""x86-vx6"">" & ASCII.LF &
      "    <target>x86-vx6</target>" & ASCII.LF &
      "    <target>x86-wrs-vxworks</target>" & ASCII.LF &
      "    <target>x86-vx6-windows</target>" & ASCII.LF &
      "    <target>x86-vx6-linux</target>" & ASCII.LF &
      "    <target>i.86-wrs-vxworks</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""ppc-vx6"">" & ASCII.LF &
      "    <target>powerpc-wrs-vxworks</target>" & ASCII.LF &
      "    <!-- ppc-vxw-.*  (vxworks 5) -->" & ASCII.LF &
      "    <target>ppc-vxw</target>" & ASCII.LF &
      "    <target>ppc-vxw-solaris</target>" & ASCII.LF &
      "    <target>ppc-vxw-windows</target>" & ASCII.LF &
      "    <!-- ppc-vx178b-.*  (vxworks cert) -->" & ASCII.LF &
      "    <target>ppc-vx178b</target>" & ASCII.LF &
      "    <target>ppc-vx178b-solaris</target>" & ASCII.LF &
      "    <target>ppc-vx178b-windows</target>" & ASCII.LF &
      "    <!-- ppc-vx6-.* - used as canonical target since more common -->" & ASCII.LF &
      "    <target>ppc-vx6</target>" & ASCII.LF &
      "    <target>ppc-vx6-solaris</target>" & ASCII.LF &
      "    <target>ppc-vx6-windows</target>" & ASCII.LF &
      "    <target>ppc-vx6-linux</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""e500v2-vx6"">" & ASCII.LF &
      "    <!-- e500v2-vx6-.* -->" & ASCII.LF &
      "    <target>e500v2-vx6</target>" & ASCII.LF &
      "    <target>e500v2-wrs-vxworks</target>" & ASCII.LF &
      "    <target>e500v2-vx6-solaris</target>" & ASCII.LF &
      "    <target>e500v2-vx6-windows</target>" & ASCII.LF &
      "    <target>e500v2-vx6-linux</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-vx653-.*  (vxworks 653) -->" & ASCII.LF &
      "  <targetset canonical=""ppc-vx653"">" & ASCII.LF &
      "    <target>ppc-vx653</target>" & ASCII.LF &
      "    <target>ppc-vx653-solaris</target>" & ASCII.LF &
      "    <target>ppc-vx653-windows</target>" & ASCII.LF &
      "    <target>powerpc-wrs-vxworksae</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- e500v2-vx653-.*  (vxworks 653) -->" & ASCII.LF &
      "  <targetset canonical=""e500v2-vx653"">" & ASCII.LF &
      "    <target>e500v2-vx653</target>" & ASCII.LF &
      "    <target>e500v2-vx653-windows</target>" & ASCII.LF &
      "    <target>e500v2-wrs-vxworksae</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- aarch64-fastos  -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-fastos"">" & ASCII.LF &
      "    <target>aarch64-fastos</target>" & ASCII.LF &
      "    <target>aarch64-thales-fastos</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- aarch64-qnx  -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-qnx"">" & ASCII.LF &
      "    <target>aarch64-qnx</target>" & ASCII.LF &
      "    <target>aarch64-nto-qnx</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm-qnx  -->" & ASCII.LF &
      "  <targetset canonical=""arm-qnx"">" & ASCII.LF &
      "    <target>arm-qnx</target>" & ASCII.LF &
      "    <target>arm-nto-qnx</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- aarch64-vx7 (vxworks 7) -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-vx7"">" & ASCII.LF &
      "    <target>aarch64-vx7</target>" & ASCII.LF &
      "    <target>aarch64-wrs-vxworks7</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- aarch64-vx7r2 (vxworks 7.2) -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-vx7r2"">" & ASCII.LF &
      "    <target>aarch64-vx7r2</target>" & ASCII.LF &
      "    <!-- vx7r2cert platforms use the same target triplet as" & ASCII.LF &
      "         the corresponding vx7r2 (non-cert) platform." & ASCII.LF &
      "         Add them to the same targetset as well (see TB12-012). -->" & ASCII.LF &
      "    <target>aarch64-vx7r2cert</target>" & ASCII.LF &
      "    <target>aarch64-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- morello-vx7r2 (vxworks 7.2) -->" & ASCII.LF &
      "  <targetset canonical=""morello-vx7r2"">" & ASCII.LF &
      "    <target>morello-vx7r2</target>" & ASCII.LF &
      "    <!-- vx7r2cert platforms use the same target triplet as" & ASCII.LF &
      "         the corresponding vx7r2 (non-cert) platform." & ASCII.LF &
      "         Add them to the same targetset as well (see TB12-012). -->" & ASCII.LF &
      "    <target>morello-vx7r2cert</target>" & ASCII.LF &
      "    <target>morello-wrs-vxworks7r2</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""ppc-elf"">" & ASCII.LF &
      "    <target>ppc-elf</target>" & ASCII.LF &
      "    <target>ppc-elf-solaris</target>" & ASCII.LF &
      "    <target>ppc-elf-windows</target>" & ASCII.LF &
      "    <target>powerpc-elf</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- p55-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""p55-elf"">" & ASCII.LF &
      "    <target>p55-elf</target>" & ASCII.LF &
      "    <target>p55-elf-windows</target>" & ASCII.LF &
      "    <target>powerpc-eabispe</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- erc32-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""erc32-elf"">" & ASCII.LF &
      "    <target>erc32-elf</target>" & ASCII.LF &
      "    <target>erc32-elf-solaris</target>" & ASCII.LF &
      "    <target>erc32-elf-linux</target>" & ASCII.LF &
      "    <target>erc32-elf.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- leon-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""leon-elf"">" & ASCII.LF &
      "    <target>leon-elf</target>" & ASCII.LF &
      "    <target>leon-elf-solaris</target>" & ASCII.LF &
      "    <target>leon-elf-linux</target>" & ASCII.LF &
      "    <target>leon-elf.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- leon3-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""leon3-elf"">" & ASCII.LF &
      "    <target>leon3-elf</target>" & ASCII.LF &
      "    <target>leon3-elf-linux</target>" & ASCII.LF &
      "    <target>leon3-elf.*</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""arm-elf"">" & ASCII.LF &
      "    <target>arm-elf</target>" & ASCII.LF &
      "    <target>arm-elf-linux</target>" & ASCII.LF &
      "    <target>arm-eabi</target>" & ASCII.LF &
      "    <target>arm-none-eabi</target>" & ASCII.LF &
      "    <target>arm-freertos</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- aarch64-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-elf"">" & ASCII.LF &
      "    <target>aarch64-elf</target>" & ASCII.LF &
      "    <target>aarch64-unknown-unknown-elf</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- morello-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""morello-elf"">" & ASCII.LF &
      "    <target>morello-elf</target>" & ASCII.LF &
      "    <target>morello-none-elf</target>" & ASCII.LF &
      "    <target>morello-unknown-elf</target>" & ASCII.LF &
      "    <target>morello-unknown-unknown-elf</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- r7-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""r7-elf"">" & ASCII.LF &
      "    <target>r7-elf</target>" & ASCII.LF &
      "    <target>r7-none-elf</target>" & ASCII.LF &
      "    <target>r7-unknown-elf</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- riscv32-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""riscv32-elf"">" & ASCII.LF &
      "    <target>riscv32-elf</target>" & ASCII.LF &
      "    <target>riscv32-none-elf</target>" & ASCII.LF &
      "    <target>riscv32-unknown-elf</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- riscv64-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""riscv64-elf"">" & ASCII.LF &
      "    <target>riscv64-elf</target>" & ASCII.LF &
      "    <target>riscv64-none-elf</target>" & ASCII.LF &
      "    <target>riscv64-unknown-elf</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-elf-.*  -->" & ASCII.LF &
      "  <targetset canonical=""x86-elf"">" & ASCII.LF &
      "    <target>x86-elf</target>" & ASCII.LF &
      "    <target>i686-elf</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- avr -->" & ASCII.LF &
      "  <targetset canonical=""avr-elf"">" & ASCII.LF &
      "    <target>avr-elf</target>" & ASCII.LF &
      "    <target>avr-elf-windows</target>" & ASCII.LF &
      "    <target>avr</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ia64-openvms -->" & ASCII.LF &
      "  <targetset canonical=""ia64-openvms"">" & ASCII.LF &
      "    <target>ia64-openvms</target>" & ASCII.LF &
      "    <target>ia64-.*-openvms</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm-android  -->" & ASCII.LF &
      "  <targetset canonical=""arm-android"">" & ASCII.LF &
      "    <target>arm-android</target>" & ASCII.LF &
      "    <target>arm-linux-androideabi</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- aarch64-android  -->" & ASCII.LF &
      "  <targetset canonical=""aarch64-android"">" & ASCII.LF &
      "    <target>aarch64-android</target>" & ASCII.LF &
      "    <target>aarch64-linux-android</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- aarch64-pikeos5  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""aarch64-pikeos5"">" & ASCII.LF &
      "    <target>aarch64-pikeos5</target>" & ASCII.LF &
      "    <target>aarch64-.*-pikeos5</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm-pikeos  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""arm-pikeos"">" & ASCII.LF &
      "    <target>arm-pikeos</target>" & ASCII.LF &
      "    <target>arm-.*-pikeos</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm-pikeos4.2  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""arm-pikeos4.2"">" & ASCII.LF &
      "    <target>arm-pikeos4.2</target>" & ASCII.LF &
      "    <target>arm-.*-pikeos4</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- arm-pikeos5  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""arm-pikeos5"">" & ASCII.LF &
      "    <target>arm-pikeos5</target>" & ASCII.LF &
      "    <target>arm-.*-pikeos5</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-pikeos  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""ppc-pikeos"">" & ASCII.LF &
      "    <target>ppc-pikeos</target>" & ASCII.LF &
      "    <target>powerpc-.*-pikeos</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- ppc-pikeos5  -->" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""ppc-pikeos5"">" & ASCII.LF &
      "    <target>ppc-pikeos5</target>" & ASCII.LF &
      "    <target>powerpc-.*-pikeos5</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- x86-pikeos  -->" & ASCII.LF &
      "  <targetset canonical=""x86-pikeos"">" & ASCII.LF &
      "    <target>x86-pikeos</target>" & ASCII.LF &
      "    <target>i.86-.*-pikeos</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <!-- C  -->" & ASCII.LF &
      "  <targetset canonical=""c"">" & ASCII.LF &
      "    <target>c</target>" & ASCII.LF &
      "    <target>ccg</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "  <targetset canonical=""codepeer"">" & ASCII.LF &
      "    <target>gnatsas</target>" & ASCII.LF &
      "    <target>codepeer</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("tricore-compilers.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "  <compiler_description>" & ASCII.LF &
      "    <name>TRICOREGCC</name>" & ASCII.LF &
      "    <executable>tricore-gcc</executable>" & ASCII.LF &
      "    <version>4.9.2</version>" & ASCII.LF &
      "    <languages>C</languages>" & ASCII.LF &
      "    <target>tricore</target>" & ASCII.LF &
      "  </compiler_description>" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("tricore-configuration.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <compilers>" & ASCII.LF &
      "      <compiler name=""TRICOREGCC""/>" & ASCII.LF &
      "    </compilers>" & ASCII.LF &
      "    <targets>" & ASCII.LF &
      "      <target name=""tricore""/>" & ASCII.LF &
      "    </targets>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver (""C"") use ""tricore-gcc"";" & ASCII.LF &
      "      for Leading_Required_Switches   (""C"") use" & ASCII.LF &
      "         (""-c"", ""-x"", ""c"") &amp; Compiler'Leading_Required_Switches (""C"");" & ASCII.LF &
      "      for Include_Switches        (""C"") use (""-I"");" & ASCII.LF &
      "      for Max_Command_Line_Length use ""8192"";" & ASCII.LF &
      "      for Response_File_Format    (""C"") use ""GCC_GNU"";" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("tricore-target.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "  <!-- tricore -->" & ASCII.LF &
      "  <targetset canonical='tricore'>" & ASCII.LF &
      "    <target>tricore</target>" & ASCII.LF &
      "  </targetset>" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("vxworks.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "  <!-- This file has been removed on 20170306. Replaced by an empty file" & ASCII.LF &
      "       for bootstrap: otherwise re-installing gprbuild on the same install" & ASCII.LF &
      "       location will not remove the old vxworks.xml. -->" & ASCII.LF &
      "  <configuration>" & ASCII.LF &
      "    <config>" & ASCII.LF &
      "    </config>" & ASCII.LF &
      "  </configuration>" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("windres.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "   <!--  This package provides the rules to handle Windows resource files -->" & ASCII.LF &
      "" & ASCII.LF &
      "   <configuration>" & ASCII.LF &
      "     <compilers>" & ASCII.LF &
      "       <compiler language=""WinRes"" />" & ASCII.LF &
      "     </compilers>" & ASCII.LF &
      "     <config>" & ASCII.LF &
      "   package Compiler is" & ASCII.LF &
      "      for Driver (""WinRes"") use ""${PREFIX(WinRes)}windres"";" & ASCII.LF &
      "      for Trailing_Required_Switches (""WinRes"") use (""-i"");" & ASCII.LF &
      "      for Object_File_Suffix (""WinRes"") use "".coff"";" & ASCII.LF &
      "      for Object_File_Switches (""WinRes"") use (""-o"", """");" & ASCII.LF &
      "   end Compiler;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Naming is" & ASCII.LF &
      "      for Body_Suffix (""WinRes"") use "".rc"";" & ASCII.LF &
      "   end Naming;" & ASCII.LF &
      "" & ASCII.LF &
      "   package Linker is" & ASCII.LF &
      "      for Unconditional_Linking (""WinRes"") use ""True"";" & ASCII.LF &
      "   end Linker;" & ASCII.LF &
      "" & ASCII.LF &
      "     </config>" & ASCII.LF &
      "   </configuration>" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("x86-vx6.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx6.ent SYSTEM ""vx6.ent""> %vx6.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'i586-wrs-vxworks'>" & ASCII.LF &
      "<!ENTITY this_gnu_wrs_suffix 'pentium'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6CERT$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6$"" />" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6CERT$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6$"" />" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS6CERT$"" />" & ASCII.LF &
      "       <compiler name=""^G\+\+-WRS6CERT$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x40000000'>" & ASCII.LF &
      "<!-- For vx6cert -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_cpu_subdir 'pentium/PENTIUM4/common'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx6;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("x86-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'i586-wrs-vxworks7'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x400000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("x86-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'i586-wrs-vxworks7r2'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^LLVMC-X86$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^LLVMC-X86$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x400000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("x86_64-vx7.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'x86_64-wrs-vxworks7'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86_64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC-WRS7X86_64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x200000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");

   Knowledge_Base.Include
     ("x86_64-vx7r2.xml",
      "<?xml version=""1.0"" ?>" & ASCII.LF &
      "<!DOCTYPE gprconfig [" & ASCII.LF &
      "<!ENTITY % env.ent SYSTEM ""env.ent""> %env.ent;" & ASCII.LF &
      "<!ENTITY % shortcuts.ent SYSTEM ""shortcuts.ent""> %shortcuts.ent;" & ASCII.LF &
      "<!ENTITY % vxworks.ent SYSTEM ""vxworks.ent""> %vxworks.ent;" & ASCII.LF &
      "<!ENTITY % vx7.ent SYSTEM ""vx7.ent""> %vx7.ent;" & ASCII.LF &
      "" & ASCII.LF &
      "<!-- Local target-specific conditions -->" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_target 'x86_64-wrs-vxworks7r2'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_c_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^GCC_Pro$"" />" & ASCII.LF &
      "       <compiler name=""^LLVMC-X86_64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_cpp_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^G\+\+_Pro$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY if_these_gnu_wrs_compilers" & ASCII.LF &
      "    '<compilers>" & ASCII.LF &
      "       <compiler name=""^LLVMC-X86_64$"" />" & ASCII.LF &
      "     </compilers>'>" & ASCII.LF &
      "" & ASCII.LF &
      "<!ENTITY this_wrs_rtp_base '0x200000'>" & ASCII.LF &
      "]>" & ASCII.LF &
      "<gprconfig>" & ASCII.LF &
      "" & ASCII.LF &
      "  &environment;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vxworks_gpp;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_vx7;" & ASCII.LF &
      "" & ASCII.LF &
      "  &configurations_gnat_ar;" & ASCII.LF &
      "" & ASCII.LF &
      "</gprconfig>");
end GPR2.KB.Embedded;
