#version 110
// Need to enable the draw buffers extension
#extension GL_ARB_draw_buffers : enable 

varying vec4 oColor;
varying vec2 oDepth;

vec4 pack(float value)
{
  vec4 shift = vec4(256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0);
  vec4 mask = vec4(0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);
  vec4 ret = fract(value * shift);
  ret -= ret.xxyz * mask;
  return ret.wzyx;
}

void main()
{
  gl_FragData[0] = oColor;
  gl_FragData[1] = pack(oDepth.x / oDepth.y);
}
