# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/Adelus clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "Adelus requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/Adelus build
## ---------------------------------------------------------------------------

set(Adelus_CXX_COMPILER "C:/M/msys64/clangarm64/bin/clang++.exe")

set(Adelus_C_COMPILER "C:/M/msys64/clangarm64/bin/clang.exe")

set(Adelus_Fortran_COMPILER "C:/M/msys64/clangarm64/bin/flang.exe")
# Deprecated!
set(Adelus_FORTRAN_COMPILER "C:/M/msys64/clangarm64/bin/flang.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/Adelus build
## ---------------------------------------------------------------------------

## Give the build type
set(Adelus_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(Adelus_CXX_FLAGS [[ ]])

set(Adelus_C_FLAGS [[-O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 ]])

set(Adelus_Fortran_FLAGS [[ ]])
# Deprecated
set(Adelus_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(Adelus_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(Adelus_SHARED_LIB_RPATH_COMMAND "/clangarm64/lib")
set(Adelus_BUILD_SHARED_LIBS "ON")

set(Adelus_LINKER C:/M/msys64/clangarm64/bin/ld.lld.exe)
set(Adelus_AR C:/M/msys64/clangarm64/bin/llvm-ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(Adelus_INSTALL_DIR "/clangarm64")

## List of package libraries
set(Adelus_LIBRARIES Adelus::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(Adelus_MPI_LIBRARIES "")
set(Adelus_MPI_LIBRARY_DIRS "")
set(Adelus_MPI_INCLUDE_DIRS "")
set(Adelus_MPI_EXEC "")
set(Adelus_MPI_EXEC_MAX_NUMPROCS "")
set(Adelus_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(Adelus_ENABLE_Kokkos ON)
set(Adelus_ENABLE_KokkosKernels ON)
set(Adelus_ENABLE_BLAS ON)

# Exported cache variables
set(Adelus_ENABLE_ZCPLX "ON")
set(Adelus_ENABLE_SCPLX "OFF")
set(Adelus_ENABLE_DREAL "OFF")
set(Adelus_ENABLE_SREAL "OFF")
set(Adelus_ENABLE_TIMING "OFF")
set(Adelus_ENABLE_HOSTPINNEDMEM "ON")
set(ADELUS_HOST_PINNED_MEM_MPI "ON")
set(Adelus_ENABLE_USEDEEPCOPY "OFF")
set(USE_DEEPCOPY "OFF")
set(Adelus_ENABLE_PRINTSTATUS "OFF")
set(PRINT_STATUS "OFF")

# Include configuration of dependent packages
if (NOT TARGET Kokkos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Kokkos/KokkosConfig.cmake")
endif()
if (NOT TARGET KokkosKernels::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../KokkosKernels/KokkosKernelsConfig.cmake")
endif()
if (NOT TARGET BLAS::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/BLAS/BLASConfig.cmake")
endif()

# Import Adelus targets
include("${CMAKE_CURRENT_LIST_DIR}/AdelusTargets.cmake")

# Standard TriBITS-compliant external package variables
set(Adelus_IS_TRIBITS_COMPLIANT TRUE)
set(Adelus_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(Adelus_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(Adelus_EXPORTED_PACKAGE_LIBS_NAMES "zadelus")

foreach(libname IN LISTS Adelus_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE Adelus::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'Adelus::${libname}', or better yet,"
      " 'Adelus::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'Adelus'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'Adelus_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
