/*
 * talkatu
 * Copyright (C) 2017-2020 Gary Kramlich <grim@reaperworld.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, see <https://www.gnu.org/licenses/>.
 */

#if !defined(TALKATU_GLOBAL_HEADER_INSIDE) && !defined(TALKATU_COMPILATION)
#error "only <talkatu.h> may be included directly"
#endif

#ifndef TALKATU_VERSION_H
#define TALKATU_VERSION_H

/**
 * TALKATU_MAJOR_VERSION:
 *
 * The major version of Talkatu that's being compiled against.
 */
#define TALKATU_MAJOR_VERSION (0)

/**
 * TALKATU_MINOR_VERSION:
 *
 * The minor version of Talkatu that's being compiled against.
 */
#define TALKATU_MINOR_VERSION (2)

/**
 * TALKATU_MICRO_VERSION:
 *
 * The micro version of Talkatu that's being compiled against.
 */
#define TALKATU_MICRO_VERSION (1)

/**
 * TALKATU_EXTRA_VERSION:
 *
 * The extra version if any of Talkatu that's being compiled against.
 */
#define TALKATU_EXTRA_VERSION "dev"

/**
 * TALKATU_VERSION:
 *
 * The full version of Talkatu that's being compiled against as a string.
 */
#define TALKATU_VERSION       "0.2.1-dev"

/**
 * TALKATU_VERSION_CHECK:
 * @major: The major version to check which must match.
 * @minor: The minimum minor version to check.
 * @micro: The minimum micro version to check.
 *
 * A simple macro that will return true if the version of Talkatu that's being
 * compiled against is newer than the provided version.
 */
#define TALKATU_VERSION_CHECK(major,minor,micro) \
	((major) == TALKATU_MAJOR_VERSION && \
	 ((minor) < TALKATU_MINOR_VERSION || \
	  ((minor) == TALKATU_MINOR_VERSION && (micro) <= TALKATU_MICRO_VERSION)))

#endif /* TALKATU_VERSION_H */
