/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public abstract class EntryFieldCommand
extends Command {
    protected Bib2Gls bib2gls;

    public EntryFieldCommand(String string, Bib2Gls bib2Gls) {
        super(string);
        this.bib2gls = bib2Gls;
    }

    protected Bib2GlsEntry fetchEntry(String string) throws IOException {
        GlsResource glsResource = this.bib2gls.getCurrentResource();
        Bib2GlsEntry bib2GlsEntry = glsResource.getEntry(string);
        if (bib2GlsEntry == null) {
            if (this.bib2gls.getDebugLevel() > 0) {
                this.bib2gls.debug(String.format("\\%s -> %s", this.getName(), this.bib2gls.getMessage("warning.unknown_entry_in_current_resource", string, glsResource)));
            }
            for (GlsResource glsResource2 : this.bib2gls.getResources()) {
                if (glsResource2 == glsResource || (bib2GlsEntry = glsResource2.getEntry(string)) == null) continue;
                if (this.bib2gls.getDebugLevel() <= 0) break;
                this.bib2gls.debug(String.format("\\%s -> %s", this.getName(), this.bib2gls.getMessage("message.found_entry_in_resource", string, glsResource2)));
                break;
            }
            if (bib2GlsEntry == null) {
                this.bib2gls.warning(String.format("\\%s -> %s", this.getName(), this.bib2gls.getMessage("warning.unknown_entry", string)));
            }
        }
        return bib2GlsEntry;
    }

    protected BibValueList getFieldBibList(TeXParser teXParser, Bib2GlsEntry bib2GlsEntry, String string) throws IOException {
        String string2 = string;
        BibValueList bibValueList = bib2GlsEntry.getField(string2);
        if (bibValueList == null && !(string2 = this.bib2gls.getFieldKey(string)).equals(string)) {
            bibValueList = bib2GlsEntry.getField(string2);
        }
        if (bibValueList == null) {
            bibValueList = bib2GlsEntry.getFallbackContents(string2);
        }
        if (bibValueList == null) {
            this.bib2gls.warning(String.format("\\%s{%s} -> %s", this.getName(), bib2GlsEntry.getId(), this.bib2gls.getMessage("message.field.not.set", string2)));
        }
        return bibValueList;
    }

    protected TeXObjectList getFieldValue(TeXParser teXParser, Bib2GlsEntry bib2GlsEntry, String string) throws IOException {
        BibValueList bibValueList = this.getFieldBibList(teXParser, bib2GlsEntry, string);
        if (bibValueList == null) {
            return null;
        }
        return ((BibValueList)bibValueList.clone()).expand(teXParser);
    }
}

