/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class PlayerTest
extends FreeColTestCase {
    private static final UnitType freeColonist = PlayerTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType galleonType = PlayerTest.spec().getUnitType("model.unit.galleon");

    public void testUnits() {
        Game game = PlayerTest.getStandardGame();
        Map map = PlayerTest.getTestMap(PlayerTest.spec().getTileType("model.tile.plains"));
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        map.getTile(4, 7).setExplored(dutch, true);
        map.getTile(4, 8).setExplored(dutch, true);
        map.getTile(5, 7).setExplored(dutch, true);
        map.getTile(5, 8).setExplored(dutch, true);
        UnitType freeColonist = PlayerTest.spec().getUnitType("model.unit.freeColonist");
        ServerUnit unit1 = new ServerUnit(game, map.getTile(4, 7), dutch, freeColonist);
        ServerUnit unit2 = new ServerUnit(game, map.getTile(4, 8), dutch, freeColonist);
        ServerUnit unit3 = new ServerUnit(game, map.getTile(5, 7), dutch, freeColonist);
        ServerUnit unit4 = new ServerUnit(game, map.getTile(5, 8), dutch, freeColonist);
        int count = CollectionUtils.count(dutch.getUnitSet());
        PlayerTest.assertTrue((count == 4 ? 1 : 0) != 0);
        unit1.dispose();
        PlayerTest.assertFalse((boolean)dutch.hasUnit(unit1));
        unit2.changeOwner(french);
        PlayerTest.assertFalse((boolean)dutch.hasUnit(unit2));
        PlayerTest.assertTrue((boolean)french.hasUnit(unit2));
    }

    public void testEuropeanPlayer(Player player) {
        PlayerTest.assertTrue((boolean)player.canBuildColonies());
        PlayerTest.assertTrue((boolean)player.canHaveFoundingFathers());
        PlayerTest.assertTrue((boolean)player.canMoveToEurope());
        PlayerTest.assertTrue((boolean)player.isColonial());
        PlayerTest.assertFalse((boolean)player.isDead());
        PlayerTest.assertTrue((boolean)player.isEuropean());
        PlayerTest.assertFalse((boolean)player.isIndian());
        PlayerTest.assertFalse((boolean)player.isREF());
        PlayerTest.assertEquals((int)2, (int)player.getMaximumFoodConsumption());
    }

    public void testIndianPlayer(Player player) {
        PlayerTest.assertFalse((boolean)player.canBuildColonies());
        PlayerTest.assertFalse((boolean)player.canHaveFoundingFathers());
        PlayerTest.assertFalse((boolean)player.canMoveToEurope());
        PlayerTest.assertFalse((boolean)player.isColonial());
        PlayerTest.assertFalse((boolean)player.isDead());
        PlayerTest.assertFalse((boolean)player.isEuropean());
        PlayerTest.assertTrue((boolean)player.isIndian());
        PlayerTest.assertFalse((boolean)player.isREF());
        PlayerTest.assertEquals((int)2, (int)player.getMaximumFoodConsumption());
    }

    public void testRoyalPlayer(Player player) {
        PlayerTest.assertFalse((boolean)player.canBuildColonies());
        PlayerTest.assertFalse((boolean)player.canHaveFoundingFathers());
        PlayerTest.assertTrue((boolean)player.canMoveToEurope());
        PlayerTest.assertFalse((boolean)player.isColonial());
        PlayerTest.assertEquals((Object)((Object)player.getPlayerType()), (Object)((Object)Player.PlayerType.ROYAL));
        PlayerTest.assertFalse((boolean)player.isDead());
        PlayerTest.assertTrue((boolean)player.isEuropean());
        PlayerTest.assertFalse((boolean)player.isIndian());
        PlayerTest.assertTrue((boolean)player.isREF());
        PlayerTest.assertEquals((int)2, (int)player.getMaximumFoodConsumption());
    }

    public void testClassicPlayers() {
        Game game = PlayerTest.getStandardGame("classic");
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        Player english = game.getPlayerByNationId("model.nation.english");
        Player spanish = game.getPlayerByNationId("model.nation.spanish");
        this.testEuropeanPlayer(dutch);
        this.testEuropeanPlayer(french);
        this.testEuropeanPlayer(english);
        this.testEuropeanPlayer(spanish);
        Player inca = game.getPlayerByNationId("model.nation.inca");
        Player aztec = game.getPlayerByNationId("model.nation.aztec");
        Player arawak = game.getPlayerByNationId("model.nation.arawak");
        Player cherokee = game.getPlayerByNationId("model.nation.cherokee");
        Player iroquois = game.getPlayerByNationId("model.nation.iroquois");
        Player sioux = game.getPlayerByNationId("model.nation.sioux");
        Player apache = game.getPlayerByNationId("model.nation.apache");
        Player tupi = game.getPlayerByNationId("model.nation.tupi");
        this.testIndianPlayer(inca);
        this.testIndianPlayer(aztec);
        this.testIndianPlayer(arawak);
        this.testIndianPlayer(cherokee);
        this.testIndianPlayer(iroquois);
        this.testIndianPlayer(sioux);
        this.testIndianPlayer(apache);
        this.testIndianPlayer(tupi);
        Player dutchREF = game.getPlayerByNationId("model.nation.dutchREF");
        Player frenchREF = game.getPlayerByNationId("model.nation.frenchREF");
        Player englishREF = game.getPlayerByNationId("model.nation.englishREF");
        Player spanishREF = game.getPlayerByNationId("model.nation.spanishREF");
        this.testRoyalPlayer(dutchREF);
        this.testRoyalPlayer(frenchREF);
        this.testRoyalPlayer(englishREF);
        this.testRoyalPlayer(spanishREF);
        PlayerTest.assertEquals((Object)dutchREF, (Object)dutch.getREFPlayer());
        PlayerTest.assertEquals((Object)frenchREF, (Object)french.getREFPlayer());
        PlayerTest.assertEquals((Object)englishREF, (Object)english.getREFPlayer());
        PlayerTest.assertEquals((Object)spanishREF, (Object)spanish.getREFPlayer());
    }

    public void testFreecolPlayers() {
        Game game = PlayerTest.getStandardGame();
        Specification specification = game.getSpecification();
        NationOptions nationOptions = new NationOptions(specification);
        for (Nation nation : specification.getEuropeanNations()) {
            nationOptions.setNationState(nation, NationOptions.NationState.AVAILABLE);
        }
        game.setNationOptions(nationOptions);
        specification.applyDifficultyLevel("model.difficulty.medium");
        for (Nation n : specification.getNations()) {
            if (n.isUnknownEnemy()) continue;
            ServerPlayer p = new ServerPlayer(game, false, n);
            p.setAI(!n.getType().isEuropean() || n.getType().isREF());
            game.addPlayer(p);
        }
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        Player english = game.getPlayerByNationId("model.nation.english");
        Player spanish = game.getPlayerByNationId("model.nation.spanish");
        Player portuguese = game.getPlayerByNationId("model.nation.portuguese");
        Player swedish = game.getPlayerByNationId("model.nation.swedish");
        Player danish = game.getPlayerByNationId("model.nation.danish");
        Player russian = game.getPlayerByNationId("model.nation.russian");
        this.testEuropeanPlayer(dutch);
        this.testEuropeanPlayer(french);
        this.testEuropeanPlayer(english);
        this.testEuropeanPlayer(spanish);
        this.testEuropeanPlayer(portuguese);
        this.testEuropeanPlayer(swedish);
        this.testEuropeanPlayer(danish);
        this.testEuropeanPlayer(russian);
        Player inca = game.getPlayerByNationId("model.nation.inca");
        Player aztec = game.getPlayerByNationId("model.nation.aztec");
        Player arawak = game.getPlayerByNationId("model.nation.arawak");
        Player cherokee = game.getPlayerByNationId("model.nation.cherokee");
        Player iroquois = game.getPlayerByNationId("model.nation.iroquois");
        Player sioux = game.getPlayerByNationId("model.nation.sioux");
        Player apache = game.getPlayerByNationId("model.nation.apache");
        Player tupi = game.getPlayerByNationId("model.nation.tupi");
        this.testIndianPlayer(inca);
        this.testIndianPlayer(aztec);
        this.testIndianPlayer(arawak);
        this.testIndianPlayer(cherokee);
        this.testIndianPlayer(iroquois);
        this.testIndianPlayer(sioux);
        this.testIndianPlayer(apache);
        this.testIndianPlayer(tupi);
        Player dutchREF = game.getPlayerByNationId("model.nation.dutchREF");
        Player frenchREF = game.getPlayerByNationId("model.nation.frenchREF");
        Player englishREF = game.getPlayerByNationId("model.nation.englishREF");
        Player spanishREF = game.getPlayerByNationId("model.nation.spanishREF");
        Player portugueseREF = game.getPlayerByNationId("model.nation.portugueseREF");
        Player swedishREF = game.getPlayerByNationId("model.nation.swedishREF");
        Player danishREF = game.getPlayerByNationId("model.nation.danishREF");
        Player russianREF = game.getPlayerByNationId("model.nation.russianREF");
        this.testRoyalPlayer(dutchREF);
        this.testRoyalPlayer(frenchREF);
        this.testRoyalPlayer(englishREF);
        this.testRoyalPlayer(spanishREF);
        this.testRoyalPlayer(portugueseREF);
        this.testRoyalPlayer(swedishREF);
        this.testRoyalPlayer(danishREF);
        this.testRoyalPlayer(russianREF);
        PlayerTest.assertEquals((Object)dutchREF, (Object)dutch.getREFPlayer());
        PlayerTest.assertEquals((Object)frenchREF, (Object)french.getREFPlayer());
        PlayerTest.assertEquals((Object)englishREF, (Object)english.getREFPlayer());
        PlayerTest.assertEquals((Object)spanishREF, (Object)spanish.getREFPlayer());
        PlayerTest.assertEquals((Object)portugueseREF, (Object)portuguese.getREFPlayer());
        PlayerTest.assertEquals((Object)swedishREF, (Object)swedish.getREFPlayer());
        PlayerTest.assertEquals((Object)danishREF, (Object)danish.getREFPlayer());
        PlayerTest.assertEquals((Object)russianREF, (Object)russian.getREFPlayer());
    }

    public void testTension() {
        Game game = PlayerTest.getStandardGame();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        int initialTension = 500;
        int change = 250;
        dutch.setTension(french, new Tension(initialTension));
        french.setTension(dutch, new Tension(initialTension));
        dutch.getTension(french).modify(change);
        int expectedDutchTension = initialTension + change;
        int expectedFrenchTension = initialTension;
        PlayerTest.assertEquals((String)"Dutch tension value should have changed", (int)expectedDutchTension, (int)dutch.getTension(french).getValue());
        PlayerTest.assertEquals((String)"French tension value should have remained the same", (int)expectedFrenchTension, (int)french.getTension(dutch).getValue());
    }

    public void testAddAnotherPlayersUnit() {
        Game game = PlayerTest.getStandardGame();
        Map map = PlayerTest.getTestMap();
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        PlayerTest.assertEquals((String)"Wrong number of units for dutch player", (int)0, (int)dutch.getUnitCount());
        PlayerTest.assertEquals((String)"Wrong number of units for french player", (int)0, (int)french.getUnitCount());
        ServerUnit colonist = new ServerUnit(game, map.getTile(6, 8), dutch, freeColonist);
        PlayerTest.assertTrue((String)"Colonist should be dutch", (colonist.getOwner() == dutch ? 1 : 0) != 0);
        PlayerTest.assertEquals((String)"Wrong number of units for dutch player", (int)1, (int)dutch.getUnitCount());
        try {
            french.addUnit(colonist);
            PlayerTest.fail((String)"An IllegalStateException should have been raised");
        }
        catch (IllegalStateException e) {
            PlayerTest.assertEquals((String)"Colonist owner should not have been changed", (Object)dutch, (Object)colonist.getOwner());
            PlayerTest.assertEquals((String)"Wrong number of units for dutch player", (int)1, (int)dutch.getUnitCount());
            PlayerTest.assertEquals((String)"Wrong number of units for french player", (int)0, (int)french.getUnitCount());
        }
    }
}

