/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant.jmx;

import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.catalina.ant.jmx.JMXAccessorTask;
import org.apache.tools.ant.BuildException;

public class JMXAccessorQueryTask
extends JMXAccessorTask {
    private boolean attributebinding = false;

    public boolean isAttributebinding() {
        return this.attributebinding;
    }

    public void setAttributebinding(boolean bl) {
        this.attributebinding = bl;
    }

    @Override
    public String jmxExecute(MBeanServerConnection mBeanServerConnection) throws Exception {
        if (this.getName() == null) {
            throw new BuildException("Must specify a 'name'");
        }
        return this.jmxQuery(mBeanServerConnection, this.getName());
    }

    protected String jmxQuery(MBeanServerConnection mBeanServerConnection, String string) {
        Set<ObjectName> set;
        String string2 = this.getResultproperty();
        try {
            set = mBeanServerConnection.queryNames(new ObjectName(string), null);
            if (string2 != null) {
                this.setProperty(string2 + ".Length", Integer.toString(set.size()));
            }
        }
        catch (Exception exception) {
            if (this.isEcho()) {
                this.handleErrorOutput(exception.getMessage());
            }
            return "Can't query mbeans " + string;
        }
        if (string2 != null) {
            int n = 0;
            for (ObjectName objectName : set) {
                String string3 = string2 + "." + Integer.toString(n) + ".";
                ++n;
                this.setProperty(string3 + "Name", objectName.toString());
                if (!this.isAttributebinding()) continue;
                this.bindAttributes(mBeanServerConnection, string3, objectName);
            }
        }
        return null;
    }

    protected void bindAttributes(MBeanServerConnection mBeanServerConnection, String string, ObjectName objectName) {
        try {
            MBeanAttributeInfo[] mBeanAttributeInfoArray;
            MBeanInfo mBeanInfo = mBeanServerConnection.getMBeanInfo(objectName);
            for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray = mBeanInfo.getAttributes()) {
                Object object;
                String string2;
                if (!mBeanAttributeInfo.isReadable() || (string2 = mBeanAttributeInfo.getName()).indexOf(61) >= 0 || string2.indexOf(58) >= 0 || string2.indexOf(32) >= 0) continue;
                try {
                    object = mBeanServerConnection.getAttribute(objectName, string2);
                }
                catch (Exception exception) {
                    if (!this.isEcho()) continue;
                    this.handleErrorOutput("Error getting attribute " + objectName + " " + string + string2 + " " + exception.toString());
                    continue;
                }
                if (object == null || "modelerType".equals(string2)) continue;
                this.createProperty(string + string2, object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

