/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;

public class Jdbc41Bridge {
    public static void abort(Connection connection, Executor executor) throws SQLException {
        try {
            connection.abort(executor);
        }
        catch (AbstractMethodError abstractMethodError) {
            connection.close();
        }
    }

    public static void closeOnCompletion(Statement statement) throws SQLException {
        block2: {
            try {
                statement.closeOnCompletion();
            }
            catch (AbstractMethodError abstractMethodError) {
                if (!statement.isClosed()) break block2;
                throw new SQLException("Statement closed");
            }
        }
    }

    public static boolean generatedKeyAlwaysReturned(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return databaseMetaData.generatedKeyAlwaysReturned();
        }
        catch (AbstractMethodError abstractMethodError) {
            return false;
        }
    }

    public static int getNetworkTimeout(Connection connection) throws SQLException {
        try {
            return connection.getNetworkTimeout();
        }
        catch (AbstractMethodError abstractMethodError) {
            return 0;
        }
    }

    public static <T> T getObject(ResultSet resultSet, int n, Class<T> clazz) throws SQLException {
        try {
            return resultSet.getObject(n, clazz);
        }
        catch (AbstractMethodError abstractMethodError) {
            if (clazz == String.class) {
                return (T)resultSet.getString(n);
            }
            if (clazz == Integer.class) {
                return (T)Integer.valueOf(resultSet.getInt(n));
            }
            if (clazz == Long.class) {
                return (T)Long.valueOf(resultSet.getLong(n));
            }
            if (clazz == Double.class) {
                return (T)Double.valueOf(resultSet.getDouble(n));
            }
            if (clazz == Float.class) {
                return (T)Float.valueOf(resultSet.getFloat(n));
            }
            if (clazz == Short.class) {
                return (T)Short.valueOf(resultSet.getShort(n));
            }
            if (clazz == BigDecimal.class) {
                return (T)resultSet.getBigDecimal(n);
            }
            if (clazz == Byte.class) {
                return (T)Byte.valueOf(resultSet.getByte(n));
            }
            if (clazz == Date.class) {
                return (T)resultSet.getDate(n);
            }
            if (clazz == Time.class) {
                return (T)resultSet.getTime(n);
            }
            if (clazz == Timestamp.class) {
                return (T)resultSet.getTimestamp(n);
            }
            if (clazz == InputStream.class) {
                return (T)resultSet.getBinaryStream(n);
            }
            if (clazz == Reader.class) {
                return (T)resultSet.getCharacterStream(n);
            }
            if (clazz == Object.class) {
                return (T)resultSet.getObject(n);
            }
            if (clazz == Boolean.class) {
                return (T)Boolean.valueOf(resultSet.getBoolean(n));
            }
            if (clazz == Array.class) {
                return (T)resultSet.getArray(n);
            }
            if (clazz == Blob.class) {
                return (T)resultSet.getBlob(n);
            }
            if (clazz == Clob.class) {
                return (T)resultSet.getClob(n);
            }
            if (clazz == Ref.class) {
                return (T)resultSet.getRef(n);
            }
            if (clazz == RowId.class) {
                return (T)resultSet.getRowId(n);
            }
            if (clazz == SQLXML.class) {
                return (T)resultSet.getSQLXML(n);
            }
            if (clazz == URL.class) {
                return (T)resultSet.getURL(n);
            }
            throw new SQLFeatureNotSupportedException(String.format("resultSet=%s, columnIndex=%,d, type=%s", resultSet, n, clazz));
        }
    }

    public static <T> T getObject(ResultSet resultSet, String string, Class<T> clazz) throws SQLException {
        try {
            return resultSet.getObject(string, clazz);
        }
        catch (AbstractMethodError abstractMethodError) {
            if (clazz == Integer.class) {
                return (T)Integer.valueOf(resultSet.getInt(string));
            }
            if (clazz == Long.class) {
                return (T)Long.valueOf(resultSet.getLong(string));
            }
            if (clazz == Double.class) {
                return (T)Double.valueOf(resultSet.getDouble(string));
            }
            if (clazz == Float.class) {
                return (T)Float.valueOf(resultSet.getFloat(string));
            }
            if (clazz == Short.class) {
                return (T)Short.valueOf(resultSet.getShort(string));
            }
            if (clazz == BigDecimal.class) {
                return (T)resultSet.getBigDecimal(string);
            }
            if (clazz == Byte.class) {
                return (T)Byte.valueOf(resultSet.getByte(string));
            }
            if (clazz == Date.class) {
                return (T)resultSet.getDate(string);
            }
            if (clazz == Time.class) {
                return (T)resultSet.getTime(string);
            }
            if (clazz == Timestamp.class) {
                return (T)resultSet.getTimestamp(string);
            }
            if (clazz == InputStream.class) {
                return (T)resultSet.getBinaryStream(string);
            }
            if (clazz == Reader.class) {
                return (T)resultSet.getCharacterStream(string);
            }
            if (clazz == Object.class) {
                return (T)resultSet.getObject(string);
            }
            if (clazz == Boolean.class) {
                return (T)Boolean.valueOf(resultSet.getBoolean(string));
            }
            if (clazz == Array.class) {
                return (T)resultSet.getArray(string);
            }
            if (clazz == Blob.class) {
                return (T)resultSet.getBlob(string);
            }
            if (clazz == Clob.class) {
                return (T)resultSet.getClob(string);
            }
            if (clazz == Ref.class) {
                return (T)resultSet.getRef(string);
            }
            if (clazz == RowId.class) {
                return (T)resultSet.getRowId(string);
            }
            if (clazz == SQLXML.class) {
                return (T)resultSet.getSQLXML(string);
            }
            if (clazz == URL.class) {
                return (T)resultSet.getURL(string);
            }
            throw new SQLFeatureNotSupportedException(String.format("resultSet=%s, columnLabel=%s, type=%s", resultSet, string, clazz));
        }
    }

    public static Logger getParentLogger(CommonDataSource commonDataSource) throws SQLFeatureNotSupportedException {
        try {
            return commonDataSource.getParentLogger();
        }
        catch (AbstractMethodError abstractMethodError) {
            throw new SQLFeatureNotSupportedException("javax.sql.CommonDataSource#getParentLogger()");
        }
    }

    public static ResultSet getPseudoColumns(DatabaseMetaData databaseMetaData, String string, String string2, String string3, String string4) throws SQLException {
        try {
            return databaseMetaData.getPseudoColumns(string, string2, string3, string4);
        }
        catch (AbstractMethodError abstractMethodError) {
            return null;
        }
    }

    public static String getSchema(Connection connection) throws SQLException {
        try {
            return connection.getSchema();
        }
        catch (AbstractMethodError abstractMethodError) {
            return null;
        }
    }

    public static boolean isCloseOnCompletion(Statement statement) throws SQLException {
        try {
            return statement.isCloseOnCompletion();
        }
        catch (AbstractMethodError abstractMethodError) {
            if (statement.isClosed()) {
                throw new SQLException("Statement closed");
            }
            return false;
        }
    }

    public static void setNetworkTimeout(Connection connection, Executor executor, int n) throws SQLException {
        try {
            connection.setNetworkTimeout(executor, n);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public static void setSchema(Connection connection, String string) throws SQLException {
        try {
            connection.setSchema(string);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }
}

