/* Copyright 2019, NVIDIA CORPORATION. All rights reserved. */

/* NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited. */

#ifndef _PGI_ALLOCA_H
#define _PGI_ALLOCA_H

#include_next <alloca.h>

#ifndef alloca
# define alloca(size) __builtin_alloca(size)
#endif

/* PGI ADDITION: __alloca() in addition to alloca() */

#undef __alloca

#ifdef __cplusplus
extern "C" {
#endif
extern void* __alloca(size_t);
#ifndef __EDG__
extern void* __builtin_alloca(size_t);
#endif
#ifdef __cplusplus
}
#endif

#define __alloca(size) __builtin_alloca(size)

#endif
