/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.message2;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.python.icu.message2.DateTimeFormatterFactory;
import org.python.icu.message2.FormattedPlaceholder;
import org.python.icu.message2.Formatter;
import org.python.icu.message2.FormatterFactory;
import org.python.icu.message2.IdentityFormatterFactory;
import org.python.icu.message2.MFDataModel;
import org.python.icu.message2.MFFunctionRegistry;
import org.python.icu.message2.NumberFormatterFactory;
import org.python.icu.message2.OptUtils;
import org.python.icu.message2.PlainStringFormattedValue;
import org.python.icu.message2.Selector;
import org.python.icu.message2.SelectorFactory;
import org.python.icu.message2.TextSelectorFactory;
import org.python.icu.util.CurrencyAmount;

class MFDataModelFormatter {
    private final Locale locale;
    private final MFDataModel.Message dm;
    private final MFFunctionRegistry standardFunctions;
    private final MFFunctionRegistry customFunctions;
    private static final MFFunctionRegistry EMPTY_REGISTY = MFFunctionRegistry.builder().build();

    MFDataModelFormatter(MFDataModel.Message dm, Locale locale, MFFunctionRegistry customFunctionRegistry) {
        this.locale = locale;
        this.dm = dm;
        this.customFunctions = customFunctionRegistry == null ? EMPTY_REGISTY : customFunctionRegistry;
        this.standardFunctions = MFFunctionRegistry.builder().setFormatter("datetime", new DateTimeFormatterFactory("datetime")).setFormatter("date", new DateTimeFormatterFactory("date")).setFormatter("time", new DateTimeFormatterFactory("time")).setDefaultFormatterNameForType(Date.class, "datetime").setDefaultFormatterNameForType(org.python.icu.util.Calendar.class, "datetime").setDefaultFormatterNameForType(Calendar.class, "datetime").setFormatter("number", new NumberFormatterFactory("number")).setFormatter("integer", new NumberFormatterFactory("integer")).setDefaultFormatterNameForType(Integer.class, "number").setDefaultFormatterNameForType(Double.class, "number").setDefaultFormatterNameForType(Number.class, "number").setDefaultFormatterNameForType(CurrencyAmount.class, "number").setFormatter("string", new IdentityFormatterFactory()).setDefaultFormatterNameForType(String.class, "string").setDefaultFormatterNameForType(CharSequence.class, "string").setSelector("number", new NumberFormatterFactory("number")).setSelector("integer", new NumberFormatterFactory("integer")).setSelector("string", new TextSelectorFactory()).setSelector("icu:gender", new TextSelectorFactory()).build();
    }

    String format(Map<String, Object> arguments2) {
        Map<String, Object> variables;
        MFDataModel.Pattern patternToRender = null;
        if (arguments2 == null) {
            arguments2 = new HashMap<String, Object>();
        }
        if (this.dm instanceof MFDataModel.PatternMessage) {
            MFDataModel.PatternMessage pm = (MFDataModel.PatternMessage)this.dm;
            variables = this.resolveDeclarations(pm.declarations, arguments2);
            patternToRender = pm.pattern;
        } else if (this.dm instanceof MFDataModel.SelectMessage) {
            MFDataModel.SelectMessage sm = (MFDataModel.SelectMessage)this.dm;
            variables = this.resolveDeclarations(sm.declarations, arguments2);
            patternToRender = this.findBestMatchingPattern(sm, variables, arguments2);
        } else {
            MFDataModelFormatter.formattingError("");
            return "ERROR!";
        }
        if (patternToRender == null) {
            return "ERROR!";
        }
        StringBuilder result = new StringBuilder();
        for (MFDataModel.PatternPart part : patternToRender.parts) {
            if (part instanceof MFDataModel.StringPart) {
                MFDataModel.StringPart strPart = (MFDataModel.StringPart)part;
                result.append(strPart.value);
                continue;
            }
            if (part instanceof MFDataModel.Expression) {
                FormattedPlaceholder formattedExpression = this.formatExpression((MFDataModel.Expression)part, variables, arguments2);
                result.append(formattedExpression.getFormattedValue().toString());
                continue;
            }
            if (part instanceof MFDataModel.Markup || part instanceof MFDataModel.UnsupportedExpression) continue;
            MFDataModelFormatter.formattingError("Unknown part type: " + part);
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private MFDataModel.Pattern findBestMatchingPattern(MFDataModel.SelectMessage sm, Map<String, Object> variables, Map<String, Object> arguments2) {
        void var11_37;
        MFDataModel.Pattern patternToRender = null;
        List<MFDataModel.Expression> selectors = sm.selectors;
        ArrayList<ResolvedSelector> res = new ArrayList<ResolvedSelector>(selectors.size());
        for (MFDataModel.Expression sel : selectors) {
            void var10_12;
            FormattedPlaceholder fph = this.formatExpression(sel, variables, arguments2);
            Object var10_13 = null;
            Object var11_26 = null;
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (fph.getInput() instanceof ResolvedExpression) {
                ResolvedExpression re = (ResolvedExpression)fph.getInput();
                Object object = re.argument;
                String string = re.functionName;
                options.putAll(re.options);
            } else if (fph.getInput() instanceof MFDataModel.VariableExpression) {
                MFDataModel.VariableExpression ve = (MFDataModel.VariableExpression)fph.getInput();
                Object object = MFDataModelFormatter.resolveLiteralOrVariable(ve.arg, variables, arguments2);
                if (ve.annotation instanceof MFDataModel.FunctionAnnotation) {
                    String string = ((MFDataModel.FunctionAnnotation)ve.annotation).name;
                }
            } else if (fph.getInput() instanceof MFDataModel.LiteralExpression) {
                MFDataModel.LiteralExpression le = (MFDataModel.LiteralExpression)fph.getInput();
                MFDataModel.Literal literal = le.arg;
                if (le.annotation instanceof MFDataModel.FunctionAnnotation) {
                    String string = ((MFDataModel.FunctionAnnotation)le.annotation).name;
                }
            }
            SelectorFactory funcFactory = this.standardFunctions.getSelector((String)var10_12);
            if (funcFactory == null) {
                funcFactory = this.customFunctions.getSelector((String)var10_12);
            }
            if (funcFactory != null) {
                void var11_25;
                Selector selectorFunction = funcFactory.createSelector(this.locale, options);
                ResolvedSelector rs = new ResolvedSelector(var11_25, options, selectorFunction);
                res.add(rs);
                continue;
            }
            throw new IllegalArgumentException("Unknown selector type: " + (String)var10_12);
        }
        if (res.size() != selectors.size()) {
            throw new IllegalArgumentException("Something went wrong, not enough selector functions, " + res.size() + " vs. " + selectors.size());
        }
        ArrayList<List<String>> pref = new ArrayList<List<String>>();
        for (int i = 0; i < res.size(); ++i) {
            ArrayList keys = new ArrayList();
            for (MFDataModel.Variant variant : sm.variants) {
                MFDataModel.LiteralOrCatchallKey key = variant.keys.get(i);
                if (key instanceof MFDataModel.CatchallKey) {
                    keys.add("*");
                    continue;
                }
                if (key instanceof MFDataModel.Literal) {
                    String ks = ((MFDataModel.Literal)key).value;
                    keys.add(ks);
                    continue;
                }
                MFDataModelFormatter.formattingError("Literal expected, but got " + key);
            }
            ResolvedSelector resolvedSelector = (ResolvedSelector)res.get(i);
            List<String> list = this.matchSelectorKeys(resolvedSelector, keys);
            pref.add(list);
        }
        ArrayList<MFDataModel.Variant> vars = new ArrayList<MFDataModel.Variant>();
        for (MFDataModel.Variant variant : sm.variants) {
            int n = 0;
            for (int i = 0; i < pref.size(); ++i) {
                MFDataModel.LiteralOrCatchallKey key = variant.keys.get(i);
                if (key instanceof MFDataModel.CatchallKey) {
                    ++n;
                    continue;
                }
                if (!(key instanceof MFDataModel.Literal)) {
                    MFDataModelFormatter.formattingError("Literal expected");
                }
                String ks = ((MFDataModel.Literal)key).value;
                List matches = (List)pref.get(i);
                if (!matches.contains(ks)) break;
                ++n;
            }
            if (n != pref.size()) continue;
            vars.add(variant);
        }
        ArrayList<IntVarTuple> sortable = new ArrayList<IntVarTuple>();
        for (MFDataModel.Variant variant : vars) {
            IntVarTuple tuple = new IntVarTuple(-1, variant);
            sortable.add(tuple);
        }
        int n = pref.size();
        int n2 = n - 1;
        while (var11_37 >= 0) {
            List matches = (List)pref.get((int)var11_37);
            int minpref = matches.size();
            for (IntVarTuple tuple : sortable) {
                int matchpref = minpref;
                MFDataModel.LiteralOrCatchallKey key = tuple.variant.keys.get((int)var11_37);
                if (!(key instanceof MFDataModel.CatchallKey)) {
                    if (!(key instanceof MFDataModel.Literal)) {
                        MFDataModelFormatter.formattingError("Literal expected");
                    }
                    String ks = ((MFDataModel.Literal)key).value;
                    matchpref = matches.indexOf(ks);
                }
                tuple.integer = matchpref;
            }
            sortable.sort(MFDataModelFormatter::sortVariants);
            --var11_37;
        }
        IntVarTuple var = (IntVarTuple)sortable.get(0);
        patternToRender = var.variant.value;
        if (patternToRender == null) {
            throw new IllegalArgumentException("The selection went wrong, cannot select any option.");
        }
        return patternToRender;
    }

    private static int sortVariants(IntVarTuple o1, IntVarTuple o2) {
        int result = Integer.compare(o1.integer, o2.integer);
        if (result != 0) {
            return result;
        }
        List<MFDataModel.LiteralOrCatchallKey> v1 = o1.variant.keys;
        List<MFDataModel.LiteralOrCatchallKey> v2 = o1.variant.keys;
        if (v1.size() != v2.size()) {
            MFDataModelFormatter.formattingError("The number of keys is not equal.");
        }
        for (int i = 0; i < v1.size(); ++i) {
            MFDataModel.LiteralOrCatchallKey k2;
            String s2;
            MFDataModel.LiteralOrCatchallKey k1 = v1.get(i);
            String s1 = k1 instanceof MFDataModel.Literal ? ((MFDataModel.Literal)k1).value : "*";
            int cmp = s1.compareTo(s2 = (k2 = v2.get(i)) instanceof MFDataModel.Literal ? ((MFDataModel.Literal)k2).value : "*");
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private List<String> matchSelectorKeys(ResolvedSelector rv, List<String> keys) {
        return rv.selectorFunction.matches(rv.argument, keys, rv.options);
    }

    private static void formattingError(String message) {
        throw new IllegalArgumentException(message);
    }

    private FormatterFactory getFormattingFunctionFactoryByName(Object toFormat, String functionName) {
        FormatterFactory func;
        if (functionName == null || functionName.isEmpty()) {
            if (toFormat == null) {
                return null;
            }
            Class<?> clazz = toFormat.getClass();
            functionName = this.standardFunctions.getDefaultFormatterNameForType(clazz);
            if (functionName == null) {
                functionName = this.customFunctions.getDefaultFormatterNameForType(clazz);
            }
            if (functionName == null) {
                throw new IllegalArgumentException("Object to format without a function, and unknown type: " + toFormat.getClass().getName());
            }
        }
        if ((func = this.standardFunctions.getFormatter(functionName)) == null) {
            func = this.customFunctions.getFormatter(functionName);
        }
        return func;
    }

    private static Object resolveLiteralOrVariable(MFDataModel.LiteralOrVariableRef value, Map<String, Object> localVars, Map<String, Object> arguments2) {
        if (value instanceof MFDataModel.Literal) {
            String val = ((MFDataModel.Literal)value).value;
            Number nr = OptUtils.asNumber(val);
            if (nr != null) {
                return nr;
            }
            return val;
        }
        if (value instanceof MFDataModel.VariableRef) {
            String varName = ((MFDataModel.VariableRef)value).name;
            Object val = localVars.get(varName);
            if (val == null) {
                val = localVars.get(varName);
            }
            if (val == null) {
                val = arguments2.get(varName);
            }
            return val;
        }
        return value;
    }

    private static Map<String, Object> convertOptions(Map<String, MFDataModel.Option> options, Map<String, Object> localVars, Map<String, Object> arguments2) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (MFDataModel.Option option : options.values()) {
            result.put(option.name, MFDataModelFormatter.resolveLiteralOrVariable(option.value, localVars, arguments2));
        }
        return result;
    }

    private FormattedPlaceholder formatExpression(MFDataModel.Expression expression, Map<String, Object> variables, Map<String, Object> arguments2) {
        MFDataModel.Annotation annotation = null;
        String functionName = null;
        Object toFormat = null;
        HashMap<String, Object> options = new HashMap<String, Object>();
        String fallbackString = "{\ufffd}";
        if (expression instanceof MFDataModel.VariableExpression) {
            MFDataModel.VariableExpression varPart = (MFDataModel.VariableExpression)expression;
            fallbackString = "{$" + varPart.arg.name + "}";
            annotation = varPart.annotation;
            Object resolved = MFDataModelFormatter.resolveLiteralOrVariable(varPart.arg, variables, arguments2);
            if (resolved instanceof FormattedPlaceholder) {
                Object input = ((FormattedPlaceholder)resolved).getInput();
                if (input instanceof ResolvedExpression) {
                    ResolvedExpression re = (ResolvedExpression)input;
                    toFormat = re.argument;
                    functionName = re.functionName;
                    options.putAll(re.options);
                } else {
                    toFormat = input;
                }
            } else {
                toFormat = resolved;
            }
        } else if (expression instanceof MFDataModel.FunctionExpression) {
            MFDataModel.FunctionExpression fe = (MFDataModel.FunctionExpression)expression;
            fallbackString = "{:" + fe.annotation.name + "}";
            annotation = fe.annotation;
        } else if (expression instanceof MFDataModel.LiteralExpression) {
            MFDataModel.LiteralExpression le = (MFDataModel.LiteralExpression)expression;
            annotation = le.annotation;
            fallbackString = "{|" + le.arg.value + "|}";
            toFormat = MFDataModelFormatter.resolveLiteralOrVariable(le.arg, variables, arguments2);
        } else {
            if (expression instanceof MFDataModel.Markup) {
                return new FormattedPlaceholder(expression, new PlainStringFormattedValue(""));
            }
            MFDataModel.UnsupportedExpression ue = (MFDataModel.UnsupportedExpression)expression;
            char sigil = ue.annotation.source.charAt(0);
            return new FormattedPlaceholder(expression, new PlainStringFormattedValue("{" + sigil + "}"));
        }
        if (annotation instanceof MFDataModel.FunctionAnnotation) {
            MFDataModel.FunctionAnnotation fa = (MFDataModel.FunctionAnnotation)annotation;
            if (functionName != null && !functionName.equals(fa.name)) {
                MFDataModelFormatter.formattingError("invalid function overrides, '" + functionName + "' <> '" + fa.name + "'");
            }
            functionName = fa.name;
            Map<String, Object> newOptions = MFDataModelFormatter.convertOptions(fa.options, variables, arguments2);
            options.putAll(newOptions);
        } else if (annotation instanceof MFDataModel.UnsupportedAnnotation) {
            return new FormattedPlaceholder(expression, new PlainStringFormattedValue(fallbackString));
        }
        FormatterFactory funcFactory = this.getFormattingFunctionFactoryByName(toFormat, functionName);
        if (funcFactory == null) {
            return new FormattedPlaceholder(expression, new PlainStringFormattedValue(fallbackString));
        }
        Formatter ff = funcFactory.createFormatter(this.locale, options);
        String res = ff.formatToString(toFormat, arguments2);
        if (res == null) {
            res = fallbackString;
        }
        ResolvedExpression resExpression = new ResolvedExpression(toFormat, functionName, options);
        return new FormattedPlaceholder(resExpression, new PlainStringFormattedValue(res));
    }

    private Map<String, Object> resolveDeclarations(List<MFDataModel.Declaration> declarations, Map<String, Object> arguments2) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (declarations != null) {
            for (MFDataModel.Declaration declaration : declarations) {
                MFDataModel.Expression value;
                String name;
                if (declaration instanceof MFDataModel.InputDeclaration) {
                    name = ((MFDataModel.InputDeclaration)declaration).name;
                    value = ((MFDataModel.InputDeclaration)declaration).value;
                } else {
                    if (!(declaration instanceof MFDataModel.LocalDeclaration)) continue;
                    name = ((MFDataModel.LocalDeclaration)declaration).name;
                    value = ((MFDataModel.LocalDeclaration)declaration).value;
                }
                try {
                    FormattedPlaceholder fmt = this.formatExpression(value, variables, arguments2);
                    variables.put(name, fmt);
                }
                catch (Exception exception) {}
            }
        }
        return variables;
    }

    private static class IntVarTuple {
        int integer;
        final MFDataModel.Variant variant;

        public IntVarTuple(int integer, MFDataModel.Variant variant) {
            this.integer = integer;
            this.variant = variant;
        }
    }

    static class ResolvedExpression
    implements MFDataModel.Expression {
        final Object argument;
        final String functionName;
        final Map<String, Object> options;

        public ResolvedExpression(Object argument, String functionName, Map<String, Object> options) {
            this.argument = argument;
            this.functionName = functionName;
            this.options = options;
        }
    }

    private static class ResolvedSelector {
        final Object argument;
        final Map<String, Object> options;
        final Selector selectorFunction;

        public ResolvedSelector(Object argument, Map<String, Object> options, Selector selectorFunction) {
            this.argument = argument;
            this.options = new HashMap<String, Object>(options);
            this.selectorFunction = selectorFunction;
        }
    }
}

