/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.Component;
import java.util.Vector;
import javax.swing.AbstractListModel;
import net.sf.juife.ComponentListModel;

public class DefaultComponentListModel<C extends Component>
extends AbstractListModel
implements ComponentListModel<C> {
    private final Vector<C> list = new Vector();
    private boolean componentListIsAdjusting = false;

    @Override
    public C get(int index) {
        return (C)((Component)this.list.get(index));
    }

    public Object getElementAt(int index) {
        return this.list.get(index);
    }

    @Override
    public void insert(C c, int index) {
        this.list.insertElementAt(c, index);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void add(C c) {
        int idx = this.list.size();
        this.list.add(c);
        this.fireIntervalAdded(this, idx, idx);
    }

    @Override
    public C set(int index, C c) {
        c = (Component)this.list.set(index, c);
        this.fireContentsChanged(this, index, index);
        return c;
    }

    @Override
    public void moveUp(C c) {
        int idx = this.indexOf(c);
        if (idx < 1) {
            return;
        }
        C c2 = this.get(idx - 1);
        this.list.set(idx, c2);
        this.list.set(idx - 1, c);
        this.fireContentsChanged(this, idx - 1, idx);
    }

    @Override
    public void moveDown(C c) {
        int idx = this.indexOf(c);
        if (idx == -1 || idx >= this.size() - 1) {
            return;
        }
        C c2 = this.get(idx + 1);
        this.list.set(idx, c2);
        this.list.set(idx + 1, c);
        this.fireContentsChanged(this, idx, idx + 1);
    }

    @Override
    public boolean remove(C c) {
        int idx = this.list.indexOf(c);
        boolean b = this.list.remove(c);
        if (idx >= 0) {
            this.fireIntervalRemoved(this, idx, idx);
        }
        return b;
    }

    @Override
    public C remove(int index) {
        Component c = (Component)this.list.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return (C)c;
    }

    @Override
    public boolean getComponentListIsAdjusting() {
        return this.componentListIsAdjusting;
    }

    @Override
    public void setComponentListIsAdjusting(boolean b) {
        this.componentListIsAdjusting = b;
    }

    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

