/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements pixel-wise generic operation on one image.


This class is parameterized over the type of the input image and the
type of the output image. It is also parameterized by the operation to
be applied, using a Functor style.

UnaryFunctorImageFilter allows the output dimension of the filter to be larger than the input
dimension. Thus subclasses of the UnaryFunctorImageFilter (like the CastImageFilter ) can be used to promote a 2D image to a 3D image, etc.


See:
 UnaryGeneratorImageFilter

 BinaryFunctorImageFilter TernaryFunctorImageFilter

 itk::simple::UnaryMinus for the procedural interface

 itk::UnaryFunctorImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkUnaryMinusImageFilter.h
*/
public class UnaryMinusImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected UnaryMinusImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.UnaryMinusImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(UnaryMinusImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(UnaryMinusImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::UnaryMinusImageFilter::~UnaryMinusImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_UnaryMinusImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::UnaryMinusImageFilter::UnaryMinusImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  UnaryMinusImageFilter() {
    this(SimpleITKJNI.new_UnaryMinusImageFilter(), true);
  }

  /**
std::string itk::simple::UnaryMinusImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.UnaryMinusImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::UnaryMinusImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.UnaryMinusImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::UnaryMinusImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.UnaryMinusImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
