/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes overlap measures between the set same set of labels of pixels
of two images. Background is assumed to be 0.


This code was contributed in the Insight Journal paper: "Introducing
Dice, Jaccard, and Other Label Overlap Measures To ITK" by Nicholas
J. Tustison, James C. Gee https://doi.org/10.54294/1vixgg


Nicholas J. Tustison

See:
 LabelOverlapMeasuresImageFilter

 itk::LabelOverlapMeasuresImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelOverlapMeasuresImageFilter.h
*/
public class LabelOverlapMeasuresImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelOverlapMeasuresImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelOverlapMeasuresImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelOverlapMeasuresImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelOverlapMeasuresImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelOverlapMeasuresImageFilter::~LabelOverlapMeasuresImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelOverlapMeasuresImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelOverlapMeasuresImageFilter::LabelOverlapMeasuresImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelOverlapMeasuresImageFilter() {
    this(SimpleITKJNI.new_LabelOverlapMeasuresImageFilter(), true);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetFalseNegativeError(int64_t label) const

Get the false negative error for the specified individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getFalseNegativeError() {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getFalseNegativeError__SWIG_0(swigCPtr, this);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetFalseNegativeError(int64_t label) const

Get the false negative error for the specified individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getFalseNegativeError(long label) {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getFalseNegativeError__SWIG_1(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetFalsePositiveError(int64_t label) const

Get the false positive error for the specified individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getFalsePositiveError() {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getFalsePositiveError__SWIG_0(swigCPtr, this);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetFalsePositiveError(int64_t label) const

Get the false positive error for the specified individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getFalsePositiveError(long label) {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getFalsePositiveError__SWIG_1(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetMeanOverlap(int64_t label) const

Get the mean overlap (Dice coefficient) for the specified individual
label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMeanOverlap() {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getMeanOverlap__SWIG_0(swigCPtr, this);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetMeanOverlap(int64_t label) const

Get the mean overlap (Dice coefficient) for the specified individual
label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMeanOverlap(long label) {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getMeanOverlap__SWIG_1(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetUnionOverlap(int64_t label) const

Get the union overlap (Jaccard coefficient) for the specified
individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getUnionOverlap() {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getUnionOverlap__SWIG_0(swigCPtr, this);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetUnionOverlap(int64_t label) const

Get the union overlap (Jaccard coefficient) for the specified
individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getUnionOverlap(long label) {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getUnionOverlap__SWIG_1(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetVolumeSimilarity(int64_t label) const

Get the volume similarity for the specified individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getVolumeSimilarity() {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getVolumeSimilarity__SWIG_0(swigCPtr, this);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetVolumeSimilarity(int64_t label) const

Get the volume similarity for the specified individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getVolumeSimilarity(long label) {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getVolumeSimilarity__SWIG_1(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetJaccardCoefficient(int64_t label) const

Get the union overlap (Jaccard coefficient) for the specified
individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getJaccardCoefficient() {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getJaccardCoefficient__SWIG_0(swigCPtr, this);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetJaccardCoefficient(int64_t label) const

Get the union overlap (Jaccard coefficient) for the specified
individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getJaccardCoefficient(long label) {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getJaccardCoefficient__SWIG_1(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetDiceCoefficient(int64_t label) const

Get the mean overlap (Dice coefficient) for the specified individual
label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getDiceCoefficient() {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getDiceCoefficient__SWIG_0(swigCPtr, this);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetDiceCoefficient(int64_t label) const

Get the mean overlap (Dice coefficient) for the specified individual
label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getDiceCoefficient(long label) {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getDiceCoefficient__SWIG_1(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetFalseDiscoveryRate(int64_t label) const

Get the false discovery rate for the specified individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getFalseDiscoveryRate() {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getFalseDiscoveryRate__SWIG_0(swigCPtr, this);
  }

  /**
double itk::simple::LabelOverlapMeasuresImageFilter::GetFalseDiscoveryRate(int64_t label) const

Get the false discovery rate for the specified individual label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getFalseDiscoveryRate(long label) {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getFalseDiscoveryRate__SWIG_1(swigCPtr, this, label);
  }

  /**
std::string itk::simple::LabelOverlapMeasuresImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelOverlapMeasuresImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelOverlapMeasuresImageFilter_toString(swigCPtr, this);
  }

  /**
void itk::simple::LabelOverlapMeasuresImageFilter::Execute(const Image &amp;sourceImage, const Image &amp;targetImage)

Execute the filter on the input image

*/
public  void execute(Image sourceImage, Image targetImage) {
    SimpleITKJNI.LabelOverlapMeasuresImageFilter_execute(swigCPtr, this, Image.getCPtr(sourceImage), sourceImage, Image.getCPtr(targetImage), targetImage);
  }

}
