/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Pad an image to make it suitable for an FFT transformation.


FFT filters usually requires a specific image size. The size is
decomposed in several prime factors, and the filter only supports
prime factors up to a maximum value. This filter automatically finds
the greatest prime factor required by the available implementation and
pads the input appropriately.

This code was adapted from the Insight Journal contribution:

"FFT Based Convolution" by Gaetan Lehmann https://doi.org/10.54294/0iky0u


Gaetan Lehmann

See:
 FFTShiftImageFilter

 itk::simple::FFTPad for the procedural interface

 itk::FFTPadImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFFTPadImageFilter.h
*/
public class FFTPadImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected FFTPadImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.FFTPadImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(FFTPadImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(FFTPadImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::FFTPadImageFilter::~FFTPadImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_FFTPadImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::FFTPadImageFilter::FFTPadImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  FFTPadImageFilter() {
    this(SimpleITKJNI.new_FFTPadImageFilter(), true);
  }

  /**
Self&amp; itk::simple::FFTPadImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public  void setBoundaryCondition(FFTPadImageFilter.BoundaryConditionType BoundaryCondition) {
    SimpleITKJNI.FFTPadImageFilter_setBoundaryCondition(swigCPtr, this, BoundaryCondition.swigValue());
  }

  /**
BoundaryConditionType itk::simple::FFTPadImageFilter::GetBoundaryCondition() const
*/
public  FFTPadImageFilter.BoundaryConditionType getBoundaryCondition() {
    return FFTPadImageFilter.BoundaryConditionType.swigToEnum(SimpleITKJNI.FFTPadImageFilter_getBoundaryCondition(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::FFTPadImageFilter::SetSizeGreatestPrimeFactor(int SizeGreatestPrimeFactor)

Set/Get the greatest prime factor allowed on the size of the padded
image. The filter increase the size of the image to reach a size with
the greatest prime factor smaller or equal to the specified value. The
default value is 5 for VNL, which is the greatest prime number for
which the FFT are precomputed in FFTW, and thus gives very good
performance. A greatest prime factor of 2 produce a size which is a
power of 2, and thus is suitable for vnl base fft filters. A greatest
prime factor of 1 or less - typically 0 - disable the extra padding.

*/
public  void setSizeGreatestPrimeFactor(int SizeGreatestPrimeFactor) {
    SimpleITKJNI.FFTPadImageFilter_setSizeGreatestPrimeFactor(swigCPtr, this, SizeGreatestPrimeFactor);
  }

  /**
int itk::simple::FFTPadImageFilter::GetSizeGreatestPrimeFactor() const

Set/Get the greatest prime factor allowed on the size of the padded
image. The filter increase the size of the image to reach a size with
the greatest prime factor smaller or equal to the specified value. The
default value is 5 for VNL, which is the greatest prime number for
which the FFT are precomputed in FFTW, and thus gives very good
performance. A greatest prime factor of 2 produce a size which is a
power of 2, and thus is suitable for vnl base fft filters. A greatest
prime factor of 1 or less - typically 0 - disable the extra padding.

*/
public  int getSizeGreatestPrimeFactor() {
    return SimpleITKJNI.FFTPadImageFilter_getSizeGreatestPrimeFactor(swigCPtr, this);
  }

  /**
std::string itk::simple::FFTPadImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.FFTPadImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::FFTPadImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.FFTPadImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::FFTPadImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.FFTPadImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  public static int defaultSizeGreatestPrimeFactor() {
    return SimpleITKJNI.FFTPadImageFilter_defaultSizeGreatestPrimeFactor();
  }

  public final static class BoundaryConditionType {
    public final static FFTPadImageFilter.BoundaryConditionType ZERO_PAD = new FFTPadImageFilter.BoundaryConditionType("ZERO_PAD");
    public final static FFTPadImageFilter.BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new FFTPadImageFilter.BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
    public final static FFTPadImageFilter.BoundaryConditionType PERIODIC_PAD = new FFTPadImageFilter.BoundaryConditionType("PERIODIC_PAD");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static BoundaryConditionType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + BoundaryConditionType.class + " with value " + swigValue);
    }

    private BoundaryConditionType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private BoundaryConditionType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private BoundaryConditionType(String swigName, BoundaryConditionType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static BoundaryConditionType[] swigValues = { ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
