/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

binary reconstruction by dilation of an image


Reconstruction by dilation operates on a "marker" image and a
"mask" image, and is defined as the dilation of the marker image
with respect to the mask image iterated until stability.

Geodesic morphology is described in Chapter 6.2 of Pierre Soille's
book "Morphological Image Analysis: Principles and Applications",
Second Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


See:
 MorphologyImageFilter , ReconstructionByDilationImageFilter , BinaryReconstructionByErosionImageFilter

 itk::simple::BinaryReconstructionByDilation for the procedural interface

 itk::BinaryReconstructionByDilationImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryReconstructionByDilationImageFilter.h
*/
public class BinaryReconstructionByDilationImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryReconstructionByDilationImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryReconstructionByDilationImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryReconstructionByDilationImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryReconstructionByDilationImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryReconstructionByDilationImageFilter::~BinaryReconstructionByDilationImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryReconstructionByDilationImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryReconstructionByDilationImageFilter::BinaryReconstructionByDilationImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryReconstructionByDilationImageFilter() {
    this(SimpleITKJNI.new_BinaryReconstructionByDilationImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryReconstructionByDilationImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.BinaryReconstructionByDilationImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::BinaryReconstructionByDilationImageFilter::GetBackgroundValue() const

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.BinaryReconstructionByDilationImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryReconstructionByDilationImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::max() .

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryReconstructionByDilationImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryReconstructionByDilationImageFilter::GetForegroundValue() const

Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::max() .

*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryReconstructionByDilationImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryReconstructionByDilationImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.BinaryReconstructionByDilationImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::BinaryReconstructionByDilationImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.BinaryReconstructionByDilationImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryReconstructionByDilationImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.BinaryReconstructionByDilationImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::BinaryReconstructionByDilationImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.BinaryReconstructionByDilationImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryReconstructionByDilationImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryReconstructionByDilationImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryReconstructionByDilationImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryReconstructionByDilationImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryReconstructionByDilationImageFilter::Execute(const Image &amp;markerImage, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image markerImage, Image maskImage) {
    return new Image(SimpleITKJNI.BinaryReconstructionByDilationImageFilter_execute(swigCPtr, this, Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage), true);
  }

}
