---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンNPMアクセストークンの公開'
---

## 説明 {#description}

レスポンス本文に、NPMアクセストークンのパターンに一致するコンテンツが含まれていることが確認されました。アクセストークンには、クラシックまたはグラニュールのいずれかがあり、どちらも権限のカスタマイズが可能です。権限によっては、このトークンへのアクセスを持つ悪意のある攻撃者が、パッケージとパッケージ情報を読み取りったり、新しいパッケージを作成して、それらを作成したアカウントで公開したりすることができます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

漏洩したキーに関するセキュリティインシデントの処理に関する一般的なガイダンスについては、GitLabドキュメントの[インターネットへの認証情報の公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。

UIからアクセストークンを失効するには、次の手順に従います:

- <https://www.npmjs.com/login>でNPMアカウントにサインインします
- 右上隅で、プロフィール画像を選択し、「アクセストークン」を選択します
- 識別されたトークンを見つけ、「削除」列の「x」を選択します
- プロンプトが表示されたら、ダイアログで「OK」を選択します

詳細については、[NPMのアクセストークンの失効に関するドキュメント](https://docs.npmjs.com/revoking-access-tokens)を参照してください。

## 詳細 {#details}

| ID | 集計 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.84 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
