/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSPropertyRule;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.PropertyDescriptorStyleDeclaration;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class PropertyRule
extends BaseCSSDeclarationRule
implements CSSPropertyRule {
    private static final long serialVersionUID = 1L;
    private String name = null;

    public PropertyRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)18, origin);
    }

    @Override
    PropertyDescriptorStyleDeclaration createStyleDeclaration(AbstractCSSStyleSheet parentSheet) {
        return new PropertyDescriptorStyleDeclaration(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) throws DOMException {
        this.name = name;
    }

    @Override
    public boolean inherits() {
        String inherits = this.getStyle().getPropertyValue("inherits").toLowerCase(Locale.ROOT);
        return !inherits.equals("false");
    }

    @Override
    public LexicalUnit getInitialValue() {
        LexicalValue lv = (LexicalValue)this.getStyle().getPropertyCSSValue("initial-value");
        return lv == null ? null : lv.getLexicalUnit();
    }

    @Override
    public CSSValueSyntax getSyntax() {
        CSSValueSyntax syn;
        StyleValue cssVal = this.getStyle().getPropertyCSSValue("syntax");
        if (cssVal == null || cssVal.getPrimitiveType() != CSSValue.Type.STRING) {
            return null;
        }
        String s = ((CSSTypedValue)((Object)cssVal)).getStringValue();
        try {
            syn = new SyntaxParser().parseSyntax(s);
        }
        catch (CSSException e) {
            return null;
        }
        return syn;
    }

    @Override
    public String getCssText() {
        PropertyDescriptorStyleDeclaration decl = (PropertyDescriptorStyleDeclaration)this.getStyle();
        if (decl.isValidDeclaration() && this.name != null) {
            StyleFormattingContext context = this.getStyleFormattingContext();
            context.setParentContext(this.getParentRule());
            BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
            try {
                this.writeCssText((SimpleWriter)sw, context);
            }
            catch (IOException e) {
                throw new DOMException(11, e.getMessage());
            }
            return sw.toString();
        }
        return "";
    }

    @Override
    public String getMinifiedCssText() {
        PropertyDescriptorStyleDeclaration decl = (PropertyDescriptorStyleDeclaration)this.getStyle();
        if (decl.isValidDeclaration() && this.name != null) {
            return "@property " + ParseHelper.escape(this.name) + " {" + this.getStyle().getMinifiedCssText() + '}';
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        PropertyDescriptorStyleDeclaration decl = (PropertyDescriptorStyleDeclaration)this.getStyle();
        if (decl.isValidDeclaration() && this.name != null) {
            context.startRule(wri, this.getPrecedingComments());
            wri.write((CharSequence)"@property ");
            wri.write((CharSequence)ParseHelper.escape(this.name));
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            context.startStyleDeclaration(wri);
            this.getStyle().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endStyleDeclaration(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri, this.getTrailingComments());
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        int idx = (cssText = cssText.trim()).indexOf(123);
        if (idx < 11) {
            throw new DOMException(12, "Bad property rule: " + cssText);
        }
        try {
            super.setCssText(cssText);
        }
        catch (DOMException e) {
            this.clear();
            throw e;
        }
        PropertyDescriptorStyleDeclaration decl = (PropertyDescriptorStyleDeclaration)this.getStyle();
        if (!decl.isValidDeclaration()) {
            this.clear();
            throw new DOMException(12, "Bad property rule: " + cssText);
        }
    }

    @Override
    void setRule(AbstractCSSRule copyMe) {
        super.setRule(copyMe);
        this.name = ((PropertyRule)copyMe).name;
        PropertyDescriptorStyleDeclaration decl = (PropertyDescriptorStyleDeclaration)this.getStyle();
        decl.updateValidity();
    }

    @Override
    void startAtRule(String name, String pseudoSelector) {
        if (!"property".equalsIgnoreCase(name)) {
            throw new DOMException(13, "Cannot set rule of type: " + name);
        }
        if (pseudoSelector == null) {
            throw new DOMException(12, "No property name.");
        }
        pseudoSelector = ParseHelper.parseIdent(pseudoSelector);
        this.setName(pseudoSelector);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getType();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyRule other = (PropertyRule)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public PropertyRule clone(AbstractCSSStyleSheet parentSheet) {
        PropertyRule rule = new PropertyRule(parentSheet, this.getOrigin());
        rule.setName(this.getName());
        PropertyDescriptorStyleDeclaration cloneStyle = (PropertyDescriptorStyleDeclaration)rule.getStyle();
        cloneStyle.addStyle((BaseCSSStyleDeclaration)this.getStyle());
        return rule;
    }
}

