/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.value.AbstractValue;
import io.sf.carte.echosvg.css.engine.value.ComponentValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.Objects;
import org.w3c.css.om.typed.CSSCounterValue;
import org.w3c.dom.DOMException;

abstract class AbstractCounterValue
extends ComponentValue
implements CSSCounterValue {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private Value listStyle = null;

    protected AbstractCounterValue() {
    }

    AbstractCounterValue(String identifier, Value listStyle) {
        this.identifier = identifier;
        this.listStyle = listStyle;
    }

    public String getName() {
        return this.identifier;
    }

    public void setName(String identifier) {
        this.identifier = identifier;
        if (this.handler != null) {
            this.handler.valueChanged(this);
        }
    }

    public Value getCounterStyle() {
        return this.listStyle;
    }

    void setCounterStyle(AbstractValue listStyle) {
        this.componentize(listStyle);
        this.listStyle = listStyle;
        if (this.handler != null) {
            this.handler.valueChanged(this);
        }
    }

    public String getSeparator() {
        return "";
    }

    @Override
    public Value item(int index) {
        if (index == 0) {
            return this.getCounterStyle();
        }
        return null;
    }

    void set(int index, Value component) throws DOMException {
        if (index == 0) {
            this.setCounterStyle((AbstractValue)component);
        }
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.listStyle == null ? this.decimalHashCode() : this.listStyle.hashCode());
        return result;
    }

    private int decimalHashCode() {
        int result = 31 * CSSValue.CssType.TYPED.hashCode() + CSSValue.Type.IDENT.hashCode();
        result = 31 * result + "decimal".hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCounterValue other = (AbstractCounterValue)obj;
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        return Objects.equals(this.listStyle, other.listStyle);
    }

    static void quoteSeparator(String separator, StringBuilder buf) {
        if (!separator.contains("'")) {
            buf.append('\'').append(separator).append('\'');
        } else {
            buf.append('\"').append(separator).append('\"');
        }
    }
}

