/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.ui.components.RenderedContent;
import org.freeplane.core.ui.components.RenderedContentSupplier;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;

public class ComboProperty
extends PropertyBean
implements IPropertyControl,
ActionListener {
    final JComboBox mComboBox;
    private Vector<String> possibleValues;

    public static Vector<Object> translate(String[] possibles) {
        Vector<Object> displayedItems = new Vector<Object>(possibles.length);
        for (int i = 0; i < possibles.length; ++i) {
            String alternativeKey = possibles[i];
            String alternativeText = TextUtils.getText(alternativeKey, null);
            String key = "OptionPanel." + alternativeKey;
            String text = alternativeText != null ? TextUtils.getText(key, alternativeText) : TextUtils.getText(key);
            displayedItems.add(text);
        }
        return displayedItems;
    }

    public ComboProperty(String name, Collection<String> possibles, Collection<?> displayedItems) {
        super(name);
        this.fillPossibleValues(possibles);
        this.mComboBox = JComboBoxFactory.create();
        this.mComboBox.setModel(new DefaultComboBoxModel(new Vector(displayedItems)));
        this.mComboBox.addActionListener(this);
    }

    public ComboProperty(String name, String[] strings) {
        this(name, Arrays.asList(strings), ComboProperty.translate(strings));
    }

    public static <T extends Enum<T>> ComboProperty of(String name, Class<T> enumClass) {
        return ComboProperty.of(name, enumClass, RenderedContent::of);
    }

    public static <T extends Enum<T>> ComboProperty of(String name, Class<T> enumClass, RenderedContentSupplier<T> supplier) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        Vector<String> choices = new Vector<String>(enumConstants.length);
        Vector<RenderedContent<Enum>> displayedItems = new Vector<RenderedContent<Enum>>(enumConstants.length);
        for (Enum enumValue : enumConstants) {
            String choice = enumValue.name();
            choices.add(choice);
            RenderedContent<Enum> renderedContent = supplier.createRenderedContent(enumValue);
            displayedItems.add(renderedContent);
        }
        ComboProperty comboProperty = new ComboProperty(name, choices, displayedItems);
        comboProperty.setRenderer(RenderedContent.createRenderer());
        return comboProperty;
    }

    private void fillPossibleValues(Collection<String> possibles) {
        this.possibleValues = new Vector();
        this.possibleValues.addAll(possibles);
    }

    @Override
    public String getValue() {
        if (this.mComboBox.getSelectedIndex() == -1) {
            return this.mComboBox.getSelectedItem().toString();
        }
        return this.possibleValues.get(this.mComboBox.getSelectedIndex());
    }

    @Override
    public JComponent getValueComponent() {
        return this.mComboBox;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        this.appendToForm(builder, this.mComboBox);
    }

    public Vector<String> getPossibleValues() {
        return this.possibleValues;
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mComboBox.setEnabled(pEnabled);
        super.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String value) {
        if (this.possibleValues.contains(value)) {
            this.mComboBox.setSelectedIndex(this.possibleValues.indexOf(value));
        } else if (this.mComboBox.isEditable()) {
            this.mComboBox.setSelectedItem(value);
        } else {
            LogUtils.severe("Can't set the value:" + value + " into the combo box " + this.getName() + " containing values " + this.possibleValues);
            if (this.mComboBox.getModel().getSize() > 0) {
                this.mComboBox.setSelectedIndex(0);
            }
        }
    }

    public void updateComboBoxEntries(List<String> possibles, List<?> displayedItems) {
        this.mComboBox.setModel(new DefaultComboBoxModel(new Vector(displayedItems)));
        this.fillPossibleValues(possibles);
        if (possibles.size() > 0) {
            this.mComboBox.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.firePropertyChangeEvent();
    }

    public void setEditable(boolean aFlag) {
        this.mComboBox.setEditable(aFlag);
    }

    public boolean isEditable() {
        return this.mComboBox.isEditable();
    }

    public void setRenderer(ListCellRenderer<?> renderer) {
        this.mComboBox.setRenderer(renderer);
    }
}

